// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptEulas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptEulasError {
    /// Kind of error that occurred.
    pub kind: AcceptEulasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptEulas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptEulasErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptEulasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptEulasErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AcceptEulasErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AcceptEulasErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            AcceptEulasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AcceptEulasErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            AcceptEulasErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AcceptEulasErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AcceptEulasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcceptEulasError {
    fn code(&self) -> Option<&str> {
        AcceptEulasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcceptEulasError {
    /// Creates a new `AcceptEulasError`.
    pub fn new(kind: AcceptEulasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptEulasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptEulasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptEulasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptEulasErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AcceptEulasErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, AcceptEulasErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `AcceptEulasErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, AcceptEulasErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `AcceptEulasErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptEulasErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `AcceptEulasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptEulasErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `AcceptEulasErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptEulasErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `AcceptEulasErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, AcceptEulasErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `AcceptEulasErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, AcceptEulasErrorKind::ValidationException(_))
    }
}
impl std::error::Error for AcceptEulasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptEulasErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AcceptEulasErrorKind::ConflictException(_inner) => Some(_inner),
            AcceptEulasErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            AcceptEulasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AcceptEulasErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            AcceptEulasErrorKind::ThrottlingException(_inner) => Some(_inner),
            AcceptEulasErrorKind::ValidationException(_inner) => Some(_inner),
            AcceptEulasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLaunchProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLaunchProfileError {
    /// Kind of error that occurred.
    pub kind: CreateLaunchProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLaunchProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLaunchProfileErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLaunchProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLaunchProfileErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateLaunchProfileErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateLaunchProfileErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateLaunchProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateLaunchProfileErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateLaunchProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateLaunchProfileErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateLaunchProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLaunchProfileError {
    fn code(&self) -> Option<&str> {
        CreateLaunchProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLaunchProfileError {
    /// Creates a new `CreateLaunchProfileError`.
    pub fn new(kind: CreateLaunchProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLaunchProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLaunchProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLaunchProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLaunchProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateLaunchProfileErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLaunchProfileErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateLaunchProfileErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLaunchProfileErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateLaunchProfileErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLaunchProfileErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateLaunchProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLaunchProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateLaunchProfileErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLaunchProfileErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateLaunchProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLaunchProfileErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `CreateLaunchProfileErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLaunchProfileErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateLaunchProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLaunchProfileErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateLaunchProfileErrorKind::ConflictException(_inner) => Some(_inner),
            CreateLaunchProfileErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateLaunchProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateLaunchProfileErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateLaunchProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateLaunchProfileErrorKind::ValidationException(_inner) => Some(_inner),
            CreateLaunchProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStreamingImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStreamingImageError {
    /// Kind of error that occurred.
    pub kind: CreateStreamingImageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStreamingImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStreamingImageErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStreamingImageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStreamingImageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateStreamingImageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateStreamingImageErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateStreamingImageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateStreamingImageErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateStreamingImageErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateStreamingImageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateStreamingImageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStreamingImageError {
    fn code(&self) -> Option<&str> {
        CreateStreamingImageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStreamingImageError {
    /// Creates a new `CreateStreamingImageError`.
    pub fn new(kind: CreateStreamingImageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStreamingImageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStreamingImageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStreamingImageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStreamingImageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateStreamingImageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingImageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamingImageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingImageErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamingImageErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingImageErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamingImageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingImageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamingImageErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingImageErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamingImageErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingImageErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamingImageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingImageErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateStreamingImageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStreamingImageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateStreamingImageErrorKind::ConflictException(_inner) => Some(_inner),
            CreateStreamingImageErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateStreamingImageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateStreamingImageErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateStreamingImageErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateStreamingImageErrorKind::ValidationException(_inner) => Some(_inner),
            CreateStreamingImageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStreamingSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStreamingSessionError {
    /// Kind of error that occurred.
    pub kind: CreateStreamingSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStreamingSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStreamingSessionErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStreamingSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStreamingSessionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateStreamingSessionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateStreamingSessionErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateStreamingSessionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateStreamingSessionErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateStreamingSessionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateStreamingSessionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateStreamingSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStreamingSessionError {
    fn code(&self) -> Option<&str> {
        CreateStreamingSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStreamingSessionError {
    /// Creates a new `CreateStreamingSessionError`.
    pub fn new(kind: CreateStreamingSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStreamingSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStreamingSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStreamingSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStreamingSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateStreamingSessionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingSessionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamingSessionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingSessionErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamingSessionErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingSessionErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamingSessionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingSessionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamingSessionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingSessionErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamingSessionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingSessionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamingSessionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingSessionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateStreamingSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStreamingSessionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateStreamingSessionErrorKind::ConflictException(_inner) => Some(_inner),
            CreateStreamingSessionErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateStreamingSessionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateStreamingSessionErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateStreamingSessionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateStreamingSessionErrorKind::ValidationException(_inner) => Some(_inner),
            CreateStreamingSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStreamingSessionStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStreamingSessionStreamError {
    /// Kind of error that occurred.
    pub kind: CreateStreamingSessionStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStreamingSessionStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStreamingSessionStreamErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStreamingSessionStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStreamingSessionStreamErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateStreamingSessionStreamErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateStreamingSessionStreamErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreateStreamingSessionStreamErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateStreamingSessionStreamErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateStreamingSessionStreamErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateStreamingSessionStreamErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateStreamingSessionStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStreamingSessionStreamError {
    fn code(&self) -> Option<&str> {
        CreateStreamingSessionStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStreamingSessionStreamError {
    /// Creates a new `CreateStreamingSessionStreamError`.
    pub fn new(kind: CreateStreamingSessionStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStreamingSessionStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStreamingSessionStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStreamingSessionStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStreamingSessionStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateStreamingSessionStreamErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingSessionStreamErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamingSessionStreamErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingSessionStreamErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamingSessionStreamErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingSessionStreamErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamingSessionStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingSessionStreamErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamingSessionStreamErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingSessionStreamErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamingSessionStreamErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingSessionStreamErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamingSessionStreamErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingSessionStreamErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateStreamingSessionStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStreamingSessionStreamErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateStreamingSessionStreamErrorKind::ConflictException(_inner) => Some(_inner),
            CreateStreamingSessionStreamErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            CreateStreamingSessionStreamErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateStreamingSessionStreamErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            CreateStreamingSessionStreamErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateStreamingSessionStreamErrorKind::ValidationException(_inner) => Some(_inner),
            CreateStreamingSessionStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStudio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStudioError {
    /// Kind of error that occurred.
    pub kind: CreateStudioErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStudio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStudioErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStudioError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStudioErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateStudioErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateStudioErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateStudioErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateStudioErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateStudioErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateStudioErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateStudioErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStudioError {
    fn code(&self) -> Option<&str> {
        CreateStudioError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStudioError {
    /// Creates a new `CreateStudioError`.
    pub fn new(kind: CreateStudioErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStudioError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStudioErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStudioError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStudioErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateStudioErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateStudioErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `CreateStudioErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateStudioErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateStudioErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStudioErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateStudioErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStudioErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateStudioErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStudioErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateStudioErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateStudioErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `CreateStudioErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateStudioErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateStudioError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStudioErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateStudioErrorKind::ConflictException(_inner) => Some(_inner),
            CreateStudioErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateStudioErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateStudioErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateStudioErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateStudioErrorKind::ValidationException(_inner) => Some(_inner),
            CreateStudioErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStudioComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStudioComponentError {
    /// Kind of error that occurred.
    pub kind: CreateStudioComponentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStudioComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStudioComponentErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStudioComponentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStudioComponentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateStudioComponentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateStudioComponentErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateStudioComponentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateStudioComponentErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateStudioComponentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateStudioComponentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateStudioComponentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStudioComponentError {
    fn code(&self) -> Option<&str> {
        CreateStudioComponentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStudioComponentError {
    /// Creates a new `CreateStudioComponentError`.
    pub fn new(kind: CreateStudioComponentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStudioComponentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStudioComponentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStudioComponentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStudioComponentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateStudioComponentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStudioComponentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateStudioComponentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStudioComponentErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateStudioComponentErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStudioComponentErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateStudioComponentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStudioComponentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateStudioComponentErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStudioComponentErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateStudioComponentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStudioComponentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `CreateStudioComponentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStudioComponentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateStudioComponentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStudioComponentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateStudioComponentErrorKind::ConflictException(_inner) => Some(_inner),
            CreateStudioComponentErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateStudioComponentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateStudioComponentErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateStudioComponentErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateStudioComponentErrorKind::ValidationException(_inner) => Some(_inner),
            CreateStudioComponentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLaunchProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLaunchProfileError {
    /// Kind of error that occurred.
    pub kind: DeleteLaunchProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLaunchProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLaunchProfileErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLaunchProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLaunchProfileErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteLaunchProfileErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteLaunchProfileErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteLaunchProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteLaunchProfileErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeleteLaunchProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteLaunchProfileErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteLaunchProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLaunchProfileError {
    fn code(&self) -> Option<&str> {
        DeleteLaunchProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLaunchProfileError {
    /// Creates a new `DeleteLaunchProfileError`.
    pub fn new(kind: DeleteLaunchProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLaunchProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLaunchProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLaunchProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLaunchProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteLaunchProfileErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLaunchProfileErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteLaunchProfileErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLaunchProfileErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteLaunchProfileErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLaunchProfileErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteLaunchProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLaunchProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteLaunchProfileErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLaunchProfileErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `DeleteLaunchProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLaunchProfileErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `DeleteLaunchProfileErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLaunchProfileErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteLaunchProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLaunchProfileErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteLaunchProfileErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteLaunchProfileErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteLaunchProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteLaunchProfileErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeleteLaunchProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteLaunchProfileErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteLaunchProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLaunchProfileMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLaunchProfileMemberError {
    /// Kind of error that occurred.
    pub kind: DeleteLaunchProfileMemberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLaunchProfileMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLaunchProfileMemberErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLaunchProfileMemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLaunchProfileMemberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteLaunchProfileMemberErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteLaunchProfileMemberErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLaunchProfileMemberErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteLaunchProfileMemberErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLaunchProfileMemberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteLaunchProfileMemberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteLaunchProfileMemberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLaunchProfileMemberError {
    fn code(&self) -> Option<&str> {
        DeleteLaunchProfileMemberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLaunchProfileMemberError {
    /// Creates a new `DeleteLaunchProfileMemberError`.
    pub fn new(kind: DeleteLaunchProfileMemberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLaunchProfileMemberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLaunchProfileMemberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLaunchProfileMemberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLaunchProfileMemberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteLaunchProfileMemberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLaunchProfileMemberErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteLaunchProfileMemberErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLaunchProfileMemberErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteLaunchProfileMemberErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLaunchProfileMemberErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteLaunchProfileMemberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLaunchProfileMemberErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteLaunchProfileMemberErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLaunchProfileMemberErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `DeleteLaunchProfileMemberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLaunchProfileMemberErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `DeleteLaunchProfileMemberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLaunchProfileMemberErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteLaunchProfileMemberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLaunchProfileMemberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteLaunchProfileMemberErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteLaunchProfileMemberErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DeleteLaunchProfileMemberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteLaunchProfileMemberErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            DeleteLaunchProfileMemberErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteLaunchProfileMemberErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteLaunchProfileMemberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStreamingImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStreamingImageError {
    /// Kind of error that occurred.
    pub kind: DeleteStreamingImageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStreamingImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStreamingImageErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStreamingImageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStreamingImageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteStreamingImageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteStreamingImageErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteStreamingImageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteStreamingImageErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeleteStreamingImageErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteStreamingImageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteStreamingImageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStreamingImageError {
    fn code(&self) -> Option<&str> {
        DeleteStreamingImageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStreamingImageError {
    /// Creates a new `DeleteStreamingImageError`.
    pub fn new(kind: DeleteStreamingImageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStreamingImageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStreamingImageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStreamingImageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStreamingImageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteStreamingImageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamingImageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStreamingImageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamingImageErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStreamingImageErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamingImageErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStreamingImageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamingImageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStreamingImageErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamingImageErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStreamingImageErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamingImageErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStreamingImageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamingImageErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteStreamingImageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStreamingImageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteStreamingImageErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteStreamingImageErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteStreamingImageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteStreamingImageErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeleteStreamingImageErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteStreamingImageErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteStreamingImageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStreamingSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStreamingSessionError {
    /// Kind of error that occurred.
    pub kind: DeleteStreamingSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStreamingSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStreamingSessionErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStreamingSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStreamingSessionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteStreamingSessionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteStreamingSessionErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteStreamingSessionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteStreamingSessionErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeleteStreamingSessionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteStreamingSessionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteStreamingSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStreamingSessionError {
    fn code(&self) -> Option<&str> {
        DeleteStreamingSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStreamingSessionError {
    /// Creates a new `DeleteStreamingSessionError`.
    pub fn new(kind: DeleteStreamingSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStreamingSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStreamingSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStreamingSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStreamingSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteStreamingSessionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamingSessionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStreamingSessionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamingSessionErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStreamingSessionErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamingSessionErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStreamingSessionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamingSessionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStreamingSessionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamingSessionErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStreamingSessionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamingSessionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStreamingSessionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamingSessionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteStreamingSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStreamingSessionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteStreamingSessionErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteStreamingSessionErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteStreamingSessionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteStreamingSessionErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeleteStreamingSessionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteStreamingSessionErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteStreamingSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStudio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStudioError {
    /// Kind of error that occurred.
    pub kind: DeleteStudioErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStudio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStudioErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStudioError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStudioErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteStudioErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteStudioErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteStudioErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteStudioErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeleteStudioErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteStudioErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteStudioErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStudioError {
    fn code(&self) -> Option<&str> {
        DeleteStudioError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStudioError {
    /// Creates a new `DeleteStudioError`.
    pub fn new(kind: DeleteStudioErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStudioError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStudioErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStudioError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStudioErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteStudioErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteStudioErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `DeleteStudioErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteStudioErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteStudioErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStudioErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStudioErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStudioErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteStudioErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `DeleteStudioErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteStudioErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteStudioError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStudioErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteStudioErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteStudioErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteStudioErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteStudioErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeleteStudioErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteStudioErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteStudioErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStudioComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStudioComponentError {
    /// Kind of error that occurred.
    pub kind: DeleteStudioComponentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStudioComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStudioComponentErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStudioComponentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStudioComponentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteStudioComponentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteStudioComponentErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteStudioComponentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteStudioComponentErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeleteStudioComponentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteStudioComponentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteStudioComponentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStudioComponentError {
    fn code(&self) -> Option<&str> {
        DeleteStudioComponentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStudioComponentError {
    /// Creates a new `DeleteStudioComponentError`.
    pub fn new(kind: DeleteStudioComponentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStudioComponentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStudioComponentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStudioComponentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStudioComponentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteStudioComponentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioComponentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStudioComponentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioComponentErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStudioComponentErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioComponentErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStudioComponentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioComponentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStudioComponentErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioComponentErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStudioComponentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioComponentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStudioComponentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioComponentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteStudioComponentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStudioComponentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteStudioComponentErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteStudioComponentErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteStudioComponentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteStudioComponentErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeleteStudioComponentErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteStudioComponentErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteStudioComponentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStudioMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStudioMemberError {
    /// Kind of error that occurred.
    pub kind: DeleteStudioMemberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStudioMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStudioMemberErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStudioMemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStudioMemberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteStudioMemberErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteStudioMemberErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteStudioMemberErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteStudioMemberErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeleteStudioMemberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteStudioMemberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteStudioMemberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStudioMemberError {
    fn code(&self) -> Option<&str> {
        DeleteStudioMemberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStudioMemberError {
    /// Creates a new `DeleteStudioMemberError`.
    pub fn new(kind: DeleteStudioMemberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStudioMemberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStudioMemberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStudioMemberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStudioMemberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteStudioMemberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioMemberErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStudioMemberErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioMemberErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStudioMemberErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioMemberErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStudioMemberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioMemberErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStudioMemberErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioMemberErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStudioMemberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioMemberErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStudioMemberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioMemberErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteStudioMemberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStudioMemberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteStudioMemberErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteStudioMemberErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteStudioMemberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteStudioMemberErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeleteStudioMemberErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteStudioMemberErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteStudioMemberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEula` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEulaError {
    /// Kind of error that occurred.
    pub kind: GetEulaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEula` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEulaErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEulaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEulaErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetEulaErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetEulaErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetEulaErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetEulaErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetEulaErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetEulaErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetEulaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEulaError {
    fn code(&self) -> Option<&str> {
        GetEulaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEulaError {
    /// Creates a new `GetEulaError`.
    pub fn new(kind: GetEulaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEulaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEulaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEulaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEulaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetEulaErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetEulaErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetEulaErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetEulaErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `GetEulaErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEulaErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetEulaErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetEulaErrorKind::ResourceNotFoundException(_))
    }
    /// Returns true if the error kind is `GetEulaErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEulaErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetEulaErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetEulaErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `GetEulaErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetEulaErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetEulaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEulaErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetEulaErrorKind::ConflictException(_inner) => Some(_inner),
            GetEulaErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetEulaErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetEulaErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetEulaErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetEulaErrorKind::ValidationException(_inner) => Some(_inner),
            GetEulaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLaunchProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLaunchProfileError {
    /// Kind of error that occurred.
    pub kind: GetLaunchProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLaunchProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLaunchProfileErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLaunchProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLaunchProfileErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLaunchProfileErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetLaunchProfileErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetLaunchProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetLaunchProfileErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetLaunchProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetLaunchProfileErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetLaunchProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLaunchProfileError {
    fn code(&self) -> Option<&str> {
        GetLaunchProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLaunchProfileError {
    /// Creates a new `GetLaunchProfileError`.
    pub fn new(kind: GetLaunchProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLaunchProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLaunchProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLaunchProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLaunchProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetLaunchProfileErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetLaunchProfileErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `GetLaunchProfileErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetLaunchProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLaunchProfileErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLaunchProfileErrorKind::ConflictException(_inner) => Some(_inner),
            GetLaunchProfileErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetLaunchProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLaunchProfileErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetLaunchProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetLaunchProfileErrorKind::ValidationException(_inner) => Some(_inner),
            GetLaunchProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLaunchProfileDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLaunchProfileDetailsError {
    /// Kind of error that occurred.
    pub kind: GetLaunchProfileDetailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLaunchProfileDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLaunchProfileDetailsErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLaunchProfileDetailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLaunchProfileDetailsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLaunchProfileDetailsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetLaunchProfileDetailsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetLaunchProfileDetailsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetLaunchProfileDetailsErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetLaunchProfileDetailsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetLaunchProfileDetailsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetLaunchProfileDetailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLaunchProfileDetailsError {
    fn code(&self) -> Option<&str> {
        GetLaunchProfileDetailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLaunchProfileDetailsError {
    /// Creates a new `GetLaunchProfileDetailsError`.
    pub fn new(kind: GetLaunchProfileDetailsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLaunchProfileDetailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLaunchProfileDetailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLaunchProfileDetailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLaunchProfileDetailsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetLaunchProfileDetailsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileDetailsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileDetailsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileDetailsErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileDetailsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileDetailsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileDetailsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileDetailsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileDetailsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileDetailsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileDetailsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileDetailsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileDetailsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileDetailsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetLaunchProfileDetailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLaunchProfileDetailsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLaunchProfileDetailsErrorKind::ConflictException(_inner) => Some(_inner),
            GetLaunchProfileDetailsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetLaunchProfileDetailsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLaunchProfileDetailsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetLaunchProfileDetailsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetLaunchProfileDetailsErrorKind::ValidationException(_inner) => Some(_inner),
            GetLaunchProfileDetailsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLaunchProfileInitialization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLaunchProfileInitializationError {
    /// Kind of error that occurred.
    pub kind: GetLaunchProfileInitializationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLaunchProfileInitialization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLaunchProfileInitializationErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLaunchProfileInitializationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLaunchProfileInitializationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLaunchProfileInitializationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetLaunchProfileInitializationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            GetLaunchProfileInitializationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetLaunchProfileInitializationErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetLaunchProfileInitializationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetLaunchProfileInitializationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetLaunchProfileInitializationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLaunchProfileInitializationError {
    fn code(&self) -> Option<&str> {
        GetLaunchProfileInitializationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLaunchProfileInitializationError {
    /// Creates a new `GetLaunchProfileInitializationError`.
    pub fn new(
        kind: GetLaunchProfileInitializationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLaunchProfileInitializationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLaunchProfileInitializationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLaunchProfileInitializationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLaunchProfileInitializationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetLaunchProfileInitializationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileInitializationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileInitializationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileInitializationErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileInitializationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileInitializationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileInitializationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileInitializationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileInitializationErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileInitializationErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileInitializationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileInitializationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileInitializationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileInitializationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetLaunchProfileInitializationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLaunchProfileInitializationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLaunchProfileInitializationErrorKind::ConflictException(_inner) => Some(_inner),
            GetLaunchProfileInitializationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            GetLaunchProfileInitializationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetLaunchProfileInitializationErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            GetLaunchProfileInitializationErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetLaunchProfileInitializationErrorKind::ValidationException(_inner) => Some(_inner),
            GetLaunchProfileInitializationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLaunchProfileMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLaunchProfileMemberError {
    /// Kind of error that occurred.
    pub kind: GetLaunchProfileMemberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLaunchProfileMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLaunchProfileMemberErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLaunchProfileMemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLaunchProfileMemberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLaunchProfileMemberErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetLaunchProfileMemberErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetLaunchProfileMemberErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetLaunchProfileMemberErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetLaunchProfileMemberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetLaunchProfileMemberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetLaunchProfileMemberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLaunchProfileMemberError {
    fn code(&self) -> Option<&str> {
        GetLaunchProfileMemberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLaunchProfileMemberError {
    /// Creates a new `GetLaunchProfileMemberError`.
    pub fn new(kind: GetLaunchProfileMemberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLaunchProfileMemberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLaunchProfileMemberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLaunchProfileMemberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLaunchProfileMemberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetLaunchProfileMemberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileMemberErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileMemberErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileMemberErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileMemberErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileMemberErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileMemberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileMemberErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileMemberErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileMemberErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileMemberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileMemberErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `GetLaunchProfileMemberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchProfileMemberErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetLaunchProfileMemberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLaunchProfileMemberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLaunchProfileMemberErrorKind::ConflictException(_inner) => Some(_inner),
            GetLaunchProfileMemberErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetLaunchProfileMemberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLaunchProfileMemberErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetLaunchProfileMemberErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetLaunchProfileMemberErrorKind::ValidationException(_inner) => Some(_inner),
            GetLaunchProfileMemberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStreamingImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStreamingImageError {
    /// Kind of error that occurred.
    pub kind: GetStreamingImageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStreamingImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStreamingImageErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStreamingImageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStreamingImageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetStreamingImageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetStreamingImageErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetStreamingImageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetStreamingImageErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetStreamingImageErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetStreamingImageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetStreamingImageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStreamingImageError {
    fn code(&self) -> Option<&str> {
        GetStreamingImageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStreamingImageError {
    /// Creates a new `GetStreamingImageError`.
    pub fn new(kind: GetStreamingImageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStreamingImageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStreamingImageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStreamingImageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStreamingImageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetStreamingImageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingImageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetStreamingImageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetStreamingImageErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `GetStreamingImageErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingImageErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetStreamingImageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingImageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetStreamingImageErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingImageErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetStreamingImageErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingImageErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `GetStreamingImageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingImageErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetStreamingImageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStreamingImageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetStreamingImageErrorKind::ConflictException(_inner) => Some(_inner),
            GetStreamingImageErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetStreamingImageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetStreamingImageErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetStreamingImageErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetStreamingImageErrorKind::ValidationException(_inner) => Some(_inner),
            GetStreamingImageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStreamingSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStreamingSessionError {
    /// Kind of error that occurred.
    pub kind: GetStreamingSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStreamingSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStreamingSessionErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStreamingSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStreamingSessionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetStreamingSessionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetStreamingSessionErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetStreamingSessionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetStreamingSessionErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetStreamingSessionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetStreamingSessionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetStreamingSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStreamingSessionError {
    fn code(&self) -> Option<&str> {
        GetStreamingSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStreamingSessionError {
    /// Creates a new `GetStreamingSessionError`.
    pub fn new(kind: GetStreamingSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStreamingSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStreamingSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStreamingSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStreamingSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetStreamingSessionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingSessionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetStreamingSessionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingSessionErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `GetStreamingSessionErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingSessionErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetStreamingSessionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingSessionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetStreamingSessionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingSessionErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetStreamingSessionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingSessionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `GetStreamingSessionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingSessionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetStreamingSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStreamingSessionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetStreamingSessionErrorKind::ConflictException(_inner) => Some(_inner),
            GetStreamingSessionErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetStreamingSessionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetStreamingSessionErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetStreamingSessionErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetStreamingSessionErrorKind::ValidationException(_inner) => Some(_inner),
            GetStreamingSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStreamingSessionStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStreamingSessionStreamError {
    /// Kind of error that occurred.
    pub kind: GetStreamingSessionStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStreamingSessionStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStreamingSessionStreamErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStreamingSessionStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStreamingSessionStreamErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetStreamingSessionStreamErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetStreamingSessionStreamErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            GetStreamingSessionStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetStreamingSessionStreamErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetStreamingSessionStreamErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetStreamingSessionStreamErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetStreamingSessionStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStreamingSessionStreamError {
    fn code(&self) -> Option<&str> {
        GetStreamingSessionStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStreamingSessionStreamError {
    /// Creates a new `GetStreamingSessionStreamError`.
    pub fn new(kind: GetStreamingSessionStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStreamingSessionStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStreamingSessionStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStreamingSessionStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStreamingSessionStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetStreamingSessionStreamErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingSessionStreamErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetStreamingSessionStreamErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingSessionStreamErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `GetStreamingSessionStreamErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingSessionStreamErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetStreamingSessionStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingSessionStreamErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetStreamingSessionStreamErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingSessionStreamErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetStreamingSessionStreamErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingSessionStreamErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `GetStreamingSessionStreamErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingSessionStreamErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetStreamingSessionStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStreamingSessionStreamErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetStreamingSessionStreamErrorKind::ConflictException(_inner) => Some(_inner),
            GetStreamingSessionStreamErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            GetStreamingSessionStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetStreamingSessionStreamErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            GetStreamingSessionStreamErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetStreamingSessionStreamErrorKind::ValidationException(_inner) => Some(_inner),
            GetStreamingSessionStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStudio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStudioError {
    /// Kind of error that occurred.
    pub kind: GetStudioErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStudio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStudioErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStudioError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStudioErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetStudioErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetStudioErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetStudioErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetStudioErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetStudioErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetStudioErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetStudioErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStudioError {
    fn code(&self) -> Option<&str> {
        GetStudioError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStudioError {
    /// Creates a new `GetStudioError`.
    pub fn new(kind: GetStudioErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStudioError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStudioErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStudioError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStudioErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetStudioErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetStudioErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetStudioErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetStudioErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `GetStudioErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStudioErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetStudioErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetStudioErrorKind::ResourceNotFoundException(_))
    }
    /// Returns true if the error kind is `GetStudioErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStudioErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetStudioErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetStudioErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `GetStudioErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetStudioErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetStudioError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStudioErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetStudioErrorKind::ConflictException(_inner) => Some(_inner),
            GetStudioErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetStudioErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetStudioErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetStudioErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetStudioErrorKind::ValidationException(_inner) => Some(_inner),
            GetStudioErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStudioComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStudioComponentError {
    /// Kind of error that occurred.
    pub kind: GetStudioComponentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStudioComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStudioComponentErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStudioComponentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStudioComponentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetStudioComponentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetStudioComponentErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetStudioComponentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetStudioComponentErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetStudioComponentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetStudioComponentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetStudioComponentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStudioComponentError {
    fn code(&self) -> Option<&str> {
        GetStudioComponentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStudioComponentError {
    /// Creates a new `GetStudioComponentError`.
    pub fn new(kind: GetStudioComponentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStudioComponentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStudioComponentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStudioComponentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStudioComponentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetStudioComponentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStudioComponentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetStudioComponentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStudioComponentErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `GetStudioComponentErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStudioComponentErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetStudioComponentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStudioComponentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetStudioComponentErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStudioComponentErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetStudioComponentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStudioComponentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `GetStudioComponentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStudioComponentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetStudioComponentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStudioComponentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetStudioComponentErrorKind::ConflictException(_inner) => Some(_inner),
            GetStudioComponentErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetStudioComponentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetStudioComponentErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetStudioComponentErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetStudioComponentErrorKind::ValidationException(_inner) => Some(_inner),
            GetStudioComponentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStudioMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStudioMemberError {
    /// Kind of error that occurred.
    pub kind: GetStudioMemberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStudioMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStudioMemberErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStudioMemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStudioMemberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetStudioMemberErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetStudioMemberErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetStudioMemberErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetStudioMemberErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetStudioMemberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetStudioMemberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetStudioMemberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStudioMemberError {
    fn code(&self) -> Option<&str> {
        GetStudioMemberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStudioMemberError {
    /// Creates a new `GetStudioMemberError`.
    pub fn new(kind: GetStudioMemberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStudioMemberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStudioMemberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStudioMemberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStudioMemberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetStudioMemberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStudioMemberErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetStudioMemberErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetStudioMemberErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `GetStudioMemberErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStudioMemberErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetStudioMemberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStudioMemberErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetStudioMemberErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStudioMemberErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetStudioMemberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetStudioMemberErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `GetStudioMemberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetStudioMemberErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetStudioMemberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStudioMemberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetStudioMemberErrorKind::ConflictException(_inner) => Some(_inner),
            GetStudioMemberErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetStudioMemberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetStudioMemberErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetStudioMemberErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetStudioMemberErrorKind::ValidationException(_inner) => Some(_inner),
            GetStudioMemberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEulaAcceptances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEulaAcceptancesError {
    /// Kind of error that occurred.
    pub kind: ListEulaAcceptancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEulaAcceptances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEulaAcceptancesErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEulaAcceptancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEulaAcceptancesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListEulaAcceptancesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListEulaAcceptancesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListEulaAcceptancesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListEulaAcceptancesErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListEulaAcceptancesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListEulaAcceptancesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListEulaAcceptancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEulaAcceptancesError {
    fn code(&self) -> Option<&str> {
        ListEulaAcceptancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEulaAcceptancesError {
    /// Creates a new `ListEulaAcceptancesError`.
    pub fn new(kind: ListEulaAcceptancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEulaAcceptancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEulaAcceptancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEulaAcceptancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEulaAcceptancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListEulaAcceptancesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEulaAcceptancesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListEulaAcceptancesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEulaAcceptancesErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListEulaAcceptancesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEulaAcceptancesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListEulaAcceptancesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEulaAcceptancesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListEulaAcceptancesErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEulaAcceptancesErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListEulaAcceptancesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEulaAcceptancesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `ListEulaAcceptancesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEulaAcceptancesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListEulaAcceptancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEulaAcceptancesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListEulaAcceptancesErrorKind::ConflictException(_inner) => Some(_inner),
            ListEulaAcceptancesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListEulaAcceptancesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListEulaAcceptancesErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListEulaAcceptancesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListEulaAcceptancesErrorKind::ValidationException(_inner) => Some(_inner),
            ListEulaAcceptancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEulas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEulasError {
    /// Kind of error that occurred.
    pub kind: ListEulasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEulas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEulasErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEulasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEulasErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListEulasErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListEulasErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListEulasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListEulasErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListEulasErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListEulasErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListEulasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEulasError {
    fn code(&self) -> Option<&str> {
        ListEulasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEulasError {
    /// Creates a new `ListEulasError`.
    pub fn new(kind: ListEulasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEulasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEulasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEulasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEulasErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListEulasErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListEulasErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `ListEulasErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListEulasErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `ListEulasErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEulasErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListEulasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListEulasErrorKind::ResourceNotFoundException(_))
    }
    /// Returns true if the error kind is `ListEulasErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEulasErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListEulasErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListEulasErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `ListEulasErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListEulasErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListEulasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEulasErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListEulasErrorKind::ConflictException(_inner) => Some(_inner),
            ListEulasErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListEulasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListEulasErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListEulasErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListEulasErrorKind::ValidationException(_inner) => Some(_inner),
            ListEulasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLaunchProfileMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLaunchProfileMembersError {
    /// Kind of error that occurred.
    pub kind: ListLaunchProfileMembersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLaunchProfileMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLaunchProfileMembersErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLaunchProfileMembersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLaunchProfileMembersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListLaunchProfileMembersErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListLaunchProfileMembersErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListLaunchProfileMembersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListLaunchProfileMembersErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            ListLaunchProfileMembersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListLaunchProfileMembersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListLaunchProfileMembersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLaunchProfileMembersError {
    fn code(&self) -> Option<&str> {
        ListLaunchProfileMembersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLaunchProfileMembersError {
    /// Creates a new `ListLaunchProfileMembersError`.
    pub fn new(kind: ListLaunchProfileMembersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLaunchProfileMembersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLaunchProfileMembersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLaunchProfileMembersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLaunchProfileMembersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListLaunchProfileMembersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLaunchProfileMembersErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListLaunchProfileMembersErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLaunchProfileMembersErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListLaunchProfileMembersErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLaunchProfileMembersErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListLaunchProfileMembersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLaunchProfileMembersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListLaunchProfileMembersErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLaunchProfileMembersErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListLaunchProfileMembersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLaunchProfileMembersErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `ListLaunchProfileMembersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLaunchProfileMembersErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListLaunchProfileMembersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLaunchProfileMembersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListLaunchProfileMembersErrorKind::ConflictException(_inner) => Some(_inner),
            ListLaunchProfileMembersErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListLaunchProfileMembersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListLaunchProfileMembersErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            ListLaunchProfileMembersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListLaunchProfileMembersErrorKind::ValidationException(_inner) => Some(_inner),
            ListLaunchProfileMembersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLaunchProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLaunchProfilesError {
    /// Kind of error that occurred.
    pub kind: ListLaunchProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLaunchProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLaunchProfilesErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLaunchProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLaunchProfilesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListLaunchProfilesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListLaunchProfilesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListLaunchProfilesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListLaunchProfilesErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListLaunchProfilesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListLaunchProfilesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListLaunchProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLaunchProfilesError {
    fn code(&self) -> Option<&str> {
        ListLaunchProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLaunchProfilesError {
    /// Creates a new `ListLaunchProfilesError`.
    pub fn new(kind: ListLaunchProfilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLaunchProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLaunchProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLaunchProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLaunchProfilesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListLaunchProfilesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLaunchProfilesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListLaunchProfilesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLaunchProfilesErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListLaunchProfilesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLaunchProfilesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListLaunchProfilesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLaunchProfilesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListLaunchProfilesErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLaunchProfilesErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListLaunchProfilesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLaunchProfilesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `ListLaunchProfilesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLaunchProfilesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListLaunchProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLaunchProfilesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListLaunchProfilesErrorKind::ConflictException(_inner) => Some(_inner),
            ListLaunchProfilesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListLaunchProfilesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListLaunchProfilesErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListLaunchProfilesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListLaunchProfilesErrorKind::ValidationException(_inner) => Some(_inner),
            ListLaunchProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStreamingImages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStreamingImagesError {
    /// Kind of error that occurred.
    pub kind: ListStreamingImagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStreamingImages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStreamingImagesErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStreamingImagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStreamingImagesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListStreamingImagesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListStreamingImagesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListStreamingImagesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListStreamingImagesErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListStreamingImagesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListStreamingImagesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListStreamingImagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStreamingImagesError {
    fn code(&self) -> Option<&str> {
        ListStreamingImagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStreamingImagesError {
    /// Creates a new `ListStreamingImagesError`.
    pub fn new(kind: ListStreamingImagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStreamingImagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStreamingImagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStreamingImagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStreamingImagesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListStreamingImagesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamingImagesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListStreamingImagesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamingImagesErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListStreamingImagesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamingImagesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListStreamingImagesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamingImagesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListStreamingImagesErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamingImagesErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListStreamingImagesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamingImagesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `ListStreamingImagesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamingImagesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListStreamingImagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStreamingImagesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListStreamingImagesErrorKind::ConflictException(_inner) => Some(_inner),
            ListStreamingImagesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListStreamingImagesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListStreamingImagesErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListStreamingImagesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListStreamingImagesErrorKind::ValidationException(_inner) => Some(_inner),
            ListStreamingImagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStreamingSessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStreamingSessionsError {
    /// Kind of error that occurred.
    pub kind: ListStreamingSessionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStreamingSessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStreamingSessionsErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStreamingSessionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStreamingSessionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListStreamingSessionsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListStreamingSessionsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListStreamingSessionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListStreamingSessionsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListStreamingSessionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListStreamingSessionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListStreamingSessionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStreamingSessionsError {
    fn code(&self) -> Option<&str> {
        ListStreamingSessionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStreamingSessionsError {
    /// Creates a new `ListStreamingSessionsError`.
    pub fn new(kind: ListStreamingSessionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStreamingSessionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStreamingSessionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStreamingSessionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStreamingSessionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListStreamingSessionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamingSessionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListStreamingSessionsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamingSessionsErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListStreamingSessionsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamingSessionsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListStreamingSessionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamingSessionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListStreamingSessionsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamingSessionsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListStreamingSessionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamingSessionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `ListStreamingSessionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamingSessionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListStreamingSessionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStreamingSessionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListStreamingSessionsErrorKind::ConflictException(_inner) => Some(_inner),
            ListStreamingSessionsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListStreamingSessionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListStreamingSessionsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListStreamingSessionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListStreamingSessionsErrorKind::ValidationException(_inner) => Some(_inner),
            ListStreamingSessionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStudioComponents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStudioComponentsError {
    /// Kind of error that occurred.
    pub kind: ListStudioComponentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStudioComponents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStudioComponentsErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStudioComponentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStudioComponentsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListStudioComponentsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListStudioComponentsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListStudioComponentsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListStudioComponentsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListStudioComponentsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListStudioComponentsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListStudioComponentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStudioComponentsError {
    fn code(&self) -> Option<&str> {
        ListStudioComponentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStudioComponentsError {
    /// Creates a new `ListStudioComponentsError`.
    pub fn new(kind: ListStudioComponentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStudioComponentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStudioComponentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStudioComponentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStudioComponentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListStudioComponentsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStudioComponentsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListStudioComponentsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStudioComponentsErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListStudioComponentsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStudioComponentsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListStudioComponentsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStudioComponentsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListStudioComponentsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStudioComponentsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListStudioComponentsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStudioComponentsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `ListStudioComponentsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStudioComponentsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListStudioComponentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStudioComponentsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListStudioComponentsErrorKind::ConflictException(_inner) => Some(_inner),
            ListStudioComponentsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListStudioComponentsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListStudioComponentsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListStudioComponentsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListStudioComponentsErrorKind::ValidationException(_inner) => Some(_inner),
            ListStudioComponentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStudioMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStudioMembersError {
    /// Kind of error that occurred.
    pub kind: ListStudioMembersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStudioMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStudioMembersErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStudioMembersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStudioMembersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListStudioMembersErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListStudioMembersErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListStudioMembersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListStudioMembersErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListStudioMembersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListStudioMembersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListStudioMembersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStudioMembersError {
    fn code(&self) -> Option<&str> {
        ListStudioMembersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStudioMembersError {
    /// Creates a new `ListStudioMembersError`.
    pub fn new(kind: ListStudioMembersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStudioMembersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStudioMembersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStudioMembersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStudioMembersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListStudioMembersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStudioMembersErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListStudioMembersErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListStudioMembersErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `ListStudioMembersErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStudioMembersErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListStudioMembersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStudioMembersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListStudioMembersErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStudioMembersErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListStudioMembersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStudioMembersErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `ListStudioMembersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStudioMembersErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListStudioMembersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStudioMembersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListStudioMembersErrorKind::ConflictException(_inner) => Some(_inner),
            ListStudioMembersErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListStudioMembersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListStudioMembersErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListStudioMembersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListStudioMembersErrorKind::ValidationException(_inner) => Some(_inner),
            ListStudioMembersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStudios` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStudiosError {
    /// Kind of error that occurred.
    pub kind: ListStudiosErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStudios` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStudiosErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStudiosError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStudiosErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListStudiosErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListStudiosErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListStudiosErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListStudiosErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListStudiosErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListStudiosErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListStudiosErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStudiosError {
    fn code(&self) -> Option<&str> {
        ListStudiosError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStudiosError {
    /// Creates a new `ListStudiosError`.
    pub fn new(kind: ListStudiosErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStudiosError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStudiosErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStudiosError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStudiosErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListStudiosErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListStudiosErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `ListStudiosErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListStudiosErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `ListStudiosErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStudiosErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListStudiosErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStudiosErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListStudiosErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStudiosErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListStudiosErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListStudiosErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `ListStudiosErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListStudiosErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListStudiosError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStudiosErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListStudiosErrorKind::ConflictException(_inner) => Some(_inner),
            ListStudiosErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListStudiosErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListStudiosErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListStudiosErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListStudiosErrorKind::ValidationException(_inner) => Some(_inner),
            ListStudiosErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ConflictException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutLaunchProfileMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutLaunchProfileMembersError {
    /// Kind of error that occurred.
    pub kind: PutLaunchProfileMembersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutLaunchProfileMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutLaunchProfileMembersErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutLaunchProfileMembersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutLaunchProfileMembersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutLaunchProfileMembersErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutLaunchProfileMembersErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            PutLaunchProfileMembersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutLaunchProfileMembersErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            PutLaunchProfileMembersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutLaunchProfileMembersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutLaunchProfileMembersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutLaunchProfileMembersError {
    fn code(&self) -> Option<&str> {
        PutLaunchProfileMembersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutLaunchProfileMembersError {
    /// Creates a new `PutLaunchProfileMembersError`.
    pub fn new(kind: PutLaunchProfileMembersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutLaunchProfileMembersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutLaunchProfileMembersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutLaunchProfileMembersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutLaunchProfileMembersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutLaunchProfileMembersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLaunchProfileMembersErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `PutLaunchProfileMembersErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLaunchProfileMembersErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `PutLaunchProfileMembersErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLaunchProfileMembersErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `PutLaunchProfileMembersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLaunchProfileMembersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PutLaunchProfileMembersErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLaunchProfileMembersErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `PutLaunchProfileMembersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLaunchProfileMembersErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `PutLaunchProfileMembersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLaunchProfileMembersErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutLaunchProfileMembersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutLaunchProfileMembersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutLaunchProfileMembersErrorKind::ConflictException(_inner) => Some(_inner),
            PutLaunchProfileMembersErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            PutLaunchProfileMembersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutLaunchProfileMembersErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            PutLaunchProfileMembersErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutLaunchProfileMembersErrorKind::ValidationException(_inner) => Some(_inner),
            PutLaunchProfileMembersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutStudioMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutStudioMembersError {
    /// Kind of error that occurred.
    pub kind: PutStudioMembersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutStudioMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutStudioMembersErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutStudioMembersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutStudioMembersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutStudioMembersErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutStudioMembersErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            PutStudioMembersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutStudioMembersErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            PutStudioMembersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutStudioMembersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutStudioMembersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutStudioMembersError {
    fn code(&self) -> Option<&str> {
        PutStudioMembersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutStudioMembersError {
    /// Creates a new `PutStudioMembersError`.
    pub fn new(kind: PutStudioMembersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutStudioMembersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutStudioMembersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutStudioMembersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutStudioMembersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutStudioMembersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutStudioMembersErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `PutStudioMembersErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutStudioMembersErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `PutStudioMembersErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutStudioMembersErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `PutStudioMembersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutStudioMembersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PutStudioMembersErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutStudioMembersErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `PutStudioMembersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutStudioMembersErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `PutStudioMembersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutStudioMembersErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutStudioMembersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutStudioMembersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutStudioMembersErrorKind::ConflictException(_inner) => Some(_inner),
            PutStudioMembersErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            PutStudioMembersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutStudioMembersErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            PutStudioMembersErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutStudioMembersErrorKind::ValidationException(_inner) => Some(_inner),
            PutStudioMembersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartStudioSSOConfigurationRepair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartStudioSSOConfigurationRepairError {
    /// Kind of error that occurred.
    pub kind: StartStudioSSOConfigurationRepairErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartStudioSSOConfigurationRepair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartStudioSSOConfigurationRepairErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartStudioSSOConfigurationRepairError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartStudioSSOConfigurationRepairErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            StartStudioSSOConfigurationRepairErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartStudioSSOConfigurationRepairErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            StartStudioSSOConfigurationRepairErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            StartStudioSSOConfigurationRepairErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            StartStudioSSOConfigurationRepairErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            StartStudioSSOConfigurationRepairErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            StartStudioSSOConfigurationRepairErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartStudioSSOConfigurationRepairError {
    fn code(&self) -> Option<&str> {
        StartStudioSSOConfigurationRepairError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartStudioSSOConfigurationRepairError {
    /// Creates a new `StartStudioSSOConfigurationRepairError`.
    pub fn new(
        kind: StartStudioSSOConfigurationRepairErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartStudioSSOConfigurationRepairError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartStudioSSOConfigurationRepairErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartStudioSSOConfigurationRepairError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartStudioSSOConfigurationRepairErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StartStudioSSOConfigurationRepairErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStudioSSOConfigurationRepairErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `StartStudioSSOConfigurationRepairErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStudioSSOConfigurationRepairErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `StartStudioSSOConfigurationRepairErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStudioSSOConfigurationRepairErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `StartStudioSSOConfigurationRepairErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStudioSSOConfigurationRepairErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `StartStudioSSOConfigurationRepairErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStudioSSOConfigurationRepairErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `StartStudioSSOConfigurationRepairErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStudioSSOConfigurationRepairErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `StartStudioSSOConfigurationRepairErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStudioSSOConfigurationRepairErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartStudioSSOConfigurationRepairError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartStudioSSOConfigurationRepairErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            StartStudioSSOConfigurationRepairErrorKind::ConflictException(_inner) => Some(_inner),
            StartStudioSSOConfigurationRepairErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            StartStudioSSOConfigurationRepairErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            StartStudioSSOConfigurationRepairErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            StartStudioSSOConfigurationRepairErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartStudioSSOConfigurationRepairErrorKind::ValidationException(_inner) => Some(_inner),
            StartStudioSSOConfigurationRepairErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateLaunchProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLaunchProfileError {
    /// Kind of error that occurred.
    pub kind: UpdateLaunchProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLaunchProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLaunchProfileErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLaunchProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLaunchProfileErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateLaunchProfileErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateLaunchProfileErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateLaunchProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateLaunchProfileErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateLaunchProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateLaunchProfileErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateLaunchProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLaunchProfileError {
    fn code(&self) -> Option<&str> {
        UpdateLaunchProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLaunchProfileError {
    /// Creates a new `UpdateLaunchProfileError`.
    pub fn new(kind: UpdateLaunchProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLaunchProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLaunchProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLaunchProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLaunchProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateLaunchProfileErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchProfileErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLaunchProfileErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchProfileErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLaunchProfileErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchProfileErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLaunchProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLaunchProfileErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchProfileErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLaunchProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchProfileErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLaunchProfileErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchProfileErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateLaunchProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLaunchProfileErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateLaunchProfileErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateLaunchProfileErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateLaunchProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateLaunchProfileErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateLaunchProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateLaunchProfileErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateLaunchProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateLaunchProfileMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLaunchProfileMemberError {
    /// Kind of error that occurred.
    pub kind: UpdateLaunchProfileMemberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLaunchProfileMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLaunchProfileMemberErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLaunchProfileMemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLaunchProfileMemberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateLaunchProfileMemberErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateLaunchProfileMemberErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLaunchProfileMemberErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateLaunchProfileMemberErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLaunchProfileMemberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateLaunchProfileMemberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateLaunchProfileMemberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLaunchProfileMemberError {
    fn code(&self) -> Option<&str> {
        UpdateLaunchProfileMemberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLaunchProfileMemberError {
    /// Creates a new `UpdateLaunchProfileMemberError`.
    pub fn new(kind: UpdateLaunchProfileMemberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLaunchProfileMemberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLaunchProfileMemberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLaunchProfileMemberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLaunchProfileMemberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateLaunchProfileMemberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchProfileMemberErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLaunchProfileMemberErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchProfileMemberErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLaunchProfileMemberErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchProfileMemberErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLaunchProfileMemberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchProfileMemberErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLaunchProfileMemberErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchProfileMemberErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLaunchProfileMemberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchProfileMemberErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLaunchProfileMemberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchProfileMemberErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateLaunchProfileMemberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLaunchProfileMemberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateLaunchProfileMemberErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateLaunchProfileMemberErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            UpdateLaunchProfileMemberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateLaunchProfileMemberErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            UpdateLaunchProfileMemberErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateLaunchProfileMemberErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateLaunchProfileMemberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateStreamingImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateStreamingImageError {
    /// Kind of error that occurred.
    pub kind: UpdateStreamingImageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateStreamingImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateStreamingImageErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateStreamingImageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateStreamingImageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateStreamingImageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateStreamingImageErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateStreamingImageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateStreamingImageErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateStreamingImageErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateStreamingImageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateStreamingImageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateStreamingImageError {
    fn code(&self) -> Option<&str> {
        UpdateStreamingImageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateStreamingImageError {
    /// Creates a new `UpdateStreamingImageError`.
    pub fn new(kind: UpdateStreamingImageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateStreamingImageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateStreamingImageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateStreamingImageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateStreamingImageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateStreamingImageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingImageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateStreamingImageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingImageErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateStreamingImageErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingImageErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `UpdateStreamingImageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingImageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateStreamingImageErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingImageErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateStreamingImageErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingImageErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `UpdateStreamingImageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingImageErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateStreamingImageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateStreamingImageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateStreamingImageErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateStreamingImageErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateStreamingImageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateStreamingImageErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateStreamingImageErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateStreamingImageErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateStreamingImageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateStudio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateStudioError {
    /// Kind of error that occurred.
    pub kind: UpdateStudioErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateStudio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateStudioErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateStudioError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateStudioErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateStudioErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateStudioErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateStudioErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateStudioErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateStudioErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateStudioErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateStudioErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateStudioError {
    fn code(&self) -> Option<&str> {
        UpdateStudioError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateStudioError {
    /// Creates a new `UpdateStudioError`.
    pub fn new(kind: UpdateStudioErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateStudioError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateStudioErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateStudioError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateStudioErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateStudioErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateStudioErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `UpdateStudioErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateStudioErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateStudioErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStudioErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `UpdateStudioErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStudioErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateStudioErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStudioErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateStudioErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateStudioErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `UpdateStudioErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateStudioErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateStudioError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateStudioErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateStudioErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateStudioErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateStudioErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateStudioErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateStudioErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateStudioErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateStudioErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateStudioComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateStudioComponentError {
    /// Kind of error that occurred.
    pub kind: UpdateStudioComponentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateStudioComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateStudioComponentErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException(crate::error::ThrottlingException),
    #[allow(missing_docs)] // documentation missing in model
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateStudioComponentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateStudioComponentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateStudioComponentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateStudioComponentErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateStudioComponentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateStudioComponentErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateStudioComponentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateStudioComponentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateStudioComponentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateStudioComponentError {
    fn code(&self) -> Option<&str> {
        UpdateStudioComponentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateStudioComponentError {
    /// Creates a new `UpdateStudioComponentError`.
    pub fn new(kind: UpdateStudioComponentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateStudioComponentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateStudioComponentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateStudioComponentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateStudioComponentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateStudioComponentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStudioComponentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateStudioComponentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStudioComponentErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateStudioComponentErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStudioComponentErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `UpdateStudioComponentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStudioComponentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateStudioComponentErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStudioComponentErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateStudioComponentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStudioComponentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `UpdateStudioComponentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStudioComponentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateStudioComponentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateStudioComponentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateStudioComponentErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateStudioComponentErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateStudioComponentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateStudioComponentErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateStudioComponentErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateStudioComponentErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateStudioComponentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    /// <p>A more specific error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The exception context.</p>
    pub context:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A human-readable description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("code", &self.code);
        formatter.field("context", &self.context);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) context: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A more specific error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>A more specific error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Adds a key-value pair to `context`.
        ///
        /// To override the contents of this collection use [`set_context`](Self::set_context).
        ///
        /// <p>The exception context.</p>
        pub fn context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.context.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.context = Some(hash_map);
            self
        }
        /// <p>The exception context.</p>
        pub fn set_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.context = input;
            self
        }
        /// <p>A human-readable description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A human-readable description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                code: self.code,
                context: self.context,
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    /// <p>A more specific error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The exception context.</p>
    pub context:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A human-readable description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("code", &self.code);
        formatter.field("context", &self.context);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) context: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A more specific error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>A more specific error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Adds a key-value pair to `context`.
        ///
        /// To override the contents of this collection use [`set_context`](Self::set_context).
        ///
        /// <p>The exception context.</p>
        pub fn context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.context.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.context = Some(hash_map);
            self
        }
        /// <p>The exception context.</p>
        pub fn set_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.context = input;
            self
        }
        /// <p>A human-readable description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A human-readable description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                code: self.code,
                context: self.context,
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    /// <p>A more specific error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The exception context.</p>
    pub context:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A human-readable description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("code", &self.code);
        formatter.field("context", &self.context);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) context: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A more specific error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>A more specific error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Adds a key-value pair to `context`.
        ///
        /// To override the contents of this collection use [`set_context`](Self::set_context).
        ///
        /// <p>The exception context.</p>
        pub fn context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.context.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.context = Some(hash_map);
            self
        }
        /// <p>The exception context.</p>
        pub fn set_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.context = input;
            self
        }
        /// <p>A human-readable description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A human-readable description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                code: self.code,
                context: self.context,
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>A more specific error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The exception context.</p>
    pub context:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A human-readable description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("code", &self.code);
        formatter.field("context", &self.context);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) context: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A more specific error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>A more specific error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Adds a key-value pair to `context`.
        ///
        /// To override the contents of this collection use [`set_context`](Self::set_context).
        ///
        /// <p>The exception context.</p>
        pub fn context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.context.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.context = Some(hash_map);
            self
        }
        /// <p>The exception context.</p>
        pub fn set_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.context = input;
            self
        }
        /// <p>A human-readable description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A human-readable description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                code: self.code,
                context: self.context,
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerErrorException {
    /// <p>A more specific error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The exception context.</p>
    pub context:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A human-readable description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerErrorException");
        formatter.field("code", &self.code);
        formatter.field("context", &self.context);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerErrorException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerErrorException {}
/// See [`InternalServerErrorException`](crate::error::InternalServerErrorException)
pub mod internal_server_error_exception {
    /// A builder for [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) context: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A more specific error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>A more specific error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Adds a key-value pair to `context`.
        ///
        /// To override the contents of this collection use [`set_context`](Self::set_context).
        ///
        /// <p>The exception context.</p>
        pub fn context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.context.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.context = Some(hash_map);
            self
        }
        /// <p>The exception context.</p>
        pub fn set_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.context = input;
            self
        }
        /// <p>A human-readable description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A human-readable description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerErrorException`](crate::error::InternalServerErrorException)
        pub fn build(self) -> crate::error::InternalServerErrorException {
            crate::error::InternalServerErrorException {
                code: self.code,
                context: self.context,
                message: self.message,
            }
        }
    }
}
impl InternalServerErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    pub fn builder() -> crate::error::internal_server_error_exception::Builder {
        crate::error::internal_server_error_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// <p>A more specific error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The exception context.</p>
    pub context:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A human-readable description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("code", &self.code);
        formatter.field("context", &self.context);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) context: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A more specific error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>A more specific error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Adds a key-value pair to `context`.
        ///
        /// To override the contents of this collection use [`set_context`](Self::set_context).
        ///
        /// <p>The exception context.</p>
        pub fn context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.context.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.context = Some(hash_map);
            self
        }
        /// <p>The exception context.</p>
        pub fn set_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.context = input;
            self
        }
        /// <p>A human-readable description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A human-readable description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                code: self.code,
                context: self.context,
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    /// <p>A more specific error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The exception context.</p>
    pub context:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A human-readable description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("code", &self.code);
        formatter.field("context", &self.context);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) context: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A more specific error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>A more specific error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Adds a key-value pair to `context`.
        ///
        /// To override the contents of this collection use [`set_context`](Self::set_context).
        ///
        /// <p>The exception context.</p>
        pub fn context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.context.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.context = Some(hash_map);
            self
        }
        /// <p>The exception context.</p>
        pub fn set_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.context = input;
            self
        }
        /// <p>A human-readable description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A human-readable description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                code: self.code,
                context: self.context,
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}
