// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcceptAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_attachment`](crate::client::Client::accept_attachment).
///
/// See [`crate::client::fluent_builders::AcceptAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptAttachment {
    _private: (),
}
impl AcceptAttachment {
    /// Creates a new builder-style object to manufacture [`AcceptAttachmentInput`](crate::input::AcceptAttachmentInput)
    pub fn builder() -> crate::input::accept_attachment_input::Builder {
        crate::input::accept_attachment_input::Builder::default()
    }
    /// Creates a new `AcceptAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptAttachment {
    type Output = std::result::Result<
        crate::output::AcceptAttachmentOutput,
        crate::error::AcceptAttachmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_attachment_error(response)
        } else {
            crate::operation_deser::parse_accept_attachment_response(response)
        }
    }
}

/// Operation shape for `AssociateConnectPeer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_connect_peer`](crate::client::Client::associate_connect_peer).
///
/// See [`crate::client::fluent_builders::AssociateConnectPeer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateConnectPeer {
    _private: (),
}
impl AssociateConnectPeer {
    /// Creates a new builder-style object to manufacture [`AssociateConnectPeerInput`](crate::input::AssociateConnectPeerInput)
    pub fn builder() -> crate::input::associate_connect_peer_input::Builder {
        crate::input::associate_connect_peer_input::Builder::default()
    }
    /// Creates a new `AssociateConnectPeer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateConnectPeer {
    type Output = std::result::Result<
        crate::output::AssociateConnectPeerOutput,
        crate::error::AssociateConnectPeerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_connect_peer_error(response)
        } else {
            crate::operation_deser::parse_associate_connect_peer_response(response)
        }
    }
}

/// Operation shape for `AssociateCustomerGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_customer_gateway`](crate::client::Client::associate_customer_gateway).
///
/// See [`crate::client::fluent_builders::AssociateCustomerGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateCustomerGateway {
    _private: (),
}
impl AssociateCustomerGateway {
    /// Creates a new builder-style object to manufacture [`AssociateCustomerGatewayInput`](crate::input::AssociateCustomerGatewayInput)
    pub fn builder() -> crate::input::associate_customer_gateway_input::Builder {
        crate::input::associate_customer_gateway_input::Builder::default()
    }
    /// Creates a new `AssociateCustomerGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateCustomerGateway {
    type Output = std::result::Result<
        crate::output::AssociateCustomerGatewayOutput,
        crate::error::AssociateCustomerGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_customer_gateway_error(response)
        } else {
            crate::operation_deser::parse_associate_customer_gateway_response(response)
        }
    }
}

/// Operation shape for `AssociateLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_link`](crate::client::Client::associate_link).
///
/// See [`crate::client::fluent_builders::AssociateLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateLink {
    _private: (),
}
impl AssociateLink {
    /// Creates a new builder-style object to manufacture [`AssociateLinkInput`](crate::input::AssociateLinkInput)
    pub fn builder() -> crate::input::associate_link_input::Builder {
        crate::input::associate_link_input::Builder::default()
    }
    /// Creates a new `AssociateLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateLink {
    type Output =
        std::result::Result<crate::output::AssociateLinkOutput, crate::error::AssociateLinkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_link_error(response)
        } else {
            crate::operation_deser::parse_associate_link_response(response)
        }
    }
}

/// Operation shape for `AssociateTransitGatewayConnectPeer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_transit_gateway_connect_peer`](crate::client::Client::associate_transit_gateway_connect_peer).
///
/// See [`crate::client::fluent_builders::AssociateTransitGatewayConnectPeer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateTransitGatewayConnectPeer {
    _private: (),
}
impl AssociateTransitGatewayConnectPeer {
    /// Creates a new builder-style object to manufacture [`AssociateTransitGatewayConnectPeerInput`](crate::input::AssociateTransitGatewayConnectPeerInput)
    pub fn builder() -> crate::input::associate_transit_gateway_connect_peer_input::Builder {
        crate::input::associate_transit_gateway_connect_peer_input::Builder::default()
    }
    /// Creates a new `AssociateTransitGatewayConnectPeer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateTransitGatewayConnectPeer {
    type Output = std::result::Result<
        crate::output::AssociateTransitGatewayConnectPeerOutput,
        crate::error::AssociateTransitGatewayConnectPeerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_transit_gateway_connect_peer_error(response)
        } else {
            crate::operation_deser::parse_associate_transit_gateway_connect_peer_response(response)
        }
    }
}

/// Operation shape for `CreateConnectAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_connect_attachment`](crate::client::Client::create_connect_attachment).
///
/// See [`crate::client::fluent_builders::CreateConnectAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConnectAttachment {
    _private: (),
}
impl CreateConnectAttachment {
    /// Creates a new builder-style object to manufacture [`CreateConnectAttachmentInput`](crate::input::CreateConnectAttachmentInput)
    pub fn builder() -> crate::input::create_connect_attachment_input::Builder {
        crate::input::create_connect_attachment_input::Builder::default()
    }
    /// Creates a new `CreateConnectAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConnectAttachment {
    type Output = std::result::Result<
        crate::output::CreateConnectAttachmentOutput,
        crate::error::CreateConnectAttachmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_connect_attachment_error(response)
        } else {
            crate::operation_deser::parse_create_connect_attachment_response(response)
        }
    }
}

/// Operation shape for `CreateConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_connection`](crate::client::Client::create_connection).
///
/// See [`crate::client::fluent_builders::CreateConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConnection {
    _private: (),
}
impl CreateConnection {
    /// Creates a new builder-style object to manufacture [`CreateConnectionInput`](crate::input::CreateConnectionInput)
    pub fn builder() -> crate::input::create_connection_input::Builder {
        crate::input::create_connection_input::Builder::default()
    }
    /// Creates a new `CreateConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConnection {
    type Output = std::result::Result<
        crate::output::CreateConnectionOutput,
        crate::error::CreateConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_connection_error(response)
        } else {
            crate::operation_deser::parse_create_connection_response(response)
        }
    }
}

/// Operation shape for `CreateConnectPeer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_connect_peer`](crate::client::Client::create_connect_peer).
///
/// See [`crate::client::fluent_builders::CreateConnectPeer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConnectPeer {
    _private: (),
}
impl CreateConnectPeer {
    /// Creates a new builder-style object to manufacture [`CreateConnectPeerInput`](crate::input::CreateConnectPeerInput)
    pub fn builder() -> crate::input::create_connect_peer_input::Builder {
        crate::input::create_connect_peer_input::Builder::default()
    }
    /// Creates a new `CreateConnectPeer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConnectPeer {
    type Output = std::result::Result<
        crate::output::CreateConnectPeerOutput,
        crate::error::CreateConnectPeerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_connect_peer_error(response)
        } else {
            crate::operation_deser::parse_create_connect_peer_response(response)
        }
    }
}

/// Operation shape for `CreateCoreNetwork`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_core_network`](crate::client::Client::create_core_network).
///
/// See [`crate::client::fluent_builders::CreateCoreNetwork`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCoreNetwork {
    _private: (),
}
impl CreateCoreNetwork {
    /// Creates a new builder-style object to manufacture [`CreateCoreNetworkInput`](crate::input::CreateCoreNetworkInput)
    pub fn builder() -> crate::input::create_core_network_input::Builder {
        crate::input::create_core_network_input::Builder::default()
    }
    /// Creates a new `CreateCoreNetwork` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCoreNetwork {
    type Output = std::result::Result<
        crate::output::CreateCoreNetworkOutput,
        crate::error::CreateCoreNetworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_core_network_error(response)
        } else {
            crate::operation_deser::parse_create_core_network_response(response)
        }
    }
}

/// Operation shape for `CreateDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_device`](crate::client::Client::create_device).
///
/// See [`crate::client::fluent_builders::CreateDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDevice {
    _private: (),
}
impl CreateDevice {
    /// Creates a new builder-style object to manufacture [`CreateDeviceInput`](crate::input::CreateDeviceInput)
    pub fn builder() -> crate::input::create_device_input::Builder {
        crate::input::create_device_input::Builder::default()
    }
    /// Creates a new `CreateDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDevice {
    type Output =
        std::result::Result<crate::output::CreateDeviceOutput, crate::error::CreateDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_device_error(response)
        } else {
            crate::operation_deser::parse_create_device_response(response)
        }
    }
}

/// Operation shape for `CreateGlobalNetwork`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_global_network`](crate::client::Client::create_global_network).
///
/// See [`crate::client::fluent_builders::CreateGlobalNetwork`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGlobalNetwork {
    _private: (),
}
impl CreateGlobalNetwork {
    /// Creates a new builder-style object to manufacture [`CreateGlobalNetworkInput`](crate::input::CreateGlobalNetworkInput)
    pub fn builder() -> crate::input::create_global_network_input::Builder {
        crate::input::create_global_network_input::Builder::default()
    }
    /// Creates a new `CreateGlobalNetwork` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGlobalNetwork {
    type Output = std::result::Result<
        crate::output::CreateGlobalNetworkOutput,
        crate::error::CreateGlobalNetworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_global_network_error(response)
        } else {
            crate::operation_deser::parse_create_global_network_response(response)
        }
    }
}

/// Operation shape for `CreateLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_link`](crate::client::Client::create_link).
///
/// See [`crate::client::fluent_builders::CreateLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLink {
    _private: (),
}
impl CreateLink {
    /// Creates a new builder-style object to manufacture [`CreateLinkInput`](crate::input::CreateLinkInput)
    pub fn builder() -> crate::input::create_link_input::Builder {
        crate::input::create_link_input::Builder::default()
    }
    /// Creates a new `CreateLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLink {
    type Output =
        std::result::Result<crate::output::CreateLinkOutput, crate::error::CreateLinkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_link_error(response)
        } else {
            crate::operation_deser::parse_create_link_response(response)
        }
    }
}

/// Operation shape for `CreateSite`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_site`](crate::client::Client::create_site).
///
/// See [`crate::client::fluent_builders::CreateSite`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSite {
    _private: (),
}
impl CreateSite {
    /// Creates a new builder-style object to manufacture [`CreateSiteInput`](crate::input::CreateSiteInput)
    pub fn builder() -> crate::input::create_site_input::Builder {
        crate::input::create_site_input::Builder::default()
    }
    /// Creates a new `CreateSite` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSite {
    type Output =
        std::result::Result<crate::output::CreateSiteOutput, crate::error::CreateSiteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_site_error(response)
        } else {
            crate::operation_deser::parse_create_site_response(response)
        }
    }
}

/// Operation shape for `CreateSiteToSiteVpnAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_site_to_site_vpn_attachment`](crate::client::Client::create_site_to_site_vpn_attachment).
///
/// See [`crate::client::fluent_builders::CreateSiteToSiteVpnAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSiteToSiteVpnAttachment {
    _private: (),
}
impl CreateSiteToSiteVpnAttachment {
    /// Creates a new builder-style object to manufacture [`CreateSiteToSiteVpnAttachmentInput`](crate::input::CreateSiteToSiteVpnAttachmentInput)
    pub fn builder() -> crate::input::create_site_to_site_vpn_attachment_input::Builder {
        crate::input::create_site_to_site_vpn_attachment_input::Builder::default()
    }
    /// Creates a new `CreateSiteToSiteVpnAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSiteToSiteVpnAttachment {
    type Output = std::result::Result<
        crate::output::CreateSiteToSiteVpnAttachmentOutput,
        crate::error::CreateSiteToSiteVpnAttachmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_site_to_site_vpn_attachment_error(response)
        } else {
            crate::operation_deser::parse_create_site_to_site_vpn_attachment_response(response)
        }
    }
}

/// Operation shape for `CreateVpcAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_vpc_attachment`](crate::client::Client::create_vpc_attachment).
///
/// See [`crate::client::fluent_builders::CreateVpcAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVpcAttachment {
    _private: (),
}
impl CreateVpcAttachment {
    /// Creates a new builder-style object to manufacture [`CreateVpcAttachmentInput`](crate::input::CreateVpcAttachmentInput)
    pub fn builder() -> crate::input::create_vpc_attachment_input::Builder {
        crate::input::create_vpc_attachment_input::Builder::default()
    }
    /// Creates a new `CreateVpcAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVpcAttachment {
    type Output = std::result::Result<
        crate::output::CreateVpcAttachmentOutput,
        crate::error::CreateVpcAttachmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_vpc_attachment_error(response)
        } else {
            crate::operation_deser::parse_create_vpc_attachment_response(response)
        }
    }
}

/// Operation shape for `DeleteAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_attachment`](crate::client::Client::delete_attachment).
///
/// See [`crate::client::fluent_builders::DeleteAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAttachment {
    _private: (),
}
impl DeleteAttachment {
    /// Creates a new builder-style object to manufacture [`DeleteAttachmentInput`](crate::input::DeleteAttachmentInput)
    pub fn builder() -> crate::input::delete_attachment_input::Builder {
        crate::input::delete_attachment_input::Builder::default()
    }
    /// Creates a new `DeleteAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAttachment {
    type Output = std::result::Result<
        crate::output::DeleteAttachmentOutput,
        crate::error::DeleteAttachmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_attachment_error(response)
        } else {
            crate::operation_deser::parse_delete_attachment_response(response)
        }
    }
}

/// Operation shape for `DeleteConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_connection`](crate::client::Client::delete_connection).
///
/// See [`crate::client::fluent_builders::DeleteConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConnection {
    _private: (),
}
impl DeleteConnection {
    /// Creates a new builder-style object to manufacture [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
    pub fn builder() -> crate::input::delete_connection_input::Builder {
        crate::input::delete_connection_input::Builder::default()
    }
    /// Creates a new `DeleteConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConnection {
    type Output = std::result::Result<
        crate::output::DeleteConnectionOutput,
        crate::error::DeleteConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_connection_error(response)
        } else {
            crate::operation_deser::parse_delete_connection_response(response)
        }
    }
}

/// Operation shape for `DeleteConnectPeer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_connect_peer`](crate::client::Client::delete_connect_peer).
///
/// See [`crate::client::fluent_builders::DeleteConnectPeer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConnectPeer {
    _private: (),
}
impl DeleteConnectPeer {
    /// Creates a new builder-style object to manufacture [`DeleteConnectPeerInput`](crate::input::DeleteConnectPeerInput)
    pub fn builder() -> crate::input::delete_connect_peer_input::Builder {
        crate::input::delete_connect_peer_input::Builder::default()
    }
    /// Creates a new `DeleteConnectPeer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConnectPeer {
    type Output = std::result::Result<
        crate::output::DeleteConnectPeerOutput,
        crate::error::DeleteConnectPeerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_connect_peer_error(response)
        } else {
            crate::operation_deser::parse_delete_connect_peer_response(response)
        }
    }
}

/// Operation shape for `DeleteCoreNetwork`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_core_network`](crate::client::Client::delete_core_network).
///
/// See [`crate::client::fluent_builders::DeleteCoreNetwork`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCoreNetwork {
    _private: (),
}
impl DeleteCoreNetwork {
    /// Creates a new builder-style object to manufacture [`DeleteCoreNetworkInput`](crate::input::DeleteCoreNetworkInput)
    pub fn builder() -> crate::input::delete_core_network_input::Builder {
        crate::input::delete_core_network_input::Builder::default()
    }
    /// Creates a new `DeleteCoreNetwork` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCoreNetwork {
    type Output = std::result::Result<
        crate::output::DeleteCoreNetworkOutput,
        crate::error::DeleteCoreNetworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_core_network_error(response)
        } else {
            crate::operation_deser::parse_delete_core_network_response(response)
        }
    }
}

/// Operation shape for `DeleteCoreNetworkPolicyVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_core_network_policy_version`](crate::client::Client::delete_core_network_policy_version).
///
/// See [`crate::client::fluent_builders::DeleteCoreNetworkPolicyVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCoreNetworkPolicyVersion {
    _private: (),
}
impl DeleteCoreNetworkPolicyVersion {
    /// Creates a new builder-style object to manufacture [`DeleteCoreNetworkPolicyVersionInput`](crate::input::DeleteCoreNetworkPolicyVersionInput)
    pub fn builder() -> crate::input::delete_core_network_policy_version_input::Builder {
        crate::input::delete_core_network_policy_version_input::Builder::default()
    }
    /// Creates a new `DeleteCoreNetworkPolicyVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCoreNetworkPolicyVersion {
    type Output = std::result::Result<
        crate::output::DeleteCoreNetworkPolicyVersionOutput,
        crate::error::DeleteCoreNetworkPolicyVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_core_network_policy_version_error(response)
        } else {
            crate::operation_deser::parse_delete_core_network_policy_version_response(response)
        }
    }
}

/// Operation shape for `DeleteDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_device`](crate::client::Client::delete_device).
///
/// See [`crate::client::fluent_builders::DeleteDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDevice {
    _private: (),
}
impl DeleteDevice {
    /// Creates a new builder-style object to manufacture [`DeleteDeviceInput`](crate::input::DeleteDeviceInput)
    pub fn builder() -> crate::input::delete_device_input::Builder {
        crate::input::delete_device_input::Builder::default()
    }
    /// Creates a new `DeleteDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDevice {
    type Output =
        std::result::Result<crate::output::DeleteDeviceOutput, crate::error::DeleteDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_device_error(response)
        } else {
            crate::operation_deser::parse_delete_device_response(response)
        }
    }
}

/// Operation shape for `DeleteGlobalNetwork`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_global_network`](crate::client::Client::delete_global_network).
///
/// See [`crate::client::fluent_builders::DeleteGlobalNetwork`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGlobalNetwork {
    _private: (),
}
impl DeleteGlobalNetwork {
    /// Creates a new builder-style object to manufacture [`DeleteGlobalNetworkInput`](crate::input::DeleteGlobalNetworkInput)
    pub fn builder() -> crate::input::delete_global_network_input::Builder {
        crate::input::delete_global_network_input::Builder::default()
    }
    /// Creates a new `DeleteGlobalNetwork` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGlobalNetwork {
    type Output = std::result::Result<
        crate::output::DeleteGlobalNetworkOutput,
        crate::error::DeleteGlobalNetworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_global_network_error(response)
        } else {
            crate::operation_deser::parse_delete_global_network_response(response)
        }
    }
}

/// Operation shape for `DeleteLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_link`](crate::client::Client::delete_link).
///
/// See [`crate::client::fluent_builders::DeleteLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLink {
    _private: (),
}
impl DeleteLink {
    /// Creates a new builder-style object to manufacture [`DeleteLinkInput`](crate::input::DeleteLinkInput)
    pub fn builder() -> crate::input::delete_link_input::Builder {
        crate::input::delete_link_input::Builder::default()
    }
    /// Creates a new `DeleteLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLink {
    type Output =
        std::result::Result<crate::output::DeleteLinkOutput, crate::error::DeleteLinkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_link_error(response)
        } else {
            crate::operation_deser::parse_delete_link_response(response)
        }
    }
}

/// Operation shape for `DeleteResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resource_policy`](crate::client::Client::delete_resource_policy).
///
/// See [`crate::client::fluent_builders::DeleteResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResourcePolicy {
    _private: (),
}
impl DeleteResourcePolicy {
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
    pub fn builder() -> crate::input::delete_resource_policy_input::Builder {
        crate::input::delete_resource_policy_input::Builder::default()
    }
    /// Creates a new `DeleteResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResourcePolicy {
    type Output = std::result::Result<
        crate::output::DeleteResourcePolicyOutput,
        crate::error::DeleteResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_resource_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteSite`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_site`](crate::client::Client::delete_site).
///
/// See [`crate::client::fluent_builders::DeleteSite`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSite {
    _private: (),
}
impl DeleteSite {
    /// Creates a new builder-style object to manufacture [`DeleteSiteInput`](crate::input::DeleteSiteInput)
    pub fn builder() -> crate::input::delete_site_input::Builder {
        crate::input::delete_site_input::Builder::default()
    }
    /// Creates a new `DeleteSite` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSite {
    type Output =
        std::result::Result<crate::output::DeleteSiteOutput, crate::error::DeleteSiteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_site_error(response)
        } else {
            crate::operation_deser::parse_delete_site_response(response)
        }
    }
}

/// Operation shape for `DeregisterTransitGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_transit_gateway`](crate::client::Client::deregister_transit_gateway).
///
/// See [`crate::client::fluent_builders::DeregisterTransitGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterTransitGateway {
    _private: (),
}
impl DeregisterTransitGateway {
    /// Creates a new builder-style object to manufacture [`DeregisterTransitGatewayInput`](crate::input::DeregisterTransitGatewayInput)
    pub fn builder() -> crate::input::deregister_transit_gateway_input::Builder {
        crate::input::deregister_transit_gateway_input::Builder::default()
    }
    /// Creates a new `DeregisterTransitGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterTransitGateway {
    type Output = std::result::Result<
        crate::output::DeregisterTransitGatewayOutput,
        crate::error::DeregisterTransitGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_transit_gateway_error(response)
        } else {
            crate::operation_deser::parse_deregister_transit_gateway_response(response)
        }
    }
}

/// Operation shape for `DescribeGlobalNetworks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_global_networks`](crate::client::Client::describe_global_networks).
///
/// See [`crate::client::fluent_builders::DescribeGlobalNetworks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGlobalNetworks {
    _private: (),
}
impl DescribeGlobalNetworks {
    /// Creates a new builder-style object to manufacture [`DescribeGlobalNetworksInput`](crate::input::DescribeGlobalNetworksInput)
    pub fn builder() -> crate::input::describe_global_networks_input::Builder {
        crate::input::describe_global_networks_input::Builder::default()
    }
    /// Creates a new `DescribeGlobalNetworks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGlobalNetworks {
    type Output = std::result::Result<
        crate::output::DescribeGlobalNetworksOutput,
        crate::error::DescribeGlobalNetworksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_global_networks_error(response)
        } else {
            crate::operation_deser::parse_describe_global_networks_response(response)
        }
    }
}

/// Operation shape for `DisassociateConnectPeer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_connect_peer`](crate::client::Client::disassociate_connect_peer).
///
/// See [`crate::client::fluent_builders::DisassociateConnectPeer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateConnectPeer {
    _private: (),
}
impl DisassociateConnectPeer {
    /// Creates a new builder-style object to manufacture [`DisassociateConnectPeerInput`](crate::input::DisassociateConnectPeerInput)
    pub fn builder() -> crate::input::disassociate_connect_peer_input::Builder {
        crate::input::disassociate_connect_peer_input::Builder::default()
    }
    /// Creates a new `DisassociateConnectPeer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateConnectPeer {
    type Output = std::result::Result<
        crate::output::DisassociateConnectPeerOutput,
        crate::error::DisassociateConnectPeerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_connect_peer_error(response)
        } else {
            crate::operation_deser::parse_disassociate_connect_peer_response(response)
        }
    }
}

/// Operation shape for `DisassociateCustomerGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_customer_gateway`](crate::client::Client::disassociate_customer_gateway).
///
/// See [`crate::client::fluent_builders::DisassociateCustomerGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateCustomerGateway {
    _private: (),
}
impl DisassociateCustomerGateway {
    /// Creates a new builder-style object to manufacture [`DisassociateCustomerGatewayInput`](crate::input::DisassociateCustomerGatewayInput)
    pub fn builder() -> crate::input::disassociate_customer_gateway_input::Builder {
        crate::input::disassociate_customer_gateway_input::Builder::default()
    }
    /// Creates a new `DisassociateCustomerGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateCustomerGateway {
    type Output = std::result::Result<
        crate::output::DisassociateCustomerGatewayOutput,
        crate::error::DisassociateCustomerGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_customer_gateway_error(response)
        } else {
            crate::operation_deser::parse_disassociate_customer_gateway_response(response)
        }
    }
}

/// Operation shape for `DisassociateLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_link`](crate::client::Client::disassociate_link).
///
/// See [`crate::client::fluent_builders::DisassociateLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateLink {
    _private: (),
}
impl DisassociateLink {
    /// Creates a new builder-style object to manufacture [`DisassociateLinkInput`](crate::input::DisassociateLinkInput)
    pub fn builder() -> crate::input::disassociate_link_input::Builder {
        crate::input::disassociate_link_input::Builder::default()
    }
    /// Creates a new `DisassociateLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateLink {
    type Output = std::result::Result<
        crate::output::DisassociateLinkOutput,
        crate::error::DisassociateLinkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_link_error(response)
        } else {
            crate::operation_deser::parse_disassociate_link_response(response)
        }
    }
}

/// Operation shape for `DisassociateTransitGatewayConnectPeer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_transit_gateway_connect_peer`](crate::client::Client::disassociate_transit_gateway_connect_peer).
///
/// See [`crate::client::fluent_builders::DisassociateTransitGatewayConnectPeer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateTransitGatewayConnectPeer {
    _private: (),
}
impl DisassociateTransitGatewayConnectPeer {
    /// Creates a new builder-style object to manufacture [`DisassociateTransitGatewayConnectPeerInput`](crate::input::DisassociateTransitGatewayConnectPeerInput)
    pub fn builder() -> crate::input::disassociate_transit_gateway_connect_peer_input::Builder {
        crate::input::disassociate_transit_gateway_connect_peer_input::Builder::default()
    }
    /// Creates a new `DisassociateTransitGatewayConnectPeer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateTransitGatewayConnectPeer {
    type Output = std::result::Result<
        crate::output::DisassociateTransitGatewayConnectPeerOutput,
        crate::error::DisassociateTransitGatewayConnectPeerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_transit_gateway_connect_peer_error(response)
        } else {
            crate::operation_deser::parse_disassociate_transit_gateway_connect_peer_response(
                response,
            )
        }
    }
}

/// Operation shape for `ExecuteCoreNetworkChangeSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`execute_core_network_change_set`](crate::client::Client::execute_core_network_change_set).
///
/// See [`crate::client::fluent_builders::ExecuteCoreNetworkChangeSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExecuteCoreNetworkChangeSet {
    _private: (),
}
impl ExecuteCoreNetworkChangeSet {
    /// Creates a new builder-style object to manufacture [`ExecuteCoreNetworkChangeSetInput`](crate::input::ExecuteCoreNetworkChangeSetInput)
    pub fn builder() -> crate::input::execute_core_network_change_set_input::Builder {
        crate::input::execute_core_network_change_set_input::Builder::default()
    }
    /// Creates a new `ExecuteCoreNetworkChangeSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExecuteCoreNetworkChangeSet {
    type Output = std::result::Result<
        crate::output::ExecuteCoreNetworkChangeSetOutput,
        crate::error::ExecuteCoreNetworkChangeSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_execute_core_network_change_set_error(response)
        } else {
            crate::operation_deser::parse_execute_core_network_change_set_response(response)
        }
    }
}

/// Operation shape for `GetConnectAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_connect_attachment`](crate::client::Client::get_connect_attachment).
///
/// See [`crate::client::fluent_builders::GetConnectAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConnectAttachment {
    _private: (),
}
impl GetConnectAttachment {
    /// Creates a new builder-style object to manufacture [`GetConnectAttachmentInput`](crate::input::GetConnectAttachmentInput)
    pub fn builder() -> crate::input::get_connect_attachment_input::Builder {
        crate::input::get_connect_attachment_input::Builder::default()
    }
    /// Creates a new `GetConnectAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConnectAttachment {
    type Output = std::result::Result<
        crate::output::GetConnectAttachmentOutput,
        crate::error::GetConnectAttachmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_connect_attachment_error(response)
        } else {
            crate::operation_deser::parse_get_connect_attachment_response(response)
        }
    }
}

/// Operation shape for `GetConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_connections`](crate::client::Client::get_connections).
///
/// See [`crate::client::fluent_builders::GetConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConnections {
    _private: (),
}
impl GetConnections {
    /// Creates a new builder-style object to manufacture [`GetConnectionsInput`](crate::input::GetConnectionsInput)
    pub fn builder() -> crate::input::get_connections_input::Builder {
        crate::input::get_connections_input::Builder::default()
    }
    /// Creates a new `GetConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConnections {
    type Output =
        std::result::Result<crate::output::GetConnectionsOutput, crate::error::GetConnectionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_connections_error(response)
        } else {
            crate::operation_deser::parse_get_connections_response(response)
        }
    }
}

/// Operation shape for `GetConnectPeer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_connect_peer`](crate::client::Client::get_connect_peer).
///
/// See [`crate::client::fluent_builders::GetConnectPeer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConnectPeer {
    _private: (),
}
impl GetConnectPeer {
    /// Creates a new builder-style object to manufacture [`GetConnectPeerInput`](crate::input::GetConnectPeerInput)
    pub fn builder() -> crate::input::get_connect_peer_input::Builder {
        crate::input::get_connect_peer_input::Builder::default()
    }
    /// Creates a new `GetConnectPeer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConnectPeer {
    type Output =
        std::result::Result<crate::output::GetConnectPeerOutput, crate::error::GetConnectPeerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_connect_peer_error(response)
        } else {
            crate::operation_deser::parse_get_connect_peer_response(response)
        }
    }
}

/// Operation shape for `GetConnectPeerAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_connect_peer_associations`](crate::client::Client::get_connect_peer_associations).
///
/// See [`crate::client::fluent_builders::GetConnectPeerAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConnectPeerAssociations {
    _private: (),
}
impl GetConnectPeerAssociations {
    /// Creates a new builder-style object to manufacture [`GetConnectPeerAssociationsInput`](crate::input::GetConnectPeerAssociationsInput)
    pub fn builder() -> crate::input::get_connect_peer_associations_input::Builder {
        crate::input::get_connect_peer_associations_input::Builder::default()
    }
    /// Creates a new `GetConnectPeerAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConnectPeerAssociations {
    type Output = std::result::Result<
        crate::output::GetConnectPeerAssociationsOutput,
        crate::error::GetConnectPeerAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_connect_peer_associations_error(response)
        } else {
            crate::operation_deser::parse_get_connect_peer_associations_response(response)
        }
    }
}

/// Operation shape for `GetCoreNetwork`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_core_network`](crate::client::Client::get_core_network).
///
/// See [`crate::client::fluent_builders::GetCoreNetwork`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCoreNetwork {
    _private: (),
}
impl GetCoreNetwork {
    /// Creates a new builder-style object to manufacture [`GetCoreNetworkInput`](crate::input::GetCoreNetworkInput)
    pub fn builder() -> crate::input::get_core_network_input::Builder {
        crate::input::get_core_network_input::Builder::default()
    }
    /// Creates a new `GetCoreNetwork` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCoreNetwork {
    type Output =
        std::result::Result<crate::output::GetCoreNetworkOutput, crate::error::GetCoreNetworkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_core_network_error(response)
        } else {
            crate::operation_deser::parse_get_core_network_response(response)
        }
    }
}

/// Operation shape for `GetCoreNetworkChangeSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_core_network_change_set`](crate::client::Client::get_core_network_change_set).
///
/// See [`crate::client::fluent_builders::GetCoreNetworkChangeSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCoreNetworkChangeSet {
    _private: (),
}
impl GetCoreNetworkChangeSet {
    /// Creates a new builder-style object to manufacture [`GetCoreNetworkChangeSetInput`](crate::input::GetCoreNetworkChangeSetInput)
    pub fn builder() -> crate::input::get_core_network_change_set_input::Builder {
        crate::input::get_core_network_change_set_input::Builder::default()
    }
    /// Creates a new `GetCoreNetworkChangeSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCoreNetworkChangeSet {
    type Output = std::result::Result<
        crate::output::GetCoreNetworkChangeSetOutput,
        crate::error::GetCoreNetworkChangeSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_core_network_change_set_error(response)
        } else {
            crate::operation_deser::parse_get_core_network_change_set_response(response)
        }
    }
}

/// Operation shape for `GetCoreNetworkPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_core_network_policy`](crate::client::Client::get_core_network_policy).
///
/// See [`crate::client::fluent_builders::GetCoreNetworkPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCoreNetworkPolicy {
    _private: (),
}
impl GetCoreNetworkPolicy {
    /// Creates a new builder-style object to manufacture [`GetCoreNetworkPolicyInput`](crate::input::GetCoreNetworkPolicyInput)
    pub fn builder() -> crate::input::get_core_network_policy_input::Builder {
        crate::input::get_core_network_policy_input::Builder::default()
    }
    /// Creates a new `GetCoreNetworkPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCoreNetworkPolicy {
    type Output = std::result::Result<
        crate::output::GetCoreNetworkPolicyOutput,
        crate::error::GetCoreNetworkPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_core_network_policy_error(response)
        } else {
            crate::operation_deser::parse_get_core_network_policy_response(response)
        }
    }
}

/// Operation shape for `GetCustomerGatewayAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_customer_gateway_associations`](crate::client::Client::get_customer_gateway_associations).
///
/// See [`crate::client::fluent_builders::GetCustomerGatewayAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCustomerGatewayAssociations {
    _private: (),
}
impl GetCustomerGatewayAssociations {
    /// Creates a new builder-style object to manufacture [`GetCustomerGatewayAssociationsInput`](crate::input::GetCustomerGatewayAssociationsInput)
    pub fn builder() -> crate::input::get_customer_gateway_associations_input::Builder {
        crate::input::get_customer_gateway_associations_input::Builder::default()
    }
    /// Creates a new `GetCustomerGatewayAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCustomerGatewayAssociations {
    type Output = std::result::Result<
        crate::output::GetCustomerGatewayAssociationsOutput,
        crate::error::GetCustomerGatewayAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_customer_gateway_associations_error(response)
        } else {
            crate::operation_deser::parse_get_customer_gateway_associations_response(response)
        }
    }
}

/// Operation shape for `GetDevices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_devices`](crate::client::Client::get_devices).
///
/// See [`crate::client::fluent_builders::GetDevices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDevices {
    _private: (),
}
impl GetDevices {
    /// Creates a new builder-style object to manufacture [`GetDevicesInput`](crate::input::GetDevicesInput)
    pub fn builder() -> crate::input::get_devices_input::Builder {
        crate::input::get_devices_input::Builder::default()
    }
    /// Creates a new `GetDevices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDevices {
    type Output =
        std::result::Result<crate::output::GetDevicesOutput, crate::error::GetDevicesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_devices_error(response)
        } else {
            crate::operation_deser::parse_get_devices_response(response)
        }
    }
}

/// Operation shape for `GetLinkAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_link_associations`](crate::client::Client::get_link_associations).
///
/// See [`crate::client::fluent_builders::GetLinkAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLinkAssociations {
    _private: (),
}
impl GetLinkAssociations {
    /// Creates a new builder-style object to manufacture [`GetLinkAssociationsInput`](crate::input::GetLinkAssociationsInput)
    pub fn builder() -> crate::input::get_link_associations_input::Builder {
        crate::input::get_link_associations_input::Builder::default()
    }
    /// Creates a new `GetLinkAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLinkAssociations {
    type Output = std::result::Result<
        crate::output::GetLinkAssociationsOutput,
        crate::error::GetLinkAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_link_associations_error(response)
        } else {
            crate::operation_deser::parse_get_link_associations_response(response)
        }
    }
}

/// Operation shape for `GetLinks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_links`](crate::client::Client::get_links).
///
/// See [`crate::client::fluent_builders::GetLinks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLinks {
    _private: (),
}
impl GetLinks {
    /// Creates a new builder-style object to manufacture [`GetLinksInput`](crate::input::GetLinksInput)
    pub fn builder() -> crate::input::get_links_input::Builder {
        crate::input::get_links_input::Builder::default()
    }
    /// Creates a new `GetLinks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLinks {
    type Output = std::result::Result<crate::output::GetLinksOutput, crate::error::GetLinksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_links_error(response)
        } else {
            crate::operation_deser::parse_get_links_response(response)
        }
    }
}

/// Operation shape for `GetNetworkResourceCounts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_network_resource_counts`](crate::client::Client::get_network_resource_counts).
///
/// See [`crate::client::fluent_builders::GetNetworkResourceCounts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetNetworkResourceCounts {
    _private: (),
}
impl GetNetworkResourceCounts {
    /// Creates a new builder-style object to manufacture [`GetNetworkResourceCountsInput`](crate::input::GetNetworkResourceCountsInput)
    pub fn builder() -> crate::input::get_network_resource_counts_input::Builder {
        crate::input::get_network_resource_counts_input::Builder::default()
    }
    /// Creates a new `GetNetworkResourceCounts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetNetworkResourceCounts {
    type Output = std::result::Result<
        crate::output::GetNetworkResourceCountsOutput,
        crate::error::GetNetworkResourceCountsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_network_resource_counts_error(response)
        } else {
            crate::operation_deser::parse_get_network_resource_counts_response(response)
        }
    }
}

/// Operation shape for `GetNetworkResourceRelationships`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_network_resource_relationships`](crate::client::Client::get_network_resource_relationships).
///
/// See [`crate::client::fluent_builders::GetNetworkResourceRelationships`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetNetworkResourceRelationships {
    _private: (),
}
impl GetNetworkResourceRelationships {
    /// Creates a new builder-style object to manufacture [`GetNetworkResourceRelationshipsInput`](crate::input::GetNetworkResourceRelationshipsInput)
    pub fn builder() -> crate::input::get_network_resource_relationships_input::Builder {
        crate::input::get_network_resource_relationships_input::Builder::default()
    }
    /// Creates a new `GetNetworkResourceRelationships` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetNetworkResourceRelationships {
    type Output = std::result::Result<
        crate::output::GetNetworkResourceRelationshipsOutput,
        crate::error::GetNetworkResourceRelationshipsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_network_resource_relationships_error(response)
        } else {
            crate::operation_deser::parse_get_network_resource_relationships_response(response)
        }
    }
}

/// Operation shape for `GetNetworkResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_network_resources`](crate::client::Client::get_network_resources).
///
/// See [`crate::client::fluent_builders::GetNetworkResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetNetworkResources {
    _private: (),
}
impl GetNetworkResources {
    /// Creates a new builder-style object to manufacture [`GetNetworkResourcesInput`](crate::input::GetNetworkResourcesInput)
    pub fn builder() -> crate::input::get_network_resources_input::Builder {
        crate::input::get_network_resources_input::Builder::default()
    }
    /// Creates a new `GetNetworkResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetNetworkResources {
    type Output = std::result::Result<
        crate::output::GetNetworkResourcesOutput,
        crate::error::GetNetworkResourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_network_resources_error(response)
        } else {
            crate::operation_deser::parse_get_network_resources_response(response)
        }
    }
}

/// Operation shape for `GetNetworkRoutes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_network_routes`](crate::client::Client::get_network_routes).
///
/// See [`crate::client::fluent_builders::GetNetworkRoutes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetNetworkRoutes {
    _private: (),
}
impl GetNetworkRoutes {
    /// Creates a new builder-style object to manufacture [`GetNetworkRoutesInput`](crate::input::GetNetworkRoutesInput)
    pub fn builder() -> crate::input::get_network_routes_input::Builder {
        crate::input::get_network_routes_input::Builder::default()
    }
    /// Creates a new `GetNetworkRoutes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetNetworkRoutes {
    type Output = std::result::Result<
        crate::output::GetNetworkRoutesOutput,
        crate::error::GetNetworkRoutesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_network_routes_error(response)
        } else {
            crate::operation_deser::parse_get_network_routes_response(response)
        }
    }
}

/// Operation shape for `GetNetworkTelemetry`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_network_telemetry`](crate::client::Client::get_network_telemetry).
///
/// See [`crate::client::fluent_builders::GetNetworkTelemetry`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetNetworkTelemetry {
    _private: (),
}
impl GetNetworkTelemetry {
    /// Creates a new builder-style object to manufacture [`GetNetworkTelemetryInput`](crate::input::GetNetworkTelemetryInput)
    pub fn builder() -> crate::input::get_network_telemetry_input::Builder {
        crate::input::get_network_telemetry_input::Builder::default()
    }
    /// Creates a new `GetNetworkTelemetry` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetNetworkTelemetry {
    type Output = std::result::Result<
        crate::output::GetNetworkTelemetryOutput,
        crate::error::GetNetworkTelemetryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_network_telemetry_error(response)
        } else {
            crate::operation_deser::parse_get_network_telemetry_response(response)
        }
    }
}

/// Operation shape for `GetResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resource_policy`](crate::client::Client::get_resource_policy).
///
/// See [`crate::client::fluent_builders::GetResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResourcePolicy {
    _private: (),
}
impl GetResourcePolicy {
    /// Creates a new builder-style object to manufacture [`GetResourcePolicyInput`](crate::input::GetResourcePolicyInput)
    pub fn builder() -> crate::input::get_resource_policy_input::Builder {
        crate::input::get_resource_policy_input::Builder::default()
    }
    /// Creates a new `GetResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResourcePolicy {
    type Output = std::result::Result<
        crate::output::GetResourcePolicyOutput,
        crate::error::GetResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_get_resource_policy_response(response)
        }
    }
}

/// Operation shape for `GetRouteAnalysis`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_route_analysis`](crate::client::Client::get_route_analysis).
///
/// See [`crate::client::fluent_builders::GetRouteAnalysis`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRouteAnalysis {
    _private: (),
}
impl GetRouteAnalysis {
    /// Creates a new builder-style object to manufacture [`GetRouteAnalysisInput`](crate::input::GetRouteAnalysisInput)
    pub fn builder() -> crate::input::get_route_analysis_input::Builder {
        crate::input::get_route_analysis_input::Builder::default()
    }
    /// Creates a new `GetRouteAnalysis` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRouteAnalysis {
    type Output = std::result::Result<
        crate::output::GetRouteAnalysisOutput,
        crate::error::GetRouteAnalysisError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_route_analysis_error(response)
        } else {
            crate::operation_deser::parse_get_route_analysis_response(response)
        }
    }
}

/// Operation shape for `GetSites`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_sites`](crate::client::Client::get_sites).
///
/// See [`crate::client::fluent_builders::GetSites`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSites {
    _private: (),
}
impl GetSites {
    /// Creates a new builder-style object to manufacture [`GetSitesInput`](crate::input::GetSitesInput)
    pub fn builder() -> crate::input::get_sites_input::Builder {
        crate::input::get_sites_input::Builder::default()
    }
    /// Creates a new `GetSites` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSites {
    type Output = std::result::Result<crate::output::GetSitesOutput, crate::error::GetSitesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_sites_error(response)
        } else {
            crate::operation_deser::parse_get_sites_response(response)
        }
    }
}

/// Operation shape for `GetSiteToSiteVpnAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_site_to_site_vpn_attachment`](crate::client::Client::get_site_to_site_vpn_attachment).
///
/// See [`crate::client::fluent_builders::GetSiteToSiteVpnAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSiteToSiteVpnAttachment {
    _private: (),
}
impl GetSiteToSiteVpnAttachment {
    /// Creates a new builder-style object to manufacture [`GetSiteToSiteVpnAttachmentInput`](crate::input::GetSiteToSiteVpnAttachmentInput)
    pub fn builder() -> crate::input::get_site_to_site_vpn_attachment_input::Builder {
        crate::input::get_site_to_site_vpn_attachment_input::Builder::default()
    }
    /// Creates a new `GetSiteToSiteVpnAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSiteToSiteVpnAttachment {
    type Output = std::result::Result<
        crate::output::GetSiteToSiteVpnAttachmentOutput,
        crate::error::GetSiteToSiteVpnAttachmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_site_to_site_vpn_attachment_error(response)
        } else {
            crate::operation_deser::parse_get_site_to_site_vpn_attachment_response(response)
        }
    }
}

/// Operation shape for `GetTransitGatewayConnectPeerAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_transit_gateway_connect_peer_associations`](crate::client::Client::get_transit_gateway_connect_peer_associations).
///
/// See [`crate::client::fluent_builders::GetTransitGatewayConnectPeerAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTransitGatewayConnectPeerAssociations {
    _private: (),
}
impl GetTransitGatewayConnectPeerAssociations {
    /// Creates a new builder-style object to manufacture [`GetTransitGatewayConnectPeerAssociationsInput`](crate::input::GetTransitGatewayConnectPeerAssociationsInput)
    pub fn builder() -> crate::input::get_transit_gateway_connect_peer_associations_input::Builder {
        crate::input::get_transit_gateway_connect_peer_associations_input::Builder::default()
    }
    /// Creates a new `GetTransitGatewayConnectPeerAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTransitGatewayConnectPeerAssociations {
    type Output = std::result::Result<
        crate::output::GetTransitGatewayConnectPeerAssociationsOutput,
        crate::error::GetTransitGatewayConnectPeerAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_transit_gateway_connect_peer_associations_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_transit_gateway_connect_peer_associations_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetTransitGatewayRegistrations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_transit_gateway_registrations`](crate::client::Client::get_transit_gateway_registrations).
///
/// See [`crate::client::fluent_builders::GetTransitGatewayRegistrations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTransitGatewayRegistrations {
    _private: (),
}
impl GetTransitGatewayRegistrations {
    /// Creates a new builder-style object to manufacture [`GetTransitGatewayRegistrationsInput`](crate::input::GetTransitGatewayRegistrationsInput)
    pub fn builder() -> crate::input::get_transit_gateway_registrations_input::Builder {
        crate::input::get_transit_gateway_registrations_input::Builder::default()
    }
    /// Creates a new `GetTransitGatewayRegistrations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTransitGatewayRegistrations {
    type Output = std::result::Result<
        crate::output::GetTransitGatewayRegistrationsOutput,
        crate::error::GetTransitGatewayRegistrationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_transit_gateway_registrations_error(response)
        } else {
            crate::operation_deser::parse_get_transit_gateway_registrations_response(response)
        }
    }
}

/// Operation shape for `GetVpcAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_vpc_attachment`](crate::client::Client::get_vpc_attachment).
///
/// See [`crate::client::fluent_builders::GetVpcAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVpcAttachment {
    _private: (),
}
impl GetVpcAttachment {
    /// Creates a new builder-style object to manufacture [`GetVpcAttachmentInput`](crate::input::GetVpcAttachmentInput)
    pub fn builder() -> crate::input::get_vpc_attachment_input::Builder {
        crate::input::get_vpc_attachment_input::Builder::default()
    }
    /// Creates a new `GetVpcAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVpcAttachment {
    type Output = std::result::Result<
        crate::output::GetVpcAttachmentOutput,
        crate::error::GetVpcAttachmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_vpc_attachment_error(response)
        } else {
            crate::operation_deser::parse_get_vpc_attachment_response(response)
        }
    }
}

/// Operation shape for `ListAttachments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_attachments`](crate::client::Client::list_attachments).
///
/// See [`crate::client::fluent_builders::ListAttachments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAttachments {
    _private: (),
}
impl ListAttachments {
    /// Creates a new builder-style object to manufacture [`ListAttachmentsInput`](crate::input::ListAttachmentsInput)
    pub fn builder() -> crate::input::list_attachments_input::Builder {
        crate::input::list_attachments_input::Builder::default()
    }
    /// Creates a new `ListAttachments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAttachments {
    type Output = std::result::Result<
        crate::output::ListAttachmentsOutput,
        crate::error::ListAttachmentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_attachments_error(response)
        } else {
            crate::operation_deser::parse_list_attachments_response(response)
        }
    }
}

/// Operation shape for `ListConnectPeers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_connect_peers`](crate::client::Client::list_connect_peers).
///
/// See [`crate::client::fluent_builders::ListConnectPeers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListConnectPeers {
    _private: (),
}
impl ListConnectPeers {
    /// Creates a new builder-style object to manufacture [`ListConnectPeersInput`](crate::input::ListConnectPeersInput)
    pub fn builder() -> crate::input::list_connect_peers_input::Builder {
        crate::input::list_connect_peers_input::Builder::default()
    }
    /// Creates a new `ListConnectPeers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListConnectPeers {
    type Output = std::result::Result<
        crate::output::ListConnectPeersOutput,
        crate::error::ListConnectPeersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_connect_peers_error(response)
        } else {
            crate::operation_deser::parse_list_connect_peers_response(response)
        }
    }
}

/// Operation shape for `ListCoreNetworkPolicyVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_core_network_policy_versions`](crate::client::Client::list_core_network_policy_versions).
///
/// See [`crate::client::fluent_builders::ListCoreNetworkPolicyVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCoreNetworkPolicyVersions {
    _private: (),
}
impl ListCoreNetworkPolicyVersions {
    /// Creates a new builder-style object to manufacture [`ListCoreNetworkPolicyVersionsInput`](crate::input::ListCoreNetworkPolicyVersionsInput)
    pub fn builder() -> crate::input::list_core_network_policy_versions_input::Builder {
        crate::input::list_core_network_policy_versions_input::Builder::default()
    }
    /// Creates a new `ListCoreNetworkPolicyVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCoreNetworkPolicyVersions {
    type Output = std::result::Result<
        crate::output::ListCoreNetworkPolicyVersionsOutput,
        crate::error::ListCoreNetworkPolicyVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_core_network_policy_versions_error(response)
        } else {
            crate::operation_deser::parse_list_core_network_policy_versions_response(response)
        }
    }
}

/// Operation shape for `ListCoreNetworks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_core_networks`](crate::client::Client::list_core_networks).
///
/// See [`crate::client::fluent_builders::ListCoreNetworks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCoreNetworks {
    _private: (),
}
impl ListCoreNetworks {
    /// Creates a new builder-style object to manufacture [`ListCoreNetworksInput`](crate::input::ListCoreNetworksInput)
    pub fn builder() -> crate::input::list_core_networks_input::Builder {
        crate::input::list_core_networks_input::Builder::default()
    }
    /// Creates a new `ListCoreNetworks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCoreNetworks {
    type Output = std::result::Result<
        crate::output::ListCoreNetworksOutput,
        crate::error::ListCoreNetworksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_core_networks_error(response)
        } else {
            crate::operation_deser::parse_list_core_networks_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutCoreNetworkPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_core_network_policy`](crate::client::Client::put_core_network_policy).
///
/// See [`crate::client::fluent_builders::PutCoreNetworkPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutCoreNetworkPolicy {
    _private: (),
}
impl PutCoreNetworkPolicy {
    /// Creates a new builder-style object to manufacture [`PutCoreNetworkPolicyInput`](crate::input::PutCoreNetworkPolicyInput)
    pub fn builder() -> crate::input::put_core_network_policy_input::Builder {
        crate::input::put_core_network_policy_input::Builder::default()
    }
    /// Creates a new `PutCoreNetworkPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutCoreNetworkPolicy {
    type Output = std::result::Result<
        crate::output::PutCoreNetworkPolicyOutput,
        crate::error::PutCoreNetworkPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_core_network_policy_error(response)
        } else {
            crate::operation_deser::parse_put_core_network_policy_response(response)
        }
    }
}

/// Operation shape for `PutResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_resource_policy`](crate::client::Client::put_resource_policy).
///
/// See [`crate::client::fluent_builders::PutResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutResourcePolicy {
    _private: (),
}
impl PutResourcePolicy {
    /// Creates a new builder-style object to manufacture [`PutResourcePolicyInput`](crate::input::PutResourcePolicyInput)
    pub fn builder() -> crate::input::put_resource_policy_input::Builder {
        crate::input::put_resource_policy_input::Builder::default()
    }
    /// Creates a new `PutResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutResourcePolicy {
    type Output = std::result::Result<
        crate::output::PutResourcePolicyOutput,
        crate::error::PutResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_put_resource_policy_response(response)
        }
    }
}

/// Operation shape for `RegisterTransitGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_transit_gateway`](crate::client::Client::register_transit_gateway).
///
/// See [`crate::client::fluent_builders::RegisterTransitGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterTransitGateway {
    _private: (),
}
impl RegisterTransitGateway {
    /// Creates a new builder-style object to manufacture [`RegisterTransitGatewayInput`](crate::input::RegisterTransitGatewayInput)
    pub fn builder() -> crate::input::register_transit_gateway_input::Builder {
        crate::input::register_transit_gateway_input::Builder::default()
    }
    /// Creates a new `RegisterTransitGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterTransitGateway {
    type Output = std::result::Result<
        crate::output::RegisterTransitGatewayOutput,
        crate::error::RegisterTransitGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_transit_gateway_error(response)
        } else {
            crate::operation_deser::parse_register_transit_gateway_response(response)
        }
    }
}

/// Operation shape for `RejectAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_attachment`](crate::client::Client::reject_attachment).
///
/// See [`crate::client::fluent_builders::RejectAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectAttachment {
    _private: (),
}
impl RejectAttachment {
    /// Creates a new builder-style object to manufacture [`RejectAttachmentInput`](crate::input::RejectAttachmentInput)
    pub fn builder() -> crate::input::reject_attachment_input::Builder {
        crate::input::reject_attachment_input::Builder::default()
    }
    /// Creates a new `RejectAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RejectAttachment {
    type Output = std::result::Result<
        crate::output::RejectAttachmentOutput,
        crate::error::RejectAttachmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_attachment_error(response)
        } else {
            crate::operation_deser::parse_reject_attachment_response(response)
        }
    }
}

/// Operation shape for `RestoreCoreNetworkPolicyVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_core_network_policy_version`](crate::client::Client::restore_core_network_policy_version).
///
/// See [`crate::client::fluent_builders::RestoreCoreNetworkPolicyVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreCoreNetworkPolicyVersion {
    _private: (),
}
impl RestoreCoreNetworkPolicyVersion {
    /// Creates a new builder-style object to manufacture [`RestoreCoreNetworkPolicyVersionInput`](crate::input::RestoreCoreNetworkPolicyVersionInput)
    pub fn builder() -> crate::input::restore_core_network_policy_version_input::Builder {
        crate::input::restore_core_network_policy_version_input::Builder::default()
    }
    /// Creates a new `RestoreCoreNetworkPolicyVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreCoreNetworkPolicyVersion {
    type Output = std::result::Result<
        crate::output::RestoreCoreNetworkPolicyVersionOutput,
        crate::error::RestoreCoreNetworkPolicyVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_core_network_policy_version_error(response)
        } else {
            crate::operation_deser::parse_restore_core_network_policy_version_response(response)
        }
    }
}

/// Operation shape for `StartRouteAnalysis`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_route_analysis`](crate::client::Client::start_route_analysis).
///
/// See [`crate::client::fluent_builders::StartRouteAnalysis`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartRouteAnalysis {
    _private: (),
}
impl StartRouteAnalysis {
    /// Creates a new builder-style object to manufacture [`StartRouteAnalysisInput`](crate::input::StartRouteAnalysisInput)
    pub fn builder() -> crate::input::start_route_analysis_input::Builder {
        crate::input::start_route_analysis_input::Builder::default()
    }
    /// Creates a new `StartRouteAnalysis` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartRouteAnalysis {
    type Output = std::result::Result<
        crate::output::StartRouteAnalysisOutput,
        crate::error::StartRouteAnalysisError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_route_analysis_error(response)
        } else {
            crate::operation_deser::parse_start_route_analysis_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_connection`](crate::client::Client::update_connection).
///
/// See [`crate::client::fluent_builders::UpdateConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateConnection {
    _private: (),
}
impl UpdateConnection {
    /// Creates a new builder-style object to manufacture [`UpdateConnectionInput`](crate::input::UpdateConnectionInput)
    pub fn builder() -> crate::input::update_connection_input::Builder {
        crate::input::update_connection_input::Builder::default()
    }
    /// Creates a new `UpdateConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateConnection {
    type Output = std::result::Result<
        crate::output::UpdateConnectionOutput,
        crate::error::UpdateConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_connection_error(response)
        } else {
            crate::operation_deser::parse_update_connection_response(response)
        }
    }
}

/// Operation shape for `UpdateCoreNetwork`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_core_network`](crate::client::Client::update_core_network).
///
/// See [`crate::client::fluent_builders::UpdateCoreNetwork`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCoreNetwork {
    _private: (),
}
impl UpdateCoreNetwork {
    /// Creates a new builder-style object to manufacture [`UpdateCoreNetworkInput`](crate::input::UpdateCoreNetworkInput)
    pub fn builder() -> crate::input::update_core_network_input::Builder {
        crate::input::update_core_network_input::Builder::default()
    }
    /// Creates a new `UpdateCoreNetwork` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCoreNetwork {
    type Output = std::result::Result<
        crate::output::UpdateCoreNetworkOutput,
        crate::error::UpdateCoreNetworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_core_network_error(response)
        } else {
            crate::operation_deser::parse_update_core_network_response(response)
        }
    }
}

/// Operation shape for `UpdateDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_device`](crate::client::Client::update_device).
///
/// See [`crate::client::fluent_builders::UpdateDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDevice {
    _private: (),
}
impl UpdateDevice {
    /// Creates a new builder-style object to manufacture [`UpdateDeviceInput`](crate::input::UpdateDeviceInput)
    pub fn builder() -> crate::input::update_device_input::Builder {
        crate::input::update_device_input::Builder::default()
    }
    /// Creates a new `UpdateDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDevice {
    type Output =
        std::result::Result<crate::output::UpdateDeviceOutput, crate::error::UpdateDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_device_error(response)
        } else {
            crate::operation_deser::parse_update_device_response(response)
        }
    }
}

/// Operation shape for `UpdateGlobalNetwork`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_global_network`](crate::client::Client::update_global_network).
///
/// See [`crate::client::fluent_builders::UpdateGlobalNetwork`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGlobalNetwork {
    _private: (),
}
impl UpdateGlobalNetwork {
    /// Creates a new builder-style object to manufacture [`UpdateGlobalNetworkInput`](crate::input::UpdateGlobalNetworkInput)
    pub fn builder() -> crate::input::update_global_network_input::Builder {
        crate::input::update_global_network_input::Builder::default()
    }
    /// Creates a new `UpdateGlobalNetwork` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGlobalNetwork {
    type Output = std::result::Result<
        crate::output::UpdateGlobalNetworkOutput,
        crate::error::UpdateGlobalNetworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_global_network_error(response)
        } else {
            crate::operation_deser::parse_update_global_network_response(response)
        }
    }
}

/// Operation shape for `UpdateLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_link`](crate::client::Client::update_link).
///
/// See [`crate::client::fluent_builders::UpdateLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLink {
    _private: (),
}
impl UpdateLink {
    /// Creates a new builder-style object to manufacture [`UpdateLinkInput`](crate::input::UpdateLinkInput)
    pub fn builder() -> crate::input::update_link_input::Builder {
        crate::input::update_link_input::Builder::default()
    }
    /// Creates a new `UpdateLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLink {
    type Output =
        std::result::Result<crate::output::UpdateLinkOutput, crate::error::UpdateLinkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_link_error(response)
        } else {
            crate::operation_deser::parse_update_link_response(response)
        }
    }
}

/// Operation shape for `UpdateNetworkResourceMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_network_resource_metadata`](crate::client::Client::update_network_resource_metadata).
///
/// See [`crate::client::fluent_builders::UpdateNetworkResourceMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateNetworkResourceMetadata {
    _private: (),
}
impl UpdateNetworkResourceMetadata {
    /// Creates a new builder-style object to manufacture [`UpdateNetworkResourceMetadataInput`](crate::input::UpdateNetworkResourceMetadataInput)
    pub fn builder() -> crate::input::update_network_resource_metadata_input::Builder {
        crate::input::update_network_resource_metadata_input::Builder::default()
    }
    /// Creates a new `UpdateNetworkResourceMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateNetworkResourceMetadata {
    type Output = std::result::Result<
        crate::output::UpdateNetworkResourceMetadataOutput,
        crate::error::UpdateNetworkResourceMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_network_resource_metadata_error(response)
        } else {
            crate::operation_deser::parse_update_network_resource_metadata_response(response)
        }
    }
}

/// Operation shape for `UpdateSite`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_site`](crate::client::Client::update_site).
///
/// See [`crate::client::fluent_builders::UpdateSite`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSite {
    _private: (),
}
impl UpdateSite {
    /// Creates a new builder-style object to manufacture [`UpdateSiteInput`](crate::input::UpdateSiteInput)
    pub fn builder() -> crate::input::update_site_input::Builder {
        crate::input::update_site_input::Builder::default()
    }
    /// Creates a new `UpdateSite` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSite {
    type Output =
        std::result::Result<crate::output::UpdateSiteOutput, crate::error::UpdateSiteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_site_error(response)
        } else {
            crate::operation_deser::parse_update_site_response(response)
        }
    }
}

/// Operation shape for `UpdateVpcAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_vpc_attachment`](crate::client::Client::update_vpc_attachment).
///
/// See [`crate::client::fluent_builders::UpdateVpcAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateVpcAttachment {
    _private: (),
}
impl UpdateVpcAttachment {
    /// Creates a new builder-style object to manufacture [`UpdateVpcAttachmentInput`](crate::input::UpdateVpcAttachmentInput)
    pub fn builder() -> crate::input::update_vpc_attachment_input::Builder {
        crate::input::update_vpc_attachment_input::Builder::default()
    }
    /// Creates a new `UpdateVpcAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateVpcAttachment {
    type Output = std::result::Result<
        crate::output::UpdateVpcAttachmentOutput,
        crate::error::UpdateVpcAttachmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_vpc_attachment_error(response)
        } else {
            crate::operation_deser::parse_update_vpc_attachment_response(response)
        }
    }
}
