// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptAttachmentError {
    /// Kind of error that occurred.
    pub kind: AcceptAttachmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptAttachmentErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptAttachmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptAttachmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AcceptAttachmentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AcceptAttachmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AcceptAttachmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AcceptAttachmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AcceptAttachmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AcceptAttachmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcceptAttachmentError {
    fn code(&self) -> Option<&str> {
        AcceptAttachmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcceptAttachmentError {
    /// Creates a new `AcceptAttachmentError`.
    pub fn new(kind: AcceptAttachmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptAttachmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptAttachmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptAttachmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptAttachmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AcceptAttachmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptAttachmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptAttachmentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, AcceptAttachmentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `AcceptAttachmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptAttachmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptAttachmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptAttachmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptAttachmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptAttachmentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptAttachmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptAttachmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AcceptAttachmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptAttachmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AcceptAttachmentErrorKind::ConflictException(_inner) => Some(_inner),
            AcceptAttachmentErrorKind::InternalServerException(_inner) => Some(_inner),
            AcceptAttachmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AcceptAttachmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            AcceptAttachmentErrorKind::ValidationException(_inner) => Some(_inner),
            AcceptAttachmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateConnectPeer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateConnectPeerError {
    /// Kind of error that occurred.
    pub kind: AssociateConnectPeerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateConnectPeer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateConnectPeerErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A service limit was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateConnectPeerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateConnectPeerErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociateConnectPeerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AssociateConnectPeerErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AssociateConnectPeerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateConnectPeerErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            AssociateConnectPeerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateConnectPeerErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociateConnectPeerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateConnectPeerError {
    fn code(&self) -> Option<&str> {
        AssociateConnectPeerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateConnectPeerError {
    /// Creates a new `AssociateConnectPeerError`.
    pub fn new(kind: AssociateConnectPeerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateConnectPeerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateConnectPeerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateConnectPeerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateConnectPeerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateConnectPeerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateConnectPeerErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateConnectPeerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateConnectPeerErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateConnectPeerErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateConnectPeerErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateConnectPeerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateConnectPeerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateConnectPeerErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateConnectPeerErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateConnectPeerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateConnectPeerErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateConnectPeerErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateConnectPeerErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateConnectPeerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateConnectPeerErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociateConnectPeerErrorKind::ConflictException(_inner) => Some(_inner),
            AssociateConnectPeerErrorKind::InternalServerException(_inner) => Some(_inner),
            AssociateConnectPeerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateConnectPeerErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            AssociateConnectPeerErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateConnectPeerErrorKind::ValidationException(_inner) => Some(_inner),
            AssociateConnectPeerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateCustomerGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateCustomerGatewayError {
    /// Kind of error that occurred.
    pub kind: AssociateCustomerGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateCustomerGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateCustomerGatewayErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A service limit was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateCustomerGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateCustomerGatewayErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociateCustomerGatewayErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AssociateCustomerGatewayErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AssociateCustomerGatewayErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateCustomerGatewayErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            AssociateCustomerGatewayErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateCustomerGatewayErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociateCustomerGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateCustomerGatewayError {
    fn code(&self) -> Option<&str> {
        AssociateCustomerGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateCustomerGatewayError {
    /// Creates a new `AssociateCustomerGatewayError`.
    pub fn new(kind: AssociateCustomerGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateCustomerGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateCustomerGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateCustomerGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateCustomerGatewayErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateCustomerGatewayErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCustomerGatewayErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateCustomerGatewayErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCustomerGatewayErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateCustomerGatewayErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCustomerGatewayErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateCustomerGatewayErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCustomerGatewayErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateCustomerGatewayErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCustomerGatewayErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateCustomerGatewayErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCustomerGatewayErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateCustomerGatewayErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCustomerGatewayErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateCustomerGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateCustomerGatewayErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociateCustomerGatewayErrorKind::ConflictException(_inner) => Some(_inner),
            AssociateCustomerGatewayErrorKind::InternalServerException(_inner) => Some(_inner),
            AssociateCustomerGatewayErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateCustomerGatewayErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            AssociateCustomerGatewayErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateCustomerGatewayErrorKind::ValidationException(_inner) => Some(_inner),
            AssociateCustomerGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateLinkError {
    /// Kind of error that occurred.
    pub kind: AssociateLinkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateLinkErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A service limit was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateLinkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateLinkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociateLinkErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AssociateLinkErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AssociateLinkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateLinkErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            AssociateLinkErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateLinkErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociateLinkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateLinkError {
    fn code(&self) -> Option<&str> {
        AssociateLinkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateLinkError {
    /// Creates a new `AssociateLinkError`.
    pub fn new(kind: AssociateLinkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateLinkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateLinkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateLinkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateLinkErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateLinkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, AssociateLinkErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `AssociateLinkErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, AssociateLinkErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `AssociateLinkErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLinkErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateLinkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLinkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateLinkErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLinkErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateLinkErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, AssociateLinkErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `AssociateLinkErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, AssociateLinkErrorKind::ValidationException(_))
    }
}
impl std::error::Error for AssociateLinkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateLinkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociateLinkErrorKind::ConflictException(_inner) => Some(_inner),
            AssociateLinkErrorKind::InternalServerException(_inner) => Some(_inner),
            AssociateLinkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateLinkErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            AssociateLinkErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateLinkErrorKind::ValidationException(_inner) => Some(_inner),
            AssociateLinkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateTransitGatewayConnectPeer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateTransitGatewayConnectPeerError {
    /// Kind of error that occurred.
    pub kind: AssociateTransitGatewayConnectPeerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateTransitGatewayConnectPeer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateTransitGatewayConnectPeerErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A service limit was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateTransitGatewayConnectPeerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateTransitGatewayConnectPeerErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            AssociateTransitGatewayConnectPeerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AssociateTransitGatewayConnectPeerErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            AssociateTransitGatewayConnectPeerErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateTransitGatewayConnectPeerErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            AssociateTransitGatewayConnectPeerErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            AssociateTransitGatewayConnectPeerErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            AssociateTransitGatewayConnectPeerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateTransitGatewayConnectPeerError {
    fn code(&self) -> Option<&str> {
        AssociateTransitGatewayConnectPeerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateTransitGatewayConnectPeerError {
    /// Creates a new `AssociateTransitGatewayConnectPeerError`.
    pub fn new(
        kind: AssociateTransitGatewayConnectPeerErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateTransitGatewayConnectPeerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateTransitGatewayConnectPeerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateTransitGatewayConnectPeerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateTransitGatewayConnectPeerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateTransitGatewayConnectPeerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTransitGatewayConnectPeerErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTransitGatewayConnectPeerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTransitGatewayConnectPeerErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTransitGatewayConnectPeerErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTransitGatewayConnectPeerErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTransitGatewayConnectPeerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTransitGatewayConnectPeerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTransitGatewayConnectPeerErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTransitGatewayConnectPeerErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTransitGatewayConnectPeerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTransitGatewayConnectPeerErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTransitGatewayConnectPeerErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTransitGatewayConnectPeerErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateTransitGatewayConnectPeerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateTransitGatewayConnectPeerErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            AssociateTransitGatewayConnectPeerErrorKind::ConflictException(_inner) => Some(_inner),
            AssociateTransitGatewayConnectPeerErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            AssociateTransitGatewayConnectPeerErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateTransitGatewayConnectPeerErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            AssociateTransitGatewayConnectPeerErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            AssociateTransitGatewayConnectPeerErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            AssociateTransitGatewayConnectPeerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConnectAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConnectAttachmentError {
    /// Kind of error that occurred.
    pub kind: CreateConnectAttachmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConnectAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConnectAttachmentErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConnectAttachmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConnectAttachmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateConnectAttachmentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateConnectAttachmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateConnectAttachmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateConnectAttachmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateConnectAttachmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateConnectAttachmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConnectAttachmentError {
    fn code(&self) -> Option<&str> {
        CreateConnectAttachmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConnectAttachmentError {
    /// Creates a new `CreateConnectAttachmentError`.
    pub fn new(kind: CreateConnectAttachmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConnectAttachmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConnectAttachmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConnectAttachmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConnectAttachmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateConnectAttachmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectAttachmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectAttachmentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectAttachmentErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectAttachmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectAttachmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectAttachmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectAttachmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectAttachmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectAttachmentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectAttachmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectAttachmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateConnectAttachmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConnectAttachmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateConnectAttachmentErrorKind::ConflictException(_inner) => Some(_inner),
            CreateConnectAttachmentErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateConnectAttachmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateConnectAttachmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateConnectAttachmentErrorKind::ValidationException(_inner) => Some(_inner),
            CreateConnectAttachmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConnectionError {
    /// Kind of error that occurred.
    pub kind: CreateConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConnectionErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A service limit was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConnectionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConnectionError {
    fn code(&self) -> Option<&str> {
        CreateConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConnectionError {
    /// Creates a new `CreateConnectionError`.
    pub fn new(kind: CreateConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateConnectionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateConnectionErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateConnectionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConnectionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateConnectionErrorKind::ConflictException(_inner) => Some(_inner),
            CreateConnectionErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateConnectionErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateConnectionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateConnectionErrorKind::ValidationException(_inner) => Some(_inner),
            CreateConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConnectPeer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConnectPeerError {
    /// Kind of error that occurred.
    pub kind: CreateConnectPeerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConnectPeer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConnectPeerErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConnectPeerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConnectPeerErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateConnectPeerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateConnectPeerErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateConnectPeerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateConnectPeerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateConnectPeerErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateConnectPeerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConnectPeerError {
    fn code(&self) -> Option<&str> {
        CreateConnectPeerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConnectPeerError {
    /// Creates a new `CreateConnectPeerError`.
    pub fn new(kind: CreateConnectPeerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConnectPeerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConnectPeerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConnectPeerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConnectPeerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateConnectPeerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectPeerErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectPeerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateConnectPeerErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateConnectPeerErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectPeerErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectPeerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectPeerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectPeerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectPeerErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectPeerErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectPeerErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateConnectPeerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConnectPeerErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateConnectPeerErrorKind::ConflictException(_inner) => Some(_inner),
            CreateConnectPeerErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateConnectPeerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateConnectPeerErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateConnectPeerErrorKind::ValidationException(_inner) => Some(_inner),
            CreateConnectPeerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCoreNetwork` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCoreNetworkError {
    /// Kind of error that occurred.
    pub kind: CreateCoreNetworkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCoreNetwork` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCoreNetworkErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Describes a core network policy exception.</p>
    CoreNetworkPolicyException(crate::error::CoreNetworkPolicyException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A service limit was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCoreNetworkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCoreNetworkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateCoreNetworkErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateCoreNetworkErrorKind::CoreNetworkPolicyException(_inner) => _inner.fmt(f),
            CreateCoreNetworkErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateCoreNetworkErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateCoreNetworkErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateCoreNetworkErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateCoreNetworkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCoreNetworkError {
    fn code(&self) -> Option<&str> {
        CreateCoreNetworkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCoreNetworkError {
    /// Creates a new `CreateCoreNetworkError`.
    pub fn new(kind: CreateCoreNetworkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCoreNetworkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCoreNetworkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCoreNetworkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCoreNetworkErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCoreNetworkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCoreNetworkErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCoreNetworkErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateCoreNetworkErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateCoreNetworkErrorKind::CoreNetworkPolicyException`.
    pub fn is_core_network_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCoreNetworkErrorKind::CoreNetworkPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCoreNetworkErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCoreNetworkErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCoreNetworkErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCoreNetworkErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCoreNetworkErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCoreNetworkErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCoreNetworkErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCoreNetworkErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateCoreNetworkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCoreNetworkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateCoreNetworkErrorKind::ConflictException(_inner) => Some(_inner),
            CreateCoreNetworkErrorKind::CoreNetworkPolicyException(_inner) => Some(_inner),
            CreateCoreNetworkErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateCoreNetworkErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateCoreNetworkErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateCoreNetworkErrorKind::ValidationException(_inner) => Some(_inner),
            CreateCoreNetworkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDeviceError {
    /// Kind of error that occurred.
    pub kind: CreateDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDeviceErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A service limit was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDeviceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDeviceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateDeviceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDeviceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateDeviceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDeviceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDeviceError {
    fn code(&self) -> Option<&str> {
        CreateDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDeviceError {
    /// Creates a new `CreateDeviceError`.
    pub fn new(kind: CreateDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDeviceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDeviceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateDeviceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateDeviceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateDeviceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateDeviceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeviceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeviceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeviceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeviceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateDeviceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateDeviceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateDeviceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDeviceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDeviceErrorKind::ConflictException(_inner) => Some(_inner),
            CreateDeviceErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDeviceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateDeviceErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDeviceErrorKind::ValidationException(_inner) => Some(_inner),
            CreateDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGlobalNetwork` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGlobalNetworkError {
    /// Kind of error that occurred.
    pub kind: CreateGlobalNetworkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGlobalNetwork` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGlobalNetworkErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A service limit was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGlobalNetworkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGlobalNetworkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateGlobalNetworkErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateGlobalNetworkErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateGlobalNetworkErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateGlobalNetworkErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateGlobalNetworkErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateGlobalNetworkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGlobalNetworkError {
    fn code(&self) -> Option<&str> {
        CreateGlobalNetworkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGlobalNetworkError {
    /// Creates a new `CreateGlobalNetworkError`.
    pub fn new(kind: CreateGlobalNetworkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGlobalNetworkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGlobalNetworkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGlobalNetworkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGlobalNetworkErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateGlobalNetworkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGlobalNetworkErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGlobalNetworkErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGlobalNetworkErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGlobalNetworkErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGlobalNetworkErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGlobalNetworkErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGlobalNetworkErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGlobalNetworkErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGlobalNetworkErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGlobalNetworkErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGlobalNetworkErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateGlobalNetworkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGlobalNetworkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateGlobalNetworkErrorKind::ConflictException(_inner) => Some(_inner),
            CreateGlobalNetworkErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateGlobalNetworkErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateGlobalNetworkErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateGlobalNetworkErrorKind::ValidationException(_inner) => Some(_inner),
            CreateGlobalNetworkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLinkError {
    /// Kind of error that occurred.
    pub kind: CreateLinkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLinkErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A service limit was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLinkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLinkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateLinkErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateLinkErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateLinkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateLinkErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateLinkErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateLinkErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateLinkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLinkError {
    fn code(&self) -> Option<&str> {
        CreateLinkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLinkError {
    /// Creates a new `CreateLinkError`.
    pub fn new(kind: CreateLinkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLinkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLinkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLinkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLinkErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLinkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateLinkErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateLinkErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateLinkErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateLinkErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreateLinkErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `CreateLinkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLinkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLinkErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLinkErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLinkErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateLinkErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateLinkErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateLinkErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateLinkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLinkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateLinkErrorKind::ConflictException(_inner) => Some(_inner),
            CreateLinkErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateLinkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateLinkErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateLinkErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateLinkErrorKind::ValidationException(_inner) => Some(_inner),
            CreateLinkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSite` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSiteError {
    /// Kind of error that occurred.
    pub kind: CreateSiteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSite` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSiteErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A service limit was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSiteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSiteErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateSiteErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateSiteErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateSiteErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateSiteErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateSiteErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateSiteErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateSiteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSiteError {
    fn code(&self) -> Option<&str> {
        CreateSiteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSiteError {
    /// Creates a new `CreateSiteError`.
    pub fn new(kind: CreateSiteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSiteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSiteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSiteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSiteErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSiteErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateSiteErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateSiteErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateSiteErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateSiteErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreateSiteErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `CreateSiteErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSiteErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSiteErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSiteErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSiteErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateSiteErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateSiteErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateSiteErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateSiteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSiteErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateSiteErrorKind::ConflictException(_inner) => Some(_inner),
            CreateSiteErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateSiteErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateSiteErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateSiteErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateSiteErrorKind::ValidationException(_inner) => Some(_inner),
            CreateSiteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSiteToSiteVpnAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSiteToSiteVpnAttachmentError {
    /// Kind of error that occurred.
    pub kind: CreateSiteToSiteVpnAttachmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSiteToSiteVpnAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSiteToSiteVpnAttachmentErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSiteToSiteVpnAttachmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSiteToSiteVpnAttachmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateSiteToSiteVpnAttachmentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateSiteToSiteVpnAttachmentErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            CreateSiteToSiteVpnAttachmentErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateSiteToSiteVpnAttachmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateSiteToSiteVpnAttachmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateSiteToSiteVpnAttachmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSiteToSiteVpnAttachmentError {
    fn code(&self) -> Option<&str> {
        CreateSiteToSiteVpnAttachmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSiteToSiteVpnAttachmentError {
    /// Creates a new `CreateSiteToSiteVpnAttachmentError`.
    pub fn new(
        kind: CreateSiteToSiteVpnAttachmentErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSiteToSiteVpnAttachmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSiteToSiteVpnAttachmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSiteToSiteVpnAttachmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSiteToSiteVpnAttachmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSiteToSiteVpnAttachmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSiteToSiteVpnAttachmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSiteToSiteVpnAttachmentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSiteToSiteVpnAttachmentErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSiteToSiteVpnAttachmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSiteToSiteVpnAttachmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSiteToSiteVpnAttachmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSiteToSiteVpnAttachmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSiteToSiteVpnAttachmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSiteToSiteVpnAttachmentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSiteToSiteVpnAttachmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSiteToSiteVpnAttachmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateSiteToSiteVpnAttachmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSiteToSiteVpnAttachmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateSiteToSiteVpnAttachmentErrorKind::ConflictException(_inner) => Some(_inner),
            CreateSiteToSiteVpnAttachmentErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateSiteToSiteVpnAttachmentErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateSiteToSiteVpnAttachmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateSiteToSiteVpnAttachmentErrorKind::ValidationException(_inner) => Some(_inner),
            CreateSiteToSiteVpnAttachmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateVpcAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateVpcAttachmentError {
    /// Kind of error that occurred.
    pub kind: CreateVpcAttachmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateVpcAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateVpcAttachmentErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateVpcAttachmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateVpcAttachmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateVpcAttachmentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateVpcAttachmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateVpcAttachmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateVpcAttachmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateVpcAttachmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateVpcAttachmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateVpcAttachmentError {
    fn code(&self) -> Option<&str> {
        CreateVpcAttachmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateVpcAttachmentError {
    /// Creates a new `CreateVpcAttachmentError`.
    pub fn new(kind: CreateVpcAttachmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateVpcAttachmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateVpcAttachmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateVpcAttachmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateVpcAttachmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateVpcAttachmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVpcAttachmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVpcAttachmentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVpcAttachmentErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVpcAttachmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVpcAttachmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVpcAttachmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVpcAttachmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVpcAttachmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVpcAttachmentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVpcAttachmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVpcAttachmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateVpcAttachmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateVpcAttachmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateVpcAttachmentErrorKind::ConflictException(_inner) => Some(_inner),
            CreateVpcAttachmentErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateVpcAttachmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateVpcAttachmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateVpcAttachmentErrorKind::ValidationException(_inner) => Some(_inner),
            CreateVpcAttachmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAttachmentError {
    /// Kind of error that occurred.
    pub kind: DeleteAttachmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAttachmentErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAttachmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAttachmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteAttachmentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteAttachmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteAttachmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAttachmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteAttachmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteAttachmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAttachmentError {
    fn code(&self) -> Option<&str> {
        DeleteAttachmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAttachmentError {
    /// Creates a new `DeleteAttachmentError`.
    pub fn new(kind: DeleteAttachmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAttachmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAttachmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAttachmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAttachmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAttachmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAttachmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAttachmentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteAttachmentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteAttachmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAttachmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAttachmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAttachmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAttachmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAttachmentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAttachmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAttachmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteAttachmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAttachmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteAttachmentErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteAttachmentErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteAttachmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAttachmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteAttachmentErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteAttachmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConnectionError {
    /// Kind of error that occurred.
    pub kind: DeleteConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConnectionErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConnectionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteConnectionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteConnectionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteConnectionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteConnectionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteConnectionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConnectionError {
    fn code(&self) -> Option<&str> {
        DeleteConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConnectionError {
    /// Creates a new `DeleteConnectionError`.
    pub fn new(kind: DeleteConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteConnectionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteConnectionErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteConnectionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConnectionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteConnectionErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteConnectionErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteConnectionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteConnectionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteConnectionErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConnectPeer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConnectPeerError {
    /// Kind of error that occurred.
    pub kind: DeleteConnectPeerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConnectPeer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConnectPeerErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConnectPeerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConnectPeerErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteConnectPeerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteConnectPeerErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteConnectPeerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteConnectPeerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteConnectPeerErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteConnectPeerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConnectPeerError {
    fn code(&self) -> Option<&str> {
        DeleteConnectPeerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConnectPeerError {
    /// Creates a new `DeleteConnectPeerError`.
    pub fn new(kind: DeleteConnectPeerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConnectPeerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConnectPeerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConnectPeerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConnectPeerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteConnectPeerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectPeerErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectPeerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteConnectPeerErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteConnectPeerErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectPeerErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectPeerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectPeerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectPeerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectPeerErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectPeerErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectPeerErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteConnectPeerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConnectPeerErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteConnectPeerErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteConnectPeerErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteConnectPeerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteConnectPeerErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteConnectPeerErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteConnectPeerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCoreNetwork` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCoreNetworkError {
    /// Kind of error that occurred.
    pub kind: DeleteCoreNetworkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCoreNetwork` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCoreNetworkErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCoreNetworkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCoreNetworkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteCoreNetworkErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteCoreNetworkErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteCoreNetworkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteCoreNetworkErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteCoreNetworkErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteCoreNetworkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCoreNetworkError {
    fn code(&self) -> Option<&str> {
        DeleteCoreNetworkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCoreNetworkError {
    /// Creates a new `DeleteCoreNetworkError`.
    pub fn new(kind: DeleteCoreNetworkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCoreNetworkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCoreNetworkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCoreNetworkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCoreNetworkErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCoreNetworkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCoreNetworkErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCoreNetworkErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteCoreNetworkErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteCoreNetworkErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCoreNetworkErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCoreNetworkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCoreNetworkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCoreNetworkErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCoreNetworkErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCoreNetworkErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCoreNetworkErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteCoreNetworkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCoreNetworkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteCoreNetworkErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteCoreNetworkErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteCoreNetworkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteCoreNetworkErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteCoreNetworkErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteCoreNetworkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCoreNetworkPolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCoreNetworkPolicyVersionError {
    /// Kind of error that occurred.
    pub kind: DeleteCoreNetworkPolicyVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCoreNetworkPolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCoreNetworkPolicyVersionErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCoreNetworkPolicyVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCoreNetworkPolicyVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteCoreNetworkPolicyVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteCoreNetworkPolicyVersionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCoreNetworkPolicyVersionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCoreNetworkPolicyVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteCoreNetworkPolicyVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteCoreNetworkPolicyVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCoreNetworkPolicyVersionError {
    fn code(&self) -> Option<&str> {
        DeleteCoreNetworkPolicyVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCoreNetworkPolicyVersionError {
    /// Creates a new `DeleteCoreNetworkPolicyVersionError`.
    pub fn new(
        kind: DeleteCoreNetworkPolicyVersionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCoreNetworkPolicyVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCoreNetworkPolicyVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCoreNetworkPolicyVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCoreNetworkPolicyVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCoreNetworkPolicyVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCoreNetworkPolicyVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCoreNetworkPolicyVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCoreNetworkPolicyVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCoreNetworkPolicyVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCoreNetworkPolicyVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCoreNetworkPolicyVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCoreNetworkPolicyVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCoreNetworkPolicyVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCoreNetworkPolicyVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCoreNetworkPolicyVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCoreNetworkPolicyVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteCoreNetworkPolicyVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCoreNetworkPolicyVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteCoreNetworkPolicyVersionErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteCoreNetworkPolicyVersionErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DeleteCoreNetworkPolicyVersionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteCoreNetworkPolicyVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteCoreNetworkPolicyVersionErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteCoreNetworkPolicyVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDeviceError {
    /// Kind of error that occurred.
    pub kind: DeleteDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDeviceErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDeviceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDeviceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteDeviceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDeviceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDeviceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDeviceError {
    fn code(&self) -> Option<&str> {
        DeleteDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDeviceError {
    /// Creates a new `DeleteDeviceError`.
    pub fn new(kind: DeleteDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDeviceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDeviceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteDeviceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteDeviceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteDeviceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteDeviceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeviceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDeviceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteDeviceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteDeviceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteDeviceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDeviceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDeviceErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteDeviceErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDeviceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDeviceErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGlobalNetwork` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGlobalNetworkError {
    /// Kind of error that occurred.
    pub kind: DeleteGlobalNetworkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGlobalNetwork` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGlobalNetworkErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGlobalNetworkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGlobalNetworkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteGlobalNetworkErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteGlobalNetworkErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteGlobalNetworkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteGlobalNetworkErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteGlobalNetworkErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteGlobalNetworkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGlobalNetworkError {
    fn code(&self) -> Option<&str> {
        DeleteGlobalNetworkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGlobalNetworkError {
    /// Creates a new `DeleteGlobalNetworkError`.
    pub fn new(kind: DeleteGlobalNetworkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGlobalNetworkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGlobalNetworkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGlobalNetworkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGlobalNetworkErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteGlobalNetworkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGlobalNetworkErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGlobalNetworkErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGlobalNetworkErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGlobalNetworkErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGlobalNetworkErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGlobalNetworkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGlobalNetworkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGlobalNetworkErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGlobalNetworkErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGlobalNetworkErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGlobalNetworkErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteGlobalNetworkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGlobalNetworkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteGlobalNetworkErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteGlobalNetworkErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteGlobalNetworkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteGlobalNetworkErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteGlobalNetworkErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteGlobalNetworkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLinkError {
    /// Kind of error that occurred.
    pub kind: DeleteLinkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLinkErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLinkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLinkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteLinkErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteLinkErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteLinkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteLinkErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteLinkErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteLinkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLinkError {
    fn code(&self) -> Option<&str> {
        DeleteLinkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLinkError {
    /// Creates a new `DeleteLinkError`.
    pub fn new(kind: DeleteLinkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLinkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLinkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLinkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLinkErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLinkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteLinkErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteLinkErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteLinkErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteLinkErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteLinkErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteLinkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLinkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLinkErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteLinkErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteLinkErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteLinkErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteLinkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLinkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteLinkErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteLinkErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteLinkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteLinkErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteLinkErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteLinkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourcePolicyErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourcePolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourcePolicyError {
    fn code(&self) -> Option<&str> {
        DeleteResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourcePolicyError {
    /// Creates a new `DeleteResourcePolicyError`.
    pub fn new(kind: DeleteResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourcePolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSite` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSiteError {
    /// Kind of error that occurred.
    pub kind: DeleteSiteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSite` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSiteErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSiteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSiteErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteSiteErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteSiteErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteSiteErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteSiteErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteSiteErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteSiteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSiteError {
    fn code(&self) -> Option<&str> {
        DeleteSiteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSiteError {
    /// Creates a new `DeleteSiteError`.
    pub fn new(kind: DeleteSiteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSiteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSiteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSiteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSiteErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSiteErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteSiteErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteSiteErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteSiteErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteSiteErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteSiteErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteSiteErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSiteErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSiteErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteSiteErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteSiteErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteSiteErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteSiteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSiteErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteSiteErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteSiteErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteSiteErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteSiteErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteSiteErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteSiteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterTransitGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterTransitGatewayError {
    /// Kind of error that occurred.
    pub kind: DeregisterTransitGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterTransitGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterTransitGatewayErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterTransitGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterTransitGatewayErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeregisterTransitGatewayErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeregisterTransitGatewayErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeregisterTransitGatewayErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeregisterTransitGatewayErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeregisterTransitGatewayErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeregisterTransitGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterTransitGatewayError {
    fn code(&self) -> Option<&str> {
        DeregisterTransitGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterTransitGatewayError {
    /// Creates a new `DeregisterTransitGatewayError`.
    pub fn new(kind: DeregisterTransitGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterTransitGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterTransitGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterTransitGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterTransitGatewayErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterTransitGatewayErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterTransitGatewayErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterTransitGatewayErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterTransitGatewayErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterTransitGatewayErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterTransitGatewayErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterTransitGatewayErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterTransitGatewayErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterTransitGatewayErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterTransitGatewayErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterTransitGatewayErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterTransitGatewayErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeregisterTransitGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterTransitGatewayErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeregisterTransitGatewayErrorKind::ConflictException(_inner) => Some(_inner),
            DeregisterTransitGatewayErrorKind::InternalServerException(_inner) => Some(_inner),
            DeregisterTransitGatewayErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeregisterTransitGatewayErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeregisterTransitGatewayErrorKind::ValidationException(_inner) => Some(_inner),
            DeregisterTransitGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeGlobalNetworks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeGlobalNetworksError {
    /// Kind of error that occurred.
    pub kind: DescribeGlobalNetworksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeGlobalNetworks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeGlobalNetworksErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeGlobalNetworksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeGlobalNetworksErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeGlobalNetworksErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeGlobalNetworksErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeGlobalNetworksErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeGlobalNetworksErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeGlobalNetworksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeGlobalNetworksError {
    fn code(&self) -> Option<&str> {
        DescribeGlobalNetworksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeGlobalNetworksError {
    /// Creates a new `DescribeGlobalNetworksError`.
    pub fn new(kind: DescribeGlobalNetworksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeGlobalNetworksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeGlobalNetworksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeGlobalNetworksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeGlobalNetworksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeGlobalNetworksErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGlobalNetworksErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGlobalNetworksErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGlobalNetworksErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGlobalNetworksErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGlobalNetworksErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGlobalNetworksErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGlobalNetworksErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGlobalNetworksErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGlobalNetworksErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeGlobalNetworksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeGlobalNetworksErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeGlobalNetworksErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeGlobalNetworksErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeGlobalNetworksErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeGlobalNetworksErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeGlobalNetworksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateConnectPeer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateConnectPeerError {
    /// Kind of error that occurred.
    pub kind: DisassociateConnectPeerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateConnectPeer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateConnectPeerErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateConnectPeerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateConnectPeerErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisassociateConnectPeerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisassociateConnectPeerErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisassociateConnectPeerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateConnectPeerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateConnectPeerErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisassociateConnectPeerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateConnectPeerError {
    fn code(&self) -> Option<&str> {
        DisassociateConnectPeerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateConnectPeerError {
    /// Creates a new `DisassociateConnectPeerError`.
    pub fn new(kind: DisassociateConnectPeerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateConnectPeerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateConnectPeerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateConnectPeerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateConnectPeerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateConnectPeerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateConnectPeerErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateConnectPeerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateConnectPeerErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateConnectPeerErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateConnectPeerErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateConnectPeerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateConnectPeerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateConnectPeerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateConnectPeerErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateConnectPeerErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateConnectPeerErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateConnectPeerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateConnectPeerErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociateConnectPeerErrorKind::ConflictException(_inner) => Some(_inner),
            DisassociateConnectPeerErrorKind::InternalServerException(_inner) => Some(_inner),
            DisassociateConnectPeerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateConnectPeerErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateConnectPeerErrorKind::ValidationException(_inner) => Some(_inner),
            DisassociateConnectPeerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateCustomerGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateCustomerGatewayError {
    /// Kind of error that occurred.
    pub kind: DisassociateCustomerGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateCustomerGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateCustomerGatewayErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateCustomerGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateCustomerGatewayErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisassociateCustomerGatewayErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisassociateCustomerGatewayErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisassociateCustomerGatewayErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateCustomerGatewayErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateCustomerGatewayErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisassociateCustomerGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateCustomerGatewayError {
    fn code(&self) -> Option<&str> {
        DisassociateCustomerGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateCustomerGatewayError {
    /// Creates a new `DisassociateCustomerGatewayError`.
    pub fn new(kind: DisassociateCustomerGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateCustomerGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateCustomerGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateCustomerGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateCustomerGatewayErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateCustomerGatewayErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCustomerGatewayErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateCustomerGatewayErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCustomerGatewayErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateCustomerGatewayErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCustomerGatewayErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateCustomerGatewayErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCustomerGatewayErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateCustomerGatewayErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCustomerGatewayErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateCustomerGatewayErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCustomerGatewayErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateCustomerGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateCustomerGatewayErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociateCustomerGatewayErrorKind::ConflictException(_inner) => Some(_inner),
            DisassociateCustomerGatewayErrorKind::InternalServerException(_inner) => Some(_inner),
            DisassociateCustomerGatewayErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateCustomerGatewayErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateCustomerGatewayErrorKind::ValidationException(_inner) => Some(_inner),
            DisassociateCustomerGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateLinkError {
    /// Kind of error that occurred.
    pub kind: DisassociateLinkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateLinkErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateLinkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateLinkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisassociateLinkErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisassociateLinkErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisassociateLinkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateLinkErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateLinkErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisassociateLinkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateLinkError {
    fn code(&self) -> Option<&str> {
        DisassociateLinkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateLinkError {
    /// Creates a new `DisassociateLinkError`.
    pub fn new(kind: DisassociateLinkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateLinkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateLinkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateLinkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateLinkErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateLinkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLinkErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateLinkErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DisassociateLinkErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DisassociateLinkErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLinkErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateLinkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLinkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateLinkErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLinkErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateLinkErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLinkErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateLinkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateLinkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociateLinkErrorKind::ConflictException(_inner) => Some(_inner),
            DisassociateLinkErrorKind::InternalServerException(_inner) => Some(_inner),
            DisassociateLinkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateLinkErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateLinkErrorKind::ValidationException(_inner) => Some(_inner),
            DisassociateLinkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateTransitGatewayConnectPeer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateTransitGatewayConnectPeerError {
    /// Kind of error that occurred.
    pub kind: DisassociateTransitGatewayConnectPeerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateTransitGatewayConnectPeer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateTransitGatewayConnectPeerErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateTransitGatewayConnectPeerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateTransitGatewayConnectPeerErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateTransitGatewayConnectPeerErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateTransitGatewayConnectPeerErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateTransitGatewayConnectPeerErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateTransitGatewayConnectPeerErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateTransitGatewayConnectPeerErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateTransitGatewayConnectPeerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateTransitGatewayConnectPeerError {
    fn code(&self) -> Option<&str> {
        DisassociateTransitGatewayConnectPeerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateTransitGatewayConnectPeerError {
    /// Creates a new `DisassociateTransitGatewayConnectPeerError`.
    pub fn new(
        kind: DisassociateTransitGatewayConnectPeerErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateTransitGatewayConnectPeerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateTransitGatewayConnectPeerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateTransitGatewayConnectPeerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateTransitGatewayConnectPeerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateTransitGatewayConnectPeerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateTransitGatewayConnectPeerErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateTransitGatewayConnectPeerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateTransitGatewayConnectPeerErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateTransitGatewayConnectPeerErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateTransitGatewayConnectPeerErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateTransitGatewayConnectPeerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateTransitGatewayConnectPeerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateTransitGatewayConnectPeerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateTransitGatewayConnectPeerErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateTransitGatewayConnectPeerErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateTransitGatewayConnectPeerErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateTransitGatewayConnectPeerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateTransitGatewayConnectPeerErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DisassociateTransitGatewayConnectPeerErrorKind::ConflictException(_inner) => {
                Some(_inner)
            }
            DisassociateTransitGatewayConnectPeerErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DisassociateTransitGatewayConnectPeerErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateTransitGatewayConnectPeerErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DisassociateTransitGatewayConnectPeerErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DisassociateTransitGatewayConnectPeerErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ExecuteCoreNetworkChangeSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExecuteCoreNetworkChangeSetError {
    /// Kind of error that occurred.
    pub kind: ExecuteCoreNetworkChangeSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExecuteCoreNetworkChangeSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExecuteCoreNetworkChangeSetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExecuteCoreNetworkChangeSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExecuteCoreNetworkChangeSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ExecuteCoreNetworkChangeSetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ExecuteCoreNetworkChangeSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ExecuteCoreNetworkChangeSetErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ExecuteCoreNetworkChangeSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ExecuteCoreNetworkChangeSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ExecuteCoreNetworkChangeSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExecuteCoreNetworkChangeSetError {
    fn code(&self) -> Option<&str> {
        ExecuteCoreNetworkChangeSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExecuteCoreNetworkChangeSetError {
    /// Creates a new `ExecuteCoreNetworkChangeSetError`.
    pub fn new(kind: ExecuteCoreNetworkChangeSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExecuteCoreNetworkChangeSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExecuteCoreNetworkChangeSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExecuteCoreNetworkChangeSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExecuteCoreNetworkChangeSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ExecuteCoreNetworkChangeSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteCoreNetworkChangeSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteCoreNetworkChangeSetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteCoreNetworkChangeSetErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteCoreNetworkChangeSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteCoreNetworkChangeSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteCoreNetworkChangeSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteCoreNetworkChangeSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteCoreNetworkChangeSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteCoreNetworkChangeSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteCoreNetworkChangeSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteCoreNetworkChangeSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ExecuteCoreNetworkChangeSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExecuteCoreNetworkChangeSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ExecuteCoreNetworkChangeSetErrorKind::ConflictException(_inner) => Some(_inner),
            ExecuteCoreNetworkChangeSetErrorKind::InternalServerException(_inner) => Some(_inner),
            ExecuteCoreNetworkChangeSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ExecuteCoreNetworkChangeSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            ExecuteCoreNetworkChangeSetErrorKind::ValidationException(_inner) => Some(_inner),
            ExecuteCoreNetworkChangeSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetConnectAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetConnectAttachmentError {
    /// Kind of error that occurred.
    pub kind: GetConnectAttachmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetConnectAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetConnectAttachmentErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetConnectAttachmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetConnectAttachmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetConnectAttachmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetConnectAttachmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetConnectAttachmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetConnectAttachmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetConnectAttachmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetConnectAttachmentError {
    fn code(&self) -> Option<&str> {
        GetConnectAttachmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetConnectAttachmentError {
    /// Creates a new `GetConnectAttachmentError`.
    pub fn new(kind: GetConnectAttachmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetConnectAttachmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetConnectAttachmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetConnectAttachmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetConnectAttachmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetConnectAttachmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectAttachmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectAttachmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectAttachmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectAttachmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectAttachmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectAttachmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectAttachmentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectAttachmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectAttachmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetConnectAttachmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetConnectAttachmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetConnectAttachmentErrorKind::InternalServerException(_inner) => Some(_inner),
            GetConnectAttachmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetConnectAttachmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetConnectAttachmentErrorKind::ValidationException(_inner) => Some(_inner),
            GetConnectAttachmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetConnectionsError {
    /// Kind of error that occurred.
    pub kind: GetConnectionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetConnectionsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetConnectionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetConnectionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetConnectionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetConnectionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetConnectionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetConnectionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetConnectionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetConnectionsError {
    fn code(&self) -> Option<&str> {
        GetConnectionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetConnectionsError {
    /// Creates a new `GetConnectionsError`.
    pub fn new(kind: GetConnectionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetConnectionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetConnectionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetConnectionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetConnectionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetConnectionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetConnectionsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetConnectionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetConnectionsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetConnectionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetConnectionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetConnectionsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetConnectionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetConnectionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetConnectionsErrorKind::ValidationException(_inner) => Some(_inner),
            GetConnectionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetConnectPeer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetConnectPeerError {
    /// Kind of error that occurred.
    pub kind: GetConnectPeerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetConnectPeer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetConnectPeerErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetConnectPeerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetConnectPeerErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetConnectPeerErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetConnectPeerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetConnectPeerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetConnectPeerErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetConnectPeerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetConnectPeerError {
    fn code(&self) -> Option<&str> {
        GetConnectPeerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetConnectPeerError {
    /// Creates a new `GetConnectPeerError`.
    pub fn new(kind: GetConnectPeerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetConnectPeerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetConnectPeerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetConnectPeerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetConnectPeerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetConnectPeerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectPeerErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectPeerErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectPeerErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectPeerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectPeerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectPeerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetConnectPeerErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetConnectPeerErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetConnectPeerErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetConnectPeerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetConnectPeerErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetConnectPeerErrorKind::InternalServerException(_inner) => Some(_inner),
            GetConnectPeerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetConnectPeerErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetConnectPeerErrorKind::ValidationException(_inner) => Some(_inner),
            GetConnectPeerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetConnectPeerAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetConnectPeerAssociationsError {
    /// Kind of error that occurred.
    pub kind: GetConnectPeerAssociationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetConnectPeerAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetConnectPeerAssociationsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetConnectPeerAssociationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetConnectPeerAssociationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetConnectPeerAssociationsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetConnectPeerAssociationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetConnectPeerAssociationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetConnectPeerAssociationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetConnectPeerAssociationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetConnectPeerAssociationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetConnectPeerAssociationsError {
    fn code(&self) -> Option<&str> {
        GetConnectPeerAssociationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetConnectPeerAssociationsError {
    /// Creates a new `GetConnectPeerAssociationsError`.
    pub fn new(kind: GetConnectPeerAssociationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetConnectPeerAssociationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetConnectPeerAssociationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetConnectPeerAssociationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetConnectPeerAssociationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetConnectPeerAssociationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectPeerAssociationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectPeerAssociationsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectPeerAssociationsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectPeerAssociationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectPeerAssociationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectPeerAssociationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectPeerAssociationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectPeerAssociationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectPeerAssociationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectPeerAssociationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectPeerAssociationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetConnectPeerAssociationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetConnectPeerAssociationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetConnectPeerAssociationsErrorKind::ConflictException(_inner) => Some(_inner),
            GetConnectPeerAssociationsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetConnectPeerAssociationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetConnectPeerAssociationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetConnectPeerAssociationsErrorKind::ValidationException(_inner) => Some(_inner),
            GetConnectPeerAssociationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCoreNetwork` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCoreNetworkError {
    /// Kind of error that occurred.
    pub kind: GetCoreNetworkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCoreNetwork` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCoreNetworkErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCoreNetworkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCoreNetworkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetCoreNetworkErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetCoreNetworkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetCoreNetworkErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetCoreNetworkErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetCoreNetworkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCoreNetworkError {
    fn code(&self) -> Option<&str> {
        GetCoreNetworkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCoreNetworkError {
    /// Creates a new `GetCoreNetworkError`.
    pub fn new(kind: GetCoreNetworkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCoreNetworkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCoreNetworkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCoreNetworkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCoreNetworkErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCoreNetworkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCoreNetworkErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCoreNetworkErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCoreNetworkErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCoreNetworkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCoreNetworkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCoreNetworkErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetCoreNetworkErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetCoreNetworkErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetCoreNetworkErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetCoreNetworkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCoreNetworkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetCoreNetworkErrorKind::InternalServerException(_inner) => Some(_inner),
            GetCoreNetworkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetCoreNetworkErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetCoreNetworkErrorKind::ValidationException(_inner) => Some(_inner),
            GetCoreNetworkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCoreNetworkChangeSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCoreNetworkChangeSetError {
    /// Kind of error that occurred.
    pub kind: GetCoreNetworkChangeSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCoreNetworkChangeSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCoreNetworkChangeSetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCoreNetworkChangeSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCoreNetworkChangeSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetCoreNetworkChangeSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetCoreNetworkChangeSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetCoreNetworkChangeSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetCoreNetworkChangeSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetCoreNetworkChangeSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCoreNetworkChangeSetError {
    fn code(&self) -> Option<&str> {
        GetCoreNetworkChangeSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCoreNetworkChangeSetError {
    /// Creates a new `GetCoreNetworkChangeSetError`.
    pub fn new(kind: GetCoreNetworkChangeSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCoreNetworkChangeSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCoreNetworkChangeSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCoreNetworkChangeSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCoreNetworkChangeSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCoreNetworkChangeSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCoreNetworkChangeSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCoreNetworkChangeSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCoreNetworkChangeSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCoreNetworkChangeSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCoreNetworkChangeSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCoreNetworkChangeSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCoreNetworkChangeSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCoreNetworkChangeSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCoreNetworkChangeSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetCoreNetworkChangeSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCoreNetworkChangeSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetCoreNetworkChangeSetErrorKind::InternalServerException(_inner) => Some(_inner),
            GetCoreNetworkChangeSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetCoreNetworkChangeSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetCoreNetworkChangeSetErrorKind::ValidationException(_inner) => Some(_inner),
            GetCoreNetworkChangeSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCoreNetworkPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCoreNetworkPolicyError {
    /// Kind of error that occurred.
    pub kind: GetCoreNetworkPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCoreNetworkPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCoreNetworkPolicyErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCoreNetworkPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCoreNetworkPolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetCoreNetworkPolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetCoreNetworkPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetCoreNetworkPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetCoreNetworkPolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetCoreNetworkPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCoreNetworkPolicyError {
    fn code(&self) -> Option<&str> {
        GetCoreNetworkPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCoreNetworkPolicyError {
    /// Creates a new `GetCoreNetworkPolicyError`.
    pub fn new(kind: GetCoreNetworkPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCoreNetworkPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCoreNetworkPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCoreNetworkPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCoreNetworkPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCoreNetworkPolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCoreNetworkPolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCoreNetworkPolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCoreNetworkPolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCoreNetworkPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCoreNetworkPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCoreNetworkPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCoreNetworkPolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCoreNetworkPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCoreNetworkPolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetCoreNetworkPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCoreNetworkPolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetCoreNetworkPolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            GetCoreNetworkPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetCoreNetworkPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetCoreNetworkPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            GetCoreNetworkPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCustomerGatewayAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCustomerGatewayAssociationsError {
    /// Kind of error that occurred.
    pub kind: GetCustomerGatewayAssociationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCustomerGatewayAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCustomerGatewayAssociationsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCustomerGatewayAssociationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCustomerGatewayAssociationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetCustomerGatewayAssociationsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetCustomerGatewayAssociationsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetCustomerGatewayAssociationsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetCustomerGatewayAssociationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetCustomerGatewayAssociationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetCustomerGatewayAssociationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCustomerGatewayAssociationsError {
    fn code(&self) -> Option<&str> {
        GetCustomerGatewayAssociationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCustomerGatewayAssociationsError {
    /// Creates a new `GetCustomerGatewayAssociationsError`.
    pub fn new(
        kind: GetCustomerGatewayAssociationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCustomerGatewayAssociationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCustomerGatewayAssociationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCustomerGatewayAssociationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCustomerGatewayAssociationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCustomerGatewayAssociationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCustomerGatewayAssociationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCustomerGatewayAssociationsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCustomerGatewayAssociationsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCustomerGatewayAssociationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCustomerGatewayAssociationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCustomerGatewayAssociationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCustomerGatewayAssociationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCustomerGatewayAssociationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCustomerGatewayAssociationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCustomerGatewayAssociationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCustomerGatewayAssociationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetCustomerGatewayAssociationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCustomerGatewayAssociationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetCustomerGatewayAssociationsErrorKind::ConflictException(_inner) => Some(_inner),
            GetCustomerGatewayAssociationsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetCustomerGatewayAssociationsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetCustomerGatewayAssociationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetCustomerGatewayAssociationsErrorKind::ValidationException(_inner) => Some(_inner),
            GetCustomerGatewayAssociationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDevicesError {
    /// Kind of error that occurred.
    pub kind: GetDevicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDevicesErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDevicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDevicesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDevicesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetDevicesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDevicesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetDevicesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetDevicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDevicesError {
    fn code(&self) -> Option<&str> {
        GetDevicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDevicesError {
    /// Creates a new `GetDevicesError`.
    pub fn new(kind: GetDevicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDevicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDevicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDevicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDevicesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDevicesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetDevicesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetDevicesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetDevicesErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetDevicesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDevicesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDevicesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetDevicesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetDevicesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetDevicesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetDevicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDevicesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDevicesErrorKind::InternalServerException(_inner) => Some(_inner),
            GetDevicesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDevicesErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetDevicesErrorKind::ValidationException(_inner) => Some(_inner),
            GetDevicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLinkAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLinkAssociationsError {
    /// Kind of error that occurred.
    pub kind: GetLinkAssociationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLinkAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLinkAssociationsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLinkAssociationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLinkAssociationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLinkAssociationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetLinkAssociationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetLinkAssociationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetLinkAssociationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetLinkAssociationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLinkAssociationsError {
    fn code(&self) -> Option<&str> {
        GetLinkAssociationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLinkAssociationsError {
    /// Creates a new `GetLinkAssociationsError`.
    pub fn new(kind: GetLinkAssociationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLinkAssociationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLinkAssociationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLinkAssociationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLinkAssociationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLinkAssociationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLinkAssociationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLinkAssociationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLinkAssociationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLinkAssociationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLinkAssociationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLinkAssociationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLinkAssociationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLinkAssociationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLinkAssociationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetLinkAssociationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLinkAssociationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLinkAssociationsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetLinkAssociationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLinkAssociationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetLinkAssociationsErrorKind::ValidationException(_inner) => Some(_inner),
            GetLinkAssociationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLinks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLinksError {
    /// Kind of error that occurred.
    pub kind: GetLinksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLinks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLinksErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLinksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLinksErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLinksErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetLinksErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetLinksErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetLinksErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetLinksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLinksError {
    fn code(&self) -> Option<&str> {
        GetLinksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLinksError {
    /// Creates a new `GetLinksError`.
    pub fn new(kind: GetLinksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLinksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLinksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLinksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLinksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLinksErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetLinksErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetLinksErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetLinksErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetLinksErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetLinksErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetLinksErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetLinksErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetLinksErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetLinksErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetLinksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLinksErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLinksErrorKind::InternalServerException(_inner) => Some(_inner),
            GetLinksErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLinksErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetLinksErrorKind::ValidationException(_inner) => Some(_inner),
            GetLinksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetNetworkResourceCounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetNetworkResourceCountsError {
    /// Kind of error that occurred.
    pub kind: GetNetworkResourceCountsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetNetworkResourceCounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetNetworkResourceCountsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetNetworkResourceCountsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetNetworkResourceCountsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetNetworkResourceCountsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetNetworkResourceCountsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetNetworkResourceCountsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetNetworkResourceCountsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetNetworkResourceCountsError {
    fn code(&self) -> Option<&str> {
        GetNetworkResourceCountsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetNetworkResourceCountsError {
    /// Creates a new `GetNetworkResourceCountsError`.
    pub fn new(kind: GetNetworkResourceCountsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetNetworkResourceCountsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetNetworkResourceCountsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetNetworkResourceCountsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetNetworkResourceCountsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetNetworkResourceCountsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkResourceCountsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkResourceCountsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkResourceCountsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkResourceCountsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkResourceCountsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkResourceCountsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkResourceCountsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetNetworkResourceCountsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetNetworkResourceCountsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetNetworkResourceCountsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetNetworkResourceCountsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetNetworkResourceCountsErrorKind::ValidationException(_inner) => Some(_inner),
            GetNetworkResourceCountsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetNetworkResourceRelationships` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetNetworkResourceRelationshipsError {
    /// Kind of error that occurred.
    pub kind: GetNetworkResourceRelationshipsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetNetworkResourceRelationships` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetNetworkResourceRelationshipsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetNetworkResourceRelationshipsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetNetworkResourceRelationshipsErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetNetworkResourceRelationshipsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetNetworkResourceRelationshipsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetNetworkResourceRelationshipsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetNetworkResourceRelationshipsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetNetworkResourceRelationshipsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetNetworkResourceRelationshipsError {
    fn code(&self) -> Option<&str> {
        GetNetworkResourceRelationshipsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetNetworkResourceRelationshipsError {
    /// Creates a new `GetNetworkResourceRelationshipsError`.
    pub fn new(
        kind: GetNetworkResourceRelationshipsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetNetworkResourceRelationshipsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetNetworkResourceRelationshipsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetNetworkResourceRelationshipsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetNetworkResourceRelationshipsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetNetworkResourceRelationshipsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkResourceRelationshipsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkResourceRelationshipsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkResourceRelationshipsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkResourceRelationshipsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkResourceRelationshipsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkResourceRelationshipsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkResourceRelationshipsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkResourceRelationshipsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkResourceRelationshipsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetNetworkResourceRelationshipsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetNetworkResourceRelationshipsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetNetworkResourceRelationshipsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetNetworkResourceRelationshipsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetNetworkResourceRelationshipsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetNetworkResourceRelationshipsErrorKind::ValidationException(_inner) => Some(_inner),
            GetNetworkResourceRelationshipsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetNetworkResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetNetworkResourcesError {
    /// Kind of error that occurred.
    pub kind: GetNetworkResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetNetworkResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetNetworkResourcesErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetNetworkResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetNetworkResourcesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetNetworkResourcesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetNetworkResourcesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetNetworkResourcesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetNetworkResourcesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetNetworkResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetNetworkResourcesError {
    fn code(&self) -> Option<&str> {
        GetNetworkResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetNetworkResourcesError {
    /// Creates a new `GetNetworkResourcesError`.
    pub fn new(kind: GetNetworkResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetNetworkResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetNetworkResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetNetworkResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetNetworkResourcesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetNetworkResourcesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkResourcesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkResourcesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkResourcesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkResourcesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkResourcesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkResourcesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkResourcesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkResourcesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkResourcesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetNetworkResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetNetworkResourcesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetNetworkResourcesErrorKind::InternalServerException(_inner) => Some(_inner),
            GetNetworkResourcesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetNetworkResourcesErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetNetworkResourcesErrorKind::ValidationException(_inner) => Some(_inner),
            GetNetworkResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetNetworkRoutes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetNetworkRoutesError {
    /// Kind of error that occurred.
    pub kind: GetNetworkRoutesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetNetworkRoutes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetNetworkRoutesErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetNetworkRoutesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetNetworkRoutesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetNetworkRoutesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetNetworkRoutesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetNetworkRoutesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetNetworkRoutesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetNetworkRoutesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetNetworkRoutesError {
    fn code(&self) -> Option<&str> {
        GetNetworkRoutesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetNetworkRoutesError {
    /// Creates a new `GetNetworkRoutesError`.
    pub fn new(kind: GetNetworkRoutesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetNetworkRoutesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetNetworkRoutesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetNetworkRoutesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetNetworkRoutesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetNetworkRoutesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkRoutesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkRoutesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkRoutesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkRoutesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkRoutesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkRoutesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkRoutesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkRoutesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkRoutesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetNetworkRoutesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetNetworkRoutesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetNetworkRoutesErrorKind::InternalServerException(_inner) => Some(_inner),
            GetNetworkRoutesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetNetworkRoutesErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetNetworkRoutesErrorKind::ValidationException(_inner) => Some(_inner),
            GetNetworkRoutesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetNetworkTelemetry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetNetworkTelemetryError {
    /// Kind of error that occurred.
    pub kind: GetNetworkTelemetryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetNetworkTelemetry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetNetworkTelemetryErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetNetworkTelemetryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetNetworkTelemetryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetNetworkTelemetryErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetNetworkTelemetryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetNetworkTelemetryErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetNetworkTelemetryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetNetworkTelemetryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetNetworkTelemetryError {
    fn code(&self) -> Option<&str> {
        GetNetworkTelemetryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetNetworkTelemetryError {
    /// Creates a new `GetNetworkTelemetryError`.
    pub fn new(kind: GetNetworkTelemetryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetNetworkTelemetryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetNetworkTelemetryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetNetworkTelemetryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetNetworkTelemetryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetNetworkTelemetryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkTelemetryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkTelemetryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkTelemetryErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkTelemetryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkTelemetryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkTelemetryErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkTelemetryErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkTelemetryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkTelemetryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetNetworkTelemetryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetNetworkTelemetryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetNetworkTelemetryErrorKind::InternalServerException(_inner) => Some(_inner),
            GetNetworkTelemetryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetNetworkTelemetryErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetNetworkTelemetryErrorKind::ValidationException(_inner) => Some(_inner),
            GetNetworkTelemetryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: GetResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourcePolicyErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourcePolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourcePolicyError {
    fn code(&self) -> Option<&str> {
        GetResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourcePolicyError {
    /// Creates a new `GetResourcePolicyError`.
    pub fn new(kind: GetResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResourcePolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourcePolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::ValidationException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRouteAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRouteAnalysisError {
    /// Kind of error that occurred.
    pub kind: GetRouteAnalysisErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRouteAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRouteAnalysisErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRouteAnalysisError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRouteAnalysisErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRouteAnalysisErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetRouteAnalysisErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetRouteAnalysisErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetRouteAnalysisErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetRouteAnalysisErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRouteAnalysisError {
    fn code(&self) -> Option<&str> {
        GetRouteAnalysisError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRouteAnalysisError {
    /// Creates a new `GetRouteAnalysisError`.
    pub fn new(kind: GetRouteAnalysisErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRouteAnalysisError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRouteAnalysisErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRouteAnalysisError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRouteAnalysisErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRouteAnalysisErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRouteAnalysisErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRouteAnalysisErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRouteAnalysisErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRouteAnalysisErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRouteAnalysisErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRouteAnalysisErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRouteAnalysisErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRouteAnalysisErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRouteAnalysisErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetRouteAnalysisError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRouteAnalysisErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRouteAnalysisErrorKind::InternalServerException(_inner) => Some(_inner),
            GetRouteAnalysisErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetRouteAnalysisErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetRouteAnalysisErrorKind::ValidationException(_inner) => Some(_inner),
            GetRouteAnalysisErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSites` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSitesError {
    /// Kind of error that occurred.
    pub kind: GetSitesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSites` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSitesErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSitesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSitesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetSitesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetSitesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetSitesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetSitesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetSitesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSitesError {
    fn code(&self) -> Option<&str> {
        GetSitesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSitesError {
    /// Creates a new `GetSitesError`.
    pub fn new(kind: GetSitesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSitesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSitesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSitesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSitesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSitesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetSitesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetSitesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetSitesErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetSitesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetSitesErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetSitesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetSitesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetSitesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetSitesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetSitesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSitesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetSitesErrorKind::InternalServerException(_inner) => Some(_inner),
            GetSitesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetSitesErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetSitesErrorKind::ValidationException(_inner) => Some(_inner),
            GetSitesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSiteToSiteVpnAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSiteToSiteVpnAttachmentError {
    /// Kind of error that occurred.
    pub kind: GetSiteToSiteVpnAttachmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSiteToSiteVpnAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSiteToSiteVpnAttachmentErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSiteToSiteVpnAttachmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSiteToSiteVpnAttachmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetSiteToSiteVpnAttachmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetSiteToSiteVpnAttachmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetSiteToSiteVpnAttachmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetSiteToSiteVpnAttachmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetSiteToSiteVpnAttachmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSiteToSiteVpnAttachmentError {
    fn code(&self) -> Option<&str> {
        GetSiteToSiteVpnAttachmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSiteToSiteVpnAttachmentError {
    /// Creates a new `GetSiteToSiteVpnAttachmentError`.
    pub fn new(kind: GetSiteToSiteVpnAttachmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSiteToSiteVpnAttachmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSiteToSiteVpnAttachmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSiteToSiteVpnAttachmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSiteToSiteVpnAttachmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSiteToSiteVpnAttachmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSiteToSiteVpnAttachmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSiteToSiteVpnAttachmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSiteToSiteVpnAttachmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSiteToSiteVpnAttachmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSiteToSiteVpnAttachmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSiteToSiteVpnAttachmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSiteToSiteVpnAttachmentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSiteToSiteVpnAttachmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSiteToSiteVpnAttachmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetSiteToSiteVpnAttachmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSiteToSiteVpnAttachmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetSiteToSiteVpnAttachmentErrorKind::InternalServerException(_inner) => Some(_inner),
            GetSiteToSiteVpnAttachmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetSiteToSiteVpnAttachmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetSiteToSiteVpnAttachmentErrorKind::ValidationException(_inner) => Some(_inner),
            GetSiteToSiteVpnAttachmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTransitGatewayConnectPeerAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTransitGatewayConnectPeerAssociationsError {
    /// Kind of error that occurred.
    pub kind: GetTransitGatewayConnectPeerAssociationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTransitGatewayConnectPeerAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTransitGatewayConnectPeerAssociationsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTransitGatewayConnectPeerAssociationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTransitGatewayConnectPeerAssociationsErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetTransitGatewayConnectPeerAssociationsErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            GetTransitGatewayConnectPeerAssociationsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetTransitGatewayConnectPeerAssociationsErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            GetTransitGatewayConnectPeerAssociationsErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            GetTransitGatewayConnectPeerAssociationsErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            GetTransitGatewayConnectPeerAssociationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTransitGatewayConnectPeerAssociationsError {
    fn code(&self) -> Option<&str> {
        GetTransitGatewayConnectPeerAssociationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTransitGatewayConnectPeerAssociationsError {
    /// Creates a new `GetTransitGatewayConnectPeerAssociationsError`.
    pub fn new(
        kind: GetTransitGatewayConnectPeerAssociationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTransitGatewayConnectPeerAssociationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTransitGatewayConnectPeerAssociationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTransitGatewayConnectPeerAssociationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTransitGatewayConnectPeerAssociationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTransitGatewayConnectPeerAssociationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTransitGatewayConnectPeerAssociationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTransitGatewayConnectPeerAssociationsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTransitGatewayConnectPeerAssociationsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTransitGatewayConnectPeerAssociationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTransitGatewayConnectPeerAssociationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTransitGatewayConnectPeerAssociationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTransitGatewayConnectPeerAssociationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTransitGatewayConnectPeerAssociationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTransitGatewayConnectPeerAssociationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTransitGatewayConnectPeerAssociationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTransitGatewayConnectPeerAssociationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetTransitGatewayConnectPeerAssociationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTransitGatewayConnectPeerAssociationsErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            GetTransitGatewayConnectPeerAssociationsErrorKind::ConflictException(_inner) => {
                Some(_inner)
            }
            GetTransitGatewayConnectPeerAssociationsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetTransitGatewayConnectPeerAssociationsErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            GetTransitGatewayConnectPeerAssociationsErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            GetTransitGatewayConnectPeerAssociationsErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            GetTransitGatewayConnectPeerAssociationsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetTransitGatewayRegistrations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTransitGatewayRegistrationsError {
    /// Kind of error that occurred.
    pub kind: GetTransitGatewayRegistrationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTransitGatewayRegistrations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTransitGatewayRegistrationsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTransitGatewayRegistrationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTransitGatewayRegistrationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetTransitGatewayRegistrationsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetTransitGatewayRegistrationsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetTransitGatewayRegistrationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetTransitGatewayRegistrationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetTransitGatewayRegistrationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTransitGatewayRegistrationsError {
    fn code(&self) -> Option<&str> {
        GetTransitGatewayRegistrationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTransitGatewayRegistrationsError {
    /// Creates a new `GetTransitGatewayRegistrationsError`.
    pub fn new(
        kind: GetTransitGatewayRegistrationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTransitGatewayRegistrationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTransitGatewayRegistrationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTransitGatewayRegistrationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTransitGatewayRegistrationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTransitGatewayRegistrationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTransitGatewayRegistrationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTransitGatewayRegistrationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTransitGatewayRegistrationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTransitGatewayRegistrationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTransitGatewayRegistrationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTransitGatewayRegistrationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTransitGatewayRegistrationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTransitGatewayRegistrationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTransitGatewayRegistrationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetTransitGatewayRegistrationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTransitGatewayRegistrationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetTransitGatewayRegistrationsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetTransitGatewayRegistrationsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetTransitGatewayRegistrationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetTransitGatewayRegistrationsErrorKind::ValidationException(_inner) => Some(_inner),
            GetTransitGatewayRegistrationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetVpcAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVpcAttachmentError {
    /// Kind of error that occurred.
    pub kind: GetVpcAttachmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVpcAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVpcAttachmentErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVpcAttachmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVpcAttachmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetVpcAttachmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetVpcAttachmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetVpcAttachmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetVpcAttachmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetVpcAttachmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVpcAttachmentError {
    fn code(&self) -> Option<&str> {
        GetVpcAttachmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVpcAttachmentError {
    /// Creates a new `GetVpcAttachmentError`.
    pub fn new(kind: GetVpcAttachmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVpcAttachmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVpcAttachmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVpcAttachmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVpcAttachmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetVpcAttachmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVpcAttachmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVpcAttachmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVpcAttachmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVpcAttachmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVpcAttachmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVpcAttachmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVpcAttachmentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVpcAttachmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVpcAttachmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetVpcAttachmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVpcAttachmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetVpcAttachmentErrorKind::InternalServerException(_inner) => Some(_inner),
            GetVpcAttachmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetVpcAttachmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetVpcAttachmentErrorKind::ValidationException(_inner) => Some(_inner),
            GetVpcAttachmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAttachments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAttachmentsError {
    /// Kind of error that occurred.
    pub kind: ListAttachmentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAttachments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAttachmentsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAttachmentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAttachmentsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAttachmentsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListAttachmentsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAttachmentsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListAttachmentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAttachmentsError {
    fn code(&self) -> Option<&str> {
        ListAttachmentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAttachmentsError {
    /// Creates a new `ListAttachmentsError`.
    pub fn new(kind: ListAttachmentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAttachmentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAttachmentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAttachmentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAttachmentsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAttachmentsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachmentsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttachmentsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachmentsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttachmentsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListAttachmentsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListAttachmentsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListAttachmentsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListAttachmentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAttachmentsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAttachmentsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListAttachmentsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAttachmentsErrorKind::ValidationException(_inner) => Some(_inner),
            ListAttachmentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListConnectPeers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListConnectPeersError {
    /// Kind of error that occurred.
    pub kind: ListConnectPeersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListConnectPeers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListConnectPeersErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListConnectPeersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListConnectPeersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListConnectPeersErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListConnectPeersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListConnectPeersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListConnectPeersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListConnectPeersError {
    fn code(&self) -> Option<&str> {
        ListConnectPeersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListConnectPeersError {
    /// Creates a new `ListConnectPeersError`.
    pub fn new(kind: ListConnectPeersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListConnectPeersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListConnectPeersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListConnectPeersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListConnectPeersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListConnectPeersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConnectPeersErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConnectPeersErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConnectPeersErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConnectPeersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConnectPeersErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConnectPeersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConnectPeersErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListConnectPeersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListConnectPeersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListConnectPeersErrorKind::InternalServerException(_inner) => Some(_inner),
            ListConnectPeersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListConnectPeersErrorKind::ValidationException(_inner) => Some(_inner),
            ListConnectPeersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCoreNetworkPolicyVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCoreNetworkPolicyVersionsError {
    /// Kind of error that occurred.
    pub kind: ListCoreNetworkPolicyVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCoreNetworkPolicyVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCoreNetworkPolicyVersionsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCoreNetworkPolicyVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCoreNetworkPolicyVersionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListCoreNetworkPolicyVersionsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListCoreNetworkPolicyVersionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListCoreNetworkPolicyVersionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListCoreNetworkPolicyVersionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListCoreNetworkPolicyVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCoreNetworkPolicyVersionsError {
    fn code(&self) -> Option<&str> {
        ListCoreNetworkPolicyVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCoreNetworkPolicyVersionsError {
    /// Creates a new `ListCoreNetworkPolicyVersionsError`.
    pub fn new(
        kind: ListCoreNetworkPolicyVersionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCoreNetworkPolicyVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCoreNetworkPolicyVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCoreNetworkPolicyVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCoreNetworkPolicyVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCoreNetworkPolicyVersionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCoreNetworkPolicyVersionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCoreNetworkPolicyVersionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCoreNetworkPolicyVersionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCoreNetworkPolicyVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCoreNetworkPolicyVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCoreNetworkPolicyVersionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCoreNetworkPolicyVersionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCoreNetworkPolicyVersionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCoreNetworkPolicyVersionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListCoreNetworkPolicyVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCoreNetworkPolicyVersionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListCoreNetworkPolicyVersionsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListCoreNetworkPolicyVersionsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListCoreNetworkPolicyVersionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListCoreNetworkPolicyVersionsErrorKind::ValidationException(_inner) => Some(_inner),
            ListCoreNetworkPolicyVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCoreNetworks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCoreNetworksError {
    /// Kind of error that occurred.
    pub kind: ListCoreNetworksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCoreNetworks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCoreNetworksErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCoreNetworksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCoreNetworksErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListCoreNetworksErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListCoreNetworksErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListCoreNetworksErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListCoreNetworksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCoreNetworksError {
    fn code(&self) -> Option<&str> {
        ListCoreNetworksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCoreNetworksError {
    /// Creates a new `ListCoreNetworksError`.
    pub fn new(kind: ListCoreNetworksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCoreNetworksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCoreNetworksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCoreNetworksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCoreNetworksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCoreNetworksErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCoreNetworksErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCoreNetworksErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCoreNetworksErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCoreNetworksErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCoreNetworksErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCoreNetworksErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCoreNetworksErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListCoreNetworksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCoreNetworksErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListCoreNetworksErrorKind::InternalServerException(_inner) => Some(_inner),
            ListCoreNetworksErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListCoreNetworksErrorKind::ValidationException(_inner) => Some(_inner),
            ListCoreNetworksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutCoreNetworkPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutCoreNetworkPolicyError {
    /// Kind of error that occurred.
    pub kind: PutCoreNetworkPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutCoreNetworkPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutCoreNetworkPolicyErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Describes a core network policy exception.</p>
    CoreNetworkPolicyException(crate::error::CoreNetworkPolicyException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutCoreNetworkPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutCoreNetworkPolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutCoreNetworkPolicyErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutCoreNetworkPolicyErrorKind::CoreNetworkPolicyException(_inner) => _inner.fmt(f),
            PutCoreNetworkPolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutCoreNetworkPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutCoreNetworkPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutCoreNetworkPolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutCoreNetworkPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutCoreNetworkPolicyError {
    fn code(&self) -> Option<&str> {
        PutCoreNetworkPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutCoreNetworkPolicyError {
    /// Creates a new `PutCoreNetworkPolicyError`.
    pub fn new(kind: PutCoreNetworkPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutCoreNetworkPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutCoreNetworkPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutCoreNetworkPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutCoreNetworkPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutCoreNetworkPolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutCoreNetworkPolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutCoreNetworkPolicyErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutCoreNetworkPolicyErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `PutCoreNetworkPolicyErrorKind::CoreNetworkPolicyException`.
    pub fn is_core_network_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutCoreNetworkPolicyErrorKind::CoreNetworkPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `PutCoreNetworkPolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutCoreNetworkPolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutCoreNetworkPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutCoreNetworkPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutCoreNetworkPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutCoreNetworkPolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `PutCoreNetworkPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutCoreNetworkPolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutCoreNetworkPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutCoreNetworkPolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutCoreNetworkPolicyErrorKind::ConflictException(_inner) => Some(_inner),
            PutCoreNetworkPolicyErrorKind::CoreNetworkPolicyException(_inner) => Some(_inner),
            PutCoreNetworkPolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            PutCoreNetworkPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutCoreNetworkPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutCoreNetworkPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            PutCoreNetworkPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: PutResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutResourcePolicyErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A service limit was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutResourcePolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutResourcePolicyError {
    fn code(&self) -> Option<&str> {
        PutResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutResourcePolicyError {
    /// Creates a new `PutResourcePolicyError`.
    pub fn new(kind: PutResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutResourcePolicyErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutResourcePolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::ConflictException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::ValidationException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterTransitGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterTransitGatewayError {
    /// Kind of error that occurred.
    pub kind: RegisterTransitGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterTransitGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterTransitGatewayErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterTransitGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterTransitGatewayErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RegisterTransitGatewayErrorKind::ConflictException(_inner) => _inner.fmt(f),
            RegisterTransitGatewayErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            RegisterTransitGatewayErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RegisterTransitGatewayErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            RegisterTransitGatewayErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RegisterTransitGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterTransitGatewayError {
    fn code(&self) -> Option<&str> {
        RegisterTransitGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterTransitGatewayError {
    /// Creates a new `RegisterTransitGatewayError`.
    pub fn new(kind: RegisterTransitGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterTransitGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterTransitGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterTransitGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterTransitGatewayErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterTransitGatewayErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTransitGatewayErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterTransitGatewayErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTransitGatewayErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterTransitGatewayErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTransitGatewayErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterTransitGatewayErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTransitGatewayErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterTransitGatewayErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTransitGatewayErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterTransitGatewayErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTransitGatewayErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for RegisterTransitGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterTransitGatewayErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RegisterTransitGatewayErrorKind::ConflictException(_inner) => Some(_inner),
            RegisterTransitGatewayErrorKind::InternalServerException(_inner) => Some(_inner),
            RegisterTransitGatewayErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RegisterTransitGatewayErrorKind::ThrottlingException(_inner) => Some(_inner),
            RegisterTransitGatewayErrorKind::ValidationException(_inner) => Some(_inner),
            RegisterTransitGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RejectAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RejectAttachmentError {
    /// Kind of error that occurred.
    pub kind: RejectAttachmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RejectAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RejectAttachmentErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RejectAttachmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RejectAttachmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RejectAttachmentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            RejectAttachmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            RejectAttachmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RejectAttachmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            RejectAttachmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RejectAttachmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RejectAttachmentError {
    fn code(&self) -> Option<&str> {
        RejectAttachmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RejectAttachmentError {
    /// Creates a new `RejectAttachmentError`.
    pub fn new(kind: RejectAttachmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RejectAttachmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RejectAttachmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RejectAttachmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RejectAttachmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RejectAttachmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectAttachmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectAttachmentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, RejectAttachmentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `RejectAttachmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectAttachmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectAttachmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectAttachmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectAttachmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectAttachmentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectAttachmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectAttachmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for RejectAttachmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RejectAttachmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RejectAttachmentErrorKind::ConflictException(_inner) => Some(_inner),
            RejectAttachmentErrorKind::InternalServerException(_inner) => Some(_inner),
            RejectAttachmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RejectAttachmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            RejectAttachmentErrorKind::ValidationException(_inner) => Some(_inner),
            RejectAttachmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreCoreNetworkPolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreCoreNetworkPolicyVersionError {
    /// Kind of error that occurred.
    pub kind: RestoreCoreNetworkPolicyVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreCoreNetworkPolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreCoreNetworkPolicyVersionErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreCoreNetworkPolicyVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreCoreNetworkPolicyVersionErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            RestoreCoreNetworkPolicyVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            RestoreCoreNetworkPolicyVersionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            RestoreCoreNetworkPolicyVersionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            RestoreCoreNetworkPolicyVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            RestoreCoreNetworkPolicyVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RestoreCoreNetworkPolicyVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreCoreNetworkPolicyVersionError {
    fn code(&self) -> Option<&str> {
        RestoreCoreNetworkPolicyVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreCoreNetworkPolicyVersionError {
    /// Creates a new `RestoreCoreNetworkPolicyVersionError`.
    pub fn new(
        kind: RestoreCoreNetworkPolicyVersionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreCoreNetworkPolicyVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreCoreNetworkPolicyVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreCoreNetworkPolicyVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreCoreNetworkPolicyVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreCoreNetworkPolicyVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreCoreNetworkPolicyVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreCoreNetworkPolicyVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreCoreNetworkPolicyVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreCoreNetworkPolicyVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreCoreNetworkPolicyVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreCoreNetworkPolicyVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreCoreNetworkPolicyVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreCoreNetworkPolicyVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreCoreNetworkPolicyVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreCoreNetworkPolicyVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreCoreNetworkPolicyVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for RestoreCoreNetworkPolicyVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreCoreNetworkPolicyVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RestoreCoreNetworkPolicyVersionErrorKind::ConflictException(_inner) => Some(_inner),
            RestoreCoreNetworkPolicyVersionErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            RestoreCoreNetworkPolicyVersionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            RestoreCoreNetworkPolicyVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            RestoreCoreNetworkPolicyVersionErrorKind::ValidationException(_inner) => Some(_inner),
            RestoreCoreNetworkPolicyVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartRouteAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartRouteAnalysisError {
    /// Kind of error that occurred.
    pub kind: StartRouteAnalysisErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartRouteAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartRouteAnalysisErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartRouteAnalysisError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartRouteAnalysisErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartRouteAnalysisErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartRouteAnalysisErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartRouteAnalysisErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartRouteAnalysisErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartRouteAnalysisErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartRouteAnalysisErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartRouteAnalysisError {
    fn code(&self) -> Option<&str> {
        StartRouteAnalysisError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartRouteAnalysisError {
    /// Creates a new `StartRouteAnalysisError`.
    pub fn new(kind: StartRouteAnalysisErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartRouteAnalysisError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartRouteAnalysisErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartRouteAnalysisError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartRouteAnalysisErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartRouteAnalysisErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRouteAnalysisErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartRouteAnalysisErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRouteAnalysisErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `StartRouteAnalysisErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRouteAnalysisErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartRouteAnalysisErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRouteAnalysisErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartRouteAnalysisErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRouteAnalysisErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StartRouteAnalysisErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRouteAnalysisErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartRouteAnalysisError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartRouteAnalysisErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartRouteAnalysisErrorKind::ConflictException(_inner) => Some(_inner),
            StartRouteAnalysisErrorKind::InternalServerException(_inner) => Some(_inner),
            StartRouteAnalysisErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartRouteAnalysisErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartRouteAnalysisErrorKind::ValidationException(_inner) => Some(_inner),
            StartRouteAnalysisErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A service limit was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConnectionError {
    /// Kind of error that occurred.
    pub kind: UpdateConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConnectionErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConnectionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateConnectionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateConnectionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateConnectionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateConnectionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateConnectionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConnectionError {
    fn code(&self) -> Option<&str> {
        UpdateConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConnectionError {
    /// Creates a new `UpdateConnectionError`.
    pub fn new(kind: UpdateConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateConnectionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateConnectionErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateConnectionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConnectionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateConnectionErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateConnectionErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateConnectionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateConnectionErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateConnectionErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCoreNetwork` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCoreNetworkError {
    /// Kind of error that occurred.
    pub kind: UpdateCoreNetworkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCoreNetwork` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCoreNetworkErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCoreNetworkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCoreNetworkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateCoreNetworkErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateCoreNetworkErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateCoreNetworkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateCoreNetworkErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateCoreNetworkErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateCoreNetworkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCoreNetworkError {
    fn code(&self) -> Option<&str> {
        UpdateCoreNetworkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCoreNetworkError {
    /// Creates a new `UpdateCoreNetworkError`.
    pub fn new(kind: UpdateCoreNetworkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCoreNetworkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCoreNetworkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCoreNetworkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCoreNetworkErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateCoreNetworkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCoreNetworkErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCoreNetworkErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateCoreNetworkErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateCoreNetworkErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCoreNetworkErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCoreNetworkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCoreNetworkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCoreNetworkErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCoreNetworkErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCoreNetworkErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCoreNetworkErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateCoreNetworkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCoreNetworkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateCoreNetworkErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateCoreNetworkErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateCoreNetworkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateCoreNetworkErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateCoreNetworkErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateCoreNetworkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDeviceError {
    /// Kind of error that occurred.
    pub kind: UpdateDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDeviceErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDeviceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateDeviceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDeviceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDeviceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDeviceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDeviceError {
    fn code(&self) -> Option<&str> {
        UpdateDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDeviceError {
    /// Creates a new `UpdateDeviceError`.
    pub fn new(kind: UpdateDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDeviceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDeviceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateDeviceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateDeviceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateDeviceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateDeviceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeviceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateDeviceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateDeviceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateDeviceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDeviceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateDeviceErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDeviceErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDeviceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDeviceErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGlobalNetwork` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGlobalNetworkError {
    /// Kind of error that occurred.
    pub kind: UpdateGlobalNetworkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGlobalNetwork` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGlobalNetworkErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGlobalNetworkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGlobalNetworkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateGlobalNetworkErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateGlobalNetworkErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateGlobalNetworkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateGlobalNetworkErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateGlobalNetworkErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateGlobalNetworkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGlobalNetworkError {
    fn code(&self) -> Option<&str> {
        UpdateGlobalNetworkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGlobalNetworkError {
    /// Creates a new `UpdateGlobalNetworkError`.
    pub fn new(kind: UpdateGlobalNetworkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGlobalNetworkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGlobalNetworkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGlobalNetworkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGlobalNetworkErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateGlobalNetworkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalNetworkErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGlobalNetworkErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalNetworkErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGlobalNetworkErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalNetworkErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGlobalNetworkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalNetworkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGlobalNetworkErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalNetworkErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGlobalNetworkErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalNetworkErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateGlobalNetworkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGlobalNetworkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateGlobalNetworkErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateGlobalNetworkErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateGlobalNetworkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateGlobalNetworkErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateGlobalNetworkErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateGlobalNetworkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLinkError {
    /// Kind of error that occurred.
    pub kind: UpdateLinkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLinkErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A service limit was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLinkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLinkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateLinkErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateLinkErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateLinkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateLinkErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateLinkErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateLinkErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateLinkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLinkError {
    fn code(&self) -> Option<&str> {
        UpdateLinkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLinkError {
    /// Creates a new `UpdateLinkError`.
    pub fn new(kind: UpdateLinkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLinkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLinkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLinkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLinkErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateLinkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateLinkErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateLinkErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateLinkErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateLinkErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateLinkErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `UpdateLinkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLinkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLinkErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLinkErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLinkErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateLinkErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateLinkErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateLinkErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateLinkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLinkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateLinkErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateLinkErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateLinkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateLinkErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateLinkErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateLinkErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateLinkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateNetworkResourceMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateNetworkResourceMetadataError {
    /// Kind of error that occurred.
    pub kind: UpdateNetworkResourceMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateNetworkResourceMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateNetworkResourceMetadataErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateNetworkResourceMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateNetworkResourceMetadataErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateNetworkResourceMetadataErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateNetworkResourceMetadataErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateNetworkResourceMetadataErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateNetworkResourceMetadataErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateNetworkResourceMetadataErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateNetworkResourceMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateNetworkResourceMetadataError {
    fn code(&self) -> Option<&str> {
        UpdateNetworkResourceMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateNetworkResourceMetadataError {
    /// Creates a new `UpdateNetworkResourceMetadataError`.
    pub fn new(
        kind: UpdateNetworkResourceMetadataErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateNetworkResourceMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateNetworkResourceMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateNetworkResourceMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateNetworkResourceMetadataErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateNetworkResourceMetadataErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkResourceMetadataErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNetworkResourceMetadataErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkResourceMetadataErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNetworkResourceMetadataErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkResourceMetadataErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNetworkResourceMetadataErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkResourceMetadataErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNetworkResourceMetadataErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkResourceMetadataErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNetworkResourceMetadataErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkResourceMetadataErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateNetworkResourceMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateNetworkResourceMetadataErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateNetworkResourceMetadataErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateNetworkResourceMetadataErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateNetworkResourceMetadataErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateNetworkResourceMetadataErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateNetworkResourceMetadataErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateNetworkResourceMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSite` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSiteError {
    /// Kind of error that occurred.
    pub kind: UpdateSiteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSite` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSiteErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSiteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSiteErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateSiteErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateSiteErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateSiteErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateSiteErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateSiteErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateSiteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSiteError {
    fn code(&self) -> Option<&str> {
        UpdateSiteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSiteError {
    /// Creates a new `UpdateSiteError`.
    pub fn new(kind: UpdateSiteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSiteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSiteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSiteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSiteErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSiteErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateSiteErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateSiteErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateSiteErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateSiteErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateSiteErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `UpdateSiteErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSiteErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSiteErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateSiteErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateSiteErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateSiteErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateSiteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSiteErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateSiteErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateSiteErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateSiteErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateSiteErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateSiteErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateSiteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateVpcAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateVpcAttachmentError {
    /// Kind of error that occurred.
    pub kind: UpdateVpcAttachmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateVpcAttachment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateVpcAttachmentErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateVpcAttachmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateVpcAttachmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateVpcAttachmentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateVpcAttachmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateVpcAttachmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateVpcAttachmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateVpcAttachmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateVpcAttachmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateVpcAttachmentError {
    fn code(&self) -> Option<&str> {
        UpdateVpcAttachmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateVpcAttachmentError {
    /// Creates a new `UpdateVpcAttachmentError`.
    pub fn new(kind: UpdateVpcAttachmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateVpcAttachmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateVpcAttachmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateVpcAttachmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateVpcAttachmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateVpcAttachmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVpcAttachmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVpcAttachmentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVpcAttachmentErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVpcAttachmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVpcAttachmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVpcAttachmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVpcAttachmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVpcAttachmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVpcAttachmentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVpcAttachmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVpcAttachmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateVpcAttachmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateVpcAttachmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateVpcAttachmentErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateVpcAttachmentErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateVpcAttachmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateVpcAttachmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateVpcAttachmentErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateVpcAttachmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The input fails to satisfy the constraints.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The reason for the error.</p>
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
    /// <p>The fields that caused the error, if applicable.</p>
    pub fields: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
}
impl ValidationException {
    /// <p>The reason for the error.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ValidationExceptionReason> {
        self.reason.as_ref()
    }
    /// <p>The fields that caused the error, if applicable.</p>
    pub fn fields(&self) -> std::option::Option<&[crate::model::ValidationExceptionField]> {
        self.fields.as_deref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
        pub(crate) fields:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The reason for the error.</p>
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason for the error.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>The fields that caused the error, if applicable.</p>
        pub fn fields(mut self, input: crate::model::ValidationExceptionField) -> Self {
            let mut v = self.fields.unwrap_or_default();
            v.push(input);
            self.fields = Some(v);
            self
        }
        /// <p>The fields that caused the error, if applicable.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                reason: self.reason,
                fields: self.fields,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The request was denied due to request throttling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Indicates when to retry the request.</p>
    pub retry_after_seconds: std::option::Option<i32>,
}
impl ThrottlingException {
    /// <p>Indicates when to retry the request.</p>
    pub fn retry_after_seconds(&self) -> std::option::Option<i32> {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Indicates when to retry the request.</p>
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>Indicates when to retry the request.</p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                retry_after_seconds: self.retry_after_seconds,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The specified resource could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The resource type.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The specified resource could not be found.</p>
    pub context:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ResourceNotFoundException {
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The resource type.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The specified resource could not be found.</p>
    pub fn context(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.context.as_ref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("context", &self.context);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) context: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Adds a key-value pair to `context`.
        ///
        /// To override the contents of this collection use [`set_context`](Self::set_context).
        ///
        /// <p>The specified resource could not be found.</p>
        pub fn context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.context.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.context = Some(hash_map);
            self
        }
        /// <p>The specified resource could not be found.</p>
        pub fn set_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.context = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                context: self.context,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The request has failed due to an internal error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Indicates when to retry the request.</p>
    pub retry_after_seconds: std::option::Option<i32>,
}
impl InternalServerException {
    /// <p>Indicates when to retry the request.</p>
    pub fn retry_after_seconds(&self) -> std::option::Option<i32> {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Indicates when to retry the request.</p>
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>Indicates when to retry the request.</p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
                retry_after_seconds: self.retry_after_seconds,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The resource type.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ConflictException {
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The resource type.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>You do not have sufficient access to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>A service limit was exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    /// <p>The error message.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The resource type.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The limit code.</p>
    pub limit_code: std::option::Option<std::string::String>,
    /// <p>The service code.</p>
    pub service_code: std::option::Option<std::string::String>,
}
impl ServiceQuotaExceededException {
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The resource type.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The limit code.</p>
    pub fn limit_code(&self) -> std::option::Option<&str> {
        self.limit_code.as_deref()
    }
    /// <p>The service code.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("limit_code", &self.limit_code);
        formatter.field("service_code", &self.service_code);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) limit_code: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The limit code.</p>
        pub fn limit_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.limit_code = Some(input.into());
            self
        }
        /// <p>The limit code.</p>
        pub fn set_limit_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.limit_code = input;
            self
        }
        /// <p>The service code.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The service code.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                limit_code: self.limit_code,
                service_code: self.service_code,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p>Describes a core network policy exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoreNetworkPolicyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Describes a core network policy exception.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::CoreNetworkPolicyError>>,
}
impl CoreNetworkPolicyException {
    /// <p>Describes a core network policy exception.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::CoreNetworkPolicyError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for CoreNetworkPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoreNetworkPolicyException");
        formatter.field("message", &self.message);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
impl CoreNetworkPolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CoreNetworkPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CoreNetworkPolicyException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for CoreNetworkPolicyException {}
/// See [`CoreNetworkPolicyException`](crate::error::CoreNetworkPolicyException)
pub mod core_network_policy_exception {
    /// A builder for [`CoreNetworkPolicyException`](crate::error::CoreNetworkPolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::CoreNetworkPolicyError>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Describes a core network policy exception.</p>
        pub fn errors(mut self, input: crate::model::CoreNetworkPolicyError) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input);
            self.errors = Some(v);
            self
        }
        /// <p>Describes a core network policy exception.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CoreNetworkPolicyError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`CoreNetworkPolicyException`](crate::error::CoreNetworkPolicyException)
        pub fn build(self) -> crate::error::CoreNetworkPolicyException {
            crate::error::CoreNetworkPolicyException {
                message: self.message,
                errors: self.errors,
            }
        }
    }
}
impl CoreNetworkPolicyException {
    /// Creates a new builder-style object to manufacture [`CoreNetworkPolicyException`](crate::error::CoreNetworkPolicyException)
    pub fn builder() -> crate::error::core_network_policy_exception::Builder {
        crate::error::core_network_policy_exception::Builder::default()
    }
}
