// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVpcAttachmentOutput {
    /// <p>Describes the updated VPC attachment.</p>
    pub vpc_attachment: std::option::Option<crate::model::VpcAttachment>,
}
impl UpdateVpcAttachmentOutput {
    /// <p>Describes the updated VPC attachment.</p>
    pub fn vpc_attachment(&self) -> std::option::Option<&crate::model::VpcAttachment> {
        self.vpc_attachment.as_ref()
    }
}
impl std::fmt::Debug for UpdateVpcAttachmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVpcAttachmentOutput");
        formatter.field("vpc_attachment", &self.vpc_attachment);
        formatter.finish()
    }
}
/// See [`UpdateVpcAttachmentOutput`](crate::output::UpdateVpcAttachmentOutput)
pub mod update_vpc_attachment_output {
    /// A builder for [`UpdateVpcAttachmentOutput`](crate::output::UpdateVpcAttachmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_attachment: std::option::Option<crate::model::VpcAttachment>,
    }
    impl Builder {
        /// <p>Describes the updated VPC attachment.</p>
        pub fn vpc_attachment(mut self, input: crate::model::VpcAttachment) -> Self {
            self.vpc_attachment = Some(input);
            self
        }
        /// <p>Describes the updated VPC attachment.</p>
        pub fn set_vpc_attachment(
            mut self,
            input: std::option::Option<crate::model::VpcAttachment>,
        ) -> Self {
            self.vpc_attachment = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVpcAttachmentOutput`](crate::output::UpdateVpcAttachmentOutput)
        pub fn build(self) -> crate::output::UpdateVpcAttachmentOutput {
            crate::output::UpdateVpcAttachmentOutput {
                vpc_attachment: self.vpc_attachment,
            }
        }
    }
}
impl UpdateVpcAttachmentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateVpcAttachmentOutput`](crate::output::UpdateVpcAttachmentOutput)
    pub fn builder() -> crate::output::update_vpc_attachment_output::Builder {
        crate::output::update_vpc_attachment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSiteOutput {
    /// <p>Information about the site.</p>
    pub site: std::option::Option<crate::model::Site>,
}
impl UpdateSiteOutput {
    /// <p>Information about the site.</p>
    pub fn site(&self) -> std::option::Option<&crate::model::Site> {
        self.site.as_ref()
    }
}
impl std::fmt::Debug for UpdateSiteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSiteOutput");
        formatter.field("site", &self.site);
        formatter.finish()
    }
}
/// See [`UpdateSiteOutput`](crate::output::UpdateSiteOutput)
pub mod update_site_output {
    /// A builder for [`UpdateSiteOutput`](crate::output::UpdateSiteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site: std::option::Option<crate::model::Site>,
    }
    impl Builder {
        /// <p>Information about the site.</p>
        pub fn site(mut self, input: crate::model::Site) -> Self {
            self.site = Some(input);
            self
        }
        /// <p>Information about the site.</p>
        pub fn set_site(mut self, input: std::option::Option<crate::model::Site>) -> Self {
            self.site = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSiteOutput`](crate::output::UpdateSiteOutput)
        pub fn build(self) -> crate::output::UpdateSiteOutput {
            crate::output::UpdateSiteOutput { site: self.site }
        }
    }
}
impl UpdateSiteOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSiteOutput`](crate::output::UpdateSiteOutput)
    pub fn builder() -> crate::output::update_site_output::Builder {
        crate::output::update_site_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateNetworkResourceMetadataOutput {
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The updated resource metadata.</p>
    pub metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateNetworkResourceMetadataOutput {
    /// <p>The ARN of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The updated resource metadata.</p>
    pub fn metadata(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.metadata.as_ref()
    }
}
impl std::fmt::Debug for UpdateNetworkResourceMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateNetworkResourceMetadataOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("metadata", &self.metadata);
        formatter.finish()
    }
}
/// See [`UpdateNetworkResourceMetadataOutput`](crate::output::UpdateNetworkResourceMetadataOutput)
pub mod update_network_resource_metadata_output {
    /// A builder for [`UpdateNetworkResourceMetadataOutput`](crate::output::UpdateNetworkResourceMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>The updated resource metadata.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metadata = Some(hash_map);
            self
        }
        /// <p>The updated resource metadata.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateNetworkResourceMetadataOutput`](crate::output::UpdateNetworkResourceMetadataOutput)
        pub fn build(self) -> crate::output::UpdateNetworkResourceMetadataOutput {
            crate::output::UpdateNetworkResourceMetadataOutput {
                resource_arn: self.resource_arn,
                metadata: self.metadata,
            }
        }
    }
}
impl UpdateNetworkResourceMetadataOutput {
    /// Creates a new builder-style object to manufacture [`UpdateNetworkResourceMetadataOutput`](crate::output::UpdateNetworkResourceMetadataOutput)
    pub fn builder() -> crate::output::update_network_resource_metadata_output::Builder {
        crate::output::update_network_resource_metadata_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLinkOutput {
    /// <p>Information about the link.</p>
    pub link: std::option::Option<crate::model::Link>,
}
impl UpdateLinkOutput {
    /// <p>Information about the link.</p>
    pub fn link(&self) -> std::option::Option<&crate::model::Link> {
        self.link.as_ref()
    }
}
impl std::fmt::Debug for UpdateLinkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLinkOutput");
        formatter.field("link", &self.link);
        formatter.finish()
    }
}
/// See [`UpdateLinkOutput`](crate::output::UpdateLinkOutput)
pub mod update_link_output {
    /// A builder for [`UpdateLinkOutput`](crate::output::UpdateLinkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) link: std::option::Option<crate::model::Link>,
    }
    impl Builder {
        /// <p>Information about the link.</p>
        pub fn link(mut self, input: crate::model::Link) -> Self {
            self.link = Some(input);
            self
        }
        /// <p>Information about the link.</p>
        pub fn set_link(mut self, input: std::option::Option<crate::model::Link>) -> Self {
            self.link = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLinkOutput`](crate::output::UpdateLinkOutput)
        pub fn build(self) -> crate::output::UpdateLinkOutput {
            crate::output::UpdateLinkOutput { link: self.link }
        }
    }
}
impl UpdateLinkOutput {
    /// Creates a new builder-style object to manufacture [`UpdateLinkOutput`](crate::output::UpdateLinkOutput)
    pub fn builder() -> crate::output::update_link_output::Builder {
        crate::output::update_link_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGlobalNetworkOutput {
    /// <p>Information about the global network object.</p>
    pub global_network: std::option::Option<crate::model::GlobalNetwork>,
}
impl UpdateGlobalNetworkOutput {
    /// <p>Information about the global network object.</p>
    pub fn global_network(&self) -> std::option::Option<&crate::model::GlobalNetwork> {
        self.global_network.as_ref()
    }
}
impl std::fmt::Debug for UpdateGlobalNetworkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGlobalNetworkOutput");
        formatter.field("global_network", &self.global_network);
        formatter.finish()
    }
}
/// See [`UpdateGlobalNetworkOutput`](crate::output::UpdateGlobalNetworkOutput)
pub mod update_global_network_output {
    /// A builder for [`UpdateGlobalNetworkOutput`](crate::output::UpdateGlobalNetworkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network: std::option::Option<crate::model::GlobalNetwork>,
    }
    impl Builder {
        /// <p>Information about the global network object.</p>
        pub fn global_network(mut self, input: crate::model::GlobalNetwork) -> Self {
            self.global_network = Some(input);
            self
        }
        /// <p>Information about the global network object.</p>
        pub fn set_global_network(
            mut self,
            input: std::option::Option<crate::model::GlobalNetwork>,
        ) -> Self {
            self.global_network = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGlobalNetworkOutput`](crate::output::UpdateGlobalNetworkOutput)
        pub fn build(self) -> crate::output::UpdateGlobalNetworkOutput {
            crate::output::UpdateGlobalNetworkOutput {
                global_network: self.global_network,
            }
        }
    }
}
impl UpdateGlobalNetworkOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGlobalNetworkOutput`](crate::output::UpdateGlobalNetworkOutput)
    pub fn builder() -> crate::output::update_global_network_output::Builder {
        crate::output::update_global_network_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeviceOutput {
    /// <p>Information about the device.</p>
    pub device: std::option::Option<crate::model::Device>,
}
impl UpdateDeviceOutput {
    /// <p>Information about the device.</p>
    pub fn device(&self) -> std::option::Option<&crate::model::Device> {
        self.device.as_ref()
    }
}
impl std::fmt::Debug for UpdateDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeviceOutput");
        formatter.field("device", &self.device);
        formatter.finish()
    }
}
/// See [`UpdateDeviceOutput`](crate::output::UpdateDeviceOutput)
pub mod update_device_output {
    /// A builder for [`UpdateDeviceOutput`](crate::output::UpdateDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device: std::option::Option<crate::model::Device>,
    }
    impl Builder {
        /// <p>Information about the device.</p>
        pub fn device(mut self, input: crate::model::Device) -> Self {
            self.device = Some(input);
            self
        }
        /// <p>Information about the device.</p>
        pub fn set_device(mut self, input: std::option::Option<crate::model::Device>) -> Self {
            self.device = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeviceOutput`](crate::output::UpdateDeviceOutput)
        pub fn build(self) -> crate::output::UpdateDeviceOutput {
            crate::output::UpdateDeviceOutput {
                device: self.device,
            }
        }
    }
}
impl UpdateDeviceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDeviceOutput`](crate::output::UpdateDeviceOutput)
    pub fn builder() -> crate::output::update_device_output::Builder {
        crate::output::update_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCoreNetworkOutput {
    /// <p>Returns information about a core network update.</p>
    pub core_network: std::option::Option<crate::model::CoreNetwork>,
}
impl UpdateCoreNetworkOutput {
    /// <p>Returns information about a core network update.</p>
    pub fn core_network(&self) -> std::option::Option<&crate::model::CoreNetwork> {
        self.core_network.as_ref()
    }
}
impl std::fmt::Debug for UpdateCoreNetworkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCoreNetworkOutput");
        formatter.field("core_network", &self.core_network);
        formatter.finish()
    }
}
/// See [`UpdateCoreNetworkOutput`](crate::output::UpdateCoreNetworkOutput)
pub mod update_core_network_output {
    /// A builder for [`UpdateCoreNetworkOutput`](crate::output::UpdateCoreNetworkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network: std::option::Option<crate::model::CoreNetwork>,
    }
    impl Builder {
        /// <p>Returns information about a core network update.</p>
        pub fn core_network(mut self, input: crate::model::CoreNetwork) -> Self {
            self.core_network = Some(input);
            self
        }
        /// <p>Returns information about a core network update.</p>
        pub fn set_core_network(
            mut self,
            input: std::option::Option<crate::model::CoreNetwork>,
        ) -> Self {
            self.core_network = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCoreNetworkOutput`](crate::output::UpdateCoreNetworkOutput)
        pub fn build(self) -> crate::output::UpdateCoreNetworkOutput {
            crate::output::UpdateCoreNetworkOutput {
                core_network: self.core_network,
            }
        }
    }
}
impl UpdateCoreNetworkOutput {
    /// Creates a new builder-style object to manufacture [`UpdateCoreNetworkOutput`](crate::output::UpdateCoreNetworkOutput)
    pub fn builder() -> crate::output::update_core_network_output::Builder {
        crate::output::update_core_network_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectionOutput {
    /// <p>Information about the connection.</p>
    pub connection: std::option::Option<crate::model::Connection>,
}
impl UpdateConnectionOutput {
    /// <p>Information about the connection.</p>
    pub fn connection(&self) -> std::option::Option<&crate::model::Connection> {
        self.connection.as_ref()
    }
}
impl std::fmt::Debug for UpdateConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectionOutput");
        formatter.field("connection", &self.connection);
        formatter.finish()
    }
}
/// See [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
pub mod update_connection_output {
    /// A builder for [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection: std::option::Option<crate::model::Connection>,
    }
    impl Builder {
        /// <p>Information about the connection.</p>
        pub fn connection(mut self, input: crate::model::Connection) -> Self {
            self.connection = Some(input);
            self
        }
        /// <p>Information about the connection.</p>
        pub fn set_connection(
            mut self,
            input: std::option::Option<crate::model::Connection>,
        ) -> Self {
            self.connection = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
        pub fn build(self) -> crate::output::UpdateConnectionOutput {
            crate::output::UpdateConnectionOutput {
                connection: self.connection,
            }
        }
    }
}
impl UpdateConnectionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
    pub fn builder() -> crate::output::update_connection_output::Builder {
        crate::output::update_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartRouteAnalysisOutput {
    /// <p>The route analysis.</p>
    pub route_analysis: std::option::Option<crate::model::RouteAnalysis>,
}
impl StartRouteAnalysisOutput {
    /// <p>The route analysis.</p>
    pub fn route_analysis(&self) -> std::option::Option<&crate::model::RouteAnalysis> {
        self.route_analysis.as_ref()
    }
}
impl std::fmt::Debug for StartRouteAnalysisOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartRouteAnalysisOutput");
        formatter.field("route_analysis", &self.route_analysis);
        formatter.finish()
    }
}
/// See [`StartRouteAnalysisOutput`](crate::output::StartRouteAnalysisOutput)
pub mod start_route_analysis_output {
    /// A builder for [`StartRouteAnalysisOutput`](crate::output::StartRouteAnalysisOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) route_analysis: std::option::Option<crate::model::RouteAnalysis>,
    }
    impl Builder {
        /// <p>The route analysis.</p>
        pub fn route_analysis(mut self, input: crate::model::RouteAnalysis) -> Self {
            self.route_analysis = Some(input);
            self
        }
        /// <p>The route analysis.</p>
        pub fn set_route_analysis(
            mut self,
            input: std::option::Option<crate::model::RouteAnalysis>,
        ) -> Self {
            self.route_analysis = input;
            self
        }
        /// Consumes the builder and constructs a [`StartRouteAnalysisOutput`](crate::output::StartRouteAnalysisOutput)
        pub fn build(self) -> crate::output::StartRouteAnalysisOutput {
            crate::output::StartRouteAnalysisOutput {
                route_analysis: self.route_analysis,
            }
        }
    }
}
impl StartRouteAnalysisOutput {
    /// Creates a new builder-style object to manufacture [`StartRouteAnalysisOutput`](crate::output::StartRouteAnalysisOutput)
    pub fn builder() -> crate::output::start_route_analysis_output::Builder {
        crate::output::start_route_analysis_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreCoreNetworkPolicyVersionOutput {
    /// <p>Describes the restored core network policy.</p>
    pub core_network_policy: std::option::Option<crate::model::CoreNetworkPolicy>,
}
impl RestoreCoreNetworkPolicyVersionOutput {
    /// <p>Describes the restored core network policy.</p>
    pub fn core_network_policy(&self) -> std::option::Option<&crate::model::CoreNetworkPolicy> {
        self.core_network_policy.as_ref()
    }
}
impl std::fmt::Debug for RestoreCoreNetworkPolicyVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreCoreNetworkPolicyVersionOutput");
        formatter.field("core_network_policy", &self.core_network_policy);
        formatter.finish()
    }
}
/// See [`RestoreCoreNetworkPolicyVersionOutput`](crate::output::RestoreCoreNetworkPolicyVersionOutput)
pub mod restore_core_network_policy_version_output {
    /// A builder for [`RestoreCoreNetworkPolicyVersionOutput`](crate::output::RestoreCoreNetworkPolicyVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network_policy: std::option::Option<crate::model::CoreNetworkPolicy>,
    }
    impl Builder {
        /// <p>Describes the restored core network policy.</p>
        pub fn core_network_policy(mut self, input: crate::model::CoreNetworkPolicy) -> Self {
            self.core_network_policy = Some(input);
            self
        }
        /// <p>Describes the restored core network policy.</p>
        pub fn set_core_network_policy(
            mut self,
            input: std::option::Option<crate::model::CoreNetworkPolicy>,
        ) -> Self {
            self.core_network_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreCoreNetworkPolicyVersionOutput`](crate::output::RestoreCoreNetworkPolicyVersionOutput)
        pub fn build(self) -> crate::output::RestoreCoreNetworkPolicyVersionOutput {
            crate::output::RestoreCoreNetworkPolicyVersionOutput {
                core_network_policy: self.core_network_policy,
            }
        }
    }
}
impl RestoreCoreNetworkPolicyVersionOutput {
    /// Creates a new builder-style object to manufacture [`RestoreCoreNetworkPolicyVersionOutput`](crate::output::RestoreCoreNetworkPolicyVersionOutput)
    pub fn builder() -> crate::output::restore_core_network_policy_version_output::Builder {
        crate::output::restore_core_network_policy_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectAttachmentOutput {
    /// <p>Describes the rejected attachment request.</p>
    pub attachment: std::option::Option<crate::model::Attachment>,
}
impl RejectAttachmentOutput {
    /// <p>Describes the rejected attachment request.</p>
    pub fn attachment(&self) -> std::option::Option<&crate::model::Attachment> {
        self.attachment.as_ref()
    }
}
impl std::fmt::Debug for RejectAttachmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectAttachmentOutput");
        formatter.field("attachment", &self.attachment);
        formatter.finish()
    }
}
/// See [`RejectAttachmentOutput`](crate::output::RejectAttachmentOutput)
pub mod reject_attachment_output {
    /// A builder for [`RejectAttachmentOutput`](crate::output::RejectAttachmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attachment: std::option::Option<crate::model::Attachment>,
    }
    impl Builder {
        /// <p>Describes the rejected attachment request.</p>
        pub fn attachment(mut self, input: crate::model::Attachment) -> Self {
            self.attachment = Some(input);
            self
        }
        /// <p>Describes the rejected attachment request.</p>
        pub fn set_attachment(
            mut self,
            input: std::option::Option<crate::model::Attachment>,
        ) -> Self {
            self.attachment = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectAttachmentOutput`](crate::output::RejectAttachmentOutput)
        pub fn build(self) -> crate::output::RejectAttachmentOutput {
            crate::output::RejectAttachmentOutput {
                attachment: self.attachment,
            }
        }
    }
}
impl RejectAttachmentOutput {
    /// Creates a new builder-style object to manufacture [`RejectAttachmentOutput`](crate::output::RejectAttachmentOutput)
    pub fn builder() -> crate::output::reject_attachment_output::Builder {
        crate::output::reject_attachment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterTransitGatewayOutput {
    /// <p>Information about the transit gateway registration.</p>
    pub transit_gateway_registration: std::option::Option<crate::model::TransitGatewayRegistration>,
}
impl RegisterTransitGatewayOutput {
    /// <p>Information about the transit gateway registration.</p>
    pub fn transit_gateway_registration(
        &self,
    ) -> std::option::Option<&crate::model::TransitGatewayRegistration> {
        self.transit_gateway_registration.as_ref()
    }
}
impl std::fmt::Debug for RegisterTransitGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterTransitGatewayOutput");
        formatter.field(
            "transit_gateway_registration",
            &self.transit_gateway_registration,
        );
        formatter.finish()
    }
}
/// See [`RegisterTransitGatewayOutput`](crate::output::RegisterTransitGatewayOutput)
pub mod register_transit_gateway_output {
    /// A builder for [`RegisterTransitGatewayOutput`](crate::output::RegisterTransitGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_registration:
            std::option::Option<crate::model::TransitGatewayRegistration>,
    }
    impl Builder {
        /// <p>Information about the transit gateway registration.</p>
        pub fn transit_gateway_registration(
            mut self,
            input: crate::model::TransitGatewayRegistration,
        ) -> Self {
            self.transit_gateway_registration = Some(input);
            self
        }
        /// <p>Information about the transit gateway registration.</p>
        pub fn set_transit_gateway_registration(
            mut self,
            input: std::option::Option<crate::model::TransitGatewayRegistration>,
        ) -> Self {
            self.transit_gateway_registration = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterTransitGatewayOutput`](crate::output::RegisterTransitGatewayOutput)
        pub fn build(self) -> crate::output::RegisterTransitGatewayOutput {
            crate::output::RegisterTransitGatewayOutput {
                transit_gateway_registration: self.transit_gateway_registration,
            }
        }
    }
}
impl RegisterTransitGatewayOutput {
    /// Creates a new builder-style object to manufacture [`RegisterTransitGatewayOutput`](crate::output::RegisterTransitGatewayOutput)
    pub fn builder() -> crate::output::register_transit_gateway_output::Builder {
        crate::output::register_transit_gateway_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutResourcePolicyOutput {}
impl std::fmt::Debug for PutResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutResourcePolicyOutput");
        formatter.finish()
    }
}
/// See [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
pub mod put_resource_policy_output {
    /// A builder for [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
        pub fn build(self) -> crate::output::PutResourcePolicyOutput {
            crate::output::PutResourcePolicyOutput {}
        }
    }
}
impl PutResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
    pub fn builder() -> crate::output::put_resource_policy_output::Builder {
        crate::output::put_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutCoreNetworkPolicyOutput {
    /// <p>Describes the changed core network policy.</p>
    pub core_network_policy: std::option::Option<crate::model::CoreNetworkPolicy>,
}
impl PutCoreNetworkPolicyOutput {
    /// <p>Describes the changed core network policy.</p>
    pub fn core_network_policy(&self) -> std::option::Option<&crate::model::CoreNetworkPolicy> {
        self.core_network_policy.as_ref()
    }
}
impl std::fmt::Debug for PutCoreNetworkPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutCoreNetworkPolicyOutput");
        formatter.field("core_network_policy", &self.core_network_policy);
        formatter.finish()
    }
}
/// See [`PutCoreNetworkPolicyOutput`](crate::output::PutCoreNetworkPolicyOutput)
pub mod put_core_network_policy_output {
    /// A builder for [`PutCoreNetworkPolicyOutput`](crate::output::PutCoreNetworkPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network_policy: std::option::Option<crate::model::CoreNetworkPolicy>,
    }
    impl Builder {
        /// <p>Describes the changed core network policy.</p>
        pub fn core_network_policy(mut self, input: crate::model::CoreNetworkPolicy) -> Self {
            self.core_network_policy = Some(input);
            self
        }
        /// <p>Describes the changed core network policy.</p>
        pub fn set_core_network_policy(
            mut self,
            input: std::option::Option<crate::model::CoreNetworkPolicy>,
        ) -> Self {
            self.core_network_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutCoreNetworkPolicyOutput`](crate::output::PutCoreNetworkPolicyOutput)
        pub fn build(self) -> crate::output::PutCoreNetworkPolicyOutput {
            crate::output::PutCoreNetworkPolicyOutput {
                core_network_policy: self.core_network_policy,
            }
        }
    }
}
impl PutCoreNetworkPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutCoreNetworkPolicyOutput`](crate::output::PutCoreNetworkPolicyOutput)
    pub fn builder() -> crate::output::put_core_network_policy_output::Builder {
        crate::output::put_core_network_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The list of tags.</p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>The list of tags.</p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>The list of tags.</p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input);
            self.tag_list = Some(v);
            self
        }
        /// <p>The list of tags.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tag_list: self.tag_list,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCoreNetworksOutput {
    /// <p>Describes the list of core networks.</p>
    pub core_networks: std::option::Option<std::vec::Vec<crate::model::CoreNetworkSummary>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCoreNetworksOutput {
    /// <p>Describes the list of core networks.</p>
    pub fn core_networks(&self) -> std::option::Option<&[crate::model::CoreNetworkSummary]> {
        self.core_networks.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCoreNetworksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCoreNetworksOutput");
        formatter.field("core_networks", &self.core_networks);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCoreNetworksOutput`](crate::output::ListCoreNetworksOutput)
pub mod list_core_networks_output {
    /// A builder for [`ListCoreNetworksOutput`](crate::output::ListCoreNetworksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_networks:
            std::option::Option<std::vec::Vec<crate::model::CoreNetworkSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `core_networks`.
        ///
        /// To override the contents of this collection use [`set_core_networks`](Self::set_core_networks).
        ///
        /// <p>Describes the list of core networks.</p>
        pub fn core_networks(mut self, input: crate::model::CoreNetworkSummary) -> Self {
            let mut v = self.core_networks.unwrap_or_default();
            v.push(input);
            self.core_networks = Some(v);
            self
        }
        /// <p>Describes the list of core networks.</p>
        pub fn set_core_networks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CoreNetworkSummary>>,
        ) -> Self {
            self.core_networks = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCoreNetworksOutput`](crate::output::ListCoreNetworksOutput)
        pub fn build(self) -> crate::output::ListCoreNetworksOutput {
            crate::output::ListCoreNetworksOutput {
                core_networks: self.core_networks,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCoreNetworksOutput {
    /// Creates a new builder-style object to manufacture [`ListCoreNetworksOutput`](crate::output::ListCoreNetworksOutput)
    pub fn builder() -> crate::output::list_core_networks_output::Builder {
        crate::output::list_core_networks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCoreNetworkPolicyVersionsOutput {
    /// <p>Describes core network policy versions.</p>
    pub core_network_policy_versions:
        std::option::Option<std::vec::Vec<crate::model::CoreNetworkPolicyVersion>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCoreNetworkPolicyVersionsOutput {
    /// <p>Describes core network policy versions.</p>
    pub fn core_network_policy_versions(
        &self,
    ) -> std::option::Option<&[crate::model::CoreNetworkPolicyVersion]> {
        self.core_network_policy_versions.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCoreNetworkPolicyVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCoreNetworkPolicyVersionsOutput");
        formatter.field(
            "core_network_policy_versions",
            &self.core_network_policy_versions,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCoreNetworkPolicyVersionsOutput`](crate::output::ListCoreNetworkPolicyVersionsOutput)
pub mod list_core_network_policy_versions_output {
    /// A builder for [`ListCoreNetworkPolicyVersionsOutput`](crate::output::ListCoreNetworkPolicyVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network_policy_versions:
            std::option::Option<std::vec::Vec<crate::model::CoreNetworkPolicyVersion>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `core_network_policy_versions`.
        ///
        /// To override the contents of this collection use [`set_core_network_policy_versions`](Self::set_core_network_policy_versions).
        ///
        /// <p>Describes core network policy versions.</p>
        pub fn core_network_policy_versions(
            mut self,
            input: crate::model::CoreNetworkPolicyVersion,
        ) -> Self {
            let mut v = self.core_network_policy_versions.unwrap_or_default();
            v.push(input);
            self.core_network_policy_versions = Some(v);
            self
        }
        /// <p>Describes core network policy versions.</p>
        pub fn set_core_network_policy_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CoreNetworkPolicyVersion>>,
        ) -> Self {
            self.core_network_policy_versions = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCoreNetworkPolicyVersionsOutput`](crate::output::ListCoreNetworkPolicyVersionsOutput)
        pub fn build(self) -> crate::output::ListCoreNetworkPolicyVersionsOutput {
            crate::output::ListCoreNetworkPolicyVersionsOutput {
                core_network_policy_versions: self.core_network_policy_versions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCoreNetworkPolicyVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListCoreNetworkPolicyVersionsOutput`](crate::output::ListCoreNetworkPolicyVersionsOutput)
    pub fn builder() -> crate::output::list_core_network_policy_versions_output::Builder {
        crate::output::list_core_network_policy_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConnectPeersOutput {
    /// <p>Describes the Connect peers.</p>
    pub connect_peers: std::option::Option<std::vec::Vec<crate::model::ConnectPeerSummary>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListConnectPeersOutput {
    /// <p>Describes the Connect peers.</p>
    pub fn connect_peers(&self) -> std::option::Option<&[crate::model::ConnectPeerSummary]> {
        self.connect_peers.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListConnectPeersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConnectPeersOutput");
        formatter.field("connect_peers", &self.connect_peers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListConnectPeersOutput`](crate::output::ListConnectPeersOutput)
pub mod list_connect_peers_output {
    /// A builder for [`ListConnectPeersOutput`](crate::output::ListConnectPeersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connect_peers:
            std::option::Option<std::vec::Vec<crate::model::ConnectPeerSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `connect_peers`.
        ///
        /// To override the contents of this collection use [`set_connect_peers`](Self::set_connect_peers).
        ///
        /// <p>Describes the Connect peers.</p>
        pub fn connect_peers(mut self, input: crate::model::ConnectPeerSummary) -> Self {
            let mut v = self.connect_peers.unwrap_or_default();
            v.push(input);
            self.connect_peers = Some(v);
            self
        }
        /// <p>Describes the Connect peers.</p>
        pub fn set_connect_peers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectPeerSummary>>,
        ) -> Self {
            self.connect_peers = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConnectPeersOutput`](crate::output::ListConnectPeersOutput)
        pub fn build(self) -> crate::output::ListConnectPeersOutput {
            crate::output::ListConnectPeersOutput {
                connect_peers: self.connect_peers,
                next_token: self.next_token,
            }
        }
    }
}
impl ListConnectPeersOutput {
    /// Creates a new builder-style object to manufacture [`ListConnectPeersOutput`](crate::output::ListConnectPeersOutput)
    pub fn builder() -> crate::output::list_connect_peers_output::Builder {
        crate::output::list_connect_peers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAttachmentsOutput {
    /// <p>Describes the list of attachments.</p>
    pub attachments: std::option::Option<std::vec::Vec<crate::model::Attachment>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAttachmentsOutput {
    /// <p>Describes the list of attachments.</p>
    pub fn attachments(&self) -> std::option::Option<&[crate::model::Attachment]> {
        self.attachments.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAttachmentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAttachmentsOutput");
        formatter.field("attachments", &self.attachments);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAttachmentsOutput`](crate::output::ListAttachmentsOutput)
pub mod list_attachments_output {
    /// A builder for [`ListAttachmentsOutput`](crate::output::ListAttachmentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attachments: std::option::Option<std::vec::Vec<crate::model::Attachment>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `attachments`.
        ///
        /// To override the contents of this collection use [`set_attachments`](Self::set_attachments).
        ///
        /// <p>Describes the list of attachments.</p>
        pub fn attachments(mut self, input: crate::model::Attachment) -> Self {
            let mut v = self.attachments.unwrap_or_default();
            v.push(input);
            self.attachments = Some(v);
            self
        }
        /// <p>Describes the list of attachments.</p>
        pub fn set_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attachment>>,
        ) -> Self {
            self.attachments = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAttachmentsOutput`](crate::output::ListAttachmentsOutput)
        pub fn build(self) -> crate::output::ListAttachmentsOutput {
            crate::output::ListAttachmentsOutput {
                attachments: self.attachments,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAttachmentsOutput {
    /// Creates a new builder-style object to manufacture [`ListAttachmentsOutput`](crate::output::ListAttachmentsOutput)
    pub fn builder() -> crate::output::list_attachments_output::Builder {
        crate::output::list_attachments_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetVpcAttachmentOutput {
    /// <p>Returns details about a VPC attachment.</p>
    pub vpc_attachment: std::option::Option<crate::model::VpcAttachment>,
}
impl GetVpcAttachmentOutput {
    /// <p>Returns details about a VPC attachment.</p>
    pub fn vpc_attachment(&self) -> std::option::Option<&crate::model::VpcAttachment> {
        self.vpc_attachment.as_ref()
    }
}
impl std::fmt::Debug for GetVpcAttachmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetVpcAttachmentOutput");
        formatter.field("vpc_attachment", &self.vpc_attachment);
        formatter.finish()
    }
}
/// See [`GetVpcAttachmentOutput`](crate::output::GetVpcAttachmentOutput)
pub mod get_vpc_attachment_output {
    /// A builder for [`GetVpcAttachmentOutput`](crate::output::GetVpcAttachmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_attachment: std::option::Option<crate::model::VpcAttachment>,
    }
    impl Builder {
        /// <p>Returns details about a VPC attachment.</p>
        pub fn vpc_attachment(mut self, input: crate::model::VpcAttachment) -> Self {
            self.vpc_attachment = Some(input);
            self
        }
        /// <p>Returns details about a VPC attachment.</p>
        pub fn set_vpc_attachment(
            mut self,
            input: std::option::Option<crate::model::VpcAttachment>,
        ) -> Self {
            self.vpc_attachment = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVpcAttachmentOutput`](crate::output::GetVpcAttachmentOutput)
        pub fn build(self) -> crate::output::GetVpcAttachmentOutput {
            crate::output::GetVpcAttachmentOutput {
                vpc_attachment: self.vpc_attachment,
            }
        }
    }
}
impl GetVpcAttachmentOutput {
    /// Creates a new builder-style object to manufacture [`GetVpcAttachmentOutput`](crate::output::GetVpcAttachmentOutput)
    pub fn builder() -> crate::output::get_vpc_attachment_output::Builder {
        crate::output::get_vpc_attachment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTransitGatewayRegistrationsOutput {
    /// <p>The transit gateway registrations.</p>
    pub transit_gateway_registrations:
        std::option::Option<std::vec::Vec<crate::model::TransitGatewayRegistration>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetTransitGatewayRegistrationsOutput {
    /// <p>The transit gateway registrations.</p>
    pub fn transit_gateway_registrations(
        &self,
    ) -> std::option::Option<&[crate::model::TransitGatewayRegistration]> {
        self.transit_gateway_registrations.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetTransitGatewayRegistrationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTransitGatewayRegistrationsOutput");
        formatter.field(
            "transit_gateway_registrations",
            &self.transit_gateway_registrations,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetTransitGatewayRegistrationsOutput`](crate::output::GetTransitGatewayRegistrationsOutput)
pub mod get_transit_gateway_registrations_output {
    /// A builder for [`GetTransitGatewayRegistrationsOutput`](crate::output::GetTransitGatewayRegistrationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_registrations:
            std::option::Option<std::vec::Vec<crate::model::TransitGatewayRegistration>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `transit_gateway_registrations`.
        ///
        /// To override the contents of this collection use [`set_transit_gateway_registrations`](Self::set_transit_gateway_registrations).
        ///
        /// <p>The transit gateway registrations.</p>
        pub fn transit_gateway_registrations(
            mut self,
            input: crate::model::TransitGatewayRegistration,
        ) -> Self {
            let mut v = self.transit_gateway_registrations.unwrap_or_default();
            v.push(input);
            self.transit_gateway_registrations = Some(v);
            self
        }
        /// <p>The transit gateway registrations.</p>
        pub fn set_transit_gateway_registrations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TransitGatewayRegistration>>,
        ) -> Self {
            self.transit_gateway_registrations = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTransitGatewayRegistrationsOutput`](crate::output::GetTransitGatewayRegistrationsOutput)
        pub fn build(self) -> crate::output::GetTransitGatewayRegistrationsOutput {
            crate::output::GetTransitGatewayRegistrationsOutput {
                transit_gateway_registrations: self.transit_gateway_registrations,
                next_token: self.next_token,
            }
        }
    }
}
impl GetTransitGatewayRegistrationsOutput {
    /// Creates a new builder-style object to manufacture [`GetTransitGatewayRegistrationsOutput`](crate::output::GetTransitGatewayRegistrationsOutput)
    pub fn builder() -> crate::output::get_transit_gateway_registrations_output::Builder {
        crate::output::get_transit_gateway_registrations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTransitGatewayConnectPeerAssociationsOutput {
    /// <p>Information about the transit gateway Connect peer associations.</p>
    pub transit_gateway_connect_peer_associations:
        std::option::Option<std::vec::Vec<crate::model::TransitGatewayConnectPeerAssociation>>,
    /// <p>The token to use for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetTransitGatewayConnectPeerAssociationsOutput {
    /// <p>Information about the transit gateway Connect peer associations.</p>
    pub fn transit_gateway_connect_peer_associations(
        &self,
    ) -> std::option::Option<&[crate::model::TransitGatewayConnectPeerAssociation]> {
        self.transit_gateway_connect_peer_associations.as_deref()
    }
    /// <p>The token to use for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetTransitGatewayConnectPeerAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTransitGatewayConnectPeerAssociationsOutput");
        formatter.field(
            "transit_gateway_connect_peer_associations",
            &self.transit_gateway_connect_peer_associations,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetTransitGatewayConnectPeerAssociationsOutput`](crate::output::GetTransitGatewayConnectPeerAssociationsOutput)
pub mod get_transit_gateway_connect_peer_associations_output {
    /// A builder for [`GetTransitGatewayConnectPeerAssociationsOutput`](crate::output::GetTransitGatewayConnectPeerAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_connect_peer_associations:
            std::option::Option<std::vec::Vec<crate::model::TransitGatewayConnectPeerAssociation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `transit_gateway_connect_peer_associations`.
        ///
        /// To override the contents of this collection use [`set_transit_gateway_connect_peer_associations`](Self::set_transit_gateway_connect_peer_associations).
        ///
        /// <p>Information about the transit gateway Connect peer associations.</p>
        pub fn transit_gateway_connect_peer_associations(
            mut self,
            input: crate::model::TransitGatewayConnectPeerAssociation,
        ) -> Self {
            let mut v = self
                .transit_gateway_connect_peer_associations
                .unwrap_or_default();
            v.push(input);
            self.transit_gateway_connect_peer_associations = Some(v);
            self
        }
        /// <p>Information about the transit gateway Connect peer associations.</p>
        pub fn set_transit_gateway_connect_peer_associations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::TransitGatewayConnectPeerAssociation>,
            >,
        ) -> Self {
            self.transit_gateway_connect_peer_associations = input;
            self
        }
        /// <p>The token to use for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTransitGatewayConnectPeerAssociationsOutput`](crate::output::GetTransitGatewayConnectPeerAssociationsOutput)
        pub fn build(self) -> crate::output::GetTransitGatewayConnectPeerAssociationsOutput {
            crate::output::GetTransitGatewayConnectPeerAssociationsOutput {
                transit_gateway_connect_peer_associations: self
                    .transit_gateway_connect_peer_associations,
                next_token: self.next_token,
            }
        }
    }
}
impl GetTransitGatewayConnectPeerAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`GetTransitGatewayConnectPeerAssociationsOutput`](crate::output::GetTransitGatewayConnectPeerAssociationsOutput)
    pub fn builder() -> crate::output::get_transit_gateway_connect_peer_associations_output::Builder
    {
        crate::output::get_transit_gateway_connect_peer_associations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSiteToSiteVpnAttachmentOutput {
    /// <p>Describes the site-to-site attachment.</p>
    pub site_to_site_vpn_attachment: std::option::Option<crate::model::SiteToSiteVpnAttachment>,
}
impl GetSiteToSiteVpnAttachmentOutput {
    /// <p>Describes the site-to-site attachment.</p>
    pub fn site_to_site_vpn_attachment(
        &self,
    ) -> std::option::Option<&crate::model::SiteToSiteVpnAttachment> {
        self.site_to_site_vpn_attachment.as_ref()
    }
}
impl std::fmt::Debug for GetSiteToSiteVpnAttachmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSiteToSiteVpnAttachmentOutput");
        formatter.field(
            "site_to_site_vpn_attachment",
            &self.site_to_site_vpn_attachment,
        );
        formatter.finish()
    }
}
/// See [`GetSiteToSiteVpnAttachmentOutput`](crate::output::GetSiteToSiteVpnAttachmentOutput)
pub mod get_site_to_site_vpn_attachment_output {
    /// A builder for [`GetSiteToSiteVpnAttachmentOutput`](crate::output::GetSiteToSiteVpnAttachmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site_to_site_vpn_attachment:
            std::option::Option<crate::model::SiteToSiteVpnAttachment>,
    }
    impl Builder {
        /// <p>Describes the site-to-site attachment.</p>
        pub fn site_to_site_vpn_attachment(
            mut self,
            input: crate::model::SiteToSiteVpnAttachment,
        ) -> Self {
            self.site_to_site_vpn_attachment = Some(input);
            self
        }
        /// <p>Describes the site-to-site attachment.</p>
        pub fn set_site_to_site_vpn_attachment(
            mut self,
            input: std::option::Option<crate::model::SiteToSiteVpnAttachment>,
        ) -> Self {
            self.site_to_site_vpn_attachment = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSiteToSiteVpnAttachmentOutput`](crate::output::GetSiteToSiteVpnAttachmentOutput)
        pub fn build(self) -> crate::output::GetSiteToSiteVpnAttachmentOutput {
            crate::output::GetSiteToSiteVpnAttachmentOutput {
                site_to_site_vpn_attachment: self.site_to_site_vpn_attachment,
            }
        }
    }
}
impl GetSiteToSiteVpnAttachmentOutput {
    /// Creates a new builder-style object to manufacture [`GetSiteToSiteVpnAttachmentOutput`](crate::output::GetSiteToSiteVpnAttachmentOutput)
    pub fn builder() -> crate::output::get_site_to_site_vpn_attachment_output::Builder {
        crate::output::get_site_to_site_vpn_attachment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSitesOutput {
    /// <p>The sites.</p>
    pub sites: std::option::Option<std::vec::Vec<crate::model::Site>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetSitesOutput {
    /// <p>The sites.</p>
    pub fn sites(&self) -> std::option::Option<&[crate::model::Site]> {
        self.sites.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetSitesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSitesOutput");
        formatter.field("sites", &self.sites);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetSitesOutput`](crate::output::GetSitesOutput)
pub mod get_sites_output {
    /// A builder for [`GetSitesOutput`](crate::output::GetSitesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sites: std::option::Option<std::vec::Vec<crate::model::Site>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `sites`.
        ///
        /// To override the contents of this collection use [`set_sites`](Self::set_sites).
        ///
        /// <p>The sites.</p>
        pub fn sites(mut self, input: crate::model::Site) -> Self {
            let mut v = self.sites.unwrap_or_default();
            v.push(input);
            self.sites = Some(v);
            self
        }
        /// <p>The sites.</p>
        pub fn set_sites(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Site>>,
        ) -> Self {
            self.sites = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSitesOutput`](crate::output::GetSitesOutput)
        pub fn build(self) -> crate::output::GetSitesOutput {
            crate::output::GetSitesOutput {
                sites: self.sites,
                next_token: self.next_token,
            }
        }
    }
}
impl GetSitesOutput {
    /// Creates a new builder-style object to manufacture [`GetSitesOutput`](crate::output::GetSitesOutput)
    pub fn builder() -> crate::output::get_sites_output::Builder {
        crate::output::get_sites_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRouteAnalysisOutput {
    /// <p>The route analysis.</p>
    pub route_analysis: std::option::Option<crate::model::RouteAnalysis>,
}
impl GetRouteAnalysisOutput {
    /// <p>The route analysis.</p>
    pub fn route_analysis(&self) -> std::option::Option<&crate::model::RouteAnalysis> {
        self.route_analysis.as_ref()
    }
}
impl std::fmt::Debug for GetRouteAnalysisOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRouteAnalysisOutput");
        formatter.field("route_analysis", &self.route_analysis);
        formatter.finish()
    }
}
/// See [`GetRouteAnalysisOutput`](crate::output::GetRouteAnalysisOutput)
pub mod get_route_analysis_output {
    /// A builder for [`GetRouteAnalysisOutput`](crate::output::GetRouteAnalysisOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) route_analysis: std::option::Option<crate::model::RouteAnalysis>,
    }
    impl Builder {
        /// <p>The route analysis.</p>
        pub fn route_analysis(mut self, input: crate::model::RouteAnalysis) -> Self {
            self.route_analysis = Some(input);
            self
        }
        /// <p>The route analysis.</p>
        pub fn set_route_analysis(
            mut self,
            input: std::option::Option<crate::model::RouteAnalysis>,
        ) -> Self {
            self.route_analysis = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRouteAnalysisOutput`](crate::output::GetRouteAnalysisOutput)
        pub fn build(self) -> crate::output::GetRouteAnalysisOutput {
            crate::output::GetRouteAnalysisOutput {
                route_analysis: self.route_analysis,
            }
        }
    }
}
impl GetRouteAnalysisOutput {
    /// Creates a new builder-style object to manufacture [`GetRouteAnalysisOutput`](crate::output::GetRouteAnalysisOutput)
    pub fn builder() -> crate::output::get_route_analysis_output::Builder {
        crate::output::get_route_analysis_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourcePolicyOutput {
    /// <p>The resource policy document.</p>
    pub policy_document: std::option::Option<std::string::String>,
}
impl GetResourcePolicyOutput {
    /// <p>The resource policy document.</p>
    pub fn policy_document(&self) -> std::option::Option<&str> {
        self.policy_document.as_deref()
    }
}
impl std::fmt::Debug for GetResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourcePolicyOutput");
        formatter.field("policy_document", &self.policy_document);
        formatter.finish()
    }
}
/// See [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
pub mod get_resource_policy_output {
    /// A builder for [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_document: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource policy document.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>The resource policy document.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
        pub fn build(self) -> crate::output::GetResourcePolicyOutput {
            crate::output::GetResourcePolicyOutput {
                policy_document: self.policy_document,
            }
        }
    }
}
impl GetResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
    pub fn builder() -> crate::output::get_resource_policy_output::Builder {
        crate::output::get_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetNetworkTelemetryOutput {
    /// <p>The network telemetry.</p>
    pub network_telemetry: std::option::Option<std::vec::Vec<crate::model::NetworkTelemetry>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetNetworkTelemetryOutput {
    /// <p>The network telemetry.</p>
    pub fn network_telemetry(&self) -> std::option::Option<&[crate::model::NetworkTelemetry]> {
        self.network_telemetry.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetNetworkTelemetryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetNetworkTelemetryOutput");
        formatter.field("network_telemetry", &self.network_telemetry);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetNetworkTelemetryOutput`](crate::output::GetNetworkTelemetryOutput)
pub mod get_network_telemetry_output {
    /// A builder for [`GetNetworkTelemetryOutput`](crate::output::GetNetworkTelemetryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_telemetry:
            std::option::Option<std::vec::Vec<crate::model::NetworkTelemetry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `network_telemetry`.
        ///
        /// To override the contents of this collection use [`set_network_telemetry`](Self::set_network_telemetry).
        ///
        /// <p>The network telemetry.</p>
        pub fn network_telemetry(mut self, input: crate::model::NetworkTelemetry) -> Self {
            let mut v = self.network_telemetry.unwrap_or_default();
            v.push(input);
            self.network_telemetry = Some(v);
            self
        }
        /// <p>The network telemetry.</p>
        pub fn set_network_telemetry(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkTelemetry>>,
        ) -> Self {
            self.network_telemetry = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetNetworkTelemetryOutput`](crate::output::GetNetworkTelemetryOutput)
        pub fn build(self) -> crate::output::GetNetworkTelemetryOutput {
            crate::output::GetNetworkTelemetryOutput {
                network_telemetry: self.network_telemetry,
                next_token: self.next_token,
            }
        }
    }
}
impl GetNetworkTelemetryOutput {
    /// Creates a new builder-style object to manufacture [`GetNetworkTelemetryOutput`](crate::output::GetNetworkTelemetryOutput)
    pub fn builder() -> crate::output::get_network_telemetry_output::Builder {
        crate::output::get_network_telemetry_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetNetworkRoutesOutput {
    /// <p>The ARN of the route table.</p>
    pub route_table_arn: std::option::Option<std::string::String>,
    /// <p>Describes a core network segment edge.</p>
    pub core_network_segment_edge:
        std::option::Option<crate::model::CoreNetworkSegmentEdgeIdentifier>,
    /// <p>The route table type.</p>
    pub route_table_type: std::option::Option<crate::model::RouteTableType>,
    /// <p>The route table creation time.</p>
    pub route_table_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The network routes.</p>
    pub network_routes: std::option::Option<std::vec::Vec<crate::model::NetworkRoute>>,
}
impl GetNetworkRoutesOutput {
    /// <p>The ARN of the route table.</p>
    pub fn route_table_arn(&self) -> std::option::Option<&str> {
        self.route_table_arn.as_deref()
    }
    /// <p>Describes a core network segment edge.</p>
    pub fn core_network_segment_edge(
        &self,
    ) -> std::option::Option<&crate::model::CoreNetworkSegmentEdgeIdentifier> {
        self.core_network_segment_edge.as_ref()
    }
    /// <p>The route table type.</p>
    pub fn route_table_type(&self) -> std::option::Option<&crate::model::RouteTableType> {
        self.route_table_type.as_ref()
    }
    /// <p>The route table creation time.</p>
    pub fn route_table_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.route_table_timestamp.as_ref()
    }
    /// <p>The network routes.</p>
    pub fn network_routes(&self) -> std::option::Option<&[crate::model::NetworkRoute]> {
        self.network_routes.as_deref()
    }
}
impl std::fmt::Debug for GetNetworkRoutesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetNetworkRoutesOutput");
        formatter.field("route_table_arn", &self.route_table_arn);
        formatter.field("core_network_segment_edge", &self.core_network_segment_edge);
        formatter.field("route_table_type", &self.route_table_type);
        formatter.field("route_table_timestamp", &self.route_table_timestamp);
        formatter.field("network_routes", &self.network_routes);
        formatter.finish()
    }
}
/// See [`GetNetworkRoutesOutput`](crate::output::GetNetworkRoutesOutput)
pub mod get_network_routes_output {
    /// A builder for [`GetNetworkRoutesOutput`](crate::output::GetNetworkRoutesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) route_table_arn: std::option::Option<std::string::String>,
        pub(crate) core_network_segment_edge:
            std::option::Option<crate::model::CoreNetworkSegmentEdgeIdentifier>,
        pub(crate) route_table_type: std::option::Option<crate::model::RouteTableType>,
        pub(crate) route_table_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) network_routes: std::option::Option<std::vec::Vec<crate::model::NetworkRoute>>,
    }
    impl Builder {
        /// <p>The ARN of the route table.</p>
        pub fn route_table_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_table_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the route table.</p>
        pub fn set_route_table_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_table_arn = input;
            self
        }
        /// <p>Describes a core network segment edge.</p>
        pub fn core_network_segment_edge(
            mut self,
            input: crate::model::CoreNetworkSegmentEdgeIdentifier,
        ) -> Self {
            self.core_network_segment_edge = Some(input);
            self
        }
        /// <p>Describes a core network segment edge.</p>
        pub fn set_core_network_segment_edge(
            mut self,
            input: std::option::Option<crate::model::CoreNetworkSegmentEdgeIdentifier>,
        ) -> Self {
            self.core_network_segment_edge = input;
            self
        }
        /// <p>The route table type.</p>
        pub fn route_table_type(mut self, input: crate::model::RouteTableType) -> Self {
            self.route_table_type = Some(input);
            self
        }
        /// <p>The route table type.</p>
        pub fn set_route_table_type(
            mut self,
            input: std::option::Option<crate::model::RouteTableType>,
        ) -> Self {
            self.route_table_type = input;
            self
        }
        /// <p>The route table creation time.</p>
        pub fn route_table_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.route_table_timestamp = Some(input);
            self
        }
        /// <p>The route table creation time.</p>
        pub fn set_route_table_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.route_table_timestamp = input;
            self
        }
        /// Appends an item to `network_routes`.
        ///
        /// To override the contents of this collection use [`set_network_routes`](Self::set_network_routes).
        ///
        /// <p>The network routes.</p>
        pub fn network_routes(mut self, input: crate::model::NetworkRoute) -> Self {
            let mut v = self.network_routes.unwrap_or_default();
            v.push(input);
            self.network_routes = Some(v);
            self
        }
        /// <p>The network routes.</p>
        pub fn set_network_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkRoute>>,
        ) -> Self {
            self.network_routes = input;
            self
        }
        /// Consumes the builder and constructs a [`GetNetworkRoutesOutput`](crate::output::GetNetworkRoutesOutput)
        pub fn build(self) -> crate::output::GetNetworkRoutesOutput {
            crate::output::GetNetworkRoutesOutput {
                route_table_arn: self.route_table_arn,
                core_network_segment_edge: self.core_network_segment_edge,
                route_table_type: self.route_table_type,
                route_table_timestamp: self.route_table_timestamp,
                network_routes: self.network_routes,
            }
        }
    }
}
impl GetNetworkRoutesOutput {
    /// Creates a new builder-style object to manufacture [`GetNetworkRoutesOutput`](crate::output::GetNetworkRoutesOutput)
    pub fn builder() -> crate::output::get_network_routes_output::Builder {
        crate::output::get_network_routes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetNetworkResourcesOutput {
    /// <p>The network resources.</p>
    pub network_resources: std::option::Option<std::vec::Vec<crate::model::NetworkResource>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetNetworkResourcesOutput {
    /// <p>The network resources.</p>
    pub fn network_resources(&self) -> std::option::Option<&[crate::model::NetworkResource]> {
        self.network_resources.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetNetworkResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetNetworkResourcesOutput");
        formatter.field("network_resources", &self.network_resources);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetNetworkResourcesOutput`](crate::output::GetNetworkResourcesOutput)
pub mod get_network_resources_output {
    /// A builder for [`GetNetworkResourcesOutput`](crate::output::GetNetworkResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_resources:
            std::option::Option<std::vec::Vec<crate::model::NetworkResource>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `network_resources`.
        ///
        /// To override the contents of this collection use [`set_network_resources`](Self::set_network_resources).
        ///
        /// <p>The network resources.</p>
        pub fn network_resources(mut self, input: crate::model::NetworkResource) -> Self {
            let mut v = self.network_resources.unwrap_or_default();
            v.push(input);
            self.network_resources = Some(v);
            self
        }
        /// <p>The network resources.</p>
        pub fn set_network_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkResource>>,
        ) -> Self {
            self.network_resources = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetNetworkResourcesOutput`](crate::output::GetNetworkResourcesOutput)
        pub fn build(self) -> crate::output::GetNetworkResourcesOutput {
            crate::output::GetNetworkResourcesOutput {
                network_resources: self.network_resources,
                next_token: self.next_token,
            }
        }
    }
}
impl GetNetworkResourcesOutput {
    /// Creates a new builder-style object to manufacture [`GetNetworkResourcesOutput`](crate::output::GetNetworkResourcesOutput)
    pub fn builder() -> crate::output::get_network_resources_output::Builder {
        crate::output::get_network_resources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetNetworkResourceRelationshipsOutput {
    /// <p>The resource relationships.</p>
    pub relationships: std::option::Option<std::vec::Vec<crate::model::Relationship>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetNetworkResourceRelationshipsOutput {
    /// <p>The resource relationships.</p>
    pub fn relationships(&self) -> std::option::Option<&[crate::model::Relationship]> {
        self.relationships.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetNetworkResourceRelationshipsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetNetworkResourceRelationshipsOutput");
        formatter.field("relationships", &self.relationships);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetNetworkResourceRelationshipsOutput`](crate::output::GetNetworkResourceRelationshipsOutput)
pub mod get_network_resource_relationships_output {
    /// A builder for [`GetNetworkResourceRelationshipsOutput`](crate::output::GetNetworkResourceRelationshipsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) relationships: std::option::Option<std::vec::Vec<crate::model::Relationship>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `relationships`.
        ///
        /// To override the contents of this collection use [`set_relationships`](Self::set_relationships).
        ///
        /// <p>The resource relationships.</p>
        pub fn relationships(mut self, input: crate::model::Relationship) -> Self {
            let mut v = self.relationships.unwrap_or_default();
            v.push(input);
            self.relationships = Some(v);
            self
        }
        /// <p>The resource relationships.</p>
        pub fn set_relationships(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Relationship>>,
        ) -> Self {
            self.relationships = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetNetworkResourceRelationshipsOutput`](crate::output::GetNetworkResourceRelationshipsOutput)
        pub fn build(self) -> crate::output::GetNetworkResourceRelationshipsOutput {
            crate::output::GetNetworkResourceRelationshipsOutput {
                relationships: self.relationships,
                next_token: self.next_token,
            }
        }
    }
}
impl GetNetworkResourceRelationshipsOutput {
    /// Creates a new builder-style object to manufacture [`GetNetworkResourceRelationshipsOutput`](crate::output::GetNetworkResourceRelationshipsOutput)
    pub fn builder() -> crate::output::get_network_resource_relationships_output::Builder {
        crate::output::get_network_resource_relationships_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetNetworkResourceCountsOutput {
    /// <p>The count of resources.</p>
    pub network_resource_counts:
        std::option::Option<std::vec::Vec<crate::model::NetworkResourceCount>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetNetworkResourceCountsOutput {
    /// <p>The count of resources.</p>
    pub fn network_resource_counts(
        &self,
    ) -> std::option::Option<&[crate::model::NetworkResourceCount]> {
        self.network_resource_counts.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetNetworkResourceCountsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetNetworkResourceCountsOutput");
        formatter.field("network_resource_counts", &self.network_resource_counts);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetNetworkResourceCountsOutput`](crate::output::GetNetworkResourceCountsOutput)
pub mod get_network_resource_counts_output {
    /// A builder for [`GetNetworkResourceCountsOutput`](crate::output::GetNetworkResourceCountsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_resource_counts:
            std::option::Option<std::vec::Vec<crate::model::NetworkResourceCount>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `network_resource_counts`.
        ///
        /// To override the contents of this collection use [`set_network_resource_counts`](Self::set_network_resource_counts).
        ///
        /// <p>The count of resources.</p>
        pub fn network_resource_counts(
            mut self,
            input: crate::model::NetworkResourceCount,
        ) -> Self {
            let mut v = self.network_resource_counts.unwrap_or_default();
            v.push(input);
            self.network_resource_counts = Some(v);
            self
        }
        /// <p>The count of resources.</p>
        pub fn set_network_resource_counts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkResourceCount>>,
        ) -> Self {
            self.network_resource_counts = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetNetworkResourceCountsOutput`](crate::output::GetNetworkResourceCountsOutput)
        pub fn build(self) -> crate::output::GetNetworkResourceCountsOutput {
            crate::output::GetNetworkResourceCountsOutput {
                network_resource_counts: self.network_resource_counts,
                next_token: self.next_token,
            }
        }
    }
}
impl GetNetworkResourceCountsOutput {
    /// Creates a new builder-style object to manufacture [`GetNetworkResourceCountsOutput`](crate::output::GetNetworkResourceCountsOutput)
    pub fn builder() -> crate::output::get_network_resource_counts_output::Builder {
        crate::output::get_network_resource_counts_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLinksOutput {
    /// <p>The links.</p>
    pub links: std::option::Option<std::vec::Vec<crate::model::Link>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetLinksOutput {
    /// <p>The links.</p>
    pub fn links(&self) -> std::option::Option<&[crate::model::Link]> {
        self.links.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetLinksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLinksOutput");
        formatter.field("links", &self.links);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetLinksOutput`](crate::output::GetLinksOutput)
pub mod get_links_output {
    /// A builder for [`GetLinksOutput`](crate::output::GetLinksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) links: std::option::Option<std::vec::Vec<crate::model::Link>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `links`.
        ///
        /// To override the contents of this collection use [`set_links`](Self::set_links).
        ///
        /// <p>The links.</p>
        pub fn links(mut self, input: crate::model::Link) -> Self {
            let mut v = self.links.unwrap_or_default();
            v.push(input);
            self.links = Some(v);
            self
        }
        /// <p>The links.</p>
        pub fn set_links(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Link>>,
        ) -> Self {
            self.links = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLinksOutput`](crate::output::GetLinksOutput)
        pub fn build(self) -> crate::output::GetLinksOutput {
            crate::output::GetLinksOutput {
                links: self.links,
                next_token: self.next_token,
            }
        }
    }
}
impl GetLinksOutput {
    /// Creates a new builder-style object to manufacture [`GetLinksOutput`](crate::output::GetLinksOutput)
    pub fn builder() -> crate::output::get_links_output::Builder {
        crate::output::get_links_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLinkAssociationsOutput {
    /// <p>The link associations.</p>
    pub link_associations: std::option::Option<std::vec::Vec<crate::model::LinkAssociation>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetLinkAssociationsOutput {
    /// <p>The link associations.</p>
    pub fn link_associations(&self) -> std::option::Option<&[crate::model::LinkAssociation]> {
        self.link_associations.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetLinkAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLinkAssociationsOutput");
        formatter.field("link_associations", &self.link_associations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetLinkAssociationsOutput`](crate::output::GetLinkAssociationsOutput)
pub mod get_link_associations_output {
    /// A builder for [`GetLinkAssociationsOutput`](crate::output::GetLinkAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) link_associations:
            std::option::Option<std::vec::Vec<crate::model::LinkAssociation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `link_associations`.
        ///
        /// To override the contents of this collection use [`set_link_associations`](Self::set_link_associations).
        ///
        /// <p>The link associations.</p>
        pub fn link_associations(mut self, input: crate::model::LinkAssociation) -> Self {
            let mut v = self.link_associations.unwrap_or_default();
            v.push(input);
            self.link_associations = Some(v);
            self
        }
        /// <p>The link associations.</p>
        pub fn set_link_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LinkAssociation>>,
        ) -> Self {
            self.link_associations = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLinkAssociationsOutput`](crate::output::GetLinkAssociationsOutput)
        pub fn build(self) -> crate::output::GetLinkAssociationsOutput {
            crate::output::GetLinkAssociationsOutput {
                link_associations: self.link_associations,
                next_token: self.next_token,
            }
        }
    }
}
impl GetLinkAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`GetLinkAssociationsOutput`](crate::output::GetLinkAssociationsOutput)
    pub fn builder() -> crate::output::get_link_associations_output::Builder {
        crate::output::get_link_associations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDevicesOutput {
    /// <p>The devices.</p>
    pub devices: std::option::Option<std::vec::Vec<crate::model::Device>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetDevicesOutput {
    /// <p>The devices.</p>
    pub fn devices(&self) -> std::option::Option<&[crate::model::Device]> {
        self.devices.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetDevicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDevicesOutput");
        formatter.field("devices", &self.devices);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetDevicesOutput`](crate::output::GetDevicesOutput)
pub mod get_devices_output {
    /// A builder for [`GetDevicesOutput`](crate::output::GetDevicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) devices: std::option::Option<std::vec::Vec<crate::model::Device>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `devices`.
        ///
        /// To override the contents of this collection use [`set_devices`](Self::set_devices).
        ///
        /// <p>The devices.</p>
        pub fn devices(mut self, input: crate::model::Device) -> Self {
            let mut v = self.devices.unwrap_or_default();
            v.push(input);
            self.devices = Some(v);
            self
        }
        /// <p>The devices.</p>
        pub fn set_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Device>>,
        ) -> Self {
            self.devices = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDevicesOutput`](crate::output::GetDevicesOutput)
        pub fn build(self) -> crate::output::GetDevicesOutput {
            crate::output::GetDevicesOutput {
                devices: self.devices,
                next_token: self.next_token,
            }
        }
    }
}
impl GetDevicesOutput {
    /// Creates a new builder-style object to manufacture [`GetDevicesOutput`](crate::output::GetDevicesOutput)
    pub fn builder() -> crate::output::get_devices_output::Builder {
        crate::output::get_devices_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCustomerGatewayAssociationsOutput {
    /// <p>The customer gateway associations.</p>
    pub customer_gateway_associations:
        std::option::Option<std::vec::Vec<crate::model::CustomerGatewayAssociation>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetCustomerGatewayAssociationsOutput {
    /// <p>The customer gateway associations.</p>
    pub fn customer_gateway_associations(
        &self,
    ) -> std::option::Option<&[crate::model::CustomerGatewayAssociation]> {
        self.customer_gateway_associations.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetCustomerGatewayAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCustomerGatewayAssociationsOutput");
        formatter.field(
            "customer_gateway_associations",
            &self.customer_gateway_associations,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetCustomerGatewayAssociationsOutput`](crate::output::GetCustomerGatewayAssociationsOutput)
pub mod get_customer_gateway_associations_output {
    /// A builder for [`GetCustomerGatewayAssociationsOutput`](crate::output::GetCustomerGatewayAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) customer_gateway_associations:
            std::option::Option<std::vec::Vec<crate::model::CustomerGatewayAssociation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `customer_gateway_associations`.
        ///
        /// To override the contents of this collection use [`set_customer_gateway_associations`](Self::set_customer_gateway_associations).
        ///
        /// <p>The customer gateway associations.</p>
        pub fn customer_gateway_associations(
            mut self,
            input: crate::model::CustomerGatewayAssociation,
        ) -> Self {
            let mut v = self.customer_gateway_associations.unwrap_or_default();
            v.push(input);
            self.customer_gateway_associations = Some(v);
            self
        }
        /// <p>The customer gateway associations.</p>
        pub fn set_customer_gateway_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomerGatewayAssociation>>,
        ) -> Self {
            self.customer_gateway_associations = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCustomerGatewayAssociationsOutput`](crate::output::GetCustomerGatewayAssociationsOutput)
        pub fn build(self) -> crate::output::GetCustomerGatewayAssociationsOutput {
            crate::output::GetCustomerGatewayAssociationsOutput {
                customer_gateway_associations: self.customer_gateway_associations,
                next_token: self.next_token,
            }
        }
    }
}
impl GetCustomerGatewayAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`GetCustomerGatewayAssociationsOutput`](crate::output::GetCustomerGatewayAssociationsOutput)
    pub fn builder() -> crate::output::get_customer_gateway_associations_output::Builder {
        crate::output::get_customer_gateway_associations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCoreNetworkPolicyOutput {
    /// <p>The details about a core network policy.</p>
    pub core_network_policy: std::option::Option<crate::model::CoreNetworkPolicy>,
}
impl GetCoreNetworkPolicyOutput {
    /// <p>The details about a core network policy.</p>
    pub fn core_network_policy(&self) -> std::option::Option<&crate::model::CoreNetworkPolicy> {
        self.core_network_policy.as_ref()
    }
}
impl std::fmt::Debug for GetCoreNetworkPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCoreNetworkPolicyOutput");
        formatter.field("core_network_policy", &self.core_network_policy);
        formatter.finish()
    }
}
/// See [`GetCoreNetworkPolicyOutput`](crate::output::GetCoreNetworkPolicyOutput)
pub mod get_core_network_policy_output {
    /// A builder for [`GetCoreNetworkPolicyOutput`](crate::output::GetCoreNetworkPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network_policy: std::option::Option<crate::model::CoreNetworkPolicy>,
    }
    impl Builder {
        /// <p>The details about a core network policy.</p>
        pub fn core_network_policy(mut self, input: crate::model::CoreNetworkPolicy) -> Self {
            self.core_network_policy = Some(input);
            self
        }
        /// <p>The details about a core network policy.</p>
        pub fn set_core_network_policy(
            mut self,
            input: std::option::Option<crate::model::CoreNetworkPolicy>,
        ) -> Self {
            self.core_network_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCoreNetworkPolicyOutput`](crate::output::GetCoreNetworkPolicyOutput)
        pub fn build(self) -> crate::output::GetCoreNetworkPolicyOutput {
            crate::output::GetCoreNetworkPolicyOutput {
                core_network_policy: self.core_network_policy,
            }
        }
    }
}
impl GetCoreNetworkPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetCoreNetworkPolicyOutput`](crate::output::GetCoreNetworkPolicyOutput)
    pub fn builder() -> crate::output::get_core_network_policy_output::Builder {
        crate::output::get_core_network_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCoreNetworkChangeSetOutput {
    /// <p>Describes a core network changes.</p>
    pub core_network_changes: std::option::Option<std::vec::Vec<crate::model::CoreNetworkChange>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetCoreNetworkChangeSetOutput {
    /// <p>Describes a core network changes.</p>
    pub fn core_network_changes(&self) -> std::option::Option<&[crate::model::CoreNetworkChange]> {
        self.core_network_changes.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetCoreNetworkChangeSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCoreNetworkChangeSetOutput");
        formatter.field("core_network_changes", &self.core_network_changes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetCoreNetworkChangeSetOutput`](crate::output::GetCoreNetworkChangeSetOutput)
pub mod get_core_network_change_set_output {
    /// A builder for [`GetCoreNetworkChangeSetOutput`](crate::output::GetCoreNetworkChangeSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network_changes:
            std::option::Option<std::vec::Vec<crate::model::CoreNetworkChange>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `core_network_changes`.
        ///
        /// To override the contents of this collection use [`set_core_network_changes`](Self::set_core_network_changes).
        ///
        /// <p>Describes a core network changes.</p>
        pub fn core_network_changes(mut self, input: crate::model::CoreNetworkChange) -> Self {
            let mut v = self.core_network_changes.unwrap_or_default();
            v.push(input);
            self.core_network_changes = Some(v);
            self
        }
        /// <p>Describes a core network changes.</p>
        pub fn set_core_network_changes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CoreNetworkChange>>,
        ) -> Self {
            self.core_network_changes = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCoreNetworkChangeSetOutput`](crate::output::GetCoreNetworkChangeSetOutput)
        pub fn build(self) -> crate::output::GetCoreNetworkChangeSetOutput {
            crate::output::GetCoreNetworkChangeSetOutput {
                core_network_changes: self.core_network_changes,
                next_token: self.next_token,
            }
        }
    }
}
impl GetCoreNetworkChangeSetOutput {
    /// Creates a new builder-style object to manufacture [`GetCoreNetworkChangeSetOutput`](crate::output::GetCoreNetworkChangeSetOutput)
    pub fn builder() -> crate::output::get_core_network_change_set_output::Builder {
        crate::output::get_core_network_change_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCoreNetworkOutput {
    /// <p>Details about a core network.</p>
    pub core_network: std::option::Option<crate::model::CoreNetwork>,
}
impl GetCoreNetworkOutput {
    /// <p>Details about a core network.</p>
    pub fn core_network(&self) -> std::option::Option<&crate::model::CoreNetwork> {
        self.core_network.as_ref()
    }
}
impl std::fmt::Debug for GetCoreNetworkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCoreNetworkOutput");
        formatter.field("core_network", &self.core_network);
        formatter.finish()
    }
}
/// See [`GetCoreNetworkOutput`](crate::output::GetCoreNetworkOutput)
pub mod get_core_network_output {
    /// A builder for [`GetCoreNetworkOutput`](crate::output::GetCoreNetworkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network: std::option::Option<crate::model::CoreNetwork>,
    }
    impl Builder {
        /// <p>Details about a core network.</p>
        pub fn core_network(mut self, input: crate::model::CoreNetwork) -> Self {
            self.core_network = Some(input);
            self
        }
        /// <p>Details about a core network.</p>
        pub fn set_core_network(
            mut self,
            input: std::option::Option<crate::model::CoreNetwork>,
        ) -> Self {
            self.core_network = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCoreNetworkOutput`](crate::output::GetCoreNetworkOutput)
        pub fn build(self) -> crate::output::GetCoreNetworkOutput {
            crate::output::GetCoreNetworkOutput {
                core_network: self.core_network,
            }
        }
    }
}
impl GetCoreNetworkOutput {
    /// Creates a new builder-style object to manufacture [`GetCoreNetworkOutput`](crate::output::GetCoreNetworkOutput)
    pub fn builder() -> crate::output::get_core_network_output::Builder {
        crate::output::get_core_network_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConnectPeerAssociationsOutput {
    /// <p>Displays a list of Connect peer associations.</p>
    pub connect_peer_associations:
        std::option::Option<std::vec::Vec<crate::model::ConnectPeerAssociation>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetConnectPeerAssociationsOutput {
    /// <p>Displays a list of Connect peer associations.</p>
    pub fn connect_peer_associations(
        &self,
    ) -> std::option::Option<&[crate::model::ConnectPeerAssociation]> {
        self.connect_peer_associations.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetConnectPeerAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConnectPeerAssociationsOutput");
        formatter.field("connect_peer_associations", &self.connect_peer_associations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetConnectPeerAssociationsOutput`](crate::output::GetConnectPeerAssociationsOutput)
pub mod get_connect_peer_associations_output {
    /// A builder for [`GetConnectPeerAssociationsOutput`](crate::output::GetConnectPeerAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connect_peer_associations:
            std::option::Option<std::vec::Vec<crate::model::ConnectPeerAssociation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `connect_peer_associations`.
        ///
        /// To override the contents of this collection use [`set_connect_peer_associations`](Self::set_connect_peer_associations).
        ///
        /// <p>Displays a list of Connect peer associations.</p>
        pub fn connect_peer_associations(
            mut self,
            input: crate::model::ConnectPeerAssociation,
        ) -> Self {
            let mut v = self.connect_peer_associations.unwrap_or_default();
            v.push(input);
            self.connect_peer_associations = Some(v);
            self
        }
        /// <p>Displays a list of Connect peer associations.</p>
        pub fn set_connect_peer_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectPeerAssociation>>,
        ) -> Self {
            self.connect_peer_associations = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConnectPeerAssociationsOutput`](crate::output::GetConnectPeerAssociationsOutput)
        pub fn build(self) -> crate::output::GetConnectPeerAssociationsOutput {
            crate::output::GetConnectPeerAssociationsOutput {
                connect_peer_associations: self.connect_peer_associations,
                next_token: self.next_token,
            }
        }
    }
}
impl GetConnectPeerAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`GetConnectPeerAssociationsOutput`](crate::output::GetConnectPeerAssociationsOutput)
    pub fn builder() -> crate::output::get_connect_peer_associations_output::Builder {
        crate::output::get_connect_peer_associations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConnectPeerOutput {
    /// <p>Returns information about a core network Connect peer.</p>
    pub connect_peer: std::option::Option<crate::model::ConnectPeer>,
}
impl GetConnectPeerOutput {
    /// <p>Returns information about a core network Connect peer.</p>
    pub fn connect_peer(&self) -> std::option::Option<&crate::model::ConnectPeer> {
        self.connect_peer.as_ref()
    }
}
impl std::fmt::Debug for GetConnectPeerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConnectPeerOutput");
        formatter.field("connect_peer", &self.connect_peer);
        formatter.finish()
    }
}
/// See [`GetConnectPeerOutput`](crate::output::GetConnectPeerOutput)
pub mod get_connect_peer_output {
    /// A builder for [`GetConnectPeerOutput`](crate::output::GetConnectPeerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connect_peer: std::option::Option<crate::model::ConnectPeer>,
    }
    impl Builder {
        /// <p>Returns information about a core network Connect peer.</p>
        pub fn connect_peer(mut self, input: crate::model::ConnectPeer) -> Self {
            self.connect_peer = Some(input);
            self
        }
        /// <p>Returns information about a core network Connect peer.</p>
        pub fn set_connect_peer(
            mut self,
            input: std::option::Option<crate::model::ConnectPeer>,
        ) -> Self {
            self.connect_peer = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConnectPeerOutput`](crate::output::GetConnectPeerOutput)
        pub fn build(self) -> crate::output::GetConnectPeerOutput {
            crate::output::GetConnectPeerOutput {
                connect_peer: self.connect_peer,
            }
        }
    }
}
impl GetConnectPeerOutput {
    /// Creates a new builder-style object to manufacture [`GetConnectPeerOutput`](crate::output::GetConnectPeerOutput)
    pub fn builder() -> crate::output::get_connect_peer_output::Builder {
        crate::output::get_connect_peer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConnectionsOutput {
    /// <p>Information about the connections.</p>
    pub connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
    /// <p>The token to use for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetConnectionsOutput {
    /// <p>Information about the connections.</p>
    pub fn connections(&self) -> std::option::Option<&[crate::model::Connection]> {
        self.connections.as_deref()
    }
    /// <p>The token to use for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetConnectionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConnectionsOutput");
        formatter.field("connections", &self.connections);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetConnectionsOutput`](crate::output::GetConnectionsOutput)
pub mod get_connections_output {
    /// A builder for [`GetConnectionsOutput`](crate::output::GetConnectionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `connections`.
        ///
        /// To override the contents of this collection use [`set_connections`](Self::set_connections).
        ///
        /// <p>Information about the connections.</p>
        pub fn connections(mut self, input: crate::model::Connection) -> Self {
            let mut v = self.connections.unwrap_or_default();
            v.push(input);
            self.connections = Some(v);
            self
        }
        /// <p>Information about the connections.</p>
        pub fn set_connections(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        ) -> Self {
            self.connections = input;
            self
        }
        /// <p>The token to use for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConnectionsOutput`](crate::output::GetConnectionsOutput)
        pub fn build(self) -> crate::output::GetConnectionsOutput {
            crate::output::GetConnectionsOutput {
                connections: self.connections,
                next_token: self.next_token,
            }
        }
    }
}
impl GetConnectionsOutput {
    /// Creates a new builder-style object to manufacture [`GetConnectionsOutput`](crate::output::GetConnectionsOutput)
    pub fn builder() -> crate::output::get_connections_output::Builder {
        crate::output::get_connections_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConnectAttachmentOutput {
    /// <p>Details about the Connect attachment.</p>
    pub connect_attachment: std::option::Option<crate::model::ConnectAttachment>,
}
impl GetConnectAttachmentOutput {
    /// <p>Details about the Connect attachment.</p>
    pub fn connect_attachment(&self) -> std::option::Option<&crate::model::ConnectAttachment> {
        self.connect_attachment.as_ref()
    }
}
impl std::fmt::Debug for GetConnectAttachmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConnectAttachmentOutput");
        formatter.field("connect_attachment", &self.connect_attachment);
        formatter.finish()
    }
}
/// See [`GetConnectAttachmentOutput`](crate::output::GetConnectAttachmentOutput)
pub mod get_connect_attachment_output {
    /// A builder for [`GetConnectAttachmentOutput`](crate::output::GetConnectAttachmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connect_attachment: std::option::Option<crate::model::ConnectAttachment>,
    }
    impl Builder {
        /// <p>Details about the Connect attachment.</p>
        pub fn connect_attachment(mut self, input: crate::model::ConnectAttachment) -> Self {
            self.connect_attachment = Some(input);
            self
        }
        /// <p>Details about the Connect attachment.</p>
        pub fn set_connect_attachment(
            mut self,
            input: std::option::Option<crate::model::ConnectAttachment>,
        ) -> Self {
            self.connect_attachment = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConnectAttachmentOutput`](crate::output::GetConnectAttachmentOutput)
        pub fn build(self) -> crate::output::GetConnectAttachmentOutput {
            crate::output::GetConnectAttachmentOutput {
                connect_attachment: self.connect_attachment,
            }
        }
    }
}
impl GetConnectAttachmentOutput {
    /// Creates a new builder-style object to manufacture [`GetConnectAttachmentOutput`](crate::output::GetConnectAttachmentOutput)
    pub fn builder() -> crate::output::get_connect_attachment_output::Builder {
        crate::output::get_connect_attachment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteCoreNetworkChangeSetOutput {}
impl std::fmt::Debug for ExecuteCoreNetworkChangeSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteCoreNetworkChangeSetOutput");
        formatter.finish()
    }
}
/// See [`ExecuteCoreNetworkChangeSetOutput`](crate::output::ExecuteCoreNetworkChangeSetOutput)
pub mod execute_core_network_change_set_output {
    /// A builder for [`ExecuteCoreNetworkChangeSetOutput`](crate::output::ExecuteCoreNetworkChangeSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ExecuteCoreNetworkChangeSetOutput`](crate::output::ExecuteCoreNetworkChangeSetOutput)
        pub fn build(self) -> crate::output::ExecuteCoreNetworkChangeSetOutput {
            crate::output::ExecuteCoreNetworkChangeSetOutput {}
        }
    }
}
impl ExecuteCoreNetworkChangeSetOutput {
    /// Creates a new builder-style object to manufacture [`ExecuteCoreNetworkChangeSetOutput`](crate::output::ExecuteCoreNetworkChangeSetOutput)
    pub fn builder() -> crate::output::execute_core_network_change_set_output::Builder {
        crate::output::execute_core_network_change_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateTransitGatewayConnectPeerOutput {
    /// <p>The transit gateway Connect peer association.</p>
    pub transit_gateway_connect_peer_association:
        std::option::Option<crate::model::TransitGatewayConnectPeerAssociation>,
}
impl DisassociateTransitGatewayConnectPeerOutput {
    /// <p>The transit gateway Connect peer association.</p>
    pub fn transit_gateway_connect_peer_association(
        &self,
    ) -> std::option::Option<&crate::model::TransitGatewayConnectPeerAssociation> {
        self.transit_gateway_connect_peer_association.as_ref()
    }
}
impl std::fmt::Debug for DisassociateTransitGatewayConnectPeerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateTransitGatewayConnectPeerOutput");
        formatter.field(
            "transit_gateway_connect_peer_association",
            &self.transit_gateway_connect_peer_association,
        );
        formatter.finish()
    }
}
/// See [`DisassociateTransitGatewayConnectPeerOutput`](crate::output::DisassociateTransitGatewayConnectPeerOutput)
pub mod disassociate_transit_gateway_connect_peer_output {
    /// A builder for [`DisassociateTransitGatewayConnectPeerOutput`](crate::output::DisassociateTransitGatewayConnectPeerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_connect_peer_association:
            std::option::Option<crate::model::TransitGatewayConnectPeerAssociation>,
    }
    impl Builder {
        /// <p>The transit gateway Connect peer association.</p>
        pub fn transit_gateway_connect_peer_association(
            mut self,
            input: crate::model::TransitGatewayConnectPeerAssociation,
        ) -> Self {
            self.transit_gateway_connect_peer_association = Some(input);
            self
        }
        /// <p>The transit gateway Connect peer association.</p>
        pub fn set_transit_gateway_connect_peer_association(
            mut self,
            input: std::option::Option<crate::model::TransitGatewayConnectPeerAssociation>,
        ) -> Self {
            self.transit_gateway_connect_peer_association = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateTransitGatewayConnectPeerOutput`](crate::output::DisassociateTransitGatewayConnectPeerOutput)
        pub fn build(self) -> crate::output::DisassociateTransitGatewayConnectPeerOutput {
            crate::output::DisassociateTransitGatewayConnectPeerOutput {
                transit_gateway_connect_peer_association: self
                    .transit_gateway_connect_peer_association,
            }
        }
    }
}
impl DisassociateTransitGatewayConnectPeerOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateTransitGatewayConnectPeerOutput`](crate::output::DisassociateTransitGatewayConnectPeerOutput)
    pub fn builder() -> crate::output::disassociate_transit_gateway_connect_peer_output::Builder {
        crate::output::disassociate_transit_gateway_connect_peer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateLinkOutput {
    /// <p>Information about the link association.</p>
    pub link_association: std::option::Option<crate::model::LinkAssociation>,
}
impl DisassociateLinkOutput {
    /// <p>Information about the link association.</p>
    pub fn link_association(&self) -> std::option::Option<&crate::model::LinkAssociation> {
        self.link_association.as_ref()
    }
}
impl std::fmt::Debug for DisassociateLinkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateLinkOutput");
        formatter.field("link_association", &self.link_association);
        formatter.finish()
    }
}
/// See [`DisassociateLinkOutput`](crate::output::DisassociateLinkOutput)
pub mod disassociate_link_output {
    /// A builder for [`DisassociateLinkOutput`](crate::output::DisassociateLinkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) link_association: std::option::Option<crate::model::LinkAssociation>,
    }
    impl Builder {
        /// <p>Information about the link association.</p>
        pub fn link_association(mut self, input: crate::model::LinkAssociation) -> Self {
            self.link_association = Some(input);
            self
        }
        /// <p>Information about the link association.</p>
        pub fn set_link_association(
            mut self,
            input: std::option::Option<crate::model::LinkAssociation>,
        ) -> Self {
            self.link_association = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateLinkOutput`](crate::output::DisassociateLinkOutput)
        pub fn build(self) -> crate::output::DisassociateLinkOutput {
            crate::output::DisassociateLinkOutput {
                link_association: self.link_association,
            }
        }
    }
}
impl DisassociateLinkOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateLinkOutput`](crate::output::DisassociateLinkOutput)
    pub fn builder() -> crate::output::disassociate_link_output::Builder {
        crate::output::disassociate_link_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateCustomerGatewayOutput {
    /// <p>Information about the customer gateway association.</p>
    pub customer_gateway_association: std::option::Option<crate::model::CustomerGatewayAssociation>,
}
impl DisassociateCustomerGatewayOutput {
    /// <p>Information about the customer gateway association.</p>
    pub fn customer_gateway_association(
        &self,
    ) -> std::option::Option<&crate::model::CustomerGatewayAssociation> {
        self.customer_gateway_association.as_ref()
    }
}
impl std::fmt::Debug for DisassociateCustomerGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateCustomerGatewayOutput");
        formatter.field(
            "customer_gateway_association",
            &self.customer_gateway_association,
        );
        formatter.finish()
    }
}
/// See [`DisassociateCustomerGatewayOutput`](crate::output::DisassociateCustomerGatewayOutput)
pub mod disassociate_customer_gateway_output {
    /// A builder for [`DisassociateCustomerGatewayOutput`](crate::output::DisassociateCustomerGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) customer_gateway_association:
            std::option::Option<crate::model::CustomerGatewayAssociation>,
    }
    impl Builder {
        /// <p>Information about the customer gateway association.</p>
        pub fn customer_gateway_association(
            mut self,
            input: crate::model::CustomerGatewayAssociation,
        ) -> Self {
            self.customer_gateway_association = Some(input);
            self
        }
        /// <p>Information about the customer gateway association.</p>
        pub fn set_customer_gateway_association(
            mut self,
            input: std::option::Option<crate::model::CustomerGatewayAssociation>,
        ) -> Self {
            self.customer_gateway_association = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateCustomerGatewayOutput`](crate::output::DisassociateCustomerGatewayOutput)
        pub fn build(self) -> crate::output::DisassociateCustomerGatewayOutput {
            crate::output::DisassociateCustomerGatewayOutput {
                customer_gateway_association: self.customer_gateway_association,
            }
        }
    }
}
impl DisassociateCustomerGatewayOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateCustomerGatewayOutput`](crate::output::DisassociateCustomerGatewayOutput)
    pub fn builder() -> crate::output::disassociate_customer_gateway_output::Builder {
        crate::output::disassociate_customer_gateway_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateConnectPeerOutput {
    /// <p>Describes the Connect peer association.</p>
    pub connect_peer_association: std::option::Option<crate::model::ConnectPeerAssociation>,
}
impl DisassociateConnectPeerOutput {
    /// <p>Describes the Connect peer association.</p>
    pub fn connect_peer_association(
        &self,
    ) -> std::option::Option<&crate::model::ConnectPeerAssociation> {
        self.connect_peer_association.as_ref()
    }
}
impl std::fmt::Debug for DisassociateConnectPeerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateConnectPeerOutput");
        formatter.field("connect_peer_association", &self.connect_peer_association);
        formatter.finish()
    }
}
/// See [`DisassociateConnectPeerOutput`](crate::output::DisassociateConnectPeerOutput)
pub mod disassociate_connect_peer_output {
    /// A builder for [`DisassociateConnectPeerOutput`](crate::output::DisassociateConnectPeerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connect_peer_association:
            std::option::Option<crate::model::ConnectPeerAssociation>,
    }
    impl Builder {
        /// <p>Describes the Connect peer association.</p>
        pub fn connect_peer_association(
            mut self,
            input: crate::model::ConnectPeerAssociation,
        ) -> Self {
            self.connect_peer_association = Some(input);
            self
        }
        /// <p>Describes the Connect peer association.</p>
        pub fn set_connect_peer_association(
            mut self,
            input: std::option::Option<crate::model::ConnectPeerAssociation>,
        ) -> Self {
            self.connect_peer_association = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateConnectPeerOutput`](crate::output::DisassociateConnectPeerOutput)
        pub fn build(self) -> crate::output::DisassociateConnectPeerOutput {
            crate::output::DisassociateConnectPeerOutput {
                connect_peer_association: self.connect_peer_association,
            }
        }
    }
}
impl DisassociateConnectPeerOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateConnectPeerOutput`](crate::output::DisassociateConnectPeerOutput)
    pub fn builder() -> crate::output::disassociate_connect_peer_output::Builder {
        crate::output::disassociate_connect_peer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGlobalNetworksOutput {
    /// <p>Information about the global networks.</p>
    pub global_networks: std::option::Option<std::vec::Vec<crate::model::GlobalNetwork>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeGlobalNetworksOutput {
    /// <p>Information about the global networks.</p>
    pub fn global_networks(&self) -> std::option::Option<&[crate::model::GlobalNetwork]> {
        self.global_networks.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeGlobalNetworksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGlobalNetworksOutput");
        formatter.field("global_networks", &self.global_networks);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeGlobalNetworksOutput`](crate::output::DescribeGlobalNetworksOutput)
pub mod describe_global_networks_output {
    /// A builder for [`DescribeGlobalNetworksOutput`](crate::output::DescribeGlobalNetworksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_networks: std::option::Option<std::vec::Vec<crate::model::GlobalNetwork>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `global_networks`.
        ///
        /// To override the contents of this collection use [`set_global_networks`](Self::set_global_networks).
        ///
        /// <p>Information about the global networks.</p>
        pub fn global_networks(mut self, input: crate::model::GlobalNetwork) -> Self {
            let mut v = self.global_networks.unwrap_or_default();
            v.push(input);
            self.global_networks = Some(v);
            self
        }
        /// <p>Information about the global networks.</p>
        pub fn set_global_networks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalNetwork>>,
        ) -> Self {
            self.global_networks = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGlobalNetworksOutput`](crate::output::DescribeGlobalNetworksOutput)
        pub fn build(self) -> crate::output::DescribeGlobalNetworksOutput {
            crate::output::DescribeGlobalNetworksOutput {
                global_networks: self.global_networks,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeGlobalNetworksOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGlobalNetworksOutput`](crate::output::DescribeGlobalNetworksOutput)
    pub fn builder() -> crate::output::describe_global_networks_output::Builder {
        crate::output::describe_global_networks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterTransitGatewayOutput {
    /// <p>The transit gateway registration information.</p>
    pub transit_gateway_registration: std::option::Option<crate::model::TransitGatewayRegistration>,
}
impl DeregisterTransitGatewayOutput {
    /// <p>The transit gateway registration information.</p>
    pub fn transit_gateway_registration(
        &self,
    ) -> std::option::Option<&crate::model::TransitGatewayRegistration> {
        self.transit_gateway_registration.as_ref()
    }
}
impl std::fmt::Debug for DeregisterTransitGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterTransitGatewayOutput");
        formatter.field(
            "transit_gateway_registration",
            &self.transit_gateway_registration,
        );
        formatter.finish()
    }
}
/// See [`DeregisterTransitGatewayOutput`](crate::output::DeregisterTransitGatewayOutput)
pub mod deregister_transit_gateway_output {
    /// A builder for [`DeregisterTransitGatewayOutput`](crate::output::DeregisterTransitGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_registration:
            std::option::Option<crate::model::TransitGatewayRegistration>,
    }
    impl Builder {
        /// <p>The transit gateway registration information.</p>
        pub fn transit_gateway_registration(
            mut self,
            input: crate::model::TransitGatewayRegistration,
        ) -> Self {
            self.transit_gateway_registration = Some(input);
            self
        }
        /// <p>The transit gateway registration information.</p>
        pub fn set_transit_gateway_registration(
            mut self,
            input: std::option::Option<crate::model::TransitGatewayRegistration>,
        ) -> Self {
            self.transit_gateway_registration = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterTransitGatewayOutput`](crate::output::DeregisterTransitGatewayOutput)
        pub fn build(self) -> crate::output::DeregisterTransitGatewayOutput {
            crate::output::DeregisterTransitGatewayOutput {
                transit_gateway_registration: self.transit_gateway_registration,
            }
        }
    }
}
impl DeregisterTransitGatewayOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterTransitGatewayOutput`](crate::output::DeregisterTransitGatewayOutput)
    pub fn builder() -> crate::output::deregister_transit_gateway_output::Builder {
        crate::output::deregister_transit_gateway_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSiteOutput {
    /// <p>Information about the site.</p>
    pub site: std::option::Option<crate::model::Site>,
}
impl DeleteSiteOutput {
    /// <p>Information about the site.</p>
    pub fn site(&self) -> std::option::Option<&crate::model::Site> {
        self.site.as_ref()
    }
}
impl std::fmt::Debug for DeleteSiteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSiteOutput");
        formatter.field("site", &self.site);
        formatter.finish()
    }
}
/// See [`DeleteSiteOutput`](crate::output::DeleteSiteOutput)
pub mod delete_site_output {
    /// A builder for [`DeleteSiteOutput`](crate::output::DeleteSiteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site: std::option::Option<crate::model::Site>,
    }
    impl Builder {
        /// <p>Information about the site.</p>
        pub fn site(mut self, input: crate::model::Site) -> Self {
            self.site = Some(input);
            self
        }
        /// <p>Information about the site.</p>
        pub fn set_site(mut self, input: std::option::Option<crate::model::Site>) -> Self {
            self.site = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSiteOutput`](crate::output::DeleteSiteOutput)
        pub fn build(self) -> crate::output::DeleteSiteOutput {
            crate::output::DeleteSiteOutput { site: self.site }
        }
    }
}
impl DeleteSiteOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSiteOutput`](crate::output::DeleteSiteOutput)
    pub fn builder() -> crate::output::delete_site_output::Builder {
        crate::output::delete_site_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourcePolicyOutput {}
impl std::fmt::Debug for DeleteResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourcePolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
pub mod delete_resource_policy_output {
    /// A builder for [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
        pub fn build(self) -> crate::output::DeleteResourcePolicyOutput {
            crate::output::DeleteResourcePolicyOutput {}
        }
    }
}
impl DeleteResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
    pub fn builder() -> crate::output::delete_resource_policy_output::Builder {
        crate::output::delete_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLinkOutput {
    /// <p>Information about the link.</p>
    pub link: std::option::Option<crate::model::Link>,
}
impl DeleteLinkOutput {
    /// <p>Information about the link.</p>
    pub fn link(&self) -> std::option::Option<&crate::model::Link> {
        self.link.as_ref()
    }
}
impl std::fmt::Debug for DeleteLinkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLinkOutput");
        formatter.field("link", &self.link);
        formatter.finish()
    }
}
/// See [`DeleteLinkOutput`](crate::output::DeleteLinkOutput)
pub mod delete_link_output {
    /// A builder for [`DeleteLinkOutput`](crate::output::DeleteLinkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) link: std::option::Option<crate::model::Link>,
    }
    impl Builder {
        /// <p>Information about the link.</p>
        pub fn link(mut self, input: crate::model::Link) -> Self {
            self.link = Some(input);
            self
        }
        /// <p>Information about the link.</p>
        pub fn set_link(mut self, input: std::option::Option<crate::model::Link>) -> Self {
            self.link = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLinkOutput`](crate::output::DeleteLinkOutput)
        pub fn build(self) -> crate::output::DeleteLinkOutput {
            crate::output::DeleteLinkOutput { link: self.link }
        }
    }
}
impl DeleteLinkOutput {
    /// Creates a new builder-style object to manufacture [`DeleteLinkOutput`](crate::output::DeleteLinkOutput)
    pub fn builder() -> crate::output::delete_link_output::Builder {
        crate::output::delete_link_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGlobalNetworkOutput {
    /// <p>Information about the global network.</p>
    pub global_network: std::option::Option<crate::model::GlobalNetwork>,
}
impl DeleteGlobalNetworkOutput {
    /// <p>Information about the global network.</p>
    pub fn global_network(&self) -> std::option::Option<&crate::model::GlobalNetwork> {
        self.global_network.as_ref()
    }
}
impl std::fmt::Debug for DeleteGlobalNetworkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGlobalNetworkOutput");
        formatter.field("global_network", &self.global_network);
        formatter.finish()
    }
}
/// See [`DeleteGlobalNetworkOutput`](crate::output::DeleteGlobalNetworkOutput)
pub mod delete_global_network_output {
    /// A builder for [`DeleteGlobalNetworkOutput`](crate::output::DeleteGlobalNetworkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network: std::option::Option<crate::model::GlobalNetwork>,
    }
    impl Builder {
        /// <p>Information about the global network.</p>
        pub fn global_network(mut self, input: crate::model::GlobalNetwork) -> Self {
            self.global_network = Some(input);
            self
        }
        /// <p>Information about the global network.</p>
        pub fn set_global_network(
            mut self,
            input: std::option::Option<crate::model::GlobalNetwork>,
        ) -> Self {
            self.global_network = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGlobalNetworkOutput`](crate::output::DeleteGlobalNetworkOutput)
        pub fn build(self) -> crate::output::DeleteGlobalNetworkOutput {
            crate::output::DeleteGlobalNetworkOutput {
                global_network: self.global_network,
            }
        }
    }
}
impl DeleteGlobalNetworkOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGlobalNetworkOutput`](crate::output::DeleteGlobalNetworkOutput)
    pub fn builder() -> crate::output::delete_global_network_output::Builder {
        crate::output::delete_global_network_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDeviceOutput {
    /// <p>Information about the device.</p>
    pub device: std::option::Option<crate::model::Device>,
}
impl DeleteDeviceOutput {
    /// <p>Information about the device.</p>
    pub fn device(&self) -> std::option::Option<&crate::model::Device> {
        self.device.as_ref()
    }
}
impl std::fmt::Debug for DeleteDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDeviceOutput");
        formatter.field("device", &self.device);
        formatter.finish()
    }
}
/// See [`DeleteDeviceOutput`](crate::output::DeleteDeviceOutput)
pub mod delete_device_output {
    /// A builder for [`DeleteDeviceOutput`](crate::output::DeleteDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device: std::option::Option<crate::model::Device>,
    }
    impl Builder {
        /// <p>Information about the device.</p>
        pub fn device(mut self, input: crate::model::Device) -> Self {
            self.device = Some(input);
            self
        }
        /// <p>Information about the device.</p>
        pub fn set_device(mut self, input: std::option::Option<crate::model::Device>) -> Self {
            self.device = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDeviceOutput`](crate::output::DeleteDeviceOutput)
        pub fn build(self) -> crate::output::DeleteDeviceOutput {
            crate::output::DeleteDeviceOutput {
                device: self.device,
            }
        }
    }
}
impl DeleteDeviceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDeviceOutput`](crate::output::DeleteDeviceOutput)
    pub fn builder() -> crate::output::delete_device_output::Builder {
        crate::output::delete_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCoreNetworkPolicyVersionOutput {
    /// <p>Returns information about the deleted policy version. </p>
    pub core_network_policy: std::option::Option<crate::model::CoreNetworkPolicy>,
}
impl DeleteCoreNetworkPolicyVersionOutput {
    /// <p>Returns information about the deleted policy version. </p>
    pub fn core_network_policy(&self) -> std::option::Option<&crate::model::CoreNetworkPolicy> {
        self.core_network_policy.as_ref()
    }
}
impl std::fmt::Debug for DeleteCoreNetworkPolicyVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCoreNetworkPolicyVersionOutput");
        formatter.field("core_network_policy", &self.core_network_policy);
        formatter.finish()
    }
}
/// See [`DeleteCoreNetworkPolicyVersionOutput`](crate::output::DeleteCoreNetworkPolicyVersionOutput)
pub mod delete_core_network_policy_version_output {
    /// A builder for [`DeleteCoreNetworkPolicyVersionOutput`](crate::output::DeleteCoreNetworkPolicyVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network_policy: std::option::Option<crate::model::CoreNetworkPolicy>,
    }
    impl Builder {
        /// <p>Returns information about the deleted policy version. </p>
        pub fn core_network_policy(mut self, input: crate::model::CoreNetworkPolicy) -> Self {
            self.core_network_policy = Some(input);
            self
        }
        /// <p>Returns information about the deleted policy version. </p>
        pub fn set_core_network_policy(
            mut self,
            input: std::option::Option<crate::model::CoreNetworkPolicy>,
        ) -> Self {
            self.core_network_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCoreNetworkPolicyVersionOutput`](crate::output::DeleteCoreNetworkPolicyVersionOutput)
        pub fn build(self) -> crate::output::DeleteCoreNetworkPolicyVersionOutput {
            crate::output::DeleteCoreNetworkPolicyVersionOutput {
                core_network_policy: self.core_network_policy,
            }
        }
    }
}
impl DeleteCoreNetworkPolicyVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCoreNetworkPolicyVersionOutput`](crate::output::DeleteCoreNetworkPolicyVersionOutput)
    pub fn builder() -> crate::output::delete_core_network_policy_version_output::Builder {
        crate::output::delete_core_network_policy_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCoreNetworkOutput {
    /// <p>Information about the deleted core network.</p>
    pub core_network: std::option::Option<crate::model::CoreNetwork>,
}
impl DeleteCoreNetworkOutput {
    /// <p>Information about the deleted core network.</p>
    pub fn core_network(&self) -> std::option::Option<&crate::model::CoreNetwork> {
        self.core_network.as_ref()
    }
}
impl std::fmt::Debug for DeleteCoreNetworkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCoreNetworkOutput");
        formatter.field("core_network", &self.core_network);
        formatter.finish()
    }
}
/// See [`DeleteCoreNetworkOutput`](crate::output::DeleteCoreNetworkOutput)
pub mod delete_core_network_output {
    /// A builder for [`DeleteCoreNetworkOutput`](crate::output::DeleteCoreNetworkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network: std::option::Option<crate::model::CoreNetwork>,
    }
    impl Builder {
        /// <p>Information about the deleted core network.</p>
        pub fn core_network(mut self, input: crate::model::CoreNetwork) -> Self {
            self.core_network = Some(input);
            self
        }
        /// <p>Information about the deleted core network.</p>
        pub fn set_core_network(
            mut self,
            input: std::option::Option<crate::model::CoreNetwork>,
        ) -> Self {
            self.core_network = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCoreNetworkOutput`](crate::output::DeleteCoreNetworkOutput)
        pub fn build(self) -> crate::output::DeleteCoreNetworkOutput {
            crate::output::DeleteCoreNetworkOutput {
                core_network: self.core_network,
            }
        }
    }
}
impl DeleteCoreNetworkOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCoreNetworkOutput`](crate::output::DeleteCoreNetworkOutput)
    pub fn builder() -> crate::output::delete_core_network_output::Builder {
        crate::output::delete_core_network_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConnectPeerOutput {
    /// <p>Information about the deleted Connect peer.</p>
    pub connect_peer: std::option::Option<crate::model::ConnectPeer>,
}
impl DeleteConnectPeerOutput {
    /// <p>Information about the deleted Connect peer.</p>
    pub fn connect_peer(&self) -> std::option::Option<&crate::model::ConnectPeer> {
        self.connect_peer.as_ref()
    }
}
impl std::fmt::Debug for DeleteConnectPeerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConnectPeerOutput");
        formatter.field("connect_peer", &self.connect_peer);
        formatter.finish()
    }
}
/// See [`DeleteConnectPeerOutput`](crate::output::DeleteConnectPeerOutput)
pub mod delete_connect_peer_output {
    /// A builder for [`DeleteConnectPeerOutput`](crate::output::DeleteConnectPeerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connect_peer: std::option::Option<crate::model::ConnectPeer>,
    }
    impl Builder {
        /// <p>Information about the deleted Connect peer.</p>
        pub fn connect_peer(mut self, input: crate::model::ConnectPeer) -> Self {
            self.connect_peer = Some(input);
            self
        }
        /// <p>Information about the deleted Connect peer.</p>
        pub fn set_connect_peer(
            mut self,
            input: std::option::Option<crate::model::ConnectPeer>,
        ) -> Self {
            self.connect_peer = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConnectPeerOutput`](crate::output::DeleteConnectPeerOutput)
        pub fn build(self) -> crate::output::DeleteConnectPeerOutput {
            crate::output::DeleteConnectPeerOutput {
                connect_peer: self.connect_peer,
            }
        }
    }
}
impl DeleteConnectPeerOutput {
    /// Creates a new builder-style object to manufacture [`DeleteConnectPeerOutput`](crate::output::DeleteConnectPeerOutput)
    pub fn builder() -> crate::output::delete_connect_peer_output::Builder {
        crate::output::delete_connect_peer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConnectionOutput {
    /// <p>Information about the connection.</p>
    pub connection: std::option::Option<crate::model::Connection>,
}
impl DeleteConnectionOutput {
    /// <p>Information about the connection.</p>
    pub fn connection(&self) -> std::option::Option<&crate::model::Connection> {
        self.connection.as_ref()
    }
}
impl std::fmt::Debug for DeleteConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConnectionOutput");
        formatter.field("connection", &self.connection);
        formatter.finish()
    }
}
/// See [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
pub mod delete_connection_output {
    /// A builder for [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection: std::option::Option<crate::model::Connection>,
    }
    impl Builder {
        /// <p>Information about the connection.</p>
        pub fn connection(mut self, input: crate::model::Connection) -> Self {
            self.connection = Some(input);
            self
        }
        /// <p>Information about the connection.</p>
        pub fn set_connection(
            mut self,
            input: std::option::Option<crate::model::Connection>,
        ) -> Self {
            self.connection = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
        pub fn build(self) -> crate::output::DeleteConnectionOutput {
            crate::output::DeleteConnectionOutput {
                connection: self.connection,
            }
        }
    }
}
impl DeleteConnectionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
    pub fn builder() -> crate::output::delete_connection_output::Builder {
        crate::output::delete_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAttachmentOutput {
    /// <p>Information about the deleted attachment.</p>
    pub attachment: std::option::Option<crate::model::Attachment>,
}
impl DeleteAttachmentOutput {
    /// <p>Information about the deleted attachment.</p>
    pub fn attachment(&self) -> std::option::Option<&crate::model::Attachment> {
        self.attachment.as_ref()
    }
}
impl std::fmt::Debug for DeleteAttachmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAttachmentOutput");
        formatter.field("attachment", &self.attachment);
        formatter.finish()
    }
}
/// See [`DeleteAttachmentOutput`](crate::output::DeleteAttachmentOutput)
pub mod delete_attachment_output {
    /// A builder for [`DeleteAttachmentOutput`](crate::output::DeleteAttachmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attachment: std::option::Option<crate::model::Attachment>,
    }
    impl Builder {
        /// <p>Information about the deleted attachment.</p>
        pub fn attachment(mut self, input: crate::model::Attachment) -> Self {
            self.attachment = Some(input);
            self
        }
        /// <p>Information about the deleted attachment.</p>
        pub fn set_attachment(
            mut self,
            input: std::option::Option<crate::model::Attachment>,
        ) -> Self {
            self.attachment = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAttachmentOutput`](crate::output::DeleteAttachmentOutput)
        pub fn build(self) -> crate::output::DeleteAttachmentOutput {
            crate::output::DeleteAttachmentOutput {
                attachment: self.attachment,
            }
        }
    }
}
impl DeleteAttachmentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAttachmentOutput`](crate::output::DeleteAttachmentOutput)
    pub fn builder() -> crate::output::delete_attachment_output::Builder {
        crate::output::delete_attachment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVpcAttachmentOutput {
    /// <p>Provides details about the VPC attachment.</p>
    pub vpc_attachment: std::option::Option<crate::model::VpcAttachment>,
}
impl CreateVpcAttachmentOutput {
    /// <p>Provides details about the VPC attachment.</p>
    pub fn vpc_attachment(&self) -> std::option::Option<&crate::model::VpcAttachment> {
        self.vpc_attachment.as_ref()
    }
}
impl std::fmt::Debug for CreateVpcAttachmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVpcAttachmentOutput");
        formatter.field("vpc_attachment", &self.vpc_attachment);
        formatter.finish()
    }
}
/// See [`CreateVpcAttachmentOutput`](crate::output::CreateVpcAttachmentOutput)
pub mod create_vpc_attachment_output {
    /// A builder for [`CreateVpcAttachmentOutput`](crate::output::CreateVpcAttachmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_attachment: std::option::Option<crate::model::VpcAttachment>,
    }
    impl Builder {
        /// <p>Provides details about the VPC attachment.</p>
        pub fn vpc_attachment(mut self, input: crate::model::VpcAttachment) -> Self {
            self.vpc_attachment = Some(input);
            self
        }
        /// <p>Provides details about the VPC attachment.</p>
        pub fn set_vpc_attachment(
            mut self,
            input: std::option::Option<crate::model::VpcAttachment>,
        ) -> Self {
            self.vpc_attachment = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVpcAttachmentOutput`](crate::output::CreateVpcAttachmentOutput)
        pub fn build(self) -> crate::output::CreateVpcAttachmentOutput {
            crate::output::CreateVpcAttachmentOutput {
                vpc_attachment: self.vpc_attachment,
            }
        }
    }
}
impl CreateVpcAttachmentOutput {
    /// Creates a new builder-style object to manufacture [`CreateVpcAttachmentOutput`](crate::output::CreateVpcAttachmentOutput)
    pub fn builder() -> crate::output::create_vpc_attachment_output::Builder {
        crate::output::create_vpc_attachment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSiteToSiteVpnAttachmentOutput {
    /// <p>Details about a site-to-site VPN attachment.</p>
    pub site_to_site_vpn_attachment: std::option::Option<crate::model::SiteToSiteVpnAttachment>,
}
impl CreateSiteToSiteVpnAttachmentOutput {
    /// <p>Details about a site-to-site VPN attachment.</p>
    pub fn site_to_site_vpn_attachment(
        &self,
    ) -> std::option::Option<&crate::model::SiteToSiteVpnAttachment> {
        self.site_to_site_vpn_attachment.as_ref()
    }
}
impl std::fmt::Debug for CreateSiteToSiteVpnAttachmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSiteToSiteVpnAttachmentOutput");
        formatter.field(
            "site_to_site_vpn_attachment",
            &self.site_to_site_vpn_attachment,
        );
        formatter.finish()
    }
}
/// See [`CreateSiteToSiteVpnAttachmentOutput`](crate::output::CreateSiteToSiteVpnAttachmentOutput)
pub mod create_site_to_site_vpn_attachment_output {
    /// A builder for [`CreateSiteToSiteVpnAttachmentOutput`](crate::output::CreateSiteToSiteVpnAttachmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site_to_site_vpn_attachment:
            std::option::Option<crate::model::SiteToSiteVpnAttachment>,
    }
    impl Builder {
        /// <p>Details about a site-to-site VPN attachment.</p>
        pub fn site_to_site_vpn_attachment(
            mut self,
            input: crate::model::SiteToSiteVpnAttachment,
        ) -> Self {
            self.site_to_site_vpn_attachment = Some(input);
            self
        }
        /// <p>Details about a site-to-site VPN attachment.</p>
        pub fn set_site_to_site_vpn_attachment(
            mut self,
            input: std::option::Option<crate::model::SiteToSiteVpnAttachment>,
        ) -> Self {
            self.site_to_site_vpn_attachment = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSiteToSiteVpnAttachmentOutput`](crate::output::CreateSiteToSiteVpnAttachmentOutput)
        pub fn build(self) -> crate::output::CreateSiteToSiteVpnAttachmentOutput {
            crate::output::CreateSiteToSiteVpnAttachmentOutput {
                site_to_site_vpn_attachment: self.site_to_site_vpn_attachment,
            }
        }
    }
}
impl CreateSiteToSiteVpnAttachmentOutput {
    /// Creates a new builder-style object to manufacture [`CreateSiteToSiteVpnAttachmentOutput`](crate::output::CreateSiteToSiteVpnAttachmentOutput)
    pub fn builder() -> crate::output::create_site_to_site_vpn_attachment_output::Builder {
        crate::output::create_site_to_site_vpn_attachment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSiteOutput {
    /// <p>Information about the site.</p>
    pub site: std::option::Option<crate::model::Site>,
}
impl CreateSiteOutput {
    /// <p>Information about the site.</p>
    pub fn site(&self) -> std::option::Option<&crate::model::Site> {
        self.site.as_ref()
    }
}
impl std::fmt::Debug for CreateSiteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSiteOutput");
        formatter.field("site", &self.site);
        formatter.finish()
    }
}
/// See [`CreateSiteOutput`](crate::output::CreateSiteOutput)
pub mod create_site_output {
    /// A builder for [`CreateSiteOutput`](crate::output::CreateSiteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site: std::option::Option<crate::model::Site>,
    }
    impl Builder {
        /// <p>Information about the site.</p>
        pub fn site(mut self, input: crate::model::Site) -> Self {
            self.site = Some(input);
            self
        }
        /// <p>Information about the site.</p>
        pub fn set_site(mut self, input: std::option::Option<crate::model::Site>) -> Self {
            self.site = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSiteOutput`](crate::output::CreateSiteOutput)
        pub fn build(self) -> crate::output::CreateSiteOutput {
            crate::output::CreateSiteOutput { site: self.site }
        }
    }
}
impl CreateSiteOutput {
    /// Creates a new builder-style object to manufacture [`CreateSiteOutput`](crate::output::CreateSiteOutput)
    pub fn builder() -> crate::output::create_site_output::Builder {
        crate::output::create_site_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLinkOutput {
    /// <p>Information about the link.</p>
    pub link: std::option::Option<crate::model::Link>,
}
impl CreateLinkOutput {
    /// <p>Information about the link.</p>
    pub fn link(&self) -> std::option::Option<&crate::model::Link> {
        self.link.as_ref()
    }
}
impl std::fmt::Debug for CreateLinkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLinkOutput");
        formatter.field("link", &self.link);
        formatter.finish()
    }
}
/// See [`CreateLinkOutput`](crate::output::CreateLinkOutput)
pub mod create_link_output {
    /// A builder for [`CreateLinkOutput`](crate::output::CreateLinkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) link: std::option::Option<crate::model::Link>,
    }
    impl Builder {
        /// <p>Information about the link.</p>
        pub fn link(mut self, input: crate::model::Link) -> Self {
            self.link = Some(input);
            self
        }
        /// <p>Information about the link.</p>
        pub fn set_link(mut self, input: std::option::Option<crate::model::Link>) -> Self {
            self.link = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLinkOutput`](crate::output::CreateLinkOutput)
        pub fn build(self) -> crate::output::CreateLinkOutput {
            crate::output::CreateLinkOutput { link: self.link }
        }
    }
}
impl CreateLinkOutput {
    /// Creates a new builder-style object to manufacture [`CreateLinkOutput`](crate::output::CreateLinkOutput)
    pub fn builder() -> crate::output::create_link_output::Builder {
        crate::output::create_link_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGlobalNetworkOutput {
    /// <p>Information about the global network object.</p>
    pub global_network: std::option::Option<crate::model::GlobalNetwork>,
}
impl CreateGlobalNetworkOutput {
    /// <p>Information about the global network object.</p>
    pub fn global_network(&self) -> std::option::Option<&crate::model::GlobalNetwork> {
        self.global_network.as_ref()
    }
}
impl std::fmt::Debug for CreateGlobalNetworkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGlobalNetworkOutput");
        formatter.field("global_network", &self.global_network);
        formatter.finish()
    }
}
/// See [`CreateGlobalNetworkOutput`](crate::output::CreateGlobalNetworkOutput)
pub mod create_global_network_output {
    /// A builder for [`CreateGlobalNetworkOutput`](crate::output::CreateGlobalNetworkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network: std::option::Option<crate::model::GlobalNetwork>,
    }
    impl Builder {
        /// <p>Information about the global network object.</p>
        pub fn global_network(mut self, input: crate::model::GlobalNetwork) -> Self {
            self.global_network = Some(input);
            self
        }
        /// <p>Information about the global network object.</p>
        pub fn set_global_network(
            mut self,
            input: std::option::Option<crate::model::GlobalNetwork>,
        ) -> Self {
            self.global_network = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGlobalNetworkOutput`](crate::output::CreateGlobalNetworkOutput)
        pub fn build(self) -> crate::output::CreateGlobalNetworkOutput {
            crate::output::CreateGlobalNetworkOutput {
                global_network: self.global_network,
            }
        }
    }
}
impl CreateGlobalNetworkOutput {
    /// Creates a new builder-style object to manufacture [`CreateGlobalNetworkOutput`](crate::output::CreateGlobalNetworkOutput)
    pub fn builder() -> crate::output::create_global_network_output::Builder {
        crate::output::create_global_network_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeviceOutput {
    /// <p>Information about the device.</p>
    pub device: std::option::Option<crate::model::Device>,
}
impl CreateDeviceOutput {
    /// <p>Information about the device.</p>
    pub fn device(&self) -> std::option::Option<&crate::model::Device> {
        self.device.as_ref()
    }
}
impl std::fmt::Debug for CreateDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeviceOutput");
        formatter.field("device", &self.device);
        formatter.finish()
    }
}
/// See [`CreateDeviceOutput`](crate::output::CreateDeviceOutput)
pub mod create_device_output {
    /// A builder for [`CreateDeviceOutput`](crate::output::CreateDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device: std::option::Option<crate::model::Device>,
    }
    impl Builder {
        /// <p>Information about the device.</p>
        pub fn device(mut self, input: crate::model::Device) -> Self {
            self.device = Some(input);
            self
        }
        /// <p>Information about the device.</p>
        pub fn set_device(mut self, input: std::option::Option<crate::model::Device>) -> Self {
            self.device = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeviceOutput`](crate::output::CreateDeviceOutput)
        pub fn build(self) -> crate::output::CreateDeviceOutput {
            crate::output::CreateDeviceOutput {
                device: self.device,
            }
        }
    }
}
impl CreateDeviceOutput {
    /// Creates a new builder-style object to manufacture [`CreateDeviceOutput`](crate::output::CreateDeviceOutput)
    pub fn builder() -> crate::output::create_device_output::Builder {
        crate::output::create_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCoreNetworkOutput {
    /// <p>Returns details about a core network.</p>
    pub core_network: std::option::Option<crate::model::CoreNetwork>,
}
impl CreateCoreNetworkOutput {
    /// <p>Returns details about a core network.</p>
    pub fn core_network(&self) -> std::option::Option<&crate::model::CoreNetwork> {
        self.core_network.as_ref()
    }
}
impl std::fmt::Debug for CreateCoreNetworkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCoreNetworkOutput");
        formatter.field("core_network", &self.core_network);
        formatter.finish()
    }
}
/// See [`CreateCoreNetworkOutput`](crate::output::CreateCoreNetworkOutput)
pub mod create_core_network_output {
    /// A builder for [`CreateCoreNetworkOutput`](crate::output::CreateCoreNetworkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network: std::option::Option<crate::model::CoreNetwork>,
    }
    impl Builder {
        /// <p>Returns details about a core network.</p>
        pub fn core_network(mut self, input: crate::model::CoreNetwork) -> Self {
            self.core_network = Some(input);
            self
        }
        /// <p>Returns details about a core network.</p>
        pub fn set_core_network(
            mut self,
            input: std::option::Option<crate::model::CoreNetwork>,
        ) -> Self {
            self.core_network = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCoreNetworkOutput`](crate::output::CreateCoreNetworkOutput)
        pub fn build(self) -> crate::output::CreateCoreNetworkOutput {
            crate::output::CreateCoreNetworkOutput {
                core_network: self.core_network,
            }
        }
    }
}
impl CreateCoreNetworkOutput {
    /// Creates a new builder-style object to manufacture [`CreateCoreNetworkOutput`](crate::output::CreateCoreNetworkOutput)
    pub fn builder() -> crate::output::create_core_network_output::Builder {
        crate::output::create_core_network_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectPeerOutput {
    /// <p>The response to the request.</p>
    pub connect_peer: std::option::Option<crate::model::ConnectPeer>,
}
impl CreateConnectPeerOutput {
    /// <p>The response to the request.</p>
    pub fn connect_peer(&self) -> std::option::Option<&crate::model::ConnectPeer> {
        self.connect_peer.as_ref()
    }
}
impl std::fmt::Debug for CreateConnectPeerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectPeerOutput");
        formatter.field("connect_peer", &self.connect_peer);
        formatter.finish()
    }
}
/// See [`CreateConnectPeerOutput`](crate::output::CreateConnectPeerOutput)
pub mod create_connect_peer_output {
    /// A builder for [`CreateConnectPeerOutput`](crate::output::CreateConnectPeerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connect_peer: std::option::Option<crate::model::ConnectPeer>,
    }
    impl Builder {
        /// <p>The response to the request.</p>
        pub fn connect_peer(mut self, input: crate::model::ConnectPeer) -> Self {
            self.connect_peer = Some(input);
            self
        }
        /// <p>The response to the request.</p>
        pub fn set_connect_peer(
            mut self,
            input: std::option::Option<crate::model::ConnectPeer>,
        ) -> Self {
            self.connect_peer = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectPeerOutput`](crate::output::CreateConnectPeerOutput)
        pub fn build(self) -> crate::output::CreateConnectPeerOutput {
            crate::output::CreateConnectPeerOutput {
                connect_peer: self.connect_peer,
            }
        }
    }
}
impl CreateConnectPeerOutput {
    /// Creates a new builder-style object to manufacture [`CreateConnectPeerOutput`](crate::output::CreateConnectPeerOutput)
    pub fn builder() -> crate::output::create_connect_peer_output::Builder {
        crate::output::create_connect_peer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectionOutput {
    /// <p>Information about the connection.</p>
    pub connection: std::option::Option<crate::model::Connection>,
}
impl CreateConnectionOutput {
    /// <p>Information about the connection.</p>
    pub fn connection(&self) -> std::option::Option<&crate::model::Connection> {
        self.connection.as_ref()
    }
}
impl std::fmt::Debug for CreateConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectionOutput");
        formatter.field("connection", &self.connection);
        formatter.finish()
    }
}
/// See [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
pub mod create_connection_output {
    /// A builder for [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection: std::option::Option<crate::model::Connection>,
    }
    impl Builder {
        /// <p>Information about the connection.</p>
        pub fn connection(mut self, input: crate::model::Connection) -> Self {
            self.connection = Some(input);
            self
        }
        /// <p>Information about the connection.</p>
        pub fn set_connection(
            mut self,
            input: std::option::Option<crate::model::Connection>,
        ) -> Self {
            self.connection = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
        pub fn build(self) -> crate::output::CreateConnectionOutput {
            crate::output::CreateConnectionOutput {
                connection: self.connection,
            }
        }
    }
}
impl CreateConnectionOutput {
    /// Creates a new builder-style object to manufacture [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
    pub fn builder() -> crate::output::create_connection_output::Builder {
        crate::output::create_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectAttachmentOutput {
    /// <p>The response to a Connect attachment request.</p>
    pub connect_attachment: std::option::Option<crate::model::ConnectAttachment>,
}
impl CreateConnectAttachmentOutput {
    /// <p>The response to a Connect attachment request.</p>
    pub fn connect_attachment(&self) -> std::option::Option<&crate::model::ConnectAttachment> {
        self.connect_attachment.as_ref()
    }
}
impl std::fmt::Debug for CreateConnectAttachmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectAttachmentOutput");
        formatter.field("connect_attachment", &self.connect_attachment);
        formatter.finish()
    }
}
/// See [`CreateConnectAttachmentOutput`](crate::output::CreateConnectAttachmentOutput)
pub mod create_connect_attachment_output {
    /// A builder for [`CreateConnectAttachmentOutput`](crate::output::CreateConnectAttachmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connect_attachment: std::option::Option<crate::model::ConnectAttachment>,
    }
    impl Builder {
        /// <p>The response to a Connect attachment request.</p>
        pub fn connect_attachment(mut self, input: crate::model::ConnectAttachment) -> Self {
            self.connect_attachment = Some(input);
            self
        }
        /// <p>The response to a Connect attachment request.</p>
        pub fn set_connect_attachment(
            mut self,
            input: std::option::Option<crate::model::ConnectAttachment>,
        ) -> Self {
            self.connect_attachment = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectAttachmentOutput`](crate::output::CreateConnectAttachmentOutput)
        pub fn build(self) -> crate::output::CreateConnectAttachmentOutput {
            crate::output::CreateConnectAttachmentOutput {
                connect_attachment: self.connect_attachment,
            }
        }
    }
}
impl CreateConnectAttachmentOutput {
    /// Creates a new builder-style object to manufacture [`CreateConnectAttachmentOutput`](crate::output::CreateConnectAttachmentOutput)
    pub fn builder() -> crate::output::create_connect_attachment_output::Builder {
        crate::output::create_connect_attachment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateTransitGatewayConnectPeerOutput {
    /// <p>The transit gateway Connect peer association.</p>
    pub transit_gateway_connect_peer_association:
        std::option::Option<crate::model::TransitGatewayConnectPeerAssociation>,
}
impl AssociateTransitGatewayConnectPeerOutput {
    /// <p>The transit gateway Connect peer association.</p>
    pub fn transit_gateway_connect_peer_association(
        &self,
    ) -> std::option::Option<&crate::model::TransitGatewayConnectPeerAssociation> {
        self.transit_gateway_connect_peer_association.as_ref()
    }
}
impl std::fmt::Debug for AssociateTransitGatewayConnectPeerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateTransitGatewayConnectPeerOutput");
        formatter.field(
            "transit_gateway_connect_peer_association",
            &self.transit_gateway_connect_peer_association,
        );
        formatter.finish()
    }
}
/// See [`AssociateTransitGatewayConnectPeerOutput`](crate::output::AssociateTransitGatewayConnectPeerOutput)
pub mod associate_transit_gateway_connect_peer_output {
    /// A builder for [`AssociateTransitGatewayConnectPeerOutput`](crate::output::AssociateTransitGatewayConnectPeerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_connect_peer_association:
            std::option::Option<crate::model::TransitGatewayConnectPeerAssociation>,
    }
    impl Builder {
        /// <p>The transit gateway Connect peer association.</p>
        pub fn transit_gateway_connect_peer_association(
            mut self,
            input: crate::model::TransitGatewayConnectPeerAssociation,
        ) -> Self {
            self.transit_gateway_connect_peer_association = Some(input);
            self
        }
        /// <p>The transit gateway Connect peer association.</p>
        pub fn set_transit_gateway_connect_peer_association(
            mut self,
            input: std::option::Option<crate::model::TransitGatewayConnectPeerAssociation>,
        ) -> Self {
            self.transit_gateway_connect_peer_association = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateTransitGatewayConnectPeerOutput`](crate::output::AssociateTransitGatewayConnectPeerOutput)
        pub fn build(self) -> crate::output::AssociateTransitGatewayConnectPeerOutput {
            crate::output::AssociateTransitGatewayConnectPeerOutput {
                transit_gateway_connect_peer_association: self
                    .transit_gateway_connect_peer_association,
            }
        }
    }
}
impl AssociateTransitGatewayConnectPeerOutput {
    /// Creates a new builder-style object to manufacture [`AssociateTransitGatewayConnectPeerOutput`](crate::output::AssociateTransitGatewayConnectPeerOutput)
    pub fn builder() -> crate::output::associate_transit_gateway_connect_peer_output::Builder {
        crate::output::associate_transit_gateway_connect_peer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateLinkOutput {
    /// <p>The link association.</p>
    pub link_association: std::option::Option<crate::model::LinkAssociation>,
}
impl AssociateLinkOutput {
    /// <p>The link association.</p>
    pub fn link_association(&self) -> std::option::Option<&crate::model::LinkAssociation> {
        self.link_association.as_ref()
    }
}
impl std::fmt::Debug for AssociateLinkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateLinkOutput");
        formatter.field("link_association", &self.link_association);
        formatter.finish()
    }
}
/// See [`AssociateLinkOutput`](crate::output::AssociateLinkOutput)
pub mod associate_link_output {
    /// A builder for [`AssociateLinkOutput`](crate::output::AssociateLinkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) link_association: std::option::Option<crate::model::LinkAssociation>,
    }
    impl Builder {
        /// <p>The link association.</p>
        pub fn link_association(mut self, input: crate::model::LinkAssociation) -> Self {
            self.link_association = Some(input);
            self
        }
        /// <p>The link association.</p>
        pub fn set_link_association(
            mut self,
            input: std::option::Option<crate::model::LinkAssociation>,
        ) -> Self {
            self.link_association = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateLinkOutput`](crate::output::AssociateLinkOutput)
        pub fn build(self) -> crate::output::AssociateLinkOutput {
            crate::output::AssociateLinkOutput {
                link_association: self.link_association,
            }
        }
    }
}
impl AssociateLinkOutput {
    /// Creates a new builder-style object to manufacture [`AssociateLinkOutput`](crate::output::AssociateLinkOutput)
    pub fn builder() -> crate::output::associate_link_output::Builder {
        crate::output::associate_link_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateCustomerGatewayOutput {
    /// <p>The customer gateway association.</p>
    pub customer_gateway_association: std::option::Option<crate::model::CustomerGatewayAssociation>,
}
impl AssociateCustomerGatewayOutput {
    /// <p>The customer gateway association.</p>
    pub fn customer_gateway_association(
        &self,
    ) -> std::option::Option<&crate::model::CustomerGatewayAssociation> {
        self.customer_gateway_association.as_ref()
    }
}
impl std::fmt::Debug for AssociateCustomerGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateCustomerGatewayOutput");
        formatter.field(
            "customer_gateway_association",
            &self.customer_gateway_association,
        );
        formatter.finish()
    }
}
/// See [`AssociateCustomerGatewayOutput`](crate::output::AssociateCustomerGatewayOutput)
pub mod associate_customer_gateway_output {
    /// A builder for [`AssociateCustomerGatewayOutput`](crate::output::AssociateCustomerGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) customer_gateway_association:
            std::option::Option<crate::model::CustomerGatewayAssociation>,
    }
    impl Builder {
        /// <p>The customer gateway association.</p>
        pub fn customer_gateway_association(
            mut self,
            input: crate::model::CustomerGatewayAssociation,
        ) -> Self {
            self.customer_gateway_association = Some(input);
            self
        }
        /// <p>The customer gateway association.</p>
        pub fn set_customer_gateway_association(
            mut self,
            input: std::option::Option<crate::model::CustomerGatewayAssociation>,
        ) -> Self {
            self.customer_gateway_association = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateCustomerGatewayOutput`](crate::output::AssociateCustomerGatewayOutput)
        pub fn build(self) -> crate::output::AssociateCustomerGatewayOutput {
            crate::output::AssociateCustomerGatewayOutput {
                customer_gateway_association: self.customer_gateway_association,
            }
        }
    }
}
impl AssociateCustomerGatewayOutput {
    /// Creates a new builder-style object to manufacture [`AssociateCustomerGatewayOutput`](crate::output::AssociateCustomerGatewayOutput)
    pub fn builder() -> crate::output::associate_customer_gateway_output::Builder {
        crate::output::associate_customer_gateway_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateConnectPeerOutput {
    /// <p>The response to the Connect peer request.</p>
    pub connect_peer_association: std::option::Option<crate::model::ConnectPeerAssociation>,
}
impl AssociateConnectPeerOutput {
    /// <p>The response to the Connect peer request.</p>
    pub fn connect_peer_association(
        &self,
    ) -> std::option::Option<&crate::model::ConnectPeerAssociation> {
        self.connect_peer_association.as_ref()
    }
}
impl std::fmt::Debug for AssociateConnectPeerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateConnectPeerOutput");
        formatter.field("connect_peer_association", &self.connect_peer_association);
        formatter.finish()
    }
}
/// See [`AssociateConnectPeerOutput`](crate::output::AssociateConnectPeerOutput)
pub mod associate_connect_peer_output {
    /// A builder for [`AssociateConnectPeerOutput`](crate::output::AssociateConnectPeerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connect_peer_association:
            std::option::Option<crate::model::ConnectPeerAssociation>,
    }
    impl Builder {
        /// <p>The response to the Connect peer request.</p>
        pub fn connect_peer_association(
            mut self,
            input: crate::model::ConnectPeerAssociation,
        ) -> Self {
            self.connect_peer_association = Some(input);
            self
        }
        /// <p>The response to the Connect peer request.</p>
        pub fn set_connect_peer_association(
            mut self,
            input: std::option::Option<crate::model::ConnectPeerAssociation>,
        ) -> Self {
            self.connect_peer_association = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateConnectPeerOutput`](crate::output::AssociateConnectPeerOutput)
        pub fn build(self) -> crate::output::AssociateConnectPeerOutput {
            crate::output::AssociateConnectPeerOutput {
                connect_peer_association: self.connect_peer_association,
            }
        }
    }
}
impl AssociateConnectPeerOutput {
    /// Creates a new builder-style object to manufacture [`AssociateConnectPeerOutput`](crate::output::AssociateConnectPeerOutput)
    pub fn builder() -> crate::output::associate_connect_peer_output::Builder {
        crate::output::associate_connect_peer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptAttachmentOutput {
    /// <p>The response to the attachment request. </p>
    pub attachment: std::option::Option<crate::model::Attachment>,
}
impl AcceptAttachmentOutput {
    /// <p>The response to the attachment request. </p>
    pub fn attachment(&self) -> std::option::Option<&crate::model::Attachment> {
        self.attachment.as_ref()
    }
}
impl std::fmt::Debug for AcceptAttachmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptAttachmentOutput");
        formatter.field("attachment", &self.attachment);
        formatter.finish()
    }
}
/// See [`AcceptAttachmentOutput`](crate::output::AcceptAttachmentOutput)
pub mod accept_attachment_output {
    /// A builder for [`AcceptAttachmentOutput`](crate::output::AcceptAttachmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attachment: std::option::Option<crate::model::Attachment>,
    }
    impl Builder {
        /// <p>The response to the attachment request. </p>
        pub fn attachment(mut self, input: crate::model::Attachment) -> Self {
            self.attachment = Some(input);
            self
        }
        /// <p>The response to the attachment request. </p>
        pub fn set_attachment(
            mut self,
            input: std::option::Option<crate::model::Attachment>,
        ) -> Self {
            self.attachment = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptAttachmentOutput`](crate::output::AcceptAttachmentOutput)
        pub fn build(self) -> crate::output::AcceptAttachmentOutput {
            crate::output::AcceptAttachmentOutput {
                attachment: self.attachment,
            }
        }
    }
}
impl AcceptAttachmentOutput {
    /// Creates a new builder-style object to manufacture [`AcceptAttachmentOutput`](crate::output::AcceptAttachmentOutput)
    pub fn builder() -> crate::output::accept_attachment_output::Builder {
        crate::output::accept_attachment_output::Builder::default()
    }
}
