// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Network Manager
///
/// Client for invoking operations on AWS Network Manager. Each operation on AWS Network Manager is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_networkmanager::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_networkmanager::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_networkmanager::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AcceptAttachment`](crate::client::fluent_builders::AcceptAttachment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attachment_id(impl Into<String>)`](crate::client::fluent_builders::AcceptAttachment::attachment_id) / [`set_attachment_id(Option<String>)`](crate::client::fluent_builders::AcceptAttachment::set_attachment_id): <p>The ID of the attachment. </p>
    /// - On success, responds with [`AcceptAttachmentOutput`](crate::output::AcceptAttachmentOutput) with field(s):
    ///   - [`attachment(Option<Attachment>)`](crate::output::AcceptAttachmentOutput::attachment): <p>The response to the attachment request. </p>
    /// - On failure, responds with [`SdkError<AcceptAttachmentError>`](crate::error::AcceptAttachmentError)
    pub fn accept_attachment(&self) -> fluent_builders::AcceptAttachment {
        fluent_builders::AcceptAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateConnectPeer`](crate::client::fluent_builders::AssociateConnectPeer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::AssociateConnectPeer::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::AssociateConnectPeer::set_global_network_id): <p>The ID of your global network.</p>
    ///   - [`connect_peer_id(impl Into<String>)`](crate::client::fluent_builders::AssociateConnectPeer::connect_peer_id) / [`set_connect_peer_id(Option<String>)`](crate::client::fluent_builders::AssociateConnectPeer::set_connect_peer_id): <p>The ID of the Connect peer.</p>
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::AssociateConnectPeer::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::AssociateConnectPeer::set_device_id): <p>The ID of the device.</p>
    ///   - [`link_id(impl Into<String>)`](crate::client::fluent_builders::AssociateConnectPeer::link_id) / [`set_link_id(Option<String>)`](crate::client::fluent_builders::AssociateConnectPeer::set_link_id): <p>The ID of the link.</p>
    /// - On success, responds with [`AssociateConnectPeerOutput`](crate::output::AssociateConnectPeerOutput) with field(s):
    ///   - [`connect_peer_association(Option<ConnectPeerAssociation>)`](crate::output::AssociateConnectPeerOutput::connect_peer_association): <p>The response to the Connect peer request.</p>
    /// - On failure, responds with [`SdkError<AssociateConnectPeerError>`](crate::error::AssociateConnectPeerError)
    pub fn associate_connect_peer(&self) -> fluent_builders::AssociateConnectPeer {
        fluent_builders::AssociateConnectPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateCustomerGateway`](crate::client::fluent_builders::AssociateCustomerGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`customer_gateway_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateCustomerGateway::customer_gateway_arn) / [`set_customer_gateway_arn(Option<String>)`](crate::client::fluent_builders::AssociateCustomerGateway::set_customer_gateway_arn): <p>The Amazon Resource Name (ARN) of the customer gateway.</p>
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::AssociateCustomerGateway::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::AssociateCustomerGateway::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::AssociateCustomerGateway::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::AssociateCustomerGateway::set_device_id): <p>The ID of the device.</p>
    ///   - [`link_id(impl Into<String>)`](crate::client::fluent_builders::AssociateCustomerGateway::link_id) / [`set_link_id(Option<String>)`](crate::client::fluent_builders::AssociateCustomerGateway::set_link_id): <p>The ID of the link.</p>
    /// - On success, responds with [`AssociateCustomerGatewayOutput`](crate::output::AssociateCustomerGatewayOutput) with field(s):
    ///   - [`customer_gateway_association(Option<CustomerGatewayAssociation>)`](crate::output::AssociateCustomerGatewayOutput::customer_gateway_association): <p>The customer gateway association.</p>
    /// - On failure, responds with [`SdkError<AssociateCustomerGatewayError>`](crate::error::AssociateCustomerGatewayError)
    pub fn associate_customer_gateway(&self) -> fluent_builders::AssociateCustomerGateway {
        fluent_builders::AssociateCustomerGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateLink`](crate::client::fluent_builders::AssociateLink) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::AssociateLink::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::AssociateLink::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::AssociateLink::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::AssociateLink::set_device_id): <p>The ID of the device.</p>
    ///   - [`link_id(impl Into<String>)`](crate::client::fluent_builders::AssociateLink::link_id) / [`set_link_id(Option<String>)`](crate::client::fluent_builders::AssociateLink::set_link_id): <p>The ID of the link.</p>
    /// - On success, responds with [`AssociateLinkOutput`](crate::output::AssociateLinkOutput) with field(s):
    ///   - [`link_association(Option<LinkAssociation>)`](crate::output::AssociateLinkOutput::link_association): <p>The link association.</p>
    /// - On failure, responds with [`SdkError<AssociateLinkError>`](crate::error::AssociateLinkError)
    pub fn associate_link(&self) -> fluent_builders::AssociateLink {
        fluent_builders::AssociateLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateTransitGatewayConnectPeer`](crate::client::fluent_builders::AssociateTransitGatewayConnectPeer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::AssociateTransitGatewayConnectPeer::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::AssociateTransitGatewayConnectPeer::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`transit_gateway_connect_peer_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateTransitGatewayConnectPeer::transit_gateway_connect_peer_arn) / [`set_transit_gateway_connect_peer_arn(Option<String>)`](crate::client::fluent_builders::AssociateTransitGatewayConnectPeer::set_transit_gateway_connect_peer_arn): <p>The Amazon Resource Name (ARN) of the Connect peer.</p>
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::AssociateTransitGatewayConnectPeer::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::AssociateTransitGatewayConnectPeer::set_device_id): <p>The ID of the device.</p>
    ///   - [`link_id(impl Into<String>)`](crate::client::fluent_builders::AssociateTransitGatewayConnectPeer::link_id) / [`set_link_id(Option<String>)`](crate::client::fluent_builders::AssociateTransitGatewayConnectPeer::set_link_id): <p>The ID of the link.</p>
    /// - On success, responds with [`AssociateTransitGatewayConnectPeerOutput`](crate::output::AssociateTransitGatewayConnectPeerOutput) with field(s):
    ///   - [`transit_gateway_connect_peer_association(Option<TransitGatewayConnectPeerAssociation>)`](crate::output::AssociateTransitGatewayConnectPeerOutput::transit_gateway_connect_peer_association): <p>The transit gateway Connect peer association.</p>
    /// - On failure, responds with [`SdkError<AssociateTransitGatewayConnectPeerError>`](crate::error::AssociateTransitGatewayConnectPeerError)
    pub fn associate_transit_gateway_connect_peer(
        &self,
    ) -> fluent_builders::AssociateTransitGatewayConnectPeer {
        fluent_builders::AssociateTransitGatewayConnectPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConnectAttachment`](crate::client::fluent_builders::CreateConnectAttachment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_network_id(impl Into<String>)`](crate::client::fluent_builders::CreateConnectAttachment::core_network_id) / [`set_core_network_id(Option<String>)`](crate::client::fluent_builders::CreateConnectAttachment::set_core_network_id): <p>The ID of a core network where you want to create the attachment. </p>
    ///   - [`edge_location(impl Into<String>)`](crate::client::fluent_builders::CreateConnectAttachment::edge_location) / [`set_edge_location(Option<String>)`](crate::client::fluent_builders::CreateConnectAttachment::set_edge_location): <p>The Region where the edge is located.</p>
    ///   - [`transport_attachment_id(impl Into<String>)`](crate::client::fluent_builders::CreateConnectAttachment::transport_attachment_id) / [`set_transport_attachment_id(Option<String>)`](crate::client::fluent_builders::CreateConnectAttachment::set_transport_attachment_id): <p>The ID of the attachment between the two connections.</p>
    ///   - [`options(ConnectAttachmentOptions)`](crate::client::fluent_builders::CreateConnectAttachment::options) / [`set_options(Option<ConnectAttachmentOptions>)`](crate::client::fluent_builders::CreateConnectAttachment::set_options): <p>Options for creating an attachment.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateConnectAttachment::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateConnectAttachment::set_tags): <p>The list of key-value tags associated with the request.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateConnectAttachment::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateConnectAttachment::set_client_token): <p>The client token associated with the request.</p>
    /// - On success, responds with [`CreateConnectAttachmentOutput`](crate::output::CreateConnectAttachmentOutput) with field(s):
    ///   - [`connect_attachment(Option<ConnectAttachment>)`](crate::output::CreateConnectAttachmentOutput::connect_attachment): <p>The response to a Connect attachment request.</p>
    /// - On failure, responds with [`SdkError<CreateConnectAttachmentError>`](crate::error::CreateConnectAttachmentError)
    pub fn create_connect_attachment(&self) -> fluent_builders::CreateConnectAttachment {
        fluent_builders::CreateConnectAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConnection`](crate::client::fluent_builders::CreateConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::CreateConnection::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::CreateConnection::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::CreateConnection::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::CreateConnection::set_device_id): <p>The ID of the first device in the connection.</p>
    ///   - [`connected_device_id(impl Into<String>)`](crate::client::fluent_builders::CreateConnection::connected_device_id) / [`set_connected_device_id(Option<String>)`](crate::client::fluent_builders::CreateConnection::set_connected_device_id): <p>The ID of the second device in the connection.</p>
    ///   - [`link_id(impl Into<String>)`](crate::client::fluent_builders::CreateConnection::link_id) / [`set_link_id(Option<String>)`](crate::client::fluent_builders::CreateConnection::set_link_id): <p>The ID of the link for the first device.</p>
    ///   - [`connected_link_id(impl Into<String>)`](crate::client::fluent_builders::CreateConnection::connected_link_id) / [`set_connected_link_id(Option<String>)`](crate::client::fluent_builders::CreateConnection::set_connected_link_id): <p>The ID of the link for the second device.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateConnection::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateConnection::set_description): <p>A description of the connection.</p>  <p>Length Constraints: Maximum length of 256 characters.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateConnection::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateConnection::set_tags): <p>The tags to apply to the resource during creation.</p>
    /// - On success, responds with [`CreateConnectionOutput`](crate::output::CreateConnectionOutput) with field(s):
    ///   - [`connection(Option<Connection>)`](crate::output::CreateConnectionOutput::connection): <p>Information about the connection.</p>
    /// - On failure, responds with [`SdkError<CreateConnectionError>`](crate::error::CreateConnectionError)
    pub fn create_connection(&self) -> fluent_builders::CreateConnection {
        fluent_builders::CreateConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConnectPeer`](crate::client::fluent_builders::CreateConnectPeer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connect_attachment_id(impl Into<String>)`](crate::client::fluent_builders::CreateConnectPeer::connect_attachment_id) / [`set_connect_attachment_id(Option<String>)`](crate::client::fluent_builders::CreateConnectPeer::set_connect_attachment_id): <p>The ID of the connection attachment.</p>
    ///   - [`core_network_address(impl Into<String>)`](crate::client::fluent_builders::CreateConnectPeer::core_network_address) / [`set_core_network_address(Option<String>)`](crate::client::fluent_builders::CreateConnectPeer::set_core_network_address): <p>A Connect peer core network address.</p>
    ///   - [`peer_address(impl Into<String>)`](crate::client::fluent_builders::CreateConnectPeer::peer_address) / [`set_peer_address(Option<String>)`](crate::client::fluent_builders::CreateConnectPeer::set_peer_address): <p>The Connect peer address.</p>
    ///   - [`bgp_options(BgpOptions)`](crate::client::fluent_builders::CreateConnectPeer::bgp_options) / [`set_bgp_options(Option<BgpOptions>)`](crate::client::fluent_builders::CreateConnectPeer::set_bgp_options): <p>The Connect peer BGP options.</p>
    ///   - [`inside_cidr_blocks(Vec<String>)`](crate::client::fluent_builders::CreateConnectPeer::inside_cidr_blocks) / [`set_inside_cidr_blocks(Option<Vec<String>>)`](crate::client::fluent_builders::CreateConnectPeer::set_inside_cidr_blocks): <p>The inside IP addresses used for BGP peering.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateConnectPeer::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateConnectPeer::set_tags): <p>The tags associated with the peer request.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateConnectPeer::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateConnectPeer::set_client_token): <p>The client token associated with the request.</p>
    /// - On success, responds with [`CreateConnectPeerOutput`](crate::output::CreateConnectPeerOutput) with field(s):
    ///   - [`connect_peer(Option<ConnectPeer>)`](crate::output::CreateConnectPeerOutput::connect_peer): <p>The response to the request.</p>
    /// - On failure, responds with [`SdkError<CreateConnectPeerError>`](crate::error::CreateConnectPeerError)
    pub fn create_connect_peer(&self) -> fluent_builders::CreateConnectPeer {
        fluent_builders::CreateConnectPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCoreNetwork`](crate::client::fluent_builders::CreateCoreNetwork) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::CreateCoreNetwork::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::CreateCoreNetwork::set_global_network_id): <p>The ID of the global network that a core network will be a part of. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateCoreNetwork::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateCoreNetwork::set_description): <p>The description of a core network.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateCoreNetwork::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateCoreNetwork::set_tags): <p>Key-value tags associated with a core network request.</p>
    ///   - [`policy_document(impl Into<String>)`](crate::client::fluent_builders::CreateCoreNetwork::policy_document) / [`set_policy_document(Option<String>)`](crate::client::fluent_builders::CreateCoreNetwork::set_policy_document): <p>The policy document for creating a core network.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateCoreNetwork::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateCoreNetwork::set_client_token): <p>The client token associated with a core network request.</p>
    /// - On success, responds with [`CreateCoreNetworkOutput`](crate::output::CreateCoreNetworkOutput) with field(s):
    ///   - [`core_network(Option<CoreNetwork>)`](crate::output::CreateCoreNetworkOutput::core_network): <p>Returns details about a core network.</p>
    /// - On failure, responds with [`SdkError<CreateCoreNetworkError>`](crate::error::CreateCoreNetworkError)
    pub fn create_core_network(&self) -> fluent_builders::CreateCoreNetwork {
        fluent_builders::CreateCoreNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDevice`](crate::client::fluent_builders::CreateDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::CreateDevice::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::CreateDevice::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`aws_location(AwsLocation)`](crate::client::fluent_builders::CreateDevice::aws_location) / [`set_aws_location(Option<AwsLocation>)`](crate::client::fluent_builders::CreateDevice::set_aws_location): <p>The Amazon Web Services location of the device, if applicable. For an on-premises device, you can omit this parameter.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateDevice::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateDevice::set_description): <p>A description of the device.</p>  <p>Constraints: Maximum length of 256 characters.</p>
    ///   - [`r#type(impl Into<String>)`](crate::client::fluent_builders::CreateDevice::type) / [`set_type(Option<String>)`](crate::client::fluent_builders::CreateDevice::set_type): <p>The type of the device.</p>
    ///   - [`vendor(impl Into<String>)`](crate::client::fluent_builders::CreateDevice::vendor) / [`set_vendor(Option<String>)`](crate::client::fluent_builders::CreateDevice::set_vendor): <p>The vendor of the device.</p>  <p>Constraints: Maximum length of 128 characters.</p>
    ///   - [`model(impl Into<String>)`](crate::client::fluent_builders::CreateDevice::model) / [`set_model(Option<String>)`](crate::client::fluent_builders::CreateDevice::set_model): <p>The model of the device.</p>  <p>Constraints: Maximum length of 128 characters.</p>
    ///   - [`serial_number(impl Into<String>)`](crate::client::fluent_builders::CreateDevice::serial_number) / [`set_serial_number(Option<String>)`](crate::client::fluent_builders::CreateDevice::set_serial_number): <p>The serial number of the device.</p>  <p>Constraints: Maximum length of 128 characters.</p>
    ///   - [`location(Location)`](crate::client::fluent_builders::CreateDevice::location) / [`set_location(Option<Location>)`](crate::client::fluent_builders::CreateDevice::set_location): <p>The location of the device.</p>
    ///   - [`site_id(impl Into<String>)`](crate::client::fluent_builders::CreateDevice::site_id) / [`set_site_id(Option<String>)`](crate::client::fluent_builders::CreateDevice::set_site_id): <p>The ID of the site.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDevice::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDevice::set_tags): <p>The tags to apply to the resource during creation.</p>
    /// - On success, responds with [`CreateDeviceOutput`](crate::output::CreateDeviceOutput) with field(s):
    ///   - [`device(Option<Device>)`](crate::output::CreateDeviceOutput::device): <p>Information about the device.</p>
    /// - On failure, responds with [`SdkError<CreateDeviceError>`](crate::error::CreateDeviceError)
    pub fn create_device(&self) -> fluent_builders::CreateDevice {
        fluent_builders::CreateDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateGlobalNetwork`](crate::client::fluent_builders::CreateGlobalNetwork) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateGlobalNetwork::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateGlobalNetwork::set_description): <p>A description of the global network.</p>  <p>Constraints: Maximum length of 256 characters.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateGlobalNetwork::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateGlobalNetwork::set_tags): <p>The tags to apply to the resource during creation.</p>
    /// - On success, responds with [`CreateGlobalNetworkOutput`](crate::output::CreateGlobalNetworkOutput) with field(s):
    ///   - [`global_network(Option<GlobalNetwork>)`](crate::output::CreateGlobalNetworkOutput::global_network): <p>Information about the global network object.</p>
    /// - On failure, responds with [`SdkError<CreateGlobalNetworkError>`](crate::error::CreateGlobalNetworkError)
    pub fn create_global_network(&self) -> fluent_builders::CreateGlobalNetwork {
        fluent_builders::CreateGlobalNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLink`](crate::client::fluent_builders::CreateLink) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::CreateLink::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::CreateLink::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateLink::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateLink::set_description): <p>A description of the link.</p>  <p>Constraints: Maximum length of 256 characters.</p>
    ///   - [`r#type(impl Into<String>)`](crate::client::fluent_builders::CreateLink::type) / [`set_type(Option<String>)`](crate::client::fluent_builders::CreateLink::set_type): <p>The type of the link.</p>  <p>Constraints: Maximum length of 128 characters. Cannot include the following characters: | \ ^</p>
    ///   - [`bandwidth(Bandwidth)`](crate::client::fluent_builders::CreateLink::bandwidth) / [`set_bandwidth(Option<Bandwidth>)`](crate::client::fluent_builders::CreateLink::set_bandwidth): <p> The upload speed and download speed in Mbps. </p>
    ///   - [`provider(impl Into<String>)`](crate::client::fluent_builders::CreateLink::provider) / [`set_provider(Option<String>)`](crate::client::fluent_builders::CreateLink::set_provider): <p>The provider of the link.</p>  <p>Constraints: Maximum length of 128 characters. Cannot include the following characters: | \ ^</p>
    ///   - [`site_id(impl Into<String>)`](crate::client::fluent_builders::CreateLink::site_id) / [`set_site_id(Option<String>)`](crate::client::fluent_builders::CreateLink::set_site_id): <p>The ID of the site.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateLink::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateLink::set_tags): <p>The tags to apply to the resource during creation.</p>
    /// - On success, responds with [`CreateLinkOutput`](crate::output::CreateLinkOutput) with field(s):
    ///   - [`link(Option<Link>)`](crate::output::CreateLinkOutput::link): <p>Information about the link.</p>
    /// - On failure, responds with [`SdkError<CreateLinkError>`](crate::error::CreateLinkError)
    pub fn create_link(&self) -> fluent_builders::CreateLink {
        fluent_builders::CreateLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSite`](crate::client::fluent_builders::CreateSite) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::CreateSite::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::CreateSite::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateSite::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateSite::set_description): <p>A description of your site.</p>  <p>Constraints: Maximum length of 256 characters.</p>
    ///   - [`location(Location)`](crate::client::fluent_builders::CreateSite::location) / [`set_location(Option<Location>)`](crate::client::fluent_builders::CreateSite::set_location): <p>The site location. This information is used for visualization in the Network Manager console. If you specify the address, the latitude and longitude are automatically calculated.</p>  <ul>   <li> <p> <code>Address</code>: The physical address of the site.</p> </li>   <li> <p> <code>Latitude</code>: The latitude of the site. </p> </li>   <li> <p> <code>Longitude</code>: The longitude of the site.</p> </li>  </ul>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateSite::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateSite::set_tags): <p>The tags to apply to the resource during creation.</p>
    /// - On success, responds with [`CreateSiteOutput`](crate::output::CreateSiteOutput) with field(s):
    ///   - [`site(Option<Site>)`](crate::output::CreateSiteOutput::site): <p>Information about the site.</p>
    /// - On failure, responds with [`SdkError<CreateSiteError>`](crate::error::CreateSiteError)
    pub fn create_site(&self) -> fluent_builders::CreateSite {
        fluent_builders::CreateSite::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSiteToSiteVpnAttachment`](crate::client::fluent_builders::CreateSiteToSiteVpnAttachment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_network_id(impl Into<String>)`](crate::client::fluent_builders::CreateSiteToSiteVpnAttachment::core_network_id) / [`set_core_network_id(Option<String>)`](crate::client::fluent_builders::CreateSiteToSiteVpnAttachment::set_core_network_id): <p>The ID of a core network where you're creating a site-to-site VPN attachment.</p>
    ///   - [`vpn_connection_arn(impl Into<String>)`](crate::client::fluent_builders::CreateSiteToSiteVpnAttachment::vpn_connection_arn) / [`set_vpn_connection_arn(Option<String>)`](crate::client::fluent_builders::CreateSiteToSiteVpnAttachment::set_vpn_connection_arn): <p>The ARN identifying the VPN attachment.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateSiteToSiteVpnAttachment::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateSiteToSiteVpnAttachment::set_tags): <p>The tags associated with the request.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateSiteToSiteVpnAttachment::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateSiteToSiteVpnAttachment::set_client_token): <p>The client token associated with the request.</p>
    /// - On success, responds with [`CreateSiteToSiteVpnAttachmentOutput`](crate::output::CreateSiteToSiteVpnAttachmentOutput) with field(s):
    ///   - [`site_to_site_vpn_attachment(Option<SiteToSiteVpnAttachment>)`](crate::output::CreateSiteToSiteVpnAttachmentOutput::site_to_site_vpn_attachment): <p>Details about a site-to-site VPN attachment.</p>
    /// - On failure, responds with [`SdkError<CreateSiteToSiteVpnAttachmentError>`](crate::error::CreateSiteToSiteVpnAttachmentError)
    pub fn create_site_to_site_vpn_attachment(
        &self,
    ) -> fluent_builders::CreateSiteToSiteVpnAttachment {
        fluent_builders::CreateSiteToSiteVpnAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVpcAttachment`](crate::client::fluent_builders::CreateVpcAttachment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_network_id(impl Into<String>)`](crate::client::fluent_builders::CreateVpcAttachment::core_network_id) / [`set_core_network_id(Option<String>)`](crate::client::fluent_builders::CreateVpcAttachment::set_core_network_id): <p>The ID of a core network for the VPC attachment.</p>
    ///   - [`vpc_arn(impl Into<String>)`](crate::client::fluent_builders::CreateVpcAttachment::vpc_arn) / [`set_vpc_arn(Option<String>)`](crate::client::fluent_builders::CreateVpcAttachment::set_vpc_arn): <p>The ARN of the VPC.</p>
    ///   - [`subnet_arns(Vec<String>)`](crate::client::fluent_builders::CreateVpcAttachment::subnet_arns) / [`set_subnet_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateVpcAttachment::set_subnet_arns): <p>The subnet ARN of the VPC attachment.</p>
    ///   - [`options(VpcOptions)`](crate::client::fluent_builders::CreateVpcAttachment::options) / [`set_options(Option<VpcOptions>)`](crate::client::fluent_builders::CreateVpcAttachment::set_options): <p>Options for the VPC attachment.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateVpcAttachment::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateVpcAttachment::set_tags): <p>The key-value tags associated with the request.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateVpcAttachment::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateVpcAttachment::set_client_token): <p>The client token associated with the request.</p>
    /// - On success, responds with [`CreateVpcAttachmentOutput`](crate::output::CreateVpcAttachmentOutput) with field(s):
    ///   - [`vpc_attachment(Option<VpcAttachment>)`](crate::output::CreateVpcAttachmentOutput::vpc_attachment): <p>Provides details about the VPC attachment.</p>
    /// - On failure, responds with [`SdkError<CreateVpcAttachmentError>`](crate::error::CreateVpcAttachmentError)
    pub fn create_vpc_attachment(&self) -> fluent_builders::CreateVpcAttachment {
        fluent_builders::CreateVpcAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAttachment`](crate::client::fluent_builders::DeleteAttachment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attachment_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAttachment::attachment_id) / [`set_attachment_id(Option<String>)`](crate::client::fluent_builders::DeleteAttachment::set_attachment_id): <p>The ID of the attachment to delete.</p>
    /// - On success, responds with [`DeleteAttachmentOutput`](crate::output::DeleteAttachmentOutput) with field(s):
    ///   - [`attachment(Option<Attachment>)`](crate::output::DeleteAttachmentOutput::attachment): <p>Information about the deleted attachment.</p>
    /// - On failure, responds with [`SdkError<DeleteAttachmentError>`](crate::error::DeleteAttachmentError)
    pub fn delete_attachment(&self) -> fluent_builders::DeleteAttachment {
        fluent_builders::DeleteAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConnection`](crate::client::fluent_builders::DeleteConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::DeleteConnection::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::DeleteConnection::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::DeleteConnection::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::DeleteConnection::set_connection_id): <p>The ID of the connection.</p>
    /// - On success, responds with [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput) with field(s):
    ///   - [`connection(Option<Connection>)`](crate::output::DeleteConnectionOutput::connection): <p>Information about the connection.</p>
    /// - On failure, responds with [`SdkError<DeleteConnectionError>`](crate::error::DeleteConnectionError)
    pub fn delete_connection(&self) -> fluent_builders::DeleteConnection {
        fluent_builders::DeleteConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConnectPeer`](crate::client::fluent_builders::DeleteConnectPeer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connect_peer_id(impl Into<String>)`](crate::client::fluent_builders::DeleteConnectPeer::connect_peer_id) / [`set_connect_peer_id(Option<String>)`](crate::client::fluent_builders::DeleteConnectPeer::set_connect_peer_id): <p>The ID of the deleted Connect peer.</p>
    /// - On success, responds with [`DeleteConnectPeerOutput`](crate::output::DeleteConnectPeerOutput) with field(s):
    ///   - [`connect_peer(Option<ConnectPeer>)`](crate::output::DeleteConnectPeerOutput::connect_peer): <p>Information about the deleted Connect peer.</p>
    /// - On failure, responds with [`SdkError<DeleteConnectPeerError>`](crate::error::DeleteConnectPeerError)
    pub fn delete_connect_peer(&self) -> fluent_builders::DeleteConnectPeer {
        fluent_builders::DeleteConnectPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCoreNetwork`](crate::client::fluent_builders::DeleteCoreNetwork) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_network_id(impl Into<String>)`](crate::client::fluent_builders::DeleteCoreNetwork::core_network_id) / [`set_core_network_id(Option<String>)`](crate::client::fluent_builders::DeleteCoreNetwork::set_core_network_id): <p>The network ID of the deleted core network.</p>
    /// - On success, responds with [`DeleteCoreNetworkOutput`](crate::output::DeleteCoreNetworkOutput) with field(s):
    ///   - [`core_network(Option<CoreNetwork>)`](crate::output::DeleteCoreNetworkOutput::core_network): <p>Information about the deleted core network.</p>
    /// - On failure, responds with [`SdkError<DeleteCoreNetworkError>`](crate::error::DeleteCoreNetworkError)
    pub fn delete_core_network(&self) -> fluent_builders::DeleteCoreNetwork {
        fluent_builders::DeleteCoreNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCoreNetworkPolicyVersion`](crate::client::fluent_builders::DeleteCoreNetworkPolicyVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_network_id(impl Into<String>)`](crate::client::fluent_builders::DeleteCoreNetworkPolicyVersion::core_network_id) / [`set_core_network_id(Option<String>)`](crate::client::fluent_builders::DeleteCoreNetworkPolicyVersion::set_core_network_id): <p>The ID of a core network for the deleted policy.</p>
    ///   - [`policy_version_id(i32)`](crate::client::fluent_builders::DeleteCoreNetworkPolicyVersion::policy_version_id) / [`set_policy_version_id(Option<i32>)`](crate::client::fluent_builders::DeleteCoreNetworkPolicyVersion::set_policy_version_id): <p>The version ID of the deleted policy.</p>
    /// - On success, responds with [`DeleteCoreNetworkPolicyVersionOutput`](crate::output::DeleteCoreNetworkPolicyVersionOutput) with field(s):
    ///   - [`core_network_policy(Option<CoreNetworkPolicy>)`](crate::output::DeleteCoreNetworkPolicyVersionOutput::core_network_policy): <p>Returns information about the deleted policy version. </p>
    /// - On failure, responds with [`SdkError<DeleteCoreNetworkPolicyVersionError>`](crate::error::DeleteCoreNetworkPolicyVersionError)
    pub fn delete_core_network_policy_version(
        &self,
    ) -> fluent_builders::DeleteCoreNetworkPolicyVersion {
        fluent_builders::DeleteCoreNetworkPolicyVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDevice`](crate::client::fluent_builders::DeleteDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDevice::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::DeleteDevice::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDevice::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::DeleteDevice::set_device_id): <p>The ID of the device.</p>
    /// - On success, responds with [`DeleteDeviceOutput`](crate::output::DeleteDeviceOutput) with field(s):
    ///   - [`device(Option<Device>)`](crate::output::DeleteDeviceOutput::device): <p>Information about the device.</p>
    /// - On failure, responds with [`SdkError<DeleteDeviceError>`](crate::error::DeleteDeviceError)
    pub fn delete_device(&self) -> fluent_builders::DeleteDevice {
        fluent_builders::DeleteDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGlobalNetwork`](crate::client::fluent_builders::DeleteGlobalNetwork) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::DeleteGlobalNetwork::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::DeleteGlobalNetwork::set_global_network_id): <p>The ID of the global network.</p>
    /// - On success, responds with [`DeleteGlobalNetworkOutput`](crate::output::DeleteGlobalNetworkOutput) with field(s):
    ///   - [`global_network(Option<GlobalNetwork>)`](crate::output::DeleteGlobalNetworkOutput::global_network): <p>Information about the global network.</p>
    /// - On failure, responds with [`SdkError<DeleteGlobalNetworkError>`](crate::error::DeleteGlobalNetworkError)
    pub fn delete_global_network(&self) -> fluent_builders::DeleteGlobalNetwork {
        fluent_builders::DeleteGlobalNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLink`](crate::client::fluent_builders::DeleteLink) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::DeleteLink::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::DeleteLink::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`link_id(impl Into<String>)`](crate::client::fluent_builders::DeleteLink::link_id) / [`set_link_id(Option<String>)`](crate::client::fluent_builders::DeleteLink::set_link_id): <p>The ID of the link.</p>
    /// - On success, responds with [`DeleteLinkOutput`](crate::output::DeleteLinkOutput) with field(s):
    ///   - [`link(Option<Link>)`](crate::output::DeleteLinkOutput::link): <p>Information about the link.</p>
    /// - On failure, responds with [`SdkError<DeleteLinkError>`](crate::error::DeleteLinkError)
    pub fn delete_link(&self) -> fluent_builders::DeleteLink {
        fluent_builders::DeleteLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResourcePolicy`](crate::client::fluent_builders::DeleteResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::set_resource_arn): <p>The ARN of the policy to delete.</p>
    /// - On success, responds with [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteResourcePolicyError>`](crate::error::DeleteResourcePolicyError)
    pub fn delete_resource_policy(&self) -> fluent_builders::DeleteResourcePolicy {
        fluent_builders::DeleteResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSite`](crate::client::fluent_builders::DeleteSite) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSite::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::DeleteSite::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`site_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSite::site_id) / [`set_site_id(Option<String>)`](crate::client::fluent_builders::DeleteSite::set_site_id): <p>The ID of the site.</p>
    /// - On success, responds with [`DeleteSiteOutput`](crate::output::DeleteSiteOutput) with field(s):
    ///   - [`site(Option<Site>)`](crate::output::DeleteSiteOutput::site): <p>Information about the site.</p>
    /// - On failure, responds with [`SdkError<DeleteSiteError>`](crate::error::DeleteSiteError)
    pub fn delete_site(&self) -> fluent_builders::DeleteSite {
        fluent_builders::DeleteSite::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterTransitGateway`](crate::client::fluent_builders::DeregisterTransitGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterTransitGateway::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::DeregisterTransitGateway::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`transit_gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DeregisterTransitGateway::transit_gateway_arn) / [`set_transit_gateway_arn(Option<String>)`](crate::client::fluent_builders::DeregisterTransitGateway::set_transit_gateway_arn): <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
    /// - On success, responds with [`DeregisterTransitGatewayOutput`](crate::output::DeregisterTransitGatewayOutput) with field(s):
    ///   - [`transit_gateway_registration(Option<TransitGatewayRegistration>)`](crate::output::DeregisterTransitGatewayOutput::transit_gateway_registration): <p>The transit gateway registration information.</p>
    /// - On failure, responds with [`SdkError<DeregisterTransitGatewayError>`](crate::error::DeregisterTransitGatewayError)
    pub fn deregister_transit_gateway(&self) -> fluent_builders::DeregisterTransitGateway {
        fluent_builders::DeregisterTransitGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeGlobalNetworks`](crate::client::fluent_builders::DescribeGlobalNetworks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeGlobalNetworks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_ids(Vec<String>)`](crate::client::fluent_builders::DescribeGlobalNetworks::global_network_ids) / [`set_global_network_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeGlobalNetworks::set_global_network_ids): <p>The IDs of one or more global networks. The maximum is 10.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeGlobalNetworks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeGlobalNetworks::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeGlobalNetworks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeGlobalNetworks::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`DescribeGlobalNetworksOutput`](crate::output::DescribeGlobalNetworksOutput) with field(s):
    ///   - [`global_networks(Option<Vec<GlobalNetwork>>)`](crate::output::DescribeGlobalNetworksOutput::global_networks): <p>Information about the global networks.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeGlobalNetworksOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<DescribeGlobalNetworksError>`](crate::error::DescribeGlobalNetworksError)
    pub fn describe_global_networks(&self) -> fluent_builders::DescribeGlobalNetworks {
        fluent_builders::DescribeGlobalNetworks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateConnectPeer`](crate::client::fluent_builders::DisassociateConnectPeer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateConnectPeer::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::DisassociateConnectPeer::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`connect_peer_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateConnectPeer::connect_peer_id) / [`set_connect_peer_id(Option<String>)`](crate::client::fluent_builders::DisassociateConnectPeer::set_connect_peer_id): <p>The ID of the Connect peer to disassociate from a device.</p>
    /// - On success, responds with [`DisassociateConnectPeerOutput`](crate::output::DisassociateConnectPeerOutput) with field(s):
    ///   - [`connect_peer_association(Option<ConnectPeerAssociation>)`](crate::output::DisassociateConnectPeerOutput::connect_peer_association): <p>Describes the Connect peer association.</p>
    /// - On failure, responds with [`SdkError<DisassociateConnectPeerError>`](crate::error::DisassociateConnectPeerError)
    pub fn disassociate_connect_peer(&self) -> fluent_builders::DisassociateConnectPeer {
        fluent_builders::DisassociateConnectPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateCustomerGateway`](crate::client::fluent_builders::DisassociateCustomerGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateCustomerGateway::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::DisassociateCustomerGateway::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`customer_gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateCustomerGateway::customer_gateway_arn) / [`set_customer_gateway_arn(Option<String>)`](crate::client::fluent_builders::DisassociateCustomerGateway::set_customer_gateway_arn): <p>The Amazon Resource Name (ARN) of the customer gateway.</p>
    /// - On success, responds with [`DisassociateCustomerGatewayOutput`](crate::output::DisassociateCustomerGatewayOutput) with field(s):
    ///   - [`customer_gateway_association(Option<CustomerGatewayAssociation>)`](crate::output::DisassociateCustomerGatewayOutput::customer_gateway_association): <p>Information about the customer gateway association.</p>
    /// - On failure, responds with [`SdkError<DisassociateCustomerGatewayError>`](crate::error::DisassociateCustomerGatewayError)
    pub fn disassociate_customer_gateway(&self) -> fluent_builders::DisassociateCustomerGateway {
        fluent_builders::DisassociateCustomerGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateLink`](crate::client::fluent_builders::DisassociateLink) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateLink::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::DisassociateLink::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateLink::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::DisassociateLink::set_device_id): <p>The ID of the device.</p>
    ///   - [`link_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateLink::link_id) / [`set_link_id(Option<String>)`](crate::client::fluent_builders::DisassociateLink::set_link_id): <p>The ID of the link.</p>
    /// - On success, responds with [`DisassociateLinkOutput`](crate::output::DisassociateLinkOutput) with field(s):
    ///   - [`link_association(Option<LinkAssociation>)`](crate::output::DisassociateLinkOutput::link_association): <p>Information about the link association.</p>
    /// - On failure, responds with [`SdkError<DisassociateLinkError>`](crate::error::DisassociateLinkError)
    pub fn disassociate_link(&self) -> fluent_builders::DisassociateLink {
        fluent_builders::DisassociateLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateTransitGatewayConnectPeer`](crate::client::fluent_builders::DisassociateTransitGatewayConnectPeer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateTransitGatewayConnectPeer::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::DisassociateTransitGatewayConnectPeer::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`transit_gateway_connect_peer_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateTransitGatewayConnectPeer::transit_gateway_connect_peer_arn) / [`set_transit_gateway_connect_peer_arn(Option<String>)`](crate::client::fluent_builders::DisassociateTransitGatewayConnectPeer::set_transit_gateway_connect_peer_arn): <p>The Amazon Resource Name (ARN) of the transit gateway Connect peer.</p>
    /// - On success, responds with [`DisassociateTransitGatewayConnectPeerOutput`](crate::output::DisassociateTransitGatewayConnectPeerOutput) with field(s):
    ///   - [`transit_gateway_connect_peer_association(Option<TransitGatewayConnectPeerAssociation>)`](crate::output::DisassociateTransitGatewayConnectPeerOutput::transit_gateway_connect_peer_association): <p>The transit gateway Connect peer association.</p>
    /// - On failure, responds with [`SdkError<DisassociateTransitGatewayConnectPeerError>`](crate::error::DisassociateTransitGatewayConnectPeerError)
    pub fn disassociate_transit_gateway_connect_peer(
        &self,
    ) -> fluent_builders::DisassociateTransitGatewayConnectPeer {
        fluent_builders::DisassociateTransitGatewayConnectPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExecuteCoreNetworkChangeSet`](crate::client::fluent_builders::ExecuteCoreNetworkChangeSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_network_id(impl Into<String>)`](crate::client::fluent_builders::ExecuteCoreNetworkChangeSet::core_network_id) / [`set_core_network_id(Option<String>)`](crate::client::fluent_builders::ExecuteCoreNetworkChangeSet::set_core_network_id): <p>The ID of a core network.</p>
    ///   - [`policy_version_id(i32)`](crate::client::fluent_builders::ExecuteCoreNetworkChangeSet::policy_version_id) / [`set_policy_version_id(Option<i32>)`](crate::client::fluent_builders::ExecuteCoreNetworkChangeSet::set_policy_version_id): <p>The ID of the policy version.</p>
    /// - On success, responds with [`ExecuteCoreNetworkChangeSetOutput`](crate::output::ExecuteCoreNetworkChangeSetOutput)

    /// - On failure, responds with [`SdkError<ExecuteCoreNetworkChangeSetError>`](crate::error::ExecuteCoreNetworkChangeSetError)
    pub fn execute_core_network_change_set(&self) -> fluent_builders::ExecuteCoreNetworkChangeSet {
        fluent_builders::ExecuteCoreNetworkChangeSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetConnectAttachment`](crate::client::fluent_builders::GetConnectAttachment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attachment_id(impl Into<String>)`](crate::client::fluent_builders::GetConnectAttachment::attachment_id) / [`set_attachment_id(Option<String>)`](crate::client::fluent_builders::GetConnectAttachment::set_attachment_id): <p>The ID of the attachment.</p>
    /// - On success, responds with [`GetConnectAttachmentOutput`](crate::output::GetConnectAttachmentOutput) with field(s):
    ///   - [`connect_attachment(Option<ConnectAttachment>)`](crate::output::GetConnectAttachmentOutput::connect_attachment): <p>Details about the Connect attachment.</p>
    /// - On failure, responds with [`SdkError<GetConnectAttachmentError>`](crate::error::GetConnectAttachmentError)
    pub fn get_connect_attachment(&self) -> fluent_builders::GetConnectAttachment {
        fluent_builders::GetConnectAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetConnections`](crate::client::fluent_builders::GetConnections) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetConnections::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::GetConnections::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::GetConnections::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`connection_ids(Vec<String>)`](crate::client::fluent_builders::GetConnections::connection_ids) / [`set_connection_ids(Option<Vec<String>>)`](crate::client::fluent_builders::GetConnections::set_connection_ids): <p>One or more connection IDs.</p>
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::GetConnections::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::GetConnections::set_device_id): <p>The ID of the device.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetConnections::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetConnections::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetConnections::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetConnections::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`GetConnectionsOutput`](crate::output::GetConnectionsOutput) with field(s):
    ///   - [`connections(Option<Vec<Connection>>)`](crate::output::GetConnectionsOutput::connections): <p>Information about the connections.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetConnectionsOutput::next_token): <p>The token to use for the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetConnectionsError>`](crate::error::GetConnectionsError)
    pub fn get_connections(&self) -> fluent_builders::GetConnections {
        fluent_builders::GetConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetConnectPeer`](crate::client::fluent_builders::GetConnectPeer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connect_peer_id(impl Into<String>)`](crate::client::fluent_builders::GetConnectPeer::connect_peer_id) / [`set_connect_peer_id(Option<String>)`](crate::client::fluent_builders::GetConnectPeer::set_connect_peer_id): <p>The ID of the Connect peer.</p>
    /// - On success, responds with [`GetConnectPeerOutput`](crate::output::GetConnectPeerOutput) with field(s):
    ///   - [`connect_peer(Option<ConnectPeer>)`](crate::output::GetConnectPeerOutput::connect_peer): <p>Returns information about a core network Connect peer.</p>
    /// - On failure, responds with [`SdkError<GetConnectPeerError>`](crate::error::GetConnectPeerError)
    pub fn get_connect_peer(&self) -> fluent_builders::GetConnectPeer {
        fluent_builders::GetConnectPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetConnectPeerAssociations`](crate::client::fluent_builders::GetConnectPeerAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetConnectPeerAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::GetConnectPeerAssociations::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::GetConnectPeerAssociations::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`connect_peer_ids(Vec<String>)`](crate::client::fluent_builders::GetConnectPeerAssociations::connect_peer_ids) / [`set_connect_peer_ids(Option<Vec<String>>)`](crate::client::fluent_builders::GetConnectPeerAssociations::set_connect_peer_ids): <p>The IDs of the Connect peers.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetConnectPeerAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetConnectPeerAssociations::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetConnectPeerAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetConnectPeerAssociations::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`GetConnectPeerAssociationsOutput`](crate::output::GetConnectPeerAssociationsOutput) with field(s):
    ///   - [`connect_peer_associations(Option<Vec<ConnectPeerAssociation>>)`](crate::output::GetConnectPeerAssociationsOutput::connect_peer_associations): <p>Displays a list of Connect peer associations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetConnectPeerAssociationsOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetConnectPeerAssociationsError>`](crate::error::GetConnectPeerAssociationsError)
    pub fn get_connect_peer_associations(&self) -> fluent_builders::GetConnectPeerAssociations {
        fluent_builders::GetConnectPeerAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCoreNetwork`](crate::client::fluent_builders::GetCoreNetwork) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_network_id(impl Into<String>)`](crate::client::fluent_builders::GetCoreNetwork::core_network_id) / [`set_core_network_id(Option<String>)`](crate::client::fluent_builders::GetCoreNetwork::set_core_network_id): <p>The ID of a core network.</p>
    /// - On success, responds with [`GetCoreNetworkOutput`](crate::output::GetCoreNetworkOutput) with field(s):
    ///   - [`core_network(Option<CoreNetwork>)`](crate::output::GetCoreNetworkOutput::core_network): <p>Details about a core network.</p>
    /// - On failure, responds with [`SdkError<GetCoreNetworkError>`](crate::error::GetCoreNetworkError)
    pub fn get_core_network(&self) -> fluent_builders::GetCoreNetwork {
        fluent_builders::GetCoreNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCoreNetworkChangeSet`](crate::client::fluent_builders::GetCoreNetworkChangeSet) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetCoreNetworkChangeSet::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_network_id(impl Into<String>)`](crate::client::fluent_builders::GetCoreNetworkChangeSet::core_network_id) / [`set_core_network_id(Option<String>)`](crate::client::fluent_builders::GetCoreNetworkChangeSet::set_core_network_id): <p>The ID of a core network.</p>
    ///   - [`policy_version_id(i32)`](crate::client::fluent_builders::GetCoreNetworkChangeSet::policy_version_id) / [`set_policy_version_id(Option<i32>)`](crate::client::fluent_builders::GetCoreNetworkChangeSet::set_policy_version_id): <p>The ID of the policy version.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetCoreNetworkChangeSet::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetCoreNetworkChangeSet::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetCoreNetworkChangeSet::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetCoreNetworkChangeSet::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`GetCoreNetworkChangeSetOutput`](crate::output::GetCoreNetworkChangeSetOutput) with field(s):
    ///   - [`core_network_changes(Option<Vec<CoreNetworkChange>>)`](crate::output::GetCoreNetworkChangeSetOutput::core_network_changes): <p>Describes a core network changes.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetCoreNetworkChangeSetOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetCoreNetworkChangeSetError>`](crate::error::GetCoreNetworkChangeSetError)
    pub fn get_core_network_change_set(&self) -> fluent_builders::GetCoreNetworkChangeSet {
        fluent_builders::GetCoreNetworkChangeSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCoreNetworkPolicy`](crate::client::fluent_builders::GetCoreNetworkPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_network_id(impl Into<String>)`](crate::client::fluent_builders::GetCoreNetworkPolicy::core_network_id) / [`set_core_network_id(Option<String>)`](crate::client::fluent_builders::GetCoreNetworkPolicy::set_core_network_id): <p>The ID of a core network.</p>
    ///   - [`policy_version_id(i32)`](crate::client::fluent_builders::GetCoreNetworkPolicy::policy_version_id) / [`set_policy_version_id(Option<i32>)`](crate::client::fluent_builders::GetCoreNetworkPolicy::set_policy_version_id): <p>The ID of a core network policy version.</p>
    ///   - [`alias(CoreNetworkPolicyAlias)`](crate::client::fluent_builders::GetCoreNetworkPolicy::alias) / [`set_alias(Option<CoreNetworkPolicyAlias>)`](crate::client::fluent_builders::GetCoreNetworkPolicy::set_alias): <p>The alias of a core network policy </p>
    /// - On success, responds with [`GetCoreNetworkPolicyOutput`](crate::output::GetCoreNetworkPolicyOutput) with field(s):
    ///   - [`core_network_policy(Option<CoreNetworkPolicy>)`](crate::output::GetCoreNetworkPolicyOutput::core_network_policy): <p>The details about a core network policy.</p>
    /// - On failure, responds with [`SdkError<GetCoreNetworkPolicyError>`](crate::error::GetCoreNetworkPolicyError)
    pub fn get_core_network_policy(&self) -> fluent_builders::GetCoreNetworkPolicy {
        fluent_builders::GetCoreNetworkPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCustomerGatewayAssociations`](crate::client::fluent_builders::GetCustomerGatewayAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetCustomerGatewayAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::GetCustomerGatewayAssociations::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::GetCustomerGatewayAssociations::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`customer_gateway_arns(Vec<String>)`](crate::client::fluent_builders::GetCustomerGatewayAssociations::customer_gateway_arns) / [`set_customer_gateway_arns(Option<Vec<String>>)`](crate::client::fluent_builders::GetCustomerGatewayAssociations::set_customer_gateway_arns): <p>One or more customer gateway Amazon Resource Names (ARNs). The maximum is 10.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetCustomerGatewayAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetCustomerGatewayAssociations::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetCustomerGatewayAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetCustomerGatewayAssociations::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`GetCustomerGatewayAssociationsOutput`](crate::output::GetCustomerGatewayAssociationsOutput) with field(s):
    ///   - [`customer_gateway_associations(Option<Vec<CustomerGatewayAssociation>>)`](crate::output::GetCustomerGatewayAssociationsOutput::customer_gateway_associations): <p>The customer gateway associations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetCustomerGatewayAssociationsOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetCustomerGatewayAssociationsError>`](crate::error::GetCustomerGatewayAssociationsError)
    pub fn get_customer_gateway_associations(
        &self,
    ) -> fluent_builders::GetCustomerGatewayAssociations {
        fluent_builders::GetCustomerGatewayAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDevices`](crate::client::fluent_builders::GetDevices) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetDevices::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::GetDevices::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::GetDevices::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`device_ids(Vec<String>)`](crate::client::fluent_builders::GetDevices::device_ids) / [`set_device_ids(Option<Vec<String>>)`](crate::client::fluent_builders::GetDevices::set_device_ids): <p>One or more device IDs. The maximum is 10.</p>
    ///   - [`site_id(impl Into<String>)`](crate::client::fluent_builders::GetDevices::site_id) / [`set_site_id(Option<String>)`](crate::client::fluent_builders::GetDevices::set_site_id): <p>The ID of the site.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetDevices::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetDevices::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetDevices::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetDevices::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`GetDevicesOutput`](crate::output::GetDevicesOutput) with field(s):
    ///   - [`devices(Option<Vec<Device>>)`](crate::output::GetDevicesOutput::devices): <p>The devices.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetDevicesOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetDevicesError>`](crate::error::GetDevicesError)
    pub fn get_devices(&self) -> fluent_builders::GetDevices {
        fluent_builders::GetDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLinkAssociations`](crate::client::fluent_builders::GetLinkAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetLinkAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::GetLinkAssociations::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::GetLinkAssociations::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::GetLinkAssociations::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::GetLinkAssociations::set_device_id): <p>The ID of the device.</p>
    ///   - [`link_id(impl Into<String>)`](crate::client::fluent_builders::GetLinkAssociations::link_id) / [`set_link_id(Option<String>)`](crate::client::fluent_builders::GetLinkAssociations::set_link_id): <p>The ID of the link.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetLinkAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetLinkAssociations::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetLinkAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetLinkAssociations::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`GetLinkAssociationsOutput`](crate::output::GetLinkAssociationsOutput) with field(s):
    ///   - [`link_associations(Option<Vec<LinkAssociation>>)`](crate::output::GetLinkAssociationsOutput::link_associations): <p>The link associations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetLinkAssociationsOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetLinkAssociationsError>`](crate::error::GetLinkAssociationsError)
    pub fn get_link_associations(&self) -> fluent_builders::GetLinkAssociations {
        fluent_builders::GetLinkAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLinks`](crate::client::fluent_builders::GetLinks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetLinks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::GetLinks::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::GetLinks::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`link_ids(Vec<String>)`](crate::client::fluent_builders::GetLinks::link_ids) / [`set_link_ids(Option<Vec<String>>)`](crate::client::fluent_builders::GetLinks::set_link_ids): <p>One or more link IDs. The maximum is 10.</p>
    ///   - [`site_id(impl Into<String>)`](crate::client::fluent_builders::GetLinks::site_id) / [`set_site_id(Option<String>)`](crate::client::fluent_builders::GetLinks::set_site_id): <p>The ID of the site.</p>
    ///   - [`r#type(impl Into<String>)`](crate::client::fluent_builders::GetLinks::type) / [`set_type(Option<String>)`](crate::client::fluent_builders::GetLinks::set_type): <p>The link type.</p>
    ///   - [`provider(impl Into<String>)`](crate::client::fluent_builders::GetLinks::provider) / [`set_provider(Option<String>)`](crate::client::fluent_builders::GetLinks::set_provider): <p>The link provider.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetLinks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetLinks::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetLinks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetLinks::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`GetLinksOutput`](crate::output::GetLinksOutput) with field(s):
    ///   - [`links(Option<Vec<Link>>)`](crate::output::GetLinksOutput::links): <p>The links.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetLinksOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetLinksError>`](crate::error::GetLinksError)
    pub fn get_links(&self) -> fluent_builders::GetLinks {
        fluent_builders::GetLinks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetNetworkResourceCounts`](crate::client::fluent_builders::GetNetworkResourceCounts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetNetworkResourceCounts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::GetNetworkResourceCounts::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::GetNetworkResourceCounts::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`resource_type(impl Into<String>)`](crate::client::fluent_builders::GetNetworkResourceCounts::resource_type) / [`set_resource_type(Option<String>)`](crate::client::fluent_builders::GetNetworkResourceCounts::set_resource_type): <p>The resource type.</p>  <p>The following are the supported resource types for Direct Connect:</p>  <ul>   <li> <p> <code>dxcon</code> </p> </li>   <li> <p> <code>dx-gateway</code> </p> </li>   <li> <p> <code>dx-vif</code> </p> </li>  </ul>  <p>The following are the supported resource types for Network Manager:</p>  <ul>   <li> <p> <code>connection</code> </p> </li>   <li> <p> <code>device</code> </p> </li>   <li> <p> <code>link</code> </p> </li>   <li> <p> <code>site</code> </p> </li>  </ul>  <p>The following are the supported resource types for Amazon VPC:</p>  <ul>   <li> <p> <code>customer-gateway</code> </p> </li>   <li> <p> <code>transit-gateway</code> </p> </li>   <li> <p> <code>transit-gateway-attachment</code> </p> </li>   <li> <p> <code>transit-gateway-connect-peer</code> </p> </li>   <li> <p> <code>transit-gateway-route-table</code> </p> </li>   <li> <p> <code>vpn-connection</code> </p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetNetworkResourceCounts::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetNetworkResourceCounts::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetNetworkResourceCounts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetNetworkResourceCounts::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`GetNetworkResourceCountsOutput`](crate::output::GetNetworkResourceCountsOutput) with field(s):
    ///   - [`network_resource_counts(Option<Vec<NetworkResourceCount>>)`](crate::output::GetNetworkResourceCountsOutput::network_resource_counts): <p>The count of resources.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetNetworkResourceCountsOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetNetworkResourceCountsError>`](crate::error::GetNetworkResourceCountsError)
    pub fn get_network_resource_counts(&self) -> fluent_builders::GetNetworkResourceCounts {
        fluent_builders::GetNetworkResourceCounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetNetworkResourceRelationships`](crate::client::fluent_builders::GetNetworkResourceRelationships) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetNetworkResourceRelationships::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::GetNetworkResourceRelationships::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::GetNetworkResourceRelationships::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`core_network_id(impl Into<String>)`](crate::client::fluent_builders::GetNetworkResourceRelationships::core_network_id) / [`set_core_network_id(Option<String>)`](crate::client::fluent_builders::GetNetworkResourceRelationships::set_core_network_id): <p>The ID of a core network.</p>
    ///   - [`registered_gateway_arn(impl Into<String>)`](crate::client::fluent_builders::GetNetworkResourceRelationships::registered_gateway_arn) / [`set_registered_gateway_arn(Option<String>)`](crate::client::fluent_builders::GetNetworkResourceRelationships::set_registered_gateway_arn): <p>The ARN of the registered gateway.</p>
    ///   - [`aws_region(impl Into<String>)`](crate::client::fluent_builders::GetNetworkResourceRelationships::aws_region) / [`set_aws_region(Option<String>)`](crate::client::fluent_builders::GetNetworkResourceRelationships::set_aws_region): <p>The Amazon Web Services Region.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetNetworkResourceRelationships::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetNetworkResourceRelationships::set_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`resource_type(impl Into<String>)`](crate::client::fluent_builders::GetNetworkResourceRelationships::resource_type) / [`set_resource_type(Option<String>)`](crate::client::fluent_builders::GetNetworkResourceRelationships::set_resource_type): <p>The resource type.</p>  <p>The following are the supported resource types for Direct Connect:</p>  <ul>   <li> <p> <code>dxcon</code> </p> </li>   <li> <p> <code>dx-gateway</code> </p> </li>   <li> <p> <code>dx-vif</code> </p> </li>  </ul>  <p>The following are the supported resource types for Network Manager:</p>  <ul>   <li> <p> <code>connection</code> </p> </li>   <li> <p> <code>device</code> </p> </li>   <li> <p> <code>link</code> </p> </li>   <li> <p> <code>site</code> </p> </li>  </ul>  <p>The following are the supported resource types for Amazon VPC:</p>  <ul>   <li> <p> <code>customer-gateway</code> </p> </li>   <li> <p> <code>transit-gateway</code> </p> </li>   <li> <p> <code>transit-gateway-attachment</code> </p> </li>   <li> <p> <code>transit-gateway-connect-peer</code> </p> </li>   <li> <p> <code>transit-gateway-route-table</code> </p> </li>   <li> <p> <code>vpn-connection</code> </p> </li>  </ul>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::GetNetworkResourceRelationships::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::GetNetworkResourceRelationships::set_resource_arn): <p>The ARN of the gateway.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetNetworkResourceRelationships::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetNetworkResourceRelationships::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetNetworkResourceRelationships::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetNetworkResourceRelationships::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`GetNetworkResourceRelationshipsOutput`](crate::output::GetNetworkResourceRelationshipsOutput) with field(s):
    ///   - [`relationships(Option<Vec<Relationship>>)`](crate::output::GetNetworkResourceRelationshipsOutput::relationships): <p>The resource relationships.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetNetworkResourceRelationshipsOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetNetworkResourceRelationshipsError>`](crate::error::GetNetworkResourceRelationshipsError)
    pub fn get_network_resource_relationships(
        &self,
    ) -> fluent_builders::GetNetworkResourceRelationships {
        fluent_builders::GetNetworkResourceRelationships::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetNetworkResources`](crate::client::fluent_builders::GetNetworkResources) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetNetworkResources::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::GetNetworkResources::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::GetNetworkResources::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`core_network_id(impl Into<String>)`](crate::client::fluent_builders::GetNetworkResources::core_network_id) / [`set_core_network_id(Option<String>)`](crate::client::fluent_builders::GetNetworkResources::set_core_network_id): <p>The ID of a core network.</p>
    ///   - [`registered_gateway_arn(impl Into<String>)`](crate::client::fluent_builders::GetNetworkResources::registered_gateway_arn) / [`set_registered_gateway_arn(Option<String>)`](crate::client::fluent_builders::GetNetworkResources::set_registered_gateway_arn): <p>The ARN of the gateway.</p>
    ///   - [`aws_region(impl Into<String>)`](crate::client::fluent_builders::GetNetworkResources::aws_region) / [`set_aws_region(Option<String>)`](crate::client::fluent_builders::GetNetworkResources::set_aws_region): <p>The Amazon Web Services Region.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetNetworkResources::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetNetworkResources::set_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`resource_type(impl Into<String>)`](crate::client::fluent_builders::GetNetworkResources::resource_type) / [`set_resource_type(Option<String>)`](crate::client::fluent_builders::GetNetworkResources::set_resource_type): <p>The resource type.</p>  <p>The following are the supported resource types for Direct Connect:</p>  <ul>   <li> <p> <code>dxcon</code> - The definition model is <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_Connection.html">Connection</a>.</p> </li>   <li> <p> <code>dx-gateway</code> - The definition model is <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DirectConnectGateway.html">DirectConnectGateway</a>.</p> </li>   <li> <p> <code>dx-vif</code> - The definition model is <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_VirtualInterface.html">VirtualInterface</a>.</p> </li>  </ul>  <p>The following are the supported resource types for Network Manager:</p>  <ul>   <li> <p> <code>connection</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Connection.html">Connection</a>.</p> </li>   <li> <p> <code>device</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Device.html">Device</a>.</p> </li>   <li> <p> <code>link</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Link.html">Link</a>.</p> </li>   <li> <p> <code>site</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Site.html">Site</a>.</p> </li>  </ul>  <p>The following are the supported resource types for Amazon VPC:</p>  <ul>   <li> <p> <code>customer-gateway</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CustomerGateway.html">CustomerGateway</a>.</p> </li>   <li> <p> <code>transit-gateway</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGateway.html">TransitGateway</a>.</p> </li>   <li> <p> <code>transit-gateway-attachment</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayAttachment.html">TransitGatewayAttachment</a>.</p> </li>   <li> <p> <code>transit-gateway-connect-peer</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayConnectPeer.html">TransitGatewayConnectPeer</a>.</p> </li>   <li> <p> <code>transit-gateway-route-table</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayRouteTable.html">TransitGatewayRouteTable</a>.</p> </li>   <li> <p> <code>vpn-connection</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpnConnection.html">VpnConnection</a>.</p> </li>  </ul>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::GetNetworkResources::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::GetNetworkResources::set_resource_arn): <p>The ARN of the resource.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetNetworkResources::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetNetworkResources::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetNetworkResources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetNetworkResources::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`GetNetworkResourcesOutput`](crate::output::GetNetworkResourcesOutput) with field(s):
    ///   - [`network_resources(Option<Vec<NetworkResource>>)`](crate::output::GetNetworkResourcesOutput::network_resources): <p>The network resources.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetNetworkResourcesOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetNetworkResourcesError>`](crate::error::GetNetworkResourcesError)
    pub fn get_network_resources(&self) -> fluent_builders::GetNetworkResources {
        fluent_builders::GetNetworkResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetNetworkRoutes`](crate::client::fluent_builders::GetNetworkRoutes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::GetNetworkRoutes::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::GetNetworkRoutes::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`route_table_identifier(RouteTableIdentifier)`](crate::client::fluent_builders::GetNetworkRoutes::route_table_identifier) / [`set_route_table_identifier(Option<RouteTableIdentifier>)`](crate::client::fluent_builders::GetNetworkRoutes::set_route_table_identifier): <p>The ID of the route table.</p>
    ///   - [`exact_cidr_matches(Vec<String>)`](crate::client::fluent_builders::GetNetworkRoutes::exact_cidr_matches) / [`set_exact_cidr_matches(Option<Vec<String>>)`](crate::client::fluent_builders::GetNetworkRoutes::set_exact_cidr_matches): <p>An exact CIDR block.</p>
    ///   - [`longest_prefix_matches(Vec<String>)`](crate::client::fluent_builders::GetNetworkRoutes::longest_prefix_matches) / [`set_longest_prefix_matches(Option<Vec<String>>)`](crate::client::fluent_builders::GetNetworkRoutes::set_longest_prefix_matches): <p>The most specific route that matches the traffic (longest prefix match).</p>
    ///   - [`subnet_of_matches(Vec<String>)`](crate::client::fluent_builders::GetNetworkRoutes::subnet_of_matches) / [`set_subnet_of_matches(Option<Vec<String>>)`](crate::client::fluent_builders::GetNetworkRoutes::set_subnet_of_matches): <p>The routes with a subnet that match the specified CIDR filter.</p>
    ///   - [`supernet_of_matches(Vec<String>)`](crate::client::fluent_builders::GetNetworkRoutes::supernet_of_matches) / [`set_supernet_of_matches(Option<Vec<String>>)`](crate::client::fluent_builders::GetNetworkRoutes::set_supernet_of_matches): <p>The routes with a CIDR that encompasses the CIDR filter. Example: If you specify 10.0.1.0/30, then the result returns 10.0.1.0/29.</p>
    ///   - [`prefix_list_ids(Vec<String>)`](crate::client::fluent_builders::GetNetworkRoutes::prefix_list_ids) / [`set_prefix_list_ids(Option<Vec<String>>)`](crate::client::fluent_builders::GetNetworkRoutes::set_prefix_list_ids): <p>The IDs of the prefix lists.</p>
    ///   - [`states(Vec<RouteState>)`](crate::client::fluent_builders::GetNetworkRoutes::states) / [`set_states(Option<Vec<RouteState>>)`](crate::client::fluent_builders::GetNetworkRoutes::set_states): <p>The route states.</p>
    ///   - [`types(Vec<RouteType>)`](crate::client::fluent_builders::GetNetworkRoutes::types) / [`set_types(Option<Vec<RouteType>>)`](crate::client::fluent_builders::GetNetworkRoutes::set_types): <p>The route types.</p>
    ///   - [`destination_filters(HashMap<String, Vec<String>>)`](crate::client::fluent_builders::GetNetworkRoutes::destination_filters) / [`set_destination_filters(Option<HashMap<String, Vec<String>>>)`](crate::client::fluent_builders::GetNetworkRoutes::set_destination_filters): <p>Filter by route table destination. Possible Values: TRANSIT_GATEWAY_ATTACHMENT_ID, RESOURCE_ID, or RESOURCE_TYPE.</p>
    /// - On success, responds with [`GetNetworkRoutesOutput`](crate::output::GetNetworkRoutesOutput) with field(s):
    ///   - [`route_table_arn(Option<String>)`](crate::output::GetNetworkRoutesOutput::route_table_arn): <p>The ARN of the route table.</p>
    ///   - [`core_network_segment_edge(Option<CoreNetworkSegmentEdgeIdentifier>)`](crate::output::GetNetworkRoutesOutput::core_network_segment_edge): <p>Describes a core network segment edge.</p>
    ///   - [`route_table_type(Option<RouteTableType>)`](crate::output::GetNetworkRoutesOutput::route_table_type): <p>The route table type.</p>
    ///   - [`route_table_timestamp(Option<DateTime>)`](crate::output::GetNetworkRoutesOutput::route_table_timestamp): <p>The route table creation time.</p>
    ///   - [`network_routes(Option<Vec<NetworkRoute>>)`](crate::output::GetNetworkRoutesOutput::network_routes): <p>The network routes.</p>
    /// - On failure, responds with [`SdkError<GetNetworkRoutesError>`](crate::error::GetNetworkRoutesError)
    pub fn get_network_routes(&self) -> fluent_builders::GetNetworkRoutes {
        fluent_builders::GetNetworkRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetNetworkTelemetry`](crate::client::fluent_builders::GetNetworkTelemetry) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetNetworkTelemetry::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::GetNetworkTelemetry::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::GetNetworkTelemetry::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`core_network_id(impl Into<String>)`](crate::client::fluent_builders::GetNetworkTelemetry::core_network_id) / [`set_core_network_id(Option<String>)`](crate::client::fluent_builders::GetNetworkTelemetry::set_core_network_id): <p>The ID of a core network.</p>
    ///   - [`registered_gateway_arn(impl Into<String>)`](crate::client::fluent_builders::GetNetworkTelemetry::registered_gateway_arn) / [`set_registered_gateway_arn(Option<String>)`](crate::client::fluent_builders::GetNetworkTelemetry::set_registered_gateway_arn): <p>The ARN of the gateway.</p>
    ///   - [`aws_region(impl Into<String>)`](crate::client::fluent_builders::GetNetworkTelemetry::aws_region) / [`set_aws_region(Option<String>)`](crate::client::fluent_builders::GetNetworkTelemetry::set_aws_region): <p>The Amazon Web Services Region.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetNetworkTelemetry::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetNetworkTelemetry::set_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`resource_type(impl Into<String>)`](crate::client::fluent_builders::GetNetworkTelemetry::resource_type) / [`set_resource_type(Option<String>)`](crate::client::fluent_builders::GetNetworkTelemetry::set_resource_type): <p>The resource type.</p>  <p>The following are the supported resource types for Direct Connect:</p>  <ul>   <li> <p> <code>dxcon</code> </p> </li>   <li> <p> <code>dx-gateway</code> </p> </li>   <li> <p> <code>dx-vif</code> </p> </li>  </ul>  <p>The following are the supported resource types for Network Manager:</p>  <ul>   <li> <p> <code>connection</code> </p> </li>   <li> <p> <code>device</code> </p> </li>   <li> <p> <code>link</code> </p> </li>   <li> <p> <code>site</code> </p> </li>  </ul>  <p>The following are the supported resource types for Amazon VPC:</p>  <ul>   <li> <p> <code>customer-gateway</code> </p> </li>   <li> <p> <code>transit-gateway</code> </p> </li>   <li> <p> <code>transit-gateway-attachment</code> </p> </li>   <li> <p> <code>transit-gateway-connect-peer</code> </p> </li>   <li> <p> <code>transit-gateway-route-table</code> </p> </li>   <li> <p> <code>vpn-connection</code> </p> </li>  </ul>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::GetNetworkTelemetry::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::GetNetworkTelemetry::set_resource_arn): <p>The ARN of the resource.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetNetworkTelemetry::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetNetworkTelemetry::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetNetworkTelemetry::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetNetworkTelemetry::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`GetNetworkTelemetryOutput`](crate::output::GetNetworkTelemetryOutput) with field(s):
    ///   - [`network_telemetry(Option<Vec<NetworkTelemetry>>)`](crate::output::GetNetworkTelemetryOutput::network_telemetry): <p>The network telemetry.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetNetworkTelemetryOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetNetworkTelemetryError>`](crate::error::GetNetworkTelemetryError)
    pub fn get_network_telemetry(&self) -> fluent_builders::GetNetworkTelemetry {
        fluent_builders::GetNetworkTelemetry::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResourcePolicy`](crate::client::fluent_builders::GetResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::GetResourcePolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::GetResourcePolicy::set_resource_arn): <p>The ARN of the resource.</p>
    /// - On success, responds with [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput) with field(s):
    ///   - [`policy_document(Option<String>)`](crate::output::GetResourcePolicyOutput::policy_document): <p>The resource policy document.</p>
    /// - On failure, responds with [`SdkError<GetResourcePolicyError>`](crate::error::GetResourcePolicyError)
    pub fn get_resource_policy(&self) -> fluent_builders::GetResourcePolicy {
        fluent_builders::GetResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRouteAnalysis`](crate::client::fluent_builders::GetRouteAnalysis) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::GetRouteAnalysis::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::GetRouteAnalysis::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`route_analysis_id(impl Into<String>)`](crate::client::fluent_builders::GetRouteAnalysis::route_analysis_id) / [`set_route_analysis_id(Option<String>)`](crate::client::fluent_builders::GetRouteAnalysis::set_route_analysis_id): <p>The ID of the route analysis.</p>
    /// - On success, responds with [`GetRouteAnalysisOutput`](crate::output::GetRouteAnalysisOutput) with field(s):
    ///   - [`route_analysis(Option<RouteAnalysis>)`](crate::output::GetRouteAnalysisOutput::route_analysis): <p>The route analysis.</p>
    /// - On failure, responds with [`SdkError<GetRouteAnalysisError>`](crate::error::GetRouteAnalysisError)
    pub fn get_route_analysis(&self) -> fluent_builders::GetRouteAnalysis {
        fluent_builders::GetRouteAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSites`](crate::client::fluent_builders::GetSites) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetSites::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::GetSites::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::GetSites::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`site_ids(Vec<String>)`](crate::client::fluent_builders::GetSites::site_ids) / [`set_site_ids(Option<Vec<String>>)`](crate::client::fluent_builders::GetSites::set_site_ids): <p>One or more site IDs. The maximum is 10.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetSites::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetSites::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetSites::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetSites::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`GetSitesOutput`](crate::output::GetSitesOutput) with field(s):
    ///   - [`sites(Option<Vec<Site>>)`](crate::output::GetSitesOutput::sites): <p>The sites.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetSitesOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetSitesError>`](crate::error::GetSitesError)
    pub fn get_sites(&self) -> fluent_builders::GetSites {
        fluent_builders::GetSites::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSiteToSiteVpnAttachment`](crate::client::fluent_builders::GetSiteToSiteVpnAttachment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attachment_id(impl Into<String>)`](crate::client::fluent_builders::GetSiteToSiteVpnAttachment::attachment_id) / [`set_attachment_id(Option<String>)`](crate::client::fluent_builders::GetSiteToSiteVpnAttachment::set_attachment_id): <p>The ID of the attachment.</p>
    /// - On success, responds with [`GetSiteToSiteVpnAttachmentOutput`](crate::output::GetSiteToSiteVpnAttachmentOutput) with field(s):
    ///   - [`site_to_site_vpn_attachment(Option<SiteToSiteVpnAttachment>)`](crate::output::GetSiteToSiteVpnAttachmentOutput::site_to_site_vpn_attachment): <p>Describes the site-to-site attachment.</p>
    /// - On failure, responds with [`SdkError<GetSiteToSiteVpnAttachmentError>`](crate::error::GetSiteToSiteVpnAttachmentError)
    pub fn get_site_to_site_vpn_attachment(&self) -> fluent_builders::GetSiteToSiteVpnAttachment {
        fluent_builders::GetSiteToSiteVpnAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTransitGatewayConnectPeerAssociations`](crate::client::fluent_builders::GetTransitGatewayConnectPeerAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetTransitGatewayConnectPeerAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::GetTransitGatewayConnectPeerAssociations::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::GetTransitGatewayConnectPeerAssociations::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`transit_gateway_connect_peer_arns(Vec<String>)`](crate::client::fluent_builders::GetTransitGatewayConnectPeerAssociations::transit_gateway_connect_peer_arns) / [`set_transit_gateway_connect_peer_arns(Option<Vec<String>>)`](crate::client::fluent_builders::GetTransitGatewayConnectPeerAssociations::set_transit_gateway_connect_peer_arns): <p>One or more transit gateway Connect peer Amazon Resource Names (ARNs).</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetTransitGatewayConnectPeerAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetTransitGatewayConnectPeerAssociations::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetTransitGatewayConnectPeerAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetTransitGatewayConnectPeerAssociations::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`GetTransitGatewayConnectPeerAssociationsOutput`](crate::output::GetTransitGatewayConnectPeerAssociationsOutput) with field(s):
    ///   - [`transit_gateway_connect_peer_associations(Option<Vec<TransitGatewayConnectPeerAssociation>>)`](crate::output::GetTransitGatewayConnectPeerAssociationsOutput::transit_gateway_connect_peer_associations): <p>Information about the transit gateway Connect peer associations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetTransitGatewayConnectPeerAssociationsOutput::next_token): <p>The token to use for the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetTransitGatewayConnectPeerAssociationsError>`](crate::error::GetTransitGatewayConnectPeerAssociationsError)
    pub fn get_transit_gateway_connect_peer_associations(
        &self,
    ) -> fluent_builders::GetTransitGatewayConnectPeerAssociations {
        fluent_builders::GetTransitGatewayConnectPeerAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTransitGatewayRegistrations`](crate::client::fluent_builders::GetTransitGatewayRegistrations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetTransitGatewayRegistrations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::GetTransitGatewayRegistrations::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::GetTransitGatewayRegistrations::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`transit_gateway_arns(Vec<String>)`](crate::client::fluent_builders::GetTransitGatewayRegistrations::transit_gateway_arns) / [`set_transit_gateway_arns(Option<Vec<String>>)`](crate::client::fluent_builders::GetTransitGatewayRegistrations::set_transit_gateway_arns): <p>The Amazon Resource Names (ARNs) of one or more transit gateways. The maximum is 10.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetTransitGatewayRegistrations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetTransitGatewayRegistrations::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetTransitGatewayRegistrations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetTransitGatewayRegistrations::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`GetTransitGatewayRegistrationsOutput`](crate::output::GetTransitGatewayRegistrationsOutput) with field(s):
    ///   - [`transit_gateway_registrations(Option<Vec<TransitGatewayRegistration>>)`](crate::output::GetTransitGatewayRegistrationsOutput::transit_gateway_registrations): <p>The transit gateway registrations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetTransitGatewayRegistrationsOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetTransitGatewayRegistrationsError>`](crate::error::GetTransitGatewayRegistrationsError)
    pub fn get_transit_gateway_registrations(
        &self,
    ) -> fluent_builders::GetTransitGatewayRegistrations {
        fluent_builders::GetTransitGatewayRegistrations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetVpcAttachment`](crate::client::fluent_builders::GetVpcAttachment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attachment_id(impl Into<String>)`](crate::client::fluent_builders::GetVpcAttachment::attachment_id) / [`set_attachment_id(Option<String>)`](crate::client::fluent_builders::GetVpcAttachment::set_attachment_id): <p>The ID of the attachment.</p>
    /// - On success, responds with [`GetVpcAttachmentOutput`](crate::output::GetVpcAttachmentOutput) with field(s):
    ///   - [`vpc_attachment(Option<VpcAttachment>)`](crate::output::GetVpcAttachmentOutput::vpc_attachment): <p>Returns details about a VPC attachment.</p>
    /// - On failure, responds with [`SdkError<GetVpcAttachmentError>`](crate::error::GetVpcAttachmentError)
    pub fn get_vpc_attachment(&self) -> fluent_builders::GetVpcAttachment {
        fluent_builders::GetVpcAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAttachments`](crate::client::fluent_builders::ListAttachments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAttachments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_network_id(impl Into<String>)`](crate::client::fluent_builders::ListAttachments::core_network_id) / [`set_core_network_id(Option<String>)`](crate::client::fluent_builders::ListAttachments::set_core_network_id): <p>The ID of a core network.</p>
    ///   - [`attachment_type(AttachmentType)`](crate::client::fluent_builders::ListAttachments::attachment_type) / [`set_attachment_type(Option<AttachmentType>)`](crate::client::fluent_builders::ListAttachments::set_attachment_type): <p>The type of attachment.</p>
    ///   - [`edge_location(impl Into<String>)`](crate::client::fluent_builders::ListAttachments::edge_location) / [`set_edge_location(Option<String>)`](crate::client::fluent_builders::ListAttachments::set_edge_location): <p>The Region where the edge is located.</p>
    ///   - [`state(AttachmentState)`](crate::client::fluent_builders::ListAttachments::state) / [`set_state(Option<AttachmentState>)`](crate::client::fluent_builders::ListAttachments::set_state): <p>The state of the attachment.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAttachments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAttachments::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAttachments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAttachments::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`ListAttachmentsOutput`](crate::output::ListAttachmentsOutput) with field(s):
    ///   - [`attachments(Option<Vec<Attachment>>)`](crate::output::ListAttachmentsOutput::attachments): <p>Describes the list of attachments.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAttachmentsOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListAttachmentsError>`](crate::error::ListAttachmentsError)
    pub fn list_attachments(&self) -> fluent_builders::ListAttachments {
        fluent_builders::ListAttachments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListConnectPeers`](crate::client::fluent_builders::ListConnectPeers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListConnectPeers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_network_id(impl Into<String>)`](crate::client::fluent_builders::ListConnectPeers::core_network_id) / [`set_core_network_id(Option<String>)`](crate::client::fluent_builders::ListConnectPeers::set_core_network_id): <p>The ID of a core network.</p>
    ///   - [`connect_attachment_id(impl Into<String>)`](crate::client::fluent_builders::ListConnectPeers::connect_attachment_id) / [`set_connect_attachment_id(Option<String>)`](crate::client::fluent_builders::ListConnectPeers::set_connect_attachment_id): <p>The ID of the attachment.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListConnectPeers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListConnectPeers::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListConnectPeers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListConnectPeers::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`ListConnectPeersOutput`](crate::output::ListConnectPeersOutput) with field(s):
    ///   - [`connect_peers(Option<Vec<ConnectPeerSummary>>)`](crate::output::ListConnectPeersOutput::connect_peers): <p>Describes the Connect peers.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListConnectPeersOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListConnectPeersError>`](crate::error::ListConnectPeersError)
    pub fn list_connect_peers(&self) -> fluent_builders::ListConnectPeers {
        fluent_builders::ListConnectPeers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCoreNetworkPolicyVersions`](crate::client::fluent_builders::ListCoreNetworkPolicyVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCoreNetworkPolicyVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_network_id(impl Into<String>)`](crate::client::fluent_builders::ListCoreNetworkPolicyVersions::core_network_id) / [`set_core_network_id(Option<String>)`](crate::client::fluent_builders::ListCoreNetworkPolicyVersions::set_core_network_id): <p>The ID of a core network.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCoreNetworkPolicyVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCoreNetworkPolicyVersions::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCoreNetworkPolicyVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCoreNetworkPolicyVersions::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`ListCoreNetworkPolicyVersionsOutput`](crate::output::ListCoreNetworkPolicyVersionsOutput) with field(s):
    ///   - [`core_network_policy_versions(Option<Vec<CoreNetworkPolicyVersion>>)`](crate::output::ListCoreNetworkPolicyVersionsOutput::core_network_policy_versions): <p>Describes core network policy versions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCoreNetworkPolicyVersionsOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListCoreNetworkPolicyVersionsError>`](crate::error::ListCoreNetworkPolicyVersionsError)
    pub fn list_core_network_policy_versions(
        &self,
    ) -> fluent_builders::ListCoreNetworkPolicyVersions {
        fluent_builders::ListCoreNetworkPolicyVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCoreNetworks`](crate::client::fluent_builders::ListCoreNetworks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCoreNetworks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCoreNetworks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCoreNetworks::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCoreNetworks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCoreNetworks::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`ListCoreNetworksOutput`](crate::output::ListCoreNetworksOutput) with field(s):
    ///   - [`core_networks(Option<Vec<CoreNetworkSummary>>)`](crate::output::ListCoreNetworksOutput::core_networks): <p>Describes the list of core networks.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCoreNetworksOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListCoreNetworksError>`](crate::error::ListCoreNetworksError)
    pub fn list_core_networks(&self) -> fluent_builders::ListCoreNetworks {
        fluent_builders::ListCoreNetworks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tag_list): <p>The list of tags.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutCoreNetworkPolicy`](crate::client::fluent_builders::PutCoreNetworkPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_network_id(impl Into<String>)`](crate::client::fluent_builders::PutCoreNetworkPolicy::core_network_id) / [`set_core_network_id(Option<String>)`](crate::client::fluent_builders::PutCoreNetworkPolicy::set_core_network_id): <p>The ID of a core network.</p>
    ///   - [`policy_document(impl Into<String>)`](crate::client::fluent_builders::PutCoreNetworkPolicy::policy_document) / [`set_policy_document(Option<String>)`](crate::client::fluent_builders::PutCoreNetworkPolicy::set_policy_document): <p>The policy document.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::PutCoreNetworkPolicy::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::PutCoreNetworkPolicy::set_description): <p>a core network policy description.</p>
    ///   - [`latest_version_id(i32)`](crate::client::fluent_builders::PutCoreNetworkPolicy::latest_version_id) / [`set_latest_version_id(Option<i32>)`](crate::client::fluent_builders::PutCoreNetworkPolicy::set_latest_version_id): <p>The ID of a core network policy. </p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::PutCoreNetworkPolicy::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::PutCoreNetworkPolicy::set_client_token): <p>The client token associated with the request.</p>
    /// - On success, responds with [`PutCoreNetworkPolicyOutput`](crate::output::PutCoreNetworkPolicyOutput) with field(s):
    ///   - [`core_network_policy(Option<CoreNetworkPolicy>)`](crate::output::PutCoreNetworkPolicyOutput::core_network_policy): <p>Describes the changed core network policy.</p>
    /// - On failure, responds with [`SdkError<PutCoreNetworkPolicyError>`](crate::error::PutCoreNetworkPolicyError)
    pub fn put_core_network_policy(&self) -> fluent_builders::PutCoreNetworkPolicy {
        fluent_builders::PutCoreNetworkPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutResourcePolicy`](crate::client::fluent_builders::PutResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_document(impl Into<String>)`](crate::client::fluent_builders::PutResourcePolicy::policy_document) / [`set_policy_document(Option<String>)`](crate::client::fluent_builders::PutResourcePolicy::set_policy_document): <p>The JSON resource policy document.</p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::PutResourcePolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::PutResourcePolicy::set_resource_arn): <p>The ARN of the resource policy. </p>
    /// - On success, responds with [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)

    /// - On failure, responds with [`SdkError<PutResourcePolicyError>`](crate::error::PutResourcePolicyError)
    pub fn put_resource_policy(&self) -> fluent_builders::PutResourcePolicy {
        fluent_builders::PutResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterTransitGateway`](crate::client::fluent_builders::RegisterTransitGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::RegisterTransitGateway::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::RegisterTransitGateway::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`transit_gateway_arn(impl Into<String>)`](crate::client::fluent_builders::RegisterTransitGateway::transit_gateway_arn) / [`set_transit_gateway_arn(Option<String>)`](crate::client::fluent_builders::RegisterTransitGateway::set_transit_gateway_arn): <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
    /// - On success, responds with [`RegisterTransitGatewayOutput`](crate::output::RegisterTransitGatewayOutput) with field(s):
    ///   - [`transit_gateway_registration(Option<TransitGatewayRegistration>)`](crate::output::RegisterTransitGatewayOutput::transit_gateway_registration): <p>Information about the transit gateway registration.</p>
    /// - On failure, responds with [`SdkError<RegisterTransitGatewayError>`](crate::error::RegisterTransitGatewayError)
    pub fn register_transit_gateway(&self) -> fluent_builders::RegisterTransitGateway {
        fluent_builders::RegisterTransitGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RejectAttachment`](crate::client::fluent_builders::RejectAttachment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attachment_id(impl Into<String>)`](crate::client::fluent_builders::RejectAttachment::attachment_id) / [`set_attachment_id(Option<String>)`](crate::client::fluent_builders::RejectAttachment::set_attachment_id): <p>The ID of the attachment.</p>
    /// - On success, responds with [`RejectAttachmentOutput`](crate::output::RejectAttachmentOutput) with field(s):
    ///   - [`attachment(Option<Attachment>)`](crate::output::RejectAttachmentOutput::attachment): <p>Describes the rejected attachment request.</p>
    /// - On failure, responds with [`SdkError<RejectAttachmentError>`](crate::error::RejectAttachmentError)
    pub fn reject_attachment(&self) -> fluent_builders::RejectAttachment {
        fluent_builders::RejectAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreCoreNetworkPolicyVersion`](crate::client::fluent_builders::RestoreCoreNetworkPolicyVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_network_id(impl Into<String>)`](crate::client::fluent_builders::RestoreCoreNetworkPolicyVersion::core_network_id) / [`set_core_network_id(Option<String>)`](crate::client::fluent_builders::RestoreCoreNetworkPolicyVersion::set_core_network_id): <p>The ID of a core network.</p>
    ///   - [`policy_version_id(i32)`](crate::client::fluent_builders::RestoreCoreNetworkPolicyVersion::policy_version_id) / [`set_policy_version_id(Option<i32>)`](crate::client::fluent_builders::RestoreCoreNetworkPolicyVersion::set_policy_version_id): <p>The ID of the policy version to restore.</p>
    /// - On success, responds with [`RestoreCoreNetworkPolicyVersionOutput`](crate::output::RestoreCoreNetworkPolicyVersionOutput) with field(s):
    ///   - [`core_network_policy(Option<CoreNetworkPolicy>)`](crate::output::RestoreCoreNetworkPolicyVersionOutput::core_network_policy): <p>Describes the restored core network policy.</p>
    /// - On failure, responds with [`SdkError<RestoreCoreNetworkPolicyVersionError>`](crate::error::RestoreCoreNetworkPolicyVersionError)
    pub fn restore_core_network_policy_version(
        &self,
    ) -> fluent_builders::RestoreCoreNetworkPolicyVersion {
        fluent_builders::RestoreCoreNetworkPolicyVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartRouteAnalysis`](crate::client::fluent_builders::StartRouteAnalysis) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::StartRouteAnalysis::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::StartRouteAnalysis::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`source(RouteAnalysisEndpointOptionsSpecification)`](crate::client::fluent_builders::StartRouteAnalysis::source) / [`set_source(Option<RouteAnalysisEndpointOptionsSpecification>)`](crate::client::fluent_builders::StartRouteAnalysis::set_source): <p>The source from which traffic originates.</p>
    ///   - [`destination(RouteAnalysisEndpointOptionsSpecification)`](crate::client::fluent_builders::StartRouteAnalysis::destination) / [`set_destination(Option<RouteAnalysisEndpointOptionsSpecification>)`](crate::client::fluent_builders::StartRouteAnalysis::set_destination): <p>The destination.</p>
    ///   - [`include_return_path(bool)`](crate::client::fluent_builders::StartRouteAnalysis::include_return_path) / [`set_include_return_path(bool)`](crate::client::fluent_builders::StartRouteAnalysis::set_include_return_path): <p>Indicates whether to analyze the return path. The default is <code>false</code>.</p>
    ///   - [`use_middleboxes(bool)`](crate::client::fluent_builders::StartRouteAnalysis::use_middleboxes) / [`set_use_middleboxes(bool)`](crate::client::fluent_builders::StartRouteAnalysis::set_use_middleboxes): <p>Indicates whether to include the location of middlebox appliances in the route analysis. The default is <code>false</code>.</p>
    /// - On success, responds with [`StartRouteAnalysisOutput`](crate::output::StartRouteAnalysisOutput) with field(s):
    ///   - [`route_analysis(Option<RouteAnalysis>)`](crate::output::StartRouteAnalysisOutput::route_analysis): <p>The route analysis.</p>
    /// - On failure, responds with [`SdkError<StartRouteAnalysisError>`](crate::error::StartRouteAnalysisError)
    pub fn start_route_analysis(&self) -> fluent_builders::StartRouteAnalysis {
        fluent_builders::StartRouteAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to apply to the specified resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys to remove from the specified resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConnection`](crate::client::fluent_builders::UpdateConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::UpdateConnection::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::UpdateConnection::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::UpdateConnection::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::UpdateConnection::set_connection_id): <p>The ID of the connection.</p>
    ///   - [`link_id(impl Into<String>)`](crate::client::fluent_builders::UpdateConnection::link_id) / [`set_link_id(Option<String>)`](crate::client::fluent_builders::UpdateConnection::set_link_id): <p>The ID of the link for the first device in the connection.</p>
    ///   - [`connected_link_id(impl Into<String>)`](crate::client::fluent_builders::UpdateConnection::connected_link_id) / [`set_connected_link_id(Option<String>)`](crate::client::fluent_builders::UpdateConnection::set_connected_link_id): <p>The ID of the link for the second device in the connection.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateConnection::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateConnection::set_description): <p>A description of the connection.</p>  <p>Length Constraints: Maximum length of 256 characters.</p>
    /// - On success, responds with [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput) with field(s):
    ///   - [`connection(Option<Connection>)`](crate::output::UpdateConnectionOutput::connection): <p>Information about the connection.</p>
    /// - On failure, responds with [`SdkError<UpdateConnectionError>`](crate::error::UpdateConnectionError)
    pub fn update_connection(&self) -> fluent_builders::UpdateConnection {
        fluent_builders::UpdateConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCoreNetwork`](crate::client::fluent_builders::UpdateCoreNetwork) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_network_id(impl Into<String>)`](crate::client::fluent_builders::UpdateCoreNetwork::core_network_id) / [`set_core_network_id(Option<String>)`](crate::client::fluent_builders::UpdateCoreNetwork::set_core_network_id): <p>The ID of a core network.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateCoreNetwork::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateCoreNetwork::set_description): <p>The description of the update.</p>
    /// - On success, responds with [`UpdateCoreNetworkOutput`](crate::output::UpdateCoreNetworkOutput) with field(s):
    ///   - [`core_network(Option<CoreNetwork>)`](crate::output::UpdateCoreNetworkOutput::core_network): <p>Returns information about a core network update.</p>
    /// - On failure, responds with [`SdkError<UpdateCoreNetworkError>`](crate::error::UpdateCoreNetworkError)
    pub fn update_core_network(&self) -> fluent_builders::UpdateCoreNetwork {
        fluent_builders::UpdateCoreNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDevice`](crate::client::fluent_builders::UpdateDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDevice::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::UpdateDevice::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDevice::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::UpdateDevice::set_device_id): <p>The ID of the device.</p>
    ///   - [`aws_location(AwsLocation)`](crate::client::fluent_builders::UpdateDevice::aws_location) / [`set_aws_location(Option<AwsLocation>)`](crate::client::fluent_builders::UpdateDevice::set_aws_location): <p>The Amazon Web Services location of the device, if applicable. For an on-premises device, you can omit this parameter.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateDevice::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateDevice::set_description): <p>A description of the device.</p>  <p>Constraints: Maximum length of 256 characters.</p>
    ///   - [`r#type(impl Into<String>)`](crate::client::fluent_builders::UpdateDevice::type) / [`set_type(Option<String>)`](crate::client::fluent_builders::UpdateDevice::set_type): <p>The type of the device.</p>
    ///   - [`vendor(impl Into<String>)`](crate::client::fluent_builders::UpdateDevice::vendor) / [`set_vendor(Option<String>)`](crate::client::fluent_builders::UpdateDevice::set_vendor): <p>The vendor of the device.</p>  <p>Constraints: Maximum length of 128 characters.</p>
    ///   - [`model(impl Into<String>)`](crate::client::fluent_builders::UpdateDevice::model) / [`set_model(Option<String>)`](crate::client::fluent_builders::UpdateDevice::set_model): <p>The model of the device.</p>  <p>Constraints: Maximum length of 128 characters.</p>
    ///   - [`serial_number(impl Into<String>)`](crate::client::fluent_builders::UpdateDevice::serial_number) / [`set_serial_number(Option<String>)`](crate::client::fluent_builders::UpdateDevice::set_serial_number): <p>The serial number of the device.</p>  <p>Constraints: Maximum length of 128 characters.</p>
    ///   - [`location(Location)`](crate::client::fluent_builders::UpdateDevice::location) / [`set_location(Option<Location>)`](crate::client::fluent_builders::UpdateDevice::set_location): <p>Describes a location.</p>
    ///   - [`site_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDevice::site_id) / [`set_site_id(Option<String>)`](crate::client::fluent_builders::UpdateDevice::set_site_id): <p>The ID of the site.</p>
    /// - On success, responds with [`UpdateDeviceOutput`](crate::output::UpdateDeviceOutput) with field(s):
    ///   - [`device(Option<Device>)`](crate::output::UpdateDeviceOutput::device): <p>Information about the device.</p>
    /// - On failure, responds with [`SdkError<UpdateDeviceError>`](crate::error::UpdateDeviceError)
    pub fn update_device(&self) -> fluent_builders::UpdateDevice {
        fluent_builders::UpdateDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGlobalNetwork`](crate::client::fluent_builders::UpdateGlobalNetwork) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::UpdateGlobalNetwork::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::UpdateGlobalNetwork::set_global_network_id): <p>The ID of your global network.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateGlobalNetwork::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateGlobalNetwork::set_description): <p>A description of the global network.</p>  <p>Constraints: Maximum length of 256 characters.</p>
    /// - On success, responds with [`UpdateGlobalNetworkOutput`](crate::output::UpdateGlobalNetworkOutput) with field(s):
    ///   - [`global_network(Option<GlobalNetwork>)`](crate::output::UpdateGlobalNetworkOutput::global_network): <p>Information about the global network object.</p>
    /// - On failure, responds with [`SdkError<UpdateGlobalNetworkError>`](crate::error::UpdateGlobalNetworkError)
    pub fn update_global_network(&self) -> fluent_builders::UpdateGlobalNetwork {
        fluent_builders::UpdateGlobalNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLink`](crate::client::fluent_builders::UpdateLink) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::UpdateLink::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::UpdateLink::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`link_id(impl Into<String>)`](crate::client::fluent_builders::UpdateLink::link_id) / [`set_link_id(Option<String>)`](crate::client::fluent_builders::UpdateLink::set_link_id): <p>The ID of the link.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateLink::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateLink::set_description): <p>A description of the link.</p>  <p>Constraints: Maximum length of 256 characters.</p>
    ///   - [`r#type(impl Into<String>)`](crate::client::fluent_builders::UpdateLink::type) / [`set_type(Option<String>)`](crate::client::fluent_builders::UpdateLink::set_type): <p>The type of the link.</p>  <p>Constraints: Maximum length of 128 characters.</p>
    ///   - [`bandwidth(Bandwidth)`](crate::client::fluent_builders::UpdateLink::bandwidth) / [`set_bandwidth(Option<Bandwidth>)`](crate::client::fluent_builders::UpdateLink::set_bandwidth): <p>The upload and download speed in Mbps. </p>
    ///   - [`provider(impl Into<String>)`](crate::client::fluent_builders::UpdateLink::provider) / [`set_provider(Option<String>)`](crate::client::fluent_builders::UpdateLink::set_provider): <p>The provider of the link.</p>  <p>Constraints: Maximum length of 128 characters.</p>
    /// - On success, responds with [`UpdateLinkOutput`](crate::output::UpdateLinkOutput) with field(s):
    ///   - [`link(Option<Link>)`](crate::output::UpdateLinkOutput::link): <p>Information about the link.</p>
    /// - On failure, responds with [`SdkError<UpdateLinkError>`](crate::error::UpdateLinkError)
    pub fn update_link(&self) -> fluent_builders::UpdateLink {
        fluent_builders::UpdateLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateNetworkResourceMetadata`](crate::client::fluent_builders::UpdateNetworkResourceMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::UpdateNetworkResourceMetadata::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::UpdateNetworkResourceMetadata::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateNetworkResourceMetadata::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UpdateNetworkResourceMetadata::set_resource_arn): <p>The ARN of the resource.</p>
    ///   - [`metadata(HashMap<String, String>)`](crate::client::fluent_builders::UpdateNetworkResourceMetadata::metadata) / [`set_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateNetworkResourceMetadata::set_metadata): <p>The resource metadata.</p>
    /// - On success, responds with [`UpdateNetworkResourceMetadataOutput`](crate::output::UpdateNetworkResourceMetadataOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::UpdateNetworkResourceMetadataOutput::resource_arn): <p>The ARN of the resource.</p>
    ///   - [`metadata(Option<HashMap<String, String>>)`](crate::output::UpdateNetworkResourceMetadataOutput::metadata): <p>The updated resource metadata.</p>
    /// - On failure, responds with [`SdkError<UpdateNetworkResourceMetadataError>`](crate::error::UpdateNetworkResourceMetadataError)
    pub fn update_network_resource_metadata(
        &self,
    ) -> fluent_builders::UpdateNetworkResourceMetadata {
        fluent_builders::UpdateNetworkResourceMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSite`](crate::client::fluent_builders::UpdateSite) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_network_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSite::global_network_id) / [`set_global_network_id(Option<String>)`](crate::client::fluent_builders::UpdateSite::set_global_network_id): <p>The ID of the global network.</p>
    ///   - [`site_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSite::site_id) / [`set_site_id(Option<String>)`](crate::client::fluent_builders::UpdateSite::set_site_id): <p>The ID of your site.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateSite::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateSite::set_description): <p>A description of your site.</p>  <p>Constraints: Maximum length of 256 characters.</p>
    ///   - [`location(Location)`](crate::client::fluent_builders::UpdateSite::location) / [`set_location(Option<Location>)`](crate::client::fluent_builders::UpdateSite::set_location): <p>The site location:</p>  <ul>   <li> <p> <code>Address</code>: The physical address of the site.</p> </li>   <li> <p> <code>Latitude</code>: The latitude of the site. </p> </li>   <li> <p> <code>Longitude</code>: The longitude of the site.</p> </li>  </ul>
    /// - On success, responds with [`UpdateSiteOutput`](crate::output::UpdateSiteOutput) with field(s):
    ///   - [`site(Option<Site>)`](crate::output::UpdateSiteOutput::site): <p>Information about the site.</p>
    /// - On failure, responds with [`SdkError<UpdateSiteError>`](crate::error::UpdateSiteError)
    pub fn update_site(&self) -> fluent_builders::UpdateSite {
        fluent_builders::UpdateSite::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateVpcAttachment`](crate::client::fluent_builders::UpdateVpcAttachment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attachment_id(impl Into<String>)`](crate::client::fluent_builders::UpdateVpcAttachment::attachment_id) / [`set_attachment_id(Option<String>)`](crate::client::fluent_builders::UpdateVpcAttachment::set_attachment_id): <p>The ID of the attachment.</p>
    ///   - [`add_subnet_arns(Vec<String>)`](crate::client::fluent_builders::UpdateVpcAttachment::add_subnet_arns) / [`set_add_subnet_arns(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateVpcAttachment::set_add_subnet_arns): <p>Adds a subnet ARN to the VPC attachment.</p>
    ///   - [`remove_subnet_arns(Vec<String>)`](crate::client::fluent_builders::UpdateVpcAttachment::remove_subnet_arns) / [`set_remove_subnet_arns(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateVpcAttachment::set_remove_subnet_arns): <p>Removes a subnet ARN from the attachment.</p>
    ///   - [`options(VpcOptions)`](crate::client::fluent_builders::UpdateVpcAttachment::options) / [`set_options(Option<VpcOptions>)`](crate::client::fluent_builders::UpdateVpcAttachment::set_options): <p>Additional options for updating the VPC attachment. </p>
    /// - On success, responds with [`UpdateVpcAttachmentOutput`](crate::output::UpdateVpcAttachmentOutput) with field(s):
    ///   - [`vpc_attachment(Option<VpcAttachment>)`](crate::output::UpdateVpcAttachmentOutput::vpc_attachment): <p>Describes the updated VPC attachment.</p>
    /// - On failure, responds with [`SdkError<UpdateVpcAttachmentError>`](crate::error::UpdateVpcAttachmentError)
    pub fn update_vpc_attachment(&self) -> fluent_builders::UpdateVpcAttachment {
        fluent_builders::UpdateVpcAttachment::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptAttachment`.
    ///
    /// <p>Accepts a core network attachment request. </p>
    /// <p>Once the attachment request is accepted by a core network owner, the attachment is created and connected to a core network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptAttachment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::accept_attachment_input::Builder,
    }
    impl AcceptAttachment {
        /// Creates a new `AcceptAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptAttachmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the attachment. </p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment. </p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateConnectPeer`.
    ///
    /// <p>Associates a core network Connect peer with a device and optionally, with a link. </p>
    /// <p>If you specify a link, it must be associated with the specified device. You can only associate core network Connect peers that have been created on a core network Connect attachment on a core network. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateConnectPeer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_connect_peer_input::Builder,
    }
    impl AssociateConnectPeer {
        /// Creates a new `AssociateConnectPeer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateConnectPeerOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateConnectPeerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of your global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of your global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the Connect peer.</p>
        pub fn connect_peer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connect_peer_id(input.into());
            self
        }
        /// <p>The ID of the Connect peer.</p>
        pub fn set_connect_peer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connect_peer_id(input);
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateCustomerGateway`.
    ///
    /// <p>Associates a customer gateway with a device and optionally, with a link. If you specify a link, it must be associated with the specified device. </p>
    /// <p>You can only associate customer gateways that are connected to a VPN attachment on a transit gateway. The transit gateway must be registered in your global network. When you register a transit gateway, customer gateways that are connected to the transit gateway are automatically included in the global network. To list customer gateways that are connected to a transit gateway, use the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnConnections.html">DescribeVpnConnections</a> EC2 API and filter by <code>transit-gateway-id</code>.</p>
    /// <p>You cannot associate a customer gateway with more than one device and link. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateCustomerGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_customer_gateway_input::Builder,
    }
    impl AssociateCustomerGateway {
        /// Creates a new `AssociateCustomerGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateCustomerGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateCustomerGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the customer gateway.</p>
        pub fn customer_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.customer_gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer gateway.</p>
        pub fn set_customer_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_customer_gateway_arn(input);
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateLink`.
    ///
    /// <p>Associates a link to a device. A device can be associated to multiple links and a link can be associated to multiple devices. The device and link must be in the same global network and the same site.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateLink {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_link_input::Builder,
    }
    impl AssociateLink {
        /// Creates a new `AssociateLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateLinkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateTransitGatewayConnectPeer`.
    ///
    /// <p>Associates a transit gateway Connect peer with a device, and optionally, with a link. If you specify a link, it must be associated with the specified device. </p>
    /// <p>You can only associate transit gateway Connect peers that have been created on a transit gateway that's registered in your global network.</p>
    /// <p>You cannot associate a transit gateway Connect peer with more than one device and link. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateTransitGatewayConnectPeer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_transit_gateway_connect_peer_input::Builder,
    }
    impl AssociateTransitGatewayConnectPeer {
        /// Creates a new `AssociateTransitGatewayConnectPeer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateTransitGatewayConnectPeerOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateTransitGatewayConnectPeerError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Connect peer.</p>
        pub fn transit_gateway_connect_peer_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.transit_gateway_connect_peer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Connect peer.</p>
        pub fn set_transit_gateway_connect_peer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_connect_peer_arn(input);
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConnectAttachment`.
    ///
    /// <p>Creates a core network Connect attachment from a specified core network attachment. </p>
    /// <p>A core network Connect attachment is a GRE-based tunnel attachment that you can use to establish a connection between a core network and an appliance. A core network Connect attachment uses an existing VPC attachment as the underlying transport mechanism.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConnectAttachment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_connect_attachment_input::Builder,
    }
    impl CreateConnectAttachment {
        /// Creates a new `CreateConnectAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectAttachmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network where you want to create the attachment. </p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network where you want to create the attachment. </p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The Region where the edge is located.</p>
        pub fn edge_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.edge_location(input.into());
            self
        }
        /// <p>The Region where the edge is located.</p>
        pub fn set_edge_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_edge_location(input);
            self
        }
        /// <p>The ID of the attachment between the two connections.</p>
        pub fn transport_attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transport_attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment between the two connections.</p>
        pub fn set_transport_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transport_attachment_id(input);
            self
        }
        /// <p>Options for creating an attachment.</p>
        pub fn options(mut self, input: crate::model::ConnectAttachmentOptions) -> Self {
            self.inner = self.inner.options(input);
            self
        }
        /// <p>Options for creating an attachment.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<crate::model::ConnectAttachmentOptions>,
        ) -> Self {
            self.inner = self.inner.set_options(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of key-value tags associated with the request.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The list of key-value tags associated with the request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConnection`.
    ///
    /// <p>Creates a connection between two devices. The devices can be a physical or virtual appliance that connects to a third-party appliance in a VPC, or a physical appliance that connects to another physical appliance in an on-premises network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_connection_input::Builder,
    }
    impl CreateConnection {
        /// Creates a new `CreateConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the first device in the connection.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the first device in the connection.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The ID of the second device in the connection.</p>
        pub fn connected_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connected_device_id(input.into());
            self
        }
        /// <p>The ID of the second device in the connection.</p>
        pub fn set_connected_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connected_device_id(input);
            self
        }
        /// <p>The ID of the link for the first device.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link for the first device.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
        /// <p>The ID of the link for the second device.</p>
        pub fn connected_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connected_link_id(input.into());
            self
        }
        /// <p>The ID of the link for the second device.</p>
        pub fn set_connected_link_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connected_link_id(input);
            self
        }
        /// <p>A description of the connection.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the connection.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConnectPeer`.
    ///
    /// <p>Creates a core network connect peer for a specified core network connect attachment between a core network and an appliance. The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConnectPeer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_connect_peer_input::Builder,
    }
    impl CreateConnectPeer {
        /// Creates a new `CreateConnectPeer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectPeerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectPeerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection attachment.</p>
        pub fn connect_attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connect_attachment_id(input.into());
            self
        }
        /// <p>The ID of the connection attachment.</p>
        pub fn set_connect_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connect_attachment_id(input);
            self
        }
        /// <p>A Connect peer core network address.</p>
        pub fn core_network_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_address(input.into());
            self
        }
        /// <p>A Connect peer core network address.</p>
        pub fn set_core_network_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_address(input);
            self
        }
        /// <p>The Connect peer address.</p>
        pub fn peer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.peer_address(input.into());
            self
        }
        /// <p>The Connect peer address.</p>
        pub fn set_peer_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_peer_address(input);
            self
        }
        /// <p>The Connect peer BGP options.</p>
        pub fn bgp_options(mut self, input: crate::model::BgpOptions) -> Self {
            self.inner = self.inner.bgp_options(input);
            self
        }
        /// <p>The Connect peer BGP options.</p>
        pub fn set_bgp_options(
            mut self,
            input: std::option::Option<crate::model::BgpOptions>,
        ) -> Self {
            self.inner = self.inner.set_bgp_options(input);
            self
        }
        /// Appends an item to `InsideCidrBlocks`.
        ///
        /// To override the contents of this collection use [`set_inside_cidr_blocks`](Self::set_inside_cidr_blocks).
        ///
        /// <p>The inside IP addresses used for BGP peering.</p>
        pub fn inside_cidr_blocks(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.inside_cidr_blocks(input.into());
            self
        }
        /// <p>The inside IP addresses used for BGP peering.</p>
        pub fn set_inside_cidr_blocks(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_inside_cidr_blocks(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the peer request.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags associated with the peer request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCoreNetwork`.
    ///
    /// <p>Creates a core network as part of your global network, and optionally, with a core network policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCoreNetwork {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_core_network_input::Builder,
    }
    impl CreateCoreNetwork {
        /// Creates a new `CreateCoreNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCoreNetworkOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCoreNetworkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network that a core network will be a part of. </p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network that a core network will be a part of. </p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The description of a core network.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of a core network.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value tags associated with a core network request.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Key-value tags associated with a core network request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The policy document for creating a core network.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(input.into());
            self
        }
        /// <p>The policy document for creating a core network.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
        /// <p>The client token associated with a core network request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The client token associated with a core network request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDevice`.
    ///
    /// <p>Creates a new device in a global network. If you specify both a site ID and a location, the location of the site is used for visualization in the Network Manager console.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDevice {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_device_input::Builder,
    }
    impl CreateDevice {
        /// Creates a new `CreateDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeviceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The Amazon Web Services location of the device, if applicable. For an on-premises device, you can omit this parameter.</p>
        pub fn aws_location(mut self, input: crate::model::AwsLocation) -> Self {
            self.inner = self.inner.aws_location(input);
            self
        }
        /// <p>The Amazon Web Services location of the device, if applicable. For an on-premises device, you can omit this parameter.</p>
        pub fn set_aws_location(
            mut self,
            input: std::option::Option<crate::model::AwsLocation>,
        ) -> Self {
            self.inner = self.inner.set_aws_location(input);
            self
        }
        /// <p>A description of the device.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the device.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The type of the device.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.r#type(input.into());
            self
        }
        /// <p>The type of the device.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The vendor of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn vendor(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vendor(input.into());
            self
        }
        /// <p>The vendor of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn set_vendor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vendor(input);
            self
        }
        /// <p>The model of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn model(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model(input.into());
            self
        }
        /// <p>The model of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn set_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model(input);
            self
        }
        /// <p>The serial number of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.serial_number(input.into());
            self
        }
        /// <p>The serial number of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_serial_number(input);
            self
        }
        /// <p>The location of the device.</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.inner = self.inner.location(input);
            self
        }
        /// <p>The location of the device.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGlobalNetwork`.
    ///
    /// <p>Creates a new, empty global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGlobalNetwork {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_global_network_input::Builder,
    }
    impl CreateGlobalNetwork {
        /// Creates a new `CreateGlobalNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGlobalNetworkOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGlobalNetworkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A description of the global network.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the global network.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLink`.
    ///
    /// <p>Creates a new link for a specified site.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLink {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_link_input::Builder,
    }
    impl CreateLink {
        /// Creates a new `CreateLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLinkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>A description of the link.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the link.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The type of the link.</p>
        /// <p>Constraints: Maximum length of 128 characters. Cannot include the following characters: | \ ^</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.r#type(input.into());
            self
        }
        /// <p>The type of the link.</p>
        /// <p>Constraints: Maximum length of 128 characters. Cannot include the following characters: | \ ^</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p> The upload speed and download speed in Mbps. </p>
        pub fn bandwidth(mut self, input: crate::model::Bandwidth) -> Self {
            self.inner = self.inner.bandwidth(input);
            self
        }
        /// <p> The upload speed and download speed in Mbps. </p>
        pub fn set_bandwidth(
            mut self,
            input: std::option::Option<crate::model::Bandwidth>,
        ) -> Self {
            self.inner = self.inner.set_bandwidth(input);
            self
        }
        /// <p>The provider of the link.</p>
        /// <p>Constraints: Maximum length of 128 characters. Cannot include the following characters: | \ ^</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider(input.into());
            self
        }
        /// <p>The provider of the link.</p>
        /// <p>Constraints: Maximum length of 128 characters. Cannot include the following characters: | \ ^</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_provider(input);
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSite`.
    ///
    /// <p>Creates a new site in a global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSite {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_site_input::Builder,
    }
    impl CreateSite {
        /// Creates a new `CreateSite`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSiteOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSiteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>A description of your site.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of your site.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The site location. This information is used for visualization in the Network Manager console. If you specify the address, the latitude and longitude are automatically calculated.</p>
        /// <ul>
        /// <li> <p> <code>Address</code>: The physical address of the site.</p> </li>
        /// <li> <p> <code>Latitude</code>: The latitude of the site. </p> </li>
        /// <li> <p> <code>Longitude</code>: The longitude of the site.</p> </li>
        /// </ul>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.inner = self.inner.location(input);
            self
        }
        /// <p>The site location. This information is used for visualization in the Network Manager console. If you specify the address, the latitude and longitude are automatically calculated.</p>
        /// <ul>
        /// <li> <p> <code>Address</code>: The physical address of the site.</p> </li>
        /// <li> <p> <code>Latitude</code>: The latitude of the site. </p> </li>
        /// <li> <p> <code>Longitude</code>: The longitude of the site.</p> </li>
        /// </ul>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSiteToSiteVpnAttachment`.
    ///
    /// <p>Creates a site-to-site VPN attachment on an edge location of a core network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSiteToSiteVpnAttachment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_site_to_site_vpn_attachment_input::Builder,
    }
    impl CreateSiteToSiteVpnAttachment {
        /// Creates a new `CreateSiteToSiteVpnAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSiteToSiteVpnAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSiteToSiteVpnAttachmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network where you're creating a site-to-site VPN attachment.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network where you're creating a site-to-site VPN attachment.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ARN identifying the VPN attachment.</p>
        pub fn vpn_connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpn_connection_arn(input.into());
            self
        }
        /// <p>The ARN identifying the VPN attachment.</p>
        pub fn set_vpn_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpn_connection_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the request.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags associated with the request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVpcAttachment`.
    ///
    /// <p>Creates a VPC attachment on an edge location of a core network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateVpcAttachment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_vpc_attachment_input::Builder,
    }
    impl CreateVpcAttachment {
        /// Creates a new `CreateVpcAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVpcAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVpcAttachmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network for the VPC attachment.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network for the VPC attachment.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ARN of the VPC.</p>
        pub fn vpc_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_arn(input.into());
            self
        }
        /// <p>The ARN of the VPC.</p>
        pub fn set_vpc_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_arn(input);
            self
        }
        /// Appends an item to `SubnetArns`.
        ///
        /// To override the contents of this collection use [`set_subnet_arns`](Self::set_subnet_arns).
        ///
        /// <p>The subnet ARN of the VPC attachment.</p>
        pub fn subnet_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_arns(input.into());
            self
        }
        /// <p>The subnet ARN of the VPC attachment.</p>
        pub fn set_subnet_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_arns(input);
            self
        }
        /// <p>Options for the VPC attachment.</p>
        pub fn options(mut self, input: crate::model::VpcOptions) -> Self {
            self.inner = self.inner.options(input);
            self
        }
        /// <p>Options for the VPC attachment.</p>
        pub fn set_options(mut self, input: std::option::Option<crate::model::VpcOptions>) -> Self {
            self.inner = self.inner.set_options(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value tags associated with the request.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The key-value tags associated with the request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAttachment`.
    ///
    /// <p>Deletes an attachment. Supports all attachment types.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAttachment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_attachment_input::Builder,
    }
    impl DeleteAttachment {
        /// Creates a new `DeleteAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAttachmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the attachment to delete.</p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment to delete.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnection`.
    ///
    /// <p>Deletes the specified connection in your global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_connection_input::Builder,
    }
    impl DeleteConnection {
        /// Creates a new `DeleteConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnectPeer`.
    ///
    /// <p>Deletes a Connect peer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConnectPeer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_connect_peer_input::Builder,
    }
    impl DeleteConnectPeer {
        /// Creates a new `DeleteConnectPeer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectPeerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectPeerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the deleted Connect peer.</p>
        pub fn connect_peer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connect_peer_id(input.into());
            self
        }
        /// <p>The ID of the deleted Connect peer.</p>
        pub fn set_connect_peer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connect_peer_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCoreNetwork`.
    ///
    /// <p>Deletes a core network along with all core network policies. This can only be done if there are no attachments on a core network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCoreNetwork {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_core_network_input::Builder,
    }
    impl DeleteCoreNetwork {
        /// Creates a new `DeleteCoreNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCoreNetworkOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCoreNetworkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The network ID of the deleted core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The network ID of the deleted core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCoreNetworkPolicyVersion`.
    ///
    /// <p>Deletes a policy version from a core network. You can't delete the current LIVE policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCoreNetworkPolicyVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_core_network_policy_version_input::Builder,
    }
    impl DeleteCoreNetworkPolicyVersion {
        /// Creates a new `DeleteCoreNetworkPolicyVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCoreNetworkPolicyVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCoreNetworkPolicyVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network for the deleted policy.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network for the deleted policy.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The version ID of the deleted policy.</p>
        pub fn policy_version_id(mut self, input: i32) -> Self {
            self.inner = self.inner.policy_version_id(input);
            self
        }
        /// <p>The version ID of the deleted policy.</p>
        pub fn set_policy_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_policy_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDevice`.
    ///
    /// <p>Deletes an existing device. You must first disassociate the device from any links and customer gateways.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDevice {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_device_input::Builder,
    }
    impl DeleteDevice {
        /// Creates a new `DeleteDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeviceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGlobalNetwork`.
    ///
    /// <p>Deletes an existing global network. You must first delete all global network objects (devices, links, and sites) and deregister all transit gateways.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGlobalNetwork {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_global_network_input::Builder,
    }
    impl DeleteGlobalNetwork {
        /// Creates a new `DeleteGlobalNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGlobalNetworkOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGlobalNetworkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLink`.
    ///
    /// <p>Deletes an existing link. You must first disassociate the link from any devices and customer gateways.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLink {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_link_input::Builder,
    }
    impl DeleteLink {
        /// Creates a new `DeleteLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLinkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourcePolicy`.
    ///
    /// <p>Deletes a resource policy for the specified resource. This revokes the access of the principals specified in the resource policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_resource_policy_input::Builder,
    }
    impl DeleteResourcePolicy {
        /// Creates a new `DeleteResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the policy to delete.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the policy to delete.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSite`.
    ///
    /// <p>Deletes an existing site. The site cannot be associated with any device or link.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSite {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_site_input::Builder,
    }
    impl DeleteSite {
        /// Creates a new `DeleteSite`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSiteOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSiteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterTransitGateway`.
    ///
    /// <p>Deregisters a transit gateway from your global network. This action does not delete your transit gateway, or modify any of its attachments. This action removes any customer gateway associations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterTransitGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deregister_transit_gateway_input::Builder,
    }
    impl DeregisterTransitGateway {
        /// Creates a new `DeregisterTransitGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterTransitGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterTransitGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
        pub fn transit_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transit_gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
        pub fn set_transit_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGlobalNetworks`.
    ///
    /// <p>Describes one or more global networks. By default, all global networks are described. To describe the objects in your global network, you must use the appropriate <code>Get*</code> action. For example, to list the transit gateways in your global network, use <code>GetTransitGatewayRegistrations</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeGlobalNetworks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_global_networks_input::Builder,
    }
    impl DescribeGlobalNetworks {
        /// Creates a new `DescribeGlobalNetworks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGlobalNetworksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGlobalNetworksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeGlobalNetworksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeGlobalNetworksPaginator {
            crate::paginator::DescribeGlobalNetworksPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `GlobalNetworkIds`.
        ///
        /// To override the contents of this collection use [`set_global_network_ids`](Self::set_global_network_ids).
        ///
        /// <p>The IDs of one or more global networks. The maximum is 10.</p>
        pub fn global_network_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_ids(input.into());
            self
        }
        /// <p>The IDs of one or more global networks. The maximum is 10.</p>
        pub fn set_global_network_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_global_network_ids(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateConnectPeer`.
    ///
    /// <p>Disassociates a core network Connect peer from a device and a link. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateConnectPeer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_connect_peer_input::Builder,
    }
    impl DisassociateConnectPeer {
        /// Creates a new `DisassociateConnectPeer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateConnectPeerOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateConnectPeerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the Connect peer to disassociate from a device.</p>
        pub fn connect_peer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connect_peer_id(input.into());
            self
        }
        /// <p>The ID of the Connect peer to disassociate from a device.</p>
        pub fn set_connect_peer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connect_peer_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateCustomerGateway`.
    ///
    /// <p>Disassociates a customer gateway from a device and a link.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateCustomerGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_customer_gateway_input::Builder,
    }
    impl DisassociateCustomerGateway {
        /// Creates a new `DisassociateCustomerGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateCustomerGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateCustomerGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer gateway.</p>
        pub fn customer_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.customer_gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer gateway.</p>
        pub fn set_customer_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_customer_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateLink`.
    ///
    /// <p>Disassociates an existing device from a link. You must first disassociate any customer gateways that are associated with the link.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateLink {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_link_input::Builder,
    }
    impl DisassociateLink {
        /// Creates a new `DisassociateLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateLinkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateTransitGatewayConnectPeer`.
    ///
    /// <p>Disassociates a transit gateway Connect peer from a device and link.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateTransitGatewayConnectPeer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_transit_gateway_connect_peer_input::Builder,
    }
    impl DisassociateTransitGatewayConnectPeer {
        /// Creates a new `DisassociateTransitGatewayConnectPeer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateTransitGatewayConnectPeerOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateTransitGatewayConnectPeerError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway Connect peer.</p>
        pub fn transit_gateway_connect_peer_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.transit_gateway_connect_peer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway Connect peer.</p>
        pub fn set_transit_gateway_connect_peer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_connect_peer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExecuteCoreNetworkChangeSet`.
    ///
    /// <p>Executes a change set on your core network. Deploys changes globally based on the policy submitted..</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExecuteCoreNetworkChangeSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::execute_core_network_change_set_input::Builder,
    }
    impl ExecuteCoreNetworkChangeSet {
        /// Creates a new `ExecuteCoreNetworkChangeSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExecuteCoreNetworkChangeSetOutput,
            aws_smithy_http::result::SdkError<crate::error::ExecuteCoreNetworkChangeSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ID of the policy version.</p>
        pub fn policy_version_id(mut self, input: i32) -> Self {
            self.inner = self.inner.policy_version_id(input);
            self
        }
        /// <p>The ID of the policy version.</p>
        pub fn set_policy_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_policy_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConnectAttachment`.
    ///
    /// <p>Returns information about a core network Connect attachment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConnectAttachment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_connect_attachment_input::Builder,
    }
    impl GetConnectAttachment {
        /// Creates a new `GetConnectAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConnectAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConnectAttachmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the attachment.</p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConnections`.
    ///
    /// <p>Gets information about one or more of your connections in a global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConnections {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_connections_input::Builder,
    }
    impl GetConnections {
        /// Creates a new `GetConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConnectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConnectionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetConnectionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetConnectionsPaginator {
            crate::paginator::GetConnectionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// Appends an item to `ConnectionIds`.
        ///
        /// To override the contents of this collection use [`set_connection_ids`](Self::set_connection_ids).
        ///
        /// <p>One or more connection IDs.</p>
        pub fn connection_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_ids(input.into());
            self
        }
        /// <p>One or more connection IDs.</p>
        pub fn set_connection_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_connection_ids(input);
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConnectPeer`.
    ///
    /// <p>Returns information about a core network Connect peer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConnectPeer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_connect_peer_input::Builder,
    }
    impl GetConnectPeer {
        /// Creates a new `GetConnectPeer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConnectPeerOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConnectPeerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Connect peer.</p>
        pub fn connect_peer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connect_peer_id(input.into());
            self
        }
        /// <p>The ID of the Connect peer.</p>
        pub fn set_connect_peer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connect_peer_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConnectPeerAssociations`.
    ///
    /// <p>Returns information about a core network Connect peer associations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConnectPeerAssociations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_connect_peer_associations_input::Builder,
    }
    impl GetConnectPeerAssociations {
        /// Creates a new `GetConnectPeerAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConnectPeerAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConnectPeerAssociationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetConnectPeerAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetConnectPeerAssociationsPaginator {
            crate::paginator::GetConnectPeerAssociationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// Appends an item to `ConnectPeerIds`.
        ///
        /// To override the contents of this collection use [`set_connect_peer_ids`](Self::set_connect_peer_ids).
        ///
        /// <p>The IDs of the Connect peers.</p>
        pub fn connect_peer_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connect_peer_ids(input.into());
            self
        }
        /// <p>The IDs of the Connect peers.</p>
        pub fn set_connect_peer_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_connect_peer_ids(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCoreNetwork`.
    ///
    /// <p>Returns information about a core network. By default it returns the LIVE policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCoreNetwork {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_core_network_input::Builder,
    }
    impl GetCoreNetwork {
        /// Creates a new `GetCoreNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCoreNetworkOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCoreNetworkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCoreNetworkChangeSet`.
    ///
    /// <p>Returns a change set between the LIVE core network policy and a submitted policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCoreNetworkChangeSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_core_network_change_set_input::Builder,
    }
    impl GetCoreNetworkChangeSet {
        /// Creates a new `GetCoreNetworkChangeSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCoreNetworkChangeSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCoreNetworkChangeSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetCoreNetworkChangeSetPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetCoreNetworkChangeSetPaginator {
            crate::paginator::GetCoreNetworkChangeSetPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ID of the policy version.</p>
        pub fn policy_version_id(mut self, input: i32) -> Self {
            self.inner = self.inner.policy_version_id(input);
            self
        }
        /// <p>The ID of the policy version.</p>
        pub fn set_policy_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_policy_version_id(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCoreNetworkPolicy`.
    ///
    /// <p>Gets details about a core network policy. You can get details about your current live policy or any previous policy version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCoreNetworkPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_core_network_policy_input::Builder,
    }
    impl GetCoreNetworkPolicy {
        /// Creates a new `GetCoreNetworkPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCoreNetworkPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCoreNetworkPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ID of a core network policy version.</p>
        pub fn policy_version_id(mut self, input: i32) -> Self {
            self.inner = self.inner.policy_version_id(input);
            self
        }
        /// <p>The ID of a core network policy version.</p>
        pub fn set_policy_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_policy_version_id(input);
            self
        }
        /// <p>The alias of a core network policy </p>
        pub fn alias(mut self, input: crate::model::CoreNetworkPolicyAlias) -> Self {
            self.inner = self.inner.alias(input);
            self
        }
        /// <p>The alias of a core network policy </p>
        pub fn set_alias(
            mut self,
            input: std::option::Option<crate::model::CoreNetworkPolicyAlias>,
        ) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCustomerGatewayAssociations`.
    ///
    /// <p>Gets the association information for customer gateways that are associated with devices and links in your global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCustomerGatewayAssociations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_customer_gateway_associations_input::Builder,
    }
    impl GetCustomerGatewayAssociations {
        /// Creates a new `GetCustomerGatewayAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCustomerGatewayAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCustomerGatewayAssociationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetCustomerGatewayAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetCustomerGatewayAssociationsPaginator {
            crate::paginator::GetCustomerGatewayAssociationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// Appends an item to `CustomerGatewayArns`.
        ///
        /// To override the contents of this collection use [`set_customer_gateway_arns`](Self::set_customer_gateway_arns).
        ///
        /// <p>One or more customer gateway Amazon Resource Names (ARNs). The maximum is 10.</p>
        pub fn customer_gateway_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.customer_gateway_arns(input.into());
            self
        }
        /// <p>One or more customer gateway Amazon Resource Names (ARNs). The maximum is 10.</p>
        pub fn set_customer_gateway_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_customer_gateway_arns(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDevices`.
    ///
    /// <p>Gets information about one or more of your devices in a global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDevices {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_devices_input::Builder,
    }
    impl GetDevices {
        /// Creates a new `GetDevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDevicesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetDevicesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetDevicesPaginator {
            crate::paginator::GetDevicesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// Appends an item to `DeviceIds`.
        ///
        /// To override the contents of this collection use [`set_device_ids`](Self::set_device_ids).
        ///
        /// <p>One or more device IDs. The maximum is 10.</p>
        pub fn device_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_ids(input.into());
            self
        }
        /// <p>One or more device IDs. The maximum is 10.</p>
        pub fn set_device_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_ids(input);
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLinkAssociations`.
    ///
    /// <p>Gets the link associations for a device or a link. Either the device ID or the link ID must be specified.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLinkAssociations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_link_associations_input::Builder,
    }
    impl GetLinkAssociations {
        /// Creates a new `GetLinkAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLinkAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLinkAssociationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetLinkAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetLinkAssociationsPaginator {
            crate::paginator::GetLinkAssociationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLinks`.
    ///
    /// <p>Gets information about one or more links in a specified global network.</p>
    /// <p>If you specify the site ID, you cannot specify the type or provider in the same request. You can specify the type and provider in the same request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLinks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_links_input::Builder,
    }
    impl GetLinks {
        /// Creates a new `GetLinks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLinksOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLinksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetLinksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetLinksPaginator {
            crate::paginator::GetLinksPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// Appends an item to `LinkIds`.
        ///
        /// To override the contents of this collection use [`set_link_ids`](Self::set_link_ids).
        ///
        /// <p>One or more link IDs. The maximum is 10.</p>
        pub fn link_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_ids(input.into());
            self
        }
        /// <p>One or more link IDs. The maximum is 10.</p>
        pub fn set_link_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_link_ids(input);
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
        /// <p>The link type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.r#type(input.into());
            self
        }
        /// <p>The link type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The link provider.</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider(input.into());
            self
        }
        /// <p>The link provider.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_provider(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNetworkResourceCounts`.
    ///
    /// <p>Gets the count of network resources, by resource type, for the specified global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetNetworkResourceCounts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_network_resource_counts_input::Builder,
    }
    impl GetNetworkResourceCounts {
        /// Creates a new `GetNetworkResourceCounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNetworkResourceCountsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNetworkResourceCountsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetNetworkResourceCountsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetNetworkResourceCountsPaginator {
            crate::paginator::GetNetworkResourceCountsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The resource type.</p>
        /// <p>The following are the supported resource types for Direct Connect:</p>
        /// <ul>
        /// <li> <p> <code>dxcon</code> </p> </li>
        /// <li> <p> <code>dx-gateway</code> </p> </li>
        /// <li> <p> <code>dx-vif</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Network Manager:</p>
        /// <ul>
        /// <li> <p> <code>connection</code> </p> </li>
        /// <li> <p> <code>device</code> </p> </li>
        /// <li> <p> <code>link</code> </p> </li>
        /// <li> <p> <code>site</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Amazon VPC:</p>
        /// <ul>
        /// <li> <p> <code>customer-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway-attachment</code> </p> </li>
        /// <li> <p> <code>transit-gateway-connect-peer</code> </p> </li>
        /// <li> <p> <code>transit-gateway-route-table</code> </p> </li>
        /// <li> <p> <code>vpn-connection</code> </p> </li>
        /// </ul>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The resource type.</p>
        /// <p>The following are the supported resource types for Direct Connect:</p>
        /// <ul>
        /// <li> <p> <code>dxcon</code> </p> </li>
        /// <li> <p> <code>dx-gateway</code> </p> </li>
        /// <li> <p> <code>dx-vif</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Network Manager:</p>
        /// <ul>
        /// <li> <p> <code>connection</code> </p> </li>
        /// <li> <p> <code>device</code> </p> </li>
        /// <li> <p> <code>link</code> </p> </li>
        /// <li> <p> <code>site</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Amazon VPC:</p>
        /// <ul>
        /// <li> <p> <code>customer-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway-attachment</code> </p> </li>
        /// <li> <p> <code>transit-gateway-connect-peer</code> </p> </li>
        /// <li> <p> <code>transit-gateway-route-table</code> </p> </li>
        /// <li> <p> <code>vpn-connection</code> </p> </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNetworkResourceRelationships`.
    ///
    /// <p>Gets the network resource relationships for the specified global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetNetworkResourceRelationships {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_network_resource_relationships_input::Builder,
    }
    impl GetNetworkResourceRelationships {
        /// Creates a new `GetNetworkResourceRelationships`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNetworkResourceRelationshipsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNetworkResourceRelationshipsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetNetworkResourceRelationshipsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetNetworkResourceRelationshipsPaginator {
            crate::paginator::GetNetworkResourceRelationshipsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ARN of the registered gateway.</p>
        pub fn registered_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registered_gateway_arn(input.into());
            self
        }
        /// <p>The ARN of the registered gateway.</p>
        pub fn set_registered_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_registered_gateway_arn(input);
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_region(input.into());
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_aws_region(input);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The resource type.</p>
        /// <p>The following are the supported resource types for Direct Connect:</p>
        /// <ul>
        /// <li> <p> <code>dxcon</code> </p> </li>
        /// <li> <p> <code>dx-gateway</code> </p> </li>
        /// <li> <p> <code>dx-vif</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Network Manager:</p>
        /// <ul>
        /// <li> <p> <code>connection</code> </p> </li>
        /// <li> <p> <code>device</code> </p> </li>
        /// <li> <p> <code>link</code> </p> </li>
        /// <li> <p> <code>site</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Amazon VPC:</p>
        /// <ul>
        /// <li> <p> <code>customer-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway-attachment</code> </p> </li>
        /// <li> <p> <code>transit-gateway-connect-peer</code> </p> </li>
        /// <li> <p> <code>transit-gateway-route-table</code> </p> </li>
        /// <li> <p> <code>vpn-connection</code> </p> </li>
        /// </ul>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The resource type.</p>
        /// <p>The following are the supported resource types for Direct Connect:</p>
        /// <ul>
        /// <li> <p> <code>dxcon</code> </p> </li>
        /// <li> <p> <code>dx-gateway</code> </p> </li>
        /// <li> <p> <code>dx-vif</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Network Manager:</p>
        /// <ul>
        /// <li> <p> <code>connection</code> </p> </li>
        /// <li> <p> <code>device</code> </p> </li>
        /// <li> <p> <code>link</code> </p> </li>
        /// <li> <p> <code>site</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Amazon VPC:</p>
        /// <ul>
        /// <li> <p> <code>customer-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway-attachment</code> </p> </li>
        /// <li> <p> <code>transit-gateway-connect-peer</code> </p> </li>
        /// <li> <p> <code>transit-gateway-route-table</code> </p> </li>
        /// <li> <p> <code>vpn-connection</code> </p> </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The ARN of the gateway.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the gateway.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNetworkResources`.
    ///
    /// <p>Describes the network resources for the specified global network.</p>
    /// <p>The results include information from the corresponding Describe call for the resource, minus any sensitive information such as pre-shared keys.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetNetworkResources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_network_resources_input::Builder,
    }
    impl GetNetworkResources {
        /// Creates a new `GetNetworkResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNetworkResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNetworkResourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetNetworkResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetNetworkResourcesPaginator {
            crate::paginator::GetNetworkResourcesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ARN of the gateway.</p>
        pub fn registered_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registered_gateway_arn(input.into());
            self
        }
        /// <p>The ARN of the gateway.</p>
        pub fn set_registered_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_registered_gateway_arn(input);
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_region(input.into());
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_aws_region(input);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The resource type.</p>
        /// <p>The following are the supported resource types for Direct Connect:</p>
        /// <ul>
        /// <li> <p> <code>dxcon</code> - The definition model is <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_Connection.html">Connection</a>.</p> </li>
        /// <li> <p> <code>dx-gateway</code> - The definition model is <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DirectConnectGateway.html">DirectConnectGateway</a>.</p> </li>
        /// <li> <p> <code>dx-vif</code> - The definition model is <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_VirtualInterface.html">VirtualInterface</a>.</p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Network Manager:</p>
        /// <ul>
        /// <li> <p> <code>connection</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Connection.html">Connection</a>.</p> </li>
        /// <li> <p> <code>device</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Device.html">Device</a>.</p> </li>
        /// <li> <p> <code>link</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Link.html">Link</a>.</p> </li>
        /// <li> <p> <code>site</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Site.html">Site</a>.</p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Amazon VPC:</p>
        /// <ul>
        /// <li> <p> <code>customer-gateway</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CustomerGateway.html">CustomerGateway</a>.</p> </li>
        /// <li> <p> <code>transit-gateway</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGateway.html">TransitGateway</a>.</p> </li>
        /// <li> <p> <code>transit-gateway-attachment</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayAttachment.html">TransitGatewayAttachment</a>.</p> </li>
        /// <li> <p> <code>transit-gateway-connect-peer</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayConnectPeer.html">TransitGatewayConnectPeer</a>.</p> </li>
        /// <li> <p> <code>transit-gateway-route-table</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayRouteTable.html">TransitGatewayRouteTable</a>.</p> </li>
        /// <li> <p> <code>vpn-connection</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpnConnection.html">VpnConnection</a>.</p> </li>
        /// </ul>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The resource type.</p>
        /// <p>The following are the supported resource types for Direct Connect:</p>
        /// <ul>
        /// <li> <p> <code>dxcon</code> - The definition model is <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_Connection.html">Connection</a>.</p> </li>
        /// <li> <p> <code>dx-gateway</code> - The definition model is <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DirectConnectGateway.html">DirectConnectGateway</a>.</p> </li>
        /// <li> <p> <code>dx-vif</code> - The definition model is <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_VirtualInterface.html">VirtualInterface</a>.</p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Network Manager:</p>
        /// <ul>
        /// <li> <p> <code>connection</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Connection.html">Connection</a>.</p> </li>
        /// <li> <p> <code>device</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Device.html">Device</a>.</p> </li>
        /// <li> <p> <code>link</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Link.html">Link</a>.</p> </li>
        /// <li> <p> <code>site</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Site.html">Site</a>.</p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Amazon VPC:</p>
        /// <ul>
        /// <li> <p> <code>customer-gateway</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CustomerGateway.html">CustomerGateway</a>.</p> </li>
        /// <li> <p> <code>transit-gateway</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGateway.html">TransitGateway</a>.</p> </li>
        /// <li> <p> <code>transit-gateway-attachment</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayAttachment.html">TransitGatewayAttachment</a>.</p> </li>
        /// <li> <p> <code>transit-gateway-connect-peer</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayConnectPeer.html">TransitGatewayConnectPeer</a>.</p> </li>
        /// <li> <p> <code>transit-gateway-route-table</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayRouteTable.html">TransitGatewayRouteTable</a>.</p> </li>
        /// <li> <p> <code>vpn-connection</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpnConnection.html">VpnConnection</a>.</p> </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNetworkRoutes`.
    ///
    /// <p>Gets the network routes of the specified global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetNetworkRoutes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_network_routes_input::Builder,
    }
    impl GetNetworkRoutes {
        /// Creates a new `GetNetworkRoutes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNetworkRoutesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNetworkRoutesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the route table.</p>
        pub fn route_table_identifier(mut self, input: crate::model::RouteTableIdentifier) -> Self {
            self.inner = self.inner.route_table_identifier(input);
            self
        }
        /// <p>The ID of the route table.</p>
        pub fn set_route_table_identifier(
            mut self,
            input: std::option::Option<crate::model::RouteTableIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_route_table_identifier(input);
            self
        }
        /// Appends an item to `ExactCidrMatches`.
        ///
        /// To override the contents of this collection use [`set_exact_cidr_matches`](Self::set_exact_cidr_matches).
        ///
        /// <p>An exact CIDR block.</p>
        pub fn exact_cidr_matches(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.exact_cidr_matches(input.into());
            self
        }
        /// <p>An exact CIDR block.</p>
        pub fn set_exact_cidr_matches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_exact_cidr_matches(input);
            self
        }
        /// Appends an item to `LongestPrefixMatches`.
        ///
        /// To override the contents of this collection use [`set_longest_prefix_matches`](Self::set_longest_prefix_matches).
        ///
        /// <p>The most specific route that matches the traffic (longest prefix match).</p>
        pub fn longest_prefix_matches(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.longest_prefix_matches(input.into());
            self
        }
        /// <p>The most specific route that matches the traffic (longest prefix match).</p>
        pub fn set_longest_prefix_matches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_longest_prefix_matches(input);
            self
        }
        /// Appends an item to `SubnetOfMatches`.
        ///
        /// To override the contents of this collection use [`set_subnet_of_matches`](Self::set_subnet_of_matches).
        ///
        /// <p>The routes with a subnet that match the specified CIDR filter.</p>
        pub fn subnet_of_matches(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_of_matches(input.into());
            self
        }
        /// <p>The routes with a subnet that match the specified CIDR filter.</p>
        pub fn set_subnet_of_matches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_of_matches(input);
            self
        }
        /// Appends an item to `SupernetOfMatches`.
        ///
        /// To override the contents of this collection use [`set_supernet_of_matches`](Self::set_supernet_of_matches).
        ///
        /// <p>The routes with a CIDR that encompasses the CIDR filter. Example: If you specify 10.0.1.0/30, then the result returns 10.0.1.0/29.</p>
        pub fn supernet_of_matches(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.supernet_of_matches(input.into());
            self
        }
        /// <p>The routes with a CIDR that encompasses the CIDR filter. Example: If you specify 10.0.1.0/30, then the result returns 10.0.1.0/29.</p>
        pub fn set_supernet_of_matches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_supernet_of_matches(input);
            self
        }
        /// Appends an item to `PrefixListIds`.
        ///
        /// To override the contents of this collection use [`set_prefix_list_ids`](Self::set_prefix_list_ids).
        ///
        /// <p>The IDs of the prefix lists.</p>
        pub fn prefix_list_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.prefix_list_ids(input.into());
            self
        }
        /// <p>The IDs of the prefix lists.</p>
        pub fn set_prefix_list_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_prefix_list_ids(input);
            self
        }
        /// Appends an item to `States`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>The route states.</p>
        pub fn states(mut self, input: crate::model::RouteState) -> Self {
            self.inner = self.inner.states(input);
            self
        }
        /// <p>The route states.</p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteState>>,
        ) -> Self {
            self.inner = self.inner.set_states(input);
            self
        }
        /// Appends an item to `Types`.
        ///
        /// To override the contents of this collection use [`set_types`](Self::set_types).
        ///
        /// <p>The route types.</p>
        pub fn types(mut self, input: crate::model::RouteType) -> Self {
            self.inner = self.inner.types(input);
            self
        }
        /// <p>The route types.</p>
        pub fn set_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteType>>,
        ) -> Self {
            self.inner = self.inner.set_types(input);
            self
        }
        /// Adds a key-value pair to `DestinationFilters`.
        ///
        /// To override the contents of this collection use [`set_destination_filters`](Self::set_destination_filters).
        ///
        /// <p>Filter by route table destination. Possible Values: TRANSIT_GATEWAY_ATTACHMENT_ID, RESOURCE_ID, or RESOURCE_TYPE.</p>
        pub fn destination_filters(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            self.inner = self.inner.destination_filters(k.into(), v);
            self
        }
        /// <p>Filter by route table destination. Possible Values: TRANSIT_GATEWAY_ATTACHMENT_ID, RESOURCE_ID, or RESOURCE_TYPE.</p>
        pub fn set_destination_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_destination_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNetworkTelemetry`.
    ///
    /// <p>Gets the network telemetry of the specified global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetNetworkTelemetry {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_network_telemetry_input::Builder,
    }
    impl GetNetworkTelemetry {
        /// Creates a new `GetNetworkTelemetry`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNetworkTelemetryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNetworkTelemetryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetNetworkTelemetryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetNetworkTelemetryPaginator {
            crate::paginator::GetNetworkTelemetryPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ARN of the gateway.</p>
        pub fn registered_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registered_gateway_arn(input.into());
            self
        }
        /// <p>The ARN of the gateway.</p>
        pub fn set_registered_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_registered_gateway_arn(input);
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_region(input.into());
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_aws_region(input);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The resource type.</p>
        /// <p>The following are the supported resource types for Direct Connect:</p>
        /// <ul>
        /// <li> <p> <code>dxcon</code> </p> </li>
        /// <li> <p> <code>dx-gateway</code> </p> </li>
        /// <li> <p> <code>dx-vif</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Network Manager:</p>
        /// <ul>
        /// <li> <p> <code>connection</code> </p> </li>
        /// <li> <p> <code>device</code> </p> </li>
        /// <li> <p> <code>link</code> </p> </li>
        /// <li> <p> <code>site</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Amazon VPC:</p>
        /// <ul>
        /// <li> <p> <code>customer-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway-attachment</code> </p> </li>
        /// <li> <p> <code>transit-gateway-connect-peer</code> </p> </li>
        /// <li> <p> <code>transit-gateway-route-table</code> </p> </li>
        /// <li> <p> <code>vpn-connection</code> </p> </li>
        /// </ul>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The resource type.</p>
        /// <p>The following are the supported resource types for Direct Connect:</p>
        /// <ul>
        /// <li> <p> <code>dxcon</code> </p> </li>
        /// <li> <p> <code>dx-gateway</code> </p> </li>
        /// <li> <p> <code>dx-vif</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Network Manager:</p>
        /// <ul>
        /// <li> <p> <code>connection</code> </p> </li>
        /// <li> <p> <code>device</code> </p> </li>
        /// <li> <p> <code>link</code> </p> </li>
        /// <li> <p> <code>site</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Amazon VPC:</p>
        /// <ul>
        /// <li> <p> <code>customer-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway-attachment</code> </p> </li>
        /// <li> <p> <code>transit-gateway-connect-peer</code> </p> </li>
        /// <li> <p> <code>transit-gateway-route-table</code> </p> </li>
        /// <li> <p> <code>vpn-connection</code> </p> </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourcePolicy`.
    ///
    /// <p>Returns information about a resource policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_resource_policy_input::Builder,
    }
    impl GetResourcePolicy {
        /// Creates a new `GetResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRouteAnalysis`.
    ///
    /// <p>Gets information about the specified route analysis.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRouteAnalysis {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_route_analysis_input::Builder,
    }
    impl GetRouteAnalysis {
        /// Creates a new `GetRouteAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRouteAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRouteAnalysisError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the route analysis.</p>
        pub fn route_analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_analysis_id(input.into());
            self
        }
        /// <p>The ID of the route analysis.</p>
        pub fn set_route_analysis_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_analysis_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSites`.
    ///
    /// <p>Gets information about one or more of your sites in a global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSites {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_sites_input::Builder,
    }
    impl GetSites {
        /// Creates a new `GetSites`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSitesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSitesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetSitesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetSitesPaginator {
            crate::paginator::GetSitesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// Appends an item to `SiteIds`.
        ///
        /// To override the contents of this collection use [`set_site_ids`](Self::set_site_ids).
        ///
        /// <p>One or more site IDs. The maximum is 10.</p>
        pub fn site_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_ids(input.into());
            self
        }
        /// <p>One or more site IDs. The maximum is 10.</p>
        pub fn set_site_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_site_ids(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSiteToSiteVpnAttachment`.
    ///
    /// <p>Returns information about a site-to-site VPN attachment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSiteToSiteVpnAttachment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_site_to_site_vpn_attachment_input::Builder,
    }
    impl GetSiteToSiteVpnAttachment {
        /// Creates a new `GetSiteToSiteVpnAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSiteToSiteVpnAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSiteToSiteVpnAttachmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the attachment.</p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTransitGatewayConnectPeerAssociations`.
    ///
    /// <p>Gets information about one or more of your transit gateway Connect peer associations in a global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTransitGatewayConnectPeerAssociations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_transit_gateway_connect_peer_associations_input::Builder,
    }
    impl GetTransitGatewayConnectPeerAssociations {
        /// Creates a new `GetTransitGatewayConnectPeerAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTransitGatewayConnectPeerAssociationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetTransitGatewayConnectPeerAssociationsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetTransitGatewayConnectPeerAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetTransitGatewayConnectPeerAssociationsPaginator {
            crate::paginator::GetTransitGatewayConnectPeerAssociationsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// Appends an item to `TransitGatewayConnectPeerArns`.
        ///
        /// To override the contents of this collection use [`set_transit_gateway_connect_peer_arns`](Self::set_transit_gateway_connect_peer_arns).
        ///
        /// <p>One or more transit gateway Connect peer Amazon Resource Names (ARNs).</p>
        pub fn transit_gateway_connect_peer_arns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.transit_gateway_connect_peer_arns(input.into());
            self
        }
        /// <p>One or more transit gateway Connect peer Amazon Resource Names (ARNs).</p>
        pub fn set_transit_gateway_connect_peer_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_connect_peer_arns(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTransitGatewayRegistrations`.
    ///
    /// <p>Gets information about the transit gateway registrations in a specified global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTransitGatewayRegistrations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_transit_gateway_registrations_input::Builder,
    }
    impl GetTransitGatewayRegistrations {
        /// Creates a new `GetTransitGatewayRegistrations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTransitGatewayRegistrationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTransitGatewayRegistrationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetTransitGatewayRegistrationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetTransitGatewayRegistrationsPaginator {
            crate::paginator::GetTransitGatewayRegistrationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// Appends an item to `TransitGatewayArns`.
        ///
        /// To override the contents of this collection use [`set_transit_gateway_arns`](Self::set_transit_gateway_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of one or more transit gateways. The maximum is 10.</p>
        pub fn transit_gateway_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transit_gateway_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of one or more transit gateways. The maximum is 10.</p>
        pub fn set_transit_gateway_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_arns(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVpcAttachment`.
    ///
    /// <p>Returns information about a VPC attachment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVpcAttachment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_vpc_attachment_input::Builder,
    }
    impl GetVpcAttachment {
        /// Creates a new `GetVpcAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVpcAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVpcAttachmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the attachment.</p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAttachments`.
    ///
    /// <p>Returns a list of core network attachments.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAttachments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_attachments_input::Builder,
    }
    impl ListAttachments {
        /// Creates a new `ListAttachments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAttachmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAttachmentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAttachmentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAttachmentsPaginator {
            crate::paginator::ListAttachmentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The type of attachment.</p>
        pub fn attachment_type(mut self, input: crate::model::AttachmentType) -> Self {
            self.inner = self.inner.attachment_type(input);
            self
        }
        /// <p>The type of attachment.</p>
        pub fn set_attachment_type(
            mut self,
            input: std::option::Option<crate::model::AttachmentType>,
        ) -> Self {
            self.inner = self.inner.set_attachment_type(input);
            self
        }
        /// <p>The Region where the edge is located.</p>
        pub fn edge_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.edge_location(input.into());
            self
        }
        /// <p>The Region where the edge is located.</p>
        pub fn set_edge_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_edge_location(input);
            self
        }
        /// <p>The state of the attachment.</p>
        pub fn state(mut self, input: crate::model::AttachmentState) -> Self {
            self.inner = self.inner.state(input);
            self
        }
        /// <p>The state of the attachment.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::AttachmentState>,
        ) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConnectPeers`.
    ///
    /// <p>Returns a list of core network Connect peers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListConnectPeers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_connect_peers_input::Builder,
    }
    impl ListConnectPeers {
        /// Creates a new `ListConnectPeers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConnectPeersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConnectPeersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListConnectPeersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListConnectPeersPaginator {
            crate::paginator::ListConnectPeersPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn connect_attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connect_attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn set_connect_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connect_attachment_id(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCoreNetworkPolicyVersions`.
    ///
    /// <p>Returns a list of core network policy versions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCoreNetworkPolicyVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_core_network_policy_versions_input::Builder,
    }
    impl ListCoreNetworkPolicyVersions {
        /// Creates a new `ListCoreNetworkPolicyVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCoreNetworkPolicyVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCoreNetworkPolicyVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCoreNetworkPolicyVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCoreNetworkPolicyVersionsPaginator {
            crate::paginator::ListCoreNetworkPolicyVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCoreNetworks`.
    ///
    /// <p>Returns a list of owned and shared core networks.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCoreNetworks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_core_networks_input::Builder,
    }
    impl ListCoreNetworks {
        /// Creates a new `ListCoreNetworks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCoreNetworksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCoreNetworksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCoreNetworksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCoreNetworksPaginator {
            crate::paginator::ListCoreNetworksPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags for a specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutCoreNetworkPolicy`.
    ///
    /// <p>Creates a new, immutable version of a core network policy. A subsequent change set is created showing the differences between the LIVE policy and the submitted policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutCoreNetworkPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_core_network_policy_input::Builder,
    }
    impl PutCoreNetworkPolicy {
        /// Creates a new `PutCoreNetworkPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutCoreNetworkPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutCoreNetworkPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The policy document.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(input.into());
            self
        }
        /// <p>The policy document.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
        /// <p>a core network policy description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>a core network policy description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ID of a core network policy. </p>
        pub fn latest_version_id(mut self, input: i32) -> Self {
            self.inner = self.inner.latest_version_id(input);
            self
        }
        /// <p>The ID of a core network policy. </p>
        pub fn set_latest_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_latest_version_id(input);
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutResourcePolicy`.
    ///
    /// <p>Creates or updates a resource policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_resource_policy_input::Builder,
    }
    impl PutResourcePolicy {
        /// Creates a new `PutResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The JSON resource policy document.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(input.into());
            self
        }
        /// <p>The JSON resource policy document.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
        /// <p>The ARN of the resource policy. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource policy. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterTransitGateway`.
    ///
    /// <p>Registers a transit gateway in your global network. The transit gateway can be in any Amazon Web Services Region, but it must be owned by the same Amazon Web Services account that owns the global network. You cannot register a transit gateway in more than one global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterTransitGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_transit_gateway_input::Builder,
    }
    impl RegisterTransitGateway {
        /// Creates a new `RegisterTransitGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterTransitGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterTransitGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
        pub fn transit_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transit_gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
        pub fn set_transit_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectAttachment`.
    ///
    /// <p>Rejects a core network attachment request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RejectAttachment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reject_attachment_input::Builder,
    }
    impl RejectAttachment {
        /// Creates a new `RejectAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectAttachmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the attachment.</p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreCoreNetworkPolicyVersion`.
    ///
    /// <p>Restores a previous policy version as a new, immutable version of a core network policy. A subsequent change set is created showing the differences between the LIVE policy and restored policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestoreCoreNetworkPolicyVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::restore_core_network_policy_version_input::Builder,
    }
    impl RestoreCoreNetworkPolicyVersion {
        /// Creates a new `RestoreCoreNetworkPolicyVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreCoreNetworkPolicyVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreCoreNetworkPolicyVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ID of the policy version to restore.</p>
        pub fn policy_version_id(mut self, input: i32) -> Self {
            self.inner = self.inner.policy_version_id(input);
            self
        }
        /// <p>The ID of the policy version to restore.</p>
        pub fn set_policy_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_policy_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartRouteAnalysis`.
    ///
    /// <p>Starts analyzing the routing path between the specified source and destination. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/route-analyzer.html">Route Analyzer</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartRouteAnalysis {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_route_analysis_input::Builder,
    }
    impl StartRouteAnalysis {
        /// Creates a new `StartRouteAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartRouteAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::StartRouteAnalysisError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The source from which traffic originates.</p>
        pub fn source(
            mut self,
            input: crate::model::RouteAnalysisEndpointOptionsSpecification,
        ) -> Self {
            self.inner = self.inner.source(input);
            self
        }
        /// <p>The source from which traffic originates.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::RouteAnalysisEndpointOptionsSpecification>,
        ) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>The destination.</p>
        pub fn destination(
            mut self,
            input: crate::model::RouteAnalysisEndpointOptionsSpecification,
        ) -> Self {
            self.inner = self.inner.destination(input);
            self
        }
        /// <p>The destination.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::RouteAnalysisEndpointOptionsSpecification>,
        ) -> Self {
            self.inner = self.inner.set_destination(input);
            self
        }
        /// <p>Indicates whether to analyze the return path. The default is <code>false</code>.</p>
        pub fn include_return_path(mut self, input: bool) -> Self {
            self.inner = self.inner.include_return_path(input);
            self
        }
        /// <p>Indicates whether to analyze the return path. The default is <code>false</code>.</p>
        pub fn set_include_return_path(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_return_path(input);
            self
        }
        /// <p>Indicates whether to include the location of middlebox appliances in the route analysis. The default is <code>false</code>.</p>
        pub fn use_middleboxes(mut self, input: bool) -> Self {
            self.inner = self.inner.use_middleboxes(input);
            self
        }
        /// <p>Indicates whether to include the location of middlebox appliances in the route analysis. The default is <code>false</code>.</p>
        pub fn set_use_middleboxes(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_use_middleboxes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Tags a specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the specified resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to apply to the specified resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys to remove from the specified resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys to remove from the specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConnection`.
    ///
    /// <p>Updates the information for an existing connection. To remove information for any of the parameters, specify an empty string.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_connection_input::Builder,
    }
    impl UpdateConnection {
        /// Creates a new `UpdateConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The ID of the link for the first device in the connection.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link for the first device in the connection.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
        /// <p>The ID of the link for the second device in the connection.</p>
        pub fn connected_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connected_link_id(input.into());
            self
        }
        /// <p>The ID of the link for the second device in the connection.</p>
        pub fn set_connected_link_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connected_link_id(input);
            self
        }
        /// <p>A description of the connection.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the connection.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCoreNetwork`.
    ///
    /// <p>Updates the description of a core network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCoreNetwork {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_core_network_input::Builder,
    }
    impl UpdateCoreNetwork {
        /// Creates a new `UpdateCoreNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCoreNetworkOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCoreNetworkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The description of the update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDevice`.
    ///
    /// <p>Updates the details for an existing device. To remove information for any of the parameters, specify an empty string.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDevice {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_device_input::Builder,
    }
    impl UpdateDevice {
        /// Creates a new `UpdateDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDeviceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The Amazon Web Services location of the device, if applicable. For an on-premises device, you can omit this parameter.</p>
        pub fn aws_location(mut self, input: crate::model::AwsLocation) -> Self {
            self.inner = self.inner.aws_location(input);
            self
        }
        /// <p>The Amazon Web Services location of the device, if applicable. For an on-premises device, you can omit this parameter.</p>
        pub fn set_aws_location(
            mut self,
            input: std::option::Option<crate::model::AwsLocation>,
        ) -> Self {
            self.inner = self.inner.set_aws_location(input);
            self
        }
        /// <p>A description of the device.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the device.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The type of the device.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.r#type(input.into());
            self
        }
        /// <p>The type of the device.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The vendor of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn vendor(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vendor(input.into());
            self
        }
        /// <p>The vendor of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn set_vendor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vendor(input);
            self
        }
        /// <p>The model of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn model(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model(input.into());
            self
        }
        /// <p>The model of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn set_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model(input);
            self
        }
        /// <p>The serial number of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.serial_number(input.into());
            self
        }
        /// <p>The serial number of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_serial_number(input);
            self
        }
        /// <p>Describes a location.</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.inner = self.inner.location(input);
            self
        }
        /// <p>Describes a location.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGlobalNetwork`.
    ///
    /// <p>Updates an existing global network. To remove information for any of the parameters, specify an empty string.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGlobalNetwork {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_global_network_input::Builder,
    }
    impl UpdateGlobalNetwork {
        /// Creates a new `UpdateGlobalNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGlobalNetworkOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGlobalNetworkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of your global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of your global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>A description of the global network.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the global network.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLink`.
    ///
    /// <p>Updates the details for an existing link. To remove information for any of the parameters, specify an empty string.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLink {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_link_input::Builder,
    }
    impl UpdateLink {
        /// Creates a new `UpdateLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLinkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
        /// <p>A description of the link.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the link.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The type of the link.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.r#type(input.into());
            self
        }
        /// <p>The type of the link.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The upload and download speed in Mbps. </p>
        pub fn bandwidth(mut self, input: crate::model::Bandwidth) -> Self {
            self.inner = self.inner.bandwidth(input);
            self
        }
        /// <p>The upload and download speed in Mbps. </p>
        pub fn set_bandwidth(
            mut self,
            input: std::option::Option<crate::model::Bandwidth>,
        ) -> Self {
            self.inner = self.inner.set_bandwidth(input);
            self
        }
        /// <p>The provider of the link.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider(input.into());
            self
        }
        /// <p>The provider of the link.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_provider(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNetworkResourceMetadata`.
    ///
    /// <p>Updates the resource metadata for the specified global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateNetworkResourceMetadata {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_network_resource_metadata_input::Builder,
    }
    impl UpdateNetworkResourceMetadata {
        /// Creates a new `UpdateNetworkResourceMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNetworkResourceMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNetworkResourceMetadataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>The resource metadata.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.metadata(k.into(), v.into());
            self
        }
        /// <p>The resource metadata.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSite`.
    ///
    /// <p>Updates the information for an existing site. To remove information for any of the parameters, specify an empty string.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSite {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_site_input::Builder,
    }
    impl UpdateSite {
        /// Creates a new `UpdateSite`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSiteOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSiteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of your site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p>The ID of your site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
        /// <p>A description of your site.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of your site.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The site location:</p>
        /// <ul>
        /// <li> <p> <code>Address</code>: The physical address of the site.</p> </li>
        /// <li> <p> <code>Latitude</code>: The latitude of the site. </p> </li>
        /// <li> <p> <code>Longitude</code>: The longitude of the site.</p> </li>
        /// </ul>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.inner = self.inner.location(input);
            self
        }
        /// <p>The site location:</p>
        /// <ul>
        /// <li> <p> <code>Address</code>: The physical address of the site.</p> </li>
        /// <li> <p> <code>Latitude</code>: The latitude of the site. </p> </li>
        /// <li> <p> <code>Longitude</code>: The longitude of the site.</p> </li>
        /// </ul>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVpcAttachment`.
    ///
    /// <p>Updates a VPC attachment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateVpcAttachment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_vpc_attachment_input::Builder,
    }
    impl UpdateVpcAttachment {
        /// Creates a new `UpdateVpcAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVpcAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVpcAttachmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the attachment.</p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_id(input);
            self
        }
        /// Appends an item to `AddSubnetArns`.
        ///
        /// To override the contents of this collection use [`set_add_subnet_arns`](Self::set_add_subnet_arns).
        ///
        /// <p>Adds a subnet ARN to the VPC attachment.</p>
        pub fn add_subnet_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.add_subnet_arns(input.into());
            self
        }
        /// <p>Adds a subnet ARN to the VPC attachment.</p>
        pub fn set_add_subnet_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_add_subnet_arns(input);
            self
        }
        /// Appends an item to `RemoveSubnetArns`.
        ///
        /// To override the contents of this collection use [`set_remove_subnet_arns`](Self::set_remove_subnet_arns).
        ///
        /// <p>Removes a subnet ARN from the attachment.</p>
        pub fn remove_subnet_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remove_subnet_arns(input.into());
            self
        }
        /// <p>Removes a subnet ARN from the attachment.</p>
        pub fn set_remove_subnet_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_remove_subnet_arns(input);
            self
        }
        /// <p>Additional options for updating the VPC attachment. </p>
        pub fn options(mut self, input: crate::model::VpcOptions) -> Self {
            self.inner = self.inner.options(input);
            self
        }
        /// <p>Additional options for updating the VPC attachment. </p>
        pub fn set_options(mut self, input: std::option::Option<crate::model::VpcOptions>) -> Self {
            self.inner = self.inner.set_options(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
