// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Network Manager
///
/// Client for invoking operations on AWS Network Manager. Each operation on AWS Network Manager is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_networkmanager::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_networkmanager::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_networkmanager::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptAttachment` operation.
    ///
    /// See [`AcceptAttachment`](crate::client::fluent_builders::AcceptAttachment) for more information about the
    /// operation and its arguments.
    pub fn accept_attachment(&self) -> fluent_builders::AcceptAttachment<C, M, R> {
        fluent_builders::AcceptAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateConnectPeer` operation.
    ///
    /// See [`AssociateConnectPeer`](crate::client::fluent_builders::AssociateConnectPeer) for more information about the
    /// operation and its arguments.
    pub fn associate_connect_peer(&self) -> fluent_builders::AssociateConnectPeer<C, M, R> {
        fluent_builders::AssociateConnectPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateCustomerGateway` operation.
    ///
    /// See [`AssociateCustomerGateway`](crate::client::fluent_builders::AssociateCustomerGateway) for more information about the
    /// operation and its arguments.
    pub fn associate_customer_gateway(&self) -> fluent_builders::AssociateCustomerGateway<C, M, R> {
        fluent_builders::AssociateCustomerGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateLink` operation.
    ///
    /// See [`AssociateLink`](crate::client::fluent_builders::AssociateLink) for more information about the
    /// operation and its arguments.
    pub fn associate_link(&self) -> fluent_builders::AssociateLink<C, M, R> {
        fluent_builders::AssociateLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateTransitGatewayConnectPeer` operation.
    ///
    /// See [`AssociateTransitGatewayConnectPeer`](crate::client::fluent_builders::AssociateTransitGatewayConnectPeer) for more information about the
    /// operation and its arguments.
    pub fn associate_transit_gateway_connect_peer(
        &self,
    ) -> fluent_builders::AssociateTransitGatewayConnectPeer<C, M, R> {
        fluent_builders::AssociateTransitGatewayConnectPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConnectAttachment` operation.
    ///
    /// See [`CreateConnectAttachment`](crate::client::fluent_builders::CreateConnectAttachment) for more information about the
    /// operation and its arguments.
    pub fn create_connect_attachment(&self) -> fluent_builders::CreateConnectAttachment<C, M, R> {
        fluent_builders::CreateConnectAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConnection` operation.
    ///
    /// See [`CreateConnection`](crate::client::fluent_builders::CreateConnection) for more information about the
    /// operation and its arguments.
    pub fn create_connection(&self) -> fluent_builders::CreateConnection<C, M, R> {
        fluent_builders::CreateConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConnectPeer` operation.
    ///
    /// See [`CreateConnectPeer`](crate::client::fluent_builders::CreateConnectPeer) for more information about the
    /// operation and its arguments.
    pub fn create_connect_peer(&self) -> fluent_builders::CreateConnectPeer<C, M, R> {
        fluent_builders::CreateConnectPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCoreNetwork` operation.
    ///
    /// See [`CreateCoreNetwork`](crate::client::fluent_builders::CreateCoreNetwork) for more information about the
    /// operation and its arguments.
    pub fn create_core_network(&self) -> fluent_builders::CreateCoreNetwork<C, M, R> {
        fluent_builders::CreateCoreNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDevice` operation.
    ///
    /// See [`CreateDevice`](crate::client::fluent_builders::CreateDevice) for more information about the
    /// operation and its arguments.
    pub fn create_device(&self) -> fluent_builders::CreateDevice<C, M, R> {
        fluent_builders::CreateDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGlobalNetwork` operation.
    ///
    /// See [`CreateGlobalNetwork`](crate::client::fluent_builders::CreateGlobalNetwork) for more information about the
    /// operation and its arguments.
    pub fn create_global_network(&self) -> fluent_builders::CreateGlobalNetwork<C, M, R> {
        fluent_builders::CreateGlobalNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLink` operation.
    ///
    /// See [`CreateLink`](crate::client::fluent_builders::CreateLink) for more information about the
    /// operation and its arguments.
    pub fn create_link(&self) -> fluent_builders::CreateLink<C, M, R> {
        fluent_builders::CreateLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSite` operation.
    ///
    /// See [`CreateSite`](crate::client::fluent_builders::CreateSite) for more information about the
    /// operation and its arguments.
    pub fn create_site(&self) -> fluent_builders::CreateSite<C, M, R> {
        fluent_builders::CreateSite::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSiteToSiteVpnAttachment` operation.
    ///
    /// See [`CreateSiteToSiteVpnAttachment`](crate::client::fluent_builders::CreateSiteToSiteVpnAttachment) for more information about the
    /// operation and its arguments.
    pub fn create_site_to_site_vpn_attachment(
        &self,
    ) -> fluent_builders::CreateSiteToSiteVpnAttachment<C, M, R> {
        fluent_builders::CreateSiteToSiteVpnAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVpcAttachment` operation.
    ///
    /// See [`CreateVpcAttachment`](crate::client::fluent_builders::CreateVpcAttachment) for more information about the
    /// operation and its arguments.
    pub fn create_vpc_attachment(&self) -> fluent_builders::CreateVpcAttachment<C, M, R> {
        fluent_builders::CreateVpcAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAttachment` operation.
    ///
    /// See [`DeleteAttachment`](crate::client::fluent_builders::DeleteAttachment) for more information about the
    /// operation and its arguments.
    pub fn delete_attachment(&self) -> fluent_builders::DeleteAttachment<C, M, R> {
        fluent_builders::DeleteAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConnection` operation.
    ///
    /// See [`DeleteConnection`](crate::client::fluent_builders::DeleteConnection) for more information about the
    /// operation and its arguments.
    pub fn delete_connection(&self) -> fluent_builders::DeleteConnection<C, M, R> {
        fluent_builders::DeleteConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConnectPeer` operation.
    ///
    /// See [`DeleteConnectPeer`](crate::client::fluent_builders::DeleteConnectPeer) for more information about the
    /// operation and its arguments.
    pub fn delete_connect_peer(&self) -> fluent_builders::DeleteConnectPeer<C, M, R> {
        fluent_builders::DeleteConnectPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCoreNetwork` operation.
    ///
    /// See [`DeleteCoreNetwork`](crate::client::fluent_builders::DeleteCoreNetwork) for more information about the
    /// operation and its arguments.
    pub fn delete_core_network(&self) -> fluent_builders::DeleteCoreNetwork<C, M, R> {
        fluent_builders::DeleteCoreNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCoreNetworkPolicyVersion` operation.
    ///
    /// See [`DeleteCoreNetworkPolicyVersion`](crate::client::fluent_builders::DeleteCoreNetworkPolicyVersion) for more information about the
    /// operation and its arguments.
    pub fn delete_core_network_policy_version(
        &self,
    ) -> fluent_builders::DeleteCoreNetworkPolicyVersion<C, M, R> {
        fluent_builders::DeleteCoreNetworkPolicyVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDevice` operation.
    ///
    /// See [`DeleteDevice`](crate::client::fluent_builders::DeleteDevice) for more information about the
    /// operation and its arguments.
    pub fn delete_device(&self) -> fluent_builders::DeleteDevice<C, M, R> {
        fluent_builders::DeleteDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGlobalNetwork` operation.
    ///
    /// See [`DeleteGlobalNetwork`](crate::client::fluent_builders::DeleteGlobalNetwork) for more information about the
    /// operation and its arguments.
    pub fn delete_global_network(&self) -> fluent_builders::DeleteGlobalNetwork<C, M, R> {
        fluent_builders::DeleteGlobalNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLink` operation.
    ///
    /// See [`DeleteLink`](crate::client::fluent_builders::DeleteLink) for more information about the
    /// operation and its arguments.
    pub fn delete_link(&self) -> fluent_builders::DeleteLink<C, M, R> {
        fluent_builders::DeleteLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResourcePolicy` operation.
    ///
    /// See [`DeleteResourcePolicy`](crate::client::fluent_builders::DeleteResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_resource_policy(&self) -> fluent_builders::DeleteResourcePolicy<C, M, R> {
        fluent_builders::DeleteResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSite` operation.
    ///
    /// See [`DeleteSite`](crate::client::fluent_builders::DeleteSite) for more information about the
    /// operation and its arguments.
    pub fn delete_site(&self) -> fluent_builders::DeleteSite<C, M, R> {
        fluent_builders::DeleteSite::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterTransitGateway` operation.
    ///
    /// See [`DeregisterTransitGateway`](crate::client::fluent_builders::DeregisterTransitGateway) for more information about the
    /// operation and its arguments.
    pub fn deregister_transit_gateway(&self) -> fluent_builders::DeregisterTransitGateway<C, M, R> {
        fluent_builders::DeregisterTransitGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeGlobalNetworks` operation.
    ///
    /// See [`DescribeGlobalNetworks`](crate::client::fluent_builders::DescribeGlobalNetworks) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeGlobalNetworks::into_paginator).
    pub fn describe_global_networks(&self) -> fluent_builders::DescribeGlobalNetworks<C, M, R> {
        fluent_builders::DescribeGlobalNetworks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateConnectPeer` operation.
    ///
    /// See [`DisassociateConnectPeer`](crate::client::fluent_builders::DisassociateConnectPeer) for more information about the
    /// operation and its arguments.
    pub fn disassociate_connect_peer(&self) -> fluent_builders::DisassociateConnectPeer<C, M, R> {
        fluent_builders::DisassociateConnectPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateCustomerGateway` operation.
    ///
    /// See [`DisassociateCustomerGateway`](crate::client::fluent_builders::DisassociateCustomerGateway) for more information about the
    /// operation and its arguments.
    pub fn disassociate_customer_gateway(
        &self,
    ) -> fluent_builders::DisassociateCustomerGateway<C, M, R> {
        fluent_builders::DisassociateCustomerGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateLink` operation.
    ///
    /// See [`DisassociateLink`](crate::client::fluent_builders::DisassociateLink) for more information about the
    /// operation and its arguments.
    pub fn disassociate_link(&self) -> fluent_builders::DisassociateLink<C, M, R> {
        fluent_builders::DisassociateLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateTransitGatewayConnectPeer` operation.
    ///
    /// See [`DisassociateTransitGatewayConnectPeer`](crate::client::fluent_builders::DisassociateTransitGatewayConnectPeer) for more information about the
    /// operation and its arguments.
    pub fn disassociate_transit_gateway_connect_peer(
        &self,
    ) -> fluent_builders::DisassociateTransitGatewayConnectPeer<C, M, R> {
        fluent_builders::DisassociateTransitGatewayConnectPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExecuteCoreNetworkChangeSet` operation.
    ///
    /// See [`ExecuteCoreNetworkChangeSet`](crate::client::fluent_builders::ExecuteCoreNetworkChangeSet) for more information about the
    /// operation and its arguments.
    pub fn execute_core_network_change_set(
        &self,
    ) -> fluent_builders::ExecuteCoreNetworkChangeSet<C, M, R> {
        fluent_builders::ExecuteCoreNetworkChangeSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConnectAttachment` operation.
    ///
    /// See [`GetConnectAttachment`](crate::client::fluent_builders::GetConnectAttachment) for more information about the
    /// operation and its arguments.
    pub fn get_connect_attachment(&self) -> fluent_builders::GetConnectAttachment<C, M, R> {
        fluent_builders::GetConnectAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConnections` operation.
    ///
    /// See [`GetConnections`](crate::client::fluent_builders::GetConnections) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetConnections::into_paginator).
    pub fn get_connections(&self) -> fluent_builders::GetConnections<C, M, R> {
        fluent_builders::GetConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConnectPeer` operation.
    ///
    /// See [`GetConnectPeer`](crate::client::fluent_builders::GetConnectPeer) for more information about the
    /// operation and its arguments.
    pub fn get_connect_peer(&self) -> fluent_builders::GetConnectPeer<C, M, R> {
        fluent_builders::GetConnectPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConnectPeerAssociations` operation.
    ///
    /// See [`GetConnectPeerAssociations`](crate::client::fluent_builders::GetConnectPeerAssociations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetConnectPeerAssociations::into_paginator).
    pub fn get_connect_peer_associations(
        &self,
    ) -> fluent_builders::GetConnectPeerAssociations<C, M, R> {
        fluent_builders::GetConnectPeerAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCoreNetwork` operation.
    ///
    /// See [`GetCoreNetwork`](crate::client::fluent_builders::GetCoreNetwork) for more information about the
    /// operation and its arguments.
    pub fn get_core_network(&self) -> fluent_builders::GetCoreNetwork<C, M, R> {
        fluent_builders::GetCoreNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCoreNetworkChangeSet` operation.
    ///
    /// See [`GetCoreNetworkChangeSet`](crate::client::fluent_builders::GetCoreNetworkChangeSet) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetCoreNetworkChangeSet::into_paginator).
    pub fn get_core_network_change_set(&self) -> fluent_builders::GetCoreNetworkChangeSet<C, M, R> {
        fluent_builders::GetCoreNetworkChangeSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCoreNetworkPolicy` operation.
    ///
    /// See [`GetCoreNetworkPolicy`](crate::client::fluent_builders::GetCoreNetworkPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_core_network_policy(&self) -> fluent_builders::GetCoreNetworkPolicy<C, M, R> {
        fluent_builders::GetCoreNetworkPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCustomerGatewayAssociations` operation.
    ///
    /// See [`GetCustomerGatewayAssociations`](crate::client::fluent_builders::GetCustomerGatewayAssociations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetCustomerGatewayAssociations::into_paginator).
    pub fn get_customer_gateway_associations(
        &self,
    ) -> fluent_builders::GetCustomerGatewayAssociations<C, M, R> {
        fluent_builders::GetCustomerGatewayAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDevices` operation.
    ///
    /// See [`GetDevices`](crate::client::fluent_builders::GetDevices) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetDevices::into_paginator).
    pub fn get_devices(&self) -> fluent_builders::GetDevices<C, M, R> {
        fluent_builders::GetDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLinkAssociations` operation.
    ///
    /// See [`GetLinkAssociations`](crate::client::fluent_builders::GetLinkAssociations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetLinkAssociations::into_paginator).
    pub fn get_link_associations(&self) -> fluent_builders::GetLinkAssociations<C, M, R> {
        fluent_builders::GetLinkAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLinks` operation.
    ///
    /// See [`GetLinks`](crate::client::fluent_builders::GetLinks) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetLinks::into_paginator).
    pub fn get_links(&self) -> fluent_builders::GetLinks<C, M, R> {
        fluent_builders::GetLinks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetNetworkResourceCounts` operation.
    ///
    /// See [`GetNetworkResourceCounts`](crate::client::fluent_builders::GetNetworkResourceCounts) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetNetworkResourceCounts::into_paginator).
    pub fn get_network_resource_counts(
        &self,
    ) -> fluent_builders::GetNetworkResourceCounts<C, M, R> {
        fluent_builders::GetNetworkResourceCounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetNetworkResourceRelationships` operation.
    ///
    /// See [`GetNetworkResourceRelationships`](crate::client::fluent_builders::GetNetworkResourceRelationships) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetNetworkResourceRelationships::into_paginator).
    pub fn get_network_resource_relationships(
        &self,
    ) -> fluent_builders::GetNetworkResourceRelationships<C, M, R> {
        fluent_builders::GetNetworkResourceRelationships::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetNetworkResources` operation.
    ///
    /// See [`GetNetworkResources`](crate::client::fluent_builders::GetNetworkResources) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetNetworkResources::into_paginator).
    pub fn get_network_resources(&self) -> fluent_builders::GetNetworkResources<C, M, R> {
        fluent_builders::GetNetworkResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetNetworkRoutes` operation.
    ///
    /// See [`GetNetworkRoutes`](crate::client::fluent_builders::GetNetworkRoutes) for more information about the
    /// operation and its arguments.
    pub fn get_network_routes(&self) -> fluent_builders::GetNetworkRoutes<C, M, R> {
        fluent_builders::GetNetworkRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetNetworkTelemetry` operation.
    ///
    /// See [`GetNetworkTelemetry`](crate::client::fluent_builders::GetNetworkTelemetry) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetNetworkTelemetry::into_paginator).
    pub fn get_network_telemetry(&self) -> fluent_builders::GetNetworkTelemetry<C, M, R> {
        fluent_builders::GetNetworkTelemetry::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResourcePolicy` operation.
    ///
    /// See [`GetResourcePolicy`](crate::client::fluent_builders::GetResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn get_resource_policy(&self) -> fluent_builders::GetResourcePolicy<C, M, R> {
        fluent_builders::GetResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRouteAnalysis` operation.
    ///
    /// See [`GetRouteAnalysis`](crate::client::fluent_builders::GetRouteAnalysis) for more information about the
    /// operation and its arguments.
    pub fn get_route_analysis(&self) -> fluent_builders::GetRouteAnalysis<C, M, R> {
        fluent_builders::GetRouteAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSites` operation.
    ///
    /// See [`GetSites`](crate::client::fluent_builders::GetSites) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetSites::into_paginator).
    pub fn get_sites(&self) -> fluent_builders::GetSites<C, M, R> {
        fluent_builders::GetSites::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSiteToSiteVpnAttachment` operation.
    ///
    /// See [`GetSiteToSiteVpnAttachment`](crate::client::fluent_builders::GetSiteToSiteVpnAttachment) for more information about the
    /// operation and its arguments.
    pub fn get_site_to_site_vpn_attachment(
        &self,
    ) -> fluent_builders::GetSiteToSiteVpnAttachment<C, M, R> {
        fluent_builders::GetSiteToSiteVpnAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTransitGatewayConnectPeerAssociations` operation.
    ///
    /// See [`GetTransitGatewayConnectPeerAssociations`](crate::client::fluent_builders::GetTransitGatewayConnectPeerAssociations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetTransitGatewayConnectPeerAssociations::into_paginator).
    pub fn get_transit_gateway_connect_peer_associations(
        &self,
    ) -> fluent_builders::GetTransitGatewayConnectPeerAssociations<C, M, R> {
        fluent_builders::GetTransitGatewayConnectPeerAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTransitGatewayRegistrations` operation.
    ///
    /// See [`GetTransitGatewayRegistrations`](crate::client::fluent_builders::GetTransitGatewayRegistrations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetTransitGatewayRegistrations::into_paginator).
    pub fn get_transit_gateway_registrations(
        &self,
    ) -> fluent_builders::GetTransitGatewayRegistrations<C, M, R> {
        fluent_builders::GetTransitGatewayRegistrations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVpcAttachment` operation.
    ///
    /// See [`GetVpcAttachment`](crate::client::fluent_builders::GetVpcAttachment) for more information about the
    /// operation and its arguments.
    pub fn get_vpc_attachment(&self) -> fluent_builders::GetVpcAttachment<C, M, R> {
        fluent_builders::GetVpcAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAttachments` operation.
    ///
    /// See [`ListAttachments`](crate::client::fluent_builders::ListAttachments) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAttachments::into_paginator).
    pub fn list_attachments(&self) -> fluent_builders::ListAttachments<C, M, R> {
        fluent_builders::ListAttachments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListConnectPeers` operation.
    ///
    /// See [`ListConnectPeers`](crate::client::fluent_builders::ListConnectPeers) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListConnectPeers::into_paginator).
    pub fn list_connect_peers(&self) -> fluent_builders::ListConnectPeers<C, M, R> {
        fluent_builders::ListConnectPeers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCoreNetworkPolicyVersions` operation.
    ///
    /// See [`ListCoreNetworkPolicyVersions`](crate::client::fluent_builders::ListCoreNetworkPolicyVersions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListCoreNetworkPolicyVersions::into_paginator).
    pub fn list_core_network_policy_versions(
        &self,
    ) -> fluent_builders::ListCoreNetworkPolicyVersions<C, M, R> {
        fluent_builders::ListCoreNetworkPolicyVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCoreNetworks` operation.
    ///
    /// See [`ListCoreNetworks`](crate::client::fluent_builders::ListCoreNetworks) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListCoreNetworks::into_paginator).
    pub fn list_core_networks(&self) -> fluent_builders::ListCoreNetworks<C, M, R> {
        fluent_builders::ListCoreNetworks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutCoreNetworkPolicy` operation.
    ///
    /// See [`PutCoreNetworkPolicy`](crate::client::fluent_builders::PutCoreNetworkPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_core_network_policy(&self) -> fluent_builders::PutCoreNetworkPolicy<C, M, R> {
        fluent_builders::PutCoreNetworkPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutResourcePolicy` operation.
    ///
    /// See [`PutResourcePolicy`](crate::client::fluent_builders::PutResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn put_resource_policy(&self) -> fluent_builders::PutResourcePolicy<C, M, R> {
        fluent_builders::PutResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterTransitGateway` operation.
    ///
    /// See [`RegisterTransitGateway`](crate::client::fluent_builders::RegisterTransitGateway) for more information about the
    /// operation and its arguments.
    pub fn register_transit_gateway(&self) -> fluent_builders::RegisterTransitGateway<C, M, R> {
        fluent_builders::RegisterTransitGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectAttachment` operation.
    ///
    /// See [`RejectAttachment`](crate::client::fluent_builders::RejectAttachment) for more information about the
    /// operation and its arguments.
    pub fn reject_attachment(&self) -> fluent_builders::RejectAttachment<C, M, R> {
        fluent_builders::RejectAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreCoreNetworkPolicyVersion` operation.
    ///
    /// See [`RestoreCoreNetworkPolicyVersion`](crate::client::fluent_builders::RestoreCoreNetworkPolicyVersion) for more information about the
    /// operation and its arguments.
    pub fn restore_core_network_policy_version(
        &self,
    ) -> fluent_builders::RestoreCoreNetworkPolicyVersion<C, M, R> {
        fluent_builders::RestoreCoreNetworkPolicyVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartRouteAnalysis` operation.
    ///
    /// See [`StartRouteAnalysis`](crate::client::fluent_builders::StartRouteAnalysis) for more information about the
    /// operation and its arguments.
    pub fn start_route_analysis(&self) -> fluent_builders::StartRouteAnalysis<C, M, R> {
        fluent_builders::StartRouteAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConnection` operation.
    ///
    /// See [`UpdateConnection`](crate::client::fluent_builders::UpdateConnection) for more information about the
    /// operation and its arguments.
    pub fn update_connection(&self) -> fluent_builders::UpdateConnection<C, M, R> {
        fluent_builders::UpdateConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCoreNetwork` operation.
    ///
    /// See [`UpdateCoreNetwork`](crate::client::fluent_builders::UpdateCoreNetwork) for more information about the
    /// operation and its arguments.
    pub fn update_core_network(&self) -> fluent_builders::UpdateCoreNetwork<C, M, R> {
        fluent_builders::UpdateCoreNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDevice` operation.
    ///
    /// See [`UpdateDevice`](crate::client::fluent_builders::UpdateDevice) for more information about the
    /// operation and its arguments.
    pub fn update_device(&self) -> fluent_builders::UpdateDevice<C, M, R> {
        fluent_builders::UpdateDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGlobalNetwork` operation.
    ///
    /// See [`UpdateGlobalNetwork`](crate::client::fluent_builders::UpdateGlobalNetwork) for more information about the
    /// operation and its arguments.
    pub fn update_global_network(&self) -> fluent_builders::UpdateGlobalNetwork<C, M, R> {
        fluent_builders::UpdateGlobalNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLink` operation.
    ///
    /// See [`UpdateLink`](crate::client::fluent_builders::UpdateLink) for more information about the
    /// operation and its arguments.
    pub fn update_link(&self) -> fluent_builders::UpdateLink<C, M, R> {
        fluent_builders::UpdateLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateNetworkResourceMetadata` operation.
    ///
    /// See [`UpdateNetworkResourceMetadata`](crate::client::fluent_builders::UpdateNetworkResourceMetadata) for more information about the
    /// operation and its arguments.
    pub fn update_network_resource_metadata(
        &self,
    ) -> fluent_builders::UpdateNetworkResourceMetadata<C, M, R> {
        fluent_builders::UpdateNetworkResourceMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSite` operation.
    ///
    /// See [`UpdateSite`](crate::client::fluent_builders::UpdateSite) for more information about the
    /// operation and its arguments.
    pub fn update_site(&self) -> fluent_builders::UpdateSite<C, M, R> {
        fluent_builders::UpdateSite::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateVpcAttachment` operation.
    ///
    /// See [`UpdateVpcAttachment`](crate::client::fluent_builders::UpdateVpcAttachment) for more information about the
    /// operation and its arguments.
    pub fn update_vpc_attachment(&self) -> fluent_builders::UpdateVpcAttachment<C, M, R> {
        fluent_builders::UpdateVpcAttachment::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptAttachment`.
    ///
    /// <p>Accepts a core network attachment request. </p>
    /// <p>Once the attachment request is accepted by a core network owner, the attachment is created and connected to a core network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptAttachment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_attachment_input::Builder,
    }
    impl<C, M, R> AcceptAttachment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptAttachmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptAttachmentInputOperationOutputAlias,
                crate::output::AcceptAttachmentOutput,
                crate::error::AcceptAttachmentError,
                crate::input::AcceptAttachmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the attachment. </p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment. </p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateConnectPeer`.
    ///
    /// <p>Associates a core network Connect peer with a device and optionally, with a link. </p>
    /// <p>If you specify a link, it must be associated with the specified device. You can only associate core network Connect peers that have been created on a core network Connect attachment on a core network. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateConnectPeer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_connect_peer_input::Builder,
    }
    impl<C, M, R> AssociateConnectPeer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateConnectPeer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateConnectPeerOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateConnectPeerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateConnectPeerInputOperationOutputAlias,
                crate::output::AssociateConnectPeerOutput,
                crate::error::AssociateConnectPeerError,
                crate::input::AssociateConnectPeerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of your global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of your global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the Connect peer.</p>
        pub fn connect_peer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connect_peer_id(input.into());
            self
        }
        /// <p>The ID of the Connect peer.</p>
        pub fn set_connect_peer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connect_peer_id(input);
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateCustomerGateway`.
    ///
    /// <p>Associates a customer gateway with a device and optionally, with a link. If you specify a link, it must be associated with the specified device. </p>
    /// <p>You can only associate customer gateways that are connected to a VPN attachment on a transit gateway. The transit gateway must be registered in your global network. When you register a transit gateway, customer gateways that are connected to the transit gateway are automatically included in the global network. To list customer gateways that are connected to a transit gateway, use the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnConnections.html">DescribeVpnConnections</a> EC2 API and filter by <code>transit-gateway-id</code>.</p>
    /// <p>You cannot associate a customer gateway with more than one device and link. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateCustomerGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_customer_gateway_input::Builder,
    }
    impl<C, M, R> AssociateCustomerGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateCustomerGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateCustomerGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateCustomerGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateCustomerGatewayInputOperationOutputAlias,
                crate::output::AssociateCustomerGatewayOutput,
                crate::error::AssociateCustomerGatewayError,
                crate::input::AssociateCustomerGatewayInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the customer gateway.</p>
        pub fn customer_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.customer_gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer gateway.</p>
        pub fn set_customer_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_customer_gateway_arn(input);
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateLink`.
    ///
    /// <p>Associates a link to a device. A device can be associated to multiple links and a link can be associated to multiple devices. The device and link must be in the same global network and the same site.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateLink<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_link_input::Builder,
    }
    impl<C, M, R> AssociateLink<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateLinkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateLinkInputOperationOutputAlias,
                crate::output::AssociateLinkOutput,
                crate::error::AssociateLinkError,
                crate::input::AssociateLinkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateTransitGatewayConnectPeer`.
    ///
    /// <p>Associates a transit gateway Connect peer with a device, and optionally, with a link. If you specify a link, it must be associated with the specified device. </p>
    /// <p>You can only associate transit gateway Connect peers that have been created on a transit gateway that's registered in your global network.</p>
    /// <p>You cannot associate a transit gateway Connect peer with more than one device and link. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateTransitGatewayConnectPeer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_transit_gateway_connect_peer_input::Builder,
    }
    impl<C, M, R> AssociateTransitGatewayConnectPeer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateTransitGatewayConnectPeer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateTransitGatewayConnectPeerOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateTransitGatewayConnectPeerError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateTransitGatewayConnectPeerInputOperationOutputAlias,
                crate::output::AssociateTransitGatewayConnectPeerOutput,
                crate::error::AssociateTransitGatewayConnectPeerError,
                crate::input::AssociateTransitGatewayConnectPeerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Connect peer.</p>
        pub fn transit_gateway_connect_peer_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.transit_gateway_connect_peer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Connect peer.</p>
        pub fn set_transit_gateway_connect_peer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_connect_peer_arn(input);
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConnectAttachment`.
    ///
    /// <p>Creates a core network Connect attachment from a specified core network attachment. </p>
    /// <p>A core network Connect attachment is a GRE-based tunnel attachment that you can use to establish a connection between a core network and an appliance. A core network Connect attachment uses an existing VPC attachment as the underlying transport mechanism.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConnectAttachment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_connect_attachment_input::Builder,
    }
    impl<C, M, R> CreateConnectAttachment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConnectAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectAttachmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConnectAttachmentInputOperationOutputAlias,
                crate::output::CreateConnectAttachmentOutput,
                crate::error::CreateConnectAttachmentError,
                crate::input::CreateConnectAttachmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network where you want to create the attachment. </p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network where you want to create the attachment. </p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The Region where the edge is located.</p>
        pub fn edge_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.edge_location(input.into());
            self
        }
        /// <p>The Region where the edge is located.</p>
        pub fn set_edge_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_edge_location(input);
            self
        }
        /// <p>The ID of the attachment between the two connections.</p>
        pub fn transport_attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transport_attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment between the two connections.</p>
        pub fn set_transport_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transport_attachment_id(input);
            self
        }
        /// <p>Options for creating an attachment.</p>
        pub fn options(mut self, input: crate::model::ConnectAttachmentOptions) -> Self {
            self.inner = self.inner.options(input);
            self
        }
        /// <p>Options for creating an attachment.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<crate::model::ConnectAttachmentOptions>,
        ) -> Self {
            self.inner = self.inner.set_options(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of key-value tags associated with the request.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The list of key-value tags associated with the request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConnection`.
    ///
    /// <p>Creates a connection between two devices. The devices can be a physical or virtual appliance that connects to a third-party appliance in a VPC, or a physical appliance that connects to another physical appliance in an on-premises network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_connection_input::Builder,
    }
    impl<C, M, R> CreateConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConnectionInputOperationOutputAlias,
                crate::output::CreateConnectionOutput,
                crate::error::CreateConnectionError,
                crate::input::CreateConnectionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the first device in the connection.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the first device in the connection.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The ID of the second device in the connection.</p>
        pub fn connected_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connected_device_id(input.into());
            self
        }
        /// <p>The ID of the second device in the connection.</p>
        pub fn set_connected_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connected_device_id(input);
            self
        }
        /// <p>The ID of the link for the first device.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link for the first device.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
        /// <p>The ID of the link for the second device.</p>
        pub fn connected_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connected_link_id(input.into());
            self
        }
        /// <p>The ID of the link for the second device.</p>
        pub fn set_connected_link_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connected_link_id(input);
            self
        }
        /// <p>A description of the connection.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the connection.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConnectPeer`.
    ///
    /// <p>Creates a core network connect peer for a specified core network connect attachment between a core network and an appliance. The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConnectPeer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_connect_peer_input::Builder,
    }
    impl<C, M, R> CreateConnectPeer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConnectPeer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectPeerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectPeerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConnectPeerInputOperationOutputAlias,
                crate::output::CreateConnectPeerOutput,
                crate::error::CreateConnectPeerError,
                crate::input::CreateConnectPeerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection attachment.</p>
        pub fn connect_attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connect_attachment_id(input.into());
            self
        }
        /// <p>The ID of the connection attachment.</p>
        pub fn set_connect_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connect_attachment_id(input);
            self
        }
        /// <p>A Connect peer core network address.</p>
        pub fn core_network_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_address(input.into());
            self
        }
        /// <p>A Connect peer core network address.</p>
        pub fn set_core_network_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_address(input);
            self
        }
        /// <p>The Connect peer address.</p>
        pub fn peer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.peer_address(input.into());
            self
        }
        /// <p>The Connect peer address.</p>
        pub fn set_peer_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_peer_address(input);
            self
        }
        /// <p>The Connect peer BGP options.</p>
        pub fn bgp_options(mut self, input: crate::model::BgpOptions) -> Self {
            self.inner = self.inner.bgp_options(input);
            self
        }
        /// <p>The Connect peer BGP options.</p>
        pub fn set_bgp_options(
            mut self,
            input: std::option::Option<crate::model::BgpOptions>,
        ) -> Self {
            self.inner = self.inner.set_bgp_options(input);
            self
        }
        /// Appends an item to `InsideCidrBlocks`.
        ///
        /// To override the contents of this collection use [`set_inside_cidr_blocks`](Self::set_inside_cidr_blocks).
        ///
        /// <p>The inside IP addresses used for BGP peering.</p>
        pub fn inside_cidr_blocks(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.inside_cidr_blocks(input.into());
            self
        }
        /// <p>The inside IP addresses used for BGP peering.</p>
        pub fn set_inside_cidr_blocks(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_inside_cidr_blocks(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the peer request.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags associated with the peer request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCoreNetwork`.
    ///
    /// <p>Creates a core network as part of your global network, and optionally, with a core network policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCoreNetwork<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_core_network_input::Builder,
    }
    impl<C, M, R> CreateCoreNetwork<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCoreNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCoreNetworkOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCoreNetworkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCoreNetworkInputOperationOutputAlias,
                crate::output::CreateCoreNetworkOutput,
                crate::error::CreateCoreNetworkError,
                crate::input::CreateCoreNetworkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network that a core network will be a part of. </p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network that a core network will be a part of. </p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The description of a core network.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of a core network.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value tags associated with a core network request.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Key-value tags associated with a core network request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The policy document for creating a core network.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(input.into());
            self
        }
        /// <p>The policy document for creating a core network.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
        /// <p>The client token associated with a core network request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The client token associated with a core network request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDevice`.
    ///
    /// <p>Creates a new device in a global network. If you specify both a site ID and a location, the location of the site is used for visualization in the Network Manager console.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_device_input::Builder,
    }
    impl<C, M, R> CreateDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDeviceInputOperationOutputAlias,
                crate::output::CreateDeviceOutput,
                crate::error::CreateDeviceError,
                crate::input::CreateDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The Amazon Web Services location of the device, if applicable. For an on-premises device, you can omit this parameter.</p>
        pub fn aws_location(mut self, input: crate::model::AwsLocation) -> Self {
            self.inner = self.inner.aws_location(input);
            self
        }
        /// <p>The Amazon Web Services location of the device, if applicable. For an on-premises device, you can omit this parameter.</p>
        pub fn set_aws_location(
            mut self,
            input: std::option::Option<crate::model::AwsLocation>,
        ) -> Self {
            self.inner = self.inner.set_aws_location(input);
            self
        }
        /// <p>A description of the device.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the device.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The type of the device.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.r#type(input.into());
            self
        }
        /// <p>The type of the device.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The vendor of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn vendor(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vendor(input.into());
            self
        }
        /// <p>The vendor of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn set_vendor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vendor(input);
            self
        }
        /// <p>The model of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn model(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model(input.into());
            self
        }
        /// <p>The model of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn set_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model(input);
            self
        }
        /// <p>The serial number of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.serial_number(input.into());
            self
        }
        /// <p>The serial number of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_serial_number(input);
            self
        }
        /// <p>The location of the device.</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.inner = self.inner.location(input);
            self
        }
        /// <p>The location of the device.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGlobalNetwork`.
    ///
    /// <p>Creates a new, empty global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGlobalNetwork<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_global_network_input::Builder,
    }
    impl<C, M, R> CreateGlobalNetwork<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGlobalNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGlobalNetworkOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGlobalNetworkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGlobalNetworkInputOperationOutputAlias,
                crate::output::CreateGlobalNetworkOutput,
                crate::error::CreateGlobalNetworkError,
                crate::input::CreateGlobalNetworkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A description of the global network.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the global network.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLink`.
    ///
    /// <p>Creates a new link for a specified site.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLink<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_link_input::Builder,
    }
    impl<C, M, R> CreateLink<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLinkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLinkInputOperationOutputAlias,
                crate::output::CreateLinkOutput,
                crate::error::CreateLinkError,
                crate::input::CreateLinkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>A description of the link.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the link.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The type of the link.</p>
        /// <p>Constraints: Maximum length of 128 characters. Cannot include the following characters: | \ ^</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.r#type(input.into());
            self
        }
        /// <p>The type of the link.</p>
        /// <p>Constraints: Maximum length of 128 characters. Cannot include the following characters: | \ ^</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p> The upload speed and download speed in Mbps. </p>
        pub fn bandwidth(mut self, input: crate::model::Bandwidth) -> Self {
            self.inner = self.inner.bandwidth(input);
            self
        }
        /// <p> The upload speed and download speed in Mbps. </p>
        pub fn set_bandwidth(
            mut self,
            input: std::option::Option<crate::model::Bandwidth>,
        ) -> Self {
            self.inner = self.inner.set_bandwidth(input);
            self
        }
        /// <p>The provider of the link.</p>
        /// <p>Constraints: Maximum length of 128 characters. Cannot include the following characters: | \ ^</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider(input.into());
            self
        }
        /// <p>The provider of the link.</p>
        /// <p>Constraints: Maximum length of 128 characters. Cannot include the following characters: | \ ^</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_provider(input);
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSite`.
    ///
    /// <p>Creates a new site in a global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSite<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_site_input::Builder,
    }
    impl<C, M, R> CreateSite<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSite`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSiteOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSiteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSiteInputOperationOutputAlias,
                crate::output::CreateSiteOutput,
                crate::error::CreateSiteError,
                crate::input::CreateSiteInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>A description of your site.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of your site.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The site location. This information is used for visualization in the Network Manager console. If you specify the address, the latitude and longitude are automatically calculated.</p>
        /// <ul>
        /// <li> <p> <code>Address</code>: The physical address of the site.</p> </li>
        /// <li> <p> <code>Latitude</code>: The latitude of the site. </p> </li>
        /// <li> <p> <code>Longitude</code>: The longitude of the site.</p> </li>
        /// </ul>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.inner = self.inner.location(input);
            self
        }
        /// <p>The site location. This information is used for visualization in the Network Manager console. If you specify the address, the latitude and longitude are automatically calculated.</p>
        /// <ul>
        /// <li> <p> <code>Address</code>: The physical address of the site.</p> </li>
        /// <li> <p> <code>Latitude</code>: The latitude of the site. </p> </li>
        /// <li> <p> <code>Longitude</code>: The longitude of the site.</p> </li>
        /// </ul>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSiteToSiteVpnAttachment`.
    ///
    /// <p>Creates a site-to-site VPN attachment on an edge location of a core network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSiteToSiteVpnAttachment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_site_to_site_vpn_attachment_input::Builder,
    }
    impl<C, M, R> CreateSiteToSiteVpnAttachment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSiteToSiteVpnAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSiteToSiteVpnAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSiteToSiteVpnAttachmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSiteToSiteVpnAttachmentInputOperationOutputAlias,
                crate::output::CreateSiteToSiteVpnAttachmentOutput,
                crate::error::CreateSiteToSiteVpnAttachmentError,
                crate::input::CreateSiteToSiteVpnAttachmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network where you're creating a site-to-site VPN attachment.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network where you're creating a site-to-site VPN attachment.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ARN identifying the VPN attachment.</p>
        pub fn vpn_connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpn_connection_arn(input.into());
            self
        }
        /// <p>The ARN identifying the VPN attachment.</p>
        pub fn set_vpn_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpn_connection_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the request.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags associated with the request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVpcAttachment`.
    ///
    /// <p>Creates a VPC attachment on an edge location of a core network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateVpcAttachment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_vpc_attachment_input::Builder,
    }
    impl<C, M, R> CreateVpcAttachment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateVpcAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVpcAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVpcAttachmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateVpcAttachmentInputOperationOutputAlias,
                crate::output::CreateVpcAttachmentOutput,
                crate::error::CreateVpcAttachmentError,
                crate::input::CreateVpcAttachmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network for the VPC attachment.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network for the VPC attachment.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ARN of the VPC.</p>
        pub fn vpc_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_arn(input.into());
            self
        }
        /// <p>The ARN of the VPC.</p>
        pub fn set_vpc_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_arn(input);
            self
        }
        /// Appends an item to `SubnetArns`.
        ///
        /// To override the contents of this collection use [`set_subnet_arns`](Self::set_subnet_arns).
        ///
        /// <p>The subnet ARN of the VPC attachment.</p>
        pub fn subnet_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_arns(input.into());
            self
        }
        /// <p>The subnet ARN of the VPC attachment.</p>
        pub fn set_subnet_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_arns(input);
            self
        }
        /// <p>Options for the VPC attachment.</p>
        pub fn options(mut self, input: crate::model::VpcOptions) -> Self {
            self.inner = self.inner.options(input);
            self
        }
        /// <p>Options for the VPC attachment.</p>
        pub fn set_options(mut self, input: std::option::Option<crate::model::VpcOptions>) -> Self {
            self.inner = self.inner.set_options(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value tags associated with the request.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The key-value tags associated with the request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAttachment`.
    ///
    /// <p>Deletes an attachment. Supports all attachment types.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAttachment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_attachment_input::Builder,
    }
    impl<C, M, R> DeleteAttachment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAttachmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAttachmentInputOperationOutputAlias,
                crate::output::DeleteAttachmentOutput,
                crate::error::DeleteAttachmentError,
                crate::input::DeleteAttachmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the attachment to delete.</p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment to delete.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnection`.
    ///
    /// <p>Deletes the specified connection in your global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_connection_input::Builder,
    }
    impl<C, M, R> DeleteConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConnectionInputOperationOutputAlias,
                crate::output::DeleteConnectionOutput,
                crate::error::DeleteConnectionError,
                crate::input::DeleteConnectionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnectPeer`.
    ///
    /// <p>Deletes a Connect peer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConnectPeer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_connect_peer_input::Builder,
    }
    impl<C, M, R> DeleteConnectPeer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConnectPeer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectPeerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectPeerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConnectPeerInputOperationOutputAlias,
                crate::output::DeleteConnectPeerOutput,
                crate::error::DeleteConnectPeerError,
                crate::input::DeleteConnectPeerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the deleted Connect peer.</p>
        pub fn connect_peer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connect_peer_id(input.into());
            self
        }
        /// <p>The ID of the deleted Connect peer.</p>
        pub fn set_connect_peer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connect_peer_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCoreNetwork`.
    ///
    /// <p>Deletes a core network along with all core network policies. This can only be done if there are no attachments on a core network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCoreNetwork<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_core_network_input::Builder,
    }
    impl<C, M, R> DeleteCoreNetwork<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCoreNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCoreNetworkOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCoreNetworkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCoreNetworkInputOperationOutputAlias,
                crate::output::DeleteCoreNetworkOutput,
                crate::error::DeleteCoreNetworkError,
                crate::input::DeleteCoreNetworkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The network ID of the deleted core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The network ID of the deleted core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCoreNetworkPolicyVersion`.
    ///
    /// <p>Deletes a policy version from a core network. You can't delete the current LIVE policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCoreNetworkPolicyVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_core_network_policy_version_input::Builder,
    }
    impl<C, M, R> DeleteCoreNetworkPolicyVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCoreNetworkPolicyVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCoreNetworkPolicyVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCoreNetworkPolicyVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCoreNetworkPolicyVersionInputOperationOutputAlias,
                crate::output::DeleteCoreNetworkPolicyVersionOutput,
                crate::error::DeleteCoreNetworkPolicyVersionError,
                crate::input::DeleteCoreNetworkPolicyVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network for the deleted policy.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network for the deleted policy.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The version ID of the deleted policy.</p>
        pub fn policy_version_id(mut self, input: i32) -> Self {
            self.inner = self.inner.policy_version_id(input);
            self
        }
        /// <p>The version ID of the deleted policy.</p>
        pub fn set_policy_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_policy_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDevice`.
    ///
    /// <p>Deletes an existing device. You must first disassociate the device from any links and customer gateways.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_device_input::Builder,
    }
    impl<C, M, R> DeleteDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDeviceInputOperationOutputAlias,
                crate::output::DeleteDeviceOutput,
                crate::error::DeleteDeviceError,
                crate::input::DeleteDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGlobalNetwork`.
    ///
    /// <p>Deletes an existing global network. You must first delete all global network objects (devices, links, and sites) and deregister all transit gateways.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGlobalNetwork<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_global_network_input::Builder,
    }
    impl<C, M, R> DeleteGlobalNetwork<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGlobalNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGlobalNetworkOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGlobalNetworkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGlobalNetworkInputOperationOutputAlias,
                crate::output::DeleteGlobalNetworkOutput,
                crate::error::DeleteGlobalNetworkError,
                crate::input::DeleteGlobalNetworkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLink`.
    ///
    /// <p>Deletes an existing link. You must first disassociate the link from any devices and customer gateways.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLink<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_link_input::Builder,
    }
    impl<C, M, R> DeleteLink<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLinkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLinkInputOperationOutputAlias,
                crate::output::DeleteLinkOutput,
                crate::error::DeleteLinkError,
                crate::input::DeleteLinkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourcePolicy`.
    ///
    /// <p>Deletes a resource policy for the specified resource. This revokes the access of the principals specified in the resource policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_policy_input::Builder,
    }
    impl<C, M, R> DeleteResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourcePolicyInputOperationOutputAlias,
                crate::output::DeleteResourcePolicyOutput,
                crate::error::DeleteResourcePolicyError,
                crate::input::DeleteResourcePolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the policy to delete.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the policy to delete.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSite`.
    ///
    /// <p>Deletes an existing site. The site cannot be associated with any device or link.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSite<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_site_input::Builder,
    }
    impl<C, M, R> DeleteSite<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSite`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSiteOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSiteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSiteInputOperationOutputAlias,
                crate::output::DeleteSiteOutput,
                crate::error::DeleteSiteError,
                crate::input::DeleteSiteInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterTransitGateway`.
    ///
    /// <p>Deregisters a transit gateway from your global network. This action does not delete your transit gateway, or modify any of its attachments. This action removes any customer gateway associations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterTransitGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_transit_gateway_input::Builder,
    }
    impl<C, M, R> DeregisterTransitGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterTransitGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterTransitGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterTransitGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterTransitGatewayInputOperationOutputAlias,
                crate::output::DeregisterTransitGatewayOutput,
                crate::error::DeregisterTransitGatewayError,
                crate::input::DeregisterTransitGatewayInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
        pub fn transit_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transit_gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
        pub fn set_transit_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGlobalNetworks`.
    ///
    /// <p>Describes one or more global networks. By default, all global networks are described. To describe the objects in your global network, you must use the appropriate <code>Get*</code> action. For example, to list the transit gateways in your global network, use <code>GetTransitGatewayRegistrations</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeGlobalNetworks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_global_networks_input::Builder,
    }
    impl<C, M, R> DescribeGlobalNetworks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeGlobalNetworks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGlobalNetworksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGlobalNetworksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeGlobalNetworksInputOperationOutputAlias,
                crate::output::DescribeGlobalNetworksOutput,
                crate::error::DescribeGlobalNetworksError,
                crate::input::DescribeGlobalNetworksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeGlobalNetworksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeGlobalNetworksPaginator<C, M, R> {
            crate::paginator::DescribeGlobalNetworksPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `GlobalNetworkIds`.
        ///
        /// To override the contents of this collection use [`set_global_network_ids`](Self::set_global_network_ids).
        ///
        /// <p>The IDs of one or more global networks. The maximum is 10.</p>
        pub fn global_network_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_ids(input.into());
            self
        }
        /// <p>The IDs of one or more global networks. The maximum is 10.</p>
        pub fn set_global_network_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_global_network_ids(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateConnectPeer`.
    ///
    /// <p>Disassociates a core network Connect peer from a device and a link. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateConnectPeer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_connect_peer_input::Builder,
    }
    impl<C, M, R> DisassociateConnectPeer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateConnectPeer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateConnectPeerOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateConnectPeerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateConnectPeerInputOperationOutputAlias,
                crate::output::DisassociateConnectPeerOutput,
                crate::error::DisassociateConnectPeerError,
                crate::input::DisassociateConnectPeerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the Connect peer to disassociate from a device.</p>
        pub fn connect_peer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connect_peer_id(input.into());
            self
        }
        /// <p>The ID of the Connect peer to disassociate from a device.</p>
        pub fn set_connect_peer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connect_peer_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateCustomerGateway`.
    ///
    /// <p>Disassociates a customer gateway from a device and a link.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateCustomerGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_customer_gateway_input::Builder,
    }
    impl<C, M, R> DisassociateCustomerGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateCustomerGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateCustomerGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateCustomerGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateCustomerGatewayInputOperationOutputAlias,
                crate::output::DisassociateCustomerGatewayOutput,
                crate::error::DisassociateCustomerGatewayError,
                crate::input::DisassociateCustomerGatewayInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer gateway.</p>
        pub fn customer_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.customer_gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer gateway.</p>
        pub fn set_customer_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_customer_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateLink`.
    ///
    /// <p>Disassociates an existing device from a link. You must first disassociate any customer gateways that are associated with the link.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateLink<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_link_input::Builder,
    }
    impl<C, M, R> DisassociateLink<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateLinkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateLinkInputOperationOutputAlias,
                crate::output::DisassociateLinkOutput,
                crate::error::DisassociateLinkError,
                crate::input::DisassociateLinkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateTransitGatewayConnectPeer`.
    ///
    /// <p>Disassociates a transit gateway Connect peer from a device and link.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateTransitGatewayConnectPeer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_transit_gateway_connect_peer_input::Builder,
    }
    impl<C, M, R> DisassociateTransitGatewayConnectPeer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateTransitGatewayConnectPeer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateTransitGatewayConnectPeerOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateTransitGatewayConnectPeerError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateTransitGatewayConnectPeerInputOperationOutputAlias,
                crate::output::DisassociateTransitGatewayConnectPeerOutput,
                crate::error::DisassociateTransitGatewayConnectPeerError,
                crate::input::DisassociateTransitGatewayConnectPeerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway Connect peer.</p>
        pub fn transit_gateway_connect_peer_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.transit_gateway_connect_peer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway Connect peer.</p>
        pub fn set_transit_gateway_connect_peer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_connect_peer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExecuteCoreNetworkChangeSet`.
    ///
    /// <p>Executes a change set on your core network. Deploys changes globally based on the policy submitted..</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExecuteCoreNetworkChangeSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::execute_core_network_change_set_input::Builder,
    }
    impl<C, M, R> ExecuteCoreNetworkChangeSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExecuteCoreNetworkChangeSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExecuteCoreNetworkChangeSetOutput,
            aws_smithy_http::result::SdkError<crate::error::ExecuteCoreNetworkChangeSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExecuteCoreNetworkChangeSetInputOperationOutputAlias,
                crate::output::ExecuteCoreNetworkChangeSetOutput,
                crate::error::ExecuteCoreNetworkChangeSetError,
                crate::input::ExecuteCoreNetworkChangeSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ID of the policy version.</p>
        pub fn policy_version_id(mut self, input: i32) -> Self {
            self.inner = self.inner.policy_version_id(input);
            self
        }
        /// <p>The ID of the policy version.</p>
        pub fn set_policy_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_policy_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConnectAttachment`.
    ///
    /// <p>Returns information about a core network Connect attachment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConnectAttachment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_connect_attachment_input::Builder,
    }
    impl<C, M, R> GetConnectAttachment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConnectAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConnectAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConnectAttachmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConnectAttachmentInputOperationOutputAlias,
                crate::output::GetConnectAttachmentOutput,
                crate::error::GetConnectAttachmentError,
                crate::input::GetConnectAttachmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the attachment.</p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConnections`.
    ///
    /// <p>Gets information about one or more of your connections in a global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConnections<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_connections_input::Builder,
    }
    impl<C, M, R> GetConnections<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConnectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConnectionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConnectionsInputOperationOutputAlias,
                crate::output::GetConnectionsOutput,
                crate::error::GetConnectionsError,
                crate::input::GetConnectionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetConnectionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetConnectionsPaginator<C, M, R> {
            crate::paginator::GetConnectionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// Appends an item to `ConnectionIds`.
        ///
        /// To override the contents of this collection use [`set_connection_ids`](Self::set_connection_ids).
        ///
        /// <p>One or more connection IDs.</p>
        pub fn connection_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_ids(input.into());
            self
        }
        /// <p>One or more connection IDs.</p>
        pub fn set_connection_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_connection_ids(input);
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConnectPeer`.
    ///
    /// <p>Returns information about a core network Connect peer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConnectPeer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_connect_peer_input::Builder,
    }
    impl<C, M, R> GetConnectPeer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConnectPeer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConnectPeerOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConnectPeerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConnectPeerInputOperationOutputAlias,
                crate::output::GetConnectPeerOutput,
                crate::error::GetConnectPeerError,
                crate::input::GetConnectPeerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Connect peer.</p>
        pub fn connect_peer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connect_peer_id(input.into());
            self
        }
        /// <p>The ID of the Connect peer.</p>
        pub fn set_connect_peer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connect_peer_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConnectPeerAssociations`.
    ///
    /// <p>Returns information about a core network Connect peer associations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConnectPeerAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_connect_peer_associations_input::Builder,
    }
    impl<C, M, R> GetConnectPeerAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConnectPeerAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConnectPeerAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConnectPeerAssociationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConnectPeerAssociationsInputOperationOutputAlias,
                crate::output::GetConnectPeerAssociationsOutput,
                crate::error::GetConnectPeerAssociationsError,
                crate::input::GetConnectPeerAssociationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetConnectPeerAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetConnectPeerAssociationsPaginator<C, M, R> {
            crate::paginator::GetConnectPeerAssociationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// Appends an item to `ConnectPeerIds`.
        ///
        /// To override the contents of this collection use [`set_connect_peer_ids`](Self::set_connect_peer_ids).
        ///
        /// <p>The IDs of the Connect peers.</p>
        pub fn connect_peer_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connect_peer_ids(input.into());
            self
        }
        /// <p>The IDs of the Connect peers.</p>
        pub fn set_connect_peer_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_connect_peer_ids(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCoreNetwork`.
    ///
    /// <p>Returns information about a core network. By default it returns the LIVE policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCoreNetwork<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_core_network_input::Builder,
    }
    impl<C, M, R> GetCoreNetwork<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCoreNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCoreNetworkOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCoreNetworkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCoreNetworkInputOperationOutputAlias,
                crate::output::GetCoreNetworkOutput,
                crate::error::GetCoreNetworkError,
                crate::input::GetCoreNetworkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCoreNetworkChangeSet`.
    ///
    /// <p>Returns a change set between the LIVE core network policy and a submitted policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCoreNetworkChangeSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_core_network_change_set_input::Builder,
    }
    impl<C, M, R> GetCoreNetworkChangeSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCoreNetworkChangeSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCoreNetworkChangeSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCoreNetworkChangeSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCoreNetworkChangeSetInputOperationOutputAlias,
                crate::output::GetCoreNetworkChangeSetOutput,
                crate::error::GetCoreNetworkChangeSetError,
                crate::input::GetCoreNetworkChangeSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetCoreNetworkChangeSetPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetCoreNetworkChangeSetPaginator<C, M, R> {
            crate::paginator::GetCoreNetworkChangeSetPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ID of the policy version.</p>
        pub fn policy_version_id(mut self, input: i32) -> Self {
            self.inner = self.inner.policy_version_id(input);
            self
        }
        /// <p>The ID of the policy version.</p>
        pub fn set_policy_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_policy_version_id(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCoreNetworkPolicy`.
    ///
    /// <p>Gets details about a core network policy. You can get details about your current live policy or any previous policy version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCoreNetworkPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_core_network_policy_input::Builder,
    }
    impl<C, M, R> GetCoreNetworkPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCoreNetworkPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCoreNetworkPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCoreNetworkPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCoreNetworkPolicyInputOperationOutputAlias,
                crate::output::GetCoreNetworkPolicyOutput,
                crate::error::GetCoreNetworkPolicyError,
                crate::input::GetCoreNetworkPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ID of a core network policy version.</p>
        pub fn policy_version_id(mut self, input: i32) -> Self {
            self.inner = self.inner.policy_version_id(input);
            self
        }
        /// <p>The ID of a core network policy version.</p>
        pub fn set_policy_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_policy_version_id(input);
            self
        }
        /// <p>The alias of a core network policy </p>
        pub fn alias(mut self, input: crate::model::CoreNetworkPolicyAlias) -> Self {
            self.inner = self.inner.alias(input);
            self
        }
        /// <p>The alias of a core network policy </p>
        pub fn set_alias(
            mut self,
            input: std::option::Option<crate::model::CoreNetworkPolicyAlias>,
        ) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCustomerGatewayAssociations`.
    ///
    /// <p>Gets the association information for customer gateways that are associated with devices and links in your global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCustomerGatewayAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_customer_gateway_associations_input::Builder,
    }
    impl<C, M, R> GetCustomerGatewayAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCustomerGatewayAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCustomerGatewayAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCustomerGatewayAssociationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCustomerGatewayAssociationsInputOperationOutputAlias,
                crate::output::GetCustomerGatewayAssociationsOutput,
                crate::error::GetCustomerGatewayAssociationsError,
                crate::input::GetCustomerGatewayAssociationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetCustomerGatewayAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetCustomerGatewayAssociationsPaginator<C, M, R> {
            crate::paginator::GetCustomerGatewayAssociationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// Appends an item to `CustomerGatewayArns`.
        ///
        /// To override the contents of this collection use [`set_customer_gateway_arns`](Self::set_customer_gateway_arns).
        ///
        /// <p>One or more customer gateway Amazon Resource Names (ARNs). The maximum is 10.</p>
        pub fn customer_gateway_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.customer_gateway_arns(input.into());
            self
        }
        /// <p>One or more customer gateway Amazon Resource Names (ARNs). The maximum is 10.</p>
        pub fn set_customer_gateway_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_customer_gateway_arns(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDevices`.
    ///
    /// <p>Gets information about one or more of your devices in a global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDevices<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_devices_input::Builder,
    }
    impl<C, M, R> GetDevices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDevicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDevicesInputOperationOutputAlias,
                crate::output::GetDevicesOutput,
                crate::error::GetDevicesError,
                crate::input::GetDevicesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetDevicesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetDevicesPaginator<C, M, R> {
            crate::paginator::GetDevicesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// Appends an item to `DeviceIds`.
        ///
        /// To override the contents of this collection use [`set_device_ids`](Self::set_device_ids).
        ///
        /// <p>One or more device IDs. The maximum is 10.</p>
        pub fn device_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_ids(input.into());
            self
        }
        /// <p>One or more device IDs. The maximum is 10.</p>
        pub fn set_device_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_ids(input);
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLinkAssociations`.
    ///
    /// <p>Gets the link associations for a device or a link. Either the device ID or the link ID must be specified.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLinkAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_link_associations_input::Builder,
    }
    impl<C, M, R> GetLinkAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLinkAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLinkAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLinkAssociationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLinkAssociationsInputOperationOutputAlias,
                crate::output::GetLinkAssociationsOutput,
                crate::error::GetLinkAssociationsError,
                crate::input::GetLinkAssociationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetLinkAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetLinkAssociationsPaginator<C, M, R> {
            crate::paginator::GetLinkAssociationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLinks`.
    ///
    /// <p>Gets information about one or more links in a specified global network.</p>
    /// <p>If you specify the site ID, you cannot specify the type or provider in the same request. You can specify the type and provider in the same request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLinks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_links_input::Builder,
    }
    impl<C, M, R> GetLinks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLinks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLinksOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLinksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLinksInputOperationOutputAlias,
                crate::output::GetLinksOutput,
                crate::error::GetLinksError,
                crate::input::GetLinksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetLinksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetLinksPaginator<C, M, R> {
            crate::paginator::GetLinksPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// Appends an item to `LinkIds`.
        ///
        /// To override the contents of this collection use [`set_link_ids`](Self::set_link_ids).
        ///
        /// <p>One or more link IDs. The maximum is 10.</p>
        pub fn link_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_ids(input.into());
            self
        }
        /// <p>One or more link IDs. The maximum is 10.</p>
        pub fn set_link_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_link_ids(input);
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
        /// <p>The link type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.r#type(input.into());
            self
        }
        /// <p>The link type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The link provider.</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider(input.into());
            self
        }
        /// <p>The link provider.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_provider(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNetworkResourceCounts`.
    ///
    /// <p>Gets the count of network resources, by resource type, for the specified global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetNetworkResourceCounts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_network_resource_counts_input::Builder,
    }
    impl<C, M, R> GetNetworkResourceCounts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetNetworkResourceCounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNetworkResourceCountsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNetworkResourceCountsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetNetworkResourceCountsInputOperationOutputAlias,
                crate::output::GetNetworkResourceCountsOutput,
                crate::error::GetNetworkResourceCountsError,
                crate::input::GetNetworkResourceCountsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetNetworkResourceCountsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetNetworkResourceCountsPaginator<C, M, R> {
            crate::paginator::GetNetworkResourceCountsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The resource type.</p>
        /// <p>The following are the supported resource types for Direct Connect:</p>
        /// <ul>
        /// <li> <p> <code>dxcon</code> </p> </li>
        /// <li> <p> <code>dx-gateway</code> </p> </li>
        /// <li> <p> <code>dx-vif</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Network Manager:</p>
        /// <ul>
        /// <li> <p> <code>connection</code> </p> </li>
        /// <li> <p> <code>device</code> </p> </li>
        /// <li> <p> <code>link</code> </p> </li>
        /// <li> <p> <code>site</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Amazon VPC:</p>
        /// <ul>
        /// <li> <p> <code>customer-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway-attachment</code> </p> </li>
        /// <li> <p> <code>transit-gateway-connect-peer</code> </p> </li>
        /// <li> <p> <code>transit-gateway-route-table</code> </p> </li>
        /// <li> <p> <code>vpn-connection</code> </p> </li>
        /// </ul>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The resource type.</p>
        /// <p>The following are the supported resource types for Direct Connect:</p>
        /// <ul>
        /// <li> <p> <code>dxcon</code> </p> </li>
        /// <li> <p> <code>dx-gateway</code> </p> </li>
        /// <li> <p> <code>dx-vif</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Network Manager:</p>
        /// <ul>
        /// <li> <p> <code>connection</code> </p> </li>
        /// <li> <p> <code>device</code> </p> </li>
        /// <li> <p> <code>link</code> </p> </li>
        /// <li> <p> <code>site</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Amazon VPC:</p>
        /// <ul>
        /// <li> <p> <code>customer-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway-attachment</code> </p> </li>
        /// <li> <p> <code>transit-gateway-connect-peer</code> </p> </li>
        /// <li> <p> <code>transit-gateway-route-table</code> </p> </li>
        /// <li> <p> <code>vpn-connection</code> </p> </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNetworkResourceRelationships`.
    ///
    /// <p>Gets the network resource relationships for the specified global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetNetworkResourceRelationships<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_network_resource_relationships_input::Builder,
    }
    impl<C, M, R> GetNetworkResourceRelationships<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetNetworkResourceRelationships`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNetworkResourceRelationshipsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNetworkResourceRelationshipsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetNetworkResourceRelationshipsInputOperationOutputAlias,
                crate::output::GetNetworkResourceRelationshipsOutput,
                crate::error::GetNetworkResourceRelationshipsError,
                crate::input::GetNetworkResourceRelationshipsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetNetworkResourceRelationshipsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetNetworkResourceRelationshipsPaginator<C, M, R> {
            crate::paginator::GetNetworkResourceRelationshipsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ARN of the registered gateway.</p>
        pub fn registered_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registered_gateway_arn(input.into());
            self
        }
        /// <p>The ARN of the registered gateway.</p>
        pub fn set_registered_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_registered_gateway_arn(input);
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_region(input.into());
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_aws_region(input);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The resource type.</p>
        /// <p>The following are the supported resource types for Direct Connect:</p>
        /// <ul>
        /// <li> <p> <code>dxcon</code> </p> </li>
        /// <li> <p> <code>dx-gateway</code> </p> </li>
        /// <li> <p> <code>dx-vif</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Network Manager:</p>
        /// <ul>
        /// <li> <p> <code>connection</code> </p> </li>
        /// <li> <p> <code>device</code> </p> </li>
        /// <li> <p> <code>link</code> </p> </li>
        /// <li> <p> <code>site</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Amazon VPC:</p>
        /// <ul>
        /// <li> <p> <code>customer-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway-attachment</code> </p> </li>
        /// <li> <p> <code>transit-gateway-connect-peer</code> </p> </li>
        /// <li> <p> <code>transit-gateway-route-table</code> </p> </li>
        /// <li> <p> <code>vpn-connection</code> </p> </li>
        /// </ul>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The resource type.</p>
        /// <p>The following are the supported resource types for Direct Connect:</p>
        /// <ul>
        /// <li> <p> <code>dxcon</code> </p> </li>
        /// <li> <p> <code>dx-gateway</code> </p> </li>
        /// <li> <p> <code>dx-vif</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Network Manager:</p>
        /// <ul>
        /// <li> <p> <code>connection</code> </p> </li>
        /// <li> <p> <code>device</code> </p> </li>
        /// <li> <p> <code>link</code> </p> </li>
        /// <li> <p> <code>site</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Amazon VPC:</p>
        /// <ul>
        /// <li> <p> <code>customer-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway-attachment</code> </p> </li>
        /// <li> <p> <code>transit-gateway-connect-peer</code> </p> </li>
        /// <li> <p> <code>transit-gateway-route-table</code> </p> </li>
        /// <li> <p> <code>vpn-connection</code> </p> </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The ARN of the gateway.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the gateway.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNetworkResources`.
    ///
    /// <p>Describes the network resources for the specified global network.</p>
    /// <p>The results include information from the corresponding Describe call for the resource, minus any sensitive information such as pre-shared keys.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetNetworkResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_network_resources_input::Builder,
    }
    impl<C, M, R> GetNetworkResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetNetworkResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNetworkResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNetworkResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetNetworkResourcesInputOperationOutputAlias,
                crate::output::GetNetworkResourcesOutput,
                crate::error::GetNetworkResourcesError,
                crate::input::GetNetworkResourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetNetworkResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetNetworkResourcesPaginator<C, M, R> {
            crate::paginator::GetNetworkResourcesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ARN of the gateway.</p>
        pub fn registered_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registered_gateway_arn(input.into());
            self
        }
        /// <p>The ARN of the gateway.</p>
        pub fn set_registered_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_registered_gateway_arn(input);
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_region(input.into());
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_aws_region(input);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The resource type.</p>
        /// <p>The following are the supported resource types for Direct Connect:</p>
        /// <ul>
        /// <li> <p> <code>dxcon</code> - The definition model is <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_Connection.html">Connection</a>.</p> </li>
        /// <li> <p> <code>dx-gateway</code> - The definition model is <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DirectConnectGateway.html">DirectConnectGateway</a>.</p> </li>
        /// <li> <p> <code>dx-vif</code> - The definition model is <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_VirtualInterface.html">VirtualInterface</a>.</p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Network Manager:</p>
        /// <ul>
        /// <li> <p> <code>connection</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Connection.html">Connection</a>.</p> </li>
        /// <li> <p> <code>device</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Device.html">Device</a>.</p> </li>
        /// <li> <p> <code>link</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Link.html">Link</a>.</p> </li>
        /// <li> <p> <code>site</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Site.html">Site</a>.</p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Amazon VPC:</p>
        /// <ul>
        /// <li> <p> <code>customer-gateway</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CustomerGateway.html">CustomerGateway</a>.</p> </li>
        /// <li> <p> <code>transit-gateway</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGateway.html">TransitGateway</a>.</p> </li>
        /// <li> <p> <code>transit-gateway-attachment</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayAttachment.html">TransitGatewayAttachment</a>.</p> </li>
        /// <li> <p> <code>transit-gateway-connect-peer</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayConnectPeer.html">TransitGatewayConnectPeer</a>.</p> </li>
        /// <li> <p> <code>transit-gateway-route-table</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayRouteTable.html">TransitGatewayRouteTable</a>.</p> </li>
        /// <li> <p> <code>vpn-connection</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpnConnection.html">VpnConnection</a>.</p> </li>
        /// </ul>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The resource type.</p>
        /// <p>The following are the supported resource types for Direct Connect:</p>
        /// <ul>
        /// <li> <p> <code>dxcon</code> - The definition model is <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_Connection.html">Connection</a>.</p> </li>
        /// <li> <p> <code>dx-gateway</code> - The definition model is <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DirectConnectGateway.html">DirectConnectGateway</a>.</p> </li>
        /// <li> <p> <code>dx-vif</code> - The definition model is <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_VirtualInterface.html">VirtualInterface</a>.</p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Network Manager:</p>
        /// <ul>
        /// <li> <p> <code>connection</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Connection.html">Connection</a>.</p> </li>
        /// <li> <p> <code>device</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Device.html">Device</a>.</p> </li>
        /// <li> <p> <code>link</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Link.html">Link</a>.</p> </li>
        /// <li> <p> <code>site</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Site.html">Site</a>.</p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Amazon VPC:</p>
        /// <ul>
        /// <li> <p> <code>customer-gateway</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CustomerGateway.html">CustomerGateway</a>.</p> </li>
        /// <li> <p> <code>transit-gateway</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGateway.html">TransitGateway</a>.</p> </li>
        /// <li> <p> <code>transit-gateway-attachment</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayAttachment.html">TransitGatewayAttachment</a>.</p> </li>
        /// <li> <p> <code>transit-gateway-connect-peer</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayConnectPeer.html">TransitGatewayConnectPeer</a>.</p> </li>
        /// <li> <p> <code>transit-gateway-route-table</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayRouteTable.html">TransitGatewayRouteTable</a>.</p> </li>
        /// <li> <p> <code>vpn-connection</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpnConnection.html">VpnConnection</a>.</p> </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNetworkRoutes`.
    ///
    /// <p>Gets the network routes of the specified global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetNetworkRoutes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_network_routes_input::Builder,
    }
    impl<C, M, R> GetNetworkRoutes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetNetworkRoutes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNetworkRoutesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNetworkRoutesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetNetworkRoutesInputOperationOutputAlias,
                crate::output::GetNetworkRoutesOutput,
                crate::error::GetNetworkRoutesError,
                crate::input::GetNetworkRoutesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the route table.</p>
        pub fn route_table_identifier(mut self, input: crate::model::RouteTableIdentifier) -> Self {
            self.inner = self.inner.route_table_identifier(input);
            self
        }
        /// <p>The ID of the route table.</p>
        pub fn set_route_table_identifier(
            mut self,
            input: std::option::Option<crate::model::RouteTableIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_route_table_identifier(input);
            self
        }
        /// Appends an item to `ExactCidrMatches`.
        ///
        /// To override the contents of this collection use [`set_exact_cidr_matches`](Self::set_exact_cidr_matches).
        ///
        /// <p>An exact CIDR block.</p>
        pub fn exact_cidr_matches(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.exact_cidr_matches(input.into());
            self
        }
        /// <p>An exact CIDR block.</p>
        pub fn set_exact_cidr_matches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_exact_cidr_matches(input);
            self
        }
        /// Appends an item to `LongestPrefixMatches`.
        ///
        /// To override the contents of this collection use [`set_longest_prefix_matches`](Self::set_longest_prefix_matches).
        ///
        /// <p>The most specific route that matches the traffic (longest prefix match).</p>
        pub fn longest_prefix_matches(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.longest_prefix_matches(input.into());
            self
        }
        /// <p>The most specific route that matches the traffic (longest prefix match).</p>
        pub fn set_longest_prefix_matches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_longest_prefix_matches(input);
            self
        }
        /// Appends an item to `SubnetOfMatches`.
        ///
        /// To override the contents of this collection use [`set_subnet_of_matches`](Self::set_subnet_of_matches).
        ///
        /// <p>The routes with a subnet that match the specified CIDR filter.</p>
        pub fn subnet_of_matches(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_of_matches(input.into());
            self
        }
        /// <p>The routes with a subnet that match the specified CIDR filter.</p>
        pub fn set_subnet_of_matches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_of_matches(input);
            self
        }
        /// Appends an item to `SupernetOfMatches`.
        ///
        /// To override the contents of this collection use [`set_supernet_of_matches`](Self::set_supernet_of_matches).
        ///
        /// <p>The routes with a CIDR that encompasses the CIDR filter. Example: If you specify 10.0.1.0/30, then the result returns 10.0.1.0/29.</p>
        pub fn supernet_of_matches(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.supernet_of_matches(input.into());
            self
        }
        /// <p>The routes with a CIDR that encompasses the CIDR filter. Example: If you specify 10.0.1.0/30, then the result returns 10.0.1.0/29.</p>
        pub fn set_supernet_of_matches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_supernet_of_matches(input);
            self
        }
        /// Appends an item to `PrefixListIds`.
        ///
        /// To override the contents of this collection use [`set_prefix_list_ids`](Self::set_prefix_list_ids).
        ///
        /// <p>The IDs of the prefix lists.</p>
        pub fn prefix_list_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.prefix_list_ids(input.into());
            self
        }
        /// <p>The IDs of the prefix lists.</p>
        pub fn set_prefix_list_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_prefix_list_ids(input);
            self
        }
        /// Appends an item to `States`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>The route states.</p>
        pub fn states(mut self, input: crate::model::RouteState) -> Self {
            self.inner = self.inner.states(input);
            self
        }
        /// <p>The route states.</p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteState>>,
        ) -> Self {
            self.inner = self.inner.set_states(input);
            self
        }
        /// Appends an item to `Types`.
        ///
        /// To override the contents of this collection use [`set_types`](Self::set_types).
        ///
        /// <p>The route types.</p>
        pub fn types(mut self, input: crate::model::RouteType) -> Self {
            self.inner = self.inner.types(input);
            self
        }
        /// <p>The route types.</p>
        pub fn set_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteType>>,
        ) -> Self {
            self.inner = self.inner.set_types(input);
            self
        }
        /// Adds a key-value pair to `DestinationFilters`.
        ///
        /// To override the contents of this collection use [`set_destination_filters`](Self::set_destination_filters).
        ///
        /// <p>Filter by route table destination. Possible Values: TRANSIT_GATEWAY_ATTACHMENT_ID, RESOURCE_ID, or RESOURCE_TYPE.</p>
        pub fn destination_filters(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            self.inner = self.inner.destination_filters(k.into(), v);
            self
        }
        /// <p>Filter by route table destination. Possible Values: TRANSIT_GATEWAY_ATTACHMENT_ID, RESOURCE_ID, or RESOURCE_TYPE.</p>
        pub fn set_destination_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_destination_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNetworkTelemetry`.
    ///
    /// <p>Gets the network telemetry of the specified global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetNetworkTelemetry<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_network_telemetry_input::Builder,
    }
    impl<C, M, R> GetNetworkTelemetry<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetNetworkTelemetry`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNetworkTelemetryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNetworkTelemetryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetNetworkTelemetryInputOperationOutputAlias,
                crate::output::GetNetworkTelemetryOutput,
                crate::error::GetNetworkTelemetryError,
                crate::input::GetNetworkTelemetryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetNetworkTelemetryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetNetworkTelemetryPaginator<C, M, R> {
            crate::paginator::GetNetworkTelemetryPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ARN of the gateway.</p>
        pub fn registered_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registered_gateway_arn(input.into());
            self
        }
        /// <p>The ARN of the gateway.</p>
        pub fn set_registered_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_registered_gateway_arn(input);
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_region(input.into());
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_aws_region(input);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The resource type.</p>
        /// <p>The following are the supported resource types for Direct Connect:</p>
        /// <ul>
        /// <li> <p> <code>dxcon</code> </p> </li>
        /// <li> <p> <code>dx-gateway</code> </p> </li>
        /// <li> <p> <code>dx-vif</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Network Manager:</p>
        /// <ul>
        /// <li> <p> <code>connection</code> </p> </li>
        /// <li> <p> <code>device</code> </p> </li>
        /// <li> <p> <code>link</code> </p> </li>
        /// <li> <p> <code>site</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Amazon VPC:</p>
        /// <ul>
        /// <li> <p> <code>customer-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway-attachment</code> </p> </li>
        /// <li> <p> <code>transit-gateway-connect-peer</code> </p> </li>
        /// <li> <p> <code>transit-gateway-route-table</code> </p> </li>
        /// <li> <p> <code>vpn-connection</code> </p> </li>
        /// </ul>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The resource type.</p>
        /// <p>The following are the supported resource types for Direct Connect:</p>
        /// <ul>
        /// <li> <p> <code>dxcon</code> </p> </li>
        /// <li> <p> <code>dx-gateway</code> </p> </li>
        /// <li> <p> <code>dx-vif</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Network Manager:</p>
        /// <ul>
        /// <li> <p> <code>connection</code> </p> </li>
        /// <li> <p> <code>device</code> </p> </li>
        /// <li> <p> <code>link</code> </p> </li>
        /// <li> <p> <code>site</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Amazon VPC:</p>
        /// <ul>
        /// <li> <p> <code>customer-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway-attachment</code> </p> </li>
        /// <li> <p> <code>transit-gateway-connect-peer</code> </p> </li>
        /// <li> <p> <code>transit-gateway-route-table</code> </p> </li>
        /// <li> <p> <code>vpn-connection</code> </p> </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourcePolicy`.
    ///
    /// <p>Returns information about a resource policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_policy_input::Builder,
    }
    impl<C, M, R> GetResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourcePolicyInputOperationOutputAlias,
                crate::output::GetResourcePolicyOutput,
                crate::error::GetResourcePolicyError,
                crate::input::GetResourcePolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRouteAnalysis`.
    ///
    /// <p>Gets information about the specified route analysis.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRouteAnalysis<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_route_analysis_input::Builder,
    }
    impl<C, M, R> GetRouteAnalysis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRouteAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRouteAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRouteAnalysisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRouteAnalysisInputOperationOutputAlias,
                crate::output::GetRouteAnalysisOutput,
                crate::error::GetRouteAnalysisError,
                crate::input::GetRouteAnalysisInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the route analysis.</p>
        pub fn route_analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_analysis_id(input.into());
            self
        }
        /// <p>The ID of the route analysis.</p>
        pub fn set_route_analysis_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_analysis_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSites`.
    ///
    /// <p>Gets information about one or more of your sites in a global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSites<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sites_input::Builder,
    }
    impl<C, M, R> GetSites<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSites`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSitesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSitesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSitesInputOperationOutputAlias,
                crate::output::GetSitesOutput,
                crate::error::GetSitesError,
                crate::input::GetSitesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetSitesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetSitesPaginator<C, M, R> {
            crate::paginator::GetSitesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// Appends an item to `SiteIds`.
        ///
        /// To override the contents of this collection use [`set_site_ids`](Self::set_site_ids).
        ///
        /// <p>One or more site IDs. The maximum is 10.</p>
        pub fn site_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_ids(input.into());
            self
        }
        /// <p>One or more site IDs. The maximum is 10.</p>
        pub fn set_site_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_site_ids(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSiteToSiteVpnAttachment`.
    ///
    /// <p>Returns information about a site-to-site VPN attachment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSiteToSiteVpnAttachment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_site_to_site_vpn_attachment_input::Builder,
    }
    impl<C, M, R> GetSiteToSiteVpnAttachment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSiteToSiteVpnAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSiteToSiteVpnAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSiteToSiteVpnAttachmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSiteToSiteVpnAttachmentInputOperationOutputAlias,
                crate::output::GetSiteToSiteVpnAttachmentOutput,
                crate::error::GetSiteToSiteVpnAttachmentError,
                crate::input::GetSiteToSiteVpnAttachmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the attachment.</p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTransitGatewayConnectPeerAssociations`.
    ///
    /// <p>Gets information about one or more of your transit gateway Connect peer associations in a global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTransitGatewayConnectPeerAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_transit_gateway_connect_peer_associations_input::Builder,
    }
    impl<C, M, R> GetTransitGatewayConnectPeerAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTransitGatewayConnectPeerAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTransitGatewayConnectPeerAssociationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetTransitGatewayConnectPeerAssociationsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTransitGatewayConnectPeerAssociationsInputOperationOutputAlias,
                crate::output::GetTransitGatewayConnectPeerAssociationsOutput,
                crate::error::GetTransitGatewayConnectPeerAssociationsError,
                crate::input::GetTransitGatewayConnectPeerAssociationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetTransitGatewayConnectPeerAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetTransitGatewayConnectPeerAssociationsPaginator<C, M, R> {
            crate::paginator::GetTransitGatewayConnectPeerAssociationsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// Appends an item to `TransitGatewayConnectPeerArns`.
        ///
        /// To override the contents of this collection use [`set_transit_gateway_connect_peer_arns`](Self::set_transit_gateway_connect_peer_arns).
        ///
        /// <p>One or more transit gateway Connect peer Amazon Resource Names (ARNs).</p>
        pub fn transit_gateway_connect_peer_arns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.transit_gateway_connect_peer_arns(input.into());
            self
        }
        /// <p>One or more transit gateway Connect peer Amazon Resource Names (ARNs).</p>
        pub fn set_transit_gateway_connect_peer_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_connect_peer_arns(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTransitGatewayRegistrations`.
    ///
    /// <p>Gets information about the transit gateway registrations in a specified global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTransitGatewayRegistrations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_transit_gateway_registrations_input::Builder,
    }
    impl<C, M, R> GetTransitGatewayRegistrations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTransitGatewayRegistrations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTransitGatewayRegistrationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTransitGatewayRegistrationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTransitGatewayRegistrationsInputOperationOutputAlias,
                crate::output::GetTransitGatewayRegistrationsOutput,
                crate::error::GetTransitGatewayRegistrationsError,
                crate::input::GetTransitGatewayRegistrationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetTransitGatewayRegistrationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetTransitGatewayRegistrationsPaginator<C, M, R> {
            crate::paginator::GetTransitGatewayRegistrationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// Appends an item to `TransitGatewayArns`.
        ///
        /// To override the contents of this collection use [`set_transit_gateway_arns`](Self::set_transit_gateway_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of one or more transit gateways. The maximum is 10.</p>
        pub fn transit_gateway_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transit_gateway_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of one or more transit gateways. The maximum is 10.</p>
        pub fn set_transit_gateway_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_arns(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVpcAttachment`.
    ///
    /// <p>Returns information about a VPC attachment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVpcAttachment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_vpc_attachment_input::Builder,
    }
    impl<C, M, R> GetVpcAttachment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVpcAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVpcAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVpcAttachmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVpcAttachmentInputOperationOutputAlias,
                crate::output::GetVpcAttachmentOutput,
                crate::error::GetVpcAttachmentError,
                crate::input::GetVpcAttachmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the attachment.</p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAttachments`.
    ///
    /// <p>Returns a list of core network attachments.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAttachments<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_attachments_input::Builder,
    }
    impl<C, M, R> ListAttachments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAttachments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAttachmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAttachmentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAttachmentsInputOperationOutputAlias,
                crate::output::ListAttachmentsOutput,
                crate::error::ListAttachmentsError,
                crate::input::ListAttachmentsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAttachmentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAttachmentsPaginator<C, M, R> {
            crate::paginator::ListAttachmentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The type of attachment.</p>
        pub fn attachment_type(mut self, input: crate::model::AttachmentType) -> Self {
            self.inner = self.inner.attachment_type(input);
            self
        }
        /// <p>The type of attachment.</p>
        pub fn set_attachment_type(
            mut self,
            input: std::option::Option<crate::model::AttachmentType>,
        ) -> Self {
            self.inner = self.inner.set_attachment_type(input);
            self
        }
        /// <p>The Region where the edge is located.</p>
        pub fn edge_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.edge_location(input.into());
            self
        }
        /// <p>The Region where the edge is located.</p>
        pub fn set_edge_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_edge_location(input);
            self
        }
        /// <p>The state of the attachment.</p>
        pub fn state(mut self, input: crate::model::AttachmentState) -> Self {
            self.inner = self.inner.state(input);
            self
        }
        /// <p>The state of the attachment.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::AttachmentState>,
        ) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConnectPeers`.
    ///
    /// <p>Returns a list of core network Connect peers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListConnectPeers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_connect_peers_input::Builder,
    }
    impl<C, M, R> ListConnectPeers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConnectPeers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConnectPeersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConnectPeersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConnectPeersInputOperationOutputAlias,
                crate::output::ListConnectPeersOutput,
                crate::error::ListConnectPeersError,
                crate::input::ListConnectPeersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListConnectPeersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListConnectPeersPaginator<C, M, R> {
            crate::paginator::ListConnectPeersPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn connect_attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connect_attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn set_connect_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connect_attachment_id(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCoreNetworkPolicyVersions`.
    ///
    /// <p>Returns a list of core network policy versions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCoreNetworkPolicyVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_core_network_policy_versions_input::Builder,
    }
    impl<C, M, R> ListCoreNetworkPolicyVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCoreNetworkPolicyVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCoreNetworkPolicyVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCoreNetworkPolicyVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCoreNetworkPolicyVersionsInputOperationOutputAlias,
                crate::output::ListCoreNetworkPolicyVersionsOutput,
                crate::error::ListCoreNetworkPolicyVersionsError,
                crate::input::ListCoreNetworkPolicyVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCoreNetworkPolicyVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListCoreNetworkPolicyVersionsPaginator<C, M, R> {
            crate::paginator::ListCoreNetworkPolicyVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCoreNetworks`.
    ///
    /// <p>Returns a list of owned and shared core networks.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCoreNetworks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_core_networks_input::Builder,
    }
    impl<C, M, R> ListCoreNetworks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCoreNetworks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCoreNetworksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCoreNetworksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCoreNetworksInputOperationOutputAlias,
                crate::output::ListCoreNetworksOutput,
                crate::error::ListCoreNetworksError,
                crate::input::ListCoreNetworksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCoreNetworksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCoreNetworksPaginator<C, M, R> {
            crate::paginator::ListCoreNetworksPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags for a specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutCoreNetworkPolicy`.
    ///
    /// <p>Creates a new, immutable version of a core network policy. A subsequent change set is created showing the differences between the LIVE policy and the submitted policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutCoreNetworkPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_core_network_policy_input::Builder,
    }
    impl<C, M, R> PutCoreNetworkPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutCoreNetworkPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutCoreNetworkPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutCoreNetworkPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutCoreNetworkPolicyInputOperationOutputAlias,
                crate::output::PutCoreNetworkPolicyOutput,
                crate::error::PutCoreNetworkPolicyError,
                crate::input::PutCoreNetworkPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The policy document.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(input.into());
            self
        }
        /// <p>The policy document.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
        /// <p>a core network policy description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>a core network policy description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ID of a core network policy. </p>
        pub fn latest_version_id(mut self, input: i32) -> Self {
            self.inner = self.inner.latest_version_id(input);
            self
        }
        /// <p>The ID of a core network policy. </p>
        pub fn set_latest_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_latest_version_id(input);
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutResourcePolicy`.
    ///
    /// <p>Creates or updates a resource policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_resource_policy_input::Builder,
    }
    impl<C, M, R> PutResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutResourcePolicyInputOperationOutputAlias,
                crate::output::PutResourcePolicyOutput,
                crate::error::PutResourcePolicyError,
                crate::input::PutResourcePolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The JSON resource policy document.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(input.into());
            self
        }
        /// <p>The JSON resource policy document.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
        /// <p>The ARN of the resource policy. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource policy. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterTransitGateway`.
    ///
    /// <p>Registers a transit gateway in your global network. The transit gateway can be in any Amazon Web Services Region, but it must be owned by the same Amazon Web Services account that owns the global network. You cannot register a transit gateway in more than one global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterTransitGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_transit_gateway_input::Builder,
    }
    impl<C, M, R> RegisterTransitGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterTransitGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterTransitGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterTransitGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterTransitGatewayInputOperationOutputAlias,
                crate::output::RegisterTransitGatewayOutput,
                crate::error::RegisterTransitGatewayError,
                crate::input::RegisterTransitGatewayInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
        pub fn transit_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transit_gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
        pub fn set_transit_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectAttachment`.
    ///
    /// <p>Rejects a core network attachment request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RejectAttachment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reject_attachment_input::Builder,
    }
    impl<C, M, R> RejectAttachment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RejectAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectAttachmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RejectAttachmentInputOperationOutputAlias,
                crate::output::RejectAttachmentOutput,
                crate::error::RejectAttachmentError,
                crate::input::RejectAttachmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the attachment.</p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreCoreNetworkPolicyVersion`.
    ///
    /// <p>Restores a previous policy version as a new, immutable version of a core network policy. A subsequent change set is created showing the differences between the LIVE policy and restored policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestoreCoreNetworkPolicyVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restore_core_network_policy_version_input::Builder,
    }
    impl<C, M, R> RestoreCoreNetworkPolicyVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestoreCoreNetworkPolicyVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreCoreNetworkPolicyVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreCoreNetworkPolicyVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestoreCoreNetworkPolicyVersionInputOperationOutputAlias,
                crate::output::RestoreCoreNetworkPolicyVersionOutput,
                crate::error::RestoreCoreNetworkPolicyVersionError,
                crate::input::RestoreCoreNetworkPolicyVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The ID of the policy version to restore.</p>
        pub fn policy_version_id(mut self, input: i32) -> Self {
            self.inner = self.inner.policy_version_id(input);
            self
        }
        /// <p>The ID of the policy version to restore.</p>
        pub fn set_policy_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_policy_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartRouteAnalysis`.
    ///
    /// <p>Starts analyzing the routing path between the specified source and destination. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/route-analyzer.html">Route Analyzer</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartRouteAnalysis<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_route_analysis_input::Builder,
    }
    impl<C, M, R> StartRouteAnalysis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartRouteAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartRouteAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::StartRouteAnalysisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartRouteAnalysisInputOperationOutputAlias,
                crate::output::StartRouteAnalysisOutput,
                crate::error::StartRouteAnalysisError,
                crate::input::StartRouteAnalysisInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The source from which traffic originates.</p>
        pub fn source(
            mut self,
            input: crate::model::RouteAnalysisEndpointOptionsSpecification,
        ) -> Self {
            self.inner = self.inner.source(input);
            self
        }
        /// <p>The source from which traffic originates.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::RouteAnalysisEndpointOptionsSpecification>,
        ) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>The destination.</p>
        pub fn destination(
            mut self,
            input: crate::model::RouteAnalysisEndpointOptionsSpecification,
        ) -> Self {
            self.inner = self.inner.destination(input);
            self
        }
        /// <p>The destination.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::RouteAnalysisEndpointOptionsSpecification>,
        ) -> Self {
            self.inner = self.inner.set_destination(input);
            self
        }
        /// <p>Indicates whether to analyze the return path. The default is <code>false</code>.</p>
        pub fn include_return_path(mut self, input: bool) -> Self {
            self.inner = self.inner.include_return_path(input);
            self
        }
        /// <p>Indicates whether to analyze the return path. The default is <code>false</code>.</p>
        pub fn set_include_return_path(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_return_path(input);
            self
        }
        /// <p>Indicates whether to include the location of middlebox appliances in the route analysis. The default is <code>false</code>.</p>
        pub fn use_middleboxes(mut self, input: bool) -> Self {
            self.inner = self.inner.use_middleboxes(input);
            self
        }
        /// <p>Indicates whether to include the location of middlebox appliances in the route analysis. The default is <code>false</code>.</p>
        pub fn set_use_middleboxes(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_use_middleboxes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Tags a specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the specified resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to apply to the specified resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys to remove from the specified resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys to remove from the specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConnection`.
    ///
    /// <p>Updates the information for an existing connection. To remove information for any of the parameters, specify an empty string.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_connection_input::Builder,
    }
    impl<C, M, R> UpdateConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConnectionInputOperationOutputAlias,
                crate::output::UpdateConnectionOutput,
                crate::error::UpdateConnectionError,
                crate::input::UpdateConnectionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The ID of the link for the first device in the connection.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link for the first device in the connection.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
        /// <p>The ID of the link for the second device in the connection.</p>
        pub fn connected_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connected_link_id(input.into());
            self
        }
        /// <p>The ID of the link for the second device in the connection.</p>
        pub fn set_connected_link_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connected_link_id(input);
            self
        }
        /// <p>A description of the connection.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the connection.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCoreNetwork`.
    ///
    /// <p>Updates the description of a core network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCoreNetwork<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_core_network_input::Builder,
    }
    impl<C, M, R> UpdateCoreNetwork<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCoreNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCoreNetworkOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCoreNetworkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCoreNetworkInputOperationOutputAlias,
                crate::output::UpdateCoreNetworkOutput,
                crate::error::UpdateCoreNetworkError,
                crate::input::UpdateCoreNetworkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_id(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_id(input);
            self
        }
        /// <p>The description of the update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDevice`.
    ///
    /// <p>Updates the details for an existing device. To remove information for any of the parameters, specify an empty string.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_device_input::Builder,
    }
    impl<C, M, R> UpdateDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDeviceInputOperationOutputAlias,
                crate::output::UpdateDeviceOutput,
                crate::error::UpdateDeviceError,
                crate::input::UpdateDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The Amazon Web Services location of the device, if applicable. For an on-premises device, you can omit this parameter.</p>
        pub fn aws_location(mut self, input: crate::model::AwsLocation) -> Self {
            self.inner = self.inner.aws_location(input);
            self
        }
        /// <p>The Amazon Web Services location of the device, if applicable. For an on-premises device, you can omit this parameter.</p>
        pub fn set_aws_location(
            mut self,
            input: std::option::Option<crate::model::AwsLocation>,
        ) -> Self {
            self.inner = self.inner.set_aws_location(input);
            self
        }
        /// <p>A description of the device.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the device.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The type of the device.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.r#type(input.into());
            self
        }
        /// <p>The type of the device.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The vendor of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn vendor(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vendor(input.into());
            self
        }
        /// <p>The vendor of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn set_vendor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vendor(input);
            self
        }
        /// <p>The model of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn model(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model(input.into());
            self
        }
        /// <p>The model of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn set_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model(input);
            self
        }
        /// <p>The serial number of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.serial_number(input.into());
            self
        }
        /// <p>The serial number of the device.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_serial_number(input);
            self
        }
        /// <p>Describes a location.</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.inner = self.inner.location(input);
            self
        }
        /// <p>Describes a location.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGlobalNetwork`.
    ///
    /// <p>Updates an existing global network. To remove information for any of the parameters, specify an empty string.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGlobalNetwork<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_global_network_input::Builder,
    }
    impl<C, M, R> UpdateGlobalNetwork<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGlobalNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGlobalNetworkOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGlobalNetworkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGlobalNetworkInputOperationOutputAlias,
                crate::output::UpdateGlobalNetworkOutput,
                crate::error::UpdateGlobalNetworkError,
                crate::input::UpdateGlobalNetworkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of your global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of your global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>A description of the global network.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the global network.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLink`.
    ///
    /// <p>Updates the details for an existing link. To remove information for any of the parameters, specify an empty string.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLink<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_link_input::Builder,
    }
    impl<C, M, R> UpdateLink<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLinkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLinkInputOperationOutputAlias,
                crate::output::UpdateLinkOutput,
                crate::error::UpdateLinkError,
                crate::input::UpdateLinkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_id(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_id(input);
            self
        }
        /// <p>A description of the link.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the link.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The type of the link.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.r#type(input.into());
            self
        }
        /// <p>The type of the link.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The upload and download speed in Mbps. </p>
        pub fn bandwidth(mut self, input: crate::model::Bandwidth) -> Self {
            self.inner = self.inner.bandwidth(input);
            self
        }
        /// <p>The upload and download speed in Mbps. </p>
        pub fn set_bandwidth(
            mut self,
            input: std::option::Option<crate::model::Bandwidth>,
        ) -> Self {
            self.inner = self.inner.set_bandwidth(input);
            self
        }
        /// <p>The provider of the link.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider(input.into());
            self
        }
        /// <p>The provider of the link.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_provider(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNetworkResourceMetadata`.
    ///
    /// <p>Updates the resource metadata for the specified global network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateNetworkResourceMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_network_resource_metadata_input::Builder,
    }
    impl<C, M, R> UpdateNetworkResourceMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateNetworkResourceMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNetworkResourceMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNetworkResourceMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateNetworkResourceMetadataInputOperationOutputAlias,
                crate::output::UpdateNetworkResourceMetadataOutput,
                crate::error::UpdateNetworkResourceMetadataError,
                crate::input::UpdateNetworkResourceMetadataInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>The resource metadata.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.metadata(k.into(), v.into());
            self
        }
        /// <p>The resource metadata.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSite`.
    ///
    /// <p>Updates the information for an existing site. To remove information for any of the parameters, specify an empty string.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSite<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_site_input::Builder,
    }
    impl<C, M, R> UpdateSite<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSite`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSiteOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSiteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSiteInputOperationOutputAlias,
                crate::output::UpdateSiteOutput,
                crate::error::UpdateSiteError,
                crate::input::UpdateSiteInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_network_id(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_network_id(input);
            self
        }
        /// <p>The ID of your site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p>The ID of your site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
        /// <p>A description of your site.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of your site.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The site location:</p>
        /// <ul>
        /// <li> <p> <code>Address</code>: The physical address of the site.</p> </li>
        /// <li> <p> <code>Latitude</code>: The latitude of the site. </p> </li>
        /// <li> <p> <code>Longitude</code>: The longitude of the site.</p> </li>
        /// </ul>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.inner = self.inner.location(input);
            self
        }
        /// <p>The site location:</p>
        /// <ul>
        /// <li> <p> <code>Address</code>: The physical address of the site.</p> </li>
        /// <li> <p> <code>Latitude</code>: The latitude of the site. </p> </li>
        /// <li> <p> <code>Longitude</code>: The longitude of the site.</p> </li>
        /// </ul>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVpcAttachment`.
    ///
    /// <p>Updates a VPC attachment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateVpcAttachment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_vpc_attachment_input::Builder,
    }
    impl<C, M, R> UpdateVpcAttachment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateVpcAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVpcAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVpcAttachmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateVpcAttachmentInputOperationOutputAlias,
                crate::output::UpdateVpcAttachmentOutput,
                crate::error::UpdateVpcAttachmentError,
                crate::input::UpdateVpcAttachmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the attachment.</p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_id(input);
            self
        }
        /// Appends an item to `AddSubnetArns`.
        ///
        /// To override the contents of this collection use [`set_add_subnet_arns`](Self::set_add_subnet_arns).
        ///
        /// <p>Adds a subnet ARN to the VPC attachment.</p>
        pub fn add_subnet_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.add_subnet_arns(input.into());
            self
        }
        /// <p>Adds a subnet ARN to the VPC attachment.</p>
        pub fn set_add_subnet_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_add_subnet_arns(input);
            self
        }
        /// Appends an item to `RemoveSubnetArns`.
        ///
        /// To override the contents of this collection use [`set_remove_subnet_arns`](Self::set_remove_subnet_arns).
        ///
        /// <p>Removes a subnet ARN from the attachment.</p>
        pub fn remove_subnet_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remove_subnet_arns(input.into());
            self
        }
        /// <p>Removes a subnet ARN from the attachment.</p>
        pub fn set_remove_subnet_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_remove_subnet_arns(input);
            self
        }
        /// <p>Additional options for updating the VPC attachment. </p>
        pub fn options(mut self, input: crate::model::VpcOptions) -> Self {
            self.inner = self.inner.options(input);
            self
        }
        /// <p>Additional options for updating the VPC attachment. </p>
        pub fn set_options(mut self, input: std::option::Option<crate::model::VpcOptions>) -> Self {
            self.inner = self.inner.set_options(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
