// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Describes a validation exception for a field.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>The name of the field.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The message for the field.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ValidationExceptionField {
    /// <p>The name of the field.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The message for the field.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the field.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the field.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The message for the field.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the field.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "CannotParse" => ValidationExceptionReason::CannotParse,
            "FieldValidationFailed" => ValidationExceptionReason::FieldValidationFailed,
            "Other" => ValidationExceptionReason::Other,
            "UnknownOperation" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "CannotParse",
            ValidationExceptionReason::FieldValidationFailed => "FieldValidationFailed",
            ValidationExceptionReason::Other => "Other",
            ValidationExceptionReason::UnknownOperation => "UnknownOperation",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CannotParse",
            "FieldValidationFailed",
            "Other",
            "UnknownOperation",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a VPC attachment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcAttachment {
    /// <p>Provides details about the VPC attachment.</p>
    pub attachment: std::option::Option<crate::model::Attachment>,
    /// <p>The subnet ARNs.</p>
    pub subnet_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Provides details about the VPC attachment.</p>
    pub options: std::option::Option<crate::model::VpcOptions>,
}
impl VpcAttachment {
    /// <p>Provides details about the VPC attachment.</p>
    pub fn attachment(&self) -> std::option::Option<&crate::model::Attachment> {
        self.attachment.as_ref()
    }
    /// <p>The subnet ARNs.</p>
    pub fn subnet_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_arns.as_deref()
    }
    /// <p>Provides details about the VPC attachment.</p>
    pub fn options(&self) -> std::option::Option<&crate::model::VpcOptions> {
        self.options.as_ref()
    }
}
impl std::fmt::Debug for VpcAttachment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcAttachment");
        formatter.field("attachment", &self.attachment);
        formatter.field("subnet_arns", &self.subnet_arns);
        formatter.field("options", &self.options);
        formatter.finish()
    }
}
/// See [`VpcAttachment`](crate::model::VpcAttachment)
pub mod vpc_attachment {
    /// A builder for [`VpcAttachment`](crate::model::VpcAttachment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attachment: std::option::Option<crate::model::Attachment>,
        pub(crate) subnet_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) options: std::option::Option<crate::model::VpcOptions>,
    }
    impl Builder {
        /// <p>Provides details about the VPC attachment.</p>
        pub fn attachment(mut self, input: crate::model::Attachment) -> Self {
            self.attachment = Some(input);
            self
        }
        /// <p>Provides details about the VPC attachment.</p>
        pub fn set_attachment(
            mut self,
            input: std::option::Option<crate::model::Attachment>,
        ) -> Self {
            self.attachment = input;
            self
        }
        /// Appends an item to `subnet_arns`.
        ///
        /// To override the contents of this collection use [`set_subnet_arns`](Self::set_subnet_arns).
        ///
        /// <p>The subnet ARNs.</p>
        pub fn subnet_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_arns.unwrap_or_default();
            v.push(input.into());
            self.subnet_arns = Some(v);
            self
        }
        /// <p>The subnet ARNs.</p>
        pub fn set_subnet_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_arns = input;
            self
        }
        /// <p>Provides details about the VPC attachment.</p>
        pub fn options(mut self, input: crate::model::VpcOptions) -> Self {
            self.options = Some(input);
            self
        }
        /// <p>Provides details about the VPC attachment.</p>
        pub fn set_options(mut self, input: std::option::Option<crate::model::VpcOptions>) -> Self {
            self.options = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcAttachment`](crate::model::VpcAttachment)
        pub fn build(self) -> crate::model::VpcAttachment {
            crate::model::VpcAttachment {
                attachment: self.attachment,
                subnet_arns: self.subnet_arns,
                options: self.options,
            }
        }
    }
}
impl VpcAttachment {
    /// Creates a new builder-style object to manufacture [`VpcAttachment`](crate::model::VpcAttachment)
    pub fn builder() -> crate::model::vpc_attachment::Builder {
        crate::model::vpc_attachment::Builder::default()
    }
}

/// <p>Describes the VPC options.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcOptions {
    /// <p>Indicates whether IPv6 is supported.</p>
    pub ipv6_support: bool,
}
impl VpcOptions {
    /// <p>Indicates whether IPv6 is supported.</p>
    pub fn ipv6_support(&self) -> bool {
        self.ipv6_support
    }
}
impl std::fmt::Debug for VpcOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcOptions");
        formatter.field("ipv6_support", &self.ipv6_support);
        formatter.finish()
    }
}
/// See [`VpcOptions`](crate::model::VpcOptions)
pub mod vpc_options {
    /// A builder for [`VpcOptions`](crate::model::VpcOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ipv6_support: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates whether IPv6 is supported.</p>
        pub fn ipv6_support(mut self, input: bool) -> Self {
            self.ipv6_support = Some(input);
            self
        }
        /// <p>Indicates whether IPv6 is supported.</p>
        pub fn set_ipv6_support(mut self, input: std::option::Option<bool>) -> Self {
            self.ipv6_support = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcOptions`](crate::model::VpcOptions)
        pub fn build(self) -> crate::model::VpcOptions {
            crate::model::VpcOptions {
                ipv6_support: self.ipv6_support.unwrap_or_default(),
            }
        }
    }
}
impl VpcOptions {
    /// Creates a new builder-style object to manufacture [`VpcOptions`](crate::model::VpcOptions)
    pub fn builder() -> crate::model::vpc_options::Builder {
        crate::model::vpc_options::Builder::default()
    }
}

/// <p>Describes a core network attachment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Attachment {
    /// <p>A core network ID.</p>
    pub core_network_id: std::option::Option<std::string::String>,
    /// <p>The ARN of a core network.</p>
    pub core_network_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the attachment.</p>
    pub attachment_id: std::option::Option<std::string::String>,
    /// <p>The ID of the attachment account owner.</p>
    pub owner_account_id: std::option::Option<std::string::String>,
    /// <p>The type of attachment.</p>
    pub attachment_type: std::option::Option<crate::model::AttachmentType>,
    /// <p>The state of the attachment.</p>
    pub state: std::option::Option<crate::model::AttachmentState>,
    /// <p>The Region where the edge is located.</p>
    pub edge_location: std::option::Option<std::string::String>,
    /// <p>The attachment resource ARN.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The policy rule number associated with the attachment.</p>
    pub attachment_policy_rule_number: std::option::Option<i32>,
    /// <p>The name of the segment attachment.</p>
    pub segment_name: std::option::Option<std::string::String>,
    /// <p>The tags associated with the attachment.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The attachment to move from one segment to another.</p>
    pub proposed_segment_change: std::option::Option<crate::model::ProposedSegmentChange>,
    /// <p>The timestamp when the attachment was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp when the attachment was last updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl Attachment {
    /// <p>A core network ID.</p>
    pub fn core_network_id(&self) -> std::option::Option<&str> {
        self.core_network_id.as_deref()
    }
    /// <p>The ARN of a core network.</p>
    pub fn core_network_arn(&self) -> std::option::Option<&str> {
        self.core_network_arn.as_deref()
    }
    /// <p>The ID of the attachment.</p>
    pub fn attachment_id(&self) -> std::option::Option<&str> {
        self.attachment_id.as_deref()
    }
    /// <p>The ID of the attachment account owner.</p>
    pub fn owner_account_id(&self) -> std::option::Option<&str> {
        self.owner_account_id.as_deref()
    }
    /// <p>The type of attachment.</p>
    pub fn attachment_type(&self) -> std::option::Option<&crate::model::AttachmentType> {
        self.attachment_type.as_ref()
    }
    /// <p>The state of the attachment.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::AttachmentState> {
        self.state.as_ref()
    }
    /// <p>The Region where the edge is located.</p>
    pub fn edge_location(&self) -> std::option::Option<&str> {
        self.edge_location.as_deref()
    }
    /// <p>The attachment resource ARN.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The policy rule number associated with the attachment.</p>
    pub fn attachment_policy_rule_number(&self) -> std::option::Option<i32> {
        self.attachment_policy_rule_number
    }
    /// <p>The name of the segment attachment.</p>
    pub fn segment_name(&self) -> std::option::Option<&str> {
        self.segment_name.as_deref()
    }
    /// <p>The tags associated with the attachment.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The attachment to move from one segment to another.</p>
    pub fn proposed_segment_change(
        &self,
    ) -> std::option::Option<&crate::model::ProposedSegmentChange> {
        self.proposed_segment_change.as_ref()
    }
    /// <p>The timestamp when the attachment was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The timestamp when the attachment was last updated.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for Attachment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Attachment");
        formatter.field("core_network_id", &self.core_network_id);
        formatter.field("core_network_arn", &self.core_network_arn);
        formatter.field("attachment_id", &self.attachment_id);
        formatter.field("owner_account_id", &self.owner_account_id);
        formatter.field("attachment_type", &self.attachment_type);
        formatter.field("state", &self.state);
        formatter.field("edge_location", &self.edge_location);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field(
            "attachment_policy_rule_number",
            &self.attachment_policy_rule_number,
        );
        formatter.field("segment_name", &self.segment_name);
        formatter.field("tags", &self.tags);
        formatter.field("proposed_segment_change", &self.proposed_segment_change);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`Attachment`](crate::model::Attachment)
pub mod attachment {
    /// A builder for [`Attachment`](crate::model::Attachment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network_id: std::option::Option<std::string::String>,
        pub(crate) core_network_arn: std::option::Option<std::string::String>,
        pub(crate) attachment_id: std::option::Option<std::string::String>,
        pub(crate) owner_account_id: std::option::Option<std::string::String>,
        pub(crate) attachment_type: std::option::Option<crate::model::AttachmentType>,
        pub(crate) state: std::option::Option<crate::model::AttachmentState>,
        pub(crate) edge_location: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) attachment_policy_rule_number: std::option::Option<i32>,
        pub(crate) segment_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) proposed_segment_change:
            std::option::Option<crate::model::ProposedSegmentChange>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A core network ID.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_network_id = Some(input.into());
            self
        }
        /// <p>A core network ID.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_network_id = input;
            self
        }
        /// <p>The ARN of a core network.</p>
        pub fn core_network_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_network_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a core network.</p>
        pub fn set_core_network_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_network_arn = input;
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attachment_id = Some(input.into());
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attachment_id = input;
            self
        }
        /// <p>The ID of the attachment account owner.</p>
        pub fn owner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the attachment account owner.</p>
        pub fn set_owner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account_id = input;
            self
        }
        /// <p>The type of attachment.</p>
        pub fn attachment_type(mut self, input: crate::model::AttachmentType) -> Self {
            self.attachment_type = Some(input);
            self
        }
        /// <p>The type of attachment.</p>
        pub fn set_attachment_type(
            mut self,
            input: std::option::Option<crate::model::AttachmentType>,
        ) -> Self {
            self.attachment_type = input;
            self
        }
        /// <p>The state of the attachment.</p>
        pub fn state(mut self, input: crate::model::AttachmentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the attachment.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::AttachmentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The Region where the edge is located.</p>
        pub fn edge_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.edge_location = Some(input.into());
            self
        }
        /// <p>The Region where the edge is located.</p>
        pub fn set_edge_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.edge_location = input;
            self
        }
        /// <p>The attachment resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The attachment resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The policy rule number associated with the attachment.</p>
        pub fn attachment_policy_rule_number(mut self, input: i32) -> Self {
            self.attachment_policy_rule_number = Some(input);
            self
        }
        /// <p>The policy rule number associated with the attachment.</p>
        pub fn set_attachment_policy_rule_number(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.attachment_policy_rule_number = input;
            self
        }
        /// <p>The name of the segment attachment.</p>
        pub fn segment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_name = Some(input.into());
            self
        }
        /// <p>The name of the segment attachment.</p>
        pub fn set_segment_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.segment_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the attachment.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the attachment.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The attachment to move from one segment to another.</p>
        pub fn proposed_segment_change(
            mut self,
            input: crate::model::ProposedSegmentChange,
        ) -> Self {
            self.proposed_segment_change = Some(input);
            self
        }
        /// <p>The attachment to move from one segment to another.</p>
        pub fn set_proposed_segment_change(
            mut self,
            input: std::option::Option<crate::model::ProposedSegmentChange>,
        ) -> Self {
            self.proposed_segment_change = input;
            self
        }
        /// <p>The timestamp when the attachment was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the attachment was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The timestamp when the attachment was last updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The timestamp when the attachment was last updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`Attachment`](crate::model::Attachment)
        pub fn build(self) -> crate::model::Attachment {
            crate::model::Attachment {
                core_network_id: self.core_network_id,
                core_network_arn: self.core_network_arn,
                attachment_id: self.attachment_id,
                owner_account_id: self.owner_account_id,
                attachment_type: self.attachment_type,
                state: self.state,
                edge_location: self.edge_location,
                resource_arn: self.resource_arn,
                attachment_policy_rule_number: self.attachment_policy_rule_number,
                segment_name: self.segment_name,
                tags: self.tags,
                proposed_segment_change: self.proposed_segment_change,
                created_at: self.created_at,
                updated_at: self.updated_at,
            }
        }
    }
}
impl Attachment {
    /// Creates a new builder-style object to manufacture [`Attachment`](crate::model::Attachment)
    pub fn builder() -> crate::model::attachment::Builder {
        crate::model::attachment::Builder::default()
    }
}

/// <p>Describes a proposed segment change. In some cases, the segment change must first be evaluated and accepted. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProposedSegmentChange {
    /// <p>The key-value tags that changed for the segment.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The rule number in the policy document that applies to this change.</p>
    pub attachment_policy_rule_number: std::option::Option<i32>,
    /// <p>The name of the segment to change.</p>
    pub segment_name: std::option::Option<std::string::String>,
}
impl ProposedSegmentChange {
    /// <p>The key-value tags that changed for the segment.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The rule number in the policy document that applies to this change.</p>
    pub fn attachment_policy_rule_number(&self) -> std::option::Option<i32> {
        self.attachment_policy_rule_number
    }
    /// <p>The name of the segment to change.</p>
    pub fn segment_name(&self) -> std::option::Option<&str> {
        self.segment_name.as_deref()
    }
}
impl std::fmt::Debug for ProposedSegmentChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProposedSegmentChange");
        formatter.field("tags", &self.tags);
        formatter.field(
            "attachment_policy_rule_number",
            &self.attachment_policy_rule_number,
        );
        formatter.field("segment_name", &self.segment_name);
        formatter.finish()
    }
}
/// See [`ProposedSegmentChange`](crate::model::ProposedSegmentChange)
pub mod proposed_segment_change {
    /// A builder for [`ProposedSegmentChange`](crate::model::ProposedSegmentChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) attachment_policy_rule_number: std::option::Option<i32>,
        pub(crate) segment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value tags that changed for the segment.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The key-value tags that changed for the segment.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The rule number in the policy document that applies to this change.</p>
        pub fn attachment_policy_rule_number(mut self, input: i32) -> Self {
            self.attachment_policy_rule_number = Some(input);
            self
        }
        /// <p>The rule number in the policy document that applies to this change.</p>
        pub fn set_attachment_policy_rule_number(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.attachment_policy_rule_number = input;
            self
        }
        /// <p>The name of the segment to change.</p>
        pub fn segment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_name = Some(input.into());
            self
        }
        /// <p>The name of the segment to change.</p>
        pub fn set_segment_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.segment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ProposedSegmentChange`](crate::model::ProposedSegmentChange)
        pub fn build(self) -> crate::model::ProposedSegmentChange {
            crate::model::ProposedSegmentChange {
                tags: self.tags,
                attachment_policy_rule_number: self.attachment_policy_rule_number,
                segment_name: self.segment_name,
            }
        }
    }
}
impl ProposedSegmentChange {
    /// Creates a new builder-style object to manufacture [`ProposedSegmentChange`](crate::model::ProposedSegmentChange)
    pub fn builder() -> crate::model::proposed_segment_change::Builder {
        crate::model::proposed_segment_change::Builder::default()
    }
}

/// <p>Describes a tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The tag key.</p>
    /// <p>Constraints: Maximum length of 128 characters.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag value.</p>
    /// <p>Constraints: Maximum length of 256 characters.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The tag key.</p>
    /// <p>Constraints: Maximum length of 128 characters.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag value.</p>
    /// <p>Constraints: Maximum length of 256 characters.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The tag key.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag key.</p>
        /// <p>Constraints: Maximum length of 128 characters.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag value.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag value.</p>
        /// <p>Constraints: Maximum length of 256 characters.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AttachmentState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    PendingAttachmentAcceptance,
    #[allow(missing_docs)] // documentation missing in model
    PendingNetworkUpdate,
    #[allow(missing_docs)] // documentation missing in model
    PendingTagAcceptance,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AttachmentState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => AttachmentState::Available,
            "CREATING" => AttachmentState::Creating,
            "DELETING" => AttachmentState::Deleting,
            "FAILED" => AttachmentState::Failed,
            "PENDING_ATTACHMENT_ACCEPTANCE" => AttachmentState::PendingAttachmentAcceptance,
            "PENDING_NETWORK_UPDATE" => AttachmentState::PendingNetworkUpdate,
            "PENDING_TAG_ACCEPTANCE" => AttachmentState::PendingTagAcceptance,
            "REJECTED" => AttachmentState::Rejected,
            "UPDATING" => AttachmentState::Updating,
            other => AttachmentState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AttachmentState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AttachmentState::from(s))
    }
}
impl AttachmentState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AttachmentState::Available => "AVAILABLE",
            AttachmentState::Creating => "CREATING",
            AttachmentState::Deleting => "DELETING",
            AttachmentState::Failed => "FAILED",
            AttachmentState::PendingAttachmentAcceptance => "PENDING_ATTACHMENT_ACCEPTANCE",
            AttachmentState::PendingNetworkUpdate => "PENDING_NETWORK_UPDATE",
            AttachmentState::PendingTagAcceptance => "PENDING_TAG_ACCEPTANCE",
            AttachmentState::Rejected => "REJECTED",
            AttachmentState::Updating => "UPDATING",
            AttachmentState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "CREATING",
            "DELETING",
            "FAILED",
            "PENDING_ATTACHMENT_ACCEPTANCE",
            "PENDING_NETWORK_UPDATE",
            "PENDING_TAG_ACCEPTANCE",
            "REJECTED",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for AttachmentState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AttachmentType {
    #[allow(missing_docs)] // documentation missing in model
    Connect,
    #[allow(missing_docs)] // documentation missing in model
    SiteToSiteVpn,
    #[allow(missing_docs)] // documentation missing in model
    Vpc,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AttachmentType {
    fn from(s: &str) -> Self {
        match s {
            "CONNECT" => AttachmentType::Connect,
            "SITE_TO_SITE_VPN" => AttachmentType::SiteToSiteVpn,
            "VPC" => AttachmentType::Vpc,
            other => AttachmentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AttachmentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AttachmentType::from(s))
    }
}
impl AttachmentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AttachmentType::Connect => "CONNECT",
            AttachmentType::SiteToSiteVpn => "SITE_TO_SITE_VPN",
            AttachmentType::Vpc => "VPC",
            AttachmentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONNECT", "SITE_TO_SITE_VPN", "VPC"]
    }
}
impl AsRef<str> for AttachmentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a site.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Site {
    /// <p>The ID of the site.</p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the site.</p>
    pub site_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The description of the site.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The location of the site.</p>
    pub location: std::option::Option<crate::model::Location>,
    /// <p>The date and time that the site was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The state of the site.</p>
    pub state: std::option::Option<crate::model::SiteState>,
    /// <p>The tags for the site.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl Site {
    /// <p>The ID of the site.</p>
    pub fn site_id(&self) -> std::option::Option<&str> {
        self.site_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the site.</p>
    pub fn site_arn(&self) -> std::option::Option<&str> {
        self.site_arn.as_deref()
    }
    /// <p>The ID of the global network.</p>
    pub fn global_network_id(&self) -> std::option::Option<&str> {
        self.global_network_id.as_deref()
    }
    /// <p>The description of the site.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The location of the site.</p>
    pub fn location(&self) -> std::option::Option<&crate::model::Location> {
        self.location.as_ref()
    }
    /// <p>The date and time that the site was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The state of the site.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::SiteState> {
        self.state.as_ref()
    }
    /// <p>The tags for the site.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for Site {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Site");
        formatter.field("site_id", &self.site_id);
        formatter.field("site_arn", &self.site_arn);
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("description", &self.description);
        formatter.field("location", &"*** Sensitive Data Redacted ***");
        formatter.field("created_at", &self.created_at);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Site`](crate::model::Site)
pub mod site {
    /// A builder for [`Site`](crate::model::Site)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) site_arn: std::option::Option<std::string::String>,
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::Location>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) state: std::option::Option<crate::model::SiteState>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the site.</p>
        pub fn site_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the site.</p>
        pub fn set_site_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_arn = input;
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The description of the site.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the site.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The location of the site.</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The location of the site.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.location = input;
            self
        }
        /// <p>The date and time that the site was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the site was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The state of the site.</p>
        pub fn state(mut self, input: crate::model::SiteState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the site.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::SiteState>) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the site.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the site.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Site`](crate::model::Site)
        pub fn build(self) -> crate::model::Site {
            crate::model::Site {
                site_id: self.site_id,
                site_arn: self.site_arn,
                global_network_id: self.global_network_id,
                description: self.description,
                location: self.location,
                created_at: self.created_at,
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl Site {
    /// Creates a new builder-style object to manufacture [`Site`](crate::model::Site)
    pub fn builder() -> crate::model::site::Builder {
        crate::model::site::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SiteState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SiteState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => SiteState::Available,
            "DELETING" => SiteState::Deleting,
            "PENDING" => SiteState::Pending,
            "UPDATING" => SiteState::Updating,
            other => SiteState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SiteState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SiteState::from(s))
    }
}
impl SiteState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SiteState::Available => "AVAILABLE",
            SiteState::Deleting => "DELETING",
            SiteState::Pending => "PENDING",
            SiteState::Updating => "UPDATING",
            SiteState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETING", "PENDING", "UPDATING"]
    }
}
impl AsRef<str> for SiteState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a location.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Location {
    /// <p>The physical address.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The latitude.</p>
    pub latitude: std::option::Option<std::string::String>,
    /// <p>The longitude.</p>
    pub longitude: std::option::Option<std::string::String>,
}
impl Location {
    /// <p>The physical address.</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>The latitude.</p>
    pub fn latitude(&self) -> std::option::Option<&str> {
        self.latitude.as_deref()
    }
    /// <p>The longitude.</p>
    pub fn longitude(&self) -> std::option::Option<&str> {
        self.longitude.as_deref()
    }
}
impl std::fmt::Debug for Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Location");
        formatter.field("address", &self.address);
        formatter.field("latitude", &self.latitude);
        formatter.field("longitude", &self.longitude);
        formatter.finish()
    }
}
/// See [`Location`](crate::model::Location)
pub mod location {
    /// A builder for [`Location`](crate::model::Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) latitude: std::option::Option<std::string::String>,
        pub(crate) longitude: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The physical address.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The physical address.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>The latitude.</p>
        pub fn latitude(mut self, input: impl Into<std::string::String>) -> Self {
            self.latitude = Some(input.into());
            self
        }
        /// <p>The latitude.</p>
        pub fn set_latitude(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.latitude = input;
            self
        }
        /// <p>The longitude.</p>
        pub fn longitude(mut self, input: impl Into<std::string::String>) -> Self {
            self.longitude = Some(input.into());
            self
        }
        /// <p>The longitude.</p>
        pub fn set_longitude(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.longitude = input;
            self
        }
        /// Consumes the builder and constructs a [`Location`](crate::model::Location)
        pub fn build(self) -> crate::model::Location {
            crate::model::Location {
                address: self.address,
                latitude: self.latitude,
                longitude: self.longitude,
            }
        }
    }
}
impl Location {
    /// Creates a new builder-style object to manufacture [`Location`](crate::model::Location)
    pub fn builder() -> crate::model::location::Builder {
        crate::model::location::Builder::default()
    }
}

/// <p>Describes a link.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Link {
    /// <p>The ID of the link.</p>
    pub link_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the link.</p>
    pub link_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the site.</p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p>The description of the link.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of the link.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The bandwidth for the link.</p>
    pub bandwidth: std::option::Option<crate::model::Bandwidth>,
    /// <p>The provider of the link.</p>
    pub provider: std::option::Option<std::string::String>,
    /// <p>The date and time that the link was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The state of the link.</p>
    pub state: std::option::Option<crate::model::LinkState>,
    /// <p>The tags for the link.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl Link {
    /// <p>The ID of the link.</p>
    pub fn link_id(&self) -> std::option::Option<&str> {
        self.link_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the link.</p>
    pub fn link_arn(&self) -> std::option::Option<&str> {
        self.link_arn.as_deref()
    }
    /// <p>The ID of the global network.</p>
    pub fn global_network_id(&self) -> std::option::Option<&str> {
        self.global_network_id.as_deref()
    }
    /// <p>The ID of the site.</p>
    pub fn site_id(&self) -> std::option::Option<&str> {
        self.site_id.as_deref()
    }
    /// <p>The description of the link.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The type of the link.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The bandwidth for the link.</p>
    pub fn bandwidth(&self) -> std::option::Option<&crate::model::Bandwidth> {
        self.bandwidth.as_ref()
    }
    /// <p>The provider of the link.</p>
    pub fn provider(&self) -> std::option::Option<&str> {
        self.provider.as_deref()
    }
    /// <p>The date and time that the link was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The state of the link.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::LinkState> {
        self.state.as_ref()
    }
    /// <p>The tags for the link.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for Link {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Link");
        formatter.field("link_id", &self.link_id);
        formatter.field("link_arn", &self.link_arn);
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("site_id", &self.site_id);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("provider", &self.provider);
        formatter.field("created_at", &self.created_at);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Link`](crate::model::Link)
pub mod link {
    /// A builder for [`Link`](crate::model::Link)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) link_id: std::option::Option<std::string::String>,
        pub(crate) link_arn: std::option::Option<std::string::String>,
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) bandwidth: std::option::Option<crate::model::Bandwidth>,
        pub(crate) provider: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) state: std::option::Option<crate::model::LinkState>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the link.</p>
        pub fn link_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the link.</p>
        pub fn set_link_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_arn = input;
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// <p>The description of the link.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the link.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of the link.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the link.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The bandwidth for the link.</p>
        pub fn bandwidth(mut self, input: crate::model::Bandwidth) -> Self {
            self.bandwidth = Some(input);
            self
        }
        /// <p>The bandwidth for the link.</p>
        pub fn set_bandwidth(
            mut self,
            input: std::option::Option<crate::model::Bandwidth>,
        ) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>The provider of the link.</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider = Some(input.into());
            self
        }
        /// <p>The provider of the link.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.provider = input;
            self
        }
        /// <p>The date and time that the link was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the link was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The state of the link.</p>
        pub fn state(mut self, input: crate::model::LinkState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the link.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::LinkState>) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the link.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the link.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Link`](crate::model::Link)
        pub fn build(self) -> crate::model::Link {
            crate::model::Link {
                link_id: self.link_id,
                link_arn: self.link_arn,
                global_network_id: self.global_network_id,
                site_id: self.site_id,
                description: self.description,
                r#type: self.r#type,
                bandwidth: self.bandwidth,
                provider: self.provider,
                created_at: self.created_at,
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl Link {
    /// Creates a new builder-style object to manufacture [`Link`](crate::model::Link)
    pub fn builder() -> crate::model::link::Builder {
        crate::model::link::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LinkState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LinkState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => LinkState::Available,
            "DELETING" => LinkState::Deleting,
            "PENDING" => LinkState::Pending,
            "UPDATING" => LinkState::Updating,
            other => LinkState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LinkState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LinkState::from(s))
    }
}
impl LinkState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LinkState::Available => "AVAILABLE",
            LinkState::Deleting => "DELETING",
            LinkState::Pending => "PENDING",
            LinkState::Updating => "UPDATING",
            LinkState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETING", "PENDING", "UPDATING"]
    }
}
impl AsRef<str> for LinkState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes bandwidth information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Bandwidth {
    /// <p>Upload speed in Mbps.</p>
    pub upload_speed: std::option::Option<i32>,
    /// <p>Download speed in Mbps.</p>
    pub download_speed: std::option::Option<i32>,
}
impl Bandwidth {
    /// <p>Upload speed in Mbps.</p>
    pub fn upload_speed(&self) -> std::option::Option<i32> {
        self.upload_speed
    }
    /// <p>Download speed in Mbps.</p>
    pub fn download_speed(&self) -> std::option::Option<i32> {
        self.download_speed
    }
}
impl std::fmt::Debug for Bandwidth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Bandwidth");
        formatter.field("upload_speed", &self.upload_speed);
        formatter.field("download_speed", &self.download_speed);
        formatter.finish()
    }
}
/// See [`Bandwidth`](crate::model::Bandwidth)
pub mod bandwidth {
    /// A builder for [`Bandwidth`](crate::model::Bandwidth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upload_speed: std::option::Option<i32>,
        pub(crate) download_speed: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Upload speed in Mbps.</p>
        pub fn upload_speed(mut self, input: i32) -> Self {
            self.upload_speed = Some(input);
            self
        }
        /// <p>Upload speed in Mbps.</p>
        pub fn set_upload_speed(mut self, input: std::option::Option<i32>) -> Self {
            self.upload_speed = input;
            self
        }
        /// <p>Download speed in Mbps.</p>
        pub fn download_speed(mut self, input: i32) -> Self {
            self.download_speed = Some(input);
            self
        }
        /// <p>Download speed in Mbps.</p>
        pub fn set_download_speed(mut self, input: std::option::Option<i32>) -> Self {
            self.download_speed = input;
            self
        }
        /// Consumes the builder and constructs a [`Bandwidth`](crate::model::Bandwidth)
        pub fn build(self) -> crate::model::Bandwidth {
            crate::model::Bandwidth {
                upload_speed: self.upload_speed,
                download_speed: self.download_speed,
            }
        }
    }
}
impl Bandwidth {
    /// Creates a new builder-style object to manufacture [`Bandwidth`](crate::model::Bandwidth)
    pub fn builder() -> crate::model::bandwidth::Builder {
        crate::model::bandwidth::Builder::default()
    }
}

/// <p>Describes a global network. This is a single private network acting as a high-level container for your network objects, including an Amazon Web Services-manged Core Network.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalNetwork {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the global network.</p>
    pub global_network_arn: std::option::Option<std::string::String>,
    /// <p>The description of the global network.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time that the global network was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The state of the global network.</p>
    pub state: std::option::Option<crate::model::GlobalNetworkState>,
    /// <p>The tags for the global network.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl GlobalNetwork {
    /// <p>The ID of the global network.</p>
    pub fn global_network_id(&self) -> std::option::Option<&str> {
        self.global_network_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the global network.</p>
    pub fn global_network_arn(&self) -> std::option::Option<&str> {
        self.global_network_arn.as_deref()
    }
    /// <p>The description of the global network.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time that the global network was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The state of the global network.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::GlobalNetworkState> {
        self.state.as_ref()
    }
    /// <p>The tags for the global network.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for GlobalNetwork {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalNetwork");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("global_network_arn", &self.global_network_arn);
        formatter.field("description", &self.description);
        formatter.field("created_at", &self.created_at);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GlobalNetwork`](crate::model::GlobalNetwork)
pub mod global_network {
    /// A builder for [`GlobalNetwork`](crate::model::GlobalNetwork)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) global_network_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) state: std::option::Option<crate::model::GlobalNetworkState>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the global network.</p>
        pub fn global_network_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the global network.</p>
        pub fn set_global_network_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_arn = input;
            self
        }
        /// <p>The description of the global network.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the global network.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time that the global network was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the global network was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The state of the global network.</p>
        pub fn state(mut self, input: crate::model::GlobalNetworkState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the global network.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::GlobalNetworkState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the global network.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the global network.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalNetwork`](crate::model::GlobalNetwork)
        pub fn build(self) -> crate::model::GlobalNetwork {
            crate::model::GlobalNetwork {
                global_network_id: self.global_network_id,
                global_network_arn: self.global_network_arn,
                description: self.description,
                created_at: self.created_at,
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl GlobalNetwork {
    /// Creates a new builder-style object to manufacture [`GlobalNetwork`](crate::model::GlobalNetwork)
    pub fn builder() -> crate::model::global_network::Builder {
        crate::model::global_network::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GlobalNetworkState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GlobalNetworkState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => GlobalNetworkState::Available,
            "DELETING" => GlobalNetworkState::Deleting,
            "PENDING" => GlobalNetworkState::Pending,
            "UPDATING" => GlobalNetworkState::Updating,
            other => GlobalNetworkState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GlobalNetworkState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GlobalNetworkState::from(s))
    }
}
impl GlobalNetworkState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GlobalNetworkState::Available => "AVAILABLE",
            GlobalNetworkState::Deleting => "DELETING",
            GlobalNetworkState::Pending => "PENDING",
            GlobalNetworkState::Updating => "UPDATING",
            GlobalNetworkState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETING", "PENDING", "UPDATING"]
    }
}
impl AsRef<str> for GlobalNetworkState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Device {
    /// <p>The ID of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the device.</p>
    pub device_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services location of the device.</p>
    pub aws_location: std::option::Option<crate::model::AwsLocation>,
    /// <p>The description of the device.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The device type.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The device vendor.</p>
    pub vendor: std::option::Option<std::string::String>,
    /// <p>The device model.</p>
    pub model: std::option::Option<std::string::String>,
    /// <p>The device serial number.</p>
    pub serial_number: std::option::Option<std::string::String>,
    /// <p>The site location.</p>
    pub location: std::option::Option<crate::model::Location>,
    /// <p>The site ID.</p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p>The date and time that the site was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The device state.</p>
    pub state: std::option::Option<crate::model::DeviceState>,
    /// <p>The tags for the device.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl Device {
    /// <p>The ID of the device.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the device.</p>
    pub fn device_arn(&self) -> std::option::Option<&str> {
        self.device_arn.as_deref()
    }
    /// <p>The ID of the global network.</p>
    pub fn global_network_id(&self) -> std::option::Option<&str> {
        self.global_network_id.as_deref()
    }
    /// <p>The Amazon Web Services location of the device.</p>
    pub fn aws_location(&self) -> std::option::Option<&crate::model::AwsLocation> {
        self.aws_location.as_ref()
    }
    /// <p>The description of the device.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The device type.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The device vendor.</p>
    pub fn vendor(&self) -> std::option::Option<&str> {
        self.vendor.as_deref()
    }
    /// <p>The device model.</p>
    pub fn model(&self) -> std::option::Option<&str> {
        self.model.as_deref()
    }
    /// <p>The device serial number.</p>
    pub fn serial_number(&self) -> std::option::Option<&str> {
        self.serial_number.as_deref()
    }
    /// <p>The site location.</p>
    pub fn location(&self) -> std::option::Option<&crate::model::Location> {
        self.location.as_ref()
    }
    /// <p>The site ID.</p>
    pub fn site_id(&self) -> std::option::Option<&str> {
        self.site_id.as_deref()
    }
    /// <p>The date and time that the site was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The device state.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::DeviceState> {
        self.state.as_ref()
    }
    /// <p>The tags for the device.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for Device {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Device");
        formatter.field("device_id", &self.device_id);
        formatter.field("device_arn", &self.device_arn);
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("aws_location", &self.aws_location);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("vendor", &self.vendor);
        formatter.field("model", &self.model);
        formatter.field("serial_number", &self.serial_number);
        formatter.field("location", &"*** Sensitive Data Redacted ***");
        formatter.field("site_id", &self.site_id);
        formatter.field("created_at", &self.created_at);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Device`](crate::model::Device)
pub mod device {
    /// A builder for [`Device`](crate::model::Device)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) device_arn: std::option::Option<std::string::String>,
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) aws_location: std::option::Option<crate::model::AwsLocation>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) vendor: std::option::Option<std::string::String>,
        pub(crate) model: std::option::Option<std::string::String>,
        pub(crate) serial_number: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::Location>,
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) state: std::option::Option<crate::model::DeviceState>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the device.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the device.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_arn = input;
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The Amazon Web Services location of the device.</p>
        pub fn aws_location(mut self, input: crate::model::AwsLocation) -> Self {
            self.aws_location = Some(input);
            self
        }
        /// <p>The Amazon Web Services location of the device.</p>
        pub fn set_aws_location(
            mut self,
            input: std::option::Option<crate::model::AwsLocation>,
        ) -> Self {
            self.aws_location = input;
            self
        }
        /// <p>The description of the device.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the device.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The device type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The device type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The device vendor.</p>
        pub fn vendor(mut self, input: impl Into<std::string::String>) -> Self {
            self.vendor = Some(input.into());
            self
        }
        /// <p>The device vendor.</p>
        pub fn set_vendor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vendor = input;
            self
        }
        /// <p>The device model.</p>
        pub fn model(mut self, input: impl Into<std::string::String>) -> Self {
            self.model = Some(input.into());
            self
        }
        /// <p>The device model.</p>
        pub fn set_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model = input;
            self
        }
        /// <p>The device serial number.</p>
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.serial_number = Some(input.into());
            self
        }
        /// <p>The device serial number.</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.serial_number = input;
            self
        }
        /// <p>The site location.</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The site location.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.location = input;
            self
        }
        /// <p>The site ID.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p>The site ID.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// <p>The date and time that the site was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the site was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The device state.</p>
        pub fn state(mut self, input: crate::model::DeviceState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The device state.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::DeviceState>) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the device.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the device.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Device`](crate::model::Device)
        pub fn build(self) -> crate::model::Device {
            crate::model::Device {
                device_id: self.device_id,
                device_arn: self.device_arn,
                global_network_id: self.global_network_id,
                aws_location: self.aws_location,
                description: self.description,
                r#type: self.r#type,
                vendor: self.vendor,
                model: self.model,
                serial_number: self.serial_number,
                location: self.location,
                site_id: self.site_id,
                created_at: self.created_at,
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl Device {
    /// Creates a new builder-style object to manufacture [`Device`](crate::model::Device)
    pub fn builder() -> crate::model::device::Builder {
        crate::model::device::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => DeviceState::Available,
            "DELETING" => DeviceState::Deleting,
            "PENDING" => DeviceState::Pending,
            "UPDATING" => DeviceState::Updating,
            other => DeviceState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceState::from(s))
    }
}
impl DeviceState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceState::Available => "AVAILABLE",
            DeviceState::Deleting => "DELETING",
            DeviceState::Pending => "PENDING",
            DeviceState::Updating => "UPDATING",
            DeviceState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETING", "PENDING", "UPDATING"]
    }
}
impl AsRef<str> for DeviceState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies a location in Amazon Web Services.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsLocation {
    /// <p>The Zone that the device is located in. Specify the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.</p>
    pub zone: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the subnet that the device is located in.</p>
    pub subnet_arn: std::option::Option<std::string::String>,
}
impl AwsLocation {
    /// <p>The Zone that the device is located in. Specify the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.</p>
    pub fn zone(&self) -> std::option::Option<&str> {
        self.zone.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the subnet that the device is located in.</p>
    pub fn subnet_arn(&self) -> std::option::Option<&str> {
        self.subnet_arn.as_deref()
    }
}
impl std::fmt::Debug for AwsLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsLocation");
        formatter.field("zone", &self.zone);
        formatter.field("subnet_arn", &self.subnet_arn);
        formatter.finish()
    }
}
/// See [`AwsLocation`](crate::model::AwsLocation)
pub mod aws_location {
    /// A builder for [`AwsLocation`](crate::model::AwsLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) zone: std::option::Option<std::string::String>,
        pub(crate) subnet_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Zone that the device is located in. Specify the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.</p>
        pub fn zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.zone = Some(input.into());
            self
        }
        /// <p>The Zone that the device is located in. Specify the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.</p>
        pub fn set_zone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.zone = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the subnet that the device is located in.</p>
        pub fn subnet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the subnet that the device is located in.</p>
        pub fn set_subnet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsLocation`](crate::model::AwsLocation)
        pub fn build(self) -> crate::model::AwsLocation {
            crate::model::AwsLocation {
                zone: self.zone,
                subnet_arn: self.subnet_arn,
            }
        }
    }
}
impl AwsLocation {
    /// Creates a new builder-style object to manufacture [`AwsLocation`](crate::model::AwsLocation)
    pub fn builder() -> crate::model::aws_location::Builder {
        crate::model::aws_location::Builder::default()
    }
}

/// <p>Describes a core network.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoreNetwork {
    /// <p>The ID of the global network that your core network is a part of. </p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of a core network.</p>
    pub core_network_id: std::option::Option<std::string::String>,
    /// <p>The ARN of a core network.</p>
    pub core_network_arn: std::option::Option<std::string::String>,
    /// <p>The description of a core network.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The timestamp when a core network was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current state of a core network.</p>
    pub state: std::option::Option<crate::model::CoreNetworkState>,
    /// <p>The segments within a core network.</p>
    pub segments: std::option::Option<std::vec::Vec<crate::model::CoreNetworkSegment>>,
    /// <p>The edges within a core network.</p>
    pub edges: std::option::Option<std::vec::Vec<crate::model::CoreNetworkEdge>>,
    /// <p>The tags associated with a core network.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CoreNetwork {
    /// <p>The ID of the global network that your core network is a part of. </p>
    pub fn global_network_id(&self) -> std::option::Option<&str> {
        self.global_network_id.as_deref()
    }
    /// <p>The ID of a core network.</p>
    pub fn core_network_id(&self) -> std::option::Option<&str> {
        self.core_network_id.as_deref()
    }
    /// <p>The ARN of a core network.</p>
    pub fn core_network_arn(&self) -> std::option::Option<&str> {
        self.core_network_arn.as_deref()
    }
    /// <p>The description of a core network.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The timestamp when a core network was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The current state of a core network.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::CoreNetworkState> {
        self.state.as_ref()
    }
    /// <p>The segments within a core network.</p>
    pub fn segments(&self) -> std::option::Option<&[crate::model::CoreNetworkSegment]> {
        self.segments.as_deref()
    }
    /// <p>The edges within a core network.</p>
    pub fn edges(&self) -> std::option::Option<&[crate::model::CoreNetworkEdge]> {
        self.edges.as_deref()
    }
    /// <p>The tags associated with a core network.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CoreNetwork {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoreNetwork");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("core_network_id", &self.core_network_id);
        formatter.field("core_network_arn", &self.core_network_arn);
        formatter.field("description", &self.description);
        formatter.field("created_at", &self.created_at);
        formatter.field("state", &self.state);
        formatter.field("segments", &self.segments);
        formatter.field("edges", &self.edges);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CoreNetwork`](crate::model::CoreNetwork)
pub mod core_network {
    /// A builder for [`CoreNetwork`](crate::model::CoreNetwork)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) core_network_id: std::option::Option<std::string::String>,
        pub(crate) core_network_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) state: std::option::Option<crate::model::CoreNetworkState>,
        pub(crate) segments: std::option::Option<std::vec::Vec<crate::model::CoreNetworkSegment>>,
        pub(crate) edges: std::option::Option<std::vec::Vec<crate::model::CoreNetworkEdge>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the global network that your core network is a part of. </p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network that your core network is a part of. </p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_network_id = Some(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_network_id = input;
            self
        }
        /// <p>The ARN of a core network.</p>
        pub fn core_network_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_network_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a core network.</p>
        pub fn set_core_network_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_network_arn = input;
            self
        }
        /// <p>The description of a core network.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of a core network.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The timestamp when a core network was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when a core network was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The current state of a core network.</p>
        pub fn state(mut self, input: crate::model::CoreNetworkState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of a core network.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::CoreNetworkState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `segments`.
        ///
        /// To override the contents of this collection use [`set_segments`](Self::set_segments).
        ///
        /// <p>The segments within a core network.</p>
        pub fn segments(mut self, input: crate::model::CoreNetworkSegment) -> Self {
            let mut v = self.segments.unwrap_or_default();
            v.push(input);
            self.segments = Some(v);
            self
        }
        /// <p>The segments within a core network.</p>
        pub fn set_segments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CoreNetworkSegment>>,
        ) -> Self {
            self.segments = input;
            self
        }
        /// Appends an item to `edges`.
        ///
        /// To override the contents of this collection use [`set_edges`](Self::set_edges).
        ///
        /// <p>The edges within a core network.</p>
        pub fn edges(mut self, input: crate::model::CoreNetworkEdge) -> Self {
            let mut v = self.edges.unwrap_or_default();
            v.push(input);
            self.edges = Some(v);
            self
        }
        /// <p>The edges within a core network.</p>
        pub fn set_edges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CoreNetworkEdge>>,
        ) -> Self {
            self.edges = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with a core network.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with a core network.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CoreNetwork`](crate::model::CoreNetwork)
        pub fn build(self) -> crate::model::CoreNetwork {
            crate::model::CoreNetwork {
                global_network_id: self.global_network_id,
                core_network_id: self.core_network_id,
                core_network_arn: self.core_network_arn,
                description: self.description,
                created_at: self.created_at,
                state: self.state,
                segments: self.segments,
                edges: self.edges,
                tags: self.tags,
            }
        }
    }
}
impl CoreNetwork {
    /// Creates a new builder-style object to manufacture [`CoreNetwork`](crate::model::CoreNetwork)
    pub fn builder() -> crate::model::core_network::Builder {
        crate::model::core_network::Builder::default()
    }
}

/// <p>Describes a core network edge.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoreNetworkEdge {
    /// <p>The Region where a core network edge is located.</p>
    pub edge_location: std::option::Option<std::string::String>,
    /// <p>The ASN of a core network edge.</p>
    pub asn: std::option::Option<i64>,
    /// <p>The inside IP addresses used for core network edges.</p>
    pub inside_cidr_blocks: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CoreNetworkEdge {
    /// <p>The Region where a core network edge is located.</p>
    pub fn edge_location(&self) -> std::option::Option<&str> {
        self.edge_location.as_deref()
    }
    /// <p>The ASN of a core network edge.</p>
    pub fn asn(&self) -> std::option::Option<i64> {
        self.asn
    }
    /// <p>The inside IP addresses used for core network edges.</p>
    pub fn inside_cidr_blocks(&self) -> std::option::Option<&[std::string::String]> {
        self.inside_cidr_blocks.as_deref()
    }
}
impl std::fmt::Debug for CoreNetworkEdge {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoreNetworkEdge");
        formatter.field("edge_location", &self.edge_location);
        formatter.field("asn", &self.asn);
        formatter.field("inside_cidr_blocks", &self.inside_cidr_blocks);
        formatter.finish()
    }
}
/// See [`CoreNetworkEdge`](crate::model::CoreNetworkEdge)
pub mod core_network_edge {
    /// A builder for [`CoreNetworkEdge`](crate::model::CoreNetworkEdge)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) edge_location: std::option::Option<std::string::String>,
        pub(crate) asn: std::option::Option<i64>,
        pub(crate) inside_cidr_blocks: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Region where a core network edge is located.</p>
        pub fn edge_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.edge_location = Some(input.into());
            self
        }
        /// <p>The Region where a core network edge is located.</p>
        pub fn set_edge_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.edge_location = input;
            self
        }
        /// <p>The ASN of a core network edge.</p>
        pub fn asn(mut self, input: i64) -> Self {
            self.asn = Some(input);
            self
        }
        /// <p>The ASN of a core network edge.</p>
        pub fn set_asn(mut self, input: std::option::Option<i64>) -> Self {
            self.asn = input;
            self
        }
        /// Appends an item to `inside_cidr_blocks`.
        ///
        /// To override the contents of this collection use [`set_inside_cidr_blocks`](Self::set_inside_cidr_blocks).
        ///
        /// <p>The inside IP addresses used for core network edges.</p>
        pub fn inside_cidr_blocks(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.inside_cidr_blocks.unwrap_or_default();
            v.push(input.into());
            self.inside_cidr_blocks = Some(v);
            self
        }
        /// <p>The inside IP addresses used for core network edges.</p>
        pub fn set_inside_cidr_blocks(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inside_cidr_blocks = input;
            self
        }
        /// Consumes the builder and constructs a [`CoreNetworkEdge`](crate::model::CoreNetworkEdge)
        pub fn build(self) -> crate::model::CoreNetworkEdge {
            crate::model::CoreNetworkEdge {
                edge_location: self.edge_location,
                asn: self.asn,
                inside_cidr_blocks: self.inside_cidr_blocks,
            }
        }
    }
}
impl CoreNetworkEdge {
    /// Creates a new builder-style object to manufacture [`CoreNetworkEdge`](crate::model::CoreNetworkEdge)
    pub fn builder() -> crate::model::core_network_edge::Builder {
        crate::model::core_network_edge::Builder::default()
    }
}

/// <p>Describes a core network segment, which are dedicated routes. Only attachments within this segment can communicate with each other.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoreNetworkSegment {
    /// <p>The name of a core network segment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Regions where the edges are located.</p>
    pub edge_locations: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The shared segments of a core network.</p>
    pub shared_segments: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CoreNetworkSegment {
    /// <p>The name of a core network segment.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Regions where the edges are located.</p>
    pub fn edge_locations(&self) -> std::option::Option<&[std::string::String]> {
        self.edge_locations.as_deref()
    }
    /// <p>The shared segments of a core network.</p>
    pub fn shared_segments(&self) -> std::option::Option<&[std::string::String]> {
        self.shared_segments.as_deref()
    }
}
impl std::fmt::Debug for CoreNetworkSegment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoreNetworkSegment");
        formatter.field("name", &self.name);
        formatter.field("edge_locations", &self.edge_locations);
        formatter.field("shared_segments", &self.shared_segments);
        formatter.finish()
    }
}
/// See [`CoreNetworkSegment`](crate::model::CoreNetworkSegment)
pub mod core_network_segment {
    /// A builder for [`CoreNetworkSegment`](crate::model::CoreNetworkSegment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) edge_locations: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) shared_segments: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of a core network segment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a core network segment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `edge_locations`.
        ///
        /// To override the contents of this collection use [`set_edge_locations`](Self::set_edge_locations).
        ///
        /// <p>The Regions where the edges are located.</p>
        pub fn edge_locations(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.edge_locations.unwrap_or_default();
            v.push(input.into());
            self.edge_locations = Some(v);
            self
        }
        /// <p>The Regions where the edges are located.</p>
        pub fn set_edge_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.edge_locations = input;
            self
        }
        /// Appends an item to `shared_segments`.
        ///
        /// To override the contents of this collection use [`set_shared_segments`](Self::set_shared_segments).
        ///
        /// <p>The shared segments of a core network.</p>
        pub fn shared_segments(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.shared_segments.unwrap_or_default();
            v.push(input.into());
            self.shared_segments = Some(v);
            self
        }
        /// <p>The shared segments of a core network.</p>
        pub fn set_shared_segments(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.shared_segments = input;
            self
        }
        /// Consumes the builder and constructs a [`CoreNetworkSegment`](crate::model::CoreNetworkSegment)
        pub fn build(self) -> crate::model::CoreNetworkSegment {
            crate::model::CoreNetworkSegment {
                name: self.name,
                edge_locations: self.edge_locations,
                shared_segments: self.shared_segments,
            }
        }
    }
}
impl CoreNetworkSegment {
    /// Creates a new builder-style object to manufacture [`CoreNetworkSegment`](crate::model::CoreNetworkSegment)
    pub fn builder() -> crate::model::core_network_segment::Builder {
        crate::model::core_network_segment::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CoreNetworkState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CoreNetworkState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => CoreNetworkState::Available,
            "CREATING" => CoreNetworkState::Creating,
            "DELETING" => CoreNetworkState::Deleting,
            "UPDATING" => CoreNetworkState::Updating,
            other => CoreNetworkState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CoreNetworkState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CoreNetworkState::from(s))
    }
}
impl CoreNetworkState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CoreNetworkState::Available => "AVAILABLE",
            CoreNetworkState::Creating => "CREATING",
            CoreNetworkState::Deleting => "DELETING",
            CoreNetworkState::Updating => "UPDATING",
            CoreNetworkState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "CREATING", "DELETING", "UPDATING"]
    }
}
impl AsRef<str> for CoreNetworkState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Connection {
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the connection.</p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the first device in the connection.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The ID of the second device in the connection.</p>
    pub connected_device_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link for the first device in the connection.</p>
    pub link_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link for the second device in the connection.</p>
    pub connected_link_id: std::option::Option<std::string::String>,
    /// <p>The description of the connection.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time that the connection was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The state of the connection.</p>
    pub state: std::option::Option<crate::model::ConnectionState>,
    /// <p>The tags for the connection.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl Connection {
    /// <p>The ID of the connection.</p>
    pub fn connection_id(&self) -> std::option::Option<&str> {
        self.connection_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the connection.</p>
    pub fn connection_arn(&self) -> std::option::Option<&str> {
        self.connection_arn.as_deref()
    }
    /// <p>The ID of the global network.</p>
    pub fn global_network_id(&self) -> std::option::Option<&str> {
        self.global_network_id.as_deref()
    }
    /// <p>The ID of the first device in the connection.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The ID of the second device in the connection.</p>
    pub fn connected_device_id(&self) -> std::option::Option<&str> {
        self.connected_device_id.as_deref()
    }
    /// <p>The ID of the link for the first device in the connection.</p>
    pub fn link_id(&self) -> std::option::Option<&str> {
        self.link_id.as_deref()
    }
    /// <p>The ID of the link for the second device in the connection.</p>
    pub fn connected_link_id(&self) -> std::option::Option<&str> {
        self.connected_link_id.as_deref()
    }
    /// <p>The description of the connection.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time that the connection was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The state of the connection.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ConnectionState> {
        self.state.as_ref()
    }
    /// <p>The tags for the connection.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for Connection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Connection");
        formatter.field("connection_id", &self.connection_id);
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("device_id", &self.device_id);
        formatter.field("connected_device_id", &self.connected_device_id);
        formatter.field("link_id", &self.link_id);
        formatter.field("connected_link_id", &self.connected_link_id);
        formatter.field("description", &self.description);
        formatter.field("created_at", &self.created_at);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Connection`](crate::model::Connection)
pub mod connection {
    /// A builder for [`Connection`](crate::model::Connection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) connected_device_id: std::option::Option<std::string::String>,
        pub(crate) link_id: std::option::Option<std::string::String>,
        pub(crate) connected_link_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) state: std::option::Option<crate::model::ConnectionState>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the connection.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the connection.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the first device in the connection.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the first device in the connection.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The ID of the second device in the connection.</p>
        pub fn connected_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connected_device_id = Some(input.into());
            self
        }
        /// <p>The ID of the second device in the connection.</p>
        pub fn set_connected_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connected_device_id = input;
            self
        }
        /// <p>The ID of the link for the first device in the connection.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link for the first device in the connection.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// <p>The ID of the link for the second device in the connection.</p>
        pub fn connected_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connected_link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link for the second device in the connection.</p>
        pub fn set_connected_link_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connected_link_id = input;
            self
        }
        /// <p>The description of the connection.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the connection.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time that the connection was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the connection was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The state of the connection.</p>
        pub fn state(mut self, input: crate::model::ConnectionState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the connection.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the connection.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the connection.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Connection`](crate::model::Connection)
        pub fn build(self) -> crate::model::Connection {
            crate::model::Connection {
                connection_id: self.connection_id,
                connection_arn: self.connection_arn,
                global_network_id: self.global_network_id,
                device_id: self.device_id,
                connected_device_id: self.connected_device_id,
                link_id: self.link_id,
                connected_link_id: self.connected_link_id,
                description: self.description,
                created_at: self.created_at,
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl Connection {
    /// Creates a new builder-style object to manufacture [`Connection`](crate::model::Connection)
    pub fn builder() -> crate::model::connection::Builder {
        crate::model::connection::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => ConnectionState::Available,
            "DELETING" => ConnectionState::Deleting,
            "PENDING" => ConnectionState::Pending,
            "UPDATING" => ConnectionState::Updating,
            other => ConnectionState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionState::from(s))
    }
}
impl ConnectionState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionState::Available => "AVAILABLE",
            ConnectionState::Deleting => "DELETING",
            ConnectionState::Pending => "PENDING",
            ConnectionState::Updating => "UPDATING",
            ConnectionState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETING", "PENDING", "UPDATING"]
    }
}
impl AsRef<str> for ConnectionState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a route analysis.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RouteAnalysis {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the AWS account that created the route analysis.</p>
    pub owner_account_id: std::option::Option<std::string::String>,
    /// <p>The ID of the route analysis.</p>
    pub route_analysis_id: std::option::Option<std::string::String>,
    /// <p>The time that the analysis started.</p>
    pub start_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the route analysis.</p>
    pub status: std::option::Option<crate::model::RouteAnalysisStatus>,
    /// <p>The source.</p>
    pub source: std::option::Option<crate::model::RouteAnalysisEndpointOptions>,
    /// <p>The destination.</p>
    pub destination: std::option::Option<crate::model::RouteAnalysisEndpointOptions>,
    /// <p>Indicates whether to analyze the return path. The return path is not analyzed if the forward path analysis does not succeed.</p>
    pub include_return_path: bool,
    /// <p>Indicates whether to include the location of middlebox appliances in the route analysis.</p>
    pub use_middleboxes: bool,
    /// <p>The forward path.</p>
    pub forward_path: std::option::Option<crate::model::RouteAnalysisPath>,
    /// <p>The return path.</p>
    pub return_path: std::option::Option<crate::model::RouteAnalysisPath>,
}
impl RouteAnalysis {
    /// <p>The ID of the global network.</p>
    pub fn global_network_id(&self) -> std::option::Option<&str> {
        self.global_network_id.as_deref()
    }
    /// <p>The ID of the AWS account that created the route analysis.</p>
    pub fn owner_account_id(&self) -> std::option::Option<&str> {
        self.owner_account_id.as_deref()
    }
    /// <p>The ID of the route analysis.</p>
    pub fn route_analysis_id(&self) -> std::option::Option<&str> {
        self.route_analysis_id.as_deref()
    }
    /// <p>The time that the analysis started.</p>
    pub fn start_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_timestamp.as_ref()
    }
    /// <p>The status of the route analysis.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RouteAnalysisStatus> {
        self.status.as_ref()
    }
    /// <p>The source.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::RouteAnalysisEndpointOptions> {
        self.source.as_ref()
    }
    /// <p>The destination.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::RouteAnalysisEndpointOptions> {
        self.destination.as_ref()
    }
    /// <p>Indicates whether to analyze the return path. The return path is not analyzed if the forward path analysis does not succeed.</p>
    pub fn include_return_path(&self) -> bool {
        self.include_return_path
    }
    /// <p>Indicates whether to include the location of middlebox appliances in the route analysis.</p>
    pub fn use_middleboxes(&self) -> bool {
        self.use_middleboxes
    }
    /// <p>The forward path.</p>
    pub fn forward_path(&self) -> std::option::Option<&crate::model::RouteAnalysisPath> {
        self.forward_path.as_ref()
    }
    /// <p>The return path.</p>
    pub fn return_path(&self) -> std::option::Option<&crate::model::RouteAnalysisPath> {
        self.return_path.as_ref()
    }
}
impl std::fmt::Debug for RouteAnalysis {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RouteAnalysis");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("owner_account_id", &self.owner_account_id);
        formatter.field("route_analysis_id", &self.route_analysis_id);
        formatter.field("start_timestamp", &self.start_timestamp);
        formatter.field("status", &self.status);
        formatter.field("source", &self.source);
        formatter.field("destination", &self.destination);
        formatter.field("include_return_path", &self.include_return_path);
        formatter.field("use_middleboxes", &self.use_middleboxes);
        formatter.field("forward_path", &self.forward_path);
        formatter.field("return_path", &self.return_path);
        formatter.finish()
    }
}
/// See [`RouteAnalysis`](crate::model::RouteAnalysis)
pub mod route_analysis {
    /// A builder for [`RouteAnalysis`](crate::model::RouteAnalysis)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) owner_account_id: std::option::Option<std::string::String>,
        pub(crate) route_analysis_id: std::option::Option<std::string::String>,
        pub(crate) start_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::RouteAnalysisStatus>,
        pub(crate) source: std::option::Option<crate::model::RouteAnalysisEndpointOptions>,
        pub(crate) destination: std::option::Option<crate::model::RouteAnalysisEndpointOptions>,
        pub(crate) include_return_path: std::option::Option<bool>,
        pub(crate) use_middleboxes: std::option::Option<bool>,
        pub(crate) forward_path: std::option::Option<crate::model::RouteAnalysisPath>,
        pub(crate) return_path: std::option::Option<crate::model::RouteAnalysisPath>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the AWS account that created the route analysis.</p>
        pub fn owner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the AWS account that created the route analysis.</p>
        pub fn set_owner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account_id = input;
            self
        }
        /// <p>The ID of the route analysis.</p>
        pub fn route_analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_analysis_id = Some(input.into());
            self
        }
        /// <p>The ID of the route analysis.</p>
        pub fn set_route_analysis_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_analysis_id = input;
            self
        }
        /// <p>The time that the analysis started.</p>
        pub fn start_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_timestamp = Some(input);
            self
        }
        /// <p>The time that the analysis started.</p>
        pub fn set_start_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_timestamp = input;
            self
        }
        /// <p>The status of the route analysis.</p>
        pub fn status(mut self, input: crate::model::RouteAnalysisStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the route analysis.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RouteAnalysisStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The source.</p>
        pub fn source(mut self, input: crate::model::RouteAnalysisEndpointOptions) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The source.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::RouteAnalysisEndpointOptions>,
        ) -> Self {
            self.source = input;
            self
        }
        /// <p>The destination.</p>
        pub fn destination(mut self, input: crate::model::RouteAnalysisEndpointOptions) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The destination.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::RouteAnalysisEndpointOptions>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>Indicates whether to analyze the return path. The return path is not analyzed if the forward path analysis does not succeed.</p>
        pub fn include_return_path(mut self, input: bool) -> Self {
            self.include_return_path = Some(input);
            self
        }
        /// <p>Indicates whether to analyze the return path. The return path is not analyzed if the forward path analysis does not succeed.</p>
        pub fn set_include_return_path(mut self, input: std::option::Option<bool>) -> Self {
            self.include_return_path = input;
            self
        }
        /// <p>Indicates whether to include the location of middlebox appliances in the route analysis.</p>
        pub fn use_middleboxes(mut self, input: bool) -> Self {
            self.use_middleboxes = Some(input);
            self
        }
        /// <p>Indicates whether to include the location of middlebox appliances in the route analysis.</p>
        pub fn set_use_middleboxes(mut self, input: std::option::Option<bool>) -> Self {
            self.use_middleboxes = input;
            self
        }
        /// <p>The forward path.</p>
        pub fn forward_path(mut self, input: crate::model::RouteAnalysisPath) -> Self {
            self.forward_path = Some(input);
            self
        }
        /// <p>The forward path.</p>
        pub fn set_forward_path(
            mut self,
            input: std::option::Option<crate::model::RouteAnalysisPath>,
        ) -> Self {
            self.forward_path = input;
            self
        }
        /// <p>The return path.</p>
        pub fn return_path(mut self, input: crate::model::RouteAnalysisPath) -> Self {
            self.return_path = Some(input);
            self
        }
        /// <p>The return path.</p>
        pub fn set_return_path(
            mut self,
            input: std::option::Option<crate::model::RouteAnalysisPath>,
        ) -> Self {
            self.return_path = input;
            self
        }
        /// Consumes the builder and constructs a [`RouteAnalysis`](crate::model::RouteAnalysis)
        pub fn build(self) -> crate::model::RouteAnalysis {
            crate::model::RouteAnalysis {
                global_network_id: self.global_network_id,
                owner_account_id: self.owner_account_id,
                route_analysis_id: self.route_analysis_id,
                start_timestamp: self.start_timestamp,
                status: self.status,
                source: self.source,
                destination: self.destination,
                include_return_path: self.include_return_path.unwrap_or_default(),
                use_middleboxes: self.use_middleboxes.unwrap_or_default(),
                forward_path: self.forward_path,
                return_path: self.return_path,
            }
        }
    }
}
impl RouteAnalysis {
    /// Creates a new builder-style object to manufacture [`RouteAnalysis`](crate::model::RouteAnalysis)
    pub fn builder() -> crate::model::route_analysis::Builder {
        crate::model::route_analysis::Builder::default()
    }
}

/// <p>Describes a route analysis path.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RouteAnalysisPath {
    /// <p>The status of the analysis at completion.</p>
    pub completion_status: std::option::Option<crate::model::RouteAnalysisCompletion>,
    /// <p>The route analysis path.</p>
    pub path: std::option::Option<std::vec::Vec<crate::model::PathComponent>>,
}
impl RouteAnalysisPath {
    /// <p>The status of the analysis at completion.</p>
    pub fn completion_status(&self) -> std::option::Option<&crate::model::RouteAnalysisCompletion> {
        self.completion_status.as_ref()
    }
    /// <p>The route analysis path.</p>
    pub fn path(&self) -> std::option::Option<&[crate::model::PathComponent]> {
        self.path.as_deref()
    }
}
impl std::fmt::Debug for RouteAnalysisPath {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RouteAnalysisPath");
        formatter.field("completion_status", &self.completion_status);
        formatter.field("path", &self.path);
        formatter.finish()
    }
}
/// See [`RouteAnalysisPath`](crate::model::RouteAnalysisPath)
pub mod route_analysis_path {
    /// A builder for [`RouteAnalysisPath`](crate::model::RouteAnalysisPath)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) completion_status: std::option::Option<crate::model::RouteAnalysisCompletion>,
        pub(crate) path: std::option::Option<std::vec::Vec<crate::model::PathComponent>>,
    }
    impl Builder {
        /// <p>The status of the analysis at completion.</p>
        pub fn completion_status(mut self, input: crate::model::RouteAnalysisCompletion) -> Self {
            self.completion_status = Some(input);
            self
        }
        /// <p>The status of the analysis at completion.</p>
        pub fn set_completion_status(
            mut self,
            input: std::option::Option<crate::model::RouteAnalysisCompletion>,
        ) -> Self {
            self.completion_status = input;
            self
        }
        /// Appends an item to `path`.
        ///
        /// To override the contents of this collection use [`set_path`](Self::set_path).
        ///
        /// <p>The route analysis path.</p>
        pub fn path(mut self, input: crate::model::PathComponent) -> Self {
            let mut v = self.path.unwrap_or_default();
            v.push(input);
            self.path = Some(v);
            self
        }
        /// <p>The route analysis path.</p>
        pub fn set_path(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PathComponent>>,
        ) -> Self {
            self.path = input;
            self
        }
        /// Consumes the builder and constructs a [`RouteAnalysisPath`](crate::model::RouteAnalysisPath)
        pub fn build(self) -> crate::model::RouteAnalysisPath {
            crate::model::RouteAnalysisPath {
                completion_status: self.completion_status,
                path: self.path,
            }
        }
    }
}
impl RouteAnalysisPath {
    /// Creates a new builder-style object to manufacture [`RouteAnalysisPath`](crate::model::RouteAnalysisPath)
    pub fn builder() -> crate::model::route_analysis_path::Builder {
        crate::model::route_analysis_path::Builder::default()
    }
}

/// <p>Describes a path component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PathComponent {
    /// <p>The sequence number in the path. The destination is 0.</p>
    pub sequence: std::option::Option<i32>,
    /// <p>The resource.</p>
    pub resource: std::option::Option<crate::model::NetworkResourceSummary>,
    /// <p>The destination CIDR block in the route table.</p>
    pub destination_cidr_block: std::option::Option<std::string::String>,
}
impl PathComponent {
    /// <p>The sequence number in the path. The destination is 0.</p>
    pub fn sequence(&self) -> std::option::Option<i32> {
        self.sequence
    }
    /// <p>The resource.</p>
    pub fn resource(&self) -> std::option::Option<&crate::model::NetworkResourceSummary> {
        self.resource.as_ref()
    }
    /// <p>The destination CIDR block in the route table.</p>
    pub fn destination_cidr_block(&self) -> std::option::Option<&str> {
        self.destination_cidr_block.as_deref()
    }
}
impl std::fmt::Debug for PathComponent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PathComponent");
        formatter.field("sequence", &self.sequence);
        formatter.field("resource", &self.resource);
        formatter.field("destination_cidr_block", &self.destination_cidr_block);
        formatter.finish()
    }
}
/// See [`PathComponent`](crate::model::PathComponent)
pub mod path_component {
    /// A builder for [`PathComponent`](crate::model::PathComponent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sequence: std::option::Option<i32>,
        pub(crate) resource: std::option::Option<crate::model::NetworkResourceSummary>,
        pub(crate) destination_cidr_block: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The sequence number in the path. The destination is 0.</p>
        pub fn sequence(mut self, input: i32) -> Self {
            self.sequence = Some(input);
            self
        }
        /// <p>The sequence number in the path. The destination is 0.</p>
        pub fn set_sequence(mut self, input: std::option::Option<i32>) -> Self {
            self.sequence = input;
            self
        }
        /// <p>The resource.</p>
        pub fn resource(mut self, input: crate::model::NetworkResourceSummary) -> Self {
            self.resource = Some(input);
            self
        }
        /// <p>The resource.</p>
        pub fn set_resource(
            mut self,
            input: std::option::Option<crate::model::NetworkResourceSummary>,
        ) -> Self {
            self.resource = input;
            self
        }
        /// <p>The destination CIDR block in the route table.</p>
        pub fn destination_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_cidr_block = Some(input.into());
            self
        }
        /// <p>The destination CIDR block in the route table.</p>
        pub fn set_destination_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_cidr_block = input;
            self
        }
        /// Consumes the builder and constructs a [`PathComponent`](crate::model::PathComponent)
        pub fn build(self) -> crate::model::PathComponent {
            crate::model::PathComponent {
                sequence: self.sequence,
                resource: self.resource,
                destination_cidr_block: self.destination_cidr_block,
            }
        }
    }
}
impl PathComponent {
    /// Creates a new builder-style object to manufacture [`PathComponent`](crate::model::PathComponent)
    pub fn builder() -> crate::model::path_component::Builder {
        crate::model::path_component::Builder::default()
    }
}

/// <p>Describes a network resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkResourceSummary {
    /// <p>The ARN of the gateway.</p>
    pub registered_gateway_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The resource type.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>Information about the resource, in JSON format. Network Manager gets this information by describing the resource using its Describe API call.</p>
    pub definition: std::option::Option<std::string::String>,
    /// <p>The value for the Name tag.</p>
    pub name_tag: std::option::Option<std::string::String>,
    /// <p>Indicates whether this is a middlebox appliance.</p>
    pub is_middlebox: bool,
}
impl NetworkResourceSummary {
    /// <p>The ARN of the gateway.</p>
    pub fn registered_gateway_arn(&self) -> std::option::Option<&str> {
        self.registered_gateway_arn.as_deref()
    }
    /// <p>The ARN of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The resource type.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>Information about the resource, in JSON format. Network Manager gets this information by describing the resource using its Describe API call.</p>
    pub fn definition(&self) -> std::option::Option<&str> {
        self.definition.as_deref()
    }
    /// <p>The value for the Name tag.</p>
    pub fn name_tag(&self) -> std::option::Option<&str> {
        self.name_tag.as_deref()
    }
    /// <p>Indicates whether this is a middlebox appliance.</p>
    pub fn is_middlebox(&self) -> bool {
        self.is_middlebox
    }
}
impl std::fmt::Debug for NetworkResourceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkResourceSummary");
        formatter.field("registered_gateway_arn", &self.registered_gateway_arn);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("definition", &self.definition);
        formatter.field("name_tag", &self.name_tag);
        formatter.field("is_middlebox", &self.is_middlebox);
        formatter.finish()
    }
}
/// See [`NetworkResourceSummary`](crate::model::NetworkResourceSummary)
pub mod network_resource_summary {
    /// A builder for [`NetworkResourceSummary`](crate::model::NetworkResourceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registered_gateway_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) definition: std::option::Option<std::string::String>,
        pub(crate) name_tag: std::option::Option<std::string::String>,
        pub(crate) is_middlebox: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ARN of the gateway.</p>
        pub fn registered_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.registered_gateway_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the gateway.</p>
        pub fn set_registered_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registered_gateway_arn = input;
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Information about the resource, in JSON format. Network Manager gets this information by describing the resource using its Describe API call.</p>
        pub fn definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.definition = Some(input.into());
            self
        }
        /// <p>Information about the resource, in JSON format. Network Manager gets this information by describing the resource using its Describe API call.</p>
        pub fn set_definition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.definition = input;
            self
        }
        /// <p>The value for the Name tag.</p>
        pub fn name_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_tag = Some(input.into());
            self
        }
        /// <p>The value for the Name tag.</p>
        pub fn set_name_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name_tag = input;
            self
        }
        /// <p>Indicates whether this is a middlebox appliance.</p>
        pub fn is_middlebox(mut self, input: bool) -> Self {
            self.is_middlebox = Some(input);
            self
        }
        /// <p>Indicates whether this is a middlebox appliance.</p>
        pub fn set_is_middlebox(mut self, input: std::option::Option<bool>) -> Self {
            self.is_middlebox = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkResourceSummary`](crate::model::NetworkResourceSummary)
        pub fn build(self) -> crate::model::NetworkResourceSummary {
            crate::model::NetworkResourceSummary {
                registered_gateway_arn: self.registered_gateway_arn,
                resource_arn: self.resource_arn,
                resource_type: self.resource_type,
                definition: self.definition,
                name_tag: self.name_tag,
                is_middlebox: self.is_middlebox.unwrap_or_default(),
            }
        }
    }
}
impl NetworkResourceSummary {
    /// Creates a new builder-style object to manufacture [`NetworkResourceSummary`](crate::model::NetworkResourceSummary)
    pub fn builder() -> crate::model::network_resource_summary::Builder {
        crate::model::network_resource_summary::Builder::default()
    }
}

/// <p>Describes the status of an analysis at completion.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RouteAnalysisCompletion {
    /// <p>The result of the analysis. If the status is <code>NOT_CONNECTED</code>, check the reason code.</p>
    pub result_code: std::option::Option<crate::model::RouteAnalysisCompletionResultCode>,
    /// <p>The reason code. Available only if a connection is not found.</p>
    /// <ul>
    /// <li> <p> <code>BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND</code> - Found a black hole route with the destination CIDR block.</p> </li>
    /// <li> <p> <code>CYCLIC_PATH_DETECTED</code> - Found the same resource multiple times while traversing the path.</p> </li>
    /// <li> <p> <code>INACTIVE_ROUTE_FOR_DESTINATION_FOUND</code> - Found an inactive route with the destination CIDR block.</p> </li>
    /// <li> <p> <code>MAX_HOPS_EXCEEDED</code> - Analysis exceeded 64 hops without finding the destination.</p> </li>
    /// <li> <p> <code>ROUTE_NOT_FOUND</code> - Cannot find a route table with the destination CIDR block.</p> </li>
    /// <li> <p> <code>TGW_ATTACH_ARN_NO_MATCH</code> - Found an attachment, but not with the correct destination ARN.</p> </li>
    /// <li> <p> <code>TGW_ATTACH_NOT_FOUND</code> - Cannot find an attachment.</p> </li>
    /// <li> <p> <code>TGW_ATTACH_NOT_IN_TGW</code> - Found an attachment, but not to the correct transit gateway.</p> </li>
    /// <li> <p> <code>TGW_ATTACH_STABLE_ROUTE_TABLE_NOT_FOUND</code> - The state of the route table association is not associated.</p> </li>
    /// </ul>
    pub reason_code: std::option::Option<crate::model::RouteAnalysisCompletionReasonCode>,
    /// <p>Additional information about the path. Available only if a connection is not found.</p>
    pub reason_context:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl RouteAnalysisCompletion {
    /// <p>The result of the analysis. If the status is <code>NOT_CONNECTED</code>, check the reason code.</p>
    pub fn result_code(
        &self,
    ) -> std::option::Option<&crate::model::RouteAnalysisCompletionResultCode> {
        self.result_code.as_ref()
    }
    /// <p>The reason code. Available only if a connection is not found.</p>
    /// <ul>
    /// <li> <p> <code>BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND</code> - Found a black hole route with the destination CIDR block.</p> </li>
    /// <li> <p> <code>CYCLIC_PATH_DETECTED</code> - Found the same resource multiple times while traversing the path.</p> </li>
    /// <li> <p> <code>INACTIVE_ROUTE_FOR_DESTINATION_FOUND</code> - Found an inactive route with the destination CIDR block.</p> </li>
    /// <li> <p> <code>MAX_HOPS_EXCEEDED</code> - Analysis exceeded 64 hops without finding the destination.</p> </li>
    /// <li> <p> <code>ROUTE_NOT_FOUND</code> - Cannot find a route table with the destination CIDR block.</p> </li>
    /// <li> <p> <code>TGW_ATTACH_ARN_NO_MATCH</code> - Found an attachment, but not with the correct destination ARN.</p> </li>
    /// <li> <p> <code>TGW_ATTACH_NOT_FOUND</code> - Cannot find an attachment.</p> </li>
    /// <li> <p> <code>TGW_ATTACH_NOT_IN_TGW</code> - Found an attachment, but not to the correct transit gateway.</p> </li>
    /// <li> <p> <code>TGW_ATTACH_STABLE_ROUTE_TABLE_NOT_FOUND</code> - The state of the route table association is not associated.</p> </li>
    /// </ul>
    pub fn reason_code(
        &self,
    ) -> std::option::Option<&crate::model::RouteAnalysisCompletionReasonCode> {
        self.reason_code.as_ref()
    }
    /// <p>Additional information about the path. Available only if a connection is not found.</p>
    pub fn reason_context(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.reason_context.as_ref()
    }
}
impl std::fmt::Debug for RouteAnalysisCompletion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RouteAnalysisCompletion");
        formatter.field("result_code", &self.result_code);
        formatter.field("reason_code", &self.reason_code);
        formatter.field("reason_context", &self.reason_context);
        formatter.finish()
    }
}
/// See [`RouteAnalysisCompletion`](crate::model::RouteAnalysisCompletion)
pub mod route_analysis_completion {
    /// A builder for [`RouteAnalysisCompletion`](crate::model::RouteAnalysisCompletion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) result_code:
            std::option::Option<crate::model::RouteAnalysisCompletionResultCode>,
        pub(crate) reason_code:
            std::option::Option<crate::model::RouteAnalysisCompletionReasonCode>,
        pub(crate) reason_context: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The result of the analysis. If the status is <code>NOT_CONNECTED</code>, check the reason code.</p>
        pub fn result_code(
            mut self,
            input: crate::model::RouteAnalysisCompletionResultCode,
        ) -> Self {
            self.result_code = Some(input);
            self
        }
        /// <p>The result of the analysis. If the status is <code>NOT_CONNECTED</code>, check the reason code.</p>
        pub fn set_result_code(
            mut self,
            input: std::option::Option<crate::model::RouteAnalysisCompletionResultCode>,
        ) -> Self {
            self.result_code = input;
            self
        }
        /// <p>The reason code. Available only if a connection is not found.</p>
        /// <ul>
        /// <li> <p> <code>BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND</code> - Found a black hole route with the destination CIDR block.</p> </li>
        /// <li> <p> <code>CYCLIC_PATH_DETECTED</code> - Found the same resource multiple times while traversing the path.</p> </li>
        /// <li> <p> <code>INACTIVE_ROUTE_FOR_DESTINATION_FOUND</code> - Found an inactive route with the destination CIDR block.</p> </li>
        /// <li> <p> <code>MAX_HOPS_EXCEEDED</code> - Analysis exceeded 64 hops without finding the destination.</p> </li>
        /// <li> <p> <code>ROUTE_NOT_FOUND</code> - Cannot find a route table with the destination CIDR block.</p> </li>
        /// <li> <p> <code>TGW_ATTACH_ARN_NO_MATCH</code> - Found an attachment, but not with the correct destination ARN.</p> </li>
        /// <li> <p> <code>TGW_ATTACH_NOT_FOUND</code> - Cannot find an attachment.</p> </li>
        /// <li> <p> <code>TGW_ATTACH_NOT_IN_TGW</code> - Found an attachment, but not to the correct transit gateway.</p> </li>
        /// <li> <p> <code>TGW_ATTACH_STABLE_ROUTE_TABLE_NOT_FOUND</code> - The state of the route table association is not associated.</p> </li>
        /// </ul>
        pub fn reason_code(
            mut self,
            input: crate::model::RouteAnalysisCompletionReasonCode,
        ) -> Self {
            self.reason_code = Some(input);
            self
        }
        /// <p>The reason code. Available only if a connection is not found.</p>
        /// <ul>
        /// <li> <p> <code>BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND</code> - Found a black hole route with the destination CIDR block.</p> </li>
        /// <li> <p> <code>CYCLIC_PATH_DETECTED</code> - Found the same resource multiple times while traversing the path.</p> </li>
        /// <li> <p> <code>INACTIVE_ROUTE_FOR_DESTINATION_FOUND</code> - Found an inactive route with the destination CIDR block.</p> </li>
        /// <li> <p> <code>MAX_HOPS_EXCEEDED</code> - Analysis exceeded 64 hops without finding the destination.</p> </li>
        /// <li> <p> <code>ROUTE_NOT_FOUND</code> - Cannot find a route table with the destination CIDR block.</p> </li>
        /// <li> <p> <code>TGW_ATTACH_ARN_NO_MATCH</code> - Found an attachment, but not with the correct destination ARN.</p> </li>
        /// <li> <p> <code>TGW_ATTACH_NOT_FOUND</code> - Cannot find an attachment.</p> </li>
        /// <li> <p> <code>TGW_ATTACH_NOT_IN_TGW</code> - Found an attachment, but not to the correct transit gateway.</p> </li>
        /// <li> <p> <code>TGW_ATTACH_STABLE_ROUTE_TABLE_NOT_FOUND</code> - The state of the route table association is not associated.</p> </li>
        /// </ul>
        pub fn set_reason_code(
            mut self,
            input: std::option::Option<crate::model::RouteAnalysisCompletionReasonCode>,
        ) -> Self {
            self.reason_code = input;
            self
        }
        /// Adds a key-value pair to `reason_context`.
        ///
        /// To override the contents of this collection use [`set_reason_context`](Self::set_reason_context).
        ///
        /// <p>Additional information about the path. Available only if a connection is not found.</p>
        pub fn reason_context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.reason_context.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.reason_context = Some(hash_map);
            self
        }
        /// <p>Additional information about the path. Available only if a connection is not found.</p>
        pub fn set_reason_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.reason_context = input;
            self
        }
        /// Consumes the builder and constructs a [`RouteAnalysisCompletion`](crate::model::RouteAnalysisCompletion)
        pub fn build(self) -> crate::model::RouteAnalysisCompletion {
            crate::model::RouteAnalysisCompletion {
                result_code: self.result_code,
                reason_code: self.reason_code,
                reason_context: self.reason_context,
            }
        }
    }
}
impl RouteAnalysisCompletion {
    /// Creates a new builder-style object to manufacture [`RouteAnalysisCompletion`](crate::model::RouteAnalysisCompletion)
    pub fn builder() -> crate::model::route_analysis_completion::Builder {
        crate::model::route_analysis_completion::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RouteAnalysisCompletionReasonCode {
    #[allow(missing_docs)] // documentation missing in model
    BlackholeRouteForDestinationFound,
    #[allow(missing_docs)] // documentation missing in model
    CyclicPathDetected,
    #[allow(missing_docs)] // documentation missing in model
    InactiveRouteForDestinationFound,
    #[allow(missing_docs)] // documentation missing in model
    MaxHopsExceeded,
    #[allow(missing_docs)] // documentation missing in model
    NoDestinationArnProvided,
    #[allow(missing_docs)] // documentation missing in model
    PossibleMiddlebox,
    #[allow(missing_docs)] // documentation missing in model
    RouteNotFound,
    #[allow(missing_docs)] // documentation missing in model
    TransitGatewayAttachment,
    #[allow(missing_docs)] // documentation missing in model
    TransitGatewayAttachmentNotFound,
    #[allow(missing_docs)] // documentation missing in model
    TransitGatewayAttachmentNotInTransitGateway,
    #[allow(missing_docs)] // documentation missing in model
    TransitGatewayAttachmentStableRouteTableNotFound,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RouteAnalysisCompletionReasonCode {
    fn from(s: &str) -> Self {
        match s {
            "BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND" => {
                RouteAnalysisCompletionReasonCode::BlackholeRouteForDestinationFound
            }
            "CYCLIC_PATH_DETECTED" => RouteAnalysisCompletionReasonCode::CyclicPathDetected,
            "INACTIVE_ROUTE_FOR_DESTINATION_FOUND" => {
                RouteAnalysisCompletionReasonCode::InactiveRouteForDestinationFound
            }
            "MAX_HOPS_EXCEEDED" => RouteAnalysisCompletionReasonCode::MaxHopsExceeded,
            "NO_DESTINATION_ARN_PROVIDED" => {
                RouteAnalysisCompletionReasonCode::NoDestinationArnProvided
            }
            "POSSIBLE_MIDDLEBOX" => RouteAnalysisCompletionReasonCode::PossibleMiddlebox,
            "ROUTE_NOT_FOUND" => RouteAnalysisCompletionReasonCode::RouteNotFound,
            "TRANSIT_GATEWAY_ATTACHMENT_ATTACH_ARN_NO_MATCH" => {
                RouteAnalysisCompletionReasonCode::TransitGatewayAttachment
            }
            "TRANSIT_GATEWAY_ATTACHMENT_NOT_FOUND" => {
                RouteAnalysisCompletionReasonCode::TransitGatewayAttachmentNotFound
            }
            "TRANSIT_GATEWAY_ATTACHMENT_NOT_IN_TRANSIT_GATEWAY" => {
                RouteAnalysisCompletionReasonCode::TransitGatewayAttachmentNotInTransitGateway
            }
            "TRANSIT_GATEWAY_ATTACHMENT_STABLE_ROUTE_TABLE_NOT_FOUND" => {
                RouteAnalysisCompletionReasonCode::TransitGatewayAttachmentStableRouteTableNotFound
            }
            other => RouteAnalysisCompletionReasonCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RouteAnalysisCompletionReasonCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RouteAnalysisCompletionReasonCode::from(s))
    }
}
impl RouteAnalysisCompletionReasonCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RouteAnalysisCompletionReasonCode::BlackholeRouteForDestinationFound => {
                "BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND"
            }
            RouteAnalysisCompletionReasonCode::CyclicPathDetected => "CYCLIC_PATH_DETECTED",
            RouteAnalysisCompletionReasonCode::InactiveRouteForDestinationFound => {
                "INACTIVE_ROUTE_FOR_DESTINATION_FOUND"
            }
            RouteAnalysisCompletionReasonCode::MaxHopsExceeded => "MAX_HOPS_EXCEEDED",
            RouteAnalysisCompletionReasonCode::NoDestinationArnProvided => {
                "NO_DESTINATION_ARN_PROVIDED"
            }
            RouteAnalysisCompletionReasonCode::PossibleMiddlebox => "POSSIBLE_MIDDLEBOX",
            RouteAnalysisCompletionReasonCode::RouteNotFound => "ROUTE_NOT_FOUND",
            RouteAnalysisCompletionReasonCode::TransitGatewayAttachment => {
                "TRANSIT_GATEWAY_ATTACHMENT_ATTACH_ARN_NO_MATCH"
            }
            RouteAnalysisCompletionReasonCode::TransitGatewayAttachmentNotFound => {
                "TRANSIT_GATEWAY_ATTACHMENT_NOT_FOUND"
            }
            RouteAnalysisCompletionReasonCode::TransitGatewayAttachmentNotInTransitGateway => {
                "TRANSIT_GATEWAY_ATTACHMENT_NOT_IN_TRANSIT_GATEWAY"
            }
            RouteAnalysisCompletionReasonCode::TransitGatewayAttachmentStableRouteTableNotFound => {
                "TRANSIT_GATEWAY_ATTACHMENT_STABLE_ROUTE_TABLE_NOT_FOUND"
            }
            RouteAnalysisCompletionReasonCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND",
            "CYCLIC_PATH_DETECTED",
            "INACTIVE_ROUTE_FOR_DESTINATION_FOUND",
            "MAX_HOPS_EXCEEDED",
            "NO_DESTINATION_ARN_PROVIDED",
            "POSSIBLE_MIDDLEBOX",
            "ROUTE_NOT_FOUND",
            "TRANSIT_GATEWAY_ATTACHMENT_ATTACH_ARN_NO_MATCH",
            "TRANSIT_GATEWAY_ATTACHMENT_NOT_FOUND",
            "TRANSIT_GATEWAY_ATTACHMENT_NOT_IN_TRANSIT_GATEWAY",
            "TRANSIT_GATEWAY_ATTACHMENT_STABLE_ROUTE_TABLE_NOT_FOUND",
        ]
    }
}
impl AsRef<str> for RouteAnalysisCompletionReasonCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RouteAnalysisCompletionResultCode {
    #[allow(missing_docs)] // documentation missing in model
    Connected,
    #[allow(missing_docs)] // documentation missing in model
    NotConnected,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RouteAnalysisCompletionResultCode {
    fn from(s: &str) -> Self {
        match s {
            "CONNECTED" => RouteAnalysisCompletionResultCode::Connected,
            "NOT_CONNECTED" => RouteAnalysisCompletionResultCode::NotConnected,
            other => RouteAnalysisCompletionResultCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RouteAnalysisCompletionResultCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RouteAnalysisCompletionResultCode::from(s))
    }
}
impl RouteAnalysisCompletionResultCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RouteAnalysisCompletionResultCode::Connected => "CONNECTED",
            RouteAnalysisCompletionResultCode::NotConnected => "NOT_CONNECTED",
            RouteAnalysisCompletionResultCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONNECTED", "NOT_CONNECTED"]
    }
}
impl AsRef<str> for RouteAnalysisCompletionResultCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a source or a destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RouteAnalysisEndpointOptions {
    /// <p>The ARN of the transit gateway attachment.</p>
    pub transit_gateway_attachment_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the transit gateway.</p>
    pub transit_gateway_arn: std::option::Option<std::string::String>,
    /// <p>The IP address.</p>
    pub ip_address: std::option::Option<std::string::String>,
}
impl RouteAnalysisEndpointOptions {
    /// <p>The ARN of the transit gateway attachment.</p>
    pub fn transit_gateway_attachment_arn(&self) -> std::option::Option<&str> {
        self.transit_gateway_attachment_arn.as_deref()
    }
    /// <p>The ARN of the transit gateway.</p>
    pub fn transit_gateway_arn(&self) -> std::option::Option<&str> {
        self.transit_gateway_arn.as_deref()
    }
    /// <p>The IP address.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
}
impl std::fmt::Debug for RouteAnalysisEndpointOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RouteAnalysisEndpointOptions");
        formatter.field(
            "transit_gateway_attachment_arn",
            &self.transit_gateway_attachment_arn,
        );
        formatter.field("transit_gateway_arn", &self.transit_gateway_arn);
        formatter.field("ip_address", &self.ip_address);
        formatter.finish()
    }
}
/// See [`RouteAnalysisEndpointOptions`](crate::model::RouteAnalysisEndpointOptions)
pub mod route_analysis_endpoint_options {
    /// A builder for [`RouteAnalysisEndpointOptions`](crate::model::RouteAnalysisEndpointOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_attachment_arn: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_arn: std::option::Option<std::string::String>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the transit gateway attachment.</p>
        pub fn transit_gateway_attachment_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the transit gateway attachment.</p>
        pub fn set_transit_gateway_attachment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_arn = input;
            self
        }
        /// <p>The ARN of the transit gateway.</p>
        pub fn transit_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.transit_gateway_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the transit gateway.</p>
        pub fn set_transit_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_arn = input;
            self
        }
        /// <p>The IP address.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The IP address.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// Consumes the builder and constructs a [`RouteAnalysisEndpointOptions`](crate::model::RouteAnalysisEndpointOptions)
        pub fn build(self) -> crate::model::RouteAnalysisEndpointOptions {
            crate::model::RouteAnalysisEndpointOptions {
                transit_gateway_attachment_arn: self.transit_gateway_attachment_arn,
                transit_gateway_arn: self.transit_gateway_arn,
                ip_address: self.ip_address,
            }
        }
    }
}
impl RouteAnalysisEndpointOptions {
    /// Creates a new builder-style object to manufacture [`RouteAnalysisEndpointOptions`](crate::model::RouteAnalysisEndpointOptions)
    pub fn builder() -> crate::model::route_analysis_endpoint_options::Builder {
        crate::model::route_analysis_endpoint_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RouteAnalysisStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RouteAnalysisStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => RouteAnalysisStatus::Completed,
            "FAILED" => RouteAnalysisStatus::Failed,
            "RUNNING" => RouteAnalysisStatus::Running,
            other => RouteAnalysisStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RouteAnalysisStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RouteAnalysisStatus::from(s))
    }
}
impl RouteAnalysisStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RouteAnalysisStatus::Completed => "COMPLETED",
            RouteAnalysisStatus::Failed => "FAILED",
            RouteAnalysisStatus::Running => "RUNNING",
            RouteAnalysisStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "FAILED", "RUNNING"]
    }
}
impl AsRef<str> for RouteAnalysisStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a source or a destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RouteAnalysisEndpointOptionsSpecification {
    /// <p>The ARN of the transit gateway attachment.</p>
    pub transit_gateway_attachment_arn: std::option::Option<std::string::String>,
    /// <p>The IP address.</p>
    pub ip_address: std::option::Option<std::string::String>,
}
impl RouteAnalysisEndpointOptionsSpecification {
    /// <p>The ARN of the transit gateway attachment.</p>
    pub fn transit_gateway_attachment_arn(&self) -> std::option::Option<&str> {
        self.transit_gateway_attachment_arn.as_deref()
    }
    /// <p>The IP address.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
}
impl std::fmt::Debug for RouteAnalysisEndpointOptionsSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RouteAnalysisEndpointOptionsSpecification");
        formatter.field(
            "transit_gateway_attachment_arn",
            &self.transit_gateway_attachment_arn,
        );
        formatter.field("ip_address", &self.ip_address);
        formatter.finish()
    }
}
/// See [`RouteAnalysisEndpointOptionsSpecification`](crate::model::RouteAnalysisEndpointOptionsSpecification)
pub mod route_analysis_endpoint_options_specification {
    /// A builder for [`RouteAnalysisEndpointOptionsSpecification`](crate::model::RouteAnalysisEndpointOptionsSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_attachment_arn: std::option::Option<std::string::String>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the transit gateway attachment.</p>
        pub fn transit_gateway_attachment_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the transit gateway attachment.</p>
        pub fn set_transit_gateway_attachment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_arn = input;
            self
        }
        /// <p>The IP address.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The IP address.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// Consumes the builder and constructs a [`RouteAnalysisEndpointOptionsSpecification`](crate::model::RouteAnalysisEndpointOptionsSpecification)
        pub fn build(self) -> crate::model::RouteAnalysisEndpointOptionsSpecification {
            crate::model::RouteAnalysisEndpointOptionsSpecification {
                transit_gateway_attachment_arn: self.transit_gateway_attachment_arn,
                ip_address: self.ip_address,
            }
        }
    }
}
impl RouteAnalysisEndpointOptionsSpecification {
    /// Creates a new builder-style object to manufacture [`RouteAnalysisEndpointOptionsSpecification`](crate::model::RouteAnalysisEndpointOptionsSpecification)
    pub fn builder() -> crate::model::route_analysis_endpoint_options_specification::Builder {
        crate::model::route_analysis_endpoint_options_specification::Builder::default()
    }
}

/// <p>Describes a core network policy. You can have only one LIVE Core Policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoreNetworkPolicy {
    /// <p>The ID of a core network.</p>
    pub core_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the policy version.</p>
    pub policy_version_id: std::option::Option<i32>,
    /// <p>Whether a core network policy is the current LIVE policy or the most recently submitted policy.</p>
    pub alias: std::option::Option<crate::model::CoreNetworkPolicyAlias>,
    /// <p>The description of a core network policy.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The timestamp when a core network policy was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The state of a core network policy.</p>
    pub change_set_state: std::option::Option<crate::model::ChangeSetState>,
    /// <p>Describes any errors in a core network policy.</p>
    pub policy_errors: std::option::Option<std::vec::Vec<crate::model::CoreNetworkPolicyError>>,
    /// <p>Describes a core network policy.</p>
    pub policy_document: std::option::Option<std::string::String>,
}
impl CoreNetworkPolicy {
    /// <p>The ID of a core network.</p>
    pub fn core_network_id(&self) -> std::option::Option<&str> {
        self.core_network_id.as_deref()
    }
    /// <p>The ID of the policy version.</p>
    pub fn policy_version_id(&self) -> std::option::Option<i32> {
        self.policy_version_id
    }
    /// <p>Whether a core network policy is the current LIVE policy or the most recently submitted policy.</p>
    pub fn alias(&self) -> std::option::Option<&crate::model::CoreNetworkPolicyAlias> {
        self.alias.as_ref()
    }
    /// <p>The description of a core network policy.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The timestamp when a core network policy was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The state of a core network policy.</p>
    pub fn change_set_state(&self) -> std::option::Option<&crate::model::ChangeSetState> {
        self.change_set_state.as_ref()
    }
    /// <p>Describes any errors in a core network policy.</p>
    pub fn policy_errors(&self) -> std::option::Option<&[crate::model::CoreNetworkPolicyError]> {
        self.policy_errors.as_deref()
    }
    /// <p>Describes a core network policy.</p>
    pub fn policy_document(&self) -> std::option::Option<&str> {
        self.policy_document.as_deref()
    }
}
impl std::fmt::Debug for CoreNetworkPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoreNetworkPolicy");
        formatter.field("core_network_id", &self.core_network_id);
        formatter.field("policy_version_id", &self.policy_version_id);
        formatter.field("alias", &self.alias);
        formatter.field("description", &self.description);
        formatter.field("created_at", &self.created_at);
        formatter.field("change_set_state", &self.change_set_state);
        formatter.field("policy_errors", &self.policy_errors);
        formatter.field("policy_document", &self.policy_document);
        formatter.finish()
    }
}
/// See [`CoreNetworkPolicy`](crate::model::CoreNetworkPolicy)
pub mod core_network_policy {
    /// A builder for [`CoreNetworkPolicy`](crate::model::CoreNetworkPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network_id: std::option::Option<std::string::String>,
        pub(crate) policy_version_id: std::option::Option<i32>,
        pub(crate) alias: std::option::Option<crate::model::CoreNetworkPolicyAlias>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) change_set_state: std::option::Option<crate::model::ChangeSetState>,
        pub(crate) policy_errors:
            std::option::Option<std::vec::Vec<crate::model::CoreNetworkPolicyError>>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_network_id = Some(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_network_id = input;
            self
        }
        /// <p>The ID of the policy version.</p>
        pub fn policy_version_id(mut self, input: i32) -> Self {
            self.policy_version_id = Some(input);
            self
        }
        /// <p>The ID of the policy version.</p>
        pub fn set_policy_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.policy_version_id = input;
            self
        }
        /// <p>Whether a core network policy is the current LIVE policy or the most recently submitted policy.</p>
        pub fn alias(mut self, input: crate::model::CoreNetworkPolicyAlias) -> Self {
            self.alias = Some(input);
            self
        }
        /// <p>Whether a core network policy is the current LIVE policy or the most recently submitted policy.</p>
        pub fn set_alias(
            mut self,
            input: std::option::Option<crate::model::CoreNetworkPolicyAlias>,
        ) -> Self {
            self.alias = input;
            self
        }
        /// <p>The description of a core network policy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of a core network policy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The timestamp when a core network policy was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when a core network policy was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The state of a core network policy.</p>
        pub fn change_set_state(mut self, input: crate::model::ChangeSetState) -> Self {
            self.change_set_state = Some(input);
            self
        }
        /// <p>The state of a core network policy.</p>
        pub fn set_change_set_state(
            mut self,
            input: std::option::Option<crate::model::ChangeSetState>,
        ) -> Self {
            self.change_set_state = input;
            self
        }
        /// Appends an item to `policy_errors`.
        ///
        /// To override the contents of this collection use [`set_policy_errors`](Self::set_policy_errors).
        ///
        /// <p>Describes any errors in a core network policy.</p>
        pub fn policy_errors(mut self, input: crate::model::CoreNetworkPolicyError) -> Self {
            let mut v = self.policy_errors.unwrap_or_default();
            v.push(input);
            self.policy_errors = Some(v);
            self
        }
        /// <p>Describes any errors in a core network policy.</p>
        pub fn set_policy_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CoreNetworkPolicyError>>,
        ) -> Self {
            self.policy_errors = input;
            self
        }
        /// <p>Describes a core network policy.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>Describes a core network policy.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// Consumes the builder and constructs a [`CoreNetworkPolicy`](crate::model::CoreNetworkPolicy)
        pub fn build(self) -> crate::model::CoreNetworkPolicy {
            crate::model::CoreNetworkPolicy {
                core_network_id: self.core_network_id,
                policy_version_id: self.policy_version_id,
                alias: self.alias,
                description: self.description,
                created_at: self.created_at,
                change_set_state: self.change_set_state,
                policy_errors: self.policy_errors,
                policy_document: self.policy_document,
            }
        }
    }
}
impl CoreNetworkPolicy {
    /// Creates a new builder-style object to manufacture [`CoreNetworkPolicy`](crate::model::CoreNetworkPolicy)
    pub fn builder() -> crate::model::core_network_policy::Builder {
        crate::model::core_network_policy::Builder::default()
    }
}

/// <p>Provides details about an error in a core network policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoreNetworkPolicyError {
    /// <p>The error code associated with a core network policy error.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The message associated with a core network policy error code.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The JSON path where the error was discovered in the policy document.</p>
    pub path: std::option::Option<std::string::String>,
}
impl CoreNetworkPolicyError {
    /// <p>The error code associated with a core network policy error.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The message associated with a core network policy error code.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The JSON path where the error was discovered in the policy document.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
}
impl std::fmt::Debug for CoreNetworkPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoreNetworkPolicyError");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.field("path", &self.path);
        formatter.finish()
    }
}
/// See [`CoreNetworkPolicyError`](crate::model::CoreNetworkPolicyError)
pub mod core_network_policy_error {
    /// A builder for [`CoreNetworkPolicyError`](crate::model::CoreNetworkPolicyError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code associated with a core network policy error.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code associated with a core network policy error.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The message associated with a core network policy error code.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message associated with a core network policy error code.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The JSON path where the error was discovered in the policy document.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The JSON path where the error was discovered in the policy document.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Consumes the builder and constructs a [`CoreNetworkPolicyError`](crate::model::CoreNetworkPolicyError)
        pub fn build(self) -> crate::model::CoreNetworkPolicyError {
            crate::model::CoreNetworkPolicyError {
                error_code: self.error_code,
                message: self.message,
                path: self.path,
            }
        }
    }
}
impl CoreNetworkPolicyError {
    /// Creates a new builder-style object to manufacture [`CoreNetworkPolicyError`](crate::model::CoreNetworkPolicyError)
    pub fn builder() -> crate::model::core_network_policy_error::Builder {
        crate::model::core_network_policy_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeSetState {
    #[allow(missing_docs)] // documentation missing in model
    Executing,
    #[allow(missing_docs)] // documentation missing in model
    ExecutionSucceeded,
    #[allow(missing_docs)] // documentation missing in model
    FailedGeneration,
    #[allow(missing_docs)] // documentation missing in model
    OutOfDate,
    #[allow(missing_docs)] // documentation missing in model
    PendingGeneration,
    #[allow(missing_docs)] // documentation missing in model
    ReadyToExecute,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeSetState {
    fn from(s: &str) -> Self {
        match s {
            "EXECUTING" => ChangeSetState::Executing,
            "EXECUTION_SUCCEEDED" => ChangeSetState::ExecutionSucceeded,
            "FAILED_GENERATION" => ChangeSetState::FailedGeneration,
            "OUT_OF_DATE" => ChangeSetState::OutOfDate,
            "PENDING_GENERATION" => ChangeSetState::PendingGeneration,
            "READY_TO_EXECUTE" => ChangeSetState::ReadyToExecute,
            other => ChangeSetState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangeSetState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeSetState::from(s))
    }
}
impl ChangeSetState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeSetState::Executing => "EXECUTING",
            ChangeSetState::ExecutionSucceeded => "EXECUTION_SUCCEEDED",
            ChangeSetState::FailedGeneration => "FAILED_GENERATION",
            ChangeSetState::OutOfDate => "OUT_OF_DATE",
            ChangeSetState::PendingGeneration => "PENDING_GENERATION",
            ChangeSetState::ReadyToExecute => "READY_TO_EXECUTE",
            ChangeSetState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EXECUTING",
            "EXECUTION_SUCCEEDED",
            "FAILED_GENERATION",
            "OUT_OF_DATE",
            "PENDING_GENERATION",
            "READY_TO_EXECUTE",
        ]
    }
}
impl AsRef<str> for ChangeSetState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CoreNetworkPolicyAlias {
    #[allow(missing_docs)] // documentation missing in model
    Latest,
    #[allow(missing_docs)] // documentation missing in model
    Live,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CoreNetworkPolicyAlias {
    fn from(s: &str) -> Self {
        match s {
            "LATEST" => CoreNetworkPolicyAlias::Latest,
            "LIVE" => CoreNetworkPolicyAlias::Live,
            other => CoreNetworkPolicyAlias::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CoreNetworkPolicyAlias {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CoreNetworkPolicyAlias::from(s))
    }
}
impl CoreNetworkPolicyAlias {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CoreNetworkPolicyAlias::Latest => "LATEST",
            CoreNetworkPolicyAlias::Live => "LIVE",
            CoreNetworkPolicyAlias::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LATEST", "LIVE"]
    }
}
impl AsRef<str> for CoreNetworkPolicyAlias {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the registration of a transit gateway to a global network.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransitGatewayRegistration {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
    pub transit_gateway_arn: std::option::Option<std::string::String>,
    /// <p>The state of the transit gateway registration.</p>
    pub state: std::option::Option<crate::model::TransitGatewayRegistrationStateReason>,
}
impl TransitGatewayRegistration {
    /// <p>The ID of the global network.</p>
    pub fn global_network_id(&self) -> std::option::Option<&str> {
        self.global_network_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
    pub fn transit_gateway_arn(&self) -> std::option::Option<&str> {
        self.transit_gateway_arn.as_deref()
    }
    /// <p>The state of the transit gateway registration.</p>
    pub fn state(
        &self,
    ) -> std::option::Option<&crate::model::TransitGatewayRegistrationStateReason> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for TransitGatewayRegistration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransitGatewayRegistration");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("transit_gateway_arn", &self.transit_gateway_arn);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`TransitGatewayRegistration`](crate::model::TransitGatewayRegistration)
pub mod transit_gateway_registration {
    /// A builder for [`TransitGatewayRegistration`](crate::model::TransitGatewayRegistration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::TransitGatewayRegistrationStateReason>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
        pub fn transit_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.transit_gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
        pub fn set_transit_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_arn = input;
            self
        }
        /// <p>The state of the transit gateway registration.</p>
        pub fn state(mut self, input: crate::model::TransitGatewayRegistrationStateReason) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the transit gateway registration.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::TransitGatewayRegistrationStateReason>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`TransitGatewayRegistration`](crate::model::TransitGatewayRegistration)
        pub fn build(self) -> crate::model::TransitGatewayRegistration {
            crate::model::TransitGatewayRegistration {
                global_network_id: self.global_network_id,
                transit_gateway_arn: self.transit_gateway_arn,
                state: self.state,
            }
        }
    }
}
impl TransitGatewayRegistration {
    /// Creates a new builder-style object to manufacture [`TransitGatewayRegistration`](crate::model::TransitGatewayRegistration)
    pub fn builder() -> crate::model::transit_gateway_registration::Builder {
        crate::model::transit_gateway_registration::Builder::default()
    }
}

/// <p>Describes the status of a transit gateway registration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransitGatewayRegistrationStateReason {
    /// <p>The code for the state reason.</p>
    pub code: std::option::Option<crate::model::TransitGatewayRegistrationState>,
    /// <p>The message for the state reason.</p>
    pub message: std::option::Option<std::string::String>,
}
impl TransitGatewayRegistrationStateReason {
    /// <p>The code for the state reason.</p>
    pub fn code(&self) -> std::option::Option<&crate::model::TransitGatewayRegistrationState> {
        self.code.as_ref()
    }
    /// <p>The message for the state reason.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for TransitGatewayRegistrationStateReason {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransitGatewayRegistrationStateReason");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`TransitGatewayRegistrationStateReason`](crate::model::TransitGatewayRegistrationStateReason)
pub mod transit_gateway_registration_state_reason {
    /// A builder for [`TransitGatewayRegistrationStateReason`](crate::model::TransitGatewayRegistrationStateReason)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::TransitGatewayRegistrationState>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The code for the state reason.</p>
        pub fn code(mut self, input: crate::model::TransitGatewayRegistrationState) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The code for the state reason.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::TransitGatewayRegistrationState>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>The message for the state reason.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the state reason.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TransitGatewayRegistrationStateReason`](crate::model::TransitGatewayRegistrationStateReason)
        pub fn build(self) -> crate::model::TransitGatewayRegistrationStateReason {
            crate::model::TransitGatewayRegistrationStateReason {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl TransitGatewayRegistrationStateReason {
    /// Creates a new builder-style object to manufacture [`TransitGatewayRegistrationStateReason`](crate::model::TransitGatewayRegistrationStateReason)
    pub fn builder() -> crate::model::transit_gateway_registration_state_reason::Builder {
        crate::model::transit_gateway_registration_state_reason::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransitGatewayRegistrationState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransitGatewayRegistrationState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => TransitGatewayRegistrationState::Available,
            "DELETED" => TransitGatewayRegistrationState::Deleted,
            "DELETING" => TransitGatewayRegistrationState::Deleting,
            "FAILED" => TransitGatewayRegistrationState::Failed,
            "PENDING" => TransitGatewayRegistrationState::Pending,
            other => TransitGatewayRegistrationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransitGatewayRegistrationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransitGatewayRegistrationState::from(s))
    }
}
impl TransitGatewayRegistrationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransitGatewayRegistrationState::Available => "AVAILABLE",
            TransitGatewayRegistrationState::Deleted => "DELETED",
            TransitGatewayRegistrationState::Deleting => "DELETING",
            TransitGatewayRegistrationState::Failed => "FAILED",
            TransitGatewayRegistrationState::Pending => "PENDING",
            TransitGatewayRegistrationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETED", "DELETING", "FAILED", "PENDING"]
    }
}
impl AsRef<str> for TransitGatewayRegistrationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returns summary information about a core network.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoreNetworkSummary {
    /// <p>The ID of a core network.</p>
    pub core_network_id: std::option::Option<std::string::String>,
    /// <p>a core network ARN.</p>
    pub core_network_arn: std::option::Option<std::string::String>,
    /// <p>The global network ID.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the account owner.</p>
    pub owner_account_id: std::option::Option<std::string::String>,
    /// <p>The state of a core network.</p>
    pub state: std::option::Option<crate::model::CoreNetworkState>,
    /// <p>The description of a core network.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The key-value tags associated with a core network summary.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CoreNetworkSummary {
    /// <p>The ID of a core network.</p>
    pub fn core_network_id(&self) -> std::option::Option<&str> {
        self.core_network_id.as_deref()
    }
    /// <p>a core network ARN.</p>
    pub fn core_network_arn(&self) -> std::option::Option<&str> {
        self.core_network_arn.as_deref()
    }
    /// <p>The global network ID.</p>
    pub fn global_network_id(&self) -> std::option::Option<&str> {
        self.global_network_id.as_deref()
    }
    /// <p>The ID of the account owner.</p>
    pub fn owner_account_id(&self) -> std::option::Option<&str> {
        self.owner_account_id.as_deref()
    }
    /// <p>The state of a core network.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::CoreNetworkState> {
        self.state.as_ref()
    }
    /// <p>The description of a core network.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The key-value tags associated with a core network summary.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CoreNetworkSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoreNetworkSummary");
        formatter.field("core_network_id", &self.core_network_id);
        formatter.field("core_network_arn", &self.core_network_arn);
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("owner_account_id", &self.owner_account_id);
        formatter.field("state", &self.state);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CoreNetworkSummary`](crate::model::CoreNetworkSummary)
pub mod core_network_summary {
    /// A builder for [`CoreNetworkSummary`](crate::model::CoreNetworkSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network_id: std::option::Option<std::string::String>,
        pub(crate) core_network_arn: std::option::Option<std::string::String>,
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) owner_account_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::CoreNetworkState>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_network_id = Some(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_network_id = input;
            self
        }
        /// <p>a core network ARN.</p>
        pub fn core_network_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_network_arn = Some(input.into());
            self
        }
        /// <p>a core network ARN.</p>
        pub fn set_core_network_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_network_arn = input;
            self
        }
        /// <p>The global network ID.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The global network ID.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the account owner.</p>
        pub fn owner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the account owner.</p>
        pub fn set_owner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account_id = input;
            self
        }
        /// <p>The state of a core network.</p>
        pub fn state(mut self, input: crate::model::CoreNetworkState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of a core network.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::CoreNetworkState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The description of a core network.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of a core network.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value tags associated with a core network summary.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The key-value tags associated with a core network summary.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CoreNetworkSummary`](crate::model::CoreNetworkSummary)
        pub fn build(self) -> crate::model::CoreNetworkSummary {
            crate::model::CoreNetworkSummary {
                core_network_id: self.core_network_id,
                core_network_arn: self.core_network_arn,
                global_network_id: self.global_network_id,
                owner_account_id: self.owner_account_id,
                state: self.state,
                description: self.description,
                tags: self.tags,
            }
        }
    }
}
impl CoreNetworkSummary {
    /// Creates a new builder-style object to manufacture [`CoreNetworkSummary`](crate::model::CoreNetworkSummary)
    pub fn builder() -> crate::model::core_network_summary::Builder {
        crate::model::core_network_summary::Builder::default()
    }
}

/// <p>Describes a core network policy version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoreNetworkPolicyVersion {
    /// <p>The ID of a core network.</p>
    pub core_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the policy version.</p>
    pub policy_version_id: std::option::Option<i32>,
    /// <p>Whether a core network policy is the current policy or the most recently submitted policy.</p>
    pub alias: std::option::Option<crate::model::CoreNetworkPolicyAlias>,
    /// <p>The description of a core network policy version.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The timestamp when a core network policy version was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the policy version change set.</p>
    pub change_set_state: std::option::Option<crate::model::ChangeSetState>,
}
impl CoreNetworkPolicyVersion {
    /// <p>The ID of a core network.</p>
    pub fn core_network_id(&self) -> std::option::Option<&str> {
        self.core_network_id.as_deref()
    }
    /// <p>The ID of the policy version.</p>
    pub fn policy_version_id(&self) -> std::option::Option<i32> {
        self.policy_version_id
    }
    /// <p>Whether a core network policy is the current policy or the most recently submitted policy.</p>
    pub fn alias(&self) -> std::option::Option<&crate::model::CoreNetworkPolicyAlias> {
        self.alias.as_ref()
    }
    /// <p>The description of a core network policy version.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The timestamp when a core network policy version was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The status of the policy version change set.</p>
    pub fn change_set_state(&self) -> std::option::Option<&crate::model::ChangeSetState> {
        self.change_set_state.as_ref()
    }
}
impl std::fmt::Debug for CoreNetworkPolicyVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoreNetworkPolicyVersion");
        formatter.field("core_network_id", &self.core_network_id);
        formatter.field("policy_version_id", &self.policy_version_id);
        formatter.field("alias", &self.alias);
        formatter.field("description", &self.description);
        formatter.field("created_at", &self.created_at);
        formatter.field("change_set_state", &self.change_set_state);
        formatter.finish()
    }
}
/// See [`CoreNetworkPolicyVersion`](crate::model::CoreNetworkPolicyVersion)
pub mod core_network_policy_version {
    /// A builder for [`CoreNetworkPolicyVersion`](crate::model::CoreNetworkPolicyVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network_id: std::option::Option<std::string::String>,
        pub(crate) policy_version_id: std::option::Option<i32>,
        pub(crate) alias: std::option::Option<crate::model::CoreNetworkPolicyAlias>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) change_set_state: std::option::Option<crate::model::ChangeSetState>,
    }
    impl Builder {
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_network_id = Some(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_network_id = input;
            self
        }
        /// <p>The ID of the policy version.</p>
        pub fn policy_version_id(mut self, input: i32) -> Self {
            self.policy_version_id = Some(input);
            self
        }
        /// <p>The ID of the policy version.</p>
        pub fn set_policy_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.policy_version_id = input;
            self
        }
        /// <p>Whether a core network policy is the current policy or the most recently submitted policy.</p>
        pub fn alias(mut self, input: crate::model::CoreNetworkPolicyAlias) -> Self {
            self.alias = Some(input);
            self
        }
        /// <p>Whether a core network policy is the current policy or the most recently submitted policy.</p>
        pub fn set_alias(
            mut self,
            input: std::option::Option<crate::model::CoreNetworkPolicyAlias>,
        ) -> Self {
            self.alias = input;
            self
        }
        /// <p>The description of a core network policy version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of a core network policy version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The timestamp when a core network policy version was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when a core network policy version was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The status of the policy version change set.</p>
        pub fn change_set_state(mut self, input: crate::model::ChangeSetState) -> Self {
            self.change_set_state = Some(input);
            self
        }
        /// <p>The status of the policy version change set.</p>
        pub fn set_change_set_state(
            mut self,
            input: std::option::Option<crate::model::ChangeSetState>,
        ) -> Self {
            self.change_set_state = input;
            self
        }
        /// Consumes the builder and constructs a [`CoreNetworkPolicyVersion`](crate::model::CoreNetworkPolicyVersion)
        pub fn build(self) -> crate::model::CoreNetworkPolicyVersion {
            crate::model::CoreNetworkPolicyVersion {
                core_network_id: self.core_network_id,
                policy_version_id: self.policy_version_id,
                alias: self.alias,
                description: self.description,
                created_at: self.created_at,
                change_set_state: self.change_set_state,
            }
        }
    }
}
impl CoreNetworkPolicyVersion {
    /// Creates a new builder-style object to manufacture [`CoreNetworkPolicyVersion`](crate::model::CoreNetworkPolicyVersion)
    pub fn builder() -> crate::model::core_network_policy_version::Builder {
        crate::model::core_network_policy_version::Builder::default()
    }
}

/// <p>Summary description of a Connect peer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectPeerSummary {
    /// <p>The ID of a core network.</p>
    pub core_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of a Connect peer attachment.</p>
    pub connect_attachment_id: std::option::Option<std::string::String>,
    /// <p>The ID of a Connect peer.</p>
    pub connect_peer_id: std::option::Option<std::string::String>,
    /// <p>The Region where the edge is located.</p>
    pub edge_location: std::option::Option<std::string::String>,
    /// <p>The state of a Connect peer.</p>
    pub connect_peer_state: std::option::Option<crate::model::ConnectPeerState>,
    /// <p>The timestamp when a Connect peer was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The tags associated with a Connect peer summary.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ConnectPeerSummary {
    /// <p>The ID of a core network.</p>
    pub fn core_network_id(&self) -> std::option::Option<&str> {
        self.core_network_id.as_deref()
    }
    /// <p>The ID of a Connect peer attachment.</p>
    pub fn connect_attachment_id(&self) -> std::option::Option<&str> {
        self.connect_attachment_id.as_deref()
    }
    /// <p>The ID of a Connect peer.</p>
    pub fn connect_peer_id(&self) -> std::option::Option<&str> {
        self.connect_peer_id.as_deref()
    }
    /// <p>The Region where the edge is located.</p>
    pub fn edge_location(&self) -> std::option::Option<&str> {
        self.edge_location.as_deref()
    }
    /// <p>The state of a Connect peer.</p>
    pub fn connect_peer_state(&self) -> std::option::Option<&crate::model::ConnectPeerState> {
        self.connect_peer_state.as_ref()
    }
    /// <p>The timestamp when a Connect peer was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The tags associated with a Connect peer summary.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ConnectPeerSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectPeerSummary");
        formatter.field("core_network_id", &self.core_network_id);
        formatter.field("connect_attachment_id", &self.connect_attachment_id);
        formatter.field("connect_peer_id", &self.connect_peer_id);
        formatter.field("edge_location", &self.edge_location);
        formatter.field("connect_peer_state", &self.connect_peer_state);
        formatter.field("created_at", &self.created_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ConnectPeerSummary`](crate::model::ConnectPeerSummary)
pub mod connect_peer_summary {
    /// A builder for [`ConnectPeerSummary`](crate::model::ConnectPeerSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network_id: std::option::Option<std::string::String>,
        pub(crate) connect_attachment_id: std::option::Option<std::string::String>,
        pub(crate) connect_peer_id: std::option::Option<std::string::String>,
        pub(crate) edge_location: std::option::Option<std::string::String>,
        pub(crate) connect_peer_state: std::option::Option<crate::model::ConnectPeerState>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_network_id = Some(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_network_id = input;
            self
        }
        /// <p>The ID of a Connect peer attachment.</p>
        pub fn connect_attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connect_attachment_id = Some(input.into());
            self
        }
        /// <p>The ID of a Connect peer attachment.</p>
        pub fn set_connect_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connect_attachment_id = input;
            self
        }
        /// <p>The ID of a Connect peer.</p>
        pub fn connect_peer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connect_peer_id = Some(input.into());
            self
        }
        /// <p>The ID of a Connect peer.</p>
        pub fn set_connect_peer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connect_peer_id = input;
            self
        }
        /// <p>The Region where the edge is located.</p>
        pub fn edge_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.edge_location = Some(input.into());
            self
        }
        /// <p>The Region where the edge is located.</p>
        pub fn set_edge_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.edge_location = input;
            self
        }
        /// <p>The state of a Connect peer.</p>
        pub fn connect_peer_state(mut self, input: crate::model::ConnectPeerState) -> Self {
            self.connect_peer_state = Some(input);
            self
        }
        /// <p>The state of a Connect peer.</p>
        pub fn set_connect_peer_state(
            mut self,
            input: std::option::Option<crate::model::ConnectPeerState>,
        ) -> Self {
            self.connect_peer_state = input;
            self
        }
        /// <p>The timestamp when a Connect peer was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when a Connect peer was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with a Connect peer summary.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with a Connect peer summary.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectPeerSummary`](crate::model::ConnectPeerSummary)
        pub fn build(self) -> crate::model::ConnectPeerSummary {
            crate::model::ConnectPeerSummary {
                core_network_id: self.core_network_id,
                connect_attachment_id: self.connect_attachment_id,
                connect_peer_id: self.connect_peer_id,
                edge_location: self.edge_location,
                connect_peer_state: self.connect_peer_state,
                created_at: self.created_at,
                tags: self.tags,
            }
        }
    }
}
impl ConnectPeerSummary {
    /// Creates a new builder-style object to manufacture [`ConnectPeerSummary`](crate::model::ConnectPeerSummary)
    pub fn builder() -> crate::model::connect_peer_summary::Builder {
        crate::model::connect_peer_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectPeerState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectPeerState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => ConnectPeerState::Available,
            "CREATING" => ConnectPeerState::Creating,
            "DELETING" => ConnectPeerState::Deleting,
            "FAILED" => ConnectPeerState::Failed,
            other => ConnectPeerState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectPeerState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectPeerState::from(s))
    }
}
impl ConnectPeerState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectPeerState::Available => "AVAILABLE",
            ConnectPeerState::Creating => "CREATING",
            ConnectPeerState::Deleting => "DELETING",
            ConnectPeerState::Failed => "FAILED",
            ConnectPeerState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "CREATING", "DELETING", "FAILED"]
    }
}
impl AsRef<str> for ConnectPeerState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a transit gateway Connect peer association.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransitGatewayConnectPeerAssociation {
    /// <p>The Amazon Resource Name (ARN) of the transit gateway Connect peer.</p>
    pub transit_gateway_connect_peer_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link.</p>
    pub link_id: std::option::Option<std::string::String>,
    /// <p>The state of the association.</p>
    pub state: std::option::Option<crate::model::TransitGatewayConnectPeerAssociationState>,
}
impl TransitGatewayConnectPeerAssociation {
    /// <p>The Amazon Resource Name (ARN) of the transit gateway Connect peer.</p>
    pub fn transit_gateway_connect_peer_arn(&self) -> std::option::Option<&str> {
        self.transit_gateway_connect_peer_arn.as_deref()
    }
    /// <p>The ID of the global network.</p>
    pub fn global_network_id(&self) -> std::option::Option<&str> {
        self.global_network_id.as_deref()
    }
    /// <p>The ID of the device.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The ID of the link.</p>
    pub fn link_id(&self) -> std::option::Option<&str> {
        self.link_id.as_deref()
    }
    /// <p>The state of the association.</p>
    pub fn state(
        &self,
    ) -> std::option::Option<&crate::model::TransitGatewayConnectPeerAssociationState> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for TransitGatewayConnectPeerAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransitGatewayConnectPeerAssociation");
        formatter.field(
            "transit_gateway_connect_peer_arn",
            &self.transit_gateway_connect_peer_arn,
        );
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("device_id", &self.device_id);
        formatter.field("link_id", &self.link_id);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`TransitGatewayConnectPeerAssociation`](crate::model::TransitGatewayConnectPeerAssociation)
pub mod transit_gateway_connect_peer_association {
    /// A builder for [`TransitGatewayConnectPeerAssociation`](crate::model::TransitGatewayConnectPeerAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_connect_peer_arn: std::option::Option<std::string::String>,
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) link_id: std::option::Option<std::string::String>,
        pub(crate) state:
            std::option::Option<crate::model::TransitGatewayConnectPeerAssociationState>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the transit gateway Connect peer.</p>
        pub fn transit_gateway_connect_peer_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.transit_gateway_connect_peer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway Connect peer.</p>
        pub fn set_transit_gateway_connect_peer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_connect_peer_arn = input;
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// <p>The state of the association.</p>
        pub fn state(
            mut self,
            input: crate::model::TransitGatewayConnectPeerAssociationState,
        ) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the association.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::TransitGatewayConnectPeerAssociationState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`TransitGatewayConnectPeerAssociation`](crate::model::TransitGatewayConnectPeerAssociation)
        pub fn build(self) -> crate::model::TransitGatewayConnectPeerAssociation {
            crate::model::TransitGatewayConnectPeerAssociation {
                transit_gateway_connect_peer_arn: self.transit_gateway_connect_peer_arn,
                global_network_id: self.global_network_id,
                device_id: self.device_id,
                link_id: self.link_id,
                state: self.state,
            }
        }
    }
}
impl TransitGatewayConnectPeerAssociation {
    /// Creates a new builder-style object to manufacture [`TransitGatewayConnectPeerAssociation`](crate::model::TransitGatewayConnectPeerAssociation)
    pub fn builder() -> crate::model::transit_gateway_connect_peer_association::Builder {
        crate::model::transit_gateway_connect_peer_association::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransitGatewayConnectPeerAssociationState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransitGatewayConnectPeerAssociationState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => TransitGatewayConnectPeerAssociationState::Available,
            "DELETED" => TransitGatewayConnectPeerAssociationState::Deleted,
            "DELETING" => TransitGatewayConnectPeerAssociationState::Deleting,
            "PENDING" => TransitGatewayConnectPeerAssociationState::Pending,
            other => TransitGatewayConnectPeerAssociationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransitGatewayConnectPeerAssociationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransitGatewayConnectPeerAssociationState::from(s))
    }
}
impl TransitGatewayConnectPeerAssociationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransitGatewayConnectPeerAssociationState::Available => "AVAILABLE",
            TransitGatewayConnectPeerAssociationState::Deleted => "DELETED",
            TransitGatewayConnectPeerAssociationState::Deleting => "DELETING",
            TransitGatewayConnectPeerAssociationState::Pending => "PENDING",
            TransitGatewayConnectPeerAssociationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETED", "DELETING", "PENDING"]
    }
}
impl AsRef<str> for TransitGatewayConnectPeerAssociationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Creates a site-to-site VPN attachment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SiteToSiteVpnAttachment {
    /// <p>Provides details about a site-to-site VPN attachment.</p>
    pub attachment: std::option::Option<crate::model::Attachment>,
    /// <p>The ARN of the site-to-site VPN attachment. </p>
    pub vpn_connection_arn: std::option::Option<std::string::String>,
}
impl SiteToSiteVpnAttachment {
    /// <p>Provides details about a site-to-site VPN attachment.</p>
    pub fn attachment(&self) -> std::option::Option<&crate::model::Attachment> {
        self.attachment.as_ref()
    }
    /// <p>The ARN of the site-to-site VPN attachment. </p>
    pub fn vpn_connection_arn(&self) -> std::option::Option<&str> {
        self.vpn_connection_arn.as_deref()
    }
}
impl std::fmt::Debug for SiteToSiteVpnAttachment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SiteToSiteVpnAttachment");
        formatter.field("attachment", &self.attachment);
        formatter.field("vpn_connection_arn", &self.vpn_connection_arn);
        formatter.finish()
    }
}
/// See [`SiteToSiteVpnAttachment`](crate::model::SiteToSiteVpnAttachment)
pub mod site_to_site_vpn_attachment {
    /// A builder for [`SiteToSiteVpnAttachment`](crate::model::SiteToSiteVpnAttachment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attachment: std::option::Option<crate::model::Attachment>,
        pub(crate) vpn_connection_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Provides details about a site-to-site VPN attachment.</p>
        pub fn attachment(mut self, input: crate::model::Attachment) -> Self {
            self.attachment = Some(input);
            self
        }
        /// <p>Provides details about a site-to-site VPN attachment.</p>
        pub fn set_attachment(
            mut self,
            input: std::option::Option<crate::model::Attachment>,
        ) -> Self {
            self.attachment = input;
            self
        }
        /// <p>The ARN of the site-to-site VPN attachment. </p>
        pub fn vpn_connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpn_connection_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the site-to-site VPN attachment. </p>
        pub fn set_vpn_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpn_connection_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SiteToSiteVpnAttachment`](crate::model::SiteToSiteVpnAttachment)
        pub fn build(self) -> crate::model::SiteToSiteVpnAttachment {
            crate::model::SiteToSiteVpnAttachment {
                attachment: self.attachment,
                vpn_connection_arn: self.vpn_connection_arn,
            }
        }
    }
}
impl SiteToSiteVpnAttachment {
    /// Creates a new builder-style object to manufacture [`SiteToSiteVpnAttachment`](crate::model::SiteToSiteVpnAttachment)
    pub fn builder() -> crate::model::site_to_site_vpn_attachment::Builder {
        crate::model::site_to_site_vpn_attachment::Builder::default()
    }
}

/// <p>Describes the telemetry information for a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkTelemetry {
    /// <p>The ARN of the gateway.</p>
    pub registered_gateway_arn: std::option::Option<std::string::String>,
    /// <p>The ID of a core network.</p>
    pub core_network_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region.</p>
    pub aws_region: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The resource type.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The address.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The connection health.</p>
    pub health: std::option::Option<crate::model::ConnectionHealth>,
}
impl NetworkTelemetry {
    /// <p>The ARN of the gateway.</p>
    pub fn registered_gateway_arn(&self) -> std::option::Option<&str> {
        self.registered_gateway_arn.as_deref()
    }
    /// <p>The ID of a core network.</p>
    pub fn core_network_id(&self) -> std::option::Option<&str> {
        self.core_network_id.as_deref()
    }
    /// <p>The Amazon Web Services Region.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
    /// <p>The Amazon Web Services account ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The resource type.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The ARN of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The address.</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>The connection health.</p>
    pub fn health(&self) -> std::option::Option<&crate::model::ConnectionHealth> {
        self.health.as_ref()
    }
}
impl std::fmt::Debug for NetworkTelemetry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkTelemetry");
        formatter.field("registered_gateway_arn", &self.registered_gateway_arn);
        formatter.field("core_network_id", &self.core_network_id);
        formatter.field("aws_region", &self.aws_region);
        formatter.field("account_id", &self.account_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("address", &self.address);
        formatter.field("health", &self.health);
        formatter.finish()
    }
}
/// See [`NetworkTelemetry`](crate::model::NetworkTelemetry)
pub mod network_telemetry {
    /// A builder for [`NetworkTelemetry`](crate::model::NetworkTelemetry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registered_gateway_arn: std::option::Option<std::string::String>,
        pub(crate) core_network_id: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) health: std::option::Option<crate::model::ConnectionHealth>,
    }
    impl Builder {
        /// <p>The ARN of the gateway.</p>
        pub fn registered_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.registered_gateway_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the gateway.</p>
        pub fn set_registered_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registered_gateway_arn = input;
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_network_id = Some(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_network_id = input;
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The address.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The address.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>The connection health.</p>
        pub fn health(mut self, input: crate::model::ConnectionHealth) -> Self {
            self.health = Some(input);
            self
        }
        /// <p>The connection health.</p>
        pub fn set_health(
            mut self,
            input: std::option::Option<crate::model::ConnectionHealth>,
        ) -> Self {
            self.health = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkTelemetry`](crate::model::NetworkTelemetry)
        pub fn build(self) -> crate::model::NetworkTelemetry {
            crate::model::NetworkTelemetry {
                registered_gateway_arn: self.registered_gateway_arn,
                core_network_id: self.core_network_id,
                aws_region: self.aws_region,
                account_id: self.account_id,
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                resource_arn: self.resource_arn,
                address: self.address,
                health: self.health,
            }
        }
    }
}
impl NetworkTelemetry {
    /// Creates a new builder-style object to manufacture [`NetworkTelemetry`](crate::model::NetworkTelemetry)
    pub fn builder() -> crate::model::network_telemetry::Builder {
        crate::model::network_telemetry::Builder::default()
    }
}

/// <p>Describes connection health.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionHealth {
    /// <p>The connection type.</p>
    pub r#type: std::option::Option<crate::model::ConnectionType>,
    /// <p>The connection status.</p>
    pub status: std::option::Option<crate::model::ConnectionStatus>,
    /// <p>The time the status was last updated.</p>
    pub timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl ConnectionHealth {
    /// <p>The connection type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ConnectionType> {
        self.r#type.as_ref()
    }
    /// <p>The connection status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ConnectionStatus> {
        self.status.as_ref()
    }
    /// <p>The time the status was last updated.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.timestamp.as_ref()
    }
}
impl std::fmt::Debug for ConnectionHealth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionHealth");
        formatter.field("r#type", &self.r#type);
        formatter.field("status", &self.status);
        formatter.field("timestamp", &self.timestamp);
        formatter.finish()
    }
}
/// See [`ConnectionHealth`](crate::model::ConnectionHealth)
pub mod connection_health {
    /// A builder for [`ConnectionHealth`](crate::model::ConnectionHealth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ConnectionType>,
        pub(crate) status: std::option::Option<crate::model::ConnectionStatus>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The connection type.</p>
        pub fn r#type(mut self, input: crate::model::ConnectionType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The connection type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The connection status.</p>
        pub fn status(mut self, input: crate::model::ConnectionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The connection status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ConnectionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time the status was last updated.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The time the status was last updated.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionHealth`](crate::model::ConnectionHealth)
        pub fn build(self) -> crate::model::ConnectionHealth {
            crate::model::ConnectionHealth {
                r#type: self.r#type,
                status: self.status,
                timestamp: self.timestamp,
            }
        }
    }
}
impl ConnectionHealth {
    /// Creates a new builder-style object to manufacture [`ConnectionHealth`](crate::model::ConnectionHealth)
    pub fn builder() -> crate::model::connection_health::Builder {
        crate::model::connection_health::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Down,
    #[allow(missing_docs)] // documentation missing in model
    Up,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionStatus {
    fn from(s: &str) -> Self {
        match s {
            "DOWN" => ConnectionStatus::Down,
            "UP" => ConnectionStatus::Up,
            other => ConnectionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionStatus::from(s))
    }
}
impl ConnectionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionStatus::Down => "DOWN",
            ConnectionStatus::Up => "UP",
            ConnectionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DOWN", "UP"]
    }
}
impl AsRef<str> for ConnectionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionType {
    #[allow(missing_docs)] // documentation missing in model
    Bgp,
    #[allow(missing_docs)] // documentation missing in model
    Ipsec,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionType {
    fn from(s: &str) -> Self {
        match s {
            "BGP" => ConnectionType::Bgp,
            "IPSEC" => ConnectionType::Ipsec,
            other => ConnectionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionType::from(s))
    }
}
impl ConnectionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionType::Bgp => "BGP",
            ConnectionType::Ipsec => "IPSEC",
            ConnectionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BGP", "IPSEC"]
    }
}
impl AsRef<str> for ConnectionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a network route.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkRoute {
    /// <p>A unique identifier for the route, such as a CIDR block.</p>
    pub destination_cidr_block: std::option::Option<std::string::String>,
    /// <p>The destinations.</p>
    pub destinations: std::option::Option<std::vec::Vec<crate::model::NetworkRouteDestination>>,
    /// <p>The ID of the prefix list.</p>
    pub prefix_list_id: std::option::Option<std::string::String>,
    /// <p>The route state. The possible values are <code>active</code> and <code>blackhole</code>.</p>
    pub state: std::option::Option<crate::model::RouteState>,
    /// <p>The route type. The possible values are <code>propagated</code> and <code>static</code>.</p>
    pub r#type: std::option::Option<crate::model::RouteType>,
}
impl NetworkRoute {
    /// <p>A unique identifier for the route, such as a CIDR block.</p>
    pub fn destination_cidr_block(&self) -> std::option::Option<&str> {
        self.destination_cidr_block.as_deref()
    }
    /// <p>The destinations.</p>
    pub fn destinations(&self) -> std::option::Option<&[crate::model::NetworkRouteDestination]> {
        self.destinations.as_deref()
    }
    /// <p>The ID of the prefix list.</p>
    pub fn prefix_list_id(&self) -> std::option::Option<&str> {
        self.prefix_list_id.as_deref()
    }
    /// <p>The route state. The possible values are <code>active</code> and <code>blackhole</code>.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::RouteState> {
        self.state.as_ref()
    }
    /// <p>The route type. The possible values are <code>propagated</code> and <code>static</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::RouteType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for NetworkRoute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkRoute");
        formatter.field("destination_cidr_block", &self.destination_cidr_block);
        formatter.field("destinations", &self.destinations);
        formatter.field("prefix_list_id", &self.prefix_list_id);
        formatter.field("state", &self.state);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`NetworkRoute`](crate::model::NetworkRoute)
pub mod network_route {
    /// A builder for [`NetworkRoute`](crate::model::NetworkRoute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_cidr_block: std::option::Option<std::string::String>,
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::NetworkRouteDestination>>,
        pub(crate) prefix_list_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::RouteState>,
        pub(crate) r#type: std::option::Option<crate::model::RouteType>,
    }
    impl Builder {
        /// <p>A unique identifier for the route, such as a CIDR block.</p>
        pub fn destination_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_cidr_block = Some(input.into());
            self
        }
        /// <p>A unique identifier for the route, such as a CIDR block.</p>
        pub fn set_destination_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_cidr_block = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// <p>The destinations.</p>
        pub fn destinations(mut self, input: crate::model::NetworkRouteDestination) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input);
            self.destinations = Some(v);
            self
        }
        /// <p>The destinations.</p>
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkRouteDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// <p>The ID of the prefix list.</p>
        pub fn prefix_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix_list_id = Some(input.into());
            self
        }
        /// <p>The ID of the prefix list.</p>
        pub fn set_prefix_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.prefix_list_id = input;
            self
        }
        /// <p>The route state. The possible values are <code>active</code> and <code>blackhole</code>.</p>
        pub fn state(mut self, input: crate::model::RouteState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The route state. The possible values are <code>active</code> and <code>blackhole</code>.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::RouteState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The route type. The possible values are <code>propagated</code> and <code>static</code>.</p>
        pub fn r#type(mut self, input: crate::model::RouteType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The route type. The possible values are <code>propagated</code> and <code>static</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RouteType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkRoute`](crate::model::NetworkRoute)
        pub fn build(self) -> crate::model::NetworkRoute {
            crate::model::NetworkRoute {
                destination_cidr_block: self.destination_cidr_block,
                destinations: self.destinations,
                prefix_list_id: self.prefix_list_id,
                state: self.state,
                r#type: self.r#type,
            }
        }
    }
}
impl NetworkRoute {
    /// Creates a new builder-style object to manufacture [`NetworkRoute`](crate::model::NetworkRoute)
    pub fn builder() -> crate::model::network_route::Builder {
        crate::model::network_route::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RouteType {
    #[allow(missing_docs)] // documentation missing in model
    Propagated,
    #[allow(missing_docs)] // documentation missing in model
    Static,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RouteType {
    fn from(s: &str) -> Self {
        match s {
            "PROPAGATED" => RouteType::Propagated,
            "STATIC" => RouteType::Static,
            other => RouteType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RouteType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RouteType::from(s))
    }
}
impl RouteType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RouteType::Propagated => "PROPAGATED",
            RouteType::Static => "STATIC",
            RouteType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PROPAGATED", "STATIC"]
    }
}
impl AsRef<str> for RouteType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RouteState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Blackhole,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RouteState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => RouteState::Active,
            "BLACKHOLE" => RouteState::Blackhole,
            other => RouteState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RouteState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RouteState::from(s))
    }
}
impl RouteState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RouteState::Active => "ACTIVE",
            RouteState::Blackhole => "BLACKHOLE",
            RouteState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "BLACKHOLE"]
    }
}
impl AsRef<str> for RouteState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the destination of a network route.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkRouteDestination {
    /// <p>The ID of a core network attachment.</p>
    pub core_network_attachment_id: std::option::Option<std::string::String>,
    /// <p>The ID of the transit gateway attachment.</p>
    pub transit_gateway_attachment_id: std::option::Option<std::string::String>,
    /// <p>The name of the segment.</p>
    pub segment_name: std::option::Option<std::string::String>,
    /// <p>The edge location for the network destination.</p>
    pub edge_location: std::option::Option<std::string::String>,
    /// <p>The resource type.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl NetworkRouteDestination {
    /// <p>The ID of a core network attachment.</p>
    pub fn core_network_attachment_id(&self) -> std::option::Option<&str> {
        self.core_network_attachment_id.as_deref()
    }
    /// <p>The ID of the transit gateway attachment.</p>
    pub fn transit_gateway_attachment_id(&self) -> std::option::Option<&str> {
        self.transit_gateway_attachment_id.as_deref()
    }
    /// <p>The name of the segment.</p>
    pub fn segment_name(&self) -> std::option::Option<&str> {
        self.segment_name.as_deref()
    }
    /// <p>The edge location for the network destination.</p>
    pub fn edge_location(&self) -> std::option::Option<&str> {
        self.edge_location.as_deref()
    }
    /// <p>The resource type.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for NetworkRouteDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkRouteDestination");
        formatter.field(
            "core_network_attachment_id",
            &self.core_network_attachment_id,
        );
        formatter.field(
            "transit_gateway_attachment_id",
            &self.transit_gateway_attachment_id,
        );
        formatter.field("segment_name", &self.segment_name);
        formatter.field("edge_location", &self.edge_location);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}
/// See [`NetworkRouteDestination`](crate::model::NetworkRouteDestination)
pub mod network_route_destination {
    /// A builder for [`NetworkRouteDestination`](crate::model::NetworkRouteDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network_attachment_id: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_attachment_id: std::option::Option<std::string::String>,
        pub(crate) segment_name: std::option::Option<std::string::String>,
        pub(crate) edge_location: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of a core network attachment.</p>
        pub fn core_network_attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_network_attachment_id = Some(input.into());
            self
        }
        /// <p>The ID of a core network attachment.</p>
        pub fn set_core_network_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_network_attachment_id = input;
            self
        }
        /// <p>The ID of the transit gateway attachment.</p>
        pub fn transit_gateway_attachment_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_id = Some(input.into());
            self
        }
        /// <p>The ID of the transit gateway attachment.</p>
        pub fn set_transit_gateway_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_id = input;
            self
        }
        /// <p>The name of the segment.</p>
        pub fn segment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_name = Some(input.into());
            self
        }
        /// <p>The name of the segment.</p>
        pub fn set_segment_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.segment_name = input;
            self
        }
        /// <p>The edge location for the network destination.</p>
        pub fn edge_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.edge_location = Some(input.into());
            self
        }
        /// <p>The edge location for the network destination.</p>
        pub fn set_edge_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.edge_location = input;
            self
        }
        /// <p>The resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkRouteDestination`](crate::model::NetworkRouteDestination)
        pub fn build(self) -> crate::model::NetworkRouteDestination {
            crate::model::NetworkRouteDestination {
                core_network_attachment_id: self.core_network_attachment_id,
                transit_gateway_attachment_id: self.transit_gateway_attachment_id,
                segment_name: self.segment_name,
                edge_location: self.edge_location,
                resource_type: self.resource_type,
                resource_id: self.resource_id,
            }
        }
    }
}
impl NetworkRouteDestination {
    /// Creates a new builder-style object to manufacture [`NetworkRouteDestination`](crate::model::NetworkRouteDestination)
    pub fn builder() -> crate::model::network_route_destination::Builder {
        crate::model::network_route_destination::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RouteTableType {
    #[allow(missing_docs)] // documentation missing in model
    CoreNetworkSegment,
    #[allow(missing_docs)] // documentation missing in model
    TransitGatewayRouteTable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RouteTableType {
    fn from(s: &str) -> Self {
        match s {
            "CORE_NETWORK_SEGMENT" => RouteTableType::CoreNetworkSegment,
            "TRANSIT_GATEWAY_ROUTE_TABLE" => RouteTableType::TransitGatewayRouteTable,
            other => RouteTableType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RouteTableType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RouteTableType::from(s))
    }
}
impl RouteTableType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RouteTableType::CoreNetworkSegment => "CORE_NETWORK_SEGMENT",
            RouteTableType::TransitGatewayRouteTable => "TRANSIT_GATEWAY_ROUTE_TABLE",
            RouteTableType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CORE_NETWORK_SEGMENT", "TRANSIT_GATEWAY_ROUTE_TABLE"]
    }
}
impl AsRef<str> for RouteTableType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returns details about a core network edge.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoreNetworkSegmentEdgeIdentifier {
    /// <p>The ID of a core network.</p>
    pub core_network_id: std::option::Option<std::string::String>,
    /// <p>The name of the segment edge.</p>
    pub segment_name: std::option::Option<std::string::String>,
    /// <p>The Region where the segment edge is located.</p>
    pub edge_location: std::option::Option<std::string::String>,
}
impl CoreNetworkSegmentEdgeIdentifier {
    /// <p>The ID of a core network.</p>
    pub fn core_network_id(&self) -> std::option::Option<&str> {
        self.core_network_id.as_deref()
    }
    /// <p>The name of the segment edge.</p>
    pub fn segment_name(&self) -> std::option::Option<&str> {
        self.segment_name.as_deref()
    }
    /// <p>The Region where the segment edge is located.</p>
    pub fn edge_location(&self) -> std::option::Option<&str> {
        self.edge_location.as_deref()
    }
}
impl std::fmt::Debug for CoreNetworkSegmentEdgeIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoreNetworkSegmentEdgeIdentifier");
        formatter.field("core_network_id", &self.core_network_id);
        formatter.field("segment_name", &self.segment_name);
        formatter.field("edge_location", &self.edge_location);
        formatter.finish()
    }
}
/// See [`CoreNetworkSegmentEdgeIdentifier`](crate::model::CoreNetworkSegmentEdgeIdentifier)
pub mod core_network_segment_edge_identifier {
    /// A builder for [`CoreNetworkSegmentEdgeIdentifier`](crate::model::CoreNetworkSegmentEdgeIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network_id: std::option::Option<std::string::String>,
        pub(crate) segment_name: std::option::Option<std::string::String>,
        pub(crate) edge_location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_network_id = Some(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_network_id = input;
            self
        }
        /// <p>The name of the segment edge.</p>
        pub fn segment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_name = Some(input.into());
            self
        }
        /// <p>The name of the segment edge.</p>
        pub fn set_segment_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.segment_name = input;
            self
        }
        /// <p>The Region where the segment edge is located.</p>
        pub fn edge_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.edge_location = Some(input.into());
            self
        }
        /// <p>The Region where the segment edge is located.</p>
        pub fn set_edge_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.edge_location = input;
            self
        }
        /// Consumes the builder and constructs a [`CoreNetworkSegmentEdgeIdentifier`](crate::model::CoreNetworkSegmentEdgeIdentifier)
        pub fn build(self) -> crate::model::CoreNetworkSegmentEdgeIdentifier {
            crate::model::CoreNetworkSegmentEdgeIdentifier {
                core_network_id: self.core_network_id,
                segment_name: self.segment_name,
                edge_location: self.edge_location,
            }
        }
    }
}
impl CoreNetworkSegmentEdgeIdentifier {
    /// Creates a new builder-style object to manufacture [`CoreNetworkSegmentEdgeIdentifier`](crate::model::CoreNetworkSegmentEdgeIdentifier)
    pub fn builder() -> crate::model::core_network_segment_edge_identifier::Builder {
        crate::model::core_network_segment_edge_identifier::Builder::default()
    }
}

/// <p>Describes a route table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RouteTableIdentifier {
    /// <p>The ARN of the transit gateway route table.</p>
    pub transit_gateway_route_table_arn: std::option::Option<std::string::String>,
    /// <p>The segment edge in a core network.</p>
    pub core_network_segment_edge:
        std::option::Option<crate::model::CoreNetworkSegmentEdgeIdentifier>,
}
impl RouteTableIdentifier {
    /// <p>The ARN of the transit gateway route table.</p>
    pub fn transit_gateway_route_table_arn(&self) -> std::option::Option<&str> {
        self.transit_gateway_route_table_arn.as_deref()
    }
    /// <p>The segment edge in a core network.</p>
    pub fn core_network_segment_edge(
        &self,
    ) -> std::option::Option<&crate::model::CoreNetworkSegmentEdgeIdentifier> {
        self.core_network_segment_edge.as_ref()
    }
}
impl std::fmt::Debug for RouteTableIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RouteTableIdentifier");
        formatter.field(
            "transit_gateway_route_table_arn",
            &self.transit_gateway_route_table_arn,
        );
        formatter.field("core_network_segment_edge", &self.core_network_segment_edge);
        formatter.finish()
    }
}
/// See [`RouteTableIdentifier`](crate::model::RouteTableIdentifier)
pub mod route_table_identifier {
    /// A builder for [`RouteTableIdentifier`](crate::model::RouteTableIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_route_table_arn: std::option::Option<std::string::String>,
        pub(crate) core_network_segment_edge:
            std::option::Option<crate::model::CoreNetworkSegmentEdgeIdentifier>,
    }
    impl Builder {
        /// <p>The ARN of the transit gateway route table.</p>
        pub fn transit_gateway_route_table_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.transit_gateway_route_table_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the transit gateway route table.</p>
        pub fn set_transit_gateway_route_table_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_route_table_arn = input;
            self
        }
        /// <p>The segment edge in a core network.</p>
        pub fn core_network_segment_edge(
            mut self,
            input: crate::model::CoreNetworkSegmentEdgeIdentifier,
        ) -> Self {
            self.core_network_segment_edge = Some(input);
            self
        }
        /// <p>The segment edge in a core network.</p>
        pub fn set_core_network_segment_edge(
            mut self,
            input: std::option::Option<crate::model::CoreNetworkSegmentEdgeIdentifier>,
        ) -> Self {
            self.core_network_segment_edge = input;
            self
        }
        /// Consumes the builder and constructs a [`RouteTableIdentifier`](crate::model::RouteTableIdentifier)
        pub fn build(self) -> crate::model::RouteTableIdentifier {
            crate::model::RouteTableIdentifier {
                transit_gateway_route_table_arn: self.transit_gateway_route_table_arn,
                core_network_segment_edge: self.core_network_segment_edge,
            }
        }
    }
}
impl RouteTableIdentifier {
    /// Creates a new builder-style object to manufacture [`RouteTableIdentifier`](crate::model::RouteTableIdentifier)
    pub fn builder() -> crate::model::route_table_identifier::Builder {
        crate::model::route_table_identifier::Builder::default()
    }
}

/// <p>Describes a network resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkResource {
    /// <p>The ARN of the gateway.</p>
    pub registered_gateway_arn: std::option::Option<std::string::String>,
    /// <p>a core network ID.</p>
    pub core_network_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region.</p>
    pub aws_region: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The resource type.</p>
    /// <p>The following are the supported resource types for Direct Connect:</p>
    /// <ul>
    /// <li> <p> <code>dxcon</code> </p> </li>
    /// <li> <p> <code>dx-gateway</code> </p> </li>
    /// <li> <p> <code>dx-vif</code> </p> </li>
    /// </ul>
    /// <p>The following are the supported resource types for Network Manager:</p>
    /// <ul>
    /// <li> <p> <code>connection</code> </p> </li>
    /// <li> <p> <code>device</code> </p> </li>
    /// <li> <p> <code>link</code> </p> </li>
    /// <li> <p> <code>site</code> </p> </li>
    /// </ul>
    /// <p>The following are the supported resource types for Amazon VPC:</p>
    /// <ul>
    /// <li> <p> <code>customer-gateway</code> </p> </li>
    /// <li> <p> <code>transit-gateway</code> </p> </li>
    /// <li> <p> <code>transit-gateway-attachment</code> </p> </li>
    /// <li> <p> <code>transit-gateway-connect-peer</code> </p> </li>
    /// <li> <p> <code>transit-gateway-route-table</code> </p> </li>
    /// <li> <p> <code>vpn-connection</code> </p> </li>
    /// </ul>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Information about the resource, in JSON format. Network Manager gets this information by describing the resource using its Describe API call.</p>
    pub definition: std::option::Option<std::string::String>,
    /// <p>The time that the resource definition was retrieved.</p>
    pub definition_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The resource metadata.</p>
    pub metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl NetworkResource {
    /// <p>The ARN of the gateway.</p>
    pub fn registered_gateway_arn(&self) -> std::option::Option<&str> {
        self.registered_gateway_arn.as_deref()
    }
    /// <p>a core network ID.</p>
    pub fn core_network_id(&self) -> std::option::Option<&str> {
        self.core_network_id.as_deref()
    }
    /// <p>The Amazon Web Services Region.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
    /// <p>The Amazon Web Services account ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The resource type.</p>
    /// <p>The following are the supported resource types for Direct Connect:</p>
    /// <ul>
    /// <li> <p> <code>dxcon</code> </p> </li>
    /// <li> <p> <code>dx-gateway</code> </p> </li>
    /// <li> <p> <code>dx-vif</code> </p> </li>
    /// </ul>
    /// <p>The following are the supported resource types for Network Manager:</p>
    /// <ul>
    /// <li> <p> <code>connection</code> </p> </li>
    /// <li> <p> <code>device</code> </p> </li>
    /// <li> <p> <code>link</code> </p> </li>
    /// <li> <p> <code>site</code> </p> </li>
    /// </ul>
    /// <p>The following are the supported resource types for Amazon VPC:</p>
    /// <ul>
    /// <li> <p> <code>customer-gateway</code> </p> </li>
    /// <li> <p> <code>transit-gateway</code> </p> </li>
    /// <li> <p> <code>transit-gateway-attachment</code> </p> </li>
    /// <li> <p> <code>transit-gateway-connect-peer</code> </p> </li>
    /// <li> <p> <code>transit-gateway-route-table</code> </p> </li>
    /// <li> <p> <code>vpn-connection</code> </p> </li>
    /// </ul>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The ARN of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Information about the resource, in JSON format. Network Manager gets this information by describing the resource using its Describe API call.</p>
    pub fn definition(&self) -> std::option::Option<&str> {
        self.definition.as_deref()
    }
    /// <p>The time that the resource definition was retrieved.</p>
    pub fn definition_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.definition_timestamp.as_ref()
    }
    /// <p>The tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The resource metadata.</p>
    pub fn metadata(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.metadata.as_ref()
    }
}
impl std::fmt::Debug for NetworkResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkResource");
        formatter.field("registered_gateway_arn", &self.registered_gateway_arn);
        formatter.field("core_network_id", &self.core_network_id);
        formatter.field("aws_region", &self.aws_region);
        formatter.field("account_id", &self.account_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("definition", &self.definition);
        formatter.field("definition_timestamp", &self.definition_timestamp);
        formatter.field("tags", &self.tags);
        formatter.field("metadata", &self.metadata);
        formatter.finish()
    }
}
/// See [`NetworkResource`](crate::model::NetworkResource)
pub mod network_resource {
    /// A builder for [`NetworkResource`](crate::model::NetworkResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registered_gateway_arn: std::option::Option<std::string::String>,
        pub(crate) core_network_id: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) definition: std::option::Option<std::string::String>,
        pub(crate) definition_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the gateway.</p>
        pub fn registered_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.registered_gateway_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the gateway.</p>
        pub fn set_registered_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registered_gateway_arn = input;
            self
        }
        /// <p>a core network ID.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_network_id = Some(input.into());
            self
        }
        /// <p>a core network ID.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_network_id = input;
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The resource type.</p>
        /// <p>The following are the supported resource types for Direct Connect:</p>
        /// <ul>
        /// <li> <p> <code>dxcon</code> </p> </li>
        /// <li> <p> <code>dx-gateway</code> </p> </li>
        /// <li> <p> <code>dx-vif</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Network Manager:</p>
        /// <ul>
        /// <li> <p> <code>connection</code> </p> </li>
        /// <li> <p> <code>device</code> </p> </li>
        /// <li> <p> <code>link</code> </p> </li>
        /// <li> <p> <code>site</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Amazon VPC:</p>
        /// <ul>
        /// <li> <p> <code>customer-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway-attachment</code> </p> </li>
        /// <li> <p> <code>transit-gateway-connect-peer</code> </p> </li>
        /// <li> <p> <code>transit-gateway-route-table</code> </p> </li>
        /// <li> <p> <code>vpn-connection</code> </p> </li>
        /// </ul>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type.</p>
        /// <p>The following are the supported resource types for Direct Connect:</p>
        /// <ul>
        /// <li> <p> <code>dxcon</code> </p> </li>
        /// <li> <p> <code>dx-gateway</code> </p> </li>
        /// <li> <p> <code>dx-vif</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Network Manager:</p>
        /// <ul>
        /// <li> <p> <code>connection</code> </p> </li>
        /// <li> <p> <code>device</code> </p> </li>
        /// <li> <p> <code>link</code> </p> </li>
        /// <li> <p> <code>site</code> </p> </li>
        /// </ul>
        /// <p>The following are the supported resource types for Amazon VPC:</p>
        /// <ul>
        /// <li> <p> <code>customer-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway</code> </p> </li>
        /// <li> <p> <code>transit-gateway-attachment</code> </p> </li>
        /// <li> <p> <code>transit-gateway-connect-peer</code> </p> </li>
        /// <li> <p> <code>transit-gateway-route-table</code> </p> </li>
        /// <li> <p> <code>vpn-connection</code> </p> </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>Information about the resource, in JSON format. Network Manager gets this information by describing the resource using its Describe API call.</p>
        pub fn definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.definition = Some(input.into());
            self
        }
        /// <p>Information about the resource, in JSON format. Network Manager gets this information by describing the resource using its Describe API call.</p>
        pub fn set_definition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.definition = input;
            self
        }
        /// <p>The time that the resource definition was retrieved.</p>
        pub fn definition_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.definition_timestamp = Some(input);
            self
        }
        /// <p>The time that the resource definition was retrieved.</p>
        pub fn set_definition_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.definition_timestamp = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>The resource metadata.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metadata = Some(hash_map);
            self
        }
        /// <p>The resource metadata.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkResource`](crate::model::NetworkResource)
        pub fn build(self) -> crate::model::NetworkResource {
            crate::model::NetworkResource {
                registered_gateway_arn: self.registered_gateway_arn,
                core_network_id: self.core_network_id,
                aws_region: self.aws_region,
                account_id: self.account_id,
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                resource_arn: self.resource_arn,
                definition: self.definition,
                definition_timestamp: self.definition_timestamp,
                tags: self.tags,
                metadata: self.metadata,
            }
        }
    }
}
impl NetworkResource {
    /// Creates a new builder-style object to manufacture [`NetworkResource`](crate::model::NetworkResource)
    pub fn builder() -> crate::model::network_resource::Builder {
        crate::model::network_resource::Builder::default()
    }
}

/// <p>Describes a resource relationship.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Relationship {
    /// <p>The ARN of the resource.</p>
    pub from: std::option::Option<std::string::String>,
    /// <p>The ARN of the resource.</p>
    pub to: std::option::Option<std::string::String>,
}
impl Relationship {
    /// <p>The ARN of the resource.</p>
    pub fn from(&self) -> std::option::Option<&str> {
        self.from.as_deref()
    }
    /// <p>The ARN of the resource.</p>
    pub fn to(&self) -> std::option::Option<&str> {
        self.to.as_deref()
    }
}
impl std::fmt::Debug for Relationship {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Relationship");
        formatter.field("from", &self.from);
        formatter.field("to", &self.to);
        formatter.finish()
    }
}
/// See [`Relationship`](crate::model::Relationship)
pub mod relationship {
    /// A builder for [`Relationship`](crate::model::Relationship)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from: std::option::Option<std::string::String>,
        pub(crate) to: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn from(mut self, input: impl Into<std::string::String>) -> Self {
            self.from = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_from(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.from = input;
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn to(mut self, input: impl Into<std::string::String>) -> Self {
            self.to = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_to(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.to = input;
            self
        }
        /// Consumes the builder and constructs a [`Relationship`](crate::model::Relationship)
        pub fn build(self) -> crate::model::Relationship {
            crate::model::Relationship {
                from: self.from,
                to: self.to,
            }
        }
    }
}
impl Relationship {
    /// Creates a new builder-style object to manufacture [`Relationship`](crate::model::Relationship)
    pub fn builder() -> crate::model::relationship::Builder {
        crate::model::relationship::Builder::default()
    }
}

/// <p>Describes a resource count.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkResourceCount {
    /// <p>The resource type.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The resource count.</p>
    pub count: std::option::Option<i32>,
}
impl NetworkResourceCount {
    /// <p>The resource type.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The resource count.</p>
    pub fn count(&self) -> std::option::Option<i32> {
        self.count
    }
}
impl std::fmt::Debug for NetworkResourceCount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkResourceCount");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("count", &self.count);
        formatter.finish()
    }
}
/// See [`NetworkResourceCount`](crate::model::NetworkResourceCount)
pub mod network_resource_count {
    /// A builder for [`NetworkResourceCount`](crate::model::NetworkResourceCount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The resource count.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The resource count.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkResourceCount`](crate::model::NetworkResourceCount)
        pub fn build(self) -> crate::model::NetworkResourceCount {
            crate::model::NetworkResourceCount {
                resource_type: self.resource_type,
                count: self.count,
            }
        }
    }
}
impl NetworkResourceCount {
    /// Creates a new builder-style object to manufacture [`NetworkResourceCount`](crate::model::NetworkResourceCount)
    pub fn builder() -> crate::model::network_resource_count::Builder {
        crate::model::network_resource_count::Builder::default()
    }
}

/// <p>Describes the association between a device and a link.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LinkAssociation {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The device ID for the link association.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link.</p>
    pub link_id: std::option::Option<std::string::String>,
    /// <p>The state of the association.</p>
    pub link_association_state: std::option::Option<crate::model::LinkAssociationState>,
}
impl LinkAssociation {
    /// <p>The ID of the global network.</p>
    pub fn global_network_id(&self) -> std::option::Option<&str> {
        self.global_network_id.as_deref()
    }
    /// <p>The device ID for the link association.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The ID of the link.</p>
    pub fn link_id(&self) -> std::option::Option<&str> {
        self.link_id.as_deref()
    }
    /// <p>The state of the association.</p>
    pub fn link_association_state(
        &self,
    ) -> std::option::Option<&crate::model::LinkAssociationState> {
        self.link_association_state.as_ref()
    }
}
impl std::fmt::Debug for LinkAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LinkAssociation");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("device_id", &self.device_id);
        formatter.field("link_id", &self.link_id);
        formatter.field("link_association_state", &self.link_association_state);
        formatter.finish()
    }
}
/// See [`LinkAssociation`](crate::model::LinkAssociation)
pub mod link_association {
    /// A builder for [`LinkAssociation`](crate::model::LinkAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) link_id: std::option::Option<std::string::String>,
        pub(crate) link_association_state: std::option::Option<crate::model::LinkAssociationState>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The device ID for the link association.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The device ID for the link association.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// <p>The state of the association.</p>
        pub fn link_association_state(mut self, input: crate::model::LinkAssociationState) -> Self {
            self.link_association_state = Some(input);
            self
        }
        /// <p>The state of the association.</p>
        pub fn set_link_association_state(
            mut self,
            input: std::option::Option<crate::model::LinkAssociationState>,
        ) -> Self {
            self.link_association_state = input;
            self
        }
        /// Consumes the builder and constructs a [`LinkAssociation`](crate::model::LinkAssociation)
        pub fn build(self) -> crate::model::LinkAssociation {
            crate::model::LinkAssociation {
                global_network_id: self.global_network_id,
                device_id: self.device_id,
                link_id: self.link_id,
                link_association_state: self.link_association_state,
            }
        }
    }
}
impl LinkAssociation {
    /// Creates a new builder-style object to manufacture [`LinkAssociation`](crate::model::LinkAssociation)
    pub fn builder() -> crate::model::link_association::Builder {
        crate::model::link_association::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LinkAssociationState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LinkAssociationState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => LinkAssociationState::Available,
            "DELETED" => LinkAssociationState::Deleted,
            "DELETING" => LinkAssociationState::Deleting,
            "PENDING" => LinkAssociationState::Pending,
            other => LinkAssociationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LinkAssociationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LinkAssociationState::from(s))
    }
}
impl LinkAssociationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LinkAssociationState::Available => "AVAILABLE",
            LinkAssociationState::Deleted => "DELETED",
            LinkAssociationState::Deleting => "DELETING",
            LinkAssociationState::Pending => "PENDING",
            LinkAssociationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETED", "DELETING", "PENDING"]
    }
}
impl AsRef<str> for LinkAssociationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the association between a customer gateway, a device, and a link.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomerGatewayAssociation {
    /// <p>The Amazon Resource Name (ARN) of the customer gateway.</p>
    pub customer_gateway_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link.</p>
    pub link_id: std::option::Option<std::string::String>,
    /// <p>The association state.</p>
    pub state: std::option::Option<crate::model::CustomerGatewayAssociationState>,
}
impl CustomerGatewayAssociation {
    /// <p>The Amazon Resource Name (ARN) of the customer gateway.</p>
    pub fn customer_gateway_arn(&self) -> std::option::Option<&str> {
        self.customer_gateway_arn.as_deref()
    }
    /// <p>The ID of the global network.</p>
    pub fn global_network_id(&self) -> std::option::Option<&str> {
        self.global_network_id.as_deref()
    }
    /// <p>The ID of the device.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The ID of the link.</p>
    pub fn link_id(&self) -> std::option::Option<&str> {
        self.link_id.as_deref()
    }
    /// <p>The association state.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::CustomerGatewayAssociationState> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for CustomerGatewayAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomerGatewayAssociation");
        formatter.field("customer_gateway_arn", &self.customer_gateway_arn);
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("device_id", &self.device_id);
        formatter.field("link_id", &self.link_id);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`CustomerGatewayAssociation`](crate::model::CustomerGatewayAssociation)
pub mod customer_gateway_association {
    /// A builder for [`CustomerGatewayAssociation`](crate::model::CustomerGatewayAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) customer_gateway_arn: std::option::Option<std::string::String>,
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) link_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::CustomerGatewayAssociationState>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the customer gateway.</p>
        pub fn customer_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer gateway.</p>
        pub fn set_customer_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_gateway_arn = input;
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// <p>The association state.</p>
        pub fn state(mut self, input: crate::model::CustomerGatewayAssociationState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The association state.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::CustomerGatewayAssociationState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomerGatewayAssociation`](crate::model::CustomerGatewayAssociation)
        pub fn build(self) -> crate::model::CustomerGatewayAssociation {
            crate::model::CustomerGatewayAssociation {
                customer_gateway_arn: self.customer_gateway_arn,
                global_network_id: self.global_network_id,
                device_id: self.device_id,
                link_id: self.link_id,
                state: self.state,
            }
        }
    }
}
impl CustomerGatewayAssociation {
    /// Creates a new builder-style object to manufacture [`CustomerGatewayAssociation`](crate::model::CustomerGatewayAssociation)
    pub fn builder() -> crate::model::customer_gateway_association::Builder {
        crate::model::customer_gateway_association::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomerGatewayAssociationState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomerGatewayAssociationState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => CustomerGatewayAssociationState::Available,
            "DELETED" => CustomerGatewayAssociationState::Deleted,
            "DELETING" => CustomerGatewayAssociationState::Deleting,
            "PENDING" => CustomerGatewayAssociationState::Pending,
            other => CustomerGatewayAssociationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomerGatewayAssociationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomerGatewayAssociationState::from(s))
    }
}
impl CustomerGatewayAssociationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomerGatewayAssociationState::Available => "AVAILABLE",
            CustomerGatewayAssociationState::Deleted => "DELETED",
            CustomerGatewayAssociationState::Deleting => "DELETING",
            CustomerGatewayAssociationState::Pending => "PENDING",
            CustomerGatewayAssociationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETED", "DELETING", "PENDING"]
    }
}
impl AsRef<str> for CustomerGatewayAssociationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details describing a core network change.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoreNetworkChange {
    /// <p>The type of change.</p>
    pub r#type: std::option::Option<crate::model::ChangeType>,
    /// <p>The action to take for a core network.</p>
    pub action: std::option::Option<crate::model::ChangeAction>,
    /// <p>The resource identifier.</p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>The previous values for a core network.</p>
    pub previous_values: std::option::Option<crate::model::CoreNetworkChangeValues>,
    /// <p>The new value for a core network</p>
    pub new_values: std::option::Option<crate::model::CoreNetworkChangeValues>,
}
impl CoreNetworkChange {
    /// <p>The type of change.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ChangeType> {
        self.r#type.as_ref()
    }
    /// <p>The action to take for a core network.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::ChangeAction> {
        self.action.as_ref()
    }
    /// <p>The resource identifier.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>The previous values for a core network.</p>
    pub fn previous_values(&self) -> std::option::Option<&crate::model::CoreNetworkChangeValues> {
        self.previous_values.as_ref()
    }
    /// <p>The new value for a core network</p>
    pub fn new_values(&self) -> std::option::Option<&crate::model::CoreNetworkChangeValues> {
        self.new_values.as_ref()
    }
}
impl std::fmt::Debug for CoreNetworkChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoreNetworkChange");
        formatter.field("r#type", &self.r#type);
        formatter.field("action", &self.action);
        formatter.field("identifier", &self.identifier);
        formatter.field("previous_values", &self.previous_values);
        formatter.field("new_values", &self.new_values);
        formatter.finish()
    }
}
/// See [`CoreNetworkChange`](crate::model::CoreNetworkChange)
pub mod core_network_change {
    /// A builder for [`CoreNetworkChange`](crate::model::CoreNetworkChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ChangeType>,
        pub(crate) action: std::option::Option<crate::model::ChangeAction>,
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) previous_values: std::option::Option<crate::model::CoreNetworkChangeValues>,
        pub(crate) new_values: std::option::Option<crate::model::CoreNetworkChangeValues>,
    }
    impl Builder {
        /// <p>The type of change.</p>
        pub fn r#type(mut self, input: crate::model::ChangeType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of change.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ChangeType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The action to take for a core network.</p>
        pub fn action(mut self, input: crate::model::ChangeAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action to take for a core network.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ChangeAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The resource identifier.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The resource identifier.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>The previous values for a core network.</p>
        pub fn previous_values(mut self, input: crate::model::CoreNetworkChangeValues) -> Self {
            self.previous_values = Some(input);
            self
        }
        /// <p>The previous values for a core network.</p>
        pub fn set_previous_values(
            mut self,
            input: std::option::Option<crate::model::CoreNetworkChangeValues>,
        ) -> Self {
            self.previous_values = input;
            self
        }
        /// <p>The new value for a core network</p>
        pub fn new_values(mut self, input: crate::model::CoreNetworkChangeValues) -> Self {
            self.new_values = Some(input);
            self
        }
        /// <p>The new value for a core network</p>
        pub fn set_new_values(
            mut self,
            input: std::option::Option<crate::model::CoreNetworkChangeValues>,
        ) -> Self {
            self.new_values = input;
            self
        }
        /// Consumes the builder and constructs a [`CoreNetworkChange`](crate::model::CoreNetworkChange)
        pub fn build(self) -> crate::model::CoreNetworkChange {
            crate::model::CoreNetworkChange {
                r#type: self.r#type,
                action: self.action,
                identifier: self.identifier,
                previous_values: self.previous_values,
                new_values: self.new_values,
            }
        }
    }
}
impl CoreNetworkChange {
    /// Creates a new builder-style object to manufacture [`CoreNetworkChange`](crate::model::CoreNetworkChange)
    pub fn builder() -> crate::model::core_network_change::Builder {
        crate::model::core_network_change::Builder::default()
    }
}

/// <p>Describes a core network change.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoreNetworkChangeValues {
    /// <p>The names of the segments in a core network.</p>
    pub segment_name: std::option::Option<std::string::String>,
    /// <p>The Regions where edges are located in a core network. </p>
    pub edge_locations: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ASN of a core network.</p>
    pub asn: std::option::Option<i64>,
    /// <p>The IP addresses used for a core network.</p>
    pub cidr: std::option::Option<std::string::String>,
    /// <p>The ID of the destination.</p>
    pub destination_identifier: std::option::Option<std::string::String>,
    /// <p>The inside IP addresses used for core network change values.</p>
    pub inside_cidr_blocks: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The shared segments for a core network change value. </p>
    pub shared_segments: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CoreNetworkChangeValues {
    /// <p>The names of the segments in a core network.</p>
    pub fn segment_name(&self) -> std::option::Option<&str> {
        self.segment_name.as_deref()
    }
    /// <p>The Regions where edges are located in a core network. </p>
    pub fn edge_locations(&self) -> std::option::Option<&[std::string::String]> {
        self.edge_locations.as_deref()
    }
    /// <p>The ASN of a core network.</p>
    pub fn asn(&self) -> std::option::Option<i64> {
        self.asn
    }
    /// <p>The IP addresses used for a core network.</p>
    pub fn cidr(&self) -> std::option::Option<&str> {
        self.cidr.as_deref()
    }
    /// <p>The ID of the destination.</p>
    pub fn destination_identifier(&self) -> std::option::Option<&str> {
        self.destination_identifier.as_deref()
    }
    /// <p>The inside IP addresses used for core network change values.</p>
    pub fn inside_cidr_blocks(&self) -> std::option::Option<&[std::string::String]> {
        self.inside_cidr_blocks.as_deref()
    }
    /// <p>The shared segments for a core network change value. </p>
    pub fn shared_segments(&self) -> std::option::Option<&[std::string::String]> {
        self.shared_segments.as_deref()
    }
}
impl std::fmt::Debug for CoreNetworkChangeValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoreNetworkChangeValues");
        formatter.field("segment_name", &self.segment_name);
        formatter.field("edge_locations", &self.edge_locations);
        formatter.field("asn", &self.asn);
        formatter.field("cidr", &self.cidr);
        formatter.field("destination_identifier", &self.destination_identifier);
        formatter.field("inside_cidr_blocks", &self.inside_cidr_blocks);
        formatter.field("shared_segments", &self.shared_segments);
        formatter.finish()
    }
}
/// See [`CoreNetworkChangeValues`](crate::model::CoreNetworkChangeValues)
pub mod core_network_change_values {
    /// A builder for [`CoreNetworkChangeValues`](crate::model::CoreNetworkChangeValues)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) segment_name: std::option::Option<std::string::String>,
        pub(crate) edge_locations: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) asn: std::option::Option<i64>,
        pub(crate) cidr: std::option::Option<std::string::String>,
        pub(crate) destination_identifier: std::option::Option<std::string::String>,
        pub(crate) inside_cidr_blocks: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) shared_segments: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The names of the segments in a core network.</p>
        pub fn segment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_name = Some(input.into());
            self
        }
        /// <p>The names of the segments in a core network.</p>
        pub fn set_segment_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.segment_name = input;
            self
        }
        /// Appends an item to `edge_locations`.
        ///
        /// To override the contents of this collection use [`set_edge_locations`](Self::set_edge_locations).
        ///
        /// <p>The Regions where edges are located in a core network. </p>
        pub fn edge_locations(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.edge_locations.unwrap_or_default();
            v.push(input.into());
            self.edge_locations = Some(v);
            self
        }
        /// <p>The Regions where edges are located in a core network. </p>
        pub fn set_edge_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.edge_locations = input;
            self
        }
        /// <p>The ASN of a core network.</p>
        pub fn asn(mut self, input: i64) -> Self {
            self.asn = Some(input);
            self
        }
        /// <p>The ASN of a core network.</p>
        pub fn set_asn(mut self, input: std::option::Option<i64>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The IP addresses used for a core network.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr = Some(input.into());
            self
        }
        /// <p>The IP addresses used for a core network.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr = input;
            self
        }
        /// <p>The ID of the destination.</p>
        pub fn destination_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the destination.</p>
        pub fn set_destination_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_identifier = input;
            self
        }
        /// Appends an item to `inside_cidr_blocks`.
        ///
        /// To override the contents of this collection use [`set_inside_cidr_blocks`](Self::set_inside_cidr_blocks).
        ///
        /// <p>The inside IP addresses used for core network change values.</p>
        pub fn inside_cidr_blocks(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.inside_cidr_blocks.unwrap_or_default();
            v.push(input.into());
            self.inside_cidr_blocks = Some(v);
            self
        }
        /// <p>The inside IP addresses used for core network change values.</p>
        pub fn set_inside_cidr_blocks(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inside_cidr_blocks = input;
            self
        }
        /// Appends an item to `shared_segments`.
        ///
        /// To override the contents of this collection use [`set_shared_segments`](Self::set_shared_segments).
        ///
        /// <p>The shared segments for a core network change value. </p>
        pub fn shared_segments(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.shared_segments.unwrap_or_default();
            v.push(input.into());
            self.shared_segments = Some(v);
            self
        }
        /// <p>The shared segments for a core network change value. </p>
        pub fn set_shared_segments(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.shared_segments = input;
            self
        }
        /// Consumes the builder and constructs a [`CoreNetworkChangeValues`](crate::model::CoreNetworkChangeValues)
        pub fn build(self) -> crate::model::CoreNetworkChangeValues {
            crate::model::CoreNetworkChangeValues {
                segment_name: self.segment_name,
                edge_locations: self.edge_locations,
                asn: self.asn,
                cidr: self.cidr,
                destination_identifier: self.destination_identifier,
                inside_cidr_blocks: self.inside_cidr_blocks,
                shared_segments: self.shared_segments,
            }
        }
    }
}
impl CoreNetworkChangeValues {
    /// Creates a new builder-style object to manufacture [`CoreNetworkChangeValues`](crate::model::CoreNetworkChangeValues)
    pub fn builder() -> crate::model::core_network_change_values::Builder {
        crate::model::core_network_change_values::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeAction {
    #[allow(missing_docs)] // documentation missing in model
    Add,
    #[allow(missing_docs)] // documentation missing in model
    Modify,
    #[allow(missing_docs)] // documentation missing in model
    Remove,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeAction {
    fn from(s: &str) -> Self {
        match s {
            "ADD" => ChangeAction::Add,
            "MODIFY" => ChangeAction::Modify,
            "REMOVE" => ChangeAction::Remove,
            other => ChangeAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangeAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeAction::from(s))
    }
}
impl ChangeAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeAction::Add => "ADD",
            ChangeAction::Modify => "MODIFY",
            ChangeAction::Remove => "REMOVE",
            ChangeAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADD", "MODIFY", "REMOVE"]
    }
}
impl AsRef<str> for ChangeAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeType {
    #[allow(missing_docs)] // documentation missing in model
    AttachmentMapping,
    #[allow(missing_docs)] // documentation missing in model
    AttachmentRoutePropagation,
    #[allow(missing_docs)] // documentation missing in model
    AttachmentRouteStatic,
    #[allow(missing_docs)] // documentation missing in model
    CoreNetworkEdge,
    #[allow(missing_docs)] // documentation missing in model
    CoreNetworkSegment,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeType {
    fn from(s: &str) -> Self {
        match s {
            "ATTACHMENT_MAPPING" => ChangeType::AttachmentMapping,
            "ATTACHMENT_ROUTE_PROPAGATION" => ChangeType::AttachmentRoutePropagation,
            "ATTACHMENT_ROUTE_STATIC" => ChangeType::AttachmentRouteStatic,
            "CORE_NETWORK_EDGE" => ChangeType::CoreNetworkEdge,
            "CORE_NETWORK_SEGMENT" => ChangeType::CoreNetworkSegment,
            other => ChangeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeType::from(s))
    }
}
impl ChangeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeType::AttachmentMapping => "ATTACHMENT_MAPPING",
            ChangeType::AttachmentRoutePropagation => "ATTACHMENT_ROUTE_PROPAGATION",
            ChangeType::AttachmentRouteStatic => "ATTACHMENT_ROUTE_STATIC",
            ChangeType::CoreNetworkEdge => "CORE_NETWORK_EDGE",
            ChangeType::CoreNetworkSegment => "CORE_NETWORK_SEGMENT",
            ChangeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ATTACHMENT_MAPPING",
            "ATTACHMENT_ROUTE_PROPAGATION",
            "ATTACHMENT_ROUTE_STATIC",
            "CORE_NETWORK_EDGE",
            "CORE_NETWORK_SEGMENT",
        ]
    }
}
impl AsRef<str> for ChangeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a core network Connect peer association.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectPeerAssociation {
    /// <p>The ID of the Connect peer.</p>
    pub connect_peer_id: std::option::Option<std::string::String>,
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the device to connect to.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link.</p>
    pub link_id: std::option::Option<std::string::String>,
    /// <p>The state of the Connect peer association.</p>
    pub state: std::option::Option<crate::model::ConnectPeerAssociationState>,
}
impl ConnectPeerAssociation {
    /// <p>The ID of the Connect peer.</p>
    pub fn connect_peer_id(&self) -> std::option::Option<&str> {
        self.connect_peer_id.as_deref()
    }
    /// <p>The ID of the global network.</p>
    pub fn global_network_id(&self) -> std::option::Option<&str> {
        self.global_network_id.as_deref()
    }
    /// <p>The ID of the device to connect to.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The ID of the link.</p>
    pub fn link_id(&self) -> std::option::Option<&str> {
        self.link_id.as_deref()
    }
    /// <p>The state of the Connect peer association.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ConnectPeerAssociationState> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for ConnectPeerAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectPeerAssociation");
        formatter.field("connect_peer_id", &self.connect_peer_id);
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("device_id", &self.device_id);
        formatter.field("link_id", &self.link_id);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`ConnectPeerAssociation`](crate::model::ConnectPeerAssociation)
pub mod connect_peer_association {
    /// A builder for [`ConnectPeerAssociation`](crate::model::ConnectPeerAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connect_peer_id: std::option::Option<std::string::String>,
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) link_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ConnectPeerAssociationState>,
    }
    impl Builder {
        /// <p>The ID of the Connect peer.</p>
        pub fn connect_peer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connect_peer_id = Some(input.into());
            self
        }
        /// <p>The ID of the Connect peer.</p>
        pub fn set_connect_peer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connect_peer_id = input;
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the device to connect to.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device to connect to.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// <p>The state of the Connect peer association.</p>
        pub fn state(mut self, input: crate::model::ConnectPeerAssociationState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the Connect peer association.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ConnectPeerAssociationState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectPeerAssociation`](crate::model::ConnectPeerAssociation)
        pub fn build(self) -> crate::model::ConnectPeerAssociation {
            crate::model::ConnectPeerAssociation {
                connect_peer_id: self.connect_peer_id,
                global_network_id: self.global_network_id,
                device_id: self.device_id,
                link_id: self.link_id,
                state: self.state,
            }
        }
    }
}
impl ConnectPeerAssociation {
    /// Creates a new builder-style object to manufacture [`ConnectPeerAssociation`](crate::model::ConnectPeerAssociation)
    pub fn builder() -> crate::model::connect_peer_association::Builder {
        crate::model::connect_peer_association::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectPeerAssociationState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectPeerAssociationState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => ConnectPeerAssociationState::Available,
            "DELETED" => ConnectPeerAssociationState::Deleted,
            "DELETING" => ConnectPeerAssociationState::Deleting,
            "PENDING" => ConnectPeerAssociationState::Pending,
            other => ConnectPeerAssociationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectPeerAssociationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectPeerAssociationState::from(s))
    }
}
impl ConnectPeerAssociationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectPeerAssociationState::Available => "AVAILABLE",
            ConnectPeerAssociationState::Deleted => "DELETED",
            ConnectPeerAssociationState::Deleting => "DELETING",
            ConnectPeerAssociationState::Pending => "PENDING",
            ConnectPeerAssociationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETED", "DELETING", "PENDING"]
    }
}
impl AsRef<str> for ConnectPeerAssociationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a core network Connect peer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectPeer {
    /// <p>The ID of a core network.</p>
    pub core_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the attachment to connect.</p>
    pub connect_attachment_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Connect peer.</p>
    pub connect_peer_id: std::option::Option<std::string::String>,
    /// <p>The Connect peer Regions where edges are located.</p>
    pub edge_location: std::option::Option<std::string::String>,
    /// <p>The state of the Connect peer.</p>
    pub state: std::option::Option<crate::model::ConnectPeerState>,
    /// <p>The timestamp when the Connect peer was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The configuration of the Connect peer.</p>
    pub configuration: std::option::Option<crate::model::ConnectPeerConfiguration>,
    /// <p>The tags associated with the Connect peer.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ConnectPeer {
    /// <p>The ID of a core network.</p>
    pub fn core_network_id(&self) -> std::option::Option<&str> {
        self.core_network_id.as_deref()
    }
    /// <p>The ID of the attachment to connect.</p>
    pub fn connect_attachment_id(&self) -> std::option::Option<&str> {
        self.connect_attachment_id.as_deref()
    }
    /// <p>The ID of the Connect peer.</p>
    pub fn connect_peer_id(&self) -> std::option::Option<&str> {
        self.connect_peer_id.as_deref()
    }
    /// <p>The Connect peer Regions where edges are located.</p>
    pub fn edge_location(&self) -> std::option::Option<&str> {
        self.edge_location.as_deref()
    }
    /// <p>The state of the Connect peer.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ConnectPeerState> {
        self.state.as_ref()
    }
    /// <p>The timestamp when the Connect peer was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The configuration of the Connect peer.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::ConnectPeerConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>The tags associated with the Connect peer.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ConnectPeer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectPeer");
        formatter.field("core_network_id", &self.core_network_id);
        formatter.field("connect_attachment_id", &self.connect_attachment_id);
        formatter.field("connect_peer_id", &self.connect_peer_id);
        formatter.field("edge_location", &self.edge_location);
        formatter.field("state", &self.state);
        formatter.field("created_at", &self.created_at);
        formatter.field("configuration", &self.configuration);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ConnectPeer`](crate::model::ConnectPeer)
pub mod connect_peer {
    /// A builder for [`ConnectPeer`](crate::model::ConnectPeer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network_id: std::option::Option<std::string::String>,
        pub(crate) connect_attachment_id: std::option::Option<std::string::String>,
        pub(crate) connect_peer_id: std::option::Option<std::string::String>,
        pub(crate) edge_location: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ConnectPeerState>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) configuration: std::option::Option<crate::model::ConnectPeerConfiguration>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of a core network.</p>
        pub fn core_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_network_id = Some(input.into());
            self
        }
        /// <p>The ID of a core network.</p>
        pub fn set_core_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_network_id = input;
            self
        }
        /// <p>The ID of the attachment to connect.</p>
        pub fn connect_attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connect_attachment_id = Some(input.into());
            self
        }
        /// <p>The ID of the attachment to connect.</p>
        pub fn set_connect_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connect_attachment_id = input;
            self
        }
        /// <p>The ID of the Connect peer.</p>
        pub fn connect_peer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connect_peer_id = Some(input.into());
            self
        }
        /// <p>The ID of the Connect peer.</p>
        pub fn set_connect_peer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connect_peer_id = input;
            self
        }
        /// <p>The Connect peer Regions where edges are located.</p>
        pub fn edge_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.edge_location = Some(input.into());
            self
        }
        /// <p>The Connect peer Regions where edges are located.</p>
        pub fn set_edge_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.edge_location = input;
            self
        }
        /// <p>The state of the Connect peer.</p>
        pub fn state(mut self, input: crate::model::ConnectPeerState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the Connect peer.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ConnectPeerState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The timestamp when the Connect peer was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the Connect peer was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The configuration of the Connect peer.</p>
        pub fn configuration(mut self, input: crate::model::ConnectPeerConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The configuration of the Connect peer.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ConnectPeerConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the Connect peer.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the Connect peer.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectPeer`](crate::model::ConnectPeer)
        pub fn build(self) -> crate::model::ConnectPeer {
            crate::model::ConnectPeer {
                core_network_id: self.core_network_id,
                connect_attachment_id: self.connect_attachment_id,
                connect_peer_id: self.connect_peer_id,
                edge_location: self.edge_location,
                state: self.state,
                created_at: self.created_at,
                configuration: self.configuration,
                tags: self.tags,
            }
        }
    }
}
impl ConnectPeer {
    /// Creates a new builder-style object to manufacture [`ConnectPeer`](crate::model::ConnectPeer)
    pub fn builder() -> crate::model::connect_peer::Builder {
        crate::model::connect_peer::Builder::default()
    }
}

/// <p>Describes a core network Connect peer configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectPeerConfiguration {
    /// <p>The IP address of a core network.</p>
    pub core_network_address: std::option::Option<std::string::String>,
    /// <p>The IP address of the Connect peer.</p>
    pub peer_address: std::option::Option<std::string::String>,
    /// <p>The inside IP addresses used for a Connect peer configuration.</p>
    pub inside_cidr_blocks: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The protocol used for a Connect peer configuration.</p>
    pub protocol: std::option::Option<crate::model::TunnelProtocol>,
    /// <p>The Connect peer BGP configurations.</p>
    pub bgp_configurations:
        std::option::Option<std::vec::Vec<crate::model::ConnectPeerBgpConfiguration>>,
}
impl ConnectPeerConfiguration {
    /// <p>The IP address of a core network.</p>
    pub fn core_network_address(&self) -> std::option::Option<&str> {
        self.core_network_address.as_deref()
    }
    /// <p>The IP address of the Connect peer.</p>
    pub fn peer_address(&self) -> std::option::Option<&str> {
        self.peer_address.as_deref()
    }
    /// <p>The inside IP addresses used for a Connect peer configuration.</p>
    pub fn inside_cidr_blocks(&self) -> std::option::Option<&[std::string::String]> {
        self.inside_cidr_blocks.as_deref()
    }
    /// <p>The protocol used for a Connect peer configuration.</p>
    pub fn protocol(&self) -> std::option::Option<&crate::model::TunnelProtocol> {
        self.protocol.as_ref()
    }
    /// <p>The Connect peer BGP configurations.</p>
    pub fn bgp_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::ConnectPeerBgpConfiguration]> {
        self.bgp_configurations.as_deref()
    }
}
impl std::fmt::Debug for ConnectPeerConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectPeerConfiguration");
        formatter.field("core_network_address", &self.core_network_address);
        formatter.field("peer_address", &self.peer_address);
        formatter.field("inside_cidr_blocks", &self.inside_cidr_blocks);
        formatter.field("protocol", &self.protocol);
        formatter.field("bgp_configurations", &self.bgp_configurations);
        formatter.finish()
    }
}
/// See [`ConnectPeerConfiguration`](crate::model::ConnectPeerConfiguration)
pub mod connect_peer_configuration {
    /// A builder for [`ConnectPeerConfiguration`](crate::model::ConnectPeerConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network_address: std::option::Option<std::string::String>,
        pub(crate) peer_address: std::option::Option<std::string::String>,
        pub(crate) inside_cidr_blocks: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) protocol: std::option::Option<crate::model::TunnelProtocol>,
        pub(crate) bgp_configurations:
            std::option::Option<std::vec::Vec<crate::model::ConnectPeerBgpConfiguration>>,
    }
    impl Builder {
        /// <p>The IP address of a core network.</p>
        pub fn core_network_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_network_address = Some(input.into());
            self
        }
        /// <p>The IP address of a core network.</p>
        pub fn set_core_network_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_network_address = input;
            self
        }
        /// <p>The IP address of the Connect peer.</p>
        pub fn peer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.peer_address = Some(input.into());
            self
        }
        /// <p>The IP address of the Connect peer.</p>
        pub fn set_peer_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.peer_address = input;
            self
        }
        /// Appends an item to `inside_cidr_blocks`.
        ///
        /// To override the contents of this collection use [`set_inside_cidr_blocks`](Self::set_inside_cidr_blocks).
        ///
        /// <p>The inside IP addresses used for a Connect peer configuration.</p>
        pub fn inside_cidr_blocks(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.inside_cidr_blocks.unwrap_or_default();
            v.push(input.into());
            self.inside_cidr_blocks = Some(v);
            self
        }
        /// <p>The inside IP addresses used for a Connect peer configuration.</p>
        pub fn set_inside_cidr_blocks(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inside_cidr_blocks = input;
            self
        }
        /// <p>The protocol used for a Connect peer configuration.</p>
        pub fn protocol(mut self, input: crate::model::TunnelProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol used for a Connect peer configuration.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::TunnelProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// Appends an item to `bgp_configurations`.
        ///
        /// To override the contents of this collection use [`set_bgp_configurations`](Self::set_bgp_configurations).
        ///
        /// <p>The Connect peer BGP configurations.</p>
        pub fn bgp_configurations(
            mut self,
            input: crate::model::ConnectPeerBgpConfiguration,
        ) -> Self {
            let mut v = self.bgp_configurations.unwrap_or_default();
            v.push(input);
            self.bgp_configurations = Some(v);
            self
        }
        /// <p>The Connect peer BGP configurations.</p>
        pub fn set_bgp_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectPeerBgpConfiguration>>,
        ) -> Self {
            self.bgp_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectPeerConfiguration`](crate::model::ConnectPeerConfiguration)
        pub fn build(self) -> crate::model::ConnectPeerConfiguration {
            crate::model::ConnectPeerConfiguration {
                core_network_address: self.core_network_address,
                peer_address: self.peer_address,
                inside_cidr_blocks: self.inside_cidr_blocks,
                protocol: self.protocol,
                bgp_configurations: self.bgp_configurations,
            }
        }
    }
}
impl ConnectPeerConfiguration {
    /// Creates a new builder-style object to manufacture [`ConnectPeerConfiguration`](crate::model::ConnectPeerConfiguration)
    pub fn builder() -> crate::model::connect_peer_configuration::Builder {
        crate::model::connect_peer_configuration::Builder::default()
    }
}

/// <p>Describes a core network BGP configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectPeerBgpConfiguration {
    /// <p>The ASN of the Coret Network.</p>
    pub core_network_asn: std::option::Option<i64>,
    /// <p>The ASN of the Connect peer.</p>
    pub peer_asn: std::option::Option<i64>,
    /// <p>The address of a core network.</p>
    pub core_network_address: std::option::Option<std::string::String>,
    /// <p>The address of a core network Connect peer.</p>
    pub peer_address: std::option::Option<std::string::String>,
}
impl ConnectPeerBgpConfiguration {
    /// <p>The ASN of the Coret Network.</p>
    pub fn core_network_asn(&self) -> std::option::Option<i64> {
        self.core_network_asn
    }
    /// <p>The ASN of the Connect peer.</p>
    pub fn peer_asn(&self) -> std::option::Option<i64> {
        self.peer_asn
    }
    /// <p>The address of a core network.</p>
    pub fn core_network_address(&self) -> std::option::Option<&str> {
        self.core_network_address.as_deref()
    }
    /// <p>The address of a core network Connect peer.</p>
    pub fn peer_address(&self) -> std::option::Option<&str> {
        self.peer_address.as_deref()
    }
}
impl std::fmt::Debug for ConnectPeerBgpConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectPeerBgpConfiguration");
        formatter.field("core_network_asn", &self.core_network_asn);
        formatter.field("peer_asn", &self.peer_asn);
        formatter.field("core_network_address", &self.core_network_address);
        formatter.field("peer_address", &self.peer_address);
        formatter.finish()
    }
}
/// See [`ConnectPeerBgpConfiguration`](crate::model::ConnectPeerBgpConfiguration)
pub mod connect_peer_bgp_configuration {
    /// A builder for [`ConnectPeerBgpConfiguration`](crate::model::ConnectPeerBgpConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_network_asn: std::option::Option<i64>,
        pub(crate) peer_asn: std::option::Option<i64>,
        pub(crate) core_network_address: std::option::Option<std::string::String>,
        pub(crate) peer_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ASN of the Coret Network.</p>
        pub fn core_network_asn(mut self, input: i64) -> Self {
            self.core_network_asn = Some(input);
            self
        }
        /// <p>The ASN of the Coret Network.</p>
        pub fn set_core_network_asn(mut self, input: std::option::Option<i64>) -> Self {
            self.core_network_asn = input;
            self
        }
        /// <p>The ASN of the Connect peer.</p>
        pub fn peer_asn(mut self, input: i64) -> Self {
            self.peer_asn = Some(input);
            self
        }
        /// <p>The ASN of the Connect peer.</p>
        pub fn set_peer_asn(mut self, input: std::option::Option<i64>) -> Self {
            self.peer_asn = input;
            self
        }
        /// <p>The address of a core network.</p>
        pub fn core_network_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_network_address = Some(input.into());
            self
        }
        /// <p>The address of a core network.</p>
        pub fn set_core_network_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_network_address = input;
            self
        }
        /// <p>The address of a core network Connect peer.</p>
        pub fn peer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.peer_address = Some(input.into());
            self
        }
        /// <p>The address of a core network Connect peer.</p>
        pub fn set_peer_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.peer_address = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectPeerBgpConfiguration`](crate::model::ConnectPeerBgpConfiguration)
        pub fn build(self) -> crate::model::ConnectPeerBgpConfiguration {
            crate::model::ConnectPeerBgpConfiguration {
                core_network_asn: self.core_network_asn,
                peer_asn: self.peer_asn,
                core_network_address: self.core_network_address,
                peer_address: self.peer_address,
            }
        }
    }
}
impl ConnectPeerBgpConfiguration {
    /// Creates a new builder-style object to manufacture [`ConnectPeerBgpConfiguration`](crate::model::ConnectPeerBgpConfiguration)
    pub fn builder() -> crate::model::connect_peer_bgp_configuration::Builder {
        crate::model::connect_peer_bgp_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TunnelProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Gre,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TunnelProtocol {
    fn from(s: &str) -> Self {
        match s {
            "GRE" => TunnelProtocol::Gre,
            other => TunnelProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TunnelProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TunnelProtocol::from(s))
    }
}
impl TunnelProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TunnelProtocol::Gre => "GRE",
            TunnelProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GRE"]
    }
}
impl AsRef<str> for TunnelProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a core network Connect attachment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectAttachment {
    /// <p>The attachment details.</p>
    pub attachment: std::option::Option<crate::model::Attachment>,
    /// <p>The ID of the transport attachment.</p>
    pub transport_attachment_id: std::option::Option<std::string::String>,
    /// <p>Options for connecting an attachment.</p>
    pub options: std::option::Option<crate::model::ConnectAttachmentOptions>,
}
impl ConnectAttachment {
    /// <p>The attachment details.</p>
    pub fn attachment(&self) -> std::option::Option<&crate::model::Attachment> {
        self.attachment.as_ref()
    }
    /// <p>The ID of the transport attachment.</p>
    pub fn transport_attachment_id(&self) -> std::option::Option<&str> {
        self.transport_attachment_id.as_deref()
    }
    /// <p>Options for connecting an attachment.</p>
    pub fn options(&self) -> std::option::Option<&crate::model::ConnectAttachmentOptions> {
        self.options.as_ref()
    }
}
impl std::fmt::Debug for ConnectAttachment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectAttachment");
        formatter.field("attachment", &self.attachment);
        formatter.field("transport_attachment_id", &self.transport_attachment_id);
        formatter.field("options", &self.options);
        formatter.finish()
    }
}
/// See [`ConnectAttachment`](crate::model::ConnectAttachment)
pub mod connect_attachment {
    /// A builder for [`ConnectAttachment`](crate::model::ConnectAttachment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attachment: std::option::Option<crate::model::Attachment>,
        pub(crate) transport_attachment_id: std::option::Option<std::string::String>,
        pub(crate) options: std::option::Option<crate::model::ConnectAttachmentOptions>,
    }
    impl Builder {
        /// <p>The attachment details.</p>
        pub fn attachment(mut self, input: crate::model::Attachment) -> Self {
            self.attachment = Some(input);
            self
        }
        /// <p>The attachment details.</p>
        pub fn set_attachment(
            mut self,
            input: std::option::Option<crate::model::Attachment>,
        ) -> Self {
            self.attachment = input;
            self
        }
        /// <p>The ID of the transport attachment.</p>
        pub fn transport_attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transport_attachment_id = Some(input.into());
            self
        }
        /// <p>The ID of the transport attachment.</p>
        pub fn set_transport_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transport_attachment_id = input;
            self
        }
        /// <p>Options for connecting an attachment.</p>
        pub fn options(mut self, input: crate::model::ConnectAttachmentOptions) -> Self {
            self.options = Some(input);
            self
        }
        /// <p>Options for connecting an attachment.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<crate::model::ConnectAttachmentOptions>,
        ) -> Self {
            self.options = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectAttachment`](crate::model::ConnectAttachment)
        pub fn build(self) -> crate::model::ConnectAttachment {
            crate::model::ConnectAttachment {
                attachment: self.attachment,
                transport_attachment_id: self.transport_attachment_id,
                options: self.options,
            }
        }
    }
}
impl ConnectAttachment {
    /// Creates a new builder-style object to manufacture [`ConnectAttachment`](crate::model::ConnectAttachment)
    pub fn builder() -> crate::model::connect_attachment::Builder {
        crate::model::connect_attachment::Builder::default()
    }
}

/// <p>Describes a core network Connect attachment options.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectAttachmentOptions {
    /// <p>The protocol used for the attachment connection.</p>
    pub protocol: std::option::Option<crate::model::TunnelProtocol>,
}
impl ConnectAttachmentOptions {
    /// <p>The protocol used for the attachment connection.</p>
    pub fn protocol(&self) -> std::option::Option<&crate::model::TunnelProtocol> {
        self.protocol.as_ref()
    }
}
impl std::fmt::Debug for ConnectAttachmentOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectAttachmentOptions");
        formatter.field("protocol", &self.protocol);
        formatter.finish()
    }
}
/// See [`ConnectAttachmentOptions`](crate::model::ConnectAttachmentOptions)
pub mod connect_attachment_options {
    /// A builder for [`ConnectAttachmentOptions`](crate::model::ConnectAttachmentOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) protocol: std::option::Option<crate::model::TunnelProtocol>,
    }
    impl Builder {
        /// <p>The protocol used for the attachment connection.</p>
        pub fn protocol(mut self, input: crate::model::TunnelProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol used for the attachment connection.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::TunnelProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectAttachmentOptions`](crate::model::ConnectAttachmentOptions)
        pub fn build(self) -> crate::model::ConnectAttachmentOptions {
            crate::model::ConnectAttachmentOptions {
                protocol: self.protocol,
            }
        }
    }
}
impl ConnectAttachmentOptions {
    /// Creates a new builder-style object to manufacture [`ConnectAttachmentOptions`](crate::model::ConnectAttachmentOptions)
    pub fn builder() -> crate::model::connect_attachment_options::Builder {
        crate::model::connect_attachment_options::Builder::default()
    }
}

/// <p>Describes the BGP options.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BgpOptions {
    /// <p>The Peer ASN of the BGP.</p>
    pub peer_asn: std::option::Option<i64>,
}
impl BgpOptions {
    /// <p>The Peer ASN of the BGP.</p>
    pub fn peer_asn(&self) -> std::option::Option<i64> {
        self.peer_asn
    }
}
impl std::fmt::Debug for BgpOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BgpOptions");
        formatter.field("peer_asn", &self.peer_asn);
        formatter.finish()
    }
}
/// See [`BgpOptions`](crate::model::BgpOptions)
pub mod bgp_options {
    /// A builder for [`BgpOptions`](crate::model::BgpOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) peer_asn: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The Peer ASN of the BGP.</p>
        pub fn peer_asn(mut self, input: i64) -> Self {
            self.peer_asn = Some(input);
            self
        }
        /// <p>The Peer ASN of the BGP.</p>
        pub fn set_peer_asn(mut self, input: std::option::Option<i64>) -> Self {
            self.peer_asn = input;
            self
        }
        /// Consumes the builder and constructs a [`BgpOptions`](crate::model::BgpOptions)
        pub fn build(self) -> crate::model::BgpOptions {
            crate::model::BgpOptions {
                peer_asn: self.peer_asn,
            }
        }
    }
}
impl BgpOptions {
    /// Creates a new builder-style object to manufacture [`BgpOptions`](crate::model::BgpOptions)
    pub fn builder() -> crate::model::bgp_options::Builder {
        crate::model::bgp_options::Builder::default()
    }
}
