// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSiteOutput {
    /// <p>Information about the site.</p>
    pub site: std::option::Option<crate::model::Site>,
}
impl std::fmt::Debug for UpdateSiteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSiteOutput");
        formatter.field("site", &self.site);
        formatter.finish()
    }
}
/// See [`UpdateSiteOutput`](crate::output::UpdateSiteOutput)
pub mod update_site_output {
    /// A builder for [`UpdateSiteOutput`](crate::output::UpdateSiteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site: std::option::Option<crate::model::Site>,
    }
    impl Builder {
        /// <p>Information about the site.</p>
        pub fn site(mut self, input: crate::model::Site) -> Self {
            self.site = Some(input);
            self
        }
        /// <p>Information about the site.</p>
        pub fn set_site(mut self, input: std::option::Option<crate::model::Site>) -> Self {
            self.site = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSiteOutput`](crate::output::UpdateSiteOutput)
        pub fn build(self) -> crate::output::UpdateSiteOutput {
            crate::output::UpdateSiteOutput { site: self.site }
        }
    }
}
impl UpdateSiteOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSiteOutput`](crate::output::UpdateSiteOutput)
    pub fn builder() -> crate::output::update_site_output::Builder {
        crate::output::update_site_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLinkOutput {
    /// <p>Information about the link.</p>
    pub link: std::option::Option<crate::model::Link>,
}
impl std::fmt::Debug for UpdateLinkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLinkOutput");
        formatter.field("link", &self.link);
        formatter.finish()
    }
}
/// See [`UpdateLinkOutput`](crate::output::UpdateLinkOutput)
pub mod update_link_output {
    /// A builder for [`UpdateLinkOutput`](crate::output::UpdateLinkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) link: std::option::Option<crate::model::Link>,
    }
    impl Builder {
        /// <p>Information about the link.</p>
        pub fn link(mut self, input: crate::model::Link) -> Self {
            self.link = Some(input);
            self
        }
        /// <p>Information about the link.</p>
        pub fn set_link(mut self, input: std::option::Option<crate::model::Link>) -> Self {
            self.link = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLinkOutput`](crate::output::UpdateLinkOutput)
        pub fn build(self) -> crate::output::UpdateLinkOutput {
            crate::output::UpdateLinkOutput { link: self.link }
        }
    }
}
impl UpdateLinkOutput {
    /// Creates a new builder-style object to manufacture [`UpdateLinkOutput`](crate::output::UpdateLinkOutput)
    pub fn builder() -> crate::output::update_link_output::Builder {
        crate::output::update_link_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGlobalNetworkOutput {
    /// <p>Information about the global network object.</p>
    pub global_network: std::option::Option<crate::model::GlobalNetwork>,
}
impl std::fmt::Debug for UpdateGlobalNetworkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGlobalNetworkOutput");
        formatter.field("global_network", &self.global_network);
        formatter.finish()
    }
}
/// See [`UpdateGlobalNetworkOutput`](crate::output::UpdateGlobalNetworkOutput)
pub mod update_global_network_output {
    /// A builder for [`UpdateGlobalNetworkOutput`](crate::output::UpdateGlobalNetworkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network: std::option::Option<crate::model::GlobalNetwork>,
    }
    impl Builder {
        /// <p>Information about the global network object.</p>
        pub fn global_network(mut self, input: crate::model::GlobalNetwork) -> Self {
            self.global_network = Some(input);
            self
        }
        /// <p>Information about the global network object.</p>
        pub fn set_global_network(
            mut self,
            input: std::option::Option<crate::model::GlobalNetwork>,
        ) -> Self {
            self.global_network = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGlobalNetworkOutput`](crate::output::UpdateGlobalNetworkOutput)
        pub fn build(self) -> crate::output::UpdateGlobalNetworkOutput {
            crate::output::UpdateGlobalNetworkOutput {
                global_network: self.global_network,
            }
        }
    }
}
impl UpdateGlobalNetworkOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGlobalNetworkOutput`](crate::output::UpdateGlobalNetworkOutput)
    pub fn builder() -> crate::output::update_global_network_output::Builder {
        crate::output::update_global_network_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeviceOutput {
    /// <p>Information about the device.</p>
    pub device: std::option::Option<crate::model::Device>,
}
impl std::fmt::Debug for UpdateDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeviceOutput");
        formatter.field("device", &self.device);
        formatter.finish()
    }
}
/// See [`UpdateDeviceOutput`](crate::output::UpdateDeviceOutput)
pub mod update_device_output {
    /// A builder for [`UpdateDeviceOutput`](crate::output::UpdateDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device: std::option::Option<crate::model::Device>,
    }
    impl Builder {
        /// <p>Information about the device.</p>
        pub fn device(mut self, input: crate::model::Device) -> Self {
            self.device = Some(input);
            self
        }
        /// <p>Information about the device.</p>
        pub fn set_device(mut self, input: std::option::Option<crate::model::Device>) -> Self {
            self.device = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeviceOutput`](crate::output::UpdateDeviceOutput)
        pub fn build(self) -> crate::output::UpdateDeviceOutput {
            crate::output::UpdateDeviceOutput {
                device: self.device,
            }
        }
    }
}
impl UpdateDeviceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDeviceOutput`](crate::output::UpdateDeviceOutput)
    pub fn builder() -> crate::output::update_device_output::Builder {
        crate::output::update_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectionOutput {
    /// <p>Information about the connection.</p>
    pub connection: std::option::Option<crate::model::Connection>,
}
impl std::fmt::Debug for UpdateConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectionOutput");
        formatter.field("connection", &self.connection);
        formatter.finish()
    }
}
/// See [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
pub mod update_connection_output {
    /// A builder for [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection: std::option::Option<crate::model::Connection>,
    }
    impl Builder {
        /// <p>Information about the connection.</p>
        pub fn connection(mut self, input: crate::model::Connection) -> Self {
            self.connection = Some(input);
            self
        }
        /// <p>Information about the connection.</p>
        pub fn set_connection(
            mut self,
            input: std::option::Option<crate::model::Connection>,
        ) -> Self {
            self.connection = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
        pub fn build(self) -> crate::output::UpdateConnectionOutput {
            crate::output::UpdateConnectionOutput {
                connection: self.connection,
            }
        }
    }
}
impl UpdateConnectionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
    pub fn builder() -> crate::output::update_connection_output::Builder {
        crate::output::update_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterTransitGatewayOutput {
    /// <p>Information about the transit gateway registration.</p>
    pub transit_gateway_registration: std::option::Option<crate::model::TransitGatewayRegistration>,
}
impl std::fmt::Debug for RegisterTransitGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterTransitGatewayOutput");
        formatter.field(
            "transit_gateway_registration",
            &self.transit_gateway_registration,
        );
        formatter.finish()
    }
}
/// See [`RegisterTransitGatewayOutput`](crate::output::RegisterTransitGatewayOutput)
pub mod register_transit_gateway_output {
    /// A builder for [`RegisterTransitGatewayOutput`](crate::output::RegisterTransitGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_registration:
            std::option::Option<crate::model::TransitGatewayRegistration>,
    }
    impl Builder {
        /// <p>Information about the transit gateway registration.</p>
        pub fn transit_gateway_registration(
            mut self,
            input: crate::model::TransitGatewayRegistration,
        ) -> Self {
            self.transit_gateway_registration = Some(input);
            self
        }
        /// <p>Information about the transit gateway registration.</p>
        pub fn set_transit_gateway_registration(
            mut self,
            input: std::option::Option<crate::model::TransitGatewayRegistration>,
        ) -> Self {
            self.transit_gateway_registration = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterTransitGatewayOutput`](crate::output::RegisterTransitGatewayOutput)
        pub fn build(self) -> crate::output::RegisterTransitGatewayOutput {
            crate::output::RegisterTransitGatewayOutput {
                transit_gateway_registration: self.transit_gateway_registration,
            }
        }
    }
}
impl RegisterTransitGatewayOutput {
    /// Creates a new builder-style object to manufacture [`RegisterTransitGatewayOutput`](crate::output::RegisterTransitGatewayOutput)
    pub fn builder() -> crate::output::register_transit_gateway_output::Builder {
        crate::output::register_transit_gateway_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The list of tags.</p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>The list of tags.</p>
        pub fn tag_list(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>The list of tags.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tag_list: self.tag_list,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTransitGatewayRegistrationsOutput {
    /// <p>The transit gateway registrations.</p>
    pub transit_gateway_registrations:
        std::option::Option<std::vec::Vec<crate::model::TransitGatewayRegistration>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetTransitGatewayRegistrationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTransitGatewayRegistrationsOutput");
        formatter.field(
            "transit_gateway_registrations",
            &self.transit_gateway_registrations,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetTransitGatewayRegistrationsOutput`](crate::output::GetTransitGatewayRegistrationsOutput)
pub mod get_transit_gateway_registrations_output {
    /// A builder for [`GetTransitGatewayRegistrationsOutput`](crate::output::GetTransitGatewayRegistrationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_registrations:
            std::option::Option<std::vec::Vec<crate::model::TransitGatewayRegistration>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `transit_gateway_registrations`.
        ///
        /// To override the contents of this collection use [`set_transit_gateway_registrations`](Self::set_transit_gateway_registrations).
        ///
        /// <p>The transit gateway registrations.</p>
        pub fn transit_gateway_registrations(
            mut self,
            input: impl Into<crate::model::TransitGatewayRegistration>,
        ) -> Self {
            let mut v = self.transit_gateway_registrations.unwrap_or_default();
            v.push(input.into());
            self.transit_gateway_registrations = Some(v);
            self
        }
        /// <p>The transit gateway registrations.</p>
        pub fn set_transit_gateway_registrations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TransitGatewayRegistration>>,
        ) -> Self {
            self.transit_gateway_registrations = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTransitGatewayRegistrationsOutput`](crate::output::GetTransitGatewayRegistrationsOutput)
        pub fn build(self) -> crate::output::GetTransitGatewayRegistrationsOutput {
            crate::output::GetTransitGatewayRegistrationsOutput {
                transit_gateway_registrations: self.transit_gateway_registrations,
                next_token: self.next_token,
            }
        }
    }
}
impl GetTransitGatewayRegistrationsOutput {
    /// Creates a new builder-style object to manufacture [`GetTransitGatewayRegistrationsOutput`](crate::output::GetTransitGatewayRegistrationsOutput)
    pub fn builder() -> crate::output::get_transit_gateway_registrations_output::Builder {
        crate::output::get_transit_gateway_registrations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTransitGatewayConnectPeerAssociationsOutput {
    /// <p>Information about the transit gateway Connect peer associations.</p>
    pub transit_gateway_connect_peer_associations:
        std::option::Option<std::vec::Vec<crate::model::TransitGatewayConnectPeerAssociation>>,
    /// <p>The token to use for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetTransitGatewayConnectPeerAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTransitGatewayConnectPeerAssociationsOutput");
        formatter.field(
            "transit_gateway_connect_peer_associations",
            &self.transit_gateway_connect_peer_associations,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetTransitGatewayConnectPeerAssociationsOutput`](crate::output::GetTransitGatewayConnectPeerAssociationsOutput)
pub mod get_transit_gateway_connect_peer_associations_output {
    /// A builder for [`GetTransitGatewayConnectPeerAssociationsOutput`](crate::output::GetTransitGatewayConnectPeerAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_connect_peer_associations:
            std::option::Option<std::vec::Vec<crate::model::TransitGatewayConnectPeerAssociation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `transit_gateway_connect_peer_associations`.
        ///
        /// To override the contents of this collection use [`set_transit_gateway_connect_peer_associations`](Self::set_transit_gateway_connect_peer_associations).
        ///
        /// <p>Information about the transit gateway Connect peer associations.</p>
        pub fn transit_gateway_connect_peer_associations(
            mut self,
            input: impl Into<crate::model::TransitGatewayConnectPeerAssociation>,
        ) -> Self {
            let mut v = self
                .transit_gateway_connect_peer_associations
                .unwrap_or_default();
            v.push(input.into());
            self.transit_gateway_connect_peer_associations = Some(v);
            self
        }
        /// <p>Information about the transit gateway Connect peer associations.</p>
        pub fn set_transit_gateway_connect_peer_associations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::TransitGatewayConnectPeerAssociation>,
            >,
        ) -> Self {
            self.transit_gateway_connect_peer_associations = input;
            self
        }
        /// <p>The token to use for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTransitGatewayConnectPeerAssociationsOutput`](crate::output::GetTransitGatewayConnectPeerAssociationsOutput)
        pub fn build(self) -> crate::output::GetTransitGatewayConnectPeerAssociationsOutput {
            crate::output::GetTransitGatewayConnectPeerAssociationsOutput {
                transit_gateway_connect_peer_associations: self
                    .transit_gateway_connect_peer_associations,
                next_token: self.next_token,
            }
        }
    }
}
impl GetTransitGatewayConnectPeerAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`GetTransitGatewayConnectPeerAssociationsOutput`](crate::output::GetTransitGatewayConnectPeerAssociationsOutput)
    pub fn builder() -> crate::output::get_transit_gateway_connect_peer_associations_output::Builder
    {
        crate::output::get_transit_gateway_connect_peer_associations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSitesOutput {
    /// <p>The sites.</p>
    pub sites: std::option::Option<std::vec::Vec<crate::model::Site>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSitesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSitesOutput");
        formatter.field("sites", &self.sites);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetSitesOutput`](crate::output::GetSitesOutput)
pub mod get_sites_output {
    /// A builder for [`GetSitesOutput`](crate::output::GetSitesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sites: std::option::Option<std::vec::Vec<crate::model::Site>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `sites`.
        ///
        /// To override the contents of this collection use [`set_sites`](Self::set_sites).
        ///
        /// <p>The sites.</p>
        pub fn sites(mut self, input: impl Into<crate::model::Site>) -> Self {
            let mut v = self.sites.unwrap_or_default();
            v.push(input.into());
            self.sites = Some(v);
            self
        }
        /// <p>The sites.</p>
        pub fn set_sites(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Site>>,
        ) -> Self {
            self.sites = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSitesOutput`](crate::output::GetSitesOutput)
        pub fn build(self) -> crate::output::GetSitesOutput {
            crate::output::GetSitesOutput {
                sites: self.sites,
                next_token: self.next_token,
            }
        }
    }
}
impl GetSitesOutput {
    /// Creates a new builder-style object to manufacture [`GetSitesOutput`](crate::output::GetSitesOutput)
    pub fn builder() -> crate::output::get_sites_output::Builder {
        crate::output::get_sites_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLinksOutput {
    /// <p>The links.</p>
    pub links: std::option::Option<std::vec::Vec<crate::model::Link>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetLinksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLinksOutput");
        formatter.field("links", &self.links);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetLinksOutput`](crate::output::GetLinksOutput)
pub mod get_links_output {
    /// A builder for [`GetLinksOutput`](crate::output::GetLinksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) links: std::option::Option<std::vec::Vec<crate::model::Link>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `links`.
        ///
        /// To override the contents of this collection use [`set_links`](Self::set_links).
        ///
        /// <p>The links.</p>
        pub fn links(mut self, input: impl Into<crate::model::Link>) -> Self {
            let mut v = self.links.unwrap_or_default();
            v.push(input.into());
            self.links = Some(v);
            self
        }
        /// <p>The links.</p>
        pub fn set_links(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Link>>,
        ) -> Self {
            self.links = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLinksOutput`](crate::output::GetLinksOutput)
        pub fn build(self) -> crate::output::GetLinksOutput {
            crate::output::GetLinksOutput {
                links: self.links,
                next_token: self.next_token,
            }
        }
    }
}
impl GetLinksOutput {
    /// Creates a new builder-style object to manufacture [`GetLinksOutput`](crate::output::GetLinksOutput)
    pub fn builder() -> crate::output::get_links_output::Builder {
        crate::output::get_links_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLinkAssociationsOutput {
    /// <p>The link associations.</p>
    pub link_associations: std::option::Option<std::vec::Vec<crate::model::LinkAssociation>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetLinkAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLinkAssociationsOutput");
        formatter.field("link_associations", &self.link_associations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetLinkAssociationsOutput`](crate::output::GetLinkAssociationsOutput)
pub mod get_link_associations_output {
    /// A builder for [`GetLinkAssociationsOutput`](crate::output::GetLinkAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) link_associations:
            std::option::Option<std::vec::Vec<crate::model::LinkAssociation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `link_associations`.
        ///
        /// To override the contents of this collection use [`set_link_associations`](Self::set_link_associations).
        ///
        /// <p>The link associations.</p>
        pub fn link_associations(
            mut self,
            input: impl Into<crate::model::LinkAssociation>,
        ) -> Self {
            let mut v = self.link_associations.unwrap_or_default();
            v.push(input.into());
            self.link_associations = Some(v);
            self
        }
        /// <p>The link associations.</p>
        pub fn set_link_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LinkAssociation>>,
        ) -> Self {
            self.link_associations = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLinkAssociationsOutput`](crate::output::GetLinkAssociationsOutput)
        pub fn build(self) -> crate::output::GetLinkAssociationsOutput {
            crate::output::GetLinkAssociationsOutput {
                link_associations: self.link_associations,
                next_token: self.next_token,
            }
        }
    }
}
impl GetLinkAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`GetLinkAssociationsOutput`](crate::output::GetLinkAssociationsOutput)
    pub fn builder() -> crate::output::get_link_associations_output::Builder {
        crate::output::get_link_associations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDevicesOutput {
    /// <p>The devices.</p>
    pub devices: std::option::Option<std::vec::Vec<crate::model::Device>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDevicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDevicesOutput");
        formatter.field("devices", &self.devices);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetDevicesOutput`](crate::output::GetDevicesOutput)
pub mod get_devices_output {
    /// A builder for [`GetDevicesOutput`](crate::output::GetDevicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) devices: std::option::Option<std::vec::Vec<crate::model::Device>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `devices`.
        ///
        /// To override the contents of this collection use [`set_devices`](Self::set_devices).
        ///
        /// <p>The devices.</p>
        pub fn devices(mut self, input: impl Into<crate::model::Device>) -> Self {
            let mut v = self.devices.unwrap_or_default();
            v.push(input.into());
            self.devices = Some(v);
            self
        }
        /// <p>The devices.</p>
        pub fn set_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Device>>,
        ) -> Self {
            self.devices = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDevicesOutput`](crate::output::GetDevicesOutput)
        pub fn build(self) -> crate::output::GetDevicesOutput {
            crate::output::GetDevicesOutput {
                devices: self.devices,
                next_token: self.next_token,
            }
        }
    }
}
impl GetDevicesOutput {
    /// Creates a new builder-style object to manufacture [`GetDevicesOutput`](crate::output::GetDevicesOutput)
    pub fn builder() -> crate::output::get_devices_output::Builder {
        crate::output::get_devices_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCustomerGatewayAssociationsOutput {
    /// <p>The customer gateway associations.</p>
    pub customer_gateway_associations:
        std::option::Option<std::vec::Vec<crate::model::CustomerGatewayAssociation>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetCustomerGatewayAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCustomerGatewayAssociationsOutput");
        formatter.field(
            "customer_gateway_associations",
            &self.customer_gateway_associations,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetCustomerGatewayAssociationsOutput`](crate::output::GetCustomerGatewayAssociationsOutput)
pub mod get_customer_gateway_associations_output {
    /// A builder for [`GetCustomerGatewayAssociationsOutput`](crate::output::GetCustomerGatewayAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) customer_gateway_associations:
            std::option::Option<std::vec::Vec<crate::model::CustomerGatewayAssociation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `customer_gateway_associations`.
        ///
        /// To override the contents of this collection use [`set_customer_gateway_associations`](Self::set_customer_gateway_associations).
        ///
        /// <p>The customer gateway associations.</p>
        pub fn customer_gateway_associations(
            mut self,
            input: impl Into<crate::model::CustomerGatewayAssociation>,
        ) -> Self {
            let mut v = self.customer_gateway_associations.unwrap_or_default();
            v.push(input.into());
            self.customer_gateway_associations = Some(v);
            self
        }
        /// <p>The customer gateway associations.</p>
        pub fn set_customer_gateway_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomerGatewayAssociation>>,
        ) -> Self {
            self.customer_gateway_associations = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCustomerGatewayAssociationsOutput`](crate::output::GetCustomerGatewayAssociationsOutput)
        pub fn build(self) -> crate::output::GetCustomerGatewayAssociationsOutput {
            crate::output::GetCustomerGatewayAssociationsOutput {
                customer_gateway_associations: self.customer_gateway_associations,
                next_token: self.next_token,
            }
        }
    }
}
impl GetCustomerGatewayAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`GetCustomerGatewayAssociationsOutput`](crate::output::GetCustomerGatewayAssociationsOutput)
    pub fn builder() -> crate::output::get_customer_gateway_associations_output::Builder {
        crate::output::get_customer_gateway_associations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConnectionsOutput {
    /// <p>Information about the connections.</p>
    pub connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
    /// <p>The token to use for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetConnectionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConnectionsOutput");
        formatter.field("connections", &self.connections);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetConnectionsOutput`](crate::output::GetConnectionsOutput)
pub mod get_connections_output {
    /// A builder for [`GetConnectionsOutput`](crate::output::GetConnectionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `connections`.
        ///
        /// To override the contents of this collection use [`set_connections`](Self::set_connections).
        ///
        /// <p>Information about the connections.</p>
        pub fn connections(mut self, input: impl Into<crate::model::Connection>) -> Self {
            let mut v = self.connections.unwrap_or_default();
            v.push(input.into());
            self.connections = Some(v);
            self
        }
        /// <p>Information about the connections.</p>
        pub fn set_connections(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        ) -> Self {
            self.connections = input;
            self
        }
        /// <p>The token to use for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConnectionsOutput`](crate::output::GetConnectionsOutput)
        pub fn build(self) -> crate::output::GetConnectionsOutput {
            crate::output::GetConnectionsOutput {
                connections: self.connections,
                next_token: self.next_token,
            }
        }
    }
}
impl GetConnectionsOutput {
    /// Creates a new builder-style object to manufacture [`GetConnectionsOutput`](crate::output::GetConnectionsOutput)
    pub fn builder() -> crate::output::get_connections_output::Builder {
        crate::output::get_connections_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateTransitGatewayConnectPeerOutput {
    /// <p>The transit gateway Connect peer association.</p>
    pub transit_gateway_connect_peer_association:
        std::option::Option<crate::model::TransitGatewayConnectPeerAssociation>,
}
impl std::fmt::Debug for DisassociateTransitGatewayConnectPeerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateTransitGatewayConnectPeerOutput");
        formatter.field(
            "transit_gateway_connect_peer_association",
            &self.transit_gateway_connect_peer_association,
        );
        formatter.finish()
    }
}
/// See [`DisassociateTransitGatewayConnectPeerOutput`](crate::output::DisassociateTransitGatewayConnectPeerOutput)
pub mod disassociate_transit_gateway_connect_peer_output {
    /// A builder for [`DisassociateTransitGatewayConnectPeerOutput`](crate::output::DisassociateTransitGatewayConnectPeerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_connect_peer_association:
            std::option::Option<crate::model::TransitGatewayConnectPeerAssociation>,
    }
    impl Builder {
        /// <p>The transit gateway Connect peer association.</p>
        pub fn transit_gateway_connect_peer_association(
            mut self,
            input: crate::model::TransitGatewayConnectPeerAssociation,
        ) -> Self {
            self.transit_gateway_connect_peer_association = Some(input);
            self
        }
        /// <p>The transit gateway Connect peer association.</p>
        pub fn set_transit_gateway_connect_peer_association(
            mut self,
            input: std::option::Option<crate::model::TransitGatewayConnectPeerAssociation>,
        ) -> Self {
            self.transit_gateway_connect_peer_association = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateTransitGatewayConnectPeerOutput`](crate::output::DisassociateTransitGatewayConnectPeerOutput)
        pub fn build(self) -> crate::output::DisassociateTransitGatewayConnectPeerOutput {
            crate::output::DisassociateTransitGatewayConnectPeerOutput {
                transit_gateway_connect_peer_association: self
                    .transit_gateway_connect_peer_association,
            }
        }
    }
}
impl DisassociateTransitGatewayConnectPeerOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateTransitGatewayConnectPeerOutput`](crate::output::DisassociateTransitGatewayConnectPeerOutput)
    pub fn builder() -> crate::output::disassociate_transit_gateway_connect_peer_output::Builder {
        crate::output::disassociate_transit_gateway_connect_peer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateLinkOutput {
    /// <p>Information about the link association.</p>
    pub link_association: std::option::Option<crate::model::LinkAssociation>,
}
impl std::fmt::Debug for DisassociateLinkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateLinkOutput");
        formatter.field("link_association", &self.link_association);
        formatter.finish()
    }
}
/// See [`DisassociateLinkOutput`](crate::output::DisassociateLinkOutput)
pub mod disassociate_link_output {
    /// A builder for [`DisassociateLinkOutput`](crate::output::DisassociateLinkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) link_association: std::option::Option<crate::model::LinkAssociation>,
    }
    impl Builder {
        /// <p>Information about the link association.</p>
        pub fn link_association(mut self, input: crate::model::LinkAssociation) -> Self {
            self.link_association = Some(input);
            self
        }
        /// <p>Information about the link association.</p>
        pub fn set_link_association(
            mut self,
            input: std::option::Option<crate::model::LinkAssociation>,
        ) -> Self {
            self.link_association = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateLinkOutput`](crate::output::DisassociateLinkOutput)
        pub fn build(self) -> crate::output::DisassociateLinkOutput {
            crate::output::DisassociateLinkOutput {
                link_association: self.link_association,
            }
        }
    }
}
impl DisassociateLinkOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateLinkOutput`](crate::output::DisassociateLinkOutput)
    pub fn builder() -> crate::output::disassociate_link_output::Builder {
        crate::output::disassociate_link_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateCustomerGatewayOutput {
    /// <p>Information about the customer gateway association.</p>
    pub customer_gateway_association: std::option::Option<crate::model::CustomerGatewayAssociation>,
}
impl std::fmt::Debug for DisassociateCustomerGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateCustomerGatewayOutput");
        formatter.field(
            "customer_gateway_association",
            &self.customer_gateway_association,
        );
        formatter.finish()
    }
}
/// See [`DisassociateCustomerGatewayOutput`](crate::output::DisassociateCustomerGatewayOutput)
pub mod disassociate_customer_gateway_output {
    /// A builder for [`DisassociateCustomerGatewayOutput`](crate::output::DisassociateCustomerGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) customer_gateway_association:
            std::option::Option<crate::model::CustomerGatewayAssociation>,
    }
    impl Builder {
        /// <p>Information about the customer gateway association.</p>
        pub fn customer_gateway_association(
            mut self,
            input: crate::model::CustomerGatewayAssociation,
        ) -> Self {
            self.customer_gateway_association = Some(input);
            self
        }
        /// <p>Information about the customer gateway association.</p>
        pub fn set_customer_gateway_association(
            mut self,
            input: std::option::Option<crate::model::CustomerGatewayAssociation>,
        ) -> Self {
            self.customer_gateway_association = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateCustomerGatewayOutput`](crate::output::DisassociateCustomerGatewayOutput)
        pub fn build(self) -> crate::output::DisassociateCustomerGatewayOutput {
            crate::output::DisassociateCustomerGatewayOutput {
                customer_gateway_association: self.customer_gateway_association,
            }
        }
    }
}
impl DisassociateCustomerGatewayOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateCustomerGatewayOutput`](crate::output::DisassociateCustomerGatewayOutput)
    pub fn builder() -> crate::output::disassociate_customer_gateway_output::Builder {
        crate::output::disassociate_customer_gateway_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGlobalNetworksOutput {
    /// <p>Information about the global networks.</p>
    pub global_networks: std::option::Option<std::vec::Vec<crate::model::GlobalNetwork>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeGlobalNetworksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGlobalNetworksOutput");
        formatter.field("global_networks", &self.global_networks);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeGlobalNetworksOutput`](crate::output::DescribeGlobalNetworksOutput)
pub mod describe_global_networks_output {
    /// A builder for [`DescribeGlobalNetworksOutput`](crate::output::DescribeGlobalNetworksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_networks: std::option::Option<std::vec::Vec<crate::model::GlobalNetwork>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `global_networks`.
        ///
        /// To override the contents of this collection use [`set_global_networks`](Self::set_global_networks).
        ///
        /// <p>Information about the global networks.</p>
        pub fn global_networks(mut self, input: impl Into<crate::model::GlobalNetwork>) -> Self {
            let mut v = self.global_networks.unwrap_or_default();
            v.push(input.into());
            self.global_networks = Some(v);
            self
        }
        /// <p>Information about the global networks.</p>
        pub fn set_global_networks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalNetwork>>,
        ) -> Self {
            self.global_networks = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGlobalNetworksOutput`](crate::output::DescribeGlobalNetworksOutput)
        pub fn build(self) -> crate::output::DescribeGlobalNetworksOutput {
            crate::output::DescribeGlobalNetworksOutput {
                global_networks: self.global_networks,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeGlobalNetworksOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGlobalNetworksOutput`](crate::output::DescribeGlobalNetworksOutput)
    pub fn builder() -> crate::output::describe_global_networks_output::Builder {
        crate::output::describe_global_networks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterTransitGatewayOutput {
    /// <p>The transit gateway registration information.</p>
    pub transit_gateway_registration: std::option::Option<crate::model::TransitGatewayRegistration>,
}
impl std::fmt::Debug for DeregisterTransitGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterTransitGatewayOutput");
        formatter.field(
            "transit_gateway_registration",
            &self.transit_gateway_registration,
        );
        formatter.finish()
    }
}
/// See [`DeregisterTransitGatewayOutput`](crate::output::DeregisterTransitGatewayOutput)
pub mod deregister_transit_gateway_output {
    /// A builder for [`DeregisterTransitGatewayOutput`](crate::output::DeregisterTransitGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_registration:
            std::option::Option<crate::model::TransitGatewayRegistration>,
    }
    impl Builder {
        /// <p>The transit gateway registration information.</p>
        pub fn transit_gateway_registration(
            mut self,
            input: crate::model::TransitGatewayRegistration,
        ) -> Self {
            self.transit_gateway_registration = Some(input);
            self
        }
        /// <p>The transit gateway registration information.</p>
        pub fn set_transit_gateway_registration(
            mut self,
            input: std::option::Option<crate::model::TransitGatewayRegistration>,
        ) -> Self {
            self.transit_gateway_registration = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterTransitGatewayOutput`](crate::output::DeregisterTransitGatewayOutput)
        pub fn build(self) -> crate::output::DeregisterTransitGatewayOutput {
            crate::output::DeregisterTransitGatewayOutput {
                transit_gateway_registration: self.transit_gateway_registration,
            }
        }
    }
}
impl DeregisterTransitGatewayOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterTransitGatewayOutput`](crate::output::DeregisterTransitGatewayOutput)
    pub fn builder() -> crate::output::deregister_transit_gateway_output::Builder {
        crate::output::deregister_transit_gateway_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSiteOutput {
    /// <p>Information about the site.</p>
    pub site: std::option::Option<crate::model::Site>,
}
impl std::fmt::Debug for DeleteSiteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSiteOutput");
        formatter.field("site", &self.site);
        formatter.finish()
    }
}
/// See [`DeleteSiteOutput`](crate::output::DeleteSiteOutput)
pub mod delete_site_output {
    /// A builder for [`DeleteSiteOutput`](crate::output::DeleteSiteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site: std::option::Option<crate::model::Site>,
    }
    impl Builder {
        /// <p>Information about the site.</p>
        pub fn site(mut self, input: crate::model::Site) -> Self {
            self.site = Some(input);
            self
        }
        /// <p>Information about the site.</p>
        pub fn set_site(mut self, input: std::option::Option<crate::model::Site>) -> Self {
            self.site = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSiteOutput`](crate::output::DeleteSiteOutput)
        pub fn build(self) -> crate::output::DeleteSiteOutput {
            crate::output::DeleteSiteOutput { site: self.site }
        }
    }
}
impl DeleteSiteOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSiteOutput`](crate::output::DeleteSiteOutput)
    pub fn builder() -> crate::output::delete_site_output::Builder {
        crate::output::delete_site_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLinkOutput {
    /// <p>Information about the link.</p>
    pub link: std::option::Option<crate::model::Link>,
}
impl std::fmt::Debug for DeleteLinkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLinkOutput");
        formatter.field("link", &self.link);
        formatter.finish()
    }
}
/// See [`DeleteLinkOutput`](crate::output::DeleteLinkOutput)
pub mod delete_link_output {
    /// A builder for [`DeleteLinkOutput`](crate::output::DeleteLinkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) link: std::option::Option<crate::model::Link>,
    }
    impl Builder {
        /// <p>Information about the link.</p>
        pub fn link(mut self, input: crate::model::Link) -> Self {
            self.link = Some(input);
            self
        }
        /// <p>Information about the link.</p>
        pub fn set_link(mut self, input: std::option::Option<crate::model::Link>) -> Self {
            self.link = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLinkOutput`](crate::output::DeleteLinkOutput)
        pub fn build(self) -> crate::output::DeleteLinkOutput {
            crate::output::DeleteLinkOutput { link: self.link }
        }
    }
}
impl DeleteLinkOutput {
    /// Creates a new builder-style object to manufacture [`DeleteLinkOutput`](crate::output::DeleteLinkOutput)
    pub fn builder() -> crate::output::delete_link_output::Builder {
        crate::output::delete_link_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGlobalNetworkOutput {
    /// <p>Information about the global network.</p>
    pub global_network: std::option::Option<crate::model::GlobalNetwork>,
}
impl std::fmt::Debug for DeleteGlobalNetworkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGlobalNetworkOutput");
        formatter.field("global_network", &self.global_network);
        formatter.finish()
    }
}
/// See [`DeleteGlobalNetworkOutput`](crate::output::DeleteGlobalNetworkOutput)
pub mod delete_global_network_output {
    /// A builder for [`DeleteGlobalNetworkOutput`](crate::output::DeleteGlobalNetworkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network: std::option::Option<crate::model::GlobalNetwork>,
    }
    impl Builder {
        /// <p>Information about the global network.</p>
        pub fn global_network(mut self, input: crate::model::GlobalNetwork) -> Self {
            self.global_network = Some(input);
            self
        }
        /// <p>Information about the global network.</p>
        pub fn set_global_network(
            mut self,
            input: std::option::Option<crate::model::GlobalNetwork>,
        ) -> Self {
            self.global_network = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGlobalNetworkOutput`](crate::output::DeleteGlobalNetworkOutput)
        pub fn build(self) -> crate::output::DeleteGlobalNetworkOutput {
            crate::output::DeleteGlobalNetworkOutput {
                global_network: self.global_network,
            }
        }
    }
}
impl DeleteGlobalNetworkOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGlobalNetworkOutput`](crate::output::DeleteGlobalNetworkOutput)
    pub fn builder() -> crate::output::delete_global_network_output::Builder {
        crate::output::delete_global_network_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDeviceOutput {
    /// <p>Information about the device.</p>
    pub device: std::option::Option<crate::model::Device>,
}
impl std::fmt::Debug for DeleteDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDeviceOutput");
        formatter.field("device", &self.device);
        formatter.finish()
    }
}
/// See [`DeleteDeviceOutput`](crate::output::DeleteDeviceOutput)
pub mod delete_device_output {
    /// A builder for [`DeleteDeviceOutput`](crate::output::DeleteDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device: std::option::Option<crate::model::Device>,
    }
    impl Builder {
        /// <p>Information about the device.</p>
        pub fn device(mut self, input: crate::model::Device) -> Self {
            self.device = Some(input);
            self
        }
        /// <p>Information about the device.</p>
        pub fn set_device(mut self, input: std::option::Option<crate::model::Device>) -> Self {
            self.device = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDeviceOutput`](crate::output::DeleteDeviceOutput)
        pub fn build(self) -> crate::output::DeleteDeviceOutput {
            crate::output::DeleteDeviceOutput {
                device: self.device,
            }
        }
    }
}
impl DeleteDeviceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDeviceOutput`](crate::output::DeleteDeviceOutput)
    pub fn builder() -> crate::output::delete_device_output::Builder {
        crate::output::delete_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConnectionOutput {
    /// <p>Information about the connection.</p>
    pub connection: std::option::Option<crate::model::Connection>,
}
impl std::fmt::Debug for DeleteConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConnectionOutput");
        formatter.field("connection", &self.connection);
        formatter.finish()
    }
}
/// See [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
pub mod delete_connection_output {
    /// A builder for [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection: std::option::Option<crate::model::Connection>,
    }
    impl Builder {
        /// <p>Information about the connection.</p>
        pub fn connection(mut self, input: crate::model::Connection) -> Self {
            self.connection = Some(input);
            self
        }
        /// <p>Information about the connection.</p>
        pub fn set_connection(
            mut self,
            input: std::option::Option<crate::model::Connection>,
        ) -> Self {
            self.connection = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
        pub fn build(self) -> crate::output::DeleteConnectionOutput {
            crate::output::DeleteConnectionOutput {
                connection: self.connection,
            }
        }
    }
}
impl DeleteConnectionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
    pub fn builder() -> crate::output::delete_connection_output::Builder {
        crate::output::delete_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSiteOutput {
    /// <p>Information about the site.</p>
    pub site: std::option::Option<crate::model::Site>,
}
impl std::fmt::Debug for CreateSiteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSiteOutput");
        formatter.field("site", &self.site);
        formatter.finish()
    }
}
/// See [`CreateSiteOutput`](crate::output::CreateSiteOutput)
pub mod create_site_output {
    /// A builder for [`CreateSiteOutput`](crate::output::CreateSiteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site: std::option::Option<crate::model::Site>,
    }
    impl Builder {
        /// <p>Information about the site.</p>
        pub fn site(mut self, input: crate::model::Site) -> Self {
            self.site = Some(input);
            self
        }
        /// <p>Information about the site.</p>
        pub fn set_site(mut self, input: std::option::Option<crate::model::Site>) -> Self {
            self.site = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSiteOutput`](crate::output::CreateSiteOutput)
        pub fn build(self) -> crate::output::CreateSiteOutput {
            crate::output::CreateSiteOutput { site: self.site }
        }
    }
}
impl CreateSiteOutput {
    /// Creates a new builder-style object to manufacture [`CreateSiteOutput`](crate::output::CreateSiteOutput)
    pub fn builder() -> crate::output::create_site_output::Builder {
        crate::output::create_site_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLinkOutput {
    /// <p>Information about the link.</p>
    pub link: std::option::Option<crate::model::Link>,
}
impl std::fmt::Debug for CreateLinkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLinkOutput");
        formatter.field("link", &self.link);
        formatter.finish()
    }
}
/// See [`CreateLinkOutput`](crate::output::CreateLinkOutput)
pub mod create_link_output {
    /// A builder for [`CreateLinkOutput`](crate::output::CreateLinkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) link: std::option::Option<crate::model::Link>,
    }
    impl Builder {
        /// <p>Information about the link.</p>
        pub fn link(mut self, input: crate::model::Link) -> Self {
            self.link = Some(input);
            self
        }
        /// <p>Information about the link.</p>
        pub fn set_link(mut self, input: std::option::Option<crate::model::Link>) -> Self {
            self.link = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLinkOutput`](crate::output::CreateLinkOutput)
        pub fn build(self) -> crate::output::CreateLinkOutput {
            crate::output::CreateLinkOutput { link: self.link }
        }
    }
}
impl CreateLinkOutput {
    /// Creates a new builder-style object to manufacture [`CreateLinkOutput`](crate::output::CreateLinkOutput)
    pub fn builder() -> crate::output::create_link_output::Builder {
        crate::output::create_link_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGlobalNetworkOutput {
    /// <p>Information about the global network object.</p>
    pub global_network: std::option::Option<crate::model::GlobalNetwork>,
}
impl std::fmt::Debug for CreateGlobalNetworkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGlobalNetworkOutput");
        formatter.field("global_network", &self.global_network);
        formatter.finish()
    }
}
/// See [`CreateGlobalNetworkOutput`](crate::output::CreateGlobalNetworkOutput)
pub mod create_global_network_output {
    /// A builder for [`CreateGlobalNetworkOutput`](crate::output::CreateGlobalNetworkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network: std::option::Option<crate::model::GlobalNetwork>,
    }
    impl Builder {
        /// <p>Information about the global network object.</p>
        pub fn global_network(mut self, input: crate::model::GlobalNetwork) -> Self {
            self.global_network = Some(input);
            self
        }
        /// <p>Information about the global network object.</p>
        pub fn set_global_network(
            mut self,
            input: std::option::Option<crate::model::GlobalNetwork>,
        ) -> Self {
            self.global_network = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGlobalNetworkOutput`](crate::output::CreateGlobalNetworkOutput)
        pub fn build(self) -> crate::output::CreateGlobalNetworkOutput {
            crate::output::CreateGlobalNetworkOutput {
                global_network: self.global_network,
            }
        }
    }
}
impl CreateGlobalNetworkOutput {
    /// Creates a new builder-style object to manufacture [`CreateGlobalNetworkOutput`](crate::output::CreateGlobalNetworkOutput)
    pub fn builder() -> crate::output::create_global_network_output::Builder {
        crate::output::create_global_network_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeviceOutput {
    /// <p>Information about the device.</p>
    pub device: std::option::Option<crate::model::Device>,
}
impl std::fmt::Debug for CreateDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeviceOutput");
        formatter.field("device", &self.device);
        formatter.finish()
    }
}
/// See [`CreateDeviceOutput`](crate::output::CreateDeviceOutput)
pub mod create_device_output {
    /// A builder for [`CreateDeviceOutput`](crate::output::CreateDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device: std::option::Option<crate::model::Device>,
    }
    impl Builder {
        /// <p>Information about the device.</p>
        pub fn device(mut self, input: crate::model::Device) -> Self {
            self.device = Some(input);
            self
        }
        /// <p>Information about the device.</p>
        pub fn set_device(mut self, input: std::option::Option<crate::model::Device>) -> Self {
            self.device = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeviceOutput`](crate::output::CreateDeviceOutput)
        pub fn build(self) -> crate::output::CreateDeviceOutput {
            crate::output::CreateDeviceOutput {
                device: self.device,
            }
        }
    }
}
impl CreateDeviceOutput {
    /// Creates a new builder-style object to manufacture [`CreateDeviceOutput`](crate::output::CreateDeviceOutput)
    pub fn builder() -> crate::output::create_device_output::Builder {
        crate::output::create_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectionOutput {
    /// <p>Information about the connection.</p>
    pub connection: std::option::Option<crate::model::Connection>,
}
impl std::fmt::Debug for CreateConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectionOutput");
        formatter.field("connection", &self.connection);
        formatter.finish()
    }
}
/// See [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
pub mod create_connection_output {
    /// A builder for [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection: std::option::Option<crate::model::Connection>,
    }
    impl Builder {
        /// <p>Information about the connection.</p>
        pub fn connection(mut self, input: crate::model::Connection) -> Self {
            self.connection = Some(input);
            self
        }
        /// <p>Information about the connection.</p>
        pub fn set_connection(
            mut self,
            input: std::option::Option<crate::model::Connection>,
        ) -> Self {
            self.connection = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
        pub fn build(self) -> crate::output::CreateConnectionOutput {
            crate::output::CreateConnectionOutput {
                connection: self.connection,
            }
        }
    }
}
impl CreateConnectionOutput {
    /// Creates a new builder-style object to manufacture [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
    pub fn builder() -> crate::output::create_connection_output::Builder {
        crate::output::create_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateTransitGatewayConnectPeerOutput {
    /// <p>The transit gateway Connect peer association.</p>
    pub transit_gateway_connect_peer_association:
        std::option::Option<crate::model::TransitGatewayConnectPeerAssociation>,
}
impl std::fmt::Debug for AssociateTransitGatewayConnectPeerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateTransitGatewayConnectPeerOutput");
        formatter.field(
            "transit_gateway_connect_peer_association",
            &self.transit_gateway_connect_peer_association,
        );
        formatter.finish()
    }
}
/// See [`AssociateTransitGatewayConnectPeerOutput`](crate::output::AssociateTransitGatewayConnectPeerOutput)
pub mod associate_transit_gateway_connect_peer_output {
    /// A builder for [`AssociateTransitGatewayConnectPeerOutput`](crate::output::AssociateTransitGatewayConnectPeerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_connect_peer_association:
            std::option::Option<crate::model::TransitGatewayConnectPeerAssociation>,
    }
    impl Builder {
        /// <p>The transit gateway Connect peer association.</p>
        pub fn transit_gateway_connect_peer_association(
            mut self,
            input: crate::model::TransitGatewayConnectPeerAssociation,
        ) -> Self {
            self.transit_gateway_connect_peer_association = Some(input);
            self
        }
        /// <p>The transit gateway Connect peer association.</p>
        pub fn set_transit_gateway_connect_peer_association(
            mut self,
            input: std::option::Option<crate::model::TransitGatewayConnectPeerAssociation>,
        ) -> Self {
            self.transit_gateway_connect_peer_association = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateTransitGatewayConnectPeerOutput`](crate::output::AssociateTransitGatewayConnectPeerOutput)
        pub fn build(self) -> crate::output::AssociateTransitGatewayConnectPeerOutput {
            crate::output::AssociateTransitGatewayConnectPeerOutput {
                transit_gateway_connect_peer_association: self
                    .transit_gateway_connect_peer_association,
            }
        }
    }
}
impl AssociateTransitGatewayConnectPeerOutput {
    /// Creates a new builder-style object to manufacture [`AssociateTransitGatewayConnectPeerOutput`](crate::output::AssociateTransitGatewayConnectPeerOutput)
    pub fn builder() -> crate::output::associate_transit_gateway_connect_peer_output::Builder {
        crate::output::associate_transit_gateway_connect_peer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateLinkOutput {
    /// <p>The link association.</p>
    pub link_association: std::option::Option<crate::model::LinkAssociation>,
}
impl std::fmt::Debug for AssociateLinkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateLinkOutput");
        formatter.field("link_association", &self.link_association);
        formatter.finish()
    }
}
/// See [`AssociateLinkOutput`](crate::output::AssociateLinkOutput)
pub mod associate_link_output {
    /// A builder for [`AssociateLinkOutput`](crate::output::AssociateLinkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) link_association: std::option::Option<crate::model::LinkAssociation>,
    }
    impl Builder {
        /// <p>The link association.</p>
        pub fn link_association(mut self, input: crate::model::LinkAssociation) -> Self {
            self.link_association = Some(input);
            self
        }
        /// <p>The link association.</p>
        pub fn set_link_association(
            mut self,
            input: std::option::Option<crate::model::LinkAssociation>,
        ) -> Self {
            self.link_association = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateLinkOutput`](crate::output::AssociateLinkOutput)
        pub fn build(self) -> crate::output::AssociateLinkOutput {
            crate::output::AssociateLinkOutput {
                link_association: self.link_association,
            }
        }
    }
}
impl AssociateLinkOutput {
    /// Creates a new builder-style object to manufacture [`AssociateLinkOutput`](crate::output::AssociateLinkOutput)
    pub fn builder() -> crate::output::associate_link_output::Builder {
        crate::output::associate_link_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateCustomerGatewayOutput {
    /// <p>The customer gateway association.</p>
    pub customer_gateway_association: std::option::Option<crate::model::CustomerGatewayAssociation>,
}
impl std::fmt::Debug for AssociateCustomerGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateCustomerGatewayOutput");
        formatter.field(
            "customer_gateway_association",
            &self.customer_gateway_association,
        );
        formatter.finish()
    }
}
/// See [`AssociateCustomerGatewayOutput`](crate::output::AssociateCustomerGatewayOutput)
pub mod associate_customer_gateway_output {
    /// A builder for [`AssociateCustomerGatewayOutput`](crate::output::AssociateCustomerGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) customer_gateway_association:
            std::option::Option<crate::model::CustomerGatewayAssociation>,
    }
    impl Builder {
        /// <p>The customer gateway association.</p>
        pub fn customer_gateway_association(
            mut self,
            input: crate::model::CustomerGatewayAssociation,
        ) -> Self {
            self.customer_gateway_association = Some(input);
            self
        }
        /// <p>The customer gateway association.</p>
        pub fn set_customer_gateway_association(
            mut self,
            input: std::option::Option<crate::model::CustomerGatewayAssociation>,
        ) -> Self {
            self.customer_gateway_association = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateCustomerGatewayOutput`](crate::output::AssociateCustomerGatewayOutput)
        pub fn build(self) -> crate::output::AssociateCustomerGatewayOutput {
            crate::output::AssociateCustomerGatewayOutput {
                customer_gateway_association: self.customer_gateway_association,
            }
        }
    }
}
impl AssociateCustomerGatewayOutput {
    /// Creates a new builder-style object to manufacture [`AssociateCustomerGatewayOutput`](crate::output::AssociateCustomerGatewayOutput)
    pub fn builder() -> crate::output::associate_customer_gateway_output::Builder {
        crate::output::associate_customer_gateway_output::Builder::default()
    }
}
