// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateCustomerGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_customer_gateway`](crate::client::Client::associate_customer_gateway).
///
/// See [`crate::client::fluent_builders::AssociateCustomerGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateCustomerGateway {
    _private: (),
}
impl AssociateCustomerGateway {
    /// Creates a new builder-style object to manufacture [`AssociateCustomerGatewayInput`](crate::input::AssociateCustomerGatewayInput)
    pub fn builder() -> crate::input::associate_customer_gateway_input::Builder {
        crate::input::associate_customer_gateway_input::Builder::default()
    }
    /// Creates a new `AssociateCustomerGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateCustomerGateway {
    type Output = std::result::Result<
        crate::output::AssociateCustomerGatewayOutput,
        crate::error::AssociateCustomerGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_customer_gateway_error(response)
        } else {
            crate::operation_deser::parse_associate_customer_gateway_response(response)
        }
    }
}

/// Operation shape for `AssociateLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_link`](crate::client::Client::associate_link).
///
/// See [`crate::client::fluent_builders::AssociateLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateLink {
    _private: (),
}
impl AssociateLink {
    /// Creates a new builder-style object to manufacture [`AssociateLinkInput`](crate::input::AssociateLinkInput)
    pub fn builder() -> crate::input::associate_link_input::Builder {
        crate::input::associate_link_input::Builder::default()
    }
    /// Creates a new `AssociateLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateLink {
    type Output =
        std::result::Result<crate::output::AssociateLinkOutput, crate::error::AssociateLinkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_link_error(response)
        } else {
            crate::operation_deser::parse_associate_link_response(response)
        }
    }
}

/// Operation shape for `AssociateTransitGatewayConnectPeer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_transit_gateway_connect_peer`](crate::client::Client::associate_transit_gateway_connect_peer).
///
/// See [`crate::client::fluent_builders::AssociateTransitGatewayConnectPeer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateTransitGatewayConnectPeer {
    _private: (),
}
impl AssociateTransitGatewayConnectPeer {
    /// Creates a new builder-style object to manufacture [`AssociateTransitGatewayConnectPeerInput`](crate::input::AssociateTransitGatewayConnectPeerInput)
    pub fn builder() -> crate::input::associate_transit_gateway_connect_peer_input::Builder {
        crate::input::associate_transit_gateway_connect_peer_input::Builder::default()
    }
    /// Creates a new `AssociateTransitGatewayConnectPeer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateTransitGatewayConnectPeer {
    type Output = std::result::Result<
        crate::output::AssociateTransitGatewayConnectPeerOutput,
        crate::error::AssociateTransitGatewayConnectPeerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_transit_gateway_connect_peer_error(response)
        } else {
            crate::operation_deser::parse_associate_transit_gateway_connect_peer_response(response)
        }
    }
}

/// Operation shape for `CreateConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_connection`](crate::client::Client::create_connection).
///
/// See [`crate::client::fluent_builders::CreateConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConnection {
    _private: (),
}
impl CreateConnection {
    /// Creates a new builder-style object to manufacture [`CreateConnectionInput`](crate::input::CreateConnectionInput)
    pub fn builder() -> crate::input::create_connection_input::Builder {
        crate::input::create_connection_input::Builder::default()
    }
    /// Creates a new `CreateConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConnection {
    type Output = std::result::Result<
        crate::output::CreateConnectionOutput,
        crate::error::CreateConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_connection_error(response)
        } else {
            crate::operation_deser::parse_create_connection_response(response)
        }
    }
}

/// Operation shape for `CreateDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_device`](crate::client::Client::create_device).
///
/// See [`crate::client::fluent_builders::CreateDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDevice {
    _private: (),
}
impl CreateDevice {
    /// Creates a new builder-style object to manufacture [`CreateDeviceInput`](crate::input::CreateDeviceInput)
    pub fn builder() -> crate::input::create_device_input::Builder {
        crate::input::create_device_input::Builder::default()
    }
    /// Creates a new `CreateDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDevice {
    type Output =
        std::result::Result<crate::output::CreateDeviceOutput, crate::error::CreateDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_device_error(response)
        } else {
            crate::operation_deser::parse_create_device_response(response)
        }
    }
}

/// Operation shape for `CreateGlobalNetwork`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_global_network`](crate::client::Client::create_global_network).
///
/// See [`crate::client::fluent_builders::CreateGlobalNetwork`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGlobalNetwork {
    _private: (),
}
impl CreateGlobalNetwork {
    /// Creates a new builder-style object to manufacture [`CreateGlobalNetworkInput`](crate::input::CreateGlobalNetworkInput)
    pub fn builder() -> crate::input::create_global_network_input::Builder {
        crate::input::create_global_network_input::Builder::default()
    }
    /// Creates a new `CreateGlobalNetwork` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGlobalNetwork {
    type Output = std::result::Result<
        crate::output::CreateGlobalNetworkOutput,
        crate::error::CreateGlobalNetworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_global_network_error(response)
        } else {
            crate::operation_deser::parse_create_global_network_response(response)
        }
    }
}

/// Operation shape for `CreateLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_link`](crate::client::Client::create_link).
///
/// See [`crate::client::fluent_builders::CreateLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLink {
    _private: (),
}
impl CreateLink {
    /// Creates a new builder-style object to manufacture [`CreateLinkInput`](crate::input::CreateLinkInput)
    pub fn builder() -> crate::input::create_link_input::Builder {
        crate::input::create_link_input::Builder::default()
    }
    /// Creates a new `CreateLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLink {
    type Output =
        std::result::Result<crate::output::CreateLinkOutput, crate::error::CreateLinkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_link_error(response)
        } else {
            crate::operation_deser::parse_create_link_response(response)
        }
    }
}

/// Operation shape for `CreateSite`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_site`](crate::client::Client::create_site).
///
/// See [`crate::client::fluent_builders::CreateSite`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSite {
    _private: (),
}
impl CreateSite {
    /// Creates a new builder-style object to manufacture [`CreateSiteInput`](crate::input::CreateSiteInput)
    pub fn builder() -> crate::input::create_site_input::Builder {
        crate::input::create_site_input::Builder::default()
    }
    /// Creates a new `CreateSite` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSite {
    type Output =
        std::result::Result<crate::output::CreateSiteOutput, crate::error::CreateSiteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_site_error(response)
        } else {
            crate::operation_deser::parse_create_site_response(response)
        }
    }
}

/// Operation shape for `DeleteConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_connection`](crate::client::Client::delete_connection).
///
/// See [`crate::client::fluent_builders::DeleteConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConnection {
    _private: (),
}
impl DeleteConnection {
    /// Creates a new builder-style object to manufacture [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
    pub fn builder() -> crate::input::delete_connection_input::Builder {
        crate::input::delete_connection_input::Builder::default()
    }
    /// Creates a new `DeleteConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConnection {
    type Output = std::result::Result<
        crate::output::DeleteConnectionOutput,
        crate::error::DeleteConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_connection_error(response)
        } else {
            crate::operation_deser::parse_delete_connection_response(response)
        }
    }
}

/// Operation shape for `DeleteDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_device`](crate::client::Client::delete_device).
///
/// See [`crate::client::fluent_builders::DeleteDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDevice {
    _private: (),
}
impl DeleteDevice {
    /// Creates a new builder-style object to manufacture [`DeleteDeviceInput`](crate::input::DeleteDeviceInput)
    pub fn builder() -> crate::input::delete_device_input::Builder {
        crate::input::delete_device_input::Builder::default()
    }
    /// Creates a new `DeleteDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDevice {
    type Output =
        std::result::Result<crate::output::DeleteDeviceOutput, crate::error::DeleteDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_device_error(response)
        } else {
            crate::operation_deser::parse_delete_device_response(response)
        }
    }
}

/// Operation shape for `DeleteGlobalNetwork`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_global_network`](crate::client::Client::delete_global_network).
///
/// See [`crate::client::fluent_builders::DeleteGlobalNetwork`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGlobalNetwork {
    _private: (),
}
impl DeleteGlobalNetwork {
    /// Creates a new builder-style object to manufacture [`DeleteGlobalNetworkInput`](crate::input::DeleteGlobalNetworkInput)
    pub fn builder() -> crate::input::delete_global_network_input::Builder {
        crate::input::delete_global_network_input::Builder::default()
    }
    /// Creates a new `DeleteGlobalNetwork` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGlobalNetwork {
    type Output = std::result::Result<
        crate::output::DeleteGlobalNetworkOutput,
        crate::error::DeleteGlobalNetworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_global_network_error(response)
        } else {
            crate::operation_deser::parse_delete_global_network_response(response)
        }
    }
}

/// Operation shape for `DeleteLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_link`](crate::client::Client::delete_link).
///
/// See [`crate::client::fluent_builders::DeleteLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLink {
    _private: (),
}
impl DeleteLink {
    /// Creates a new builder-style object to manufacture [`DeleteLinkInput`](crate::input::DeleteLinkInput)
    pub fn builder() -> crate::input::delete_link_input::Builder {
        crate::input::delete_link_input::Builder::default()
    }
    /// Creates a new `DeleteLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLink {
    type Output =
        std::result::Result<crate::output::DeleteLinkOutput, crate::error::DeleteLinkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_link_error(response)
        } else {
            crate::operation_deser::parse_delete_link_response(response)
        }
    }
}

/// Operation shape for `DeleteSite`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_site`](crate::client::Client::delete_site).
///
/// See [`crate::client::fluent_builders::DeleteSite`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSite {
    _private: (),
}
impl DeleteSite {
    /// Creates a new builder-style object to manufacture [`DeleteSiteInput`](crate::input::DeleteSiteInput)
    pub fn builder() -> crate::input::delete_site_input::Builder {
        crate::input::delete_site_input::Builder::default()
    }
    /// Creates a new `DeleteSite` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSite {
    type Output =
        std::result::Result<crate::output::DeleteSiteOutput, crate::error::DeleteSiteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_site_error(response)
        } else {
            crate::operation_deser::parse_delete_site_response(response)
        }
    }
}

/// Operation shape for `DeregisterTransitGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_transit_gateway`](crate::client::Client::deregister_transit_gateway).
///
/// See [`crate::client::fluent_builders::DeregisterTransitGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterTransitGateway {
    _private: (),
}
impl DeregisterTransitGateway {
    /// Creates a new builder-style object to manufacture [`DeregisterTransitGatewayInput`](crate::input::DeregisterTransitGatewayInput)
    pub fn builder() -> crate::input::deregister_transit_gateway_input::Builder {
        crate::input::deregister_transit_gateway_input::Builder::default()
    }
    /// Creates a new `DeregisterTransitGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterTransitGateway {
    type Output = std::result::Result<
        crate::output::DeregisterTransitGatewayOutput,
        crate::error::DeregisterTransitGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_transit_gateway_error(response)
        } else {
            crate::operation_deser::parse_deregister_transit_gateway_response(response)
        }
    }
}

/// Operation shape for `DescribeGlobalNetworks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_global_networks`](crate::client::Client::describe_global_networks).
///
/// See [`crate::client::fluent_builders::DescribeGlobalNetworks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGlobalNetworks {
    _private: (),
}
impl DescribeGlobalNetworks {
    /// Creates a new builder-style object to manufacture [`DescribeGlobalNetworksInput`](crate::input::DescribeGlobalNetworksInput)
    pub fn builder() -> crate::input::describe_global_networks_input::Builder {
        crate::input::describe_global_networks_input::Builder::default()
    }
    /// Creates a new `DescribeGlobalNetworks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGlobalNetworks {
    type Output = std::result::Result<
        crate::output::DescribeGlobalNetworksOutput,
        crate::error::DescribeGlobalNetworksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_global_networks_error(response)
        } else {
            crate::operation_deser::parse_describe_global_networks_response(response)
        }
    }
}

/// Operation shape for `DisassociateCustomerGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_customer_gateway`](crate::client::Client::disassociate_customer_gateway).
///
/// See [`crate::client::fluent_builders::DisassociateCustomerGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateCustomerGateway {
    _private: (),
}
impl DisassociateCustomerGateway {
    /// Creates a new builder-style object to manufacture [`DisassociateCustomerGatewayInput`](crate::input::DisassociateCustomerGatewayInput)
    pub fn builder() -> crate::input::disassociate_customer_gateway_input::Builder {
        crate::input::disassociate_customer_gateway_input::Builder::default()
    }
    /// Creates a new `DisassociateCustomerGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateCustomerGateway {
    type Output = std::result::Result<
        crate::output::DisassociateCustomerGatewayOutput,
        crate::error::DisassociateCustomerGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_customer_gateway_error(response)
        } else {
            crate::operation_deser::parse_disassociate_customer_gateway_response(response)
        }
    }
}

/// Operation shape for `DisassociateLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_link`](crate::client::Client::disassociate_link).
///
/// See [`crate::client::fluent_builders::DisassociateLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateLink {
    _private: (),
}
impl DisassociateLink {
    /// Creates a new builder-style object to manufacture [`DisassociateLinkInput`](crate::input::DisassociateLinkInput)
    pub fn builder() -> crate::input::disassociate_link_input::Builder {
        crate::input::disassociate_link_input::Builder::default()
    }
    /// Creates a new `DisassociateLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateLink {
    type Output = std::result::Result<
        crate::output::DisassociateLinkOutput,
        crate::error::DisassociateLinkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_link_error(response)
        } else {
            crate::operation_deser::parse_disassociate_link_response(response)
        }
    }
}

/// Operation shape for `DisassociateTransitGatewayConnectPeer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_transit_gateway_connect_peer`](crate::client::Client::disassociate_transit_gateway_connect_peer).
///
/// See [`crate::client::fluent_builders::DisassociateTransitGatewayConnectPeer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateTransitGatewayConnectPeer {
    _private: (),
}
impl DisassociateTransitGatewayConnectPeer {
    /// Creates a new builder-style object to manufacture [`DisassociateTransitGatewayConnectPeerInput`](crate::input::DisassociateTransitGatewayConnectPeerInput)
    pub fn builder() -> crate::input::disassociate_transit_gateway_connect_peer_input::Builder {
        crate::input::disassociate_transit_gateway_connect_peer_input::Builder::default()
    }
    /// Creates a new `DisassociateTransitGatewayConnectPeer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateTransitGatewayConnectPeer {
    type Output = std::result::Result<
        crate::output::DisassociateTransitGatewayConnectPeerOutput,
        crate::error::DisassociateTransitGatewayConnectPeerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_transit_gateway_connect_peer_error(response)
        } else {
            crate::operation_deser::parse_disassociate_transit_gateway_connect_peer_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_connections`](crate::client::Client::get_connections).
///
/// See [`crate::client::fluent_builders::GetConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConnections {
    _private: (),
}
impl GetConnections {
    /// Creates a new builder-style object to manufacture [`GetConnectionsInput`](crate::input::GetConnectionsInput)
    pub fn builder() -> crate::input::get_connections_input::Builder {
        crate::input::get_connections_input::Builder::default()
    }
    /// Creates a new `GetConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConnections {
    type Output =
        std::result::Result<crate::output::GetConnectionsOutput, crate::error::GetConnectionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_connections_error(response)
        } else {
            crate::operation_deser::parse_get_connections_response(response)
        }
    }
}

/// Operation shape for `GetCustomerGatewayAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_customer_gateway_associations`](crate::client::Client::get_customer_gateway_associations).
///
/// See [`crate::client::fluent_builders::GetCustomerGatewayAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCustomerGatewayAssociations {
    _private: (),
}
impl GetCustomerGatewayAssociations {
    /// Creates a new builder-style object to manufacture [`GetCustomerGatewayAssociationsInput`](crate::input::GetCustomerGatewayAssociationsInput)
    pub fn builder() -> crate::input::get_customer_gateway_associations_input::Builder {
        crate::input::get_customer_gateway_associations_input::Builder::default()
    }
    /// Creates a new `GetCustomerGatewayAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCustomerGatewayAssociations {
    type Output = std::result::Result<
        crate::output::GetCustomerGatewayAssociationsOutput,
        crate::error::GetCustomerGatewayAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_customer_gateway_associations_error(response)
        } else {
            crate::operation_deser::parse_get_customer_gateway_associations_response(response)
        }
    }
}

/// Operation shape for `GetDevices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_devices`](crate::client::Client::get_devices).
///
/// See [`crate::client::fluent_builders::GetDevices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDevices {
    _private: (),
}
impl GetDevices {
    /// Creates a new builder-style object to manufacture [`GetDevicesInput`](crate::input::GetDevicesInput)
    pub fn builder() -> crate::input::get_devices_input::Builder {
        crate::input::get_devices_input::Builder::default()
    }
    /// Creates a new `GetDevices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDevices {
    type Output =
        std::result::Result<crate::output::GetDevicesOutput, crate::error::GetDevicesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_devices_error(response)
        } else {
            crate::operation_deser::parse_get_devices_response(response)
        }
    }
}

/// Operation shape for `GetLinkAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_link_associations`](crate::client::Client::get_link_associations).
///
/// See [`crate::client::fluent_builders::GetLinkAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLinkAssociations {
    _private: (),
}
impl GetLinkAssociations {
    /// Creates a new builder-style object to manufacture [`GetLinkAssociationsInput`](crate::input::GetLinkAssociationsInput)
    pub fn builder() -> crate::input::get_link_associations_input::Builder {
        crate::input::get_link_associations_input::Builder::default()
    }
    /// Creates a new `GetLinkAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLinkAssociations {
    type Output = std::result::Result<
        crate::output::GetLinkAssociationsOutput,
        crate::error::GetLinkAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_link_associations_error(response)
        } else {
            crate::operation_deser::parse_get_link_associations_response(response)
        }
    }
}

/// Operation shape for `GetLinks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_links`](crate::client::Client::get_links).
///
/// See [`crate::client::fluent_builders::GetLinks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLinks {
    _private: (),
}
impl GetLinks {
    /// Creates a new builder-style object to manufacture [`GetLinksInput`](crate::input::GetLinksInput)
    pub fn builder() -> crate::input::get_links_input::Builder {
        crate::input::get_links_input::Builder::default()
    }
    /// Creates a new `GetLinks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLinks {
    type Output = std::result::Result<crate::output::GetLinksOutput, crate::error::GetLinksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_links_error(response)
        } else {
            crate::operation_deser::parse_get_links_response(response)
        }
    }
}

/// Operation shape for `GetSites`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_sites`](crate::client::Client::get_sites).
///
/// See [`crate::client::fluent_builders::GetSites`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSites {
    _private: (),
}
impl GetSites {
    /// Creates a new builder-style object to manufacture [`GetSitesInput`](crate::input::GetSitesInput)
    pub fn builder() -> crate::input::get_sites_input::Builder {
        crate::input::get_sites_input::Builder::default()
    }
    /// Creates a new `GetSites` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSites {
    type Output = std::result::Result<crate::output::GetSitesOutput, crate::error::GetSitesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_sites_error(response)
        } else {
            crate::operation_deser::parse_get_sites_response(response)
        }
    }
}

/// Operation shape for `GetTransitGatewayConnectPeerAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_transit_gateway_connect_peer_associations`](crate::client::Client::get_transit_gateway_connect_peer_associations).
///
/// See [`crate::client::fluent_builders::GetTransitGatewayConnectPeerAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTransitGatewayConnectPeerAssociations {
    _private: (),
}
impl GetTransitGatewayConnectPeerAssociations {
    /// Creates a new builder-style object to manufacture [`GetTransitGatewayConnectPeerAssociationsInput`](crate::input::GetTransitGatewayConnectPeerAssociationsInput)
    pub fn builder() -> crate::input::get_transit_gateway_connect_peer_associations_input::Builder {
        crate::input::get_transit_gateway_connect_peer_associations_input::Builder::default()
    }
    /// Creates a new `GetTransitGatewayConnectPeerAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTransitGatewayConnectPeerAssociations {
    type Output = std::result::Result<
        crate::output::GetTransitGatewayConnectPeerAssociationsOutput,
        crate::error::GetTransitGatewayConnectPeerAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_transit_gateway_connect_peer_associations_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_transit_gateway_connect_peer_associations_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetTransitGatewayRegistrations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_transit_gateway_registrations`](crate::client::Client::get_transit_gateway_registrations).
///
/// See [`crate::client::fluent_builders::GetTransitGatewayRegistrations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTransitGatewayRegistrations {
    _private: (),
}
impl GetTransitGatewayRegistrations {
    /// Creates a new builder-style object to manufacture [`GetTransitGatewayRegistrationsInput`](crate::input::GetTransitGatewayRegistrationsInput)
    pub fn builder() -> crate::input::get_transit_gateway_registrations_input::Builder {
        crate::input::get_transit_gateway_registrations_input::Builder::default()
    }
    /// Creates a new `GetTransitGatewayRegistrations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTransitGatewayRegistrations {
    type Output = std::result::Result<
        crate::output::GetTransitGatewayRegistrationsOutput,
        crate::error::GetTransitGatewayRegistrationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_transit_gateway_registrations_error(response)
        } else {
            crate::operation_deser::parse_get_transit_gateway_registrations_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `RegisterTransitGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_transit_gateway`](crate::client::Client::register_transit_gateway).
///
/// See [`crate::client::fluent_builders::RegisterTransitGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterTransitGateway {
    _private: (),
}
impl RegisterTransitGateway {
    /// Creates a new builder-style object to manufacture [`RegisterTransitGatewayInput`](crate::input::RegisterTransitGatewayInput)
    pub fn builder() -> crate::input::register_transit_gateway_input::Builder {
        crate::input::register_transit_gateway_input::Builder::default()
    }
    /// Creates a new `RegisterTransitGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterTransitGateway {
    type Output = std::result::Result<
        crate::output::RegisterTransitGatewayOutput,
        crate::error::RegisterTransitGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_transit_gateway_error(response)
        } else {
            crate::operation_deser::parse_register_transit_gateway_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_connection`](crate::client::Client::update_connection).
///
/// See [`crate::client::fluent_builders::UpdateConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateConnection {
    _private: (),
}
impl UpdateConnection {
    /// Creates a new builder-style object to manufacture [`UpdateConnectionInput`](crate::input::UpdateConnectionInput)
    pub fn builder() -> crate::input::update_connection_input::Builder {
        crate::input::update_connection_input::Builder::default()
    }
    /// Creates a new `UpdateConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateConnection {
    type Output = std::result::Result<
        crate::output::UpdateConnectionOutput,
        crate::error::UpdateConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_connection_error(response)
        } else {
            crate::operation_deser::parse_update_connection_response(response)
        }
    }
}

/// Operation shape for `UpdateDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_device`](crate::client::Client::update_device).
///
/// See [`crate::client::fluent_builders::UpdateDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDevice {
    _private: (),
}
impl UpdateDevice {
    /// Creates a new builder-style object to manufacture [`UpdateDeviceInput`](crate::input::UpdateDeviceInput)
    pub fn builder() -> crate::input::update_device_input::Builder {
        crate::input::update_device_input::Builder::default()
    }
    /// Creates a new `UpdateDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDevice {
    type Output =
        std::result::Result<crate::output::UpdateDeviceOutput, crate::error::UpdateDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_device_error(response)
        } else {
            crate::operation_deser::parse_update_device_response(response)
        }
    }
}

/// Operation shape for `UpdateGlobalNetwork`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_global_network`](crate::client::Client::update_global_network).
///
/// See [`crate::client::fluent_builders::UpdateGlobalNetwork`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGlobalNetwork {
    _private: (),
}
impl UpdateGlobalNetwork {
    /// Creates a new builder-style object to manufacture [`UpdateGlobalNetworkInput`](crate::input::UpdateGlobalNetworkInput)
    pub fn builder() -> crate::input::update_global_network_input::Builder {
        crate::input::update_global_network_input::Builder::default()
    }
    /// Creates a new `UpdateGlobalNetwork` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGlobalNetwork {
    type Output = std::result::Result<
        crate::output::UpdateGlobalNetworkOutput,
        crate::error::UpdateGlobalNetworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_global_network_error(response)
        } else {
            crate::operation_deser::parse_update_global_network_response(response)
        }
    }
}

/// Operation shape for `UpdateLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_link`](crate::client::Client::update_link).
///
/// See [`crate::client::fluent_builders::UpdateLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLink {
    _private: (),
}
impl UpdateLink {
    /// Creates a new builder-style object to manufacture [`UpdateLinkInput`](crate::input::UpdateLinkInput)
    pub fn builder() -> crate::input::update_link_input::Builder {
        crate::input::update_link_input::Builder::default()
    }
    /// Creates a new `UpdateLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLink {
    type Output =
        std::result::Result<crate::output::UpdateLinkOutput, crate::error::UpdateLinkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_link_error(response)
        } else {
            crate::operation_deser::parse_update_link_response(response)
        }
    }
}

/// Operation shape for `UpdateSite`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_site`](crate::client::Client::update_site).
///
/// See [`crate::client::fluent_builders::UpdateSite`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSite {
    _private: (),
}
impl UpdateSite {
    /// Creates a new builder-style object to manufacture [`UpdateSiteInput`](crate::input::UpdateSiteInput)
    pub fn builder() -> crate::input::update_site_input::Builder {
        crate::input::update_site_input::Builder::default()
    }
    /// Creates a new `UpdateSite` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSite {
    type Output =
        std::result::Result<crate::output::UpdateSiteOutput, crate::error::UpdateSiteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_site_error(response)
        } else {
            crate::operation_deser::parse_update_site_response(response)
        }
    }
}
