// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Describes a validation exception for a field.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>The name of the field.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The message for the field.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the field.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the field.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The message for the field.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the field.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "CannotParse" => ValidationExceptionReason::CannotParse,
            "FieldValidationFailed" => ValidationExceptionReason::FieldValidationFailed,
            "Other" => ValidationExceptionReason::Other,
            "UnknownOperation" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "CannotParse",
            ValidationExceptionReason::FieldValidationFailed => "FieldValidationFailed",
            ValidationExceptionReason::Other => "Other",
            ValidationExceptionReason::UnknownOperation => "UnknownOperation",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CannotParse",
            "FieldValidationFailed",
            "Other",
            "UnknownOperation",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a site.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Site {
    /// <p>The ID of the site.</p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the site.</p>
    pub site_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The description of the site.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The location of the site.</p>
    pub location: std::option::Option<crate::model::Location>,
    /// <p>The date and time that the site was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The state of the site.</p>
    pub state: std::option::Option<crate::model::SiteState>,
    /// <p>The tags for the site.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for Site {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Site");
        formatter.field("site_id", &self.site_id);
        formatter.field("site_arn", &self.site_arn);
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("description", &self.description);
        formatter.field("location", &"*** Sensitive Data Redacted ***");
        formatter.field("created_at", &self.created_at);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Site`](crate::model::Site)
pub mod site {
    /// A builder for [`Site`](crate::model::Site)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) site_arn: std::option::Option<std::string::String>,
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::Location>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) state: std::option::Option<crate::model::SiteState>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the site.</p>
        pub fn site_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the site.</p>
        pub fn set_site_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_arn = input;
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The description of the site.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the site.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The location of the site.</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The location of the site.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.location = input;
            self
        }
        /// <p>The date and time that the site was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the site was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The state of the site.</p>
        pub fn state(mut self, input: crate::model::SiteState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the site.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::SiteState>) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the site.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the site.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Site`](crate::model::Site)
        pub fn build(self) -> crate::model::Site {
            crate::model::Site {
                site_id: self.site_id,
                site_arn: self.site_arn,
                global_network_id: self.global_network_id,
                description: self.description,
                location: self.location,
                created_at: self.created_at,
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl Site {
    /// Creates a new builder-style object to manufacture [`Site`](crate::model::Site)
    pub fn builder() -> crate::model::site::Builder {
        crate::model::site::Builder::default()
    }
}

/// <p>Describes a tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The tag key.</p>
    /// <p>Length Constraints: Maximum length of 128 characters.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag value.</p>
    /// <p>Length Constraints: Maximum length of 256 characters.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The tag key.</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag key.</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag value.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag value.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SiteState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SiteState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => SiteState::Available,
            "DELETING" => SiteState::Deleting,
            "PENDING" => SiteState::Pending,
            "UPDATING" => SiteState::Updating,
            other => SiteState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SiteState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SiteState::from(s))
    }
}
impl SiteState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SiteState::Available => "AVAILABLE",
            SiteState::Deleting => "DELETING",
            SiteState::Pending => "PENDING",
            SiteState::Updating => "UPDATING",
            SiteState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETING", "PENDING", "UPDATING"]
    }
}
impl AsRef<str> for SiteState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a location.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Location {
    /// <p>The physical address.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The latitude.</p>
    pub latitude: std::option::Option<std::string::String>,
    /// <p>The longitude.</p>
    pub longitude: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Location");
        formatter.field("address", &self.address);
        formatter.field("latitude", &self.latitude);
        formatter.field("longitude", &self.longitude);
        formatter.finish()
    }
}
/// See [`Location`](crate::model::Location)
pub mod location {
    /// A builder for [`Location`](crate::model::Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) latitude: std::option::Option<std::string::String>,
        pub(crate) longitude: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The physical address.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The physical address.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>The latitude.</p>
        pub fn latitude(mut self, input: impl Into<std::string::String>) -> Self {
            self.latitude = Some(input.into());
            self
        }
        /// <p>The latitude.</p>
        pub fn set_latitude(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.latitude = input;
            self
        }
        /// <p>The longitude.</p>
        pub fn longitude(mut self, input: impl Into<std::string::String>) -> Self {
            self.longitude = Some(input.into());
            self
        }
        /// <p>The longitude.</p>
        pub fn set_longitude(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.longitude = input;
            self
        }
        /// Consumes the builder and constructs a [`Location`](crate::model::Location)
        pub fn build(self) -> crate::model::Location {
            crate::model::Location {
                address: self.address,
                latitude: self.latitude,
                longitude: self.longitude,
            }
        }
    }
}
impl Location {
    /// Creates a new builder-style object to manufacture [`Location`](crate::model::Location)
    pub fn builder() -> crate::model::location::Builder {
        crate::model::location::Builder::default()
    }
}

/// <p>Describes a link.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Link {
    /// <p>The ID of the link.</p>
    pub link_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the link.</p>
    pub link_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the site.</p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p>The description of the link.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of the link.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The bandwidth for the link.</p>
    pub bandwidth: std::option::Option<crate::model::Bandwidth>,
    /// <p>The provider of the link.</p>
    pub provider: std::option::Option<std::string::String>,
    /// <p>The date and time that the link was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The state of the link.</p>
    pub state: std::option::Option<crate::model::LinkState>,
    /// <p>The tags for the link.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for Link {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Link");
        formatter.field("link_id", &self.link_id);
        formatter.field("link_arn", &self.link_arn);
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("site_id", &self.site_id);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("provider", &self.provider);
        formatter.field("created_at", &self.created_at);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Link`](crate::model::Link)
pub mod link {
    /// A builder for [`Link`](crate::model::Link)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) link_id: std::option::Option<std::string::String>,
        pub(crate) link_arn: std::option::Option<std::string::String>,
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) bandwidth: std::option::Option<crate::model::Bandwidth>,
        pub(crate) provider: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) state: std::option::Option<crate::model::LinkState>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the link.</p>
        pub fn link_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the link.</p>
        pub fn set_link_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_arn = input;
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// <p>The description of the link.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the link.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of the link.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the link.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The bandwidth for the link.</p>
        pub fn bandwidth(mut self, input: crate::model::Bandwidth) -> Self {
            self.bandwidth = Some(input);
            self
        }
        /// <p>The bandwidth for the link.</p>
        pub fn set_bandwidth(
            mut self,
            input: std::option::Option<crate::model::Bandwidth>,
        ) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>The provider of the link.</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider = Some(input.into());
            self
        }
        /// <p>The provider of the link.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.provider = input;
            self
        }
        /// <p>The date and time that the link was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the link was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The state of the link.</p>
        pub fn state(mut self, input: crate::model::LinkState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the link.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::LinkState>) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the link.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the link.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Link`](crate::model::Link)
        pub fn build(self) -> crate::model::Link {
            crate::model::Link {
                link_id: self.link_id,
                link_arn: self.link_arn,
                global_network_id: self.global_network_id,
                site_id: self.site_id,
                description: self.description,
                r#type: self.r#type,
                bandwidth: self.bandwidth,
                provider: self.provider,
                created_at: self.created_at,
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl Link {
    /// Creates a new builder-style object to manufacture [`Link`](crate::model::Link)
    pub fn builder() -> crate::model::link::Builder {
        crate::model::link::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LinkState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LinkState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => LinkState::Available,
            "DELETING" => LinkState::Deleting,
            "PENDING" => LinkState::Pending,
            "UPDATING" => LinkState::Updating,
            other => LinkState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LinkState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LinkState::from(s))
    }
}
impl LinkState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LinkState::Available => "AVAILABLE",
            LinkState::Deleting => "DELETING",
            LinkState::Pending => "PENDING",
            LinkState::Updating => "UPDATING",
            LinkState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETING", "PENDING", "UPDATING"]
    }
}
impl AsRef<str> for LinkState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes bandwidth information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Bandwidth {
    /// <p>Upload speed in Mbps.</p>
    pub upload_speed: std::option::Option<i32>,
    /// <p>Download speed in Mbps.</p>
    pub download_speed: std::option::Option<i32>,
}
impl std::fmt::Debug for Bandwidth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Bandwidth");
        formatter.field("upload_speed", &self.upload_speed);
        formatter.field("download_speed", &self.download_speed);
        formatter.finish()
    }
}
/// See [`Bandwidth`](crate::model::Bandwidth)
pub mod bandwidth {
    /// A builder for [`Bandwidth`](crate::model::Bandwidth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upload_speed: std::option::Option<i32>,
        pub(crate) download_speed: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Upload speed in Mbps.</p>
        pub fn upload_speed(mut self, input: i32) -> Self {
            self.upload_speed = Some(input);
            self
        }
        /// <p>Upload speed in Mbps.</p>
        pub fn set_upload_speed(mut self, input: std::option::Option<i32>) -> Self {
            self.upload_speed = input;
            self
        }
        /// <p>Download speed in Mbps.</p>
        pub fn download_speed(mut self, input: i32) -> Self {
            self.download_speed = Some(input);
            self
        }
        /// <p>Download speed in Mbps.</p>
        pub fn set_download_speed(mut self, input: std::option::Option<i32>) -> Self {
            self.download_speed = input;
            self
        }
        /// Consumes the builder and constructs a [`Bandwidth`](crate::model::Bandwidth)
        pub fn build(self) -> crate::model::Bandwidth {
            crate::model::Bandwidth {
                upload_speed: self.upload_speed,
                download_speed: self.download_speed,
            }
        }
    }
}
impl Bandwidth {
    /// Creates a new builder-style object to manufacture [`Bandwidth`](crate::model::Bandwidth)
    pub fn builder() -> crate::model::bandwidth::Builder {
        crate::model::bandwidth::Builder::default()
    }
}

/// <p>Describes a global network.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalNetwork {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the global network.</p>
    pub global_network_arn: std::option::Option<std::string::String>,
    /// <p>The description of the global network.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time that the global network was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The state of the global network.</p>
    pub state: std::option::Option<crate::model::GlobalNetworkState>,
    /// <p>The tags for the global network.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for GlobalNetwork {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalNetwork");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("global_network_arn", &self.global_network_arn);
        formatter.field("description", &self.description);
        formatter.field("created_at", &self.created_at);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GlobalNetwork`](crate::model::GlobalNetwork)
pub mod global_network {
    /// A builder for [`GlobalNetwork`](crate::model::GlobalNetwork)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) global_network_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) state: std::option::Option<crate::model::GlobalNetworkState>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the global network.</p>
        pub fn global_network_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the global network.</p>
        pub fn set_global_network_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_arn = input;
            self
        }
        /// <p>The description of the global network.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the global network.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time that the global network was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the global network was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The state of the global network.</p>
        pub fn state(mut self, input: crate::model::GlobalNetworkState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the global network.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::GlobalNetworkState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the global network.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the global network.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalNetwork`](crate::model::GlobalNetwork)
        pub fn build(self) -> crate::model::GlobalNetwork {
            crate::model::GlobalNetwork {
                global_network_id: self.global_network_id,
                global_network_arn: self.global_network_arn,
                description: self.description,
                created_at: self.created_at,
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl GlobalNetwork {
    /// Creates a new builder-style object to manufacture [`GlobalNetwork`](crate::model::GlobalNetwork)
    pub fn builder() -> crate::model::global_network::Builder {
        crate::model::global_network::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GlobalNetworkState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GlobalNetworkState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => GlobalNetworkState::Available,
            "DELETING" => GlobalNetworkState::Deleting,
            "PENDING" => GlobalNetworkState::Pending,
            "UPDATING" => GlobalNetworkState::Updating,
            other => GlobalNetworkState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GlobalNetworkState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GlobalNetworkState::from(s))
    }
}
impl GlobalNetworkState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GlobalNetworkState::Available => "AVAILABLE",
            GlobalNetworkState::Deleting => "DELETING",
            GlobalNetworkState::Pending => "PENDING",
            GlobalNetworkState::Updating => "UPDATING",
            GlobalNetworkState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETING", "PENDING", "UPDATING"]
    }
}
impl AsRef<str> for GlobalNetworkState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Device {
    /// <p>The ID of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the device.</p>
    pub device_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The AWS location of the device.</p>
    pub aws_location: std::option::Option<crate::model::AwsLocation>,
    /// <p>The description of the device.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The device type.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The device vendor.</p>
    pub vendor: std::option::Option<std::string::String>,
    /// <p>The device model.</p>
    pub model: std::option::Option<std::string::String>,
    /// <p>The device serial number.</p>
    pub serial_number: std::option::Option<std::string::String>,
    /// <p>The site location.</p>
    pub location: std::option::Option<crate::model::Location>,
    /// <p>The site ID.</p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p>The date and time that the site was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The device state.</p>
    pub state: std::option::Option<crate::model::DeviceState>,
    /// <p>The tags for the device.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for Device {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Device");
        formatter.field("device_id", &self.device_id);
        formatter.field("device_arn", &self.device_arn);
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("aws_location", &self.aws_location);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("vendor", &self.vendor);
        formatter.field("model", &self.model);
        formatter.field("serial_number", &self.serial_number);
        formatter.field("location", &"*** Sensitive Data Redacted ***");
        formatter.field("site_id", &self.site_id);
        formatter.field("created_at", &self.created_at);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Device`](crate::model::Device)
pub mod device {
    /// A builder for [`Device`](crate::model::Device)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) device_arn: std::option::Option<std::string::String>,
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) aws_location: std::option::Option<crate::model::AwsLocation>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) vendor: std::option::Option<std::string::String>,
        pub(crate) model: std::option::Option<std::string::String>,
        pub(crate) serial_number: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::Location>,
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) state: std::option::Option<crate::model::DeviceState>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the device.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the device.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_arn = input;
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The AWS location of the device.</p>
        pub fn aws_location(mut self, input: crate::model::AwsLocation) -> Self {
            self.aws_location = Some(input);
            self
        }
        /// <p>The AWS location of the device.</p>
        pub fn set_aws_location(
            mut self,
            input: std::option::Option<crate::model::AwsLocation>,
        ) -> Self {
            self.aws_location = input;
            self
        }
        /// <p>The description of the device.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the device.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The device type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The device type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The device vendor.</p>
        pub fn vendor(mut self, input: impl Into<std::string::String>) -> Self {
            self.vendor = Some(input.into());
            self
        }
        /// <p>The device vendor.</p>
        pub fn set_vendor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vendor = input;
            self
        }
        /// <p>The device model.</p>
        pub fn model(mut self, input: impl Into<std::string::String>) -> Self {
            self.model = Some(input.into());
            self
        }
        /// <p>The device model.</p>
        pub fn set_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model = input;
            self
        }
        /// <p>The device serial number.</p>
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.serial_number = Some(input.into());
            self
        }
        /// <p>The device serial number.</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.serial_number = input;
            self
        }
        /// <p>The site location.</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The site location.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.location = input;
            self
        }
        /// <p>The site ID.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p>The site ID.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// <p>The date and time that the site was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the site was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The device state.</p>
        pub fn state(mut self, input: crate::model::DeviceState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The device state.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::DeviceState>) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the device.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the device.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Device`](crate::model::Device)
        pub fn build(self) -> crate::model::Device {
            crate::model::Device {
                device_id: self.device_id,
                device_arn: self.device_arn,
                global_network_id: self.global_network_id,
                aws_location: self.aws_location,
                description: self.description,
                r#type: self.r#type,
                vendor: self.vendor,
                model: self.model,
                serial_number: self.serial_number,
                location: self.location,
                site_id: self.site_id,
                created_at: self.created_at,
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl Device {
    /// Creates a new builder-style object to manufacture [`Device`](crate::model::Device)
    pub fn builder() -> crate::model::device::Builder {
        crate::model::device::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => DeviceState::Available,
            "DELETING" => DeviceState::Deleting,
            "PENDING" => DeviceState::Pending,
            "UPDATING" => DeviceState::Updating,
            other => DeviceState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceState::from(s))
    }
}
impl DeviceState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceState::Available => "AVAILABLE",
            DeviceState::Deleting => "DELETING",
            DeviceState::Pending => "PENDING",
            DeviceState::Updating => "UPDATING",
            DeviceState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETING", "PENDING", "UPDATING"]
    }
}
impl AsRef<str> for DeviceState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies a location in AWS.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsLocation {
    /// <p>The Zone the device is located in. This can be the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.</p>
    pub zone: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the subnet the device is located in.</p>
    pub subnet_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsLocation");
        formatter.field("zone", &self.zone);
        formatter.field("subnet_arn", &self.subnet_arn);
        formatter.finish()
    }
}
/// See [`AwsLocation`](crate::model::AwsLocation)
pub mod aws_location {
    /// A builder for [`AwsLocation`](crate::model::AwsLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) zone: std::option::Option<std::string::String>,
        pub(crate) subnet_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Zone the device is located in. This can be the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.</p>
        pub fn zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.zone = Some(input.into());
            self
        }
        /// <p>The Zone the device is located in. This can be the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.</p>
        pub fn set_zone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.zone = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the subnet the device is located in.</p>
        pub fn subnet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the subnet the device is located in.</p>
        pub fn set_subnet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsLocation`](crate::model::AwsLocation)
        pub fn build(self) -> crate::model::AwsLocation {
            crate::model::AwsLocation {
                zone: self.zone,
                subnet_arn: self.subnet_arn,
            }
        }
    }
}
impl AwsLocation {
    /// Creates a new builder-style object to manufacture [`AwsLocation`](crate::model::AwsLocation)
    pub fn builder() -> crate::model::aws_location::Builder {
        crate::model::aws_location::Builder::default()
    }
}

/// <p>Describes a connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Connection {
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the connection.</p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the first device in the connection.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The ID of the second device in the connection.</p>
    pub connected_device_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link for the first device in the connection.</p>
    pub link_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link for the second device in the connection.</p>
    pub connected_link_id: std::option::Option<std::string::String>,
    /// <p>The description of the connection.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time that the connection was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The state of the connection.</p>
    pub state: std::option::Option<crate::model::ConnectionState>,
    /// <p>The tags for the connection.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for Connection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Connection");
        formatter.field("connection_id", &self.connection_id);
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("device_id", &self.device_id);
        formatter.field("connected_device_id", &self.connected_device_id);
        formatter.field("link_id", &self.link_id);
        formatter.field("connected_link_id", &self.connected_link_id);
        formatter.field("description", &self.description);
        formatter.field("created_at", &self.created_at);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Connection`](crate::model::Connection)
pub mod connection {
    /// A builder for [`Connection`](crate::model::Connection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) connected_device_id: std::option::Option<std::string::String>,
        pub(crate) link_id: std::option::Option<std::string::String>,
        pub(crate) connected_link_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) state: std::option::Option<crate::model::ConnectionState>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the connection.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the connection.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the first device in the connection.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the first device in the connection.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The ID of the second device in the connection.</p>
        pub fn connected_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connected_device_id = Some(input.into());
            self
        }
        /// <p>The ID of the second device in the connection.</p>
        pub fn set_connected_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connected_device_id = input;
            self
        }
        /// <p>The ID of the link for the first device in the connection.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link for the first device in the connection.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// <p>The ID of the link for the second device in the connection.</p>
        pub fn connected_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connected_link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link for the second device in the connection.</p>
        pub fn set_connected_link_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connected_link_id = input;
            self
        }
        /// <p>The description of the connection.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the connection.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time that the connection was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the connection was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The state of the connection.</p>
        pub fn state(mut self, input: crate::model::ConnectionState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the connection.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the connection.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the connection.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Connection`](crate::model::Connection)
        pub fn build(self) -> crate::model::Connection {
            crate::model::Connection {
                connection_id: self.connection_id,
                connection_arn: self.connection_arn,
                global_network_id: self.global_network_id,
                device_id: self.device_id,
                connected_device_id: self.connected_device_id,
                link_id: self.link_id,
                connected_link_id: self.connected_link_id,
                description: self.description,
                created_at: self.created_at,
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl Connection {
    /// Creates a new builder-style object to manufacture [`Connection`](crate::model::Connection)
    pub fn builder() -> crate::model::connection::Builder {
        crate::model::connection::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => ConnectionState::Available,
            "DELETING" => ConnectionState::Deleting,
            "PENDING" => ConnectionState::Pending,
            "UPDATING" => ConnectionState::Updating,
            other => ConnectionState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionState::from(s))
    }
}
impl ConnectionState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionState::Available => "AVAILABLE",
            ConnectionState::Deleting => "DELETING",
            ConnectionState::Pending => "PENDING",
            ConnectionState::Updating => "UPDATING",
            ConnectionState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETING", "PENDING", "UPDATING"]
    }
}
impl AsRef<str> for ConnectionState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the registration of a transit gateway to a global network.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransitGatewayRegistration {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
    pub transit_gateway_arn: std::option::Option<std::string::String>,
    /// <p>The state of the transit gateway registration.</p>
    pub state: std::option::Option<crate::model::TransitGatewayRegistrationStateReason>,
}
impl std::fmt::Debug for TransitGatewayRegistration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransitGatewayRegistration");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("transit_gateway_arn", &self.transit_gateway_arn);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`TransitGatewayRegistration`](crate::model::TransitGatewayRegistration)
pub mod transit_gateway_registration {
    /// A builder for [`TransitGatewayRegistration`](crate::model::TransitGatewayRegistration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::TransitGatewayRegistrationStateReason>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
        pub fn transit_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.transit_gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
        pub fn set_transit_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_arn = input;
            self
        }
        /// <p>The state of the transit gateway registration.</p>
        pub fn state(mut self, input: crate::model::TransitGatewayRegistrationStateReason) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the transit gateway registration.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::TransitGatewayRegistrationStateReason>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`TransitGatewayRegistration`](crate::model::TransitGatewayRegistration)
        pub fn build(self) -> crate::model::TransitGatewayRegistration {
            crate::model::TransitGatewayRegistration {
                global_network_id: self.global_network_id,
                transit_gateway_arn: self.transit_gateway_arn,
                state: self.state,
            }
        }
    }
}
impl TransitGatewayRegistration {
    /// Creates a new builder-style object to manufacture [`TransitGatewayRegistration`](crate::model::TransitGatewayRegistration)
    pub fn builder() -> crate::model::transit_gateway_registration::Builder {
        crate::model::transit_gateway_registration::Builder::default()
    }
}

/// <p>Describes the status of a transit gateway registration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransitGatewayRegistrationStateReason {
    /// <p>The code for the state reason.</p>
    pub code: std::option::Option<crate::model::TransitGatewayRegistrationState>,
    /// <p>The message for the state reason.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TransitGatewayRegistrationStateReason {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransitGatewayRegistrationStateReason");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`TransitGatewayRegistrationStateReason`](crate::model::TransitGatewayRegistrationStateReason)
pub mod transit_gateway_registration_state_reason {
    /// A builder for [`TransitGatewayRegistrationStateReason`](crate::model::TransitGatewayRegistrationStateReason)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::TransitGatewayRegistrationState>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The code for the state reason.</p>
        pub fn code(mut self, input: crate::model::TransitGatewayRegistrationState) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The code for the state reason.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::TransitGatewayRegistrationState>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>The message for the state reason.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the state reason.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TransitGatewayRegistrationStateReason`](crate::model::TransitGatewayRegistrationStateReason)
        pub fn build(self) -> crate::model::TransitGatewayRegistrationStateReason {
            crate::model::TransitGatewayRegistrationStateReason {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl TransitGatewayRegistrationStateReason {
    /// Creates a new builder-style object to manufacture [`TransitGatewayRegistrationStateReason`](crate::model::TransitGatewayRegistrationStateReason)
    pub fn builder() -> crate::model::transit_gateway_registration_state_reason::Builder {
        crate::model::transit_gateway_registration_state_reason::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransitGatewayRegistrationState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransitGatewayRegistrationState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => TransitGatewayRegistrationState::Available,
            "DELETED" => TransitGatewayRegistrationState::Deleted,
            "DELETING" => TransitGatewayRegistrationState::Deleting,
            "FAILED" => TransitGatewayRegistrationState::Failed,
            "PENDING" => TransitGatewayRegistrationState::Pending,
            other => TransitGatewayRegistrationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransitGatewayRegistrationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransitGatewayRegistrationState::from(s))
    }
}
impl TransitGatewayRegistrationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransitGatewayRegistrationState::Available => "AVAILABLE",
            TransitGatewayRegistrationState::Deleted => "DELETED",
            TransitGatewayRegistrationState::Deleting => "DELETING",
            TransitGatewayRegistrationState::Failed => "FAILED",
            TransitGatewayRegistrationState::Pending => "PENDING",
            TransitGatewayRegistrationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETED", "DELETING", "FAILED", "PENDING"]
    }
}
impl AsRef<str> for TransitGatewayRegistrationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a transit gateway Connect peer association.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransitGatewayConnectPeerAssociation {
    /// <p>The Amazon Resource Name (ARN) of the transit gateway Connect peer.</p>
    pub transit_gateway_connect_peer_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link.</p>
    pub link_id: std::option::Option<std::string::String>,
    /// <p>The state of the association.</p>
    pub state: std::option::Option<crate::model::TransitGatewayConnectPeerAssociationState>,
}
impl std::fmt::Debug for TransitGatewayConnectPeerAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransitGatewayConnectPeerAssociation");
        formatter.field(
            "transit_gateway_connect_peer_arn",
            &self.transit_gateway_connect_peer_arn,
        );
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("device_id", &self.device_id);
        formatter.field("link_id", &self.link_id);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`TransitGatewayConnectPeerAssociation`](crate::model::TransitGatewayConnectPeerAssociation)
pub mod transit_gateway_connect_peer_association {
    /// A builder for [`TransitGatewayConnectPeerAssociation`](crate::model::TransitGatewayConnectPeerAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_connect_peer_arn: std::option::Option<std::string::String>,
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) link_id: std::option::Option<std::string::String>,
        pub(crate) state:
            std::option::Option<crate::model::TransitGatewayConnectPeerAssociationState>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the transit gateway Connect peer.</p>
        pub fn transit_gateway_connect_peer_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.transit_gateway_connect_peer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway Connect peer.</p>
        pub fn set_transit_gateway_connect_peer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_connect_peer_arn = input;
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// <p>The state of the association.</p>
        pub fn state(
            mut self,
            input: crate::model::TransitGatewayConnectPeerAssociationState,
        ) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the association.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::TransitGatewayConnectPeerAssociationState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`TransitGatewayConnectPeerAssociation`](crate::model::TransitGatewayConnectPeerAssociation)
        pub fn build(self) -> crate::model::TransitGatewayConnectPeerAssociation {
            crate::model::TransitGatewayConnectPeerAssociation {
                transit_gateway_connect_peer_arn: self.transit_gateway_connect_peer_arn,
                global_network_id: self.global_network_id,
                device_id: self.device_id,
                link_id: self.link_id,
                state: self.state,
            }
        }
    }
}
impl TransitGatewayConnectPeerAssociation {
    /// Creates a new builder-style object to manufacture [`TransitGatewayConnectPeerAssociation`](crate::model::TransitGatewayConnectPeerAssociation)
    pub fn builder() -> crate::model::transit_gateway_connect_peer_association::Builder {
        crate::model::transit_gateway_connect_peer_association::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransitGatewayConnectPeerAssociationState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransitGatewayConnectPeerAssociationState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => TransitGatewayConnectPeerAssociationState::Available,
            "DELETED" => TransitGatewayConnectPeerAssociationState::Deleted,
            "DELETING" => TransitGatewayConnectPeerAssociationState::Deleting,
            "PENDING" => TransitGatewayConnectPeerAssociationState::Pending,
            other => TransitGatewayConnectPeerAssociationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransitGatewayConnectPeerAssociationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransitGatewayConnectPeerAssociationState::from(s))
    }
}
impl TransitGatewayConnectPeerAssociationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransitGatewayConnectPeerAssociationState::Available => "AVAILABLE",
            TransitGatewayConnectPeerAssociationState::Deleted => "DELETED",
            TransitGatewayConnectPeerAssociationState::Deleting => "DELETING",
            TransitGatewayConnectPeerAssociationState::Pending => "PENDING",
            TransitGatewayConnectPeerAssociationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETED", "DELETING", "PENDING"]
    }
}
impl AsRef<str> for TransitGatewayConnectPeerAssociationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the association between a device and a link.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LinkAssociation {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The device ID for the link association.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link.</p>
    pub link_id: std::option::Option<std::string::String>,
    /// <p>The state of the association.</p>
    pub link_association_state: std::option::Option<crate::model::LinkAssociationState>,
}
impl std::fmt::Debug for LinkAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LinkAssociation");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("device_id", &self.device_id);
        formatter.field("link_id", &self.link_id);
        formatter.field("link_association_state", &self.link_association_state);
        formatter.finish()
    }
}
/// See [`LinkAssociation`](crate::model::LinkAssociation)
pub mod link_association {
    /// A builder for [`LinkAssociation`](crate::model::LinkAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) link_id: std::option::Option<std::string::String>,
        pub(crate) link_association_state: std::option::Option<crate::model::LinkAssociationState>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The device ID for the link association.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The device ID for the link association.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// <p>The state of the association.</p>
        pub fn link_association_state(mut self, input: crate::model::LinkAssociationState) -> Self {
            self.link_association_state = Some(input);
            self
        }
        /// <p>The state of the association.</p>
        pub fn set_link_association_state(
            mut self,
            input: std::option::Option<crate::model::LinkAssociationState>,
        ) -> Self {
            self.link_association_state = input;
            self
        }
        /// Consumes the builder and constructs a [`LinkAssociation`](crate::model::LinkAssociation)
        pub fn build(self) -> crate::model::LinkAssociation {
            crate::model::LinkAssociation {
                global_network_id: self.global_network_id,
                device_id: self.device_id,
                link_id: self.link_id,
                link_association_state: self.link_association_state,
            }
        }
    }
}
impl LinkAssociation {
    /// Creates a new builder-style object to manufacture [`LinkAssociation`](crate::model::LinkAssociation)
    pub fn builder() -> crate::model::link_association::Builder {
        crate::model::link_association::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LinkAssociationState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LinkAssociationState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => LinkAssociationState::Available,
            "DELETED" => LinkAssociationState::Deleted,
            "DELETING" => LinkAssociationState::Deleting,
            "PENDING" => LinkAssociationState::Pending,
            other => LinkAssociationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LinkAssociationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LinkAssociationState::from(s))
    }
}
impl LinkAssociationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LinkAssociationState::Available => "AVAILABLE",
            LinkAssociationState::Deleted => "DELETED",
            LinkAssociationState::Deleting => "DELETING",
            LinkAssociationState::Pending => "PENDING",
            LinkAssociationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETED", "DELETING", "PENDING"]
    }
}
impl AsRef<str> for LinkAssociationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the association between a customer gateway, a device, and a link.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomerGatewayAssociation {
    /// <p>The Amazon Resource Name (ARN) of the customer gateway.</p>
    pub customer_gateway_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link.</p>
    pub link_id: std::option::Option<std::string::String>,
    /// <p>The association state.</p>
    pub state: std::option::Option<crate::model::CustomerGatewayAssociationState>,
}
impl std::fmt::Debug for CustomerGatewayAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomerGatewayAssociation");
        formatter.field("customer_gateway_arn", &self.customer_gateway_arn);
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("device_id", &self.device_id);
        formatter.field("link_id", &self.link_id);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`CustomerGatewayAssociation`](crate::model::CustomerGatewayAssociation)
pub mod customer_gateway_association {
    /// A builder for [`CustomerGatewayAssociation`](crate::model::CustomerGatewayAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) customer_gateway_arn: std::option::Option<std::string::String>,
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) link_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::CustomerGatewayAssociationState>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the customer gateway.</p>
        pub fn customer_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer gateway.</p>
        pub fn set_customer_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_gateway_arn = input;
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// <p>The association state.</p>
        pub fn state(mut self, input: crate::model::CustomerGatewayAssociationState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The association state.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::CustomerGatewayAssociationState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomerGatewayAssociation`](crate::model::CustomerGatewayAssociation)
        pub fn build(self) -> crate::model::CustomerGatewayAssociation {
            crate::model::CustomerGatewayAssociation {
                customer_gateway_arn: self.customer_gateway_arn,
                global_network_id: self.global_network_id,
                device_id: self.device_id,
                link_id: self.link_id,
                state: self.state,
            }
        }
    }
}
impl CustomerGatewayAssociation {
    /// Creates a new builder-style object to manufacture [`CustomerGatewayAssociation`](crate::model::CustomerGatewayAssociation)
    pub fn builder() -> crate::model::customer_gateway_association::Builder {
        crate::model::customer_gateway_association::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomerGatewayAssociationState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomerGatewayAssociationState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => CustomerGatewayAssociationState::Available,
            "DELETED" => CustomerGatewayAssociationState::Deleted,
            "DELETING" => CustomerGatewayAssociationState::Deleting,
            "PENDING" => CustomerGatewayAssociationState::Pending,
            other => CustomerGatewayAssociationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomerGatewayAssociationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomerGatewayAssociationState::from(s))
    }
}
impl CustomerGatewayAssociationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomerGatewayAssociationState::Available => "AVAILABLE",
            CustomerGatewayAssociationState::Deleted => "DELETED",
            CustomerGatewayAssociationState::Deleting => "DELETING",
            CustomerGatewayAssociationState::Pending => "PENDING",
            CustomerGatewayAssociationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETED", "DELETING", "PENDING"]
    }
}
impl AsRef<str> for CustomerGatewayAssociationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
