// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateCustomerGatewayInput`](crate::input::AssociateCustomerGatewayInput)
pub mod associate_customer_gateway_input {
    /// A builder for [`AssociateCustomerGatewayInput`](crate::input::AssociateCustomerGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) customer_gateway_arn: std::option::Option<std::string::String>,
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) link_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the customer gateway. For more information, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonec2.html#amazonec2-resources-for-iam-policies">Resources Defined by Amazon EC2</a>.</p>
        pub fn customer_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer gateway. For more information, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonec2.html#amazonec2-resources-for-iam-policies">Resources Defined by Amazon EC2</a>.</p>
        pub fn set_customer_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_gateway_arn = input;
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateCustomerGatewayInput`](crate::input::AssociateCustomerGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateCustomerGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateCustomerGatewayInput {
                customer_gateway_arn: self.customer_gateway_arn,
                global_network_id: self.global_network_id,
                device_id: self.device_id,
                link_id: self.link_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateCustomerGatewayInputOperationOutputAlias =
    crate::operation::AssociateCustomerGateway;
#[doc(hidden)]
pub type AssociateCustomerGatewayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateCustomerGatewayInput {
    /// Consumes the builder and constructs an Operation<[`AssociateCustomerGateway`](crate::operation::AssociateCustomerGateway)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateCustomerGateway,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateCustomerGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.global_network_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_1, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/customer-gateway-associations",
                GlobalNetworkId = global_network_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateCustomerGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateCustomerGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_customer_gateway(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateCustomerGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateCustomerGateway",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateCustomerGatewayInput`](crate::input::AssociateCustomerGatewayInput)
    pub fn builder() -> crate::input::associate_customer_gateway_input::Builder {
        crate::input::associate_customer_gateway_input::Builder::default()
    }
}

/// See [`AssociateLinkInput`](crate::input::AssociateLinkInput)
pub mod associate_link_input {
    /// A builder for [`AssociateLinkInput`](crate::input::AssociateLinkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) link_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateLinkInput`](crate::input::AssociateLinkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateLinkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateLinkInput {
                global_network_id: self.global_network_id,
                device_id: self.device_id,
                link_id: self.link_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateLinkInputOperationOutputAlias = crate::operation::AssociateLink;
#[doc(hidden)]
pub type AssociateLinkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateLinkInput {
    /// Consumes the builder and constructs an Operation<[`AssociateLink`](crate::operation::AssociateLink)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateLink,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateLinkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.global_network_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_2, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/link-associations",
                GlobalNetworkId = global_network_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateLinkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateLinkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_associate_link(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateLink::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateLink",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateLinkInput`](crate::input::AssociateLinkInput)
    pub fn builder() -> crate::input::associate_link_input::Builder {
        crate::input::associate_link_input::Builder::default()
    }
}

/// See [`AssociateTransitGatewayConnectPeerInput`](crate::input::AssociateTransitGatewayConnectPeerInput)
pub mod associate_transit_gateway_connect_peer_input {
    /// A builder for [`AssociateTransitGatewayConnectPeerInput`](crate::input::AssociateTransitGatewayConnectPeerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_connect_peer_arn: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) link_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Connect peer.</p>
        pub fn transit_gateway_connect_peer_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.transit_gateway_connect_peer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Connect peer.</p>
        pub fn set_transit_gateway_connect_peer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_connect_peer_arn = input;
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateTransitGatewayConnectPeerInput`](crate::input::AssociateTransitGatewayConnectPeerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateTransitGatewayConnectPeerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateTransitGatewayConnectPeerInput {
                global_network_id: self.global_network_id,
                transit_gateway_connect_peer_arn: self.transit_gateway_connect_peer_arn,
                device_id: self.device_id,
                link_id: self.link_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateTransitGatewayConnectPeerInputOperationOutputAlias =
    crate::operation::AssociateTransitGatewayConnectPeer;
#[doc(hidden)]
pub type AssociateTransitGatewayConnectPeerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateTransitGatewayConnectPeerInput {
    /// Consumes the builder and constructs an Operation<[`AssociateTransitGatewayConnectPeer`](crate::operation::AssociateTransitGatewayConnectPeer)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateTransitGatewayConnectPeer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateTransitGatewayConnectPeerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.global_network_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_3, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/transit-gateway-connect-peer-associations",
                GlobalNetworkId = global_network_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateTransitGatewayConnectPeerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateTransitGatewayConnectPeerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_transit_gateway_connect_peer(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateTransitGatewayConnectPeer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateTransitGatewayConnectPeer",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateTransitGatewayConnectPeerInput`](crate::input::AssociateTransitGatewayConnectPeerInput)
    pub fn builder() -> crate::input::associate_transit_gateway_connect_peer_input::Builder {
        crate::input::associate_transit_gateway_connect_peer_input::Builder::default()
    }
}

/// See [`CreateConnectionInput`](crate::input::CreateConnectionInput)
pub mod create_connection_input {
    /// A builder for [`CreateConnectionInput`](crate::input::CreateConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) connected_device_id: std::option::Option<std::string::String>,
        pub(crate) link_id: std::option::Option<std::string::String>,
        pub(crate) connected_link_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the first device in the connection.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the first device in the connection.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The ID of the second device in the connection.</p>
        pub fn connected_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connected_device_id = Some(input.into());
            self
        }
        /// <p>The ID of the second device in the connection.</p>
        pub fn set_connected_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connected_device_id = input;
            self
        }
        /// <p>The ID of the link for the first device.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link for the first device.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// <p>The ID of the link for the second device.</p>
        pub fn connected_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connected_link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link for the second device.</p>
        pub fn set_connected_link_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connected_link_id = input;
            self
        }
        /// <p>A description of the connection.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the connection.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectionInput`](crate::input::CreateConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConnectionInput {
                global_network_id: self.global_network_id,
                device_id: self.device_id,
                connected_device_id: self.connected_device_id,
                link_id: self.link_id,
                connected_link_id: self.connected_link_id,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConnectionInputOperationOutputAlias = crate::operation::CreateConnection;
#[doc(hidden)]
pub type CreateConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateConnectionInput {
    /// Consumes the builder and constructs an Operation<[`CreateConnection`](crate::operation::CreateConnection)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.global_network_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_4, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/connections",
                GlobalNetworkId = global_network_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_connection(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConnection",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateConnectionInput`](crate::input::CreateConnectionInput)
    pub fn builder() -> crate::input::create_connection_input::Builder {
        crate::input::create_connection_input::Builder::default()
    }
}

/// See [`CreateDeviceInput`](crate::input::CreateDeviceInput)
pub mod create_device_input {
    /// A builder for [`CreateDeviceInput`](crate::input::CreateDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) aws_location: std::option::Option<crate::model::AwsLocation>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) vendor: std::option::Option<std::string::String>,
        pub(crate) model: std::option::Option<std::string::String>,
        pub(crate) serial_number: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::Location>,
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The AWS location of the device.</p>
        pub fn aws_location(mut self, input: crate::model::AwsLocation) -> Self {
            self.aws_location = Some(input);
            self
        }
        /// <p>The AWS location of the device.</p>
        pub fn set_aws_location(
            mut self,
            input: std::option::Option<crate::model::AwsLocation>,
        ) -> Self {
            self.aws_location = input;
            self
        }
        /// <p>A description of the device.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the device.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of the device.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the device.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The vendor of the device.</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn vendor(mut self, input: impl Into<std::string::String>) -> Self {
            self.vendor = Some(input.into());
            self
        }
        /// <p>The vendor of the device.</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn set_vendor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vendor = input;
            self
        }
        /// <p>The model of the device.</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn model(mut self, input: impl Into<std::string::String>) -> Self {
            self.model = Some(input.into());
            self
        }
        /// <p>The model of the device.</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn set_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model = input;
            self
        }
        /// <p>The serial number of the device.</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.serial_number = Some(input.into());
            self
        }
        /// <p>The serial number of the device.</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.serial_number = input;
            self
        }
        /// <p>The location of the device.</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The location of the device.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.location = input;
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeviceInput`](crate::input::CreateDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDeviceInput {
                global_network_id: self.global_network_id,
                aws_location: self.aws_location,
                description: self.description,
                r#type: self.r#type,
                vendor: self.vendor,
                model: self.model,
                serial_number: self.serial_number,
                location: self.location,
                site_id: self.site_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDeviceInputOperationOutputAlias = crate::operation::CreateDevice;
#[doc(hidden)]
pub type CreateDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDeviceInput {
    /// Consumes the builder and constructs an Operation<[`CreateDevice`](crate::operation::CreateDevice)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.global_network_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_5, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/devices",
                GlobalNetworkId = global_network_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_device(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDevice",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDeviceInput`](crate::input::CreateDeviceInput)
    pub fn builder() -> crate::input::create_device_input::Builder {
        crate::input::create_device_input::Builder::default()
    }
}

/// See [`CreateGlobalNetworkInput`](crate::input::CreateGlobalNetworkInput)
pub mod create_global_network_input {
    /// A builder for [`CreateGlobalNetworkInput`](crate::input::CreateGlobalNetworkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A description of the global network.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the global network.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGlobalNetworkInput`](crate::input::CreateGlobalNetworkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGlobalNetworkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGlobalNetworkInput {
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGlobalNetworkInputOperationOutputAlias = crate::operation::CreateGlobalNetwork;
#[doc(hidden)]
pub type CreateGlobalNetworkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateGlobalNetworkInput {
    /// Consumes the builder and constructs an Operation<[`CreateGlobalNetwork`](crate::operation::CreateGlobalNetwork)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGlobalNetwork,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateGlobalNetworkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/global-networks").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateGlobalNetworkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateGlobalNetworkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_global_network(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGlobalNetwork::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGlobalNetwork",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateGlobalNetworkInput`](crate::input::CreateGlobalNetworkInput)
    pub fn builder() -> crate::input::create_global_network_input::Builder {
        crate::input::create_global_network_input::Builder::default()
    }
}

/// See [`CreateLinkInput`](crate::input::CreateLinkInput)
pub mod create_link_input {
    /// A builder for [`CreateLinkInput`](crate::input::CreateLinkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) bandwidth: std::option::Option<crate::model::Bandwidth>,
        pub(crate) provider: std::option::Option<std::string::String>,
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>A description of the link.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the link.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of the link.</p>
        /// <p>Constraints: Cannot include the following characters: | \ ^</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the link.</p>
        /// <p>Constraints: Cannot include the following characters: | \ ^</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p> The upload speed and download speed in Mbps. </p>
        pub fn bandwidth(mut self, input: crate::model::Bandwidth) -> Self {
            self.bandwidth = Some(input);
            self
        }
        /// <p> The upload speed and download speed in Mbps. </p>
        pub fn set_bandwidth(
            mut self,
            input: std::option::Option<crate::model::Bandwidth>,
        ) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>The provider of the link.</p>
        /// <p>Constraints: Cannot include the following characters: | \ ^</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider = Some(input.into());
            self
        }
        /// <p>The provider of the link.</p>
        /// <p>Constraints: Cannot include the following characters: | \ ^</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.provider = input;
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLinkInput`](crate::input::CreateLinkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLinkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLinkInput {
                global_network_id: self.global_network_id,
                description: self.description,
                r#type: self.r#type,
                bandwidth: self.bandwidth,
                provider: self.provider,
                site_id: self.site_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLinkInputOperationOutputAlias = crate::operation::CreateLink;
#[doc(hidden)]
pub type CreateLinkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateLinkInput {
    /// Consumes the builder and constructs an Operation<[`CreateLink`](crate::operation::CreateLink)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLink,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateLinkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.global_network_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_6, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/links",
                GlobalNetworkId = global_network_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateLinkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateLinkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_link(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLink::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLink",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateLinkInput`](crate::input::CreateLinkInput)
    pub fn builder() -> crate::input::create_link_input::Builder {
        crate::input::create_link_input::Builder::default()
    }
}

/// See [`CreateSiteInput`](crate::input::CreateSiteInput)
pub mod create_site_input {
    /// A builder for [`CreateSiteInput`](crate::input::CreateSiteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::Location>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>A description of your site.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of your site.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The site location. This information is used for visualization in the Network Manager console. If you specify the address, the latitude and longitude are automatically calculated.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Address</code>: The physical address of the site.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Latitude</code>: The latitude of the site. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Longitude</code>: The longitude of the site.</p>
        /// </li>
        /// </ul>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The site location. This information is used for visualization in the Network Manager console. If you specify the address, the latitude and longitude are automatically calculated.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Address</code>: The physical address of the site.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Latitude</code>: The latitude of the site. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Longitude</code>: The longitude of the site.</p>
        /// </li>
        /// </ul>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.location = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to apply to the resource during creation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSiteInput`](crate::input::CreateSiteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSiteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSiteInput {
                global_network_id: self.global_network_id,
                description: self.description,
                location: self.location,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSiteInputOperationOutputAlias = crate::operation::CreateSite;
#[doc(hidden)]
pub type CreateSiteInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSiteInput {
    /// Consumes the builder and constructs an Operation<[`CreateSite`](crate::operation::CreateSite)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSite,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSiteInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.global_network_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_7, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/sites",
                GlobalNetworkId = global_network_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSiteInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSiteInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_site(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSite::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSite",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSiteInput`](crate::input::CreateSiteInput)
    pub fn builder() -> crate::input::create_site_input::Builder {
        crate::input::create_site_input::Builder::default()
    }
}

/// See [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
pub mod delete_connection_input {
    /// A builder for [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConnectionInput {
                global_network_id: self.global_network_id,
                connection_id: self.connection_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConnectionInputOperationOutputAlias = crate::operation::DeleteConnection;
#[doc(hidden)]
pub type DeleteConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteConnectionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConnection`](crate::operation::DeleteConnection)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.global_network_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_8, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_9 = &_input.connection_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "connection_id",
                        details: "cannot be empty or unset",
                    })?;
            let connection_id = aws_smithy_http::label::fmt_string(input_9, false);
            if connection_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "connection_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/connections/{ConnectionId}",
                GlobalNetworkId = global_network_id,
                ConnectionId = connection_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConnection",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
    pub fn builder() -> crate::input::delete_connection_input::Builder {
        crate::input::delete_connection_input::Builder::default()
    }
}

/// See [`DeleteDeviceInput`](crate::input::DeleteDeviceInput)
pub mod delete_device_input {
    /// A builder for [`DeleteDeviceInput`](crate::input::DeleteDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDeviceInput`](crate::input::DeleteDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDeviceInput {
                global_network_id: self.global_network_id,
                device_id: self.device_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDeviceInputOperationOutputAlias = crate::operation::DeleteDevice;
#[doc(hidden)]
pub type DeleteDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDeviceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDevice`](crate::operation::DeleteDevice)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.global_network_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_10, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_11 = &_input.device_id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_id = aws_smithy_http::label::fmt_string(input_11, false);
            if device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/devices/{DeviceId}",
                GlobalNetworkId = global_network_id,
                DeviceId = device_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDevice",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDeviceInput`](crate::input::DeleteDeviceInput)
    pub fn builder() -> crate::input::delete_device_input::Builder {
        crate::input::delete_device_input::Builder::default()
    }
}

/// See [`DeleteGlobalNetworkInput`](crate::input::DeleteGlobalNetworkInput)
pub mod delete_global_network_input {
    /// A builder for [`DeleteGlobalNetworkInput`](crate::input::DeleteGlobalNetworkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGlobalNetworkInput`](crate::input::DeleteGlobalNetworkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGlobalNetworkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGlobalNetworkInput {
                global_network_id: self.global_network_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGlobalNetworkInputOperationOutputAlias = crate::operation::DeleteGlobalNetwork;
#[doc(hidden)]
pub type DeleteGlobalNetworkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteGlobalNetworkInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGlobalNetwork`](crate::operation::DeleteGlobalNetwork)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGlobalNetwork,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteGlobalNetworkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.global_network_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_12, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}",
                GlobalNetworkId = global_network_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteGlobalNetworkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteGlobalNetworkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGlobalNetwork::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGlobalNetwork",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteGlobalNetworkInput`](crate::input::DeleteGlobalNetworkInput)
    pub fn builder() -> crate::input::delete_global_network_input::Builder {
        crate::input::delete_global_network_input::Builder::default()
    }
}

/// See [`DeleteLinkInput`](crate::input::DeleteLinkInput)
pub mod delete_link_input {
    /// A builder for [`DeleteLinkInput`](crate::input::DeleteLinkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) link_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLinkInput`](crate::input::DeleteLinkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLinkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLinkInput {
                global_network_id: self.global_network_id,
                link_id: self.link_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLinkInputOperationOutputAlias = crate::operation::DeleteLink;
#[doc(hidden)]
pub type DeleteLinkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteLinkInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLink`](crate::operation::DeleteLink)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLink,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteLinkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.global_network_id;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_13, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_14 = &_input.link_id;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "link_id",
                        details: "cannot be empty or unset",
                    })?;
            let link_id = aws_smithy_http::label::fmt_string(input_14, false);
            if link_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "link_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/links/{LinkId}",
                GlobalNetworkId = global_network_id,
                LinkId = link_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteLinkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteLinkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLink::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLink",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteLinkInput`](crate::input::DeleteLinkInput)
    pub fn builder() -> crate::input::delete_link_input::Builder {
        crate::input::delete_link_input::Builder::default()
    }
}

/// See [`DeleteSiteInput`](crate::input::DeleteSiteInput)
pub mod delete_site_input {
    /// A builder for [`DeleteSiteInput`](crate::input::DeleteSiteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) site_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSiteInput`](crate::input::DeleteSiteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSiteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSiteInput {
                global_network_id: self.global_network_id,
                site_id: self.site_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSiteInputOperationOutputAlias = crate::operation::DeleteSite;
#[doc(hidden)]
pub type DeleteSiteInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSiteInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSite`](crate::operation::DeleteSite)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSite,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSiteInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.global_network_id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_15, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_16 = &_input.site_id;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "site_id",
                        details: "cannot be empty or unset",
                    })?;
            let site_id = aws_smithy_http::label::fmt_string(input_16, false);
            if site_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "site_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/sites/{SiteId}",
                GlobalNetworkId = global_network_id,
                SiteId = site_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSiteInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSiteInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSite::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSite",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSiteInput`](crate::input::DeleteSiteInput)
    pub fn builder() -> crate::input::delete_site_input::Builder {
        crate::input::delete_site_input::Builder::default()
    }
}

/// See [`DeregisterTransitGatewayInput`](crate::input::DeregisterTransitGatewayInput)
pub mod deregister_transit_gateway_input {
    /// A builder for [`DeregisterTransitGatewayInput`](crate::input::DeregisterTransitGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
        pub fn transit_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.transit_gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
        pub fn set_transit_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterTransitGatewayInput`](crate::input::DeregisterTransitGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterTransitGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterTransitGatewayInput {
                global_network_id: self.global_network_id,
                transit_gateway_arn: self.transit_gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterTransitGatewayInputOperationOutputAlias =
    crate::operation::DeregisterTransitGateway;
#[doc(hidden)]
pub type DeregisterTransitGatewayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeregisterTransitGatewayInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterTransitGateway`](crate::operation::DeregisterTransitGateway)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterTransitGateway,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterTransitGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.global_network_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_17, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_18 = &_input.transit_gateway_arn;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "transit_gateway_arn",
                        details: "cannot be empty or unset",
                    })?;
            let transit_gateway_arn = aws_smithy_http::label::fmt_string(input_18, false);
            if transit_gateway_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "transit_gateway_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/global-networks/{GlobalNetworkId}/transit-gateway-registrations/{TransitGatewayArn}", GlobalNetworkId = global_network_id, TransitGatewayArn = transit_gateway_arn).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterTransitGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterTransitGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterTransitGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterTransitGateway",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterTransitGatewayInput`](crate::input::DeregisterTransitGatewayInput)
    pub fn builder() -> crate::input::deregister_transit_gateway_input::Builder {
        crate::input::deregister_transit_gateway_input::Builder::default()
    }
}

/// See [`DescribeGlobalNetworksInput`](crate::input::DescribeGlobalNetworksInput)
pub mod describe_global_networks_input {
    /// A builder for [`DescribeGlobalNetworksInput`](crate::input::DescribeGlobalNetworksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `global_network_ids`.
        ///
        /// To override the contents of this collection use [`set_global_network_ids`](Self::set_global_network_ids).
        ///
        /// <p>The IDs of one or more global networks. The maximum is 10.</p>
        pub fn global_network_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.global_network_ids.unwrap_or_default();
            v.push(input.into());
            self.global_network_ids = Some(v);
            self
        }
        /// <p>The IDs of one or more global networks. The maximum is 10.</p>
        pub fn set_global_network_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.global_network_ids = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGlobalNetworksInput`](crate::input::DescribeGlobalNetworksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGlobalNetworksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGlobalNetworksInput {
                global_network_ids: self.global_network_ids,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGlobalNetworksInputOperationOutputAlias = crate::operation::DescribeGlobalNetworks;
#[doc(hidden)]
pub type DescribeGlobalNetworksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeGlobalNetworksInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGlobalNetworks`](crate::operation::DescribeGlobalNetworks)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGlobalNetworks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeGlobalNetworksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/global-networks").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DescribeGlobalNetworksInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_19) = &_input.global_network_ids {
                for inner_20 in inner_19 {
                    query.push_kv(
                        "globalNetworkIds",
                        &aws_smithy_http::query::fmt_string(&inner_20),
                    );
                }
            }
            if let Some(inner_21) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_21).encode(),
                );
            }
            if let Some(inner_22) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_22));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeGlobalNetworksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeGlobalNetworksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGlobalNetworks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGlobalNetworks",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeGlobalNetworksInput`](crate::input::DescribeGlobalNetworksInput)
    pub fn builder() -> crate::input::describe_global_networks_input::Builder {
        crate::input::describe_global_networks_input::Builder::default()
    }
}

/// See [`DisassociateCustomerGatewayInput`](crate::input::DisassociateCustomerGatewayInput)
pub mod disassociate_customer_gateway_input {
    /// A builder for [`DisassociateCustomerGatewayInput`](crate::input::DisassociateCustomerGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) customer_gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer gateway. For more information, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonec2.html#amazonec2-resources-for-iam-policies">Resources Defined by Amazon EC2</a>.</p>
        pub fn customer_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer gateway. For more information, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonec2.html#amazonec2-resources-for-iam-policies">Resources Defined by Amazon EC2</a>.</p>
        pub fn set_customer_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateCustomerGatewayInput`](crate::input::DisassociateCustomerGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateCustomerGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateCustomerGatewayInput {
                global_network_id: self.global_network_id,
                customer_gateway_arn: self.customer_gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateCustomerGatewayInputOperationOutputAlias =
    crate::operation::DisassociateCustomerGateway;
#[doc(hidden)]
pub type DisassociateCustomerGatewayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateCustomerGatewayInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateCustomerGateway`](crate::operation::DisassociateCustomerGateway)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateCustomerGateway,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateCustomerGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.global_network_id;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_23, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_24 = &_input.customer_gateway_arn;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "customer_gateway_arn",
                        details: "cannot be empty or unset",
                    })?;
            let customer_gateway_arn = aws_smithy_http::label::fmt_string(input_24, false);
            if customer_gateway_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "customer_gateway_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/global-networks/{GlobalNetworkId}/customer-gateway-associations/{CustomerGatewayArn}", GlobalNetworkId = global_network_id, CustomerGatewayArn = customer_gateway_arn).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateCustomerGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateCustomerGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateCustomerGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateCustomerGateway",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateCustomerGatewayInput`](crate::input::DisassociateCustomerGatewayInput)
    pub fn builder() -> crate::input::disassociate_customer_gateway_input::Builder {
        crate::input::disassociate_customer_gateway_input::Builder::default()
    }
}

/// See [`DisassociateLinkInput`](crate::input::DisassociateLinkInput)
pub mod disassociate_link_input {
    /// A builder for [`DisassociateLinkInput`](crate::input::DisassociateLinkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) link_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateLinkInput`](crate::input::DisassociateLinkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateLinkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateLinkInput {
                global_network_id: self.global_network_id,
                device_id: self.device_id,
                link_id: self.link_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateLinkInputOperationOutputAlias = crate::operation::DisassociateLink;
#[doc(hidden)]
pub type DisassociateLinkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateLinkInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateLink`](crate::operation::DisassociateLink)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateLink,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateLinkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_25 = &_input.global_network_id;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_25, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/link-associations",
                GlobalNetworkId = global_network_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DisassociateLinkInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_26) = &_input.device_id {
                query.push_kv("deviceId", &aws_smithy_http::query::fmt_string(&inner_26));
            }
            if let Some(inner_27) = &_input.link_id {
                query.push_kv("linkId", &aws_smithy_http::query::fmt_string(&inner_27));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateLinkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateLinkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateLink::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateLink",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateLinkInput`](crate::input::DisassociateLinkInput)
    pub fn builder() -> crate::input::disassociate_link_input::Builder {
        crate::input::disassociate_link_input::Builder::default()
    }
}

/// See [`DisassociateTransitGatewayConnectPeerInput`](crate::input::DisassociateTransitGatewayConnectPeerInput)
pub mod disassociate_transit_gateway_connect_peer_input {
    /// A builder for [`DisassociateTransitGatewayConnectPeerInput`](crate::input::DisassociateTransitGatewayConnectPeerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_connect_peer_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway Connect peer.</p>
        pub fn transit_gateway_connect_peer_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.transit_gateway_connect_peer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway Connect peer.</p>
        pub fn set_transit_gateway_connect_peer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_connect_peer_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateTransitGatewayConnectPeerInput`](crate::input::DisassociateTransitGatewayConnectPeerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateTransitGatewayConnectPeerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateTransitGatewayConnectPeerInput {
                global_network_id: self.global_network_id,
                transit_gateway_connect_peer_arn: self.transit_gateway_connect_peer_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateTransitGatewayConnectPeerInputOperationOutputAlias =
    crate::operation::DisassociateTransitGatewayConnectPeer;
#[doc(hidden)]
pub type DisassociateTransitGatewayConnectPeerInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DisassociateTransitGatewayConnectPeerInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateTransitGatewayConnectPeer`](crate::operation::DisassociateTransitGatewayConnectPeer)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateTransitGatewayConnectPeer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateTransitGatewayConnectPeerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_28 = &_input.global_network_id;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_28, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_29 = &_input.transit_gateway_connect_peer_arn;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "transit_gateway_connect_peer_arn",
                        details: "cannot be empty or unset",
                    })?;
            let transit_gateway_connect_peer_arn =
                aws_smithy_http::label::fmt_string(input_29, false);
            if transit_gateway_connect_peer_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "transit_gateway_connect_peer_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/global-networks/{GlobalNetworkId}/transit-gateway-connect-peer-associations/{TransitGatewayConnectPeerArn}", GlobalNetworkId = global_network_id, TransitGatewayConnectPeerArn = transit_gateway_connect_peer_arn).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateTransitGatewayConnectPeerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateTransitGatewayConnectPeerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateTransitGatewayConnectPeer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateTransitGatewayConnectPeer",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateTransitGatewayConnectPeerInput`](crate::input::DisassociateTransitGatewayConnectPeerInput)
    pub fn builder() -> crate::input::disassociate_transit_gateway_connect_peer_input::Builder {
        crate::input::disassociate_transit_gateway_connect_peer_input::Builder::default()
    }
}

/// See [`GetConnectionsInput`](crate::input::GetConnectionsInput)
pub mod get_connections_input {
    /// A builder for [`GetConnectionsInput`](crate::input::GetConnectionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) connection_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// Appends an item to `connection_ids`.
        ///
        /// To override the contents of this collection use [`set_connection_ids`](Self::set_connection_ids).
        ///
        /// <p>One or more connection IDs.</p>
        pub fn connection_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.connection_ids.unwrap_or_default();
            v.push(input.into());
            self.connection_ids = Some(v);
            self
        }
        /// <p>One or more connection IDs.</p>
        pub fn set_connection_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.connection_ids = input;
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConnectionsInput`](crate::input::GetConnectionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetConnectionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetConnectionsInput {
                global_network_id: self.global_network_id,
                connection_ids: self.connection_ids,
                device_id: self.device_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetConnectionsInputOperationOutputAlias = crate::operation::GetConnections;
#[doc(hidden)]
pub type GetConnectionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetConnectionsInput {
    /// Consumes the builder and constructs an Operation<[`GetConnections`](crate::operation::GetConnections)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetConnections,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetConnectionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.global_network_id;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_30, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/connections",
                GlobalNetworkId = global_network_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetConnectionsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_31) = &_input.connection_ids {
                for inner_32 in inner_31 {
                    query.push_kv(
                        "connectionIds",
                        &aws_smithy_http::query::fmt_string(&inner_32),
                    );
                }
            }
            if let Some(inner_33) = &_input.device_id {
                query.push_kv("deviceId", &aws_smithy_http::query::fmt_string(&inner_33));
            }
            if let Some(inner_34) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_34).encode(),
                );
            }
            if let Some(inner_35) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_35));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetConnectionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetConnectionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetConnections::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetConnections",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetConnectionsInput`](crate::input::GetConnectionsInput)
    pub fn builder() -> crate::input::get_connections_input::Builder {
        crate::input::get_connections_input::Builder::default()
    }
}

/// See [`GetCustomerGatewayAssociationsInput`](crate::input::GetCustomerGatewayAssociationsInput)
pub mod get_customer_gateway_associations_input {
    /// A builder for [`GetCustomerGatewayAssociationsInput`](crate::input::GetCustomerGatewayAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) customer_gateway_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// Appends an item to `customer_gateway_arns`.
        ///
        /// To override the contents of this collection use [`set_customer_gateway_arns`](Self::set_customer_gateway_arns).
        ///
        /// <p>One or more customer gateway Amazon Resource Names (ARNs). For more information, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonec2.html#amazonec2-resources-for-iam-policies">Resources Defined by Amazon EC2</a>. The maximum is 10.</p>
        pub fn customer_gateway_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.customer_gateway_arns.unwrap_or_default();
            v.push(input.into());
            self.customer_gateway_arns = Some(v);
            self
        }
        /// <p>One or more customer gateway Amazon Resource Names (ARNs). For more information, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonec2.html#amazonec2-resources-for-iam-policies">Resources Defined by Amazon EC2</a>. The maximum is 10.</p>
        pub fn set_customer_gateway_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.customer_gateway_arns = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCustomerGatewayAssociationsInput`](crate::input::GetCustomerGatewayAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCustomerGatewayAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCustomerGatewayAssociationsInput {
                global_network_id: self.global_network_id,
                customer_gateway_arns: self.customer_gateway_arns,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCustomerGatewayAssociationsInputOperationOutputAlias =
    crate::operation::GetCustomerGatewayAssociations;
#[doc(hidden)]
pub type GetCustomerGatewayAssociationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCustomerGatewayAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`GetCustomerGatewayAssociations`](crate::operation::GetCustomerGatewayAssociations)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCustomerGatewayAssociations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCustomerGatewayAssociationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_36 = &_input.global_network_id;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_36, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/customer-gateway-associations",
                GlobalNetworkId = global_network_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetCustomerGatewayAssociationsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_37) = &_input.customer_gateway_arns {
                for inner_38 in inner_37 {
                    query.push_kv(
                        "customerGatewayArns",
                        &aws_smithy_http::query::fmt_string(&inner_38),
                    );
                }
            }
            if let Some(inner_39) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_39).encode(),
                );
            }
            if let Some(inner_40) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_40));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCustomerGatewayAssociationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCustomerGatewayAssociationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCustomerGatewayAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCustomerGatewayAssociations",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCustomerGatewayAssociationsInput`](crate::input::GetCustomerGatewayAssociationsInput)
    pub fn builder() -> crate::input::get_customer_gateway_associations_input::Builder {
        crate::input::get_customer_gateway_associations_input::Builder::default()
    }
}

/// See [`GetDevicesInput`](crate::input::GetDevicesInput)
pub mod get_devices_input {
    /// A builder for [`GetDevicesInput`](crate::input::GetDevicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) device_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// Appends an item to `device_ids`.
        ///
        /// To override the contents of this collection use [`set_device_ids`](Self::set_device_ids).
        ///
        /// <p>One or more device IDs. The maximum is 10.</p>
        pub fn device_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.device_ids.unwrap_or_default();
            v.push(input.into());
            self.device_ids = Some(v);
            self
        }
        /// <p>One or more device IDs. The maximum is 10.</p>
        pub fn set_device_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.device_ids = input;
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDevicesInput`](crate::input::GetDevicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDevicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDevicesInput {
                global_network_id: self.global_network_id,
                device_ids: self.device_ids,
                site_id: self.site_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDevicesInputOperationOutputAlias = crate::operation::GetDevices;
#[doc(hidden)]
pub type GetDevicesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDevicesInput {
    /// Consumes the builder and constructs an Operation<[`GetDevices`](crate::operation::GetDevices)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDevices,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDevicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_41 = &_input.global_network_id;
            let input_41 =
                input_41
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_41, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/devices",
                GlobalNetworkId = global_network_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetDevicesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_42) = &_input.device_ids {
                for inner_43 in inner_42 {
                    query.push_kv("deviceIds", &aws_smithy_http::query::fmt_string(&inner_43));
                }
            }
            if let Some(inner_44) = &_input.site_id {
                query.push_kv("siteId", &aws_smithy_http::query::fmt_string(&inner_44));
            }
            if let Some(inner_45) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_45).encode(),
                );
            }
            if let Some(inner_46) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_46));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDevicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDevicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDevices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDevices",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDevicesInput`](crate::input::GetDevicesInput)
    pub fn builder() -> crate::input::get_devices_input::Builder {
        crate::input::get_devices_input::Builder::default()
    }
}

/// See [`GetLinkAssociationsInput`](crate::input::GetLinkAssociationsInput)
pub mod get_link_associations_input {
    /// A builder for [`GetLinkAssociationsInput`](crate::input::GetLinkAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) link_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLinkAssociationsInput`](crate::input::GetLinkAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLinkAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLinkAssociationsInput {
                global_network_id: self.global_network_id,
                device_id: self.device_id,
                link_id: self.link_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLinkAssociationsInputOperationOutputAlias = crate::operation::GetLinkAssociations;
#[doc(hidden)]
pub type GetLinkAssociationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetLinkAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`GetLinkAssociations`](crate::operation::GetLinkAssociations)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLinkAssociations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetLinkAssociationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_47 = &_input.global_network_id;
            let input_47 =
                input_47
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_47, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/link-associations",
                GlobalNetworkId = global_network_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetLinkAssociationsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_48) = &_input.device_id {
                query.push_kv("deviceId", &aws_smithy_http::query::fmt_string(&inner_48));
            }
            if let Some(inner_49) = &_input.link_id {
                query.push_kv("linkId", &aws_smithy_http::query::fmt_string(&inner_49));
            }
            if let Some(inner_50) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_50).encode(),
                );
            }
            if let Some(inner_51) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_51));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetLinkAssociationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetLinkAssociationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLinkAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLinkAssociations",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetLinkAssociationsInput`](crate::input::GetLinkAssociationsInput)
    pub fn builder() -> crate::input::get_link_associations_input::Builder {
        crate::input::get_link_associations_input::Builder::default()
    }
}

/// See [`GetLinksInput`](crate::input::GetLinksInput)
pub mod get_links_input {
    /// A builder for [`GetLinksInput`](crate::input::GetLinksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) link_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) provider: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// Appends an item to `link_ids`.
        ///
        /// To override the contents of this collection use [`set_link_ids`](Self::set_link_ids).
        ///
        /// <p>One or more link IDs. The maximum is 10.</p>
        pub fn link_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.link_ids.unwrap_or_default();
            v.push(input.into());
            self.link_ids = Some(v);
            self
        }
        /// <p>One or more link IDs. The maximum is 10.</p>
        pub fn set_link_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.link_ids = input;
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// <p>The link type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The link type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The link provider.</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider = Some(input.into());
            self
        }
        /// <p>The link provider.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.provider = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLinksInput`](crate::input::GetLinksInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetLinksInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetLinksInput {
                global_network_id: self.global_network_id,
                link_ids: self.link_ids,
                site_id: self.site_id,
                r#type: self.r#type,
                provider: self.provider,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLinksInputOperationOutputAlias = crate::operation::GetLinks;
#[doc(hidden)]
pub type GetLinksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetLinksInput {
    /// Consumes the builder and constructs an Operation<[`GetLinks`](crate::operation::GetLinks)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLinks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetLinksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_52 = &_input.global_network_id;
            let input_52 =
                input_52
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_52, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/links",
                GlobalNetworkId = global_network_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetLinksInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_53) = &_input.link_ids {
                for inner_54 in inner_53 {
                    query.push_kv("linkIds", &aws_smithy_http::query::fmt_string(&inner_54));
                }
            }
            if let Some(inner_55) = &_input.site_id {
                query.push_kv("siteId", &aws_smithy_http::query::fmt_string(&inner_55));
            }
            if let Some(inner_56) = &_input.r#type {
                query.push_kv("type", &aws_smithy_http::query::fmt_string(&inner_56));
            }
            if let Some(inner_57) = &_input.provider {
                query.push_kv("provider", &aws_smithy_http::query::fmt_string(&inner_57));
            }
            if let Some(inner_58) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_58).encode(),
                );
            }
            if let Some(inner_59) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_59));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetLinksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetLinksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetLinks::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetLinks",
                    "networkmanager",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetLinksInput`](crate::input::GetLinksInput)
    pub fn builder() -> crate::input::get_links_input::Builder {
        crate::input::get_links_input::Builder::default()
    }
}

/// See [`GetSitesInput`](crate::input::GetSitesInput)
pub mod get_sites_input {
    /// A builder for [`GetSitesInput`](crate::input::GetSitesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) site_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// Appends an item to `site_ids`.
        ///
        /// To override the contents of this collection use [`set_site_ids`](Self::set_site_ids).
        ///
        /// <p>One or more site IDs. The maximum is 10.</p>
        pub fn site_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.site_ids.unwrap_or_default();
            v.push(input.into());
            self.site_ids = Some(v);
            self
        }
        /// <p>One or more site IDs. The maximum is 10.</p>
        pub fn set_site_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.site_ids = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSitesInput`](crate::input::GetSitesInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetSitesInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetSitesInput {
                global_network_id: self.global_network_id,
                site_ids: self.site_ids,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSitesInputOperationOutputAlias = crate::operation::GetSites;
#[doc(hidden)]
pub type GetSitesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSitesInput {
    /// Consumes the builder and constructs an Operation<[`GetSites`](crate::operation::GetSites)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSites,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSitesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_60 = &_input.global_network_id;
            let input_60 =
                input_60
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_60, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/sites",
                GlobalNetworkId = global_network_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetSitesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_61) = &_input.site_ids {
                for inner_62 in inner_61 {
                    query.push_kv("siteIds", &aws_smithy_http::query::fmt_string(&inner_62));
                }
            }
            if let Some(inner_63) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_63).encode(),
                );
            }
            if let Some(inner_64) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_64));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSitesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSitesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetSites::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetSites",
                    "networkmanager",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSitesInput`](crate::input::GetSitesInput)
    pub fn builder() -> crate::input::get_sites_input::Builder {
        crate::input::get_sites_input::Builder::default()
    }
}

/// See [`GetTransitGatewayConnectPeerAssociationsInput`](crate::input::GetTransitGatewayConnectPeerAssociationsInput)
pub mod get_transit_gateway_connect_peer_associations_input {
    /// A builder for [`GetTransitGatewayConnectPeerAssociationsInput`](crate::input::GetTransitGatewayConnectPeerAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_connect_peer_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// Appends an item to `transit_gateway_connect_peer_arns`.
        ///
        /// To override the contents of this collection use [`set_transit_gateway_connect_peer_arns`](Self::set_transit_gateway_connect_peer_arns).
        ///
        /// <p>One or more transit gateway Connect peer Amazon Resource Names (ARNs).</p>
        pub fn transit_gateway_connect_peer_arns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.transit_gateway_connect_peer_arns.unwrap_or_default();
            v.push(input.into());
            self.transit_gateway_connect_peer_arns = Some(v);
            self
        }
        /// <p>One or more transit gateway Connect peer Amazon Resource Names (ARNs).</p>
        pub fn set_transit_gateway_connect_peer_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.transit_gateway_connect_peer_arns = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTransitGatewayConnectPeerAssociationsInput`](crate::input::GetTransitGatewayConnectPeerAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTransitGatewayConnectPeerAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::GetTransitGatewayConnectPeerAssociationsInput {
                    global_network_id: self.global_network_id,
                    transit_gateway_connect_peer_arns: self.transit_gateway_connect_peer_arns,
                    max_results: self.max_results,
                    next_token: self.next_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type GetTransitGatewayConnectPeerAssociationsInputOperationOutputAlias =
    crate::operation::GetTransitGatewayConnectPeerAssociations;
#[doc(hidden)]
pub type GetTransitGatewayConnectPeerAssociationsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl GetTransitGatewayConnectPeerAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`GetTransitGatewayConnectPeerAssociations`](crate::operation::GetTransitGatewayConnectPeerAssociations)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTransitGatewayConnectPeerAssociations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTransitGatewayConnectPeerAssociationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_65 = &_input.global_network_id;
            let input_65 =
                input_65
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_65, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/transit-gateway-connect-peer-associations",
                GlobalNetworkId = global_network_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetTransitGatewayConnectPeerAssociationsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_66) = &_input.transit_gateway_connect_peer_arns {
                for inner_67 in inner_66 {
                    query.push_kv(
                        "transitGatewayConnectPeerArns",
                        &aws_smithy_http::query::fmt_string(&inner_67),
                    );
                }
            }
            if let Some(inner_68) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_68).encode(),
                );
            }
            if let Some(inner_69) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_69));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTransitGatewayConnectPeerAssociationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTransitGatewayConnectPeerAssociationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTransitGatewayConnectPeerAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTransitGatewayConnectPeerAssociations",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTransitGatewayConnectPeerAssociationsInput`](crate::input::GetTransitGatewayConnectPeerAssociationsInput)
    pub fn builder() -> crate::input::get_transit_gateway_connect_peer_associations_input::Builder {
        crate::input::get_transit_gateway_connect_peer_associations_input::Builder::default()
    }
}

/// See [`GetTransitGatewayRegistrationsInput`](crate::input::GetTransitGatewayRegistrationsInput)
pub mod get_transit_gateway_registrations_input {
    /// A builder for [`GetTransitGatewayRegistrationsInput`](crate::input::GetTransitGatewayRegistrationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// Appends an item to `transit_gateway_arns`.
        ///
        /// To override the contents of this collection use [`set_transit_gateway_arns`](Self::set_transit_gateway_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of one or more transit gateways. The maximum is
        /// 10.</p>
        pub fn transit_gateway_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.transit_gateway_arns.unwrap_or_default();
            v.push(input.into());
            self.transit_gateway_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of one or more transit gateways. The maximum is
        /// 10.</p>
        pub fn set_transit_gateway_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.transit_gateway_arns = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTransitGatewayRegistrationsInput`](crate::input::GetTransitGatewayRegistrationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTransitGatewayRegistrationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTransitGatewayRegistrationsInput {
                global_network_id: self.global_network_id,
                transit_gateway_arns: self.transit_gateway_arns,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTransitGatewayRegistrationsInputOperationOutputAlias =
    crate::operation::GetTransitGatewayRegistrations;
#[doc(hidden)]
pub type GetTransitGatewayRegistrationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetTransitGatewayRegistrationsInput {
    /// Consumes the builder and constructs an Operation<[`GetTransitGatewayRegistrations`](crate::operation::GetTransitGatewayRegistrations)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTransitGatewayRegistrations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTransitGatewayRegistrationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_70 = &_input.global_network_id;
            let input_70 =
                input_70
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_70, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/transit-gateway-registrations",
                GlobalNetworkId = global_network_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetTransitGatewayRegistrationsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_71) = &_input.transit_gateway_arns {
                for inner_72 in inner_71 {
                    query.push_kv(
                        "transitGatewayArns",
                        &aws_smithy_http::query::fmt_string(&inner_72),
                    );
                }
            }
            if let Some(inner_73) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_73).encode(),
                );
            }
            if let Some(inner_74) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_74));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTransitGatewayRegistrationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTransitGatewayRegistrationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTransitGatewayRegistrations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTransitGatewayRegistrations",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTransitGatewayRegistrationsInput`](crate::input::GetTransitGatewayRegistrationsInput)
    pub fn builder() -> crate::input::get_transit_gateway_registrations_input::Builder {
        crate::input::get_transit_gateway_registrations_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_75 = &_input.resource_arn;
            let input_75 =
                input_75
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_75, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`RegisterTransitGatewayInput`](crate::input::RegisterTransitGatewayInput)
pub mod register_transit_gateway_input {
    /// A builder for [`RegisterTransitGatewayInput`](crate::input::RegisterTransitGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway. For more information, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonec2.html#amazonec2-resources-for-iam-policies">Resources Defined by Amazon EC2</a>.</p>
        pub fn transit_gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.transit_gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transit gateway. For more information, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonec2.html#amazonec2-resources-for-iam-policies">Resources Defined by Amazon EC2</a>.</p>
        pub fn set_transit_gateway_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterTransitGatewayInput`](crate::input::RegisterTransitGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterTransitGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterTransitGatewayInput {
                global_network_id: self.global_network_id,
                transit_gateway_arn: self.transit_gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterTransitGatewayInputOperationOutputAlias = crate::operation::RegisterTransitGateway;
#[doc(hidden)]
pub type RegisterTransitGatewayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterTransitGatewayInput {
    /// Consumes the builder and constructs an Operation<[`RegisterTransitGateway`](crate::operation::RegisterTransitGateway)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterTransitGateway,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterTransitGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_76 = &_input.global_network_id;
            let input_76 =
                input_76
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_76, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/transit-gateway-registrations",
                GlobalNetworkId = global_network_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterTransitGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterTransitGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_transit_gateway(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterTransitGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterTransitGateway",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterTransitGatewayInput`](crate::input::RegisterTransitGatewayInput)
    pub fn builder() -> crate::input::register_transit_gateway_input::Builder {
        crate::input::register_transit_gateway_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the specified resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to apply to the specified resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_77 = &_input.resource_arn;
            let input_77 =
                input_77
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_77, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys to remove from the specified resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys to remove from the specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_78 = &_input.resource_arn;
            let input_78 =
                input_78
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_78, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UntagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_79) = &_input.tag_keys {
                for inner_80 in inner_79 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_80));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateConnectionInput`](crate::input::UpdateConnectionInput)
pub mod update_connection_input {
    /// A builder for [`UpdateConnectionInput`](crate::input::UpdateConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) link_id: std::option::Option<std::string::String>,
        pub(crate) connected_link_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The ID of the link for the first device in the connection.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link for the first device in the connection.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// <p>The ID of the link for the second device in the connection.</p>
        pub fn connected_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connected_link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link for the second device in the connection.</p>
        pub fn set_connected_link_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connected_link_id = input;
            self
        }
        /// <p>A description of the connection.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the connection.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConnectionInput`](crate::input::UpdateConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConnectionInput {
                global_network_id: self.global_network_id,
                connection_id: self.connection_id,
                link_id: self.link_id,
                connected_link_id: self.connected_link_id,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConnectionInputOperationOutputAlias = crate::operation::UpdateConnection;
#[doc(hidden)]
pub type UpdateConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateConnectionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConnection`](crate::operation::UpdateConnection)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_81 = &_input.global_network_id;
            let input_81 =
                input_81
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_81, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_82 = &_input.connection_id;
            let input_82 =
                input_82
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "connection_id",
                        details: "cannot be empty or unset",
                    })?;
            let connection_id = aws_smithy_http::label::fmt_string(input_82, false);
            if connection_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "connection_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/connections/{ConnectionId}",
                GlobalNetworkId = global_network_id,
                ConnectionId = connection_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_connection(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConnection",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateConnectionInput`](crate::input::UpdateConnectionInput)
    pub fn builder() -> crate::input::update_connection_input::Builder {
        crate::input::update_connection_input::Builder::default()
    }
}

/// See [`UpdateDeviceInput`](crate::input::UpdateDeviceInput)
pub mod update_device_input {
    /// A builder for [`UpdateDeviceInput`](crate::input::UpdateDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) aws_location: std::option::Option<crate::model::AwsLocation>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) vendor: std::option::Option<std::string::String>,
        pub(crate) model: std::option::Option<std::string::String>,
        pub(crate) serial_number: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::Location>,
        pub(crate) site_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The AWS location of the device.</p>
        pub fn aws_location(mut self, input: crate::model::AwsLocation) -> Self {
            self.aws_location = Some(input);
            self
        }
        /// <p>The AWS location of the device.</p>
        pub fn set_aws_location(
            mut self,
            input: std::option::Option<crate::model::AwsLocation>,
        ) -> Self {
            self.aws_location = input;
            self
        }
        /// <p>A description of the device.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the device.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of the device.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the device.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The vendor of the device.</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn vendor(mut self, input: impl Into<std::string::String>) -> Self {
            self.vendor = Some(input.into());
            self
        }
        /// <p>The vendor of the device.</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn set_vendor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vendor = input;
            self
        }
        /// <p>The model of the device.</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn model(mut self, input: impl Into<std::string::String>) -> Self {
            self.model = Some(input.into());
            self
        }
        /// <p>The model of the device.</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn set_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model = input;
            self
        }
        /// <p>The serial number of the device.</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.serial_number = Some(input.into());
            self
        }
        /// <p>The serial number of the device.</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.serial_number = input;
            self
        }
        /// <p>Describes a location.</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>Describes a location.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.location = input;
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeviceInput`](crate::input::UpdateDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDeviceInput {
                global_network_id: self.global_network_id,
                device_id: self.device_id,
                aws_location: self.aws_location,
                description: self.description,
                r#type: self.r#type,
                vendor: self.vendor,
                model: self.model,
                serial_number: self.serial_number,
                location: self.location,
                site_id: self.site_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDeviceInputOperationOutputAlias = crate::operation::UpdateDevice;
#[doc(hidden)]
pub type UpdateDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateDeviceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDevice`](crate::operation::UpdateDevice)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_83 = &_input.global_network_id;
            let input_83 =
                input_83
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_83, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_84 = &_input.device_id;
            let input_84 =
                input_84
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_id = aws_smithy_http::label::fmt_string(input_84, false);
            if device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/devices/{DeviceId}",
                GlobalNetworkId = global_network_id,
                DeviceId = device_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_device(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDevice",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDeviceInput`](crate::input::UpdateDeviceInput)
    pub fn builder() -> crate::input::update_device_input::Builder {
        crate::input::update_device_input::Builder::default()
    }
}

/// See [`UpdateGlobalNetworkInput`](crate::input::UpdateGlobalNetworkInput)
pub mod update_global_network_input {
    /// A builder for [`UpdateGlobalNetworkInput`](crate::input::UpdateGlobalNetworkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of your global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of your global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>A description of the global network.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the global network.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGlobalNetworkInput`](crate::input::UpdateGlobalNetworkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGlobalNetworkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGlobalNetworkInput {
                global_network_id: self.global_network_id,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGlobalNetworkInputOperationOutputAlias = crate::operation::UpdateGlobalNetwork;
#[doc(hidden)]
pub type UpdateGlobalNetworkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateGlobalNetworkInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGlobalNetwork`](crate::operation::UpdateGlobalNetwork)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGlobalNetwork,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGlobalNetworkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_85 = &_input.global_network_id;
            let input_85 =
                input_85
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_85, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}",
                GlobalNetworkId = global_network_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGlobalNetworkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGlobalNetworkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_global_network(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGlobalNetwork::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGlobalNetwork",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGlobalNetworkInput`](crate::input::UpdateGlobalNetworkInput)
    pub fn builder() -> crate::input::update_global_network_input::Builder {
        crate::input::update_global_network_input::Builder::default()
    }
}

/// See [`UpdateLinkInput`](crate::input::UpdateLinkInput)
pub mod update_link_input {
    /// A builder for [`UpdateLinkInput`](crate::input::UpdateLinkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) link_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) bandwidth: std::option::Option<crate::model::Bandwidth>,
        pub(crate) provider: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of the link.</p>
        pub fn link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_id = Some(input.into());
            self
        }
        /// <p>The ID of the link.</p>
        pub fn set_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_id = input;
            self
        }
        /// <p>A description of the link.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the link.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of the link.</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the link.</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The upload and download speed in Mbps. </p>
        pub fn bandwidth(mut self, input: crate::model::Bandwidth) -> Self {
            self.bandwidth = Some(input);
            self
        }
        /// <p>The upload and download speed in Mbps. </p>
        pub fn set_bandwidth(
            mut self,
            input: std::option::Option<crate::model::Bandwidth>,
        ) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>The provider of the link.</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider = Some(input.into());
            self
        }
        /// <p>The provider of the link.</p>
        /// <p>Length Constraints: Maximum length of 128 characters.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.provider = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLinkInput`](crate::input::UpdateLinkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateLinkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateLinkInput {
                global_network_id: self.global_network_id,
                link_id: self.link_id,
                description: self.description,
                r#type: self.r#type,
                bandwidth: self.bandwidth,
                provider: self.provider,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateLinkInputOperationOutputAlias = crate::operation::UpdateLink;
#[doc(hidden)]
pub type UpdateLinkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateLinkInput {
    /// Consumes the builder and constructs an Operation<[`UpdateLink`](crate::operation::UpdateLink)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateLink,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateLinkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_86 = &_input.global_network_id;
            let input_86 =
                input_86
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_86, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_87 = &_input.link_id;
            let input_87 =
                input_87
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "link_id",
                        details: "cannot be empty or unset",
                    })?;
            let link_id = aws_smithy_http::label::fmt_string(input_87, false);
            if link_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "link_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/links/{LinkId}",
                GlobalNetworkId = global_network_id,
                LinkId = link_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateLinkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateLinkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_link(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateLink::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateLink",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateLinkInput`](crate::input::UpdateLinkInput)
    pub fn builder() -> crate::input::update_link_input::Builder {
        crate::input::update_link_input::Builder::default()
    }
}

/// See [`UpdateSiteInput`](crate::input::UpdateSiteInput)
pub mod update_site_input {
    /// A builder for [`UpdateSiteInput`](crate::input::UpdateSiteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_network_id: std::option::Option<std::string::String>,
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::Location>,
    }
    impl Builder {
        /// <p>The ID of the global network.</p>
        pub fn global_network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_network_id = Some(input.into());
            self
        }
        /// <p>The ID of the global network.</p>
        pub fn set_global_network_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_network_id = input;
            self
        }
        /// <p>The ID of your site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p>The ID of your site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// <p>A description of your site.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of your site.</p>
        /// <p>Length Constraints: Maximum length of 256 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The site location:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Address</code>: The physical address of the site.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Latitude</code>: The latitude of the site. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Longitude</code>: The longitude of the site.</p>
        /// </li>
        /// </ul>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The site location:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Address</code>: The physical address of the site.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Latitude</code>: The latitude of the site. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Longitude</code>: The longitude of the site.</p>
        /// </li>
        /// </ul>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSiteInput`](crate::input::UpdateSiteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSiteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSiteInput {
                global_network_id: self.global_network_id,
                site_id: self.site_id,
                description: self.description,
                location: self.location,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSiteInputOperationOutputAlias = crate::operation::UpdateSite;
#[doc(hidden)]
pub type UpdateSiteInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateSiteInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSite`](crate::operation::UpdateSite)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSite,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSiteInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_88 = &_input.global_network_id;
            let input_88 =
                input_88
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "global_network_id",
                        details: "cannot be empty or unset",
                    })?;
            let global_network_id = aws_smithy_http::label::fmt_string(input_88, false);
            if global_network_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "global_network_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_89 = &_input.site_id;
            let input_89 =
                input_89
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "site_id",
                        details: "cannot be empty or unset",
                    })?;
            let site_id = aws_smithy_http::label::fmt_string(input_89, false);
            if site_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "site_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/global-networks/{GlobalNetworkId}/sites/{SiteId}",
                GlobalNetworkId = global_network_id,
                SiteId = site_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSiteInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSiteInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_site(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSite::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSite",
            "networkmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSiteInput`](crate::input::UpdateSiteInput)
    pub fn builder() -> crate::input::update_site_input::Builder {
        crate::input::update_site_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSiteInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of your site.</p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p>A description of your site.</p>
    /// <p>Length Constraints: Maximum length of 256 characters.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The site location:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Address</code>: The physical address of the site.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Latitude</code>: The latitude of the site. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Longitude</code>: The longitude of the site.</p>
    /// </li>
    /// </ul>
    pub location: std::option::Option<crate::model::Location>,
}
impl std::fmt::Debug for UpdateSiteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSiteInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("site_id", &self.site_id);
        formatter.field("description", &self.description);
        formatter.field("location", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLinkInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link.</p>
    pub link_id: std::option::Option<std::string::String>,
    /// <p>A description of the link.</p>
    /// <p>Length Constraints: Maximum length of 256 characters.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of the link.</p>
    /// <p>Length Constraints: Maximum length of 128 characters.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The upload and download speed in Mbps. </p>
    pub bandwidth: std::option::Option<crate::model::Bandwidth>,
    /// <p>The provider of the link.</p>
    /// <p>Length Constraints: Maximum length of 128 characters.</p>
    pub provider: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateLinkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLinkInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("link_id", &self.link_id);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("provider", &self.provider);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGlobalNetworkInput {
    /// <p>The ID of your global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>A description of the global network.</p>
    /// <p>Length Constraints: Maximum length of 256 characters.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateGlobalNetworkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGlobalNetworkInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeviceInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The AWS location of the device.</p>
    pub aws_location: std::option::Option<crate::model::AwsLocation>,
    /// <p>A description of the device.</p>
    /// <p>Length Constraints: Maximum length of 256 characters.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of the device.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The vendor of the device.</p>
    /// <p>Length Constraints: Maximum length of 128 characters.</p>
    pub vendor: std::option::Option<std::string::String>,
    /// <p>The model of the device.</p>
    /// <p>Length Constraints: Maximum length of 128 characters.</p>
    pub model: std::option::Option<std::string::String>,
    /// <p>The serial number of the device.</p>
    /// <p>Length Constraints: Maximum length of 128 characters.</p>
    pub serial_number: std::option::Option<std::string::String>,
    /// <p>Describes a location.</p>
    pub location: std::option::Option<crate::model::Location>,
    /// <p>The ID of the site.</p>
    pub site_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeviceInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("device_id", &self.device_id);
        formatter.field("aws_location", &self.aws_location);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("vendor", &self.vendor);
        formatter.field("model", &self.model);
        formatter.field("serial_number", &self.serial_number);
        formatter.field("location", &"*** Sensitive Data Redacted ***");
        formatter.field("site_id", &self.site_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectionInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link for the first device in the connection.</p>
    pub link_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link for the second device in the connection.</p>
    pub connected_link_id: std::option::Option<std::string::String>,
    /// <p>A description of the connection.</p>
    /// <p>Length Constraints: Maximum length of 256 characters.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectionInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("link_id", &self.link_id);
        formatter.field("connected_link_id", &self.connected_link_id);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag keys to remove from the specified resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to apply to the specified resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterTransitGatewayInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the transit gateway. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonec2.html#amazonec2-resources-for-iam-policies">Resources Defined by Amazon EC2</a>.</p>
    pub transit_gateway_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RegisterTransitGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterTransitGatewayInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("transit_gateway_arn", &self.transit_gateway_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTransitGatewayRegistrationsInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARNs) of one or more transit gateways. The maximum is
    /// 10.</p>
    pub transit_gateway_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetTransitGatewayRegistrationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTransitGatewayRegistrationsInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("transit_gateway_arns", &self.transit_gateway_arns);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTransitGatewayConnectPeerAssociationsInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>One or more transit gateway Connect peer Amazon Resource Names (ARNs).</p>
    pub transit_gateway_connect_peer_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetTransitGatewayConnectPeerAssociationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTransitGatewayConnectPeerAssociationsInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field(
            "transit_gateway_connect_peer_arns",
            &self.transit_gateway_connect_peer_arns,
        );
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSitesInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>One or more site IDs. The maximum is 10.</p>
    pub site_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSitesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSitesInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("site_ids", &self.site_ids);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLinksInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>One or more link IDs. The maximum is 10.</p>
    pub link_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the site.</p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p>The link type.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The link provider.</p>
    pub provider: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetLinksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLinksInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("link_ids", &self.link_ids);
        formatter.field("site_id", &self.site_id);
        formatter.field("r#type", &self.r#type);
        formatter.field("provider", &self.provider);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLinkAssociationsInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link.</p>
    pub link_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetLinkAssociationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLinkAssociationsInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("device_id", &self.device_id);
        formatter.field("link_id", &self.link_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDevicesInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>One or more device IDs. The maximum is 10.</p>
    pub device_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the site.</p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDevicesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDevicesInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("device_ids", &self.device_ids);
        formatter.field("site_id", &self.site_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCustomerGatewayAssociationsInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>One or more customer gateway Amazon Resource Names (ARNs). For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonec2.html#amazonec2-resources-for-iam-policies">Resources Defined by Amazon EC2</a>. The maximum is 10.</p>
    pub customer_gateway_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetCustomerGatewayAssociationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCustomerGatewayAssociationsInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("customer_gateway_arns", &self.customer_gateway_arns);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConnectionsInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>One or more connection IDs.</p>
    pub connection_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetConnectionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConnectionsInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("connection_ids", &self.connection_ids);
        formatter.field("device_id", &self.device_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateTransitGatewayConnectPeerInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the transit gateway Connect peer.</p>
    pub transit_gateway_connect_peer_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisassociateTransitGatewayConnectPeerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateTransitGatewayConnectPeerInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field(
            "transit_gateway_connect_peer_arn",
            &self.transit_gateway_connect_peer_arn,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateLinkInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link.</p>
    pub link_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisassociateLinkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateLinkInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("device_id", &self.device_id);
        formatter.field("link_id", &self.link_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateCustomerGatewayInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the customer gateway. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonec2.html#amazonec2-resources-for-iam-policies">Resources Defined by Amazon EC2</a>.</p>
    pub customer_gateway_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisassociateCustomerGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateCustomerGatewayInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("customer_gateway_arn", &self.customer_gateway_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGlobalNetworksInput {
    /// <p>The IDs of one or more global networks. The maximum is 10.</p>
    pub global_network_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeGlobalNetworksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGlobalNetworksInput");
        formatter.field("global_network_ids", &self.global_network_ids);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterTransitGatewayInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the transit gateway.</p>
    pub transit_gateway_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeregisterTransitGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterTransitGatewayInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("transit_gateway_arn", &self.transit_gateway_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSiteInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the site.</p>
    pub site_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteSiteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSiteInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("site_id", &self.site_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLinkInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link.</p>
    pub link_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteLinkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLinkInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("link_id", &self.link_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGlobalNetworkInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteGlobalNetworkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGlobalNetworkInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDeviceInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDeviceInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("device_id", &self.device_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConnectionInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConnectionInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("connection_id", &self.connection_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSiteInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>A description of your site.</p>
    /// <p>Length Constraints: Maximum length of 256 characters.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The site location. This information is used for visualization in the Network Manager console. If you specify the address, the latitude and longitude are automatically calculated.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Address</code>: The physical address of the site.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Latitude</code>: The latitude of the site. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Longitude</code>: The longitude of the site.</p>
    /// </li>
    /// </ul>
    pub location: std::option::Option<crate::model::Location>,
    /// <p>The tags to apply to the resource during creation.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateSiteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSiteInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("description", &self.description);
        formatter.field("location", &"*** Sensitive Data Redacted ***");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLinkInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>A description of the link.</p>
    /// <p>Length Constraints: Maximum length of 256 characters.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of the link.</p>
    /// <p>Constraints: Cannot include the following characters: | \ ^</p>
    /// <p>Length Constraints: Maximum length of 128 characters.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p> The upload speed and download speed in Mbps. </p>
    pub bandwidth: std::option::Option<crate::model::Bandwidth>,
    /// <p>The provider of the link.</p>
    /// <p>Constraints: Cannot include the following characters: | \ ^</p>
    /// <p>Length Constraints: Maximum length of 128 characters.</p>
    pub provider: std::option::Option<std::string::String>,
    /// <p>The ID of the site.</p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p>The tags to apply to the resource during creation.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateLinkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLinkInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("provider", &self.provider);
        formatter.field("site_id", &self.site_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGlobalNetworkInput {
    /// <p>A description of the global network.</p>
    /// <p>Length Constraints: Maximum length of 256 characters.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The tags to apply to the resource during creation.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateGlobalNetworkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGlobalNetworkInput");
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeviceInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The AWS location of the device.</p>
    pub aws_location: std::option::Option<crate::model::AwsLocation>,
    /// <p>A description of the device.</p>
    /// <p>Length Constraints: Maximum length of 256 characters.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of the device.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The vendor of the device.</p>
    /// <p>Length Constraints: Maximum length of 128 characters.</p>
    pub vendor: std::option::Option<std::string::String>,
    /// <p>The model of the device.</p>
    /// <p>Length Constraints: Maximum length of 128 characters.</p>
    pub model: std::option::Option<std::string::String>,
    /// <p>The serial number of the device.</p>
    /// <p>Length Constraints: Maximum length of 128 characters.</p>
    pub serial_number: std::option::Option<std::string::String>,
    /// <p>The location of the device.</p>
    pub location: std::option::Option<crate::model::Location>,
    /// <p>The ID of the site.</p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p>The tags to apply to the resource during creation.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeviceInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("aws_location", &self.aws_location);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("vendor", &self.vendor);
        formatter.field("model", &self.model);
        formatter.field("serial_number", &self.serial_number);
        formatter.field("location", &"*** Sensitive Data Redacted ***");
        formatter.field("site_id", &self.site_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectionInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the first device in the connection.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The ID of the second device in the connection.</p>
    pub connected_device_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link for the first device.</p>
    pub link_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link for the second device.</p>
    pub connected_link_id: std::option::Option<std::string::String>,
    /// <p>A description of the connection.</p>
    /// <p>Length Constraints: Maximum length of 256 characters.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The tags to apply to the resource during creation.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectionInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("device_id", &self.device_id);
        formatter.field("connected_device_id", &self.connected_device_id);
        formatter.field("link_id", &self.link_id);
        formatter.field("connected_link_id", &self.connected_link_id);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateTransitGatewayConnectPeerInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Connect peer.</p>
    pub transit_gateway_connect_peer_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link.</p>
    pub link_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateTransitGatewayConnectPeerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateTransitGatewayConnectPeerInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field(
            "transit_gateway_connect_peer_arn",
            &self.transit_gateway_connect_peer_arn,
        );
        formatter.field("device_id", &self.device_id);
        formatter.field("link_id", &self.link_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateLinkInput {
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link.</p>
    pub link_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateLinkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateLinkInput");
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("device_id", &self.device_id);
        formatter.field("link_id", &self.link_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateCustomerGatewayInput {
    /// <p>The Amazon Resource Name (ARN) of the customer gateway. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonec2.html#amazonec2-resources-for-iam-policies">Resources Defined by Amazon EC2</a>.</p>
    pub customer_gateway_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the global network.</p>
    pub global_network_id: std::option::Option<std::string::String>,
    /// <p>The ID of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The ID of the link.</p>
    pub link_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateCustomerGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateCustomerGatewayInput");
        formatter.field("customer_gateway_arn", &self.customer_gateway_arn);
        formatter.field("global_network_id", &self.global_network_id);
        formatter.field("device_id", &self.device_id);
        formatter.field("link_id", &self.link_id);
        formatter.finish()
    }
}
