// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Network Firewall
///
/// Client for invoking operations on AWS Network Firewall. Each operation on AWS Network Firewall is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_networkfirewall::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_networkfirewall::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_networkfirewall::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateFirewallPolicy`](crate::client::fluent_builders::AssociateFirewallPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`update_token(impl Into<String>)`](crate::client::fluent_builders::AssociateFirewallPolicy::update_token) / [`set_update_token(Option<String>)`](crate::client::fluent_builders::AssociateFirewallPolicy::set_update_token): <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>  <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>  <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    ///   - [`firewall_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateFirewallPolicy::firewall_arn) / [`set_firewall_arn(Option<String>)`](crate::client::fluent_builders::AssociateFirewallPolicy::set_firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`firewall_name(impl Into<String>)`](crate::client::fluent_builders::AssociateFirewallPolicy::firewall_name) / [`set_firewall_name(Option<String>)`](crate::client::fluent_builders::AssociateFirewallPolicy::set_firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`firewall_policy_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateFirewallPolicy::firewall_policy_arn) / [`set_firewall_policy_arn(Option<String>)`](crate::client::fluent_builders::AssociateFirewallPolicy::set_firewall_policy_arn): <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
    /// - On success, responds with [`AssociateFirewallPolicyOutput`](crate::output::AssociateFirewallPolicyOutput) with field(s):
    ///   - [`firewall_arn(Option<String>)`](crate::output::AssociateFirewallPolicyOutput::firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>
    ///   - [`firewall_name(Option<String>)`](crate::output::AssociateFirewallPolicyOutput::firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    ///   - [`firewall_policy_arn(Option<String>)`](crate::output::AssociateFirewallPolicyOutput::firewall_policy_arn): <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
    ///   - [`update_token(Option<String>)`](crate::output::AssociateFirewallPolicyOutput::update_token): <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>  <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>  <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    /// - On failure, responds with [`SdkError<AssociateFirewallPolicyError>`](crate::error::AssociateFirewallPolicyError)
    pub fn associate_firewall_policy(&self) -> fluent_builders::AssociateFirewallPolicy {
        fluent_builders::AssociateFirewallPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateSubnets`](crate::client::fluent_builders::AssociateSubnets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`update_token(impl Into<String>)`](crate::client::fluent_builders::AssociateSubnets::update_token) / [`set_update_token(Option<String>)`](crate::client::fluent_builders::AssociateSubnets::set_update_token): <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>  <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>  <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    ///   - [`firewall_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateSubnets::firewall_arn) / [`set_firewall_arn(Option<String>)`](crate::client::fluent_builders::AssociateSubnets::set_firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`firewall_name(impl Into<String>)`](crate::client::fluent_builders::AssociateSubnets::firewall_name) / [`set_firewall_name(Option<String>)`](crate::client::fluent_builders::AssociateSubnets::set_firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`subnet_mappings(Vec<SubnetMapping>)`](crate::client::fluent_builders::AssociateSubnets::subnet_mappings) / [`set_subnet_mappings(Option<Vec<SubnetMapping>>)`](crate::client::fluent_builders::AssociateSubnets::set_subnet_mappings): <p>The IDs of the subnets that you want to associate with the firewall. </p>
    /// - On success, responds with [`AssociateSubnetsOutput`](crate::output::AssociateSubnetsOutput) with field(s):
    ///   - [`firewall_arn(Option<String>)`](crate::output::AssociateSubnetsOutput::firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>
    ///   - [`firewall_name(Option<String>)`](crate::output::AssociateSubnetsOutput::firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    ///   - [`subnet_mappings(Option<Vec<SubnetMapping>>)`](crate::output::AssociateSubnetsOutput::subnet_mappings): <p>The IDs of the subnets that are associated with the firewall. </p>
    ///   - [`update_token(Option<String>)`](crate::output::AssociateSubnetsOutput::update_token): <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>  <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>  <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    /// - On failure, responds with [`SdkError<AssociateSubnetsError>`](crate::error::AssociateSubnetsError)
    pub fn associate_subnets(&self) -> fluent_builders::AssociateSubnets {
        fluent_builders::AssociateSubnets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFirewall`](crate::client::fluent_builders::CreateFirewall) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_name(impl Into<String>)`](crate::client::fluent_builders::CreateFirewall::firewall_name) / [`set_firewall_name(Option<String>)`](crate::client::fluent_builders::CreateFirewall::set_firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    ///   - [`firewall_policy_arn(impl Into<String>)`](crate::client::fluent_builders::CreateFirewall::firewall_policy_arn) / [`set_firewall_policy_arn(Option<String>)`](crate::client::fluent_builders::CreateFirewall::set_firewall_policy_arn): <p>The Amazon Resource Name (ARN) of the <code>FirewallPolicy</code> that you want to use for the firewall.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::CreateFirewall::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::CreateFirewall::set_vpc_id): <p>The unique identifier of the VPC where Network Firewall should create the firewall. </p>  <p>You can't change this setting after you create the firewall. </p>
    ///   - [`subnet_mappings(Vec<SubnetMapping>)`](crate::client::fluent_builders::CreateFirewall::subnet_mappings) / [`set_subnet_mappings(Option<Vec<SubnetMapping>>)`](crate::client::fluent_builders::CreateFirewall::set_subnet_mappings): <p>The public subnets to use for your Network Firewall firewalls. Each subnet must belong to a different Availability Zone in the VPC. Network Firewall creates a firewall endpoint in each subnet. </p>
    ///   - [`delete_protection(bool)`](crate::client::fluent_builders::CreateFirewall::delete_protection) / [`set_delete_protection(bool)`](crate::client::fluent_builders::CreateFirewall::set_delete_protection): <p>A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.</p>
    ///   - [`subnet_change_protection(bool)`](crate::client::fluent_builders::CreateFirewall::subnet_change_protection) / [`set_subnet_change_protection(bool)`](crate::client::fluent_builders::CreateFirewall::set_subnet_change_protection): <p>A setting indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
    ///   - [`firewall_policy_change_protection(bool)`](crate::client::fluent_builders::CreateFirewall::firewall_policy_change_protection) / [`set_firewall_policy_change_protection(bool)`](crate::client::fluent_builders::CreateFirewall::set_firewall_policy_change_protection): <p>A setting indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateFirewall::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateFirewall::set_description): <p>A description of the firewall.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateFirewall::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateFirewall::set_tags): <p>The key:value pairs to associate with the resource.</p>
    /// - On success, responds with [`CreateFirewallOutput`](crate::output::CreateFirewallOutput) with field(s):
    ///   - [`firewall(Option<Firewall>)`](crate::output::CreateFirewallOutput::firewall): <p>The configuration settings for the firewall. These settings include the firewall policy and the subnets in your VPC to use for the firewall endpoints. </p>
    ///   - [`firewall_status(Option<FirewallStatus>)`](crate::output::CreateFirewallOutput::firewall_status): <p>Detailed information about the current status of a <code>Firewall</code>. You can retrieve this for a firewall by calling <code>DescribeFirewall</code> and providing the firewall name and ARN.</p>
    /// - On failure, responds with [`SdkError<CreateFirewallError>`](crate::error::CreateFirewallError)
    pub fn create_firewall(&self) -> fluent_builders::CreateFirewall {
        fluent_builders::CreateFirewall::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFirewallPolicy`](crate::client::fluent_builders::CreateFirewallPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_policy_name(impl Into<String>)`](crate::client::fluent_builders::CreateFirewallPolicy::firewall_policy_name) / [`set_firewall_policy_name(Option<String>)`](crate::client::fluent_builders::CreateFirewallPolicy::set_firewall_policy_name): <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
    ///   - [`firewall_policy(FirewallPolicy)`](crate::client::fluent_builders::CreateFirewallPolicy::firewall_policy) / [`set_firewall_policy(Option<FirewallPolicy>)`](crate::client::fluent_builders::CreateFirewallPolicy::set_firewall_policy): <p>The rule groups and policy actions to use in the firewall policy.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateFirewallPolicy::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateFirewallPolicy::set_description): <p>A description of the firewall policy.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateFirewallPolicy::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateFirewallPolicy::set_tags): <p>The key:value pairs to associate with the resource.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateFirewallPolicy::dry_run) / [`set_dry_run(bool)`](crate::client::fluent_builders::CreateFirewallPolicy::set_dry_run): <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>  <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid. </p>  <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
    /// - On success, responds with [`CreateFirewallPolicyOutput`](crate::output::CreateFirewallPolicyOutput) with field(s):
    ///   - [`update_token(Option<String>)`](crate::output::CreateFirewallPolicyOutput::update_token): <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p>  <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>
    ///   - [`firewall_policy_response(Option<FirewallPolicyResponse>)`](crate::output::CreateFirewallPolicyOutput::firewall_policy_response): <p>The high-level properties of a firewall policy. This, along with the <code>FirewallPolicy</code>, define the policy. You can retrieve all objects for a firewall policy by calling <code>DescribeFirewallPolicy</code>. </p>
    /// - On failure, responds with [`SdkError<CreateFirewallPolicyError>`](crate::error::CreateFirewallPolicyError)
    pub fn create_firewall_policy(&self) -> fluent_builders::CreateFirewallPolicy {
        fluent_builders::CreateFirewallPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRuleGroup`](crate::client::fluent_builders::CreateRuleGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateRuleGroup::rule_group_name) / [`set_rule_group_name(Option<String>)`](crate::client::fluent_builders::CreateRuleGroup::set_rule_group_name): <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
    ///   - [`rule_group(RuleGroup)`](crate::client::fluent_builders::CreateRuleGroup::rule_group) / [`set_rule_group(Option<RuleGroup>)`](crate::client::fluent_builders::CreateRuleGroup::set_rule_group): <p>An object that defines the rule group rules. </p> <note>   <p>You must provide either this rule group setting or a <code>Rules</code> setting, but not both. </p>  </note>
    ///   - [`rules(impl Into<String>)`](crate::client::fluent_builders::CreateRuleGroup::rules) / [`set_rules(Option<String>)`](crate::client::fluent_builders::CreateRuleGroup::set_rules): <p>A string containing stateful rule group rules specifications in Suricata flat format, with one rule per line. Use this to import your existing Suricata compatible rule groups. </p> <note>   <p>You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not both. </p>  </note>  <p>You can provide your rule group specification in Suricata flat format through this setting when you create or update your rule group. The call response returns a <code>RuleGroup</code> object that Network Firewall has populated from your string. </p>
    ///   - [`r#type(RuleGroupType)`](crate::client::fluent_builders::CreateRuleGroup::type) / [`set_type(Option<RuleGroupType>)`](crate::client::fluent_builders::CreateRuleGroup::set_type): <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateRuleGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateRuleGroup::set_description): <p>A description of the rule group. </p>
    ///   - [`capacity(i32)`](crate::client::fluent_builders::CreateRuleGroup::capacity) / [`set_capacity(Option<i32>)`](crate::client::fluent_builders::CreateRuleGroup::set_capacity): <p>The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy, Network Firewall reserves this capacity for the rule group. </p>  <p>You can retrieve the capacity that would be required for a rule group before you create the rule group by calling <code>CreateRuleGroup</code> with <code>DryRun</code> set to <code>TRUE</code>. </p> <note>   <p>You can't change or exceed this capacity when you update the rule group, so leave room for your rule group to grow. </p>  </note>  <p> <b>Capacity for a stateless rule group</b> </p>  <p>For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual rules that you expect to have in the rule group. </p>  <p>To calculate the capacity requirement of a single rule, multiply the capacity requirement values of each of the rule's match settings:</p>  <ul>   <li> <p>A match setting with no criteria specified has a value of 1. </p> </li>   <li> <p>A match setting with <code>Any</code> specified has a value of 1. </p> </li>   <li> <p>All other match settings have a value equal to the number of elements provided in the setting. For example, a protocol setting ["UDP"] and a source setting ["10.0.0.0/24"] each have a value of 1. A protocol setting ["UDP","TCP"] has a value of 2. A source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"] has a value of 3. </p> </li>  </ul>  <p>A rule with no criteria specified in any of its match settings has a capacity requirement of 1. A rule with protocol setting ["UDP","TCP"], source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"], and a single specification or no specification for each of the other match settings has a capacity requirement of 6. </p>  <p> <b>Capacity for a stateful rule group</b> </p>  <p>For a stateful rule group, the minimum capacity required is the number of individual rules that you expect to have in the rule group. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateRuleGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateRuleGroup::set_tags): <p>The key:value pairs to associate with the resource.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateRuleGroup::dry_run) / [`set_dry_run(bool)`](crate::client::fluent_builders::CreateRuleGroup::set_dry_run): <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>  <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid. </p>  <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
    /// - On success, responds with [`CreateRuleGroupOutput`](crate::output::CreateRuleGroupOutput) with field(s):
    ///   - [`update_token(Option<String>)`](crate::output::CreateRuleGroupOutput::update_token): <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p>  <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>
    ///   - [`rule_group_response(Option<RuleGroupResponse>)`](crate::output::CreateRuleGroupOutput::rule_group_response): <p>The high-level properties of a rule group. This, along with the <code>RuleGroup</code>, define the rule group. You can retrieve all objects for a rule group by calling <code>DescribeRuleGroup</code>. </p>
    /// - On failure, responds with [`SdkError<CreateRuleGroupError>`](crate::error::CreateRuleGroupError)
    pub fn create_rule_group(&self) -> fluent_builders::CreateRuleGroup {
        fluent_builders::CreateRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFirewall`](crate::client::fluent_builders::DeleteFirewall) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_name(impl Into<String>)`](crate::client::fluent_builders::DeleteFirewall::firewall_name) / [`set_firewall_name(Option<String>)`](crate::client::fluent_builders::DeleteFirewall::set_firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`firewall_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteFirewall::firewall_arn) / [`set_firewall_arn(Option<String>)`](crate::client::fluent_builders::DeleteFirewall::set_firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    /// - On success, responds with [`DeleteFirewallOutput`](crate::output::DeleteFirewallOutput) with field(s):
    ///   - [`firewall(Option<Firewall>)`](crate::output::DeleteFirewallOutput::firewall): <p>The firewall defines the configuration settings for an AWS Network Firewall firewall. These settings include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and any tags that are attached to the firewall AWS resource. </p>  <p>The status of the firewall, for example whether it's ready to filter network traffic, is provided in the corresponding <code>FirewallStatus</code>. You can retrieve both objects by calling <code>DescribeFirewall</code>.</p>
    ///   - [`firewall_status(Option<FirewallStatus>)`](crate::output::DeleteFirewallOutput::firewall_status): <p>Detailed information about the current status of a <code>Firewall</code>. You can retrieve this for a firewall by calling <code>DescribeFirewall</code> and providing the firewall name and ARN.</p>
    /// - On failure, responds with [`SdkError<DeleteFirewallError>`](crate::error::DeleteFirewallError)
    pub fn delete_firewall(&self) -> fluent_builders::DeleteFirewall {
        fluent_builders::DeleteFirewall::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFirewallPolicy`](crate::client::fluent_builders::DeleteFirewallPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_policy_name(impl Into<String>)`](crate::client::fluent_builders::DeleteFirewallPolicy::firewall_policy_name) / [`set_firewall_policy_name(Option<String>)`](crate::client::fluent_builders::DeleteFirewallPolicy::set_firewall_policy_name): <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`firewall_policy_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteFirewallPolicy::firewall_policy_arn) / [`set_firewall_policy_arn(Option<String>)`](crate::client::fluent_builders::DeleteFirewallPolicy::set_firewall_policy_arn): <p>The Amazon Resource Name (ARN) of the firewall policy.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    /// - On success, responds with [`DeleteFirewallPolicyOutput`](crate::output::DeleteFirewallPolicyOutput) with field(s):
    ///   - [`firewall_policy_response(Option<FirewallPolicyResponse>)`](crate::output::DeleteFirewallPolicyOutput::firewall_policy_response): <p>The object containing the definition of the <code>FirewallPolicyResponse</code> that you asked to delete. </p>
    /// - On failure, responds with [`SdkError<DeleteFirewallPolicyError>`](crate::error::DeleteFirewallPolicyError)
    pub fn delete_firewall_policy(&self) -> fluent_builders::DeleteFirewallPolicy {
        fluent_builders::DeleteFirewallPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResourcePolicy`](crate::client::fluent_builders::DeleteResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::set_resource_arn): <p>The Amazon Resource Name (ARN) of the rule group or firewall policy whose resource policy you want to delete. </p>
    /// - On success, responds with [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteResourcePolicyError>`](crate::error::DeleteResourcePolicyError)
    pub fn delete_resource_policy(&self) -> fluent_builders::DeleteResourcePolicy {
        fluent_builders::DeleteResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRuleGroup`](crate::client::fluent_builders::DeleteRuleGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteRuleGroup::rule_group_name) / [`set_rule_group_name(Option<String>)`](crate::client::fluent_builders::DeleteRuleGroup::set_rule_group_name): <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`rule_group_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteRuleGroup::rule_group_arn) / [`set_rule_group_arn(Option<String>)`](crate::client::fluent_builders::DeleteRuleGroup::set_rule_group_arn): <p>The Amazon Resource Name (ARN) of the rule group.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`r#type(RuleGroupType)`](crate::client::fluent_builders::DeleteRuleGroup::type) / [`set_type(Option<RuleGroupType>)`](crate::client::fluent_builders::DeleteRuleGroup::set_type): <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p> <note>   <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p>  </note>
    /// - On success, responds with [`DeleteRuleGroupOutput`](crate::output::DeleteRuleGroupOutput) with field(s):
    ///   - [`rule_group_response(Option<RuleGroupResponse>)`](crate::output::DeleteRuleGroupOutput::rule_group_response): <p>The high-level properties of a rule group. This, along with the <code>RuleGroup</code>, define the rule group. You can retrieve all objects for a rule group by calling <code>DescribeRuleGroup</code>. </p>
    /// - On failure, responds with [`SdkError<DeleteRuleGroupError>`](crate::error::DeleteRuleGroupError)
    pub fn delete_rule_group(&self) -> fluent_builders::DeleteRuleGroup {
        fluent_builders::DeleteRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFirewall`](crate::client::fluent_builders::DescribeFirewall) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_name(impl Into<String>)`](crate::client::fluent_builders::DescribeFirewall::firewall_name) / [`set_firewall_name(Option<String>)`](crate::client::fluent_builders::DescribeFirewall::set_firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`firewall_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeFirewall::firewall_arn) / [`set_firewall_arn(Option<String>)`](crate::client::fluent_builders::DescribeFirewall::set_firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    /// - On success, responds with [`DescribeFirewallOutput`](crate::output::DescribeFirewallOutput) with field(s):
    ///   - [`update_token(Option<String>)`](crate::output::DescribeFirewallOutput::update_token): <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>  <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>  <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    ///   - [`firewall(Option<Firewall>)`](crate::output::DescribeFirewallOutput::firewall): <p>The configuration settings for the firewall. These settings include the firewall policy and the subnets in your VPC to use for the firewall endpoints. </p>
    ///   - [`firewall_status(Option<FirewallStatus>)`](crate::output::DescribeFirewallOutput::firewall_status): <p>Detailed information about the current status of a <code>Firewall</code>. You can retrieve this for a firewall by calling <code>DescribeFirewall</code> and providing the firewall name and ARN.</p>
    /// - On failure, responds with [`SdkError<DescribeFirewallError>`](crate::error::DescribeFirewallError)
    pub fn describe_firewall(&self) -> fluent_builders::DescribeFirewall {
        fluent_builders::DescribeFirewall::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFirewallPolicy`](crate::client::fluent_builders::DescribeFirewallPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_policy_name(impl Into<String>)`](crate::client::fluent_builders::DescribeFirewallPolicy::firewall_policy_name) / [`set_firewall_policy_name(Option<String>)`](crate::client::fluent_builders::DescribeFirewallPolicy::set_firewall_policy_name): <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`firewall_policy_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeFirewallPolicy::firewall_policy_arn) / [`set_firewall_policy_arn(Option<String>)`](crate::client::fluent_builders::DescribeFirewallPolicy::set_firewall_policy_arn): <p>The Amazon Resource Name (ARN) of the firewall policy.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    /// - On success, responds with [`DescribeFirewallPolicyOutput`](crate::output::DescribeFirewallPolicyOutput) with field(s):
    ///   - [`update_token(Option<String>)`](crate::output::DescribeFirewallPolicyOutput::update_token): <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p>  <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>
    ///   - [`firewall_policy_response(Option<FirewallPolicyResponse>)`](crate::output::DescribeFirewallPolicyOutput::firewall_policy_response): <p>The high-level properties of a firewall policy. This, along with the <code>FirewallPolicy</code>, define the policy. You can retrieve all objects for a firewall policy by calling <code>DescribeFirewallPolicy</code>. </p>
    ///   - [`firewall_policy(Option<FirewallPolicy>)`](crate::output::DescribeFirewallPolicyOutput::firewall_policy): <p>The policy for the specified firewall policy. </p>
    /// - On failure, responds with [`SdkError<DescribeFirewallPolicyError>`](crate::error::DescribeFirewallPolicyError)
    pub fn describe_firewall_policy(&self) -> fluent_builders::DescribeFirewallPolicy {
        fluent_builders::DescribeFirewallPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLoggingConfiguration`](crate::client::fluent_builders::DescribeLoggingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeLoggingConfiguration::firewall_arn) / [`set_firewall_arn(Option<String>)`](crate::client::fluent_builders::DescribeLoggingConfiguration::set_firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`firewall_name(impl Into<String>)`](crate::client::fluent_builders::DescribeLoggingConfiguration::firewall_name) / [`set_firewall_name(Option<String>)`](crate::client::fluent_builders::DescribeLoggingConfiguration::set_firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    /// - On success, responds with [`DescribeLoggingConfigurationOutput`](crate::output::DescribeLoggingConfigurationOutput) with field(s):
    ///   - [`firewall_arn(Option<String>)`](crate::output::DescribeLoggingConfigurationOutput::firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>
    ///   - [`logging_configuration(Option<LoggingConfiguration>)`](crate::output::DescribeLoggingConfigurationOutput::logging_configuration): <p>Defines how AWS Network Firewall performs logging for a <code>Firewall</code>. </p>
    /// - On failure, responds with [`SdkError<DescribeLoggingConfigurationError>`](crate::error::DescribeLoggingConfigurationError)
    pub fn describe_logging_configuration(&self) -> fluent_builders::DescribeLoggingConfiguration {
        fluent_builders::DescribeLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeResourcePolicy`](crate::client::fluent_builders::DescribeResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeResourcePolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DescribeResourcePolicy::set_resource_arn): <p>The Amazon Resource Name (ARN) of the rule group or firewall policy whose resource policy you want to retrieve. </p>
    /// - On success, responds with [`DescribeResourcePolicyOutput`](crate::output::DescribeResourcePolicyOutput) with field(s):
    ///   - [`policy(Option<String>)`](crate::output::DescribeResourcePolicyOutput::policy): <p>The AWS Identity and Access Management policy for the resource. </p>
    /// - On failure, responds with [`SdkError<DescribeResourcePolicyError>`](crate::error::DescribeResourcePolicyError)
    pub fn describe_resource_policy(&self) -> fluent_builders::DescribeResourcePolicy {
        fluent_builders::DescribeResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRuleGroup`](crate::client::fluent_builders::DescribeRuleGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeRuleGroup::rule_group_name) / [`set_rule_group_name(Option<String>)`](crate::client::fluent_builders::DescribeRuleGroup::set_rule_group_name): <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`rule_group_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeRuleGroup::rule_group_arn) / [`set_rule_group_arn(Option<String>)`](crate::client::fluent_builders::DescribeRuleGroup::set_rule_group_arn): <p>The Amazon Resource Name (ARN) of the rule group.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`r#type(RuleGroupType)`](crate::client::fluent_builders::DescribeRuleGroup::type) / [`set_type(Option<RuleGroupType>)`](crate::client::fluent_builders::DescribeRuleGroup::set_type): <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p> <note>   <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p>  </note>
    /// - On success, responds with [`DescribeRuleGroupOutput`](crate::output::DescribeRuleGroupOutput) with field(s):
    ///   - [`update_token(Option<String>)`](crate::output::DescribeRuleGroupOutput::update_token): <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p>  <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>
    ///   - [`rule_group(Option<RuleGroup>)`](crate::output::DescribeRuleGroupOutput::rule_group): <p>The object that defines the rules in a rule group. This, along with <code>RuleGroupResponse</code>, define the rule group. You can retrieve all objects for a rule group by calling <code>DescribeRuleGroup</code>. </p>  <p>AWS Network Firewall uses a rule group to inspect and control network traffic. You define stateless rule groups to inspect individual packets and you define stateful rule groups to inspect packets in the context of their traffic flow. </p>  <p>To use a rule group, you include it by reference in an Network Firewall firewall policy, then you use the policy in a firewall. You can reference a rule group from more than one firewall policy, and you can use a firewall policy in more than one firewall. </p>
    ///   - [`rule_group_response(Option<RuleGroupResponse>)`](crate::output::DescribeRuleGroupOutput::rule_group_response): <p>The high-level properties of a rule group. This, along with the <code>RuleGroup</code>, define the rule group. You can retrieve all objects for a rule group by calling <code>DescribeRuleGroup</code>. </p>
    /// - On failure, responds with [`SdkError<DescribeRuleGroupError>`](crate::error::DescribeRuleGroupError)
    pub fn describe_rule_group(&self) -> fluent_builders::DescribeRuleGroup {
        fluent_builders::DescribeRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRuleGroupMetadata`](crate::client::fluent_builders::DescribeRuleGroupMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeRuleGroupMetadata::rule_group_name) / [`set_rule_group_name(Option<String>)`](crate::client::fluent_builders::DescribeRuleGroupMetadata::set_rule_group_name): <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`rule_group_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeRuleGroupMetadata::rule_group_arn) / [`set_rule_group_arn(Option<String>)`](crate::client::fluent_builders::DescribeRuleGroupMetadata::set_rule_group_arn): <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`r#type(RuleGroupType)`](crate::client::fluent_builders::DescribeRuleGroupMetadata::type) / [`set_type(Option<RuleGroupType>)`](crate::client::fluent_builders::DescribeRuleGroupMetadata::set_type): <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p> <note>   <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p>  </note>
    /// - On success, responds with [`DescribeRuleGroupMetadataOutput`](crate::output::DescribeRuleGroupMetadataOutput) with field(s):
    ///   - [`rule_group_arn(Option<String>)`](crate::output::DescribeRuleGroupMetadataOutput::rule_group_arn): <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`rule_group_name(Option<String>)`](crate::output::DescribeRuleGroupMetadataOutput::rule_group_name): <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`description(Option<String>)`](crate::output::DescribeRuleGroupMetadataOutput::description): <p>Returns the metadata objects for the specified rule group. </p>
    ///   - [`r#type(Option<RuleGroupType>)`](crate::output::DescribeRuleGroupMetadataOutput::type): <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p> <note>   <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p>  </note>
    ///   - [`capacity(Option<i32>)`](crate::output::DescribeRuleGroupMetadataOutput::capacity): <p>The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy, Network Firewall reserves this capacity for the rule group. </p>  <p>You can retrieve the capacity that would be required for a rule group before you create the rule group by calling <code>CreateRuleGroup</code> with <code>DryRun</code> set to <code>TRUE</code>. </p>
    ///   - [`stateful_rule_options(Option<StatefulRuleOptions>)`](crate::output::DescribeRuleGroupMetadataOutput::stateful_rule_options): <p>Additional options governing how Network Firewall handles the rule group. You can only use these for stateful rule groups.</p>
    /// - On failure, responds with [`SdkError<DescribeRuleGroupMetadataError>`](crate::error::DescribeRuleGroupMetadataError)
    pub fn describe_rule_group_metadata(&self) -> fluent_builders::DescribeRuleGroupMetadata {
        fluent_builders::DescribeRuleGroupMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateSubnets`](crate::client::fluent_builders::DisassociateSubnets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`update_token(impl Into<String>)`](crate::client::fluent_builders::DisassociateSubnets::update_token) / [`set_update_token(Option<String>)`](crate::client::fluent_builders::DisassociateSubnets::set_update_token): <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>  <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>  <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    ///   - [`firewall_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateSubnets::firewall_arn) / [`set_firewall_arn(Option<String>)`](crate::client::fluent_builders::DisassociateSubnets::set_firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`firewall_name(impl Into<String>)`](crate::client::fluent_builders::DisassociateSubnets::firewall_name) / [`set_firewall_name(Option<String>)`](crate::client::fluent_builders::DisassociateSubnets::set_firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::DisassociateSubnets::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DisassociateSubnets::set_subnet_ids): <p>The unique identifiers for the subnets that you want to disassociate. </p>
    /// - On success, responds with [`DisassociateSubnetsOutput`](crate::output::DisassociateSubnetsOutput) with field(s):
    ///   - [`firewall_arn(Option<String>)`](crate::output::DisassociateSubnetsOutput::firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>
    ///   - [`firewall_name(Option<String>)`](crate::output::DisassociateSubnetsOutput::firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    ///   - [`subnet_mappings(Option<Vec<SubnetMapping>>)`](crate::output::DisassociateSubnetsOutput::subnet_mappings): <p>The IDs of the subnets that are associated with the firewall. </p>
    ///   - [`update_token(Option<String>)`](crate::output::DisassociateSubnetsOutput::update_token): <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>  <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>  <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    /// - On failure, responds with [`SdkError<DisassociateSubnetsError>`](crate::error::DisassociateSubnetsError)
    pub fn disassociate_subnets(&self) -> fluent_builders::DisassociateSubnets {
        fluent_builders::DisassociateSubnets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFirewallPolicies`](crate::client::fluent_builders::ListFirewallPolicies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFirewallPolicies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFirewallPolicies::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFirewallPolicies::set_next_token): <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFirewallPolicies::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFirewallPolicies::set_max_results): <p>The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// - On success, responds with [`ListFirewallPoliciesOutput`](crate::output::ListFirewallPoliciesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListFirewallPoliciesOutput::next_token): <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
    ///   - [`firewall_policies(Option<Vec<FirewallPolicyMetadata>>)`](crate::output::ListFirewallPoliciesOutput::firewall_policies): <p>The metadata for the firewall policies. Depending on your setting for max results and the number of firewall policies that you have, this might not be the full list. </p>
    /// - On failure, responds with [`SdkError<ListFirewallPoliciesError>`](crate::error::ListFirewallPoliciesError)
    pub fn list_firewall_policies(&self) -> fluent_builders::ListFirewallPolicies {
        fluent_builders::ListFirewallPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFirewalls`](crate::client::fluent_builders::ListFirewalls) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFirewalls::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFirewalls::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFirewalls::set_next_token): <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
    ///   - [`vpc_ids(Vec<String>)`](crate::client::fluent_builders::ListFirewalls::vpc_ids) / [`set_vpc_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ListFirewalls::set_vpc_ids): <p>The unique identifiers of the VPCs that you want Network Firewall to retrieve the firewalls for. Leave this blank to retrieve all firewalls that you have defined.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFirewalls::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFirewalls::set_max_results): <p>The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// - On success, responds with [`ListFirewallsOutput`](crate::output::ListFirewallsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListFirewallsOutput::next_token): <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
    ///   - [`firewalls(Option<Vec<FirewallMetadata>>)`](crate::output::ListFirewallsOutput::firewalls): <p>The firewall metadata objects for the VPCs that you specified. Depending on your setting for max results and the number of firewalls you have, a single call might not be the full list. </p>
    /// - On failure, responds with [`SdkError<ListFirewallsError>`](crate::error::ListFirewallsError)
    pub fn list_firewalls(&self) -> fluent_builders::ListFirewalls {
        fluent_builders::ListFirewalls::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRuleGroups`](crate::client::fluent_builders::ListRuleGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRuleGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRuleGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRuleGroups::set_next_token): <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRuleGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRuleGroups::set_max_results): <p>The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    ///   - [`scope(ResourceManagedStatus)`](crate::client::fluent_builders::ListRuleGroups::scope) / [`set_scope(Option<ResourceManagedStatus>)`](crate::client::fluent_builders::ListRuleGroups::set_scope): <p>The scope of the request. The default setting of <code>ACCOUNT</code> or a setting of <code>NULL</code> returns all of the rule groups in your account. A setting of <code>MANAGED</code> returns all available managed rule groups.</p>
    /// - On success, responds with [`ListRuleGroupsOutput`](crate::output::ListRuleGroupsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListRuleGroupsOutput::next_token): <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
    ///   - [`rule_groups(Option<Vec<RuleGroupMetadata>>)`](crate::output::ListRuleGroupsOutput::rule_groups): <p>The rule group metadata objects that you've defined. Depending on your setting for max results and the number of rule groups, this might not be the full list. </p>
    /// - On failure, responds with [`SdkError<ListRuleGroupsError>`](crate::error::ListRuleGroupsError)
    pub fn list_rule_groups(&self) -> fluent_builders::ListRuleGroups {
        fluent_builders::ListRuleGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTagsForResource::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTagsForResource::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTagsForResource::set_max_results): <p>The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags that are associated with the resource. </p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutResourcePolicy`](crate::client::fluent_builders::PutResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::PutResourcePolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::PutResourcePolicy::set_resource_arn): <p>The Amazon Resource Name (ARN) of the account that you want to share rule groups and firewall policies with.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutResourcePolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutResourcePolicy::set_policy): <p>The AWS Identity and Access Management policy statement that lists the accounts that you want to share your rule group or firewall policy with and the operations that you want the accounts to be able to perform. </p>  <p>For a rule group resource, you can specify the following operations in the Actions section of the statement:</p>  <ul>   <li> <p>network-firewall:CreateFirewallPolicy</p> </li>   <li> <p>network-firewall:UpdateFirewallPolicy</p> </li>   <li> <p>network-firewall:ListRuleGroups</p> </li>  </ul>  <p>For a firewall policy resource, you can specify the following operations in the Actions section of the statement:</p>  <ul>   <li> <p>network-firewall:CreateFirewall</p> </li>   <li> <p>network-firewall:UpdateFirewall</p> </li>   <li> <p>network-firewall:AssociateFirewallPolicy</p> </li>   <li> <p>network-firewall:ListFirewallPolicies</p> </li>  </ul>  <p>In the Resource section of the statement, you specify the ARNs for the rule groups and firewall policies that you want to share with the account that you specified in <code>Arn</code>.</p>
    /// - On success, responds with [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)

    /// - On failure, responds with [`SdkError<PutResourcePolicyError>`](crate::error::PutResourcePolicyError)
    pub fn put_resource_policy(&self) -> fluent_builders::PutResourcePolicy {
        fluent_builders::PutResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p></p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p></p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFirewallDeleteProtection`](crate::client::fluent_builders::UpdateFirewallDeleteProtection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`update_token(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallDeleteProtection::update_token) / [`set_update_token(Option<String>)`](crate::client::fluent_builders::UpdateFirewallDeleteProtection::set_update_token): <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>  <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>  <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    ///   - [`firewall_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallDeleteProtection::firewall_arn) / [`set_firewall_arn(Option<String>)`](crate::client::fluent_builders::UpdateFirewallDeleteProtection::set_firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`firewall_name(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallDeleteProtection::firewall_name) / [`set_firewall_name(Option<String>)`](crate::client::fluent_builders::UpdateFirewallDeleteProtection::set_firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`delete_protection(bool)`](crate::client::fluent_builders::UpdateFirewallDeleteProtection::delete_protection) / [`set_delete_protection(bool)`](crate::client::fluent_builders::UpdateFirewallDeleteProtection::set_delete_protection): <p>A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.</p>
    /// - On success, responds with [`UpdateFirewallDeleteProtectionOutput`](crate::output::UpdateFirewallDeleteProtectionOutput) with field(s):
    ///   - [`firewall_arn(Option<String>)`](crate::output::UpdateFirewallDeleteProtectionOutput::firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>
    ///   - [`firewall_name(Option<String>)`](crate::output::UpdateFirewallDeleteProtectionOutput::firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    ///   - [`delete_protection(bool)`](crate::output::UpdateFirewallDeleteProtectionOutput::delete_protection): <p>A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.</p>
    ///   - [`update_token(Option<String>)`](crate::output::UpdateFirewallDeleteProtectionOutput::update_token): <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>  <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>  <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    /// - On failure, responds with [`SdkError<UpdateFirewallDeleteProtectionError>`](crate::error::UpdateFirewallDeleteProtectionError)
    pub fn update_firewall_delete_protection(
        &self,
    ) -> fluent_builders::UpdateFirewallDeleteProtection {
        fluent_builders::UpdateFirewallDeleteProtection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFirewallDescription`](crate::client::fluent_builders::UpdateFirewallDescription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`update_token(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallDescription::update_token) / [`set_update_token(Option<String>)`](crate::client::fluent_builders::UpdateFirewallDescription::set_update_token): <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>  <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>  <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    ///   - [`firewall_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallDescription::firewall_arn) / [`set_firewall_arn(Option<String>)`](crate::client::fluent_builders::UpdateFirewallDescription::set_firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`firewall_name(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallDescription::firewall_name) / [`set_firewall_name(Option<String>)`](crate::client::fluent_builders::UpdateFirewallDescription::set_firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallDescription::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateFirewallDescription::set_description): <p>The new description for the firewall. If you omit this setting, Network Firewall removes the description for the firewall.</p>
    /// - On success, responds with [`UpdateFirewallDescriptionOutput`](crate::output::UpdateFirewallDescriptionOutput) with field(s):
    ///   - [`firewall_arn(Option<String>)`](crate::output::UpdateFirewallDescriptionOutput::firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>
    ///   - [`firewall_name(Option<String>)`](crate::output::UpdateFirewallDescriptionOutput::firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateFirewallDescriptionOutput::description): <p>A description of the firewall.</p>
    ///   - [`update_token(Option<String>)`](crate::output::UpdateFirewallDescriptionOutput::update_token): <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>  <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>  <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    /// - On failure, responds with [`SdkError<UpdateFirewallDescriptionError>`](crate::error::UpdateFirewallDescriptionError)
    pub fn update_firewall_description(&self) -> fluent_builders::UpdateFirewallDescription {
        fluent_builders::UpdateFirewallDescription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFirewallPolicy`](crate::client::fluent_builders::UpdateFirewallPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`update_token(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallPolicy::update_token) / [`set_update_token(Option<String>)`](crate::client::fluent_builders::UpdateFirewallPolicy::set_update_token): <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p>  <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>
    ///   - [`firewall_policy_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallPolicy::firewall_policy_arn) / [`set_firewall_policy_arn(Option<String>)`](crate::client::fluent_builders::UpdateFirewallPolicy::set_firewall_policy_arn): <p>The Amazon Resource Name (ARN) of the firewall policy.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`firewall_policy_name(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallPolicy::firewall_policy_name) / [`set_firewall_policy_name(Option<String>)`](crate::client::fluent_builders::UpdateFirewallPolicy::set_firewall_policy_name): <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`firewall_policy(FirewallPolicy)`](crate::client::fluent_builders::UpdateFirewallPolicy::firewall_policy) / [`set_firewall_policy(Option<FirewallPolicy>)`](crate::client::fluent_builders::UpdateFirewallPolicy::set_firewall_policy): <p>The updated firewall policy to use for the firewall. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallPolicy::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateFirewallPolicy::set_description): <p>A description of the firewall policy.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::UpdateFirewallPolicy::dry_run) / [`set_dry_run(bool)`](crate::client::fluent_builders::UpdateFirewallPolicy::set_dry_run): <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>  <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid. </p>  <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
    /// - On success, responds with [`UpdateFirewallPolicyOutput`](crate::output::UpdateFirewallPolicyOutput) with field(s):
    ///   - [`update_token(Option<String>)`](crate::output::UpdateFirewallPolicyOutput::update_token): <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p>  <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>
    ///   - [`firewall_policy_response(Option<FirewallPolicyResponse>)`](crate::output::UpdateFirewallPolicyOutput::firewall_policy_response): <p>The high-level properties of a firewall policy. This, along with the <code>FirewallPolicy</code>, define the policy. You can retrieve all objects for a firewall policy by calling <code>DescribeFirewallPolicy</code>. </p>
    /// - On failure, responds with [`SdkError<UpdateFirewallPolicyError>`](crate::error::UpdateFirewallPolicyError)
    pub fn update_firewall_policy(&self) -> fluent_builders::UpdateFirewallPolicy {
        fluent_builders::UpdateFirewallPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFirewallPolicyChangeProtection`](crate::client::fluent_builders::UpdateFirewallPolicyChangeProtection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`update_token(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallPolicyChangeProtection::update_token) / [`set_update_token(Option<String>)`](crate::client::fluent_builders::UpdateFirewallPolicyChangeProtection::set_update_token): <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>  <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>  <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    ///   - [`firewall_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallPolicyChangeProtection::firewall_arn) / [`set_firewall_arn(Option<String>)`](crate::client::fluent_builders::UpdateFirewallPolicyChangeProtection::set_firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`firewall_name(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallPolicyChangeProtection::firewall_name) / [`set_firewall_name(Option<String>)`](crate::client::fluent_builders::UpdateFirewallPolicyChangeProtection::set_firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`firewall_policy_change_protection(bool)`](crate::client::fluent_builders::UpdateFirewallPolicyChangeProtection::firewall_policy_change_protection) / [`set_firewall_policy_change_protection(bool)`](crate::client::fluent_builders::UpdateFirewallPolicyChangeProtection::set_firewall_policy_change_protection): <p>A setting indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
    /// - On success, responds with [`UpdateFirewallPolicyChangeProtectionOutput`](crate::output::UpdateFirewallPolicyChangeProtectionOutput) with field(s):
    ///   - [`update_token(Option<String>)`](crate::output::UpdateFirewallPolicyChangeProtectionOutput::update_token): <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>  <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>  <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    ///   - [`firewall_arn(Option<String>)`](crate::output::UpdateFirewallPolicyChangeProtectionOutput::firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>
    ///   - [`firewall_name(Option<String>)`](crate::output::UpdateFirewallPolicyChangeProtectionOutput::firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    ///   - [`firewall_policy_change_protection(bool)`](crate::output::UpdateFirewallPolicyChangeProtectionOutput::firewall_policy_change_protection): <p>A setting indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateFirewallPolicyChangeProtectionError>`](crate::error::UpdateFirewallPolicyChangeProtectionError)
    pub fn update_firewall_policy_change_protection(
        &self,
    ) -> fluent_builders::UpdateFirewallPolicyChangeProtection {
        fluent_builders::UpdateFirewallPolicyChangeProtection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLoggingConfiguration`](crate::client::fluent_builders::UpdateLoggingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateLoggingConfiguration::firewall_arn) / [`set_firewall_arn(Option<String>)`](crate::client::fluent_builders::UpdateLoggingConfiguration::set_firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`firewall_name(impl Into<String>)`](crate::client::fluent_builders::UpdateLoggingConfiguration::firewall_name) / [`set_firewall_name(Option<String>)`](crate::client::fluent_builders::UpdateLoggingConfiguration::set_firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`logging_configuration(LoggingConfiguration)`](crate::client::fluent_builders::UpdateLoggingConfiguration::logging_configuration) / [`set_logging_configuration(Option<LoggingConfiguration>)`](crate::client::fluent_builders::UpdateLoggingConfiguration::set_logging_configuration): <p>Defines how Network Firewall performs logging for a firewall. If you omit this setting, Network Firewall disables logging for the firewall.</p>
    /// - On success, responds with [`UpdateLoggingConfigurationOutput`](crate::output::UpdateLoggingConfigurationOutput) with field(s):
    ///   - [`firewall_arn(Option<String>)`](crate::output::UpdateLoggingConfigurationOutput::firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>
    ///   - [`firewall_name(Option<String>)`](crate::output::UpdateLoggingConfigurationOutput::firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    ///   - [`logging_configuration(Option<LoggingConfiguration>)`](crate::output::UpdateLoggingConfigurationOutput::logging_configuration): <p>Defines how AWS Network Firewall performs logging for a <code>Firewall</code>. </p>
    /// - On failure, responds with [`SdkError<UpdateLoggingConfigurationError>`](crate::error::UpdateLoggingConfigurationError)
    pub fn update_logging_configuration(&self) -> fluent_builders::UpdateLoggingConfiguration {
        fluent_builders::UpdateLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRuleGroup`](crate::client::fluent_builders::UpdateRuleGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`update_token(impl Into<String>)`](crate::client::fluent_builders::UpdateRuleGroup::update_token) / [`set_update_token(Option<String>)`](crate::client::fluent_builders::UpdateRuleGroup::set_update_token): <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p>  <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>
    ///   - [`rule_group_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateRuleGroup::rule_group_arn) / [`set_rule_group_arn(Option<String>)`](crate::client::fluent_builders::UpdateRuleGroup::set_rule_group_arn): <p>The Amazon Resource Name (ARN) of the rule group.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`rule_group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateRuleGroup::rule_group_name) / [`set_rule_group_name(Option<String>)`](crate::client::fluent_builders::UpdateRuleGroup::set_rule_group_name): <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`rule_group(RuleGroup)`](crate::client::fluent_builders::UpdateRuleGroup::rule_group) / [`set_rule_group(Option<RuleGroup>)`](crate::client::fluent_builders::UpdateRuleGroup::set_rule_group): <p>An object that defines the rule group rules. </p> <note>   <p>You must provide either this rule group setting or a <code>Rules</code> setting, but not both. </p>  </note>
    ///   - [`rules(impl Into<String>)`](crate::client::fluent_builders::UpdateRuleGroup::rules) / [`set_rules(Option<String>)`](crate::client::fluent_builders::UpdateRuleGroup::set_rules): <p>A string containing stateful rule group rules specifications in Suricata flat format, with one rule per line. Use this to import your existing Suricata compatible rule groups. </p> <note>   <p>You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not both. </p>  </note>  <p>You can provide your rule group specification in Suricata flat format through this setting when you create or update your rule group. The call response returns a <code>RuleGroup</code> object that Network Firewall has populated from your string. </p>
    ///   - [`r#type(RuleGroupType)`](crate::client::fluent_builders::UpdateRuleGroup::type) / [`set_type(Option<RuleGroupType>)`](crate::client::fluent_builders::UpdateRuleGroup::set_type): <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p> <note>   <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p>  </note>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateRuleGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateRuleGroup::set_description): <p>A description of the rule group. </p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::UpdateRuleGroup::dry_run) / [`set_dry_run(bool)`](crate::client::fluent_builders::UpdateRuleGroup::set_dry_run): <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>  <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid. </p>  <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
    /// - On success, responds with [`UpdateRuleGroupOutput`](crate::output::UpdateRuleGroupOutput) with field(s):
    ///   - [`update_token(Option<String>)`](crate::output::UpdateRuleGroupOutput::update_token): <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p>  <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>
    ///   - [`rule_group_response(Option<RuleGroupResponse>)`](crate::output::UpdateRuleGroupOutput::rule_group_response): <p>The high-level properties of a rule group. This, along with the <code>RuleGroup</code>, define the rule group. You can retrieve all objects for a rule group by calling <code>DescribeRuleGroup</code>. </p>
    /// - On failure, responds with [`SdkError<UpdateRuleGroupError>`](crate::error::UpdateRuleGroupError)
    pub fn update_rule_group(&self) -> fluent_builders::UpdateRuleGroup {
        fluent_builders::UpdateRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSubnetChangeProtection`](crate::client::fluent_builders::UpdateSubnetChangeProtection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`update_token(impl Into<String>)`](crate::client::fluent_builders::UpdateSubnetChangeProtection::update_token) / [`set_update_token(Option<String>)`](crate::client::fluent_builders::UpdateSubnetChangeProtection::set_update_token): <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>  <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>  <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    ///   - [`firewall_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateSubnetChangeProtection::firewall_arn) / [`set_firewall_arn(Option<String>)`](crate::client::fluent_builders::UpdateSubnetChangeProtection::set_firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`firewall_name(impl Into<String>)`](crate::client::fluent_builders::UpdateSubnetChangeProtection::firewall_name) / [`set_firewall_name(Option<String>)`](crate::client::fluent_builders::UpdateSubnetChangeProtection::set_firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>  <p>You must specify the ARN or the name, and you can specify both. </p>
    ///   - [`subnet_change_protection(bool)`](crate::client::fluent_builders::UpdateSubnetChangeProtection::subnet_change_protection) / [`set_subnet_change_protection(bool)`](crate::client::fluent_builders::UpdateSubnetChangeProtection::set_subnet_change_protection): <p>A setting indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
    /// - On success, responds with [`UpdateSubnetChangeProtectionOutput`](crate::output::UpdateSubnetChangeProtectionOutput) with field(s):
    ///   - [`update_token(Option<String>)`](crate::output::UpdateSubnetChangeProtectionOutput::update_token): <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>  <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>  <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    ///   - [`firewall_arn(Option<String>)`](crate::output::UpdateSubnetChangeProtectionOutput::firewall_arn): <p>The Amazon Resource Name (ARN) of the firewall.</p>
    ///   - [`firewall_name(Option<String>)`](crate::output::UpdateSubnetChangeProtectionOutput::firewall_name): <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    ///   - [`subnet_change_protection(bool)`](crate::output::UpdateSubnetChangeProtectionOutput::subnet_change_protection): <p>A setting indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateSubnetChangeProtectionError>`](crate::error::UpdateSubnetChangeProtectionError)
    pub fn update_subnet_change_protection(&self) -> fluent_builders::UpdateSubnetChangeProtection {
        fluent_builders::UpdateSubnetChangeProtection::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateFirewallPolicy`.
    ///
    /// <p>Associates a <code>FirewallPolicy</code> to a <code>Firewall</code>. </p>
    /// <p>A firewall policy defines how to monitor and manage your VPC network traffic, using a collection of inspection rule groups and other settings. Each firewall requires one firewall policy association, and you can use the same firewall policy for multiple firewalls. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateFirewallPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_firewall_policy_input::Builder,
    }
    impl AssociateFirewallPolicy {
        /// Creates a new `AssociateFirewallPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateFirewallPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateFirewallPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(input.into());
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        pub fn firewall_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_policy_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        pub fn set_firewall_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateSubnets`.
    ///
    /// <p>Associates the specified subnets in the Amazon VPC to the firewall. You can specify one subnet for each of the Availability Zones that the VPC spans. </p>
    /// <p>This request creates an AWS Network Firewall firewall endpoint in each of the subnets. To enable the firewall's protections, you must also modify the VPC's route tables for each subnet's Availability Zone, to redirect the traffic that's coming into and going out of the zone through the firewall endpoint. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateSubnets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_subnets_input::Builder,
    }
    impl AssociateSubnets {
        /// Creates a new `AssociateSubnets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateSubnetsOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateSubnetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(input.into());
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// Appends an item to `SubnetMappings`.
        ///
        /// To override the contents of this collection use [`set_subnet_mappings`](Self::set_subnet_mappings).
        ///
        /// <p>The IDs of the subnets that you want to associate with the firewall. </p>
        pub fn subnet_mappings(mut self, input: crate::model::SubnetMapping) -> Self {
            self.inner = self.inner.subnet_mappings(input);
            self
        }
        /// <p>The IDs of the subnets that you want to associate with the firewall. </p>
        pub fn set_subnet_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_mappings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFirewall`.
    ///
    /// <p>Creates an AWS Network Firewall <code>Firewall</code> and accompanying <code>FirewallStatus</code> for a VPC. </p>
    /// <p>The firewall defines the configuration settings for an AWS Network Firewall firewall. The settings that you can define at creation include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and any tags that are attached to the firewall AWS resource. </p>
    /// <p>After you create a firewall, you can provide additional settings, like the logging configuration. </p>
    /// <p>To update the settings for a firewall, you use the operations that apply to the settings themselves, for example <code>UpdateLoggingConfiguration</code>, <code>AssociateSubnets</code>, and <code>UpdateFirewallDeleteProtection</code>. </p>
    /// <p>To manage a firewall's tags, use the standard AWS resource tagging operations, <code>ListTagsForResource</code>, <code>TagResource</code>, and <code>UntagResource</code>.</p>
    /// <p>To retrieve information about firewalls, use <code>ListFirewalls</code> and <code>DescribeFirewall</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFirewall {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_firewall_input::Builder,
    }
    impl CreateFirewall {
        /// Creates a new `CreateFirewall`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFirewallOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFirewallError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <code>FirewallPolicy</code> that you want to use for the firewall.</p>
        pub fn firewall_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_policy_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <code>FirewallPolicy</code> that you want to use for the firewall.</p>
        pub fn set_firewall_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_arn(input);
            self
        }
        /// <p>The unique identifier of the VPC where Network Firewall should create the firewall. </p>
        /// <p>You can't change this setting after you create the firewall. </p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The unique identifier of the VPC where Network Firewall should create the firewall. </p>
        /// <p>You can't change this setting after you create the firewall. </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// Appends an item to `SubnetMappings`.
        ///
        /// To override the contents of this collection use [`set_subnet_mappings`](Self::set_subnet_mappings).
        ///
        /// <p>The public subnets to use for your Network Firewall firewalls. Each subnet must belong to a different Availability Zone in the VPC. Network Firewall creates a firewall endpoint in each subnet. </p>
        pub fn subnet_mappings(mut self, input: crate::model::SubnetMapping) -> Self {
            self.inner = self.inner.subnet_mappings(input);
            self
        }
        /// <p>The public subnets to use for your Network Firewall firewalls. Each subnet must belong to a different Availability Zone in the VPC. Network Firewall creates a firewall endpoint in each subnet. </p>
        pub fn set_subnet_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_mappings(input);
            self
        }
        /// <p>A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.</p>
        pub fn delete_protection(mut self, input: bool) -> Self {
            self.inner = self.inner.delete_protection(input);
            self
        }
        /// <p>A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.</p>
        pub fn set_delete_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_protection(input);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn subnet_change_protection(mut self, input: bool) -> Self {
            self.inner = self.inner.subnet_change_protection(input);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn set_subnet_change_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_subnet_change_protection(input);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn firewall_policy_change_protection(mut self, input: bool) -> Self {
            self.inner = self.inner.firewall_policy_change_protection(input);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn set_firewall_policy_change_protection(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_change_protection(input);
            self
        }
        /// <p>A description of the firewall.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the firewall.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key:value pairs to associate with the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The key:value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFirewallPolicy`.
    ///
    /// <p>Creates the firewall policy for the firewall according to the specifications. </p>
    /// <p>An AWS Network Firewall firewall policy defines the behavior of a firewall, in a collection of stateless and stateful rule groups and other settings. You can use one firewall policy for multiple firewalls. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFirewallPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_firewall_policy_input::Builder,
    }
    impl CreateFirewallPolicy {
        /// Creates a new `CreateFirewallPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFirewallPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFirewallPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        pub fn firewall_policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_policy_name(input.into());
            self
        }
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        pub fn set_firewall_policy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_name(input);
            self
        }
        /// <p>The rule groups and policy actions to use in the firewall policy.</p>
        pub fn firewall_policy(mut self, input: crate::model::FirewallPolicy) -> Self {
            self.inner = self.inner.firewall_policy(input);
            self
        }
        /// <p>The rule groups and policy actions to use in the firewall policy.</p>
        pub fn set_firewall_policy(
            mut self,
            input: std::option::Option<crate::model::FirewallPolicy>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy(input);
            self
        }
        /// <p>A description of the firewall policy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the firewall policy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key:value pairs to associate with the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The key:value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>
        /// <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid. </p>
        /// <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>
        /// <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid. </p>
        /// <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRuleGroup`.
    ///
    /// <p>Creates the specified stateless or stateful rule group, which includes the rules for network traffic inspection, a capacity setting, and tags. </p>
    /// <p>You provide your rule group specification in your request using either <code>RuleGroup</code> or <code>Rules</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRuleGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_rule_group_input::Builder,
    }
    impl CreateRuleGroup {
        /// Creates a new `CreateRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRuleGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        pub fn rule_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_name(input.into());
            self
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        pub fn set_rule_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_name(input);
            self
        }
        /// <p>An object that defines the rule group rules. </p> <note>
        /// <p>You must provide either this rule group setting or a <code>Rules</code> setting, but not both. </p>
        /// </note>
        pub fn rule_group(mut self, input: crate::model::RuleGroup) -> Self {
            self.inner = self.inner.rule_group(input);
            self
        }
        /// <p>An object that defines the rule group rules. </p> <note>
        /// <p>You must provide either this rule group setting or a <code>Rules</code> setting, but not both. </p>
        /// </note>
        pub fn set_rule_group(
            mut self,
            input: std::option::Option<crate::model::RuleGroup>,
        ) -> Self {
            self.inner = self.inner.set_rule_group(input);
            self
        }
        /// <p>A string containing stateful rule group rules specifications in Suricata flat format, with one rule per line. Use this to import your existing Suricata compatible rule groups. </p> <note>
        /// <p>You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not both. </p>
        /// </note>
        /// <p>You can provide your rule group specification in Suricata flat format through this setting when you create or update your rule group. The call response returns a <code>RuleGroup</code> object that Network Firewall has populated from your string. </p>
        pub fn rules(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rules(input.into());
            self
        }
        /// <p>A string containing stateful rule group rules specifications in Suricata flat format, with one rule per line. Use this to import your existing Suricata compatible rule groups. </p> <note>
        /// <p>You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not both. </p>
        /// </note>
        /// <p>You can provide your rule group specification in Suricata flat format through this setting when you create or update your rule group. The call response returns a <code>RuleGroup</code> object that Network Firewall has populated from your string. </p>
        pub fn set_rules(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p>
        pub fn r#type(mut self, input: crate::model::RuleGroupType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RuleGroupType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>A description of the rule group. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the rule group. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy, Network Firewall reserves this capacity for the rule group. </p>
        /// <p>You can retrieve the capacity that would be required for a rule group before you create the rule group by calling <code>CreateRuleGroup</code> with <code>DryRun</code> set to <code>TRUE</code>. </p> <note>
        /// <p>You can't change or exceed this capacity when you update the rule group, so leave room for your rule group to grow. </p>
        /// </note>
        /// <p> <b>Capacity for a stateless rule group</b> </p>
        /// <p>For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual rules that you expect to have in the rule group. </p>
        /// <p>To calculate the capacity requirement of a single rule, multiply the capacity requirement values of each of the rule's match settings:</p>
        /// <ul>
        /// <li> <p>A match setting with no criteria specified has a value of 1. </p> </li>
        /// <li> <p>A match setting with <code>Any</code> specified has a value of 1. </p> </li>
        /// <li> <p>All other match settings have a value equal to the number of elements provided in the setting. For example, a protocol setting ["UDP"] and a source setting ["10.0.0.0/24"] each have a value of 1. A protocol setting ["UDP","TCP"] has a value of 2. A source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"] has a value of 3. </p> </li>
        /// </ul>
        /// <p>A rule with no criteria specified in any of its match settings has a capacity requirement of 1. A rule with protocol setting ["UDP","TCP"], source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"], and a single specification or no specification for each of the other match settings has a capacity requirement of 6. </p>
        /// <p> <b>Capacity for a stateful rule group</b> </p>
        /// <p>For a stateful rule group, the minimum capacity required is the number of individual rules that you expect to have in the rule group. </p>
        pub fn capacity(mut self, input: i32) -> Self {
            self.inner = self.inner.capacity(input);
            self
        }
        /// <p>The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy, Network Firewall reserves this capacity for the rule group. </p>
        /// <p>You can retrieve the capacity that would be required for a rule group before you create the rule group by calling <code>CreateRuleGroup</code> with <code>DryRun</code> set to <code>TRUE</code>. </p> <note>
        /// <p>You can't change or exceed this capacity when you update the rule group, so leave room for your rule group to grow. </p>
        /// </note>
        /// <p> <b>Capacity for a stateless rule group</b> </p>
        /// <p>For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual rules that you expect to have in the rule group. </p>
        /// <p>To calculate the capacity requirement of a single rule, multiply the capacity requirement values of each of the rule's match settings:</p>
        /// <ul>
        /// <li> <p>A match setting with no criteria specified has a value of 1. </p> </li>
        /// <li> <p>A match setting with <code>Any</code> specified has a value of 1. </p> </li>
        /// <li> <p>All other match settings have a value equal to the number of elements provided in the setting. For example, a protocol setting ["UDP"] and a source setting ["10.0.0.0/24"] each have a value of 1. A protocol setting ["UDP","TCP"] has a value of 2. A source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"] has a value of 3. </p> </li>
        /// </ul>
        /// <p>A rule with no criteria specified in any of its match settings has a capacity requirement of 1. A rule with protocol setting ["UDP","TCP"], source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"], and a single specification or no specification for each of the other match settings has a capacity requirement of 6. </p>
        /// <p> <b>Capacity for a stateful rule group</b> </p>
        /// <p>For a stateful rule group, the minimum capacity required is the number of individual rules that you expect to have in the rule group. </p>
        pub fn set_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_capacity(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key:value pairs to associate with the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The key:value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>
        /// <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid. </p>
        /// <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>
        /// <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid. </p>
        /// <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFirewall`.
    ///
    /// <p>Deletes the specified <code>Firewall</code> and its <code>FirewallStatus</code>. This operation requires the firewall's <code>DeleteProtection</code> flag to be <code>FALSE</code>. You can't revert this operation. </p>
    /// <p>You can check whether a firewall is in use by reviewing the route tables for the Availability Zones where you have firewall subnet mappings. Retrieve the subnet mappings by calling <code>DescribeFirewall</code>. You define and update the route tables through Amazon VPC. As needed, update the route tables for the zones to remove the firewall endpoints. When the route tables no longer use the firewall endpoints, you can remove the firewall safely.</p>
    /// <p>To delete a firewall, remove the delete protection if you need to using <code>UpdateFirewallDeleteProtection</code>, then delete the firewall by calling <code>DeleteFirewall</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFirewall {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_firewall_input::Builder,
    }
    impl DeleteFirewall {
        /// Creates a new `DeleteFirewall`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFirewallOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFirewallError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFirewallPolicy`.
    ///
    /// <p>Deletes the specified <code>FirewallPolicy</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFirewallPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_firewall_policy_input::Builder,
    }
    impl DeleteFirewallPolicy {
        /// Creates a new `DeleteFirewallPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFirewallPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFirewallPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_policy_name(input.into());
            self
        }
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_policy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_policy_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourcePolicy`.
    ///
    /// <p>Deletes a resource policy that you created in a <code>PutResourcePolicy</code> request. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_resource_policy_input::Builder,
    }
    impl DeleteResourcePolicy {
        /// Creates a new `DeleteResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group or firewall policy whose resource policy you want to delete. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group or firewall policy whose resource policy you want to delete. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRuleGroup`.
    ///
    /// <p>Deletes the specified <code>RuleGroup</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRuleGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_rule_group_input::Builder,
    }
    impl DeleteRuleGroup {
        /// Creates a new `DeleteRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRuleGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn rule_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_name(input.into());
            self
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_rule_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn rule_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_rule_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_arn(input);
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p> <note>
        /// <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p>
        /// </note>
        pub fn r#type(mut self, input: crate::model::RuleGroupType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p> <note>
        /// <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p>
        /// </note>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RuleGroupType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFirewall`.
    ///
    /// <p>Returns the data objects for the specified firewall. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFirewall {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_firewall_input::Builder,
    }
    impl DescribeFirewall {
        /// Creates a new `DescribeFirewall`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFirewallOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFirewallError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFirewallPolicy`.
    ///
    /// <p>Returns the data objects for the specified firewall policy. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFirewallPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_firewall_policy_input::Builder,
    }
    impl DescribeFirewallPolicy {
        /// Creates a new `DescribeFirewallPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFirewallPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFirewallPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_policy_name(input.into());
            self
        }
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_policy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_policy_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoggingConfiguration`.
    ///
    /// <p>Returns the logging configuration for the specified firewall. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLoggingConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_logging_configuration_input::Builder,
    }
    impl DescribeLoggingConfiguration {
        /// Creates a new `DescribeLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoggingConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResourcePolicy`.
    ///
    /// <p>Retrieves a resource policy that you created in a <code>PutResourcePolicy</code> request. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_resource_policy_input::Builder,
    }
    impl DescribeResourcePolicy {
        /// Creates a new `DescribeResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group or firewall policy whose resource policy you want to retrieve. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group or firewall policy whose resource policy you want to retrieve. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRuleGroup`.
    ///
    /// <p>Returns the data objects for the specified rule group. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRuleGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_rule_group_input::Builder,
    }
    impl DescribeRuleGroup {
        /// Creates a new `DescribeRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRuleGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn rule_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_name(input.into());
            self
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_rule_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn rule_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_rule_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_arn(input);
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p> <note>
        /// <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p>
        /// </note>
        pub fn r#type(mut self, input: crate::model::RuleGroupType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p> <note>
        /// <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p>
        /// </note>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RuleGroupType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRuleGroupMetadata`.
    ///
    /// <p>High-level information about a rule group, returned by operations like create and describe. You can use the information provided in the metadata to retrieve and manage a rule group. You can retrieve all objects for a rule group by calling <code>DescribeRuleGroup</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRuleGroupMetadata {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_rule_group_metadata_input::Builder,
    }
    impl DescribeRuleGroupMetadata {
        /// Creates a new `DescribeRuleGroupMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRuleGroupMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRuleGroupMetadataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn rule_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_name(input.into());
            self
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_rule_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_name(input);
            self
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn rule_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_arn(input.into());
            self
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_rule_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_arn(input);
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p> <note>
        /// <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p>
        /// </note>
        pub fn r#type(mut self, input: crate::model::RuleGroupType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p> <note>
        /// <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p>
        /// </note>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RuleGroupType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateSubnets`.
    ///
    /// <p>Removes the specified subnet associations from the firewall. This removes the firewall endpoints from the subnets and removes any network filtering protections that the endpoints were providing. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateSubnets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_subnets_input::Builder,
    }
    impl DisassociateSubnets {
        /// Creates a new `DisassociateSubnets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateSubnetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateSubnetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(input.into());
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The unique identifiers for the subnets that you want to disassociate. </p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>The unique identifiers for the subnets that you want to disassociate. </p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFirewallPolicies`.
    ///
    /// <p>Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results and the number of firewall policies, a single call might not return the full list. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFirewallPolicies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_firewall_policies_input::Builder,
    }
    impl ListFirewallPolicies {
        /// Creates a new `ListFirewallPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFirewallPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFirewallPoliciesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFirewallPoliciesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFirewallPoliciesPaginator {
            crate::paginator::ListFirewallPoliciesPaginator::new(self.handle, self.inner)
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFirewalls`.
    ///
    /// <p>Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request, this returns only the firewalls for those VPCs.</p>
    /// <p>Depending on your setting for max results and the number of firewalls, a single call might not return the full list. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFirewalls {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_firewalls_input::Builder,
    }
    impl ListFirewalls {
        /// Creates a new `ListFirewalls`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFirewallsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFirewallsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFirewallsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFirewallsPaginator {
            crate::paginator::ListFirewallsPaginator::new(self.handle, self.inner)
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `VpcIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_ids`](Self::set_vpc_ids).
        ///
        /// <p>The unique identifiers of the VPCs that you want Network Firewall to retrieve the firewalls for. Leave this blank to retrieve all firewalls that you have defined.</p>
        pub fn vpc_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_ids(input.into());
            self
        }
        /// <p>The unique identifiers of the VPCs that you want Network Firewall to retrieve the firewalls for. Leave this blank to retrieve all firewalls that you have defined.</p>
        pub fn set_vpc_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_ids(input);
            self
        }
        /// <p>The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRuleGroups`.
    ///
    /// <p>Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and the number of rule groups, a single call might not return the full list. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRuleGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_rule_groups_input::Builder,
    }
    impl ListRuleGroups {
        /// Creates a new `ListRuleGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRuleGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRuleGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRuleGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRuleGroupsPaginator {
            crate::paginator::ListRuleGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The scope of the request. The default setting of <code>ACCOUNT</code> or a setting of <code>NULL</code> returns all of the rule groups in your account. A setting of <code>MANAGED</code> returns all available managed rule groups.</p>
        pub fn scope(mut self, input: crate::model::ResourceManagedStatus) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>The scope of the request. The default setting of <code>ACCOUNT</code> or a setting of <code>NULL</code> returns all of the rule groups in your account. A setting of <code>MANAGED</code> returns all available managed rule groups.</p>
        pub fn set_scope(
            mut self,
            input: std::option::Option<crate::model::ResourceManagedStatus>,
        ) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each AWS resource, up to 50 tags for a resource.</p>
    /// <p>You can tag the AWS resources that you manage through AWS Network Firewall: firewalls, firewall policies, and rule groups. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagsForResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagsForResourcePaginator {
            crate::paginator::ListTagsForResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutResourcePolicy`.
    ///
    /// <p>Creates or updates an AWS Identity and Access Management policy for your rule group or firewall policy. Use this to share rule groups and firewall policies between accounts. This operation works in conjunction with the AWS Resource Access Manager (RAM) service to manage resource sharing for Network Firewall. </p>
    /// <p>Use this operation to create or update a resource policy for your rule group or firewall policy. In the policy, you specify the accounts that you want to share the resource with and the operations that you want the accounts to be able to perform. </p>
    /// <p>When you add an account in the resource policy, you then run the following Resource Access Manager (RAM) operations to access and accept the shared rule group or firewall policy. </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareInvitations.html">GetResourceShareInvitations</a> - Returns the Amazon Resource Names (ARNs) of the resource share invitations. </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_AcceptResourceShareInvitation.html">AcceptResourceShareInvitation</a> - Accepts the share invitation for a specified resource share. </p> </li>
    /// </ul>
    /// <p>For additional information about resource sharing using RAM, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/what-is.html">AWS Resource Access Manager User Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_resource_policy_input::Builder,
    }
    impl PutResourcePolicy {
        /// Creates a new `PutResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the account that you want to share rule groups and firewall policies with.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the account that you want to share rule groups and firewall policies with.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The AWS Identity and Access Management policy statement that lists the accounts that you want to share your rule group or firewall policy with and the operations that you want the accounts to be able to perform. </p>
        /// <p>For a rule group resource, you can specify the following operations in the Actions section of the statement:</p>
        /// <ul>
        /// <li> <p>network-firewall:CreateFirewallPolicy</p> </li>
        /// <li> <p>network-firewall:UpdateFirewallPolicy</p> </li>
        /// <li> <p>network-firewall:ListRuleGroups</p> </li>
        /// </ul>
        /// <p>For a firewall policy resource, you can specify the following operations in the Actions section of the statement:</p>
        /// <ul>
        /// <li> <p>network-firewall:CreateFirewall</p> </li>
        /// <li> <p>network-firewall:UpdateFirewall</p> </li>
        /// <li> <p>network-firewall:AssociateFirewallPolicy</p> </li>
        /// <li> <p>network-firewall:ListFirewallPolicies</p> </li>
        /// </ul>
        /// <p>In the Resource section of the statement, you specify the ARNs for the rule groups and firewall policies that you want to share with the account that you specified in <code>Arn</code>.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The AWS Identity and Access Management policy statement that lists the accounts that you want to share your rule group or firewall policy with and the operations that you want the accounts to be able to perform. </p>
        /// <p>For a rule group resource, you can specify the following operations in the Actions section of the statement:</p>
        /// <ul>
        /// <li> <p>network-firewall:CreateFirewallPolicy</p> </li>
        /// <li> <p>network-firewall:UpdateFirewallPolicy</p> </li>
        /// <li> <p>network-firewall:ListRuleGroups</p> </li>
        /// </ul>
        /// <p>For a firewall policy resource, you can specify the following operations in the Actions section of the statement:</p>
        /// <ul>
        /// <li> <p>network-firewall:CreateFirewall</p> </li>
        /// <li> <p>network-firewall:UpdateFirewall</p> </li>
        /// <li> <p>network-firewall:AssociateFirewallPolicy</p> </li>
        /// <li> <p>network-firewall:ListFirewallPolicies</p> </li>
        /// </ul>
        /// <p>In the Resource section of the statement, you specify the ARNs for the rule groups and firewall policies that you want to share with the account that you specified in <code>Arn</code>.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds the specified tags to the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each AWS resource, up to 50 tags for a resource.</p>
    /// <p>You can tag the AWS resources that you manage through AWS Network Firewall: firewalls, firewall policies, and rule groups. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p></p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p></p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the tags with the specified keys from the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each AWS resource, up to 50 tags for a resource.</p>
    /// <p>You can manage tags for the AWS resources that you manage through AWS Network Firewall: firewalls, firewall policies, and rule groups. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p></p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p></p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFirewallDeleteProtection`.
    ///
    /// <p>Modifies the flag, <code>DeleteProtection</code>, which indicates whether it is possible to delete the firewall. If the flag is set to <code>TRUE</code>, the firewall is protected against deletion. This setting helps protect against accidentally deleting a firewall that's in use. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFirewallDeleteProtection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_firewall_delete_protection_input::Builder,
    }
    impl UpdateFirewallDeleteProtection {
        /// Creates a new `UpdateFirewallDeleteProtection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFirewallDeleteProtectionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFirewallDeleteProtectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(input.into());
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// <p>A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.</p>
        pub fn delete_protection(mut self, input: bool) -> Self {
            self.inner = self.inner.delete_protection(input);
            self
        }
        /// <p>A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.</p>
        pub fn set_delete_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_protection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFirewallDescription`.
    ///
    /// <p>Modifies the description for the specified firewall. Use the description to help you identify the firewall when you're working with it. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFirewallDescription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_firewall_description_input::Builder,
    }
    impl UpdateFirewallDescription {
        /// Creates a new `UpdateFirewallDescription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFirewallDescriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFirewallDescriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(input.into());
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// <p>The new description for the firewall. If you omit this setting, Network Firewall removes the description for the firewall.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The new description for the firewall. If you omit this setting, Network Firewall removes the description for the firewall.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFirewallPolicy`.
    ///
    /// <p>Updates the properties of the specified firewall policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFirewallPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_firewall_policy_input::Builder,
    }
    impl UpdateFirewallPolicy {
        /// Creates a new `UpdateFirewallPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFirewallPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFirewallPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p>
        /// <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p>
        /// <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_policy_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_policy_name(input.into());
            self
        }
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_policy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_name(input);
            self
        }
        /// <p>The updated firewall policy to use for the firewall. </p>
        pub fn firewall_policy(mut self, input: crate::model::FirewallPolicy) -> Self {
            self.inner = self.inner.firewall_policy(input);
            self
        }
        /// <p>The updated firewall policy to use for the firewall. </p>
        pub fn set_firewall_policy(
            mut self,
            input: std::option::Option<crate::model::FirewallPolicy>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy(input);
            self
        }
        /// <p>A description of the firewall policy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the firewall policy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>
        /// <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid. </p>
        /// <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>
        /// <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid. </p>
        /// <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFirewallPolicyChangeProtection`.
    ///
    /// <p>Modifies the flag, <code>ChangeProtection</code>, which indicates whether it is possible to change the firewall. If the flag is set to <code>TRUE</code>, the firewall is protected from changes. This setting helps protect against accidentally changing a firewall that's in use.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFirewallPolicyChangeProtection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_firewall_policy_change_protection_input::Builder,
    }
    impl UpdateFirewallPolicyChangeProtection {
        /// Creates a new `UpdateFirewallPolicyChangeProtection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFirewallPolicyChangeProtectionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateFirewallPolicyChangeProtectionError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(input.into());
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn firewall_policy_change_protection(mut self, input: bool) -> Self {
            self.inner = self.inner.firewall_policy_change_protection(input);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn set_firewall_policy_change_protection(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_change_protection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLoggingConfiguration`.
    ///
    /// <p>Sets the logging configuration for the specified firewall. </p>
    /// <p>To change the logging configuration, retrieve the <code>LoggingConfiguration</code> by calling <code>DescribeLoggingConfiguration</code>, then change it and provide the modified object to this update call. You must change the logging configuration one <code>LogDestinationConfig</code> at a time inside the retrieved <code>LoggingConfiguration</code> object. </p>
    /// <p>You can perform only one of the following actions in any call to <code>UpdateLoggingConfiguration</code>: </p>
    /// <ul>
    /// <li> <p>Create a new log destination object by adding a single <code>LogDestinationConfig</code> array element to <code>LogDestinationConfigs</code>.</p> </li>
    /// <li> <p>Delete a log destination object by removing a single <code>LogDestinationConfig</code> array element from <code>LogDestinationConfigs</code>.</p> </li>
    /// <li> <p>Change the <code>LogDestination</code> setting in a single <code>LogDestinationConfig</code> array element.</p> </li>
    /// </ul>
    /// <p>You can't change the <code>LogDestinationType</code> or <code>LogType</code> in a <code>LogDestinationConfig</code>. To change these settings, delete the existing <code>LogDestinationConfig</code> object and create a new one, using two separate calls to this update operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLoggingConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_logging_configuration_input::Builder,
    }
    impl UpdateLoggingConfiguration {
        /// Creates a new `UpdateLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLoggingConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// <p>Defines how Network Firewall performs logging for a firewall. If you omit this setting, Network Firewall disables logging for the firewall.</p>
        pub fn logging_configuration(mut self, input: crate::model::LoggingConfiguration) -> Self {
            self.inner = self.inner.logging_configuration(input);
            self
        }
        /// <p>Defines how Network Firewall performs logging for a firewall. If you omit this setting, Network Firewall disables logging for the firewall.</p>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_logging_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRuleGroup`.
    ///
    /// <p>Updates the rule settings for the specified rule group. You use a rule group by reference in one or more firewall policies. When you modify a rule group, you modify all firewall policies that use the rule group. </p>
    /// <p>To update a rule group, first call <code>DescribeRuleGroup</code> to retrieve the current <code>RuleGroup</code> object, update the object as needed, and then provide the updated object to this call. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRuleGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_rule_group_input::Builder,
    }
    impl UpdateRuleGroup {
        /// Creates a new `UpdateRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRuleGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p>
        /// <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p>
        /// <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn rule_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_rule_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_arn(input);
            self
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn rule_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_name(input.into());
            self
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_rule_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_name(input);
            self
        }
        /// <p>An object that defines the rule group rules. </p> <note>
        /// <p>You must provide either this rule group setting or a <code>Rules</code> setting, but not both. </p>
        /// </note>
        pub fn rule_group(mut self, input: crate::model::RuleGroup) -> Self {
            self.inner = self.inner.rule_group(input);
            self
        }
        /// <p>An object that defines the rule group rules. </p> <note>
        /// <p>You must provide either this rule group setting or a <code>Rules</code> setting, but not both. </p>
        /// </note>
        pub fn set_rule_group(
            mut self,
            input: std::option::Option<crate::model::RuleGroup>,
        ) -> Self {
            self.inner = self.inner.set_rule_group(input);
            self
        }
        /// <p>A string containing stateful rule group rules specifications in Suricata flat format, with one rule per line. Use this to import your existing Suricata compatible rule groups. </p> <note>
        /// <p>You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not both. </p>
        /// </note>
        /// <p>You can provide your rule group specification in Suricata flat format through this setting when you create or update your rule group. The call response returns a <code>RuleGroup</code> object that Network Firewall has populated from your string. </p>
        pub fn rules(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rules(input.into());
            self
        }
        /// <p>A string containing stateful rule group rules specifications in Suricata flat format, with one rule per line. Use this to import your existing Suricata compatible rule groups. </p> <note>
        /// <p>You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not both. </p>
        /// </note>
        /// <p>You can provide your rule group specification in Suricata flat format through this setting when you create or update your rule group. The call response returns a <code>RuleGroup</code> object that Network Firewall has populated from your string. </p>
        pub fn set_rules(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p> <note>
        /// <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p>
        /// </note>
        pub fn r#type(mut self, input: crate::model::RuleGroupType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p> <note>
        /// <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p>
        /// </note>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RuleGroupType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>A description of the rule group. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the rule group. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>
        /// <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid. </p>
        /// <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>
        /// <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid. </p>
        /// <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSubnetChangeProtection`.
    ///
    /// <p></p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSubnetChangeProtection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_subnet_change_protection_input::Builder,
    }
    impl UpdateSubnetChangeProtection {
        /// Creates a new `UpdateSubnetChangeProtection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSubnetChangeProtectionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSubnetChangeProtectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(input.into());
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn subnet_change_protection(mut self, input: bool) -> Self {
            self.inner = self.inner.subnet_change_protection(input);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn set_subnet_change_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_subnet_change_protection(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
