// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS Network Firewall
///
/// Client for invoking operations on AWS Network Firewall. Each operation on AWS Network Firewall is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_networkfirewall::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_networkfirewall::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_networkfirewall::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateFirewallPolicy` operation.
    ///
    /// See [`AssociateFirewallPolicy`](crate::client::fluent_builders::AssociateFirewallPolicy) for more information about the
    /// operation and its arguments.
    pub fn associate_firewall_policy(&self) -> fluent_builders::AssociateFirewallPolicy<C, M, R> {
        fluent_builders::AssociateFirewallPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateSubnets` operation.
    ///
    /// See [`AssociateSubnets`](crate::client::fluent_builders::AssociateSubnets) for more information about the
    /// operation and its arguments.
    pub fn associate_subnets(&self) -> fluent_builders::AssociateSubnets<C, M, R> {
        fluent_builders::AssociateSubnets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFirewall` operation.
    ///
    /// See [`CreateFirewall`](crate::client::fluent_builders::CreateFirewall) for more information about the
    /// operation and its arguments.
    pub fn create_firewall(&self) -> fluent_builders::CreateFirewall<C, M, R> {
        fluent_builders::CreateFirewall::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFirewallPolicy` operation.
    ///
    /// See [`CreateFirewallPolicy`](crate::client::fluent_builders::CreateFirewallPolicy) for more information about the
    /// operation and its arguments.
    pub fn create_firewall_policy(&self) -> fluent_builders::CreateFirewallPolicy<C, M, R> {
        fluent_builders::CreateFirewallPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRuleGroup` operation.
    ///
    /// See [`CreateRuleGroup`](crate::client::fluent_builders::CreateRuleGroup) for more information about the
    /// operation and its arguments.
    pub fn create_rule_group(&self) -> fluent_builders::CreateRuleGroup<C, M, R> {
        fluent_builders::CreateRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFirewall` operation.
    ///
    /// See [`DeleteFirewall`](crate::client::fluent_builders::DeleteFirewall) for more information about the
    /// operation and its arguments.
    pub fn delete_firewall(&self) -> fluent_builders::DeleteFirewall<C, M, R> {
        fluent_builders::DeleteFirewall::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFirewallPolicy` operation.
    ///
    /// See [`DeleteFirewallPolicy`](crate::client::fluent_builders::DeleteFirewallPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_firewall_policy(&self) -> fluent_builders::DeleteFirewallPolicy<C, M, R> {
        fluent_builders::DeleteFirewallPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResourcePolicy` operation.
    ///
    /// See [`DeleteResourcePolicy`](crate::client::fluent_builders::DeleteResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_resource_policy(&self) -> fluent_builders::DeleteResourcePolicy<C, M, R> {
        fluent_builders::DeleteResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRuleGroup` operation.
    ///
    /// See [`DeleteRuleGroup`](crate::client::fluent_builders::DeleteRuleGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_rule_group(&self) -> fluent_builders::DeleteRuleGroup<C, M, R> {
        fluent_builders::DeleteRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFirewall` operation.
    ///
    /// See [`DescribeFirewall`](crate::client::fluent_builders::DescribeFirewall) for more information about the
    /// operation and its arguments.
    pub fn describe_firewall(&self) -> fluent_builders::DescribeFirewall<C, M, R> {
        fluent_builders::DescribeFirewall::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFirewallPolicy` operation.
    ///
    /// See [`DescribeFirewallPolicy`](crate::client::fluent_builders::DescribeFirewallPolicy) for more information about the
    /// operation and its arguments.
    pub fn describe_firewall_policy(&self) -> fluent_builders::DescribeFirewallPolicy<C, M, R> {
        fluent_builders::DescribeFirewallPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLoggingConfiguration` operation.
    ///
    /// See [`DescribeLoggingConfiguration`](crate::client::fluent_builders::DescribeLoggingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_logging_configuration(
        &self,
    ) -> fluent_builders::DescribeLoggingConfiguration<C, M, R> {
        fluent_builders::DescribeLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeResourcePolicy` operation.
    ///
    /// See [`DescribeResourcePolicy`](crate::client::fluent_builders::DescribeResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn describe_resource_policy(&self) -> fluent_builders::DescribeResourcePolicy<C, M, R> {
        fluent_builders::DescribeResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRuleGroup` operation.
    ///
    /// See [`DescribeRuleGroup`](crate::client::fluent_builders::DescribeRuleGroup) for more information about the
    /// operation and its arguments.
    pub fn describe_rule_group(&self) -> fluent_builders::DescribeRuleGroup<C, M, R> {
        fluent_builders::DescribeRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateSubnets` operation.
    ///
    /// See [`DisassociateSubnets`](crate::client::fluent_builders::DisassociateSubnets) for more information about the
    /// operation and its arguments.
    pub fn disassociate_subnets(&self) -> fluent_builders::DisassociateSubnets<C, M, R> {
        fluent_builders::DisassociateSubnets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFirewallPolicies` operation.
    ///
    /// See [`ListFirewallPolicies`](crate::client::fluent_builders::ListFirewallPolicies) for more information about the
    /// operation and its arguments.
    pub fn list_firewall_policies(&self) -> fluent_builders::ListFirewallPolicies<C, M, R> {
        fluent_builders::ListFirewallPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFirewalls` operation.
    ///
    /// See [`ListFirewalls`](crate::client::fluent_builders::ListFirewalls) for more information about the
    /// operation and its arguments.
    pub fn list_firewalls(&self) -> fluent_builders::ListFirewalls<C, M, R> {
        fluent_builders::ListFirewalls::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRuleGroups` operation.
    ///
    /// See [`ListRuleGroups`](crate::client::fluent_builders::ListRuleGroups) for more information about the
    /// operation and its arguments.
    pub fn list_rule_groups(&self) -> fluent_builders::ListRuleGroups<C, M, R> {
        fluent_builders::ListRuleGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutResourcePolicy` operation.
    ///
    /// See [`PutResourcePolicy`](crate::client::fluent_builders::PutResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn put_resource_policy(&self) -> fluent_builders::PutResourcePolicy<C, M, R> {
        fluent_builders::PutResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFirewallDeleteProtection` operation.
    ///
    /// See [`UpdateFirewallDeleteProtection`](crate::client::fluent_builders::UpdateFirewallDeleteProtection) for more information about the
    /// operation and its arguments.
    pub fn update_firewall_delete_protection(
        &self,
    ) -> fluent_builders::UpdateFirewallDeleteProtection<C, M, R> {
        fluent_builders::UpdateFirewallDeleteProtection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFirewallDescription` operation.
    ///
    /// See [`UpdateFirewallDescription`](crate::client::fluent_builders::UpdateFirewallDescription) for more information about the
    /// operation and its arguments.
    pub fn update_firewall_description(
        &self,
    ) -> fluent_builders::UpdateFirewallDescription<C, M, R> {
        fluent_builders::UpdateFirewallDescription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFirewallPolicy` operation.
    ///
    /// See [`UpdateFirewallPolicy`](crate::client::fluent_builders::UpdateFirewallPolicy) for more information about the
    /// operation and its arguments.
    pub fn update_firewall_policy(&self) -> fluent_builders::UpdateFirewallPolicy<C, M, R> {
        fluent_builders::UpdateFirewallPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFirewallPolicyChangeProtection` operation.
    ///
    /// See [`UpdateFirewallPolicyChangeProtection`](crate::client::fluent_builders::UpdateFirewallPolicyChangeProtection) for more information about the
    /// operation and its arguments.
    pub fn update_firewall_policy_change_protection(
        &self,
    ) -> fluent_builders::UpdateFirewallPolicyChangeProtection<C, M, R> {
        fluent_builders::UpdateFirewallPolicyChangeProtection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLoggingConfiguration` operation.
    ///
    /// See [`UpdateLoggingConfiguration`](crate::client::fluent_builders::UpdateLoggingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_logging_configuration(
        &self,
    ) -> fluent_builders::UpdateLoggingConfiguration<C, M, R> {
        fluent_builders::UpdateLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRuleGroup` operation.
    ///
    /// See [`UpdateRuleGroup`](crate::client::fluent_builders::UpdateRuleGroup) for more information about the
    /// operation and its arguments.
    pub fn update_rule_group(&self) -> fluent_builders::UpdateRuleGroup<C, M, R> {
        fluent_builders::UpdateRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSubnetChangeProtection` operation.
    ///
    /// See [`UpdateSubnetChangeProtection`](crate::client::fluent_builders::UpdateSubnetChangeProtection) for more information about the
    /// operation and its arguments.
    pub fn update_subnet_change_protection(
        &self,
    ) -> fluent_builders::UpdateSubnetChangeProtection<C, M, R> {
        fluent_builders::UpdateSubnetChangeProtection::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateFirewallPolicy`.
    ///
    /// <p>Associates a <a>FirewallPolicy</a> to a <a>Firewall</a>. </p>
    /// <p>A firewall policy defines how to monitor and manage your VPC network traffic, using a
    /// collection of inspection rule groups and other settings. Each firewall requires one
    /// firewall policy association, and you can use the same firewall policy for multiple
    /// firewalls. </p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateFirewallPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_firewall_policy_input::Builder,
    }
    impl<C, M, R> AssociateFirewallPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateFirewallPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateFirewallPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateFirewallPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateFirewallPolicyInputOperationOutputAlias,
                crate::output::AssociateFirewallPolicyOutput,
                crate::error::AssociateFirewallPolicyError,
                crate::input::AssociateFirewallPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(inp);
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(inp);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        pub fn firewall_policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_policy_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        pub fn set_firewall_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateSubnets`.
    ///
    /// <p>Associates the specified subnets in the Amazon VPC to the firewall. You can specify one
    /// subnet for each of the Availability Zones that the VPC spans. </p>
    /// <p>This request creates an AWS Network Firewall firewall endpoint in each of the subnets. To
    /// enable the firewall's protections, you must also modify the VPC's route tables for each
    /// subnet's Availability Zone, to redirect the traffic that's coming into and going out of the
    /// zone through the firewall endpoint. </p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateSubnets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_subnets_input::Builder,
    }
    impl<C, M, R> AssociateSubnets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateSubnets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateSubnetsOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateSubnetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateSubnetsInputOperationOutputAlias,
                crate::output::AssociateSubnetsOutput,
                crate::error::AssociateSubnetsError,
                crate::input::AssociateSubnetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(inp);
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(inp);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// Appends an item to `SubnetMappings`.
        ///
        /// To override the contents of this collection use [`set_subnet_mappings`](Self::set_subnet_mappings).
        ///
        /// <p>The IDs of the subnets that you want to associate with the firewall. </p>
        pub fn subnet_mappings(mut self, inp: impl Into<crate::model::SubnetMapping>) -> Self {
            self.inner = self.inner.subnet_mappings(inp);
            self
        }
        /// <p>The IDs of the subnets that you want to associate with the firewall. </p>
        pub fn set_subnet_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_mappings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFirewall`.
    ///
    /// <p>Creates an AWS Network Firewall <a>Firewall</a> and accompanying <a>FirewallStatus</a> for a VPC. </p>
    /// <p>The firewall defines the configuration settings for an AWS Network Firewall firewall. The settings that you can define at creation include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and any tags that are attached to the firewall AWS resource. </p>
    /// <p>After you create a firewall, you can provide additional settings, like the logging configuration. </p>
    /// <p>To update the settings for a firewall, you use the operations that apply to the settings
    /// themselves, for example <a>UpdateLoggingConfiguration</a>, <a>AssociateSubnets</a>, and <a>UpdateFirewallDeleteProtection</a>. </p>
    /// <p>To manage a firewall's tags, use the standard AWS resource tagging operations, <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.</p>
    /// <p>To retrieve information about firewalls, use <a>ListFirewalls</a> and <a>DescribeFirewall</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFirewall<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_firewall_input::Builder,
    }
    impl<C, M, R> CreateFirewall<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFirewall`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFirewallOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFirewallError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFirewallInputOperationOutputAlias,
                crate::output::CreateFirewallOutput,
                crate::error::CreateFirewallError,
                crate::input::CreateFirewallInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn firewall_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(inp);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a>FirewallPolicy</a> that you want to
        /// use for the firewall.</p>
        pub fn firewall_policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_policy_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a>FirewallPolicy</a> that you want to
        /// use for the firewall.</p>
        pub fn set_firewall_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_arn(input);
            self
        }
        /// <p>The unique identifier of the VPC where Network Firewall should create the firewall. </p>
        /// <p>You can't change this setting after you create the firewall. </p>
        pub fn vpc_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(inp);
            self
        }
        /// <p>The unique identifier of the VPC where Network Firewall should create the firewall. </p>
        /// <p>You can't change this setting after you create the firewall. </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// Appends an item to `SubnetMappings`.
        ///
        /// To override the contents of this collection use [`set_subnet_mappings`](Self::set_subnet_mappings).
        ///
        /// <p>The public subnets to use for your Network Firewall firewalls. Each subnet must belong to a
        /// different Availability Zone in the VPC. Network Firewall creates a firewall endpoint in each
        /// subnet. </p>
        pub fn subnet_mappings(mut self, inp: impl Into<crate::model::SubnetMapping>) -> Self {
            self.inner = self.inner.subnet_mappings(inp);
            self
        }
        /// <p>The public subnets to use for your Network Firewall firewalls. Each subnet must belong to a
        /// different Availability Zone in the VPC. Network Firewall creates a firewall endpoint in each
        /// subnet. </p>
        pub fn set_subnet_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_mappings(input);
            self
        }
        /// <p>A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates
        /// that the firewall is protected against deletion. Use this setting to protect against
        /// accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.</p>
        pub fn delete_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.delete_protection(inp);
            self
        }
        /// <p>A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates
        /// that the firewall is protected against deletion. Use this setting to protect against
        /// accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.</p>
        pub fn set_delete_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_protection(input);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against changes to the subnet associations.
        /// Use this setting to protect against
        /// accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn subnet_change_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.subnet_change_protection(inp);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against changes to the subnet associations.
        /// Use this setting to protect against
        /// accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn set_subnet_change_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_subnet_change_protection(input);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against a change to the firewall policy association.
        /// Use this setting to protect against
        /// accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn firewall_policy_change_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.firewall_policy_change_protection(inp);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against a change to the firewall policy association.
        /// Use this setting to protect against
        /// accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn set_firewall_policy_change_protection(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_change_protection(input);
            self
        }
        /// <p>A description of the firewall.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the firewall.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key:value pairs to associate with the resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The key:value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFirewallPolicy`.
    ///
    /// <p>Creates the firewall policy for the firewall according to the specifications. </p>
    /// <p>An AWS Network Firewall firewall policy defines the behavior of a firewall, in a collection of
    /// stateless and stateful rule groups and other settings. You can use one firewall policy for
    /// multiple firewalls. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFirewallPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_firewall_policy_input::Builder,
    }
    impl<C, M, R> CreateFirewallPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFirewallPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFirewallPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFirewallPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFirewallPolicyInputOperationOutputAlias,
                crate::output::CreateFirewallPolicyOutput,
                crate::error::CreateFirewallPolicyError,
                crate::input::CreateFirewallPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        pub fn firewall_policy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_policy_name(inp);
            self
        }
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        pub fn set_firewall_policy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_name(input);
            self
        }
        /// <p>The rule groups and policy actions to use in the firewall policy.</p>
        pub fn firewall_policy(mut self, inp: crate::model::FirewallPolicy) -> Self {
            self.inner = self.inner.firewall_policy(inp);
            self
        }
        /// <p>The rule groups and policy actions to use in the firewall policy.</p>
        pub fn set_firewall_policy(
            mut self,
            input: std::option::Option<crate::model::FirewallPolicy>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy(input);
            self
        }
        /// <p>A description of the firewall policy.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the firewall policy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key:value pairs to associate with the resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The key:value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>
        /// <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully,
        /// but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with
        /// dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have
        /// the required permissions to run the request and that your request parameters are valid. </p>
        /// <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
        pub fn dry_run(mut self, inp: bool) -> Self {
            self.inner = self.inner.dry_run(inp);
            self
        }
        /// <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>
        /// <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully,
        /// but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with
        /// dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have
        /// the required permissions to run the request and that your request parameters are valid. </p>
        /// <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRuleGroup`.
    ///
    /// <p>Creates the specified stateless or stateful rule group, which includes the rules for
    /// network traffic inspection, a capacity setting, and tags. </p>
    /// <p>You provide your rule group specification in your request using either
    /// <code>RuleGroup</code> or <code>Rules</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRuleGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_rule_group_input::Builder,
    }
    impl<C, M, R> CreateRuleGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRuleGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRuleGroupInputOperationOutputAlias,
                crate::output::CreateRuleGroupOutput,
                crate::error::CreateRuleGroupError,
                crate::input::CreateRuleGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        pub fn rule_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_name(inp);
            self
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        pub fn set_rule_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_name(input);
            self
        }
        /// <p>An object that defines the rule group rules. </p>
        /// <note>
        /// <p>You must provide either this rule group setting or a <code>Rules</code> setting, but not both. </p>
        /// </note>
        pub fn rule_group(mut self, inp: crate::model::RuleGroup) -> Self {
            self.inner = self.inner.rule_group(inp);
            self
        }
        /// <p>An object that defines the rule group rules. </p>
        /// <note>
        /// <p>You must provide either this rule group setting or a <code>Rules</code> setting, but not both. </p>
        /// </note>
        pub fn set_rule_group(
            mut self,
            input: std::option::Option<crate::model::RuleGroup>,
        ) -> Self {
            self.inner = self.inner.set_rule_group(input);
            self
        }
        /// <p>A string containing stateful rule group rules specifications in Suricata flat format, with one rule
        /// per line. Use this to import your existing Suricata compatible rule groups. </p>
        /// <note>
        /// <p>You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not both. </p>
        /// </note>  
        /// <p>You can provide your rule group specification in Suricata flat format through this setting when you create or update your rule group. The call
        /// response returns a <a>RuleGroup</a> object that Network Firewall has populated from your string. </p>
        pub fn rules(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rules(inp);
            self
        }
        /// <p>A string containing stateful rule group rules specifications in Suricata flat format, with one rule
        /// per line. Use this to import your existing Suricata compatible rule groups. </p>
        /// <note>
        /// <p>You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not both. </p>
        /// </note>  
        /// <p>You can provide your rule group specification in Suricata flat format through this setting when you create or update your rule group. The call
        /// response returns a <a>RuleGroup</a> object that Network Firewall has populated from your string. </p>
        pub fn set_rules(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
        /// stateless rules. If it is stateful, it contains stateful rules. </p>
        pub fn r#type(mut self, inp: crate::model::RuleGroupType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
        /// stateless rules. If it is stateful, it contains stateful rules. </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RuleGroupType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>A description of the rule group. </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the rule group. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation.
        /// When you update a rule group, you are limited to this capacity. When you reference a rule group
        /// from a firewall policy, Network Firewall reserves this capacity for the rule group. </p>
        /// <p>You can retrieve the capacity that would be required for a rule group before you create the rule group by calling
        /// <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>. </p>
        /// <note>
        /// <p>You can't change or exceed this capacity when you update the rule group, so leave
        /// room for your rule group to grow. </p>
        /// </note>
        /// <p>
        /// <b>Capacity for a stateless rule group</b>
        /// </p>
        /// <p>For a stateless rule group, the capacity required is the sum of the capacity
        /// requirements of the individual rules that you expect to have in the rule group. </p>
        /// <p>To calculate the capacity requirement of a single rule, multiply the capacity
        /// requirement values of each of the rule's match settings:</p>
        /// <ul>
        /// <li>
        /// <p>A match setting with no criteria specified has a value of 1. </p>
        /// </li>
        /// <li>
        /// <p>A match setting with <code>Any</code> specified has a value of 1. </p>
        /// </li>
        /// <li>
        /// <p>All other match settings have a value equal to the number of elements provided in
        /// the setting. For example, a protocol setting ["UDP"] and a source setting
        /// ["10.0.0.0/24"] each have a value of 1. A protocol setting ["UDP","TCP"] has a value
        /// of 2. A source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"] has a value of 3.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>A rule with no criteria specified in any of its match settings has a capacity
        /// requirement of 1. A rule with protocol setting ["UDP","TCP"], source setting
        /// ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"], and a single specification or no specification
        /// for each of the other match settings has a capacity requirement of 6. </p>
        /// <p>
        /// <b>Capacity for a stateful rule group</b>
        /// </p>
        /// <p>For
        /// a stateful rule group, the minimum capacity required is the number of individual rules that
        /// you expect to have in the rule group. </p>
        pub fn capacity(mut self, inp: i32) -> Self {
            self.inner = self.inner.capacity(inp);
            self
        }
        /// <p>The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation.
        /// When you update a rule group, you are limited to this capacity. When you reference a rule group
        /// from a firewall policy, Network Firewall reserves this capacity for the rule group. </p>
        /// <p>You can retrieve the capacity that would be required for a rule group before you create the rule group by calling
        /// <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>. </p>
        /// <note>
        /// <p>You can't change or exceed this capacity when you update the rule group, so leave
        /// room for your rule group to grow. </p>
        /// </note>
        /// <p>
        /// <b>Capacity for a stateless rule group</b>
        /// </p>
        /// <p>For a stateless rule group, the capacity required is the sum of the capacity
        /// requirements of the individual rules that you expect to have in the rule group. </p>
        /// <p>To calculate the capacity requirement of a single rule, multiply the capacity
        /// requirement values of each of the rule's match settings:</p>
        /// <ul>
        /// <li>
        /// <p>A match setting with no criteria specified has a value of 1. </p>
        /// </li>
        /// <li>
        /// <p>A match setting with <code>Any</code> specified has a value of 1. </p>
        /// </li>
        /// <li>
        /// <p>All other match settings have a value equal to the number of elements provided in
        /// the setting. For example, a protocol setting ["UDP"] and a source setting
        /// ["10.0.0.0/24"] each have a value of 1. A protocol setting ["UDP","TCP"] has a value
        /// of 2. A source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"] has a value of 3.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>A rule with no criteria specified in any of its match settings has a capacity
        /// requirement of 1. A rule with protocol setting ["UDP","TCP"], source setting
        /// ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"], and a single specification or no specification
        /// for each of the other match settings has a capacity requirement of 6. </p>
        /// <p>
        /// <b>Capacity for a stateful rule group</b>
        /// </p>
        /// <p>For
        /// a stateful rule group, the minimum capacity required is the number of individual rules that
        /// you expect to have in the rule group. </p>
        pub fn set_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_capacity(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key:value pairs to associate with the resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The key:value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>
        /// <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully,
        /// but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with
        /// dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have
        /// the required permissions to run the request and that your request parameters are valid. </p>
        /// <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
        pub fn dry_run(mut self, inp: bool) -> Self {
            self.inner = self.inner.dry_run(inp);
            self
        }
        /// <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>
        /// <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully,
        /// but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with
        /// dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have
        /// the required permissions to run the request and that your request parameters are valid. </p>
        /// <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFirewall`.
    ///
    /// <p>Deletes the specified <a>Firewall</a> and its <a>FirewallStatus</a>.
    /// This operation requires the firewall's <code>DeleteProtection</code> flag to be
    /// <code>FALSE</code>. You can't revert this operation. </p>
    /// <p>You can check whether a firewall is
    /// in use by reviewing the route tables for the Availability Zones where you have
    /// firewall subnet mappings. Retrieve the subnet mappings by calling <a>DescribeFirewall</a>.
    /// You define and update the route tables through Amazon VPC. As needed, update the route tables for the
    /// zones to remove the firewall endpoints. When the route tables no longer use the firewall endpoints,
    /// you can remove the firewall safely.</p>
    /// <p>To delete a firewall, remove the delete protection if you need to using <a>UpdateFirewallDeleteProtection</a>,
    /// then delete the firewall by calling <a>DeleteFirewall</a>. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFirewall<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_firewall_input::Builder,
    }
    impl<C, M, R> DeleteFirewall<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFirewall`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFirewallOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFirewallError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFirewallInputOperationOutputAlias,
                crate::output::DeleteFirewallOutput,
                crate::error::DeleteFirewallError,
                crate::input::DeleteFirewallInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(inp);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFirewallPolicy`.
    ///
    /// <p>Deletes the specified <a>FirewallPolicy</a>. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFirewallPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_firewall_policy_input::Builder,
    }
    impl<C, M, R> DeleteFirewallPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFirewallPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFirewallPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFirewallPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFirewallPolicyInputOperationOutputAlias,
                crate::output::DeleteFirewallPolicyOutput,
                crate::error::DeleteFirewallPolicyError,
                crate::input::DeleteFirewallPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_policy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_policy_name(inp);
            self
        }
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_policy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_policy_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourcePolicy`.
    ///
    /// <p>Deletes a resource policy that you created in a <a>PutResourcePolicy</a> request. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_policy_input::Builder,
    }
    impl<C, M, R> DeleteResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourcePolicyInputOperationOutputAlias,
                crate::output::DeleteResourcePolicyOutput,
                crate::error::DeleteResourcePolicyError,
                crate::input::DeleteResourcePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group or firewall policy whose resource policy you want to delete. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group or firewall policy whose resource policy you want to delete. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRuleGroup`.
    ///
    /// <p>Deletes the specified <a>RuleGroup</a>. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRuleGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_rule_group_input::Builder,
    }
    impl<C, M, R> DeleteRuleGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRuleGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRuleGroupInputOperationOutputAlias,
                crate::output::DeleteRuleGroupOutput,
                crate::error::DeleteRuleGroupError,
                crate::input::DeleteRuleGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn rule_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_name(inp);
            self
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_rule_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn rule_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_rule_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_arn(input);
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
        /// stateless rules. If it is stateful, it contains stateful rules. </p>
        /// <note>
        /// <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p>
        /// </note>
        pub fn r#type(mut self, inp: crate::model::RuleGroupType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
        /// stateless rules. If it is stateful, it contains stateful rules. </p>
        /// <note>
        /// <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p>
        /// </note>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RuleGroupType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFirewall`.
    ///
    /// <p>Returns the data objects for the specified firewall. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFirewall<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_firewall_input::Builder,
    }
    impl<C, M, R> DescribeFirewall<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFirewall`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFirewallOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFirewallError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFirewallInputOperationOutputAlias,
                crate::output::DescribeFirewallOutput,
                crate::error::DescribeFirewallError,
                crate::input::DescribeFirewallInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(inp);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFirewallPolicy`.
    ///
    /// <p>Returns the data objects for the specified firewall policy. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFirewallPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_firewall_policy_input::Builder,
    }
    impl<C, M, R> DescribeFirewallPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFirewallPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFirewallPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFirewallPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFirewallPolicyInputOperationOutputAlias,
                crate::output::DescribeFirewallPolicyOutput,
                crate::error::DescribeFirewallPolicyError,
                crate::input::DescribeFirewallPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_policy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_policy_name(inp);
            self
        }
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_policy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_policy_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoggingConfiguration`.
    ///
    /// <p>Returns the logging configuration for the specified firewall. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLoggingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_logging_configuration_input::Builder,
    }
    impl<C, M, R> DescribeLoggingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoggingConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLoggingConfigurationInputOperationOutputAlias,
                crate::output::DescribeLoggingConfigurationOutput,
                crate::error::DescribeLoggingConfigurationError,
                crate::input::DescribeLoggingConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(inp);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResourcePolicy`.
    ///
    /// <p>Retrieves a resource policy that you created in a <a>PutResourcePolicy</a> request. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_resource_policy_input::Builder,
    }
    impl<C, M, R> DescribeResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeResourcePolicyInputOperationOutputAlias,
                crate::output::DescribeResourcePolicyOutput,
                crate::error::DescribeResourcePolicyError,
                crate::input::DescribeResourcePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group or firewall policy whose resource policy you want to retrieve. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group or firewall policy whose resource policy you want to retrieve. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRuleGroup`.
    ///
    /// <p>Returns the data objects for the specified rule group. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRuleGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_rule_group_input::Builder,
    }
    impl<C, M, R> DescribeRuleGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRuleGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRuleGroupInputOperationOutputAlias,
                crate::output::DescribeRuleGroupOutput,
                crate::error::DescribeRuleGroupError,
                crate::input::DescribeRuleGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn rule_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_name(inp);
            self
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_rule_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn rule_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_rule_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_arn(input);
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
        /// stateless rules. If it is stateful, it contains stateful rules. </p>
        /// <note>
        /// <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p>
        /// </note>
        pub fn r#type(mut self, inp: crate::model::RuleGroupType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
        /// stateless rules. If it is stateful, it contains stateful rules. </p>
        /// <note>
        /// <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p>
        /// </note>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RuleGroupType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateSubnets`.
    ///
    /// <p>Removes the specified subnet associations from the firewall. This removes the
    /// firewall endpoints from the subnets and removes any network filtering protections that the endpoints
    /// were providing.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateSubnets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_subnets_input::Builder,
    }
    impl<C, M, R> DisassociateSubnets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateSubnets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateSubnetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateSubnetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateSubnetsInputOperationOutputAlias,
                crate::output::DisassociateSubnetsOutput,
                crate::error::DisassociateSubnetsError,
                crate::input::DisassociateSubnetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(inp);
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(inp);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The unique identifiers for the subnets that you want to disassociate. </p>
        pub fn subnet_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(inp);
            self
        }
        /// <p>The unique identifiers for the subnets that you want to disassociate. </p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFirewallPolicies`.
    ///
    /// <p>Retrieves the metadata for the firewall policies that you have defined. Depending on
    /// your setting for max results and the number of firewall policies, a single call might not
    /// return the full list. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListFirewallPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_firewall_policies_input::Builder,
    }
    impl<C, M, R> ListFirewallPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFirewallPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFirewallPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFirewallPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFirewallPoliciesInputOperationOutputAlias,
                crate::output::ListFirewallPoliciesOutput,
                crate::error::ListFirewallPoliciesError,
                crate::input::ListFirewallPoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
        /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
        /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
        /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
        /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects that you want Network Firewall to return for this request. If more
        /// objects are available, in the response, Network Firewall provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects that you want Network Firewall to return for this request. If more
        /// objects are available, in the response, Network Firewall provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFirewalls`.
    ///
    /// <p>Retrieves the metadata for the firewalls that you have defined. If you provide VPC
    /// identifiers in your request, this returns only the firewalls for those VPCs.</p>
    /// <p>Depending on your setting for max results and the number of firewalls, a single call
    /// might not return the full list. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListFirewalls<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_firewalls_input::Builder,
    }
    impl<C, M, R> ListFirewalls<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFirewalls`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFirewallsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFirewallsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFirewallsInputOperationOutputAlias,
                crate::output::ListFirewallsOutput,
                crate::error::ListFirewallsError,
                crate::input::ListFirewallsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
        /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
        /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
        /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
        /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `VpcIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_ids`](Self::set_vpc_ids).
        ///
        /// <p>The unique identifiers of the VPCs that you want Network Firewall to retrieve the firewalls
        /// for. Leave this blank to retrieve all firewalls that you have defined.</p>
        pub fn vpc_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_ids(inp);
            self
        }
        /// <p>The unique identifiers of the VPCs that you want Network Firewall to retrieve the firewalls
        /// for. Leave this blank to retrieve all firewalls that you have defined.</p>
        pub fn set_vpc_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_ids(input);
            self
        }
        /// <p>The maximum number of objects that you want Network Firewall to return for this request. If more
        /// objects are available, in the response, Network Firewall provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects that you want Network Firewall to return for this request. If more
        /// objects are available, in the response, Network Firewall provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRuleGroups`.
    ///
    /// <p>Retrieves the metadata for the rule groups that you have defined. Depending on your
    /// setting for max results and the number of rule groups, a single call might not return the
    /// full list. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListRuleGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_rule_groups_input::Builder,
    }
    impl<C, M, R> ListRuleGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRuleGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRuleGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRuleGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRuleGroupsInputOperationOutputAlias,
                crate::output::ListRuleGroupsOutput,
                crate::error::ListRuleGroupsError,
                crate::input::ListRuleGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
        /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
        /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
        /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
        /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects that you want Network Firewall to return for this request. If more
        /// objects are available, in the response, Network Firewall provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects that you want Network Firewall to return for this request. If more
        /// objects are available, in the response, Network Firewall provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves the tags associated with the specified resource. Tags are key:value pairs that
    /// you can use to categorize and manage your resources, for purposes like billing. For
    /// example, you might set the tag key to "customer" and the value to the customer name or ID.
    /// You can specify one or more tags to add to each AWS resource, up to 50 tags for a
    /// resource.</p>
    /// <p>You can tag the AWS resources that you manage through AWS Network Firewall: firewalls, firewall
    /// policies, and rule groups. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
        /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
        /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
        /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
        /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects that you want Network Firewall to return for this request. If more
        /// objects are available, in the response, Network Firewall provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects that you want Network Firewall to return for this request. If more
        /// objects are available, in the response, Network Firewall provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutResourcePolicy`.
    ///
    /// <p>Creates or updates an AWS Identity and Access Management policy for your rule group or firewall policy. Use this to share rule groups and firewall policies between accounts. This operation works in conjunction with the AWS Resource Access Manager (RAM) service
    /// to manage resource sharing for Network Firewall. </p>
    /// <p>Use this operation to create or update a resource policy for your rule group or firewall policy. In the policy, you specify the accounts that you want to share the resource with and the operations that you want the accounts to be able to perform. </p>
    /// <p>When you add an account in the resource policy, you then run the following Resource Access Manager (RAM) operations to access and accept the shared rule group or firewall policy. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareInvitations.html">GetResourceShareInvitations</a> - Returns the Amazon Resource Names (ARNs) of the resource share invitations.  </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_AcceptResourceShareInvitation.html">AcceptResourceShareInvitation</a> - Accepts the share invitation for a specified resource share. </p>
    /// </li>
    /// </ul>
    /// <p>For additional information about resource sharing using RAM, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/what-is.html">AWS Resource Access Manager User Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_resource_policy_input::Builder,
    }
    impl<C, M, R> PutResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutResourcePolicyInputOperationOutputAlias,
                crate::output::PutResourcePolicyOutput,
                crate::error::PutResourcePolicyError,
                crate::input::PutResourcePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the account that you want to share rule groups and firewall policies with.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the account that you want to share rule groups and firewall policies with.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The AWS Identity and Access Management policy statement that lists the accounts that you want to share your rule group or firewall policy with
        /// and the operations that you want the accounts to be able to perform. </p>
        /// <p>For a rule group resource, you can specify the following operations in the Actions section of the statement:</p>
        /// <ul>
        /// <li>
        /// <p>network-firewall:CreateFirewallPolicy</p>
        /// </li>
        /// <li>
        /// <p>network-firewall:UpdateFirewallPolicy</p>
        /// </li>
        /// <li>
        /// <p>network-firewall:ListRuleGroups</p>
        /// </li>
        /// </ul>
        /// <p>For a firewall policy resource, you can specify the following operations in the Actions section of the statement:</p>
        /// <ul>
        /// <li>
        /// <p>network-firewall:CreateFirewall</p>
        /// </li>
        /// <li>
        /// <p>network-firewall:UpdateFirewall</p>
        /// </li>
        /// <li>
        /// <p>network-firewall:AssociateFirewallPolicy</p>
        /// </li>
        /// <li>
        /// <p>network-firewall:ListFirewallPolicies</p>
        /// </li>
        /// </ul>
        /// <p>In the Resource section of the statement, you specify the ARNs for the rule groups and firewall policies that you want to share with the account that you specified in <code>Arn</code>.</p>
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// <p>The AWS Identity and Access Management policy statement that lists the accounts that you want to share your rule group or firewall policy with
        /// and the operations that you want the accounts to be able to perform. </p>
        /// <p>For a rule group resource, you can specify the following operations in the Actions section of the statement:</p>
        /// <ul>
        /// <li>
        /// <p>network-firewall:CreateFirewallPolicy</p>
        /// </li>
        /// <li>
        /// <p>network-firewall:UpdateFirewallPolicy</p>
        /// </li>
        /// <li>
        /// <p>network-firewall:ListRuleGroups</p>
        /// </li>
        /// </ul>
        /// <p>For a firewall policy resource, you can specify the following operations in the Actions section of the statement:</p>
        /// <ul>
        /// <li>
        /// <p>network-firewall:CreateFirewall</p>
        /// </li>
        /// <li>
        /// <p>network-firewall:UpdateFirewall</p>
        /// </li>
        /// <li>
        /// <p>network-firewall:AssociateFirewallPolicy</p>
        /// </li>
        /// <li>
        /// <p>network-firewall:ListFirewallPolicies</p>
        /// </li>
        /// </ul>
        /// <p>In the Resource section of the statement, you specify the ARNs for the rule groups and firewall policies that you want to share with the account that you specified in <code>Arn</code>.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds the specified tags to the specified resource. Tags are key:value pairs that you can
    /// use to categorize and manage your resources, for purposes like billing. For example, you
    /// might set the tag key to "customer" and the value to the customer name or ID. You can
    /// specify one or more tags to add to each AWS resource, up to 50 tags for a resource.</p>
    /// <p>You can tag the AWS resources that you manage through AWS Network Firewall: firewalls, firewall
    /// policies, and rule groups. </p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p></p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p></p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the tags with the specified keys from the specified resource. Tags are key:value
    /// pairs that you can use to categorize and manage your resources, for purposes like billing.
    /// For example, you might set the tag key to "customer" and the value to the customer name or
    /// ID. You can specify one or more tags to add to each AWS resource, up to 50 tags for a
    /// resource.</p>
    /// <p>You can manage tags for the AWS resources that you manage through AWS Network Firewall:
    /// firewalls, firewall policies, and rule groups. </p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p></p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p></p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFirewallDeleteProtection`.
    ///
    /// <p>Modifies the flag, <code>DeleteProtection</code>, which indicates whether it is possible
    /// to delete the firewall. If the flag is set to <code>TRUE</code>, the firewall is protected
    /// against deletion. This setting helps protect against accidentally deleting a firewall
    /// that's in use. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFirewallDeleteProtection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_firewall_delete_protection_input::Builder,
    }
    impl<C, M, R> UpdateFirewallDeleteProtection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFirewallDeleteProtection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFirewallDeleteProtectionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFirewallDeleteProtectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFirewallDeleteProtectionInputOperationOutputAlias,
                crate::output::UpdateFirewallDeleteProtectionOutput,
                crate::error::UpdateFirewallDeleteProtectionError,
                crate::input::UpdateFirewallDeleteProtectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(inp);
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(inp);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// <p>A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates
        /// that the firewall is protected against deletion. Use this setting to protect against
        /// accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.</p>
        pub fn delete_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.delete_protection(inp);
            self
        }
        /// <p>A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates
        /// that the firewall is protected against deletion. Use this setting to protect against
        /// accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.</p>
        pub fn set_delete_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_protection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFirewallDescription`.
    ///
    /// <p>Modifies the description for the specified firewall. Use the description to help you
    /// identify the firewall when you're working with it. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFirewallDescription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_firewall_description_input::Builder,
    }
    impl<C, M, R> UpdateFirewallDescription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFirewallDescription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFirewallDescriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFirewallDescriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFirewallDescriptionInputOperationOutputAlias,
                crate::output::UpdateFirewallDescriptionOutput,
                crate::error::UpdateFirewallDescriptionError,
                crate::input::UpdateFirewallDescriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(inp);
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(inp);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// <p>The new description for the firewall. If you omit this setting, Network Firewall removes
        /// the description for the firewall.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The new description for the firewall. If you omit this setting, Network Firewall removes
        /// the description for the firewall.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFirewallPolicy`.
    ///
    /// <p>Updates the properties of the specified firewall policy.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFirewallPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_firewall_policy_input::Builder,
    }
    impl<C, M, R> UpdateFirewallPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFirewallPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFirewallPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFirewallPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFirewallPolicyInputOperationOutputAlias,
                crate::output::UpdateFirewallPolicyOutput,
                crate::error::UpdateFirewallPolicyError,
                crate::input::UpdateFirewallPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p>
        /// <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(inp);
            self
        }
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p>
        /// <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_policy_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_policy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_policy_name(inp);
            self
        }
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_policy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_name(input);
            self
        }
        /// <p>The updated firewall policy to use for the firewall. </p>
        pub fn firewall_policy(mut self, inp: crate::model::FirewallPolicy) -> Self {
            self.inner = self.inner.firewall_policy(inp);
            self
        }
        /// <p>The updated firewall policy to use for the firewall. </p>
        pub fn set_firewall_policy(
            mut self,
            input: std::option::Option<crate::model::FirewallPolicy>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy(input);
            self
        }
        /// <p>A description of the firewall policy.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the firewall policy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>
        /// <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully,
        /// but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with
        /// dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have
        /// the required permissions to run the request and that your request parameters are valid. </p>
        /// <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
        pub fn dry_run(mut self, inp: bool) -> Self {
            self.inner = self.inner.dry_run(inp);
            self
        }
        /// <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>
        /// <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully,
        /// but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with
        /// dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have
        /// the required permissions to run the request and that your request parameters are valid. </p>
        /// <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFirewallPolicyChangeProtection`.
    ///
    /// <p></p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFirewallPolicyChangeProtection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_firewall_policy_change_protection_input::Builder,
    }
    impl<C, M, R> UpdateFirewallPolicyChangeProtection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFirewallPolicyChangeProtection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFirewallPolicyChangeProtectionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateFirewallPolicyChangeProtectionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFirewallPolicyChangeProtectionInputOperationOutputAlias,
                crate::output::UpdateFirewallPolicyChangeProtectionOutput,
                crate::error::UpdateFirewallPolicyChangeProtectionError,
                crate::input::UpdateFirewallPolicyChangeProtectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(inp);
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(inp);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against a change to the firewall policy association.
        /// Use this setting to protect against
        /// accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn firewall_policy_change_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.firewall_policy_change_protection(inp);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against a change to the firewall policy association.
        /// Use this setting to protect against
        /// accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn set_firewall_policy_change_protection(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_firewall_policy_change_protection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLoggingConfiguration`.
    ///
    /// <p>Sets the logging configuration for the specified firewall. </p>
    /// <p>To change the logging configuration, retrieve the <a>LoggingConfiguration</a> by calling <a>DescribeLoggingConfiguration</a>, then change it and provide
    /// the modified object to this update call. You must change the logging configuration one
    /// <a>LogDestinationConfig</a> at a time inside the retrieved <a>LoggingConfiguration</a> object. </p>
    /// <p>You can perform only one of the following actions in any call to
    /// <code>UpdateLoggingConfiguration</code>: </p>
    /// <ul>
    /// <li>
    /// <p>Create a new log destination object by adding a single
    /// <code>LogDestinationConfig</code> array element to
    /// <code>LogDestinationConfigs</code>.</p>
    /// </li>
    /// <li>
    /// <p>Delete a log destination object by removing a single
    /// <code>LogDestinationConfig</code> array element from
    /// <code>LogDestinationConfigs</code>.</p>
    /// </li>
    /// <li>
    /// <p>Change the <code>LogDestination</code> setting in a single
    /// <code>LogDestinationConfig</code> array element.</p>
    /// </li>
    /// </ul>
    /// <p>You can't change the <code>LogDestinationType</code> or <code>LogType</code> in a
    /// <code>LogDestinationConfig</code>. To change these settings, delete the existing
    /// <code>LogDestinationConfig</code> object and create a new one, using two separate calls
    /// to this update operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLoggingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_logging_configuration_input::Builder,
    }
    impl<C, M, R> UpdateLoggingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLoggingConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLoggingConfigurationInputOperationOutputAlias,
                crate::output::UpdateLoggingConfigurationOutput,
                crate::error::UpdateLoggingConfigurationError,
                crate::input::UpdateLoggingConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(inp);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// <p>Defines how Network Firewall performs logging for a firewall. If you omit this setting,
        /// Network Firewall disables logging for the firewall.</p>
        pub fn logging_configuration(mut self, inp: crate::model::LoggingConfiguration) -> Self {
            self.inner = self.inner.logging_configuration(inp);
            self
        }
        /// <p>Defines how Network Firewall performs logging for a firewall. If you omit this setting,
        /// Network Firewall disables logging for the firewall.</p>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_logging_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRuleGroup`.
    ///
    /// <p>Updates the rule settings for the specified rule group. You use a rule group by
    /// reference in one or more firewall policies. When you modify a rule group, you modify all
    /// firewall policies that use the rule group. </p>
    /// <p>To update a rule group, first call <a>DescribeRuleGroup</a> to retrieve the
    /// current <a>RuleGroup</a> object, update the object as needed, and then provide
    /// the updated object to this call. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRuleGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_rule_group_input::Builder,
    }
    impl<C, M, R> UpdateRuleGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRuleGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRuleGroupInputOperationOutputAlias,
                crate::output::UpdateRuleGroupOutput,
                crate::error::UpdateRuleGroupError,
                crate::input::UpdateRuleGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p>
        /// <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(inp);
            self
        }
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p>
        /// <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn rule_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_rule_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_arn(input);
            self
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn rule_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_name(inp);
            self
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_rule_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_name(input);
            self
        }
        /// <p>An object that defines the rule group rules. </p>
        /// <note>
        /// <p>You must provide either this rule group setting or a <code>Rules</code> setting, but not both. </p>
        /// </note>
        pub fn rule_group(mut self, inp: crate::model::RuleGroup) -> Self {
            self.inner = self.inner.rule_group(inp);
            self
        }
        /// <p>An object that defines the rule group rules. </p>
        /// <note>
        /// <p>You must provide either this rule group setting or a <code>Rules</code> setting, but not both. </p>
        /// </note>
        pub fn set_rule_group(
            mut self,
            input: std::option::Option<crate::model::RuleGroup>,
        ) -> Self {
            self.inner = self.inner.set_rule_group(input);
            self
        }
        /// <p>A string containing stateful rule group rules specifications in Suricata flat format, with one rule
        /// per line. Use this to import your existing Suricata compatible rule groups. </p>
        /// <note>
        /// <p>You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not both. </p>
        /// </note>  
        /// <p>You can provide your rule group specification in Suricata flat format through this setting when you create or update your rule group. The call
        /// response returns a <a>RuleGroup</a> object that Network Firewall has populated from your string. </p>
        pub fn rules(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rules(inp);
            self
        }
        /// <p>A string containing stateful rule group rules specifications in Suricata flat format, with one rule
        /// per line. Use this to import your existing Suricata compatible rule groups. </p>
        /// <note>
        /// <p>You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not both. </p>
        /// </note>  
        /// <p>You can provide your rule group specification in Suricata flat format through this setting when you create or update your rule group. The call
        /// response returns a <a>RuleGroup</a> object that Network Firewall has populated from your string. </p>
        pub fn set_rules(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
        /// stateless rules. If it is stateful, it contains stateful rules. </p>
        /// <note>
        /// <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p>
        /// </note>
        pub fn r#type(mut self, inp: crate::model::RuleGroupType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
        /// stateless rules. If it is stateful, it contains stateful rules. </p>
        /// <note>
        /// <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p>
        /// </note>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RuleGroupType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>A description of the rule group. </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the rule group. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>
        /// <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully,
        /// but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with
        /// dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have
        /// the required permissions to run the request and that your request parameters are valid. </p>
        /// <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
        pub fn dry_run(mut self, inp: bool) -> Self {
            self.inner = self.inner.dry_run(inp);
            self
        }
        /// <p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p>
        /// <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully,
        /// but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with
        /// dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows you to make sure that you have
        /// the required permissions to run the request and that your request parameters are valid. </p>
        /// <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSubnetChangeProtection`.
    ///
    /// <p></p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSubnetChangeProtection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_subnet_change_protection_input::Builder,
    }
    impl<C, M, R> UpdateSubnetChangeProtection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSubnetChangeProtection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSubnetChangeProtectionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSubnetChangeProtectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSubnetChangeProtectionInputOperationOutputAlias,
                crate::output::UpdateSubnetChangeProtectionOutput,
                crate::error::UpdateSubnetChangeProtectionError,
                crate::input::UpdateSubnetChangeProtectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(inp);
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_firewall_arn(input);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn firewall_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_name(inp);
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        /// <p>You must specify the ARN or the name, and you can specify both. </p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_name(input);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against changes to the subnet associations.
        /// Use this setting to protect against
        /// accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn subnet_change_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.subnet_change_protection(inp);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against changes to the subnet associations.
        /// Use this setting to protect against
        /// accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn set_subnet_change_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_subnet_change_protection(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
