// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateFirewallPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_firewall_policy`](crate::client::Client::associate_firewall_policy).
///
/// See [`crate::client::fluent_builders::AssociateFirewallPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateFirewallPolicy {
    _private: (),
}
impl AssociateFirewallPolicy {
    /// Creates a new builder-style object to manufacture [`AssociateFirewallPolicyInput`](crate::input::AssociateFirewallPolicyInput)
    pub fn builder() -> crate::input::associate_firewall_policy_input::Builder {
        crate::input::associate_firewall_policy_input::Builder::default()
    }
    /// Creates a new `AssociateFirewallPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateFirewallPolicy {
    type Output = std::result::Result<
        crate::output::AssociateFirewallPolicyOutput,
        crate::error::AssociateFirewallPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_firewall_policy_error(response)
        } else {
            crate::operation_deser::parse_associate_firewall_policy_response(response)
        }
    }
}

/// Operation shape for `AssociateSubnets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_subnets`](crate::client::Client::associate_subnets).
///
/// See [`crate::client::fluent_builders::AssociateSubnets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateSubnets {
    _private: (),
}
impl AssociateSubnets {
    /// Creates a new builder-style object to manufacture [`AssociateSubnetsInput`](crate::input::AssociateSubnetsInput)
    pub fn builder() -> crate::input::associate_subnets_input::Builder {
        crate::input::associate_subnets_input::Builder::default()
    }
    /// Creates a new `AssociateSubnets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateSubnets {
    type Output = std::result::Result<
        crate::output::AssociateSubnetsOutput,
        crate::error::AssociateSubnetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_subnets_error(response)
        } else {
            crate::operation_deser::parse_associate_subnets_response(response)
        }
    }
}

/// Operation shape for `CreateFirewall`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_firewall`](crate::client::Client::create_firewall).
///
/// See [`crate::client::fluent_builders::CreateFirewall`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFirewall {
    _private: (),
}
impl CreateFirewall {
    /// Creates a new builder-style object to manufacture [`CreateFirewallInput`](crate::input::CreateFirewallInput)
    pub fn builder() -> crate::input::create_firewall_input::Builder {
        crate::input::create_firewall_input::Builder::default()
    }
    /// Creates a new `CreateFirewall` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFirewall {
    type Output =
        std::result::Result<crate::output::CreateFirewallOutput, crate::error::CreateFirewallError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_firewall_error(response)
        } else {
            crate::operation_deser::parse_create_firewall_response(response)
        }
    }
}

/// Operation shape for `CreateFirewallPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_firewall_policy`](crate::client::Client::create_firewall_policy).
///
/// See [`crate::client::fluent_builders::CreateFirewallPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFirewallPolicy {
    _private: (),
}
impl CreateFirewallPolicy {
    /// Creates a new builder-style object to manufacture [`CreateFirewallPolicyInput`](crate::input::CreateFirewallPolicyInput)
    pub fn builder() -> crate::input::create_firewall_policy_input::Builder {
        crate::input::create_firewall_policy_input::Builder::default()
    }
    /// Creates a new `CreateFirewallPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFirewallPolicy {
    type Output = std::result::Result<
        crate::output::CreateFirewallPolicyOutput,
        crate::error::CreateFirewallPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_firewall_policy_error(response)
        } else {
            crate::operation_deser::parse_create_firewall_policy_response(response)
        }
    }
}

/// Operation shape for `CreateRuleGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_rule_group`](crate::client::Client::create_rule_group).
///
/// See [`crate::client::fluent_builders::CreateRuleGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRuleGroup {
    _private: (),
}
impl CreateRuleGroup {
    /// Creates a new builder-style object to manufacture [`CreateRuleGroupInput`](crate::input::CreateRuleGroupInput)
    pub fn builder() -> crate::input::create_rule_group_input::Builder {
        crate::input::create_rule_group_input::Builder::default()
    }
    /// Creates a new `CreateRuleGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRuleGroup {
    type Output = std::result::Result<
        crate::output::CreateRuleGroupOutput,
        crate::error::CreateRuleGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_rule_group_error(response)
        } else {
            crate::operation_deser::parse_create_rule_group_response(response)
        }
    }
}

/// Operation shape for `DeleteFirewall`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_firewall`](crate::client::Client::delete_firewall).
///
/// See [`crate::client::fluent_builders::DeleteFirewall`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFirewall {
    _private: (),
}
impl DeleteFirewall {
    /// Creates a new builder-style object to manufacture [`DeleteFirewallInput`](crate::input::DeleteFirewallInput)
    pub fn builder() -> crate::input::delete_firewall_input::Builder {
        crate::input::delete_firewall_input::Builder::default()
    }
    /// Creates a new `DeleteFirewall` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFirewall {
    type Output =
        std::result::Result<crate::output::DeleteFirewallOutput, crate::error::DeleteFirewallError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_firewall_error(response)
        } else {
            crate::operation_deser::parse_delete_firewall_response(response)
        }
    }
}

/// Operation shape for `DeleteFirewallPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_firewall_policy`](crate::client::Client::delete_firewall_policy).
///
/// See [`crate::client::fluent_builders::DeleteFirewallPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFirewallPolicy {
    _private: (),
}
impl DeleteFirewallPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteFirewallPolicyInput`](crate::input::DeleteFirewallPolicyInput)
    pub fn builder() -> crate::input::delete_firewall_policy_input::Builder {
        crate::input::delete_firewall_policy_input::Builder::default()
    }
    /// Creates a new `DeleteFirewallPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFirewallPolicy {
    type Output = std::result::Result<
        crate::output::DeleteFirewallPolicyOutput,
        crate::error::DeleteFirewallPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_firewall_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_firewall_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resource_policy`](crate::client::Client::delete_resource_policy).
///
/// See [`crate::client::fluent_builders::DeleteResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResourcePolicy {
    _private: (),
}
impl DeleteResourcePolicy {
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
    pub fn builder() -> crate::input::delete_resource_policy_input::Builder {
        crate::input::delete_resource_policy_input::Builder::default()
    }
    /// Creates a new `DeleteResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResourcePolicy {
    type Output = std::result::Result<
        crate::output::DeleteResourcePolicyOutput,
        crate::error::DeleteResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_resource_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteRuleGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_rule_group`](crate::client::Client::delete_rule_group).
///
/// See [`crate::client::fluent_builders::DeleteRuleGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRuleGroup {
    _private: (),
}
impl DeleteRuleGroup {
    /// Creates a new builder-style object to manufacture [`DeleteRuleGroupInput`](crate::input::DeleteRuleGroupInput)
    pub fn builder() -> crate::input::delete_rule_group_input::Builder {
        crate::input::delete_rule_group_input::Builder::default()
    }
    /// Creates a new `DeleteRuleGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRuleGroup {
    type Output = std::result::Result<
        crate::output::DeleteRuleGroupOutput,
        crate::error::DeleteRuleGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_rule_group_error(response)
        } else {
            crate::operation_deser::parse_delete_rule_group_response(response)
        }
    }
}

/// Operation shape for `DescribeFirewall`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_firewall`](crate::client::Client::describe_firewall).
///
/// See [`crate::client::fluent_builders::DescribeFirewall`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFirewall {
    _private: (),
}
impl DescribeFirewall {
    /// Creates a new builder-style object to manufacture [`DescribeFirewallInput`](crate::input::DescribeFirewallInput)
    pub fn builder() -> crate::input::describe_firewall_input::Builder {
        crate::input::describe_firewall_input::Builder::default()
    }
    /// Creates a new `DescribeFirewall` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFirewall {
    type Output = std::result::Result<
        crate::output::DescribeFirewallOutput,
        crate::error::DescribeFirewallError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_firewall_error(response)
        } else {
            crate::operation_deser::parse_describe_firewall_response(response)
        }
    }
}

/// Operation shape for `DescribeFirewallPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_firewall_policy`](crate::client::Client::describe_firewall_policy).
///
/// See [`crate::client::fluent_builders::DescribeFirewallPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFirewallPolicy {
    _private: (),
}
impl DescribeFirewallPolicy {
    /// Creates a new builder-style object to manufacture [`DescribeFirewallPolicyInput`](crate::input::DescribeFirewallPolicyInput)
    pub fn builder() -> crate::input::describe_firewall_policy_input::Builder {
        crate::input::describe_firewall_policy_input::Builder::default()
    }
    /// Creates a new `DescribeFirewallPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFirewallPolicy {
    type Output = std::result::Result<
        crate::output::DescribeFirewallPolicyOutput,
        crate::error::DescribeFirewallPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_firewall_policy_error(response)
        } else {
            crate::operation_deser::parse_describe_firewall_policy_response(response)
        }
    }
}

/// Operation shape for `DescribeLoggingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_logging_configuration`](crate::client::Client::describe_logging_configuration).
///
/// See [`crate::client::fluent_builders::DescribeLoggingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLoggingConfiguration {
    _private: (),
}
impl DescribeLoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeLoggingConfigurationInput`](crate::input::DescribeLoggingConfigurationInput)
    pub fn builder() -> crate::input::describe_logging_configuration_input::Builder {
        crate::input::describe_logging_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeLoggingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLoggingConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeLoggingConfigurationOutput,
        crate::error::DescribeLoggingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_logging_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_logging_configuration_response(response)
        }
    }
}

/// Operation shape for `DescribeResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_resource_policy`](crate::client::Client::describe_resource_policy).
///
/// See [`crate::client::fluent_builders::DescribeResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeResourcePolicy {
    _private: (),
}
impl DescribeResourcePolicy {
    /// Creates a new builder-style object to manufacture [`DescribeResourcePolicyInput`](crate::input::DescribeResourcePolicyInput)
    pub fn builder() -> crate::input::describe_resource_policy_input::Builder {
        crate::input::describe_resource_policy_input::Builder::default()
    }
    /// Creates a new `DescribeResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeResourcePolicy {
    type Output = std::result::Result<
        crate::output::DescribeResourcePolicyOutput,
        crate::error::DescribeResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_describe_resource_policy_response(response)
        }
    }
}

/// Operation shape for `DescribeRuleGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_rule_group`](crate::client::Client::describe_rule_group).
///
/// See [`crate::client::fluent_builders::DescribeRuleGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRuleGroup {
    _private: (),
}
impl DescribeRuleGroup {
    /// Creates a new builder-style object to manufacture [`DescribeRuleGroupInput`](crate::input::DescribeRuleGroupInput)
    pub fn builder() -> crate::input::describe_rule_group_input::Builder {
        crate::input::describe_rule_group_input::Builder::default()
    }
    /// Creates a new `DescribeRuleGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRuleGroup {
    type Output = std::result::Result<
        crate::output::DescribeRuleGroupOutput,
        crate::error::DescribeRuleGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_rule_group_error(response)
        } else {
            crate::operation_deser::parse_describe_rule_group_response(response)
        }
    }
}

/// Operation shape for `DescribeRuleGroupMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_rule_group_metadata`](crate::client::Client::describe_rule_group_metadata).
///
/// See [`crate::client::fluent_builders::DescribeRuleGroupMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRuleGroupMetadata {
    _private: (),
}
impl DescribeRuleGroupMetadata {
    /// Creates a new builder-style object to manufacture [`DescribeRuleGroupMetadataInput`](crate::input::DescribeRuleGroupMetadataInput)
    pub fn builder() -> crate::input::describe_rule_group_metadata_input::Builder {
        crate::input::describe_rule_group_metadata_input::Builder::default()
    }
    /// Creates a new `DescribeRuleGroupMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRuleGroupMetadata {
    type Output = std::result::Result<
        crate::output::DescribeRuleGroupMetadataOutput,
        crate::error::DescribeRuleGroupMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_rule_group_metadata_error(response)
        } else {
            crate::operation_deser::parse_describe_rule_group_metadata_response(response)
        }
    }
}

/// Operation shape for `DisassociateSubnets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_subnets`](crate::client::Client::disassociate_subnets).
///
/// See [`crate::client::fluent_builders::DisassociateSubnets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateSubnets {
    _private: (),
}
impl DisassociateSubnets {
    /// Creates a new builder-style object to manufacture [`DisassociateSubnetsInput`](crate::input::DisassociateSubnetsInput)
    pub fn builder() -> crate::input::disassociate_subnets_input::Builder {
        crate::input::disassociate_subnets_input::Builder::default()
    }
    /// Creates a new `DisassociateSubnets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateSubnets {
    type Output = std::result::Result<
        crate::output::DisassociateSubnetsOutput,
        crate::error::DisassociateSubnetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_subnets_error(response)
        } else {
            crate::operation_deser::parse_disassociate_subnets_response(response)
        }
    }
}

/// Operation shape for `ListFirewallPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_firewall_policies`](crate::client::Client::list_firewall_policies).
///
/// See [`crate::client::fluent_builders::ListFirewallPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFirewallPolicies {
    _private: (),
}
impl ListFirewallPolicies {
    /// Creates a new builder-style object to manufacture [`ListFirewallPoliciesInput`](crate::input::ListFirewallPoliciesInput)
    pub fn builder() -> crate::input::list_firewall_policies_input::Builder {
        crate::input::list_firewall_policies_input::Builder::default()
    }
    /// Creates a new `ListFirewallPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFirewallPolicies {
    type Output = std::result::Result<
        crate::output::ListFirewallPoliciesOutput,
        crate::error::ListFirewallPoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_firewall_policies_error(response)
        } else {
            crate::operation_deser::parse_list_firewall_policies_response(response)
        }
    }
}

/// Operation shape for `ListFirewalls`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_firewalls`](crate::client::Client::list_firewalls).
///
/// See [`crate::client::fluent_builders::ListFirewalls`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFirewalls {
    _private: (),
}
impl ListFirewalls {
    /// Creates a new builder-style object to manufacture [`ListFirewallsInput`](crate::input::ListFirewallsInput)
    pub fn builder() -> crate::input::list_firewalls_input::Builder {
        crate::input::list_firewalls_input::Builder::default()
    }
    /// Creates a new `ListFirewalls` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFirewalls {
    type Output =
        std::result::Result<crate::output::ListFirewallsOutput, crate::error::ListFirewallsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_firewalls_error(response)
        } else {
            crate::operation_deser::parse_list_firewalls_response(response)
        }
    }
}

/// Operation shape for `ListRuleGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_rule_groups`](crate::client::Client::list_rule_groups).
///
/// See [`crate::client::fluent_builders::ListRuleGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRuleGroups {
    _private: (),
}
impl ListRuleGroups {
    /// Creates a new builder-style object to manufacture [`ListRuleGroupsInput`](crate::input::ListRuleGroupsInput)
    pub fn builder() -> crate::input::list_rule_groups_input::Builder {
        crate::input::list_rule_groups_input::Builder::default()
    }
    /// Creates a new `ListRuleGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRuleGroups {
    type Output =
        std::result::Result<crate::output::ListRuleGroupsOutput, crate::error::ListRuleGroupsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_rule_groups_error(response)
        } else {
            crate::operation_deser::parse_list_rule_groups_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_resource_policy`](crate::client::Client::put_resource_policy).
///
/// See [`crate::client::fluent_builders::PutResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutResourcePolicy {
    _private: (),
}
impl PutResourcePolicy {
    /// Creates a new builder-style object to manufacture [`PutResourcePolicyInput`](crate::input::PutResourcePolicyInput)
    pub fn builder() -> crate::input::put_resource_policy_input::Builder {
        crate::input::put_resource_policy_input::Builder::default()
    }
    /// Creates a new `PutResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutResourcePolicy {
    type Output = std::result::Result<
        crate::output::PutResourcePolicyOutput,
        crate::error::PutResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_put_resource_policy_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateFirewallDeleteProtection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_firewall_delete_protection`](crate::client::Client::update_firewall_delete_protection).
///
/// See [`crate::client::fluent_builders::UpdateFirewallDeleteProtection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFirewallDeleteProtection {
    _private: (),
}
impl UpdateFirewallDeleteProtection {
    /// Creates a new builder-style object to manufacture [`UpdateFirewallDeleteProtectionInput`](crate::input::UpdateFirewallDeleteProtectionInput)
    pub fn builder() -> crate::input::update_firewall_delete_protection_input::Builder {
        crate::input::update_firewall_delete_protection_input::Builder::default()
    }
    /// Creates a new `UpdateFirewallDeleteProtection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFirewallDeleteProtection {
    type Output = std::result::Result<
        crate::output::UpdateFirewallDeleteProtectionOutput,
        crate::error::UpdateFirewallDeleteProtectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_firewall_delete_protection_error(response)
        } else {
            crate::operation_deser::parse_update_firewall_delete_protection_response(response)
        }
    }
}

/// Operation shape for `UpdateFirewallDescription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_firewall_description`](crate::client::Client::update_firewall_description).
///
/// See [`crate::client::fluent_builders::UpdateFirewallDescription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFirewallDescription {
    _private: (),
}
impl UpdateFirewallDescription {
    /// Creates a new builder-style object to manufacture [`UpdateFirewallDescriptionInput`](crate::input::UpdateFirewallDescriptionInput)
    pub fn builder() -> crate::input::update_firewall_description_input::Builder {
        crate::input::update_firewall_description_input::Builder::default()
    }
    /// Creates a new `UpdateFirewallDescription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFirewallDescription {
    type Output = std::result::Result<
        crate::output::UpdateFirewallDescriptionOutput,
        crate::error::UpdateFirewallDescriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_firewall_description_error(response)
        } else {
            crate::operation_deser::parse_update_firewall_description_response(response)
        }
    }
}

/// Operation shape for `UpdateFirewallEncryptionConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_firewall_encryption_configuration`](crate::client::Client::update_firewall_encryption_configuration).
///
/// See [`crate::client::fluent_builders::UpdateFirewallEncryptionConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFirewallEncryptionConfiguration {
    _private: (),
}
impl UpdateFirewallEncryptionConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateFirewallEncryptionConfigurationInput`](crate::input::UpdateFirewallEncryptionConfigurationInput)
    pub fn builder() -> crate::input::update_firewall_encryption_configuration_input::Builder {
        crate::input::update_firewall_encryption_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateFirewallEncryptionConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFirewallEncryptionConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateFirewallEncryptionConfigurationOutput,
        crate::error::UpdateFirewallEncryptionConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_firewall_encryption_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_firewall_encryption_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `UpdateFirewallPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_firewall_policy`](crate::client::Client::update_firewall_policy).
///
/// See [`crate::client::fluent_builders::UpdateFirewallPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFirewallPolicy {
    _private: (),
}
impl UpdateFirewallPolicy {
    /// Creates a new builder-style object to manufacture [`UpdateFirewallPolicyInput`](crate::input::UpdateFirewallPolicyInput)
    pub fn builder() -> crate::input::update_firewall_policy_input::Builder {
        crate::input::update_firewall_policy_input::Builder::default()
    }
    /// Creates a new `UpdateFirewallPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFirewallPolicy {
    type Output = std::result::Result<
        crate::output::UpdateFirewallPolicyOutput,
        crate::error::UpdateFirewallPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_firewall_policy_error(response)
        } else {
            crate::operation_deser::parse_update_firewall_policy_response(response)
        }
    }
}

/// Operation shape for `UpdateFirewallPolicyChangeProtection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_firewall_policy_change_protection`](crate::client::Client::update_firewall_policy_change_protection).
///
/// See [`crate::client::fluent_builders::UpdateFirewallPolicyChangeProtection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFirewallPolicyChangeProtection {
    _private: (),
}
impl UpdateFirewallPolicyChangeProtection {
    /// Creates a new builder-style object to manufacture [`UpdateFirewallPolicyChangeProtectionInput`](crate::input::UpdateFirewallPolicyChangeProtectionInput)
    pub fn builder() -> crate::input::update_firewall_policy_change_protection_input::Builder {
        crate::input::update_firewall_policy_change_protection_input::Builder::default()
    }
    /// Creates a new `UpdateFirewallPolicyChangeProtection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFirewallPolicyChangeProtection {
    type Output = std::result::Result<
        crate::output::UpdateFirewallPolicyChangeProtectionOutput,
        crate::error::UpdateFirewallPolicyChangeProtectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_firewall_policy_change_protection_error(response)
        } else {
            crate::operation_deser::parse_update_firewall_policy_change_protection_response(
                response,
            )
        }
    }
}

/// Operation shape for `UpdateLoggingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_logging_configuration`](crate::client::Client::update_logging_configuration).
///
/// See [`crate::client::fluent_builders::UpdateLoggingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLoggingConfiguration {
    _private: (),
}
impl UpdateLoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateLoggingConfigurationInput`](crate::input::UpdateLoggingConfigurationInput)
    pub fn builder() -> crate::input::update_logging_configuration_input::Builder {
        crate::input::update_logging_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateLoggingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLoggingConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateLoggingConfigurationOutput,
        crate::error::UpdateLoggingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_logging_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_logging_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateRuleGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_rule_group`](crate::client::Client::update_rule_group).
///
/// See [`crate::client::fluent_builders::UpdateRuleGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRuleGroup {
    _private: (),
}
impl UpdateRuleGroup {
    /// Creates a new builder-style object to manufacture [`UpdateRuleGroupInput`](crate::input::UpdateRuleGroupInput)
    pub fn builder() -> crate::input::update_rule_group_input::Builder {
        crate::input::update_rule_group_input::Builder::default()
    }
    /// Creates a new `UpdateRuleGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRuleGroup {
    type Output = std::result::Result<
        crate::output::UpdateRuleGroupOutput,
        crate::error::UpdateRuleGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_rule_group_error(response)
        } else {
            crate::operation_deser::parse_update_rule_group_response(response)
        }
    }
}

/// Operation shape for `UpdateSubnetChangeProtection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_subnet_change_protection`](crate::client::Client::update_subnet_change_protection).
///
/// See [`crate::client::fluent_builders::UpdateSubnetChangeProtection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSubnetChangeProtection {
    _private: (),
}
impl UpdateSubnetChangeProtection {
    /// Creates a new builder-style object to manufacture [`UpdateSubnetChangeProtectionInput`](crate::input::UpdateSubnetChangeProtectionInput)
    pub fn builder() -> crate::input::update_subnet_change_protection_input::Builder {
        crate::input::update_subnet_change_protection_input::Builder::default()
    }
    /// Creates a new `UpdateSubnetChangeProtection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSubnetChangeProtection {
    type Output = std::result::Result<
        crate::output::UpdateSubnetChangeProtectionOutput,
        crate::error::UpdateSubnetChangeProtectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_subnet_change_protection_error(response)
        } else {
            crate::operation_deser::parse_update_subnet_change_protection_response(response)
        }
    }
}
