// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleGroupResponse {
    /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
    /// <note>
    /// <p>If this response is for a create request that had <code>DryRun</code> set to
    /// <code>TRUE</code>, then this ARN is a placeholder that isn't attached to a valid
    /// resource.</p>
    /// </note>
    pub rule_group_arn: std::option::Option<std::string::String>,
    /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
    pub rule_group_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the rule group. </p>
    pub rule_group_id: std::option::Option<std::string::String>,
    /// <p>A description of the rule group. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
    /// stateless rules. If it is stateful, it contains stateful rules. </p>
    pub r#type: std::option::Option<crate::model::RuleGroupType>,
    /// <p>The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation.
    /// When you update a rule group, you are limited to this capacity. When you reference a rule group
    /// from a firewall policy, Network Firewall reserves this capacity for the rule group. </p>
    /// <p>You can retrieve the capacity that would be required for a rule group before you create the rule group by calling
    /// <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>. </p>
    pub capacity: std::option::Option<i32>,
    /// <p>Detailed information about the current status of a rule group. </p>
    pub rule_group_status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>The key:value pairs to associate with the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The number of capacity units currently consumed by the rule group rules. </p>
    pub consumed_capacity: std::option::Option<i32>,
    /// <p>The number of firewall policies that use this rule group.</p>
    pub number_of_associations: std::option::Option<i32>,
}
impl RuleGroupResponse {
    /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
    /// <note>
    /// <p>If this response is for a create request that had <code>DryRun</code> set to
    /// <code>TRUE</code>, then this ARN is a placeholder that isn't attached to a valid
    /// resource.</p>
    /// </note>
    pub fn rule_group_arn(&self) -> std::option::Option<&str> {
        self.rule_group_arn.as_deref()
    }
    /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
    pub fn rule_group_name(&self) -> std::option::Option<&str> {
        self.rule_group_name.as_deref()
    }
    /// <p>The unique identifier for the rule group. </p>
    pub fn rule_group_id(&self) -> std::option::Option<&str> {
        self.rule_group_id.as_deref()
    }
    /// <p>A description of the rule group. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
    /// stateless rules. If it is stateful, it contains stateful rules. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::RuleGroupType> {
        self.r#type.as_ref()
    }
    /// <p>The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation.
    /// When you update a rule group, you are limited to this capacity. When you reference a rule group
    /// from a firewall policy, Network Firewall reserves this capacity for the rule group. </p>
    /// <p>You can retrieve the capacity that would be required for a rule group before you create the rule group by calling
    /// <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>. </p>
    pub fn capacity(&self) -> std::option::Option<i32> {
        self.capacity
    }
    /// <p>Detailed information about the current status of a rule group. </p>
    pub fn rule_group_status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.rule_group_status.as_ref()
    }
    /// <p>The key:value pairs to associate with the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The number of capacity units currently consumed by the rule group rules. </p>
    pub fn consumed_capacity(&self) -> std::option::Option<i32> {
        self.consumed_capacity
    }
    /// <p>The number of firewall policies that use this rule group.</p>
    pub fn number_of_associations(&self) -> std::option::Option<i32> {
        self.number_of_associations
    }
}
impl std::fmt::Debug for RuleGroupResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleGroupResponse");
        formatter.field("rule_group_arn", &self.rule_group_arn);
        formatter.field("rule_group_name", &self.rule_group_name);
        formatter.field("rule_group_id", &self.rule_group_id);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("capacity", &self.capacity);
        formatter.field("rule_group_status", &self.rule_group_status);
        formatter.field("tags", &self.tags);
        formatter.field("consumed_capacity", &self.consumed_capacity);
        formatter.field("number_of_associations", &self.number_of_associations);
        formatter.finish()
    }
}
/// See [`RuleGroupResponse`](crate::model::RuleGroupResponse)
pub mod rule_group_response {
    /// A builder for [`RuleGroupResponse`](crate::model::RuleGroupResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_group_arn: std::option::Option<std::string::String>,
        pub(crate) rule_group_name: std::option::Option<std::string::String>,
        pub(crate) rule_group_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::RuleGroupType>,
        pub(crate) capacity: std::option::Option<i32>,
        pub(crate) rule_group_status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) consumed_capacity: std::option::Option<i32>,
        pub(crate) number_of_associations: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
        /// <note>
        /// <p>If this response is for a create request that had <code>DryRun</code> set to
        /// <code>TRUE</code>, then this ARN is a placeholder that isn't attached to a valid
        /// resource.</p>
        /// </note>
        pub fn rule_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
        /// <note>
        /// <p>If this response is for a create request that had <code>DryRun</code> set to
        /// <code>TRUE</code>, then this ARN is a placeholder that isn't attached to a valid
        /// resource.</p>
        /// </note>
        pub fn set_rule_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_group_arn = input;
            self
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        pub fn rule_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_group_name = Some(input.into());
            self
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        pub fn set_rule_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_group_name = input;
            self
        }
        /// <p>The unique identifier for the rule group. </p>
        pub fn rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the rule group. </p>
        pub fn set_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_group_id = input;
            self
        }
        /// <p>A description of the rule group. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the rule group. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
        /// stateless rules. If it is stateful, it contains stateful rules. </p>
        pub fn r#type(mut self, input: crate::model::RuleGroupType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
        /// stateless rules. If it is stateful, it contains stateful rules. </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RuleGroupType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation.
        /// When you update a rule group, you are limited to this capacity. When you reference a rule group
        /// from a firewall policy, Network Firewall reserves this capacity for the rule group. </p>
        /// <p>You can retrieve the capacity that would be required for a rule group before you create the rule group by calling
        /// <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>. </p>
        pub fn capacity(mut self, input: i32) -> Self {
            self.capacity = Some(input);
            self
        }
        /// <p>The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation.
        /// When you update a rule group, you are limited to this capacity. When you reference a rule group
        /// from a firewall policy, Network Firewall reserves this capacity for the rule group. </p>
        /// <p>You can retrieve the capacity that would be required for a rule group before you create the rule group by calling
        /// <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>. </p>
        pub fn set_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.capacity = input;
            self
        }
        /// <p>Detailed information about the current status of a rule group. </p>
        pub fn rule_group_status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.rule_group_status = Some(input);
            self
        }
        /// <p>Detailed information about the current status of a rule group. </p>
        pub fn set_rule_group_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.rule_group_status = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key:value pairs to associate with the resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The key:value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The number of capacity units currently consumed by the rule group rules. </p>
        pub fn consumed_capacity(mut self, input: i32) -> Self {
            self.consumed_capacity = Some(input);
            self
        }
        /// <p>The number of capacity units currently consumed by the rule group rules. </p>
        pub fn set_consumed_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.consumed_capacity = input;
            self
        }
        /// <p>The number of firewall policies that use this rule group.</p>
        pub fn number_of_associations(mut self, input: i32) -> Self {
            self.number_of_associations = Some(input);
            self
        }
        /// <p>The number of firewall policies that use this rule group.</p>
        pub fn set_number_of_associations(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_associations = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleGroupResponse`](crate::model::RuleGroupResponse)
        pub fn build(self) -> crate::model::RuleGroupResponse {
            crate::model::RuleGroupResponse {
                rule_group_arn: self.rule_group_arn,
                rule_group_name: self.rule_group_name,
                rule_group_id: self.rule_group_id,
                description: self.description,
                r#type: self.r#type,
                capacity: self.capacity,
                rule_group_status: self.rule_group_status,
                tags: self.tags,
                consumed_capacity: self.consumed_capacity,
                number_of_associations: self.number_of_associations,
            }
        }
    }
}
impl RuleGroupResponse {
    /// Creates a new builder-style object to manufacture [`RuleGroupResponse`](crate::model::RuleGroupResponse)
    pub fn builder() -> crate::model::rule_group_response::Builder {
        crate::model::rule_group_response::Builder::default()
    }
}

/// <p>A key:value pair associated with an AWS resource. The key:value pair can be anything you
/// define. Typically, the tag key represents a category (such as "environment") and the tag
/// value represents a specific value within that category (such as "test," "development," or
/// "production"). You can add up to 50 tags to each AWS resource. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The part of the key:value pair that defines a tag. You can use a tag key to describe a
    /// category of information, such as "customer." Tag keys are case-sensitive.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The part of the key:value pair that defines a tag. You can use a tag value to describe a
    /// specific value within a category, such as "companyA" or "companyB." Tag values are
    /// case-sensitive.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The part of the key:value pair that defines a tag. You can use a tag key to describe a
    /// category of information, such as "customer." Tag keys are case-sensitive.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The part of the key:value pair that defines a tag. You can use a tag value to describe a
    /// specific value within a category, such as "companyA" or "companyB." Tag values are
    /// case-sensitive.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The part of the key:value pair that defines a tag. You can use a tag key to describe a
        /// category of information, such as "customer." Tag keys are case-sensitive.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The part of the key:value pair that defines a tag. You can use a tag key to describe a
        /// category of information, such as "customer." Tag keys are case-sensitive.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The part of the key:value pair that defines a tag. You can use a tag value to describe a
        /// specific value within a category, such as "companyA" or "companyB." Tag values are
        /// case-sensitive.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The part of the key:value pair that defines a tag. You can use a tag value to describe a
        /// specific value within a category, such as "companyA" or "companyB." Tag values are
        /// case-sensitive.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ResourceStatus::Active,
            "DELETING" => ResourceStatus::Deleting,
            other => ResourceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceStatus::from(s))
    }
}
impl ResourceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceStatus::Active => "ACTIVE",
            ResourceStatus::Deleting => "DELETING",
            ResourceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DELETING"]
    }
}
impl AsRef<str> for ResourceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RuleGroupType {
    #[allow(missing_docs)] // documentation missing in model
    Stateful,
    #[allow(missing_docs)] // documentation missing in model
    Stateless,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RuleGroupType {
    fn from(s: &str) -> Self {
        match s {
            "STATEFUL" => RuleGroupType::Stateful,
            "STATELESS" => RuleGroupType::Stateless,
            other => RuleGroupType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RuleGroupType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RuleGroupType::from(s))
    }
}
impl RuleGroupType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RuleGroupType::Stateful => "STATEFUL",
            RuleGroupType::Stateless => "STATELESS",
            RuleGroupType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["STATEFUL", "STATELESS"]
    }
}
impl AsRef<str> for RuleGroupType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The object that defines the rules in a rule group. This, along with <a>RuleGroupResponse</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>
/// <p>AWS Network Firewall uses a rule group to inspect and control network traffic.
/// You define stateless rule groups to inspect individual packets and you define stateful rule groups to inspect packets in the context of their
/// traffic flow. </p>
/// <p>To use a rule group, you include it by reference in an Network Firewall firewall policy, then you use the policy in a firewall. You can reference a rule group from
/// more than one firewall policy, and you can use a firewall policy in more than one firewall. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleGroup {
    /// <p>Settings that are available for use in the rules in the rule group. You can only use
    /// these for stateful rule groups. </p>
    pub rule_variables: std::option::Option<crate::model::RuleVariables>,
    /// <p>The stateful rules or stateless rules for the rule group. </p>
    pub rules_source: std::option::Option<crate::model::RulesSource>,
    /// <p>Additional options governing how Network Firewall handles stateful rules. The policies where you use your stateful
    /// rule group must have stateful rule options settings that are compatible with these settings.</p>
    pub stateful_rule_options: std::option::Option<crate::model::StatefulRuleOptions>,
}
impl RuleGroup {
    /// <p>Settings that are available for use in the rules in the rule group. You can only use
    /// these for stateful rule groups. </p>
    pub fn rule_variables(&self) -> std::option::Option<&crate::model::RuleVariables> {
        self.rule_variables.as_ref()
    }
    /// <p>The stateful rules or stateless rules for the rule group. </p>
    pub fn rules_source(&self) -> std::option::Option<&crate::model::RulesSource> {
        self.rules_source.as_ref()
    }
    /// <p>Additional options governing how Network Firewall handles stateful rules. The policies where you use your stateful
    /// rule group must have stateful rule options settings that are compatible with these settings.</p>
    pub fn stateful_rule_options(&self) -> std::option::Option<&crate::model::StatefulRuleOptions> {
        self.stateful_rule_options.as_ref()
    }
}
impl std::fmt::Debug for RuleGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleGroup");
        formatter.field("rule_variables", &self.rule_variables);
        formatter.field("rules_source", &self.rules_source);
        formatter.field("stateful_rule_options", &self.stateful_rule_options);
        formatter.finish()
    }
}
/// See [`RuleGroup`](crate::model::RuleGroup)
pub mod rule_group {
    /// A builder for [`RuleGroup`](crate::model::RuleGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_variables: std::option::Option<crate::model::RuleVariables>,
        pub(crate) rules_source: std::option::Option<crate::model::RulesSource>,
        pub(crate) stateful_rule_options: std::option::Option<crate::model::StatefulRuleOptions>,
    }
    impl Builder {
        /// <p>Settings that are available for use in the rules in the rule group. You can only use
        /// these for stateful rule groups. </p>
        pub fn rule_variables(mut self, input: crate::model::RuleVariables) -> Self {
            self.rule_variables = Some(input);
            self
        }
        /// <p>Settings that are available for use in the rules in the rule group. You can only use
        /// these for stateful rule groups. </p>
        pub fn set_rule_variables(
            mut self,
            input: std::option::Option<crate::model::RuleVariables>,
        ) -> Self {
            self.rule_variables = input;
            self
        }
        /// <p>The stateful rules or stateless rules for the rule group. </p>
        pub fn rules_source(mut self, input: crate::model::RulesSource) -> Self {
            self.rules_source = Some(input);
            self
        }
        /// <p>The stateful rules or stateless rules for the rule group. </p>
        pub fn set_rules_source(
            mut self,
            input: std::option::Option<crate::model::RulesSource>,
        ) -> Self {
            self.rules_source = input;
            self
        }
        /// <p>Additional options governing how Network Firewall handles stateful rules. The policies where you use your stateful
        /// rule group must have stateful rule options settings that are compatible with these settings.</p>
        pub fn stateful_rule_options(mut self, input: crate::model::StatefulRuleOptions) -> Self {
            self.stateful_rule_options = Some(input);
            self
        }
        /// <p>Additional options governing how Network Firewall handles stateful rules. The policies where you use your stateful
        /// rule group must have stateful rule options settings that are compatible with these settings.</p>
        pub fn set_stateful_rule_options(
            mut self,
            input: std::option::Option<crate::model::StatefulRuleOptions>,
        ) -> Self {
            self.stateful_rule_options = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleGroup`](crate::model::RuleGroup)
        pub fn build(self) -> crate::model::RuleGroup {
            crate::model::RuleGroup {
                rule_variables: self.rule_variables,
                rules_source: self.rules_source,
                stateful_rule_options: self.stateful_rule_options,
            }
        }
    }
}
impl RuleGroup {
    /// Creates a new builder-style object to manufacture [`RuleGroup`](crate::model::RuleGroup)
    pub fn builder() -> crate::model::rule_group::Builder {
        crate::model::rule_group::Builder::default()
    }
}

/// <p>Additional options governing how Network Firewall handles the rule group. You can only use these for stateful rule groups.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatefulRuleOptions {
    /// <p>Indicates how to manage the order of the rule evaluation for the rule group. By default, Network Firewall
    /// leaves the rule evaluation order up to the Suricata rule processing engine. If you set
    /// this to <code>STRICT_ORDER</code>, your rules are evaluated in the exact order that they're listed
    /// in your Suricata rules string. </p>
    pub rule_order: std::option::Option<crate::model::RuleOrder>,
}
impl StatefulRuleOptions {
    /// <p>Indicates how to manage the order of the rule evaluation for the rule group. By default, Network Firewall
    /// leaves the rule evaluation order up to the Suricata rule processing engine. If you set
    /// this to <code>STRICT_ORDER</code>, your rules are evaluated in the exact order that they're listed
    /// in your Suricata rules string. </p>
    pub fn rule_order(&self) -> std::option::Option<&crate::model::RuleOrder> {
        self.rule_order.as_ref()
    }
}
impl std::fmt::Debug for StatefulRuleOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatefulRuleOptions");
        formatter.field("rule_order", &self.rule_order);
        formatter.finish()
    }
}
/// See [`StatefulRuleOptions`](crate::model::StatefulRuleOptions)
pub mod stateful_rule_options {
    /// A builder for [`StatefulRuleOptions`](crate::model::StatefulRuleOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_order: std::option::Option<crate::model::RuleOrder>,
    }
    impl Builder {
        /// <p>Indicates how to manage the order of the rule evaluation for the rule group. By default, Network Firewall
        /// leaves the rule evaluation order up to the Suricata rule processing engine. If you set
        /// this to <code>STRICT_ORDER</code>, your rules are evaluated in the exact order that they're listed
        /// in your Suricata rules string. </p>
        pub fn rule_order(mut self, input: crate::model::RuleOrder) -> Self {
            self.rule_order = Some(input);
            self
        }
        /// <p>Indicates how to manage the order of the rule evaluation for the rule group. By default, Network Firewall
        /// leaves the rule evaluation order up to the Suricata rule processing engine. If you set
        /// this to <code>STRICT_ORDER</code>, your rules are evaluated in the exact order that they're listed
        /// in your Suricata rules string. </p>
        pub fn set_rule_order(
            mut self,
            input: std::option::Option<crate::model::RuleOrder>,
        ) -> Self {
            self.rule_order = input;
            self
        }
        /// Consumes the builder and constructs a [`StatefulRuleOptions`](crate::model::StatefulRuleOptions)
        pub fn build(self) -> crate::model::StatefulRuleOptions {
            crate::model::StatefulRuleOptions {
                rule_order: self.rule_order,
            }
        }
    }
}
impl StatefulRuleOptions {
    /// Creates a new builder-style object to manufacture [`StatefulRuleOptions`](crate::model::StatefulRuleOptions)
    pub fn builder() -> crate::model::stateful_rule_options::Builder {
        crate::model::stateful_rule_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RuleOrder {
    #[allow(missing_docs)] // documentation missing in model
    DefaultActionOrder,
    #[allow(missing_docs)] // documentation missing in model
    StrictOrder,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RuleOrder {
    fn from(s: &str) -> Self {
        match s {
            "DEFAULT_ACTION_ORDER" => RuleOrder::DefaultActionOrder,
            "STRICT_ORDER" => RuleOrder::StrictOrder,
            other => RuleOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RuleOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RuleOrder::from(s))
    }
}
impl RuleOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RuleOrder::DefaultActionOrder => "DEFAULT_ACTION_ORDER",
            RuleOrder::StrictOrder => "STRICT_ORDER",
            RuleOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEFAULT_ACTION_ORDER", "STRICT_ORDER"]
    }
}
impl AsRef<str> for RuleOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The stateless or stateful rules definitions for use in a single rule group. Each rule
/// group requires a single <code>RulesSource</code>. You can use an instance of this for
/// either stateless rules or stateful rules. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RulesSource {
    /// <p>Stateful inspection criteria, provided in Suricata compatible intrusion prevention
    /// system (IPS) rules. Suricata is an open-source network IPS that includes a standard
    /// rule-based language for network traffic inspection.</p>
    /// <p>These rules contain the inspection criteria and the action to take for traffic that
    /// matches the criteria, so this type of rule group doesn't have a separate action
    /// setting.</p>
    pub rules_string: std::option::Option<std::string::String>,
    /// <p>Stateful inspection criteria for a domain list rule group. </p>
    pub rules_source_list: std::option::Option<crate::model::RulesSourceList>,
    /// <p>An array of individual stateful rules inspection criteria to be used together in a stateful rule group.
    /// Use this option to specify simple Suricata rules with protocol, source and destination, ports, direction, and rule options.
    /// For information about the Suricata <code>Rules</code> format, see
    /// <a href="https://suricata.readthedocs.io/en/suricata-5.0.0/rules/intro.html#">Rules Format</a>. </p>
    pub stateful_rules: std::option::Option<std::vec::Vec<crate::model::StatefulRule>>,
    /// <p>Stateless inspection criteria to be used in a stateless rule group. </p>
    pub stateless_rules_and_custom_actions:
        std::option::Option<crate::model::StatelessRulesAndCustomActions>,
}
impl RulesSource {
    /// <p>Stateful inspection criteria, provided in Suricata compatible intrusion prevention
    /// system (IPS) rules. Suricata is an open-source network IPS that includes a standard
    /// rule-based language for network traffic inspection.</p>
    /// <p>These rules contain the inspection criteria and the action to take for traffic that
    /// matches the criteria, so this type of rule group doesn't have a separate action
    /// setting.</p>
    pub fn rules_string(&self) -> std::option::Option<&str> {
        self.rules_string.as_deref()
    }
    /// <p>Stateful inspection criteria for a domain list rule group. </p>
    pub fn rules_source_list(&self) -> std::option::Option<&crate::model::RulesSourceList> {
        self.rules_source_list.as_ref()
    }
    /// <p>An array of individual stateful rules inspection criteria to be used together in a stateful rule group.
    /// Use this option to specify simple Suricata rules with protocol, source and destination, ports, direction, and rule options.
    /// For information about the Suricata <code>Rules</code> format, see
    /// <a href="https://suricata.readthedocs.io/en/suricata-5.0.0/rules/intro.html#">Rules Format</a>. </p>
    pub fn stateful_rules(&self) -> std::option::Option<&[crate::model::StatefulRule]> {
        self.stateful_rules.as_deref()
    }
    /// <p>Stateless inspection criteria to be used in a stateless rule group. </p>
    pub fn stateless_rules_and_custom_actions(
        &self,
    ) -> std::option::Option<&crate::model::StatelessRulesAndCustomActions> {
        self.stateless_rules_and_custom_actions.as_ref()
    }
}
impl std::fmt::Debug for RulesSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RulesSource");
        formatter.field("rules_string", &self.rules_string);
        formatter.field("rules_source_list", &self.rules_source_list);
        formatter.field("stateful_rules", &self.stateful_rules);
        formatter.field(
            "stateless_rules_and_custom_actions",
            &self.stateless_rules_and_custom_actions,
        );
        formatter.finish()
    }
}
/// See [`RulesSource`](crate::model::RulesSource)
pub mod rules_source {
    /// A builder for [`RulesSource`](crate::model::RulesSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rules_string: std::option::Option<std::string::String>,
        pub(crate) rules_source_list: std::option::Option<crate::model::RulesSourceList>,
        pub(crate) stateful_rules: std::option::Option<std::vec::Vec<crate::model::StatefulRule>>,
        pub(crate) stateless_rules_and_custom_actions:
            std::option::Option<crate::model::StatelessRulesAndCustomActions>,
    }
    impl Builder {
        /// <p>Stateful inspection criteria, provided in Suricata compatible intrusion prevention
        /// system (IPS) rules. Suricata is an open-source network IPS that includes a standard
        /// rule-based language for network traffic inspection.</p>
        /// <p>These rules contain the inspection criteria and the action to take for traffic that
        /// matches the criteria, so this type of rule group doesn't have a separate action
        /// setting.</p>
        pub fn rules_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.rules_string = Some(input.into());
            self
        }
        /// <p>Stateful inspection criteria, provided in Suricata compatible intrusion prevention
        /// system (IPS) rules. Suricata is an open-source network IPS that includes a standard
        /// rule-based language for network traffic inspection.</p>
        /// <p>These rules contain the inspection criteria and the action to take for traffic that
        /// matches the criteria, so this type of rule group doesn't have a separate action
        /// setting.</p>
        pub fn set_rules_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rules_string = input;
            self
        }
        /// <p>Stateful inspection criteria for a domain list rule group. </p>
        pub fn rules_source_list(mut self, input: crate::model::RulesSourceList) -> Self {
            self.rules_source_list = Some(input);
            self
        }
        /// <p>Stateful inspection criteria for a domain list rule group. </p>
        pub fn set_rules_source_list(
            mut self,
            input: std::option::Option<crate::model::RulesSourceList>,
        ) -> Self {
            self.rules_source_list = input;
            self
        }
        /// Appends an item to `stateful_rules`.
        ///
        /// To override the contents of this collection use [`set_stateful_rules`](Self::set_stateful_rules).
        ///
        /// <p>An array of individual stateful rules inspection criteria to be used together in a stateful rule group.
        /// Use this option to specify simple Suricata rules with protocol, source and destination, ports, direction, and rule options.
        /// For information about the Suricata <code>Rules</code> format, see
        /// <a href="https://suricata.readthedocs.io/en/suricata-5.0.0/rules/intro.html#">Rules Format</a>. </p>
        pub fn stateful_rules(mut self, input: impl Into<crate::model::StatefulRule>) -> Self {
            let mut v = self.stateful_rules.unwrap_or_default();
            v.push(input.into());
            self.stateful_rules = Some(v);
            self
        }
        /// <p>An array of individual stateful rules inspection criteria to be used together in a stateful rule group.
        /// Use this option to specify simple Suricata rules with protocol, source and destination, ports, direction, and rule options.
        /// For information about the Suricata <code>Rules</code> format, see
        /// <a href="https://suricata.readthedocs.io/en/suricata-5.0.0/rules/intro.html#">Rules Format</a>. </p>
        pub fn set_stateful_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StatefulRule>>,
        ) -> Self {
            self.stateful_rules = input;
            self
        }
        /// <p>Stateless inspection criteria to be used in a stateless rule group. </p>
        pub fn stateless_rules_and_custom_actions(
            mut self,
            input: crate::model::StatelessRulesAndCustomActions,
        ) -> Self {
            self.stateless_rules_and_custom_actions = Some(input);
            self
        }
        /// <p>Stateless inspection criteria to be used in a stateless rule group. </p>
        pub fn set_stateless_rules_and_custom_actions(
            mut self,
            input: std::option::Option<crate::model::StatelessRulesAndCustomActions>,
        ) -> Self {
            self.stateless_rules_and_custom_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`RulesSource`](crate::model::RulesSource)
        pub fn build(self) -> crate::model::RulesSource {
            crate::model::RulesSource {
                rules_string: self.rules_string,
                rules_source_list: self.rules_source_list,
                stateful_rules: self.stateful_rules,
                stateless_rules_and_custom_actions: self.stateless_rules_and_custom_actions,
            }
        }
    }
}
impl RulesSource {
    /// Creates a new builder-style object to manufacture [`RulesSource`](crate::model::RulesSource)
    pub fn builder() -> crate::model::rules_source::Builder {
        crate::model::rules_source::Builder::default()
    }
}

/// <p>Stateless inspection criteria. Each stateless rule group uses exactly one of these data
/// types to define its stateless rules. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatelessRulesAndCustomActions {
    /// <p>Defines the set of stateless rules for use in a stateless rule group. </p>
    pub stateless_rules: std::option::Option<std::vec::Vec<crate::model::StatelessRule>>,
    /// <p>Defines an array of individual custom action definitions that are available for use by
    /// the stateless rules in this <code>StatelessRulesAndCustomActions</code> specification. You
    /// name each custom action that you define, and then you can use it by name in your <a>StatelessRule</a>
    /// <a>RuleDefinition</a>
    /// <code>Actions</code> specification.</p>
    pub custom_actions: std::option::Option<std::vec::Vec<crate::model::CustomAction>>,
}
impl StatelessRulesAndCustomActions {
    /// <p>Defines the set of stateless rules for use in a stateless rule group. </p>
    pub fn stateless_rules(&self) -> std::option::Option<&[crate::model::StatelessRule]> {
        self.stateless_rules.as_deref()
    }
    /// <p>Defines an array of individual custom action definitions that are available for use by
    /// the stateless rules in this <code>StatelessRulesAndCustomActions</code> specification. You
    /// name each custom action that you define, and then you can use it by name in your <a>StatelessRule</a>
    /// <a>RuleDefinition</a>
    /// <code>Actions</code> specification.</p>
    pub fn custom_actions(&self) -> std::option::Option<&[crate::model::CustomAction]> {
        self.custom_actions.as_deref()
    }
}
impl std::fmt::Debug for StatelessRulesAndCustomActions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatelessRulesAndCustomActions");
        formatter.field("stateless_rules", &self.stateless_rules);
        formatter.field("custom_actions", &self.custom_actions);
        formatter.finish()
    }
}
/// See [`StatelessRulesAndCustomActions`](crate::model::StatelessRulesAndCustomActions)
pub mod stateless_rules_and_custom_actions {
    /// A builder for [`StatelessRulesAndCustomActions`](crate::model::StatelessRulesAndCustomActions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stateless_rules: std::option::Option<std::vec::Vec<crate::model::StatelessRule>>,
        pub(crate) custom_actions: std::option::Option<std::vec::Vec<crate::model::CustomAction>>,
    }
    impl Builder {
        /// Appends an item to `stateless_rules`.
        ///
        /// To override the contents of this collection use [`set_stateless_rules`](Self::set_stateless_rules).
        ///
        /// <p>Defines the set of stateless rules for use in a stateless rule group. </p>
        pub fn stateless_rules(mut self, input: impl Into<crate::model::StatelessRule>) -> Self {
            let mut v = self.stateless_rules.unwrap_or_default();
            v.push(input.into());
            self.stateless_rules = Some(v);
            self
        }
        /// <p>Defines the set of stateless rules for use in a stateless rule group. </p>
        pub fn set_stateless_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StatelessRule>>,
        ) -> Self {
            self.stateless_rules = input;
            self
        }
        /// Appends an item to `custom_actions`.
        ///
        /// To override the contents of this collection use [`set_custom_actions`](Self::set_custom_actions).
        ///
        /// <p>Defines an array of individual custom action definitions that are available for use by
        /// the stateless rules in this <code>StatelessRulesAndCustomActions</code> specification. You
        /// name each custom action that you define, and then you can use it by name in your <a>StatelessRule</a>
        /// <a>RuleDefinition</a>
        /// <code>Actions</code> specification.</p>
        pub fn custom_actions(mut self, input: impl Into<crate::model::CustomAction>) -> Self {
            let mut v = self.custom_actions.unwrap_or_default();
            v.push(input.into());
            self.custom_actions = Some(v);
            self
        }
        /// <p>Defines an array of individual custom action definitions that are available for use by
        /// the stateless rules in this <code>StatelessRulesAndCustomActions</code> specification. You
        /// name each custom action that you define, and then you can use it by name in your <a>StatelessRule</a>
        /// <a>RuleDefinition</a>
        /// <code>Actions</code> specification.</p>
        pub fn set_custom_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomAction>>,
        ) -> Self {
            self.custom_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`StatelessRulesAndCustomActions`](crate::model::StatelessRulesAndCustomActions)
        pub fn build(self) -> crate::model::StatelessRulesAndCustomActions {
            crate::model::StatelessRulesAndCustomActions {
                stateless_rules: self.stateless_rules,
                custom_actions: self.custom_actions,
            }
        }
    }
}
impl StatelessRulesAndCustomActions {
    /// Creates a new builder-style object to manufacture [`StatelessRulesAndCustomActions`](crate::model::StatelessRulesAndCustomActions)
    pub fn builder() -> crate::model::stateless_rules_and_custom_actions::Builder {
        crate::model::stateless_rules_and_custom_actions::Builder::default()
    }
}

/// <p>An optional, non-standard action to use for stateless packet handling. You can define
/// this in addition to the standard action that you must specify. </p>
/// <p>You define and name the custom actions that you want to be able to use, and then you
/// reference them by name in your actions settings. </p>
/// <p>You can use custom actions in the following places: </p>
/// <ul>
/// <li>
/// <p>In a rule group's <a>StatelessRulesAndCustomActions</a> specification.
/// The custom actions are available for use by name inside the
/// <code>StatelessRulesAndCustomActions</code> where you define them. You can use
/// them for your stateless rule actions to specify what to do with a packet that matches
/// the rule's match attributes. </p>
/// </li>
/// <li>
/// <p>In a <a>FirewallPolicy</a> specification, in
/// <code>StatelessCustomActions</code>. The custom actions are available for use
/// inside the policy where you define them. You can use them for the policy's default
/// stateless actions settings to specify what to do with packets that don't match any of
/// the policy's stateless rules. </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomAction {
    /// <p>The descriptive name of the custom action. You can't change the name of a custom action after you create it.</p>
    pub action_name: std::option::Option<std::string::String>,
    /// <p>The custom action associated with the action name.</p>
    pub action_definition: std::option::Option<crate::model::ActionDefinition>,
}
impl CustomAction {
    /// <p>The descriptive name of the custom action. You can't change the name of a custom action after you create it.</p>
    pub fn action_name(&self) -> std::option::Option<&str> {
        self.action_name.as_deref()
    }
    /// <p>The custom action associated with the action name.</p>
    pub fn action_definition(&self) -> std::option::Option<&crate::model::ActionDefinition> {
        self.action_definition.as_ref()
    }
}
impl std::fmt::Debug for CustomAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomAction");
        formatter.field("action_name", &self.action_name);
        formatter.field("action_definition", &self.action_definition);
        formatter.finish()
    }
}
/// See [`CustomAction`](crate::model::CustomAction)
pub mod custom_action {
    /// A builder for [`CustomAction`](crate::model::CustomAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_name: std::option::Option<std::string::String>,
        pub(crate) action_definition: std::option::Option<crate::model::ActionDefinition>,
    }
    impl Builder {
        /// <p>The descriptive name of the custom action. You can't change the name of a custom action after you create it.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p>The descriptive name of the custom action. You can't change the name of a custom action after you create it.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// <p>The custom action associated with the action name.</p>
        pub fn action_definition(mut self, input: crate::model::ActionDefinition) -> Self {
            self.action_definition = Some(input);
            self
        }
        /// <p>The custom action associated with the action name.</p>
        pub fn set_action_definition(
            mut self,
            input: std::option::Option<crate::model::ActionDefinition>,
        ) -> Self {
            self.action_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomAction`](crate::model::CustomAction)
        pub fn build(self) -> crate::model::CustomAction {
            crate::model::CustomAction {
                action_name: self.action_name,
                action_definition: self.action_definition,
            }
        }
    }
}
impl CustomAction {
    /// Creates a new builder-style object to manufacture [`CustomAction`](crate::model::CustomAction)
    pub fn builder() -> crate::model::custom_action::Builder {
        crate::model::custom_action::Builder::default()
    }
}

/// <p>A custom action to use in stateless rule actions settings. This is used in <a>CustomAction</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionDefinition {
    /// <p>Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the
    /// matching packet. This setting defines a CloudWatch dimension value to be published.</p>
    /// <p>You can pair this custom action with any of the standard stateless rule actions. For
    /// example, you could pair this in a rule action with the standard action that forwards the
    /// packet for stateful inspection. Then, when a packet matches the rule, Network Firewall
    /// publishes metrics for the packet and forwards it. </p>
    pub publish_metric_action: std::option::Option<crate::model::PublishMetricAction>,
}
impl ActionDefinition {
    /// <p>Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the
    /// matching packet. This setting defines a CloudWatch dimension value to be published.</p>
    /// <p>You can pair this custom action with any of the standard stateless rule actions. For
    /// example, you could pair this in a rule action with the standard action that forwards the
    /// packet for stateful inspection. Then, when a packet matches the rule, Network Firewall
    /// publishes metrics for the packet and forwards it. </p>
    pub fn publish_metric_action(&self) -> std::option::Option<&crate::model::PublishMetricAction> {
        self.publish_metric_action.as_ref()
    }
}
impl std::fmt::Debug for ActionDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionDefinition");
        formatter.field("publish_metric_action", &self.publish_metric_action);
        formatter.finish()
    }
}
/// See [`ActionDefinition`](crate::model::ActionDefinition)
pub mod action_definition {
    /// A builder for [`ActionDefinition`](crate::model::ActionDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) publish_metric_action: std::option::Option<crate::model::PublishMetricAction>,
    }
    impl Builder {
        /// <p>Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the
        /// matching packet. This setting defines a CloudWatch dimension value to be published.</p>
        /// <p>You can pair this custom action with any of the standard stateless rule actions. For
        /// example, you could pair this in a rule action with the standard action that forwards the
        /// packet for stateful inspection. Then, when a packet matches the rule, Network Firewall
        /// publishes metrics for the packet and forwards it. </p>
        pub fn publish_metric_action(mut self, input: crate::model::PublishMetricAction) -> Self {
            self.publish_metric_action = Some(input);
            self
        }
        /// <p>Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the
        /// matching packet. This setting defines a CloudWatch dimension value to be published.</p>
        /// <p>You can pair this custom action with any of the standard stateless rule actions. For
        /// example, you could pair this in a rule action with the standard action that forwards the
        /// packet for stateful inspection. Then, when a packet matches the rule, Network Firewall
        /// publishes metrics for the packet and forwards it. </p>
        pub fn set_publish_metric_action(
            mut self,
            input: std::option::Option<crate::model::PublishMetricAction>,
        ) -> Self {
            self.publish_metric_action = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionDefinition`](crate::model::ActionDefinition)
        pub fn build(self) -> crate::model::ActionDefinition {
            crate::model::ActionDefinition {
                publish_metric_action: self.publish_metric_action,
            }
        }
    }
}
impl ActionDefinition {
    /// Creates a new builder-style object to manufacture [`ActionDefinition`](crate::model::ActionDefinition)
    pub fn builder() -> crate::model::action_definition::Builder {
        crate::model::action_definition::Builder::default()
    }
}

/// <p>Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the
/// matching packet. This setting defines a CloudWatch dimension value to be published.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublishMetricAction {
    /// <p></p>
    pub dimensions: std::option::Option<std::vec::Vec<crate::model::Dimension>>,
}
impl PublishMetricAction {
    /// <p></p>
    pub fn dimensions(&self) -> std::option::Option<&[crate::model::Dimension]> {
        self.dimensions.as_deref()
    }
}
impl std::fmt::Debug for PublishMetricAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublishMetricAction");
        formatter.field("dimensions", &self.dimensions);
        formatter.finish()
    }
}
/// See [`PublishMetricAction`](crate::model::PublishMetricAction)
pub mod publish_metric_action {
    /// A builder for [`PublishMetricAction`](crate::model::PublishMetricAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimensions: std::option::Option<std::vec::Vec<crate::model::Dimension>>,
    }
    impl Builder {
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p></p>
        pub fn dimensions(mut self, input: impl Into<crate::model::Dimension>) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input.into());
            self.dimensions = Some(v);
            self
        }
        /// <p></p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Dimension>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// Consumes the builder and constructs a [`PublishMetricAction`](crate::model::PublishMetricAction)
        pub fn build(self) -> crate::model::PublishMetricAction {
            crate::model::PublishMetricAction {
                dimensions: self.dimensions,
            }
        }
    }
}
impl PublishMetricAction {
    /// Creates a new builder-style object to manufacture [`PublishMetricAction`](crate::model::PublishMetricAction)
    pub fn builder() -> crate::model::publish_metric_action::Builder {
        crate::model::publish_metric_action::Builder::default()
    }
}

/// <p>The value to use in an Amazon CloudWatch custom metric dimension. This is used in the
/// <code>PublishMetrics</code>
/// <a>CustomAction</a>. A CloudWatch custom metric dimension is a name/value pair that's
/// part of the identity of a metric. </p>
/// <p>AWS Network Firewall sets the dimension name to <code>CustomAction</code> and you provide the
/// dimension value. </p>
/// <p>For more information about CloudWatch custom metric dimensions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html#usingDimensions">Publishing Custom Metrics</a> in the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch User
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Dimension {
    /// <p>The value to use in the custom metric dimension.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Dimension {
    /// <p>The value to use in the custom metric dimension.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Dimension {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Dimension");
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Dimension`](crate::model::Dimension)
pub mod dimension {
    /// A builder for [`Dimension`](crate::model::Dimension)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value to use in the custom metric dimension.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value to use in the custom metric dimension.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Dimension`](crate::model::Dimension)
        pub fn build(self) -> crate::model::Dimension {
            crate::model::Dimension { value: self.value }
        }
    }
}
impl Dimension {
    /// Creates a new builder-style object to manufacture [`Dimension`](crate::model::Dimension)
    pub fn builder() -> crate::model::dimension::Builder {
        crate::model::dimension::Builder::default()
    }
}

/// <p>A single stateless rule. This is used in <a>StatelessRulesAndCustomActions</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatelessRule {
    /// <p>Defines the stateless 5-tuple packet inspection criteria and the action to take on a
    /// packet that matches the criteria. </p>
    pub rule_definition: std::option::Option<crate::model::RuleDefinition>,
    /// <p>Indicates the order in which to run this rule relative to all of the
    /// rules that are defined for a stateless rule group. Network Firewall evaluates the rules in a
    /// rule group starting with the lowest priority setting. You must ensure that the priority
    /// settings are unique for the rule group. </p>
    /// <p>Each stateless rule group uses exactly one <code>StatelessRulesAndCustomActions</code>
    /// object, and each <code>StatelessRulesAndCustomActions</code> contains exactly one
    /// <code>StatelessRules</code> object. To ensure unique priority settings for your rule
    /// groups, set unique priorities for the stateless rules that you define inside any single
    /// <code>StatelessRules</code> object.</p>
    /// <p>You can change the priority settings of your rules at any time. To make it easier to
    /// insert rules later, number them so there's a wide range in between, for example use 100,
    /// 200, and so on. </p>
    pub priority: i32,
}
impl StatelessRule {
    /// <p>Defines the stateless 5-tuple packet inspection criteria and the action to take on a
    /// packet that matches the criteria. </p>
    pub fn rule_definition(&self) -> std::option::Option<&crate::model::RuleDefinition> {
        self.rule_definition.as_ref()
    }
    /// <p>Indicates the order in which to run this rule relative to all of the
    /// rules that are defined for a stateless rule group. Network Firewall evaluates the rules in a
    /// rule group starting with the lowest priority setting. You must ensure that the priority
    /// settings are unique for the rule group. </p>
    /// <p>Each stateless rule group uses exactly one <code>StatelessRulesAndCustomActions</code>
    /// object, and each <code>StatelessRulesAndCustomActions</code> contains exactly one
    /// <code>StatelessRules</code> object. To ensure unique priority settings for your rule
    /// groups, set unique priorities for the stateless rules that you define inside any single
    /// <code>StatelessRules</code> object.</p>
    /// <p>You can change the priority settings of your rules at any time. To make it easier to
    /// insert rules later, number them so there's a wide range in between, for example use 100,
    /// 200, and so on. </p>
    pub fn priority(&self) -> i32 {
        self.priority
    }
}
impl std::fmt::Debug for StatelessRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatelessRule");
        formatter.field("rule_definition", &self.rule_definition);
        formatter.field("priority", &self.priority);
        formatter.finish()
    }
}
/// See [`StatelessRule`](crate::model::StatelessRule)
pub mod stateless_rule {
    /// A builder for [`StatelessRule`](crate::model::StatelessRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_definition: std::option::Option<crate::model::RuleDefinition>,
        pub(crate) priority: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Defines the stateless 5-tuple packet inspection criteria and the action to take on a
        /// packet that matches the criteria. </p>
        pub fn rule_definition(mut self, input: crate::model::RuleDefinition) -> Self {
            self.rule_definition = Some(input);
            self
        }
        /// <p>Defines the stateless 5-tuple packet inspection criteria and the action to take on a
        /// packet that matches the criteria. </p>
        pub fn set_rule_definition(
            mut self,
            input: std::option::Option<crate::model::RuleDefinition>,
        ) -> Self {
            self.rule_definition = input;
            self
        }
        /// <p>Indicates the order in which to run this rule relative to all of the
        /// rules that are defined for a stateless rule group. Network Firewall evaluates the rules in a
        /// rule group starting with the lowest priority setting. You must ensure that the priority
        /// settings are unique for the rule group. </p>
        /// <p>Each stateless rule group uses exactly one <code>StatelessRulesAndCustomActions</code>
        /// object, and each <code>StatelessRulesAndCustomActions</code> contains exactly one
        /// <code>StatelessRules</code> object. To ensure unique priority settings for your rule
        /// groups, set unique priorities for the stateless rules that you define inside any single
        /// <code>StatelessRules</code> object.</p>
        /// <p>You can change the priority settings of your rules at any time. To make it easier to
        /// insert rules later, number them so there's a wide range in between, for example use 100,
        /// 200, and so on. </p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>Indicates the order in which to run this rule relative to all of the
        /// rules that are defined for a stateless rule group. Network Firewall evaluates the rules in a
        /// rule group starting with the lowest priority setting. You must ensure that the priority
        /// settings are unique for the rule group. </p>
        /// <p>Each stateless rule group uses exactly one <code>StatelessRulesAndCustomActions</code>
        /// object, and each <code>StatelessRulesAndCustomActions</code> contains exactly one
        /// <code>StatelessRules</code> object. To ensure unique priority settings for your rule
        /// groups, set unique priorities for the stateless rules that you define inside any single
        /// <code>StatelessRules</code> object.</p>
        /// <p>You can change the priority settings of your rules at any time. To make it easier to
        /// insert rules later, number them so there's a wide range in between, for example use 100,
        /// 200, and so on. </p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// Consumes the builder and constructs a [`StatelessRule`](crate::model::StatelessRule)
        pub fn build(self) -> crate::model::StatelessRule {
            crate::model::StatelessRule {
                rule_definition: self.rule_definition,
                priority: self.priority.unwrap_or_default(),
            }
        }
    }
}
impl StatelessRule {
    /// Creates a new builder-style object to manufacture [`StatelessRule`](crate::model::StatelessRule)
    pub fn builder() -> crate::model::stateless_rule::Builder {
        crate::model::stateless_rule::Builder::default()
    }
}

/// <p>The inspection criteria and action for a single stateless rule. AWS Network Firewall inspects each packet for the specified matching
/// criteria. When a packet matches the criteria, Network Firewall performs the rule's actions on
/// the packet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleDefinition {
    /// <p>Criteria for Network Firewall to use to inspect an individual packet in stateless rule inspection. Each match attributes set can include one or more items such as IP address, CIDR range, port number, protocol, and TCP flags. </p>
    pub match_attributes: std::option::Option<crate::model::MatchAttributes>,
    /// <p>The actions to take on a packet that matches one of the stateless rule definition's
    /// match attributes. You must specify a standard action and you can add custom actions. </p>
    /// <note>
    /// <p>Network Firewall only forwards a packet for stateful rule inspection if you specify
    /// <code>aws:forward_to_sfe</code> for a rule that the packet matches, or if the packet
    /// doesn't match any stateless rule and you specify <code>aws:forward_to_sfe</code> for the
    /// <code>StatelessDefaultActions</code> setting for the <a>FirewallPolicy</a>.</p>
    /// </note>
    /// <p>For every rule, you must specify exactly one of the following standard actions. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>aws:pass</b> - Discontinues all inspection of
    /// the packet and permits it to go to its intended destination.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>aws:drop</b> - Discontinues all inspection of
    /// the packet and blocks it from going to its intended destination.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>aws:forward_to_sfe</b> - Discontinues
    /// stateless inspection of the packet and forwards it to the stateful rule engine for
    /// inspection. </p>
    /// </li>
    /// </ul>
    /// <p>Additionally, you can specify a custom action.
    /// To
    /// do this, you define a custom action by name and type, then provide the name you've assigned
    /// to the action in this <code>Actions</code> setting. For information about the options, see
    /// <a>CustomAction</a>. </p>
    /// <p>To provide more than one action in this setting, separate the settings with a comma. For
    /// example, if you have a custom <code>PublishMetrics</code> action that you've named
    /// <code>MyMetricsAction</code>, then you could specify the standard action
    /// <code>aws:pass</code> and the custom action with <code>[“aws:pass”,
    /// “MyMetricsAction”]</code>. </p>
    pub actions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RuleDefinition {
    /// <p>Criteria for Network Firewall to use to inspect an individual packet in stateless rule inspection. Each match attributes set can include one or more items such as IP address, CIDR range, port number, protocol, and TCP flags. </p>
    pub fn match_attributes(&self) -> std::option::Option<&crate::model::MatchAttributes> {
        self.match_attributes.as_ref()
    }
    /// <p>The actions to take on a packet that matches one of the stateless rule definition's
    /// match attributes. You must specify a standard action and you can add custom actions. </p>
    /// <note>
    /// <p>Network Firewall only forwards a packet for stateful rule inspection if you specify
    /// <code>aws:forward_to_sfe</code> for a rule that the packet matches, or if the packet
    /// doesn't match any stateless rule and you specify <code>aws:forward_to_sfe</code> for the
    /// <code>StatelessDefaultActions</code> setting for the <a>FirewallPolicy</a>.</p>
    /// </note>
    /// <p>For every rule, you must specify exactly one of the following standard actions. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>aws:pass</b> - Discontinues all inspection of
    /// the packet and permits it to go to its intended destination.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>aws:drop</b> - Discontinues all inspection of
    /// the packet and blocks it from going to its intended destination.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>aws:forward_to_sfe</b> - Discontinues
    /// stateless inspection of the packet and forwards it to the stateful rule engine for
    /// inspection. </p>
    /// </li>
    /// </ul>
    /// <p>Additionally, you can specify a custom action.
    /// To
    /// do this, you define a custom action by name and type, then provide the name you've assigned
    /// to the action in this <code>Actions</code> setting. For information about the options, see
    /// <a>CustomAction</a>. </p>
    /// <p>To provide more than one action in this setting, separate the settings with a comma. For
    /// example, if you have a custom <code>PublishMetrics</code> action that you've named
    /// <code>MyMetricsAction</code>, then you could specify the standard action
    /// <code>aws:pass</code> and the custom action with <code>[“aws:pass”,
    /// “MyMetricsAction”]</code>. </p>
    pub fn actions(&self) -> std::option::Option<&[std::string::String]> {
        self.actions.as_deref()
    }
}
impl std::fmt::Debug for RuleDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleDefinition");
        formatter.field("match_attributes", &self.match_attributes);
        formatter.field("actions", &self.actions);
        formatter.finish()
    }
}
/// See [`RuleDefinition`](crate::model::RuleDefinition)
pub mod rule_definition {
    /// A builder for [`RuleDefinition`](crate::model::RuleDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) match_attributes: std::option::Option<crate::model::MatchAttributes>,
        pub(crate) actions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Criteria for Network Firewall to use to inspect an individual packet in stateless rule inspection. Each match attributes set can include one or more items such as IP address, CIDR range, port number, protocol, and TCP flags. </p>
        pub fn match_attributes(mut self, input: crate::model::MatchAttributes) -> Self {
            self.match_attributes = Some(input);
            self
        }
        /// <p>Criteria for Network Firewall to use to inspect an individual packet in stateless rule inspection. Each match attributes set can include one or more items such as IP address, CIDR range, port number, protocol, and TCP flags. </p>
        pub fn set_match_attributes(
            mut self,
            input: std::option::Option<crate::model::MatchAttributes>,
        ) -> Self {
            self.match_attributes = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions to take on a packet that matches one of the stateless rule definition's
        /// match attributes. You must specify a standard action and you can add custom actions. </p>
        /// <note>
        /// <p>Network Firewall only forwards a packet for stateful rule inspection if you specify
        /// <code>aws:forward_to_sfe</code> for a rule that the packet matches, or if the packet
        /// doesn't match any stateless rule and you specify <code>aws:forward_to_sfe</code> for the
        /// <code>StatelessDefaultActions</code> setting for the <a>FirewallPolicy</a>.</p>
        /// </note>
        /// <p>For every rule, you must specify exactly one of the following standard actions. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>aws:pass</b> - Discontinues all inspection of
        /// the packet and permits it to go to its intended destination.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>aws:drop</b> - Discontinues all inspection of
        /// the packet and blocks it from going to its intended destination.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>aws:forward_to_sfe</b> - Discontinues
        /// stateless inspection of the packet and forwards it to the stateful rule engine for
        /// inspection. </p>
        /// </li>
        /// </ul>
        /// <p>Additionally, you can specify a custom action.
        /// To
        /// do this, you define a custom action by name and type, then provide the name you've assigned
        /// to the action in this <code>Actions</code> setting. For information about the options, see
        /// <a>CustomAction</a>. </p>
        /// <p>To provide more than one action in this setting, separate the settings with a comma. For
        /// example, if you have a custom <code>PublishMetrics</code> action that you've named
        /// <code>MyMetricsAction</code>, then you could specify the standard action
        /// <code>aws:pass</code> and the custom action with <code>[“aws:pass”,
        /// “MyMetricsAction”]</code>. </p>
        pub fn actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>The actions to take on a packet that matches one of the stateless rule definition's
        /// match attributes. You must specify a standard action and you can add custom actions. </p>
        /// <note>
        /// <p>Network Firewall only forwards a packet for stateful rule inspection if you specify
        /// <code>aws:forward_to_sfe</code> for a rule that the packet matches, or if the packet
        /// doesn't match any stateless rule and you specify <code>aws:forward_to_sfe</code> for the
        /// <code>StatelessDefaultActions</code> setting for the <a>FirewallPolicy</a>.</p>
        /// </note>
        /// <p>For every rule, you must specify exactly one of the following standard actions. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>aws:pass</b> - Discontinues all inspection of
        /// the packet and permits it to go to its intended destination.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>aws:drop</b> - Discontinues all inspection of
        /// the packet and blocks it from going to its intended destination.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>aws:forward_to_sfe</b> - Discontinues
        /// stateless inspection of the packet and forwards it to the stateful rule engine for
        /// inspection. </p>
        /// </li>
        /// </ul>
        /// <p>Additionally, you can specify a custom action.
        /// To
        /// do this, you define a custom action by name and type, then provide the name you've assigned
        /// to the action in this <code>Actions</code> setting. For information about the options, see
        /// <a>CustomAction</a>. </p>
        /// <p>To provide more than one action in this setting, separate the settings with a comma. For
        /// example, if you have a custom <code>PublishMetrics</code> action that you've named
        /// <code>MyMetricsAction</code>, then you could specify the standard action
        /// <code>aws:pass</code> and the custom action with <code>[“aws:pass”,
        /// “MyMetricsAction”]</code>. </p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleDefinition`](crate::model::RuleDefinition)
        pub fn build(self) -> crate::model::RuleDefinition {
            crate::model::RuleDefinition {
                match_attributes: self.match_attributes,
                actions: self.actions,
            }
        }
    }
}
impl RuleDefinition {
    /// Creates a new builder-style object to manufacture [`RuleDefinition`](crate::model::RuleDefinition)
    pub fn builder() -> crate::model::rule_definition::Builder {
        crate::model::rule_definition::Builder::default()
    }
}

/// <p>Criteria for Network Firewall to use to inspect an individual packet in stateless rule inspection. Each match attributes set can include one or more items such as IP address, CIDR range, port number, protocol, and TCP flags. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MatchAttributes {
    /// <p>The source IP addresses and address ranges to inspect for, in CIDR notation. If not
    /// specified, this matches with any source address. </p>
    pub sources: std::option::Option<std::vec::Vec<crate::model::Address>>,
    /// <p>The destination IP addresses and address ranges to inspect for, in CIDR notation. If not
    /// specified, this matches with any destination address. </p>
    pub destinations: std::option::Option<std::vec::Vec<crate::model::Address>>,
    /// <p>The source ports to inspect for. If not specified, this matches with any source port.
    /// This setting is only used for protocols 6 (TCP) and 17 (UDP). </p>
    /// <p>You can specify individual ports, for example <code>1994</code> and you can specify port
    /// ranges, for example <code>1990:1994</code>. </p>
    pub source_ports: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
    /// <p>The destination ports to inspect for. If not specified, this matches with any
    /// destination port. This setting is only used for protocols 6 (TCP) and 17 (UDP). </p>
    /// <p>You can specify individual ports, for example <code>1994</code> and you can specify port
    /// ranges, for example <code>1990:1994</code>. </p>
    pub destination_ports: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
    /// <p>The protocols to inspect for, specified using each protocol's assigned internet protocol
    /// number (IANA). If not specified, this matches with any protocol. </p>
    pub protocols: std::option::Option<std::vec::Vec<i32>>,
    /// <p>The TCP flags and masks to inspect for. If not specified, this matches with any
    /// settings. This setting is only used for protocol 6 (TCP).</p>
    pub tcp_flags: std::option::Option<std::vec::Vec<crate::model::TcpFlagField>>,
}
impl MatchAttributes {
    /// <p>The source IP addresses and address ranges to inspect for, in CIDR notation. If not
    /// specified, this matches with any source address. </p>
    pub fn sources(&self) -> std::option::Option<&[crate::model::Address]> {
        self.sources.as_deref()
    }
    /// <p>The destination IP addresses and address ranges to inspect for, in CIDR notation. If not
    /// specified, this matches with any destination address. </p>
    pub fn destinations(&self) -> std::option::Option<&[crate::model::Address]> {
        self.destinations.as_deref()
    }
    /// <p>The source ports to inspect for. If not specified, this matches with any source port.
    /// This setting is only used for protocols 6 (TCP) and 17 (UDP). </p>
    /// <p>You can specify individual ports, for example <code>1994</code> and you can specify port
    /// ranges, for example <code>1990:1994</code>. </p>
    pub fn source_ports(&self) -> std::option::Option<&[crate::model::PortRange]> {
        self.source_ports.as_deref()
    }
    /// <p>The destination ports to inspect for. If not specified, this matches with any
    /// destination port. This setting is only used for protocols 6 (TCP) and 17 (UDP). </p>
    /// <p>You can specify individual ports, for example <code>1994</code> and you can specify port
    /// ranges, for example <code>1990:1994</code>. </p>
    pub fn destination_ports(&self) -> std::option::Option<&[crate::model::PortRange]> {
        self.destination_ports.as_deref()
    }
    /// <p>The protocols to inspect for, specified using each protocol's assigned internet protocol
    /// number (IANA). If not specified, this matches with any protocol. </p>
    pub fn protocols(&self) -> std::option::Option<&[i32]> {
        self.protocols.as_deref()
    }
    /// <p>The TCP flags and masks to inspect for. If not specified, this matches with any
    /// settings. This setting is only used for protocol 6 (TCP).</p>
    pub fn tcp_flags(&self) -> std::option::Option<&[crate::model::TcpFlagField]> {
        self.tcp_flags.as_deref()
    }
}
impl std::fmt::Debug for MatchAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MatchAttributes");
        formatter.field("sources", &self.sources);
        formatter.field("destinations", &self.destinations);
        formatter.field("source_ports", &self.source_ports);
        formatter.field("destination_ports", &self.destination_ports);
        formatter.field("protocols", &self.protocols);
        formatter.field("tcp_flags", &self.tcp_flags);
        formatter.finish()
    }
}
/// See [`MatchAttributes`](crate::model::MatchAttributes)
pub mod match_attributes {
    /// A builder for [`MatchAttributes`](crate::model::MatchAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::Address>>,
        pub(crate) destinations: std::option::Option<std::vec::Vec<crate::model::Address>>,
        pub(crate) source_ports: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        pub(crate) destination_ports: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        pub(crate) protocols: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) tcp_flags: std::option::Option<std::vec::Vec<crate::model::TcpFlagField>>,
    }
    impl Builder {
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The source IP addresses and address ranges to inspect for, in CIDR notation. If not
        /// specified, this matches with any source address. </p>
        pub fn sources(mut self, input: impl Into<crate::model::Address>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        /// <p>The source IP addresses and address ranges to inspect for, in CIDR notation. If not
        /// specified, this matches with any source address. </p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Address>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// <p>The destination IP addresses and address ranges to inspect for, in CIDR notation. If not
        /// specified, this matches with any destination address. </p>
        pub fn destinations(mut self, input: impl Into<crate::model::Address>) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input.into());
            self.destinations = Some(v);
            self
        }
        /// <p>The destination IP addresses and address ranges to inspect for, in CIDR notation. If not
        /// specified, this matches with any destination address. </p>
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Address>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// Appends an item to `source_ports`.
        ///
        /// To override the contents of this collection use [`set_source_ports`](Self::set_source_ports).
        ///
        /// <p>The source ports to inspect for. If not specified, this matches with any source port.
        /// This setting is only used for protocols 6 (TCP) and 17 (UDP). </p>
        /// <p>You can specify individual ports, for example <code>1994</code> and you can specify port
        /// ranges, for example <code>1990:1994</code>. </p>
        pub fn source_ports(mut self, input: impl Into<crate::model::PortRange>) -> Self {
            let mut v = self.source_ports.unwrap_or_default();
            v.push(input.into());
            self.source_ports = Some(v);
            self
        }
        /// <p>The source ports to inspect for. If not specified, this matches with any source port.
        /// This setting is only used for protocols 6 (TCP) and 17 (UDP). </p>
        /// <p>You can specify individual ports, for example <code>1994</code> and you can specify port
        /// ranges, for example <code>1990:1994</code>. </p>
        pub fn set_source_ports(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.source_ports = input;
            self
        }
        /// Appends an item to `destination_ports`.
        ///
        /// To override the contents of this collection use [`set_destination_ports`](Self::set_destination_ports).
        ///
        /// <p>The destination ports to inspect for. If not specified, this matches with any
        /// destination port. This setting is only used for protocols 6 (TCP) and 17 (UDP). </p>
        /// <p>You can specify individual ports, for example <code>1994</code> and you can specify port
        /// ranges, for example <code>1990:1994</code>. </p>
        pub fn destination_ports(mut self, input: impl Into<crate::model::PortRange>) -> Self {
            let mut v = self.destination_ports.unwrap_or_default();
            v.push(input.into());
            self.destination_ports = Some(v);
            self
        }
        /// <p>The destination ports to inspect for. If not specified, this matches with any
        /// destination port. This setting is only used for protocols 6 (TCP) and 17 (UDP). </p>
        /// <p>You can specify individual ports, for example <code>1994</code> and you can specify port
        /// ranges, for example <code>1990:1994</code>. </p>
        pub fn set_destination_ports(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.destination_ports = input;
            self
        }
        /// Appends an item to `protocols`.
        ///
        /// To override the contents of this collection use [`set_protocols`](Self::set_protocols).
        ///
        /// <p>The protocols to inspect for, specified using each protocol's assigned internet protocol
        /// number (IANA). If not specified, this matches with any protocol. </p>
        pub fn protocols(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.protocols.unwrap_or_default();
            v.push(input.into());
            self.protocols = Some(v);
            self
        }
        /// <p>The protocols to inspect for, specified using each protocol's assigned internet protocol
        /// number (IANA). If not specified, this matches with any protocol. </p>
        pub fn set_protocols(mut self, input: std::option::Option<std::vec::Vec<i32>>) -> Self {
            self.protocols = input;
            self
        }
        /// Appends an item to `tcp_flags`.
        ///
        /// To override the contents of this collection use [`set_tcp_flags`](Self::set_tcp_flags).
        ///
        /// <p>The TCP flags and masks to inspect for. If not specified, this matches with any
        /// settings. This setting is only used for protocol 6 (TCP).</p>
        pub fn tcp_flags(mut self, input: impl Into<crate::model::TcpFlagField>) -> Self {
            let mut v = self.tcp_flags.unwrap_or_default();
            v.push(input.into());
            self.tcp_flags = Some(v);
            self
        }
        /// <p>The TCP flags and masks to inspect for. If not specified, this matches with any
        /// settings. This setting is only used for protocol 6 (TCP).</p>
        pub fn set_tcp_flags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TcpFlagField>>,
        ) -> Self {
            self.tcp_flags = input;
            self
        }
        /// Consumes the builder and constructs a [`MatchAttributes`](crate::model::MatchAttributes)
        pub fn build(self) -> crate::model::MatchAttributes {
            crate::model::MatchAttributes {
                sources: self.sources,
                destinations: self.destinations,
                source_ports: self.source_ports,
                destination_ports: self.destination_ports,
                protocols: self.protocols,
                tcp_flags: self.tcp_flags,
            }
        }
    }
}
impl MatchAttributes {
    /// Creates a new builder-style object to manufacture [`MatchAttributes`](crate::model::MatchAttributes)
    pub fn builder() -> crate::model::match_attributes::Builder {
        crate::model::match_attributes::Builder::default()
    }
}

/// <p>TCP flags and masks to inspect packets for, used in stateless rules <a>MatchAttributes</a> settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TcpFlagField {
    /// <p>Used in conjunction with the <code>Masks</code> setting to define the flags that must be set and flags that must not be set in order for the packet to match. This setting can only specify values that are also specified in the <code>Masks</code> setting.</p>
    /// <p>For the flags that are specified in the masks setting, the following must be true for the packet to match: </p>
    /// <ul>
    /// <li>
    /// <p>The ones that are set in this flags setting must be set in the packet. </p>
    /// </li>
    /// <li>
    /// <p>The ones that are not set in this flags setting must also not be set in the packet. </p>
    /// </li>
    /// </ul>
    pub flags: std::option::Option<std::vec::Vec<crate::model::TcpFlag>>,
    /// <p>The set of flags to consider in the inspection. To inspect all flags in the valid values list, leave this with no setting.</p>
    pub masks: std::option::Option<std::vec::Vec<crate::model::TcpFlag>>,
}
impl TcpFlagField {
    /// <p>Used in conjunction with the <code>Masks</code> setting to define the flags that must be set and flags that must not be set in order for the packet to match. This setting can only specify values that are also specified in the <code>Masks</code> setting.</p>
    /// <p>For the flags that are specified in the masks setting, the following must be true for the packet to match: </p>
    /// <ul>
    /// <li>
    /// <p>The ones that are set in this flags setting must be set in the packet. </p>
    /// </li>
    /// <li>
    /// <p>The ones that are not set in this flags setting must also not be set in the packet. </p>
    /// </li>
    /// </ul>
    pub fn flags(&self) -> std::option::Option<&[crate::model::TcpFlag]> {
        self.flags.as_deref()
    }
    /// <p>The set of flags to consider in the inspection. To inspect all flags in the valid values list, leave this with no setting.</p>
    pub fn masks(&self) -> std::option::Option<&[crate::model::TcpFlag]> {
        self.masks.as_deref()
    }
}
impl std::fmt::Debug for TcpFlagField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TcpFlagField");
        formatter.field("flags", &self.flags);
        formatter.field("masks", &self.masks);
        formatter.finish()
    }
}
/// See [`TcpFlagField`](crate::model::TcpFlagField)
pub mod tcp_flag_field {
    /// A builder for [`TcpFlagField`](crate::model::TcpFlagField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flags: std::option::Option<std::vec::Vec<crate::model::TcpFlag>>,
        pub(crate) masks: std::option::Option<std::vec::Vec<crate::model::TcpFlag>>,
    }
    impl Builder {
        /// Appends an item to `flags`.
        ///
        /// To override the contents of this collection use [`set_flags`](Self::set_flags).
        ///
        /// <p>Used in conjunction with the <code>Masks</code> setting to define the flags that must be set and flags that must not be set in order for the packet to match. This setting can only specify values that are also specified in the <code>Masks</code> setting.</p>
        /// <p>For the flags that are specified in the masks setting, the following must be true for the packet to match: </p>
        /// <ul>
        /// <li>
        /// <p>The ones that are set in this flags setting must be set in the packet. </p>
        /// </li>
        /// <li>
        /// <p>The ones that are not set in this flags setting must also not be set in the packet. </p>
        /// </li>
        /// </ul>
        pub fn flags(mut self, input: impl Into<crate::model::TcpFlag>) -> Self {
            let mut v = self.flags.unwrap_or_default();
            v.push(input.into());
            self.flags = Some(v);
            self
        }
        /// <p>Used in conjunction with the <code>Masks</code> setting to define the flags that must be set and flags that must not be set in order for the packet to match. This setting can only specify values that are also specified in the <code>Masks</code> setting.</p>
        /// <p>For the flags that are specified in the masks setting, the following must be true for the packet to match: </p>
        /// <ul>
        /// <li>
        /// <p>The ones that are set in this flags setting must be set in the packet. </p>
        /// </li>
        /// <li>
        /// <p>The ones that are not set in this flags setting must also not be set in the packet. </p>
        /// </li>
        /// </ul>
        pub fn set_flags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TcpFlag>>,
        ) -> Self {
            self.flags = input;
            self
        }
        /// Appends an item to `masks`.
        ///
        /// To override the contents of this collection use [`set_masks`](Self::set_masks).
        ///
        /// <p>The set of flags to consider in the inspection. To inspect all flags in the valid values list, leave this with no setting.</p>
        pub fn masks(mut self, input: impl Into<crate::model::TcpFlag>) -> Self {
            let mut v = self.masks.unwrap_or_default();
            v.push(input.into());
            self.masks = Some(v);
            self
        }
        /// <p>The set of flags to consider in the inspection. To inspect all flags in the valid values list, leave this with no setting.</p>
        pub fn set_masks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TcpFlag>>,
        ) -> Self {
            self.masks = input;
            self
        }
        /// Consumes the builder and constructs a [`TcpFlagField`](crate::model::TcpFlagField)
        pub fn build(self) -> crate::model::TcpFlagField {
            crate::model::TcpFlagField {
                flags: self.flags,
                masks: self.masks,
            }
        }
    }
}
impl TcpFlagField {
    /// Creates a new builder-style object to manufacture [`TcpFlagField`](crate::model::TcpFlagField)
    pub fn builder() -> crate::model::tcp_flag_field::Builder {
        crate::model::tcp_flag_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TcpFlag {
    #[allow(missing_docs)] // documentation missing in model
    Ack,
    #[allow(missing_docs)] // documentation missing in model
    Cwr,
    #[allow(missing_docs)] // documentation missing in model
    Ece,
    #[allow(missing_docs)] // documentation missing in model
    Fin,
    #[allow(missing_docs)] // documentation missing in model
    Psh,
    #[allow(missing_docs)] // documentation missing in model
    Rst,
    #[allow(missing_docs)] // documentation missing in model
    Syn,
    #[allow(missing_docs)] // documentation missing in model
    Urg,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TcpFlag {
    fn from(s: &str) -> Self {
        match s {
            "ACK" => TcpFlag::Ack,
            "CWR" => TcpFlag::Cwr,
            "ECE" => TcpFlag::Ece,
            "FIN" => TcpFlag::Fin,
            "PSH" => TcpFlag::Psh,
            "RST" => TcpFlag::Rst,
            "SYN" => TcpFlag::Syn,
            "URG" => TcpFlag::Urg,
            other => TcpFlag::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TcpFlag {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TcpFlag::from(s))
    }
}
impl TcpFlag {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TcpFlag::Ack => "ACK",
            TcpFlag::Cwr => "CWR",
            TcpFlag::Ece => "ECE",
            TcpFlag::Fin => "FIN",
            TcpFlag::Psh => "PSH",
            TcpFlag::Rst => "RST",
            TcpFlag::Syn => "SYN",
            TcpFlag::Urg => "URG",
            TcpFlag::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACK", "CWR", "ECE", "FIN", "PSH", "RST", "SYN", "URG"]
    }
}
impl AsRef<str> for TcpFlag {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A single port range specification. This is used for source and destination port ranges
/// in the stateless rule <a>MatchAttributes</a>, <code>SourcePorts</code>, and
/// <code>DestinationPorts</code> settings. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortRange {
    /// <p>The lower limit of the port range. This must be less than or equal to the
    /// <code>ToPort</code> specification. </p>
    pub from_port: i32,
    /// <p>The upper limit of the port range. This must be greater than or equal to the
    /// <code>FromPort</code> specification. </p>
    pub to_port: i32,
}
impl PortRange {
    /// <p>The lower limit of the port range. This must be less than or equal to the
    /// <code>ToPort</code> specification. </p>
    pub fn from_port(&self) -> i32 {
        self.from_port
    }
    /// <p>The upper limit of the port range. This must be greater than or equal to the
    /// <code>FromPort</code> specification. </p>
    pub fn to_port(&self) -> i32 {
        self.to_port
    }
}
impl std::fmt::Debug for PortRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortRange");
        formatter.field("from_port", &self.from_port);
        formatter.field("to_port", &self.to_port);
        formatter.finish()
    }
}
/// See [`PortRange`](crate::model::PortRange)
pub mod port_range {
    /// A builder for [`PortRange`](crate::model::PortRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_port: std::option::Option<i32>,
        pub(crate) to_port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The lower limit of the port range. This must be less than or equal to the
        /// <code>ToPort</code> specification. </p>
        pub fn from_port(mut self, input: i32) -> Self {
            self.from_port = Some(input);
            self
        }
        /// <p>The lower limit of the port range. This must be less than or equal to the
        /// <code>ToPort</code> specification. </p>
        pub fn set_from_port(mut self, input: std::option::Option<i32>) -> Self {
            self.from_port = input;
            self
        }
        /// <p>The upper limit of the port range. This must be greater than or equal to the
        /// <code>FromPort</code> specification. </p>
        pub fn to_port(mut self, input: i32) -> Self {
            self.to_port = Some(input);
            self
        }
        /// <p>The upper limit of the port range. This must be greater than or equal to the
        /// <code>FromPort</code> specification. </p>
        pub fn set_to_port(mut self, input: std::option::Option<i32>) -> Self {
            self.to_port = input;
            self
        }
        /// Consumes the builder and constructs a [`PortRange`](crate::model::PortRange)
        pub fn build(self) -> crate::model::PortRange {
            crate::model::PortRange {
                from_port: self.from_port.unwrap_or_default(),
                to_port: self.to_port.unwrap_or_default(),
            }
        }
    }
}
impl PortRange {
    /// Creates a new builder-style object to manufacture [`PortRange`](crate::model::PortRange)
    pub fn builder() -> crate::model::port_range::Builder {
        crate::model::port_range::Builder::default()
    }
}

/// <p>A single IP address specification. This is used in the <a>MatchAttributes</a>
/// source and destination specifications.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Address {
    /// <p>Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4. </p>
    /// <p>Examples: </p>
    /// <ul>
    /// <li>
    /// <p>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p>
    /// </li>
    /// <li>
    /// <p>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless
    /// Inter-Domain Routing</a>.</p>
    pub address_definition: std::option::Option<std::string::String>,
}
impl Address {
    /// <p>Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4. </p>
    /// <p>Examples: </p>
    /// <ul>
    /// <li>
    /// <p>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p>
    /// </li>
    /// <li>
    /// <p>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless
    /// Inter-Domain Routing</a>.</p>
    pub fn address_definition(&self) -> std::option::Option<&str> {
        self.address_definition.as_deref()
    }
}
impl std::fmt::Debug for Address {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Address");
        formatter.field("address_definition", &self.address_definition);
        formatter.finish()
    }
}
/// See [`Address`](crate::model::Address)
pub mod address {
    /// A builder for [`Address`](crate::model::Address)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address_definition: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4. </p>
        /// <p>Examples: </p>
        /// <ul>
        /// <li>
        /// <p>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p>
        /// </li>
        /// <li>
        /// <p>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless
        /// Inter-Domain Routing</a>.</p>
        pub fn address_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_definition = Some(input.into());
            self
        }
        /// <p>Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4. </p>
        /// <p>Examples: </p>
        /// <ul>
        /// <li>
        /// <p>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p>
        /// </li>
        /// <li>
        /// <p>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless
        /// Inter-Domain Routing</a>.</p>
        pub fn set_address_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.address_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`Address`](crate::model::Address)
        pub fn build(self) -> crate::model::Address {
            crate::model::Address {
                address_definition: self.address_definition,
            }
        }
    }
}
impl Address {
    /// Creates a new builder-style object to manufacture [`Address`](crate::model::Address)
    pub fn builder() -> crate::model::address::Builder {
        crate::model::address::Builder::default()
    }
}

/// <p>A single Suricata rules specification, for use in a stateful rule group.  
/// Use this option to specify a simple Suricata rule with protocol, source and destination, ports, direction, and rule options.
/// For information about the Suricata <code>Rules</code> format, see
/// <a href="https://suricata.readthedocs.io/en/suricata-5.0.0/rules/intro.html#">Rules Format</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatefulRule {
    /// <p>Defines what Network Firewall should do with the packets in a traffic flow when the flow
    /// matches the stateful rule criteria. For all actions, Network Firewall performs the specified
    /// action and discontinues stateful inspection of the traffic flow. </p>
    /// <p>The actions for a stateful rule are defined as follows: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>PASS</b> - Permits the packets to go to the
    /// intended destination.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>DROP</b> - Blocks the packets from going to
    /// the intended destination and sends an alert log message, if alert logging is configured in the <a>Firewall</a>
    /// <a>LoggingConfiguration</a>. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>ALERT</b> - Permits the packets to go to the
    /// intended destination and sends an alert log message, if alert logging is configured in the <a>Firewall</a>
    /// <a>LoggingConfiguration</a>. </p>
    /// <p>You can use this action to test a rule that you intend to use to drop traffic. You
    /// can enable the rule with <code>ALERT</code> action, verify in the logs that the rule
    /// is filtering as you want, then change the action to <code>DROP</code>.</p>
    /// </li>
    /// </ul>
    pub action: std::option::Option<crate::model::StatefulAction>,
    /// <p>The stateful inspection criteria for this rule, used to inspect traffic flows.
    /// </p>
    pub header: std::option::Option<crate::model::Header>,
    /// <p>Additional options for the rule. These are the Suricata <code>RuleOptions</code> settings.</p>
    pub rule_options: std::option::Option<std::vec::Vec<crate::model::RuleOption>>,
}
impl StatefulRule {
    /// <p>Defines what Network Firewall should do with the packets in a traffic flow when the flow
    /// matches the stateful rule criteria. For all actions, Network Firewall performs the specified
    /// action and discontinues stateful inspection of the traffic flow. </p>
    /// <p>The actions for a stateful rule are defined as follows: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>PASS</b> - Permits the packets to go to the
    /// intended destination.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>DROP</b> - Blocks the packets from going to
    /// the intended destination and sends an alert log message, if alert logging is configured in the <a>Firewall</a>
    /// <a>LoggingConfiguration</a>. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>ALERT</b> - Permits the packets to go to the
    /// intended destination and sends an alert log message, if alert logging is configured in the <a>Firewall</a>
    /// <a>LoggingConfiguration</a>. </p>
    /// <p>You can use this action to test a rule that you intend to use to drop traffic. You
    /// can enable the rule with <code>ALERT</code> action, verify in the logs that the rule
    /// is filtering as you want, then change the action to <code>DROP</code>.</p>
    /// </li>
    /// </ul>
    pub fn action(&self) -> std::option::Option<&crate::model::StatefulAction> {
        self.action.as_ref()
    }
    /// <p>The stateful inspection criteria for this rule, used to inspect traffic flows.
    /// </p>
    pub fn header(&self) -> std::option::Option<&crate::model::Header> {
        self.header.as_ref()
    }
    /// <p>Additional options for the rule. These are the Suricata <code>RuleOptions</code> settings.</p>
    pub fn rule_options(&self) -> std::option::Option<&[crate::model::RuleOption]> {
        self.rule_options.as_deref()
    }
}
impl std::fmt::Debug for StatefulRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatefulRule");
        formatter.field("action", &self.action);
        formatter.field("header", &self.header);
        formatter.field("rule_options", &self.rule_options);
        formatter.finish()
    }
}
/// See [`StatefulRule`](crate::model::StatefulRule)
pub mod stateful_rule {
    /// A builder for [`StatefulRule`](crate::model::StatefulRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::StatefulAction>,
        pub(crate) header: std::option::Option<crate::model::Header>,
        pub(crate) rule_options: std::option::Option<std::vec::Vec<crate::model::RuleOption>>,
    }
    impl Builder {
        /// <p>Defines what Network Firewall should do with the packets in a traffic flow when the flow
        /// matches the stateful rule criteria. For all actions, Network Firewall performs the specified
        /// action and discontinues stateful inspection of the traffic flow. </p>
        /// <p>The actions for a stateful rule are defined as follows: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>PASS</b> - Permits the packets to go to the
        /// intended destination.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>DROP</b> - Blocks the packets from going to
        /// the intended destination and sends an alert log message, if alert logging is configured in the <a>Firewall</a>
        /// <a>LoggingConfiguration</a>. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>ALERT</b> - Permits the packets to go to the
        /// intended destination and sends an alert log message, if alert logging is configured in the <a>Firewall</a>
        /// <a>LoggingConfiguration</a>. </p>
        /// <p>You can use this action to test a rule that you intend to use to drop traffic. You
        /// can enable the rule with <code>ALERT</code> action, verify in the logs that the rule
        /// is filtering as you want, then change the action to <code>DROP</code>.</p>
        /// </li>
        /// </ul>
        pub fn action(mut self, input: crate::model::StatefulAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Defines what Network Firewall should do with the packets in a traffic flow when the flow
        /// matches the stateful rule criteria. For all actions, Network Firewall performs the specified
        /// action and discontinues stateful inspection of the traffic flow. </p>
        /// <p>The actions for a stateful rule are defined as follows: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>PASS</b> - Permits the packets to go to the
        /// intended destination.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>DROP</b> - Blocks the packets from going to
        /// the intended destination and sends an alert log message, if alert logging is configured in the <a>Firewall</a>
        /// <a>LoggingConfiguration</a>. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>ALERT</b> - Permits the packets to go to the
        /// intended destination and sends an alert log message, if alert logging is configured in the <a>Firewall</a>
        /// <a>LoggingConfiguration</a>. </p>
        /// <p>You can use this action to test a rule that you intend to use to drop traffic. You
        /// can enable the rule with <code>ALERT</code> action, verify in the logs that the rule
        /// is filtering as you want, then change the action to <code>DROP</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::StatefulAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The stateful inspection criteria for this rule, used to inspect traffic flows.
        /// </p>
        pub fn header(mut self, input: crate::model::Header) -> Self {
            self.header = Some(input);
            self
        }
        /// <p>The stateful inspection criteria for this rule, used to inspect traffic flows.
        /// </p>
        pub fn set_header(mut self, input: std::option::Option<crate::model::Header>) -> Self {
            self.header = input;
            self
        }
        /// Appends an item to `rule_options`.
        ///
        /// To override the contents of this collection use [`set_rule_options`](Self::set_rule_options).
        ///
        /// <p>Additional options for the rule. These are the Suricata <code>RuleOptions</code> settings.</p>
        pub fn rule_options(mut self, input: impl Into<crate::model::RuleOption>) -> Self {
            let mut v = self.rule_options.unwrap_or_default();
            v.push(input.into());
            self.rule_options = Some(v);
            self
        }
        /// <p>Additional options for the rule. These are the Suricata <code>RuleOptions</code> settings.</p>
        pub fn set_rule_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleOption>>,
        ) -> Self {
            self.rule_options = input;
            self
        }
        /// Consumes the builder and constructs a [`StatefulRule`](crate::model::StatefulRule)
        pub fn build(self) -> crate::model::StatefulRule {
            crate::model::StatefulRule {
                action: self.action,
                header: self.header,
                rule_options: self.rule_options,
            }
        }
    }
}
impl StatefulRule {
    /// Creates a new builder-style object to manufacture [`StatefulRule`](crate::model::StatefulRule)
    pub fn builder() -> crate::model::stateful_rule::Builder {
        crate::model::stateful_rule::Builder::default()
    }
}

/// <p>Additional settings for a stateful rule. This is part of the <a>StatefulRule</a> configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleOption {
    /// <p></p>
    pub keyword: std::option::Option<std::string::String>,
    /// <p></p>
    pub settings: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RuleOption {
    /// <p></p>
    pub fn keyword(&self) -> std::option::Option<&str> {
        self.keyword.as_deref()
    }
    /// <p></p>
    pub fn settings(&self) -> std::option::Option<&[std::string::String]> {
        self.settings.as_deref()
    }
}
impl std::fmt::Debug for RuleOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleOption");
        formatter.field("keyword", &self.keyword);
        formatter.field("settings", &self.settings);
        formatter.finish()
    }
}
/// See [`RuleOption`](crate::model::RuleOption)
pub mod rule_option {
    /// A builder for [`RuleOption`](crate::model::RuleOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keyword: std::option::Option<std::string::String>,
        pub(crate) settings: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p></p>
        pub fn keyword(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyword = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_keyword(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.keyword = input;
            self
        }
        /// Appends an item to `settings`.
        ///
        /// To override the contents of this collection use [`set_settings`](Self::set_settings).
        ///
        /// <p></p>
        pub fn settings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.settings.unwrap_or_default();
            v.push(input.into());
            self.settings = Some(v);
            self
        }
        /// <p></p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.settings = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleOption`](crate::model::RuleOption)
        pub fn build(self) -> crate::model::RuleOption {
            crate::model::RuleOption {
                keyword: self.keyword,
                settings: self.settings,
            }
        }
    }
}
impl RuleOption {
    /// Creates a new builder-style object to manufacture [`RuleOption`](crate::model::RuleOption)
    pub fn builder() -> crate::model::rule_option::Builder {
        crate::model::rule_option::Builder::default()
    }
}

/// <p>The basic rule criteria for AWS Network Firewall to use to inspect packet headers in stateful
/// traffic flow inspection. Traffic flows that match the criteria are a match for the
/// corresponding <a>StatefulRule</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Header {
    /// <p>The protocol to inspect for. To specify all, you can use <code>IP</code>, because all traffic on AWS and on the internet is IP.</p>
    pub protocol: std::option::Option<crate::model::StatefulRuleProtocol>,
    /// <p>The source IP address or address range to inspect for, in CIDR notation.
    /// To match with any address, specify <code>ANY</code>. </p>
    /// <p>Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4. </p>
    /// <p>Examples: </p>
    /// <ul>
    /// <li>
    /// <p>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p>
    /// </li>
    /// <li>
    /// <p>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless
    /// Inter-Domain Routing</a>.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>The source port to inspect for. You can specify an individual port, for
    /// example <code>1994</code> and you can specify a port
    /// range, for example <code>1990:1994</code>.
    /// To match with any port, specify <code>ANY</code>. </p>
    pub source_port: std::option::Option<std::string::String>,
    /// <p>The direction of traffic flow to inspect. If set to <code>ANY</code>, the inspection
    /// matches bidirectional traffic, both from the source to the destination and from the
    /// destination to the source. If set to <code>FORWARD</code>, the inspection only matches
    /// traffic going from the source to the destination. </p>
    pub direction: std::option::Option<crate::model::StatefulRuleDirection>,
    /// <p>The destination IP address or address range to inspect for, in CIDR notation.
    /// To match with any address, specify <code>ANY</code>. </p>
    /// <p>Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4. </p>
    /// <p>Examples: </p>
    /// <ul>
    /// <li>
    /// <p>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p>
    /// </li>
    /// <li>
    /// <p>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless
    /// Inter-Domain Routing</a>.</p>
    pub destination: std::option::Option<std::string::String>,
    /// <p>The destination port to inspect for. You can specify an individual port, for
    /// example <code>1994</code> and you can specify
    /// a port range, for example <code>1990:1994</code>.
    /// To match with any port, specify <code>ANY</code>. </p>
    pub destination_port: std::option::Option<std::string::String>,
}
impl Header {
    /// <p>The protocol to inspect for. To specify all, you can use <code>IP</code>, because all traffic on AWS and on the internet is IP.</p>
    pub fn protocol(&self) -> std::option::Option<&crate::model::StatefulRuleProtocol> {
        self.protocol.as_ref()
    }
    /// <p>The source IP address or address range to inspect for, in CIDR notation.
    /// To match with any address, specify <code>ANY</code>. </p>
    /// <p>Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4. </p>
    /// <p>Examples: </p>
    /// <ul>
    /// <li>
    /// <p>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p>
    /// </li>
    /// <li>
    /// <p>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless
    /// Inter-Domain Routing</a>.</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>The source port to inspect for. You can specify an individual port, for
    /// example <code>1994</code> and you can specify a port
    /// range, for example <code>1990:1994</code>.
    /// To match with any port, specify <code>ANY</code>. </p>
    pub fn source_port(&self) -> std::option::Option<&str> {
        self.source_port.as_deref()
    }
    /// <p>The direction of traffic flow to inspect. If set to <code>ANY</code>, the inspection
    /// matches bidirectional traffic, both from the source to the destination and from the
    /// destination to the source. If set to <code>FORWARD</code>, the inspection only matches
    /// traffic going from the source to the destination. </p>
    pub fn direction(&self) -> std::option::Option<&crate::model::StatefulRuleDirection> {
        self.direction.as_ref()
    }
    /// <p>The destination IP address or address range to inspect for, in CIDR notation.
    /// To match with any address, specify <code>ANY</code>. </p>
    /// <p>Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4. </p>
    /// <p>Examples: </p>
    /// <ul>
    /// <li>
    /// <p>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p>
    /// </li>
    /// <li>
    /// <p>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless
    /// Inter-Domain Routing</a>.</p>
    pub fn destination(&self) -> std::option::Option<&str> {
        self.destination.as_deref()
    }
    /// <p>The destination port to inspect for. You can specify an individual port, for
    /// example <code>1994</code> and you can specify
    /// a port range, for example <code>1990:1994</code>.
    /// To match with any port, specify <code>ANY</code>. </p>
    pub fn destination_port(&self) -> std::option::Option<&str> {
        self.destination_port.as_deref()
    }
}
impl std::fmt::Debug for Header {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Header");
        formatter.field("protocol", &self.protocol);
        formatter.field("source", &self.source);
        formatter.field("source_port", &self.source_port);
        formatter.field("direction", &self.direction);
        formatter.field("destination", &self.destination);
        formatter.field("destination_port", &self.destination_port);
        formatter.finish()
    }
}
/// See [`Header`](crate::model::Header)
pub mod header {
    /// A builder for [`Header`](crate::model::Header)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) protocol: std::option::Option<crate::model::StatefulRuleProtocol>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) source_port: std::option::Option<std::string::String>,
        pub(crate) direction: std::option::Option<crate::model::StatefulRuleDirection>,
        pub(crate) destination: std::option::Option<std::string::String>,
        pub(crate) destination_port: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The protocol to inspect for. To specify all, you can use <code>IP</code>, because all traffic on AWS and on the internet is IP.</p>
        pub fn protocol(mut self, input: crate::model::StatefulRuleProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol to inspect for. To specify all, you can use <code>IP</code>, because all traffic on AWS and on the internet is IP.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::StatefulRuleProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The source IP address or address range to inspect for, in CIDR notation.
        /// To match with any address, specify <code>ANY</code>. </p>
        /// <p>Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4. </p>
        /// <p>Examples: </p>
        /// <ul>
        /// <li>
        /// <p>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p>
        /// </li>
        /// <li>
        /// <p>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless
        /// Inter-Domain Routing</a>.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The source IP address or address range to inspect for, in CIDR notation.
        /// To match with any address, specify <code>ANY</code>. </p>
        /// <p>Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4. </p>
        /// <p>Examples: </p>
        /// <ul>
        /// <li>
        /// <p>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p>
        /// </li>
        /// <li>
        /// <p>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless
        /// Inter-Domain Routing</a>.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The source port to inspect for. You can specify an individual port, for
        /// example <code>1994</code> and you can specify a port
        /// range, for example <code>1990:1994</code>.
        /// To match with any port, specify <code>ANY</code>. </p>
        pub fn source_port(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_port = Some(input.into());
            self
        }
        /// <p>The source port to inspect for. You can specify an individual port, for
        /// example <code>1994</code> and you can specify a port
        /// range, for example <code>1990:1994</code>.
        /// To match with any port, specify <code>ANY</code>. </p>
        pub fn set_source_port(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_port = input;
            self
        }
        /// <p>The direction of traffic flow to inspect. If set to <code>ANY</code>, the inspection
        /// matches bidirectional traffic, both from the source to the destination and from the
        /// destination to the source. If set to <code>FORWARD</code>, the inspection only matches
        /// traffic going from the source to the destination. </p>
        pub fn direction(mut self, input: crate::model::StatefulRuleDirection) -> Self {
            self.direction = Some(input);
            self
        }
        /// <p>The direction of traffic flow to inspect. If set to <code>ANY</code>, the inspection
        /// matches bidirectional traffic, both from the source to the destination and from the
        /// destination to the source. If set to <code>FORWARD</code>, the inspection only matches
        /// traffic going from the source to the destination. </p>
        pub fn set_direction(
            mut self,
            input: std::option::Option<crate::model::StatefulRuleDirection>,
        ) -> Self {
            self.direction = input;
            self
        }
        /// <p>The destination IP address or address range to inspect for, in CIDR notation.
        /// To match with any address, specify <code>ANY</code>. </p>
        /// <p>Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4. </p>
        /// <p>Examples: </p>
        /// <ul>
        /// <li>
        /// <p>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p>
        /// </li>
        /// <li>
        /// <p>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless
        /// Inter-Domain Routing</a>.</p>
        pub fn destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination = Some(input.into());
            self
        }
        /// <p>The destination IP address or address range to inspect for, in CIDR notation.
        /// To match with any address, specify <code>ANY</code>. </p>
        /// <p>Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4. </p>
        /// <p>Examples: </p>
        /// <ul>
        /// <li>
        /// <p>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p>
        /// </li>
        /// <li>
        /// <p>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless
        /// Inter-Domain Routing</a>.</p>
        pub fn set_destination(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.destination = input;
            self
        }
        /// <p>The destination port to inspect for. You can specify an individual port, for
        /// example <code>1994</code> and you can specify
        /// a port range, for example <code>1990:1994</code>.
        /// To match with any port, specify <code>ANY</code>. </p>
        pub fn destination_port(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_port = Some(input.into());
            self
        }
        /// <p>The destination port to inspect for. You can specify an individual port, for
        /// example <code>1994</code> and you can specify
        /// a port range, for example <code>1990:1994</code>.
        /// To match with any port, specify <code>ANY</code>. </p>
        pub fn set_destination_port(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_port = input;
            self
        }
        /// Consumes the builder and constructs a [`Header`](crate::model::Header)
        pub fn build(self) -> crate::model::Header {
            crate::model::Header {
                protocol: self.protocol,
                source: self.source,
                source_port: self.source_port,
                direction: self.direction,
                destination: self.destination,
                destination_port: self.destination_port,
            }
        }
    }
}
impl Header {
    /// Creates a new builder-style object to manufacture [`Header`](crate::model::Header)
    pub fn builder() -> crate::model::header::Builder {
        crate::model::header::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StatefulRuleDirection {
    #[allow(missing_docs)] // documentation missing in model
    Any,
    #[allow(missing_docs)] // documentation missing in model
    Forward,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StatefulRuleDirection {
    fn from(s: &str) -> Self {
        match s {
            "ANY" => StatefulRuleDirection::Any,
            "FORWARD" => StatefulRuleDirection::Forward,
            other => StatefulRuleDirection::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StatefulRuleDirection {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StatefulRuleDirection::from(s))
    }
}
impl StatefulRuleDirection {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StatefulRuleDirection::Any => "ANY",
            StatefulRuleDirection::Forward => "FORWARD",
            StatefulRuleDirection::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ANY", "FORWARD"]
    }
}
impl AsRef<str> for StatefulRuleDirection {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StatefulRuleProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Dcerpc,
    #[allow(missing_docs)] // documentation missing in model
    Dhcp,
    #[allow(missing_docs)] // documentation missing in model
    Dns,
    #[allow(missing_docs)] // documentation missing in model
    Ftp,
    #[allow(missing_docs)] // documentation missing in model
    Http,
    #[allow(missing_docs)] // documentation missing in model
    Icmp,
    #[allow(missing_docs)] // documentation missing in model
    Ikev2,
    #[allow(missing_docs)] // documentation missing in model
    Imap,
    #[allow(missing_docs)] // documentation missing in model
    Any,
    #[allow(missing_docs)] // documentation missing in model
    Krb5,
    #[allow(missing_docs)] // documentation missing in model
    Msn,
    #[allow(missing_docs)] // documentation missing in model
    Ntp,
    #[allow(missing_docs)] // documentation missing in model
    Smb,
    #[allow(missing_docs)] // documentation missing in model
    Smtp,
    #[allow(missing_docs)] // documentation missing in model
    Ssh,
    #[allow(missing_docs)] // documentation missing in model
    Tcp,
    #[allow(missing_docs)] // documentation missing in model
    Tftp,
    #[allow(missing_docs)] // documentation missing in model
    Tls,
    #[allow(missing_docs)] // documentation missing in model
    Udp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StatefulRuleProtocol {
    fn from(s: &str) -> Self {
        match s {
            "DCERPC" => StatefulRuleProtocol::Dcerpc,
            "DHCP" => StatefulRuleProtocol::Dhcp,
            "DNS" => StatefulRuleProtocol::Dns,
            "FTP" => StatefulRuleProtocol::Ftp,
            "HTTP" => StatefulRuleProtocol::Http,
            "ICMP" => StatefulRuleProtocol::Icmp,
            "IKEV2" => StatefulRuleProtocol::Ikev2,
            "IMAP" => StatefulRuleProtocol::Imap,
            "IP" => StatefulRuleProtocol::Any,
            "KRB5" => StatefulRuleProtocol::Krb5,
            "MSN" => StatefulRuleProtocol::Msn,
            "NTP" => StatefulRuleProtocol::Ntp,
            "SMB" => StatefulRuleProtocol::Smb,
            "SMTP" => StatefulRuleProtocol::Smtp,
            "SSH" => StatefulRuleProtocol::Ssh,
            "TCP" => StatefulRuleProtocol::Tcp,
            "TFTP" => StatefulRuleProtocol::Tftp,
            "TLS" => StatefulRuleProtocol::Tls,
            "UDP" => StatefulRuleProtocol::Udp,
            other => StatefulRuleProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StatefulRuleProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StatefulRuleProtocol::from(s))
    }
}
impl StatefulRuleProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StatefulRuleProtocol::Dcerpc => "DCERPC",
            StatefulRuleProtocol::Dhcp => "DHCP",
            StatefulRuleProtocol::Dns => "DNS",
            StatefulRuleProtocol::Ftp => "FTP",
            StatefulRuleProtocol::Http => "HTTP",
            StatefulRuleProtocol::Icmp => "ICMP",
            StatefulRuleProtocol::Ikev2 => "IKEV2",
            StatefulRuleProtocol::Imap => "IMAP",
            StatefulRuleProtocol::Any => "IP",
            StatefulRuleProtocol::Krb5 => "KRB5",
            StatefulRuleProtocol::Msn => "MSN",
            StatefulRuleProtocol::Ntp => "NTP",
            StatefulRuleProtocol::Smb => "SMB",
            StatefulRuleProtocol::Smtp => "SMTP",
            StatefulRuleProtocol::Ssh => "SSH",
            StatefulRuleProtocol::Tcp => "TCP",
            StatefulRuleProtocol::Tftp => "TFTP",
            StatefulRuleProtocol::Tls => "TLS",
            StatefulRuleProtocol::Udp => "UDP",
            StatefulRuleProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DCERPC", "DHCP", "DNS", "FTP", "HTTP", "ICMP", "IKEV2", "IMAP", "IP", "KRB5", "MSN",
            "NTP", "SMB", "SMTP", "SSH", "TCP", "TFTP", "TLS", "UDP",
        ]
    }
}
impl AsRef<str> for StatefulRuleProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StatefulAction {
    #[allow(missing_docs)] // documentation missing in model
    Alert,
    #[allow(missing_docs)] // documentation missing in model
    Drop,
    #[allow(missing_docs)] // documentation missing in model
    Pass,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StatefulAction {
    fn from(s: &str) -> Self {
        match s {
            "ALERT" => StatefulAction::Alert,
            "DROP" => StatefulAction::Drop,
            "PASS" => StatefulAction::Pass,
            other => StatefulAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StatefulAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StatefulAction::from(s))
    }
}
impl StatefulAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StatefulAction::Alert => "ALERT",
            StatefulAction::Drop => "DROP",
            StatefulAction::Pass => "PASS",
            StatefulAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALERT", "DROP", "PASS"]
    }
}
impl AsRef<str> for StatefulAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Stateful inspection criteria for a domain list rule group. </p>
/// <p>For HTTPS traffic, domain filtering is SNI-based. It uses the server name indicator extension of the TLS handshake.</p>
/// <p>By default, Network Firewall domain list inspection only includes traffic coming from the VPC where you deploy the firewall. To inspect traffic from IP addresses outside of the deployment VPC, you set the <code>HOME_NET</code> rule variable to include the CIDR range of the deployment VPC plus the other CIDR ranges. For more information, see <a>RuleVariables</a> in this guide and <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/stateful-rule-groups-domain-names.html">Stateful domain list rule groups in AWS Network Firewall</a> in the <i>Network Firewall Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RulesSourceList {
    /// <p>The domains that you want to inspect for in your traffic flows. To provide multiple
    /// domains, separate them with commas. Valid domain specifications are the following:</p>
    /// <ul>
    /// <li>
    /// <p>Explicit names. For example, <code>abc.example.com</code> matches only the domain <code>abc.example.com</code>.</p>
    /// </li>
    /// <li>
    /// <p>Names that use a domain wildcard, which you indicate with an initial '<code>.</code>'. For example,<code>.example.com</code> matches <code>example.com</code> and matches all subdomains of <code>example.com</code>, such as <code>abc.example.com</code> and <code>www.example.com</code>. </p>
    /// </li>
    /// </ul>
    pub targets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The protocols you want to inspect. Specify <code>TLS_SNI</code> for <code>HTTPS</code>. Specify <code>HTTP_HOST</code> for <code>HTTP</code>. You can specify either or both. </p>
    pub target_types: std::option::Option<std::vec::Vec<crate::model::TargetType>>,
    /// <p>Whether you want to allow or deny access to the domains in your target list.</p>
    pub generated_rules_type: std::option::Option<crate::model::GeneratedRulesType>,
}
impl RulesSourceList {
    /// <p>The domains that you want to inspect for in your traffic flows. To provide multiple
    /// domains, separate them with commas. Valid domain specifications are the following:</p>
    /// <ul>
    /// <li>
    /// <p>Explicit names. For example, <code>abc.example.com</code> matches only the domain <code>abc.example.com</code>.</p>
    /// </li>
    /// <li>
    /// <p>Names that use a domain wildcard, which you indicate with an initial '<code>.</code>'. For example,<code>.example.com</code> matches <code>example.com</code> and matches all subdomains of <code>example.com</code>, such as <code>abc.example.com</code> and <code>www.example.com</code>. </p>
    /// </li>
    /// </ul>
    pub fn targets(&self) -> std::option::Option<&[std::string::String]> {
        self.targets.as_deref()
    }
    /// <p>The protocols you want to inspect. Specify <code>TLS_SNI</code> for <code>HTTPS</code>. Specify <code>HTTP_HOST</code> for <code>HTTP</code>. You can specify either or both. </p>
    pub fn target_types(&self) -> std::option::Option<&[crate::model::TargetType]> {
        self.target_types.as_deref()
    }
    /// <p>Whether you want to allow or deny access to the domains in your target list.</p>
    pub fn generated_rules_type(&self) -> std::option::Option<&crate::model::GeneratedRulesType> {
        self.generated_rules_type.as_ref()
    }
}
impl std::fmt::Debug for RulesSourceList {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RulesSourceList");
        formatter.field("targets", &self.targets);
        formatter.field("target_types", &self.target_types);
        formatter.field("generated_rules_type", &self.generated_rules_type);
        formatter.finish()
    }
}
/// See [`RulesSourceList`](crate::model::RulesSourceList)
pub mod rules_source_list {
    /// A builder for [`RulesSourceList`](crate::model::RulesSourceList)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) targets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) target_types: std::option::Option<std::vec::Vec<crate::model::TargetType>>,
        pub(crate) generated_rules_type: std::option::Option<crate::model::GeneratedRulesType>,
    }
    impl Builder {
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The domains that you want to inspect for in your traffic flows. To provide multiple
        /// domains, separate them with commas. Valid domain specifications are the following:</p>
        /// <ul>
        /// <li>
        /// <p>Explicit names. For example, <code>abc.example.com</code> matches only the domain <code>abc.example.com</code>.</p>
        /// </li>
        /// <li>
        /// <p>Names that use a domain wildcard, which you indicate with an initial '<code>.</code>'. For example,<code>.example.com</code> matches <code>example.com</code> and matches all subdomains of <code>example.com</code>, such as <code>abc.example.com</code> and <code>www.example.com</code>. </p>
        /// </li>
        /// </ul>
        pub fn targets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The domains that you want to inspect for in your traffic flows. To provide multiple
        /// domains, separate them with commas. Valid domain specifications are the following:</p>
        /// <ul>
        /// <li>
        /// <p>Explicit names. For example, <code>abc.example.com</code> matches only the domain <code>abc.example.com</code>.</p>
        /// </li>
        /// <li>
        /// <p>Names that use a domain wildcard, which you indicate with an initial '<code>.</code>'. For example,<code>.example.com</code> matches <code>example.com</code> and matches all subdomains of <code>example.com</code>, such as <code>abc.example.com</code> and <code>www.example.com</code>. </p>
        /// </li>
        /// </ul>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Appends an item to `target_types`.
        ///
        /// To override the contents of this collection use [`set_target_types`](Self::set_target_types).
        ///
        /// <p>The protocols you want to inspect. Specify <code>TLS_SNI</code> for <code>HTTPS</code>. Specify <code>HTTP_HOST</code> for <code>HTTP</code>. You can specify either or both. </p>
        pub fn target_types(mut self, input: impl Into<crate::model::TargetType>) -> Self {
            let mut v = self.target_types.unwrap_or_default();
            v.push(input.into());
            self.target_types = Some(v);
            self
        }
        /// <p>The protocols you want to inspect. Specify <code>TLS_SNI</code> for <code>HTTPS</code>. Specify <code>HTTP_HOST</code> for <code>HTTP</code>. You can specify either or both. </p>
        pub fn set_target_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetType>>,
        ) -> Self {
            self.target_types = input;
            self
        }
        /// <p>Whether you want to allow or deny access to the domains in your target list.</p>
        pub fn generated_rules_type(mut self, input: crate::model::GeneratedRulesType) -> Self {
            self.generated_rules_type = Some(input);
            self
        }
        /// <p>Whether you want to allow or deny access to the domains in your target list.</p>
        pub fn set_generated_rules_type(
            mut self,
            input: std::option::Option<crate::model::GeneratedRulesType>,
        ) -> Self {
            self.generated_rules_type = input;
            self
        }
        /// Consumes the builder and constructs a [`RulesSourceList`](crate::model::RulesSourceList)
        pub fn build(self) -> crate::model::RulesSourceList {
            crate::model::RulesSourceList {
                targets: self.targets,
                target_types: self.target_types,
                generated_rules_type: self.generated_rules_type,
            }
        }
    }
}
impl RulesSourceList {
    /// Creates a new builder-style object to manufacture [`RulesSourceList`](crate::model::RulesSourceList)
    pub fn builder() -> crate::model::rules_source_list::Builder {
        crate::model::rules_source_list::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GeneratedRulesType {
    #[allow(missing_docs)] // documentation missing in model
    Allowlist,
    #[allow(missing_docs)] // documentation missing in model
    Denylist,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GeneratedRulesType {
    fn from(s: &str) -> Self {
        match s {
            "ALLOWLIST" => GeneratedRulesType::Allowlist,
            "DENYLIST" => GeneratedRulesType::Denylist,
            other => GeneratedRulesType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GeneratedRulesType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GeneratedRulesType::from(s))
    }
}
impl GeneratedRulesType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GeneratedRulesType::Allowlist => "ALLOWLIST",
            GeneratedRulesType::Denylist => "DENYLIST",
            GeneratedRulesType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALLOWLIST", "DENYLIST"]
    }
}
impl AsRef<str> for GeneratedRulesType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetType {
    #[allow(missing_docs)] // documentation missing in model
    HttpHost,
    #[allow(missing_docs)] // documentation missing in model
    TlsSni,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetType {
    fn from(s: &str) -> Self {
        match s {
            "HTTP_HOST" => TargetType::HttpHost,
            "TLS_SNI" => TargetType::TlsSni,
            other => TargetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetType::from(s))
    }
}
impl TargetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetType::HttpHost => "HTTP_HOST",
            TargetType::TlsSni => "TLS_SNI",
            TargetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HTTP_HOST", "TLS_SNI"]
    }
}
impl AsRef<str> for TargetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Settings that are available for use in the rules in the <a>RuleGroup</a>
/// where this is defined. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleVariables {
    /// <p>A list of IP addresses and address ranges, in CIDR notation. </p>
    pub ip_sets:
        std::option::Option<std::collections::HashMap<std::string::String, crate::model::IpSet>>,
    /// <p>A list of port ranges. </p>
    pub port_sets:
        std::option::Option<std::collections::HashMap<std::string::String, crate::model::PortSet>>,
}
impl RuleVariables {
    /// <p>A list of IP addresses and address ranges, in CIDR notation. </p>
    pub fn ip_sets(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::IpSet>>
    {
        self.ip_sets.as_ref()
    }
    /// <p>A list of port ranges. </p>
    pub fn port_sets(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::PortSet>>
    {
        self.port_sets.as_ref()
    }
}
impl std::fmt::Debug for RuleVariables {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleVariables");
        formatter.field("ip_sets", &self.ip_sets);
        formatter.field("port_sets", &self.port_sets);
        formatter.finish()
    }
}
/// See [`RuleVariables`](crate::model::RuleVariables)
pub mod rule_variables {
    /// A builder for [`RuleVariables`](crate::model::RuleVariables)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_sets: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::IpSet>,
        >,
        pub(crate) port_sets: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::PortSet>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `ip_sets`.
        ///
        /// To override the contents of this collection use [`set_ip_sets`](Self::set_ip_sets).
        ///
        /// <p>A list of IP addresses and address ranges, in CIDR notation. </p>
        pub fn ip_sets(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::IpSet>,
        ) -> Self {
            let mut hash_map = self.ip_sets.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.ip_sets = Some(hash_map);
            self
        }
        /// <p>A list of IP addresses and address ranges, in CIDR notation. </p>
        pub fn set_ip_sets(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::IpSet>,
            >,
        ) -> Self {
            self.ip_sets = input;
            self
        }
        /// Adds a key-value pair to `port_sets`.
        ///
        /// To override the contents of this collection use [`set_port_sets`](Self::set_port_sets).
        ///
        /// <p>A list of port ranges. </p>
        pub fn port_sets(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::PortSet>,
        ) -> Self {
            let mut hash_map = self.port_sets.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.port_sets = Some(hash_map);
            self
        }
        /// <p>A list of port ranges. </p>
        pub fn set_port_sets(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::PortSet>,
            >,
        ) -> Self {
            self.port_sets = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleVariables`](crate::model::RuleVariables)
        pub fn build(self) -> crate::model::RuleVariables {
            crate::model::RuleVariables {
                ip_sets: self.ip_sets,
                port_sets: self.port_sets,
            }
        }
    }
}
impl RuleVariables {
    /// Creates a new builder-style object to manufacture [`RuleVariables`](crate::model::RuleVariables)
    pub fn builder() -> crate::model::rule_variables::Builder {
        crate::model::rule_variables::Builder::default()
    }
}

/// <p>A set of port ranges for use in the rules in a rule group. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortSet {
    /// <p>The set of port ranges.
    /// </p>
    pub definition: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl PortSet {
    /// <p>The set of port ranges.
    /// </p>
    pub fn definition(&self) -> std::option::Option<&[std::string::String]> {
        self.definition.as_deref()
    }
}
impl std::fmt::Debug for PortSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortSet");
        formatter.field("definition", &self.definition);
        formatter.finish()
    }
}
/// See [`PortSet`](crate::model::PortSet)
pub mod port_set {
    /// A builder for [`PortSet`](crate::model::PortSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) definition: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `definition`.
        ///
        /// To override the contents of this collection use [`set_definition`](Self::set_definition).
        ///
        /// <p>The set of port ranges.
        /// </p>
        pub fn definition(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.definition.unwrap_or_default();
            v.push(input.into());
            self.definition = Some(v);
            self
        }
        /// <p>The set of port ranges.
        /// </p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.definition = input;
            self
        }
        /// Consumes the builder and constructs a [`PortSet`](crate::model::PortSet)
        pub fn build(self) -> crate::model::PortSet {
            crate::model::PortSet {
                definition: self.definition,
            }
        }
    }
}
impl PortSet {
    /// Creates a new builder-style object to manufacture [`PortSet`](crate::model::PortSet)
    pub fn builder() -> crate::model::port_set::Builder {
        crate::model::port_set::Builder::default()
    }
}

/// <p>A list of IP addresses and address ranges, in CIDR notation. This is part of a <a>RuleVariables</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpSet {
    /// <p>The list of IP addresses and address ranges, in CIDR notation.
    ///
    /// </p>
    pub definition: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl IpSet {
    /// <p>The list of IP addresses and address ranges, in CIDR notation.
    ///
    /// </p>
    pub fn definition(&self) -> std::option::Option<&[std::string::String]> {
        self.definition.as_deref()
    }
}
impl std::fmt::Debug for IpSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpSet");
        formatter.field("definition", &self.definition);
        formatter.finish()
    }
}
/// See [`IpSet`](crate::model::IpSet)
pub mod ip_set {
    /// A builder for [`IpSet`](crate::model::IpSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) definition: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `definition`.
        ///
        /// To override the contents of this collection use [`set_definition`](Self::set_definition).
        ///
        /// <p>The list of IP addresses and address ranges, in CIDR notation.
        ///
        /// </p>
        pub fn definition(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.definition.unwrap_or_default();
            v.push(input.into());
            self.definition = Some(v);
            self
        }
        /// <p>The list of IP addresses and address ranges, in CIDR notation.
        ///
        /// </p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.definition = input;
            self
        }
        /// Consumes the builder and constructs a [`IpSet`](crate::model::IpSet)
        pub fn build(self) -> crate::model::IpSet {
            crate::model::IpSet {
                definition: self.definition,
            }
        }
    }
}
impl IpSet {
    /// Creates a new builder-style object to manufacture [`IpSet`](crate::model::IpSet)
    pub fn builder() -> crate::model::ip_set::Builder {
        crate::model::ip_set::Builder::default()
    }
}

/// <p>Defines how AWS Network Firewall performs logging for a <a>Firewall</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoggingConfiguration {
    /// <p>Defines the logging destinations for the logs for a firewall. Network Firewall generates
    /// logs for stateful rule groups. </p>
    pub log_destination_configs:
        std::option::Option<std::vec::Vec<crate::model::LogDestinationConfig>>,
}
impl LoggingConfiguration {
    /// <p>Defines the logging destinations for the logs for a firewall. Network Firewall generates
    /// logs for stateful rule groups. </p>
    pub fn log_destination_configs(
        &self,
    ) -> std::option::Option<&[crate::model::LogDestinationConfig]> {
        self.log_destination_configs.as_deref()
    }
}
impl std::fmt::Debug for LoggingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoggingConfiguration");
        formatter.field("log_destination_configs", &self.log_destination_configs);
        formatter.finish()
    }
}
/// See [`LoggingConfiguration`](crate::model::LoggingConfiguration)
pub mod logging_configuration {
    /// A builder for [`LoggingConfiguration`](crate::model::LoggingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_destination_configs:
            std::option::Option<std::vec::Vec<crate::model::LogDestinationConfig>>,
    }
    impl Builder {
        /// Appends an item to `log_destination_configs`.
        ///
        /// To override the contents of this collection use [`set_log_destination_configs`](Self::set_log_destination_configs).
        ///
        /// <p>Defines the logging destinations for the logs for a firewall. Network Firewall generates
        /// logs for stateful rule groups. </p>
        pub fn log_destination_configs(
            mut self,
            input: impl Into<crate::model::LogDestinationConfig>,
        ) -> Self {
            let mut v = self.log_destination_configs.unwrap_or_default();
            v.push(input.into());
            self.log_destination_configs = Some(v);
            self
        }
        /// <p>Defines the logging destinations for the logs for a firewall. Network Firewall generates
        /// logs for stateful rule groups. </p>
        pub fn set_log_destination_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LogDestinationConfig>>,
        ) -> Self {
            self.log_destination_configs = input;
            self
        }
        /// Consumes the builder and constructs a [`LoggingConfiguration`](crate::model::LoggingConfiguration)
        pub fn build(self) -> crate::model::LoggingConfiguration {
            crate::model::LoggingConfiguration {
                log_destination_configs: self.log_destination_configs,
            }
        }
    }
}
impl LoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`LoggingConfiguration`](crate::model::LoggingConfiguration)
    pub fn builder() -> crate::model::logging_configuration::Builder {
        crate::model::logging_configuration::Builder::default()
    }
}

/// <p>Defines where AWS Network Firewall sends logs for the firewall for one log type. This is used
/// in <a>LoggingConfiguration</a>. You can send each type of log to an Amazon S3 bucket, a CloudWatch log group, or a Kinesis Data Firehose delivery stream.</p>
/// <p>Network Firewall generates logs for stateful rule groups. You can save alert and flow log
/// types. The stateful rules engine records flow logs for all network traffic that it receives.
/// It records alert logs for traffic that matches stateful rules that have the rule
/// action set to <code>DROP</code> or <code>ALERT</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogDestinationConfig {
    /// <p>The type of log to send. Alert logs report traffic that matches a <a>StatefulRule</a> with an action setting that sends an alert log message. Flow logs are
    /// standard network traffic flow logs. </p>
    pub log_type: std::option::Option<crate::model::LogType>,
    /// <p>The type of storage destination to send these logs to. You can send logs to an Amazon S3 bucket,
    /// a CloudWatch log group, or a Kinesis Data Firehose delivery stream.</p>
    pub log_destination_type: std::option::Option<crate::model::LogDestinationType>,
    /// <p>The named location for the logs, provided in a key:value mapping that is specific to the
    /// chosen destination type. </p>
    /// <ul>
    /// <li>
    /// <p>For an Amazon S3 bucket, provide the name of the bucket, with key <code>bucketName</code>,
    /// and optionally provide a prefix, with key <code>prefix</code>. The following example
    /// specifies an Amazon S3 bucket named
    /// <code>DOC-EXAMPLE-BUCKET</code> and the prefix <code>alerts</code>: </p>
    /// <p>
    /// <code>"LogDestination": { "bucketName": "DOC-EXAMPLE-BUCKET", "prefix": "alerts"
    /// }</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>For a CloudWatch log group, provide the name of the CloudWatch log group, with key
    /// <code>logGroup</code>. The following example specifies a log group named
    /// <code>alert-log-group</code>: </p>
    /// <p>
    /// <code>"LogDestination": { "logGroup": "alert-log-group" }</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>For a Kinesis Data Firehose delivery stream, provide the name of the delivery stream, with key
    /// <code>deliveryStream</code>. The following example specifies a delivery stream
    /// named <code>alert-delivery-stream</code>: </p>
    /// <p>
    /// <code>"LogDestination": { "deliveryStream": "alert-delivery-stream"
    /// }</code>
    /// </p>
    /// </li>
    /// </ul>
    pub log_destination:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl LogDestinationConfig {
    /// <p>The type of log to send. Alert logs report traffic that matches a <a>StatefulRule</a> with an action setting that sends an alert log message. Flow logs are
    /// standard network traffic flow logs. </p>
    pub fn log_type(&self) -> std::option::Option<&crate::model::LogType> {
        self.log_type.as_ref()
    }
    /// <p>The type of storage destination to send these logs to. You can send logs to an Amazon S3 bucket,
    /// a CloudWatch log group, or a Kinesis Data Firehose delivery stream.</p>
    pub fn log_destination_type(&self) -> std::option::Option<&crate::model::LogDestinationType> {
        self.log_destination_type.as_ref()
    }
    /// <p>The named location for the logs, provided in a key:value mapping that is specific to the
    /// chosen destination type. </p>
    /// <ul>
    /// <li>
    /// <p>For an Amazon S3 bucket, provide the name of the bucket, with key <code>bucketName</code>,
    /// and optionally provide a prefix, with key <code>prefix</code>. The following example
    /// specifies an Amazon S3 bucket named
    /// <code>DOC-EXAMPLE-BUCKET</code> and the prefix <code>alerts</code>: </p>
    /// <p>
    /// <code>"LogDestination": { "bucketName": "DOC-EXAMPLE-BUCKET", "prefix": "alerts"
    /// }</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>For a CloudWatch log group, provide the name of the CloudWatch log group, with key
    /// <code>logGroup</code>. The following example specifies a log group named
    /// <code>alert-log-group</code>: </p>
    /// <p>
    /// <code>"LogDestination": { "logGroup": "alert-log-group" }</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>For a Kinesis Data Firehose delivery stream, provide the name of the delivery stream, with key
    /// <code>deliveryStream</code>. The following example specifies a delivery stream
    /// named <code>alert-delivery-stream</code>: </p>
    /// <p>
    /// <code>"LogDestination": { "deliveryStream": "alert-delivery-stream"
    /// }</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn log_destination(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.log_destination.as_ref()
    }
}
impl std::fmt::Debug for LogDestinationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogDestinationConfig");
        formatter.field("log_type", &self.log_type);
        formatter.field("log_destination_type", &self.log_destination_type);
        formatter.field("log_destination", &self.log_destination);
        formatter.finish()
    }
}
/// See [`LogDestinationConfig`](crate::model::LogDestinationConfig)
pub mod log_destination_config {
    /// A builder for [`LogDestinationConfig`](crate::model::LogDestinationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_type: std::option::Option<crate::model::LogType>,
        pub(crate) log_destination_type: std::option::Option<crate::model::LogDestinationType>,
        pub(crate) log_destination: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The type of log to send. Alert logs report traffic that matches a <a>StatefulRule</a> with an action setting that sends an alert log message. Flow logs are
        /// standard network traffic flow logs. </p>
        pub fn log_type(mut self, input: crate::model::LogType) -> Self {
            self.log_type = Some(input);
            self
        }
        /// <p>The type of log to send. Alert logs report traffic that matches a <a>StatefulRule</a> with an action setting that sends an alert log message. Flow logs are
        /// standard network traffic flow logs. </p>
        pub fn set_log_type(mut self, input: std::option::Option<crate::model::LogType>) -> Self {
            self.log_type = input;
            self
        }
        /// <p>The type of storage destination to send these logs to. You can send logs to an Amazon S3 bucket,
        /// a CloudWatch log group, or a Kinesis Data Firehose delivery stream.</p>
        pub fn log_destination_type(mut self, input: crate::model::LogDestinationType) -> Self {
            self.log_destination_type = Some(input);
            self
        }
        /// <p>The type of storage destination to send these logs to. You can send logs to an Amazon S3 bucket,
        /// a CloudWatch log group, or a Kinesis Data Firehose delivery stream.</p>
        pub fn set_log_destination_type(
            mut self,
            input: std::option::Option<crate::model::LogDestinationType>,
        ) -> Self {
            self.log_destination_type = input;
            self
        }
        /// Adds a key-value pair to `log_destination`.
        ///
        /// To override the contents of this collection use [`set_log_destination`](Self::set_log_destination).
        ///
        /// <p>The named location for the logs, provided in a key:value mapping that is specific to the
        /// chosen destination type. </p>
        /// <ul>
        /// <li>
        /// <p>For an Amazon S3 bucket, provide the name of the bucket, with key <code>bucketName</code>,
        /// and optionally provide a prefix, with key <code>prefix</code>. The following example
        /// specifies an Amazon S3 bucket named
        /// <code>DOC-EXAMPLE-BUCKET</code> and the prefix <code>alerts</code>: </p>
        /// <p>
        /// <code>"LogDestination": { "bucketName": "DOC-EXAMPLE-BUCKET", "prefix": "alerts"
        /// }</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For a CloudWatch log group, provide the name of the CloudWatch log group, with key
        /// <code>logGroup</code>. The following example specifies a log group named
        /// <code>alert-log-group</code>: </p>
        /// <p>
        /// <code>"LogDestination": { "logGroup": "alert-log-group" }</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For a Kinesis Data Firehose delivery stream, provide the name of the delivery stream, with key
        /// <code>deliveryStream</code>. The following example specifies a delivery stream
        /// named <code>alert-delivery-stream</code>: </p>
        /// <p>
        /// <code>"LogDestination": { "deliveryStream": "alert-delivery-stream"
        /// }</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn log_destination(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.log_destination.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.log_destination = Some(hash_map);
            self
        }
        /// <p>The named location for the logs, provided in a key:value mapping that is specific to the
        /// chosen destination type. </p>
        /// <ul>
        /// <li>
        /// <p>For an Amazon S3 bucket, provide the name of the bucket, with key <code>bucketName</code>,
        /// and optionally provide a prefix, with key <code>prefix</code>. The following example
        /// specifies an Amazon S3 bucket named
        /// <code>DOC-EXAMPLE-BUCKET</code> and the prefix <code>alerts</code>: </p>
        /// <p>
        /// <code>"LogDestination": { "bucketName": "DOC-EXAMPLE-BUCKET", "prefix": "alerts"
        /// }</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For a CloudWatch log group, provide the name of the CloudWatch log group, with key
        /// <code>logGroup</code>. The following example specifies a log group named
        /// <code>alert-log-group</code>: </p>
        /// <p>
        /// <code>"LogDestination": { "logGroup": "alert-log-group" }</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For a Kinesis Data Firehose delivery stream, provide the name of the delivery stream, with key
        /// <code>deliveryStream</code>. The following example specifies a delivery stream
        /// named <code>alert-delivery-stream</code>: </p>
        /// <p>
        /// <code>"LogDestination": { "deliveryStream": "alert-delivery-stream"
        /// }</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_log_destination(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.log_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`LogDestinationConfig`](crate::model::LogDestinationConfig)
        pub fn build(self) -> crate::model::LogDestinationConfig {
            crate::model::LogDestinationConfig {
                log_type: self.log_type,
                log_destination_type: self.log_destination_type,
                log_destination: self.log_destination,
            }
        }
    }
}
impl LogDestinationConfig {
    /// Creates a new builder-style object to manufacture [`LogDestinationConfig`](crate::model::LogDestinationConfig)
    pub fn builder() -> crate::model::log_destination_config::Builder {
        crate::model::log_destination_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogDestinationType {
    #[allow(missing_docs)] // documentation missing in model
    CloudwatchLogs,
    #[allow(missing_docs)] // documentation missing in model
    KinesisDataFirehose,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogDestinationType {
    fn from(s: &str) -> Self {
        match s {
            "CloudWatchLogs" => LogDestinationType::CloudwatchLogs,
            "KinesisDataFirehose" => LogDestinationType::KinesisDataFirehose,
            "S3" => LogDestinationType::S3,
            other => LogDestinationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogDestinationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogDestinationType::from(s))
    }
}
impl LogDestinationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogDestinationType::CloudwatchLogs => "CloudWatchLogs",
            LogDestinationType::KinesisDataFirehose => "KinesisDataFirehose",
            LogDestinationType::S3 => "S3",
            LogDestinationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CloudWatchLogs", "KinesisDataFirehose", "S3"]
    }
}
impl AsRef<str> for LogDestinationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogType {
    #[allow(missing_docs)] // documentation missing in model
    Alert,
    #[allow(missing_docs)] // documentation missing in model
    Flow,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogType {
    fn from(s: &str) -> Self {
        match s {
            "ALERT" => LogType::Alert,
            "FLOW" => LogType::Flow,
            other => LogType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogType::from(s))
    }
}
impl LogType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogType::Alert => "ALERT",
            LogType::Flow => "FLOW",
            LogType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALERT", "FLOW"]
    }
}
impl AsRef<str> for LogType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FirewallPolicyResponse {
    /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
    pub firewall_policy_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
    /// <note>
    /// <p>If this response is for a create request that had <code>DryRun</code> set to
    /// <code>TRUE</code>, then this ARN is a placeholder that isn't attached to a valid
    /// resource.</p>
    /// </note>
    pub firewall_policy_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the firewall policy. </p>
    pub firewall_policy_id: std::option::Option<std::string::String>,
    /// <p>A description of the firewall policy.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The current status of the firewall policy. You can retrieve this for a firewall policy
    /// by calling <a>DescribeFirewallPolicy</a> and providing the firewall policy's
    /// name or ARN.</p>
    pub firewall_policy_status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>The key:value pairs to associate with the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The number of capacity units currently consumed by the policy's stateless rules.</p>
    pub consumed_stateless_rule_capacity: std::option::Option<i32>,
    /// <p>The number of capacity units currently consumed by the policy's stateful rules.</p>
    pub consumed_stateful_rule_capacity: std::option::Option<i32>,
    /// <p>The number of firewalls that are associated with this firewall policy.</p>
    pub number_of_associations: std::option::Option<i32>,
}
impl FirewallPolicyResponse {
    /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
    pub fn firewall_policy_name(&self) -> std::option::Option<&str> {
        self.firewall_policy_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
    /// <note>
    /// <p>If this response is for a create request that had <code>DryRun</code> set to
    /// <code>TRUE</code>, then this ARN is a placeholder that isn't attached to a valid
    /// resource.</p>
    /// </note>
    pub fn firewall_policy_arn(&self) -> std::option::Option<&str> {
        self.firewall_policy_arn.as_deref()
    }
    /// <p>The unique identifier for the firewall policy. </p>
    pub fn firewall_policy_id(&self) -> std::option::Option<&str> {
        self.firewall_policy_id.as_deref()
    }
    /// <p>A description of the firewall policy.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The current status of the firewall policy. You can retrieve this for a firewall policy
    /// by calling <a>DescribeFirewallPolicy</a> and providing the firewall policy's
    /// name or ARN.</p>
    pub fn firewall_policy_status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.firewall_policy_status.as_ref()
    }
    /// <p>The key:value pairs to associate with the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The number of capacity units currently consumed by the policy's stateless rules.</p>
    pub fn consumed_stateless_rule_capacity(&self) -> std::option::Option<i32> {
        self.consumed_stateless_rule_capacity
    }
    /// <p>The number of capacity units currently consumed by the policy's stateful rules.</p>
    pub fn consumed_stateful_rule_capacity(&self) -> std::option::Option<i32> {
        self.consumed_stateful_rule_capacity
    }
    /// <p>The number of firewalls that are associated with this firewall policy.</p>
    pub fn number_of_associations(&self) -> std::option::Option<i32> {
        self.number_of_associations
    }
}
impl std::fmt::Debug for FirewallPolicyResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FirewallPolicyResponse");
        formatter.field("firewall_policy_name", &self.firewall_policy_name);
        formatter.field("firewall_policy_arn", &self.firewall_policy_arn);
        formatter.field("firewall_policy_id", &self.firewall_policy_id);
        formatter.field("description", &self.description);
        formatter.field("firewall_policy_status", &self.firewall_policy_status);
        formatter.field("tags", &self.tags);
        formatter.field(
            "consumed_stateless_rule_capacity",
            &self.consumed_stateless_rule_capacity,
        );
        formatter.field(
            "consumed_stateful_rule_capacity",
            &self.consumed_stateful_rule_capacity,
        );
        formatter.field("number_of_associations", &self.number_of_associations);
        formatter.finish()
    }
}
/// See [`FirewallPolicyResponse`](crate::model::FirewallPolicyResponse)
pub mod firewall_policy_response {
    /// A builder for [`FirewallPolicyResponse`](crate::model::FirewallPolicyResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_policy_name: std::option::Option<std::string::String>,
        pub(crate) firewall_policy_arn: std::option::Option<std::string::String>,
        pub(crate) firewall_policy_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) firewall_policy_status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) consumed_stateless_rule_capacity: std::option::Option<i32>,
        pub(crate) consumed_stateful_rule_capacity: std::option::Option<i32>,
        pub(crate) number_of_associations: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        pub fn firewall_policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_policy_name = Some(input.into());
            self
        }
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        pub fn set_firewall_policy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_policy_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        /// <note>
        /// <p>If this response is for a create request that had <code>DryRun</code> set to
        /// <code>TRUE</code>, then this ARN is a placeholder that isn't attached to a valid
        /// resource.</p>
        /// </note>
        pub fn firewall_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        /// <note>
        /// <p>If this response is for a create request that had <code>DryRun</code> set to
        /// <code>TRUE</code>, then this ARN is a placeholder that isn't attached to a valid
        /// resource.</p>
        /// </note>
        pub fn set_firewall_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_policy_arn = input;
            self
        }
        /// <p>The unique identifier for the firewall policy. </p>
        pub fn firewall_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_policy_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the firewall policy. </p>
        pub fn set_firewall_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_policy_id = input;
            self
        }
        /// <p>A description of the firewall policy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the firewall policy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The current status of the firewall policy. You can retrieve this for a firewall policy
        /// by calling <a>DescribeFirewallPolicy</a> and providing the firewall policy's
        /// name or ARN.</p>
        pub fn firewall_policy_status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.firewall_policy_status = Some(input);
            self
        }
        /// <p>The current status of the firewall policy. You can retrieve this for a firewall policy
        /// by calling <a>DescribeFirewallPolicy</a> and providing the firewall policy's
        /// name or ARN.</p>
        pub fn set_firewall_policy_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.firewall_policy_status = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key:value pairs to associate with the resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The key:value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The number of capacity units currently consumed by the policy's stateless rules.</p>
        pub fn consumed_stateless_rule_capacity(mut self, input: i32) -> Self {
            self.consumed_stateless_rule_capacity = Some(input);
            self
        }
        /// <p>The number of capacity units currently consumed by the policy's stateless rules.</p>
        pub fn set_consumed_stateless_rule_capacity(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.consumed_stateless_rule_capacity = input;
            self
        }
        /// <p>The number of capacity units currently consumed by the policy's stateful rules.</p>
        pub fn consumed_stateful_rule_capacity(mut self, input: i32) -> Self {
            self.consumed_stateful_rule_capacity = Some(input);
            self
        }
        /// <p>The number of capacity units currently consumed by the policy's stateful rules.</p>
        pub fn set_consumed_stateful_rule_capacity(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.consumed_stateful_rule_capacity = input;
            self
        }
        /// <p>The number of firewalls that are associated with this firewall policy.</p>
        pub fn number_of_associations(mut self, input: i32) -> Self {
            self.number_of_associations = Some(input);
            self
        }
        /// <p>The number of firewalls that are associated with this firewall policy.</p>
        pub fn set_number_of_associations(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_associations = input;
            self
        }
        /// Consumes the builder and constructs a [`FirewallPolicyResponse`](crate::model::FirewallPolicyResponse)
        pub fn build(self) -> crate::model::FirewallPolicyResponse {
            crate::model::FirewallPolicyResponse {
                firewall_policy_name: self.firewall_policy_name,
                firewall_policy_arn: self.firewall_policy_arn,
                firewall_policy_id: self.firewall_policy_id,
                description: self.description,
                firewall_policy_status: self.firewall_policy_status,
                tags: self.tags,
                consumed_stateless_rule_capacity: self.consumed_stateless_rule_capacity,
                consumed_stateful_rule_capacity: self.consumed_stateful_rule_capacity,
                number_of_associations: self.number_of_associations,
            }
        }
    }
}
impl FirewallPolicyResponse {
    /// Creates a new builder-style object to manufacture [`FirewallPolicyResponse`](crate::model::FirewallPolicyResponse)
    pub fn builder() -> crate::model::firewall_policy_response::Builder {
        crate::model::firewall_policy_response::Builder::default()
    }
}

/// <p>The firewall policy defines the behavior of a firewall using a collection of stateless
/// and stateful rule groups and other settings. You can use one firewall policy for multiple
/// firewalls. </p>
/// <p>This, along with <a>FirewallPolicyResponse</a>, define the policy.
/// You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FirewallPolicy {
    /// <p>References to the stateless rule groups that are used in the policy. These define the
    /// matching criteria in stateless rules. </p>
    pub stateless_rule_group_references:
        std::option::Option<std::vec::Vec<crate::model::StatelessRuleGroupReference>>,
    /// <p>The actions to take on a packet if it doesn't match any of the stateless rules in the
    /// policy. If you want non-matching packets to be forwarded for stateful inspection, specify
    /// <code>aws:forward_to_sfe</code>. </p>
    /// <p>You must specify one of the standard actions: <code>aws:pass</code>,
    /// <code>aws:drop</code>, or <code>aws:forward_to_sfe</code>. In addition, you can specify
    /// custom actions that are compatible with your standard section choice.</p>
    /// <p>For example, you could specify <code>["aws:pass"]</code> or you could specify
    /// <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see
    /// the custom action descriptions under <a>CustomAction</a>.</p>
    pub stateless_default_actions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The actions to take on a fragmented UDP packet if it doesn't match any of the stateless
    /// rules in the policy. Network Firewall only manages UDP packet fragments and silently drops packet fragments for other protocols.
    /// If you want non-matching fragmented UDP packets to be forwarded for
    /// stateful inspection, specify <code>aws:forward_to_sfe</code>. </p>
    /// <p>You must specify one of the standard actions: <code>aws:pass</code>,
    /// <code>aws:drop</code>, or <code>aws:forward_to_sfe</code>. In addition, you can specify
    /// custom actions that are compatible with your standard section choice.</p>
    /// <p>For example, you could specify <code>["aws:pass"]</code> or you could specify
    /// <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see
    /// the custom action descriptions under <a>CustomAction</a>.</p>
    pub stateless_fragment_default_actions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The custom action definitions that are available for use in the firewall policy's
    /// <code>StatelessDefaultActions</code> setting. You name each custom action that you
    /// define, and then you can use it by name in your default actions specifications.</p>
    pub stateless_custom_actions: std::option::Option<std::vec::Vec<crate::model::CustomAction>>,
    /// <p>References to the stateful rule groups that are used in the policy. These define the
    /// inspection criteria in stateful rules. </p>
    pub stateful_rule_group_references:
        std::option::Option<std::vec::Vec<crate::model::StatefulRuleGroupReference>>,
    /// <p>The default actions to take on a packet that doesn't match any stateful rules.</p>
    pub stateful_default_actions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Additional options governing how Network Firewall handles stateful rules. The stateful
    /// rule groups that you use in your policy must have stateful rule options settings that are compatible with these settings.</p>
    pub stateful_engine_options: std::option::Option<crate::model::StatefulEngineOptions>,
}
impl FirewallPolicy {
    /// <p>References to the stateless rule groups that are used in the policy. These define the
    /// matching criteria in stateless rules. </p>
    pub fn stateless_rule_group_references(
        &self,
    ) -> std::option::Option<&[crate::model::StatelessRuleGroupReference]> {
        self.stateless_rule_group_references.as_deref()
    }
    /// <p>The actions to take on a packet if it doesn't match any of the stateless rules in the
    /// policy. If you want non-matching packets to be forwarded for stateful inspection, specify
    /// <code>aws:forward_to_sfe</code>. </p>
    /// <p>You must specify one of the standard actions: <code>aws:pass</code>,
    /// <code>aws:drop</code>, or <code>aws:forward_to_sfe</code>. In addition, you can specify
    /// custom actions that are compatible with your standard section choice.</p>
    /// <p>For example, you could specify <code>["aws:pass"]</code> or you could specify
    /// <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see
    /// the custom action descriptions under <a>CustomAction</a>.</p>
    pub fn stateless_default_actions(&self) -> std::option::Option<&[std::string::String]> {
        self.stateless_default_actions.as_deref()
    }
    /// <p>The actions to take on a fragmented UDP packet if it doesn't match any of the stateless
    /// rules in the policy. Network Firewall only manages UDP packet fragments and silently drops packet fragments for other protocols.
    /// If you want non-matching fragmented UDP packets to be forwarded for
    /// stateful inspection, specify <code>aws:forward_to_sfe</code>. </p>
    /// <p>You must specify one of the standard actions: <code>aws:pass</code>,
    /// <code>aws:drop</code>, or <code>aws:forward_to_sfe</code>. In addition, you can specify
    /// custom actions that are compatible with your standard section choice.</p>
    /// <p>For example, you could specify <code>["aws:pass"]</code> or you could specify
    /// <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see
    /// the custom action descriptions under <a>CustomAction</a>.</p>
    pub fn stateless_fragment_default_actions(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.stateless_fragment_default_actions.as_deref()
    }
    /// <p>The custom action definitions that are available for use in the firewall policy's
    /// <code>StatelessDefaultActions</code> setting. You name each custom action that you
    /// define, and then you can use it by name in your default actions specifications.</p>
    pub fn stateless_custom_actions(&self) -> std::option::Option<&[crate::model::CustomAction]> {
        self.stateless_custom_actions.as_deref()
    }
    /// <p>References to the stateful rule groups that are used in the policy. These define the
    /// inspection criteria in stateful rules. </p>
    pub fn stateful_rule_group_references(
        &self,
    ) -> std::option::Option<&[crate::model::StatefulRuleGroupReference]> {
        self.stateful_rule_group_references.as_deref()
    }
    /// <p>The default actions to take on a packet that doesn't match any stateful rules.</p>
    pub fn stateful_default_actions(&self) -> std::option::Option<&[std::string::String]> {
        self.stateful_default_actions.as_deref()
    }
    /// <p>Additional options governing how Network Firewall handles stateful rules. The stateful
    /// rule groups that you use in your policy must have stateful rule options settings that are compatible with these settings.</p>
    pub fn stateful_engine_options(
        &self,
    ) -> std::option::Option<&crate::model::StatefulEngineOptions> {
        self.stateful_engine_options.as_ref()
    }
}
impl std::fmt::Debug for FirewallPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FirewallPolicy");
        formatter.field(
            "stateless_rule_group_references",
            &self.stateless_rule_group_references,
        );
        formatter.field("stateless_default_actions", &self.stateless_default_actions);
        formatter.field(
            "stateless_fragment_default_actions",
            &self.stateless_fragment_default_actions,
        );
        formatter.field("stateless_custom_actions", &self.stateless_custom_actions);
        formatter.field(
            "stateful_rule_group_references",
            &self.stateful_rule_group_references,
        );
        formatter.field("stateful_default_actions", &self.stateful_default_actions);
        formatter.field("stateful_engine_options", &self.stateful_engine_options);
        formatter.finish()
    }
}
/// See [`FirewallPolicy`](crate::model::FirewallPolicy)
pub mod firewall_policy {
    /// A builder for [`FirewallPolicy`](crate::model::FirewallPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stateless_rule_group_references:
            std::option::Option<std::vec::Vec<crate::model::StatelessRuleGroupReference>>,
        pub(crate) stateless_default_actions:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) stateless_fragment_default_actions:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) stateless_custom_actions:
            std::option::Option<std::vec::Vec<crate::model::CustomAction>>,
        pub(crate) stateful_rule_group_references:
            std::option::Option<std::vec::Vec<crate::model::StatefulRuleGroupReference>>,
        pub(crate) stateful_default_actions:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) stateful_engine_options:
            std::option::Option<crate::model::StatefulEngineOptions>,
    }
    impl Builder {
        /// Appends an item to `stateless_rule_group_references`.
        ///
        /// To override the contents of this collection use [`set_stateless_rule_group_references`](Self::set_stateless_rule_group_references).
        ///
        /// <p>References to the stateless rule groups that are used in the policy. These define the
        /// matching criteria in stateless rules. </p>
        pub fn stateless_rule_group_references(
            mut self,
            input: impl Into<crate::model::StatelessRuleGroupReference>,
        ) -> Self {
            let mut v = self.stateless_rule_group_references.unwrap_or_default();
            v.push(input.into());
            self.stateless_rule_group_references = Some(v);
            self
        }
        /// <p>References to the stateless rule groups that are used in the policy. These define the
        /// matching criteria in stateless rules. </p>
        pub fn set_stateless_rule_group_references(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StatelessRuleGroupReference>>,
        ) -> Self {
            self.stateless_rule_group_references = input;
            self
        }
        /// Appends an item to `stateless_default_actions`.
        ///
        /// To override the contents of this collection use [`set_stateless_default_actions`](Self::set_stateless_default_actions).
        ///
        /// <p>The actions to take on a packet if it doesn't match any of the stateless rules in the
        /// policy. If you want non-matching packets to be forwarded for stateful inspection, specify
        /// <code>aws:forward_to_sfe</code>. </p>
        /// <p>You must specify one of the standard actions: <code>aws:pass</code>,
        /// <code>aws:drop</code>, or <code>aws:forward_to_sfe</code>. In addition, you can specify
        /// custom actions that are compatible with your standard section choice.</p>
        /// <p>For example, you could specify <code>["aws:pass"]</code> or you could specify
        /// <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see
        /// the custom action descriptions under <a>CustomAction</a>.</p>
        pub fn stateless_default_actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stateless_default_actions.unwrap_or_default();
            v.push(input.into());
            self.stateless_default_actions = Some(v);
            self
        }
        /// <p>The actions to take on a packet if it doesn't match any of the stateless rules in the
        /// policy. If you want non-matching packets to be forwarded for stateful inspection, specify
        /// <code>aws:forward_to_sfe</code>. </p>
        /// <p>You must specify one of the standard actions: <code>aws:pass</code>,
        /// <code>aws:drop</code>, or <code>aws:forward_to_sfe</code>. In addition, you can specify
        /// custom actions that are compatible with your standard section choice.</p>
        /// <p>For example, you could specify <code>["aws:pass"]</code> or you could specify
        /// <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see
        /// the custom action descriptions under <a>CustomAction</a>.</p>
        pub fn set_stateless_default_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stateless_default_actions = input;
            self
        }
        /// Appends an item to `stateless_fragment_default_actions`.
        ///
        /// To override the contents of this collection use [`set_stateless_fragment_default_actions`](Self::set_stateless_fragment_default_actions).
        ///
        /// <p>The actions to take on a fragmented UDP packet if it doesn't match any of the stateless
        /// rules in the policy. Network Firewall only manages UDP packet fragments and silently drops packet fragments for other protocols.
        /// If you want non-matching fragmented UDP packets to be forwarded for
        /// stateful inspection, specify <code>aws:forward_to_sfe</code>. </p>
        /// <p>You must specify one of the standard actions: <code>aws:pass</code>,
        /// <code>aws:drop</code>, or <code>aws:forward_to_sfe</code>. In addition, you can specify
        /// custom actions that are compatible with your standard section choice.</p>
        /// <p>For example, you could specify <code>["aws:pass"]</code> or you could specify
        /// <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see
        /// the custom action descriptions under <a>CustomAction</a>.</p>
        pub fn stateless_fragment_default_actions(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.stateless_fragment_default_actions.unwrap_or_default();
            v.push(input.into());
            self.stateless_fragment_default_actions = Some(v);
            self
        }
        /// <p>The actions to take on a fragmented UDP packet if it doesn't match any of the stateless
        /// rules in the policy. Network Firewall only manages UDP packet fragments and silently drops packet fragments for other protocols.
        /// If you want non-matching fragmented UDP packets to be forwarded for
        /// stateful inspection, specify <code>aws:forward_to_sfe</code>. </p>
        /// <p>You must specify one of the standard actions: <code>aws:pass</code>,
        /// <code>aws:drop</code>, or <code>aws:forward_to_sfe</code>. In addition, you can specify
        /// custom actions that are compatible with your standard section choice.</p>
        /// <p>For example, you could specify <code>["aws:pass"]</code> or you could specify
        /// <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see
        /// the custom action descriptions under <a>CustomAction</a>.</p>
        pub fn set_stateless_fragment_default_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stateless_fragment_default_actions = input;
            self
        }
        /// Appends an item to `stateless_custom_actions`.
        ///
        /// To override the contents of this collection use [`set_stateless_custom_actions`](Self::set_stateless_custom_actions).
        ///
        /// <p>The custom action definitions that are available for use in the firewall policy's
        /// <code>StatelessDefaultActions</code> setting. You name each custom action that you
        /// define, and then you can use it by name in your default actions specifications.</p>
        pub fn stateless_custom_actions(
            mut self,
            input: impl Into<crate::model::CustomAction>,
        ) -> Self {
            let mut v = self.stateless_custom_actions.unwrap_or_default();
            v.push(input.into());
            self.stateless_custom_actions = Some(v);
            self
        }
        /// <p>The custom action definitions that are available for use in the firewall policy's
        /// <code>StatelessDefaultActions</code> setting. You name each custom action that you
        /// define, and then you can use it by name in your default actions specifications.</p>
        pub fn set_stateless_custom_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomAction>>,
        ) -> Self {
            self.stateless_custom_actions = input;
            self
        }
        /// Appends an item to `stateful_rule_group_references`.
        ///
        /// To override the contents of this collection use [`set_stateful_rule_group_references`](Self::set_stateful_rule_group_references).
        ///
        /// <p>References to the stateful rule groups that are used in the policy. These define the
        /// inspection criteria in stateful rules. </p>
        pub fn stateful_rule_group_references(
            mut self,
            input: impl Into<crate::model::StatefulRuleGroupReference>,
        ) -> Self {
            let mut v = self.stateful_rule_group_references.unwrap_or_default();
            v.push(input.into());
            self.stateful_rule_group_references = Some(v);
            self
        }
        /// <p>References to the stateful rule groups that are used in the policy. These define the
        /// inspection criteria in stateful rules. </p>
        pub fn set_stateful_rule_group_references(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StatefulRuleGroupReference>>,
        ) -> Self {
            self.stateful_rule_group_references = input;
            self
        }
        /// Appends an item to `stateful_default_actions`.
        ///
        /// To override the contents of this collection use [`set_stateful_default_actions`](Self::set_stateful_default_actions).
        ///
        /// <p>The default actions to take on a packet that doesn't match any stateful rules.</p>
        pub fn stateful_default_actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stateful_default_actions.unwrap_or_default();
            v.push(input.into());
            self.stateful_default_actions = Some(v);
            self
        }
        /// <p>The default actions to take on a packet that doesn't match any stateful rules.</p>
        pub fn set_stateful_default_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stateful_default_actions = input;
            self
        }
        /// <p>Additional options governing how Network Firewall handles stateful rules. The stateful
        /// rule groups that you use in your policy must have stateful rule options settings that are compatible with these settings.</p>
        pub fn stateful_engine_options(
            mut self,
            input: crate::model::StatefulEngineOptions,
        ) -> Self {
            self.stateful_engine_options = Some(input);
            self
        }
        /// <p>Additional options governing how Network Firewall handles stateful rules. The stateful
        /// rule groups that you use in your policy must have stateful rule options settings that are compatible with these settings.</p>
        pub fn set_stateful_engine_options(
            mut self,
            input: std::option::Option<crate::model::StatefulEngineOptions>,
        ) -> Self {
            self.stateful_engine_options = input;
            self
        }
        /// Consumes the builder and constructs a [`FirewallPolicy`](crate::model::FirewallPolicy)
        pub fn build(self) -> crate::model::FirewallPolicy {
            crate::model::FirewallPolicy {
                stateless_rule_group_references: self.stateless_rule_group_references,
                stateless_default_actions: self.stateless_default_actions,
                stateless_fragment_default_actions: self.stateless_fragment_default_actions,
                stateless_custom_actions: self.stateless_custom_actions,
                stateful_rule_group_references: self.stateful_rule_group_references,
                stateful_default_actions: self.stateful_default_actions,
                stateful_engine_options: self.stateful_engine_options,
            }
        }
    }
}
impl FirewallPolicy {
    /// Creates a new builder-style object to manufacture [`FirewallPolicy`](crate::model::FirewallPolicy)
    pub fn builder() -> crate::model::firewall_policy::Builder {
        crate::model::firewall_policy::Builder::default()
    }
}

/// <p>Configuration settings for the handling of the stateful rule groups in a firewall policy. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatefulEngineOptions {
    /// <p>Indicates how to manage the order of stateful rule evaluation for the policy. By default, Network Firewall
    /// leaves the rule evaluation order up to the Suricata rule processing engine. If you set
    /// this to <code>STRICT_ORDER</code>, your rules are evaluated in the exact order that you provide them
    /// in the policy. With strict ordering, the rule groups are evaluated by order of priority, starting from the lowest number, and
    /// the rules in each rule group are processed in the order that they're defined. </p>
    pub rule_order: std::option::Option<crate::model::RuleOrder>,
}
impl StatefulEngineOptions {
    /// <p>Indicates how to manage the order of stateful rule evaluation for the policy. By default, Network Firewall
    /// leaves the rule evaluation order up to the Suricata rule processing engine. If you set
    /// this to <code>STRICT_ORDER</code>, your rules are evaluated in the exact order that you provide them
    /// in the policy. With strict ordering, the rule groups are evaluated by order of priority, starting from the lowest number, and
    /// the rules in each rule group are processed in the order that they're defined. </p>
    pub fn rule_order(&self) -> std::option::Option<&crate::model::RuleOrder> {
        self.rule_order.as_ref()
    }
}
impl std::fmt::Debug for StatefulEngineOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatefulEngineOptions");
        formatter.field("rule_order", &self.rule_order);
        formatter.finish()
    }
}
/// See [`StatefulEngineOptions`](crate::model::StatefulEngineOptions)
pub mod stateful_engine_options {
    /// A builder for [`StatefulEngineOptions`](crate::model::StatefulEngineOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_order: std::option::Option<crate::model::RuleOrder>,
    }
    impl Builder {
        /// <p>Indicates how to manage the order of stateful rule evaluation for the policy. By default, Network Firewall
        /// leaves the rule evaluation order up to the Suricata rule processing engine. If you set
        /// this to <code>STRICT_ORDER</code>, your rules are evaluated in the exact order that you provide them
        /// in the policy. With strict ordering, the rule groups are evaluated by order of priority, starting from the lowest number, and
        /// the rules in each rule group are processed in the order that they're defined. </p>
        pub fn rule_order(mut self, input: crate::model::RuleOrder) -> Self {
            self.rule_order = Some(input);
            self
        }
        /// <p>Indicates how to manage the order of stateful rule evaluation for the policy. By default, Network Firewall
        /// leaves the rule evaluation order up to the Suricata rule processing engine. If you set
        /// this to <code>STRICT_ORDER</code>, your rules are evaluated in the exact order that you provide them
        /// in the policy. With strict ordering, the rule groups are evaluated by order of priority, starting from the lowest number, and
        /// the rules in each rule group are processed in the order that they're defined. </p>
        pub fn set_rule_order(
            mut self,
            input: std::option::Option<crate::model::RuleOrder>,
        ) -> Self {
            self.rule_order = input;
            self
        }
        /// Consumes the builder and constructs a [`StatefulEngineOptions`](crate::model::StatefulEngineOptions)
        pub fn build(self) -> crate::model::StatefulEngineOptions {
            crate::model::StatefulEngineOptions {
                rule_order: self.rule_order,
            }
        }
    }
}
impl StatefulEngineOptions {
    /// Creates a new builder-style object to manufacture [`StatefulEngineOptions`](crate::model::StatefulEngineOptions)
    pub fn builder() -> crate::model::stateful_engine_options::Builder {
        crate::model::stateful_engine_options::Builder::default()
    }
}

/// <p>Identifier for a single stateful rule group, used in a firewall policy to refer to a
/// rule group. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatefulRuleGroupReference {
    /// <p>The Amazon Resource Name (ARN) of the stateful rule group.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>An integer setting that indicates the order in which to run the stateful rule groups in
    /// a single <a>FirewallPolicy</a>. This setting only applies to firewall policies
    /// that specify the <code>STRICT_ORDER</code> rule order in the stateful engine options settings.</p>
    /// <p>Network Firewall evalutes each stateful rule group
    /// against a packet starting with the group that has the lowest priority setting. You must ensure
    /// that the priority settings are unique within each policy.</p>
    /// <p>You can change the priority settings of your rule groups at any time. To make it easier to
    /// insert rule groups later, number them so there's a wide range in between, for example use 100,
    /// 200, and so on. </p>
    pub priority: std::option::Option<i32>,
}
impl StatefulRuleGroupReference {
    /// <p>The Amazon Resource Name (ARN) of the stateful rule group.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>An integer setting that indicates the order in which to run the stateful rule groups in
    /// a single <a>FirewallPolicy</a>. This setting only applies to firewall policies
    /// that specify the <code>STRICT_ORDER</code> rule order in the stateful engine options settings.</p>
    /// <p>Network Firewall evalutes each stateful rule group
    /// against a packet starting with the group that has the lowest priority setting. You must ensure
    /// that the priority settings are unique within each policy.</p>
    /// <p>You can change the priority settings of your rule groups at any time. To make it easier to
    /// insert rule groups later, number them so there's a wide range in between, for example use 100,
    /// 200, and so on. </p>
    pub fn priority(&self) -> std::option::Option<i32> {
        self.priority
    }
}
impl std::fmt::Debug for StatefulRuleGroupReference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatefulRuleGroupReference");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("priority", &self.priority);
        formatter.finish()
    }
}
/// See [`StatefulRuleGroupReference`](crate::model::StatefulRuleGroupReference)
pub mod stateful_rule_group_reference {
    /// A builder for [`StatefulRuleGroupReference`](crate::model::StatefulRuleGroupReference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the stateful rule group.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stateful rule group.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>An integer setting that indicates the order in which to run the stateful rule groups in
        /// a single <a>FirewallPolicy</a>. This setting only applies to firewall policies
        /// that specify the <code>STRICT_ORDER</code> rule order in the stateful engine options settings.</p>
        /// <p>Network Firewall evalutes each stateful rule group
        /// against a packet starting with the group that has the lowest priority setting. You must ensure
        /// that the priority settings are unique within each policy.</p>
        /// <p>You can change the priority settings of your rule groups at any time. To make it easier to
        /// insert rule groups later, number them so there's a wide range in between, for example use 100,
        /// 200, and so on. </p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>An integer setting that indicates the order in which to run the stateful rule groups in
        /// a single <a>FirewallPolicy</a>. This setting only applies to firewall policies
        /// that specify the <code>STRICT_ORDER</code> rule order in the stateful engine options settings.</p>
        /// <p>Network Firewall evalutes each stateful rule group
        /// against a packet starting with the group that has the lowest priority setting. You must ensure
        /// that the priority settings are unique within each policy.</p>
        /// <p>You can change the priority settings of your rule groups at any time. To make it easier to
        /// insert rule groups later, number them so there's a wide range in between, for example use 100,
        /// 200, and so on. </p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// Consumes the builder and constructs a [`StatefulRuleGroupReference`](crate::model::StatefulRuleGroupReference)
        pub fn build(self) -> crate::model::StatefulRuleGroupReference {
            crate::model::StatefulRuleGroupReference {
                resource_arn: self.resource_arn,
                priority: self.priority,
            }
        }
    }
}
impl StatefulRuleGroupReference {
    /// Creates a new builder-style object to manufacture [`StatefulRuleGroupReference`](crate::model::StatefulRuleGroupReference)
    pub fn builder() -> crate::model::stateful_rule_group_reference::Builder {
        crate::model::stateful_rule_group_reference::Builder::default()
    }
}

/// <p>Identifier for a single stateless rule group, used in a firewall policy to refer to the
/// rule group. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatelessRuleGroupReference {
    /// <p>The Amazon Resource Name (ARN) of the stateless rule group.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>An integer setting that indicates the order in which to run the stateless rule groups in
    /// a single <a>FirewallPolicy</a>. Network Firewall applies each stateless rule group
    /// to a packet starting with the group that has the lowest priority setting. You must ensure
    /// that the priority settings are unique within each policy.</p>
    pub priority: i32,
}
impl StatelessRuleGroupReference {
    /// <p>The Amazon Resource Name (ARN) of the stateless rule group.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>An integer setting that indicates the order in which to run the stateless rule groups in
    /// a single <a>FirewallPolicy</a>. Network Firewall applies each stateless rule group
    /// to a packet starting with the group that has the lowest priority setting. You must ensure
    /// that the priority settings are unique within each policy.</p>
    pub fn priority(&self) -> i32 {
        self.priority
    }
}
impl std::fmt::Debug for StatelessRuleGroupReference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatelessRuleGroupReference");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("priority", &self.priority);
        formatter.finish()
    }
}
/// See [`StatelessRuleGroupReference`](crate::model::StatelessRuleGroupReference)
pub mod stateless_rule_group_reference {
    /// A builder for [`StatelessRuleGroupReference`](crate::model::StatelessRuleGroupReference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the stateless rule group.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stateless rule group.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>An integer setting that indicates the order in which to run the stateless rule groups in
        /// a single <a>FirewallPolicy</a>. Network Firewall applies each stateless rule group
        /// to a packet starting with the group that has the lowest priority setting. You must ensure
        /// that the priority settings are unique within each policy.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>An integer setting that indicates the order in which to run the stateless rule groups in
        /// a single <a>FirewallPolicy</a>. Network Firewall applies each stateless rule group
        /// to a packet starting with the group that has the lowest priority setting. You must ensure
        /// that the priority settings are unique within each policy.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// Consumes the builder and constructs a [`StatelessRuleGroupReference`](crate::model::StatelessRuleGroupReference)
        pub fn build(self) -> crate::model::StatelessRuleGroupReference {
            crate::model::StatelessRuleGroupReference {
                resource_arn: self.resource_arn,
                priority: self.priority.unwrap_or_default(),
            }
        }
    }
}
impl StatelessRuleGroupReference {
    /// Creates a new builder-style object to manufacture [`StatelessRuleGroupReference`](crate::model::StatelessRuleGroupReference)
    pub fn builder() -> crate::model::stateless_rule_group_reference::Builder {
        crate::model::stateless_rule_group_reference::Builder::default()
    }
}

/// <p>High-level information about a rule group, returned by <a>ListRuleGroups</a>.
/// You can use the information provided in the metadata to retrieve and manage a
/// rule group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleGroupMetadata {
    /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl RuleGroupMetadata {
    /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for RuleGroupMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleGroupMetadata");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`RuleGroupMetadata`](crate::model::RuleGroupMetadata)
pub mod rule_group_metadata {
    /// A builder for [`RuleGroupMetadata`](crate::model::RuleGroupMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The descriptive name of the rule group. You can't change the name of a rule group after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleGroupMetadata`](crate::model::RuleGroupMetadata)
        pub fn build(self) -> crate::model::RuleGroupMetadata {
            crate::model::RuleGroupMetadata {
                name: self.name,
                arn: self.arn,
            }
        }
    }
}
impl RuleGroupMetadata {
    /// Creates a new builder-style object to manufacture [`RuleGroupMetadata`](crate::model::RuleGroupMetadata)
    pub fn builder() -> crate::model::rule_group_metadata::Builder {
        crate::model::rule_group_metadata::Builder::default()
    }
}

/// <p>High-level information about a firewall, returned by operations like create and
/// describe. You can use the information provided in the metadata to retrieve and manage a
/// firewall.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FirewallMetadata {
    /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    pub firewall_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
    pub firewall_arn: std::option::Option<std::string::String>,
}
impl FirewallMetadata {
    /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    pub fn firewall_name(&self) -> std::option::Option<&str> {
        self.firewall_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
    pub fn firewall_arn(&self) -> std::option::Option<&str> {
        self.firewall_arn.as_deref()
    }
}
impl std::fmt::Debug for FirewallMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FirewallMetadata");
        formatter.field("firewall_name", &self.firewall_name);
        formatter.field("firewall_arn", &self.firewall_arn);
        formatter.finish()
    }
}
/// See [`FirewallMetadata`](crate::model::FirewallMetadata)
pub mod firewall_metadata {
    /// A builder for [`FirewallMetadata`](crate::model::FirewallMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_name: std::option::Option<std::string::String>,
        pub(crate) firewall_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_name = Some(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.firewall_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`FirewallMetadata`](crate::model::FirewallMetadata)
        pub fn build(self) -> crate::model::FirewallMetadata {
            crate::model::FirewallMetadata {
                firewall_name: self.firewall_name,
                firewall_arn: self.firewall_arn,
            }
        }
    }
}
impl FirewallMetadata {
    /// Creates a new builder-style object to manufacture [`FirewallMetadata`](crate::model::FirewallMetadata)
    pub fn builder() -> crate::model::firewall_metadata::Builder {
        crate::model::firewall_metadata::Builder::default()
    }
}

/// <p>High-level information about a firewall policy, returned by operations like create and
/// describe. You can use the information provided in the metadata to retrieve and manage a
/// firewall policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FirewallPolicyMetadata {
    /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl FirewallPolicyMetadata {
    /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for FirewallPolicyMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FirewallPolicyMetadata");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`FirewallPolicyMetadata`](crate::model::FirewallPolicyMetadata)
pub mod firewall_policy_metadata {
    /// A builder for [`FirewallPolicyMetadata`](crate::model::FirewallPolicyMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`FirewallPolicyMetadata`](crate::model::FirewallPolicyMetadata)
        pub fn build(self) -> crate::model::FirewallPolicyMetadata {
            crate::model::FirewallPolicyMetadata {
                name: self.name,
                arn: self.arn,
            }
        }
    }
}
impl FirewallPolicyMetadata {
    /// Creates a new builder-style object to manufacture [`FirewallPolicyMetadata`](crate::model::FirewallPolicyMetadata)
    pub fn builder() -> crate::model::firewall_policy_metadata::Builder {
        crate::model::firewall_policy_metadata::Builder::default()
    }
}

/// <p>The ID for a subnet that you want to associate with the firewall. This is used with
/// <a>CreateFirewall</a> and <a>AssociateSubnets</a>. AWS Network Firewall
/// creates an instance of the associated firewall in each subnet that you specify, to filter
/// traffic in the subnet's Availability Zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetMapping {
    /// <p>The unique identifier for the subnet. </p>
    pub subnet_id: std::option::Option<std::string::String>,
}
impl SubnetMapping {
    /// <p>The unique identifier for the subnet. </p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
}
impl std::fmt::Debug for SubnetMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetMapping");
        formatter.field("subnet_id", &self.subnet_id);
        formatter.finish()
    }
}
/// See [`SubnetMapping`](crate::model::SubnetMapping)
pub mod subnet_mapping {
    /// A builder for [`SubnetMapping`](crate::model::SubnetMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the subnet. </p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the subnet. </p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetMapping`](crate::model::SubnetMapping)
        pub fn build(self) -> crate::model::SubnetMapping {
            crate::model::SubnetMapping {
                subnet_id: self.subnet_id,
            }
        }
    }
}
impl SubnetMapping {
    /// Creates a new builder-style object to manufacture [`SubnetMapping`](crate::model::SubnetMapping)
    pub fn builder() -> crate::model::subnet_mapping::Builder {
        crate::model::subnet_mapping::Builder::default()
    }
}

/// <p>Detailed information about the current status of a <a>Firewall</a>. You can retrieve this for a firewall by calling <a>DescribeFirewall</a> and providing the firewall name and ARN.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FirewallStatus {
    /// <p>The readiness of the configured firewall to handle network traffic across all of the
    /// Availability Zones where you've configured it. This setting is <code>READY</code> only when
    /// the <code>ConfigurationSyncStateSummary</code> value is <code>IN_SYNC</code> and the
    /// <code>Attachment</code>
    /// <code>Status</code> values for all of the configured subnets are <code>READY</code>.
    /// </p>
    pub status: std::option::Option<crate::model::FirewallStatusValue>,
    /// <p>The configuration sync state for the firewall. This summarizes the sync states reported
    /// in the <code>Config</code> settings for all of the Availability Zones where you have
    /// configured the firewall. </p>
    /// <p>When you create a firewall or update its configuration, for example by adding a rule
    /// group to its firewall policy, Network Firewall distributes the configuration changes to all
    /// zones where the firewall is in use. This summary indicates whether the configuration
    /// changes have been applied everywhere. </p>
    /// <p>This status must be <code>IN_SYNC</code> for the firewall to be ready for use, but it
    /// doesn't indicate that the firewall is ready. The <code>Status</code> setting indicates
    /// firewall readiness.</p>
    pub configuration_sync_state_summary: std::option::Option<crate::model::ConfigurationSyncState>,
    /// <p>The subnets that you've configured for use by the Network Firewall firewall. This contains
    /// one array element per Availability Zone where you've configured a subnet. These objects
    /// provide details of the information that is summarized in the
    /// <code>ConfigurationSyncStateSummary</code> and <code>Status</code>, broken down by zone
    /// and configuration object. </p>
    pub sync_states: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::SyncState>,
    >,
}
impl FirewallStatus {
    /// <p>The readiness of the configured firewall to handle network traffic across all of the
    /// Availability Zones where you've configured it. This setting is <code>READY</code> only when
    /// the <code>ConfigurationSyncStateSummary</code> value is <code>IN_SYNC</code> and the
    /// <code>Attachment</code>
    /// <code>Status</code> values for all of the configured subnets are <code>READY</code>.
    /// </p>
    pub fn status(&self) -> std::option::Option<&crate::model::FirewallStatusValue> {
        self.status.as_ref()
    }
    /// <p>The configuration sync state for the firewall. This summarizes the sync states reported
    /// in the <code>Config</code> settings for all of the Availability Zones where you have
    /// configured the firewall. </p>
    /// <p>When you create a firewall or update its configuration, for example by adding a rule
    /// group to its firewall policy, Network Firewall distributes the configuration changes to all
    /// zones where the firewall is in use. This summary indicates whether the configuration
    /// changes have been applied everywhere. </p>
    /// <p>This status must be <code>IN_SYNC</code> for the firewall to be ready for use, but it
    /// doesn't indicate that the firewall is ready. The <code>Status</code> setting indicates
    /// firewall readiness.</p>
    pub fn configuration_sync_state_summary(
        &self,
    ) -> std::option::Option<&crate::model::ConfigurationSyncState> {
        self.configuration_sync_state_summary.as_ref()
    }
    /// <p>The subnets that you've configured for use by the Network Firewall firewall. This contains
    /// one array element per Availability Zone where you've configured a subnet. These objects
    /// provide details of the information that is summarized in the
    /// <code>ConfigurationSyncStateSummary</code> and <code>Status</code>, broken down by zone
    /// and configuration object. </p>
    pub fn sync_states(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::SyncState>>
    {
        self.sync_states.as_ref()
    }
}
impl std::fmt::Debug for FirewallStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FirewallStatus");
        formatter.field("status", &self.status);
        formatter.field(
            "configuration_sync_state_summary",
            &self.configuration_sync_state_summary,
        );
        formatter.field("sync_states", &self.sync_states);
        formatter.finish()
    }
}
/// See [`FirewallStatus`](crate::model::FirewallStatus)
pub mod firewall_status {
    /// A builder for [`FirewallStatus`](crate::model::FirewallStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::FirewallStatusValue>,
        pub(crate) configuration_sync_state_summary:
            std::option::Option<crate::model::ConfigurationSyncState>,
        pub(crate) sync_states: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::SyncState>,
        >,
    }
    impl Builder {
        /// <p>The readiness of the configured firewall to handle network traffic across all of the
        /// Availability Zones where you've configured it. This setting is <code>READY</code> only when
        /// the <code>ConfigurationSyncStateSummary</code> value is <code>IN_SYNC</code> and the
        /// <code>Attachment</code>
        /// <code>Status</code> values for all of the configured subnets are <code>READY</code>.
        /// </p>
        pub fn status(mut self, input: crate::model::FirewallStatusValue) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The readiness of the configured firewall to handle network traffic across all of the
        /// Availability Zones where you've configured it. This setting is <code>READY</code> only when
        /// the <code>ConfigurationSyncStateSummary</code> value is <code>IN_SYNC</code> and the
        /// <code>Attachment</code>
        /// <code>Status</code> values for all of the configured subnets are <code>READY</code>.
        /// </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FirewallStatusValue>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The configuration sync state for the firewall. This summarizes the sync states reported
        /// in the <code>Config</code> settings for all of the Availability Zones where you have
        /// configured the firewall. </p>
        /// <p>When you create a firewall or update its configuration, for example by adding a rule
        /// group to its firewall policy, Network Firewall distributes the configuration changes to all
        /// zones where the firewall is in use. This summary indicates whether the configuration
        /// changes have been applied everywhere. </p>
        /// <p>This status must be <code>IN_SYNC</code> for the firewall to be ready for use, but it
        /// doesn't indicate that the firewall is ready. The <code>Status</code> setting indicates
        /// firewall readiness.</p>
        pub fn configuration_sync_state_summary(
            mut self,
            input: crate::model::ConfigurationSyncState,
        ) -> Self {
            self.configuration_sync_state_summary = Some(input);
            self
        }
        /// <p>The configuration sync state for the firewall. This summarizes the sync states reported
        /// in the <code>Config</code> settings for all of the Availability Zones where you have
        /// configured the firewall. </p>
        /// <p>When you create a firewall or update its configuration, for example by adding a rule
        /// group to its firewall policy, Network Firewall distributes the configuration changes to all
        /// zones where the firewall is in use. This summary indicates whether the configuration
        /// changes have been applied everywhere. </p>
        /// <p>This status must be <code>IN_SYNC</code> for the firewall to be ready for use, but it
        /// doesn't indicate that the firewall is ready. The <code>Status</code> setting indicates
        /// firewall readiness.</p>
        pub fn set_configuration_sync_state_summary(
            mut self,
            input: std::option::Option<crate::model::ConfigurationSyncState>,
        ) -> Self {
            self.configuration_sync_state_summary = input;
            self
        }
        /// Adds a key-value pair to `sync_states`.
        ///
        /// To override the contents of this collection use [`set_sync_states`](Self::set_sync_states).
        ///
        /// <p>The subnets that you've configured for use by the Network Firewall firewall. This contains
        /// one array element per Availability Zone where you've configured a subnet. These objects
        /// provide details of the information that is summarized in the
        /// <code>ConfigurationSyncStateSummary</code> and <code>Status</code>, broken down by zone
        /// and configuration object. </p>
        pub fn sync_states(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::SyncState>,
        ) -> Self {
            let mut hash_map = self.sync_states.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.sync_states = Some(hash_map);
            self
        }
        /// <p>The subnets that you've configured for use by the Network Firewall firewall. This contains
        /// one array element per Availability Zone where you've configured a subnet. These objects
        /// provide details of the information that is summarized in the
        /// <code>ConfigurationSyncStateSummary</code> and <code>Status</code>, broken down by zone
        /// and configuration object. </p>
        pub fn set_sync_states(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::SyncState>,
            >,
        ) -> Self {
            self.sync_states = input;
            self
        }
        /// Consumes the builder and constructs a [`FirewallStatus`](crate::model::FirewallStatus)
        pub fn build(self) -> crate::model::FirewallStatus {
            crate::model::FirewallStatus {
                status: self.status,
                configuration_sync_state_summary: self.configuration_sync_state_summary,
                sync_states: self.sync_states,
            }
        }
    }
}
impl FirewallStatus {
    /// Creates a new builder-style object to manufacture [`FirewallStatus`](crate::model::FirewallStatus)
    pub fn builder() -> crate::model::firewall_status::Builder {
        crate::model::firewall_status::Builder::default()
    }
}

/// <p>The status of the firewall endpoint and firewall policy configuration for a single VPC
/// subnet. </p>
/// <p>For each VPC subnet that you associate with a firewall, AWS Network Firewall does the
/// following: </p>
/// <ul>
/// <li>
/// <p>Instantiates a firewall endpoint in the subnet, ready to take traffic.</p>
/// </li>
/// <li>
/// <p>Configures the endpoint with the current firewall policy settings, to provide the
/// filtering behavior for the endpoint.</p>
/// </li>
/// </ul>
/// <p>When you update a firewall, for example to add a subnet association or change a rule
/// group in the firewall policy, the affected sync states reflect out-of-sync or not ready
/// status until the changes are complete. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SyncState {
    /// <p>The attachment status of the firewall's association with a single VPC subnet. For each
    /// configured subnet, Network Firewall creates the attachment by instantiating the firewall
    /// endpoint in the subnet so that it's ready to take traffic. This is part of the <a>FirewallStatus</a>.</p>
    pub attachment: std::option::Option<crate::model::Attachment>,
    /// <p>The configuration status of the firewall endpoint in a single VPC subnet. Network Firewall
    /// provides each endpoint with the rules that are configured in the firewall policy. Each time
    /// you add a subnet or modify the associated firewall policy, Network Firewall synchronizes the
    /// rules in the endpoint, so it can properly filter network traffic. This is part of the <a>FirewallStatus</a>.</p>
    pub config: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::PerObjectStatus>,
    >,
}
impl SyncState {
    /// <p>The attachment status of the firewall's association with a single VPC subnet. For each
    /// configured subnet, Network Firewall creates the attachment by instantiating the firewall
    /// endpoint in the subnet so that it's ready to take traffic. This is part of the <a>FirewallStatus</a>.</p>
    pub fn attachment(&self) -> std::option::Option<&crate::model::Attachment> {
        self.attachment.as_ref()
    }
    /// <p>The configuration status of the firewall endpoint in a single VPC subnet. Network Firewall
    /// provides each endpoint with the rules that are configured in the firewall policy. Each time
    /// you add a subnet or modify the associated firewall policy, Network Firewall synchronizes the
    /// rules in the endpoint, so it can properly filter network traffic. This is part of the <a>FirewallStatus</a>.</p>
    pub fn config(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::PerObjectStatus>,
    > {
        self.config.as_ref()
    }
}
impl std::fmt::Debug for SyncState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SyncState");
        formatter.field("attachment", &self.attachment);
        formatter.field("config", &self.config);
        formatter.finish()
    }
}
/// See [`SyncState`](crate::model::SyncState)
pub mod sync_state {
    /// A builder for [`SyncState`](crate::model::SyncState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attachment: std::option::Option<crate::model::Attachment>,
        pub(crate) config: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::PerObjectStatus>,
        >,
    }
    impl Builder {
        /// <p>The attachment status of the firewall's association with a single VPC subnet. For each
        /// configured subnet, Network Firewall creates the attachment by instantiating the firewall
        /// endpoint in the subnet so that it's ready to take traffic. This is part of the <a>FirewallStatus</a>.</p>
        pub fn attachment(mut self, input: crate::model::Attachment) -> Self {
            self.attachment = Some(input);
            self
        }
        /// <p>The attachment status of the firewall's association with a single VPC subnet. For each
        /// configured subnet, Network Firewall creates the attachment by instantiating the firewall
        /// endpoint in the subnet so that it's ready to take traffic. This is part of the <a>FirewallStatus</a>.</p>
        pub fn set_attachment(
            mut self,
            input: std::option::Option<crate::model::Attachment>,
        ) -> Self {
            self.attachment = input;
            self
        }
        /// Adds a key-value pair to `config`.
        ///
        /// To override the contents of this collection use [`set_config`](Self::set_config).
        ///
        /// <p>The configuration status of the firewall endpoint in a single VPC subnet. Network Firewall
        /// provides each endpoint with the rules that are configured in the firewall policy. Each time
        /// you add a subnet or modify the associated firewall policy, Network Firewall synchronizes the
        /// rules in the endpoint, so it can properly filter network traffic. This is part of the <a>FirewallStatus</a>.</p>
        pub fn config(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::PerObjectStatus>,
        ) -> Self {
            let mut hash_map = self.config.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.config = Some(hash_map);
            self
        }
        /// <p>The configuration status of the firewall endpoint in a single VPC subnet. Network Firewall
        /// provides each endpoint with the rules that are configured in the firewall policy. Each time
        /// you add a subnet or modify the associated firewall policy, Network Firewall synchronizes the
        /// rules in the endpoint, so it can properly filter network traffic. This is part of the <a>FirewallStatus</a>.</p>
        pub fn set_config(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::PerObjectStatus>,
            >,
        ) -> Self {
            self.config = input;
            self
        }
        /// Consumes the builder and constructs a [`SyncState`](crate::model::SyncState)
        pub fn build(self) -> crate::model::SyncState {
            crate::model::SyncState {
                attachment: self.attachment,
                config: self.config,
            }
        }
    }
}
impl SyncState {
    /// Creates a new builder-style object to manufacture [`SyncState`](crate::model::SyncState)
    pub fn builder() -> crate::model::sync_state::Builder {
        crate::model::sync_state::Builder::default()
    }
}

/// <p>Provides configuration status for a single policy or rule group that is used for a firewall endpoint. Network Firewall
/// provides each endpoint with the rules that are configured in the firewall policy. Each time
/// you add a subnet or modify the associated firewall policy, Network Firewall synchronizes the
/// rules in the endpoint, so it can properly filter network traffic. This is part of a <a>SyncState</a> for a firewall.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PerObjectStatus {
    /// <p>Indicates whether this object is in sync with the version indicated in the update token.</p>
    pub sync_status: std::option::Option<crate::model::PerObjectSyncStatus>,
    /// <p>The current version of the object that is either in sync or pending synchronization. </p>
    pub update_token: std::option::Option<std::string::String>,
}
impl PerObjectStatus {
    /// <p>Indicates whether this object is in sync with the version indicated in the update token.</p>
    pub fn sync_status(&self) -> std::option::Option<&crate::model::PerObjectSyncStatus> {
        self.sync_status.as_ref()
    }
    /// <p>The current version of the object that is either in sync or pending synchronization. </p>
    pub fn update_token(&self) -> std::option::Option<&str> {
        self.update_token.as_deref()
    }
}
impl std::fmt::Debug for PerObjectStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PerObjectStatus");
        formatter.field("sync_status", &self.sync_status);
        formatter.field("update_token", &self.update_token);
        formatter.finish()
    }
}
/// See [`PerObjectStatus`](crate::model::PerObjectStatus)
pub mod per_object_status {
    /// A builder for [`PerObjectStatus`](crate::model::PerObjectStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sync_status: std::option::Option<crate::model::PerObjectSyncStatus>,
        pub(crate) update_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether this object is in sync with the version indicated in the update token.</p>
        pub fn sync_status(mut self, input: crate::model::PerObjectSyncStatus) -> Self {
            self.sync_status = Some(input);
            self
        }
        /// <p>Indicates whether this object is in sync with the version indicated in the update token.</p>
        pub fn set_sync_status(
            mut self,
            input: std::option::Option<crate::model::PerObjectSyncStatus>,
        ) -> Self {
            self.sync_status = input;
            self
        }
        /// <p>The current version of the object that is either in sync or pending synchronization. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_token = Some(input.into());
            self
        }
        /// <p>The current version of the object that is either in sync or pending synchronization. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.update_token = input;
            self
        }
        /// Consumes the builder and constructs a [`PerObjectStatus`](crate::model::PerObjectStatus)
        pub fn build(self) -> crate::model::PerObjectStatus {
            crate::model::PerObjectStatus {
                sync_status: self.sync_status,
                update_token: self.update_token,
            }
        }
    }
}
impl PerObjectStatus {
    /// Creates a new builder-style object to manufacture [`PerObjectStatus`](crate::model::PerObjectStatus)
    pub fn builder() -> crate::model::per_object_status::Builder {
        crate::model::per_object_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PerObjectSyncStatus {
    #[allow(missing_docs)] // documentation missing in model
    InSync,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PerObjectSyncStatus {
    fn from(s: &str) -> Self {
        match s {
            "IN_SYNC" => PerObjectSyncStatus::InSync,
            "PENDING" => PerObjectSyncStatus::Pending,
            other => PerObjectSyncStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PerObjectSyncStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PerObjectSyncStatus::from(s))
    }
}
impl PerObjectSyncStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PerObjectSyncStatus::InSync => "IN_SYNC",
            PerObjectSyncStatus::Pending => "PENDING",
            PerObjectSyncStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IN_SYNC", "PENDING"]
    }
}
impl AsRef<str> for PerObjectSyncStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configuration and status for a single subnet that you've specified for use by the
/// AWS Network Firewall firewall. This is part of the <a>FirewallStatus</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Attachment {
    /// <p>The unique identifier of the subnet that you've specified to be used for a firewall
    /// endpoint. </p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the firewall endpoint that Network Firewall has instantiated in the
    /// subnet. You use this to identify the firewall endpoint in the VPC route tables, when you
    /// redirect the VPC traffic through the endpoint. </p>
    pub endpoint_id: std::option::Option<std::string::String>,
    /// <p>The current status of the firewall endpoint in the subnet. This value reflects both the
    /// instantiation of the endpoint in the VPC subnet and the sync states that are reported in
    /// the <code>Config</code> settings. When this value is <code>READY</code>, the endpoint is
    /// available and configured properly to handle network traffic. When the endpoint isn't
    /// available for traffic, this value will reflect its state, for example
    /// <code>CREATING</code>, <code>DELETING</code>, or <code>FAILED</code>.</p>
    pub status: std::option::Option<crate::model::AttachmentStatus>,
}
impl Attachment {
    /// <p>The unique identifier of the subnet that you've specified to be used for a firewall
    /// endpoint. </p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The identifier of the firewall endpoint that Network Firewall has instantiated in the
    /// subnet. You use this to identify the firewall endpoint in the VPC route tables, when you
    /// redirect the VPC traffic through the endpoint. </p>
    pub fn endpoint_id(&self) -> std::option::Option<&str> {
        self.endpoint_id.as_deref()
    }
    /// <p>The current status of the firewall endpoint in the subnet. This value reflects both the
    /// instantiation of the endpoint in the VPC subnet and the sync states that are reported in
    /// the <code>Config</code> settings. When this value is <code>READY</code>, the endpoint is
    /// available and configured properly to handle network traffic. When the endpoint isn't
    /// available for traffic, this value will reflect its state, for example
    /// <code>CREATING</code>, <code>DELETING</code>, or <code>FAILED</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AttachmentStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for Attachment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Attachment");
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("endpoint_id", &self.endpoint_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`Attachment`](crate::model::Attachment)
pub mod attachment {
    /// A builder for [`Attachment`](crate::model::Attachment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) endpoint_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AttachmentStatus>,
    }
    impl Builder {
        /// <p>The unique identifier of the subnet that you've specified to be used for a firewall
        /// endpoint. </p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the subnet that you've specified to be used for a firewall
        /// endpoint. </p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The identifier of the firewall endpoint that Network Firewall has instantiated in the
        /// subnet. You use this to identify the firewall endpoint in the VPC route tables, when you
        /// redirect the VPC traffic through the endpoint. </p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_id = Some(input.into());
            self
        }
        /// <p>The identifier of the firewall endpoint that Network Firewall has instantiated in the
        /// subnet. You use this to identify the firewall endpoint in the VPC route tables, when you
        /// redirect the VPC traffic through the endpoint. </p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_id = input;
            self
        }
        /// <p>The current status of the firewall endpoint in the subnet. This value reflects both the
        /// instantiation of the endpoint in the VPC subnet and the sync states that are reported in
        /// the <code>Config</code> settings. When this value is <code>READY</code>, the endpoint is
        /// available and configured properly to handle network traffic. When the endpoint isn't
        /// available for traffic, this value will reflect its state, for example
        /// <code>CREATING</code>, <code>DELETING</code>, or <code>FAILED</code>.</p>
        pub fn status(mut self, input: crate::model::AttachmentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the firewall endpoint in the subnet. This value reflects both the
        /// instantiation of the endpoint in the VPC subnet and the sync states that are reported in
        /// the <code>Config</code> settings. When this value is <code>READY</code>, the endpoint is
        /// available and configured properly to handle network traffic. When the endpoint isn't
        /// available for traffic, this value will reflect its state, for example
        /// <code>CREATING</code>, <code>DELETING</code>, or <code>FAILED</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AttachmentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`Attachment`](crate::model::Attachment)
        pub fn build(self) -> crate::model::Attachment {
            crate::model::Attachment {
                subnet_id: self.subnet_id,
                endpoint_id: self.endpoint_id,
                status: self.status,
            }
        }
    }
}
impl Attachment {
    /// Creates a new builder-style object to manufacture [`Attachment`](crate::model::Attachment)
    pub fn builder() -> crate::model::attachment::Builder {
        crate::model::attachment::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AttachmentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    #[allow(missing_docs)] // documentation missing in model
    Scaling,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AttachmentStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATING" => AttachmentStatus::Creating,
            "DELETING" => AttachmentStatus::Deleting,
            "READY" => AttachmentStatus::Ready,
            "SCALING" => AttachmentStatus::Scaling,
            other => AttachmentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AttachmentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AttachmentStatus::from(s))
    }
}
impl AttachmentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AttachmentStatus::Creating => "CREATING",
            AttachmentStatus::Deleting => "DELETING",
            AttachmentStatus::Ready => "READY",
            AttachmentStatus::Scaling => "SCALING",
            AttachmentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATING", "DELETING", "READY", "SCALING"]
    }
}
impl AsRef<str> for AttachmentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfigurationSyncState {
    #[allow(missing_docs)] // documentation missing in model
    InSync,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfigurationSyncState {
    fn from(s: &str) -> Self {
        match s {
            "IN_SYNC" => ConfigurationSyncState::InSync,
            "PENDING" => ConfigurationSyncState::Pending,
            other => ConfigurationSyncState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfigurationSyncState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfigurationSyncState::from(s))
    }
}
impl ConfigurationSyncState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfigurationSyncState::InSync => "IN_SYNC",
            ConfigurationSyncState::Pending => "PENDING",
            ConfigurationSyncState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IN_SYNC", "PENDING"]
    }
}
impl AsRef<str> for ConfigurationSyncState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FirewallStatusValue {
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Provisioning,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FirewallStatusValue {
    fn from(s: &str) -> Self {
        match s {
            "DELETING" => FirewallStatusValue::Deleting,
            "PROVISIONING" => FirewallStatusValue::Provisioning,
            "READY" => FirewallStatusValue::Ready,
            other => FirewallStatusValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FirewallStatusValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FirewallStatusValue::from(s))
    }
}
impl FirewallStatusValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FirewallStatusValue::Deleting => "DELETING",
            FirewallStatusValue::Provisioning => "PROVISIONING",
            FirewallStatusValue::Ready => "READY",
            FirewallStatusValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETING", "PROVISIONING", "READY"]
    }
}
impl AsRef<str> for FirewallStatusValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The firewall defines the configuration settings for an AWS Network Firewall firewall. These settings include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and any tags that are attached to the firewall AWS resource. </p>
/// <p>The status of the firewall, for example whether it's ready to filter network traffic,
/// is provided in the corresponding <a>FirewallStatus</a>. You can retrieve both
/// objects by calling <a>DescribeFirewall</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Firewall {
    /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    pub firewall_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
    pub firewall_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
    /// <p>The relationship of firewall to firewall policy is many to one. Each firewall requires
    /// one firewall policy association, and you can use the same firewall policy for multiple
    /// firewalls. </p>
    pub firewall_policy_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the VPC where the firewall is in use. </p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The public subnets that Network Firewall is using for the firewall. Each subnet must belong
    /// to a different Availability Zone. </p>
    pub subnet_mappings: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
    /// <p>A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates
    /// that the firewall is protected against deletion. Use this setting to protect against
    /// accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.</p>
    pub delete_protection: bool,
    /// <p>A setting indicating whether the firewall is protected against changes to the subnet associations.
    /// Use this setting to protect against
    /// accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
    pub subnet_change_protection: bool,
    /// <p>A setting indicating whether the firewall is protected against a change to the firewall policy association.
    /// Use this setting to protect against
    /// accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
    pub firewall_policy_change_protection: bool,
    /// <p>A description of the firewall.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the firewall. </p>
    pub firewall_id: std::option::Option<std::string::String>,
    /// <p></p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl Firewall {
    /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    pub fn firewall_name(&self) -> std::option::Option<&str> {
        self.firewall_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
    pub fn firewall_arn(&self) -> std::option::Option<&str> {
        self.firewall_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
    /// <p>The relationship of firewall to firewall policy is many to one. Each firewall requires
    /// one firewall policy association, and you can use the same firewall policy for multiple
    /// firewalls. </p>
    pub fn firewall_policy_arn(&self) -> std::option::Option<&str> {
        self.firewall_policy_arn.as_deref()
    }
    /// <p>The unique identifier of the VPC where the firewall is in use. </p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The public subnets that Network Firewall is using for the firewall. Each subnet must belong
    /// to a different Availability Zone. </p>
    pub fn subnet_mappings(&self) -> std::option::Option<&[crate::model::SubnetMapping]> {
        self.subnet_mappings.as_deref()
    }
    /// <p>A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates
    /// that the firewall is protected against deletion. Use this setting to protect against
    /// accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.</p>
    pub fn delete_protection(&self) -> bool {
        self.delete_protection
    }
    /// <p>A setting indicating whether the firewall is protected against changes to the subnet associations.
    /// Use this setting to protect against
    /// accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
    pub fn subnet_change_protection(&self) -> bool {
        self.subnet_change_protection
    }
    /// <p>A setting indicating whether the firewall is protected against a change to the firewall policy association.
    /// Use this setting to protect against
    /// accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
    pub fn firewall_policy_change_protection(&self) -> bool {
        self.firewall_policy_change_protection
    }
    /// <p>A description of the firewall.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The unique identifier for the firewall. </p>
    pub fn firewall_id(&self) -> std::option::Option<&str> {
        self.firewall_id.as_deref()
    }
    /// <p></p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for Firewall {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Firewall");
        formatter.field("firewall_name", &self.firewall_name);
        formatter.field("firewall_arn", &self.firewall_arn);
        formatter.field("firewall_policy_arn", &self.firewall_policy_arn);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_mappings", &self.subnet_mappings);
        formatter.field("delete_protection", &self.delete_protection);
        formatter.field("subnet_change_protection", &self.subnet_change_protection);
        formatter.field(
            "firewall_policy_change_protection",
            &self.firewall_policy_change_protection,
        );
        formatter.field("description", &self.description);
        formatter.field("firewall_id", &self.firewall_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Firewall`](crate::model::Firewall)
pub mod firewall {
    /// A builder for [`Firewall`](crate::model::Firewall)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_name: std::option::Option<std::string::String>,
        pub(crate) firewall_arn: std::option::Option<std::string::String>,
        pub(crate) firewall_policy_arn: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_mappings: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
        pub(crate) delete_protection: std::option::Option<bool>,
        pub(crate) subnet_change_protection: std::option::Option<bool>,
        pub(crate) firewall_policy_change_protection: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) firewall_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_name = Some(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.firewall_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        /// <p>The relationship of firewall to firewall policy is many to one. Each firewall requires
        /// one firewall policy association, and you can use the same firewall policy for multiple
        /// firewalls. </p>
        pub fn firewall_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        /// <p>The relationship of firewall to firewall policy is many to one. Each firewall requires
        /// one firewall policy association, and you can use the same firewall policy for multiple
        /// firewalls. </p>
        pub fn set_firewall_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_policy_arn = input;
            self
        }
        /// <p>The unique identifier of the VPC where the firewall is in use. </p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the VPC where the firewall is in use. </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `subnet_mappings`.
        ///
        /// To override the contents of this collection use [`set_subnet_mappings`](Self::set_subnet_mappings).
        ///
        /// <p>The public subnets that Network Firewall is using for the firewall. Each subnet must belong
        /// to a different Availability Zone. </p>
        pub fn subnet_mappings(mut self, input: impl Into<crate::model::SubnetMapping>) -> Self {
            let mut v = self.subnet_mappings.unwrap_or_default();
            v.push(input.into());
            self.subnet_mappings = Some(v);
            self
        }
        /// <p>The public subnets that Network Firewall is using for the firewall. Each subnet must belong
        /// to a different Availability Zone. </p>
        pub fn set_subnet_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
        ) -> Self {
            self.subnet_mappings = input;
            self
        }
        /// <p>A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates
        /// that the firewall is protected against deletion. Use this setting to protect against
        /// accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.</p>
        pub fn delete_protection(mut self, input: bool) -> Self {
            self.delete_protection = Some(input);
            self
        }
        /// <p>A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates
        /// that the firewall is protected against deletion. Use this setting to protect against
        /// accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.</p>
        pub fn set_delete_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_protection = input;
            self
        }
        /// <p>A setting indicating whether the firewall is protected against changes to the subnet associations.
        /// Use this setting to protect against
        /// accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn subnet_change_protection(mut self, input: bool) -> Self {
            self.subnet_change_protection = Some(input);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against changes to the subnet associations.
        /// Use this setting to protect against
        /// accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn set_subnet_change_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.subnet_change_protection = input;
            self
        }
        /// <p>A setting indicating whether the firewall is protected against a change to the firewall policy association.
        /// Use this setting to protect against
        /// accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn firewall_policy_change_protection(mut self, input: bool) -> Self {
            self.firewall_policy_change_protection = Some(input);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against a change to the firewall policy association.
        /// Use this setting to protect against
        /// accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn set_firewall_policy_change_protection(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.firewall_policy_change_protection = input;
            self
        }
        /// <p>A description of the firewall.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the firewall.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique identifier for the firewall. </p>
        pub fn firewall_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the firewall. </p>
        pub fn set_firewall_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.firewall_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p></p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p></p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Firewall`](crate::model::Firewall)
        pub fn build(self) -> crate::model::Firewall {
            crate::model::Firewall {
                firewall_name: self.firewall_name,
                firewall_arn: self.firewall_arn,
                firewall_policy_arn: self.firewall_policy_arn,
                vpc_id: self.vpc_id,
                subnet_mappings: self.subnet_mappings,
                delete_protection: self.delete_protection.unwrap_or_default(),
                subnet_change_protection: self.subnet_change_protection.unwrap_or_default(),
                firewall_policy_change_protection: self
                    .firewall_policy_change_protection
                    .unwrap_or_default(),
                description: self.description,
                firewall_id: self.firewall_id,
                tags: self.tags,
            }
        }
    }
}
impl Firewall {
    /// Creates a new builder-style object to manufacture [`Firewall`](crate::model::Firewall)
    pub fn builder() -> crate::model::firewall::Builder {
        crate::model::firewall::Builder::default()
    }
}
