// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSubnetChangeProtectionOutput {
    /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
    /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
    /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    pub update_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
    pub firewall_arn: std::option::Option<std::string::String>,
    /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    pub firewall_name: std::option::Option<std::string::String>,
    /// <p>A setting indicating whether the firewall is protected against changes to the subnet associations.
    /// Use this setting to protect against
    /// accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
    pub subnet_change_protection: bool,
}
impl std::fmt::Debug for UpdateSubnetChangeProtectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSubnetChangeProtectionOutput");
        formatter.field("update_token", &self.update_token);
        formatter.field("firewall_arn", &self.firewall_arn);
        formatter.field("firewall_name", &self.firewall_name);
        formatter.field("subnet_change_protection", &self.subnet_change_protection);
        formatter.finish()
    }
}
/// See [`UpdateSubnetChangeProtectionOutput`](crate::output::UpdateSubnetChangeProtectionOutput)
pub mod update_subnet_change_protection_output {
    /// A builder for [`UpdateSubnetChangeProtectionOutput`](crate::output::UpdateSubnetChangeProtectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_token: std::option::Option<std::string::String>,
        pub(crate) firewall_arn: std::option::Option<std::string::String>,
        pub(crate) firewall_name: std::option::Option<std::string::String>,
        pub(crate) subnet_change_protection: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_token = Some(input.into());
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.update_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.firewall_arn = input;
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_name = Some(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_name = input;
            self
        }
        /// <p>A setting indicating whether the firewall is protected against changes to the subnet associations.
        /// Use this setting to protect against
        /// accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn subnet_change_protection(mut self, input: bool) -> Self {
            self.subnet_change_protection = Some(input);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against changes to the subnet associations.
        /// Use this setting to protect against
        /// accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn set_subnet_change_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.subnet_change_protection = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSubnetChangeProtectionOutput`](crate::output::UpdateSubnetChangeProtectionOutput)
        pub fn build(self) -> crate::output::UpdateSubnetChangeProtectionOutput {
            crate::output::UpdateSubnetChangeProtectionOutput {
                update_token: self.update_token,
                firewall_arn: self.firewall_arn,
                firewall_name: self.firewall_name,
                subnet_change_protection: self.subnet_change_protection.unwrap_or_default(),
            }
        }
    }
}
impl UpdateSubnetChangeProtectionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSubnetChangeProtectionOutput`](crate::output::UpdateSubnetChangeProtectionOutput)
    pub fn builder() -> crate::output::update_subnet_change_protection_output::Builder {
        crate::output::update_subnet_change_protection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRuleGroupOutput {
    /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p>
    /// <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>
    pub update_token: std::option::Option<std::string::String>,
    /// <p>The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>
    pub rule_group_response: std::option::Option<crate::model::RuleGroupResponse>,
}
impl std::fmt::Debug for UpdateRuleGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRuleGroupOutput");
        formatter.field("update_token", &self.update_token);
        formatter.field("rule_group_response", &self.rule_group_response);
        formatter.finish()
    }
}
/// See [`UpdateRuleGroupOutput`](crate::output::UpdateRuleGroupOutput)
pub mod update_rule_group_output {
    /// A builder for [`UpdateRuleGroupOutput`](crate::output::UpdateRuleGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_token: std::option::Option<std::string::String>,
        pub(crate) rule_group_response: std::option::Option<crate::model::RuleGroupResponse>,
    }
    impl Builder {
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p>
        /// <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_token = Some(input.into());
            self
        }
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p>
        /// <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.update_token = input;
            self
        }
        /// <p>The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>
        pub fn rule_group_response(mut self, input: crate::model::RuleGroupResponse) -> Self {
            self.rule_group_response = Some(input);
            self
        }
        /// <p>The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>
        pub fn set_rule_group_response(
            mut self,
            input: std::option::Option<crate::model::RuleGroupResponse>,
        ) -> Self {
            self.rule_group_response = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRuleGroupOutput`](crate::output::UpdateRuleGroupOutput)
        pub fn build(self) -> crate::output::UpdateRuleGroupOutput {
            crate::output::UpdateRuleGroupOutput {
                update_token: self.update_token,
                rule_group_response: self.rule_group_response,
            }
        }
    }
}
impl UpdateRuleGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRuleGroupOutput`](crate::output::UpdateRuleGroupOutput)
    pub fn builder() -> crate::output::update_rule_group_output::Builder {
        crate::output::update_rule_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLoggingConfigurationOutput {
    /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
    pub firewall_arn: std::option::Option<std::string::String>,
    /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    pub firewall_name: std::option::Option<std::string::String>,
    /// <p>Defines how AWS Network Firewall performs logging for a <a>Firewall</a>. </p>
    pub logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
}
impl std::fmt::Debug for UpdateLoggingConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLoggingConfigurationOutput");
        formatter.field("firewall_arn", &self.firewall_arn);
        formatter.field("firewall_name", &self.firewall_name);
        formatter.field("logging_configuration", &self.logging_configuration);
        formatter.finish()
    }
}
/// See [`UpdateLoggingConfigurationOutput`](crate::output::UpdateLoggingConfigurationOutput)
pub mod update_logging_configuration_output {
    /// A builder for [`UpdateLoggingConfigurationOutput`](crate::output::UpdateLoggingConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_arn: std::option::Option<std::string::String>,
        pub(crate) firewall_name: std::option::Option<std::string::String>,
        pub(crate) logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.firewall_arn = input;
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_name = Some(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_name = input;
            self
        }
        /// <p>Defines how AWS Network Firewall performs logging for a <a>Firewall</a>. </p>
        pub fn logging_configuration(mut self, input: crate::model::LoggingConfiguration) -> Self {
            self.logging_configuration = Some(input);
            self
        }
        /// <p>Defines how AWS Network Firewall performs logging for a <a>Firewall</a>. </p>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.logging_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLoggingConfigurationOutput`](crate::output::UpdateLoggingConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateLoggingConfigurationOutput {
            crate::output::UpdateLoggingConfigurationOutput {
                firewall_arn: self.firewall_arn,
                firewall_name: self.firewall_name,
                logging_configuration: self.logging_configuration,
            }
        }
    }
}
impl UpdateLoggingConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateLoggingConfigurationOutput`](crate::output::UpdateLoggingConfigurationOutput)
    pub fn builder() -> crate::output::update_logging_configuration_output::Builder {
        crate::output::update_logging_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFirewallPolicyChangeProtectionOutput {
    /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
    /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
    /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    pub update_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
    pub firewall_arn: std::option::Option<std::string::String>,
    /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    pub firewall_name: std::option::Option<std::string::String>,
    /// <p>A setting indicating whether the firewall is protected against a change to the firewall policy association.
    /// Use this setting to protect against
    /// accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
    pub firewall_policy_change_protection: bool,
}
impl std::fmt::Debug for UpdateFirewallPolicyChangeProtectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFirewallPolicyChangeProtectionOutput");
        formatter.field("update_token", &self.update_token);
        formatter.field("firewall_arn", &self.firewall_arn);
        formatter.field("firewall_name", &self.firewall_name);
        formatter.field(
            "firewall_policy_change_protection",
            &self.firewall_policy_change_protection,
        );
        formatter.finish()
    }
}
/// See [`UpdateFirewallPolicyChangeProtectionOutput`](crate::output::UpdateFirewallPolicyChangeProtectionOutput)
pub mod update_firewall_policy_change_protection_output {
    /// A builder for [`UpdateFirewallPolicyChangeProtectionOutput`](crate::output::UpdateFirewallPolicyChangeProtectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_token: std::option::Option<std::string::String>,
        pub(crate) firewall_arn: std::option::Option<std::string::String>,
        pub(crate) firewall_name: std::option::Option<std::string::String>,
        pub(crate) firewall_policy_change_protection: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_token = Some(input.into());
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.update_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.firewall_arn = input;
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_name = Some(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_name = input;
            self
        }
        /// <p>A setting indicating whether the firewall is protected against a change to the firewall policy association.
        /// Use this setting to protect against
        /// accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn firewall_policy_change_protection(mut self, input: bool) -> Self {
            self.firewall_policy_change_protection = Some(input);
            self
        }
        /// <p>A setting indicating whether the firewall is protected against a change to the firewall policy association.
        /// Use this setting to protect against
        /// accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>
        pub fn set_firewall_policy_change_protection(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.firewall_policy_change_protection = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFirewallPolicyChangeProtectionOutput`](crate::output::UpdateFirewallPolicyChangeProtectionOutput)
        pub fn build(self) -> crate::output::UpdateFirewallPolicyChangeProtectionOutput {
            crate::output::UpdateFirewallPolicyChangeProtectionOutput {
                update_token: self.update_token,
                firewall_arn: self.firewall_arn,
                firewall_name: self.firewall_name,
                firewall_policy_change_protection: self
                    .firewall_policy_change_protection
                    .unwrap_or_default(),
            }
        }
    }
}
impl UpdateFirewallPolicyChangeProtectionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFirewallPolicyChangeProtectionOutput`](crate::output::UpdateFirewallPolicyChangeProtectionOutput)
    pub fn builder() -> crate::output::update_firewall_policy_change_protection_output::Builder {
        crate::output::update_firewall_policy_change_protection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFirewallPolicyOutput {
    /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p>
    /// <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>
    pub update_token: std::option::Option<std::string::String>,
    /// <p>The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>. </p>
    pub firewall_policy_response: std::option::Option<crate::model::FirewallPolicyResponse>,
}
impl std::fmt::Debug for UpdateFirewallPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFirewallPolicyOutput");
        formatter.field("update_token", &self.update_token);
        formatter.field("firewall_policy_response", &self.firewall_policy_response);
        formatter.finish()
    }
}
/// See [`UpdateFirewallPolicyOutput`](crate::output::UpdateFirewallPolicyOutput)
pub mod update_firewall_policy_output {
    /// A builder for [`UpdateFirewallPolicyOutput`](crate::output::UpdateFirewallPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_token: std::option::Option<std::string::String>,
        pub(crate) firewall_policy_response:
            std::option::Option<crate::model::FirewallPolicyResponse>,
    }
    impl Builder {
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p>
        /// <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_token = Some(input.into());
            self
        }
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p>
        /// <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.update_token = input;
            self
        }
        /// <p>The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>. </p>
        pub fn firewall_policy_response(
            mut self,
            input: crate::model::FirewallPolicyResponse,
        ) -> Self {
            self.firewall_policy_response = Some(input);
            self
        }
        /// <p>The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>. </p>
        pub fn set_firewall_policy_response(
            mut self,
            input: std::option::Option<crate::model::FirewallPolicyResponse>,
        ) -> Self {
            self.firewall_policy_response = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFirewallPolicyOutput`](crate::output::UpdateFirewallPolicyOutput)
        pub fn build(self) -> crate::output::UpdateFirewallPolicyOutput {
            crate::output::UpdateFirewallPolicyOutput {
                update_token: self.update_token,
                firewall_policy_response: self.firewall_policy_response,
            }
        }
    }
}
impl UpdateFirewallPolicyOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFirewallPolicyOutput`](crate::output::UpdateFirewallPolicyOutput)
    pub fn builder() -> crate::output::update_firewall_policy_output::Builder {
        crate::output::update_firewall_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFirewallDescriptionOutput {
    /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
    pub firewall_arn: std::option::Option<std::string::String>,
    /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    pub firewall_name: std::option::Option<std::string::String>,
    /// <p>A description of the firewall.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
    /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
    /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    pub update_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateFirewallDescriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFirewallDescriptionOutput");
        formatter.field("firewall_arn", &self.firewall_arn);
        formatter.field("firewall_name", &self.firewall_name);
        formatter.field("description", &self.description);
        formatter.field("update_token", &self.update_token);
        formatter.finish()
    }
}
/// See [`UpdateFirewallDescriptionOutput`](crate::output::UpdateFirewallDescriptionOutput)
pub mod update_firewall_description_output {
    /// A builder for [`UpdateFirewallDescriptionOutput`](crate::output::UpdateFirewallDescriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_arn: std::option::Option<std::string::String>,
        pub(crate) firewall_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) update_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.firewall_arn = input;
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_name = Some(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_name = input;
            self
        }
        /// <p>A description of the firewall.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the firewall.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_token = Some(input.into());
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.update_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFirewallDescriptionOutput`](crate::output::UpdateFirewallDescriptionOutput)
        pub fn build(self) -> crate::output::UpdateFirewallDescriptionOutput {
            crate::output::UpdateFirewallDescriptionOutput {
                firewall_arn: self.firewall_arn,
                firewall_name: self.firewall_name,
                description: self.description,
                update_token: self.update_token,
            }
        }
    }
}
impl UpdateFirewallDescriptionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFirewallDescriptionOutput`](crate::output::UpdateFirewallDescriptionOutput)
    pub fn builder() -> crate::output::update_firewall_description_output::Builder {
        crate::output::update_firewall_description_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFirewallDeleteProtectionOutput {
    /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
    pub firewall_arn: std::option::Option<std::string::String>,
    /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    pub firewall_name: std::option::Option<std::string::String>,
    /// <p></p>
    pub delete_protection: bool,
    /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
    /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
    /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    pub update_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateFirewallDeleteProtectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFirewallDeleteProtectionOutput");
        formatter.field("firewall_arn", &self.firewall_arn);
        formatter.field("firewall_name", &self.firewall_name);
        formatter.field("delete_protection", &self.delete_protection);
        formatter.field("update_token", &self.update_token);
        formatter.finish()
    }
}
/// See [`UpdateFirewallDeleteProtectionOutput`](crate::output::UpdateFirewallDeleteProtectionOutput)
pub mod update_firewall_delete_protection_output {
    /// A builder for [`UpdateFirewallDeleteProtectionOutput`](crate::output::UpdateFirewallDeleteProtectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_arn: std::option::Option<std::string::String>,
        pub(crate) firewall_name: std::option::Option<std::string::String>,
        pub(crate) delete_protection: std::option::Option<bool>,
        pub(crate) update_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.firewall_arn = input;
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_name = Some(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_name = input;
            self
        }
        /// <p></p>
        pub fn delete_protection(mut self, input: bool) -> Self {
            self.delete_protection = Some(input);
            self
        }
        /// <p></p>
        pub fn set_delete_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_protection = input;
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_token = Some(input.into());
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.update_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFirewallDeleteProtectionOutput`](crate::output::UpdateFirewallDeleteProtectionOutput)
        pub fn build(self) -> crate::output::UpdateFirewallDeleteProtectionOutput {
            crate::output::UpdateFirewallDeleteProtectionOutput {
                firewall_arn: self.firewall_arn,
                firewall_name: self.firewall_name,
                delete_protection: self.delete_protection.unwrap_or_default(),
                update_token: self.update_token,
            }
        }
    }
}
impl UpdateFirewallDeleteProtectionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFirewallDeleteProtectionOutput`](crate::output::UpdateFirewallDeleteProtectionOutput)
    pub fn builder() -> crate::output::update_firewall_delete_protection_output::Builder {
        crate::output::update_firewall_delete_protection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutResourcePolicyOutput {}
impl std::fmt::Debug for PutResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutResourcePolicyOutput");
        formatter.finish()
    }
}
/// See [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
pub mod put_resource_policy_output {
    /// A builder for [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
        pub fn build(self) -> crate::output::PutResourcePolicyOutput {
            crate::output::PutResourcePolicyOutput {}
        }
    }
}
impl PutResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
    pub fn builder() -> crate::output::put_resource_policy_output::Builder {
        crate::output::put_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
    /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
    /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The tags that are associated with the resource. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
        /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
        /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
        /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
        /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that are associated with the resource. </p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags that are associated with the resource. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                next_token: self.next_token,
                tags: self.tags,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRuleGroupsOutput {
    /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
    /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
    /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The rule group metadata objects that you've defined. Depending on your setting for max
    /// results and the number of rule groups, this might not be the full list. </p>
    pub rule_groups: std::option::Option<std::vec::Vec<crate::model::RuleGroupMetadata>>,
}
impl std::fmt::Debug for ListRuleGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRuleGroupsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("rule_groups", &self.rule_groups);
        formatter.finish()
    }
}
/// See [`ListRuleGroupsOutput`](crate::output::ListRuleGroupsOutput)
pub mod list_rule_groups_output {
    /// A builder for [`ListRuleGroupsOutput`](crate::output::ListRuleGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) rule_groups: std::option::Option<std::vec::Vec<crate::model::RuleGroupMetadata>>,
    }
    impl Builder {
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
        /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
        /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
        /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
        /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `rule_groups`.
        ///
        /// To override the contents of this collection use [`set_rule_groups`](Self::set_rule_groups).
        ///
        /// <p>The rule group metadata objects that you've defined. Depending on your setting for max
        /// results and the number of rule groups, this might not be the full list. </p>
        pub fn rule_groups(mut self, input: impl Into<crate::model::RuleGroupMetadata>) -> Self {
            let mut v = self.rule_groups.unwrap_or_default();
            v.push(input.into());
            self.rule_groups = Some(v);
            self
        }
        /// <p>The rule group metadata objects that you've defined. Depending on your setting for max
        /// results and the number of rule groups, this might not be the full list. </p>
        pub fn set_rule_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleGroupMetadata>>,
        ) -> Self {
            self.rule_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRuleGroupsOutput`](crate::output::ListRuleGroupsOutput)
        pub fn build(self) -> crate::output::ListRuleGroupsOutput {
            crate::output::ListRuleGroupsOutput {
                next_token: self.next_token,
                rule_groups: self.rule_groups,
            }
        }
    }
}
impl ListRuleGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListRuleGroupsOutput`](crate::output::ListRuleGroupsOutput)
    pub fn builder() -> crate::output::list_rule_groups_output::Builder {
        crate::output::list_rule_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFirewallsOutput {
    /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
    /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
    /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The firewall metadata objects for the VPCs that you specified. Depending on your setting
    /// for max results and the number of firewalls you have, a single call might not be the full
    /// list. </p>
    pub firewalls: std::option::Option<std::vec::Vec<crate::model::FirewallMetadata>>,
}
impl std::fmt::Debug for ListFirewallsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFirewallsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("firewalls", &self.firewalls);
        formatter.finish()
    }
}
/// See [`ListFirewallsOutput`](crate::output::ListFirewallsOutput)
pub mod list_firewalls_output {
    /// A builder for [`ListFirewallsOutput`](crate::output::ListFirewallsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) firewalls: std::option::Option<std::vec::Vec<crate::model::FirewallMetadata>>,
    }
    impl Builder {
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
        /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
        /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
        /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
        /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `firewalls`.
        ///
        /// To override the contents of this collection use [`set_firewalls`](Self::set_firewalls).
        ///
        /// <p>The firewall metadata objects for the VPCs that you specified. Depending on your setting
        /// for max results and the number of firewalls you have, a single call might not be the full
        /// list. </p>
        pub fn firewalls(mut self, input: impl Into<crate::model::FirewallMetadata>) -> Self {
            let mut v = self.firewalls.unwrap_or_default();
            v.push(input.into());
            self.firewalls = Some(v);
            self
        }
        /// <p>The firewall metadata objects for the VPCs that you specified. Depending on your setting
        /// for max results and the number of firewalls you have, a single call might not be the full
        /// list. </p>
        pub fn set_firewalls(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FirewallMetadata>>,
        ) -> Self {
            self.firewalls = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFirewallsOutput`](crate::output::ListFirewallsOutput)
        pub fn build(self) -> crate::output::ListFirewallsOutput {
            crate::output::ListFirewallsOutput {
                next_token: self.next_token,
                firewalls: self.firewalls,
            }
        }
    }
}
impl ListFirewallsOutput {
    /// Creates a new builder-style object to manufacture [`ListFirewallsOutput`](crate::output::ListFirewallsOutput)
    pub fn builder() -> crate::output::list_firewalls_output::Builder {
        crate::output::list_firewalls_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFirewallPoliciesOutput {
    /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
    /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
    /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The metadata for the firewall policies. Depending on your setting for max results and
    /// the number of firewall policies that you have, this might not be the full list. </p>
    pub firewall_policies: std::option::Option<std::vec::Vec<crate::model::FirewallPolicyMetadata>>,
}
impl std::fmt::Debug for ListFirewallPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFirewallPoliciesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("firewall_policies", &self.firewall_policies);
        formatter.finish()
    }
}
/// See [`ListFirewallPoliciesOutput`](crate::output::ListFirewallPoliciesOutput)
pub mod list_firewall_policies_output {
    /// A builder for [`ListFirewallPoliciesOutput`](crate::output::ListFirewallPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) firewall_policies:
            std::option::Option<std::vec::Vec<crate::model::FirewallPolicyMetadata>>,
    }
    impl Builder {
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
        /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
        /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available
        /// for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code>
        /// value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `firewall_policies`.
        ///
        /// To override the contents of this collection use [`set_firewall_policies`](Self::set_firewall_policies).
        ///
        /// <p>The metadata for the firewall policies. Depending on your setting for max results and
        /// the number of firewall policies that you have, this might not be the full list. </p>
        pub fn firewall_policies(
            mut self,
            input: impl Into<crate::model::FirewallPolicyMetadata>,
        ) -> Self {
            let mut v = self.firewall_policies.unwrap_or_default();
            v.push(input.into());
            self.firewall_policies = Some(v);
            self
        }
        /// <p>The metadata for the firewall policies. Depending on your setting for max results and
        /// the number of firewall policies that you have, this might not be the full list. </p>
        pub fn set_firewall_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FirewallPolicyMetadata>>,
        ) -> Self {
            self.firewall_policies = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFirewallPoliciesOutput`](crate::output::ListFirewallPoliciesOutput)
        pub fn build(self) -> crate::output::ListFirewallPoliciesOutput {
            crate::output::ListFirewallPoliciesOutput {
                next_token: self.next_token,
                firewall_policies: self.firewall_policies,
            }
        }
    }
}
impl ListFirewallPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListFirewallPoliciesOutput`](crate::output::ListFirewallPoliciesOutput)
    pub fn builder() -> crate::output::list_firewall_policies_output::Builder {
        crate::output::list_firewall_policies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateSubnetsOutput {
    /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
    pub firewall_arn: std::option::Option<std::string::String>,
    /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    pub firewall_name: std::option::Option<std::string::String>,
    /// <p>The IDs of the subnets that are associated with the firewall. </p>
    pub subnet_mappings: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
    /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
    /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
    /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    pub update_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisassociateSubnetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateSubnetsOutput");
        formatter.field("firewall_arn", &self.firewall_arn);
        formatter.field("firewall_name", &self.firewall_name);
        formatter.field("subnet_mappings", &self.subnet_mappings);
        formatter.field("update_token", &self.update_token);
        formatter.finish()
    }
}
/// See [`DisassociateSubnetsOutput`](crate::output::DisassociateSubnetsOutput)
pub mod disassociate_subnets_output {
    /// A builder for [`DisassociateSubnetsOutput`](crate::output::DisassociateSubnetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_arn: std::option::Option<std::string::String>,
        pub(crate) firewall_name: std::option::Option<std::string::String>,
        pub(crate) subnet_mappings: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
        pub(crate) update_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.firewall_arn = input;
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_name = Some(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_name = input;
            self
        }
        /// Appends an item to `subnet_mappings`.
        ///
        /// To override the contents of this collection use [`set_subnet_mappings`](Self::set_subnet_mappings).
        ///
        /// <p>The IDs of the subnets that are associated with the firewall. </p>
        pub fn subnet_mappings(mut self, input: impl Into<crate::model::SubnetMapping>) -> Self {
            let mut v = self.subnet_mappings.unwrap_or_default();
            v.push(input.into());
            self.subnet_mappings = Some(v);
            self
        }
        /// <p>The IDs of the subnets that are associated with the firewall. </p>
        pub fn set_subnet_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
        ) -> Self {
            self.subnet_mappings = input;
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_token = Some(input.into());
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.update_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateSubnetsOutput`](crate::output::DisassociateSubnetsOutput)
        pub fn build(self) -> crate::output::DisassociateSubnetsOutput {
            crate::output::DisassociateSubnetsOutput {
                firewall_arn: self.firewall_arn,
                firewall_name: self.firewall_name,
                subnet_mappings: self.subnet_mappings,
                update_token: self.update_token,
            }
        }
    }
}
impl DisassociateSubnetsOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateSubnetsOutput`](crate::output::DisassociateSubnetsOutput)
    pub fn builder() -> crate::output::disassociate_subnets_output::Builder {
        crate::output::disassociate_subnets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRuleGroupOutput {
    /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p>
    /// <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>
    pub update_token: std::option::Option<std::string::String>,
    /// <p>The object that defines the rules in a rule group. This, along with <a>RuleGroupResponse</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>
    /// <p>AWS Network Firewall uses a rule group to inspect and control network traffic.
    /// You define stateless rule groups to inspect individual packets and you define stateful rule groups to inspect packets in the context of their
    /// traffic flow. </p>
    /// <p>To use a rule group, you include it by reference in an Network Firewall firewall policy, then you use the policy in a firewall. You can reference a rule group from
    /// more than one firewall policy, and you can use a firewall policy in more than one firewall. </p>
    pub rule_group: std::option::Option<crate::model::RuleGroup>,
    /// <p>The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>
    pub rule_group_response: std::option::Option<crate::model::RuleGroupResponse>,
}
impl std::fmt::Debug for DescribeRuleGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRuleGroupOutput");
        formatter.field("update_token", &self.update_token);
        formatter.field("rule_group", &self.rule_group);
        formatter.field("rule_group_response", &self.rule_group_response);
        formatter.finish()
    }
}
/// See [`DescribeRuleGroupOutput`](crate::output::DescribeRuleGroupOutput)
pub mod describe_rule_group_output {
    /// A builder for [`DescribeRuleGroupOutput`](crate::output::DescribeRuleGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_token: std::option::Option<std::string::String>,
        pub(crate) rule_group: std::option::Option<crate::model::RuleGroup>,
        pub(crate) rule_group_response: std::option::Option<crate::model::RuleGroupResponse>,
    }
    impl Builder {
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p>
        /// <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_token = Some(input.into());
            self
        }
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p>
        /// <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.update_token = input;
            self
        }
        /// <p>The object that defines the rules in a rule group. This, along with <a>RuleGroupResponse</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>
        /// <p>AWS Network Firewall uses a rule group to inspect and control network traffic.
        /// You define stateless rule groups to inspect individual packets and you define stateful rule groups to inspect packets in the context of their
        /// traffic flow. </p>
        /// <p>To use a rule group, you include it by reference in an Network Firewall firewall policy, then you use the policy in a firewall. You can reference a rule group from
        /// more than one firewall policy, and you can use a firewall policy in more than one firewall. </p>
        pub fn rule_group(mut self, input: crate::model::RuleGroup) -> Self {
            self.rule_group = Some(input);
            self
        }
        /// <p>The object that defines the rules in a rule group. This, along with <a>RuleGroupResponse</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>
        /// <p>AWS Network Firewall uses a rule group to inspect and control network traffic.
        /// You define stateless rule groups to inspect individual packets and you define stateful rule groups to inspect packets in the context of their
        /// traffic flow. </p>
        /// <p>To use a rule group, you include it by reference in an Network Firewall firewall policy, then you use the policy in a firewall. You can reference a rule group from
        /// more than one firewall policy, and you can use a firewall policy in more than one firewall. </p>
        pub fn set_rule_group(
            mut self,
            input: std::option::Option<crate::model::RuleGroup>,
        ) -> Self {
            self.rule_group = input;
            self
        }
        /// <p>The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>
        pub fn rule_group_response(mut self, input: crate::model::RuleGroupResponse) -> Self {
            self.rule_group_response = Some(input);
            self
        }
        /// <p>The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>
        pub fn set_rule_group_response(
            mut self,
            input: std::option::Option<crate::model::RuleGroupResponse>,
        ) -> Self {
            self.rule_group_response = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRuleGroupOutput`](crate::output::DescribeRuleGroupOutput)
        pub fn build(self) -> crate::output::DescribeRuleGroupOutput {
            crate::output::DescribeRuleGroupOutput {
                update_token: self.update_token,
                rule_group: self.rule_group,
                rule_group_response: self.rule_group_response,
            }
        }
    }
}
impl DescribeRuleGroupOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRuleGroupOutput`](crate::output::DescribeRuleGroupOutput)
    pub fn builder() -> crate::output::describe_rule_group_output::Builder {
        crate::output::describe_rule_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeResourcePolicyOutput {
    /// <p>The AWS Identity and Access Management policy for the resource. </p>
    pub policy: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeResourcePolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`DescribeResourcePolicyOutput`](crate::output::DescribeResourcePolicyOutput)
pub mod describe_resource_policy_output {
    /// A builder for [`DescribeResourcePolicyOutput`](crate::output::DescribeResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS Identity and Access Management policy for the resource. </p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The AWS Identity and Access Management policy for the resource. </p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeResourcePolicyOutput`](crate::output::DescribeResourcePolicyOutput)
        pub fn build(self) -> crate::output::DescribeResourcePolicyOutput {
            crate::output::DescribeResourcePolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl DescribeResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DescribeResourcePolicyOutput`](crate::output::DescribeResourcePolicyOutput)
    pub fn builder() -> crate::output::describe_resource_policy_output::Builder {
        crate::output::describe_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLoggingConfigurationOutput {
    /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
    pub firewall_arn: std::option::Option<std::string::String>,
    /// <p>Defines how AWS Network Firewall performs logging for a <a>Firewall</a>. </p>
    pub logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
}
impl std::fmt::Debug for DescribeLoggingConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLoggingConfigurationOutput");
        formatter.field("firewall_arn", &self.firewall_arn);
        formatter.field("logging_configuration", &self.logging_configuration);
        formatter.finish()
    }
}
/// See [`DescribeLoggingConfigurationOutput`](crate::output::DescribeLoggingConfigurationOutput)
pub mod describe_logging_configuration_output {
    /// A builder for [`DescribeLoggingConfigurationOutput`](crate::output::DescribeLoggingConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_arn: std::option::Option<std::string::String>,
        pub(crate) logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.firewall_arn = input;
            self
        }
        /// <p>Defines how AWS Network Firewall performs logging for a <a>Firewall</a>. </p>
        pub fn logging_configuration(mut self, input: crate::model::LoggingConfiguration) -> Self {
            self.logging_configuration = Some(input);
            self
        }
        /// <p>Defines how AWS Network Firewall performs logging for a <a>Firewall</a>. </p>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.logging_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLoggingConfigurationOutput`](crate::output::DescribeLoggingConfigurationOutput)
        pub fn build(self) -> crate::output::DescribeLoggingConfigurationOutput {
            crate::output::DescribeLoggingConfigurationOutput {
                firewall_arn: self.firewall_arn,
                logging_configuration: self.logging_configuration,
            }
        }
    }
}
impl DescribeLoggingConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLoggingConfigurationOutput`](crate::output::DescribeLoggingConfigurationOutput)
    pub fn builder() -> crate::output::describe_logging_configuration_output::Builder {
        crate::output::describe_logging_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFirewallPolicyOutput {
    /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p>
    /// <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>
    pub update_token: std::option::Option<std::string::String>,
    /// <p>The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>. </p>
    pub firewall_policy_response: std::option::Option<crate::model::FirewallPolicyResponse>,
    /// <p>The policy for the specified firewall policy. </p>
    pub firewall_policy: std::option::Option<crate::model::FirewallPolicy>,
}
impl std::fmt::Debug for DescribeFirewallPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFirewallPolicyOutput");
        formatter.field("update_token", &self.update_token);
        formatter.field("firewall_policy_response", &self.firewall_policy_response);
        formatter.field("firewall_policy", &self.firewall_policy);
        formatter.finish()
    }
}
/// See [`DescribeFirewallPolicyOutput`](crate::output::DescribeFirewallPolicyOutput)
pub mod describe_firewall_policy_output {
    /// A builder for [`DescribeFirewallPolicyOutput`](crate::output::DescribeFirewallPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_token: std::option::Option<std::string::String>,
        pub(crate) firewall_policy_response:
            std::option::Option<crate::model::FirewallPolicyResponse>,
        pub(crate) firewall_policy: std::option::Option<crate::model::FirewallPolicy>,
    }
    impl Builder {
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p>
        /// <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_token = Some(input.into());
            self
        }
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p>
        /// <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.update_token = input;
            self
        }
        /// <p>The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>. </p>
        pub fn firewall_policy_response(
            mut self,
            input: crate::model::FirewallPolicyResponse,
        ) -> Self {
            self.firewall_policy_response = Some(input);
            self
        }
        /// <p>The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>. </p>
        pub fn set_firewall_policy_response(
            mut self,
            input: std::option::Option<crate::model::FirewallPolicyResponse>,
        ) -> Self {
            self.firewall_policy_response = input;
            self
        }
        /// <p>The policy for the specified firewall policy. </p>
        pub fn firewall_policy(mut self, input: crate::model::FirewallPolicy) -> Self {
            self.firewall_policy = Some(input);
            self
        }
        /// <p>The policy for the specified firewall policy. </p>
        pub fn set_firewall_policy(
            mut self,
            input: std::option::Option<crate::model::FirewallPolicy>,
        ) -> Self {
            self.firewall_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFirewallPolicyOutput`](crate::output::DescribeFirewallPolicyOutput)
        pub fn build(self) -> crate::output::DescribeFirewallPolicyOutput {
            crate::output::DescribeFirewallPolicyOutput {
                update_token: self.update_token,
                firewall_policy_response: self.firewall_policy_response,
                firewall_policy: self.firewall_policy,
            }
        }
    }
}
impl DescribeFirewallPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFirewallPolicyOutput`](crate::output::DescribeFirewallPolicyOutput)
    pub fn builder() -> crate::output::describe_firewall_policy_output::Builder {
        crate::output::describe_firewall_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFirewallOutput {
    /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
    /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
    /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    pub update_token: std::option::Option<std::string::String>,
    /// <p>The configuration settings for the firewall. These settings include the firewall policy and the subnets in your VPC to use for the firewall endpoints. </p>
    pub firewall: std::option::Option<crate::model::Firewall>,
    /// <p>Detailed information about the current status of a <a>Firewall</a>. You can retrieve this for a firewall by calling <a>DescribeFirewall</a> and providing the firewall name and ARN.</p>
    pub firewall_status: std::option::Option<crate::model::FirewallStatus>,
}
impl std::fmt::Debug for DescribeFirewallOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFirewallOutput");
        formatter.field("update_token", &self.update_token);
        formatter.field("firewall", &self.firewall);
        formatter.field("firewall_status", &self.firewall_status);
        formatter.finish()
    }
}
/// See [`DescribeFirewallOutput`](crate::output::DescribeFirewallOutput)
pub mod describe_firewall_output {
    /// A builder for [`DescribeFirewallOutput`](crate::output::DescribeFirewallOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_token: std::option::Option<std::string::String>,
        pub(crate) firewall: std::option::Option<crate::model::Firewall>,
        pub(crate) firewall_status: std::option::Option<crate::model::FirewallStatus>,
    }
    impl Builder {
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_token = Some(input.into());
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.update_token = input;
            self
        }
        /// <p>The configuration settings for the firewall. These settings include the firewall policy and the subnets in your VPC to use for the firewall endpoints. </p>
        pub fn firewall(mut self, input: crate::model::Firewall) -> Self {
            self.firewall = Some(input);
            self
        }
        /// <p>The configuration settings for the firewall. These settings include the firewall policy and the subnets in your VPC to use for the firewall endpoints. </p>
        pub fn set_firewall(mut self, input: std::option::Option<crate::model::Firewall>) -> Self {
            self.firewall = input;
            self
        }
        /// <p>Detailed information about the current status of a <a>Firewall</a>. You can retrieve this for a firewall by calling <a>DescribeFirewall</a> and providing the firewall name and ARN.</p>
        pub fn firewall_status(mut self, input: crate::model::FirewallStatus) -> Self {
            self.firewall_status = Some(input);
            self
        }
        /// <p>Detailed information about the current status of a <a>Firewall</a>. You can retrieve this for a firewall by calling <a>DescribeFirewall</a> and providing the firewall name and ARN.</p>
        pub fn set_firewall_status(
            mut self,
            input: std::option::Option<crate::model::FirewallStatus>,
        ) -> Self {
            self.firewall_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFirewallOutput`](crate::output::DescribeFirewallOutput)
        pub fn build(self) -> crate::output::DescribeFirewallOutput {
            crate::output::DescribeFirewallOutput {
                update_token: self.update_token,
                firewall: self.firewall,
                firewall_status: self.firewall_status,
            }
        }
    }
}
impl DescribeFirewallOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFirewallOutput`](crate::output::DescribeFirewallOutput)
    pub fn builder() -> crate::output::describe_firewall_output::Builder {
        crate::output::describe_firewall_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRuleGroupOutput {
    /// <p>The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>
    pub rule_group_response: std::option::Option<crate::model::RuleGroupResponse>,
}
impl std::fmt::Debug for DeleteRuleGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRuleGroupOutput");
        formatter.field("rule_group_response", &self.rule_group_response);
        formatter.finish()
    }
}
/// See [`DeleteRuleGroupOutput`](crate::output::DeleteRuleGroupOutput)
pub mod delete_rule_group_output {
    /// A builder for [`DeleteRuleGroupOutput`](crate::output::DeleteRuleGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_group_response: std::option::Option<crate::model::RuleGroupResponse>,
    }
    impl Builder {
        /// <p>The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>
        pub fn rule_group_response(mut self, input: crate::model::RuleGroupResponse) -> Self {
            self.rule_group_response = Some(input);
            self
        }
        /// <p>The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>
        pub fn set_rule_group_response(
            mut self,
            input: std::option::Option<crate::model::RuleGroupResponse>,
        ) -> Self {
            self.rule_group_response = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRuleGroupOutput`](crate::output::DeleteRuleGroupOutput)
        pub fn build(self) -> crate::output::DeleteRuleGroupOutput {
            crate::output::DeleteRuleGroupOutput {
                rule_group_response: self.rule_group_response,
            }
        }
    }
}
impl DeleteRuleGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRuleGroupOutput`](crate::output::DeleteRuleGroupOutput)
    pub fn builder() -> crate::output::delete_rule_group_output::Builder {
        crate::output::delete_rule_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourcePolicyOutput {}
impl std::fmt::Debug for DeleteResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourcePolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
pub mod delete_resource_policy_output {
    /// A builder for [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
        pub fn build(self) -> crate::output::DeleteResourcePolicyOutput {
            crate::output::DeleteResourcePolicyOutput {}
        }
    }
}
impl DeleteResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
    pub fn builder() -> crate::output::delete_resource_policy_output::Builder {
        crate::output::delete_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFirewallPolicyOutput {
    /// <p>The object containing the definition of the <a>FirewallPolicyResponse</a>
    /// that you asked to delete. </p>
    pub firewall_policy_response: std::option::Option<crate::model::FirewallPolicyResponse>,
}
impl std::fmt::Debug for DeleteFirewallPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFirewallPolicyOutput");
        formatter.field("firewall_policy_response", &self.firewall_policy_response);
        formatter.finish()
    }
}
/// See [`DeleteFirewallPolicyOutput`](crate::output::DeleteFirewallPolicyOutput)
pub mod delete_firewall_policy_output {
    /// A builder for [`DeleteFirewallPolicyOutput`](crate::output::DeleteFirewallPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_policy_response:
            std::option::Option<crate::model::FirewallPolicyResponse>,
    }
    impl Builder {
        /// <p>The object containing the definition of the <a>FirewallPolicyResponse</a>
        /// that you asked to delete. </p>
        pub fn firewall_policy_response(
            mut self,
            input: crate::model::FirewallPolicyResponse,
        ) -> Self {
            self.firewall_policy_response = Some(input);
            self
        }
        /// <p>The object containing the definition of the <a>FirewallPolicyResponse</a>
        /// that you asked to delete. </p>
        pub fn set_firewall_policy_response(
            mut self,
            input: std::option::Option<crate::model::FirewallPolicyResponse>,
        ) -> Self {
            self.firewall_policy_response = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFirewallPolicyOutput`](crate::output::DeleteFirewallPolicyOutput)
        pub fn build(self) -> crate::output::DeleteFirewallPolicyOutput {
            crate::output::DeleteFirewallPolicyOutput {
                firewall_policy_response: self.firewall_policy_response,
            }
        }
    }
}
impl DeleteFirewallPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFirewallPolicyOutput`](crate::output::DeleteFirewallPolicyOutput)
    pub fn builder() -> crate::output::delete_firewall_policy_output::Builder {
        crate::output::delete_firewall_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFirewallOutput {
    /// <p>The firewall defines the configuration settings for an AWS Network Firewall firewall. These settings include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and any tags that are attached to the firewall AWS resource. </p>
    /// <p>The status of the firewall, for example whether it's ready to filter network traffic,
    /// is provided in the corresponding <a>FirewallStatus</a>. You can retrieve both
    /// objects by calling <a>DescribeFirewall</a>.</p>
    pub firewall: std::option::Option<crate::model::Firewall>,
    /// <p>Detailed information about the current status of a <a>Firewall</a>. You can retrieve this for a firewall by calling <a>DescribeFirewall</a> and providing the firewall name and ARN.</p>
    pub firewall_status: std::option::Option<crate::model::FirewallStatus>,
}
impl std::fmt::Debug for DeleteFirewallOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFirewallOutput");
        formatter.field("firewall", &self.firewall);
        formatter.field("firewall_status", &self.firewall_status);
        formatter.finish()
    }
}
/// See [`DeleteFirewallOutput`](crate::output::DeleteFirewallOutput)
pub mod delete_firewall_output {
    /// A builder for [`DeleteFirewallOutput`](crate::output::DeleteFirewallOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall: std::option::Option<crate::model::Firewall>,
        pub(crate) firewall_status: std::option::Option<crate::model::FirewallStatus>,
    }
    impl Builder {
        /// <p>The firewall defines the configuration settings for an AWS Network Firewall firewall. These settings include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and any tags that are attached to the firewall AWS resource. </p>
        /// <p>The status of the firewall, for example whether it's ready to filter network traffic,
        /// is provided in the corresponding <a>FirewallStatus</a>. You can retrieve both
        /// objects by calling <a>DescribeFirewall</a>.</p>
        pub fn firewall(mut self, input: crate::model::Firewall) -> Self {
            self.firewall = Some(input);
            self
        }
        /// <p>The firewall defines the configuration settings for an AWS Network Firewall firewall. These settings include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and any tags that are attached to the firewall AWS resource. </p>
        /// <p>The status of the firewall, for example whether it's ready to filter network traffic,
        /// is provided in the corresponding <a>FirewallStatus</a>. You can retrieve both
        /// objects by calling <a>DescribeFirewall</a>.</p>
        pub fn set_firewall(mut self, input: std::option::Option<crate::model::Firewall>) -> Self {
            self.firewall = input;
            self
        }
        /// <p>Detailed information about the current status of a <a>Firewall</a>. You can retrieve this for a firewall by calling <a>DescribeFirewall</a> and providing the firewall name and ARN.</p>
        pub fn firewall_status(mut self, input: crate::model::FirewallStatus) -> Self {
            self.firewall_status = Some(input);
            self
        }
        /// <p>Detailed information about the current status of a <a>Firewall</a>. You can retrieve this for a firewall by calling <a>DescribeFirewall</a> and providing the firewall name and ARN.</p>
        pub fn set_firewall_status(
            mut self,
            input: std::option::Option<crate::model::FirewallStatus>,
        ) -> Self {
            self.firewall_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFirewallOutput`](crate::output::DeleteFirewallOutput)
        pub fn build(self) -> crate::output::DeleteFirewallOutput {
            crate::output::DeleteFirewallOutput {
                firewall: self.firewall,
                firewall_status: self.firewall_status,
            }
        }
    }
}
impl DeleteFirewallOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFirewallOutput`](crate::output::DeleteFirewallOutput)
    pub fn builder() -> crate::output::delete_firewall_output::Builder {
        crate::output::delete_firewall_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRuleGroupOutput {
    /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p>
    /// <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>
    pub update_token: std::option::Option<std::string::String>,
    /// <p>The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>
    pub rule_group_response: std::option::Option<crate::model::RuleGroupResponse>,
}
impl std::fmt::Debug for CreateRuleGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRuleGroupOutput");
        formatter.field("update_token", &self.update_token);
        formatter.field("rule_group_response", &self.rule_group_response);
        formatter.finish()
    }
}
/// See [`CreateRuleGroupOutput`](crate::output::CreateRuleGroupOutput)
pub mod create_rule_group_output {
    /// A builder for [`CreateRuleGroupOutput`](crate::output::CreateRuleGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_token: std::option::Option<std::string::String>,
        pub(crate) rule_group_response: std::option::Option<crate::model::RuleGroupResponse>,
    }
    impl Builder {
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p>
        /// <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_token = Some(input.into());
            self
        }
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p>
        /// <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.update_token = input;
            self
        }
        /// <p>The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>
        pub fn rule_group_response(mut self, input: crate::model::RuleGroupResponse) -> Self {
            self.rule_group_response = Some(input);
            self
        }
        /// <p>The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>
        pub fn set_rule_group_response(
            mut self,
            input: std::option::Option<crate::model::RuleGroupResponse>,
        ) -> Self {
            self.rule_group_response = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRuleGroupOutput`](crate::output::CreateRuleGroupOutput)
        pub fn build(self) -> crate::output::CreateRuleGroupOutput {
            crate::output::CreateRuleGroupOutput {
                update_token: self.update_token,
                rule_group_response: self.rule_group_response,
            }
        }
    }
}
impl CreateRuleGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateRuleGroupOutput`](crate::output::CreateRuleGroupOutput)
    pub fn builder() -> crate::output::create_rule_group_output::Builder {
        crate::output::create_rule_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFirewallPolicyOutput {
    /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p>
    /// <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>
    pub update_token: std::option::Option<std::string::String>,
    /// <p>The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>. </p>
    pub firewall_policy_response: std::option::Option<crate::model::FirewallPolicyResponse>,
}
impl std::fmt::Debug for CreateFirewallPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFirewallPolicyOutput");
        formatter.field("update_token", &self.update_token);
        formatter.field("firewall_policy_response", &self.firewall_policy_response);
        formatter.finish()
    }
}
/// See [`CreateFirewallPolicyOutput`](crate::output::CreateFirewallPolicyOutput)
pub mod create_firewall_policy_output {
    /// A builder for [`CreateFirewallPolicyOutput`](crate::output::CreateFirewallPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_token: std::option::Option<std::string::String>,
        pub(crate) firewall_policy_response:
            std::option::Option<crate::model::FirewallPolicyResponse>,
    }
    impl Builder {
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p>
        /// <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_token = Some(input.into());
            self
        }
        /// <p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p>
        /// <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.update_token = input;
            self
        }
        /// <p>The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>. </p>
        pub fn firewall_policy_response(
            mut self,
            input: crate::model::FirewallPolicyResponse,
        ) -> Self {
            self.firewall_policy_response = Some(input);
            self
        }
        /// <p>The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>. </p>
        pub fn set_firewall_policy_response(
            mut self,
            input: std::option::Option<crate::model::FirewallPolicyResponse>,
        ) -> Self {
            self.firewall_policy_response = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFirewallPolicyOutput`](crate::output::CreateFirewallPolicyOutput)
        pub fn build(self) -> crate::output::CreateFirewallPolicyOutput {
            crate::output::CreateFirewallPolicyOutput {
                update_token: self.update_token,
                firewall_policy_response: self.firewall_policy_response,
            }
        }
    }
}
impl CreateFirewallPolicyOutput {
    /// Creates a new builder-style object to manufacture [`CreateFirewallPolicyOutput`](crate::output::CreateFirewallPolicyOutput)
    pub fn builder() -> crate::output::create_firewall_policy_output::Builder {
        crate::output::create_firewall_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFirewallOutput {
    /// <p>The configuration settings for the firewall. These settings include the firewall policy and the subnets in your VPC to use for the firewall endpoints. </p>
    pub firewall: std::option::Option<crate::model::Firewall>,
    /// <p>Detailed information about the current status of a <a>Firewall</a>. You can retrieve this for a firewall by calling <a>DescribeFirewall</a> and providing the firewall name and ARN.</p>
    pub firewall_status: std::option::Option<crate::model::FirewallStatus>,
}
impl std::fmt::Debug for CreateFirewallOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFirewallOutput");
        formatter.field("firewall", &self.firewall);
        formatter.field("firewall_status", &self.firewall_status);
        formatter.finish()
    }
}
/// See [`CreateFirewallOutput`](crate::output::CreateFirewallOutput)
pub mod create_firewall_output {
    /// A builder for [`CreateFirewallOutput`](crate::output::CreateFirewallOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall: std::option::Option<crate::model::Firewall>,
        pub(crate) firewall_status: std::option::Option<crate::model::FirewallStatus>,
    }
    impl Builder {
        /// <p>The configuration settings for the firewall. These settings include the firewall policy and the subnets in your VPC to use for the firewall endpoints. </p>
        pub fn firewall(mut self, input: crate::model::Firewall) -> Self {
            self.firewall = Some(input);
            self
        }
        /// <p>The configuration settings for the firewall. These settings include the firewall policy and the subnets in your VPC to use for the firewall endpoints. </p>
        pub fn set_firewall(mut self, input: std::option::Option<crate::model::Firewall>) -> Self {
            self.firewall = input;
            self
        }
        /// <p>Detailed information about the current status of a <a>Firewall</a>. You can retrieve this for a firewall by calling <a>DescribeFirewall</a> and providing the firewall name and ARN.</p>
        pub fn firewall_status(mut self, input: crate::model::FirewallStatus) -> Self {
            self.firewall_status = Some(input);
            self
        }
        /// <p>Detailed information about the current status of a <a>Firewall</a>. You can retrieve this for a firewall by calling <a>DescribeFirewall</a> and providing the firewall name and ARN.</p>
        pub fn set_firewall_status(
            mut self,
            input: std::option::Option<crate::model::FirewallStatus>,
        ) -> Self {
            self.firewall_status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFirewallOutput`](crate::output::CreateFirewallOutput)
        pub fn build(self) -> crate::output::CreateFirewallOutput {
            crate::output::CreateFirewallOutput {
                firewall: self.firewall,
                firewall_status: self.firewall_status,
            }
        }
    }
}
impl CreateFirewallOutput {
    /// Creates a new builder-style object to manufacture [`CreateFirewallOutput`](crate::output::CreateFirewallOutput)
    pub fn builder() -> crate::output::create_firewall_output::Builder {
        crate::output::create_firewall_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateSubnetsOutput {
    /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
    pub firewall_arn: std::option::Option<std::string::String>,
    /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    pub firewall_name: std::option::Option<std::string::String>,
    /// <p>The IDs of the subnets that are associated with the firewall. </p>
    pub subnet_mappings: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
    /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
    /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
    /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    pub update_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateSubnetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateSubnetsOutput");
        formatter.field("firewall_arn", &self.firewall_arn);
        formatter.field("firewall_name", &self.firewall_name);
        formatter.field("subnet_mappings", &self.subnet_mappings);
        formatter.field("update_token", &self.update_token);
        formatter.finish()
    }
}
/// See [`AssociateSubnetsOutput`](crate::output::AssociateSubnetsOutput)
pub mod associate_subnets_output {
    /// A builder for [`AssociateSubnetsOutput`](crate::output::AssociateSubnetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_arn: std::option::Option<std::string::String>,
        pub(crate) firewall_name: std::option::Option<std::string::String>,
        pub(crate) subnet_mappings: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
        pub(crate) update_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.firewall_arn = input;
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_name = Some(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_name = input;
            self
        }
        /// Appends an item to `subnet_mappings`.
        ///
        /// To override the contents of this collection use [`set_subnet_mappings`](Self::set_subnet_mappings).
        ///
        /// <p>The IDs of the subnets that are associated with the firewall. </p>
        pub fn subnet_mappings(mut self, input: impl Into<crate::model::SubnetMapping>) -> Self {
            let mut v = self.subnet_mappings.unwrap_or_default();
            v.push(input.into());
            self.subnet_mappings = Some(v);
            self
        }
        /// <p>The IDs of the subnets that are associated with the firewall. </p>
        pub fn set_subnet_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
        ) -> Self {
            self.subnet_mappings = input;
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_token = Some(input.into());
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.update_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateSubnetsOutput`](crate::output::AssociateSubnetsOutput)
        pub fn build(self) -> crate::output::AssociateSubnetsOutput {
            crate::output::AssociateSubnetsOutput {
                firewall_arn: self.firewall_arn,
                firewall_name: self.firewall_name,
                subnet_mappings: self.subnet_mappings,
                update_token: self.update_token,
            }
        }
    }
}
impl AssociateSubnetsOutput {
    /// Creates a new builder-style object to manufacture [`AssociateSubnetsOutput`](crate::output::AssociateSubnetsOutput)
    pub fn builder() -> crate::output::associate_subnets_output::Builder {
        crate::output::associate_subnets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateFirewallPolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
    pub firewall_arn: std::option::Option<std::string::String>,
    /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
    pub firewall_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
    pub firewall_policy_arn: std::option::Option<std::string::String>,
    /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
    /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
    /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
    pub update_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateFirewallPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateFirewallPolicyOutput");
        formatter.field("firewall_arn", &self.firewall_arn);
        formatter.field("firewall_name", &self.firewall_name);
        formatter.field("firewall_policy_arn", &self.firewall_policy_arn);
        formatter.field("update_token", &self.update_token);
        formatter.finish()
    }
}
/// See [`AssociateFirewallPolicyOutput`](crate::output::AssociateFirewallPolicyOutput)
pub mod associate_firewall_policy_output {
    /// A builder for [`AssociateFirewallPolicyOutput`](crate::output::AssociateFirewallPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_arn: std::option::Option<std::string::String>,
        pub(crate) firewall_name: std::option::Option<std::string::String>,
        pub(crate) firewall_policy_arn: std::option::Option<std::string::String>,
        pub(crate) update_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn firewall_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall.</p>
        pub fn set_firewall_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.firewall_arn = input;
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn firewall_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_name = Some(input.into());
            self
        }
        /// <p>The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
        pub fn set_firewall_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        pub fn firewall_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall policy.</p>
        pub fn set_firewall_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_policy_arn = input;
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_token = Some(input.into());
            self
        }
        /// <p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p>
        /// <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p>
        /// <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.update_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateFirewallPolicyOutput`](crate::output::AssociateFirewallPolicyOutput)
        pub fn build(self) -> crate::output::AssociateFirewallPolicyOutput {
            crate::output::AssociateFirewallPolicyOutput {
                firewall_arn: self.firewall_arn,
                firewall_name: self.firewall_name,
                firewall_policy_arn: self.firewall_policy_arn,
                update_token: self.update_token,
            }
        }
    }
}
impl AssociateFirewallPolicyOutput {
    /// Creates a new builder-style object to manufacture [`AssociateFirewallPolicyOutput`](crate::output::AssociateFirewallPolicyOutput)
    pub fn builder() -> crate::output::associate_firewall_policy_output::Builder {
        crate::output::associate_firewall_policy_output::Builder::default()
    }
}
