// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateFirewallPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateFirewallPolicyError {
    /// Kind of error that occurred.
    pub kind: AssociateFirewallPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateFirewallPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateFirewallPolicyErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because it's not valid. For example, you might have tried to delete
    /// a rule group or firewall policy that's in use.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The token you provided is stale or isn't valid for the operation. </p>
    InvalidTokenException(crate::error::InvalidTokenException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateFirewallPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateFirewallPolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AssociateFirewallPolicyErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            AssociateFirewallPolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AssociateFirewallPolicyErrorKind::InvalidTokenException(_inner) => _inner.fmt(f),
            AssociateFirewallPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateFirewallPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateFirewallPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateFirewallPolicyError {
    fn code(&self) -> Option<&str> {
        AssociateFirewallPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateFirewallPolicyError {
    /// Creates a new `AssociateFirewallPolicyError`.
    pub fn new(kind: AssociateFirewallPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateFirewallPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateFirewallPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateFirewallPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateFirewallPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateFirewallPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            AssociateFirewallPolicyErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `AssociateFirewallPolicyErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateFirewallPolicyErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns true if the error kind is `AssociateFirewallPolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateFirewallPolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `AssociateFirewallPolicyErrorKind::InvalidTokenException`.
    pub fn is_invalid_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateFirewallPolicyErrorKind::InvalidTokenException(_)
        )
    }
    /// Returns true if the error kind is `AssociateFirewallPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateFirewallPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `AssociateFirewallPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateFirewallPolicyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for AssociateFirewallPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateFirewallPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            AssociateFirewallPolicyErrorKind::InvalidOperationException(_inner) => Some(_inner),
            AssociateFirewallPolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AssociateFirewallPolicyErrorKind::InvalidTokenException(_inner) => Some(_inner),
            AssociateFirewallPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateFirewallPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateFirewallPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateSubnets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateSubnetsError {
    /// Kind of error that occurred.
    pub kind: AssociateSubnetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateSubnets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateSubnetsErrorKind {
    /// <p>AWS doesn't currently have enough available capacity to fulfill your request. Try your
    /// request later. </p>
    InsufficientCapacityException(crate::error::InsufficientCapacityException),
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because it's not valid. For example, you might have tried to delete
    /// a rule group or firewall policy that's in use.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The token you provided is stale or isn't valid for the operation. </p>
    InvalidTokenException(crate::error::InvalidTokenException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateSubnetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateSubnetsErrorKind::InsufficientCapacityException(_inner) => _inner.fmt(f),
            AssociateSubnetsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AssociateSubnetsErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            AssociateSubnetsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AssociateSubnetsErrorKind::InvalidTokenException(_inner) => _inner.fmt(f),
            AssociateSubnetsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateSubnetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateSubnetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateSubnetsError {
    fn code(&self) -> Option<&str> {
        AssociateSubnetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateSubnetsError {
    /// Creates a new `AssociateSubnetsError`.
    pub fn new(kind: AssociateSubnetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateSubnetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateSubnetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateSubnetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateSubnetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateSubnetsErrorKind::InsufficientCapacityException`.
    pub fn is_insufficient_capacity_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSubnetsErrorKind::InsufficientCapacityException(_)
        )
    }
    /// Returns true if the error kind is `AssociateSubnetsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSubnetsErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `AssociateSubnetsErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSubnetsErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns true if the error kind is `AssociateSubnetsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSubnetsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `AssociateSubnetsErrorKind::InvalidTokenException`.
    pub fn is_invalid_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSubnetsErrorKind::InvalidTokenException(_)
        )
    }
    /// Returns true if the error kind is `AssociateSubnetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSubnetsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `AssociateSubnetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSubnetsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for AssociateSubnetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateSubnetsErrorKind::InsufficientCapacityException(_inner) => Some(_inner),
            AssociateSubnetsErrorKind::InternalServerError(_inner) => Some(_inner),
            AssociateSubnetsErrorKind::InvalidOperationException(_inner) => Some(_inner),
            AssociateSubnetsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AssociateSubnetsErrorKind::InvalidTokenException(_inner) => Some(_inner),
            AssociateSubnetsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateSubnetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateSubnetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFirewall` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFirewallError {
    /// Kind of error that occurred.
    pub kind: CreateFirewallErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFirewall` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFirewallErrorKind {
    /// <p>AWS doesn't currently have enough available capacity to fulfill your request. Try your
    /// request later. </p>
    InsufficientCapacityException(crate::error::InsufficientCapacityException),
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because it's not valid. For example, you might have tried to delete
    /// a rule group or firewall policy that's in use.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Unable to perform the operation because doing so would violate a limit setting. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFirewallError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFirewallErrorKind::InsufficientCapacityException(_inner) => _inner.fmt(f),
            CreateFirewallErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateFirewallErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            CreateFirewallErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateFirewallErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateFirewallErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateFirewallErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFirewallError {
    fn code(&self) -> Option<&str> {
        CreateFirewallError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFirewallError {
    /// Creates a new `CreateFirewallError`.
    pub fn new(kind: CreateFirewallErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFirewallError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFirewallErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFirewallError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFirewallErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateFirewallErrorKind::InsufficientCapacityException`.
    pub fn is_insufficient_capacity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFirewallErrorKind::InsufficientCapacityException(_)
        )
    }
    /// Returns true if the error kind is `CreateFirewallErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CreateFirewallErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `CreateFirewallErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFirewallErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns true if the error kind is `CreateFirewallErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFirewallErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateFirewallErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFirewallErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateFirewallErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateFirewallErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateFirewallError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFirewallErrorKind::InsufficientCapacityException(_inner) => Some(_inner),
            CreateFirewallErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateFirewallErrorKind::InvalidOperationException(_inner) => Some(_inner),
            CreateFirewallErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateFirewallErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateFirewallErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateFirewallErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFirewallPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFirewallPolicyError {
    /// Kind of error that occurred.
    pub kind: CreateFirewallPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFirewallPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFirewallPolicyErrorKind {
    /// <p>AWS doesn't currently have enough available capacity to fulfill your request. Try your
    /// request later. </p>
    InsufficientCapacityException(crate::error::InsufficientCapacityException),
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Unable to perform the operation because doing so would violate a limit setting. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFirewallPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFirewallPolicyErrorKind::InsufficientCapacityException(_inner) => _inner.fmt(f),
            CreateFirewallPolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateFirewallPolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateFirewallPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateFirewallPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateFirewallPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFirewallPolicyError {
    fn code(&self) -> Option<&str> {
        CreateFirewallPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFirewallPolicyError {
    /// Creates a new `CreateFirewallPolicyError`.
    pub fn new(kind: CreateFirewallPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFirewallPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFirewallPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFirewallPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFirewallPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateFirewallPolicyErrorKind::InsufficientCapacityException`.
    pub fn is_insufficient_capacity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFirewallPolicyErrorKind::InsufficientCapacityException(_)
        )
    }
    /// Returns true if the error kind is `CreateFirewallPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateFirewallPolicyErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `CreateFirewallPolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFirewallPolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateFirewallPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFirewallPolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateFirewallPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFirewallPolicyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateFirewallPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFirewallPolicyErrorKind::InsufficientCapacityException(_inner) => Some(_inner),
            CreateFirewallPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateFirewallPolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateFirewallPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateFirewallPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateFirewallPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRuleGroupError {
    /// Kind of error that occurred.
    pub kind: CreateRuleGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRuleGroupErrorKind {
    /// <p>AWS doesn't currently have enough available capacity to fulfill your request. Try your
    /// request later. </p>
    InsufficientCapacityException(crate::error::InsufficientCapacityException),
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Unable to perform the operation because doing so would violate a limit setting. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRuleGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRuleGroupErrorKind::InsufficientCapacityException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRuleGroupError {
    fn code(&self) -> Option<&str> {
        CreateRuleGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRuleGroupError {
    /// Creates a new `CreateRuleGroupError`.
    pub fn new(kind: CreateRuleGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRuleGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRuleGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRuleGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRuleGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateRuleGroupErrorKind::InsufficientCapacityException`.
    pub fn is_insufficient_capacity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::InsufficientCapacityException(_)
        )
    }
    /// Returns true if the error kind is `CreateRuleGroupErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CreateRuleGroupErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `CreateRuleGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateRuleGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateRuleGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateRuleGroupErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateRuleGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRuleGroupErrorKind::InsufficientCapacityException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFirewall` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFirewallError {
    /// Kind of error that occurred.
    pub kind: DeleteFirewallErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFirewall` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFirewallErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because it's not valid. For example, you might have tried to delete
    /// a rule group or firewall policy that's in use.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The operation you requested isn't supported by Network Firewall. </p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFirewallError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFirewallErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteFirewallErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            DeleteFirewallErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteFirewallErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFirewallErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteFirewallErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            DeleteFirewallErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFirewallError {
    fn code(&self) -> Option<&str> {
        DeleteFirewallError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFirewallError {
    /// Creates a new `DeleteFirewallError`.
    pub fn new(kind: DeleteFirewallErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFirewallError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFirewallErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFirewallError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFirewallErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteFirewallErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DeleteFirewallErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `DeleteFirewallErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFirewallErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteFirewallErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFirewallErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteFirewallErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFirewallErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteFirewallErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteFirewallErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `DeleteFirewallErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFirewallErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DeleteFirewallError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFirewallErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteFirewallErrorKind::InvalidOperationException(_inner) => Some(_inner),
            DeleteFirewallErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteFirewallErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFirewallErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteFirewallErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            DeleteFirewallErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFirewallPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFirewallPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteFirewallPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFirewallPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFirewallPolicyErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because it's not valid. For example, you might have tried to delete
    /// a rule group or firewall policy that's in use.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The operation you requested isn't supported by Network Firewall. </p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFirewallPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFirewallPolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteFirewallPolicyErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            DeleteFirewallPolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteFirewallPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFirewallPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteFirewallPolicyErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            DeleteFirewallPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFirewallPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteFirewallPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFirewallPolicyError {
    /// Creates a new `DeleteFirewallPolicyError`.
    pub fn new(kind: DeleteFirewallPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFirewallPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFirewallPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFirewallPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFirewallPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteFirewallPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFirewallPolicyErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DeleteFirewallPolicyErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFirewallPolicyErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteFirewallPolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFirewallPolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteFirewallPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFirewallPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteFirewallPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFirewallPolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `DeleteFirewallPolicyErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFirewallPolicyErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DeleteFirewallPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFirewallPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteFirewallPolicyErrorKind::InvalidOperationException(_inner) => Some(_inner),
            DeleteFirewallPolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteFirewallPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFirewallPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteFirewallPolicyErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            DeleteFirewallPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourcePolicyErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The policy statement failed validation.</p>
    InvalidResourcePolicyException(crate::error::InvalidResourcePolicyException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourcePolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::InvalidResourcePolicyException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourcePolicyError {
    fn code(&self) -> Option<&str> {
        DeleteResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourcePolicyError {
    /// Creates a new `DeleteResourcePolicyError`.
    pub fn new(kind: DeleteResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteResourcePolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DeleteResourcePolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteResourcePolicyErrorKind::InvalidResourcePolicyException`.
    pub fn is_invalid_resource_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::InvalidResourcePolicyException(_)
        )
    }
    /// Returns true if the error kind is `DeleteResourcePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteResourcePolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourcePolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::InvalidResourcePolicyException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRuleGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteRuleGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRuleGroupErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because it's not valid. For example, you might have tried to delete
    /// a rule group or firewall policy that's in use.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The operation you requested isn't supported by Network Firewall. </p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRuleGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRuleGroupErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRuleGroupError {
    fn code(&self) -> Option<&str> {
        DeleteRuleGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRuleGroupError {
    /// Creates a new `DeleteRuleGroupError`.
    pub fn new(kind: DeleteRuleGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRuleGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRuleGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRuleGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRuleGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteRuleGroupErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DeleteRuleGroupErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `DeleteRuleGroupErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRuleGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRuleGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRuleGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteRuleGroupErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `DeleteRuleGroupErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DeleteRuleGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRuleGroupErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::InvalidOperationException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFirewall` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFirewallError {
    /// Kind of error that occurred.
    pub kind: DescribeFirewallErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFirewall` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFirewallErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFirewallError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFirewallErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeFirewallErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeFirewallErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeFirewallErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeFirewallErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFirewallError {
    fn code(&self) -> Option<&str> {
        DescribeFirewallError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFirewallError {
    /// Creates a new `DescribeFirewallError`.
    pub fn new(kind: DescribeFirewallErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFirewallError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFirewallErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFirewallError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFirewallErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeFirewallErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFirewallErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeFirewallErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFirewallErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeFirewallErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFirewallErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeFirewallErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFirewallErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeFirewallError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFirewallErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeFirewallErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeFirewallErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeFirewallErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeFirewallErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFirewallPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFirewallPolicyError {
    /// Kind of error that occurred.
    pub kind: DescribeFirewallPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFirewallPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFirewallPolicyErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFirewallPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFirewallPolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeFirewallPolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeFirewallPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeFirewallPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeFirewallPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFirewallPolicyError {
    fn code(&self) -> Option<&str> {
        DescribeFirewallPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFirewallPolicyError {
    /// Creates a new `DescribeFirewallPolicyError`.
    pub fn new(kind: DescribeFirewallPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFirewallPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFirewallPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFirewallPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFirewallPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeFirewallPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFirewallPolicyErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeFirewallPolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFirewallPolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeFirewallPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFirewallPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeFirewallPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFirewallPolicyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeFirewallPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFirewallPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeFirewallPolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeFirewallPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeFirewallPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeFirewallPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLoggingConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeLoggingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLoggingConfigurationErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLoggingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLoggingConfigurationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeLoggingConfigurationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeLoggingConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeLoggingConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeLoggingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLoggingConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeLoggingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLoggingConfigurationError {
    /// Creates a new `DescribeLoggingConfigurationError`.
    pub fn new(kind: DescribeLoggingConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLoggingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLoggingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLoggingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLoggingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeLoggingConfigurationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoggingConfigurationErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeLoggingConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoggingConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeLoggingConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoggingConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeLoggingConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoggingConfigurationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeLoggingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLoggingConfigurationErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeLoggingConfigurationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeLoggingConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeLoggingConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeLoggingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: DescribeResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeResourcePolicyErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeResourcePolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeResourcePolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeResourcePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeResourcePolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeResourcePolicyError {
    fn code(&self) -> Option<&str> {
        DescribeResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeResourcePolicyError {
    /// Creates a new `DescribeResourcePolicyError`.
    pub fn new(kind: DescribeResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeResourcePolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourcePolicyErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeResourcePolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourcePolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeResourcePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourcePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeResourcePolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourcePolicyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeResourcePolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeResourcePolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeResourcePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeResourcePolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRuleGroupError {
    /// Kind of error that occurred.
    pub kind: DescribeRuleGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRuleGroupErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRuleGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRuleGroupErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeRuleGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeRuleGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeRuleGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeRuleGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRuleGroupError {
    fn code(&self) -> Option<&str> {
        DescribeRuleGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRuleGroupError {
    /// Creates a new `DescribeRuleGroupError`.
    pub fn new(kind: DescribeRuleGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRuleGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRuleGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRuleGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRuleGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeRuleGroupErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRuleGroupErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DescribeRuleGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRuleGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeRuleGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRuleGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeRuleGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRuleGroupErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeRuleGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRuleGroupErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeRuleGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeRuleGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeRuleGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeRuleGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateSubnets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateSubnetsError {
    /// Kind of error that occurred.
    pub kind: DisassociateSubnetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateSubnets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateSubnetsErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because it's not valid. For example, you might have tried to delete
    /// a rule group or firewall policy that's in use.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The token you provided is stale or isn't valid for the operation. </p>
    InvalidTokenException(crate::error::InvalidTokenException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateSubnetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateSubnetsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DisassociateSubnetsErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            DisassociateSubnetsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DisassociateSubnetsErrorKind::InvalidTokenException(_inner) => _inner.fmt(f),
            DisassociateSubnetsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateSubnetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateSubnetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateSubnetsError {
    fn code(&self) -> Option<&str> {
        DisassociateSubnetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateSubnetsError {
    /// Creates a new `DisassociateSubnetsError`.
    pub fn new(kind: DisassociateSubnetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateSubnetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateSubnetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateSubnetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateSubnetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociateSubnetsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSubnetsErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DisassociateSubnetsErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSubnetsErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateSubnetsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSubnetsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateSubnetsErrorKind::InvalidTokenException`.
    pub fn is_invalid_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSubnetsErrorKind::InvalidTokenException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateSubnetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSubnetsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateSubnetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSubnetsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DisassociateSubnetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateSubnetsErrorKind::InternalServerError(_inner) => Some(_inner),
            DisassociateSubnetsErrorKind::InvalidOperationException(_inner) => Some(_inner),
            DisassociateSubnetsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DisassociateSubnetsErrorKind::InvalidTokenException(_inner) => Some(_inner),
            DisassociateSubnetsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateSubnetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateSubnetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFirewallPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFirewallPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListFirewallPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFirewallPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFirewallPoliciesErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFirewallPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFirewallPoliciesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListFirewallPoliciesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListFirewallPoliciesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListFirewallPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFirewallPoliciesError {
    fn code(&self) -> Option<&str> {
        ListFirewallPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFirewallPoliciesError {
    /// Creates a new `ListFirewallPoliciesError`.
    pub fn new(kind: ListFirewallPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFirewallPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFirewallPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFirewallPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFirewallPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListFirewallPoliciesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListFirewallPoliciesErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `ListFirewallPoliciesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFirewallPoliciesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListFirewallPoliciesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFirewallPoliciesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListFirewallPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFirewallPoliciesErrorKind::InternalServerError(_inner) => Some(_inner),
            ListFirewallPoliciesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListFirewallPoliciesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListFirewallPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFirewalls` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFirewallsError {
    /// Kind of error that occurred.
    pub kind: ListFirewallsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFirewalls` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFirewallsErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFirewallsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFirewallsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListFirewallsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListFirewallsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListFirewallsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFirewallsError {
    fn code(&self) -> Option<&str> {
        ListFirewallsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFirewallsError {
    /// Creates a new `ListFirewallsError`.
    pub fn new(kind: ListFirewallsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFirewallsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFirewallsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFirewallsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFirewallsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListFirewallsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ListFirewallsErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `ListFirewallsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFirewallsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListFirewallsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListFirewallsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListFirewallsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFirewallsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListFirewallsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListFirewallsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListFirewallsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRuleGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRuleGroupsError {
    /// Kind of error that occurred.
    pub kind: ListRuleGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRuleGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRuleGroupsErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRuleGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRuleGroupsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListRuleGroupsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListRuleGroupsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListRuleGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRuleGroupsError {
    fn code(&self) -> Option<&str> {
        ListRuleGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRuleGroupsError {
    /// Creates a new `ListRuleGroupsError`.
    pub fn new(kind: ListRuleGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRuleGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRuleGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRuleGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRuleGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListRuleGroupsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ListRuleGroupsErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `ListRuleGroupsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRuleGroupsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListRuleGroupsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListRuleGroupsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListRuleGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRuleGroupsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListRuleGroupsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListRuleGroupsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListRuleGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: PutResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutResourcePolicyErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The policy statement failed validation.</p>
    InvalidResourcePolicyException(crate::error::InvalidResourcePolicyException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutResourcePolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::InvalidResourcePolicyException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutResourcePolicyError {
    fn code(&self) -> Option<&str> {
        PutResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutResourcePolicyError {
    /// Creates a new `PutResourcePolicyError`.
    pub fn new(kind: PutResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutResourcePolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `PutResourcePolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `PutResourcePolicyErrorKind::InvalidResourcePolicyException`.
    pub fn is_invalid_resource_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::InvalidResourcePolicyException(_)
        )
    }
    /// Returns true if the error kind is `PutResourcePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PutResourcePolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for PutResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutResourcePolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::InvalidResourcePolicyException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidRequestException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFirewallDeleteProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFirewallDeleteProtectionError {
    /// Kind of error that occurred.
    pub kind: UpdateFirewallDeleteProtectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFirewallDeleteProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFirewallDeleteProtectionErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The token you provided is stale or isn't valid for the operation. </p>
    InvalidTokenException(crate::error::InvalidTokenException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to change the resource because your account doesn't own it. </p>
    ResourceOwnerCheckException(crate::error::ResourceOwnerCheckException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFirewallDeleteProtectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFirewallDeleteProtectionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateFirewallDeleteProtectionErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFirewallDeleteProtectionErrorKind::InvalidTokenException(_inner) => _inner.fmt(f),
            UpdateFirewallDeleteProtectionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFirewallDeleteProtectionErrorKind::ResourceOwnerCheckException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFirewallDeleteProtectionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateFirewallDeleteProtectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFirewallDeleteProtectionError {
    fn code(&self) -> Option<&str> {
        UpdateFirewallDeleteProtectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFirewallDeleteProtectionError {
    /// Creates a new `UpdateFirewallDeleteProtectionError`.
    pub fn new(
        kind: UpdateFirewallDeleteProtectionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFirewallDeleteProtectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFirewallDeleteProtectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFirewallDeleteProtectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFirewallDeleteProtectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateFirewallDeleteProtectionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallDeleteProtectionErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateFirewallDeleteProtectionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallDeleteProtectionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFirewallDeleteProtectionErrorKind::InvalidTokenException`.
    pub fn is_invalid_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallDeleteProtectionErrorKind::InvalidTokenException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFirewallDeleteProtectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallDeleteProtectionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFirewallDeleteProtectionErrorKind::ResourceOwnerCheckException`.
    pub fn is_resource_owner_check_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallDeleteProtectionErrorKind::ResourceOwnerCheckException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFirewallDeleteProtectionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallDeleteProtectionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateFirewallDeleteProtectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFirewallDeleteProtectionErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateFirewallDeleteProtectionErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            UpdateFirewallDeleteProtectionErrorKind::InvalidTokenException(_inner) => Some(_inner),
            UpdateFirewallDeleteProtectionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateFirewallDeleteProtectionErrorKind::ResourceOwnerCheckException(_inner) => {
                Some(_inner)
            }
            UpdateFirewallDeleteProtectionErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateFirewallDeleteProtectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFirewallDescription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFirewallDescriptionError {
    /// Kind of error that occurred.
    pub kind: UpdateFirewallDescriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFirewallDescription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFirewallDescriptionErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The token you provided is stale or isn't valid for the operation. </p>
    InvalidTokenException(crate::error::InvalidTokenException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFirewallDescriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFirewallDescriptionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateFirewallDescriptionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateFirewallDescriptionErrorKind::InvalidTokenException(_inner) => _inner.fmt(f),
            UpdateFirewallDescriptionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateFirewallDescriptionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateFirewallDescriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFirewallDescriptionError {
    fn code(&self) -> Option<&str> {
        UpdateFirewallDescriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFirewallDescriptionError {
    /// Creates a new `UpdateFirewallDescriptionError`.
    pub fn new(kind: UpdateFirewallDescriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFirewallDescriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFirewallDescriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFirewallDescriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFirewallDescriptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateFirewallDescriptionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallDescriptionErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateFirewallDescriptionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallDescriptionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFirewallDescriptionErrorKind::InvalidTokenException`.
    pub fn is_invalid_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallDescriptionErrorKind::InvalidTokenException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFirewallDescriptionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallDescriptionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFirewallDescriptionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallDescriptionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateFirewallDescriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFirewallDescriptionErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateFirewallDescriptionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateFirewallDescriptionErrorKind::InvalidTokenException(_inner) => Some(_inner),
            UpdateFirewallDescriptionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateFirewallDescriptionErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateFirewallDescriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFirewallPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFirewallPolicyError {
    /// Kind of error that occurred.
    pub kind: UpdateFirewallPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFirewallPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFirewallPolicyErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The token you provided is stale or isn't valid for the operation. </p>
    InvalidTokenException(crate::error::InvalidTokenException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFirewallPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFirewallPolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateFirewallPolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateFirewallPolicyErrorKind::InvalidTokenException(_inner) => _inner.fmt(f),
            UpdateFirewallPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateFirewallPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateFirewallPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFirewallPolicyError {
    fn code(&self) -> Option<&str> {
        UpdateFirewallPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFirewallPolicyError {
    /// Creates a new `UpdateFirewallPolicyError`.
    pub fn new(kind: UpdateFirewallPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFirewallPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFirewallPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFirewallPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFirewallPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateFirewallPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallPolicyErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateFirewallPolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallPolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFirewallPolicyErrorKind::InvalidTokenException`.
    pub fn is_invalid_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallPolicyErrorKind::InvalidTokenException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFirewallPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFirewallPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallPolicyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateFirewallPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFirewallPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateFirewallPolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateFirewallPolicyErrorKind::InvalidTokenException(_inner) => Some(_inner),
            UpdateFirewallPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateFirewallPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateFirewallPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFirewallPolicyChangeProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFirewallPolicyChangeProtectionError {
    /// Kind of error that occurred.
    pub kind: UpdateFirewallPolicyChangeProtectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFirewallPolicyChangeProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFirewallPolicyChangeProtectionErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The token you provided is stale or isn't valid for the operation. </p>
    InvalidTokenException(crate::error::InvalidTokenException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to change the resource because your account doesn't own it. </p>
    ResourceOwnerCheckException(crate::error::ResourceOwnerCheckException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFirewallPolicyChangeProtectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFirewallPolicyChangeProtectionErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            UpdateFirewallPolicyChangeProtectionErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFirewallPolicyChangeProtectionErrorKind::InvalidTokenException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFirewallPolicyChangeProtectionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFirewallPolicyChangeProtectionErrorKind::ResourceOwnerCheckException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFirewallPolicyChangeProtectionErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFirewallPolicyChangeProtectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFirewallPolicyChangeProtectionError {
    fn code(&self) -> Option<&str> {
        UpdateFirewallPolicyChangeProtectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFirewallPolicyChangeProtectionError {
    /// Creates a new `UpdateFirewallPolicyChangeProtectionError`.
    pub fn new(
        kind: UpdateFirewallPolicyChangeProtectionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFirewallPolicyChangeProtectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFirewallPolicyChangeProtectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFirewallPolicyChangeProtectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFirewallPolicyChangeProtectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateFirewallPolicyChangeProtectionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallPolicyChangeProtectionErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateFirewallPolicyChangeProtectionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallPolicyChangeProtectionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFirewallPolicyChangeProtectionErrorKind::InvalidTokenException`.
    pub fn is_invalid_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallPolicyChangeProtectionErrorKind::InvalidTokenException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFirewallPolicyChangeProtectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallPolicyChangeProtectionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFirewallPolicyChangeProtectionErrorKind::ResourceOwnerCheckException`.
    pub fn is_resource_owner_check_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallPolicyChangeProtectionErrorKind::ResourceOwnerCheckException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFirewallPolicyChangeProtectionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFirewallPolicyChangeProtectionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateFirewallPolicyChangeProtectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFirewallPolicyChangeProtectionErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            UpdateFirewallPolicyChangeProtectionErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            UpdateFirewallPolicyChangeProtectionErrorKind::InvalidTokenException(_inner) => {
                Some(_inner)
            }
            UpdateFirewallPolicyChangeProtectionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateFirewallPolicyChangeProtectionErrorKind::ResourceOwnerCheckException(_inner) => {
                Some(_inner)
            }
            UpdateFirewallPolicyChangeProtectionErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            UpdateFirewallPolicyChangeProtectionErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLoggingConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateLoggingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLoggingConfigurationErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The token you provided is stale or isn't valid for the operation. </p>
    InvalidTokenException(crate::error::InvalidTokenException),
    /// <p>Unable to send logs to a configured logging destination. </p>
    LogDestinationPermissionException(crate::error::LogDestinationPermissionException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLoggingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLoggingConfigurationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateLoggingConfigurationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateLoggingConfigurationErrorKind::InvalidTokenException(_inner) => _inner.fmt(f),
            UpdateLoggingConfigurationErrorKind::LogDestinationPermissionException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLoggingConfigurationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateLoggingConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateLoggingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLoggingConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateLoggingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLoggingConfigurationError {
    /// Creates a new `UpdateLoggingConfigurationError`.
    pub fn new(kind: UpdateLoggingConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLoggingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLoggingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLoggingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLoggingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateLoggingConfigurationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLoggingConfigurationErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateLoggingConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLoggingConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLoggingConfigurationErrorKind::InvalidTokenException`.
    pub fn is_invalid_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLoggingConfigurationErrorKind::InvalidTokenException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLoggingConfigurationErrorKind::LogDestinationPermissionException`.
    pub fn is_log_destination_permission_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLoggingConfigurationErrorKind::LogDestinationPermissionException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLoggingConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLoggingConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLoggingConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLoggingConfigurationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateLoggingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLoggingConfigurationErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateLoggingConfigurationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateLoggingConfigurationErrorKind::InvalidTokenException(_inner) => Some(_inner),
            UpdateLoggingConfigurationErrorKind::LogDestinationPermissionException(_inner) => {
                Some(_inner)
            }
            UpdateLoggingConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateLoggingConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateLoggingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRuleGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateRuleGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRuleGroupErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The token you provided is stale or isn't valid for the operation. </p>
    InvalidTokenException(crate::error::InvalidTokenException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRuleGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRuleGroupErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::InvalidTokenException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRuleGroupError {
    fn code(&self) -> Option<&str> {
        UpdateRuleGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRuleGroupError {
    /// Creates a new `UpdateRuleGroupError`.
    pub fn new(kind: UpdateRuleGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRuleGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRuleGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRuleGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRuleGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateRuleGroupErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, UpdateRuleGroupErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `UpdateRuleGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRuleGroupErrorKind::InvalidTokenException`.
    pub fn is_invalid_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleGroupErrorKind::InvalidTokenException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRuleGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRuleGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateRuleGroupErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdateRuleGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRuleGroupErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::InvalidTokenException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSubnetChangeProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSubnetChangeProtectionError {
    /// Kind of error that occurred.
    pub kind: UpdateSubnetChangeProtectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSubnetChangeProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSubnetChangeProtectionErrorKind {
    /// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
    /// system problem. Retry your request. </p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation failed because of a problem with your request. Examples include: </p>
    /// <ul>
    /// <li>
    /// <p>You specified an unsupported parameter name or value.</p>
    /// </li>
    /// <li>
    /// <p>You tried to update a property with a value that isn't among the available
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>Your request references an ARN that is malformed, or corresponds to a resource
    /// that isn't valid in the context of the request.</p>
    /// </li>
    /// </ul>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The token you provided is stale or isn't valid for the operation. </p>
    InvalidTokenException(crate::error::InvalidTokenException),
    /// <p>Unable to locate a resource using the parameters that you provided.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unable to change the resource because your account doesn't own it. </p>
    ResourceOwnerCheckException(crate::error::ResourceOwnerCheckException),
    /// <p>Unable to process the request due to throttling limitations.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSubnetChangeProtectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSubnetChangeProtectionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateSubnetChangeProtectionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateSubnetChangeProtectionErrorKind::InvalidTokenException(_inner) => _inner.fmt(f),
            UpdateSubnetChangeProtectionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateSubnetChangeProtectionErrorKind::ResourceOwnerCheckException(_inner) => {
                _inner.fmt(f)
            }
            UpdateSubnetChangeProtectionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateSubnetChangeProtectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSubnetChangeProtectionError {
    fn code(&self) -> Option<&str> {
        UpdateSubnetChangeProtectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSubnetChangeProtectionError {
    /// Creates a new `UpdateSubnetChangeProtectionError`.
    pub fn new(kind: UpdateSubnetChangeProtectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSubnetChangeProtectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSubnetChangeProtectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSubnetChangeProtectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSubnetChangeProtectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateSubnetChangeProtectionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubnetChangeProtectionErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `UpdateSubnetChangeProtectionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubnetChangeProtectionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateSubnetChangeProtectionErrorKind::InvalidTokenException`.
    pub fn is_invalid_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubnetChangeProtectionErrorKind::InvalidTokenException(_)
        )
    }
    /// Returns true if the error kind is `UpdateSubnetChangeProtectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubnetChangeProtectionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateSubnetChangeProtectionErrorKind::ResourceOwnerCheckException`.
    pub fn is_resource_owner_check_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubnetChangeProtectionErrorKind::ResourceOwnerCheckException(_)
        )
    }
    /// Returns true if the error kind is `UpdateSubnetChangeProtectionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubnetChangeProtectionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateSubnetChangeProtectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSubnetChangeProtectionErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateSubnetChangeProtectionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateSubnetChangeProtectionErrorKind::InvalidTokenException(_inner) => Some(_inner),
            UpdateSubnetChangeProtectionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateSubnetChangeProtectionErrorKind::ResourceOwnerCheckException(_inner) => {
                Some(_inner)
            }
            UpdateSubnetChangeProtectionErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateSubnetChangeProtectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Unable to process the request due to throttling limitations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>Unable to change the resource because your account doesn't own it. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceOwnerCheckException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceOwnerCheckException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceOwnerCheckException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceOwnerCheckException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceOwnerCheckException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceOwnerCheckException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceOwnerCheckException {}
/// See [`ResourceOwnerCheckException`](crate::error::ResourceOwnerCheckException)
pub mod resource_owner_check_exception {
    /// A builder for [`ResourceOwnerCheckException`](crate::error::ResourceOwnerCheckException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceOwnerCheckException`](crate::error::ResourceOwnerCheckException)
        pub fn build(self) -> crate::error::ResourceOwnerCheckException {
            crate::error::ResourceOwnerCheckException {
                message: self.message,
            }
        }
    }
}
impl ResourceOwnerCheckException {
    /// Creates a new builder-style object to manufacture [`ResourceOwnerCheckException`](crate::error::ResourceOwnerCheckException)
    pub fn builder() -> crate::error::resource_owner_check_exception::Builder {
        crate::error::resource_owner_check_exception::Builder::default()
    }
}

/// <p>Unable to locate a resource using the parameters that you provided.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The token you provided is stale or isn't valid for the operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTokenException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTokenException {}
/// See [`InvalidTokenException`](crate::error::InvalidTokenException)
pub mod invalid_token_exception {
    /// A builder for [`InvalidTokenException`](crate::error::InvalidTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTokenException`](crate::error::InvalidTokenException)
        pub fn build(self) -> crate::error::InvalidTokenException {
            crate::error::InvalidTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidTokenException`](crate::error::InvalidTokenException)
    pub fn builder() -> crate::error::invalid_token_exception::Builder {
        crate::error::invalid_token_exception::Builder::default()
    }
}

/// <p>The operation failed because of a problem with your request. Examples include: </p>
/// <ul>
/// <li>
/// <p>You specified an unsupported parameter name or value.</p>
/// </li>
/// <li>
/// <p>You tried to update a property with a value that isn't among the available
/// types.</p>
/// </li>
/// <li>
/// <p>Your request references an ARN that is malformed, or corresponds to a resource
/// that isn't valid in the context of the request.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>Your request is valid, but Network Firewall couldn’t perform the operation because of a
/// system problem. Retry your request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerError")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerError {}
/// See [`InternalServerError`](crate::error::InternalServerError)
pub mod internal_server_error {
    /// A builder for [`InternalServerError`](crate::error::InternalServerError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerError`](crate::error::InternalServerError)
        pub fn build(self) -> crate::error::InternalServerError {
            crate::error::InternalServerError {
                message: self.message,
            }
        }
    }
}
impl InternalServerError {
    /// Creates a new builder-style object to manufacture [`InternalServerError`](crate::error::InternalServerError)
    pub fn builder() -> crate::error::internal_server_error::Builder {
        crate::error::internal_server_error::Builder::default()
    }
}

/// <p>Unable to send logs to a configured logging destination. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogDestinationPermissionException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LogDestinationPermissionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogDestinationPermissionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LogDestinationPermissionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LogDestinationPermissionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LogDestinationPermissionException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for LogDestinationPermissionException {}
/// See [`LogDestinationPermissionException`](crate::error::LogDestinationPermissionException)
pub mod log_destination_permission_exception {
    /// A builder for [`LogDestinationPermissionException`](crate::error::LogDestinationPermissionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LogDestinationPermissionException`](crate::error::LogDestinationPermissionException)
        pub fn build(self) -> crate::error::LogDestinationPermissionException {
            crate::error::LogDestinationPermissionException {
                message: self.message,
            }
        }
    }
}
impl LogDestinationPermissionException {
    /// Creates a new builder-style object to manufacture [`LogDestinationPermissionException`](crate::error::LogDestinationPermissionException)
    pub fn builder() -> crate::error::log_destination_permission_exception::Builder {
        crate::error::log_destination_permission_exception::Builder::default()
    }
}

/// <p>The policy statement failed validation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidResourcePolicyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidResourcePolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidResourcePolicyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidResourcePolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidResourcePolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidResourcePolicyException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidResourcePolicyException {}
/// See [`InvalidResourcePolicyException`](crate::error::InvalidResourcePolicyException)
pub mod invalid_resource_policy_exception {
    /// A builder for [`InvalidResourcePolicyException`](crate::error::InvalidResourcePolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidResourcePolicyException`](crate::error::InvalidResourcePolicyException)
        pub fn build(self) -> crate::error::InvalidResourcePolicyException {
            crate::error::InvalidResourcePolicyException {
                message: self.message,
            }
        }
    }
}
impl InvalidResourcePolicyException {
    /// Creates a new builder-style object to manufacture [`InvalidResourcePolicyException`](crate::error::InvalidResourcePolicyException)
    pub fn builder() -> crate::error::invalid_resource_policy_exception::Builder {
        crate::error::invalid_resource_policy_exception::Builder::default()
    }
}

/// <p>The operation failed because it's not valid. For example, you might have tried to delete
/// a rule group or firewall policy that's in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidOperationException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidOperationException {}
/// See [`InvalidOperationException`](crate::error::InvalidOperationException)
pub mod invalid_operation_exception {
    /// A builder for [`InvalidOperationException`](crate::error::InvalidOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidOperationException`](crate::error::InvalidOperationException)
        pub fn build(self) -> crate::error::InvalidOperationException {
            crate::error::InvalidOperationException {
                message: self.message,
            }
        }
    }
}
impl InvalidOperationException {
    /// Creates a new builder-style object to manufacture [`InvalidOperationException`](crate::error::InvalidOperationException)
    pub fn builder() -> crate::error::invalid_operation_exception::Builder {
        crate::error::invalid_operation_exception::Builder::default()
    }
}

/// <p>The operation you requested isn't supported by Network Firewall. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedOperationException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedOperationException {}
/// See [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
pub mod unsupported_operation_exception {
    /// A builder for [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
        pub fn build(self) -> crate::error::UnsupportedOperationException {
            crate::error::UnsupportedOperationException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedOperationException {
    /// Creates a new builder-style object to manufacture [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
    pub fn builder() -> crate::error::unsupported_operation_exception::Builder {
        crate::error::unsupported_operation_exception::Builder::default()
    }
}

/// <p>Unable to perform the operation because doing so would violate a limit setting. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>AWS doesn't currently have enough available capacity to fulfill your request. Try your
/// request later. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientCapacityException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientCapacityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientCapacityException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientCapacityException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientCapacityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientCapacityException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientCapacityException {}
/// See [`InsufficientCapacityException`](crate::error::InsufficientCapacityException)
pub mod insufficient_capacity_exception {
    /// A builder for [`InsufficientCapacityException`](crate::error::InsufficientCapacityException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientCapacityException`](crate::error::InsufficientCapacityException)
        pub fn build(self) -> crate::error::InsufficientCapacityException {
            crate::error::InsufficientCapacityException {
                message: self.message,
            }
        }
    }
}
impl InsufficientCapacityException {
    /// Creates a new builder-style object to manufacture [`InsufficientCapacityException`](crate::error::InsufficientCapacityException)
    pub fn builder() -> crate::error::insufficient_capacity_exception::Builder {
        crate::error::insufficient_capacity_exception::Builder::default()
    }
}
