// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopDbClusterOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    pub db_cluster: std::option::Option<crate::model::DbCluster>,
}
impl StopDbClusterOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    pub fn db_cluster(&self) -> std::option::Option<&crate::model::DbCluster> {
        self.db_cluster.as_ref()
    }
}
impl std::fmt::Debug for StopDbClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopDbClusterOutput");
        formatter.field("db_cluster", &self.db_cluster);
        formatter.finish()
    }
}
/// See [`StopDbClusterOutput`](crate::output::StopDbClusterOutput)
pub mod stop_db_cluster_output {
    /// A builder for [`StopDbClusterOutput`](crate::output::StopDbClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster: std::option::Option<crate::model::DbCluster>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
        pub fn db_cluster(mut self, input: crate::model::DbCluster) -> Self {
            self.db_cluster = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
        pub fn set_db_cluster(
            mut self,
            input: std::option::Option<crate::model::DbCluster>,
        ) -> Self {
            self.db_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`StopDbClusterOutput`](crate::output::StopDbClusterOutput)
        pub fn build(self) -> crate::output::StopDbClusterOutput {
            crate::output::StopDbClusterOutput {
                db_cluster: self.db_cluster,
            }
        }
    }
}
impl StopDbClusterOutput {
    /// Creates a new builder-style object to manufacture [`StopDbClusterOutput`](crate::output::StopDbClusterOutput)
    pub fn builder() -> crate::output::stop_db_cluster_output::Builder {
        crate::output::stop_db_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDbClusterOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    pub db_cluster: std::option::Option<crate::model::DbCluster>,
}
impl StartDbClusterOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    pub fn db_cluster(&self) -> std::option::Option<&crate::model::DbCluster> {
        self.db_cluster.as_ref()
    }
}
impl std::fmt::Debug for StartDbClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDbClusterOutput");
        formatter.field("db_cluster", &self.db_cluster);
        formatter.finish()
    }
}
/// See [`StartDbClusterOutput`](crate::output::StartDbClusterOutput)
pub mod start_db_cluster_output {
    /// A builder for [`StartDbClusterOutput`](crate::output::StartDbClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster: std::option::Option<crate::model::DbCluster>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
        pub fn db_cluster(mut self, input: crate::model::DbCluster) -> Self {
            self.db_cluster = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
        pub fn set_db_cluster(
            mut self,
            input: std::option::Option<crate::model::DbCluster>,
        ) -> Self {
            self.db_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDbClusterOutput`](crate::output::StartDbClusterOutput)
        pub fn build(self) -> crate::output::StartDbClusterOutput {
            crate::output::StartDbClusterOutput {
                db_cluster: self.db_cluster,
            }
        }
    }
}
impl StartDbClusterOutput {
    /// Creates a new builder-style object to manufacture [`StartDbClusterOutput`](crate::output::StartDbClusterOutput)
    pub fn builder() -> crate::output::start_db_cluster_output::Builder {
        crate::output::start_db_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreDbClusterToPointInTimeOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    pub db_cluster: std::option::Option<crate::model::DbCluster>,
}
impl RestoreDbClusterToPointInTimeOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    pub fn db_cluster(&self) -> std::option::Option<&crate::model::DbCluster> {
        self.db_cluster.as_ref()
    }
}
impl std::fmt::Debug for RestoreDbClusterToPointInTimeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreDbClusterToPointInTimeOutput");
        formatter.field("db_cluster", &self.db_cluster);
        formatter.finish()
    }
}
/// See [`RestoreDbClusterToPointInTimeOutput`](crate::output::RestoreDbClusterToPointInTimeOutput)
pub mod restore_db_cluster_to_point_in_time_output {
    /// A builder for [`RestoreDbClusterToPointInTimeOutput`](crate::output::RestoreDbClusterToPointInTimeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster: std::option::Option<crate::model::DbCluster>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
        pub fn db_cluster(mut self, input: crate::model::DbCluster) -> Self {
            self.db_cluster = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
        pub fn set_db_cluster(
            mut self,
            input: std::option::Option<crate::model::DbCluster>,
        ) -> Self {
            self.db_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreDbClusterToPointInTimeOutput`](crate::output::RestoreDbClusterToPointInTimeOutput)
        pub fn build(self) -> crate::output::RestoreDbClusterToPointInTimeOutput {
            crate::output::RestoreDbClusterToPointInTimeOutput {
                db_cluster: self.db_cluster,
            }
        }
    }
}
impl RestoreDbClusterToPointInTimeOutput {
    /// Creates a new builder-style object to manufacture [`RestoreDbClusterToPointInTimeOutput`](crate::output::RestoreDbClusterToPointInTimeOutput)
    pub fn builder() -> crate::output::restore_db_cluster_to_point_in_time_output::Builder {
        crate::output::restore_db_cluster_to_point_in_time_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreDbClusterFromSnapshotOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    pub db_cluster: std::option::Option<crate::model::DbCluster>,
}
impl RestoreDbClusterFromSnapshotOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    pub fn db_cluster(&self) -> std::option::Option<&crate::model::DbCluster> {
        self.db_cluster.as_ref()
    }
}
impl std::fmt::Debug for RestoreDbClusterFromSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreDbClusterFromSnapshotOutput");
        formatter.field("db_cluster", &self.db_cluster);
        formatter.finish()
    }
}
/// See [`RestoreDbClusterFromSnapshotOutput`](crate::output::RestoreDbClusterFromSnapshotOutput)
pub mod restore_db_cluster_from_snapshot_output {
    /// A builder for [`RestoreDbClusterFromSnapshotOutput`](crate::output::RestoreDbClusterFromSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster: std::option::Option<crate::model::DbCluster>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
        pub fn db_cluster(mut self, input: crate::model::DbCluster) -> Self {
            self.db_cluster = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
        pub fn set_db_cluster(
            mut self,
            input: std::option::Option<crate::model::DbCluster>,
        ) -> Self {
            self.db_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreDbClusterFromSnapshotOutput`](crate::output::RestoreDbClusterFromSnapshotOutput)
        pub fn build(self) -> crate::output::RestoreDbClusterFromSnapshotOutput {
            crate::output::RestoreDbClusterFromSnapshotOutput {
                db_cluster: self.db_cluster,
            }
        }
    }
}
impl RestoreDbClusterFromSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`RestoreDbClusterFromSnapshotOutput`](crate::output::RestoreDbClusterFromSnapshotOutput)
    pub fn builder() -> crate::output::restore_db_cluster_from_snapshot_output::Builder {
        crate::output::restore_db_cluster_from_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetDbParameterGroupOutput {
    /// <p>Provides the name of the DB parameter group.</p>
    pub db_parameter_group_name: std::option::Option<std::string::String>,
}
impl ResetDbParameterGroupOutput {
    /// <p>Provides the name of the DB parameter group.</p>
    pub fn db_parameter_group_name(&self) -> std::option::Option<&str> {
        self.db_parameter_group_name.as_deref()
    }
}
impl std::fmt::Debug for ResetDbParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetDbParameterGroupOutput");
        formatter.field("db_parameter_group_name", &self.db_parameter_group_name);
        formatter.finish()
    }
}
/// See [`ResetDbParameterGroupOutput`](crate::output::ResetDbParameterGroupOutput)
pub mod reset_db_parameter_group_output {
    /// A builder for [`ResetDbParameterGroupOutput`](crate::output::ResetDbParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Provides the name of the DB parameter group.</p>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>Provides the name of the DB parameter group.</p>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetDbParameterGroupOutput`](crate::output::ResetDbParameterGroupOutput)
        pub fn build(self) -> crate::output::ResetDbParameterGroupOutput {
            crate::output::ResetDbParameterGroupOutput {
                db_parameter_group_name: self.db_parameter_group_name,
            }
        }
    }
}
impl ResetDbParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`ResetDbParameterGroupOutput`](crate::output::ResetDbParameterGroupOutput)
    pub fn builder() -> crate::output::reset_db_parameter_group_output::Builder {
        crate::output::reset_db_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetDbClusterParameterGroupOutput {
    /// <p>The name of the DB cluster parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li> <p>Must be 1 to 255 letters or numbers.</p> </li>
    /// <li> <p>First character must be a letter</p> </li>
    /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
    /// </ul> <note>
    /// <p>This value is stored as a lowercase string.</p>
    /// </note>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
}
impl ResetDbClusterParameterGroupOutput {
    /// <p>The name of the DB cluster parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li> <p>Must be 1 to 255 letters or numbers.</p> </li>
    /// <li> <p>First character must be a letter</p> </li>
    /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
    /// </ul> <note>
    /// <p>This value is stored as a lowercase string.</p>
    /// </note>
    pub fn db_cluster_parameter_group_name(&self) -> std::option::Option<&str> {
        self.db_cluster_parameter_group_name.as_deref()
    }
}
impl std::fmt::Debug for ResetDbClusterParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetDbClusterParameterGroupOutput");
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.finish()
    }
}
/// See [`ResetDbClusterParameterGroupOutput`](crate::output::ResetDbClusterParameterGroupOutput)
pub mod reset_db_cluster_parameter_group_output {
    /// A builder for [`ResetDbClusterParameterGroupOutput`](crate::output::ResetDbClusterParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters or numbers.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul> <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters or numbers.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul> <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetDbClusterParameterGroupOutput`](crate::output::ResetDbClusterParameterGroupOutput)
        pub fn build(self) -> crate::output::ResetDbClusterParameterGroupOutput {
            crate::output::ResetDbClusterParameterGroupOutput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
            }
        }
    }
}
impl ResetDbClusterParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`ResetDbClusterParameterGroupOutput`](crate::output::ResetDbClusterParameterGroupOutput)
    pub fn builder() -> crate::output::reset_db_cluster_parameter_group_output::Builder {
        crate::output::reset_db_cluster_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsFromResourceOutput {}
impl std::fmt::Debug for RemoveTagsFromResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsFromResourceOutput");
        formatter.finish()
    }
}
/// See [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
pub mod remove_tags_from_resource_output {
    /// A builder for [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
        pub fn build(self) -> crate::output::RemoveTagsFromResourceOutput {
            crate::output::RemoveTagsFromResourceOutput {}
        }
    }
}
impl RemoveTagsFromResourceOutput {
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
    pub fn builder() -> crate::output::remove_tags_from_resource_output::Builder {
        crate::output::remove_tags_from_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveSourceIdentifierFromSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub event_subscription: std::option::Option<crate::model::EventSubscription>,
}
impl RemoveSourceIdentifierFromSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub fn event_subscription(&self) -> std::option::Option<&crate::model::EventSubscription> {
        self.event_subscription.as_ref()
    }
}
impl std::fmt::Debug for RemoveSourceIdentifierFromSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveSourceIdentifierFromSubscriptionOutput");
        formatter.field("event_subscription", &self.event_subscription);
        formatter.finish()
    }
}
/// See [`RemoveSourceIdentifierFromSubscriptionOutput`](crate::output::RemoveSourceIdentifierFromSubscriptionOutput)
pub mod remove_source_identifier_from_subscription_output {
    /// A builder for [`RemoveSourceIdentifierFromSubscriptionOutput`](crate::output::RemoveSourceIdentifierFromSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_subscription: std::option::Option<crate::model::EventSubscription>,
    }
    impl Builder {
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn event_subscription(mut self, input: crate::model::EventSubscription) -> Self {
            self.event_subscription = Some(input);
            self
        }
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn set_event_subscription(
            mut self,
            input: std::option::Option<crate::model::EventSubscription>,
        ) -> Self {
            self.event_subscription = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveSourceIdentifierFromSubscriptionOutput`](crate::output::RemoveSourceIdentifierFromSubscriptionOutput)
        pub fn build(self) -> crate::output::RemoveSourceIdentifierFromSubscriptionOutput {
            crate::output::RemoveSourceIdentifierFromSubscriptionOutput {
                event_subscription: self.event_subscription,
            }
        }
    }
}
impl RemoveSourceIdentifierFromSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`RemoveSourceIdentifierFromSubscriptionOutput`](crate::output::RemoveSourceIdentifierFromSubscriptionOutput)
    pub fn builder() -> crate::output::remove_source_identifier_from_subscription_output::Builder {
        crate::output::remove_source_identifier_from_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveRoleFromDbClusterOutput {}
impl std::fmt::Debug for RemoveRoleFromDbClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveRoleFromDbClusterOutput");
        formatter.finish()
    }
}
/// See [`RemoveRoleFromDbClusterOutput`](crate::output::RemoveRoleFromDbClusterOutput)
pub mod remove_role_from_db_cluster_output {
    /// A builder for [`RemoveRoleFromDbClusterOutput`](crate::output::RemoveRoleFromDbClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveRoleFromDbClusterOutput`](crate::output::RemoveRoleFromDbClusterOutput)
        pub fn build(self) -> crate::output::RemoveRoleFromDbClusterOutput {
            crate::output::RemoveRoleFromDbClusterOutput {}
        }
    }
}
impl RemoveRoleFromDbClusterOutput {
    /// Creates a new builder-style object to manufacture [`RemoveRoleFromDbClusterOutput`](crate::output::RemoveRoleFromDbClusterOutput)
    pub fn builder() -> crate::output::remove_role_from_db_cluster_output::Builder {
        crate::output::remove_role_from_db_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebootDbInstanceOutput {
    /// <p>Contains the details of an Amazon Neptune DB instance.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
    pub db_instance: std::option::Option<crate::model::DbInstance>,
}
impl RebootDbInstanceOutput {
    /// <p>Contains the details of an Amazon Neptune DB instance.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
    pub fn db_instance(&self) -> std::option::Option<&crate::model::DbInstance> {
        self.db_instance.as_ref()
    }
}
impl std::fmt::Debug for RebootDbInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebootDbInstanceOutput");
        formatter.field("db_instance", &self.db_instance);
        formatter.finish()
    }
}
/// See [`RebootDbInstanceOutput`](crate::output::RebootDbInstanceOutput)
pub mod reboot_db_instance_output {
    /// A builder for [`RebootDbInstanceOutput`](crate::output::RebootDbInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance: std::option::Option<crate::model::DbInstance>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Neptune DB instance.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
        pub fn db_instance(mut self, input: crate::model::DbInstance) -> Self {
            self.db_instance = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Neptune DB instance.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
        pub fn set_db_instance(
            mut self,
            input: std::option::Option<crate::model::DbInstance>,
        ) -> Self {
            self.db_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`RebootDbInstanceOutput`](crate::output::RebootDbInstanceOutput)
        pub fn build(self) -> crate::output::RebootDbInstanceOutput {
            crate::output::RebootDbInstanceOutput {
                db_instance: self.db_instance,
            }
        }
    }
}
impl RebootDbInstanceOutput {
    /// Creates a new builder-style object to manufacture [`RebootDbInstanceOutput`](crate::output::RebootDbInstanceOutput)
    pub fn builder() -> crate::output::reboot_db_instance_output::Builder {
        crate::output::reboot_db_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PromoteReadReplicaDbClusterOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    pub db_cluster: std::option::Option<crate::model::DbCluster>,
}
impl PromoteReadReplicaDbClusterOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    pub fn db_cluster(&self) -> std::option::Option<&crate::model::DbCluster> {
        self.db_cluster.as_ref()
    }
}
impl std::fmt::Debug for PromoteReadReplicaDbClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PromoteReadReplicaDbClusterOutput");
        formatter.field("db_cluster", &self.db_cluster);
        formatter.finish()
    }
}
/// See [`PromoteReadReplicaDbClusterOutput`](crate::output::PromoteReadReplicaDbClusterOutput)
pub mod promote_read_replica_db_cluster_output {
    /// A builder for [`PromoteReadReplicaDbClusterOutput`](crate::output::PromoteReadReplicaDbClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster: std::option::Option<crate::model::DbCluster>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
        pub fn db_cluster(mut self, input: crate::model::DbCluster) -> Self {
            self.db_cluster = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
        pub fn set_db_cluster(
            mut self,
            input: std::option::Option<crate::model::DbCluster>,
        ) -> Self {
            self.db_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`PromoteReadReplicaDbClusterOutput`](crate::output::PromoteReadReplicaDbClusterOutput)
        pub fn build(self) -> crate::output::PromoteReadReplicaDbClusterOutput {
            crate::output::PromoteReadReplicaDbClusterOutput {
                db_cluster: self.db_cluster,
            }
        }
    }
}
impl PromoteReadReplicaDbClusterOutput {
    /// Creates a new builder-style object to manufacture [`PromoteReadReplicaDbClusterOutput`](crate::output::PromoteReadReplicaDbClusterOutput)
    pub fn builder() -> crate::output::promote_read_replica_db_cluster_output::Builder {
        crate::output::promote_read_replica_db_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyEventSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub event_subscription: std::option::Option<crate::model::EventSubscription>,
}
impl ModifyEventSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub fn event_subscription(&self) -> std::option::Option<&crate::model::EventSubscription> {
        self.event_subscription.as_ref()
    }
}
impl std::fmt::Debug for ModifyEventSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyEventSubscriptionOutput");
        formatter.field("event_subscription", &self.event_subscription);
        formatter.finish()
    }
}
/// See [`ModifyEventSubscriptionOutput`](crate::output::ModifyEventSubscriptionOutput)
pub mod modify_event_subscription_output {
    /// A builder for [`ModifyEventSubscriptionOutput`](crate::output::ModifyEventSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_subscription: std::option::Option<crate::model::EventSubscription>,
    }
    impl Builder {
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn event_subscription(mut self, input: crate::model::EventSubscription) -> Self {
            self.event_subscription = Some(input);
            self
        }
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn set_event_subscription(
            mut self,
            input: std::option::Option<crate::model::EventSubscription>,
        ) -> Self {
            self.event_subscription = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyEventSubscriptionOutput`](crate::output::ModifyEventSubscriptionOutput)
        pub fn build(self) -> crate::output::ModifyEventSubscriptionOutput {
            crate::output::ModifyEventSubscriptionOutput {
                event_subscription: self.event_subscription,
            }
        }
    }
}
impl ModifyEventSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`ModifyEventSubscriptionOutput`](crate::output::ModifyEventSubscriptionOutput)
    pub fn builder() -> crate::output::modify_event_subscription_output::Builder {
        crate::output::modify_event_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbSubnetGroupOutput {
    /// <p>Contains the details of an Amazon Neptune DB subnet group.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBSubnetGroups</code> action.</p>
    pub db_subnet_group: std::option::Option<crate::model::DbSubnetGroup>,
}
impl ModifyDbSubnetGroupOutput {
    /// <p>Contains the details of an Amazon Neptune DB subnet group.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBSubnetGroups</code> action.</p>
    pub fn db_subnet_group(&self) -> std::option::Option<&crate::model::DbSubnetGroup> {
        self.db_subnet_group.as_ref()
    }
}
impl std::fmt::Debug for ModifyDbSubnetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbSubnetGroupOutput");
        formatter.field("db_subnet_group", &self.db_subnet_group);
        formatter.finish()
    }
}
/// See [`ModifyDbSubnetGroupOutput`](crate::output::ModifyDbSubnetGroupOutput)
pub mod modify_db_subnet_group_output {
    /// A builder for [`ModifyDbSubnetGroupOutput`](crate::output::ModifyDbSubnetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_subnet_group: std::option::Option<crate::model::DbSubnetGroup>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Neptune DB subnet group.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBSubnetGroups</code> action.</p>
        pub fn db_subnet_group(mut self, input: crate::model::DbSubnetGroup) -> Self {
            self.db_subnet_group = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Neptune DB subnet group.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBSubnetGroups</code> action.</p>
        pub fn set_db_subnet_group(
            mut self,
            input: std::option::Option<crate::model::DbSubnetGroup>,
        ) -> Self {
            self.db_subnet_group = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbSubnetGroupOutput`](crate::output::ModifyDbSubnetGroupOutput)
        pub fn build(self) -> crate::output::ModifyDbSubnetGroupOutput {
            crate::output::ModifyDbSubnetGroupOutput {
                db_subnet_group: self.db_subnet_group,
            }
        }
    }
}
impl ModifyDbSubnetGroupOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDbSubnetGroupOutput`](crate::output::ModifyDbSubnetGroupOutput)
    pub fn builder() -> crate::output::modify_db_subnet_group_output::Builder {
        crate::output::modify_db_subnet_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbParameterGroupOutput {
    /// <p>Provides the name of the DB parameter group.</p>
    pub db_parameter_group_name: std::option::Option<std::string::String>,
}
impl ModifyDbParameterGroupOutput {
    /// <p>Provides the name of the DB parameter group.</p>
    pub fn db_parameter_group_name(&self) -> std::option::Option<&str> {
        self.db_parameter_group_name.as_deref()
    }
}
impl std::fmt::Debug for ModifyDbParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbParameterGroupOutput");
        formatter.field("db_parameter_group_name", &self.db_parameter_group_name);
        formatter.finish()
    }
}
/// See [`ModifyDbParameterGroupOutput`](crate::output::ModifyDbParameterGroupOutput)
pub mod modify_db_parameter_group_output {
    /// A builder for [`ModifyDbParameterGroupOutput`](crate::output::ModifyDbParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Provides the name of the DB parameter group.</p>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>Provides the name of the DB parameter group.</p>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbParameterGroupOutput`](crate::output::ModifyDbParameterGroupOutput)
        pub fn build(self) -> crate::output::ModifyDbParameterGroupOutput {
            crate::output::ModifyDbParameterGroupOutput {
                db_parameter_group_name: self.db_parameter_group_name,
            }
        }
    }
}
impl ModifyDbParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDbParameterGroupOutput`](crate::output::ModifyDbParameterGroupOutput)
    pub fn builder() -> crate::output::modify_db_parameter_group_output::Builder {
        crate::output::modify_db_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbInstanceOutput {
    /// <p>Contains the details of an Amazon Neptune DB instance.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
    pub db_instance: std::option::Option<crate::model::DbInstance>,
}
impl ModifyDbInstanceOutput {
    /// <p>Contains the details of an Amazon Neptune DB instance.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
    pub fn db_instance(&self) -> std::option::Option<&crate::model::DbInstance> {
        self.db_instance.as_ref()
    }
}
impl std::fmt::Debug for ModifyDbInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbInstanceOutput");
        formatter.field("db_instance", &self.db_instance);
        formatter.finish()
    }
}
/// See [`ModifyDbInstanceOutput`](crate::output::ModifyDbInstanceOutput)
pub mod modify_db_instance_output {
    /// A builder for [`ModifyDbInstanceOutput`](crate::output::ModifyDbInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance: std::option::Option<crate::model::DbInstance>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Neptune DB instance.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
        pub fn db_instance(mut self, input: crate::model::DbInstance) -> Self {
            self.db_instance = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Neptune DB instance.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
        pub fn set_db_instance(
            mut self,
            input: std::option::Option<crate::model::DbInstance>,
        ) -> Self {
            self.db_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbInstanceOutput`](crate::output::ModifyDbInstanceOutput)
        pub fn build(self) -> crate::output::ModifyDbInstanceOutput {
            crate::output::ModifyDbInstanceOutput {
                db_instance: self.db_instance,
            }
        }
    }
}
impl ModifyDbInstanceOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDbInstanceOutput`](crate::output::ModifyDbInstanceOutput)
    pub fn builder() -> crate::output::modify_db_instance_output::Builder {
        crate::output::modify_db_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbClusterSnapshotAttributeOutput {
    /// <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code> API action.</p>
    /// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon accounts to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
    pub db_cluster_snapshot_attributes_result:
        std::option::Option<crate::model::DbClusterSnapshotAttributesResult>,
}
impl ModifyDbClusterSnapshotAttributeOutput {
    /// <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code> API action.</p>
    /// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon accounts to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
    pub fn db_cluster_snapshot_attributes_result(
        &self,
    ) -> std::option::Option<&crate::model::DbClusterSnapshotAttributesResult> {
        self.db_cluster_snapshot_attributes_result.as_ref()
    }
}
impl std::fmt::Debug for ModifyDbClusterSnapshotAttributeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbClusterSnapshotAttributeOutput");
        formatter.field(
            "db_cluster_snapshot_attributes_result",
            &self.db_cluster_snapshot_attributes_result,
        );
        formatter.finish()
    }
}
/// See [`ModifyDbClusterSnapshotAttributeOutput`](crate::output::ModifyDbClusterSnapshotAttributeOutput)
pub mod modify_db_cluster_snapshot_attribute_output {
    /// A builder for [`ModifyDbClusterSnapshotAttributeOutput`](crate::output::ModifyDbClusterSnapshotAttributeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot_attributes_result:
            std::option::Option<crate::model::DbClusterSnapshotAttributesResult>,
    }
    impl Builder {
        /// <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code> API action.</p>
        /// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon accounts to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
        pub fn db_cluster_snapshot_attributes_result(
            mut self,
            input: crate::model::DbClusterSnapshotAttributesResult,
        ) -> Self {
            self.db_cluster_snapshot_attributes_result = Some(input);
            self
        }
        /// <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code> API action.</p>
        /// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon accounts to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
        pub fn set_db_cluster_snapshot_attributes_result(
            mut self,
            input: std::option::Option<crate::model::DbClusterSnapshotAttributesResult>,
        ) -> Self {
            self.db_cluster_snapshot_attributes_result = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbClusterSnapshotAttributeOutput`](crate::output::ModifyDbClusterSnapshotAttributeOutput)
        pub fn build(self) -> crate::output::ModifyDbClusterSnapshotAttributeOutput {
            crate::output::ModifyDbClusterSnapshotAttributeOutput {
                db_cluster_snapshot_attributes_result: self.db_cluster_snapshot_attributes_result,
            }
        }
    }
}
impl ModifyDbClusterSnapshotAttributeOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterSnapshotAttributeOutput`](crate::output::ModifyDbClusterSnapshotAttributeOutput)
    pub fn builder() -> crate::output::modify_db_cluster_snapshot_attribute_output::Builder {
        crate::output::modify_db_cluster_snapshot_attribute_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbClusterParameterGroupOutput {
    /// <p>The name of the DB cluster parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li> <p>Must be 1 to 255 letters or numbers.</p> </li>
    /// <li> <p>First character must be a letter</p> </li>
    /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
    /// </ul> <note>
    /// <p>This value is stored as a lowercase string.</p>
    /// </note>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
}
impl ModifyDbClusterParameterGroupOutput {
    /// <p>The name of the DB cluster parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li> <p>Must be 1 to 255 letters or numbers.</p> </li>
    /// <li> <p>First character must be a letter</p> </li>
    /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
    /// </ul> <note>
    /// <p>This value is stored as a lowercase string.</p>
    /// </note>
    pub fn db_cluster_parameter_group_name(&self) -> std::option::Option<&str> {
        self.db_cluster_parameter_group_name.as_deref()
    }
}
impl std::fmt::Debug for ModifyDbClusterParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbClusterParameterGroupOutput");
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.finish()
    }
}
/// See [`ModifyDbClusterParameterGroupOutput`](crate::output::ModifyDbClusterParameterGroupOutput)
pub mod modify_db_cluster_parameter_group_output {
    /// A builder for [`ModifyDbClusterParameterGroupOutput`](crate::output::ModifyDbClusterParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters or numbers.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul> <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters or numbers.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul> <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbClusterParameterGroupOutput`](crate::output::ModifyDbClusterParameterGroupOutput)
        pub fn build(self) -> crate::output::ModifyDbClusterParameterGroupOutput {
            crate::output::ModifyDbClusterParameterGroupOutput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
            }
        }
    }
}
impl ModifyDbClusterParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterParameterGroupOutput`](crate::output::ModifyDbClusterParameterGroupOutput)
    pub fn builder() -> crate::output::modify_db_cluster_parameter_group_output::Builder {
        crate::output::modify_db_cluster_parameter_group_output::Builder::default()
    }
}

/// <p>This data type represents the information you need to connect to an Amazon Aurora DB cluster. This data type is used as a response element in the following actions:</p>
/// <ul>
/// <li> <p> <code>CreateDBClusterEndpoint</code> </p> </li>
/// <li> <p> <code>DescribeDBClusterEndpoints</code> </p> </li>
/// <li> <p> <code>ModifyDBClusterEndpoint</code> </p> </li>
/// <li> <p> <code>DeleteDBClusterEndpoint</code> </p> </li>
/// </ul>
/// <p>For the data structure that represents Amazon RDS DB instance endpoints, see <code>Endpoint</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbClusterEndpointOutput {
    /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
    /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    pub db_cluster_endpoint_resource_identifier: std::option::Option<std::string::String>,
    /// <p>The DNS address of the endpoint.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    pub endpoint_type: std::option::Option<std::string::String>,
    /// <p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    pub custom_endpoint_type: std::option::Option<std::string::String>,
    /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    pub static_members: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
    pub excluded_members: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    pub db_cluster_endpoint_arn: std::option::Option<std::string::String>,
}
impl ModifyDbClusterEndpointOutput {
    /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub fn db_cluster_endpoint_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_endpoint_identifier.as_deref()
    }
    /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    pub fn db_cluster_endpoint_resource_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_endpoint_resource_identifier.as_deref()
    }
    /// <p>The DNS address of the endpoint.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    pub fn endpoint_type(&self) -> std::option::Option<&str> {
        self.endpoint_type.as_deref()
    }
    /// <p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    pub fn custom_endpoint_type(&self) -> std::option::Option<&str> {
        self.custom_endpoint_type.as_deref()
    }
    /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    pub fn static_members(&self) -> std::option::Option<&[std::string::String]> {
        self.static_members.as_deref()
    }
    /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
    pub fn excluded_members(&self) -> std::option::Option<&[std::string::String]> {
        self.excluded_members.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    pub fn db_cluster_endpoint_arn(&self) -> std::option::Option<&str> {
        self.db_cluster_endpoint_arn.as_deref()
    }
}
impl std::fmt::Debug for ModifyDbClusterEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbClusterEndpointOutput");
        formatter.field(
            "db_cluster_endpoint_identifier",
            &self.db_cluster_endpoint_identifier,
        );
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field(
            "db_cluster_endpoint_resource_identifier",
            &self.db_cluster_endpoint_resource_identifier,
        );
        formatter.field("endpoint", &self.endpoint);
        formatter.field("status", &self.status);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("custom_endpoint_type", &self.custom_endpoint_type);
        formatter.field("static_members", &self.static_members);
        formatter.field("excluded_members", &self.excluded_members);
        formatter.field("db_cluster_endpoint_arn", &self.db_cluster_endpoint_arn);
        formatter.finish()
    }
}
/// See [`ModifyDbClusterEndpointOutput`](crate::output::ModifyDbClusterEndpointOutput)
pub mod modify_db_cluster_endpoint_output {
    /// A builder for [`ModifyDbClusterEndpointOutput`](crate::output::ModifyDbClusterEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_endpoint_resource_identifier:
            std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<std::string::String>,
        pub(crate) custom_endpoint_type: std::option::Option<std::string::String>,
        pub(crate) static_members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) excluded_members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_cluster_endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = Some(input.into());
            self
        }
        /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = input;
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
        pub fn db_cluster_endpoint_resource_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_resource_identifier = Some(input.into());
            self
        }
        /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
        pub fn set_db_cluster_endpoint_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_resource_identifier = input;
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
        pub fn endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_type = Some(input.into());
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn custom_endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_endpoint_type = Some(input.into());
            self
        }
        /// <p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn set_custom_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_endpoint_type = input;
            self
        }
        /// Appends an item to `static_members`.
        ///
        /// To override the contents of this collection use [`set_static_members`](Self::set_static_members).
        ///
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn static_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.static_members.unwrap_or_default();
            v.push(input.into());
            self.static_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn set_static_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.static_members = input;
            self
        }
        /// Appends an item to `excluded_members`.
        ///
        /// To override the contents of this collection use [`set_excluded_members`](Self::set_excluded_members).
        ///
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
        pub fn excluded_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.excluded_members.unwrap_or_default();
            v.push(input.into());
            self.excluded_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
        pub fn set_excluded_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.excluded_members = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
        pub fn db_cluster_endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
        pub fn set_db_cluster_endpoint_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbClusterEndpointOutput`](crate::output::ModifyDbClusterEndpointOutput)
        pub fn build(self) -> crate::output::ModifyDbClusterEndpointOutput {
            crate::output::ModifyDbClusterEndpointOutput {
                db_cluster_endpoint_identifier: self.db_cluster_endpoint_identifier,
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_endpoint_resource_identifier: self
                    .db_cluster_endpoint_resource_identifier,
                endpoint: self.endpoint,
                status: self.status,
                endpoint_type: self.endpoint_type,
                custom_endpoint_type: self.custom_endpoint_type,
                static_members: self.static_members,
                excluded_members: self.excluded_members,
                db_cluster_endpoint_arn: self.db_cluster_endpoint_arn,
            }
        }
    }
}
impl ModifyDbClusterEndpointOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterEndpointOutput`](crate::output::ModifyDbClusterEndpointOutput)
    pub fn builder() -> crate::output::modify_db_cluster_endpoint_output::Builder {
        crate::output::modify_db_cluster_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbClusterOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    pub db_cluster: std::option::Option<crate::model::DbCluster>,
}
impl ModifyDbClusterOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    pub fn db_cluster(&self) -> std::option::Option<&crate::model::DbCluster> {
        self.db_cluster.as_ref()
    }
}
impl std::fmt::Debug for ModifyDbClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbClusterOutput");
        formatter.field("db_cluster", &self.db_cluster);
        formatter.finish()
    }
}
/// See [`ModifyDbClusterOutput`](crate::output::ModifyDbClusterOutput)
pub mod modify_db_cluster_output {
    /// A builder for [`ModifyDbClusterOutput`](crate::output::ModifyDbClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster: std::option::Option<crate::model::DbCluster>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
        pub fn db_cluster(mut self, input: crate::model::DbCluster) -> Self {
            self.db_cluster = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
        pub fn set_db_cluster(
            mut self,
            input: std::option::Option<crate::model::DbCluster>,
        ) -> Self {
            self.db_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbClusterOutput`](crate::output::ModifyDbClusterOutput)
        pub fn build(self) -> crate::output::ModifyDbClusterOutput {
            crate::output::ModifyDbClusterOutput {
                db_cluster: self.db_cluster,
            }
        }
    }
}
impl ModifyDbClusterOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterOutput`](crate::output::ModifyDbClusterOutput)
    pub fn builder() -> crate::output::modify_db_cluster_output::Builder {
        crate::output::modify_db_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>List of tags returned by the ListTagsForResource operation.</p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>List of tags returned by the ListTagsForResource operation.</p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>List of tags returned by the ListTagsForResource operation.</p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input);
            self.tag_list = Some(v);
            self
        }
        /// <p>List of tags returned by the ListTagsForResource operation.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tag_list: self.tag_list,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailoverDbClusterOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    pub db_cluster: std::option::Option<crate::model::DbCluster>,
}
impl FailoverDbClusterOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    pub fn db_cluster(&self) -> std::option::Option<&crate::model::DbCluster> {
        self.db_cluster.as_ref()
    }
}
impl std::fmt::Debug for FailoverDbClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailoverDbClusterOutput");
        formatter.field("db_cluster", &self.db_cluster);
        formatter.finish()
    }
}
/// See [`FailoverDbClusterOutput`](crate::output::FailoverDbClusterOutput)
pub mod failover_db_cluster_output {
    /// A builder for [`FailoverDbClusterOutput`](crate::output::FailoverDbClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster: std::option::Option<crate::model::DbCluster>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
        pub fn db_cluster(mut self, input: crate::model::DbCluster) -> Self {
            self.db_cluster = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
        pub fn set_db_cluster(
            mut self,
            input: std::option::Option<crate::model::DbCluster>,
        ) -> Self {
            self.db_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`FailoverDbClusterOutput`](crate::output::FailoverDbClusterOutput)
        pub fn build(self) -> crate::output::FailoverDbClusterOutput {
            crate::output::FailoverDbClusterOutput {
                db_cluster: self.db_cluster,
            }
        }
    }
}
impl FailoverDbClusterOutput {
    /// Creates a new builder-style object to manufacture [`FailoverDbClusterOutput`](crate::output::FailoverDbClusterOutput)
    pub fn builder() -> crate::output::failover_db_cluster_output::Builder {
        crate::output::failover_db_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeValidDbInstanceModificationsOutput {
    /// <p>Information about valid modifications that you can make to your DB instance. Contains the result of a successful call to the <code>DescribeValidDBInstanceModifications</code> action. You can use this information when you call <code>ModifyDBInstance</code>. </p>
    pub valid_db_instance_modifications_message:
        std::option::Option<crate::model::ValidDbInstanceModificationsMessage>,
}
impl DescribeValidDbInstanceModificationsOutput {
    /// <p>Information about valid modifications that you can make to your DB instance. Contains the result of a successful call to the <code>DescribeValidDBInstanceModifications</code> action. You can use this information when you call <code>ModifyDBInstance</code>. </p>
    pub fn valid_db_instance_modifications_message(
        &self,
    ) -> std::option::Option<&crate::model::ValidDbInstanceModificationsMessage> {
        self.valid_db_instance_modifications_message.as_ref()
    }
}
impl std::fmt::Debug for DescribeValidDbInstanceModificationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeValidDbInstanceModificationsOutput");
        formatter.field(
            "valid_db_instance_modifications_message",
            &self.valid_db_instance_modifications_message,
        );
        formatter.finish()
    }
}
/// See [`DescribeValidDbInstanceModificationsOutput`](crate::output::DescribeValidDbInstanceModificationsOutput)
pub mod describe_valid_db_instance_modifications_output {
    /// A builder for [`DescribeValidDbInstanceModificationsOutput`](crate::output::DescribeValidDbInstanceModificationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) valid_db_instance_modifications_message:
            std::option::Option<crate::model::ValidDbInstanceModificationsMessage>,
    }
    impl Builder {
        /// <p>Information about valid modifications that you can make to your DB instance. Contains the result of a successful call to the <code>DescribeValidDBInstanceModifications</code> action. You can use this information when you call <code>ModifyDBInstance</code>. </p>
        pub fn valid_db_instance_modifications_message(
            mut self,
            input: crate::model::ValidDbInstanceModificationsMessage,
        ) -> Self {
            self.valid_db_instance_modifications_message = Some(input);
            self
        }
        /// <p>Information about valid modifications that you can make to your DB instance. Contains the result of a successful call to the <code>DescribeValidDBInstanceModifications</code> action. You can use this information when you call <code>ModifyDBInstance</code>. </p>
        pub fn set_valid_db_instance_modifications_message(
            mut self,
            input: std::option::Option<crate::model::ValidDbInstanceModificationsMessage>,
        ) -> Self {
            self.valid_db_instance_modifications_message = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeValidDbInstanceModificationsOutput`](crate::output::DescribeValidDbInstanceModificationsOutput)
        pub fn build(self) -> crate::output::DescribeValidDbInstanceModificationsOutput {
            crate::output::DescribeValidDbInstanceModificationsOutput {
                valid_db_instance_modifications_message: self
                    .valid_db_instance_modifications_message,
            }
        }
    }
}
impl DescribeValidDbInstanceModificationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeValidDbInstanceModificationsOutput`](crate::output::DescribeValidDbInstanceModificationsOutput)
    pub fn builder() -> crate::output::describe_valid_db_instance_modifications_output::Builder {
        crate::output::describe_valid_db_instance_modifications_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePendingMaintenanceActionsOutput {
    /// <p>A list of the pending maintenance actions for the resource.</p>
    pub pending_maintenance_actions:
        std::option::Option<std::vec::Vec<crate::model::ResourcePendingMaintenanceActions>>,
    /// <p> An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribePendingMaintenanceActionsOutput {
    /// <p>A list of the pending maintenance actions for the resource.</p>
    pub fn pending_maintenance_actions(
        &self,
    ) -> std::option::Option<&[crate::model::ResourcePendingMaintenanceActions]> {
        self.pending_maintenance_actions.as_deref()
    }
    /// <p> An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribePendingMaintenanceActionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePendingMaintenanceActionsOutput");
        formatter.field(
            "pending_maintenance_actions",
            &self.pending_maintenance_actions,
        );
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribePendingMaintenanceActionsOutput`](crate::output::DescribePendingMaintenanceActionsOutput)
pub mod describe_pending_maintenance_actions_output {
    /// A builder for [`DescribePendingMaintenanceActionsOutput`](crate::output::DescribePendingMaintenanceActionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pending_maintenance_actions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePendingMaintenanceActions>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `pending_maintenance_actions`.
        ///
        /// To override the contents of this collection use [`set_pending_maintenance_actions`](Self::set_pending_maintenance_actions).
        ///
        /// <p>A list of the pending maintenance actions for the resource.</p>
        pub fn pending_maintenance_actions(
            mut self,
            input: crate::model::ResourcePendingMaintenanceActions,
        ) -> Self {
            let mut v = self.pending_maintenance_actions.unwrap_or_default();
            v.push(input);
            self.pending_maintenance_actions = Some(v);
            self
        }
        /// <p>A list of the pending maintenance actions for the resource.</p>
        pub fn set_pending_maintenance_actions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ResourcePendingMaintenanceActions>,
            >,
        ) -> Self {
            self.pending_maintenance_actions = input;
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePendingMaintenanceActionsOutput`](crate::output::DescribePendingMaintenanceActionsOutput)
        pub fn build(self) -> crate::output::DescribePendingMaintenanceActionsOutput {
            crate::output::DescribePendingMaintenanceActionsOutput {
                pending_maintenance_actions: self.pending_maintenance_actions,
                marker: self.marker,
            }
        }
    }
}
impl DescribePendingMaintenanceActionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribePendingMaintenanceActionsOutput`](crate::output::DescribePendingMaintenanceActionsOutput)
    pub fn builder() -> crate::output::describe_pending_maintenance_actions_output::Builder {
        crate::output::describe_pending_maintenance_actions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrderableDbInstanceOptionsOutput {
    /// <p>An <code>OrderableDBInstanceOption</code> structure containing information about orderable options for the DB instance.</p>
    pub orderable_db_instance_options:
        std::option::Option<std::vec::Vec<crate::model::OrderableDbInstanceOption>>,
    /// <p> An optional pagination token provided by a previous OrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeOrderableDbInstanceOptionsOutput {
    /// <p>An <code>OrderableDBInstanceOption</code> structure containing information about orderable options for the DB instance.</p>
    pub fn orderable_db_instance_options(
        &self,
    ) -> std::option::Option<&[crate::model::OrderableDbInstanceOption]> {
        self.orderable_db_instance_options.as_deref()
    }
    /// <p> An optional pagination token provided by a previous OrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeOrderableDbInstanceOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrderableDbInstanceOptionsOutput");
        formatter.field(
            "orderable_db_instance_options",
            &self.orderable_db_instance_options,
        );
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeOrderableDbInstanceOptionsOutput`](crate::output::DescribeOrderableDbInstanceOptionsOutput)
pub mod describe_orderable_db_instance_options_output {
    /// A builder for [`DescribeOrderableDbInstanceOptionsOutput`](crate::output::DescribeOrderableDbInstanceOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) orderable_db_instance_options:
            std::option::Option<std::vec::Vec<crate::model::OrderableDbInstanceOption>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `orderable_db_instance_options`.
        ///
        /// To override the contents of this collection use [`set_orderable_db_instance_options`](Self::set_orderable_db_instance_options).
        ///
        /// <p>An <code>OrderableDBInstanceOption</code> structure containing information about orderable options for the DB instance.</p>
        pub fn orderable_db_instance_options(
            mut self,
            input: crate::model::OrderableDbInstanceOption,
        ) -> Self {
            let mut v = self.orderable_db_instance_options.unwrap_or_default();
            v.push(input);
            self.orderable_db_instance_options = Some(v);
            self
        }
        /// <p>An <code>OrderableDBInstanceOption</code> structure containing information about orderable options for the DB instance.</p>
        pub fn set_orderable_db_instance_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OrderableDbInstanceOption>>,
        ) -> Self {
            self.orderable_db_instance_options = input;
            self
        }
        /// <p> An optional pagination token provided by a previous OrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous OrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrderableDbInstanceOptionsOutput`](crate::output::DescribeOrderableDbInstanceOptionsOutput)
        pub fn build(self) -> crate::output::DescribeOrderableDbInstanceOptionsOutput {
            crate::output::DescribeOrderableDbInstanceOptionsOutput {
                orderable_db_instance_options: self.orderable_db_instance_options,
                marker: self.marker,
            }
        }
    }
}
impl DescribeOrderableDbInstanceOptionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeOrderableDbInstanceOptionsOutput`](crate::output::DescribeOrderableDbInstanceOptionsOutput)
    pub fn builder() -> crate::output::describe_orderable_db_instance_options_output::Builder {
        crate::output::describe_orderable_db_instance_options_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventSubscriptionsOutput {
    /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of EventSubscriptions data types.</p>
    pub event_subscriptions_list:
        std::option::Option<std::vec::Vec<crate::model::EventSubscription>>,
}
impl DescribeEventSubscriptionsOutput {
    /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of EventSubscriptions data types.</p>
    pub fn event_subscriptions_list(
        &self,
    ) -> std::option::Option<&[crate::model::EventSubscription]> {
        self.event_subscriptions_list.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventSubscriptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventSubscriptionsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("event_subscriptions_list", &self.event_subscriptions_list);
        formatter.finish()
    }
}
/// See [`DescribeEventSubscriptionsOutput`](crate::output::DescribeEventSubscriptionsOutput)
pub mod describe_event_subscriptions_output {
    /// A builder for [`DescribeEventSubscriptionsOutput`](crate::output::DescribeEventSubscriptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) event_subscriptions_list:
            std::option::Option<std::vec::Vec<crate::model::EventSubscription>>,
    }
    impl Builder {
        /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `event_subscriptions_list`.
        ///
        /// To override the contents of this collection use [`set_event_subscriptions_list`](Self::set_event_subscriptions_list).
        ///
        /// <p>A list of EventSubscriptions data types.</p>
        pub fn event_subscriptions_list(mut self, input: crate::model::EventSubscription) -> Self {
            let mut v = self.event_subscriptions_list.unwrap_or_default();
            v.push(input);
            self.event_subscriptions_list = Some(v);
            self
        }
        /// <p>A list of EventSubscriptions data types.</p>
        pub fn set_event_subscriptions_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventSubscription>>,
        ) -> Self {
            self.event_subscriptions_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventSubscriptionsOutput`](crate::output::DescribeEventSubscriptionsOutput)
        pub fn build(self) -> crate::output::DescribeEventSubscriptionsOutput {
            crate::output::DescribeEventSubscriptionsOutput {
                marker: self.marker,
                event_subscriptions_list: self.event_subscriptions_list,
            }
        }
    }
}
impl DescribeEventSubscriptionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEventSubscriptionsOutput`](crate::output::DescribeEventSubscriptionsOutput)
    pub fn builder() -> crate::output::describe_event_subscriptions_output::Builder {
        crate::output::describe_event_subscriptions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventsOutput {
    /// <p> An optional pagination token provided by a previous Events request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p> A list of <code>Event</code> instances.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::Event>>,
}
impl DescribeEventsOutput {
    /// <p> An optional pagination token provided by a previous Events request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p> A list of <code>Event</code> instances.</p>
    pub fn events(&self) -> std::option::Option<&[crate::model::Event]> {
        self.events.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("events", &self.events);
        formatter.finish()
    }
}
/// See [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
pub mod describe_events_output {
    /// A builder for [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::Event>>,
    }
    impl Builder {
        /// <p> An optional pagination token provided by a previous Events request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous Events request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p> A list of <code>Event</code> instances.</p>
        pub fn events(mut self, input: crate::model::Event) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input);
            self.events = Some(v);
            self
        }
        /// <p> A list of <code>Event</code> instances.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Event>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
        pub fn build(self) -> crate::output::DescribeEventsOutput {
            crate::output::DescribeEventsOutput {
                marker: self.marker,
                events: self.events,
            }
        }
    }
}
impl DescribeEventsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
    pub fn builder() -> crate::output::describe_events_output::Builder {
        crate::output::describe_events_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventCategoriesOutput {
    /// <p>A list of EventCategoriesMap data types.</p>
    pub event_categories_map_list:
        std::option::Option<std::vec::Vec<crate::model::EventCategoriesMap>>,
}
impl DescribeEventCategoriesOutput {
    /// <p>A list of EventCategoriesMap data types.</p>
    pub fn event_categories_map_list(
        &self,
    ) -> std::option::Option<&[crate::model::EventCategoriesMap]> {
        self.event_categories_map_list.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventCategoriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventCategoriesOutput");
        formatter.field("event_categories_map_list", &self.event_categories_map_list);
        formatter.finish()
    }
}
/// See [`DescribeEventCategoriesOutput`](crate::output::DescribeEventCategoriesOutput)
pub mod describe_event_categories_output {
    /// A builder for [`DescribeEventCategoriesOutput`](crate::output::DescribeEventCategoriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_categories_map_list:
            std::option::Option<std::vec::Vec<crate::model::EventCategoriesMap>>,
    }
    impl Builder {
        /// Appends an item to `event_categories_map_list`.
        ///
        /// To override the contents of this collection use [`set_event_categories_map_list`](Self::set_event_categories_map_list).
        ///
        /// <p>A list of EventCategoriesMap data types.</p>
        pub fn event_categories_map_list(
            mut self,
            input: crate::model::EventCategoriesMap,
        ) -> Self {
            let mut v = self.event_categories_map_list.unwrap_or_default();
            v.push(input);
            self.event_categories_map_list = Some(v);
            self
        }
        /// <p>A list of EventCategoriesMap data types.</p>
        pub fn set_event_categories_map_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventCategoriesMap>>,
        ) -> Self {
            self.event_categories_map_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventCategoriesOutput`](crate::output::DescribeEventCategoriesOutput)
        pub fn build(self) -> crate::output::DescribeEventCategoriesOutput {
            crate::output::DescribeEventCategoriesOutput {
                event_categories_map_list: self.event_categories_map_list,
            }
        }
    }
}
impl DescribeEventCategoriesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEventCategoriesOutput`](crate::output::DescribeEventCategoriesOutput)
    pub fn builder() -> crate::output::describe_event_categories_output::Builder {
        crate::output::describe_event_categories_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEngineDefaultParametersOutput {
    /// <p> Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.</p>
    pub engine_defaults: std::option::Option<crate::model::EngineDefaults>,
}
impl DescribeEngineDefaultParametersOutput {
    /// <p> Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.</p>
    pub fn engine_defaults(&self) -> std::option::Option<&crate::model::EngineDefaults> {
        self.engine_defaults.as_ref()
    }
}
impl std::fmt::Debug for DescribeEngineDefaultParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEngineDefaultParametersOutput");
        formatter.field("engine_defaults", &self.engine_defaults);
        formatter.finish()
    }
}
/// See [`DescribeEngineDefaultParametersOutput`](crate::output::DescribeEngineDefaultParametersOutput)
pub mod describe_engine_default_parameters_output {
    /// A builder for [`DescribeEngineDefaultParametersOutput`](crate::output::DescribeEngineDefaultParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine_defaults: std::option::Option<crate::model::EngineDefaults>,
    }
    impl Builder {
        /// <p> Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.</p>
        pub fn engine_defaults(mut self, input: crate::model::EngineDefaults) -> Self {
            self.engine_defaults = Some(input);
            self
        }
        /// <p> Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.</p>
        pub fn set_engine_defaults(
            mut self,
            input: std::option::Option<crate::model::EngineDefaults>,
        ) -> Self {
            self.engine_defaults = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEngineDefaultParametersOutput`](crate::output::DescribeEngineDefaultParametersOutput)
        pub fn build(self) -> crate::output::DescribeEngineDefaultParametersOutput {
            crate::output::DescribeEngineDefaultParametersOutput {
                engine_defaults: self.engine_defaults,
            }
        }
    }
}
impl DescribeEngineDefaultParametersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEngineDefaultParametersOutput`](crate::output::DescribeEngineDefaultParametersOutput)
    pub fn builder() -> crate::output::describe_engine_default_parameters_output::Builder {
        crate::output::describe_engine_default_parameters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEngineDefaultClusterParametersOutput {
    /// <p> Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.</p>
    pub engine_defaults: std::option::Option<crate::model::EngineDefaults>,
}
impl DescribeEngineDefaultClusterParametersOutput {
    /// <p> Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.</p>
    pub fn engine_defaults(&self) -> std::option::Option<&crate::model::EngineDefaults> {
        self.engine_defaults.as_ref()
    }
}
impl std::fmt::Debug for DescribeEngineDefaultClusterParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEngineDefaultClusterParametersOutput");
        formatter.field("engine_defaults", &self.engine_defaults);
        formatter.finish()
    }
}
/// See [`DescribeEngineDefaultClusterParametersOutput`](crate::output::DescribeEngineDefaultClusterParametersOutput)
pub mod describe_engine_default_cluster_parameters_output {
    /// A builder for [`DescribeEngineDefaultClusterParametersOutput`](crate::output::DescribeEngineDefaultClusterParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine_defaults: std::option::Option<crate::model::EngineDefaults>,
    }
    impl Builder {
        /// <p> Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.</p>
        pub fn engine_defaults(mut self, input: crate::model::EngineDefaults) -> Self {
            self.engine_defaults = Some(input);
            self
        }
        /// <p> Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.</p>
        pub fn set_engine_defaults(
            mut self,
            input: std::option::Option<crate::model::EngineDefaults>,
        ) -> Self {
            self.engine_defaults = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEngineDefaultClusterParametersOutput`](crate::output::DescribeEngineDefaultClusterParametersOutput)
        pub fn build(self) -> crate::output::DescribeEngineDefaultClusterParametersOutput {
            crate::output::DescribeEngineDefaultClusterParametersOutput {
                engine_defaults: self.engine_defaults,
            }
        }
    }
}
impl DescribeEngineDefaultClusterParametersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEngineDefaultClusterParametersOutput`](crate::output::DescribeEngineDefaultClusterParametersOutput)
    pub fn builder() -> crate::output::describe_engine_default_cluster_parameters_output::Builder {
        crate::output::describe_engine_default_cluster_parameters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbSubnetGroupsOutput {
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p> A list of <code>DBSubnetGroup</code> instances.</p>
    pub db_subnet_groups: std::option::Option<std::vec::Vec<crate::model::DbSubnetGroup>>,
}
impl DescribeDbSubnetGroupsOutput {
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p> A list of <code>DBSubnetGroup</code> instances.</p>
    pub fn db_subnet_groups(&self) -> std::option::Option<&[crate::model::DbSubnetGroup]> {
        self.db_subnet_groups.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbSubnetGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbSubnetGroupsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("db_subnet_groups", &self.db_subnet_groups);
        formatter.finish()
    }
}
/// See [`DescribeDbSubnetGroupsOutput`](crate::output::DescribeDbSubnetGroupsOutput)
pub mod describe_db_subnet_groups_output {
    /// A builder for [`DescribeDbSubnetGroupsOutput`](crate::output::DescribeDbSubnetGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_subnet_groups:
            std::option::Option<std::vec::Vec<crate::model::DbSubnetGroup>>,
    }
    impl Builder {
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_subnet_groups`.
        ///
        /// To override the contents of this collection use [`set_db_subnet_groups`](Self::set_db_subnet_groups).
        ///
        /// <p> A list of <code>DBSubnetGroup</code> instances.</p>
        pub fn db_subnet_groups(mut self, input: crate::model::DbSubnetGroup) -> Self {
            let mut v = self.db_subnet_groups.unwrap_or_default();
            v.push(input);
            self.db_subnet_groups = Some(v);
            self
        }
        /// <p> A list of <code>DBSubnetGroup</code> instances.</p>
        pub fn set_db_subnet_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbSubnetGroup>>,
        ) -> Self {
            self.db_subnet_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbSubnetGroupsOutput`](crate::output::DescribeDbSubnetGroupsOutput)
        pub fn build(self) -> crate::output::DescribeDbSubnetGroupsOutput {
            crate::output::DescribeDbSubnetGroupsOutput {
                marker: self.marker,
                db_subnet_groups: self.db_subnet_groups,
            }
        }
    }
}
impl DescribeDbSubnetGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbSubnetGroupsOutput`](crate::output::DescribeDbSubnetGroupsOutput)
    pub fn builder() -> crate::output::describe_db_subnet_groups_output::Builder {
        crate::output::describe_db_subnet_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbParametersOutput {
    /// <p>A list of <code>Parameter</code> values.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeDbParametersOutput {
    /// <p>A list of <code>Parameter</code> values.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameters.as_deref()
    }
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbParametersOutput");
        formatter.field("parameters", &self.parameters);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeDbParametersOutput`](crate::output::DescribeDbParametersOutput)
pub mod describe_db_parameters_output {
    /// A builder for [`DescribeDbParametersOutput`](crate::output::DescribeDbParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of <code>Parameter</code> values.</p>
        pub fn parameters(mut self, input: crate::model::Parameter) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input);
            self.parameters = Some(v);
            self
        }
        /// <p>A list of <code>Parameter</code> values.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbParametersOutput`](crate::output::DescribeDbParametersOutput)
        pub fn build(self) -> crate::output::DescribeDbParametersOutput {
            crate::output::DescribeDbParametersOutput {
                parameters: self.parameters,
                marker: self.marker,
            }
        }
    }
}
impl DescribeDbParametersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbParametersOutput`](crate::output::DescribeDbParametersOutput)
    pub fn builder() -> crate::output::describe_db_parameters_output::Builder {
        crate::output::describe_db_parameters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbParameterGroupsOutput {
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of <code>DBParameterGroup</code> instances.</p>
    pub db_parameter_groups: std::option::Option<std::vec::Vec<crate::model::DbParameterGroup>>,
}
impl DescribeDbParameterGroupsOutput {
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of <code>DBParameterGroup</code> instances.</p>
    pub fn db_parameter_groups(&self) -> std::option::Option<&[crate::model::DbParameterGroup]> {
        self.db_parameter_groups.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbParameterGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbParameterGroupsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("db_parameter_groups", &self.db_parameter_groups);
        formatter.finish()
    }
}
/// See [`DescribeDbParameterGroupsOutput`](crate::output::DescribeDbParameterGroupsOutput)
pub mod describe_db_parameter_groups_output {
    /// A builder for [`DescribeDbParameterGroupsOutput`](crate::output::DescribeDbParameterGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_parameter_groups:
            std::option::Option<std::vec::Vec<crate::model::DbParameterGroup>>,
    }
    impl Builder {
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_parameter_groups`.
        ///
        /// To override the contents of this collection use [`set_db_parameter_groups`](Self::set_db_parameter_groups).
        ///
        /// <p>A list of <code>DBParameterGroup</code> instances.</p>
        pub fn db_parameter_groups(mut self, input: crate::model::DbParameterGroup) -> Self {
            let mut v = self.db_parameter_groups.unwrap_or_default();
            v.push(input);
            self.db_parameter_groups = Some(v);
            self
        }
        /// <p>A list of <code>DBParameterGroup</code> instances.</p>
        pub fn set_db_parameter_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbParameterGroup>>,
        ) -> Self {
            self.db_parameter_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbParameterGroupsOutput`](crate::output::DescribeDbParameterGroupsOutput)
        pub fn build(self) -> crate::output::DescribeDbParameterGroupsOutput {
            crate::output::DescribeDbParameterGroupsOutput {
                marker: self.marker,
                db_parameter_groups: self.db_parameter_groups,
            }
        }
    }
}
impl DescribeDbParameterGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbParameterGroupsOutput`](crate::output::DescribeDbParameterGroupsOutput)
    pub fn builder() -> crate::output::describe_db_parameter_groups_output::Builder {
        crate::output::describe_db_parameter_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbInstancesOutput {
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p> A list of <code>DBInstance</code> instances.</p>
    pub db_instances: std::option::Option<std::vec::Vec<crate::model::DbInstance>>,
}
impl DescribeDbInstancesOutput {
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p> A list of <code>DBInstance</code> instances.</p>
    pub fn db_instances(&self) -> std::option::Option<&[crate::model::DbInstance]> {
        self.db_instances.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbInstancesOutput");
        formatter.field("marker", &self.marker);
        formatter.field("db_instances", &self.db_instances);
        formatter.finish()
    }
}
/// See [`DescribeDbInstancesOutput`](crate::output::DescribeDbInstancesOutput)
pub mod describe_db_instances_output {
    /// A builder for [`DescribeDbInstancesOutput`](crate::output::DescribeDbInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_instances: std::option::Option<std::vec::Vec<crate::model::DbInstance>>,
    }
    impl Builder {
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_instances`.
        ///
        /// To override the contents of this collection use [`set_db_instances`](Self::set_db_instances).
        ///
        /// <p> A list of <code>DBInstance</code> instances.</p>
        pub fn db_instances(mut self, input: crate::model::DbInstance) -> Self {
            let mut v = self.db_instances.unwrap_or_default();
            v.push(input);
            self.db_instances = Some(v);
            self
        }
        /// <p> A list of <code>DBInstance</code> instances.</p>
        pub fn set_db_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbInstance>>,
        ) -> Self {
            self.db_instances = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbInstancesOutput`](crate::output::DescribeDbInstancesOutput)
        pub fn build(self) -> crate::output::DescribeDbInstancesOutput {
            crate::output::DescribeDbInstancesOutput {
                marker: self.marker,
                db_instances: self.db_instances,
            }
        }
    }
}
impl DescribeDbInstancesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbInstancesOutput`](crate::output::DescribeDbInstancesOutput)
    pub fn builder() -> crate::output::describe_db_instances_output::Builder {
        crate::output::describe_db_instances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbEngineVersionsOutput {
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p> A list of <code>DBEngineVersion</code> elements.</p>
    pub db_engine_versions: std::option::Option<std::vec::Vec<crate::model::DbEngineVersion>>,
}
impl DescribeDbEngineVersionsOutput {
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p> A list of <code>DBEngineVersion</code> elements.</p>
    pub fn db_engine_versions(&self) -> std::option::Option<&[crate::model::DbEngineVersion]> {
        self.db_engine_versions.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbEngineVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbEngineVersionsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("db_engine_versions", &self.db_engine_versions);
        formatter.finish()
    }
}
/// See [`DescribeDbEngineVersionsOutput`](crate::output::DescribeDbEngineVersionsOutput)
pub mod describe_db_engine_versions_output {
    /// A builder for [`DescribeDbEngineVersionsOutput`](crate::output::DescribeDbEngineVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_engine_versions:
            std::option::Option<std::vec::Vec<crate::model::DbEngineVersion>>,
    }
    impl Builder {
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_engine_versions`.
        ///
        /// To override the contents of this collection use [`set_db_engine_versions`](Self::set_db_engine_versions).
        ///
        /// <p> A list of <code>DBEngineVersion</code> elements.</p>
        pub fn db_engine_versions(mut self, input: crate::model::DbEngineVersion) -> Self {
            let mut v = self.db_engine_versions.unwrap_or_default();
            v.push(input);
            self.db_engine_versions = Some(v);
            self
        }
        /// <p> A list of <code>DBEngineVersion</code> elements.</p>
        pub fn set_db_engine_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbEngineVersion>>,
        ) -> Self {
            self.db_engine_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbEngineVersionsOutput`](crate::output::DescribeDbEngineVersionsOutput)
        pub fn build(self) -> crate::output::DescribeDbEngineVersionsOutput {
            crate::output::DescribeDbEngineVersionsOutput {
                marker: self.marker,
                db_engine_versions: self.db_engine_versions,
            }
        }
    }
}
impl DescribeDbEngineVersionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbEngineVersionsOutput`](crate::output::DescribeDbEngineVersionsOutput)
    pub fn builder() -> crate::output::describe_db_engine_versions_output::Builder {
        crate::output::describe_db_engine_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterSnapshotsOutput {
    /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Provides a list of DB cluster snapshots for the user.</p>
    pub db_cluster_snapshots: std::option::Option<std::vec::Vec<crate::model::DbClusterSnapshot>>,
}
impl DescribeDbClusterSnapshotsOutput {
    /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Provides a list of DB cluster snapshots for the user.</p>
    pub fn db_cluster_snapshots(&self) -> std::option::Option<&[crate::model::DbClusterSnapshot]> {
        self.db_cluster_snapshots.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbClusterSnapshotsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterSnapshotsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("db_cluster_snapshots", &self.db_cluster_snapshots);
        formatter.finish()
    }
}
/// See [`DescribeDbClusterSnapshotsOutput`](crate::output::DescribeDbClusterSnapshotsOutput)
pub mod describe_db_cluster_snapshots_output {
    /// A builder for [`DescribeDbClusterSnapshotsOutput`](crate::output::DescribeDbClusterSnapshotsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_cluster_snapshots:
            std::option::Option<std::vec::Vec<crate::model::DbClusterSnapshot>>,
    }
    impl Builder {
        /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_cluster_snapshots`.
        ///
        /// To override the contents of this collection use [`set_db_cluster_snapshots`](Self::set_db_cluster_snapshots).
        ///
        /// <p>Provides a list of DB cluster snapshots for the user.</p>
        pub fn db_cluster_snapshots(mut self, input: crate::model::DbClusterSnapshot) -> Self {
            let mut v = self.db_cluster_snapshots.unwrap_or_default();
            v.push(input);
            self.db_cluster_snapshots = Some(v);
            self
        }
        /// <p>Provides a list of DB cluster snapshots for the user.</p>
        pub fn set_db_cluster_snapshots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbClusterSnapshot>>,
        ) -> Self {
            self.db_cluster_snapshots = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterSnapshotsOutput`](crate::output::DescribeDbClusterSnapshotsOutput)
        pub fn build(self) -> crate::output::DescribeDbClusterSnapshotsOutput {
            crate::output::DescribeDbClusterSnapshotsOutput {
                marker: self.marker,
                db_cluster_snapshots: self.db_cluster_snapshots,
            }
        }
    }
}
impl DescribeDbClusterSnapshotsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterSnapshotsOutput`](crate::output::DescribeDbClusterSnapshotsOutput)
    pub fn builder() -> crate::output::describe_db_cluster_snapshots_output::Builder {
        crate::output::describe_db_cluster_snapshots_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterSnapshotAttributesOutput {
    /// <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code> API action.</p>
    /// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon accounts to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
    pub db_cluster_snapshot_attributes_result:
        std::option::Option<crate::model::DbClusterSnapshotAttributesResult>,
}
impl DescribeDbClusterSnapshotAttributesOutput {
    /// <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code> API action.</p>
    /// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon accounts to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
    pub fn db_cluster_snapshot_attributes_result(
        &self,
    ) -> std::option::Option<&crate::model::DbClusterSnapshotAttributesResult> {
        self.db_cluster_snapshot_attributes_result.as_ref()
    }
}
impl std::fmt::Debug for DescribeDbClusterSnapshotAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterSnapshotAttributesOutput");
        formatter.field(
            "db_cluster_snapshot_attributes_result",
            &self.db_cluster_snapshot_attributes_result,
        );
        formatter.finish()
    }
}
/// See [`DescribeDbClusterSnapshotAttributesOutput`](crate::output::DescribeDbClusterSnapshotAttributesOutput)
pub mod describe_db_cluster_snapshot_attributes_output {
    /// A builder for [`DescribeDbClusterSnapshotAttributesOutput`](crate::output::DescribeDbClusterSnapshotAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot_attributes_result:
            std::option::Option<crate::model::DbClusterSnapshotAttributesResult>,
    }
    impl Builder {
        /// <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code> API action.</p>
        /// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon accounts to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
        pub fn db_cluster_snapshot_attributes_result(
            mut self,
            input: crate::model::DbClusterSnapshotAttributesResult,
        ) -> Self {
            self.db_cluster_snapshot_attributes_result = Some(input);
            self
        }
        /// <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code> API action.</p>
        /// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon accounts to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
        pub fn set_db_cluster_snapshot_attributes_result(
            mut self,
            input: std::option::Option<crate::model::DbClusterSnapshotAttributesResult>,
        ) -> Self {
            self.db_cluster_snapshot_attributes_result = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterSnapshotAttributesOutput`](crate::output::DescribeDbClusterSnapshotAttributesOutput)
        pub fn build(self) -> crate::output::DescribeDbClusterSnapshotAttributesOutput {
            crate::output::DescribeDbClusterSnapshotAttributesOutput {
                db_cluster_snapshot_attributes_result: self.db_cluster_snapshot_attributes_result,
            }
        }
    }
}
impl DescribeDbClusterSnapshotAttributesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterSnapshotAttributesOutput`](crate::output::DescribeDbClusterSnapshotAttributesOutput)
    pub fn builder() -> crate::output::describe_db_cluster_snapshot_attributes_output::Builder {
        crate::output::describe_db_cluster_snapshot_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClustersOutput {
    /// <p>A pagination token that can be used in a subsequent DescribeDBClusters request.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Contains a list of DB clusters for the user.</p>
    pub db_clusters: std::option::Option<std::vec::Vec<crate::model::DbCluster>>,
}
impl DescribeDbClustersOutput {
    /// <p>A pagination token that can be used in a subsequent DescribeDBClusters request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Contains a list of DB clusters for the user.</p>
    pub fn db_clusters(&self) -> std::option::Option<&[crate::model::DbCluster]> {
        self.db_clusters.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbClustersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClustersOutput");
        formatter.field("marker", &self.marker);
        formatter.field("db_clusters", &self.db_clusters);
        formatter.finish()
    }
}
/// See [`DescribeDbClustersOutput`](crate::output::DescribeDbClustersOutput)
pub mod describe_db_clusters_output {
    /// A builder for [`DescribeDbClustersOutput`](crate::output::DescribeDbClustersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_clusters: std::option::Option<std::vec::Vec<crate::model::DbCluster>>,
    }
    impl Builder {
        /// <p>A pagination token that can be used in a subsequent DescribeDBClusters request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent DescribeDBClusters request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_clusters`.
        ///
        /// To override the contents of this collection use [`set_db_clusters`](Self::set_db_clusters).
        ///
        /// <p>Contains a list of DB clusters for the user.</p>
        pub fn db_clusters(mut self, input: crate::model::DbCluster) -> Self {
            let mut v = self.db_clusters.unwrap_or_default();
            v.push(input);
            self.db_clusters = Some(v);
            self
        }
        /// <p>Contains a list of DB clusters for the user.</p>
        pub fn set_db_clusters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbCluster>>,
        ) -> Self {
            self.db_clusters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClustersOutput`](crate::output::DescribeDbClustersOutput)
        pub fn build(self) -> crate::output::DescribeDbClustersOutput {
            crate::output::DescribeDbClustersOutput {
                marker: self.marker,
                db_clusters: self.db_clusters,
            }
        }
    }
}
impl DescribeDbClustersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbClustersOutput`](crate::output::DescribeDbClustersOutput)
    pub fn builder() -> crate::output::describe_db_clusters_output::Builder {
        crate::output::describe_db_clusters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterParametersOutput {
    /// <p>Provides a list of parameters for the DB cluster parameter group.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    /// <p> An optional pagination token provided by a previous DescribeDBClusterParameters request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeDbClusterParametersOutput {
    /// <p>Provides a list of parameters for the DB cluster parameter group.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameters.as_deref()
    }
    /// <p> An optional pagination token provided by a previous DescribeDBClusterParameters request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbClusterParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterParametersOutput");
        formatter.field("parameters", &self.parameters);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeDbClusterParametersOutput`](crate::output::DescribeDbClusterParametersOutput)
pub mod describe_db_cluster_parameters_output {
    /// A builder for [`DescribeDbClusterParametersOutput`](crate::output::DescribeDbClusterParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Provides a list of parameters for the DB cluster parameter group.</p>
        pub fn parameters(mut self, input: crate::model::Parameter) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input);
            self.parameters = Some(v);
            self
        }
        /// <p>Provides a list of parameters for the DB cluster parameter group.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeDBClusterParameters request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeDBClusterParameters request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterParametersOutput`](crate::output::DescribeDbClusterParametersOutput)
        pub fn build(self) -> crate::output::DescribeDbClusterParametersOutput {
            crate::output::DescribeDbClusterParametersOutput {
                parameters: self.parameters,
                marker: self.marker,
            }
        }
    }
}
impl DescribeDbClusterParametersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterParametersOutput`](crate::output::DescribeDbClusterParametersOutput)
    pub fn builder() -> crate::output::describe_db_cluster_parameters_output::Builder {
        crate::output::describe_db_cluster_parameters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterParameterGroupsOutput {
    /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of DB cluster parameter groups.</p>
    pub db_cluster_parameter_groups:
        std::option::Option<std::vec::Vec<crate::model::DbClusterParameterGroup>>,
}
impl DescribeDbClusterParameterGroupsOutput {
    /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of DB cluster parameter groups.</p>
    pub fn db_cluster_parameter_groups(
        &self,
    ) -> std::option::Option<&[crate::model::DbClusterParameterGroup]> {
        self.db_cluster_parameter_groups.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbClusterParameterGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterParameterGroupsOutput");
        formatter.field("marker", &self.marker);
        formatter.field(
            "db_cluster_parameter_groups",
            &self.db_cluster_parameter_groups,
        );
        formatter.finish()
    }
}
/// See [`DescribeDbClusterParameterGroupsOutput`](crate::output::DescribeDbClusterParameterGroupsOutput)
pub mod describe_db_cluster_parameter_groups_output {
    /// A builder for [`DescribeDbClusterParameterGroupsOutput`](crate::output::DescribeDbClusterParameterGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_cluster_parameter_groups:
            std::option::Option<std::vec::Vec<crate::model::DbClusterParameterGroup>>,
    }
    impl Builder {
        /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_cluster_parameter_groups`.
        ///
        /// To override the contents of this collection use [`set_db_cluster_parameter_groups`](Self::set_db_cluster_parameter_groups).
        ///
        /// <p>A list of DB cluster parameter groups.</p>
        pub fn db_cluster_parameter_groups(
            mut self,
            input: crate::model::DbClusterParameterGroup,
        ) -> Self {
            let mut v = self.db_cluster_parameter_groups.unwrap_or_default();
            v.push(input);
            self.db_cluster_parameter_groups = Some(v);
            self
        }
        /// <p>A list of DB cluster parameter groups.</p>
        pub fn set_db_cluster_parameter_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbClusterParameterGroup>>,
        ) -> Self {
            self.db_cluster_parameter_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterParameterGroupsOutput`](crate::output::DescribeDbClusterParameterGroupsOutput)
        pub fn build(self) -> crate::output::DescribeDbClusterParameterGroupsOutput {
            crate::output::DescribeDbClusterParameterGroupsOutput {
                marker: self.marker,
                db_cluster_parameter_groups: self.db_cluster_parameter_groups,
            }
        }
    }
}
impl DescribeDbClusterParameterGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterParameterGroupsOutput`](crate::output::DescribeDbClusterParameterGroupsOutput)
    pub fn builder() -> crate::output::describe_db_cluster_parameter_groups_output::Builder {
        crate::output::describe_db_cluster_parameter_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterEndpointsOutput {
    /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterEndpoints</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Contains the details of the endpoints associated with the cluster and matching any filter conditions.</p>
    pub db_cluster_endpoints: std::option::Option<std::vec::Vec<crate::model::DbClusterEndpoint>>,
}
impl DescribeDbClusterEndpointsOutput {
    /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterEndpoints</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Contains the details of the endpoints associated with the cluster and matching any filter conditions.</p>
    pub fn db_cluster_endpoints(&self) -> std::option::Option<&[crate::model::DbClusterEndpoint]> {
        self.db_cluster_endpoints.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbClusterEndpointsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterEndpointsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("db_cluster_endpoints", &self.db_cluster_endpoints);
        formatter.finish()
    }
}
/// See [`DescribeDbClusterEndpointsOutput`](crate::output::DescribeDbClusterEndpointsOutput)
pub mod describe_db_cluster_endpoints_output {
    /// A builder for [`DescribeDbClusterEndpointsOutput`](crate::output::DescribeDbClusterEndpointsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_cluster_endpoints:
            std::option::Option<std::vec::Vec<crate::model::DbClusterEndpoint>>,
    }
    impl Builder {
        /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterEndpoints</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterEndpoints</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_cluster_endpoints`.
        ///
        /// To override the contents of this collection use [`set_db_cluster_endpoints`](Self::set_db_cluster_endpoints).
        ///
        /// <p>Contains the details of the endpoints associated with the cluster and matching any filter conditions.</p>
        pub fn db_cluster_endpoints(mut self, input: crate::model::DbClusterEndpoint) -> Self {
            let mut v = self.db_cluster_endpoints.unwrap_or_default();
            v.push(input);
            self.db_cluster_endpoints = Some(v);
            self
        }
        /// <p>Contains the details of the endpoints associated with the cluster and matching any filter conditions.</p>
        pub fn set_db_cluster_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbClusterEndpoint>>,
        ) -> Self {
            self.db_cluster_endpoints = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterEndpointsOutput`](crate::output::DescribeDbClusterEndpointsOutput)
        pub fn build(self) -> crate::output::DescribeDbClusterEndpointsOutput {
            crate::output::DescribeDbClusterEndpointsOutput {
                marker: self.marker,
                db_cluster_endpoints: self.db_cluster_endpoints,
            }
        }
    }
}
impl DescribeDbClusterEndpointsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterEndpointsOutput`](crate::output::DescribeDbClusterEndpointsOutput)
    pub fn builder() -> crate::output::describe_db_cluster_endpoints_output::Builder {
        crate::output::describe_db_cluster_endpoints_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub event_subscription: std::option::Option<crate::model::EventSubscription>,
}
impl DeleteEventSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub fn event_subscription(&self) -> std::option::Option<&crate::model::EventSubscription> {
        self.event_subscription.as_ref()
    }
}
impl std::fmt::Debug for DeleteEventSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventSubscriptionOutput");
        formatter.field("event_subscription", &self.event_subscription);
        formatter.finish()
    }
}
/// See [`DeleteEventSubscriptionOutput`](crate::output::DeleteEventSubscriptionOutput)
pub mod delete_event_subscription_output {
    /// A builder for [`DeleteEventSubscriptionOutput`](crate::output::DeleteEventSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_subscription: std::option::Option<crate::model::EventSubscription>,
    }
    impl Builder {
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn event_subscription(mut self, input: crate::model::EventSubscription) -> Self {
            self.event_subscription = Some(input);
            self
        }
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn set_event_subscription(
            mut self,
            input: std::option::Option<crate::model::EventSubscription>,
        ) -> Self {
            self.event_subscription = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventSubscriptionOutput`](crate::output::DeleteEventSubscriptionOutput)
        pub fn build(self) -> crate::output::DeleteEventSubscriptionOutput {
            crate::output::DeleteEventSubscriptionOutput {
                event_subscription: self.event_subscription,
            }
        }
    }
}
impl DeleteEventSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEventSubscriptionOutput`](crate::output::DeleteEventSubscriptionOutput)
    pub fn builder() -> crate::output::delete_event_subscription_output::Builder {
        crate::output::delete_event_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbSubnetGroupOutput {}
impl std::fmt::Debug for DeleteDbSubnetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbSubnetGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteDbSubnetGroupOutput`](crate::output::DeleteDbSubnetGroupOutput)
pub mod delete_db_subnet_group_output {
    /// A builder for [`DeleteDbSubnetGroupOutput`](crate::output::DeleteDbSubnetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDbSubnetGroupOutput`](crate::output::DeleteDbSubnetGroupOutput)
        pub fn build(self) -> crate::output::DeleteDbSubnetGroupOutput {
            crate::output::DeleteDbSubnetGroupOutput {}
        }
    }
}
impl DeleteDbSubnetGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDbSubnetGroupOutput`](crate::output::DeleteDbSubnetGroupOutput)
    pub fn builder() -> crate::output::delete_db_subnet_group_output::Builder {
        crate::output::delete_db_subnet_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbParameterGroupOutput {}
impl std::fmt::Debug for DeleteDbParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbParameterGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteDbParameterGroupOutput`](crate::output::DeleteDbParameterGroupOutput)
pub mod delete_db_parameter_group_output {
    /// A builder for [`DeleteDbParameterGroupOutput`](crate::output::DeleteDbParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDbParameterGroupOutput`](crate::output::DeleteDbParameterGroupOutput)
        pub fn build(self) -> crate::output::DeleteDbParameterGroupOutput {
            crate::output::DeleteDbParameterGroupOutput {}
        }
    }
}
impl DeleteDbParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDbParameterGroupOutput`](crate::output::DeleteDbParameterGroupOutput)
    pub fn builder() -> crate::output::delete_db_parameter_group_output::Builder {
        crate::output::delete_db_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbInstanceOutput {
    /// <p>Contains the details of an Amazon Neptune DB instance.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
    pub db_instance: std::option::Option<crate::model::DbInstance>,
}
impl DeleteDbInstanceOutput {
    /// <p>Contains the details of an Amazon Neptune DB instance.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
    pub fn db_instance(&self) -> std::option::Option<&crate::model::DbInstance> {
        self.db_instance.as_ref()
    }
}
impl std::fmt::Debug for DeleteDbInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbInstanceOutput");
        formatter.field("db_instance", &self.db_instance);
        formatter.finish()
    }
}
/// See [`DeleteDbInstanceOutput`](crate::output::DeleteDbInstanceOutput)
pub mod delete_db_instance_output {
    /// A builder for [`DeleteDbInstanceOutput`](crate::output::DeleteDbInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance: std::option::Option<crate::model::DbInstance>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Neptune DB instance.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
        pub fn db_instance(mut self, input: crate::model::DbInstance) -> Self {
            self.db_instance = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Neptune DB instance.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
        pub fn set_db_instance(
            mut self,
            input: std::option::Option<crate::model::DbInstance>,
        ) -> Self {
            self.db_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbInstanceOutput`](crate::output::DeleteDbInstanceOutput)
        pub fn build(self) -> crate::output::DeleteDbInstanceOutput {
            crate::output::DeleteDbInstanceOutput {
                db_instance: self.db_instance,
            }
        }
    }
}
impl DeleteDbInstanceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDbInstanceOutput`](crate::output::DeleteDbInstanceOutput)
    pub fn builder() -> crate::output::delete_db_instance_output::Builder {
        crate::output::delete_db_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbClusterSnapshotOutput {
    /// <p>Contains the details for an Amazon Neptune DB cluster snapshot</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action.</p>
    pub db_cluster_snapshot: std::option::Option<crate::model::DbClusterSnapshot>,
}
impl DeleteDbClusterSnapshotOutput {
    /// <p>Contains the details for an Amazon Neptune DB cluster snapshot</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action.</p>
    pub fn db_cluster_snapshot(&self) -> std::option::Option<&crate::model::DbClusterSnapshot> {
        self.db_cluster_snapshot.as_ref()
    }
}
impl std::fmt::Debug for DeleteDbClusterSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbClusterSnapshotOutput");
        formatter.field("db_cluster_snapshot", &self.db_cluster_snapshot);
        formatter.finish()
    }
}
/// See [`DeleteDbClusterSnapshotOutput`](crate::output::DeleteDbClusterSnapshotOutput)
pub mod delete_db_cluster_snapshot_output {
    /// A builder for [`DeleteDbClusterSnapshotOutput`](crate::output::DeleteDbClusterSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot: std::option::Option<crate::model::DbClusterSnapshot>,
    }
    impl Builder {
        /// <p>Contains the details for an Amazon Neptune DB cluster snapshot</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action.</p>
        pub fn db_cluster_snapshot(mut self, input: crate::model::DbClusterSnapshot) -> Self {
            self.db_cluster_snapshot = Some(input);
            self
        }
        /// <p>Contains the details for an Amazon Neptune DB cluster snapshot</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action.</p>
        pub fn set_db_cluster_snapshot(
            mut self,
            input: std::option::Option<crate::model::DbClusterSnapshot>,
        ) -> Self {
            self.db_cluster_snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbClusterSnapshotOutput`](crate::output::DeleteDbClusterSnapshotOutput)
        pub fn build(self) -> crate::output::DeleteDbClusterSnapshotOutput {
            crate::output::DeleteDbClusterSnapshotOutput {
                db_cluster_snapshot: self.db_cluster_snapshot,
            }
        }
    }
}
impl DeleteDbClusterSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterSnapshotOutput`](crate::output::DeleteDbClusterSnapshotOutput)
    pub fn builder() -> crate::output::delete_db_cluster_snapshot_output::Builder {
        crate::output::delete_db_cluster_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbClusterParameterGroupOutput {}
impl std::fmt::Debug for DeleteDbClusterParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbClusterParameterGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteDbClusterParameterGroupOutput`](crate::output::DeleteDbClusterParameterGroupOutput)
pub mod delete_db_cluster_parameter_group_output {
    /// A builder for [`DeleteDbClusterParameterGroupOutput`](crate::output::DeleteDbClusterParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDbClusterParameterGroupOutput`](crate::output::DeleteDbClusterParameterGroupOutput)
        pub fn build(self) -> crate::output::DeleteDbClusterParameterGroupOutput {
            crate::output::DeleteDbClusterParameterGroupOutput {}
        }
    }
}
impl DeleteDbClusterParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterParameterGroupOutput`](crate::output::DeleteDbClusterParameterGroupOutput)
    pub fn builder() -> crate::output::delete_db_cluster_parameter_group_output::Builder {
        crate::output::delete_db_cluster_parameter_group_output::Builder::default()
    }
}

/// <p>This data type represents the information you need to connect to an Amazon Neptune DB cluster. This data type is used as a response element in the following actions:</p>
/// <ul>
/// <li> <p> <code>CreateDBClusterEndpoint</code> </p> </li>
/// <li> <p> <code>DescribeDBClusterEndpoints</code> </p> </li>
/// <li> <p> <code>ModifyDBClusterEndpoint</code> </p> </li>
/// <li> <p> <code>DeleteDBClusterEndpoint</code> </p> </li>
/// </ul>
/// <p>For the data structure that represents Amazon RDS DB instance endpoints, see <code>Endpoint</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbClusterEndpointOutput {
    /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
    /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    pub db_cluster_endpoint_resource_identifier: std::option::Option<std::string::String>,
    /// <p>The DNS address of the endpoint.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    pub endpoint_type: std::option::Option<std::string::String>,
    /// <p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    pub custom_endpoint_type: std::option::Option<std::string::String>,
    /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    pub static_members: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
    pub excluded_members: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    pub db_cluster_endpoint_arn: std::option::Option<std::string::String>,
}
impl DeleteDbClusterEndpointOutput {
    /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub fn db_cluster_endpoint_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_endpoint_identifier.as_deref()
    }
    /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    pub fn db_cluster_endpoint_resource_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_endpoint_resource_identifier.as_deref()
    }
    /// <p>The DNS address of the endpoint.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    pub fn endpoint_type(&self) -> std::option::Option<&str> {
        self.endpoint_type.as_deref()
    }
    /// <p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    pub fn custom_endpoint_type(&self) -> std::option::Option<&str> {
        self.custom_endpoint_type.as_deref()
    }
    /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    pub fn static_members(&self) -> std::option::Option<&[std::string::String]> {
        self.static_members.as_deref()
    }
    /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
    pub fn excluded_members(&self) -> std::option::Option<&[std::string::String]> {
        self.excluded_members.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    pub fn db_cluster_endpoint_arn(&self) -> std::option::Option<&str> {
        self.db_cluster_endpoint_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteDbClusterEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbClusterEndpointOutput");
        formatter.field(
            "db_cluster_endpoint_identifier",
            &self.db_cluster_endpoint_identifier,
        );
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field(
            "db_cluster_endpoint_resource_identifier",
            &self.db_cluster_endpoint_resource_identifier,
        );
        formatter.field("endpoint", &self.endpoint);
        formatter.field("status", &self.status);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("custom_endpoint_type", &self.custom_endpoint_type);
        formatter.field("static_members", &self.static_members);
        formatter.field("excluded_members", &self.excluded_members);
        formatter.field("db_cluster_endpoint_arn", &self.db_cluster_endpoint_arn);
        formatter.finish()
    }
}
/// See [`DeleteDbClusterEndpointOutput`](crate::output::DeleteDbClusterEndpointOutput)
pub mod delete_db_cluster_endpoint_output {
    /// A builder for [`DeleteDbClusterEndpointOutput`](crate::output::DeleteDbClusterEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_endpoint_resource_identifier:
            std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<std::string::String>,
        pub(crate) custom_endpoint_type: std::option::Option<std::string::String>,
        pub(crate) static_members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) excluded_members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_cluster_endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = Some(input.into());
            self
        }
        /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = input;
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
        pub fn db_cluster_endpoint_resource_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_resource_identifier = Some(input.into());
            self
        }
        /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
        pub fn set_db_cluster_endpoint_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_resource_identifier = input;
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
        pub fn endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_type = Some(input.into());
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn custom_endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_endpoint_type = Some(input.into());
            self
        }
        /// <p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn set_custom_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_endpoint_type = input;
            self
        }
        /// Appends an item to `static_members`.
        ///
        /// To override the contents of this collection use [`set_static_members`](Self::set_static_members).
        ///
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn static_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.static_members.unwrap_or_default();
            v.push(input.into());
            self.static_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn set_static_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.static_members = input;
            self
        }
        /// Appends an item to `excluded_members`.
        ///
        /// To override the contents of this collection use [`set_excluded_members`](Self::set_excluded_members).
        ///
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
        pub fn excluded_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.excluded_members.unwrap_or_default();
            v.push(input.into());
            self.excluded_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
        pub fn set_excluded_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.excluded_members = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
        pub fn db_cluster_endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
        pub fn set_db_cluster_endpoint_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbClusterEndpointOutput`](crate::output::DeleteDbClusterEndpointOutput)
        pub fn build(self) -> crate::output::DeleteDbClusterEndpointOutput {
            crate::output::DeleteDbClusterEndpointOutput {
                db_cluster_endpoint_identifier: self.db_cluster_endpoint_identifier,
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_endpoint_resource_identifier: self
                    .db_cluster_endpoint_resource_identifier,
                endpoint: self.endpoint,
                status: self.status,
                endpoint_type: self.endpoint_type,
                custom_endpoint_type: self.custom_endpoint_type,
                static_members: self.static_members,
                excluded_members: self.excluded_members,
                db_cluster_endpoint_arn: self.db_cluster_endpoint_arn,
            }
        }
    }
}
impl DeleteDbClusterEndpointOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterEndpointOutput`](crate::output::DeleteDbClusterEndpointOutput)
    pub fn builder() -> crate::output::delete_db_cluster_endpoint_output::Builder {
        crate::output::delete_db_cluster_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbClusterOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    pub db_cluster: std::option::Option<crate::model::DbCluster>,
}
impl DeleteDbClusterOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    pub fn db_cluster(&self) -> std::option::Option<&crate::model::DbCluster> {
        self.db_cluster.as_ref()
    }
}
impl std::fmt::Debug for DeleteDbClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbClusterOutput");
        formatter.field("db_cluster", &self.db_cluster);
        formatter.finish()
    }
}
/// See [`DeleteDbClusterOutput`](crate::output::DeleteDbClusterOutput)
pub mod delete_db_cluster_output {
    /// A builder for [`DeleteDbClusterOutput`](crate::output::DeleteDbClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster: std::option::Option<crate::model::DbCluster>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
        pub fn db_cluster(mut self, input: crate::model::DbCluster) -> Self {
            self.db_cluster = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
        pub fn set_db_cluster(
            mut self,
            input: std::option::Option<crate::model::DbCluster>,
        ) -> Self {
            self.db_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbClusterOutput`](crate::output::DeleteDbClusterOutput)
        pub fn build(self) -> crate::output::DeleteDbClusterOutput {
            crate::output::DeleteDbClusterOutput {
                db_cluster: self.db_cluster,
            }
        }
    }
}
impl DeleteDbClusterOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterOutput`](crate::output::DeleteDbClusterOutput)
    pub fn builder() -> crate::output::delete_db_cluster_output::Builder {
        crate::output::delete_db_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEventSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub event_subscription: std::option::Option<crate::model::EventSubscription>,
}
impl CreateEventSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub fn event_subscription(&self) -> std::option::Option<&crate::model::EventSubscription> {
        self.event_subscription.as_ref()
    }
}
impl std::fmt::Debug for CreateEventSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEventSubscriptionOutput");
        formatter.field("event_subscription", &self.event_subscription);
        formatter.finish()
    }
}
/// See [`CreateEventSubscriptionOutput`](crate::output::CreateEventSubscriptionOutput)
pub mod create_event_subscription_output {
    /// A builder for [`CreateEventSubscriptionOutput`](crate::output::CreateEventSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_subscription: std::option::Option<crate::model::EventSubscription>,
    }
    impl Builder {
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn event_subscription(mut self, input: crate::model::EventSubscription) -> Self {
            self.event_subscription = Some(input);
            self
        }
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn set_event_subscription(
            mut self,
            input: std::option::Option<crate::model::EventSubscription>,
        ) -> Self {
            self.event_subscription = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventSubscriptionOutput`](crate::output::CreateEventSubscriptionOutput)
        pub fn build(self) -> crate::output::CreateEventSubscriptionOutput {
            crate::output::CreateEventSubscriptionOutput {
                event_subscription: self.event_subscription,
            }
        }
    }
}
impl CreateEventSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`CreateEventSubscriptionOutput`](crate::output::CreateEventSubscriptionOutput)
    pub fn builder() -> crate::output::create_event_subscription_output::Builder {
        crate::output::create_event_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbSubnetGroupOutput {
    /// <p>Contains the details of an Amazon Neptune DB subnet group.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBSubnetGroups</code> action.</p>
    pub db_subnet_group: std::option::Option<crate::model::DbSubnetGroup>,
}
impl CreateDbSubnetGroupOutput {
    /// <p>Contains the details of an Amazon Neptune DB subnet group.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBSubnetGroups</code> action.</p>
    pub fn db_subnet_group(&self) -> std::option::Option<&crate::model::DbSubnetGroup> {
        self.db_subnet_group.as_ref()
    }
}
impl std::fmt::Debug for CreateDbSubnetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbSubnetGroupOutput");
        formatter.field("db_subnet_group", &self.db_subnet_group);
        formatter.finish()
    }
}
/// See [`CreateDbSubnetGroupOutput`](crate::output::CreateDbSubnetGroupOutput)
pub mod create_db_subnet_group_output {
    /// A builder for [`CreateDbSubnetGroupOutput`](crate::output::CreateDbSubnetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_subnet_group: std::option::Option<crate::model::DbSubnetGroup>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Neptune DB subnet group.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBSubnetGroups</code> action.</p>
        pub fn db_subnet_group(mut self, input: crate::model::DbSubnetGroup) -> Self {
            self.db_subnet_group = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Neptune DB subnet group.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBSubnetGroups</code> action.</p>
        pub fn set_db_subnet_group(
            mut self,
            input: std::option::Option<crate::model::DbSubnetGroup>,
        ) -> Self {
            self.db_subnet_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbSubnetGroupOutput`](crate::output::CreateDbSubnetGroupOutput)
        pub fn build(self) -> crate::output::CreateDbSubnetGroupOutput {
            crate::output::CreateDbSubnetGroupOutput {
                db_subnet_group: self.db_subnet_group,
            }
        }
    }
}
impl CreateDbSubnetGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateDbSubnetGroupOutput`](crate::output::CreateDbSubnetGroupOutput)
    pub fn builder() -> crate::output::create_db_subnet_group_output::Builder {
        crate::output::create_db_subnet_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbParameterGroupOutput {
    /// <p>Contains the details of an Amazon Neptune DB parameter group.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.</p>
    pub db_parameter_group: std::option::Option<crate::model::DbParameterGroup>,
}
impl CreateDbParameterGroupOutput {
    /// <p>Contains the details of an Amazon Neptune DB parameter group.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.</p>
    pub fn db_parameter_group(&self) -> std::option::Option<&crate::model::DbParameterGroup> {
        self.db_parameter_group.as_ref()
    }
}
impl std::fmt::Debug for CreateDbParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbParameterGroupOutput");
        formatter.field("db_parameter_group", &self.db_parameter_group);
        formatter.finish()
    }
}
/// See [`CreateDbParameterGroupOutput`](crate::output::CreateDbParameterGroupOutput)
pub mod create_db_parameter_group_output {
    /// A builder for [`CreateDbParameterGroupOutput`](crate::output::CreateDbParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group: std::option::Option<crate::model::DbParameterGroup>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Neptune DB parameter group.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.</p>
        pub fn db_parameter_group(mut self, input: crate::model::DbParameterGroup) -> Self {
            self.db_parameter_group = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Neptune DB parameter group.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.</p>
        pub fn set_db_parameter_group(
            mut self,
            input: std::option::Option<crate::model::DbParameterGroup>,
        ) -> Self {
            self.db_parameter_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbParameterGroupOutput`](crate::output::CreateDbParameterGroupOutput)
        pub fn build(self) -> crate::output::CreateDbParameterGroupOutput {
            crate::output::CreateDbParameterGroupOutput {
                db_parameter_group: self.db_parameter_group,
            }
        }
    }
}
impl CreateDbParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateDbParameterGroupOutput`](crate::output::CreateDbParameterGroupOutput)
    pub fn builder() -> crate::output::create_db_parameter_group_output::Builder {
        crate::output::create_db_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbInstanceOutput {
    /// <p>Contains the details of an Amazon Neptune DB instance.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
    pub db_instance: std::option::Option<crate::model::DbInstance>,
}
impl CreateDbInstanceOutput {
    /// <p>Contains the details of an Amazon Neptune DB instance.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
    pub fn db_instance(&self) -> std::option::Option<&crate::model::DbInstance> {
        self.db_instance.as_ref()
    }
}
impl std::fmt::Debug for CreateDbInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbInstanceOutput");
        formatter.field("db_instance", &self.db_instance);
        formatter.finish()
    }
}
/// See [`CreateDbInstanceOutput`](crate::output::CreateDbInstanceOutput)
pub mod create_db_instance_output {
    /// A builder for [`CreateDbInstanceOutput`](crate::output::CreateDbInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance: std::option::Option<crate::model::DbInstance>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Neptune DB instance.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
        pub fn db_instance(mut self, input: crate::model::DbInstance) -> Self {
            self.db_instance = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Neptune DB instance.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
        pub fn set_db_instance(
            mut self,
            input: std::option::Option<crate::model::DbInstance>,
        ) -> Self {
            self.db_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbInstanceOutput`](crate::output::CreateDbInstanceOutput)
        pub fn build(self) -> crate::output::CreateDbInstanceOutput {
            crate::output::CreateDbInstanceOutput {
                db_instance: self.db_instance,
            }
        }
    }
}
impl CreateDbInstanceOutput {
    /// Creates a new builder-style object to manufacture [`CreateDbInstanceOutput`](crate::output::CreateDbInstanceOutput)
    pub fn builder() -> crate::output::create_db_instance_output::Builder {
        crate::output::create_db_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbClusterSnapshotOutput {
    /// <p>Contains the details for an Amazon Neptune DB cluster snapshot</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action.</p>
    pub db_cluster_snapshot: std::option::Option<crate::model::DbClusterSnapshot>,
}
impl CreateDbClusterSnapshotOutput {
    /// <p>Contains the details for an Amazon Neptune DB cluster snapshot</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action.</p>
    pub fn db_cluster_snapshot(&self) -> std::option::Option<&crate::model::DbClusterSnapshot> {
        self.db_cluster_snapshot.as_ref()
    }
}
impl std::fmt::Debug for CreateDbClusterSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbClusterSnapshotOutput");
        formatter.field("db_cluster_snapshot", &self.db_cluster_snapshot);
        formatter.finish()
    }
}
/// See [`CreateDbClusterSnapshotOutput`](crate::output::CreateDbClusterSnapshotOutput)
pub mod create_db_cluster_snapshot_output {
    /// A builder for [`CreateDbClusterSnapshotOutput`](crate::output::CreateDbClusterSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot: std::option::Option<crate::model::DbClusterSnapshot>,
    }
    impl Builder {
        /// <p>Contains the details for an Amazon Neptune DB cluster snapshot</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action.</p>
        pub fn db_cluster_snapshot(mut self, input: crate::model::DbClusterSnapshot) -> Self {
            self.db_cluster_snapshot = Some(input);
            self
        }
        /// <p>Contains the details for an Amazon Neptune DB cluster snapshot</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action.</p>
        pub fn set_db_cluster_snapshot(
            mut self,
            input: std::option::Option<crate::model::DbClusterSnapshot>,
        ) -> Self {
            self.db_cluster_snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbClusterSnapshotOutput`](crate::output::CreateDbClusterSnapshotOutput)
        pub fn build(self) -> crate::output::CreateDbClusterSnapshotOutput {
            crate::output::CreateDbClusterSnapshotOutput {
                db_cluster_snapshot: self.db_cluster_snapshot,
            }
        }
    }
}
impl CreateDbClusterSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`CreateDbClusterSnapshotOutput`](crate::output::CreateDbClusterSnapshotOutput)
    pub fn builder() -> crate::output::create_db_cluster_snapshot_output::Builder {
        crate::output::create_db_cluster_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbClusterParameterGroupOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster parameter group.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.</p>
    pub db_cluster_parameter_group: std::option::Option<crate::model::DbClusterParameterGroup>,
}
impl CreateDbClusterParameterGroupOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster parameter group.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.</p>
    pub fn db_cluster_parameter_group(
        &self,
    ) -> std::option::Option<&crate::model::DbClusterParameterGroup> {
        self.db_cluster_parameter_group.as_ref()
    }
}
impl std::fmt::Debug for CreateDbClusterParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbClusterParameterGroupOutput");
        formatter.field(
            "db_cluster_parameter_group",
            &self.db_cluster_parameter_group,
        );
        formatter.finish()
    }
}
/// See [`CreateDbClusterParameterGroupOutput`](crate::output::CreateDbClusterParameterGroupOutput)
pub mod create_db_cluster_parameter_group_output {
    /// A builder for [`CreateDbClusterParameterGroupOutput`](crate::output::CreateDbClusterParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group:
            std::option::Option<crate::model::DbClusterParameterGroup>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Neptune DB cluster parameter group.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.</p>
        pub fn db_cluster_parameter_group(
            mut self,
            input: crate::model::DbClusterParameterGroup,
        ) -> Self {
            self.db_cluster_parameter_group = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Neptune DB cluster parameter group.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.</p>
        pub fn set_db_cluster_parameter_group(
            mut self,
            input: std::option::Option<crate::model::DbClusterParameterGroup>,
        ) -> Self {
            self.db_cluster_parameter_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbClusterParameterGroupOutput`](crate::output::CreateDbClusterParameterGroupOutput)
        pub fn build(self) -> crate::output::CreateDbClusterParameterGroupOutput {
            crate::output::CreateDbClusterParameterGroupOutput {
                db_cluster_parameter_group: self.db_cluster_parameter_group,
            }
        }
    }
}
impl CreateDbClusterParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateDbClusterParameterGroupOutput`](crate::output::CreateDbClusterParameterGroupOutput)
    pub fn builder() -> crate::output::create_db_cluster_parameter_group_output::Builder {
        crate::output::create_db_cluster_parameter_group_output::Builder::default()
    }
}

/// <p>This data type represents the information you need to connect to an Amazon Neptune DB cluster. This data type is used as a response element in the following actions:</p>
/// <ul>
/// <li> <p> <code>CreateDBClusterEndpoint</code> </p> </li>
/// <li> <p> <code>DescribeDBClusterEndpoints</code> </p> </li>
/// <li> <p> <code>ModifyDBClusterEndpoint</code> </p> </li>
/// <li> <p> <code>DeleteDBClusterEndpoint</code> </p> </li>
/// </ul>
/// <p>For the data structure that represents Amazon Neptune DB instance endpoints, see <code>Endpoint</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbClusterEndpointOutput {
    /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
    /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    pub db_cluster_endpoint_resource_identifier: std::option::Option<std::string::String>,
    /// <p>The DNS address of the endpoint.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    pub endpoint_type: std::option::Option<std::string::String>,
    /// <p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    pub custom_endpoint_type: std::option::Option<std::string::String>,
    /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    pub static_members: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
    pub excluded_members: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    pub db_cluster_endpoint_arn: std::option::Option<std::string::String>,
}
impl CreateDbClusterEndpointOutput {
    /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub fn db_cluster_endpoint_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_endpoint_identifier.as_deref()
    }
    /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    pub fn db_cluster_endpoint_resource_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_endpoint_resource_identifier.as_deref()
    }
    /// <p>The DNS address of the endpoint.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    pub fn endpoint_type(&self) -> std::option::Option<&str> {
        self.endpoint_type.as_deref()
    }
    /// <p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    pub fn custom_endpoint_type(&self) -> std::option::Option<&str> {
        self.custom_endpoint_type.as_deref()
    }
    /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    pub fn static_members(&self) -> std::option::Option<&[std::string::String]> {
        self.static_members.as_deref()
    }
    /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
    pub fn excluded_members(&self) -> std::option::Option<&[std::string::String]> {
        self.excluded_members.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    pub fn db_cluster_endpoint_arn(&self) -> std::option::Option<&str> {
        self.db_cluster_endpoint_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateDbClusterEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbClusterEndpointOutput");
        formatter.field(
            "db_cluster_endpoint_identifier",
            &self.db_cluster_endpoint_identifier,
        );
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field(
            "db_cluster_endpoint_resource_identifier",
            &self.db_cluster_endpoint_resource_identifier,
        );
        formatter.field("endpoint", &self.endpoint);
        formatter.field("status", &self.status);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("custom_endpoint_type", &self.custom_endpoint_type);
        formatter.field("static_members", &self.static_members);
        formatter.field("excluded_members", &self.excluded_members);
        formatter.field("db_cluster_endpoint_arn", &self.db_cluster_endpoint_arn);
        formatter.finish()
    }
}
/// See [`CreateDbClusterEndpointOutput`](crate::output::CreateDbClusterEndpointOutput)
pub mod create_db_cluster_endpoint_output {
    /// A builder for [`CreateDbClusterEndpointOutput`](crate::output::CreateDbClusterEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_endpoint_resource_identifier:
            std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<std::string::String>,
        pub(crate) custom_endpoint_type: std::option::Option<std::string::String>,
        pub(crate) static_members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) excluded_members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_cluster_endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = Some(input.into());
            self
        }
        /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = input;
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
        pub fn db_cluster_endpoint_resource_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_resource_identifier = Some(input.into());
            self
        }
        /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
        pub fn set_db_cluster_endpoint_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_resource_identifier = input;
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
        pub fn endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_type = Some(input.into());
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn custom_endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_endpoint_type = Some(input.into());
            self
        }
        /// <p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn set_custom_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_endpoint_type = input;
            self
        }
        /// Appends an item to `static_members`.
        ///
        /// To override the contents of this collection use [`set_static_members`](Self::set_static_members).
        ///
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn static_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.static_members.unwrap_or_default();
            v.push(input.into());
            self.static_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn set_static_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.static_members = input;
            self
        }
        /// Appends an item to `excluded_members`.
        ///
        /// To override the contents of this collection use [`set_excluded_members`](Self::set_excluded_members).
        ///
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
        pub fn excluded_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.excluded_members.unwrap_or_default();
            v.push(input.into());
            self.excluded_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
        pub fn set_excluded_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.excluded_members = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
        pub fn db_cluster_endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
        pub fn set_db_cluster_endpoint_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbClusterEndpointOutput`](crate::output::CreateDbClusterEndpointOutput)
        pub fn build(self) -> crate::output::CreateDbClusterEndpointOutput {
            crate::output::CreateDbClusterEndpointOutput {
                db_cluster_endpoint_identifier: self.db_cluster_endpoint_identifier,
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_endpoint_resource_identifier: self
                    .db_cluster_endpoint_resource_identifier,
                endpoint: self.endpoint,
                status: self.status,
                endpoint_type: self.endpoint_type,
                custom_endpoint_type: self.custom_endpoint_type,
                static_members: self.static_members,
                excluded_members: self.excluded_members,
                db_cluster_endpoint_arn: self.db_cluster_endpoint_arn,
            }
        }
    }
}
impl CreateDbClusterEndpointOutput {
    /// Creates a new builder-style object to manufacture [`CreateDbClusterEndpointOutput`](crate::output::CreateDbClusterEndpointOutput)
    pub fn builder() -> crate::output::create_db_cluster_endpoint_output::Builder {
        crate::output::create_db_cluster_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbClusterOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    pub db_cluster: std::option::Option<crate::model::DbCluster>,
}
impl CreateDbClusterOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    pub fn db_cluster(&self) -> std::option::Option<&crate::model::DbCluster> {
        self.db_cluster.as_ref()
    }
}
impl std::fmt::Debug for CreateDbClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbClusterOutput");
        formatter.field("db_cluster", &self.db_cluster);
        formatter.finish()
    }
}
/// See [`CreateDbClusterOutput`](crate::output::CreateDbClusterOutput)
pub mod create_db_cluster_output {
    /// A builder for [`CreateDbClusterOutput`](crate::output::CreateDbClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster: std::option::Option<crate::model::DbCluster>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
        pub fn db_cluster(mut self, input: crate::model::DbCluster) -> Self {
            self.db_cluster = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Neptune DB cluster.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
        pub fn set_db_cluster(
            mut self,
            input: std::option::Option<crate::model::DbCluster>,
        ) -> Self {
            self.db_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbClusterOutput`](crate::output::CreateDbClusterOutput)
        pub fn build(self) -> crate::output::CreateDbClusterOutput {
            crate::output::CreateDbClusterOutput {
                db_cluster: self.db_cluster,
            }
        }
    }
}
impl CreateDbClusterOutput {
    /// Creates a new builder-style object to manufacture [`CreateDbClusterOutput`](crate::output::CreateDbClusterOutput)
    pub fn builder() -> crate::output::create_db_cluster_output::Builder {
        crate::output::create_db_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyDbParameterGroupOutput {
    /// <p>Contains the details of an Amazon Neptune DB parameter group.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.</p>
    pub db_parameter_group: std::option::Option<crate::model::DbParameterGroup>,
}
impl CopyDbParameterGroupOutput {
    /// <p>Contains the details of an Amazon Neptune DB parameter group.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.</p>
    pub fn db_parameter_group(&self) -> std::option::Option<&crate::model::DbParameterGroup> {
        self.db_parameter_group.as_ref()
    }
}
impl std::fmt::Debug for CopyDbParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyDbParameterGroupOutput");
        formatter.field("db_parameter_group", &self.db_parameter_group);
        formatter.finish()
    }
}
/// See [`CopyDbParameterGroupOutput`](crate::output::CopyDbParameterGroupOutput)
pub mod copy_db_parameter_group_output {
    /// A builder for [`CopyDbParameterGroupOutput`](crate::output::CopyDbParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group: std::option::Option<crate::model::DbParameterGroup>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Neptune DB parameter group.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.</p>
        pub fn db_parameter_group(mut self, input: crate::model::DbParameterGroup) -> Self {
            self.db_parameter_group = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Neptune DB parameter group.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.</p>
        pub fn set_db_parameter_group(
            mut self,
            input: std::option::Option<crate::model::DbParameterGroup>,
        ) -> Self {
            self.db_parameter_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyDbParameterGroupOutput`](crate::output::CopyDbParameterGroupOutput)
        pub fn build(self) -> crate::output::CopyDbParameterGroupOutput {
            crate::output::CopyDbParameterGroupOutput {
                db_parameter_group: self.db_parameter_group,
            }
        }
    }
}
impl CopyDbParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`CopyDbParameterGroupOutput`](crate::output::CopyDbParameterGroupOutput)
    pub fn builder() -> crate::output::copy_db_parameter_group_output::Builder {
        crate::output::copy_db_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyDbClusterSnapshotOutput {
    /// <p>Contains the details for an Amazon Neptune DB cluster snapshot</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action.</p>
    pub db_cluster_snapshot: std::option::Option<crate::model::DbClusterSnapshot>,
}
impl CopyDbClusterSnapshotOutput {
    /// <p>Contains the details for an Amazon Neptune DB cluster snapshot</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action.</p>
    pub fn db_cluster_snapshot(&self) -> std::option::Option<&crate::model::DbClusterSnapshot> {
        self.db_cluster_snapshot.as_ref()
    }
}
impl std::fmt::Debug for CopyDbClusterSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyDbClusterSnapshotOutput");
        formatter.field("db_cluster_snapshot", &self.db_cluster_snapshot);
        formatter.finish()
    }
}
/// See [`CopyDbClusterSnapshotOutput`](crate::output::CopyDbClusterSnapshotOutput)
pub mod copy_db_cluster_snapshot_output {
    /// A builder for [`CopyDbClusterSnapshotOutput`](crate::output::CopyDbClusterSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot: std::option::Option<crate::model::DbClusterSnapshot>,
    }
    impl Builder {
        /// <p>Contains the details for an Amazon Neptune DB cluster snapshot</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action.</p>
        pub fn db_cluster_snapshot(mut self, input: crate::model::DbClusterSnapshot) -> Self {
            self.db_cluster_snapshot = Some(input);
            self
        }
        /// <p>Contains the details for an Amazon Neptune DB cluster snapshot</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action.</p>
        pub fn set_db_cluster_snapshot(
            mut self,
            input: std::option::Option<crate::model::DbClusterSnapshot>,
        ) -> Self {
            self.db_cluster_snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyDbClusterSnapshotOutput`](crate::output::CopyDbClusterSnapshotOutput)
        pub fn build(self) -> crate::output::CopyDbClusterSnapshotOutput {
            crate::output::CopyDbClusterSnapshotOutput {
                db_cluster_snapshot: self.db_cluster_snapshot,
            }
        }
    }
}
impl CopyDbClusterSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`CopyDbClusterSnapshotOutput`](crate::output::CopyDbClusterSnapshotOutput)
    pub fn builder() -> crate::output::copy_db_cluster_snapshot_output::Builder {
        crate::output::copy_db_cluster_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyDbClusterParameterGroupOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster parameter group.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.</p>
    pub db_cluster_parameter_group: std::option::Option<crate::model::DbClusterParameterGroup>,
}
impl CopyDbClusterParameterGroupOutput {
    /// <p>Contains the details of an Amazon Neptune DB cluster parameter group.</p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.</p>
    pub fn db_cluster_parameter_group(
        &self,
    ) -> std::option::Option<&crate::model::DbClusterParameterGroup> {
        self.db_cluster_parameter_group.as_ref()
    }
}
impl std::fmt::Debug for CopyDbClusterParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyDbClusterParameterGroupOutput");
        formatter.field(
            "db_cluster_parameter_group",
            &self.db_cluster_parameter_group,
        );
        formatter.finish()
    }
}
/// See [`CopyDbClusterParameterGroupOutput`](crate::output::CopyDbClusterParameterGroupOutput)
pub mod copy_db_cluster_parameter_group_output {
    /// A builder for [`CopyDbClusterParameterGroupOutput`](crate::output::CopyDbClusterParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group:
            std::option::Option<crate::model::DbClusterParameterGroup>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Neptune DB cluster parameter group.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.</p>
        pub fn db_cluster_parameter_group(
            mut self,
            input: crate::model::DbClusterParameterGroup,
        ) -> Self {
            self.db_cluster_parameter_group = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Neptune DB cluster parameter group.</p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.</p>
        pub fn set_db_cluster_parameter_group(
            mut self,
            input: std::option::Option<crate::model::DbClusterParameterGroup>,
        ) -> Self {
            self.db_cluster_parameter_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyDbClusterParameterGroupOutput`](crate::output::CopyDbClusterParameterGroupOutput)
        pub fn build(self) -> crate::output::CopyDbClusterParameterGroupOutput {
            crate::output::CopyDbClusterParameterGroupOutput {
                db_cluster_parameter_group: self.db_cluster_parameter_group,
            }
        }
    }
}
impl CopyDbClusterParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`CopyDbClusterParameterGroupOutput`](crate::output::CopyDbClusterParameterGroupOutput)
    pub fn builder() -> crate::output::copy_db_cluster_parameter_group_output::Builder {
        crate::output::copy_db_cluster_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplyPendingMaintenanceActionOutput {
    /// <p>Describes the pending maintenance actions for a resource.</p>
    pub resource_pending_maintenance_actions:
        std::option::Option<crate::model::ResourcePendingMaintenanceActions>,
}
impl ApplyPendingMaintenanceActionOutput {
    /// <p>Describes the pending maintenance actions for a resource.</p>
    pub fn resource_pending_maintenance_actions(
        &self,
    ) -> std::option::Option<&crate::model::ResourcePendingMaintenanceActions> {
        self.resource_pending_maintenance_actions.as_ref()
    }
}
impl std::fmt::Debug for ApplyPendingMaintenanceActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplyPendingMaintenanceActionOutput");
        formatter.field(
            "resource_pending_maintenance_actions",
            &self.resource_pending_maintenance_actions,
        );
        formatter.finish()
    }
}
/// See [`ApplyPendingMaintenanceActionOutput`](crate::output::ApplyPendingMaintenanceActionOutput)
pub mod apply_pending_maintenance_action_output {
    /// A builder for [`ApplyPendingMaintenanceActionOutput`](crate::output::ApplyPendingMaintenanceActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_pending_maintenance_actions:
            std::option::Option<crate::model::ResourcePendingMaintenanceActions>,
    }
    impl Builder {
        /// <p>Describes the pending maintenance actions for a resource.</p>
        pub fn resource_pending_maintenance_actions(
            mut self,
            input: crate::model::ResourcePendingMaintenanceActions,
        ) -> Self {
            self.resource_pending_maintenance_actions = Some(input);
            self
        }
        /// <p>Describes the pending maintenance actions for a resource.</p>
        pub fn set_resource_pending_maintenance_actions(
            mut self,
            input: std::option::Option<crate::model::ResourcePendingMaintenanceActions>,
        ) -> Self {
            self.resource_pending_maintenance_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplyPendingMaintenanceActionOutput`](crate::output::ApplyPendingMaintenanceActionOutput)
        pub fn build(self) -> crate::output::ApplyPendingMaintenanceActionOutput {
            crate::output::ApplyPendingMaintenanceActionOutput {
                resource_pending_maintenance_actions: self.resource_pending_maintenance_actions,
            }
        }
    }
}
impl ApplyPendingMaintenanceActionOutput {
    /// Creates a new builder-style object to manufacture [`ApplyPendingMaintenanceActionOutput`](crate::output::ApplyPendingMaintenanceActionOutput)
    pub fn builder() -> crate::output::apply_pending_maintenance_action_output::Builder {
        crate::output::apply_pending_maintenance_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsToResourceOutput {}
impl std::fmt::Debug for AddTagsToResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsToResourceOutput");
        formatter.finish()
    }
}
/// See [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
pub mod add_tags_to_resource_output {
    /// A builder for [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
        pub fn build(self) -> crate::output::AddTagsToResourceOutput {
            crate::output::AddTagsToResourceOutput {}
        }
    }
}
impl AddTagsToResourceOutput {
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
    pub fn builder() -> crate::output::add_tags_to_resource_output::Builder {
        crate::output::add_tags_to_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddSourceIdentifierToSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub event_subscription: std::option::Option<crate::model::EventSubscription>,
}
impl AddSourceIdentifierToSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub fn event_subscription(&self) -> std::option::Option<&crate::model::EventSubscription> {
        self.event_subscription.as_ref()
    }
}
impl std::fmt::Debug for AddSourceIdentifierToSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddSourceIdentifierToSubscriptionOutput");
        formatter.field("event_subscription", &self.event_subscription);
        formatter.finish()
    }
}
/// See [`AddSourceIdentifierToSubscriptionOutput`](crate::output::AddSourceIdentifierToSubscriptionOutput)
pub mod add_source_identifier_to_subscription_output {
    /// A builder for [`AddSourceIdentifierToSubscriptionOutput`](crate::output::AddSourceIdentifierToSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_subscription: std::option::Option<crate::model::EventSubscription>,
    }
    impl Builder {
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn event_subscription(mut self, input: crate::model::EventSubscription) -> Self {
            self.event_subscription = Some(input);
            self
        }
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn set_event_subscription(
            mut self,
            input: std::option::Option<crate::model::EventSubscription>,
        ) -> Self {
            self.event_subscription = input;
            self
        }
        /// Consumes the builder and constructs a [`AddSourceIdentifierToSubscriptionOutput`](crate::output::AddSourceIdentifierToSubscriptionOutput)
        pub fn build(self) -> crate::output::AddSourceIdentifierToSubscriptionOutput {
            crate::output::AddSourceIdentifierToSubscriptionOutput {
                event_subscription: self.event_subscription,
            }
        }
    }
}
impl AddSourceIdentifierToSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`AddSourceIdentifierToSubscriptionOutput`](crate::output::AddSourceIdentifierToSubscriptionOutput)
    pub fn builder() -> crate::output::add_source_identifier_to_subscription_output::Builder {
        crate::output::add_source_identifier_to_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddRoleToDbClusterOutput {}
impl std::fmt::Debug for AddRoleToDbClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddRoleToDbClusterOutput");
        formatter.finish()
    }
}
/// See [`AddRoleToDbClusterOutput`](crate::output::AddRoleToDbClusterOutput)
pub mod add_role_to_db_cluster_output {
    /// A builder for [`AddRoleToDbClusterOutput`](crate::output::AddRoleToDbClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddRoleToDbClusterOutput`](crate::output::AddRoleToDbClusterOutput)
        pub fn build(self) -> crate::output::AddRoleToDbClusterOutput {
            crate::output::AddRoleToDbClusterOutput {}
        }
    }
}
impl AddRoleToDbClusterOutput {
    /// Creates a new builder-style object to manufacture [`AddRoleToDbClusterOutput`](crate::output::AddRoleToDbClusterOutput)
    pub fn builder() -> crate::output::add_role_to_db_cluster_output::Builder {
        crate::output::add_role_to_db_cluster_output::Builder::default()
    }
}
