// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddRoleToDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddRoleToDBClusterError {
    /// Kind of error that occurred.
    pub kind: AddRoleToDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddRoleToDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddRoleToDBClusterErrorKind {
    /// <p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The specified IAM role Amazon Resource Name (ARN) is already associated with the specified DB cluster.</p>
    DbClusterRoleAlreadyExistsFault(crate::error::DbClusterRoleAlreadyExistsFault),
    /// <p>You have exceeded the maximum number of IAM roles that can be associated with the specified DB cluster.</p>
    DbClusterRoleQuotaExceededFault(crate::error::DbClusterRoleQuotaExceededFault),
    /// <p>The DB cluster is not in a valid state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddRoleToDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddRoleToDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            AddRoleToDBClusterErrorKind::DbClusterRoleAlreadyExistsFault(_inner) => _inner.fmt(f),
            AddRoleToDBClusterErrorKind::DbClusterRoleQuotaExceededFault(_inner) => _inner.fmt(f),
            AddRoleToDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            AddRoleToDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddRoleToDBClusterError {
    fn code(&self) -> Option<&str> {
        AddRoleToDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddRoleToDBClusterError {
    /// Creates a new `AddRoleToDBClusterError`.
    pub fn new(kind: AddRoleToDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddRoleToDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddRoleToDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddRoleToDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddRoleToDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddRoleToDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddRoleToDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `AddRoleToDBClusterErrorKind::DbClusterRoleAlreadyExistsFault`.
    pub fn is_db_cluster_role_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddRoleToDBClusterErrorKind::DbClusterRoleAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `AddRoleToDBClusterErrorKind::DbClusterRoleQuotaExceededFault`.
    pub fn is_db_cluster_role_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddRoleToDBClusterErrorKind::DbClusterRoleQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `AddRoleToDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddRoleToDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
}
impl std::error::Error for AddRoleToDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddRoleToDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            AddRoleToDBClusterErrorKind::DbClusterRoleAlreadyExistsFault(_inner) => Some(_inner),
            AddRoleToDBClusterErrorKind::DbClusterRoleQuotaExceededFault(_inner) => Some(_inner),
            AddRoleToDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            AddRoleToDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddSourceIdentifierToSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddSourceIdentifierToSubscriptionError {
    /// Kind of error that occurred.
    pub kind: AddSourceIdentifierToSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddSourceIdentifierToSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddSourceIdentifierToSubscriptionErrorKind {
    /// <p>The source could not be found.</p>
    SourceNotFoundFault(crate::error::SourceNotFoundFault),
    /// <p>The designated subscription could not be found.</p>
    SubscriptionNotFoundFault(crate::error::SubscriptionNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddSourceIdentifierToSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddSourceIdentifierToSubscriptionErrorKind::SourceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            AddSourceIdentifierToSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            AddSourceIdentifierToSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddSourceIdentifierToSubscriptionError {
    fn code(&self) -> Option<&str> {
        AddSourceIdentifierToSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddSourceIdentifierToSubscriptionError {
    /// Creates a new `AddSourceIdentifierToSubscriptionError`.
    pub fn new(
        kind: AddSourceIdentifierToSubscriptionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddSourceIdentifierToSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddSourceIdentifierToSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddSourceIdentifierToSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddSourceIdentifierToSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddSourceIdentifierToSubscriptionErrorKind::SourceNotFoundFault`.
    pub fn is_source_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddSourceIdentifierToSubscriptionErrorKind::SourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `AddSourceIdentifierToSubscriptionErrorKind::SubscriptionNotFoundFault`.
    pub fn is_subscription_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddSourceIdentifierToSubscriptionErrorKind::SubscriptionNotFoundFault(_)
        )
    }
}
impl std::error::Error for AddSourceIdentifierToSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddSourceIdentifierToSubscriptionErrorKind::SourceNotFoundFault(_inner) => Some(_inner),
            AddSourceIdentifierToSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => {
                Some(_inner)
            }
            AddSourceIdentifierToSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddTagsToResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddTagsToResourceError {
    /// Kind of error that occurred.
    pub kind: AddTagsToResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddTagsToResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddTagsToResourceErrorKind {
    /// <p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p> <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</p>
    DbSnapshotNotFoundFault(crate::error::DbSnapshotNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddTagsToResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddTagsToResourceErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::DbSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddTagsToResourceError {
    fn code(&self) -> Option<&str> {
        AddTagsToResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddTagsToResourceError {
    /// Creates a new `AddTagsToResourceError`.
    pub fn new(kind: AddTagsToResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddTagsToResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddTagsToResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddTagsToResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddTagsToResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToResourceErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToResourceErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::DbSnapshotNotFoundFault`.
    pub fn is_db_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToResourceErrorKind::DbSnapshotNotFoundFault(_)
        )
    }
}
impl std::error::Error for AddTagsToResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddTagsToResourceErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::DbSnapshotNotFoundFault(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ApplyPendingMaintenanceAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ApplyPendingMaintenanceActionError {
    /// Kind of error that occurred.
    pub kind: ApplyPendingMaintenanceActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ApplyPendingMaintenanceAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ApplyPendingMaintenanceActionErrorKind {
    /// <p>The specified resource ID was not found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ApplyPendingMaintenanceActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ApplyPendingMaintenanceActionErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            ApplyPendingMaintenanceActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ApplyPendingMaintenanceActionError {
    fn code(&self) -> Option<&str> {
        ApplyPendingMaintenanceActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ApplyPendingMaintenanceActionError {
    /// Creates a new `ApplyPendingMaintenanceActionError`.
    pub fn new(
        kind: ApplyPendingMaintenanceActionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ApplyPendingMaintenanceActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ApplyPendingMaintenanceActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ApplyPendingMaintenanceActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ApplyPendingMaintenanceActionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ApplyPendingMaintenanceActionErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ApplyPendingMaintenanceActionErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for ApplyPendingMaintenanceActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ApplyPendingMaintenanceActionErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            ApplyPendingMaintenanceActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CopyDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CopyDBClusterParameterGroupError {
    /// Kind of error that occurred.
    pub kind: CopyDBClusterParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CopyDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CopyDBClusterParameterGroupErrorKind {
    /// <p>A DB parameter group with the same name exists.</p>
    DbParameterGroupAlreadyExistsFault(crate::error::DbParameterGroupAlreadyExistsFault),
    /// <p> <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.</p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p>Request would result in user exceeding the allowed number of DB parameter groups.</p>
    DbParameterGroupQuotaExceededFault(crate::error::DbParameterGroupQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CopyDBClusterParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CopyDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CopyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            CopyDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CopyDBClusterParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CopyDBClusterParameterGroupError {
    fn code(&self) -> Option<&str> {
        CopyDBClusterParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CopyDBClusterParameterGroupError {
    /// Creates a new `CopyDBClusterParameterGroupError`.
    pub fn new(kind: CopyDBClusterParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CopyDBClusterParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CopyDBClusterParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CopyDBClusterParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CopyDBClusterParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CopyDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault`.
    pub fn is_db_parameter_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault`.
    pub fn is_db_parameter_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CopyDBClusterParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CopyDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CopyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            CopyDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CopyDBClusterParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CopyDBClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CopyDBClusterSnapshotError {
    /// Kind of error that occurred.
    pub kind: CopyDBClusterSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CopyDBClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CopyDBClusterSnapshotErrorKind {
    /// <p>User already has a DB cluster snapshot with the given identifier.</p>
    DbClusterSnapshotAlreadyExistsFault(crate::error::DbClusterSnapshotAlreadyExistsFault),
    /// <p> <i>DBClusterSnapshotIdentifier</i> does not refer to an existing DB cluster snapshot.</p>
    DbClusterSnapshotNotFoundFault(crate::error::DbClusterSnapshotNotFoundFault),
    /// <p>The supplied value is not a valid DB cluster snapshot state.</p>
    InvalidDbClusterSnapshotStateFault(crate::error::InvalidDbClusterSnapshotStateFault),
    /// <p>The DB cluster is not in a valid state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>Error accessing KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>Request would result in user exceeding the allowed number of DB snapshots.</p>
    SnapshotQuotaExceededFault(crate::error::SnapshotQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CopyDBClusterSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CopyDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CopyDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            CopyDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            CopyDBClusterSnapshotErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            CopyDBClusterSnapshotErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            CopyDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault(_inner) => _inner.fmt(f),
            CopyDBClusterSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CopyDBClusterSnapshotError {
    fn code(&self) -> Option<&str> {
        CopyDBClusterSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CopyDBClusterSnapshotError {
    /// Creates a new `CopyDBClusterSnapshotError`.
    pub fn new(kind: CopyDBClusterSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CopyDBClusterSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CopyDBClusterSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CopyDBClusterSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CopyDBClusterSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CopyDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault`.
    pub fn is_db_cluster_snapshot_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault`.
    pub fn is_db_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault`.
    pub fn is_invalid_db_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBClusterSnapshotErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBClusterSnapshotErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBClusterSnapshotErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBClusterSnapshotErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault`.
    pub fn is_snapshot_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CopyDBClusterSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CopyDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CopyDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault(_inner) => Some(_inner),
            CopyDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            CopyDBClusterSnapshotErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            CopyDBClusterSnapshotErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            CopyDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault(_inner) => Some(_inner),
            CopyDBClusterSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CopyDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CopyDBParameterGroupError {
    /// Kind of error that occurred.
    pub kind: CopyDBParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CopyDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CopyDBParameterGroupErrorKind {
    /// <p>A DB parameter group with the same name exists.</p>
    DbParameterGroupAlreadyExistsFault(crate::error::DbParameterGroupAlreadyExistsFault),
    /// <p> <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.</p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p>Request would result in user exceeding the allowed number of DB parameter groups.</p>
    DbParameterGroupQuotaExceededFault(crate::error::DbParameterGroupQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CopyDBParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CopyDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CopyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            CopyDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CopyDBParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CopyDBParameterGroupError {
    fn code(&self) -> Option<&str> {
        CopyDBParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CopyDBParameterGroupError {
    /// Creates a new `CopyDBParameterGroupError`.
    pub fn new(kind: CopyDBParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CopyDBParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CopyDBParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CopyDBParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CopyDBParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CopyDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault`.
    pub fn is_db_parameter_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault`.
    pub fn is_db_parameter_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CopyDBParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CopyDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CopyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => Some(_inner),
            CopyDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CopyDBParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDBClusterError {
    /// Kind of error that occurred.
    pub kind: CreateDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDBClusterErrorKind {
    /// <p>User already has a DB cluster with the given identifier.</p>
    DbClusterAlreadyExistsFault(crate::error::DbClusterAlreadyExistsFault),
    /// <p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <i>DBClusterParameterGroupName</i> does not refer to an existing DB Cluster parameter group.</p>
    DbClusterParameterGroupNotFoundFault(crate::error::DbClusterParameterGroupNotFoundFault),
    /// <p>User attempted to create a new DB cluster and the user has already reached the maximum allowed DB cluster quota.</p>
    DbClusterQuotaExceededFault(crate::error::DbClusterQuotaExceededFault),
    /// <p> <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>
    DbSubnetGroupDoesNotCoverEnoughAZs(crate::error::DbSubnetGroupDoesNotCoverEnoughAZs),
    /// <p> <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group.</p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p>There is insufficient storage available for the current action. You may be able to resolve this error by updating your subnet group to use different Availability Zones that have more storage available.</p>
    InsufficientStorageClusterCapacityFault(crate::error::InsufficientStorageClusterCapacityFault),
    /// <p>The DB cluster is not in a valid state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The specified DB instance is not in the <i>available</i> state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>The DB subnet group cannot be deleted because it is in use.</p>
    InvalidDbSubnetGroupStateFault(crate::error::InvalidDbSubnetGroupStateFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>DB subnet group does not cover all Availability Zones after it is created because users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>Error accessing KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>Request would result in user exceeding the allowed amount of storage available across all DB instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDBClusterErrorKind::DbClusterAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::DbClusterParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::DbClusterQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::DbSubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::InsufficientStorageClusterCapacityFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::InvalidDbSubnetGroupStateFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::InvalidVpcNetworkStateFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::StorageQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDBClusterError {
    fn code(&self) -> Option<&str> {
        CreateDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDBClusterError {
    /// Creates a new `CreateDBClusterError`.
    pub fn new(kind: CreateDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::DbClusterAlreadyExistsFault`.
    pub fn is_db_cluster_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::DbClusterAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::DbClusterParameterGroupNotFoundFault`.
    pub fn is_db_cluster_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::DbClusterParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::DbClusterQuotaExceededFault`.
    pub fn is_db_cluster_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::DbClusterQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs`.
    pub fn is_db_subnet_group_does_not_cover_enough_a_zs(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::InsufficientStorageClusterCapacityFault`.
    pub fn is_insufficient_storage_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::InsufficientStorageClusterCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::InvalidDbSubnetGroupStateFault`.
    pub fn is_invalid_db_subnet_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::InvalidDbSubnetGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(&self.kind, CreateDBClusterErrorKind::InvalidSubnet(_))
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::StorageQuotaExceededFault`.
    pub fn is_storage_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::StorageQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CreateDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDBClusterErrorKind::DbClusterAlreadyExistsFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::DbClusterParameterGroupNotFoundFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::DbClusterQuotaExceededFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => Some(_inner),
            CreateDBClusterErrorKind::DbSubnetGroupNotFoundFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::InsufficientStorageClusterCapacityFault(_inner) => {
                Some(_inner)
            }
            CreateDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::InvalidDbSubnetGroupStateFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::InvalidSubnet(_inner) => Some(_inner),
            CreateDBClusterErrorKind::InvalidVpcNetworkStateFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::StorageQuotaExceededFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDBClusterEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDBClusterEndpointError {
    /// Kind of error that occurred.
    pub kind: CreateDBClusterEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDBClusterEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDBClusterEndpointErrorKind {
    /// <p>The specified custom endpoint cannot be created because it already exists.</p>
    DbClusterEndpointAlreadyExistsFault(crate::error::DbClusterEndpointAlreadyExistsFault),
    /// <p>The cluster already has the maximum number of custom endpoints.</p>
    DbClusterEndpointQuotaExceededFault(crate::error::DbClusterEndpointQuotaExceededFault),
    /// <p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The DB cluster is not in a valid state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The specified DB instance is not in the <i>available</i> state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDBClusterEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDBClusterEndpointErrorKind::DbClusterEndpointAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBClusterEndpointErrorKind::DbClusterEndpointQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBClusterEndpointErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBClusterEndpointErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBClusterEndpointErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            CreateDBClusterEndpointErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            CreateDBClusterEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDBClusterEndpointError {
    fn code(&self) -> Option<&str> {
        CreateDBClusterEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDBClusterEndpointError {
    /// Creates a new `CreateDBClusterEndpointError`.
    pub fn new(kind: CreateDBClusterEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDBClusterEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDBClusterEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDBClusterEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDBClusterEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDBClusterEndpointErrorKind::DbClusterEndpointAlreadyExistsFault`.
    pub fn is_db_cluster_endpoint_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterEndpointErrorKind::DbClusterEndpointAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterEndpointErrorKind::DbClusterEndpointQuotaExceededFault`.
    pub fn is_db_cluster_endpoint_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterEndpointErrorKind::DbClusterEndpointQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterEndpointErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterEndpointErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterEndpointErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterEndpointErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterEndpointErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterEndpointErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterEndpointErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterEndpointErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
}
impl std::error::Error for CreateDBClusterEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDBClusterEndpointErrorKind::DbClusterEndpointAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateDBClusterEndpointErrorKind::DbClusterEndpointQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateDBClusterEndpointErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            CreateDBClusterEndpointErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            CreateDBClusterEndpointErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            CreateDBClusterEndpointErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            CreateDBClusterEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDBClusterParameterGroupError {
    /// Kind of error that occurred.
    pub kind: CreateDBClusterParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDBClusterParameterGroupErrorKind {
    /// <p>A DB parameter group with the same name exists.</p>
    DbParameterGroupAlreadyExistsFault(crate::error::DbParameterGroupAlreadyExistsFault),
    /// <p>Request would result in user exceeding the allowed number of DB parameter groups.</p>
    DbParameterGroupQuotaExceededFault(crate::error::DbParameterGroupQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDBClusterParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBClusterParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDBClusterParameterGroupError {
    fn code(&self) -> Option<&str> {
        CreateDBClusterParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDBClusterParameterGroupError {
    /// Creates a new `CreateDBClusterParameterGroupError`.
    pub fn new(
        kind: CreateDBClusterParameterGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDBClusterParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDBClusterParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDBClusterParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDBClusterParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault`.
    pub fn is_db_parameter_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault`.
    pub fn is_db_parameter_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CreateDBClusterParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateDBClusterParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDBClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDBClusterSnapshotError {
    /// Kind of error that occurred.
    pub kind: CreateDBClusterSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDBClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDBClusterSnapshotErrorKind {
    /// <p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>User already has a DB cluster snapshot with the given identifier.</p>
    DbClusterSnapshotAlreadyExistsFault(crate::error::DbClusterSnapshotAlreadyExistsFault),
    /// <p>The supplied value is not a valid DB cluster snapshot state.</p>
    InvalidDbClusterSnapshotStateFault(crate::error::InvalidDbClusterSnapshotStateFault),
    /// <p>The DB cluster is not in a valid state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>Request would result in user exceeding the allowed number of DB snapshots.</p>
    SnapshotQuotaExceededFault(crate::error::SnapshotQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDBClusterSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDBClusterSnapshotErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBClusterSnapshotErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            CreateDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateDBClusterSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDBClusterSnapshotError {
    fn code(&self) -> Option<&str> {
        CreateDBClusterSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDBClusterSnapshotError {
    /// Creates a new `CreateDBClusterSnapshotError`.
    pub fn new(kind: CreateDBClusterSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDBClusterSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDBClusterSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDBClusterSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDBClusterSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDBClusterSnapshotErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterSnapshotErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault`.
    pub fn is_db_cluster_snapshot_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault`.
    pub fn is_invalid_db_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterSnapshotErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterSnapshotErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault`.
    pub fn is_snapshot_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CreateDBClusterSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDBClusterSnapshotErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            CreateDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            CreateDBClusterSnapshotErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            CreateDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault(_inner) => Some(_inner),
            CreateDBClusterSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDBInstanceError {
    /// Kind of error that occurred.
    pub kind: CreateDBInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDBInstanceErrorKind {
    /// <p>Specified CIDRIP or EC2 security group is not authorized for the specified DB security group.</p>
    /// <p>Neptune may not also be authorized via IAM to perform necessary actions on your behalf.</p>
    AuthorizationNotFoundFault(crate::error::AuthorizationNotFoundFault),
    /// <p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>User already has a DB instance with the given identifier.</p>
    DbInstanceAlreadyExistsFault(crate::error::DbInstanceAlreadyExistsFault),
    /// <p> <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.</p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p> <i>DBSecurityGroupName</i> does not refer to an existing DB security group.</p>
    DbSecurityGroupNotFoundFault(crate::error::DbSecurityGroupNotFoundFault),
    /// <p>Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>
    DbSubnetGroupDoesNotCoverEnoughAZs(crate::error::DbSubnetGroupDoesNotCoverEnoughAZs),
    /// <p> <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group.</p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p> <i>Domain</i> does not refer to an existing Active Directory Domain.</p>
    DomainNotFoundFault(crate::error::DomainNotFoundFault),
    /// <p>Request would result in user exceeding the allowed number of DB instances.</p>
    InstanceQuotaExceededFault(crate::error::InstanceQuotaExceededFault),
    /// <p>Specified DB instance class is not available in the specified Availability Zone.</p>
    InsufficientDbInstanceCapacityFault(crate::error::InsufficientDbInstanceCapacityFault),
    /// <p>The DB cluster is not in a valid state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>DB subnet group does not cover all Availability Zones after it is created because users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>Error accessing KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The designated option group could not be found.</p>
    OptionGroupNotFoundFault(crate::error::OptionGroupNotFoundFault),
    /// <p>Provisioned IOPS not available in the specified Availability Zone.</p>
    ProvisionedIopsNotAvailableInAzFault(crate::error::ProvisionedIopsNotAvailableInAzFault),
    /// <p>Request would result in user exceeding the allowed amount of storage available across all DB instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// <p> <i>StorageType</i> specified cannot be associated with the DB Instance.</p>
    StorageTypeNotSupportedFault(crate::error::StorageTypeNotSupportedFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDBInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDBInstanceErrorKind::AuthorizationNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::DbInstanceAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::DbParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::DbSecurityGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::DbSubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::DomainNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::InstanceQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::InvalidVpcNetworkStateFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::OptionGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBInstanceErrorKind::StorageQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::StorageTypeNotSupportedFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDBInstanceError {
    fn code(&self) -> Option<&str> {
        CreateDBInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDBInstanceError {
    /// Creates a new `CreateDBInstanceError`.
    pub fn new(kind: CreateDBInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDBInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDBInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDBInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDBInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::AuthorizationNotFoundFault`.
    pub fn is_authorization_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::AuthorizationNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::DbInstanceAlreadyExistsFault`.
    pub fn is_db_instance_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::DbInstanceAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::DbSecurityGroupNotFoundFault`.
    pub fn is_db_security_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::DbSecurityGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs`.
    pub fn is_db_subnet_group_does_not_cover_enough_a_zs(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::DomainNotFoundFault`.
    pub fn is_domain_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::DomainNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::InstanceQuotaExceededFault`.
    pub fn is_instance_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::InstanceQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::InsufficientDbInstanceCapacityFault`.
    pub fn is_insufficient_db_instance_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(&self.kind, CreateDBInstanceErrorKind::InvalidSubnet(_))
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::OptionGroupNotFoundFault`.
    pub fn is_option_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::OptionGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault`.
    pub fn is_provisioned_iops_not_available_in_az_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::StorageQuotaExceededFault`.
    pub fn is_storage_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::StorageQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::StorageTypeNotSupportedFault`.
    pub fn is_storage_type_not_supported_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::StorageTypeNotSupportedFault(_)
        )
    }
}
impl std::error::Error for CreateDBInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDBInstanceErrorKind::AuthorizationNotFoundFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::DbInstanceAlreadyExistsFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::DbParameterGroupNotFoundFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::DbSecurityGroupNotFoundFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::DbSubnetGroupNotFoundFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::DomainNotFoundFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::InstanceQuotaExceededFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::InvalidSubnet(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::InvalidVpcNetworkStateFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::OptionGroupNotFoundFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::StorageQuotaExceededFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::StorageTypeNotSupportedFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDBParameterGroupError {
    /// Kind of error that occurred.
    pub kind: CreateDBParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDBParameterGroupErrorKind {
    /// <p>A DB parameter group with the same name exists.</p>
    DbParameterGroupAlreadyExistsFault(crate::error::DbParameterGroupAlreadyExistsFault),
    /// <p>Request would result in user exceeding the allowed number of DB parameter groups.</p>
    DbParameterGroupQuotaExceededFault(crate::error::DbParameterGroupQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDBParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDBParameterGroupError {
    fn code(&self) -> Option<&str> {
        CreateDBParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDBParameterGroupError {
    /// Creates a new `CreateDBParameterGroupError`.
    pub fn new(kind: CreateDBParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDBParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDBParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDBParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDBParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault`.
    pub fn is_db_parameter_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault`.
    pub fn is_db_parameter_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CreateDBParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateDBParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDBSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDBSubnetGroupError {
    /// Kind of error that occurred.
    pub kind: CreateDBSubnetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDBSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDBSubnetGroupErrorKind {
    /// <p> <i>DBSubnetGroupName</i> is already used by an existing DB subnet group.</p>
    DbSubnetGroupAlreadyExistsFault(crate::error::DbSubnetGroupAlreadyExistsFault),
    /// <p>Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>
    DbSubnetGroupDoesNotCoverEnoughAZs(crate::error::DbSubnetGroupDoesNotCoverEnoughAZs),
    /// <p>Request would result in user exceeding the allowed number of DB subnet groups.</p>
    DbSubnetGroupQuotaExceededFault(crate::error::DbSubnetGroupQuotaExceededFault),
    /// <p>Request would result in user exceeding the allowed number of subnets in a DB subnet groups.</p>
    DbSubnetQuotaExceededFault(crate::error::DbSubnetQuotaExceededFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDBSubnetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDBSubnetGroupErrorKind::DbSubnetGroupAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => {
                _inner.fmt(f)
            }
            CreateDBSubnetGroupErrorKind::DbSubnetGroupQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateDBSubnetGroupErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            CreateDBSubnetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDBSubnetGroupError {
    fn code(&self) -> Option<&str> {
        CreateDBSubnetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDBSubnetGroupError {
    /// Creates a new `CreateDBSubnetGroupError`.
    pub fn new(kind: CreateDBSubnetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDBSubnetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDBSubnetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDBSubnetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDBSubnetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDBSubnetGroupErrorKind::DbSubnetGroupAlreadyExistsFault`.
    pub fn is_db_subnet_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBSubnetGroupErrorKind::DbSubnetGroupAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs`.
    pub fn is_db_subnet_group_does_not_cover_enough_a_zs(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBSubnetGroupErrorKind::DbSubnetGroupQuotaExceededFault`.
    pub fn is_db_subnet_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBSubnetGroupErrorKind::DbSubnetGroupQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault`.
    pub fn is_db_subnet_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBSubnetGroupErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(&self.kind, CreateDBSubnetGroupErrorKind::InvalidSubnet(_))
    }
}
impl std::error::Error for CreateDBSubnetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDBSubnetGroupErrorKind::DbSubnetGroupAlreadyExistsFault(_inner) => Some(_inner),
            CreateDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => {
                Some(_inner)
            }
            CreateDBSubnetGroupErrorKind::DbSubnetGroupQuotaExceededFault(_inner) => Some(_inner),
            CreateDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault(_inner) => Some(_inner),
            CreateDBSubnetGroupErrorKind::InvalidSubnet(_inner) => Some(_inner),
            CreateDBSubnetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEventSubscriptionError {
    /// Kind of error that occurred.
    pub kind: CreateEventSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEventSubscriptionErrorKind {
    /// <p>You have exceeded the number of events you can subscribe to.</p>
    EventSubscriptionQuotaExceededFault(crate::error::EventSubscriptionQuotaExceededFault),
    /// <p>The SNS topic is invalid.</p>
    SnsInvalidTopicFault(crate::error::SnsInvalidTopicFault),
    /// <p>There is no SNS authorization.</p>
    SnsNoAuthorizationFault(crate::error::SnsNoAuthorizationFault),
    /// <p>The ARN of the SNS topic could not be found.</p>
    SnsTopicArnNotFoundFault(crate::error::SnsTopicArnNotFoundFault),
    /// <p>The source could not be found.</p>
    SourceNotFoundFault(crate::error::SourceNotFoundFault),
    /// <p>This subscription already exists.</p>
    SubscriptionAlreadyExistFault(crate::error::SubscriptionAlreadyExistFault),
    /// <p>The designated subscription category could not be found.</p>
    SubscriptionCategoryNotFoundFault(crate::error::SubscriptionCategoryNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEventSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateEventSubscriptionErrorKind::SnsInvalidTopicFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::SourceNotFoundFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::SubscriptionAlreadyExistFault(_inner) => {
                _inner.fmt(f)
            }
            CreateEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            CreateEventSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEventSubscriptionError {
    fn code(&self) -> Option<&str> {
        CreateEventSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEventSubscriptionError {
    /// Creates a new `CreateEventSubscriptionError`.
    pub fn new(kind: CreateEventSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEventSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEventSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEventSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEventSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault`.
    pub fn is_event_subscription_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SnsInvalidTopicFault`.
    pub fn is_sns_invalid_topic_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SnsInvalidTopicFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault`.
    pub fn is_sns_no_authorization_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SnsTopicArnNotFoundFault`.
    pub fn is_sns_topic_arn_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SourceNotFoundFault`.
    pub fn is_source_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SubscriptionAlreadyExistFault`.
    pub fn is_subscription_already_exist_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SubscriptionAlreadyExistFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault`.
    pub fn is_subscription_category_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(_)
        )
    }
}
impl std::error::Error for CreateEventSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateEventSubscriptionErrorKind::SnsInvalidTopicFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::SourceNotFoundFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::SubscriptionAlreadyExistFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(_inner) => {
                Some(_inner)
            }
            CreateEventSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDBClusterError {
    /// Kind of error that occurred.
    pub kind: DeleteDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDBClusterErrorKind {
    /// <p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>User already has a DB cluster snapshot with the given identifier.</p>
    DbClusterSnapshotAlreadyExistsFault(crate::error::DbClusterSnapshotAlreadyExistsFault),
    /// <p>The supplied value is not a valid DB cluster snapshot state.</p>
    InvalidDbClusterSnapshotStateFault(crate::error::InvalidDbClusterSnapshotStateFault),
    /// <p>The DB cluster is not in a valid state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>Request would result in user exceeding the allowed number of DB snapshots.</p>
    SnapshotQuotaExceededFault(crate::error::SnapshotQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            DeleteDBClusterErrorKind::DbClusterSnapshotAlreadyExistsFault(_inner) => _inner.fmt(f),
            DeleteDBClusterErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => _inner.fmt(f),
            DeleteDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            DeleteDBClusterErrorKind::SnapshotQuotaExceededFault(_inner) => _inner.fmt(f),
            DeleteDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDBClusterError {
    fn code(&self) -> Option<&str> {
        DeleteDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDBClusterError {
    /// Creates a new `DeleteDBClusterError`.
    pub fn new(kind: DeleteDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBClusterErrorKind::DbClusterSnapshotAlreadyExistsFault`.
    pub fn is_db_cluster_snapshot_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterErrorKind::DbClusterSnapshotAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBClusterErrorKind::InvalidDbClusterSnapshotStateFault`.
    pub fn is_invalid_db_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterErrorKind::InvalidDbClusterSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBClusterErrorKind::SnapshotQuotaExceededFault`.
    pub fn is_snapshot_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterErrorKind::SnapshotQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for DeleteDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            DeleteDBClusterErrorKind::DbClusterSnapshotAlreadyExistsFault(_inner) => Some(_inner),
            DeleteDBClusterErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => Some(_inner),
            DeleteDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            DeleteDBClusterErrorKind::SnapshotQuotaExceededFault(_inner) => Some(_inner),
            DeleteDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDBClusterEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDBClusterEndpointError {
    /// Kind of error that occurred.
    pub kind: DeleteDBClusterEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDBClusterEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDBClusterEndpointErrorKind {
    /// <p>The specified custom endpoint doesn't exist.</p>
    DbClusterEndpointNotFoundFault(crate::error::DbClusterEndpointNotFoundFault),
    /// <p>The requested operation cannot be performed on the endpoint while the endpoint is in this state.</p>
    InvalidDbClusterEndpointStateFault(crate::error::InvalidDbClusterEndpointStateFault),
    /// <p>The DB cluster is not in a valid state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDBClusterEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteDBClusterEndpointErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            DeleteDBClusterEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDBClusterEndpointError {
    fn code(&self) -> Option<&str> {
        DeleteDBClusterEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDBClusterEndpointError {
    /// Creates a new `DeleteDBClusterEndpointError`.
    pub fn new(kind: DeleteDBClusterEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDBClusterEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDBClusterEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDBClusterEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDBClusterEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault`.
    pub fn is_db_cluster_endpoint_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault`.
    pub fn is_invalid_db_cluster_endpoint_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBClusterEndpointErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterEndpointErrorKind::InvalidDbClusterStateFault(_)
        )
    }
}
impl std::error::Error for DeleteDBClusterEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault(_inner) => {
                Some(_inner)
            }
            DeleteDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault(_inner) => {
                Some(_inner)
            }
            DeleteDBClusterEndpointErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            DeleteDBClusterEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDBClusterParameterGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteDBClusterParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDBClusterParameterGroupErrorKind {
    /// <p> <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.</p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p>The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter group, you cannot delete it when the parameter group is in this state.</p>
    InvalidDbParameterGroupStateFault(crate::error::InvalidDbParameterGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDBClusterParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteDBClusterParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDBClusterParameterGroupError {
    fn code(&self) -> Option<&str> {
        DeleteDBClusterParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDBClusterParameterGroupError {
    /// Creates a new `DeleteDBClusterParameterGroupError`.
    pub fn new(
        kind: DeleteDBClusterParameterGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDBClusterParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDBClusterParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDBClusterParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDBClusterParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault`.
    pub fn is_invalid_db_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_)
        )
    }
}
impl std::error::Error for DeleteDBClusterParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            DeleteDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                Some(_inner)
            }
            DeleteDBClusterParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDBClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDBClusterSnapshotError {
    /// Kind of error that occurred.
    pub kind: DeleteDBClusterSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDBClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDBClusterSnapshotErrorKind {
    /// <p> <i>DBClusterSnapshotIdentifier</i> does not refer to an existing DB cluster snapshot.</p>
    DbClusterSnapshotNotFoundFault(crate::error::DbClusterSnapshotNotFoundFault),
    /// <p>The supplied value is not a valid DB cluster snapshot state.</p>
    InvalidDbClusterSnapshotStateFault(crate::error::InvalidDbClusterSnapshotStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDBClusterSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteDBClusterSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDBClusterSnapshotError {
    fn code(&self) -> Option<&str> {
        DeleteDBClusterSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDBClusterSnapshotError {
    /// Creates a new `DeleteDBClusterSnapshotError`.
    pub fn new(kind: DeleteDBClusterSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDBClusterSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDBClusterSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDBClusterSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDBClusterSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault`.
    pub fn is_db_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault`.
    pub fn is_invalid_db_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_)
        )
    }
}
impl std::error::Error for DeleteDBClusterSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                Some(_inner)
            }
            DeleteDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            DeleteDBClusterSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDBInstanceError {
    /// Kind of error that occurred.
    pub kind: DeleteDBInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDBInstanceErrorKind {
    /// <p> <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p> <i>DBSnapshotIdentifier</i> is already used by an existing snapshot.</p>
    DbSnapshotAlreadyExistsFault(crate::error::DbSnapshotAlreadyExistsFault),
    /// <p>The DB cluster is not in a valid state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The specified DB instance is not in the <i>available</i> state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>Request would result in user exceeding the allowed number of DB snapshots.</p>
    SnapshotQuotaExceededFault(crate::error::SnapshotQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDBInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            DeleteDBInstanceErrorKind::DbSnapshotAlreadyExistsFault(_inner) => _inner.fmt(f),
            DeleteDBInstanceErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            DeleteDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            DeleteDBInstanceErrorKind::SnapshotQuotaExceededFault(_inner) => _inner.fmt(f),
            DeleteDBInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDBInstanceError {
    fn code(&self) -> Option<&str> {
        DeleteDBInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDBInstanceError {
    /// Creates a new `DeleteDBInstanceError`.
    pub fn new(kind: DeleteDBInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDBInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDBInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDBInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDBInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDBInstanceErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBInstanceErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBInstanceErrorKind::DbSnapshotAlreadyExistsFault`.
    pub fn is_db_snapshot_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBInstanceErrorKind::DbSnapshotAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBInstanceErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBInstanceErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBInstanceErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBInstanceErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBInstanceErrorKind::SnapshotQuotaExceededFault`.
    pub fn is_snapshot_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBInstanceErrorKind::SnapshotQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for DeleteDBInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            DeleteDBInstanceErrorKind::DbSnapshotAlreadyExistsFault(_inner) => Some(_inner),
            DeleteDBInstanceErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            DeleteDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            DeleteDBInstanceErrorKind::SnapshotQuotaExceededFault(_inner) => Some(_inner),
            DeleteDBInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDBParameterGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteDBParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDBParameterGroupErrorKind {
    /// <p> <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.</p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p>The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter group, you cannot delete it when the parameter group is in this state.</p>
    InvalidDbParameterGroupStateFault(crate::error::InvalidDbParameterGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDBParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            DeleteDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteDBParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDBParameterGroupError {
    fn code(&self) -> Option<&str> {
        DeleteDBParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDBParameterGroupError {
    /// Creates a new `DeleteDBParameterGroupError`.
    pub fn new(kind: DeleteDBParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDBParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDBParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDBParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDBParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDBParameterGroupErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault`.
    pub fn is_invalid_db_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_)
        )
    }
}
impl std::error::Error for DeleteDBParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => Some(_inner),
            DeleteDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                Some(_inner)
            }
            DeleteDBParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDBSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDBSubnetGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteDBSubnetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDBSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDBSubnetGroupErrorKind {
    /// <p> <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group.</p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p>The DB subnet group cannot be deleted because it is in use.</p>
    InvalidDbSubnetGroupStateFault(crate::error::InvalidDbSubnetGroupStateFault),
    /// <p>The DB subnet is not in the <i>available</i> state.</p>
    InvalidDbSubnetStateFault(crate::error::InvalidDbSubnetStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDBSubnetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            DeleteDBSubnetGroupErrorKind::InvalidDbSubnetGroupStateFault(_inner) => _inner.fmt(f),
            DeleteDBSubnetGroupErrorKind::InvalidDbSubnetStateFault(_inner) => _inner.fmt(f),
            DeleteDBSubnetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDBSubnetGroupError {
    fn code(&self) -> Option<&str> {
        DeleteDBSubnetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDBSubnetGroupError {
    /// Creates a new `DeleteDBSubnetGroupError`.
    pub fn new(kind: DeleteDBSubnetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDBSubnetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDBSubnetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDBSubnetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDBSubnetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBSubnetGroupErrorKind::InvalidDbSubnetGroupStateFault`.
    pub fn is_invalid_db_subnet_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBSubnetGroupErrorKind::InvalidDbSubnetGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBSubnetGroupErrorKind::InvalidDbSubnetStateFault`.
    pub fn is_invalid_db_subnet_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBSubnetGroupErrorKind::InvalidDbSubnetStateFault(_)
        )
    }
}
impl std::error::Error for DeleteDBSubnetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault(_inner) => Some(_inner),
            DeleteDBSubnetGroupErrorKind::InvalidDbSubnetGroupStateFault(_inner) => Some(_inner),
            DeleteDBSubnetGroupErrorKind::InvalidDbSubnetStateFault(_inner) => Some(_inner),
            DeleteDBSubnetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEventSubscriptionError {
    /// Kind of error that occurred.
    pub kind: DeleteEventSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEventSubscriptionErrorKind {
    /// <p>The event subscription is in an invalid state.</p>
    InvalidEventSubscriptionStateFault(crate::error::InvalidEventSubscriptionStateFault),
    /// <p>The designated subscription could not be found.</p>
    SubscriptionNotFoundFault(crate::error::SubscriptionNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEventSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEventSubscriptionErrorKind::InvalidEventSubscriptionStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteEventSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => _inner.fmt(f),
            DeleteEventSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEventSubscriptionError {
    fn code(&self) -> Option<&str> {
        DeleteEventSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEventSubscriptionError {
    /// Creates a new `DeleteEventSubscriptionError`.
    pub fn new(kind: DeleteEventSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEventSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEventSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEventSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEventSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEventSubscriptionErrorKind::InvalidEventSubscriptionStateFault`.
    pub fn is_invalid_event_subscription_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventSubscriptionErrorKind::InvalidEventSubscriptionStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventSubscriptionErrorKind::SubscriptionNotFoundFault`.
    pub fn is_subscription_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventSubscriptionErrorKind::SubscriptionNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteEventSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEventSubscriptionErrorKind::InvalidEventSubscriptionStateFault(_inner) => {
                Some(_inner)
            }
            DeleteEventSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => Some(_inner),
            DeleteEventSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBClusterEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBClusterEndpointsError {
    /// Kind of error that occurred.
    pub kind: DescribeDBClusterEndpointsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBClusterEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBClusterEndpointsErrorKind {
    /// <p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBClusterEndpointsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBClusterEndpointsErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            DescribeDBClusterEndpointsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBClusterEndpointsError {
    fn code(&self) -> Option<&str> {
        DescribeDBClusterEndpointsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBClusterEndpointsError {
    /// Creates a new `DescribeDBClusterEndpointsError`.
    pub fn new(kind: DescribeDBClusterEndpointsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBClusterEndpointsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBClusterEndpointsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBClusterEndpointsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBClusterEndpointsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBClusterEndpointsErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBClusterEndpointsErrorKind::DbClusterNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBClusterEndpointsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBClusterEndpointsErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            DescribeDBClusterEndpointsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBClusterParameterGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBClusterParameterGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeDBClusterParameterGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBClusterParameterGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBClusterParameterGroupsErrorKind {
    /// <p> <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.</p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBClusterParameterGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBClusterParameterGroupsErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeDBClusterParameterGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBClusterParameterGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeDBClusterParameterGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBClusterParameterGroupsError {
    /// Creates a new `DescribeDBClusterParameterGroupsError`.
    pub fn new(
        kind: DescribeDBClusterParameterGroupsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBClusterParameterGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBClusterParameterGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBClusterParameterGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBClusterParameterGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBClusterParameterGroupsErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBClusterParameterGroupsErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBClusterParameterGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBClusterParameterGroupsErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeDBClusterParameterGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBClusterParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBClusterParametersError {
    /// Kind of error that occurred.
    pub kind: DescribeDBClusterParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBClusterParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBClusterParametersErrorKind {
    /// <p> <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.</p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBClusterParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBClusterParametersErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeDBClusterParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBClusterParametersError {
    fn code(&self) -> Option<&str> {
        DescribeDBClusterParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBClusterParametersError {
    /// Creates a new `DescribeDBClusterParametersError`.
    pub fn new(kind: DescribeDBClusterParametersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBClusterParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBClusterParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBClusterParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBClusterParametersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBClusterParametersErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBClusterParametersErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBClusterParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBClusterParametersErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeDBClusterParametersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBClustersError {
    /// Kind of error that occurred.
    pub kind: DescribeDBClustersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBClustersErrorKind {
    /// <p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBClustersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBClustersErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            DescribeDBClustersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBClustersError {
    fn code(&self) -> Option<&str> {
        DescribeDBClustersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBClustersError {
    /// Creates a new `DescribeDBClustersError`.
    pub fn new(kind: DescribeDBClustersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBClustersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBClustersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBClustersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBClustersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBClustersErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBClustersErrorKind::DbClusterNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBClustersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBClustersErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            DescribeDBClustersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBClusterSnapshotAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBClusterSnapshotAttributesError {
    /// Kind of error that occurred.
    pub kind: DescribeDBClusterSnapshotAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBClusterSnapshotAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBClusterSnapshotAttributesErrorKind {
    /// <p> <i>DBClusterSnapshotIdentifier</i> does not refer to an existing DB cluster snapshot.</p>
    DbClusterSnapshotNotFoundFault(crate::error::DbClusterSnapshotNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBClusterSnapshotAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBClusterSnapshotAttributesErrorKind::DbClusterSnapshotNotFoundFault(
                _inner,
            ) => _inner.fmt(f),
            DescribeDBClusterSnapshotAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBClusterSnapshotAttributesError {
    fn code(&self) -> Option<&str> {
        DescribeDBClusterSnapshotAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBClusterSnapshotAttributesError {
    /// Creates a new `DescribeDBClusterSnapshotAttributesError`.
    pub fn new(
        kind: DescribeDBClusterSnapshotAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBClusterSnapshotAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBClusterSnapshotAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBClusterSnapshotAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBClusterSnapshotAttributesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBClusterSnapshotAttributesErrorKind::DbClusterSnapshotNotFoundFault`.
    pub fn is_db_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBClusterSnapshotAttributesErrorKind::DbClusterSnapshotNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBClusterSnapshotAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBClusterSnapshotAttributesErrorKind::DbClusterSnapshotNotFoundFault(
                _inner,
            ) => Some(_inner),
            DescribeDBClusterSnapshotAttributesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeDBClusterSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBClusterSnapshotsError {
    /// Kind of error that occurred.
    pub kind: DescribeDBClusterSnapshotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBClusterSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBClusterSnapshotsErrorKind {
    /// <p> <i>DBClusterSnapshotIdentifier</i> does not refer to an existing DB cluster snapshot.</p>
    DbClusterSnapshotNotFoundFault(crate::error::DbClusterSnapshotNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBClusterSnapshotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBClusterSnapshotsErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeDBClusterSnapshotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBClusterSnapshotsError {
    fn code(&self) -> Option<&str> {
        DescribeDBClusterSnapshotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBClusterSnapshotsError {
    /// Creates a new `DescribeDBClusterSnapshotsError`.
    pub fn new(kind: DescribeDBClusterSnapshotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBClusterSnapshotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBClusterSnapshotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBClusterSnapshotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBClusterSnapshotsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBClusterSnapshotsErrorKind::DbClusterSnapshotNotFoundFault`.
    pub fn is_db_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBClusterSnapshotsErrorKind::DbClusterSnapshotNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBClusterSnapshotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBClusterSnapshotsErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeDBClusterSnapshotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBEngineVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBEngineVersionsError {
    /// Kind of error that occurred.
    pub kind: DescribeDBEngineVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBEngineVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBEngineVersionsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBEngineVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBEngineVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBEngineVersionsError {
    fn code(&self) -> Option<&str> {
        DescribeDBEngineVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBEngineVersionsError {
    /// Creates a new `DescribeDBEngineVersionsError`.
    pub fn new(kind: DescribeDBEngineVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBEngineVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBEngineVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBEngineVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBEngineVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeDBEngineVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBEngineVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBInstancesError {
    /// Kind of error that occurred.
    pub kind: DescribeDBInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBInstancesErrorKind {
    /// <p> <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBInstancesErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            DescribeDBInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBInstancesError {
    fn code(&self) -> Option<&str> {
        DescribeDBInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBInstancesError {
    /// Creates a new `DescribeDBInstancesError`.
    pub fn new(kind: DescribeDBInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBInstancesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBInstancesErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBInstancesErrorKind::DbInstanceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBInstancesErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            DescribeDBInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBParameterGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBParameterGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeDBParameterGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBParameterGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBParameterGroupsErrorKind {
    /// <p> <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.</p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBParameterGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBParameterGroupsErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeDBParameterGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBParameterGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeDBParameterGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBParameterGroupsError {
    /// Creates a new `DescribeDBParameterGroupsError`.
    pub fn new(kind: DescribeDBParameterGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBParameterGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBParameterGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBParameterGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBParameterGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBParameterGroupsErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBParameterGroupsErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBParameterGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBParameterGroupsErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeDBParameterGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBParametersError {
    /// Kind of error that occurred.
    pub kind: DescribeDBParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBParametersErrorKind {
    /// <p> <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.</p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBParametersErrorKind::DbParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            DescribeDBParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBParametersError {
    fn code(&self) -> Option<&str> {
        DescribeDBParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBParametersError {
    /// Creates a new `DescribeDBParametersError`.
    pub fn new(kind: DescribeDBParametersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBParametersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBParametersErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBParametersErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBParametersErrorKind::DbParameterGroupNotFoundFault(_inner) => Some(_inner),
            DescribeDBParametersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBSubnetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBSubnetGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeDBSubnetGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBSubnetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBSubnetGroupsErrorKind {
    /// <p> <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group.</p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBSubnetGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBSubnetGroupsErrorKind::DbSubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            DescribeDBSubnetGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBSubnetGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeDBSubnetGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBSubnetGroupsError {
    /// Creates a new `DescribeDBSubnetGroupsError`.
    pub fn new(kind: DescribeDBSubnetGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBSubnetGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBSubnetGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBSubnetGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBSubnetGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBSubnetGroupsErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBSubnetGroupsErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBSubnetGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBSubnetGroupsErrorKind::DbSubnetGroupNotFoundFault(_inner) => Some(_inner),
            DescribeDBSubnetGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEngineDefaultClusterParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEngineDefaultClusterParametersError {
    /// Kind of error that occurred.
    pub kind: DescribeEngineDefaultClusterParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEngineDefaultClusterParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEngineDefaultClusterParametersErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEngineDefaultClusterParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEngineDefaultClusterParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEngineDefaultClusterParametersError {
    fn code(&self) -> Option<&str> {
        DescribeEngineDefaultClusterParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEngineDefaultClusterParametersError {
    /// Creates a new `DescribeEngineDefaultClusterParametersError`.
    pub fn new(
        kind: DescribeEngineDefaultClusterParametersErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEngineDefaultClusterParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEngineDefaultClusterParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEngineDefaultClusterParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEngineDefaultClusterParametersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeEngineDefaultClusterParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEngineDefaultClusterParametersErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeEngineDefaultParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEngineDefaultParametersError {
    /// Kind of error that occurred.
    pub kind: DescribeEngineDefaultParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEngineDefaultParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEngineDefaultParametersErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEngineDefaultParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEngineDefaultParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEngineDefaultParametersError {
    fn code(&self) -> Option<&str> {
        DescribeEngineDefaultParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEngineDefaultParametersError {
    /// Creates a new `DescribeEngineDefaultParametersError`.
    pub fn new(
        kind: DescribeEngineDefaultParametersErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEngineDefaultParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEngineDefaultParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEngineDefaultParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEngineDefaultParametersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeEngineDefaultParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEngineDefaultParametersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEventCategories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventCategoriesError {
    /// Kind of error that occurred.
    pub kind: DescribeEventCategoriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEventCategories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventCategoriesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventCategoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventCategoriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventCategoriesError {
    fn code(&self) -> Option<&str> {
        DescribeEventCategoriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventCategoriesError {
    /// Creates a new `DescribeEventCategoriesError`.
    pub fn new(kind: DescribeEventCategoriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventCategoriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventCategoriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventCategoriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventCategoriesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeEventCategoriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventCategoriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventsError {
    /// Kind of error that occurred.
    pub kind: DescribeEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventsError {
    fn code(&self) -> Option<&str> {
        DescribeEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventsError {
    /// Creates a new `DescribeEventsError`.
    pub fn new(kind: DescribeEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEventSubscriptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventSubscriptionsError {
    /// Kind of error that occurred.
    pub kind: DescribeEventSubscriptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEventSubscriptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventSubscriptionsErrorKind {
    /// <p>The designated subscription could not be found.</p>
    SubscriptionNotFoundFault(crate::error::SubscriptionNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventSubscriptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventSubscriptionsErrorKind::SubscriptionNotFoundFault(_inner) => _inner.fmt(f),
            DescribeEventSubscriptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventSubscriptionsError {
    fn code(&self) -> Option<&str> {
        DescribeEventSubscriptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventSubscriptionsError {
    /// Creates a new `DescribeEventSubscriptionsError`.
    pub fn new(kind: DescribeEventSubscriptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventSubscriptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventSubscriptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventSubscriptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventSubscriptionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEventSubscriptionsErrorKind::SubscriptionNotFoundFault`.
    pub fn is_subscription_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventSubscriptionsErrorKind::SubscriptionNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeEventSubscriptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventSubscriptionsErrorKind::SubscriptionNotFoundFault(_inner) => Some(_inner),
            DescribeEventSubscriptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOrderableDBInstanceOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOrderableDBInstanceOptionsError {
    /// Kind of error that occurred.
    pub kind: DescribeOrderableDBInstanceOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOrderableDBInstanceOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOrderableDBInstanceOptionsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOrderableDBInstanceOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOrderableDBInstanceOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOrderableDBInstanceOptionsError {
    fn code(&self) -> Option<&str> {
        DescribeOrderableDBInstanceOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOrderableDBInstanceOptionsError {
    /// Creates a new `DescribeOrderableDBInstanceOptionsError`.
    pub fn new(
        kind: DescribeOrderableDBInstanceOptionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOrderableDBInstanceOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOrderableDBInstanceOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOrderableDBInstanceOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOrderableDBInstanceOptionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeOrderableDBInstanceOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOrderableDBInstanceOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePendingMaintenanceActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePendingMaintenanceActionsError {
    /// Kind of error that occurred.
    pub kind: DescribePendingMaintenanceActionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePendingMaintenanceActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePendingMaintenanceActionsErrorKind {
    /// <p>The specified resource ID was not found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePendingMaintenanceActionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePendingMaintenanceActionsErrorKind::ResourceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribePendingMaintenanceActionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePendingMaintenanceActionsError {
    fn code(&self) -> Option<&str> {
        DescribePendingMaintenanceActionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePendingMaintenanceActionsError {
    /// Creates a new `DescribePendingMaintenanceActionsError`.
    pub fn new(
        kind: DescribePendingMaintenanceActionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePendingMaintenanceActionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePendingMaintenanceActionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePendingMaintenanceActionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePendingMaintenanceActionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePendingMaintenanceActionsErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribePendingMaintenanceActionsErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribePendingMaintenanceActionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePendingMaintenanceActionsErrorKind::ResourceNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribePendingMaintenanceActionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeValidDBInstanceModifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeValidDBInstanceModificationsError {
    /// Kind of error that occurred.
    pub kind: DescribeValidDBInstanceModificationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeValidDBInstanceModifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeValidDBInstanceModificationsErrorKind {
    /// <p> <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The specified DB instance is not in the <i>available</i> state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeValidDBInstanceModificationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeValidDBInstanceModificationsErrorKind::DbInstanceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeValidDBInstanceModificationsErrorKind::InvalidDbInstanceStateFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeValidDBInstanceModificationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeValidDBInstanceModificationsError {
    fn code(&self) -> Option<&str> {
        DescribeValidDBInstanceModificationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeValidDBInstanceModificationsError {
    /// Creates a new `DescribeValidDBInstanceModificationsError`.
    pub fn new(
        kind: DescribeValidDBInstanceModificationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeValidDBInstanceModificationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeValidDBInstanceModificationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeValidDBInstanceModificationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeValidDBInstanceModificationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeValidDBInstanceModificationsErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeValidDBInstanceModificationsErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeValidDBInstanceModificationsErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeValidDBInstanceModificationsErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
}
impl std::error::Error for DescribeValidDBInstanceModificationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeValidDBInstanceModificationsErrorKind::DbInstanceNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeValidDBInstanceModificationsErrorKind::InvalidDbInstanceStateFault(_inner) => {
                Some(_inner)
            }
            DescribeValidDBInstanceModificationsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `FailoverDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct FailoverDBClusterError {
    /// Kind of error that occurred.
    pub kind: FailoverDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `FailoverDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum FailoverDBClusterErrorKind {
    /// <p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The DB cluster is not in a valid state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The specified DB instance is not in the <i>available</i> state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for FailoverDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            FailoverDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            FailoverDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            FailoverDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            FailoverDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for FailoverDBClusterError {
    fn code(&self) -> Option<&str> {
        FailoverDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl FailoverDBClusterError {
    /// Creates a new `FailoverDBClusterError`.
    pub fn new(kind: FailoverDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `FailoverDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: FailoverDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `FailoverDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: FailoverDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `FailoverDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            FailoverDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `FailoverDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            FailoverDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `FailoverDBClusterErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            FailoverDBClusterErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
}
impl std::error::Error for FailoverDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            FailoverDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            FailoverDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            FailoverDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            FailoverDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p> <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</p>
    DbSnapshotNotFoundFault(crate::error::DbSnapshotNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::DbSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::DbSnapshotNotFoundFault`.
    pub fn is_db_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::DbSnapshotNotFoundFault(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::DbSnapshotNotFoundFault(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDBClusterError {
    /// Kind of error that occurred.
    pub kind: ModifyDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDBClusterErrorKind {
    /// <p>User already has a DB cluster with the given identifier.</p>
    DbClusterAlreadyExistsFault(crate::error::DbClusterAlreadyExistsFault),
    /// <p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <i>DBClusterParameterGroupName</i> does not refer to an existing DB Cluster parameter group.</p>
    DbClusterParameterGroupNotFoundFault(crate::error::DbClusterParameterGroupNotFoundFault),
    /// <p> <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group.</p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p>The DB cluster is not in a valid state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The specified DB instance is not in the <i>available</i> state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>The state of the DB security group does not allow deletion.</p>
    InvalidDbSecurityGroupStateFault(crate::error::InvalidDbSecurityGroupStateFault),
    /// <p>The DB subnet group cannot be deleted because it is in use.</p>
    InvalidDbSubnetGroupStateFault(crate::error::InvalidDbSubnetGroupStateFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>DB subnet group does not cover all Availability Zones after it is created because users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>Request would result in user exceeding the allowed amount of storage available across all DB instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDBClusterErrorKind::DbClusterAlreadyExistsFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::DbClusterParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::DbSubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::InvalidDbSecurityGroupStateFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::InvalidDbSubnetGroupStateFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::InvalidVpcNetworkStateFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::StorageQuotaExceededFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDBClusterError {
    fn code(&self) -> Option<&str> {
        ModifyDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDBClusterError {
    /// Creates a new `ModifyDBClusterError`.
    pub fn new(kind: ModifyDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::DbClusterAlreadyExistsFault`.
    pub fn is_db_cluster_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::DbClusterAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::DbClusterParameterGroupNotFoundFault`.
    pub fn is_db_cluster_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::DbClusterParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::InvalidDbSecurityGroupStateFault`.
    pub fn is_invalid_db_security_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::InvalidDbSecurityGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::InvalidDbSubnetGroupStateFault`.
    pub fn is_invalid_db_subnet_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::InvalidDbSubnetGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(&self.kind, ModifyDBClusterErrorKind::InvalidSubnet(_))
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::StorageQuotaExceededFault`.
    pub fn is_storage_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::StorageQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for ModifyDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDBClusterErrorKind::DbClusterAlreadyExistsFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::DbClusterParameterGroupNotFoundFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::DbSubnetGroupNotFoundFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::InvalidDbSecurityGroupStateFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::InvalidDbSubnetGroupStateFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::InvalidSubnet(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::InvalidVpcNetworkStateFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::StorageQuotaExceededFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDBClusterEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDBClusterEndpointError {
    /// Kind of error that occurred.
    pub kind: ModifyDBClusterEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDBClusterEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDBClusterEndpointErrorKind {
    /// <p>The specified custom endpoint doesn't exist.</p>
    DbClusterEndpointNotFoundFault(crate::error::DbClusterEndpointNotFoundFault),
    /// <p> <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The requested operation cannot be performed on the endpoint while the endpoint is in this state.</p>
    InvalidDbClusterEndpointStateFault(crate::error::InvalidDbClusterEndpointStateFault),
    /// <p>The DB cluster is not in a valid state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The specified DB instance is not in the <i>available</i> state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDBClusterEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBClusterEndpointErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBClusterEndpointErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            ModifyDBClusterEndpointErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            ModifyDBClusterEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDBClusterEndpointError {
    fn code(&self) -> Option<&str> {
        ModifyDBClusterEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDBClusterEndpointError {
    /// Creates a new `ModifyDBClusterEndpointError`.
    pub fn new(kind: ModifyDBClusterEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDBClusterEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDBClusterEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDBClusterEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDBClusterEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault`.
    pub fn is_db_cluster_endpoint_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterEndpointErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterEndpointErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault`.
    pub fn is_invalid_db_cluster_endpoint_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterEndpointErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterEndpointErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterEndpointErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterEndpointErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
}
impl std::error::Error for ModifyDBClusterEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault(_inner) => {
                Some(_inner)
            }
            ModifyDBClusterEndpointErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            ModifyDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault(_inner) => {
                Some(_inner)
            }
            ModifyDBClusterEndpointErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            ModifyDBClusterEndpointErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            ModifyDBClusterEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDBClusterParameterGroupError {
    /// Kind of error that occurred.
    pub kind: ModifyDBClusterParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDBClusterParameterGroupErrorKind {
    /// <p> <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.</p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p>The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter group, you cannot delete it when the parameter group is in this state.</p>
    InvalidDbParameterGroupStateFault(crate::error::InvalidDbParameterGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDBClusterParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBClusterParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDBClusterParameterGroupError {
    fn code(&self) -> Option<&str> {
        ModifyDBClusterParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDBClusterParameterGroupError {
    /// Creates a new `ModifyDBClusterParameterGroupError`.
    pub fn new(
        kind: ModifyDBClusterParameterGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDBClusterParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDBClusterParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDBClusterParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDBClusterParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault`.
    pub fn is_invalid_db_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_)
        )
    }
}
impl std::error::Error for ModifyDBClusterParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            ModifyDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                Some(_inner)
            }
            ModifyDBClusterParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDBClusterSnapshotAttribute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDBClusterSnapshotAttributeError {
    /// Kind of error that occurred.
    pub kind: ModifyDBClusterSnapshotAttributeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDBClusterSnapshotAttribute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDBClusterSnapshotAttributeErrorKind {
    /// <p> <i>DBClusterSnapshotIdentifier</i> does not refer to an existing DB cluster snapshot.</p>
    DbClusterSnapshotNotFoundFault(crate::error::DbClusterSnapshotNotFoundFault),
    /// <p>The supplied value is not a valid DB cluster snapshot state.</p>
    InvalidDbClusterSnapshotStateFault(crate::error::InvalidDbClusterSnapshotStateFault),
    /// <p>You have exceeded the maximum number of accounts that you can share a manual DB snapshot with.</p>
    SharedSnapshotQuotaExceededFault(crate::error::SharedSnapshotQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDBClusterSnapshotAttributeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDBClusterSnapshotAttributeErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBClusterSnapshotAttributeErrorKind::InvalidDbClusterSnapshotStateFault(
                _inner,
            ) => _inner.fmt(f),
            ModifyDBClusterSnapshotAttributeErrorKind::SharedSnapshotQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBClusterSnapshotAttributeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDBClusterSnapshotAttributeError {
    fn code(&self) -> Option<&str> {
        ModifyDBClusterSnapshotAttributeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDBClusterSnapshotAttributeError {
    /// Creates a new `ModifyDBClusterSnapshotAttributeError`.
    pub fn new(
        kind: ModifyDBClusterSnapshotAttributeErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDBClusterSnapshotAttributeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDBClusterSnapshotAttributeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDBClusterSnapshotAttributeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDBClusterSnapshotAttributeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDBClusterSnapshotAttributeErrorKind::DbClusterSnapshotNotFoundFault`.
    pub fn is_db_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterSnapshotAttributeErrorKind::DbClusterSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterSnapshotAttributeErrorKind::InvalidDbClusterSnapshotStateFault`.
    pub fn is_invalid_db_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterSnapshotAttributeErrorKind::InvalidDbClusterSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterSnapshotAttributeErrorKind::SharedSnapshotQuotaExceededFault`.
    pub fn is_shared_snapshot_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterSnapshotAttributeErrorKind::SharedSnapshotQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for ModifyDBClusterSnapshotAttributeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDBClusterSnapshotAttributeErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                Some(_inner)
            }
            ModifyDBClusterSnapshotAttributeErrorKind::InvalidDbClusterSnapshotStateFault(
                _inner,
            ) => Some(_inner),
            ModifyDBClusterSnapshotAttributeErrorKind::SharedSnapshotQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            ModifyDBClusterSnapshotAttributeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDBInstanceError {
    /// Kind of error that occurred.
    pub kind: ModifyDBInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDBInstanceErrorKind {
    /// <p>Specified CIDRIP or EC2 security group is not authorized for the specified DB security group.</p>
    /// <p>Neptune may not also be authorized via IAM to perform necessary actions on your behalf.</p>
    AuthorizationNotFoundFault(crate::error::AuthorizationNotFoundFault),
    /// <p> <i>CertificateIdentifier</i> does not refer to an existing certificate.</p>
    CertificateNotFoundFault(crate::error::CertificateNotFoundFault),
    /// <p>User already has a DB instance with the given identifier.</p>
    DbInstanceAlreadyExistsFault(crate::error::DbInstanceAlreadyExistsFault),
    /// <p> <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p> <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.</p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p> <i>DBSecurityGroupName</i> does not refer to an existing DB security group.</p>
    DbSecurityGroupNotFoundFault(crate::error::DbSecurityGroupNotFoundFault),
    /// <p>The DB upgrade failed because a resource the DB depends on could not be modified.</p>
    DbUpgradeDependencyFailureFault(crate::error::DbUpgradeDependencyFailureFault),
    /// <p> <i>Domain</i> does not refer to an existing Active Directory Domain.</p>
    DomainNotFoundFault(crate::error::DomainNotFoundFault),
    /// <p>Specified DB instance class is not available in the specified Availability Zone.</p>
    InsufficientDbInstanceCapacityFault(crate::error::InsufficientDbInstanceCapacityFault),
    /// <p>The specified DB instance is not in the <i>available</i> state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>The state of the DB security group does not allow deletion.</p>
    InvalidDbSecurityGroupStateFault(crate::error::InvalidDbSecurityGroupStateFault),
    /// <p>DB subnet group does not cover all Availability Zones after it is created because users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>The designated option group could not be found.</p>
    OptionGroupNotFoundFault(crate::error::OptionGroupNotFoundFault),
    /// <p>Provisioned IOPS not available in the specified Availability Zone.</p>
    ProvisionedIopsNotAvailableInAzFault(crate::error::ProvisionedIopsNotAvailableInAzFault),
    /// <p>Request would result in user exceeding the allowed amount of storage available across all DB instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// <p> <i>StorageType</i> specified cannot be associated with the DB Instance.</p>
    StorageTypeNotSupportedFault(crate::error::StorageTypeNotSupportedFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDBInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDBInstanceErrorKind::AuthorizationNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::CertificateNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::DbInstanceAlreadyExistsFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::DbParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::DbSecurityGroupNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::DbUpgradeDependencyFailureFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::DomainNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::InvalidDbSecurityGroupStateFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::InvalidVpcNetworkStateFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::OptionGroupNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBInstanceErrorKind::StorageQuotaExceededFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::StorageTypeNotSupportedFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDBInstanceError {
    fn code(&self) -> Option<&str> {
        ModifyDBInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDBInstanceError {
    /// Creates a new `ModifyDBInstanceError`.
    pub fn new(kind: ModifyDBInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDBInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDBInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDBInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDBInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::AuthorizationNotFoundFault`.
    pub fn is_authorization_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::AuthorizationNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::CertificateNotFoundFault`.
    pub fn is_certificate_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::CertificateNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::DbInstanceAlreadyExistsFault`.
    pub fn is_db_instance_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::DbInstanceAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::DbSecurityGroupNotFoundFault`.
    pub fn is_db_security_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::DbSecurityGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::DbUpgradeDependencyFailureFault`.
    pub fn is_db_upgrade_dependency_failure_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::DbUpgradeDependencyFailureFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::DomainNotFoundFault`.
    pub fn is_domain_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::DomainNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::InsufficientDbInstanceCapacityFault`.
    pub fn is_insufficient_db_instance_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::InvalidDbSecurityGroupStateFault`.
    pub fn is_invalid_db_security_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::InvalidDbSecurityGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::OptionGroupNotFoundFault`.
    pub fn is_option_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::OptionGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault`.
    pub fn is_provisioned_iops_not_available_in_az_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::StorageQuotaExceededFault`.
    pub fn is_storage_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::StorageQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::StorageTypeNotSupportedFault`.
    pub fn is_storage_type_not_supported_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::StorageTypeNotSupportedFault(_)
        )
    }
}
impl std::error::Error for ModifyDBInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDBInstanceErrorKind::AuthorizationNotFoundFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::CertificateNotFoundFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::DbInstanceAlreadyExistsFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::DbParameterGroupNotFoundFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::DbSecurityGroupNotFoundFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::DbUpgradeDependencyFailureFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::DomainNotFoundFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::InvalidDbSecurityGroupStateFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::InvalidVpcNetworkStateFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::OptionGroupNotFoundFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::StorageQuotaExceededFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::StorageTypeNotSupportedFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDBParameterGroupError {
    /// Kind of error that occurred.
    pub kind: ModifyDBParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDBParameterGroupErrorKind {
    /// <p> <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.</p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p>The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter group, you cannot delete it when the parameter group is in this state.</p>
    InvalidDbParameterGroupStateFault(crate::error::InvalidDbParameterGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDBParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDBParameterGroupError {
    fn code(&self) -> Option<&str> {
        ModifyDBParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDBParameterGroupError {
    /// Creates a new `ModifyDBParameterGroupError`.
    pub fn new(kind: ModifyDBParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDBParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDBParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDBParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDBParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault`.
    pub fn is_invalid_db_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_)
        )
    }
}
impl std::error::Error for ModifyDBParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => Some(_inner),
            ModifyDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                Some(_inner)
            }
            ModifyDBParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDBSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDBSubnetGroupError {
    /// Kind of error that occurred.
    pub kind: ModifyDBSubnetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDBSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDBSubnetGroupErrorKind {
    /// <p>Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>
    DbSubnetGroupDoesNotCoverEnoughAZs(crate::error::DbSubnetGroupDoesNotCoverEnoughAZs),
    /// <p> <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group.</p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p>Request would result in user exceeding the allowed number of subnets in a DB subnet groups.</p>
    DbSubnetQuotaExceededFault(crate::error::DbSubnetQuotaExceededFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The DB subnet is already in use in the Availability Zone.</p>
    SubnetAlreadyInUse(crate::error::SubnetAlreadyInUse),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDBSubnetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault(_inner) => _inner.fmt(f),
            ModifyDBSubnetGroupErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            ModifyDBSubnetGroupErrorKind::SubnetAlreadyInUse(_inner) => _inner.fmt(f),
            ModifyDBSubnetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDBSubnetGroupError {
    fn code(&self) -> Option<&str> {
        ModifyDBSubnetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDBSubnetGroupError {
    /// Creates a new `ModifyDBSubnetGroupError`.
    pub fn new(kind: ModifyDBSubnetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDBSubnetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDBSubnetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDBSubnetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDBSubnetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs`.
    pub fn is_db_subnet_group_does_not_cover_enough_a_zs(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault`.
    pub fn is_db_subnet_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBSubnetGroupErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(&self.kind, ModifyDBSubnetGroupErrorKind::InvalidSubnet(_))
    }
    /// Returns `true` if the error kind is `ModifyDBSubnetGroupErrorKind::SubnetAlreadyInUse`.
    pub fn is_subnet_already_in_use(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBSubnetGroupErrorKind::SubnetAlreadyInUse(_)
        )
    }
}
impl std::error::Error for ModifyDBSubnetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => {
                Some(_inner)
            }
            ModifyDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault(_inner) => Some(_inner),
            ModifyDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault(_inner) => Some(_inner),
            ModifyDBSubnetGroupErrorKind::InvalidSubnet(_inner) => Some(_inner),
            ModifyDBSubnetGroupErrorKind::SubnetAlreadyInUse(_inner) => Some(_inner),
            ModifyDBSubnetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyEventSubscriptionError {
    /// Kind of error that occurred.
    pub kind: ModifyEventSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyEventSubscriptionErrorKind {
    /// <p>You have exceeded the number of events you can subscribe to.</p>
    EventSubscriptionQuotaExceededFault(crate::error::EventSubscriptionQuotaExceededFault),
    /// <p>The SNS topic is invalid.</p>
    SnsInvalidTopicFault(crate::error::SnsInvalidTopicFault),
    /// <p>There is no SNS authorization.</p>
    SnsNoAuthorizationFault(crate::error::SnsNoAuthorizationFault),
    /// <p>The ARN of the SNS topic could not be found.</p>
    SnsTopicArnNotFoundFault(crate::error::SnsTopicArnNotFoundFault),
    /// <p>The designated subscription category could not be found.</p>
    SubscriptionCategoryNotFoundFault(crate::error::SubscriptionCategoryNotFoundFault),
    /// <p>The designated subscription could not be found.</p>
    SubscriptionNotFoundFault(crate::error::SubscriptionNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyEventSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyEventSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyEventSubscriptionError {
    fn code(&self) -> Option<&str> {
        ModifyEventSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyEventSubscriptionError {
    /// Creates a new `ModifyEventSubscriptionError`.
    pub fn new(kind: ModifyEventSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyEventSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyEventSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyEventSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyEventSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault`.
    pub fn is_event_subscription_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault`.
    pub fn is_sns_invalid_topic_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault`.
    pub fn is_sns_no_authorization_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SnsTopicArnNotFoundFault`.
    pub fn is_sns_topic_arn_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault`.
    pub fn is_subscription_category_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SubscriptionNotFoundFault`.
    pub fn is_subscription_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SubscriptionNotFoundFault(_)
        )
    }
}
impl std::error::Error for ModifyEventSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(_inner) => {
                Some(_inner)
            }
            ModifyEventSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PromoteReadReplicaDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PromoteReadReplicaDBClusterError {
    /// Kind of error that occurred.
    pub kind: PromoteReadReplicaDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PromoteReadReplicaDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PromoteReadReplicaDBClusterErrorKind {
    /// <p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The DB cluster is not in a valid state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PromoteReadReplicaDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PromoteReadReplicaDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            PromoteReadReplicaDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => {
                _inner.fmt(f)
            }
            PromoteReadReplicaDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PromoteReadReplicaDBClusterError {
    fn code(&self) -> Option<&str> {
        PromoteReadReplicaDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PromoteReadReplicaDBClusterError {
    /// Creates a new `PromoteReadReplicaDBClusterError`.
    pub fn new(kind: PromoteReadReplicaDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PromoteReadReplicaDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PromoteReadReplicaDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PromoteReadReplicaDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PromoteReadReplicaDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PromoteReadReplicaDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            PromoteReadReplicaDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `PromoteReadReplicaDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            PromoteReadReplicaDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
}
impl std::error::Error for PromoteReadReplicaDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PromoteReadReplicaDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            PromoteReadReplicaDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => {
                Some(_inner)
            }
            PromoteReadReplicaDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RebootDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RebootDBInstanceError {
    /// Kind of error that occurred.
    pub kind: RebootDBInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RebootDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RebootDBInstanceErrorKind {
    /// <p> <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The specified DB instance is not in the <i>available</i> state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RebootDBInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RebootDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            RebootDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            RebootDBInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RebootDBInstanceError {
    fn code(&self) -> Option<&str> {
        RebootDBInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RebootDBInstanceError {
    /// Creates a new `RebootDBInstanceError`.
    pub fn new(kind: RebootDBInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RebootDBInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RebootDBInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RebootDBInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RebootDBInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RebootDBInstanceErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RebootDBInstanceErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RebootDBInstanceErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RebootDBInstanceErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
}
impl std::error::Error for RebootDBInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RebootDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            RebootDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            RebootDBInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveRoleFromDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveRoleFromDBClusterError {
    /// Kind of error that occurred.
    pub kind: RemoveRoleFromDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveRoleFromDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveRoleFromDBClusterErrorKind {
    /// <p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The specified IAM role Amazon Resource Name (ARN) is not associated with the specified DB cluster.</p>
    DbClusterRoleNotFoundFault(crate::error::DbClusterRoleNotFoundFault),
    /// <p>The DB cluster is not in a valid state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveRoleFromDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveRoleFromDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            RemoveRoleFromDBClusterErrorKind::DbClusterRoleNotFoundFault(_inner) => _inner.fmt(f),
            RemoveRoleFromDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            RemoveRoleFromDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveRoleFromDBClusterError {
    fn code(&self) -> Option<&str> {
        RemoveRoleFromDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveRoleFromDBClusterError {
    /// Creates a new `RemoveRoleFromDBClusterError`.
    pub fn new(kind: RemoveRoleFromDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveRoleFromDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveRoleFromDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveRoleFromDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveRoleFromDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveRoleFromDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveRoleFromDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveRoleFromDBClusterErrorKind::DbClusterRoleNotFoundFault`.
    pub fn is_db_cluster_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveRoleFromDBClusterErrorKind::DbClusterRoleNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveRoleFromDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveRoleFromDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
}
impl std::error::Error for RemoveRoleFromDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveRoleFromDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            RemoveRoleFromDBClusterErrorKind::DbClusterRoleNotFoundFault(_inner) => Some(_inner),
            RemoveRoleFromDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            RemoveRoleFromDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveSourceIdentifierFromSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveSourceIdentifierFromSubscriptionError {
    /// Kind of error that occurred.
    pub kind: RemoveSourceIdentifierFromSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveSourceIdentifierFromSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveSourceIdentifierFromSubscriptionErrorKind {
    /// <p>The source could not be found.</p>
    SourceNotFoundFault(crate::error::SourceNotFoundFault),
    /// <p>The designated subscription could not be found.</p>
    SubscriptionNotFoundFault(crate::error::SubscriptionNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveSourceIdentifierFromSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveSourceIdentifierFromSubscriptionErrorKind::SourceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RemoveSourceIdentifierFromSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RemoveSourceIdentifierFromSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveSourceIdentifierFromSubscriptionError {
    fn code(&self) -> Option<&str> {
        RemoveSourceIdentifierFromSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveSourceIdentifierFromSubscriptionError {
    /// Creates a new `RemoveSourceIdentifierFromSubscriptionError`.
    pub fn new(
        kind: RemoveSourceIdentifierFromSubscriptionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveSourceIdentifierFromSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveSourceIdentifierFromSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveSourceIdentifierFromSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveSourceIdentifierFromSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveSourceIdentifierFromSubscriptionErrorKind::SourceNotFoundFault`.
    pub fn is_source_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveSourceIdentifierFromSubscriptionErrorKind::SourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveSourceIdentifierFromSubscriptionErrorKind::SubscriptionNotFoundFault`.
    pub fn is_subscription_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveSourceIdentifierFromSubscriptionErrorKind::SubscriptionNotFoundFault(_)
        )
    }
}
impl std::error::Error for RemoveSourceIdentifierFromSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveSourceIdentifierFromSubscriptionErrorKind::SourceNotFoundFault(_inner) => {
                Some(_inner)
            }
            RemoveSourceIdentifierFromSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => {
                Some(_inner)
            }
            RemoveSourceIdentifierFromSubscriptionErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `RemoveTagsFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveTagsFromResourceError {
    /// Kind of error that occurred.
    pub kind: RemoveTagsFromResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveTagsFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveTagsFromResourceErrorKind {
    /// <p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p> <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</p>
    DbSnapshotNotFoundFault(crate::error::DbSnapshotNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveTagsFromResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveTagsFromResourceErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::DbSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveTagsFromResourceError {
    fn code(&self) -> Option<&str> {
        RemoveTagsFromResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveTagsFromResourceError {
    /// Creates a new `RemoveTagsFromResourceError`.
    pub fn new(kind: RemoveTagsFromResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveTagsFromResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveTagsFromResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveTagsFromResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveTagsFromResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::DbSnapshotNotFoundFault`.
    pub fn is_db_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::DbSnapshotNotFoundFault(_)
        )
    }
}
impl std::error::Error for RemoveTagsFromResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveTagsFromResourceErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::DbSnapshotNotFoundFault(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResetDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResetDBClusterParameterGroupError {
    /// Kind of error that occurred.
    pub kind: ResetDBClusterParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResetDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResetDBClusterParameterGroupErrorKind {
    /// <p> <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.</p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p>The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter group, you cannot delete it when the parameter group is in this state.</p>
    InvalidDbParameterGroupStateFault(crate::error::InvalidDbParameterGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResetDBClusterParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResetDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ResetDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            ResetDBClusterParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResetDBClusterParameterGroupError {
    fn code(&self) -> Option<&str> {
        ResetDBClusterParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResetDBClusterParameterGroupError {
    /// Creates a new `ResetDBClusterParameterGroupError`.
    pub fn new(kind: ResetDBClusterParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResetDBClusterParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResetDBClusterParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResetDBClusterParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResetDBClusterParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResetDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResetDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ResetDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault`.
    pub fn is_invalid_db_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResetDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_)
        )
    }
}
impl std::error::Error for ResetDBClusterParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResetDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            ResetDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                Some(_inner)
            }
            ResetDBClusterParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResetDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResetDBParameterGroupError {
    /// Kind of error that occurred.
    pub kind: ResetDBParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResetDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResetDBParameterGroupErrorKind {
    /// <p> <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.</p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p>The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter group, you cannot delete it when the parameter group is in this state.</p>
    InvalidDbParameterGroupStateFault(crate::error::InvalidDbParameterGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResetDBParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResetDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            ResetDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            ResetDBParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResetDBParameterGroupError {
    fn code(&self) -> Option<&str> {
        ResetDBParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResetDBParameterGroupError {
    /// Creates a new `ResetDBParameterGroupError`.
    pub fn new(kind: ResetDBParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResetDBParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResetDBParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResetDBParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResetDBParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResetDBParameterGroupErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResetDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ResetDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault`.
    pub fn is_invalid_db_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResetDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_)
        )
    }
}
impl std::error::Error for ResetDBParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResetDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => Some(_inner),
            ResetDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                Some(_inner)
            }
            ResetDBParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreDBClusterFromSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreDBClusterFromSnapshotError {
    /// Kind of error that occurred.
    pub kind: RestoreDBClusterFromSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreDBClusterFromSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreDBClusterFromSnapshotErrorKind {
    /// <p>User already has a DB cluster with the given identifier.</p>
    DbClusterAlreadyExistsFault(crate::error::DbClusterAlreadyExistsFault),
    /// <p> <i>DBClusterParameterGroupName</i> does not refer to an existing DB Cluster parameter group.</p>
    DbClusterParameterGroupNotFoundFault(crate::error::DbClusterParameterGroupNotFoundFault),
    /// <p>User attempted to create a new DB cluster and the user has already reached the maximum allowed DB cluster quota.</p>
    DbClusterQuotaExceededFault(crate::error::DbClusterQuotaExceededFault),
    /// <p> <i>DBClusterSnapshotIdentifier</i> does not refer to an existing DB cluster snapshot.</p>
    DbClusterSnapshotNotFoundFault(crate::error::DbClusterSnapshotNotFoundFault),
    /// <p> <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</p>
    DbSnapshotNotFoundFault(crate::error::DbSnapshotNotFoundFault),
    /// <p> <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group.</p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p>The DB cluster does not have enough capacity for the current operation.</p>
    InsufficientDbClusterCapacityFault(crate::error::InsufficientDbClusterCapacityFault),
    /// <p>There is insufficient storage available for the current action. You may be able to resolve this error by updating your subnet group to use different Availability Zones that have more storage available.</p>
    InsufficientStorageClusterCapacityFault(crate::error::InsufficientStorageClusterCapacityFault),
    /// <p>The supplied value is not a valid DB cluster snapshot state.</p>
    InvalidDbClusterSnapshotStateFault(crate::error::InvalidDbClusterSnapshotStateFault),
    /// <p>The state of the DB snapshot does not allow deletion.</p>
    InvalidDbSnapshotStateFault(crate::error::InvalidDbSnapshotStateFault),
    /// <p>Cannot restore from vpc backup to non-vpc DB instance.</p>
    InvalidRestoreFault(crate::error::InvalidRestoreFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>DB subnet group does not cover all Availability Zones after it is created because users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>Error accessing KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The designated option group could not be found.</p>
    OptionGroupNotFoundFault(crate::error::OptionGroupNotFoundFault),
    /// <p>Request would result in user exceeding the allowed amount of storage available across all DB instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreDBClusterFromSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreDBClusterFromSnapshotErrorKind::DbClusterAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::DbClusterParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::DbClusterQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::DbSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            RestoreDBClusterFromSnapshotErrorKind::DbSubnetGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::InsufficientDbClusterCapacityFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::InsufficientStorageClusterCapacityFault(
                _inner,
            ) => _inner.fmt(f),
            RestoreDBClusterFromSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::InvalidDbSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::InvalidRestoreFault(_inner) => _inner.fmt(f),
            RestoreDBClusterFromSnapshotErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            RestoreDBClusterFromSnapshotErrorKind::InvalidVpcNetworkStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::KmsKeyNotAccessibleFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::OptionGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::StorageQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreDBClusterFromSnapshotError {
    fn code(&self) -> Option<&str> {
        RestoreDBClusterFromSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreDBClusterFromSnapshotError {
    /// Creates a new `RestoreDBClusterFromSnapshotError`.
    pub fn new(kind: RestoreDBClusterFromSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreDBClusterFromSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreDBClusterFromSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreDBClusterFromSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreDBClusterFromSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::DbClusterAlreadyExistsFault`.
    pub fn is_db_cluster_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::DbClusterAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::DbClusterParameterGroupNotFoundFault`.
    pub fn is_db_cluster_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::DbClusterParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::DbClusterQuotaExceededFault`.
    pub fn is_db_cluster_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::DbClusterQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::DbClusterSnapshotNotFoundFault`.
    pub fn is_db_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::DbClusterSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::DbSnapshotNotFoundFault`.
    pub fn is_db_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::DbSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::InsufficientDbClusterCapacityFault`.
    pub fn is_insufficient_db_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::InsufficientDbClusterCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::InsufficientStorageClusterCapacityFault`.
    pub fn is_insufficient_storage_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::InsufficientStorageClusterCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::InvalidDbClusterSnapshotStateFault`.
    pub fn is_invalid_db_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::InvalidDbSnapshotStateFault`.
    pub fn is_invalid_db_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::InvalidDbSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::InvalidRestoreFault`.
    pub fn is_invalid_restore_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::InvalidRestoreFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::InvalidSubnet(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::OptionGroupNotFoundFault`.
    pub fn is_option_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::OptionGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::StorageQuotaExceededFault`.
    pub fn is_storage_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::StorageQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for RestoreDBClusterFromSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreDBClusterFromSnapshotErrorKind::DbClusterAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::DbClusterParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::DbClusterQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::DbSnapshotNotFoundFault(_inner) => Some(_inner),
            RestoreDBClusterFromSnapshotErrorKind::DbSubnetGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::InsufficientDbClusterCapacityFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::InsufficientStorageClusterCapacityFault(
                _inner,
            ) => Some(_inner),
            RestoreDBClusterFromSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::InvalidDbSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::InvalidRestoreFault(_inner) => Some(_inner),
            RestoreDBClusterFromSnapshotErrorKind::InvalidSubnet(_inner) => Some(_inner),
            RestoreDBClusterFromSnapshotErrorKind::InvalidVpcNetworkStateFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            RestoreDBClusterFromSnapshotErrorKind::OptionGroupNotFoundFault(_inner) => Some(_inner),
            RestoreDBClusterFromSnapshotErrorKind::StorageQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreDBClusterToPointInTime` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreDBClusterToPointInTimeError {
    /// Kind of error that occurred.
    pub kind: RestoreDBClusterToPointInTimeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreDBClusterToPointInTime` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreDBClusterToPointInTimeErrorKind {
    /// <p>User already has a DB cluster with the given identifier.</p>
    DbClusterAlreadyExistsFault(crate::error::DbClusterAlreadyExistsFault),
    /// <p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <i>DBClusterParameterGroupName</i> does not refer to an existing DB Cluster parameter group.</p>
    DbClusterParameterGroupNotFoundFault(crate::error::DbClusterParameterGroupNotFoundFault),
    /// <p>User attempted to create a new DB cluster and the user has already reached the maximum allowed DB cluster quota.</p>
    DbClusterQuotaExceededFault(crate::error::DbClusterQuotaExceededFault),
    /// <p> <i>DBClusterSnapshotIdentifier</i> does not refer to an existing DB cluster snapshot.</p>
    DbClusterSnapshotNotFoundFault(crate::error::DbClusterSnapshotNotFoundFault),
    /// <p> <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group.</p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p>The DB cluster does not have enough capacity for the current operation.</p>
    InsufficientDbClusterCapacityFault(crate::error::InsufficientDbClusterCapacityFault),
    /// <p>There is insufficient storage available for the current action. You may be able to resolve this error by updating your subnet group to use different Availability Zones that have more storage available.</p>
    InsufficientStorageClusterCapacityFault(crate::error::InsufficientStorageClusterCapacityFault),
    /// <p>The supplied value is not a valid DB cluster snapshot state.</p>
    InvalidDbClusterSnapshotStateFault(crate::error::InvalidDbClusterSnapshotStateFault),
    /// <p>The DB cluster is not in a valid state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The state of the DB snapshot does not allow deletion.</p>
    InvalidDbSnapshotStateFault(crate::error::InvalidDbSnapshotStateFault),
    /// <p>Cannot restore from vpc backup to non-vpc DB instance.</p>
    InvalidRestoreFault(crate::error::InvalidRestoreFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>DB subnet group does not cover all Availability Zones after it is created because users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>Error accessing KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The designated option group could not be found.</p>
    OptionGroupNotFoundFault(crate::error::OptionGroupNotFoundFault),
    /// <p>Request would result in user exceeding the allowed amount of storage available across all DB instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreDBClusterToPointInTimeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreDBClusterToPointInTimeErrorKind::DbClusterAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            RestoreDBClusterToPointInTimeErrorKind::DbClusterParameterGroupNotFoundFault(
                _inner,
            ) => _inner.fmt(f),
            RestoreDBClusterToPointInTimeErrorKind::DbClusterQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::DbSubnetGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::InsufficientDbClusterCapacityFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::InsufficientStorageClusterCapacityFault(
                _inner,
            ) => _inner.fmt(f),
            RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::InvalidDbSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::InvalidRestoreFault(_inner) => _inner.fmt(f),
            RestoreDBClusterToPointInTimeErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            RestoreDBClusterToPointInTimeErrorKind::InvalidVpcNetworkStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::KmsKeyNotAccessibleFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::OptionGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::StorageQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreDBClusterToPointInTimeError {
    fn code(&self) -> Option<&str> {
        RestoreDBClusterToPointInTimeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreDBClusterToPointInTimeError {
    /// Creates a new `RestoreDBClusterToPointInTimeError`.
    pub fn new(
        kind: RestoreDBClusterToPointInTimeErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreDBClusterToPointInTimeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreDBClusterToPointInTimeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreDBClusterToPointInTimeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreDBClusterToPointInTimeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::DbClusterAlreadyExistsFault`.
    pub fn is_db_cluster_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::DbClusterAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::DbClusterParameterGroupNotFoundFault`.
    pub fn is_db_cluster_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::DbClusterParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::DbClusterQuotaExceededFault`.
    pub fn is_db_cluster_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::DbClusterQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::DbClusterSnapshotNotFoundFault`.
    pub fn is_db_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::DbClusterSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::InsufficientDbClusterCapacityFault`.
    pub fn is_insufficient_db_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::InsufficientDbClusterCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::InsufficientStorageClusterCapacityFault`.
    pub fn is_insufficient_storage_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::InsufficientStorageClusterCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterSnapshotStateFault`.
    pub fn is_invalid_db_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::InvalidDbSnapshotStateFault`.
    pub fn is_invalid_db_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::InvalidDbSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::InvalidRestoreFault`.
    pub fn is_invalid_restore_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::InvalidRestoreFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::InvalidSubnet(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::OptionGroupNotFoundFault`.
    pub fn is_option_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::OptionGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::StorageQuotaExceededFault`.
    pub fn is_storage_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::StorageQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for RestoreDBClusterToPointInTimeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreDBClusterToPointInTimeErrorKind::DbClusterAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            RestoreDBClusterToPointInTimeErrorKind::DbClusterParameterGroupNotFoundFault(
                _inner,
            ) => Some(_inner),
            RestoreDBClusterToPointInTimeErrorKind::DbClusterQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::DbSubnetGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::InsufficientDbClusterCapacityFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::InsufficientStorageClusterCapacityFault(
                _inner,
            ) => Some(_inner),
            RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterStateFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::InvalidDbSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::InvalidRestoreFault(_inner) => Some(_inner),
            RestoreDBClusterToPointInTimeErrorKind::InvalidSubnet(_inner) => Some(_inner),
            RestoreDBClusterToPointInTimeErrorKind::InvalidVpcNetworkStateFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::KmsKeyNotAccessibleFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::OptionGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::StorageQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartDBClusterError {
    /// Kind of error that occurred.
    pub kind: StartDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartDBClusterErrorKind {
    /// <p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The DB cluster is not in a valid state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The specified DB instance is not in the <i>available</i> state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            StartDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            StartDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            StartDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartDBClusterError {
    fn code(&self) -> Option<&str> {
        StartDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartDBClusterError {
    /// Creates a new `StartDBClusterError`.
    pub fn new(kind: StartDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartDBClusterErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartDBClusterErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
}
impl std::error::Error for StartDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            StartDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            StartDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            StartDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopDBClusterError {
    /// Kind of error that occurred.
    pub kind: StopDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopDBClusterErrorKind {
    /// <p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The DB cluster is not in a valid state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The specified DB instance is not in the <i>available</i> state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            StopDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            StopDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            StopDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopDBClusterError {
    fn code(&self) -> Option<&str> {
        StopDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopDBClusterError {
    /// Creates a new `StopDBClusterError`.
    pub fn new(kind: StopDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StopDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StopDBClusterErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopDBClusterErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
}
impl std::error::Error for StopDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            StopDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            StopDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            StopDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The specified DB instance is not in the <i>available</i> state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDbInstanceStateFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDbInstanceStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDbInstanceStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDbInstanceStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDbInstanceStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidDbInstanceStateFault [InvalidDBInstanceStateFault]"
        )?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDbInstanceStateFault {}
/// See [`InvalidDbInstanceStateFault`](crate::error::InvalidDbInstanceStateFault)
pub mod invalid_db_instance_state_fault {
    /// A builder for [`InvalidDbInstanceStateFault`](crate::error::InvalidDbInstanceStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDbInstanceStateFault`](crate::error::InvalidDbInstanceStateFault)
        pub fn build(self) -> crate::error::InvalidDbInstanceStateFault {
            crate::error::InvalidDbInstanceStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidDbInstanceStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidDbInstanceStateFault`](crate::error::InvalidDbInstanceStateFault)
    pub fn builder() -> crate::error::invalid_db_instance_state_fault::Builder {
        crate::error::invalid_db_instance_state_fault::Builder::default()
    }
}

/// <p>The DB cluster is not in a valid state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDbClusterStateFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDbClusterStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDbClusterStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDbClusterStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDbClusterStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDbClusterStateFault [InvalidDBClusterStateFault]")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDbClusterStateFault {}
/// See [`InvalidDbClusterStateFault`](crate::error::InvalidDbClusterStateFault)
pub mod invalid_db_cluster_state_fault {
    /// A builder for [`InvalidDbClusterStateFault`](crate::error::InvalidDbClusterStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDbClusterStateFault`](crate::error::InvalidDbClusterStateFault)
        pub fn build(self) -> crate::error::InvalidDbClusterStateFault {
            crate::error::InvalidDbClusterStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidDbClusterStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidDbClusterStateFault`](crate::error::InvalidDbClusterStateFault)
    pub fn builder() -> crate::error::invalid_db_cluster_state_fault::Builder {
        crate::error::invalid_db_cluster_state_fault::Builder::default()
    }
}

/// <p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterNotFoundFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbClusterNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbClusterNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DbClusterNotFoundFault [DBClusterNotFoundFault]")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbClusterNotFoundFault {}
/// See [`DbClusterNotFoundFault`](crate::error::DbClusterNotFoundFault)
pub mod db_cluster_not_found_fault {
    /// A builder for [`DbClusterNotFoundFault`](crate::error::DbClusterNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterNotFoundFault`](crate::error::DbClusterNotFoundFault)
        pub fn build(self) -> crate::error::DbClusterNotFoundFault {
            crate::error::DbClusterNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbClusterNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbClusterNotFoundFault`](crate::error::DbClusterNotFoundFault)
    pub fn builder() -> crate::error::db_cluster_not_found_fault::Builder {
        crate::error::db_cluster_not_found_fault::Builder::default()
    }
}

/// <p>Request would result in user exceeding the allowed amount of storage available across all DB instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageQuotaExceededFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StorageQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StorageQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StorageQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StorageQuotaExceededFault")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for StorageQuotaExceededFault {}
/// See [`StorageQuotaExceededFault`](crate::error::StorageQuotaExceededFault)
pub mod storage_quota_exceeded_fault {
    /// A builder for [`StorageQuotaExceededFault`](crate::error::StorageQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageQuotaExceededFault`](crate::error::StorageQuotaExceededFault)
        pub fn build(self) -> crate::error::StorageQuotaExceededFault {
            crate::error::StorageQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl StorageQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`StorageQuotaExceededFault`](crate::error::StorageQuotaExceededFault)
    pub fn builder() -> crate::error::storage_quota_exceeded_fault::Builder {
        crate::error::storage_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The designated option group could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptionGroupNotFoundFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OptionGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptionGroupNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OptionGroupNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OptionGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OptionGroupNotFoundFault")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for OptionGroupNotFoundFault {}
/// See [`OptionGroupNotFoundFault`](crate::error::OptionGroupNotFoundFault)
pub mod option_group_not_found_fault {
    /// A builder for [`OptionGroupNotFoundFault`](crate::error::OptionGroupNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OptionGroupNotFoundFault`](crate::error::OptionGroupNotFoundFault)
        pub fn build(self) -> crate::error::OptionGroupNotFoundFault {
            crate::error::OptionGroupNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl OptionGroupNotFoundFault {
    /// Creates a new builder-style object to manufacture [`OptionGroupNotFoundFault`](crate::error::OptionGroupNotFoundFault)
    pub fn builder() -> crate::error::option_group_not_found_fault::Builder {
        crate::error::option_group_not_found_fault::Builder::default()
    }
}

/// <p>Error accessing KMS key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsKeyNotAccessibleFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsKeyNotAccessibleFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsKeyNotAccessibleFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsKeyNotAccessibleFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsKeyNotAccessibleFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsKeyNotAccessibleFault [KMSKeyNotAccessibleFault]")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsKeyNotAccessibleFault {}
/// See [`KmsKeyNotAccessibleFault`](crate::error::KmsKeyNotAccessibleFault)
pub mod kms_key_not_accessible_fault {
    /// A builder for [`KmsKeyNotAccessibleFault`](crate::error::KmsKeyNotAccessibleFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsKeyNotAccessibleFault`](crate::error::KmsKeyNotAccessibleFault)
        pub fn build(self) -> crate::error::KmsKeyNotAccessibleFault {
            crate::error::KmsKeyNotAccessibleFault {
                message: self.message,
            }
        }
    }
}
impl KmsKeyNotAccessibleFault {
    /// Creates a new builder-style object to manufacture [`KmsKeyNotAccessibleFault`](crate::error::KmsKeyNotAccessibleFault)
    pub fn builder() -> crate::error::kms_key_not_accessible_fault::Builder {
        crate::error::kms_key_not_accessible_fault::Builder::default()
    }
}

/// <p>DB subnet group does not cover all Availability Zones after it is created because users' change.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidVpcNetworkStateFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidVpcNetworkStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidVpcNetworkStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidVpcNetworkStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidVpcNetworkStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidVpcNetworkStateFault [InvalidVPCNetworkStateFault]"
        )?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidVpcNetworkStateFault {}
/// See [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
pub mod invalid_vpc_network_state_fault {
    /// A builder for [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
        pub fn build(self) -> crate::error::InvalidVpcNetworkStateFault {
            crate::error::InvalidVpcNetworkStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidVpcNetworkStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
    pub fn builder() -> crate::error::invalid_vpc_network_state_fault::Builder {
        crate::error::invalid_vpc_network_state_fault::Builder::default()
    }
}

/// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSubnet {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSubnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSubnet");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSubnet {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSubnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSubnet")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSubnet {}
/// See [`InvalidSubnet`](crate::error::InvalidSubnet)
pub mod invalid_subnet {
    /// A builder for [`InvalidSubnet`](crate::error::InvalidSubnet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSubnet`](crate::error::InvalidSubnet)
        pub fn build(self) -> crate::error::InvalidSubnet {
            crate::error::InvalidSubnet {
                message: self.message,
            }
        }
    }
}
impl InvalidSubnet {
    /// Creates a new builder-style object to manufacture [`InvalidSubnet`](crate::error::InvalidSubnet)
    pub fn builder() -> crate::error::invalid_subnet::Builder {
        crate::error::invalid_subnet::Builder::default()
    }
}

/// <p>Cannot restore from vpc backup to non-vpc DB instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRestoreFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRestoreFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRestoreFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRestoreFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRestoreFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRestoreFault")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRestoreFault {}
/// See [`InvalidRestoreFault`](crate::error::InvalidRestoreFault)
pub mod invalid_restore_fault {
    /// A builder for [`InvalidRestoreFault`](crate::error::InvalidRestoreFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRestoreFault`](crate::error::InvalidRestoreFault)
        pub fn build(self) -> crate::error::InvalidRestoreFault {
            crate::error::InvalidRestoreFault {
                message: self.message,
            }
        }
    }
}
impl InvalidRestoreFault {
    /// Creates a new builder-style object to manufacture [`InvalidRestoreFault`](crate::error::InvalidRestoreFault)
    pub fn builder() -> crate::error::invalid_restore_fault::Builder {
        crate::error::invalid_restore_fault::Builder::default()
    }
}

/// <p>The state of the DB snapshot does not allow deletion.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDbSnapshotStateFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDbSnapshotStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDbSnapshotStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDbSnapshotStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDbSnapshotStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidDbSnapshotStateFault [InvalidDBSnapshotStateFault]"
        )?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDbSnapshotStateFault {}
/// See [`InvalidDbSnapshotStateFault`](crate::error::InvalidDbSnapshotStateFault)
pub mod invalid_db_snapshot_state_fault {
    /// A builder for [`InvalidDbSnapshotStateFault`](crate::error::InvalidDbSnapshotStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDbSnapshotStateFault`](crate::error::InvalidDbSnapshotStateFault)
        pub fn build(self) -> crate::error::InvalidDbSnapshotStateFault {
            crate::error::InvalidDbSnapshotStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidDbSnapshotStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidDbSnapshotStateFault`](crate::error::InvalidDbSnapshotStateFault)
    pub fn builder() -> crate::error::invalid_db_snapshot_state_fault::Builder {
        crate::error::invalid_db_snapshot_state_fault::Builder::default()
    }
}

/// <p>The supplied value is not a valid DB cluster snapshot state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDbClusterSnapshotStateFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDbClusterSnapshotStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDbClusterSnapshotStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDbClusterSnapshotStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDbClusterSnapshotStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidDbClusterSnapshotStateFault [InvalidDBClusterSnapshotStateFault]"
        )?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDbClusterSnapshotStateFault {}
/// See [`InvalidDbClusterSnapshotStateFault`](crate::error::InvalidDbClusterSnapshotStateFault)
pub mod invalid_db_cluster_snapshot_state_fault {
    /// A builder for [`InvalidDbClusterSnapshotStateFault`](crate::error::InvalidDbClusterSnapshotStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDbClusterSnapshotStateFault`](crate::error::InvalidDbClusterSnapshotStateFault)
        pub fn build(self) -> crate::error::InvalidDbClusterSnapshotStateFault {
            crate::error::InvalidDbClusterSnapshotStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidDbClusterSnapshotStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidDbClusterSnapshotStateFault`](crate::error::InvalidDbClusterSnapshotStateFault)
    pub fn builder() -> crate::error::invalid_db_cluster_snapshot_state_fault::Builder {
        crate::error::invalid_db_cluster_snapshot_state_fault::Builder::default()
    }
}

/// <p>There is insufficient storage available for the current action. You may be able to resolve this error by updating your subnet group to use different Availability Zones that have more storage available.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientStorageClusterCapacityFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientStorageClusterCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientStorageClusterCapacityFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientStorageClusterCapacityFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientStorageClusterCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientStorageClusterCapacityFault")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientStorageClusterCapacityFault {}
/// See [`InsufficientStorageClusterCapacityFault`](crate::error::InsufficientStorageClusterCapacityFault)
pub mod insufficient_storage_cluster_capacity_fault {
    /// A builder for [`InsufficientStorageClusterCapacityFault`](crate::error::InsufficientStorageClusterCapacityFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientStorageClusterCapacityFault`](crate::error::InsufficientStorageClusterCapacityFault)
        pub fn build(self) -> crate::error::InsufficientStorageClusterCapacityFault {
            crate::error::InsufficientStorageClusterCapacityFault {
                message: self.message,
            }
        }
    }
}
impl InsufficientStorageClusterCapacityFault {
    /// Creates a new builder-style object to manufacture [`InsufficientStorageClusterCapacityFault`](crate::error::InsufficientStorageClusterCapacityFault)
    pub fn builder() -> crate::error::insufficient_storage_cluster_capacity_fault::Builder {
        crate::error::insufficient_storage_cluster_capacity_fault::Builder::default()
    }
}

/// <p>The DB cluster does not have enough capacity for the current operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientDbClusterCapacityFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientDbClusterCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientDbClusterCapacityFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientDbClusterCapacityFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientDbClusterCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InsufficientDbClusterCapacityFault [InsufficientDBClusterCapacityFault]"
        )?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientDbClusterCapacityFault {}
/// See [`InsufficientDbClusterCapacityFault`](crate::error::InsufficientDbClusterCapacityFault)
pub mod insufficient_db_cluster_capacity_fault {
    /// A builder for [`InsufficientDbClusterCapacityFault`](crate::error::InsufficientDbClusterCapacityFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientDbClusterCapacityFault`](crate::error::InsufficientDbClusterCapacityFault)
        pub fn build(self) -> crate::error::InsufficientDbClusterCapacityFault {
            crate::error::InsufficientDbClusterCapacityFault {
                message: self.message,
            }
        }
    }
}
impl InsufficientDbClusterCapacityFault {
    /// Creates a new builder-style object to manufacture [`InsufficientDbClusterCapacityFault`](crate::error::InsufficientDbClusterCapacityFault)
    pub fn builder() -> crate::error::insufficient_db_cluster_capacity_fault::Builder {
        crate::error::insufficient_db_cluster_capacity_fault::Builder::default()
    }
}

/// <p> <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSubnetGroupNotFoundFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbSubnetGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSubnetGroupNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbSubnetGroupNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbSubnetGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DbSubnetGroupNotFoundFault [DBSubnetGroupNotFoundFault]")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbSubnetGroupNotFoundFault {}
/// See [`DbSubnetGroupNotFoundFault`](crate::error::DbSubnetGroupNotFoundFault)
pub mod db_subnet_group_not_found_fault {
    /// A builder for [`DbSubnetGroupNotFoundFault`](crate::error::DbSubnetGroupNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSubnetGroupNotFoundFault`](crate::error::DbSubnetGroupNotFoundFault)
        pub fn build(self) -> crate::error::DbSubnetGroupNotFoundFault {
            crate::error::DbSubnetGroupNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbSubnetGroupNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbSubnetGroupNotFoundFault`](crate::error::DbSubnetGroupNotFoundFault)
    pub fn builder() -> crate::error::db_subnet_group_not_found_fault::Builder {
        crate::error::db_subnet_group_not_found_fault::Builder::default()
    }
}

/// <p> <i>DBClusterSnapshotIdentifier</i> does not refer to an existing DB cluster snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterSnapshotNotFoundFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterSnapshotNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterSnapshotNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbClusterSnapshotNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbClusterSnapshotNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbClusterSnapshotNotFoundFault [DBClusterSnapshotNotFoundFault]"
        )?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbClusterSnapshotNotFoundFault {}
/// See [`DbClusterSnapshotNotFoundFault`](crate::error::DbClusterSnapshotNotFoundFault)
pub mod db_cluster_snapshot_not_found_fault {
    /// A builder for [`DbClusterSnapshotNotFoundFault`](crate::error::DbClusterSnapshotNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterSnapshotNotFoundFault`](crate::error::DbClusterSnapshotNotFoundFault)
        pub fn build(self) -> crate::error::DbClusterSnapshotNotFoundFault {
            crate::error::DbClusterSnapshotNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbClusterSnapshotNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbClusterSnapshotNotFoundFault`](crate::error::DbClusterSnapshotNotFoundFault)
    pub fn builder() -> crate::error::db_cluster_snapshot_not_found_fault::Builder {
        crate::error::db_cluster_snapshot_not_found_fault::Builder::default()
    }
}

/// <p>User attempted to create a new DB cluster and the user has already reached the maximum allowed DB cluster quota.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterQuotaExceededFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbClusterQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbClusterQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbClusterQuotaExceededFault [DBClusterQuotaExceededFault]"
        )?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbClusterQuotaExceededFault {}
/// See [`DbClusterQuotaExceededFault`](crate::error::DbClusterQuotaExceededFault)
pub mod db_cluster_quota_exceeded_fault {
    /// A builder for [`DbClusterQuotaExceededFault`](crate::error::DbClusterQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterQuotaExceededFault`](crate::error::DbClusterQuotaExceededFault)
        pub fn build(self) -> crate::error::DbClusterQuotaExceededFault {
            crate::error::DbClusterQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl DbClusterQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`DbClusterQuotaExceededFault`](crate::error::DbClusterQuotaExceededFault)
    pub fn builder() -> crate::error::db_cluster_quota_exceeded_fault::Builder {
        crate::error::db_cluster_quota_exceeded_fault::Builder::default()
    }
}

/// <p> <i>DBClusterParameterGroupName</i> does not refer to an existing DB Cluster parameter group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterParameterGroupNotFoundFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterParameterGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterParameterGroupNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbClusterParameterGroupNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbClusterParameterGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbClusterParameterGroupNotFoundFault [DBClusterParameterGroupNotFoundFault]"
        )?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbClusterParameterGroupNotFoundFault {}
/// See [`DbClusterParameterGroupNotFoundFault`](crate::error::DbClusterParameterGroupNotFoundFault)
pub mod db_cluster_parameter_group_not_found_fault {
    /// A builder for [`DbClusterParameterGroupNotFoundFault`](crate::error::DbClusterParameterGroupNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterParameterGroupNotFoundFault`](crate::error::DbClusterParameterGroupNotFoundFault)
        pub fn build(self) -> crate::error::DbClusterParameterGroupNotFoundFault {
            crate::error::DbClusterParameterGroupNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbClusterParameterGroupNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbClusterParameterGroupNotFoundFault`](crate::error::DbClusterParameterGroupNotFoundFault)
    pub fn builder() -> crate::error::db_cluster_parameter_group_not_found_fault::Builder {
        crate::error::db_cluster_parameter_group_not_found_fault::Builder::default()
    }
}

/// <p>User already has a DB cluster with the given identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterAlreadyExistsFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbClusterAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbClusterAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbClusterAlreadyExistsFault [DBClusterAlreadyExistsFault]"
        )?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbClusterAlreadyExistsFault {}
/// See [`DbClusterAlreadyExistsFault`](crate::error::DbClusterAlreadyExistsFault)
pub mod db_cluster_already_exists_fault {
    /// A builder for [`DbClusterAlreadyExistsFault`](crate::error::DbClusterAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterAlreadyExistsFault`](crate::error::DbClusterAlreadyExistsFault)
        pub fn build(self) -> crate::error::DbClusterAlreadyExistsFault {
            crate::error::DbClusterAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl DbClusterAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`DbClusterAlreadyExistsFault`](crate::error::DbClusterAlreadyExistsFault)
    pub fn builder() -> crate::error::db_cluster_already_exists_fault::Builder {
        crate::error::db_cluster_already_exists_fault::Builder::default()
    }
}

/// <p> <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSnapshotNotFoundFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbSnapshotNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSnapshotNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbSnapshotNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbSnapshotNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DbSnapshotNotFoundFault [DBSnapshotNotFoundFault]")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbSnapshotNotFoundFault {}
/// See [`DbSnapshotNotFoundFault`](crate::error::DbSnapshotNotFoundFault)
pub mod db_snapshot_not_found_fault {
    /// A builder for [`DbSnapshotNotFoundFault`](crate::error::DbSnapshotNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSnapshotNotFoundFault`](crate::error::DbSnapshotNotFoundFault)
        pub fn build(self) -> crate::error::DbSnapshotNotFoundFault {
            crate::error::DbSnapshotNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbSnapshotNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbSnapshotNotFoundFault`](crate::error::DbSnapshotNotFoundFault)
    pub fn builder() -> crate::error::db_snapshot_not_found_fault::Builder {
        crate::error::db_snapshot_not_found_fault::Builder::default()
    }
}

/// <p>The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter group, you cannot delete it when the parameter group is in this state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDbParameterGroupStateFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDbParameterGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDbParameterGroupStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDbParameterGroupStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDbParameterGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidDbParameterGroupStateFault [InvalidDBParameterGroupStateFault]"
        )?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDbParameterGroupStateFault {}
/// See [`InvalidDbParameterGroupStateFault`](crate::error::InvalidDbParameterGroupStateFault)
pub mod invalid_db_parameter_group_state_fault {
    /// A builder for [`InvalidDbParameterGroupStateFault`](crate::error::InvalidDbParameterGroupStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDbParameterGroupStateFault`](crate::error::InvalidDbParameterGroupStateFault)
        pub fn build(self) -> crate::error::InvalidDbParameterGroupStateFault {
            crate::error::InvalidDbParameterGroupStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidDbParameterGroupStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidDbParameterGroupStateFault`](crate::error::InvalidDbParameterGroupStateFault)
    pub fn builder() -> crate::error::invalid_db_parameter_group_state_fault::Builder {
        crate::error::invalid_db_parameter_group_state_fault::Builder::default()
    }
}

/// <p> <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbParameterGroupNotFoundFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbParameterGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbParameterGroupNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbParameterGroupNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbParameterGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbParameterGroupNotFoundFault [DBParameterGroupNotFoundFault]"
        )?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbParameterGroupNotFoundFault {}
/// See [`DbParameterGroupNotFoundFault`](crate::error::DbParameterGroupNotFoundFault)
pub mod db_parameter_group_not_found_fault {
    /// A builder for [`DbParameterGroupNotFoundFault`](crate::error::DbParameterGroupNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbParameterGroupNotFoundFault`](crate::error::DbParameterGroupNotFoundFault)
        pub fn build(self) -> crate::error::DbParameterGroupNotFoundFault {
            crate::error::DbParameterGroupNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbParameterGroupNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbParameterGroupNotFoundFault`](crate::error::DbParameterGroupNotFoundFault)
    pub fn builder() -> crate::error::db_parameter_group_not_found_fault::Builder {
        crate::error::db_parameter_group_not_found_fault::Builder::default()
    }
}

/// <p> <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbInstanceNotFoundFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbInstanceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbInstanceNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbInstanceNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbInstanceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DbInstanceNotFoundFault [DBInstanceNotFoundFault]")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbInstanceNotFoundFault {}
/// See [`DbInstanceNotFoundFault`](crate::error::DbInstanceNotFoundFault)
pub mod db_instance_not_found_fault {
    /// A builder for [`DbInstanceNotFoundFault`](crate::error::DbInstanceNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbInstanceNotFoundFault`](crate::error::DbInstanceNotFoundFault)
        pub fn build(self) -> crate::error::DbInstanceNotFoundFault {
            crate::error::DbInstanceNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbInstanceNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbInstanceNotFoundFault`](crate::error::DbInstanceNotFoundFault)
    pub fn builder() -> crate::error::db_instance_not_found_fault::Builder {
        crate::error::db_instance_not_found_fault::Builder::default()
    }
}

/// <p>The designated subscription could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscriptionNotFoundFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubscriptionNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscriptionNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubscriptionNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubscriptionNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubscriptionNotFoundFault")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubscriptionNotFoundFault {}
/// See [`SubscriptionNotFoundFault`](crate::error::SubscriptionNotFoundFault)
pub mod subscription_not_found_fault {
    /// A builder for [`SubscriptionNotFoundFault`](crate::error::SubscriptionNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscriptionNotFoundFault`](crate::error::SubscriptionNotFoundFault)
        pub fn build(self) -> crate::error::SubscriptionNotFoundFault {
            crate::error::SubscriptionNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl SubscriptionNotFoundFault {
    /// Creates a new builder-style object to manufacture [`SubscriptionNotFoundFault`](crate::error::SubscriptionNotFoundFault)
    pub fn builder() -> crate::error::subscription_not_found_fault::Builder {
        crate::error::subscription_not_found_fault::Builder::default()
    }
}

/// <p>The source could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceNotFoundFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SourceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SourceNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SourceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SourceNotFoundFault")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for SourceNotFoundFault {}
/// See [`SourceNotFoundFault`](crate::error::SourceNotFoundFault)
pub mod source_not_found_fault {
    /// A builder for [`SourceNotFoundFault`](crate::error::SourceNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceNotFoundFault`](crate::error::SourceNotFoundFault)
        pub fn build(self) -> crate::error::SourceNotFoundFault {
            crate::error::SourceNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl SourceNotFoundFault {
    /// Creates a new builder-style object to manufacture [`SourceNotFoundFault`](crate::error::SourceNotFoundFault)
    pub fn builder() -> crate::error::source_not_found_fault::Builder {
        crate::error::source_not_found_fault::Builder::default()
    }
}

/// <p>The specified IAM role Amazon Resource Name (ARN) is not associated with the specified DB cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterRoleNotFoundFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterRoleNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterRoleNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbClusterRoleNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbClusterRoleNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DbClusterRoleNotFoundFault [DBClusterRoleNotFoundFault]")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbClusterRoleNotFoundFault {}
/// See [`DbClusterRoleNotFoundFault`](crate::error::DbClusterRoleNotFoundFault)
pub mod db_cluster_role_not_found_fault {
    /// A builder for [`DbClusterRoleNotFoundFault`](crate::error::DbClusterRoleNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterRoleNotFoundFault`](crate::error::DbClusterRoleNotFoundFault)
        pub fn build(self) -> crate::error::DbClusterRoleNotFoundFault {
            crate::error::DbClusterRoleNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbClusterRoleNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbClusterRoleNotFoundFault`](crate::error::DbClusterRoleNotFoundFault)
    pub fn builder() -> crate::error::db_cluster_role_not_found_fault::Builder {
        crate::error::db_cluster_role_not_found_fault::Builder::default()
    }
}

/// <p>The designated subscription category could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscriptionCategoryNotFoundFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubscriptionCategoryNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscriptionCategoryNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubscriptionCategoryNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubscriptionCategoryNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubscriptionCategoryNotFoundFault")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubscriptionCategoryNotFoundFault {}
/// See [`SubscriptionCategoryNotFoundFault`](crate::error::SubscriptionCategoryNotFoundFault)
pub mod subscription_category_not_found_fault {
    /// A builder for [`SubscriptionCategoryNotFoundFault`](crate::error::SubscriptionCategoryNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscriptionCategoryNotFoundFault`](crate::error::SubscriptionCategoryNotFoundFault)
        pub fn build(self) -> crate::error::SubscriptionCategoryNotFoundFault {
            crate::error::SubscriptionCategoryNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl SubscriptionCategoryNotFoundFault {
    /// Creates a new builder-style object to manufacture [`SubscriptionCategoryNotFoundFault`](crate::error::SubscriptionCategoryNotFoundFault)
    pub fn builder() -> crate::error::subscription_category_not_found_fault::Builder {
        crate::error::subscription_category_not_found_fault::Builder::default()
    }
}

/// <p>The ARN of the SNS topic could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsTopicArnNotFoundFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnsTopicArnNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsTopicArnNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnsTopicArnNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnsTopicArnNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnsTopicArnNotFoundFault [SNSTopicArnNotFoundFault]")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnsTopicArnNotFoundFault {}
/// See [`SnsTopicArnNotFoundFault`](crate::error::SnsTopicArnNotFoundFault)
pub mod sns_topic_arn_not_found_fault {
    /// A builder for [`SnsTopicArnNotFoundFault`](crate::error::SnsTopicArnNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsTopicArnNotFoundFault`](crate::error::SnsTopicArnNotFoundFault)
        pub fn build(self) -> crate::error::SnsTopicArnNotFoundFault {
            crate::error::SnsTopicArnNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl SnsTopicArnNotFoundFault {
    /// Creates a new builder-style object to manufacture [`SnsTopicArnNotFoundFault`](crate::error::SnsTopicArnNotFoundFault)
    pub fn builder() -> crate::error::sns_topic_arn_not_found_fault::Builder {
        crate::error::sns_topic_arn_not_found_fault::Builder::default()
    }
}

/// <p>There is no SNS authorization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsNoAuthorizationFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnsNoAuthorizationFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsNoAuthorizationFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnsNoAuthorizationFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnsNoAuthorizationFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnsNoAuthorizationFault [SNSNoAuthorizationFault]")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnsNoAuthorizationFault {}
/// See [`SnsNoAuthorizationFault`](crate::error::SnsNoAuthorizationFault)
pub mod sns_no_authorization_fault {
    /// A builder for [`SnsNoAuthorizationFault`](crate::error::SnsNoAuthorizationFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsNoAuthorizationFault`](crate::error::SnsNoAuthorizationFault)
        pub fn build(self) -> crate::error::SnsNoAuthorizationFault {
            crate::error::SnsNoAuthorizationFault {
                message: self.message,
            }
        }
    }
}
impl SnsNoAuthorizationFault {
    /// Creates a new builder-style object to manufacture [`SnsNoAuthorizationFault`](crate::error::SnsNoAuthorizationFault)
    pub fn builder() -> crate::error::sns_no_authorization_fault::Builder {
        crate::error::sns_no_authorization_fault::Builder::default()
    }
}

/// <p>The SNS topic is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsInvalidTopicFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnsInvalidTopicFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsInvalidTopicFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnsInvalidTopicFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnsInvalidTopicFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnsInvalidTopicFault [SNSInvalidTopicFault]")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnsInvalidTopicFault {}
/// See [`SnsInvalidTopicFault`](crate::error::SnsInvalidTopicFault)
pub mod sns_invalid_topic_fault {
    /// A builder for [`SnsInvalidTopicFault`](crate::error::SnsInvalidTopicFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsInvalidTopicFault`](crate::error::SnsInvalidTopicFault)
        pub fn build(self) -> crate::error::SnsInvalidTopicFault {
            crate::error::SnsInvalidTopicFault {
                message: self.message,
            }
        }
    }
}
impl SnsInvalidTopicFault {
    /// Creates a new builder-style object to manufacture [`SnsInvalidTopicFault`](crate::error::SnsInvalidTopicFault)
    pub fn builder() -> crate::error::sns_invalid_topic_fault::Builder {
        crate::error::sns_invalid_topic_fault::Builder::default()
    }
}

/// <p>You have exceeded the number of events you can subscribe to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventSubscriptionQuotaExceededFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EventSubscriptionQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventSubscriptionQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EventSubscriptionQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EventSubscriptionQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EventSubscriptionQuotaExceededFault")?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for EventSubscriptionQuotaExceededFault {}
/// See [`EventSubscriptionQuotaExceededFault`](crate::error::EventSubscriptionQuotaExceededFault)
pub mod event_subscription_quota_exceeded_fault {
    /// A builder for [`EventSubscriptionQuotaExceededFault`](crate::error::EventSubscriptionQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EventSubscriptionQuotaExceededFault`](crate::error::EventSubscriptionQuotaExceededFault)
        pub fn build(self) -> crate::error::EventSubscriptionQuotaExceededFault {
            crate::error::EventSubscriptionQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl EventSubscriptionQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`EventSubscriptionQuotaExceededFault`](crate::error::EventSubscriptionQuotaExceededFault)
    pub fn builder() -> crate::error::event_subscription_quota_exceeded_fault::Builder {
        crate::error::event_subscription_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The DB subnet is already in use in the Availability Zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetAlreadyInUse {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubnetAlreadyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetAlreadyInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetAlreadyInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetAlreadyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetAlreadyInUse")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetAlreadyInUse {}
/// See [`SubnetAlreadyInUse`](crate::error::SubnetAlreadyInUse)
pub mod subnet_already_in_use {
    /// A builder for [`SubnetAlreadyInUse`](crate::error::SubnetAlreadyInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetAlreadyInUse`](crate::error::SubnetAlreadyInUse)
        pub fn build(self) -> crate::error::SubnetAlreadyInUse {
            crate::error::SubnetAlreadyInUse {
                message: self.message,
            }
        }
    }
}
impl SubnetAlreadyInUse {
    /// Creates a new builder-style object to manufacture [`SubnetAlreadyInUse`](crate::error::SubnetAlreadyInUse)
    pub fn builder() -> crate::error::subnet_already_in_use::Builder {
        crate::error::subnet_already_in_use::Builder::default()
    }
}

/// <p>Request would result in user exceeding the allowed number of subnets in a DB subnet groups.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSubnetQuotaExceededFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbSubnetQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSubnetQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbSubnetQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbSubnetQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DbSubnetQuotaExceededFault [DBSubnetQuotaExceededFault]")?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbSubnetQuotaExceededFault {}
/// See [`DbSubnetQuotaExceededFault`](crate::error::DbSubnetQuotaExceededFault)
pub mod db_subnet_quota_exceeded_fault {
    /// A builder for [`DbSubnetQuotaExceededFault`](crate::error::DbSubnetQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSubnetQuotaExceededFault`](crate::error::DbSubnetQuotaExceededFault)
        pub fn build(self) -> crate::error::DbSubnetQuotaExceededFault {
            crate::error::DbSubnetQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl DbSubnetQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`DbSubnetQuotaExceededFault`](crate::error::DbSubnetQuotaExceededFault)
    pub fn builder() -> crate::error::db_subnet_quota_exceeded_fault::Builder {
        crate::error::db_subnet_quota_exceeded_fault::Builder::default()
    }
}

/// <p>Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSubnetGroupDoesNotCoverEnoughAZs {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbSubnetGroupDoesNotCoverEnoughAZs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSubnetGroupDoesNotCoverEnoughAZs");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbSubnetGroupDoesNotCoverEnoughAZs {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbSubnetGroupDoesNotCoverEnoughAZs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbSubnetGroupDoesNotCoverEnoughAZs [DBSubnetGroupDoesNotCoverEnoughAZs]"
        )?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbSubnetGroupDoesNotCoverEnoughAZs {}
/// See [`DbSubnetGroupDoesNotCoverEnoughAZs`](crate::error::DbSubnetGroupDoesNotCoverEnoughAZs)
pub mod db_subnet_group_does_not_cover_enough_a_zs {
    /// A builder for [`DbSubnetGroupDoesNotCoverEnoughAZs`](crate::error::DbSubnetGroupDoesNotCoverEnoughAZs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSubnetGroupDoesNotCoverEnoughAZs`](crate::error::DbSubnetGroupDoesNotCoverEnoughAZs)
        pub fn build(self) -> crate::error::DbSubnetGroupDoesNotCoverEnoughAZs {
            crate::error::DbSubnetGroupDoesNotCoverEnoughAZs {
                message: self.message,
            }
        }
    }
}
impl DbSubnetGroupDoesNotCoverEnoughAZs {
    /// Creates a new builder-style object to manufacture [`DbSubnetGroupDoesNotCoverEnoughAZs`](crate::error::DbSubnetGroupDoesNotCoverEnoughAZs)
    pub fn builder() -> crate::error::db_subnet_group_does_not_cover_enough_a_zs::Builder {
        crate::error::db_subnet_group_does_not_cover_enough_a_zs::Builder::default()
    }
}

/// <p> <i>StorageType</i> specified cannot be associated with the DB Instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageTypeNotSupportedFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StorageTypeNotSupportedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageTypeNotSupportedFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StorageTypeNotSupportedFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StorageTypeNotSupportedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StorageTypeNotSupportedFault")?;
        if let Some(inner_34) = &self.message {
            write!(f, ": {}", inner_34)?;
        }
        Ok(())
    }
}
impl std::error::Error for StorageTypeNotSupportedFault {}
/// See [`StorageTypeNotSupportedFault`](crate::error::StorageTypeNotSupportedFault)
pub mod storage_type_not_supported_fault {
    /// A builder for [`StorageTypeNotSupportedFault`](crate::error::StorageTypeNotSupportedFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageTypeNotSupportedFault`](crate::error::StorageTypeNotSupportedFault)
        pub fn build(self) -> crate::error::StorageTypeNotSupportedFault {
            crate::error::StorageTypeNotSupportedFault {
                message: self.message,
            }
        }
    }
}
impl StorageTypeNotSupportedFault {
    /// Creates a new builder-style object to manufacture [`StorageTypeNotSupportedFault`](crate::error::StorageTypeNotSupportedFault)
    pub fn builder() -> crate::error::storage_type_not_supported_fault::Builder {
        crate::error::storage_type_not_supported_fault::Builder::default()
    }
}

/// <p>Provisioned IOPS not available in the specified Availability Zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionedIopsNotAvailableInAzFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProvisionedIopsNotAvailableInAzFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionedIopsNotAvailableInAzFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ProvisionedIopsNotAvailableInAzFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ProvisionedIopsNotAvailableInAzFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "ProvisionedIopsNotAvailableInAzFault [ProvisionedIopsNotAvailableInAZFault]"
        )?;
        if let Some(inner_35) = &self.message {
            write!(f, ": {}", inner_35)?;
        }
        Ok(())
    }
}
impl std::error::Error for ProvisionedIopsNotAvailableInAzFault {}
/// See [`ProvisionedIopsNotAvailableInAzFault`](crate::error::ProvisionedIopsNotAvailableInAzFault)
pub mod provisioned_iops_not_available_in_az_fault {
    /// A builder for [`ProvisionedIopsNotAvailableInAzFault`](crate::error::ProvisionedIopsNotAvailableInAzFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionedIopsNotAvailableInAzFault`](crate::error::ProvisionedIopsNotAvailableInAzFault)
        pub fn build(self) -> crate::error::ProvisionedIopsNotAvailableInAzFault {
            crate::error::ProvisionedIopsNotAvailableInAzFault {
                message: self.message,
            }
        }
    }
}
impl ProvisionedIopsNotAvailableInAzFault {
    /// Creates a new builder-style object to manufacture [`ProvisionedIopsNotAvailableInAzFault`](crate::error::ProvisionedIopsNotAvailableInAzFault)
    pub fn builder() -> crate::error::provisioned_iops_not_available_in_az_fault::Builder {
        crate::error::provisioned_iops_not_available_in_az_fault::Builder::default()
    }
}

/// <p>The state of the DB security group does not allow deletion.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDbSecurityGroupStateFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDbSecurityGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDbSecurityGroupStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDbSecurityGroupStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDbSecurityGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidDbSecurityGroupStateFault [InvalidDBSecurityGroupStateFault]"
        )?;
        if let Some(inner_36) = &self.message {
            write!(f, ": {}", inner_36)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDbSecurityGroupStateFault {}
/// See [`InvalidDbSecurityGroupStateFault`](crate::error::InvalidDbSecurityGroupStateFault)
pub mod invalid_db_security_group_state_fault {
    /// A builder for [`InvalidDbSecurityGroupStateFault`](crate::error::InvalidDbSecurityGroupStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDbSecurityGroupStateFault`](crate::error::InvalidDbSecurityGroupStateFault)
        pub fn build(self) -> crate::error::InvalidDbSecurityGroupStateFault {
            crate::error::InvalidDbSecurityGroupStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidDbSecurityGroupStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidDbSecurityGroupStateFault`](crate::error::InvalidDbSecurityGroupStateFault)
    pub fn builder() -> crate::error::invalid_db_security_group_state_fault::Builder {
        crate::error::invalid_db_security_group_state_fault::Builder::default()
    }
}

/// <p>Specified DB instance class is not available in the specified Availability Zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientDbInstanceCapacityFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientDbInstanceCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientDbInstanceCapacityFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientDbInstanceCapacityFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientDbInstanceCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InsufficientDbInstanceCapacityFault [InsufficientDBInstanceCapacityFault]"
        )?;
        if let Some(inner_37) = &self.message {
            write!(f, ": {}", inner_37)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientDbInstanceCapacityFault {}
/// See [`InsufficientDbInstanceCapacityFault`](crate::error::InsufficientDbInstanceCapacityFault)
pub mod insufficient_db_instance_capacity_fault {
    /// A builder for [`InsufficientDbInstanceCapacityFault`](crate::error::InsufficientDbInstanceCapacityFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientDbInstanceCapacityFault`](crate::error::InsufficientDbInstanceCapacityFault)
        pub fn build(self) -> crate::error::InsufficientDbInstanceCapacityFault {
            crate::error::InsufficientDbInstanceCapacityFault {
                message: self.message,
            }
        }
    }
}
impl InsufficientDbInstanceCapacityFault {
    /// Creates a new builder-style object to manufacture [`InsufficientDbInstanceCapacityFault`](crate::error::InsufficientDbInstanceCapacityFault)
    pub fn builder() -> crate::error::insufficient_db_instance_capacity_fault::Builder {
        crate::error::insufficient_db_instance_capacity_fault::Builder::default()
    }
}

/// <p> <i>Domain</i> does not refer to an existing Active Directory Domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainNotFoundFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DomainNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DomainNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DomainNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DomainNotFoundFault")?;
        if let Some(inner_38) = &self.message {
            write!(f, ": {}", inner_38)?;
        }
        Ok(())
    }
}
impl std::error::Error for DomainNotFoundFault {}
/// See [`DomainNotFoundFault`](crate::error::DomainNotFoundFault)
pub mod domain_not_found_fault {
    /// A builder for [`DomainNotFoundFault`](crate::error::DomainNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainNotFoundFault`](crate::error::DomainNotFoundFault)
        pub fn build(self) -> crate::error::DomainNotFoundFault {
            crate::error::DomainNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DomainNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DomainNotFoundFault`](crate::error::DomainNotFoundFault)
    pub fn builder() -> crate::error::domain_not_found_fault::Builder {
        crate::error::domain_not_found_fault::Builder::default()
    }
}

/// <p>The DB upgrade failed because a resource the DB depends on could not be modified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbUpgradeDependencyFailureFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbUpgradeDependencyFailureFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbUpgradeDependencyFailureFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbUpgradeDependencyFailureFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbUpgradeDependencyFailureFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbUpgradeDependencyFailureFault [DBUpgradeDependencyFailureFault]"
        )?;
        if let Some(inner_39) = &self.message {
            write!(f, ": {}", inner_39)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbUpgradeDependencyFailureFault {}
/// See [`DbUpgradeDependencyFailureFault`](crate::error::DbUpgradeDependencyFailureFault)
pub mod db_upgrade_dependency_failure_fault {
    /// A builder for [`DbUpgradeDependencyFailureFault`](crate::error::DbUpgradeDependencyFailureFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbUpgradeDependencyFailureFault`](crate::error::DbUpgradeDependencyFailureFault)
        pub fn build(self) -> crate::error::DbUpgradeDependencyFailureFault {
            crate::error::DbUpgradeDependencyFailureFault {
                message: self.message,
            }
        }
    }
}
impl DbUpgradeDependencyFailureFault {
    /// Creates a new builder-style object to manufacture [`DbUpgradeDependencyFailureFault`](crate::error::DbUpgradeDependencyFailureFault)
    pub fn builder() -> crate::error::db_upgrade_dependency_failure_fault::Builder {
        crate::error::db_upgrade_dependency_failure_fault::Builder::default()
    }
}

/// <p> <i>DBSecurityGroupName</i> does not refer to an existing DB security group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSecurityGroupNotFoundFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbSecurityGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSecurityGroupNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbSecurityGroupNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbSecurityGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbSecurityGroupNotFoundFault [DBSecurityGroupNotFoundFault]"
        )?;
        if let Some(inner_40) = &self.message {
            write!(f, ": {}", inner_40)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbSecurityGroupNotFoundFault {}
/// See [`DbSecurityGroupNotFoundFault`](crate::error::DbSecurityGroupNotFoundFault)
pub mod db_security_group_not_found_fault {
    /// A builder for [`DbSecurityGroupNotFoundFault`](crate::error::DbSecurityGroupNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSecurityGroupNotFoundFault`](crate::error::DbSecurityGroupNotFoundFault)
        pub fn build(self) -> crate::error::DbSecurityGroupNotFoundFault {
            crate::error::DbSecurityGroupNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbSecurityGroupNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbSecurityGroupNotFoundFault`](crate::error::DbSecurityGroupNotFoundFault)
    pub fn builder() -> crate::error::db_security_group_not_found_fault::Builder {
        crate::error::db_security_group_not_found_fault::Builder::default()
    }
}

/// <p>User already has a DB instance with the given identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbInstanceAlreadyExistsFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbInstanceAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbInstanceAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbInstanceAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbInstanceAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbInstanceAlreadyExistsFault [DBInstanceAlreadyExistsFault]"
        )?;
        if let Some(inner_41) = &self.message {
            write!(f, ": {}", inner_41)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbInstanceAlreadyExistsFault {}
/// See [`DbInstanceAlreadyExistsFault`](crate::error::DbInstanceAlreadyExistsFault)
pub mod db_instance_already_exists_fault {
    /// A builder for [`DbInstanceAlreadyExistsFault`](crate::error::DbInstanceAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbInstanceAlreadyExistsFault`](crate::error::DbInstanceAlreadyExistsFault)
        pub fn build(self) -> crate::error::DbInstanceAlreadyExistsFault {
            crate::error::DbInstanceAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl DbInstanceAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`DbInstanceAlreadyExistsFault`](crate::error::DbInstanceAlreadyExistsFault)
    pub fn builder() -> crate::error::db_instance_already_exists_fault::Builder {
        crate::error::db_instance_already_exists_fault::Builder::default()
    }
}

/// <p> <i>CertificateIdentifier</i> does not refer to an existing certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateNotFoundFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CertificateNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CertificateNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CertificateNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CertificateNotFoundFault")?;
        if let Some(inner_42) = &self.message {
            write!(f, ": {}", inner_42)?;
        }
        Ok(())
    }
}
impl std::error::Error for CertificateNotFoundFault {}
/// See [`CertificateNotFoundFault`](crate::error::CertificateNotFoundFault)
pub mod certificate_not_found_fault {
    /// A builder for [`CertificateNotFoundFault`](crate::error::CertificateNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateNotFoundFault`](crate::error::CertificateNotFoundFault)
        pub fn build(self) -> crate::error::CertificateNotFoundFault {
            crate::error::CertificateNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl CertificateNotFoundFault {
    /// Creates a new builder-style object to manufacture [`CertificateNotFoundFault`](crate::error::CertificateNotFoundFault)
    pub fn builder() -> crate::error::certificate_not_found_fault::Builder {
        crate::error::certificate_not_found_fault::Builder::default()
    }
}

/// <p>Specified CIDRIP or EC2 security group is not authorized for the specified DB security group.</p>
/// <p>Neptune may not also be authorized via IAM to perform necessary actions on your behalf.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthorizationNotFoundFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AuthorizationNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthorizationNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AuthorizationNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AuthorizationNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AuthorizationNotFoundFault")?;
        if let Some(inner_43) = &self.message {
            write!(f, ": {}", inner_43)?;
        }
        Ok(())
    }
}
impl std::error::Error for AuthorizationNotFoundFault {}
/// See [`AuthorizationNotFoundFault`](crate::error::AuthorizationNotFoundFault)
pub mod authorization_not_found_fault {
    /// A builder for [`AuthorizationNotFoundFault`](crate::error::AuthorizationNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizationNotFoundFault`](crate::error::AuthorizationNotFoundFault)
        pub fn build(self) -> crate::error::AuthorizationNotFoundFault {
            crate::error::AuthorizationNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl AuthorizationNotFoundFault {
    /// Creates a new builder-style object to manufacture [`AuthorizationNotFoundFault`](crate::error::AuthorizationNotFoundFault)
    pub fn builder() -> crate::error::authorization_not_found_fault::Builder {
        crate::error::authorization_not_found_fault::Builder::default()
    }
}

/// <p>You have exceeded the maximum number of accounts that you can share a manual DB snapshot with.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SharedSnapshotQuotaExceededFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SharedSnapshotQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SharedSnapshotQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SharedSnapshotQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SharedSnapshotQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SharedSnapshotQuotaExceededFault")?;
        if let Some(inner_44) = &self.message {
            write!(f, ": {}", inner_44)?;
        }
        Ok(())
    }
}
impl std::error::Error for SharedSnapshotQuotaExceededFault {}
/// See [`SharedSnapshotQuotaExceededFault`](crate::error::SharedSnapshotQuotaExceededFault)
pub mod shared_snapshot_quota_exceeded_fault {
    /// A builder for [`SharedSnapshotQuotaExceededFault`](crate::error::SharedSnapshotQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SharedSnapshotQuotaExceededFault`](crate::error::SharedSnapshotQuotaExceededFault)
        pub fn build(self) -> crate::error::SharedSnapshotQuotaExceededFault {
            crate::error::SharedSnapshotQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl SharedSnapshotQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`SharedSnapshotQuotaExceededFault`](crate::error::SharedSnapshotQuotaExceededFault)
    pub fn builder() -> crate::error::shared_snapshot_quota_exceeded_fault::Builder {
        crate::error::shared_snapshot_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The requested operation cannot be performed on the endpoint while the endpoint is in this state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDbClusterEndpointStateFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDbClusterEndpointStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDbClusterEndpointStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDbClusterEndpointStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDbClusterEndpointStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidDbClusterEndpointStateFault [InvalidDBClusterEndpointStateFault]"
        )?;
        if let Some(inner_45) = &self.message {
            write!(f, ": {}", inner_45)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDbClusterEndpointStateFault {}
/// See [`InvalidDbClusterEndpointStateFault`](crate::error::InvalidDbClusterEndpointStateFault)
pub mod invalid_db_cluster_endpoint_state_fault {
    /// A builder for [`InvalidDbClusterEndpointStateFault`](crate::error::InvalidDbClusterEndpointStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDbClusterEndpointStateFault`](crate::error::InvalidDbClusterEndpointStateFault)
        pub fn build(self) -> crate::error::InvalidDbClusterEndpointStateFault {
            crate::error::InvalidDbClusterEndpointStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidDbClusterEndpointStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidDbClusterEndpointStateFault`](crate::error::InvalidDbClusterEndpointStateFault)
    pub fn builder() -> crate::error::invalid_db_cluster_endpoint_state_fault::Builder {
        crate::error::invalid_db_cluster_endpoint_state_fault::Builder::default()
    }
}

/// <p>The specified custom endpoint doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterEndpointNotFoundFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterEndpointNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterEndpointNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbClusterEndpointNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbClusterEndpointNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbClusterEndpointNotFoundFault [DBClusterEndpointNotFoundFault]"
        )?;
        if let Some(inner_46) = &self.message {
            write!(f, ": {}", inner_46)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbClusterEndpointNotFoundFault {}
/// See [`DbClusterEndpointNotFoundFault`](crate::error::DbClusterEndpointNotFoundFault)
pub mod db_cluster_endpoint_not_found_fault {
    /// A builder for [`DbClusterEndpointNotFoundFault`](crate::error::DbClusterEndpointNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterEndpointNotFoundFault`](crate::error::DbClusterEndpointNotFoundFault)
        pub fn build(self) -> crate::error::DbClusterEndpointNotFoundFault {
            crate::error::DbClusterEndpointNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbClusterEndpointNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbClusterEndpointNotFoundFault`](crate::error::DbClusterEndpointNotFoundFault)
    pub fn builder() -> crate::error::db_cluster_endpoint_not_found_fault::Builder {
        crate::error::db_cluster_endpoint_not_found_fault::Builder::default()
    }
}

/// <p>The DB subnet group cannot be deleted because it is in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDbSubnetGroupStateFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDbSubnetGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDbSubnetGroupStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDbSubnetGroupStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDbSubnetGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidDbSubnetGroupStateFault [InvalidDBSubnetGroupStateFault]"
        )?;
        if let Some(inner_47) = &self.message {
            write!(f, ": {}", inner_47)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDbSubnetGroupStateFault {}
/// See [`InvalidDbSubnetGroupStateFault`](crate::error::InvalidDbSubnetGroupStateFault)
pub mod invalid_db_subnet_group_state_fault {
    /// A builder for [`InvalidDbSubnetGroupStateFault`](crate::error::InvalidDbSubnetGroupStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDbSubnetGroupStateFault`](crate::error::InvalidDbSubnetGroupStateFault)
        pub fn build(self) -> crate::error::InvalidDbSubnetGroupStateFault {
            crate::error::InvalidDbSubnetGroupStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidDbSubnetGroupStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidDbSubnetGroupStateFault`](crate::error::InvalidDbSubnetGroupStateFault)
    pub fn builder() -> crate::error::invalid_db_subnet_group_state_fault::Builder {
        crate::error::invalid_db_subnet_group_state_fault::Builder::default()
    }
}

/// <p>The specified resource ID was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundFault")?;
        if let Some(inner_48) = &self.message {
            write!(f, ": {}", inner_48)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundFault {}
/// See [`ResourceNotFoundFault`](crate::error::ResourceNotFoundFault)
pub mod resource_not_found_fault {
    /// A builder for [`ResourceNotFoundFault`](crate::error::ResourceNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundFault`](crate::error::ResourceNotFoundFault)
        pub fn build(self) -> crate::error::ResourceNotFoundFault {
            crate::error::ResourceNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundFault`](crate::error::ResourceNotFoundFault)
    pub fn builder() -> crate::error::resource_not_found_fault::Builder {
        crate::error::resource_not_found_fault::Builder::default()
    }
}

/// <p>The event subscription is in an invalid state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidEventSubscriptionStateFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidEventSubscriptionStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidEventSubscriptionStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidEventSubscriptionStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidEventSubscriptionStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidEventSubscriptionStateFault")?;
        if let Some(inner_49) = &self.message {
            write!(f, ": {}", inner_49)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidEventSubscriptionStateFault {}
/// See [`InvalidEventSubscriptionStateFault`](crate::error::InvalidEventSubscriptionStateFault)
pub mod invalid_event_subscription_state_fault {
    /// A builder for [`InvalidEventSubscriptionStateFault`](crate::error::InvalidEventSubscriptionStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidEventSubscriptionStateFault`](crate::error::InvalidEventSubscriptionStateFault)
        pub fn build(self) -> crate::error::InvalidEventSubscriptionStateFault {
            crate::error::InvalidEventSubscriptionStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidEventSubscriptionStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidEventSubscriptionStateFault`](crate::error::InvalidEventSubscriptionStateFault)
    pub fn builder() -> crate::error::invalid_event_subscription_state_fault::Builder {
        crate::error::invalid_event_subscription_state_fault::Builder::default()
    }
}

/// <p>The DB subnet is not in the <i>available</i> state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDbSubnetStateFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDbSubnetStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDbSubnetStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDbSubnetStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDbSubnetStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDbSubnetStateFault [InvalidDBSubnetStateFault]")?;
        if let Some(inner_50) = &self.message {
            write!(f, ": {}", inner_50)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDbSubnetStateFault {}
/// See [`InvalidDbSubnetStateFault`](crate::error::InvalidDbSubnetStateFault)
pub mod invalid_db_subnet_state_fault {
    /// A builder for [`InvalidDbSubnetStateFault`](crate::error::InvalidDbSubnetStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDbSubnetStateFault`](crate::error::InvalidDbSubnetStateFault)
        pub fn build(self) -> crate::error::InvalidDbSubnetStateFault {
            crate::error::InvalidDbSubnetStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidDbSubnetStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidDbSubnetStateFault`](crate::error::InvalidDbSubnetStateFault)
    pub fn builder() -> crate::error::invalid_db_subnet_state_fault::Builder {
        crate::error::invalid_db_subnet_state_fault::Builder::default()
    }
}

/// <p>Request would result in user exceeding the allowed number of DB snapshots.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotQuotaExceededFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnapshotQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnapshotQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnapshotQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnapshotQuotaExceededFault")?;
        if let Some(inner_51) = &self.message {
            write!(f, ": {}", inner_51)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnapshotQuotaExceededFault {}
/// See [`SnapshotQuotaExceededFault`](crate::error::SnapshotQuotaExceededFault)
pub mod snapshot_quota_exceeded_fault {
    /// A builder for [`SnapshotQuotaExceededFault`](crate::error::SnapshotQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotQuotaExceededFault`](crate::error::SnapshotQuotaExceededFault)
        pub fn build(self) -> crate::error::SnapshotQuotaExceededFault {
            crate::error::SnapshotQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl SnapshotQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`SnapshotQuotaExceededFault`](crate::error::SnapshotQuotaExceededFault)
    pub fn builder() -> crate::error::snapshot_quota_exceeded_fault::Builder {
        crate::error::snapshot_quota_exceeded_fault::Builder::default()
    }
}

/// <p> <i>DBSnapshotIdentifier</i> is already used by an existing snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSnapshotAlreadyExistsFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbSnapshotAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSnapshotAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbSnapshotAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbSnapshotAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbSnapshotAlreadyExistsFault [DBSnapshotAlreadyExistsFault]"
        )?;
        if let Some(inner_52) = &self.message {
            write!(f, ": {}", inner_52)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbSnapshotAlreadyExistsFault {}
/// See [`DbSnapshotAlreadyExistsFault`](crate::error::DbSnapshotAlreadyExistsFault)
pub mod db_snapshot_already_exists_fault {
    /// A builder for [`DbSnapshotAlreadyExistsFault`](crate::error::DbSnapshotAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSnapshotAlreadyExistsFault`](crate::error::DbSnapshotAlreadyExistsFault)
        pub fn build(self) -> crate::error::DbSnapshotAlreadyExistsFault {
            crate::error::DbSnapshotAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl DbSnapshotAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`DbSnapshotAlreadyExistsFault`](crate::error::DbSnapshotAlreadyExistsFault)
    pub fn builder() -> crate::error::db_snapshot_already_exists_fault::Builder {
        crate::error::db_snapshot_already_exists_fault::Builder::default()
    }
}

/// <p>User already has a DB cluster snapshot with the given identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterSnapshotAlreadyExistsFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterSnapshotAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterSnapshotAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbClusterSnapshotAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbClusterSnapshotAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbClusterSnapshotAlreadyExistsFault [DBClusterSnapshotAlreadyExistsFault]"
        )?;
        if let Some(inner_53) = &self.message {
            write!(f, ": {}", inner_53)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbClusterSnapshotAlreadyExistsFault {}
/// See [`DbClusterSnapshotAlreadyExistsFault`](crate::error::DbClusterSnapshotAlreadyExistsFault)
pub mod db_cluster_snapshot_already_exists_fault {
    /// A builder for [`DbClusterSnapshotAlreadyExistsFault`](crate::error::DbClusterSnapshotAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterSnapshotAlreadyExistsFault`](crate::error::DbClusterSnapshotAlreadyExistsFault)
        pub fn build(self) -> crate::error::DbClusterSnapshotAlreadyExistsFault {
            crate::error::DbClusterSnapshotAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl DbClusterSnapshotAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`DbClusterSnapshotAlreadyExistsFault`](crate::error::DbClusterSnapshotAlreadyExistsFault)
    pub fn builder() -> crate::error::db_cluster_snapshot_already_exists_fault::Builder {
        crate::error::db_cluster_snapshot_already_exists_fault::Builder::default()
    }
}

/// <p>This subscription already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscriptionAlreadyExistFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubscriptionAlreadyExistFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscriptionAlreadyExistFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubscriptionAlreadyExistFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubscriptionAlreadyExistFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubscriptionAlreadyExistFault")?;
        if let Some(inner_54) = &self.message {
            write!(f, ": {}", inner_54)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubscriptionAlreadyExistFault {}
/// See [`SubscriptionAlreadyExistFault`](crate::error::SubscriptionAlreadyExistFault)
pub mod subscription_already_exist_fault {
    /// A builder for [`SubscriptionAlreadyExistFault`](crate::error::SubscriptionAlreadyExistFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscriptionAlreadyExistFault`](crate::error::SubscriptionAlreadyExistFault)
        pub fn build(self) -> crate::error::SubscriptionAlreadyExistFault {
            crate::error::SubscriptionAlreadyExistFault {
                message: self.message,
            }
        }
    }
}
impl SubscriptionAlreadyExistFault {
    /// Creates a new builder-style object to manufacture [`SubscriptionAlreadyExistFault`](crate::error::SubscriptionAlreadyExistFault)
    pub fn builder() -> crate::error::subscription_already_exist_fault::Builder {
        crate::error::subscription_already_exist_fault::Builder::default()
    }
}

/// <p>Request would result in user exceeding the allowed number of DB subnet groups.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSubnetGroupQuotaExceededFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbSubnetGroupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSubnetGroupQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbSubnetGroupQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbSubnetGroupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbSubnetGroupQuotaExceededFault [DBSubnetGroupQuotaExceededFault]"
        )?;
        if let Some(inner_55) = &self.message {
            write!(f, ": {}", inner_55)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbSubnetGroupQuotaExceededFault {}
/// See [`DbSubnetGroupQuotaExceededFault`](crate::error::DbSubnetGroupQuotaExceededFault)
pub mod db_subnet_group_quota_exceeded_fault {
    /// A builder for [`DbSubnetGroupQuotaExceededFault`](crate::error::DbSubnetGroupQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSubnetGroupQuotaExceededFault`](crate::error::DbSubnetGroupQuotaExceededFault)
        pub fn build(self) -> crate::error::DbSubnetGroupQuotaExceededFault {
            crate::error::DbSubnetGroupQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl DbSubnetGroupQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`DbSubnetGroupQuotaExceededFault`](crate::error::DbSubnetGroupQuotaExceededFault)
    pub fn builder() -> crate::error::db_subnet_group_quota_exceeded_fault::Builder {
        crate::error::db_subnet_group_quota_exceeded_fault::Builder::default()
    }
}

/// <p> <i>DBSubnetGroupName</i> is already used by an existing DB subnet group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSubnetGroupAlreadyExistsFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbSubnetGroupAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSubnetGroupAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbSubnetGroupAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbSubnetGroupAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbSubnetGroupAlreadyExistsFault [DBSubnetGroupAlreadyExistsFault]"
        )?;
        if let Some(inner_56) = &self.message {
            write!(f, ": {}", inner_56)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbSubnetGroupAlreadyExistsFault {}
/// See [`DbSubnetGroupAlreadyExistsFault`](crate::error::DbSubnetGroupAlreadyExistsFault)
pub mod db_subnet_group_already_exists_fault {
    /// A builder for [`DbSubnetGroupAlreadyExistsFault`](crate::error::DbSubnetGroupAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSubnetGroupAlreadyExistsFault`](crate::error::DbSubnetGroupAlreadyExistsFault)
        pub fn build(self) -> crate::error::DbSubnetGroupAlreadyExistsFault {
            crate::error::DbSubnetGroupAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl DbSubnetGroupAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`DbSubnetGroupAlreadyExistsFault`](crate::error::DbSubnetGroupAlreadyExistsFault)
    pub fn builder() -> crate::error::db_subnet_group_already_exists_fault::Builder {
        crate::error::db_subnet_group_already_exists_fault::Builder::default()
    }
}

/// <p>Request would result in user exceeding the allowed number of DB parameter groups.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbParameterGroupQuotaExceededFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbParameterGroupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbParameterGroupQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbParameterGroupQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbParameterGroupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbParameterGroupQuotaExceededFault [DBParameterGroupQuotaExceededFault]"
        )?;
        if let Some(inner_57) = &self.message {
            write!(f, ": {}", inner_57)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbParameterGroupQuotaExceededFault {}
/// See [`DbParameterGroupQuotaExceededFault`](crate::error::DbParameterGroupQuotaExceededFault)
pub mod db_parameter_group_quota_exceeded_fault {
    /// A builder for [`DbParameterGroupQuotaExceededFault`](crate::error::DbParameterGroupQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbParameterGroupQuotaExceededFault`](crate::error::DbParameterGroupQuotaExceededFault)
        pub fn build(self) -> crate::error::DbParameterGroupQuotaExceededFault {
            crate::error::DbParameterGroupQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl DbParameterGroupQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`DbParameterGroupQuotaExceededFault`](crate::error::DbParameterGroupQuotaExceededFault)
    pub fn builder() -> crate::error::db_parameter_group_quota_exceeded_fault::Builder {
        crate::error::db_parameter_group_quota_exceeded_fault::Builder::default()
    }
}

/// <p>A DB parameter group with the same name exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbParameterGroupAlreadyExistsFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbParameterGroupAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbParameterGroupAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbParameterGroupAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbParameterGroupAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbParameterGroupAlreadyExistsFault [DBParameterGroupAlreadyExistsFault]"
        )?;
        if let Some(inner_58) = &self.message {
            write!(f, ": {}", inner_58)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbParameterGroupAlreadyExistsFault {}
/// See [`DbParameterGroupAlreadyExistsFault`](crate::error::DbParameterGroupAlreadyExistsFault)
pub mod db_parameter_group_already_exists_fault {
    /// A builder for [`DbParameterGroupAlreadyExistsFault`](crate::error::DbParameterGroupAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbParameterGroupAlreadyExistsFault`](crate::error::DbParameterGroupAlreadyExistsFault)
        pub fn build(self) -> crate::error::DbParameterGroupAlreadyExistsFault {
            crate::error::DbParameterGroupAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl DbParameterGroupAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`DbParameterGroupAlreadyExistsFault`](crate::error::DbParameterGroupAlreadyExistsFault)
    pub fn builder() -> crate::error::db_parameter_group_already_exists_fault::Builder {
        crate::error::db_parameter_group_already_exists_fault::Builder::default()
    }
}

/// <p>Request would result in user exceeding the allowed number of DB instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceQuotaExceededFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InstanceQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InstanceQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InstanceQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InstanceQuotaExceededFault")?;
        if let Some(inner_59) = &self.message {
            write!(f, ": {}", inner_59)?;
        }
        Ok(())
    }
}
impl std::error::Error for InstanceQuotaExceededFault {}
/// See [`InstanceQuotaExceededFault`](crate::error::InstanceQuotaExceededFault)
pub mod instance_quota_exceeded_fault {
    /// A builder for [`InstanceQuotaExceededFault`](crate::error::InstanceQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceQuotaExceededFault`](crate::error::InstanceQuotaExceededFault)
        pub fn build(self) -> crate::error::InstanceQuotaExceededFault {
            crate::error::InstanceQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl InstanceQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`InstanceQuotaExceededFault`](crate::error::InstanceQuotaExceededFault)
    pub fn builder() -> crate::error::instance_quota_exceeded_fault::Builder {
        crate::error::instance_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The cluster already has the maximum number of custom endpoints.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterEndpointQuotaExceededFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterEndpointQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterEndpointQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbClusterEndpointQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbClusterEndpointQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbClusterEndpointQuotaExceededFault [DBClusterEndpointQuotaExceededFault]"
        )?;
        if let Some(inner_60) = &self.message {
            write!(f, ": {}", inner_60)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbClusterEndpointQuotaExceededFault {}
/// See [`DbClusterEndpointQuotaExceededFault`](crate::error::DbClusterEndpointQuotaExceededFault)
pub mod db_cluster_endpoint_quota_exceeded_fault {
    /// A builder for [`DbClusterEndpointQuotaExceededFault`](crate::error::DbClusterEndpointQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterEndpointQuotaExceededFault`](crate::error::DbClusterEndpointQuotaExceededFault)
        pub fn build(self) -> crate::error::DbClusterEndpointQuotaExceededFault {
            crate::error::DbClusterEndpointQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl DbClusterEndpointQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`DbClusterEndpointQuotaExceededFault`](crate::error::DbClusterEndpointQuotaExceededFault)
    pub fn builder() -> crate::error::db_cluster_endpoint_quota_exceeded_fault::Builder {
        crate::error::db_cluster_endpoint_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The specified custom endpoint cannot be created because it already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterEndpointAlreadyExistsFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterEndpointAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterEndpointAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbClusterEndpointAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbClusterEndpointAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbClusterEndpointAlreadyExistsFault [DBClusterEndpointAlreadyExistsFault]"
        )?;
        if let Some(inner_61) = &self.message {
            write!(f, ": {}", inner_61)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbClusterEndpointAlreadyExistsFault {}
/// See [`DbClusterEndpointAlreadyExistsFault`](crate::error::DbClusterEndpointAlreadyExistsFault)
pub mod db_cluster_endpoint_already_exists_fault {
    /// A builder for [`DbClusterEndpointAlreadyExistsFault`](crate::error::DbClusterEndpointAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterEndpointAlreadyExistsFault`](crate::error::DbClusterEndpointAlreadyExistsFault)
        pub fn build(self) -> crate::error::DbClusterEndpointAlreadyExistsFault {
            crate::error::DbClusterEndpointAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl DbClusterEndpointAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`DbClusterEndpointAlreadyExistsFault`](crate::error::DbClusterEndpointAlreadyExistsFault)
    pub fn builder() -> crate::error::db_cluster_endpoint_already_exists_fault::Builder {
        crate::error::db_cluster_endpoint_already_exists_fault::Builder::default()
    }
}

/// <p>You have exceeded the maximum number of IAM roles that can be associated with the specified DB cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterRoleQuotaExceededFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterRoleQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterRoleQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbClusterRoleQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbClusterRoleQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbClusterRoleQuotaExceededFault [DBClusterRoleQuotaExceededFault]"
        )?;
        if let Some(inner_62) = &self.message {
            write!(f, ": {}", inner_62)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbClusterRoleQuotaExceededFault {}
/// See [`DbClusterRoleQuotaExceededFault`](crate::error::DbClusterRoleQuotaExceededFault)
pub mod db_cluster_role_quota_exceeded_fault {
    /// A builder for [`DbClusterRoleQuotaExceededFault`](crate::error::DbClusterRoleQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterRoleQuotaExceededFault`](crate::error::DbClusterRoleQuotaExceededFault)
        pub fn build(self) -> crate::error::DbClusterRoleQuotaExceededFault {
            crate::error::DbClusterRoleQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl DbClusterRoleQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`DbClusterRoleQuotaExceededFault`](crate::error::DbClusterRoleQuotaExceededFault)
    pub fn builder() -> crate::error::db_cluster_role_quota_exceeded_fault::Builder {
        crate::error::db_cluster_role_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The specified IAM role Amazon Resource Name (ARN) is already associated with the specified DB cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterRoleAlreadyExistsFault {
    /// <p>A message describing the details of the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterRoleAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterRoleAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbClusterRoleAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbClusterRoleAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbClusterRoleAlreadyExistsFault [DBClusterRoleAlreadyExistsFault]"
        )?;
        if let Some(inner_63) = &self.message {
            write!(f, ": {}", inner_63)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbClusterRoleAlreadyExistsFault {}
/// See [`DbClusterRoleAlreadyExistsFault`](crate::error::DbClusterRoleAlreadyExistsFault)
pub mod db_cluster_role_already_exists_fault {
    /// A builder for [`DbClusterRoleAlreadyExistsFault`](crate::error::DbClusterRoleAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the details of the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the details of the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterRoleAlreadyExistsFault`](crate::error::DbClusterRoleAlreadyExistsFault)
        pub fn build(self) -> crate::error::DbClusterRoleAlreadyExistsFault {
            crate::error::DbClusterRoleAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl DbClusterRoleAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`DbClusterRoleAlreadyExistsFault`](crate::error::DbClusterRoleAlreadyExistsFault)
    pub fn builder() -> crate::error::db_cluster_role_already_exists_fault::Builder {
        crate::error::db_cluster_role_already_exists_fault::Builder::default()
    }
}
