// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Neptune
///
/// Client for invoking operations on Amazon Neptune. Each operation on Amazon Neptune is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_neptune::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_neptune::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_neptune::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddRoleToDBCluster`](crate::client::fluent_builders::AddRoleToDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::AddRoleToDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::AddRoleToDBCluster::set_db_cluster_identifier): <p>The name of the DB cluster to associate the IAM role with.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::AddRoleToDBCluster::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::AddRoleToDBCluster::set_role_arn): <p>The Amazon Resource Name (ARN) of the IAM role to associate with the Neptune DB cluster, for example <code>arn:aws:iam::123456789012:role/NeptuneAccessRole</code>.</p>
    ///   - [`feature_name(impl Into<String>)`](crate::client::fluent_builders::AddRoleToDBCluster::feature_name) / [`set_feature_name(Option<String>)`](crate::client::fluent_builders::AddRoleToDBCluster::set_feature_name): <p>The name of the feature for the Neptune DB cluster that the IAM role is to be associated with. For the list of supported feature names, see <a href="neptune/latest/userguide/api-other-apis.html#DBEngineVersion">DBEngineVersion</a>.</p>
    /// - On success, responds with [`AddRoleToDbClusterOutput`](crate::output::AddRoleToDbClusterOutput)

    /// - On failure, responds with [`SdkError<AddRoleToDBClusterError>`](crate::error::AddRoleToDBClusterError)
    pub fn add_role_to_db_cluster(&self) -> fluent_builders::AddRoleToDBCluster {
        fluent_builders::AddRoleToDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddSourceIdentifierToSubscription`](crate::client::fluent_builders::AddSourceIdentifierToSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::AddSourceIdentifierToSubscription::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::AddSourceIdentifierToSubscription::set_subscription_name): <p>The name of the event notification subscription you want to add a source identifier to.</p>
    ///   - [`source_identifier(impl Into<String>)`](crate::client::fluent_builders::AddSourceIdentifierToSubscription::source_identifier) / [`set_source_identifier(Option<String>)`](crate::client::fluent_builders::AddSourceIdentifierToSubscription::set_source_identifier): <p>The identifier of the event source to be added.</p>  <p>Constraints:</p>  <ul>   <li> <p>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be supplied.</p> </li>   <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be supplied.</p> </li>   <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must be supplied.</p> </li>   <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be supplied.</p> </li>  </ul>
    /// - On success, responds with [`AddSourceIdentifierToSubscriptionOutput`](crate::output::AddSourceIdentifierToSubscriptionOutput) with field(s):
    ///   - [`event_subscription(Option<EventSubscription>)`](crate::output::AddSourceIdentifierToSubscriptionOutput::event_subscription): <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    /// - On failure, responds with [`SdkError<AddSourceIdentifierToSubscriptionError>`](crate::error::AddSourceIdentifierToSubscriptionError)
    pub fn add_source_identifier_to_subscription(
        &self,
    ) -> fluent_builders::AddSourceIdentifierToSubscription {
        fluent_builders::AddSourceIdentifierToSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddTagsToResource`](crate::client::fluent_builders::AddTagsToResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_name(impl Into<String>)`](crate::client::fluent_builders::AddTagsToResource::resource_name) / [`set_resource_name(Option<String>)`](crate::client::fluent_builders::AddTagsToResource::set_resource_name): <p>The Amazon Neptune resource that the tags are added to. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::AddTagsToResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::AddTagsToResource::set_tags): <p>The tags to be assigned to the Amazon Neptune resource.</p>
    /// - On success, responds with [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)

    /// - On failure, responds with [`SdkError<AddTagsToResourceError>`](crate::error::AddTagsToResourceError)
    pub fn add_tags_to_resource(&self) -> fluent_builders::AddTagsToResource {
        fluent_builders::AddTagsToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ApplyPendingMaintenanceAction`](crate::client::fluent_builders::ApplyPendingMaintenanceAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_identifier(impl Into<String>)`](crate::client::fluent_builders::ApplyPendingMaintenanceAction::resource_identifier) / [`set_resource_identifier(Option<String>)`](crate::client::fluent_builders::ApplyPendingMaintenanceAction::set_resource_identifier): <p>The Amazon Resource Name (ARN) of the resource that the pending maintenance action applies to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>
    ///   - [`apply_action(impl Into<String>)`](crate::client::fluent_builders::ApplyPendingMaintenanceAction::apply_action) / [`set_apply_action(Option<String>)`](crate::client::fluent_builders::ApplyPendingMaintenanceAction::set_apply_action): <p>The pending maintenance action to apply to this resource.</p>  <p>Valid values: <code>system-update</code>, <code>db-upgrade</code> </p>
    ///   - [`opt_in_type(impl Into<String>)`](crate::client::fluent_builders::ApplyPendingMaintenanceAction::opt_in_type) / [`set_opt_in_type(Option<String>)`](crate::client::fluent_builders::ApplyPendingMaintenanceAction::set_opt_in_type): <p>A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type <code>immediate</code> can't be undone.</p>  <p>Valid values:</p>  <ul>   <li> <p> <code>immediate</code> - Apply the maintenance action immediately.</p> </li>   <li> <p> <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the resource.</p> </li>   <li> <p> <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.</p> </li>  </ul>
    /// - On success, responds with [`ApplyPendingMaintenanceActionOutput`](crate::output::ApplyPendingMaintenanceActionOutput) with field(s):
    ///   - [`resource_pending_maintenance_actions(Option<ResourcePendingMaintenanceActions>)`](crate::output::ApplyPendingMaintenanceActionOutput::resource_pending_maintenance_actions): <p>Describes the pending maintenance actions for a resource.</p>
    /// - On failure, responds with [`SdkError<ApplyPendingMaintenanceActionError>`](crate::error::ApplyPendingMaintenanceActionError)
    pub fn apply_pending_maintenance_action(
        &self,
    ) -> fluent_builders::ApplyPendingMaintenanceAction {
        fluent_builders::ApplyPendingMaintenanceAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CopyDBClusterParameterGroup`](crate::client::fluent_builders::CopyDBClusterParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_db_cluster_parameter_group_identifier(impl Into<String>)`](crate::client::fluent_builders::CopyDBClusterParameterGroup::source_db_cluster_parameter_group_identifier) / [`set_source_db_cluster_parameter_group_identifier(Option<String>)`](crate::client::fluent_builders::CopyDBClusterParameterGroup::set_source_db_cluster_parameter_group_identifier): <p>The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must specify a valid DB cluster parameter group.</p> </li>   <li> <p>If the source DB cluster parameter group is in the same Amazon Region as the copy, specify a valid DB parameter group identifier, for example <code>my-db-cluster-param-group</code>, or a valid ARN.</p> </li>   <li> <p>If the source DB parameter group is in a different Amazon Region than the copy, specify a valid DB cluster parameter group ARN, for example <code>arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1</code>.</p> </li>  </ul>
    ///   - [`target_db_cluster_parameter_group_identifier(impl Into<String>)`](crate::client::fluent_builders::CopyDBClusterParameterGroup::target_db_cluster_parameter_group_identifier) / [`set_target_db_cluster_parameter_group_identifier(Option<String>)`](crate::client::fluent_builders::CopyDBClusterParameterGroup::set_target_db_cluster_parameter_group_identifier): <p>The identifier for the copied DB cluster parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Cannot be null, empty, or blank</p> </li>   <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>  <p>Example: <code>my-cluster-param-group1</code> </p>
    ///   - [`target_db_cluster_parameter_group_description(impl Into<String>)`](crate::client::fluent_builders::CopyDBClusterParameterGroup::target_db_cluster_parameter_group_description) / [`set_target_db_cluster_parameter_group_description(Option<String>)`](crate::client::fluent_builders::CopyDBClusterParameterGroup::set_target_db_cluster_parameter_group_description): <p>A description for the copied DB cluster parameter group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CopyDBClusterParameterGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CopyDBClusterParameterGroup::set_tags): <p>The tags to be assigned to the copied DB cluster parameter group.</p>
    /// - On success, responds with [`CopyDbClusterParameterGroupOutput`](crate::output::CopyDbClusterParameterGroupOutput) with field(s):
    ///   - [`db_cluster_parameter_group(Option<DbClusterParameterGroup>)`](crate::output::CopyDbClusterParameterGroupOutput::db_cluster_parameter_group): <p>Contains the details of an Amazon Neptune DB cluster parameter group.</p>  <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.</p>
    /// - On failure, responds with [`SdkError<CopyDBClusterParameterGroupError>`](crate::error::CopyDBClusterParameterGroupError)
    pub fn copy_db_cluster_parameter_group(&self) -> fluent_builders::CopyDBClusterParameterGroup {
        fluent_builders::CopyDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CopyDBClusterSnapshot`](crate::client::fluent_builders::CopyDBClusterSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_db_cluster_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::source_db_cluster_snapshot_identifier) / [`set_source_db_cluster_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::set_source_db_cluster_snapshot_identifier): <p>The identifier of the DB cluster snapshot to copy. This parameter is not case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must specify a valid system snapshot in the "available" state.</p> </li>   <li> <p>Specify a valid DB snapshot identifier.</p> </li>  </ul>  <p>Example: <code>my-cluster-snapshot1</code> </p>
    ///   - [`target_db_cluster_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::target_db_cluster_snapshot_identifier) / [`set_target_db_cluster_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::set_target_db_cluster_snapshot_identifier): <p>The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter is not case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>  <p>Example: <code>my-cluster-snapshot2</code> </p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::set_kms_key_id): <p>The Amazon Amazon KMS key ID for an encrypted DB cluster snapshot. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.</p>  <p>If you copy an encrypted DB cluster snapshot from your Amazon account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new KMS encryption key. If you don't specify a value for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is encrypted with the same KMS key as the source DB cluster snapshot.</p>  <p>If you copy an encrypted DB cluster snapshot that is shared from another Amazon account, then you must specify a value for <code>KmsKeyId</code>.</p>  <p> KMS encryption keys are specific to the Amazon Region that they are created in, and you can't use encryption keys from one Amazon Region in another Amazon Region.</p>  <p>You cannot encrypt an unencrypted DB cluster snapshot when you copy it. If you try to copy an unencrypted DB cluster snapshot and specify a value for the KmsKeyId parameter, an error is returned.</p>
    ///   - [`pre_signed_url(impl Into<String>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::pre_signed_url) / [`set_pre_signed_url(Option<String>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::set_pre_signed_url): <p>Not currently supported.</p>
    ///   - [`copy_tags(bool)`](crate::client::fluent_builders::CopyDBClusterSnapshot::copy_tags) / [`set_copy_tags(Option<bool>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::set_copy_tags): <p>True to copy all tags from the source DB cluster snapshot to the target DB cluster snapshot, and otherwise false. The default is false.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::set_tags): <p>The tags to assign to the new DB cluster snapshot copy.</p>
    /// - On success, responds with [`CopyDbClusterSnapshotOutput`](crate::output::CopyDbClusterSnapshotOutput) with field(s):
    ///   - [`db_cluster_snapshot(Option<DbClusterSnapshot>)`](crate::output::CopyDbClusterSnapshotOutput::db_cluster_snapshot): <p>Contains the details for an Amazon Neptune DB cluster snapshot</p>  <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action.</p>
    /// - On failure, responds with [`SdkError<CopyDBClusterSnapshotError>`](crate::error::CopyDBClusterSnapshotError)
    pub fn copy_db_cluster_snapshot(&self) -> fluent_builders::CopyDBClusterSnapshot {
        fluent_builders::CopyDBClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CopyDBParameterGroup`](crate::client::fluent_builders::CopyDBParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_db_parameter_group_identifier(impl Into<String>)`](crate::client::fluent_builders::CopyDBParameterGroup::source_db_parameter_group_identifier) / [`set_source_db_parameter_group_identifier(Option<String>)`](crate::client::fluent_builders::CopyDBParameterGroup::set_source_db_parameter_group_identifier): <p>The identifier or ARN for the source DB parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must specify a valid DB parameter group.</p> </li>   <li> <p>Must specify a valid DB parameter group identifier, for example <code>my-db-param-group</code>, or a valid ARN.</p> </li>  </ul>
    ///   - [`target_db_parameter_group_identifier(impl Into<String>)`](crate::client::fluent_builders::CopyDBParameterGroup::target_db_parameter_group_identifier) / [`set_target_db_parameter_group_identifier(Option<String>)`](crate::client::fluent_builders::CopyDBParameterGroup::set_target_db_parameter_group_identifier): <p>The identifier for the copied DB parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Cannot be null, empty, or blank.</p> </li>   <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>  <p>Example: <code>my-db-parameter-group</code> </p>
    ///   - [`target_db_parameter_group_description(impl Into<String>)`](crate::client::fluent_builders::CopyDBParameterGroup::target_db_parameter_group_description) / [`set_target_db_parameter_group_description(Option<String>)`](crate::client::fluent_builders::CopyDBParameterGroup::set_target_db_parameter_group_description): <p>A description for the copied DB parameter group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CopyDBParameterGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CopyDBParameterGroup::set_tags): <p>The tags to be assigned to the copied DB parameter group.</p>
    /// - On success, responds with [`CopyDbParameterGroupOutput`](crate::output::CopyDbParameterGroupOutput) with field(s):
    ///   - [`db_parameter_group(Option<DbParameterGroup>)`](crate::output::CopyDbParameterGroupOutput::db_parameter_group): <p>Contains the details of an Amazon Neptune DB parameter group.</p>  <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.</p>
    /// - On failure, responds with [`SdkError<CopyDBParameterGroupError>`](crate::error::CopyDBParameterGroupError)
    pub fn copy_db_parameter_group(&self) -> fluent_builders::CopyDBParameterGroup {
        fluent_builders::CopyDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDBCluster`](crate::client::fluent_builders::CreateDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`availability_zones(Vec<String>)`](crate::client::fluent_builders::CreateDBCluster::availability_zones) / [`set_availability_zones(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBCluster::set_availability_zones): <p>A list of EC2 Availability Zones that instances in the DB cluster can be created in.</p>
    ///   - [`backup_retention_period(i32)`](crate::client::fluent_builders::CreateDBCluster::backup_retention_period) / [`set_backup_retention_period(Option<i32>)`](crate::client::fluent_builders::CreateDBCluster::set_backup_retention_period): <p>The number of days for which automated backups are retained. You must specify a minimum value of 1.</p>  <p>Default: 1</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be a value from 1 to 35</p> </li>  </ul>
    ///   - [`character_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::character_set_name) / [`set_character_set_name(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_character_set_name): <p> <i>(Not supported by Neptune)</i> </p>
    ///   - [`copy_tags_to_snapshot(bool)`](crate::client::fluent_builders::CreateDBCluster::copy_tags_to_snapshot) / [`set_copy_tags_to_snapshot(Option<bool>)`](crate::client::fluent_builders::CreateDBCluster::set_copy_tags_to_snapshot): <p> <i>If set to <code>true</code>, tags are copied to any snapshot of the DB cluster that is created.</i> </p>
    ///   - [`database_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::database_name) / [`set_database_name(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_database_name): <p>The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon Neptune will not create a database in the DB cluster you are creating.</p>
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_db_cluster_identifier): <p>The DB cluster identifier. This parameter is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>  <p>Example: <code>my-cluster1</code> </p>
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_db_cluster_parameter_group_name): <p> The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted, the default is used.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>  </ul>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateDBCluster::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBCluster::set_vpc_security_group_ids): <p>A list of EC2 VPC security groups to associate with this DB cluster.</p>
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_db_subnet_group_name): <p>A DB subnet group to associate with this DB cluster.</p>  <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>  <p>Example: <code>mySubnetgroup</code> </p>
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_engine): <p>The name of the database engine to be used for this DB cluster.</p>  <p>Valid Values: <code>neptune</code> </p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_engine_version): <p>The version number of the database engine to use for the new DB cluster.</p>  <p>Example: <code>1.0.2.1</code> </p>
    ///   - [`port(i32)`](crate::client::fluent_builders::CreateDBCluster::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::CreateDBCluster::set_port): <p>The port number on which the instances in the DB cluster accept connections.</p>  <p> Default: <code>8182</code> </p>
    ///   - [`master_username(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::master_username) / [`set_master_username(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_master_username): <p>Not supported by Neptune.</p>
    ///   - [`master_user_password(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::master_user_password) / [`set_master_user_password(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_master_user_password): <p>Not supported by Neptune.</p>
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_option_group_name): <p> <i>(Not supported by Neptune)</i> </p>
    ///   - [`preferred_backup_window(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::preferred_backup_window) / [`set_preferred_backup_window(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_preferred_backup_window): <p>The daily time range during which automated backups are created if automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter.</p>  <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred Maintenance Window</a> in the <i>Amazon Neptune User Guide.</i> </p>  <p>Constraints:</p>  <ul>   <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>   <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>   <li> <p>Must not conflict with the preferred maintenance window.</p> </li>   <li> <p>Must be at least 30 minutes.</p> </li>  </ul>
    ///   - [`preferred_maintenance_window(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::preferred_maintenance_window) / [`set_preferred_maintenance_window(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_preferred_maintenance_window): <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>  <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>  <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred Maintenance Window</a> in the <i>Amazon Neptune User Guide.</i> </p>  <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>  <p>Constraints: Minimum 30-minute window.</p>
    ///   - [`replication_source_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::replication_source_identifier) / [`set_replication_source_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_replication_source_identifier): <p>The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a Read Replica.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDBCluster::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDBCluster::set_tags): <p>The tags to assign to the new DB cluster.</p>
    ///   - [`storage_encrypted(bool)`](crate::client::fluent_builders::CreateDBCluster::storage_encrypted) / [`set_storage_encrypted(Option<bool>)`](crate::client::fluent_builders::CreateDBCluster::set_storage_encrypted): <p>Specifies whether the DB cluster is encrypted.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_kms_key_id): <p>The Amazon KMS key identifier for an encrypted DB cluster.</p>  <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>  <p>If an encryption key is not specified in <code>KmsKeyId</code>:</p>  <ul>   <li> <p>If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then Amazon Neptune will use the encryption key used to encrypt the source. Otherwise, Amazon Neptune will use your default encryption key.</p> </li>   <li> <p>If the <code>StorageEncrypted</code> parameter is true and <code>ReplicationSourceIdentifier</code> is not specified, then Amazon Neptune will use your default encryption key.</p> </li>  </ul>  <p>Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a different default encryption key for each Amazon Region.</p>  <p>If you create a Read Replica of an encrypted DB cluster in another Amazon Region, you must set <code>KmsKeyId</code> to a KMS key ID that is valid in the destination Amazon Region. This key is used to encrypt the Read Replica in that Amazon Region.</p>
    ///   - [`pre_signed_url(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::pre_signed_url) / [`set_pre_signed_url(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_pre_signed_url): <p>This parameter is not currently supported.</p>
    ///   - [`enable_iam_database_authentication(bool)`](crate::client::fluent_builders::CreateDBCluster::enable_iam_database_authentication) / [`set_enable_iam_database_authentication(Option<bool>)`](crate::client::fluent_builders::CreateDBCluster::set_enable_iam_database_authentication): <p>If set to <code>true</code>, enables Amazon Identity and Access Management (IAM) authentication for the entire DB cluster (this cannot be set at an instance level).</p>  <p>Default: <code>false</code>.</p>
    ///   - [`enable_cloudwatch_logs_exports(Vec<String>)`](crate::client::fluent_builders::CreateDBCluster::enable_cloudwatch_logs_exports) / [`set_enable_cloudwatch_logs_exports(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBCluster::set_enable_cloudwatch_logs_exports): <p>The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::CreateDBCluster::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::CreateDBCluster::set_deletion_protection): <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is enabled.</p>
    /// - On success, responds with [`CreateDbClusterOutput`](crate::output::CreateDbClusterOutput) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::CreateDbClusterOutput::db_cluster): <p>Contains the details of an Amazon Neptune DB cluster.</p>  <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    /// - On failure, responds with [`SdkError<CreateDBClusterError>`](crate::error::CreateDBClusterError)
    pub fn create_db_cluster(&self) -> fluent_builders::CreateDBCluster {
        fluent_builders::CreateDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDBClusterEndpoint`](crate::client::fluent_builders::CreateDBClusterEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::set_db_cluster_identifier): <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
    ///   - [`db_cluster_endpoint_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::db_cluster_endpoint_identifier) / [`set_db_cluster_endpoint_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::set_db_cluster_endpoint_identifier): <p>The identifier to use for the new endpoint. This parameter is stored as a lowercase string.</p>
    ///   - [`endpoint_type(impl Into<String>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::endpoint_type) / [`set_endpoint_type(Option<String>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::set_endpoint_type): <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    ///   - [`static_members(Vec<String>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::static_members) / [`set_static_members(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::set_static_members): <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    ///   - [`excluded_members(Vec<String>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::excluded_members) / [`set_excluded_members(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::set_excluded_members): <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::set_tags): <p>The tags to be assigned to the Amazon Neptune resource.</p>
    /// - On success, responds with [`CreateDbClusterEndpointOutput`](crate::output::CreateDbClusterEndpointOutput) with field(s):
    ///   - [`db_cluster_endpoint_identifier(Option<String>)`](crate::output::CreateDbClusterEndpointOutput::db_cluster_endpoint_identifier): <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    ///   - [`db_cluster_identifier(Option<String>)`](crate::output::CreateDbClusterEndpointOutput::db_cluster_identifier): <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
    ///   - [`db_cluster_endpoint_resource_identifier(Option<String>)`](crate::output::CreateDbClusterEndpointOutput::db_cluster_endpoint_resource_identifier): <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    ///   - [`endpoint(Option<String>)`](crate::output::CreateDbClusterEndpointOutput::endpoint): <p>The DNS address of the endpoint.</p>
    ///   - [`status(Option<String>)`](crate::output::CreateDbClusterEndpointOutput::status): <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    ///   - [`endpoint_type(Option<String>)`](crate::output::CreateDbClusterEndpointOutput::endpoint_type): <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    ///   - [`custom_endpoint_type(Option<String>)`](crate::output::CreateDbClusterEndpointOutput::custom_endpoint_type): <p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    ///   - [`static_members(Option<Vec<String>>)`](crate::output::CreateDbClusterEndpointOutput::static_members): <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    ///   - [`excluded_members(Option<Vec<String>>)`](crate::output::CreateDbClusterEndpointOutput::excluded_members): <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
    ///   - [`db_cluster_endpoint_arn(Option<String>)`](crate::output::CreateDbClusterEndpointOutput::db_cluster_endpoint_arn): <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    /// - On failure, responds with [`SdkError<CreateDBClusterEndpointError>`](crate::error::CreateDBClusterEndpointError)
    pub fn create_db_cluster_endpoint(&self) -> fluent_builders::CreateDBClusterEndpoint {
        fluent_builders::CreateDBClusterEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDBClusterParameterGroup`](crate::client::fluent_builders::CreateDBClusterParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBClusterParameterGroup::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBClusterParameterGroup::set_db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the name of an existing DBClusterParameterGroup.</p> </li>  </ul> <note>   <p>This value is stored as a lowercase string.</p>  </note>
    ///   - [`db_parameter_group_family(impl Into<String>)`](crate::client::fluent_builders::CreateDBClusterParameterGroup::db_parameter_group_family) / [`set_db_parameter_group_family(Option<String>)`](crate::client::fluent_builders::CreateDBClusterParameterGroup::set_db_parameter_group_family): <p>The DB cluster parameter group family name. A DB cluster parameter group can be associated with one and only one DB cluster parameter group family, and can be applied only to a DB cluster running a database engine and engine version compatible with that DB cluster parameter group family.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateDBClusterParameterGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateDBClusterParameterGroup::set_description): <p>The description for the DB cluster parameter group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDBClusterParameterGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDBClusterParameterGroup::set_tags): <p>The tags to be assigned to the new DB cluster parameter group.</p>
    /// - On success, responds with [`CreateDbClusterParameterGroupOutput`](crate::output::CreateDbClusterParameterGroupOutput) with field(s):
    ///   - [`db_cluster_parameter_group(Option<DbClusterParameterGroup>)`](crate::output::CreateDbClusterParameterGroupOutput::db_cluster_parameter_group): <p>Contains the details of an Amazon Neptune DB cluster parameter group.</p>  <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.</p>
    /// - On failure, responds with [`SdkError<CreateDBClusterParameterGroupError>`](crate::error::CreateDBClusterParameterGroupError)
    pub fn create_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::CreateDBClusterParameterGroup {
        fluent_builders::CreateDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDBClusterSnapshot`](crate::client::fluent_builders::CreateDBClusterSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBClusterSnapshot::db_cluster_snapshot_identifier) / [`set_db_cluster_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBClusterSnapshot::set_db_cluster_snapshot_identifier): <p>The identifier of the DB cluster snapshot. This parameter is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>  <p>Example: <code>my-cluster1-snapshot1</code> </p>
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBClusterSnapshot::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBClusterSnapshot::set_db_cluster_identifier): <p>The identifier of the DB cluster to create a snapshot for. This parameter is not case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing DBCluster.</p> </li>  </ul>  <p>Example: <code>my-cluster1</code> </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDBClusterSnapshot::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDBClusterSnapshot::set_tags): <p>The tags to be assigned to the DB cluster snapshot.</p>
    /// - On success, responds with [`CreateDbClusterSnapshotOutput`](crate::output::CreateDbClusterSnapshotOutput) with field(s):
    ///   - [`db_cluster_snapshot(Option<DbClusterSnapshot>)`](crate::output::CreateDbClusterSnapshotOutput::db_cluster_snapshot): <p>Contains the details for an Amazon Neptune DB cluster snapshot</p>  <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action.</p>
    /// - On failure, responds with [`SdkError<CreateDBClusterSnapshotError>`](crate::error::CreateDBClusterSnapshotError)
    pub fn create_db_cluster_snapshot(&self) -> fluent_builders::CreateDBClusterSnapshot {
        fluent_builders::CreateDBClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDBInstance`](crate::client::fluent_builders::CreateDBInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::db_name) / [`set_db_name(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_db_name): <p>Not supported.</p>
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_db_instance_identifier): <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>  <p>Example: <code>mydbinstance</code> </p>
    ///   - [`allocated_storage(i32)`](crate::client::fluent_builders::CreateDBInstance::allocated_storage) / [`set_allocated_storage(Option<i32>)`](crate::client::fluent_builders::CreateDBInstance::set_allocated_storage): <p>Not supported by Neptune.</p>
    ///   - [`db_instance_class(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::db_instance_class) / [`set_db_instance_class(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_db_instance_class): <p>The compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>. Not all DB instance classes are available in all Amazon Regions.</p>
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_engine): <p>The name of the database engine to be used for this instance.</p>  <p>Valid Values: <code>neptune</code> </p>
    ///   - [`master_username(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::master_username) / [`set_master_username(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_master_username): <p>Not supported by Neptune.</p>
    ///   - [`master_user_password(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::master_user_password) / [`set_master_user_password(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_master_user_password): <p>Not supported by Neptune.</p>
    ///   - [`db_security_groups(Vec<String>)`](crate::client::fluent_builders::CreateDBInstance::db_security_groups) / [`set_db_security_groups(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBInstance::set_db_security_groups): <p>A list of DB security groups to associate with this DB instance.</p>  <p>Default: The default DB security group for the database engine.</p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateDBInstance::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBInstance::set_vpc_security_group_ids): <p>A list of EC2 VPC security groups to associate with this DB instance.</p>  <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>  <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_availability_zone): <p> The EC2 Availability Zone that the DB instance is created in</p>  <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Region.</p>  <p> Example: <code>us-east-1d</code> </p>  <p> Constraint: The AvailabilityZone parameter can't be specified if the MultiAZ parameter is set to <code>true</code>. The specified Availability Zone must be in the same Amazon Region as the current endpoint.</p>
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_db_subnet_group_name): <p>A DB subnet group to associate with this DB instance.</p>  <p>If there is no DB subnet group, then it is a non-VPC DB instance.</p>
    ///   - [`preferred_maintenance_window(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::preferred_maintenance_window) / [`set_preferred_maintenance_window(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_preferred_maintenance_window): <p>The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>  <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>  <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week.</p>  <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>  <p>Constraints: Minimum 30-minute window.</p>
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_db_parameter_group_name): <p>The name of the DB parameter group to associate with this DB instance. If this argument is omitted, the default DBParameterGroup for the specified engine is used.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>
    ///   - [`backup_retention_period(i32)`](crate::client::fluent_builders::CreateDBInstance::backup_retention_period) / [`set_backup_retention_period(Option<i32>)`](crate::client::fluent_builders::CreateDBInstance::set_backup_retention_period): <p>The number of days for which automated backups are retained.</p>  <p>Not applicable. The retention period for automated backups is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>  <p>Default: 1</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be a value from 0 to 35</p> </li>   <li> <p>Cannot be set to 0 if the DB instance is a source to Read Replicas</p> </li>  </ul>
    ///   - [`preferred_backup_window(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::preferred_backup_window) / [`set_preferred_backup_window(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_preferred_backup_window): <p> The daily time range during which automated backups are created.</p>  <p>Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
    ///   - [`port(i32)`](crate::client::fluent_builders::CreateDBInstance::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::CreateDBInstance::set_port): <p>The port number on which the database accepts connections.</p>  <p>Not applicable. The port is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>  <p> Default: <code>8182</code> </p>  <p>Type: Integer</p>
    ///   - [`multi_az(bool)`](crate::client::fluent_builders::CreateDBInstance::multi_az) / [`set_multi_az(Option<bool>)`](crate::client::fluent_builders::CreateDBInstance::set_multi_az): <p>Specifies if the DB instance is a Multi-AZ deployment. You can't set the AvailabilityZone parameter if the MultiAZ parameter is set to true.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_engine_version): <p>The version number of the database engine to use. Currently, setting this parameter has no effect.</p>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::CreateDBInstance::auto_minor_version_upgrade) / [`set_auto_minor_version_upgrade(Option<bool>)`](crate::client::fluent_builders::CreateDBInstance::set_auto_minor_version_upgrade): <p>Indicates that minor engine upgrades are applied automatically to the DB instance during the maintenance window.</p>  <p>Default: <code>true</code> </p>
    ///   - [`license_model(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::license_model) / [`set_license_model(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_license_model): <p>License model information for this DB instance.</p>  <p> Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code> </p>
    ///   - [`iops(i32)`](crate::client::fluent_builders::CreateDBInstance::iops) / [`set_iops(Option<i32>)`](crate::client::fluent_builders::CreateDBInstance::set_iops): <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance.</p>
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_option_group_name): <p> <i>(Not supported by Neptune)</i> </p>
    ///   - [`character_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::character_set_name) / [`set_character_set_name(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_character_set_name): <p> <i>(Not supported by Neptune)</i> </p>
    ///   - [`publicly_accessible(bool)`](crate::client::fluent_builders::CreateDBInstance::publicly_accessible) / [`set_publicly_accessible(Option<bool>)`](crate::client::fluent_builders::CreateDBInstance::set_publicly_accessible): <p>This flag should no longer be used.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDBInstance::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDBInstance::set_tags): <p>The tags to assign to the new instance.</p>
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_db_cluster_identifier): <p>The identifier of the DB cluster that the instance will belong to.</p>  <p>For information on creating a DB cluster, see <code>CreateDBCluster</code>.</p>  <p>Type: String</p>
    ///   - [`storage_type(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::storage_type) / [`set_storage_type(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_storage_type): <p>Specifies the storage type to be associated with the DB instance.</p>  <p>Not applicable. Storage is managed by the DB Cluster.</p>
    ///   - [`tde_credential_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::tde_credential_arn) / [`set_tde_credential_arn(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_tde_credential_arn): <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
    ///   - [`tde_credential_password(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::tde_credential_password) / [`set_tde_credential_password(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_tde_credential_password): <p>The password for the given ARN from the key store in order to access the device.</p>
    ///   - [`storage_encrypted(bool)`](crate::client::fluent_builders::CreateDBInstance::storage_encrypted) / [`set_storage_encrypted(Option<bool>)`](crate::client::fluent_builders::CreateDBInstance::set_storage_encrypted): <p>Specifies whether the DB instance is encrypted.</p>  <p>Not applicable. The encryption for DB instances is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>  <p>Default: false</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_kms_key_id): <p>The Amazon KMS key identifier for an encrypted DB instance.</p>  <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a DB instance with the same Amazon account that owns the KMS encryption key used to encrypt the new DB instance, then you can use the KMS key alias instead of the ARN for the KM encryption key.</p>  <p>Not applicable. The KMS key identifier is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>  <p>If the <code>StorageEncrypted</code> parameter is true, and you do not specify a value for the <code>KmsKeyId</code> parameter, then Amazon Neptune will use your default encryption key. Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a different default encryption key for each Amazon Region.</p>
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_domain): <p>Specify the Active Directory Domain to create the instance in.</p>
    ///   - [`copy_tags_to_snapshot(bool)`](crate::client::fluent_builders::CreateDBInstance::copy_tags_to_snapshot) / [`set_copy_tags_to_snapshot(Option<bool>)`](crate::client::fluent_builders::CreateDBInstance::set_copy_tags_to_snapshot): <p>True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise false. The default is false.</p>
    ///   - [`monitoring_interval(i32)`](crate::client::fluent_builders::CreateDBInstance::monitoring_interval) / [`set_monitoring_interval(Option<i32>)`](crate::client::fluent_builders::CreateDBInstance::set_monitoring_interval): <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p>  <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0.</p>  <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
    ///   - [`monitoring_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::monitoring_role_arn) / [`set_monitoring_role_arn(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_monitoring_role_arn): <p>The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>  <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>
    ///   - [`domain_iam_role_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::domain_iam_role_name) / [`set_domain_iam_role_name(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_domain_iam_role_name): <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
    ///   - [`promotion_tier(i32)`](crate::client::fluent_builders::CreateDBInstance::promotion_tier) / [`set_promotion_tier(Option<i32>)`](crate::client::fluent_builders::CreateDBInstance::set_promotion_tier): <p>A value that specifies the order in which an Read Replica is promoted to the primary instance after a failure of the existing primary instance. </p>  <p>Default: 1</p>  <p>Valid Values: 0 - 15</p>
    ///   - [`timezone(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::timezone) / [`set_timezone(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_timezone): <p>The time zone of the DB instance.</p>
    ///   - [`enable_iam_database_authentication(bool)`](crate::client::fluent_builders::CreateDBInstance::enable_iam_database_authentication) / [`set_enable_iam_database_authentication(Option<bool>)`](crate::client::fluent_builders::CreateDBInstance::set_enable_iam_database_authentication): <p>Not supported by Neptune (ignored).</p>
    ///   - [`enable_performance_insights(bool)`](crate::client::fluent_builders::CreateDBInstance::enable_performance_insights) / [`set_enable_performance_insights(Option<bool>)`](crate::client::fluent_builders::CreateDBInstance::set_enable_performance_insights): <p> <i>(Not supported by Neptune)</i> </p>
    ///   - [`performance_insights_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::performance_insights_kms_key_id) / [`set_performance_insights_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_performance_insights_kms_key_id): <p> <i>(Not supported by Neptune)</i> </p>
    ///   - [`enable_cloudwatch_logs_exports(Vec<String>)`](crate::client::fluent_builders::CreateDBInstance::enable_cloudwatch_logs_exports) / [`set_enable_cloudwatch_logs_exports(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBInstance::set_enable_cloudwatch_logs_exports): <p>The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::CreateDBInstance::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::CreateDBInstance::set_deletion_protection): <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting a DB Instance</a>.</p>  <p>DB instances in a DB cluster can be deleted even when deletion protection is enabled in their parent DB cluster.</p>
    /// - On success, responds with [`CreateDbInstanceOutput`](crate::output::CreateDbInstanceOutput) with field(s):
    ///   - [`db_instance(Option<DbInstance>)`](crate::output::CreateDbInstanceOutput::db_instance): <p>Contains the details of an Amazon Neptune DB instance.</p>  <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
    /// - On failure, responds with [`SdkError<CreateDBInstanceError>`](crate::error::CreateDBInstanceError)
    pub fn create_db_instance(&self) -> fluent_builders::CreateDBInstance {
        fluent_builders::CreateDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDBParameterGroup`](crate::client::fluent_builders::CreateDBParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBParameterGroup::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBParameterGroup::set_db_parameter_group_name): <p>The name of the DB parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>  </ul> <note>   <p>This value is stored as a lowercase string.</p>  </note>
    ///   - [`db_parameter_group_family(impl Into<String>)`](crate::client::fluent_builders::CreateDBParameterGroup::db_parameter_group_family) / [`set_db_parameter_group_family(Option<String>)`](crate::client::fluent_builders::CreateDBParameterGroup::set_db_parameter_group_family): <p>The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateDBParameterGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateDBParameterGroup::set_description): <p>The description for the DB parameter group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDBParameterGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDBParameterGroup::set_tags): <p>The tags to be assigned to the new DB parameter group.</p>
    /// - On success, responds with [`CreateDbParameterGroupOutput`](crate::output::CreateDbParameterGroupOutput) with field(s):
    ///   - [`db_parameter_group(Option<DbParameterGroup>)`](crate::output::CreateDbParameterGroupOutput::db_parameter_group): <p>Contains the details of an Amazon Neptune DB parameter group.</p>  <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.</p>
    /// - On failure, responds with [`SdkError<CreateDBParameterGroupError>`](crate::error::CreateDBParameterGroupError)
    pub fn create_db_parameter_group(&self) -> fluent_builders::CreateDBParameterGroup {
        fluent_builders::CreateDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDBSubnetGroup`](crate::client::fluent_builders::CreateDBSubnetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBSubnetGroup::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBSubnetGroup::set_db_subnet_group_name): <p>The name for the DB subnet group. This value is stored as a lowercase string.</p>  <p>Constraints: Must contain no more than 255 letters, numbers, periods, underscores, spaces, or hyphens. Must not be default.</p>  <p>Example: <code>mySubnetgroup</code> </p>
    ///   - [`db_subnet_group_description(impl Into<String>)`](crate::client::fluent_builders::CreateDBSubnetGroup::db_subnet_group_description) / [`set_db_subnet_group_description(Option<String>)`](crate::client::fluent_builders::CreateDBSubnetGroup::set_db_subnet_group_description): <p>The description for the DB subnet group.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::CreateDBSubnetGroup::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBSubnetGroup::set_subnet_ids): <p>The EC2 Subnet IDs for the DB subnet group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDBSubnetGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDBSubnetGroup::set_tags): <p>The tags to be assigned to the new DB subnet group.</p>
    /// - On success, responds with [`CreateDbSubnetGroupOutput`](crate::output::CreateDbSubnetGroupOutput) with field(s):
    ///   - [`db_subnet_group(Option<DbSubnetGroup>)`](crate::output::CreateDbSubnetGroupOutput::db_subnet_group): <p>Contains the details of an Amazon Neptune DB subnet group.</p>  <p>This data type is used as a response element in the <code>DescribeDBSubnetGroups</code> action.</p>
    /// - On failure, responds with [`SdkError<CreateDBSubnetGroupError>`](crate::error::CreateDBSubnetGroupError)
    pub fn create_db_subnet_group(&self) -> fluent_builders::CreateDBSubnetGroup {
        fluent_builders::CreateDBSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEventSubscription`](crate::client::fluent_builders::CreateEventSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::CreateEventSubscription::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::CreateEventSubscription::set_subscription_name): <p>The name of the subscription.</p>  <p>Constraints: The name must be less than 255 characters.</p>
    ///   - [`sns_topic_arn(impl Into<String>)`](crate::client::fluent_builders::CreateEventSubscription::sns_topic_arn) / [`set_sns_topic_arn(Option<String>)`](crate::client::fluent_builders::CreateEventSubscription::set_sns_topic_arn): <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
    ///   - [`source_type(impl Into<String>)`](crate::client::fluent_builders::CreateEventSubscription::source_type) / [`set_source_type(Option<String>)`](crate::client::fluent_builders::CreateEventSubscription::set_source_type): <p>The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you would set this parameter to db-instance. if this value is not specified, all events are returned.</p>  <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> </p>
    ///   - [`event_categories(Vec<String>)`](crate::client::fluent_builders::CreateEventSubscription::event_categories) / [`set_event_categories(Option<Vec<String>>)`](crate::client::fluent_builders::CreateEventSubscription::set_event_categories): <p> A list of event categories for a SourceType that you want to subscribe to. You can see a list of the categories for a given SourceType by using the <b>DescribeEventCategories</b> action.</p>
    ///   - [`source_ids(Vec<String>)`](crate::client::fluent_builders::CreateEventSubscription::source_ids) / [`set_source_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateEventSubscription::set_source_ids): <p>The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>  <p>Constraints:</p>  <ul>   <li> <p>If SourceIds are supplied, SourceType must also be provided.</p> </li>   <li> <p>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be supplied.</p> </li>   <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be supplied.</p> </li>   <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must be supplied.</p> </li>   <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be supplied.</p> </li>  </ul>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::CreateEventSubscription::enabled) / [`set_enabled(Option<bool>)`](crate::client::fluent_builders::CreateEventSubscription::set_enabled): <p> A Boolean value; set to <b>true</b> to activate the subscription, set to <b>false</b> to create the subscription but not active it.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateEventSubscription::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateEventSubscription::set_tags): <p>The tags to be applied to the new event subscription.</p>
    /// - On success, responds with [`CreateEventSubscriptionOutput`](crate::output::CreateEventSubscriptionOutput) with field(s):
    ///   - [`event_subscription(Option<EventSubscription>)`](crate::output::CreateEventSubscriptionOutput::event_subscription): <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    /// - On failure, responds with [`SdkError<CreateEventSubscriptionError>`](crate::error::CreateEventSubscriptionError)
    pub fn create_event_subscription(&self) -> fluent_builders::CreateEventSubscription {
        fluent_builders::CreateEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDBCluster`](crate::client::fluent_builders::DeleteDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DeleteDBCluster::set_db_cluster_identifier): <p>The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match an existing DBClusterIdentifier.</p> </li>  </ul>
    ///   - [`skip_final_snapshot(bool)`](crate::client::fluent_builders::DeleteDBCluster::skip_final_snapshot) / [`set_skip_final_snapshot(bool)`](crate::client::fluent_builders::DeleteDBCluster::set_skip_final_snapshot): <p> Determines whether a final DB cluster snapshot is created before the DB cluster is deleted. If <code>true</code> is specified, no DB cluster snapshot is created. If <code>false</code> is specified, a DB cluster snapshot is created before the DB cluster is deleted.</p> <note>   <p>You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if <code>SkipFinalSnapshot</code> is <code>false</code>.</p>  </note>  <p>Default: <code>false</code> </p>
    ///   - [`final_db_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteDBCluster::final_db_snapshot_identifier) / [`set_final_db_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::DeleteDBCluster::set_final_db_snapshot_identifier): <p> The DB cluster snapshot identifier of the new DB cluster snapshot created when <code>SkipFinalSnapshot</code> is set to <code>false</code>.</p> <note>   <p> Specifying this parameter and also setting the <code>SkipFinalShapshot</code> parameter to true results in an error.</p>  </note>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>
    /// - On success, responds with [`DeleteDbClusterOutput`](crate::output::DeleteDbClusterOutput) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::DeleteDbClusterOutput::db_cluster): <p>Contains the details of an Amazon Neptune DB cluster.</p>  <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    /// - On failure, responds with [`SdkError<DeleteDBClusterError>`](crate::error::DeleteDBClusterError)
    pub fn delete_db_cluster(&self) -> fluent_builders::DeleteDBCluster {
        fluent_builders::DeleteDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDBClusterEndpoint`](crate::client::fluent_builders::DeleteDBClusterEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_endpoint_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteDBClusterEndpoint::db_cluster_endpoint_identifier) / [`set_db_cluster_endpoint_identifier(Option<String>)`](crate::client::fluent_builders::DeleteDBClusterEndpoint::set_db_cluster_endpoint_identifier): <p>The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.</p>
    /// - On success, responds with [`DeleteDbClusterEndpointOutput`](crate::output::DeleteDbClusterEndpointOutput) with field(s):
    ///   - [`db_cluster_endpoint_identifier(Option<String>)`](crate::output::DeleteDbClusterEndpointOutput::db_cluster_endpoint_identifier): <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    ///   - [`db_cluster_identifier(Option<String>)`](crate::output::DeleteDbClusterEndpointOutput::db_cluster_identifier): <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
    ///   - [`db_cluster_endpoint_resource_identifier(Option<String>)`](crate::output::DeleteDbClusterEndpointOutput::db_cluster_endpoint_resource_identifier): <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    ///   - [`endpoint(Option<String>)`](crate::output::DeleteDbClusterEndpointOutput::endpoint): <p>The DNS address of the endpoint.</p>
    ///   - [`status(Option<String>)`](crate::output::DeleteDbClusterEndpointOutput::status): <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    ///   - [`endpoint_type(Option<String>)`](crate::output::DeleteDbClusterEndpointOutput::endpoint_type): <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    ///   - [`custom_endpoint_type(Option<String>)`](crate::output::DeleteDbClusterEndpointOutput::custom_endpoint_type): <p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    ///   - [`static_members(Option<Vec<String>>)`](crate::output::DeleteDbClusterEndpointOutput::static_members): <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    ///   - [`excluded_members(Option<Vec<String>>)`](crate::output::DeleteDbClusterEndpointOutput::excluded_members): <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
    ///   - [`db_cluster_endpoint_arn(Option<String>)`](crate::output::DeleteDbClusterEndpointOutput::db_cluster_endpoint_arn): <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    /// - On failure, responds with [`SdkError<DeleteDBClusterEndpointError>`](crate::error::DeleteDBClusterEndpointError)
    pub fn delete_db_cluster_endpoint(&self) -> fluent_builders::DeleteDBClusterEndpoint {
        fluent_builders::DeleteDBClusterEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDBClusterParameterGroup`](crate::client::fluent_builders::DeleteDBClusterParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDBClusterParameterGroup::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DeleteDBClusterParameterGroup::set_db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be the name of an existing DB cluster parameter group.</p> </li>   <li> <p>You can't delete a default DB cluster parameter group.</p> </li>   <li> <p>Cannot be associated with any DB clusters.</p> </li>  </ul>
    /// - On success, responds with [`DeleteDbClusterParameterGroupOutput`](crate::output::DeleteDbClusterParameterGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteDBClusterParameterGroupError>`](crate::error::DeleteDBClusterParameterGroupError)
    pub fn delete_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::DeleteDBClusterParameterGroup {
        fluent_builders::DeleteDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDBClusterSnapshot`](crate::client::fluent_builders::DeleteDBClusterSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteDBClusterSnapshot::db_cluster_snapshot_identifier) / [`set_db_cluster_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::DeleteDBClusterSnapshot::set_db_cluster_snapshot_identifier): <p>The identifier of the DB cluster snapshot to delete.</p>  <p>Constraints: Must be the name of an existing DB cluster snapshot in the <code>available</code> state.</p>
    /// - On success, responds with [`DeleteDbClusterSnapshotOutput`](crate::output::DeleteDbClusterSnapshotOutput) with field(s):
    ///   - [`db_cluster_snapshot(Option<DbClusterSnapshot>)`](crate::output::DeleteDbClusterSnapshotOutput::db_cluster_snapshot): <p>Contains the details for an Amazon Neptune DB cluster snapshot</p>  <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action.</p>
    /// - On failure, responds with [`SdkError<DeleteDBClusterSnapshotError>`](crate::error::DeleteDBClusterSnapshotError)
    pub fn delete_db_cluster_snapshot(&self) -> fluent_builders::DeleteDBClusterSnapshot {
        fluent_builders::DeleteDBClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDBInstance`](crate::client::fluent_builders::DeleteDBInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteDBInstance::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::DeleteDBInstance::set_db_instance_identifier): <p>The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the name of an existing DB instance.</p> </li>  </ul>
    ///   - [`skip_final_snapshot(bool)`](crate::client::fluent_builders::DeleteDBInstance::skip_final_snapshot) / [`set_skip_final_snapshot(bool)`](crate::client::fluent_builders::DeleteDBInstance::set_skip_final_snapshot): <p> Determines whether a final DB snapshot is created before the DB instance is deleted. If <code>true</code> is specified, no DBSnapshot is created. If <code>false</code> is specified, a DB snapshot is created before the DB instance is deleted.</p>  <p>Note that when a DB instance is in a failure state and has a status of 'failed', 'incompatible-restore', or 'incompatible-network', it can only be deleted when the SkipFinalSnapshot parameter is set to "true".</p>  <p>Specify <code>true</code> when deleting a Read Replica.</p> <note>   <p>The FinalDBSnapshotIdentifier parameter must be specified if SkipFinalSnapshot is <code>false</code>.</p>  </note>  <p>Default: <code>false</code> </p>
    ///   - [`final_db_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteDBInstance::final_db_snapshot_identifier) / [`set_final_db_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::DeleteDBInstance::set_final_db_snapshot_identifier): <p> The DBSnapshotIdentifier of the new DBSnapshot created when SkipFinalSnapshot is set to <code>false</code>.</p> <note>   <p>Specifying this parameter and also setting the SkipFinalShapshot parameter to true results in an error.</p>  </note>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 letters or numbers.</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>   <li> <p>Cannot be specified when deleting a Read Replica.</p> </li>  </ul>
    /// - On success, responds with [`DeleteDbInstanceOutput`](crate::output::DeleteDbInstanceOutput) with field(s):
    ///   - [`db_instance(Option<DbInstance>)`](crate::output::DeleteDbInstanceOutput::db_instance): <p>Contains the details of an Amazon Neptune DB instance.</p>  <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
    /// - On failure, responds with [`SdkError<DeleteDBInstanceError>`](crate::error::DeleteDBInstanceError)
    pub fn delete_db_instance(&self) -> fluent_builders::DeleteDBInstance {
        fluent_builders::DeleteDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDBParameterGroup`](crate::client::fluent_builders::DeleteDBParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDBParameterGroup::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DeleteDBParameterGroup::set_db_parameter_group_name): <p>The name of the DB parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be the name of an existing DB parameter group</p> </li>   <li> <p>You can't delete a default DB parameter group</p> </li>   <li> <p>Cannot be associated with any DB instances</p> </li>  </ul>
    /// - On success, responds with [`DeleteDbParameterGroupOutput`](crate::output::DeleteDbParameterGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteDBParameterGroupError>`](crate::error::DeleteDBParameterGroupError)
    pub fn delete_db_parameter_group(&self) -> fluent_builders::DeleteDBParameterGroup {
        fluent_builders::DeleteDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDBSubnetGroup`](crate::client::fluent_builders::DeleteDBSubnetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDBSubnetGroup::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::DeleteDBSubnetGroup::set_db_subnet_group_name): <p>The name of the database subnet group to delete.</p> <note>   <p>You can't delete the default subnet group.</p>  </note>  <p>Constraints:</p>  <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>  <p>Example: <code>mySubnetgroup</code> </p>
    /// - On success, responds with [`DeleteDbSubnetGroupOutput`](crate::output::DeleteDbSubnetGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteDBSubnetGroupError>`](crate::error::DeleteDBSubnetGroupError)
    pub fn delete_db_subnet_group(&self) -> fluent_builders::DeleteDBSubnetGroup {
        fluent_builders::DeleteDBSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEventSubscription`](crate::client::fluent_builders::DeleteEventSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::DeleteEventSubscription::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::DeleteEventSubscription::set_subscription_name): <p>The name of the event notification subscription you want to delete.</p>
    /// - On success, responds with [`DeleteEventSubscriptionOutput`](crate::output::DeleteEventSubscriptionOutput) with field(s):
    ///   - [`event_subscription(Option<EventSubscription>)`](crate::output::DeleteEventSubscriptionOutput::event_subscription): <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    /// - On failure, responds with [`SdkError<DeleteEventSubscriptionError>`](crate::error::DeleteEventSubscriptionError)
    pub fn delete_event_subscription(&self) -> fluent_builders::DeleteEventSubscription {
        fluent_builders::DeleteEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBClusterEndpoints`](crate::client::fluent_builders::DescribeDBClusterEndpoints) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBClusterEndpoints::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::set_db_cluster_identifier): <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
    ///   - [`db_cluster_endpoint_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::db_cluster_endpoint_identifier) / [`set_db_cluster_endpoint_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::set_db_cluster_endpoint_identifier): <p>The identifier of the endpoint to describe. This parameter is stored as a lowercase string.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::set_filters): <p>A set of name-value pairs that define which endpoints to include in the output. The filters are specified as name-value pairs, in the format <code>Name=<i>endpoint_type</i>,Values=<i>endpoint_type1</i>,<i>endpoint_type2</i>,...</code>. <code>Name</code> can be one of: <code>db-cluster-endpoint-type</code>, <code>db-cluster-endpoint-custom-type</code>, <code>db-cluster-endpoint-id</code>, <code>db-cluster-endpoint-status</code>. <code>Values</code> for the <code> db-cluster-endpoint-type</code> filter can be one or more of: <code>reader</code>, <code>writer</code>, <code>custom</code>. <code>Values</code> for the <code>db-cluster-endpoint-custom-type</code> filter can be one or more of: <code>reader</code>, <code>any</code>. <code>Values</code> for the <code>db-cluster-endpoint-status</code> filter can be one or more of: <code>available</code>, <code>creating</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results. </p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::set_marker): <p> An optional pagination token provided by a previous <code>DescribeDBClusterEndpoints</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    /// - On success, responds with [`DescribeDbClusterEndpointsOutput`](crate::output::DescribeDbClusterEndpointsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbClusterEndpointsOutput::marker): <p> An optional pagination token provided by a previous <code>DescribeDBClusterEndpoints</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    ///   - [`db_cluster_endpoints(Option<Vec<DbClusterEndpoint>>)`](crate::output::DescribeDbClusterEndpointsOutput::db_cluster_endpoints): <p>Contains the details of the endpoints associated with the cluster and matching any filter conditions.</p>
    /// - On failure, responds with [`SdkError<DescribeDBClusterEndpointsError>`](crate::error::DescribeDBClusterEndpointsError)
    pub fn describe_db_cluster_endpoints(&self) -> fluent_builders::DescribeDBClusterEndpoints {
        fluent_builders::DescribeDBClusterEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBClusterParameterGroups`](crate::client::fluent_builders::DescribeDBClusterParameterGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBClusterParameterGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterParameterGroups::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterParameterGroups::set_db_cluster_parameter_group_name): <p>The name of a specific DB cluster parameter group to return details for.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>  </ul>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBClusterParameterGroups::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBClusterParameterGroups::set_filters): <p>This parameter is not currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBClusterParameterGroups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBClusterParameterGroups::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterParameterGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterParameterGroups::set_marker): <p> An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeDbClusterParameterGroupsOutput`](crate::output::DescribeDbClusterParameterGroupsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbClusterParameterGroupsOutput::marker): <p> An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`db_cluster_parameter_groups(Option<Vec<DbClusterParameterGroup>>)`](crate::output::DescribeDbClusterParameterGroupsOutput::db_cluster_parameter_groups): <p>A list of DB cluster parameter groups.</p>
    /// - On failure, responds with [`SdkError<DescribeDBClusterParameterGroupsError>`](crate::error::DescribeDBClusterParameterGroupsError)
    pub fn describe_db_cluster_parameter_groups(
        &self,
    ) -> fluent_builders::DescribeDBClusterParameterGroups {
        fluent_builders::DescribeDBClusterParameterGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBClusterParameters`](crate::client::fluent_builders::DescribeDBClusterParameters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBClusterParameters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterParameters::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterParameters::set_db_cluster_parameter_group_name): <p>The name of a specific DB cluster parameter group to return parameter details for.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>  </ul>
    ///   - [`source(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterParameters::source) / [`set_source(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterParameters::set_source): <p> A value that indicates to return only parameters for a specific source. Parameter sources can be <code>engine</code>, <code>service</code>, or <code>customer</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBClusterParameters::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBClusterParameters::set_filters): <p>This parameter is not currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBClusterParameters::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBClusterParameters::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterParameters::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterParameters::set_marker): <p> An optional pagination token provided by a previous <code>DescribeDBClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    /// - On success, responds with [`DescribeDbClusterParametersOutput`](crate::output::DescribeDbClusterParametersOutput) with field(s):
    ///   - [`parameters(Option<Vec<Parameter>>)`](crate::output::DescribeDbClusterParametersOutput::parameters): <p>Provides a list of parameters for the DB cluster parameter group.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbClusterParametersOutput::marker): <p> An optional pagination token provided by a previous DescribeDBClusterParameters request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
    /// - On failure, responds with [`SdkError<DescribeDBClusterParametersError>`](crate::error::DescribeDBClusterParametersError)
    pub fn describe_db_cluster_parameters(&self) -> fluent_builders::DescribeDBClusterParameters {
        fluent_builders::DescribeDBClusterParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBClusters`](crate::client::fluent_builders::DescribeDBClusters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBClusters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusters::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBClusters::set_db_cluster_identifier): <p>The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match an existing DBClusterIdentifier.</p> </li>  </ul>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBClusters::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBClusters::set_filters): <p>A filter that specifies one or more DB clusters to describe.</p>  <p>Supported filters:</p>  <ul>   <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include information about the DB clusters identified by these ARNs.</p> </li>   <li> <p> <code>engine</code> - Accepts an engine name (such as <code>neptune</code>), and restricts the results list to DB clusters created by that engine.</p> </li>  </ul>  <p>For example, to invoke this API from the Amazon CLI and filter so that only Neptune DB clusters are returned, you could use the following command:</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBClusters::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBClusters::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusters::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBClusters::set_marker): <p>An optional pagination token provided by a previous <code>DescribeDBClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeDbClustersOutput`](crate::output::DescribeDbClustersOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbClustersOutput::marker): <p>A pagination token that can be used in a subsequent DescribeDBClusters request.</p>
    ///   - [`db_clusters(Option<Vec<DbCluster>>)`](crate::output::DescribeDbClustersOutput::db_clusters): <p>Contains a list of DB clusters for the user.</p>
    /// - On failure, responds with [`SdkError<DescribeDBClustersError>`](crate::error::DescribeDBClustersError)
    pub fn describe_db_clusters(&self) -> fluent_builders::DescribeDBClusters {
        fluent_builders::DescribeDBClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBClusterSnapshotAttributes`](crate::client::fluent_builders::DescribeDBClusterSnapshotAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshotAttributes::db_cluster_snapshot_identifier) / [`set_db_cluster_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshotAttributes::set_db_cluster_snapshot_identifier): <p>The identifier for the DB cluster snapshot to describe the attributes for.</p>
    /// - On success, responds with [`DescribeDbClusterSnapshotAttributesOutput`](crate::output::DescribeDbClusterSnapshotAttributesOutput) with field(s):
    ///   - [`db_cluster_snapshot_attributes_result(Option<DbClusterSnapshotAttributesResult>)`](crate::output::DescribeDbClusterSnapshotAttributesOutput::db_cluster_snapshot_attributes_result): <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code> API action.</p>  <p>Manual DB cluster snapshot attributes are used to authorize other Amazon accounts to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
    /// - On failure, responds with [`SdkError<DescribeDBClusterSnapshotAttributesError>`](crate::error::DescribeDBClusterSnapshotAttributesError)
    pub fn describe_db_cluster_snapshot_attributes(
        &self,
    ) -> fluent_builders::DescribeDBClusterSnapshotAttributes {
        fluent_builders::DescribeDBClusterSnapshotAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBClusterSnapshots`](crate::client::fluent_builders::DescribeDBClusterSnapshots) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBClusterSnapshots::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::set_db_cluster_identifier): <p>The ID of the DB cluster to retrieve the list of DB cluster snapshots for. This parameter can't be used in conjunction with the <code>DBClusterSnapshotIdentifier</code> parameter. This parameter is not case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the identifier of an existing DBCluster.</p> </li>  </ul>
    ///   - [`db_cluster_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::db_cluster_snapshot_identifier) / [`set_db_cluster_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::set_db_cluster_snapshot_identifier): <p>A specific DB cluster snapshot identifier to describe. This parameter can't be used in conjunction with the <code>DBClusterIdentifier</code> parameter. This value is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the identifier of an existing DBClusterSnapshot.</p> </li>   <li> <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</p> </li>  </ul>
    ///   - [`snapshot_type(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::snapshot_type) / [`set_snapshot_type(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::set_snapshot_type): <p>The type of DB cluster snapshots to be returned. You can specify one of the following values:</p>  <ul>   <li> <p> <code>automated</code> - Return all DB cluster snapshots that have been automatically taken by Amazon Neptune for my Amazon account.</p> </li>   <li> <p> <code>manual</code> - Return all DB cluster snapshots that have been taken by my Amazon account.</p> </li>   <li> <p> <code>shared</code> - Return all manual DB cluster snapshots that have been shared to my Amazon account.</p> </li>   <li> <p> <code>public</code> - Return all DB cluster snapshots that have been marked as public.</p> </li>  </ul>  <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual DB cluster snapshots are returned. You can include shared DB cluster snapshots with these results by setting the <code>IncludeShared</code> parameter to <code>true</code>. You can include public DB cluster snapshots with these results by setting the <code>IncludePublic</code> parameter to <code>true</code>.</p>  <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>public</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::set_filters): <p>This parameter is not currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::set_marker): <p>An optional pagination token provided by a previous <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    ///   - [`include_shared(bool)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::include_shared) / [`set_include_shared(bool)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::set_include_shared): <p>True to include shared manual DB cluster snapshots from other Amazon accounts that this Amazon account has been given permission to copy or restore, and otherwise false. The default is <code>false</code>.</p>  <p>You can give an Amazon account permission to restore a manual DB cluster snapshot from another Amazon account by the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
    ///   - [`include_public(bool)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::include_public) / [`set_include_public(bool)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::set_include_public): <p>True to include manual DB cluster snapshots that are public and can be copied or restored by any Amazon account, and otherwise false. The default is <code>false</code>. The default is false.</p>  <p>You can share a manual DB cluster snapshot as public by using the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
    /// - On success, responds with [`DescribeDbClusterSnapshotsOutput`](crate::output::DescribeDbClusterSnapshotsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbClusterSnapshotsOutput::marker): <p> An optional pagination token provided by a previous <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    ///   - [`db_cluster_snapshots(Option<Vec<DbClusterSnapshot>>)`](crate::output::DescribeDbClusterSnapshotsOutput::db_cluster_snapshots): <p>Provides a list of DB cluster snapshots for the user.</p>
    /// - On failure, responds with [`SdkError<DescribeDBClusterSnapshotsError>`](crate::error::DescribeDBClusterSnapshotsError)
    pub fn describe_db_cluster_snapshots(&self) -> fluent_builders::DescribeDBClusterSnapshots {
        fluent_builders::DescribeDBClusterSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBEngineVersions`](crate::client::fluent_builders::DescribeDBEngineVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBEngineVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::DescribeDBEngineVersions::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::DescribeDBEngineVersions::set_engine): <p>The database engine to return.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::DescribeDBEngineVersions::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::DescribeDBEngineVersions::set_engine_version): <p>The database engine version to return.</p>  <p>Example: <code>5.1.49</code> </p>
    ///   - [`db_parameter_group_family(impl Into<String>)`](crate::client::fluent_builders::DescribeDBEngineVersions::db_parameter_group_family) / [`set_db_parameter_group_family(Option<String>)`](crate::client::fluent_builders::DescribeDBEngineVersions::set_db_parameter_group_family): <p>The name of a specific DB parameter group family to return details for.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match an existing DBParameterGroupFamily.</p> </li>  </ul>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBEngineVersions::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBEngineVersions::set_filters): <p>Not currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBEngineVersions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBEngineVersions::set_max_records): <p> The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is included in the response so that the following results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBEngineVersions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBEngineVersions::set_marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`default_only(bool)`](crate::client::fluent_builders::DescribeDBEngineVersions::default_only) / [`set_default_only(bool)`](crate::client::fluent_builders::DescribeDBEngineVersions::set_default_only): <p>Indicates that only the default version of the specified engine or engine and major version combination is returned.</p>
    ///   - [`list_supported_character_sets(bool)`](crate::client::fluent_builders::DescribeDBEngineVersions::list_supported_character_sets) / [`set_list_supported_character_sets(Option<bool>)`](crate::client::fluent_builders::DescribeDBEngineVersions::set_list_supported_character_sets): <p>If this parameter is specified and the requested engine supports the <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine version.</p>
    ///   - [`list_supported_timezones(bool)`](crate::client::fluent_builders::DescribeDBEngineVersions::list_supported_timezones) / [`set_list_supported_timezones(Option<bool>)`](crate::client::fluent_builders::DescribeDBEngineVersions::set_list_supported_timezones): <p>If this parameter is specified and the requested engine supports the <code>TimeZone</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine version.</p>
    /// - On success, responds with [`DescribeDbEngineVersionsOutput`](crate::output::DescribeDbEngineVersionsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbEngineVersionsOutput::marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`db_engine_versions(Option<Vec<DbEngineVersion>>)`](crate::output::DescribeDbEngineVersionsOutput::db_engine_versions): <p> A list of <code>DBEngineVersion</code> elements.</p>
    /// - On failure, responds with [`SdkError<DescribeDBEngineVersionsError>`](crate::error::DescribeDBEngineVersionsError)
    pub fn describe_db_engine_versions(&self) -> fluent_builders::DescribeDBEngineVersions {
        fluent_builders::DescribeDBEngineVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBInstances`](crate::client::fluent_builders::DescribeDBInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBInstances::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBInstances::set_db_instance_identifier): <p>The user-supplied instance identifier. If this parameter is specified, information from only the specific DB instance is returned. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the identifier of an existing DBInstance.</p> </li>  </ul>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBInstances::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBInstances::set_filters): <p>A filter that specifies one or more DB instances to describe.</p>  <p>Supported filters:</p>  <ul>   <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include information about the DB instances associated with the DB clusters identified by these ARNs.</p> </li>   <li> <p> <code>engine</code> - Accepts an engine name (such as <code>neptune</code>), and restricts the results list to DB instances created by that engine.</p> </li>  </ul>  <p>For example, to invoke this API from the Amazon CLI and filter so that only Neptune DB instances are returned, you could use the following command:</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBInstances::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBInstances::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBInstances::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBInstances::set_marker): <p> An optional pagination token provided by a previous <code>DescribeDBInstances</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeDbInstancesOutput`](crate::output::DescribeDbInstancesOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbInstancesOutput::marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
    ///   - [`db_instances(Option<Vec<DbInstance>>)`](crate::output::DescribeDbInstancesOutput::db_instances): <p> A list of <code>DBInstance</code> instances.</p>
    /// - On failure, responds with [`SdkError<DescribeDBInstancesError>`](crate::error::DescribeDBInstancesError)
    pub fn describe_db_instances(&self) -> fluent_builders::DescribeDBInstances {
        fluent_builders::DescribeDBInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBParameterGroups`](crate::client::fluent_builders::DescribeDBParameterGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBParameterGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDBParameterGroups::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DescribeDBParameterGroups::set_db_parameter_group_name): <p>The name of a specific DB parameter group to return details for.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>  </ul>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBParameterGroups::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBParameterGroups::set_filters): <p>This parameter is not currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBParameterGroups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBParameterGroups::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBParameterGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBParameterGroups::set_marker): <p>An optional pagination token provided by a previous <code>DescribeDBParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeDbParameterGroupsOutput`](crate::output::DescribeDbParameterGroupsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbParameterGroupsOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`db_parameter_groups(Option<Vec<DbParameterGroup>>)`](crate::output::DescribeDbParameterGroupsOutput::db_parameter_groups): <p>A list of <code>DBParameterGroup</code> instances.</p>
    /// - On failure, responds with [`SdkError<DescribeDBParameterGroupsError>`](crate::error::DescribeDBParameterGroupsError)
    pub fn describe_db_parameter_groups(&self) -> fluent_builders::DescribeDBParameterGroups {
        fluent_builders::DescribeDBParameterGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBParameters`](crate::client::fluent_builders::DescribeDBParameters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBParameters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDBParameters::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DescribeDBParameters::set_db_parameter_group_name): <p>The name of a specific DB parameter group to return details for.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the name of an existing DBParameterGroup.</p> </li>  </ul>
    ///   - [`source(impl Into<String>)`](crate::client::fluent_builders::DescribeDBParameters::source) / [`set_source(Option<String>)`](crate::client::fluent_builders::DescribeDBParameters::set_source): <p>The parameter types to return.</p>  <p>Default: All parameter types returned</p>  <p>Valid Values: <code>user | system | engine-default</code> </p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBParameters::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBParameters::set_filters): <p>This parameter is not currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBParameters::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBParameters::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBParameters::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBParameters::set_marker): <p>An optional pagination token provided by a previous <code>DescribeDBParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeDbParametersOutput`](crate::output::DescribeDbParametersOutput) with field(s):
    ///   - [`parameters(Option<Vec<Parameter>>)`](crate::output::DescribeDbParametersOutput::parameters): <p>A list of <code>Parameter</code> values.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbParametersOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeDBParametersError>`](crate::error::DescribeDBParametersError)
    pub fn describe_db_parameters(&self) -> fluent_builders::DescribeDBParameters {
        fluent_builders::DescribeDBParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBSubnetGroups`](crate::client::fluent_builders::DescribeDBSubnetGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBSubnetGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDBSubnetGroups::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::DescribeDBSubnetGroups::set_db_subnet_group_name): <p>The name of the DB subnet group to return details for.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBSubnetGroups::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBSubnetGroups::set_filters): <p>This parameter is not currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBSubnetGroups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBSubnetGroups::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBSubnetGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBSubnetGroups::set_marker): <p> An optional pagination token provided by a previous DescribeDBSubnetGroups request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeDbSubnetGroupsOutput`](crate::output::DescribeDbSubnetGroupsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbSubnetGroupsOutput::marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`db_subnet_groups(Option<Vec<DbSubnetGroup>>)`](crate::output::DescribeDbSubnetGroupsOutput::db_subnet_groups): <p> A list of <code>DBSubnetGroup</code> instances.</p>
    /// - On failure, responds with [`SdkError<DescribeDBSubnetGroupsError>`](crate::error::DescribeDBSubnetGroupsError)
    pub fn describe_db_subnet_groups(&self) -> fluent_builders::DescribeDBSubnetGroups {
        fluent_builders::DescribeDBSubnetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEngineDefaultClusterParameters`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_parameter_group_family(impl Into<String>)`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters::db_parameter_group_family) / [`set_db_parameter_group_family(Option<String>)`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters::set_db_parameter_group_family): <p>The name of the DB cluster parameter group family to return engine parameter information for.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters::set_filters): <p>This parameter is not currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters::set_marker): <p> An optional pagination token provided by a previous <code>DescribeEngineDefaultClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeEngineDefaultClusterParametersOutput`](crate::output::DescribeEngineDefaultClusterParametersOutput) with field(s):
    ///   - [`engine_defaults(Option<EngineDefaults>)`](crate::output::DescribeEngineDefaultClusterParametersOutput::engine_defaults): <p> Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.</p>
    /// - On failure, responds with [`SdkError<DescribeEngineDefaultClusterParametersError>`](crate::error::DescribeEngineDefaultClusterParametersError)
    pub fn describe_engine_default_cluster_parameters(
        &self,
    ) -> fluent_builders::DescribeEngineDefaultClusterParameters {
        fluent_builders::DescribeEngineDefaultClusterParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEngineDefaultParameters`](crate::client::fluent_builders::DescribeEngineDefaultParameters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEngineDefaultParameters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_parameter_group_family(impl Into<String>)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::db_parameter_group_family) / [`set_db_parameter_group_family(Option<String>)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::set_db_parameter_group_family): <p>The name of the DB parameter group family.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::set_filters): <p>Not currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::set_marker): <p> An optional pagination token provided by a previous <code>DescribeEngineDefaultParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeEngineDefaultParametersOutput`](crate::output::DescribeEngineDefaultParametersOutput) with field(s):
    ///   - [`engine_defaults(Option<EngineDefaults>)`](crate::output::DescribeEngineDefaultParametersOutput::engine_defaults): <p> Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.</p>
    /// - On failure, responds with [`SdkError<DescribeEngineDefaultParametersError>`](crate::error::DescribeEngineDefaultParametersError)
    pub fn describe_engine_default_parameters(
        &self,
    ) -> fluent_builders::DescribeEngineDefaultParameters {
        fluent_builders::DescribeEngineDefaultParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEventCategories`](crate::client::fluent_builders::DescribeEventCategories) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_type(impl Into<String>)`](crate::client::fluent_builders::DescribeEventCategories::source_type) / [`set_source_type(Option<String>)`](crate::client::fluent_builders::DescribeEventCategories::set_source_type): <p>The type of source that is generating the events.</p>  <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeEventCategories::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeEventCategories::set_filters): <p>This parameter is not currently supported.</p>
    /// - On success, responds with [`DescribeEventCategoriesOutput`](crate::output::DescribeEventCategoriesOutput) with field(s):
    ///   - [`event_categories_map_list(Option<Vec<EventCategoriesMap>>)`](crate::output::DescribeEventCategoriesOutput::event_categories_map_list): <p>A list of EventCategoriesMap data types.</p>
    /// - On failure, responds with [`SdkError<DescribeEventCategoriesError>`](crate::error::DescribeEventCategoriesError)
    pub fn describe_event_categories(&self) -> fluent_builders::DescribeEventCategories {
        fluent_builders::DescribeEventCategories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEvents`](crate::client::fluent_builders::DescribeEvents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEvents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::source_identifier) / [`set_source_identifier(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_source_identifier): <p>The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.</p>  <p>Constraints:</p>  <ul>   <li> <p>If SourceIdentifier is supplied, SourceType must also be provided.</p> </li>   <li> <p>If the source type is <code>DBInstance</code>, then a <code>DBInstanceIdentifier</code> must be supplied.</p> </li>   <li> <p>If the source type is <code>DBSecurityGroup</code>, a <code>DBSecurityGroupName</code> must be supplied.</p> </li>   <li> <p>If the source type is <code>DBParameterGroup</code>, a <code>DBParameterGroupName</code> must be supplied.</p> </li>   <li> <p>If the source type is <code>DBSnapshot</code>, a <code>DBSnapshotIdentifier</code> must be supplied.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>
    ///   - [`source_type(SourceType)`](crate::client::fluent_builders::DescribeEvents::source_type) / [`set_source_type(Option<SourceType>)`](crate::client::fluent_builders::DescribeEvents::set_source_type): <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::DescribeEvents::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeEvents::set_start_time): <p> The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>  <p>Example: 2009-07-08T18:00Z</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::DescribeEvents::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeEvents::set_end_time): <p> The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>  <p>Example: 2009-07-08T18:00Z</p>
    ///   - [`duration(i32)`](crate::client::fluent_builders::DescribeEvents::duration) / [`set_duration(Option<i32>)`](crate::client::fluent_builders::DescribeEvents::set_duration): <p>The number of minutes to retrieve events for.</p>  <p>Default: 60</p>
    ///   - [`event_categories(Vec<String>)`](crate::client::fluent_builders::DescribeEvents::event_categories) / [`set_event_categories(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeEvents::set_event_categories): <p>A list of event categories that trigger notifications for a event notification subscription.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeEvents::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeEvents::set_filters): <p>This parameter is not currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEvents::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEvents::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_marker): <p> An optional pagination token provided by a previous DescribeEvents request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeEventsOutput`](crate::output::DescribeEventsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeEventsOutput::marker): <p> An optional pagination token provided by a previous Events request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
    ///   - [`events(Option<Vec<Event>>)`](crate::output::DescribeEventsOutput::events): <p> A list of <code>Event</code> instances.</p>
    /// - On failure, responds with [`SdkError<DescribeEventsError>`](crate::error::DescribeEventsError)
    pub fn describe_events(&self) -> fluent_builders::DescribeEvents {
        fluent_builders::DescribeEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEventSubscriptions`](crate::client::fluent_builders::DescribeEventSubscriptions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEventSubscriptions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::DescribeEventSubscriptions::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::DescribeEventSubscriptions::set_subscription_name): <p>The name of the event notification subscription you want to describe.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeEventSubscriptions::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeEventSubscriptions::set_filters): <p>This parameter is not currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEventSubscriptions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEventSubscriptions::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeEventSubscriptions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeEventSubscriptions::set_marker): <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
    /// - On success, responds with [`DescribeEventSubscriptionsOutput`](crate::output::DescribeEventSubscriptionsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeEventSubscriptionsOutput::marker): <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`event_subscriptions_list(Option<Vec<EventSubscription>>)`](crate::output::DescribeEventSubscriptionsOutput::event_subscriptions_list): <p>A list of EventSubscriptions data types.</p>
    /// - On failure, responds with [`SdkError<DescribeEventSubscriptionsError>`](crate::error::DescribeEventSubscriptionsError)
    pub fn describe_event_subscriptions(&self) -> fluent_builders::DescribeEventSubscriptions {
        fluent_builders::DescribeEventSubscriptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOrderableDBInstanceOptions`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::set_engine): <p>The name of the engine to retrieve DB instance options for.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::set_engine_version): <p>The engine version filter value. Specify this parameter to show only the available offerings matching the specified engine version.</p>
    ///   - [`db_instance_class(impl Into<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::db_instance_class) / [`set_db_instance_class(Option<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::set_db_instance_class): <p>The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class.</p>
    ///   - [`license_model(impl Into<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::license_model) / [`set_license_model(Option<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::set_license_model): <p>The license model filter value. Specify this parameter to show only the available offerings matching the specified license model.</p>
    ///   - [`vpc(bool)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::vpc) / [`set_vpc(Option<bool>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::set_vpc): <p>The VPC filter value. Specify this parameter to show only the available VPC or non-VPC offerings.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::set_filters): <p>This parameter is not currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::set_marker): <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
    /// - On success, responds with [`DescribeOrderableDbInstanceOptionsOutput`](crate::output::DescribeOrderableDbInstanceOptionsOutput) with field(s):
    ///   - [`orderable_db_instance_options(Option<Vec<OrderableDbInstanceOption>>)`](crate::output::DescribeOrderableDbInstanceOptionsOutput::orderable_db_instance_options): <p>An <code>OrderableDBInstanceOption</code> structure containing information about orderable options for the DB instance.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeOrderableDbInstanceOptionsOutput::marker): <p> An optional pagination token provided by a previous OrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
    /// - On failure, responds with [`SdkError<DescribeOrderableDBInstanceOptionsError>`](crate::error::DescribeOrderableDBInstanceOptionsError)
    pub fn describe_orderable_db_instance_options(
        &self,
    ) -> fluent_builders::DescribeOrderableDBInstanceOptions {
        fluent_builders::DescribeOrderableDBInstanceOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePendingMaintenanceActions`](crate::client::fluent_builders::DescribePendingMaintenanceActions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribePendingMaintenanceActions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::resource_identifier) / [`set_resource_identifier(Option<String>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::set_resource_identifier): <p>The ARN of a resource to return pending maintenance actions for.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::set_filters): <p>A filter that specifies one or more resources to return pending maintenance actions for.</p>  <p>Supported filters:</p>  <ul>   <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include pending maintenance actions for the DB clusters identified by these ARNs.</p> </li>   <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance ARNs. The results list will only include pending maintenance actions for the DB instances identified by these ARNs.</p> </li>  </ul>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::set_marker): <p> An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by <code>MaxRecords</code>.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    /// - On success, responds with [`DescribePendingMaintenanceActionsOutput`](crate::output::DescribePendingMaintenanceActionsOutput) with field(s):
    ///   - [`pending_maintenance_actions(Option<Vec<ResourcePendingMaintenanceActions>>)`](crate::output::DescribePendingMaintenanceActionsOutput::pending_maintenance_actions): <p>A list of the pending maintenance actions for the resource.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribePendingMaintenanceActionsOutput::marker): <p> An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by <code>MaxRecords</code>.</p>
    /// - On failure, responds with [`SdkError<DescribePendingMaintenanceActionsError>`](crate::error::DescribePendingMaintenanceActionsError)
    pub fn describe_pending_maintenance_actions(
        &self,
    ) -> fluent_builders::DescribePendingMaintenanceActions {
        fluent_builders::DescribePendingMaintenanceActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeValidDBInstanceModifications`](crate::client::fluent_builders::DescribeValidDBInstanceModifications) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeValidDBInstanceModifications::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::DescribeValidDBInstanceModifications::set_db_instance_identifier): <p>The customer identifier or the ARN of your DB instance.</p>
    /// - On success, responds with [`DescribeValidDbInstanceModificationsOutput`](crate::output::DescribeValidDbInstanceModificationsOutput) with field(s):
    ///   - [`valid_db_instance_modifications_message(Option<ValidDbInstanceModificationsMessage>)`](crate::output::DescribeValidDbInstanceModificationsOutput::valid_db_instance_modifications_message): <p>Information about valid modifications that you can make to your DB instance. Contains the result of a successful call to the <code>DescribeValidDBInstanceModifications</code> action. You can use this information when you call <code>ModifyDBInstance</code>. </p>
    /// - On failure, responds with [`SdkError<DescribeValidDBInstanceModificationsError>`](crate::error::DescribeValidDBInstanceModificationsError)
    pub fn describe_valid_db_instance_modifications(
        &self,
    ) -> fluent_builders::DescribeValidDBInstanceModifications {
        fluent_builders::DescribeValidDBInstanceModifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`FailoverDBCluster`](crate::client::fluent_builders::FailoverDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::FailoverDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::FailoverDBCluster::set_db_cluster_identifier): <p>A DB cluster identifier to force a failover for. This parameter is not case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing DBCluster.</p> </li>  </ul>
    ///   - [`target_db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::FailoverDBCluster::target_db_instance_identifier) / [`set_target_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::FailoverDBCluster::set_target_db_instance_identifier): <p>The name of the instance to promote to the primary instance.</p>  <p>You must specify the instance identifier for an Read Replica in the DB cluster. For example, <code>mydbcluster-replica1</code>.</p>
    /// - On success, responds with [`FailoverDbClusterOutput`](crate::output::FailoverDbClusterOutput) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::FailoverDbClusterOutput::db_cluster): <p>Contains the details of an Amazon Neptune DB cluster.</p>  <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    /// - On failure, responds with [`SdkError<FailoverDBClusterError>`](crate::error::FailoverDBClusterError)
    pub fn failover_db_cluster(&self) -> fluent_builders::FailoverDBCluster {
        fluent_builders::FailoverDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_name(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_name) / [`set_resource_name(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_name): <p>The Amazon Neptune resource with tags to be listed. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListTagsForResource::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListTagsForResource::set_filters): <p>This parameter is not currently supported.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tag_list): <p>List of tags returned by the ListTagsForResource operation.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDBCluster`](crate::client::fluent_builders::ModifyDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_db_cluster_identifier): <p>The DB cluster identifier for the cluster being modified. This parameter is not case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing DBCluster.</p> </li>  </ul>
    ///   - [`new_db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::new_db_cluster_identifier) / [`set_new_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_new_db_cluster_identifier): <p>The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li>   <li> <p>The first character must be a letter</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>  <p>Example: <code>my-cluster2</code> </p>
    ///   - [`apply_immediately(bool)`](crate::client::fluent_builders::ModifyDBCluster::apply_immediately) / [`set_apply_immediately(bool)`](crate::client::fluent_builders::ModifyDBCluster::set_apply_immediately): <p>A value that specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB cluster. If this parameter is set to <code>false</code>, changes to the DB cluster are applied during the next maintenance window.</p>  <p>The <code>ApplyImmediately</code> parameter only affects <code>NewDBClusterIdentifier</code> values. If you set the <code>ApplyImmediately</code> parameter value to false, then changes to <code>NewDBClusterIdentifier</code> values are applied during the next maintenance window. All other changes are applied immediately, regardless of the value of the <code>ApplyImmediately</code> parameter.</p>  <p>Default: <code>false</code> </p>
    ///   - [`backup_retention_period(i32)`](crate::client::fluent_builders::ModifyDBCluster::backup_retention_period) / [`set_backup_retention_period(Option<i32>)`](crate::client::fluent_builders::ModifyDBCluster::set_backup_retention_period): <p>The number of days for which automated backups are retained. You must specify a minimum value of 1.</p>  <p>Default: 1</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be a value from 1 to 35</p> </li>  </ul>
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group to use for the DB cluster.</p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::ModifyDBCluster::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBCluster::set_vpc_security_group_ids): <p>A list of VPC security groups that the DB cluster will belong to.</p>
    ///   - [`port(i32)`](crate::client::fluent_builders::ModifyDBCluster::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::ModifyDBCluster::set_port): <p>The port number on which the DB cluster accepts connections.</p>  <p>Constraints: Value must be <code>1150-65535</code> </p>  <p>Default: The same port as the original DB cluster.</p>
    ///   - [`master_user_password(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::master_user_password) / [`set_master_user_password(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_master_user_password): <p>Not supported by Neptune.</p>
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_option_group_name): <p> <i>Not supported by Neptune.</i> </p>
    ///   - [`preferred_backup_window(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::preferred_backup_window) / [`set_preferred_backup_window(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_preferred_backup_window): <p>The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter.</p>  <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>   <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>   <li> <p>Must not conflict with the preferred maintenance window.</p> </li>   <li> <p>Must be at least 30 minutes.</p> </li>  </ul>
    ///   - [`preferred_maintenance_window(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::preferred_maintenance_window) / [`set_preferred_maintenance_window(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_preferred_maintenance_window): <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>  <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>  <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week.</p>  <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>  <p>Constraints: Minimum 30-minute window.</p>
    ///   - [`enable_iam_database_authentication(bool)`](crate::client::fluent_builders::ModifyDBCluster::enable_iam_database_authentication) / [`set_enable_iam_database_authentication(Option<bool>)`](crate::client::fluent_builders::ModifyDBCluster::set_enable_iam_database_authentication): <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.</p>  <p>Default: <code>false</code> </p>
    ///   - [`cloudwatch_logs_export_configuration(CloudwatchLogsExportConfiguration)`](crate::client::fluent_builders::ModifyDBCluster::cloudwatch_logs_export_configuration) / [`set_cloudwatch_logs_export_configuration(Option<CloudwatchLogsExportConfiguration>)`](crate::client::fluent_builders::ModifyDBCluster::set_cloudwatch_logs_export_configuration): <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB cluster.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_engine_version): <p>The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is set to true.</p>  <p>For a list of valid engine versions, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/engine-releases.html">Engine Releases for Amazon Neptune</a>, or call <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-other-apis.html#DescribeDBEngineVersions">DescribeDBEngineVersions</a>.</p>
    ///   - [`allow_major_version_upgrade(bool)`](crate::client::fluent_builders::ModifyDBCluster::allow_major_version_upgrade) / [`set_allow_major_version_upgrade(bool)`](crate::client::fluent_builders::ModifyDBCluster::set_allow_major_version_upgrade): <p>A value that indicates whether upgrades between different major versions are allowed.</p>  <p>Constraints: You must set the allow-major-version-upgrade flag when providing an <code>EngineVersion</code> parameter that uses a different major version than the DB cluster's current version.</p>
    ///   - [`db_instance_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::db_instance_parameter_group_name) / [`set_db_instance_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_db_instance_parameter_group_name): <p>The name of the DB parameter group to apply to all instances of the DB cluster. </p> <note>   <p>When you apply a parameter group using <code>DBInstanceParameterGroupName</code>, parameter changes aren't applied during the next maintenance window but instead are applied immediately.</p>  </note>  <p>Default: The existing name setting</p>  <p>Constraints:</p>  <ul>   <li> <p>The DB parameter group must be in the same DB parameter group family as the target DB cluster version.</p> </li>   <li> <p>The <code>DBInstanceParameterGroupName</code> parameter is only valid in combination with the <code>AllowMajorVersionUpgrade</code> parameter.</p> </li>  </ul>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::ModifyDBCluster::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::ModifyDBCluster::set_deletion_protection): <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.</p>
    ///   - [`copy_tags_to_snapshot(bool)`](crate::client::fluent_builders::ModifyDBCluster::copy_tags_to_snapshot) / [`set_copy_tags_to_snapshot(Option<bool>)`](crate::client::fluent_builders::ModifyDBCluster::set_copy_tags_to_snapshot): <p> <i>If set to <code>true</code>, tags are copied to any snapshot of the DB cluster that is created.</i> </p>
    /// - On success, responds with [`ModifyDbClusterOutput`](crate::output::ModifyDbClusterOutput) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::ModifyDbClusterOutput::db_cluster): <p>Contains the details of an Amazon Neptune DB cluster.</p>  <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    /// - On failure, responds with [`SdkError<ModifyDBClusterError>`](crate::error::ModifyDBClusterError)
    pub fn modify_db_cluster(&self) -> fluent_builders::ModifyDBCluster {
        fluent_builders::ModifyDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDBClusterEndpoint`](crate::client::fluent_builders::ModifyDBClusterEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_endpoint_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyDBClusterEndpoint::db_cluster_endpoint_identifier) / [`set_db_cluster_endpoint_identifier(Option<String>)`](crate::client::fluent_builders::ModifyDBClusterEndpoint::set_db_cluster_endpoint_identifier): <p>The identifier of the endpoint to modify. This parameter is stored as a lowercase string.</p>
    ///   - [`endpoint_type(impl Into<String>)`](crate::client::fluent_builders::ModifyDBClusterEndpoint::endpoint_type) / [`set_endpoint_type(Option<String>)`](crate::client::fluent_builders::ModifyDBClusterEndpoint::set_endpoint_type): <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    ///   - [`static_members(Vec<String>)`](crate::client::fluent_builders::ModifyDBClusterEndpoint::static_members) / [`set_static_members(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBClusterEndpoint::set_static_members): <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    ///   - [`excluded_members(Vec<String>)`](crate::client::fluent_builders::ModifyDBClusterEndpoint::excluded_members) / [`set_excluded_members(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBClusterEndpoint::set_excluded_members): <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
    /// - On success, responds with [`ModifyDbClusterEndpointOutput`](crate::output::ModifyDbClusterEndpointOutput) with field(s):
    ///   - [`db_cluster_endpoint_identifier(Option<String>)`](crate::output::ModifyDbClusterEndpointOutput::db_cluster_endpoint_identifier): <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    ///   - [`db_cluster_identifier(Option<String>)`](crate::output::ModifyDbClusterEndpointOutput::db_cluster_identifier): <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
    ///   - [`db_cluster_endpoint_resource_identifier(Option<String>)`](crate::output::ModifyDbClusterEndpointOutput::db_cluster_endpoint_resource_identifier): <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    ///   - [`endpoint(Option<String>)`](crate::output::ModifyDbClusterEndpointOutput::endpoint): <p>The DNS address of the endpoint.</p>
    ///   - [`status(Option<String>)`](crate::output::ModifyDbClusterEndpointOutput::status): <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    ///   - [`endpoint_type(Option<String>)`](crate::output::ModifyDbClusterEndpointOutput::endpoint_type): <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    ///   - [`custom_endpoint_type(Option<String>)`](crate::output::ModifyDbClusterEndpointOutput::custom_endpoint_type): <p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    ///   - [`static_members(Option<Vec<String>>)`](crate::output::ModifyDbClusterEndpointOutput::static_members): <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    ///   - [`excluded_members(Option<Vec<String>>)`](crate::output::ModifyDbClusterEndpointOutput::excluded_members): <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
    ///   - [`db_cluster_endpoint_arn(Option<String>)`](crate::output::ModifyDbClusterEndpointOutput::db_cluster_endpoint_arn): <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    /// - On failure, responds with [`SdkError<ModifyDBClusterEndpointError>`](crate::error::ModifyDBClusterEndpointError)
    pub fn modify_db_cluster_endpoint(&self) -> fluent_builders::ModifyDBClusterEndpoint {
        fluent_builders::ModifyDBClusterEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDBClusterParameterGroup`](crate::client::fluent_builders::ModifyDBClusterParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBClusterParameterGroup::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBClusterParameterGroup::set_db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group to modify.</p>
    ///   - [`parameters(Vec<Parameter>)`](crate::client::fluent_builders::ModifyDBClusterParameterGroup::parameters) / [`set_parameters(Option<Vec<Parameter>>)`](crate::client::fluent_builders::ModifyDBClusterParameterGroup::set_parameters): <p>A list of parameters in the DB cluster parameter group to modify.</p>
    /// - On success, responds with [`ModifyDbClusterParameterGroupOutput`](crate::output::ModifyDbClusterParameterGroupOutput) with field(s):
    ///   - [`db_cluster_parameter_group_name(Option<String>)`](crate::output::ModifyDbClusterParameterGroupOutput::db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 letters or numbers.</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>  </ul> <note>   <p>This value is stored as a lowercase string.</p>  </note>
    /// - On failure, responds with [`SdkError<ModifyDBClusterParameterGroupError>`](crate::error::ModifyDBClusterParameterGroupError)
    pub fn modify_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::ModifyDBClusterParameterGroup {
        fluent_builders::ModifyDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDBClusterSnapshotAttribute`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute::db_cluster_snapshot_identifier) / [`set_db_cluster_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute::set_db_cluster_snapshot_identifier): <p>The identifier for the DB cluster snapshot to modify the attributes for.</p>
    ///   - [`attribute_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute::attribute_name) / [`set_attribute_name(Option<String>)`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute::set_attribute_name): <p>The name of the DB cluster snapshot attribute to modify.</p>  <p>To manage authorization for other Amazon accounts to copy or restore a manual DB cluster snapshot, set this value to <code>restore</code>.</p>
    ///   - [`values_to_add(Vec<String>)`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute::values_to_add) / [`set_values_to_add(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute::set_values_to_add): <p>A list of DB cluster snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p>  <p>To authorize other Amazon accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more Amazon account IDs, or <code>all</code> to make the manual DB cluster snapshot restorable by any Amazon account. Do not add the <code>all</code> value for any manual DB cluster snapshots that contain private information that you don't want available to all Amazon accounts.</p>
    ///   - [`values_to_remove(Vec<String>)`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute::values_to_remove) / [`set_values_to_remove(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute::set_values_to_remove): <p>A list of DB cluster snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.</p>  <p>To remove authorization for other Amazon accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more Amazon account identifiers, or <code>all</code> to remove authorization for any Amazon account to copy or restore the DB cluster snapshot. If you specify <code>all</code>, an Amazon account whose account ID is explicitly added to the <code>restore</code> attribute can still copy or restore a manual DB cluster snapshot.</p>
    /// - On success, responds with [`ModifyDbClusterSnapshotAttributeOutput`](crate::output::ModifyDbClusterSnapshotAttributeOutput) with field(s):
    ///   - [`db_cluster_snapshot_attributes_result(Option<DbClusterSnapshotAttributesResult>)`](crate::output::ModifyDbClusterSnapshotAttributeOutput::db_cluster_snapshot_attributes_result): <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code> API action.</p>  <p>Manual DB cluster snapshot attributes are used to authorize other Amazon accounts to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
    /// - On failure, responds with [`SdkError<ModifyDBClusterSnapshotAttributeError>`](crate::error::ModifyDBClusterSnapshotAttributeError)
    pub fn modify_db_cluster_snapshot_attribute(
        &self,
    ) -> fluent_builders::ModifyDBClusterSnapshotAttribute {
        fluent_builders::ModifyDBClusterSnapshotAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDBInstance`](crate::client::fluent_builders::ModifyDBInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_db_instance_identifier): <p>The DB instance identifier. This value is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing DBInstance.</p> </li>  </ul>
    ///   - [`allocated_storage(i32)`](crate::client::fluent_builders::ModifyDBInstance::allocated_storage) / [`set_allocated_storage(Option<i32>)`](crate::client::fluent_builders::ModifyDBInstance::set_allocated_storage): <p>Not supported by Neptune.</p>
    ///   - [`db_instance_class(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::db_instance_class) / [`set_db_instance_class(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_db_instance_class): <p>The new compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>. Not all DB instance classes are available in all Amazon Regions.</p>  <p>If you modify the DB instance class, an outage occurs during the change. The change is applied during the next maintenance window, unless <code>ApplyImmediately</code> is specified as <code>true</code> for this request.</p>  <p>Default: Uses existing setting</p>
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_db_subnet_group_name): <p>The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a different VPC.</p>  <p>Changing the subnet group causes an outage during the change. The change is applied during the next maintenance window, unless you specify <code>true</code> for the <code>ApplyImmediately</code> parameter.</p>  <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>  <p>Example: <code>mySubnetGroup</code> </p>
    ///   - [`db_security_groups(Vec<String>)`](crate::client::fluent_builders::ModifyDBInstance::db_security_groups) / [`set_db_security_groups(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBInstance::set_db_security_groups): <p>A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in an outage and the change is asynchronously applied as soon as possible.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match existing DBSecurityGroups.</p> </li>  </ul>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::ModifyDBInstance::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBInstance::set_vpc_security_group_ids): <p>A list of EC2 VPC security groups to authorize on this DB instance. This change is asynchronously applied as soon as possible.</p>  <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match existing VpcSecurityGroupIds.</p> </li>  </ul>
    ///   - [`apply_immediately(bool)`](crate::client::fluent_builders::ModifyDBInstance::apply_immediately) / [`set_apply_immediately(bool)`](crate::client::fluent_builders::ModifyDBInstance::set_apply_immediately): <p>Specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB instance.</p>  <p> If this parameter is set to <code>false</code>, changes to the DB instance are applied during the next maintenance window. Some parameter changes can cause an outage and are applied on the next call to <code>RebootDBInstance</code>, or the next failure reboot.</p>  <p>Default: <code>false</code> </p>
    ///   - [`master_user_password(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::master_user_password) / [`set_master_user_password(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_master_user_password): <p>Not supported by Neptune.</p>
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_db_parameter_group_name): <p>The name of the DB parameter group to apply to the DB instance. Changing this setting doesn't result in an outage. The parameter group name itself is changed immediately, but the actual parameter changes are not applied until you reboot the instance without failover. The db instance will NOT be rebooted automatically and the parameter changes will NOT be applied during the next maintenance window.</p>  <p>Default: Uses existing setting</p>  <p>Constraints: The DB parameter group must be in the same DB parameter group family as this DB instance.</p>
    ///   - [`backup_retention_period(i32)`](crate::client::fluent_builders::ModifyDBInstance::backup_retention_period) / [`set_backup_retention_period(Option<i32>)`](crate::client::fluent_builders::ModifyDBInstance::set_backup_retention_period): <p>Not applicable. The retention period for automated backups is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p>  <p>Default: Uses existing setting</p>
    ///   - [`preferred_backup_window(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::preferred_backup_window) / [`set_preferred_backup_window(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_preferred_backup_window): <p> The daily time range during which automated backups are created if automated backups are enabled.</p>  <p>Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be in the format hh24:mi-hh24:mi</p> </li>   <li> <p>Must be in Universal Time Coordinated (UTC)</p> </li>   <li> <p>Must not conflict with the preferred maintenance window</p> </li>   <li> <p>Must be at least 30 minutes</p> </li>  </ul>
    ///   - [`preferred_maintenance_window(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::preferred_maintenance_window) / [`set_preferred_maintenance_window(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_preferred_maintenance_window): <p>The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage. Changing this parameter doesn't result in an outage, except in the following situation, and the change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance window is changed to include the current time, then changing this parameter will cause a reboot of the DB instance. If moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure pending changes are applied.</p>  <p>Default: Uses existing setting</p>  <p>Format: ddd:hh24:mi-ddd:hh24:mi</p>  <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>  <p>Constraints: Must be at least 30 minutes</p>
    ///   - [`multi_az(bool)`](crate::client::fluent_builders::ModifyDBInstance::multi_az) / [`set_multi_az(Option<bool>)`](crate::client::fluent_builders::ModifyDBInstance::set_multi_az): <p>Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter doesn't result in an outage and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_engine_version): <p>The version number of the database engine to upgrade to. Currently, setting this parameter has no effect. To upgrade your database engine to the most recent release, use the <code>ApplyPendingMaintenanceAction</code> API.</p>
    ///   - [`allow_major_version_upgrade(bool)`](crate::client::fluent_builders::ModifyDBInstance::allow_major_version_upgrade) / [`set_allow_major_version_upgrade(bool)`](crate::client::fluent_builders::ModifyDBInstance::set_allow_major_version_upgrade): <p>Indicates that major version upgrades are allowed. Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.</p>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::ModifyDBInstance::auto_minor_version_upgrade) / [`set_auto_minor_version_upgrade(Option<bool>)`](crate::client::fluent_builders::ModifyDBInstance::set_auto_minor_version_upgrade): <p> Indicates that minor version upgrades are applied automatically to the DB instance during the maintenance window. Changing this parameter doesn't result in an outage except in the following case and the change is asynchronously applied as soon as possible. An outage will result if this parameter is set to <code>true</code> during the maintenance window, and a newer minor version is available, and Neptune has enabled auto patching for that engine version.</p>
    ///   - [`license_model(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::license_model) / [`set_license_model(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_license_model): <p>Not supported by Neptune.</p>
    ///   - [`iops(i32)`](crate::client::fluent_builders::ModifyDBInstance::iops) / [`set_iops(Option<i32>)`](crate::client::fluent_builders::ModifyDBInstance::set_iops): <p>The new Provisioned IOPS (I/O operations per second) value for the instance.</p>  <p>Changing this setting doesn't result in an outage and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request.</p>  <p>Default: Uses existing setting</p>
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_option_group_name): <p> <i>(Not supported by Neptune)</i> </p>
    ///   - [`new_db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::new_db_instance_identifier) / [`set_new_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_new_db_instance_identifier): <p> The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB instance identifier, an instance reboot will occur immediately if you set <code>Apply Immediately</code> to true, or will occur during the next maintenance window if <code>Apply Immediately</code> to false. This value is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>   <li> <p>The first character must be a letter.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>  <p>Example: <code>mydbinstance</code> </p>
    ///   - [`storage_type(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::storage_type) / [`set_storage_type(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_storage_type): <p>Not supported.</p>
    ///   - [`tde_credential_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::tde_credential_arn) / [`set_tde_credential_arn(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_tde_credential_arn): <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
    ///   - [`tde_credential_password(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::tde_credential_password) / [`set_tde_credential_password(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_tde_credential_password): <p>The password for the given ARN from the key store in order to access the device.</p>
    ///   - [`ca_certificate_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::ca_certificate_identifier) / [`set_ca_certificate_identifier(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_ca_certificate_identifier): <p>Indicates the certificate that needs to be associated with the instance.</p>
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_domain): <p>Not supported.</p>
    ///   - [`copy_tags_to_snapshot(bool)`](crate::client::fluent_builders::ModifyDBInstance::copy_tags_to_snapshot) / [`set_copy_tags_to_snapshot(Option<bool>)`](crate::client::fluent_builders::ModifyDBInstance::set_copy_tags_to_snapshot): <p>True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise false. The default is false.</p>
    ///   - [`monitoring_interval(i32)`](crate::client::fluent_builders::ModifyDBInstance::monitoring_interval) / [`set_monitoring_interval(Option<i32>)`](crate::client::fluent_builders::ModifyDBInstance::set_monitoring_interval): <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p>  <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0.</p>  <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
    ///   - [`db_port_number(i32)`](crate::client::fluent_builders::ModifyDBInstance::db_port_number) / [`set_db_port_number(Option<i32>)`](crate::client::fluent_builders::ModifyDBInstance::set_db_port_number): <p>The port number on which the database accepts connections.</p>  <p>The value of the <code>DBPortNumber</code> parameter must not match any of the port values specified for options in the option group for the DB instance.</p>  <p>Your database will restart when you change the <code>DBPortNumber</code> value regardless of the value of the <code>ApplyImmediately</code> parameter.</p>  <p> Default: <code>8182</code> </p>
    ///   - [`publicly_accessible(bool)`](crate::client::fluent_builders::ModifyDBInstance::publicly_accessible) / [`set_publicly_accessible(Option<bool>)`](crate::client::fluent_builders::ModifyDBInstance::set_publicly_accessible): <p>This flag should no longer be used.</p>
    ///   - [`monitoring_role_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::monitoring_role_arn) / [`set_monitoring_role_arn(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_monitoring_role_arn): <p>The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>  <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>
    ///   - [`domain_iam_role_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::domain_iam_role_name) / [`set_domain_iam_role_name(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_domain_iam_role_name): <p>Not supported</p>
    ///   - [`promotion_tier(i32)`](crate::client::fluent_builders::ModifyDBInstance::promotion_tier) / [`set_promotion_tier(Option<i32>)`](crate::client::fluent_builders::ModifyDBInstance::set_promotion_tier): <p>A value that specifies the order in which a Read Replica is promoted to the primary instance after a failure of the existing primary instance.</p>  <p>Default: 1</p>  <p>Valid Values: 0 - 15</p>
    ///   - [`enable_iam_database_authentication(bool)`](crate::client::fluent_builders::ModifyDBInstance::enable_iam_database_authentication) / [`set_enable_iam_database_authentication(Option<bool>)`](crate::client::fluent_builders::ModifyDBInstance::set_enable_iam_database_authentication): <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.</p>  <p>You can enable IAM database authentication for the following database engines</p>  <p>Not applicable. Mapping Amazon IAM accounts to database accounts is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p>  <p>Default: <code>false</code> </p>
    ///   - [`enable_performance_insights(bool)`](crate::client::fluent_builders::ModifyDBInstance::enable_performance_insights) / [`set_enable_performance_insights(Option<bool>)`](crate::client::fluent_builders::ModifyDBInstance::set_enable_performance_insights): <p> <i>(Not supported by Neptune)</i> </p>
    ///   - [`performance_insights_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::performance_insights_kms_key_id) / [`set_performance_insights_kms_key_id(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_performance_insights_kms_key_id): <p> <i>(Not supported by Neptune)</i> </p>
    ///   - [`cloudwatch_logs_export_configuration(CloudwatchLogsExportConfiguration)`](crate::client::fluent_builders::ModifyDBInstance::cloudwatch_logs_export_configuration) / [`set_cloudwatch_logs_export_configuration(Option<CloudwatchLogsExportConfiguration>)`](crate::client::fluent_builders::ModifyDBInstance::set_cloudwatch_logs_export_configuration): <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB instance or DB cluster.</p>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::ModifyDBInstance::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::ModifyDBInstance::set_deletion_protection): <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting a DB Instance</a>.</p>
    /// - On success, responds with [`ModifyDbInstanceOutput`](crate::output::ModifyDbInstanceOutput) with field(s):
    ///   - [`db_instance(Option<DbInstance>)`](crate::output::ModifyDbInstanceOutput::db_instance): <p>Contains the details of an Amazon Neptune DB instance.</p>  <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
    /// - On failure, responds with [`SdkError<ModifyDBInstanceError>`](crate::error::ModifyDBInstanceError)
    pub fn modify_db_instance(&self) -> fluent_builders::ModifyDBInstance {
        fluent_builders::ModifyDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDBParameterGroup`](crate::client::fluent_builders::ModifyDBParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBParameterGroup::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBParameterGroup::set_db_parameter_group_name): <p>The name of the DB parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the name of an existing DBParameterGroup.</p> </li>  </ul>
    ///   - [`parameters(Vec<Parameter>)`](crate::client::fluent_builders::ModifyDBParameterGroup::parameters) / [`set_parameters(Option<Vec<Parameter>>)`](crate::client::fluent_builders::ModifyDBParameterGroup::set_parameters): <p>An array of parameter names, values, and the apply method for the parameter update. At least one parameter name, value, and apply method must be supplied; subsequent arguments are optional. A maximum of 20 parameters can be modified in a single request.</p>  <p>Valid Values (for the application method): <code>immediate | pending-reboot</code> </p> <note>   <p>You can use the immediate value with dynamic parameters only. You can use the pending-reboot value for both dynamic and static parameters, and changes are applied when you reboot the DB instance without failover.</p>  </note>
    /// - On success, responds with [`ModifyDbParameterGroupOutput`](crate::output::ModifyDbParameterGroupOutput) with field(s):
    ///   - [`db_parameter_group_name(Option<String>)`](crate::output::ModifyDbParameterGroupOutput::db_parameter_group_name): <p>Provides the name of the DB parameter group.</p>
    /// - On failure, responds with [`SdkError<ModifyDBParameterGroupError>`](crate::error::ModifyDBParameterGroupError)
    pub fn modify_db_parameter_group(&self) -> fluent_builders::ModifyDBParameterGroup {
        fluent_builders::ModifyDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDBSubnetGroup`](crate::client::fluent_builders::ModifyDBSubnetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBSubnetGroup::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBSubnetGroup::set_db_subnet_group_name): <p>The name for the DB subnet group. This value is stored as a lowercase string. You can't modify the default subnet group.</p>  <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>  <p>Example: <code>mySubnetgroup</code> </p>
    ///   - [`db_subnet_group_description(impl Into<String>)`](crate::client::fluent_builders::ModifyDBSubnetGroup::db_subnet_group_description) / [`set_db_subnet_group_description(Option<String>)`](crate::client::fluent_builders::ModifyDBSubnetGroup::set_db_subnet_group_description): <p>The description for the DB subnet group.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::ModifyDBSubnetGroup::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBSubnetGroup::set_subnet_ids): <p>The EC2 subnet IDs for the DB subnet group.</p>
    /// - On success, responds with [`ModifyDbSubnetGroupOutput`](crate::output::ModifyDbSubnetGroupOutput) with field(s):
    ///   - [`db_subnet_group(Option<DbSubnetGroup>)`](crate::output::ModifyDbSubnetGroupOutput::db_subnet_group): <p>Contains the details of an Amazon Neptune DB subnet group.</p>  <p>This data type is used as a response element in the <code>DescribeDBSubnetGroups</code> action.</p>
    /// - On failure, responds with [`SdkError<ModifyDBSubnetGroupError>`](crate::error::ModifyDBSubnetGroupError)
    pub fn modify_db_subnet_group(&self) -> fluent_builders::ModifyDBSubnetGroup {
        fluent_builders::ModifyDBSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyEventSubscription`](crate::client::fluent_builders::ModifyEventSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::ModifyEventSubscription::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::ModifyEventSubscription::set_subscription_name): <p>The name of the event notification subscription.</p>
    ///   - [`sns_topic_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyEventSubscription::sns_topic_arn) / [`set_sns_topic_arn(Option<String>)`](crate::client::fluent_builders::ModifyEventSubscription::set_sns_topic_arn): <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
    ///   - [`source_type(impl Into<String>)`](crate::client::fluent_builders::ModifyEventSubscription::source_type) / [`set_source_type(Option<String>)`](crate::client::fluent_builders::ModifyEventSubscription::set_source_type): <p>The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you would set this parameter to db-instance. if this value is not specified, all events are returned.</p>  <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>
    ///   - [`event_categories(Vec<String>)`](crate::client::fluent_builders::ModifyEventSubscription::event_categories) / [`set_event_categories(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyEventSubscription::set_event_categories): <p> A list of event categories for a SourceType that you want to subscribe to. You can see a list of the categories for a given SourceType by using the <b>DescribeEventCategories</b> action.</p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::ModifyEventSubscription::enabled) / [`set_enabled(Option<bool>)`](crate::client::fluent_builders::ModifyEventSubscription::set_enabled): <p> A Boolean value; set to <b>true</b> to activate the subscription.</p>
    /// - On success, responds with [`ModifyEventSubscriptionOutput`](crate::output::ModifyEventSubscriptionOutput) with field(s):
    ///   - [`event_subscription(Option<EventSubscription>)`](crate::output::ModifyEventSubscriptionOutput::event_subscription): <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    /// - On failure, responds with [`SdkError<ModifyEventSubscriptionError>`](crate::error::ModifyEventSubscriptionError)
    pub fn modify_event_subscription(&self) -> fluent_builders::ModifyEventSubscription {
        fluent_builders::ModifyEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PromoteReadReplicaDBCluster`](crate::client::fluent_builders::PromoteReadReplicaDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::PromoteReadReplicaDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::PromoteReadReplicaDBCluster::set_db_cluster_identifier): <p>Not supported.</p>
    /// - On success, responds with [`PromoteReadReplicaDbClusterOutput`](crate::output::PromoteReadReplicaDbClusterOutput) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::PromoteReadReplicaDbClusterOutput::db_cluster): <p>Contains the details of an Amazon Neptune DB cluster.</p>  <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    /// - On failure, responds with [`SdkError<PromoteReadReplicaDBClusterError>`](crate::error::PromoteReadReplicaDBClusterError)
    pub fn promote_read_replica_db_cluster(&self) -> fluent_builders::PromoteReadReplicaDBCluster {
        fluent_builders::PromoteReadReplicaDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RebootDBInstance`](crate::client::fluent_builders::RebootDBInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::RebootDBInstance::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::RebootDBInstance::set_db_instance_identifier): <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing DBInstance.</p> </li>  </ul>
    ///   - [`force_failover(bool)`](crate::client::fluent_builders::RebootDBInstance::force_failover) / [`set_force_failover(Option<bool>)`](crate::client::fluent_builders::RebootDBInstance::set_force_failover): <p> When <code>true</code>, the reboot is conducted through a MultiAZ failover.</p>  <p>Constraint: You can't specify <code>true</code> if the instance is not configured for MultiAZ.</p>
    /// - On success, responds with [`RebootDbInstanceOutput`](crate::output::RebootDbInstanceOutput) with field(s):
    ///   - [`db_instance(Option<DbInstance>)`](crate::output::RebootDbInstanceOutput::db_instance): <p>Contains the details of an Amazon Neptune DB instance.</p>  <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.</p>
    /// - On failure, responds with [`SdkError<RebootDBInstanceError>`](crate::error::RebootDBInstanceError)
    pub fn reboot_db_instance(&self) -> fluent_builders::RebootDBInstance {
        fluent_builders::RebootDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveRoleFromDBCluster`](crate::client::fluent_builders::RemoveRoleFromDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::RemoveRoleFromDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::RemoveRoleFromDBCluster::set_db_cluster_identifier): <p>The name of the DB cluster to disassociate the IAM role from.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveRoleFromDBCluster::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::RemoveRoleFromDBCluster::set_role_arn): <p>The Amazon Resource Name (ARN) of the IAM role to disassociate from the DB cluster, for example <code>arn:aws:iam::123456789012:role/NeptuneAccessRole</code>.</p>
    ///   - [`feature_name(impl Into<String>)`](crate::client::fluent_builders::RemoveRoleFromDBCluster::feature_name) / [`set_feature_name(Option<String>)`](crate::client::fluent_builders::RemoveRoleFromDBCluster::set_feature_name): <p>The name of the feature for the DB cluster that the IAM role is to be disassociated from. For the list of supported feature names, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-other-apis.html#DescribeDBEngineVersions">DescribeDBEngineVersions</a>.</p>
    /// - On success, responds with [`RemoveRoleFromDbClusterOutput`](crate::output::RemoveRoleFromDbClusterOutput)

    /// - On failure, responds with [`SdkError<RemoveRoleFromDBClusterError>`](crate::error::RemoveRoleFromDBClusterError)
    pub fn remove_role_from_db_cluster(&self) -> fluent_builders::RemoveRoleFromDBCluster {
        fluent_builders::RemoveRoleFromDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveSourceIdentifierFromSubscription`](crate::client::fluent_builders::RemoveSourceIdentifierFromSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::RemoveSourceIdentifierFromSubscription::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::RemoveSourceIdentifierFromSubscription::set_subscription_name): <p>The name of the event notification subscription you want to remove a source identifier from.</p>
    ///   - [`source_identifier(impl Into<String>)`](crate::client::fluent_builders::RemoveSourceIdentifierFromSubscription::source_identifier) / [`set_source_identifier(Option<String>)`](crate::client::fluent_builders::RemoveSourceIdentifierFromSubscription::set_source_identifier): <p> The source identifier to be removed from the subscription, such as the <b>DB instance identifier</b> for a DB instance or the name of a security group.</p>
    /// - On success, responds with [`RemoveSourceIdentifierFromSubscriptionOutput`](crate::output::RemoveSourceIdentifierFromSubscriptionOutput) with field(s):
    ///   - [`event_subscription(Option<EventSubscription>)`](crate::output::RemoveSourceIdentifierFromSubscriptionOutput::event_subscription): <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    /// - On failure, responds with [`SdkError<RemoveSourceIdentifierFromSubscriptionError>`](crate::error::RemoveSourceIdentifierFromSubscriptionError)
    pub fn remove_source_identifier_from_subscription(
        &self,
    ) -> fluent_builders::RemoveSourceIdentifierFromSubscription {
        fluent_builders::RemoveSourceIdentifierFromSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveTagsFromResource`](crate::client::fluent_builders::RemoveTagsFromResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_name(impl Into<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::resource_name) / [`set_resource_name(Option<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::set_resource_name): <p>The Amazon Neptune resource that the tags are removed from. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveTagsFromResource::set_tag_keys): <p>The tag key (name) of the tag to be removed.</p>
    /// - On success, responds with [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)

    /// - On failure, responds with [`SdkError<RemoveTagsFromResourceError>`](crate::error::RemoveTagsFromResourceError)
    pub fn remove_tags_from_resource(&self) -> fluent_builders::RemoveTagsFromResource {
        fluent_builders::RemoveTagsFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResetDBClusterParameterGroup`](crate::client::fluent_builders::ResetDBClusterParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ResetDBClusterParameterGroup::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ResetDBClusterParameterGroup::set_db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group to reset.</p>
    ///   - [`reset_all_parameters(bool)`](crate::client::fluent_builders::ResetDBClusterParameterGroup::reset_all_parameters) / [`set_reset_all_parameters(bool)`](crate::client::fluent_builders::ResetDBClusterParameterGroup::set_reset_all_parameters): <p>A value that is set to <code>true</code> to reset all parameters in the DB cluster parameter group to their default values, and <code>false</code> otherwise. You can't use this parameter if there is a list of parameter names specified for the <code>Parameters</code> parameter.</p>
    ///   - [`parameters(Vec<Parameter>)`](crate::client::fluent_builders::ResetDBClusterParameterGroup::parameters) / [`set_parameters(Option<Vec<Parameter>>)`](crate::client::fluent_builders::ResetDBClusterParameterGroup::set_parameters): <p>A list of parameter names in the DB cluster parameter group to reset to the default values. You can't use this parameter if the <code>ResetAllParameters</code> parameter is set to <code>true</code>.</p>
    /// - On success, responds with [`ResetDbClusterParameterGroupOutput`](crate::output::ResetDbClusterParameterGroupOutput) with field(s):
    ///   - [`db_cluster_parameter_group_name(Option<String>)`](crate::output::ResetDbClusterParameterGroupOutput::db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 letters or numbers.</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>  </ul> <note>   <p>This value is stored as a lowercase string.</p>  </note>
    /// - On failure, responds with [`SdkError<ResetDBClusterParameterGroupError>`](crate::error::ResetDBClusterParameterGroupError)
    pub fn reset_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::ResetDBClusterParameterGroup {
        fluent_builders::ResetDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResetDBParameterGroup`](crate::client::fluent_builders::ResetDBParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ResetDBParameterGroup::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ResetDBParameterGroup::set_db_parameter_group_name): <p>The name of the DB parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the name of an existing DBParameterGroup.</p> </li>  </ul>
    ///   - [`reset_all_parameters(bool)`](crate::client::fluent_builders::ResetDBParameterGroup::reset_all_parameters) / [`set_reset_all_parameters(bool)`](crate::client::fluent_builders::ResetDBParameterGroup::set_reset_all_parameters): <p>Specifies whether (<code>true</code>) or not (<code>false</code>) to reset all parameters in the DB parameter group to default values.</p>  <p>Default: <code>true</code> </p>
    ///   - [`parameters(Vec<Parameter>)`](crate::client::fluent_builders::ResetDBParameterGroup::parameters) / [`set_parameters(Option<Vec<Parameter>>)`](crate::client::fluent_builders::ResetDBParameterGroup::set_parameters): <p>To reset the entire DB parameter group, specify the <code>DBParameterGroup</code> name and <code>ResetAllParameters</code> parameters. To reset specific parameters, provide a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. A maximum of 20 parameters can be modified in a single request.</p>  <p>Valid Values (for Apply method): <code>pending-reboot</code> </p>
    /// - On success, responds with [`ResetDbParameterGroupOutput`](crate::output::ResetDbParameterGroupOutput) with field(s):
    ///   - [`db_parameter_group_name(Option<String>)`](crate::output::ResetDbParameterGroupOutput::db_parameter_group_name): <p>Provides the name of the DB parameter group.</p>
    /// - On failure, responds with [`SdkError<ResetDBParameterGroupError>`](crate::error::ResetDBParameterGroupError)
    pub fn reset_db_parameter_group(&self) -> fluent_builders::ResetDBParameterGroup {
        fluent_builders::ResetDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreDBClusterFromSnapshot`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`availability_zones(Vec<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::availability_zones) / [`set_availability_zones(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_availability_zones): <p>Provides the list of EC2 Availability Zones that instances in the restored DB cluster can be created in.</p>
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_db_cluster_identifier): <p>The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>  <p>Example: <code>my-snapshot-id</code> </p>
    ///   - [`snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::snapshot_identifier) / [`set_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_snapshot_identifier): <p>The identifier for the DB snapshot or DB cluster snapshot to restore from.</p>  <p>You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing Snapshot.</p> </li>  </ul>
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_engine): <p>The database engine to use for the new DB cluster.</p>  <p>Default: The same as source</p>  <p>Constraint: Must be compatible with the engine of the source</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_engine_version): <p>The version of the database engine to use for the new DB cluster.</p>
    ///   - [`port(i32)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_port): <p>The port number on which the new DB cluster accepts connections.</p>  <p>Constraints: Value must be <code>1150-65535</code> </p>  <p>Default: The same port as the original DB cluster.</p>
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_db_subnet_group_name): <p>The name of the DB subnet group to use for the new DB cluster.</p>  <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>  <p>Example: <code>mySubnetgroup</code> </p>
    ///   - [`database_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::database_name) / [`set_database_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_database_name): <p>Not supported.</p>
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_option_group_name): <p> <i>(Not supported by Neptune)</i> </p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_vpc_security_group_ids): <p>A list of VPC security groups that the new DB cluster will belong to.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_tags): <p>The tags to be assigned to the restored DB cluster.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_kms_key_id): <p>The Amazon KMS key identifier to use when restoring an encrypted DB cluster from a DB snapshot or DB cluster snapshot.</p>  <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>  <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following will occur:</p>  <ul>   <li> <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB cluster snapshot.</p> </li>   <li> <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is not encrypted, then the restored DB cluster is not encrypted.</p> </li>  </ul>
    ///   - [`enable_iam_database_authentication(bool)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::enable_iam_database_authentication) / [`set_enable_iam_database_authentication(Option<bool>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_enable_iam_database_authentication): <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.</p>  <p>Default: <code>false</code> </p>
    ///   - [`enable_cloudwatch_logs_exports(Vec<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::enable_cloudwatch_logs_exports) / [`set_enable_cloudwatch_logs_exports(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_enable_cloudwatch_logs_exports): <p>The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs.</p>
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group to associate with the new DB cluster.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>  </ul>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_deletion_protection): <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. </p>
    ///   - [`copy_tags_to_snapshot(bool)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::copy_tags_to_snapshot) / [`set_copy_tags_to_snapshot(Option<bool>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_copy_tags_to_snapshot): <p> <i>If set to <code>true</code>, tags are copied to any snapshot of the restored DB cluster that is created.</i> </p>
    /// - On success, responds with [`RestoreDbClusterFromSnapshotOutput`](crate::output::RestoreDbClusterFromSnapshotOutput) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::RestoreDbClusterFromSnapshotOutput::db_cluster): <p>Contains the details of an Amazon Neptune DB cluster.</p>  <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    /// - On failure, responds with [`SdkError<RestoreDBClusterFromSnapshotError>`](crate::error::RestoreDBClusterFromSnapshotError)
    pub fn restore_db_cluster_from_snapshot(
        &self,
    ) -> fluent_builders::RestoreDBClusterFromSnapshot {
        fluent_builders::RestoreDBClusterFromSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreDBClusterToPointInTime`](crate::client::fluent_builders::RestoreDBClusterToPointInTime) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_db_cluster_identifier): <p>The name of the new DB cluster to be created.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>
    ///   - [`restore_type(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::restore_type) / [`set_restore_type(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_restore_type): <p>The type of restore to be performed. You can specify one of the following values:</p>  <ul>   <li> <p> <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.</p> </li>   <li> <p> <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.</p> </li>  </ul>  <p>If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the source DB cluster.</p>
    ///   - [`source_db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::source_db_cluster_identifier) / [`set_source_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_source_db_cluster_identifier): <p>The identifier of the source DB cluster from which to restore.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing DBCluster.</p> </li>  </ul>
    ///   - [`restore_to_time(DateTime)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::restore_to_time) / [`set_restore_to_time(Option<DateTime>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_restore_to_time): <p>The date and time to restore the DB cluster to.</p>  <p>Valid Values: Value must be a time in Universal Coordinated Time (UTC) format</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be before the latest restorable time for the DB instance</p> </li>   <li> <p>Must be specified if <code>UseLatestRestorableTime</code> parameter is not provided</p> </li>   <li> <p>Cannot be specified if <code>UseLatestRestorableTime</code> parameter is true</p> </li>   <li> <p>Cannot be specified if <code>RestoreType</code> parameter is <code>copy-on-write</code> </p> </li>  </ul>  <p>Example: <code>2015-03-07T23:45:00Z</code> </p>
    ///   - [`use_latest_restorable_time(bool)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::use_latest_restorable_time) / [`set_use_latest_restorable_time(bool)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_use_latest_restorable_time): <p>A value that is set to <code>true</code> to restore the DB cluster to the latest restorable backup time, and <code>false</code> otherwise.</p>  <p>Default: <code>false</code> </p>  <p>Constraints: Cannot be specified if <code>RestoreToTime</code> parameter is provided.</p>
    ///   - [`port(i32)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_port): <p>The port number on which the new DB cluster accepts connections.</p>  <p>Constraints: Value must be <code>1150-65535</code> </p>  <p>Default: The same port as the original DB cluster.</p>
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_db_subnet_group_name): <p>The DB subnet group name to use for the new DB cluster.</p>  <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>  <p>Example: <code>mySubnetgroup</code> </p>
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_option_group_name): <p> <i>(Not supported by Neptune)</i> </p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_vpc_security_group_ids): <p>A list of VPC security groups that the new DB cluster belongs to.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_tags): <p>The tags to be applied to the restored DB cluster.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_kms_key_id): <p>The Amazon KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB cluster.</p>  <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>  <p>You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different than the KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS key identified by the <code>KmsKeyId</code> parameter.</p>  <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following will occur:</p>  <ul>   <li> <p>If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the source DB cluster.</p> </li>   <li> <p>If the DB cluster is not encrypted, then the restored DB cluster is not encrypted.</p> </li>  </ul>  <p>If <code>DBClusterIdentifier</code> refers to a DB cluster that is not encrypted, then the restore request is rejected.</p>
    ///   - [`enable_iam_database_authentication(bool)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::enable_iam_database_authentication) / [`set_enable_iam_database_authentication(Option<bool>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_enable_iam_database_authentication): <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.</p>  <p>Default: <code>false</code> </p>
    ///   - [`enable_cloudwatch_logs_exports(Vec<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::enable_cloudwatch_logs_exports) / [`set_enable_cloudwatch_logs_exports(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_enable_cloudwatch_logs_exports): <p>The list of logs that the restored DB cluster is to export to CloudWatch Logs.</p>
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group to associate with the new DB cluster.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>  </ul>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_deletion_protection): <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. </p>
    /// - On success, responds with [`RestoreDbClusterToPointInTimeOutput`](crate::output::RestoreDbClusterToPointInTimeOutput) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::RestoreDbClusterToPointInTimeOutput::db_cluster): <p>Contains the details of an Amazon Neptune DB cluster.</p>  <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    /// - On failure, responds with [`SdkError<RestoreDBClusterToPointInTimeError>`](crate::error::RestoreDBClusterToPointInTimeError)
    pub fn restore_db_cluster_to_point_in_time(
        &self,
    ) -> fluent_builders::RestoreDBClusterToPointInTime {
        fluent_builders::RestoreDBClusterToPointInTime::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartDBCluster`](crate::client::fluent_builders::StartDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::StartDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::StartDBCluster::set_db_cluster_identifier): <p>The DB cluster identifier of the Neptune DB cluster to be started. This parameter is stored as a lowercase string.</p>
    /// - On success, responds with [`StartDbClusterOutput`](crate::output::StartDbClusterOutput) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::StartDbClusterOutput::db_cluster): <p>Contains the details of an Amazon Neptune DB cluster.</p>  <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    /// - On failure, responds with [`SdkError<StartDBClusterError>`](crate::error::StartDBClusterError)
    pub fn start_db_cluster(&self) -> fluent_builders::StartDBCluster {
        fluent_builders::StartDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopDBCluster`](crate::client::fluent_builders::StopDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::StopDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::StopDBCluster::set_db_cluster_identifier): <p>The DB cluster identifier of the Neptune DB cluster to be stopped. This parameter is stored as a lowercase string.</p>
    /// - On success, responds with [`StopDbClusterOutput`](crate::output::StopDbClusterOutput) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::StopDbClusterOutput::db_cluster): <p>Contains the details of an Amazon Neptune DB cluster.</p>  <p>This data type is used as a response element in the <code>DescribeDBClusters</code> action.</p>
    /// - On failure, responds with [`SdkError<StopDBClusterError>`](crate::error::StopDBClusterError)
    pub fn stop_db_cluster(&self) -> fluent_builders::StopDBCluster {
        fluent_builders::StopDBCluster::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddRoleToDBCluster`.
    ///
    /// <p>Associates an Identity and Access Management (IAM) role with an Neptune DB cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddRoleToDBCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_role_to_db_cluster_input::Builder,
    }
    impl AddRoleToDBCluster {
        /// Creates a new `AddRoleToDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddRoleToDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::AddRoleToDBClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster to associate the IAM role with.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The name of the DB cluster to associate the IAM role with.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the Neptune DB cluster, for example <code>arn:aws:iam::123456789012:role/NeptuneAccessRole</code>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the Neptune DB cluster, for example <code>arn:aws:iam::123456789012:role/NeptuneAccessRole</code>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The name of the feature for the Neptune DB cluster that the IAM role is to be associated with. For the list of supported feature names, see <a href="neptune/latest/userguide/api-other-apis.html#DBEngineVersion">DBEngineVersion</a>.</p>
        pub fn feature_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature_name(input.into());
            self
        }
        /// <p>The name of the feature for the Neptune DB cluster that the IAM role is to be associated with. For the list of supported feature names, see <a href="neptune/latest/userguide/api-other-apis.html#DBEngineVersion">DBEngineVersion</a>.</p>
        pub fn set_feature_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feature_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddSourceIdentifierToSubscription`.
    ///
    /// <p>Adds a source identifier to an existing event notification subscription.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddSourceIdentifierToSubscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_source_identifier_to_subscription_input::Builder,
    }
    impl AddSourceIdentifierToSubscription {
        /// Creates a new `AddSourceIdentifierToSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddSourceIdentifierToSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::AddSourceIdentifierToSubscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event notification subscription you want to add a source identifier to.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(input.into());
            self
        }
        /// <p>The name of the event notification subscription you want to add a source identifier to.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p>The identifier of the event source to be added.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be supplied.</p> </li>
        /// </ul>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_identifier(input.into());
            self
        }
        /// <p>The identifier of the event source to be added.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be supplied.</p> </li>
        /// </ul>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddTagsToResource`.
    ///
    /// <p>Adds metadata tags to an Amazon Neptune resource. These tags can also be used with cost allocation reporting to track cost associated with Amazon Neptune resources, or used in a Condition statement in an IAM policy for Amazon Neptune.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTagsToResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_tags_to_resource_input::Builder,
    }
    impl AddTagsToResource {
        /// Creates a new `AddTagsToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Neptune resource that the tags are added to. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The Amazon Neptune resource that the tags are added to. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Amazon Neptune resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be assigned to the Amazon Neptune resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ApplyPendingMaintenanceAction`.
    ///
    /// <p>Applies a pending maintenance action to a resource (for example, to a DB instance).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ApplyPendingMaintenanceAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::apply_pending_maintenance_action_input::Builder,
    }
    impl ApplyPendingMaintenanceAction {
        /// Creates a new `ApplyPendingMaintenanceAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ApplyPendingMaintenanceActionOutput,
            aws_smithy_http::result::SdkError<crate::error::ApplyPendingMaintenanceActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that the pending maintenance action applies to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that the pending maintenance action applies to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>system-update</code>, <code>db-upgrade</code> </p>
        pub fn apply_action(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.apply_action(input.into());
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>system-update</code>, <code>db-upgrade</code> </p>
        pub fn set_apply_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_apply_action(input);
            self
        }
        /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type <code>immediate</code> can't be undone.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>immediate</code> - Apply the maintenance action immediately.</p> </li>
        /// <li> <p> <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the resource.</p> </li>
        /// <li> <p> <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.</p> </li>
        /// </ul>
        pub fn opt_in_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.opt_in_type(input.into());
            self
        }
        /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type <code>immediate</code> can't be undone.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>immediate</code> - Apply the maintenance action immediately.</p> </li>
        /// <li> <p> <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the resource.</p> </li>
        /// <li> <p> <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.</p> </li>
        /// </ul>
        pub fn set_opt_in_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_opt_in_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyDBClusterParameterGroup`.
    ///
    /// <p>Copies the specified DB cluster parameter group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopyDBClusterParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::copy_db_cluster_parameter_group_input::Builder,
    }
    impl CopyDBClusterParameterGroup {
        /// Creates a new `CopyDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyDBClusterParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid DB cluster parameter group.</p> </li>
        /// <li> <p>If the source DB cluster parameter group is in the same Amazon Region as the copy, specify a valid DB parameter group identifier, for example <code>my-db-cluster-param-group</code>, or a valid ARN.</p> </li>
        /// <li> <p>If the source DB parameter group is in a different Amazon Region than the copy, specify a valid DB cluster parameter group ARN, for example <code>arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1</code>.</p> </li>
        /// </ul>
        pub fn source_db_cluster_parameter_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .source_db_cluster_parameter_group_identifier(input.into());
            self
        }
        /// <p>The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid DB cluster parameter group.</p> </li>
        /// <li> <p>If the source DB cluster parameter group is in the same Amazon Region as the copy, specify a valid DB parameter group identifier, for example <code>my-db-cluster-param-group</code>, or a valid ARN.</p> </li>
        /// <li> <p>If the source DB parameter group is in a different Amazon Region than the copy, specify a valid DB cluster parameter group ARN, for example <code>arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1</code>.</p> </li>
        /// </ul>
        pub fn set_source_db_cluster_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_source_db_cluster_parameter_group_identifier(input);
            self
        }
        /// <p>The identifier for the copied DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Cannot be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-param-group1</code> </p>
        pub fn target_db_cluster_parameter_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .target_db_cluster_parameter_group_identifier(input.into());
            self
        }
        /// <p>The identifier for the copied DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Cannot be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-param-group1</code> </p>
        pub fn set_target_db_cluster_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_target_db_cluster_parameter_group_identifier(input);
            self
        }
        /// <p>A description for the copied DB cluster parameter group.</p>
        pub fn target_db_cluster_parameter_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .target_db_cluster_parameter_group_description(input.into());
            self
        }
        /// <p>A description for the copied DB cluster parameter group.</p>
        pub fn set_target_db_cluster_parameter_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_target_db_cluster_parameter_group_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the copied DB cluster parameter group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be assigned to the copied DB cluster parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyDBClusterSnapshot`.
    ///
    /// <p>Copies a snapshot of a DB cluster.</p>
    /// <p>To copy a DB cluster snapshot from a shared manual DB cluster snapshot, <code>SourceDBClusterSnapshotIdentifier</code> must be the Amazon Resource Name (ARN) of the shared DB cluster snapshot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopyDBClusterSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::copy_db_cluster_snapshot_input::Builder,
    }
    impl CopyDBClusterSnapshot {
        /// Creates a new `CopyDBClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyDbClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyDBClusterSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the DB cluster snapshot to copy. This parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid system snapshot in the "available" state.</p> </li>
        /// <li> <p>Specify a valid DB snapshot identifier.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code> </p>
        pub fn source_db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .source_db_cluster_snapshot_identifier(input.into());
            self
        }
        /// <p>The identifier of the DB cluster snapshot to copy. This parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid system snapshot in the "available" state.</p> </li>
        /// <li> <p>Specify a valid DB snapshot identifier.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code> </p>
        pub fn set_source_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot2</code> </p>
        pub fn target_db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .target_db_cluster_snapshot_identifier(input.into());
            self
        }
        /// <p>The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot2</code> </p>
        pub fn set_target_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The Amazon Amazon KMS key ID for an encrypted DB cluster snapshot. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.</p>
        /// <p>If you copy an encrypted DB cluster snapshot from your Amazon account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new KMS encryption key. If you don't specify a value for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is encrypted with the same KMS key as the source DB cluster snapshot.</p>
        /// <p>If you copy an encrypted DB cluster snapshot that is shared from another Amazon account, then you must specify a value for <code>KmsKeyId</code>.</p>
        /// <p> KMS encryption keys are specific to the Amazon Region that they are created in, and you can't use encryption keys from one Amazon Region in another Amazon Region.</p>
        /// <p>You cannot encrypt an unencrypted DB cluster snapshot when you copy it. If you try to copy an unencrypted DB cluster snapshot and specify a value for the KmsKeyId parameter, an error is returned.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The Amazon Amazon KMS key ID for an encrypted DB cluster snapshot. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.</p>
        /// <p>If you copy an encrypted DB cluster snapshot from your Amazon account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new KMS encryption key. If you don't specify a value for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is encrypted with the same KMS key as the source DB cluster snapshot.</p>
        /// <p>If you copy an encrypted DB cluster snapshot that is shared from another Amazon account, then you must specify a value for <code>KmsKeyId</code>.</p>
        /// <p> KMS encryption keys are specific to the Amazon Region that they are created in, and you can't use encryption keys from one Amazon Region in another Amazon Region.</p>
        /// <p>You cannot encrypt an unencrypted DB cluster snapshot when you copy it. If you try to copy an unencrypted DB cluster snapshot and specify a value for the KmsKeyId parameter, an error is returned.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>Not currently supported.</p>
        pub fn pre_signed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pre_signed_url(input.into());
            self
        }
        /// <p>Not currently supported.</p>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pre_signed_url(input);
            self
        }
        /// <p>True to copy all tags from the source DB cluster snapshot to the target DB cluster snapshot, and otherwise false. The default is false.</p>
        pub fn copy_tags(mut self, input: bool) -> Self {
            self.inner = self.inner.copy_tags(input);
            self
        }
        /// <p>True to copy all tags from the source DB cluster snapshot to the target DB cluster snapshot, and otherwise false. The default is false.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the new DB cluster snapshot copy.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to assign to the new DB cluster snapshot copy.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyDBParameterGroup`.
    ///
    /// <p>Copies the specified DB parameter group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopyDBParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::copy_db_parameter_group_input::Builder,
    }
    impl CopyDBParameterGroup {
        /// Creates a new `CopyDBParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyDbParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyDBParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier or ARN for the source DB parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid DB parameter group.</p> </li>
        /// <li> <p>Must specify a valid DB parameter group identifier, for example <code>my-db-param-group</code>, or a valid ARN.</p> </li>
        /// </ul>
        pub fn source_db_parameter_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .source_db_parameter_group_identifier(input.into());
            self
        }
        /// <p>The identifier or ARN for the source DB parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid DB parameter group.</p> </li>
        /// <li> <p>Must specify a valid DB parameter group identifier, for example <code>my-db-param-group</code>, or a valid ARN.</p> </li>
        /// </ul>
        pub fn set_source_db_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_db_parameter_group_identifier(input);
            self
        }
        /// <p>The identifier for the copied DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Cannot be null, empty, or blank.</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-db-parameter-group</code> </p>
        pub fn target_db_parameter_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .target_db_parameter_group_identifier(input.into());
            self
        }
        /// <p>The identifier for the copied DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Cannot be null, empty, or blank.</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-db-parameter-group</code> </p>
        pub fn set_target_db_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_parameter_group_identifier(input);
            self
        }
        /// <p>A description for the copied DB parameter group.</p>
        pub fn target_db_parameter_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .target_db_parameter_group_description(input.into());
            self
        }
        /// <p>A description for the copied DB parameter group.</p>
        pub fn set_target_db_parameter_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_parameter_group_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the copied DB parameter group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be assigned to the copied DB parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBCluster`.
    ///
    /// <p>Creates a new Amazon Neptune DB cluster.</p>
    /// <p>You can use the <code>ReplicationSourceIdentifier</code> parameter to create the DB cluster as a Read Replica of another DB cluster or Amazon Neptune DB instance.</p>
    /// <p>Note that when you create a new cluster using <code>CreateDBCluster</code> directly, deletion protection is disabled by default (when you create a new production cluster in the console, deletion protection is enabled by default). You can only delete a DB cluster if its <code>DeletionProtection</code> field is set to <code>false</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDBCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_db_cluster_input::Builder,
    }
    impl CreateDBCluster {
        /// Creates a new `CreateDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AvailabilityZones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>A list of EC2 Availability Zones that instances in the DB cluster can be created in.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zones(input.into());
            self
        }
        /// <p>A list of EC2 Availability Zones that instances in the DB cluster can be created in.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_availability_zones(input);
            self
        }
        /// <p>The number of days for which automated backups are retained. You must specify a minimum value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be a value from 1 to 35</p> </li>
        /// </ul>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.inner = self.inner.backup_retention_period(input);
            self
        }
        /// <p>The number of days for which automated backups are retained. You must specify a minimum value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be a value from 1 to 35</p> </li>
        /// </ul>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_backup_retention_period(input);
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn character_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.character_set_name(input.into());
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn set_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_character_set_name(input);
            self
        }
        /// <p> <i>If set to <code>true</code>, tags are copied to any snapshot of the DB cluster that is created.</i> </p>
        pub fn copy_tags_to_snapshot(mut self, input: bool) -> Self {
            self.inner = self.inner.copy_tags_to_snapshot(input);
            self
        }
        /// <p> <i>If set to <code>true</code>, tags are copied to any snapshot of the DB cluster that is created.</i> </p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags_to_snapshot(input);
            self
        }
        /// <p>The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon Neptune will not create a database in the DB cluster you are creating.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(input.into());
            self
        }
        /// <p>The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon Neptune will not create a database in the DB cluster you are creating.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The DB cluster identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code> </p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The DB cluster identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code> </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p> The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted, the default is used.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(input.into());
            self
        }
        /// <p> The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted, the default is used.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of EC2 VPC security groups to associate with this DB cluster.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(input.into());
            self
        }
        /// <p>A list of EC2 VPC security groups to associate with this DB cluster.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>A DB subnet group to associate with this DB cluster.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code> </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(input.into());
            self
        }
        /// <p>A DB subnet group to associate with this DB cluster.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code> </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p>The name of the database engine to be used for this DB cluster.</p>
        /// <p>Valid Values: <code>neptune</code> </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(input.into());
            self
        }
        /// <p>The name of the database engine to be used for this DB cluster.</p>
        /// <p>Valid Values: <code>neptune</code> </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The version number of the database engine to use for the new DB cluster.</p>
        /// <p>Example: <code>1.0.2.1</code> </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The version number of the database engine to use for the new DB cluster.</p>
        /// <p>Example: <code>1.0.2.1</code> </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The port number on which the instances in the DB cluster accept connections.</p>
        /// <p> Default: <code>8182</code> </p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port number on which the instances in the DB cluster accept connections.</p>
        /// <p> Default: <code>8182</code> </p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_username(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_username(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(input.into());
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred Maintenance Window</a> in the <i>Amazon Neptune User Guide.</i> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>
        /// <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>
        /// <li> <p>Must not conflict with the preferred maintenance window.</p> </li>
        /// <li> <p>Must be at least 30 minutes.</p> </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_backup_window(input.into());
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred Maintenance Window</a> in the <i>Amazon Neptune User Guide.</i> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>
        /// <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>
        /// <li> <p>Must not conflict with the preferred maintenance window.</p> </li>
        /// <li> <p>Must be at least 30 minutes.</p> </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_backup_window(input);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred Maintenance Window</a> in the <i>Amazon Neptune User Guide.</i> </p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.preferred_maintenance_window(input.into());
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred Maintenance Window</a> in the <i>Amazon Neptune User Guide.</i> </p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a Read Replica.</p>
        pub fn replication_source_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_source_identifier(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a Read Replica.</p>
        pub fn set_replication_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_source_identifier(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the new DB cluster.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to assign to the new DB cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies whether the DB cluster is encrypted.</p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.inner = self.inner.storage_encrypted(input);
            self
        }
        /// <p>Specifies whether the DB cluster is encrypted.</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_storage_encrypted(input);
            self
        }
        /// <p>The Amazon KMS key identifier for an encrypted DB cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
        /// <p>If an encryption key is not specified in <code>KmsKeyId</code>:</p>
        /// <ul>
        /// <li> <p>If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then Amazon Neptune will use the encryption key used to encrypt the source. Otherwise, Amazon Neptune will use your default encryption key.</p> </li>
        /// <li> <p>If the <code>StorageEncrypted</code> parameter is true and <code>ReplicationSourceIdentifier</code> is not specified, then Amazon Neptune will use your default encryption key.</p> </li>
        /// </ul>
        /// <p>Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a different default encryption key for each Amazon Region.</p>
        /// <p>If you create a Read Replica of an encrypted DB cluster in another Amazon Region, you must set <code>KmsKeyId</code> to a KMS key ID that is valid in the destination Amazon Region. This key is used to encrypt the Read Replica in that Amazon Region.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The Amazon KMS key identifier for an encrypted DB cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
        /// <p>If an encryption key is not specified in <code>KmsKeyId</code>:</p>
        /// <ul>
        /// <li> <p>If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then Amazon Neptune will use the encryption key used to encrypt the source. Otherwise, Amazon Neptune will use your default encryption key.</p> </li>
        /// <li> <p>If the <code>StorageEncrypted</code> parameter is true and <code>ReplicationSourceIdentifier</code> is not specified, then Amazon Neptune will use your default encryption key.</p> </li>
        /// </ul>
        /// <p>Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a different default encryption key for each Amazon Region.</p>
        /// <p>If you create a Read Replica of an encrypted DB cluster in another Amazon Region, you must set <code>KmsKeyId</code> to a KMS key ID that is valid in the destination Amazon Region. This key is used to encrypt the Read Replica in that Amazon Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn pre_signed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pre_signed_url(input.into());
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pre_signed_url(input);
            self
        }
        /// <p>If set to <code>true</code>, enables Amazon Identity and Access Management (IAM) authentication for the entire DB cluster (this cannot be set at an instance level).</p>
        /// <p>Default: <code>false</code>.</p>
        pub fn enable_iam_database_authentication(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_iam_database_authentication(input);
            self
        }
        /// <p>If set to <code>true</code>, enables Amazon Identity and Access Management (IAM) authentication for the entire DB cluster (this cannot be set at an instance level).</p>
        /// <p>Default: <code>false</code>.</p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_iam_database_authentication(input);
            self
        }
        /// Appends an item to `EnableCloudwatchLogsExports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.enable_cloudwatch_logs_exports(input.into());
            self
        }
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_enable_cloudwatch_logs_exports(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is enabled.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.inner = self.inner.deletion_protection(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is enabled.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBClusterEndpoint`.
    ///
    /// <p>Creates a new custom endpoint and associates it with an Amazon Neptune DB cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDBClusterEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_db_cluster_endpoint_input::Builder,
    }
    impl CreateDBClusterEndpoint {
        /// Creates a new `CreateDBClusterEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbClusterEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBClusterEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The identifier to use for the new endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_endpoint_identifier(input.into());
            self
        }
        /// <p>The identifier to use for the new endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_endpoint_identifier(input);
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_type(input.into());
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_type(input);
            self
        }
        /// Appends an item to `StaticMembers`.
        ///
        /// To override the contents of this collection use [`set_static_members`](Self::set_static_members).
        ///
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn static_members(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.static_members(input.into());
            self
        }
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn set_static_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_static_members(input);
            self
        }
        /// Appends an item to `ExcludedMembers`.
        ///
        /// To override the contents of this collection use [`set_excluded_members`](Self::set_excluded_members).
        ///
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
        pub fn excluded_members(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.excluded_members(input.into());
            self
        }
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
        pub fn set_excluded_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_excluded_members(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Amazon Neptune resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be assigned to the Amazon Neptune resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBClusterParameterGroup`.
    ///
    /// <p>Creates a new DB cluster parameter group.</p>
    /// <p>Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.</p>
    /// <p> A DB cluster parameter group is initially created with the default parameters for the database engine used by instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after creating it using <code>ModifyDBClusterParameterGroup</code>. Once you've created a DB cluster parameter group, you need to associate it with your DB cluster using <code>ModifyDBCluster</code>. When you associate a new DB cluster parameter group with a running DB cluster, you need to reboot the DB instances in the DB cluster without failover for the new DB cluster parameter group and associated settings to take effect.</p> <important>
    /// <p>After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon Neptune to fully complete the create action before the DB cluster parameter group is used as the default for a new DB cluster. This is especially important for parameters that are critical when creating the default database for a DB cluster, such as the character set for the default database defined by the <code>character_set_database</code> parameter. You can use the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon Neptune console</a> or the <code>DescribeDBClusterParameters</code> command to verify that your DB cluster parameter group has been created or modified.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDBClusterParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_db_cluster_parameter_group_input::Builder,
    }
    impl CreateDBClusterParameterGroup {
        /// Creates a new `CreateDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBClusterParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul> <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul> <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// <p>The DB cluster parameter group family name. A DB cluster parameter group can be associated with one and only one DB cluster parameter group family, and can be applied only to a DB cluster running a database engine and engine version compatible with that DB cluster parameter group family.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_family(input.into());
            self
        }
        /// <p>The DB cluster parameter group family name. A DB cluster parameter group can be associated with one and only one DB cluster parameter group family, and can be applied only to a DB cluster running a database engine and engine version compatible with that DB cluster parameter group family.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_family(input);
            self
        }
        /// <p>The description for the DB cluster parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the DB cluster parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the new DB cluster parameter group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be assigned to the new DB cluster parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBClusterSnapshot`.
    ///
    /// <p>Creates a snapshot of a DB cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDBClusterSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_db_cluster_snapshot_input::Builder,
    }
    impl CreateDBClusterSnapshot {
        /// Creates a new `CreateDBClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBClusterSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the DB cluster snapshot. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1-snapshot1</code> </p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(input.into());
            self
        }
        /// <p>The identifier of the DB cluster snapshot. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1-snapshot1</code> </p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The identifier of the DB cluster to create a snapshot for. This parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBCluster.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code> </p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The identifier of the DB cluster to create a snapshot for. This parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBCluster.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code> </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the DB cluster snapshot.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be assigned to the DB cluster snapshot.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBInstance`.
    ///
    /// <p>Creates a new DB instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDBInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_db_instance_input::Builder,
    }
    impl CreateDBInstance {
        /// Creates a new `CreateDBInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Not supported.</p>
        pub fn db_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_name(input.into());
            self
        }
        /// <p>Not supported.</p>
        pub fn set_db_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_db_name(input);
            self
        }
        /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code> </p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(input.into());
            self
        }
        /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code> </p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.inner = self.inner.allocated_storage(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_allocated_storage(input);
            self
        }
        /// <p>The compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>. Not all DB instance classes are available in all Amazon Regions.</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_class(input.into());
            self
        }
        /// <p>The compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>. Not all DB instance classes are available in all Amazon Regions.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_class(input);
            self
        }
        /// <p>The name of the database engine to be used for this instance.</p>
        /// <p>Valid Values: <code>neptune</code> </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(input.into());
            self
        }
        /// <p>The name of the database engine to be used for this instance.</p>
        /// <p>Valid Values: <code>neptune</code> </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_username(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_username(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// Appends an item to `DBSecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_db_security_groups`](Self::set_db_security_groups).
        ///
        /// <p>A list of DB security groups to associate with this DB instance.</p>
        /// <p>Default: The default DB security group for the database engine.</p>
        pub fn db_security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_security_groups(input.into());
            self
        }
        /// <p>A list of DB security groups to associate with this DB instance.</p>
        /// <p>Default: The default DB security group for the database engine.</p>
        pub fn set_db_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_db_security_groups(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of EC2 VPC security groups to associate with this DB instance.</p>
        /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
        /// <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(input.into());
            self
        }
        /// <p>A list of EC2 VPC security groups to associate with this DB instance.</p>
        /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
        /// <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p> The EC2 Availability Zone that the DB instance is created in</p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Region.</p>
        /// <p> Example: <code>us-east-1d</code> </p>
        /// <p> Constraint: The AvailabilityZone parameter can't be specified if the MultiAZ parameter is set to <code>true</code>. The specified Availability Zone must be in the same Amazon Region as the current endpoint.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(input.into());
            self
        }
        /// <p> The EC2 Availability Zone that the DB instance is created in</p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Region.</p>
        /// <p> Example: <code>us-east-1d</code> </p>
        /// <p> Constraint: The AvailabilityZone parameter can't be specified if the MultiAZ parameter is set to <code>true</code>. The specified Availability Zone must be in the same Amazon Region as the current endpoint.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>A DB subnet group to associate with this DB instance.</p>
        /// <p>If there is no DB subnet group, then it is a non-VPC DB instance.</p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(input.into());
            self
        }
        /// <p>A DB subnet group to associate with this DB instance.</p>
        /// <p>If there is no DB subnet group, then it is a non-VPC DB instance.</p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p>The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.preferred_maintenance_window(input.into());
            self
        }
        /// <p>The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The name of the DB parameter group to associate with this DB instance. If this argument is omitted, the default DBParameterGroup for the specified engine is used.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the DB parameter group to associate with this DB instance. If this argument is omitted, the default DBParameterGroup for the specified engine is used.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// <p>The number of days for which automated backups are retained.</p>
        /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be a value from 0 to 35</p> </li>
        /// <li> <p>Cannot be set to 0 if the DB instance is a source to Read Replicas</p> </li>
        /// </ul>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.inner = self.inner.backup_retention_period(input);
            self
        }
        /// <p>The number of days for which automated backups are retained.</p>
        /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be a value from 0 to 35</p> </li>
        /// <li> <p>Cannot be set to 0 if the DB instance is a source to Read Replicas</p> </li>
        /// </ul>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_backup_retention_period(input);
            self
        }
        /// <p> The daily time range during which automated backups are created.</p>
        /// <p>Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_backup_window(input.into());
            self
        }
        /// <p> The daily time range during which automated backups are created.</p>
        /// <p>Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_backup_window(input);
            self
        }
        /// <p>The port number on which the database accepts connections.</p>
        /// <p>Not applicable. The port is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
        /// <p> Default: <code>8182</code> </p>
        /// <p>Type: Integer</p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port number on which the database accepts connections.</p>
        /// <p>Not applicable. The port is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
        /// <p> Default: <code>8182</code> </p>
        /// <p>Type: Integer</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>Specifies if the DB instance is a Multi-AZ deployment. You can't set the AvailabilityZone parameter if the MultiAZ parameter is set to true.</p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.inner = self.inner.multi_az(input);
            self
        }
        /// <p>Specifies if the DB instance is a Multi-AZ deployment. You can't set the AvailabilityZone parameter if the MultiAZ parameter is set to true.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_multi_az(input);
            self
        }
        /// <p>The version number of the database engine to use. Currently, setting this parameter has no effect.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The version number of the database engine to use. Currently, setting this parameter has no effect.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>Indicates that minor engine upgrades are applied automatically to the DB instance during the maintenance window.</p>
        /// <p>Default: <code>true</code> </p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(input);
            self
        }
        /// <p>Indicates that minor engine upgrades are applied automatically to the DB instance during the maintenance window.</p>
        /// <p>Default: <code>true</code> </p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// <p>License model information for this DB instance.</p>
        /// <p> Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code> </p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_model(input.into());
            self
        }
        /// <p>License model information for this DB instance.</p>
        /// <p> Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code> </p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_model(input);
            self
        }
        /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.inner = self.inner.iops(input);
            self
        }
        /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_iops(input);
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(input.into());
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn character_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.character_set_name(input.into());
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn set_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_character_set_name(input);
            self
        }
        /// <p>This flag should no longer be used.</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.inner = self.inner.publicly_accessible(input);
            self
        }
        /// <p>This flag should no longer be used.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_accessible(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the new instance.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to assign to the new instance.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The identifier of the DB cluster that the instance will belong to.</p>
        /// <p>For information on creating a DB cluster, see <code>CreateDBCluster</code>.</p>
        /// <p>Type: String</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The identifier of the DB cluster that the instance will belong to.</p>
        /// <p>For information on creating a DB cluster, see <code>CreateDBCluster</code>.</p>
        /// <p>Type: String</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>Specifies the storage type to be associated with the DB instance.</p>
        /// <p>Not applicable. Storage is managed by the DB Cluster.</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.storage_type(input.into());
            self
        }
        /// <p>Specifies the storage type to be associated with the DB instance.</p>
        /// <p>Not applicable. Storage is managed by the DB Cluster.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_storage_type(input);
            self
        }
        /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
        pub fn tde_credential_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tde_credential_arn(input.into());
            self
        }
        /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
        pub fn set_tde_credential_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tde_credential_arn(input);
            self
        }
        /// <p>The password for the given ARN from the key store in order to access the device.</p>
        pub fn tde_credential_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tde_credential_password(input.into());
            self
        }
        /// <p>The password for the given ARN from the key store in order to access the device.</p>
        pub fn set_tde_credential_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tde_credential_password(input);
            self
        }
        /// <p>Specifies whether the DB instance is encrypted.</p>
        /// <p>Not applicable. The encryption for DB instances is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
        /// <p>Default: false</p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.inner = self.inner.storage_encrypted(input);
            self
        }
        /// <p>Specifies whether the DB instance is encrypted.</p>
        /// <p>Not applicable. The encryption for DB instances is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
        /// <p>Default: false</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_storage_encrypted(input);
            self
        }
        /// <p>The Amazon KMS key identifier for an encrypted DB instance.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a DB instance with the same Amazon account that owns the KMS encryption key used to encrypt the new DB instance, then you can use the KMS key alias instead of the ARN for the KM encryption key.</p>
        /// <p>Not applicable. The KMS key identifier is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
        /// <p>If the <code>StorageEncrypted</code> parameter is true, and you do not specify a value for the <code>KmsKeyId</code> parameter, then Amazon Neptune will use your default encryption key. Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a different default encryption key for each Amazon Region.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The Amazon KMS key identifier for an encrypted DB instance.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a DB instance with the same Amazon account that owns the KMS encryption key used to encrypt the new DB instance, then you can use the KMS key alias instead of the ARN for the KM encryption key.</p>
        /// <p>Not applicable. The KMS key identifier is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
        /// <p>If the <code>StorageEncrypted</code> parameter is true, and you do not specify a value for the <code>KmsKeyId</code> parameter, then Amazon Neptune will use your default encryption key. Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a different default encryption key for each Amazon Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>Specify the Active Directory Domain to create the instance in.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>Specify the Active Directory Domain to create the instance in.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise false. The default is false.</p>
        pub fn copy_tags_to_snapshot(mut self, input: bool) -> Self {
            self.inner = self.inner.copy_tags_to_snapshot(input);
            self
        }
        /// <p>True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise false. The default is false.</p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags_to_snapshot(input);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
        pub fn monitoring_interval(mut self, input: i32) -> Self {
            self.inner = self.inner.monitoring_interval(input);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
        pub fn set_monitoring_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_monitoring_interval(input);
            self
        }
        /// <p>The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>
        pub fn monitoring_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.monitoring_role_arn(input.into());
            self
        }
        /// <p>The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>
        pub fn set_monitoring_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_monitoring_role_arn(input);
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
        pub fn domain_iam_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_iam_role_name(input.into());
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
        pub fn set_domain_iam_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_domain_iam_role_name(input);
            self
        }
        /// <p>A value that specifies the order in which an Read Replica is promoted to the primary instance after a failure of the existing primary instance. </p>
        /// <p>Default: 1</p>
        /// <p>Valid Values: 0 - 15</p>
        pub fn promotion_tier(mut self, input: i32) -> Self {
            self.inner = self.inner.promotion_tier(input);
            self
        }
        /// <p>A value that specifies the order in which an Read Replica is promoted to the primary instance after a failure of the existing primary instance. </p>
        /// <p>Default: 1</p>
        /// <p>Valid Values: 0 - 15</p>
        pub fn set_promotion_tier(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_promotion_tier(input);
            self
        }
        /// <p>The time zone of the DB instance.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.timezone(input.into());
            self
        }
        /// <p>The time zone of the DB instance.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_timezone(input);
            self
        }
        /// <p>Not supported by Neptune (ignored).</p>
        pub fn enable_iam_database_authentication(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_iam_database_authentication(input);
            self
        }
        /// <p>Not supported by Neptune (ignored).</p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_iam_database_authentication(input);
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn enable_performance_insights(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_performance_insights(input);
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn set_enable_performance_insights(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_performance_insights(input);
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn performance_insights_kms_key_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.performance_insights_kms_key_id(input.into());
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn set_performance_insights_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_performance_insights_kms_key_id(input);
            self
        }
        /// Appends an item to `EnableCloudwatchLogsExports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.enable_cloudwatch_logs_exports(input.into());
            self
        }
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_enable_cloudwatch_logs_exports(input);
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting a DB Instance</a>.</p>
        /// <p>DB instances in a DB cluster can be deleted even when deletion protection is enabled in their parent DB cluster.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.inner = self.inner.deletion_protection(input);
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting a DB Instance</a>.</p>
        /// <p>DB instances in a DB cluster can be deleted even when deletion protection is enabled in their parent DB cluster.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBParameterGroup`.
    ///
    /// <p>Creates a new DB parameter group.</p>
    /// <p>A DB parameter group is initially created with the default parameters for the database engine used by the DB instance. To provide custom values for any of the parameters, you must modify the group after creating it using <i>ModifyDBParameterGroup</i>. Once you've created a DB parameter group, you need to associate it with your DB instance using <i>ModifyDBInstance</i>. When you associate a new DB parameter group with a running DB instance, you need to reboot the DB instance without failover for the new DB parameter group and associated settings to take effect.</p> <important>
    /// <p>After you create a DB parameter group, you should wait at least 5 minutes before creating your first DB instance that uses that DB parameter group as the default parameter group. This allows Amazon Neptune to fully complete the create action before the parameter group is used as the default for a new DB instance. This is especially important for parameters that are critical when creating the default database for a DB instance, such as the character set for the default database defined by the <code>character_set_database</code> parameter. You can use the <i>Parameter Groups</i> option of the Amazon Neptune console or the <i>DescribeDBParameters</i> command to verify that your DB parameter group has been created or modified.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDBParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_db_parameter_group_input::Builder,
    }
    impl CreateDBParameterGroup {
        /// Creates a new `CreateDBParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul> <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul> <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// <p>The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_family(input.into());
            self
        }
        /// <p>The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_family(input);
            self
        }
        /// <p>The description for the DB parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the DB parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the new DB parameter group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be assigned to the new DB parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBSubnetGroup`.
    ///
    /// <p>Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDBSubnetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_db_subnet_group_input::Builder,
    }
    impl CreateDBSubnetGroup {
        /// Creates a new `CreateDBSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBSubnetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the DB subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 letters, numbers, periods, underscores, spaces, or hyphens. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code> </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(input.into());
            self
        }
        /// <p>The name for the DB subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 letters, numbers, periods, underscores, spaces, or hyphens. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code> </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p>The description for the DB subnet group.</p>
        pub fn db_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_subnet_group_description(input.into());
            self
        }
        /// <p>The description for the DB subnet group.</p>
        pub fn set_db_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The EC2 Subnet IDs for the DB subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>The EC2 Subnet IDs for the DB subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the new DB subnet group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be assigned to the new DB subnet group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEventSubscription`.
    ///
    /// <p>Creates an event notification subscription. This action requires a topic ARN (Amazon Resource Name) created by either the Neptune console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.</p>
    /// <p>You can specify the type of source (SourceType) you want to be notified of, provide a list of Neptune sources (SourceIds) that triggers the events, and provide a list of event categories (EventCategories) for events you want to be notified of. For example, you can specify SourceType = db-instance, SourceIds = mydbinstance1, mydbinstance2 and EventCategories = Availability, Backup.</p>
    /// <p>If you specify both the SourceType and SourceIds, such as SourceType = db-instance and SourceIdentifier = myDBInstance1, you are notified of all the db-instance events for the specified source. If you specify a SourceType but do not specify a SourceIdentifier, you receive notice of the events for that source type for all your Neptune sources. If you do not specify either the SourceType nor the SourceIdentifier, you are notified of events generated from all Neptune sources belonging to your customer account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEventSubscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_event_subscription_input::Builder,
    }
    impl CreateEventSubscription {
        /// Creates a new `CreateEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEventSubscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the subscription.</p>
        /// <p>Constraints: The name must be less than 255 characters.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(input.into());
            self
        }
        /// <p>The name of the subscription.</p>
        /// <p>Constraints: The name must be less than 255 characters.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you would set this parameter to db-instance. if this value is not specified, all events are returned.</p>
        /// <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> </p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(input.into());
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you would set this parameter to db-instance. if this value is not specified, all events are returned.</p>
        /// <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> </p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p> A list of event categories for a SourceType that you want to subscribe to. You can see a list of the categories for a given SourceType by using the <b>DescribeEventCategories</b> action.</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(input.into());
            self
        }
        /// <p> A list of event categories for a SourceType that you want to subscribe to. You can see a list of the categories for a given SourceType by using the <b>DescribeEventCategories</b> action.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// Appends an item to `SourceIds`.
        ///
        /// To override the contents of this collection use [`set_source_ids`](Self::set_source_ids).
        ///
        /// <p>The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If SourceIds are supplied, SourceType must also be provided.</p> </li>
        /// <li> <p>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be supplied.</p> </li>
        /// </ul>
        pub fn source_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_ids(input.into());
            self
        }
        /// <p>The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If SourceIds are supplied, SourceType must also be provided.</p> </li>
        /// <li> <p>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be supplied.</p> </li>
        /// </ul>
        pub fn set_source_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_source_ids(input);
            self
        }
        /// <p> A Boolean value; set to <b>true</b> to activate the subscription, set to <b>false</b> to create the subscription but not active it.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p> A Boolean value; set to <b>true</b> to activate the subscription, set to <b>false</b> to create the subscription but not active it.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be applied to the new event subscription.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be applied to the new event subscription.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBCluster`.
    ///
    /// <p>The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified DB cluster are not deleted.</p>
    /// <p>Note that the DB Cluster cannot be deleted if deletion protection is enabled. To delete it, you must first set its <code>DeletionProtection</code> field to <code>False</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDBCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_db_cluster_input::Builder,
    }
    impl DeleteDBCluster {
        /// Creates a new `DeleteDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match an existing DBClusterIdentifier.</p> </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match an existing DBClusterIdentifier.</p> </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p> Determines whether a final DB cluster snapshot is created before the DB cluster is deleted. If <code>true</code> is specified, no DB cluster snapshot is created. If <code>false</code> is specified, a DB cluster snapshot is created before the DB cluster is deleted.</p> <note>
        /// <p>You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if <code>SkipFinalSnapshot</code> is <code>false</code>.</p>
        /// </note>
        /// <p>Default: <code>false</code> </p>
        pub fn skip_final_snapshot(mut self, input: bool) -> Self {
            self.inner = self.inner.skip_final_snapshot(input);
            self
        }
        /// <p> Determines whether a final DB cluster snapshot is created before the DB cluster is deleted. If <code>true</code> is specified, no DB cluster snapshot is created. If <code>false</code> is specified, a DB cluster snapshot is created before the DB cluster is deleted.</p> <note>
        /// <p>You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if <code>SkipFinalSnapshot</code> is <code>false</code>.</p>
        /// </note>
        /// <p>Default: <code>false</code> </p>
        pub fn set_skip_final_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_final_snapshot(input);
            self
        }
        /// <p> The DB cluster snapshot identifier of the new DB cluster snapshot created when <code>SkipFinalSnapshot</code> is set to <code>false</code>.</p> <note>
        /// <p> Specifying this parameter and also setting the <code>SkipFinalShapshot</code> parameter to true results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn final_db_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.final_db_snapshot_identifier(input.into());
            self
        }
        /// <p> The DB cluster snapshot identifier of the new DB cluster snapshot created when <code>SkipFinalSnapshot</code> is set to <code>false</code>.</p> <note>
        /// <p> Specifying this parameter and also setting the <code>SkipFinalShapshot</code> parameter to true results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn set_final_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_final_db_snapshot_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBClusterEndpoint`.
    ///
    /// <p>Deletes a custom endpoint and removes it from an Amazon Neptune DB cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDBClusterEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_db_cluster_endpoint_input::Builder,
    }
    impl DeleteDBClusterEndpoint {
        /// Creates a new `DeleteDBClusterEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbClusterEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_endpoint_identifier(input.into());
            self
        }
        /// <p>The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_endpoint_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBClusterParameterGroup`.
    ///
    /// <p>Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated with any DB clusters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDBClusterParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_db_cluster_parameter_group_input::Builder,
    }
    impl DeleteDBClusterParameterGroup {
        /// Creates a new `DeleteDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be the name of an existing DB cluster parameter group.</p> </li>
        /// <li> <p>You can't delete a default DB cluster parameter group.</p> </li>
        /// <li> <p>Cannot be associated with any DB clusters.</p> </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be the name of an existing DB cluster parameter group.</p> </li>
        /// <li> <p>You can't delete a default DB cluster parameter group.</p> </li>
        /// <li> <p>Cannot be associated with any DB clusters.</p> </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBClusterSnapshot`.
    ///
    /// <p>Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.</p> <note>
    /// <p>The DB cluster snapshot must be in the <code>available</code> state to be deleted.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDBClusterSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_db_cluster_snapshot_input::Builder,
    }
    impl DeleteDBClusterSnapshot {
        /// Creates a new `DeleteDBClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the DB cluster snapshot to delete.</p>
        /// <p>Constraints: Must be the name of an existing DB cluster snapshot in the <code>available</code> state.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(input.into());
            self
        }
        /// <p>The identifier of the DB cluster snapshot to delete.</p>
        /// <p>Constraints: Must be the name of an existing DB cluster snapshot in the <code>available</code> state.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBInstance`.
    ///
    /// <p>The DeleteDBInstance action deletes a previously provisioned DB instance. When you delete a DB instance, all automated backups for that instance are deleted and can't be recovered. Manual DB snapshots of the DB instance to be deleted by <code>DeleteDBInstance</code> are not deleted.</p>
    /// <p> If you request a final DB snapshot the status of the Amazon Neptune DB instance is <code>deleting</code> until the DB snapshot is created. The API action <code>DescribeDBInstance</code> is used to monitor the status of this operation. The action can't be canceled or reverted once submitted.</p>
    /// <p>Note that when a DB instance is in a failure state and has a status of <code>failed</code>, <code>incompatible-restore</code>, or <code>incompatible-network</code>, you can only delete it when the <code>SkipFinalSnapshot</code> parameter is set to <code>true</code>.</p>
    /// <p>You can't delete a DB instance if it is the only instance in the DB cluster, or if it has deletion protection enabled.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDBInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_db_instance_input::Builder,
    }
    impl DeleteDBInstance {
        /// Creates a new `DeleteDBInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the name of an existing DB instance.</p> </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(input.into());
            self
        }
        /// <p>The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the name of an existing DB instance.</p> </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p> Determines whether a final DB snapshot is created before the DB instance is deleted. If <code>true</code> is specified, no DBSnapshot is created. If <code>false</code> is specified, a DB snapshot is created before the DB instance is deleted.</p>
        /// <p>Note that when a DB instance is in a failure state and has a status of 'failed', 'incompatible-restore', or 'incompatible-network', it can only be deleted when the SkipFinalSnapshot parameter is set to "true".</p>
        /// <p>Specify <code>true</code> when deleting a Read Replica.</p> <note>
        /// <p>The FinalDBSnapshotIdentifier parameter must be specified if SkipFinalSnapshot is <code>false</code>.</p>
        /// </note>
        /// <p>Default: <code>false</code> </p>
        pub fn skip_final_snapshot(mut self, input: bool) -> Self {
            self.inner = self.inner.skip_final_snapshot(input);
            self
        }
        /// <p> Determines whether a final DB snapshot is created before the DB instance is deleted. If <code>true</code> is specified, no DBSnapshot is created. If <code>false</code> is specified, a DB snapshot is created before the DB instance is deleted.</p>
        /// <p>Note that when a DB instance is in a failure state and has a status of 'failed', 'incompatible-restore', or 'incompatible-network', it can only be deleted when the SkipFinalSnapshot parameter is set to "true".</p>
        /// <p>Specify <code>true</code> when deleting a Read Replica.</p> <note>
        /// <p>The FinalDBSnapshotIdentifier parameter must be specified if SkipFinalSnapshot is <code>false</code>.</p>
        /// </note>
        /// <p>Default: <code>false</code> </p>
        pub fn set_skip_final_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_final_snapshot(input);
            self
        }
        /// <p> The DBSnapshotIdentifier of the new DBSnapshot created when SkipFinalSnapshot is set to <code>false</code>.</p> <note>
        /// <p>Specifying this parameter and also setting the SkipFinalShapshot parameter to true results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters or numbers.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// <li> <p>Cannot be specified when deleting a Read Replica.</p> </li>
        /// </ul>
        pub fn final_db_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.final_db_snapshot_identifier(input.into());
            self
        }
        /// <p> The DBSnapshotIdentifier of the new DBSnapshot created when SkipFinalSnapshot is set to <code>false</code>.</p> <note>
        /// <p>Specifying this parameter and also setting the SkipFinalShapshot parameter to true results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters or numbers.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// <li> <p>Cannot be specified when deleting a Read Replica.</p> </li>
        /// </ul>
        pub fn set_final_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_final_db_snapshot_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBParameterGroup`.
    ///
    /// <p>Deletes a specified DBParameterGroup. The DBParameterGroup to be deleted can't be associated with any DB instances.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDBParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_db_parameter_group_input::Builder,
    }
    impl DeleteDBParameterGroup {
        /// Creates a new `DeleteDBParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be the name of an existing DB parameter group</p> </li>
        /// <li> <p>You can't delete a default DB parameter group</p> </li>
        /// <li> <p>Cannot be associated with any DB instances</p> </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be the name of an existing DB parameter group</p> </li>
        /// <li> <p>You can't delete a default DB parameter group</p> </li>
        /// <li> <p>Cannot be associated with any DB instances</p> </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBSubnetGroup`.
    ///
    /// <p>Deletes a DB subnet group.</p> <note>
    /// <p>The specified database subnet group must not be associated with any DB instances.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDBSubnetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_db_subnet_group_input::Builder,
    }
    impl DeleteDBSubnetGroup {
        /// Creates a new `DeleteDBSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBSubnetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the database subnet group to delete.</p> <note>
        /// <p>You can't delete the default subnet group.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code> </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(input.into());
            self
        }
        /// <p>The name of the database subnet group to delete.</p> <note>
        /// <p>You can't delete the default subnet group.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code> </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventSubscription`.
    ///
    /// <p>Deletes an event notification subscription.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEventSubscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_event_subscription_input::Builder,
    }
    impl DeleteEventSubscription {
        /// Creates a new `DeleteEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventSubscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event notification subscription you want to delete.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(input.into());
            self
        }
        /// <p>The name of the event notification subscription you want to delete.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterEndpoints`.
    ///
    /// <p>Returns information about endpoints for an Amazon Neptune DB cluster.</p> <note>
    /// <p>This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDBClusterEndpoints {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_db_cluster_endpoints_input::Builder,
    }
    impl DescribeDBClusterEndpoints {
        /// Creates a new `DescribeDBClusterEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterEndpointsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDbClusterEndpointsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDbClusterEndpointsPaginator {
            crate::paginator::DescribeDbClusterEndpointsPaginator::new(self.handle, self.inner)
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The identifier of the endpoint to describe. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_endpoint_identifier(input.into());
            self
        }
        /// <p>The identifier of the endpoint to describe. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_endpoint_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A set of name-value pairs that define which endpoints to include in the output. The filters are specified as name-value pairs, in the format <code>Name=<i>endpoint_type</i>,Values=<i>endpoint_type1</i>,<i>endpoint_type2</i>,...</code>. <code>Name</code> can be one of: <code>db-cluster-endpoint-type</code>, <code>db-cluster-endpoint-custom-type</code>, <code>db-cluster-endpoint-id</code>, <code>db-cluster-endpoint-status</code>. <code>Values</code> for the <code> db-cluster-endpoint-type</code> filter can be one or more of: <code>reader</code>, <code>writer</code>, <code>custom</code>. <code>Values</code> for the <code>db-cluster-endpoint-custom-type</code> filter can be one or more of: <code>reader</code>, <code>any</code>. <code>Values</code> for the <code>db-cluster-endpoint-status</code> filter can be one or more of: <code>available</code>, <code>creating</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. </p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A set of name-value pairs that define which endpoints to include in the output. The filters are specified as name-value pairs, in the format <code>Name=<i>endpoint_type</i>,Values=<i>endpoint_type1</i>,<i>endpoint_type2</i>,...</code>. <code>Name</code> can be one of: <code>db-cluster-endpoint-type</code>, <code>db-cluster-endpoint-custom-type</code>, <code>db-cluster-endpoint-id</code>, <code>db-cluster-endpoint-status</code>. <code>Values</code> for the <code> db-cluster-endpoint-type</code> filter can be one or more of: <code>reader</code>, <code>writer</code>, <code>custom</code>. <code>Values</code> for the <code>db-cluster-endpoint-custom-type</code> filter can be one or more of: <code>reader</code>, <code>any</code>. <code>Values</code> for the <code>db-cluster-endpoint-status</code> filter can be one or more of: <code>available</code>, <code>creating</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterEndpoints</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterEndpoints</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterParameterGroups`.
    ///
    /// <p> Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of the specified DB cluster parameter group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDBClusterParameterGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_db_cluster_parameter_groups_input::Builder,
    }
    impl DescribeDBClusterParameterGroups {
        /// Creates a new `DescribeDBClusterParameterGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterParameterGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterParameterGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDbClusterParameterGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDbClusterParameterGroupsPaginator {
            crate::paginator::DescribeDbClusterParameterGroupsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of a specific DB cluster parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(input.into());
            self
        }
        /// <p>The name of a specific DB cluster parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterParameters`.
    ///
    /// <p>Returns the detailed parameter list for a particular DB cluster parameter group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDBClusterParameters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_db_cluster_parameters_input::Builder,
    }
    impl DescribeDBClusterParameters {
        /// Creates a new `DescribeDBClusterParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterParametersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDbClusterParametersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDbClusterParametersPaginator {
            crate::paginator::DescribeDbClusterParametersPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of a specific DB cluster parameter group to return parameter details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(input.into());
            self
        }
        /// <p>The name of a specific DB cluster parameter group to return parameter details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// <p> A value that indicates to return only parameters for a specific source. Parameter sources can be <code>engine</code>, <code>service</code>, or <code>customer</code>.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(input.into());
            self
        }
        /// <p> A value that indicates to return only parameters for a specific source. Parameter sources can be <code>engine</code>, <code>service</code>, or <code>customer</code>.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusters`.
    ///
    /// <p>Returns information about provisioned DB clusters, and supports pagination.</p> <note>
    /// <p>This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDBClusters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_db_clusters_input::Builder,
    }
    impl DescribeDBClusters {
        /// Creates a new `DescribeDBClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClustersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDbClustersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDbClustersPaginator {
            crate::paginator::DescribeDbClustersPaginator::new(self.handle, self.inner)
        }
        /// <p>The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match an existing DBClusterIdentifier.</p> </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match an existing DBClusterIdentifier.</p> </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more DB clusters to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include information about the DB clusters identified by these ARNs.</p> </li>
        /// <li> <p> <code>engine</code> - Accepts an engine name (such as <code>neptune</code>), and restricts the results list to DB clusters created by that engine.</p> </li>
        /// </ul>
        /// <p>For example, to invoke this API from the Amazon CLI and filter so that only Neptune DB clusters are returned, you could use the following command:</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A filter that specifies one or more DB clusters to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include information about the DB clusters identified by these ARNs.</p> </li>
        /// <li> <p> <code>engine</code> - Accepts an engine name (such as <code>neptune</code>), and restricts the results list to DB clusters created by that engine.</p> </li>
        /// </ul>
        /// <p>For example, to invoke this API from the Amazon CLI and filter so that only Neptune DB clusters are returned, you could use the following command:</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterSnapshotAttributes`.
    ///
    /// <p>Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.</p>
    /// <p>When sharing snapshots with other Amazon accounts, <code>DescribeDBClusterSnapshotAttributes</code> returns the <code>restore</code> attribute and a list of IDs for the Amazon accounts that are authorized to copy or restore the manual DB cluster snapshot. If <code>all</code> is included in the list of values for the <code>restore</code> attribute, then the manual DB cluster snapshot is public and can be copied or restored by all Amazon accounts.</p>
    /// <p>To add or remove access for an Amazon account to copy or restore a manual DB cluster snapshot, or to make the manual DB cluster snapshot public or private, use the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDBClusterSnapshotAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_db_cluster_snapshot_attributes_input::Builder,
    }
    impl DescribeDBClusterSnapshotAttributes {
        /// Creates a new `DescribeDBClusterSnapshotAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterSnapshotAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeDBClusterSnapshotAttributesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the DB cluster snapshot to describe the attributes for.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(input.into());
            self
        }
        /// <p>The identifier for the DB cluster snapshot to describe the attributes for.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterSnapshots`.
    ///
    /// <p>Returns information about DB cluster snapshots. This API action supports pagination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDBClusterSnapshots {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_db_cluster_snapshots_input::Builder,
    }
    impl DescribeDBClusterSnapshots {
        /// Creates a new `DescribeDBClusterSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterSnapshotsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDbClusterSnapshotsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDbClusterSnapshotsPaginator {
            crate::paginator::DescribeDbClusterSnapshotsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the DB cluster to retrieve the list of DB cluster snapshots for. This parameter can't be used in conjunction with the <code>DBClusterSnapshotIdentifier</code> parameter. This parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the identifier of an existing DBCluster.</p> </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The ID of the DB cluster to retrieve the list of DB cluster snapshots for. This parameter can't be used in conjunction with the <code>DBClusterSnapshotIdentifier</code> parameter. This parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the identifier of an existing DBCluster.</p> </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>A specific DB cluster snapshot identifier to describe. This parameter can't be used in conjunction with the <code>DBClusterIdentifier</code> parameter. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the identifier of an existing DBClusterSnapshot.</p> </li>
        /// <li> <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</p> </li>
        /// </ul>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(input.into());
            self
        }
        /// <p>A specific DB cluster snapshot identifier to describe. This parameter can't be used in conjunction with the <code>DBClusterIdentifier</code> parameter. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the identifier of an existing DBClusterSnapshot.</p> </li>
        /// <li> <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</p> </li>
        /// </ul>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The type of DB cluster snapshots to be returned. You can specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>automated</code> - Return all DB cluster snapshots that have been automatically taken by Amazon Neptune for my Amazon account.</p> </li>
        /// <li> <p> <code>manual</code> - Return all DB cluster snapshots that have been taken by my Amazon account.</p> </li>
        /// <li> <p> <code>shared</code> - Return all manual DB cluster snapshots that have been shared to my Amazon account.</p> </li>
        /// <li> <p> <code>public</code> - Return all DB cluster snapshots that have been marked as public.</p> </li>
        /// </ul>
        /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual DB cluster snapshots are returned. You can include shared DB cluster snapshots with these results by setting the <code>IncludeShared</code> parameter to <code>true</code>. You can include public DB cluster snapshots with these results by setting the <code>IncludePublic</code> parameter to <code>true</code>.</p>
        /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>public</code>.</p>
        pub fn snapshot_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_type(input.into());
            self
        }
        /// <p>The type of DB cluster snapshots to be returned. You can specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>automated</code> - Return all DB cluster snapshots that have been automatically taken by Amazon Neptune for my Amazon account.</p> </li>
        /// <li> <p> <code>manual</code> - Return all DB cluster snapshots that have been taken by my Amazon account.</p> </li>
        /// <li> <p> <code>shared</code> - Return all manual DB cluster snapshots that have been shared to my Amazon account.</p> </li>
        /// <li> <p> <code>public</code> - Return all DB cluster snapshots that have been marked as public.</p> </li>
        /// </ul>
        /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual DB cluster snapshots are returned. You can include shared DB cluster snapshots with these results by setting the <code>IncludeShared</code> parameter to <code>true</code>. You can include public DB cluster snapshots with these results by setting the <code>IncludePublic</code> parameter to <code>true</code>.</p>
        /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>public</code>.</p>
        pub fn set_snapshot_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_type(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>True to include shared manual DB cluster snapshots from other Amazon accounts that this Amazon account has been given permission to copy or restore, and otherwise false. The default is <code>false</code>.</p>
        /// <p>You can give an Amazon account permission to restore a manual DB cluster snapshot from another Amazon account by the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
        pub fn include_shared(mut self, input: bool) -> Self {
            self.inner = self.inner.include_shared(input);
            self
        }
        /// <p>True to include shared manual DB cluster snapshots from other Amazon accounts that this Amazon account has been given permission to copy or restore, and otherwise false. The default is <code>false</code>.</p>
        /// <p>You can give an Amazon account permission to restore a manual DB cluster snapshot from another Amazon account by the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
        pub fn set_include_shared(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_shared(input);
            self
        }
        /// <p>True to include manual DB cluster snapshots that are public and can be copied or restored by any Amazon account, and otherwise false. The default is <code>false</code>. The default is false.</p>
        /// <p>You can share a manual DB cluster snapshot as public by using the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
        pub fn include_public(mut self, input: bool) -> Self {
            self.inner = self.inner.include_public(input);
            self
        }
        /// <p>True to include manual DB cluster snapshots that are public and can be copied or restored by any Amazon account, and otherwise false. The default is <code>false</code>. The default is false.</p>
        /// <p>You can share a manual DB cluster snapshot as public by using the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
        pub fn set_include_public(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_public(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBEngineVersions`.
    ///
    /// <p>Returns a list of the available DB engines.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDBEngineVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_db_engine_versions_input::Builder,
    }
    impl DescribeDBEngineVersions {
        /// Creates a new `DescribeDBEngineVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbEngineVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBEngineVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDbEngineVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDbEngineVersionsPaginator {
            crate::paginator::DescribeDbEngineVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The database engine to return.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(input.into());
            self
        }
        /// <p>The database engine to return.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The database engine version to return.</p>
        /// <p>Example: <code>5.1.49</code> </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The database engine version to return.</p>
        /// <p>Example: <code>5.1.49</code> </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The name of a specific DB parameter group family to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match an existing DBParameterGroupFamily.</p> </li>
        /// </ul>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_family(input.into());
            self
        }
        /// <p>The name of a specific DB parameter group family to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match an existing DBParameterGroupFamily.</p> </li>
        /// </ul>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_family(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Not currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is included in the response so that the following results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is included in the response so that the following results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Indicates that only the default version of the specified engine or engine and major version combination is returned.</p>
        pub fn default_only(mut self, input: bool) -> Self {
            self.inner = self.inner.default_only(input);
            self
        }
        /// <p>Indicates that only the default version of the specified engine or engine and major version combination is returned.</p>
        pub fn set_default_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_default_only(input);
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine version.</p>
        pub fn list_supported_character_sets(mut self, input: bool) -> Self {
            self.inner = self.inner.list_supported_character_sets(input);
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine version.</p>
        pub fn set_list_supported_character_sets(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_list_supported_character_sets(input);
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the <code>TimeZone</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine version.</p>
        pub fn list_supported_timezones(mut self, input: bool) -> Self {
            self.inner = self.inner.list_supported_timezones(input);
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the <code>TimeZone</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine version.</p>
        pub fn set_list_supported_timezones(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_list_supported_timezones(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBInstances`.
    ///
    /// <p>Returns information about provisioned instances, and supports pagination.</p> <note>
    /// <p>This operation can also return information for Amazon RDS instances and Amazon DocDB instances.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDBInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_db_instances_input::Builder,
    }
    impl DescribeDBInstances {
        /// Creates a new `DescribeDBInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDbInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDbInstancesPaginator {
            crate::paginator::DescribeDbInstancesPaginator::new(self.handle, self.inner)
        }
        /// <p>The user-supplied instance identifier. If this parameter is specified, information from only the specific DB instance is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the identifier of an existing DBInstance.</p> </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(input.into());
            self
        }
        /// <p>The user-supplied instance identifier. If this parameter is specified, information from only the specific DB instance is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the identifier of an existing DBInstance.</p> </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more DB instances to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include information about the DB instances associated with the DB clusters identified by these ARNs.</p> </li>
        /// <li> <p> <code>engine</code> - Accepts an engine name (such as <code>neptune</code>), and restricts the results list to DB instances created by that engine.</p> </li>
        /// </ul>
        /// <p>For example, to invoke this API from the Amazon CLI and filter so that only Neptune DB instances are returned, you could use the following command:</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A filter that specifies one or more DB instances to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include information about the DB instances associated with the DB clusters identified by these ARNs.</p> </li>
        /// <li> <p> <code>engine</code> - Accepts an engine name (such as <code>neptune</code>), and restricts the results list to DB instances created by that engine.</p> </li>
        /// </ul>
        /// <p>For example, to invoke this API from the Amazon CLI and filter so that only Neptune DB instances are returned, you could use the following command:</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribeDBInstances</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribeDBInstances</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBParameterGroups`.
    ///
    /// <p>Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is specified, the list will contain only the description of the specified DB parameter group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDBParameterGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_db_parameter_groups_input::Builder,
    }
    impl DescribeDBParameterGroups {
        /// Creates a new `DescribeDBParameterGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbParameterGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBParameterGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDbParameterGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDbParameterGroupsPaginator {
            crate::paginator::DescribeDbParameterGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(input.into());
            self
        }
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBParameters`.
    ///
    /// <p>Returns the detailed parameter list for a particular DB parameter group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDBParameters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_db_parameters_input::Builder,
    }
    impl DescribeDBParameters {
        /// Creates a new `DescribeDBParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBParametersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDbParametersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDbParametersPaginator {
            crate::paginator::DescribeDbParametersPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBParameterGroup.</p> </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(input.into());
            self
        }
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBParameterGroup.</p> </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// <p>The parameter types to return.</p>
        /// <p>Default: All parameter types returned</p>
        /// <p>Valid Values: <code>user | system | engine-default</code> </p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(input.into());
            self
        }
        /// <p>The parameter types to return.</p>
        /// <p>Default: All parameter types returned</p>
        /// <p>Valid Values: <code>user | system | engine-default</code> </p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBSubnetGroups`.
    ///
    /// <p>Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the descriptions of the specified DBSubnetGroup.</p>
    /// <p>For an overview of CIDR ranges, go to the <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDBSubnetGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_db_subnet_groups_input::Builder,
    }
    impl DescribeDBSubnetGroups {
        /// Creates a new `DescribeDBSubnetGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbSubnetGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBSubnetGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDbSubnetGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDbSubnetGroupsPaginator {
            crate::paginator::DescribeDbSubnetGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the DB subnet group to return details for.</p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(input.into());
            self
        }
        /// <p>The name of the DB subnet group to return details for.</p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeDBSubnetGroups request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeDBSubnetGroups request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEngineDefaultClusterParameters`.
    ///
    /// <p>Returns the default engine and system parameter information for the cluster database engine.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEngineDefaultClusterParameters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_engine_default_cluster_parameters_input::Builder,
    }
    impl DescribeEngineDefaultClusterParameters {
        /// Creates a new `DescribeEngineDefaultClusterParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEngineDefaultClusterParametersOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeEngineDefaultClusterParametersError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster parameter group family to return engine parameter information for.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_family(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group family to return engine parameter information for.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_family(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribeEngineDefaultClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribeEngineDefaultClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEngineDefaultParameters`.
    ///
    /// <p>Returns the default engine and system parameter information for the specified database engine.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEngineDefaultParameters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_engine_default_parameters_input::Builder,
    }
    impl DescribeEngineDefaultParameters {
        /// Creates a new `DescribeEngineDefaultParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEngineDefaultParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEngineDefaultParametersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEngineDefaultParametersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEngineDefaultParametersPaginator {
            crate::paginator::DescribeEngineDefaultParametersPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the DB parameter group family.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_family(input.into());
            self
        }
        /// <p>The name of the DB parameter group family.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_family(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Not currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribeEngineDefaultParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribeEngineDefaultParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventCategories`.
    ///
    /// <p>Displays a list of categories for all event source types, or, if specified, for a specified source type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventCategories {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_event_categories_input::Builder,
    }
    impl DescribeEventCategories {
        /// Creates a new `DescribeEventCategories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventCategoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventCategoriesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of source that is generating the events.</p>
        /// <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(input.into());
            self
        }
        /// <p>The type of source that is generating the events.</p>
        /// <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEvents`.
    ///
    /// <p>Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14 days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group can be obtained by providing the name as a parameter. By default, the past hour of events are returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_events_input::Builder,
    }
    impl DescribeEvents {
        /// Creates a new `DescribeEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEventsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEventsPaginator {
            crate::paginator::DescribeEventsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If SourceIdentifier is supplied, SourceType must also be provided.</p> </li>
        /// <li> <p>If the source type is <code>DBInstance</code>, then a <code>DBInstanceIdentifier</code> must be supplied.</p> </li>
        /// <li> <p>If the source type is <code>DBSecurityGroup</code>, a <code>DBSecurityGroupName</code> must be supplied.</p> </li>
        /// <li> <p>If the source type is <code>DBParameterGroup</code>, a <code>DBParameterGroupName</code> must be supplied.</p> </li>
        /// <li> <p>If the source type is <code>DBSnapshot</code>, a <code>DBSnapshotIdentifier</code> must be supplied.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_identifier(input.into());
            self
        }
        /// <p>The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If SourceIdentifier is supplied, SourceType must also be provided.</p> </li>
        /// <li> <p>If the source type is <code>DBInstance</code>, then a <code>DBInstanceIdentifier</code> must be supplied.</p> </li>
        /// <li> <p>If the source type is <code>DBSecurityGroup</code>, a <code>DBSecurityGroupName</code> must be supplied.</p> </li>
        /// <li> <p>If the source type is <code>DBParameterGroup</code>, a <code>DBParameterGroupName</code> must be supplied.</p> </li>
        /// <li> <p>If the source type is <code>DBSnapshot</code>, a <code>DBSnapshotIdentifier</code> must be supplied.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_identifier(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.inner = self.inner.source_type(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// <p> The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p> The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p> The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p> The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The number of minutes to retrieve events for.</p>
        /// <p>Default: 60</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.inner = self.inner.duration(input);
            self
        }
        /// <p>The number of minutes to retrieve events for.</p>
        /// <p>Default: 60</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>A list of event categories that trigger notifications for a event notification subscription.</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(input.into());
            self
        }
        /// <p>A list of event categories that trigger notifications for a event notification subscription.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeEvents request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeEvents request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventSubscriptions`.
    ///
    /// <p>Lists all the subscription descriptions for a customer account. The description for a subscription includes SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.</p>
    /// <p>If you specify a SubscriptionName, lists the description for that subscription.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventSubscriptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_event_subscriptions_input::Builder,
    }
    impl DescribeEventSubscriptions {
        /// Creates a new `DescribeEventSubscriptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventSubscriptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventSubscriptionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEventSubscriptionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEventSubscriptionsPaginator {
            crate::paginator::DescribeEventSubscriptionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the event notification subscription you want to describe.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(input.into());
            self
        }
        /// <p>The name of the event notification subscription you want to describe.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrderableDBInstanceOptions`.
    ///
    /// <p>Returns a list of orderable DB instance options for the specified engine.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOrderableDBInstanceOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_orderable_db_instance_options_input::Builder,
    }
    impl DescribeOrderableDBInstanceOptions {
        /// Creates a new `DescribeOrderableDBInstanceOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrderableDbInstanceOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeOrderableDBInstanceOptionsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeOrderableDbInstanceOptionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeOrderableDbInstanceOptionsPaginator {
            crate::paginator::DescribeOrderableDbInstanceOptionsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of the engine to retrieve DB instance options for.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(input.into());
            self
        }
        /// <p>The name of the engine to retrieve DB instance options for.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The engine version filter value. Specify this parameter to show only the available offerings matching the specified engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The engine version filter value. Specify this parameter to show only the available offerings matching the specified engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class.</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_class(input.into());
            self
        }
        /// <p>The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_class(input);
            self
        }
        /// <p>The license model filter value. Specify this parameter to show only the available offerings matching the specified license model.</p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_model(input.into());
            self
        }
        /// <p>The license model filter value. Specify this parameter to show only the available offerings matching the specified license model.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_model(input);
            self
        }
        /// <p>The VPC filter value. Specify this parameter to show only the available VPC or non-VPC offerings.</p>
        pub fn vpc(mut self, input: bool) -> Self {
            self.inner = self.inner.vpc(input);
            self
        }
        /// <p>The VPC filter value. Specify this parameter to show only the available VPC or non-VPC offerings.</p>
        pub fn set_vpc(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_vpc(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePendingMaintenanceActions`.
    ///
    /// <p>Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePendingMaintenanceActions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_pending_maintenance_actions_input::Builder,
    }
    impl DescribePendingMaintenanceActions {
        /// Creates a new `DescribePendingMaintenanceActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePendingMaintenanceActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePendingMaintenanceActionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribePendingMaintenanceActionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribePendingMaintenanceActionsPaginator {
            crate::paginator::DescribePendingMaintenanceActionsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ARN of a resource to return pending maintenance actions for.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(input.into());
            self
        }
        /// <p>The ARN of a resource to return pending maintenance actions for.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more resources to return pending maintenance actions for.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include pending maintenance actions for the DB clusters identified by these ARNs.</p> </li>
        /// <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance ARNs. The results list will only include pending maintenance actions for the DB instances identified by these ARNs.</p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A filter that specifies one or more resources to return pending maintenance actions for.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include pending maintenance actions for the DB clusters identified by these ARNs.</p> </li>
        /// <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance ARNs. The results list will only include pending maintenance actions for the DB instances identified by these ARNs.</p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeValidDBInstanceModifications`.
    ///
    /// <p>You can call <code>DescribeValidDBInstanceModifications</code> to learn what modifications you can make to your DB instance. You can use this information when you call <code>ModifyDBInstance</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeValidDBInstanceModifications {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_valid_db_instance_modifications_input::Builder,
    }
    impl DescribeValidDBInstanceModifications {
        /// Creates a new `DescribeValidDBInstanceModifications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeValidDbInstanceModificationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeValidDBInstanceModificationsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The customer identifier or the ARN of your DB instance.</p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(input.into());
            self
        }
        /// <p>The customer identifier or the ARN of your DB instance.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `FailoverDBCluster`.
    ///
    /// <p>Forces a failover for a DB cluster.</p>
    /// <p>A failover for a DB cluster promotes one of the Read Replicas (read-only instances) in the DB cluster to be the primary instance (the cluster writer).</p>
    /// <p>Amazon Neptune will automatically fail over to a Read Replica, if one exists, when the primary instance fails. You can force a failover when you want to simulate a failure of a primary instance for testing. Because each instance in a DB cluster has its own endpoint address, you will need to clean up and re-establish any existing connections that use those endpoint addresses when the failover is complete.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct FailoverDBCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::failover_db_cluster_input::Builder,
    }
    impl FailoverDBCluster {
        /// Creates a new `FailoverDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::FailoverDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::FailoverDBClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A DB cluster identifier to force a failover for. This parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBCluster.</p> </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>A DB cluster identifier to force a failover for. This parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBCluster.</p> </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The name of the instance to promote to the primary instance.</p>
        /// <p>You must specify the instance identifier for an Read Replica in the DB cluster. For example, <code>mydbcluster-replica1</code>.</p>
        pub fn target_db_instance_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_db_instance_identifier(input.into());
            self
        }
        /// <p>The name of the instance to promote to the primary instance.</p>
        /// <p>You must specify the instance identifier for an Read Replica in the DB cluster. For example, <code>mydbcluster-replica1</code>.</p>
        pub fn set_target_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_instance_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags on an Amazon Neptune resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Neptune resource with tags to be listed. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The Amazon Neptune resource with tags to be listed. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBCluster`.
    ///
    /// <p>Modify a setting for a DB cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyDBCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_db_cluster_input::Builder,
    }
    impl ModifyDBCluster {
        /// Creates a new `ModifyDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB cluster identifier for the cluster being modified. This parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBCluster.</p> </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The DB cluster identifier for the cluster being modified. This parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBCluster.</p> </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li>
        /// <li> <p>The first character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster2</code> </p>
        pub fn new_db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_db_cluster_identifier(input.into());
            self
        }
        /// <p>The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li>
        /// <li> <p>The first character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster2</code> </p>
        pub fn set_new_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_db_cluster_identifier(input);
            self
        }
        /// <p>A value that specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB cluster. If this parameter is set to <code>false</code>, changes to the DB cluster are applied during the next maintenance window.</p>
        /// <p>The <code>ApplyImmediately</code> parameter only affects <code>NewDBClusterIdentifier</code> values. If you set the <code>ApplyImmediately</code> parameter value to false, then changes to <code>NewDBClusterIdentifier</code> values are applied during the next maintenance window. All other changes are applied immediately, regardless of the value of the <code>ApplyImmediately</code> parameter.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.inner = self.inner.apply_immediately(input);
            self
        }
        /// <p>A value that specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB cluster. If this parameter is set to <code>false</code>, changes to the DB cluster are applied during the next maintenance window.</p>
        /// <p>The <code>ApplyImmediately</code> parameter only affects <code>NewDBClusterIdentifier</code> values. If you set the <code>ApplyImmediately</code> parameter value to false, then changes to <code>NewDBClusterIdentifier</code> values are applied during the next maintenance window. All other changes are applied immediately, regardless of the value of the <code>ApplyImmediately</code> parameter.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_immediately(input);
            self
        }
        /// <p>The number of days for which automated backups are retained. You must specify a minimum value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be a value from 1 to 35</p> </li>
        /// </ul>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.inner = self.inner.backup_retention_period(input);
            self
        }
        /// <p>The number of days for which automated backups are retained. You must specify a minimum value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be a value from 1 to 35</p> </li>
        /// </ul>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_backup_retention_period(input);
            self
        }
        /// <p>The name of the DB cluster parameter group to use for the DB cluster.</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group to use for the DB cluster.</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of VPC security groups that the DB cluster will belong to.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(input.into());
            self
        }
        /// <p>A list of VPC security groups that the DB cluster will belong to.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>The port number on which the DB cluster accepts connections.</p>
        /// <p>Constraints: Value must be <code>1150-65535</code> </p>
        /// <p>Default: The same port as the original DB cluster.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port number on which the DB cluster accepts connections.</p>
        /// <p>Constraints: Value must be <code>1150-65535</code> </p>
        /// <p>Default: The same port as the original DB cluster.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// <p> <i>Not supported by Neptune.</i> </p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(input.into());
            self
        }
        /// <p> <i>Not supported by Neptune.</i> </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>
        /// <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>
        /// <li> <p>Must not conflict with the preferred maintenance window.</p> </li>
        /// <li> <p>Must be at least 30 minutes.</p> </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_backup_window(input.into());
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>
        /// <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>
        /// <li> <p>Must not conflict with the preferred maintenance window.</p> </li>
        /// <li> <p>Must be at least 30 minutes.</p> </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_backup_window(input);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.preferred_maintenance_window(input.into());
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn enable_iam_database_authentication(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_iam_database_authentication(input);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_iam_database_authentication(input);
            self
        }
        /// <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB cluster.</p>
        pub fn cloudwatch_logs_export_configuration(
            mut self,
            input: crate::model::CloudwatchLogsExportConfiguration,
        ) -> Self {
            self.inner = self.inner.cloudwatch_logs_export_configuration(input);
            self
        }
        /// <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB cluster.</p>
        pub fn set_cloudwatch_logs_export_configuration(
            mut self,
            input: std::option::Option<crate::model::CloudwatchLogsExportConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_cloudwatch_logs_export_configuration(input);
            self
        }
        /// <p>The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is set to true.</p>
        /// <p>For a list of valid engine versions, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/engine-releases.html">Engine Releases for Amazon Neptune</a>, or call <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-other-apis.html#DescribeDBEngineVersions">DescribeDBEngineVersions</a>.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is set to true.</p>
        /// <p>For a list of valid engine versions, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/engine-releases.html">Engine Releases for Amazon Neptune</a>, or call <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-other-apis.html#DescribeDBEngineVersions">DescribeDBEngineVersions</a>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>A value that indicates whether upgrades between different major versions are allowed.</p>
        /// <p>Constraints: You must set the allow-major-version-upgrade flag when providing an <code>EngineVersion</code> parameter that uses a different major version than the DB cluster's current version.</p>
        pub fn allow_major_version_upgrade(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_major_version_upgrade(input);
            self
        }
        /// <p>A value that indicates whether upgrades between different major versions are allowed.</p>
        /// <p>Constraints: You must set the allow-major-version-upgrade flag when providing an <code>EngineVersion</code> parameter that uses a different major version than the DB cluster's current version.</p>
        pub fn set_allow_major_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_major_version_upgrade(input);
            self
        }
        /// <p>The name of the DB parameter group to apply to all instances of the DB cluster. </p> <note>
        /// <p>When you apply a parameter group using <code>DBInstanceParameterGroupName</code>, parameter changes aren't applied during the next maintenance window but instead are applied immediately.</p>
        /// </note>
        /// <p>Default: The existing name setting</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>The DB parameter group must be in the same DB parameter group family as the target DB cluster version.</p> </li>
        /// <li> <p>The <code>DBInstanceParameterGroupName</code> parameter is only valid in combination with the <code>AllowMajorVersionUpgrade</code> parameter.</p> </li>
        /// </ul>
        pub fn db_instance_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_instance_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the DB parameter group to apply to all instances of the DB cluster. </p> <note>
        /// <p>When you apply a parameter group using <code>DBInstanceParameterGroupName</code>, parameter changes aren't applied during the next maintenance window but instead are applied immediately.</p>
        /// </note>
        /// <p>Default: The existing name setting</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>The DB parameter group must be in the same DB parameter group family as the target DB cluster version.</p> </li>
        /// <li> <p>The <code>DBInstanceParameterGroupName</code> parameter is only valid in combination with the <code>AllowMajorVersionUpgrade</code> parameter.</p> </li>
        /// </ul>
        pub fn set_db_instance_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_parameter_group_name(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.inner = self.inner.deletion_protection(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
        /// <p> <i>If set to <code>true</code>, tags are copied to any snapshot of the DB cluster that is created.</i> </p>
        pub fn copy_tags_to_snapshot(mut self, input: bool) -> Self {
            self.inner = self.inner.copy_tags_to_snapshot(input);
            self
        }
        /// <p> <i>If set to <code>true</code>, tags are copied to any snapshot of the DB cluster that is created.</i> </p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags_to_snapshot(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBClusterEndpoint`.
    ///
    /// <p>Modifies the properties of an endpoint in an Amazon Neptune DB cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyDBClusterEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_db_cluster_endpoint_input::Builder,
    }
    impl ModifyDBClusterEndpoint {
        /// Creates a new `ModifyDBClusterEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDbClusterEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the endpoint to modify. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_endpoint_identifier(input.into());
            self
        }
        /// <p>The identifier of the endpoint to modify. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_endpoint_identifier(input);
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_type(input.into());
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_type(input);
            self
        }
        /// Appends an item to `StaticMembers`.
        ///
        /// To override the contents of this collection use [`set_static_members`](Self::set_static_members).
        ///
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn static_members(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.static_members(input.into());
            self
        }
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn set_static_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_static_members(input);
            self
        }
        /// Appends an item to `ExcludedMembers`.
        ///
        /// To override the contents of this collection use [`set_excluded_members`](Self::set_excluded_members).
        ///
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
        pub fn excluded_members(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.excluded_members(input.into());
            self
        }
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
        pub fn set_excluded_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_excluded_members(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBClusterParameterGroup`.
    ///
    /// <p> Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20 parameters can be modified in a single request.</p> <note>
    /// <p>Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without failover to the DB cluster associated with the parameter group before the change can take effect.</p>
    /// </note> <important>
    /// <p>After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon Neptune to fully complete the create action before the parameter group is used as the default for a new DB cluster. This is especially important for parameters that are critical when creating the default database for a DB cluster, such as the character set for the default database defined by the <code>character_set_database</code> parameter. You can use the <i>Parameter Groups</i> option of the Amazon Neptune console or the <code>DescribeDBClusterParameters</code> command to verify that your DB cluster parameter group has been created or modified.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyDBClusterParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_db_cluster_parameter_group_input::Builder,
    }
    impl ModifyDBClusterParameterGroup {
        /// Creates a new `ModifyDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster parameter group to modify.</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group to modify.</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of parameters in the DB cluster parameter group to modify.</p>
        pub fn parameters(mut self, input: crate::model::Parameter) -> Self {
            self.inner = self.inner.parameters(input);
            self
        }
        /// <p>A list of parameters in the DB cluster parameter group to modify.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBClusterSnapshotAttribute`.
    ///
    /// <p>Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.</p>
    /// <p>To share a manual DB cluster snapshot with other Amazon accounts, specify <code>restore</code> as the <code>AttributeName</code> and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the Amazon accounts that are authorized to restore the manual DB cluster snapshot. Use the value <code>all</code> to make the manual DB cluster snapshot public, which means that it can be copied or restored by all Amazon accounts. Do not add the <code>all</code> value for any manual DB cluster snapshots that contain private information that you don't want available to all Amazon accounts. If a manual DB cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized Amazon account IDs for the <code>ValuesToAdd</code> parameter. You can't use <code>all</code> as a value for that parameter in this case.</p>
    /// <p>To view which Amazon accounts have access to copy or restore a manual DB cluster snapshot, or whether a manual DB cluster snapshot public or private, use the <code>DescribeDBClusterSnapshotAttributes</code> API action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyDBClusterSnapshotAttribute {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_db_cluster_snapshot_attribute_input::Builder,
    }
    impl ModifyDBClusterSnapshotAttribute {
        /// Creates a new `ModifyDBClusterSnapshotAttribute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDbClusterSnapshotAttributeOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterSnapshotAttributeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the DB cluster snapshot to modify the attributes for.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(input.into());
            self
        }
        /// <p>The identifier for the DB cluster snapshot to modify the attributes for.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The name of the DB cluster snapshot attribute to modify.</p>
        /// <p>To manage authorization for other Amazon accounts to copy or restore a manual DB cluster snapshot, set this value to <code>restore</code>.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_name(input.into());
            self
        }
        /// <p>The name of the DB cluster snapshot attribute to modify.</p>
        /// <p>To manage authorization for other Amazon accounts to copy or restore a manual DB cluster snapshot, set this value to <code>restore</code>.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attribute_name(input);
            self
        }
        /// Appends an item to `ValuesToAdd`.
        ///
        /// To override the contents of this collection use [`set_values_to_add`](Self::set_values_to_add).
        ///
        /// <p>A list of DB cluster snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p>
        /// <p>To authorize other Amazon accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more Amazon account IDs, or <code>all</code> to make the manual DB cluster snapshot restorable by any Amazon account. Do not add the <code>all</code> value for any manual DB cluster snapshots that contain private information that you don't want available to all Amazon accounts.</p>
        pub fn values_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.values_to_add(input.into());
            self
        }
        /// <p>A list of DB cluster snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p>
        /// <p>To authorize other Amazon accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more Amazon account IDs, or <code>all</code> to make the manual DB cluster snapshot restorable by any Amazon account. Do not add the <code>all</code> value for any manual DB cluster snapshots that contain private information that you don't want available to all Amazon accounts.</p>
        pub fn set_values_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_values_to_add(input);
            self
        }
        /// Appends an item to `ValuesToRemove`.
        ///
        /// To override the contents of this collection use [`set_values_to_remove`](Self::set_values_to_remove).
        ///
        /// <p>A list of DB cluster snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.</p>
        /// <p>To remove authorization for other Amazon accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more Amazon account identifiers, or <code>all</code> to remove authorization for any Amazon account to copy or restore the DB cluster snapshot. If you specify <code>all</code>, an Amazon account whose account ID is explicitly added to the <code>restore</code> attribute can still copy or restore a manual DB cluster snapshot.</p>
        pub fn values_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.values_to_remove(input.into());
            self
        }
        /// <p>A list of DB cluster snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.</p>
        /// <p>To remove authorization for other Amazon accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more Amazon account identifiers, or <code>all</code> to remove authorization for any Amazon account to copy or restore the DB cluster snapshot. If you specify <code>all</code>, an Amazon account whose account ID is explicitly added to the <code>restore</code> attribute can still copy or restore a manual DB cluster snapshot.</p>
        pub fn set_values_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_values_to_remove(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBInstance`.
    ///
    /// <p>Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. To learn what modifications you can make to your DB instance, call <code>DescribeValidDBInstanceModifications</code> before you call <code>ModifyDBInstance</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyDBInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_db_instance_input::Builder,
    }
    impl ModifyDBInstance {
        /// Creates a new `ModifyDBInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDbInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDBInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB instance identifier. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBInstance.</p> </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(input.into());
            self
        }
        /// <p>The DB instance identifier. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBInstance.</p> </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.inner = self.inner.allocated_storage(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_allocated_storage(input);
            self
        }
        /// <p>The new compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>. Not all DB instance classes are available in all Amazon Regions.</p>
        /// <p>If you modify the DB instance class, an outage occurs during the change. The change is applied during the next maintenance window, unless <code>ApplyImmediately</code> is specified as <code>true</code> for this request.</p>
        /// <p>Default: Uses existing setting</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_class(input.into());
            self
        }
        /// <p>The new compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>. Not all DB instance classes are available in all Amazon Regions.</p>
        /// <p>If you modify the DB instance class, an outage occurs during the change. The change is applied during the next maintenance window, unless <code>ApplyImmediately</code> is specified as <code>true</code> for this request.</p>
        /// <p>Default: Uses existing setting</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_class(input);
            self
        }
        /// <p>The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a different VPC.</p>
        /// <p>Changing the subnet group causes an outage during the change. The change is applied during the next maintenance window, unless you specify <code>true</code> for the <code>ApplyImmediately</code> parameter.</p>
        /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// <p>Example: <code>mySubnetGroup</code> </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(input.into());
            self
        }
        /// <p>The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a different VPC.</p>
        /// <p>Changing the subnet group causes an outage during the change. The change is applied during the next maintenance window, unless you specify <code>true</code> for the <code>ApplyImmediately</code> parameter.</p>
        /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// <p>Example: <code>mySubnetGroup</code> </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// Appends an item to `DBSecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_db_security_groups`](Self::set_db_security_groups).
        ///
        /// <p>A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in an outage and the change is asynchronously applied as soon as possible.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match existing DBSecurityGroups.</p> </li>
        /// </ul>
        pub fn db_security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_security_groups(input.into());
            self
        }
        /// <p>A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in an outage and the change is asynchronously applied as soon as possible.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match existing DBSecurityGroups.</p> </li>
        /// </ul>
        pub fn set_db_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_db_security_groups(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of EC2 VPC security groups to authorize on this DB instance. This change is asynchronously applied as soon as possible.</p>
        /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match existing VpcSecurityGroupIds.</p> </li>
        /// </ul>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(input.into());
            self
        }
        /// <p>A list of EC2 VPC security groups to authorize on this DB instance. This change is asynchronously applied as soon as possible.</p>
        /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match existing VpcSecurityGroupIds.</p> </li>
        /// </ul>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>Specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB instance.</p>
        /// <p> If this parameter is set to <code>false</code>, changes to the DB instance are applied during the next maintenance window. Some parameter changes can cause an outage and are applied on the next call to <code>RebootDBInstance</code>, or the next failure reboot.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.inner = self.inner.apply_immediately(input);
            self
        }
        /// <p>Specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB instance.</p>
        /// <p> If this parameter is set to <code>false</code>, changes to the DB instance are applied during the next maintenance window. Some parameter changes can cause an outage and are applied on the next call to <code>RebootDBInstance</code>, or the next failure reboot.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_immediately(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// <p>The name of the DB parameter group to apply to the DB instance. Changing this setting doesn't result in an outage. The parameter group name itself is changed immediately, but the actual parameter changes are not applied until you reboot the instance without failover. The db instance will NOT be rebooted automatically and the parameter changes will NOT be applied during the next maintenance window.</p>
        /// <p>Default: Uses existing setting</p>
        /// <p>Constraints: The DB parameter group must be in the same DB parameter group family as this DB instance.</p>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the DB parameter group to apply to the DB instance. Changing this setting doesn't result in an outage. The parameter group name itself is changed immediately, but the actual parameter changes are not applied until you reboot the instance without failover. The db instance will NOT be rebooted automatically and the parameter changes will NOT be applied during the next maintenance window.</p>
        /// <p>Default: Uses existing setting</p>
        /// <p>Constraints: The DB parameter group must be in the same DB parameter group family as this DB instance.</p>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p>
        /// <p>Default: Uses existing setting</p>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.inner = self.inner.backup_retention_period(input);
            self
        }
        /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p>
        /// <p>Default: Uses existing setting</p>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_backup_retention_period(input);
            self
        }
        /// <p> The daily time range during which automated backups are created if automated backups are enabled.</p>
        /// <p>Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the format hh24:mi-hh24:mi</p> </li>
        /// <li> <p>Must be in Universal Time Coordinated (UTC)</p> </li>
        /// <li> <p>Must not conflict with the preferred maintenance window</p> </li>
        /// <li> <p>Must be at least 30 minutes</p> </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_backup_window(input.into());
            self
        }
        /// <p> The daily time range during which automated backups are created if automated backups are enabled.</p>
        /// <p>Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the format hh24:mi-hh24:mi</p> </li>
        /// <li> <p>Must be in Universal Time Coordinated (UTC)</p> </li>
        /// <li> <p>Must not conflict with the preferred maintenance window</p> </li>
        /// <li> <p>Must be at least 30 minutes</p> </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_backup_window(input);
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage. Changing this parameter doesn't result in an outage, except in the following situation, and the change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance window is changed to include the current time, then changing this parameter will cause a reboot of the DB instance. If moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure pending changes are applied.</p>
        /// <p>Default: Uses existing setting</p>
        /// <p>Format: ddd:hh24:mi-ddd:hh24:mi</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Must be at least 30 minutes</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.preferred_maintenance_window(input.into());
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage. Changing this parameter doesn't result in an outage, except in the following situation, and the change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance window is changed to include the current time, then changing this parameter will cause a reboot of the DB instance. If moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure pending changes are applied.</p>
        /// <p>Default: Uses existing setting</p>
        /// <p>Format: ddd:hh24:mi-ddd:hh24:mi</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Must be at least 30 minutes</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter doesn't result in an outage and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request.</p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.inner = self.inner.multi_az(input);
            self
        }
        /// <p>Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter doesn't result in an outage and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_multi_az(input);
            self
        }
        /// <p>The version number of the database engine to upgrade to. Currently, setting this parameter has no effect. To upgrade your database engine to the most recent release, use the <code>ApplyPendingMaintenanceAction</code> API.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The version number of the database engine to upgrade to. Currently, setting this parameter has no effect. To upgrade your database engine to the most recent release, use the <code>ApplyPendingMaintenanceAction</code> API.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>Indicates that major version upgrades are allowed. Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.</p>
        pub fn allow_major_version_upgrade(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_major_version_upgrade(input);
            self
        }
        /// <p>Indicates that major version upgrades are allowed. Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.</p>
        pub fn set_allow_major_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_major_version_upgrade(input);
            self
        }
        /// <p> Indicates that minor version upgrades are applied automatically to the DB instance during the maintenance window. Changing this parameter doesn't result in an outage except in the following case and the change is asynchronously applied as soon as possible. An outage will result if this parameter is set to <code>true</code> during the maintenance window, and a newer minor version is available, and Neptune has enabled auto patching for that engine version.</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(input);
            self
        }
        /// <p> Indicates that minor version upgrades are applied automatically to the DB instance during the maintenance window. Changing this parameter doesn't result in an outage except in the following case and the change is asynchronously applied as soon as possible. An outage will result if this parameter is set to <code>true</code> during the maintenance window, and a newer minor version is available, and Neptune has enabled auto patching for that engine version.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_model(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_model(input);
            self
        }
        /// <p>The new Provisioned IOPS (I/O operations per second) value for the instance.</p>
        /// <p>Changing this setting doesn't result in an outage and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request.</p>
        /// <p>Default: Uses existing setting</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.inner = self.inner.iops(input);
            self
        }
        /// <p>The new Provisioned IOPS (I/O operations per second) value for the instance.</p>
        /// <p>Changing this setting doesn't result in an outage and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request.</p>
        /// <p>Default: Uses existing setting</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_iops(input);
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(input.into());
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// <p> The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB instance identifier, an instance reboot will occur immediately if you set <code>Apply Immediately</code> to true, or will occur during the next maintenance window if <code>Apply Immediately</code> to false. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>The first character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code> </p>
        pub fn new_db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_db_instance_identifier(input.into());
            self
        }
        /// <p> The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB instance identifier, an instance reboot will occur immediately if you set <code>Apply Immediately</code> to true, or will occur during the next maintenance window if <code>Apply Immediately</code> to false. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>The first character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code> </p>
        pub fn set_new_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_db_instance_identifier(input);
            self
        }
        /// <p>Not supported.</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.storage_type(input.into());
            self
        }
        /// <p>Not supported.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_storage_type(input);
            self
        }
        /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
        pub fn tde_credential_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tde_credential_arn(input.into());
            self
        }
        /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
        pub fn set_tde_credential_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tde_credential_arn(input);
            self
        }
        /// <p>The password for the given ARN from the key store in order to access the device.</p>
        pub fn tde_credential_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tde_credential_password(input.into());
            self
        }
        /// <p>The password for the given ARN from the key store in order to access the device.</p>
        pub fn set_tde_credential_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tde_credential_password(input);
            self
        }
        /// <p>Indicates the certificate that needs to be associated with the instance.</p>
        pub fn ca_certificate_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ca_certificate_identifier(input.into());
            self
        }
        /// <p>Indicates the certificate that needs to be associated with the instance.</p>
        pub fn set_ca_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ca_certificate_identifier(input);
            self
        }
        /// <p>Not supported.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>Not supported.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise false. The default is false.</p>
        pub fn copy_tags_to_snapshot(mut self, input: bool) -> Self {
            self.inner = self.inner.copy_tags_to_snapshot(input);
            self
        }
        /// <p>True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise false. The default is false.</p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags_to_snapshot(input);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
        pub fn monitoring_interval(mut self, input: i32) -> Self {
            self.inner = self.inner.monitoring_interval(input);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
        pub fn set_monitoring_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_monitoring_interval(input);
            self
        }
        /// <p>The port number on which the database accepts connections.</p>
        /// <p>The value of the <code>DBPortNumber</code> parameter must not match any of the port values specified for options in the option group for the DB instance.</p>
        /// <p>Your database will restart when you change the <code>DBPortNumber</code> value regardless of the value of the <code>ApplyImmediately</code> parameter.</p>
        /// <p> Default: <code>8182</code> </p>
        pub fn db_port_number(mut self, input: i32) -> Self {
            self.inner = self.inner.db_port_number(input);
            self
        }
        /// <p>The port number on which the database accepts connections.</p>
        /// <p>The value of the <code>DBPortNumber</code> parameter must not match any of the port values specified for options in the option group for the DB instance.</p>
        /// <p>Your database will restart when you change the <code>DBPortNumber</code> value regardless of the value of the <code>ApplyImmediately</code> parameter.</p>
        /// <p> Default: <code>8182</code> </p>
        pub fn set_db_port_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_db_port_number(input);
            self
        }
        /// <p>This flag should no longer be used.</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.inner = self.inner.publicly_accessible(input);
            self
        }
        /// <p>This flag should no longer be used.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_accessible(input);
            self
        }
        /// <p>The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>
        pub fn monitoring_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.monitoring_role_arn(input.into());
            self
        }
        /// <p>The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>
        pub fn set_monitoring_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_monitoring_role_arn(input);
            self
        }
        /// <p>Not supported</p>
        pub fn domain_iam_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_iam_role_name(input.into());
            self
        }
        /// <p>Not supported</p>
        pub fn set_domain_iam_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_domain_iam_role_name(input);
            self
        }
        /// <p>A value that specifies the order in which a Read Replica is promoted to the primary instance after a failure of the existing primary instance.</p>
        /// <p>Default: 1</p>
        /// <p>Valid Values: 0 - 15</p>
        pub fn promotion_tier(mut self, input: i32) -> Self {
            self.inner = self.inner.promotion_tier(input);
            self
        }
        /// <p>A value that specifies the order in which a Read Replica is promoted to the primary instance after a failure of the existing primary instance.</p>
        /// <p>Default: 1</p>
        /// <p>Valid Values: 0 - 15</p>
        pub fn set_promotion_tier(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_promotion_tier(input);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.</p>
        /// <p>You can enable IAM database authentication for the following database engines</p>
        /// <p>Not applicable. Mapping Amazon IAM accounts to database accounts is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn enable_iam_database_authentication(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_iam_database_authentication(input);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.</p>
        /// <p>You can enable IAM database authentication for the following database engines</p>
        /// <p>Not applicable. Mapping Amazon IAM accounts to database accounts is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_iam_database_authentication(input);
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn enable_performance_insights(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_performance_insights(input);
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn set_enable_performance_insights(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_performance_insights(input);
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn performance_insights_kms_key_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.performance_insights_kms_key_id(input.into());
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn set_performance_insights_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_performance_insights_kms_key_id(input);
            self
        }
        /// <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB instance or DB cluster.</p>
        pub fn cloudwatch_logs_export_configuration(
            mut self,
            input: crate::model::CloudwatchLogsExportConfiguration,
        ) -> Self {
            self.inner = self.inner.cloudwatch_logs_export_configuration(input);
            self
        }
        /// <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB instance or DB cluster.</p>
        pub fn set_cloudwatch_logs_export_configuration(
            mut self,
            input: std::option::Option<crate::model::CloudwatchLogsExportConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_cloudwatch_logs_export_configuration(input);
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting a DB Instance</a>.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.inner = self.inner.deletion_protection(input);
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting a DB Instance</a>.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBParameterGroup`.
    ///
    /// <p>Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20 parameters can be modified in a single request.</p> <note>
    /// <p>Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without failover to the DB instance associated with the parameter group before the change can take effect.</p>
    /// </note> <important>
    /// <p>After you modify a DB parameter group, you should wait at least 5 minutes before creating your first DB instance that uses that DB parameter group as the default parameter group. This allows Amazon Neptune to fully complete the modify action before the parameter group is used as the default for a new DB instance. This is especially important for parameters that are critical when creating the default database for a DB instance, such as the character set for the default database defined by the <code>character_set_database</code> parameter. You can use the <i>Parameter Groups</i> option of the Amazon Neptune console or the <i>DescribeDBParameters</i> command to verify that your DB parameter group has been created or modified.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyDBParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_db_parameter_group_input::Builder,
    }
    impl ModifyDBParameterGroup {
        /// Creates a new `ModifyDBParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDbParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDBParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBParameterGroup.</p> </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBParameterGroup.</p> </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>An array of parameter names, values, and the apply method for the parameter update. At least one parameter name, value, and apply method must be supplied; subsequent arguments are optional. A maximum of 20 parameters can be modified in a single request.</p>
        /// <p>Valid Values (for the application method): <code>immediate | pending-reboot</code> </p> <note>
        /// <p>You can use the immediate value with dynamic parameters only. You can use the pending-reboot value for both dynamic and static parameters, and changes are applied when you reboot the DB instance without failover.</p>
        /// </note>
        pub fn parameters(mut self, input: crate::model::Parameter) -> Self {
            self.inner = self.inner.parameters(input);
            self
        }
        /// <p>An array of parameter names, values, and the apply method for the parameter update. At least one parameter name, value, and apply method must be supplied; subsequent arguments are optional. A maximum of 20 parameters can be modified in a single request.</p>
        /// <p>Valid Values (for the application method): <code>immediate | pending-reboot</code> </p> <note>
        /// <p>You can use the immediate value with dynamic parameters only. You can use the pending-reboot value for both dynamic and static parameters, and changes are applied when you reboot the DB instance without failover.</p>
        /// </note>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBSubnetGroup`.
    ///
    /// <p>Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyDBSubnetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_db_subnet_group_input::Builder,
    }
    impl ModifyDBSubnetGroup {
        /// Creates a new `ModifyDBSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDbSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDBSubnetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the DB subnet group. This value is stored as a lowercase string. You can't modify the default subnet group.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code> </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(input.into());
            self
        }
        /// <p>The name for the DB subnet group. This value is stored as a lowercase string. You can't modify the default subnet group.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code> </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p>The description for the DB subnet group.</p>
        pub fn db_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_subnet_group_description(input.into());
            self
        }
        /// <p>The description for the DB subnet group.</p>
        pub fn set_db_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The EC2 subnet IDs for the DB subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>The EC2 subnet IDs for the DB subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyEventSubscription`.
    ///
    /// <p>Modifies an existing event notification subscription. Note that you can't modify the source identifiers using this call; to change source identifiers for a subscription, use the <code>AddSourceIdentifierToSubscription</code> and <code>RemoveSourceIdentifierFromSubscription</code> calls.</p>
    /// <p>You can see a list of the event categories for a given SourceType by using the <b>DescribeEventCategories</b> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyEventSubscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_event_subscription_input::Builder,
    }
    impl ModifyEventSubscription {
        /// Creates a new `ModifyEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyEventSubscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event notification subscription.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(input.into());
            self
        }
        /// <p>The name of the event notification subscription.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you would set this parameter to db-instance. if this value is not specified, all events are returned.</p>
        /// <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(input.into());
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you would set this parameter to db-instance. if this value is not specified, all events are returned.</p>
        /// <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p> A list of event categories for a SourceType that you want to subscribe to. You can see a list of the categories for a given SourceType by using the <b>DescribeEventCategories</b> action.</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(input.into());
            self
        }
        /// <p> A list of event categories for a SourceType that you want to subscribe to. You can see a list of the categories for a given SourceType by using the <b>DescribeEventCategories</b> action.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// <p> A Boolean value; set to <b>true</b> to activate the subscription.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p> A Boolean value; set to <b>true</b> to activate the subscription.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PromoteReadReplicaDBCluster`.
    ///
    /// <p>Not supported.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PromoteReadReplicaDBCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::promote_read_replica_db_cluster_input::Builder,
    }
    impl PromoteReadReplicaDBCluster {
        /// Creates a new `PromoteReadReplicaDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PromoteReadReplicaDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::PromoteReadReplicaDBClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Not supported.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>Not supported.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RebootDBInstance`.
    ///
    /// <p>You might need to reboot your DB instance, usually for maintenance reasons. For example, if you make certain modifications, or if you change the DB parameter group associated with the DB instance, you must reboot the instance for the changes to take effect.</p>
    /// <p>Rebooting a DB instance restarts the database engine service. Rebooting a DB instance results in a momentary outage, during which the DB instance status is set to rebooting.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RebootDBInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reboot_db_instance_input::Builder,
    }
    impl RebootDBInstance {
        /// Creates a new `RebootDBInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RebootDbInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::RebootDBInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBInstance.</p> </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(input.into());
            self
        }
        /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBInstance.</p> </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p> When <code>true</code>, the reboot is conducted through a MultiAZ failover.</p>
        /// <p>Constraint: You can't specify <code>true</code> if the instance is not configured for MultiAZ.</p>
        pub fn force_failover(mut self, input: bool) -> Self {
            self.inner = self.inner.force_failover(input);
            self
        }
        /// <p> When <code>true</code>, the reboot is conducted through a MultiAZ failover.</p>
        /// <p>Constraint: You can't specify <code>true</code> if the instance is not configured for MultiAZ.</p>
        pub fn set_force_failover(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_failover(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveRoleFromDBCluster`.
    ///
    /// <p>Disassociates an Identity and Access Management (IAM) role from a DB cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveRoleFromDBCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_role_from_db_cluster_input::Builder,
    }
    impl RemoveRoleFromDBCluster {
        /// Creates a new `RemoveRoleFromDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveRoleFromDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveRoleFromDBClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster to disassociate the IAM role from.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The name of the DB cluster to disassociate the IAM role from.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to disassociate from the DB cluster, for example <code>arn:aws:iam::123456789012:role/NeptuneAccessRole</code>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to disassociate from the DB cluster, for example <code>arn:aws:iam::123456789012:role/NeptuneAccessRole</code>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The name of the feature for the DB cluster that the IAM role is to be disassociated from. For the list of supported feature names, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-other-apis.html#DescribeDBEngineVersions">DescribeDBEngineVersions</a>.</p>
        pub fn feature_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature_name(input.into());
            self
        }
        /// <p>The name of the feature for the DB cluster that the IAM role is to be disassociated from. For the list of supported feature names, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-other-apis.html#DescribeDBEngineVersions">DescribeDBEngineVersions</a>.</p>
        pub fn set_feature_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feature_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveSourceIdentifierFromSubscription`.
    ///
    /// <p>Removes a source identifier from an existing event notification subscription.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveSourceIdentifierFromSubscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_source_identifier_from_subscription_input::Builder,
    }
    impl RemoveSourceIdentifierFromSubscription {
        /// Creates a new `RemoveSourceIdentifierFromSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveSourceIdentifierFromSubscriptionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::RemoveSourceIdentifierFromSubscriptionError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event notification subscription you want to remove a source identifier from.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(input.into());
            self
        }
        /// <p>The name of the event notification subscription you want to remove a source identifier from.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p> The source identifier to be removed from the subscription, such as the <b>DB instance identifier</b> for a DB instance or the name of a security group.</p>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_identifier(input.into());
            self
        }
        /// <p> The source identifier to be removed from the subscription, such as the <b>DB instance identifier</b> for a DB instance or the name of a security group.</p>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTagsFromResource`.
    ///
    /// <p>Removes metadata tags from an Amazon Neptune resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveTagsFromResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_tags_from_resource_input::Builder,
    }
    impl RemoveTagsFromResource {
        /// Creates a new `RemoveTagsFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Neptune resource that the tags are removed from. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The Amazon Neptune resource that the tags are removed from. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetDBClusterParameterGroup`.
    ///
    /// <p> Modifies the parameters of a DB cluster parameter group to the default value. To reset specific parameters submit a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB cluster parameter group, specify the <code>DBClusterParameterGroupName</code> and <code>ResetAllParameters</code> parameters.</p>
    /// <p> When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to <code>pending-reboot</code> to take effect on the next DB instance restart or <code>RebootDBInstance</code> request. You must call <code>RebootDBInstance</code> for every DB instance in your DB cluster that you want the updated static parameter to apply to.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ResetDBClusterParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reset_db_cluster_parameter_group_input::Builder,
    }
    impl ResetDBClusterParameterGroup {
        /// Creates a new `ResetDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetDBClusterParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster parameter group to reset.</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group to reset.</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// <p>A value that is set to <code>true</code> to reset all parameters in the DB cluster parameter group to their default values, and <code>false</code> otherwise. You can't use this parameter if there is a list of parameter names specified for the <code>Parameters</code> parameter.</p>
        pub fn reset_all_parameters(mut self, input: bool) -> Self {
            self.inner = self.inner.reset_all_parameters(input);
            self
        }
        /// <p>A value that is set to <code>true</code> to reset all parameters in the DB cluster parameter group to their default values, and <code>false</code> otherwise. You can't use this parameter if there is a list of parameter names specified for the <code>Parameters</code> parameter.</p>
        pub fn set_reset_all_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reset_all_parameters(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of parameter names in the DB cluster parameter group to reset to the default values. You can't use this parameter if the <code>ResetAllParameters</code> parameter is set to <code>true</code>.</p>
        pub fn parameters(mut self, input: crate::model::Parameter) -> Self {
            self.inner = self.inner.parameters(input);
            self
        }
        /// <p>A list of parameter names in the DB cluster parameter group to reset to the default values. You can't use this parameter if the <code>ResetAllParameters</code> parameter is set to <code>true</code>.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetDBParameterGroup`.
    ///
    /// <p>Modifies the parameters of a DB parameter group to the engine/system default value. To reset specific parameters, provide a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB parameter group, specify the <code>DBParameterGroup</code> name and <code>ResetAllParameters</code> parameters. When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to <code>pending-reboot</code> to take effect on the next DB instance restart or <code>RebootDBInstance</code> request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ResetDBParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reset_db_parameter_group_input::Builder,
    }
    impl ResetDBParameterGroup {
        /// Creates a new `ResetDBParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetDbParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetDBParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the name of an existing DBParameterGroup.</p> </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the name of an existing DBParameterGroup.</p> </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// <p>Specifies whether (<code>true</code>) or not (<code>false</code>) to reset all parameters in the DB parameter group to default values.</p>
        /// <p>Default: <code>true</code> </p>
        pub fn reset_all_parameters(mut self, input: bool) -> Self {
            self.inner = self.inner.reset_all_parameters(input);
            self
        }
        /// <p>Specifies whether (<code>true</code>) or not (<code>false</code>) to reset all parameters in the DB parameter group to default values.</p>
        /// <p>Default: <code>true</code> </p>
        pub fn set_reset_all_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reset_all_parameters(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>To reset the entire DB parameter group, specify the <code>DBParameterGroup</code> name and <code>ResetAllParameters</code> parameters. To reset specific parameters, provide a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. A maximum of 20 parameters can be modified in a single request.</p>
        /// <p>Valid Values (for Apply method): <code>pending-reboot</code> </p>
        pub fn parameters(mut self, input: crate::model::Parameter) -> Self {
            self.inner = self.inner.parameters(input);
            self
        }
        /// <p>To reset the entire DB parameter group, specify the <code>DBParameterGroup</code> name and <code>ResetAllParameters</code> parameters. To reset specific parameters, provide a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. A maximum of 20 parameters can be modified in a single request.</p>
        /// <p>Valid Values (for Apply method): <code>pending-reboot</code> </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreDBClusterFromSnapshot`.
    ///
    /// <p>Creates a new DB cluster from a DB snapshot or DB cluster snapshot.</p>
    /// <p>If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.</p>
    /// <p>If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestoreDBClusterFromSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::restore_db_cluster_from_snapshot_input::Builder,
    }
    impl RestoreDBClusterFromSnapshot {
        /// Creates a new `RestoreDBClusterFromSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreDbClusterFromSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterFromSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AvailabilityZones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>Provides the list of EC2 Availability Zones that instances in the restored DB cluster can be created in.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zones(input.into());
            self
        }
        /// <p>Provides the list of EC2 Availability Zones that instances in the restored DB cluster can be created in.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_availability_zones(input);
            self
        }
        /// <p>The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code> </p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code> </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The identifier for the DB snapshot or DB cluster snapshot to restore from.</p>
        /// <p>You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing Snapshot.</p> </li>
        /// </ul>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier(input.into());
            self
        }
        /// <p>The identifier for the DB snapshot or DB cluster snapshot to restore from.</p>
        /// <p>You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing Snapshot.</p> </li>
        /// </ul>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier(input);
            self
        }
        /// <p>The database engine to use for the new DB cluster.</p>
        /// <p>Default: The same as source</p>
        /// <p>Constraint: Must be compatible with the engine of the source</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(input.into());
            self
        }
        /// <p>The database engine to use for the new DB cluster.</p>
        /// <p>Default: The same as source</p>
        /// <p>Constraint: Must be compatible with the engine of the source</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The version of the database engine to use for the new DB cluster.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The version of the database engine to use for the new DB cluster.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The port number on which the new DB cluster accepts connections.</p>
        /// <p>Constraints: Value must be <code>1150-65535</code> </p>
        /// <p>Default: The same port as the original DB cluster.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port number on which the new DB cluster accepts connections.</p>
        /// <p>Constraints: Value must be <code>1150-65535</code> </p>
        /// <p>Default: The same port as the original DB cluster.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The name of the DB subnet group to use for the new DB cluster.</p>
        /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// <p>Example: <code>mySubnetgroup</code> </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(input.into());
            self
        }
        /// <p>The name of the DB subnet group to use for the new DB cluster.</p>
        /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// <p>Example: <code>mySubnetgroup</code> </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p>Not supported.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(input.into());
            self
        }
        /// <p>Not supported.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(input.into());
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of VPC security groups that the new DB cluster will belong to.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(input.into());
            self
        }
        /// <p>A list of VPC security groups that the new DB cluster will belong to.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the restored DB cluster.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be assigned to the restored DB cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The Amazon KMS key identifier to use when restoring an encrypted DB cluster from a DB snapshot or DB cluster snapshot.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following will occur:</p>
        /// <ul>
        /// <li> <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB cluster snapshot.</p> </li>
        /// <li> <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is not encrypted, then the restored DB cluster is not encrypted.</p> </li>
        /// </ul>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The Amazon KMS key identifier to use when restoring an encrypted DB cluster from a DB snapshot or DB cluster snapshot.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following will occur:</p>
        /// <ul>
        /// <li> <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB cluster snapshot.</p> </li>
        /// <li> <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is not encrypted, then the restored DB cluster is not encrypted.</p> </li>
        /// </ul>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn enable_iam_database_authentication(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_iam_database_authentication(input);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_iam_database_authentication(input);
            self
        }
        /// Appends an item to `EnableCloudwatchLogsExports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs.</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.enable_cloudwatch_logs_exports(input.into());
            self
        }
        /// <p>The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs.</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_enable_cloudwatch_logs_exports(input);
            self
        }
        /// <p>The name of the DB cluster parameter group to associate with the new DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group to associate with the new DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. </p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.inner = self.inner.deletion_protection(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. </p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
        /// <p> <i>If set to <code>true</code>, tags are copied to any snapshot of the restored DB cluster that is created.</i> </p>
        pub fn copy_tags_to_snapshot(mut self, input: bool) -> Self {
            self.inner = self.inner.copy_tags_to_snapshot(input);
            self
        }
        /// <p> <i>If set to <code>true</code>, tags are copied to any snapshot of the restored DB cluster that is created.</i> </p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags_to_snapshot(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreDBClusterToPointInTime`.
    ///
    /// <p>Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time before <code>LatestRestorableTime</code> for up to <code>BackupRetentionPeriod</code> days. The target DB cluster is created from the source DB cluster with the same configuration as the original DB cluster, except that the new DB cluster is created with the default DB security group.</p> <note>
    /// <p>This action only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the <code>CreateDBInstance</code> action to create DB instances for the restored DB cluster, specifying the identifier of the restored DB cluster in <code>DBClusterIdentifier</code>. You can create DB instances only after the <code>RestoreDBClusterToPointInTime</code> action has completed and the DB cluster is available.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestoreDBClusterToPointInTime {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::restore_db_cluster_to_point_in_time_input::Builder,
    }
    impl RestoreDBClusterToPointInTime {
        /// Creates a new `RestoreDBClusterToPointInTime`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreDbClusterToPointInTimeOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterToPointInTimeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new DB cluster to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The name of the new DB cluster to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The type of restore to be performed. You can specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.</p> </li>
        /// <li> <p> <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.</p> </li>
        /// </ul>
        /// <p>If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the source DB cluster.</p>
        pub fn restore_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.restore_type(input.into());
            self
        }
        /// <p>The type of restore to be performed. You can specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.</p> </li>
        /// <li> <p> <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.</p> </li>
        /// </ul>
        /// <p>If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the source DB cluster.</p>
        pub fn set_restore_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_restore_type(input);
            self
        }
        /// <p>The identifier of the source DB cluster from which to restore.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBCluster.</p> </li>
        /// </ul>
        pub fn source_db_cluster_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_db_cluster_identifier(input.into());
            self
        }
        /// <p>The identifier of the source DB cluster from which to restore.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBCluster.</p> </li>
        /// </ul>
        pub fn set_source_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_db_cluster_identifier(input);
            self
        }
        /// <p>The date and time to restore the DB cluster to.</p>
        /// <p>Valid Values: Value must be a time in Universal Coordinated Time (UTC) format</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be before the latest restorable time for the DB instance</p> </li>
        /// <li> <p>Must be specified if <code>UseLatestRestorableTime</code> parameter is not provided</p> </li>
        /// <li> <p>Cannot be specified if <code>UseLatestRestorableTime</code> parameter is true</p> </li>
        /// <li> <p>Cannot be specified if <code>RestoreType</code> parameter is <code>copy-on-write</code> </p> </li>
        /// </ul>
        /// <p>Example: <code>2015-03-07T23:45:00Z</code> </p>
        pub fn restore_to_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.restore_to_time(input);
            self
        }
        /// <p>The date and time to restore the DB cluster to.</p>
        /// <p>Valid Values: Value must be a time in Universal Coordinated Time (UTC) format</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be before the latest restorable time for the DB instance</p> </li>
        /// <li> <p>Must be specified if <code>UseLatestRestorableTime</code> parameter is not provided</p> </li>
        /// <li> <p>Cannot be specified if <code>UseLatestRestorableTime</code> parameter is true</p> </li>
        /// <li> <p>Cannot be specified if <code>RestoreType</code> parameter is <code>copy-on-write</code> </p> </li>
        /// </ul>
        /// <p>Example: <code>2015-03-07T23:45:00Z</code> </p>
        pub fn set_restore_to_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_restore_to_time(input);
            self
        }
        /// <p>A value that is set to <code>true</code> to restore the DB cluster to the latest restorable backup time, and <code>false</code> otherwise.</p>
        /// <p>Default: <code>false</code> </p>
        /// <p>Constraints: Cannot be specified if <code>RestoreToTime</code> parameter is provided.</p>
        pub fn use_latest_restorable_time(mut self, input: bool) -> Self {
            self.inner = self.inner.use_latest_restorable_time(input);
            self
        }
        /// <p>A value that is set to <code>true</code> to restore the DB cluster to the latest restorable backup time, and <code>false</code> otherwise.</p>
        /// <p>Default: <code>false</code> </p>
        /// <p>Constraints: Cannot be specified if <code>RestoreToTime</code> parameter is provided.</p>
        pub fn set_use_latest_restorable_time(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_use_latest_restorable_time(input);
            self
        }
        /// <p>The port number on which the new DB cluster accepts connections.</p>
        /// <p>Constraints: Value must be <code>1150-65535</code> </p>
        /// <p>Default: The same port as the original DB cluster.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port number on which the new DB cluster accepts connections.</p>
        /// <p>Constraints: Value must be <code>1150-65535</code> </p>
        /// <p>Default: The same port as the original DB cluster.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The DB subnet group name to use for the new DB cluster.</p>
        /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// <p>Example: <code>mySubnetgroup</code> </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(input.into());
            self
        }
        /// <p>The DB subnet group name to use for the new DB cluster.</p>
        /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// <p>Example: <code>mySubnetgroup</code> </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(input.into());
            self
        }
        /// <p> <i>(Not supported by Neptune)</i> </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of VPC security groups that the new DB cluster belongs to.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(input.into());
            self
        }
        /// <p>A list of VPC security groups that the new DB cluster belongs to.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be applied to the restored DB cluster.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be applied to the restored DB cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The Amazon KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
        /// <p>You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different than the KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS key identified by the <code>KmsKeyId</code> parameter.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following will occur:</p>
        /// <ul>
        /// <li> <p>If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the source DB cluster.</p> </li>
        /// <li> <p>If the DB cluster is not encrypted, then the restored DB cluster is not encrypted.</p> </li>
        /// </ul>
        /// <p>If <code>DBClusterIdentifier</code> refers to a DB cluster that is not encrypted, then the restore request is rejected.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The Amazon KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
        /// <p>You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different than the KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS key identified by the <code>KmsKeyId</code> parameter.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following will occur:</p>
        /// <ul>
        /// <li> <p>If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the source DB cluster.</p> </li>
        /// <li> <p>If the DB cluster is not encrypted, then the restored DB cluster is not encrypted.</p> </li>
        /// </ul>
        /// <p>If <code>DBClusterIdentifier</code> refers to a DB cluster that is not encrypted, then the restore request is rejected.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn enable_iam_database_authentication(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_iam_database_authentication(input);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_iam_database_authentication(input);
            self
        }
        /// Appends an item to `EnableCloudwatchLogsExports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>The list of logs that the restored DB cluster is to export to CloudWatch Logs.</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.enable_cloudwatch_logs_exports(input.into());
            self
        }
        /// <p>The list of logs that the restored DB cluster is to export to CloudWatch Logs.</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_enable_cloudwatch_logs_exports(input);
            self
        }
        /// <p>The name of the DB cluster parameter group to associate with the new DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group to associate with the new DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. </p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.inner = self.inner.deletion_protection(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. </p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDBCluster`.
    ///
    /// <p>Starts an Amazon Neptune DB cluster that was stopped using the Amazon console, the Amazon CLI stop-db-cluster command, or the StopDBCluster API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartDBCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_db_cluster_input::Builder,
    }
    impl StartDBCluster {
        /// Creates a new `StartDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDBClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB cluster identifier of the Neptune DB cluster to be started. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The DB cluster identifier of the Neptune DB cluster to be started. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopDBCluster`.
    ///
    /// <p>Stops an Amazon Neptune DB cluster. When you stop a DB cluster, Neptune retains the DB cluster's metadata, including its endpoints and DB parameter groups.</p>
    /// <p>Neptune also retains the transaction logs so you can do a point-in-time restore if necessary.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopDBCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_db_cluster_input::Builder,
    }
    impl StopDBCluster {
        /// Creates a new `StopDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::StopDBClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB cluster identifier of the Neptune DB cluster to be stopped. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The DB cluster identifier of the Neptune DB cluster to be stopped. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
