// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Contains the details of an Amazon Neptune DB cluster.</p>
/// <p>This data type is used as a response element in the <a>DescribeDBClusters</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbCluster {
    /// <p>
    /// <code>AllocatedStorage</code> always returns 1, because Neptune DB cluster storage size is
    /// not fixed, but instead automatically adjusts as needed.</p>
    pub allocated_storage: std::option::Option<i32>,
    /// <p>Provides the list of EC2 Availability Zones that instances in the DB cluster can be
    /// created in.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the number of days for which automatic DB snapshots are retained.</p>
    pub backup_retention_period: std::option::Option<i32>,
    /// <p>Not supported by Neptune.</p>
    pub character_set_name: std::option::Option<std::string::String>,
    /// <p>Contains the name of the initial database of this DB cluster that was provided at create
    /// time, if one was specified when the DB cluster was created. This same name is returned for the
    /// life of the DB cluster.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>Contains a user-supplied DB cluster identifier. This identifier is the unique key that
    /// identifies a DB cluster.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the DB cluster parameter group for the DB cluster.</p>
    pub db_cluster_parameter_group: std::option::Option<std::string::String>,
    /// <p>Specifies information on the subnet group associated with the DB cluster, including the
    /// name, description, and subnets in the subnet group.</p>
    pub db_subnet_group: std::option::Option<std::string::String>,
    /// <p>Specifies the current state of this DB cluster.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Specifies the progress of the operation as a percentage.</p>
    pub percent_progress: std::option::Option<std::string::String>,
    /// <p>Specifies the earliest time to which a database can be restored with point-in-time
    /// restore.</p>
    pub earliest_restorable_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Specifies the connection endpoint for the primary instance of the DB cluster.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances
    /// connections across the Read Replicas that are available in a DB cluster. As clients request
    /// new connections to the reader endpoint, Neptune distributes the connection requests among the
    /// Read Replicas in the DB cluster. This functionality can help balance your read workload across
    /// multiple Read Replicas in your DB cluster.</p>
    /// <p>If a failover occurs, and the Read Replica that you are connected to is promoted to be the
    /// primary instance, your connection is dropped. To continue sending your read workload to other
    /// Read Replicas in the cluster, you can then reconnect to the reader endpoint.</p>
    pub reader_endpoint: std::option::Option<std::string::String>,
    /// <p>Specifies whether the DB cluster has instances in multiple Availability Zones.</p>
    pub multi_az: bool,
    /// <p>Provides the name of the database engine to be used for this DB cluster.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>Indicates the database engine version.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Specifies the latest time to which a database can be restored with point-in-time
    /// restore.</p>
    pub latest_restorable_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Specifies the port that the database engine is listening on.</p>
    pub port: std::option::Option<i32>,
    /// <p>Not supported by Neptune.</p>
    pub master_username: std::option::Option<std::string::String>,
    /// <p>Not supported by Neptune.</p>
    pub db_cluster_option_group_memberships:
        std::option::Option<std::vec::Vec<crate::model::DbClusterOptionGroupStatus>>,
    /// <p>Specifies the daily time range during which automated backups are created if automated
    /// backups are enabled, as determined by the <code>BackupRetentionPeriod</code>.</p>
    pub preferred_backup_window: std::option::Option<std::string::String>,
    /// <p>Specifies the weekly time range during which system maintenance can occur, in Universal
    /// Coordinated Time (UTC).</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>Not supported by Neptune.</p>
    pub replication_source_identifier: std::option::Option<std::string::String>,
    /// <p>Contains one or more identifiers of the Read Replicas associated with this DB
    /// cluster.</p>
    pub read_replica_identifiers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Provides the list of instances that make up the DB cluster.</p>
    pub db_cluster_members: std::option::Option<std::vec::Vec<crate::model::DbClusterMember>>,
    /// <p>Provides a list of VPC security groups that the DB cluster belongs to.</p>
    pub vpc_security_groups:
        std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
    /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the DB cluster is encrypted.</p>
    pub storage_encrypted: bool,
    /// <p>If <code>StorageEncrypted</code> is true, the Amazon KMS key identifier for the
    /// encrypted DB cluster.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Region-unique, immutable identifier for the DB cluster. This identifier is found
    /// in Amazon CloudTrail log entries whenever the Amazon KMS key for the DB cluster is accessed.</p>
    pub db_cluster_resource_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the DB cluster.</p>
    pub db_cluster_arn: std::option::Option<std::string::String>,
    /// <p>Provides a list of the Amazon Identity and Access Management (IAM) roles that are associated
    /// with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the
    /// DB cluster to access other Amazon services on your behalf.</p>
    pub associated_roles: std::option::Option<std::vec::Vec<crate::model::DbClusterRole>>,
    /// <p>True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts
    /// is enabled, and otherwise false.</p>
    pub iam_database_authentication_enabled: bool,
    /// <p>Identifies the clone group to which the DB cluster is associated.</p>
    pub clone_group_id: std::option::Option<std::string::String>,
    /// <p>Specifies the time when the DB cluster was created, in Universal Coordinated Time
    /// (UTC).</p>
    pub cluster_create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// <i>If set to <code>true</code>, tags are copied to any snapshot of
    /// the DB cluster that is created.</i>
    /// </p>
    pub copy_tags_to_snapshot: std::option::Option<bool>,
    /// <p>A list of log types that this DB cluster is configured to export to CloudWatch Logs.</p>
    pub enabled_cloudwatch_logs_exports: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates whether or not the DB cluster has deletion protection enabled.
    /// The database can't be deleted when deletion protection is enabled.</p>
    pub deletion_protection: std::option::Option<bool>,
    /// <p>If set to <code>true</code>, the DB cluster can be cloned across accounts.</p>
    pub cross_account_clone: std::option::Option<bool>,
    /// <p>Time at which the DB cluster will be automatically restarted.</p>
    pub automatic_restart_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for DbCluster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbCluster");
        formatter.field("allocated_storage", &self.allocated_storage);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("backup_retention_period", &self.backup_retention_period);
        formatter.field("character_set_name", &self.character_set_name);
        formatter.field("database_name", &self.database_name);
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field(
            "db_cluster_parameter_group",
            &self.db_cluster_parameter_group,
        );
        formatter.field("db_subnet_group", &self.db_subnet_group);
        formatter.field("status", &self.status);
        formatter.field("percent_progress", &self.percent_progress);
        formatter.field("earliest_restorable_time", &self.earliest_restorable_time);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("reader_endpoint", &self.reader_endpoint);
        formatter.field("multi_az", &self.multi_az);
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("latest_restorable_time", &self.latest_restorable_time);
        formatter.field("port", &self.port);
        formatter.field("master_username", &self.master_username);
        formatter.field(
            "db_cluster_option_group_memberships",
            &self.db_cluster_option_group_memberships,
        );
        formatter.field("preferred_backup_window", &self.preferred_backup_window);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field(
            "replication_source_identifier",
            &self.replication_source_identifier,
        );
        formatter.field("read_replica_identifiers", &self.read_replica_identifiers);
        formatter.field("db_cluster_members", &self.db_cluster_members);
        formatter.field("vpc_security_groups", &self.vpc_security_groups);
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("storage_encrypted", &self.storage_encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("db_cluster_resource_id", &self.db_cluster_resource_id);
        formatter.field("db_cluster_arn", &self.db_cluster_arn);
        formatter.field("associated_roles", &self.associated_roles);
        formatter.field(
            "iam_database_authentication_enabled",
            &self.iam_database_authentication_enabled,
        );
        formatter.field("clone_group_id", &self.clone_group_id);
        formatter.field("cluster_create_time", &self.cluster_create_time);
        formatter.field("copy_tags_to_snapshot", &self.copy_tags_to_snapshot);
        formatter.field(
            "enabled_cloudwatch_logs_exports",
            &self.enabled_cloudwatch_logs_exports,
        );
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.field("cross_account_clone", &self.cross_account_clone);
        formatter.field("automatic_restart_time", &self.automatic_restart_time);
        formatter.finish()
    }
}
/// See [`DbCluster`](crate::model::DbCluster)
pub mod db_cluster {
    /// A builder for [`DbCluster`](crate::model::DbCluster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allocated_storage: std::option::Option<i32>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) backup_retention_period: std::option::Option<i32>,
        pub(crate) character_set_name: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_parameter_group: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) percent_progress: std::option::Option<std::string::String>,
        pub(crate) earliest_restorable_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) reader_endpoint: std::option::Option<std::string::String>,
        pub(crate) multi_az: std::option::Option<bool>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) latest_restorable_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) master_username: std::option::Option<std::string::String>,
        pub(crate) db_cluster_option_group_memberships:
            std::option::Option<std::vec::Vec<crate::model::DbClusterOptionGroupStatus>>,
        pub(crate) preferred_backup_window: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) replication_source_identifier: std::option::Option<std::string::String>,
        pub(crate) read_replica_identifiers:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_cluster_members:
            std::option::Option<std::vec::Vec<crate::model::DbClusterMember>>,
        pub(crate) vpc_security_groups:
            std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) storage_encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) db_cluster_resource_id: std::option::Option<std::string::String>,
        pub(crate) db_cluster_arn: std::option::Option<std::string::String>,
        pub(crate) associated_roles:
            std::option::Option<std::vec::Vec<crate::model::DbClusterRole>>,
        pub(crate) iam_database_authentication_enabled: std::option::Option<bool>,
        pub(crate) clone_group_id: std::option::Option<std::string::String>,
        pub(crate) cluster_create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) copy_tags_to_snapshot: std::option::Option<bool>,
        pub(crate) enabled_cloudwatch_logs_exports:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) deletion_protection: std::option::Option<bool>,
        pub(crate) cross_account_clone: std::option::Option<bool>,
        pub(crate) automatic_restart_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>
        /// <code>AllocatedStorage</code> always returns 1, because Neptune DB cluster storage size is
        /// not fixed, but instead automatically adjusts as needed.</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.allocated_storage = Some(input);
            self
        }
        /// <p>
        /// <code>AllocatedStorage</code> always returns 1, because Neptune DB cluster storage size is
        /// not fixed, but instead automatically adjusts as needed.</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_storage = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>Provides the list of EC2 Availability Zones that instances in the DB cluster can be
        /// created in.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>Provides the list of EC2 Availability Zones that instances in the DB cluster can be
        /// created in.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// <p>Specifies the number of days for which automatic DB snapshots are retained.</p>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.backup_retention_period = Some(input);
            self
        }
        /// <p>Specifies the number of days for which automatic DB snapshots are retained.</p>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.backup_retention_period = input;
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn character_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.character_set_name = Some(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.character_set_name = input;
            self
        }
        /// <p>Contains the name of the initial database of this DB cluster that was provided at create
        /// time, if one was specified when the DB cluster was created. This same name is returned for the
        /// life of the DB cluster.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>Contains the name of the initial database of this DB cluster that was provided at create
        /// time, if one was specified when the DB cluster was created. This same name is returned for the
        /// life of the DB cluster.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>Contains a user-supplied DB cluster identifier. This identifier is the unique key that
        /// identifies a DB cluster.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>Contains a user-supplied DB cluster identifier. This identifier is the unique key that
        /// identifies a DB cluster.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>Specifies the name of the DB cluster parameter group for the DB cluster.</p>
        pub fn db_cluster_parameter_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_parameter_group = Some(input.into());
            self
        }
        /// <p>Specifies the name of the DB cluster parameter group for the DB cluster.</p>
        pub fn set_db_cluster_parameter_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group = input;
            self
        }
        /// <p>Specifies information on the subnet group associated with the DB cluster, including the
        /// name, description, and subnets in the subnet group.</p>
        pub fn db_subnet_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group = Some(input.into());
            self
        }
        /// <p>Specifies information on the subnet group associated with the DB cluster, including the
        /// name, description, and subnets in the subnet group.</p>
        pub fn set_db_subnet_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group = input;
            self
        }
        /// <p>Specifies the current state of this DB cluster.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Specifies the current state of this DB cluster.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Specifies the progress of the operation as a percentage.</p>
        pub fn percent_progress(mut self, input: impl Into<std::string::String>) -> Self {
            self.percent_progress = Some(input.into());
            self
        }
        /// <p>Specifies the progress of the operation as a percentage.</p>
        pub fn set_percent_progress(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.percent_progress = input;
            self
        }
        /// <p>Specifies the earliest time to which a database can be restored with point-in-time
        /// restore.</p>
        pub fn earliest_restorable_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.earliest_restorable_time = Some(input);
            self
        }
        /// <p>Specifies the earliest time to which a database can be restored with point-in-time
        /// restore.</p>
        pub fn set_earliest_restorable_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.earliest_restorable_time = input;
            self
        }
        /// <p>Specifies the connection endpoint for the primary instance of the DB cluster.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>Specifies the connection endpoint for the primary instance of the DB cluster.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances
        /// connections across the Read Replicas that are available in a DB cluster. As clients request
        /// new connections to the reader endpoint, Neptune distributes the connection requests among the
        /// Read Replicas in the DB cluster. This functionality can help balance your read workload across
        /// multiple Read Replicas in your DB cluster.</p>
        /// <p>If a failover occurs, and the Read Replica that you are connected to is promoted to be the
        /// primary instance, your connection is dropped. To continue sending your read workload to other
        /// Read Replicas in the cluster, you can then reconnect to the reader endpoint.</p>
        pub fn reader_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.reader_endpoint = Some(input.into());
            self
        }
        /// <p>The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances
        /// connections across the Read Replicas that are available in a DB cluster. As clients request
        /// new connections to the reader endpoint, Neptune distributes the connection requests among the
        /// Read Replicas in the DB cluster. This functionality can help balance your read workload across
        /// multiple Read Replicas in your DB cluster.</p>
        /// <p>If a failover occurs, and the Read Replica that you are connected to is promoted to be the
        /// primary instance, your connection is dropped. To continue sending your read workload to other
        /// Read Replicas in the cluster, you can then reconnect to the reader endpoint.</p>
        pub fn set_reader_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reader_endpoint = input;
            self
        }
        /// <p>Specifies whether the DB cluster has instances in multiple Availability Zones.</p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.multi_az = Some(input);
            self
        }
        /// <p>Specifies whether the DB cluster has instances in multiple Availability Zones.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az = input;
            self
        }
        /// <p>Provides the name of the database engine to be used for this DB cluster.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>Provides the name of the database engine to be used for this DB cluster.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Specifies the latest time to which a database can be restored with point-in-time
        /// restore.</p>
        pub fn latest_restorable_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.latest_restorable_time = Some(input);
            self
        }
        /// <p>Specifies the latest time to which a database can be restored with point-in-time
        /// restore.</p>
        pub fn set_latest_restorable_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.latest_restorable_time = input;
            self
        }
        /// <p>Specifies the port that the database engine is listening on.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Specifies the port that the database engine is listening on.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_username = Some(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_username = input;
            self
        }
        /// Appends an item to `db_cluster_option_group_memberships`.
        ///
        /// To override the contents of this collection use [`set_db_cluster_option_group_memberships`](Self::set_db_cluster_option_group_memberships).
        ///
        /// <p>Not supported by Neptune.</p>
        pub fn db_cluster_option_group_memberships(
            mut self,
            input: impl Into<crate::model::DbClusterOptionGroupStatus>,
        ) -> Self {
            let mut v = self.db_cluster_option_group_memberships.unwrap_or_default();
            v.push(input.into());
            self.db_cluster_option_group_memberships = Some(v);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_db_cluster_option_group_memberships(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbClusterOptionGroupStatus>>,
        ) -> Self {
            self.db_cluster_option_group_memberships = input;
            self
        }
        /// <p>Specifies the daily time range during which automated backups are created if automated
        /// backups are enabled, as determined by the <code>BackupRetentionPeriod</code>.</p>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_backup_window = Some(input.into());
            self
        }
        /// <p>Specifies the daily time range during which automated backups are created if automated
        /// backups are enabled, as determined by the <code>BackupRetentionPeriod</code>.</p>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_backup_window = input;
            self
        }
        /// <p>Specifies the weekly time range during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn replication_source_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_source_identifier = Some(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_replication_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_source_identifier = input;
            self
        }
        /// Appends an item to `read_replica_identifiers`.
        ///
        /// To override the contents of this collection use [`set_read_replica_identifiers`](Self::set_read_replica_identifiers).
        ///
        /// <p>Contains one or more identifiers of the Read Replicas associated with this DB
        /// cluster.</p>
        pub fn read_replica_identifiers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.read_replica_identifiers.unwrap_or_default();
            v.push(input.into());
            self.read_replica_identifiers = Some(v);
            self
        }
        /// <p>Contains one or more identifiers of the Read Replicas associated with this DB
        /// cluster.</p>
        pub fn set_read_replica_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.read_replica_identifiers = input;
            self
        }
        /// Appends an item to `db_cluster_members`.
        ///
        /// To override the contents of this collection use [`set_db_cluster_members`](Self::set_db_cluster_members).
        ///
        /// <p>Provides the list of instances that make up the DB cluster.</p>
        pub fn db_cluster_members(
            mut self,
            input: impl Into<crate::model::DbClusterMember>,
        ) -> Self {
            let mut v = self.db_cluster_members.unwrap_or_default();
            v.push(input.into());
            self.db_cluster_members = Some(v);
            self
        }
        /// <p>Provides the list of instances that make up the DB cluster.</p>
        pub fn set_db_cluster_members(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbClusterMember>>,
        ) -> Self {
            self.db_cluster_members = input;
            self
        }
        /// Appends an item to `vpc_security_groups`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_groups`](Self::set_vpc_security_groups).
        ///
        /// <p>Provides a list of VPC security groups that the DB cluster belongs to.</p>
        pub fn vpc_security_groups(
            mut self,
            input: impl Into<crate::model::VpcSecurityGroupMembership>,
        ) -> Self {
            let mut v = self.vpc_security_groups.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_groups = Some(v);
            self
        }
        /// <p>Provides a list of VPC security groups that the DB cluster belongs to.</p>
        pub fn set_vpc_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        ) -> Self {
            self.vpc_security_groups = input;
            self
        }
        /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>Specifies whether the DB cluster is encrypted.</p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.storage_encrypted = Some(input);
            self
        }
        /// <p>Specifies whether the DB cluster is encrypted.</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_encrypted = input;
            self
        }
        /// <p>If <code>StorageEncrypted</code> is true, the Amazon KMS key identifier for the
        /// encrypted DB cluster.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>If <code>StorageEncrypted</code> is true, the Amazon KMS key identifier for the
        /// encrypted DB cluster.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The Amazon Region-unique, immutable identifier for the DB cluster. This identifier is found
        /// in Amazon CloudTrail log entries whenever the Amazon KMS key for the DB cluster is accessed.</p>
        pub fn db_cluster_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_resource_id = Some(input.into());
            self
        }
        /// <p>The Amazon Region-unique, immutable identifier for the DB cluster. This identifier is found
        /// in Amazon CloudTrail log entries whenever the Amazon KMS key for the DB cluster is accessed.</p>
        pub fn set_db_cluster_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_resource_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB cluster.</p>
        pub fn db_cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB cluster.</p>
        pub fn set_db_cluster_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_arn = input;
            self
        }
        /// Appends an item to `associated_roles`.
        ///
        /// To override the contents of this collection use [`set_associated_roles`](Self::set_associated_roles).
        ///
        /// <p>Provides a list of the Amazon Identity and Access Management (IAM) roles that are associated
        /// with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the
        /// DB cluster to access other Amazon services on your behalf.</p>
        pub fn associated_roles(mut self, input: impl Into<crate::model::DbClusterRole>) -> Self {
            let mut v = self.associated_roles.unwrap_or_default();
            v.push(input.into());
            self.associated_roles = Some(v);
            self
        }
        /// <p>Provides a list of the Amazon Identity and Access Management (IAM) roles that are associated
        /// with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the
        /// DB cluster to access other Amazon services on your behalf.</p>
        pub fn set_associated_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbClusterRole>>,
        ) -> Self {
            self.associated_roles = input;
            self
        }
        /// <p>True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts
        /// is enabled, and otherwise false.</p>
        pub fn iam_database_authentication_enabled(mut self, input: bool) -> Self {
            self.iam_database_authentication_enabled = Some(input);
            self
        }
        /// <p>True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts
        /// is enabled, and otherwise false.</p>
        pub fn set_iam_database_authentication_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.iam_database_authentication_enabled = input;
            self
        }
        /// <p>Identifies the clone group to which the DB cluster is associated.</p>
        pub fn clone_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.clone_group_id = Some(input.into());
            self
        }
        /// <p>Identifies the clone group to which the DB cluster is associated.</p>
        pub fn set_clone_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.clone_group_id = input;
            self
        }
        /// <p>Specifies the time when the DB cluster was created, in Universal Coordinated Time
        /// (UTC).</p>
        pub fn cluster_create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.cluster_create_time = Some(input);
            self
        }
        /// <p>Specifies the time when the DB cluster was created, in Universal Coordinated Time
        /// (UTC).</p>
        pub fn set_cluster_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.cluster_create_time = input;
            self
        }
        /// <p>
        /// <i>If set to <code>true</code>, tags are copied to any snapshot of
        /// the DB cluster that is created.</i>
        /// </p>
        pub fn copy_tags_to_snapshot(mut self, input: bool) -> Self {
            self.copy_tags_to_snapshot = Some(input);
            self
        }
        /// <p>
        /// <i>If set to <code>true</code>, tags are copied to any snapshot of
        /// the DB cluster that is created.</i>
        /// </p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags_to_snapshot = input;
            self
        }
        /// Appends an item to `enabled_cloudwatch_logs_exports`.
        ///
        /// To override the contents of this collection use [`set_enabled_cloudwatch_logs_exports`](Self::set_enabled_cloudwatch_logs_exports).
        ///
        /// <p>A list of log types that this DB cluster is configured to export to CloudWatch Logs.</p>
        pub fn enabled_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.enabled_cloudwatch_logs_exports.unwrap_or_default();
            v.push(input.into());
            self.enabled_cloudwatch_logs_exports = Some(v);
            self
        }
        /// <p>A list of log types that this DB cluster is configured to export to CloudWatch Logs.</p>
        pub fn set_enabled_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.enabled_cloudwatch_logs_exports = input;
            self
        }
        /// <p>Indicates whether or not the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>Indicates whether or not the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// <p>If set to <code>true</code>, the DB cluster can be cloned across accounts.</p>
        pub fn cross_account_clone(mut self, input: bool) -> Self {
            self.cross_account_clone = Some(input);
            self
        }
        /// <p>If set to <code>true</code>, the DB cluster can be cloned across accounts.</p>
        pub fn set_cross_account_clone(mut self, input: std::option::Option<bool>) -> Self {
            self.cross_account_clone = input;
            self
        }
        /// <p>Time at which the DB cluster will be automatically restarted.</p>
        pub fn automatic_restart_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.automatic_restart_time = Some(input);
            self
        }
        /// <p>Time at which the DB cluster will be automatically restarted.</p>
        pub fn set_automatic_restart_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.automatic_restart_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DbCluster`](crate::model::DbCluster)
        pub fn build(self) -> crate::model::DbCluster {
            crate::model::DbCluster {
                allocated_storage: self.allocated_storage,
                availability_zones: self.availability_zones,
                backup_retention_period: self.backup_retention_period,
                character_set_name: self.character_set_name,
                database_name: self.database_name,
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_parameter_group: self.db_cluster_parameter_group,
                db_subnet_group: self.db_subnet_group,
                status: self.status,
                percent_progress: self.percent_progress,
                earliest_restorable_time: self.earliest_restorable_time,
                endpoint: self.endpoint,
                reader_endpoint: self.reader_endpoint,
                multi_az: self.multi_az.unwrap_or_default(),
                engine: self.engine,
                engine_version: self.engine_version,
                latest_restorable_time: self.latest_restorable_time,
                port: self.port,
                master_username: self.master_username,
                db_cluster_option_group_memberships: self.db_cluster_option_group_memberships,
                preferred_backup_window: self.preferred_backup_window,
                preferred_maintenance_window: self.preferred_maintenance_window,
                replication_source_identifier: self.replication_source_identifier,
                read_replica_identifiers: self.read_replica_identifiers,
                db_cluster_members: self.db_cluster_members,
                vpc_security_groups: self.vpc_security_groups,
                hosted_zone_id: self.hosted_zone_id,
                storage_encrypted: self.storage_encrypted.unwrap_or_default(),
                kms_key_id: self.kms_key_id,
                db_cluster_resource_id: self.db_cluster_resource_id,
                db_cluster_arn: self.db_cluster_arn,
                associated_roles: self.associated_roles,
                iam_database_authentication_enabled: self
                    .iam_database_authentication_enabled
                    .unwrap_or_default(),
                clone_group_id: self.clone_group_id,
                cluster_create_time: self.cluster_create_time,
                copy_tags_to_snapshot: self.copy_tags_to_snapshot,
                enabled_cloudwatch_logs_exports: self.enabled_cloudwatch_logs_exports,
                deletion_protection: self.deletion_protection,
                cross_account_clone: self.cross_account_clone,
                automatic_restart_time: self.automatic_restart_time,
            }
        }
    }
}
impl DbCluster {
    /// Creates a new builder-style object to manufacture [`DbCluster`](crate::model::DbCluster)
    pub fn builder() -> crate::model::db_cluster::Builder {
        crate::model::db_cluster::Builder::default()
    }
}

/// <p>Describes an Amazon Identity and Access Management (IAM) role that is associated with a DB
/// cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterRole {
    /// <p>The Amazon Resource Name (ARN) of the IAM role that is associated with the DB
    /// cluster.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Describes the state of association between the IAM role and the DB cluster. The Status
    /// property returns one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> - the IAM role ARN is associated with the DB cluster and can be
    /// used to access other Amazon services on your behalf.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - the IAM role ARN is being associated with the DB
    /// cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INVALID</code> - the IAM role ARN is associated with the DB cluster, but the DB
    /// cluster is unable to assume the IAM role in order to access other Amazon services on your
    /// behalf.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The name of the feature associated with the Amazon Identity and Access Management (IAM) role.
    /// For the list of supported feature names, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-other-apis.html#DescribeDBEngineVersions">DescribeDBEngineVersions</a>.
    /// </p>
    pub feature_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterRole {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterRole");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("status", &self.status);
        formatter.field("feature_name", &self.feature_name);
        formatter.finish()
    }
}
/// See [`DbClusterRole`](crate::model::DbClusterRole)
pub mod db_cluster_role {
    /// A builder for [`DbClusterRole`](crate::model::DbClusterRole)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) feature_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the IAM role that is associated with the DB
        /// cluster.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that is associated with the DB
        /// cluster.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Describes the state of association between the IAM role and the DB cluster. The Status
        /// property returns one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> - the IAM role ARN is associated with the DB cluster and can be
        /// used to access other Amazon services on your behalf.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - the IAM role ARN is being associated with the DB
        /// cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INVALID</code> - the IAM role ARN is associated with the DB cluster, but the DB
        /// cluster is unable to assume the IAM role in order to access other Amazon services on your
        /// behalf.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Describes the state of association between the IAM role and the DB cluster. The Status
        /// property returns one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> - the IAM role ARN is associated with the DB cluster and can be
        /// used to access other Amazon services on your behalf.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - the IAM role ARN is being associated with the DB
        /// cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INVALID</code> - the IAM role ARN is associated with the DB cluster, but the DB
        /// cluster is unable to assume the IAM role in order to access other Amazon services on your
        /// behalf.</p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The name of the feature associated with the Amazon Identity and Access Management (IAM) role.
        /// For the list of supported feature names, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-other-apis.html#DescribeDBEngineVersions">DescribeDBEngineVersions</a>.
        /// </p>
        pub fn feature_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature_name = Some(input.into());
            self
        }
        /// <p>The name of the feature associated with the Amazon Identity and Access Management (IAM) role.
        /// For the list of supported feature names, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-other-apis.html#DescribeDBEngineVersions">DescribeDBEngineVersions</a>.
        /// </p>
        pub fn set_feature_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feature_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterRole`](crate::model::DbClusterRole)
        pub fn build(self) -> crate::model::DbClusterRole {
            crate::model::DbClusterRole {
                role_arn: self.role_arn,
                status: self.status,
                feature_name: self.feature_name,
            }
        }
    }
}
impl DbClusterRole {
    /// Creates a new builder-style object to manufacture [`DbClusterRole`](crate::model::DbClusterRole)
    pub fn builder() -> crate::model::db_cluster_role::Builder {
        crate::model::db_cluster_role::Builder::default()
    }
}

/// <p>This data type is used as a response element for queries on VPC security group
/// membership.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcSecurityGroupMembership {
    /// <p>The name of the VPC security group.</p>
    pub vpc_security_group_id: std::option::Option<std::string::String>,
    /// <p>The status of the VPC security group.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for VpcSecurityGroupMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcSecurityGroupMembership");
        formatter.field("vpc_security_group_id", &self.vpc_security_group_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
pub mod vpc_security_group_membership {
    /// A builder for [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_security_group_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the VPC security group.</p>
        pub fn vpc_security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_security_group_id = Some(input.into());
            self
        }
        /// <p>The name of the VPC security group.</p>
        pub fn set_vpc_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_security_group_id = input;
            self
        }
        /// <p>The status of the VPC security group.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the VPC security group.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
        pub fn build(self) -> crate::model::VpcSecurityGroupMembership {
            crate::model::VpcSecurityGroupMembership {
                vpc_security_group_id: self.vpc_security_group_id,
                status: self.status,
            }
        }
    }
}
impl VpcSecurityGroupMembership {
    /// Creates a new builder-style object to manufacture [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
    pub fn builder() -> crate::model::vpc_security_group_membership::Builder {
        crate::model::vpc_security_group_membership::Builder::default()
    }
}

/// <p>Contains information about an instance that is part of a DB cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterMember {
    /// <p>Specifies the instance identifier for this member of the DB cluster.</p>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>Value that is <code>true</code> if the cluster member is the primary instance for the DB
    /// cluster and <code>false</code> otherwise.</p>
    pub is_cluster_writer: bool,
    /// <p>Specifies the status of the DB cluster parameter group for this member of the DB
    /// cluster.</p>
    pub db_cluster_parameter_group_status: std::option::Option<std::string::String>,
    /// <p>A value that specifies the order in which a Read Replica is promoted to the primary
    /// instance after a failure of the existing primary instance.</p>
    pub promotion_tier: std::option::Option<i32>,
}
impl std::fmt::Debug for DbClusterMember {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterMember");
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("is_cluster_writer", &self.is_cluster_writer);
        formatter.field(
            "db_cluster_parameter_group_status",
            &self.db_cluster_parameter_group_status,
        );
        formatter.field("promotion_tier", &self.promotion_tier);
        formatter.finish()
    }
}
/// See [`DbClusterMember`](crate::model::DbClusterMember)
pub mod db_cluster_member {
    /// A builder for [`DbClusterMember`](crate::model::DbClusterMember)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) is_cluster_writer: std::option::Option<bool>,
        pub(crate) db_cluster_parameter_group_status: std::option::Option<std::string::String>,
        pub(crate) promotion_tier: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies the instance identifier for this member of the DB cluster.</p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the instance identifier for this member of the DB cluster.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>Value that is <code>true</code> if the cluster member is the primary instance for the DB
        /// cluster and <code>false</code> otherwise.</p>
        pub fn is_cluster_writer(mut self, input: bool) -> Self {
            self.is_cluster_writer = Some(input);
            self
        }
        /// <p>Value that is <code>true</code> if the cluster member is the primary instance for the DB
        /// cluster and <code>false</code> otherwise.</p>
        pub fn set_is_cluster_writer(mut self, input: std::option::Option<bool>) -> Self {
            self.is_cluster_writer = input;
            self
        }
        /// <p>Specifies the status of the DB cluster parameter group for this member of the DB
        /// cluster.</p>
        pub fn db_cluster_parameter_group_status(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_status = Some(input.into());
            self
        }
        /// <p>Specifies the status of the DB cluster parameter group for this member of the DB
        /// cluster.</p>
        pub fn set_db_cluster_parameter_group_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_status = input;
            self
        }
        /// <p>A value that specifies the order in which a Read Replica is promoted to the primary
        /// instance after a failure of the existing primary instance.</p>
        pub fn promotion_tier(mut self, input: i32) -> Self {
            self.promotion_tier = Some(input);
            self
        }
        /// <p>A value that specifies the order in which a Read Replica is promoted to the primary
        /// instance after a failure of the existing primary instance.</p>
        pub fn set_promotion_tier(mut self, input: std::option::Option<i32>) -> Self {
            self.promotion_tier = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterMember`](crate::model::DbClusterMember)
        pub fn build(self) -> crate::model::DbClusterMember {
            crate::model::DbClusterMember {
                db_instance_identifier: self.db_instance_identifier,
                is_cluster_writer: self.is_cluster_writer.unwrap_or_default(),
                db_cluster_parameter_group_status: self.db_cluster_parameter_group_status,
                promotion_tier: self.promotion_tier,
            }
        }
    }
}
impl DbClusterMember {
    /// Creates a new builder-style object to manufacture [`DbClusterMember`](crate::model::DbClusterMember)
    pub fn builder() -> crate::model::db_cluster_member::Builder {
        crate::model::db_cluster_member::Builder::default()
    }
}

/// <p>Not supported by Neptune.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterOptionGroupStatus {
    /// <p>Not supported by Neptune.</p>
    pub db_cluster_option_group_name: std::option::Option<std::string::String>,
    /// <p>Not supported by Neptune.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterOptionGroupStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterOptionGroupStatus");
        formatter.field(
            "db_cluster_option_group_name",
            &self.db_cluster_option_group_name,
        );
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DbClusterOptionGroupStatus`](crate::model::DbClusterOptionGroupStatus)
pub mod db_cluster_option_group_status {
    /// A builder for [`DbClusterOptionGroupStatus`](crate::model::DbClusterOptionGroupStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_option_group_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Not supported by Neptune.</p>
        pub fn db_cluster_option_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_option_group_name = Some(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_db_cluster_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_option_group_name = input;
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterOptionGroupStatus`](crate::model::DbClusterOptionGroupStatus)
        pub fn build(self) -> crate::model::DbClusterOptionGroupStatus {
            crate::model::DbClusterOptionGroupStatus {
                db_cluster_option_group_name: self.db_cluster_option_group_name,
                status: self.status,
            }
        }
    }
}
impl DbClusterOptionGroupStatus {
    /// Creates a new builder-style object to manufacture [`DbClusterOptionGroupStatus`](crate::model::DbClusterOptionGroupStatus)
    pub fn builder() -> crate::model::db_cluster_option_group_status::Builder {
        crate::model::db_cluster_option_group_status::Builder::default()
    }
}

/// <p>Metadata assigned to an Amazon Neptune resource consisting of a key-value pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>A key is the required name of the tag. The string value can be from 1 to 128 Unicode
    /// characters in length and can't be prefixed with <code>aws:</code> or <code>rds:</code>.
    /// The string can only contain the set of Unicode letters, digits, white-space,
    /// '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>A value is the optional value of the tag. The string value can be from 1 to 256 Unicode
    /// characters in length and can't be prefixed with <code>aws:</code> or <code>rds:</code>.
    /// The string can only contain the set of Unicode letters, digits, white-space,
    /// '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A key is the required name of the tag. The string value can be from 1 to 128 Unicode
        /// characters in length and can't be prefixed with <code>aws:</code> or <code>rds:</code>.
        /// The string can only contain the set of Unicode letters, digits, white-space,
        /// '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A key is the required name of the tag. The string value can be from 1 to 128 Unicode
        /// characters in length and can't be prefixed with <code>aws:</code> or <code>rds:</code>.
        /// The string can only contain the set of Unicode letters, digits, white-space,
        /// '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>A value is the optional value of the tag. The string value can be from 1 to 256 Unicode
        /// characters in length and can't be prefixed with <code>aws:</code> or <code>rds:</code>.
        /// The string can only contain the set of Unicode letters, digits, white-space,
        /// '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>A value is the optional value of the tag. The string value can be from 1 to 256 Unicode
        /// characters in length and can't be prefixed with <code>aws:</code> or <code>rds:</code>.
        /// The string can only contain the set of Unicode letters, digits, white-space,
        /// '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Specifies a parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Parameter {
    /// <p>Specifies the name of the parameter.</p>
    pub parameter_name: std::option::Option<std::string::String>,
    /// <p>Specifies the value of the parameter.</p>
    pub parameter_value: std::option::Option<std::string::String>,
    /// <p>Provides a description of the parameter.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Indicates the source of the parameter value.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>Specifies the engine specific parameters type.</p>
    pub apply_type: std::option::Option<std::string::String>,
    /// <p>Specifies the valid data type for the parameter.</p>
    pub data_type: std::option::Option<std::string::String>,
    /// <p>Specifies the valid range of values for the parameter.</p>
    pub allowed_values: std::option::Option<std::string::String>,
    /// <p> Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be
    /// modified. Some parameters have security or operational implications that prevent them from
    /// being changed.</p>
    pub is_modifiable: bool,
    /// <p>The earliest engine version to which the parameter can apply.</p>
    pub minimum_engine_version: std::option::Option<std::string::String>,
    /// <p>Indicates when to apply parameter updates.</p>
    pub apply_method: std::option::Option<crate::model::ApplyMethod>,
}
impl std::fmt::Debug for Parameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Parameter");
        formatter.field("parameter_name", &self.parameter_name);
        formatter.field("parameter_value", &self.parameter_value);
        formatter.field("description", &self.description);
        formatter.field("source", &self.source);
        formatter.field("apply_type", &self.apply_type);
        formatter.field("data_type", &self.data_type);
        formatter.field("allowed_values", &self.allowed_values);
        formatter.field("is_modifiable", &self.is_modifiable);
        formatter.field("minimum_engine_version", &self.minimum_engine_version);
        formatter.field("apply_method", &self.apply_method);
        formatter.finish()
    }
}
/// See [`Parameter`](crate::model::Parameter)
pub mod parameter {
    /// A builder for [`Parameter`](crate::model::Parameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_name: std::option::Option<std::string::String>,
        pub(crate) parameter_value: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) apply_type: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<std::string::String>,
        pub(crate) allowed_values: std::option::Option<std::string::String>,
        pub(crate) is_modifiable: std::option::Option<bool>,
        pub(crate) minimum_engine_version: std::option::Option<std::string::String>,
        pub(crate) apply_method: std::option::Option<crate::model::ApplyMethod>,
    }
    impl Builder {
        /// <p>Specifies the name of the parameter.</p>
        pub fn parameter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the parameter.</p>
        pub fn set_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_name = input;
            self
        }
        /// <p>Specifies the value of the parameter.</p>
        pub fn parameter_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_value = Some(input.into());
            self
        }
        /// <p>Specifies the value of the parameter.</p>
        pub fn set_parameter_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_value = input;
            self
        }
        /// <p>Provides a description of the parameter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Provides a description of the parameter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Indicates the source of the parameter value.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>Indicates the source of the parameter value.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>Specifies the engine specific parameters type.</p>
        pub fn apply_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.apply_type = Some(input.into());
            self
        }
        /// <p>Specifies the engine specific parameters type.</p>
        pub fn set_apply_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.apply_type = input;
            self
        }
        /// <p>Specifies the valid data type for the parameter.</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>Specifies the valid data type for the parameter.</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// <p>Specifies the valid range of values for the parameter.</p>
        pub fn allowed_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_values = Some(input.into());
            self
        }
        /// <p>Specifies the valid range of values for the parameter.</p>
        pub fn set_allowed_values(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_values = input;
            self
        }
        /// <p> Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be
        /// modified. Some parameters have security or operational implications that prevent them from
        /// being changed.</p>
        pub fn is_modifiable(mut self, input: bool) -> Self {
            self.is_modifiable = Some(input);
            self
        }
        /// <p> Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be
        /// modified. Some parameters have security or operational implications that prevent them from
        /// being changed.</p>
        pub fn set_is_modifiable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_modifiable = input;
            self
        }
        /// <p>The earliest engine version to which the parameter can apply.</p>
        pub fn minimum_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minimum_engine_version = Some(input.into());
            self
        }
        /// <p>The earliest engine version to which the parameter can apply.</p>
        pub fn set_minimum_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_engine_version = input;
            self
        }
        /// <p>Indicates when to apply parameter updates.</p>
        pub fn apply_method(mut self, input: crate::model::ApplyMethod) -> Self {
            self.apply_method = Some(input);
            self
        }
        /// <p>Indicates when to apply parameter updates.</p>
        pub fn set_apply_method(
            mut self,
            input: std::option::Option<crate::model::ApplyMethod>,
        ) -> Self {
            self.apply_method = input;
            self
        }
        /// Consumes the builder and constructs a [`Parameter`](crate::model::Parameter)
        pub fn build(self) -> crate::model::Parameter {
            crate::model::Parameter {
                parameter_name: self.parameter_name,
                parameter_value: self.parameter_value,
                description: self.description,
                source: self.source,
                apply_type: self.apply_type,
                data_type: self.data_type,
                allowed_values: self.allowed_values,
                is_modifiable: self.is_modifiable.unwrap_or_default(),
                minimum_engine_version: self.minimum_engine_version,
                apply_method: self.apply_method,
            }
        }
    }
}
impl Parameter {
    /// Creates a new builder-style object to manufacture [`Parameter`](crate::model::Parameter)
    pub fn builder() -> crate::model::parameter::Builder {
        crate::model::parameter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApplyMethod {
    #[allow(missing_docs)] // documentation missing in model
    Immediate,
    #[allow(missing_docs)] // documentation missing in model
    PendingReboot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApplyMethod {
    fn from(s: &str) -> Self {
        match s {
            "immediate" => ApplyMethod::Immediate,
            "pending-reboot" => ApplyMethod::PendingReboot,
            other => ApplyMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApplyMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApplyMethod::from(s))
    }
}
impl ApplyMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApplyMethod::Immediate => "immediate",
            ApplyMethod::PendingReboot => "pending-reboot",
            ApplyMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["immediate", "pending-reboot"]
    }
}
impl AsRef<str> for ApplyMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the results of a successful invocation of the <a>DescribeEventSubscriptions</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventSubscription {
    /// <p>The Amazon customer account associated with the event notification subscription.</p>
    pub customer_aws_id: std::option::Option<std::string::String>,
    /// <p>The event notification subscription Id.</p>
    pub cust_subscription_id: std::option::Option<std::string::String>,
    /// <p>The topic ARN of the event notification subscription.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The status of the event notification subscription.</p>
    /// <p>Constraints:</p>
    /// <p>Can be one of the following: creating | modifying | deleting | active | no-permission |
    /// topic-not-exist</p>
    /// <p>The status "no-permission" indicates that Neptune no longer has permission to post to the
    /// SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the
    /// subscription was created.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The time the event notification subscription was created.</p>
    pub subscription_creation_time: std::option::Option<std::string::String>,
    /// <p>The source type for the event notification subscription.</p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p>A list of source IDs for the event notification subscription.</p>
    pub source_ids_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of event categories for the event notification subscription.</p>
    pub event_categories_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A Boolean value indicating if the subscription is enabled. True indicates the subscription
    /// is enabled.</p>
    pub enabled: bool,
    /// <p>The Amazon Resource Name (ARN) for the event subscription.</p>
    pub event_subscription_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EventSubscription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventSubscription");
        formatter.field("customer_aws_id", &self.customer_aws_id);
        formatter.field("cust_subscription_id", &self.cust_subscription_id);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("status", &self.status);
        formatter.field(
            "subscription_creation_time",
            &self.subscription_creation_time,
        );
        formatter.field("source_type", &self.source_type);
        formatter.field("source_ids_list", &self.source_ids_list);
        formatter.field("event_categories_list", &self.event_categories_list);
        formatter.field("enabled", &self.enabled);
        formatter.field("event_subscription_arn", &self.event_subscription_arn);
        formatter.finish()
    }
}
/// See [`EventSubscription`](crate::model::EventSubscription)
pub mod event_subscription {
    /// A builder for [`EventSubscription`](crate::model::EventSubscription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) customer_aws_id: std::option::Option<std::string::String>,
        pub(crate) cust_subscription_id: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) subscription_creation_time: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) source_ids_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) event_categories_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) event_subscription_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon customer account associated with the event notification subscription.</p>
        pub fn customer_aws_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_aws_id = Some(input.into());
            self
        }
        /// <p>The Amazon customer account associated with the event notification subscription.</p>
        pub fn set_customer_aws_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_aws_id = input;
            self
        }
        /// <p>The event notification subscription Id.</p>
        pub fn cust_subscription_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cust_subscription_id = Some(input.into());
            self
        }
        /// <p>The event notification subscription Id.</p>
        pub fn set_cust_subscription_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cust_subscription_id = input;
            self
        }
        /// <p>The topic ARN of the event notification subscription.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The topic ARN of the event notification subscription.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The status of the event notification subscription.</p>
        /// <p>Constraints:</p>
        /// <p>Can be one of the following: creating | modifying | deleting | active | no-permission |
        /// topic-not-exist</p>
        /// <p>The status "no-permission" indicates that Neptune no longer has permission to post to the
        /// SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the
        /// subscription was created.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the event notification subscription.</p>
        /// <p>Constraints:</p>
        /// <p>Can be one of the following: creating | modifying | deleting | active | no-permission |
        /// topic-not-exist</p>
        /// <p>The status "no-permission" indicates that Neptune no longer has permission to post to the
        /// SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the
        /// subscription was created.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The time the event notification subscription was created.</p>
        pub fn subscription_creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_creation_time = Some(input.into());
            self
        }
        /// <p>The time the event notification subscription was created.</p>
        pub fn set_subscription_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_creation_time = input;
            self
        }
        /// <p>The source type for the event notification subscription.</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The source type for the event notification subscription.</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `source_ids_list`.
        ///
        /// To override the contents of this collection use [`set_source_ids_list`](Self::set_source_ids_list).
        ///
        /// <p>A list of source IDs for the event notification subscription.</p>
        pub fn source_ids_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_ids_list.unwrap_or_default();
            v.push(input.into());
            self.source_ids_list = Some(v);
            self
        }
        /// <p>A list of source IDs for the event notification subscription.</p>
        pub fn set_source_ids_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_ids_list = input;
            self
        }
        /// Appends an item to `event_categories_list`.
        ///
        /// To override the contents of this collection use [`set_event_categories_list`](Self::set_event_categories_list).
        ///
        /// <p>A list of event categories for the event notification subscription.</p>
        pub fn event_categories_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories_list.unwrap_or_default();
            v.push(input.into());
            self.event_categories_list = Some(v);
            self
        }
        /// <p>A list of event categories for the event notification subscription.</p>
        pub fn set_event_categories_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories_list = input;
            self
        }
        /// <p>A Boolean value indicating if the subscription is enabled. True indicates the subscription
        /// is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>A Boolean value indicating if the subscription is enabled. True indicates the subscription
        /// is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the event subscription.</p>
        pub fn event_subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_subscription_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the event subscription.</p>
        pub fn set_event_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_subscription_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`EventSubscription`](crate::model::EventSubscription)
        pub fn build(self) -> crate::model::EventSubscription {
            crate::model::EventSubscription {
                customer_aws_id: self.customer_aws_id,
                cust_subscription_id: self.cust_subscription_id,
                sns_topic_arn: self.sns_topic_arn,
                status: self.status,
                subscription_creation_time: self.subscription_creation_time,
                source_type: self.source_type,
                source_ids_list: self.source_ids_list,
                event_categories_list: self.event_categories_list,
                enabled: self.enabled.unwrap_or_default(),
                event_subscription_arn: self.event_subscription_arn,
            }
        }
    }
}
impl EventSubscription {
    /// Creates a new builder-style object to manufacture [`EventSubscription`](crate::model::EventSubscription)
    pub fn builder() -> crate::model::event_subscription::Builder {
        crate::model::event_subscription::Builder::default()
    }
}

/// <p>Contains the details of an Amazon Neptune DB instance.</p>
/// <p>This data type is used as a response element in the <a>DescribeDBInstances</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbInstance {
    /// <p>Contains a user-supplied database identifier. This identifier is the unique key that
    /// identifies a DB instance.</p>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>Contains the name of the compute and memory capacity class of the DB instance.</p>
    pub db_instance_class: std::option::Option<std::string::String>,
    /// <p>Provides the name of the database engine to be used for this DB instance.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>Specifies the current state of this database.</p>
    pub db_instance_status: std::option::Option<std::string::String>,
    /// <p>Not supported by Neptune.</p>
    pub master_username: std::option::Option<std::string::String>,
    /// <p>The database name.</p>
    pub db_name: std::option::Option<std::string::String>,
    /// <p>Specifies the connection endpoint.</p>
    pub endpoint: std::option::Option<crate::model::Endpoint>,
    /// <p>Not supported by Neptune.</p>
    pub allocated_storage: i32,
    /// <p>Provides the date and time the DB instance was created.</p>
    pub instance_create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> Specifies the daily time range during which automated backups are created if automated
    /// backups are enabled, as determined by the <code>BackupRetentionPeriod</code>.</p>
    pub preferred_backup_window: std::option::Option<std::string::String>,
    /// <p>Specifies the number of days for which automatic DB snapshots are retained.</p>
    pub backup_retention_period: i32,
    /// <p> Provides List of DB security group elements containing only
    /// <code>DBSecurityGroup.Name</code> and <code>DBSecurityGroup.Status</code> subelements.</p>
    pub db_security_groups:
        std::option::Option<std::vec::Vec<crate::model::DbSecurityGroupMembership>>,
    /// <p>Provides a list of VPC security group elements that the DB instance belongs to.</p>
    pub vpc_security_groups:
        std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
    /// <p>Provides the list of DB parameter groups applied to this DB instance.</p>
    pub db_parameter_groups:
        std::option::Option<std::vec::Vec<crate::model::DbParameterGroupStatus>>,
    /// <p>Specifies the name of the Availability Zone the DB instance is located in.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>Specifies information on the subnet group associated with the DB instance, including the
    /// name, description, and subnets in the subnet group.</p>
    pub db_subnet_group: std::option::Option<crate::model::DbSubnetGroup>,
    /// <p>Specifies the weekly time range during which system maintenance can occur, in Universal
    /// Coordinated Time (UTC).</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>Specifies that changes to the DB instance are pending. This element is only included when
    /// changes are pending. Specific changes are identified by subelements.</p>
    pub pending_modified_values: std::option::Option<crate::model::PendingModifiedValues>,
    /// <p>Specifies the latest time to which a database can be restored with point-in-time
    /// restore.</p>
    pub latest_restorable_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Specifies if the DB instance is a Multi-AZ deployment.</p>
    pub multi_az: bool,
    /// <p>Indicates the database engine version.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Indicates that minor version patches are applied automatically.</p>
    pub auto_minor_version_upgrade: bool,
    /// <p>Contains the identifier of the source DB instance if this DB instance is a Read
    /// Replica.</p>
    pub read_replica_source_db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>Contains one or more identifiers of the Read Replicas associated with this DB
    /// instance.</p>
    pub read_replica_db_instance_identifiers:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Contains one or more identifiers of DB clusters that are Read Replicas of this DB
    /// instance.</p>
    pub read_replica_db_cluster_identifiers:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>License model information for this DB instance.</p>
    pub license_model: std::option::Option<std::string::String>,
    /// <p>Specifies the Provisioned IOPS (I/O operations per second) value.</p>
    pub iops: std::option::Option<i32>,
    /// <p>
    /// <i>(Not supported by Neptune)</i>
    /// </p>
    pub option_group_memberships:
        std::option::Option<std::vec::Vec<crate::model::OptionGroupMembership>>,
    /// <p>
    /// <i>(Not supported by Neptune)</i>
    /// </p>
    pub character_set_name: std::option::Option<std::string::String>,
    /// <p>If present, specifies the name of the secondary Availability Zone for a DB instance with
    /// multi-AZ support.</p>
    pub secondary_availability_zone: std::option::Option<std::string::String>,
    /// <p>This flag should no longer be used.</p>
    pub publicly_accessible: bool,
    /// <p>The status of a Read Replica. If the instance is not a Read Replica, this is blank.</p>
    pub status_infos: std::option::Option<std::vec::Vec<crate::model::DbInstanceStatusInfo>>,
    /// <p>Specifies the storage type associated with DB instance.</p>
    pub storage_type: std::option::Option<std::string::String>,
    /// <p>The ARN from the key store with which the instance is associated for TDE
    /// encryption.</p>
    pub tde_credential_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the port that the DB instance listens on. If the DB instance is part of a DB
    /// cluster, this can be a different port than the DB cluster port.</p>
    pub db_instance_port: i32,
    /// <p>If the DB instance is a member of a DB cluster, contains the name of the DB cluster that
    /// the DB instance is a member of.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>Not supported: The encryption for DB instances is managed by the DB cluster.</p>
    pub storage_encrypted: bool,
    /// <p> Not supported: The encryption for DB instances is managed by the DB cluster.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Region-unique, immutable identifier for the DB instance. This identifier is found
    /// in Amazon CloudTrail log entries whenever the Amazon KMS key for the DB instance is accessed.</p>
    pub dbi_resource_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the CA certificate for this DB instance.</p>
    pub ca_certificate_identifier: std::option::Option<std::string::String>,
    /// <p>Not supported</p>
    pub domain_memberships: std::option::Option<std::vec::Vec<crate::model::DomainMembership>>,
    /// <p>Specifies whether tags are copied from the DB instance to snapshots of the DB
    /// instance.</p>
    pub copy_tags_to_snapshot: bool,
    /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected
    /// for the DB instance.</p>
    pub monitoring_interval: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the
    /// Enhanced Monitoring metrics data for the DB instance.</p>
    pub enhanced_monitoring_resource_arn: std::option::Option<std::string::String>,
    /// <p>The ARN for the IAM role that permits Neptune to send Enhanced Monitoring metrics to
    /// Amazon CloudWatch Logs.</p>
    pub monitoring_role_arn: std::option::Option<std::string::String>,
    /// <p>A value that specifies the order in which a Read Replica is promoted to the primary
    /// instance after a failure of the existing primary instance.
    /// </p>
    pub promotion_tier: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) for the DB instance.</p>
    pub db_instance_arn: std::option::Option<std::string::String>,
    /// <p>Not supported.</p>
    pub timezone: std::option::Option<std::string::String>,
    /// <p>True if Amazon Identity and Access Management (IAM) authentication is enabled, and otherwise
    /// false.</p>
    pub iam_database_authentication_enabled: bool,
    /// <p>
    /// <i>(Not supported by Neptune)</i>
    /// </p>
    pub performance_insights_enabled: std::option::Option<bool>,
    /// <p>
    /// <i>(Not supported by Neptune)</i>
    /// </p>
    pub performance_insights_kms_key_id: std::option::Option<std::string::String>,
    /// <p>A list of log types that this DB instance is configured to export to CloudWatch
    /// Logs.</p>
    pub enabled_cloudwatch_logs_exports: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates whether or not the DB instance has deletion protection enabled.
    /// The instance can't be deleted when deletion protection is enabled. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting
    /// a DB Instance</a>.</p>
    pub deletion_protection: std::option::Option<bool>,
}
impl std::fmt::Debug for DbInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbInstance");
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("db_instance_class", &self.db_instance_class);
        formatter.field("engine", &self.engine);
        formatter.field("db_instance_status", &self.db_instance_status);
        formatter.field("master_username", &self.master_username);
        formatter.field("db_name", &self.db_name);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("allocated_storage", &self.allocated_storage);
        formatter.field("instance_create_time", &self.instance_create_time);
        formatter.field("preferred_backup_window", &self.preferred_backup_window);
        formatter.field("backup_retention_period", &self.backup_retention_period);
        formatter.field("db_security_groups", &self.db_security_groups);
        formatter.field("vpc_security_groups", &self.vpc_security_groups);
        formatter.field("db_parameter_groups", &self.db_parameter_groups);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("db_subnet_group", &self.db_subnet_group);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field("pending_modified_values", &self.pending_modified_values);
        formatter.field("latest_restorable_time", &self.latest_restorable_time);
        formatter.field("multi_az", &self.multi_az);
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.field(
            "read_replica_source_db_instance_identifier",
            &self.read_replica_source_db_instance_identifier,
        );
        formatter.field(
            "read_replica_db_instance_identifiers",
            &self.read_replica_db_instance_identifiers,
        );
        formatter.field(
            "read_replica_db_cluster_identifiers",
            &self.read_replica_db_cluster_identifiers,
        );
        formatter.field("license_model", &self.license_model);
        formatter.field("iops", &self.iops);
        formatter.field("option_group_memberships", &self.option_group_memberships);
        formatter.field("character_set_name", &self.character_set_name);
        formatter.field(
            "secondary_availability_zone",
            &self.secondary_availability_zone,
        );
        formatter.field("publicly_accessible", &self.publicly_accessible);
        formatter.field("status_infos", &self.status_infos);
        formatter.field("storage_type", &self.storage_type);
        formatter.field("tde_credential_arn", &self.tde_credential_arn);
        formatter.field("db_instance_port", &self.db_instance_port);
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("storage_encrypted", &self.storage_encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("dbi_resource_id", &self.dbi_resource_id);
        formatter.field("ca_certificate_identifier", &self.ca_certificate_identifier);
        formatter.field("domain_memberships", &self.domain_memberships);
        formatter.field("copy_tags_to_snapshot", &self.copy_tags_to_snapshot);
        formatter.field("monitoring_interval", &self.monitoring_interval);
        formatter.field(
            "enhanced_monitoring_resource_arn",
            &self.enhanced_monitoring_resource_arn,
        );
        formatter.field("monitoring_role_arn", &self.monitoring_role_arn);
        formatter.field("promotion_tier", &self.promotion_tier);
        formatter.field("db_instance_arn", &self.db_instance_arn);
        formatter.field("timezone", &self.timezone);
        formatter.field(
            "iam_database_authentication_enabled",
            &self.iam_database_authentication_enabled,
        );
        formatter.field(
            "performance_insights_enabled",
            &self.performance_insights_enabled,
        );
        formatter.field(
            "performance_insights_kms_key_id",
            &self.performance_insights_kms_key_id,
        );
        formatter.field(
            "enabled_cloudwatch_logs_exports",
            &self.enabled_cloudwatch_logs_exports,
        );
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.finish()
    }
}
/// See [`DbInstance`](crate::model::DbInstance)
pub mod db_instance {
    /// A builder for [`DbInstance`](crate::model::DbInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) db_instance_class: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) db_instance_status: std::option::Option<std::string::String>,
        pub(crate) master_username: std::option::Option<std::string::String>,
        pub(crate) db_name: std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<crate::model::Endpoint>,
        pub(crate) allocated_storage: std::option::Option<i32>,
        pub(crate) instance_create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) preferred_backup_window: std::option::Option<std::string::String>,
        pub(crate) backup_retention_period: std::option::Option<i32>,
        pub(crate) db_security_groups:
            std::option::Option<std::vec::Vec<crate::model::DbSecurityGroupMembership>>,
        pub(crate) vpc_security_groups:
            std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        pub(crate) db_parameter_groups:
            std::option::Option<std::vec::Vec<crate::model::DbParameterGroupStatus>>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group: std::option::Option<crate::model::DbSubnetGroup>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) pending_modified_values:
            std::option::Option<crate::model::PendingModifiedValues>,
        pub(crate) latest_restorable_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) multi_az: std::option::Option<bool>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) read_replica_source_db_instance_identifier:
            std::option::Option<std::string::String>,
        pub(crate) read_replica_db_instance_identifiers:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) read_replica_db_cluster_identifiers:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) license_model: std::option::Option<std::string::String>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) option_group_memberships:
            std::option::Option<std::vec::Vec<crate::model::OptionGroupMembership>>,
        pub(crate) character_set_name: std::option::Option<std::string::String>,
        pub(crate) secondary_availability_zone: std::option::Option<std::string::String>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) status_infos:
            std::option::Option<std::vec::Vec<crate::model::DbInstanceStatusInfo>>,
        pub(crate) storage_type: std::option::Option<std::string::String>,
        pub(crate) tde_credential_arn: std::option::Option<std::string::String>,
        pub(crate) db_instance_port: std::option::Option<i32>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) storage_encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) dbi_resource_id: std::option::Option<std::string::String>,
        pub(crate) ca_certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) domain_memberships:
            std::option::Option<std::vec::Vec<crate::model::DomainMembership>>,
        pub(crate) copy_tags_to_snapshot: std::option::Option<bool>,
        pub(crate) monitoring_interval: std::option::Option<i32>,
        pub(crate) enhanced_monitoring_resource_arn: std::option::Option<std::string::String>,
        pub(crate) monitoring_role_arn: std::option::Option<std::string::String>,
        pub(crate) promotion_tier: std::option::Option<i32>,
        pub(crate) db_instance_arn: std::option::Option<std::string::String>,
        pub(crate) timezone: std::option::Option<std::string::String>,
        pub(crate) iam_database_authentication_enabled: std::option::Option<bool>,
        pub(crate) performance_insights_enabled: std::option::Option<bool>,
        pub(crate) performance_insights_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) enabled_cloudwatch_logs_exports:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) deletion_protection: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Contains a user-supplied database identifier. This identifier is the unique key that
        /// identifies a DB instance.</p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>Contains a user-supplied database identifier. This identifier is the unique key that
        /// identifies a DB instance.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>Contains the name of the compute and memory capacity class of the DB instance.</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_class = Some(input.into());
            self
        }
        /// <p>Contains the name of the compute and memory capacity class of the DB instance.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_class = input;
            self
        }
        /// <p>Provides the name of the database engine to be used for this DB instance.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>Provides the name of the database engine to be used for this DB instance.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>Specifies the current state of this database.</p>
        pub fn db_instance_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_status = Some(input.into());
            self
        }
        /// <p>Specifies the current state of this database.</p>
        pub fn set_db_instance_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_status = input;
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_username = Some(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_username = input;
            self
        }
        /// <p>The database name.</p>
        pub fn db_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_name = Some(input.into());
            self
        }
        /// <p>The database name.</p>
        pub fn set_db_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_name = input;
            self
        }
        /// <p>Specifies the connection endpoint.</p>
        pub fn endpoint(mut self, input: crate::model::Endpoint) -> Self {
            self.endpoint = Some(input);
            self
        }
        /// <p>Specifies the connection endpoint.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<crate::model::Endpoint>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.allocated_storage = Some(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_storage = input;
            self
        }
        /// <p>Provides the date and time the DB instance was created.</p>
        pub fn instance_create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.instance_create_time = Some(input);
            self
        }
        /// <p>Provides the date and time the DB instance was created.</p>
        pub fn set_instance_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.instance_create_time = input;
            self
        }
        /// <p> Specifies the daily time range during which automated backups are created if automated
        /// backups are enabled, as determined by the <code>BackupRetentionPeriod</code>.</p>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_backup_window = Some(input.into());
            self
        }
        /// <p> Specifies the daily time range during which automated backups are created if automated
        /// backups are enabled, as determined by the <code>BackupRetentionPeriod</code>.</p>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_backup_window = input;
            self
        }
        /// <p>Specifies the number of days for which automatic DB snapshots are retained.</p>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.backup_retention_period = Some(input);
            self
        }
        /// <p>Specifies the number of days for which automatic DB snapshots are retained.</p>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.backup_retention_period = input;
            self
        }
        /// Appends an item to `db_security_groups`.
        ///
        /// To override the contents of this collection use [`set_db_security_groups`](Self::set_db_security_groups).
        ///
        /// <p> Provides List of DB security group elements containing only
        /// <code>DBSecurityGroup.Name</code> and <code>DBSecurityGroup.Status</code> subelements.</p>
        pub fn db_security_groups(
            mut self,
            input: impl Into<crate::model::DbSecurityGroupMembership>,
        ) -> Self {
            let mut v = self.db_security_groups.unwrap_or_default();
            v.push(input.into());
            self.db_security_groups = Some(v);
            self
        }
        /// <p> Provides List of DB security group elements containing only
        /// <code>DBSecurityGroup.Name</code> and <code>DBSecurityGroup.Status</code> subelements.</p>
        pub fn set_db_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbSecurityGroupMembership>>,
        ) -> Self {
            self.db_security_groups = input;
            self
        }
        /// Appends an item to `vpc_security_groups`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_groups`](Self::set_vpc_security_groups).
        ///
        /// <p>Provides a list of VPC security group elements that the DB instance belongs to.</p>
        pub fn vpc_security_groups(
            mut self,
            input: impl Into<crate::model::VpcSecurityGroupMembership>,
        ) -> Self {
            let mut v = self.vpc_security_groups.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_groups = Some(v);
            self
        }
        /// <p>Provides a list of VPC security group elements that the DB instance belongs to.</p>
        pub fn set_vpc_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        ) -> Self {
            self.vpc_security_groups = input;
            self
        }
        /// Appends an item to `db_parameter_groups`.
        ///
        /// To override the contents of this collection use [`set_db_parameter_groups`](Self::set_db_parameter_groups).
        ///
        /// <p>Provides the list of DB parameter groups applied to this DB instance.</p>
        pub fn db_parameter_groups(
            mut self,
            input: impl Into<crate::model::DbParameterGroupStatus>,
        ) -> Self {
            let mut v = self.db_parameter_groups.unwrap_or_default();
            v.push(input.into());
            self.db_parameter_groups = Some(v);
            self
        }
        /// <p>Provides the list of DB parameter groups applied to this DB instance.</p>
        pub fn set_db_parameter_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbParameterGroupStatus>>,
        ) -> Self {
            self.db_parameter_groups = input;
            self
        }
        /// <p>Specifies the name of the Availability Zone the DB instance is located in.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>Specifies the name of the Availability Zone the DB instance is located in.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>Specifies information on the subnet group associated with the DB instance, including the
        /// name, description, and subnets in the subnet group.</p>
        pub fn db_subnet_group(mut self, input: crate::model::DbSubnetGroup) -> Self {
            self.db_subnet_group = Some(input);
            self
        }
        /// <p>Specifies information on the subnet group associated with the DB instance, including the
        /// name, description, and subnets in the subnet group.</p>
        pub fn set_db_subnet_group(
            mut self,
            input: std::option::Option<crate::model::DbSubnetGroup>,
        ) -> Self {
            self.db_subnet_group = input;
            self
        }
        /// <p>Specifies the weekly time range during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>Specifies that changes to the DB instance are pending. This element is only included when
        /// changes are pending. Specific changes are identified by subelements.</p>
        pub fn pending_modified_values(
            mut self,
            input: crate::model::PendingModifiedValues,
        ) -> Self {
            self.pending_modified_values = Some(input);
            self
        }
        /// <p>Specifies that changes to the DB instance are pending. This element is only included when
        /// changes are pending. Specific changes are identified by subelements.</p>
        pub fn set_pending_modified_values(
            mut self,
            input: std::option::Option<crate::model::PendingModifiedValues>,
        ) -> Self {
            self.pending_modified_values = input;
            self
        }
        /// <p>Specifies the latest time to which a database can be restored with point-in-time
        /// restore.</p>
        pub fn latest_restorable_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.latest_restorable_time = Some(input);
            self
        }
        /// <p>Specifies the latest time to which a database can be restored with point-in-time
        /// restore.</p>
        pub fn set_latest_restorable_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.latest_restorable_time = input;
            self
        }
        /// <p>Specifies if the DB instance is a Multi-AZ deployment.</p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.multi_az = Some(input);
            self
        }
        /// <p>Specifies if the DB instance is a Multi-AZ deployment.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az = input;
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Indicates that minor version patches are applied automatically.</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>Indicates that minor version patches are applied automatically.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>Contains the identifier of the source DB instance if this DB instance is a Read
        /// Replica.</p>
        pub fn read_replica_source_db_instance_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.read_replica_source_db_instance_identifier = Some(input.into());
            self
        }
        /// <p>Contains the identifier of the source DB instance if this DB instance is a Read
        /// Replica.</p>
        pub fn set_read_replica_source_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.read_replica_source_db_instance_identifier = input;
            self
        }
        /// Appends an item to `read_replica_db_instance_identifiers`.
        ///
        /// To override the contents of this collection use [`set_read_replica_db_instance_identifiers`](Self::set_read_replica_db_instance_identifiers).
        ///
        /// <p>Contains one or more identifiers of the Read Replicas associated with this DB
        /// instance.</p>
        pub fn read_replica_db_instance_identifiers(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .read_replica_db_instance_identifiers
                .unwrap_or_default();
            v.push(input.into());
            self.read_replica_db_instance_identifiers = Some(v);
            self
        }
        /// <p>Contains one or more identifiers of the Read Replicas associated with this DB
        /// instance.</p>
        pub fn set_read_replica_db_instance_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.read_replica_db_instance_identifiers = input;
            self
        }
        /// Appends an item to `read_replica_db_cluster_identifiers`.
        ///
        /// To override the contents of this collection use [`set_read_replica_db_cluster_identifiers`](Self::set_read_replica_db_cluster_identifiers).
        ///
        /// <p>Contains one or more identifiers of DB clusters that are Read Replicas of this DB
        /// instance.</p>
        pub fn read_replica_db_cluster_identifiers(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.read_replica_db_cluster_identifiers.unwrap_or_default();
            v.push(input.into());
            self.read_replica_db_cluster_identifiers = Some(v);
            self
        }
        /// <p>Contains one or more identifiers of DB clusters that are Read Replicas of this DB
        /// instance.</p>
        pub fn set_read_replica_db_cluster_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.read_replica_db_cluster_identifiers = input;
            self
        }
        /// <p>License model information for this DB instance.</p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_model = Some(input.into());
            self
        }
        /// <p>License model information for this DB instance.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_model = input;
            self
        }
        /// <p>Specifies the Provisioned IOPS (I/O operations per second) value.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>Specifies the Provisioned IOPS (I/O operations per second) value.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// Appends an item to `option_group_memberships`.
        ///
        /// To override the contents of this collection use [`set_option_group_memberships`](Self::set_option_group_memberships).
        ///
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn option_group_memberships(
            mut self,
            input: impl Into<crate::model::OptionGroupMembership>,
        ) -> Self {
            let mut v = self.option_group_memberships.unwrap_or_default();
            v.push(input.into());
            self.option_group_memberships = Some(v);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_option_group_memberships(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionGroupMembership>>,
        ) -> Self {
            self.option_group_memberships = input;
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn character_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.character_set_name = Some(input.into());
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.character_set_name = input;
            self
        }
        /// <p>If present, specifies the name of the secondary Availability Zone for a DB instance with
        /// multi-AZ support.</p>
        pub fn secondary_availability_zone(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secondary_availability_zone = Some(input.into());
            self
        }
        /// <p>If present, specifies the name of the secondary Availability Zone for a DB instance with
        /// multi-AZ support.</p>
        pub fn set_secondary_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secondary_availability_zone = input;
            self
        }
        /// <p>This flag should no longer be used.</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p>This flag should no longer be used.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// Appends an item to `status_infos`.
        ///
        /// To override the contents of this collection use [`set_status_infos`](Self::set_status_infos).
        ///
        /// <p>The status of a Read Replica. If the instance is not a Read Replica, this is blank.</p>
        pub fn status_infos(
            mut self,
            input: impl Into<crate::model::DbInstanceStatusInfo>,
        ) -> Self {
            let mut v = self.status_infos.unwrap_or_default();
            v.push(input.into());
            self.status_infos = Some(v);
            self
        }
        /// <p>The status of a Read Replica. If the instance is not a Read Replica, this is blank.</p>
        pub fn set_status_infos(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbInstanceStatusInfo>>,
        ) -> Self {
            self.status_infos = input;
            self
        }
        /// <p>Specifies the storage type associated with DB instance.</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type = Some(input.into());
            self
        }
        /// <p>Specifies the storage type associated with DB instance.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>The ARN from the key store with which the instance is associated for TDE
        /// encryption.</p>
        pub fn tde_credential_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tde_credential_arn = Some(input.into());
            self
        }
        /// <p>The ARN from the key store with which the instance is associated for TDE
        /// encryption.</p>
        pub fn set_tde_credential_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tde_credential_arn = input;
            self
        }
        /// <p>Specifies the port that the DB instance listens on. If the DB instance is part of a DB
        /// cluster, this can be a different port than the DB cluster port.</p>
        pub fn db_instance_port(mut self, input: i32) -> Self {
            self.db_instance_port = Some(input);
            self
        }
        /// <p>Specifies the port that the DB instance listens on. If the DB instance is part of a DB
        /// cluster, this can be a different port than the DB cluster port.</p>
        pub fn set_db_instance_port(mut self, input: std::option::Option<i32>) -> Self {
            self.db_instance_port = input;
            self
        }
        /// <p>If the DB instance is a member of a DB cluster, contains the name of the DB cluster that
        /// the DB instance is a member of.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>If the DB instance is a member of a DB cluster, contains the name of the DB cluster that
        /// the DB instance is a member of.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>Not supported: The encryption for DB instances is managed by the DB cluster.</p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.storage_encrypted = Some(input);
            self
        }
        /// <p>Not supported: The encryption for DB instances is managed by the DB cluster.</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_encrypted = input;
            self
        }
        /// <p> Not supported: The encryption for DB instances is managed by the DB cluster.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p> Not supported: The encryption for DB instances is managed by the DB cluster.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The Amazon Region-unique, immutable identifier for the DB instance. This identifier is found
        /// in Amazon CloudTrail log entries whenever the Amazon KMS key for the DB instance is accessed.</p>
        pub fn dbi_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dbi_resource_id = Some(input.into());
            self
        }
        /// <p>The Amazon Region-unique, immutable identifier for the DB instance. This identifier is found
        /// in Amazon CloudTrail log entries whenever the Amazon KMS key for the DB instance is accessed.</p>
        pub fn set_dbi_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dbi_resource_id = input;
            self
        }
        /// <p>The identifier of the CA certificate for this DB instance.</p>
        pub fn ca_certificate_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.ca_certificate_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the CA certificate for this DB instance.</p>
        pub fn set_ca_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ca_certificate_identifier = input;
            self
        }
        /// Appends an item to `domain_memberships`.
        ///
        /// To override the contents of this collection use [`set_domain_memberships`](Self::set_domain_memberships).
        ///
        /// <p>Not supported</p>
        pub fn domain_memberships(
            mut self,
            input: impl Into<crate::model::DomainMembership>,
        ) -> Self {
            let mut v = self.domain_memberships.unwrap_or_default();
            v.push(input.into());
            self.domain_memberships = Some(v);
            self
        }
        /// <p>Not supported</p>
        pub fn set_domain_memberships(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainMembership>>,
        ) -> Self {
            self.domain_memberships = input;
            self
        }
        /// <p>Specifies whether tags are copied from the DB instance to snapshots of the DB
        /// instance.</p>
        pub fn copy_tags_to_snapshot(mut self, input: bool) -> Self {
            self.copy_tags_to_snapshot = Some(input);
            self
        }
        /// <p>Specifies whether tags are copied from the DB instance to snapshots of the DB
        /// instance.</p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags_to_snapshot = input;
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected
        /// for the DB instance.</p>
        pub fn monitoring_interval(mut self, input: i32) -> Self {
            self.monitoring_interval = Some(input);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected
        /// for the DB instance.</p>
        pub fn set_monitoring_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.monitoring_interval = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the
        /// Enhanced Monitoring metrics data for the DB instance.</p>
        pub fn enhanced_monitoring_resource_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.enhanced_monitoring_resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the
        /// Enhanced Monitoring metrics data for the DB instance.</p>
        pub fn set_enhanced_monitoring_resource_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.enhanced_monitoring_resource_arn = input;
            self
        }
        /// <p>The ARN for the IAM role that permits Neptune to send Enhanced Monitoring metrics to
        /// Amazon CloudWatch Logs.</p>
        pub fn monitoring_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitoring_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the IAM role that permits Neptune to send Enhanced Monitoring metrics to
        /// Amazon CloudWatch Logs.</p>
        pub fn set_monitoring_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitoring_role_arn = input;
            self
        }
        /// <p>A value that specifies the order in which a Read Replica is promoted to the primary
        /// instance after a failure of the existing primary instance.
        /// </p>
        pub fn promotion_tier(mut self, input: i32) -> Self {
            self.promotion_tier = Some(input);
            self
        }
        /// <p>A value that specifies the order in which a Read Replica is promoted to the primary
        /// instance after a failure of the existing primary instance.
        /// </p>
        pub fn set_promotion_tier(mut self, input: std::option::Option<i32>) -> Self {
            self.promotion_tier = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB instance.</p>
        pub fn db_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB instance.</p>
        pub fn set_db_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_arn = input;
            self
        }
        /// <p>Not supported.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>Not supported.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// <p>True if Amazon Identity and Access Management (IAM) authentication is enabled, and otherwise
        /// false.</p>
        pub fn iam_database_authentication_enabled(mut self, input: bool) -> Self {
            self.iam_database_authentication_enabled = Some(input);
            self
        }
        /// <p>True if Amazon Identity and Access Management (IAM) authentication is enabled, and otherwise
        /// false.</p>
        pub fn set_iam_database_authentication_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.iam_database_authentication_enabled = input;
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn performance_insights_enabled(mut self, input: bool) -> Self {
            self.performance_insights_enabled = Some(input);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_performance_insights_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.performance_insights_enabled = input;
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn performance_insights_kms_key_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.performance_insights_kms_key_id = Some(input.into());
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_performance_insights_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.performance_insights_kms_key_id = input;
            self
        }
        /// Appends an item to `enabled_cloudwatch_logs_exports`.
        ///
        /// To override the contents of this collection use [`set_enabled_cloudwatch_logs_exports`](Self::set_enabled_cloudwatch_logs_exports).
        ///
        /// <p>A list of log types that this DB instance is configured to export to CloudWatch
        /// Logs.</p>
        pub fn enabled_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.enabled_cloudwatch_logs_exports.unwrap_or_default();
            v.push(input.into());
            self.enabled_cloudwatch_logs_exports = Some(v);
            self
        }
        /// <p>A list of log types that this DB instance is configured to export to CloudWatch
        /// Logs.</p>
        pub fn set_enabled_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.enabled_cloudwatch_logs_exports = input;
            self
        }
        /// <p>Indicates whether or not the DB instance has deletion protection enabled.
        /// The instance can't be deleted when deletion protection is enabled. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting
        /// a DB Instance</a>.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>Indicates whether or not the DB instance has deletion protection enabled.
        /// The instance can't be deleted when deletion protection is enabled. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting
        /// a DB Instance</a>.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// Consumes the builder and constructs a [`DbInstance`](crate::model::DbInstance)
        pub fn build(self) -> crate::model::DbInstance {
            crate::model::DbInstance {
                db_instance_identifier: self.db_instance_identifier,
                db_instance_class: self.db_instance_class,
                engine: self.engine,
                db_instance_status: self.db_instance_status,
                master_username: self.master_username,
                db_name: self.db_name,
                endpoint: self.endpoint,
                allocated_storage: self.allocated_storage.unwrap_or_default(),
                instance_create_time: self.instance_create_time,
                preferred_backup_window: self.preferred_backup_window,
                backup_retention_period: self.backup_retention_period.unwrap_or_default(),
                db_security_groups: self.db_security_groups,
                vpc_security_groups: self.vpc_security_groups,
                db_parameter_groups: self.db_parameter_groups,
                availability_zone: self.availability_zone,
                db_subnet_group: self.db_subnet_group,
                preferred_maintenance_window: self.preferred_maintenance_window,
                pending_modified_values: self.pending_modified_values,
                latest_restorable_time: self.latest_restorable_time,
                multi_az: self.multi_az.unwrap_or_default(),
                engine_version: self.engine_version,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade.unwrap_or_default(),
                read_replica_source_db_instance_identifier: self
                    .read_replica_source_db_instance_identifier,
                read_replica_db_instance_identifiers: self.read_replica_db_instance_identifiers,
                read_replica_db_cluster_identifiers: self.read_replica_db_cluster_identifiers,
                license_model: self.license_model,
                iops: self.iops,
                option_group_memberships: self.option_group_memberships,
                character_set_name: self.character_set_name,
                secondary_availability_zone: self.secondary_availability_zone,
                publicly_accessible: self.publicly_accessible.unwrap_or_default(),
                status_infos: self.status_infos,
                storage_type: self.storage_type,
                tde_credential_arn: self.tde_credential_arn,
                db_instance_port: self.db_instance_port.unwrap_or_default(),
                db_cluster_identifier: self.db_cluster_identifier,
                storage_encrypted: self.storage_encrypted.unwrap_or_default(),
                kms_key_id: self.kms_key_id,
                dbi_resource_id: self.dbi_resource_id,
                ca_certificate_identifier: self.ca_certificate_identifier,
                domain_memberships: self.domain_memberships,
                copy_tags_to_snapshot: self.copy_tags_to_snapshot.unwrap_or_default(),
                monitoring_interval: self.monitoring_interval,
                enhanced_monitoring_resource_arn: self.enhanced_monitoring_resource_arn,
                monitoring_role_arn: self.monitoring_role_arn,
                promotion_tier: self.promotion_tier,
                db_instance_arn: self.db_instance_arn,
                timezone: self.timezone,
                iam_database_authentication_enabled: self
                    .iam_database_authentication_enabled
                    .unwrap_or_default(),
                performance_insights_enabled: self.performance_insights_enabled,
                performance_insights_kms_key_id: self.performance_insights_kms_key_id,
                enabled_cloudwatch_logs_exports: self.enabled_cloudwatch_logs_exports,
                deletion_protection: self.deletion_protection,
            }
        }
    }
}
impl DbInstance {
    /// Creates a new builder-style object to manufacture [`DbInstance`](crate::model::DbInstance)
    pub fn builder() -> crate::model::db_instance::Builder {
        crate::model::db_instance::Builder::default()
    }
}

/// <p>An Active Directory Domain membership record associated with a DB instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainMembership {
    /// <p>The identifier of the Active Directory Domain.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The status of the DB instance's Active Directory Domain membership, such as joined,
    /// pending-join, failed etc).</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The fully qualified domain name of the Active Directory Domain.</p>
    pub fqdn: std::option::Option<std::string::String>,
    /// <p>The name of the IAM role to be used when making API calls to the Directory Service.</p>
    pub iam_role_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DomainMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainMembership");
        formatter.field("domain", &self.domain);
        formatter.field("status", &self.status);
        formatter.field("fqdn", &self.fqdn);
        formatter.field("iam_role_name", &self.iam_role_name);
        formatter.finish()
    }
}
/// See [`DomainMembership`](crate::model::DomainMembership)
pub mod domain_membership {
    /// A builder for [`DomainMembership`](crate::model::DomainMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) fqdn: std::option::Option<std::string::String>,
        pub(crate) iam_role_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Active Directory Domain.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The identifier of the Active Directory Domain.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The status of the DB instance's Active Directory Domain membership, such as joined,
        /// pending-join, failed etc).</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the DB instance's Active Directory Domain membership, such as joined,
        /// pending-join, failed etc).</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The fully qualified domain name of the Active Directory Domain.</p>
        pub fn fqdn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fqdn = Some(input.into());
            self
        }
        /// <p>The fully qualified domain name of the Active Directory Domain.</p>
        pub fn set_fqdn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fqdn = input;
            self
        }
        /// <p>The name of the IAM role to be used when making API calls to the Directory Service.</p>
        pub fn iam_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM role to be used when making API calls to the Directory Service.</p>
        pub fn set_iam_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iam_role_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainMembership`](crate::model::DomainMembership)
        pub fn build(self) -> crate::model::DomainMembership {
            crate::model::DomainMembership {
                domain: self.domain,
                status: self.status,
                fqdn: self.fqdn,
                iam_role_name: self.iam_role_name,
            }
        }
    }
}
impl DomainMembership {
    /// Creates a new builder-style object to manufacture [`DomainMembership`](crate::model::DomainMembership)
    pub fn builder() -> crate::model::domain_membership::Builder {
        crate::model::domain_membership::Builder::default()
    }
}

/// <p>Provides a list of status information for a DB instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbInstanceStatusInfo {
    /// <p>This value is currently "read replication."</p>
    pub status_type: std::option::Option<std::string::String>,
    /// <p>Boolean value that is true if the instance is operating normally, or false if the instance
    /// is in an error state.</p>
    pub normal: bool,
    /// <p>Status of the DB instance. For a StatusType of read replica, the values can be
    /// replicating, error, stopped, or terminated.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Details of the error if there is an error for the instance. If the instance is not in an
    /// error state, this value is blank.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbInstanceStatusInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbInstanceStatusInfo");
        formatter.field("status_type", &self.status_type);
        formatter.field("normal", &self.normal);
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DbInstanceStatusInfo`](crate::model::DbInstanceStatusInfo)
pub mod db_instance_status_info {
    /// A builder for [`DbInstanceStatusInfo`](crate::model::DbInstanceStatusInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_type: std::option::Option<std::string::String>,
        pub(crate) normal: std::option::Option<bool>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>This value is currently "read replication."</p>
        pub fn status_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_type = Some(input.into());
            self
        }
        /// <p>This value is currently "read replication."</p>
        pub fn set_status_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_type = input;
            self
        }
        /// <p>Boolean value that is true if the instance is operating normally, or false if the instance
        /// is in an error state.</p>
        pub fn normal(mut self, input: bool) -> Self {
            self.normal = Some(input);
            self
        }
        /// <p>Boolean value that is true if the instance is operating normally, or false if the instance
        /// is in an error state.</p>
        pub fn set_normal(mut self, input: std::option::Option<bool>) -> Self {
            self.normal = input;
            self
        }
        /// <p>Status of the DB instance. For a StatusType of read replica, the values can be
        /// replicating, error, stopped, or terminated.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Status of the DB instance. For a StatusType of read replica, the values can be
        /// replicating, error, stopped, or terminated.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Details of the error if there is an error for the instance. If the instance is not in an
        /// error state, this value is blank.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Details of the error if there is an error for the instance. If the instance is not in an
        /// error state, this value is blank.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbInstanceStatusInfo`](crate::model::DbInstanceStatusInfo)
        pub fn build(self) -> crate::model::DbInstanceStatusInfo {
            crate::model::DbInstanceStatusInfo {
                status_type: self.status_type,
                normal: self.normal.unwrap_or_default(),
                status: self.status,
                message: self.message,
            }
        }
    }
}
impl DbInstanceStatusInfo {
    /// Creates a new builder-style object to manufacture [`DbInstanceStatusInfo`](crate::model::DbInstanceStatusInfo)
    pub fn builder() -> crate::model::db_instance_status_info::Builder {
        crate::model::db_instance_status_info::Builder::default()
    }
}

/// <p>Not supported by Neptune.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptionGroupMembership {
    /// <p>Not supported by Neptune.</p>
    pub option_group_name: std::option::Option<std::string::String>,
    /// <p>Not supported by Neptune.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OptionGroupMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptionGroupMembership");
        formatter.field("option_group_name", &self.option_group_name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`OptionGroupMembership`](crate::model::OptionGroupMembership)
pub mod option_group_membership {
    /// A builder for [`OptionGroupMembership`](crate::model::OptionGroupMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) option_group_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Not supported by Neptune.</p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_name = Some(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_name = input;
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`OptionGroupMembership`](crate::model::OptionGroupMembership)
        pub fn build(self) -> crate::model::OptionGroupMembership {
            crate::model::OptionGroupMembership {
                option_group_name: self.option_group_name,
                status: self.status,
            }
        }
    }
}
impl OptionGroupMembership {
    /// Creates a new builder-style object to manufacture [`OptionGroupMembership`](crate::model::OptionGroupMembership)
    pub fn builder() -> crate::model::option_group_membership::Builder {
        crate::model::option_group_membership::Builder::default()
    }
}

/// <p> This data type is used as a response element in the <a>ModifyDBInstance</a>
/// action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PendingModifiedValues {
    /// <p> Contains the new <code>DBInstanceClass</code> for the DB instance that will be applied or
    /// is currently being applied.</p>
    pub db_instance_class: std::option::Option<std::string::String>,
    /// <p> Contains the new <code>AllocatedStorage</code> size for the DB instance that will be
    /// applied or is currently being applied.</p>
    pub allocated_storage: std::option::Option<i32>,
    /// <p>Not supported by Neptune.</p>
    pub master_user_password: std::option::Option<std::string::String>,
    /// <p>Specifies the pending port for the DB instance.</p>
    pub port: std::option::Option<i32>,
    /// <p>Specifies the pending number of days for which automated backups are retained.</p>
    pub backup_retention_period: std::option::Option<i32>,
    /// <p>Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.</p>
    pub multi_az: std::option::Option<bool>,
    /// <p>Indicates the database engine version.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Not supported by Neptune.</p>
    pub license_model: std::option::Option<std::string::String>,
    /// <p>Specifies the new Provisioned IOPS value for the DB instance that will be applied or is
    /// currently being applied.</p>
    pub iops: std::option::Option<i32>,
    /// <p> Contains the new <code>DBInstanceIdentifier</code> for the DB instance that will be
    /// applied or is currently being applied.</p>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the storage type to be associated with the DB instance.</p>
    pub storage_type: std::option::Option<std::string::String>,
    /// <p>Specifies the identifier of the CA certificate for the DB instance.</p>
    pub ca_certificate_identifier: std::option::Option<std::string::String>,
    /// <p>The new DB subnet group for the DB instance.</p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>This <code>PendingCloudwatchLogsExports</code> structure specifies
    /// pending changes to which CloudWatch logs are enabled and which are disabled.</p>
    pub pending_cloudwatch_logs_exports:
        std::option::Option<crate::model::PendingCloudwatchLogsExports>,
}
impl std::fmt::Debug for PendingModifiedValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PendingModifiedValues");
        formatter.field("db_instance_class", &self.db_instance_class);
        formatter.field("allocated_storage", &self.allocated_storage);
        formatter.field("master_user_password", &self.master_user_password);
        formatter.field("port", &self.port);
        formatter.field("backup_retention_period", &self.backup_retention_period);
        formatter.field("multi_az", &self.multi_az);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("license_model", &self.license_model);
        formatter.field("iops", &self.iops);
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("storage_type", &self.storage_type);
        formatter.field("ca_certificate_identifier", &self.ca_certificate_identifier);
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field(
            "pending_cloudwatch_logs_exports",
            &self.pending_cloudwatch_logs_exports,
        );
        formatter.finish()
    }
}
/// See [`PendingModifiedValues`](crate::model::PendingModifiedValues)
pub mod pending_modified_values {
    /// A builder for [`PendingModifiedValues`](crate::model::PendingModifiedValues)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_class: std::option::Option<std::string::String>,
        pub(crate) allocated_storage: std::option::Option<i32>,
        pub(crate) master_user_password: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) backup_retention_period: std::option::Option<i32>,
        pub(crate) multi_az: std::option::Option<bool>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) license_model: std::option::Option<std::string::String>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) storage_type: std::option::Option<std::string::String>,
        pub(crate) ca_certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) pending_cloudwatch_logs_exports:
            std::option::Option<crate::model::PendingCloudwatchLogsExports>,
    }
    impl Builder {
        /// <p> Contains the new <code>DBInstanceClass</code> for the DB instance that will be applied or
        /// is currently being applied.</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_class = Some(input.into());
            self
        }
        /// <p> Contains the new <code>DBInstanceClass</code> for the DB instance that will be applied or
        /// is currently being applied.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_class = input;
            self
        }
        /// <p> Contains the new <code>AllocatedStorage</code> size for the DB instance that will be
        /// applied or is currently being applied.</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.allocated_storage = Some(input);
            self
        }
        /// <p> Contains the new <code>AllocatedStorage</code> size for the DB instance that will be
        /// applied or is currently being applied.</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_storage = input;
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_password = Some(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_password = input;
            self
        }
        /// <p>Specifies the pending port for the DB instance.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Specifies the pending port for the DB instance.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Specifies the pending number of days for which automated backups are retained.</p>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.backup_retention_period = Some(input);
            self
        }
        /// <p>Specifies the pending number of days for which automated backups are retained.</p>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.backup_retention_period = input;
            self
        }
        /// <p>Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.</p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.multi_az = Some(input);
            self
        }
        /// <p>Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az = input;
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_model = Some(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_model = input;
            self
        }
        /// <p>Specifies the new Provisioned IOPS value for the DB instance that will be applied or is
        /// currently being applied.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>Specifies the new Provisioned IOPS value for the DB instance that will be applied or is
        /// currently being applied.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p> Contains the new <code>DBInstanceIdentifier</code> for the DB instance that will be
        /// applied or is currently being applied.</p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p> Contains the new <code>DBInstanceIdentifier</code> for the DB instance that will be
        /// applied or is currently being applied.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>Specifies the storage type to be associated with the DB instance.</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type = Some(input.into());
            self
        }
        /// <p>Specifies the storage type to be associated with the DB instance.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>Specifies the identifier of the CA certificate for the DB instance.</p>
        pub fn ca_certificate_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.ca_certificate_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the identifier of the CA certificate for the DB instance.</p>
        pub fn set_ca_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ca_certificate_identifier = input;
            self
        }
        /// <p>The new DB subnet group for the DB instance.</p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The new DB subnet group for the DB instance.</p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// <p>This <code>PendingCloudwatchLogsExports</code> structure specifies
        /// pending changes to which CloudWatch logs are enabled and which are disabled.</p>
        pub fn pending_cloudwatch_logs_exports(
            mut self,
            input: crate::model::PendingCloudwatchLogsExports,
        ) -> Self {
            self.pending_cloudwatch_logs_exports = Some(input);
            self
        }
        /// <p>This <code>PendingCloudwatchLogsExports</code> structure specifies
        /// pending changes to which CloudWatch logs are enabled and which are disabled.</p>
        pub fn set_pending_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<crate::model::PendingCloudwatchLogsExports>,
        ) -> Self {
            self.pending_cloudwatch_logs_exports = input;
            self
        }
        /// Consumes the builder and constructs a [`PendingModifiedValues`](crate::model::PendingModifiedValues)
        pub fn build(self) -> crate::model::PendingModifiedValues {
            crate::model::PendingModifiedValues {
                db_instance_class: self.db_instance_class,
                allocated_storage: self.allocated_storage,
                master_user_password: self.master_user_password,
                port: self.port,
                backup_retention_period: self.backup_retention_period,
                multi_az: self.multi_az,
                engine_version: self.engine_version,
                license_model: self.license_model,
                iops: self.iops,
                db_instance_identifier: self.db_instance_identifier,
                storage_type: self.storage_type,
                ca_certificate_identifier: self.ca_certificate_identifier,
                db_subnet_group_name: self.db_subnet_group_name,
                pending_cloudwatch_logs_exports: self.pending_cloudwatch_logs_exports,
            }
        }
    }
}
impl PendingModifiedValues {
    /// Creates a new builder-style object to manufacture [`PendingModifiedValues`](crate::model::PendingModifiedValues)
    pub fn builder() -> crate::model::pending_modified_values::Builder {
        crate::model::pending_modified_values::Builder::default()
    }
}

/// <p>A list of the log types whose configuration is still pending. In other
/// words, these log types are in the process of being activated or deactivated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PendingCloudwatchLogsExports {
    /// <p>Log types that are in the process of being deactivated. After they are
    /// deactivated, these log types aren't exported to CloudWatch Logs.</p>
    pub log_types_to_enable: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Log types that are in the process of being enabled. After they are
    /// enabled, these log types are exported to CloudWatch Logs.</p>
    pub log_types_to_disable: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for PendingCloudwatchLogsExports {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PendingCloudwatchLogsExports");
        formatter.field("log_types_to_enable", &self.log_types_to_enable);
        formatter.field("log_types_to_disable", &self.log_types_to_disable);
        formatter.finish()
    }
}
/// See [`PendingCloudwatchLogsExports`](crate::model::PendingCloudwatchLogsExports)
pub mod pending_cloudwatch_logs_exports {
    /// A builder for [`PendingCloudwatchLogsExports`](crate::model::PendingCloudwatchLogsExports)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_types_to_enable: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) log_types_to_disable: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `log_types_to_enable`.
        ///
        /// To override the contents of this collection use [`set_log_types_to_enable`](Self::set_log_types_to_enable).
        ///
        /// <p>Log types that are in the process of being deactivated. After they are
        /// deactivated, these log types aren't exported to CloudWatch Logs.</p>
        pub fn log_types_to_enable(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.log_types_to_enable.unwrap_or_default();
            v.push(input.into());
            self.log_types_to_enable = Some(v);
            self
        }
        /// <p>Log types that are in the process of being deactivated. After they are
        /// deactivated, these log types aren't exported to CloudWatch Logs.</p>
        pub fn set_log_types_to_enable(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.log_types_to_enable = input;
            self
        }
        /// Appends an item to `log_types_to_disable`.
        ///
        /// To override the contents of this collection use [`set_log_types_to_disable`](Self::set_log_types_to_disable).
        ///
        /// <p>Log types that are in the process of being enabled. After they are
        /// enabled, these log types are exported to CloudWatch Logs.</p>
        pub fn log_types_to_disable(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.log_types_to_disable.unwrap_or_default();
            v.push(input.into());
            self.log_types_to_disable = Some(v);
            self
        }
        /// <p>Log types that are in the process of being enabled. After they are
        /// enabled, these log types are exported to CloudWatch Logs.</p>
        pub fn set_log_types_to_disable(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.log_types_to_disable = input;
            self
        }
        /// Consumes the builder and constructs a [`PendingCloudwatchLogsExports`](crate::model::PendingCloudwatchLogsExports)
        pub fn build(self) -> crate::model::PendingCloudwatchLogsExports {
            crate::model::PendingCloudwatchLogsExports {
                log_types_to_enable: self.log_types_to_enable,
                log_types_to_disable: self.log_types_to_disable,
            }
        }
    }
}
impl PendingCloudwatchLogsExports {
    /// Creates a new builder-style object to manufacture [`PendingCloudwatchLogsExports`](crate::model::PendingCloudwatchLogsExports)
    pub fn builder() -> crate::model::pending_cloudwatch_logs_exports::Builder {
        crate::model::pending_cloudwatch_logs_exports::Builder::default()
    }
}

/// <p>Contains the details of an Amazon Neptune DB subnet group.</p>
/// <p>This data type is used as a response element in the <a>DescribeDBSubnetGroups</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSubnetGroup {
    /// <p>The name of the DB subnet group.</p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>Provides the description of the DB subnet group.</p>
    pub db_subnet_group_description: std::option::Option<std::string::String>,
    /// <p>Provides the VpcId of the DB subnet group.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>Provides the status of the DB subnet group.</p>
    pub subnet_group_status: std::option::Option<std::string::String>,
    /// <p> Contains a list of <a>Subnet</a> elements.</p>
    pub subnets: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
    /// <p>The Amazon Resource Name (ARN) for the DB subnet group.</p>
    pub db_subnet_group_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbSubnetGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSubnetGroup");
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field(
            "db_subnet_group_description",
            &self.db_subnet_group_description,
        );
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_group_status", &self.subnet_group_status);
        formatter.field("subnets", &self.subnets);
        formatter.field("db_subnet_group_arn", &self.db_subnet_group_arn);
        formatter.finish()
    }
}
/// See [`DbSubnetGroup`](crate::model::DbSubnetGroup)
pub mod db_subnet_group {
    /// A builder for [`DbSubnetGroup`](crate::model::DbSubnetGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group_description: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_group_status: std::option::Option<std::string::String>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
        pub(crate) db_subnet_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB subnet group.</p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB subnet group.</p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// <p>Provides the description of the DB subnet group.</p>
        pub fn db_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_subnet_group_description = Some(input.into());
            self
        }
        /// <p>Provides the description of the DB subnet group.</p>
        pub fn set_db_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_description = input;
            self
        }
        /// <p>Provides the VpcId of the DB subnet group.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>Provides the VpcId of the DB subnet group.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>Provides the status of the DB subnet group.</p>
        pub fn subnet_group_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_status = Some(input.into());
            self
        }
        /// <p>Provides the status of the DB subnet group.</p>
        pub fn set_subnet_group_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_status = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p> Contains a list of <a>Subnet</a> elements.</p>
        pub fn subnets(mut self, input: impl Into<crate::model::Subnet>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p> Contains a list of <a>Subnet</a> elements.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB subnet group.</p>
        pub fn db_subnet_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB subnet group.</p>
        pub fn set_db_subnet_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSubnetGroup`](crate::model::DbSubnetGroup)
        pub fn build(self) -> crate::model::DbSubnetGroup {
            crate::model::DbSubnetGroup {
                db_subnet_group_name: self.db_subnet_group_name,
                db_subnet_group_description: self.db_subnet_group_description,
                vpc_id: self.vpc_id,
                subnet_group_status: self.subnet_group_status,
                subnets: self.subnets,
                db_subnet_group_arn: self.db_subnet_group_arn,
            }
        }
    }
}
impl DbSubnetGroup {
    /// Creates a new builder-style object to manufacture [`DbSubnetGroup`](crate::model::DbSubnetGroup)
    pub fn builder() -> crate::model::db_subnet_group::Builder {
        crate::model::db_subnet_group::Builder::default()
    }
}

/// <p>Specifies a subnet.</p>
/// <p> This data type is used as a response element in the <a>DescribeDBSubnetGroups</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Subnet {
    /// <p>Specifies the identifier of the subnet.</p>
    pub subnet_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the EC2 Availability Zone that the subnet is in.</p>
    pub subnet_availability_zone: std::option::Option<crate::model::AvailabilityZone>,
    /// <p>Specifies the status of the subnet.</p>
    pub subnet_status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Subnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Subnet");
        formatter.field("subnet_identifier", &self.subnet_identifier);
        formatter.field("subnet_availability_zone", &self.subnet_availability_zone);
        formatter.field("subnet_status", &self.subnet_status);
        formatter.finish()
    }
}
/// See [`Subnet`](crate::model::Subnet)
pub mod subnet {
    /// A builder for [`Subnet`](crate::model::Subnet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_identifier: std::option::Option<std::string::String>,
        pub(crate) subnet_availability_zone: std::option::Option<crate::model::AvailabilityZone>,
        pub(crate) subnet_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the identifier of the subnet.</p>
        pub fn subnet_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the identifier of the subnet.</p>
        pub fn set_subnet_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_identifier = input;
            self
        }
        /// <p>Specifies the EC2 Availability Zone that the subnet is in.</p>
        pub fn subnet_availability_zone(mut self, input: crate::model::AvailabilityZone) -> Self {
            self.subnet_availability_zone = Some(input);
            self
        }
        /// <p>Specifies the EC2 Availability Zone that the subnet is in.</p>
        pub fn set_subnet_availability_zone(
            mut self,
            input: std::option::Option<crate::model::AvailabilityZone>,
        ) -> Self {
            self.subnet_availability_zone = input;
            self
        }
        /// <p>Specifies the status of the subnet.</p>
        pub fn subnet_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_status = Some(input.into());
            self
        }
        /// <p>Specifies the status of the subnet.</p>
        pub fn set_subnet_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_status = input;
            self
        }
        /// Consumes the builder and constructs a [`Subnet`](crate::model::Subnet)
        pub fn build(self) -> crate::model::Subnet {
            crate::model::Subnet {
                subnet_identifier: self.subnet_identifier,
                subnet_availability_zone: self.subnet_availability_zone,
                subnet_status: self.subnet_status,
            }
        }
    }
}
impl Subnet {
    /// Creates a new builder-style object to manufacture [`Subnet`](crate::model::Subnet)
    pub fn builder() -> crate::model::subnet::Builder {
        crate::model::subnet::Builder::default()
    }
}

/// <p>Specifies an Availability Zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AvailabilityZone {
    /// <p>The name of the availability zone.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AvailabilityZone {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AvailabilityZone");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`AvailabilityZone`](crate::model::AvailabilityZone)
pub mod availability_zone {
    /// A builder for [`AvailabilityZone`](crate::model::AvailabilityZone)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the availability zone.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the availability zone.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`AvailabilityZone`](crate::model::AvailabilityZone)
        pub fn build(self) -> crate::model::AvailabilityZone {
            crate::model::AvailabilityZone { name: self.name }
        }
    }
}
impl AvailabilityZone {
    /// Creates a new builder-style object to manufacture [`AvailabilityZone`](crate::model::AvailabilityZone)
    pub fn builder() -> crate::model::availability_zone::Builder {
        crate::model::availability_zone::Builder::default()
    }
}

/// <p>The status of the DB parameter group.</p>
/// <p>This data type is used as a response element in the following actions:</p>
/// <ul>
/// <li>
/// <p>
/// <a>CreateDBInstance</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>DeleteDBInstance</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>ModifyDBInstance</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>RebootDBInstance</a>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbParameterGroupStatus {
    /// <p>The name of the DP parameter group.</p>
    pub db_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The status of parameter updates.</p>
    pub parameter_apply_status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbParameterGroupStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbParameterGroupStatus");
        formatter.field("db_parameter_group_name", &self.db_parameter_group_name);
        formatter.field("parameter_apply_status", &self.parameter_apply_status);
        formatter.finish()
    }
}
/// See [`DbParameterGroupStatus`](crate::model::DbParameterGroupStatus)
pub mod db_parameter_group_status {
    /// A builder for [`DbParameterGroupStatus`](crate::model::DbParameterGroupStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) parameter_apply_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DP parameter group.</p>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DP parameter group.</p>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// <p>The status of parameter updates.</p>
        pub fn parameter_apply_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_apply_status = Some(input.into());
            self
        }
        /// <p>The status of parameter updates.</p>
        pub fn set_parameter_apply_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_apply_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DbParameterGroupStatus`](crate::model::DbParameterGroupStatus)
        pub fn build(self) -> crate::model::DbParameterGroupStatus {
            crate::model::DbParameterGroupStatus {
                db_parameter_group_name: self.db_parameter_group_name,
                parameter_apply_status: self.parameter_apply_status,
            }
        }
    }
}
impl DbParameterGroupStatus {
    /// Creates a new builder-style object to manufacture [`DbParameterGroupStatus`](crate::model::DbParameterGroupStatus)
    pub fn builder() -> crate::model::db_parameter_group_status::Builder {
        crate::model::db_parameter_group_status::Builder::default()
    }
}

/// <p>Specifies membership in a designated DB security group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSecurityGroupMembership {
    /// <p>The name of the DB security group.</p>
    pub db_security_group_name: std::option::Option<std::string::String>,
    /// <p>The status of the DB security group.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbSecurityGroupMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSecurityGroupMembership");
        formatter.field("db_security_group_name", &self.db_security_group_name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DbSecurityGroupMembership`](crate::model::DbSecurityGroupMembership)
pub mod db_security_group_membership {
    /// A builder for [`DbSecurityGroupMembership`](crate::model::DbSecurityGroupMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_security_group_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB security group.</p>
        pub fn db_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_security_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB security group.</p>
        pub fn set_db_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_security_group_name = input;
            self
        }
        /// <p>The status of the DB security group.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the DB security group.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSecurityGroupMembership`](crate::model::DbSecurityGroupMembership)
        pub fn build(self) -> crate::model::DbSecurityGroupMembership {
            crate::model::DbSecurityGroupMembership {
                db_security_group_name: self.db_security_group_name,
                status: self.status,
            }
        }
    }
}
impl DbSecurityGroupMembership {
    /// Creates a new builder-style object to manufacture [`DbSecurityGroupMembership`](crate::model::DbSecurityGroupMembership)
    pub fn builder() -> crate::model::db_security_group_membership::Builder {
        crate::model::db_security_group_membership::Builder::default()
    }
}

/// <p>Specifies a connection endpoint.</p>
///
/// <p>For the data structure that represents Amazon Neptune DB cluster endpoints,
/// see <code>DBClusterEndpoint</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Endpoint {
    /// <p>Specifies the DNS address of the DB instance.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>Specifies the port that the database engine is listening on.</p>
    pub port: i32,
    /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Endpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Endpoint");
        formatter.field("address", &self.address);
        formatter.field("port", &self.port);
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.finish()
    }
}
/// See [`Endpoint`](crate::model::Endpoint)
pub mod endpoint {
    /// A builder for [`Endpoint`](crate::model::Endpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the DNS address of the DB instance.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>Specifies the DNS address of the DB instance.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>Specifies the port that the database engine is listening on.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Specifies the port that the database engine is listening on.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Endpoint`](crate::model::Endpoint)
        pub fn build(self) -> crate::model::Endpoint {
            crate::model::Endpoint {
                address: self.address,
                port: self.port.unwrap_or_default(),
                hosted_zone_id: self.hosted_zone_id,
            }
        }
    }
}
impl Endpoint {
    /// Creates a new builder-style object to manufacture [`Endpoint`](crate::model::Endpoint)
    pub fn builder() -> crate::model::endpoint::Builder {
        crate::model::endpoint::Builder::default()
    }
}

/// <p>The configuration setting for the log types to be enabled for export
/// to CloudWatch Logs for a specific DB instance or DB cluster.</p>
///
/// <p>The <code>EnableLogTypes</code> and <code>DisableLogTypes</code> arrays
/// determine which logs will be exported (or not exported) to CloudWatch Logs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudwatchLogsExportConfiguration {
    /// <p>The list of log types to enable.</p>
    pub enable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of log types to disable.</p>
    pub disable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for CloudwatchLogsExportConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudwatchLogsExportConfiguration");
        formatter.field("enable_log_types", &self.enable_log_types);
        formatter.field("disable_log_types", &self.disable_log_types);
        formatter.finish()
    }
}
/// See [`CloudwatchLogsExportConfiguration`](crate::model::CloudwatchLogsExportConfiguration)
pub mod cloudwatch_logs_export_configuration {
    /// A builder for [`CloudwatchLogsExportConfiguration`](crate::model::CloudwatchLogsExportConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) disable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `enable_log_types`.
        ///
        /// To override the contents of this collection use [`set_enable_log_types`](Self::set_enable_log_types).
        ///
        /// <p>The list of log types to enable.</p>
        pub fn enable_log_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.enable_log_types.unwrap_or_default();
            v.push(input.into());
            self.enable_log_types = Some(v);
            self
        }
        /// <p>The list of log types to enable.</p>
        pub fn set_enable_log_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.enable_log_types = input;
            self
        }
        /// Appends an item to `disable_log_types`.
        ///
        /// To override the contents of this collection use [`set_disable_log_types`](Self::set_disable_log_types).
        ///
        /// <p>The list of log types to disable.</p>
        pub fn disable_log_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.disable_log_types.unwrap_or_default();
            v.push(input.into());
            self.disable_log_types = Some(v);
            self
        }
        /// <p>The list of log types to disable.</p>
        pub fn set_disable_log_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.disable_log_types = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudwatchLogsExportConfiguration`](crate::model::CloudwatchLogsExportConfiguration)
        pub fn build(self) -> crate::model::CloudwatchLogsExportConfiguration {
            crate::model::CloudwatchLogsExportConfiguration {
                enable_log_types: self.enable_log_types,
                disable_log_types: self.disable_log_types,
            }
        }
    }
}
impl CloudwatchLogsExportConfiguration {
    /// Creates a new builder-style object to manufacture [`CloudwatchLogsExportConfiguration`](crate::model::CloudwatchLogsExportConfiguration)
    pub fn builder() -> crate::model::cloudwatch_logs_export_configuration::Builder {
        crate::model::cloudwatch_logs_export_configuration::Builder::default()
    }
}

/// <p>Contains the results of a successful call to the <a>DescribeDBClusterSnapshotAttributes</a> API action.</p>
/// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon accounts to copy or
/// restore a manual DB cluster snapshot. For more information, see the <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterSnapshotAttributesResult {
    /// <p>The identifier of the manual DB cluster snapshot that the attributes apply to.</p>
    pub db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>The list of attributes and values for the manual DB cluster snapshot.</p>
    pub db_cluster_snapshot_attributes:
        std::option::Option<std::vec::Vec<crate::model::DbClusterSnapshotAttribute>>,
}
impl std::fmt::Debug for DbClusterSnapshotAttributesResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterSnapshotAttributesResult");
        formatter.field(
            "db_cluster_snapshot_identifier",
            &self.db_cluster_snapshot_identifier,
        );
        formatter.field(
            "db_cluster_snapshot_attributes",
            &self.db_cluster_snapshot_attributes,
        );
        formatter.finish()
    }
}
/// See [`DbClusterSnapshotAttributesResult`](crate::model::DbClusterSnapshotAttributesResult)
pub mod db_cluster_snapshot_attributes_result {
    /// A builder for [`DbClusterSnapshotAttributesResult`](crate::model::DbClusterSnapshotAttributesResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_snapshot_attributes:
            std::option::Option<std::vec::Vec<crate::model::DbClusterSnapshotAttribute>>,
    }
    impl Builder {
        /// <p>The identifier of the manual DB cluster snapshot that the attributes apply to.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the manual DB cluster snapshot that the attributes apply to.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = input;
            self
        }
        /// Appends an item to `db_cluster_snapshot_attributes`.
        ///
        /// To override the contents of this collection use [`set_db_cluster_snapshot_attributes`](Self::set_db_cluster_snapshot_attributes).
        ///
        /// <p>The list of attributes and values for the manual DB cluster snapshot.</p>
        pub fn db_cluster_snapshot_attributes(
            mut self,
            input: impl Into<crate::model::DbClusterSnapshotAttribute>,
        ) -> Self {
            let mut v = self.db_cluster_snapshot_attributes.unwrap_or_default();
            v.push(input.into());
            self.db_cluster_snapshot_attributes = Some(v);
            self
        }
        /// <p>The list of attributes and values for the manual DB cluster snapshot.</p>
        pub fn set_db_cluster_snapshot_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbClusterSnapshotAttribute>>,
        ) -> Self {
            self.db_cluster_snapshot_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterSnapshotAttributesResult`](crate::model::DbClusterSnapshotAttributesResult)
        pub fn build(self) -> crate::model::DbClusterSnapshotAttributesResult {
            crate::model::DbClusterSnapshotAttributesResult {
                db_cluster_snapshot_identifier: self.db_cluster_snapshot_identifier,
                db_cluster_snapshot_attributes: self.db_cluster_snapshot_attributes,
            }
        }
    }
}
impl DbClusterSnapshotAttributesResult {
    /// Creates a new builder-style object to manufacture [`DbClusterSnapshotAttributesResult`](crate::model::DbClusterSnapshotAttributesResult)
    pub fn builder() -> crate::model::db_cluster_snapshot_attributes_result::Builder {
        crate::model::db_cluster_snapshot_attributes_result::Builder::default()
    }
}

/// <p>Contains the name and values of a manual DB cluster snapshot attribute.</p>
/// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon accounts to restore
/// a manual DB cluster snapshot. For more information, see the <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterSnapshotAttribute {
    /// <p>The name of the manual DB cluster snapshot attribute.</p>
    /// <p>The attribute named <code>restore</code> refers to the list of Amazon accounts that have
    /// permission to copy or restore the manual DB cluster snapshot. For more information, see the
    /// <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The value(s) for the manual DB cluster snapshot attribute.</p>
    /// <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element
    /// returns a list of IDs of the Amazon accounts that are authorized to copy or restore the manual DB
    /// cluster snapshot. If a value of <code>all</code> is in the list, then the manual DB cluster
    /// snapshot is public and available for any Amazon account to copy or restore.</p>
    pub attribute_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for DbClusterSnapshotAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterSnapshotAttribute");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("attribute_values", &self.attribute_values);
        formatter.finish()
    }
}
/// See [`DbClusterSnapshotAttribute`](crate::model::DbClusterSnapshotAttribute)
pub mod db_cluster_snapshot_attribute {
    /// A builder for [`DbClusterSnapshotAttribute`](crate::model::DbClusterSnapshotAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) attribute_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the manual DB cluster snapshot attribute.</p>
        /// <p>The attribute named <code>restore</code> refers to the list of Amazon accounts that have
        /// permission to copy or restore the manual DB cluster snapshot. For more information, see the
        /// <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the manual DB cluster snapshot attribute.</p>
        /// <p>The attribute named <code>restore</code> refers to the list of Amazon accounts that have
        /// permission to copy or restore the manual DB cluster snapshot. For more information, see the
        /// <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// Appends an item to `attribute_values`.
        ///
        /// To override the contents of this collection use [`set_attribute_values`](Self::set_attribute_values).
        ///
        /// <p>The value(s) for the manual DB cluster snapshot attribute.</p>
        /// <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element
        /// returns a list of IDs of the Amazon accounts that are authorized to copy or restore the manual DB
        /// cluster snapshot. If a value of <code>all</code> is in the list, then the manual DB cluster
        /// snapshot is public and available for any Amazon account to copy or restore.</p>
        pub fn attribute_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attribute_values.unwrap_or_default();
            v.push(input.into());
            self.attribute_values = Some(v);
            self
        }
        /// <p>The value(s) for the manual DB cluster snapshot attribute.</p>
        /// <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element
        /// returns a list of IDs of the Amazon accounts that are authorized to copy or restore the manual DB
        /// cluster snapshot. If a value of <code>all</code> is in the list, then the manual DB cluster
        /// snapshot is public and available for any Amazon account to copy or restore.</p>
        pub fn set_attribute_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attribute_values = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterSnapshotAttribute`](crate::model::DbClusterSnapshotAttribute)
        pub fn build(self) -> crate::model::DbClusterSnapshotAttribute {
            crate::model::DbClusterSnapshotAttribute {
                attribute_name: self.attribute_name,
                attribute_values: self.attribute_values,
            }
        }
    }
}
impl DbClusterSnapshotAttribute {
    /// Creates a new builder-style object to manufacture [`DbClusterSnapshotAttribute`](crate::model::DbClusterSnapshotAttribute)
    pub fn builder() -> crate::model::db_cluster_snapshot_attribute::Builder {
        crate::model::db_cluster_snapshot_attribute::Builder::default()
    }
}

/// <p>This type is not currently supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>This parameter is not currently supported.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>This parameter is not currently supported.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

/// <p>Information about valid modifications that you can make to your DB instance. Contains the
/// result of a successful call to the <a>DescribeValidDBInstanceModifications</a>
/// action. You can use this information when you call <a>ModifyDBInstance</a>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidDbInstanceModificationsMessage {
    /// <p>Valid storage options for your DB instance.</p>
    pub storage: std::option::Option<std::vec::Vec<crate::model::ValidStorageOptions>>,
}
impl std::fmt::Debug for ValidDbInstanceModificationsMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidDbInstanceModificationsMessage");
        formatter.field("storage", &self.storage);
        formatter.finish()
    }
}
/// See [`ValidDbInstanceModificationsMessage`](crate::model::ValidDbInstanceModificationsMessage)
pub mod valid_db_instance_modifications_message {
    /// A builder for [`ValidDbInstanceModificationsMessage`](crate::model::ValidDbInstanceModificationsMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage: std::option::Option<std::vec::Vec<crate::model::ValidStorageOptions>>,
    }
    impl Builder {
        /// Appends an item to `storage`.
        ///
        /// To override the contents of this collection use [`set_storage`](Self::set_storage).
        ///
        /// <p>Valid storage options for your DB instance.</p>
        pub fn storage(mut self, input: impl Into<crate::model::ValidStorageOptions>) -> Self {
            let mut v = self.storage.unwrap_or_default();
            v.push(input.into());
            self.storage = Some(v);
            self
        }
        /// <p>Valid storage options for your DB instance.</p>
        pub fn set_storage(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidStorageOptions>>,
        ) -> Self {
            self.storage = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidDbInstanceModificationsMessage`](crate::model::ValidDbInstanceModificationsMessage)
        pub fn build(self) -> crate::model::ValidDbInstanceModificationsMessage {
            crate::model::ValidDbInstanceModificationsMessage {
                storage: self.storage,
            }
        }
    }
}
impl ValidDbInstanceModificationsMessage {
    /// Creates a new builder-style object to manufacture [`ValidDbInstanceModificationsMessage`](crate::model::ValidDbInstanceModificationsMessage)
    pub fn builder() -> crate::model::valid_db_instance_modifications_message::Builder {
        crate::model::valid_db_instance_modifications_message::Builder::default()
    }
}

/// <p>Information about valid modifications that you can make to your DB
/// instance.</p>
/// <p>Contains the result of a successful call to the <a>DescribeValidDBInstanceModifications</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidStorageOptions {
    /// <p>The valid storage types for your DB instance. For example, gp2, io1.</p>
    pub storage_type: std::option::Option<std::string::String>,
    /// <p>The valid range of storage in gibibytes. For example, 100 to 16384.</p>
    pub storage_size: std::option::Option<std::vec::Vec<crate::model::Range>>,
    /// <p>The valid range of provisioned IOPS. For example, 1000-20000.</p>
    pub provisioned_iops: std::option::Option<std::vec::Vec<crate::model::Range>>,
    /// <p>The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10,
    /// which means that provisioned IOPS can be between 3 and 10 times storage.</p>
    pub iops_to_storage_ratio: std::option::Option<std::vec::Vec<crate::model::DoubleRange>>,
}
impl std::fmt::Debug for ValidStorageOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidStorageOptions");
        formatter.field("storage_type", &self.storage_type);
        formatter.field("storage_size", &self.storage_size);
        formatter.field("provisioned_iops", &self.provisioned_iops);
        formatter.field("iops_to_storage_ratio", &self.iops_to_storage_ratio);
        formatter.finish()
    }
}
/// See [`ValidStorageOptions`](crate::model::ValidStorageOptions)
pub mod valid_storage_options {
    /// A builder for [`ValidStorageOptions`](crate::model::ValidStorageOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_type: std::option::Option<std::string::String>,
        pub(crate) storage_size: std::option::Option<std::vec::Vec<crate::model::Range>>,
        pub(crate) provisioned_iops: std::option::Option<std::vec::Vec<crate::model::Range>>,
        pub(crate) iops_to_storage_ratio:
            std::option::Option<std::vec::Vec<crate::model::DoubleRange>>,
    }
    impl Builder {
        /// <p>The valid storage types for your DB instance. For example, gp2, io1.</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type = Some(input.into());
            self
        }
        /// <p>The valid storage types for your DB instance. For example, gp2, io1.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage_type = input;
            self
        }
        /// Appends an item to `storage_size`.
        ///
        /// To override the contents of this collection use [`set_storage_size`](Self::set_storage_size).
        ///
        /// <p>The valid range of storage in gibibytes. For example, 100 to 16384.</p>
        pub fn storage_size(mut self, input: impl Into<crate::model::Range>) -> Self {
            let mut v = self.storage_size.unwrap_or_default();
            v.push(input.into());
            self.storage_size = Some(v);
            self
        }
        /// <p>The valid range of storage in gibibytes. For example, 100 to 16384.</p>
        pub fn set_storage_size(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Range>>,
        ) -> Self {
            self.storage_size = input;
            self
        }
        /// Appends an item to `provisioned_iops`.
        ///
        /// To override the contents of this collection use [`set_provisioned_iops`](Self::set_provisioned_iops).
        ///
        /// <p>The valid range of provisioned IOPS. For example, 1000-20000.</p>
        pub fn provisioned_iops(mut self, input: impl Into<crate::model::Range>) -> Self {
            let mut v = self.provisioned_iops.unwrap_or_default();
            v.push(input.into());
            self.provisioned_iops = Some(v);
            self
        }
        /// <p>The valid range of provisioned IOPS. For example, 1000-20000.</p>
        pub fn set_provisioned_iops(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Range>>,
        ) -> Self {
            self.provisioned_iops = input;
            self
        }
        /// Appends an item to `iops_to_storage_ratio`.
        ///
        /// To override the contents of this collection use [`set_iops_to_storage_ratio`](Self::set_iops_to_storage_ratio).
        ///
        /// <p>The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10,
        /// which means that provisioned IOPS can be between 3 and 10 times storage.</p>
        pub fn iops_to_storage_ratio(
            mut self,
            input: impl Into<crate::model::DoubleRange>,
        ) -> Self {
            let mut v = self.iops_to_storage_ratio.unwrap_or_default();
            v.push(input.into());
            self.iops_to_storage_ratio = Some(v);
            self
        }
        /// <p>The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10,
        /// which means that provisioned IOPS can be between 3 and 10 times storage.</p>
        pub fn set_iops_to_storage_ratio(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DoubleRange>>,
        ) -> Self {
            self.iops_to_storage_ratio = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidStorageOptions`](crate::model::ValidStorageOptions)
        pub fn build(self) -> crate::model::ValidStorageOptions {
            crate::model::ValidStorageOptions {
                storage_type: self.storage_type,
                storage_size: self.storage_size,
                provisioned_iops: self.provisioned_iops,
                iops_to_storage_ratio: self.iops_to_storage_ratio,
            }
        }
    }
}
impl ValidStorageOptions {
    /// Creates a new builder-style object to manufacture [`ValidStorageOptions`](crate::model::ValidStorageOptions)
    pub fn builder() -> crate::model::valid_storage_options::Builder {
        crate::model::valid_storage_options::Builder::default()
    }
}

/// <p>A range of double values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DoubleRange {
    /// <p>The minimum value in the range.</p>
    pub from: f64,
    /// <p>The maximum value in the range.</p>
    pub to: f64,
}
impl std::fmt::Debug for DoubleRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DoubleRange");
        formatter.field("from", &self.from);
        formatter.field("to", &self.to);
        formatter.finish()
    }
}
/// See [`DoubleRange`](crate::model::DoubleRange)
pub mod double_range {
    /// A builder for [`DoubleRange`](crate::model::DoubleRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from: std::option::Option<f64>,
        pub(crate) to: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The minimum value in the range.</p>
        pub fn from(mut self, input: f64) -> Self {
            self.from = Some(input);
            self
        }
        /// <p>The minimum value in the range.</p>
        pub fn set_from(mut self, input: std::option::Option<f64>) -> Self {
            self.from = input;
            self
        }
        /// <p>The maximum value in the range.</p>
        pub fn to(mut self, input: f64) -> Self {
            self.to = Some(input);
            self
        }
        /// <p>The maximum value in the range.</p>
        pub fn set_to(mut self, input: std::option::Option<f64>) -> Self {
            self.to = input;
            self
        }
        /// Consumes the builder and constructs a [`DoubleRange`](crate::model::DoubleRange)
        pub fn build(self) -> crate::model::DoubleRange {
            crate::model::DoubleRange {
                from: self.from.unwrap_or_default(),
                to: self.to.unwrap_or_default(),
            }
        }
    }
}
impl DoubleRange {
    /// Creates a new builder-style object to manufacture [`DoubleRange`](crate::model::DoubleRange)
    pub fn builder() -> crate::model::double_range::Builder {
        crate::model::double_range::Builder::default()
    }
}

/// <p>A range of integer values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Range {
    /// <p>The minimum value in the range.</p>
    pub from: i32,
    /// <p>The maximum value in the range.</p>
    pub to: i32,
    /// <p>The step value for the range. For example, if you have a range of 5,000 to 10,000, with a
    /// step value of 1,000, the valid values start at 5,000 and step up by 1,000. Even though 7,500
    /// is within the range, it isn't a valid value for the range. The valid values are 5,000, 6,000,
    /// 7,000, 8,000...</p>
    pub step: std::option::Option<i32>,
}
impl std::fmt::Debug for Range {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Range");
        formatter.field("from", &self.from);
        formatter.field("to", &self.to);
        formatter.field("step", &self.step);
        formatter.finish()
    }
}
/// See [`Range`](crate::model::Range)
pub mod range {
    /// A builder for [`Range`](crate::model::Range)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from: std::option::Option<i32>,
        pub(crate) to: std::option::Option<i32>,
        pub(crate) step: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The minimum value in the range.</p>
        pub fn from(mut self, input: i32) -> Self {
            self.from = Some(input);
            self
        }
        /// <p>The minimum value in the range.</p>
        pub fn set_from(mut self, input: std::option::Option<i32>) -> Self {
            self.from = input;
            self
        }
        /// <p>The maximum value in the range.</p>
        pub fn to(mut self, input: i32) -> Self {
            self.to = Some(input);
            self
        }
        /// <p>The maximum value in the range.</p>
        pub fn set_to(mut self, input: std::option::Option<i32>) -> Self {
            self.to = input;
            self
        }
        /// <p>The step value for the range. For example, if you have a range of 5,000 to 10,000, with a
        /// step value of 1,000, the valid values start at 5,000 and step up by 1,000. Even though 7,500
        /// is within the range, it isn't a valid value for the range. The valid values are 5,000, 6,000,
        /// 7,000, 8,000...</p>
        pub fn step(mut self, input: i32) -> Self {
            self.step = Some(input);
            self
        }
        /// <p>The step value for the range. For example, if you have a range of 5,000 to 10,000, with a
        /// step value of 1,000, the valid values start at 5,000 and step up by 1,000. Even though 7,500
        /// is within the range, it isn't a valid value for the range. The valid values are 5,000, 6,000,
        /// 7,000, 8,000...</p>
        pub fn set_step(mut self, input: std::option::Option<i32>) -> Self {
            self.step = input;
            self
        }
        /// Consumes the builder and constructs a [`Range`](crate::model::Range)
        pub fn build(self) -> crate::model::Range {
            crate::model::Range {
                from: self.from.unwrap_or_default(),
                to: self.to.unwrap_or_default(),
                step: self.step,
            }
        }
    }
}
impl Range {
    /// Creates a new builder-style object to manufacture [`Range`](crate::model::Range)
    pub fn builder() -> crate::model::range::Builder {
        crate::model::range::Builder::default()
    }
}

/// <p>Describes the pending maintenance actions for a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourcePendingMaintenanceActions {
    /// <p>The ARN of the resource that has pending maintenance actions.</p>
    pub resource_identifier: std::option::Option<std::string::String>,
    /// <p>A list that provides details about the pending maintenance actions for the
    /// resource.</p>
    pub pending_maintenance_action_details:
        std::option::Option<std::vec::Vec<crate::model::PendingMaintenanceAction>>,
}
impl std::fmt::Debug for ResourcePendingMaintenanceActions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourcePendingMaintenanceActions");
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field(
            "pending_maintenance_action_details",
            &self.pending_maintenance_action_details,
        );
        formatter.finish()
    }
}
/// See [`ResourcePendingMaintenanceActions`](crate::model::ResourcePendingMaintenanceActions)
pub mod resource_pending_maintenance_actions {
    /// A builder for [`ResourcePendingMaintenanceActions`](crate::model::ResourcePendingMaintenanceActions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
        pub(crate) pending_maintenance_action_details:
            std::option::Option<std::vec::Vec<crate::model::PendingMaintenanceAction>>,
    }
    impl Builder {
        /// <p>The ARN of the resource that has pending maintenance actions.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// <p>The ARN of the resource that has pending maintenance actions.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// Appends an item to `pending_maintenance_action_details`.
        ///
        /// To override the contents of this collection use [`set_pending_maintenance_action_details`](Self::set_pending_maintenance_action_details).
        ///
        /// <p>A list that provides details about the pending maintenance actions for the
        /// resource.</p>
        pub fn pending_maintenance_action_details(
            mut self,
            input: impl Into<crate::model::PendingMaintenanceAction>,
        ) -> Self {
            let mut v = self.pending_maintenance_action_details.unwrap_or_default();
            v.push(input.into());
            self.pending_maintenance_action_details = Some(v);
            self
        }
        /// <p>A list that provides details about the pending maintenance actions for the
        /// resource.</p>
        pub fn set_pending_maintenance_action_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PendingMaintenanceAction>>,
        ) -> Self {
            self.pending_maintenance_action_details = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourcePendingMaintenanceActions`](crate::model::ResourcePendingMaintenanceActions)
        pub fn build(self) -> crate::model::ResourcePendingMaintenanceActions {
            crate::model::ResourcePendingMaintenanceActions {
                resource_identifier: self.resource_identifier,
                pending_maintenance_action_details: self.pending_maintenance_action_details,
            }
        }
    }
}
impl ResourcePendingMaintenanceActions {
    /// Creates a new builder-style object to manufacture [`ResourcePendingMaintenanceActions`](crate::model::ResourcePendingMaintenanceActions)
    pub fn builder() -> crate::model::resource_pending_maintenance_actions::Builder {
        crate::model::resource_pending_maintenance_actions::Builder::default()
    }
}

/// <p>Provides information about a pending maintenance action for a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PendingMaintenanceAction {
    /// <p>The type of pending maintenance action that is available for the resource.</p>
    pub action: std::option::Option<std::string::String>,
    /// <p>The date of the maintenance window when the action is applied. The maintenance action is
    /// applied to the resource during its first maintenance window after this date. If this date is
    /// specified, any <code>next-maintenance</code> opt-in requests are ignored.</p>
    pub auto_applied_after_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date when the maintenance action is automatically applied. The maintenance action is
    /// applied to the resource on this date regardless of the maintenance window for the resource. If
    /// this date is specified, any <code>immediate</code> opt-in requests are ignored.</p>
    pub forced_apply_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Indicates the type of opt-in request that has been received for the resource.</p>
    pub opt_in_status: std::option::Option<std::string::String>,
    /// <p>The effective date when the pending maintenance action is applied to the resource. This
    /// date takes into account opt-in requests received from the <a>ApplyPendingMaintenanceAction</a> API, the <code>AutoAppliedAfterDate</code>, and the
    /// <code>ForcedApplyDate</code>. This value is blank if an opt-in request has not been received
    /// and nothing has been specified as <code>AutoAppliedAfterDate</code> or
    /// <code>ForcedApplyDate</code>.</p>
    pub current_apply_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A description providing more detail about the maintenance action.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PendingMaintenanceAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PendingMaintenanceAction");
        formatter.field("action", &self.action);
        formatter.field("auto_applied_after_date", &self.auto_applied_after_date);
        formatter.field("forced_apply_date", &self.forced_apply_date);
        formatter.field("opt_in_status", &self.opt_in_status);
        formatter.field("current_apply_date", &self.current_apply_date);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
pub mod pending_maintenance_action {
    /// A builder for [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<std::string::String>,
        pub(crate) auto_applied_after_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) forced_apply_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) opt_in_status: std::option::Option<std::string::String>,
        pub(crate) current_apply_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of pending maintenance action that is available for the resource.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.action = Some(input.into());
            self
        }
        /// <p>The type of pending maintenance action that is available for the resource.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action = input;
            self
        }
        /// <p>The date of the maintenance window when the action is applied. The maintenance action is
        /// applied to the resource during its first maintenance window after this date. If this date is
        /// specified, any <code>next-maintenance</code> opt-in requests are ignored.</p>
        pub fn auto_applied_after_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.auto_applied_after_date = Some(input);
            self
        }
        /// <p>The date of the maintenance window when the action is applied. The maintenance action is
        /// applied to the resource during its first maintenance window after this date. If this date is
        /// specified, any <code>next-maintenance</code> opt-in requests are ignored.</p>
        pub fn set_auto_applied_after_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.auto_applied_after_date = input;
            self
        }
        /// <p>The date when the maintenance action is automatically applied. The maintenance action is
        /// applied to the resource on this date regardless of the maintenance window for the resource. If
        /// this date is specified, any <code>immediate</code> opt-in requests are ignored.</p>
        pub fn forced_apply_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.forced_apply_date = Some(input);
            self
        }
        /// <p>The date when the maintenance action is automatically applied. The maintenance action is
        /// applied to the resource on this date regardless of the maintenance window for the resource. If
        /// this date is specified, any <code>immediate</code> opt-in requests are ignored.</p>
        pub fn set_forced_apply_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.forced_apply_date = input;
            self
        }
        /// <p>Indicates the type of opt-in request that has been received for the resource.</p>
        pub fn opt_in_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_in_status = Some(input.into());
            self
        }
        /// <p>Indicates the type of opt-in request that has been received for the resource.</p>
        pub fn set_opt_in_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_in_status = input;
            self
        }
        /// <p>The effective date when the pending maintenance action is applied to the resource. This
        /// date takes into account opt-in requests received from the <a>ApplyPendingMaintenanceAction</a> API, the <code>AutoAppliedAfterDate</code>, and the
        /// <code>ForcedApplyDate</code>. This value is blank if an opt-in request has not been received
        /// and nothing has been specified as <code>AutoAppliedAfterDate</code> or
        /// <code>ForcedApplyDate</code>.</p>
        pub fn current_apply_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.current_apply_date = Some(input);
            self
        }
        /// <p>The effective date when the pending maintenance action is applied to the resource. This
        /// date takes into account opt-in requests received from the <a>ApplyPendingMaintenanceAction</a> API, the <code>AutoAppliedAfterDate</code>, and the
        /// <code>ForcedApplyDate</code>. This value is blank if an opt-in request has not been received
        /// and nothing has been specified as <code>AutoAppliedAfterDate</code> or
        /// <code>ForcedApplyDate</code>.</p>
        pub fn set_current_apply_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.current_apply_date = input;
            self
        }
        /// <p>A description providing more detail about the maintenance action.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description providing more detail about the maintenance action.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
        pub fn build(self) -> crate::model::PendingMaintenanceAction {
            crate::model::PendingMaintenanceAction {
                action: self.action,
                auto_applied_after_date: self.auto_applied_after_date,
                forced_apply_date: self.forced_apply_date,
                opt_in_status: self.opt_in_status,
                current_apply_date: self.current_apply_date,
                description: self.description,
            }
        }
    }
}
impl PendingMaintenanceAction {
    /// Creates a new builder-style object to manufacture [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
    pub fn builder() -> crate::model::pending_maintenance_action::Builder {
        crate::model::pending_maintenance_action::Builder::default()
    }
}

/// <p>Contains a list of available options for a DB instance.</p>
/// <p> This data type is used as a response element in the <a>DescribeOrderableDBInstanceOptions</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrderableDbInstanceOption {
    /// <p>The engine type of a DB instance.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The engine version of a DB instance.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The DB instance class for a DB instance.</p>
    pub db_instance_class: std::option::Option<std::string::String>,
    /// <p>The license model for a DB instance.</p>
    pub license_model: std::option::Option<std::string::String>,
    /// <p>A list of Availability Zones for a DB instance.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
    /// <p>Indicates whether a DB instance is Multi-AZ capable.</p>
    pub multi_az_capable: bool,
    /// <p>Indicates whether a DB instance can have a Read Replica.</p>
    pub read_replica_capable: bool,
    /// <p>Indicates whether a DB instance is in a VPC.</p>
    pub vpc: bool,
    /// <p>Indicates whether a DB instance supports encrypted storage.</p>
    pub supports_storage_encryption: bool,
    /// <p>Indicates the storage type for a DB instance.</p>
    pub storage_type: std::option::Option<std::string::String>,
    /// <p>Indicates whether a DB instance supports provisioned IOPS.</p>
    pub supports_iops: bool,
    /// <p>Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60
    /// seconds.</p>
    pub supports_enhanced_monitoring: bool,
    /// <p>Indicates whether a DB instance supports IAM database authentication.</p>
    pub supports_iam_database_authentication: bool,
    /// <p>
    /// <i>(Not supported by Neptune)</i>
    /// </p>
    pub supports_performance_insights: bool,
    /// <p>Minimum storage size for a DB instance.</p>
    pub min_storage_size: std::option::Option<i32>,
    /// <p>Maximum storage size for a DB instance.</p>
    pub max_storage_size: std::option::Option<i32>,
    /// <p>Minimum total provisioned IOPS for a DB instance.</p>
    pub min_iops_per_db_instance: std::option::Option<i32>,
    /// <p>Maximum total provisioned IOPS for a DB instance.</p>
    pub max_iops_per_db_instance: std::option::Option<i32>,
    /// <p>Minimum provisioned IOPS per GiB for a DB instance.</p>
    pub min_iops_per_gib: std::option::Option<f64>,
    /// <p>Maximum provisioned IOPS per GiB for a DB instance.</p>
    pub max_iops_per_gib: std::option::Option<f64>,
}
impl std::fmt::Debug for OrderableDbInstanceOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrderableDbInstanceOption");
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("db_instance_class", &self.db_instance_class);
        formatter.field("license_model", &self.license_model);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("multi_az_capable", &self.multi_az_capable);
        formatter.field("read_replica_capable", &self.read_replica_capable);
        formatter.field("vpc", &self.vpc);
        formatter.field(
            "supports_storage_encryption",
            &self.supports_storage_encryption,
        );
        formatter.field("storage_type", &self.storage_type);
        formatter.field("supports_iops", &self.supports_iops);
        formatter.field(
            "supports_enhanced_monitoring",
            &self.supports_enhanced_monitoring,
        );
        formatter.field(
            "supports_iam_database_authentication",
            &self.supports_iam_database_authentication,
        );
        formatter.field(
            "supports_performance_insights",
            &self.supports_performance_insights,
        );
        formatter.field("min_storage_size", &self.min_storage_size);
        formatter.field("max_storage_size", &self.max_storage_size);
        formatter.field("min_iops_per_db_instance", &self.min_iops_per_db_instance);
        formatter.field("max_iops_per_db_instance", &self.max_iops_per_db_instance);
        formatter.field("min_iops_per_gib", &self.min_iops_per_gib);
        formatter.field("max_iops_per_gib", &self.max_iops_per_gib);
        formatter.finish()
    }
}
/// See [`OrderableDbInstanceOption`](crate::model::OrderableDbInstanceOption)
pub mod orderable_db_instance_option {
    /// A builder for [`OrderableDbInstanceOption`](crate::model::OrderableDbInstanceOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) db_instance_class: std::option::Option<std::string::String>,
        pub(crate) license_model: std::option::Option<std::string::String>,
        pub(crate) availability_zones:
            std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
        pub(crate) multi_az_capable: std::option::Option<bool>,
        pub(crate) read_replica_capable: std::option::Option<bool>,
        pub(crate) vpc: std::option::Option<bool>,
        pub(crate) supports_storage_encryption: std::option::Option<bool>,
        pub(crate) storage_type: std::option::Option<std::string::String>,
        pub(crate) supports_iops: std::option::Option<bool>,
        pub(crate) supports_enhanced_monitoring: std::option::Option<bool>,
        pub(crate) supports_iam_database_authentication: std::option::Option<bool>,
        pub(crate) supports_performance_insights: std::option::Option<bool>,
        pub(crate) min_storage_size: std::option::Option<i32>,
        pub(crate) max_storage_size: std::option::Option<i32>,
        pub(crate) min_iops_per_db_instance: std::option::Option<i32>,
        pub(crate) max_iops_per_db_instance: std::option::Option<i32>,
        pub(crate) min_iops_per_gib: std::option::Option<f64>,
        pub(crate) max_iops_per_gib: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The engine type of a DB instance.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The engine type of a DB instance.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The engine version of a DB instance.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The engine version of a DB instance.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The DB instance class for a DB instance.</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_class = Some(input.into());
            self
        }
        /// <p>The DB instance class for a DB instance.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_class = input;
            self
        }
        /// <p>The license model for a DB instance.</p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_model = Some(input.into());
            self
        }
        /// <p>The license model for a DB instance.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_model = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>A list of Availability Zones for a DB instance.</p>
        pub fn availability_zones(
            mut self,
            input: impl Into<crate::model::AvailabilityZone>,
        ) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>A list of Availability Zones for a DB instance.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// <p>Indicates whether a DB instance is Multi-AZ capable.</p>
        pub fn multi_az_capable(mut self, input: bool) -> Self {
            self.multi_az_capable = Some(input);
            self
        }
        /// <p>Indicates whether a DB instance is Multi-AZ capable.</p>
        pub fn set_multi_az_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az_capable = input;
            self
        }
        /// <p>Indicates whether a DB instance can have a Read Replica.</p>
        pub fn read_replica_capable(mut self, input: bool) -> Self {
            self.read_replica_capable = Some(input);
            self
        }
        /// <p>Indicates whether a DB instance can have a Read Replica.</p>
        pub fn set_read_replica_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.read_replica_capable = input;
            self
        }
        /// <p>Indicates whether a DB instance is in a VPC.</p>
        pub fn vpc(mut self, input: bool) -> Self {
            self.vpc = Some(input);
            self
        }
        /// <p>Indicates whether a DB instance is in a VPC.</p>
        pub fn set_vpc(mut self, input: std::option::Option<bool>) -> Self {
            self.vpc = input;
            self
        }
        /// <p>Indicates whether a DB instance supports encrypted storage.</p>
        pub fn supports_storage_encryption(mut self, input: bool) -> Self {
            self.supports_storage_encryption = Some(input);
            self
        }
        /// <p>Indicates whether a DB instance supports encrypted storage.</p>
        pub fn set_supports_storage_encryption(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_storage_encryption = input;
            self
        }
        /// <p>Indicates the storage type for a DB instance.</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type = Some(input.into());
            self
        }
        /// <p>Indicates the storage type for a DB instance.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>Indicates whether a DB instance supports provisioned IOPS.</p>
        pub fn supports_iops(mut self, input: bool) -> Self {
            self.supports_iops = Some(input);
            self
        }
        /// <p>Indicates whether a DB instance supports provisioned IOPS.</p>
        pub fn set_supports_iops(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_iops = input;
            self
        }
        /// <p>Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60
        /// seconds.</p>
        pub fn supports_enhanced_monitoring(mut self, input: bool) -> Self {
            self.supports_enhanced_monitoring = Some(input);
            self
        }
        /// <p>Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60
        /// seconds.</p>
        pub fn set_supports_enhanced_monitoring(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.supports_enhanced_monitoring = input;
            self
        }
        /// <p>Indicates whether a DB instance supports IAM database authentication.</p>
        pub fn supports_iam_database_authentication(mut self, input: bool) -> Self {
            self.supports_iam_database_authentication = Some(input);
            self
        }
        /// <p>Indicates whether a DB instance supports IAM database authentication.</p>
        pub fn set_supports_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.supports_iam_database_authentication = input;
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn supports_performance_insights(mut self, input: bool) -> Self {
            self.supports_performance_insights = Some(input);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_supports_performance_insights(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.supports_performance_insights = input;
            self
        }
        /// <p>Minimum storage size for a DB instance.</p>
        pub fn min_storage_size(mut self, input: i32) -> Self {
            self.min_storage_size = Some(input);
            self
        }
        /// <p>Minimum storage size for a DB instance.</p>
        pub fn set_min_storage_size(mut self, input: std::option::Option<i32>) -> Self {
            self.min_storage_size = input;
            self
        }
        /// <p>Maximum storage size for a DB instance.</p>
        pub fn max_storage_size(mut self, input: i32) -> Self {
            self.max_storage_size = Some(input);
            self
        }
        /// <p>Maximum storage size for a DB instance.</p>
        pub fn set_max_storage_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_storage_size = input;
            self
        }
        /// <p>Minimum total provisioned IOPS for a DB instance.</p>
        pub fn min_iops_per_db_instance(mut self, input: i32) -> Self {
            self.min_iops_per_db_instance = Some(input);
            self
        }
        /// <p>Minimum total provisioned IOPS for a DB instance.</p>
        pub fn set_min_iops_per_db_instance(mut self, input: std::option::Option<i32>) -> Self {
            self.min_iops_per_db_instance = input;
            self
        }
        /// <p>Maximum total provisioned IOPS for a DB instance.</p>
        pub fn max_iops_per_db_instance(mut self, input: i32) -> Self {
            self.max_iops_per_db_instance = Some(input);
            self
        }
        /// <p>Maximum total provisioned IOPS for a DB instance.</p>
        pub fn set_max_iops_per_db_instance(mut self, input: std::option::Option<i32>) -> Self {
            self.max_iops_per_db_instance = input;
            self
        }
        /// <p>Minimum provisioned IOPS per GiB for a DB instance.</p>
        pub fn min_iops_per_gib(mut self, input: f64) -> Self {
            self.min_iops_per_gib = Some(input);
            self
        }
        /// <p>Minimum provisioned IOPS per GiB for a DB instance.</p>
        pub fn set_min_iops_per_gib(mut self, input: std::option::Option<f64>) -> Self {
            self.min_iops_per_gib = input;
            self
        }
        /// <p>Maximum provisioned IOPS per GiB for a DB instance.</p>
        pub fn max_iops_per_gib(mut self, input: f64) -> Self {
            self.max_iops_per_gib = Some(input);
            self
        }
        /// <p>Maximum provisioned IOPS per GiB for a DB instance.</p>
        pub fn set_max_iops_per_gib(mut self, input: std::option::Option<f64>) -> Self {
            self.max_iops_per_gib = input;
            self
        }
        /// Consumes the builder and constructs a [`OrderableDbInstanceOption`](crate::model::OrderableDbInstanceOption)
        pub fn build(self) -> crate::model::OrderableDbInstanceOption {
            crate::model::OrderableDbInstanceOption {
                engine: self.engine,
                engine_version: self.engine_version,
                db_instance_class: self.db_instance_class,
                license_model: self.license_model,
                availability_zones: self.availability_zones,
                multi_az_capable: self.multi_az_capable.unwrap_or_default(),
                read_replica_capable: self.read_replica_capable.unwrap_or_default(),
                vpc: self.vpc.unwrap_or_default(),
                supports_storage_encryption: self.supports_storage_encryption.unwrap_or_default(),
                storage_type: self.storage_type,
                supports_iops: self.supports_iops.unwrap_or_default(),
                supports_enhanced_monitoring: self.supports_enhanced_monitoring.unwrap_or_default(),
                supports_iam_database_authentication: self
                    .supports_iam_database_authentication
                    .unwrap_or_default(),
                supports_performance_insights: self
                    .supports_performance_insights
                    .unwrap_or_default(),
                min_storage_size: self.min_storage_size,
                max_storage_size: self.max_storage_size,
                min_iops_per_db_instance: self.min_iops_per_db_instance,
                max_iops_per_db_instance: self.max_iops_per_db_instance,
                min_iops_per_gib: self.min_iops_per_gib,
                max_iops_per_gib: self.max_iops_per_gib,
            }
        }
    }
}
impl OrderableDbInstanceOption {
    /// Creates a new builder-style object to manufacture [`OrderableDbInstanceOption`](crate::model::OrderableDbInstanceOption)
    pub fn builder() -> crate::model::orderable_db_instance_option::Builder {
        crate::model::orderable_db_instance_option::Builder::default()
    }
}

/// <p> This data type is used as a response element in the <a>DescribeEvents</a>
/// action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Event {
    /// <p>Provides the identifier for the source of the event.</p>
    pub source_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the source type for this event.</p>
    pub source_type: std::option::Option<crate::model::SourceType>,
    /// <p>Provides the text of this event.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Specifies the category for the event.</p>
    pub event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the date and time of the event.</p>
    pub date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) for the event.</p>
    pub source_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Event {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Event");
        formatter.field("source_identifier", &self.source_identifier);
        formatter.field("source_type", &self.source_type);
        formatter.field("message", &self.message);
        formatter.field("event_categories", &self.event_categories);
        formatter.field("date", &self.date);
        formatter.field("source_arn", &self.source_arn);
        formatter.finish()
    }
}
/// See [`Event`](crate::model::Event)
pub mod event {
    /// A builder for [`Event`](crate::model::Event)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_identifier: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Provides the identifier for the source of the event.</p>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identifier = Some(input.into());
            self
        }
        /// <p>Provides the identifier for the source of the event.</p>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identifier = input;
            self
        }
        /// <p>Specifies the source type for this event.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>Specifies the source type for this event.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p>Provides the text of this event.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Provides the text of this event.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>Specifies the category for the event.</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p>Specifies the category for the event.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// <p>Specifies the date and time of the event.</p>
        pub fn date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.date = Some(input);
            self
        }
        /// <p>Specifies the date and time of the event.</p>
        pub fn set_date(mut self, input: std::option::Option<aws_smithy_types::Instant>) -> Self {
            self.date = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the event.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the event.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Event`](crate::model::Event)
        pub fn build(self) -> crate::model::Event {
            crate::model::Event {
                source_identifier: self.source_identifier,
                source_type: self.source_type,
                message: self.message,
                event_categories: self.event_categories,
                date: self.date,
                source_arn: self.source_arn,
            }
        }
    }
}
impl Event {
    /// Creates a new builder-style object to manufacture [`Event`](crate::model::Event)
    pub fn builder() -> crate::model::event::Builder {
        crate::model::event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceType {
    #[allow(missing_docs)] // documentation missing in model
    DbCluster,
    #[allow(missing_docs)] // documentation missing in model
    DbClusterSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    DbInstance,
    #[allow(missing_docs)] // documentation missing in model
    DbParameterGroup,
    #[allow(missing_docs)] // documentation missing in model
    DbSecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    DbSnapshot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceType {
    fn from(s: &str) -> Self {
        match s {
            "db-cluster" => SourceType::DbCluster,
            "db-cluster-snapshot" => SourceType::DbClusterSnapshot,
            "db-instance" => SourceType::DbInstance,
            "db-parameter-group" => SourceType::DbParameterGroup,
            "db-security-group" => SourceType::DbSecurityGroup,
            "db-snapshot" => SourceType::DbSnapshot,
            other => SourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceType::from(s))
    }
}
impl SourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceType::DbCluster => "db-cluster",
            SourceType::DbClusterSnapshot => "db-cluster-snapshot",
            SourceType::DbInstance => "db-instance",
            SourceType::DbParameterGroup => "db-parameter-group",
            SourceType::DbSecurityGroup => "db-security-group",
            SourceType::DbSnapshot => "db-snapshot",
            SourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "db-cluster",
            "db-cluster-snapshot",
            "db-instance",
            "db-parameter-group",
            "db-security-group",
            "db-snapshot",
        ]
    }
}
impl AsRef<str> for SourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the results of a successful invocation of the <a>DescribeEventCategories</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventCategoriesMap {
    /// <p>The source type that the returned categories belong to</p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p>The event categories for the specified source type</p>
    pub event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for EventCategoriesMap {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventCategoriesMap");
        formatter.field("source_type", &self.source_type);
        formatter.field("event_categories", &self.event_categories);
        formatter.finish()
    }
}
/// See [`EventCategoriesMap`](crate::model::EventCategoriesMap)
pub mod event_categories_map {
    /// A builder for [`EventCategoriesMap`](crate::model::EventCategoriesMap)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The source type that the returned categories belong to</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The source type that the returned categories belong to</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>The event categories for the specified source type</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p>The event categories for the specified source type</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// Consumes the builder and constructs a [`EventCategoriesMap`](crate::model::EventCategoriesMap)
        pub fn build(self) -> crate::model::EventCategoriesMap {
            crate::model::EventCategoriesMap {
                source_type: self.source_type,
                event_categories: self.event_categories,
            }
        }
    }
}
impl EventCategoriesMap {
    /// Creates a new builder-style object to manufacture [`EventCategoriesMap`](crate::model::EventCategoriesMap)
    pub fn builder() -> crate::model::event_categories_map::Builder {
        crate::model::event_categories_map::Builder::default()
    }
}

/// <p> Contains the result of a successful invocation of the <a>DescribeEngineDefaultParameters</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EngineDefaults {
    /// <p>Specifies the name of the DB parameter group family that the engine default parameters
    /// apply to.</p>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p> An optional pagination token provided by a previous EngineDefaults request. If this
    /// parameter is specified, the response includes only records beyond the marker, up to the value
    /// specified by <code>MaxRecords</code> .</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Contains a list of engine default parameters.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
}
impl std::fmt::Debug for EngineDefaults {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EngineDefaults");
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("marker", &self.marker);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`EngineDefaults`](crate::model::EngineDefaults)
pub mod engine_defaults {
    /// A builder for [`EngineDefaults`](crate::model::EngineDefaults)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    }
    impl Builder {
        /// <p>Specifies the name of the DB parameter group family that the engine default parameters
        /// apply to.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>Specifies the name of the DB parameter group family that the engine default parameters
        /// apply to.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// <p> An optional pagination token provided by a previous EngineDefaults request. If this
        /// parameter is specified, the response includes only records beyond the marker, up to the value
        /// specified by <code>MaxRecords</code> .</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous EngineDefaults request. If this
        /// parameter is specified, the response includes only records beyond the marker, up to the value
        /// specified by <code>MaxRecords</code> .</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Contains a list of engine default parameters.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>Contains a list of engine default parameters.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`EngineDefaults`](crate::model::EngineDefaults)
        pub fn build(self) -> crate::model::EngineDefaults {
            crate::model::EngineDefaults {
                db_parameter_group_family: self.db_parameter_group_family,
                marker: self.marker,
                parameters: self.parameters,
            }
        }
    }
}
impl EngineDefaults {
    /// Creates a new builder-style object to manufacture [`EngineDefaults`](crate::model::EngineDefaults)
    pub fn builder() -> crate::model::engine_defaults::Builder {
        crate::model::engine_defaults::Builder::default()
    }
}

/// <p>Contains the details of an Amazon Neptune DB parameter group.</p>
/// <p>This data type is used as a response element in the <a>DescribeDBParameterGroups</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbParameterGroup {
    /// <p>Provides the name of the DB parameter group.</p>
    pub db_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>Provides the name of the DB parameter group family that this DB parameter group is
    /// compatible with.</p>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>Provides the customer-specified description for this DB parameter group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the DB parameter group.</p>
    pub db_parameter_group_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbParameterGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbParameterGroup");
        formatter.field("db_parameter_group_name", &self.db_parameter_group_name);
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("description", &self.description);
        formatter.field("db_parameter_group_arn", &self.db_parameter_group_arn);
        formatter.finish()
    }
}
/// See [`DbParameterGroup`](crate::model::DbParameterGroup)
pub mod db_parameter_group {
    /// A builder for [`DbParameterGroup`](crate::model::DbParameterGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Provides the name of the DB parameter group.</p>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>Provides the name of the DB parameter group.</p>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// <p>Provides the name of the DB parameter group family that this DB parameter group is
        /// compatible with.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>Provides the name of the DB parameter group family that this DB parameter group is
        /// compatible with.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// <p>Provides the customer-specified description for this DB parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Provides the customer-specified description for this DB parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB parameter group.</p>
        pub fn db_parameter_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB parameter group.</p>
        pub fn set_db_parameter_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DbParameterGroup`](crate::model::DbParameterGroup)
        pub fn build(self) -> crate::model::DbParameterGroup {
            crate::model::DbParameterGroup {
                db_parameter_group_name: self.db_parameter_group_name,
                db_parameter_group_family: self.db_parameter_group_family,
                description: self.description,
                db_parameter_group_arn: self.db_parameter_group_arn,
            }
        }
    }
}
impl DbParameterGroup {
    /// Creates a new builder-style object to manufacture [`DbParameterGroup`](crate::model::DbParameterGroup)
    pub fn builder() -> crate::model::db_parameter_group::Builder {
        crate::model::db_parameter_group::Builder::default()
    }
}

/// <p> This data type is used as a response element in the action <a>DescribeDBEngineVersions</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbEngineVersion {
    /// <p>The name of the database engine.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The version number of the database engine.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The name of the DB parameter group family for the database engine.</p>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>The description of the database engine.</p>
    pub db_engine_description: std::option::Option<std::string::String>,
    /// <p>The description of the database engine version.</p>
    pub db_engine_version_description: std::option::Option<std::string::String>,
    /// <p>
    /// <i>(Not supported by Neptune)</i>
    /// </p>
    pub default_character_set: std::option::Option<crate::model::CharacterSet>,
    /// <p>
    /// <i>(Not supported by Neptune)</i>
    /// </p>
    pub supported_character_sets: std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
    /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
    pub valid_upgrade_target: std::option::Option<std::vec::Vec<crate::model::UpgradeTarget>>,
    /// <p>A list of the time zones supported by this engine for the <code>Timezone</code> parameter
    /// of the <code>CreateDBInstance</code> action.</p>
    pub supported_timezones: std::option::Option<std::vec::Vec<crate::model::Timezone>>,
    /// <p>The types of logs that the database engine has available for export to CloudWatch
    /// Logs.</p>
    pub exportable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A value that indicates whether the engine version supports exporting the log types
    /// specified by ExportableLogTypes to CloudWatch Logs.</p>
    pub supports_log_exports_to_cloudwatch_logs: bool,
    /// <p>Indicates whether the database engine version supports read replicas.</p>
    pub supports_read_replica: bool,
}
impl std::fmt::Debug for DbEngineVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbEngineVersion");
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("db_engine_description", &self.db_engine_description);
        formatter.field(
            "db_engine_version_description",
            &self.db_engine_version_description,
        );
        formatter.field("default_character_set", &self.default_character_set);
        formatter.field("supported_character_sets", &self.supported_character_sets);
        formatter.field("valid_upgrade_target", &self.valid_upgrade_target);
        formatter.field("supported_timezones", &self.supported_timezones);
        formatter.field("exportable_log_types", &self.exportable_log_types);
        formatter.field(
            "supports_log_exports_to_cloudwatch_logs",
            &self.supports_log_exports_to_cloudwatch_logs,
        );
        formatter.field("supports_read_replica", &self.supports_read_replica);
        formatter.finish()
    }
}
/// See [`DbEngineVersion`](crate::model::DbEngineVersion)
pub mod db_engine_version {
    /// A builder for [`DbEngineVersion`](crate::model::DbEngineVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) db_engine_description: std::option::Option<std::string::String>,
        pub(crate) db_engine_version_description: std::option::Option<std::string::String>,
        pub(crate) default_character_set: std::option::Option<crate::model::CharacterSet>,
        pub(crate) supported_character_sets:
            std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
        pub(crate) valid_upgrade_target:
            std::option::Option<std::vec::Vec<crate::model::UpgradeTarget>>,
        pub(crate) supported_timezones: std::option::Option<std::vec::Vec<crate::model::Timezone>>,
        pub(crate) exportable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) supports_log_exports_to_cloudwatch_logs: std::option::Option<bool>,
        pub(crate) supports_read_replica: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the database engine.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the database engine.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The version number of the database engine.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the database engine.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The name of the DB parameter group family for the database engine.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group family for the database engine.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// <p>The description of the database engine.</p>
        pub fn db_engine_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_engine_description = Some(input.into());
            self
        }
        /// <p>The description of the database engine.</p>
        pub fn set_db_engine_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_engine_description = input;
            self
        }
        /// <p>The description of the database engine version.</p>
        pub fn db_engine_version_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_engine_version_description = Some(input.into());
            self
        }
        /// <p>The description of the database engine version.</p>
        pub fn set_db_engine_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_engine_version_description = input;
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn default_character_set(mut self, input: crate::model::CharacterSet) -> Self {
            self.default_character_set = Some(input);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_default_character_set(
            mut self,
            input: std::option::Option<crate::model::CharacterSet>,
        ) -> Self {
            self.default_character_set = input;
            self
        }
        /// Appends an item to `supported_character_sets`.
        ///
        /// To override the contents of this collection use [`set_supported_character_sets`](Self::set_supported_character_sets).
        ///
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn supported_character_sets(
            mut self,
            input: impl Into<crate::model::CharacterSet>,
        ) -> Self {
            let mut v = self.supported_character_sets.unwrap_or_default();
            v.push(input.into());
            self.supported_character_sets = Some(v);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_supported_character_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
        ) -> Self {
            self.supported_character_sets = input;
            self
        }
        /// Appends an item to `valid_upgrade_target`.
        ///
        /// To override the contents of this collection use [`set_valid_upgrade_target`](Self::set_valid_upgrade_target).
        ///
        /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
        pub fn valid_upgrade_target(
            mut self,
            input: impl Into<crate::model::UpgradeTarget>,
        ) -> Self {
            let mut v = self.valid_upgrade_target.unwrap_or_default();
            v.push(input.into());
            self.valid_upgrade_target = Some(v);
            self
        }
        /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
        pub fn set_valid_upgrade_target(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpgradeTarget>>,
        ) -> Self {
            self.valid_upgrade_target = input;
            self
        }
        /// Appends an item to `supported_timezones`.
        ///
        /// To override the contents of this collection use [`set_supported_timezones`](Self::set_supported_timezones).
        ///
        /// <p>A list of the time zones supported by this engine for the <code>Timezone</code> parameter
        /// of the <code>CreateDBInstance</code> action.</p>
        pub fn supported_timezones(mut self, input: impl Into<crate::model::Timezone>) -> Self {
            let mut v = self.supported_timezones.unwrap_or_default();
            v.push(input.into());
            self.supported_timezones = Some(v);
            self
        }
        /// <p>A list of the time zones supported by this engine for the <code>Timezone</code> parameter
        /// of the <code>CreateDBInstance</code> action.</p>
        pub fn set_supported_timezones(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Timezone>>,
        ) -> Self {
            self.supported_timezones = input;
            self
        }
        /// Appends an item to `exportable_log_types`.
        ///
        /// To override the contents of this collection use [`set_exportable_log_types`](Self::set_exportable_log_types).
        ///
        /// <p>The types of logs that the database engine has available for export to CloudWatch
        /// Logs.</p>
        pub fn exportable_log_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exportable_log_types.unwrap_or_default();
            v.push(input.into());
            self.exportable_log_types = Some(v);
            self
        }
        /// <p>The types of logs that the database engine has available for export to CloudWatch
        /// Logs.</p>
        pub fn set_exportable_log_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exportable_log_types = input;
            self
        }
        /// <p>A value that indicates whether the engine version supports exporting the log types
        /// specified by ExportableLogTypes to CloudWatch Logs.</p>
        pub fn supports_log_exports_to_cloudwatch_logs(mut self, input: bool) -> Self {
            self.supports_log_exports_to_cloudwatch_logs = Some(input);
            self
        }
        /// <p>A value that indicates whether the engine version supports exporting the log types
        /// specified by ExportableLogTypes to CloudWatch Logs.</p>
        pub fn set_supports_log_exports_to_cloudwatch_logs(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.supports_log_exports_to_cloudwatch_logs = input;
            self
        }
        /// <p>Indicates whether the database engine version supports read replicas.</p>
        pub fn supports_read_replica(mut self, input: bool) -> Self {
            self.supports_read_replica = Some(input);
            self
        }
        /// <p>Indicates whether the database engine version supports read replicas.</p>
        pub fn set_supports_read_replica(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_read_replica = input;
            self
        }
        /// Consumes the builder and constructs a [`DbEngineVersion`](crate::model::DbEngineVersion)
        pub fn build(self) -> crate::model::DbEngineVersion {
            crate::model::DbEngineVersion {
                engine: self.engine,
                engine_version: self.engine_version,
                db_parameter_group_family: self.db_parameter_group_family,
                db_engine_description: self.db_engine_description,
                db_engine_version_description: self.db_engine_version_description,
                default_character_set: self.default_character_set,
                supported_character_sets: self.supported_character_sets,
                valid_upgrade_target: self.valid_upgrade_target,
                supported_timezones: self.supported_timezones,
                exportable_log_types: self.exportable_log_types,
                supports_log_exports_to_cloudwatch_logs: self
                    .supports_log_exports_to_cloudwatch_logs
                    .unwrap_or_default(),
                supports_read_replica: self.supports_read_replica.unwrap_or_default(),
            }
        }
    }
}
impl DbEngineVersion {
    /// Creates a new builder-style object to manufacture [`DbEngineVersion`](crate::model::DbEngineVersion)
    pub fn builder() -> crate::model::db_engine_version::Builder {
        crate::model::db_engine_version::Builder::default()
    }
}

/// <p>A time zone associated with a <a>DBInstance</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Timezone {
    /// <p>The name of the time zone.</p>
    pub timezone_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Timezone {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Timezone");
        formatter.field("timezone_name", &self.timezone_name);
        formatter.finish()
    }
}
/// See [`Timezone`](crate::model::Timezone)
pub mod timezone {
    /// A builder for [`Timezone`](crate::model::Timezone)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timezone_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the time zone.</p>
        pub fn timezone_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone_name = Some(input.into());
            self
        }
        /// <p>The name of the time zone.</p>
        pub fn set_timezone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.timezone_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Timezone`](crate::model::Timezone)
        pub fn build(self) -> crate::model::Timezone {
            crate::model::Timezone {
                timezone_name: self.timezone_name,
            }
        }
    }
}
impl Timezone {
    /// Creates a new builder-style object to manufacture [`Timezone`](crate::model::Timezone)
    pub fn builder() -> crate::model::timezone::Builder {
        crate::model::timezone::Builder::default()
    }
}

/// <p>The version of the database engine that a DB instance can be upgraded to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpgradeTarget {
    /// <p>The name of the upgrade target database engine.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The version number of the upgrade target database engine.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The version of the database engine that a DB instance can be upgraded to.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A value that indicates whether the target version is applied to any source DB instances
    /// that have AutoMinorVersionUpgrade set to true.</p>
    pub auto_upgrade: bool,
    /// <p>A value that indicates whether a database engine is upgraded to a major version.</p>
    pub is_major_version_upgrade: bool,
}
impl std::fmt::Debug for UpgradeTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpgradeTarget");
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("description", &self.description);
        formatter.field("auto_upgrade", &self.auto_upgrade);
        formatter.field("is_major_version_upgrade", &self.is_major_version_upgrade);
        formatter.finish()
    }
}
/// See [`UpgradeTarget`](crate::model::UpgradeTarget)
pub mod upgrade_target {
    /// A builder for [`UpgradeTarget`](crate::model::UpgradeTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) auto_upgrade: std::option::Option<bool>,
        pub(crate) is_major_version_upgrade: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the upgrade target database engine.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the upgrade target database engine.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The version number of the upgrade target database engine.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the upgrade target database engine.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The version of the database engine that a DB instance can be upgraded to.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The version of the database engine that a DB instance can be upgraded to.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A value that indicates whether the target version is applied to any source DB instances
        /// that have AutoMinorVersionUpgrade set to true.</p>
        pub fn auto_upgrade(mut self, input: bool) -> Self {
            self.auto_upgrade = Some(input);
            self
        }
        /// <p>A value that indicates whether the target version is applied to any source DB instances
        /// that have AutoMinorVersionUpgrade set to true.</p>
        pub fn set_auto_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_upgrade = input;
            self
        }
        /// <p>A value that indicates whether a database engine is upgraded to a major version.</p>
        pub fn is_major_version_upgrade(mut self, input: bool) -> Self {
            self.is_major_version_upgrade = Some(input);
            self
        }
        /// <p>A value that indicates whether a database engine is upgraded to a major version.</p>
        pub fn set_is_major_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.is_major_version_upgrade = input;
            self
        }
        /// Consumes the builder and constructs a [`UpgradeTarget`](crate::model::UpgradeTarget)
        pub fn build(self) -> crate::model::UpgradeTarget {
            crate::model::UpgradeTarget {
                engine: self.engine,
                engine_version: self.engine_version,
                description: self.description,
                auto_upgrade: self.auto_upgrade.unwrap_or_default(),
                is_major_version_upgrade: self.is_major_version_upgrade.unwrap_or_default(),
            }
        }
    }
}
impl UpgradeTarget {
    /// Creates a new builder-style object to manufacture [`UpgradeTarget`](crate::model::UpgradeTarget)
    pub fn builder() -> crate::model::upgrade_target::Builder {
        crate::model::upgrade_target::Builder::default()
    }
}

/// <p>Specifies a character set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CharacterSet {
    /// <p>The name of the character set.</p>
    pub character_set_name: std::option::Option<std::string::String>,
    /// <p>The description of the character set.</p>
    pub character_set_description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CharacterSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CharacterSet");
        formatter.field("character_set_name", &self.character_set_name);
        formatter.field("character_set_description", &self.character_set_description);
        formatter.finish()
    }
}
/// See [`CharacterSet`](crate::model::CharacterSet)
pub mod character_set {
    /// A builder for [`CharacterSet`](crate::model::CharacterSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) character_set_name: std::option::Option<std::string::String>,
        pub(crate) character_set_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the character set.</p>
        pub fn character_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.character_set_name = Some(input.into());
            self
        }
        /// <p>The name of the character set.</p>
        pub fn set_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.character_set_name = input;
            self
        }
        /// <p>The description of the character set.</p>
        pub fn character_set_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.character_set_description = Some(input.into());
            self
        }
        /// <p>The description of the character set.</p>
        pub fn set_character_set_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.character_set_description = input;
            self
        }
        /// Consumes the builder and constructs a [`CharacterSet`](crate::model::CharacterSet)
        pub fn build(self) -> crate::model::CharacterSet {
            crate::model::CharacterSet {
                character_set_name: self.character_set_name,
                character_set_description: self.character_set_description,
            }
        }
    }
}
impl CharacterSet {
    /// Creates a new builder-style object to manufacture [`CharacterSet`](crate::model::CharacterSet)
    pub fn builder() -> crate::model::character_set::Builder {
        crate::model::character_set::Builder::default()
    }
}

/// <p>Contains the details for an Amazon Neptune DB cluster snapshot</p>
/// <p>This data type is used as a response element in the <a>DescribeDBClusterSnapshots</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterSnapshot {
    /// <p>Provides the list of EC2 Availability Zones that instances in the DB cluster snapshot can
    /// be restored in.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the identifier for a DB cluster snapshot. Must match the identifier
    /// of an existing snapshot.</p>
    ///
    /// <p>After you restore a DB cluster using a <code>DBClusterSnapshotIdentifier</code>,
    /// you must specify the same <code>DBClusterSnapshotIdentifier</code> for any future
    /// updates to the DB cluster. When you specify this property for an update, the DB
    /// cluster is not restored from the snapshot again, and the data in the database is not
    /// changed.</p>
    ///
    /// <p>However, if you don't specify the <code>DBClusterSnapshotIdentifier</code>, an empty
    /// DB cluster is created, and the original DB cluster is deleted. If you specify a
    /// property that is different from the previous snapshot restore property, the DB
    /// cluster is restored from the snapshot specified by the <code>DBClusterSnapshotIdentifier</code>,
    /// and the original DB cluster is deleted.</p>
    pub db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the DB cluster identifier of the DB cluster that this DB cluster snapshot was
    /// created from.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).</p>
    pub snapshot_create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Specifies the name of the database engine.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>Specifies the allocated storage size in gibibytes (GiB).</p>
    pub allocated_storage: i32,
    /// <p>Specifies the status of this DB cluster snapshot.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Specifies the port that the DB cluster was listening on at the time of the
    /// snapshot.</p>
    pub port: i32,
    /// <p>Provides the VPC ID associated with the DB cluster snapshot.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>Specifies the time when the DB cluster was created, in Universal Coordinated Time
    /// (UTC).</p>
    pub cluster_create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Not supported by Neptune.</p>
    pub master_username: std::option::Option<std::string::String>,
    /// <p>Provides the version of the database engine for this DB cluster snapshot.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Provides the license model information for this DB cluster snapshot.</p>
    pub license_model: std::option::Option<std::string::String>,
    /// <p>Provides the type of the DB cluster snapshot.</p>
    pub snapshot_type: std::option::Option<std::string::String>,
    /// <p>Specifies the percentage of the estimated data that has been transferred.</p>
    pub percent_progress: i32,
    /// <p>Specifies whether the DB cluster snapshot is encrypted.</p>
    pub storage_encrypted: bool,
    /// <p>If <code>StorageEncrypted</code> is true, the Amazon KMS key identifier for the encrypted DB
    /// cluster snapshot.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the DB cluster snapshot.</p>
    pub db_cluster_snapshot_arn: std::option::Option<std::string::String>,
    /// <p>If the DB cluster snapshot was copied from a source DB cluster snapshot, the Amazon
    /// Resource Name (ARN) for the source DB cluster snapshot, otherwise, a null value.</p>
    pub source_db_cluster_snapshot_arn: std::option::Option<std::string::String>,
    /// <p>True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts
    /// is enabled, and otherwise false.</p>
    pub iam_database_authentication_enabled: bool,
}
impl std::fmt::Debug for DbClusterSnapshot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterSnapshot");
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field(
            "db_cluster_snapshot_identifier",
            &self.db_cluster_snapshot_identifier,
        );
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("snapshot_create_time", &self.snapshot_create_time);
        formatter.field("engine", &self.engine);
        formatter.field("allocated_storage", &self.allocated_storage);
        formatter.field("status", &self.status);
        formatter.field("port", &self.port);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("cluster_create_time", &self.cluster_create_time);
        formatter.field("master_username", &self.master_username);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("license_model", &self.license_model);
        formatter.field("snapshot_type", &self.snapshot_type);
        formatter.field("percent_progress", &self.percent_progress);
        formatter.field("storage_encrypted", &self.storage_encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("db_cluster_snapshot_arn", &self.db_cluster_snapshot_arn);
        formatter.field(
            "source_db_cluster_snapshot_arn",
            &self.source_db_cluster_snapshot_arn,
        );
        formatter.field(
            "iam_database_authentication_enabled",
            &self.iam_database_authentication_enabled,
        );
        formatter.finish()
    }
}
/// See [`DbClusterSnapshot`](crate::model::DbClusterSnapshot)
pub mod db_cluster_snapshot {
    /// A builder for [`DbClusterSnapshot`](crate::model::DbClusterSnapshot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) snapshot_create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) allocated_storage: std::option::Option<i32>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) cluster_create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) master_username: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) license_model: std::option::Option<std::string::String>,
        pub(crate) snapshot_type: std::option::Option<std::string::String>,
        pub(crate) percent_progress: std::option::Option<i32>,
        pub(crate) storage_encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) db_cluster_snapshot_arn: std::option::Option<std::string::String>,
        pub(crate) source_db_cluster_snapshot_arn: std::option::Option<std::string::String>,
        pub(crate) iam_database_authentication_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>Provides the list of EC2 Availability Zones that instances in the DB cluster snapshot can
        /// be restored in.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>Provides the list of EC2 Availability Zones that instances in the DB cluster snapshot can
        /// be restored in.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// <p>Specifies the identifier for a DB cluster snapshot. Must match the identifier
        /// of an existing snapshot.</p>
        ///
        /// <p>After you restore a DB cluster using a <code>DBClusterSnapshotIdentifier</code>,
        /// you must specify the same <code>DBClusterSnapshotIdentifier</code> for any future
        /// updates to the DB cluster. When you specify this property for an update, the DB
        /// cluster is not restored from the snapshot again, and the data in the database is not
        /// changed.</p>
        ///
        /// <p>However, if you don't specify the <code>DBClusterSnapshotIdentifier</code>, an empty
        /// DB cluster is created, and the original DB cluster is deleted. If you specify a
        /// property that is different from the previous snapshot restore property, the DB
        /// cluster is restored from the snapshot specified by the <code>DBClusterSnapshotIdentifier</code>,
        /// and the original DB cluster is deleted.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the identifier for a DB cluster snapshot. Must match the identifier
        /// of an existing snapshot.</p>
        ///
        /// <p>After you restore a DB cluster using a <code>DBClusterSnapshotIdentifier</code>,
        /// you must specify the same <code>DBClusterSnapshotIdentifier</code> for any future
        /// updates to the DB cluster. When you specify this property for an update, the DB
        /// cluster is not restored from the snapshot again, and the data in the database is not
        /// changed.</p>
        ///
        /// <p>However, if you don't specify the <code>DBClusterSnapshotIdentifier</code>, an empty
        /// DB cluster is created, and the original DB cluster is deleted. If you specify a
        /// property that is different from the previous snapshot restore property, the DB
        /// cluster is restored from the snapshot specified by the <code>DBClusterSnapshotIdentifier</code>,
        /// and the original DB cluster is deleted.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = input;
            self
        }
        /// <p>Specifies the DB cluster identifier of the DB cluster that this DB cluster snapshot was
        /// created from.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the DB cluster identifier of the DB cluster that this DB cluster snapshot was
        /// created from.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).</p>
        pub fn snapshot_create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.snapshot_create_time = Some(input);
            self
        }
        /// <p>Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).</p>
        pub fn set_snapshot_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.snapshot_create_time = input;
            self
        }
        /// <p>Specifies the name of the database engine.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>Specifies the name of the database engine.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>Specifies the allocated storage size in gibibytes (GiB).</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.allocated_storage = Some(input);
            self
        }
        /// <p>Specifies the allocated storage size in gibibytes (GiB).</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_storage = input;
            self
        }
        /// <p>Specifies the status of this DB cluster snapshot.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Specifies the status of this DB cluster snapshot.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Specifies the port that the DB cluster was listening on at the time of the
        /// snapshot.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Specifies the port that the DB cluster was listening on at the time of the
        /// snapshot.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Provides the VPC ID associated with the DB cluster snapshot.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>Provides the VPC ID associated with the DB cluster snapshot.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>Specifies the time when the DB cluster was created, in Universal Coordinated Time
        /// (UTC).</p>
        pub fn cluster_create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.cluster_create_time = Some(input);
            self
        }
        /// <p>Specifies the time when the DB cluster was created, in Universal Coordinated Time
        /// (UTC).</p>
        pub fn set_cluster_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.cluster_create_time = input;
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_username = Some(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_username = input;
            self
        }
        /// <p>Provides the version of the database engine for this DB cluster snapshot.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>Provides the version of the database engine for this DB cluster snapshot.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Provides the license model information for this DB cluster snapshot.</p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_model = Some(input.into());
            self
        }
        /// <p>Provides the license model information for this DB cluster snapshot.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_model = input;
            self
        }
        /// <p>Provides the type of the DB cluster snapshot.</p>
        pub fn snapshot_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_type = Some(input.into());
            self
        }
        /// <p>Provides the type of the DB cluster snapshot.</p>
        pub fn set_snapshot_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_type = input;
            self
        }
        /// <p>Specifies the percentage of the estimated data that has been transferred.</p>
        pub fn percent_progress(mut self, input: i32) -> Self {
            self.percent_progress = Some(input);
            self
        }
        /// <p>Specifies the percentage of the estimated data that has been transferred.</p>
        pub fn set_percent_progress(mut self, input: std::option::Option<i32>) -> Self {
            self.percent_progress = input;
            self
        }
        /// <p>Specifies whether the DB cluster snapshot is encrypted.</p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.storage_encrypted = Some(input);
            self
        }
        /// <p>Specifies whether the DB cluster snapshot is encrypted.</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_encrypted = input;
            self
        }
        /// <p>If <code>StorageEncrypted</code> is true, the Amazon KMS key identifier for the encrypted DB
        /// cluster snapshot.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>If <code>StorageEncrypted</code> is true, the Amazon KMS key identifier for the encrypted DB
        /// cluster snapshot.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB cluster snapshot.</p>
        pub fn db_cluster_snapshot_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_snapshot_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB cluster snapshot.</p>
        pub fn set_db_cluster_snapshot_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_arn = input;
            self
        }
        /// <p>If the DB cluster snapshot was copied from a source DB cluster snapshot, the Amazon
        /// Resource Name (ARN) for the source DB cluster snapshot, otherwise, a null value.</p>
        pub fn source_db_cluster_snapshot_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_db_cluster_snapshot_arn = Some(input.into());
            self
        }
        /// <p>If the DB cluster snapshot was copied from a source DB cluster snapshot, the Amazon
        /// Resource Name (ARN) for the source DB cluster snapshot, otherwise, a null value.</p>
        pub fn set_source_db_cluster_snapshot_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_db_cluster_snapshot_arn = input;
            self
        }
        /// <p>True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts
        /// is enabled, and otherwise false.</p>
        pub fn iam_database_authentication_enabled(mut self, input: bool) -> Self {
            self.iam_database_authentication_enabled = Some(input);
            self
        }
        /// <p>True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts
        /// is enabled, and otherwise false.</p>
        pub fn set_iam_database_authentication_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.iam_database_authentication_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterSnapshot`](crate::model::DbClusterSnapshot)
        pub fn build(self) -> crate::model::DbClusterSnapshot {
            crate::model::DbClusterSnapshot {
                availability_zones: self.availability_zones,
                db_cluster_snapshot_identifier: self.db_cluster_snapshot_identifier,
                db_cluster_identifier: self.db_cluster_identifier,
                snapshot_create_time: self.snapshot_create_time,
                engine: self.engine,
                allocated_storage: self.allocated_storage.unwrap_or_default(),
                status: self.status,
                port: self.port.unwrap_or_default(),
                vpc_id: self.vpc_id,
                cluster_create_time: self.cluster_create_time,
                master_username: self.master_username,
                engine_version: self.engine_version,
                license_model: self.license_model,
                snapshot_type: self.snapshot_type,
                percent_progress: self.percent_progress.unwrap_or_default(),
                storage_encrypted: self.storage_encrypted.unwrap_or_default(),
                kms_key_id: self.kms_key_id,
                db_cluster_snapshot_arn: self.db_cluster_snapshot_arn,
                source_db_cluster_snapshot_arn: self.source_db_cluster_snapshot_arn,
                iam_database_authentication_enabled: self
                    .iam_database_authentication_enabled
                    .unwrap_or_default(),
            }
        }
    }
}
impl DbClusterSnapshot {
    /// Creates a new builder-style object to manufacture [`DbClusterSnapshot`](crate::model::DbClusterSnapshot)
    pub fn builder() -> crate::model::db_cluster_snapshot::Builder {
        crate::model::db_cluster_snapshot::Builder::default()
    }
}

/// <p>Contains the details of an Amazon Neptune DB cluster parameter group.</p>
/// <p>This data type is used as a response element in the <a>DescribeDBClusterParameterGroups</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterParameterGroup {
    /// <p>Provides the name of the DB cluster parameter group.</p>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>Provides the name of the DB parameter group family that this DB cluster parameter group is
    /// compatible with.</p>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>Provides the customer-specified description for this DB cluster parameter group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the DB cluster parameter group.</p>
    pub db_cluster_parameter_group_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterParameterGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterParameterGroup");
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("description", &self.description);
        formatter.field(
            "db_cluster_parameter_group_arn",
            &self.db_cluster_parameter_group_arn,
        );
        formatter.finish()
    }
}
/// See [`DbClusterParameterGroup`](crate::model::DbClusterParameterGroup)
pub mod db_cluster_parameter_group {
    /// A builder for [`DbClusterParameterGroup`](crate::model::DbClusterParameterGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) db_cluster_parameter_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Provides the name of the DB cluster parameter group.</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>Provides the name of the DB cluster parameter group.</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// <p>Provides the name of the DB parameter group family that this DB cluster parameter group is
        /// compatible with.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>Provides the name of the DB parameter group family that this DB cluster parameter group is
        /// compatible with.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// <p>Provides the customer-specified description for this DB cluster parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Provides the customer-specified description for this DB cluster parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB cluster parameter group.</p>
        pub fn db_cluster_parameter_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB cluster parameter group.</p>
        pub fn set_db_cluster_parameter_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterParameterGroup`](crate::model::DbClusterParameterGroup)
        pub fn build(self) -> crate::model::DbClusterParameterGroup {
            crate::model::DbClusterParameterGroup {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                db_parameter_group_family: self.db_parameter_group_family,
                description: self.description,
                db_cluster_parameter_group_arn: self.db_cluster_parameter_group_arn,
            }
        }
    }
}
impl DbClusterParameterGroup {
    /// Creates a new builder-style object to manufacture [`DbClusterParameterGroup`](crate::model::DbClusterParameterGroup)
    pub fn builder() -> crate::model::db_cluster_parameter_group::Builder {
        crate::model::db_cluster_parameter_group::Builder::default()
    }
}

/// <p>This data type represents the information you need to connect to an Amazon Neptune DB cluster.
/// This data type is used as a response element in the following actions:</p>
/// <ul>
/// <li>
/// <p>
/// <code>CreateDBClusterEndpoint</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>DescribeDBClusterEndpoints</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>ModifyDBClusterEndpoint</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>DeleteDBClusterEndpoint</code>
/// </p>
/// </li>
/// </ul>
/// <p>For the data structure that represents Amazon Neptune DB instance endpoints,
/// see <code>Endpoint</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterEndpoint {
    /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
    /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
    /// stored as a lowercase string.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    pub db_cluster_endpoint_resource_identifier: std::option::Option<std::string::String>,
    /// <p>The DNS address of the endpoint.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster,
    /// such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    pub endpoint_type: std::option::Option<std::string::String>,
    /// <p>The type associated with a custom endpoint. One of: <code>READER</code>,
    /// <code>WRITER</code>, <code>ANY</code>.</p>
    pub custom_endpoint_type: std::option::Option<std::string::String>,
    /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    pub static_members: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
    /// All other eligible instances are reachable through the custom endpoint.
    /// Only relevant if the list of static members is empty.</p>
    pub excluded_members: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    pub db_cluster_endpoint_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterEndpoint");
        formatter.field(
            "db_cluster_endpoint_identifier",
            &self.db_cluster_endpoint_identifier,
        );
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field(
            "db_cluster_endpoint_resource_identifier",
            &self.db_cluster_endpoint_resource_identifier,
        );
        formatter.field("endpoint", &self.endpoint);
        formatter.field("status", &self.status);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("custom_endpoint_type", &self.custom_endpoint_type);
        formatter.field("static_members", &self.static_members);
        formatter.field("excluded_members", &self.excluded_members);
        formatter.field("db_cluster_endpoint_arn", &self.db_cluster_endpoint_arn);
        formatter.finish()
    }
}
/// See [`DbClusterEndpoint`](crate::model::DbClusterEndpoint)
pub mod db_cluster_endpoint {
    /// A builder for [`DbClusterEndpoint`](crate::model::DbClusterEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_endpoint_resource_identifier:
            std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<std::string::String>,
        pub(crate) custom_endpoint_type: std::option::Option<std::string::String>,
        pub(crate) static_members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) excluded_members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_cluster_endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = Some(input.into());
            self
        }
        /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = input;
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
        pub fn db_cluster_endpoint_resource_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_resource_identifier = Some(input.into());
            self
        }
        /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
        pub fn set_db_cluster_endpoint_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_resource_identifier = input;
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster,
        /// such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster,
        /// such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
        pub fn endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_type = Some(input.into());
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The type associated with a custom endpoint. One of: <code>READER</code>,
        /// <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn custom_endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_endpoint_type = Some(input.into());
            self
        }
        /// <p>The type associated with a custom endpoint. One of: <code>READER</code>,
        /// <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn set_custom_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_endpoint_type = input;
            self
        }
        /// Appends an item to `static_members`.
        ///
        /// To override the contents of this collection use [`set_static_members`](Self::set_static_members).
        ///
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn static_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.static_members.unwrap_or_default();
            v.push(input.into());
            self.static_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn set_static_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.static_members = input;
            self
        }
        /// Appends an item to `excluded_members`.
        ///
        /// To override the contents of this collection use [`set_excluded_members`](Self::set_excluded_members).
        ///
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
        /// All other eligible instances are reachable through the custom endpoint.
        /// Only relevant if the list of static members is empty.</p>
        pub fn excluded_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.excluded_members.unwrap_or_default();
            v.push(input.into());
            self.excluded_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
        /// All other eligible instances are reachable through the custom endpoint.
        /// Only relevant if the list of static members is empty.</p>
        pub fn set_excluded_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.excluded_members = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
        pub fn db_cluster_endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
        pub fn set_db_cluster_endpoint_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterEndpoint`](crate::model::DbClusterEndpoint)
        pub fn build(self) -> crate::model::DbClusterEndpoint {
            crate::model::DbClusterEndpoint {
                db_cluster_endpoint_identifier: self.db_cluster_endpoint_identifier,
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_endpoint_resource_identifier: self
                    .db_cluster_endpoint_resource_identifier,
                endpoint: self.endpoint,
                status: self.status,
                endpoint_type: self.endpoint_type,
                custom_endpoint_type: self.custom_endpoint_type,
                static_members: self.static_members,
                excluded_members: self.excluded_members,
                db_cluster_endpoint_arn: self.db_cluster_endpoint_arn,
            }
        }
    }
}
impl DbClusterEndpoint {
    /// Creates a new builder-style object to manufacture [`DbClusterEndpoint`](crate::model::DbClusterEndpoint)
    pub fn builder() -> crate::model::db_cluster_endpoint::Builder {
        crate::model::db_cluster_endpoint::Builder::default()
    }
}
