// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>Specified CIDRIP or EC2 security group is not authorized for the specified DB security group.</p>
    /// <p>Neptune may not also be authorized via IAM to perform necessary actions on your behalf.</p>
    AuthorizationNotFoundFault(crate::error::AuthorizationNotFoundFault),
    /// <p>
    /// <i>CertificateIdentifier</i> does not refer to an existing certificate.</p>
    CertificateNotFoundFault(crate::error::CertificateNotFoundFault),
    /// <p>User already has a DB cluster with the given identifier.</p>
    DbClusterAlreadyExistsFault(crate::error::DbClusterAlreadyExistsFault),
    /// <p>The specified custom endpoint cannot be created because it already exists.</p>
    DbClusterEndpointAlreadyExistsFault(crate::error::DbClusterEndpointAlreadyExistsFault),
    /// <p>The specified custom endpoint doesn't exist.</p>
    DbClusterEndpointNotFoundFault(crate::error::DbClusterEndpointNotFoundFault),
    /// <p>The cluster already has the maximum number of custom endpoints.</p>
    DbClusterEndpointQuotaExceededFault(crate::error::DbClusterEndpointQuotaExceededFault),
    /// <p>
    /// <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>
    /// <i>DBClusterParameterGroupName</i> does not refer to an
    /// existing DB Cluster parameter group.</p>
    DbClusterParameterGroupNotFoundFault(crate::error::DbClusterParameterGroupNotFoundFault),
    /// <p>User attempted to create a new DB cluster and the user has already reached the maximum allowed DB cluster quota.</p>
    DbClusterQuotaExceededFault(crate::error::DbClusterQuotaExceededFault),
    /// <p>The specified IAM role Amazon Resource Name (ARN) is already associated with the specified DB cluster.</p>
    DbClusterRoleAlreadyExistsFault(crate::error::DbClusterRoleAlreadyExistsFault),
    /// <p>The specified IAM role Amazon Resource Name (ARN) is not associated with the specified DB cluster.</p>
    DbClusterRoleNotFoundFault(crate::error::DbClusterRoleNotFoundFault),
    /// <p>You have exceeded the maximum number of IAM roles that can be associated with the specified DB cluster.</p>
    DbClusterRoleQuotaExceededFault(crate::error::DbClusterRoleQuotaExceededFault),
    /// <p>User already has a DB cluster snapshot with the given identifier.</p>
    DbClusterSnapshotAlreadyExistsFault(crate::error::DbClusterSnapshotAlreadyExistsFault),
    /// <p>
    /// <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
    /// DB cluster snapshot.</p>
    DbClusterSnapshotNotFoundFault(crate::error::DbClusterSnapshotNotFoundFault),
    /// <p>User already has a DB instance with the given identifier.</p>
    DbInstanceAlreadyExistsFault(crate::error::DbInstanceAlreadyExistsFault),
    /// <p>
    /// <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>A DB parameter group with the same name exists.</p>
    DbParameterGroupAlreadyExistsFault(crate::error::DbParameterGroupAlreadyExistsFault),
    /// <p>
    /// <i>DBParameterGroupName</i> does not refer to an
    /// existing DB parameter group.</p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p>Request would result in user exceeding the allowed number of DB parameter groups.</p>
    DbParameterGroupQuotaExceededFault(crate::error::DbParameterGroupQuotaExceededFault),
    /// <p>
    /// <i>DBSecurityGroupName</i> does not refer
    /// to an existing DB security group.</p>
    DbSecurityGroupNotFoundFault(crate::error::DbSecurityGroupNotFoundFault),
    /// <p>
    /// <i>DBSnapshotIdentifier</i> is already used by an existing snapshot.</p>
    DbSnapshotAlreadyExistsFault(crate::error::DbSnapshotAlreadyExistsFault),
    /// <p>
    /// <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</p>
    DbSnapshotNotFoundFault(crate::error::DbSnapshotNotFoundFault),
    /// <p>
    /// <i>DBSubnetGroupName</i> is already used by an existing DB subnet group.</p>
    DbSubnetGroupAlreadyExistsFault(crate::error::DbSubnetGroupAlreadyExistsFault),
    /// <p>Subnets in the DB subnet group should cover at least two Availability
    /// Zones unless there is only one Availability Zone.</p>
    DbSubnetGroupDoesNotCoverEnoughAZs(crate::error::DbSubnetGroupDoesNotCoverEnoughAZs),
    /// <p>
    /// <i>DBSubnetGroupName</i> does not refer to an
    /// existing DB subnet group.</p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p>Request would result in user exceeding the allowed number of DB subnet groups.</p>
    DbSubnetGroupQuotaExceededFault(crate::error::DbSubnetGroupQuotaExceededFault),
    /// <p>Request would result in user exceeding the allowed number of subnets in a DB subnet groups.</p>
    DbSubnetQuotaExceededFault(crate::error::DbSubnetQuotaExceededFault),
    /// <p>The DB upgrade failed because a resource the DB depends on could not be modified.</p>
    DbUpgradeDependencyFailureFault(crate::error::DbUpgradeDependencyFailureFault),
    /// <p>
    /// <i>Domain</i> does not refer to an existing Active Directory Domain.</p>
    DomainNotFoundFault(crate::error::DomainNotFoundFault),
    /// <p>You have exceeded the number of events you can subscribe to.</p>
    EventSubscriptionQuotaExceededFault(crate::error::EventSubscriptionQuotaExceededFault),
    /// <p>Request would result in user exceeding the allowed number of DB instances.</p>
    InstanceQuotaExceededFault(crate::error::InstanceQuotaExceededFault),
    /// <p>The DB cluster does not have enough capacity for the current operation.</p>
    InsufficientDbClusterCapacityFault(crate::error::InsufficientDbClusterCapacityFault),
    /// <p>Specified DB instance class is not available in the specified Availability Zone.</p>
    InsufficientDbInstanceCapacityFault(crate::error::InsufficientDbInstanceCapacityFault),
    /// <p>There is insufficient storage available for the current action. You may
    /// be able to resolve this error by updating your subnet group to use different
    /// Availability Zones that have more storage available.</p>
    InsufficientStorageClusterCapacityFault(crate::error::InsufficientStorageClusterCapacityFault),
    /// <p>The requested operation cannot be performed on the endpoint while the endpoint is in this state.</p>
    InvalidDbClusterEndpointStateFault(crate::error::InvalidDbClusterEndpointStateFault),
    /// <p>The supplied value is not a valid DB cluster snapshot state.</p>
    InvalidDbClusterSnapshotStateFault(crate::error::InvalidDbClusterSnapshotStateFault),
    /// <p>The DB cluster is not in a valid state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The specified DB instance is not in the <i>available</i> state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>The DB parameter group is in use or is in an invalid state. If you are attempting to
    /// delete the parameter group, you cannot delete it when the parameter group is in this state.</p>
    InvalidDbParameterGroupStateFault(crate::error::InvalidDbParameterGroupStateFault),
    /// <p>The state of the DB security group does not allow deletion.</p>
    InvalidDbSecurityGroupStateFault(crate::error::InvalidDbSecurityGroupStateFault),
    /// <p>The state of the DB snapshot does not allow deletion.</p>
    InvalidDbSnapshotStateFault(crate::error::InvalidDbSnapshotStateFault),
    /// <p>The DB subnet group cannot be deleted because it is in use.</p>
    InvalidDbSubnetGroupStateFault(crate::error::InvalidDbSubnetGroupStateFault),
    /// <p>The DB subnet is not in the <i>available</i> state.</p>
    InvalidDbSubnetStateFault(crate::error::InvalidDbSubnetStateFault),
    /// <p>The event subscription is in an invalid state.</p>
    InvalidEventSubscriptionStateFault(crate::error::InvalidEventSubscriptionStateFault),
    /// <p>Cannot restore from vpc backup to non-vpc DB instance.</p>
    InvalidRestoreFault(crate::error::InvalidRestoreFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are
    /// not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>DB subnet group does not cover all Availability Zones after it is created
    /// because users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>Error accessing KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The designated option group could not be found.</p>
    OptionGroupNotFoundFault(crate::error::OptionGroupNotFoundFault),
    /// <p>Provisioned IOPS not available in the specified Availability Zone.</p>
    ProvisionedIopsNotAvailableInAzFault(crate::error::ProvisionedIopsNotAvailableInAzFault),
    /// <p>The specified resource ID was not found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// <p>The SNS topic is invalid.</p>
    SnsInvalidTopicFault(crate::error::SnsInvalidTopicFault),
    /// <p>There is no SNS authorization.</p>
    SnsNoAuthorizationFault(crate::error::SnsNoAuthorizationFault),
    /// <p>The ARN of the SNS topic could not be found.</p>
    SnsTopicArnNotFoundFault(crate::error::SnsTopicArnNotFoundFault),
    /// <p>You have exceeded the maximum number of accounts that you can share a manual DB snapshot with.</p>
    SharedSnapshotQuotaExceededFault(crate::error::SharedSnapshotQuotaExceededFault),
    /// <p>Request would result in user exceeding the allowed number of DB snapshots.</p>
    SnapshotQuotaExceededFault(crate::error::SnapshotQuotaExceededFault),
    /// <p>The source could not be found.</p>
    SourceNotFoundFault(crate::error::SourceNotFoundFault),
    /// <p>Request would result in user exceeding the allowed amount of storage available across all DB instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// <p>
    /// <i>StorageType</i> specified cannot be associated with the DB Instance.</p>
    StorageTypeNotSupportedFault(crate::error::StorageTypeNotSupportedFault),
    /// <p>The DB subnet is already in use in the Availability Zone.</p>
    SubnetAlreadyInUse(crate::error::SubnetAlreadyInUse),
    /// <p>This subscription already exists.</p>
    SubscriptionAlreadyExistFault(crate::error::SubscriptionAlreadyExistFault),
    /// <p>The designated subscription category could not be found.</p>
    SubscriptionCategoryNotFoundFault(crate::error::SubscriptionCategoryNotFoundFault),
    /// <p>The designated subscription could not be found.</p>
    SubscriptionNotFoundFault(crate::error::SubscriptionNotFoundFault),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AuthorizationNotFoundFault(inner) => inner.fmt(f),
            Error::CertificateNotFoundFault(inner) => inner.fmt(f),
            Error::DbClusterAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbClusterEndpointAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbClusterEndpointNotFoundFault(inner) => inner.fmt(f),
            Error::DbClusterEndpointQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbClusterNotFoundFault(inner) => inner.fmt(f),
            Error::DbClusterParameterGroupNotFoundFault(inner) => inner.fmt(f),
            Error::DbClusterQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbClusterRoleAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbClusterRoleNotFoundFault(inner) => inner.fmt(f),
            Error::DbClusterRoleQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbClusterSnapshotAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbClusterSnapshotNotFoundFault(inner) => inner.fmt(f),
            Error::DbInstanceAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbInstanceNotFoundFault(inner) => inner.fmt(f),
            Error::DbParameterGroupAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbParameterGroupNotFoundFault(inner) => inner.fmt(f),
            Error::DbParameterGroupQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbSecurityGroupNotFoundFault(inner) => inner.fmt(f),
            Error::DbSnapshotAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbSnapshotNotFoundFault(inner) => inner.fmt(f),
            Error::DbSubnetGroupAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner) => inner.fmt(f),
            Error::DbSubnetGroupNotFoundFault(inner) => inner.fmt(f),
            Error::DbSubnetGroupQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbSubnetQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbUpgradeDependencyFailureFault(inner) => inner.fmt(f),
            Error::DomainNotFoundFault(inner) => inner.fmt(f),
            Error::EventSubscriptionQuotaExceededFault(inner) => inner.fmt(f),
            Error::InstanceQuotaExceededFault(inner) => inner.fmt(f),
            Error::InsufficientDbClusterCapacityFault(inner) => inner.fmt(f),
            Error::InsufficientDbInstanceCapacityFault(inner) => inner.fmt(f),
            Error::InsufficientStorageClusterCapacityFault(inner) => inner.fmt(f),
            Error::InvalidDbClusterEndpointStateFault(inner) => inner.fmt(f),
            Error::InvalidDbClusterSnapshotStateFault(inner) => inner.fmt(f),
            Error::InvalidDbClusterStateFault(inner) => inner.fmt(f),
            Error::InvalidDbInstanceStateFault(inner) => inner.fmt(f),
            Error::InvalidDbParameterGroupStateFault(inner) => inner.fmt(f),
            Error::InvalidDbSecurityGroupStateFault(inner) => inner.fmt(f),
            Error::InvalidDbSnapshotStateFault(inner) => inner.fmt(f),
            Error::InvalidDbSubnetGroupStateFault(inner) => inner.fmt(f),
            Error::InvalidDbSubnetStateFault(inner) => inner.fmt(f),
            Error::InvalidEventSubscriptionStateFault(inner) => inner.fmt(f),
            Error::InvalidRestoreFault(inner) => inner.fmt(f),
            Error::InvalidSubnet(inner) => inner.fmt(f),
            Error::InvalidVpcNetworkStateFault(inner) => inner.fmt(f),
            Error::KmsKeyNotAccessibleFault(inner) => inner.fmt(f),
            Error::OptionGroupNotFoundFault(inner) => inner.fmt(f),
            Error::ProvisionedIopsNotAvailableInAzFault(inner) => inner.fmt(f),
            Error::ResourceNotFoundFault(inner) => inner.fmt(f),
            Error::SnsInvalidTopicFault(inner) => inner.fmt(f),
            Error::SnsNoAuthorizationFault(inner) => inner.fmt(f),
            Error::SnsTopicArnNotFoundFault(inner) => inner.fmt(f),
            Error::SharedSnapshotQuotaExceededFault(inner) => inner.fmt(f),
            Error::SnapshotQuotaExceededFault(inner) => inner.fmt(f),
            Error::SourceNotFoundFault(inner) => inner.fmt(f),
            Error::StorageQuotaExceededFault(inner) => inner.fmt(f),
            Error::StorageTypeNotSupportedFault(inner) => inner.fmt(f),
            Error::SubnetAlreadyInUse(inner) => inner.fmt(f),
            Error::SubscriptionAlreadyExistFault(inner) => inner.fmt(f),
            Error::SubscriptionCategoryNotFoundFault(inner) => inner.fmt(f),
            Error::SubscriptionNotFoundFault(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddRoleToDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AddRoleToDBClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddRoleToDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::AddRoleToDBClusterErrorKind::DbClusterRoleAlreadyExistsFault(
                    inner,
                ) => Error::DbClusterRoleAlreadyExistsFault(inner),
                crate::error::AddRoleToDBClusterErrorKind::DbClusterRoleQuotaExceededFault(
                    inner,
                ) => Error::DbClusterRoleQuotaExceededFault(inner),
                crate::error::AddRoleToDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::AddRoleToDBClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::AddSourceIdentifierToSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AddSourceIdentifierToSubscriptionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AddSourceIdentifierToSubscriptionErrorKind::SourceNotFoundFault(inner) => Error::SourceNotFoundFault(inner),
                crate::error::AddSourceIdentifierToSubscriptionErrorKind::SubscriptionNotFoundFault(inner) => Error::SubscriptionNotFoundFault(inner),
                crate::error::AddSourceIdentifierToSubscriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddTagsToResourceErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::AddTagsToResourceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::AddTagsToResourceErrorKind::DbSnapshotNotFoundFault(inner) => {
                    Error::DbSnapshotNotFoundFault(inner)
                }
                crate::error::AddTagsToResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ApplyPendingMaintenanceActionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ApplyPendingMaintenanceActionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ApplyPendingMaintenanceActionErrorKind::ResourceNotFoundFault(
                    inner,
                ) => Error::ResourceNotFoundFault(inner),
                crate::error::ApplyPendingMaintenanceActionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CopyDBClusterParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CopyDBClusterParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CopyDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(inner) => Error::DbParameterGroupAlreadyExistsFault(inner),
                crate::error::CopyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::CopyDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(inner) => Error::DbParameterGroupQuotaExceededFault(inner),
                crate::error::CopyDBClusterParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CopyDBClusterSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CopyDBClusterSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CopyDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(inner) => Error::DbClusterSnapshotAlreadyExistsFault(inner),
                crate::error::CopyDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::CopyDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(inner) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::CopyDBClusterSnapshotErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::CopyDBClusterSnapshotErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::CopyDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault(inner) => Error::SnapshotQuotaExceededFault(inner),
                crate::error::CopyDBClusterSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CopyDBParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CopyDBParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CopyDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(
                    inner,
                ) => Error::DbParameterGroupAlreadyExistsFault(inner),
                crate::error::CopyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(
                    inner,
                ) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::CopyDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(
                    inner,
                ) => Error::DbParameterGroupQuotaExceededFault(inner),
                crate::error::CopyDBParameterGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateDBClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDBClusterErrorKind::DbClusterAlreadyExistsFault(inner) => {
                    Error::DbClusterAlreadyExistsFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::DbClusterParameterGroupNotFoundFault(
                    inner,
                ) => Error::DbClusterParameterGroupNotFoundFault(inner),
                crate::error::CreateDBClusterErrorKind::DbClusterQuotaExceededFault(inner) => {
                    Error::DbClusterQuotaExceededFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(
                    inner,
                ) => Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::CreateDBClusterErrorKind::DbSubnetGroupNotFoundFault(inner) => {
                    Error::DbSubnetGroupNotFoundFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::InsufficientStorageClusterCapacityFault(
                    inner,
                ) => Error::InsufficientStorageClusterCapacityFault(inner),
                crate::error::CreateDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::InvalidDbSubnetGroupStateFault(inner) => {
                    Error::InvalidDbSubnetGroupStateFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::CreateDBClusterErrorKind::InvalidVpcNetworkStateFault(inner) => {
                    Error::InvalidVpcNetworkStateFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::KmsKeyNotAccessibleFault(inner) => {
                    Error::KmsKeyNotAccessibleFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::StorageQuotaExceededFault(inner) => {
                    Error::StorageQuotaExceededFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBClusterEndpointError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBClusterEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDBClusterEndpointErrorKind::DbClusterEndpointAlreadyExistsFault(inner) => Error::DbClusterEndpointAlreadyExistsFault(inner),
                crate::error::CreateDBClusterEndpointErrorKind::DbClusterEndpointQuotaExceededFault(inner) => Error::DbClusterEndpointQuotaExceededFault(inner),
                crate::error::CreateDBClusterEndpointErrorKind::DbClusterNotFoundFault(inner) => Error::DbClusterNotFoundFault(inner),
                crate::error::CreateDBClusterEndpointErrorKind::DbInstanceNotFoundFault(inner) => Error::DbInstanceNotFoundFault(inner),
                crate::error::CreateDBClusterEndpointErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::CreateDBClusterEndpointErrorKind::InvalidDbInstanceStateFault(inner) => Error::InvalidDbInstanceStateFault(inner),
                crate::error::CreateDBClusterEndpointErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBClusterParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBClusterParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(inner) => Error::DbParameterGroupAlreadyExistsFault(inner),
                crate::error::CreateDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(inner) => Error::DbParameterGroupQuotaExceededFault(inner),
                crate::error::CreateDBClusterParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBClusterSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBClusterSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDBClusterSnapshotErrorKind::DbClusterNotFoundFault(inner) => Error::DbClusterNotFoundFault(inner),
                crate::error::CreateDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(inner) => Error::DbClusterSnapshotAlreadyExistsFault(inner),
                crate::error::CreateDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(inner) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::CreateDBClusterSnapshotErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::CreateDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault(inner) => Error::SnapshotQuotaExceededFault(inner),
                crate::error::CreateDBClusterSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDBInstanceErrorKind::AuthorizationNotFoundFault(inner) => {
                    Error::AuthorizationNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::DbInstanceAlreadyExistsFault(inner) => {
                    Error::DbInstanceAlreadyExistsFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::DbParameterGroupNotFoundFault(inner) => {
                    Error::DbParameterGroupNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::DbSecurityGroupNotFoundFault(inner) => {
                    Error::DbSecurityGroupNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(
                    inner,
                ) => Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::CreateDBInstanceErrorKind::DbSubnetGroupNotFoundFault(inner) => {
                    Error::DbSubnetGroupNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::DomainNotFoundFault(inner) => {
                    Error::DomainNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::InstanceQuotaExceededFault(inner) => {
                    Error::InstanceQuotaExceededFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(
                    inner,
                ) => Error::InsufficientDbInstanceCapacityFault(inner),
                crate::error::CreateDBInstanceErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::CreateDBInstanceErrorKind::InvalidVpcNetworkStateFault(inner) => {
                    Error::InvalidVpcNetworkStateFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::KmsKeyNotAccessibleFault(inner) => {
                    Error::KmsKeyNotAccessibleFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::OptionGroupNotFoundFault(inner) => {
                    Error::OptionGroupNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault(
                    inner,
                ) => Error::ProvisionedIopsNotAvailableInAzFault(inner),
                crate::error::CreateDBInstanceErrorKind::StorageQuotaExceededFault(inner) => {
                    Error::StorageQuotaExceededFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::StorageTypeNotSupportedFault(inner) => {
                    Error::StorageTypeNotSupportedFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(inner) => Error::DbParameterGroupAlreadyExistsFault(inner),
                crate::error::CreateDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(inner) => Error::DbParameterGroupQuotaExceededFault(inner),
                crate::error::CreateDBParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBSubnetGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDBSubnetGroupErrorKind::DbSubnetGroupAlreadyExistsFault(
                    inner,
                ) => Error::DbSubnetGroupAlreadyExistsFault(inner),
                crate::error::CreateDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(
                    inner,
                ) => Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::CreateDBSubnetGroupErrorKind::DbSubnetGroupQuotaExceededFault(
                    inner,
                ) => Error::DbSubnetGroupQuotaExceededFault(inner),
                crate::error::CreateDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault(inner) => {
                    Error::DbSubnetQuotaExceededFault(inner)
                }
                crate::error::CreateDBSubnetGroupErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::CreateDBSubnetGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateEventSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateEventSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(inner) => Error::EventSubscriptionQuotaExceededFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SnsInvalidTopicFault(inner) => Error::SnsInvalidTopicFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault(inner) => Error::SnsNoAuthorizationFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(inner) => Error::SnsTopicArnNotFoundFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SourceNotFoundFault(inner) => Error::SourceNotFoundFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SubscriptionAlreadyExistFault(inner) => Error::SubscriptionAlreadyExistFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(inner) => Error::SubscriptionCategoryNotFoundFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::DeleteDBClusterErrorKind::DbClusterSnapshotAlreadyExistsFault(
                    inner,
                ) => Error::DbClusterSnapshotAlreadyExistsFault(inner),
                crate::error::DeleteDBClusterErrorKind::InvalidDbClusterSnapshotStateFault(
                    inner,
                ) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::DeleteDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::DeleteDBClusterErrorKind::SnapshotQuotaExceededFault(inner) => {
                    Error::SnapshotQuotaExceededFault(inner)
                }
                crate::error::DeleteDBClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterEndpointError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault(inner) => Error::DbClusterEndpointNotFoundFault(inner),
                crate::error::DeleteDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault(inner) => Error::InvalidDbClusterEndpointStateFault(inner),
                crate::error::DeleteDBClusterEndpointErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::DeleteDBClusterEndpointErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::DeleteDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(inner) => Error::InvalidDbParameterGroupStateFault(inner),
                crate::error::DeleteDBClusterParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::DeleteDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(inner) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::DeleteDBClusterSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDBInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDBInstanceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::DeleteDBInstanceErrorKind::DbSnapshotAlreadyExistsFault(inner) => {
                    Error::DbSnapshotAlreadyExistsFault(inner)
                }
                crate::error::DeleteDBInstanceErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::DeleteDBInstanceErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::DeleteDBInstanceErrorKind::SnapshotQuotaExceededFault(inner) => {
                    Error::SnapshotQuotaExceededFault(inner)
                }
                crate::error::DeleteDBInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDBParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::DeleteDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(inner) => Error::InvalidDbParameterGroupStateFault(inner),
                crate::error::DeleteDBParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBSubnetGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDBSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault(inner) => {
                    Error::DbSubnetGroupNotFoundFault(inner)
                }
                crate::error::DeleteDBSubnetGroupErrorKind::InvalidDbSubnetGroupStateFault(
                    inner,
                ) => Error::InvalidDbSubnetGroupStateFault(inner),
                crate::error::DeleteDBSubnetGroupErrorKind::InvalidDbSubnetStateFault(inner) => {
                    Error::InvalidDbSubnetStateFault(inner)
                }
                crate::error::DeleteDBSubnetGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteEventSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteEventSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteEventSubscriptionErrorKind::InvalidEventSubscriptionStateFault(inner) => Error::InvalidEventSubscriptionStateFault(inner),
                crate::error::DeleteEventSubscriptionErrorKind::SubscriptionNotFoundFault(inner) => Error::SubscriptionNotFoundFault(inner),
                crate::error::DeleteEventSubscriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterEndpointsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterEndpointsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBClusterEndpointsErrorKind::DbClusterNotFoundFault(
                    inner,
                ) => Error::DbClusterNotFoundFault(inner),
                crate::error::DescribeDBClusterEndpointsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterParameterGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeDBClusterParameterGroupsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDBClusterParameterGroupsErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::DescribeDBClusterParameterGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterParametersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterParametersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDBClusterParametersErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::DescribeDBClusterParametersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBClustersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBClustersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBClustersErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::DescribeDBClustersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeDBClusterSnapshotAttributesError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeDBClusterSnapshotAttributesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDBClusterSnapshotAttributesErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::DescribeDBClusterSnapshotAttributesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterSnapshotsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterSnapshotsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDBClusterSnapshotsErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::DescribeDBClusterSnapshotsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBEngineVersionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBEngineVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBEngineVersionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBInstancesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBInstancesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBInstancesErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::DescribeDBInstancesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBParameterGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBParameterGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBParameterGroupsErrorKind::DbParameterGroupNotFoundFault(
                    inner,
                ) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::DescribeDBParameterGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBParametersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBParametersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBParametersErrorKind::DbParameterGroupNotFoundFault(
                    inner,
                ) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::DescribeDBParametersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBSubnetGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBSubnetGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBSubnetGroupsErrorKind::DbSubnetGroupNotFoundFault(
                    inner,
                ) => Error::DbSubnetGroupNotFoundFault(inner),
                crate::error::DescribeDBSubnetGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeEngineDefaultClusterParametersError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeEngineDefaultClusterParametersError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEngineDefaultClusterParametersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeEngineDefaultParametersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeEngineDefaultParametersError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEngineDefaultParametersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEventCategoriesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEventCategoriesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEventCategoriesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEventsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeEventsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEventsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEventSubscriptionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEventSubscriptionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEventSubscriptionsErrorKind::SubscriptionNotFoundFault(
                    inner,
                ) => Error::SubscriptionNotFoundFault(inner),
                crate::error::DescribeEventSubscriptionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::DescribeOrderableDBInstanceOptionsError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeOrderableDBInstanceOptionsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeOrderableDBInstanceOptionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribePendingMaintenanceActionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribePendingMaintenanceActionsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribePendingMaintenanceActionsErrorKind::ResourceNotFoundFault(
                    inner,
                ) => Error::ResourceNotFoundFault(inner),
                crate::error::DescribePendingMaintenanceActionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeValidDBInstanceModificationsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeValidDBInstanceModificationsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeValidDBInstanceModificationsErrorKind::DbInstanceNotFoundFault(inner) => Error::DbInstanceNotFoundFault(inner),
                crate::error::DescribeValidDBInstanceModificationsErrorKind::InvalidDbInstanceStateFault(inner) => Error::InvalidDbInstanceStateFault(inner),
                crate::error::DescribeValidDBInstanceModificationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::FailoverDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::FailoverDBClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::FailoverDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::FailoverDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::FailoverDBClusterErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::FailoverDBClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::ListTagsForResourceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::ListTagsForResourceErrorKind::DbSnapshotNotFoundFault(inner) => {
                    Error::DbSnapshotNotFoundFault(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyDBClusterErrorKind::DbClusterAlreadyExistsFault(inner) => {
                    Error::DbClusterAlreadyExistsFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::DbClusterParameterGroupNotFoundFault(
                    inner,
                ) => Error::DbClusterParameterGroupNotFoundFault(inner),
                crate::error::ModifyDBClusterErrorKind::DbSubnetGroupNotFoundFault(inner) => {
                    Error::DbSubnetGroupNotFoundFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::InvalidDbSecurityGroupStateFault(inner) => {
                    Error::InvalidDbSecurityGroupStateFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::InvalidDbSubnetGroupStateFault(inner) => {
                    Error::InvalidDbSubnetGroupStateFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::ModifyDBClusterErrorKind::InvalidVpcNetworkStateFault(inner) => {
                    Error::InvalidVpcNetworkStateFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::StorageQuotaExceededFault(inner) => {
                    Error::StorageQuotaExceededFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterEndpointError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault(inner) => Error::DbClusterEndpointNotFoundFault(inner),
                crate::error::ModifyDBClusterEndpointErrorKind::DbInstanceNotFoundFault(inner) => Error::DbInstanceNotFoundFault(inner),
                crate::error::ModifyDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault(inner) => Error::InvalidDbClusterEndpointStateFault(inner),
                crate::error::ModifyDBClusterEndpointErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::ModifyDBClusterEndpointErrorKind::InvalidDbInstanceStateFault(inner) => Error::InvalidDbInstanceStateFault(inner),
                crate::error::ModifyDBClusterEndpointErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::ModifyDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(inner) => Error::InvalidDbParameterGroupStateFault(inner),
                crate::error::ModifyDBClusterParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterSnapshotAttributeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ModifyDBClusterSnapshotAttributeError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyDBClusterSnapshotAttributeErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::ModifyDBClusterSnapshotAttributeErrorKind::InvalidDbClusterSnapshotStateFault(inner) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::ModifyDBClusterSnapshotAttributeErrorKind::SharedSnapshotQuotaExceededFault(inner) => Error::SharedSnapshotQuotaExceededFault(inner),
                crate::error::ModifyDBClusterSnapshotAttributeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyDBInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyDBInstanceErrorKind::AuthorizationNotFoundFault(inner) => {
                    Error::AuthorizationNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::CertificateNotFoundFault(inner) => {
                    Error::CertificateNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::DbInstanceAlreadyExistsFault(inner) => {
                    Error::DbInstanceAlreadyExistsFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::DbParameterGroupNotFoundFault(inner) => {
                    Error::DbParameterGroupNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::DbSecurityGroupNotFoundFault(inner) => {
                    Error::DbSecurityGroupNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::DbUpgradeDependencyFailureFault(inner) => {
                    Error::DbUpgradeDependencyFailureFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::DomainNotFoundFault(inner) => {
                    Error::DomainNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(
                    inner,
                ) => Error::InsufficientDbInstanceCapacityFault(inner),
                crate::error::ModifyDBInstanceErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::InvalidDbSecurityGroupStateFault(
                    inner,
                ) => Error::InvalidDbSecurityGroupStateFault(inner),
                crate::error::ModifyDBInstanceErrorKind::InvalidVpcNetworkStateFault(inner) => {
                    Error::InvalidVpcNetworkStateFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::OptionGroupNotFoundFault(inner) => {
                    Error::OptionGroupNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault(
                    inner,
                ) => Error::ProvisionedIopsNotAvailableInAzFault(inner),
                crate::error::ModifyDBInstanceErrorKind::StorageQuotaExceededFault(inner) => {
                    Error::StorageQuotaExceededFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::StorageTypeNotSupportedFault(inner) => {
                    Error::StorageTypeNotSupportedFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyDBParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::ModifyDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(inner) => Error::InvalidDbParameterGroupStateFault(inner),
                crate::error::ModifyDBParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBSubnetGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyDBSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(
                    inner,
                ) => Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::ModifyDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault(inner) => {
                    Error::DbSubnetGroupNotFoundFault(inner)
                }
                crate::error::ModifyDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault(inner) => {
                    Error::DbSubnetQuotaExceededFault(inner)
                }
                crate::error::ModifyDBSubnetGroupErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::ModifyDBSubnetGroupErrorKind::SubnetAlreadyInUse(inner) => {
                    Error::SubnetAlreadyInUse(inner)
                }
                crate::error::ModifyDBSubnetGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyEventSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyEventSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(inner) => Error::EventSubscriptionQuotaExceededFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault(inner) => Error::SnsInvalidTopicFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault(inner) => Error::SnsNoAuthorizationFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(inner) => Error::SnsTopicArnNotFoundFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(inner) => Error::SubscriptionCategoryNotFoundFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SubscriptionNotFoundFault(inner) => Error::SubscriptionNotFoundFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PromoteReadReplicaDBClusterError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PromoteReadReplicaDBClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PromoteReadReplicaDBClusterErrorKind::DbClusterNotFoundFault(
                    inner,
                ) => Error::DbClusterNotFoundFault(inner),
                crate::error::PromoteReadReplicaDBClusterErrorKind::InvalidDbClusterStateFault(
                    inner,
                ) => Error::InvalidDbClusterStateFault(inner),
                crate::error::PromoteReadReplicaDBClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RebootDBInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RebootDBInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RebootDBInstanceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::RebootDBInstanceErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::RebootDBInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveRoleFromDBClusterError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveRoleFromDBClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RemoveRoleFromDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::RemoveRoleFromDBClusterErrorKind::DbClusterRoleNotFoundFault(
                    inner,
                ) => Error::DbClusterRoleNotFoundFault(inner),
                crate::error::RemoveRoleFromDBClusterErrorKind::InvalidDbClusterStateFault(
                    inner,
                ) => Error::InvalidDbClusterStateFault(inner),
                crate::error::RemoveRoleFromDBClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::RemoveSourceIdentifierFromSubscriptionError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::RemoveSourceIdentifierFromSubscriptionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RemoveSourceIdentifierFromSubscriptionErrorKind::SourceNotFoundFault(inner) => Error::SourceNotFoundFault(inner),
                crate::error::RemoveSourceIdentifierFromSubscriptionErrorKind::SubscriptionNotFoundFault(inner) => Error::SubscriptionNotFoundFault(inner),
                crate::error::RemoveSourceIdentifierFromSubscriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RemoveTagsFromResourceErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::RemoveTagsFromResourceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::RemoveTagsFromResourceErrorKind::DbSnapshotNotFoundFault(inner) => {
                    Error::DbSnapshotNotFoundFault(inner)
                }
                crate::error::RemoveTagsFromResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ResetDBClusterParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ResetDBClusterParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ResetDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::ResetDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(inner) => Error::InvalidDbParameterGroupStateFault(inner),
                crate::error::ResetDBClusterParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ResetDBParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ResetDBParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ResetDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(
                    inner,
                ) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::ResetDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(
                    inner,
                ) => Error::InvalidDbParameterGroupStateFault(inner),
                crate::error::ResetDBParameterGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterFromSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterFromSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RestoreDBClusterFromSnapshotErrorKind::DbClusterAlreadyExistsFault(inner) => Error::DbClusterAlreadyExistsFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::DbClusterParameterGroupNotFoundFault(inner) => Error::DbClusterParameterGroupNotFoundFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::DbClusterQuotaExceededFault(inner) => Error::DbClusterQuotaExceededFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::DbSnapshotNotFoundFault(inner) => Error::DbSnapshotNotFoundFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::DbSubnetGroupNotFoundFault(inner) => Error::DbSubnetGroupNotFoundFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InsufficientDbClusterCapacityFault(inner) => Error::InsufficientDbClusterCapacityFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InsufficientStorageClusterCapacityFault(inner) => Error::InsufficientStorageClusterCapacityFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(inner) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidDbSnapshotStateFault(inner) => Error::InvalidDbSnapshotStateFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidRestoreFault(inner) => Error::InvalidRestoreFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidSubnet(inner) => Error::InvalidSubnet(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::OptionGroupNotFoundFault(inner) => Error::OptionGroupNotFoundFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::StorageQuotaExceededFault(inner) => Error::StorageQuotaExceededFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterToPointInTimeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterToPointInTimeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RestoreDBClusterToPointInTimeErrorKind::DbClusterAlreadyExistsFault(inner) => Error::DbClusterAlreadyExistsFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::DbClusterNotFoundFault(inner) => Error::DbClusterNotFoundFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::DbClusterParameterGroupNotFoundFault(inner) => Error::DbClusterParameterGroupNotFoundFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::DbClusterQuotaExceededFault(inner) => Error::DbClusterQuotaExceededFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::DbSubnetGroupNotFoundFault(inner) => Error::DbSubnetGroupNotFoundFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InsufficientDbClusterCapacityFault(inner) => Error::InsufficientDbClusterCapacityFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InsufficientStorageClusterCapacityFault(inner) => Error::InsufficientStorageClusterCapacityFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterSnapshotStateFault(inner) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidDbSnapshotStateFault(inner) => Error::InvalidDbSnapshotStateFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidRestoreFault(inner) => Error::InvalidRestoreFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidSubnet(inner) => Error::InvalidSubnet(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::OptionGroupNotFoundFault(inner) => Error::OptionGroupNotFoundFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::StorageQuotaExceededFault(inner) => Error::StorageQuotaExceededFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StartDBClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::StartDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::StartDBClusterErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::StartDBClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StopDBClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::StopDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::StopDBClusterErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::StopDBClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
