// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AmazonRDSv19`.
///
/// This client allows ergonomic access to a `AmazonRDSv19`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddRoleToDBCluster` operation.
    ///
    /// See [`AddRoleToDBCluster`](crate::client::fluent_builders::AddRoleToDBCluster) for more information about the
    /// operation and its arguments.
    pub fn add_role_to_db_cluster(&self) -> fluent_builders::AddRoleToDBCluster<C, M, R> {
        fluent_builders::AddRoleToDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddSourceIdentifierToSubscription` operation.
    ///
    /// See [`AddSourceIdentifierToSubscription`](crate::client::fluent_builders::AddSourceIdentifierToSubscription) for more information about the
    /// operation and its arguments.
    pub fn add_source_identifier_to_subscription(
        &self,
    ) -> fluent_builders::AddSourceIdentifierToSubscription<C, M, R> {
        fluent_builders::AddSourceIdentifierToSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddTagsToResource` operation.
    ///
    /// See [`AddTagsToResource`](crate::client::fluent_builders::AddTagsToResource) for more information about the
    /// operation and its arguments.
    pub fn add_tags_to_resource(&self) -> fluent_builders::AddTagsToResource<C, M, R> {
        fluent_builders::AddTagsToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ApplyPendingMaintenanceAction` operation.
    ///
    /// See [`ApplyPendingMaintenanceAction`](crate::client::fluent_builders::ApplyPendingMaintenanceAction) for more information about the
    /// operation and its arguments.
    pub fn apply_pending_maintenance_action(
        &self,
    ) -> fluent_builders::ApplyPendingMaintenanceAction<C, M, R> {
        fluent_builders::ApplyPendingMaintenanceAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CopyDBClusterParameterGroup` operation.
    ///
    /// See [`CopyDBClusterParameterGroup`](crate::client::fluent_builders::CopyDBClusterParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn copy_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::CopyDBClusterParameterGroup<C, M, R> {
        fluent_builders::CopyDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CopyDBClusterSnapshot` operation.
    ///
    /// See [`CopyDBClusterSnapshot`](crate::client::fluent_builders::CopyDBClusterSnapshot) for more information about the
    /// operation and its arguments.
    pub fn copy_db_cluster_snapshot(&self) -> fluent_builders::CopyDBClusterSnapshot<C, M, R> {
        fluent_builders::CopyDBClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CopyDBParameterGroup` operation.
    ///
    /// See [`CopyDBParameterGroup`](crate::client::fluent_builders::CopyDBParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn copy_db_parameter_group(&self) -> fluent_builders::CopyDBParameterGroup<C, M, R> {
        fluent_builders::CopyDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBCluster` operation.
    ///
    /// See [`CreateDBCluster`](crate::client::fluent_builders::CreateDBCluster) for more information about the
    /// operation and its arguments.
    pub fn create_db_cluster(&self) -> fluent_builders::CreateDBCluster<C, M, R> {
        fluent_builders::CreateDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBClusterEndpoint` operation.
    ///
    /// See [`CreateDBClusterEndpoint`](crate::client::fluent_builders::CreateDBClusterEndpoint) for more information about the
    /// operation and its arguments.
    pub fn create_db_cluster_endpoint(&self) -> fluent_builders::CreateDBClusterEndpoint<C, M, R> {
        fluent_builders::CreateDBClusterEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBClusterParameterGroup` operation.
    ///
    /// See [`CreateDBClusterParameterGroup`](crate::client::fluent_builders::CreateDBClusterParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn create_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::CreateDBClusterParameterGroup<C, M, R> {
        fluent_builders::CreateDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBClusterSnapshot` operation.
    ///
    /// See [`CreateDBClusterSnapshot`](crate::client::fluent_builders::CreateDBClusterSnapshot) for more information about the
    /// operation and its arguments.
    pub fn create_db_cluster_snapshot(&self) -> fluent_builders::CreateDBClusterSnapshot<C, M, R> {
        fluent_builders::CreateDBClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBInstance` operation.
    ///
    /// See [`CreateDBInstance`](crate::client::fluent_builders::CreateDBInstance) for more information about the
    /// operation and its arguments.
    pub fn create_db_instance(&self) -> fluent_builders::CreateDBInstance<C, M, R> {
        fluent_builders::CreateDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBParameterGroup` operation.
    ///
    /// See [`CreateDBParameterGroup`](crate::client::fluent_builders::CreateDBParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn create_db_parameter_group(&self) -> fluent_builders::CreateDBParameterGroup<C, M, R> {
        fluent_builders::CreateDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBSubnetGroup` operation.
    ///
    /// See [`CreateDBSubnetGroup`](crate::client::fluent_builders::CreateDBSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn create_db_subnet_group(&self) -> fluent_builders::CreateDBSubnetGroup<C, M, R> {
        fluent_builders::CreateDBSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEventSubscription` operation.
    ///
    /// See [`CreateEventSubscription`](crate::client::fluent_builders::CreateEventSubscription) for more information about the
    /// operation and its arguments.
    pub fn create_event_subscription(&self) -> fluent_builders::CreateEventSubscription<C, M, R> {
        fluent_builders::CreateEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBCluster` operation.
    ///
    /// See [`DeleteDBCluster`](crate::client::fluent_builders::DeleteDBCluster) for more information about the
    /// operation and its arguments.
    pub fn delete_db_cluster(&self) -> fluent_builders::DeleteDBCluster<C, M, R> {
        fluent_builders::DeleteDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBClusterEndpoint` operation.
    ///
    /// See [`DeleteDBClusterEndpoint`](crate::client::fluent_builders::DeleteDBClusterEndpoint) for more information about the
    /// operation and its arguments.
    pub fn delete_db_cluster_endpoint(&self) -> fluent_builders::DeleteDBClusterEndpoint<C, M, R> {
        fluent_builders::DeleteDBClusterEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBClusterParameterGroup` operation.
    ///
    /// See [`DeleteDBClusterParameterGroup`](crate::client::fluent_builders::DeleteDBClusterParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::DeleteDBClusterParameterGroup<C, M, R> {
        fluent_builders::DeleteDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBClusterSnapshot` operation.
    ///
    /// See [`DeleteDBClusterSnapshot`](crate::client::fluent_builders::DeleteDBClusterSnapshot) for more information about the
    /// operation and its arguments.
    pub fn delete_db_cluster_snapshot(&self) -> fluent_builders::DeleteDBClusterSnapshot<C, M, R> {
        fluent_builders::DeleteDBClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBInstance` operation.
    ///
    /// See [`DeleteDBInstance`](crate::client::fluent_builders::DeleteDBInstance) for more information about the
    /// operation and its arguments.
    pub fn delete_db_instance(&self) -> fluent_builders::DeleteDBInstance<C, M, R> {
        fluent_builders::DeleteDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBParameterGroup` operation.
    ///
    /// See [`DeleteDBParameterGroup`](crate::client::fluent_builders::DeleteDBParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_db_parameter_group(&self) -> fluent_builders::DeleteDBParameterGroup<C, M, R> {
        fluent_builders::DeleteDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBSubnetGroup` operation.
    ///
    /// See [`DeleteDBSubnetGroup`](crate::client::fluent_builders::DeleteDBSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_db_subnet_group(&self) -> fluent_builders::DeleteDBSubnetGroup<C, M, R> {
        fluent_builders::DeleteDBSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEventSubscription` operation.
    ///
    /// See [`DeleteEventSubscription`](crate::client::fluent_builders::DeleteEventSubscription) for more information about the
    /// operation and its arguments.
    pub fn delete_event_subscription(&self) -> fluent_builders::DeleteEventSubscription<C, M, R> {
        fluent_builders::DeleteEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBClusterEndpoints` operation.
    ///
    /// See [`DescribeDBClusterEndpoints`](crate::client::fluent_builders::DescribeDBClusterEndpoints) for more information about the
    /// operation and its arguments.
    pub fn describe_db_cluster_endpoints(
        &self,
    ) -> fluent_builders::DescribeDBClusterEndpoints<C, M, R> {
        fluent_builders::DescribeDBClusterEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBClusterParameterGroups` operation.
    ///
    /// See [`DescribeDBClusterParameterGroups`](crate::client::fluent_builders::DescribeDBClusterParameterGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_db_cluster_parameter_groups(
        &self,
    ) -> fluent_builders::DescribeDBClusterParameterGroups<C, M, R> {
        fluent_builders::DescribeDBClusterParameterGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBClusterParameters` operation.
    ///
    /// See [`DescribeDBClusterParameters`](crate::client::fluent_builders::DescribeDBClusterParameters) for more information about the
    /// operation and its arguments.
    pub fn describe_db_cluster_parameters(
        &self,
    ) -> fluent_builders::DescribeDBClusterParameters<C, M, R> {
        fluent_builders::DescribeDBClusterParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBClusters` operation.
    ///
    /// See [`DescribeDBClusters`](crate::client::fluent_builders::DescribeDBClusters) for more information about the
    /// operation and its arguments.
    pub fn describe_db_clusters(&self) -> fluent_builders::DescribeDBClusters<C, M, R> {
        fluent_builders::DescribeDBClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBClusterSnapshotAttributes` operation.
    ///
    /// See [`DescribeDBClusterSnapshotAttributes`](crate::client::fluent_builders::DescribeDBClusterSnapshotAttributes) for more information about the
    /// operation and its arguments.
    pub fn describe_db_cluster_snapshot_attributes(
        &self,
    ) -> fluent_builders::DescribeDBClusterSnapshotAttributes<C, M, R> {
        fluent_builders::DescribeDBClusterSnapshotAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBClusterSnapshots` operation.
    ///
    /// See [`DescribeDBClusterSnapshots`](crate::client::fluent_builders::DescribeDBClusterSnapshots) for more information about the
    /// operation and its arguments.
    pub fn describe_db_cluster_snapshots(
        &self,
    ) -> fluent_builders::DescribeDBClusterSnapshots<C, M, R> {
        fluent_builders::DescribeDBClusterSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBEngineVersions` operation.
    ///
    /// See [`DescribeDBEngineVersions`](crate::client::fluent_builders::DescribeDBEngineVersions) for more information about the
    /// operation and its arguments.
    pub fn describe_db_engine_versions(
        &self,
    ) -> fluent_builders::DescribeDBEngineVersions<C, M, R> {
        fluent_builders::DescribeDBEngineVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBInstances` operation.
    ///
    /// See [`DescribeDBInstances`](crate::client::fluent_builders::DescribeDBInstances) for more information about the
    /// operation and its arguments.
    pub fn describe_db_instances(&self) -> fluent_builders::DescribeDBInstances<C, M, R> {
        fluent_builders::DescribeDBInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBParameterGroups` operation.
    ///
    /// See [`DescribeDBParameterGroups`](crate::client::fluent_builders::DescribeDBParameterGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_db_parameter_groups(
        &self,
    ) -> fluent_builders::DescribeDBParameterGroups<C, M, R> {
        fluent_builders::DescribeDBParameterGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBParameters` operation.
    ///
    /// See [`DescribeDBParameters`](crate::client::fluent_builders::DescribeDBParameters) for more information about the
    /// operation and its arguments.
    pub fn describe_db_parameters(&self) -> fluent_builders::DescribeDBParameters<C, M, R> {
        fluent_builders::DescribeDBParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBSubnetGroups` operation.
    ///
    /// See [`DescribeDBSubnetGroups`](crate::client::fluent_builders::DescribeDBSubnetGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_db_subnet_groups(&self) -> fluent_builders::DescribeDBSubnetGroups<C, M, R> {
        fluent_builders::DescribeDBSubnetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEngineDefaultClusterParameters` operation.
    ///
    /// See [`DescribeEngineDefaultClusterParameters`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters) for more information about the
    /// operation and its arguments.
    pub fn describe_engine_default_cluster_parameters(
        &self,
    ) -> fluent_builders::DescribeEngineDefaultClusterParameters<C, M, R> {
        fluent_builders::DescribeEngineDefaultClusterParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEngineDefaultParameters` operation.
    ///
    /// See [`DescribeEngineDefaultParameters`](crate::client::fluent_builders::DescribeEngineDefaultParameters) for more information about the
    /// operation and its arguments.
    pub fn describe_engine_default_parameters(
        &self,
    ) -> fluent_builders::DescribeEngineDefaultParameters<C, M, R> {
        fluent_builders::DescribeEngineDefaultParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEventCategories` operation.
    ///
    /// See [`DescribeEventCategories`](crate::client::fluent_builders::DescribeEventCategories) for more information about the
    /// operation and its arguments.
    pub fn describe_event_categories(&self) -> fluent_builders::DescribeEventCategories<C, M, R> {
        fluent_builders::DescribeEventCategories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEvents` operation.
    ///
    /// See [`DescribeEvents`](crate::client::fluent_builders::DescribeEvents) for more information about the
    /// operation and its arguments.
    pub fn describe_events(&self) -> fluent_builders::DescribeEvents<C, M, R> {
        fluent_builders::DescribeEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEventSubscriptions` operation.
    ///
    /// See [`DescribeEventSubscriptions`](crate::client::fluent_builders::DescribeEventSubscriptions) for more information about the
    /// operation and its arguments.
    pub fn describe_event_subscriptions(
        &self,
    ) -> fluent_builders::DescribeEventSubscriptions<C, M, R> {
        fluent_builders::DescribeEventSubscriptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOrderableDBInstanceOptions` operation.
    ///
    /// See [`DescribeOrderableDBInstanceOptions`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions) for more information about the
    /// operation and its arguments.
    pub fn describe_orderable_db_instance_options(
        &self,
    ) -> fluent_builders::DescribeOrderableDBInstanceOptions<C, M, R> {
        fluent_builders::DescribeOrderableDBInstanceOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePendingMaintenanceActions` operation.
    ///
    /// See [`DescribePendingMaintenanceActions`](crate::client::fluent_builders::DescribePendingMaintenanceActions) for more information about the
    /// operation and its arguments.
    pub fn describe_pending_maintenance_actions(
        &self,
    ) -> fluent_builders::DescribePendingMaintenanceActions<C, M, R> {
        fluent_builders::DescribePendingMaintenanceActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeValidDBInstanceModifications` operation.
    ///
    /// See [`DescribeValidDBInstanceModifications`](crate::client::fluent_builders::DescribeValidDBInstanceModifications) for more information about the
    /// operation and its arguments.
    pub fn describe_valid_db_instance_modifications(
        &self,
    ) -> fluent_builders::DescribeValidDBInstanceModifications<C, M, R> {
        fluent_builders::DescribeValidDBInstanceModifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `FailoverDBCluster` operation.
    ///
    /// See [`FailoverDBCluster`](crate::client::fluent_builders::FailoverDBCluster) for more information about the
    /// operation and its arguments.
    pub fn failover_db_cluster(&self) -> fluent_builders::FailoverDBCluster<C, M, R> {
        fluent_builders::FailoverDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBCluster` operation.
    ///
    /// See [`ModifyDBCluster`](crate::client::fluent_builders::ModifyDBCluster) for more information about the
    /// operation and its arguments.
    pub fn modify_db_cluster(&self) -> fluent_builders::ModifyDBCluster<C, M, R> {
        fluent_builders::ModifyDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBClusterEndpoint` operation.
    ///
    /// See [`ModifyDBClusterEndpoint`](crate::client::fluent_builders::ModifyDBClusterEndpoint) for more information about the
    /// operation and its arguments.
    pub fn modify_db_cluster_endpoint(&self) -> fluent_builders::ModifyDBClusterEndpoint<C, M, R> {
        fluent_builders::ModifyDBClusterEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBClusterParameterGroup` operation.
    ///
    /// See [`ModifyDBClusterParameterGroup`](crate::client::fluent_builders::ModifyDBClusterParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn modify_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::ModifyDBClusterParameterGroup<C, M, R> {
        fluent_builders::ModifyDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBClusterSnapshotAttribute` operation.
    ///
    /// See [`ModifyDBClusterSnapshotAttribute`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute) for more information about the
    /// operation and its arguments.
    pub fn modify_db_cluster_snapshot_attribute(
        &self,
    ) -> fluent_builders::ModifyDBClusterSnapshotAttribute<C, M, R> {
        fluent_builders::ModifyDBClusterSnapshotAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBInstance` operation.
    ///
    /// See [`ModifyDBInstance`](crate::client::fluent_builders::ModifyDBInstance) for more information about the
    /// operation and its arguments.
    pub fn modify_db_instance(&self) -> fluent_builders::ModifyDBInstance<C, M, R> {
        fluent_builders::ModifyDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBParameterGroup` operation.
    ///
    /// See [`ModifyDBParameterGroup`](crate::client::fluent_builders::ModifyDBParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn modify_db_parameter_group(&self) -> fluent_builders::ModifyDBParameterGroup<C, M, R> {
        fluent_builders::ModifyDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBSubnetGroup` operation.
    ///
    /// See [`ModifyDBSubnetGroup`](crate::client::fluent_builders::ModifyDBSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn modify_db_subnet_group(&self) -> fluent_builders::ModifyDBSubnetGroup<C, M, R> {
        fluent_builders::ModifyDBSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyEventSubscription` operation.
    ///
    /// See [`ModifyEventSubscription`](crate::client::fluent_builders::ModifyEventSubscription) for more information about the
    /// operation and its arguments.
    pub fn modify_event_subscription(&self) -> fluent_builders::ModifyEventSubscription<C, M, R> {
        fluent_builders::ModifyEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PromoteReadReplicaDBCluster` operation.
    ///
    /// See [`PromoteReadReplicaDBCluster`](crate::client::fluent_builders::PromoteReadReplicaDBCluster) for more information about the
    /// operation and its arguments.
    pub fn promote_read_replica_db_cluster(
        &self,
    ) -> fluent_builders::PromoteReadReplicaDBCluster<C, M, R> {
        fluent_builders::PromoteReadReplicaDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RebootDBInstance` operation.
    ///
    /// See [`RebootDBInstance`](crate::client::fluent_builders::RebootDBInstance) for more information about the
    /// operation and its arguments.
    pub fn reboot_db_instance(&self) -> fluent_builders::RebootDBInstance<C, M, R> {
        fluent_builders::RebootDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveRoleFromDBCluster` operation.
    ///
    /// See [`RemoveRoleFromDBCluster`](crate::client::fluent_builders::RemoveRoleFromDBCluster) for more information about the
    /// operation and its arguments.
    pub fn remove_role_from_db_cluster(&self) -> fluent_builders::RemoveRoleFromDBCluster<C, M, R> {
        fluent_builders::RemoveRoleFromDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveSourceIdentifierFromSubscription` operation.
    ///
    /// See [`RemoveSourceIdentifierFromSubscription`](crate::client::fluent_builders::RemoveSourceIdentifierFromSubscription) for more information about the
    /// operation and its arguments.
    pub fn remove_source_identifier_from_subscription(
        &self,
    ) -> fluent_builders::RemoveSourceIdentifierFromSubscription<C, M, R> {
        fluent_builders::RemoveSourceIdentifierFromSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveTagsFromResource` operation.
    ///
    /// See [`RemoveTagsFromResource`](crate::client::fluent_builders::RemoveTagsFromResource) for more information about the
    /// operation and its arguments.
    pub fn remove_tags_from_resource(&self) -> fluent_builders::RemoveTagsFromResource<C, M, R> {
        fluent_builders::RemoveTagsFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetDBClusterParameterGroup` operation.
    ///
    /// See [`ResetDBClusterParameterGroup`](crate::client::fluent_builders::ResetDBClusterParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn reset_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::ResetDBClusterParameterGroup<C, M, R> {
        fluent_builders::ResetDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetDBParameterGroup` operation.
    ///
    /// See [`ResetDBParameterGroup`](crate::client::fluent_builders::ResetDBParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn reset_db_parameter_group(&self) -> fluent_builders::ResetDBParameterGroup<C, M, R> {
        fluent_builders::ResetDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreDBClusterFromSnapshot` operation.
    ///
    /// See [`RestoreDBClusterFromSnapshot`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot) for more information about the
    /// operation and its arguments.
    pub fn restore_db_cluster_from_snapshot(
        &self,
    ) -> fluent_builders::RestoreDBClusterFromSnapshot<C, M, R> {
        fluent_builders::RestoreDBClusterFromSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreDBClusterToPointInTime` operation.
    ///
    /// See [`RestoreDBClusterToPointInTime`](crate::client::fluent_builders::RestoreDBClusterToPointInTime) for more information about the
    /// operation and its arguments.
    pub fn restore_db_cluster_to_point_in_time(
        &self,
    ) -> fluent_builders::RestoreDBClusterToPointInTime<C, M, R> {
        fluent_builders::RestoreDBClusterToPointInTime::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartDBCluster` operation.
    ///
    /// See [`StartDBCluster`](crate::client::fluent_builders::StartDBCluster) for more information about the
    /// operation and its arguments.
    pub fn start_db_cluster(&self) -> fluent_builders::StartDBCluster<C, M, R> {
        fluent_builders::StartDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopDBCluster` operation.
    ///
    /// See [`StopDBCluster`](crate::client::fluent_builders::StopDBCluster) for more information about the
    /// operation and its arguments.
    pub fn stop_db_cluster(&self) -> fluent_builders::StopDBCluster<C, M, R> {
        fluent_builders::StopDBCluster::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddRoleToDBCluster`.
    ///
    /// <p>Associates an Identity and Access Management (IAM) role with an
    /// Neptune DB cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddRoleToDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_role_to_db_cluster_input::Builder,
    }
    impl<C, M, R> AddRoleToDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddRoleToDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddRoleToDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::AddRoleToDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddRoleToDbClusterInputOperationOutputAlias,
                crate::output::AddRoleToDbClusterOutput,
                crate::error::AddRoleToDBClusterError,
                crate::input::AddRoleToDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster to associate the IAM role with.</p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The name of the DB cluster to associate the IAM role with.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the Neptune DB cluster,
        /// for example <code>arn:aws:iam::123456789012:role/NeptuneAccessRole</code>.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the Neptune DB cluster,
        /// for example <code>arn:aws:iam::123456789012:role/NeptuneAccessRole</code>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The name of the feature for the Neptune DB cluster that the IAM role is to be associated with.
        /// For the list of supported feature names, see <a href="neptune/latest/userguide/api-other-apis.html#DBEngineVersion">DBEngineVersion</a>.</p>
        pub fn feature_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature_name(inp);
            self
        }
        /// <p>The name of the feature for the Neptune DB cluster that the IAM role is to be associated with.
        /// For the list of supported feature names, see <a href="neptune/latest/userguide/api-other-apis.html#DBEngineVersion">DBEngineVersion</a>.</p>
        pub fn set_feature_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feature_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddSourceIdentifierToSubscription`.
    ///
    /// <p>Adds a source identifier to an existing event notification subscription.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddSourceIdentifierToSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_source_identifier_to_subscription_input::Builder,
    }
    impl<C, M, R> AddSourceIdentifierToSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddSourceIdentifierToSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddSourceIdentifierToSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::AddSourceIdentifierToSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddSourceIdentifierToSubscriptionInputOperationOutputAlias,
                crate::output::AddSourceIdentifierToSubscriptionOutput,
                crate::error::AddSourceIdentifierToSubscriptionError,
                crate::input::AddSourceIdentifierToSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event notification subscription you want to add a source identifier
        /// to.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the event notification subscription you want to add a source identifier
        /// to.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p>The identifier of the event source to be added.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be
        /// supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be
        /// supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must
        /// be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be
        /// supplied.</p>
        /// </li>
        /// </ul>
        pub fn source_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_identifier(inp);
            self
        }
        /// <p>The identifier of the event source to be added.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be
        /// supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be
        /// supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must
        /// be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be
        /// supplied.</p>
        /// </li>
        /// </ul>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddTagsToResource`.
    ///
    /// <p>Adds metadata tags to an Amazon Neptune resource. These tags can also be used with cost
    /// allocation reporting to track cost associated with Amazon Neptune resources, or used in a
    /// Condition statement in an IAM policy for Amazon Neptune.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddTagsToResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_tags_to_resource_input::Builder,
    }
    impl<C, M, R> AddTagsToResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddTagsToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddTagsToResourceInputOperationOutputAlias,
                crate::output::AddTagsToResourceOutput,
                crate::error::AddTagsToResourceError,
                crate::input::AddTagsToResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Neptune resource that the tags are added to. This value is an Amazon Resource
        /// Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The Amazon Neptune resource that the tags are added to. This value is an Amazon Resource
        /// Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Amazon Neptune resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the Amazon Neptune resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ApplyPendingMaintenanceAction`.
    ///
    /// <p>Applies a pending maintenance action to a resource (for example, to a DB instance).</p>
    #[derive(std::fmt::Debug)]
    pub struct ApplyPendingMaintenanceAction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::apply_pending_maintenance_action_input::Builder,
    }
    impl<C, M, R> ApplyPendingMaintenanceAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ApplyPendingMaintenanceAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ApplyPendingMaintenanceActionOutput,
            aws_smithy_http::result::SdkError<crate::error::ApplyPendingMaintenanceActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ApplyPendingMaintenanceActionInputOperationOutputAlias,
                crate::output::ApplyPendingMaintenanceActionOutput,
                crate::error::ApplyPendingMaintenanceActionError,
                crate::input::ApplyPendingMaintenanceActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that the pending maintenance action applies
        /// to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        pub fn resource_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that the pending maintenance action applies
        /// to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>system-update</code>, <code>db-upgrade</code>
        /// </p>
        pub fn apply_action(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.apply_action(inp);
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>system-update</code>, <code>db-upgrade</code>
        /// </p>
        pub fn set_apply_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_apply_action(input);
            self
        }
        /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in
        /// request of type <code>immediate</code> can't be undone.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>immediate</code> - Apply the maintenance action immediately.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>next-maintenance</code> - Apply the maintenance action during the next
        /// maintenance window for the resource.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in
        /// requests.</p>
        /// </li>
        /// </ul>
        pub fn opt_in_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.opt_in_type(inp);
            self
        }
        /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in
        /// request of type <code>immediate</code> can't be undone.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>immediate</code> - Apply the maintenance action immediately.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>next-maintenance</code> - Apply the maintenance action during the next
        /// maintenance window for the resource.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in
        /// requests.</p>
        /// </li>
        /// </ul>
        pub fn set_opt_in_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_opt_in_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyDBClusterParameterGroup`.
    ///
    /// <p>Copies the specified DB cluster parameter group.</p>
    #[derive(std::fmt::Debug)]
    pub struct CopyDBClusterParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_db_cluster_parameter_group_input::Builder,
    }
    impl<C, M, R> CopyDBClusterParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyDBClusterParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyDbClusterParameterGroupInputOperationOutputAlias,
                crate::output::CopyDbClusterParameterGroupOutput,
                crate::error::CopyDBClusterParameterGroupError,
                crate::input::CopyDbClusterParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group.
        /// For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid DB cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>If the source DB cluster parameter group is in the same Amazon Region as the copy,
        /// specify a valid DB parameter group identifier, for example
        /// <code>my-db-cluster-param-group</code>, or a valid ARN.</p>
        /// </li>
        /// <li>
        /// <p>If the source DB parameter group is in a different Amazon Region than the copy, specify a
        /// valid DB cluster parameter group ARN, for example
        /// <code>arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1</code>.</p>
        /// </li>
        /// </ul>
        pub fn source_db_cluster_parameter_group_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_db_cluster_parameter_group_identifier(inp);
            self
        }
        /// <p>The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group.
        /// For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid DB cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>If the source DB cluster parameter group is in the same Amazon Region as the copy,
        /// specify a valid DB parameter group identifier, for example
        /// <code>my-db-cluster-param-group</code>, or a valid ARN.</p>
        /// </li>
        /// <li>
        /// <p>If the source DB parameter group is in a different Amazon Region than the copy, specify a
        /// valid DB cluster parameter group ARN, for example
        /// <code>arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_source_db_cluster_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_source_db_cluster_parameter_group_identifier(input);
            self
        }
        /// <p>The identifier for the copied DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-param-group1</code>
        /// </p>
        pub fn target_db_cluster_parameter_group_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_db_cluster_parameter_group_identifier(inp);
            self
        }
        /// <p>The identifier for the copied DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-param-group1</code>
        /// </p>
        pub fn set_target_db_cluster_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_target_db_cluster_parameter_group_identifier(input);
            self
        }
        /// <p>A description for the copied DB cluster parameter group.</p>
        pub fn target_db_cluster_parameter_group_description(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .target_db_cluster_parameter_group_description(inp);
            self
        }
        /// <p>A description for the copied DB cluster parameter group.</p>
        pub fn set_target_db_cluster_parameter_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_target_db_cluster_parameter_group_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the copied DB cluster parameter group.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the copied DB cluster parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyDBClusterSnapshot`.
    ///
    /// <p>Copies a snapshot of a DB cluster.</p>
    /// <p>To copy a DB cluster snapshot from a shared manual DB cluster snapshot,
    /// <code>SourceDBClusterSnapshotIdentifier</code> must be the Amazon Resource Name (ARN) of the
    /// shared DB cluster snapshot.</p>
    #[derive(std::fmt::Debug)]
    pub struct CopyDBClusterSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_db_cluster_snapshot_input::Builder,
    }
    impl<C, M, R> CopyDBClusterSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyDBClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyDbClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyDBClusterSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyDbClusterSnapshotInputOperationOutputAlias,
                crate::output::CopyDbClusterSnapshotOutput,
                crate::error::CopyDBClusterSnapshotError,
                crate::input::CopyDbClusterSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the DB cluster snapshot to copy. This parameter is not
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid system snapshot in the "available" state.</p>
        /// </li>
        /// <li>
        /// <p>Specify a valid DB snapshot identifier.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code>
        /// </p>
        pub fn source_db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier of the DB cluster snapshot to copy. This parameter is not
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid system snapshot in the "available" state.</p>
        /// </li>
        /// <li>
        /// <p>Specify a valid DB snapshot identifier.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code>
        /// </p>
        pub fn set_source_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The identifier of the new DB cluster snapshot to create from the source DB cluster
        /// snapshot. This parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot2</code>
        /// </p>
        pub fn target_db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier of the new DB cluster snapshot to create from the source DB cluster
        /// snapshot. This parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot2</code>
        /// </p>
        pub fn set_target_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The Amazon Amazon KMS key ID for an encrypted DB cluster snapshot. The KMS key ID is the Amazon
        /// Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.</p>
        ///
        /// <p>If you copy an encrypted DB cluster snapshot from your Amazon account, you can specify a
        /// value for <code>KmsKeyId</code> to encrypt the copy with a new KMS encryption key. If you
        /// don't specify a value for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is
        /// encrypted with the same KMS key as the source DB cluster snapshot.</p>
        ///
        /// <p>If you copy an encrypted DB cluster snapshot that is shared from another Amazon account, then
        /// you must specify a value for <code>KmsKeyId</code>.</p>
        /// <p> KMS encryption keys are specific to the Amazon Region that they are created in, and you
        /// can't use encryption keys from one Amazon Region in another Amazon Region.</p>
        ///
        /// <p>You cannot encrypt an unencrypted DB cluster snapshot when you copy it. If you try to
        /// copy an unencrypted DB cluster snapshot and specify a value for the KmsKeyId parameter, an
        /// error is returned.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The Amazon Amazon KMS key ID for an encrypted DB cluster snapshot. The KMS key ID is the Amazon
        /// Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.</p>
        ///
        /// <p>If you copy an encrypted DB cluster snapshot from your Amazon account, you can specify a
        /// value for <code>KmsKeyId</code> to encrypt the copy with a new KMS encryption key. If you
        /// don't specify a value for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is
        /// encrypted with the same KMS key as the source DB cluster snapshot.</p>
        ///
        /// <p>If you copy an encrypted DB cluster snapshot that is shared from another Amazon account, then
        /// you must specify a value for <code>KmsKeyId</code>.</p>
        /// <p> KMS encryption keys are specific to the Amazon Region that they are created in, and you
        /// can't use encryption keys from one Amazon Region in another Amazon Region.</p>
        ///
        /// <p>You cannot encrypt an unencrypted DB cluster snapshot when you copy it. If you try to
        /// copy an unencrypted DB cluster snapshot and specify a value for the KmsKeyId parameter, an
        /// error is returned.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>Not currently supported.</p>
        pub fn pre_signed_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pre_signed_url(inp);
            self
        }
        /// <p>Not currently supported.</p>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pre_signed_url(input);
            self
        }
        /// <p>True to copy all tags from the source DB cluster snapshot to the target DB cluster
        /// snapshot, and otherwise false. The default is false.</p>
        pub fn copy_tags(mut self, inp: bool) -> Self {
            self.inner = self.inner.copy_tags(inp);
            self
        }
        /// <p>True to copy all tags from the source DB cluster snapshot to the target DB cluster
        /// snapshot, and otherwise false. The default is false.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the new DB cluster snapshot copy.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to assign to the new DB cluster snapshot copy.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyDBParameterGroup`.
    ///
    /// <p>Copies the specified DB parameter group.</p>
    #[derive(std::fmt::Debug)]
    pub struct CopyDBParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_db_parameter_group_input::Builder,
    }
    impl<C, M, R> CopyDBParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyDBParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyDbParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyDBParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyDbParameterGroupInputOperationOutputAlias,
                crate::output::CopyDbParameterGroupOutput,
                crate::error::CopyDBParameterGroupError,
                crate::input::CopyDbParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier or ARN for the source DB parameter group. For information about creating
        /// an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        ///
        /// <p>Constraints:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Must specify a valid DB parameter group.</p>
        /// </li>
        /// <li>
        /// <p>Must specify a valid DB parameter group identifier, for example
        /// <code>my-db-param-group</code>, or a valid ARN.</p>
        /// </li>
        /// </ul>
        pub fn source_db_parameter_group_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_db_parameter_group_identifier(inp);
            self
        }
        /// <p>The identifier or ARN for the source DB parameter group. For information about creating
        /// an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        ///
        /// <p>Constraints:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Must specify a valid DB parameter group.</p>
        /// </li>
        /// <li>
        /// <p>Must specify a valid DB parameter group identifier, for example
        /// <code>my-db-param-group</code>, or a valid ARN.</p>
        /// </li>
        /// </ul>
        pub fn set_source_db_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_db_parameter_group_identifier(input);
            self
        }
        /// <p>The identifier for the copied DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>Example: <code>my-db-parameter-group</code>
        /// </p>
        pub fn target_db_parameter_group_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_db_parameter_group_identifier(inp);
            self
        }
        /// <p>The identifier for the copied DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>Example: <code>my-db-parameter-group</code>
        /// </p>
        pub fn set_target_db_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_parameter_group_identifier(input);
            self
        }
        /// <p>A description for the copied DB parameter group.</p>
        pub fn target_db_parameter_group_description(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_db_parameter_group_description(inp);
            self
        }
        /// <p>A description for the copied DB parameter group.</p>
        pub fn set_target_db_parameter_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_parameter_group_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the copied DB parameter group.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the copied DB parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBCluster`.
    ///
    /// <p>Creates a new Amazon Neptune DB cluster.</p>
    /// <p>You can use the <code>ReplicationSourceIdentifier</code> parameter to create the DB
    /// cluster as a Read Replica of another DB cluster or Amazon Neptune DB instance.</p>
    /// <p>Note that when you create a new cluster using <code>CreateDBCluster</code> directly,
    /// deletion protection is disabled by default (when you create a new production cluster in
    /// the console, deletion protection is enabled by default). You can only delete a DB
    /// cluster if its <code>DeletionProtection</code> field is set to <code>false</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_cluster_input::Builder,
    }
    impl<C, M, R> CreateDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbClusterInputOperationOutputAlias,
                crate::output::CreateDbClusterOutput,
                crate::error::CreateDBClusterError,
                crate::input::CreateDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AvailabilityZones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>A list of EC2 Availability Zones that instances in the DB cluster can be created
        /// in.</p>
        pub fn availability_zones(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zones(inp);
            self
        }
        /// <p>A list of EC2 Availability Zones that instances in the DB cluster can be created
        /// in.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_availability_zones(input);
            self
        }
        /// <p>The number of days for which automated backups are retained. You must specify a minimum
        /// value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 1 to 35</p>
        /// </li>
        /// </ul>
        pub fn backup_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.backup_retention_period(inp);
            self
        }
        /// <p>The number of days for which automated backups are retained. You must specify a minimum
        /// value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 1 to 35</p>
        /// </li>
        /// </ul>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_backup_retention_period(input);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn character_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.character_set_name(inp);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_character_set_name(input);
            self
        }
        /// <p>
        /// <i>If set to <code>true</code>, tags are copied to any snapshot of
        /// the DB cluster that is created.</i>
        /// </p>
        pub fn copy_tags_to_snapshot(mut self, inp: bool) -> Self {
            self.inner = self.inner.copy_tags_to_snapshot(inp);
            self
        }
        /// <p>
        /// <i>If set to <code>true</code>, tags are copied to any snapshot of
        /// the DB cluster that is created.</i>
        /// </p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags_to_snapshot(input);
            self
        }
        /// <p>The name for your database of up to 64 alpha-numeric characters. If you do not provide a
        /// name, Amazon Neptune will not create a database in the DB cluster you are creating.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name for your database of up to 64 alpha-numeric characters. If you do not provide a
        /// name, Amazon Neptune will not create a database in the DB cluster you are creating.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The DB cluster identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The DB cluster identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p> The name of the DB cluster parameter group to associate with this DB cluster. If this
        /// argument is omitted, the default is used.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p> The name of the DB cluster parameter group to associate with this DB cluster. If this
        /// argument is omitted, the default is used.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of EC2 VPC security groups to associate with this DB cluster.</p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p>A list of EC2 VPC security groups to associate with this DB cluster.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>A DB subnet group to associate with this DB cluster.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>A DB subnet group to associate with this DB cluster.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p>The name of the database engine to be used for this DB cluster.</p>
        /// <p>Valid Values: <code>neptune</code>
        /// </p>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The name of the database engine to be used for this DB cluster.</p>
        /// <p>Valid Values: <code>neptune</code>
        /// </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The version number of the database engine to use for the new DB cluster.</p>
        /// <p>Example: <code>1.0.2.1</code>
        /// </p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The version number of the database engine to use for the new DB cluster.</p>
        /// <p>Example: <code>1.0.2.1</code>
        /// </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The port number on which the instances in the DB cluster accept connections.</p>
        /// <p> Default: <code>8182</code>
        /// </p>
        pub fn port(mut self, inp: i32) -> Self {
            self.inner = self.inner.port(inp);
            self
        }
        /// <p>The port number on which the instances in the DB cluster accept connections.</p>
        /// <p> Default: <code>8182</code>
        /// </p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_username(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_username(inp);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_username(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_user_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(inp);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn option_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(inp);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are
        /// enabled using the <code>BackupRetentionPeriod</code> parameter.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred
        /// Maintenance Window</a> in the <i>Amazon Neptune User Guide.</i>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_backup_window(inp);
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are
        /// enabled using the <code>BackupRetentionPeriod</code> parameter.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred
        /// Maintenance Window</a> in the <i>Amazon Neptune User Guide.</i>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_backup_window(input);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated
        /// Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region, occurring on a random day of the week. To see the time blocks available, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred
        /// Maintenance Window</a> in the <i>Amazon Neptune User Guide.</i>
        /// </p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_maintenance_window(inp);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated
        /// Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region, occurring on a random day of the week. To see the time blocks available, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred
        /// Maintenance Window</a> in the <i>Amazon Neptune User Guide.</i>
        /// </p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster
        /// is created as a Read Replica.</p>
        pub fn replication_source_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_source_identifier(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster
        /// is created as a Read Replica.</p>
        pub fn set_replication_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_source_identifier(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the new DB cluster.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to assign to the new DB cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies whether the DB cluster is encrypted.</p>
        pub fn storage_encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.storage_encrypted(inp);
            self
        }
        /// <p>Specifies whether the DB cluster is encrypted.</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_storage_encrypted(input);
            self
        }
        /// <p>The Amazon KMS key identifier for an encrypted DB cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
        /// you are creating a DB cluster with the same Amazon account that owns the KMS encryption key used
        /// to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the
        /// KMS encryption key.</p>
        /// <p>If an encryption key is not specified in <code>KmsKeyId</code>:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then
        /// Amazon Neptune will use the encryption key used to encrypt the source. Otherwise, Amazon
        /// Neptune will use your default encryption key.</p>
        /// </li>
        /// <li>
        /// <p>If the <code>StorageEncrypted</code> parameter is true and
        /// <code>ReplicationSourceIdentifier</code> is not specified, then Amazon Neptune will use
        /// your default encryption key.</p>
        /// </li>
        /// </ul>
        /// <p>Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a
        /// different default encryption key for each Amazon Region.</p>
        /// <p>If you create a Read Replica of an encrypted DB cluster in another Amazon Region, you must
        /// set <code>KmsKeyId</code> to a KMS key ID that is valid in the destination Amazon Region. This
        /// key is used to encrypt the Read Replica in that Amazon Region.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The Amazon KMS key identifier for an encrypted DB cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
        /// you are creating a DB cluster with the same Amazon account that owns the KMS encryption key used
        /// to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the
        /// KMS encryption key.</p>
        /// <p>If an encryption key is not specified in <code>KmsKeyId</code>:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then
        /// Amazon Neptune will use the encryption key used to encrypt the source. Otherwise, Amazon
        /// Neptune will use your default encryption key.</p>
        /// </li>
        /// <li>
        /// <p>If the <code>StorageEncrypted</code> parameter is true and
        /// <code>ReplicationSourceIdentifier</code> is not specified, then Amazon Neptune will use
        /// your default encryption key.</p>
        /// </li>
        /// </ul>
        /// <p>Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a
        /// different default encryption key for each Amazon Region.</p>
        /// <p>If you create a Read Replica of an encrypted DB cluster in another Amazon Region, you must
        /// set <code>KmsKeyId</code> to a KMS key ID that is valid in the destination Amazon Region. This
        /// key is used to encrypt the Read Replica in that Amazon Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn pre_signed_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pre_signed_url(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pre_signed_url(input);
            self
        }
        /// <p>If set to <code>true</code>, enables Amazon Identity and Access Management
        /// (IAM) authentication for the entire DB cluster (this cannot be set at an
        /// instance level).</p>
        /// <p>Default: <code>false</code>.</p>
        pub fn enable_iam_database_authentication(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_iam_database_authentication(inp);
            self
        }
        /// <p>If set to <code>true</code>, enables Amazon Identity and Access Management
        /// (IAM) authentication for the entire DB cluster (this cannot be set at an
        /// instance level).</p>
        /// <p>Default: <code>false</code>.</p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_iam_database_authentication(input);
            self
        }
        /// Appends an item to `EnableCloudwatchLogsExports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.enable_cloudwatch_logs_exports(inp);
            self
        }
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_enable_cloudwatch_logs_exports(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is enabled.</p>
        pub fn deletion_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.deletion_protection(inp);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is enabled.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBClusterEndpoint`.
    ///
    /// <p>Creates a new custom endpoint and associates it with an Amazon Neptune DB cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBClusterEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_cluster_endpoint_input::Builder,
    }
    impl<C, M, R> CreateDBClusterEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBClusterEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbClusterEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBClusterEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbClusterEndpointInputOperationOutputAlias,
                crate::output::CreateDbClusterEndpointOutput,
                crate::error::CreateDBClusterEndpointError,
                crate::input::CreateDbClusterEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The identifier to use for the new endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_endpoint_identifier(inp);
            self
        }
        /// <p>The identifier to use for the new endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_endpoint_identifier(input);
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn endpoint_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_type(inp);
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_type(input);
            self
        }
        /// Appends an item to `StaticMembers`.
        ///
        /// To override the contents of this collection use [`set_static_members`](Self::set_static_members).
        ///
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn static_members(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.static_members(inp);
            self
        }
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn set_static_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_static_members(input);
            self
        }
        /// Appends an item to `ExcludedMembers`.
        ///
        /// To override the contents of this collection use [`set_excluded_members`](Self::set_excluded_members).
        ///
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
        /// All other eligible instances are reachable through the custom endpoint.
        /// Only relevant if the list of static members is empty.</p>
        pub fn excluded_members(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.excluded_members(inp);
            self
        }
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
        /// All other eligible instances are reachable through the custom endpoint.
        /// Only relevant if the list of static members is empty.</p>
        pub fn set_excluded_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_excluded_members(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Amazon Neptune resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the Amazon Neptune resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBClusterParameterGroup`.
    ///
    /// <p>Creates a new DB cluster parameter group.</p>
    /// <p>Parameters in a DB cluster parameter group apply to all of the instances in a DB
    /// cluster.</p>
    /// <p> A DB cluster parameter group is initially created with the default
    /// parameters for the database engine used by instances in the DB cluster.
    /// To provide custom values for any of the parameters, you must modify the
    /// group after creating it using <a>ModifyDBClusterParameterGroup</a>.
    /// Once you've created a DB cluster parameter group, you need to associate it
    /// with your DB cluster using <a>ModifyDBCluster</a>.
    /// When you associate a new DB cluster parameter group with a running DB cluster,
    /// you need to reboot the DB instances in the DB cluster without failover for the
    /// new DB cluster parameter group and associated settings to take effect.</p>
    /// <important>
    /// <p>After you create a DB cluster parameter group, you should wait at least
    /// 5 minutes before creating your first DB cluster that uses that DB cluster
    /// parameter group as the default parameter group. This allows Amazon Neptune
    /// to fully complete the create action before the DB cluster parameter group
    /// is used as the default for a new DB cluster. This is especially important for
    /// parameters that are critical when creating the default database for a DB
    /// cluster, such as the character set for the default database defined by the
    /// <code>character_set_database</code> parameter. You can use the <i>Parameter
    /// Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon Neptune
    /// console</a> or the <a>DescribeDBClusterParameters</a>
    /// command to verify that your DB cluster parameter group has been created or modified.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBClusterParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_cluster_parameter_group_input::Builder,
    }
    impl<C, M, R> CreateDBClusterParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBClusterParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbClusterParameterGroupInputOperationOutputAlias,
                crate::output::CreateDbClusterParameterGroupOutput,
                crate::error::CreateDBClusterParameterGroupError,
                crate::input::CreateDbClusterParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// <p>The DB cluster parameter group family name. A DB cluster parameter group can be associated
        /// with one and only one DB cluster parameter group family, and can be applied only to a DB
        /// cluster running a database engine and engine version compatible with that DB cluster parameter
        /// group family.</p>
        pub fn db_parameter_group_family(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_family(inp);
            self
        }
        /// <p>The DB cluster parameter group family name. A DB cluster parameter group can be associated
        /// with one and only one DB cluster parameter group family, and can be applied only to a DB
        /// cluster running a database engine and engine version compatible with that DB cluster parameter
        /// group family.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_family(input);
            self
        }
        /// <p>The description for the DB cluster parameter group.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description for the DB cluster parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the new DB cluster parameter group.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the new DB cluster parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBClusterSnapshot`.
    ///
    /// <p>Creates a snapshot of a DB cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBClusterSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_cluster_snapshot_input::Builder,
    }
    impl<C, M, R> CreateDBClusterSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBClusterSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbClusterSnapshotInputOperationOutputAlias,
                crate::output::CreateDbClusterSnapshotOutput,
                crate::error::CreateDBClusterSnapshotError,
                crate::input::CreateDbClusterSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the DB cluster snapshot. This parameter is stored as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1-snapshot1</code>
        /// </p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier of the DB cluster snapshot. This parameter is stored as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1-snapshot1</code>
        /// </p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The identifier of the DB cluster to create a snapshot for. This parameter is not
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the DB cluster to create a snapshot for. This parameter is not
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the DB cluster snapshot.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the DB cluster snapshot.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBInstance`.
    ///
    /// <p>Creates a new DB instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_instance_input::Builder,
    }
    impl<C, M, R> CreateDBInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbInstanceInputOperationOutputAlias,
                crate::output::CreateDbInstanceOutput,
                crate::error::CreateDBInstanceError,
                crate::input::CreateDbInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Not supported.</p>
        pub fn db_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_name(inp);
            self
        }
        /// <p>Not supported.</p>
        pub fn set_db_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_db_name(input);
            self
        }
        /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code>
        /// </p>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code>
        /// </p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn allocated_storage(mut self, inp: i32) -> Self {
            self.inner = self.inner.allocated_storage(inp);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_allocated_storage(input);
            self
        }
        /// <p>The compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>.
        /// Not all DB instance classes are available in all Amazon Regions.</p>
        pub fn db_instance_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_class(inp);
            self
        }
        /// <p>The compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>.
        /// Not all DB instance classes are available in all Amazon Regions.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_class(input);
            self
        }
        /// <p>The name of the database engine to be used for this instance.</p>
        /// <p>Valid Values: <code>neptune</code>
        /// </p>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The name of the database engine to be used for this instance.</p>
        /// <p>Valid Values: <code>neptune</code>
        /// </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_username(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_username(inp);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_username(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_user_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(inp);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// Appends an item to `DBSecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_db_security_groups`](Self::set_db_security_groups).
        ///
        /// <p>A list of DB security groups to associate with this DB instance.</p>
        /// <p>Default: The default DB security group for the database engine.</p>
        pub fn db_security_groups(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_security_groups(inp);
            self
        }
        /// <p>A list of DB security groups to associate with this DB instance.</p>
        /// <p>Default: The default DB security group for the database engine.</p>
        pub fn set_db_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_db_security_groups(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of EC2 VPC security groups to associate with this DB instance.</p>
        /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB
        /// cluster. For more information, see <a>CreateDBCluster</a>.</p>
        /// <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p>A list of EC2 VPC security groups to associate with this DB instance.</p>
        /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB
        /// cluster. For more information, see <a>CreateDBCluster</a>.</p>
        /// <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p> The EC2 Availability Zone that the DB instance is created in</p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Region.</p>
        /// <p> Example: <code>us-east-1d</code>
        /// </p>
        /// <p> Constraint: The AvailabilityZone parameter can't be specified if the MultiAZ parameter is
        /// set to <code>true</code>. The specified Availability Zone must be in the same Amazon Region as
        /// the current endpoint.</p>
        pub fn availability_zone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(inp);
            self
        }
        /// <p> The EC2 Availability Zone that the DB instance is created in</p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Region.</p>
        /// <p> Example: <code>us-east-1d</code>
        /// </p>
        /// <p> Constraint: The AvailabilityZone parameter can't be specified if the MultiAZ parameter is
        /// set to <code>true</code>. The specified Availability Zone must be in the same Amazon Region as
        /// the current endpoint.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>A DB subnet group to associate with this DB instance.</p>
        /// <p>If there is no DB subnet group, then it is a non-VPC DB instance.</p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>A DB subnet group to associate with this DB instance.</p>
        /// <p>If there is no DB subnet group, then it is a non-VPC DB instance.</p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p>The time range each week during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region, occurring on a random day of the week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_maintenance_window(inp);
            self
        }
        /// <p>The time range each week during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region, occurring on a random day of the week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The name of the DB parameter group to associate with this DB instance. If this argument is
        /// omitted, the default DBParameterGroup for the specified engine is used.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB parameter group to associate with this DB instance. If this argument is
        /// omitted, the default DBParameterGroup for the specified engine is used.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// <p>The number of days for which automated backups are
        /// retained.</p>
        /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster.
        /// For more information, see <a>CreateDBCluster</a>.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 0 to 35</p>
        /// </li>
        /// <li>
        /// <p>Cannot be set to 0 if the DB instance is a source to Read Replicas</p>
        /// </li>
        /// </ul>
        pub fn backup_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.backup_retention_period(inp);
            self
        }
        /// <p>The number of days for which automated backups are
        /// retained.</p>
        /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster.
        /// For more information, see <a>CreateDBCluster</a>.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 0 to 35</p>
        /// </li>
        /// <li>
        /// <p>Cannot be set to 0 if the DB instance is a source to Read Replicas</p>
        /// </li>
        /// </ul>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_backup_retention_period(input);
            self
        }
        /// <p> The daily time range during which automated backups are created.</p>
        /// <p>Not applicable. The daily time range for creating automated backups is managed by the DB
        /// cluster. For more information, see <a>CreateDBCluster</a>.</p>
        pub fn preferred_backup_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_backup_window(inp);
            self
        }
        /// <p> The daily time range during which automated backups are created.</p>
        /// <p>Not applicable. The daily time range for creating automated backups is managed by the DB
        /// cluster. For more information, see <a>CreateDBCluster</a>.</p>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_backup_window(input);
            self
        }
        /// <p>The port number on which the database accepts connections.</p>
        /// <p>Not applicable. The port is managed by the DB cluster. For more information, see <a>CreateDBCluster</a>.</p>
        /// <p> Default: <code>8182</code>
        /// </p>
        /// <p>Type: Integer</p>
        pub fn port(mut self, inp: i32) -> Self {
            self.inner = self.inner.port(inp);
            self
        }
        /// <p>The port number on which the database accepts connections.</p>
        /// <p>Not applicable. The port is managed by the DB cluster. For more information, see <a>CreateDBCluster</a>.</p>
        /// <p> Default: <code>8182</code>
        /// </p>
        /// <p>Type: Integer</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>Specifies if the DB instance is a Multi-AZ deployment. You can't set the AvailabilityZone
        /// parameter if the MultiAZ parameter is set to true.</p>
        pub fn multi_az(mut self, inp: bool) -> Self {
            self.inner = self.inner.multi_az(inp);
            self
        }
        /// <p>Specifies if the DB instance is a Multi-AZ deployment. You can't set the AvailabilityZone
        /// parameter if the MultiAZ parameter is set to true.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_multi_az(input);
            self
        }
        /// <p>The version number of the database engine to use. Currently, setting this
        /// parameter has no effect.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The version number of the database engine to use. Currently, setting this
        /// parameter has no effect.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>Indicates that minor engine upgrades are applied automatically to the DB instance during
        /// the maintenance window.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn auto_minor_version_upgrade(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(inp);
            self
        }
        /// <p>Indicates that minor engine upgrades are applied automatically to the DB instance during
        /// the maintenance window.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// <p>License model information for this DB instance.</p>
        /// <p> Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
        /// <code>general-public-license</code>
        /// </p>
        pub fn license_model(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_model(inp);
            self
        }
        /// <p>License model information for this DB instance.</p>
        /// <p> Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
        /// <code>general-public-license</code>
        /// </p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_model(input);
            self
        }
        /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially
        /// allocated for the DB instance.</p>
        pub fn iops(mut self, inp: i32) -> Self {
            self.inner = self.inner.iops(inp);
            self
        }
        /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially
        /// allocated for the DB instance.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_iops(input);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn option_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(inp);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn character_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.character_set_name(inp);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_character_set_name(input);
            self
        }
        /// <p>This flag should no longer be used.</p>
        pub fn publicly_accessible(mut self, inp: bool) -> Self {
            self.inner = self.inner.publicly_accessible(inp);
            self
        }
        /// <p>This flag should no longer be used.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_accessible(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the new instance.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to assign to the new instance.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The identifier of the DB cluster that the instance will belong to.</p>
        /// <p>For information on creating a DB cluster, see <a>CreateDBCluster</a>.</p>
        /// <p>Type: String</p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the DB cluster that the instance will belong to.</p>
        /// <p>For information on creating a DB cluster, see <a>CreateDBCluster</a>.</p>
        /// <p>Type: String</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>Specifies the storage type to be associated with the DB instance.</p>
        /// <p>Not applicable. Storage is managed by the DB Cluster.</p>
        pub fn storage_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.storage_type(inp);
            self
        }
        /// <p>Specifies the storage type to be associated with the DB instance.</p>
        /// <p>Not applicable. Storage is managed by the DB Cluster.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_storage_type(input);
            self
        }
        /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
        pub fn tde_credential_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tde_credential_arn(inp);
            self
        }
        /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
        pub fn set_tde_credential_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tde_credential_arn(input);
            self
        }
        /// <p>The password for the given ARN from the key store in order to access the device.</p>
        pub fn tde_credential_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tde_credential_password(inp);
            self
        }
        /// <p>The password for the given ARN from the key store in order to access the device.</p>
        pub fn set_tde_credential_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tde_credential_password(input);
            self
        }
        /// <p>Specifies whether the DB instance is encrypted.</p>
        /// <p>Not applicable. The encryption for DB instances is managed by the DB cluster. For more
        /// information, see <a>CreateDBCluster</a>.</p>
        /// <p>Default: false</p>
        pub fn storage_encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.storage_encrypted(inp);
            self
        }
        /// <p>Specifies whether the DB instance is encrypted.</p>
        /// <p>Not applicable. The encryption for DB instances is managed by the DB cluster. For more
        /// information, see <a>CreateDBCluster</a>.</p>
        /// <p>Default: false</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_storage_encrypted(input);
            self
        }
        /// <p>The Amazon KMS key identifier for an encrypted DB instance.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
        /// you are creating a DB instance with the same Amazon account that owns the KMS encryption key used
        /// to encrypt the new DB instance, then you can use the KMS key alias instead of the ARN for the
        /// KM encryption key.</p>
        /// <p>Not applicable. The KMS key identifier is managed by the DB cluster. For more information,
        /// see <a>CreateDBCluster</a>.</p>
        /// <p>If the <code>StorageEncrypted</code> parameter is true, and you do not specify a value for
        /// the <code>KmsKeyId</code> parameter, then Amazon Neptune will use your default encryption key.
        /// Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a
        /// different default encryption key for each Amazon Region.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The Amazon KMS key identifier for an encrypted DB instance.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
        /// you are creating a DB instance with the same Amazon account that owns the KMS encryption key used
        /// to encrypt the new DB instance, then you can use the KMS key alias instead of the ARN for the
        /// KM encryption key.</p>
        /// <p>Not applicable. The KMS key identifier is managed by the DB cluster. For more information,
        /// see <a>CreateDBCluster</a>.</p>
        /// <p>If the <code>StorageEncrypted</code> parameter is true, and you do not specify a value for
        /// the <code>KmsKeyId</code> parameter, then Amazon Neptune will use your default encryption key.
        /// Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a
        /// different default encryption key for each Amazon Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>Specify the Active Directory Domain to create the instance in.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>Specify the Active Directory Domain to create the instance in.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise
        /// false. The default is false.</p>
        pub fn copy_tags_to_snapshot(mut self, inp: bool) -> Self {
            self.inner = self.inner.copy_tags_to_snapshot(inp);
            self
        }
        /// <p>True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise
        /// false. The default is false.</p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags_to_snapshot(input);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected
        /// for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default
        /// is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must also set
        /// <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
        /// </p>
        pub fn monitoring_interval(mut self, inp: i32) -> Self {
            self.inner = self.inner.monitoring_interval(inp);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected
        /// for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default
        /// is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must also set
        /// <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
        /// </p>
        pub fn set_monitoring_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_monitoring_interval(input);
            self
        }
        /// <p>The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to
        /// Amazon CloudWatch Logs. For example,
        /// <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
        /// <code>MonitoringRoleArn</code> value.</p>
        pub fn monitoring_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.monitoring_role_arn(inp);
            self
        }
        /// <p>The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to
        /// Amazon CloudWatch Logs. For example,
        /// <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
        /// <code>MonitoringRoleArn</code> value.</p>
        pub fn set_monitoring_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_monitoring_role_arn(input);
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory
        /// Service.</p>
        pub fn domain_iam_role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_iam_role_name(inp);
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory
        /// Service.</p>
        pub fn set_domain_iam_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_domain_iam_role_name(input);
            self
        }
        /// <p>A value that specifies the order in which an Read Replica is promoted to the primary
        /// instance after a failure of the existing primary instance.
        /// </p>
        /// <p>Default: 1</p>
        /// <p>Valid Values: 0 - 15</p>
        pub fn promotion_tier(mut self, inp: i32) -> Self {
            self.inner = self.inner.promotion_tier(inp);
            self
        }
        /// <p>A value that specifies the order in which an Read Replica is promoted to the primary
        /// instance after a failure of the existing primary instance.
        /// </p>
        /// <p>Default: 1</p>
        /// <p>Valid Values: 0 - 15</p>
        pub fn set_promotion_tier(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_promotion_tier(input);
            self
        }
        /// <p>The time zone of the DB instance.</p>
        pub fn timezone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.timezone(inp);
            self
        }
        /// <p>The time zone of the DB instance.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_timezone(input);
            self
        }
        /// <p>Not supported by Neptune (ignored).</p>
        pub fn enable_iam_database_authentication(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_iam_database_authentication(inp);
            self
        }
        /// <p>Not supported by Neptune (ignored).</p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_iam_database_authentication(input);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn enable_performance_insights(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_performance_insights(inp);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_enable_performance_insights(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_performance_insights(input);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn performance_insights_kms_key_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.performance_insights_kms_key_id(inp);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_performance_insights_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_performance_insights_kms_key_id(input);
            self
        }
        /// Appends an item to `EnableCloudwatchLogsExports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.enable_cloudwatch_logs_exports(inp);
            self
        }
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_enable_cloudwatch_logs_exports(input);
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting
        /// a DB Instance</a>.</p>
        ///
        /// <p>DB instances in a DB cluster can be deleted even when deletion
        /// protection is enabled in their parent DB cluster.</p>
        pub fn deletion_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.deletion_protection(inp);
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting
        /// a DB Instance</a>.</p>
        ///
        /// <p>DB instances in a DB cluster can be deleted even when deletion
        /// protection is enabled in their parent DB cluster.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBParameterGroup`.
    ///
    /// <p>Creates a new DB parameter group.</p>
    ///
    /// <p>A DB parameter group is initially created with the default parameters for the database
    /// engine used by the DB instance. To provide custom values for any of the parameters, you must
    /// modify the group after creating it using <i>ModifyDBParameterGroup</i>. Once
    /// you've created a DB parameter group, you need to associate it with your DB instance using
    /// <i>ModifyDBInstance</i>. When you associate a new DB parameter group with a
    /// running DB instance, you need to reboot the DB instance without failover for the new DB
    /// parameter group and associated settings to take effect.</p>
    ///
    /// <important>
    /// <p>After you create a DB parameter group, you should wait at least 5 minutes before
    /// creating your first DB instance that uses that DB parameter group as the default parameter
    /// group. This allows Amazon Neptune to fully complete the create action before the parameter
    /// group is used as the default for a new DB instance. This is especially important for
    /// parameters that are critical when creating the default database for a DB instance, such as
    /// the character set for the default database defined by the
    /// <code>character_set_database</code> parameter. You can use the <i>Parameter
    /// Groups</i> option of the Amazon Neptune console or the
    /// <i>DescribeDBParameters</i> command to verify that your DB parameter group has
    /// been created or modified.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_parameter_group_input::Builder,
    }
    impl<C, M, R> CreateDBParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbParameterGroupInputOperationOutputAlias,
                crate::output::CreateDbParameterGroupOutput,
                crate::error::CreateDBParameterGroupError,
                crate::input::CreateDbParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn db_parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// <p>The DB parameter group family name. A DB parameter group can be associated with one and
        /// only one DB parameter group family, and can be applied only to a DB instance running a
        /// database engine and engine version compatible with that DB parameter group family.</p>
        pub fn db_parameter_group_family(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_family(inp);
            self
        }
        /// <p>The DB parameter group family name. A DB parameter group can be associated with one and
        /// only one DB parameter group family, and can be applied only to a DB instance running a
        /// database engine and engine version compatible with that DB parameter group family.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_family(input);
            self
        }
        /// <p>The description for the DB parameter group.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description for the DB parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the new DB parameter group.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the new DB parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBSubnetGroup`.
    ///
    /// <p>Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at
    /// least two AZs in the Amazon Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_subnet_group_input::Builder,
    }
    impl<C, M, R> CreateDBSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbSubnetGroupInputOperationOutputAlias,
                crate::output::CreateDbSubnetGroupOutput,
                crate::error::CreateDBSubnetGroupError,
                crate::input::CreateDbSubnetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the DB subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 letters, numbers, periods, underscores, spaces,
        /// or hyphens. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>The name for the DB subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 letters, numbers, periods, underscores, spaces,
        /// or hyphens. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p>The description for the DB subnet group.</p>
        pub fn db_subnet_group_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_description(inp);
            self
        }
        /// <p>The description for the DB subnet group.</p>
        pub fn set_db_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The EC2 Subnet IDs for the DB subnet group.</p>
        pub fn subnet_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(inp);
            self
        }
        /// <p>The EC2 Subnet IDs for the DB subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the new DB subnet group.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the new DB subnet group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEventSubscription`.
    ///
    /// <p>Creates an event notification subscription. This action requires a topic ARN (Amazon
    /// Resource Name) created by either the Neptune console, the SNS console, or the SNS API. To
    /// obtain an ARN with SNS, you must create a topic in Amazon SNS and subscribe to the topic. The
    /// ARN is displayed in the SNS console.</p>
    /// <p>You can specify the type of source (SourceType) you want to be notified of, provide a list
    /// of Neptune sources (SourceIds) that triggers the events, and provide a list of event
    /// categories (EventCategories) for events you want to be notified of. For example, you can
    /// specify SourceType = db-instance, SourceIds = mydbinstance1, mydbinstance2 and EventCategories
    /// = Availability, Backup.</p>
    /// <p>If you specify both the SourceType and SourceIds, such as SourceType = db-instance and
    /// SourceIdentifier = myDBInstance1, you are notified of all the db-instance events for the
    /// specified source. If you specify a SourceType but do not specify a SourceIdentifier, you
    /// receive notice of the events for that source type for all your Neptune sources. If you do not
    /// specify either the SourceType nor the SourceIdentifier, you are notified of events generated
    /// from all Neptune sources belonging to your customer account.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateEventSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_event_subscription_input::Builder,
    }
    impl<C, M, R> CreateEventSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEventSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEventSubscriptionInputOperationOutputAlias,
                crate::output::CreateEventSubscriptionOutput,
                crate::error::CreateEventSubscriptionError,
                crate::input::CreateEventSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the subscription.</p>
        /// <p>Constraints: The name must be less than 255 characters.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the subscription.</p>
        /// <p>Constraints: The name must be less than 255 characters.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is
        /// created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn sns_topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is
        /// created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified
        /// of events generated by a DB instance, you would set this parameter to db-instance. if this
        /// value is not specified, all events are returned.</p>
        /// <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> |
        /// <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> |
        /// <code>db-cluster-snapshot</code>
        /// </p>
        pub fn source_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified
        /// of events generated by a DB instance, you would set this parameter to db-instance. if this
        /// value is not specified, all events are returned.</p>
        /// <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> |
        /// <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> |
        /// <code>db-cluster-snapshot</code>
        /// </p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p> A list of event categories for a SourceType that you want to subscribe to. You can see a
        /// list of the categories for a given SourceType by using the
        /// <b>DescribeEventCategories</b> action.</p>
        pub fn event_categories(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(inp);
            self
        }
        /// <p> A list of event categories for a SourceType that you want to subscribe to. You can see a
        /// list of the categories for a given SourceType by using the
        /// <b>DescribeEventCategories</b> action.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// Appends an item to `SourceIds`.
        ///
        /// To override the contents of this collection use [`set_source_ids`](Self::set_source_ids).
        ///
        /// <p>The list of identifiers of the event sources for which events are returned. If not
        /// specified, then all sources are included in the response. An identifier must begin with a
        /// letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or
        /// contain two consecutive hyphens.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If SourceIds are supplied, SourceType must also be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be
        /// supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be
        /// supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must
        /// be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be
        /// supplied.</p>
        /// </li>
        /// </ul>
        pub fn source_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_ids(inp);
            self
        }
        /// <p>The list of identifiers of the event sources for which events are returned. If not
        /// specified, then all sources are included in the response. An identifier must begin with a
        /// letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or
        /// contain two consecutive hyphens.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If SourceIds are supplied, SourceType must also be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be
        /// supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be
        /// supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must
        /// be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be
        /// supplied.</p>
        /// </li>
        /// </ul>
        pub fn set_source_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_source_ids(input);
            self
        }
        /// <p> A Boolean value; set to <b>true</b> to activate the
        /// subscription, set to <b>false</b> to create the subscription but not
        /// active it.</p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p> A Boolean value; set to <b>true</b> to activate the
        /// subscription, set to <b>false</b> to create the subscription but not
        /// active it.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be applied to the new event subscription.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be applied to the new event subscription.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBCluster`.
    ///
    /// <p>The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a
    /// DB cluster, all automated backups for that DB cluster are deleted and can't be recovered.
    /// Manual DB cluster snapshots of the specified DB cluster are not deleted.</p>
    ///
    /// <p>Note that the DB Cluster cannot be deleted if deletion protection is enabled.  To
    /// delete it, you must first set its <code>DeletionProtection</code> field to
    /// <code>False</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_cluster_input::Builder,
    }
    impl<C, M, R> DeleteDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbClusterInputOperationOutputAlias,
                crate::output::DeleteDbClusterOutput,
                crate::error::DeleteDBClusterError,
                crate::input::DeleteDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB cluster identifier for the DB cluster to be deleted. This parameter isn't
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match an existing DBClusterIdentifier.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The DB cluster identifier for the DB cluster to be deleted. This parameter isn't
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match an existing DBClusterIdentifier.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p> Determines whether a final DB cluster snapshot is created before the DB cluster is
        /// deleted. If <code>true</code> is specified, no DB cluster snapshot is created. If
        /// <code>false</code> is specified, a DB cluster snapshot is created before the DB cluster is
        /// deleted.</p>
        /// <note>
        /// <p>You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if
        /// <code>SkipFinalSnapshot</code> is <code>false</code>.</p>
        /// </note>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn skip_final_snapshot(mut self, inp: bool) -> Self {
            self.inner = self.inner.skip_final_snapshot(inp);
            self
        }
        /// <p> Determines whether a final DB cluster snapshot is created before the DB cluster is
        /// deleted. If <code>true</code> is specified, no DB cluster snapshot is created. If
        /// <code>false</code> is specified, a DB cluster snapshot is created before the DB cluster is
        /// deleted.</p>
        /// <note>
        /// <p>You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if
        /// <code>SkipFinalSnapshot</code> is <code>false</code>.</p>
        /// </note>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_skip_final_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_final_snapshot(input);
            self
        }
        /// <p> The DB cluster snapshot identifier of the new DB cluster snapshot created when
        /// <code>SkipFinalSnapshot</code> is set to <code>false</code>.</p>
        /// <note>
        /// <p> Specifying this parameter and also setting the <code>SkipFinalShapshot</code> parameter
        /// to true results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn final_db_snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.final_db_snapshot_identifier(inp);
            self
        }
        /// <p> The DB cluster snapshot identifier of the new DB cluster snapshot created when
        /// <code>SkipFinalSnapshot</code> is set to <code>false</code>.</p>
        /// <note>
        /// <p> Specifying this parameter and also setting the <code>SkipFinalShapshot</code> parameter
        /// to true results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn set_final_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_final_db_snapshot_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBClusterEndpoint`.
    ///
    /// <p>Deletes a custom endpoint and removes it from an Amazon Neptune DB cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBClusterEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_cluster_endpoint_input::Builder,
    }
    impl<C, M, R> DeleteDBClusterEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBClusterEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbClusterEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbClusterEndpointInputOperationOutputAlias,
                crate::output::DeleteDbClusterEndpointOutput,
                crate::error::DeleteDBClusterEndpointError,
                crate::input::DeleteDbClusterEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_endpoint_identifier(inp);
            self
        }
        /// <p>The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_endpoint_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBClusterParameterGroup`.
    ///
    /// <p>Deletes a specified DB cluster parameter group. The DB cluster parameter group to be
    /// deleted can't be associated with any DB clusters.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBClusterParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_cluster_parameter_group_input::Builder,
    }
    impl<C, M, R> DeleteDBClusterParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbClusterParameterGroupInputOperationOutputAlias,
                crate::output::DeleteDbClusterParameterGroupOutput,
                crate::error::DeleteDBClusterParameterGroupError,
                crate::input::DeleteDbClusterParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing DB cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>You can't delete a default DB cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be associated with any DB clusters.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing DB cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>You can't delete a default DB cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be associated with any DB clusters.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBClusterSnapshot`.
    ///
    /// <p>Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is
    /// terminated.</p>
    /// <note>
    /// <p>The DB cluster snapshot must be in the <code>available</code> state to be
    /// deleted.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBClusterSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_cluster_snapshot_input::Builder,
    }
    impl<C, M, R> DeleteDBClusterSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbClusterSnapshotInputOperationOutputAlias,
                crate::output::DeleteDbClusterSnapshotOutput,
                crate::error::DeleteDBClusterSnapshotError,
                crate::input::DeleteDbClusterSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the DB cluster snapshot to delete.</p>
        /// <p>Constraints: Must be the name of an existing DB cluster snapshot in the
        /// <code>available</code> state.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier of the DB cluster snapshot to delete.</p>
        /// <p>Constraints: Must be the name of an existing DB cluster snapshot in the
        /// <code>available</code> state.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBInstance`.
    ///
    /// <p>The DeleteDBInstance action deletes a previously provisioned DB instance. When you delete
    /// a DB instance, all automated backups for that instance are deleted and can't be recovered.
    /// Manual DB snapshots of the DB instance to be deleted by <code>DeleteDBInstance</code> are not
    /// deleted.</p>
    /// <p> If you request a final DB snapshot the status of the Amazon Neptune DB instance is
    /// <code>deleting</code> until the DB snapshot is created. The API action
    /// <code>DescribeDBInstance</code> is used to monitor the status of this operation. The action
    /// can't be canceled or reverted once submitted.</p>
    /// <p>Note that when a DB instance is in a failure state and has a status of
    /// <code>failed</code>, <code>incompatible-restore</code>, or <code>incompatible-network</code>,
    /// you can only delete it when the <code>SkipFinalSnapshot</code> parameter is set to
    /// <code>true</code>.</p>
    /// <p>You can't delete a DB instance if it is the only instance in the DB cluster, or
    /// if it has deletion protection enabled.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_instance_input::Builder,
    }
    impl<C, M, R> DeleteDBInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbInstanceInputOperationOutputAlias,
                crate::output::DeleteDbInstanceOutput,
                crate::error::DeleteDBInstanceError,
                crate::input::DeleteDbInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB instance identifier for the DB instance to be deleted. This parameter isn't
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing DB instance.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The DB instance identifier for the DB instance to be deleted. This parameter isn't
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing DB instance.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p> Determines whether a final DB snapshot is created before the DB instance is deleted. If
        /// <code>true</code> is specified, no DBSnapshot is created. If <code>false</code> is specified,
        /// a DB snapshot is created before the DB instance is deleted.</p>
        /// <p>Note that when a DB instance is in a failure state and has a status of 'failed',
        /// 'incompatible-restore', or 'incompatible-network', it can only be deleted when the
        /// SkipFinalSnapshot parameter is set to "true".</p>
        /// <p>Specify <code>true</code> when deleting a Read Replica.</p>
        /// <note>
        /// <p>The FinalDBSnapshotIdentifier parameter must be specified if SkipFinalSnapshot is
        /// <code>false</code>.</p>
        /// </note>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn skip_final_snapshot(mut self, inp: bool) -> Self {
            self.inner = self.inner.skip_final_snapshot(inp);
            self
        }
        /// <p> Determines whether a final DB snapshot is created before the DB instance is deleted. If
        /// <code>true</code> is specified, no DBSnapshot is created. If <code>false</code> is specified,
        /// a DB snapshot is created before the DB instance is deleted.</p>
        /// <p>Note that when a DB instance is in a failure state and has a status of 'failed',
        /// 'incompatible-restore', or 'incompatible-network', it can only be deleted when the
        /// SkipFinalSnapshot parameter is set to "true".</p>
        /// <p>Specify <code>true</code> when deleting a Read Replica.</p>
        /// <note>
        /// <p>The FinalDBSnapshotIdentifier parameter must be specified if SkipFinalSnapshot is
        /// <code>false</code>.</p>
        /// </note>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_skip_final_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_final_snapshot(input);
            self
        }
        /// <p> The DBSnapshotIdentifier of the new DBSnapshot created when SkipFinalSnapshot is set to
        /// <code>false</code>.</p>
        /// <note>
        /// <p>Specifying this parameter and also setting the SkipFinalShapshot parameter to true
        /// results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified when deleting a Read Replica.</p>
        /// </li>
        /// </ul>
        pub fn final_db_snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.final_db_snapshot_identifier(inp);
            self
        }
        /// <p> The DBSnapshotIdentifier of the new DBSnapshot created when SkipFinalSnapshot is set to
        /// <code>false</code>.</p>
        /// <note>
        /// <p>Specifying this parameter and also setting the SkipFinalShapshot parameter to true
        /// results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified when deleting a Read Replica.</p>
        /// </li>
        /// </ul>
        pub fn set_final_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_final_db_snapshot_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBParameterGroup`.
    ///
    /// <p>Deletes a specified DBParameterGroup. The DBParameterGroup to be deleted can't be
    /// associated with any DB instances.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_parameter_group_input::Builder,
    }
    impl<C, M, R> DeleteDBParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbParameterGroupInputOperationOutputAlias,
                crate::output::DeleteDbParameterGroupOutput,
                crate::error::DeleteDBParameterGroupError,
                crate::input::DeleteDbParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing DB parameter group</p>
        /// </li>
        /// <li>
        /// <p>You can't delete a default DB parameter group</p>
        /// </li>
        /// <li>
        /// <p>Cannot be associated with any DB instances</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing DB parameter group</p>
        /// </li>
        /// <li>
        /// <p>You can't delete a default DB parameter group</p>
        /// </li>
        /// <li>
        /// <p>Cannot be associated with any DB instances</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBSubnetGroup`.
    ///
    /// <p>Deletes a DB subnet group.</p>
    /// <note>
    /// <p>The specified database subnet group must not be associated with any DB instances.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_subnet_group_input::Builder,
    }
    impl<C, M, R> DeleteDBSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbSubnetGroupInputOperationOutputAlias,
                crate::output::DeleteDbSubnetGroupOutput,
                crate::error::DeleteDBSubnetGroupError,
                crate::input::DeleteDbSubnetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the database subnet group to delete.</p>
        /// <note>
        /// <p>You can't delete the default subnet group.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>The name of the database subnet group to delete.</p>
        /// <note>
        /// <p>You can't delete the default subnet group.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventSubscription`.
    ///
    /// <p>Deletes an event notification subscription.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEventSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_event_subscription_input::Builder,
    }
    impl<C, M, R> DeleteEventSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEventSubscriptionInputOperationOutputAlias,
                crate::output::DeleteEventSubscriptionOutput,
                crate::error::DeleteEventSubscriptionError,
                crate::input::DeleteEventSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event notification subscription you want to delete.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the event notification subscription you want to delete.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterEndpoints`.
    ///
    /// <p>Returns information about endpoints for an Amazon Neptune DB cluster.</p>
    /// <note>
    /// <p>This operation can also return information for Amazon RDS clusters
    /// and Amazon DocDB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBClusterEndpoints<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_cluster_endpoints_input::Builder,
    }
    impl<C, M, R> DescribeDBClusterEndpoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBClusterEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterEndpointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbClusterEndpointsInputOperationOutputAlias,
                crate::output::DescribeDbClusterEndpointsOutput,
                crate::error::DescribeDBClusterEndpointsError,
                crate::input::DescribeDbClusterEndpointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The identifier of the endpoint to describe. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_endpoint_identifier(inp);
            self
        }
        /// <p>The identifier of the endpoint to describe. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_endpoint_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A set of name-value pairs that define which endpoints to include in the output.
        /// The filters are specified as name-value pairs, in the format
        /// <code>Name=<i>endpoint_type</i>,Values=<i>endpoint_type1</i>,<i>endpoint_type2</i>,...</code>.
        /// <code>Name</code> can be one of: <code>db-cluster-endpoint-type</code>, <code>db-cluster-endpoint-custom-type</code>, <code>db-cluster-endpoint-id</code>, <code>db-cluster-endpoint-status</code>.
        /// <code>Values</code> for the <code> db-cluster-endpoint-type</code> filter can be one or more of: <code>reader</code>, <code>writer</code>, <code>custom</code>.
        /// <code>Values</code> for the <code>db-cluster-endpoint-custom-type</code> filter can be one or more of: <code>reader</code>, <code>any</code>.
        /// <code>Values</code> for the <code>db-cluster-endpoint-status</code> filter can be one or more of: <code>available</code>, <code>creating</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>.
        /// </p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A set of name-value pairs that define which endpoints to include in the output.
        /// The filters are specified as name-value pairs, in the format
        /// <code>Name=<i>endpoint_type</i>,Values=<i>endpoint_type1</i>,<i>endpoint_type2</i>,...</code>.
        /// <code>Name</code> can be one of: <code>db-cluster-endpoint-type</code>, <code>db-cluster-endpoint-custom-type</code>, <code>db-cluster-endpoint-id</code>, <code>db-cluster-endpoint-status</code>.
        /// <code>Values</code> for the <code> db-cluster-endpoint-type</code> filter can be one or more of: <code>reader</code>, <code>writer</code>, <code>custom</code>.
        /// <code>Values</code> for the <code>db-cluster-endpoint-custom-type</code> filter can be one or more of: <code>reader</code>, <code>any</code>.
        /// <code>Values</code> for the <code>db-cluster-endpoint-status</code> filter can be one or more of: <code>available</code>, <code>creating</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>.
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeDBClusterEndpoints</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeDBClusterEndpoints</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterParameterGroups`.
    ///
    /// <p> Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
    /// <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only
    /// the description of the specified DB cluster parameter group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBClusterParameterGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_cluster_parameter_groups_input::Builder,
    }
    impl<C, M, R> DescribeDBClusterParameterGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBClusterParameterGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterParameterGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterParameterGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbClusterParameterGroupsInputOperationOutputAlias,
                crate::output::DescribeDbClusterParameterGroupsOutput,
                crate::error::DescribeDBClusterParameterGroupsError,
                crate::input::DescribeDbClusterParameterGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a specific DB cluster parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of a specific DB cluster parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterParameters`.
    ///
    /// <p>Returns the detailed parameter list for a particular DB cluster parameter group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBClusterParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_cluster_parameters_input::Builder,
    }
    impl<C, M, R> DescribeDBClusterParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBClusterParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterParametersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbClusterParametersInputOperationOutputAlias,
                crate::output::DescribeDbClusterParametersOutput,
                crate::error::DescribeDBClusterParametersError,
                crate::input::DescribeDbClusterParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a specific DB cluster parameter group to return parameter details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of a specific DB cluster parameter group to return parameter details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// <p> A value that indicates to return only parameters for a specific source. Parameter sources
        /// can be <code>engine</code>, <code>service</code>, or <code>customer</code>.</p>
        pub fn source(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p> A value that indicates to return only parameters for a specific source. Parameter sources
        /// can be <code>engine</code>, <code>service</code>, or <code>customer</code>.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeDBClusterParameters</code> request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeDBClusterParameters</code> request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusters`.
    ///
    /// <p>Returns information about provisioned DB clusters, and supports
    /// pagination.</p>
    ///
    /// <note>
    /// <p>This operation can also return information for Amazon RDS clusters
    /// and Amazon DocDB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBClusters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_clusters_input::Builder,
    }
    impl<C, M, R> DescribeDBClusters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClustersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbClustersInputOperationOutputAlias,
                crate::output::DescribeDbClustersOutput,
                crate::error::DescribeDBClustersError,
                crate::input::DescribeDbClustersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user-supplied DB cluster identifier. If this parameter is specified, information from
        /// only the specific DB cluster is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match an existing DBClusterIdentifier.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The user-supplied DB cluster identifier. If this parameter is specified, information from
        /// only the specific DB cluster is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match an existing DBClusterIdentifier.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more DB clusters to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon
        /// Resource Names (ARNs). The results list will only include information about the DB
        /// clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>engine</code> - Accepts an engine name (such as <code>neptune</code>),
        /// and restricts the results list to DB clusters created by that engine.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>For example, to invoke this API from the Amazon CLI and filter so that only
        /// Neptune DB clusters are returned, you could use the following command:</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A filter that specifies one or more DB clusters to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon
        /// Resource Names (ARNs). The results list will only include information about the DB
        /// clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>engine</code> - Accepts an engine name (such as <code>neptune</code>),
        /// and restricts the results list to DB clusters created by that engine.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>For example, to invoke this API from the Amazon CLI and filter so that only
        /// Neptune DB clusters are returned, you could use the following command:</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous <a>DescribeDBClusters</a>
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous <a>DescribeDBClusters</a>
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterSnapshotAttributes`.
    ///
    /// <p>Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster
    /// snapshot.</p>
    /// <p>When sharing snapshots with other Amazon accounts,
    /// <code>DescribeDBClusterSnapshotAttributes</code> returns the <code>restore</code> attribute
    /// and a list of IDs for the Amazon accounts that are authorized to copy or restore the manual DB
    /// cluster snapshot. If <code>all</code> is included in the list of values for the
    /// <code>restore</code> attribute, then the manual DB cluster snapshot is public and can be
    /// copied or restored by all Amazon accounts.</p>
    /// <p>To add or remove access for an Amazon account to copy or restore a manual DB cluster
    /// snapshot, or to make the manual DB cluster snapshot public or private, use the <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBClusterSnapshotAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_cluster_snapshot_attributes_input::Builder,
    }
    impl<C, M, R> DescribeDBClusterSnapshotAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBClusterSnapshotAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterSnapshotAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeDBClusterSnapshotAttributesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbClusterSnapshotAttributesInputOperationOutputAlias,
                crate::output::DescribeDbClusterSnapshotAttributesOutput,
                crate::error::DescribeDBClusterSnapshotAttributesError,
                crate::input::DescribeDbClusterSnapshotAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the DB cluster snapshot to describe the attributes for.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier for the DB cluster snapshot to describe the attributes for.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterSnapshots`.
    ///
    /// <p>Returns information about DB cluster snapshots. This API action supports
    /// pagination.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBClusterSnapshots<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_cluster_snapshots_input::Builder,
    }
    impl<C, M, R> DescribeDBClusterSnapshots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBClusterSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterSnapshotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbClusterSnapshotsInputOperationOutputAlias,
                crate::output::DescribeDbClusterSnapshotsOutput,
                crate::error::DescribeDBClusterSnapshotsError,
                crate::input::DescribeDbClusterSnapshotsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the DB cluster to retrieve the list of DB cluster snapshots for. This parameter
        /// can't be used in conjunction with the <code>DBClusterSnapshotIdentifier</code> parameter. This
        /// parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The ID of the DB cluster to retrieve the list of DB cluster snapshots for. This parameter
        /// can't be used in conjunction with the <code>DBClusterSnapshotIdentifier</code> parameter. This
        /// parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>A specific DB cluster snapshot identifier to describe. This parameter can't be used in
        /// conjunction with the <code>DBClusterIdentifier</code> parameter. This value is stored as a
        /// lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBClusterSnapshot.</p>
        /// </li>
        /// <li>
        /// <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code>
        /// parameter must also be specified.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>A specific DB cluster snapshot identifier to describe. This parameter can't be used in
        /// conjunction with the <code>DBClusterIdentifier</code> parameter. This value is stored as a
        /// lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBClusterSnapshot.</p>
        /// </li>
        /// <li>
        /// <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code>
        /// parameter must also be specified.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The type of DB cluster snapshots to be returned. You can specify one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>automated</code> - Return all DB cluster snapshots that have been automatically
        /// taken by Amazon Neptune for my Amazon account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>manual</code> - Return all DB cluster snapshots that have been taken by my Amazon
        /// account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>shared</code> - Return all manual DB cluster snapshots that have been shared to
        /// my Amazon account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public</code> - Return all DB cluster snapshots that have been marked as
        /// public.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual DB
        /// cluster snapshots are returned. You can include shared DB cluster snapshots with these results
        /// by setting the <code>IncludeShared</code> parameter to <code>true</code>. You can include
        /// public DB cluster snapshots with these results by setting the <code>IncludePublic</code>
        /// parameter to <code>true</code>.</p>
        /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for
        /// <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The
        /// <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to
        /// <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when
        /// <code>SnapshotType</code> is set to <code>public</code>.</p>
        pub fn snapshot_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_type(inp);
            self
        }
        /// <p>The type of DB cluster snapshots to be returned. You can specify one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>automated</code> - Return all DB cluster snapshots that have been automatically
        /// taken by Amazon Neptune for my Amazon account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>manual</code> - Return all DB cluster snapshots that have been taken by my Amazon
        /// account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>shared</code> - Return all manual DB cluster snapshots that have been shared to
        /// my Amazon account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public</code> - Return all DB cluster snapshots that have been marked as
        /// public.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual DB
        /// cluster snapshots are returned. You can include shared DB cluster snapshots with these results
        /// by setting the <code>IncludeShared</code> parameter to <code>true</code>. You can include
        /// public DB cluster snapshots with these results by setting the <code>IncludePublic</code>
        /// parameter to <code>true</code>.</p>
        /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for
        /// <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The
        /// <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to
        /// <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when
        /// <code>SnapshotType</code> is set to <code>public</code>.</p>
        pub fn set_snapshot_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_type(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>True to include shared manual DB cluster snapshots from other Amazon accounts that this Amazon
        /// account has been given permission to copy or restore, and otherwise false. The default is
        /// <code>false</code>.</p>
        /// <p>You can give an Amazon account permission to restore a manual DB cluster snapshot from
        /// another Amazon account by the <a>ModifyDBClusterSnapshotAttribute</a> API
        /// action.</p>
        pub fn include_shared(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_shared(inp);
            self
        }
        /// <p>True to include shared manual DB cluster snapshots from other Amazon accounts that this Amazon
        /// account has been given permission to copy or restore, and otherwise false. The default is
        /// <code>false</code>.</p>
        /// <p>You can give an Amazon account permission to restore a manual DB cluster snapshot from
        /// another Amazon account by the <a>ModifyDBClusterSnapshotAttribute</a> API
        /// action.</p>
        pub fn set_include_shared(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_shared(input);
            self
        }
        /// <p>True to include manual DB cluster snapshots that are public and can be copied or restored
        /// by any Amazon account, and otherwise false. The default is <code>false</code>. The default is
        /// false.</p>
        /// <p>You can share a manual DB cluster snapshot as public by using the <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>
        pub fn include_public(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_public(inp);
            self
        }
        /// <p>True to include manual DB cluster snapshots that are public and can be copied or restored
        /// by any Amazon account, and otherwise false. The default is <code>false</code>. The default is
        /// false.</p>
        /// <p>You can share a manual DB cluster snapshot as public by using the <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>
        pub fn set_include_public(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_public(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBEngineVersions`.
    ///
    /// <p>Returns a list of the available DB engines.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBEngineVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_engine_versions_input::Builder,
    }
    impl<C, M, R> DescribeDBEngineVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBEngineVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbEngineVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBEngineVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbEngineVersionsInputOperationOutputAlias,
                crate::output::DescribeDbEngineVersionsOutput,
                crate::error::DescribeDBEngineVersionsError,
                crate::input::DescribeDbEngineVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The database engine to return.</p>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The database engine to return.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The database engine version to return.</p>
        /// <p>Example: <code>5.1.49</code>
        /// </p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The database engine version to return.</p>
        /// <p>Example: <code>5.1.49</code>
        /// </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The name of a specific DB parameter group family to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match an existing DBParameterGroupFamily.</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_family(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_family(inp);
            self
        }
        /// <p>The name of a specific DB parameter group family to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match an existing DBParameterGroupFamily.</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_family(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more than the
        /// <code>MaxRecords</code> value is available, a pagination token called a marker is included in
        /// the response so that the following results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more than the
        /// <code>MaxRecords</code> value is available, a pagination token called a marker is included in
        /// the response so that the following results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Indicates that only the default version of the specified engine or engine and major
        /// version combination is returned.</p>
        pub fn default_only(mut self, inp: bool) -> Self {
            self.inner = self.inner.default_only(inp);
            self
        }
        /// <p>Indicates that only the default version of the specified engine or engine and major
        /// version combination is returned.</p>
        pub fn set_default_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_default_only(input);
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the
        /// <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response
        /// includes a list of supported character sets for each engine version.</p>
        pub fn list_supported_character_sets(mut self, inp: bool) -> Self {
            self.inner = self.inner.list_supported_character_sets(inp);
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the
        /// <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response
        /// includes a list of supported character sets for each engine version.</p>
        pub fn set_list_supported_character_sets(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_list_supported_character_sets(input);
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the <code>TimeZone</code>
        /// parameter for <code>CreateDBInstance</code>, the response includes a list of supported time
        /// zones for each engine version.</p>
        pub fn list_supported_timezones(mut self, inp: bool) -> Self {
            self.inner = self.inner.list_supported_timezones(inp);
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the <code>TimeZone</code>
        /// parameter for <code>CreateDBInstance</code>, the response includes a list of supported time
        /// zones for each engine version.</p>
        pub fn set_list_supported_timezones(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_list_supported_timezones(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBInstances`.
    ///
    /// <p>Returns information about provisioned instances, and supports pagination.</p>
    ///
    /// <note>
    /// <p>This operation can also return information for Amazon RDS instances
    /// and Amazon DocDB instances.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_instances_input::Builder,
    }
    impl<C, M, R> DescribeDBInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbInstancesInputOperationOutputAlias,
                crate::output::DescribeDbInstancesOutput,
                crate::error::DescribeDBInstancesError,
                crate::input::DescribeDbInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user-supplied instance identifier. If this parameter is specified, information from
        /// only the specific DB instance is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The user-supplied instance identifier. If this parameter is specified, information from
        /// only the specific DB instance is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more DB instances to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon
        /// Resource Names (ARNs). The results list will only include information about the DB
        /// instances associated with the DB clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>engine</code> - Accepts an engine name (such as <code>neptune</code>),
        /// and restricts the results list to DB instances created by that engine.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>For example, to invoke this API from the Amazon CLI and filter so that only
        /// Neptune DB instances are returned, you could use the following command:</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A filter that specifies one or more DB instances to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon
        /// Resource Names (ARNs). The results list will only include information about the DB
        /// instances associated with the DB clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>engine</code> - Accepts an engine name (such as <code>neptune</code>),
        /// and restricts the results list to DB instances created by that engine.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>For example, to invoke this API from the Amazon CLI and filter so that only
        /// Neptune DB instances are returned, you could use the following command:</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribeDBInstances</code>
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribeDBInstances</code>
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBParameterGroups`.
    ///
    /// <p>Returns a list of <code>DBParameterGroup</code> descriptions. If a
    /// <code>DBParameterGroupName</code> is specified, the list will contain only the description of
    /// the specified DB parameter group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBParameterGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_parameter_groups_input::Builder,
    }
    impl<C, M, R> DescribeDBParameterGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBParameterGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbParameterGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBParameterGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbParameterGroupsInputOperationOutputAlias,
                crate::output::DescribeDbParameterGroupsOutput,
                crate::error::DescribeDBParameterGroupsError,
                crate::input::DescribeDbParameterGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(inp);
            self
        }
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeDBParameterGroups</code> request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeDBParameterGroups</code> request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBParameters`.
    ///
    /// <p>Returns the detailed parameter list for a particular DB parameter group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_parameters_input::Builder,
    }
    impl<C, M, R> DescribeDBParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBParametersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbParametersInputOperationOutputAlias,
                crate::output::DescribeDbParametersOutput,
                crate::error::DescribeDBParametersError,
                crate::input::DescribeDbParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(inp);
            self
        }
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// <p>The parameter types to return.</p>
        /// <p>Default: All parameter types returned</p>
        /// <p>Valid Values: <code>user | system | engine-default</code>
        /// </p>
        pub fn source(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p>The parameter types to return.</p>
        /// <p>Default: All parameter types returned</p>
        /// <p>Valid Values: <code>user | system | engine-default</code>
        /// </p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBParameters</code>
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBParameters</code>
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBSubnetGroups`.
    ///
    /// <p>Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the
    /// list will contain only the descriptions of the specified DBSubnetGroup.</p>
    /// <p>For an overview of CIDR ranges, go to the <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBSubnetGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_subnet_groups_input::Builder,
    }
    impl<C, M, R> DescribeDBSubnetGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBSubnetGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbSubnetGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBSubnetGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbSubnetGroupsInputOperationOutputAlias,
                crate::output::DescribeDbSubnetGroupsOutput,
                crate::error::DescribeDBSubnetGroupsError,
                crate::input::DescribeDbSubnetGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB subnet group to return details for.</p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>The name of the DB subnet group to return details for.</p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeDBSubnetGroups request. If
        /// this parameter is specified, the response includes only records beyond the marker, up to the
        /// value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeDBSubnetGroups request. If
        /// this parameter is specified, the response includes only records beyond the marker, up to the
        /// value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEngineDefaultClusterParameters`.
    ///
    /// <p>Returns the default engine and system parameter information for the cluster database
    /// engine.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEngineDefaultClusterParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_engine_default_cluster_parameters_input::Builder,
    }
    impl<C, M, R> DescribeEngineDefaultClusterParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEngineDefaultClusterParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEngineDefaultClusterParametersOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeEngineDefaultClusterParametersError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEngineDefaultClusterParametersInputOperationOutputAlias,
                crate::output::DescribeEngineDefaultClusterParametersOutput,
                crate::error::DescribeEngineDefaultClusterParametersError,
                crate::input::DescribeEngineDefaultClusterParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster parameter group family to return engine parameter information
        /// for.</p>
        pub fn db_parameter_group_family(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_family(inp);
            self
        }
        /// <p>The name of the DB cluster parameter group family to return engine parameter information
        /// for.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_family(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeEngineDefaultClusterParameters</code> request. If this parameter is specified,
        /// the response includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeEngineDefaultClusterParameters</code> request. If this parameter is specified,
        /// the response includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEngineDefaultParameters`.
    ///
    /// <p>Returns the default engine and system parameter information for the specified database
    /// engine.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEngineDefaultParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_engine_default_parameters_input::Builder,
    }
    impl<C, M, R> DescribeEngineDefaultParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEngineDefaultParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEngineDefaultParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEngineDefaultParametersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEngineDefaultParametersInputOperationOutputAlias,
                crate::output::DescribeEngineDefaultParametersOutput,
                crate::error::DescribeEngineDefaultParametersError,
                crate::input::DescribeEngineDefaultParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB parameter group family.</p>
        pub fn db_parameter_group_family(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_family(inp);
            self
        }
        /// <p>The name of the DB parameter group family.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_family(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeEngineDefaultParameters</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeEngineDefaultParameters</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventCategories`.
    ///
    /// <p>Displays a list of categories for all event source types, or, if specified, for a
    /// specified source type.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEventCategories<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_event_categories_input::Builder,
    }
    impl<C, M, R> DescribeEventCategories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEventCategories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventCategoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventCategoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventCategoriesInputOperationOutputAlias,
                crate::output::DescribeEventCategoriesOutput,
                crate::error::DescribeEventCategoriesError,
                crate::input::DescribeEventCategoriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of source that is generating the events.</p>
        /// <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>
        pub fn source_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p>The type of source that is generating the events.</p>
        /// <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEvents`.
    ///
    /// <p>Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter
    /// groups for the past 14 days. Events specific to a particular DB instance, DB security group,
    /// database snapshot, or DB parameter group can be obtained by providing the name as a parameter.
    /// By default, the past hour of events are returned.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_events_input::Builder,
    }
    impl<C, M, R> DescribeEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventsInputOperationOutputAlias,
                crate::output::DescribeEventsOutput,
                crate::error::DescribeEventsError,
                crate::input::DescribeEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the event source for which events are returned. If not specified, then
        /// all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If SourceIdentifier is supplied, SourceType must also be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBInstance</code>, then a
        /// <code>DBInstanceIdentifier</code> must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBSecurityGroup</code>, a <code>DBSecurityGroupName</code>
        /// must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBParameterGroup</code>, a
        /// <code>DBParameterGroupName</code> must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBSnapshot</code>, a <code>DBSnapshotIdentifier</code>
        /// must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn source_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_identifier(inp);
            self
        }
        /// <p>The identifier of the event source for which events are returned. If not specified, then
        /// all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If SourceIdentifier is supplied, SourceType must also be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBInstance</code>, then a
        /// <code>DBInstanceIdentifier</code> must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBSecurityGroup</code>, a <code>DBSecurityGroupName</code>
        /// must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBParameterGroup</code>, a
        /// <code>DBParameterGroupName</code> must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBSnapshot</code>, a <code>DBSnapshotIdentifier</code>
        /// must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_identifier(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are
        /// returned.</p>
        pub fn source_type(mut self, inp: crate::model::SourceType) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are
        /// returned.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// <p> The beginning of the time interval to retrieve events for, specified in ISO 8601 format.
        /// For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p> The beginning of the time interval to retrieve events for, specified in ISO 8601 format.
        /// For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p> The end of the time interval for which to retrieve events, specified in ISO 8601 format.
        /// For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p> The end of the time interval for which to retrieve events, specified in ISO 8601 format.
        /// For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The number of minutes to retrieve events for.</p>
        /// <p>Default: 60</p>
        pub fn duration(mut self, inp: i32) -> Self {
            self.inner = self.inner.duration(inp);
            self
        }
        /// <p>The number of minutes to retrieve events for.</p>
        /// <p>Default: 60</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>A list of event categories that trigger notifications for a event notification
        /// subscription.</p>
        pub fn event_categories(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(inp);
            self
        }
        /// <p>A list of event categories that trigger notifications for a event notification
        /// subscription.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeEvents request. If this
        /// parameter is specified, the response includes only records beyond the marker, up to the value
        /// specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeEvents request. If this
        /// parameter is specified, the response includes only records beyond the marker, up to the value
        /// specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventSubscriptions`.
    ///
    /// <p>Lists all the subscription descriptions for a customer account. The description for a
    /// subscription includes SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID,
    /// CreationTime, and Status.</p>
    /// <p>If you specify a SubscriptionName, lists the description for that subscription.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEventSubscriptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_event_subscriptions_input::Builder,
    }
    impl<C, M, R> DescribeEventSubscriptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEventSubscriptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventSubscriptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventSubscriptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventSubscriptionsInputOperationOutputAlias,
                crate::output::DescribeEventSubscriptionsOutput,
                crate::error::DescribeEventSubscriptionsError,
                crate::input::DescribeEventSubscriptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event notification subscription you want to describe.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the event notification subscription you want to describe.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrderableDBInstanceOptions`.
    ///
    /// <p>Returns a list of orderable DB instance options for the specified engine.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeOrderableDBInstanceOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_orderable_db_instance_options_input::Builder,
    }
    impl<C, M, R> DescribeOrderableDBInstanceOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrderableDBInstanceOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrderableDbInstanceOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeOrderableDBInstanceOptionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrderableDbInstanceOptionsInputOperationOutputAlias,
                crate::output::DescribeOrderableDbInstanceOptionsOutput,
                crate::error::DescribeOrderableDBInstanceOptionsError,
                crate::input::DescribeOrderableDbInstanceOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the engine to retrieve DB instance options for.</p>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The name of the engine to retrieve DB instance options for.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The engine version filter value. Specify this parameter to show only the available
        /// offerings matching the specified engine version.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The engine version filter value. Specify this parameter to show only the available
        /// offerings matching the specified engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The DB instance class filter value. Specify this parameter to show only the available
        /// offerings matching the specified DB instance class.</p>
        pub fn db_instance_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_class(inp);
            self
        }
        /// <p>The DB instance class filter value. Specify this parameter to show only the available
        /// offerings matching the specified DB instance class.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_class(input);
            self
        }
        /// <p>The license model filter value. Specify this parameter to show only the available
        /// offerings matching the specified license model.</p>
        pub fn license_model(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_model(inp);
            self
        }
        /// <p>The license model filter value. Specify this parameter to show only the available
        /// offerings matching the specified license model.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_model(input);
            self
        }
        /// <p>The VPC filter value. Specify this parameter to show only the available VPC or non-VPC
        /// offerings.</p>
        pub fn vpc(mut self, inp: bool) -> Self {
            self.inner = self.inner.vpc(inp);
            self
        }
        /// <p>The VPC filter value. Specify this parameter to show only the available VPC or non-VPC
        /// offerings.</p>
        pub fn set_vpc(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_vpc(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePendingMaintenanceActions`.
    ///
    /// <p>Returns a list of resources (for example, DB instances) that have at least one pending
    /// maintenance action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePendingMaintenanceActions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_pending_maintenance_actions_input::Builder,
    }
    impl<C, M, R> DescribePendingMaintenanceActions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePendingMaintenanceActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePendingMaintenanceActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePendingMaintenanceActionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePendingMaintenanceActionsInputOperationOutputAlias,
                crate::output::DescribePendingMaintenanceActionsOutput,
                crate::error::DescribePendingMaintenanceActionsError,
                crate::input::DescribePendingMaintenanceActionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of a resource to return pending maintenance actions for.</p>
        pub fn resource_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(inp);
            self
        }
        /// <p>The ARN of a resource to return pending maintenance actions for.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more resources to return pending maintenance actions
        /// for.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon
        /// Resource Names (ARNs). The results list will only include pending maintenance actions for
        /// the DB clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance ARNs.
        /// The results list will only include pending maintenance actions for the DB instances
        /// identified by these ARNs.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A filter that specifies one or more resources to return pending maintenance actions
        /// for.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon
        /// Resource Names (ARNs). The results list will only include pending maintenance actions for
        /// the DB clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance ARNs.
        /// The results list will only include pending maintenance actions for the DB instances
        /// identified by these ARNs.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to a number of records specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to a number of records specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeValidDBInstanceModifications`.
    ///
    /// <p>You can call <a>DescribeValidDBInstanceModifications</a>
    /// to learn what modifications you can make to your DB instance. You can use this
    /// information when you call <a>ModifyDBInstance</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeValidDBInstanceModifications<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_valid_db_instance_modifications_input::Builder,
    }
    impl<C, M, R> DescribeValidDBInstanceModifications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeValidDBInstanceModifications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeValidDbInstanceModificationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeValidDBInstanceModificationsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeValidDbInstanceModificationsInputOperationOutputAlias,
                crate::output::DescribeValidDbInstanceModificationsOutput,
                crate::error::DescribeValidDBInstanceModificationsError,
                crate::input::DescribeValidDbInstanceModificationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The customer identifier or the ARN of your DB instance.</p>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The customer identifier or the ARN of your DB instance.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `FailoverDBCluster`.
    ///
    /// <p>Forces a failover for a DB cluster.</p>
    /// <p>A failover for a DB cluster promotes one of the Read Replicas (read-only instances) in the
    /// DB cluster to be the primary instance (the cluster writer).</p>
    /// <p>Amazon Neptune will automatically fail over to a Read Replica, if one exists, when the
    /// primary instance fails. You can force a failover when you want to simulate a failure of a
    /// primary instance for testing. Because each instance in a DB cluster has its own endpoint
    /// address, you will need to clean up and re-establish any existing connections that use those
    /// endpoint addresses when the failover is complete.</p>
    #[derive(std::fmt::Debug)]
    pub struct FailoverDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::failover_db_cluster_input::Builder,
    }
    impl<C, M, R> FailoverDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `FailoverDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::FailoverDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::FailoverDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::FailoverDbClusterInputOperationOutputAlias,
                crate::output::FailoverDbClusterOutput,
                crate::error::FailoverDBClusterError,
                crate::input::FailoverDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A DB cluster identifier to force a failover for. This parameter is not
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>A DB cluster identifier to force a failover for. This parameter is not
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The name of the instance to promote to the primary instance.</p>
        /// <p>You must specify the instance identifier for an Read Replica in the DB cluster. For
        /// example, <code>mydbcluster-replica1</code>.</p>
        pub fn target_db_instance_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_db_instance_identifier(inp);
            self
        }
        /// <p>The name of the instance to promote to the primary instance.</p>
        /// <p>You must specify the instance identifier for an Read Replica in the DB cluster. For
        /// example, <code>mydbcluster-replica1</code>.</p>
        pub fn set_target_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_instance_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags on an Amazon Neptune resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Neptune resource with tags to be listed. This value is an Amazon Resource Name
        /// (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The Amazon Neptune resource with tags to be listed. This value is an Amazon Resource Name
        /// (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBCluster`.
    ///
    /// <p>Modify a setting for a DB cluster. You can change one or more database configuration
    /// parameters by specifying these parameters and the new values in the request.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_db_cluster_input::Builder,
    }
    impl<C, M, R> ModifyDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyDbClusterInputOperationOutputAlias,
                crate::output::ModifyDbClusterOutput,
                crate::error::ModifyDBClusterError,
                crate::input::ModifyDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB cluster identifier for the cluster being modified. This parameter is not
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The DB cluster identifier for the cluster being modified. This parameter is not
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is
        /// stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster2</code>
        /// </p>
        pub fn new_db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_db_cluster_identifier(inp);
            self
        }
        /// <p>The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is
        /// stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster2</code>
        /// </p>
        pub fn set_new_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_db_cluster_identifier(input);
            self
        }
        /// <p>A value that specifies whether the modifications in this request and any pending
        /// modifications are asynchronously applied as soon as possible, regardless of the
        /// <code>PreferredMaintenanceWindow</code> setting for the DB cluster. If this parameter is set
        /// to <code>false</code>, changes to the DB cluster are applied during the next maintenance
        /// window.</p>
        /// <p>The <code>ApplyImmediately</code> parameter only affects <code>NewDBClusterIdentifier</code>
        /// values. If you set the <code>ApplyImmediately</code> parameter value to false, then changes to
        /// <code>NewDBClusterIdentifier</code> values are applied during the next maintenance window.
        /// All other changes are applied immediately, regardless of the value of the
        /// <code>ApplyImmediately</code> parameter.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn apply_immediately(mut self, inp: bool) -> Self {
            self.inner = self.inner.apply_immediately(inp);
            self
        }
        /// <p>A value that specifies whether the modifications in this request and any pending
        /// modifications are asynchronously applied as soon as possible, regardless of the
        /// <code>PreferredMaintenanceWindow</code> setting for the DB cluster. If this parameter is set
        /// to <code>false</code>, changes to the DB cluster are applied during the next maintenance
        /// window.</p>
        /// <p>The <code>ApplyImmediately</code> parameter only affects <code>NewDBClusterIdentifier</code>
        /// values. If you set the <code>ApplyImmediately</code> parameter value to false, then changes to
        /// <code>NewDBClusterIdentifier</code> values are applied during the next maintenance window.
        /// All other changes are applied immediately, regardless of the value of the
        /// <code>ApplyImmediately</code> parameter.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_immediately(input);
            self
        }
        /// <p>The number of days for which automated backups are retained. You must specify a minimum
        /// value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 1 to 35</p>
        /// </li>
        /// </ul>
        pub fn backup_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.backup_retention_period(inp);
            self
        }
        /// <p>The number of days for which automated backups are retained. You must specify a minimum
        /// value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 1 to 35</p>
        /// </li>
        /// </ul>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_backup_retention_period(input);
            self
        }
        /// <p>The name of the DB cluster parameter group to use for the DB cluster.</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB cluster parameter group to use for the DB cluster.</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of VPC security groups that the DB cluster will belong to.</p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p>A list of VPC security groups that the DB cluster will belong to.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>The port number on which the DB cluster accepts connections.</p>
        /// <p>Constraints: Value must be <code>1150-65535</code>
        /// </p>
        /// <p>Default: The same port as the original DB cluster.</p>
        pub fn port(mut self, inp: i32) -> Self {
            self.inner = self.inner.port(inp);
            self
        }
        /// <p>The port number on which the DB cluster accepts connections.</p>
        /// <p>Constraints: Value must be <code>1150-65535</code>
        /// </p>
        /// <p>Default: The same port as the original DB cluster.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_user_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(inp);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// <p>
        /// <i>Not supported by Neptune.</i>
        /// </p>
        pub fn option_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(inp);
            self
        }
        /// <p>
        /// <i>Not supported by Neptune.</i>
        /// </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are
        /// enabled, using the <code>BackupRetentionPeriod</code> parameter.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_backup_window(inp);
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are
        /// enabled, using the <code>BackupRetentionPeriod</code> parameter.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_backup_window(input);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated
        /// Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region, occurring on a random day of the
        /// week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_maintenance_window(inp);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated
        /// Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region, occurring on a random day of the
        /// week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
        /// accounts, and otherwise false.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn enable_iam_database_authentication(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_iam_database_authentication(inp);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
        /// accounts, and otherwise false.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_iam_database_authentication(input);
            self
        }
        /// <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs
        /// for a specific DB cluster.</p>
        pub fn cloudwatch_logs_export_configuration(
            mut self,
            inp: crate::model::CloudwatchLogsExportConfiguration,
        ) -> Self {
            self.inner = self.inner.cloudwatch_logs_export_configuration(inp);
            self
        }
        /// <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs
        /// for a specific DB cluster.</p>
        pub fn set_cloudwatch_logs_export_configuration(
            mut self,
            input: std::option::Option<crate::model::CloudwatchLogsExportConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_cloudwatch_logs_export_configuration(input);
            self
        }
        /// <p>The version number of the database engine to which you want to upgrade. Changing this
        /// parameter results in an outage. The change is applied during the next maintenance window
        /// unless the <code>ApplyImmediately</code> parameter is set to true.</p>
        /// <p>For a list of valid engine versions, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/engine-releases.html">Engine Releases for Amazon
        /// Neptune</a>, or call <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-other-apis.html#DescribeDBEngineVersions">DescribeDBEngineVersions</a>.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The version number of the database engine to which you want to upgrade. Changing this
        /// parameter results in an outage. The change is applied during the next maintenance window
        /// unless the <code>ApplyImmediately</code> parameter is set to true.</p>
        /// <p>For a list of valid engine versions, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/engine-releases.html">Engine Releases for Amazon
        /// Neptune</a>, or call <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-other-apis.html#DescribeDBEngineVersions">DescribeDBEngineVersions</a>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>A value that indicates whether upgrades between different major versions are allowed.</p>
        /// <p>Constraints: You must set the allow-major-version-upgrade flag when providing an
        /// <code>EngineVersion</code> parameter that uses a different major version than the DB cluster's current
        /// version.</p>
        pub fn allow_major_version_upgrade(mut self, inp: bool) -> Self {
            self.inner = self.inner.allow_major_version_upgrade(inp);
            self
        }
        /// <p>A value that indicates whether upgrades between different major versions are allowed.</p>
        /// <p>Constraints: You must set the allow-major-version-upgrade flag when providing an
        /// <code>EngineVersion</code> parameter that uses a different major version than the DB cluster's current
        /// version.</p>
        pub fn set_allow_major_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_major_version_upgrade(input);
            self
        }
        /// <p>The name of the DB parameter group to apply to all instances of the DB cluster. </p>
        /// <note>
        /// <p>When you apply a parameter group using <code>DBInstanceParameterGroupName</code>,
        /// parameter changes aren't applied during the next maintenance window but instead are
        /// applied immediately.</p>
        /// </note>
        /// <p>Default: The existing name setting</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>The DB parameter group must be in the same DB parameter group family as
        /// the target DB cluster version.</p>
        /// </li>
        /// <li>
        /// <p>The <code>DBInstanceParameterGroupName</code> parameter is only valid in combination with
        /// the <code>AllowMajorVersionUpgrade</code> parameter.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_instance_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB parameter group to apply to all instances of the DB cluster. </p>
        /// <note>
        /// <p>When you apply a parameter group using <code>DBInstanceParameterGroupName</code>,
        /// parameter changes aren't applied during the next maintenance window but instead are
        /// applied immediately.</p>
        /// </note>
        /// <p>Default: The existing name setting</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>The DB parameter group must be in the same DB parameter group family as
        /// the target DB cluster version.</p>
        /// </li>
        /// <li>
        /// <p>The <code>DBInstanceParameterGroupName</code> parameter is only valid in combination with
        /// the <code>AllowMajorVersionUpgrade</code> parameter.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_parameter_group_name(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled.</p>
        pub fn deletion_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.deletion_protection(inp);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
        /// <p>
        /// <i>If set to <code>true</code>, tags are copied to any snapshot of
        /// the DB cluster that is created.</i>
        /// </p>
        pub fn copy_tags_to_snapshot(mut self, inp: bool) -> Self {
            self.inner = self.inner.copy_tags_to_snapshot(inp);
            self
        }
        /// <p>
        /// <i>If set to <code>true</code>, tags are copied to any snapshot of
        /// the DB cluster that is created.</i>
        /// </p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags_to_snapshot(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBClusterEndpoint`.
    ///
    /// <p>Modifies the properties of an endpoint in an Amazon Neptune DB cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyDBClusterEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_db_cluster_endpoint_input::Builder,
    }
    impl<C, M, R> ModifyDBClusterEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyDBClusterEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDbClusterEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyDbClusterEndpointInputOperationOutputAlias,
                crate::output::ModifyDbClusterEndpointOutput,
                crate::error::ModifyDBClusterEndpointError,
                crate::input::ModifyDbClusterEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the endpoint to modify. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_endpoint_identifier(inp);
            self
        }
        /// <p>The identifier of the endpoint to modify. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_endpoint_identifier(input);
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn endpoint_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_type(inp);
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_type(input);
            self
        }
        /// Appends an item to `StaticMembers`.
        ///
        /// To override the contents of this collection use [`set_static_members`](Self::set_static_members).
        ///
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn static_members(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.static_members(inp);
            self
        }
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn set_static_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_static_members(input);
            self
        }
        /// Appends an item to `ExcludedMembers`.
        ///
        /// To override the contents of this collection use [`set_excluded_members`](Self::set_excluded_members).
        ///
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
        /// All other eligible instances are reachable through the custom endpoint.
        /// Only relevant if the list of static members is empty.</p>
        pub fn excluded_members(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.excluded_members(inp);
            self
        }
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
        /// All other eligible instances are reachable through the custom endpoint.
        /// Only relevant if the list of static members is empty.</p>
        pub fn set_excluded_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_excluded_members(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBClusterParameterGroup`.
    ///
    /// <p> Modifies the parameters of a DB cluster parameter group. To modify more than one
    /// parameter, submit a list of the following: <code>ParameterName</code>,
    /// <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20 parameters can be
    /// modified in a single request.</p>
    ///
    /// <note>
    /// <p>Changes to dynamic parameters are applied immediately. Changes to static parameters
    /// require a reboot without failover to the DB cluster associated with the parameter group
    /// before the change can take effect.</p>
    /// </note>
    /// <important>
    /// <p>After you create a DB cluster parameter group, you should wait at least 5 minutes before
    /// creating your first DB cluster that uses that DB cluster parameter group as the default
    /// parameter group. This allows Amazon Neptune to fully complete the create action before the
    /// parameter group is used as the default for a new DB cluster. This is especially important
    /// for parameters that are critical when creating the default database for a DB cluster, such
    /// as the character set for the default database defined by the
    /// <code>character_set_database</code> parameter. You can use the <i>Parameter
    /// Groups</i> option of the Amazon Neptune console or the <a>DescribeDBClusterParameters</a> command to verify that your DB cluster parameter
    /// group has been created or modified.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct ModifyDBClusterParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_db_cluster_parameter_group_input::Builder,
    }
    impl<C, M, R> ModifyDBClusterParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyDbClusterParameterGroupInputOperationOutputAlias,
                crate::output::ModifyDbClusterParameterGroupOutput,
                crate::error::ModifyDBClusterParameterGroupError,
                crate::input::ModifyDbClusterParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster parameter group to modify.</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB cluster parameter group to modify.</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of parameters in the DB cluster parameter group to modify.</p>
        pub fn parameters(mut self, inp: impl Into<crate::model::Parameter>) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>A list of parameters in the DB cluster parameter group to modify.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBClusterSnapshotAttribute`.
    ///
    /// <p>Adds an attribute and values to, or removes an attribute and values from, a manual DB
    /// cluster snapshot.</p>
    /// <p>To share a manual DB cluster snapshot with other Amazon accounts, specify
    /// <code>restore</code> as the <code>AttributeName</code> and use the <code>ValuesToAdd</code>
    /// parameter to add a list of IDs of the Amazon accounts that are authorized to restore the manual
    /// DB cluster snapshot. Use the value <code>all</code> to make the manual DB cluster snapshot
    /// public, which means that it can be copied or restored by all Amazon accounts. Do not add the
    /// <code>all</code> value for any manual DB cluster snapshots that contain private information
    /// that you don't want available to all Amazon accounts. If a manual DB cluster snapshot is
    /// encrypted, it can be shared, but only by specifying a list of authorized Amazon account IDs for
    /// the <code>ValuesToAdd</code> parameter. You can't use <code>all</code> as a value for that
    /// parameter in this case.</p>
    /// <p>To view which Amazon accounts have access to copy or restore a manual DB cluster snapshot, or
    /// whether a manual DB cluster snapshot public or private, use the <a>DescribeDBClusterSnapshotAttributes</a> API action.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyDBClusterSnapshotAttribute<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_db_cluster_snapshot_attribute_input::Builder,
    }
    impl<C, M, R> ModifyDBClusterSnapshotAttribute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyDBClusterSnapshotAttribute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDbClusterSnapshotAttributeOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterSnapshotAttributeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyDbClusterSnapshotAttributeInputOperationOutputAlias,
                crate::output::ModifyDbClusterSnapshotAttributeOutput,
                crate::error::ModifyDBClusterSnapshotAttributeError,
                crate::input::ModifyDbClusterSnapshotAttributeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the DB cluster snapshot to modify the attributes for.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier for the DB cluster snapshot to modify the attributes for.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The name of the DB cluster snapshot attribute to modify.</p>
        /// <p>To manage authorization for other Amazon accounts to copy or restore a manual DB cluster
        /// snapshot, set this value to <code>restore</code>.</p>
        pub fn attribute_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_name(inp);
            self
        }
        /// <p>The name of the DB cluster snapshot attribute to modify.</p>
        /// <p>To manage authorization for other Amazon accounts to copy or restore a manual DB cluster
        /// snapshot, set this value to <code>restore</code>.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attribute_name(input);
            self
        }
        /// Appends an item to `ValuesToAdd`.
        ///
        /// To override the contents of this collection use [`set_values_to_add`](Self::set_values_to_add).
        ///
        /// <p>A list of DB cluster snapshot attributes to add to the attribute specified by
        /// <code>AttributeName</code>.</p>
        /// <p>To authorize other Amazon accounts to copy or restore a manual DB cluster snapshot, set this
        /// list to include one or more Amazon account IDs, or <code>all</code> to make the manual DB cluster
        /// snapshot restorable by any Amazon account. Do not add the <code>all</code> value for any manual
        /// DB cluster snapshots that contain private information that you don't want available to all Amazon
        /// accounts.</p>
        pub fn values_to_add(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.values_to_add(inp);
            self
        }
        /// <p>A list of DB cluster snapshot attributes to add to the attribute specified by
        /// <code>AttributeName</code>.</p>
        /// <p>To authorize other Amazon accounts to copy or restore a manual DB cluster snapshot, set this
        /// list to include one or more Amazon account IDs, or <code>all</code> to make the manual DB cluster
        /// snapshot restorable by any Amazon account. Do not add the <code>all</code> value for any manual
        /// DB cluster snapshots that contain private information that you don't want available to all Amazon
        /// accounts.</p>
        pub fn set_values_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_values_to_add(input);
            self
        }
        /// Appends an item to `ValuesToRemove`.
        ///
        /// To override the contents of this collection use [`set_values_to_remove`](Self::set_values_to_remove).
        ///
        /// <p>A list of DB cluster snapshot attributes to remove from the attribute specified by
        /// <code>AttributeName</code>.</p>
        /// <p>To remove authorization for other Amazon accounts to copy or restore a manual DB cluster
        /// snapshot, set this list to include one or more Amazon account identifiers, or <code>all</code> to
        /// remove authorization for any Amazon account to copy or restore the DB cluster snapshot. If you
        /// specify <code>all</code>, an Amazon account whose account ID is explicitly added to the
        /// <code>restore</code> attribute can still copy or restore a manual DB cluster snapshot.</p>
        pub fn values_to_remove(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.values_to_remove(inp);
            self
        }
        /// <p>A list of DB cluster snapshot attributes to remove from the attribute specified by
        /// <code>AttributeName</code>.</p>
        /// <p>To remove authorization for other Amazon accounts to copy or restore a manual DB cluster
        /// snapshot, set this list to include one or more Amazon account identifiers, or <code>all</code> to
        /// remove authorization for any Amazon account to copy or restore the DB cluster snapshot. If you
        /// specify <code>all</code>, an Amazon account whose account ID is explicitly added to the
        /// <code>restore</code> attribute can still copy or restore a manual DB cluster snapshot.</p>
        pub fn set_values_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_values_to_remove(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBInstance`.
    ///
    /// <p>Modifies settings for a DB instance. You can change one or more database configuration
    /// parameters by specifying these parameters and the new values in the request. To learn what
    /// modifications you can make to your DB instance, call <a>DescribeValidDBInstanceModifications</a> before you call <a>ModifyDBInstance</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyDBInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_db_instance_input::Builder,
    }
    impl<C, M, R> ModifyDBInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyDBInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDbInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDBInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyDbInstanceInputOperationOutputAlias,
                crate::output::ModifyDbInstanceOutput,
                crate::error::ModifyDBInstanceError,
                crate::input::ModifyDbInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB instance identifier. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The DB instance identifier. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn allocated_storage(mut self, inp: i32) -> Self {
            self.inner = self.inner.allocated_storage(inp);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_allocated_storage(input);
            self
        }
        /// <p>The new compute and memory capacity of the DB instance, for example,
        /// <code>db.m4.large</code>. Not all DB instance classes are available in all Amazon
        /// Regions.</p>
        /// <p>If you modify the DB instance class, an outage occurs during the change. The change is
        /// applied during the next maintenance window, unless <code>ApplyImmediately</code> is specified
        /// as <code>true</code> for this request.</p>
        /// <p>Default: Uses existing setting</p>
        pub fn db_instance_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_class(inp);
            self
        }
        /// <p>The new compute and memory capacity of the DB instance, for example,
        /// <code>db.m4.large</code>. Not all DB instance classes are available in all Amazon
        /// Regions.</p>
        /// <p>If you modify the DB instance class, an outage occurs during the change. The change is
        /// applied during the next maintenance window, unless <code>ApplyImmediately</code> is specified
        /// as <code>true</code> for this request.</p>
        /// <p>Default: Uses existing setting</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_class(input);
            self
        }
        /// <p>The new DB subnet group for the DB instance. You can use this parameter to move your DB
        /// instance to a different VPC.</p>
        /// <p>Changing the subnet group causes an outage during the change. The change is applied during
        /// the next maintenance window, unless you specify <code>true</code> for the
        /// <code>ApplyImmediately</code> parameter.</p>
        /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// <p>Example: <code>mySubnetGroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>The new DB subnet group for the DB instance. You can use this parameter to move your DB
        /// instance to a different VPC.</p>
        /// <p>Changing the subnet group causes an outage during the change. The change is applied during
        /// the next maintenance window, unless you specify <code>true</code> for the
        /// <code>ApplyImmediately</code> parameter.</p>
        /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// <p>Example: <code>mySubnetGroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// Appends an item to `DBSecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_db_security_groups`](Self::set_db_security_groups).
        ///
        /// <p>A list of DB security groups to authorize on this DB instance. Changing this setting
        /// doesn't result in an outage and the change is asynchronously applied as soon as
        /// possible.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match existing DBSecurityGroups.</p>
        /// </li>
        /// </ul>
        pub fn db_security_groups(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_security_groups(inp);
            self
        }
        /// <p>A list of DB security groups to authorize on this DB instance. Changing this setting
        /// doesn't result in an outage and the change is asynchronously applied as soon as
        /// possible.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match existing DBSecurityGroups.</p>
        /// </li>
        /// </ul>
        pub fn set_db_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_db_security_groups(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of EC2 VPC security groups to authorize on this DB instance. This change is
        /// asynchronously applied as soon as possible.</p>
        /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB
        /// cluster. For more information, see <a>ModifyDBCluster</a>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match existing VpcSecurityGroupIds.</p>
        /// </li>
        /// </ul>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p>A list of EC2 VPC security groups to authorize on this DB instance. This change is
        /// asynchronously applied as soon as possible.</p>
        /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB
        /// cluster. For more information, see <a>ModifyDBCluster</a>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match existing VpcSecurityGroupIds.</p>
        /// </li>
        /// </ul>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>Specifies whether the modifications in this request and any pending modifications are
        /// asynchronously applied as soon as possible, regardless of the
        /// <code>PreferredMaintenanceWindow</code> setting for the DB instance.</p>
        /// <p> If this parameter is set to <code>false</code>, changes to the DB instance are applied
        /// during the next maintenance window. Some parameter changes can cause an outage and are applied
        /// on the next call to <a>RebootDBInstance</a>, or the next
        /// failure reboot.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn apply_immediately(mut self, inp: bool) -> Self {
            self.inner = self.inner.apply_immediately(inp);
            self
        }
        /// <p>Specifies whether the modifications in this request and any pending modifications are
        /// asynchronously applied as soon as possible, regardless of the
        /// <code>PreferredMaintenanceWindow</code> setting for the DB instance.</p>
        /// <p> If this parameter is set to <code>false</code>, changes to the DB instance are applied
        /// during the next maintenance window. Some parameter changes can cause an outage and are applied
        /// on the next call to <a>RebootDBInstance</a>, or the next
        /// failure reboot.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_immediately(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_user_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(inp);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// <p>The name of the DB parameter group to apply to the DB instance. Changing this setting
        /// doesn't result in an outage. The parameter group name itself is changed immediately, but the
        /// actual parameter changes are not applied until you reboot the instance without failover. The
        /// db instance will NOT be rebooted automatically and the parameter changes will NOT be applied
        /// during the next maintenance window.</p>
        /// <p>Default: Uses existing setting</p>
        /// <p>Constraints: The DB parameter group must be in the same DB parameter group family as this
        /// DB instance.</p>
        pub fn db_parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB parameter group to apply to the DB instance. Changing this setting
        /// doesn't result in an outage. The parameter group name itself is changed immediately, but the
        /// actual parameter changes are not applied until you reboot the instance without failover. The
        /// db instance will NOT be rebooted automatically and the parameter changes will NOT be applied
        /// during the next maintenance window.</p>
        /// <p>Default: Uses existing setting</p>
        /// <p>Constraints: The DB parameter group must be in the same DB parameter group family as this
        /// DB instance.</p>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster.
        /// For more information, see <a>ModifyDBCluster</a>.</p>
        /// <p>Default: Uses existing setting</p>
        pub fn backup_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.backup_retention_period(inp);
            self
        }
        /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster.
        /// For more information, see <a>ModifyDBCluster</a>.</p>
        /// <p>Default: Uses existing setting</p>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_backup_retention_period(input);
            self
        }
        /// <p> The daily time range during which automated backups are created if automated backups are
        /// enabled.</p>
        /// <p>Not applicable. The daily time range for creating automated backups is managed by the DB
        /// cluster. For more information, see <a>ModifyDBCluster</a>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format hh24:mi-hh24:mi</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Time Coordinated (UTC)</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes</p>
        /// </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_backup_window(inp);
            self
        }
        /// <p> The daily time range during which automated backups are created if automated backups are
        /// enabled.</p>
        /// <p>Not applicable. The daily time range for creating automated backups is managed by the DB
        /// cluster. For more information, see <a>ModifyDBCluster</a>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format hh24:mi-hh24:mi</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Time Coordinated (UTC)</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes</p>
        /// </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_backup_window(input);
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might
        /// result in an outage. Changing this parameter doesn't result in an outage, except in the
        /// following situation, and the change is asynchronously applied as soon as possible. If there
        /// are pending actions that cause a reboot, and the maintenance window is changed to include the
        /// current time, then changing this parameter will cause a reboot of the DB instance. If moving
        /// this window to the current time, there must be at least 30 minutes between the current time
        /// and end of the window to ensure pending changes are applied.</p>
        /// <p>Default: Uses existing setting</p>
        /// <p>Format: ddd:hh24:mi-ddd:hh24:mi</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Must be at least 30 minutes</p>
        pub fn preferred_maintenance_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_maintenance_window(inp);
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might
        /// result in an outage. Changing this parameter doesn't result in an outage, except in the
        /// following situation, and the change is asynchronously applied as soon as possible. If there
        /// are pending actions that cause a reboot, and the maintenance window is changed to include the
        /// current time, then changing this parameter will cause a reboot of the DB instance. If moving
        /// this window to the current time, there must be at least 30 minutes between the current time
        /// and end of the window to ensure pending changes are applied.</p>
        /// <p>Default: Uses existing setting</p>
        /// <p>Format: ddd:hh24:mi-ddd:hh24:mi</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Must be at least 30 minutes</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter doesn't
        /// result in an outage and the change is applied during the next maintenance window unless the
        /// <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request.</p>
        pub fn multi_az(mut self, inp: bool) -> Self {
            self.inner = self.inner.multi_az(inp);
            self
        }
        /// <p>Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter doesn't
        /// result in an outage and the change is applied during the next maintenance window unless the
        /// <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_multi_az(input);
            self
        }
        /// <p>The version number of the database engine to upgrade to. Currently, setting this
        /// parameter has no effect. To upgrade your database engine to the most recent release,
        /// use the <a>ApplyPendingMaintenanceAction</a> API.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The version number of the database engine to upgrade to. Currently, setting this
        /// parameter has no effect. To upgrade your database engine to the most recent release,
        /// use the <a>ApplyPendingMaintenanceAction</a> API.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>Indicates that major version upgrades are allowed. Changing this parameter doesn't result
        /// in an outage and the change is asynchronously applied as soon as possible.</p>
        pub fn allow_major_version_upgrade(mut self, inp: bool) -> Self {
            self.inner = self.inner.allow_major_version_upgrade(inp);
            self
        }
        /// <p>Indicates that major version upgrades are allowed. Changing this parameter doesn't result
        /// in an outage and the change is asynchronously applied as soon as possible.</p>
        pub fn set_allow_major_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_major_version_upgrade(input);
            self
        }
        /// <p> Indicates that minor version upgrades are applied automatically to the DB instance during
        /// the maintenance window. Changing this parameter doesn't result in an outage except in the
        /// following case and the change is asynchronously applied as soon as possible. An outage will
        /// result if this parameter is set to <code>true</code> during the maintenance window, and a
        /// newer minor version is available, and Neptune has enabled auto patching for that engine
        /// version.</p>
        pub fn auto_minor_version_upgrade(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(inp);
            self
        }
        /// <p> Indicates that minor version upgrades are applied automatically to the DB instance during
        /// the maintenance window. Changing this parameter doesn't result in an outage except in the
        /// following case and the change is asynchronously applied as soon as possible. An outage will
        /// result if this parameter is set to <code>true</code> during the maintenance window, and a
        /// newer minor version is available, and Neptune has enabled auto patching for that engine
        /// version.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn license_model(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_model(inp);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_model(input);
            self
        }
        /// <p>The new Provisioned IOPS (I/O operations per second) value for the instance.</p>
        /// <p>Changing this setting doesn't result in an outage and the change is applied during the
        /// next maintenance window unless the <code>ApplyImmediately</code> parameter is set to
        /// <code>true</code> for this request.</p>
        /// <p>Default: Uses existing setting</p>
        pub fn iops(mut self, inp: i32) -> Self {
            self.inner = self.inner.iops(inp);
            self
        }
        /// <p>The new Provisioned IOPS (I/O operations per second) value for the instance.</p>
        /// <p>Changing this setting doesn't result in an outage and the change is applied during the
        /// next maintenance window unless the <code>ApplyImmediately</code> parameter is set to
        /// <code>true</code> for this request.</p>
        /// <p>Default: Uses existing setting</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_iops(input);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn option_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(inp);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// <p> The new DB instance identifier for the DB instance when renaming a DB instance. When you
        /// change the DB instance identifier, an instance reboot will occur immediately if you set
        /// <code>Apply Immediately</code> to true, or will occur during the next maintenance window if
        /// <code>Apply Immediately</code> to false. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code>
        /// </p>
        pub fn new_db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_db_instance_identifier(inp);
            self
        }
        /// <p> The new DB instance identifier for the DB instance when renaming a DB instance. When you
        /// change the DB instance identifier, an instance reboot will occur immediately if you set
        /// <code>Apply Immediately</code> to true, or will occur during the next maintenance window if
        /// <code>Apply Immediately</code> to false. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code>
        /// </p>
        pub fn set_new_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_db_instance_identifier(input);
            self
        }
        /// <p>Not supported.</p>
        pub fn storage_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.storage_type(inp);
            self
        }
        /// <p>Not supported.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_storage_type(input);
            self
        }
        /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
        pub fn tde_credential_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tde_credential_arn(inp);
            self
        }
        /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
        pub fn set_tde_credential_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tde_credential_arn(input);
            self
        }
        /// <p>The password for the given ARN from the key store in order to access the device.</p>
        pub fn tde_credential_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tde_credential_password(inp);
            self
        }
        /// <p>The password for the given ARN from the key store in order to access the device.</p>
        pub fn set_tde_credential_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tde_credential_password(input);
            self
        }
        /// <p>Indicates the certificate that needs to be associated with the instance.</p>
        pub fn ca_certificate_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ca_certificate_identifier(inp);
            self
        }
        /// <p>Indicates the certificate that needs to be associated with the instance.</p>
        pub fn set_ca_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ca_certificate_identifier(input);
            self
        }
        /// <p>Not supported.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>Not supported.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise
        /// false. The default is false.</p>
        pub fn copy_tags_to_snapshot(mut self, inp: bool) -> Self {
            self.inner = self.inner.copy_tags_to_snapshot(inp);
            self
        }
        /// <p>True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise
        /// false. The default is false.</p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags_to_snapshot(input);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected
        /// for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default
        /// is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must also set
        /// <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
        /// </p>
        pub fn monitoring_interval(mut self, inp: i32) -> Self {
            self.inner = self.inner.monitoring_interval(inp);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected
        /// for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default
        /// is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must also set
        /// <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
        /// </p>
        pub fn set_monitoring_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_monitoring_interval(input);
            self
        }
        /// <p>The port number on which the database accepts connections.</p>
        /// <p>The value of the <code>DBPortNumber</code> parameter must not match any of the port values
        /// specified for options in the option group for the DB instance.</p>
        /// <p>Your database will restart when you change the <code>DBPortNumber</code> value regardless
        /// of the value of the <code>ApplyImmediately</code> parameter.</p>
        /// <p> Default: <code>8182</code>
        /// </p>
        pub fn db_port_number(mut self, inp: i32) -> Self {
            self.inner = self.inner.db_port_number(inp);
            self
        }
        /// <p>The port number on which the database accepts connections.</p>
        /// <p>The value of the <code>DBPortNumber</code> parameter must not match any of the port values
        /// specified for options in the option group for the DB instance.</p>
        /// <p>Your database will restart when you change the <code>DBPortNumber</code> value regardless
        /// of the value of the <code>ApplyImmediately</code> parameter.</p>
        /// <p> Default: <code>8182</code>
        /// </p>
        pub fn set_db_port_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_db_port_number(input);
            self
        }
        /// <p>This flag should no longer be used.</p>
        pub fn publicly_accessible(mut self, inp: bool) -> Self {
            self.inner = self.inner.publicly_accessible(inp);
            self
        }
        /// <p>This flag should no longer be used.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_accessible(input);
            self
        }
        /// <p>The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to
        /// Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
        /// <code>MonitoringRoleArn</code> value.</p>
        pub fn monitoring_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.monitoring_role_arn(inp);
            self
        }
        /// <p>The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to
        /// Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
        /// <code>MonitoringRoleArn</code> value.</p>
        pub fn set_monitoring_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_monitoring_role_arn(input);
            self
        }
        /// <p>Not supported</p>
        pub fn domain_iam_role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_iam_role_name(inp);
            self
        }
        /// <p>Not supported</p>
        pub fn set_domain_iam_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_domain_iam_role_name(input);
            self
        }
        /// <p>A value that specifies the order in which a Read Replica is promoted to the primary
        /// instance after a failure of the existing primary instance.</p>
        /// <p>Default: 1</p>
        /// <p>Valid Values: 0 - 15</p>
        pub fn promotion_tier(mut self, inp: i32) -> Self {
            self.inner = self.inner.promotion_tier(inp);
            self
        }
        /// <p>A value that specifies the order in which a Read Replica is promoted to the primary
        /// instance after a failure of the existing primary instance.</p>
        /// <p>Default: 1</p>
        /// <p>Valid Values: 0 - 15</p>
        pub fn set_promotion_tier(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_promotion_tier(input);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
        /// accounts, and otherwise false.</p>
        /// <p>You can enable IAM database authentication for the following database engines</p>
        /// <p>Not applicable. Mapping Amazon IAM accounts to database accounts is managed by the DB
        /// cluster. For more information, see <a>ModifyDBCluster</a>.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn enable_iam_database_authentication(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_iam_database_authentication(inp);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
        /// accounts, and otherwise false.</p>
        /// <p>You can enable IAM database authentication for the following database engines</p>
        /// <p>Not applicable. Mapping Amazon IAM accounts to database accounts is managed by the DB
        /// cluster. For more information, see <a>ModifyDBCluster</a>.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_iam_database_authentication(input);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn enable_performance_insights(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_performance_insights(inp);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_enable_performance_insights(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_performance_insights(input);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn performance_insights_kms_key_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.performance_insights_kms_key_id(inp);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_performance_insights_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_performance_insights_kms_key_id(input);
            self
        }
        /// <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs
        /// for a specific DB instance or DB cluster.</p>
        pub fn cloudwatch_logs_export_configuration(
            mut self,
            inp: crate::model::CloudwatchLogsExportConfiguration,
        ) -> Self {
            self.inner = self.inner.cloudwatch_logs_export_configuration(inp);
            self
        }
        /// <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs
        /// for a specific DB instance or DB cluster.</p>
        pub fn set_cloudwatch_logs_export_configuration(
            mut self,
            input: std::option::Option<crate::model::CloudwatchLogsExportConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_cloudwatch_logs_export_configuration(input);
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled.  See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting
        /// a DB Instance</a>.</p>
        pub fn deletion_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.deletion_protection(inp);
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled.  See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting
        /// a DB Instance</a>.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBParameterGroup`.
    ///
    /// <p>Modifies the parameters of a DB parameter group. To modify more than one parameter,
    /// submit a list of the following: <code>ParameterName</code>, <code>ParameterValue</code>, and
    /// <code>ApplyMethod</code>. A maximum of 20 parameters can be modified in a single request.</p>
    /// <note>
    /// <p>Changes to dynamic parameters are applied immediately. Changes to static parameters
    /// require a reboot without failover to the DB instance associated with the parameter group
    /// before the change can take effect.</p>
    /// </note>
    /// <important>
    /// <p>After you modify a DB parameter group, you should wait at least 5 minutes before
    /// creating your first DB instance that uses that DB parameter group as the default parameter
    /// group. This allows Amazon Neptune to fully complete the modify action before the parameter
    /// group is used as the default for a new DB instance. This is especially important for
    /// parameters that are critical when creating the default database for a DB instance, such as
    /// the character set for the default database defined by the
    /// <code>character_set_database</code> parameter. You can use the <i>Parameter
    /// Groups</i> option of the Amazon Neptune console or the
    /// <i>DescribeDBParameters</i> command to verify that your DB parameter group has
    /// been created or modified.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct ModifyDBParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_db_parameter_group_input::Builder,
    }
    impl<C, M, R> ModifyDBParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyDBParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDbParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDBParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyDbParameterGroupInputOperationOutputAlias,
                crate::output::ModifyDbParameterGroupOutput,
                crate::error::ModifyDBParameterGroupError,
                crate::input::ModifyDbParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>An array of parameter names, values, and the apply method for the parameter update. At
        /// least one parameter name, value, and apply method must be supplied; subsequent arguments are
        /// optional. A maximum of 20 parameters can be modified in a single request.</p>
        /// <p>Valid Values (for the application method): <code>immediate | pending-reboot</code>
        /// </p>
        /// <note>
        /// <p>You can use the immediate value with dynamic parameters only. You can use the
        /// pending-reboot value for both dynamic and static parameters, and changes are applied when
        /// you reboot the DB instance without failover.</p>
        /// </note>
        pub fn parameters(mut self, inp: impl Into<crate::model::Parameter>) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>An array of parameter names, values, and the apply method for the parameter update. At
        /// least one parameter name, value, and apply method must be supplied; subsequent arguments are
        /// optional. A maximum of 20 parameters can be modified in a single request.</p>
        /// <p>Valid Values (for the application method): <code>immediate | pending-reboot</code>
        /// </p>
        /// <note>
        /// <p>You can use the immediate value with dynamic parameters only. You can use the
        /// pending-reboot value for both dynamic and static parameters, and changes are applied when
        /// you reboot the DB instance without failover.</p>
        /// </note>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBSubnetGroup`.
    ///
    /// <p>Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in
    /// at least two AZs in the Amazon Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyDBSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_db_subnet_group_input::Builder,
    }
    impl<C, M, R> ModifyDBSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyDBSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDbSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDBSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyDbSubnetGroupInputOperationOutputAlias,
                crate::output::ModifyDbSubnetGroupOutput,
                crate::error::ModifyDBSubnetGroupError,
                crate::input::ModifyDbSubnetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the DB subnet group. This value is stored as a lowercase string. You can't
        /// modify the default subnet group.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>The name for the DB subnet group. This value is stored as a lowercase string. You can't
        /// modify the default subnet group.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p>The description for the DB subnet group.</p>
        pub fn db_subnet_group_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_description(inp);
            self
        }
        /// <p>The description for the DB subnet group.</p>
        pub fn set_db_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The EC2 subnet IDs for the DB subnet group.</p>
        pub fn subnet_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(inp);
            self
        }
        /// <p>The EC2 subnet IDs for the DB subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyEventSubscription`.
    ///
    /// <p>Modifies an existing event notification subscription. Note that you can't modify the
    /// source identifiers using this call; to change source identifiers for a subscription, use the
    /// <a>AddSourceIdentifierToSubscription</a> and <a>RemoveSourceIdentifierFromSubscription</a> calls.</p>
    /// <p>You can see a list of the event categories for a given SourceType
    /// by using the <b>DescribeEventCategories</b> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyEventSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_event_subscription_input::Builder,
    }
    impl<C, M, R> ModifyEventSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyEventSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyEventSubscriptionInputOperationOutputAlias,
                crate::output::ModifyEventSubscriptionOutput,
                crate::error::ModifyEventSubscriptionError,
                crate::input::ModifyEventSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event notification subscription.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the event notification subscription.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is
        /// created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn sns_topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is
        /// created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified
        /// of events generated by a DB instance, you would set this parameter to db-instance. if this
        /// value is not specified, all events are returned.</p>
        /// <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>
        pub fn source_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified
        /// of events generated by a DB instance, you would set this parameter to db-instance. if this
        /// value is not specified, all events are returned.</p>
        /// <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p> A list of event categories for a SourceType that you want to subscribe to. You can see a
        /// list of the categories for a given SourceType
        ///
        /// by using the <b>DescribeEventCategories</b> action.</p>
        pub fn event_categories(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(inp);
            self
        }
        /// <p> A list of event categories for a SourceType that you want to subscribe to. You can see a
        /// list of the categories for a given SourceType
        ///
        /// by using the <b>DescribeEventCategories</b> action.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// <p> A Boolean value; set to <b>true</b> to activate the
        /// subscription.</p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p> A Boolean value; set to <b>true</b> to activate the
        /// subscription.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PromoteReadReplicaDBCluster`.
    ///
    /// <p>Not supported.</p>
    #[derive(std::fmt::Debug)]
    pub struct PromoteReadReplicaDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::promote_read_replica_db_cluster_input::Builder,
    }
    impl<C, M, R> PromoteReadReplicaDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PromoteReadReplicaDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PromoteReadReplicaDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::PromoteReadReplicaDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PromoteReadReplicaDbClusterInputOperationOutputAlias,
                crate::output::PromoteReadReplicaDbClusterOutput,
                crate::error::PromoteReadReplicaDBClusterError,
                crate::input::PromoteReadReplicaDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Not supported.</p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>Not supported.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RebootDBInstance`.
    ///
    /// <p>You might need to reboot your DB instance, usually for maintenance reasons. For example,
    /// if you make certain modifications, or if you change the DB parameter group associated with the
    /// DB instance, you must reboot the instance for the changes to take effect.</p>
    /// <p>Rebooting a DB instance restarts the database engine service. Rebooting a DB instance
    /// results in a momentary outage, during which the DB instance status is set to rebooting.</p>
    #[derive(std::fmt::Debug)]
    pub struct RebootDBInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reboot_db_instance_input::Builder,
    }
    impl<C, M, R> RebootDBInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RebootDBInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RebootDbInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::RebootDBInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RebootDbInstanceInputOperationOutputAlias,
                crate::output::RebootDbInstanceOutput,
                crate::error::RebootDBInstanceError,
                crate::input::RebootDbInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p> When <code>true</code>, the reboot is conducted through a MultiAZ failover.</p>
        /// <p>Constraint: You can't specify <code>true</code> if the instance is not configured for
        /// MultiAZ.</p>
        pub fn force_failover(mut self, inp: bool) -> Self {
            self.inner = self.inner.force_failover(inp);
            self
        }
        /// <p> When <code>true</code>, the reboot is conducted through a MultiAZ failover.</p>
        /// <p>Constraint: You can't specify <code>true</code> if the instance is not configured for
        /// MultiAZ.</p>
        pub fn set_force_failover(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_failover(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveRoleFromDBCluster`.
    ///
    /// <p>Disassociates an Identity and Access Management (IAM) role from a DB cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveRoleFromDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_role_from_db_cluster_input::Builder,
    }
    impl<C, M, R> RemoveRoleFromDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveRoleFromDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveRoleFromDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveRoleFromDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveRoleFromDbClusterInputOperationOutputAlias,
                crate::output::RemoveRoleFromDbClusterOutput,
                crate::error::RemoveRoleFromDBClusterError,
                crate::input::RemoveRoleFromDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster to disassociate the IAM role from.</p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The name of the DB cluster to disassociate the IAM role from.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to disassociate from the DB cluster, for
        /// example <code>arn:aws:iam::123456789012:role/NeptuneAccessRole</code>.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to disassociate from the DB cluster, for
        /// example <code>arn:aws:iam::123456789012:role/NeptuneAccessRole</code>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The name of the feature for the DB cluster that the IAM role is to be disassociated from.
        /// For the list of supported feature names, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-other-apis.html#DescribeDBEngineVersions">DescribeDBEngineVersions</a>.</p>
        pub fn feature_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature_name(inp);
            self
        }
        /// <p>The name of the feature for the DB cluster that the IAM role is to be disassociated from.
        /// For the list of supported feature names, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-other-apis.html#DescribeDBEngineVersions">DescribeDBEngineVersions</a>.</p>
        pub fn set_feature_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feature_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveSourceIdentifierFromSubscription`.
    ///
    /// <p>Removes a source identifier from an existing event notification subscription.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveSourceIdentifierFromSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_source_identifier_from_subscription_input::Builder,
    }
    impl<C, M, R> RemoveSourceIdentifierFromSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveSourceIdentifierFromSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveSourceIdentifierFromSubscriptionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::RemoveSourceIdentifierFromSubscriptionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveSourceIdentifierFromSubscriptionInputOperationOutputAlias,
                crate::output::RemoveSourceIdentifierFromSubscriptionOutput,
                crate::error::RemoveSourceIdentifierFromSubscriptionError,
                crate::input::RemoveSourceIdentifierFromSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event notification subscription you want to remove a source identifier
        /// from.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the event notification subscription you want to remove a source identifier
        /// from.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p> The source identifier to be removed from the subscription, such as the <b>DB instance identifier</b> for a DB instance or the name of a security
        /// group.</p>
        pub fn source_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_identifier(inp);
            self
        }
        /// <p> The source identifier to be removed from the subscription, such as the <b>DB instance identifier</b> for a DB instance or the name of a security
        /// group.</p>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTagsFromResource`.
    ///
    /// <p>Removes metadata tags from an Amazon Neptune resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveTagsFromResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_tags_from_resource_input::Builder,
    }
    impl<C, M, R> RemoveTagsFromResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveTagsFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveTagsFromResourceInputOperationOutputAlias,
                crate::output::RemoveTagsFromResourceOutput,
                crate::error::RemoveTagsFromResourceError,
                crate::input::RemoveTagsFromResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Neptune resource that the tags are removed from. This value is an Amazon
        /// Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The Amazon Neptune resource that the tags are removed from. This value is an Amazon
        /// Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetDBClusterParameterGroup`.
    ///
    /// <p> Modifies the parameters of a DB cluster parameter group to the default value. To reset
    /// specific parameters submit a list of the following: <code>ParameterName</code> and
    /// <code>ApplyMethod</code>. To reset the entire DB cluster parameter group, specify the
    /// <code>DBClusterParameterGroupName</code> and <code>ResetAllParameters</code> parameters.</p>
    /// <p> When resetting the entire group, dynamic parameters are updated immediately and static
    /// parameters are set to <code>pending-reboot</code> to take effect on the next DB instance
    /// restart or <a>RebootDBInstance</a> request. You must call <a>RebootDBInstance</a> for every DB instance in your DB cluster
    /// that you want the updated static parameter to apply to.</p>
    #[derive(std::fmt::Debug)]
    pub struct ResetDBClusterParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_db_cluster_parameter_group_input::Builder,
    }
    impl<C, M, R> ResetDBClusterParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetDBClusterParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetDbClusterParameterGroupInputOperationOutputAlias,
                crate::output::ResetDbClusterParameterGroupOutput,
                crate::error::ResetDBClusterParameterGroupError,
                crate::input::ResetDbClusterParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster parameter group to reset.</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB cluster parameter group to reset.</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// <p>A value that is set to <code>true</code> to reset all parameters in the DB cluster
        /// parameter group to their default values, and <code>false</code> otherwise. You can't use this
        /// parameter if there is a list of parameter names specified for the <code>Parameters</code>
        /// parameter.</p>
        pub fn reset_all_parameters(mut self, inp: bool) -> Self {
            self.inner = self.inner.reset_all_parameters(inp);
            self
        }
        /// <p>A value that is set to <code>true</code> to reset all parameters in the DB cluster
        /// parameter group to their default values, and <code>false</code> otherwise. You can't use this
        /// parameter if there is a list of parameter names specified for the <code>Parameters</code>
        /// parameter.</p>
        pub fn set_reset_all_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reset_all_parameters(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of parameter names in the DB cluster parameter group to reset to the default
        /// values. You can't use this parameter if the <code>ResetAllParameters</code> parameter is set
        /// to <code>true</code>.</p>
        pub fn parameters(mut self, inp: impl Into<crate::model::Parameter>) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>A list of parameter names in the DB cluster parameter group to reset to the default
        /// values. You can't use this parameter if the <code>ResetAllParameters</code> parameter is set
        /// to <code>true</code>.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetDBParameterGroup`.
    ///
    /// <p>Modifies the parameters of a DB parameter group to the engine/system default value. To
    /// reset specific parameters, provide a list of the following: <code>ParameterName</code> and
    /// <code>ApplyMethod</code>. To reset the entire DB parameter group, specify the
    /// <code>DBParameterGroup</code> name and <code>ResetAllParameters</code> parameters. When
    /// resetting the entire group, dynamic parameters are updated immediately and static parameters
    /// are set to <code>pending-reboot</code> to take effect on the next DB instance restart or
    /// <code>RebootDBInstance</code> request.</p>
    #[derive(std::fmt::Debug)]
    pub struct ResetDBParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_db_parameter_group_input::Builder,
    }
    impl<C, M, R> ResetDBParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetDBParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetDbParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetDBParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetDbParameterGroupInputOperationOutputAlias,
                crate::output::ResetDbParameterGroupOutput,
                crate::error::ResetDBParameterGroupError,
                crate::input::ResetDbParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing DBParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing DBParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// <p>Specifies whether (<code>true</code>) or not (<code>false</code>) to reset all parameters
        /// in the DB parameter group to default values.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn reset_all_parameters(mut self, inp: bool) -> Self {
            self.inner = self.inner.reset_all_parameters(inp);
            self
        }
        /// <p>Specifies whether (<code>true</code>) or not (<code>false</code>) to reset all parameters
        /// in the DB parameter group to default values.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn set_reset_all_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reset_all_parameters(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>To reset the entire DB parameter group, specify the <code>DBParameterGroup</code> name and
        /// <code>ResetAllParameters</code> parameters. To reset specific parameters, provide a list of
        /// the following: <code>ParameterName</code> and <code>ApplyMethod</code>. A maximum of 20
        /// parameters can be modified in a single request.</p>
        /// <p>Valid Values (for Apply method): <code>pending-reboot</code>
        /// </p>
        pub fn parameters(mut self, inp: impl Into<crate::model::Parameter>) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>To reset the entire DB parameter group, specify the <code>DBParameterGroup</code> name and
        /// <code>ResetAllParameters</code> parameters. To reset specific parameters, provide a list of
        /// the following: <code>ParameterName</code> and <code>ApplyMethod</code>. A maximum of 20
        /// parameters can be modified in a single request.</p>
        /// <p>Valid Values (for Apply method): <code>pending-reboot</code>
        /// </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreDBClusterFromSnapshot`.
    ///
    /// <p>Creates a new DB cluster from a DB snapshot or DB cluster snapshot.</p>
    /// <p>If a DB snapshot is specified, the target DB cluster is created from the source DB
    /// snapshot with a default configuration and default security group.</p>
    /// <p>If a DB cluster snapshot is specified, the target DB cluster is created from the source DB
    /// cluster restore point with the same configuration as the original source DB cluster, except
    /// that the new DB cluster is created with the default security group.</p>
    #[derive(std::fmt::Debug)]
    pub struct RestoreDBClusterFromSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restore_db_cluster_from_snapshot_input::Builder,
    }
    impl<C, M, R> RestoreDBClusterFromSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestoreDBClusterFromSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreDbClusterFromSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterFromSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestoreDbClusterFromSnapshotInputOperationOutputAlias,
                crate::output::RestoreDbClusterFromSnapshotOutput,
                crate::error::RestoreDBClusterFromSnapshotError,
                crate::input::RestoreDbClusterFromSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AvailabilityZones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>Provides the list of EC2 Availability Zones that instances in the restored DB cluster can
        /// be created in.</p>
        pub fn availability_zones(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zones(inp);
            self
        }
        /// <p>Provides the list of EC2 Availability Zones that instances in the restored DB cluster can
        /// be created in.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_availability_zones(input);
            self
        }
        /// <p>The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This
        /// parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This
        /// parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The identifier for the DB snapshot or DB cluster snapshot to restore from.</p>
        /// <p>You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster
        /// snapshot. However, you can use only the ARN to specify a DB snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing Snapshot.</p>
        /// </li>
        /// </ul>
        pub fn snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier(inp);
            self
        }
        /// <p>The identifier for the DB snapshot or DB cluster snapshot to restore from.</p>
        /// <p>You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster
        /// snapshot. However, you can use only the ARN to specify a DB snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing Snapshot.</p>
        /// </li>
        /// </ul>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier(input);
            self
        }
        /// <p>The database engine to use for the new DB cluster.</p>
        /// <p>Default: The same as source</p>
        /// <p>Constraint: Must be compatible with the engine of the source</p>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The database engine to use for the new DB cluster.</p>
        /// <p>Default: The same as source</p>
        /// <p>Constraint: Must be compatible with the engine of the source</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The version of the database engine to use for the new DB cluster.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The version of the database engine to use for the new DB cluster.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The port number on which the new DB cluster accepts connections.</p>
        /// <p>Constraints: Value must be <code>1150-65535</code>
        /// </p>
        /// <p>Default: The same port as the original DB cluster.</p>
        pub fn port(mut self, inp: i32) -> Self {
            self.inner = self.inner.port(inp);
            self
        }
        /// <p>The port number on which the new DB cluster accepts connections.</p>
        /// <p>Constraints: Value must be <code>1150-65535</code>
        /// </p>
        /// <p>Default: The same port as the original DB cluster.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The name of the DB subnet group to use for the new DB cluster.</p>
        /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>The name of the DB subnet group to use for the new DB cluster.</p>
        /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p>Not supported.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>Not supported.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn option_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(inp);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of VPC security groups that the new DB cluster will belong to.</p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p>A list of VPC security groups that the new DB cluster will belong to.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the restored DB cluster.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the restored DB cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The Amazon KMS key identifier to use when restoring an encrypted DB cluster from a DB
        /// snapshot or DB cluster snapshot.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
        /// you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used
        /// to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the
        /// KMS encryption key.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following
        /// will occur:</p>
        /// <ul>
        /// <li>
        /// <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is
        /// encrypted, then the restored DB cluster is encrypted using the KMS key that was used to
        /// encrypt the DB snapshot or DB cluster snapshot.</p>
        /// </li>
        /// <li>
        /// <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is not
        /// encrypted, then the restored DB cluster is not encrypted.</p>
        /// </li>
        /// </ul>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The Amazon KMS key identifier to use when restoring an encrypted DB cluster from a DB
        /// snapshot or DB cluster snapshot.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
        /// you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used
        /// to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the
        /// KMS encryption key.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following
        /// will occur:</p>
        /// <ul>
        /// <li>
        /// <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is
        /// encrypted, then the restored DB cluster is encrypted using the KMS key that was used to
        /// encrypt the DB snapshot or DB cluster snapshot.</p>
        /// </li>
        /// <li>
        /// <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is not
        /// encrypted, then the restored DB cluster is not encrypted.</p>
        /// </li>
        /// </ul>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
        /// accounts, and otherwise false.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn enable_iam_database_authentication(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_iam_database_authentication(inp);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
        /// accounts, and otherwise false.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_iam_database_authentication(input);
            self
        }
        /// Appends an item to `EnableCloudwatchLogsExports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs.</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.enable_cloudwatch_logs_exports(inp);
            self
        }
        /// <p>The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs.</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_enable_cloudwatch_logs_exports(input);
            self
        }
        /// <p>The name of the DB cluster parameter group to associate with the new DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB cluster parameter group to associate with the new DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled.
        /// </p>
        pub fn deletion_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.deletion_protection(inp);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled.
        /// </p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
        /// <p>
        /// <i>If set to <code>true</code>, tags are copied to any snapshot of
        /// the restored DB cluster that is created.</i>
        /// </p>
        pub fn copy_tags_to_snapshot(mut self, inp: bool) -> Self {
            self.inner = self.inner.copy_tags_to_snapshot(inp);
            self
        }
        /// <p>
        /// <i>If set to <code>true</code>, tags are copied to any snapshot of
        /// the restored DB cluster that is created.</i>
        /// </p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags_to_snapshot(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreDBClusterToPointInTime`.
    ///
    /// <p>Restores a DB cluster to an arbitrary point in time. Users can restore to any point in
    /// time before <code>LatestRestorableTime</code> for up to <code>BackupRetentionPeriod</code>
    /// days. The target DB cluster is created from the source DB cluster with the same configuration
    /// as the original DB cluster, except that the new DB cluster is created with the default DB
    /// security group.</p>
    /// <note>
    /// <p>This action only restores the DB cluster, not the DB instances for that DB cluster. You
    /// must invoke the <a>CreateDBInstance</a> action to create DB instances for the
    /// restored DB cluster, specifying the identifier of the restored DB cluster in
    /// <code>DBClusterIdentifier</code>. You can create DB instances only after the
    /// <code>RestoreDBClusterToPointInTime</code> action has completed and the DB cluster is
    /// available.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct RestoreDBClusterToPointInTime<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restore_db_cluster_to_point_in_time_input::Builder,
    }
    impl<C, M, R> RestoreDBClusterToPointInTime<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestoreDBClusterToPointInTime`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreDbClusterToPointInTimeOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterToPointInTimeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestoreDbClusterToPointInTimeInputOperationOutputAlias,
                crate::output::RestoreDbClusterToPointInTimeOutput,
                crate::error::RestoreDBClusterToPointInTimeError,
                crate::input::RestoreDbClusterToPointInTimeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new DB cluster to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The name of the new DB cluster to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The type of restore to be performed. You can specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>full-copy</code> - The new DB cluster is restored as a full copy of the source
        /// DB cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source
        /// DB cluster.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored
        /// as a full copy of the source DB cluster.</p>
        pub fn restore_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.restore_type(inp);
            self
        }
        /// <p>The type of restore to be performed. You can specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>full-copy</code> - The new DB cluster is restored as a full copy of the source
        /// DB cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source
        /// DB cluster.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored
        /// as a full copy of the source DB cluster.</p>
        pub fn set_restore_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_restore_type(input);
            self
        }
        /// <p>The identifier of the source DB cluster from which to restore.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn source_db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_db_cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the source DB cluster from which to restore.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn set_source_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_db_cluster_identifier(input);
            self
        }
        /// <p>The date and time to restore the DB cluster to.</p>
        /// <p>Valid Values: Value must be a time in Universal Coordinated Time (UTC) format</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be before the latest restorable time for the DB instance</p>
        /// </li>
        /// <li>
        /// <p>Must be specified if <code>UseLatestRestorableTime</code> parameter is not
        /// provided</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified if <code>UseLatestRestorableTime</code> parameter is true</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified if <code>RestoreType</code> parameter is
        /// <code>copy-on-write</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>2015-03-07T23:45:00Z</code>
        /// </p>
        pub fn restore_to_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.restore_to_time(inp);
            self
        }
        /// <p>The date and time to restore the DB cluster to.</p>
        /// <p>Valid Values: Value must be a time in Universal Coordinated Time (UTC) format</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be before the latest restorable time for the DB instance</p>
        /// </li>
        /// <li>
        /// <p>Must be specified if <code>UseLatestRestorableTime</code> parameter is not
        /// provided</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified if <code>UseLatestRestorableTime</code> parameter is true</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified if <code>RestoreType</code> parameter is
        /// <code>copy-on-write</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>2015-03-07T23:45:00Z</code>
        /// </p>
        pub fn set_restore_to_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_restore_to_time(input);
            self
        }
        /// <p>A value that is set to <code>true</code> to restore the DB cluster to the latest
        /// restorable backup time, and <code>false</code> otherwise.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        /// <p>Constraints: Cannot be specified if <code>RestoreToTime</code> parameter is
        /// provided.</p>
        pub fn use_latest_restorable_time(mut self, inp: bool) -> Self {
            self.inner = self.inner.use_latest_restorable_time(inp);
            self
        }
        /// <p>A value that is set to <code>true</code> to restore the DB cluster to the latest
        /// restorable backup time, and <code>false</code> otherwise.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        /// <p>Constraints: Cannot be specified if <code>RestoreToTime</code> parameter is
        /// provided.</p>
        pub fn set_use_latest_restorable_time(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_use_latest_restorable_time(input);
            self
        }
        /// <p>The port number on which the new DB cluster accepts connections.</p>
        /// <p>Constraints: Value must be <code>1150-65535</code>
        /// </p>
        /// <p>Default: The same port as the original DB cluster.</p>
        pub fn port(mut self, inp: i32) -> Self {
            self.inner = self.inner.port(inp);
            self
        }
        /// <p>The port number on which the new DB cluster accepts connections.</p>
        /// <p>Constraints: Value must be <code>1150-65535</code>
        /// </p>
        /// <p>Default: The same port as the original DB cluster.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The DB subnet group name to use for the new DB cluster.</p>
        /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>The DB subnet group name to use for the new DB cluster.</p>
        /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn option_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(inp);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of VPC security groups that the new DB cluster belongs to.</p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p>A list of VPC security groups that the new DB cluster belongs to.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be applied to the restored DB cluster.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be applied to the restored DB cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The Amazon KMS key identifier to use when restoring an encrypted DB cluster from an encrypted
        /// DB cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
        /// you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used
        /// to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the
        /// KMS encryption key.</p>
        /// <p>You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is
        /// different than the KMS key used to encrypt the source DB cluster. The new DB cluster is
        /// encrypted with the KMS key identified by the <code>KmsKeyId</code> parameter.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following
        /// will occur:</p>
        /// <ul>
        /// <li>
        /// <p>If the DB cluster is encrypted, then the restored DB cluster is encrypted using the
        /// KMS key that was used to encrypt the source DB cluster.</p>
        /// </li>
        /// <li>
        /// <p>If the DB cluster is not encrypted, then the restored DB cluster is not
        /// encrypted.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>DBClusterIdentifier</code> refers to a DB cluster that is not encrypted, then the
        /// restore request is rejected.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The Amazon KMS key identifier to use when restoring an encrypted DB cluster from an encrypted
        /// DB cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
        /// you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used
        /// to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the
        /// KMS encryption key.</p>
        /// <p>You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is
        /// different than the KMS key used to encrypt the source DB cluster. The new DB cluster is
        /// encrypted with the KMS key identified by the <code>KmsKeyId</code> parameter.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following
        /// will occur:</p>
        /// <ul>
        /// <li>
        /// <p>If the DB cluster is encrypted, then the restored DB cluster is encrypted using the
        /// KMS key that was used to encrypt the source DB cluster.</p>
        /// </li>
        /// <li>
        /// <p>If the DB cluster is not encrypted, then the restored DB cluster is not
        /// encrypted.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>DBClusterIdentifier</code> refers to a DB cluster that is not encrypted, then the
        /// restore request is rejected.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
        /// accounts, and otherwise false.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn enable_iam_database_authentication(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_iam_database_authentication(inp);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
        /// accounts, and otherwise false.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_iam_database_authentication(input);
            self
        }
        /// Appends an item to `EnableCloudwatchLogsExports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>The list of logs that the restored DB cluster is to export to CloudWatch Logs.</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.enable_cloudwatch_logs_exports(inp);
            self
        }
        /// <p>The list of logs that the restored DB cluster is to export to CloudWatch Logs.</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_enable_cloudwatch_logs_exports(input);
            self
        }
        /// <p>The name of the DB cluster parameter group to associate with the new DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB cluster parameter group to associate with the new DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled.
        /// </p>
        pub fn deletion_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.deletion_protection(inp);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled.
        /// </p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDBCluster`.
    ///
    /// <p>Starts an Amazon Neptune  DB cluster that was stopped using the Amazon
    /// console, the Amazon CLI stop-db-cluster command, or the StopDBCluster API.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_db_cluster_input::Builder,
    }
    impl<C, M, R> StartDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartDbClusterInputOperationOutputAlias,
                crate::output::StartDbClusterOutput,
                crate::error::StartDBClusterError,
                crate::input::StartDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB cluster identifier of the Neptune DB cluster to be started.
        /// This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The DB cluster identifier of the Neptune DB cluster to be started.
        /// This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopDBCluster`.
    ///
    /// <p>Stops an Amazon Neptune DB cluster. When you stop a DB cluster, Neptune
    /// retains the DB cluster's metadata, including its endpoints and DB parameter
    /// groups.</p>
    ///
    /// <p>Neptune also retains the transaction logs so you can do a point-in-time
    /// restore if necessary.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_db_cluster_input::Builder,
    }
    impl<C, M, R> StopDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::StopDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopDbClusterInputOperationOutputAlias,
                crate::output::StopDbClusterOutput,
                crate::error::StopDBClusterError,
                crate::input::StopDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB cluster identifier of the Neptune DB cluster to be stopped.
        /// This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The DB cluster identifier of the Neptune DB cluster to be stopped.
        /// This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
