// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddRoleToDbClusterInput`](crate::input::AddRoleToDbClusterInput)
pub mod add_role_to_db_cluster_input {
    /// A builder for [`AddRoleToDbClusterInput`](crate::input::AddRoleToDbClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) feature_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB cluster to associate the IAM role with.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster to associate the IAM role with.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the Neptune DB cluster,
        /// for example <code>arn:aws:iam::123456789012:role/NeptuneAccessRole</code>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the Neptune DB cluster,
        /// for example <code>arn:aws:iam::123456789012:role/NeptuneAccessRole</code>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The name of the feature for the Neptune DB cluster that the IAM role is to be associated with.
        /// For the list of supported feature names, see <a>DBEngineVersion</a>.</p>
        pub fn feature_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature_name = Some(input.into());
            self
        }
        /// <p>The name of the feature for the Neptune DB cluster that the IAM role is to be associated with.
        /// For the list of supported feature names, see <a>DBEngineVersion</a>.</p>
        pub fn set_feature_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feature_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AddRoleToDbClusterInput`](crate::input::AddRoleToDbClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddRoleToDbClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddRoleToDbClusterInput {
                db_cluster_identifier: self.db_cluster_identifier,
                role_arn: self.role_arn,
                feature_name: self.feature_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AddRoleToDbClusterInputOperationOutputAlias = crate::operation::AddRoleToDBCluster;
#[doc(hidden)]
pub type AddRoleToDbClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddRoleToDbClusterInput {
    /// Consumes the builder and constructs an Operation<[`AddRoleToDBCluster`](crate::operation::AddRoleToDBCluster)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddRoleToDBCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddRoleToDbClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddRoleToDbClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddRoleToDbClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_role_to_db_cluster(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddRoleToDBCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddRoleToDBCluster",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddRoleToDbClusterInput`](crate::input::AddRoleToDbClusterInput)
    pub fn builder() -> crate::input::add_role_to_db_cluster_input::Builder {
        crate::input::add_role_to_db_cluster_input::Builder::default()
    }
}

/// See [`AddSourceIdentifierToSubscriptionInput`](crate::input::AddSourceIdentifierToSubscriptionInput)
pub mod add_source_identifier_to_subscription_input {
    /// A builder for [`AddSourceIdentifierToSubscriptionInput`](crate::input::AddSourceIdentifierToSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
        pub(crate) source_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the event notification subscription you want to add a source identifier
        /// to.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the event notification subscription you want to add a source identifier
        /// to.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// <p>The identifier of the event source to be added.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be
        /// supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be
        /// supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must
        /// be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be
        /// supplied.</p>
        /// </li>
        /// </ul>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the event source to be added.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be
        /// supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be
        /// supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must
        /// be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be
        /// supplied.</p>
        /// </li>
        /// </ul>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`AddSourceIdentifierToSubscriptionInput`](crate::input::AddSourceIdentifierToSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddSourceIdentifierToSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddSourceIdentifierToSubscriptionInput {
                subscription_name: self.subscription_name,
                source_identifier: self.source_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type AddSourceIdentifierToSubscriptionInputOperationOutputAlias =
    crate::operation::AddSourceIdentifierToSubscription;
#[doc(hidden)]
pub type AddSourceIdentifierToSubscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddSourceIdentifierToSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`AddSourceIdentifierToSubscription`](crate::operation::AddSourceIdentifierToSubscription)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddSourceIdentifierToSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddSourceIdentifierToSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddSourceIdentifierToSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddSourceIdentifierToSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_source_identifier_to_subscription(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddSourceIdentifierToSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddSourceIdentifierToSubscription",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddSourceIdentifierToSubscriptionInput`](crate::input::AddSourceIdentifierToSubscriptionInput)
    pub fn builder() -> crate::input::add_source_identifier_to_subscription_input::Builder {
        crate::input::add_source_identifier_to_subscription_input::Builder::default()
    }
}

/// See [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
pub mod add_tags_to_resource_input {
    /// A builder for [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Neptune resource that the tags are added to. This value is an Amazon Resource
        /// Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The Amazon Neptune resource that the tags are added to. This value is an Amazon Resource
        /// Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Amazon Neptune resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the Amazon Neptune resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddTagsToResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddTagsToResourceInput {
                resource_name: self.resource_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsToResourceInputOperationOutputAlias = crate::operation::AddTagsToResource;
#[doc(hidden)]
pub type AddTagsToResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddTagsToResourceInput {
    /// Consumes the builder and constructs an Operation<[`AddTagsToResource`](crate::operation::AddTagsToResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTagsToResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddTagsToResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddTagsToResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddTagsToResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_tags_to_resource(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddTagsToResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddTagsToResource",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    pub fn builder() -> crate::input::add_tags_to_resource_input::Builder {
        crate::input::add_tags_to_resource_input::Builder::default()
    }
}

/// See [`ApplyPendingMaintenanceActionInput`](crate::input::ApplyPendingMaintenanceActionInput)
pub mod apply_pending_maintenance_action_input {
    /// A builder for [`ApplyPendingMaintenanceActionInput`](crate::input::ApplyPendingMaintenanceActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
        pub(crate) apply_action: std::option::Option<std::string::String>,
        pub(crate) opt_in_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that the pending maintenance action applies
        /// to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that the pending maintenance action applies
        /// to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>system-update</code>, <code>db-upgrade</code>
        /// </p>
        pub fn apply_action(mut self, input: impl Into<std::string::String>) -> Self {
            self.apply_action = Some(input.into());
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>system-update</code>, <code>db-upgrade</code>
        /// </p>
        pub fn set_apply_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.apply_action = input;
            self
        }
        /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in
        /// request of type <code>immediate</code> can't be undone.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>immediate</code> - Apply the maintenance action immediately.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>next-maintenance</code> - Apply the maintenance action during the next
        /// maintenance window for the resource.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in
        /// requests.</p>
        /// </li>
        /// </ul>
        pub fn opt_in_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_in_type = Some(input.into());
            self
        }
        /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in
        /// request of type <code>immediate</code> can't be undone.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>immediate</code> - Apply the maintenance action immediately.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>next-maintenance</code> - Apply the maintenance action during the next
        /// maintenance window for the resource.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in
        /// requests.</p>
        /// </li>
        /// </ul>
        pub fn set_opt_in_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.opt_in_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplyPendingMaintenanceActionInput`](crate::input::ApplyPendingMaintenanceActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ApplyPendingMaintenanceActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ApplyPendingMaintenanceActionInput {
                resource_identifier: self.resource_identifier,
                apply_action: self.apply_action,
                opt_in_type: self.opt_in_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ApplyPendingMaintenanceActionInputOperationOutputAlias =
    crate::operation::ApplyPendingMaintenanceAction;
#[doc(hidden)]
pub type ApplyPendingMaintenanceActionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ApplyPendingMaintenanceActionInput {
    /// Consumes the builder and constructs an Operation<[`ApplyPendingMaintenanceAction`](crate::operation::ApplyPendingMaintenanceAction)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ApplyPendingMaintenanceAction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ApplyPendingMaintenanceActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ApplyPendingMaintenanceActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ApplyPendingMaintenanceActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_apply_pending_maintenance_action(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ApplyPendingMaintenanceAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ApplyPendingMaintenanceAction",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ApplyPendingMaintenanceActionInput`](crate::input::ApplyPendingMaintenanceActionInput)
    pub fn builder() -> crate::input::apply_pending_maintenance_action_input::Builder {
        crate::input::apply_pending_maintenance_action_input::Builder::default()
    }
}

/// See [`CopyDbClusterParameterGroupInput`](crate::input::CopyDbClusterParameterGroupInput)
pub mod copy_db_cluster_parameter_group_input {
    /// A builder for [`CopyDbClusterParameterGroupInput`](crate::input::CopyDbClusterParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_db_cluster_parameter_group_identifier:
            std::option::Option<std::string::String>,
        pub(crate) target_db_cluster_parameter_group_identifier:
            std::option::Option<std::string::String>,
        pub(crate) target_db_cluster_parameter_group_description:
            std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group.
        /// For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid DB cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>If the source DB cluster parameter group is in the same Amazon Region as the copy,
        /// specify a valid DB parameter group identifier, for example
        /// <code>my-db-cluster-param-group</code>, or a valid ARN.</p>
        /// </li>
        /// <li>
        /// <p>If the source DB parameter group is in a different Amazon Region than the copy, specify a
        /// valid DB cluster parameter group ARN, for example
        /// <code>arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1</code>.</p>
        /// </li>
        /// </ul>
        pub fn source_db_cluster_parameter_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_db_cluster_parameter_group_identifier = Some(input.into());
            self
        }
        /// <p>The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group.
        /// For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid DB cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>If the source DB cluster parameter group is in the same Amazon Region as the copy,
        /// specify a valid DB parameter group identifier, for example
        /// <code>my-db-cluster-param-group</code>, or a valid ARN.</p>
        /// </li>
        /// <li>
        /// <p>If the source DB parameter group is in a different Amazon Region than the copy, specify a
        /// valid DB cluster parameter group ARN, for example
        /// <code>arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_source_db_cluster_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_db_cluster_parameter_group_identifier = input;
            self
        }
        /// <p>The identifier for the copied DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-param-group1</code>
        /// </p>
        pub fn target_db_cluster_parameter_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_db_cluster_parameter_group_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the copied DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-param-group1</code>
        /// </p>
        pub fn set_target_db_cluster_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_db_cluster_parameter_group_identifier = input;
            self
        }
        /// <p>A description for the copied DB cluster parameter group.</p>
        pub fn target_db_cluster_parameter_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_db_cluster_parameter_group_description = Some(input.into());
            self
        }
        /// <p>A description for the copied DB cluster parameter group.</p>
        pub fn set_target_db_cluster_parameter_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_db_cluster_parameter_group_description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the copied DB cluster parameter group.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the copied DB cluster parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyDbClusterParameterGroupInput`](crate::input::CopyDbClusterParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopyDbClusterParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopyDbClusterParameterGroupInput {
                source_db_cluster_parameter_group_identifier: self
                    .source_db_cluster_parameter_group_identifier,
                target_db_cluster_parameter_group_identifier: self
                    .target_db_cluster_parameter_group_identifier,
                target_db_cluster_parameter_group_description: self
                    .target_db_cluster_parameter_group_description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyDbClusterParameterGroupInputOperationOutputAlias =
    crate::operation::CopyDBClusterParameterGroup;
#[doc(hidden)]
pub type CopyDbClusterParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CopyDbClusterParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`CopyDBClusterParameterGroup`](crate::operation::CopyDBClusterParameterGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyDBClusterParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CopyDbClusterParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CopyDbClusterParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CopyDbClusterParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_copy_db_cluster_parameter_group(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopyDBClusterParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopyDBClusterParameterGroup",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CopyDbClusterParameterGroupInput`](crate::input::CopyDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::copy_db_cluster_parameter_group_input::Builder {
        crate::input::copy_db_cluster_parameter_group_input::Builder::default()
    }
}

/// See [`CopyDbClusterSnapshotInput`](crate::input::CopyDbClusterSnapshotInput)
pub mod copy_db_cluster_snapshot_input {
    /// A builder for [`CopyDbClusterSnapshotInput`](crate::input::CopyDbClusterSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) target_db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) pre_signed_url: std::option::Option<std::string::String>,
        pub(crate) copy_tags: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier of the DB cluster snapshot to copy. This parameter is not
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid system snapshot in the "available" state.</p>
        /// </li>
        /// <li>
        /// <p>Specify a valid DB snapshot identifier.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code>
        /// </p>
        pub fn source_db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the DB cluster snapshot to copy. This parameter is not
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid system snapshot in the "available" state.</p>
        /// </li>
        /// <li>
        /// <p>Specify a valid DB snapshot identifier.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code>
        /// </p>
        pub fn set_source_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_db_cluster_snapshot_identifier = input;
            self
        }
        /// <p>The identifier of the new DB cluster snapshot to create from the source DB cluster
        /// snapshot. This parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot2</code>
        /// </p>
        pub fn target_db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the new DB cluster snapshot to create from the source DB cluster
        /// snapshot. This parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot2</code>
        /// </p>
        pub fn set_target_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_db_cluster_snapshot_identifier = input;
            self
        }
        /// <p>The Amazon Amazon KMS key ID for an encrypted DB cluster snapshot. The KMS key ID is the Amazon
        /// Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.</p>
        ///
        /// <p>If you copy an encrypted DB cluster snapshot from your Amazon account, you can specify a
        /// value for <code>KmsKeyId</code> to encrypt the copy with a new KMS encryption key. If you
        /// don't specify a value for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is
        /// encrypted with the same KMS key as the source DB cluster snapshot.</p>
        ///
        /// <p>If you copy an encrypted DB cluster snapshot that is shared from another Amazon account, then
        /// you must specify a value for <code>KmsKeyId</code>.</p>
        /// <p> KMS encryption keys are specific to the Amazon Region that they are created in, and you
        /// can't use encryption keys from one Amazon Region in another Amazon Region.</p>
        ///
        /// <p>You cannot encrypt an unencrypted DB cluster snapshot when you copy it. If you try to
        /// copy an unencrypted DB cluster snapshot and specify a value for the KmsKeyId parameter, an
        /// error is returned.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Amazon KMS key ID for an encrypted DB cluster snapshot. The KMS key ID is the Amazon
        /// Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.</p>
        ///
        /// <p>If you copy an encrypted DB cluster snapshot from your Amazon account, you can specify a
        /// value for <code>KmsKeyId</code> to encrypt the copy with a new KMS encryption key. If you
        /// don't specify a value for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is
        /// encrypted with the same KMS key as the source DB cluster snapshot.</p>
        ///
        /// <p>If you copy an encrypted DB cluster snapshot that is shared from another Amazon account, then
        /// you must specify a value for <code>KmsKeyId</code>.</p>
        /// <p> KMS encryption keys are specific to the Amazon Region that they are created in, and you
        /// can't use encryption keys from one Amazon Region in another Amazon Region.</p>
        ///
        /// <p>You cannot encrypt an unencrypted DB cluster snapshot when you copy it. If you try to
        /// copy an unencrypted DB cluster snapshot and specify a value for the KmsKeyId parameter, an
        /// error is returned.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Not currently supported.</p>
        pub fn pre_signed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.pre_signed_url = Some(input.into());
            self
        }
        /// <p>Not currently supported.</p>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pre_signed_url = input;
            self
        }
        /// <p>True to copy all tags from the source DB cluster snapshot to the target DB cluster
        /// snapshot, and otherwise false. The default is false.</p>
        pub fn copy_tags(mut self, input: bool) -> Self {
            self.copy_tags = Some(input);
            self
        }
        /// <p>True to copy all tags from the source DB cluster snapshot to the target DB cluster
        /// snapshot, and otherwise false. The default is false.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the new DB cluster snapshot copy.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to assign to the new DB cluster snapshot copy.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyDbClusterSnapshotInput`](crate::input::CopyDbClusterSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopyDbClusterSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopyDbClusterSnapshotInput {
                source_db_cluster_snapshot_identifier: self.source_db_cluster_snapshot_identifier,
                target_db_cluster_snapshot_identifier: self.target_db_cluster_snapshot_identifier,
                kms_key_id: self.kms_key_id,
                pre_signed_url: self.pre_signed_url,
                copy_tags: self.copy_tags,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyDbClusterSnapshotInputOperationOutputAlias = crate::operation::CopyDBClusterSnapshot;
#[doc(hidden)]
pub type CopyDbClusterSnapshotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CopyDbClusterSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CopyDBClusterSnapshot`](crate::operation::CopyDBClusterSnapshot)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyDBClusterSnapshot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CopyDbClusterSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CopyDbClusterSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CopyDbClusterSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_copy_db_cluster_snapshot(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopyDBClusterSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopyDBClusterSnapshot",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CopyDbClusterSnapshotInput`](crate::input::CopyDbClusterSnapshotInput)
    pub fn builder() -> crate::input::copy_db_cluster_snapshot_input::Builder {
        crate::input::copy_db_cluster_snapshot_input::Builder::default()
    }
}

/// See [`CopyDbParameterGroupInput`](crate::input::CopyDbParameterGroupInput)
pub mod copy_db_parameter_group_input {
    /// A builder for [`CopyDbParameterGroupInput`](crate::input::CopyDbParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_db_parameter_group_identifier: std::option::Option<std::string::String>,
        pub(crate) target_db_parameter_group_identifier: std::option::Option<std::string::String>,
        pub(crate) target_db_parameter_group_description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier or ARN for the source DB parameter group. For information about creating
        /// an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        ///
        /// <p>Constraints:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Must specify a valid DB parameter group.</p>
        /// </li>
        /// <li>
        /// <p>Must specify a valid DB parameter group identifier, for example
        /// <code>my-db-param-group</code>, or a valid ARN.</p>
        /// </li>
        /// </ul>
        pub fn source_db_parameter_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_db_parameter_group_identifier = Some(input.into());
            self
        }
        /// <p>The identifier or ARN for the source DB parameter group. For information about creating
        /// an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        ///
        /// <p>Constraints:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Must specify a valid DB parameter group.</p>
        /// </li>
        /// <li>
        /// <p>Must specify a valid DB parameter group identifier, for example
        /// <code>my-db-param-group</code>, or a valid ARN.</p>
        /// </li>
        /// </ul>
        pub fn set_source_db_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_db_parameter_group_identifier = input;
            self
        }
        /// <p>The identifier for the copied DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>Example: <code>my-db-parameter-group</code>
        /// </p>
        pub fn target_db_parameter_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_db_parameter_group_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the copied DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>Example: <code>my-db-parameter-group</code>
        /// </p>
        pub fn set_target_db_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_db_parameter_group_identifier = input;
            self
        }
        /// <p>A description for the copied DB parameter group.</p>
        pub fn target_db_parameter_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_db_parameter_group_description = Some(input.into());
            self
        }
        /// <p>A description for the copied DB parameter group.</p>
        pub fn set_target_db_parameter_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_db_parameter_group_description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the copied DB parameter group.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the copied DB parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyDbParameterGroupInput`](crate::input::CopyDbParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopyDbParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopyDbParameterGroupInput {
                source_db_parameter_group_identifier: self.source_db_parameter_group_identifier,
                target_db_parameter_group_identifier: self.target_db_parameter_group_identifier,
                target_db_parameter_group_description: self.target_db_parameter_group_description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyDbParameterGroupInputOperationOutputAlias = crate::operation::CopyDBParameterGroup;
#[doc(hidden)]
pub type CopyDbParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CopyDbParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`CopyDBParameterGroup`](crate::operation::CopyDBParameterGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyDBParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CopyDbParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CopyDbParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CopyDbParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_copy_db_parameter_group(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopyDBParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopyDBParameterGroup",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CopyDbParameterGroupInput`](crate::input::CopyDbParameterGroupInput)
    pub fn builder() -> crate::input::copy_db_parameter_group_input::Builder {
        crate::input::copy_db_parameter_group_input::Builder::default()
    }
}

/// See [`CreateDbClusterInput`](crate::input::CreateDbClusterInput)
pub mod create_db_cluster_input {
    /// A builder for [`CreateDbClusterInput`](crate::input::CreateDbClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) backup_retention_period: std::option::Option<i32>,
        pub(crate) character_set_name: std::option::Option<std::string::String>,
        pub(crate) copy_tags_to_snapshot: std::option::Option<bool>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) master_username: std::option::Option<std::string::String>,
        pub(crate) master_user_password: std::option::Option<std::string::String>,
        pub(crate) option_group_name: std::option::Option<std::string::String>,
        pub(crate) preferred_backup_window: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) replication_source_identifier: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) storage_encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) pre_signed_url: std::option::Option<std::string::String>,
        pub(crate) enable_iam_database_authentication: std::option::Option<bool>,
        pub(crate) enable_cloudwatch_logs_exports:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) deletion_protection: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>A list of EC2 Availability Zones that instances in the DB cluster can be created
        /// in.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>A list of EC2 Availability Zones that instances in the DB cluster can be created
        /// in.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// <p>The number of days for which automated backups are retained. You must specify a minimum
        /// value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 1 to 35</p>
        /// </li>
        /// </ul>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.backup_retention_period = Some(input);
            self
        }
        /// <p>The number of days for which automated backups are retained. You must specify a minimum
        /// value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 1 to 35</p>
        /// </li>
        /// </ul>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.backup_retention_period = input;
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn character_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.character_set_name = Some(input.into());
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.character_set_name = input;
            self
        }
        /// <p>
        /// <i>If set to <code>true</code>, tags are copied to any snapshot of
        /// the DB cluster that is created.</i>
        /// </p>
        pub fn copy_tags_to_snapshot(mut self, input: bool) -> Self {
            self.copy_tags_to_snapshot = Some(input);
            self
        }
        /// <p>
        /// <i>If set to <code>true</code>, tags are copied to any snapshot of
        /// the DB cluster that is created.</i>
        /// </p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags_to_snapshot = input;
            self
        }
        /// <p>The name for your database of up to 64 alpha-numeric characters. If you do not provide a
        /// name, Amazon Neptune will not create a database in the DB cluster you are creating.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name for your database of up to 64 alpha-numeric characters. If you do not provide a
        /// name, Amazon Neptune will not create a database in the DB cluster you are creating.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The DB cluster identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p> The name of the DB cluster parameter group to associate with this DB cluster. If this
        /// argument is omitted, the default is used.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p> The name of the DB cluster parameter group to associate with this DB cluster. If this
        /// argument is omitted, the default is used.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of EC2 VPC security groups to associate with this DB cluster.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>A list of EC2 VPC security groups to associate with this DB cluster.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// <p>A DB subnet group to associate with this DB cluster.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>A DB subnet group to associate with this DB cluster.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// <p>The name of the database engine to be used for this DB cluster.</p>
        /// <p>Valid Values: <code>neptune</code>
        /// </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the database engine to be used for this DB cluster.</p>
        /// <p>Valid Values: <code>neptune</code>
        /// </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The version number of the database engine to use for the new DB cluster.</p>
        /// <p>Example: <code>1.0.2.1</code>
        /// </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the database engine to use for the new DB cluster.</p>
        /// <p>Example: <code>1.0.2.1</code>
        /// </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The port number on which the instances in the DB cluster accept connections.</p>
        /// <p> Default: <code>8182</code>
        /// </p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number on which the instances in the DB cluster accept connections.</p>
        /// <p> Default: <code>8182</code>
        /// </p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_username = Some(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_username = input;
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_password = Some(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_password = input;
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_name = Some(input.into());
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_name = input;
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are
        /// enabled using the <code>BackupRetentionPeriod</code> parameter.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred
        /// Maintenance Window</a> in the <i>Amazon Neptune User Guide.</i>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_backup_window = Some(input.into());
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are
        /// enabled using the <code>BackupRetentionPeriod</code> parameter.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred
        /// Maintenance Window</a> in the <i>Amazon Neptune User Guide.</i>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_backup_window = input;
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated
        /// Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region, occurring on a random day of the week. To see the time blocks available, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred
        /// Maintenance Window</a> in the <i>Amazon Neptune User Guide.</i>
        /// </p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated
        /// Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region, occurring on a random day of the week. To see the time blocks available, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred
        /// Maintenance Window</a> in the <i>Amazon Neptune User Guide.</i>
        /// </p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster
        /// is created as a Read Replica.</p>
        pub fn replication_source_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_source_identifier = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster
        /// is created as a Read Replica.</p>
        pub fn set_replication_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_source_identifier = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the new DB cluster.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to assign to the new DB cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies whether the DB cluster is encrypted.</p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.storage_encrypted = Some(input);
            self
        }
        /// <p>Specifies whether the DB cluster is encrypted.</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_encrypted = input;
            self
        }
        /// <p>The Amazon KMS key identifier for an encrypted DB cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
        /// you are creating a DB cluster with the same Amazon account that owns the KMS encryption key used
        /// to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the
        /// KMS encryption key.</p>
        /// <p>If an encryption key is not specified in <code>KmsKeyId</code>:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then
        /// Amazon Neptune will use the encryption key used to encrypt the source. Otherwise, Amazon
        /// Neptune will use your default encryption key.</p>
        /// </li>
        /// <li>
        /// <p>If the <code>StorageEncrypted</code> parameter is true and
        /// <code>ReplicationSourceIdentifier</code> is not specified, then Amazon Neptune will use
        /// your default encryption key.</p>
        /// </li>
        /// </ul>
        /// <p>Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a
        /// different default encryption key for each Amazon Region.</p>
        /// <p>If you create a Read Replica of an encrypted DB cluster in another Amazon Region, you must
        /// set <code>KmsKeyId</code> to a KMS key ID that is valid in the destination Amazon Region. This
        /// key is used to encrypt the Read Replica in that Amazon Region.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon KMS key identifier for an encrypted DB cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
        /// you are creating a DB cluster with the same Amazon account that owns the KMS encryption key used
        /// to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the
        /// KMS encryption key.</p>
        /// <p>If an encryption key is not specified in <code>KmsKeyId</code>:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then
        /// Amazon Neptune will use the encryption key used to encrypt the source. Otherwise, Amazon
        /// Neptune will use your default encryption key.</p>
        /// </li>
        /// <li>
        /// <p>If the <code>StorageEncrypted</code> parameter is true and
        /// <code>ReplicationSourceIdentifier</code> is not specified, then Amazon Neptune will use
        /// your default encryption key.</p>
        /// </li>
        /// </ul>
        /// <p>Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a
        /// different default encryption key for each Amazon Region.</p>
        /// <p>If you create a Read Replica of an encrypted DB cluster in another Amazon Region, you must
        /// set <code>KmsKeyId</code> to a KMS key ID that is valid in the destination Amazon Region. This
        /// key is used to encrypt the Read Replica in that Amazon Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn pre_signed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.pre_signed_url = Some(input.into());
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pre_signed_url = input;
            self
        }
        /// <p>If set to <code>true</code>, enables Amazon Identity and Access Management
        /// (IAM) authentication for the entire DB cluster (this cannot be set at an
        /// instance level).</p>
        /// <p>Default: <code>false</code>.</p>
        pub fn enable_iam_database_authentication(mut self, input: bool) -> Self {
            self.enable_iam_database_authentication = Some(input);
            self
        }
        /// <p>If set to <code>true</code>, enables Amazon Identity and Access Management
        /// (IAM) authentication for the entire DB cluster (this cannot be set at an
        /// instance level).</p>
        /// <p>Default: <code>false</code>.</p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_iam_database_authentication = input;
            self
        }
        /// Appends an item to `enable_cloudwatch_logs_exports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.enable_cloudwatch_logs_exports.unwrap_or_default();
            v.push(input.into());
            self.enable_cloudwatch_logs_exports = Some(v);
            self
        }
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.enable_cloudwatch_logs_exports = input;
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is enabled.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is enabled.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbClusterInput`](crate::input::CreateDbClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbClusterInput {
                availability_zones: self.availability_zones,
                backup_retention_period: self.backup_retention_period,
                character_set_name: self.character_set_name,
                copy_tags_to_snapshot: self.copy_tags_to_snapshot,
                database_name: self.database_name,
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                vpc_security_group_ids: self.vpc_security_group_ids,
                db_subnet_group_name: self.db_subnet_group_name,
                engine: self.engine,
                engine_version: self.engine_version,
                port: self.port,
                master_username: self.master_username,
                master_user_password: self.master_user_password,
                option_group_name: self.option_group_name,
                preferred_backup_window: self.preferred_backup_window,
                preferred_maintenance_window: self.preferred_maintenance_window,
                replication_source_identifier: self.replication_source_identifier,
                tags: self.tags,
                storage_encrypted: self.storage_encrypted,
                kms_key_id: self.kms_key_id,
                pre_signed_url: self.pre_signed_url,
                enable_iam_database_authentication: self.enable_iam_database_authentication,
                enable_cloudwatch_logs_exports: self.enable_cloudwatch_logs_exports,
                deletion_protection: self.deletion_protection,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbClusterInputOperationOutputAlias = crate::operation::CreateDBCluster;
#[doc(hidden)]
pub type CreateDbClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDbClusterInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBCluster`](crate::operation::CreateDBCluster)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDbClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDbClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDbClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_db_cluster(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBCluster",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDbClusterInput`](crate::input::CreateDbClusterInput)
    pub fn builder() -> crate::input::create_db_cluster_input::Builder {
        crate::input::create_db_cluster_input::Builder::default()
    }
}

/// See [`CreateDbClusterEndpointInput`](crate::input::CreateDbClusterEndpointInput)
pub mod create_db_cluster_endpoint_input {
    /// A builder for [`CreateDbClusterEndpointInput`](crate::input::CreateDbClusterEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<std::string::String>,
        pub(crate) static_members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) excluded_members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>The identifier to use for the new endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = Some(input.into());
            self
        }
        /// <p>The identifier to use for the new endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = input;
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_type = Some(input.into());
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// Appends an item to `static_members`.
        ///
        /// To override the contents of this collection use [`set_static_members`](Self::set_static_members).
        ///
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn static_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.static_members.unwrap_or_default();
            v.push(input.into());
            self.static_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn set_static_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.static_members = input;
            self
        }
        /// Appends an item to `excluded_members`.
        ///
        /// To override the contents of this collection use [`set_excluded_members`](Self::set_excluded_members).
        ///
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
        /// All other eligible instances are reachable through the custom endpoint.
        /// Only relevant if the list of static members is empty.</p>
        pub fn excluded_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.excluded_members.unwrap_or_default();
            v.push(input.into());
            self.excluded_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
        /// All other eligible instances are reachable through the custom endpoint.
        /// Only relevant if the list of static members is empty.</p>
        pub fn set_excluded_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.excluded_members = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Amazon Neptune resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the Amazon Neptune resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbClusterEndpointInput`](crate::input::CreateDbClusterEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbClusterEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbClusterEndpointInput {
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_endpoint_identifier: self.db_cluster_endpoint_identifier,
                endpoint_type: self.endpoint_type,
                static_members: self.static_members,
                excluded_members: self.excluded_members,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbClusterEndpointInputOperationOutputAlias =
    crate::operation::CreateDBClusterEndpoint;
#[doc(hidden)]
pub type CreateDbClusterEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDbClusterEndpointInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBClusterEndpoint`](crate::operation::CreateDBClusterEndpoint)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBClusterEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDbClusterEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDbClusterEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDbClusterEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_db_cluster_endpoint(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBClusterEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBClusterEndpoint",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDbClusterEndpointInput`](crate::input::CreateDbClusterEndpointInput)
    pub fn builder() -> crate::input::create_db_cluster_endpoint_input::Builder {
        crate::input::create_db_cluster_endpoint_input::Builder::default()
    }
}

/// See [`CreateDbClusterParameterGroupInput`](crate::input::CreateDbClusterParameterGroupInput)
pub mod create_db_cluster_parameter_group_input {
    /// A builder for [`CreateDbClusterParameterGroupInput`](crate::input::CreateDbClusterParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// <p>The DB cluster parameter group family name. A DB cluster parameter group can be associated
        /// with one and only one DB cluster parameter group family, and can be applied only to a DB
        /// cluster running a database engine and engine version compatible with that DB cluster parameter
        /// group family.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The DB cluster parameter group family name. A DB cluster parameter group can be associated
        /// with one and only one DB cluster parameter group family, and can be applied only to a DB
        /// cluster running a database engine and engine version compatible with that DB cluster parameter
        /// group family.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// <p>The description for the DB cluster parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the DB cluster parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the new DB cluster parameter group.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the new DB cluster parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbClusterParameterGroupInput`](crate::input::CreateDbClusterParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbClusterParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbClusterParameterGroupInput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                db_parameter_group_family: self.db_parameter_group_family,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbClusterParameterGroupInputOperationOutputAlias =
    crate::operation::CreateDBClusterParameterGroup;
#[doc(hidden)]
pub type CreateDbClusterParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDbClusterParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBClusterParameterGroup`](crate::operation::CreateDBClusterParameterGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBClusterParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDbClusterParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDbClusterParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDbClusterParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_db_cluster_parameter_group(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBClusterParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBClusterParameterGroup",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDbClusterParameterGroupInput`](crate::input::CreateDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::create_db_cluster_parameter_group_input::Builder {
        crate::input::create_db_cluster_parameter_group_input::Builder::default()
    }
}

/// See [`CreateDbClusterSnapshotInput`](crate::input::CreateDbClusterSnapshotInput)
pub mod create_db_cluster_snapshot_input {
    /// A builder for [`CreateDbClusterSnapshotInput`](crate::input::CreateDbClusterSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier of the DB cluster snapshot. This parameter is stored as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1-snapshot1</code>
        /// </p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the DB cluster snapshot. This parameter is stored as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1-snapshot1</code>
        /// </p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = input;
            self
        }
        /// <p>The identifier of the DB cluster to create a snapshot for. This parameter is not
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the DB cluster to create a snapshot for. This parameter is not
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the DB cluster snapshot.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the DB cluster snapshot.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbClusterSnapshotInput`](crate::input::CreateDbClusterSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbClusterSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbClusterSnapshotInput {
                db_cluster_snapshot_identifier: self.db_cluster_snapshot_identifier,
                db_cluster_identifier: self.db_cluster_identifier,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbClusterSnapshotInputOperationOutputAlias =
    crate::operation::CreateDBClusterSnapshot;
#[doc(hidden)]
pub type CreateDbClusterSnapshotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDbClusterSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBClusterSnapshot`](crate::operation::CreateDBClusterSnapshot)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBClusterSnapshot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDbClusterSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDbClusterSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDbClusterSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_db_cluster_snapshot(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBClusterSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBClusterSnapshot",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDbClusterSnapshotInput`](crate::input::CreateDbClusterSnapshotInput)
    pub fn builder() -> crate::input::create_db_cluster_snapshot_input::Builder {
        crate::input::create_db_cluster_snapshot_input::Builder::default()
    }
}

/// See [`CreateDbInstanceInput`](crate::input::CreateDbInstanceInput)
pub mod create_db_instance_input {
    /// A builder for [`CreateDbInstanceInput`](crate::input::CreateDbInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_name: std::option::Option<std::string::String>,
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) allocated_storage: std::option::Option<i32>,
        pub(crate) db_instance_class: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) master_username: std::option::Option<std::string::String>,
        pub(crate) master_user_password: std::option::Option<std::string::String>,
        pub(crate) db_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) backup_retention_period: std::option::Option<i32>,
        pub(crate) preferred_backup_window: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) multi_az: std::option::Option<bool>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) license_model: std::option::Option<std::string::String>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) option_group_name: std::option::Option<std::string::String>,
        pub(crate) character_set_name: std::option::Option<std::string::String>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) storage_type: std::option::Option<std::string::String>,
        pub(crate) tde_credential_arn: std::option::Option<std::string::String>,
        pub(crate) tde_credential_password: std::option::Option<std::string::String>,
        pub(crate) storage_encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) copy_tags_to_snapshot: std::option::Option<bool>,
        pub(crate) monitoring_interval: std::option::Option<i32>,
        pub(crate) monitoring_role_arn: std::option::Option<std::string::String>,
        pub(crate) domain_iam_role_name: std::option::Option<std::string::String>,
        pub(crate) promotion_tier: std::option::Option<i32>,
        pub(crate) timezone: std::option::Option<std::string::String>,
        pub(crate) enable_iam_database_authentication: std::option::Option<bool>,
        pub(crate) enable_performance_insights: std::option::Option<bool>,
        pub(crate) performance_insights_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) enable_cloudwatch_logs_exports:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) deletion_protection: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Not supported.</p>
        pub fn db_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_name = Some(input.into());
            self
        }
        /// <p>Not supported.</p>
        pub fn set_db_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_name = input;
            self
        }
        /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code>
        /// </p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code>
        /// </p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.allocated_storage = Some(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_storage = input;
            self
        }
        /// <p>The compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>.
        /// Not all DB instance classes are available in all Amazon Regions.</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_class = Some(input.into());
            self
        }
        /// <p>The compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>.
        /// Not all DB instance classes are available in all Amazon Regions.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_class = input;
            self
        }
        /// <p>The name of the database engine to be used for this instance.</p>
        /// <p>Valid Values: <code>neptune</code>
        /// </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the database engine to be used for this instance.</p>
        /// <p>Valid Values: <code>neptune</code>
        /// </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_username = Some(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_username = input;
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_password = Some(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_password = input;
            self
        }
        /// Appends an item to `db_security_groups`.
        ///
        /// To override the contents of this collection use [`set_db_security_groups`](Self::set_db_security_groups).
        ///
        /// <p>A list of DB security groups to associate with this DB instance.</p>
        /// <p>Default: The default DB security group for the database engine.</p>
        pub fn db_security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.db_security_groups.unwrap_or_default();
            v.push(input.into());
            self.db_security_groups = Some(v);
            self
        }
        /// <p>A list of DB security groups to associate with this DB instance.</p>
        /// <p>Default: The default DB security group for the database engine.</p>
        pub fn set_db_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.db_security_groups = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of EC2 VPC security groups to associate with this DB instance.</p>
        /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB
        /// cluster. For more information, see <a>CreateDBCluster</a>.</p>
        /// <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>A list of EC2 VPC security groups to associate with this DB instance.</p>
        /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB
        /// cluster. For more information, see <a>CreateDBCluster</a>.</p>
        /// <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// <p> The EC2 Availability Zone that the DB instance is created in</p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Region.</p>
        /// <p> Example: <code>us-east-1d</code>
        /// </p>
        /// <p> Constraint: The AvailabilityZone parameter can't be specified if the MultiAZ parameter is
        /// set to <code>true</code>. The specified Availability Zone must be in the same Amazon Region as
        /// the current endpoint.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p> The EC2 Availability Zone that the DB instance is created in</p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Region.</p>
        /// <p> Example: <code>us-east-1d</code>
        /// </p>
        /// <p> Constraint: The AvailabilityZone parameter can't be specified if the MultiAZ parameter is
        /// set to <code>true</code>. The specified Availability Zone must be in the same Amazon Region as
        /// the current endpoint.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>A DB subnet group to associate with this DB instance.</p>
        /// <p>If there is no DB subnet group, then it is a non-VPC DB instance.</p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>A DB subnet group to associate with this DB instance.</p>
        /// <p>If there is no DB subnet group, then it is a non-VPC DB instance.</p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// <p>The time range each week during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region, occurring on a random day of the week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>The time range each week during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region, occurring on a random day of the week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>The name of the DB parameter group to associate with this DB instance. If this argument is
        /// omitted, the default DBParameterGroup for the specified engine is used.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group to associate with this DB instance. If this argument is
        /// omitted, the default DBParameterGroup for the specified engine is used.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// <p>The number of days for which automated backups are
        /// retained.</p>
        /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster.
        /// For more information, see <a>CreateDBCluster</a>.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 0 to 35</p>
        /// </li>
        /// <li>
        /// <p>Cannot be set to 0 if the DB instance is a source to Read Replicas</p>
        /// </li>
        /// </ul>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.backup_retention_period = Some(input);
            self
        }
        /// <p>The number of days for which automated backups are
        /// retained.</p>
        /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster.
        /// For more information, see <a>CreateDBCluster</a>.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 0 to 35</p>
        /// </li>
        /// <li>
        /// <p>Cannot be set to 0 if the DB instance is a source to Read Replicas</p>
        /// </li>
        /// </ul>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.backup_retention_period = input;
            self
        }
        /// <p> The daily time range during which automated backups are created.</p>
        /// <p>Not applicable. The daily time range for creating automated backups is managed by the DB
        /// cluster. For more information, see <a>CreateDBCluster</a>.</p>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_backup_window = Some(input.into());
            self
        }
        /// <p> The daily time range during which automated backups are created.</p>
        /// <p>Not applicable. The daily time range for creating automated backups is managed by the DB
        /// cluster. For more information, see <a>CreateDBCluster</a>.</p>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_backup_window = input;
            self
        }
        /// <p>The port number on which the database accepts connections.</p>
        /// <p>Not applicable. The port is managed by the DB cluster. For more information, see <a>CreateDBCluster</a>.</p>
        /// <p> Default: <code>8182</code>
        /// </p>
        /// <p>Type: Integer</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number on which the database accepts connections.</p>
        /// <p>Not applicable. The port is managed by the DB cluster. For more information, see <a>CreateDBCluster</a>.</p>
        /// <p> Default: <code>8182</code>
        /// </p>
        /// <p>Type: Integer</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Specifies if the DB instance is a Multi-AZ deployment. You can't set the AvailabilityZone
        /// parameter if the MultiAZ parameter is set to true.</p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.multi_az = Some(input);
            self
        }
        /// <p>Specifies if the DB instance is a Multi-AZ deployment. You can't set the AvailabilityZone
        /// parameter if the MultiAZ parameter is set to true.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az = input;
            self
        }
        /// <p>The version number of the database engine to use. Currently, setting this
        /// parameter has no effect.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the database engine to use. Currently, setting this
        /// parameter has no effect.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Indicates that minor engine upgrades are applied automatically to the DB instance during
        /// the maintenance window.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>Indicates that minor engine upgrades are applied automatically to the DB instance during
        /// the maintenance window.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>License model information for this DB instance.</p>
        /// <p> Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
        /// <code>general-public-license</code>
        /// </p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_model = Some(input.into());
            self
        }
        /// <p>License model information for this DB instance.</p>
        /// <p> Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
        /// <code>general-public-license</code>
        /// </p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_model = input;
            self
        }
        /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially
        /// allocated for the DB instance.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially
        /// allocated for the DB instance.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_name = Some(input.into());
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_name = input;
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn character_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.character_set_name = Some(input.into());
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.character_set_name = input;
            self
        }
        /// <p>This flag should no longer be used.</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p>This flag should no longer be used.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the new instance.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to assign to the new instance.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The identifier of the DB cluster that the instance will belong to.</p>
        /// <p>For information on creating a DB cluster, see <a>CreateDBCluster</a>.</p>
        /// <p>Type: String</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the DB cluster that the instance will belong to.</p>
        /// <p>For information on creating a DB cluster, see <a>CreateDBCluster</a>.</p>
        /// <p>Type: String</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>Specifies the storage type to be associated with the DB instance.</p>
        /// <p>Not applicable. Storage is managed by the DB Cluster.</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type = Some(input.into());
            self
        }
        /// <p>Specifies the storage type to be associated with the DB instance.</p>
        /// <p>Not applicable. Storage is managed by the DB Cluster.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
        pub fn tde_credential_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tde_credential_arn = Some(input.into());
            self
        }
        /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
        pub fn set_tde_credential_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tde_credential_arn = input;
            self
        }
        /// <p>The password for the given ARN from the key store in order to access the device.</p>
        pub fn tde_credential_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.tde_credential_password = Some(input.into());
            self
        }
        /// <p>The password for the given ARN from the key store in order to access the device.</p>
        pub fn set_tde_credential_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tde_credential_password = input;
            self
        }
        /// <p>Specifies whether the DB instance is encrypted.</p>
        /// <p>Not applicable. The encryption for DB instances is managed by the DB cluster. For more
        /// information, see <a>CreateDBCluster</a>.</p>
        /// <p>Default: false</p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.storage_encrypted = Some(input);
            self
        }
        /// <p>Specifies whether the DB instance is encrypted.</p>
        /// <p>Not applicable. The encryption for DB instances is managed by the DB cluster. For more
        /// information, see <a>CreateDBCluster</a>.</p>
        /// <p>Default: false</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_encrypted = input;
            self
        }
        /// <p>The Amazon KMS key identifier for an encrypted DB instance.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
        /// you are creating a DB instance with the same Amazon account that owns the KMS encryption key used
        /// to encrypt the new DB instance, then you can use the KMS key alias instead of the ARN for the
        /// KM encryption key.</p>
        /// <p>Not applicable. The KMS key identifier is managed by the DB cluster. For more information,
        /// see <a>CreateDBCluster</a>.</p>
        /// <p>If the <code>StorageEncrypted</code> parameter is true, and you do not specify a value for
        /// the <code>KmsKeyId</code> parameter, then Amazon Neptune will use your default encryption key.
        /// Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a
        /// different default encryption key for each Amazon Region.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon KMS key identifier for an encrypted DB instance.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
        /// you are creating a DB instance with the same Amazon account that owns the KMS encryption key used
        /// to encrypt the new DB instance, then you can use the KMS key alias instead of the ARN for the
        /// KM encryption key.</p>
        /// <p>Not applicable. The KMS key identifier is managed by the DB cluster. For more information,
        /// see <a>CreateDBCluster</a>.</p>
        /// <p>If the <code>StorageEncrypted</code> parameter is true, and you do not specify a value for
        /// the <code>KmsKeyId</code> parameter, then Amazon Neptune will use your default encryption key.
        /// Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a
        /// different default encryption key for each Amazon Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Specify the Active Directory Domain to create the instance in.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>Specify the Active Directory Domain to create the instance in.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise
        /// false. The default is false.</p>
        pub fn copy_tags_to_snapshot(mut self, input: bool) -> Self {
            self.copy_tags_to_snapshot = Some(input);
            self
        }
        /// <p>True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise
        /// false. The default is false.</p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags_to_snapshot = input;
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected
        /// for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default
        /// is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must also set
        /// <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
        /// </p>
        pub fn monitoring_interval(mut self, input: i32) -> Self {
            self.monitoring_interval = Some(input);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected
        /// for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default
        /// is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must also set
        /// <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
        /// </p>
        pub fn set_monitoring_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.monitoring_interval = input;
            self
        }
        /// <p>The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to
        /// Amazon CloudWatch Logs. For example,
        /// <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
        /// <code>MonitoringRoleArn</code> value.</p>
        pub fn monitoring_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitoring_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to
        /// Amazon CloudWatch Logs. For example,
        /// <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
        /// <code>MonitoringRoleArn</code> value.</p>
        pub fn set_monitoring_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitoring_role_arn = input;
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory
        /// Service.</p>
        pub fn domain_iam_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_iam_role_name = Some(input.into());
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory
        /// Service.</p>
        pub fn set_domain_iam_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_iam_role_name = input;
            self
        }
        /// <p>A value that specifies the order in which an Read Replica is promoted to the primary
        /// instance after a failure of the existing primary instance.
        /// </p>
        /// <p>Default: 1</p>
        /// <p>Valid Values: 0 - 15</p>
        pub fn promotion_tier(mut self, input: i32) -> Self {
            self.promotion_tier = Some(input);
            self
        }
        /// <p>A value that specifies the order in which an Read Replica is promoted to the primary
        /// instance after a failure of the existing primary instance.
        /// </p>
        /// <p>Default: 1</p>
        /// <p>Valid Values: 0 - 15</p>
        pub fn set_promotion_tier(mut self, input: std::option::Option<i32>) -> Self {
            self.promotion_tier = input;
            self
        }
        /// <p>The time zone of the DB instance.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>The time zone of the DB instance.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// <p>Not supported by Neptune (ignored).</p>
        pub fn enable_iam_database_authentication(mut self, input: bool) -> Self {
            self.enable_iam_database_authentication = Some(input);
            self
        }
        /// <p>Not supported by Neptune (ignored).</p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_iam_database_authentication = input;
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn enable_performance_insights(mut self, input: bool) -> Self {
            self.enable_performance_insights = Some(input);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_enable_performance_insights(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_performance_insights = input;
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn performance_insights_kms_key_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.performance_insights_kms_key_id = Some(input.into());
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_performance_insights_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.performance_insights_kms_key_id = input;
            self
        }
        /// Appends an item to `enable_cloudwatch_logs_exports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.enable_cloudwatch_logs_exports.unwrap_or_default();
            v.push(input.into());
            self.enable_cloudwatch_logs_exports = Some(v);
            self
        }
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.enable_cloudwatch_logs_exports = input;
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting
        /// a DB Instance</a>.</p>
        ///
        /// <p>DB instances in a DB cluster can be deleted even when deletion
        /// protection is enabled in their parent DB cluster.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting
        /// a DB Instance</a>.</p>
        ///
        /// <p>DB instances in a DB cluster can be deleted even when deletion
        /// protection is enabled in their parent DB cluster.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbInstanceInput`](crate::input::CreateDbInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbInstanceInput {
                db_name: self.db_name,
                db_instance_identifier: self.db_instance_identifier,
                allocated_storage: self.allocated_storage,
                db_instance_class: self.db_instance_class,
                engine: self.engine,
                master_username: self.master_username,
                master_user_password: self.master_user_password,
                db_security_groups: self.db_security_groups,
                vpc_security_group_ids: self.vpc_security_group_ids,
                availability_zone: self.availability_zone,
                db_subnet_group_name: self.db_subnet_group_name,
                preferred_maintenance_window: self.preferred_maintenance_window,
                db_parameter_group_name: self.db_parameter_group_name,
                backup_retention_period: self.backup_retention_period,
                preferred_backup_window: self.preferred_backup_window,
                port: self.port,
                multi_az: self.multi_az,
                engine_version: self.engine_version,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade,
                license_model: self.license_model,
                iops: self.iops,
                option_group_name: self.option_group_name,
                character_set_name: self.character_set_name,
                publicly_accessible: self.publicly_accessible,
                tags: self.tags,
                db_cluster_identifier: self.db_cluster_identifier,
                storage_type: self.storage_type,
                tde_credential_arn: self.tde_credential_arn,
                tde_credential_password: self.tde_credential_password,
                storage_encrypted: self.storage_encrypted,
                kms_key_id: self.kms_key_id,
                domain: self.domain,
                copy_tags_to_snapshot: self.copy_tags_to_snapshot,
                monitoring_interval: self.monitoring_interval,
                monitoring_role_arn: self.monitoring_role_arn,
                domain_iam_role_name: self.domain_iam_role_name,
                promotion_tier: self.promotion_tier,
                timezone: self.timezone,
                enable_iam_database_authentication: self.enable_iam_database_authentication,
                enable_performance_insights: self.enable_performance_insights,
                performance_insights_kms_key_id: self.performance_insights_kms_key_id,
                enable_cloudwatch_logs_exports: self.enable_cloudwatch_logs_exports,
                deletion_protection: self.deletion_protection,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbInstanceInputOperationOutputAlias = crate::operation::CreateDBInstance;
#[doc(hidden)]
pub type CreateDbInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDbInstanceInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBInstance`](crate::operation::CreateDBInstance)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDbInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDbInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDbInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_db_instance(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBInstance",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDbInstanceInput`](crate::input::CreateDbInstanceInput)
    pub fn builder() -> crate::input::create_db_instance_input::Builder {
        crate::input::create_db_instance_input::Builder::default()
    }
}

/// See [`CreateDbParameterGroupInput`](crate::input::CreateDbParameterGroupInput)
pub mod create_db_parameter_group_input {
    /// A builder for [`CreateDbParameterGroupInput`](crate::input::CreateDbParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// <p>The DB parameter group family name. A DB parameter group can be associated with one and
        /// only one DB parameter group family, and can be applied only to a DB instance running a
        /// database engine and engine version compatible with that DB parameter group family.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The DB parameter group family name. A DB parameter group can be associated with one and
        /// only one DB parameter group family, and can be applied only to a DB instance running a
        /// database engine and engine version compatible with that DB parameter group family.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// <p>The description for the DB parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the DB parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the new DB parameter group.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the new DB parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbParameterGroupInput`](crate::input::CreateDbParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbParameterGroupInput {
                db_parameter_group_name: self.db_parameter_group_name,
                db_parameter_group_family: self.db_parameter_group_family,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbParameterGroupInputOperationOutputAlias = crate::operation::CreateDBParameterGroup;
#[doc(hidden)]
pub type CreateDbParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDbParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBParameterGroup`](crate::operation::CreateDBParameterGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDbParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDbParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDbParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_db_parameter_group(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBParameterGroup",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDbParameterGroupInput`](crate::input::CreateDbParameterGroupInput)
    pub fn builder() -> crate::input::create_db_parameter_group_input::Builder {
        crate::input::create_db_parameter_group_input::Builder::default()
    }
}

/// See [`CreateDbSubnetGroupInput`](crate::input::CreateDbSubnetGroupInput)
pub mod create_db_subnet_group_input {
    /// A builder for [`CreateDbSubnetGroupInput`](crate::input::CreateDbSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group_description: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name for the DB subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 letters, numbers, periods, underscores, spaces,
        /// or hyphens. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name for the DB subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 letters, numbers, periods, underscores, spaces,
        /// or hyphens. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// <p>The description for the DB subnet group.</p>
        pub fn db_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_subnet_group_description = Some(input.into());
            self
        }
        /// <p>The description for the DB subnet group.</p>
        pub fn set_db_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_description = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The EC2 Subnet IDs for the DB subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The EC2 Subnet IDs for the DB subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the new DB subnet group.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the new DB subnet group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbSubnetGroupInput`](crate::input::CreateDbSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbSubnetGroupInput {
                db_subnet_group_name: self.db_subnet_group_name,
                db_subnet_group_description: self.db_subnet_group_description,
                subnet_ids: self.subnet_ids,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbSubnetGroupInputOperationOutputAlias = crate::operation::CreateDBSubnetGroup;
#[doc(hidden)]
pub type CreateDbSubnetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDbSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBSubnetGroup`](crate::operation::CreateDBSubnetGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBSubnetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDbSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDbSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDbSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_db_subnet_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBSubnetGroup",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDbSubnetGroupInput`](crate::input::CreateDbSubnetGroupInput)
    pub fn builder() -> crate::input::create_db_subnet_group_input::Builder {
        crate::input::create_db_subnet_group_input::Builder::default()
    }
}

/// See [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
pub mod create_event_subscription_input {
    /// A builder for [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) source_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the subscription.</p>
        /// <p>Constraints: The name must be less than 255 characters.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the subscription.</p>
        /// <p>Constraints: The name must be less than 255 characters.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is
        /// created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is
        /// created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified
        /// of events generated by a DB instance, you would set this parameter to db-instance. if this
        /// value is not specified, all events are returned.</p>
        /// <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> |
        /// <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> |
        /// <code>db-cluster-snapshot</code>
        /// </p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified
        /// of events generated by a DB instance, you would set this parameter to db-instance. if this
        /// value is not specified, all events are returned.</p>
        /// <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> |
        /// <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> |
        /// <code>db-cluster-snapshot</code>
        /// </p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p> A list of event categories for a SourceType that you want to subscribe to. You can see a
        /// list of the categories for a given SourceType by using the
        /// <b>DescribeEventCategories</b> action.</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p> A list of event categories for a SourceType that you want to subscribe to. You can see a
        /// list of the categories for a given SourceType by using the
        /// <b>DescribeEventCategories</b> action.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// Appends an item to `source_ids`.
        ///
        /// To override the contents of this collection use [`set_source_ids`](Self::set_source_ids).
        ///
        /// <p>The list of identifiers of the event sources for which events are returned. If not
        /// specified, then all sources are included in the response. An identifier must begin with a
        /// letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or
        /// contain two consecutive hyphens.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If SourceIds are supplied, SourceType must also be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be
        /// supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be
        /// supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must
        /// be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be
        /// supplied.</p>
        /// </li>
        /// </ul>
        pub fn source_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_ids.unwrap_or_default();
            v.push(input.into());
            self.source_ids = Some(v);
            self
        }
        /// <p>The list of identifiers of the event sources for which events are returned. If not
        /// specified, then all sources are included in the response. An identifier must begin with a
        /// letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or
        /// contain two consecutive hyphens.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If SourceIds are supplied, SourceType must also be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be
        /// supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be
        /// supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must
        /// be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be
        /// supplied.</p>
        /// </li>
        /// </ul>
        pub fn set_source_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_ids = input;
            self
        }
        /// <p> A Boolean value; set to <b>true</b> to activate the
        /// subscription, set to <b>false</b> to create the subscription but not
        /// active it.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p> A Boolean value; set to <b>true</b> to activate the
        /// subscription, set to <b>false</b> to create the subscription but not
        /// active it.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be applied to the new event subscription.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be applied to the new event subscription.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEventSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEventSubscriptionInput {
                subscription_name: self.subscription_name,
                sns_topic_arn: self.sns_topic_arn,
                source_type: self.source_type,
                event_categories: self.event_categories,
                source_ids: self.source_ids,
                enabled: self.enabled,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEventSubscriptionInputOperationOutputAlias =
    crate::operation::CreateEventSubscription;
#[doc(hidden)]
pub type CreateEventSubscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEventSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`CreateEventSubscription`](crate::operation::CreateEventSubscription)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEventSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEventSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEventSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEventSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_event_subscription(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEventSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEventSubscription",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
    pub fn builder() -> crate::input::create_event_subscription_input::Builder {
        crate::input::create_event_subscription_input::Builder::default()
    }
}

/// See [`DeleteDbClusterInput`](crate::input::DeleteDbClusterInput)
pub mod delete_db_cluster_input {
    /// A builder for [`DeleteDbClusterInput`](crate::input::DeleteDbClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) skip_final_snapshot: std::option::Option<bool>,
        pub(crate) final_db_snapshot_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The DB cluster identifier for the DB cluster to be deleted. This parameter isn't
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match an existing DBClusterIdentifier.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier for the DB cluster to be deleted. This parameter isn't
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match an existing DBClusterIdentifier.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p> Determines whether a final DB cluster snapshot is created before the DB cluster is
        /// deleted. If <code>true</code> is specified, no DB cluster snapshot is created. If
        /// <code>false</code> is specified, a DB cluster snapshot is created before the DB cluster is
        /// deleted.</p>
        /// <note>
        /// <p>You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if
        /// <code>SkipFinalSnapshot</code> is <code>false</code>.</p>
        /// </note>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn skip_final_snapshot(mut self, input: bool) -> Self {
            self.skip_final_snapshot = Some(input);
            self
        }
        /// <p> Determines whether a final DB cluster snapshot is created before the DB cluster is
        /// deleted. If <code>true</code> is specified, no DB cluster snapshot is created. If
        /// <code>false</code> is specified, a DB cluster snapshot is created before the DB cluster is
        /// deleted.</p>
        /// <note>
        /// <p>You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if
        /// <code>SkipFinalSnapshot</code> is <code>false</code>.</p>
        /// </note>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_skip_final_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_final_snapshot = input;
            self
        }
        /// <p> The DB cluster snapshot identifier of the new DB cluster snapshot created when
        /// <code>SkipFinalSnapshot</code> is set to <code>false</code>.</p>
        /// <note>
        /// <p> Specifying this parameter and also setting the <code>SkipFinalShapshot</code> parameter
        /// to true results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn final_db_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.final_db_snapshot_identifier = Some(input.into());
            self
        }
        /// <p> The DB cluster snapshot identifier of the new DB cluster snapshot created when
        /// <code>SkipFinalSnapshot</code> is set to <code>false</code>.</p>
        /// <note>
        /// <p> Specifying this parameter and also setting the <code>SkipFinalShapshot</code> parameter
        /// to true results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn set_final_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.final_db_snapshot_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbClusterInput`](crate::input::DeleteDbClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbClusterInput {
                db_cluster_identifier: self.db_cluster_identifier,
                skip_final_snapshot: self.skip_final_snapshot.unwrap_or_default(),
                final_db_snapshot_identifier: self.final_db_snapshot_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbClusterInputOperationOutputAlias = crate::operation::DeleteDBCluster;
#[doc(hidden)]
pub type DeleteDbClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDbClusterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBCluster`](crate::operation::DeleteDBCluster)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDbClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDbClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDbClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_db_cluster(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBCluster",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterInput`](crate::input::DeleteDbClusterInput)
    pub fn builder() -> crate::input::delete_db_cluster_input::Builder {
        crate::input::delete_db_cluster_input::Builder::default()
    }
}

/// See [`DeleteDbClusterEndpointInput`](crate::input::DeleteDbClusterEndpointInput)
pub mod delete_db_cluster_endpoint_input {
    /// A builder for [`DeleteDbClusterEndpointInput`](crate::input::DeleteDbClusterEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = Some(input.into());
            self
        }
        /// <p>The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbClusterEndpointInput`](crate::input::DeleteDbClusterEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbClusterEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbClusterEndpointInput {
                db_cluster_endpoint_identifier: self.db_cluster_endpoint_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbClusterEndpointInputOperationOutputAlias =
    crate::operation::DeleteDBClusterEndpoint;
#[doc(hidden)]
pub type DeleteDbClusterEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDbClusterEndpointInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBClusterEndpoint`](crate::operation::DeleteDBClusterEndpoint)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBClusterEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDbClusterEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDbClusterEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDbClusterEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_db_cluster_endpoint(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBClusterEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBClusterEndpoint",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterEndpointInput`](crate::input::DeleteDbClusterEndpointInput)
    pub fn builder() -> crate::input::delete_db_cluster_endpoint_input::Builder {
        crate::input::delete_db_cluster_endpoint_input::Builder::default()
    }
}

/// See [`DeleteDbClusterParameterGroupInput`](crate::input::DeleteDbClusterParameterGroupInput)
pub mod delete_db_cluster_parameter_group_input {
    /// A builder for [`DeleteDbClusterParameterGroupInput`](crate::input::DeleteDbClusterParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing DB cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>You can't delete a default DB cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be associated with any DB clusters.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing DB cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>You can't delete a default DB cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be associated with any DB clusters.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbClusterParameterGroupInput`](crate::input::DeleteDbClusterParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbClusterParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbClusterParameterGroupInput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbClusterParameterGroupInputOperationOutputAlias =
    crate::operation::DeleteDBClusterParameterGroup;
#[doc(hidden)]
pub type DeleteDbClusterParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDbClusterParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBClusterParameterGroup`](crate::operation::DeleteDBClusterParameterGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBClusterParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDbClusterParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDbClusterParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDbClusterParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_db_cluster_parameter_group(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBClusterParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBClusterParameterGroup",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterParameterGroupInput`](crate::input::DeleteDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::delete_db_cluster_parameter_group_input::Builder {
        crate::input::delete_db_cluster_parameter_group_input::Builder::default()
    }
}

/// See [`DeleteDbClusterSnapshotInput`](crate::input::DeleteDbClusterSnapshotInput)
pub mod delete_db_cluster_snapshot_input {
    /// A builder for [`DeleteDbClusterSnapshotInput`](crate::input::DeleteDbClusterSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the DB cluster snapshot to delete.</p>
        /// <p>Constraints: Must be the name of an existing DB cluster snapshot in the
        /// <code>available</code> state.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the DB cluster snapshot to delete.</p>
        /// <p>Constraints: Must be the name of an existing DB cluster snapshot in the
        /// <code>available</code> state.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbClusterSnapshotInput`](crate::input::DeleteDbClusterSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbClusterSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbClusterSnapshotInput {
                db_cluster_snapshot_identifier: self.db_cluster_snapshot_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbClusterSnapshotInputOperationOutputAlias =
    crate::operation::DeleteDBClusterSnapshot;
#[doc(hidden)]
pub type DeleteDbClusterSnapshotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDbClusterSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBClusterSnapshot`](crate::operation::DeleteDBClusterSnapshot)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBClusterSnapshot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDbClusterSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDbClusterSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDbClusterSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_db_cluster_snapshot(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBClusterSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBClusterSnapshot",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterSnapshotInput`](crate::input::DeleteDbClusterSnapshotInput)
    pub fn builder() -> crate::input::delete_db_cluster_snapshot_input::Builder {
        crate::input::delete_db_cluster_snapshot_input::Builder::default()
    }
}

/// See [`DeleteDbInstanceInput`](crate::input::DeleteDbInstanceInput)
pub mod delete_db_instance_input {
    /// A builder for [`DeleteDbInstanceInput`](crate::input::DeleteDbInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) skip_final_snapshot: std::option::Option<bool>,
        pub(crate) final_db_snapshot_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The DB instance identifier for the DB instance to be deleted. This parameter isn't
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing DB instance.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The DB instance identifier for the DB instance to be deleted. This parameter isn't
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing DB instance.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p> Determines whether a final DB snapshot is created before the DB instance is deleted. If
        /// <code>true</code> is specified, no DBSnapshot is created. If <code>false</code> is specified,
        /// a DB snapshot is created before the DB instance is deleted.</p>
        /// <p>Note that when a DB instance is in a failure state and has a status of 'failed',
        /// 'incompatible-restore', or 'incompatible-network', it can only be deleted when the
        /// SkipFinalSnapshot parameter is set to "true".</p>
        /// <p>Specify <code>true</code> when deleting a Read Replica.</p>
        /// <note>
        /// <p>The FinalDBSnapshotIdentifier parameter must be specified if SkipFinalSnapshot is
        /// <code>false</code>.</p>
        /// </note>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn skip_final_snapshot(mut self, input: bool) -> Self {
            self.skip_final_snapshot = Some(input);
            self
        }
        /// <p> Determines whether a final DB snapshot is created before the DB instance is deleted. If
        /// <code>true</code> is specified, no DBSnapshot is created. If <code>false</code> is specified,
        /// a DB snapshot is created before the DB instance is deleted.</p>
        /// <p>Note that when a DB instance is in a failure state and has a status of 'failed',
        /// 'incompatible-restore', or 'incompatible-network', it can only be deleted when the
        /// SkipFinalSnapshot parameter is set to "true".</p>
        /// <p>Specify <code>true</code> when deleting a Read Replica.</p>
        /// <note>
        /// <p>The FinalDBSnapshotIdentifier parameter must be specified if SkipFinalSnapshot is
        /// <code>false</code>.</p>
        /// </note>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_skip_final_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_final_snapshot = input;
            self
        }
        /// <p> The DBSnapshotIdentifier of the new DBSnapshot created when SkipFinalSnapshot is set to
        /// <code>false</code>.</p>
        /// <note>
        /// <p>Specifying this parameter and also setting the SkipFinalShapshot parameter to true
        /// results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified when deleting a Read Replica.</p>
        /// </li>
        /// </ul>
        pub fn final_db_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.final_db_snapshot_identifier = Some(input.into());
            self
        }
        /// <p> The DBSnapshotIdentifier of the new DBSnapshot created when SkipFinalSnapshot is set to
        /// <code>false</code>.</p>
        /// <note>
        /// <p>Specifying this parameter and also setting the SkipFinalShapshot parameter to true
        /// results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified when deleting a Read Replica.</p>
        /// </li>
        /// </ul>
        pub fn set_final_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.final_db_snapshot_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbInstanceInput`](crate::input::DeleteDbInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbInstanceInput {
                db_instance_identifier: self.db_instance_identifier,
                skip_final_snapshot: self.skip_final_snapshot.unwrap_or_default(),
                final_db_snapshot_identifier: self.final_db_snapshot_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbInstanceInputOperationOutputAlias = crate::operation::DeleteDBInstance;
#[doc(hidden)]
pub type DeleteDbInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDbInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBInstance`](crate::operation::DeleteDBInstance)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDbInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDbInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDbInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_db_instance(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBInstance",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbInstanceInput`](crate::input::DeleteDbInstanceInput)
    pub fn builder() -> crate::input::delete_db_instance_input::Builder {
        crate::input::delete_db_instance_input::Builder::default()
    }
}

/// See [`DeleteDbParameterGroupInput`](crate::input::DeleteDbParameterGroupInput)
pub mod delete_db_parameter_group_input {
    /// A builder for [`DeleteDbParameterGroupInput`](crate::input::DeleteDbParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing DB parameter group</p>
        /// </li>
        /// <li>
        /// <p>You can't delete a default DB parameter group</p>
        /// </li>
        /// <li>
        /// <p>Cannot be associated with any DB instances</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing DB parameter group</p>
        /// </li>
        /// <li>
        /// <p>You can't delete a default DB parameter group</p>
        /// </li>
        /// <li>
        /// <p>Cannot be associated with any DB instances</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbParameterGroupInput`](crate::input::DeleteDbParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbParameterGroupInput {
                db_parameter_group_name: self.db_parameter_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbParameterGroupInputOperationOutputAlias = crate::operation::DeleteDBParameterGroup;
#[doc(hidden)]
pub type DeleteDbParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDbParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBParameterGroup`](crate::operation::DeleteDBParameterGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDbParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDbParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDbParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_db_parameter_group(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBParameterGroup",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbParameterGroupInput`](crate::input::DeleteDbParameterGroupInput)
    pub fn builder() -> crate::input::delete_db_parameter_group_input::Builder {
        crate::input::delete_db_parameter_group_input::Builder::default()
    }
}

/// See [`DeleteDbSubnetGroupInput`](crate::input::DeleteDbSubnetGroupInput)
pub mod delete_db_subnet_group_input {
    /// A builder for [`DeleteDbSubnetGroupInput`](crate::input::DeleteDbSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the database subnet group to delete.</p>
        /// <note>
        /// <p>You can't delete the default subnet group.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the database subnet group to delete.</p>
        /// <note>
        /// <p>You can't delete the default subnet group.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbSubnetGroupInput`](crate::input::DeleteDbSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbSubnetGroupInput {
                db_subnet_group_name: self.db_subnet_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbSubnetGroupInputOperationOutputAlias = crate::operation::DeleteDBSubnetGroup;
#[doc(hidden)]
pub type DeleteDbSubnetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDbSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBSubnetGroup`](crate::operation::DeleteDBSubnetGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBSubnetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDbSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDbSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDbSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_db_subnet_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBSubnetGroup",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbSubnetGroupInput`](crate::input::DeleteDbSubnetGroupInput)
    pub fn builder() -> crate::input::delete_db_subnet_group_input::Builder {
        crate::input::delete_db_subnet_group_input::Builder::default()
    }
}

/// See [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
pub mod delete_event_subscription_input {
    /// A builder for [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the event notification subscription you want to delete.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the event notification subscription you want to delete.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEventSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEventSubscriptionInput {
                subscription_name: self.subscription_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEventSubscriptionInputOperationOutputAlias =
    crate::operation::DeleteEventSubscription;
#[doc(hidden)]
pub type DeleteEventSubscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEventSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEventSubscription`](crate::operation::DeleteEventSubscription)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEventSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEventSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEventSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEventSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_event_subscription(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEventSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEventSubscription",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
    pub fn builder() -> crate::input::delete_event_subscription_input::Builder {
        crate::input::delete_event_subscription_input::Builder::default()
    }
}

/// See [`DescribeDbClusterEndpointsInput`](crate::input::DescribeDbClusterEndpointsInput)
pub mod describe_db_cluster_endpoints_input {
    /// A builder for [`DescribeDbClusterEndpointsInput`](crate::input::DescribeDbClusterEndpointsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>The identifier of the endpoint to describe. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the endpoint to describe. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A set of name-value pairs that define which endpoints to include in the output.
        /// The filters are specified as name-value pairs, in the format
        /// <code>Name=<i>endpoint_type</i>,Values=<i>endpoint_type1</i>,<i>endpoint_type2</i>,...</code>.
        /// <code>Name</code> can be one of: <code>db-cluster-endpoint-type</code>, <code>db-cluster-endpoint-custom-type</code>, <code>db-cluster-endpoint-id</code>, <code>db-cluster-endpoint-status</code>.
        /// <code>Values</code> for the <code> db-cluster-endpoint-type</code> filter can be one or more of: <code>reader</code>, <code>writer</code>, <code>custom</code>.
        /// <code>Values</code> for the <code>db-cluster-endpoint-custom-type</code> filter can be one or more of: <code>reader</code>, <code>any</code>.
        /// <code>Values</code> for the <code>db-cluster-endpoint-status</code> filter can be one or more of: <code>available</code>, <code>creating</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>.
        /// </p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>A set of name-value pairs that define which endpoints to include in the output.
        /// The filters are specified as name-value pairs, in the format
        /// <code>Name=<i>endpoint_type</i>,Values=<i>endpoint_type1</i>,<i>endpoint_type2</i>,...</code>.
        /// <code>Name</code> can be one of: <code>db-cluster-endpoint-type</code>, <code>db-cluster-endpoint-custom-type</code>, <code>db-cluster-endpoint-id</code>, <code>db-cluster-endpoint-status</code>.
        /// <code>Values</code> for the <code> db-cluster-endpoint-type</code> filter can be one or more of: <code>reader</code>, <code>writer</code>, <code>custom</code>.
        /// <code>Values</code> for the <code>db-cluster-endpoint-custom-type</code> filter can be one or more of: <code>reader</code>, <code>any</code>.
        /// <code>Values</code> for the <code>db-cluster-endpoint-status</code> filter can be one or more of: <code>available</code>, <code>creating</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>.
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeDBClusterEndpoints</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeDBClusterEndpoints</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterEndpointsInput`](crate::input::DescribeDbClusterEndpointsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbClusterEndpointsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbClusterEndpointsInput {
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_endpoint_identifier: self.db_cluster_endpoint_identifier,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbClusterEndpointsInputOperationOutputAlias =
    crate::operation::DescribeDBClusterEndpoints;
#[doc(hidden)]
pub type DescribeDbClusterEndpointsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDbClusterEndpointsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBClusterEndpoints`](crate::operation::DescribeDBClusterEndpoints)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBClusterEndpoints,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDbClusterEndpointsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDbClusterEndpointsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDbClusterEndpointsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_db_cluster_endpoints(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBClusterEndpoints::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBClusterEndpoints",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterEndpointsInput`](crate::input::DescribeDbClusterEndpointsInput)
    pub fn builder() -> crate::input::describe_db_cluster_endpoints_input::Builder {
        crate::input::describe_db_cluster_endpoints_input::Builder::default()
    }
}

/// See [`DescribeDbClusterParameterGroupsInput`](crate::input::DescribeDbClusterParameterGroupsInput)
pub mod describe_db_cluster_parameter_groups_input {
    /// A builder for [`DescribeDbClusterParameterGroupsInput`](crate::input::DescribeDbClusterParameterGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a specific DB cluster parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of a specific DB cluster parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterParameterGroupsInput`](crate::input::DescribeDbClusterParameterGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbClusterParameterGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbClusterParameterGroupsInput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbClusterParameterGroupsInputOperationOutputAlias =
    crate::operation::DescribeDBClusterParameterGroups;
#[doc(hidden)]
pub type DescribeDbClusterParameterGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDbClusterParameterGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBClusterParameterGroups`](crate::operation::DescribeDBClusterParameterGroups)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBClusterParameterGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDbClusterParameterGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDbClusterParameterGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDbClusterParameterGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_db_cluster_parameter_groups(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBClusterParameterGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBClusterParameterGroups",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterParameterGroupsInput`](crate::input::DescribeDbClusterParameterGroupsInput)
    pub fn builder() -> crate::input::describe_db_cluster_parameter_groups_input::Builder {
        crate::input::describe_db_cluster_parameter_groups_input::Builder::default()
    }
}

/// See [`DescribeDbClusterParametersInput`](crate::input::DescribeDbClusterParametersInput)
pub mod describe_db_cluster_parameters_input {
    /// A builder for [`DescribeDbClusterParametersInput`](crate::input::DescribeDbClusterParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a specific DB cluster parameter group to return parameter details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of a specific DB cluster parameter group to return parameter details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// <p> A value that indicates to return only parameters for a specific source. Parameter sources
        /// can be <code>engine</code>, <code>service</code>, or <code>customer</code>.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p> A value that indicates to return only parameters for a specific source. Parameter sources
        /// can be <code>engine</code>, <code>service</code>, or <code>customer</code>.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeDBClusterParameters</code> request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeDBClusterParameters</code> request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterParametersInput`](crate::input::DescribeDbClusterParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbClusterParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbClusterParametersInput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                source: self.source,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbClusterParametersInputOperationOutputAlias =
    crate::operation::DescribeDBClusterParameters;
#[doc(hidden)]
pub type DescribeDbClusterParametersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDbClusterParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBClusterParameters`](crate::operation::DescribeDBClusterParameters)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBClusterParameters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDbClusterParametersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDbClusterParametersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDbClusterParametersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_db_cluster_parameters(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBClusterParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBClusterParameters",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterParametersInput`](crate::input::DescribeDbClusterParametersInput)
    pub fn builder() -> crate::input::describe_db_cluster_parameters_input::Builder {
        crate::input::describe_db_cluster_parameters_input::Builder::default()
    }
}

/// See [`DescribeDbClustersInput`](crate::input::DescribeDbClustersInput)
pub mod describe_db_clusters_input {
    /// A builder for [`DescribeDbClustersInput`](crate::input::DescribeDbClustersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user-supplied DB cluster identifier. If this parameter is specified, information from
        /// only the specific DB cluster is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match an existing DBClusterIdentifier.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The user-supplied DB cluster identifier. If this parameter is specified, information from
        /// only the specific DB cluster is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match an existing DBClusterIdentifier.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more DB clusters to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon
        /// Resource Names (ARNs). The results list will only include information about the DB
        /// clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>engine</code> - Accepts an engine name (such as <code>neptune</code>),
        /// and restricts the results list to DB clusters created by that engine.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>For example, to invoke this API from the Amazon CLI and filter so that only
        /// Neptune DB clusters are returned, you could use the following command:</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>A filter that specifies one or more DB clusters to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon
        /// Resource Names (ARNs). The results list will only include information about the DB
        /// clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>engine</code> - Accepts an engine name (such as <code>neptune</code>),
        /// and restricts the results list to DB clusters created by that engine.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>For example, to invoke this API from the Amazon CLI and filter so that only
        /// Neptune DB clusters are returned, you could use the following command:</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <a>DescribeDBClusters</a>
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <a>DescribeDBClusters</a>
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClustersInput`](crate::input::DescribeDbClustersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbClustersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbClustersInput {
                db_cluster_identifier: self.db_cluster_identifier,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbClustersInputOperationOutputAlias = crate::operation::DescribeDBClusters;
#[doc(hidden)]
pub type DescribeDbClustersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDbClustersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBClusters`](crate::operation::DescribeDBClusters)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBClusters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDbClustersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDbClustersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDbClustersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_db_clusters(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBClusters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBClusters",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbClustersInput`](crate::input::DescribeDbClustersInput)
    pub fn builder() -> crate::input::describe_db_clusters_input::Builder {
        crate::input::describe_db_clusters_input::Builder::default()
    }
}

/// See [`DescribeDbClusterSnapshotAttributesInput`](crate::input::DescribeDbClusterSnapshotAttributesInput)
pub mod describe_db_cluster_snapshot_attributes_input {
    /// A builder for [`DescribeDbClusterSnapshotAttributesInput`](crate::input::DescribeDbClusterSnapshotAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the DB cluster snapshot to describe the attributes for.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the DB cluster snapshot to describe the attributes for.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterSnapshotAttributesInput`](crate::input::DescribeDbClusterSnapshotAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbClusterSnapshotAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbClusterSnapshotAttributesInput {
                db_cluster_snapshot_identifier: self.db_cluster_snapshot_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbClusterSnapshotAttributesInputOperationOutputAlias =
    crate::operation::DescribeDBClusterSnapshotAttributes;
#[doc(hidden)]
pub type DescribeDbClusterSnapshotAttributesInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeDbClusterSnapshotAttributesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBClusterSnapshotAttributes`](crate::operation::DescribeDBClusterSnapshotAttributes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBClusterSnapshotAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDbClusterSnapshotAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDbClusterSnapshotAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDbClusterSnapshotAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_db_cluster_snapshot_attributes(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBClusterSnapshotAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBClusterSnapshotAttributes",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterSnapshotAttributesInput`](crate::input::DescribeDbClusterSnapshotAttributesInput)
    pub fn builder() -> crate::input::describe_db_cluster_snapshot_attributes_input::Builder {
        crate::input::describe_db_cluster_snapshot_attributes_input::Builder::default()
    }
}

/// See [`DescribeDbClusterSnapshotsInput`](crate::input::DescribeDbClusterSnapshotsInput)
pub mod describe_db_cluster_snapshots_input {
    /// A builder for [`DescribeDbClusterSnapshotsInput`](crate::input::DescribeDbClusterSnapshotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) snapshot_type: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) include_shared: std::option::Option<bool>,
        pub(crate) include_public: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the DB cluster to retrieve the list of DB cluster snapshots for. This parameter
        /// can't be used in conjunction with the <code>DBClusterSnapshotIdentifier</code> parameter. This
        /// parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the DB cluster to retrieve the list of DB cluster snapshots for. This parameter
        /// can't be used in conjunction with the <code>DBClusterSnapshotIdentifier</code> parameter. This
        /// parameter is not case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>A specific DB cluster snapshot identifier to describe. This parameter can't be used in
        /// conjunction with the <code>DBClusterIdentifier</code> parameter. This value is stored as a
        /// lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBClusterSnapshot.</p>
        /// </li>
        /// <li>
        /// <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code>
        /// parameter must also be specified.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>A specific DB cluster snapshot identifier to describe. This parameter can't be used in
        /// conjunction with the <code>DBClusterIdentifier</code> parameter. This value is stored as a
        /// lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBClusterSnapshot.</p>
        /// </li>
        /// <li>
        /// <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code>
        /// parameter must also be specified.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = input;
            self
        }
        /// <p>The type of DB cluster snapshots to be returned. You can specify one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>automated</code> - Return all DB cluster snapshots that have been automatically
        /// taken by Amazon Neptune for my Amazon account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>manual</code> - Return all DB cluster snapshots that have been taken by my AWS
        /// account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>shared</code> - Return all manual DB cluster snapshots that have been shared to
        /// my Amazon account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public</code> - Return all DB cluster snapshots that have been marked as
        /// public.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual DB
        /// cluster snapshots are returned. You can include shared DB cluster snapshots with these results
        /// by setting the <code>IncludeShared</code> parameter to <code>true</code>. You can include
        /// public DB cluster snapshots with these results by setting the <code>IncludePublic</code>
        /// parameter to <code>true</code>.</p>
        /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for
        /// <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The
        /// <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to
        /// <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when
        /// <code>SnapshotType</code> is set to <code>public</code>.</p>
        pub fn snapshot_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_type = Some(input.into());
            self
        }
        /// <p>The type of DB cluster snapshots to be returned. You can specify one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>automated</code> - Return all DB cluster snapshots that have been automatically
        /// taken by Amazon Neptune for my Amazon account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>manual</code> - Return all DB cluster snapshots that have been taken by my AWS
        /// account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>shared</code> - Return all manual DB cluster snapshots that have been shared to
        /// my Amazon account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public</code> - Return all DB cluster snapshots that have been marked as
        /// public.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual DB
        /// cluster snapshots are returned. You can include shared DB cluster snapshots with these results
        /// by setting the <code>IncludeShared</code> parameter to <code>true</code>. You can include
        /// public DB cluster snapshots with these results by setting the <code>IncludePublic</code>
        /// parameter to <code>true</code>.</p>
        /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for
        /// <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The
        /// <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to
        /// <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when
        /// <code>SnapshotType</code> is set to <code>public</code>.</p>
        pub fn set_snapshot_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_type = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>True to include shared manual DB cluster snapshots from other Amazon accounts that this AWS
        /// account has been given permission to copy or restore, and otherwise false. The default is
        /// <code>false</code>.</p>
        /// <p>You can give an Amazon account permission to restore a manual DB cluster snapshot from
        /// another Amazon account by the <a>ModifyDBClusterSnapshotAttribute</a> API
        /// action.</p>
        pub fn include_shared(mut self, input: bool) -> Self {
            self.include_shared = Some(input);
            self
        }
        /// <p>True to include shared manual DB cluster snapshots from other Amazon accounts that this AWS
        /// account has been given permission to copy or restore, and otherwise false. The default is
        /// <code>false</code>.</p>
        /// <p>You can give an Amazon account permission to restore a manual DB cluster snapshot from
        /// another Amazon account by the <a>ModifyDBClusterSnapshotAttribute</a> API
        /// action.</p>
        pub fn set_include_shared(mut self, input: std::option::Option<bool>) -> Self {
            self.include_shared = input;
            self
        }
        /// <p>True to include manual DB cluster snapshots that are public and can be copied or restored
        /// by any Amazon account, and otherwise false. The default is <code>false</code>. The default is
        /// false.</p>
        /// <p>You can share a manual DB cluster snapshot as public by using the <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>
        pub fn include_public(mut self, input: bool) -> Self {
            self.include_public = Some(input);
            self
        }
        /// <p>True to include manual DB cluster snapshots that are public and can be copied or restored
        /// by any Amazon account, and otherwise false. The default is <code>false</code>. The default is
        /// false.</p>
        /// <p>You can share a manual DB cluster snapshot as public by using the <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>
        pub fn set_include_public(mut self, input: std::option::Option<bool>) -> Self {
            self.include_public = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterSnapshotsInput`](crate::input::DescribeDbClusterSnapshotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbClusterSnapshotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbClusterSnapshotsInput {
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_snapshot_identifier: self.db_cluster_snapshot_identifier,
                snapshot_type: self.snapshot_type,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
                include_shared: self.include_shared.unwrap_or_default(),
                include_public: self.include_public.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbClusterSnapshotsInputOperationOutputAlias =
    crate::operation::DescribeDBClusterSnapshots;
#[doc(hidden)]
pub type DescribeDbClusterSnapshotsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDbClusterSnapshotsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBClusterSnapshots`](crate::operation::DescribeDBClusterSnapshots)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBClusterSnapshots,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDbClusterSnapshotsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDbClusterSnapshotsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDbClusterSnapshotsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_db_cluster_snapshots(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBClusterSnapshots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBClusterSnapshots",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterSnapshotsInput`](crate::input::DescribeDbClusterSnapshotsInput)
    pub fn builder() -> crate::input::describe_db_cluster_snapshots_input::Builder {
        crate::input::describe_db_cluster_snapshots_input::Builder::default()
    }
}

/// See [`DescribeDbEngineVersionsInput`](crate::input::DescribeDbEngineVersionsInput)
pub mod describe_db_engine_versions_input {
    /// A builder for [`DescribeDbEngineVersionsInput`](crate::input::DescribeDbEngineVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) default_only: std::option::Option<bool>,
        pub(crate) list_supported_character_sets: std::option::Option<bool>,
        pub(crate) list_supported_timezones: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The database engine to return.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The database engine to return.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The database engine version to return.</p>
        /// <p>Example: <code>5.1.49</code>
        /// </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The database engine version to return.</p>
        /// <p>Example: <code>5.1.49</code>
        /// </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The name of a specific DB parameter group family to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match an existing DBParameterGroupFamily.</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of a specific DB parameter group family to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match an existing DBParameterGroupFamily.</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more than the
        /// <code>MaxRecords</code> value is available, a pagination token called a marker is included in
        /// the response so that the following results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more than the
        /// <code>MaxRecords</code> value is available, a pagination token called a marker is included in
        /// the response so that the following results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Indicates that only the default version of the specified engine or engine and major
        /// version combination is returned.</p>
        pub fn default_only(mut self, input: bool) -> Self {
            self.default_only = Some(input);
            self
        }
        /// <p>Indicates that only the default version of the specified engine or engine and major
        /// version combination is returned.</p>
        pub fn set_default_only(mut self, input: std::option::Option<bool>) -> Self {
            self.default_only = input;
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the
        /// <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response
        /// includes a list of supported character sets for each engine version.</p>
        pub fn list_supported_character_sets(mut self, input: bool) -> Self {
            self.list_supported_character_sets = Some(input);
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the
        /// <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response
        /// includes a list of supported character sets for each engine version.</p>
        pub fn set_list_supported_character_sets(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.list_supported_character_sets = input;
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the <code>TimeZone</code>
        /// parameter for <code>CreateDBInstance</code>, the response includes a list of supported time
        /// zones for each engine version.</p>
        pub fn list_supported_timezones(mut self, input: bool) -> Self {
            self.list_supported_timezones = Some(input);
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the <code>TimeZone</code>
        /// parameter for <code>CreateDBInstance</code>, the response includes a list of supported time
        /// zones for each engine version.</p>
        pub fn set_list_supported_timezones(mut self, input: std::option::Option<bool>) -> Self {
            self.list_supported_timezones = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbEngineVersionsInput`](crate::input::DescribeDbEngineVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbEngineVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbEngineVersionsInput {
                engine: self.engine,
                engine_version: self.engine_version,
                db_parameter_group_family: self.db_parameter_group_family,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
                default_only: self.default_only.unwrap_or_default(),
                list_supported_character_sets: self.list_supported_character_sets,
                list_supported_timezones: self.list_supported_timezones,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbEngineVersionsInputOperationOutputAlias =
    crate::operation::DescribeDBEngineVersions;
#[doc(hidden)]
pub type DescribeDbEngineVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDbEngineVersionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBEngineVersions`](crate::operation::DescribeDBEngineVersions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBEngineVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDbEngineVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDbEngineVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDbEngineVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_db_engine_versions(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBEngineVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBEngineVersions",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbEngineVersionsInput`](crate::input::DescribeDbEngineVersionsInput)
    pub fn builder() -> crate::input::describe_db_engine_versions_input::Builder {
        crate::input::describe_db_engine_versions_input::Builder::default()
    }
}

/// See [`DescribeDbInstancesInput`](crate::input::DescribeDbInstancesInput)
pub mod describe_db_instances_input {
    /// A builder for [`DescribeDbInstancesInput`](crate::input::DescribeDbInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user-supplied instance identifier. If this parameter is specified, information from
        /// only the specific DB instance is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The user-supplied instance identifier. If this parameter is specified, information from
        /// only the specific DB instance is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more DB instances to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon
        /// Resource Names (ARNs). The results list will only include information about the DB
        /// instances associated with the DB clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>engine</code> - Accepts an engine name (such as <code>neptune</code>),
        /// and restricts the results list to DB instances created by that engine.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>For example, to invoke this API from the Amazon CLI and filter so that only
        /// Neptune DB instances are returned, you could use the following command:</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>A filter that specifies one or more DB instances to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon
        /// Resource Names (ARNs). The results list will only include information about the DB
        /// instances associated with the DB clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>engine</code> - Accepts an engine name (such as <code>neptune</code>),
        /// and restricts the results list to DB instances created by that engine.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>For example, to invoke this API from the Amazon CLI and filter so that only
        /// Neptune DB instances are returned, you could use the following command:</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribeDBInstances</code>
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous <code>DescribeDBInstances</code>
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbInstancesInput`](crate::input::DescribeDbInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbInstancesInput {
                db_instance_identifier: self.db_instance_identifier,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbInstancesInputOperationOutputAlias = crate::operation::DescribeDBInstances;
#[doc(hidden)]
pub type DescribeDbInstancesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDbInstancesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBInstances`](crate::operation::DescribeDBInstances)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBInstances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDbInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDbInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDbInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_db_instances(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBInstances",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbInstancesInput`](crate::input::DescribeDbInstancesInput)
    pub fn builder() -> crate::input::describe_db_instances_input::Builder {
        crate::input::describe_db_instances_input::Builder::default()
    }
}

/// See [`DescribeDbParameterGroupsInput`](crate::input::DescribeDbParameterGroupsInput)
pub mod describe_db_parameter_groups_input {
    /// A builder for [`DescribeDbParameterGroupsInput`](crate::input::DescribeDbParameterGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeDBParameterGroups</code> request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeDBParameterGroups</code> request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbParameterGroupsInput`](crate::input::DescribeDbParameterGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbParameterGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbParameterGroupsInput {
                db_parameter_group_name: self.db_parameter_group_name,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbParameterGroupsInputOperationOutputAlias =
    crate::operation::DescribeDBParameterGroups;
#[doc(hidden)]
pub type DescribeDbParameterGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDbParameterGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBParameterGroups`](crate::operation::DescribeDBParameterGroups)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBParameterGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDbParameterGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDbParameterGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDbParameterGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_db_parameter_groups(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBParameterGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBParameterGroups",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbParameterGroupsInput`](crate::input::DescribeDbParameterGroupsInput)
    pub fn builder() -> crate::input::describe_db_parameter_groups_input::Builder {
        crate::input::describe_db_parameter_groups_input::Builder::default()
    }
}

/// See [`DescribeDbParametersInput`](crate::input::DescribeDbParametersInput)
pub mod describe_db_parameters_input {
    /// A builder for [`DescribeDbParametersInput`](crate::input::DescribeDbParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// <p>The parameter types to return.</p>
        /// <p>Default: All parameter types returned</p>
        /// <p>Valid Values: <code>user | system | engine-default</code>
        /// </p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The parameter types to return.</p>
        /// <p>Default: All parameter types returned</p>
        /// <p>Valid Values: <code>user | system | engine-default</code>
        /// </p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBParameters</code>
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBParameters</code>
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbParametersInput`](crate::input::DescribeDbParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbParametersInput {
                db_parameter_group_name: self.db_parameter_group_name,
                source: self.source,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbParametersInputOperationOutputAlias = crate::operation::DescribeDBParameters;
#[doc(hidden)]
pub type DescribeDbParametersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDbParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBParameters`](crate::operation::DescribeDBParameters)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBParameters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDbParametersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDbParametersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDbParametersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_db_parameters(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBParameters",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbParametersInput`](crate::input::DescribeDbParametersInput)
    pub fn builder() -> crate::input::describe_db_parameters_input::Builder {
        crate::input::describe_db_parameters_input::Builder::default()
    }
}

/// See [`DescribeDbSubnetGroupsInput`](crate::input::DescribeDbSubnetGroupsInput)
pub mod describe_db_subnet_groups_input {
    /// A builder for [`DescribeDbSubnetGroupsInput`](crate::input::DescribeDbSubnetGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB subnet group to return details for.</p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB subnet group to return details for.</p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeDBSubnetGroups request. If
        /// this parameter is specified, the response includes only records beyond the marker, up to the
        /// value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeDBSubnetGroups request. If
        /// this parameter is specified, the response includes only records beyond the marker, up to the
        /// value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbSubnetGroupsInput`](crate::input::DescribeDbSubnetGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbSubnetGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbSubnetGroupsInput {
                db_subnet_group_name: self.db_subnet_group_name,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbSubnetGroupsInputOperationOutputAlias = crate::operation::DescribeDBSubnetGroups;
#[doc(hidden)]
pub type DescribeDbSubnetGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDbSubnetGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBSubnetGroups`](crate::operation::DescribeDBSubnetGroups)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBSubnetGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDbSubnetGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDbSubnetGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDbSubnetGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_db_subnet_groups(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBSubnetGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBSubnetGroups",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbSubnetGroupsInput`](crate::input::DescribeDbSubnetGroupsInput)
    pub fn builder() -> crate::input::describe_db_subnet_groups_input::Builder {
        crate::input::describe_db_subnet_groups_input::Builder::default()
    }
}

/// See [`DescribeEngineDefaultClusterParametersInput`](crate::input::DescribeEngineDefaultClusterParametersInput)
pub mod describe_engine_default_cluster_parameters_input {
    /// A builder for [`DescribeEngineDefaultClusterParametersInput`](crate::input::DescribeEngineDefaultClusterParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB cluster parameter group family to return engine parameter information
        /// for.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group family to return engine parameter information
        /// for.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeEngineDefaultClusterParameters</code> request. If this parameter is specified,
        /// the response includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeEngineDefaultClusterParameters</code> request. If this parameter is specified,
        /// the response includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEngineDefaultClusterParametersInput`](crate::input::DescribeEngineDefaultClusterParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEngineDefaultClusterParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEngineDefaultClusterParametersInput {
                db_parameter_group_family: self.db_parameter_group_family,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEngineDefaultClusterParametersInputOperationOutputAlias =
    crate::operation::DescribeEngineDefaultClusterParameters;
#[doc(hidden)]
pub type DescribeEngineDefaultClusterParametersInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeEngineDefaultClusterParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEngineDefaultClusterParameters`](crate::operation::DescribeEngineDefaultClusterParameters)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEngineDefaultClusterParameters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEngineDefaultClusterParametersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEngineDefaultClusterParametersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEngineDefaultClusterParametersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_engine_default_cluster_parameters(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEngineDefaultClusterParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEngineDefaultClusterParameters",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEngineDefaultClusterParametersInput`](crate::input::DescribeEngineDefaultClusterParametersInput)
    pub fn builder() -> crate::input::describe_engine_default_cluster_parameters_input::Builder {
        crate::input::describe_engine_default_cluster_parameters_input::Builder::default()
    }
}

/// See [`DescribeEngineDefaultParametersInput`](crate::input::DescribeEngineDefaultParametersInput)
pub mod describe_engine_default_parameters_input {
    /// A builder for [`DescribeEngineDefaultParametersInput`](crate::input::DescribeEngineDefaultParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB parameter group family.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group family.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeEngineDefaultParameters</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeEngineDefaultParameters</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEngineDefaultParametersInput`](crate::input::DescribeEngineDefaultParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEngineDefaultParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEngineDefaultParametersInput {
                db_parameter_group_family: self.db_parameter_group_family,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEngineDefaultParametersInputOperationOutputAlias =
    crate::operation::DescribeEngineDefaultParameters;
#[doc(hidden)]
pub type DescribeEngineDefaultParametersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEngineDefaultParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEngineDefaultParameters`](crate::operation::DescribeEngineDefaultParameters)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEngineDefaultParameters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEngineDefaultParametersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEngineDefaultParametersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEngineDefaultParametersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_engine_default_parameters(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEngineDefaultParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEngineDefaultParameters",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEngineDefaultParametersInput`](crate::input::DescribeEngineDefaultParametersInput)
    pub fn builder() -> crate::input::describe_engine_default_parameters_input::Builder {
        crate::input::describe_engine_default_parameters_input::Builder::default()
    }
}

/// See [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
pub mod describe_event_categories_input {
    /// A builder for [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>The type of source that is generating the events.</p>
        /// <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The type of source that is generating the events.</p>
        /// <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventCategoriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventCategoriesInput {
                source_type: self.source_type,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventCategoriesInputOperationOutputAlias =
    crate::operation::DescribeEventCategories;
#[doc(hidden)]
pub type DescribeEventCategoriesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventCategoriesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventCategories`](crate::operation::DescribeEventCategories)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventCategories,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventCategoriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventCategoriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventCategoriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_event_categories(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventCategories::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventCategories",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
    pub fn builder() -> crate::input::describe_event_categories_input::Builder {
        crate::input::describe_event_categories_input::Builder::default()
    }
}

/// See [`DescribeEventsInput`](crate::input::DescribeEventsInput)
pub mod describe_events_input {
    /// A builder for [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_identifier: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the event source for which events are returned. If not specified, then
        /// all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If SourceIdentifier is supplied, SourceType must also be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBInstance</code>, then a
        /// <code>DBInstanceIdentifier</code> must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBSecurityGroup</code>, a <code>DBSecurityGroupName</code>
        /// must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBParameterGroup</code>, a
        /// <code>DBParameterGroupName</code> must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBSnapshot</code>, a <code>DBSnapshotIdentifier</code>
        /// must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the event source for which events are returned. If not specified, then
        /// all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If SourceIdentifier is supplied, SourceType must also be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBInstance</code>, then a
        /// <code>DBInstanceIdentifier</code> must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBSecurityGroup</code>, a <code>DBSecurityGroupName</code>
        /// must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBParameterGroup</code>, a
        /// <code>DBParameterGroupName</code> must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBSnapshot</code>, a <code>DBSnapshotIdentifier</code>
        /// must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identifier = input;
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are
        /// returned.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are
        /// returned.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p> The beginning of the time interval to retrieve events for, specified in ISO 8601 format.
        /// For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p> The beginning of the time interval to retrieve events for, specified in ISO 8601 format.
        /// For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p> The end of the time interval for which to retrieve events, specified in ISO 8601 format.
        /// For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p> The end of the time interval for which to retrieve events, specified in ISO 8601 format.
        /// For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The number of minutes to retrieve events for.</p>
        /// <p>Default: 60</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The number of minutes to retrieve events for.</p>
        /// <p>Default: 60</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>A list of event categories that trigger notifications for a event notification
        /// subscription.</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p>A list of event categories that trigger notifications for a event notification
        /// subscription.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeEvents request. If this
        /// parameter is specified, the response includes only records beyond the marker, up to the value
        /// specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeEvents request. If this
        /// parameter is specified, the response includes only records beyond the marker, up to the value
        /// specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventsInput`](crate::input::DescribeEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventsInput {
                source_identifier: self.source_identifier,
                source_type: self.source_type,
                start_time: self.start_time,
                end_time: self.end_time,
                duration: self.duration,
                event_categories: self.event_categories,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventsInputOperationOutputAlias = crate::operation::DescribeEvents;
#[doc(hidden)]
pub type DescribeEventsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEvents`](crate::operation::DescribeEvents)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEvents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_events(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEvents",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    pub fn builder() -> crate::input::describe_events_input::Builder {
        crate::input::describe_events_input::Builder::default()
    }
}

/// See [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
pub mod describe_event_subscriptions_input {
    /// A builder for [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the event notification subscription you want to describe.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the event notification subscription you want to describe.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventSubscriptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventSubscriptionsInput {
                subscription_name: self.subscription_name,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventSubscriptionsInputOperationOutputAlias =
    crate::operation::DescribeEventSubscriptions;
#[doc(hidden)]
pub type DescribeEventSubscriptionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventSubscriptionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventSubscriptions`](crate::operation::DescribeEventSubscriptions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventSubscriptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventSubscriptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventSubscriptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventSubscriptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_event_subscriptions(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventSubscriptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventSubscriptions",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
    pub fn builder() -> crate::input::describe_event_subscriptions_input::Builder {
        crate::input::describe_event_subscriptions_input::Builder::default()
    }
}

/// See [`DescribeOrderableDbInstanceOptionsInput`](crate::input::DescribeOrderableDbInstanceOptionsInput)
pub mod describe_orderable_db_instance_options_input {
    /// A builder for [`DescribeOrderableDbInstanceOptionsInput`](crate::input::DescribeOrderableDbInstanceOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) db_instance_class: std::option::Option<std::string::String>,
        pub(crate) license_model: std::option::Option<std::string::String>,
        pub(crate) vpc: std::option::Option<bool>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the engine to retrieve DB instance options for.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the engine to retrieve DB instance options for.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The engine version filter value. Specify this parameter to show only the available
        /// offerings matching the specified engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The engine version filter value. Specify this parameter to show only the available
        /// offerings matching the specified engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The DB instance class filter value. Specify this parameter to show only the available
        /// offerings matching the specified DB instance class.</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_class = Some(input.into());
            self
        }
        /// <p>The DB instance class filter value. Specify this parameter to show only the available
        /// offerings matching the specified DB instance class.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_class = input;
            self
        }
        /// <p>The license model filter value. Specify this parameter to show only the available
        /// offerings matching the specified license model.</p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_model = Some(input.into());
            self
        }
        /// <p>The license model filter value. Specify this parameter to show only the available
        /// offerings matching the specified license model.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_model = input;
            self
        }
        /// <p>The VPC filter value. Specify this parameter to show only the available VPC or non-VPC
        /// offerings.</p>
        pub fn vpc(mut self, input: bool) -> Self {
            self.vpc = Some(input);
            self
        }
        /// <p>The VPC filter value. Specify this parameter to show only the available VPC or non-VPC
        /// offerings.</p>
        pub fn set_vpc(mut self, input: std::option::Option<bool>) -> Self {
            self.vpc = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions
        /// request. If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrderableDbInstanceOptionsInput`](crate::input::DescribeOrderableDbInstanceOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOrderableDbInstanceOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOrderableDbInstanceOptionsInput {
                engine: self.engine,
                engine_version: self.engine_version,
                db_instance_class: self.db_instance_class,
                license_model: self.license_model,
                vpc: self.vpc,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeOrderableDbInstanceOptionsInputOperationOutputAlias =
    crate::operation::DescribeOrderableDBInstanceOptions;
#[doc(hidden)]
pub type DescribeOrderableDbInstanceOptionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeOrderableDbInstanceOptionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOrderableDBInstanceOptions`](crate::operation::DescribeOrderableDBInstanceOptions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOrderableDBInstanceOptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeOrderableDbInstanceOptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeOrderableDbInstanceOptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeOrderableDbInstanceOptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_orderable_db_instance_options(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOrderableDBInstanceOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOrderableDBInstanceOptions",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeOrderableDbInstanceOptionsInput`](crate::input::DescribeOrderableDbInstanceOptionsInput)
    pub fn builder() -> crate::input::describe_orderable_db_instance_options_input::Builder {
        crate::input::describe_orderable_db_instance_options_input::Builder::default()
    }
}

/// See [`DescribePendingMaintenanceActionsInput`](crate::input::DescribePendingMaintenanceActionsInput)
pub mod describe_pending_maintenance_actions_input {
    /// A builder for [`DescribePendingMaintenanceActionsInput`](crate::input::DescribePendingMaintenanceActionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of a resource to return pending maintenance actions for.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// <p>The ARN of a resource to return pending maintenance actions for.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more resources to return pending maintenance actions
        /// for.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon
        /// Resource Names (ARNs). The results list will only include pending maintenance actions for
        /// the DB clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance ARNs.
        /// The results list will only include pending maintenance actions for the DB instances
        /// identified by these ARNs.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>A filter that specifies one or more resources to return pending maintenance actions
        /// for.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon
        /// Resource Names (ARNs). The results list will only include pending maintenance actions for
        /// the DB clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance ARNs.
        /// The results list will only include pending maintenance actions for the DB instances
        /// identified by these ARNs.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to a number of records specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to a number of records specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
        /// response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePendingMaintenanceActionsInput`](crate::input::DescribePendingMaintenanceActionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePendingMaintenanceActionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePendingMaintenanceActionsInput {
                resource_identifier: self.resource_identifier,
                filters: self.filters,
                marker: self.marker,
                max_records: self.max_records,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePendingMaintenanceActionsInputOperationOutputAlias =
    crate::operation::DescribePendingMaintenanceActions;
#[doc(hidden)]
pub type DescribePendingMaintenanceActionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribePendingMaintenanceActionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribePendingMaintenanceActions`](crate::operation::DescribePendingMaintenanceActions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePendingMaintenanceActions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePendingMaintenanceActionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePendingMaintenanceActionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePendingMaintenanceActionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_pending_maintenance_actions(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePendingMaintenanceActions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePendingMaintenanceActions",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePendingMaintenanceActionsInput`](crate::input::DescribePendingMaintenanceActionsInput)
    pub fn builder() -> crate::input::describe_pending_maintenance_actions_input::Builder {
        crate::input::describe_pending_maintenance_actions_input::Builder::default()
    }
}

/// See [`DescribeValidDbInstanceModificationsInput`](crate::input::DescribeValidDbInstanceModificationsInput)
pub mod describe_valid_db_instance_modifications_input {
    /// A builder for [`DescribeValidDbInstanceModificationsInput`](crate::input::DescribeValidDbInstanceModificationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The customer identifier or the ARN of your DB instance.</p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The customer identifier or the ARN of your DB instance.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeValidDbInstanceModificationsInput`](crate::input::DescribeValidDbInstanceModificationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeValidDbInstanceModificationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeValidDbInstanceModificationsInput {
                db_instance_identifier: self.db_instance_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeValidDbInstanceModificationsInputOperationOutputAlias =
    crate::operation::DescribeValidDBInstanceModifications;
#[doc(hidden)]
pub type DescribeValidDbInstanceModificationsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeValidDbInstanceModificationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeValidDBInstanceModifications`](crate::operation::DescribeValidDBInstanceModifications)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeValidDBInstanceModifications,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeValidDbInstanceModificationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeValidDbInstanceModificationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeValidDbInstanceModificationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_valid_db_instance_modifications(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeValidDBInstanceModifications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeValidDBInstanceModifications",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeValidDbInstanceModificationsInput`](crate::input::DescribeValidDbInstanceModificationsInput)
    pub fn builder() -> crate::input::describe_valid_db_instance_modifications_input::Builder {
        crate::input::describe_valid_db_instance_modifications_input::Builder::default()
    }
}

/// See [`FailoverDbClusterInput`](crate::input::FailoverDbClusterInput)
pub mod failover_db_cluster_input {
    /// A builder for [`FailoverDbClusterInput`](crate::input::FailoverDbClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) target_db_instance_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A DB cluster identifier to force a failover for. This parameter is not
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>A DB cluster identifier to force a failover for. This parameter is not
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>The name of the instance to promote to the primary instance.</p>
        /// <p>You must specify the instance identifier for an Read Replica in the DB cluster. For
        /// example, <code>mydbcluster-replica1</code>.</p>
        pub fn target_db_instance_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The name of the instance to promote to the primary instance.</p>
        /// <p>You must specify the instance identifier for an Read Replica in the DB cluster. For
        /// example, <code>mydbcluster-replica1</code>.</p>
        pub fn set_target_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_db_instance_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`FailoverDbClusterInput`](crate::input::FailoverDbClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::FailoverDbClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::FailoverDbClusterInput {
                db_cluster_identifier: self.db_cluster_identifier,
                target_db_instance_identifier: self.target_db_instance_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type FailoverDbClusterInputOperationOutputAlias = crate::operation::FailoverDBCluster;
#[doc(hidden)]
pub type FailoverDbClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl FailoverDbClusterInput {
    /// Consumes the builder and constructs an Operation<[`FailoverDBCluster`](crate::operation::FailoverDBCluster)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::FailoverDBCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::FailoverDbClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::FailoverDbClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::FailoverDbClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_failover_db_cluster(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::FailoverDBCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "FailoverDBCluster",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`FailoverDbClusterInput`](crate::input::FailoverDbClusterInput)
    pub fn builder() -> crate::input::failover_db_cluster_input::Builder {
        crate::input::failover_db_cluster_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>The Amazon Neptune resource with tags to be listed. This value is an Amazon Resource Name
        /// (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The Amazon Neptune resource with tags to be listed. This value is an Amazon Resource Name
        /// (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_name: self.resource_name,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ModifyDbClusterInput`](crate::input::ModifyDbClusterInput)
pub mod modify_db_cluster_input {
    /// A builder for [`ModifyDbClusterInput`](crate::input::ModifyDbClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) new_db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) apply_immediately: std::option::Option<bool>,
        pub(crate) backup_retention_period: std::option::Option<i32>,
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) master_user_password: std::option::Option<std::string::String>,
        pub(crate) option_group_name: std::option::Option<std::string::String>,
        pub(crate) preferred_backup_window: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) enable_iam_database_authentication: std::option::Option<bool>,
        pub(crate) cloudwatch_logs_export_configuration:
            std::option::Option<crate::model::CloudwatchLogsExportConfiguration>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) deletion_protection: std::option::Option<bool>,
        pub(crate) copy_tags_to_snapshot: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The DB cluster identifier for the cluster being modified. This parameter is not
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier for the cluster being modified. This parameter is not
        /// case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is
        /// stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster2</code>
        /// </p>
        pub fn new_db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is
        /// stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster2</code>
        /// </p>
        pub fn set_new_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.new_db_cluster_identifier = input;
            self
        }
        /// <p>A value that specifies whether the modifications in this request and any pending
        /// modifications are asynchronously applied as soon as possible, regardless of the
        /// <code>PreferredMaintenanceWindow</code> setting for the DB cluster. If this parameter is set
        /// to <code>false</code>, changes to the DB cluster are applied during the next maintenance
        /// window.</p>
        /// <p>The <code>ApplyImmediately</code> parameter only affects <code>NewDBClusterIdentifier</code>
        /// values. If you set the <code>ApplyImmediately</code> parameter value to false, then changes to
        /// <code>NewDBClusterIdentifier</code> values are applied during the next maintenance window.
        /// All other changes are applied immediately, regardless of the value of the
        /// <code>ApplyImmediately</code> parameter.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.apply_immediately = Some(input);
            self
        }
        /// <p>A value that specifies whether the modifications in this request and any pending
        /// modifications are asynchronously applied as soon as possible, regardless of the
        /// <code>PreferredMaintenanceWindow</code> setting for the DB cluster. If this parameter is set
        /// to <code>false</code>, changes to the DB cluster are applied during the next maintenance
        /// window.</p>
        /// <p>The <code>ApplyImmediately</code> parameter only affects <code>NewDBClusterIdentifier</code>
        /// values. If you set the <code>ApplyImmediately</code> parameter value to false, then changes to
        /// <code>NewDBClusterIdentifier</code> values are applied during the next maintenance window.
        /// All other changes are applied immediately, regardless of the value of the
        /// <code>ApplyImmediately</code> parameter.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.apply_immediately = input;
            self
        }
        /// <p>The number of days for which automated backups are retained. You must specify a minimum
        /// value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 1 to 35</p>
        /// </li>
        /// </ul>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.backup_retention_period = Some(input);
            self
        }
        /// <p>The number of days for which automated backups are retained. You must specify a minimum
        /// value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 1 to 35</p>
        /// </li>
        /// </ul>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.backup_retention_period = input;
            self
        }
        /// <p>The name of the DB cluster parameter group to use for the DB cluster.</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group to use for the DB cluster.</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of VPC security groups that the DB cluster will belong to.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>A list of VPC security groups that the DB cluster will belong to.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// <p>The port number on which the DB cluster accepts connections.</p>
        /// <p>Constraints: Value must be <code>1150-65535</code>
        /// </p>
        /// <p>Default: The same port as the original DB cluster.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number on which the DB cluster accepts connections.</p>
        /// <p>Constraints: Value must be <code>1150-65535</code>
        /// </p>
        /// <p>Default: The same port as the original DB cluster.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_password = Some(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_password = input;
            self
        }
        /// <p>
        /// <i>Not supported by Neptune.</i>
        /// </p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_name = Some(input.into());
            self
        }
        /// <p>
        /// <i>Not supported by Neptune.</i>
        /// </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_name = input;
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are
        /// enabled, using the <code>BackupRetentionPeriod</code> parameter.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_backup_window = Some(input.into());
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are
        /// enabled, using the <code>BackupRetentionPeriod</code> parameter.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_backup_window = input;
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated
        /// Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region, occurring on a random day of the
        /// week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated
        /// Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// Amazon Region, occurring on a random day of the
        /// week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
        /// accounts, and otherwise false.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn enable_iam_database_authentication(mut self, input: bool) -> Self {
            self.enable_iam_database_authentication = Some(input);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
        /// accounts, and otherwise false.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_iam_database_authentication = input;
            self
        }
        /// <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs
        /// for a specific DB cluster.</p>
        pub fn cloudwatch_logs_export_configuration(
            mut self,
            input: crate::model::CloudwatchLogsExportConfiguration,
        ) -> Self {
            self.cloudwatch_logs_export_configuration = Some(input);
            self
        }
        /// <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs
        /// for a specific DB cluster.</p>
        pub fn set_cloudwatch_logs_export_configuration(
            mut self,
            input: std::option::Option<crate::model::CloudwatchLogsExportConfiguration>,
        ) -> Self {
            self.cloudwatch_logs_export_configuration = input;
            self
        }
        /// <p>The version number of the database engine to which you want to upgrade. Changing this
        /// parameter results in an outage. The change is applied during the next maintenance window
        /// unless the <code>ApplyImmediately</code> parameter is set to true.</p>
        /// <p>For a list of valid engine versions, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/engine-releases.html">Engine Releases for Amazon
        /// Neptune</a>, or call <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-other-apis.html#DescribeDBEngineVersions">DescribeDBEngineVersions</a>.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the database engine to which you want to upgrade. Changing this
        /// parameter results in an outage. The change is applied during the next maintenance window
        /// unless the <code>ApplyImmediately</code> parameter is set to true.</p>
        /// <p>For a list of valid engine versions, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/engine-releases.html">Engine Releases for Amazon
        /// Neptune</a>, or call <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-other-apis.html#DescribeDBEngineVersions">DescribeDBEngineVersions</a>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// <p>
        /// <i>If set to <code>true</code>, tags are copied to any snapshot of
        /// the DB cluster that is created.</i>
        /// </p>
        pub fn copy_tags_to_snapshot(mut self, input: bool) -> Self {
            self.copy_tags_to_snapshot = Some(input);
            self
        }
        /// <p>
        /// <i>If set to <code>true</code>, tags are copied to any snapshot of
        /// the DB cluster that is created.</i>
        /// </p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags_to_snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbClusterInput`](crate::input::ModifyDbClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyDbClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyDbClusterInput {
                db_cluster_identifier: self.db_cluster_identifier,
                new_db_cluster_identifier: self.new_db_cluster_identifier,
                apply_immediately: self.apply_immediately.unwrap_or_default(),
                backup_retention_period: self.backup_retention_period,
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                vpc_security_group_ids: self.vpc_security_group_ids,
                port: self.port,
                master_user_password: self.master_user_password,
                option_group_name: self.option_group_name,
                preferred_backup_window: self.preferred_backup_window,
                preferred_maintenance_window: self.preferred_maintenance_window,
                enable_iam_database_authentication: self.enable_iam_database_authentication,
                cloudwatch_logs_export_configuration: self.cloudwatch_logs_export_configuration,
                engine_version: self.engine_version,
                deletion_protection: self.deletion_protection,
                copy_tags_to_snapshot: self.copy_tags_to_snapshot,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyDbClusterInputOperationOutputAlias = crate::operation::ModifyDBCluster;
#[doc(hidden)]
pub type ModifyDbClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyDbClusterInput {
    /// Consumes the builder and constructs an Operation<[`ModifyDBCluster`](crate::operation::ModifyDBCluster)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyDBCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyDbClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyDbClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyDbClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_db_cluster(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyDBCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyDBCluster",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterInput`](crate::input::ModifyDbClusterInput)
    pub fn builder() -> crate::input::modify_db_cluster_input::Builder {
        crate::input::modify_db_cluster_input::Builder::default()
    }
}

/// See [`ModifyDbClusterEndpointInput`](crate::input::ModifyDbClusterEndpointInput)
pub mod modify_db_cluster_endpoint_input {
    /// A builder for [`ModifyDbClusterEndpointInput`](crate::input::ModifyDbClusterEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<std::string::String>,
        pub(crate) static_members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) excluded_members: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of the endpoint to modify. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the endpoint to modify. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = input;
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_type = Some(input.into());
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// Appends an item to `static_members`.
        ///
        /// To override the contents of this collection use [`set_static_members`](Self::set_static_members).
        ///
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn static_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.static_members.unwrap_or_default();
            v.push(input.into());
            self.static_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn set_static_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.static_members = input;
            self
        }
        /// Appends an item to `excluded_members`.
        ///
        /// To override the contents of this collection use [`set_excluded_members`](Self::set_excluded_members).
        ///
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
        /// All other eligible instances are reachable through the custom endpoint.
        /// Only relevant if the list of static members is empty.</p>
        pub fn excluded_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.excluded_members.unwrap_or_default();
            v.push(input.into());
            self.excluded_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
        /// All other eligible instances are reachable through the custom endpoint.
        /// Only relevant if the list of static members is empty.</p>
        pub fn set_excluded_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.excluded_members = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbClusterEndpointInput`](crate::input::ModifyDbClusterEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyDbClusterEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyDbClusterEndpointInput {
                db_cluster_endpoint_identifier: self.db_cluster_endpoint_identifier,
                endpoint_type: self.endpoint_type,
                static_members: self.static_members,
                excluded_members: self.excluded_members,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyDbClusterEndpointInputOperationOutputAlias =
    crate::operation::ModifyDBClusterEndpoint;
#[doc(hidden)]
pub type ModifyDbClusterEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyDbClusterEndpointInput {
    /// Consumes the builder and constructs an Operation<[`ModifyDBClusterEndpoint`](crate::operation::ModifyDBClusterEndpoint)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyDBClusterEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyDbClusterEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyDbClusterEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyDbClusterEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_db_cluster_endpoint(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyDBClusterEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyDBClusterEndpoint",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterEndpointInput`](crate::input::ModifyDbClusterEndpointInput)
    pub fn builder() -> crate::input::modify_db_cluster_endpoint_input::Builder {
        crate::input::modify_db_cluster_endpoint_input::Builder::default()
    }
}

/// See [`ModifyDbClusterParameterGroupInput`](crate::input::ModifyDbClusterParameterGroupInput)
pub mod modify_db_cluster_parameter_group_input {
    /// A builder for [`ModifyDbClusterParameterGroupInput`](crate::input::ModifyDbClusterParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    }
    impl Builder {
        /// <p>The name of the DB cluster parameter group to modify.</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group to modify.</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of parameters in the DB cluster parameter group to modify.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>A list of parameters in the DB cluster parameter group to modify.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbClusterParameterGroupInput`](crate::input::ModifyDbClusterParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyDbClusterParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyDbClusterParameterGroupInput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                parameters: self.parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyDbClusterParameterGroupInputOperationOutputAlias =
    crate::operation::ModifyDBClusterParameterGroup;
#[doc(hidden)]
pub type ModifyDbClusterParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyDbClusterParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`ModifyDBClusterParameterGroup`](crate::operation::ModifyDBClusterParameterGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyDBClusterParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyDbClusterParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyDbClusterParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyDbClusterParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_db_cluster_parameter_group(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyDBClusterParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyDBClusterParameterGroup",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterParameterGroupInput`](crate::input::ModifyDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::modify_db_cluster_parameter_group_input::Builder {
        crate::input::modify_db_cluster_parameter_group_input::Builder::default()
    }
}

/// See [`ModifyDbClusterSnapshotAttributeInput`](crate::input::ModifyDbClusterSnapshotAttributeInput)
pub mod modify_db_cluster_snapshot_attribute_input {
    /// A builder for [`ModifyDbClusterSnapshotAttributeInput`](crate::input::ModifyDbClusterSnapshotAttributeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) values_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) values_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier for the DB cluster snapshot to modify the attributes for.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the DB cluster snapshot to modify the attributes for.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = input;
            self
        }
        /// <p>The name of the DB cluster snapshot attribute to modify.</p>
        /// <p>To manage authorization for other Amazon accounts to copy or restore a manual DB cluster
        /// snapshot, set this value to <code>restore</code>.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster snapshot attribute to modify.</p>
        /// <p>To manage authorization for other Amazon accounts to copy or restore a manual DB cluster
        /// snapshot, set this value to <code>restore</code>.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// Appends an item to `values_to_add`.
        ///
        /// To override the contents of this collection use [`set_values_to_add`](Self::set_values_to_add).
        ///
        /// <p>A list of DB cluster snapshot attributes to add to the attribute specified by
        /// <code>AttributeName</code>.</p>
        /// <p>To authorize other Amazon accounts to copy or restore a manual DB cluster snapshot, set this
        /// list to include one or more Amazon account IDs, or <code>all</code> to make the manual DB cluster
        /// snapshot restorable by any Amazon account. Do not add the <code>all</code> value for any manual
        /// DB cluster snapshots that contain private information that you don't want available to all AWS
        /// accounts.</p>
        pub fn values_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values_to_add.unwrap_or_default();
            v.push(input.into());
            self.values_to_add = Some(v);
            self
        }
        /// <p>A list of DB cluster snapshot attributes to add to the attribute specified by
        /// <code>AttributeName</code>.</p>
        /// <p>To authorize other Amazon accounts to copy or restore a manual DB cluster snapshot, set this
        /// list to include one or more Amazon account IDs, or <code>all</code> to make the manual DB cluster
        /// snapshot restorable by any Amazon account. Do not add the <code>all</code> value for any manual
        /// DB cluster snapshots that contain private information that you don't want available to all AWS
        /// accounts.</p>
        pub fn set_values_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values_to_add = input;
            self
        }
        /// Appends an item to `values_to_remove`.
        ///
        /// To override the contents of this collection use [`set_values_to_remove`](Self::set_values_to_remove).
        ///
        /// <p>A list of DB cluster snapshot attributes to remove from the attribute specified by
        /// <code>AttributeName</code>.</p>
        /// <p>To remove authorization for other Amazon accounts to copy or restore a manual DB cluster
        /// snapshot, set this list to include one or more Amazon account identifiers, or <code>all</code> to
        /// remove authorization for any Amazon account to copy or restore the DB cluster snapshot. If you
        /// specify <code>all</code>, an Amazon account whose account ID is explicitly added to the
        /// <code>restore</code> attribute can still copy or restore a manual DB cluster snapshot.</p>
        pub fn values_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values_to_remove.unwrap_or_default();
            v.push(input.into());
            self.values_to_remove = Some(v);
            self
        }
        /// <p>A list of DB cluster snapshot attributes to remove from the attribute specified by
        /// <code>AttributeName</code>.</p>
        /// <p>To remove authorization for other Amazon accounts to copy or restore a manual DB cluster
        /// snapshot, set this list to include one or more Amazon account identifiers, or <code>all</code> to
        /// remove authorization for any Amazon account to copy or restore the DB cluster snapshot. If you
        /// specify <code>all</code>, an Amazon account whose account ID is explicitly added to the
        /// <code>restore</code> attribute can still copy or restore a manual DB cluster snapshot.</p>
        pub fn set_values_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values_to_remove = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbClusterSnapshotAttributeInput`](crate::input::ModifyDbClusterSnapshotAttributeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyDbClusterSnapshotAttributeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyDbClusterSnapshotAttributeInput {
                db_cluster_snapshot_identifier: self.db_cluster_snapshot_identifier,
                attribute_name: self.attribute_name,
                values_to_add: self.values_to_add,
                values_to_remove: self.values_to_remove,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyDbClusterSnapshotAttributeInputOperationOutputAlias =
    crate::operation::ModifyDBClusterSnapshotAttribute;
#[doc(hidden)]
pub type ModifyDbClusterSnapshotAttributeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyDbClusterSnapshotAttributeInput {
    /// Consumes the builder and constructs an Operation<[`ModifyDBClusterSnapshotAttribute`](crate::operation::ModifyDBClusterSnapshotAttribute)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyDBClusterSnapshotAttribute,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyDbClusterSnapshotAttributeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyDbClusterSnapshotAttributeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyDbClusterSnapshotAttributeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_db_cluster_snapshot_attribute(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyDBClusterSnapshotAttribute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyDBClusterSnapshotAttribute",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterSnapshotAttributeInput`](crate::input::ModifyDbClusterSnapshotAttributeInput)
    pub fn builder() -> crate::input::modify_db_cluster_snapshot_attribute_input::Builder {
        crate::input::modify_db_cluster_snapshot_attribute_input::Builder::default()
    }
}

/// See [`ModifyDbInstanceInput`](crate::input::ModifyDbInstanceInput)
pub mod modify_db_instance_input {
    /// A builder for [`ModifyDbInstanceInput`](crate::input::ModifyDbInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) allocated_storage: std::option::Option<i32>,
        pub(crate) db_instance_class: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) db_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) apply_immediately: std::option::Option<bool>,
        pub(crate) master_user_password: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) backup_retention_period: std::option::Option<i32>,
        pub(crate) preferred_backup_window: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) multi_az: std::option::Option<bool>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) allow_major_version_upgrade: std::option::Option<bool>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) license_model: std::option::Option<std::string::String>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) option_group_name: std::option::Option<std::string::String>,
        pub(crate) new_db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) storage_type: std::option::Option<std::string::String>,
        pub(crate) tde_credential_arn: std::option::Option<std::string::String>,
        pub(crate) tde_credential_password: std::option::Option<std::string::String>,
        pub(crate) ca_certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) copy_tags_to_snapshot: std::option::Option<bool>,
        pub(crate) monitoring_interval: std::option::Option<i32>,
        pub(crate) db_port_number: std::option::Option<i32>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) monitoring_role_arn: std::option::Option<std::string::String>,
        pub(crate) domain_iam_role_name: std::option::Option<std::string::String>,
        pub(crate) promotion_tier: std::option::Option<i32>,
        pub(crate) enable_iam_database_authentication: std::option::Option<bool>,
        pub(crate) enable_performance_insights: std::option::Option<bool>,
        pub(crate) performance_insights_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) cloudwatch_logs_export_configuration:
            std::option::Option<crate::model::CloudwatchLogsExportConfiguration>,
        pub(crate) deletion_protection: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The DB instance identifier. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The DB instance identifier. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.allocated_storage = Some(input);
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_storage = input;
            self
        }
        /// <p>The new compute and memory capacity of the DB instance, for example,
        /// <code>db.m4.large</code>. Not all DB instance classes are available in all AWS
        /// Regions.</p>
        /// <p>If you modify the DB instance class, an outage occurs during the change. The change is
        /// applied during the next maintenance window, unless <code>ApplyImmediately</code> is specified
        /// as <code>true</code> for this request.</p>
        /// <p>Default: Uses existing setting</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_class = Some(input.into());
            self
        }
        /// <p>The new compute and memory capacity of the DB instance, for example,
        /// <code>db.m4.large</code>. Not all DB instance classes are available in all AWS
        /// Regions.</p>
        /// <p>If you modify the DB instance class, an outage occurs during the change. The change is
        /// applied during the next maintenance window, unless <code>ApplyImmediately</code> is specified
        /// as <code>true</code> for this request.</p>
        /// <p>Default: Uses existing setting</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_class = input;
            self
        }
        /// <p>The new DB subnet group for the DB instance. You can use this parameter to move your DB
        /// instance to a different VPC.</p>
        /// <p>Changing the subnet group causes an outage during the change. The change is applied during
        /// the next maintenance window, unless you specify <code>true</code> for the
        /// <code>ApplyImmediately</code> parameter.</p>
        /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// <p>Example: <code>mySubnetGroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The new DB subnet group for the DB instance. You can use this parameter to move your DB
        /// instance to a different VPC.</p>
        /// <p>Changing the subnet group causes an outage during the change. The change is applied during
        /// the next maintenance window, unless you specify <code>true</code> for the
        /// <code>ApplyImmediately</code> parameter.</p>
        /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// <p>Example: <code>mySubnetGroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// Appends an item to `db_security_groups`.
        ///
        /// To override the contents of this collection use [`set_db_security_groups`](Self::set_db_security_groups).
        ///
        /// <p>A list of DB security groups to authorize on this DB instance. Changing this setting
        /// doesn't result in an outage and the change is asynchronously applied as soon as
        /// possible.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match existing DBSecurityGroups.</p>
        /// </li>
        /// </ul>
        pub fn db_security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.db_security_groups.unwrap_or_default();
            v.push(input.into());
            self.db_security_groups = Some(v);
            self
        }
        /// <p>A list of DB security groups to authorize on this DB instance. Changing this setting
        /// doesn't result in an outage and the change is asynchronously applied as soon as
        /// possible.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match existing DBSecurityGroups.</p>
        /// </li>
        /// </ul>
        pub fn set_db_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.db_security_groups = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of EC2 VPC security groups to authorize on this DB instance. This change is
        /// asynchronously applied as soon as possible.</p>
        /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB
        /// cluster. For more information, see <a>ModifyDBCluster</a>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match existing VpcSecurityGroupIds.</p>
        /// </li>
        /// </ul>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>A list of EC2 VPC security groups to authorize on this DB instance. This change is
        /// asynchronously applied as soon as possible.</p>
        /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB
        /// cluster. For more information, see <a>ModifyDBCluster</a>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match existing VpcSecurityGroupIds.</p>
        /// </li>
        /// </ul>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// <p>Specifies whether the modifications in this request and any pending modifications are
        /// asynchronously applied as soon as possible, regardless of the
        /// <code>PreferredMaintenanceWindow</code> setting for the DB instance.</p>
        /// <p> If this parameter is set to <code>false</code>, changes to the DB instance are applied
        /// during the next maintenance window. Some parameter changes can cause an outage and are applied
        /// on the next call to <a>RebootDBInstance</a>, or the next
        /// failure reboot.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.apply_immediately = Some(input);
            self
        }
        /// <p>Specifies whether the modifications in this request and any pending modifications are
        /// asynchronously applied as soon as possible, regardless of the
        /// <code>PreferredMaintenanceWindow</code> setting for the DB instance.</p>
        /// <p> If this parameter is set to <code>false</code>, changes to the DB instance are applied
        /// during the next maintenance window. Some parameter changes can cause an outage and are applied
        /// on the next call to <a>RebootDBInstance</a>, or the next
        /// failure reboot.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.apply_immediately = input;
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_password = Some(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_password = input;
            self
        }
        /// <p>The name of the DB parameter group to apply to the DB instance. Changing this setting
        /// doesn't result in an outage. The parameter group name itself is changed immediately, but the
        /// actual parameter changes are not applied until you reboot the instance without failover. The
        /// db instance will NOT be rebooted automatically and the parameter changes will NOT be applied
        /// during the next maintenance window.</p>
        /// <p>Default: Uses existing setting</p>
        /// <p>Constraints: The DB parameter group must be in the same DB parameter group family as this
        /// DB instance.</p>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group to apply to the DB instance. Changing this setting
        /// doesn't result in an outage. The parameter group name itself is changed immediately, but the
        /// actual parameter changes are not applied until you reboot the instance without failover. The
        /// db instance will NOT be rebooted automatically and the parameter changes will NOT be applied
        /// during the next maintenance window.</p>
        /// <p>Default: Uses existing setting</p>
        /// <p>Constraints: The DB parameter group must be in the same DB parameter group family as this
        /// DB instance.</p>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster.
        /// For more information, see <a>ModifyDBCluster</a>.</p>
        /// <p>Default: Uses existing setting</p>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.backup_retention_period = Some(input);
            self
        }
        /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster.
        /// For more information, see <a>ModifyDBCluster</a>.</p>
        /// <p>Default: Uses existing setting</p>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.backup_retention_period = input;
            self
        }
        /// <p> The daily time range during which automated backups are created if automated backups are
        /// enabled.</p>
        /// <p>Not applicable. The daily time range for creating automated backups is managed by the DB
        /// cluster. For more information, see <a>ModifyDBCluster</a>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format hh24:mi-hh24:mi</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Time Coordinated (UTC)</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes</p>
        /// </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_backup_window = Some(input.into());
            self
        }
        /// <p> The daily time range during which automated backups are created if automated backups are
        /// enabled.</p>
        /// <p>Not applicable. The daily time range for creating automated backups is managed by the DB
        /// cluster. For more information, see <a>ModifyDBCluster</a>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format hh24:mi-hh24:mi</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Time Coordinated (UTC)</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes</p>
        /// </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_backup_window = input;
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might
        /// result in an outage. Changing this parameter doesn't result in an outage, except in the
        /// following situation, and the change is asynchronously applied as soon as possible. If there
        /// are pending actions that cause a reboot, and the maintenance window is changed to include the
        /// current time, then changing this parameter will cause a reboot of the DB instance. If moving
        /// this window to the current time, there must be at least 30 minutes between the current time
        /// and end of the window to ensure pending changes are applied.</p>
        /// <p>Default: Uses existing setting</p>
        /// <p>Format: ddd:hh24:mi-ddd:hh24:mi</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Must be at least 30 minutes</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might
        /// result in an outage. Changing this parameter doesn't result in an outage, except in the
        /// following situation, and the change is asynchronously applied as soon as possible. If there
        /// are pending actions that cause a reboot, and the maintenance window is changed to include the
        /// current time, then changing this parameter will cause a reboot of the DB instance. If moving
        /// this window to the current time, there must be at least 30 minutes between the current time
        /// and end of the window to ensure pending changes are applied.</p>
        /// <p>Default: Uses existing setting</p>
        /// <p>Format: ddd:hh24:mi-ddd:hh24:mi</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Must be at least 30 minutes</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter doesn't
        /// result in an outage and the change is applied during the next maintenance window unless the
        /// <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request.</p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.multi_az = Some(input);
            self
        }
        /// <p>Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter doesn't
        /// result in an outage and the change is applied during the next maintenance window unless the
        /// <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az = input;
            self
        }
        /// <p>The version number of the database engine to upgrade to. Currently, setting this
        /// parameter has no effect. To upgrade your database engine to the most recent release,
        /// use the <a>ApplyPendingMaintenanceAction</a> API.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the database engine to upgrade to. Currently, setting this
        /// parameter has no effect. To upgrade your database engine to the most recent release,
        /// use the <a>ApplyPendingMaintenanceAction</a> API.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Indicates that major version upgrades are allowed. Changing this parameter doesn't result
        /// in an outage and the change is asynchronously applied as soon as possible.</p>
        pub fn allow_major_version_upgrade(mut self, input: bool) -> Self {
            self.allow_major_version_upgrade = Some(input);
            self
        }
        /// <p>Indicates that major version upgrades are allowed. Changing this parameter doesn't result
        /// in an outage and the change is asynchronously applied as soon as possible.</p>
        pub fn set_allow_major_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_major_version_upgrade = input;
            self
        }
        /// <p> Indicates that minor version upgrades are applied automatically to the DB instance during
        /// the maintenance window. Changing this parameter doesn't result in an outage except in the
        /// following case and the change is asynchronously applied as soon as possible. An outage will
        /// result if this parameter is set to <code>true</code> during the maintenance window, and a
        /// newer minor version is available, and Neptune has enabled auto patching for that engine
        /// version.</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p> Indicates that minor version upgrades are applied automatically to the DB instance during
        /// the maintenance window. Changing this parameter doesn't result in an outage except in the
        /// following case and the change is asynchronously applied as soon as possible. An outage will
        /// result if this parameter is set to <code>true</code> during the maintenance window, and a
        /// newer minor version is available, and Neptune has enabled auto patching for that engine
        /// version.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_model = Some(input.into());
            self
        }
        /// <p>Not supported by Neptune.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_model = input;
            self
        }
        /// <p>The new Provisioned IOPS (I/O operations per second) value for the instance.</p>
        /// <p>Changing this setting doesn't result in an outage and the change is applied during the
        /// next maintenance window unless the <code>ApplyImmediately</code> parameter is set to
        /// <code>true</code> for this request.</p>
        /// <p>Default: Uses existing setting</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>The new Provisioned IOPS (I/O operations per second) value for the instance.</p>
        /// <p>Changing this setting doesn't result in an outage and the change is applied during the
        /// next maintenance window unless the <code>ApplyImmediately</code> parameter is set to
        /// <code>true</code> for this request.</p>
        /// <p>Default: Uses existing setting</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_name = Some(input.into());
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_name = input;
            self
        }
        /// <p> The new DB instance identifier for the DB instance when renaming a DB instance. When you
        /// change the DB instance identifier, an instance reboot will occur immediately if you set
        /// <code>Apply Immediately</code> to true, or will occur during the next maintenance window if
        /// <code>Apply Immediately</code> to false. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code>
        /// </p>
        pub fn new_db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_db_instance_identifier = Some(input.into());
            self
        }
        /// <p> The new DB instance identifier for the DB instance when renaming a DB instance. When you
        /// change the DB instance identifier, an instance reboot will occur immediately if you set
        /// <code>Apply Immediately</code> to true, or will occur during the next maintenance window if
        /// <code>Apply Immediately</code> to false. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code>
        /// </p>
        pub fn set_new_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.new_db_instance_identifier = input;
            self
        }
        /// <p>Not supported.</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type = Some(input.into());
            self
        }
        /// <p>Not supported.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
        pub fn tde_credential_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tde_credential_arn = Some(input.into());
            self
        }
        /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
        pub fn set_tde_credential_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tde_credential_arn = input;
            self
        }
        /// <p>The password for the given ARN from the key store in order to access the device.</p>
        pub fn tde_credential_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.tde_credential_password = Some(input.into());
            self
        }
        /// <p>The password for the given ARN from the key store in order to access the device.</p>
        pub fn set_tde_credential_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tde_credential_password = input;
            self
        }
        /// <p>Indicates the certificate that needs to be associated with the instance.</p>
        pub fn ca_certificate_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.ca_certificate_identifier = Some(input.into());
            self
        }
        /// <p>Indicates the certificate that needs to be associated with the instance.</p>
        pub fn set_ca_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ca_certificate_identifier = input;
            self
        }
        /// <p>Not supported.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>Not supported.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise
        /// false. The default is false.</p>
        pub fn copy_tags_to_snapshot(mut self, input: bool) -> Self {
            self.copy_tags_to_snapshot = Some(input);
            self
        }
        /// <p>True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise
        /// false. The default is false.</p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags_to_snapshot = input;
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected
        /// for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default
        /// is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must also set
        /// <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
        /// </p>
        pub fn monitoring_interval(mut self, input: i32) -> Self {
            self.monitoring_interval = Some(input);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected
        /// for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default
        /// is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must also set
        /// <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
        /// </p>
        pub fn set_monitoring_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.monitoring_interval = input;
            self
        }
        /// <p>The port number on which the database accepts connections.</p>
        /// <p>The value of the <code>DBPortNumber</code> parameter must not match any of the port values
        /// specified for options in the option group for the DB instance.</p>
        /// <p>Your database will restart when you change the <code>DBPortNumber</code> value regardless
        /// of the value of the <code>ApplyImmediately</code> parameter.</p>
        /// <p> Default: <code>8182</code>
        /// </p>
        pub fn db_port_number(mut self, input: i32) -> Self {
            self.db_port_number = Some(input);
            self
        }
        /// <p>The port number on which the database accepts connections.</p>
        /// <p>The value of the <code>DBPortNumber</code> parameter must not match any of the port values
        /// specified for options in the option group for the DB instance.</p>
        /// <p>Your database will restart when you change the <code>DBPortNumber</code> value regardless
        /// of the value of the <code>ApplyImmediately</code> parameter.</p>
        /// <p> Default: <code>8182</code>
        /// </p>
        pub fn set_db_port_number(mut self, input: std::option::Option<i32>) -> Self {
            self.db_port_number = input;
            self
        }
        /// <p>This flag should no longer be used.</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p>This flag should no longer be used.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// <p>The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to
        /// Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
        /// <code>MonitoringRoleArn</code> value.</p>
        pub fn monitoring_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitoring_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to
        /// Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
        /// <code>MonitoringRoleArn</code> value.</p>
        pub fn set_monitoring_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitoring_role_arn = input;
            self
        }
        /// <p>Not supported</p>
        pub fn domain_iam_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_iam_role_name = Some(input.into());
            self
        }
        /// <p>Not supported</p>
        pub fn set_domain_iam_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_iam_role_name = input;
            self
        }
        /// <p>A value that specifies the order in which a Read Replica is promoted to the primary
        /// instance after a failure of the existing primary instance.</p>
        /// <p>Default: 1</p>
        /// <p>Valid Values: 0 - 15</p>
        pub fn promotion_tier(mut self, input: i32) -> Self {
            self.promotion_tier = Some(input);
            self
        }
        /// <p>A value that specifies the order in which a Read Replica is promoted to the primary
        /// instance after a failure of the existing primary instance.</p>
        /// <p>Default: 1</p>
        /// <p>Valid Values: 0 - 15</p>
        pub fn set_promotion_tier(mut self, input: std::option::Option<i32>) -> Self {
            self.promotion_tier = input;
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
        /// accounts, and otherwise false.</p>
        /// <p>You can enable IAM database authentication for the following database engines</p>
        /// <p>Not applicable. Mapping Amazon IAM accounts to database accounts is managed by the DB
        /// cluster. For more information, see <a>ModifyDBCluster</a>.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn enable_iam_database_authentication(mut self, input: bool) -> Self {
            self.enable_iam_database_authentication = Some(input);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
        /// accounts, and otherwise false.</p>
        /// <p>You can enable IAM database authentication for the following database engines</p>
        /// <p>Not applicable. Mapping Amazon IAM accounts to database accounts is managed by the DB
        /// cluster. For more information, see <a>ModifyDBCluster</a>.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_iam_database_authentication = input;
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn enable_performance_insights(mut self, input: bool) -> Self {
            self.enable_performance_insights = Some(input);
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_enable_performance_insights(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_performance_insights = input;
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn performance_insights_kms_key_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.performance_insights_kms_key_id = Some(input.into());
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_performance_insights_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.performance_insights_kms_key_id = input;
            self
        }
        /// <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs
        /// for a specific DB instance or DB cluster.</p>
        pub fn cloudwatch_logs_export_configuration(
            mut self,
            input: crate::model::CloudwatchLogsExportConfiguration,
        ) -> Self {
            self.cloudwatch_logs_export_configuration = Some(input);
            self
        }
        /// <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs
        /// for a specific DB instance or DB cluster.</p>
        pub fn set_cloudwatch_logs_export_configuration(
            mut self,
            input: std::option::Option<crate::model::CloudwatchLogsExportConfiguration>,
        ) -> Self {
            self.cloudwatch_logs_export_configuration = input;
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled.  See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting
        /// a DB Instance</a>.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled.  See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting
        /// a DB Instance</a>.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbInstanceInput`](crate::input::ModifyDbInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyDbInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyDbInstanceInput {
                db_instance_identifier: self.db_instance_identifier,
                allocated_storage: self.allocated_storage,
                db_instance_class: self.db_instance_class,
                db_subnet_group_name: self.db_subnet_group_name,
                db_security_groups: self.db_security_groups,
                vpc_security_group_ids: self.vpc_security_group_ids,
                apply_immediately: self.apply_immediately.unwrap_or_default(),
                master_user_password: self.master_user_password,
                db_parameter_group_name: self.db_parameter_group_name,
                backup_retention_period: self.backup_retention_period,
                preferred_backup_window: self.preferred_backup_window,
                preferred_maintenance_window: self.preferred_maintenance_window,
                multi_az: self.multi_az,
                engine_version: self.engine_version,
                allow_major_version_upgrade: self.allow_major_version_upgrade.unwrap_or_default(),
                auto_minor_version_upgrade: self.auto_minor_version_upgrade,
                license_model: self.license_model,
                iops: self.iops,
                option_group_name: self.option_group_name,
                new_db_instance_identifier: self.new_db_instance_identifier,
                storage_type: self.storage_type,
                tde_credential_arn: self.tde_credential_arn,
                tde_credential_password: self.tde_credential_password,
                ca_certificate_identifier: self.ca_certificate_identifier,
                domain: self.domain,
                copy_tags_to_snapshot: self.copy_tags_to_snapshot,
                monitoring_interval: self.monitoring_interval,
                db_port_number: self.db_port_number,
                publicly_accessible: self.publicly_accessible,
                monitoring_role_arn: self.monitoring_role_arn,
                domain_iam_role_name: self.domain_iam_role_name,
                promotion_tier: self.promotion_tier,
                enable_iam_database_authentication: self.enable_iam_database_authentication,
                enable_performance_insights: self.enable_performance_insights,
                performance_insights_kms_key_id: self.performance_insights_kms_key_id,
                cloudwatch_logs_export_configuration: self.cloudwatch_logs_export_configuration,
                deletion_protection: self.deletion_protection,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyDbInstanceInputOperationOutputAlias = crate::operation::ModifyDBInstance;
#[doc(hidden)]
pub type ModifyDbInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyDbInstanceInput {
    /// Consumes the builder and constructs an Operation<[`ModifyDBInstance`](crate::operation::ModifyDBInstance)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyDBInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyDbInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyDbInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyDbInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_db_instance(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyDBInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyDBInstance",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyDbInstanceInput`](crate::input::ModifyDbInstanceInput)
    pub fn builder() -> crate::input::modify_db_instance_input::Builder {
        crate::input::modify_db_instance_input::Builder::default()
    }
}

/// See [`ModifyDbParameterGroupInput`](crate::input::ModifyDbParameterGroupInput)
pub mod modify_db_parameter_group_input {
    /// A builder for [`ModifyDbParameterGroupInput`](crate::input::ModifyDbParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    }
    impl Builder {
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>An array of parameter names, values, and the apply method for the parameter update. At
        /// least one parameter name, value, and apply method must be supplied; subsequent arguments are
        /// optional. A maximum of 20 parameters can be modified in a single request.</p>
        /// <p>Valid Values (for the application method): <code>immediate | pending-reboot</code>
        /// </p>
        /// <note>
        /// <p>You can use the immediate value with dynamic parameters only. You can use the
        /// pending-reboot value for both dynamic and static parameters, and changes are applied when
        /// you reboot the DB instance without failover.</p>
        /// </note>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>An array of parameter names, values, and the apply method for the parameter update. At
        /// least one parameter name, value, and apply method must be supplied; subsequent arguments are
        /// optional. A maximum of 20 parameters can be modified in a single request.</p>
        /// <p>Valid Values (for the application method): <code>immediate | pending-reboot</code>
        /// </p>
        /// <note>
        /// <p>You can use the immediate value with dynamic parameters only. You can use the
        /// pending-reboot value for both dynamic and static parameters, and changes are applied when
        /// you reboot the DB instance without failover.</p>
        /// </note>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbParameterGroupInput`](crate::input::ModifyDbParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyDbParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyDbParameterGroupInput {
                db_parameter_group_name: self.db_parameter_group_name,
                parameters: self.parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyDbParameterGroupInputOperationOutputAlias = crate::operation::ModifyDBParameterGroup;
#[doc(hidden)]
pub type ModifyDbParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyDbParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`ModifyDBParameterGroup`](crate::operation::ModifyDBParameterGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyDBParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyDbParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyDbParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyDbParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_db_parameter_group(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyDBParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyDBParameterGroup",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyDbParameterGroupInput`](crate::input::ModifyDbParameterGroupInput)
    pub fn builder() -> crate::input::modify_db_parameter_group_input::Builder {
        crate::input::modify_db_parameter_group_input::Builder::default()
    }
}

/// See [`ModifyDbSubnetGroupInput`](crate::input::ModifyDbSubnetGroupInput)
pub mod modify_db_subnet_group_input {
    /// A builder for [`ModifyDbSubnetGroupInput`](crate::input::ModifyDbSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group_description: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name for the DB subnet group. This value is stored as a lowercase string. You can't
        /// modify the default subnet group.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name for the DB subnet group. This value is stored as a lowercase string. You can't
        /// modify the default subnet group.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// <p>The description for the DB subnet group.</p>
        pub fn db_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_subnet_group_description = Some(input.into());
            self
        }
        /// <p>The description for the DB subnet group.</p>
        pub fn set_db_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_description = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The EC2 subnet IDs for the DB subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The EC2 subnet IDs for the DB subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbSubnetGroupInput`](crate::input::ModifyDbSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyDbSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyDbSubnetGroupInput {
                db_subnet_group_name: self.db_subnet_group_name,
                db_subnet_group_description: self.db_subnet_group_description,
                subnet_ids: self.subnet_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyDbSubnetGroupInputOperationOutputAlias = crate::operation::ModifyDBSubnetGroup;
#[doc(hidden)]
pub type ModifyDbSubnetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyDbSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`ModifyDBSubnetGroup`](crate::operation::ModifyDBSubnetGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyDBSubnetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyDbSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyDbSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyDbSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_db_subnet_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyDBSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyDBSubnetGroup",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyDbSubnetGroupInput`](crate::input::ModifyDbSubnetGroupInput)
    pub fn builder() -> crate::input::modify_db_subnet_group_input::Builder {
        crate::input::modify_db_subnet_group_input::Builder::default()
    }
}

/// See [`ModifyEventSubscriptionInput`](crate::input::ModifyEventSubscriptionInput)
pub mod modify_event_subscription_input {
    /// A builder for [`ModifyEventSubscriptionInput`](crate::input::ModifyEventSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the event notification subscription.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the event notification subscription.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is
        /// created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is
        /// created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified
        /// of events generated by a DB instance, you would set this parameter to db-instance. if this
        /// value is not specified, all events are returned.</p>
        /// <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified
        /// of events generated by a DB instance, you would set this parameter to db-instance. if this
        /// value is not specified, all events are returned.</p>
        /// <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p> A list of event categories for a SourceType that you want to subscribe to. You can see a
        /// list of the categories for a given SourceType
        ///
        /// by using the <b>DescribeEventCategories</b> action.</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p> A list of event categories for a SourceType that you want to subscribe to. You can see a
        /// list of the categories for a given SourceType
        ///
        /// by using the <b>DescribeEventCategories</b> action.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// <p> A Boolean value; set to <b>true</b> to activate the
        /// subscription.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p> A Boolean value; set to <b>true</b> to activate the
        /// subscription.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyEventSubscriptionInput`](crate::input::ModifyEventSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyEventSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyEventSubscriptionInput {
                subscription_name: self.subscription_name,
                sns_topic_arn: self.sns_topic_arn,
                source_type: self.source_type,
                event_categories: self.event_categories,
                enabled: self.enabled,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyEventSubscriptionInputOperationOutputAlias =
    crate::operation::ModifyEventSubscription;
#[doc(hidden)]
pub type ModifyEventSubscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyEventSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`ModifyEventSubscription`](crate::operation::ModifyEventSubscription)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyEventSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyEventSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyEventSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyEventSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_event_subscription(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyEventSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyEventSubscription",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyEventSubscriptionInput`](crate::input::ModifyEventSubscriptionInput)
    pub fn builder() -> crate::input::modify_event_subscription_input::Builder {
        crate::input::modify_event_subscription_input::Builder::default()
    }
}

/// See [`PromoteReadReplicaDbClusterInput`](crate::input::PromoteReadReplicaDbClusterInput)
pub mod promote_read_replica_db_cluster_input {
    /// A builder for [`PromoteReadReplicaDbClusterInput`](crate::input::PromoteReadReplicaDbClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Not supported.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>Not supported.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`PromoteReadReplicaDbClusterInput`](crate::input::PromoteReadReplicaDbClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PromoteReadReplicaDbClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PromoteReadReplicaDbClusterInput {
                db_cluster_identifier: self.db_cluster_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type PromoteReadReplicaDbClusterInputOperationOutputAlias =
    crate::operation::PromoteReadReplicaDBCluster;
#[doc(hidden)]
pub type PromoteReadReplicaDbClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PromoteReadReplicaDbClusterInput {
    /// Consumes the builder and constructs an Operation<[`PromoteReadReplicaDBCluster`](crate::operation::PromoteReadReplicaDBCluster)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PromoteReadReplicaDBCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PromoteReadReplicaDbClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PromoteReadReplicaDbClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PromoteReadReplicaDbClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_promote_read_replica_db_cluster(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PromoteReadReplicaDBCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PromoteReadReplicaDBCluster",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PromoteReadReplicaDbClusterInput`](crate::input::PromoteReadReplicaDbClusterInput)
    pub fn builder() -> crate::input::promote_read_replica_db_cluster_input::Builder {
        crate::input::promote_read_replica_db_cluster_input::Builder::default()
    }
}

/// See [`RebootDbInstanceInput`](crate::input::RebootDbInstanceInput)
pub mod reboot_db_instance_input {
    /// A builder for [`RebootDbInstanceInput`](crate::input::RebootDbInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) force_failover: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p> When <code>true</code>, the reboot is conducted through a MultiAZ failover.</p>
        /// <p>Constraint: You can't specify <code>true</code> if the instance is not configured for
        /// MultiAZ.</p>
        pub fn force_failover(mut self, input: bool) -> Self {
            self.force_failover = Some(input);
            self
        }
        /// <p> When <code>true</code>, the reboot is conducted through a MultiAZ failover.</p>
        /// <p>Constraint: You can't specify <code>true</code> if the instance is not configured for
        /// MultiAZ.</p>
        pub fn set_force_failover(mut self, input: std::option::Option<bool>) -> Self {
            self.force_failover = input;
            self
        }
        /// Consumes the builder and constructs a [`RebootDbInstanceInput`](crate::input::RebootDbInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RebootDbInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RebootDbInstanceInput {
                db_instance_identifier: self.db_instance_identifier,
                force_failover: self.force_failover,
            })
        }
    }
}
#[doc(hidden)]
pub type RebootDbInstanceInputOperationOutputAlias = crate::operation::RebootDBInstance;
#[doc(hidden)]
pub type RebootDbInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RebootDbInstanceInput {
    /// Consumes the builder and constructs an Operation<[`RebootDBInstance`](crate::operation::RebootDBInstance)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RebootDBInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RebootDbInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RebootDbInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RebootDbInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_reboot_db_instance(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RebootDBInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RebootDBInstance",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RebootDbInstanceInput`](crate::input::RebootDbInstanceInput)
    pub fn builder() -> crate::input::reboot_db_instance_input::Builder {
        crate::input::reboot_db_instance_input::Builder::default()
    }
}

/// See [`RemoveRoleFromDbClusterInput`](crate::input::RemoveRoleFromDbClusterInput)
pub mod remove_role_from_db_cluster_input {
    /// A builder for [`RemoveRoleFromDbClusterInput`](crate::input::RemoveRoleFromDbClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) feature_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB cluster to disassociate the IAM role from.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster to disassociate the IAM role from.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to disassociate from the DB cluster, for
        /// example <code>arn:aws:iam::123456789012:role/NeptuneAccessRole</code>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to disassociate from the DB cluster, for
        /// example <code>arn:aws:iam::123456789012:role/NeptuneAccessRole</code>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The name of the feature for the DB cluster that the IAM role is to be disassociated from.
        /// For the list of supported feature names, see <a>DBEngineVersion</a>.</p>
        pub fn feature_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature_name = Some(input.into());
            self
        }
        /// <p>The name of the feature for the DB cluster that the IAM role is to be disassociated from.
        /// For the list of supported feature names, see <a>DBEngineVersion</a>.</p>
        pub fn set_feature_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feature_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveRoleFromDbClusterInput`](crate::input::RemoveRoleFromDbClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveRoleFromDbClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveRoleFromDbClusterInput {
                db_cluster_identifier: self.db_cluster_identifier,
                role_arn: self.role_arn,
                feature_name: self.feature_name,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveRoleFromDbClusterInputOperationOutputAlias =
    crate::operation::RemoveRoleFromDBCluster;
#[doc(hidden)]
pub type RemoveRoleFromDbClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveRoleFromDbClusterInput {
    /// Consumes the builder and constructs an Operation<[`RemoveRoleFromDBCluster`](crate::operation::RemoveRoleFromDBCluster)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveRoleFromDBCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveRoleFromDbClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveRoleFromDbClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveRoleFromDbClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_role_from_db_cluster(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveRoleFromDBCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveRoleFromDBCluster",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveRoleFromDbClusterInput`](crate::input::RemoveRoleFromDbClusterInput)
    pub fn builder() -> crate::input::remove_role_from_db_cluster_input::Builder {
        crate::input::remove_role_from_db_cluster_input::Builder::default()
    }
}

/// See [`RemoveSourceIdentifierFromSubscriptionInput`](crate::input::RemoveSourceIdentifierFromSubscriptionInput)
pub mod remove_source_identifier_from_subscription_input {
    /// A builder for [`RemoveSourceIdentifierFromSubscriptionInput`](crate::input::RemoveSourceIdentifierFromSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
        pub(crate) source_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the event notification subscription you want to remove a source identifier
        /// from.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the event notification subscription you want to remove a source identifier
        /// from.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// <p> The source identifier to be removed from the subscription, such as the <b>DB instance identifier</b> for a DB instance or the name of a security
        /// group.</p>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identifier = Some(input.into());
            self
        }
        /// <p> The source identifier to be removed from the subscription, such as the <b>DB instance identifier</b> for a DB instance or the name of a security
        /// group.</p>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveSourceIdentifierFromSubscriptionInput`](crate::input::RemoveSourceIdentifierFromSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveSourceIdentifierFromSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveSourceIdentifierFromSubscriptionInput {
                subscription_name: self.subscription_name,
                source_identifier: self.source_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveSourceIdentifierFromSubscriptionInputOperationOutputAlias =
    crate::operation::RemoveSourceIdentifierFromSubscription;
#[doc(hidden)]
pub type RemoveSourceIdentifierFromSubscriptionInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl RemoveSourceIdentifierFromSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`RemoveSourceIdentifierFromSubscription`](crate::operation::RemoveSourceIdentifierFromSubscription)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveSourceIdentifierFromSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveSourceIdentifierFromSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveSourceIdentifierFromSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveSourceIdentifierFromSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_source_identifier_from_subscription(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveSourceIdentifierFromSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveSourceIdentifierFromSubscription",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveSourceIdentifierFromSubscriptionInput`](crate::input::RemoveSourceIdentifierFromSubscriptionInput)
    pub fn builder() -> crate::input::remove_source_identifier_from_subscription_input::Builder {
        crate::input::remove_source_identifier_from_subscription_input::Builder::default()
    }
}

/// See [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
pub mod remove_tags_from_resource_input {
    /// A builder for [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Neptune resource that the tags are removed from. This value is an Amazon
        /// Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The Amazon Neptune resource that the tags are removed from. This value is an Amazon
        /// Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
        /// Amazon Resource Name (ARN)</a>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveTagsFromResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveTagsFromResourceInput {
                resource_name: self.resource_name,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveTagsFromResourceInputOperationOutputAlias = crate::operation::RemoveTagsFromResource;
#[doc(hidden)]
pub type RemoveTagsFromResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveTagsFromResourceInput {
    /// Consumes the builder and constructs an Operation<[`RemoveTagsFromResource`](crate::operation::RemoveTagsFromResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveTagsFromResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveTagsFromResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveTagsFromResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveTagsFromResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_tags_from_resource(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveTagsFromResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveTagsFromResource",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    pub fn builder() -> crate::input::remove_tags_from_resource_input::Builder {
        crate::input::remove_tags_from_resource_input::Builder::default()
    }
}

/// See [`ResetDbClusterParameterGroupInput`](crate::input::ResetDbClusterParameterGroupInput)
pub mod reset_db_cluster_parameter_group_input {
    /// A builder for [`ResetDbClusterParameterGroupInput`](crate::input::ResetDbClusterParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) reset_all_parameters: std::option::Option<bool>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    }
    impl Builder {
        /// <p>The name of the DB cluster parameter group to reset.</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group to reset.</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// <p>A value that is set to <code>true</code> to reset all parameters in the DB cluster
        /// parameter group to their default values, and <code>false</code> otherwise. You can't use this
        /// parameter if there is a list of parameter names specified for the <code>Parameters</code>
        /// parameter.</p>
        pub fn reset_all_parameters(mut self, input: bool) -> Self {
            self.reset_all_parameters = Some(input);
            self
        }
        /// <p>A value that is set to <code>true</code> to reset all parameters in the DB cluster
        /// parameter group to their default values, and <code>false</code> otherwise. You can't use this
        /// parameter if there is a list of parameter names specified for the <code>Parameters</code>
        /// parameter.</p>
        pub fn set_reset_all_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.reset_all_parameters = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of parameter names in the DB cluster parameter group to reset to the default
        /// values. You can't use this parameter if the <code>ResetAllParameters</code> parameter is set
        /// to <code>true</code>.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>A list of parameter names in the DB cluster parameter group to reset to the default
        /// values. You can't use this parameter if the <code>ResetAllParameters</code> parameter is set
        /// to <code>true</code>.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetDbClusterParameterGroupInput`](crate::input::ResetDbClusterParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResetDbClusterParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResetDbClusterParameterGroupInput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                reset_all_parameters: self.reset_all_parameters.unwrap_or_default(),
                parameters: self.parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type ResetDbClusterParameterGroupInputOperationOutputAlias =
    crate::operation::ResetDBClusterParameterGroup;
#[doc(hidden)]
pub type ResetDbClusterParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ResetDbClusterParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`ResetDBClusterParameterGroup`](crate::operation::ResetDBClusterParameterGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResetDBClusterParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResetDbClusterParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResetDbClusterParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResetDbClusterParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_reset_db_cluster_parameter_group(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResetDBClusterParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResetDBClusterParameterGroup",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResetDbClusterParameterGroupInput`](crate::input::ResetDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::reset_db_cluster_parameter_group_input::Builder {
        crate::input::reset_db_cluster_parameter_group_input::Builder::default()
    }
}

/// See [`ResetDbParameterGroupInput`](crate::input::ResetDbParameterGroupInput)
pub mod reset_db_parameter_group_input {
    /// A builder for [`ResetDbParameterGroupInput`](crate::input::ResetDbParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) reset_all_parameters: std::option::Option<bool>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    }
    impl Builder {
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing DBParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing DBParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// <p>Specifies whether (<code>true</code>) or not (<code>false</code>) to reset all parameters
        /// in the DB parameter group to default values.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn reset_all_parameters(mut self, input: bool) -> Self {
            self.reset_all_parameters = Some(input);
            self
        }
        /// <p>Specifies whether (<code>true</code>) or not (<code>false</code>) to reset all parameters
        /// in the DB parameter group to default values.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn set_reset_all_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.reset_all_parameters = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>To reset the entire DB parameter group, specify the <code>DBParameterGroup</code> name and
        /// <code>ResetAllParameters</code> parameters. To reset specific parameters, provide a list of
        /// the following: <code>ParameterName</code> and <code>ApplyMethod</code>. A maximum of 20
        /// parameters can be modified in a single request.</p>
        /// <p>Valid Values (for Apply method): <code>pending-reboot</code>
        /// </p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>To reset the entire DB parameter group, specify the <code>DBParameterGroup</code> name and
        /// <code>ResetAllParameters</code> parameters. To reset specific parameters, provide a list of
        /// the following: <code>ParameterName</code> and <code>ApplyMethod</code>. A maximum of 20
        /// parameters can be modified in a single request.</p>
        /// <p>Valid Values (for Apply method): <code>pending-reboot</code>
        /// </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetDbParameterGroupInput`](crate::input::ResetDbParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResetDbParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResetDbParameterGroupInput {
                db_parameter_group_name: self.db_parameter_group_name,
                reset_all_parameters: self.reset_all_parameters.unwrap_or_default(),
                parameters: self.parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type ResetDbParameterGroupInputOperationOutputAlias = crate::operation::ResetDBParameterGroup;
#[doc(hidden)]
pub type ResetDbParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ResetDbParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`ResetDBParameterGroup`](crate::operation::ResetDBParameterGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResetDBParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResetDbParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResetDbParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResetDbParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_reset_db_parameter_group(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResetDBParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResetDBParameterGroup",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResetDbParameterGroupInput`](crate::input::ResetDbParameterGroupInput)
    pub fn builder() -> crate::input::reset_db_parameter_group_input::Builder {
        crate::input::reset_db_parameter_group_input::Builder::default()
    }
}

/// See [`RestoreDbClusterFromSnapshotInput`](crate::input::RestoreDbClusterFromSnapshotInput)
pub mod restore_db_cluster_from_snapshot_input {
    /// A builder for [`RestoreDbClusterFromSnapshotInput`](crate::input::RestoreDbClusterFromSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) option_group_name: std::option::Option<std::string::String>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) enable_iam_database_authentication: std::option::Option<bool>,
        pub(crate) enable_cloudwatch_logs_exports:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) deletion_protection: std::option::Option<bool>,
        pub(crate) copy_tags_to_snapshot: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>Provides the list of EC2 Availability Zones that instances in the restored DB cluster can
        /// be created in.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>Provides the list of EC2 Availability Zones that instances in the restored DB cluster can
        /// be created in.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// <p>The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This
        /// parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This
        /// parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>The identifier for the DB snapshot or DB cluster snapshot to restore from.</p>
        /// <p>You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster
        /// snapshot. However, you can use only the ARN to specify a DB snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing Snapshot.</p>
        /// </li>
        /// </ul>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the DB snapshot or DB cluster snapshot to restore from.</p>
        /// <p>You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster
        /// snapshot. However, you can use only the ARN to specify a DB snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing Snapshot.</p>
        /// </li>
        /// </ul>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_identifier = input;
            self
        }
        /// <p>The database engine to use for the new DB cluster.</p>
        /// <p>Default: The same as source</p>
        /// <p>Constraint: Must be compatible with the engine of the source</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The database engine to use for the new DB cluster.</p>
        /// <p>Default: The same as source</p>
        /// <p>Constraint: Must be compatible with the engine of the source</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The version of the database engine to use for the new DB cluster.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version of the database engine to use for the new DB cluster.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The port number on which the new DB cluster accepts connections.</p>
        /// <p>Constraints: Value must be <code>1150-65535</code>
        /// </p>
        /// <p>Default: The same port as the original DB cluster.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number on which the new DB cluster accepts connections.</p>
        /// <p>Constraints: Value must be <code>1150-65535</code>
        /// </p>
        /// <p>Default: The same port as the original DB cluster.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The name of the DB subnet group to use for the new DB cluster.</p>
        /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB subnet group to use for the new DB cluster.</p>
        /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// <p>Not supported.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>Not supported.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_name = Some(input.into());
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_name = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of VPC security groups that the new DB cluster will belong to.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>A list of VPC security groups that the new DB cluster will belong to.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the restored DB cluster.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the restored DB cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon KMS key identifier to use when restoring an encrypted DB cluster from a DB
        /// snapshot or DB cluster snapshot.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
        /// you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used
        /// to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the
        /// KMS encryption key.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following
        /// will occur:</p>
        /// <ul>
        /// <li>
        /// <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is
        /// encrypted, then the restored DB cluster is encrypted using the KMS key that was used to
        /// encrypt the DB snapshot or DB cluster snapshot.</p>
        /// </li>
        /// <li>
        /// <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is not
        /// encrypted, then the restored DB cluster is not encrypted.</p>
        /// </li>
        /// </ul>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon KMS key identifier to use when restoring an encrypted DB cluster from a DB
        /// snapshot or DB cluster snapshot.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
        /// you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used
        /// to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the
        /// KMS encryption key.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following
        /// will occur:</p>
        /// <ul>
        /// <li>
        /// <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is
        /// encrypted, then the restored DB cluster is encrypted using the KMS key that was used to
        /// encrypt the DB snapshot or DB cluster snapshot.</p>
        /// </li>
        /// <li>
        /// <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is not
        /// encrypted, then the restored DB cluster is not encrypted.</p>
        /// </li>
        /// </ul>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
        /// accounts, and otherwise false.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn enable_iam_database_authentication(mut self, input: bool) -> Self {
            self.enable_iam_database_authentication = Some(input);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
        /// accounts, and otherwise false.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_iam_database_authentication = input;
            self
        }
        /// Appends an item to `enable_cloudwatch_logs_exports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs.</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.enable_cloudwatch_logs_exports.unwrap_or_default();
            v.push(input.into());
            self.enable_cloudwatch_logs_exports = Some(v);
            self
        }
        /// <p>The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs.</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.enable_cloudwatch_logs_exports = input;
            self
        }
        /// <p>The name of the DB cluster parameter group to associate with the new DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group to associate with the new DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled.
        /// </p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled.
        /// </p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// <p>
        /// <i>If set to <code>true</code>, tags are copied to any snapshot of
        /// the restored DB cluster that is created.</i>
        /// </p>
        pub fn copy_tags_to_snapshot(mut self, input: bool) -> Self {
            self.copy_tags_to_snapshot = Some(input);
            self
        }
        /// <p>
        /// <i>If set to <code>true</code>, tags are copied to any snapshot of
        /// the restored DB cluster that is created.</i>
        /// </p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags_to_snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreDbClusterFromSnapshotInput`](crate::input::RestoreDbClusterFromSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RestoreDbClusterFromSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RestoreDbClusterFromSnapshotInput {
                availability_zones: self.availability_zones,
                db_cluster_identifier: self.db_cluster_identifier,
                snapshot_identifier: self.snapshot_identifier,
                engine: self.engine,
                engine_version: self.engine_version,
                port: self.port,
                db_subnet_group_name: self.db_subnet_group_name,
                database_name: self.database_name,
                option_group_name: self.option_group_name,
                vpc_security_group_ids: self.vpc_security_group_ids,
                tags: self.tags,
                kms_key_id: self.kms_key_id,
                enable_iam_database_authentication: self.enable_iam_database_authentication,
                enable_cloudwatch_logs_exports: self.enable_cloudwatch_logs_exports,
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                deletion_protection: self.deletion_protection,
                copy_tags_to_snapshot: self.copy_tags_to_snapshot,
            })
        }
    }
}
#[doc(hidden)]
pub type RestoreDbClusterFromSnapshotInputOperationOutputAlias =
    crate::operation::RestoreDBClusterFromSnapshot;
#[doc(hidden)]
pub type RestoreDbClusterFromSnapshotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RestoreDbClusterFromSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`RestoreDBClusterFromSnapshot`](crate::operation::RestoreDBClusterFromSnapshot)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RestoreDBClusterFromSnapshot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RestoreDbClusterFromSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RestoreDbClusterFromSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RestoreDbClusterFromSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_restore_db_cluster_from_snapshot(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RestoreDBClusterFromSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RestoreDBClusterFromSnapshot",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RestoreDbClusterFromSnapshotInput`](crate::input::RestoreDbClusterFromSnapshotInput)
    pub fn builder() -> crate::input::restore_db_cluster_from_snapshot_input::Builder {
        crate::input::restore_db_cluster_from_snapshot_input::Builder::default()
    }
}

/// See [`RestoreDbClusterToPointInTimeInput`](crate::input::RestoreDbClusterToPointInTimeInput)
pub mod restore_db_cluster_to_point_in_time_input {
    /// A builder for [`RestoreDbClusterToPointInTimeInput`](crate::input::RestoreDbClusterToPointInTimeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) restore_type: std::option::Option<std::string::String>,
        pub(crate) source_db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) restore_to_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) use_latest_restorable_time: std::option::Option<bool>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) option_group_name: std::option::Option<std::string::String>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) enable_iam_database_authentication: std::option::Option<bool>,
        pub(crate) enable_cloudwatch_logs_exports:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) deletion_protection: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the new DB cluster to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The name of the new DB cluster to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>The type of restore to be performed. You can specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>full-copy</code> - The new DB cluster is restored as a full copy of the source
        /// DB cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source
        /// DB cluster.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored
        /// as a full copy of the source DB cluster.</p>
        pub fn restore_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.restore_type = Some(input.into());
            self
        }
        /// <p>The type of restore to be performed. You can specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>full-copy</code> - The new DB cluster is restored as a full copy of the source
        /// DB cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source
        /// DB cluster.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored
        /// as a full copy of the source DB cluster.</p>
        pub fn set_restore_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.restore_type = input;
            self
        }
        /// <p>The identifier of the source DB cluster from which to restore.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn source_db_cluster_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the source DB cluster from which to restore.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn set_source_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_db_cluster_identifier = input;
            self
        }
        /// <p>The date and time to restore the DB cluster to.</p>
        /// <p>Valid Values: Value must be a time in Universal Coordinated Time (UTC) format</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be before the latest restorable time for the DB instance</p>
        /// </li>
        /// <li>
        /// <p>Must be specified if <code>UseLatestRestorableTime</code> parameter is not
        /// provided</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified if <code>UseLatestRestorableTime</code> parameter is true</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified if <code>RestoreType</code> parameter is
        /// <code>copy-on-write</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>2015-03-07T23:45:00Z</code>
        /// </p>
        pub fn restore_to_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.restore_to_time = Some(input);
            self
        }
        /// <p>The date and time to restore the DB cluster to.</p>
        /// <p>Valid Values: Value must be a time in Universal Coordinated Time (UTC) format</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be before the latest restorable time for the DB instance</p>
        /// </li>
        /// <li>
        /// <p>Must be specified if <code>UseLatestRestorableTime</code> parameter is not
        /// provided</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified if <code>UseLatestRestorableTime</code> parameter is true</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified if <code>RestoreType</code> parameter is
        /// <code>copy-on-write</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>2015-03-07T23:45:00Z</code>
        /// </p>
        pub fn set_restore_to_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.restore_to_time = input;
            self
        }
        /// <p>A value that is set to <code>true</code> to restore the DB cluster to the latest
        /// restorable backup time, and <code>false</code> otherwise.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        /// <p>Constraints: Cannot be specified if <code>RestoreToTime</code> parameter is
        /// provided.</p>
        pub fn use_latest_restorable_time(mut self, input: bool) -> Self {
            self.use_latest_restorable_time = Some(input);
            self
        }
        /// <p>A value that is set to <code>true</code> to restore the DB cluster to the latest
        /// restorable backup time, and <code>false</code> otherwise.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        /// <p>Constraints: Cannot be specified if <code>RestoreToTime</code> parameter is
        /// provided.</p>
        pub fn set_use_latest_restorable_time(mut self, input: std::option::Option<bool>) -> Self {
            self.use_latest_restorable_time = input;
            self
        }
        /// <p>The port number on which the new DB cluster accepts connections.</p>
        /// <p>Constraints: Value must be <code>1150-65535</code>
        /// </p>
        /// <p>Default: The same port as the original DB cluster.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number on which the new DB cluster accepts connections.</p>
        /// <p>Constraints: Value must be <code>1150-65535</code>
        /// </p>
        /// <p>Default: The same port as the original DB cluster.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The DB subnet group name to use for the new DB cluster.</p>
        /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The DB subnet group name to use for the new DB cluster.</p>
        /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_name = Some(input.into());
            self
        }
        /// <p>
        /// <i>(Not supported by Neptune)</i>
        /// </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_name = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of VPC security groups that the new DB cluster belongs to.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>A list of VPC security groups that the new DB cluster belongs to.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be applied to the restored DB cluster.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be applied to the restored DB cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon KMS key identifier to use when restoring an encrypted DB cluster from an encrypted
        /// DB cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
        /// you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used
        /// to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the
        /// KMS encryption key.</p>
        /// <p>You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is
        /// different than the KMS key used to encrypt the source DB cluster. The new DB cluster is
        /// encrypted with the KMS key identified by the <code>KmsKeyId</code> parameter.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following
        /// will occur:</p>
        /// <ul>
        /// <li>
        /// <p>If the DB cluster is encrypted, then the restored DB cluster is encrypted using the
        /// KMS key that was used to encrypt the source DB cluster.</p>
        /// </li>
        /// <li>
        /// <p>If the DB cluster is not encrypted, then the restored DB cluster is not
        /// encrypted.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>DBClusterIdentifier</code> refers to a DB cluster that is not encrypted, then the
        /// restore request is rejected.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon KMS key identifier to use when restoring an encrypted DB cluster from an encrypted
        /// DB cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
        /// you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used
        /// to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the
        /// KMS encryption key.</p>
        /// <p>You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is
        /// different than the KMS key used to encrypt the source DB cluster. The new DB cluster is
        /// encrypted with the KMS key identified by the <code>KmsKeyId</code> parameter.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following
        /// will occur:</p>
        /// <ul>
        /// <li>
        /// <p>If the DB cluster is encrypted, then the restored DB cluster is encrypted using the
        /// KMS key that was used to encrypt the source DB cluster.</p>
        /// </li>
        /// <li>
        /// <p>If the DB cluster is not encrypted, then the restored DB cluster is not
        /// encrypted.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>DBClusterIdentifier</code> refers to a DB cluster that is not encrypted, then the
        /// restore request is rejected.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
        /// accounts, and otherwise false.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn enable_iam_database_authentication(mut self, input: bool) -> Self {
            self.enable_iam_database_authentication = Some(input);
            self
        }
        /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
        /// accounts, and otherwise false.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_iam_database_authentication = input;
            self
        }
        /// Appends an item to `enable_cloudwatch_logs_exports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>The list of logs that the restored DB cluster is to export to CloudWatch Logs.</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.enable_cloudwatch_logs_exports.unwrap_or_default();
            v.push(input.into());
            self.enable_cloudwatch_logs_exports = Some(v);
            self
        }
        /// <p>The list of logs that the restored DB cluster is to export to CloudWatch Logs.</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.enable_cloudwatch_logs_exports = input;
            self
        }
        /// <p>The name of the DB cluster parameter group to associate with the new DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group to associate with the new DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled.
        /// </p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled.
        /// </p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreDbClusterToPointInTimeInput`](crate::input::RestoreDbClusterToPointInTimeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RestoreDbClusterToPointInTimeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RestoreDbClusterToPointInTimeInput {
                db_cluster_identifier: self.db_cluster_identifier,
                restore_type: self.restore_type,
                source_db_cluster_identifier: self.source_db_cluster_identifier,
                restore_to_time: self.restore_to_time,
                use_latest_restorable_time: self.use_latest_restorable_time.unwrap_or_default(),
                port: self.port,
                db_subnet_group_name: self.db_subnet_group_name,
                option_group_name: self.option_group_name,
                vpc_security_group_ids: self.vpc_security_group_ids,
                tags: self.tags,
                kms_key_id: self.kms_key_id,
                enable_iam_database_authentication: self.enable_iam_database_authentication,
                enable_cloudwatch_logs_exports: self.enable_cloudwatch_logs_exports,
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                deletion_protection: self.deletion_protection,
            })
        }
    }
}
#[doc(hidden)]
pub type RestoreDbClusterToPointInTimeInputOperationOutputAlias =
    crate::operation::RestoreDBClusterToPointInTime;
#[doc(hidden)]
pub type RestoreDbClusterToPointInTimeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RestoreDbClusterToPointInTimeInput {
    /// Consumes the builder and constructs an Operation<[`RestoreDBClusterToPointInTime`](crate::operation::RestoreDBClusterToPointInTime)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RestoreDBClusterToPointInTime,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RestoreDbClusterToPointInTimeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RestoreDbClusterToPointInTimeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RestoreDbClusterToPointInTimeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_restore_db_cluster_to_point_in_time(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RestoreDBClusterToPointInTime::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RestoreDBClusterToPointInTime",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RestoreDbClusterToPointInTimeInput`](crate::input::RestoreDbClusterToPointInTimeInput)
    pub fn builder() -> crate::input::restore_db_cluster_to_point_in_time_input::Builder {
        crate::input::restore_db_cluster_to_point_in_time_input::Builder::default()
    }
}

/// See [`StartDbClusterInput`](crate::input::StartDbClusterInput)
pub mod start_db_cluster_input {
    /// A builder for [`StartDbClusterInput`](crate::input::StartDbClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The DB cluster identifier of the Neptune DB cluster to be started.
        /// This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier of the Neptune DB cluster to be started.
        /// This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDbClusterInput`](crate::input::StartDbClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartDbClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartDbClusterInput {
                db_cluster_identifier: self.db_cluster_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type StartDbClusterInputOperationOutputAlias = crate::operation::StartDBCluster;
#[doc(hidden)]
pub type StartDbClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartDbClusterInput {
    /// Consumes the builder and constructs an Operation<[`StartDBCluster`](crate::operation::StartDBCluster)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartDBCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartDbClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartDbClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartDbClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_db_cluster(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartDBCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartDBCluster",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartDbClusterInput`](crate::input::StartDbClusterInput)
    pub fn builder() -> crate::input::start_db_cluster_input::Builder {
        crate::input::start_db_cluster_input::Builder::default()
    }
}

/// See [`StopDbClusterInput`](crate::input::StopDbClusterInput)
pub mod stop_db_cluster_input {
    /// A builder for [`StopDbClusterInput`](crate::input::StopDbClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The DB cluster identifier of the Neptune DB cluster to be stopped.
        /// This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier of the Neptune DB cluster to be stopped.
        /// This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`StopDbClusterInput`](crate::input::StopDbClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopDbClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopDbClusterInput {
                db_cluster_identifier: self.db_cluster_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type StopDbClusterInputOperationOutputAlias = crate::operation::StopDBCluster;
#[doc(hidden)]
pub type StopDbClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopDbClusterInput {
    /// Consumes the builder and constructs an Operation<[`StopDBCluster`](crate::operation::StopDBCluster)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopDBCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopDbClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopDbClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopDbClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_stop_db_cluster(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopDBCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopDBCluster",
            "neptune",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopDbClusterInput`](crate::input::StopDbClusterInput)
    pub fn builder() -> crate::input::stop_db_cluster_input::Builder {
        crate::input::stop_db_cluster_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopDbClusterInput {
    /// <p>The DB cluster identifier of the Neptune DB cluster to be stopped.
    /// This parameter is stored as a lowercase string.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StopDbClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopDbClusterInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDbClusterInput {
    /// <p>The DB cluster identifier of the Neptune DB cluster to be started.
    /// This parameter is stored as a lowercase string.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartDbClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDbClusterInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreDbClusterToPointInTimeInput {
    /// <p>The name of the new DB cluster to be created.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
    /// </li>
    /// </ul>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The type of restore to be performed. You can specify one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>full-copy</code> - The new DB cluster is restored as a full copy of the source
    /// DB cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source
    /// DB cluster.</p>
    /// </li>
    /// </ul>
    /// <p>If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored
    /// as a full copy of the source DB cluster.</p>
    pub restore_type: std::option::Option<std::string::String>,
    /// <p>The identifier of the source DB cluster from which to restore.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing DBCluster.</p>
    /// </li>
    /// </ul>
    pub source_db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The date and time to restore the DB cluster to.</p>
    /// <p>Valid Values: Value must be a time in Universal Coordinated Time (UTC) format</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be before the latest restorable time for the DB instance</p>
    /// </li>
    /// <li>
    /// <p>Must be specified if <code>UseLatestRestorableTime</code> parameter is not
    /// provided</p>
    /// </li>
    /// <li>
    /// <p>Cannot be specified if <code>UseLatestRestorableTime</code> parameter is true</p>
    /// </li>
    /// <li>
    /// <p>Cannot be specified if <code>RestoreType</code> parameter is
    /// <code>copy-on-write</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>2015-03-07T23:45:00Z</code>
    /// </p>
    pub restore_to_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A value that is set to <code>true</code> to restore the DB cluster to the latest
    /// restorable backup time, and <code>false</code> otherwise.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    /// <p>Constraints: Cannot be specified if <code>RestoreToTime</code> parameter is
    /// provided.</p>
    pub use_latest_restorable_time: bool,
    /// <p>The port number on which the new DB cluster accepts connections.</p>
    /// <p>Constraints: Value must be <code>1150-65535</code>
    /// </p>
    /// <p>Default: The same port as the original DB cluster.</p>
    pub port: std::option::Option<i32>,
    /// <p>The DB subnet group name to use for the new DB cluster.</p>
    /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
    /// <p>Example: <code>mySubnetgroup</code>
    /// </p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>
    /// <i>(Not supported by Neptune)</i>
    /// </p>
    pub option_group_name: std::option::Option<std::string::String>,
    /// <p>A list of VPC security groups that the new DB cluster belongs to.</p>
    pub vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags to be applied to the restored DB cluster.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The Amazon KMS key identifier to use when restoring an encrypted DB cluster from an encrypted
    /// DB cluster.</p>
    /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
    /// you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used
    /// to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the
    /// KMS encryption key.</p>
    /// <p>You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is
    /// different than the KMS key used to encrypt the source DB cluster. The new DB cluster is
    /// encrypted with the KMS key identified by the <code>KmsKeyId</code> parameter.</p>
    /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following
    /// will occur:</p>
    /// <ul>
    /// <li>
    /// <p>If the DB cluster is encrypted, then the restored DB cluster is encrypted using the
    /// KMS key that was used to encrypt the source DB cluster.</p>
    /// </li>
    /// <li>
    /// <p>If the DB cluster is not encrypted, then the restored DB cluster is not
    /// encrypted.</p>
    /// </li>
    /// </ul>
    /// <p>If <code>DBClusterIdentifier</code> refers to a DB cluster that is not encrypted, then the
    /// restore request is rejected.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
    /// accounts, and otherwise false.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub enable_iam_database_authentication: std::option::Option<bool>,
    /// <p>The list of logs that the restored DB cluster is to export to CloudWatch Logs.</p>
    pub enable_cloudwatch_logs_exports: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the DB cluster parameter group to associate with the new DB cluster.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
    /// </li>
    /// </ul>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
    /// The database can't be deleted when deletion protection is enabled. By default,
    /// deletion protection is disabled.
    /// </p>
    pub deletion_protection: std::option::Option<bool>,
}
impl std::fmt::Debug for RestoreDbClusterToPointInTimeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreDbClusterToPointInTimeInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("restore_type", &self.restore_type);
        formatter.field(
            "source_db_cluster_identifier",
            &self.source_db_cluster_identifier,
        );
        formatter.field("restore_to_time", &self.restore_to_time);
        formatter.field(
            "use_latest_restorable_time",
            &self.use_latest_restorable_time,
        );
        formatter.field("port", &self.port);
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field("option_group_name", &self.option_group_name);
        formatter.field("vpc_security_group_ids", &self.vpc_security_group_ids);
        formatter.field("tags", &self.tags);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field(
            "enable_iam_database_authentication",
            &self.enable_iam_database_authentication,
        );
        formatter.field(
            "enable_cloudwatch_logs_exports",
            &self.enable_cloudwatch_logs_exports,
        );
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreDbClusterFromSnapshotInput {
    /// <p>Provides the list of EC2 Availability Zones that instances in the restored DB cluster can
    /// be created in.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This
    /// parameter isn't case-sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-snapshot-id</code>
    /// </p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The identifier for the DB snapshot or DB cluster snapshot to restore from.</p>
    /// <p>You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster
    /// snapshot. However, you can use only the ARN to specify a DB snapshot.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing Snapshot.</p>
    /// </li>
    /// </ul>
    pub snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>The database engine to use for the new DB cluster.</p>
    /// <p>Default: The same as source</p>
    /// <p>Constraint: Must be compatible with the engine of the source</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The version of the database engine to use for the new DB cluster.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The port number on which the new DB cluster accepts connections.</p>
    /// <p>Constraints: Value must be <code>1150-65535</code>
    /// </p>
    /// <p>Default: The same port as the original DB cluster.</p>
    pub port: std::option::Option<i32>,
    /// <p>The name of the DB subnet group to use for the new DB cluster.</p>
    /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
    /// <p>Example: <code>mySubnetgroup</code>
    /// </p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>Not supported.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>
    /// <i>(Not supported by Neptune)</i>
    /// </p>
    pub option_group_name: std::option::Option<std::string::String>,
    /// <p>A list of VPC security groups that the new DB cluster will belong to.</p>
    pub vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags to be assigned to the restored DB cluster.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The Amazon KMS key identifier to use when restoring an encrypted DB cluster from a DB
    /// snapshot or DB cluster snapshot.</p>
    /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
    /// you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used
    /// to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the
    /// KMS encryption key.</p>
    /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following
    /// will occur:</p>
    /// <ul>
    /// <li>
    /// <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is
    /// encrypted, then the restored DB cluster is encrypted using the KMS key that was used to
    /// encrypt the DB snapshot or DB cluster snapshot.</p>
    /// </li>
    /// <li>
    /// <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is not
    /// encrypted, then the restored DB cluster is not encrypted.</p>
    /// </li>
    /// </ul>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
    /// accounts, and otherwise false.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub enable_iam_database_authentication: std::option::Option<bool>,
    /// <p>The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs.</p>
    pub enable_cloudwatch_logs_exports: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the DB cluster parameter group to associate with the new DB cluster.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
    /// </li>
    /// </ul>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
    /// The database can't be deleted when deletion protection is enabled. By default,
    /// deletion protection is disabled.
    /// </p>
    pub deletion_protection: std::option::Option<bool>,
    /// <p>
    /// <i>If set to <code>true</code>, tags are copied to any snapshot of
    /// the restored DB cluster that is created.</i>
    /// </p>
    pub copy_tags_to_snapshot: std::option::Option<bool>,
}
impl std::fmt::Debug for RestoreDbClusterFromSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreDbClusterFromSnapshotInput");
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("snapshot_identifier", &self.snapshot_identifier);
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("port", &self.port);
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field("database_name", &self.database_name);
        formatter.field("option_group_name", &self.option_group_name);
        formatter.field("vpc_security_group_ids", &self.vpc_security_group_ids);
        formatter.field("tags", &self.tags);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field(
            "enable_iam_database_authentication",
            &self.enable_iam_database_authentication,
        );
        formatter.field(
            "enable_cloudwatch_logs_exports",
            &self.enable_cloudwatch_logs_exports,
        );
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.field("copy_tags_to_snapshot", &self.copy_tags_to_snapshot);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetDbParameterGroupInput {
    /// <p>The name of the DB parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the name of an existing DBParameterGroup.</p>
    /// </li>
    /// </ul>
    pub db_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether (<code>true</code>) or not (<code>false</code>) to reset all parameters
    /// in the DB parameter group to default values.</p>
    /// <p>Default: <code>true</code>
    /// </p>
    pub reset_all_parameters: bool,
    /// <p>To reset the entire DB parameter group, specify the <code>DBParameterGroup</code> name and
    /// <code>ResetAllParameters</code> parameters. To reset specific parameters, provide a list of
    /// the following: <code>ParameterName</code> and <code>ApplyMethod</code>. A maximum of 20
    /// parameters can be modified in a single request.</p>
    /// <p>Valid Values (for Apply method): <code>pending-reboot</code>
    /// </p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
}
impl std::fmt::Debug for ResetDbParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetDbParameterGroupInput");
        formatter.field("db_parameter_group_name", &self.db_parameter_group_name);
        formatter.field("reset_all_parameters", &self.reset_all_parameters);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetDbClusterParameterGroupInput {
    /// <p>The name of the DB cluster parameter group to reset.</p>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>A value that is set to <code>true</code> to reset all parameters in the DB cluster
    /// parameter group to their default values, and <code>false</code> otherwise. You can't use this
    /// parameter if there is a list of parameter names specified for the <code>Parameters</code>
    /// parameter.</p>
    pub reset_all_parameters: bool,
    /// <p>A list of parameter names in the DB cluster parameter group to reset to the default
    /// values. You can't use this parameter if the <code>ResetAllParameters</code> parameter is set
    /// to <code>true</code>.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
}
impl std::fmt::Debug for ResetDbClusterParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetDbClusterParameterGroupInput");
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.field("reset_all_parameters", &self.reset_all_parameters);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsFromResourceInput {
    /// <p>The Amazon Neptune resource that the tags are removed from. This value is an Amazon
    /// Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
    /// Amazon Resource Name (ARN)</a>.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>The tag key (name) of the tag to be removed.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for RemoveTagsFromResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsFromResourceInput");
        formatter.field("resource_name", &self.resource_name);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveSourceIdentifierFromSubscriptionInput {
    /// <p>The name of the event notification subscription you want to remove a source identifier
    /// from.</p>
    pub subscription_name: std::option::Option<std::string::String>,
    /// <p> The source identifier to be removed from the subscription, such as the <b>DB instance identifier</b> for a DB instance or the name of a security
    /// group.</p>
    pub source_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RemoveSourceIdentifierFromSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveSourceIdentifierFromSubscriptionInput");
        formatter.field("subscription_name", &self.subscription_name);
        formatter.field("source_identifier", &self.source_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveRoleFromDbClusterInput {
    /// <p>The name of the DB cluster to disassociate the IAM role from.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role to disassociate from the DB cluster, for
    /// example <code>arn:aws:iam::123456789012:role/NeptuneAccessRole</code>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The name of the feature for the DB cluster that the IAM role is to be disassociated from.
    /// For the list of supported feature names, see <a>DBEngineVersion</a>.</p>
    pub feature_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RemoveRoleFromDbClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveRoleFromDbClusterInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("feature_name", &self.feature_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebootDbInstanceInput {
    /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing DBInstance.</p>
    /// </li>
    /// </ul>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p> When <code>true</code>, the reboot is conducted through a MultiAZ failover.</p>
    /// <p>Constraint: You can't specify <code>true</code> if the instance is not configured for
    /// MultiAZ.</p>
    pub force_failover: std::option::Option<bool>,
}
impl std::fmt::Debug for RebootDbInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebootDbInstanceInput");
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("force_failover", &self.force_failover);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PromoteReadReplicaDbClusterInput {
    /// <p>Not supported.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PromoteReadReplicaDbClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PromoteReadReplicaDbClusterInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyEventSubscriptionInput {
    /// <p>The name of the event notification subscription.</p>
    pub subscription_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is
    /// created by Amazon SNS when you create a topic and subscribe to it.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The type of source that is generating the events. For example, if you want to be notified
    /// of events generated by a DB instance, you would set this parameter to db-instance. if this
    /// value is not specified, all events are returned.</p>
    /// <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p> A list of event categories for a SourceType that you want to subscribe to. You can see a
    /// list of the categories for a given SourceType
    ///
    /// by using the <b>DescribeEventCategories</b> action.</p>
    pub event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A Boolean value; set to <b>true</b> to activate the
    /// subscription.</p>
    pub enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for ModifyEventSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyEventSubscriptionInput");
        formatter.field("subscription_name", &self.subscription_name);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("source_type", &self.source_type);
        formatter.field("event_categories", &self.event_categories);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbSubnetGroupInput {
    /// <p>The name for the DB subnet group. This value is stored as a lowercase string. You can't
    /// modify the default subnet group.</p>
    /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
    /// <p>Example: <code>mySubnetgroup</code>
    /// </p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>The description for the DB subnet group.</p>
    pub db_subnet_group_description: std::option::Option<std::string::String>,
    /// <p>The EC2 subnet IDs for the DB subnet group.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ModifyDbSubnetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbSubnetGroupInput");
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field(
            "db_subnet_group_description",
            &self.db_subnet_group_description,
        );
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbParameterGroupInput {
    /// <p>The name of the DB parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If supplied, must match the name of an existing DBParameterGroup.</p>
    /// </li>
    /// </ul>
    pub db_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>An array of parameter names, values, and the apply method for the parameter update. At
    /// least one parameter name, value, and apply method must be supplied; subsequent arguments are
    /// optional. A maximum of 20 parameters can be modified in a single request.</p>
    /// <p>Valid Values (for the application method): <code>immediate | pending-reboot</code>
    /// </p>
    /// <note>
    /// <p>You can use the immediate value with dynamic parameters only. You can use the
    /// pending-reboot value for both dynamic and static parameters, and changes are applied when
    /// you reboot the DB instance without failover.</p>
    /// </note>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
}
impl std::fmt::Debug for ModifyDbParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbParameterGroupInput");
        formatter.field("db_parameter_group_name", &self.db_parameter_group_name);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbInstanceInput {
    /// <p>The DB instance identifier. This value is stored as a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing DBInstance.</p>
    /// </li>
    /// </ul>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>Not supported by Neptune.</p>
    pub allocated_storage: std::option::Option<i32>,
    /// <p>The new compute and memory capacity of the DB instance, for example,
    /// <code>db.m4.large</code>. Not all DB instance classes are available in all AWS
    /// Regions.</p>
    /// <p>If you modify the DB instance class, an outage occurs during the change. The change is
    /// applied during the next maintenance window, unless <code>ApplyImmediately</code> is specified
    /// as <code>true</code> for this request.</p>
    /// <p>Default: Uses existing setting</p>
    pub db_instance_class: std::option::Option<std::string::String>,
    /// <p>The new DB subnet group for the DB instance. You can use this parameter to move your DB
    /// instance to a different VPC.</p>
    /// <p>Changing the subnet group causes an outage during the change. The change is applied during
    /// the next maintenance window, unless you specify <code>true</code> for the
    /// <code>ApplyImmediately</code> parameter.</p>
    /// <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>
    /// <p>Example: <code>mySubnetGroup</code>
    /// </p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>A list of DB security groups to authorize on this DB instance. Changing this setting
    /// doesn't result in an outage and the change is asynchronously applied as soon as
    /// possible.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If supplied, must match existing DBSecurityGroups.</p>
    /// </li>
    /// </ul>
    pub db_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of EC2 VPC security groups to authorize on this DB instance. This change is
    /// asynchronously applied as soon as possible.</p>
    /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB
    /// cluster. For more information, see <a>ModifyDBCluster</a>.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If supplied, must match existing VpcSecurityGroupIds.</p>
    /// </li>
    /// </ul>
    pub vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies whether the modifications in this request and any pending modifications are
    /// asynchronously applied as soon as possible, regardless of the
    /// <code>PreferredMaintenanceWindow</code> setting for the DB instance.</p>
    /// <p> If this parameter is set to <code>false</code>, changes to the DB instance are applied
    /// during the next maintenance window. Some parameter changes can cause an outage and are applied
    /// on the next call to <a>RebootDBInstance</a>, or the next
    /// failure reboot.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub apply_immediately: bool,
    /// <p>Not supported by Neptune.</p>
    pub master_user_password: std::option::Option<std::string::String>,
    /// <p>The name of the DB parameter group to apply to the DB instance. Changing this setting
    /// doesn't result in an outage. The parameter group name itself is changed immediately, but the
    /// actual parameter changes are not applied until you reboot the instance without failover. The
    /// db instance will NOT be rebooted automatically and the parameter changes will NOT be applied
    /// during the next maintenance window.</p>
    /// <p>Default: Uses existing setting</p>
    /// <p>Constraints: The DB parameter group must be in the same DB parameter group family as this
    /// DB instance.</p>
    pub db_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster.
    /// For more information, see <a>ModifyDBCluster</a>.</p>
    /// <p>Default: Uses existing setting</p>
    pub backup_retention_period: std::option::Option<i32>,
    /// <p> The daily time range during which automated backups are created if automated backups are
    /// enabled.</p>
    /// <p>Not applicable. The daily time range for creating automated backups is managed by the DB
    /// cluster. For more information, see <a>ModifyDBCluster</a>.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be in the format hh24:mi-hh24:mi</p>
    /// </li>
    /// <li>
    /// <p>Must be in Universal Time Coordinated (UTC)</p>
    /// </li>
    /// <li>
    /// <p>Must not conflict with the preferred maintenance window</p>
    /// </li>
    /// <li>
    /// <p>Must be at least 30 minutes</p>
    /// </li>
    /// </ul>
    pub preferred_backup_window: std::option::Option<std::string::String>,
    /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might
    /// result in an outage. Changing this parameter doesn't result in an outage, except in the
    /// following situation, and the change is asynchronously applied as soon as possible. If there
    /// are pending actions that cause a reboot, and the maintenance window is changed to include the
    /// current time, then changing this parameter will cause a reboot of the DB instance. If moving
    /// this window to the current time, there must be at least 30 minutes between the current time
    /// and end of the window to ensure pending changes are applied.</p>
    /// <p>Default: Uses existing setting</p>
    /// <p>Format: ddd:hh24:mi-ddd:hh24:mi</p>
    /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
    /// <p>Constraints: Must be at least 30 minutes</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter doesn't
    /// result in an outage and the change is applied during the next maintenance window unless the
    /// <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request.</p>
    pub multi_az: std::option::Option<bool>,
    /// <p>The version number of the database engine to upgrade to. Currently, setting this
    /// parameter has no effect. To upgrade your database engine to the most recent release,
    /// use the <a>ApplyPendingMaintenanceAction</a> API.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Indicates that major version upgrades are allowed. Changing this parameter doesn't result
    /// in an outage and the change is asynchronously applied as soon as possible.</p>
    pub allow_major_version_upgrade: bool,
    /// <p> Indicates that minor version upgrades are applied automatically to the DB instance during
    /// the maintenance window. Changing this parameter doesn't result in an outage except in the
    /// following case and the change is asynchronously applied as soon as possible. An outage will
    /// result if this parameter is set to <code>true</code> during the maintenance window, and a
    /// newer minor version is available, and Neptune has enabled auto patching for that engine
    /// version.</p>
    pub auto_minor_version_upgrade: std::option::Option<bool>,
    /// <p>Not supported by Neptune.</p>
    pub license_model: std::option::Option<std::string::String>,
    /// <p>The new Provisioned IOPS (I/O operations per second) value for the instance.</p>
    /// <p>Changing this setting doesn't result in an outage and the change is applied during the
    /// next maintenance window unless the <code>ApplyImmediately</code> parameter is set to
    /// <code>true</code> for this request.</p>
    /// <p>Default: Uses existing setting</p>
    pub iops: std::option::Option<i32>,
    /// <p>
    /// <i>(Not supported by Neptune)</i>
    /// </p>
    pub option_group_name: std::option::Option<std::string::String>,
    /// <p> The new DB instance identifier for the DB instance when renaming a DB instance. When you
    /// change the DB instance identifier, an instance reboot will occur immediately if you set
    /// <code>Apply Immediately</code> to true, or will occur during the next maintenance window if
    /// <code>Apply Immediately</code> to false. This value is stored as a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>mydbinstance</code>
    /// </p>
    pub new_db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>Not supported.</p>
    pub storage_type: std::option::Option<std::string::String>,
    /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
    pub tde_credential_arn: std::option::Option<std::string::String>,
    /// <p>The password for the given ARN from the key store in order to access the device.</p>
    pub tde_credential_password: std::option::Option<std::string::String>,
    /// <p>Indicates the certificate that needs to be associated with the instance.</p>
    pub ca_certificate_identifier: std::option::Option<std::string::String>,
    /// <p>Not supported.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise
    /// false. The default is false.</p>
    pub copy_tags_to_snapshot: std::option::Option<bool>,
    /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected
    /// for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default
    /// is 0.</p>
    /// <p>If <code>MonitoringRoleArn</code> is specified, then you must also set
    /// <code>MonitoringInterval</code> to a value other than 0.</p>
    /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
    /// </p>
    pub monitoring_interval: std::option::Option<i32>,
    /// <p>The port number on which the database accepts connections.</p>
    /// <p>The value of the <code>DBPortNumber</code> parameter must not match any of the port values
    /// specified for options in the option group for the DB instance.</p>
    /// <p>Your database will restart when you change the <code>DBPortNumber</code> value regardless
    /// of the value of the <code>ApplyImmediately</code> parameter.</p>
    /// <p> Default: <code>8182</code>
    /// </p>
    pub db_port_number: std::option::Option<i32>,
    /// <p>This flag should no longer be used.</p>
    pub publicly_accessible: std::option::Option<bool>,
    /// <p>The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to
    /// Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>
    /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
    /// <code>MonitoringRoleArn</code> value.</p>
    pub monitoring_role_arn: std::option::Option<std::string::String>,
    /// <p>Not supported</p>
    pub domain_iam_role_name: std::option::Option<std::string::String>,
    /// <p>A value that specifies the order in which a Read Replica is promoted to the primary
    /// instance after a failure of the existing primary instance.</p>
    /// <p>Default: 1</p>
    /// <p>Valid Values: 0 - 15</p>
    pub promotion_tier: std::option::Option<i32>,
    /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
    /// accounts, and otherwise false.</p>
    /// <p>You can enable IAM database authentication for the following database engines</p>
    /// <p>Not applicable. Mapping Amazon IAM accounts to database accounts is managed by the DB
    /// cluster. For more information, see <a>ModifyDBCluster</a>.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub enable_iam_database_authentication: std::option::Option<bool>,
    /// <p>
    /// <i>(Not supported by Neptune)</i>
    /// </p>
    pub enable_performance_insights: std::option::Option<bool>,
    /// <p>
    /// <i>(Not supported by Neptune)</i>
    /// </p>
    pub performance_insights_kms_key_id: std::option::Option<std::string::String>,
    /// <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs
    /// for a specific DB instance or DB cluster.</p>
    pub cloudwatch_logs_export_configuration:
        std::option::Option<crate::model::CloudwatchLogsExportConfiguration>,
    /// <p>A value that indicates whether the DB instance has deletion protection enabled.
    /// The database can't be deleted when deletion protection is enabled. By default,
    /// deletion protection is disabled.  See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting
    /// a DB Instance</a>.</p>
    pub deletion_protection: std::option::Option<bool>,
}
impl std::fmt::Debug for ModifyDbInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbInstanceInput");
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("allocated_storage", &self.allocated_storage);
        formatter.field("db_instance_class", &self.db_instance_class);
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field("db_security_groups", &self.db_security_groups);
        formatter.field("vpc_security_group_ids", &self.vpc_security_group_ids);
        formatter.field("apply_immediately", &self.apply_immediately);
        formatter.field("master_user_password", &self.master_user_password);
        formatter.field("db_parameter_group_name", &self.db_parameter_group_name);
        formatter.field("backup_retention_period", &self.backup_retention_period);
        formatter.field("preferred_backup_window", &self.preferred_backup_window);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field("multi_az", &self.multi_az);
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "allow_major_version_upgrade",
            &self.allow_major_version_upgrade,
        );
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.field("license_model", &self.license_model);
        formatter.field("iops", &self.iops);
        formatter.field("option_group_name", &self.option_group_name);
        formatter.field(
            "new_db_instance_identifier",
            &self.new_db_instance_identifier,
        );
        formatter.field("storage_type", &self.storage_type);
        formatter.field("tde_credential_arn", &self.tde_credential_arn);
        formatter.field("tde_credential_password", &self.tde_credential_password);
        formatter.field("ca_certificate_identifier", &self.ca_certificate_identifier);
        formatter.field("domain", &self.domain);
        formatter.field("copy_tags_to_snapshot", &self.copy_tags_to_snapshot);
        formatter.field("monitoring_interval", &self.monitoring_interval);
        formatter.field("db_port_number", &self.db_port_number);
        formatter.field("publicly_accessible", &self.publicly_accessible);
        formatter.field("monitoring_role_arn", &self.monitoring_role_arn);
        formatter.field("domain_iam_role_name", &self.domain_iam_role_name);
        formatter.field("promotion_tier", &self.promotion_tier);
        formatter.field(
            "enable_iam_database_authentication",
            &self.enable_iam_database_authentication,
        );
        formatter.field(
            "enable_performance_insights",
            &self.enable_performance_insights,
        );
        formatter.field(
            "performance_insights_kms_key_id",
            &self.performance_insights_kms_key_id,
        );
        formatter.field(
            "cloudwatch_logs_export_configuration",
            &self.cloudwatch_logs_export_configuration,
        );
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbClusterSnapshotAttributeInput {
    /// <p>The identifier for the DB cluster snapshot to modify the attributes for.</p>
    pub db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>The name of the DB cluster snapshot attribute to modify.</p>
    /// <p>To manage authorization for other Amazon accounts to copy or restore a manual DB cluster
    /// snapshot, set this value to <code>restore</code>.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>A list of DB cluster snapshot attributes to add to the attribute specified by
    /// <code>AttributeName</code>.</p>
    /// <p>To authorize other Amazon accounts to copy or restore a manual DB cluster snapshot, set this
    /// list to include one or more Amazon account IDs, or <code>all</code> to make the manual DB cluster
    /// snapshot restorable by any Amazon account. Do not add the <code>all</code> value for any manual
    /// DB cluster snapshots that contain private information that you don't want available to all AWS
    /// accounts.</p>
    pub values_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of DB cluster snapshot attributes to remove from the attribute specified by
    /// <code>AttributeName</code>.</p>
    /// <p>To remove authorization for other Amazon accounts to copy or restore a manual DB cluster
    /// snapshot, set this list to include one or more Amazon account identifiers, or <code>all</code> to
    /// remove authorization for any Amazon account to copy or restore the DB cluster snapshot. If you
    /// specify <code>all</code>, an Amazon account whose account ID is explicitly added to the
    /// <code>restore</code> attribute can still copy or restore a manual DB cluster snapshot.</p>
    pub values_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ModifyDbClusterSnapshotAttributeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbClusterSnapshotAttributeInput");
        formatter.field(
            "db_cluster_snapshot_identifier",
            &self.db_cluster_snapshot_identifier,
        );
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("values_to_add", &self.values_to_add);
        formatter.field("values_to_remove", &self.values_to_remove);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbClusterParameterGroupInput {
    /// <p>The name of the DB cluster parameter group to modify.</p>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>A list of parameters in the DB cluster parameter group to modify.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
}
impl std::fmt::Debug for ModifyDbClusterParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbClusterParameterGroupInput");
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbClusterEndpointInput {
    /// <p>The identifier of the endpoint to modify. This parameter is stored as a lowercase string.</p>
    pub db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
    /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    pub endpoint_type: std::option::Option<std::string::String>,
    /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    pub static_members: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
    /// All other eligible instances are reachable through the custom endpoint.
    /// Only relevant if the list of static members is empty.</p>
    pub excluded_members: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ModifyDbClusterEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbClusterEndpointInput");
        formatter.field(
            "db_cluster_endpoint_identifier",
            &self.db_cluster_endpoint_identifier,
        );
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("static_members", &self.static_members);
        formatter.field("excluded_members", &self.excluded_members);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbClusterInput {
    /// <p>The DB cluster identifier for the cluster being modified. This parameter is not
    /// case-sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing DBCluster.</p>
    /// </li>
    /// </ul>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is
    /// stored as a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster2</code>
    /// </p>
    pub new_db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>A value that specifies whether the modifications in this request and any pending
    /// modifications are asynchronously applied as soon as possible, regardless of the
    /// <code>PreferredMaintenanceWindow</code> setting for the DB cluster. If this parameter is set
    /// to <code>false</code>, changes to the DB cluster are applied during the next maintenance
    /// window.</p>
    /// <p>The <code>ApplyImmediately</code> parameter only affects <code>NewDBClusterIdentifier</code>
    /// values. If you set the <code>ApplyImmediately</code> parameter value to false, then changes to
    /// <code>NewDBClusterIdentifier</code> values are applied during the next maintenance window.
    /// All other changes are applied immediately, regardless of the value of the
    /// <code>ApplyImmediately</code> parameter.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub apply_immediately: bool,
    /// <p>The number of days for which automated backups are retained. You must specify a minimum
    /// value of 1.</p>
    /// <p>Default: 1</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be a value from 1 to 35</p>
    /// </li>
    /// </ul>
    pub backup_retention_period: std::option::Option<i32>,
    /// <p>The name of the DB cluster parameter group to use for the DB cluster.</p>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>A list of VPC security groups that the DB cluster will belong to.</p>
    pub vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The port number on which the DB cluster accepts connections.</p>
    /// <p>Constraints: Value must be <code>1150-65535</code>
    /// </p>
    /// <p>Default: The same port as the original DB cluster.</p>
    pub port: std::option::Option<i32>,
    /// <p>Not supported by Neptune.</p>
    pub master_user_password: std::option::Option<std::string::String>,
    /// <p>
    /// <i>Not supported by Neptune.</i>
    /// </p>
    pub option_group_name: std::option::Option<std::string::String>,
    /// <p>The daily time range during which automated backups are created if automated backups are
    /// enabled, using the <code>BackupRetentionPeriod</code> parameter.</p>
    /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
    /// Amazon Region.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
    /// </li>
    /// <li>
    /// <p>Must be in Universal Coordinated Time (UTC).</p>
    /// </li>
    /// <li>
    /// <p>Must not conflict with the preferred maintenance window.</p>
    /// </li>
    /// <li>
    /// <p>Must be at least 30 minutes.</p>
    /// </li>
    /// </ul>
    pub preferred_backup_window: std::option::Option<std::string::String>,
    /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated
    /// Time (UTC).</p>
    /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
    /// </p>
    /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
    /// Amazon Region, occurring on a random day of the
    /// week.</p>
    /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
    /// <p>Constraints: Minimum 30-minute window.</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database
    /// accounts, and otherwise false.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub enable_iam_database_authentication: std::option::Option<bool>,
    /// <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs
    /// for a specific DB cluster.</p>
    pub cloudwatch_logs_export_configuration:
        std::option::Option<crate::model::CloudwatchLogsExportConfiguration>,
    /// <p>The version number of the database engine to which you want to upgrade. Changing this
    /// parameter results in an outage. The change is applied during the next maintenance window
    /// unless the <code>ApplyImmediately</code> parameter is set to true.</p>
    /// <p>For a list of valid engine versions, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/engine-releases.html">Engine Releases for Amazon
    /// Neptune</a>, or call <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-other-apis.html#DescribeDBEngineVersions">DescribeDBEngineVersions</a>.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
    /// The database can't be deleted when deletion protection is enabled. By default,
    /// deletion protection is disabled.</p>
    pub deletion_protection: std::option::Option<bool>,
    /// <p>
    /// <i>If set to <code>true</code>, tags are copied to any snapshot of
    /// the DB cluster that is created.</i>
    /// </p>
    pub copy_tags_to_snapshot: std::option::Option<bool>,
}
impl std::fmt::Debug for ModifyDbClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbClusterInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("new_db_cluster_identifier", &self.new_db_cluster_identifier);
        formatter.field("apply_immediately", &self.apply_immediately);
        formatter.field("backup_retention_period", &self.backup_retention_period);
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.field("vpc_security_group_ids", &self.vpc_security_group_ids);
        formatter.field("port", &self.port);
        formatter.field("master_user_password", &self.master_user_password);
        formatter.field("option_group_name", &self.option_group_name);
        formatter.field("preferred_backup_window", &self.preferred_backup_window);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field(
            "enable_iam_database_authentication",
            &self.enable_iam_database_authentication,
        );
        formatter.field(
            "cloudwatch_logs_export_configuration",
            &self.cloudwatch_logs_export_configuration,
        );
        formatter.field("engine_version", &self.engine_version);
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.field("copy_tags_to_snapshot", &self.copy_tags_to_snapshot);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Neptune resource with tags to be listed. This value is an Amazon Resource Name
    /// (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
    /// Amazon Resource Name (ARN)</a>.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_name", &self.resource_name);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailoverDbClusterInput {
    /// <p>A DB cluster identifier to force a failover for. This parameter is not
    /// case-sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing DBCluster.</p>
    /// </li>
    /// </ul>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The name of the instance to promote to the primary instance.</p>
    /// <p>You must specify the instance identifier for an Read Replica in the DB cluster. For
    /// example, <code>mydbcluster-replica1</code>.</p>
    pub target_db_instance_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FailoverDbClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailoverDbClusterInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field(
            "target_db_instance_identifier",
            &self.target_db_instance_identifier,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeValidDbInstanceModificationsInput {
    /// <p>The customer identifier or the ARN of your DB instance.</p>
    pub db_instance_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeValidDbInstanceModificationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeValidDbInstanceModificationsInput");
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePendingMaintenanceActionsInput {
    /// <p>The ARN of a resource to return pending maintenance actions for.</p>
    pub resource_identifier: std::option::Option<std::string::String>,
    /// <p>A filter that specifies one or more resources to return pending maintenance actions
    /// for.</p>
    /// <p>Supported filters:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon
    /// Resource Names (ARNs). The results list will only include pending maintenance actions for
    /// the DB clusters identified by these ARNs.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance ARNs.
    /// The results list will only include pending maintenance actions for the DB instances
    /// identified by these ARNs.</p>
    /// </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> An optional pagination token provided by a previous
    /// <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the
    /// response includes only records beyond the marker, up to a number of records specified by
    /// <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the
    /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
    /// response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
}
impl std::fmt::Debug for DescribePendingMaintenanceActionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePendingMaintenanceActionsInput");
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field("filters", &self.filters);
        formatter.field("marker", &self.marker);
        formatter.field("max_records", &self.max_records);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrderableDbInstanceOptionsInput {
    /// <p>The name of the engine to retrieve DB instance options for.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The engine version filter value. Specify this parameter to show only the available
    /// offerings matching the specified engine version.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The DB instance class filter value. Specify this parameter to show only the available
    /// offerings matching the specified DB instance class.</p>
    pub db_instance_class: std::option::Option<std::string::String>,
    /// <p>The license model filter value. Specify this parameter to show only the available
    /// offerings matching the specified license model.</p>
    pub license_model: std::option::Option<std::string::String>,
    /// <p>The VPC filter value. Specify this parameter to show only the available VPC or non-VPC
    /// offerings.</p>
    pub vpc: std::option::Option<bool>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than the
    /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
    /// response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions
    /// request. If this parameter is specified, the response includes only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code> .</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeOrderableDbInstanceOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrderableDbInstanceOptionsInput");
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("db_instance_class", &self.db_instance_class);
        formatter.field("license_model", &self.license_model);
        formatter.field("vpc", &self.vpc);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventSubscriptionsInput {
    /// <p>The name of the event notification subscription you want to describe.</p>
    pub subscription_name: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than the
    /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
    /// response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions
    /// request. If this parameter is specified, the response includes only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code> .</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeEventSubscriptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventSubscriptionsInput");
        formatter.field("subscription_name", &self.subscription_name);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventsInput {
    /// <p>The identifier of the event source for which events are returned. If not specified, then
    /// all sources are included in the response.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If SourceIdentifier is supplied, SourceType must also be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is <code>DBInstance</code>, then a
    /// <code>DBInstanceIdentifier</code> must be supplied.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is <code>DBSecurityGroup</code>, a <code>DBSecurityGroupName</code>
    /// must be supplied.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is <code>DBParameterGroup</code>, a
    /// <code>DBParameterGroupName</code> must be supplied.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is <code>DBSnapshot</code>, a <code>DBSnapshotIdentifier</code>
    /// must be supplied.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    pub source_identifier: std::option::Option<std::string::String>,
    /// <p>The event source to retrieve events for. If no value is specified, all events are
    /// returned.</p>
    pub source_type: std::option::Option<crate::model::SourceType>,
    /// <p> The beginning of the time interval to retrieve events for, specified in ISO 8601 format.
    /// For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
    /// </p>
    /// <p>Example: 2009-07-08T18:00Z</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The end of the time interval for which to retrieve events, specified in ISO 8601 format.
    /// For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
    /// </p>
    /// <p>Example: 2009-07-08T18:00Z</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The number of minutes to retrieve events for.</p>
    /// <p>Default: 60</p>
    pub duration: std::option::Option<i32>,
    /// <p>A list of event categories that trigger notifications for a event notification
    /// subscription.</p>
    pub event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than the
    /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
    /// response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous DescribeEvents request. If this
    /// parameter is specified, the response includes only records beyond the marker, up to the value
    /// specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventsInput");
        formatter.field("source_identifier", &self.source_identifier);
        formatter.field("source_type", &self.source_type);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("duration", &self.duration);
        formatter.field("event_categories", &self.event_categories);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventCategoriesInput {
    /// <p>The type of source that is generating the events.</p>
    /// <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl std::fmt::Debug for DescribeEventCategoriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventCategoriesInput");
        formatter.field("source_type", &self.source_type);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEngineDefaultParametersInput {
    /// <p>The name of the DB parameter group family.</p>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>Not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than the
    /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
    /// response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous
    /// <code>DescribeEngineDefaultParameters</code> request. If this parameter is specified, the
    /// response includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeEngineDefaultParametersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEngineDefaultParametersInput");
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEngineDefaultClusterParametersInput {
    /// <p>The name of the DB cluster parameter group family to return engine parameter information
    /// for.</p>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than the
    /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
    /// response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous
    /// <code>DescribeEngineDefaultClusterParameters</code> request. If this parameter is specified,
    /// the response includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeEngineDefaultClusterParametersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEngineDefaultClusterParametersInput");
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbSubnetGroupsInput {
    /// <p>The name of the DB subnet group to return details for.</p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than the
    /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
    /// response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous DescribeDBSubnetGroups request. If
    /// this parameter is specified, the response includes only records beyond the marker, up to the
    /// value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDbSubnetGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbSubnetGroupsInput");
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbParametersInput {
    /// <p>The name of a specific DB parameter group to return details for.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If supplied, must match the name of an existing DBParameterGroup.</p>
    /// </li>
    /// </ul>
    pub db_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The parameter types to return.</p>
    /// <p>Default: All parameter types returned</p>
    /// <p>Valid Values: <code>user | system | engine-default</code>
    /// </p>
    pub source: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The maximum number of records to include in the response. If more records exist than the
    /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
    /// response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous <code>DescribeDBParameters</code>
    /// request. If this parameter is specified, the response includes only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDbParametersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbParametersInput");
        formatter.field("db_parameter_group_name", &self.db_parameter_group_name);
        formatter.field("source", &self.source);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbParameterGroupsInput {
    /// <p>The name of a specific DB parameter group to return details for.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
    /// </li>
    /// </ul>
    pub db_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The maximum number of records to include in the response. If more records exist than the
    /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
    /// response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous
    /// <code>DescribeDBParameterGroups</code> request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDbParameterGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbParameterGroupsInput");
        formatter.field("db_parameter_group_name", &self.db_parameter_group_name);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbInstancesInput {
    /// <p>The user-supplied instance identifier. If this parameter is specified, information from
    /// only the specific DB instance is returned. This parameter isn't case-sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If supplied, must match the identifier of an existing DBInstance.</p>
    /// </li>
    /// </ul>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>A filter that specifies one or more DB instances to describe.</p>
    /// <p>Supported filters:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon
    /// Resource Names (ARNs). The results list will only include information about the DB
    /// instances associated with the DB clusters identified by these ARNs.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>engine</code> - Accepts an engine name (such as <code>neptune</code>),
    /// and restricts the results list to DB instances created by that engine.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>For example, to invoke this API from the Amazon CLI and filter so that only
    /// Neptune DB instances are returned, you could use the following command:</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than the
    /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
    /// response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous <code>DescribeDBInstances</code>
    /// request. If this parameter is specified, the response includes only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDbInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbInstancesInput");
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbEngineVersionsInput {
    /// <p>The database engine to return.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The database engine version to return.</p>
    /// <p>Example: <code>5.1.49</code>
    /// </p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The name of a specific DB parameter group family to return details for.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If supplied, must match an existing DBParameterGroupFamily.</p>
    /// </li>
    /// </ul>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>Not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more than the
    /// <code>MaxRecords</code> value is available, a pagination token called a marker is included in
    /// the response so that the following results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is
    /// specified, the response includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Indicates that only the default version of the specified engine or engine and major
    /// version combination is returned.</p>
    pub default_only: bool,
    /// <p>If this parameter is specified and the requested engine supports the
    /// <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response
    /// includes a list of supported character sets for each engine version.</p>
    pub list_supported_character_sets: std::option::Option<bool>,
    /// <p>If this parameter is specified and the requested engine supports the <code>TimeZone</code>
    /// parameter for <code>CreateDBInstance</code>, the response includes a list of supported time
    /// zones for each engine version.</p>
    pub list_supported_timezones: std::option::Option<bool>,
}
impl std::fmt::Debug for DescribeDbEngineVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbEngineVersionsInput");
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.field("default_only", &self.default_only);
        formatter.field(
            "list_supported_character_sets",
            &self.list_supported_character_sets,
        );
        formatter.field("list_supported_timezones", &self.list_supported_timezones);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterSnapshotsInput {
    /// <p>The ID of the DB cluster to retrieve the list of DB cluster snapshots for. This parameter
    /// can't be used in conjunction with the <code>DBClusterSnapshotIdentifier</code> parameter. This
    /// parameter is not case-sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If supplied, must match the identifier of an existing DBCluster.</p>
    /// </li>
    /// </ul>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>A specific DB cluster snapshot identifier to describe. This parameter can't be used in
    /// conjunction with the <code>DBClusterIdentifier</code> parameter. This value is stored as a
    /// lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If supplied, must match the identifier of an existing DBClusterSnapshot.</p>
    /// </li>
    /// <li>
    /// <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code>
    /// parameter must also be specified.</p>
    /// </li>
    /// </ul>
    pub db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>The type of DB cluster snapshots to be returned. You can specify one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>automated</code> - Return all DB cluster snapshots that have been automatically
    /// taken by Amazon Neptune for my Amazon account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>manual</code> - Return all DB cluster snapshots that have been taken by my AWS
    /// account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>shared</code> - Return all manual DB cluster snapshots that have been shared to
    /// my Amazon account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>public</code> - Return all DB cluster snapshots that have been marked as
    /// public.</p>
    /// </li>
    /// </ul>
    /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual DB
    /// cluster snapshots are returned. You can include shared DB cluster snapshots with these results
    /// by setting the <code>IncludeShared</code> parameter to <code>true</code>. You can include
    /// public DB cluster snapshots with these results by setting the <code>IncludePublic</code>
    /// parameter to <code>true</code>.</p>
    /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for
    /// <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The
    /// <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to
    /// <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when
    /// <code>SnapshotType</code> is set to <code>public</code>.</p>
    pub snapshot_type: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The maximum number of records to include in the response. If more records exist than the
    /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
    /// response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous
    /// <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>True to include shared manual DB cluster snapshots from other Amazon accounts that this AWS
    /// account has been given permission to copy or restore, and otherwise false. The default is
    /// <code>false</code>.</p>
    /// <p>You can give an Amazon account permission to restore a manual DB cluster snapshot from
    /// another Amazon account by the <a>ModifyDBClusterSnapshotAttribute</a> API
    /// action.</p>
    pub include_shared: bool,
    /// <p>True to include manual DB cluster snapshots that are public and can be copied or restored
    /// by any Amazon account, and otherwise false. The default is <code>false</code>. The default is
    /// false.</p>
    /// <p>You can share a manual DB cluster snapshot as public by using the <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>
    pub include_public: bool,
}
impl std::fmt::Debug for DescribeDbClusterSnapshotsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterSnapshotsInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field(
            "db_cluster_snapshot_identifier",
            &self.db_cluster_snapshot_identifier,
        );
        formatter.field("snapshot_type", &self.snapshot_type);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.field("include_shared", &self.include_shared);
        formatter.field("include_public", &self.include_public);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterSnapshotAttributesInput {
    /// <p>The identifier for the DB cluster snapshot to describe the attributes for.</p>
    pub db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDbClusterSnapshotAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterSnapshotAttributesInput");
        formatter.field(
            "db_cluster_snapshot_identifier",
            &self.db_cluster_snapshot_identifier,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClustersInput {
    /// <p>The user-supplied DB cluster identifier. If this parameter is specified, information from
    /// only the specific DB cluster is returned. This parameter isn't case-sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If supplied, must match an existing DBClusterIdentifier.</p>
    /// </li>
    /// </ul>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>A filter that specifies one or more DB clusters to describe.</p>
    /// <p>Supported filters:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon
    /// Resource Names (ARNs). The results list will only include information about the DB
    /// clusters identified by these ARNs.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>engine</code> - Accepts an engine name (such as <code>neptune</code>),
    /// and restricts the results list to DB clusters created by that engine.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>For example, to invoke this API from the Amazon CLI and filter so that only
    /// Neptune DB clusters are returned, you could use the following command:</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The maximum number of records to include in the response. If more records exist than the
    /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
    /// response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous <a>DescribeDBClusters</a>
    /// request. If this parameter is specified, the response includes only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDbClustersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClustersInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterParametersInput {
    /// <p>The name of a specific DB cluster parameter group to return parameter details for.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
    /// </li>
    /// </ul>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    /// <p> A value that indicates to return only parameters for a specific source. Parameter sources
    /// can be <code>engine</code>, <code>service</code>, or <code>customer</code>.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than the
    /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
    /// response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous
    /// <code>DescribeDBClusterParameters</code> request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDbClusterParametersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterParametersInput");
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.field("source", &self.source);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterParameterGroupsInput {
    /// <p>The name of a specific DB cluster parameter group to return details for.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
    /// </li>
    /// </ul>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than the
    /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
    /// response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous
    /// <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the
    /// response includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDbClusterParameterGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterParameterGroupsInput");
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterEndpointsInput {
    /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
    /// stored as a lowercase string.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The identifier of the endpoint to describe. This parameter is stored as a lowercase string.</p>
    pub db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
    /// <p>A set of name-value pairs that define which endpoints to include in the output.
    /// The filters are specified as name-value pairs, in the format
    /// <code>Name=<i>endpoint_type</i>,Values=<i>endpoint_type1</i>,<i>endpoint_type2</i>,...</code>.
    /// <code>Name</code> can be one of: <code>db-cluster-endpoint-type</code>, <code>db-cluster-endpoint-custom-type</code>, <code>db-cluster-endpoint-id</code>, <code>db-cluster-endpoint-status</code>.
    /// <code>Values</code> for the <code> db-cluster-endpoint-type</code> filter can be one or more of: <code>reader</code>, <code>writer</code>, <code>custom</code>.
    /// <code>Values</code> for the <code>db-cluster-endpoint-custom-type</code> filter can be one or more of: <code>reader</code>, <code>any</code>.
    /// <code>Values</code> for the <code>db-cluster-endpoint-status</code> filter can be one or more of: <code>available</code>, <code>creating</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>.
    /// </p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The maximum number of records to include in the response.
    /// If more records exist than the specified <code>MaxRecords</code> value,
    /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
    /// </p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous
    /// <code>DescribeDBClusterEndpoints</code> request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDbClusterEndpointsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterEndpointsInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field(
            "db_cluster_endpoint_identifier",
            &self.db_cluster_endpoint_identifier,
        );
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventSubscriptionInput {
    /// <p>The name of the event notification subscription you want to delete.</p>
    pub subscription_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteEventSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventSubscriptionInput");
        formatter.field("subscription_name", &self.subscription_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbSubnetGroupInput {
    /// <p>The name of the database subnet group to delete.</p>
    /// <note>
    /// <p>You can't delete the default subnet group.</p>
    /// </note>
    /// <p>Constraints:</p>
    /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
    /// <p>Example: <code>mySubnetgroup</code>
    /// </p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDbSubnetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbSubnetGroupInput");
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbParameterGroupInput {
    /// <p>The name of the DB parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be the name of an existing DB parameter group</p>
    /// </li>
    /// <li>
    /// <p>You can't delete a default DB parameter group</p>
    /// </li>
    /// <li>
    /// <p>Cannot be associated with any DB instances</p>
    /// </li>
    /// </ul>
    pub db_parameter_group_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDbParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbParameterGroupInput");
        formatter.field("db_parameter_group_name", &self.db_parameter_group_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbInstanceInput {
    /// <p>The DB instance identifier for the DB instance to be deleted. This parameter isn't
    /// case-sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the name of an existing DB instance.</p>
    /// </li>
    /// </ul>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p> Determines whether a final DB snapshot is created before the DB instance is deleted. If
    /// <code>true</code> is specified, no DBSnapshot is created. If <code>false</code> is specified,
    /// a DB snapshot is created before the DB instance is deleted.</p>
    /// <p>Note that when a DB instance is in a failure state and has a status of 'failed',
    /// 'incompatible-restore', or 'incompatible-network', it can only be deleted when the
    /// SkipFinalSnapshot parameter is set to "true".</p>
    /// <p>Specify <code>true</code> when deleting a Read Replica.</p>
    /// <note>
    /// <p>The FinalDBSnapshotIdentifier parameter must be specified if SkipFinalSnapshot is
    /// <code>false</code>.</p>
    /// </note>
    /// <p>Default: <code>false</code>
    /// </p>
    pub skip_final_snapshot: bool,
    /// <p> The DBSnapshotIdentifier of the new DBSnapshot created when SkipFinalSnapshot is set to
    /// <code>false</code>.</p>
    /// <note>
    /// <p>Specifying this parameter and also setting the SkipFinalShapshot parameter to true
    /// results in an error.</p>
    /// </note>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be 1 to 255 letters or numbers.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
    /// </li>
    /// <li>
    /// <p>Cannot be specified when deleting a Read Replica.</p>
    /// </li>
    /// </ul>
    pub final_db_snapshot_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDbInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbInstanceInput");
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("skip_final_snapshot", &self.skip_final_snapshot);
        formatter.field(
            "final_db_snapshot_identifier",
            &self.final_db_snapshot_identifier,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbClusterSnapshotInput {
    /// <p>The identifier of the DB cluster snapshot to delete.</p>
    /// <p>Constraints: Must be the name of an existing DB cluster snapshot in the
    /// <code>available</code> state.</p>
    pub db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDbClusterSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbClusterSnapshotInput");
        formatter.field(
            "db_cluster_snapshot_identifier",
            &self.db_cluster_snapshot_identifier,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbClusterParameterGroupInput {
    /// <p>The name of the DB cluster parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be the name of an existing DB cluster parameter group.</p>
    /// </li>
    /// <li>
    /// <p>You can't delete a default DB cluster parameter group.</p>
    /// </li>
    /// <li>
    /// <p>Cannot be associated with any DB clusters.</p>
    /// </li>
    /// </ul>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDbClusterParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbClusterParameterGroupInput");
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbClusterEndpointInput {
    /// <p>The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.</p>
    pub db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDbClusterEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbClusterEndpointInput");
        formatter.field(
            "db_cluster_endpoint_identifier",
            &self.db_cluster_endpoint_identifier,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbClusterInput {
    /// <p>The DB cluster identifier for the DB cluster to be deleted. This parameter isn't
    /// case-sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match an existing DBClusterIdentifier.</p>
    /// </li>
    /// </ul>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p> Determines whether a final DB cluster snapshot is created before the DB cluster is
    /// deleted. If <code>true</code> is specified, no DB cluster snapshot is created. If
    /// <code>false</code> is specified, a DB cluster snapshot is created before the DB cluster is
    /// deleted.</p>
    /// <note>
    /// <p>You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if
    /// <code>SkipFinalSnapshot</code> is <code>false</code>.</p>
    /// </note>
    /// <p>Default: <code>false</code>
    /// </p>
    pub skip_final_snapshot: bool,
    /// <p> The DB cluster snapshot identifier of the new DB cluster snapshot created when
    /// <code>SkipFinalSnapshot</code> is set to <code>false</code>.</p>
    /// <note>
    /// <p> Specifying this parameter and also setting the <code>SkipFinalShapshot</code> parameter
    /// to true results in an error.</p>
    /// </note>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
    /// </li>
    /// </ul>
    pub final_db_snapshot_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDbClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbClusterInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("skip_final_snapshot", &self.skip_final_snapshot);
        formatter.field(
            "final_db_snapshot_identifier",
            &self.final_db_snapshot_identifier,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEventSubscriptionInput {
    /// <p>The name of the subscription.</p>
    /// <p>Constraints: The name must be less than 255 characters.</p>
    pub subscription_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is
    /// created by Amazon SNS when you create a topic and subscribe to it.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The type of source that is generating the events. For example, if you want to be notified
    /// of events generated by a DB instance, you would set this parameter to db-instance. if this
    /// value is not specified, all events are returned.</p>
    /// <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> |
    /// <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> |
    /// <code>db-cluster-snapshot</code>
    /// </p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p> A list of event categories for a SourceType that you want to subscribe to. You can see a
    /// list of the categories for a given SourceType by using the
    /// <b>DescribeEventCategories</b> action.</p>
    pub event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of identifiers of the event sources for which events are returned. If not
    /// specified, then all sources are included in the response. An identifier must begin with a
    /// letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or
    /// contain two consecutive hyphens.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If SourceIds are supplied, SourceType must also be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be
    /// supplied.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be
    /// supplied.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must
    /// be supplied.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be
    /// supplied.</p>
    /// </li>
    /// </ul>
    pub source_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A Boolean value; set to <b>true</b> to activate the
    /// subscription, set to <b>false</b> to create the subscription but not
    /// active it.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>The tags to be applied to the new event subscription.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateEventSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEventSubscriptionInput");
        formatter.field("subscription_name", &self.subscription_name);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("source_type", &self.source_type);
        formatter.field("event_categories", &self.event_categories);
        formatter.field("source_ids", &self.source_ids);
        formatter.field("enabled", &self.enabled);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbSubnetGroupInput {
    /// <p>The name for the DB subnet group. This value is stored as a lowercase string.</p>
    /// <p>Constraints: Must contain no more than 255 letters, numbers, periods, underscores, spaces,
    /// or hyphens. Must not be default.</p>
    /// <p>Example: <code>mySubnetgroup</code>
    /// </p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>The description for the DB subnet group.</p>
    pub db_subnet_group_description: std::option::Option<std::string::String>,
    /// <p>The EC2 Subnet IDs for the DB subnet group.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags to be assigned to the new DB subnet group.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateDbSubnetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbSubnetGroupInput");
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field(
            "db_subnet_group_description",
            &self.db_subnet_group_description,
        );
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbParameterGroupInput {
    /// <p>The name of the DB parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>This value is stored as a lowercase string.</p>
    /// </note>
    pub db_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The DB parameter group family name. A DB parameter group can be associated with one and
    /// only one DB parameter group family, and can be applied only to a DB instance running a
    /// database engine and engine version compatible with that DB parameter group family.</p>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>The description for the DB parameter group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The tags to be assigned to the new DB parameter group.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateDbParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbParameterGroupInput");
        formatter.field("db_parameter_group_name", &self.db_parameter_group_name);
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbInstanceInput {
    /// <p>Not supported.</p>
    pub db_name: std::option::Option<std::string::String>,
    /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>mydbinstance</code>
    /// </p>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>Not supported by Neptune.</p>
    pub allocated_storage: std::option::Option<i32>,
    /// <p>The compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>.
    /// Not all DB instance classes are available in all Amazon Regions.</p>
    pub db_instance_class: std::option::Option<std::string::String>,
    /// <p>The name of the database engine to be used for this instance.</p>
    /// <p>Valid Values: <code>neptune</code>
    /// </p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>Not supported by Neptune.</p>
    pub master_username: std::option::Option<std::string::String>,
    /// <p>Not supported by Neptune.</p>
    pub master_user_password: std::option::Option<std::string::String>,
    /// <p>A list of DB security groups to associate with this DB instance.</p>
    /// <p>Default: The default DB security group for the database engine.</p>
    pub db_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of EC2 VPC security groups to associate with this DB instance.</p>
    /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB
    /// cluster. For more information, see <a>CreateDBCluster</a>.</p>
    /// <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
    pub vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The EC2 Availability Zone that the DB instance is created in</p>
    /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Region.</p>
    /// <p> Example: <code>us-east-1d</code>
    /// </p>
    /// <p> Constraint: The AvailabilityZone parameter can't be specified if the MultiAZ parameter is
    /// set to <code>true</code>. The specified Availability Zone must be in the same Amazon Region as
    /// the current endpoint.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>A DB subnet group to associate with this DB instance.</p>
    /// <p>If there is no DB subnet group, then it is a non-VPC DB instance.</p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>The time range each week during which system maintenance can occur, in Universal
    /// Coordinated Time (UTC).</p>
    /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
    /// </p>
    /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
    /// Amazon Region, occurring on a random day of the week.</p>
    /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
    /// <p>Constraints: Minimum 30-minute window.</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>The name of the DB parameter group to associate with this DB instance. If this argument is
    /// omitted, the default DBParameterGroup for the specified engine is used.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
    /// </li>
    /// </ul>
    pub db_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The number of days for which automated backups are
    /// retained.</p>
    /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster.
    /// For more information, see <a>CreateDBCluster</a>.</p>
    /// <p>Default: 1</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be a value from 0 to 35</p>
    /// </li>
    /// <li>
    /// <p>Cannot be set to 0 if the DB instance is a source to Read Replicas</p>
    /// </li>
    /// </ul>
    pub backup_retention_period: std::option::Option<i32>,
    /// <p> The daily time range during which automated backups are created.</p>
    /// <p>Not applicable. The daily time range for creating automated backups is managed by the DB
    /// cluster. For more information, see <a>CreateDBCluster</a>.</p>
    pub preferred_backup_window: std::option::Option<std::string::String>,
    /// <p>The port number on which the database accepts connections.</p>
    /// <p>Not applicable. The port is managed by the DB cluster. For more information, see <a>CreateDBCluster</a>.</p>
    /// <p> Default: <code>8182</code>
    /// </p>
    /// <p>Type: Integer</p>
    pub port: std::option::Option<i32>,
    /// <p>Specifies if the DB instance is a Multi-AZ deployment. You can't set the AvailabilityZone
    /// parameter if the MultiAZ parameter is set to true.</p>
    pub multi_az: std::option::Option<bool>,
    /// <p>The version number of the database engine to use. Currently, setting this
    /// parameter has no effect.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Indicates that minor engine upgrades are applied automatically to the DB instance during
    /// the maintenance window.</p>
    /// <p>Default: <code>true</code>
    /// </p>
    pub auto_minor_version_upgrade: std::option::Option<bool>,
    /// <p>License model information for this DB instance.</p>
    /// <p> Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
    /// <code>general-public-license</code>
    /// </p>
    pub license_model: std::option::Option<std::string::String>,
    /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially
    /// allocated for the DB instance.</p>
    pub iops: std::option::Option<i32>,
    /// <p>
    /// <i>(Not supported by Neptune)</i>
    /// </p>
    pub option_group_name: std::option::Option<std::string::String>,
    /// <p>
    /// <i>(Not supported by Neptune)</i>
    /// </p>
    pub character_set_name: std::option::Option<std::string::String>,
    /// <p>This flag should no longer be used.</p>
    pub publicly_accessible: std::option::Option<bool>,
    /// <p>The tags to assign to the new instance.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The identifier of the DB cluster that the instance will belong to.</p>
    /// <p>For information on creating a DB cluster, see <a>CreateDBCluster</a>.</p>
    /// <p>Type: String</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the storage type to be associated with the DB instance.</p>
    /// <p>Not applicable. Storage is managed by the DB Cluster.</p>
    pub storage_type: std::option::Option<std::string::String>,
    /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
    pub tde_credential_arn: std::option::Option<std::string::String>,
    /// <p>The password for the given ARN from the key store in order to access the device.</p>
    pub tde_credential_password: std::option::Option<std::string::String>,
    /// <p>Specifies whether the DB instance is encrypted.</p>
    /// <p>Not applicable. The encryption for DB instances is managed by the DB cluster. For more
    /// information, see <a>CreateDBCluster</a>.</p>
    /// <p>Default: false</p>
    pub storage_encrypted: std::option::Option<bool>,
    /// <p>The Amazon KMS key identifier for an encrypted DB instance.</p>
    /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
    /// you are creating a DB instance with the same Amazon account that owns the KMS encryption key used
    /// to encrypt the new DB instance, then you can use the KMS key alias instead of the ARN for the
    /// KM encryption key.</p>
    /// <p>Not applicable. The KMS key identifier is managed by the DB cluster. For more information,
    /// see <a>CreateDBCluster</a>.</p>
    /// <p>If the <code>StorageEncrypted</code> parameter is true, and you do not specify a value for
    /// the <code>KmsKeyId</code> parameter, then Amazon Neptune will use your default encryption key.
    /// Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a
    /// different default encryption key for each Amazon Region.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Specify the Active Directory Domain to create the instance in.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise
    /// false. The default is false.</p>
    pub copy_tags_to_snapshot: std::option::Option<bool>,
    /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected
    /// for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default
    /// is 0.</p>
    /// <p>If <code>MonitoringRoleArn</code> is specified, then you must also set
    /// <code>MonitoringInterval</code> to a value other than 0.</p>
    /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
    /// </p>
    pub monitoring_interval: std::option::Option<i32>,
    /// <p>The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to
    /// Amazon CloudWatch Logs. For example,
    /// <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>
    /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
    /// <code>MonitoringRoleArn</code> value.</p>
    pub monitoring_role_arn: std::option::Option<std::string::String>,
    /// <p>Specify the name of the IAM role to be used when making API calls to the Directory
    /// Service.</p>
    pub domain_iam_role_name: std::option::Option<std::string::String>,
    /// <p>A value that specifies the order in which an Read Replica is promoted to the primary
    /// instance after a failure of the existing primary instance.
    /// </p>
    /// <p>Default: 1</p>
    /// <p>Valid Values: 0 - 15</p>
    pub promotion_tier: std::option::Option<i32>,
    /// <p>The time zone of the DB instance.</p>
    pub timezone: std::option::Option<std::string::String>,
    /// <p>Not supported by Neptune (ignored).</p>
    pub enable_iam_database_authentication: std::option::Option<bool>,
    /// <p>
    /// <i>(Not supported by Neptune)</i>
    /// </p>
    pub enable_performance_insights: std::option::Option<bool>,
    /// <p>
    /// <i>(Not supported by Neptune)</i>
    /// </p>
    pub performance_insights_kms_key_id: std::option::Option<std::string::String>,
    /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>
    pub enable_cloudwatch_logs_exports: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A value that indicates whether the DB instance has deletion protection enabled.
    /// The database can't be deleted when deletion protection is enabled. By default,
    /// deletion protection is disabled. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting
    /// a DB Instance</a>.</p>
    ///
    /// <p>DB instances in a DB cluster can be deleted even when deletion
    /// protection is enabled in their parent DB cluster.</p>
    pub deletion_protection: std::option::Option<bool>,
}
impl std::fmt::Debug for CreateDbInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbInstanceInput");
        formatter.field("db_name", &self.db_name);
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("allocated_storage", &self.allocated_storage);
        formatter.field("db_instance_class", &self.db_instance_class);
        formatter.field("engine", &self.engine);
        formatter.field("master_username", &self.master_username);
        formatter.field("master_user_password", &self.master_user_password);
        formatter.field("db_security_groups", &self.db_security_groups);
        formatter.field("vpc_security_group_ids", &self.vpc_security_group_ids);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field("db_parameter_group_name", &self.db_parameter_group_name);
        formatter.field("backup_retention_period", &self.backup_retention_period);
        formatter.field("preferred_backup_window", &self.preferred_backup_window);
        formatter.field("port", &self.port);
        formatter.field("multi_az", &self.multi_az);
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.field("license_model", &self.license_model);
        formatter.field("iops", &self.iops);
        formatter.field("option_group_name", &self.option_group_name);
        formatter.field("character_set_name", &self.character_set_name);
        formatter.field("publicly_accessible", &self.publicly_accessible);
        formatter.field("tags", &self.tags);
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("storage_type", &self.storage_type);
        formatter.field("tde_credential_arn", &self.tde_credential_arn);
        formatter.field("tde_credential_password", &self.tde_credential_password);
        formatter.field("storage_encrypted", &self.storage_encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("domain", &self.domain);
        formatter.field("copy_tags_to_snapshot", &self.copy_tags_to_snapshot);
        formatter.field("monitoring_interval", &self.monitoring_interval);
        formatter.field("monitoring_role_arn", &self.monitoring_role_arn);
        formatter.field("domain_iam_role_name", &self.domain_iam_role_name);
        formatter.field("promotion_tier", &self.promotion_tier);
        formatter.field("timezone", &self.timezone);
        formatter.field(
            "enable_iam_database_authentication",
            &self.enable_iam_database_authentication,
        );
        formatter.field(
            "enable_performance_insights",
            &self.enable_performance_insights,
        );
        formatter.field(
            "performance_insights_kms_key_id",
            &self.performance_insights_kms_key_id,
        );
        formatter.field(
            "enable_cloudwatch_logs_exports",
            &self.enable_cloudwatch_logs_exports,
        );
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbClusterSnapshotInput {
    /// <p>The identifier of the DB cluster snapshot. This parameter is stored as a lowercase
    /// string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster1-snapshot1</code>
    /// </p>
    pub db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>The identifier of the DB cluster to create a snapshot for. This parameter is not
    /// case-sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing DBCluster.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster1</code>
    /// </p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The tags to be assigned to the DB cluster snapshot.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateDbClusterSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbClusterSnapshotInput");
        formatter.field(
            "db_cluster_snapshot_identifier",
            &self.db_cluster_snapshot_identifier,
        );
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbClusterParameterGroupInput {
    /// <p>The name of the DB cluster parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the name of an existing DBClusterParameterGroup.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>This value is stored as a lowercase string.</p>
    /// </note>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The DB cluster parameter group family name. A DB cluster parameter group can be associated
    /// with one and only one DB cluster parameter group family, and can be applied only to a DB
    /// cluster running a database engine and engine version compatible with that DB cluster parameter
    /// group family.</p>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>The description for the DB cluster parameter group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The tags to be assigned to the new DB cluster parameter group.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateDbClusterParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbClusterParameterGroupInput");
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbClusterEndpointInput {
    /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
    /// stored as a lowercase string.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The identifier to use for the new endpoint. This parameter is stored as a lowercase string.</p>
    pub db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
    /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    pub endpoint_type: std::option::Option<std::string::String>,
    /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    pub static_members: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
    /// All other eligible instances are reachable through the custom endpoint.
    /// Only relevant if the list of static members is empty.</p>
    pub excluded_members: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags to be assigned to the Amazon Neptune resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateDbClusterEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbClusterEndpointInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field(
            "db_cluster_endpoint_identifier",
            &self.db_cluster_endpoint_identifier,
        );
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("static_members", &self.static_members);
        formatter.field("excluded_members", &self.excluded_members);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbClusterInput {
    /// <p>A list of EC2 Availability Zones that instances in the DB cluster can be created
    /// in.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The number of days for which automated backups are retained. You must specify a minimum
    /// value of 1.</p>
    /// <p>Default: 1</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be a value from 1 to 35</p>
    /// </li>
    /// </ul>
    pub backup_retention_period: std::option::Option<i32>,
    /// <p>
    /// <i>(Not supported by Neptune)</i>
    /// </p>
    pub character_set_name: std::option::Option<std::string::String>,
    /// <p>
    /// <i>If set to <code>true</code>, tags are copied to any snapshot of
    /// the DB cluster that is created.</i>
    /// </p>
    pub copy_tags_to_snapshot: std::option::Option<bool>,
    /// <p>The name for your database of up to 64 alpha-numeric characters. If you do not provide a
    /// name, Amazon Neptune will not create a database in the DB cluster you are creating.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The DB cluster identifier. This parameter is stored as a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster1</code>
    /// </p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p> The name of the DB cluster parameter group to associate with this DB cluster. If this
    /// argument is omitted, the default is used.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
    /// </li>
    /// </ul>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>A list of EC2 VPC security groups to associate with this DB cluster.</p>
    pub vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A DB subnet group to associate with this DB cluster.</p>
    /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
    /// <p>Example: <code>mySubnetgroup</code>
    /// </p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the database engine to be used for this DB cluster.</p>
    /// <p>Valid Values: <code>neptune</code>
    /// </p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The version number of the database engine to use for the new DB cluster.</p>
    /// <p>Example: <code>1.0.2.1</code>
    /// </p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The port number on which the instances in the DB cluster accept connections.</p>
    /// <p> Default: <code>8182</code>
    /// </p>
    pub port: std::option::Option<i32>,
    /// <p>Not supported by Neptune.</p>
    pub master_username: std::option::Option<std::string::String>,
    /// <p>Not supported by Neptune.</p>
    pub master_user_password: std::option::Option<std::string::String>,
    /// <p>
    /// <i>(Not supported by Neptune)</i>
    /// </p>
    pub option_group_name: std::option::Option<std::string::String>,
    /// <p>The daily time range during which automated backups are created if automated backups are
    /// enabled using the <code>BackupRetentionPeriod</code> parameter.</p>
    /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
    /// Amazon Region. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred
    /// Maintenance Window</a> in the <i>Amazon Neptune User Guide.</i>
    /// </p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
    /// </li>
    /// <li>
    /// <p>Must be in Universal Coordinated Time (UTC).</p>
    /// </li>
    /// <li>
    /// <p>Must not conflict with the preferred maintenance window.</p>
    /// </li>
    /// <li>
    /// <p>Must be at least 30 minutes.</p>
    /// </li>
    /// </ul>
    pub preferred_backup_window: std::option::Option<std::string::String>,
    /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated
    /// Time (UTC).</p>
    /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
    /// </p>
    /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
    /// Amazon Region, occurring on a random day of the week. To see the time blocks available, see
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred
    /// Maintenance Window</a> in the <i>Amazon Neptune User Guide.</i>
    /// </p>
    /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
    /// <p>Constraints: Minimum 30-minute window.</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster
    /// is created as a Read Replica.</p>
    pub replication_source_identifier: std::option::Option<std::string::String>,
    /// <p>The tags to assign to the new DB cluster.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Specifies whether the DB cluster is encrypted.</p>
    pub storage_encrypted: std::option::Option<bool>,
    /// <p>The Amazon KMS key identifier for an encrypted DB cluster.</p>
    /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If
    /// you are creating a DB cluster with the same Amazon account that owns the KMS encryption key used
    /// to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the
    /// KMS encryption key.</p>
    /// <p>If an encryption key is not specified in <code>KmsKeyId</code>:</p>
    /// <ul>
    /// <li>
    /// <p>If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then
    /// Amazon Neptune will use the encryption key used to encrypt the source. Otherwise, Amazon
    /// Neptune will use your default encryption key.</p>
    /// </li>
    /// <li>
    /// <p>If the <code>StorageEncrypted</code> parameter is true and
    /// <code>ReplicationSourceIdentifier</code> is not specified, then Amazon Neptune will use
    /// your default encryption key.</p>
    /// </li>
    /// </ul>
    /// <p>Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a
    /// different default encryption key for each Amazon Region.</p>
    /// <p>If you create a Read Replica of an encrypted DB cluster in another Amazon Region, you must
    /// set <code>KmsKeyId</code> to a KMS key ID that is valid in the destination Amazon Region. This
    /// key is used to encrypt the Read Replica in that Amazon Region.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub pre_signed_url: std::option::Option<std::string::String>,
    /// <p>If set to <code>true</code>, enables Amazon Identity and Access Management
    /// (IAM) authentication for the entire DB cluster (this cannot be set at an
    /// instance level).</p>
    /// <p>Default: <code>false</code>.</p>
    pub enable_iam_database_authentication: std::option::Option<bool>,
    /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>
    pub enable_cloudwatch_logs_exports: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
    /// The database can't be deleted when deletion protection is enabled. By default,
    /// deletion protection is enabled.</p>
    pub deletion_protection: std::option::Option<bool>,
}
impl std::fmt::Debug for CreateDbClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbClusterInput");
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("backup_retention_period", &self.backup_retention_period);
        formatter.field("character_set_name", &self.character_set_name);
        formatter.field("copy_tags_to_snapshot", &self.copy_tags_to_snapshot);
        formatter.field("database_name", &self.database_name);
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.field("vpc_security_group_ids", &self.vpc_security_group_ids);
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("port", &self.port);
        formatter.field("master_username", &self.master_username);
        formatter.field("master_user_password", &self.master_user_password);
        formatter.field("option_group_name", &self.option_group_name);
        formatter.field("preferred_backup_window", &self.preferred_backup_window);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field(
            "replication_source_identifier",
            &self.replication_source_identifier,
        );
        formatter.field("tags", &self.tags);
        formatter.field("storage_encrypted", &self.storage_encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("pre_signed_url", &self.pre_signed_url);
        formatter.field(
            "enable_iam_database_authentication",
            &self.enable_iam_database_authentication,
        );
        formatter.field(
            "enable_cloudwatch_logs_exports",
            &self.enable_cloudwatch_logs_exports,
        );
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyDbParameterGroupInput {
    /// <p>The identifier or ARN for the source DB parameter group. For information about creating
    /// an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
    /// Amazon Resource Name (ARN)</a>.</p>
    ///
    /// <p>Constraints:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Must specify a valid DB parameter group.</p>
    /// </li>
    /// <li>
    /// <p>Must specify a valid DB parameter group identifier, for example
    /// <code>my-db-param-group</code>, or a valid ARN.</p>
    /// </li>
    /// </ul>
    pub source_db_parameter_group_identifier: std::option::Option<std::string::String>,
    /// <p>The identifier for the copied DB parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Cannot be null, empty, or blank.</p>
    /// </li>
    /// <li>
    /// <p>Must contain from 1 to 255 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>Example: <code>my-db-parameter-group</code>
    /// </p>
    pub target_db_parameter_group_identifier: std::option::Option<std::string::String>,
    /// <p>A description for the copied DB parameter group.</p>
    pub target_db_parameter_group_description: std::option::Option<std::string::String>,
    /// <p>The tags to be assigned to the copied DB parameter group.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CopyDbParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyDbParameterGroupInput");
        formatter.field(
            "source_db_parameter_group_identifier",
            &self.source_db_parameter_group_identifier,
        );
        formatter.field(
            "target_db_parameter_group_identifier",
            &self.target_db_parameter_group_identifier,
        );
        formatter.field(
            "target_db_parameter_group_description",
            &self.target_db_parameter_group_description,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyDbClusterSnapshotInput {
    /// <p>The identifier of the DB cluster snapshot to copy. This parameter is not
    /// case-sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must specify a valid system snapshot in the "available" state.</p>
    /// </li>
    /// <li>
    /// <p>Specify a valid DB snapshot identifier.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster-snapshot1</code>
    /// </p>
    pub source_db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>The identifier of the new DB cluster snapshot to create from the source DB cluster
    /// snapshot. This parameter is not case-sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster-snapshot2</code>
    /// </p>
    pub target_db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>The Amazon Amazon KMS key ID for an encrypted DB cluster snapshot. The KMS key ID is the Amazon
    /// Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.</p>
    ///
    /// <p>If you copy an encrypted DB cluster snapshot from your Amazon account, you can specify a
    /// value for <code>KmsKeyId</code> to encrypt the copy with a new KMS encryption key. If you
    /// don't specify a value for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is
    /// encrypted with the same KMS key as the source DB cluster snapshot.</p>
    ///
    /// <p>If you copy an encrypted DB cluster snapshot that is shared from another Amazon account, then
    /// you must specify a value for <code>KmsKeyId</code>.</p>
    /// <p> KMS encryption keys are specific to the Amazon Region that they are created in, and you
    /// can't use encryption keys from one Amazon Region in another Amazon Region.</p>
    ///
    /// <p>You cannot encrypt an unencrypted DB cluster snapshot when you copy it. If you try to
    /// copy an unencrypted DB cluster snapshot and specify a value for the KmsKeyId parameter, an
    /// error is returned.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Not currently supported.</p>
    pub pre_signed_url: std::option::Option<std::string::String>,
    /// <p>True to copy all tags from the source DB cluster snapshot to the target DB cluster
    /// snapshot, and otherwise false. The default is false.</p>
    pub copy_tags: std::option::Option<bool>,
    /// <p>The tags to assign to the new DB cluster snapshot copy.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CopyDbClusterSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyDbClusterSnapshotInput");
        formatter.field(
            "source_db_cluster_snapshot_identifier",
            &self.source_db_cluster_snapshot_identifier,
        );
        formatter.field(
            "target_db_cluster_snapshot_identifier",
            &self.target_db_cluster_snapshot_identifier,
        );
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("pre_signed_url", &self.pre_signed_url);
        formatter.field("copy_tags", &self.copy_tags);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyDbClusterParameterGroupInput {
    /// <p>The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group.
    /// For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
    /// Amazon Resource Name (ARN)</a>.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must specify a valid DB cluster parameter group.</p>
    /// </li>
    /// <li>
    /// <p>If the source DB cluster parameter group is in the same Amazon Region as the copy,
    /// specify a valid DB parameter group identifier, for example
    /// <code>my-db-cluster-param-group</code>, or a valid ARN.</p>
    /// </li>
    /// <li>
    /// <p>If the source DB parameter group is in a different Amazon Region than the copy, specify a
    /// valid DB cluster parameter group ARN, for example
    /// <code>arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1</code>.</p>
    /// </li>
    /// </ul>
    pub source_db_cluster_parameter_group_identifier: std::option::Option<std::string::String>,
    /// <p>The identifier for the copied DB cluster parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Cannot be null, empty, or blank</p>
    /// </li>
    /// <li>
    /// <p>Must contain from 1 to 255 letters, numbers, or hyphens</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster-param-group1</code>
    /// </p>
    pub target_db_cluster_parameter_group_identifier: std::option::Option<std::string::String>,
    /// <p>A description for the copied DB cluster parameter group.</p>
    pub target_db_cluster_parameter_group_description: std::option::Option<std::string::String>,
    /// <p>The tags to be assigned to the copied DB cluster parameter group.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CopyDbClusterParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyDbClusterParameterGroupInput");
        formatter.field(
            "source_db_cluster_parameter_group_identifier",
            &self.source_db_cluster_parameter_group_identifier,
        );
        formatter.field(
            "target_db_cluster_parameter_group_identifier",
            &self.target_db_cluster_parameter_group_identifier,
        );
        formatter.field(
            "target_db_cluster_parameter_group_description",
            &self.target_db_cluster_parameter_group_description,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplyPendingMaintenanceActionInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that the pending maintenance action applies
    /// to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
    /// Amazon Resource Name (ARN)</a>.</p>
    pub resource_identifier: std::option::Option<std::string::String>,
    /// <p>The pending maintenance action to apply to this resource.</p>
    /// <p>Valid values: <code>system-update</code>, <code>db-upgrade</code>
    /// </p>
    pub apply_action: std::option::Option<std::string::String>,
    /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in
    /// request of type <code>immediate</code> can't be undone.</p>
    /// <p>Valid values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>immediate</code> - Apply the maintenance action immediately.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>next-maintenance</code> - Apply the maintenance action during the next
    /// maintenance window for the resource.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in
    /// requests.</p>
    /// </li>
    /// </ul>
    pub opt_in_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ApplyPendingMaintenanceActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplyPendingMaintenanceActionInput");
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field("apply_action", &self.apply_action);
        formatter.field("opt_in_type", &self.opt_in_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsToResourceInput {
    /// <p>The Amazon Neptune resource that the tags are added to. This value is an Amazon Resource
    /// Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an
    /// Amazon Resource Name (ARN)</a>.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>The tags to be assigned to the Amazon Neptune resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for AddTagsToResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsToResourceInput");
        formatter.field("resource_name", &self.resource_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddSourceIdentifierToSubscriptionInput {
    /// <p>The name of the event notification subscription you want to add a source identifier
    /// to.</p>
    pub subscription_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the event source to be added.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be
    /// supplied.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be
    /// supplied.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must
    /// be supplied.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be
    /// supplied.</p>
    /// </li>
    /// </ul>
    pub source_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AddSourceIdentifierToSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddSourceIdentifierToSubscriptionInput");
        formatter.field("subscription_name", &self.subscription_name);
        formatter.field("source_identifier", &self.source_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddRoleToDbClusterInput {
    /// <p>The name of the DB cluster to associate the IAM role with.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the Neptune DB cluster,
    /// for example <code>arn:aws:iam::123456789012:role/NeptuneAccessRole</code>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The name of the feature for the Neptune DB cluster that the IAM role is to be associated with.
    /// For the list of supported feature names, see <a>DBEngineVersion</a>.</p>
    pub feature_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AddRoleToDbClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddRoleToDbClusterInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("feature_name", &self.feature_name);
        formatter.finish()
    }
}
