// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WebserverAccessMode {
    #[allow(missing_docs)] // documentation missing in model
    PrivateOnly,
    #[allow(missing_docs)] // documentation missing in model
    PublicOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WebserverAccessMode {
    fn from(s: &str) -> Self {
        match s {
            "PRIVATE_ONLY" => WebserverAccessMode::PrivateOnly,
            "PUBLIC_ONLY" => WebserverAccessMode::PublicOnly,
            other => WebserverAccessMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WebserverAccessMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WebserverAccessMode::from(s))
    }
}
impl WebserverAccessMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WebserverAccessMode::PrivateOnly => "PRIVATE_ONLY",
            WebserverAccessMode::PublicOnly => "PUBLIC_ONLY",
            WebserverAccessMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRIVATE_ONLY", "PUBLIC_ONLY"]
    }
}
impl AsRef<str> for WebserverAccessMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines the Apache Airflow logs to send to CloudWatch Logs: <code>DagProcessingLogs</code>, <code>SchedulerLogs</code>, <code>TaskLogs</code>, <code>WebserverLogs</code>, <code>WorkerLogs</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoggingConfigurationInput {
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub dag_processing_logs: std::option::Option<crate::model::ModuleLoggingConfigurationInput>,
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub scheduler_logs: std::option::Option<crate::model::ModuleLoggingConfigurationInput>,
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub webserver_logs: std::option::Option<crate::model::ModuleLoggingConfigurationInput>,
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub worker_logs: std::option::Option<crate::model::ModuleLoggingConfigurationInput>,
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub task_logs: std::option::Option<crate::model::ModuleLoggingConfigurationInput>,
}
impl LoggingConfigurationInput {
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub fn dag_processing_logs(
        &self,
    ) -> std::option::Option<&crate::model::ModuleLoggingConfigurationInput> {
        self.dag_processing_logs.as_ref()
    }
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub fn scheduler_logs(
        &self,
    ) -> std::option::Option<&crate::model::ModuleLoggingConfigurationInput> {
        self.scheduler_logs.as_ref()
    }
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub fn webserver_logs(
        &self,
    ) -> std::option::Option<&crate::model::ModuleLoggingConfigurationInput> {
        self.webserver_logs.as_ref()
    }
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub fn worker_logs(
        &self,
    ) -> std::option::Option<&crate::model::ModuleLoggingConfigurationInput> {
        self.worker_logs.as_ref()
    }
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub fn task_logs(&self) -> std::option::Option<&crate::model::ModuleLoggingConfigurationInput> {
        self.task_logs.as_ref()
    }
}
impl std::fmt::Debug for LoggingConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoggingConfigurationInput");
        formatter.field("dag_processing_logs", &self.dag_processing_logs);
        formatter.field("scheduler_logs", &self.scheduler_logs);
        formatter.field("webserver_logs", &self.webserver_logs);
        formatter.field("worker_logs", &self.worker_logs);
        formatter.field("task_logs", &self.task_logs);
        formatter.finish()
    }
}
/// See [`LoggingConfigurationInput`](crate::model::LoggingConfigurationInput)
pub mod logging_configuration_input {
    /// A builder for [`LoggingConfigurationInput`](crate::model::LoggingConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dag_processing_logs:
            std::option::Option<crate::model::ModuleLoggingConfigurationInput>,
        pub(crate) scheduler_logs:
            std::option::Option<crate::model::ModuleLoggingConfigurationInput>,
        pub(crate) webserver_logs:
            std::option::Option<crate::model::ModuleLoggingConfigurationInput>,
        pub(crate) worker_logs: std::option::Option<crate::model::ModuleLoggingConfigurationInput>,
        pub(crate) task_logs: std::option::Option<crate::model::ModuleLoggingConfigurationInput>,
    }
    impl Builder {
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn dag_processing_logs(
            mut self,
            input: crate::model::ModuleLoggingConfigurationInput,
        ) -> Self {
            self.dag_processing_logs = Some(input);
            self
        }
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn set_dag_processing_logs(
            mut self,
            input: std::option::Option<crate::model::ModuleLoggingConfigurationInput>,
        ) -> Self {
            self.dag_processing_logs = input;
            self
        }
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn scheduler_logs(
            mut self,
            input: crate::model::ModuleLoggingConfigurationInput,
        ) -> Self {
            self.scheduler_logs = Some(input);
            self
        }
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn set_scheduler_logs(
            mut self,
            input: std::option::Option<crate::model::ModuleLoggingConfigurationInput>,
        ) -> Self {
            self.scheduler_logs = input;
            self
        }
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn webserver_logs(
            mut self,
            input: crate::model::ModuleLoggingConfigurationInput,
        ) -> Self {
            self.webserver_logs = Some(input);
            self
        }
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn set_webserver_logs(
            mut self,
            input: std::option::Option<crate::model::ModuleLoggingConfigurationInput>,
        ) -> Self {
            self.webserver_logs = input;
            self
        }
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn worker_logs(mut self, input: crate::model::ModuleLoggingConfigurationInput) -> Self {
            self.worker_logs = Some(input);
            self
        }
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn set_worker_logs(
            mut self,
            input: std::option::Option<crate::model::ModuleLoggingConfigurationInput>,
        ) -> Self {
            self.worker_logs = input;
            self
        }
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn task_logs(mut self, input: crate::model::ModuleLoggingConfigurationInput) -> Self {
            self.task_logs = Some(input);
            self
        }
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn set_task_logs(
            mut self,
            input: std::option::Option<crate::model::ModuleLoggingConfigurationInput>,
        ) -> Self {
            self.task_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`LoggingConfigurationInput`](crate::model::LoggingConfigurationInput)
        pub fn build(self) -> crate::model::LoggingConfigurationInput {
            crate::model::LoggingConfigurationInput {
                dag_processing_logs: self.dag_processing_logs,
                scheduler_logs: self.scheduler_logs,
                webserver_logs: self.webserver_logs,
                worker_logs: self.worker_logs,
                task_logs: self.task_logs,
            }
        }
    }
}
impl LoggingConfigurationInput {
    /// Creates a new builder-style object to manufacture [`LoggingConfigurationInput`](crate::model::LoggingConfigurationInput)
    pub fn builder() -> crate::model::logging_configuration_input::Builder {
        crate::model::logging_configuration_input::Builder::default()
    }
}

/// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModuleLoggingConfigurationInput {
    /// <p>Indicates whether to enable the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) in CloudWatch Logs.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>Defines the Apache Airflow logs to send for the log type (e.g. <code>DagProcessingLogs</code>) to CloudWatch Logs. Valid values: <code>CRITICAL</code>, <code>ERROR</code>, <code>WARNING</code>, <code>INFO</code>.</p>
    pub log_level: std::option::Option<crate::model::LoggingLevel>,
}
impl ModuleLoggingConfigurationInput {
    /// <p>Indicates whether to enable the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) in CloudWatch Logs.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>Defines the Apache Airflow logs to send for the log type (e.g. <code>DagProcessingLogs</code>) to CloudWatch Logs. Valid values: <code>CRITICAL</code>, <code>ERROR</code>, <code>WARNING</code>, <code>INFO</code>.</p>
    pub fn log_level(&self) -> std::option::Option<&crate::model::LoggingLevel> {
        self.log_level.as_ref()
    }
}
impl std::fmt::Debug for ModuleLoggingConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModuleLoggingConfigurationInput");
        formatter.field("enabled", &self.enabled);
        formatter.field("log_level", &self.log_level);
        formatter.finish()
    }
}
/// See [`ModuleLoggingConfigurationInput`](crate::model::ModuleLoggingConfigurationInput)
pub mod module_logging_configuration_input {
    /// A builder for [`ModuleLoggingConfigurationInput`](crate::model::ModuleLoggingConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) log_level: std::option::Option<crate::model::LoggingLevel>,
    }
    impl Builder {
        /// <p>Indicates whether to enable the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) in CloudWatch Logs.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether to enable the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) in CloudWatch Logs.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>Defines the Apache Airflow logs to send for the log type (e.g. <code>DagProcessingLogs</code>) to CloudWatch Logs. Valid values: <code>CRITICAL</code>, <code>ERROR</code>, <code>WARNING</code>, <code>INFO</code>.</p>
        pub fn log_level(mut self, input: crate::model::LoggingLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// <p>Defines the Apache Airflow logs to send for the log type (e.g. <code>DagProcessingLogs</code>) to CloudWatch Logs. Valid values: <code>CRITICAL</code>, <code>ERROR</code>, <code>WARNING</code>, <code>INFO</code>.</p>
        pub fn set_log_level(
            mut self,
            input: std::option::Option<crate::model::LoggingLevel>,
        ) -> Self {
            self.log_level = input;
            self
        }
        /// Consumes the builder and constructs a [`ModuleLoggingConfigurationInput`](crate::model::ModuleLoggingConfigurationInput)
        pub fn build(self) -> crate::model::ModuleLoggingConfigurationInput {
            crate::model::ModuleLoggingConfigurationInput {
                enabled: self.enabled,
                log_level: self.log_level,
            }
        }
    }
}
impl ModuleLoggingConfigurationInput {
    /// Creates a new builder-style object to manufacture [`ModuleLoggingConfigurationInput`](crate::model::ModuleLoggingConfigurationInput)
    pub fn builder() -> crate::model::module_logging_configuration_input::Builder {
        crate::model::module_logging_configuration_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LoggingLevel {
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    Debug,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Info,
    #[allow(missing_docs)] // documentation missing in model
    Warning,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LoggingLevel {
    fn from(s: &str) -> Self {
        match s {
            "CRITICAL" => LoggingLevel::Critical,
            "DEBUG" => LoggingLevel::Debug,
            "ERROR" => LoggingLevel::Error,
            "INFO" => LoggingLevel::Info,
            "WARNING" => LoggingLevel::Warning,
            other => LoggingLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LoggingLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LoggingLevel::from(s))
    }
}
impl LoggingLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LoggingLevel::Critical => "CRITICAL",
            LoggingLevel::Debug => "DEBUG",
            LoggingLevel::Error => "ERROR",
            LoggingLevel::Info => "INFO",
            LoggingLevel::Warning => "WARNING",
            LoggingLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CRITICAL", "DEBUG", "ERROR", "INFO", "WARNING"]
    }
}
impl AsRef<str> for LoggingLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The VPC networking components used to secure and enable network traffic between the AWS resources for your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateNetworkConfigurationInput {
    /// <p>A list of 1 or more security group IDs. Accepts up to 5 security group IDs. A security group must be attached to the same VPC as the subnets. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-security.html">Security in your VPC on Amazon MWAA</a>.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateNetworkConfigurationInput {
    /// <p>A list of 1 or more security group IDs. Accepts up to 5 security group IDs. A security group must be attached to the same VPC as the subnets. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-security.html">Security in your VPC on Amazon MWAA</a>.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
}
impl std::fmt::Debug for UpdateNetworkConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateNetworkConfigurationInput");
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.finish()
    }
}
/// See [`UpdateNetworkConfigurationInput`](crate::model::UpdateNetworkConfigurationInput)
pub mod update_network_configuration_input {
    /// A builder for [`UpdateNetworkConfigurationInput`](crate::model::UpdateNetworkConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of 1 or more security group IDs. Accepts up to 5 security group IDs. A security group must be attached to the same VPC as the subnets. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-security.html">Security in your VPC on Amazon MWAA</a>.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>A list of 1 or more security group IDs. Accepts up to 5 security group IDs. A security group must be attached to the same VPC as the subnets. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-security.html">Security in your VPC on Amazon MWAA</a>.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateNetworkConfigurationInput`](crate::model::UpdateNetworkConfigurationInput)
        pub fn build(self) -> crate::model::UpdateNetworkConfigurationInput {
            crate::model::UpdateNetworkConfigurationInput {
                security_group_ids: self.security_group_ids,
            }
        }
    }
}
impl UpdateNetworkConfigurationInput {
    /// Creates a new builder-style object to manufacture [`UpdateNetworkConfigurationInput`](crate::model::UpdateNetworkConfigurationInput)
    pub fn builder() -> crate::model::update_network_configuration_input::Builder {
        crate::model::update_network_configuration_input::Builder::default()
    }
}

/// <p>Internal only API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricDatum {
    /// <p>Internal only API.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>Internal only API.</p>
    pub timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Internal only API.</p>
    pub dimensions: std::option::Option<std::vec::Vec<crate::model::Dimension>>,
    /// <p>Internal only API.</p>
    pub value: std::option::Option<f64>,
    /// Unit
    pub unit: std::option::Option<crate::model::Unit>,
    /// <p>Internal only API.</p>
    pub statistic_values: std::option::Option<crate::model::StatisticSet>,
}
impl MetricDatum {
    /// <p>Internal only API.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>Internal only API.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.timestamp.as_ref()
    }
    /// <p>Internal only API.</p>
    pub fn dimensions(&self) -> std::option::Option<&[crate::model::Dimension]> {
        self.dimensions.as_deref()
    }
    /// <p>Internal only API.</p>
    pub fn value(&self) -> std::option::Option<f64> {
        self.value
    }
    /// Unit
    pub fn unit(&self) -> std::option::Option<&crate::model::Unit> {
        self.unit.as_ref()
    }
    /// <p>Internal only API.</p>
    pub fn statistic_values(&self) -> std::option::Option<&crate::model::StatisticSet> {
        self.statistic_values.as_ref()
    }
}
impl std::fmt::Debug for MetricDatum {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricDatum");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("dimensions", &self.dimensions);
        formatter.field("value", &self.value);
        formatter.field("unit", &self.unit);
        formatter.field("statistic_values", &self.statistic_values);
        formatter.finish()
    }
}
/// See [`MetricDatum`](crate::model::MetricDatum)
pub mod metric_datum {
    /// A builder for [`MetricDatum`](crate::model::MetricDatum)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) dimensions: std::option::Option<std::vec::Vec<crate::model::Dimension>>,
        pub(crate) value: std::option::Option<f64>,
        pub(crate) unit: std::option::Option<crate::model::Unit>,
        pub(crate) statistic_values: std::option::Option<crate::model::StatisticSet>,
    }
    impl Builder {
        /// <p>Internal only API.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>Internal only API.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>Internal only API.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>Internal only API.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>Internal only API.</p>
        pub fn dimensions(mut self, input: crate::model::Dimension) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input);
            self.dimensions = Some(v);
            self
        }
        /// <p>Internal only API.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Dimension>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>Internal only API.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>Internal only API.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// Unit
        pub fn unit(mut self, input: crate::model::Unit) -> Self {
            self.unit = Some(input);
            self
        }
        /// Unit
        pub fn set_unit(mut self, input: std::option::Option<crate::model::Unit>) -> Self {
            self.unit = input;
            self
        }
        /// <p>Internal only API.</p>
        pub fn statistic_values(mut self, input: crate::model::StatisticSet) -> Self {
            self.statistic_values = Some(input);
            self
        }
        /// <p>Internal only API.</p>
        pub fn set_statistic_values(
            mut self,
            input: std::option::Option<crate::model::StatisticSet>,
        ) -> Self {
            self.statistic_values = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricDatum`](crate::model::MetricDatum)
        pub fn build(self) -> crate::model::MetricDatum {
            crate::model::MetricDatum {
                metric_name: self.metric_name,
                timestamp: self.timestamp,
                dimensions: self.dimensions,
                value: self.value,
                unit: self.unit,
                statistic_values: self.statistic_values,
            }
        }
    }
}
impl MetricDatum {
    /// Creates a new builder-style object to manufacture [`MetricDatum`](crate::model::MetricDatum)
    pub fn builder() -> crate::model::metric_datum::Builder {
        crate::model::metric_datum::Builder::default()
    }
}

/// <p>Internal only API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatisticSet {
    /// <p>Internal only API.</p>
    pub sample_count: std::option::Option<i32>,
    /// <p>Internal only API.</p>
    pub sum: std::option::Option<f64>,
    /// <p>Internal only API.</p>
    pub minimum: std::option::Option<f64>,
    /// <p>Internal only API.</p>
    pub maximum: std::option::Option<f64>,
}
impl StatisticSet {
    /// <p>Internal only API.</p>
    pub fn sample_count(&self) -> std::option::Option<i32> {
        self.sample_count
    }
    /// <p>Internal only API.</p>
    pub fn sum(&self) -> std::option::Option<f64> {
        self.sum
    }
    /// <p>Internal only API.</p>
    pub fn minimum(&self) -> std::option::Option<f64> {
        self.minimum
    }
    /// <p>Internal only API.</p>
    pub fn maximum(&self) -> std::option::Option<f64> {
        self.maximum
    }
}
impl std::fmt::Debug for StatisticSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatisticSet");
        formatter.field("sample_count", &self.sample_count);
        formatter.field("sum", &self.sum);
        formatter.field("minimum", &self.minimum);
        formatter.field("maximum", &self.maximum);
        formatter.finish()
    }
}
/// See [`StatisticSet`](crate::model::StatisticSet)
pub mod statistic_set {
    /// A builder for [`StatisticSet`](crate::model::StatisticSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sample_count: std::option::Option<i32>,
        pub(crate) sum: std::option::Option<f64>,
        pub(crate) minimum: std::option::Option<f64>,
        pub(crate) maximum: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>Internal only API.</p>
        pub fn sample_count(mut self, input: i32) -> Self {
            self.sample_count = Some(input);
            self
        }
        /// <p>Internal only API.</p>
        pub fn set_sample_count(mut self, input: std::option::Option<i32>) -> Self {
            self.sample_count = input;
            self
        }
        /// <p>Internal only API.</p>
        pub fn sum(mut self, input: f64) -> Self {
            self.sum = Some(input);
            self
        }
        /// <p>Internal only API.</p>
        pub fn set_sum(mut self, input: std::option::Option<f64>) -> Self {
            self.sum = input;
            self
        }
        /// <p>Internal only API.</p>
        pub fn minimum(mut self, input: f64) -> Self {
            self.minimum = Some(input);
            self
        }
        /// <p>Internal only API.</p>
        pub fn set_minimum(mut self, input: std::option::Option<f64>) -> Self {
            self.minimum = input;
            self
        }
        /// <p>Internal only API.</p>
        pub fn maximum(mut self, input: f64) -> Self {
            self.maximum = Some(input);
            self
        }
        /// <p>Internal only API.</p>
        pub fn set_maximum(mut self, input: std::option::Option<f64>) -> Self {
            self.maximum = input;
            self
        }
        /// Consumes the builder and constructs a [`StatisticSet`](crate::model::StatisticSet)
        pub fn build(self) -> crate::model::StatisticSet {
            crate::model::StatisticSet {
                sample_count: self.sample_count,
                sum: self.sum,
                minimum: self.minimum,
                maximum: self.maximum,
            }
        }
    }
}
impl StatisticSet {
    /// Creates a new builder-style object to manufacture [`StatisticSet`](crate::model::StatisticSet)
    pub fn builder() -> crate::model::statistic_set::Builder {
        crate::model::statistic_set::Builder::default()
    }
}

/// Unit
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Unit {
    #[allow(missing_docs)] // documentation missing in model
    Bits,
    #[allow(missing_docs)] // documentation missing in model
    BitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Bytes,
    #[allow(missing_docs)] // documentation missing in model
    BytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Count,
    #[allow(missing_docs)] // documentation missing in model
    CountPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Gigabits,
    #[allow(missing_docs)] // documentation missing in model
    GigabitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Gigabytes,
    #[allow(missing_docs)] // documentation missing in model
    GigabytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Kilobits,
    #[allow(missing_docs)] // documentation missing in model
    KilobitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Kilobytes,
    #[allow(missing_docs)] // documentation missing in model
    KilobytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Megabits,
    #[allow(missing_docs)] // documentation missing in model
    MegabitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Megabytes,
    #[allow(missing_docs)] // documentation missing in model
    MegabytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Microseconds,
    #[allow(missing_docs)] // documentation missing in model
    Milliseconds,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Percent,
    #[allow(missing_docs)] // documentation missing in model
    Seconds,
    #[allow(missing_docs)] // documentation missing in model
    Terabits,
    #[allow(missing_docs)] // documentation missing in model
    TerabitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Terabytes,
    #[allow(missing_docs)] // documentation missing in model
    TerabytesPerSecond,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Unit {
    fn from(s: &str) -> Self {
        match s {
            "Bits" => Unit::Bits,
            "Bits/Second" => Unit::BitsPerSecond,
            "Bytes" => Unit::Bytes,
            "Bytes/Second" => Unit::BytesPerSecond,
            "Count" => Unit::Count,
            "Count/Second" => Unit::CountPerSecond,
            "Gigabits" => Unit::Gigabits,
            "Gigabits/Second" => Unit::GigabitsPerSecond,
            "Gigabytes" => Unit::Gigabytes,
            "Gigabytes/Second" => Unit::GigabytesPerSecond,
            "Kilobits" => Unit::Kilobits,
            "Kilobits/Second" => Unit::KilobitsPerSecond,
            "Kilobytes" => Unit::Kilobytes,
            "Kilobytes/Second" => Unit::KilobytesPerSecond,
            "Megabits" => Unit::Megabits,
            "Megabits/Second" => Unit::MegabitsPerSecond,
            "Megabytes" => Unit::Megabytes,
            "Megabytes/Second" => Unit::MegabytesPerSecond,
            "Microseconds" => Unit::Microseconds,
            "Milliseconds" => Unit::Milliseconds,
            "None" => Unit::None,
            "Percent" => Unit::Percent,
            "Seconds" => Unit::Seconds,
            "Terabits" => Unit::Terabits,
            "Terabits/Second" => Unit::TerabitsPerSecond,
            "Terabytes" => Unit::Terabytes,
            "Terabytes/Second" => Unit::TerabytesPerSecond,
            other => Unit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Unit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Unit::from(s))
    }
}
impl Unit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Unit::Bits => "Bits",
            Unit::BitsPerSecond => "Bits/Second",
            Unit::Bytes => "Bytes",
            Unit::BytesPerSecond => "Bytes/Second",
            Unit::Count => "Count",
            Unit::CountPerSecond => "Count/Second",
            Unit::Gigabits => "Gigabits",
            Unit::GigabitsPerSecond => "Gigabits/Second",
            Unit::Gigabytes => "Gigabytes",
            Unit::GigabytesPerSecond => "Gigabytes/Second",
            Unit::Kilobits => "Kilobits",
            Unit::KilobitsPerSecond => "Kilobits/Second",
            Unit::Kilobytes => "Kilobytes",
            Unit::KilobytesPerSecond => "Kilobytes/Second",
            Unit::Megabits => "Megabits",
            Unit::MegabitsPerSecond => "Megabits/Second",
            Unit::Megabytes => "Megabytes",
            Unit::MegabytesPerSecond => "Megabytes/Second",
            Unit::Microseconds => "Microseconds",
            Unit::Milliseconds => "Milliseconds",
            Unit::None => "None",
            Unit::Percent => "Percent",
            Unit::Seconds => "Seconds",
            Unit::Terabits => "Terabits",
            Unit::TerabitsPerSecond => "Terabits/Second",
            Unit::Terabytes => "Terabytes",
            Unit::TerabytesPerSecond => "Terabytes/Second",
            Unit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Bits",
            "Bits/Second",
            "Bytes",
            "Bytes/Second",
            "Count",
            "Count/Second",
            "Gigabits",
            "Gigabits/Second",
            "Gigabytes",
            "Gigabytes/Second",
            "Kilobits",
            "Kilobits/Second",
            "Kilobytes",
            "Kilobytes/Second",
            "Megabits",
            "Megabits/Second",
            "Megabytes",
            "Megabytes/Second",
            "Microseconds",
            "Milliseconds",
            "None",
            "Percent",
            "Seconds",
            "Terabits",
            "Terabits/Second",
            "Terabytes",
            "Terabytes/Second",
        ]
    }
}
impl AsRef<str> for Unit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Internal only API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Dimension {
    /// <p>Internal only API.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Internal only API.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Dimension {
    /// <p>Internal only API.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Internal only API.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Dimension {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Dimension");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Dimension`](crate::model::Dimension)
pub mod dimension {
    /// A builder for [`Dimension`](crate::model::Dimension)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Internal only API.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Internal only API.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Internal only API.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Internal only API.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Dimension`](crate::model::Dimension)
        pub fn build(self) -> crate::model::Dimension {
            crate::model::Dimension {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl Dimension {
    /// Creates a new builder-style object to manufacture [`Dimension`](crate::model::Dimension)
    pub fn builder() -> crate::model::dimension::Builder {
        crate::model::dimension::Builder::default()
    }
}

/// <p>The Amazon Managed Workflows for Apache Airflow (MWAA) environment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Environment {
    /// <p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the Amazon MWAA environment. Valid values:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - Indicates the request to create the environment is in progress.</p> </li>
    /// <li> <p> <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the environment could not be created.</p> </li>
    /// <li> <p> <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.</p> </li>
    /// <li> <p> <code>UPDATING</code> - Indicates the request to update the environment is in progress.</p> </li>
    /// <li> <p> <code>DELETING</code> - Indicates the request to delete the environment is in progress.</p> </li>
    /// <li> <p> <code>DELETED</code> - Indicates the request to delete the environment is complete, and the environment has been deleted.</p> </li>
    /// <li> <p> <code>UNAVAILABLE</code> - Indicates the request failed, but the environment was unable to rollback and is not in a stable state.</p> </li>
    /// <li> <p> <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the environment has rolled back successfully and is ready to use.</p> </li>
    /// </ul>
    /// <p>We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA troubleshooting</a>.</p>
    pub status: std::option::Option<crate::model::EnvironmentStatus>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon MWAA environment.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The day and time the environment was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Apache Airflow <i>Web server</i> host name for the Amazon MWAA environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/access-airflow-ui.html">Accessing the Apache Airflow UI</a>.</p>
    pub webserver_url: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access AWS resources in your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution role</a>.</p>
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the service-linked role of the environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-slr.html">Amazon MWAA Service-linked role</a>.</p>
    pub service_role_arn: std::option::Option<std::string::String>,
    /// <p>The Key Management Service (KMS) encryption key used to encrypt the data in your environment.</p>
    pub kms_key: std::option::Option<std::string::String>,
    /// <p>The Apache Airflow version on your environment. For example, <code>v1.10.12</code>.</p>
    pub airflow_version: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for Amazon MWAA</a>.</p>
    pub source_bucket_arn: std::option::Option<std::string::String>,
    /// <p>The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a>.</p>
    pub dag_s3_path: std::option::Option<std::string::String>,
    /// <p>The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>
    pub plugins_s3_path: std::option::Option<std::string::String>,
    /// <p>The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>
    pub plugins_s3_object_version: std::option::Option<std::string::String>,
    /// <p>The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>
    pub requirements_s3_path: std::option::Option<std::string::String>,
    /// <p>The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>
    pub requirements_s3_object_version: std::option::Option<std::string::String>,
    /// <p>A list of key-value pairs containing the Apache Airflow configuration options attached to your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow configuration options</a>.</p>
    pub airflow_configuration_options:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>, <code>mw1.large</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment class</a>.</p>
    pub environment_class: std::option::Option<std::string::String>,
    /// <p>The maximum number of workers that run in your environment. For example, <code>20</code>.</p>
    pub max_workers: std::option::Option<i32>,
    /// <p>The VPC networking components used to secure and enable network traffic between the AWS resources for your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>
    pub network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
    /// <p>The Apache Airflow logs being sent to CloudWatch Logs: <code>DagProcessingLogs</code>, <code>SchedulerLogs</code>, <code>TaskLogs</code>, <code>WebserverLogs</code>, <code>WorkerLogs</code>.</p>
    pub logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
    /// <p>The status of the last update on the environment, and any errors that were encountered.</p>
    pub last_update: std::option::Option<crate::model::LastUpdate>,
    /// <p>The day and time of the week that weekly maintenance updates are scheduled. For example: <code>TUE:03:30</code>.</p>
    pub weekly_maintenance_window_start: std::option::Option<std::string::String>,
    /// <p>The key-value tag pairs associated to your environment. For example, <code>"Environment": "Staging"</code>. To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Apache Airflow <i>Web server</i> access mode. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access modes</a>.</p>
    pub webserver_access_mode: std::option::Option<crate::model::WebserverAccessMode>,
    /// <p>The minimum number of workers that run in your environment. For example, <code>2</code>.</p>
    pub min_workers: std::option::Option<i32>,
    /// <p>The number of Apache Airflow schedulers that run in your Amazon MWAA environment.</p>
    pub schedulers: std::option::Option<i32>,
}
impl Environment {
    /// <p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the Amazon MWAA environment. Valid values:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - Indicates the request to create the environment is in progress.</p> </li>
    /// <li> <p> <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the environment could not be created.</p> </li>
    /// <li> <p> <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.</p> </li>
    /// <li> <p> <code>UPDATING</code> - Indicates the request to update the environment is in progress.</p> </li>
    /// <li> <p> <code>DELETING</code> - Indicates the request to delete the environment is in progress.</p> </li>
    /// <li> <p> <code>DELETED</code> - Indicates the request to delete the environment is complete, and the environment has been deleted.</p> </li>
    /// <li> <p> <code>UNAVAILABLE</code> - Indicates the request failed, but the environment was unable to rollback and is not in a stable state.</p> </li>
    /// <li> <p> <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the environment has rolled back successfully and is ready to use.</p> </li>
    /// </ul>
    /// <p>We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA troubleshooting</a>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::EnvironmentStatus> {
        self.status.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon MWAA environment.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The day and time the environment was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The Apache Airflow <i>Web server</i> host name for the Amazon MWAA environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/access-airflow-ui.html">Accessing the Apache Airflow UI</a>.</p>
    pub fn webserver_url(&self) -> std::option::Option<&str> {
        self.webserver_url.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access AWS resources in your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution role</a>.</p>
    pub fn execution_role_arn(&self) -> std::option::Option<&str> {
        self.execution_role_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the service-linked role of the environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-slr.html">Amazon MWAA Service-linked role</a>.</p>
    pub fn service_role_arn(&self) -> std::option::Option<&str> {
        self.service_role_arn.as_deref()
    }
    /// <p>The Key Management Service (KMS) encryption key used to encrypt the data in your environment.</p>
    pub fn kms_key(&self) -> std::option::Option<&str> {
        self.kms_key.as_deref()
    }
    /// <p>The Apache Airflow version on your environment. For example, <code>v1.10.12</code>.</p>
    pub fn airflow_version(&self) -> std::option::Option<&str> {
        self.airflow_version.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for Amazon MWAA</a>.</p>
    pub fn source_bucket_arn(&self) -> std::option::Option<&str> {
        self.source_bucket_arn.as_deref()
    }
    /// <p>The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a>.</p>
    pub fn dag_s3_path(&self) -> std::option::Option<&str> {
        self.dag_s3_path.as_deref()
    }
    /// <p>The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>
    pub fn plugins_s3_path(&self) -> std::option::Option<&str> {
        self.plugins_s3_path.as_deref()
    }
    /// <p>The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>
    pub fn plugins_s3_object_version(&self) -> std::option::Option<&str> {
        self.plugins_s3_object_version.as_deref()
    }
    /// <p>The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>
    pub fn requirements_s3_path(&self) -> std::option::Option<&str> {
        self.requirements_s3_path.as_deref()
    }
    /// <p>The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>
    pub fn requirements_s3_object_version(&self) -> std::option::Option<&str> {
        self.requirements_s3_object_version.as_deref()
    }
    /// <p>A list of key-value pairs containing the Apache Airflow configuration options attached to your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow configuration options</a>.</p>
    pub fn airflow_configuration_options(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.airflow_configuration_options.as_ref()
    }
    /// <p>The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>, <code>mw1.large</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment class</a>.</p>
    pub fn environment_class(&self) -> std::option::Option<&str> {
        self.environment_class.as_deref()
    }
    /// <p>The maximum number of workers that run in your environment. For example, <code>20</code>.</p>
    pub fn max_workers(&self) -> std::option::Option<i32> {
        self.max_workers
    }
    /// <p>The VPC networking components used to secure and enable network traffic between the AWS resources for your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>
    pub fn network_configuration(
        &self,
    ) -> std::option::Option<&crate::model::NetworkConfiguration> {
        self.network_configuration.as_ref()
    }
    /// <p>The Apache Airflow logs being sent to CloudWatch Logs: <code>DagProcessingLogs</code>, <code>SchedulerLogs</code>, <code>TaskLogs</code>, <code>WebserverLogs</code>, <code>WorkerLogs</code>.</p>
    pub fn logging_configuration(
        &self,
    ) -> std::option::Option<&crate::model::LoggingConfiguration> {
        self.logging_configuration.as_ref()
    }
    /// <p>The status of the last update on the environment, and any errors that were encountered.</p>
    pub fn last_update(&self) -> std::option::Option<&crate::model::LastUpdate> {
        self.last_update.as_ref()
    }
    /// <p>The day and time of the week that weekly maintenance updates are scheduled. For example: <code>TUE:03:30</code>.</p>
    pub fn weekly_maintenance_window_start(&self) -> std::option::Option<&str> {
        self.weekly_maintenance_window_start.as_deref()
    }
    /// <p>The key-value tag pairs associated to your environment. For example, <code>"Environment": "Staging"</code>. To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The Apache Airflow <i>Web server</i> access mode. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access modes</a>.</p>
    pub fn webserver_access_mode(&self) -> std::option::Option<&crate::model::WebserverAccessMode> {
        self.webserver_access_mode.as_ref()
    }
    /// <p>The minimum number of workers that run in your environment. For example, <code>2</code>.</p>
    pub fn min_workers(&self) -> std::option::Option<i32> {
        self.min_workers
    }
    /// <p>The number of Apache Airflow schedulers that run in your Amazon MWAA environment.</p>
    pub fn schedulers(&self) -> std::option::Option<i32> {
        self.schedulers
    }
}
impl std::fmt::Debug for Environment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Environment");
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("webserver_url", &self.webserver_url);
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("service_role_arn", &self.service_role_arn);
        formatter.field("kms_key", &self.kms_key);
        formatter.field("airflow_version", &self.airflow_version);
        formatter.field("source_bucket_arn", &self.source_bucket_arn);
        formatter.field("dag_s3_path", &self.dag_s3_path);
        formatter.field("plugins_s3_path", &self.plugins_s3_path);
        formatter.field("plugins_s3_object_version", &self.plugins_s3_object_version);
        formatter.field("requirements_s3_path", &self.requirements_s3_path);
        formatter.field(
            "requirements_s3_object_version",
            &self.requirements_s3_object_version,
        );
        formatter.field(
            "airflow_configuration_options",
            &self.airflow_configuration_options,
        );
        formatter.field("environment_class", &self.environment_class);
        formatter.field("max_workers", &self.max_workers);
        formatter.field("network_configuration", &self.network_configuration);
        formatter.field("logging_configuration", &self.logging_configuration);
        formatter.field("last_update", &self.last_update);
        formatter.field(
            "weekly_maintenance_window_start",
            &self.weekly_maintenance_window_start,
        );
        formatter.field("tags", &self.tags);
        formatter.field("webserver_access_mode", &self.webserver_access_mode);
        formatter.field("min_workers", &self.min_workers);
        formatter.field("schedulers", &self.schedulers);
        formatter.finish()
    }
}
/// See [`Environment`](crate::model::Environment)
pub mod environment {
    /// A builder for [`Environment`](crate::model::Environment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::EnvironmentStatus>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) webserver_url: std::option::Option<std::string::String>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) service_role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
        pub(crate) airflow_version: std::option::Option<std::string::String>,
        pub(crate) source_bucket_arn: std::option::Option<std::string::String>,
        pub(crate) dag_s3_path: std::option::Option<std::string::String>,
        pub(crate) plugins_s3_path: std::option::Option<std::string::String>,
        pub(crate) plugins_s3_object_version: std::option::Option<std::string::String>,
        pub(crate) requirements_s3_path: std::option::Option<std::string::String>,
        pub(crate) requirements_s3_object_version: std::option::Option<std::string::String>,
        pub(crate) airflow_configuration_options: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) environment_class: std::option::Option<std::string::String>,
        pub(crate) max_workers: std::option::Option<i32>,
        pub(crate) network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
        pub(crate) logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
        pub(crate) last_update: std::option::Option<crate::model::LastUpdate>,
        pub(crate) weekly_maintenance_window_start: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) webserver_access_mode: std::option::Option<crate::model::WebserverAccessMode>,
        pub(crate) min_workers: std::option::Option<i32>,
        pub(crate) schedulers: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the Amazon MWAA environment. Valid values:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - Indicates the request to create the environment is in progress.</p> </li>
        /// <li> <p> <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the environment could not be created.</p> </li>
        /// <li> <p> <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.</p> </li>
        /// <li> <p> <code>UPDATING</code> - Indicates the request to update the environment is in progress.</p> </li>
        /// <li> <p> <code>DELETING</code> - Indicates the request to delete the environment is in progress.</p> </li>
        /// <li> <p> <code>DELETED</code> - Indicates the request to delete the environment is complete, and the environment has been deleted.</p> </li>
        /// <li> <p> <code>UNAVAILABLE</code> - Indicates the request failed, but the environment was unable to rollback and is not in a stable state.</p> </li>
        /// <li> <p> <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the environment has rolled back successfully and is ready to use.</p> </li>
        /// </ul>
        /// <p>We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA troubleshooting</a>.</p>
        pub fn status(mut self, input: crate::model::EnvironmentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the Amazon MWAA environment. Valid values:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - Indicates the request to create the environment is in progress.</p> </li>
        /// <li> <p> <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the environment could not be created.</p> </li>
        /// <li> <p> <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.</p> </li>
        /// <li> <p> <code>UPDATING</code> - Indicates the request to update the environment is in progress.</p> </li>
        /// <li> <p> <code>DELETING</code> - Indicates the request to delete the environment is in progress.</p> </li>
        /// <li> <p> <code>DELETED</code> - Indicates the request to delete the environment is complete, and the environment has been deleted.</p> </li>
        /// <li> <p> <code>UNAVAILABLE</code> - Indicates the request failed, but the environment was unable to rollback and is not in a stable state.</p> </li>
        /// <li> <p> <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the environment has rolled back successfully and is ready to use.</p> </li>
        /// </ul>
        /// <p>We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA troubleshooting</a>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EnvironmentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon MWAA environment.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon MWAA environment.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The day and time the environment was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The day and time the environment was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Apache Airflow <i>Web server</i> host name for the Amazon MWAA environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/access-airflow-ui.html">Accessing the Apache Airflow UI</a>.</p>
        pub fn webserver_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.webserver_url = Some(input.into());
            self
        }
        /// <p>The Apache Airflow <i>Web server</i> host name for the Amazon MWAA environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/access-airflow-ui.html">Accessing the Apache Airflow UI</a>.</p>
        pub fn set_webserver_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.webserver_url = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access AWS resources in your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution role</a>.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access AWS resources in your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution role</a>.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the service-linked role of the environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-slr.html">Amazon MWAA Service-linked role</a>.</p>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the service-linked role of the environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-slr.html">Amazon MWAA Service-linked role</a>.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_role_arn = input;
            self
        }
        /// <p>The Key Management Service (KMS) encryption key used to encrypt the data in your environment.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p>The Key Management Service (KMS) encryption key used to encrypt the data in your environment.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// <p>The Apache Airflow version on your environment. For example, <code>v1.10.12</code>.</p>
        pub fn airflow_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.airflow_version = Some(input.into());
            self
        }
        /// <p>The Apache Airflow version on your environment. For example, <code>v1.10.12</code>.</p>
        pub fn set_airflow_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.airflow_version = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for Amazon MWAA</a>.</p>
        pub fn source_bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_bucket_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for Amazon MWAA</a>.</p>
        pub fn set_source_bucket_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_bucket_arn = input;
            self
        }
        /// <p>The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a>.</p>
        pub fn dag_s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.dag_s3_path = Some(input.into());
            self
        }
        /// <p>The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a>.</p>
        pub fn set_dag_s3_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dag_s3_path = input;
            self
        }
        /// <p>The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>
        pub fn plugins_s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.plugins_s3_path = Some(input.into());
            self
        }
        /// <p>The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>
        pub fn set_plugins_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.plugins_s3_path = input;
            self
        }
        /// <p>The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>
        pub fn plugins_s3_object_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.plugins_s3_object_version = Some(input.into());
            self
        }
        /// <p>The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>
        pub fn set_plugins_s3_object_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.plugins_s3_object_version = input;
            self
        }
        /// <p>The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>
        pub fn requirements_s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.requirements_s3_path = Some(input.into());
            self
        }
        /// <p>The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>
        pub fn set_requirements_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.requirements_s3_path = input;
            self
        }
        /// <p>The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>
        pub fn requirements_s3_object_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.requirements_s3_object_version = Some(input.into());
            self
        }
        /// <p>The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>
        pub fn set_requirements_s3_object_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.requirements_s3_object_version = input;
            self
        }
        /// Adds a key-value pair to `airflow_configuration_options`.
        ///
        /// To override the contents of this collection use [`set_airflow_configuration_options`](Self::set_airflow_configuration_options).
        ///
        /// <p>A list of key-value pairs containing the Apache Airflow configuration options attached to your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow configuration options</a>.</p>
        pub fn airflow_configuration_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.airflow_configuration_options.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.airflow_configuration_options = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs containing the Apache Airflow configuration options attached to your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow configuration options</a>.</p>
        pub fn set_airflow_configuration_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.airflow_configuration_options = input;
            self
        }
        /// <p>The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>, <code>mw1.large</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment class</a>.</p>
        pub fn environment_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_class = Some(input.into());
            self
        }
        /// <p>The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>, <code>mw1.large</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment class</a>.</p>
        pub fn set_environment_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_class = input;
            self
        }
        /// <p>The maximum number of workers that run in your environment. For example, <code>20</code>.</p>
        pub fn max_workers(mut self, input: i32) -> Self {
            self.max_workers = Some(input);
            self
        }
        /// <p>The maximum number of workers that run in your environment. For example, <code>20</code>.</p>
        pub fn set_max_workers(mut self, input: std::option::Option<i32>) -> Self {
            self.max_workers = input;
            self
        }
        /// <p>The VPC networking components used to secure and enable network traffic between the AWS resources for your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>
        pub fn network_configuration(mut self, input: crate::model::NetworkConfiguration) -> Self {
            self.network_configuration = Some(input);
            self
        }
        /// <p>The VPC networking components used to secure and enable network traffic between the AWS resources for your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>
        pub fn set_network_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkConfiguration>,
        ) -> Self {
            self.network_configuration = input;
            self
        }
        /// <p>The Apache Airflow logs being sent to CloudWatch Logs: <code>DagProcessingLogs</code>, <code>SchedulerLogs</code>, <code>TaskLogs</code>, <code>WebserverLogs</code>, <code>WorkerLogs</code>.</p>
        pub fn logging_configuration(mut self, input: crate::model::LoggingConfiguration) -> Self {
            self.logging_configuration = Some(input);
            self
        }
        /// <p>The Apache Airflow logs being sent to CloudWatch Logs: <code>DagProcessingLogs</code>, <code>SchedulerLogs</code>, <code>TaskLogs</code>, <code>WebserverLogs</code>, <code>WorkerLogs</code>.</p>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.logging_configuration = input;
            self
        }
        /// <p>The status of the last update on the environment, and any errors that were encountered.</p>
        pub fn last_update(mut self, input: crate::model::LastUpdate) -> Self {
            self.last_update = Some(input);
            self
        }
        /// <p>The status of the last update on the environment, and any errors that were encountered.</p>
        pub fn set_last_update(
            mut self,
            input: std::option::Option<crate::model::LastUpdate>,
        ) -> Self {
            self.last_update = input;
            self
        }
        /// <p>The day and time of the week that weekly maintenance updates are scheduled. For example: <code>TUE:03:30</code>.</p>
        pub fn weekly_maintenance_window_start(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_window_start = Some(input.into());
            self
        }
        /// <p>The day and time of the week that weekly maintenance updates are scheduled. For example: <code>TUE:03:30</code>.</p>
        pub fn set_weekly_maintenance_window_start(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_window_start = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value tag pairs associated to your environment. For example, <code>"Environment": "Staging"</code>. To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The key-value tag pairs associated to your environment. For example, <code>"Environment": "Staging"</code>. To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Apache Airflow <i>Web server</i> access mode. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access modes</a>.</p>
        pub fn webserver_access_mode(mut self, input: crate::model::WebserverAccessMode) -> Self {
            self.webserver_access_mode = Some(input);
            self
        }
        /// <p>The Apache Airflow <i>Web server</i> access mode. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access modes</a>.</p>
        pub fn set_webserver_access_mode(
            mut self,
            input: std::option::Option<crate::model::WebserverAccessMode>,
        ) -> Self {
            self.webserver_access_mode = input;
            self
        }
        /// <p>The minimum number of workers that run in your environment. For example, <code>2</code>.</p>
        pub fn min_workers(mut self, input: i32) -> Self {
            self.min_workers = Some(input);
            self
        }
        /// <p>The minimum number of workers that run in your environment. For example, <code>2</code>.</p>
        pub fn set_min_workers(mut self, input: std::option::Option<i32>) -> Self {
            self.min_workers = input;
            self
        }
        /// <p>The number of Apache Airflow schedulers that run in your Amazon MWAA environment.</p>
        pub fn schedulers(mut self, input: i32) -> Self {
            self.schedulers = Some(input);
            self
        }
        /// <p>The number of Apache Airflow schedulers that run in your Amazon MWAA environment.</p>
        pub fn set_schedulers(mut self, input: std::option::Option<i32>) -> Self {
            self.schedulers = input;
            self
        }
        /// Consumes the builder and constructs a [`Environment`](crate::model::Environment)
        pub fn build(self) -> crate::model::Environment {
            crate::model::Environment {
                name: self.name,
                status: self.status,
                arn: self.arn,
                created_at: self.created_at,
                webserver_url: self.webserver_url,
                execution_role_arn: self.execution_role_arn,
                service_role_arn: self.service_role_arn,
                kms_key: self.kms_key,
                airflow_version: self.airflow_version,
                source_bucket_arn: self.source_bucket_arn,
                dag_s3_path: self.dag_s3_path,
                plugins_s3_path: self.plugins_s3_path,
                plugins_s3_object_version: self.plugins_s3_object_version,
                requirements_s3_path: self.requirements_s3_path,
                requirements_s3_object_version: self.requirements_s3_object_version,
                airflow_configuration_options: self.airflow_configuration_options,
                environment_class: self.environment_class,
                max_workers: self.max_workers,
                network_configuration: self.network_configuration,
                logging_configuration: self.logging_configuration,
                last_update: self.last_update,
                weekly_maintenance_window_start: self.weekly_maintenance_window_start,
                tags: self.tags,
                webserver_access_mode: self.webserver_access_mode,
                min_workers: self.min_workers,
                schedulers: self.schedulers,
            }
        }
    }
}
impl Environment {
    /// Creates a new builder-style object to manufacture [`Environment`](crate::model::Environment)
    pub fn builder() -> crate::model::environment::Builder {
        crate::model::environment::Builder::default()
    }
}

/// <p>The status of the last update on the environment, and any errors that were encountered.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LastUpdate {
    /// <p>The status of the last update on the environment. Valid values: <code>SUCCESS</code>, <code>PENDING</code>, <code>FAILED</code>.</p>
    pub status: std::option::Option<crate::model::UpdateStatus>,
    /// <p>The day and time of the last update on the environment.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The error that was encountered during the last update of the environment.</p>
    pub error: std::option::Option<crate::model::UpdateError>,
}
impl LastUpdate {
    /// <p>The status of the last update on the environment. Valid values: <code>SUCCESS</code>, <code>PENDING</code>, <code>FAILED</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::UpdateStatus> {
        self.status.as_ref()
    }
    /// <p>The day and time of the last update on the environment.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The error that was encountered during the last update of the environment.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::UpdateError> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for LastUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LastUpdate");
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`LastUpdate`](crate::model::LastUpdate)
pub mod last_update {
    /// A builder for [`LastUpdate`](crate::model::LastUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::UpdateStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) error: std::option::Option<crate::model::UpdateError>,
    }
    impl Builder {
        /// <p>The status of the last update on the environment. Valid values: <code>SUCCESS</code>, <code>PENDING</code>, <code>FAILED</code>.</p>
        pub fn status(mut self, input: crate::model::UpdateStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the last update on the environment. Valid values: <code>SUCCESS</code>, <code>PENDING</code>, <code>FAILED</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::UpdateStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The day and time of the last update on the environment.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The day and time of the last update on the environment.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The error that was encountered during the last update of the environment.</p>
        pub fn error(mut self, input: crate::model::UpdateError) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>The error that was encountered during the last update of the environment.</p>
        pub fn set_error(mut self, input: std::option::Option<crate::model::UpdateError>) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`LastUpdate`](crate::model::LastUpdate)
        pub fn build(self) -> crate::model::LastUpdate {
            crate::model::LastUpdate {
                status: self.status,
                created_at: self.created_at,
                error: self.error,
            }
        }
    }
}
impl LastUpdate {
    /// Creates a new builder-style object to manufacture [`LastUpdate`](crate::model::LastUpdate)
    pub fn builder() -> crate::model::last_update::Builder {
        crate::model::last_update::Builder::default()
    }
}

/// <p>An object containing the error encountered with the last update: <code>ErrorCode</code>, <code>ErrorMessage</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateError {
    /// <p>The error code that corresponds to the error with the last update.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message that corresponds to the error code.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl UpdateError {
    /// <p>The error code that corresponds to the error with the last update.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The error message that corresponds to the error code.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for UpdateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateError");
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`UpdateError`](crate::model::UpdateError)
pub mod update_error {
    /// A builder for [`UpdateError`](crate::model::UpdateError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code that corresponds to the error with the last update.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code that corresponds to the error with the last update.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message that corresponds to the error code.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message that corresponds to the error code.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateError`](crate::model::UpdateError)
        pub fn build(self) -> crate::model::UpdateError {
            crate::model::UpdateError {
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl UpdateError {
    /// Creates a new builder-style object to manufacture [`UpdateError`](crate::model::UpdateError)
    pub fn builder() -> crate::model::update_error::Builder {
        crate::model::update_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UpdateStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UpdateStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => UpdateStatus::Failed,
            "PENDING" => UpdateStatus::Pending,
            "SUCCESS" => UpdateStatus::Success,
            other => UpdateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UpdateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UpdateStatus::from(s))
    }
}
impl UpdateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UpdateStatus::Failed => "FAILED",
            UpdateStatus::Pending => "PENDING",
            UpdateStatus::Success => "SUCCESS",
            UpdateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "PENDING", "SUCCESS"]
    }
}
impl AsRef<str> for UpdateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines the Apache Airflow logs to send to CloudWatch Logs: <code>DagProcessingLogs</code>, <code>SchedulerLogs</code>, <code>TaskLogs</code>, <code>WebserverLogs</code>, <code>WorkerLogs</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoggingConfiguration {
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub dag_processing_logs: std::option::Option<crate::model::ModuleLoggingConfiguration>,
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub scheduler_logs: std::option::Option<crate::model::ModuleLoggingConfiguration>,
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub webserver_logs: std::option::Option<crate::model::ModuleLoggingConfiguration>,
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub worker_logs: std::option::Option<crate::model::ModuleLoggingConfiguration>,
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub task_logs: std::option::Option<crate::model::ModuleLoggingConfiguration>,
}
impl LoggingConfiguration {
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub fn dag_processing_logs(
        &self,
    ) -> std::option::Option<&crate::model::ModuleLoggingConfiguration> {
        self.dag_processing_logs.as_ref()
    }
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub fn scheduler_logs(&self) -> std::option::Option<&crate::model::ModuleLoggingConfiguration> {
        self.scheduler_logs.as_ref()
    }
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub fn webserver_logs(&self) -> std::option::Option<&crate::model::ModuleLoggingConfiguration> {
        self.webserver_logs.as_ref()
    }
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub fn worker_logs(&self) -> std::option::Option<&crate::model::ModuleLoggingConfiguration> {
        self.worker_logs.as_ref()
    }
    /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
    pub fn task_logs(&self) -> std::option::Option<&crate::model::ModuleLoggingConfiguration> {
        self.task_logs.as_ref()
    }
}
impl std::fmt::Debug for LoggingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoggingConfiguration");
        formatter.field("dag_processing_logs", &self.dag_processing_logs);
        formatter.field("scheduler_logs", &self.scheduler_logs);
        formatter.field("webserver_logs", &self.webserver_logs);
        formatter.field("worker_logs", &self.worker_logs);
        formatter.field("task_logs", &self.task_logs);
        formatter.finish()
    }
}
/// See [`LoggingConfiguration`](crate::model::LoggingConfiguration)
pub mod logging_configuration {
    /// A builder for [`LoggingConfiguration`](crate::model::LoggingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dag_processing_logs:
            std::option::Option<crate::model::ModuleLoggingConfiguration>,
        pub(crate) scheduler_logs: std::option::Option<crate::model::ModuleLoggingConfiguration>,
        pub(crate) webserver_logs: std::option::Option<crate::model::ModuleLoggingConfiguration>,
        pub(crate) worker_logs: std::option::Option<crate::model::ModuleLoggingConfiguration>,
        pub(crate) task_logs: std::option::Option<crate::model::ModuleLoggingConfiguration>,
    }
    impl Builder {
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn dag_processing_logs(
            mut self,
            input: crate::model::ModuleLoggingConfiguration,
        ) -> Self {
            self.dag_processing_logs = Some(input);
            self
        }
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn set_dag_processing_logs(
            mut self,
            input: std::option::Option<crate::model::ModuleLoggingConfiguration>,
        ) -> Self {
            self.dag_processing_logs = input;
            self
        }
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn scheduler_logs(mut self, input: crate::model::ModuleLoggingConfiguration) -> Self {
            self.scheduler_logs = Some(input);
            self
        }
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn set_scheduler_logs(
            mut self,
            input: std::option::Option<crate::model::ModuleLoggingConfiguration>,
        ) -> Self {
            self.scheduler_logs = input;
            self
        }
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn webserver_logs(mut self, input: crate::model::ModuleLoggingConfiguration) -> Self {
            self.webserver_logs = Some(input);
            self
        }
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn set_webserver_logs(
            mut self,
            input: std::option::Option<crate::model::ModuleLoggingConfiguration>,
        ) -> Self {
            self.webserver_logs = input;
            self
        }
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn worker_logs(mut self, input: crate::model::ModuleLoggingConfiguration) -> Self {
            self.worker_logs = Some(input);
            self
        }
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn set_worker_logs(
            mut self,
            input: std::option::Option<crate::model::ModuleLoggingConfiguration>,
        ) -> Self {
            self.worker_logs = input;
            self
        }
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn task_logs(mut self, input: crate::model::ModuleLoggingConfiguration) -> Self {
            self.task_logs = Some(input);
            self
        }
        /// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
        pub fn set_task_logs(
            mut self,
            input: std::option::Option<crate::model::ModuleLoggingConfiguration>,
        ) -> Self {
            self.task_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`LoggingConfiguration`](crate::model::LoggingConfiguration)
        pub fn build(self) -> crate::model::LoggingConfiguration {
            crate::model::LoggingConfiguration {
                dag_processing_logs: self.dag_processing_logs,
                scheduler_logs: self.scheduler_logs,
                webserver_logs: self.webserver_logs,
                worker_logs: self.worker_logs,
                task_logs: self.task_logs,
            }
        }
    }
}
impl LoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`LoggingConfiguration`](crate::model::LoggingConfiguration)
    pub fn builder() -> crate::model::logging_configuration::Builder {
        crate::model::logging_configuration::Builder::default()
    }
}

/// <p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModuleLoggingConfiguration {
    /// <p>Indicates whether to enable the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) in CloudWatch Logs.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>Defines the Apache Airflow logs to send for the log type (e.g. <code>DagProcessingLogs</code>) to CloudWatch Logs. Valid values: <code>CRITICAL</code>, <code>ERROR</code>, <code>WARNING</code>, <code>INFO</code>.</p>
    pub log_level: std::option::Option<crate::model::LoggingLevel>,
    /// <p>The Amazon Resource Name (ARN) for the CloudWatch Logs group where the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) is published. For example, <code>arn:aws:logs:us-east-1:123456789012:log-group:airflow-MyMWAAEnvironment-MwaaEnvironment-DAGProcessing:*</code>.</p>
    pub cloud_watch_log_group_arn: std::option::Option<std::string::String>,
}
impl ModuleLoggingConfiguration {
    /// <p>Indicates whether to enable the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) in CloudWatch Logs.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>Defines the Apache Airflow logs to send for the log type (e.g. <code>DagProcessingLogs</code>) to CloudWatch Logs. Valid values: <code>CRITICAL</code>, <code>ERROR</code>, <code>WARNING</code>, <code>INFO</code>.</p>
    pub fn log_level(&self) -> std::option::Option<&crate::model::LoggingLevel> {
        self.log_level.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for the CloudWatch Logs group where the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) is published. For example, <code>arn:aws:logs:us-east-1:123456789012:log-group:airflow-MyMWAAEnvironment-MwaaEnvironment-DAGProcessing:*</code>.</p>
    pub fn cloud_watch_log_group_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_log_group_arn.as_deref()
    }
}
impl std::fmt::Debug for ModuleLoggingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModuleLoggingConfiguration");
        formatter.field("enabled", &self.enabled);
        formatter.field("log_level", &self.log_level);
        formatter.field("cloud_watch_log_group_arn", &self.cloud_watch_log_group_arn);
        formatter.finish()
    }
}
/// See [`ModuleLoggingConfiguration`](crate::model::ModuleLoggingConfiguration)
pub mod module_logging_configuration {
    /// A builder for [`ModuleLoggingConfiguration`](crate::model::ModuleLoggingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) log_level: std::option::Option<crate::model::LoggingLevel>,
        pub(crate) cloud_watch_log_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether to enable the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) in CloudWatch Logs.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether to enable the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) in CloudWatch Logs.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>Defines the Apache Airflow logs to send for the log type (e.g. <code>DagProcessingLogs</code>) to CloudWatch Logs. Valid values: <code>CRITICAL</code>, <code>ERROR</code>, <code>WARNING</code>, <code>INFO</code>.</p>
        pub fn log_level(mut self, input: crate::model::LoggingLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// <p>Defines the Apache Airflow logs to send for the log type (e.g. <code>DagProcessingLogs</code>) to CloudWatch Logs. Valid values: <code>CRITICAL</code>, <code>ERROR</code>, <code>WARNING</code>, <code>INFO</code>.</p>
        pub fn set_log_level(
            mut self,
            input: std::option::Option<crate::model::LoggingLevel>,
        ) -> Self {
            self.log_level = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the CloudWatch Logs group where the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) is published. For example, <code>arn:aws:logs:us-east-1:123456789012:log-group:airflow-MyMWAAEnvironment-MwaaEnvironment-DAGProcessing:*</code>.</p>
        pub fn cloud_watch_log_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_log_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the CloudWatch Logs group where the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) is published. For example, <code>arn:aws:logs:us-east-1:123456789012:log-group:airflow-MyMWAAEnvironment-MwaaEnvironment-DAGProcessing:*</code>.</p>
        pub fn set_cloud_watch_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_log_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ModuleLoggingConfiguration`](crate::model::ModuleLoggingConfiguration)
        pub fn build(self) -> crate::model::ModuleLoggingConfiguration {
            crate::model::ModuleLoggingConfiguration {
                enabled: self.enabled,
                log_level: self.log_level,
                cloud_watch_log_group_arn: self.cloud_watch_log_group_arn,
            }
        }
    }
}
impl ModuleLoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`ModuleLoggingConfiguration`](crate::model::ModuleLoggingConfiguration)
    pub fn builder() -> crate::model::module_logging_configuration::Builder {
        crate::model::module_logging_configuration::Builder::default()
    }
}

/// <p>The VPC networking components used to secure and enable network traffic between the AWS resources for your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkConfiguration {
    /// <p>A list of 2 subnet IDs. <b>Required</b> to create an environment. Must be private subnets in two different availability zones. A subnet must be attached to the same VPC as the security group.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of 1 or more security group IDs. Accepts up to 5 security group IDs. A security group must be attached to the same VPC as the subnets. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-security.html">Security in your VPC on Amazon MWAA</a>.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl NetworkConfiguration {
    /// <p>A list of 2 subnet IDs. <b>Required</b> to create an environment. Must be private subnets in two different availability zones. A subnet must be attached to the same VPC as the security group.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>A list of 1 or more security group IDs. Accepts up to 5 security group IDs. A security group must be attached to the same VPC as the subnets. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-security.html">Security in your VPC on Amazon MWAA</a>.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
}
impl std::fmt::Debug for NetworkConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkConfiguration");
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.finish()
    }
}
/// See [`NetworkConfiguration`](crate::model::NetworkConfiguration)
pub mod network_configuration {
    /// A builder for [`NetworkConfiguration`](crate::model::NetworkConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of 2 subnet IDs. <b>Required</b> to create an environment. Must be private subnets in two different availability zones. A subnet must be attached to the same VPC as the security group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of 2 subnet IDs. <b>Required</b> to create an environment. Must be private subnets in two different availability zones. A subnet must be attached to the same VPC as the security group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of 1 or more security group IDs. Accepts up to 5 security group IDs. A security group must be attached to the same VPC as the subnets. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-security.html">Security in your VPC on Amazon MWAA</a>.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>A list of 1 or more security group IDs. Accepts up to 5 security group IDs. A security group must be attached to the same VPC as the subnets. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-security.html">Security in your VPC on Amazon MWAA</a>.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkConfiguration`](crate::model::NetworkConfiguration)
        pub fn build(self) -> crate::model::NetworkConfiguration {
            crate::model::NetworkConfiguration {
                subnet_ids: self.subnet_ids,
                security_group_ids: self.security_group_ids,
            }
        }
    }
}
impl NetworkConfiguration {
    /// Creates a new builder-style object to manufacture [`NetworkConfiguration`](crate::model::NetworkConfiguration)
    pub fn builder() -> crate::model::network_configuration::Builder {
        crate::model::network_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EnvironmentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Unavailable,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EnvironmentStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => EnvironmentStatus::Available,
            "CREATE_FAILED" => EnvironmentStatus::CreateFailed,
            "CREATING" => EnvironmentStatus::Creating,
            "DELETED" => EnvironmentStatus::Deleted,
            "DELETING" => EnvironmentStatus::Deleting,
            "UNAVAILABLE" => EnvironmentStatus::Unavailable,
            "UPDATE_FAILED" => EnvironmentStatus::UpdateFailed,
            "UPDATING" => EnvironmentStatus::Updating,
            other => EnvironmentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EnvironmentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EnvironmentStatus::from(s))
    }
}
impl EnvironmentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EnvironmentStatus::Available => "AVAILABLE",
            EnvironmentStatus::CreateFailed => "CREATE_FAILED",
            EnvironmentStatus::Creating => "CREATING",
            EnvironmentStatus::Deleted => "DELETED",
            EnvironmentStatus::Deleting => "DELETING",
            EnvironmentStatus::Unavailable => "UNAVAILABLE",
            EnvironmentStatus::UpdateFailed => "UPDATE_FAILED",
            EnvironmentStatus::Updating => "UPDATING",
            EnvironmentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "CREATE_FAILED",
            "CREATING",
            "DELETED",
            "DELETING",
            "UNAVAILABLE",
            "UPDATE_FAILED",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for EnvironmentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
