// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AmazonMWAA
///
/// Client for invoking operations on AmazonMWAA. Each operation on AmazonMWAA is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_mwaa::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_mwaa::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_mwaa::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateCliToken`](crate::client::fluent_builders::CreateCliToken) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateCliToken::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateCliToken::set_name): <p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
    /// - On success, responds with [`CreateCliTokenOutput`](crate::output::CreateCliTokenOutput) with field(s):
    ///   - [`cli_token(Option<String>)`](crate::output::CreateCliTokenOutput::cli_token): <p>An Airflow CLI login token.</p>
    ///   - [`web_server_hostname(Option<String>)`](crate::output::CreateCliTokenOutput::web_server_hostname): <p>The Airflow web server hostname for the environment.</p>
    /// - On failure, responds with [`SdkError<CreateCliTokenError>`](crate::error::CreateCliTokenError)
    pub fn create_cli_token(&self) -> fluent_builders::CreateCliToken {
        fluent_builders::CreateCliToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEnvironment`](crate::client::fluent_builders::CreateEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_name): <p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
    ///   - [`execution_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::execution_role_arn) / [`set_execution_role_arn(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_execution_role_arn): <p>The Amazon Resource Name (ARN) of the execution role for your environment. An execution role is an Amazon Web Services Identity and Access Management (IAM) role that grants MWAA permission to access Amazon Web Services services and resources used by your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution role</a>.</p>
    ///   - [`source_bucket_arn(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::source_bucket_arn) / [`set_source_bucket_arn(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_source_bucket_arn): <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for Amazon MWAA</a>.</p>
    ///   - [`dag_s3_path(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::dag_s3_path) / [`set_dag_s3_path(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_dag_s3_path): <p>The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a>.</p>
    ///   - [`network_configuration(NetworkConfiguration)`](crate::client::fluent_builders::CreateEnvironment::network_configuration) / [`set_network_configuration(Option<NetworkConfiguration>)`](crate::client::fluent_builders::CreateEnvironment::set_network_configuration): <p>The VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>
    ///   - [`plugins_s3_path(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::plugins_s3_path) / [`set_plugins_s3_path(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_plugins_s3_path): <p>The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code>. If specified, then the plugins.zip version is required. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>
    ///   - [`plugins_s3_object_version(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::plugins_s3_object_version) / [`set_plugins_s3_object_version(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_plugins_s3_object_version): <p>The version of the plugins.zip file on your Amazon S3 bucket. A version must be specified each time a plugins.zip file is updated. To learn more, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>
    ///   - [`requirements_s3_path(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::requirements_s3_path) / [`set_requirements_s3_path(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_requirements_s3_path): <p>The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code>. If specified, then a file version is required. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>
    ///   - [`requirements_s3_object_version(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::requirements_s3_object_version) / [`set_requirements_s3_object_version(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_requirements_s3_object_version): <p>The version of the requirements.txt file on your Amazon S3 bucket. A version must be specified each time a requirements.txt file is updated. To learn more, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>
    ///   - [`airflow_configuration_options(HashMap<String, String>)`](crate::client::fluent_builders::CreateEnvironment::airflow_configuration_options) / [`set_airflow_configuration_options(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateEnvironment::set_airflow_configuration_options): <p>A list of key-value pairs containing the Apache Airflow configuration options you want to attach to your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow configuration options</a>.</p>
    ///   - [`environment_class(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::environment_class) / [`set_environment_class(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_environment_class): <p>The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>, <code>mw1.large</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment class</a>.</p>
    ///   - [`max_workers(i32)`](crate::client::fluent_builders::CreateEnvironment::max_workers) / [`set_max_workers(Option<i32>)`](crate::client::fluent_builders::CreateEnvironment::set_max_workers): <p>The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. For example, <code>20</code>. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in <code>MinWorkers</code>.</p>
    ///   - [`kms_key(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::kms_key) / [`set_kms_key(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_kms_key): <p>The Amazon Web Services Key Management Service (KMS) key to encrypt the data in your environment. You can use an Amazon Web Services owned CMK, or a Customer managed CMK (advanced). To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/create-environment.html">Create an Amazon MWAA environment</a>.</p>
    ///   - [`airflow_version(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::airflow_version) / [`set_airflow_version(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_airflow_version): <p>The Apache Airflow version for your environment. If no value is specified, defaults to the latest version. Valid values: <code>1.10.12</code>, <code>2.0.2</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/airflow-versions.html">Apache Airflow versions on Amazon Managed Workflows for Apache Airflow (MWAA)</a>.</p>
    ///   - [`logging_configuration(LoggingConfigurationInput)`](crate::client::fluent_builders::CreateEnvironment::logging_configuration) / [`set_logging_configuration(Option<LoggingConfigurationInput>)`](crate::client::fluent_builders::CreateEnvironment::set_logging_configuration): <p>Defines the Apache Airflow logs to send to CloudWatch Logs.</p>
    ///   - [`weekly_maintenance_window_start(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::weekly_maintenance_window_start) / [`set_weekly_maintenance_window_start(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_weekly_maintenance_window_start): <p>The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time to start weekly maintenance updates of your environment in the following format: <code>DAY:HH:MM</code>. For example: <code>TUE:03:30</code>. You can specify a start time in 30 minute increments only.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateEnvironment::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateEnvironment::set_tags): <p>The key-value tag pairs you want to associate to your environment. For example, <code>"Environment": "Staging"</code>. To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
    ///   - [`webserver_access_mode(WebserverAccessMode)`](crate::client::fluent_builders::CreateEnvironment::webserver_access_mode) / [`set_webserver_access_mode(Option<WebserverAccessMode>)`](crate::client::fluent_builders::CreateEnvironment::set_webserver_access_mode): <p>The Apache Airflow <i>Web server</i> access mode. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access modes</a>.</p>
    ///   - [`min_workers(i32)`](crate::client::fluent_builders::CreateEnvironment::min_workers) / [`set_min_workers(Option<i32>)`](crate::client::fluent_builders::CreateEnvironment::set_min_workers): <p>The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the <code>MinWorkers</code> field. For example, <code>2</code>.</p>
    ///   - [`schedulers(i32)`](crate::client::fluent_builders::CreateEnvironment::schedulers) / [`set_schedulers(Option<i32>)`](crate::client::fluent_builders::CreateEnvironment::set_schedulers): <p>The number of Apache Airflow schedulers to run in your environment. Valid values:</p>  <ul>   <li> <p>v2.0.2 - Accepts between 2 to 5. Defaults to 2.</p> </li>   <li> <p>v1.10.12 - Accepts 1.</p> </li>  </ul>
    /// - On success, responds with [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateEnvironmentOutput::arn): <p>The Amazon Resource Name (ARN) returned in the response for the environment.</p>
    /// - On failure, responds with [`SdkError<CreateEnvironmentError>`](crate::error::CreateEnvironmentError)
    pub fn create_environment(&self) -> fluent_builders::CreateEnvironment {
        fluent_builders::CreateEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateWebLoginToken`](crate::client::fluent_builders::CreateWebLoginToken) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateWebLoginToken::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateWebLoginToken::set_name): <p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
    /// - On success, responds with [`CreateWebLoginTokenOutput`](crate::output::CreateWebLoginTokenOutput) with field(s):
    ///   - [`web_token(Option<String>)`](crate::output::CreateWebLoginTokenOutput::web_token): <p>An Airflow web server login token.</p>
    ///   - [`web_server_hostname(Option<String>)`](crate::output::CreateWebLoginTokenOutput::web_server_hostname): <p>The Airflow web server hostname for the environment.</p>
    /// - On failure, responds with [`SdkError<CreateWebLoginTokenError>`](crate::error::CreateWebLoginTokenError)
    pub fn create_web_login_token(&self) -> fluent_builders::CreateWebLoginToken {
        fluent_builders::CreateWebLoginToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEnvironment`](crate::client::fluent_builders::DeleteEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteEnvironment::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteEnvironment::set_name): <p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
    /// - On success, responds with [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput)

    /// - On failure, responds with [`SdkError<DeleteEnvironmentError>`](crate::error::DeleteEnvironmentError)
    pub fn delete_environment(&self) -> fluent_builders::DeleteEnvironment {
        fluent_builders::DeleteEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEnvironment`](crate::client::fluent_builders::GetEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetEnvironment::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetEnvironment::set_name): <p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
    /// - On success, responds with [`GetEnvironmentOutput`](crate::output::GetEnvironmentOutput) with field(s):
    ///   - [`environment(Option<Environment>)`](crate::output::GetEnvironmentOutput::environment): <p>An object containing all available details about the environment.</p>
    /// - On failure, responds with [`SdkError<GetEnvironmentError>`](crate::error::GetEnvironmentError)
    pub fn get_environment(&self) -> fluent_builders::GetEnvironment {
        fluent_builders::GetEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEnvironments`](crate::client::fluent_builders::ListEnvironments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEnvironments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEnvironments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEnvironments::set_next_token): <p>Retrieves the next page of the results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEnvironments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEnvironments::set_max_results): <p>The maximum number of results to retrieve per page. For example, <code>5</code> environments per page.</p>
    /// - On success, responds with [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput) with field(s):
    ///   - [`environments(Option<Vec<String>>)`](crate::output::ListEnvironmentsOutput::environments): <p>Returns a list of Amazon MWAA environments.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEnvironmentsOutput::next_token): <p>Retrieves the next page of the results.</p>
    /// - On failure, responds with [`SdkError<ListEnvironmentsError>`](crate::error::ListEnvironmentsError)
    pub fn list_environments(&self) -> fluent_builders::ListEnvironments {
        fluent_builders::ListEnvironments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the Amazon MWAA environment. For example, <code>arn:aws:airflow:us-east-1:123456789012:environment/MyMWAAEnvironment</code>.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The key-value tag pairs associated to your environment. To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PublishMetrics`](crate::client::fluent_builders::PublishMetrics) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::PublishMetrics::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::PublishMetrics::set_environment_name): <p> <b>Internal only</b>. The name of the environment.</p>
    ///   - [`metric_data(Vec<MetricDatum>)`](crate::client::fluent_builders::PublishMetrics::metric_data) / [`set_metric_data(Option<Vec<MetricDatum>>)`](crate::client::fluent_builders::PublishMetrics::set_metric_data): <p> <b>Internal only</b>. Publishes metrics to Amazon CloudWatch. To learn more about the metrics published to Amazon CloudWatch, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/cw-metrics.html">Amazon MWAA performance metrics in Amazon CloudWatch</a>.</p>
    /// - On success, responds with [`PublishMetricsOutput`](crate::output::PublishMetricsOutput)

    /// - On failure, responds with [`SdkError<PublishMetricsError>`](crate::error::PublishMetricsError)
    pub fn publish_metrics(&self) -> fluent_builders::PublishMetrics {
        fluent_builders::PublishMetrics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the Amazon MWAA environment. For example, <code>arn:aws:airflow:us-east-1:123456789012:environment/MyMWAAEnvironment</code>.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The key-value tag pairs you want to associate to your environment. For example, <code>"Environment": "Staging"</code>. To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the Amazon MWAA environment. For example, <code>arn:aws:airflow:us-east-1:123456789012:environment/MyMWAAEnvironment</code>.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The key-value tag pair you want to remove. For example, <code>"Environment": "Staging"</code>. </p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEnvironment`](crate::client::fluent_builders::UpdateEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_name): <p>The name of your Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
    ///   - [`execution_role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::execution_role_arn) / [`set_execution_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_execution_role_arn): <p>The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web Services resources in your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution role</a>.</p>
    ///   - [`airflow_version(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::airflow_version) / [`set_airflow_version(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_airflow_version): <p>The Apache Airflow version for your environment. If no value is specified, defaults to the latest version. Valid values: <code>1.10.12</code>, <code>2.0.2</code>.</p>
    ///   - [`source_bucket_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::source_bucket_arn) / [`set_source_bucket_arn(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_source_bucket_arn): <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for Amazon MWAA</a>.</p>
    ///   - [`dag_s3_path(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::dag_s3_path) / [`set_dag_s3_path(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_dag_s3_path): <p>The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a>.</p>
    ///   - [`plugins_s3_path(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::plugins_s3_path) / [`set_plugins_s3_path(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_plugins_s3_path): <p>The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code>. If specified, then the plugins.zip version is required. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>
    ///   - [`plugins_s3_object_version(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::plugins_s3_object_version) / [`set_plugins_s3_object_version(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_plugins_s3_object_version): <p>The version of the plugins.zip file on your Amazon S3 bucket. A version must be specified each time a plugins.zip file is updated. To learn more, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>
    ///   - [`requirements_s3_path(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::requirements_s3_path) / [`set_requirements_s3_path(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_requirements_s3_path): <p>The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code>. If specified, then a file version is required. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>
    ///   - [`requirements_s3_object_version(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::requirements_s3_object_version) / [`set_requirements_s3_object_version(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_requirements_s3_object_version): <p>The version of the requirements.txt file on your Amazon S3 bucket. A version must be specified each time a requirements.txt file is updated. To learn more, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>
    ///   - [`airflow_configuration_options(HashMap<String, String>)`](crate::client::fluent_builders::UpdateEnvironment::airflow_configuration_options) / [`set_airflow_configuration_options(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateEnvironment::set_airflow_configuration_options): <p>A list of key-value pairs containing the Apache Airflow configuration options you want to attach to your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow configuration options</a>.</p>
    ///   - [`environment_class(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::environment_class) / [`set_environment_class(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_environment_class): <p>The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>, <code>mw1.large</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment class</a>.</p>
    ///   - [`max_workers(i32)`](crate::client::fluent_builders::UpdateEnvironment::max_workers) / [`set_max_workers(Option<i32>)`](crate::client::fluent_builders::UpdateEnvironment::set_max_workers): <p>The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. For example, <code>20</code>. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in <code>MinWorkers</code>.</p>
    ///   - [`network_configuration(UpdateNetworkConfigurationInput)`](crate::client::fluent_builders::UpdateEnvironment::network_configuration) / [`set_network_configuration(Option<UpdateNetworkConfigurationInput>)`](crate::client::fluent_builders::UpdateEnvironment::set_network_configuration): <p>The VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>
    ///   - [`logging_configuration(LoggingConfigurationInput)`](crate::client::fluent_builders::UpdateEnvironment::logging_configuration) / [`set_logging_configuration(Option<LoggingConfigurationInput>)`](crate::client::fluent_builders::UpdateEnvironment::set_logging_configuration): <p>The Apache Airflow log types to send to CloudWatch Logs.</p>
    ///   - [`weekly_maintenance_window_start(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::weekly_maintenance_window_start) / [`set_weekly_maintenance_window_start(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_weekly_maintenance_window_start): <p>The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time to start weekly maintenance updates of your environment in the following format: <code>DAY:HH:MM</code>. For example: <code>TUE:03:30</code>. You can specify a start time in 30 minute increments only.</p>
    ///   - [`webserver_access_mode(WebserverAccessMode)`](crate::client::fluent_builders::UpdateEnvironment::webserver_access_mode) / [`set_webserver_access_mode(Option<WebserverAccessMode>)`](crate::client::fluent_builders::UpdateEnvironment::set_webserver_access_mode): <p>The Apache Airflow <i>Web server</i> access mode. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access modes</a>.</p>
    ///   - [`min_workers(i32)`](crate::client::fluent_builders::UpdateEnvironment::min_workers) / [`set_min_workers(Option<i32>)`](crate::client::fluent_builders::UpdateEnvironment::set_min_workers): <p>The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the <code>MinWorkers</code> field. For example, <code>2</code>.</p>
    ///   - [`schedulers(i32)`](crate::client::fluent_builders::UpdateEnvironment::schedulers) / [`set_schedulers(Option<i32>)`](crate::client::fluent_builders::UpdateEnvironment::set_schedulers): <p>The number of Apache Airflow schedulers to run in your Amazon MWAA environment.</p>
    /// - On success, responds with [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdateEnvironmentOutput::arn): <p>The Amazon Resource Name (ARN) of the Amazon MWAA environment. For example, <code>arn:aws:airflow:us-east-1:123456789012:environment/MyMWAAEnvironment</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateEnvironmentError>`](crate::error::UpdateEnvironmentError)
    pub fn update_environment(&self) -> fluent_builders::UpdateEnvironment {
        fluent_builders::UpdateEnvironment::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateCliToken`.
    ///
    /// <p>Creates a CLI token for the Airflow CLI. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/call-mwaa-apis-cli.html">Creating an Apache Airflow CLI token</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCliToken {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_cli_token_input::Builder,
    }
    impl CreateCliToken {
        /// Creates a new `CreateCliToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCliTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCliTokenError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEnvironment`.
    ///
    /// <p>Creates an Amazon Managed Workflows for Apache Airflow (MWAA) environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEnvironment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_environment_input::Builder,
    }
    impl CreateEnvironment {
        /// Creates a new `CreateEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEnvironmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the execution role for your environment. An execution role is an Amazon Web Services Identity and Access Management (IAM) role that grants MWAA permission to access Amazon Web Services services and resources used by your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution role</a>.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the execution role for your environment. An execution role is an Amazon Web Services Identity and Access Management (IAM) role that grants MWAA permission to access Amazon Web Services services and resources used by your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution role</a>.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_role_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for Amazon MWAA</a>.</p>
        pub fn source_bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_bucket_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for Amazon MWAA</a>.</p>
        pub fn set_source_bucket_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_bucket_arn(input);
            self
        }
        /// <p>The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a>.</p>
        pub fn dag_s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dag_s3_path(input.into());
            self
        }
        /// <p>The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a>.</p>
        pub fn set_dag_s3_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dag_s3_path(input);
            self
        }
        /// <p>The VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>
        pub fn network_configuration(mut self, input: crate::model::NetworkConfiguration) -> Self {
            self.inner = self.inner.network_configuration(input);
            self
        }
        /// <p>The VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>
        pub fn set_network_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_network_configuration(input);
            self
        }
        /// <p>The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code>. If specified, then the plugins.zip version is required. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>
        pub fn plugins_s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.plugins_s3_path(input.into());
            self
        }
        /// <p>The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code>. If specified, then the plugins.zip version is required. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>
        pub fn set_plugins_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_plugins_s3_path(input);
            self
        }
        /// <p>The version of the plugins.zip file on your Amazon S3 bucket. A version must be specified each time a plugins.zip file is updated. To learn more, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>
        pub fn plugins_s3_object_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.plugins_s3_object_version(input.into());
            self
        }
        /// <p>The version of the plugins.zip file on your Amazon S3 bucket. A version must be specified each time a plugins.zip file is updated. To learn more, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>
        pub fn set_plugins_s3_object_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_plugins_s3_object_version(input);
            self
        }
        /// <p>The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code>. If specified, then a file version is required. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>
        pub fn requirements_s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.requirements_s3_path(input.into());
            self
        }
        /// <p>The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code>. If specified, then a file version is required. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>
        pub fn set_requirements_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_requirements_s3_path(input);
            self
        }
        /// <p>The version of the requirements.txt file on your Amazon S3 bucket. A version must be specified each time a requirements.txt file is updated. To learn more, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>
        pub fn requirements_s3_object_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.requirements_s3_object_version(input.into());
            self
        }
        /// <p>The version of the requirements.txt file on your Amazon S3 bucket. A version must be specified each time a requirements.txt file is updated. To learn more, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>
        pub fn set_requirements_s3_object_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_requirements_s3_object_version(input);
            self
        }
        /// Adds a key-value pair to `AirflowConfigurationOptions`.
        ///
        /// To override the contents of this collection use [`set_airflow_configuration_options`](Self::set_airflow_configuration_options).
        ///
        /// <p>A list of key-value pairs containing the Apache Airflow configuration options you want to attach to your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow configuration options</a>.</p>
        pub fn airflow_configuration_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.airflow_configuration_options(k.into(), v.into());
            self
        }
        /// <p>A list of key-value pairs containing the Apache Airflow configuration options you want to attach to your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow configuration options</a>.</p>
        pub fn set_airflow_configuration_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_airflow_configuration_options(input);
            self
        }
        /// <p>The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>, <code>mw1.large</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment class</a>.</p>
        pub fn environment_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_class(input.into());
            self
        }
        /// <p>The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>, <code>mw1.large</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment class</a>.</p>
        pub fn set_environment_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_class(input);
            self
        }
        /// <p>The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. For example, <code>20</code>. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in <code>MinWorkers</code>.</p>
        pub fn max_workers(mut self, input: i32) -> Self {
            self.inner = self.inner.max_workers(input);
            self
        }
        /// <p>The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. For example, <code>20</code>. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in <code>MinWorkers</code>.</p>
        pub fn set_max_workers(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_workers(input);
            self
        }
        /// <p>The Amazon Web Services Key Management Service (KMS) key to encrypt the data in your environment. You can use an Amazon Web Services owned CMK, or a Customer managed CMK (advanced). To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/create-environment.html">Create an Amazon MWAA environment</a>.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(input.into());
            self
        }
        /// <p>The Amazon Web Services Key Management Service (KMS) key to encrypt the data in your environment. You can use an Amazon Web Services owned CMK, or a Customer managed CMK (advanced). To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/create-environment.html">Create an Amazon MWAA environment</a>.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// <p>The Apache Airflow version for your environment. If no value is specified, defaults to the latest version. Valid values: <code>1.10.12</code>, <code>2.0.2</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/airflow-versions.html">Apache Airflow versions on Amazon Managed Workflows for Apache Airflow (MWAA)</a>.</p>
        pub fn airflow_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.airflow_version(input.into());
            self
        }
        /// <p>The Apache Airflow version for your environment. If no value is specified, defaults to the latest version. Valid values: <code>1.10.12</code>, <code>2.0.2</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/airflow-versions.html">Apache Airflow versions on Amazon Managed Workflows for Apache Airflow (MWAA)</a>.</p>
        pub fn set_airflow_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_airflow_version(input);
            self
        }
        /// <p>Defines the Apache Airflow logs to send to CloudWatch Logs.</p>
        pub fn logging_configuration(
            mut self,
            input: crate::model::LoggingConfigurationInput,
        ) -> Self {
            self.inner = self.inner.logging_configuration(input);
            self
        }
        /// <p>Defines the Apache Airflow logs to send to CloudWatch Logs.</p>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfigurationInput>,
        ) -> Self {
            self.inner = self.inner.set_logging_configuration(input);
            self
        }
        /// <p>The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time to start weekly maintenance updates of your environment in the following format: <code>DAY:HH:MM</code>. For example: <code>TUE:03:30</code>. You can specify a start time in 30 minute increments only.</p>
        pub fn weekly_maintenance_window_start(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.weekly_maintenance_window_start(input.into());
            self
        }
        /// <p>The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time to start weekly maintenance updates of your environment in the following format: <code>DAY:HH:MM</code>. For example: <code>TUE:03:30</code>. You can specify a start time in 30 minute increments only.</p>
        pub fn set_weekly_maintenance_window_start(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_weekly_maintenance_window_start(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value tag pairs you want to associate to your environment. For example, <code>"Environment": "Staging"</code>. To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The key-value tag pairs you want to associate to your environment. For example, <code>"Environment": "Staging"</code>. To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The Apache Airflow <i>Web server</i> access mode. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access modes</a>.</p>
        pub fn webserver_access_mode(mut self, input: crate::model::WebserverAccessMode) -> Self {
            self.inner = self.inner.webserver_access_mode(input);
            self
        }
        /// <p>The Apache Airflow <i>Web server</i> access mode. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access modes</a>.</p>
        pub fn set_webserver_access_mode(
            mut self,
            input: std::option::Option<crate::model::WebserverAccessMode>,
        ) -> Self {
            self.inner = self.inner.set_webserver_access_mode(input);
            self
        }
        /// <p>The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the <code>MinWorkers</code> field. For example, <code>2</code>.</p>
        pub fn min_workers(mut self, input: i32) -> Self {
            self.inner = self.inner.min_workers(input);
            self
        }
        /// <p>The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the <code>MinWorkers</code> field. For example, <code>2</code>.</p>
        pub fn set_min_workers(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_min_workers(input);
            self
        }
        /// <p>The number of Apache Airflow schedulers to run in your environment. Valid values:</p>
        /// <ul>
        /// <li> <p>v2.0.2 - Accepts between 2 to 5. Defaults to 2.</p> </li>
        /// <li> <p>v1.10.12 - Accepts 1.</p> </li>
        /// </ul>
        pub fn schedulers(mut self, input: i32) -> Self {
            self.inner = self.inner.schedulers(input);
            self
        }
        /// <p>The number of Apache Airflow schedulers to run in your environment. Valid values:</p>
        /// <ul>
        /// <li> <p>v2.0.2 - Accepts between 2 to 5. Defaults to 2.</p> </li>
        /// <li> <p>v1.10.12 - Accepts 1.</p> </li>
        /// </ul>
        pub fn set_schedulers(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_schedulers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWebLoginToken`.
    ///
    /// <p>Creates a web login token for the Airflow Web UI. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/call-mwaa-apis-web.html">Creating an Apache Airflow web login token</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWebLoginToken {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_web_login_token_input::Builder,
    }
    impl CreateWebLoginToken {
        /// Creates a new `CreateWebLoginToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWebLoginTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWebLoginTokenError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEnvironment`.
    ///
    /// <p>Deletes an Amazon Managed Workflows for Apache Airflow (MWAA) environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEnvironment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_environment_input::Builder,
    }
    impl DeleteEnvironment {
        /// Creates a new `DeleteEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEnvironmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEnvironment`.
    ///
    /// <p>Describes an Amazon Managed Workflows for Apache Airflow (MWAA) environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEnvironment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_environment_input::Builder,
    }
    impl GetEnvironment {
        /// Creates a new `GetEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEnvironmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEnvironments`.
    ///
    /// <p>Lists the Amazon Managed Workflows for Apache Airflow (MWAA) environments.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEnvironments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_environments_input::Builder,
    }
    impl ListEnvironments {
        /// Creates a new `ListEnvironments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEnvironmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEnvironmentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEnvironmentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEnvironmentsPaginator {
            crate::paginator::ListEnvironmentsPaginator::new(self.handle, self.inner)
        }
        /// <p>Retrieves the next page of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Retrieves the next page of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve per page. For example, <code>5</code> environments per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to retrieve per page. For example, <code>5</code> environments per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the key-value tag pairs associated to the Amazon Managed Workflows for Apache Airflow (MWAA) environment. For example, <code>"Environment": "Staging"</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon MWAA environment. For example, <code>arn:aws:airflow:us-east-1:123456789012:environment/MyMWAAEnvironment</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon MWAA environment. For example, <code>arn:aws:airflow:us-east-1:123456789012:environment/MyMWAAEnvironment</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PublishMetrics`.
    ///
    /// <p> <b>Internal only</b>. Publishes environment health metrics to Amazon CloudWatch.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PublishMetrics {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::publish_metrics_input::Builder,
    }
    impl PublishMetrics {
        /// Creates a new `PublishMetrics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PublishMetricsOutput,
            aws_smithy_http::result::SdkError<crate::error::PublishMetricsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> <b>Internal only</b>. The name of the environment.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p> <b>Internal only</b>. The name of the environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// Appends an item to `MetricData`.
        ///
        /// To override the contents of this collection use [`set_metric_data`](Self::set_metric_data).
        ///
        /// <p> <b>Internal only</b>. Publishes metrics to Amazon CloudWatch. To learn more about the metrics published to Amazon CloudWatch, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/cw-metrics.html">Amazon MWAA performance metrics in Amazon CloudWatch</a>.</p>
        pub fn metric_data(mut self, input: crate::model::MetricDatum) -> Self {
            self.inner = self.inner.metric_data(input);
            self
        }
        /// <p> <b>Internal only</b>. Publishes metrics to Amazon CloudWatch. To learn more about the metrics published to Amazon CloudWatch, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/cw-metrics.html">Amazon MWAA performance metrics in Amazon CloudWatch</a>.</p>
        pub fn set_metric_data(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricDatum>>,
        ) -> Self {
            self.inner = self.inner.set_metric_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associates key-value tag pairs to your Amazon Managed Workflows for Apache Airflow (MWAA) environment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon MWAA environment. For example, <code>arn:aws:airflow:us-east-1:123456789012:environment/MyMWAAEnvironment</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon MWAA environment. For example, <code>arn:aws:airflow:us-east-1:123456789012:environment/MyMWAAEnvironment</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value tag pairs you want to associate to your environment. For example, <code>"Environment": "Staging"</code>. To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The key-value tag pairs you want to associate to your environment. For example, <code>"Environment": "Staging"</code>. To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes key-value tag pairs associated to your Amazon Managed Workflows for Apache Airflow (MWAA) environment. For example, <code>"Environment": "Staging"</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon MWAA environment. For example, <code>arn:aws:airflow:us-east-1:123456789012:environment/MyMWAAEnvironment</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon MWAA environment. For example, <code>arn:aws:airflow:us-east-1:123456789012:environment/MyMWAAEnvironment</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The key-value tag pair you want to remove. For example, <code>"Environment": "Staging"</code>. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The key-value tag pair you want to remove. For example, <code>"Environment": "Staging"</code>. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEnvironment`.
    ///
    /// <p>Updates an Amazon Managed Workflows for Apache Airflow (MWAA) environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEnvironment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_environment_input::Builder,
    }
    impl UpdateEnvironment {
        /// Creates a new `UpdateEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEnvironmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of your Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of your Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web Services resources in your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution role</a>.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web Services resources in your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution role</a>.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_role_arn(input);
            self
        }
        /// <p>The Apache Airflow version for your environment. If no value is specified, defaults to the latest version. Valid values: <code>1.10.12</code>, <code>2.0.2</code>.</p>
        pub fn airflow_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.airflow_version(input.into());
            self
        }
        /// <p>The Apache Airflow version for your environment. If no value is specified, defaults to the latest version. Valid values: <code>1.10.12</code>, <code>2.0.2</code>.</p>
        pub fn set_airflow_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_airflow_version(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for Amazon MWAA</a>.</p>
        pub fn source_bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_bucket_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for Amazon MWAA</a>.</p>
        pub fn set_source_bucket_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_bucket_arn(input);
            self
        }
        /// <p>The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a>.</p>
        pub fn dag_s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dag_s3_path(input.into());
            self
        }
        /// <p>The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a>.</p>
        pub fn set_dag_s3_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dag_s3_path(input);
            self
        }
        /// <p>The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code>. If specified, then the plugins.zip version is required. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>
        pub fn plugins_s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.plugins_s3_path(input.into());
            self
        }
        /// <p>The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code>. If specified, then the plugins.zip version is required. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>
        pub fn set_plugins_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_plugins_s3_path(input);
            self
        }
        /// <p>The version of the plugins.zip file on your Amazon S3 bucket. A version must be specified each time a plugins.zip file is updated. To learn more, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>
        pub fn plugins_s3_object_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.plugins_s3_object_version(input.into());
            self
        }
        /// <p>The version of the plugins.zip file on your Amazon S3 bucket. A version must be specified each time a plugins.zip file is updated. To learn more, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>
        pub fn set_plugins_s3_object_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_plugins_s3_object_version(input);
            self
        }
        /// <p>The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code>. If specified, then a file version is required. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>
        pub fn requirements_s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.requirements_s3_path(input.into());
            self
        }
        /// <p>The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code>. If specified, then a file version is required. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>
        pub fn set_requirements_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_requirements_s3_path(input);
            self
        }
        /// <p>The version of the requirements.txt file on your Amazon S3 bucket. A version must be specified each time a requirements.txt file is updated. To learn more, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>
        pub fn requirements_s3_object_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.requirements_s3_object_version(input.into());
            self
        }
        /// <p>The version of the requirements.txt file on your Amazon S3 bucket. A version must be specified each time a requirements.txt file is updated. To learn more, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>
        pub fn set_requirements_s3_object_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_requirements_s3_object_version(input);
            self
        }
        /// Adds a key-value pair to `AirflowConfigurationOptions`.
        ///
        /// To override the contents of this collection use [`set_airflow_configuration_options`](Self::set_airflow_configuration_options).
        ///
        /// <p>A list of key-value pairs containing the Apache Airflow configuration options you want to attach to your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow configuration options</a>.</p>
        pub fn airflow_configuration_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.airflow_configuration_options(k.into(), v.into());
            self
        }
        /// <p>A list of key-value pairs containing the Apache Airflow configuration options you want to attach to your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow configuration options</a>.</p>
        pub fn set_airflow_configuration_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_airflow_configuration_options(input);
            self
        }
        /// <p>The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>, <code>mw1.large</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment class</a>.</p>
        pub fn environment_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_class(input.into());
            self
        }
        /// <p>The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>, <code>mw1.large</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment class</a>.</p>
        pub fn set_environment_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_class(input);
            self
        }
        /// <p>The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. For example, <code>20</code>. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in <code>MinWorkers</code>.</p>
        pub fn max_workers(mut self, input: i32) -> Self {
            self.inner = self.inner.max_workers(input);
            self
        }
        /// <p>The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. For example, <code>20</code>. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in <code>MinWorkers</code>.</p>
        pub fn set_max_workers(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_workers(input);
            self
        }
        /// <p>The VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>
        pub fn network_configuration(
            mut self,
            input: crate::model::UpdateNetworkConfigurationInput,
        ) -> Self {
            self.inner = self.inner.network_configuration(input);
            self
        }
        /// <p>The VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>
        pub fn set_network_configuration(
            mut self,
            input: std::option::Option<crate::model::UpdateNetworkConfigurationInput>,
        ) -> Self {
            self.inner = self.inner.set_network_configuration(input);
            self
        }
        /// <p>The Apache Airflow log types to send to CloudWatch Logs.</p>
        pub fn logging_configuration(
            mut self,
            input: crate::model::LoggingConfigurationInput,
        ) -> Self {
            self.inner = self.inner.logging_configuration(input);
            self
        }
        /// <p>The Apache Airflow log types to send to CloudWatch Logs.</p>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfigurationInput>,
        ) -> Self {
            self.inner = self.inner.set_logging_configuration(input);
            self
        }
        /// <p>The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time to start weekly maintenance updates of your environment in the following format: <code>DAY:HH:MM</code>. For example: <code>TUE:03:30</code>. You can specify a start time in 30 minute increments only.</p>
        pub fn weekly_maintenance_window_start(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.weekly_maintenance_window_start(input.into());
            self
        }
        /// <p>The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time to start weekly maintenance updates of your environment in the following format: <code>DAY:HH:MM</code>. For example: <code>TUE:03:30</code>. You can specify a start time in 30 minute increments only.</p>
        pub fn set_weekly_maintenance_window_start(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_weekly_maintenance_window_start(input);
            self
        }
        /// <p>The Apache Airflow <i>Web server</i> access mode. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access modes</a>.</p>
        pub fn webserver_access_mode(mut self, input: crate::model::WebserverAccessMode) -> Self {
            self.inner = self.inner.webserver_access_mode(input);
            self
        }
        /// <p>The Apache Airflow <i>Web server</i> access mode. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access modes</a>.</p>
        pub fn set_webserver_access_mode(
            mut self,
            input: std::option::Option<crate::model::WebserverAccessMode>,
        ) -> Self {
            self.inner = self.inner.set_webserver_access_mode(input);
            self
        }
        /// <p>The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the <code>MinWorkers</code> field. For example, <code>2</code>.</p>
        pub fn min_workers(mut self, input: i32) -> Self {
            self.inner = self.inner.min_workers(input);
            self
        }
        /// <p>The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the <code>MinWorkers</code> field. For example, <code>2</code>.</p>
        pub fn set_min_workers(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_min_workers(input);
            self
        }
        /// <p>The number of Apache Airflow schedulers to run in your Amazon MWAA environment.</p>
        pub fn schedulers(mut self, input: i32) -> Self {
            self.inner = self.inner.schedulers(input);
            self
        }
        /// <p>The number of Apache Airflow schedulers to run in your Amazon MWAA environment.</p>
        pub fn set_schedulers(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_schedulers(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
