// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Mechanical Turk
///
/// Client for invoking operations on Amazon Mechanical Turk. Each operation on Amazon Mechanical Turk is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_mturk::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_mturk::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_mturk::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AcceptQualificationRequest`](crate::client::fluent_builders::AcceptQualificationRequest) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`qualification_request_id(impl Into<String>)`](crate::client::fluent_builders::AcceptQualificationRequest::qualification_request_id) / [`set_qualification_request_id(Option<String>)`](crate::client::fluent_builders::AcceptQualificationRequest::set_qualification_request_id): <p>The ID of the Qualification request, as returned by the <code>GetQualificationRequests</code> operation.</p>
    ///   - [`integer_value(i32)`](crate::client::fluent_builders::AcceptQualificationRequest::integer_value) / [`set_integer_value(Option<i32>)`](crate::client::fluent_builders::AcceptQualificationRequest::set_integer_value): <p> The value of the Qualification. You can omit this value if you are using the presence or absence of the Qualification as the basis for a HIT requirement. </p>
    /// - On success, responds with [`AcceptQualificationRequestOutput`](crate::output::AcceptQualificationRequestOutput)

    /// - On failure, responds with [`SdkError<AcceptQualificationRequestError>`](crate::error::AcceptQualificationRequestError)
    pub fn accept_qualification_request(&self) -> fluent_builders::AcceptQualificationRequest {
        fluent_builders::AcceptQualificationRequest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ApproveAssignment`](crate::client::fluent_builders::ApproveAssignment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assignment_id(impl Into<String>)`](crate::client::fluent_builders::ApproveAssignment::assignment_id) / [`set_assignment_id(Option<String>)`](crate::client::fluent_builders::ApproveAssignment::set_assignment_id): <p> The ID of the assignment. The assignment must correspond to a HIT created by the Requester. </p>
    ///   - [`requester_feedback(impl Into<String>)`](crate::client::fluent_builders::ApproveAssignment::requester_feedback) / [`set_requester_feedback(Option<String>)`](crate::client::fluent_builders::ApproveAssignment::set_requester_feedback): <p> A message for the Worker, which the Worker can see in the Status section of the web site. </p>
    ///   - [`override_rejection(bool)`](crate::client::fluent_builders::ApproveAssignment::override_rejection) / [`set_override_rejection(Option<bool>)`](crate::client::fluent_builders::ApproveAssignment::set_override_rejection): <p> A flag indicating that an assignment should be approved even if it was previously rejected. Defaults to <code>False</code>. </p>
    /// - On success, responds with [`ApproveAssignmentOutput`](crate::output::ApproveAssignmentOutput)

    /// - On failure, responds with [`SdkError<ApproveAssignmentError>`](crate::error::ApproveAssignmentError)
    pub fn approve_assignment(&self) -> fluent_builders::ApproveAssignment {
        fluent_builders::ApproveAssignment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateQualificationWithWorker`](crate::client::fluent_builders::AssociateQualificationWithWorker) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`qualification_type_id(impl Into<String>)`](crate::client::fluent_builders::AssociateQualificationWithWorker::qualification_type_id) / [`set_qualification_type_id(Option<String>)`](crate::client::fluent_builders::AssociateQualificationWithWorker::set_qualification_type_id): <p>The ID of the Qualification type to use for the assigned Qualification.</p>
    ///   - [`worker_id(impl Into<String>)`](crate::client::fluent_builders::AssociateQualificationWithWorker::worker_id) / [`set_worker_id(Option<String>)`](crate::client::fluent_builders::AssociateQualificationWithWorker::set_worker_id): <p> The ID of the Worker to whom the Qualification is being assigned. Worker IDs are included with submitted HIT assignments and Qualification requests. </p>
    ///   - [`integer_value(i32)`](crate::client::fluent_builders::AssociateQualificationWithWorker::integer_value) / [`set_integer_value(Option<i32>)`](crate::client::fluent_builders::AssociateQualificationWithWorker::set_integer_value): <p>The value of the Qualification to assign.</p>
    ///   - [`send_notification(bool)`](crate::client::fluent_builders::AssociateQualificationWithWorker::send_notification) / [`set_send_notification(Option<bool>)`](crate::client::fluent_builders::AssociateQualificationWithWorker::set_send_notification): <p> Specifies whether to send a notification email message to the Worker saying that the qualification was assigned to the Worker. Note: this is true by default. </p>
    /// - On success, responds with [`AssociateQualificationWithWorkerOutput`](crate::output::AssociateQualificationWithWorkerOutput)

    /// - On failure, responds with [`SdkError<AssociateQualificationWithWorkerError>`](crate::error::AssociateQualificationWithWorkerError)
    pub fn associate_qualification_with_worker(
        &self,
    ) -> fluent_builders::AssociateQualificationWithWorker {
        fluent_builders::AssociateQualificationWithWorker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAdditionalAssignmentsForHIT`](crate::client::fluent_builders::CreateAdditionalAssignmentsForHIT) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hit_id(impl Into<String>)`](crate::client::fluent_builders::CreateAdditionalAssignmentsForHIT::hit_id) / [`set_hit_id(Option<String>)`](crate::client::fluent_builders::CreateAdditionalAssignmentsForHIT::set_hit_id): <p>The ID of the HIT to extend.</p>
    ///   - [`number_of_additional_assignments(i32)`](crate::client::fluent_builders::CreateAdditionalAssignmentsForHIT::number_of_additional_assignments) / [`set_number_of_additional_assignments(Option<i32>)`](crate::client::fluent_builders::CreateAdditionalAssignmentsForHIT::set_number_of_additional_assignments): <p>The number of additional assignments to request for this HIT.</p>
    ///   - [`unique_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateAdditionalAssignmentsForHIT::unique_request_token) / [`set_unique_request_token(Option<String>)`](crate::client::fluent_builders::CreateAdditionalAssignmentsForHIT::set_unique_request_token): <p> A unique identifier for this request, which allows you to retry the call on error without extending the HIT multiple times. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the extend HIT already exists in the system from a previous call using the same <code>UniqueRequestToken</code>, subsequent calls will return an error with a message containing the request ID. </p>
    /// - On success, responds with [`CreateAdditionalAssignmentsForHitOutput`](crate::output::CreateAdditionalAssignmentsForHitOutput)

    /// - On failure, responds with [`SdkError<CreateAdditionalAssignmentsForHITError>`](crate::error::CreateAdditionalAssignmentsForHITError)
    pub fn create_additional_assignments_for_hit(
        &self,
    ) -> fluent_builders::CreateAdditionalAssignmentsForHIT {
        fluent_builders::CreateAdditionalAssignmentsForHIT::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateHIT`](crate::client::fluent_builders::CreateHIT) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_assignments(i32)`](crate::client::fluent_builders::CreateHIT::max_assignments) / [`set_max_assignments(Option<i32>)`](crate::client::fluent_builders::CreateHIT::set_max_assignments): <p> The number of times the HIT can be accepted and completed before the HIT becomes unavailable. </p>
    ///   - [`auto_approval_delay_in_seconds(i64)`](crate::client::fluent_builders::CreateHIT::auto_approval_delay_in_seconds) / [`set_auto_approval_delay_in_seconds(Option<i64>)`](crate::client::fluent_builders::CreateHIT::set_auto_approval_delay_in_seconds): <p> The number of seconds after an assignment for the HIT has been submitted, after which the assignment is considered Approved automatically unless the Requester explicitly rejects it. </p>
    ///   - [`lifetime_in_seconds(i64)`](crate::client::fluent_builders::CreateHIT::lifetime_in_seconds) / [`set_lifetime_in_seconds(Option<i64>)`](crate::client::fluent_builders::CreateHIT::set_lifetime_in_seconds): <p> An amount of time, in seconds, after which the HIT is no longer available for users to accept. After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches, even if not all of the assignments for the HIT have been accepted. </p>
    ///   - [`assignment_duration_in_seconds(i64)`](crate::client::fluent_builders::CreateHIT::assignment_duration_in_seconds) / [`set_assignment_duration_in_seconds(Option<i64>)`](crate::client::fluent_builders::CreateHIT::set_assignment_duration_in_seconds): <p> The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker does not complete the assignment within the specified duration, the assignment is considered abandoned. If the HIT is still active (that is, its lifetime has not elapsed), the assignment becomes available for other users to find and accept. </p>
    ///   - [`reward(impl Into<String>)`](crate::client::fluent_builders::CreateHIT::reward) / [`set_reward(Option<String>)`](crate::client::fluent_builders::CreateHIT::set_reward): <p> The amount of money the Requester will pay a Worker for successfully completing the HIT. </p>
    ///   - [`title(impl Into<String>)`](crate::client::fluent_builders::CreateHIT::title) / [`set_title(Option<String>)`](crate::client::fluent_builders::CreateHIT::set_title): <p> The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the HIT is mentioned. </p>
    ///   - [`keywords(impl Into<String>)`](crate::client::fluent_builders::CreateHIT::keywords) / [`set_keywords(Option<String>)`](crate::client::fluent_builders::CreateHIT::set_keywords): <p> One or more words or phrases that describe the HIT, separated by commas. These words are used in searches to find HITs. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateHIT::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateHIT::set_description): <p> A general description of the HIT. A description includes detailed information about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded view of search results, and in the HIT and assignment screens. A good description gives the user enough information to evaluate the HIT before accepting it. </p>
    ///   - [`question(impl Into<String>)`](crate::client::fluent_builders::CreateHIT::question) / [`set_question(Option<String>)`](crate::client::fluent_builders::CreateHIT::set_question): <p> The data the person completing the HIT uses to produce the results. </p>  <p> Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure, or an HTMLQuestion data structure. The XML question data must not be larger than 64 kilobytes (65,535 bytes) in size, including whitespace. </p>  <p>Either a Question parameter or a HITLayoutId parameter must be provided.</p>
    ///   - [`requester_annotation(impl Into<String>)`](crate::client::fluent_builders::CreateHIT::requester_annotation) / [`set_requester_annotation(Option<String>)`](crate::client::fluent_builders::CreateHIT::set_requester_annotation): <p> An arbitrary data field. The RequesterAnnotation parameter lets your application attach arbitrary data to the HIT for tracking purposes. For example, this parameter could be an identifier internal to the Requester's application that corresponds with the HIT. </p>  <p> The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT. It is not shown to the Worker, or any other Requester. </p>  <p> The RequesterAnnotation parameter may be different for each HIT you submit. It does not affect how your HITs are grouped. </p>
    ///   - [`qualification_requirements(Vec<QualificationRequirement>)`](crate::client::fluent_builders::CreateHIT::qualification_requirements) / [`set_qualification_requirements(Option<Vec<QualificationRequirement>>)`](crate::client::fluent_builders::CreateHIT::set_qualification_requirements): <p> Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT. Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each <code>QualificationRequirement</code> structure. </p>
    ///   - [`unique_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateHIT::unique_request_token) / [`set_unique_request_token(Option<String>)`](crate::client::fluent_builders::CreateHIT::set_unique_request_token): <p> A unique identifier for this request which allows you to retry the call on error without creating duplicate HITs. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the HIT already exists in the system from a previous call using the same UniqueRequestToken, subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error with a message containing the HITId. </p> <note>   <p> Note: It is your responsibility to ensure uniqueness of the token. The unique token expires after 24 hours. Subsequent calls using the same UniqueRequestToken made after the 24 hour limit could create duplicate HITs. </p>  </note>
    ///   - [`assignment_review_policy(ReviewPolicy)`](crate::client::fluent_builders::CreateHIT::assignment_review_policy) / [`set_assignment_review_policy(Option<ReviewPolicy>)`](crate::client::fluent_builders::CreateHIT::set_assignment_review_policy): <p> The Assignment-level Review Policy applies to the assignments under the HIT. You can specify for Mechanical Turk to take various actions based on the policy. </p>
    ///   - [`hit_review_policy(ReviewPolicy)`](crate::client::fluent_builders::CreateHIT::hit_review_policy) / [`set_hit_review_policy(Option<ReviewPolicy>)`](crate::client::fluent_builders::CreateHIT::set_hit_review_policy): <p> The HIT-level Review Policy applies to the HIT. You can specify for Mechanical Turk to take various actions based on the policy. </p>
    ///   - [`hit_layout_id(impl Into<String>)`](crate::client::fluent_builders::CreateHIT::hit_layout_id) / [`set_hit_layout_id(Option<String>)`](crate::client::fluent_builders::CreateHIT::set_hit_layout_id): <p> The HITLayoutId allows you to use a pre-existing HIT design with placeholder values and create an additional HIT by providing those values as HITLayoutParameters. </p>  <p> Constraints: Either a Question parameter or a HITLayoutId parameter must be provided. </p>
    ///   - [`hit_layout_parameters(Vec<HitLayoutParameter>)`](crate::client::fluent_builders::CreateHIT::hit_layout_parameters) / [`set_hit_layout_parameters(Option<Vec<HitLayoutParameter>>)`](crate::client::fluent_builders::CreateHIT::set_hit_layout_parameters): <p> If the HITLayoutId is provided, any placeholder values must be filled in with values using the HITLayoutParameter structure. For more information, see HITLayout. </p>
    /// - On success, responds with [`CreateHitOutput`](crate::output::CreateHitOutput) with field(s):
    ///   - [`hit(Option<Hit>)`](crate::output::CreateHitOutput::hit): <p> Contains the newly created HIT data. For a description of the HIT data structure as it appears in responses, see the HIT Data Structure documentation. </p>
    /// - On failure, responds with [`SdkError<CreateHITError>`](crate::error::CreateHITError)
    pub fn create_hit(&self) -> fluent_builders::CreateHIT {
        fluent_builders::CreateHIT::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateHITType`](crate::client::fluent_builders::CreateHITType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`auto_approval_delay_in_seconds(i64)`](crate::client::fluent_builders::CreateHITType::auto_approval_delay_in_seconds) / [`set_auto_approval_delay_in_seconds(Option<i64>)`](crate::client::fluent_builders::CreateHITType::set_auto_approval_delay_in_seconds): <p> The number of seconds after an assignment for the HIT has been submitted, after which the assignment is considered Approved automatically unless the Requester explicitly rejects it. </p>
    ///   - [`assignment_duration_in_seconds(i64)`](crate::client::fluent_builders::CreateHITType::assignment_duration_in_seconds) / [`set_assignment_duration_in_seconds(Option<i64>)`](crate::client::fluent_builders::CreateHITType::set_assignment_duration_in_seconds): <p> The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker does not complete the assignment within the specified duration, the assignment is considered abandoned. If the HIT is still active (that is, its lifetime has not elapsed), the assignment becomes available for other users to find and accept. </p>
    ///   - [`reward(impl Into<String>)`](crate::client::fluent_builders::CreateHITType::reward) / [`set_reward(Option<String>)`](crate::client::fluent_builders::CreateHITType::set_reward): <p> The amount of money the Requester will pay a Worker for successfully completing the HIT. </p>
    ///   - [`title(impl Into<String>)`](crate::client::fluent_builders::CreateHITType::title) / [`set_title(Option<String>)`](crate::client::fluent_builders::CreateHITType::set_title): <p> The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the HIT is mentioned. </p>
    ///   - [`keywords(impl Into<String>)`](crate::client::fluent_builders::CreateHITType::keywords) / [`set_keywords(Option<String>)`](crate::client::fluent_builders::CreateHITType::set_keywords): <p> One or more words or phrases that describe the HIT, separated by commas. These words are used in searches to find HITs. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateHITType::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateHITType::set_description): <p> A general description of the HIT. A description includes detailed information about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded view of search results, and in the HIT and assignment screens. A good description gives the user enough information to evaluate the HIT before accepting it. </p>
    ///   - [`qualification_requirements(Vec<QualificationRequirement>)`](crate::client::fluent_builders::CreateHITType::qualification_requirements) / [`set_qualification_requirements(Option<Vec<QualificationRequirement>>)`](crate::client::fluent_builders::CreateHITType::set_qualification_requirements): <p> Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT. Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each <code>QualificationRequirement</code> structure. </p>
    /// - On success, responds with [`CreateHitTypeOutput`](crate::output::CreateHitTypeOutput) with field(s):
    ///   - [`hit_type_id(Option<String>)`](crate::output::CreateHitTypeOutput::hit_type_id): <p> The ID of the newly registered HIT type.</p>
    /// - On failure, responds with [`SdkError<CreateHITTypeError>`](crate::error::CreateHITTypeError)
    pub fn create_hit_type(&self) -> fluent_builders::CreateHITType {
        fluent_builders::CreateHITType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateHITWithHITType`](crate::client::fluent_builders::CreateHITWithHITType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hit_type_id(impl Into<String>)`](crate::client::fluent_builders::CreateHITWithHITType::hit_type_id) / [`set_hit_type_id(Option<String>)`](crate::client::fluent_builders::CreateHITWithHITType::set_hit_type_id): <p>The HIT type ID you want to create this HIT with.</p>
    ///   - [`max_assignments(i32)`](crate::client::fluent_builders::CreateHITWithHITType::max_assignments) / [`set_max_assignments(Option<i32>)`](crate::client::fluent_builders::CreateHITWithHITType::set_max_assignments): <p> The number of times the HIT can be accepted and completed before the HIT becomes unavailable. </p>
    ///   - [`lifetime_in_seconds(i64)`](crate::client::fluent_builders::CreateHITWithHITType::lifetime_in_seconds) / [`set_lifetime_in_seconds(Option<i64>)`](crate::client::fluent_builders::CreateHITWithHITType::set_lifetime_in_seconds): <p> An amount of time, in seconds, after which the HIT is no longer available for users to accept. After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches, even if not all of the assignments for the HIT have been accepted. </p>
    ///   - [`question(impl Into<String>)`](crate::client::fluent_builders::CreateHITWithHITType::question) / [`set_question(Option<String>)`](crate::client::fluent_builders::CreateHITWithHITType::set_question): <p> The data the person completing the HIT uses to produce the results. </p>  <p> Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure, or an HTMLQuestion data structure. The XML question data must not be larger than 64 kilobytes (65,535 bytes) in size, including whitespace. </p>  <p>Either a Question parameter or a HITLayoutId parameter must be provided.</p>
    ///   - [`requester_annotation(impl Into<String>)`](crate::client::fluent_builders::CreateHITWithHITType::requester_annotation) / [`set_requester_annotation(Option<String>)`](crate::client::fluent_builders::CreateHITWithHITType::set_requester_annotation): <p> An arbitrary data field. The RequesterAnnotation parameter lets your application attach arbitrary data to the HIT for tracking purposes. For example, this parameter could be an identifier internal to the Requester's application that corresponds with the HIT. </p>  <p> The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT. It is not shown to the Worker, or any other Requester. </p>  <p> The RequesterAnnotation parameter may be different for each HIT you submit. It does not affect how your HITs are grouped. </p>
    ///   - [`unique_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateHITWithHITType::unique_request_token) / [`set_unique_request_token(Option<String>)`](crate::client::fluent_builders::CreateHITWithHITType::set_unique_request_token): <p> A unique identifier for this request which allows you to retry the call on error without creating duplicate HITs. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the HIT already exists in the system from a previous call using the same UniqueRequestToken, subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error with a message containing the HITId. </p> <note>   <p> Note: It is your responsibility to ensure uniqueness of the token. The unique token expires after 24 hours. Subsequent calls using the same UniqueRequestToken made after the 24 hour limit could create duplicate HITs. </p>  </note>
    ///   - [`assignment_review_policy(ReviewPolicy)`](crate::client::fluent_builders::CreateHITWithHITType::assignment_review_policy) / [`set_assignment_review_policy(Option<ReviewPolicy>)`](crate::client::fluent_builders::CreateHITWithHITType::set_assignment_review_policy): <p> The Assignment-level Review Policy applies to the assignments under the HIT. You can specify for Mechanical Turk to take various actions based on the policy. </p>
    ///   - [`hit_review_policy(ReviewPolicy)`](crate::client::fluent_builders::CreateHITWithHITType::hit_review_policy) / [`set_hit_review_policy(Option<ReviewPolicy>)`](crate::client::fluent_builders::CreateHITWithHITType::set_hit_review_policy): <p> The HIT-level Review Policy applies to the HIT. You can specify for Mechanical Turk to take various actions based on the policy. </p>
    ///   - [`hit_layout_id(impl Into<String>)`](crate::client::fluent_builders::CreateHITWithHITType::hit_layout_id) / [`set_hit_layout_id(Option<String>)`](crate::client::fluent_builders::CreateHITWithHITType::set_hit_layout_id): <p> The HITLayoutId allows you to use a pre-existing HIT design with placeholder values and create an additional HIT by providing those values as HITLayoutParameters. </p>  <p> Constraints: Either a Question parameter or a HITLayoutId parameter must be provided. </p>
    ///   - [`hit_layout_parameters(Vec<HitLayoutParameter>)`](crate::client::fluent_builders::CreateHITWithHITType::hit_layout_parameters) / [`set_hit_layout_parameters(Option<Vec<HitLayoutParameter>>)`](crate::client::fluent_builders::CreateHITWithHITType::set_hit_layout_parameters): <p> If the HITLayoutId is provided, any placeholder values must be filled in with values using the HITLayoutParameter structure. For more information, see HITLayout. </p>
    /// - On success, responds with [`CreateHitWithHitTypeOutput`](crate::output::CreateHitWithHitTypeOutput) with field(s):
    ///   - [`hit(Option<Hit>)`](crate::output::CreateHitWithHitTypeOutput::hit): <p> Contains the newly created HIT data. For a description of the HIT data structure as it appears in responses, see the HIT Data Structure documentation. </p>
    /// - On failure, responds with [`SdkError<CreateHITWithHITTypeError>`](crate::error::CreateHITWithHITTypeError)
    pub fn create_hit_with_hit_type(&self) -> fluent_builders::CreateHITWithHITType {
        fluent_builders::CreateHITWithHITType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateQualificationType`](crate::client::fluent_builders::CreateQualificationType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateQualificationType::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateQualificationType::set_name): <p> The name you give to the Qualification type. The type name is used to represent the Qualification to Workers, and to find the type using a Qualification type search. It must be unique across all of your Qualification types.</p>
    ///   - [`keywords(impl Into<String>)`](crate::client::fluent_builders::CreateQualificationType::keywords) / [`set_keywords(Option<String>)`](crate::client::fluent_builders::CreateQualificationType::set_keywords): <p>One or more words or phrases that describe the Qualification type, separated by commas. The keywords of a type make the type easier to find during a search.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateQualificationType::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateQualificationType::set_description): <p>A long description for the Qualification type. On the Amazon Mechanical Turk website, the long description is displayed when a Worker examines a Qualification type.</p>
    ///   - [`qualification_type_status(QualificationTypeStatus)`](crate::client::fluent_builders::CreateQualificationType::qualification_type_status) / [`set_qualification_type_status(Option<QualificationTypeStatus>)`](crate::client::fluent_builders::CreateQualificationType::set_qualification_type_status): <p>The initial status of the Qualification type.</p>  <p>Constraints: Valid values are: Active | Inactive</p>
    ///   - [`retry_delay_in_seconds(i64)`](crate::client::fluent_builders::CreateQualificationType::retry_delay_in_seconds) / [`set_retry_delay_in_seconds(Option<i64>)`](crate::client::fluent_builders::CreateQualificationType::set_retry_delay_in_seconds): <p>The number of seconds that a Worker must wait after requesting a Qualification of the Qualification type before the worker can retry the Qualification request.</p>  <p>Constraints: None. If not specified, retries are disabled and Workers can request a Qualification of this type only once, even if the Worker has not been granted the Qualification. It is not possible to disable retries for a Qualification type after it has been created with retries enabled. If you want to disable retries, you must delete existing retry-enabled Qualification type and then create a new Qualification type with retries disabled.</p>
    ///   - [`test(impl Into<String>)`](crate::client::fluent_builders::CreateQualificationType::test) / [`set_test(Option<String>)`](crate::client::fluent_builders::CreateQualificationType::set_test): <p> The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified. </p>  <p>Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be specified if AutoGranted is true.</p>  <p>Constraints: None. If not specified, the Worker may request the Qualification without answering any questions.</p>
    ///   - [`answer_key(impl Into<String>)`](crate::client::fluent_builders::CreateQualificationType::answer_key) / [`set_answer_key(Option<String>)`](crate::client::fluent_builders::CreateQualificationType::set_answer_key): <p>The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data structure.</p>  <p>Constraints: Must not be longer than 65535 bytes.</p>  <p>Constraints: None. If not specified, you must process Qualification requests manually.</p>
    ///   - [`test_duration_in_seconds(i64)`](crate::client::fluent_builders::CreateQualificationType::test_duration_in_seconds) / [`set_test_duration_in_seconds(Option<i64>)`](crate::client::fluent_builders::CreateQualificationType::set_test_duration_in_seconds): <p>The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker requests the Qualification.</p>
    ///   - [`auto_granted(bool)`](crate::client::fluent_builders::CreateQualificationType::auto_granted) / [`set_auto_granted(Option<bool>)`](crate::client::fluent_builders::CreateQualificationType::set_auto_granted): <p>Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test.</p>  <p>Constraints: If the Test parameter is specified, this parameter cannot be true.</p>
    ///   - [`auto_granted_value(i32)`](crate::client::fluent_builders::CreateQualificationType::auto_granted_value) / [`set_auto_granted_value(Option<i32>)`](crate::client::fluent_builders::CreateQualificationType::set_auto_granted_value): <p>The Qualification value to use for automatically granted Qualifications. This parameter is used only if the AutoGranted parameter is true.</p>
    /// - On success, responds with [`CreateQualificationTypeOutput`](crate::output::CreateQualificationTypeOutput) with field(s):
    ///   - [`qualification_type(Option<QualificationType>)`](crate::output::CreateQualificationTypeOutput::qualification_type): <p>The created Qualification type, returned as a QualificationType data structure.</p>
    /// - On failure, responds with [`SdkError<CreateQualificationTypeError>`](crate::error::CreateQualificationTypeError)
    pub fn create_qualification_type(&self) -> fluent_builders::CreateQualificationType {
        fluent_builders::CreateQualificationType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateWorkerBlock`](crate::client::fluent_builders::CreateWorkerBlock) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`worker_id(impl Into<String>)`](crate::client::fluent_builders::CreateWorkerBlock::worker_id) / [`set_worker_id(Option<String>)`](crate::client::fluent_builders::CreateWorkerBlock::set_worker_id): <p>The ID of the Worker to block.</p>
    ///   - [`reason(impl Into<String>)`](crate::client::fluent_builders::CreateWorkerBlock::reason) / [`set_reason(Option<String>)`](crate::client::fluent_builders::CreateWorkerBlock::set_reason): <p>A message explaining the reason for blocking the Worker. This parameter enables you to keep track of your Workers. The Worker does not see this message.</p>
    /// - On success, responds with [`CreateWorkerBlockOutput`](crate::output::CreateWorkerBlockOutput)

    /// - On failure, responds with [`SdkError<CreateWorkerBlockError>`](crate::error::CreateWorkerBlockError)
    pub fn create_worker_block(&self) -> fluent_builders::CreateWorkerBlock {
        fluent_builders::CreateWorkerBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteHIT`](crate::client::fluent_builders::DeleteHIT) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hit_id(impl Into<String>)`](crate::client::fluent_builders::DeleteHIT::hit_id) / [`set_hit_id(Option<String>)`](crate::client::fluent_builders::DeleteHIT::set_hit_id): <p>The ID of the HIT to be deleted.</p>
    /// - On success, responds with [`DeleteHitOutput`](crate::output::DeleteHitOutput)

    /// - On failure, responds with [`SdkError<DeleteHITError>`](crate::error::DeleteHITError)
    pub fn delete_hit(&self) -> fluent_builders::DeleteHIT {
        fluent_builders::DeleteHIT::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteQualificationType`](crate::client::fluent_builders::DeleteQualificationType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`qualification_type_id(impl Into<String>)`](crate::client::fluent_builders::DeleteQualificationType::qualification_type_id) / [`set_qualification_type_id(Option<String>)`](crate::client::fluent_builders::DeleteQualificationType::set_qualification_type_id): <p>The ID of the QualificationType to dispose.</p>
    /// - On success, responds with [`DeleteQualificationTypeOutput`](crate::output::DeleteQualificationTypeOutput)

    /// - On failure, responds with [`SdkError<DeleteQualificationTypeError>`](crate::error::DeleteQualificationTypeError)
    pub fn delete_qualification_type(&self) -> fluent_builders::DeleteQualificationType {
        fluent_builders::DeleteQualificationType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteWorkerBlock`](crate::client::fluent_builders::DeleteWorkerBlock) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`worker_id(impl Into<String>)`](crate::client::fluent_builders::DeleteWorkerBlock::worker_id) / [`set_worker_id(Option<String>)`](crate::client::fluent_builders::DeleteWorkerBlock::set_worker_id): <p>The ID of the Worker to unblock.</p>
    ///   - [`reason(impl Into<String>)`](crate::client::fluent_builders::DeleteWorkerBlock::reason) / [`set_reason(Option<String>)`](crate::client::fluent_builders::DeleteWorkerBlock::set_reason): <p>A message that explains the reason for unblocking the Worker. The Worker does not see this message.</p>
    /// - On success, responds with [`DeleteWorkerBlockOutput`](crate::output::DeleteWorkerBlockOutput)

    /// - On failure, responds with [`SdkError<DeleteWorkerBlockError>`](crate::error::DeleteWorkerBlockError)
    pub fn delete_worker_block(&self) -> fluent_builders::DeleteWorkerBlock {
        fluent_builders::DeleteWorkerBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateQualificationFromWorker`](crate::client::fluent_builders::DisassociateQualificationFromWorker) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`worker_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateQualificationFromWorker::worker_id) / [`set_worker_id(Option<String>)`](crate::client::fluent_builders::DisassociateQualificationFromWorker::set_worker_id): <p>The ID of the Worker who possesses the Qualification to be revoked.</p>
    ///   - [`qualification_type_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateQualificationFromWorker::qualification_type_id) / [`set_qualification_type_id(Option<String>)`](crate::client::fluent_builders::DisassociateQualificationFromWorker::set_qualification_type_id): <p>The ID of the Qualification type of the Qualification to be revoked.</p>
    ///   - [`reason(impl Into<String>)`](crate::client::fluent_builders::DisassociateQualificationFromWorker::reason) / [`set_reason(Option<String>)`](crate::client::fluent_builders::DisassociateQualificationFromWorker::set_reason): <p>A text message that explains why the Qualification was revoked. The user who had the Qualification sees this message.</p>
    /// - On success, responds with [`DisassociateQualificationFromWorkerOutput`](crate::output::DisassociateQualificationFromWorkerOutput)

    /// - On failure, responds with [`SdkError<DisassociateQualificationFromWorkerError>`](crate::error::DisassociateQualificationFromWorkerError)
    pub fn disassociate_qualification_from_worker(
        &self,
    ) -> fluent_builders::DisassociateQualificationFromWorker {
        fluent_builders::DisassociateQualificationFromWorker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccountBalance`](crate::client::fluent_builders::GetAccountBalance) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetAccountBalance::send) it.

    /// - On success, responds with [`GetAccountBalanceOutput`](crate::output::GetAccountBalanceOutput) with field(s):
    ///   - [`available_balance(Option<String>)`](crate::output::GetAccountBalanceOutput::available_balance): <p>A string representing a currency amount.</p>
    ///   - [`on_hold_balance(Option<String>)`](crate::output::GetAccountBalanceOutput::on_hold_balance): <p>A string representing a currency amount.</p>
    /// - On failure, responds with [`SdkError<GetAccountBalanceError>`](crate::error::GetAccountBalanceError)
    pub fn get_account_balance(&self) -> fluent_builders::GetAccountBalance {
        fluent_builders::GetAccountBalance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAssignment`](crate::client::fluent_builders::GetAssignment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assignment_id(impl Into<String>)`](crate::client::fluent_builders::GetAssignment::assignment_id) / [`set_assignment_id(Option<String>)`](crate::client::fluent_builders::GetAssignment::set_assignment_id): <p>The ID of the Assignment to be retrieved.</p>
    /// - On success, responds with [`GetAssignmentOutput`](crate::output::GetAssignmentOutput) with field(s):
    ///   - [`assignment(Option<Assignment>)`](crate::output::GetAssignmentOutput::assignment): <p> The assignment. The response includes one Assignment element. </p>
    ///   - [`hit(Option<Hit>)`](crate::output::GetAssignmentOutput::hit): <p> The HIT associated with this assignment. The response includes one HIT element.</p>
    /// - On failure, responds with [`SdkError<GetAssignmentError>`](crate::error::GetAssignmentError)
    pub fn get_assignment(&self) -> fluent_builders::GetAssignment {
        fluent_builders::GetAssignment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFileUploadURL`](crate::client::fluent_builders::GetFileUploadURL) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assignment_id(impl Into<String>)`](crate::client::fluent_builders::GetFileUploadURL::assignment_id) / [`set_assignment_id(Option<String>)`](crate::client::fluent_builders::GetFileUploadURL::set_assignment_id): <p>The ID of the assignment that contains the question with a FileUploadAnswer.</p>
    ///   - [`question_identifier(impl Into<String>)`](crate::client::fluent_builders::GetFileUploadURL::question_identifier) / [`set_question_identifier(Option<String>)`](crate::client::fluent_builders::GetFileUploadURL::set_question_identifier): <p>The identifier of the question with a FileUploadAnswer, as specified in the QuestionForm of the HIT.</p>
    /// - On success, responds with [`GetFileUploadUrlOutput`](crate::output::GetFileUploadUrlOutput) with field(s):
    ///   - [`file_upload_url(Option<String>)`](crate::output::GetFileUploadUrlOutput::file_upload_url): <p> A temporary URL for the file that the Worker uploaded for the answer. </p>
    /// - On failure, responds with [`SdkError<GetFileUploadURLError>`](crate::error::GetFileUploadURLError)
    pub fn get_file_upload_url(&self) -> fluent_builders::GetFileUploadURL {
        fluent_builders::GetFileUploadURL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetHIT`](crate::client::fluent_builders::GetHIT) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hit_id(impl Into<String>)`](crate::client::fluent_builders::GetHIT::hit_id) / [`set_hit_id(Option<String>)`](crate::client::fluent_builders::GetHIT::set_hit_id): <p>The ID of the HIT to be retrieved.</p>
    /// - On success, responds with [`GetHitOutput`](crate::output::GetHitOutput) with field(s):
    ///   - [`hit(Option<Hit>)`](crate::output::GetHitOutput::hit): <p> Contains the requested HIT data.</p>
    /// - On failure, responds with [`SdkError<GetHITError>`](crate::error::GetHITError)
    pub fn get_hit(&self) -> fluent_builders::GetHIT {
        fluent_builders::GetHIT::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetQualificationScore`](crate::client::fluent_builders::GetQualificationScore) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`qualification_type_id(impl Into<String>)`](crate::client::fluent_builders::GetQualificationScore::qualification_type_id) / [`set_qualification_type_id(Option<String>)`](crate::client::fluent_builders::GetQualificationScore::set_qualification_type_id): <p>The ID of the QualificationType.</p>
    ///   - [`worker_id(impl Into<String>)`](crate::client::fluent_builders::GetQualificationScore::worker_id) / [`set_worker_id(Option<String>)`](crate::client::fluent_builders::GetQualificationScore::set_worker_id): <p>The ID of the Worker whose Qualification is being updated.</p>
    /// - On success, responds with [`GetQualificationScoreOutput`](crate::output::GetQualificationScoreOutput) with field(s):
    ///   - [`qualification(Option<Qualification>)`](crate::output::GetQualificationScoreOutput::qualification): <p> The Qualification data structure of the Qualification assigned to a user, including the Qualification type and the value (score). </p>
    /// - On failure, responds with [`SdkError<GetQualificationScoreError>`](crate::error::GetQualificationScoreError)
    pub fn get_qualification_score(&self) -> fluent_builders::GetQualificationScore {
        fluent_builders::GetQualificationScore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetQualificationType`](crate::client::fluent_builders::GetQualificationType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`qualification_type_id(impl Into<String>)`](crate::client::fluent_builders::GetQualificationType::qualification_type_id) / [`set_qualification_type_id(Option<String>)`](crate::client::fluent_builders::GetQualificationType::set_qualification_type_id): <p>The ID of the QualificationType.</p>
    /// - On success, responds with [`GetQualificationTypeOutput`](crate::output::GetQualificationTypeOutput) with field(s):
    ///   - [`qualification_type(Option<QualificationType>)`](crate::output::GetQualificationTypeOutput::qualification_type): <p> The returned Qualification Type</p>
    /// - On failure, responds with [`SdkError<GetQualificationTypeError>`](crate::error::GetQualificationTypeError)
    pub fn get_qualification_type(&self) -> fluent_builders::GetQualificationType {
        fluent_builders::GetQualificationType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssignmentsForHIT`](crate::client::fluent_builders::ListAssignmentsForHIT) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssignmentsForHIT::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`hit_id(impl Into<String>)`](crate::client::fluent_builders::ListAssignmentsForHIT::hit_id) / [`set_hit_id(Option<String>)`](crate::client::fluent_builders::ListAssignmentsForHIT::set_hit_id): <p>The ID of the HIT.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssignmentsForHIT::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssignmentsForHIT::set_next_token): <p>Pagination token</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssignmentsForHIT::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssignmentsForHIT::set_max_results): (undocumented)
    ///   - [`assignment_statuses(Vec<AssignmentStatus>)`](crate::client::fluent_builders::ListAssignmentsForHIT::assignment_statuses) / [`set_assignment_statuses(Option<Vec<AssignmentStatus>>)`](crate::client::fluent_builders::ListAssignmentsForHIT::set_assignment_statuses): <p>The status of the assignments to return: Submitted | Approved | Rejected</p>
    /// - On success, responds with [`ListAssignmentsForHitOutput`](crate::output::ListAssignmentsForHitOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListAssignmentsForHitOutput::next_token): <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    ///   - [`num_results(Option<i32>)`](crate::output::ListAssignmentsForHitOutput::num_results): <p> The number of assignments on the page in the filtered results list, equivalent to the number of assignments returned by this call.</p>
    ///   - [`assignments(Option<Vec<Assignment>>)`](crate::output::ListAssignmentsForHitOutput::assignments): <p> The collection of Assignment data structures returned by this call.</p>
    /// - On failure, responds with [`SdkError<ListAssignmentsForHITError>`](crate::error::ListAssignmentsForHITError)
    pub fn list_assignments_for_hit(&self) -> fluent_builders::ListAssignmentsForHIT {
        fluent_builders::ListAssignmentsForHIT::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBonusPayments`](crate::client::fluent_builders::ListBonusPayments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBonusPayments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`hit_id(impl Into<String>)`](crate::client::fluent_builders::ListBonusPayments::hit_id) / [`set_hit_id(Option<String>)`](crate::client::fluent_builders::ListBonusPayments::set_hit_id): <p>The ID of the HIT associated with the bonus payments to retrieve. If not specified, all bonus payments for all assignments for the given HIT are returned. Either the HITId parameter or the AssignmentId parameter must be specified</p>
    ///   - [`assignment_id(impl Into<String>)`](crate::client::fluent_builders::ListBonusPayments::assignment_id) / [`set_assignment_id(Option<String>)`](crate::client::fluent_builders::ListBonusPayments::set_assignment_id): <p>The ID of the assignment associated with the bonus payments to retrieve. If specified, only bonus payments for the given assignment are returned. Either the HITId parameter or the AssignmentId parameter must be specified</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBonusPayments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBonusPayments::set_next_token): <p>Pagination token</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListBonusPayments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListBonusPayments::set_max_results): (undocumented)
    /// - On success, responds with [`ListBonusPaymentsOutput`](crate::output::ListBonusPaymentsOutput) with field(s):
    ///   - [`num_results(Option<i32>)`](crate::output::ListBonusPaymentsOutput::num_results): <p>The number of bonus payments on this page in the filtered results list, equivalent to the number of bonus payments being returned by this call. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBonusPaymentsOutput::next_token): <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    ///   - [`bonus_payments(Option<Vec<BonusPayment>>)`](crate::output::ListBonusPaymentsOutput::bonus_payments): <p>A successful request to the ListBonusPayments operation returns a list of BonusPayment objects. </p>
    /// - On failure, responds with [`SdkError<ListBonusPaymentsError>`](crate::error::ListBonusPaymentsError)
    pub fn list_bonus_payments(&self) -> fluent_builders::ListBonusPayments {
        fluent_builders::ListBonusPayments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListHITs`](crate::client::fluent_builders::ListHITs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListHITs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListHITs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListHITs::set_next_token): <p>Pagination token</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListHITs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListHITs::set_max_results): (undocumented)
    /// - On success, responds with [`ListHiTsOutput`](crate::output::ListHiTsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListHiTsOutput::next_token): <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    ///   - [`num_results(Option<i32>)`](crate::output::ListHiTsOutput::num_results): <p>The number of HITs on this page in the filtered results list, equivalent to the number of HITs being returned by this call.</p>
    ///   - [`hi_ts(Option<Vec<Hit>>)`](crate::output::ListHiTsOutput::hi_ts): <p> The list of HIT elements returned by the query.</p>
    /// - On failure, responds with [`SdkError<ListHITsError>`](crate::error::ListHITsError)
    pub fn list_hi_ts(&self) -> fluent_builders::ListHITs {
        fluent_builders::ListHITs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListHITsForQualificationType`](crate::client::fluent_builders::ListHITsForQualificationType) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListHITsForQualificationType::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`qualification_type_id(impl Into<String>)`](crate::client::fluent_builders::ListHITsForQualificationType::qualification_type_id) / [`set_qualification_type_id(Option<String>)`](crate::client::fluent_builders::ListHITsForQualificationType::set_qualification_type_id): <p> The ID of the Qualification type to use when querying HITs. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListHITsForQualificationType::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListHITsForQualificationType::set_next_token): <p>Pagination Token</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListHITsForQualificationType::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListHITsForQualificationType::set_max_results): <p> Limit the number of results returned. </p>
    /// - On success, responds with [`ListHiTsForQualificationTypeOutput`](crate::output::ListHiTsForQualificationTypeOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListHiTsForQualificationTypeOutput::next_token): <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    ///   - [`num_results(Option<i32>)`](crate::output::ListHiTsForQualificationTypeOutput::num_results): <p> The number of HITs on this page in the filtered results list, equivalent to the number of HITs being returned by this call. </p>
    ///   - [`hi_ts(Option<Vec<Hit>>)`](crate::output::ListHiTsForQualificationTypeOutput::hi_ts): <p> The list of HIT elements returned by the query.</p>
    /// - On failure, responds with [`SdkError<ListHITsForQualificationTypeError>`](crate::error::ListHITsForQualificationTypeError)
    pub fn list_hi_ts_for_qualification_type(
        &self,
    ) -> fluent_builders::ListHITsForQualificationType {
        fluent_builders::ListHITsForQualificationType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListQualificationRequests`](crate::client::fluent_builders::ListQualificationRequests) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListQualificationRequests::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`qualification_type_id(impl Into<String>)`](crate::client::fluent_builders::ListQualificationRequests::qualification_type_id) / [`set_qualification_type_id(Option<String>)`](crate::client::fluent_builders::ListQualificationRequests::set_qualification_type_id): <p>The ID of the QualificationType.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListQualificationRequests::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListQualificationRequests::set_next_token): <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListQualificationRequests::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListQualificationRequests::set_max_results): <p> The maximum number of results to return in a single call. </p>
    /// - On success, responds with [`ListQualificationRequestsOutput`](crate::output::ListQualificationRequestsOutput) with field(s):
    ///   - [`num_results(Option<i32>)`](crate::output::ListQualificationRequestsOutput::num_results): <p>The number of Qualification requests on this page in the filtered results list, equivalent to the number of Qualification requests being returned by this call.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListQualificationRequestsOutput::next_token): <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    ///   - [`qualification_requests(Option<Vec<QualificationRequest>>)`](crate::output::ListQualificationRequestsOutput::qualification_requests): <p>The Qualification request. The response includes one QualificationRequest element for each Qualification request returned by the query.</p>
    /// - On failure, responds with [`SdkError<ListQualificationRequestsError>`](crate::error::ListQualificationRequestsError)
    pub fn list_qualification_requests(&self) -> fluent_builders::ListQualificationRequests {
        fluent_builders::ListQualificationRequests::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListQualificationTypes`](crate::client::fluent_builders::ListQualificationTypes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListQualificationTypes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`query(impl Into<String>)`](crate::client::fluent_builders::ListQualificationTypes::query) / [`set_query(Option<String>)`](crate::client::fluent_builders::ListQualificationTypes::set_query): <p> A text query against all of the searchable attributes of Qualification types. </p>
    ///   - [`must_be_requestable(bool)`](crate::client::fluent_builders::ListQualificationTypes::must_be_requestable) / [`set_must_be_requestable(Option<bool>)`](crate::client::fluent_builders::ListQualificationTypes::set_must_be_requestable): <p>Specifies that only Qualification types that a user can request through the Amazon Mechanical Turk web site, such as by taking a Qualification test, are returned as results of the search. Some Qualification types, such as those assigned automatically by the system, cannot be requested directly by users. If false, all Qualification types, including those managed by the system, are considered. Valid values are True | False. </p>
    ///   - [`must_be_owned_by_caller(bool)`](crate::client::fluent_builders::ListQualificationTypes::must_be_owned_by_caller) / [`set_must_be_owned_by_caller(Option<bool>)`](crate::client::fluent_builders::ListQualificationTypes::set_must_be_owned_by_caller): <p> Specifies that only Qualification types that the Requester created are returned. If false, the operation returns all Qualification types. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListQualificationTypes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListQualificationTypes::set_next_token): <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListQualificationTypes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListQualificationTypes::set_max_results): <p> The maximum number of results to return in a single call. </p>
    /// - On success, responds with [`ListQualificationTypesOutput`](crate::output::ListQualificationTypesOutput) with field(s):
    ///   - [`num_results(Option<i32>)`](crate::output::ListQualificationTypesOutput::num_results): <p> The number of Qualification types on this page in the filtered results list, equivalent to the number of types this operation returns. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListQualificationTypesOutput::next_token): <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    ///   - [`qualification_types(Option<Vec<QualificationType>>)`](crate::output::ListQualificationTypesOutput::qualification_types): <p> The list of QualificationType elements returned by the query. </p>
    /// - On failure, responds with [`SdkError<ListQualificationTypesError>`](crate::error::ListQualificationTypesError)
    pub fn list_qualification_types(&self) -> fluent_builders::ListQualificationTypes {
        fluent_builders::ListQualificationTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListReviewableHITs`](crate::client::fluent_builders::ListReviewableHITs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListReviewableHITs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`hit_type_id(impl Into<String>)`](crate::client::fluent_builders::ListReviewableHITs::hit_type_id) / [`set_hit_type_id(Option<String>)`](crate::client::fluent_builders::ListReviewableHITs::set_hit_type_id): <p> The ID of the HIT type of the HITs to consider for the query. If not specified, all HITs for the Reviewer are considered </p>
    ///   - [`status(ReviewableHitStatus)`](crate::client::fluent_builders::ListReviewableHITs::status) / [`set_status(Option<ReviewableHitStatus>)`](crate::client::fluent_builders::ListReviewableHITs::set_status): <p> Can be either <code>Reviewable</code> or <code>Reviewing</code>. Reviewable is the default value. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListReviewableHITs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListReviewableHITs::set_next_token): <p>Pagination Token</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListReviewableHITs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListReviewableHITs::set_max_results): <p> Limit the number of results returned. </p>
    /// - On success, responds with [`ListReviewableHiTsOutput`](crate::output::ListReviewableHiTsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListReviewableHiTsOutput::next_token): <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    ///   - [`num_results(Option<i32>)`](crate::output::ListReviewableHiTsOutput::num_results): <p> The number of HITs on this page in the filtered results list, equivalent to the number of HITs being returned by this call. </p>
    ///   - [`hi_ts(Option<Vec<Hit>>)`](crate::output::ListReviewableHiTsOutput::hi_ts): <p> The list of HIT elements returned by the query.</p>
    /// - On failure, responds with [`SdkError<ListReviewableHITsError>`](crate::error::ListReviewableHITsError)
    pub fn list_reviewable_hi_ts(&self) -> fluent_builders::ListReviewableHITs {
        fluent_builders::ListReviewableHITs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListReviewPolicyResultsForHIT`](crate::client::fluent_builders::ListReviewPolicyResultsForHIT) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListReviewPolicyResultsForHIT::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`hit_id(impl Into<String>)`](crate::client::fluent_builders::ListReviewPolicyResultsForHIT::hit_id) / [`set_hit_id(Option<String>)`](crate::client::fluent_builders::ListReviewPolicyResultsForHIT::set_hit_id): <p>The unique identifier of the HIT to retrieve review results for.</p>
    ///   - [`policy_levels(Vec<ReviewPolicyLevel>)`](crate::client::fluent_builders::ListReviewPolicyResultsForHIT::policy_levels) / [`set_policy_levels(Option<Vec<ReviewPolicyLevel>>)`](crate::client::fluent_builders::ListReviewPolicyResultsForHIT::set_policy_levels): <p> The Policy Level(s) to retrieve review results for - HIT or Assignment. If omitted, the default behavior is to retrieve all data for both policy levels. For a list of all the described policies, see Review Policies. </p>
    ///   - [`retrieve_actions(bool)`](crate::client::fluent_builders::ListReviewPolicyResultsForHIT::retrieve_actions) / [`set_retrieve_actions(Option<bool>)`](crate::client::fluent_builders::ListReviewPolicyResultsForHIT::set_retrieve_actions): <p> Specify if the operation should retrieve a list of the actions taken executing the Review Policies and their outcomes. </p>
    ///   - [`retrieve_results(bool)`](crate::client::fluent_builders::ListReviewPolicyResultsForHIT::retrieve_results) / [`set_retrieve_results(Option<bool>)`](crate::client::fluent_builders::ListReviewPolicyResultsForHIT::set_retrieve_results): <p> Specify if the operation should retrieve a list of the results computed by the Review Policies. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListReviewPolicyResultsForHIT::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListReviewPolicyResultsForHIT::set_next_token): <p>Pagination token</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListReviewPolicyResultsForHIT::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListReviewPolicyResultsForHIT::set_max_results): <p>Limit the number of results returned.</p>
    /// - On success, responds with [`ListReviewPolicyResultsForHitOutput`](crate::output::ListReviewPolicyResultsForHitOutput) with field(s):
    ///   - [`hit_id(Option<String>)`](crate::output::ListReviewPolicyResultsForHitOutput::hit_id): <p>The HITId of the HIT for which results have been returned.</p>
    ///   - [`assignment_review_policy(Option<ReviewPolicy>)`](crate::output::ListReviewPolicyResultsForHitOutput::assignment_review_policy): <p> The name of the Assignment-level Review Policy. This contains only the PolicyName element. </p>
    ///   - [`hit_review_policy(Option<ReviewPolicy>)`](crate::output::ListReviewPolicyResultsForHitOutput::hit_review_policy): <p>The name of the HIT-level Review Policy. This contains only the PolicyName element.</p>
    ///   - [`assignment_review_report(Option<ReviewReport>)`](crate::output::ListReviewPolicyResultsForHitOutput::assignment_review_report): <p> Contains both ReviewResult and ReviewAction elements for an Assignment. </p>
    ///   - [`hit_review_report(Option<ReviewReport>)`](crate::output::ListReviewPolicyResultsForHitOutput::hit_review_report): <p>Contains both ReviewResult and ReviewAction elements for a particular HIT. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListReviewPolicyResultsForHitOutput::next_token): <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListReviewPolicyResultsForHITError>`](crate::error::ListReviewPolicyResultsForHITError)
    pub fn list_review_policy_results_for_hit(
        &self,
    ) -> fluent_builders::ListReviewPolicyResultsForHIT {
        fluent_builders::ListReviewPolicyResultsForHIT::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListWorkerBlocks`](crate::client::fluent_builders::ListWorkerBlocks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListWorkerBlocks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListWorkerBlocks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListWorkerBlocks::set_next_token): <p>Pagination token</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListWorkerBlocks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListWorkerBlocks::set_max_results): (undocumented)
    /// - On success, responds with [`ListWorkerBlocksOutput`](crate::output::ListWorkerBlocksOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListWorkerBlocksOutput::next_token): <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    ///   - [`num_results(Option<i32>)`](crate::output::ListWorkerBlocksOutput::num_results): <p> The number of assignments on the page in the filtered results list, equivalent to the number of assignments returned by this call.</p>
    ///   - [`worker_blocks(Option<Vec<WorkerBlock>>)`](crate::output::ListWorkerBlocksOutput::worker_blocks): <p> The list of WorkerBlocks, containing the collection of Worker IDs and reasons for blocking.</p>
    /// - On failure, responds with [`SdkError<ListWorkerBlocksError>`](crate::error::ListWorkerBlocksError)
    pub fn list_worker_blocks(&self) -> fluent_builders::ListWorkerBlocks {
        fluent_builders::ListWorkerBlocks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListWorkersWithQualificationType`](crate::client::fluent_builders::ListWorkersWithQualificationType) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListWorkersWithQualificationType::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`qualification_type_id(impl Into<String>)`](crate::client::fluent_builders::ListWorkersWithQualificationType::qualification_type_id) / [`set_qualification_type_id(Option<String>)`](crate::client::fluent_builders::ListWorkersWithQualificationType::set_qualification_type_id): <p>The ID of the Qualification type of the Qualifications to return.</p>
    ///   - [`status(QualificationStatus)`](crate::client::fluent_builders::ListWorkersWithQualificationType::status) / [`set_status(Option<QualificationStatus>)`](crate::client::fluent_builders::ListWorkersWithQualificationType::set_status): <p> The status of the Qualifications to return. Can be <code>Granted | Revoked</code>. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListWorkersWithQualificationType::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListWorkersWithQualificationType::set_next_token): <p>Pagination Token</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListWorkersWithQualificationType::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListWorkersWithQualificationType::set_max_results): <p> Limit the number of results returned. </p>
    /// - On success, responds with [`ListWorkersWithQualificationTypeOutput`](crate::output::ListWorkersWithQualificationTypeOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListWorkersWithQualificationTypeOutput::next_token): <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    ///   - [`num_results(Option<i32>)`](crate::output::ListWorkersWithQualificationTypeOutput::num_results): <p> The number of Qualifications on this page in the filtered results list, equivalent to the number of Qualifications being returned by this call.</p>
    ///   - [`qualifications(Option<Vec<Qualification>>)`](crate::output::ListWorkersWithQualificationTypeOutput::qualifications): <p> The list of Qualification elements returned by this call. </p>
    /// - On failure, responds with [`SdkError<ListWorkersWithQualificationTypeError>`](crate::error::ListWorkersWithQualificationTypeError)
    pub fn list_workers_with_qualification_type(
        &self,
    ) -> fluent_builders::ListWorkersWithQualificationType {
        fluent_builders::ListWorkersWithQualificationType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`NotifyWorkers`](crate::client::fluent_builders::NotifyWorkers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subject(impl Into<String>)`](crate::client::fluent_builders::NotifyWorkers::subject) / [`set_subject(Option<String>)`](crate::client::fluent_builders::NotifyWorkers::set_subject): <p>The subject line of the email message to send. Can include up to 200 characters.</p>
    ///   - [`message_text(impl Into<String>)`](crate::client::fluent_builders::NotifyWorkers::message_text) / [`set_message_text(Option<String>)`](crate::client::fluent_builders::NotifyWorkers::set_message_text): <p>The text of the email message to send. Can include up to 4,096 characters</p>
    ///   - [`worker_ids(Vec<String>)`](crate::client::fluent_builders::NotifyWorkers::worker_ids) / [`set_worker_ids(Option<Vec<String>>)`](crate::client::fluent_builders::NotifyWorkers::set_worker_ids): <p>A list of Worker IDs you wish to notify. You can notify upto 100 Workers at a time.</p>
    /// - On success, responds with [`NotifyWorkersOutput`](crate::output::NotifyWorkersOutput) with field(s):
    ///   - [`notify_workers_failure_statuses(Option<Vec<NotifyWorkersFailureStatus>>)`](crate::output::NotifyWorkersOutput::notify_workers_failure_statuses): <p> When MTurk sends notifications to the list of Workers, it returns back any failures it encounters in this list of NotifyWorkersFailureStatus objects. </p>
    /// - On failure, responds with [`SdkError<NotifyWorkersError>`](crate::error::NotifyWorkersError)
    pub fn notify_workers(&self) -> fluent_builders::NotifyWorkers {
        fluent_builders::NotifyWorkers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RejectAssignment`](crate::client::fluent_builders::RejectAssignment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assignment_id(impl Into<String>)`](crate::client::fluent_builders::RejectAssignment::assignment_id) / [`set_assignment_id(Option<String>)`](crate::client::fluent_builders::RejectAssignment::set_assignment_id): <p> The ID of the assignment. The assignment must correspond to a HIT created by the Requester. </p>
    ///   - [`requester_feedback(impl Into<String>)`](crate::client::fluent_builders::RejectAssignment::requester_feedback) / [`set_requester_feedback(Option<String>)`](crate::client::fluent_builders::RejectAssignment::set_requester_feedback): <p> A message for the Worker, which the Worker can see in the Status section of the web site. </p>
    /// - On success, responds with [`RejectAssignmentOutput`](crate::output::RejectAssignmentOutput)

    /// - On failure, responds with [`SdkError<RejectAssignmentError>`](crate::error::RejectAssignmentError)
    pub fn reject_assignment(&self) -> fluent_builders::RejectAssignment {
        fluent_builders::RejectAssignment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RejectQualificationRequest`](crate::client::fluent_builders::RejectQualificationRequest) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`qualification_request_id(impl Into<String>)`](crate::client::fluent_builders::RejectQualificationRequest::qualification_request_id) / [`set_qualification_request_id(Option<String>)`](crate::client::fluent_builders::RejectQualificationRequest::set_qualification_request_id): <p> The ID of the Qualification request, as returned by the <code>ListQualificationRequests</code> operation. </p>
    ///   - [`reason(impl Into<String>)`](crate::client::fluent_builders::RejectQualificationRequest::reason) / [`set_reason(Option<String>)`](crate::client::fluent_builders::RejectQualificationRequest::set_reason): <p>A text message explaining why the request was rejected, to be shown to the Worker who made the request.</p>
    /// - On success, responds with [`RejectQualificationRequestOutput`](crate::output::RejectQualificationRequestOutput)

    /// - On failure, responds with [`SdkError<RejectQualificationRequestError>`](crate::error::RejectQualificationRequestError)
    pub fn reject_qualification_request(&self) -> fluent_builders::RejectQualificationRequest {
        fluent_builders::RejectQualificationRequest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendBonus`](crate::client::fluent_builders::SendBonus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`worker_id(impl Into<String>)`](crate::client::fluent_builders::SendBonus::worker_id) / [`set_worker_id(Option<String>)`](crate::client::fluent_builders::SendBonus::set_worker_id): <p>The ID of the Worker being paid the bonus.</p>
    ///   - [`bonus_amount(impl Into<String>)`](crate::client::fluent_builders::SendBonus::bonus_amount) / [`set_bonus_amount(Option<String>)`](crate::client::fluent_builders::SendBonus::set_bonus_amount): <p> The Bonus amount is a US Dollar amount specified using a string (for example, "5" represents $5.00 USD and "101.42" represents $101.42 USD). Do not include currency symbols or currency codes. </p>
    ///   - [`assignment_id(impl Into<String>)`](crate::client::fluent_builders::SendBonus::assignment_id) / [`set_assignment_id(Option<String>)`](crate::client::fluent_builders::SendBonus::set_assignment_id): <p>The ID of the assignment for which this bonus is paid.</p>
    ///   - [`reason(impl Into<String>)`](crate::client::fluent_builders::SendBonus::reason) / [`set_reason(Option<String>)`](crate::client::fluent_builders::SendBonus::set_reason): <p>A message that explains the reason for the bonus payment. The Worker receiving the bonus can see this message.</p>
    ///   - [`unique_request_token(impl Into<String>)`](crate::client::fluent_builders::SendBonus::unique_request_token) / [`set_unique_request_token(Option<String>)`](crate::client::fluent_builders::SendBonus::set_unique_request_token): <p>A unique identifier for this request, which allows you to retry the call on error without granting multiple bonuses. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the bonus already exists in the system from a previous call using the same UniqueRequestToken, subsequent calls will return an error with a message containing the request ID.</p>
    /// - On success, responds with [`SendBonusOutput`](crate::output::SendBonusOutput)

    /// - On failure, responds with [`SdkError<SendBonusError>`](crate::error::SendBonusError)
    pub fn send_bonus(&self) -> fluent_builders::SendBonus {
        fluent_builders::SendBonus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendTestEventNotification`](crate::client::fluent_builders::SendTestEventNotification) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`notification(NotificationSpecification)`](crate::client::fluent_builders::SendTestEventNotification::notification) / [`set_notification(Option<NotificationSpecification>)`](crate::client::fluent_builders::SendTestEventNotification::set_notification): <p> The notification specification to test. This value is identical to the value you would provide to the UpdateNotificationSettings operation when you establish the notification specification for a HIT type. </p>
    ///   - [`test_event_type(EventType)`](crate::client::fluent_builders::SendTestEventNotification::test_event_type) / [`set_test_event_type(Option<EventType>)`](crate::client::fluent_builders::SendTestEventNotification::set_test_event_type): <p> The event to simulate to test the notification specification. This event is included in the test message even if the notification specification does not include the event type. The notification specification does not filter out the test event. </p>
    /// - On success, responds with [`SendTestEventNotificationOutput`](crate::output::SendTestEventNotificationOutput)

    /// - On failure, responds with [`SdkError<SendTestEventNotificationError>`](crate::error::SendTestEventNotificationError)
    pub fn send_test_event_notification(&self) -> fluent_builders::SendTestEventNotification {
        fluent_builders::SendTestEventNotification::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateExpirationForHIT`](crate::client::fluent_builders::UpdateExpirationForHIT) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hit_id(impl Into<String>)`](crate::client::fluent_builders::UpdateExpirationForHIT::hit_id) / [`set_hit_id(Option<String>)`](crate::client::fluent_builders::UpdateExpirationForHIT::set_hit_id): <p> The HIT to update. </p>
    ///   - [`expire_at(DateTime)`](crate::client::fluent_builders::UpdateExpirationForHIT::expire_at) / [`set_expire_at(Option<DateTime>)`](crate::client::fluent_builders::UpdateExpirationForHIT::set_expire_at): <p> The date and time at which you want the HIT to expire </p>
    /// - On success, responds with [`UpdateExpirationForHitOutput`](crate::output::UpdateExpirationForHitOutput)

    /// - On failure, responds with [`SdkError<UpdateExpirationForHITError>`](crate::error::UpdateExpirationForHITError)
    pub fn update_expiration_for_hit(&self) -> fluent_builders::UpdateExpirationForHIT {
        fluent_builders::UpdateExpirationForHIT::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateHITReviewStatus`](crate::client::fluent_builders::UpdateHITReviewStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hit_id(impl Into<String>)`](crate::client::fluent_builders::UpdateHITReviewStatus::hit_id) / [`set_hit_id(Option<String>)`](crate::client::fluent_builders::UpdateHITReviewStatus::set_hit_id): <p> The ID of the HIT to update. </p>
    ///   - [`revert(bool)`](crate::client::fluent_builders::UpdateHITReviewStatus::revert) / [`set_revert(Option<bool>)`](crate::client::fluent_builders::UpdateHITReviewStatus::set_revert): <p> Specifies how to update the HIT status. Default is <code>False</code>. </p>  <ul>   <li> <p> Setting this to false will only transition a HIT from <code>Reviewable</code> to <code>Reviewing</code> </p> </li>   <li> <p> Setting this to true will only transition a HIT from <code>Reviewing</code> to <code>Reviewable</code> </p> </li>  </ul>
    /// - On success, responds with [`UpdateHitReviewStatusOutput`](crate::output::UpdateHitReviewStatusOutput)

    /// - On failure, responds with [`SdkError<UpdateHITReviewStatusError>`](crate::error::UpdateHITReviewStatusError)
    pub fn update_hit_review_status(&self) -> fluent_builders::UpdateHITReviewStatus {
        fluent_builders::UpdateHITReviewStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateHITTypeOfHIT`](crate::client::fluent_builders::UpdateHITTypeOfHIT) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hit_id(impl Into<String>)`](crate::client::fluent_builders::UpdateHITTypeOfHIT::hit_id) / [`set_hit_id(Option<String>)`](crate::client::fluent_builders::UpdateHITTypeOfHIT::set_hit_id): <p>The HIT to update.</p>
    ///   - [`hit_type_id(impl Into<String>)`](crate::client::fluent_builders::UpdateHITTypeOfHIT::hit_type_id) / [`set_hit_type_id(Option<String>)`](crate::client::fluent_builders::UpdateHITTypeOfHIT::set_hit_type_id): <p>The ID of the new HIT type.</p>
    /// - On success, responds with [`UpdateHitTypeOfHitOutput`](crate::output::UpdateHitTypeOfHitOutput)

    /// - On failure, responds with [`SdkError<UpdateHITTypeOfHITError>`](crate::error::UpdateHITTypeOfHITError)
    pub fn update_hit_type_of_hit(&self) -> fluent_builders::UpdateHITTypeOfHIT {
        fluent_builders::UpdateHITTypeOfHIT::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateNotificationSettings`](crate::client::fluent_builders::UpdateNotificationSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hit_type_id(impl Into<String>)`](crate::client::fluent_builders::UpdateNotificationSettings::hit_type_id) / [`set_hit_type_id(Option<String>)`](crate::client::fluent_builders::UpdateNotificationSettings::set_hit_type_id): <p> The ID of the HIT type whose notification specification is being updated. </p>
    ///   - [`notification(NotificationSpecification)`](crate::client::fluent_builders::UpdateNotificationSettings::notification) / [`set_notification(Option<NotificationSpecification>)`](crate::client::fluent_builders::UpdateNotificationSettings::set_notification): <p> The notification specification for the HIT type. </p>
    ///   - [`active(bool)`](crate::client::fluent_builders::UpdateNotificationSettings::active) / [`set_active(Option<bool>)`](crate::client::fluent_builders::UpdateNotificationSettings::set_active): <p> Specifies whether notifications are sent for HITs of this HIT type, according to the notification specification. You must specify either the Notification parameter or the Active parameter for the call to UpdateNotificationSettings to succeed. </p>
    /// - On success, responds with [`UpdateNotificationSettingsOutput`](crate::output::UpdateNotificationSettingsOutput)

    /// - On failure, responds with [`SdkError<UpdateNotificationSettingsError>`](crate::error::UpdateNotificationSettingsError)
    pub fn update_notification_settings(&self) -> fluent_builders::UpdateNotificationSettings {
        fluent_builders::UpdateNotificationSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateQualificationType`](crate::client::fluent_builders::UpdateQualificationType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`qualification_type_id(impl Into<String>)`](crate::client::fluent_builders::UpdateQualificationType::qualification_type_id) / [`set_qualification_type_id(Option<String>)`](crate::client::fluent_builders::UpdateQualificationType::set_qualification_type_id): <p>The ID of the Qualification type to update.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateQualificationType::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateQualificationType::set_description): <p>The new description of the Qualification type.</p>
    ///   - [`qualification_type_status(QualificationTypeStatus)`](crate::client::fluent_builders::UpdateQualificationType::qualification_type_status) / [`set_qualification_type_status(Option<QualificationTypeStatus>)`](crate::client::fluent_builders::UpdateQualificationType::set_qualification_type_status): <p>The new status of the Qualification type - Active | Inactive</p>
    ///   - [`test(impl Into<String>)`](crate::client::fluent_builders::UpdateQualificationType::test) / [`set_test(Option<String>)`](crate::client::fluent_builders::UpdateQualificationType::set_test): <p>The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified.</p>  <p>Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be specified if AutoGranted is true.</p>  <p>Constraints: None. If not specified, the Worker may request the Qualification without answering any questions.</p>
    ///   - [`answer_key(impl Into<String>)`](crate::client::fluent_builders::UpdateQualificationType::answer_key) / [`set_answer_key(Option<String>)`](crate::client::fluent_builders::UpdateQualificationType::set_answer_key): <p>The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data structure.</p>
    ///   - [`test_duration_in_seconds(i64)`](crate::client::fluent_builders::UpdateQualificationType::test_duration_in_seconds) / [`set_test_duration_in_seconds(Option<i64>)`](crate::client::fluent_builders::UpdateQualificationType::set_test_duration_in_seconds): <p>The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker requests the Qualification.</p>
    ///   - [`retry_delay_in_seconds(i64)`](crate::client::fluent_builders::UpdateQualificationType::retry_delay_in_seconds) / [`set_retry_delay_in_seconds(Option<i64>)`](crate::client::fluent_builders::UpdateQualificationType::set_retry_delay_in_seconds): <p>The amount of time, in seconds, that Workers must wait after requesting a Qualification of the specified Qualification type before they can retry the Qualification request. It is not possible to disable retries for a Qualification type after it has been created with retries enabled. If you want to disable retries, you must dispose of the existing retry-enabled Qualification type using DisposeQualificationType and then create a new Qualification type with retries disabled using CreateQualificationType.</p>
    ///   - [`auto_granted(bool)`](crate::client::fluent_builders::UpdateQualificationType::auto_granted) / [`set_auto_granted(Option<bool>)`](crate::client::fluent_builders::UpdateQualificationType::set_auto_granted): <p>Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test.</p>  <p>Constraints: If the Test parameter is specified, this parameter cannot be true.</p>
    ///   - [`auto_granted_value(i32)`](crate::client::fluent_builders::UpdateQualificationType::auto_granted_value) / [`set_auto_granted_value(Option<i32>)`](crate::client::fluent_builders::UpdateQualificationType::set_auto_granted_value): <p>The Qualification value to use for automatically granted Qualifications. This parameter is used only if the AutoGranted parameter is true.</p>
    /// - On success, responds with [`UpdateQualificationTypeOutput`](crate::output::UpdateQualificationTypeOutput) with field(s):
    ///   - [`qualification_type(Option<QualificationType>)`](crate::output::UpdateQualificationTypeOutput::qualification_type): <p> Contains a QualificationType data structure.</p>
    /// - On failure, responds with [`SdkError<UpdateQualificationTypeError>`](crate::error::UpdateQualificationTypeError)
    pub fn update_qualification_type(&self) -> fluent_builders::UpdateQualificationType {
        fluent_builders::UpdateQualificationType::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptQualificationRequest`.
    ///
    /// <p> The <code>AcceptQualificationRequest</code> operation approves a Worker's request for a Qualification. </p>
    /// <p> Only the owner of the Qualification type can grant a Qualification request for that type. </p>
    /// <p> A successful request for the <code>AcceptQualificationRequest</code> operation returns with no errors and an empty body. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptQualificationRequest {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::accept_qualification_request_input::Builder,
    }
    impl AcceptQualificationRequest {
        /// Creates a new `AcceptQualificationRequest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptQualificationRequestOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptQualificationRequestError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Qualification request, as returned by the <code>GetQualificationRequests</code> operation.</p>
        pub fn qualification_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_request_id(input.into());
            self
        }
        /// <p>The ID of the Qualification request, as returned by the <code>GetQualificationRequests</code> operation.</p>
        pub fn set_qualification_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_request_id(input);
            self
        }
        /// <p> The value of the Qualification. You can omit this value if you are using the presence or absence of the Qualification as the basis for a HIT requirement. </p>
        pub fn integer_value(mut self, input: i32) -> Self {
            self.inner = self.inner.integer_value(input);
            self
        }
        /// <p> The value of the Qualification. You can omit this value if you are using the presence or absence of the Qualification as the basis for a HIT requirement. </p>
        pub fn set_integer_value(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_integer_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ApproveAssignment`.
    ///
    /// <p> The <code>ApproveAssignment</code> operation approves the results of a completed assignment. </p>
    /// <p> Approving an assignment initiates two payments from the Requester's Amazon.com account </p>
    /// <ul>
    /// <li> <p> The Worker who submitted the results is paid the reward specified in the HIT. </p> </li>
    /// <li> <p> Amazon Mechanical Turk fees are debited. </p> </li>
    /// </ul>
    /// <p> If the Requester's account does not have adequate funds for these payments, the call to ApproveAssignment returns an exception, and the approval is not processed. You can include an optional feedback message with the approval, which the Worker can see in the Status section of the web site. </p>
    /// <p> You can also call this operation for assignments that were previous rejected and approve them by explicitly overriding the previous rejection. This only works on rejected assignments that were submitted within the previous 30 days and only if the assignment's related HIT has not been deleted. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ApproveAssignment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::approve_assignment_input::Builder,
    }
    impl ApproveAssignment {
        /// Creates a new `ApproveAssignment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ApproveAssignmentOutput,
            aws_smithy_http::result::SdkError<crate::error::ApproveAssignmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the assignment. The assignment must correspond to a HIT created by the Requester. </p>
        pub fn assignment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_id(input.into());
            self
        }
        /// <p> The ID of the assignment. The assignment must correspond to a HIT created by the Requester. </p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_id(input);
            self
        }
        /// <p> A message for the Worker, which the Worker can see in the Status section of the web site. </p>
        pub fn requester_feedback(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.requester_feedback(input.into());
            self
        }
        /// <p> A message for the Worker, which the Worker can see in the Status section of the web site. </p>
        pub fn set_requester_feedback(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_requester_feedback(input);
            self
        }
        /// <p> A flag indicating that an assignment should be approved even if it was previously rejected. Defaults to <code>False</code>. </p>
        pub fn override_rejection(mut self, input: bool) -> Self {
            self.inner = self.inner.override_rejection(input);
            self
        }
        /// <p> A flag indicating that an assignment should be approved even if it was previously rejected. Defaults to <code>False</code>. </p>
        pub fn set_override_rejection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_override_rejection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateQualificationWithWorker`.
    ///
    /// <p> The <code>AssociateQualificationWithWorker</code> operation gives a Worker a Qualification. <code>AssociateQualificationWithWorker</code> does not require that the Worker submit a Qualification request. It gives the Qualification directly to the Worker. </p>
    /// <p> You can only assign a Qualification of a Qualification type that you created (using the <code>CreateQualificationType</code> operation). </p> <note>
    /// <p> Note: <code>AssociateQualificationWithWorker</code> does not affect any pending Qualification requests for the Qualification by the Worker. If you assign a Qualification to a Worker, then later grant a Qualification request made by the Worker, the granting of the request may modify the Qualification score. To resolve a pending Qualification request without affecting the Qualification the Worker already has, reject the request with the <code>RejectQualificationRequest</code> operation. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateQualificationWithWorker {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_qualification_with_worker_input::Builder,
    }
    impl AssociateQualificationWithWorker {
        /// Creates a new `AssociateQualificationWithWorker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateQualificationWithWorkerOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateQualificationWithWorkerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Qualification type to use for the assigned Qualification.</p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_type_id(input.into());
            self
        }
        /// <p>The ID of the Qualification type to use for the assigned Qualification.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_id(input);
            self
        }
        /// <p> The ID of the Worker to whom the Qualification is being assigned. Worker IDs are included with submitted HIT assignments and Qualification requests. </p>
        pub fn worker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worker_id(input.into());
            self
        }
        /// <p> The ID of the Worker to whom the Qualification is being assigned. Worker IDs are included with submitted HIT assignments and Qualification requests. </p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_worker_id(input);
            self
        }
        /// <p>The value of the Qualification to assign.</p>
        pub fn integer_value(mut self, input: i32) -> Self {
            self.inner = self.inner.integer_value(input);
            self
        }
        /// <p>The value of the Qualification to assign.</p>
        pub fn set_integer_value(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_integer_value(input);
            self
        }
        /// <p> Specifies whether to send a notification email message to the Worker saying that the qualification was assigned to the Worker. Note: this is true by default. </p>
        pub fn send_notification(mut self, input: bool) -> Self {
            self.inner = self.inner.send_notification(input);
            self
        }
        /// <p> Specifies whether to send a notification email message to the Worker saying that the qualification was assigned to the Worker. Note: this is true by default. </p>
        pub fn set_send_notification(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_send_notification(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAdditionalAssignmentsForHIT`.
    ///
    /// <p> The <code>CreateAdditionalAssignmentsForHIT</code> operation increases the maximum number of assignments of an existing HIT. </p>
    /// <p> To extend the maximum number of assignments, specify the number of additional assignments.</p> <note>
    /// <ul>
    /// <li> <p>HITs created with fewer than 10 assignments cannot be extended to have 10 or more assignments. Attempting to add assignments in a way that brings the total number of assignments for a HIT from fewer than 10 assignments to 10 or more assignments will result in an <code>AWS.MechanicalTurk.InvalidMaximumAssignmentsIncrease</code> exception.</p> </li>
    /// <li> <p>HITs that were created before July 22, 2015 cannot be extended. Attempting to extend HITs that were created before July 22, 2015 will result in an <code>AWS.MechanicalTurk.HITTooOldForExtension</code> exception. </p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAdditionalAssignmentsForHIT {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_additional_assignments_for_hit_input::Builder,
    }
    impl CreateAdditionalAssignmentsForHIT {
        /// Creates a new `CreateAdditionalAssignmentsForHIT`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAdditionalAssignmentsForHitOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAdditionalAssignmentsForHITError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the HIT to extend.</p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_id(input.into());
            self
        }
        /// <p>The ID of the HIT to extend.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_id(input);
            self
        }
        /// <p>The number of additional assignments to request for this HIT.</p>
        pub fn number_of_additional_assignments(mut self, input: i32) -> Self {
            self.inner = self.inner.number_of_additional_assignments(input);
            self
        }
        /// <p>The number of additional assignments to request for this HIT.</p>
        pub fn set_number_of_additional_assignments(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_number_of_additional_assignments(input);
            self
        }
        /// <p> A unique identifier for this request, which allows you to retry the call on error without extending the HIT multiple times. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the extend HIT already exists in the system from a previous call using the same <code>UniqueRequestToken</code>, subsequent calls will return an error with a message containing the request ID. </p>
        pub fn unique_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.unique_request_token(input.into());
            self
        }
        /// <p> A unique identifier for this request, which allows you to retry the call on error without extending the HIT multiple times. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the extend HIT already exists in the system from a previous call using the same <code>UniqueRequestToken</code>, subsequent calls will return an error with a message containing the request ID. </p>
        pub fn set_unique_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_unique_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHIT`.
    ///
    /// <p>The <code>CreateHIT</code> operation creates a new Human Intelligence Task (HIT). The new HIT is made available for Workers to find and accept on the Amazon Mechanical Turk website. </p>
    /// <p> This operation allows you to specify a new HIT by passing in values for the properties of the HIT, such as its title, reward amount and number of assignments. When you pass these values to <code>CreateHIT</code>, a new HIT is created for you, with a new <code>HITTypeID</code>. The HITTypeID can be used to create additional HITs in the future without needing to specify common parameters such as the title, description and reward amount each time.</p>
    /// <p> An alternative way to create HITs is to first generate a HITTypeID using the <code>CreateHITType</code> operation and then call the <code>CreateHITWithHITType</code> operation. This is the recommended best practice for Requesters who are creating large numbers of HITs. </p>
    /// <p>CreateHIT also supports several ways to provide question data: by providing a value for the <code>Question</code> parameter that fully specifies the contents of the HIT, or by providing a <code>HitLayoutId</code> and associated <code>HitLayoutParameters</code>. </p> <note>
    /// <p> If a HIT is created with 10 or more maximum assignments, there is an additional fee. For more information, see <a href="https://requester.mturk.com/pricing">Amazon Mechanical Turk Pricing</a>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHIT {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_hit_input::Builder,
    }
    impl CreateHIT {
        /// Creates a new `CreateHIT`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHitOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHITError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The number of times the HIT can be accepted and completed before the HIT becomes unavailable. </p>
        pub fn max_assignments(mut self, input: i32) -> Self {
            self.inner = self.inner.max_assignments(input);
            self
        }
        /// <p> The number of times the HIT can be accepted and completed before the HIT becomes unavailable. </p>
        pub fn set_max_assignments(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_assignments(input);
            self
        }
        /// <p> The number of seconds after an assignment for the HIT has been submitted, after which the assignment is considered Approved automatically unless the Requester explicitly rejects it. </p>
        pub fn auto_approval_delay_in_seconds(mut self, input: i64) -> Self {
            self.inner = self.inner.auto_approval_delay_in_seconds(input);
            self
        }
        /// <p> The number of seconds after an assignment for the HIT has been submitted, after which the assignment is considered Approved automatically unless the Requester explicitly rejects it. </p>
        pub fn set_auto_approval_delay_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self.inner.set_auto_approval_delay_in_seconds(input);
            self
        }
        /// <p> An amount of time, in seconds, after which the HIT is no longer available for users to accept. After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches, even if not all of the assignments for the HIT have been accepted. </p>
        pub fn lifetime_in_seconds(mut self, input: i64) -> Self {
            self.inner = self.inner.lifetime_in_seconds(input);
            self
        }
        /// <p> An amount of time, in seconds, after which the HIT is no longer available for users to accept. After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches, even if not all of the assignments for the HIT have been accepted. </p>
        pub fn set_lifetime_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_lifetime_in_seconds(input);
            self
        }
        /// <p> The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker does not complete the assignment within the specified duration, the assignment is considered abandoned. If the HIT is still active (that is, its lifetime has not elapsed), the assignment becomes available for other users to find and accept. </p>
        pub fn assignment_duration_in_seconds(mut self, input: i64) -> Self {
            self.inner = self.inner.assignment_duration_in_seconds(input);
            self
        }
        /// <p> The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker does not complete the assignment within the specified duration, the assignment is considered abandoned. If the HIT is still active (that is, its lifetime has not elapsed), the assignment becomes available for other users to find and accept. </p>
        pub fn set_assignment_duration_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self.inner.set_assignment_duration_in_seconds(input);
            self
        }
        /// <p> The amount of money the Requester will pay a Worker for successfully completing the HIT. </p>
        pub fn reward(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reward(input.into());
            self
        }
        /// <p> The amount of money the Requester will pay a Worker for successfully completing the HIT. </p>
        pub fn set_reward(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reward(input);
            self
        }
        /// <p> The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the HIT is mentioned. </p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.title(input.into());
            self
        }
        /// <p> The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the HIT is mentioned. </p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_title(input);
            self
        }
        /// <p> One or more words or phrases that describe the HIT, separated by commas. These words are used in searches to find HITs. </p>
        pub fn keywords(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keywords(input.into());
            self
        }
        /// <p> One or more words or phrases that describe the HIT, separated by commas. These words are used in searches to find HITs. </p>
        pub fn set_keywords(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_keywords(input);
            self
        }
        /// <p> A general description of the HIT. A description includes detailed information about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded view of search results, and in the HIT and assignment screens. A good description gives the user enough information to evaluate the HIT before accepting it. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> A general description of the HIT. A description includes detailed information about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded view of search results, and in the HIT and assignment screens. A good description gives the user enough information to evaluate the HIT before accepting it. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The data the person completing the HIT uses to produce the results. </p>
        /// <p> Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure, or an HTMLQuestion data structure. The XML question data must not be larger than 64 kilobytes (65,535 bytes) in size, including whitespace. </p>
        /// <p>Either a Question parameter or a HITLayoutId parameter must be provided.</p>
        pub fn question(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.question(input.into());
            self
        }
        /// <p> The data the person completing the HIT uses to produce the results. </p>
        /// <p> Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure, or an HTMLQuestion data structure. The XML question data must not be larger than 64 kilobytes (65,535 bytes) in size, including whitespace. </p>
        /// <p>Either a Question parameter or a HITLayoutId parameter must be provided.</p>
        pub fn set_question(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_question(input);
            self
        }
        /// <p> An arbitrary data field. The RequesterAnnotation parameter lets your application attach arbitrary data to the HIT for tracking purposes. For example, this parameter could be an identifier internal to the Requester's application that corresponds with the HIT. </p>
        /// <p> The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT. It is not shown to the Worker, or any other Requester. </p>
        /// <p> The RequesterAnnotation parameter may be different for each HIT you submit. It does not affect how your HITs are grouped. </p>
        pub fn requester_annotation(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.requester_annotation(input.into());
            self
        }
        /// <p> An arbitrary data field. The RequesterAnnotation parameter lets your application attach arbitrary data to the HIT for tracking purposes. For example, this parameter could be an identifier internal to the Requester's application that corresponds with the HIT. </p>
        /// <p> The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT. It is not shown to the Worker, or any other Requester. </p>
        /// <p> The RequesterAnnotation parameter may be different for each HIT you submit. It does not affect how your HITs are grouped. </p>
        pub fn set_requester_annotation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_requester_annotation(input);
            self
        }
        /// Appends an item to `QualificationRequirements`.
        ///
        /// To override the contents of this collection use [`set_qualification_requirements`](Self::set_qualification_requirements).
        ///
        /// <p> Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT. Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each <code>QualificationRequirement</code> structure. </p>
        pub fn qualification_requirements(
            mut self,
            input: crate::model::QualificationRequirement,
        ) -> Self {
            self.inner = self.inner.qualification_requirements(input);
            self
        }
        /// <p> Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT. Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each <code>QualificationRequirement</code> structure. </p>
        pub fn set_qualification_requirements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QualificationRequirement>>,
        ) -> Self {
            self.inner = self.inner.set_qualification_requirements(input);
            self
        }
        /// <p> A unique identifier for this request which allows you to retry the call on error without creating duplicate HITs. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the HIT already exists in the system from a previous call using the same UniqueRequestToken, subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error with a message containing the HITId. </p> <note>
        /// <p> Note: It is your responsibility to ensure uniqueness of the token. The unique token expires after 24 hours. Subsequent calls using the same UniqueRequestToken made after the 24 hour limit could create duplicate HITs. </p>
        /// </note>
        pub fn unique_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.unique_request_token(input.into());
            self
        }
        /// <p> A unique identifier for this request which allows you to retry the call on error without creating duplicate HITs. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the HIT already exists in the system from a previous call using the same UniqueRequestToken, subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error with a message containing the HITId. </p> <note>
        /// <p> Note: It is your responsibility to ensure uniqueness of the token. The unique token expires after 24 hours. Subsequent calls using the same UniqueRequestToken made after the 24 hour limit could create duplicate HITs. </p>
        /// </note>
        pub fn set_unique_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_unique_request_token(input);
            self
        }
        /// <p> The Assignment-level Review Policy applies to the assignments under the HIT. You can specify for Mechanical Turk to take various actions based on the policy. </p>
        pub fn assignment_review_policy(mut self, input: crate::model::ReviewPolicy) -> Self {
            self.inner = self.inner.assignment_review_policy(input);
            self
        }
        /// <p> The Assignment-level Review Policy applies to the assignments under the HIT. You can specify for Mechanical Turk to take various actions based on the policy. </p>
        pub fn set_assignment_review_policy(
            mut self,
            input: std::option::Option<crate::model::ReviewPolicy>,
        ) -> Self {
            self.inner = self.inner.set_assignment_review_policy(input);
            self
        }
        /// <p> The HIT-level Review Policy applies to the HIT. You can specify for Mechanical Turk to take various actions based on the policy. </p>
        pub fn hit_review_policy(mut self, input: crate::model::ReviewPolicy) -> Self {
            self.inner = self.inner.hit_review_policy(input);
            self
        }
        /// <p> The HIT-level Review Policy applies to the HIT. You can specify for Mechanical Turk to take various actions based on the policy. </p>
        pub fn set_hit_review_policy(
            mut self,
            input: std::option::Option<crate::model::ReviewPolicy>,
        ) -> Self {
            self.inner = self.inner.set_hit_review_policy(input);
            self
        }
        /// <p> The HITLayoutId allows you to use a pre-existing HIT design with placeholder values and create an additional HIT by providing those values as HITLayoutParameters. </p>
        /// <p> Constraints: Either a Question parameter or a HITLayoutId parameter must be provided. </p>
        pub fn hit_layout_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_layout_id(input.into());
            self
        }
        /// <p> The HITLayoutId allows you to use a pre-existing HIT design with placeholder values and create an additional HIT by providing those values as HITLayoutParameters. </p>
        /// <p> Constraints: Either a Question parameter or a HITLayoutId parameter must be provided. </p>
        pub fn set_hit_layout_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hit_layout_id(input);
            self
        }
        /// Appends an item to `HITLayoutParameters`.
        ///
        /// To override the contents of this collection use [`set_hit_layout_parameters`](Self::set_hit_layout_parameters).
        ///
        /// <p> If the HITLayoutId is provided, any placeholder values must be filled in with values using the HITLayoutParameter structure. For more information, see HITLayout. </p>
        pub fn hit_layout_parameters(mut self, input: crate::model::HitLayoutParameter) -> Self {
            self.inner = self.inner.hit_layout_parameters(input);
            self
        }
        /// <p> If the HITLayoutId is provided, any placeholder values must be filled in with values using the HITLayoutParameter structure. For more information, see HITLayout. </p>
        pub fn set_hit_layout_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HitLayoutParameter>>,
        ) -> Self {
            self.inner = self.inner.set_hit_layout_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHITType`.
    ///
    /// <p> The <code>CreateHITType</code> operation creates a new HIT type. This operation allows you to define a standard set of HIT properties to use when creating HITs. If you register a HIT type with values that match an existing HIT type, the HIT type ID of the existing type will be returned. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHITType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_hit_type_input::Builder,
    }
    impl CreateHITType {
        /// Creates a new `CreateHITType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHitTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHITTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The number of seconds after an assignment for the HIT has been submitted, after which the assignment is considered Approved automatically unless the Requester explicitly rejects it. </p>
        pub fn auto_approval_delay_in_seconds(mut self, input: i64) -> Self {
            self.inner = self.inner.auto_approval_delay_in_seconds(input);
            self
        }
        /// <p> The number of seconds after an assignment for the HIT has been submitted, after which the assignment is considered Approved automatically unless the Requester explicitly rejects it. </p>
        pub fn set_auto_approval_delay_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self.inner.set_auto_approval_delay_in_seconds(input);
            self
        }
        /// <p> The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker does not complete the assignment within the specified duration, the assignment is considered abandoned. If the HIT is still active (that is, its lifetime has not elapsed), the assignment becomes available for other users to find and accept. </p>
        pub fn assignment_duration_in_seconds(mut self, input: i64) -> Self {
            self.inner = self.inner.assignment_duration_in_seconds(input);
            self
        }
        /// <p> The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker does not complete the assignment within the specified duration, the assignment is considered abandoned. If the HIT is still active (that is, its lifetime has not elapsed), the assignment becomes available for other users to find and accept. </p>
        pub fn set_assignment_duration_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self.inner.set_assignment_duration_in_seconds(input);
            self
        }
        /// <p> The amount of money the Requester will pay a Worker for successfully completing the HIT. </p>
        pub fn reward(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reward(input.into());
            self
        }
        /// <p> The amount of money the Requester will pay a Worker for successfully completing the HIT. </p>
        pub fn set_reward(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reward(input);
            self
        }
        /// <p> The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the HIT is mentioned. </p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.title(input.into());
            self
        }
        /// <p> The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the HIT is mentioned. </p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_title(input);
            self
        }
        /// <p> One or more words or phrases that describe the HIT, separated by commas. These words are used in searches to find HITs. </p>
        pub fn keywords(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keywords(input.into());
            self
        }
        /// <p> One or more words or phrases that describe the HIT, separated by commas. These words are used in searches to find HITs. </p>
        pub fn set_keywords(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_keywords(input);
            self
        }
        /// <p> A general description of the HIT. A description includes detailed information about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded view of search results, and in the HIT and assignment screens. A good description gives the user enough information to evaluate the HIT before accepting it. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> A general description of the HIT. A description includes detailed information about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded view of search results, and in the HIT and assignment screens. A good description gives the user enough information to evaluate the HIT before accepting it. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `QualificationRequirements`.
        ///
        /// To override the contents of this collection use [`set_qualification_requirements`](Self::set_qualification_requirements).
        ///
        /// <p> Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT. Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each <code>QualificationRequirement</code> structure. </p>
        pub fn qualification_requirements(
            mut self,
            input: crate::model::QualificationRequirement,
        ) -> Self {
            self.inner = self.inner.qualification_requirements(input);
            self
        }
        /// <p> Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT. Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each <code>QualificationRequirement</code> structure. </p>
        pub fn set_qualification_requirements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QualificationRequirement>>,
        ) -> Self {
            self.inner = self.inner.set_qualification_requirements(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHITWithHITType`.
    ///
    /// <p> The <code>CreateHITWithHITType</code> operation creates a new Human Intelligence Task (HIT) using an existing HITTypeID generated by the <code>CreateHITType</code> operation. </p>
    /// <p> This is an alternative way to create HITs from the <code>CreateHIT</code> operation. This is the recommended best practice for Requesters who are creating large numbers of HITs. </p>
    /// <p>CreateHITWithHITType also supports several ways to provide question data: by providing a value for the <code>Question</code> parameter that fully specifies the contents of the HIT, or by providing a <code>HitLayoutId</code> and associated <code>HitLayoutParameters</code>. </p> <note>
    /// <p> If a HIT is created with 10 or more maximum assignments, there is an additional fee. For more information, see <a href="https://requester.mturk.com/pricing">Amazon Mechanical Turk Pricing</a>. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHITWithHITType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_hit_with_hit_type_input::Builder,
    }
    impl CreateHITWithHITType {
        /// Creates a new `CreateHITWithHITType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHitWithHitTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHITWithHITTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The HIT type ID you want to create this HIT with.</p>
        pub fn hit_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_type_id(input.into());
            self
        }
        /// <p>The HIT type ID you want to create this HIT with.</p>
        pub fn set_hit_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_type_id(input);
            self
        }
        /// <p> The number of times the HIT can be accepted and completed before the HIT becomes unavailable. </p>
        pub fn max_assignments(mut self, input: i32) -> Self {
            self.inner = self.inner.max_assignments(input);
            self
        }
        /// <p> The number of times the HIT can be accepted and completed before the HIT becomes unavailable. </p>
        pub fn set_max_assignments(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_assignments(input);
            self
        }
        /// <p> An amount of time, in seconds, after which the HIT is no longer available for users to accept. After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches, even if not all of the assignments for the HIT have been accepted. </p>
        pub fn lifetime_in_seconds(mut self, input: i64) -> Self {
            self.inner = self.inner.lifetime_in_seconds(input);
            self
        }
        /// <p> An amount of time, in seconds, after which the HIT is no longer available for users to accept. After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches, even if not all of the assignments for the HIT have been accepted. </p>
        pub fn set_lifetime_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_lifetime_in_seconds(input);
            self
        }
        /// <p> The data the person completing the HIT uses to produce the results. </p>
        /// <p> Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure, or an HTMLQuestion data structure. The XML question data must not be larger than 64 kilobytes (65,535 bytes) in size, including whitespace. </p>
        /// <p>Either a Question parameter or a HITLayoutId parameter must be provided.</p>
        pub fn question(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.question(input.into());
            self
        }
        /// <p> The data the person completing the HIT uses to produce the results. </p>
        /// <p> Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure, or an HTMLQuestion data structure. The XML question data must not be larger than 64 kilobytes (65,535 bytes) in size, including whitespace. </p>
        /// <p>Either a Question parameter or a HITLayoutId parameter must be provided.</p>
        pub fn set_question(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_question(input);
            self
        }
        /// <p> An arbitrary data field. The RequesterAnnotation parameter lets your application attach arbitrary data to the HIT for tracking purposes. For example, this parameter could be an identifier internal to the Requester's application that corresponds with the HIT. </p>
        /// <p> The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT. It is not shown to the Worker, or any other Requester. </p>
        /// <p> The RequesterAnnotation parameter may be different for each HIT you submit. It does not affect how your HITs are grouped. </p>
        pub fn requester_annotation(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.requester_annotation(input.into());
            self
        }
        /// <p> An arbitrary data field. The RequesterAnnotation parameter lets your application attach arbitrary data to the HIT for tracking purposes. For example, this parameter could be an identifier internal to the Requester's application that corresponds with the HIT. </p>
        /// <p> The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT. It is not shown to the Worker, or any other Requester. </p>
        /// <p> The RequesterAnnotation parameter may be different for each HIT you submit. It does not affect how your HITs are grouped. </p>
        pub fn set_requester_annotation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_requester_annotation(input);
            self
        }
        /// <p> A unique identifier for this request which allows you to retry the call on error without creating duplicate HITs. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the HIT already exists in the system from a previous call using the same UniqueRequestToken, subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error with a message containing the HITId. </p> <note>
        /// <p> Note: It is your responsibility to ensure uniqueness of the token. The unique token expires after 24 hours. Subsequent calls using the same UniqueRequestToken made after the 24 hour limit could create duplicate HITs. </p>
        /// </note>
        pub fn unique_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.unique_request_token(input.into());
            self
        }
        /// <p> A unique identifier for this request which allows you to retry the call on error without creating duplicate HITs. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the HIT already exists in the system from a previous call using the same UniqueRequestToken, subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error with a message containing the HITId. </p> <note>
        /// <p> Note: It is your responsibility to ensure uniqueness of the token. The unique token expires after 24 hours. Subsequent calls using the same UniqueRequestToken made after the 24 hour limit could create duplicate HITs. </p>
        /// </note>
        pub fn set_unique_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_unique_request_token(input);
            self
        }
        /// <p> The Assignment-level Review Policy applies to the assignments under the HIT. You can specify for Mechanical Turk to take various actions based on the policy. </p>
        pub fn assignment_review_policy(mut self, input: crate::model::ReviewPolicy) -> Self {
            self.inner = self.inner.assignment_review_policy(input);
            self
        }
        /// <p> The Assignment-level Review Policy applies to the assignments under the HIT. You can specify for Mechanical Turk to take various actions based on the policy. </p>
        pub fn set_assignment_review_policy(
            mut self,
            input: std::option::Option<crate::model::ReviewPolicy>,
        ) -> Self {
            self.inner = self.inner.set_assignment_review_policy(input);
            self
        }
        /// <p> The HIT-level Review Policy applies to the HIT. You can specify for Mechanical Turk to take various actions based on the policy. </p>
        pub fn hit_review_policy(mut self, input: crate::model::ReviewPolicy) -> Self {
            self.inner = self.inner.hit_review_policy(input);
            self
        }
        /// <p> The HIT-level Review Policy applies to the HIT. You can specify for Mechanical Turk to take various actions based on the policy. </p>
        pub fn set_hit_review_policy(
            mut self,
            input: std::option::Option<crate::model::ReviewPolicy>,
        ) -> Self {
            self.inner = self.inner.set_hit_review_policy(input);
            self
        }
        /// <p> The HITLayoutId allows you to use a pre-existing HIT design with placeholder values and create an additional HIT by providing those values as HITLayoutParameters. </p>
        /// <p> Constraints: Either a Question parameter or a HITLayoutId parameter must be provided. </p>
        pub fn hit_layout_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_layout_id(input.into());
            self
        }
        /// <p> The HITLayoutId allows you to use a pre-existing HIT design with placeholder values and create an additional HIT by providing those values as HITLayoutParameters. </p>
        /// <p> Constraints: Either a Question parameter or a HITLayoutId parameter must be provided. </p>
        pub fn set_hit_layout_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hit_layout_id(input);
            self
        }
        /// Appends an item to `HITLayoutParameters`.
        ///
        /// To override the contents of this collection use [`set_hit_layout_parameters`](Self::set_hit_layout_parameters).
        ///
        /// <p> If the HITLayoutId is provided, any placeholder values must be filled in with values using the HITLayoutParameter structure. For more information, see HITLayout. </p>
        pub fn hit_layout_parameters(mut self, input: crate::model::HitLayoutParameter) -> Self {
            self.inner = self.inner.hit_layout_parameters(input);
            self
        }
        /// <p> If the HITLayoutId is provided, any placeholder values must be filled in with values using the HITLayoutParameter structure. For more information, see HITLayout. </p>
        pub fn set_hit_layout_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HitLayoutParameter>>,
        ) -> Self {
            self.inner = self.inner.set_hit_layout_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateQualificationType`.
    ///
    /// <p> The <code>CreateQualificationType</code> operation creates a new Qualification type, which is represented by a <code>QualificationType</code> data structure. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateQualificationType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_qualification_type_input::Builder,
    }
    impl CreateQualificationType {
        /// Creates a new `CreateQualificationType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateQualificationTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateQualificationTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name you give to the Qualification type. The type name is used to represent the Qualification to Workers, and to find the type using a Qualification type search. It must be unique across all of your Qualification types.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> The name you give to the Qualification type. The type name is used to represent the Qualification to Workers, and to find the type using a Qualification type search. It must be unique across all of your Qualification types.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>One or more words or phrases that describe the Qualification type, separated by commas. The keywords of a type make the type easier to find during a search.</p>
        pub fn keywords(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keywords(input.into());
            self
        }
        /// <p>One or more words or phrases that describe the Qualification type, separated by commas. The keywords of a type make the type easier to find during a search.</p>
        pub fn set_keywords(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_keywords(input);
            self
        }
        /// <p>A long description for the Qualification type. On the Amazon Mechanical Turk website, the long description is displayed when a Worker examines a Qualification type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A long description for the Qualification type. On the Amazon Mechanical Turk website, the long description is displayed when a Worker examines a Qualification type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The initial status of the Qualification type.</p>
        /// <p>Constraints: Valid values are: Active | Inactive</p>
        pub fn qualification_type_status(
            mut self,
            input: crate::model::QualificationTypeStatus,
        ) -> Self {
            self.inner = self.inner.qualification_type_status(input);
            self
        }
        /// <p>The initial status of the Qualification type.</p>
        /// <p>Constraints: Valid values are: Active | Inactive</p>
        pub fn set_qualification_type_status(
            mut self,
            input: std::option::Option<crate::model::QualificationTypeStatus>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_status(input);
            self
        }
        /// <p>The number of seconds that a Worker must wait after requesting a Qualification of the Qualification type before the worker can retry the Qualification request.</p>
        /// <p>Constraints: None. If not specified, retries are disabled and Workers can request a Qualification of this type only once, even if the Worker has not been granted the Qualification. It is not possible to disable retries for a Qualification type after it has been created with retries enabled. If you want to disable retries, you must delete existing retry-enabled Qualification type and then create a new Qualification type with retries disabled.</p>
        pub fn retry_delay_in_seconds(mut self, input: i64) -> Self {
            self.inner = self.inner.retry_delay_in_seconds(input);
            self
        }
        /// <p>The number of seconds that a Worker must wait after requesting a Qualification of the Qualification type before the worker can retry the Qualification request.</p>
        /// <p>Constraints: None. If not specified, retries are disabled and Workers can request a Qualification of this type only once, even if the Worker has not been granted the Qualification. It is not possible to disable retries for a Qualification type after it has been created with retries enabled. If you want to disable retries, you must delete existing retry-enabled Qualification type and then create a new Qualification type with retries disabled.</p>
        pub fn set_retry_delay_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_retry_delay_in_seconds(input);
            self
        }
        /// <p> The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified. </p>
        /// <p>Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be specified if AutoGranted is true.</p>
        /// <p>Constraints: None. If not specified, the Worker may request the Qualification without answering any questions.</p>
        pub fn test(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.test(input.into());
            self
        }
        /// <p> The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified. </p>
        /// <p>Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be specified if AutoGranted is true.</p>
        /// <p>Constraints: None. If not specified, the Worker may request the Qualification without answering any questions.</p>
        pub fn set_test(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_test(input);
            self
        }
        /// <p>The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data structure.</p>
        /// <p>Constraints: Must not be longer than 65535 bytes.</p>
        /// <p>Constraints: None. If not specified, you must process Qualification requests manually.</p>
        pub fn answer_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.answer_key(input.into());
            self
        }
        /// <p>The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data structure.</p>
        /// <p>Constraints: Must not be longer than 65535 bytes.</p>
        /// <p>Constraints: None. If not specified, you must process Qualification requests manually.</p>
        pub fn set_answer_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_answer_key(input);
            self
        }
        /// <p>The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker requests the Qualification.</p>
        pub fn test_duration_in_seconds(mut self, input: i64) -> Self {
            self.inner = self.inner.test_duration_in_seconds(input);
            self
        }
        /// <p>The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker requests the Qualification.</p>
        pub fn set_test_duration_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_test_duration_in_seconds(input);
            self
        }
        /// <p>Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test.</p>
        /// <p>Constraints: If the Test parameter is specified, this parameter cannot be true.</p>
        pub fn auto_granted(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_granted(input);
            self
        }
        /// <p>Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test.</p>
        /// <p>Constraints: If the Test parameter is specified, this parameter cannot be true.</p>
        pub fn set_auto_granted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_granted(input);
            self
        }
        /// <p>The Qualification value to use for automatically granted Qualifications. This parameter is used only if the AutoGranted parameter is true.</p>
        pub fn auto_granted_value(mut self, input: i32) -> Self {
            self.inner = self.inner.auto_granted_value(input);
            self
        }
        /// <p>The Qualification value to use for automatically granted Qualifications. This parameter is used only if the AutoGranted parameter is true.</p>
        pub fn set_auto_granted_value(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_auto_granted_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkerBlock`.
    ///
    /// <p>The <code>CreateWorkerBlock</code> operation allows you to prevent a Worker from working on your HITs. For example, you can block a Worker who is producing poor quality work. You can block up to 100,000 Workers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorkerBlock {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_worker_block_input::Builder,
    }
    impl CreateWorkerBlock {
        /// Creates a new `CreateWorkerBlock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkerBlockOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkerBlockError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Worker to block.</p>
        pub fn worker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worker_id(input.into());
            self
        }
        /// <p>The ID of the Worker to block.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_worker_id(input);
            self
        }
        /// <p>A message explaining the reason for blocking the Worker. This parameter enables you to keep track of your Workers. The Worker does not see this message.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(input.into());
            self
        }
        /// <p>A message explaining the reason for blocking the Worker. This parameter enables you to keep track of your Workers. The Worker does not see this message.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHIT`.
    ///
    /// <p> The <code>DeleteHIT</code> operation is used to delete HIT that is no longer needed. Only the Requester who created the HIT can delete it. </p>
    /// <p> You can only dispose of HITs that are in the <code>Reviewable</code> state, with all of their submitted assignments already either approved or rejected. If you call the DeleteHIT operation on a HIT that is not in the <code>Reviewable</code> state (for example, that has not expired, or still has active assignments), or on a HIT that is Reviewable but without all of its submitted assignments already approved or rejected, the service will return an error. </p> <note>
    /// <ul>
    /// <li> <p> HITs are automatically disposed of after 120 days. </p> </li>
    /// <li> <p> After you dispose of a HIT, you can no longer approve the HIT's rejected assignments. </p> </li>
    /// <li> <p> Disposed HITs are not returned in results for the ListHITs operation. </p> </li>
    /// <li> <p> Disposing HITs can improve the performance of operations such as ListReviewableHITs and ListHITs. </p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteHIT {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_hit_input::Builder,
    }
    impl DeleteHIT {
        /// Creates a new `DeleteHIT`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHitOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHITError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the HIT to be deleted.</p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_id(input.into());
            self
        }
        /// <p>The ID of the HIT to be deleted.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteQualificationType`.
    ///
    /// <p> The <code>DeleteQualificationType</code> deletes a Qualification type and deletes any HIT types that are associated with the Qualification type. </p>
    /// <p>This operation does not revoke Qualifications already assigned to Workers because the Qualifications might be needed for active HITs. If there are any pending requests for the Qualification type, Amazon Mechanical Turk rejects those requests. After you delete a Qualification type, you can no longer use it to create HITs or HIT types.</p> <note>
    /// <p>DeleteQualificationType must wait for all the HITs that use the deleted Qualification type to be deleted before completing. It may take up to 48 hours before DeleteQualificationType completes and the unique name of the Qualification type is available for reuse with CreateQualificationType.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteQualificationType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_qualification_type_input::Builder,
    }
    impl DeleteQualificationType {
        /// Creates a new `DeleteQualificationType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteQualificationTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteQualificationTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the QualificationType to dispose.</p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_type_id(input.into());
            self
        }
        /// <p>The ID of the QualificationType to dispose.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkerBlock`.
    ///
    /// <p>The <code>DeleteWorkerBlock</code> operation allows you to reinstate a blocked Worker to work on your HITs. This operation reverses the effects of the CreateWorkerBlock operation. You need the Worker ID to use this operation. If the Worker ID is missing or invalid, this operation fails and returns the message “WorkerId is invalid.” If the specified Worker is not blocked, this operation returns successfully.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWorkerBlock {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_worker_block_input::Builder,
    }
    impl DeleteWorkerBlock {
        /// Creates a new `DeleteWorkerBlock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkerBlockOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkerBlockError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Worker to unblock.</p>
        pub fn worker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worker_id(input.into());
            self
        }
        /// <p>The ID of the Worker to unblock.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_worker_id(input);
            self
        }
        /// <p>A message that explains the reason for unblocking the Worker. The Worker does not see this message.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(input.into());
            self
        }
        /// <p>A message that explains the reason for unblocking the Worker. The Worker does not see this message.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateQualificationFromWorker`.
    ///
    /// <p> The <code>DisassociateQualificationFromWorker</code> revokes a previously granted Qualification from a user. </p>
    /// <p> You can provide a text message explaining why the Qualification was revoked. The user who had the Qualification can see this message. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateQualificationFromWorker {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_qualification_from_worker_input::Builder,
    }
    impl DisassociateQualificationFromWorker {
        /// Creates a new `DisassociateQualificationFromWorker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateQualificationFromWorkerOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateQualificationFromWorkerError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Worker who possesses the Qualification to be revoked.</p>
        pub fn worker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worker_id(input.into());
            self
        }
        /// <p>The ID of the Worker who possesses the Qualification to be revoked.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_worker_id(input);
            self
        }
        /// <p>The ID of the Qualification type of the Qualification to be revoked.</p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_type_id(input.into());
            self
        }
        /// <p>The ID of the Qualification type of the Qualification to be revoked.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_id(input);
            self
        }
        /// <p>A text message that explains why the Qualification was revoked. The user who had the Qualification sees this message.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(input.into());
            self
        }
        /// <p>A text message that explains why the Qualification was revoked. The user who had the Qualification sees this message.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccountBalance`.
    ///
    /// <p>The <code>GetAccountBalance</code> operation retrieves the Prepaid HITs balance in your Amazon Mechanical Turk account if you are a Prepaid Requester. Alternatively, this operation will retrieve the remaining available AWS Billing usage if you have enabled AWS Billing. Note: If you have enabled AWS Billing and still have a remaining Prepaid HITs balance, this balance can be viewed on the My Account page in the Requester console.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccountBalance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_account_balance_input::Builder,
    }
    impl GetAccountBalance {
        /// Creates a new `GetAccountBalance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountBalanceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountBalanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetAssignment`.
    ///
    /// <p> The <code>GetAssignment</code> operation retrieves the details of the specified Assignment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAssignment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_assignment_input::Builder,
    }
    impl GetAssignment {
        /// Creates a new `GetAssignment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssignmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssignmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Assignment to be retrieved.</p>
        pub fn assignment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_id(input.into());
            self
        }
        /// <p>The ID of the Assignment to be retrieved.</p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFileUploadURL`.
    ///
    /// <p> The <code>GetFileUploadURL</code> operation generates and returns a temporary URL. You use the temporary URL to retrieve a file uploaded by a Worker as an answer to a FileUploadAnswer question for a HIT. The temporary URL is generated the instant the GetFileUploadURL operation is called, and is valid for 60 seconds. You can get a temporary file upload URL any time until the HIT is disposed. After the HIT is disposed, any uploaded files are deleted, and cannot be retrieved. Pending Deprecation on December 12, 2017. The Answer Specification structure will no longer support the <code>FileUploadAnswer</code> element to be used for the QuestionForm data structure. Instead, we recommend that Requesters who want to create HITs asking Workers to upload files to use Amazon S3. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFileUploadURL {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_file_upload_url_input::Builder,
    }
    impl GetFileUploadURL {
        /// Creates a new `GetFileUploadURL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFileUploadUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFileUploadURLError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the assignment that contains the question with a FileUploadAnswer.</p>
        pub fn assignment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_id(input.into());
            self
        }
        /// <p>The ID of the assignment that contains the question with a FileUploadAnswer.</p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_id(input);
            self
        }
        /// <p>The identifier of the question with a FileUploadAnswer, as specified in the QuestionForm of the HIT.</p>
        pub fn question_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.question_identifier(input.into());
            self
        }
        /// <p>The identifier of the question with a FileUploadAnswer, as specified in the QuestionForm of the HIT.</p>
        pub fn set_question_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_question_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetHIT`.
    ///
    /// <p> The <code>GetHIT</code> operation retrieves the details of the specified HIT. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetHIT {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_hit_input::Builder,
    }
    impl GetHIT {
        /// Creates a new `GetHIT`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetHitOutput,
            aws_smithy_http::result::SdkError<crate::error::GetHITError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the HIT to be retrieved.</p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_id(input.into());
            self
        }
        /// <p>The ID of the HIT to be retrieved.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetQualificationScore`.
    ///
    /// <p> The <code>GetQualificationScore</code> operation returns the value of a Worker's Qualification for a given Qualification type. </p>
    /// <p> To get a Worker's Qualification, you must know the Worker's ID. The Worker's ID is included in the assignment data returned by the <code>ListAssignmentsForHIT</code> operation. </p>
    /// <p>Only the owner of a Qualification type can query the value of a Worker's Qualification of that type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetQualificationScore {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_qualification_score_input::Builder,
    }
    impl GetQualificationScore {
        /// Creates a new `GetQualificationScore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetQualificationScoreOutput,
            aws_smithy_http::result::SdkError<crate::error::GetQualificationScoreError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the QualificationType.</p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_type_id(input.into());
            self
        }
        /// <p>The ID of the QualificationType.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_id(input);
            self
        }
        /// <p>The ID of the Worker whose Qualification is being updated.</p>
        pub fn worker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worker_id(input.into());
            self
        }
        /// <p>The ID of the Worker whose Qualification is being updated.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_worker_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetQualificationType`.
    ///
    /// <p> The <code>GetQualificationType</code>operation retrieves information about a Qualification type using its ID. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetQualificationType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_qualification_type_input::Builder,
    }
    impl GetQualificationType {
        /// Creates a new `GetQualificationType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetQualificationTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetQualificationTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the QualificationType.</p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_type_id(input.into());
            self
        }
        /// <p>The ID of the QualificationType.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssignmentsForHIT`.
    ///
    /// <p> The <code>ListAssignmentsForHIT</code> operation retrieves completed assignments for a HIT. You can use this operation to retrieve the results for a HIT. </p>
    /// <p> You can get assignments for a HIT at any time, even if the HIT is not yet Reviewable. If a HIT requested multiple assignments, and has received some results but has not yet become Reviewable, you can still retrieve the partial results with this operation. </p>
    /// <p> Use the AssignmentStatus parameter to control which set of assignments for a HIT are returned. The ListAssignmentsForHIT operation can return submitted assignments awaiting approval, or it can return assignments that have already been approved or rejected. You can set AssignmentStatus=Approved,Rejected to get assignments that have already been approved and rejected together in one result set. </p>
    /// <p> Only the Requester who created the HIT can retrieve the assignments for that HIT. </p>
    /// <p> Results are sorted and divided into numbered pages and the operation returns a single page of results. You can use the parameters of the operation to control sorting and pagination. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssignmentsForHIT {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_assignments_for_hit_input::Builder,
    }
    impl ListAssignmentsForHIT {
        /// Creates a new `ListAssignmentsForHIT`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssignmentsForHitOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssignmentsForHITError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssignmentsForHitPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAssignmentsForHitPaginator {
            crate::paginator::ListAssignmentsForHitPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the HIT.</p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_id(input.into());
            self
        }
        /// <p>The ID of the HIT.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_id(input);
            self
        }
        /// <p>Pagination token</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Pagination token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `AssignmentStatuses`.
        ///
        /// To override the contents of this collection use [`set_assignment_statuses`](Self::set_assignment_statuses).
        ///
        /// <p>The status of the assignments to return: Submitted | Approved | Rejected</p>
        pub fn assignment_statuses(mut self, input: crate::model::AssignmentStatus) -> Self {
            self.inner = self.inner.assignment_statuses(input);
            self
        }
        /// <p>The status of the assignments to return: Submitted | Approved | Rejected</p>
        pub fn set_assignment_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssignmentStatus>>,
        ) -> Self {
            self.inner = self.inner.set_assignment_statuses(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBonusPayments`.
    ///
    /// <p> The <code>ListBonusPayments</code> operation retrieves the amounts of bonuses you have paid to Workers for a given HIT or assignment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBonusPayments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_bonus_payments_input::Builder,
    }
    impl ListBonusPayments {
        /// Creates a new `ListBonusPayments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBonusPaymentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBonusPaymentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBonusPaymentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBonusPaymentsPaginator {
            crate::paginator::ListBonusPaymentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the HIT associated with the bonus payments to retrieve. If not specified, all bonus payments for all assignments for the given HIT are returned. Either the HITId parameter or the AssignmentId parameter must be specified</p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_id(input.into());
            self
        }
        /// <p>The ID of the HIT associated with the bonus payments to retrieve. If not specified, all bonus payments for all assignments for the given HIT are returned. Either the HITId parameter or the AssignmentId parameter must be specified</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_id(input);
            self
        }
        /// <p>The ID of the assignment associated with the bonus payments to retrieve. If specified, only bonus payments for the given assignment are returned. Either the HITId parameter or the AssignmentId parameter must be specified</p>
        pub fn assignment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_id(input.into());
            self
        }
        /// <p>The ID of the assignment associated with the bonus payments to retrieve. If specified, only bonus payments for the given assignment are returned. Either the HITId parameter or the AssignmentId parameter must be specified</p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_id(input);
            self
        }
        /// <p>Pagination token</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Pagination token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHITs`.
    ///
    /// <p> The <code>ListHITs</code> operation returns all of a Requester's HITs. The operation returns HITs of any status, except for HITs that have been deleted of with the DeleteHIT operation or that have been auto-deleted. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHITs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_hi_ts_input::Builder,
    }
    impl ListHITs {
        /// Creates a new `ListHITs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHiTsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHITsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListHiTsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListHiTsPaginator {
            crate::paginator::ListHiTsPaginator::new(self.handle, self.inner)
        }
        /// <p>Pagination token</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Pagination token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHITsForQualificationType`.
    ///
    /// <p> The <code>ListHITsForQualificationType</code> operation returns the HITs that use the given Qualification type for a Qualification requirement. The operation returns HITs of any status, except for HITs that have been deleted with the <code>DeleteHIT</code> operation or that have been auto-deleted. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHITsForQualificationType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_hi_ts_for_qualification_type_input::Builder,
    }
    impl ListHITsForQualificationType {
        /// Creates a new `ListHITsForQualificationType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHiTsForQualificationTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHITsForQualificationTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListHiTsForQualificationTypePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListHiTsForQualificationTypePaginator {
            crate::paginator::ListHiTsForQualificationTypePaginator::new(self.handle, self.inner)
        }
        /// <p> The ID of the Qualification type to use when querying HITs. </p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_type_id(input.into());
            self
        }
        /// <p> The ID of the Qualification type to use when querying HITs. </p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_id(input);
            self
        }
        /// <p>Pagination Token</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Pagination Token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> Limit the number of results returned. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Limit the number of results returned. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListQualificationRequests`.
    ///
    /// <p> The <code>ListQualificationRequests</code> operation retrieves requests for Qualifications of a particular Qualification type. The owner of the Qualification type calls this operation to poll for pending requests, and accepts them using the AcceptQualification operation. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListQualificationRequests {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_qualification_requests_input::Builder,
    }
    impl ListQualificationRequests {
        /// Creates a new `ListQualificationRequests`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListQualificationRequestsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListQualificationRequestsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListQualificationRequestsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListQualificationRequestsPaginator {
            crate::paginator::ListQualificationRequestsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the QualificationType.</p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_type_id(input.into());
            self
        }
        /// <p>The ID of the QualificationType.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_id(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of results to return in a single call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of results to return in a single call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListQualificationTypes`.
    ///
    /// <p> The <code>ListQualificationTypes</code> operation returns a list of Qualification types, filtered by an optional search term. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListQualificationTypes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_qualification_types_input::Builder,
    }
    impl ListQualificationTypes {
        /// Creates a new `ListQualificationTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListQualificationTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListQualificationTypesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListQualificationTypesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListQualificationTypesPaginator {
            crate::paginator::ListQualificationTypesPaginator::new(self.handle, self.inner)
        }
        /// <p> A text query against all of the searchable attributes of Qualification types. </p>
        pub fn query(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query(input.into());
            self
        }
        /// <p> A text query against all of the searchable attributes of Qualification types. </p>
        pub fn set_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query(input);
            self
        }
        /// <p>Specifies that only Qualification types that a user can request through the Amazon Mechanical Turk web site, such as by taking a Qualification test, are returned as results of the search. Some Qualification types, such as those assigned automatically by the system, cannot be requested directly by users. If false, all Qualification types, including those managed by the system, are considered. Valid values are True | False. </p>
        pub fn must_be_requestable(mut self, input: bool) -> Self {
            self.inner = self.inner.must_be_requestable(input);
            self
        }
        /// <p>Specifies that only Qualification types that a user can request through the Amazon Mechanical Turk web site, such as by taking a Qualification test, are returned as results of the search. Some Qualification types, such as those assigned automatically by the system, cannot be requested directly by users. If false, all Qualification types, including those managed by the system, are considered. Valid values are True | False. </p>
        pub fn set_must_be_requestable(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_must_be_requestable(input);
            self
        }
        /// <p> Specifies that only Qualification types that the Requester created are returned. If false, the operation returns all Qualification types. </p>
        pub fn must_be_owned_by_caller(mut self, input: bool) -> Self {
            self.inner = self.inner.must_be_owned_by_caller(input);
            self
        }
        /// <p> Specifies that only Qualification types that the Requester created are returned. If false, the operation returns all Qualification types. </p>
        pub fn set_must_be_owned_by_caller(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_must_be_owned_by_caller(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of results to return in a single call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of results to return in a single call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReviewableHITs`.
    ///
    /// <p> The <code>ListReviewableHITs</code> operation retrieves the HITs with Status equal to Reviewable or Status equal to Reviewing that belong to the Requester calling the operation. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListReviewableHITs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_reviewable_hi_ts_input::Builder,
    }
    impl ListReviewableHITs {
        /// Creates a new `ListReviewableHITs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReviewableHiTsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReviewableHITsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListReviewableHiTsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListReviewableHiTsPaginator {
            crate::paginator::ListReviewableHiTsPaginator::new(self.handle, self.inner)
        }
        /// <p> The ID of the HIT type of the HITs to consider for the query. If not specified, all HITs for the Reviewer are considered </p>
        pub fn hit_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_type_id(input.into());
            self
        }
        /// <p> The ID of the HIT type of the HITs to consider for the query. If not specified, all HITs for the Reviewer are considered </p>
        pub fn set_hit_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_type_id(input);
            self
        }
        /// <p> Can be either <code>Reviewable</code> or <code>Reviewing</code>. Reviewable is the default value. </p>
        pub fn status(mut self, input: crate::model::ReviewableHitStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p> Can be either <code>Reviewable</code> or <code>Reviewing</code>. Reviewable is the default value. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ReviewableHitStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>Pagination Token</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Pagination Token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> Limit the number of results returned. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Limit the number of results returned. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReviewPolicyResultsForHIT`.
    ///
    /// <p> The <code>ListReviewPolicyResultsForHIT</code> operation retrieves the computed results and the actions taken in the course of executing your Review Policies for a given HIT. For information about how to specify Review Policies when you call CreateHIT, see Review Policies. The ListReviewPolicyResultsForHIT operation can return results for both Assignment-level and HIT-level review results. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListReviewPolicyResultsForHIT {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_review_policy_results_for_hit_input::Builder,
    }
    impl ListReviewPolicyResultsForHIT {
        /// Creates a new `ListReviewPolicyResultsForHIT`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReviewPolicyResultsForHitOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReviewPolicyResultsForHITError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListReviewPolicyResultsForHitPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListReviewPolicyResultsForHitPaginator {
            crate::paginator::ListReviewPolicyResultsForHitPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier of the HIT to retrieve review results for.</p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_id(input.into());
            self
        }
        /// <p>The unique identifier of the HIT to retrieve review results for.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_id(input);
            self
        }
        /// Appends an item to `PolicyLevels`.
        ///
        /// To override the contents of this collection use [`set_policy_levels`](Self::set_policy_levels).
        ///
        /// <p> The Policy Level(s) to retrieve review results for - HIT or Assignment. If omitted, the default behavior is to retrieve all data for both policy levels. For a list of all the described policies, see Review Policies. </p>
        pub fn policy_levels(mut self, input: crate::model::ReviewPolicyLevel) -> Self {
            self.inner = self.inner.policy_levels(input);
            self
        }
        /// <p> The Policy Level(s) to retrieve review results for - HIT or Assignment. If omitted, the default behavior is to retrieve all data for both policy levels. For a list of all the described policies, see Review Policies. </p>
        pub fn set_policy_levels(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReviewPolicyLevel>>,
        ) -> Self {
            self.inner = self.inner.set_policy_levels(input);
            self
        }
        /// <p> Specify if the operation should retrieve a list of the actions taken executing the Review Policies and their outcomes. </p>
        pub fn retrieve_actions(mut self, input: bool) -> Self {
            self.inner = self.inner.retrieve_actions(input);
            self
        }
        /// <p> Specify if the operation should retrieve a list of the actions taken executing the Review Policies and their outcomes. </p>
        pub fn set_retrieve_actions(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_retrieve_actions(input);
            self
        }
        /// <p> Specify if the operation should retrieve a list of the results computed by the Review Policies. </p>
        pub fn retrieve_results(mut self, input: bool) -> Self {
            self.inner = self.inner.retrieve_results(input);
            self
        }
        /// <p> Specify if the operation should retrieve a list of the results computed by the Review Policies. </p>
        pub fn set_retrieve_results(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_retrieve_results(input);
            self
        }
        /// <p>Pagination token</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Pagination token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Limit the number of results returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Limit the number of results returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkerBlocks`.
    ///
    /// <p>The <code>ListWorkersBlocks</code> operation retrieves a list of Workers who are blocked from working on your HITs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWorkerBlocks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_worker_blocks_input::Builder,
    }
    impl ListWorkerBlocks {
        /// Creates a new `ListWorkerBlocks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkerBlocksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkerBlocksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWorkerBlocksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListWorkerBlocksPaginator {
            crate::paginator::ListWorkerBlocksPaginator::new(self.handle, self.inner)
        }
        /// <p>Pagination token</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Pagination token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkersWithQualificationType`.
    ///
    /// <p> The <code>ListWorkersWithQualificationType</code> operation returns all of the Workers that have been associated with a given Qualification type. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWorkersWithQualificationType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_workers_with_qualification_type_input::Builder,
    }
    impl ListWorkersWithQualificationType {
        /// Creates a new `ListWorkersWithQualificationType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkersWithQualificationTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkersWithQualificationTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWorkersWithQualificationTypePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListWorkersWithQualificationTypePaginator {
            crate::paginator::ListWorkersWithQualificationTypePaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ID of the Qualification type of the Qualifications to return.</p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_type_id(input.into());
            self
        }
        /// <p>The ID of the Qualification type of the Qualifications to return.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_id(input);
            self
        }
        /// <p> The status of the Qualifications to return. Can be <code>Granted | Revoked</code>. </p>
        pub fn status(mut self, input: crate::model::QualificationStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p> The status of the Qualifications to return. Can be <code>Granted | Revoked</code>. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::QualificationStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>Pagination Token</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Pagination Token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> Limit the number of results returned. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Limit the number of results returned. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `NotifyWorkers`.
    ///
    /// <p> The <code>NotifyWorkers</code> operation sends an email to one or more Workers that you specify with the Worker ID. You can specify up to 100 Worker IDs to send the same message with a single call to the NotifyWorkers operation. The NotifyWorkers operation will send a notification email to a Worker only if you have previously approved or rejected work from the Worker. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct NotifyWorkers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::notify_workers_input::Builder,
    }
    impl NotifyWorkers {
        /// Creates a new `NotifyWorkers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::NotifyWorkersOutput,
            aws_smithy_http::result::SdkError<crate::error::NotifyWorkersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The subject line of the email message to send. Can include up to 200 characters.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subject(input.into());
            self
        }
        /// <p>The subject line of the email message to send. Can include up to 200 characters.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subject(input);
            self
        }
        /// <p>The text of the email message to send. Can include up to 4,096 characters</p>
        pub fn message_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_text(input.into());
            self
        }
        /// <p>The text of the email message to send. Can include up to 4,096 characters</p>
        pub fn set_message_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_text(input);
            self
        }
        /// Appends an item to `WorkerIds`.
        ///
        /// To override the contents of this collection use [`set_worker_ids`](Self::set_worker_ids).
        ///
        /// <p>A list of Worker IDs you wish to notify. You can notify upto 100 Workers at a time.</p>
        pub fn worker_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worker_ids(input.into());
            self
        }
        /// <p>A list of Worker IDs you wish to notify. You can notify upto 100 Workers at a time.</p>
        pub fn set_worker_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_worker_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectAssignment`.
    ///
    /// <p> The <code>RejectAssignment</code> operation rejects the results of a completed assignment. </p>
    /// <p> You can include an optional feedback message with the rejection, which the Worker can see in the Status section of the web site. When you include a feedback message with the rejection, it helps the Worker understand why the assignment was rejected, and can improve the quality of the results the Worker submits in the future. </p>
    /// <p> Only the Requester who created the HIT can reject an assignment for the HIT. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RejectAssignment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reject_assignment_input::Builder,
    }
    impl RejectAssignment {
        /// Creates a new `RejectAssignment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectAssignmentOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectAssignmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the assignment. The assignment must correspond to a HIT created by the Requester. </p>
        pub fn assignment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_id(input.into());
            self
        }
        /// <p> The ID of the assignment. The assignment must correspond to a HIT created by the Requester. </p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_id(input);
            self
        }
        /// <p> A message for the Worker, which the Worker can see in the Status section of the web site. </p>
        pub fn requester_feedback(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.requester_feedback(input.into());
            self
        }
        /// <p> A message for the Worker, which the Worker can see in the Status section of the web site. </p>
        pub fn set_requester_feedback(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_requester_feedback(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectQualificationRequest`.
    ///
    /// <p> The <code>RejectQualificationRequest</code> operation rejects a user's request for a Qualification. </p>
    /// <p> You can provide a text message explaining why the request was rejected. The Worker who made the request can see this message.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RejectQualificationRequest {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reject_qualification_request_input::Builder,
    }
    impl RejectQualificationRequest {
        /// Creates a new `RejectQualificationRequest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectQualificationRequestOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectQualificationRequestError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the Qualification request, as returned by the <code>ListQualificationRequests</code> operation. </p>
        pub fn qualification_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_request_id(input.into());
            self
        }
        /// <p> The ID of the Qualification request, as returned by the <code>ListQualificationRequests</code> operation. </p>
        pub fn set_qualification_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_request_id(input);
            self
        }
        /// <p>A text message explaining why the request was rejected, to be shown to the Worker who made the request.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(input.into());
            self
        }
        /// <p>A text message explaining why the request was rejected, to be shown to the Worker who made the request.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendBonus`.
    ///
    /// <p> The <code>SendBonus</code> operation issues a payment of money from your account to a Worker. This payment happens separately from the reward you pay to the Worker when you approve the Worker's assignment. The SendBonus operation requires the Worker's ID and the assignment ID as parameters to initiate payment of the bonus. You must include a message that explains the reason for the bonus payment, as the Worker may not be expecting the payment. Amazon Mechanical Turk collects a fee for bonus payments, similar to the HIT listing fee. This operation fails if your account does not have enough funds to pay for both the bonus and the fees. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendBonus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_bonus_input::Builder,
    }
    impl SendBonus {
        /// Creates a new `SendBonus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendBonusOutput,
            aws_smithy_http::result::SdkError<crate::error::SendBonusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Worker being paid the bonus.</p>
        pub fn worker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worker_id(input.into());
            self
        }
        /// <p>The ID of the Worker being paid the bonus.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_worker_id(input);
            self
        }
        /// <p> The Bonus amount is a US Dollar amount specified using a string (for example, "5" represents $5.00 USD and "101.42" represents $101.42 USD). Do not include currency symbols or currency codes. </p>
        pub fn bonus_amount(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bonus_amount(input.into());
            self
        }
        /// <p> The Bonus amount is a US Dollar amount specified using a string (for example, "5" represents $5.00 USD and "101.42" represents $101.42 USD). Do not include currency symbols or currency codes. </p>
        pub fn set_bonus_amount(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bonus_amount(input);
            self
        }
        /// <p>The ID of the assignment for which this bonus is paid.</p>
        pub fn assignment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_id(input.into());
            self
        }
        /// <p>The ID of the assignment for which this bonus is paid.</p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_id(input);
            self
        }
        /// <p>A message that explains the reason for the bonus payment. The Worker receiving the bonus can see this message.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(input.into());
            self
        }
        /// <p>A message that explains the reason for the bonus payment. The Worker receiving the bonus can see this message.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
        /// <p>A unique identifier for this request, which allows you to retry the call on error without granting multiple bonuses. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the bonus already exists in the system from a previous call using the same UniqueRequestToken, subsequent calls will return an error with a message containing the request ID.</p>
        pub fn unique_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.unique_request_token(input.into());
            self
        }
        /// <p>A unique identifier for this request, which allows you to retry the call on error without granting multiple bonuses. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the bonus already exists in the system from a previous call using the same UniqueRequestToken, subsequent calls will return an error with a message containing the request ID.</p>
        pub fn set_unique_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_unique_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendTestEventNotification`.
    ///
    /// <p> The <code>SendTestEventNotification</code> operation causes Amazon Mechanical Turk to send a notification message as if a HIT event occurred, according to the provided notification specification. This allows you to test notifications without setting up notifications for a real HIT type and trying to trigger them using the website. When you call this operation, the service attempts to send the test notification immediately. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendTestEventNotification {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_test_event_notification_input::Builder,
    }
    impl SendTestEventNotification {
        /// Creates a new `SendTestEventNotification`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendTestEventNotificationOutput,
            aws_smithy_http::result::SdkError<crate::error::SendTestEventNotificationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The notification specification to test. This value is identical to the value you would provide to the UpdateNotificationSettings operation when you establish the notification specification for a HIT type. </p>
        pub fn notification(mut self, input: crate::model::NotificationSpecification) -> Self {
            self.inner = self.inner.notification(input);
            self
        }
        /// <p> The notification specification to test. This value is identical to the value you would provide to the UpdateNotificationSettings operation when you establish the notification specification for a HIT type. </p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::NotificationSpecification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
        /// <p> The event to simulate to test the notification specification. This event is included in the test message even if the notification specification does not include the event type. The notification specification does not filter out the test event. </p>
        pub fn test_event_type(mut self, input: crate::model::EventType) -> Self {
            self.inner = self.inner.test_event_type(input);
            self
        }
        /// <p> The event to simulate to test the notification specification. This event is included in the test message even if the notification specification does not include the event type. The notification specification does not filter out the test event. </p>
        pub fn set_test_event_type(
            mut self,
            input: std::option::Option<crate::model::EventType>,
        ) -> Self {
            self.inner = self.inner.set_test_event_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateExpirationForHIT`.
    ///
    /// <p> The <code>UpdateExpirationForHIT</code> operation allows you update the expiration time of a HIT. If you update it to a time in the past, the HIT will be immediately expired. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateExpirationForHIT {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_expiration_for_hit_input::Builder,
    }
    impl UpdateExpirationForHIT {
        /// Creates a new `UpdateExpirationForHIT`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateExpirationForHitOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateExpirationForHITError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The HIT to update. </p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_id(input.into());
            self
        }
        /// <p> The HIT to update. </p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_id(input);
            self
        }
        /// <p> The date and time at which you want the HIT to expire </p>
        pub fn expire_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.expire_at(input);
            self
        }
        /// <p> The date and time at which you want the HIT to expire </p>
        pub fn set_expire_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_expire_at(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateHITReviewStatus`.
    ///
    /// <p> The <code>UpdateHITReviewStatus</code> operation updates the status of a HIT. If the status is Reviewable, this operation can update the status to Reviewing, or it can revert a Reviewing HIT back to the Reviewable status. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateHITReviewStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_hit_review_status_input::Builder,
    }
    impl UpdateHITReviewStatus {
        /// Creates a new `UpdateHITReviewStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateHitReviewStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateHITReviewStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the HIT to update. </p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_id(input.into());
            self
        }
        /// <p> The ID of the HIT to update. </p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_id(input);
            self
        }
        /// <p> Specifies how to update the HIT status. Default is <code>False</code>. </p>
        /// <ul>
        /// <li> <p> Setting this to false will only transition a HIT from <code>Reviewable</code> to <code>Reviewing</code> </p> </li>
        /// <li> <p> Setting this to true will only transition a HIT from <code>Reviewing</code> to <code>Reviewable</code> </p> </li>
        /// </ul>
        pub fn revert(mut self, input: bool) -> Self {
            self.inner = self.inner.revert(input);
            self
        }
        /// <p> Specifies how to update the HIT status. Default is <code>False</code>. </p>
        /// <ul>
        /// <li> <p> Setting this to false will only transition a HIT from <code>Reviewable</code> to <code>Reviewing</code> </p> </li>
        /// <li> <p> Setting this to true will only transition a HIT from <code>Reviewing</code> to <code>Reviewable</code> </p> </li>
        /// </ul>
        pub fn set_revert(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_revert(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateHITTypeOfHIT`.
    ///
    /// <p> The <code>UpdateHITTypeOfHIT</code> operation allows you to change the HITType properties of a HIT. This operation disassociates the HIT from its old HITType properties and associates it with the new HITType properties. The HIT takes on the properties of the new HITType in place of the old ones. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateHITTypeOfHIT {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_hit_type_of_hit_input::Builder,
    }
    impl UpdateHITTypeOfHIT {
        /// Creates a new `UpdateHITTypeOfHIT`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateHitTypeOfHitOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateHITTypeOfHITError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The HIT to update.</p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_id(input.into());
            self
        }
        /// <p>The HIT to update.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_id(input);
            self
        }
        /// <p>The ID of the new HIT type.</p>
        pub fn hit_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_type_id(input.into());
            self
        }
        /// <p>The ID of the new HIT type.</p>
        pub fn set_hit_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_type_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNotificationSettings`.
    ///
    /// <p> The <code>UpdateNotificationSettings</code> operation creates, updates, disables or re-enables notifications for a HIT type. If you call the UpdateNotificationSettings operation for a HIT type that already has a notification specification, the operation replaces the old specification with a new one. You can call the UpdateNotificationSettings operation to enable or disable notifications for the HIT type, without having to modify the notification specification itself by providing updates to the Active status without specifying a new notification specification. To change the Active status of a HIT type's notifications, the HIT type must already have a notification specification, or one must be provided in the same call to <code>UpdateNotificationSettings</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateNotificationSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_notification_settings_input::Builder,
    }
    impl UpdateNotificationSettings {
        /// Creates a new `UpdateNotificationSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNotificationSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNotificationSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the HIT type whose notification specification is being updated. </p>
        pub fn hit_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_type_id(input.into());
            self
        }
        /// <p> The ID of the HIT type whose notification specification is being updated. </p>
        pub fn set_hit_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_type_id(input);
            self
        }
        /// <p> The notification specification for the HIT type. </p>
        pub fn notification(mut self, input: crate::model::NotificationSpecification) -> Self {
            self.inner = self.inner.notification(input);
            self
        }
        /// <p> The notification specification for the HIT type. </p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::NotificationSpecification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
        /// <p> Specifies whether notifications are sent for HITs of this HIT type, according to the notification specification. You must specify either the Notification parameter or the Active parameter for the call to UpdateNotificationSettings to succeed. </p>
        pub fn active(mut self, input: bool) -> Self {
            self.inner = self.inner.active(input);
            self
        }
        /// <p> Specifies whether notifications are sent for HITs of this HIT type, according to the notification specification. You must specify either the Notification parameter or the Active parameter for the call to UpdateNotificationSettings to succeed. </p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_active(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateQualificationType`.
    ///
    /// <p> The <code>UpdateQualificationType</code> operation modifies the attributes of an existing Qualification type, which is represented by a QualificationType data structure. Only the owner of a Qualification type can modify its attributes. </p>
    /// <p> Most attributes of a Qualification type can be changed after the type has been created. However, the Name and Keywords fields cannot be modified. The RetryDelayInSeconds parameter can be modified or added to change the delay or to enable retries, but RetryDelayInSeconds cannot be used to disable retries. </p>
    /// <p> You can use this operation to update the test for a Qualification type. The test is updated based on the values specified for the Test, TestDurationInSeconds and AnswerKey parameters. All three parameters specify the updated test. If you are updating the test for a type, you must specify the Test and TestDurationInSeconds parameters. The AnswerKey parameter is optional; omitting it specifies that the updated test does not have an answer key. </p>
    /// <p> If you omit the Test parameter, the test for the Qualification type is unchanged. There is no way to remove a test from a Qualification type that has one. If the type already has a test, you cannot update it to be AutoGranted. If the Qualification type does not have a test and one is provided by an update, the type will henceforth have a test. </p>
    /// <p> If you want to update the test duration or answer key for an existing test without changing the questions, you must specify a Test parameter with the original questions, along with the updated values. </p>
    /// <p> If you provide an updated Test but no AnswerKey, the new test will not have an answer key. Requests for such Qualifications must be granted manually. </p>
    /// <p> You can also update the AutoGranted and AutoGrantedValue attributes of the Qualification type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateQualificationType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_qualification_type_input::Builder,
    }
    impl UpdateQualificationType {
        /// Creates a new `UpdateQualificationType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateQualificationTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateQualificationTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Qualification type to update.</p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_type_id(input.into());
            self
        }
        /// <p>The ID of the Qualification type to update.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_id(input);
            self
        }
        /// <p>The new description of the Qualification type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The new description of the Qualification type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The new status of the Qualification type - Active | Inactive</p>
        pub fn qualification_type_status(
            mut self,
            input: crate::model::QualificationTypeStatus,
        ) -> Self {
            self.inner = self.inner.qualification_type_status(input);
            self
        }
        /// <p>The new status of the Qualification type - Active | Inactive</p>
        pub fn set_qualification_type_status(
            mut self,
            input: std::option::Option<crate::model::QualificationTypeStatus>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_status(input);
            self
        }
        /// <p>The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified.</p>
        /// <p>Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be specified if AutoGranted is true.</p>
        /// <p>Constraints: None. If not specified, the Worker may request the Qualification without answering any questions.</p>
        pub fn test(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.test(input.into());
            self
        }
        /// <p>The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified.</p>
        /// <p>Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be specified if AutoGranted is true.</p>
        /// <p>Constraints: None. If not specified, the Worker may request the Qualification without answering any questions.</p>
        pub fn set_test(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_test(input);
            self
        }
        /// <p>The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data structure.</p>
        pub fn answer_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.answer_key(input.into());
            self
        }
        /// <p>The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data structure.</p>
        pub fn set_answer_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_answer_key(input);
            self
        }
        /// <p>The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker requests the Qualification.</p>
        pub fn test_duration_in_seconds(mut self, input: i64) -> Self {
            self.inner = self.inner.test_duration_in_seconds(input);
            self
        }
        /// <p>The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker requests the Qualification.</p>
        pub fn set_test_duration_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_test_duration_in_seconds(input);
            self
        }
        /// <p>The amount of time, in seconds, that Workers must wait after requesting a Qualification of the specified Qualification type before they can retry the Qualification request. It is not possible to disable retries for a Qualification type after it has been created with retries enabled. If you want to disable retries, you must dispose of the existing retry-enabled Qualification type using DisposeQualificationType and then create a new Qualification type with retries disabled using CreateQualificationType.</p>
        pub fn retry_delay_in_seconds(mut self, input: i64) -> Self {
            self.inner = self.inner.retry_delay_in_seconds(input);
            self
        }
        /// <p>The amount of time, in seconds, that Workers must wait after requesting a Qualification of the specified Qualification type before they can retry the Qualification request. It is not possible to disable retries for a Qualification type after it has been created with retries enabled. If you want to disable retries, you must dispose of the existing retry-enabled Qualification type using DisposeQualificationType and then create a new Qualification type with retries disabled using CreateQualificationType.</p>
        pub fn set_retry_delay_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_retry_delay_in_seconds(input);
            self
        }
        /// <p>Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test.</p>
        /// <p>Constraints: If the Test parameter is specified, this parameter cannot be true.</p>
        pub fn auto_granted(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_granted(input);
            self
        }
        /// <p>Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test.</p>
        /// <p>Constraints: If the Test parameter is specified, this parameter cannot be true.</p>
        pub fn set_auto_granted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_granted(input);
            self
        }
        /// <p>The Qualification value to use for automatically granted Qualifications. This parameter is used only if the AutoGranted parameter is true.</p>
        pub fn auto_granted_value(mut self, input: i32) -> Self {
            self.inner = self.inner.auto_granted_value(input);
            self
        }
        /// <p>The Qualification value to use for automatically granted Qualifications. This parameter is used only if the AutoGranted parameter is true.</p>
        pub fn set_auto_granted_value(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_auto_granted_value(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
