// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p> The QualificationType data structure represents a Qualification type, a description of a property of a Worker that must match the requirements of a HIT for the Worker to be able to accept the HIT. The type also describes how a Worker can obtain a Qualification of that type, such as through a Qualification test. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QualificationType {
    /// <p> A unique identifier for the Qualification type. A Qualification type is given a Qualification type ID when you call the CreateQualificationType operation. </p>
    pub qualification_type_id: std::option::Option<std::string::String>,
    /// <p> The date and time the Qualification type was created. </p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The name of the Qualification type. The type name is used to identify the type, and to find the type using a Qualification type search. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> A long description for the Qualification type. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> One or more words or phrases that describe theQualification type, separated by commas. The Keywords make the type easier to find using a search. </p>
    pub keywords: std::option::Option<std::string::String>,
    /// <p> The status of the Qualification type. A Qualification type's status determines if users can apply to receive a Qualification of this type, and if HITs can be created with requirements based on this type. Valid values are Active | Inactive. </p>
    pub qualification_type_status: std::option::Option<crate::model::QualificationTypeStatus>,
    /// <p> The questions for a Qualification test associated with this Qualification type that a user can take to obtain a Qualification of this type. This parameter must be specified if AnswerKey is present. A Qualification type cannot have both a specified Test parameter and an AutoGranted value of true. </p>
    pub test: std::option::Option<std::string::String>,
    /// <p> The amount of time, in seconds, given to a Worker to complete the Qualification test, beginning from the time the Worker requests the Qualification. </p>
    pub test_duration_in_seconds: std::option::Option<i64>,
    /// <p>The answers to the Qualification test specified in the Test parameter.</p>
    pub answer_key: std::option::Option<std::string::String>,
    /// <p> The amount of time, in seconds, Workers must wait after taking the Qualification test before they can take it again. Workers can take a Qualification test multiple times if they were not granted the Qualification from a previous attempt, or if the test offers a gradient score and they want a better score. If not specified, retries are disabled and Workers can request a Qualification only once. </p>
    pub retry_delay_in_seconds: std::option::Option<i64>,
    /// <p> Specifies whether the Qualification type is one that a user can request through the Amazon Mechanical Turk web site, such as by taking a Qualification test. This value is False for Qualifications assigned automatically by the system. Valid values are True | False. </p>
    pub is_requestable: std::option::Option<bool>,
    /// <p>Specifies that requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test. Valid values are True | False.</p>
    pub auto_granted: std::option::Option<bool>,
    /// <p> The Qualification integer value to use for automatically granted Qualifications, if AutoGranted is true. This is 1 by default. </p>
    pub auto_granted_value: std::option::Option<i32>,
}
impl QualificationType {
    /// <p> A unique identifier for the Qualification type. A Qualification type is given a Qualification type ID when you call the CreateQualificationType operation. </p>
    pub fn qualification_type_id(&self) -> std::option::Option<&str> {
        self.qualification_type_id.as_deref()
    }
    /// <p> The date and time the Qualification type was created. </p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p> The name of the Qualification type. The type name is used to identify the type, and to find the type using a Qualification type search. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> A long description for the Qualification type. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> One or more words or phrases that describe theQualification type, separated by commas. The Keywords make the type easier to find using a search. </p>
    pub fn keywords(&self) -> std::option::Option<&str> {
        self.keywords.as_deref()
    }
    /// <p> The status of the Qualification type. A Qualification type's status determines if users can apply to receive a Qualification of this type, and if HITs can be created with requirements based on this type. Valid values are Active | Inactive. </p>
    pub fn qualification_type_status(
        &self,
    ) -> std::option::Option<&crate::model::QualificationTypeStatus> {
        self.qualification_type_status.as_ref()
    }
    /// <p> The questions for a Qualification test associated with this Qualification type that a user can take to obtain a Qualification of this type. This parameter must be specified if AnswerKey is present. A Qualification type cannot have both a specified Test parameter and an AutoGranted value of true. </p>
    pub fn test(&self) -> std::option::Option<&str> {
        self.test.as_deref()
    }
    /// <p> The amount of time, in seconds, given to a Worker to complete the Qualification test, beginning from the time the Worker requests the Qualification. </p>
    pub fn test_duration_in_seconds(&self) -> std::option::Option<i64> {
        self.test_duration_in_seconds
    }
    /// <p>The answers to the Qualification test specified in the Test parameter.</p>
    pub fn answer_key(&self) -> std::option::Option<&str> {
        self.answer_key.as_deref()
    }
    /// <p> The amount of time, in seconds, Workers must wait after taking the Qualification test before they can take it again. Workers can take a Qualification test multiple times if they were not granted the Qualification from a previous attempt, or if the test offers a gradient score and they want a better score. If not specified, retries are disabled and Workers can request a Qualification only once. </p>
    pub fn retry_delay_in_seconds(&self) -> std::option::Option<i64> {
        self.retry_delay_in_seconds
    }
    /// <p> Specifies whether the Qualification type is one that a user can request through the Amazon Mechanical Turk web site, such as by taking a Qualification test. This value is False for Qualifications assigned automatically by the system. Valid values are True | False. </p>
    pub fn is_requestable(&self) -> std::option::Option<bool> {
        self.is_requestable
    }
    /// <p>Specifies that requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test. Valid values are True | False.</p>
    pub fn auto_granted(&self) -> std::option::Option<bool> {
        self.auto_granted
    }
    /// <p> The Qualification integer value to use for automatically granted Qualifications, if AutoGranted is true. This is 1 by default. </p>
    pub fn auto_granted_value(&self) -> std::option::Option<i32> {
        self.auto_granted_value
    }
}
impl std::fmt::Debug for QualificationType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QualificationType");
        formatter.field("qualification_type_id", &self.qualification_type_id);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("keywords", &self.keywords);
        formatter.field("qualification_type_status", &self.qualification_type_status);
        formatter.field("test", &self.test);
        formatter.field("test_duration_in_seconds", &self.test_duration_in_seconds);
        formatter.field("answer_key", &self.answer_key);
        formatter.field("retry_delay_in_seconds", &self.retry_delay_in_seconds);
        formatter.field("is_requestable", &self.is_requestable);
        formatter.field("auto_granted", &self.auto_granted);
        formatter.field("auto_granted_value", &self.auto_granted_value);
        formatter.finish()
    }
}
/// See [`QualificationType`](crate::model::QualificationType)
pub mod qualification_type {
    /// A builder for [`QualificationType`](crate::model::QualificationType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) qualification_type_id: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) keywords: std::option::Option<std::string::String>,
        pub(crate) qualification_type_status:
            std::option::Option<crate::model::QualificationTypeStatus>,
        pub(crate) test: std::option::Option<std::string::String>,
        pub(crate) test_duration_in_seconds: std::option::Option<i64>,
        pub(crate) answer_key: std::option::Option<std::string::String>,
        pub(crate) retry_delay_in_seconds: std::option::Option<i64>,
        pub(crate) is_requestable: std::option::Option<bool>,
        pub(crate) auto_granted: std::option::Option<bool>,
        pub(crate) auto_granted_value: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> A unique identifier for the Qualification type. A Qualification type is given a Qualification type ID when you call the CreateQualificationType operation. </p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualification_type_id = Some(input.into());
            self
        }
        /// <p> A unique identifier for the Qualification type. A Qualification type is given a Qualification type ID when you call the CreateQualificationType operation. </p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.qualification_type_id = input;
            self
        }
        /// <p> The date and time the Qualification type was created. </p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p> The date and time the Qualification type was created. </p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p> The name of the Qualification type. The type name is used to identify the type, and to find the type using a Qualification type search. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the Qualification type. The type name is used to identify the type, and to find the type using a Qualification type search. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> A long description for the Qualification type. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> A long description for the Qualification type. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> One or more words or phrases that describe theQualification type, separated by commas. The Keywords make the type easier to find using a search. </p>
        pub fn keywords(mut self, input: impl Into<std::string::String>) -> Self {
            self.keywords = Some(input.into());
            self
        }
        /// <p> One or more words or phrases that describe theQualification type, separated by commas. The Keywords make the type easier to find using a search. </p>
        pub fn set_keywords(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.keywords = input;
            self
        }
        /// <p> The status of the Qualification type. A Qualification type's status determines if users can apply to receive a Qualification of this type, and if HITs can be created with requirements based on this type. Valid values are Active | Inactive. </p>
        pub fn qualification_type_status(
            mut self,
            input: crate::model::QualificationTypeStatus,
        ) -> Self {
            self.qualification_type_status = Some(input);
            self
        }
        /// <p> The status of the Qualification type. A Qualification type's status determines if users can apply to receive a Qualification of this type, and if HITs can be created with requirements based on this type. Valid values are Active | Inactive. </p>
        pub fn set_qualification_type_status(
            mut self,
            input: std::option::Option<crate::model::QualificationTypeStatus>,
        ) -> Self {
            self.qualification_type_status = input;
            self
        }
        /// <p> The questions for a Qualification test associated with this Qualification type that a user can take to obtain a Qualification of this type. This parameter must be specified if AnswerKey is present. A Qualification type cannot have both a specified Test parameter and an AutoGranted value of true. </p>
        pub fn test(mut self, input: impl Into<std::string::String>) -> Self {
            self.test = Some(input.into());
            self
        }
        /// <p> The questions for a Qualification test associated with this Qualification type that a user can take to obtain a Qualification of this type. This parameter must be specified if AnswerKey is present. A Qualification type cannot have both a specified Test parameter and an AutoGranted value of true. </p>
        pub fn set_test(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.test = input;
            self
        }
        /// <p> The amount of time, in seconds, given to a Worker to complete the Qualification test, beginning from the time the Worker requests the Qualification. </p>
        pub fn test_duration_in_seconds(mut self, input: i64) -> Self {
            self.test_duration_in_seconds = Some(input);
            self
        }
        /// <p> The amount of time, in seconds, given to a Worker to complete the Qualification test, beginning from the time the Worker requests the Qualification. </p>
        pub fn set_test_duration_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.test_duration_in_seconds = input;
            self
        }
        /// <p>The answers to the Qualification test specified in the Test parameter.</p>
        pub fn answer_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.answer_key = Some(input.into());
            self
        }
        /// <p>The answers to the Qualification test specified in the Test parameter.</p>
        pub fn set_answer_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.answer_key = input;
            self
        }
        /// <p> The amount of time, in seconds, Workers must wait after taking the Qualification test before they can take it again. Workers can take a Qualification test multiple times if they were not granted the Qualification from a previous attempt, or if the test offers a gradient score and they want a better score. If not specified, retries are disabled and Workers can request a Qualification only once. </p>
        pub fn retry_delay_in_seconds(mut self, input: i64) -> Self {
            self.retry_delay_in_seconds = Some(input);
            self
        }
        /// <p> The amount of time, in seconds, Workers must wait after taking the Qualification test before they can take it again. Workers can take a Qualification test multiple times if they were not granted the Qualification from a previous attempt, or if the test offers a gradient score and they want a better score. If not specified, retries are disabled and Workers can request a Qualification only once. </p>
        pub fn set_retry_delay_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.retry_delay_in_seconds = input;
            self
        }
        /// <p> Specifies whether the Qualification type is one that a user can request through the Amazon Mechanical Turk web site, such as by taking a Qualification test. This value is False for Qualifications assigned automatically by the system. Valid values are True | False. </p>
        pub fn is_requestable(mut self, input: bool) -> Self {
            self.is_requestable = Some(input);
            self
        }
        /// <p> Specifies whether the Qualification type is one that a user can request through the Amazon Mechanical Turk web site, such as by taking a Qualification test. This value is False for Qualifications assigned automatically by the system. Valid values are True | False. </p>
        pub fn set_is_requestable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_requestable = input;
            self
        }
        /// <p>Specifies that requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test. Valid values are True | False.</p>
        pub fn auto_granted(mut self, input: bool) -> Self {
            self.auto_granted = Some(input);
            self
        }
        /// <p>Specifies that requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test. Valid values are True | False.</p>
        pub fn set_auto_granted(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_granted = input;
            self
        }
        /// <p> The Qualification integer value to use for automatically granted Qualifications, if AutoGranted is true. This is 1 by default. </p>
        pub fn auto_granted_value(mut self, input: i32) -> Self {
            self.auto_granted_value = Some(input);
            self
        }
        /// <p> The Qualification integer value to use for automatically granted Qualifications, if AutoGranted is true. This is 1 by default. </p>
        pub fn set_auto_granted_value(mut self, input: std::option::Option<i32>) -> Self {
            self.auto_granted_value = input;
            self
        }
        /// Consumes the builder and constructs a [`QualificationType`](crate::model::QualificationType)
        pub fn build(self) -> crate::model::QualificationType {
            crate::model::QualificationType {
                qualification_type_id: self.qualification_type_id,
                creation_time: self.creation_time,
                name: self.name,
                description: self.description,
                keywords: self.keywords,
                qualification_type_status: self.qualification_type_status,
                test: self.test,
                test_duration_in_seconds: self.test_duration_in_seconds,
                answer_key: self.answer_key,
                retry_delay_in_seconds: self.retry_delay_in_seconds,
                is_requestable: self.is_requestable,
                auto_granted: self.auto_granted,
                auto_granted_value: self.auto_granted_value,
            }
        }
    }
}
impl QualificationType {
    /// Creates a new builder-style object to manufacture [`QualificationType`](crate::model::QualificationType)
    pub fn builder() -> crate::model::qualification_type::Builder {
        crate::model::qualification_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QualificationTypeStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QualificationTypeStatus {
    fn from(s: &str) -> Self {
        match s {
            "Active" => QualificationTypeStatus::Active,
            "Inactive" => QualificationTypeStatus::Inactive,
            other => QualificationTypeStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QualificationTypeStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QualificationTypeStatus::from(s))
    }
}
impl QualificationTypeStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QualificationTypeStatus::Active => "Active",
            QualificationTypeStatus::Inactive => "Inactive",
            QualificationTypeStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Active", "Inactive"]
    }
}
impl AsRef<str> for QualificationTypeStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The NotificationSpecification data structure describes a HIT event notification for a HIT type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationSpecification {
    /// <p> The target for notification messages. The Destination’s format is determined by the specified Transport: </p>
    /// <ul>
    /// <li> <p>When Transport is Email, the Destination is your email address.</p> </li>
    /// <li> <p>When Transport is SQS, the Destination is your queue URL.</p> </li>
    /// <li> <p>When Transport is SNS, the Destination is the ARN of your topic.</p> </li>
    /// </ul>
    pub destination: std::option::Option<std::string::String>,
    /// <p> The method Amazon Mechanical Turk uses to send the notification. Valid Values: Email | SQS | SNS. </p>
    pub transport: std::option::Option<crate::model::NotificationTransport>,
    /// <p>The version of the Notification API to use. Valid value is 2006-05-05.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p> The list of events that should cause notifications to be sent. Valid Values: AssignmentAccepted | AssignmentAbandoned | AssignmentReturned | AssignmentSubmitted | AssignmentRejected | AssignmentApproved | HITCreated | HITExtended | HITDisposed | HITReviewable | HITExpired | Ping. The Ping event is only valid for the SendTestEventNotification operation. </p>
    pub event_types: std::option::Option<std::vec::Vec<crate::model::EventType>>,
}
impl NotificationSpecification {
    /// <p> The target for notification messages. The Destination’s format is determined by the specified Transport: </p>
    /// <ul>
    /// <li> <p>When Transport is Email, the Destination is your email address.</p> </li>
    /// <li> <p>When Transport is SQS, the Destination is your queue URL.</p> </li>
    /// <li> <p>When Transport is SNS, the Destination is the ARN of your topic.</p> </li>
    /// </ul>
    pub fn destination(&self) -> std::option::Option<&str> {
        self.destination.as_deref()
    }
    /// <p> The method Amazon Mechanical Turk uses to send the notification. Valid Values: Email | SQS | SNS. </p>
    pub fn transport(&self) -> std::option::Option<&crate::model::NotificationTransport> {
        self.transport.as_ref()
    }
    /// <p>The version of the Notification API to use. Valid value is 2006-05-05.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p> The list of events that should cause notifications to be sent. Valid Values: AssignmentAccepted | AssignmentAbandoned | AssignmentReturned | AssignmentSubmitted | AssignmentRejected | AssignmentApproved | HITCreated | HITExtended | HITDisposed | HITReviewable | HITExpired | Ping. The Ping event is only valid for the SendTestEventNotification operation. </p>
    pub fn event_types(&self) -> std::option::Option<&[crate::model::EventType]> {
        self.event_types.as_deref()
    }
}
impl std::fmt::Debug for NotificationSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationSpecification");
        formatter.field("destination", &self.destination);
        formatter.field("transport", &self.transport);
        formatter.field("version", &self.version);
        formatter.field("event_types", &self.event_types);
        formatter.finish()
    }
}
/// See [`NotificationSpecification`](crate::model::NotificationSpecification)
pub mod notification_specification {
    /// A builder for [`NotificationSpecification`](crate::model::NotificationSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination: std::option::Option<std::string::String>,
        pub(crate) transport: std::option::Option<crate::model::NotificationTransport>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) event_types: std::option::Option<std::vec::Vec<crate::model::EventType>>,
    }
    impl Builder {
        /// <p> The target for notification messages. The Destination’s format is determined by the specified Transport: </p>
        /// <ul>
        /// <li> <p>When Transport is Email, the Destination is your email address.</p> </li>
        /// <li> <p>When Transport is SQS, the Destination is your queue URL.</p> </li>
        /// <li> <p>When Transport is SNS, the Destination is the ARN of your topic.</p> </li>
        /// </ul>
        pub fn destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination = Some(input.into());
            self
        }
        /// <p> The target for notification messages. The Destination’s format is determined by the specified Transport: </p>
        /// <ul>
        /// <li> <p>When Transport is Email, the Destination is your email address.</p> </li>
        /// <li> <p>When Transport is SQS, the Destination is your queue URL.</p> </li>
        /// <li> <p>When Transport is SNS, the Destination is the ARN of your topic.</p> </li>
        /// </ul>
        pub fn set_destination(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.destination = input;
            self
        }
        /// <p> The method Amazon Mechanical Turk uses to send the notification. Valid Values: Email | SQS | SNS. </p>
        pub fn transport(mut self, input: crate::model::NotificationTransport) -> Self {
            self.transport = Some(input);
            self
        }
        /// <p> The method Amazon Mechanical Turk uses to send the notification. Valid Values: Email | SQS | SNS. </p>
        pub fn set_transport(
            mut self,
            input: std::option::Option<crate::model::NotificationTransport>,
        ) -> Self {
            self.transport = input;
            self
        }
        /// <p>The version of the Notification API to use. Valid value is 2006-05-05.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the Notification API to use. Valid value is 2006-05-05.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `event_types`.
        ///
        /// To override the contents of this collection use [`set_event_types`](Self::set_event_types).
        ///
        /// <p> The list of events that should cause notifications to be sent. Valid Values: AssignmentAccepted | AssignmentAbandoned | AssignmentReturned | AssignmentSubmitted | AssignmentRejected | AssignmentApproved | HITCreated | HITExtended | HITDisposed | HITReviewable | HITExpired | Ping. The Ping event is only valid for the SendTestEventNotification operation. </p>
        pub fn event_types(mut self, input: crate::model::EventType) -> Self {
            let mut v = self.event_types.unwrap_or_default();
            v.push(input);
            self.event_types = Some(v);
            self
        }
        /// <p> The list of events that should cause notifications to be sent. Valid Values: AssignmentAccepted | AssignmentAbandoned | AssignmentReturned | AssignmentSubmitted | AssignmentRejected | AssignmentApproved | HITCreated | HITExtended | HITDisposed | HITReviewable | HITExpired | Ping. The Ping event is only valid for the SendTestEventNotification operation. </p>
        pub fn set_event_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventType>>,
        ) -> Self {
            self.event_types = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationSpecification`](crate::model::NotificationSpecification)
        pub fn build(self) -> crate::model::NotificationSpecification {
            crate::model::NotificationSpecification {
                destination: self.destination,
                transport: self.transport,
                version: self.version,
                event_types: self.event_types,
            }
        }
    }
}
impl NotificationSpecification {
    /// Creates a new builder-style object to manufacture [`NotificationSpecification`](crate::model::NotificationSpecification)
    pub fn builder() -> crate::model::notification_specification::Builder {
        crate::model::notification_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventType {
    #[allow(missing_docs)] // documentation missing in model
    AssignmentAbandoned,
    #[allow(missing_docs)] // documentation missing in model
    AssignmentAccepted,
    #[allow(missing_docs)] // documentation missing in model
    AssignmentApproved,
    #[allow(missing_docs)] // documentation missing in model
    AssignmentRejected,
    #[allow(missing_docs)] // documentation missing in model
    AssignmentReturned,
    #[allow(missing_docs)] // documentation missing in model
    AssignmentSubmitted,
    #[allow(missing_docs)] // documentation missing in model
    HitCreated,
    #[allow(missing_docs)] // documentation missing in model
    HitDisposed,
    #[allow(missing_docs)] // documentation missing in model
    HitExpired,
    #[allow(missing_docs)] // documentation missing in model
    HitExtended,
    #[allow(missing_docs)] // documentation missing in model
    HitReviewable,
    #[allow(missing_docs)] // documentation missing in model
    Ping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventType {
    fn from(s: &str) -> Self {
        match s {
            "AssignmentAbandoned" => EventType::AssignmentAbandoned,
            "AssignmentAccepted" => EventType::AssignmentAccepted,
            "AssignmentApproved" => EventType::AssignmentApproved,
            "AssignmentRejected" => EventType::AssignmentRejected,
            "AssignmentReturned" => EventType::AssignmentReturned,
            "AssignmentSubmitted" => EventType::AssignmentSubmitted,
            "HITCreated" => EventType::HitCreated,
            "HITDisposed" => EventType::HitDisposed,
            "HITExpired" => EventType::HitExpired,
            "HITExtended" => EventType::HitExtended,
            "HITReviewable" => EventType::HitReviewable,
            "Ping" => EventType::Ping,
            other => EventType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventType::from(s))
    }
}
impl EventType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventType::AssignmentAbandoned => "AssignmentAbandoned",
            EventType::AssignmentAccepted => "AssignmentAccepted",
            EventType::AssignmentApproved => "AssignmentApproved",
            EventType::AssignmentRejected => "AssignmentRejected",
            EventType::AssignmentReturned => "AssignmentReturned",
            EventType::AssignmentSubmitted => "AssignmentSubmitted",
            EventType::HitCreated => "HITCreated",
            EventType::HitDisposed => "HITDisposed",
            EventType::HitExpired => "HITExpired",
            EventType::HitExtended => "HITExtended",
            EventType::HitReviewable => "HITReviewable",
            EventType::Ping => "Ping",
            EventType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AssignmentAbandoned",
            "AssignmentAccepted",
            "AssignmentApproved",
            "AssignmentRejected",
            "AssignmentReturned",
            "AssignmentSubmitted",
            "HITCreated",
            "HITDisposed",
            "HITExpired",
            "HITExtended",
            "HITReviewable",
            "Ping",
        ]
    }
}
impl AsRef<str> for EventType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NotificationTransport {
    #[allow(missing_docs)] // documentation missing in model
    Email,
    #[allow(missing_docs)] // documentation missing in model
    Sns,
    #[allow(missing_docs)] // documentation missing in model
    Sqs,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NotificationTransport {
    fn from(s: &str) -> Self {
        match s {
            "Email" => NotificationTransport::Email,
            "SNS" => NotificationTransport::Sns,
            "SQS" => NotificationTransport::Sqs,
            other => NotificationTransport::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NotificationTransport {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NotificationTransport::from(s))
    }
}
impl NotificationTransport {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NotificationTransport::Email => "Email",
            NotificationTransport::Sns => "SNS",
            NotificationTransport::Sqs => "SQS",
            NotificationTransport::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Email", "SNS", "SQS"]
    }
}
impl AsRef<str> for NotificationTransport {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> When MTurk encounters an issue with notifying the Workers you specified, it returns back this object with failure details. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotifyWorkersFailureStatus {
    /// <p> Encoded value for the failure type. </p>
    pub notify_workers_failure_code: std::option::Option<crate::model::NotifyWorkersFailureCode>,
    /// <p> A message detailing the reason the Worker could not be notified. </p>
    pub notify_workers_failure_message: std::option::Option<std::string::String>,
    /// <p> The ID of the Worker.</p>
    pub worker_id: std::option::Option<std::string::String>,
}
impl NotifyWorkersFailureStatus {
    /// <p> Encoded value for the failure type. </p>
    pub fn notify_workers_failure_code(
        &self,
    ) -> std::option::Option<&crate::model::NotifyWorkersFailureCode> {
        self.notify_workers_failure_code.as_ref()
    }
    /// <p> A message detailing the reason the Worker could not be notified. </p>
    pub fn notify_workers_failure_message(&self) -> std::option::Option<&str> {
        self.notify_workers_failure_message.as_deref()
    }
    /// <p> The ID of the Worker.</p>
    pub fn worker_id(&self) -> std::option::Option<&str> {
        self.worker_id.as_deref()
    }
}
impl std::fmt::Debug for NotifyWorkersFailureStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotifyWorkersFailureStatus");
        formatter.field(
            "notify_workers_failure_code",
            &self.notify_workers_failure_code,
        );
        formatter.field(
            "notify_workers_failure_message",
            &self.notify_workers_failure_message,
        );
        formatter.field("worker_id", &self.worker_id);
        formatter.finish()
    }
}
/// See [`NotifyWorkersFailureStatus`](crate::model::NotifyWorkersFailureStatus)
pub mod notify_workers_failure_status {
    /// A builder for [`NotifyWorkersFailureStatus`](crate::model::NotifyWorkersFailureStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notify_workers_failure_code:
            std::option::Option<crate::model::NotifyWorkersFailureCode>,
        pub(crate) notify_workers_failure_message: std::option::Option<std::string::String>,
        pub(crate) worker_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> Encoded value for the failure type. </p>
        pub fn notify_workers_failure_code(
            mut self,
            input: crate::model::NotifyWorkersFailureCode,
        ) -> Self {
            self.notify_workers_failure_code = Some(input);
            self
        }
        /// <p> Encoded value for the failure type. </p>
        pub fn set_notify_workers_failure_code(
            mut self,
            input: std::option::Option<crate::model::NotifyWorkersFailureCode>,
        ) -> Self {
            self.notify_workers_failure_code = input;
            self
        }
        /// <p> A message detailing the reason the Worker could not be notified. </p>
        pub fn notify_workers_failure_message(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.notify_workers_failure_message = Some(input.into());
            self
        }
        /// <p> A message detailing the reason the Worker could not be notified. </p>
        pub fn set_notify_workers_failure_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notify_workers_failure_message = input;
            self
        }
        /// <p> The ID of the Worker.</p>
        pub fn worker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_id = Some(input.into());
            self
        }
        /// <p> The ID of the Worker.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.worker_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NotifyWorkersFailureStatus`](crate::model::NotifyWorkersFailureStatus)
        pub fn build(self) -> crate::model::NotifyWorkersFailureStatus {
            crate::model::NotifyWorkersFailureStatus {
                notify_workers_failure_code: self.notify_workers_failure_code,
                notify_workers_failure_message: self.notify_workers_failure_message,
                worker_id: self.worker_id,
            }
        }
    }
}
impl NotifyWorkersFailureStatus {
    /// Creates a new builder-style object to manufacture [`NotifyWorkersFailureStatus`](crate::model::NotifyWorkersFailureStatus)
    pub fn builder() -> crate::model::notify_workers_failure_status::Builder {
        crate::model::notify_workers_failure_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NotifyWorkersFailureCode {
    #[allow(missing_docs)] // documentation missing in model
    HardFailure,
    #[allow(missing_docs)] // documentation missing in model
    SoftFailure,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NotifyWorkersFailureCode {
    fn from(s: &str) -> Self {
        match s {
            "HardFailure" => NotifyWorkersFailureCode::HardFailure,
            "SoftFailure" => NotifyWorkersFailureCode::SoftFailure,
            other => NotifyWorkersFailureCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NotifyWorkersFailureCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NotifyWorkersFailureCode::from(s))
    }
}
impl NotifyWorkersFailureCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NotifyWorkersFailureCode::HardFailure => "HardFailure",
            NotifyWorkersFailureCode::SoftFailure => "SoftFailure",
            NotifyWorkersFailureCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HardFailure", "SoftFailure"]
    }
}
impl AsRef<str> for NotifyWorkersFailureCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The Qualification data structure represents a Qualification assigned to a user, including the Qualification type and the value (score).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Qualification {
    /// <p> The ID of the Qualification type for the Qualification.</p>
    pub qualification_type_id: std::option::Option<std::string::String>,
    /// <p> The ID of the Worker who possesses the Qualification. </p>
    pub worker_id: std::option::Option<std::string::String>,
    /// <p> The date and time the Qualification was granted to the Worker. If the Worker's Qualification was revoked, and then re-granted based on a new Qualification request, GrantTime is the date and time of the last call to the AcceptQualificationRequest operation.</p>
    pub grant_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The value (score) of the Qualification, if the Qualification has an integer value.</p>
    pub integer_value: std::option::Option<i32>,
    /// <p>The Locale data structure represents a geographical region or location.</p>
    pub locale_value: std::option::Option<crate::model::Locale>,
    /// <p> The status of the Qualification. Valid values are Granted | Revoked.</p>
    pub status: std::option::Option<crate::model::QualificationStatus>,
}
impl Qualification {
    /// <p> The ID of the Qualification type for the Qualification.</p>
    pub fn qualification_type_id(&self) -> std::option::Option<&str> {
        self.qualification_type_id.as_deref()
    }
    /// <p> The ID of the Worker who possesses the Qualification. </p>
    pub fn worker_id(&self) -> std::option::Option<&str> {
        self.worker_id.as_deref()
    }
    /// <p> The date and time the Qualification was granted to the Worker. If the Worker's Qualification was revoked, and then re-granted based on a new Qualification request, GrantTime is the date and time of the last call to the AcceptQualificationRequest operation.</p>
    pub fn grant_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.grant_time.as_ref()
    }
    /// <p> The value (score) of the Qualification, if the Qualification has an integer value.</p>
    pub fn integer_value(&self) -> std::option::Option<i32> {
        self.integer_value
    }
    /// <p>The Locale data structure represents a geographical region or location.</p>
    pub fn locale_value(&self) -> std::option::Option<&crate::model::Locale> {
        self.locale_value.as_ref()
    }
    /// <p> The status of the Qualification. Valid values are Granted | Revoked.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::QualificationStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for Qualification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Qualification");
        formatter.field("qualification_type_id", &self.qualification_type_id);
        formatter.field("worker_id", &self.worker_id);
        formatter.field("grant_time", &self.grant_time);
        formatter.field("integer_value", &self.integer_value);
        formatter.field("locale_value", &self.locale_value);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`Qualification`](crate::model::Qualification)
pub mod qualification {
    /// A builder for [`Qualification`](crate::model::Qualification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) qualification_type_id: std::option::Option<std::string::String>,
        pub(crate) worker_id: std::option::Option<std::string::String>,
        pub(crate) grant_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) integer_value: std::option::Option<i32>,
        pub(crate) locale_value: std::option::Option<crate::model::Locale>,
        pub(crate) status: std::option::Option<crate::model::QualificationStatus>,
    }
    impl Builder {
        /// <p> The ID of the Qualification type for the Qualification.</p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualification_type_id = Some(input.into());
            self
        }
        /// <p> The ID of the Qualification type for the Qualification.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.qualification_type_id = input;
            self
        }
        /// <p> The ID of the Worker who possesses the Qualification. </p>
        pub fn worker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_id = Some(input.into());
            self
        }
        /// <p> The ID of the Worker who possesses the Qualification. </p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.worker_id = input;
            self
        }
        /// <p> The date and time the Qualification was granted to the Worker. If the Worker's Qualification was revoked, and then re-granted based on a new Qualification request, GrantTime is the date and time of the last call to the AcceptQualificationRequest operation.</p>
        pub fn grant_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.grant_time = Some(input);
            self
        }
        /// <p> The date and time the Qualification was granted to the Worker. If the Worker's Qualification was revoked, and then re-granted based on a new Qualification request, GrantTime is the date and time of the last call to the AcceptQualificationRequest operation.</p>
        pub fn set_grant_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.grant_time = input;
            self
        }
        /// <p> The value (score) of the Qualification, if the Qualification has an integer value.</p>
        pub fn integer_value(mut self, input: i32) -> Self {
            self.integer_value = Some(input);
            self
        }
        /// <p> The value (score) of the Qualification, if the Qualification has an integer value.</p>
        pub fn set_integer_value(mut self, input: std::option::Option<i32>) -> Self {
            self.integer_value = input;
            self
        }
        /// <p>The Locale data structure represents a geographical region or location.</p>
        pub fn locale_value(mut self, input: crate::model::Locale) -> Self {
            self.locale_value = Some(input);
            self
        }
        /// <p>The Locale data structure represents a geographical region or location.</p>
        pub fn set_locale_value(
            mut self,
            input: std::option::Option<crate::model::Locale>,
        ) -> Self {
            self.locale_value = input;
            self
        }
        /// <p> The status of the Qualification. Valid values are Granted | Revoked.</p>
        pub fn status(mut self, input: crate::model::QualificationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of the Qualification. Valid values are Granted | Revoked.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::QualificationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`Qualification`](crate::model::Qualification)
        pub fn build(self) -> crate::model::Qualification {
            crate::model::Qualification {
                qualification_type_id: self.qualification_type_id,
                worker_id: self.worker_id,
                grant_time: self.grant_time,
                integer_value: self.integer_value,
                locale_value: self.locale_value,
                status: self.status,
            }
        }
    }
}
impl Qualification {
    /// Creates a new builder-style object to manufacture [`Qualification`](crate::model::Qualification)
    pub fn builder() -> crate::model::qualification::Builder {
        crate::model::qualification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QualificationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Granted,
    #[allow(missing_docs)] // documentation missing in model
    Revoked,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QualificationStatus {
    fn from(s: &str) -> Self {
        match s {
            "Granted" => QualificationStatus::Granted,
            "Revoked" => QualificationStatus::Revoked,
            other => QualificationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QualificationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QualificationStatus::from(s))
    }
}
impl QualificationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QualificationStatus::Granted => "Granted",
            QualificationStatus::Revoked => "Revoked",
            QualificationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Granted", "Revoked"]
    }
}
impl AsRef<str> for QualificationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The Locale data structure represents a geographical region or location.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Locale {
    /// <p> The country of the locale. Must be a valid ISO 3166 country code. For example, the code US refers to the United States of America. </p>
    pub country: std::option::Option<std::string::String>,
    /// <p>The state or subdivision of the locale. A valid ISO 3166-2 subdivision code. For example, the code WA refers to the state of Washington.</p>
    pub subdivision: std::option::Option<std::string::String>,
}
impl Locale {
    /// <p> The country of the locale. Must be a valid ISO 3166 country code. For example, the code US refers to the United States of America. </p>
    pub fn country(&self) -> std::option::Option<&str> {
        self.country.as_deref()
    }
    /// <p>The state or subdivision of the locale. A valid ISO 3166-2 subdivision code. For example, the code WA refers to the state of Washington.</p>
    pub fn subdivision(&self) -> std::option::Option<&str> {
        self.subdivision.as_deref()
    }
}
impl std::fmt::Debug for Locale {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Locale");
        formatter.field("country", &self.country);
        formatter.field("subdivision", &self.subdivision);
        formatter.finish()
    }
}
/// See [`Locale`](crate::model::Locale)
pub mod locale {
    /// A builder for [`Locale`](crate::model::Locale)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) country: std::option::Option<std::string::String>,
        pub(crate) subdivision: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The country of the locale. Must be a valid ISO 3166 country code. For example, the code US refers to the United States of America. </p>
        pub fn country(mut self, input: impl Into<std::string::String>) -> Self {
            self.country = Some(input.into());
            self
        }
        /// <p> The country of the locale. Must be a valid ISO 3166 country code. For example, the code US refers to the United States of America. </p>
        pub fn set_country(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.country = input;
            self
        }
        /// <p>The state or subdivision of the locale. A valid ISO 3166-2 subdivision code. For example, the code WA refers to the state of Washington.</p>
        pub fn subdivision(mut self, input: impl Into<std::string::String>) -> Self {
            self.subdivision = Some(input.into());
            self
        }
        /// <p>The state or subdivision of the locale. A valid ISO 3166-2 subdivision code. For example, the code WA refers to the state of Washington.</p>
        pub fn set_subdivision(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subdivision = input;
            self
        }
        /// Consumes the builder and constructs a [`Locale`](crate::model::Locale)
        pub fn build(self) -> crate::model::Locale {
            crate::model::Locale {
                country: self.country,
                subdivision: self.subdivision,
            }
        }
    }
}
impl Locale {
    /// Creates a new builder-style object to manufacture [`Locale`](crate::model::Locale)
    pub fn builder() -> crate::model::locale::Builder {
        crate::model::locale::Builder::default()
    }
}

/// <p> The WorkerBlock data structure represents a Worker who has been blocked. It has two elements: the WorkerId and the Reason for the block. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkerBlock {
    /// <p> The ID of the Worker who accepted the HIT.</p>
    pub worker_id: std::option::Option<std::string::String>,
    /// <p> A message explaining the reason the Worker was blocked. </p>
    pub reason: std::option::Option<std::string::String>,
}
impl WorkerBlock {
    /// <p> The ID of the Worker who accepted the HIT.</p>
    pub fn worker_id(&self) -> std::option::Option<&str> {
        self.worker_id.as_deref()
    }
    /// <p> A message explaining the reason the Worker was blocked. </p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for WorkerBlock {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkerBlock");
        formatter.field("worker_id", &self.worker_id);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`WorkerBlock`](crate::model::WorkerBlock)
pub mod worker_block {
    /// A builder for [`WorkerBlock`](crate::model::WorkerBlock)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) worker_id: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ID of the Worker who accepted the HIT.</p>
        pub fn worker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_id = Some(input.into());
            self
        }
        /// <p> The ID of the Worker who accepted the HIT.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.worker_id = input;
            self
        }
        /// <p> A message explaining the reason the Worker was blocked. </p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p> A message explaining the reason the Worker was blocked. </p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkerBlock`](crate::model::WorkerBlock)
        pub fn build(self) -> crate::model::WorkerBlock {
            crate::model::WorkerBlock {
                worker_id: self.worker_id,
                reason: self.reason,
            }
        }
    }
}
impl WorkerBlock {
    /// Creates a new builder-style object to manufacture [`WorkerBlock`](crate::model::WorkerBlock)
    pub fn builder() -> crate::model::worker_block::Builder {
        crate::model::worker_block::Builder::default()
    }
}

/// <p> Contains both ReviewResult and ReviewAction elements for a particular HIT. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReviewReport {
    /// <p> A list of ReviewResults objects for each action specified in the Review Policy. </p>
    pub review_results: std::option::Option<std::vec::Vec<crate::model::ReviewResultDetail>>,
    /// <p> A list of ReviewAction objects for each action specified in the Review Policy. </p>
    pub review_actions: std::option::Option<std::vec::Vec<crate::model::ReviewActionDetail>>,
}
impl ReviewReport {
    /// <p> A list of ReviewResults objects for each action specified in the Review Policy. </p>
    pub fn review_results(&self) -> std::option::Option<&[crate::model::ReviewResultDetail]> {
        self.review_results.as_deref()
    }
    /// <p> A list of ReviewAction objects for each action specified in the Review Policy. </p>
    pub fn review_actions(&self) -> std::option::Option<&[crate::model::ReviewActionDetail]> {
        self.review_actions.as_deref()
    }
}
impl std::fmt::Debug for ReviewReport {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReviewReport");
        formatter.field("review_results", &self.review_results);
        formatter.field("review_actions", &self.review_actions);
        formatter.finish()
    }
}
/// See [`ReviewReport`](crate::model::ReviewReport)
pub mod review_report {
    /// A builder for [`ReviewReport`](crate::model::ReviewReport)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) review_results:
            std::option::Option<std::vec::Vec<crate::model::ReviewResultDetail>>,
        pub(crate) review_actions:
            std::option::Option<std::vec::Vec<crate::model::ReviewActionDetail>>,
    }
    impl Builder {
        /// Appends an item to `review_results`.
        ///
        /// To override the contents of this collection use [`set_review_results`](Self::set_review_results).
        ///
        /// <p> A list of ReviewResults objects for each action specified in the Review Policy. </p>
        pub fn review_results(mut self, input: crate::model::ReviewResultDetail) -> Self {
            let mut v = self.review_results.unwrap_or_default();
            v.push(input);
            self.review_results = Some(v);
            self
        }
        /// <p> A list of ReviewResults objects for each action specified in the Review Policy. </p>
        pub fn set_review_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReviewResultDetail>>,
        ) -> Self {
            self.review_results = input;
            self
        }
        /// Appends an item to `review_actions`.
        ///
        /// To override the contents of this collection use [`set_review_actions`](Self::set_review_actions).
        ///
        /// <p> A list of ReviewAction objects for each action specified in the Review Policy. </p>
        pub fn review_actions(mut self, input: crate::model::ReviewActionDetail) -> Self {
            let mut v = self.review_actions.unwrap_or_default();
            v.push(input);
            self.review_actions = Some(v);
            self
        }
        /// <p> A list of ReviewAction objects for each action specified in the Review Policy. </p>
        pub fn set_review_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReviewActionDetail>>,
        ) -> Self {
            self.review_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`ReviewReport`](crate::model::ReviewReport)
        pub fn build(self) -> crate::model::ReviewReport {
            crate::model::ReviewReport {
                review_results: self.review_results,
                review_actions: self.review_actions,
            }
        }
    }
}
impl ReviewReport {
    /// Creates a new builder-style object to manufacture [`ReviewReport`](crate::model::ReviewReport)
    pub fn builder() -> crate::model::review_report::Builder {
        crate::model::review_report::Builder::default()
    }
}

/// <p> Both the AssignmentReviewReport and the HITReviewReport elements contains the ReviewActionDetail data structure. This structure is returned multiple times for each action specified in the Review Policy. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReviewActionDetail {
    /// <p>The unique identifier for the action.</p>
    pub action_id: std::option::Option<std::string::String>,
    /// <p> The nature of the action itself. The Review Policy is responsible for examining the HIT and Assignments, emitting results, and deciding which other actions will be necessary. </p>
    pub action_name: std::option::Option<std::string::String>,
    /// <p> The specific HITId or AssignmentID targeted by the action.</p>
    pub target_id: std::option::Option<std::string::String>,
    /// <p> The type of object in TargetId.</p>
    pub target_type: std::option::Option<std::string::String>,
    /// <p> The current disposition of the action: INTENDED, SUCCEEDED, FAILED, or CANCELLED. </p>
    pub status: std::option::Option<crate::model::ReviewActionStatus>,
    /// <p> The date when the action was completed.</p>
    pub complete_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> A description of the outcome of the review.</p>
    pub result: std::option::Option<std::string::String>,
    /// <p> Present only when the Results have a FAILED Status.</p>
    pub error_code: std::option::Option<std::string::String>,
}
impl ReviewActionDetail {
    /// <p>The unique identifier for the action.</p>
    pub fn action_id(&self) -> std::option::Option<&str> {
        self.action_id.as_deref()
    }
    /// <p> The nature of the action itself. The Review Policy is responsible for examining the HIT and Assignments, emitting results, and deciding which other actions will be necessary. </p>
    pub fn action_name(&self) -> std::option::Option<&str> {
        self.action_name.as_deref()
    }
    /// <p> The specific HITId or AssignmentID targeted by the action.</p>
    pub fn target_id(&self) -> std::option::Option<&str> {
        self.target_id.as_deref()
    }
    /// <p> The type of object in TargetId.</p>
    pub fn target_type(&self) -> std::option::Option<&str> {
        self.target_type.as_deref()
    }
    /// <p> The current disposition of the action: INTENDED, SUCCEEDED, FAILED, or CANCELLED. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::ReviewActionStatus> {
        self.status.as_ref()
    }
    /// <p> The date when the action was completed.</p>
    pub fn complete_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.complete_time.as_ref()
    }
    /// <p> A description of the outcome of the review.</p>
    pub fn result(&self) -> std::option::Option<&str> {
        self.result.as_deref()
    }
    /// <p> Present only when the Results have a FAILED Status.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for ReviewActionDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReviewActionDetail");
        formatter.field("action_id", &self.action_id);
        formatter.field("action_name", &self.action_name);
        formatter.field("target_id", &self.target_id);
        formatter.field("target_type", &self.target_type);
        formatter.field("status", &self.status);
        formatter.field("complete_time", &self.complete_time);
        formatter.field("result", &self.result);
        formatter.field("error_code", &self.error_code);
        formatter.finish()
    }
}
/// See [`ReviewActionDetail`](crate::model::ReviewActionDetail)
pub mod review_action_detail {
    /// A builder for [`ReviewActionDetail`](crate::model::ReviewActionDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_id: std::option::Option<std::string::String>,
        pub(crate) action_name: std::option::Option<std::string::String>,
        pub(crate) target_id: std::option::Option<std::string::String>,
        pub(crate) target_type: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ReviewActionStatus>,
        pub(crate) complete_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) result: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the action.</p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the action.</p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// <p> The nature of the action itself. The Review Policy is responsible for examining the HIT and Assignments, emitting results, and deciding which other actions will be necessary. </p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p> The nature of the action itself. The Review Policy is responsible for examining the HIT and Assignments, emitting results, and deciding which other actions will be necessary. </p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// <p> The specific HITId or AssignmentID targeted by the action.</p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p> The specific HITId or AssignmentID targeted by the action.</p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// <p> The type of object in TargetId.</p>
        pub fn target_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_type = Some(input.into());
            self
        }
        /// <p> The type of object in TargetId.</p>
        pub fn set_target_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_type = input;
            self
        }
        /// <p> The current disposition of the action: INTENDED, SUCCEEDED, FAILED, or CANCELLED. </p>
        pub fn status(mut self, input: crate::model::ReviewActionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The current disposition of the action: INTENDED, SUCCEEDED, FAILED, or CANCELLED. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ReviewActionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The date when the action was completed.</p>
        pub fn complete_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.complete_time = Some(input);
            self
        }
        /// <p> The date when the action was completed.</p>
        pub fn set_complete_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.complete_time = input;
            self
        }
        /// <p> A description of the outcome of the review.</p>
        pub fn result(mut self, input: impl Into<std::string::String>) -> Self {
            self.result = Some(input.into());
            self
        }
        /// <p> A description of the outcome of the review.</p>
        pub fn set_result(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.result = input;
            self
        }
        /// <p> Present only when the Results have a FAILED Status.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p> Present only when the Results have a FAILED Status.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ReviewActionDetail`](crate::model::ReviewActionDetail)
        pub fn build(self) -> crate::model::ReviewActionDetail {
            crate::model::ReviewActionDetail {
                action_id: self.action_id,
                action_name: self.action_name,
                target_id: self.target_id,
                target_type: self.target_type,
                status: self.status,
                complete_time: self.complete_time,
                result: self.result,
                error_code: self.error_code,
            }
        }
    }
}
impl ReviewActionDetail {
    /// Creates a new builder-style object to manufacture [`ReviewActionDetail`](crate::model::ReviewActionDetail)
    pub fn builder() -> crate::model::review_action_detail::Builder {
        crate::model::review_action_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReviewActionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Intended,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReviewActionStatus {
    fn from(s: &str) -> Self {
        match s {
            "Cancelled" => ReviewActionStatus::Cancelled,
            "Failed" => ReviewActionStatus::Failed,
            "Intended" => ReviewActionStatus::Intended,
            "Succeeded" => ReviewActionStatus::Succeeded,
            other => ReviewActionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReviewActionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReviewActionStatus::from(s))
    }
}
impl ReviewActionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReviewActionStatus::Cancelled => "Cancelled",
            ReviewActionStatus::Failed => "Failed",
            ReviewActionStatus::Intended => "Intended",
            ReviewActionStatus::Succeeded => "Succeeded",
            ReviewActionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Cancelled", "Failed", "Intended", "Succeeded"]
    }
}
impl AsRef<str> for ReviewActionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> This data structure is returned multiple times for each result specified in the Review Policy. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReviewResultDetail {
    /// <p> A unique identifier of the Review action result. </p>
    pub action_id: std::option::Option<std::string::String>,
    /// <p>The HITID or AssignmentId about which this result was taken. Note that HIT-level Review Policies will often emit results about both the HIT itself and its Assignments, while Assignment-level review policies generally only emit results about the Assignment itself. </p>
    pub subject_id: std::option::Option<std::string::String>,
    /// <p> The type of the object from the SubjectId field.</p>
    pub subject_type: std::option::Option<std::string::String>,
    /// <p> Specifies the QuestionId the result is describing. Depending on whether the TargetType is a HIT or Assignment this results could specify multiple values. If TargetType is HIT and QuestionId is absent, then the result describes results of the HIT, including the HIT agreement score. If ObjectType is Assignment and QuestionId is absent, then the result describes the Worker's performance on the HIT. </p>
    pub question_id: std::option::Option<std::string::String>,
    /// <p> Key identifies the particular piece of reviewed information. </p>
    pub key: std::option::Option<std::string::String>,
    /// <p> The values of Key provided by the review policies you have selected. </p>
    pub value: std::option::Option<std::string::String>,
}
impl ReviewResultDetail {
    /// <p> A unique identifier of the Review action result. </p>
    pub fn action_id(&self) -> std::option::Option<&str> {
        self.action_id.as_deref()
    }
    /// <p>The HITID or AssignmentId about which this result was taken. Note that HIT-level Review Policies will often emit results about both the HIT itself and its Assignments, while Assignment-level review policies generally only emit results about the Assignment itself. </p>
    pub fn subject_id(&self) -> std::option::Option<&str> {
        self.subject_id.as_deref()
    }
    /// <p> The type of the object from the SubjectId field.</p>
    pub fn subject_type(&self) -> std::option::Option<&str> {
        self.subject_type.as_deref()
    }
    /// <p> Specifies the QuestionId the result is describing. Depending on whether the TargetType is a HIT or Assignment this results could specify multiple values. If TargetType is HIT and QuestionId is absent, then the result describes results of the HIT, including the HIT agreement score. If ObjectType is Assignment and QuestionId is absent, then the result describes the Worker's performance on the HIT. </p>
    pub fn question_id(&self) -> std::option::Option<&str> {
        self.question_id.as_deref()
    }
    /// <p> Key identifies the particular piece of reviewed information. </p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p> The values of Key provided by the review policies you have selected. </p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for ReviewResultDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReviewResultDetail");
        formatter.field("action_id", &self.action_id);
        formatter.field("subject_id", &self.subject_id);
        formatter.field("subject_type", &self.subject_type);
        formatter.field("question_id", &self.question_id);
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ReviewResultDetail`](crate::model::ReviewResultDetail)
pub mod review_result_detail {
    /// A builder for [`ReviewResultDetail`](crate::model::ReviewResultDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_id: std::option::Option<std::string::String>,
        pub(crate) subject_id: std::option::Option<std::string::String>,
        pub(crate) subject_type: std::option::Option<std::string::String>,
        pub(crate) question_id: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> A unique identifier of the Review action result. </p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p> A unique identifier of the Review action result. </p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// <p>The HITID or AssignmentId about which this result was taken. Note that HIT-level Review Policies will often emit results about both the HIT itself and its Assignments, while Assignment-level review policies generally only emit results about the Assignment itself. </p>
        pub fn subject_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject_id = Some(input.into());
            self
        }
        /// <p>The HITID or AssignmentId about which this result was taken. Note that HIT-level Review Policies will often emit results about both the HIT itself and its Assignments, while Assignment-level review policies generally only emit results about the Assignment itself. </p>
        pub fn set_subject_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject_id = input;
            self
        }
        /// <p> The type of the object from the SubjectId field.</p>
        pub fn subject_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject_type = Some(input.into());
            self
        }
        /// <p> The type of the object from the SubjectId field.</p>
        pub fn set_subject_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject_type = input;
            self
        }
        /// <p> Specifies the QuestionId the result is describing. Depending on whether the TargetType is a HIT or Assignment this results could specify multiple values. If TargetType is HIT and QuestionId is absent, then the result describes results of the HIT, including the HIT agreement score. If ObjectType is Assignment and QuestionId is absent, then the result describes the Worker's performance on the HIT. </p>
        pub fn question_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.question_id = Some(input.into());
            self
        }
        /// <p> Specifies the QuestionId the result is describing. Depending on whether the TargetType is a HIT or Assignment this results could specify multiple values. If TargetType is HIT and QuestionId is absent, then the result describes results of the HIT, including the HIT agreement score. If ObjectType is Assignment and QuestionId is absent, then the result describes the Worker's performance on the HIT. </p>
        pub fn set_question_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.question_id = input;
            self
        }
        /// <p> Key identifies the particular piece of reviewed information. </p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p> Key identifies the particular piece of reviewed information. </p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p> The values of Key provided by the review policies you have selected. </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p> The values of Key provided by the review policies you have selected. </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ReviewResultDetail`](crate::model::ReviewResultDetail)
        pub fn build(self) -> crate::model::ReviewResultDetail {
            crate::model::ReviewResultDetail {
                action_id: self.action_id,
                subject_id: self.subject_id,
                subject_type: self.subject_type,
                question_id: self.question_id,
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl ReviewResultDetail {
    /// Creates a new builder-style object to manufacture [`ReviewResultDetail`](crate::model::ReviewResultDetail)
    pub fn builder() -> crate::model::review_result_detail::Builder {
        crate::model::review_result_detail::Builder::default()
    }
}

/// <p> HIT Review Policy data structures represent HIT review policies, which you specify when you create a HIT. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReviewPolicy {
    /// <p> Name of a Review Policy: SimplePlurality/2011-09-01 or ScoreMyKnownAnswers/2011-09-01 </p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>Name of the parameter from the Review policy.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::PolicyParameter>>,
}
impl ReviewPolicy {
    /// <p> Name of a Review Policy: SimplePlurality/2011-09-01 or ScoreMyKnownAnswers/2011-09-01 </p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>Name of the parameter from the Review policy.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::PolicyParameter]> {
        self.parameters.as_deref()
    }
}
impl std::fmt::Debug for ReviewPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReviewPolicy");
        formatter.field("policy_name", &self.policy_name);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`ReviewPolicy`](crate::model::ReviewPolicy)
pub mod review_policy {
    /// A builder for [`ReviewPolicy`](crate::model::ReviewPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::PolicyParameter>>,
    }
    impl Builder {
        /// <p> Name of a Review Policy: SimplePlurality/2011-09-01 or ScoreMyKnownAnswers/2011-09-01 </p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p> Name of a Review Policy: SimplePlurality/2011-09-01 or ScoreMyKnownAnswers/2011-09-01 </p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Name of the parameter from the Review policy.</p>
        pub fn parameters(mut self, input: crate::model::PolicyParameter) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input);
            self.parameters = Some(v);
            self
        }
        /// <p>Name of the parameter from the Review policy.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyParameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ReviewPolicy`](crate::model::ReviewPolicy)
        pub fn build(self) -> crate::model::ReviewPolicy {
            crate::model::ReviewPolicy {
                policy_name: self.policy_name,
                parameters: self.parameters,
            }
        }
    }
}
impl ReviewPolicy {
    /// Creates a new builder-style object to manufacture [`ReviewPolicy`](crate::model::ReviewPolicy)
    pub fn builder() -> crate::model::review_policy::Builder {
        crate::model::review_policy::Builder::default()
    }
}

/// <p> Name of the parameter from the Review policy. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyParameter {
    /// <p> Name of the parameter from the list of Review Polices. </p>
    pub key: std::option::Option<std::string::String>,
    /// <p> The list of values of the Parameter</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> List of ParameterMapEntry objects. </p>
    pub map_entries: std::option::Option<std::vec::Vec<crate::model::ParameterMapEntry>>,
}
impl PolicyParameter {
    /// <p> Name of the parameter from the list of Review Polices. </p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p> The list of values of the Parameter</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
    /// <p> List of ParameterMapEntry objects. </p>
    pub fn map_entries(&self) -> std::option::Option<&[crate::model::ParameterMapEntry]> {
        self.map_entries.as_deref()
    }
}
impl std::fmt::Debug for PolicyParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyParameter");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.field("map_entries", &self.map_entries);
        formatter.finish()
    }
}
/// See [`PolicyParameter`](crate::model::PolicyParameter)
pub mod policy_parameter {
    /// A builder for [`PolicyParameter`](crate::model::PolicyParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) map_entries: std::option::Option<std::vec::Vec<crate::model::ParameterMapEntry>>,
    }
    impl Builder {
        /// <p> Name of the parameter from the list of Review Polices. </p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p> Name of the parameter from the list of Review Polices. </p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p> The list of values of the Parameter</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p> The list of values of the Parameter</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Appends an item to `map_entries`.
        ///
        /// To override the contents of this collection use [`set_map_entries`](Self::set_map_entries).
        ///
        /// <p> List of ParameterMapEntry objects. </p>
        pub fn map_entries(mut self, input: crate::model::ParameterMapEntry) -> Self {
            let mut v = self.map_entries.unwrap_or_default();
            v.push(input);
            self.map_entries = Some(v);
            self
        }
        /// <p> List of ParameterMapEntry objects. </p>
        pub fn set_map_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterMapEntry>>,
        ) -> Self {
            self.map_entries = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyParameter`](crate::model::PolicyParameter)
        pub fn build(self) -> crate::model::PolicyParameter {
            crate::model::PolicyParameter {
                key: self.key,
                values: self.values,
                map_entries: self.map_entries,
            }
        }
    }
}
impl PolicyParameter {
    /// Creates a new builder-style object to manufacture [`PolicyParameter`](crate::model::PolicyParameter)
    pub fn builder() -> crate::model::policy_parameter::Builder {
        crate::model::policy_parameter::Builder::default()
    }
}

/// <p> This data structure is the data type for the AnswerKey parameter of the ScoreMyKnownAnswers/2011-09-01 Review Policy. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterMapEntry {
    /// <p> The QuestionID from the HIT that is used to identify which question requires Mechanical Turk to score as part of the ScoreMyKnownAnswers/2011-09-01 Review Policy. </p>
    pub key: std::option::Option<std::string::String>,
    /// <p> The list of answers to the question specified in the MapEntry Key element. The Worker must match all values in order for the answer to be scored correctly. </p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ParameterMapEntry {
    /// <p> The QuestionID from the HIT that is used to identify which question requires Mechanical Turk to score as part of the ScoreMyKnownAnswers/2011-09-01 Review Policy. </p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p> The list of answers to the question specified in the MapEntry Key element. The Worker must match all values in order for the answer to be scored correctly. </p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for ParameterMapEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterMapEntry");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`ParameterMapEntry`](crate::model::ParameterMapEntry)
pub mod parameter_map_entry {
    /// A builder for [`ParameterMapEntry`](crate::model::ParameterMapEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The QuestionID from the HIT that is used to identify which question requires Mechanical Turk to score as part of the ScoreMyKnownAnswers/2011-09-01 Review Policy. </p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p> The QuestionID from the HIT that is used to identify which question requires Mechanical Turk to score as part of the ScoreMyKnownAnswers/2011-09-01 Review Policy. </p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p> The list of answers to the question specified in the MapEntry Key element. The Worker must match all values in order for the answer to be scored correctly. </p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p> The list of answers to the question specified in the MapEntry Key element. The Worker must match all values in order for the answer to be scored correctly. </p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterMapEntry`](crate::model::ParameterMapEntry)
        pub fn build(self) -> crate::model::ParameterMapEntry {
            crate::model::ParameterMapEntry {
                key: self.key,
                values: self.values,
            }
        }
    }
}
impl ParameterMapEntry {
    /// Creates a new builder-style object to manufacture [`ParameterMapEntry`](crate::model::ParameterMapEntry)
    pub fn builder() -> crate::model::parameter_map_entry::Builder {
        crate::model::parameter_map_entry::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReviewPolicyLevel {
    #[allow(missing_docs)] // documentation missing in model
    Assignment,
    #[allow(missing_docs)] // documentation missing in model
    Hit,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReviewPolicyLevel {
    fn from(s: &str) -> Self {
        match s {
            "Assignment" => ReviewPolicyLevel::Assignment,
            "HIT" => ReviewPolicyLevel::Hit,
            other => ReviewPolicyLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReviewPolicyLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReviewPolicyLevel::from(s))
    }
}
impl ReviewPolicyLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReviewPolicyLevel::Assignment => "Assignment",
            ReviewPolicyLevel::Hit => "HIT",
            ReviewPolicyLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Assignment", "HIT"]
    }
}
impl AsRef<str> for ReviewPolicyLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The HIT data structure represents a single HIT, including all the information necessary for a Worker to accept and complete the HIT.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Hit {
    /// <p> A unique identifier for the HIT.</p>
    pub hit_id: std::option::Option<std::string::String>,
    /// <p>The ID of the HIT type of this HIT</p>
    pub hit_type_id: std::option::Option<std::string::String>,
    /// <p> The ID of the HIT Group of this HIT.</p>
    pub hit_group_id: std::option::Option<std::string::String>,
    /// <p> The ID of the HIT Layout of this HIT.</p>
    pub hit_layout_id: std::option::Option<std::string::String>,
    /// <p> The date and time the HIT was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The title of the HIT.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p> A general description of the HIT.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The data the Worker completing the HIT uses produce the results. This is either either a QuestionForm, HTMLQuestion or an ExternalQuestion data structure.</p>
    pub question: std::option::Option<std::string::String>,
    /// <p> One or more words or phrases that describe the HIT, separated by commas. Search terms similar to the keywords of a HIT are more likely to have the HIT in the search results.</p>
    pub keywords: std::option::Option<std::string::String>,
    /// <p>The status of the HIT and its assignments. Valid Values are Assignable | Unassignable | Reviewable | Reviewing | Disposed. </p>
    pub hit_status: std::option::Option<crate::model::HitStatus>,
    /// <p>The number of times the HIT can be accepted and completed before the HIT becomes unavailable. </p>
    pub max_assignments: std::option::Option<i32>,
    /// <p>A string representing a currency amount.</p>
    pub reward: std::option::Option<std::string::String>,
    /// <p>The amount of time, in seconds, after the Worker submits an assignment for the HIT that the results are automatically approved by Amazon Mechanical Turk. This is the amount of time the Requester has to reject an assignment submitted by a Worker before the assignment is auto-approved and the Worker is paid. </p>
    pub auto_approval_delay_in_seconds: std::option::Option<i64>,
    /// <p>The date and time the HIT expires.</p>
    pub expiration: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The length of time, in seconds, that a Worker has to complete the HIT after accepting it.</p>
    pub assignment_duration_in_seconds: std::option::Option<i64>,
    /// <p> An arbitrary data field the Requester who created the HIT can use. This field is visible only to the creator of the HIT.</p>
    pub requester_annotation: std::option::Option<std::string::String>,
    /// <p> Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT. Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each <code>QualificationRequirement</code> structure. </p>
    pub qualification_requirements:
        std::option::Option<std::vec::Vec<crate::model::QualificationRequirement>>,
    /// <p> Indicates the review status of the HIT. Valid Values are NotReviewed | MarkedForReview | ReviewedAppropriate | ReviewedInappropriate.</p>
    pub hit_review_status: std::option::Option<crate::model::HitReviewStatus>,
    /// <p> The number of assignments for this HIT that are being previewed or have been accepted by Workers, but have not yet been submitted, returned, or abandoned.</p>
    pub number_of_assignments_pending: std::option::Option<i32>,
    /// <p> The number of assignments for this HIT that are available for Workers to accept.</p>
    pub number_of_assignments_available: std::option::Option<i32>,
    /// <p> The number of assignments for this HIT that have been approved or rejected.</p>
    pub number_of_assignments_completed: std::option::Option<i32>,
}
impl Hit {
    /// <p> A unique identifier for the HIT.</p>
    pub fn hit_id(&self) -> std::option::Option<&str> {
        self.hit_id.as_deref()
    }
    /// <p>The ID of the HIT type of this HIT</p>
    pub fn hit_type_id(&self) -> std::option::Option<&str> {
        self.hit_type_id.as_deref()
    }
    /// <p> The ID of the HIT Group of this HIT.</p>
    pub fn hit_group_id(&self) -> std::option::Option<&str> {
        self.hit_group_id.as_deref()
    }
    /// <p> The ID of the HIT Layout of this HIT.</p>
    pub fn hit_layout_id(&self) -> std::option::Option<&str> {
        self.hit_layout_id.as_deref()
    }
    /// <p> The date and time the HIT was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p> The title of the HIT.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p> A general description of the HIT.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The data the Worker completing the HIT uses produce the results. This is either either a QuestionForm, HTMLQuestion or an ExternalQuestion data structure.</p>
    pub fn question(&self) -> std::option::Option<&str> {
        self.question.as_deref()
    }
    /// <p> One or more words or phrases that describe the HIT, separated by commas. Search terms similar to the keywords of a HIT are more likely to have the HIT in the search results.</p>
    pub fn keywords(&self) -> std::option::Option<&str> {
        self.keywords.as_deref()
    }
    /// <p>The status of the HIT and its assignments. Valid Values are Assignable | Unassignable | Reviewable | Reviewing | Disposed. </p>
    pub fn hit_status(&self) -> std::option::Option<&crate::model::HitStatus> {
        self.hit_status.as_ref()
    }
    /// <p>The number of times the HIT can be accepted and completed before the HIT becomes unavailable. </p>
    pub fn max_assignments(&self) -> std::option::Option<i32> {
        self.max_assignments
    }
    /// <p>A string representing a currency amount.</p>
    pub fn reward(&self) -> std::option::Option<&str> {
        self.reward.as_deref()
    }
    /// <p>The amount of time, in seconds, after the Worker submits an assignment for the HIT that the results are automatically approved by Amazon Mechanical Turk. This is the amount of time the Requester has to reject an assignment submitted by a Worker before the assignment is auto-approved and the Worker is paid. </p>
    pub fn auto_approval_delay_in_seconds(&self) -> std::option::Option<i64> {
        self.auto_approval_delay_in_seconds
    }
    /// <p>The date and time the HIT expires.</p>
    pub fn expiration(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expiration.as_ref()
    }
    /// <p> The length of time, in seconds, that a Worker has to complete the HIT after accepting it.</p>
    pub fn assignment_duration_in_seconds(&self) -> std::option::Option<i64> {
        self.assignment_duration_in_seconds
    }
    /// <p> An arbitrary data field the Requester who created the HIT can use. This field is visible only to the creator of the HIT.</p>
    pub fn requester_annotation(&self) -> std::option::Option<&str> {
        self.requester_annotation.as_deref()
    }
    /// <p> Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT. Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each <code>QualificationRequirement</code> structure. </p>
    pub fn qualification_requirements(
        &self,
    ) -> std::option::Option<&[crate::model::QualificationRequirement]> {
        self.qualification_requirements.as_deref()
    }
    /// <p> Indicates the review status of the HIT. Valid Values are NotReviewed | MarkedForReview | ReviewedAppropriate | ReviewedInappropriate.</p>
    pub fn hit_review_status(&self) -> std::option::Option<&crate::model::HitReviewStatus> {
        self.hit_review_status.as_ref()
    }
    /// <p> The number of assignments for this HIT that are being previewed or have been accepted by Workers, but have not yet been submitted, returned, or abandoned.</p>
    pub fn number_of_assignments_pending(&self) -> std::option::Option<i32> {
        self.number_of_assignments_pending
    }
    /// <p> The number of assignments for this HIT that are available for Workers to accept.</p>
    pub fn number_of_assignments_available(&self) -> std::option::Option<i32> {
        self.number_of_assignments_available
    }
    /// <p> The number of assignments for this HIT that have been approved or rejected.</p>
    pub fn number_of_assignments_completed(&self) -> std::option::Option<i32> {
        self.number_of_assignments_completed
    }
}
impl std::fmt::Debug for Hit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Hit");
        formatter.field("hit_id", &self.hit_id);
        formatter.field("hit_type_id", &self.hit_type_id);
        formatter.field("hit_group_id", &self.hit_group_id);
        formatter.field("hit_layout_id", &self.hit_layout_id);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("title", &self.title);
        formatter.field("description", &self.description);
        formatter.field("question", &self.question);
        formatter.field("keywords", &self.keywords);
        formatter.field("hit_status", &self.hit_status);
        formatter.field("max_assignments", &self.max_assignments);
        formatter.field("reward", &self.reward);
        formatter.field(
            "auto_approval_delay_in_seconds",
            &self.auto_approval_delay_in_seconds,
        );
        formatter.field("expiration", &self.expiration);
        formatter.field(
            "assignment_duration_in_seconds",
            &self.assignment_duration_in_seconds,
        );
        formatter.field("requester_annotation", &self.requester_annotation);
        formatter.field(
            "qualification_requirements",
            &self.qualification_requirements,
        );
        formatter.field("hit_review_status", &self.hit_review_status);
        formatter.field(
            "number_of_assignments_pending",
            &self.number_of_assignments_pending,
        );
        formatter.field(
            "number_of_assignments_available",
            &self.number_of_assignments_available,
        );
        formatter.field(
            "number_of_assignments_completed",
            &self.number_of_assignments_completed,
        );
        formatter.finish()
    }
}
/// See [`Hit`](crate::model::Hit)
pub mod hit {
    /// A builder for [`Hit`](crate::model::Hit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hit_id: std::option::Option<std::string::String>,
        pub(crate) hit_type_id: std::option::Option<std::string::String>,
        pub(crate) hit_group_id: std::option::Option<std::string::String>,
        pub(crate) hit_layout_id: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) question: std::option::Option<std::string::String>,
        pub(crate) keywords: std::option::Option<std::string::String>,
        pub(crate) hit_status: std::option::Option<crate::model::HitStatus>,
        pub(crate) max_assignments: std::option::Option<i32>,
        pub(crate) reward: std::option::Option<std::string::String>,
        pub(crate) auto_approval_delay_in_seconds: std::option::Option<i64>,
        pub(crate) expiration: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) assignment_duration_in_seconds: std::option::Option<i64>,
        pub(crate) requester_annotation: std::option::Option<std::string::String>,
        pub(crate) qualification_requirements:
            std::option::Option<std::vec::Vec<crate::model::QualificationRequirement>>,
        pub(crate) hit_review_status: std::option::Option<crate::model::HitReviewStatus>,
        pub(crate) number_of_assignments_pending: std::option::Option<i32>,
        pub(crate) number_of_assignments_available: std::option::Option<i32>,
        pub(crate) number_of_assignments_completed: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> A unique identifier for the HIT.</p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_id = Some(input.into());
            self
        }
        /// <p> A unique identifier for the HIT.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hit_id = input;
            self
        }
        /// <p>The ID of the HIT type of this HIT</p>
        pub fn hit_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the HIT type of this HIT</p>
        pub fn set_hit_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hit_type_id = input;
            self
        }
        /// <p> The ID of the HIT Group of this HIT.</p>
        pub fn hit_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_group_id = Some(input.into());
            self
        }
        /// <p> The ID of the HIT Group of this HIT.</p>
        pub fn set_hit_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hit_group_id = input;
            self
        }
        /// <p> The ID of the HIT Layout of this HIT.</p>
        pub fn hit_layout_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_layout_id = Some(input.into());
            self
        }
        /// <p> The ID of the HIT Layout of this HIT.</p>
        pub fn set_hit_layout_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hit_layout_id = input;
            self
        }
        /// <p> The date and time the HIT was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p> The date and time the HIT was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p> The title of the HIT.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p> The title of the HIT.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p> A general description of the HIT.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> A general description of the HIT.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The data the Worker completing the HIT uses produce the results. This is either either a QuestionForm, HTMLQuestion or an ExternalQuestion data structure.</p>
        pub fn question(mut self, input: impl Into<std::string::String>) -> Self {
            self.question = Some(input.into());
            self
        }
        /// <p> The data the Worker completing the HIT uses produce the results. This is either either a QuestionForm, HTMLQuestion or an ExternalQuestion data structure.</p>
        pub fn set_question(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.question = input;
            self
        }
        /// <p> One or more words or phrases that describe the HIT, separated by commas. Search terms similar to the keywords of a HIT are more likely to have the HIT in the search results.</p>
        pub fn keywords(mut self, input: impl Into<std::string::String>) -> Self {
            self.keywords = Some(input.into());
            self
        }
        /// <p> One or more words or phrases that describe the HIT, separated by commas. Search terms similar to the keywords of a HIT are more likely to have the HIT in the search results.</p>
        pub fn set_keywords(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.keywords = input;
            self
        }
        /// <p>The status of the HIT and its assignments. Valid Values are Assignable | Unassignable | Reviewable | Reviewing | Disposed. </p>
        pub fn hit_status(mut self, input: crate::model::HitStatus) -> Self {
            self.hit_status = Some(input);
            self
        }
        /// <p>The status of the HIT and its assignments. Valid Values are Assignable | Unassignable | Reviewable | Reviewing | Disposed. </p>
        pub fn set_hit_status(
            mut self,
            input: std::option::Option<crate::model::HitStatus>,
        ) -> Self {
            self.hit_status = input;
            self
        }
        /// <p>The number of times the HIT can be accepted and completed before the HIT becomes unavailable. </p>
        pub fn max_assignments(mut self, input: i32) -> Self {
            self.max_assignments = Some(input);
            self
        }
        /// <p>The number of times the HIT can be accepted and completed before the HIT becomes unavailable. </p>
        pub fn set_max_assignments(mut self, input: std::option::Option<i32>) -> Self {
            self.max_assignments = input;
            self
        }
        /// <p>A string representing a currency amount.</p>
        pub fn reward(mut self, input: impl Into<std::string::String>) -> Self {
            self.reward = Some(input.into());
            self
        }
        /// <p>A string representing a currency amount.</p>
        pub fn set_reward(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reward = input;
            self
        }
        /// <p>The amount of time, in seconds, after the Worker submits an assignment for the HIT that the results are automatically approved by Amazon Mechanical Turk. This is the amount of time the Requester has to reject an assignment submitted by a Worker before the assignment is auto-approved and the Worker is paid. </p>
        pub fn auto_approval_delay_in_seconds(mut self, input: i64) -> Self {
            self.auto_approval_delay_in_seconds = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, after the Worker submits an assignment for the HIT that the results are automatically approved by Amazon Mechanical Turk. This is the amount of time the Requester has to reject an assignment submitted by a Worker before the assignment is auto-approved and the Worker is paid. </p>
        pub fn set_auto_approval_delay_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.auto_approval_delay_in_seconds = input;
            self
        }
        /// <p>The date and time the HIT expires.</p>
        pub fn expiration(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expiration = Some(input);
            self
        }
        /// <p>The date and time the HIT expires.</p>
        pub fn set_expiration(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expiration = input;
            self
        }
        /// <p> The length of time, in seconds, that a Worker has to complete the HIT after accepting it.</p>
        pub fn assignment_duration_in_seconds(mut self, input: i64) -> Self {
            self.assignment_duration_in_seconds = Some(input);
            self
        }
        /// <p> The length of time, in seconds, that a Worker has to complete the HIT after accepting it.</p>
        pub fn set_assignment_duration_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.assignment_duration_in_seconds = input;
            self
        }
        /// <p> An arbitrary data field the Requester who created the HIT can use. This field is visible only to the creator of the HIT.</p>
        pub fn requester_annotation(mut self, input: impl Into<std::string::String>) -> Self {
            self.requester_annotation = Some(input.into());
            self
        }
        /// <p> An arbitrary data field the Requester who created the HIT can use. This field is visible only to the creator of the HIT.</p>
        pub fn set_requester_annotation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.requester_annotation = input;
            self
        }
        /// Appends an item to `qualification_requirements`.
        ///
        /// To override the contents of this collection use [`set_qualification_requirements`](Self::set_qualification_requirements).
        ///
        /// <p> Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT. Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each <code>QualificationRequirement</code> structure. </p>
        pub fn qualification_requirements(
            mut self,
            input: crate::model::QualificationRequirement,
        ) -> Self {
            let mut v = self.qualification_requirements.unwrap_or_default();
            v.push(input);
            self.qualification_requirements = Some(v);
            self
        }
        /// <p> Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT. Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each <code>QualificationRequirement</code> structure. </p>
        pub fn set_qualification_requirements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QualificationRequirement>>,
        ) -> Self {
            self.qualification_requirements = input;
            self
        }
        /// <p> Indicates the review status of the HIT. Valid Values are NotReviewed | MarkedForReview | ReviewedAppropriate | ReviewedInappropriate.</p>
        pub fn hit_review_status(mut self, input: crate::model::HitReviewStatus) -> Self {
            self.hit_review_status = Some(input);
            self
        }
        /// <p> Indicates the review status of the HIT. Valid Values are NotReviewed | MarkedForReview | ReviewedAppropriate | ReviewedInappropriate.</p>
        pub fn set_hit_review_status(
            mut self,
            input: std::option::Option<crate::model::HitReviewStatus>,
        ) -> Self {
            self.hit_review_status = input;
            self
        }
        /// <p> The number of assignments for this HIT that are being previewed or have been accepted by Workers, but have not yet been submitted, returned, or abandoned.</p>
        pub fn number_of_assignments_pending(mut self, input: i32) -> Self {
            self.number_of_assignments_pending = Some(input);
            self
        }
        /// <p> The number of assignments for this HIT that are being previewed or have been accepted by Workers, but have not yet been submitted, returned, or abandoned.</p>
        pub fn set_number_of_assignments_pending(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.number_of_assignments_pending = input;
            self
        }
        /// <p> The number of assignments for this HIT that are available for Workers to accept.</p>
        pub fn number_of_assignments_available(mut self, input: i32) -> Self {
            self.number_of_assignments_available = Some(input);
            self
        }
        /// <p> The number of assignments for this HIT that are available for Workers to accept.</p>
        pub fn set_number_of_assignments_available(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.number_of_assignments_available = input;
            self
        }
        /// <p> The number of assignments for this HIT that have been approved or rejected.</p>
        pub fn number_of_assignments_completed(mut self, input: i32) -> Self {
            self.number_of_assignments_completed = Some(input);
            self
        }
        /// <p> The number of assignments for this HIT that have been approved or rejected.</p>
        pub fn set_number_of_assignments_completed(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.number_of_assignments_completed = input;
            self
        }
        /// Consumes the builder and constructs a [`Hit`](crate::model::Hit)
        pub fn build(self) -> crate::model::Hit {
            crate::model::Hit {
                hit_id: self.hit_id,
                hit_type_id: self.hit_type_id,
                hit_group_id: self.hit_group_id,
                hit_layout_id: self.hit_layout_id,
                creation_time: self.creation_time,
                title: self.title,
                description: self.description,
                question: self.question,
                keywords: self.keywords,
                hit_status: self.hit_status,
                max_assignments: self.max_assignments,
                reward: self.reward,
                auto_approval_delay_in_seconds: self.auto_approval_delay_in_seconds,
                expiration: self.expiration,
                assignment_duration_in_seconds: self.assignment_duration_in_seconds,
                requester_annotation: self.requester_annotation,
                qualification_requirements: self.qualification_requirements,
                hit_review_status: self.hit_review_status,
                number_of_assignments_pending: self.number_of_assignments_pending,
                number_of_assignments_available: self.number_of_assignments_available,
                number_of_assignments_completed: self.number_of_assignments_completed,
            }
        }
    }
}
impl Hit {
    /// Creates a new builder-style object to manufacture [`Hit`](crate::model::Hit)
    pub fn builder() -> crate::model::hit::Builder {
        crate::model::hit::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HitReviewStatus {
    #[allow(missing_docs)] // documentation missing in model
    MarkedForReview,
    #[allow(missing_docs)] // documentation missing in model
    NotReviewed,
    #[allow(missing_docs)] // documentation missing in model
    ReviewedAppropriate,
    #[allow(missing_docs)] // documentation missing in model
    ReviewedInappropriate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HitReviewStatus {
    fn from(s: &str) -> Self {
        match s {
            "MarkedForReview" => HitReviewStatus::MarkedForReview,
            "NotReviewed" => HitReviewStatus::NotReviewed,
            "ReviewedAppropriate" => HitReviewStatus::ReviewedAppropriate,
            "ReviewedInappropriate" => HitReviewStatus::ReviewedInappropriate,
            other => HitReviewStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HitReviewStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HitReviewStatus::from(s))
    }
}
impl HitReviewStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HitReviewStatus::MarkedForReview => "MarkedForReview",
            HitReviewStatus::NotReviewed => "NotReviewed",
            HitReviewStatus::ReviewedAppropriate => "ReviewedAppropriate",
            HitReviewStatus::ReviewedInappropriate => "ReviewedInappropriate",
            HitReviewStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "MarkedForReview",
            "NotReviewed",
            "ReviewedAppropriate",
            "ReviewedInappropriate",
        ]
    }
}
impl AsRef<str> for HitReviewStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The QualificationRequirement data structure describes a Qualification that a Worker must have before the Worker is allowed to accept a HIT. A requirement may optionally state that a Worker must have the Qualification in order to preview the HIT, or see the HIT in search results. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QualificationRequirement {
    /// <p> The ID of the Qualification type for the requirement.</p>
    pub qualification_type_id: std::option::Option<std::string::String>,
    /// <p>The kind of comparison to make against a Qualification's value. You can compare a Qualification's value to an IntegerValue to see if it is LessThan, LessThanOrEqualTo, GreaterThan, GreaterThanOrEqualTo, EqualTo, or NotEqualTo the IntegerValue. You can compare it to a LocaleValue to see if it is EqualTo, or NotEqualTo the LocaleValue. You can check to see if the value is In or NotIn a set of IntegerValue or LocaleValue values. Lastly, a Qualification requirement can also test if a Qualification Exists or DoesNotExist in the user's profile, regardless of its value. </p>
    pub comparator: std::option::Option<crate::model::Comparator>,
    /// <p> The integer value to compare against the Qualification's value. IntegerValue must not be present if Comparator is Exists or DoesNotExist. IntegerValue can only be used if the Qualification type has an integer value; it cannot be used with the Worker_Locale QualificationType ID. When performing a set comparison by using the In or the NotIn comparator, you can use up to 15 IntegerValue elements in a QualificationRequirement data structure. </p>
    pub integer_values: std::option::Option<std::vec::Vec<i32>>,
    /// <p> The locale value to compare against the Qualification's value. The local value must be a valid ISO 3166 country code or supports ISO 3166-2 subdivisions. LocaleValue can only be used with a Worker_Locale QualificationType ID. LocaleValue can only be used with the EqualTo, NotEqualTo, In, and NotIn comparators. You must only use a single LocaleValue element when using the EqualTo or NotEqualTo comparators. When performing a set comparison by using the In or the NotIn comparator, you can use up to 30 LocaleValue elements in a QualificationRequirement data structure. </p>
    pub locale_values: std::option::Option<std::vec::Vec<crate::model::Locale>>,
    /// <p> DEPRECATED: Use the <code>ActionsGuarded</code> field instead. If RequiredToPreview is true, the question data for the HIT will not be shown when a Worker whose Qualifications do not meet this requirement tries to preview the HIT. That is, a Worker's Qualifications must meet all of the requirements for which RequiredToPreview is true in order to preview the HIT. If a Worker meets all of the requirements where RequiredToPreview is true (or if there are no such requirements), but does not meet all of the requirements for the HIT, the Worker will be allowed to preview the HIT's question data, but will not be allowed to accept and complete the HIT. The default is false. This should not be used in combination with the <code>ActionsGuarded</code> field. </p>
    pub required_to_preview: std::option::Option<bool>,
    /// <p> Setting this attribute prevents Workers whose Qualifications do not meet this QualificationRequirement from taking the specified action. Valid arguments include "Accept" (Worker cannot accept the HIT, but can preview the HIT and see it in their search results), "PreviewAndAccept" (Worker cannot accept or preview the HIT, but can see the HIT in their search results), and "DiscoverPreviewAndAccept" (Worker cannot accept, preview, or see the HIT in their search results). It's possible for you to create a HIT with multiple QualificationRequirements (which can have different values for the ActionGuarded attribute). In this case, the Worker is only permitted to perform an action when they have met all QualificationRequirements guarding the action. The actions in the order of least restrictive to most restrictive are Discover, Preview and Accept. For example, if a Worker meets all QualificationRequirements that are set to DiscoverPreviewAndAccept, but do not meet all requirements that are set with PreviewAndAccept, then the Worker will be able to Discover, i.e. see the HIT in their search result, but will not be able to Preview or Accept the HIT. ActionsGuarded should not be used in combination with the <code>RequiredToPreview</code> field. </p>
    pub actions_guarded: std::option::Option<crate::model::HitAccessActions>,
}
impl QualificationRequirement {
    /// <p> The ID of the Qualification type for the requirement.</p>
    pub fn qualification_type_id(&self) -> std::option::Option<&str> {
        self.qualification_type_id.as_deref()
    }
    /// <p>The kind of comparison to make against a Qualification's value. You can compare a Qualification's value to an IntegerValue to see if it is LessThan, LessThanOrEqualTo, GreaterThan, GreaterThanOrEqualTo, EqualTo, or NotEqualTo the IntegerValue. You can compare it to a LocaleValue to see if it is EqualTo, or NotEqualTo the LocaleValue. You can check to see if the value is In or NotIn a set of IntegerValue or LocaleValue values. Lastly, a Qualification requirement can also test if a Qualification Exists or DoesNotExist in the user's profile, regardless of its value. </p>
    pub fn comparator(&self) -> std::option::Option<&crate::model::Comparator> {
        self.comparator.as_ref()
    }
    /// <p> The integer value to compare against the Qualification's value. IntegerValue must not be present if Comparator is Exists or DoesNotExist. IntegerValue can only be used if the Qualification type has an integer value; it cannot be used with the Worker_Locale QualificationType ID. When performing a set comparison by using the In or the NotIn comparator, you can use up to 15 IntegerValue elements in a QualificationRequirement data structure. </p>
    pub fn integer_values(&self) -> std::option::Option<&[i32]> {
        self.integer_values.as_deref()
    }
    /// <p> The locale value to compare against the Qualification's value. The local value must be a valid ISO 3166 country code or supports ISO 3166-2 subdivisions. LocaleValue can only be used with a Worker_Locale QualificationType ID. LocaleValue can only be used with the EqualTo, NotEqualTo, In, and NotIn comparators. You must only use a single LocaleValue element when using the EqualTo or NotEqualTo comparators. When performing a set comparison by using the In or the NotIn comparator, you can use up to 30 LocaleValue elements in a QualificationRequirement data structure. </p>
    pub fn locale_values(&self) -> std::option::Option<&[crate::model::Locale]> {
        self.locale_values.as_deref()
    }
    /// <p> DEPRECATED: Use the <code>ActionsGuarded</code> field instead. If RequiredToPreview is true, the question data for the HIT will not be shown when a Worker whose Qualifications do not meet this requirement tries to preview the HIT. That is, a Worker's Qualifications must meet all of the requirements for which RequiredToPreview is true in order to preview the HIT. If a Worker meets all of the requirements where RequiredToPreview is true (or if there are no such requirements), but does not meet all of the requirements for the HIT, the Worker will be allowed to preview the HIT's question data, but will not be allowed to accept and complete the HIT. The default is false. This should not be used in combination with the <code>ActionsGuarded</code> field. </p>
    pub fn required_to_preview(&self) -> std::option::Option<bool> {
        self.required_to_preview
    }
    /// <p> Setting this attribute prevents Workers whose Qualifications do not meet this QualificationRequirement from taking the specified action. Valid arguments include "Accept" (Worker cannot accept the HIT, but can preview the HIT and see it in their search results), "PreviewAndAccept" (Worker cannot accept or preview the HIT, but can see the HIT in their search results), and "DiscoverPreviewAndAccept" (Worker cannot accept, preview, or see the HIT in their search results). It's possible for you to create a HIT with multiple QualificationRequirements (which can have different values for the ActionGuarded attribute). In this case, the Worker is only permitted to perform an action when they have met all QualificationRequirements guarding the action. The actions in the order of least restrictive to most restrictive are Discover, Preview and Accept. For example, if a Worker meets all QualificationRequirements that are set to DiscoverPreviewAndAccept, but do not meet all requirements that are set with PreviewAndAccept, then the Worker will be able to Discover, i.e. see the HIT in their search result, but will not be able to Preview or Accept the HIT. ActionsGuarded should not be used in combination with the <code>RequiredToPreview</code> field. </p>
    pub fn actions_guarded(&self) -> std::option::Option<&crate::model::HitAccessActions> {
        self.actions_guarded.as_ref()
    }
}
impl std::fmt::Debug for QualificationRequirement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QualificationRequirement");
        formatter.field("qualification_type_id", &self.qualification_type_id);
        formatter.field("comparator", &self.comparator);
        formatter.field("integer_values", &self.integer_values);
        formatter.field("locale_values", &self.locale_values);
        formatter.field("required_to_preview", &self.required_to_preview);
        formatter.field("actions_guarded", &self.actions_guarded);
        formatter.finish()
    }
}
/// See [`QualificationRequirement`](crate::model::QualificationRequirement)
pub mod qualification_requirement {
    /// A builder for [`QualificationRequirement`](crate::model::QualificationRequirement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) qualification_type_id: std::option::Option<std::string::String>,
        pub(crate) comparator: std::option::Option<crate::model::Comparator>,
        pub(crate) integer_values: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) locale_values: std::option::Option<std::vec::Vec<crate::model::Locale>>,
        pub(crate) required_to_preview: std::option::Option<bool>,
        pub(crate) actions_guarded: std::option::Option<crate::model::HitAccessActions>,
    }
    impl Builder {
        /// <p> The ID of the Qualification type for the requirement.</p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualification_type_id = Some(input.into());
            self
        }
        /// <p> The ID of the Qualification type for the requirement.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.qualification_type_id = input;
            self
        }
        /// <p>The kind of comparison to make against a Qualification's value. You can compare a Qualification's value to an IntegerValue to see if it is LessThan, LessThanOrEqualTo, GreaterThan, GreaterThanOrEqualTo, EqualTo, or NotEqualTo the IntegerValue. You can compare it to a LocaleValue to see if it is EqualTo, or NotEqualTo the LocaleValue. You can check to see if the value is In or NotIn a set of IntegerValue or LocaleValue values. Lastly, a Qualification requirement can also test if a Qualification Exists or DoesNotExist in the user's profile, regardless of its value. </p>
        pub fn comparator(mut self, input: crate::model::Comparator) -> Self {
            self.comparator = Some(input);
            self
        }
        /// <p>The kind of comparison to make against a Qualification's value. You can compare a Qualification's value to an IntegerValue to see if it is LessThan, LessThanOrEqualTo, GreaterThan, GreaterThanOrEqualTo, EqualTo, or NotEqualTo the IntegerValue. You can compare it to a LocaleValue to see if it is EqualTo, or NotEqualTo the LocaleValue. You can check to see if the value is In or NotIn a set of IntegerValue or LocaleValue values. Lastly, a Qualification requirement can also test if a Qualification Exists or DoesNotExist in the user's profile, regardless of its value. </p>
        pub fn set_comparator(
            mut self,
            input: std::option::Option<crate::model::Comparator>,
        ) -> Self {
            self.comparator = input;
            self
        }
        /// Appends an item to `integer_values`.
        ///
        /// To override the contents of this collection use [`set_integer_values`](Self::set_integer_values).
        ///
        /// <p> The integer value to compare against the Qualification's value. IntegerValue must not be present if Comparator is Exists or DoesNotExist. IntegerValue can only be used if the Qualification type has an integer value; it cannot be used with the Worker_Locale QualificationType ID. When performing a set comparison by using the In or the NotIn comparator, you can use up to 15 IntegerValue elements in a QualificationRequirement data structure. </p>
        pub fn integer_values(mut self, input: i32) -> Self {
            let mut v = self.integer_values.unwrap_or_default();
            v.push(input);
            self.integer_values = Some(v);
            self
        }
        /// <p> The integer value to compare against the Qualification's value. IntegerValue must not be present if Comparator is Exists or DoesNotExist. IntegerValue can only be used if the Qualification type has an integer value; it cannot be used with the Worker_Locale QualificationType ID. When performing a set comparison by using the In or the NotIn comparator, you can use up to 15 IntegerValue elements in a QualificationRequirement data structure. </p>
        pub fn set_integer_values(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.integer_values = input;
            self
        }
        /// Appends an item to `locale_values`.
        ///
        /// To override the contents of this collection use [`set_locale_values`](Self::set_locale_values).
        ///
        /// <p> The locale value to compare against the Qualification's value. The local value must be a valid ISO 3166 country code or supports ISO 3166-2 subdivisions. LocaleValue can only be used with a Worker_Locale QualificationType ID. LocaleValue can only be used with the EqualTo, NotEqualTo, In, and NotIn comparators. You must only use a single LocaleValue element when using the EqualTo or NotEqualTo comparators. When performing a set comparison by using the In or the NotIn comparator, you can use up to 30 LocaleValue elements in a QualificationRequirement data structure. </p>
        pub fn locale_values(mut self, input: crate::model::Locale) -> Self {
            let mut v = self.locale_values.unwrap_or_default();
            v.push(input);
            self.locale_values = Some(v);
            self
        }
        /// <p> The locale value to compare against the Qualification's value. The local value must be a valid ISO 3166 country code or supports ISO 3166-2 subdivisions. LocaleValue can only be used with a Worker_Locale QualificationType ID. LocaleValue can only be used with the EqualTo, NotEqualTo, In, and NotIn comparators. You must only use a single LocaleValue element when using the EqualTo or NotEqualTo comparators. When performing a set comparison by using the In or the NotIn comparator, you can use up to 30 LocaleValue elements in a QualificationRequirement data structure. </p>
        pub fn set_locale_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Locale>>,
        ) -> Self {
            self.locale_values = input;
            self
        }
        /// <p> DEPRECATED: Use the <code>ActionsGuarded</code> field instead. If RequiredToPreview is true, the question data for the HIT will not be shown when a Worker whose Qualifications do not meet this requirement tries to preview the HIT. That is, a Worker's Qualifications must meet all of the requirements for which RequiredToPreview is true in order to preview the HIT. If a Worker meets all of the requirements where RequiredToPreview is true (or if there are no such requirements), but does not meet all of the requirements for the HIT, the Worker will be allowed to preview the HIT's question data, but will not be allowed to accept and complete the HIT. The default is false. This should not be used in combination with the <code>ActionsGuarded</code> field. </p>
        pub fn required_to_preview(mut self, input: bool) -> Self {
            self.required_to_preview = Some(input);
            self
        }
        /// <p> DEPRECATED: Use the <code>ActionsGuarded</code> field instead. If RequiredToPreview is true, the question data for the HIT will not be shown when a Worker whose Qualifications do not meet this requirement tries to preview the HIT. That is, a Worker's Qualifications must meet all of the requirements for which RequiredToPreview is true in order to preview the HIT. If a Worker meets all of the requirements where RequiredToPreview is true (or if there are no such requirements), but does not meet all of the requirements for the HIT, the Worker will be allowed to preview the HIT's question data, but will not be allowed to accept and complete the HIT. The default is false. This should not be used in combination with the <code>ActionsGuarded</code> field. </p>
        pub fn set_required_to_preview(mut self, input: std::option::Option<bool>) -> Self {
            self.required_to_preview = input;
            self
        }
        /// <p> Setting this attribute prevents Workers whose Qualifications do not meet this QualificationRequirement from taking the specified action. Valid arguments include "Accept" (Worker cannot accept the HIT, but can preview the HIT and see it in their search results), "PreviewAndAccept" (Worker cannot accept or preview the HIT, but can see the HIT in their search results), and "DiscoverPreviewAndAccept" (Worker cannot accept, preview, or see the HIT in their search results). It's possible for you to create a HIT with multiple QualificationRequirements (which can have different values for the ActionGuarded attribute). In this case, the Worker is only permitted to perform an action when they have met all QualificationRequirements guarding the action. The actions in the order of least restrictive to most restrictive are Discover, Preview and Accept. For example, if a Worker meets all QualificationRequirements that are set to DiscoverPreviewAndAccept, but do not meet all requirements that are set with PreviewAndAccept, then the Worker will be able to Discover, i.e. see the HIT in their search result, but will not be able to Preview or Accept the HIT. ActionsGuarded should not be used in combination with the <code>RequiredToPreview</code> field. </p>
        pub fn actions_guarded(mut self, input: crate::model::HitAccessActions) -> Self {
            self.actions_guarded = Some(input);
            self
        }
        /// <p> Setting this attribute prevents Workers whose Qualifications do not meet this QualificationRequirement from taking the specified action. Valid arguments include "Accept" (Worker cannot accept the HIT, but can preview the HIT and see it in their search results), "PreviewAndAccept" (Worker cannot accept or preview the HIT, but can see the HIT in their search results), and "DiscoverPreviewAndAccept" (Worker cannot accept, preview, or see the HIT in their search results). It's possible for you to create a HIT with multiple QualificationRequirements (which can have different values for the ActionGuarded attribute). In this case, the Worker is only permitted to perform an action when they have met all QualificationRequirements guarding the action. The actions in the order of least restrictive to most restrictive are Discover, Preview and Accept. For example, if a Worker meets all QualificationRequirements that are set to DiscoverPreviewAndAccept, but do not meet all requirements that are set with PreviewAndAccept, then the Worker will be able to Discover, i.e. see the HIT in their search result, but will not be able to Preview or Accept the HIT. ActionsGuarded should not be used in combination with the <code>RequiredToPreview</code> field. </p>
        pub fn set_actions_guarded(
            mut self,
            input: std::option::Option<crate::model::HitAccessActions>,
        ) -> Self {
            self.actions_guarded = input;
            self
        }
        /// Consumes the builder and constructs a [`QualificationRequirement`](crate::model::QualificationRequirement)
        pub fn build(self) -> crate::model::QualificationRequirement {
            crate::model::QualificationRequirement {
                qualification_type_id: self.qualification_type_id,
                comparator: self.comparator,
                integer_values: self.integer_values,
                locale_values: self.locale_values,
                required_to_preview: self.required_to_preview,
                actions_guarded: self.actions_guarded,
            }
        }
    }
}
impl QualificationRequirement {
    /// Creates a new builder-style object to manufacture [`QualificationRequirement`](crate::model::QualificationRequirement)
    pub fn builder() -> crate::model::qualification_requirement::Builder {
        crate::model::qualification_requirement::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HitAccessActions {
    #[allow(missing_docs)] // documentation missing in model
    Accept,
    #[allow(missing_docs)] // documentation missing in model
    DiscoverPreviewAndAccept,
    #[allow(missing_docs)] // documentation missing in model
    PreviewAndAccept,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HitAccessActions {
    fn from(s: &str) -> Self {
        match s {
            "Accept" => HitAccessActions::Accept,
            "DiscoverPreviewAndAccept" => HitAccessActions::DiscoverPreviewAndAccept,
            "PreviewAndAccept" => HitAccessActions::PreviewAndAccept,
            other => HitAccessActions::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HitAccessActions {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HitAccessActions::from(s))
    }
}
impl HitAccessActions {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HitAccessActions::Accept => "Accept",
            HitAccessActions::DiscoverPreviewAndAccept => "DiscoverPreviewAndAccept",
            HitAccessActions::PreviewAndAccept => "PreviewAndAccept",
            HitAccessActions::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Accept", "DiscoverPreviewAndAccept", "PreviewAndAccept"]
    }
}
impl AsRef<str> for HitAccessActions {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Comparator {
    #[allow(missing_docs)] // documentation missing in model
    DoesNotExist,
    #[allow(missing_docs)] // documentation missing in model
    EqualTo,
    #[allow(missing_docs)] // documentation missing in model
    Exists,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    In,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    NotEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    NotIn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Comparator {
    fn from(s: &str) -> Self {
        match s {
            "DoesNotExist" => Comparator::DoesNotExist,
            "EqualTo" => Comparator::EqualTo,
            "Exists" => Comparator::Exists,
            "GreaterThan" => Comparator::GreaterThan,
            "GreaterThanOrEqualTo" => Comparator::GreaterThanOrEqualTo,
            "In" => Comparator::In,
            "LessThan" => Comparator::LessThan,
            "LessThanOrEqualTo" => Comparator::LessThanOrEqualTo,
            "NotEqualTo" => Comparator::NotEqualTo,
            "NotIn" => Comparator::NotIn,
            other => Comparator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Comparator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Comparator::from(s))
    }
}
impl Comparator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Comparator::DoesNotExist => "DoesNotExist",
            Comparator::EqualTo => "EqualTo",
            Comparator::Exists => "Exists",
            Comparator::GreaterThan => "GreaterThan",
            Comparator::GreaterThanOrEqualTo => "GreaterThanOrEqualTo",
            Comparator::In => "In",
            Comparator::LessThan => "LessThan",
            Comparator::LessThanOrEqualTo => "LessThanOrEqualTo",
            Comparator::NotEqualTo => "NotEqualTo",
            Comparator::NotIn => "NotIn",
            Comparator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DoesNotExist",
            "EqualTo",
            "Exists",
            "GreaterThan",
            "GreaterThanOrEqualTo",
            "In",
            "LessThan",
            "LessThanOrEqualTo",
            "NotEqualTo",
            "NotIn",
        ]
    }
}
impl AsRef<str> for Comparator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HitStatus {
    #[allow(missing_docs)] // documentation missing in model
    Assignable,
    #[allow(missing_docs)] // documentation missing in model
    Disposed,
    #[allow(missing_docs)] // documentation missing in model
    Reviewable,
    #[allow(missing_docs)] // documentation missing in model
    Reviewing,
    #[allow(missing_docs)] // documentation missing in model
    Unassignable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HitStatus {
    fn from(s: &str) -> Self {
        match s {
            "Assignable" => HitStatus::Assignable,
            "Disposed" => HitStatus::Disposed,
            "Reviewable" => HitStatus::Reviewable,
            "Reviewing" => HitStatus::Reviewing,
            "Unassignable" => HitStatus::Unassignable,
            other => HitStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HitStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HitStatus::from(s))
    }
}
impl HitStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HitStatus::Assignable => "Assignable",
            HitStatus::Disposed => "Disposed",
            HitStatus::Reviewable => "Reviewable",
            HitStatus::Reviewing => "Reviewing",
            HitStatus::Unassignable => "Unassignable",
            HitStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Assignable",
            "Disposed",
            "Reviewable",
            "Reviewing",
            "Unassignable",
        ]
    }
}
impl AsRef<str> for HitStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReviewableHitStatus {
    #[allow(missing_docs)] // documentation missing in model
    Reviewable,
    #[allow(missing_docs)] // documentation missing in model
    Reviewing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReviewableHitStatus {
    fn from(s: &str) -> Self {
        match s {
            "Reviewable" => ReviewableHitStatus::Reviewable,
            "Reviewing" => ReviewableHitStatus::Reviewing,
            other => ReviewableHitStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReviewableHitStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReviewableHitStatus::from(s))
    }
}
impl ReviewableHitStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReviewableHitStatus::Reviewable => "Reviewable",
            ReviewableHitStatus::Reviewing => "Reviewing",
            ReviewableHitStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Reviewable", "Reviewing"]
    }
}
impl AsRef<str> for ReviewableHitStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The QualificationRequest data structure represents a request a Worker has made for a Qualification. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QualificationRequest {
    /// <p>The ID of the Qualification request, a unique identifier generated when the request was submitted. </p>
    pub qualification_request_id: std::option::Option<std::string::String>,
    /// <p> The ID of the Qualification type the Worker is requesting, as returned by the CreateQualificationType operation. </p>
    pub qualification_type_id: std::option::Option<std::string::String>,
    /// <p> The ID of the Worker requesting the Qualification.</p>
    pub worker_id: std::option::Option<std::string::String>,
    /// <p> The contents of the Qualification test that was presented to the Worker, if the type has a test and the Worker has submitted answers. This value is identical to the QuestionForm associated with the Qualification type at the time the Worker requests the Qualification.</p>
    pub test: std::option::Option<std::string::String>,
    /// <p> The Worker's answers for the Qualification type's test contained in a QuestionFormAnswers document, if the type has a test and the Worker has submitted answers. If the Worker does not provide any answers, Answer may be empty. </p>
    pub answer: std::option::Option<std::string::String>,
    /// <p>The date and time the Qualification request had a status of Submitted. This is either the time the Worker submitted answers for a Qualification test, or the time the Worker requested the Qualification if the Qualification type does not have a test. </p>
    pub submit_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl QualificationRequest {
    /// <p>The ID of the Qualification request, a unique identifier generated when the request was submitted. </p>
    pub fn qualification_request_id(&self) -> std::option::Option<&str> {
        self.qualification_request_id.as_deref()
    }
    /// <p> The ID of the Qualification type the Worker is requesting, as returned by the CreateQualificationType operation. </p>
    pub fn qualification_type_id(&self) -> std::option::Option<&str> {
        self.qualification_type_id.as_deref()
    }
    /// <p> The ID of the Worker requesting the Qualification.</p>
    pub fn worker_id(&self) -> std::option::Option<&str> {
        self.worker_id.as_deref()
    }
    /// <p> The contents of the Qualification test that was presented to the Worker, if the type has a test and the Worker has submitted answers. This value is identical to the QuestionForm associated with the Qualification type at the time the Worker requests the Qualification.</p>
    pub fn test(&self) -> std::option::Option<&str> {
        self.test.as_deref()
    }
    /// <p> The Worker's answers for the Qualification type's test contained in a QuestionFormAnswers document, if the type has a test and the Worker has submitted answers. If the Worker does not provide any answers, Answer may be empty. </p>
    pub fn answer(&self) -> std::option::Option<&str> {
        self.answer.as_deref()
    }
    /// <p>The date and time the Qualification request had a status of Submitted. This is either the time the Worker submitted answers for a Qualification test, or the time the Worker requested the Qualification if the Qualification type does not have a test. </p>
    pub fn submit_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.submit_time.as_ref()
    }
}
impl std::fmt::Debug for QualificationRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QualificationRequest");
        formatter.field("qualification_request_id", &self.qualification_request_id);
        formatter.field("qualification_type_id", &self.qualification_type_id);
        formatter.field("worker_id", &self.worker_id);
        formatter.field("test", &self.test);
        formatter.field("answer", &self.answer);
        formatter.field("submit_time", &self.submit_time);
        formatter.finish()
    }
}
/// See [`QualificationRequest`](crate::model::QualificationRequest)
pub mod qualification_request {
    /// A builder for [`QualificationRequest`](crate::model::QualificationRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) qualification_request_id: std::option::Option<std::string::String>,
        pub(crate) qualification_type_id: std::option::Option<std::string::String>,
        pub(crate) worker_id: std::option::Option<std::string::String>,
        pub(crate) test: std::option::Option<std::string::String>,
        pub(crate) answer: std::option::Option<std::string::String>,
        pub(crate) submit_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the Qualification request, a unique identifier generated when the request was submitted. </p>
        pub fn qualification_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualification_request_id = Some(input.into());
            self
        }
        /// <p>The ID of the Qualification request, a unique identifier generated when the request was submitted. </p>
        pub fn set_qualification_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.qualification_request_id = input;
            self
        }
        /// <p> The ID of the Qualification type the Worker is requesting, as returned by the CreateQualificationType operation. </p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualification_type_id = Some(input.into());
            self
        }
        /// <p> The ID of the Qualification type the Worker is requesting, as returned by the CreateQualificationType operation. </p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.qualification_type_id = input;
            self
        }
        /// <p> The ID of the Worker requesting the Qualification.</p>
        pub fn worker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_id = Some(input.into());
            self
        }
        /// <p> The ID of the Worker requesting the Qualification.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.worker_id = input;
            self
        }
        /// <p> The contents of the Qualification test that was presented to the Worker, if the type has a test and the Worker has submitted answers. This value is identical to the QuestionForm associated with the Qualification type at the time the Worker requests the Qualification.</p>
        pub fn test(mut self, input: impl Into<std::string::String>) -> Self {
            self.test = Some(input.into());
            self
        }
        /// <p> The contents of the Qualification test that was presented to the Worker, if the type has a test and the Worker has submitted answers. This value is identical to the QuestionForm associated with the Qualification type at the time the Worker requests the Qualification.</p>
        pub fn set_test(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.test = input;
            self
        }
        /// <p> The Worker's answers for the Qualification type's test contained in a QuestionFormAnswers document, if the type has a test and the Worker has submitted answers. If the Worker does not provide any answers, Answer may be empty. </p>
        pub fn answer(mut self, input: impl Into<std::string::String>) -> Self {
            self.answer = Some(input.into());
            self
        }
        /// <p> The Worker's answers for the Qualification type's test contained in a QuestionFormAnswers document, if the type has a test and the Worker has submitted answers. If the Worker does not provide any answers, Answer may be empty. </p>
        pub fn set_answer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.answer = input;
            self
        }
        /// <p>The date and time the Qualification request had a status of Submitted. This is either the time the Worker submitted answers for a Qualification test, or the time the Worker requested the Qualification if the Qualification type does not have a test. </p>
        pub fn submit_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.submit_time = Some(input);
            self
        }
        /// <p>The date and time the Qualification request had a status of Submitted. This is either the time the Worker submitted answers for a Qualification test, or the time the Worker requested the Qualification if the Qualification type does not have a test. </p>
        pub fn set_submit_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.submit_time = input;
            self
        }
        /// Consumes the builder and constructs a [`QualificationRequest`](crate::model::QualificationRequest)
        pub fn build(self) -> crate::model::QualificationRequest {
            crate::model::QualificationRequest {
                qualification_request_id: self.qualification_request_id,
                qualification_type_id: self.qualification_type_id,
                worker_id: self.worker_id,
                test: self.test,
                answer: self.answer,
                submit_time: self.submit_time,
            }
        }
    }
}
impl QualificationRequest {
    /// Creates a new builder-style object to manufacture [`QualificationRequest`](crate::model::QualificationRequest)
    pub fn builder() -> crate::model::qualification_request::Builder {
        crate::model::qualification_request::Builder::default()
    }
}

/// <p>An object representing a Bonus payment paid to a Worker.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BonusPayment {
    /// <p>The ID of the Worker to whom the bonus was paid.</p>
    pub worker_id: std::option::Option<std::string::String>,
    /// <p>A string representing a currency amount.</p>
    pub bonus_amount: std::option::Option<std::string::String>,
    /// <p>The ID of the assignment associated with this bonus payment.</p>
    pub assignment_id: std::option::Option<std::string::String>,
    /// <p>The Reason text given when the bonus was granted, if any.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>The date and time of when the bonus was granted.</p>
    pub grant_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl BonusPayment {
    /// <p>The ID of the Worker to whom the bonus was paid.</p>
    pub fn worker_id(&self) -> std::option::Option<&str> {
        self.worker_id.as_deref()
    }
    /// <p>A string representing a currency amount.</p>
    pub fn bonus_amount(&self) -> std::option::Option<&str> {
        self.bonus_amount.as_deref()
    }
    /// <p>The ID of the assignment associated with this bonus payment.</p>
    pub fn assignment_id(&self) -> std::option::Option<&str> {
        self.assignment_id.as_deref()
    }
    /// <p>The Reason text given when the bonus was granted, if any.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
    /// <p>The date and time of when the bonus was granted.</p>
    pub fn grant_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.grant_time.as_ref()
    }
}
impl std::fmt::Debug for BonusPayment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BonusPayment");
        formatter.field("worker_id", &self.worker_id);
        formatter.field("bonus_amount", &self.bonus_amount);
        formatter.field("assignment_id", &self.assignment_id);
        formatter.field("reason", &self.reason);
        formatter.field("grant_time", &self.grant_time);
        formatter.finish()
    }
}
/// See [`BonusPayment`](crate::model::BonusPayment)
pub mod bonus_payment {
    /// A builder for [`BonusPayment`](crate::model::BonusPayment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) worker_id: std::option::Option<std::string::String>,
        pub(crate) bonus_amount: std::option::Option<std::string::String>,
        pub(crate) assignment_id: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) grant_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the Worker to whom the bonus was paid.</p>
        pub fn worker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_id = Some(input.into());
            self
        }
        /// <p>The ID of the Worker to whom the bonus was paid.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.worker_id = input;
            self
        }
        /// <p>A string representing a currency amount.</p>
        pub fn bonus_amount(mut self, input: impl Into<std::string::String>) -> Self {
            self.bonus_amount = Some(input.into());
            self
        }
        /// <p>A string representing a currency amount.</p>
        pub fn set_bonus_amount(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bonus_amount = input;
            self
        }
        /// <p>The ID of the assignment associated with this bonus payment.</p>
        pub fn assignment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_id = Some(input.into());
            self
        }
        /// <p>The ID of the assignment associated with this bonus payment.</p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_id = input;
            self
        }
        /// <p>The Reason text given when the bonus was granted, if any.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The Reason text given when the bonus was granted, if any.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// <p>The date and time of when the bonus was granted.</p>
        pub fn grant_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.grant_time = Some(input);
            self
        }
        /// <p>The date and time of when the bonus was granted.</p>
        pub fn set_grant_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.grant_time = input;
            self
        }
        /// Consumes the builder and constructs a [`BonusPayment`](crate::model::BonusPayment)
        pub fn build(self) -> crate::model::BonusPayment {
            crate::model::BonusPayment {
                worker_id: self.worker_id,
                bonus_amount: self.bonus_amount,
                assignment_id: self.assignment_id,
                reason: self.reason,
                grant_time: self.grant_time,
            }
        }
    }
}
impl BonusPayment {
    /// Creates a new builder-style object to manufacture [`BonusPayment`](crate::model::BonusPayment)
    pub fn builder() -> crate::model::bonus_payment::Builder {
        crate::model::bonus_payment::Builder::default()
    }
}

/// <p> The Assignment data structure represents a single assignment of a HIT to a Worker. The assignment tracks the Worker's efforts to complete the HIT, and contains the results for later retrieval. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Assignment {
    /// <p> A unique identifier for the assignment.</p>
    pub assignment_id: std::option::Option<std::string::String>,
    /// <p> The ID of the Worker who accepted the HIT.</p>
    pub worker_id: std::option::Option<std::string::String>,
    /// <p> The ID of the HIT.</p>
    pub hit_id: std::option::Option<std::string::String>,
    /// <p> The status of the assignment.</p>
    pub assignment_status: std::option::Option<crate::model::AssignmentStatus>,
    /// <p> If results have been submitted, AutoApprovalTime is the date and time the results of the assignment results are considered Approved automatically if they have not already been explicitly approved or rejected by the Requester. This value is derived from the auto-approval delay specified by the Requester in the HIT. This value is omitted from the assignment if the Worker has not yet submitted results.</p>
    pub auto_approval_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The date and time the Worker accepted the assignment.</p>
    pub accept_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> If the Worker has submitted results, SubmitTime is the date and time the assignment was submitted. This value is omitted from the assignment if the Worker has not yet submitted results.</p>
    pub submit_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> If the Worker has submitted results and the Requester has approved the results, ApprovalTime is the date and time the Requester approved the results. This value is omitted from the assignment if the Requester has not yet approved the results.</p>
    pub approval_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> If the Worker has submitted results and the Requester has rejected the results, RejectionTime is the date and time the Requester rejected the results.</p>
    pub rejection_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The date and time of the deadline for the assignment. This value is derived from the deadline specification for the HIT and the date and time the Worker accepted the HIT.</p>
    pub deadline: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The Worker's answers submitted for the HIT contained in a QuestionFormAnswers document, if the Worker provides an answer. If the Worker does not provide any answers, Answer may contain a QuestionFormAnswers document, or Answer may be empty.</p>
    pub answer: std::option::Option<std::string::String>,
    /// <p> The feedback string included with the call to the ApproveAssignment operation or the RejectAssignment operation, if the Requester approved or rejected the assignment and specified feedback.</p>
    pub requester_feedback: std::option::Option<std::string::String>,
}
impl Assignment {
    /// <p> A unique identifier for the assignment.</p>
    pub fn assignment_id(&self) -> std::option::Option<&str> {
        self.assignment_id.as_deref()
    }
    /// <p> The ID of the Worker who accepted the HIT.</p>
    pub fn worker_id(&self) -> std::option::Option<&str> {
        self.worker_id.as_deref()
    }
    /// <p> The ID of the HIT.</p>
    pub fn hit_id(&self) -> std::option::Option<&str> {
        self.hit_id.as_deref()
    }
    /// <p> The status of the assignment.</p>
    pub fn assignment_status(&self) -> std::option::Option<&crate::model::AssignmentStatus> {
        self.assignment_status.as_ref()
    }
    /// <p> If results have been submitted, AutoApprovalTime is the date and time the results of the assignment results are considered Approved automatically if they have not already been explicitly approved or rejected by the Requester. This value is derived from the auto-approval delay specified by the Requester in the HIT. This value is omitted from the assignment if the Worker has not yet submitted results.</p>
    pub fn auto_approval_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.auto_approval_time.as_ref()
    }
    /// <p> The date and time the Worker accepted the assignment.</p>
    pub fn accept_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.accept_time.as_ref()
    }
    /// <p> If the Worker has submitted results, SubmitTime is the date and time the assignment was submitted. This value is omitted from the assignment if the Worker has not yet submitted results.</p>
    pub fn submit_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.submit_time.as_ref()
    }
    /// <p> If the Worker has submitted results and the Requester has approved the results, ApprovalTime is the date and time the Requester approved the results. This value is omitted from the assignment if the Requester has not yet approved the results.</p>
    pub fn approval_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.approval_time.as_ref()
    }
    /// <p> If the Worker has submitted results and the Requester has rejected the results, RejectionTime is the date and time the Requester rejected the results.</p>
    pub fn rejection_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.rejection_time.as_ref()
    }
    /// <p> The date and time of the deadline for the assignment. This value is derived from the deadline specification for the HIT and the date and time the Worker accepted the HIT.</p>
    pub fn deadline(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.deadline.as_ref()
    }
    /// <p> The Worker's answers submitted for the HIT contained in a QuestionFormAnswers document, if the Worker provides an answer. If the Worker does not provide any answers, Answer may contain a QuestionFormAnswers document, or Answer may be empty.</p>
    pub fn answer(&self) -> std::option::Option<&str> {
        self.answer.as_deref()
    }
    /// <p> The feedback string included with the call to the ApproveAssignment operation or the RejectAssignment operation, if the Requester approved or rejected the assignment and specified feedback.</p>
    pub fn requester_feedback(&self) -> std::option::Option<&str> {
        self.requester_feedback.as_deref()
    }
}
impl std::fmt::Debug for Assignment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Assignment");
        formatter.field("assignment_id", &self.assignment_id);
        formatter.field("worker_id", &self.worker_id);
        formatter.field("hit_id", &self.hit_id);
        formatter.field("assignment_status", &self.assignment_status);
        formatter.field("auto_approval_time", &self.auto_approval_time);
        formatter.field("accept_time", &self.accept_time);
        formatter.field("submit_time", &self.submit_time);
        formatter.field("approval_time", &self.approval_time);
        formatter.field("rejection_time", &self.rejection_time);
        formatter.field("deadline", &self.deadline);
        formatter.field("answer", &self.answer);
        formatter.field("requester_feedback", &self.requester_feedback);
        formatter.finish()
    }
}
/// See [`Assignment`](crate::model::Assignment)
pub mod assignment {
    /// A builder for [`Assignment`](crate::model::Assignment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assignment_id: std::option::Option<std::string::String>,
        pub(crate) worker_id: std::option::Option<std::string::String>,
        pub(crate) hit_id: std::option::Option<std::string::String>,
        pub(crate) assignment_status: std::option::Option<crate::model::AssignmentStatus>,
        pub(crate) auto_approval_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) accept_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) submit_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) approval_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) rejection_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deadline: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) answer: std::option::Option<std::string::String>,
        pub(crate) requester_feedback: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> A unique identifier for the assignment.</p>
        pub fn assignment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_id = Some(input.into());
            self
        }
        /// <p> A unique identifier for the assignment.</p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_id = input;
            self
        }
        /// <p> The ID of the Worker who accepted the HIT.</p>
        pub fn worker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_id = Some(input.into());
            self
        }
        /// <p> The ID of the Worker who accepted the HIT.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.worker_id = input;
            self
        }
        /// <p> The ID of the HIT.</p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_id = Some(input.into());
            self
        }
        /// <p> The ID of the HIT.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hit_id = input;
            self
        }
        /// <p> The status of the assignment.</p>
        pub fn assignment_status(mut self, input: crate::model::AssignmentStatus) -> Self {
            self.assignment_status = Some(input);
            self
        }
        /// <p> The status of the assignment.</p>
        pub fn set_assignment_status(
            mut self,
            input: std::option::Option<crate::model::AssignmentStatus>,
        ) -> Self {
            self.assignment_status = input;
            self
        }
        /// <p> If results have been submitted, AutoApprovalTime is the date and time the results of the assignment results are considered Approved automatically if they have not already been explicitly approved or rejected by the Requester. This value is derived from the auto-approval delay specified by the Requester in the HIT. This value is omitted from the assignment if the Worker has not yet submitted results.</p>
        pub fn auto_approval_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.auto_approval_time = Some(input);
            self
        }
        /// <p> If results have been submitted, AutoApprovalTime is the date and time the results of the assignment results are considered Approved automatically if they have not already been explicitly approved or rejected by the Requester. This value is derived from the auto-approval delay specified by the Requester in the HIT. This value is omitted from the assignment if the Worker has not yet submitted results.</p>
        pub fn set_auto_approval_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.auto_approval_time = input;
            self
        }
        /// <p> The date and time the Worker accepted the assignment.</p>
        pub fn accept_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.accept_time = Some(input);
            self
        }
        /// <p> The date and time the Worker accepted the assignment.</p>
        pub fn set_accept_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.accept_time = input;
            self
        }
        /// <p> If the Worker has submitted results, SubmitTime is the date and time the assignment was submitted. This value is omitted from the assignment if the Worker has not yet submitted results.</p>
        pub fn submit_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.submit_time = Some(input);
            self
        }
        /// <p> If the Worker has submitted results, SubmitTime is the date and time the assignment was submitted. This value is omitted from the assignment if the Worker has not yet submitted results.</p>
        pub fn set_submit_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.submit_time = input;
            self
        }
        /// <p> If the Worker has submitted results and the Requester has approved the results, ApprovalTime is the date and time the Requester approved the results. This value is omitted from the assignment if the Requester has not yet approved the results.</p>
        pub fn approval_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.approval_time = Some(input);
            self
        }
        /// <p> If the Worker has submitted results and the Requester has approved the results, ApprovalTime is the date and time the Requester approved the results. This value is omitted from the assignment if the Requester has not yet approved the results.</p>
        pub fn set_approval_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.approval_time = input;
            self
        }
        /// <p> If the Worker has submitted results and the Requester has rejected the results, RejectionTime is the date and time the Requester rejected the results.</p>
        pub fn rejection_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.rejection_time = Some(input);
            self
        }
        /// <p> If the Worker has submitted results and the Requester has rejected the results, RejectionTime is the date and time the Requester rejected the results.</p>
        pub fn set_rejection_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.rejection_time = input;
            self
        }
        /// <p> The date and time of the deadline for the assignment. This value is derived from the deadline specification for the HIT and the date and time the Worker accepted the HIT.</p>
        pub fn deadline(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.deadline = Some(input);
            self
        }
        /// <p> The date and time of the deadline for the assignment. This value is derived from the deadline specification for the HIT and the date and time the Worker accepted the HIT.</p>
        pub fn set_deadline(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.deadline = input;
            self
        }
        /// <p> The Worker's answers submitted for the HIT contained in a QuestionFormAnswers document, if the Worker provides an answer. If the Worker does not provide any answers, Answer may contain a QuestionFormAnswers document, or Answer may be empty.</p>
        pub fn answer(mut self, input: impl Into<std::string::String>) -> Self {
            self.answer = Some(input.into());
            self
        }
        /// <p> The Worker's answers submitted for the HIT contained in a QuestionFormAnswers document, if the Worker provides an answer. If the Worker does not provide any answers, Answer may contain a QuestionFormAnswers document, or Answer may be empty.</p>
        pub fn set_answer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.answer = input;
            self
        }
        /// <p> The feedback string included with the call to the ApproveAssignment operation or the RejectAssignment operation, if the Requester approved or rejected the assignment and specified feedback.</p>
        pub fn requester_feedback(mut self, input: impl Into<std::string::String>) -> Self {
            self.requester_feedback = Some(input.into());
            self
        }
        /// <p> The feedback string included with the call to the ApproveAssignment operation or the RejectAssignment operation, if the Requester approved or rejected the assignment and specified feedback.</p>
        pub fn set_requester_feedback(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.requester_feedback = input;
            self
        }
        /// Consumes the builder and constructs a [`Assignment`](crate::model::Assignment)
        pub fn build(self) -> crate::model::Assignment {
            crate::model::Assignment {
                assignment_id: self.assignment_id,
                worker_id: self.worker_id,
                hit_id: self.hit_id,
                assignment_status: self.assignment_status,
                auto_approval_time: self.auto_approval_time,
                accept_time: self.accept_time,
                submit_time: self.submit_time,
                approval_time: self.approval_time,
                rejection_time: self.rejection_time,
                deadline: self.deadline,
                answer: self.answer,
                requester_feedback: self.requester_feedback,
            }
        }
    }
}
impl Assignment {
    /// Creates a new builder-style object to manufacture [`Assignment`](crate::model::Assignment)
    pub fn builder() -> crate::model::assignment::Builder {
        crate::model::assignment::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssignmentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Approved,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    #[allow(missing_docs)] // documentation missing in model
    Submitted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssignmentStatus {
    fn from(s: &str) -> Self {
        match s {
            "Approved" => AssignmentStatus::Approved,
            "Rejected" => AssignmentStatus::Rejected,
            "Submitted" => AssignmentStatus::Submitted,
            other => AssignmentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssignmentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssignmentStatus::from(s))
    }
}
impl AssignmentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssignmentStatus::Approved => "Approved",
            AssignmentStatus::Rejected => "Rejected",
            AssignmentStatus::Submitted => "Submitted",
            AssignmentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Approved", "Rejected", "Submitted"]
    }
}
impl AsRef<str> for AssignmentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The HITLayoutParameter data structure defines parameter values used with a HITLayout. A HITLayout is a reusable Amazon Mechanical Turk project template used to provide Human Intelligence Task (HIT) question data for CreateHIT. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HitLayoutParameter {
    /// <p> The name of the parameter in the HITLayout. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value substituted for the parameter referenced in the HITLayout. </p>
    pub value: std::option::Option<std::string::String>,
}
impl HitLayoutParameter {
    /// <p> The name of the parameter in the HITLayout. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value substituted for the parameter referenced in the HITLayout. </p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for HitLayoutParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HitLayoutParameter");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`HitLayoutParameter`](crate::model::HitLayoutParameter)
pub mod hit_layout_parameter {
    /// A builder for [`HitLayoutParameter`](crate::model::HitLayoutParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the parameter in the HITLayout. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the parameter in the HITLayout. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value substituted for the parameter referenced in the HITLayout. </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value substituted for the parameter referenced in the HITLayout. </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`HitLayoutParameter`](crate::model::HitLayoutParameter)
        pub fn build(self) -> crate::model::HitLayoutParameter {
            crate::model::HitLayoutParameter {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl HitLayoutParameter {
    /// Creates a new builder-style object to manufacture [`HitLayoutParameter`](crate::model::HitLayoutParameter)
    pub fn builder() -> crate::model::hit_layout_parameter::Builder {
        crate::model::hit_layout_parameter::Builder::default()
    }
}
