// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcceptQualificationRequest`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_qualification_request`](crate::client::Client::accept_qualification_request).
///
/// See [`crate::client::fluent_builders::AcceptQualificationRequest`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptQualificationRequest {
    _private: (),
}
impl AcceptQualificationRequest {
    /// Creates a new builder-style object to manufacture [`AcceptQualificationRequestInput`](crate::input::AcceptQualificationRequestInput)
    pub fn builder() -> crate::input::accept_qualification_request_input::Builder {
        crate::input::accept_qualification_request_input::Builder::default()
    }
    /// Creates a new `AcceptQualificationRequest` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptQualificationRequest {
    type Output = std::result::Result<
        crate::output::AcceptQualificationRequestOutput,
        crate::error::AcceptQualificationRequestError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_qualification_request_error(response)
        } else {
            crate::operation_deser::parse_accept_qualification_request_response(response)
        }
    }
}

/// Operation shape for `ApproveAssignment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`approve_assignment`](crate::client::Client::approve_assignment).
///
/// See [`crate::client::fluent_builders::ApproveAssignment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ApproveAssignment {
    _private: (),
}
impl ApproveAssignment {
    /// Creates a new builder-style object to manufacture [`ApproveAssignmentInput`](crate::input::ApproveAssignmentInput)
    pub fn builder() -> crate::input::approve_assignment_input::Builder {
        crate::input::approve_assignment_input::Builder::default()
    }
    /// Creates a new `ApproveAssignment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ApproveAssignment {
    type Output = std::result::Result<
        crate::output::ApproveAssignmentOutput,
        crate::error::ApproveAssignmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_approve_assignment_error(response)
        } else {
            crate::operation_deser::parse_approve_assignment_response(response)
        }
    }
}

/// Operation shape for `AssociateQualificationWithWorker`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_qualification_with_worker`](crate::client::Client::associate_qualification_with_worker).
///
/// See [`crate::client::fluent_builders::AssociateQualificationWithWorker`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateQualificationWithWorker {
    _private: (),
}
impl AssociateQualificationWithWorker {
    /// Creates a new builder-style object to manufacture [`AssociateQualificationWithWorkerInput`](crate::input::AssociateQualificationWithWorkerInput)
    pub fn builder() -> crate::input::associate_qualification_with_worker_input::Builder {
        crate::input::associate_qualification_with_worker_input::Builder::default()
    }
    /// Creates a new `AssociateQualificationWithWorker` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateQualificationWithWorker {
    type Output = std::result::Result<
        crate::output::AssociateQualificationWithWorkerOutput,
        crate::error::AssociateQualificationWithWorkerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_qualification_with_worker_error(response)
        } else {
            crate::operation_deser::parse_associate_qualification_with_worker_response(response)
        }
    }
}

/// Operation shape for `CreateAdditionalAssignmentsForHIT`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_additional_assignments_for_hit`](crate::client::Client::create_additional_assignments_for_hit).
///
/// See [`crate::client::fluent_builders::CreateAdditionalAssignmentsForHIT`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAdditionalAssignmentsForHIT {
    _private: (),
}
impl CreateAdditionalAssignmentsForHIT {
    /// Creates a new builder-style object to manufacture [`CreateAdditionalAssignmentsForHitInput`](crate::input::CreateAdditionalAssignmentsForHitInput)
    pub fn builder() -> crate::input::create_additional_assignments_for_hit_input::Builder {
        crate::input::create_additional_assignments_for_hit_input::Builder::default()
    }
    /// Creates a new `CreateAdditionalAssignmentsForHIT` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAdditionalAssignmentsForHIT {
    type Output = std::result::Result<
        crate::output::CreateAdditionalAssignmentsForHitOutput,
        crate::error::CreateAdditionalAssignmentsForHITError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_additional_assignments_for_hit_error(response)
        } else {
            crate::operation_deser::parse_create_additional_assignments_for_hit_response(response)
        }
    }
}

/// Operation shape for `CreateHIT`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_hit`](crate::client::Client::create_hit).
///
/// See [`crate::client::fluent_builders::CreateHIT`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateHIT {
    _private: (),
}
impl CreateHIT {
    /// Creates a new builder-style object to manufacture [`CreateHitInput`](crate::input::CreateHitInput)
    pub fn builder() -> crate::input::create_hit_input::Builder {
        crate::input::create_hit_input::Builder::default()
    }
    /// Creates a new `CreateHIT` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateHIT {
    type Output = std::result::Result<crate::output::CreateHitOutput, crate::error::CreateHITError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_hit_error(response)
        } else {
            crate::operation_deser::parse_create_hit_response(response)
        }
    }
}

/// Operation shape for `CreateHITType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_hit_type`](crate::client::Client::create_hit_type).
///
/// See [`crate::client::fluent_builders::CreateHITType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateHITType {
    _private: (),
}
impl CreateHITType {
    /// Creates a new builder-style object to manufacture [`CreateHitTypeInput`](crate::input::CreateHitTypeInput)
    pub fn builder() -> crate::input::create_hit_type_input::Builder {
        crate::input::create_hit_type_input::Builder::default()
    }
    /// Creates a new `CreateHITType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateHITType {
    type Output =
        std::result::Result<crate::output::CreateHitTypeOutput, crate::error::CreateHITTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_hit_type_error(response)
        } else {
            crate::operation_deser::parse_create_hit_type_response(response)
        }
    }
}

/// Operation shape for `CreateHITWithHITType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_hit_with_hit_type`](crate::client::Client::create_hit_with_hit_type).
///
/// See [`crate::client::fluent_builders::CreateHITWithHITType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateHITWithHITType {
    _private: (),
}
impl CreateHITWithHITType {
    /// Creates a new builder-style object to manufacture [`CreateHitWithHitTypeInput`](crate::input::CreateHitWithHitTypeInput)
    pub fn builder() -> crate::input::create_hit_with_hit_type_input::Builder {
        crate::input::create_hit_with_hit_type_input::Builder::default()
    }
    /// Creates a new `CreateHITWithHITType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateHITWithHITType {
    type Output = std::result::Result<
        crate::output::CreateHitWithHitTypeOutput,
        crate::error::CreateHITWithHITTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_hit_with_hit_type_error(response)
        } else {
            crate::operation_deser::parse_create_hit_with_hit_type_response(response)
        }
    }
}

/// Operation shape for `CreateQualificationType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_qualification_type`](crate::client::Client::create_qualification_type).
///
/// See [`crate::client::fluent_builders::CreateQualificationType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateQualificationType {
    _private: (),
}
impl CreateQualificationType {
    /// Creates a new builder-style object to manufacture [`CreateQualificationTypeInput`](crate::input::CreateQualificationTypeInput)
    pub fn builder() -> crate::input::create_qualification_type_input::Builder {
        crate::input::create_qualification_type_input::Builder::default()
    }
    /// Creates a new `CreateQualificationType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateQualificationType {
    type Output = std::result::Result<
        crate::output::CreateQualificationTypeOutput,
        crate::error::CreateQualificationTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_qualification_type_error(response)
        } else {
            crate::operation_deser::parse_create_qualification_type_response(response)
        }
    }
}

/// Operation shape for `CreateWorkerBlock`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_worker_block`](crate::client::Client::create_worker_block).
///
/// See [`crate::client::fluent_builders::CreateWorkerBlock`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWorkerBlock {
    _private: (),
}
impl CreateWorkerBlock {
    /// Creates a new builder-style object to manufacture [`CreateWorkerBlockInput`](crate::input::CreateWorkerBlockInput)
    pub fn builder() -> crate::input::create_worker_block_input::Builder {
        crate::input::create_worker_block_input::Builder::default()
    }
    /// Creates a new `CreateWorkerBlock` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWorkerBlock {
    type Output = std::result::Result<
        crate::output::CreateWorkerBlockOutput,
        crate::error::CreateWorkerBlockError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_worker_block_error(response)
        } else {
            crate::operation_deser::parse_create_worker_block_response(response)
        }
    }
}

/// Operation shape for `DeleteHIT`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_hit`](crate::client::Client::delete_hit).
///
/// See [`crate::client::fluent_builders::DeleteHIT`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteHIT {
    _private: (),
}
impl DeleteHIT {
    /// Creates a new builder-style object to manufacture [`DeleteHitInput`](crate::input::DeleteHitInput)
    pub fn builder() -> crate::input::delete_hit_input::Builder {
        crate::input::delete_hit_input::Builder::default()
    }
    /// Creates a new `DeleteHIT` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteHIT {
    type Output = std::result::Result<crate::output::DeleteHitOutput, crate::error::DeleteHITError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_hit_error(response)
        } else {
            crate::operation_deser::parse_delete_hit_response(response)
        }
    }
}

/// Operation shape for `DeleteQualificationType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_qualification_type`](crate::client::Client::delete_qualification_type).
///
/// See [`crate::client::fluent_builders::DeleteQualificationType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteQualificationType {
    _private: (),
}
impl DeleteQualificationType {
    /// Creates a new builder-style object to manufacture [`DeleteQualificationTypeInput`](crate::input::DeleteQualificationTypeInput)
    pub fn builder() -> crate::input::delete_qualification_type_input::Builder {
        crate::input::delete_qualification_type_input::Builder::default()
    }
    /// Creates a new `DeleteQualificationType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteQualificationType {
    type Output = std::result::Result<
        crate::output::DeleteQualificationTypeOutput,
        crate::error::DeleteQualificationTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_qualification_type_error(response)
        } else {
            crate::operation_deser::parse_delete_qualification_type_response(response)
        }
    }
}

/// Operation shape for `DeleteWorkerBlock`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_worker_block`](crate::client::Client::delete_worker_block).
///
/// See [`crate::client::fluent_builders::DeleteWorkerBlock`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWorkerBlock {
    _private: (),
}
impl DeleteWorkerBlock {
    /// Creates a new builder-style object to manufacture [`DeleteWorkerBlockInput`](crate::input::DeleteWorkerBlockInput)
    pub fn builder() -> crate::input::delete_worker_block_input::Builder {
        crate::input::delete_worker_block_input::Builder::default()
    }
    /// Creates a new `DeleteWorkerBlock` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWorkerBlock {
    type Output = std::result::Result<
        crate::output::DeleteWorkerBlockOutput,
        crate::error::DeleteWorkerBlockError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_worker_block_error(response)
        } else {
            crate::operation_deser::parse_delete_worker_block_response(response)
        }
    }
}

/// Operation shape for `DisassociateQualificationFromWorker`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_qualification_from_worker`](crate::client::Client::disassociate_qualification_from_worker).
///
/// See [`crate::client::fluent_builders::DisassociateQualificationFromWorker`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateQualificationFromWorker {
    _private: (),
}
impl DisassociateQualificationFromWorker {
    /// Creates a new builder-style object to manufacture [`DisassociateQualificationFromWorkerInput`](crate::input::DisassociateQualificationFromWorkerInput)
    pub fn builder() -> crate::input::disassociate_qualification_from_worker_input::Builder {
        crate::input::disassociate_qualification_from_worker_input::Builder::default()
    }
    /// Creates a new `DisassociateQualificationFromWorker` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateQualificationFromWorker {
    type Output = std::result::Result<
        crate::output::DisassociateQualificationFromWorkerOutput,
        crate::error::DisassociateQualificationFromWorkerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_qualification_from_worker_error(response)
        } else {
            crate::operation_deser::parse_disassociate_qualification_from_worker_response(response)
        }
    }
}

/// Operation shape for `GetAccountBalance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_account_balance`](crate::client::Client::get_account_balance).
///
/// See [`crate::client::fluent_builders::GetAccountBalance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccountBalance {
    _private: (),
}
impl GetAccountBalance {
    /// Creates a new builder-style object to manufacture [`GetAccountBalanceInput`](crate::input::GetAccountBalanceInput)
    pub fn builder() -> crate::input::get_account_balance_input::Builder {
        crate::input::get_account_balance_input::Builder::default()
    }
    /// Creates a new `GetAccountBalance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccountBalance {
    type Output = std::result::Result<
        crate::output::GetAccountBalanceOutput,
        crate::error::GetAccountBalanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_account_balance_error(response)
        } else {
            crate::operation_deser::parse_get_account_balance_response(response)
        }
    }
}

/// Operation shape for `GetAssignment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_assignment`](crate::client::Client::get_assignment).
///
/// See [`crate::client::fluent_builders::GetAssignment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAssignment {
    _private: (),
}
impl GetAssignment {
    /// Creates a new builder-style object to manufacture [`GetAssignmentInput`](crate::input::GetAssignmentInput)
    pub fn builder() -> crate::input::get_assignment_input::Builder {
        crate::input::get_assignment_input::Builder::default()
    }
    /// Creates a new `GetAssignment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAssignment {
    type Output =
        std::result::Result<crate::output::GetAssignmentOutput, crate::error::GetAssignmentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_assignment_error(response)
        } else {
            crate::operation_deser::parse_get_assignment_response(response)
        }
    }
}

/// Operation shape for `GetFileUploadURL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_file_upload_url`](crate::client::Client::get_file_upload_url).
///
/// See [`crate::client::fluent_builders::GetFileUploadURL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFileUploadURL {
    _private: (),
}
impl GetFileUploadURL {
    /// Creates a new builder-style object to manufacture [`GetFileUploadUrlInput`](crate::input::GetFileUploadUrlInput)
    pub fn builder() -> crate::input::get_file_upload_url_input::Builder {
        crate::input::get_file_upload_url_input::Builder::default()
    }
    /// Creates a new `GetFileUploadURL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFileUploadURL {
    type Output = std::result::Result<
        crate::output::GetFileUploadUrlOutput,
        crate::error::GetFileUploadURLError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_file_upload_url_error(response)
        } else {
            crate::operation_deser::parse_get_file_upload_url_response(response)
        }
    }
}

/// Operation shape for `GetHIT`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_hit`](crate::client::Client::get_hit).
///
/// See [`crate::client::fluent_builders::GetHIT`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetHIT {
    _private: (),
}
impl GetHIT {
    /// Creates a new builder-style object to manufacture [`GetHitInput`](crate::input::GetHitInput)
    pub fn builder() -> crate::input::get_hit_input::Builder {
        crate::input::get_hit_input::Builder::default()
    }
    /// Creates a new `GetHIT` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetHIT {
    type Output = std::result::Result<crate::output::GetHitOutput, crate::error::GetHITError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_hit_error(response)
        } else {
            crate::operation_deser::parse_get_hit_response(response)
        }
    }
}

/// Operation shape for `GetQualificationScore`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_qualification_score`](crate::client::Client::get_qualification_score).
///
/// See [`crate::client::fluent_builders::GetQualificationScore`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetQualificationScore {
    _private: (),
}
impl GetQualificationScore {
    /// Creates a new builder-style object to manufacture [`GetQualificationScoreInput`](crate::input::GetQualificationScoreInput)
    pub fn builder() -> crate::input::get_qualification_score_input::Builder {
        crate::input::get_qualification_score_input::Builder::default()
    }
    /// Creates a new `GetQualificationScore` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetQualificationScore {
    type Output = std::result::Result<
        crate::output::GetQualificationScoreOutput,
        crate::error::GetQualificationScoreError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_qualification_score_error(response)
        } else {
            crate::operation_deser::parse_get_qualification_score_response(response)
        }
    }
}

/// Operation shape for `GetQualificationType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_qualification_type`](crate::client::Client::get_qualification_type).
///
/// See [`crate::client::fluent_builders::GetQualificationType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetQualificationType {
    _private: (),
}
impl GetQualificationType {
    /// Creates a new builder-style object to manufacture [`GetQualificationTypeInput`](crate::input::GetQualificationTypeInput)
    pub fn builder() -> crate::input::get_qualification_type_input::Builder {
        crate::input::get_qualification_type_input::Builder::default()
    }
    /// Creates a new `GetQualificationType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetQualificationType {
    type Output = std::result::Result<
        crate::output::GetQualificationTypeOutput,
        crate::error::GetQualificationTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_qualification_type_error(response)
        } else {
            crate::operation_deser::parse_get_qualification_type_response(response)
        }
    }
}

/// Operation shape for `ListAssignmentsForHIT`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_assignments_for_hit`](crate::client::Client::list_assignments_for_hit).
///
/// See [`crate::client::fluent_builders::ListAssignmentsForHIT`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssignmentsForHIT {
    _private: (),
}
impl ListAssignmentsForHIT {
    /// Creates a new builder-style object to manufacture [`ListAssignmentsForHitInput`](crate::input::ListAssignmentsForHitInput)
    pub fn builder() -> crate::input::list_assignments_for_hit_input::Builder {
        crate::input::list_assignments_for_hit_input::Builder::default()
    }
    /// Creates a new `ListAssignmentsForHIT` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssignmentsForHIT {
    type Output = std::result::Result<
        crate::output::ListAssignmentsForHitOutput,
        crate::error::ListAssignmentsForHITError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_assignments_for_hit_error(response)
        } else {
            crate::operation_deser::parse_list_assignments_for_hit_response(response)
        }
    }
}

/// Operation shape for `ListBonusPayments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_bonus_payments`](crate::client::Client::list_bonus_payments).
///
/// See [`crate::client::fluent_builders::ListBonusPayments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBonusPayments {
    _private: (),
}
impl ListBonusPayments {
    /// Creates a new builder-style object to manufacture [`ListBonusPaymentsInput`](crate::input::ListBonusPaymentsInput)
    pub fn builder() -> crate::input::list_bonus_payments_input::Builder {
        crate::input::list_bonus_payments_input::Builder::default()
    }
    /// Creates a new `ListBonusPayments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBonusPayments {
    type Output = std::result::Result<
        crate::output::ListBonusPaymentsOutput,
        crate::error::ListBonusPaymentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_bonus_payments_error(response)
        } else {
            crate::operation_deser::parse_list_bonus_payments_response(response)
        }
    }
}

/// Operation shape for `ListHITs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_hi_ts`](crate::client::Client::list_hi_ts).
///
/// See [`crate::client::fluent_builders::ListHITs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListHITs {
    _private: (),
}
impl ListHITs {
    /// Creates a new builder-style object to manufacture [`ListHiTsInput`](crate::input::ListHiTsInput)
    pub fn builder() -> crate::input::list_hi_ts_input::Builder {
        crate::input::list_hi_ts_input::Builder::default()
    }
    /// Creates a new `ListHITs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListHITs {
    type Output = std::result::Result<crate::output::ListHiTsOutput, crate::error::ListHITsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_hi_ts_error(response)
        } else {
            crate::operation_deser::parse_list_hi_ts_response(response)
        }
    }
}

/// Operation shape for `ListHITsForQualificationType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_hi_ts_for_qualification_type`](crate::client::Client::list_hi_ts_for_qualification_type).
///
/// See [`crate::client::fluent_builders::ListHITsForQualificationType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListHITsForQualificationType {
    _private: (),
}
impl ListHITsForQualificationType {
    /// Creates a new builder-style object to manufacture [`ListHiTsForQualificationTypeInput`](crate::input::ListHiTsForQualificationTypeInput)
    pub fn builder() -> crate::input::list_hi_ts_for_qualification_type_input::Builder {
        crate::input::list_hi_ts_for_qualification_type_input::Builder::default()
    }
    /// Creates a new `ListHITsForQualificationType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListHITsForQualificationType {
    type Output = std::result::Result<
        crate::output::ListHiTsForQualificationTypeOutput,
        crate::error::ListHITsForQualificationTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_hi_ts_for_qualification_type_error(response)
        } else {
            crate::operation_deser::parse_list_hi_ts_for_qualification_type_response(response)
        }
    }
}

/// Operation shape for `ListQualificationRequests`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_qualification_requests`](crate::client::Client::list_qualification_requests).
///
/// See [`crate::client::fluent_builders::ListQualificationRequests`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListQualificationRequests {
    _private: (),
}
impl ListQualificationRequests {
    /// Creates a new builder-style object to manufacture [`ListQualificationRequestsInput`](crate::input::ListQualificationRequestsInput)
    pub fn builder() -> crate::input::list_qualification_requests_input::Builder {
        crate::input::list_qualification_requests_input::Builder::default()
    }
    /// Creates a new `ListQualificationRequests` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListQualificationRequests {
    type Output = std::result::Result<
        crate::output::ListQualificationRequestsOutput,
        crate::error::ListQualificationRequestsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_qualification_requests_error(response)
        } else {
            crate::operation_deser::parse_list_qualification_requests_response(response)
        }
    }
}

/// Operation shape for `ListQualificationTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_qualification_types`](crate::client::Client::list_qualification_types).
///
/// See [`crate::client::fluent_builders::ListQualificationTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListQualificationTypes {
    _private: (),
}
impl ListQualificationTypes {
    /// Creates a new builder-style object to manufacture [`ListQualificationTypesInput`](crate::input::ListQualificationTypesInput)
    pub fn builder() -> crate::input::list_qualification_types_input::Builder {
        crate::input::list_qualification_types_input::Builder::default()
    }
    /// Creates a new `ListQualificationTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListQualificationTypes {
    type Output = std::result::Result<
        crate::output::ListQualificationTypesOutput,
        crate::error::ListQualificationTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_qualification_types_error(response)
        } else {
            crate::operation_deser::parse_list_qualification_types_response(response)
        }
    }
}

/// Operation shape for `ListReviewableHITs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_reviewable_hi_ts`](crate::client::Client::list_reviewable_hi_ts).
///
/// See [`crate::client::fluent_builders::ListReviewableHITs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListReviewableHITs {
    _private: (),
}
impl ListReviewableHITs {
    /// Creates a new builder-style object to manufacture [`ListReviewableHiTsInput`](crate::input::ListReviewableHiTsInput)
    pub fn builder() -> crate::input::list_reviewable_hi_ts_input::Builder {
        crate::input::list_reviewable_hi_ts_input::Builder::default()
    }
    /// Creates a new `ListReviewableHITs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListReviewableHITs {
    type Output = std::result::Result<
        crate::output::ListReviewableHiTsOutput,
        crate::error::ListReviewableHITsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_reviewable_hi_ts_error(response)
        } else {
            crate::operation_deser::parse_list_reviewable_hi_ts_response(response)
        }
    }
}

/// Operation shape for `ListReviewPolicyResultsForHIT`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_review_policy_results_for_hit`](crate::client::Client::list_review_policy_results_for_hit).
///
/// See [`crate::client::fluent_builders::ListReviewPolicyResultsForHIT`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListReviewPolicyResultsForHIT {
    _private: (),
}
impl ListReviewPolicyResultsForHIT {
    /// Creates a new builder-style object to manufacture [`ListReviewPolicyResultsForHitInput`](crate::input::ListReviewPolicyResultsForHitInput)
    pub fn builder() -> crate::input::list_review_policy_results_for_hit_input::Builder {
        crate::input::list_review_policy_results_for_hit_input::Builder::default()
    }
    /// Creates a new `ListReviewPolicyResultsForHIT` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListReviewPolicyResultsForHIT {
    type Output = std::result::Result<
        crate::output::ListReviewPolicyResultsForHitOutput,
        crate::error::ListReviewPolicyResultsForHITError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_review_policy_results_for_hit_error(response)
        } else {
            crate::operation_deser::parse_list_review_policy_results_for_hit_response(response)
        }
    }
}

/// Operation shape for `ListWorkerBlocks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_worker_blocks`](crate::client::Client::list_worker_blocks).
///
/// See [`crate::client::fluent_builders::ListWorkerBlocks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWorkerBlocks {
    _private: (),
}
impl ListWorkerBlocks {
    /// Creates a new builder-style object to manufacture [`ListWorkerBlocksInput`](crate::input::ListWorkerBlocksInput)
    pub fn builder() -> crate::input::list_worker_blocks_input::Builder {
        crate::input::list_worker_blocks_input::Builder::default()
    }
    /// Creates a new `ListWorkerBlocks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWorkerBlocks {
    type Output = std::result::Result<
        crate::output::ListWorkerBlocksOutput,
        crate::error::ListWorkerBlocksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_worker_blocks_error(response)
        } else {
            crate::operation_deser::parse_list_worker_blocks_response(response)
        }
    }
}

/// Operation shape for `ListWorkersWithQualificationType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_workers_with_qualification_type`](crate::client::Client::list_workers_with_qualification_type).
///
/// See [`crate::client::fluent_builders::ListWorkersWithQualificationType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWorkersWithQualificationType {
    _private: (),
}
impl ListWorkersWithQualificationType {
    /// Creates a new builder-style object to manufacture [`ListWorkersWithQualificationTypeInput`](crate::input::ListWorkersWithQualificationTypeInput)
    pub fn builder() -> crate::input::list_workers_with_qualification_type_input::Builder {
        crate::input::list_workers_with_qualification_type_input::Builder::default()
    }
    /// Creates a new `ListWorkersWithQualificationType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWorkersWithQualificationType {
    type Output = std::result::Result<
        crate::output::ListWorkersWithQualificationTypeOutput,
        crate::error::ListWorkersWithQualificationTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_workers_with_qualification_type_error(response)
        } else {
            crate::operation_deser::parse_list_workers_with_qualification_type_response(response)
        }
    }
}

/// Operation shape for `NotifyWorkers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`notify_workers`](crate::client::Client::notify_workers).
///
/// See [`crate::client::fluent_builders::NotifyWorkers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct NotifyWorkers {
    _private: (),
}
impl NotifyWorkers {
    /// Creates a new builder-style object to manufacture [`NotifyWorkersInput`](crate::input::NotifyWorkersInput)
    pub fn builder() -> crate::input::notify_workers_input::Builder {
        crate::input::notify_workers_input::Builder::default()
    }
    /// Creates a new `NotifyWorkers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for NotifyWorkers {
    type Output =
        std::result::Result<crate::output::NotifyWorkersOutput, crate::error::NotifyWorkersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_notify_workers_error(response)
        } else {
            crate::operation_deser::parse_notify_workers_response(response)
        }
    }
}

/// Operation shape for `RejectAssignment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_assignment`](crate::client::Client::reject_assignment).
///
/// See [`crate::client::fluent_builders::RejectAssignment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectAssignment {
    _private: (),
}
impl RejectAssignment {
    /// Creates a new builder-style object to manufacture [`RejectAssignmentInput`](crate::input::RejectAssignmentInput)
    pub fn builder() -> crate::input::reject_assignment_input::Builder {
        crate::input::reject_assignment_input::Builder::default()
    }
    /// Creates a new `RejectAssignment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RejectAssignment {
    type Output = std::result::Result<
        crate::output::RejectAssignmentOutput,
        crate::error::RejectAssignmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_assignment_error(response)
        } else {
            crate::operation_deser::parse_reject_assignment_response(response)
        }
    }
}

/// Operation shape for `RejectQualificationRequest`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_qualification_request`](crate::client::Client::reject_qualification_request).
///
/// See [`crate::client::fluent_builders::RejectQualificationRequest`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectQualificationRequest {
    _private: (),
}
impl RejectQualificationRequest {
    /// Creates a new builder-style object to manufacture [`RejectQualificationRequestInput`](crate::input::RejectQualificationRequestInput)
    pub fn builder() -> crate::input::reject_qualification_request_input::Builder {
        crate::input::reject_qualification_request_input::Builder::default()
    }
    /// Creates a new `RejectQualificationRequest` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RejectQualificationRequest {
    type Output = std::result::Result<
        crate::output::RejectQualificationRequestOutput,
        crate::error::RejectQualificationRequestError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_qualification_request_error(response)
        } else {
            crate::operation_deser::parse_reject_qualification_request_response(response)
        }
    }
}

/// Operation shape for `SendBonus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_bonus`](crate::client::Client::send_bonus).
///
/// See [`crate::client::fluent_builders::SendBonus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendBonus {
    _private: (),
}
impl SendBonus {
    /// Creates a new builder-style object to manufacture [`SendBonusInput`](crate::input::SendBonusInput)
    pub fn builder() -> crate::input::send_bonus_input::Builder {
        crate::input::send_bonus_input::Builder::default()
    }
    /// Creates a new `SendBonus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendBonus {
    type Output = std::result::Result<crate::output::SendBonusOutput, crate::error::SendBonusError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_bonus_error(response)
        } else {
            crate::operation_deser::parse_send_bonus_response(response)
        }
    }
}

/// Operation shape for `SendTestEventNotification`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_test_event_notification`](crate::client::Client::send_test_event_notification).
///
/// See [`crate::client::fluent_builders::SendTestEventNotification`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendTestEventNotification {
    _private: (),
}
impl SendTestEventNotification {
    /// Creates a new builder-style object to manufacture [`SendTestEventNotificationInput`](crate::input::SendTestEventNotificationInput)
    pub fn builder() -> crate::input::send_test_event_notification_input::Builder {
        crate::input::send_test_event_notification_input::Builder::default()
    }
    /// Creates a new `SendTestEventNotification` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendTestEventNotification {
    type Output = std::result::Result<
        crate::output::SendTestEventNotificationOutput,
        crate::error::SendTestEventNotificationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_test_event_notification_error(response)
        } else {
            crate::operation_deser::parse_send_test_event_notification_response(response)
        }
    }
}

/// Operation shape for `UpdateExpirationForHIT`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_expiration_for_hit`](crate::client::Client::update_expiration_for_hit).
///
/// See [`crate::client::fluent_builders::UpdateExpirationForHIT`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateExpirationForHIT {
    _private: (),
}
impl UpdateExpirationForHIT {
    /// Creates a new builder-style object to manufacture [`UpdateExpirationForHitInput`](crate::input::UpdateExpirationForHitInput)
    pub fn builder() -> crate::input::update_expiration_for_hit_input::Builder {
        crate::input::update_expiration_for_hit_input::Builder::default()
    }
    /// Creates a new `UpdateExpirationForHIT` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateExpirationForHIT {
    type Output = std::result::Result<
        crate::output::UpdateExpirationForHitOutput,
        crate::error::UpdateExpirationForHITError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_expiration_for_hit_error(response)
        } else {
            crate::operation_deser::parse_update_expiration_for_hit_response(response)
        }
    }
}

/// Operation shape for `UpdateHITReviewStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_hit_review_status`](crate::client::Client::update_hit_review_status).
///
/// See [`crate::client::fluent_builders::UpdateHITReviewStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateHITReviewStatus {
    _private: (),
}
impl UpdateHITReviewStatus {
    /// Creates a new builder-style object to manufacture [`UpdateHitReviewStatusInput`](crate::input::UpdateHitReviewStatusInput)
    pub fn builder() -> crate::input::update_hit_review_status_input::Builder {
        crate::input::update_hit_review_status_input::Builder::default()
    }
    /// Creates a new `UpdateHITReviewStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateHITReviewStatus {
    type Output = std::result::Result<
        crate::output::UpdateHitReviewStatusOutput,
        crate::error::UpdateHITReviewStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_hit_review_status_error(response)
        } else {
            crate::operation_deser::parse_update_hit_review_status_response(response)
        }
    }
}

/// Operation shape for `UpdateHITTypeOfHIT`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_hit_type_of_hit`](crate::client::Client::update_hit_type_of_hit).
///
/// See [`crate::client::fluent_builders::UpdateHITTypeOfHIT`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateHITTypeOfHIT {
    _private: (),
}
impl UpdateHITTypeOfHIT {
    /// Creates a new builder-style object to manufacture [`UpdateHitTypeOfHitInput`](crate::input::UpdateHitTypeOfHitInput)
    pub fn builder() -> crate::input::update_hit_type_of_hit_input::Builder {
        crate::input::update_hit_type_of_hit_input::Builder::default()
    }
    /// Creates a new `UpdateHITTypeOfHIT` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateHITTypeOfHIT {
    type Output = std::result::Result<
        crate::output::UpdateHitTypeOfHitOutput,
        crate::error::UpdateHITTypeOfHITError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_hit_type_of_hit_error(response)
        } else {
            crate::operation_deser::parse_update_hit_type_of_hit_response(response)
        }
    }
}

/// Operation shape for `UpdateNotificationSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_notification_settings`](crate::client::Client::update_notification_settings).
///
/// See [`crate::client::fluent_builders::UpdateNotificationSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateNotificationSettings {
    _private: (),
}
impl UpdateNotificationSettings {
    /// Creates a new builder-style object to manufacture [`UpdateNotificationSettingsInput`](crate::input::UpdateNotificationSettingsInput)
    pub fn builder() -> crate::input::update_notification_settings_input::Builder {
        crate::input::update_notification_settings_input::Builder::default()
    }
    /// Creates a new `UpdateNotificationSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateNotificationSettings {
    type Output = std::result::Result<
        crate::output::UpdateNotificationSettingsOutput,
        crate::error::UpdateNotificationSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_notification_settings_error(response)
        } else {
            crate::operation_deser::parse_update_notification_settings_response(response)
        }
    }
}

/// Operation shape for `UpdateQualificationType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_qualification_type`](crate::client::Client::update_qualification_type).
///
/// See [`crate::client::fluent_builders::UpdateQualificationType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateQualificationType {
    _private: (),
}
impl UpdateQualificationType {
    /// Creates a new builder-style object to manufacture [`UpdateQualificationTypeInput`](crate::input::UpdateQualificationTypeInput)
    pub fn builder() -> crate::input::update_qualification_type_input::Builder {
        crate::input::update_qualification_type_input::Builder::default()
    }
    /// Creates a new `UpdateQualificationType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateQualificationType {
    type Output = std::result::Result<
        crate::output::UpdateQualificationTypeOutput,
        crate::error::UpdateQualificationTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_qualification_type_error(response)
        } else {
            crate::operation_deser::parse_update_qualification_type_response(response)
        }
    }
}
