// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_accept_qualification_request_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AcceptQualificationRequestOutput,
    crate::error::AcceptQualificationRequestError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AcceptQualificationRequestError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AcceptQualificationRequestError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::AcceptQualificationRequestError {
            meta: generic,
            kind: crate::error::AcceptQualificationRequestErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::AcceptQualificationRequestError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::AcceptQualificationRequestError {
            meta: generic,
            kind: crate::error::AcceptQualificationRequestErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::AcceptQualificationRequestError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AcceptQualificationRequestError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_accept_qualification_request_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AcceptQualificationRequestOutput,
    crate::error::AcceptQualificationRequestError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::accept_qualification_request_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_approve_assignment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ApproveAssignmentOutput, crate::error::ApproveAssignmentError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ApproveAssignmentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ApproveAssignmentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::ApproveAssignmentError {
            meta: generic,
            kind: crate::error::ApproveAssignmentErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ApproveAssignmentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::ApproveAssignmentError {
            meta: generic,
            kind: crate::error::ApproveAssignmentErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ApproveAssignmentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ApproveAssignmentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_approve_assignment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ApproveAssignmentOutput, crate::error::ApproveAssignmentError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::approve_assignment_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_qualification_with_worker_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateQualificationWithWorkerOutput,
    crate::error::AssociateQualificationWithWorkerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateQualificationWithWorkerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AssociateQualificationWithWorkerError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::AssociateQualificationWithWorkerError {
            meta: generic,
            kind: crate::error::AssociateQualificationWithWorkerErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::AssociateQualificationWithWorkerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::AssociateQualificationWithWorkerError {
            meta: generic,
            kind: crate::error::AssociateQualificationWithWorkerErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::AssociateQualificationWithWorkerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateQualificationWithWorkerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_qualification_with_worker_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateQualificationWithWorkerOutput,
    crate::error::AssociateQualificationWithWorkerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::associate_qualification_with_worker_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_additional_assignments_for_hit_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateAdditionalAssignmentsForHitOutput,
    crate::error::CreateAdditionalAssignmentsForHITError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAdditionalAssignmentsForHITError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateAdditionalAssignmentsForHITError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::CreateAdditionalAssignmentsForHITError {
            meta: generic,
            kind: crate::error::CreateAdditionalAssignmentsForHITErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateAdditionalAssignmentsForHITError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::CreateAdditionalAssignmentsForHITError {
            meta: generic,
            kind: crate::error::CreateAdditionalAssignmentsForHITErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateAdditionalAssignmentsForHITError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateAdditionalAssignmentsForHITError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_additional_assignments_for_hit_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateAdditionalAssignmentsForHitOutput,
    crate::error::CreateAdditionalAssignmentsForHITError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_additional_assignments_for_hit_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_hit_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateHitOutput, crate::error::CreateHITError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateHITError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateHITError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::CreateHITError {
            meta: generic,
            kind: crate::error::CreateHITErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateHITError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::CreateHITError {
            meta: generic,
            kind: crate::error::CreateHITErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateHITError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateHITError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_hit_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateHitOutput, crate::error::CreateHITError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_hit_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_hit(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateHITError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_hit_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateHitTypeOutput, crate::error::CreateHITTypeError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateHITTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateHITTypeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::CreateHITTypeError {
            meta: generic,
            kind: crate::error::CreateHITTypeErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateHITTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::CreateHITTypeError {
            meta: generic,
            kind: crate::error::CreateHITTypeErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateHITTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateHITTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_hit_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateHitTypeOutput, crate::error::CreateHITTypeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_hit_type_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_hit_type(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateHITTypeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_hit_with_hit_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateHitWithHitTypeOutput,
    crate::error::CreateHITWithHITTypeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateHITWithHITTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateHITWithHITTypeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::CreateHITWithHITTypeError {
            meta: generic,
            kind: crate::error::CreateHITWithHITTypeErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateHITWithHITTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::CreateHITWithHITTypeError {
            meta: generic,
            kind: crate::error::CreateHITWithHITTypeErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateHITWithHITTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateHITWithHITTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_hit_with_hit_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateHitWithHitTypeOutput,
    crate::error::CreateHITWithHITTypeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_hit_with_hit_type_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_hit_with_hit_type(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateHITWithHITTypeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_qualification_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateQualificationTypeOutput,
    crate::error::CreateQualificationTypeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateQualificationTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateQualificationTypeError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::CreateQualificationTypeError {
            meta: generic,
            kind: crate::error::CreateQualificationTypeErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateQualificationTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::CreateQualificationTypeError {
            meta: generic,
            kind: crate::error::CreateQualificationTypeErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateQualificationTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateQualificationTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_qualification_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateQualificationTypeOutput,
    crate::error::CreateQualificationTypeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_qualification_type_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_qualification_type(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateQualificationTypeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_worker_block_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateWorkerBlockOutput, crate::error::CreateWorkerBlockError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateWorkerBlockError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateWorkerBlockError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::CreateWorkerBlockError {
            meta: generic,
            kind: crate::error::CreateWorkerBlockErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateWorkerBlockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::CreateWorkerBlockError {
            meta: generic,
            kind: crate::error::CreateWorkerBlockErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateWorkerBlockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateWorkerBlockError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_worker_block_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateWorkerBlockOutput, crate::error::CreateWorkerBlockError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_worker_block_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_hit_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteHitOutput, crate::error::DeleteHITError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteHITError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteHITError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::DeleteHITError {
            meta: generic,
            kind: crate::error::DeleteHITErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteHITError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::DeleteHITError {
            meta: generic,
            kind: crate::error::DeleteHITErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteHITError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteHITError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_hit_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteHitOutput, crate::error::DeleteHITError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_hit_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_qualification_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteQualificationTypeOutput,
    crate::error::DeleteQualificationTypeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteQualificationTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteQualificationTypeError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::DeleteQualificationTypeError {
            meta: generic,
            kind: crate::error::DeleteQualificationTypeErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteQualificationTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::DeleteQualificationTypeError {
            meta: generic,
            kind: crate::error::DeleteQualificationTypeErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteQualificationTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteQualificationTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_qualification_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteQualificationTypeOutput,
    crate::error::DeleteQualificationTypeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_qualification_type_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_worker_block_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteWorkerBlockOutput, crate::error::DeleteWorkerBlockError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteWorkerBlockError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteWorkerBlockError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::DeleteWorkerBlockError {
            meta: generic,
            kind: crate::error::DeleteWorkerBlockErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteWorkerBlockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::DeleteWorkerBlockError {
            meta: generic,
            kind: crate::error::DeleteWorkerBlockErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteWorkerBlockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteWorkerBlockError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_worker_block_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteWorkerBlockOutput, crate::error::DeleteWorkerBlockError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_worker_block_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_qualification_from_worker_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateQualificationFromWorkerOutput,
    crate::error::DisassociateQualificationFromWorkerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateQualificationFromWorkerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisassociateQualificationFromWorkerError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::DisassociateQualificationFromWorkerError {
            meta: generic,
            kind: crate::error::DisassociateQualificationFromWorkerErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DisassociateQualificationFromWorkerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::DisassociateQualificationFromWorkerError {
            meta: generic,
            kind: crate::error::DisassociateQualificationFromWorkerErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DisassociateQualificationFromWorkerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisassociateQualificationFromWorkerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_qualification_from_worker_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateQualificationFromWorkerOutput,
    crate::error::DisassociateQualificationFromWorkerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::disassociate_qualification_from_worker_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_account_balance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAccountBalanceOutput, crate::error::GetAccountBalanceError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAccountBalanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetAccountBalanceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::GetAccountBalanceError {
            meta: generic,
            kind: crate::error::GetAccountBalanceErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetAccountBalanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::GetAccountBalanceError {
            meta: generic,
            kind: crate::error::GetAccountBalanceErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetAccountBalanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetAccountBalanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_account_balance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAccountBalanceOutput, crate::error::GetAccountBalanceError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_account_balance_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_account_balance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAccountBalanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_assignment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAssignmentOutput, crate::error::GetAssignmentError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAssignmentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetAssignmentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::GetAssignmentError {
            meta: generic,
            kind: crate::error::GetAssignmentErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetAssignmentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::GetAssignmentError {
            meta: generic,
            kind: crate::error::GetAssignmentErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetAssignmentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetAssignmentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_assignment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAssignmentOutput, crate::error::GetAssignmentError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_assignment_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_assignment(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAssignmentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_file_upload_url_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetFileUploadUrlOutput, crate::error::GetFileUploadURLError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetFileUploadURLError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetFileUploadURLError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::GetFileUploadURLError {
            meta: generic,
            kind: crate::error::GetFileUploadURLErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetFileUploadURLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::GetFileUploadURLError {
            meta: generic,
            kind: crate::error::GetFileUploadURLErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetFileUploadURLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetFileUploadURLError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_file_upload_url_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetFileUploadUrlOutput, crate::error::GetFileUploadURLError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_file_upload_url_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_file_upload_url(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetFileUploadURLError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_hit_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetHitOutput, crate::error::GetHITError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetHITError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetHITError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::GetHITError {
            meta: generic,
            kind: crate::error::GetHITErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetHITError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::GetHITError {
            meta: generic,
            kind: crate::error::GetHITErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetHITError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetHITError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_hit_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetHitOutput, crate::error::GetHITError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_hit_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_hit(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetHITError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_qualification_score_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetQualificationScoreOutput,
    crate::error::GetQualificationScoreError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetQualificationScoreError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetQualificationScoreError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::GetQualificationScoreError {
            meta: generic,
            kind: crate::error::GetQualificationScoreErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetQualificationScoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::GetQualificationScoreError {
            meta: generic,
            kind: crate::error::GetQualificationScoreErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetQualificationScoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetQualificationScoreError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_qualification_score_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetQualificationScoreOutput,
    crate::error::GetQualificationScoreError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_qualification_score_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_qualification_score(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetQualificationScoreError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_qualification_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetQualificationTypeOutput,
    crate::error::GetQualificationTypeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetQualificationTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetQualificationTypeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::GetQualificationTypeError {
            meta: generic,
            kind: crate::error::GetQualificationTypeErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetQualificationTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::GetQualificationTypeError {
            meta: generic,
            kind: crate::error::GetQualificationTypeErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetQualificationTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetQualificationTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_qualification_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetQualificationTypeOutput,
    crate::error::GetQualificationTypeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_qualification_type_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_qualification_type(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetQualificationTypeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_assignments_for_hit_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAssignmentsForHitOutput,
    crate::error::ListAssignmentsForHITError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAssignmentsForHITError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListAssignmentsForHITError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::ListAssignmentsForHITError {
            meta: generic,
            kind: crate::error::ListAssignmentsForHITErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListAssignmentsForHITError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::ListAssignmentsForHITError {
            meta: generic,
            kind: crate::error::ListAssignmentsForHITErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListAssignmentsForHITError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListAssignmentsForHITError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_assignments_for_hit_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAssignmentsForHitOutput,
    crate::error::ListAssignmentsForHITError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_assignments_for_hit_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_assignments_for_hit(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAssignmentsForHITError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_bonus_payments_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListBonusPaymentsOutput, crate::error::ListBonusPaymentsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListBonusPaymentsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListBonusPaymentsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::ListBonusPaymentsError {
            meta: generic,
            kind: crate::error::ListBonusPaymentsErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListBonusPaymentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::ListBonusPaymentsError {
            meta: generic,
            kind: crate::error::ListBonusPaymentsErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListBonusPaymentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListBonusPaymentsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_bonus_payments_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListBonusPaymentsOutput, crate::error::ListBonusPaymentsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_bonus_payments_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_bonus_payments(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListBonusPaymentsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_hi_ts_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListHiTsOutput, crate::error::ListHITsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListHITsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListHITsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::ListHITsError {
            meta: generic,
            kind: crate::error::ListHITsErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListHITsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::ListHITsError {
            meta: generic,
            kind: crate::error::ListHITsErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListHITsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListHITsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_hi_ts_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListHiTsOutput, crate::error::ListHITsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_hi_ts_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_hi_ts(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListHITsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_hi_ts_for_qualification_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListHiTsForQualificationTypeOutput,
    crate::error::ListHITsForQualificationTypeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListHITsForQualificationTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListHITsForQualificationTypeError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::ListHITsForQualificationTypeError {
            meta: generic,
            kind: crate::error::ListHITsForQualificationTypeErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListHITsForQualificationTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::ListHITsForQualificationTypeError {
            meta: generic,
            kind: crate::error::ListHITsForQualificationTypeErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListHITsForQualificationTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListHITsForQualificationTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_hi_ts_for_qualification_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListHiTsForQualificationTypeOutput,
    crate::error::ListHITsForQualificationTypeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_hi_ts_for_qualification_type_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_hi_ts_for_qualification_type(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListHITsForQualificationTypeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_qualification_requests_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListQualificationRequestsOutput,
    crate::error::ListQualificationRequestsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListQualificationRequestsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListQualificationRequestsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::ListQualificationRequestsError {
            meta: generic,
            kind: crate::error::ListQualificationRequestsErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListQualificationRequestsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::ListQualificationRequestsError {
            meta: generic,
            kind: crate::error::ListQualificationRequestsErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListQualificationRequestsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListQualificationRequestsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_qualification_requests_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListQualificationRequestsOutput,
    crate::error::ListQualificationRequestsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_qualification_requests_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_qualification_requests(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListQualificationRequestsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_qualification_types_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListQualificationTypesOutput,
    crate::error::ListQualificationTypesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListQualificationTypesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListQualificationTypesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::ListQualificationTypesError {
            meta: generic,
            kind: crate::error::ListQualificationTypesErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListQualificationTypesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::ListQualificationTypesError {
            meta: generic,
            kind: crate::error::ListQualificationTypesErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListQualificationTypesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListQualificationTypesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_qualification_types_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListQualificationTypesOutput,
    crate::error::ListQualificationTypesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_qualification_types_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_qualification_types(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListQualificationTypesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_reviewable_hi_ts_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListReviewableHiTsOutput,
    crate::error::ListReviewableHITsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListReviewableHITsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListReviewableHITsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::ListReviewableHITsError {
            meta: generic,
            kind: crate::error::ListReviewableHITsErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListReviewableHITsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::ListReviewableHITsError {
            meta: generic,
            kind: crate::error::ListReviewableHITsErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListReviewableHITsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListReviewableHITsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_reviewable_hi_ts_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListReviewableHiTsOutput,
    crate::error::ListReviewableHITsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_reviewable_hi_ts_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_reviewable_hi_ts(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListReviewableHITsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_review_policy_results_for_hit_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListReviewPolicyResultsForHitOutput,
    crate::error::ListReviewPolicyResultsForHITError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListReviewPolicyResultsForHITError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListReviewPolicyResultsForHITError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::ListReviewPolicyResultsForHITError {
            meta: generic,
            kind: crate::error::ListReviewPolicyResultsForHITErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListReviewPolicyResultsForHITError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::ListReviewPolicyResultsForHITError {
            meta: generic,
            kind: crate::error::ListReviewPolicyResultsForHITErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListReviewPolicyResultsForHITError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListReviewPolicyResultsForHITError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_review_policy_results_for_hit_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListReviewPolicyResultsForHitOutput,
    crate::error::ListReviewPolicyResultsForHITError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_review_policy_results_for_hit_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_review_policy_results_for_hit(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListReviewPolicyResultsForHITError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_worker_blocks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListWorkerBlocksOutput, crate::error::ListWorkerBlocksError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListWorkerBlocksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListWorkerBlocksError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::ListWorkerBlocksError {
            meta: generic,
            kind: crate::error::ListWorkerBlocksErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListWorkerBlocksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::ListWorkerBlocksError {
            meta: generic,
            kind: crate::error::ListWorkerBlocksErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListWorkerBlocksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListWorkerBlocksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_worker_blocks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListWorkerBlocksOutput, crate::error::ListWorkerBlocksError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_worker_blocks_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_worker_blocks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListWorkerBlocksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_workers_with_qualification_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListWorkersWithQualificationTypeOutput,
    crate::error::ListWorkersWithQualificationTypeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListWorkersWithQualificationTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListWorkersWithQualificationTypeError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::ListWorkersWithQualificationTypeError {
            meta: generic,
            kind: crate::error::ListWorkersWithQualificationTypeErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListWorkersWithQualificationTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::ListWorkersWithQualificationTypeError {
            meta: generic,
            kind: crate::error::ListWorkersWithQualificationTypeErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListWorkersWithQualificationTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListWorkersWithQualificationTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_workers_with_qualification_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListWorkersWithQualificationTypeOutput,
    crate::error::ListWorkersWithQualificationTypeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_workers_with_qualification_type_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_workers_with_qualification_type(response.body().as_ref(), output).map_err(crate::error::ListWorkersWithQualificationTypeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_notify_workers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::NotifyWorkersOutput, crate::error::NotifyWorkersError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::NotifyWorkersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::NotifyWorkersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::NotifyWorkersError {
            meta: generic,
            kind: crate::error::NotifyWorkersErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::NotifyWorkersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::NotifyWorkersError {
            meta: generic,
            kind: crate::error::NotifyWorkersErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::NotifyWorkersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::NotifyWorkersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_notify_workers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::NotifyWorkersOutput, crate::error::NotifyWorkersError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::notify_workers_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_notify_workers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::NotifyWorkersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reject_assignment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RejectAssignmentOutput, crate::error::RejectAssignmentError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RejectAssignmentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RejectAssignmentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::RejectAssignmentError {
            meta: generic,
            kind: crate::error::RejectAssignmentErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::RejectAssignmentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::RejectAssignmentError {
            meta: generic,
            kind: crate::error::RejectAssignmentErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::RejectAssignmentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RejectAssignmentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reject_assignment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RejectAssignmentOutput, crate::error::RejectAssignmentError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reject_assignment_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reject_qualification_request_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RejectQualificationRequestOutput,
    crate::error::RejectQualificationRequestError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RejectQualificationRequestError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RejectQualificationRequestError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::RejectQualificationRequestError {
            meta: generic,
            kind: crate::error::RejectQualificationRequestErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::RejectQualificationRequestError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::RejectQualificationRequestError {
            meta: generic,
            kind: crate::error::RejectQualificationRequestErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::RejectQualificationRequestError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RejectQualificationRequestError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reject_qualification_request_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RejectQualificationRequestOutput,
    crate::error::RejectQualificationRequestError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reject_qualification_request_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_bonus_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendBonusOutput, crate::error::SendBonusError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendBonusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SendBonusError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::SendBonusError {
            meta: generic,
            kind: crate::error::SendBonusErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::SendBonusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::SendBonusError {
            meta: generic,
            kind: crate::error::SendBonusErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::SendBonusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SendBonusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_bonus_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendBonusOutput, crate::error::SendBonusError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::send_bonus_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_test_event_notification_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SendTestEventNotificationOutput,
    crate::error::SendTestEventNotificationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendTestEventNotificationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SendTestEventNotificationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::SendTestEventNotificationError {
            meta: generic,
            kind: crate::error::SendTestEventNotificationErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::SendTestEventNotificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::SendTestEventNotificationError {
            meta: generic,
            kind: crate::error::SendTestEventNotificationErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::SendTestEventNotificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SendTestEventNotificationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_test_event_notification_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SendTestEventNotificationOutput,
    crate::error::SendTestEventNotificationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::send_test_event_notification_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_expiration_for_hit_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateExpirationForHitOutput,
    crate::error::UpdateExpirationForHITError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateExpirationForHITError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateExpirationForHITError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::UpdateExpirationForHITError {
            meta: generic,
            kind: crate::error::UpdateExpirationForHITErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateExpirationForHITError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::UpdateExpirationForHITError {
            meta: generic,
            kind: crate::error::UpdateExpirationForHITErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateExpirationForHITError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateExpirationForHITError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_expiration_for_hit_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateExpirationForHitOutput,
    crate::error::UpdateExpirationForHITError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_expiration_for_hit_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_hit_review_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateHitReviewStatusOutput,
    crate::error::UpdateHITReviewStatusError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateHITReviewStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateHITReviewStatusError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::UpdateHITReviewStatusError {
            meta: generic,
            kind: crate::error::UpdateHITReviewStatusErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateHITReviewStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::UpdateHITReviewStatusError {
            meta: generic,
            kind: crate::error::UpdateHITReviewStatusErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateHITReviewStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateHITReviewStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_hit_review_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateHitReviewStatusOutput,
    crate::error::UpdateHITReviewStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_hit_review_status_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_hit_type_of_hit_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateHitTypeOfHitOutput,
    crate::error::UpdateHITTypeOfHITError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateHITTypeOfHITError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateHITTypeOfHITError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::UpdateHITTypeOfHITError {
            meta: generic,
            kind: crate::error::UpdateHITTypeOfHITErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateHITTypeOfHITError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::UpdateHITTypeOfHITError {
            meta: generic,
            kind: crate::error::UpdateHITTypeOfHITErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateHITTypeOfHITError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateHITTypeOfHITError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_hit_type_of_hit_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateHitTypeOfHitOutput,
    crate::error::UpdateHITTypeOfHITError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_hit_type_of_hit_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_notification_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateNotificationSettingsOutput,
    crate::error::UpdateNotificationSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateNotificationSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateNotificationSettingsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::UpdateNotificationSettingsError {
            meta: generic,
            kind: crate::error::UpdateNotificationSettingsErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateNotificationSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::UpdateNotificationSettingsError {
            meta: generic,
            kind: crate::error::UpdateNotificationSettingsErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateNotificationSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateNotificationSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_notification_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateNotificationSettingsOutput,
    crate::error::UpdateNotificationSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_notification_settings_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_qualification_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateQualificationTypeOutput,
    crate::error::UpdateQualificationTypeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateQualificationTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateQualificationTypeError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RequestError" => crate::error::UpdateQualificationTypeError {
            meta: generic,
            kind: crate::error::UpdateQualificationTypeErrorKind::RequestError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateQualificationTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFault" => crate::error::UpdateQualificationTypeError {
            meta: generic,
            kind: crate::error::UpdateQualificationTypeErrorKind::ServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateQualificationTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateQualificationTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_qualification_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateQualificationTypeOutput,
    crate::error::UpdateQualificationTypeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_qualification_type_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_qualification_type(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateQualificationTypeError::unhandled)?;
        output.build()
    })
}
