// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptQualificationRequestInput`](crate::input::AcceptQualificationRequestInput)
pub mod accept_qualification_request_input {
    /// A builder for [`AcceptQualificationRequestInput`](crate::input::AcceptQualificationRequestInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) qualification_request_id: std::option::Option<std::string::String>,
        pub(crate) integer_value: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the Qualification request, as returned by the <code>GetQualificationRequests</code> operation.</p>
        pub fn qualification_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualification_request_id = Some(input.into());
            self
        }
        /// <p>The ID of the Qualification request, as returned by the <code>GetQualificationRequests</code> operation.</p>
        pub fn set_qualification_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.qualification_request_id = input;
            self
        }
        /// <p>
        /// The value of the Qualification. You can omit this value if you are using the
        /// presence or absence of the Qualification as the basis for a HIT requirement.
        /// </p>
        pub fn integer_value(mut self, input: i32) -> Self {
            self.integer_value = Some(input);
            self
        }
        /// <p>
        /// The value of the Qualification. You can omit this value if you are using the
        /// presence or absence of the Qualification as the basis for a HIT requirement.
        /// </p>
        pub fn set_integer_value(mut self, input: std::option::Option<i32>) -> Self {
            self.integer_value = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptQualificationRequestInput`](crate::input::AcceptQualificationRequestInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptQualificationRequestInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptQualificationRequestInput {
                qualification_request_id: self.qualification_request_id,
                integer_value: self.integer_value,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptQualificationRequestInputOperationOutputAlias =
    crate::operation::AcceptQualificationRequest;
#[doc(hidden)]
pub type AcceptQualificationRequestInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AcceptQualificationRequestInput {
    /// Consumes the builder and constructs an Operation<[`AcceptQualificationRequest`](crate::operation::AcceptQualificationRequest)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptQualificationRequest,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AcceptQualificationRequestInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AcceptQualificationRequestInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AcceptQualificationRequestInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.AcceptQualificationRequest",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_accept_qualification_request(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptQualificationRequest::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptQualificationRequest",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AcceptQualificationRequestInput`](crate::input::AcceptQualificationRequestInput)
    pub fn builder() -> crate::input::accept_qualification_request_input::Builder {
        crate::input::accept_qualification_request_input::Builder::default()
    }
}

/// See [`ApproveAssignmentInput`](crate::input::ApproveAssignmentInput)
pub mod approve_assignment_input {
    /// A builder for [`ApproveAssignmentInput`](crate::input::ApproveAssignmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assignment_id: std::option::Option<std::string::String>,
        pub(crate) requester_feedback: std::option::Option<std::string::String>,
        pub(crate) override_rejection: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>
        /// The ID of the assignment. The assignment must correspond to a HIT created by the Requester.
        /// </p>
        pub fn assignment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the assignment. The assignment must correspond to a HIT created by the Requester.
        /// </p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_id = input;
            self
        }
        /// <p>
        /// A message for the Worker, which the Worker can see in the Status section of the web site.
        /// </p>
        pub fn requester_feedback(mut self, input: impl Into<std::string::String>) -> Self {
            self.requester_feedback = Some(input.into());
            self
        }
        /// <p>
        /// A message for the Worker, which the Worker can see in the Status section of the web site.
        /// </p>
        pub fn set_requester_feedback(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.requester_feedback = input;
            self
        }
        /// <p>
        /// A flag indicating that an assignment should be approved even if it was previously rejected. Defaults to <code>False</code>.
        /// </p>
        pub fn override_rejection(mut self, input: bool) -> Self {
            self.override_rejection = Some(input);
            self
        }
        /// <p>
        /// A flag indicating that an assignment should be approved even if it was previously rejected. Defaults to <code>False</code>.
        /// </p>
        pub fn set_override_rejection(mut self, input: std::option::Option<bool>) -> Self {
            self.override_rejection = input;
            self
        }
        /// Consumes the builder and constructs a [`ApproveAssignmentInput`](crate::input::ApproveAssignmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ApproveAssignmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ApproveAssignmentInput {
                assignment_id: self.assignment_id,
                requester_feedback: self.requester_feedback,
                override_rejection: self.override_rejection,
            })
        }
    }
}
#[doc(hidden)]
pub type ApproveAssignmentInputOperationOutputAlias = crate::operation::ApproveAssignment;
#[doc(hidden)]
pub type ApproveAssignmentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ApproveAssignmentInput {
    /// Consumes the builder and constructs an Operation<[`ApproveAssignment`](crate::operation::ApproveAssignment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ApproveAssignment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ApproveAssignmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ApproveAssignmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ApproveAssignmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.ApproveAssignment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_approve_assignment(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ApproveAssignment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ApproveAssignment",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ApproveAssignmentInput`](crate::input::ApproveAssignmentInput)
    pub fn builder() -> crate::input::approve_assignment_input::Builder {
        crate::input::approve_assignment_input::Builder::default()
    }
}

/// See [`AssociateQualificationWithWorkerInput`](crate::input::AssociateQualificationWithWorkerInput)
pub mod associate_qualification_with_worker_input {
    /// A builder for [`AssociateQualificationWithWorkerInput`](crate::input::AssociateQualificationWithWorkerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) qualification_type_id: std::option::Option<std::string::String>,
        pub(crate) worker_id: std::option::Option<std::string::String>,
        pub(crate) integer_value: std::option::Option<i32>,
        pub(crate) send_notification: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the Qualification type to use for the assigned Qualification.</p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualification_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the Qualification type to use for the assigned Qualification.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.qualification_type_id = input;
            self
        }
        /// <p>
        /// The ID of the Worker to whom the Qualification is being assigned.
        /// Worker IDs are included with submitted HIT assignments and Qualification requests.
        /// </p>
        pub fn worker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the Worker to whom the Qualification is being assigned.
        /// Worker IDs are included with submitted HIT assignments and Qualification requests.
        /// </p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.worker_id = input;
            self
        }
        /// <p>The value of the Qualification to assign.</p>
        pub fn integer_value(mut self, input: i32) -> Self {
            self.integer_value = Some(input);
            self
        }
        /// <p>The value of the Qualification to assign.</p>
        pub fn set_integer_value(mut self, input: std::option::Option<i32>) -> Self {
            self.integer_value = input;
            self
        }
        /// <p>
        /// Specifies whether to send a notification email message to the Worker
        /// saying that the qualification was assigned to the Worker.
        /// Note: this is true by default.
        /// </p>
        pub fn send_notification(mut self, input: bool) -> Self {
            self.send_notification = Some(input);
            self
        }
        /// <p>
        /// Specifies whether to send a notification email message to the Worker
        /// saying that the qualification was assigned to the Worker.
        /// Note: this is true by default.
        /// </p>
        pub fn set_send_notification(mut self, input: std::option::Option<bool>) -> Self {
            self.send_notification = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateQualificationWithWorkerInput`](crate::input::AssociateQualificationWithWorkerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateQualificationWithWorkerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateQualificationWithWorkerInput {
                qualification_type_id: self.qualification_type_id,
                worker_id: self.worker_id,
                integer_value: self.integer_value,
                send_notification: self.send_notification,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateQualificationWithWorkerInputOperationOutputAlias =
    crate::operation::AssociateQualificationWithWorker;
#[doc(hidden)]
pub type AssociateQualificationWithWorkerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateQualificationWithWorkerInput {
    /// Consumes the builder and constructs an Operation<[`AssociateQualificationWithWorker`](crate::operation::AssociateQualificationWithWorker)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateQualificationWithWorker,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateQualificationWithWorkerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateQualificationWithWorkerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateQualificationWithWorkerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.AssociateQualificationWithWorker",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_qualification_with_worker(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateQualificationWithWorker::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateQualificationWithWorker",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateQualificationWithWorkerInput`](crate::input::AssociateQualificationWithWorkerInput)
    pub fn builder() -> crate::input::associate_qualification_with_worker_input::Builder {
        crate::input::associate_qualification_with_worker_input::Builder::default()
    }
}

/// See [`CreateAdditionalAssignmentsForHitInput`](crate::input::CreateAdditionalAssignmentsForHitInput)
pub mod create_additional_assignments_for_hit_input {
    /// A builder for [`CreateAdditionalAssignmentsForHitInput`](crate::input::CreateAdditionalAssignmentsForHitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hit_id: std::option::Option<std::string::String>,
        pub(crate) number_of_additional_assignments: std::option::Option<i32>,
        pub(crate) unique_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the HIT to extend.</p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_id = Some(input.into());
            self
        }
        /// <p>The ID of the HIT to extend.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hit_id = input;
            self
        }
        /// <p>The number of additional assignments to request for this HIT.</p>
        pub fn number_of_additional_assignments(mut self, input: i32) -> Self {
            self.number_of_additional_assignments = Some(input);
            self
        }
        /// <p>The number of additional assignments to request for this HIT.</p>
        pub fn set_number_of_additional_assignments(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.number_of_additional_assignments = input;
            self
        }
        /// <p>
        /// A unique identifier for this request, which allows you to retry the call on error
        /// without extending the HIT multiple times.
        /// This is useful in cases such as network timeouts where it is unclear whether or not
        /// the call succeeded on the server. If the extend HIT already exists in the system
        /// from a previous call using the same <code>UniqueRequestToken</code>,
        /// subsequent calls will return an error with a message containing the request ID.
        /// </p>
        pub fn unique_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.unique_request_token = Some(input.into());
            self
        }
        /// <p>
        /// A unique identifier for this request, which allows you to retry the call on error
        /// without extending the HIT multiple times.
        /// This is useful in cases such as network timeouts where it is unclear whether or not
        /// the call succeeded on the server. If the extend HIT already exists in the system
        /// from a previous call using the same <code>UniqueRequestToken</code>,
        /// subsequent calls will return an error with a message containing the request ID.
        /// </p>
        pub fn set_unique_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.unique_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAdditionalAssignmentsForHitInput`](crate::input::CreateAdditionalAssignmentsForHitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAdditionalAssignmentsForHitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAdditionalAssignmentsForHitInput {
                hit_id: self.hit_id,
                number_of_additional_assignments: self.number_of_additional_assignments,
                unique_request_token: self.unique_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAdditionalAssignmentsForHitInputOperationOutputAlias =
    crate::operation::CreateAdditionalAssignmentsForHIT;
#[doc(hidden)]
pub type CreateAdditionalAssignmentsForHitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAdditionalAssignmentsForHitInput {
    /// Consumes the builder and constructs an Operation<[`CreateAdditionalAssignmentsForHIT`](crate::operation::CreateAdditionalAssignmentsForHIT)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAdditionalAssignmentsForHIT,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAdditionalAssignmentsForHitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAdditionalAssignmentsForHitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAdditionalAssignmentsForHitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.CreateAdditionalAssignmentsForHIT",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_additional_assignments_for_hit(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAdditionalAssignmentsForHIT::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAdditionalAssignmentsForHIT",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAdditionalAssignmentsForHitInput`](crate::input::CreateAdditionalAssignmentsForHitInput)
    pub fn builder() -> crate::input::create_additional_assignments_for_hit_input::Builder {
        crate::input::create_additional_assignments_for_hit_input::Builder::default()
    }
}

/// See [`CreateHitInput`](crate::input::CreateHitInput)
pub mod create_hit_input {
    /// A builder for [`CreateHitInput`](crate::input::CreateHitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_assignments: std::option::Option<i32>,
        pub(crate) auto_approval_delay_in_seconds: std::option::Option<i64>,
        pub(crate) lifetime_in_seconds: std::option::Option<i64>,
        pub(crate) assignment_duration_in_seconds: std::option::Option<i64>,
        pub(crate) reward: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) keywords: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) question: std::option::Option<std::string::String>,
        pub(crate) requester_annotation: std::option::Option<std::string::String>,
        pub(crate) qualification_requirements:
            std::option::Option<std::vec::Vec<crate::model::QualificationRequirement>>,
        pub(crate) unique_request_token: std::option::Option<std::string::String>,
        pub(crate) assignment_review_policy: std::option::Option<crate::model::ReviewPolicy>,
        pub(crate) hit_review_policy: std::option::Option<crate::model::ReviewPolicy>,
        pub(crate) hit_layout_id: std::option::Option<std::string::String>,
        pub(crate) hit_layout_parameters:
            std::option::Option<std::vec::Vec<crate::model::HitLayoutParameter>>,
    }
    impl Builder {
        /// <p>
        /// The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
        /// </p>
        pub fn max_assignments(mut self, input: i32) -> Self {
            self.max_assignments = Some(input);
            self
        }
        /// <p>
        /// The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
        /// </p>
        pub fn set_max_assignments(mut self, input: std::option::Option<i32>) -> Self {
            self.max_assignments = input;
            self
        }
        /// <p>
        /// The number of seconds after an assignment for the HIT has been submitted,
        /// after which the assignment is considered Approved automatically
        /// unless the Requester explicitly rejects it.
        /// </p>
        pub fn auto_approval_delay_in_seconds(mut self, input: i64) -> Self {
            self.auto_approval_delay_in_seconds = Some(input);
            self
        }
        /// <p>
        /// The number of seconds after an assignment for the HIT has been submitted,
        /// after which the assignment is considered Approved automatically
        /// unless the Requester explicitly rejects it.
        /// </p>
        pub fn set_auto_approval_delay_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.auto_approval_delay_in_seconds = input;
            self
        }
        /// <p>
        /// An amount of time, in seconds, after which the HIT is no longer available for users to accept.
        /// After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches,
        /// even if not all of the assignments for the HIT have been accepted.
        /// </p>
        pub fn lifetime_in_seconds(mut self, input: i64) -> Self {
            self.lifetime_in_seconds = Some(input);
            self
        }
        /// <p>
        /// An amount of time, in seconds, after which the HIT is no longer available for users to accept.
        /// After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches,
        /// even if not all of the assignments for the HIT have been accepted.
        /// </p>
        pub fn set_lifetime_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.lifetime_in_seconds = input;
            self
        }
        /// <p>
        /// The amount of time, in seconds, that a Worker has to complete the HIT after accepting it.
        /// If a Worker does not complete the assignment within the specified duration,
        /// the assignment is considered abandoned. If the HIT is still active
        /// (that is, its lifetime has not elapsed), the assignment becomes available
        /// for other users to find and accept.
        /// </p>
        pub fn assignment_duration_in_seconds(mut self, input: i64) -> Self {
            self.assignment_duration_in_seconds = Some(input);
            self
        }
        /// <p>
        /// The amount of time, in seconds, that a Worker has to complete the HIT after accepting it.
        /// If a Worker does not complete the assignment within the specified duration,
        /// the assignment is considered abandoned. If the HIT is still active
        /// (that is, its lifetime has not elapsed), the assignment becomes available
        /// for other users to find and accept.
        /// </p>
        pub fn set_assignment_duration_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.assignment_duration_in_seconds = input;
            self
        }
        /// <p>
        /// The amount of money the Requester will pay a Worker for successfully completing the HIT.
        /// </p>
        pub fn reward(mut self, input: impl Into<std::string::String>) -> Self {
            self.reward = Some(input.into());
            self
        }
        /// <p>
        /// The amount of money the Requester will pay a Worker for successfully completing the HIT.
        /// </p>
        pub fn set_reward(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reward = input;
            self
        }
        /// <p>
        /// The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains.
        /// On the Amazon Mechanical Turk web site, the HIT title appears in search results,
        /// and everywhere the HIT is mentioned.
        /// </p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>
        /// The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains.
        /// On the Amazon Mechanical Turk web site, the HIT title appears in search results,
        /// and everywhere the HIT is mentioned.
        /// </p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>
        /// One or more words or phrases that describe the HIT, separated by commas.
        /// These words are used in searches to find HITs.
        /// </p>
        pub fn keywords(mut self, input: impl Into<std::string::String>) -> Self {
            self.keywords = Some(input.into());
            self
        }
        /// <p>
        /// One or more words or phrases that describe the HIT, separated by commas.
        /// These words are used in searches to find HITs.
        /// </p>
        pub fn set_keywords(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.keywords = input;
            self
        }
        /// <p>
        /// A general description of the HIT. A description includes detailed information about the kind of task
        /// the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded
        /// view of search results, and in the HIT and assignment screens. A good description gives the user enough
        /// information to evaluate the HIT before accepting it.
        /// </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>
        /// A general description of the HIT. A description includes detailed information about the kind of task
        /// the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded
        /// view of search results, and in the HIT and assignment screens. A good description gives the user enough
        /// information to evaluate the HIT before accepting it.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>
        /// The data the person completing the HIT uses to produce the results.
        /// </p>
        /// <p>
        /// Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure,
        /// or an HTMLQuestion data structure. The XML question data must not be larger than
        /// 64 kilobytes (65,535 bytes) in size, including whitespace.
        /// </p>
        /// <p>Either a Question parameter or a HITLayoutId parameter must be provided.</p>
        pub fn question(mut self, input: impl Into<std::string::String>) -> Self {
            self.question = Some(input.into());
            self
        }
        /// <p>
        /// The data the person completing the HIT uses to produce the results.
        /// </p>
        /// <p>
        /// Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure,
        /// or an HTMLQuestion data structure. The XML question data must not be larger than
        /// 64 kilobytes (65,535 bytes) in size, including whitespace.
        /// </p>
        /// <p>Either a Question parameter or a HITLayoutId parameter must be provided.</p>
        pub fn set_question(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.question = input;
            self
        }
        /// <p>
        /// An arbitrary data field.
        /// The RequesterAnnotation parameter lets your application attach arbitrary data
        /// to the HIT for tracking purposes.
        /// For example, this parameter could be an identifier internal to the Requester's application
        /// that corresponds with the HIT.
        /// </p>
        /// <p>
        /// The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT.
        /// It is not shown to the Worker, or any other Requester.
        /// </p>
        /// <p>
        /// The RequesterAnnotation parameter may be different for each HIT you submit.
        /// It does not affect how your HITs are grouped.
        /// </p>
        pub fn requester_annotation(mut self, input: impl Into<std::string::String>) -> Self {
            self.requester_annotation = Some(input.into());
            self
        }
        /// <p>
        /// An arbitrary data field.
        /// The RequesterAnnotation parameter lets your application attach arbitrary data
        /// to the HIT for tracking purposes.
        /// For example, this parameter could be an identifier internal to the Requester's application
        /// that corresponds with the HIT.
        /// </p>
        /// <p>
        /// The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT.
        /// It is not shown to the Worker, or any other Requester.
        /// </p>
        /// <p>
        /// The RequesterAnnotation parameter may be different for each HIT you submit.
        /// It does not affect how your HITs are grouped.
        /// </p>
        pub fn set_requester_annotation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.requester_annotation = input;
            self
        }
        /// Appends an item to `qualification_requirements`.
        ///
        /// To override the contents of this collection use [`set_qualification_requirements`](Self::set_qualification_requirements).
        ///
        /// <p>
        /// Conditions that a Worker's Qualifications must meet in order
        /// to accept the HIT. A HIT can have between zero and ten
        /// Qualification requirements. All requirements must be met in
        /// order for a Worker to accept the HIT. Additionally, other
        /// actions can be restricted using the <code>ActionsGuarded</code>
        /// field on each <code>QualificationRequirement</code> structure.
        /// </p>
        pub fn qualification_requirements(
            mut self,
            input: impl Into<crate::model::QualificationRequirement>,
        ) -> Self {
            let mut v = self.qualification_requirements.unwrap_or_default();
            v.push(input.into());
            self.qualification_requirements = Some(v);
            self
        }
        /// <p>
        /// Conditions that a Worker's Qualifications must meet in order
        /// to accept the HIT. A HIT can have between zero and ten
        /// Qualification requirements. All requirements must be met in
        /// order for a Worker to accept the HIT. Additionally, other
        /// actions can be restricted using the <code>ActionsGuarded</code>
        /// field on each <code>QualificationRequirement</code> structure.
        /// </p>
        pub fn set_qualification_requirements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QualificationRequirement>>,
        ) -> Self {
            self.qualification_requirements = input;
            self
        }
        /// <p>
        /// A unique identifier for this request which allows you to retry the call
        /// on error without creating duplicate HITs.
        /// This is useful in cases such as network timeouts where it is unclear whether or not
        /// the call succeeded on the server.
        /// If the HIT already exists in the system from a previous call using the same UniqueRequestToken,
        /// subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error
        /// with a message containing the HITId.
        /// </p>
        /// <note>
        /// <p>
        /// Note: It is your responsibility to ensure uniqueness of the token.
        /// The unique token expires after 24 hours. Subsequent calls using the same
        /// UniqueRequestToken made after the 24 hour limit could create duplicate HITs.
        /// </p>
        /// </note>
        pub fn unique_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.unique_request_token = Some(input.into());
            self
        }
        /// <p>
        /// A unique identifier for this request which allows you to retry the call
        /// on error without creating duplicate HITs.
        /// This is useful in cases such as network timeouts where it is unclear whether or not
        /// the call succeeded on the server.
        /// If the HIT already exists in the system from a previous call using the same UniqueRequestToken,
        /// subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error
        /// with a message containing the HITId.
        /// </p>
        /// <note>
        /// <p>
        /// Note: It is your responsibility to ensure uniqueness of the token.
        /// The unique token expires after 24 hours. Subsequent calls using the same
        /// UniqueRequestToken made after the 24 hour limit could create duplicate HITs.
        /// </p>
        /// </note>
        pub fn set_unique_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.unique_request_token = input;
            self
        }
        /// <p>
        /// The Assignment-level Review Policy applies to the assignments under the HIT.
        /// You can specify for Mechanical Turk to take various actions based on the policy.
        /// </p>
        pub fn assignment_review_policy(mut self, input: crate::model::ReviewPolicy) -> Self {
            self.assignment_review_policy = Some(input);
            self
        }
        /// <p>
        /// The Assignment-level Review Policy applies to the assignments under the HIT.
        /// You can specify for Mechanical Turk to take various actions based on the policy.
        /// </p>
        pub fn set_assignment_review_policy(
            mut self,
            input: std::option::Option<crate::model::ReviewPolicy>,
        ) -> Self {
            self.assignment_review_policy = input;
            self
        }
        /// <p>
        /// The HIT-level Review Policy applies to the HIT.
        /// You can specify for Mechanical Turk to take various actions based on the policy.
        /// </p>
        pub fn hit_review_policy(mut self, input: crate::model::ReviewPolicy) -> Self {
            self.hit_review_policy = Some(input);
            self
        }
        /// <p>
        /// The HIT-level Review Policy applies to the HIT.
        /// You can specify for Mechanical Turk to take various actions based on the policy.
        /// </p>
        pub fn set_hit_review_policy(
            mut self,
            input: std::option::Option<crate::model::ReviewPolicy>,
        ) -> Self {
            self.hit_review_policy = input;
            self
        }
        /// <p>
        /// The HITLayoutId allows you to use a pre-existing HIT design with placeholder values
        /// and create an additional HIT by providing those values as HITLayoutParameters.
        /// </p>
        /// <p>
        /// Constraints: Either a Question parameter or a HITLayoutId parameter must be provided.
        /// </p>
        pub fn hit_layout_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_layout_id = Some(input.into());
            self
        }
        /// <p>
        /// The HITLayoutId allows you to use a pre-existing HIT design with placeholder values
        /// and create an additional HIT by providing those values as HITLayoutParameters.
        /// </p>
        /// <p>
        /// Constraints: Either a Question parameter or a HITLayoutId parameter must be provided.
        /// </p>
        pub fn set_hit_layout_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hit_layout_id = input;
            self
        }
        /// Appends an item to `hit_layout_parameters`.
        ///
        /// To override the contents of this collection use [`set_hit_layout_parameters`](Self::set_hit_layout_parameters).
        ///
        /// <p>
        /// If the HITLayoutId is provided, any placeholder values must be filled in with values
        /// using the HITLayoutParameter structure. For more information, see HITLayout.
        /// </p>
        pub fn hit_layout_parameters(
            mut self,
            input: impl Into<crate::model::HitLayoutParameter>,
        ) -> Self {
            let mut v = self.hit_layout_parameters.unwrap_or_default();
            v.push(input.into());
            self.hit_layout_parameters = Some(v);
            self
        }
        /// <p>
        /// If the HITLayoutId is provided, any placeholder values must be filled in with values
        /// using the HITLayoutParameter structure. For more information, see HITLayout.
        /// </p>
        pub fn set_hit_layout_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HitLayoutParameter>>,
        ) -> Self {
            self.hit_layout_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHitInput`](crate::input::CreateHitInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CreateHitInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CreateHitInput {
                max_assignments: self.max_assignments,
                auto_approval_delay_in_seconds: self.auto_approval_delay_in_seconds,
                lifetime_in_seconds: self.lifetime_in_seconds,
                assignment_duration_in_seconds: self.assignment_duration_in_seconds,
                reward: self.reward,
                title: self.title,
                keywords: self.keywords,
                description: self.description,
                question: self.question,
                requester_annotation: self.requester_annotation,
                qualification_requirements: self.qualification_requirements,
                unique_request_token: self.unique_request_token,
                assignment_review_policy: self.assignment_review_policy,
                hit_review_policy: self.hit_review_policy,
                hit_layout_id: self.hit_layout_id,
                hit_layout_parameters: self.hit_layout_parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateHitInputOperationOutputAlias = crate::operation::CreateHIT;
#[doc(hidden)]
pub type CreateHitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateHitInput {
    /// Consumes the builder and constructs an Operation<[`CreateHIT`](crate::operation::CreateHIT)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateHIT,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateHitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateHitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateHitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.CreateHIT",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_hit(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CreateHIT::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CreateHIT",
                    "mturk",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateHitInput`](crate::input::CreateHitInput)
    pub fn builder() -> crate::input::create_hit_input::Builder {
        crate::input::create_hit_input::Builder::default()
    }
}

/// See [`CreateHitTypeInput`](crate::input::CreateHitTypeInput)
pub mod create_hit_type_input {
    /// A builder for [`CreateHitTypeInput`](crate::input::CreateHitTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_approval_delay_in_seconds: std::option::Option<i64>,
        pub(crate) assignment_duration_in_seconds: std::option::Option<i64>,
        pub(crate) reward: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) keywords: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) qualification_requirements:
            std::option::Option<std::vec::Vec<crate::model::QualificationRequirement>>,
    }
    impl Builder {
        /// <p>
        /// The number of seconds after an assignment for the HIT has been submitted,
        /// after which the assignment is considered Approved automatically
        /// unless the Requester explicitly rejects it.
        /// </p>
        pub fn auto_approval_delay_in_seconds(mut self, input: i64) -> Self {
            self.auto_approval_delay_in_seconds = Some(input);
            self
        }
        /// <p>
        /// The number of seconds after an assignment for the HIT has been submitted,
        /// after which the assignment is considered Approved automatically
        /// unless the Requester explicitly rejects it.
        /// </p>
        pub fn set_auto_approval_delay_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.auto_approval_delay_in_seconds = input;
            self
        }
        /// <p>
        /// The amount of time, in seconds, that a Worker has to complete the HIT after accepting it.
        /// If a Worker does not complete the assignment within the specified duration,
        /// the assignment is considered abandoned. If the HIT is still active
        /// (that is, its lifetime has not elapsed), the assignment becomes available
        /// for other users to find and accept.
        /// </p>
        pub fn assignment_duration_in_seconds(mut self, input: i64) -> Self {
            self.assignment_duration_in_seconds = Some(input);
            self
        }
        /// <p>
        /// The amount of time, in seconds, that a Worker has to complete the HIT after accepting it.
        /// If a Worker does not complete the assignment within the specified duration,
        /// the assignment is considered abandoned. If the HIT is still active
        /// (that is, its lifetime has not elapsed), the assignment becomes available
        /// for other users to find and accept.
        /// </p>
        pub fn set_assignment_duration_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.assignment_duration_in_seconds = input;
            self
        }
        /// <p>
        /// The amount of money the Requester will pay a Worker for successfully completing the HIT.
        /// </p>
        pub fn reward(mut self, input: impl Into<std::string::String>) -> Self {
            self.reward = Some(input.into());
            self
        }
        /// <p>
        /// The amount of money the Requester will pay a Worker for successfully completing the HIT.
        /// </p>
        pub fn set_reward(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reward = input;
            self
        }
        /// <p>
        /// The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains.
        /// On the Amazon Mechanical Turk web site, the HIT title appears in search results,
        /// and everywhere the HIT is mentioned.
        /// </p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>
        /// The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains.
        /// On the Amazon Mechanical Turk web site, the HIT title appears in search results,
        /// and everywhere the HIT is mentioned.
        /// </p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>
        /// One or more words or phrases that describe the HIT, separated by commas.
        /// These words are used in searches to find HITs.
        /// </p>
        pub fn keywords(mut self, input: impl Into<std::string::String>) -> Self {
            self.keywords = Some(input.into());
            self
        }
        /// <p>
        /// One or more words or phrases that describe the HIT, separated by commas.
        /// These words are used in searches to find HITs.
        /// </p>
        pub fn set_keywords(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.keywords = input;
            self
        }
        /// <p>
        /// A general description of the HIT. A description includes detailed information about the kind of task
        /// the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded
        /// view of search results, and in the HIT and assignment screens. A good description gives the user enough
        /// information to evaluate the HIT before accepting it.
        /// </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>
        /// A general description of the HIT. A description includes detailed information about the kind of task
        /// the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded
        /// view of search results, and in the HIT and assignment screens. A good description gives the user enough
        /// information to evaluate the HIT before accepting it.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `qualification_requirements`.
        ///
        /// To override the contents of this collection use [`set_qualification_requirements`](Self::set_qualification_requirements).
        ///
        /// <p>
        /// Conditions that a Worker's Qualifications must meet in order
        /// to accept the HIT. A HIT can have between zero and ten
        /// Qualification requirements. All requirements must be met in
        /// order for a Worker to accept the HIT. Additionally, other
        /// actions can be restricted using the <code>ActionsGuarded</code>
        /// field on each <code>QualificationRequirement</code> structure.
        /// </p>
        pub fn qualification_requirements(
            mut self,
            input: impl Into<crate::model::QualificationRequirement>,
        ) -> Self {
            let mut v = self.qualification_requirements.unwrap_or_default();
            v.push(input.into());
            self.qualification_requirements = Some(v);
            self
        }
        /// <p>
        /// Conditions that a Worker's Qualifications must meet in order
        /// to accept the HIT. A HIT can have between zero and ten
        /// Qualification requirements. All requirements must be met in
        /// order for a Worker to accept the HIT. Additionally, other
        /// actions can be restricted using the <code>ActionsGuarded</code>
        /// field on each <code>QualificationRequirement</code> structure.
        /// </p>
        pub fn set_qualification_requirements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QualificationRequirement>>,
        ) -> Self {
            self.qualification_requirements = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHitTypeInput`](crate::input::CreateHitTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateHitTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateHitTypeInput {
                auto_approval_delay_in_seconds: self.auto_approval_delay_in_seconds,
                assignment_duration_in_seconds: self.assignment_duration_in_seconds,
                reward: self.reward,
                title: self.title,
                keywords: self.keywords,
                description: self.description,
                qualification_requirements: self.qualification_requirements,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateHitTypeInputOperationOutputAlias = crate::operation::CreateHITType;
#[doc(hidden)]
pub type CreateHitTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateHitTypeInput {
    /// Consumes the builder and constructs an Operation<[`CreateHITType`](crate::operation::CreateHITType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateHITType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateHitTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateHitTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateHitTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.CreateHITType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_hit_type(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateHITType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateHITType",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateHitTypeInput`](crate::input::CreateHitTypeInput)
    pub fn builder() -> crate::input::create_hit_type_input::Builder {
        crate::input::create_hit_type_input::Builder::default()
    }
}

/// See [`CreateHitWithHitTypeInput`](crate::input::CreateHitWithHitTypeInput)
pub mod create_hit_with_hit_type_input {
    /// A builder for [`CreateHitWithHitTypeInput`](crate::input::CreateHitWithHitTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hit_type_id: std::option::Option<std::string::String>,
        pub(crate) max_assignments: std::option::Option<i32>,
        pub(crate) lifetime_in_seconds: std::option::Option<i64>,
        pub(crate) question: std::option::Option<std::string::String>,
        pub(crate) requester_annotation: std::option::Option<std::string::String>,
        pub(crate) unique_request_token: std::option::Option<std::string::String>,
        pub(crate) assignment_review_policy: std::option::Option<crate::model::ReviewPolicy>,
        pub(crate) hit_review_policy: std::option::Option<crate::model::ReviewPolicy>,
        pub(crate) hit_layout_id: std::option::Option<std::string::String>,
        pub(crate) hit_layout_parameters:
            std::option::Option<std::vec::Vec<crate::model::HitLayoutParameter>>,
    }
    impl Builder {
        /// <p>The HIT type ID you want to create this HIT with.</p>
        pub fn hit_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_type_id = Some(input.into());
            self
        }
        /// <p>The HIT type ID you want to create this HIT with.</p>
        pub fn set_hit_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hit_type_id = input;
            self
        }
        /// <p>
        /// The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
        /// </p>
        pub fn max_assignments(mut self, input: i32) -> Self {
            self.max_assignments = Some(input);
            self
        }
        /// <p>
        /// The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
        /// </p>
        pub fn set_max_assignments(mut self, input: std::option::Option<i32>) -> Self {
            self.max_assignments = input;
            self
        }
        /// <p>
        /// An amount of time, in seconds, after which the HIT is no longer available for users to accept.
        /// After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches,
        /// even if not all of the assignments for the HIT have been accepted.
        /// </p>
        pub fn lifetime_in_seconds(mut self, input: i64) -> Self {
            self.lifetime_in_seconds = Some(input);
            self
        }
        /// <p>
        /// An amount of time, in seconds, after which the HIT is no longer available for users to accept.
        /// After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches,
        /// even if not all of the assignments for the HIT have been accepted.
        /// </p>
        pub fn set_lifetime_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.lifetime_in_seconds = input;
            self
        }
        /// <p>
        /// The data the person completing the HIT uses to produce the results.
        /// </p>
        /// <p>
        /// Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure,
        /// or an HTMLQuestion data structure. The XML question data must not be larger than
        /// 64 kilobytes (65,535 bytes) in size, including whitespace.
        /// </p>
        /// <p>Either a Question parameter or a HITLayoutId parameter must be provided.</p>
        pub fn question(mut self, input: impl Into<std::string::String>) -> Self {
            self.question = Some(input.into());
            self
        }
        /// <p>
        /// The data the person completing the HIT uses to produce the results.
        /// </p>
        /// <p>
        /// Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure,
        /// or an HTMLQuestion data structure. The XML question data must not be larger than
        /// 64 kilobytes (65,535 bytes) in size, including whitespace.
        /// </p>
        /// <p>Either a Question parameter or a HITLayoutId parameter must be provided.</p>
        pub fn set_question(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.question = input;
            self
        }
        /// <p>
        /// An arbitrary data field.
        /// The RequesterAnnotation parameter lets your application attach arbitrary data
        /// to the HIT for tracking purposes.
        /// For example, this parameter could be an identifier internal to the Requester's application
        /// that corresponds with the HIT.
        /// </p>
        /// <p>
        /// The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT.
        /// It is not shown to the Worker, or any other Requester.
        /// </p>
        /// <p>
        /// The RequesterAnnotation parameter may be different for each HIT you submit.
        /// It does not affect how your HITs are grouped.
        /// </p>
        pub fn requester_annotation(mut self, input: impl Into<std::string::String>) -> Self {
            self.requester_annotation = Some(input.into());
            self
        }
        /// <p>
        /// An arbitrary data field.
        /// The RequesterAnnotation parameter lets your application attach arbitrary data
        /// to the HIT for tracking purposes.
        /// For example, this parameter could be an identifier internal to the Requester's application
        /// that corresponds with the HIT.
        /// </p>
        /// <p>
        /// The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT.
        /// It is not shown to the Worker, or any other Requester.
        /// </p>
        /// <p>
        /// The RequesterAnnotation parameter may be different for each HIT you submit.
        /// It does not affect how your HITs are grouped.
        /// </p>
        pub fn set_requester_annotation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.requester_annotation = input;
            self
        }
        /// <p>
        /// A unique identifier for this request which allows you to retry the call
        /// on error without creating duplicate HITs.
        /// This is useful in cases such as network timeouts where it is unclear whether or not
        /// the call succeeded on the server.
        /// If the HIT already exists in the system from a previous call using the same UniqueRequestToken,
        /// subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error
        /// with a message containing the HITId.
        /// </p>
        /// <note>
        /// <p>
        /// Note: It is your responsibility to ensure uniqueness of the token.
        /// The unique token expires after 24 hours. Subsequent calls using the same
        /// UniqueRequestToken made after the 24 hour limit could create duplicate HITs.
        /// </p>
        /// </note>
        pub fn unique_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.unique_request_token = Some(input.into());
            self
        }
        /// <p>
        /// A unique identifier for this request which allows you to retry the call
        /// on error without creating duplicate HITs.
        /// This is useful in cases such as network timeouts where it is unclear whether or not
        /// the call succeeded on the server.
        /// If the HIT already exists in the system from a previous call using the same UniqueRequestToken,
        /// subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error
        /// with a message containing the HITId.
        /// </p>
        /// <note>
        /// <p>
        /// Note: It is your responsibility to ensure uniqueness of the token.
        /// The unique token expires after 24 hours. Subsequent calls using the same
        /// UniqueRequestToken made after the 24 hour limit could create duplicate HITs.
        /// </p>
        /// </note>
        pub fn set_unique_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.unique_request_token = input;
            self
        }
        /// <p>
        /// The Assignment-level Review Policy applies to the assignments under the HIT.
        /// You can specify for Mechanical Turk to take various actions based on the policy.
        /// </p>
        pub fn assignment_review_policy(mut self, input: crate::model::ReviewPolicy) -> Self {
            self.assignment_review_policy = Some(input);
            self
        }
        /// <p>
        /// The Assignment-level Review Policy applies to the assignments under the HIT.
        /// You can specify for Mechanical Turk to take various actions based on the policy.
        /// </p>
        pub fn set_assignment_review_policy(
            mut self,
            input: std::option::Option<crate::model::ReviewPolicy>,
        ) -> Self {
            self.assignment_review_policy = input;
            self
        }
        /// <p>
        /// The HIT-level Review Policy applies to the HIT.
        /// You can specify for Mechanical Turk to take various actions based on the policy.
        /// </p>
        pub fn hit_review_policy(mut self, input: crate::model::ReviewPolicy) -> Self {
            self.hit_review_policy = Some(input);
            self
        }
        /// <p>
        /// The HIT-level Review Policy applies to the HIT.
        /// You can specify for Mechanical Turk to take various actions based on the policy.
        /// </p>
        pub fn set_hit_review_policy(
            mut self,
            input: std::option::Option<crate::model::ReviewPolicy>,
        ) -> Self {
            self.hit_review_policy = input;
            self
        }
        /// <p>
        /// The HITLayoutId allows you to use a pre-existing HIT design with placeholder values
        /// and create an additional HIT by providing those values as HITLayoutParameters.
        /// </p>
        /// <p>
        /// Constraints: Either a Question parameter or a HITLayoutId parameter must be provided.
        /// </p>
        pub fn hit_layout_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_layout_id = Some(input.into());
            self
        }
        /// <p>
        /// The HITLayoutId allows you to use a pre-existing HIT design with placeholder values
        /// and create an additional HIT by providing those values as HITLayoutParameters.
        /// </p>
        /// <p>
        /// Constraints: Either a Question parameter or a HITLayoutId parameter must be provided.
        /// </p>
        pub fn set_hit_layout_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hit_layout_id = input;
            self
        }
        /// Appends an item to `hit_layout_parameters`.
        ///
        /// To override the contents of this collection use [`set_hit_layout_parameters`](Self::set_hit_layout_parameters).
        ///
        /// <p>
        /// If the HITLayoutId is provided, any placeholder values must be filled in with values
        /// using the HITLayoutParameter structure. For more information, see HITLayout.
        /// </p>
        pub fn hit_layout_parameters(
            mut self,
            input: impl Into<crate::model::HitLayoutParameter>,
        ) -> Self {
            let mut v = self.hit_layout_parameters.unwrap_or_default();
            v.push(input.into());
            self.hit_layout_parameters = Some(v);
            self
        }
        /// <p>
        /// If the HITLayoutId is provided, any placeholder values must be filled in with values
        /// using the HITLayoutParameter structure. For more information, see HITLayout.
        /// </p>
        pub fn set_hit_layout_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HitLayoutParameter>>,
        ) -> Self {
            self.hit_layout_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHitWithHitTypeInput`](crate::input::CreateHitWithHitTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateHitWithHitTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateHitWithHitTypeInput {
                hit_type_id: self.hit_type_id,
                max_assignments: self.max_assignments,
                lifetime_in_seconds: self.lifetime_in_seconds,
                question: self.question,
                requester_annotation: self.requester_annotation,
                unique_request_token: self.unique_request_token,
                assignment_review_policy: self.assignment_review_policy,
                hit_review_policy: self.hit_review_policy,
                hit_layout_id: self.hit_layout_id,
                hit_layout_parameters: self.hit_layout_parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateHitWithHitTypeInputOperationOutputAlias = crate::operation::CreateHITWithHITType;
#[doc(hidden)]
pub type CreateHitWithHitTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateHitWithHitTypeInput {
    /// Consumes the builder and constructs an Operation<[`CreateHITWithHITType`](crate::operation::CreateHITWithHITType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateHITWithHITType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateHitWithHitTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateHitWithHitTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateHitWithHitTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.CreateHITWithHITType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_hit_with_hit_type(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateHITWithHITType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateHITWithHITType",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateHitWithHitTypeInput`](crate::input::CreateHitWithHitTypeInput)
    pub fn builder() -> crate::input::create_hit_with_hit_type_input::Builder {
        crate::input::create_hit_with_hit_type_input::Builder::default()
    }
}

/// See [`CreateQualificationTypeInput`](crate::input::CreateQualificationTypeInput)
pub mod create_qualification_type_input {
    /// A builder for [`CreateQualificationTypeInput`](crate::input::CreateQualificationTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) keywords: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) qualification_type_status:
            std::option::Option<crate::model::QualificationTypeStatus>,
        pub(crate) retry_delay_in_seconds: std::option::Option<i64>,
        pub(crate) test: std::option::Option<std::string::String>,
        pub(crate) answer_key: std::option::Option<std::string::String>,
        pub(crate) test_duration_in_seconds: std::option::Option<i64>,
        pub(crate) auto_granted: std::option::Option<bool>,
        pub(crate) auto_granted_value: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The name you give to the Qualification type. The type name
        /// is used to represent the Qualification to Workers, and to find the
        /// type using a Qualification type search. It must be unique across all
        /// of your Qualification types.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name you give to the Qualification type. The type name
        /// is used to represent the Qualification to Workers, and to find the
        /// type using a Qualification type search. It must be unique across all
        /// of your Qualification types.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>One or more words or phrases that describe the Qualification
        /// type, separated by commas. The keywords of a type make the type
        /// easier to find during a search.</p>
        pub fn keywords(mut self, input: impl Into<std::string::String>) -> Self {
            self.keywords = Some(input.into());
            self
        }
        /// <p>One or more words or phrases that describe the Qualification
        /// type, separated by commas. The keywords of a type make the type
        /// easier to find during a search.</p>
        pub fn set_keywords(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.keywords = input;
            self
        }
        /// <p>A long description for the Qualification type. On the Amazon
        /// Mechanical Turk website, the long description is displayed when a
        /// Worker examines a Qualification type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A long description for the Qualification type. On the Amazon
        /// Mechanical Turk website, the long description is displayed when a
        /// Worker examines a Qualification type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The initial status of the Qualification type.</p>
        /// <p>Constraints: Valid values are: Active | Inactive</p>
        pub fn qualification_type_status(
            mut self,
            input: crate::model::QualificationTypeStatus,
        ) -> Self {
            self.qualification_type_status = Some(input);
            self
        }
        /// <p>The initial status of the Qualification type.</p>
        /// <p>Constraints: Valid values are: Active | Inactive</p>
        pub fn set_qualification_type_status(
            mut self,
            input: std::option::Option<crate::model::QualificationTypeStatus>,
        ) -> Self {
            self.qualification_type_status = input;
            self
        }
        /// <p>The number of seconds that a Worker must wait after
        /// requesting a Qualification of the Qualification type before the
        /// worker can retry the Qualification request.</p>
        /// <p>Constraints: None. If not specified, retries are disabled and
        /// Workers can request a Qualification of this type only once, even if
        /// the Worker has not been granted the Qualification. It is not possible
        /// to disable retries for a Qualification type after it has been created
        /// with retries enabled. If you want to disable retries, you must delete
        /// existing retry-enabled Qualification type and then create a new
        /// Qualification type with retries disabled.</p>
        pub fn retry_delay_in_seconds(mut self, input: i64) -> Self {
            self.retry_delay_in_seconds = Some(input);
            self
        }
        /// <p>The number of seconds that a Worker must wait after
        /// requesting a Qualification of the Qualification type before the
        /// worker can retry the Qualification request.</p>
        /// <p>Constraints: None. If not specified, retries are disabled and
        /// Workers can request a Qualification of this type only once, even if
        /// the Worker has not been granted the Qualification. It is not possible
        /// to disable retries for a Qualification type after it has been created
        /// with retries enabled. If you want to disable retries, you must delete
        /// existing retry-enabled Qualification type and then create a new
        /// Qualification type with retries disabled.</p>
        pub fn set_retry_delay_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.retry_delay_in_seconds = input;
            self
        }
        /// <p>
        /// The questions for the Qualification test a Worker must answer
        /// correctly to obtain a Qualification of this type. If this parameter
        /// is specified,
        /// <code>TestDurationInSeconds</code>
        /// must also be specified.
        /// </p>
        /// <p>Constraints: Must not be longer than 65535 bytes. Must be a
        /// QuestionForm data structure. This parameter cannot be specified if
        /// AutoGranted is true.</p>
        /// <p>Constraints: None. If not specified, the Worker may request
        /// the Qualification without answering any questions.</p>
        pub fn test(mut self, input: impl Into<std::string::String>) -> Self {
            self.test = Some(input.into());
            self
        }
        /// <p>
        /// The questions for the Qualification test a Worker must answer
        /// correctly to obtain a Qualification of this type. If this parameter
        /// is specified,
        /// <code>TestDurationInSeconds</code>
        /// must also be specified.
        /// </p>
        /// <p>Constraints: Must not be longer than 65535 bytes. Must be a
        /// QuestionForm data structure. This parameter cannot be specified if
        /// AutoGranted is true.</p>
        /// <p>Constraints: None. If not specified, the Worker may request
        /// the Qualification without answering any questions.</p>
        pub fn set_test(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.test = input;
            self
        }
        /// <p>The answers to the Qualification test specified in the Test
        /// parameter, in the form of an AnswerKey data structure.</p>
        /// <p>Constraints: Must not be longer than 65535 bytes.</p>
        /// <p>Constraints: None. If not specified, you must process
        /// Qualification requests manually.</p>
        pub fn answer_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.answer_key = Some(input.into());
            self
        }
        /// <p>The answers to the Qualification test specified in the Test
        /// parameter, in the form of an AnswerKey data structure.</p>
        /// <p>Constraints: Must not be longer than 65535 bytes.</p>
        /// <p>Constraints: None. If not specified, you must process
        /// Qualification requests manually.</p>
        pub fn set_answer_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.answer_key = input;
            self
        }
        /// <p>The number of seconds the Worker has to complete the
        /// Qualification test, starting from the time the Worker requests the
        /// Qualification.</p>
        pub fn test_duration_in_seconds(mut self, input: i64) -> Self {
            self.test_duration_in_seconds = Some(input);
            self
        }
        /// <p>The number of seconds the Worker has to complete the
        /// Qualification test, starting from the time the Worker requests the
        /// Qualification.</p>
        pub fn set_test_duration_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.test_duration_in_seconds = input;
            self
        }
        /// <p>Specifies whether requests for the Qualification type are
        /// granted immediately, without prompting the Worker with a
        /// Qualification test.</p>
        /// <p>Constraints: If the Test parameter is specified, this
        /// parameter cannot be true.</p>
        pub fn auto_granted(mut self, input: bool) -> Self {
            self.auto_granted = Some(input);
            self
        }
        /// <p>Specifies whether requests for the Qualification type are
        /// granted immediately, without prompting the Worker with a
        /// Qualification test.</p>
        /// <p>Constraints: If the Test parameter is specified, this
        /// parameter cannot be true.</p>
        pub fn set_auto_granted(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_granted = input;
            self
        }
        /// <p>The Qualification value to use for automatically granted
        /// Qualifications. This parameter is used only if the AutoGranted
        /// parameter is true.</p>
        pub fn auto_granted_value(mut self, input: i32) -> Self {
            self.auto_granted_value = Some(input);
            self
        }
        /// <p>The Qualification value to use for automatically granted
        /// Qualifications. This parameter is used only if the AutoGranted
        /// parameter is true.</p>
        pub fn set_auto_granted_value(mut self, input: std::option::Option<i32>) -> Self {
            self.auto_granted_value = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateQualificationTypeInput`](crate::input::CreateQualificationTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateQualificationTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateQualificationTypeInput {
                name: self.name,
                keywords: self.keywords,
                description: self.description,
                qualification_type_status: self.qualification_type_status,
                retry_delay_in_seconds: self.retry_delay_in_seconds,
                test: self.test,
                answer_key: self.answer_key,
                test_duration_in_seconds: self.test_duration_in_seconds,
                auto_granted: self.auto_granted,
                auto_granted_value: self.auto_granted_value,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateQualificationTypeInputOperationOutputAlias =
    crate::operation::CreateQualificationType;
#[doc(hidden)]
pub type CreateQualificationTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateQualificationTypeInput {
    /// Consumes the builder and constructs an Operation<[`CreateQualificationType`](crate::operation::CreateQualificationType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateQualificationType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateQualificationTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateQualificationTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateQualificationTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.CreateQualificationType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_qualification_type(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateQualificationType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateQualificationType",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateQualificationTypeInput`](crate::input::CreateQualificationTypeInput)
    pub fn builder() -> crate::input::create_qualification_type_input::Builder {
        crate::input::create_qualification_type_input::Builder::default()
    }
}

/// See [`CreateWorkerBlockInput`](crate::input::CreateWorkerBlockInput)
pub mod create_worker_block_input {
    /// A builder for [`CreateWorkerBlockInput`](crate::input::CreateWorkerBlockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) worker_id: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Worker to block.</p>
        pub fn worker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_id = Some(input.into());
            self
        }
        /// <p>The ID of the Worker to block.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.worker_id = input;
            self
        }
        /// <p>A message explaining the reason for blocking the Worker. This parameter enables you to keep track of your Workers. The Worker does not see this message.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>A message explaining the reason for blocking the Worker. This parameter enables you to keep track of your Workers. The Worker does not see this message.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkerBlockInput`](crate::input::CreateWorkerBlockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWorkerBlockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWorkerBlockInput {
                worker_id: self.worker_id,
                reason: self.reason,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWorkerBlockInputOperationOutputAlias = crate::operation::CreateWorkerBlock;
#[doc(hidden)]
pub type CreateWorkerBlockInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateWorkerBlockInput {
    /// Consumes the builder and constructs an Operation<[`CreateWorkerBlock`](crate::operation::CreateWorkerBlock)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWorkerBlock,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateWorkerBlockInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateWorkerBlockInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateWorkerBlockInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.CreateWorkerBlock",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_worker_block(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWorkerBlock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWorkerBlock",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateWorkerBlockInput`](crate::input::CreateWorkerBlockInput)
    pub fn builder() -> crate::input::create_worker_block_input::Builder {
        crate::input::create_worker_block_input::Builder::default()
    }
}

/// See [`DeleteHitInput`](crate::input::DeleteHitInput)
pub mod delete_hit_input {
    /// A builder for [`DeleteHitInput`](crate::input::DeleteHitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hit_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the HIT to be deleted.</p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_id = Some(input.into());
            self
        }
        /// <p>The ID of the HIT to be deleted.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hit_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteHitInput`](crate::input::DeleteHitInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteHitInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteHitInput {
                hit_id: self.hit_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteHitInputOperationOutputAlias = crate::operation::DeleteHIT;
#[doc(hidden)]
pub type DeleteHitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteHitInput {
    /// Consumes the builder and constructs an Operation<[`DeleteHIT`](crate::operation::DeleteHIT)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteHIT,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteHitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteHitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteHitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.DeleteHIT",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_hit(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteHIT::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteHIT",
                    "mturk",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteHitInput`](crate::input::DeleteHitInput)
    pub fn builder() -> crate::input::delete_hit_input::Builder {
        crate::input::delete_hit_input::Builder::default()
    }
}

/// See [`DeleteQualificationTypeInput`](crate::input::DeleteQualificationTypeInput)
pub mod delete_qualification_type_input {
    /// A builder for [`DeleteQualificationTypeInput`](crate::input::DeleteQualificationTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) qualification_type_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the QualificationType to dispose.</p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualification_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the QualificationType to dispose.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.qualification_type_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteQualificationTypeInput`](crate::input::DeleteQualificationTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteQualificationTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteQualificationTypeInput {
                qualification_type_id: self.qualification_type_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteQualificationTypeInputOperationOutputAlias =
    crate::operation::DeleteQualificationType;
#[doc(hidden)]
pub type DeleteQualificationTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteQualificationTypeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteQualificationType`](crate::operation::DeleteQualificationType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteQualificationType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteQualificationTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteQualificationTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteQualificationTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.DeleteQualificationType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_qualification_type(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteQualificationType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteQualificationType",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteQualificationTypeInput`](crate::input::DeleteQualificationTypeInput)
    pub fn builder() -> crate::input::delete_qualification_type_input::Builder {
        crate::input::delete_qualification_type_input::Builder::default()
    }
}

/// See [`DeleteWorkerBlockInput`](crate::input::DeleteWorkerBlockInput)
pub mod delete_worker_block_input {
    /// A builder for [`DeleteWorkerBlockInput`](crate::input::DeleteWorkerBlockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) worker_id: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Worker to unblock.</p>
        pub fn worker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_id = Some(input.into());
            self
        }
        /// <p>The ID of the Worker to unblock.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.worker_id = input;
            self
        }
        /// <p>A message that explains the reason for unblocking the Worker. The Worker does not see this message.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>A message that explains the reason for unblocking the Worker. The Worker does not see this message.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWorkerBlockInput`](crate::input::DeleteWorkerBlockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWorkerBlockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWorkerBlockInput {
                worker_id: self.worker_id,
                reason: self.reason,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteWorkerBlockInputOperationOutputAlias = crate::operation::DeleteWorkerBlock;
#[doc(hidden)]
pub type DeleteWorkerBlockInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteWorkerBlockInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWorkerBlock`](crate::operation::DeleteWorkerBlock)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWorkerBlock,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteWorkerBlockInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteWorkerBlockInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteWorkerBlockInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.DeleteWorkerBlock",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_worker_block(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWorkerBlock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWorkerBlock",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteWorkerBlockInput`](crate::input::DeleteWorkerBlockInput)
    pub fn builder() -> crate::input::delete_worker_block_input::Builder {
        crate::input::delete_worker_block_input::Builder::default()
    }
}

/// See [`DisassociateQualificationFromWorkerInput`](crate::input::DisassociateQualificationFromWorkerInput)
pub mod disassociate_qualification_from_worker_input {
    /// A builder for [`DisassociateQualificationFromWorkerInput`](crate::input::DisassociateQualificationFromWorkerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) worker_id: std::option::Option<std::string::String>,
        pub(crate) qualification_type_id: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Worker who possesses the Qualification to be revoked.</p>
        pub fn worker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_id = Some(input.into());
            self
        }
        /// <p>The ID of the Worker who possesses the Qualification to be revoked.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.worker_id = input;
            self
        }
        /// <p>The ID of the Qualification type of the Qualification to be revoked.</p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualification_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the Qualification type of the Qualification to be revoked.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.qualification_type_id = input;
            self
        }
        /// <p>A text message that explains why the Qualification was revoked. The user who had the Qualification sees this message.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>A text message that explains why the Qualification was revoked. The user who had the Qualification sees this message.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateQualificationFromWorkerInput`](crate::input::DisassociateQualificationFromWorkerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateQualificationFromWorkerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateQualificationFromWorkerInput {
                worker_id: self.worker_id,
                qualification_type_id: self.qualification_type_id,
                reason: self.reason,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateQualificationFromWorkerInputOperationOutputAlias =
    crate::operation::DisassociateQualificationFromWorker;
#[doc(hidden)]
pub type DisassociateQualificationFromWorkerInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DisassociateQualificationFromWorkerInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateQualificationFromWorker`](crate::operation::DisassociateQualificationFromWorker)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateQualificationFromWorker,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateQualificationFromWorkerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateQualificationFromWorkerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateQualificationFromWorkerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.DisassociateQualificationFromWorker",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_qualification_from_worker(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateQualificationFromWorker::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateQualificationFromWorker",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateQualificationFromWorkerInput`](crate::input::DisassociateQualificationFromWorkerInput)
    pub fn builder() -> crate::input::disassociate_qualification_from_worker_input::Builder {
        crate::input::disassociate_qualification_from_worker_input::Builder::default()
    }
}

/// See [`GetAccountBalanceInput`](crate::input::GetAccountBalanceInput)
pub mod get_account_balance_input {
    /// A builder for [`GetAccountBalanceInput`](crate::input::GetAccountBalanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetAccountBalanceInput`](crate::input::GetAccountBalanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccountBalanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccountBalanceInput {})
        }
    }
}
#[doc(hidden)]
pub type GetAccountBalanceInputOperationOutputAlias = crate::operation::GetAccountBalance;
#[doc(hidden)]
pub type GetAccountBalanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAccountBalanceInput {
    /// Consumes the builder and constructs an Operation<[`GetAccountBalance`](crate::operation::GetAccountBalance)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccountBalance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccountBalanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccountBalanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccountBalanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.GetAccountBalance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_account_balance(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccountBalance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccountBalance",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccountBalanceInput`](crate::input::GetAccountBalanceInput)
    pub fn builder() -> crate::input::get_account_balance_input::Builder {
        crate::input::get_account_balance_input::Builder::default()
    }
}

/// See [`GetAssignmentInput`](crate::input::GetAssignmentInput)
pub mod get_assignment_input {
    /// A builder for [`GetAssignmentInput`](crate::input::GetAssignmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assignment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Assignment to be retrieved.</p>
        pub fn assignment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_id = Some(input.into());
            self
        }
        /// <p>The ID of the Assignment to be retrieved.</p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssignmentInput`](crate::input::GetAssignmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAssignmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAssignmentInput {
                assignment_id: self.assignment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAssignmentInputOperationOutputAlias = crate::operation::GetAssignment;
#[doc(hidden)]
pub type GetAssignmentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAssignmentInput {
    /// Consumes the builder and constructs an Operation<[`GetAssignment`](crate::operation::GetAssignment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAssignment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAssignmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAssignmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAssignmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.GetAssignment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_assignment(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAssignment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAssignment",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAssignmentInput`](crate::input::GetAssignmentInput)
    pub fn builder() -> crate::input::get_assignment_input::Builder {
        crate::input::get_assignment_input::Builder::default()
    }
}

/// See [`GetFileUploadUrlInput`](crate::input::GetFileUploadUrlInput)
pub mod get_file_upload_url_input {
    /// A builder for [`GetFileUploadUrlInput`](crate::input::GetFileUploadUrlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assignment_id: std::option::Option<std::string::String>,
        pub(crate) question_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the assignment that contains the question with a
        /// FileUploadAnswer.</p>
        pub fn assignment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_id = Some(input.into());
            self
        }
        /// <p>The ID of the assignment that contains the question with a
        /// FileUploadAnswer.</p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_id = input;
            self
        }
        /// <p>The identifier of the question with a FileUploadAnswer, as
        /// specified in the QuestionForm of the HIT.</p>
        pub fn question_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.question_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the question with a FileUploadAnswer, as
        /// specified in the QuestionForm of the HIT.</p>
        pub fn set_question_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.question_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFileUploadUrlInput`](crate::input::GetFileUploadUrlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFileUploadUrlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFileUploadUrlInput {
                assignment_id: self.assignment_id,
                question_identifier: self.question_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFileUploadUrlInputOperationOutputAlias = crate::operation::GetFileUploadURL;
#[doc(hidden)]
pub type GetFileUploadUrlInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetFileUploadUrlInput {
    /// Consumes the builder and constructs an Operation<[`GetFileUploadURL`](crate::operation::GetFileUploadURL)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFileUploadURL,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFileUploadUrlInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFileUploadUrlInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFileUploadUrlInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.GetFileUploadURL",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_file_upload_url(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFileUploadURL::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFileUploadURL",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFileUploadUrlInput`](crate::input::GetFileUploadUrlInput)
    pub fn builder() -> crate::input::get_file_upload_url_input::Builder {
        crate::input::get_file_upload_url_input::Builder::default()
    }
}

/// See [`GetHitInput`](crate::input::GetHitInput)
pub mod get_hit_input {
    /// A builder for [`GetHitInput`](crate::input::GetHitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hit_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the HIT to be retrieved.</p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_id = Some(input.into());
            self
        }
        /// <p>The ID of the HIT to be retrieved.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hit_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetHitInput`](crate::input::GetHitInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetHitInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetHitInput {
                hit_id: self.hit_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetHitInputOperationOutputAlias = crate::operation::GetHIT;
#[doc(hidden)]
pub type GetHitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetHitInput {
    /// Consumes the builder and constructs an Operation<[`GetHIT`](crate::operation::GetHIT)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetHIT,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetHitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetHitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetHitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.GetHIT",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_hit(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetHIT::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("GetHIT", "mturk"));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetHitInput`](crate::input::GetHitInput)
    pub fn builder() -> crate::input::get_hit_input::Builder {
        crate::input::get_hit_input::Builder::default()
    }
}

/// See [`GetQualificationScoreInput`](crate::input::GetQualificationScoreInput)
pub mod get_qualification_score_input {
    /// A builder for [`GetQualificationScoreInput`](crate::input::GetQualificationScoreInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) qualification_type_id: std::option::Option<std::string::String>,
        pub(crate) worker_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the QualificationType.</p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualification_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the QualificationType.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.qualification_type_id = input;
            self
        }
        /// <p>The ID of the Worker whose Qualification is being updated.</p>
        pub fn worker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_id = Some(input.into());
            self
        }
        /// <p>The ID of the Worker whose Qualification is being updated.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.worker_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetQualificationScoreInput`](crate::input::GetQualificationScoreInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetQualificationScoreInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetQualificationScoreInput {
                qualification_type_id: self.qualification_type_id,
                worker_id: self.worker_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetQualificationScoreInputOperationOutputAlias = crate::operation::GetQualificationScore;
#[doc(hidden)]
pub type GetQualificationScoreInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetQualificationScoreInput {
    /// Consumes the builder and constructs an Operation<[`GetQualificationScore`](crate::operation::GetQualificationScore)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetQualificationScore,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetQualificationScoreInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetQualificationScoreInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetQualificationScoreInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.GetQualificationScore",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_qualification_score(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetQualificationScore::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetQualificationScore",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetQualificationScoreInput`](crate::input::GetQualificationScoreInput)
    pub fn builder() -> crate::input::get_qualification_score_input::Builder {
        crate::input::get_qualification_score_input::Builder::default()
    }
}

/// See [`GetQualificationTypeInput`](crate::input::GetQualificationTypeInput)
pub mod get_qualification_type_input {
    /// A builder for [`GetQualificationTypeInput`](crate::input::GetQualificationTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) qualification_type_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the QualificationType.</p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualification_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the QualificationType.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.qualification_type_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetQualificationTypeInput`](crate::input::GetQualificationTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetQualificationTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetQualificationTypeInput {
                qualification_type_id: self.qualification_type_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetQualificationTypeInputOperationOutputAlias = crate::operation::GetQualificationType;
#[doc(hidden)]
pub type GetQualificationTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetQualificationTypeInput {
    /// Consumes the builder and constructs an Operation<[`GetQualificationType`](crate::operation::GetQualificationType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetQualificationType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetQualificationTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetQualificationTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetQualificationTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.GetQualificationType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_qualification_type(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetQualificationType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetQualificationType",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetQualificationTypeInput`](crate::input::GetQualificationTypeInput)
    pub fn builder() -> crate::input::get_qualification_type_input::Builder {
        crate::input::get_qualification_type_input::Builder::default()
    }
}

/// See [`ListAssignmentsForHitInput`](crate::input::ListAssignmentsForHitInput)
pub mod list_assignments_for_hit_input {
    /// A builder for [`ListAssignmentsForHitInput`](crate::input::ListAssignmentsForHitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hit_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) assignment_statuses:
            std::option::Option<std::vec::Vec<crate::model::AssignmentStatus>>,
    }
    impl Builder {
        /// <p>The ID of the HIT.</p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_id = Some(input.into());
            self
        }
        /// <p>The ID of the HIT.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hit_id = input;
            self
        }
        /// <p>Pagination token</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `assignment_statuses`.
        ///
        /// To override the contents of this collection use [`set_assignment_statuses`](Self::set_assignment_statuses).
        ///
        /// <p>The status of the assignments to return: Submitted | Approved
        /// | Rejected</p>
        pub fn assignment_statuses(
            mut self,
            input: impl Into<crate::model::AssignmentStatus>,
        ) -> Self {
            let mut v = self.assignment_statuses.unwrap_or_default();
            v.push(input.into());
            self.assignment_statuses = Some(v);
            self
        }
        /// <p>The status of the assignments to return: Submitted | Approved
        /// | Rejected</p>
        pub fn set_assignment_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssignmentStatus>>,
        ) -> Self {
            self.assignment_statuses = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssignmentsForHitInput`](crate::input::ListAssignmentsForHitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssignmentsForHitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssignmentsForHitInput {
                hit_id: self.hit_id,
                next_token: self.next_token,
                max_results: self.max_results,
                assignment_statuses: self.assignment_statuses,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssignmentsForHitInputOperationOutputAlias = crate::operation::ListAssignmentsForHIT;
#[doc(hidden)]
pub type ListAssignmentsForHitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAssignmentsForHitInput {
    /// Consumes the builder and constructs an Operation<[`ListAssignmentsForHIT`](crate::operation::ListAssignmentsForHIT)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssignmentsForHIT,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAssignmentsForHitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAssignmentsForHitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAssignmentsForHitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.ListAssignmentsForHIT",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_assignments_for_hit(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssignmentsForHIT::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssignmentsForHIT",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAssignmentsForHitInput`](crate::input::ListAssignmentsForHitInput)
    pub fn builder() -> crate::input::list_assignments_for_hit_input::Builder {
        crate::input::list_assignments_for_hit_input::Builder::default()
    }
}

/// See [`ListBonusPaymentsInput`](crate::input::ListBonusPaymentsInput)
pub mod list_bonus_payments_input {
    /// A builder for [`ListBonusPaymentsInput`](crate::input::ListBonusPaymentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hit_id: std::option::Option<std::string::String>,
        pub(crate) assignment_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the HIT associated with the bonus payments to
        /// retrieve. If not specified, all bonus payments for all assignments
        /// for the given HIT are returned. Either the HITId parameter or the
        /// AssignmentId parameter must be specified</p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_id = Some(input.into());
            self
        }
        /// <p>The ID of the HIT associated with the bonus payments to
        /// retrieve. If not specified, all bonus payments for all assignments
        /// for the given HIT are returned. Either the HITId parameter or the
        /// AssignmentId parameter must be specified</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hit_id = input;
            self
        }
        /// <p>The ID of the assignment associated with the bonus payments
        /// to retrieve. If specified, only bonus payments for the given
        /// assignment are returned. Either the HITId parameter or the
        /// AssignmentId parameter must be specified</p>
        pub fn assignment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_id = Some(input.into());
            self
        }
        /// <p>The ID of the assignment associated with the bonus payments
        /// to retrieve. If specified, only bonus payments for the given
        /// assignment are returned. Either the HITId parameter or the
        /// AssignmentId parameter must be specified</p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_id = input;
            self
        }
        /// <p>Pagination token</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBonusPaymentsInput`](crate::input::ListBonusPaymentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBonusPaymentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBonusPaymentsInput {
                hit_id: self.hit_id,
                assignment_id: self.assignment_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBonusPaymentsInputOperationOutputAlias = crate::operation::ListBonusPayments;
#[doc(hidden)]
pub type ListBonusPaymentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListBonusPaymentsInput {
    /// Consumes the builder and constructs an Operation<[`ListBonusPayments`](crate::operation::ListBonusPayments)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBonusPayments,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBonusPaymentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBonusPaymentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBonusPaymentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.ListBonusPayments",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_bonus_payments(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBonusPayments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBonusPayments",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBonusPaymentsInput`](crate::input::ListBonusPaymentsInput)
    pub fn builder() -> crate::input::list_bonus_payments_input::Builder {
        crate::input::list_bonus_payments_input::Builder::default()
    }
}

/// See [`ListHiTsInput`](crate::input::ListHiTsInput)
pub mod list_hi_ts_input {
    /// A builder for [`ListHiTsInput`](crate::input::ListHiTsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Pagination token</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHiTsInput`](crate::input::ListHiTsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListHiTsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListHiTsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListHiTsInputOperationOutputAlias = crate::operation::ListHITs;
#[doc(hidden)]
pub type ListHiTsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListHiTsInput {
    /// Consumes the builder and constructs an Operation<[`ListHITs`](crate::operation::ListHITs)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListHITs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListHiTsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListHiTsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListHiTsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.ListHITs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_hi_ts(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListHITs::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListHITs", "mturk",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListHiTsInput`](crate::input::ListHiTsInput)
    pub fn builder() -> crate::input::list_hi_ts_input::Builder {
        crate::input::list_hi_ts_input::Builder::default()
    }
}

/// See [`ListHiTsForQualificationTypeInput`](crate::input::ListHiTsForQualificationTypeInput)
pub mod list_hi_ts_for_qualification_type_input {
    /// A builder for [`ListHiTsForQualificationTypeInput`](crate::input::ListHiTsForQualificationTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) qualification_type_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>
        /// The ID of the Qualification type to use when querying HITs.
        /// </p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualification_type_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the Qualification type to use when querying HITs.
        /// </p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.qualification_type_id = input;
            self
        }
        /// <p>Pagination Token</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination Token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>
        /// Limit the number of results returned.
        /// </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>
        /// Limit the number of results returned.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHiTsForQualificationTypeInput`](crate::input::ListHiTsForQualificationTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListHiTsForQualificationTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListHiTsForQualificationTypeInput {
                qualification_type_id: self.qualification_type_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListHiTsForQualificationTypeInputOperationOutputAlias =
    crate::operation::ListHITsForQualificationType;
#[doc(hidden)]
pub type ListHiTsForQualificationTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListHiTsForQualificationTypeInput {
    /// Consumes the builder and constructs an Operation<[`ListHITsForQualificationType`](crate::operation::ListHITsForQualificationType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListHITsForQualificationType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListHiTsForQualificationTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListHiTsForQualificationTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListHiTsForQualificationTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.ListHITsForQualificationType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_hi_ts_for_qualification_type(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListHITsForQualificationType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListHITsForQualificationType",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListHiTsForQualificationTypeInput`](crate::input::ListHiTsForQualificationTypeInput)
    pub fn builder() -> crate::input::list_hi_ts_for_qualification_type_input::Builder {
        crate::input::list_hi_ts_for_qualification_type_input::Builder::default()
    }
}

/// See [`ListQualificationRequestsInput`](crate::input::ListQualificationRequestsInput)
pub mod list_qualification_requests_input {
    /// A builder for [`ListQualificationRequestsInput`](crate::input::ListQualificationRequestsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) qualification_type_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the QualificationType.</p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualification_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the QualificationType.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.qualification_type_id = input;
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk
        /// returns a pagination token in the response. You can use this pagination token
        /// to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk
        /// returns a pagination token in the response. You can use this pagination token
        /// to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> The maximum number of results to return in a single call.
        /// </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of results to return in a single call.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListQualificationRequestsInput`](crate::input::ListQualificationRequestsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListQualificationRequestsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListQualificationRequestsInput {
                qualification_type_id: self.qualification_type_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListQualificationRequestsInputOperationOutputAlias =
    crate::operation::ListQualificationRequests;
#[doc(hidden)]
pub type ListQualificationRequestsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListQualificationRequestsInput {
    /// Consumes the builder and constructs an Operation<[`ListQualificationRequests`](crate::operation::ListQualificationRequests)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListQualificationRequests,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListQualificationRequestsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListQualificationRequestsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListQualificationRequestsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.ListQualificationRequests",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_qualification_requests(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListQualificationRequests::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListQualificationRequests",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListQualificationRequestsInput`](crate::input::ListQualificationRequestsInput)
    pub fn builder() -> crate::input::list_qualification_requests_input::Builder {
        crate::input::list_qualification_requests_input::Builder::default()
    }
}

/// See [`ListQualificationTypesInput`](crate::input::ListQualificationTypesInput)
pub mod list_qualification_types_input {
    /// A builder for [`ListQualificationTypesInput`](crate::input::ListQualificationTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query: std::option::Option<std::string::String>,
        pub(crate) must_be_requestable: std::option::Option<bool>,
        pub(crate) must_be_owned_by_caller: std::option::Option<bool>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> A text query against all of the searchable attributes of
        /// Qualification types.
        /// </p>
        pub fn query(mut self, input: impl Into<std::string::String>) -> Self {
            self.query = Some(input.into());
            self
        }
        /// <p> A text query against all of the searchable attributes of
        /// Qualification types.
        /// </p>
        pub fn set_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query = input;
            self
        }
        /// <p>Specifies that only Qualification types that a user can
        /// request through the Amazon Mechanical Turk web site, such as by
        /// taking a Qualification test, are returned as results of the search.
        /// Some Qualification types, such as those assigned automatically by the
        /// system, cannot be requested directly by users. If false, all
        /// Qualification types, including those managed by the system, are
        /// considered. Valid values are True | False.
        /// </p>
        pub fn must_be_requestable(mut self, input: bool) -> Self {
            self.must_be_requestable = Some(input);
            self
        }
        /// <p>Specifies that only Qualification types that a user can
        /// request through the Amazon Mechanical Turk web site, such as by
        /// taking a Qualification test, are returned as results of the search.
        /// Some Qualification types, such as those assigned automatically by the
        /// system, cannot be requested directly by users. If false, all
        /// Qualification types, including those managed by the system, are
        /// considered. Valid values are True | False.
        /// </p>
        pub fn set_must_be_requestable(mut self, input: std::option::Option<bool>) -> Self {
            self.must_be_requestable = input;
            self
        }
        /// <p> Specifies that only Qualification types that the Requester
        /// created are returned. If false, the operation returns all
        /// Qualification types.
        /// </p>
        pub fn must_be_owned_by_caller(mut self, input: bool) -> Self {
            self.must_be_owned_by_caller = Some(input);
            self
        }
        /// <p> Specifies that only Qualification types that the Requester
        /// created are returned. If false, the operation returns all
        /// Qualification types.
        /// </p>
        pub fn set_must_be_owned_by_caller(mut self, input: std::option::Option<bool>) -> Self {
            self.must_be_owned_by_caller = input;
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk
        /// returns a pagination token in the response. You can use this pagination token
        /// to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk
        /// returns a pagination token in the response. You can use this pagination token
        /// to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> The maximum number of results to return in a single call.
        /// </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of results to return in a single call.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListQualificationTypesInput`](crate::input::ListQualificationTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListQualificationTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListQualificationTypesInput {
                query: self.query,
                must_be_requestable: self.must_be_requestable,
                must_be_owned_by_caller: self.must_be_owned_by_caller,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListQualificationTypesInputOperationOutputAlias = crate::operation::ListQualificationTypes;
#[doc(hidden)]
pub type ListQualificationTypesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListQualificationTypesInput {
    /// Consumes the builder and constructs an Operation<[`ListQualificationTypes`](crate::operation::ListQualificationTypes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListQualificationTypes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListQualificationTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListQualificationTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListQualificationTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.ListQualificationTypes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_qualification_types(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListQualificationTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListQualificationTypes",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListQualificationTypesInput`](crate::input::ListQualificationTypesInput)
    pub fn builder() -> crate::input::list_qualification_types_input::Builder {
        crate::input::list_qualification_types_input::Builder::default()
    }
}

/// See [`ListReviewableHiTsInput`](crate::input::ListReviewableHiTsInput)
pub mod list_reviewable_hi_ts_input {
    /// A builder for [`ListReviewableHiTsInput`](crate::input::ListReviewableHiTsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hit_type_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ReviewableHitStatus>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>
        /// The ID of the HIT type of the HITs to consider for the query.
        /// If not specified, all HITs for the Reviewer are considered
        /// </p>
        pub fn hit_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_type_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the HIT type of the HITs to consider for the query.
        /// If not specified, all HITs for the Reviewer are considered
        /// </p>
        pub fn set_hit_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hit_type_id = input;
            self
        }
        /// <p>
        /// Can be either <code>Reviewable</code> or <code>Reviewing</code>.
        /// Reviewable is the default value.
        /// </p>
        pub fn status(mut self, input: crate::model::ReviewableHitStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>
        /// Can be either <code>Reviewable</code> or <code>Reviewing</code>.
        /// Reviewable is the default value.
        /// </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ReviewableHitStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Pagination Token</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination Token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>
        /// Limit the number of results returned.
        /// </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>
        /// Limit the number of results returned.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReviewableHiTsInput`](crate::input::ListReviewableHiTsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListReviewableHiTsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListReviewableHiTsInput {
                hit_type_id: self.hit_type_id,
                status: self.status,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListReviewableHiTsInputOperationOutputAlias = crate::operation::ListReviewableHITs;
#[doc(hidden)]
pub type ListReviewableHiTsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListReviewableHiTsInput {
    /// Consumes the builder and constructs an Operation<[`ListReviewableHITs`](crate::operation::ListReviewableHITs)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListReviewableHITs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListReviewableHiTsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListReviewableHiTsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListReviewableHiTsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.ListReviewableHITs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_reviewable_hi_ts(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListReviewableHITs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListReviewableHITs",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListReviewableHiTsInput`](crate::input::ListReviewableHiTsInput)
    pub fn builder() -> crate::input::list_reviewable_hi_ts_input::Builder {
        crate::input::list_reviewable_hi_ts_input::Builder::default()
    }
}

/// See [`ListReviewPolicyResultsForHitInput`](crate::input::ListReviewPolicyResultsForHitInput)
pub mod list_review_policy_results_for_hit_input {
    /// A builder for [`ListReviewPolicyResultsForHitInput`](crate::input::ListReviewPolicyResultsForHitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hit_id: std::option::Option<std::string::String>,
        pub(crate) policy_levels:
            std::option::Option<std::vec::Vec<crate::model::ReviewPolicyLevel>>,
        pub(crate) retrieve_actions: std::option::Option<bool>,
        pub(crate) retrieve_results: std::option::Option<bool>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier of the HIT to retrieve review results for.</p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the HIT to retrieve review results for.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hit_id = input;
            self
        }
        /// Appends an item to `policy_levels`.
        ///
        /// To override the contents of this collection use [`set_policy_levels`](Self::set_policy_levels).
        ///
        /// <p>
        /// The Policy Level(s) to retrieve review results for - HIT or Assignment.
        /// If omitted, the default behavior is to retrieve all data for both policy levels.
        /// For a list of all the described policies, see Review Policies.
        /// </p>
        pub fn policy_levels(mut self, input: impl Into<crate::model::ReviewPolicyLevel>) -> Self {
            let mut v = self.policy_levels.unwrap_or_default();
            v.push(input.into());
            self.policy_levels = Some(v);
            self
        }
        /// <p>
        /// The Policy Level(s) to retrieve review results for - HIT or Assignment.
        /// If omitted, the default behavior is to retrieve all data for both policy levels.
        /// For a list of all the described policies, see Review Policies.
        /// </p>
        pub fn set_policy_levels(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReviewPolicyLevel>>,
        ) -> Self {
            self.policy_levels = input;
            self
        }
        /// <p>
        /// Specify if the operation should retrieve a list of the actions taken executing
        /// the Review Policies and their outcomes.
        /// </p>
        pub fn retrieve_actions(mut self, input: bool) -> Self {
            self.retrieve_actions = Some(input);
            self
        }
        /// <p>
        /// Specify if the operation should retrieve a list of the actions taken executing
        /// the Review Policies and their outcomes.
        /// </p>
        pub fn set_retrieve_actions(mut self, input: std::option::Option<bool>) -> Self {
            self.retrieve_actions = input;
            self
        }
        /// <p>
        /// Specify if the operation should retrieve a list of the results computed by the Review Policies.
        /// </p>
        pub fn retrieve_results(mut self, input: bool) -> Self {
            self.retrieve_results = Some(input);
            self
        }
        /// <p>
        /// Specify if the operation should retrieve a list of the results computed by the Review Policies.
        /// </p>
        pub fn set_retrieve_results(mut self, input: std::option::Option<bool>) -> Self {
            self.retrieve_results = input;
            self
        }
        /// <p>Pagination token</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Limit the number of results returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Limit the number of results returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReviewPolicyResultsForHitInput`](crate::input::ListReviewPolicyResultsForHitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListReviewPolicyResultsForHitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListReviewPolicyResultsForHitInput {
                hit_id: self.hit_id,
                policy_levels: self.policy_levels,
                retrieve_actions: self.retrieve_actions,
                retrieve_results: self.retrieve_results,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListReviewPolicyResultsForHitInputOperationOutputAlias =
    crate::operation::ListReviewPolicyResultsForHIT;
#[doc(hidden)]
pub type ListReviewPolicyResultsForHitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListReviewPolicyResultsForHitInput {
    /// Consumes the builder and constructs an Operation<[`ListReviewPolicyResultsForHIT`](crate::operation::ListReviewPolicyResultsForHIT)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListReviewPolicyResultsForHIT,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListReviewPolicyResultsForHitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListReviewPolicyResultsForHitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListReviewPolicyResultsForHitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.ListReviewPolicyResultsForHIT",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_review_policy_results_for_hit(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListReviewPolicyResultsForHIT::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListReviewPolicyResultsForHIT",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListReviewPolicyResultsForHitInput`](crate::input::ListReviewPolicyResultsForHitInput)
    pub fn builder() -> crate::input::list_review_policy_results_for_hit_input::Builder {
        crate::input::list_review_policy_results_for_hit_input::Builder::default()
    }
}

/// See [`ListWorkerBlocksInput`](crate::input::ListWorkerBlocksInput)
pub mod list_worker_blocks_input {
    /// A builder for [`ListWorkerBlocksInput`](crate::input::ListWorkerBlocksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Pagination token</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkerBlocksInput`](crate::input::ListWorkerBlocksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWorkerBlocksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWorkerBlocksInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListWorkerBlocksInputOperationOutputAlias = crate::operation::ListWorkerBlocks;
#[doc(hidden)]
pub type ListWorkerBlocksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListWorkerBlocksInput {
    /// Consumes the builder and constructs an Operation<[`ListWorkerBlocks`](crate::operation::ListWorkerBlocks)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWorkerBlocks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListWorkerBlocksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListWorkerBlocksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListWorkerBlocksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.ListWorkerBlocks",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_worker_blocks(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWorkerBlocks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWorkerBlocks",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListWorkerBlocksInput`](crate::input::ListWorkerBlocksInput)
    pub fn builder() -> crate::input::list_worker_blocks_input::Builder {
        crate::input::list_worker_blocks_input::Builder::default()
    }
}

/// See [`ListWorkersWithQualificationTypeInput`](crate::input::ListWorkersWithQualificationTypeInput)
pub mod list_workers_with_qualification_type_input {
    /// A builder for [`ListWorkersWithQualificationTypeInput`](crate::input::ListWorkersWithQualificationTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) qualification_type_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::QualificationStatus>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the Qualification type of the Qualifications to
        /// return.</p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualification_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the Qualification type of the Qualifications to
        /// return.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.qualification_type_id = input;
            self
        }
        /// <p>
        /// The status of the Qualifications to return.
        /// Can be <code>Granted | Revoked</code>.
        /// </p>
        pub fn status(mut self, input: crate::model::QualificationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>
        /// The status of the Qualifications to return.
        /// Can be <code>Granted | Revoked</code>.
        /// </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::QualificationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Pagination Token</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination Token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>
        /// Limit the number of results returned.
        /// </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>
        /// Limit the number of results returned.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkersWithQualificationTypeInput`](crate::input::ListWorkersWithQualificationTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWorkersWithQualificationTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWorkersWithQualificationTypeInput {
                qualification_type_id: self.qualification_type_id,
                status: self.status,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListWorkersWithQualificationTypeInputOperationOutputAlias =
    crate::operation::ListWorkersWithQualificationType;
#[doc(hidden)]
pub type ListWorkersWithQualificationTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListWorkersWithQualificationTypeInput {
    /// Consumes the builder and constructs an Operation<[`ListWorkersWithQualificationType`](crate::operation::ListWorkersWithQualificationType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWorkersWithQualificationType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListWorkersWithQualificationTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListWorkersWithQualificationTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListWorkersWithQualificationTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.ListWorkersWithQualificationType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_workers_with_qualification_type(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWorkersWithQualificationType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWorkersWithQualificationType",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListWorkersWithQualificationTypeInput`](crate::input::ListWorkersWithQualificationTypeInput)
    pub fn builder() -> crate::input::list_workers_with_qualification_type_input::Builder {
        crate::input::list_workers_with_qualification_type_input::Builder::default()
    }
}

/// See [`NotifyWorkersInput`](crate::input::NotifyWorkersInput)
pub mod notify_workers_input {
    /// A builder for [`NotifyWorkersInput`](crate::input::NotifyWorkersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) message_text: std::option::Option<std::string::String>,
        pub(crate) worker_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The subject line of the email message to send. Can include up
        /// to 200 characters.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// <p>The subject line of the email message to send. Can include up
        /// to 200 characters.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// <p>The text of the email message to send. Can include up to
        /// 4,096 characters</p>
        pub fn message_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_text = Some(input.into());
            self
        }
        /// <p>The text of the email message to send. Can include up to
        /// 4,096 characters</p>
        pub fn set_message_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_text = input;
            self
        }
        /// Appends an item to `worker_ids`.
        ///
        /// To override the contents of this collection use [`set_worker_ids`](Self::set_worker_ids).
        ///
        /// <p>A list of Worker IDs you wish to notify. You
        /// can notify upto
        /// 100 Workers at a time.</p>
        pub fn worker_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.worker_ids.unwrap_or_default();
            v.push(input.into());
            self.worker_ids = Some(v);
            self
        }
        /// <p>A list of Worker IDs you wish to notify. You
        /// can notify upto
        /// 100 Workers at a time.</p>
        pub fn set_worker_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.worker_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`NotifyWorkersInput`](crate::input::NotifyWorkersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::NotifyWorkersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::NotifyWorkersInput {
                subject: self.subject,
                message_text: self.message_text,
                worker_ids: self.worker_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type NotifyWorkersInputOperationOutputAlias = crate::operation::NotifyWorkers;
#[doc(hidden)]
pub type NotifyWorkersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl NotifyWorkersInput {
    /// Consumes the builder and constructs an Operation<[`NotifyWorkers`](crate::operation::NotifyWorkers)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::NotifyWorkers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::NotifyWorkersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::NotifyWorkersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::NotifyWorkersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.NotifyWorkers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_notify_workers(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::NotifyWorkers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "NotifyWorkers",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`NotifyWorkersInput`](crate::input::NotifyWorkersInput)
    pub fn builder() -> crate::input::notify_workers_input::Builder {
        crate::input::notify_workers_input::Builder::default()
    }
}

/// See [`RejectAssignmentInput`](crate::input::RejectAssignmentInput)
pub mod reject_assignment_input {
    /// A builder for [`RejectAssignmentInput`](crate::input::RejectAssignmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assignment_id: std::option::Option<std::string::String>,
        pub(crate) requester_feedback: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The ID of the assignment. The assignment must correspond to a HIT created by the Requester.
        /// </p>
        pub fn assignment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the assignment. The assignment must correspond to a HIT created by the Requester.
        /// </p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_id = input;
            self
        }
        /// <p>
        /// A message for the Worker, which the Worker can see in the Status section of the web site.
        /// </p>
        pub fn requester_feedback(mut self, input: impl Into<std::string::String>) -> Self {
            self.requester_feedback = Some(input.into());
            self
        }
        /// <p>
        /// A message for the Worker, which the Worker can see in the Status section of the web site.
        /// </p>
        pub fn set_requester_feedback(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.requester_feedback = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectAssignmentInput`](crate::input::RejectAssignmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RejectAssignmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RejectAssignmentInput {
                assignment_id: self.assignment_id,
                requester_feedback: self.requester_feedback,
            })
        }
    }
}
#[doc(hidden)]
pub type RejectAssignmentInputOperationOutputAlias = crate::operation::RejectAssignment;
#[doc(hidden)]
pub type RejectAssignmentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RejectAssignmentInput {
    /// Consumes the builder and constructs an Operation<[`RejectAssignment`](crate::operation::RejectAssignment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RejectAssignment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RejectAssignmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RejectAssignmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RejectAssignmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.RejectAssignment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_reject_assignment(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RejectAssignment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RejectAssignment",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RejectAssignmentInput`](crate::input::RejectAssignmentInput)
    pub fn builder() -> crate::input::reject_assignment_input::Builder {
        crate::input::reject_assignment_input::Builder::default()
    }
}

/// See [`RejectQualificationRequestInput`](crate::input::RejectQualificationRequestInput)
pub mod reject_qualification_request_input {
    /// A builder for [`RejectQualificationRequestInput`](crate::input::RejectQualificationRequestInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) qualification_request_id: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The ID of the Qualification request, as returned by the
        /// <code>ListQualificationRequests</code>
        /// operation.
        /// </p>
        pub fn qualification_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualification_request_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the Qualification request, as returned by the
        /// <code>ListQualificationRequests</code>
        /// operation.
        /// </p>
        pub fn set_qualification_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.qualification_request_id = input;
            self
        }
        /// <p>A text message explaining why the request was rejected, to be
        /// shown to the Worker who made the request.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>A text message explaining why the request was rejected, to be
        /// shown to the Worker who made the request.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectQualificationRequestInput`](crate::input::RejectQualificationRequestInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RejectQualificationRequestInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RejectQualificationRequestInput {
                qualification_request_id: self.qualification_request_id,
                reason: self.reason,
            })
        }
    }
}
#[doc(hidden)]
pub type RejectQualificationRequestInputOperationOutputAlias =
    crate::operation::RejectQualificationRequest;
#[doc(hidden)]
pub type RejectQualificationRequestInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RejectQualificationRequestInput {
    /// Consumes the builder and constructs an Operation<[`RejectQualificationRequest`](crate::operation::RejectQualificationRequest)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RejectQualificationRequest,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RejectQualificationRequestInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RejectQualificationRequestInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RejectQualificationRequestInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.RejectQualificationRequest",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_reject_qualification_request(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RejectQualificationRequest::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RejectQualificationRequest",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RejectQualificationRequestInput`](crate::input::RejectQualificationRequestInput)
    pub fn builder() -> crate::input::reject_qualification_request_input::Builder {
        crate::input::reject_qualification_request_input::Builder::default()
    }
}

/// See [`SendBonusInput`](crate::input::SendBonusInput)
pub mod send_bonus_input {
    /// A builder for [`SendBonusInput`](crate::input::SendBonusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) worker_id: std::option::Option<std::string::String>,
        pub(crate) bonus_amount: std::option::Option<std::string::String>,
        pub(crate) assignment_id: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) unique_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Worker being paid the bonus.</p>
        pub fn worker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_id = Some(input.into());
            self
        }
        /// <p>The ID of the Worker being paid the bonus.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.worker_id = input;
            self
        }
        /// <p>
        /// The Bonus amount is a US Dollar amount specified using a string (for example, "5" represents $5.00 USD and
        /// "101.42" represents $101.42 USD). Do not include currency symbols or currency codes.
        /// </p>
        pub fn bonus_amount(mut self, input: impl Into<std::string::String>) -> Self {
            self.bonus_amount = Some(input.into());
            self
        }
        /// <p>
        /// The Bonus amount is a US Dollar amount specified using a string (for example, "5" represents $5.00 USD and
        /// "101.42" represents $101.42 USD). Do not include currency symbols or currency codes.
        /// </p>
        pub fn set_bonus_amount(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bonus_amount = input;
            self
        }
        /// <p>The ID of the assignment for which this bonus is paid.</p>
        pub fn assignment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_id = Some(input.into());
            self
        }
        /// <p>The ID of the assignment for which this bonus is paid.</p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_id = input;
            self
        }
        /// <p>A message that explains the reason for the bonus payment. The
        /// Worker receiving the bonus can see this message.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>A message that explains the reason for the bonus payment. The
        /// Worker receiving the bonus can see this message.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// <p>A unique identifier for this request, which allows you to
        /// retry the call on error without granting multiple bonuses. This is
        /// useful in cases such as network timeouts where it is unclear whether
        /// or not the call succeeded on the server. If the bonus already exists
        /// in the system from a previous call using the same UniqueRequestToken,
        /// subsequent calls will return an error with a message containing the
        /// request ID.</p>
        pub fn unique_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.unique_request_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for this request, which allows you to
        /// retry the call on error without granting multiple bonuses. This is
        /// useful in cases such as network timeouts where it is unclear whether
        /// or not the call succeeded on the server. If the bonus already exists
        /// in the system from a previous call using the same UniqueRequestToken,
        /// subsequent calls will return an error with a message containing the
        /// request ID.</p>
        pub fn set_unique_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.unique_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SendBonusInput`](crate::input::SendBonusInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::SendBonusInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::SendBonusInput {
                worker_id: self.worker_id,
                bonus_amount: self.bonus_amount,
                assignment_id: self.assignment_id,
                reason: self.reason,
                unique_request_token: self.unique_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type SendBonusInputOperationOutputAlias = crate::operation::SendBonus;
#[doc(hidden)]
pub type SendBonusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SendBonusInput {
    /// Consumes the builder and constructs an Operation<[`SendBonus`](crate::operation::SendBonus)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendBonus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendBonusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendBonusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendBonusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.SendBonus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_send_bonus(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::SendBonus::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "SendBonus",
                    "mturk",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendBonusInput`](crate::input::SendBonusInput)
    pub fn builder() -> crate::input::send_bonus_input::Builder {
        crate::input::send_bonus_input::Builder::default()
    }
}

/// See [`SendTestEventNotificationInput`](crate::input::SendTestEventNotificationInput)
pub mod send_test_event_notification_input {
    /// A builder for [`SendTestEventNotificationInput`](crate::input::SendTestEventNotificationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notification: std::option::Option<crate::model::NotificationSpecification>,
        pub(crate) test_event_type: std::option::Option<crate::model::EventType>,
    }
    impl Builder {
        /// <p>
        /// The notification specification to test. This value is identical to the value
        /// you would provide to the UpdateNotificationSettings operation when you establish
        /// the notification specification for a HIT type.
        /// </p>
        pub fn notification(mut self, input: crate::model::NotificationSpecification) -> Self {
            self.notification = Some(input);
            self
        }
        /// <p>
        /// The notification specification to test. This value is identical to the value
        /// you would provide to the UpdateNotificationSettings operation when you establish
        /// the notification specification for a HIT type.
        /// </p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::NotificationSpecification>,
        ) -> Self {
            self.notification = input;
            self
        }
        /// <p>
        /// The event to simulate to test the notification specification.
        /// This event is included in the test message even if the notification specification
        /// does not include the event type.
        /// The notification specification does not filter out the test event.
        /// </p>
        pub fn test_event_type(mut self, input: crate::model::EventType) -> Self {
            self.test_event_type = Some(input);
            self
        }
        /// <p>
        /// The event to simulate to test the notification specification.
        /// This event is included in the test message even if the notification specification
        /// does not include the event type.
        /// The notification specification does not filter out the test event.
        /// </p>
        pub fn set_test_event_type(
            mut self,
            input: std::option::Option<crate::model::EventType>,
        ) -> Self {
            self.test_event_type = input;
            self
        }
        /// Consumes the builder and constructs a [`SendTestEventNotificationInput`](crate::input::SendTestEventNotificationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendTestEventNotificationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendTestEventNotificationInput {
                notification: self.notification,
                test_event_type: self.test_event_type,
            })
        }
    }
}
#[doc(hidden)]
pub type SendTestEventNotificationInputOperationOutputAlias =
    crate::operation::SendTestEventNotification;
#[doc(hidden)]
pub type SendTestEventNotificationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SendTestEventNotificationInput {
    /// Consumes the builder and constructs an Operation<[`SendTestEventNotification`](crate::operation::SendTestEventNotification)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendTestEventNotification,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendTestEventNotificationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendTestEventNotificationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendTestEventNotificationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.SendTestEventNotification",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_send_test_event_notification(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendTestEventNotification::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendTestEventNotification",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendTestEventNotificationInput`](crate::input::SendTestEventNotificationInput)
    pub fn builder() -> crate::input::send_test_event_notification_input::Builder {
        crate::input::send_test_event_notification_input::Builder::default()
    }
}

/// See [`UpdateExpirationForHitInput`](crate::input::UpdateExpirationForHitInput)
pub mod update_expiration_for_hit_input {
    /// A builder for [`UpdateExpirationForHitInput`](crate::input::UpdateExpirationForHitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hit_id: std::option::Option<std::string::String>,
        pub(crate) expire_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>
        /// The HIT to update.
        /// </p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_id = Some(input.into());
            self
        }
        /// <p>
        /// The HIT to update.
        /// </p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hit_id = input;
            self
        }
        /// <p>
        /// The date and time at which you want the HIT to expire
        /// </p>
        pub fn expire_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expire_at = Some(input);
            self
        }
        /// <p>
        /// The date and time at which you want the HIT to expire
        /// </p>
        pub fn set_expire_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expire_at = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateExpirationForHitInput`](crate::input::UpdateExpirationForHitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateExpirationForHitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateExpirationForHitInput {
                hit_id: self.hit_id,
                expire_at: self.expire_at,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateExpirationForHitInputOperationOutputAlias = crate::operation::UpdateExpirationForHIT;
#[doc(hidden)]
pub type UpdateExpirationForHitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateExpirationForHitInput {
    /// Consumes the builder and constructs an Operation<[`UpdateExpirationForHIT`](crate::operation::UpdateExpirationForHIT)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateExpirationForHIT,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateExpirationForHitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateExpirationForHitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateExpirationForHitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.UpdateExpirationForHIT",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_expiration_for_hit(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateExpirationForHIT::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateExpirationForHIT",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateExpirationForHitInput`](crate::input::UpdateExpirationForHitInput)
    pub fn builder() -> crate::input::update_expiration_for_hit_input::Builder {
        crate::input::update_expiration_for_hit_input::Builder::default()
    }
}

/// See [`UpdateHitReviewStatusInput`](crate::input::UpdateHitReviewStatusInput)
pub mod update_hit_review_status_input {
    /// A builder for [`UpdateHitReviewStatusInput`](crate::input::UpdateHitReviewStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hit_id: std::option::Option<std::string::String>,
        pub(crate) revert: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>
        /// The ID of the HIT to update.
        /// </p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the HIT to update.
        /// </p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hit_id = input;
            self
        }
        /// <p>
        /// Specifies how to update the HIT status. Default is <code>False</code>.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// Setting this to false will only transition a HIT from <code>Reviewable</code> to <code>Reviewing</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// Setting this to true will only transition a HIT from <code>Reviewing</code> to <code>Reviewable</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn revert(mut self, input: bool) -> Self {
            self.revert = Some(input);
            self
        }
        /// <p>
        /// Specifies how to update the HIT status. Default is <code>False</code>.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// Setting this to false will only transition a HIT from <code>Reviewable</code> to <code>Reviewing</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// Setting this to true will only transition a HIT from <code>Reviewing</code> to <code>Reviewable</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_revert(mut self, input: std::option::Option<bool>) -> Self {
            self.revert = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateHitReviewStatusInput`](crate::input::UpdateHitReviewStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateHitReviewStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateHitReviewStatusInput {
                hit_id: self.hit_id,
                revert: self.revert,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateHitReviewStatusInputOperationOutputAlias = crate::operation::UpdateHITReviewStatus;
#[doc(hidden)]
pub type UpdateHitReviewStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateHitReviewStatusInput {
    /// Consumes the builder and constructs an Operation<[`UpdateHITReviewStatus`](crate::operation::UpdateHITReviewStatus)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateHITReviewStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateHitReviewStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateHitReviewStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateHitReviewStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.UpdateHITReviewStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_hit_review_status(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateHITReviewStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateHITReviewStatus",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateHitReviewStatusInput`](crate::input::UpdateHitReviewStatusInput)
    pub fn builder() -> crate::input::update_hit_review_status_input::Builder {
        crate::input::update_hit_review_status_input::Builder::default()
    }
}

/// See [`UpdateHitTypeOfHitInput`](crate::input::UpdateHitTypeOfHitInput)
pub mod update_hit_type_of_hit_input {
    /// A builder for [`UpdateHitTypeOfHitInput`](crate::input::UpdateHitTypeOfHitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hit_id: std::option::Option<std::string::String>,
        pub(crate) hit_type_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HIT to update.</p>
        pub fn hit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_id = Some(input.into());
            self
        }
        /// <p>The HIT to update.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hit_id = input;
            self
        }
        /// <p>The ID of the new HIT type.</p>
        pub fn hit_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the new HIT type.</p>
        pub fn set_hit_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hit_type_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateHitTypeOfHitInput`](crate::input::UpdateHitTypeOfHitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateHitTypeOfHitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateHitTypeOfHitInput {
                hit_id: self.hit_id,
                hit_type_id: self.hit_type_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateHitTypeOfHitInputOperationOutputAlias = crate::operation::UpdateHITTypeOfHIT;
#[doc(hidden)]
pub type UpdateHitTypeOfHitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateHitTypeOfHitInput {
    /// Consumes the builder and constructs an Operation<[`UpdateHITTypeOfHIT`](crate::operation::UpdateHITTypeOfHIT)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateHITTypeOfHIT,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateHitTypeOfHitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateHitTypeOfHitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateHitTypeOfHitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.UpdateHITTypeOfHIT",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_hit_type_of_hit(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateHITTypeOfHIT::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateHITTypeOfHIT",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateHitTypeOfHitInput`](crate::input::UpdateHitTypeOfHitInput)
    pub fn builder() -> crate::input::update_hit_type_of_hit_input::Builder {
        crate::input::update_hit_type_of_hit_input::Builder::default()
    }
}

/// See [`UpdateNotificationSettingsInput`](crate::input::UpdateNotificationSettingsInput)
pub mod update_notification_settings_input {
    /// A builder for [`UpdateNotificationSettingsInput`](crate::input::UpdateNotificationSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hit_type_id: std::option::Option<std::string::String>,
        pub(crate) notification: std::option::Option<crate::model::NotificationSpecification>,
        pub(crate) active: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>
        /// The ID of the HIT type whose notification specification is being updated.
        /// </p>
        pub fn hit_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hit_type_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the HIT type whose notification specification is being updated.
        /// </p>
        pub fn set_hit_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hit_type_id = input;
            self
        }
        /// <p>
        /// The notification specification for the HIT type.
        /// </p>
        pub fn notification(mut self, input: crate::model::NotificationSpecification) -> Self {
            self.notification = Some(input);
            self
        }
        /// <p>
        /// The notification specification for the HIT type.
        /// </p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::NotificationSpecification>,
        ) -> Self {
            self.notification = input;
            self
        }
        /// <p>
        /// Specifies whether notifications are sent for HITs of this HIT type,
        /// according to the notification specification.
        /// You must specify either the Notification parameter or the Active parameter
        /// for the call to UpdateNotificationSettings to succeed.
        /// </p>
        pub fn active(mut self, input: bool) -> Self {
            self.active = Some(input);
            self
        }
        /// <p>
        /// Specifies whether notifications are sent for HITs of this HIT type,
        /// according to the notification specification.
        /// You must specify either the Notification parameter or the Active parameter
        /// for the call to UpdateNotificationSettings to succeed.
        /// </p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.active = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateNotificationSettingsInput`](crate::input::UpdateNotificationSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateNotificationSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateNotificationSettingsInput {
                hit_type_id: self.hit_type_id,
                notification: self.notification,
                active: self.active,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateNotificationSettingsInputOperationOutputAlias =
    crate::operation::UpdateNotificationSettings;
#[doc(hidden)]
pub type UpdateNotificationSettingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateNotificationSettingsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateNotificationSettings`](crate::operation::UpdateNotificationSettings)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateNotificationSettings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateNotificationSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateNotificationSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateNotificationSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.UpdateNotificationSettings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_notification_settings(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateNotificationSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateNotificationSettings",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateNotificationSettingsInput`](crate::input::UpdateNotificationSettingsInput)
    pub fn builder() -> crate::input::update_notification_settings_input::Builder {
        crate::input::update_notification_settings_input::Builder::default()
    }
}

/// See [`UpdateQualificationTypeInput`](crate::input::UpdateQualificationTypeInput)
pub mod update_qualification_type_input {
    /// A builder for [`UpdateQualificationTypeInput`](crate::input::UpdateQualificationTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) qualification_type_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) qualification_type_status:
            std::option::Option<crate::model::QualificationTypeStatus>,
        pub(crate) test: std::option::Option<std::string::String>,
        pub(crate) answer_key: std::option::Option<std::string::String>,
        pub(crate) test_duration_in_seconds: std::option::Option<i64>,
        pub(crate) retry_delay_in_seconds: std::option::Option<i64>,
        pub(crate) auto_granted: std::option::Option<bool>,
        pub(crate) auto_granted_value: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the Qualification type to update.</p>
        pub fn qualification_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualification_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the Qualification type to update.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.qualification_type_id = input;
            self
        }
        /// <p>The new description of the Qualification type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The new description of the Qualification type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The new status of the Qualification type - Active | Inactive</p>
        pub fn qualification_type_status(
            mut self,
            input: crate::model::QualificationTypeStatus,
        ) -> Self {
            self.qualification_type_status = Some(input);
            self
        }
        /// <p>The new status of the Qualification type - Active | Inactive</p>
        pub fn set_qualification_type_status(
            mut self,
            input: std::option::Option<crate::model::QualificationTypeStatus>,
        ) -> Self {
            self.qualification_type_status = input;
            self
        }
        /// <p>The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified.</p>
        /// <p>Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be specified if AutoGranted is true.</p>
        /// <p>Constraints: None. If not specified, the Worker may request the Qualification without answering any questions.</p>
        pub fn test(mut self, input: impl Into<std::string::String>) -> Self {
            self.test = Some(input.into());
            self
        }
        /// <p>The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified.</p>
        /// <p>Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be specified if AutoGranted is true.</p>
        /// <p>Constraints: None. If not specified, the Worker may request the Qualification without answering any questions.</p>
        pub fn set_test(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.test = input;
            self
        }
        /// <p>The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data structure.</p>
        pub fn answer_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.answer_key = Some(input.into());
            self
        }
        /// <p>The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data structure.</p>
        pub fn set_answer_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.answer_key = input;
            self
        }
        /// <p>The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker requests the Qualification.</p>
        pub fn test_duration_in_seconds(mut self, input: i64) -> Self {
            self.test_duration_in_seconds = Some(input);
            self
        }
        /// <p>The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker requests the Qualification.</p>
        pub fn set_test_duration_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.test_duration_in_seconds = input;
            self
        }
        /// <p>The amount of time, in seconds, that Workers must wait
        /// after requesting a Qualification of the specified Qualification type
        /// before they can retry the Qualification request. It is not possible to
        /// disable retries for a Qualification type after it has been created with
        /// retries enabled. If you want to disable retries, you must dispose of
        /// the existing retry-enabled Qualification type using
        /// DisposeQualificationType and then create a new Qualification type with
        /// retries disabled using CreateQualificationType.</p>
        pub fn retry_delay_in_seconds(mut self, input: i64) -> Self {
            self.retry_delay_in_seconds = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, that Workers must wait
        /// after requesting a Qualification of the specified Qualification type
        /// before they can retry the Qualification request. It is not possible to
        /// disable retries for a Qualification type after it has been created with
        /// retries enabled. If you want to disable retries, you must dispose of
        /// the existing retry-enabled Qualification type using
        /// DisposeQualificationType and then create a new Qualification type with
        /// retries disabled using CreateQualificationType.</p>
        pub fn set_retry_delay_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.retry_delay_in_seconds = input;
            self
        }
        /// <p>Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test.</p>
        /// <p>Constraints: If the Test parameter is specified, this parameter cannot be true.</p>
        pub fn auto_granted(mut self, input: bool) -> Self {
            self.auto_granted = Some(input);
            self
        }
        /// <p>Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test.</p>
        /// <p>Constraints: If the Test parameter is specified, this parameter cannot be true.</p>
        pub fn set_auto_granted(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_granted = input;
            self
        }
        /// <p>The Qualification value to use for automatically granted Qualifications. This parameter is used only if the AutoGranted parameter is true.</p>
        pub fn auto_granted_value(mut self, input: i32) -> Self {
            self.auto_granted_value = Some(input);
            self
        }
        /// <p>The Qualification value to use for automatically granted Qualifications. This parameter is used only if the AutoGranted parameter is true.</p>
        pub fn set_auto_granted_value(mut self, input: std::option::Option<i32>) -> Self {
            self.auto_granted_value = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateQualificationTypeInput`](crate::input::UpdateQualificationTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateQualificationTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateQualificationTypeInput {
                qualification_type_id: self.qualification_type_id,
                description: self.description,
                qualification_type_status: self.qualification_type_status,
                test: self.test,
                answer_key: self.answer_key,
                test_duration_in_seconds: self.test_duration_in_seconds,
                retry_delay_in_seconds: self.retry_delay_in_seconds,
                auto_granted: self.auto_granted,
                auto_granted_value: self.auto_granted_value,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateQualificationTypeInputOperationOutputAlias =
    crate::operation::UpdateQualificationType;
#[doc(hidden)]
pub type UpdateQualificationTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateQualificationTypeInput {
    /// Consumes the builder and constructs an Operation<[`UpdateQualificationType`](crate::operation::UpdateQualificationType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateQualificationType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateQualificationTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateQualificationTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateQualificationTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "MTurkRequesterServiceV20170117.UpdateQualificationType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_qualification_type(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateQualificationType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateQualificationType",
            "mturk",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateQualificationTypeInput`](crate::input::UpdateQualificationTypeInput)
    pub fn builder() -> crate::input::update_qualification_type_input::Builder {
        crate::input::update_qualification_type_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateQualificationTypeInput {
    /// <p>The ID of the Qualification type to update.</p>
    pub qualification_type_id: std::option::Option<std::string::String>,
    /// <p>The new description of the Qualification type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The new status of the Qualification type - Active | Inactive</p>
    pub qualification_type_status: std::option::Option<crate::model::QualificationTypeStatus>,
    /// <p>The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified.</p>
    /// <p>Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be specified if AutoGranted is true.</p>
    /// <p>Constraints: None. If not specified, the Worker may request the Qualification without answering any questions.</p>
    pub test: std::option::Option<std::string::String>,
    /// <p>The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data structure.</p>
    pub answer_key: std::option::Option<std::string::String>,
    /// <p>The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker requests the Qualification.</p>
    pub test_duration_in_seconds: std::option::Option<i64>,
    /// <p>The amount of time, in seconds, that Workers must wait
    /// after requesting a Qualification of the specified Qualification type
    /// before they can retry the Qualification request. It is not possible to
    /// disable retries for a Qualification type after it has been created with
    /// retries enabled. If you want to disable retries, you must dispose of
    /// the existing retry-enabled Qualification type using
    /// DisposeQualificationType and then create a new Qualification type with
    /// retries disabled using CreateQualificationType.</p>
    pub retry_delay_in_seconds: std::option::Option<i64>,
    /// <p>Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test.</p>
    /// <p>Constraints: If the Test parameter is specified, this parameter cannot be true.</p>
    pub auto_granted: std::option::Option<bool>,
    /// <p>The Qualification value to use for automatically granted Qualifications. This parameter is used only if the AutoGranted parameter is true.</p>
    pub auto_granted_value: std::option::Option<i32>,
}
impl std::fmt::Debug for UpdateQualificationTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateQualificationTypeInput");
        formatter.field("qualification_type_id", &self.qualification_type_id);
        formatter.field("description", &self.description);
        formatter.field("qualification_type_status", &self.qualification_type_status);
        formatter.field("test", &self.test);
        formatter.field("answer_key", &self.answer_key);
        formatter.field("test_duration_in_seconds", &self.test_duration_in_seconds);
        formatter.field("retry_delay_in_seconds", &self.retry_delay_in_seconds);
        formatter.field("auto_granted", &self.auto_granted);
        formatter.field("auto_granted_value", &self.auto_granted_value);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateNotificationSettingsInput {
    /// <p>
    /// The ID of the HIT type whose notification specification is being updated.
    /// </p>
    pub hit_type_id: std::option::Option<std::string::String>,
    /// <p>
    /// The notification specification for the HIT type.
    /// </p>
    pub notification: std::option::Option<crate::model::NotificationSpecification>,
    /// <p>
    /// Specifies whether notifications are sent for HITs of this HIT type,
    /// according to the notification specification.
    /// You must specify either the Notification parameter or the Active parameter
    /// for the call to UpdateNotificationSettings to succeed.
    /// </p>
    pub active: std::option::Option<bool>,
}
impl std::fmt::Debug for UpdateNotificationSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateNotificationSettingsInput");
        formatter.field("hit_type_id", &self.hit_type_id);
        formatter.field("notification", &self.notification);
        formatter.field("active", &self.active);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateHitTypeOfHitInput {
    /// <p>The HIT to update.</p>
    pub hit_id: std::option::Option<std::string::String>,
    /// <p>The ID of the new HIT type.</p>
    pub hit_type_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateHitTypeOfHitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateHitTypeOfHitInput");
        formatter.field("hit_id", &self.hit_id);
        formatter.field("hit_type_id", &self.hit_type_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateHitReviewStatusInput {
    /// <p>
    /// The ID of the HIT to update.
    /// </p>
    pub hit_id: std::option::Option<std::string::String>,
    /// <p>
    /// Specifies how to update the HIT status. Default is <code>False</code>.
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// Setting this to false will only transition a HIT from <code>Reviewable</code> to <code>Reviewing</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// Setting this to true will only transition a HIT from <code>Reviewing</code> to <code>Reviewable</code>
    /// </p>
    /// </li>
    /// </ul>
    pub revert: std::option::Option<bool>,
}
impl std::fmt::Debug for UpdateHitReviewStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateHitReviewStatusInput");
        formatter.field("hit_id", &self.hit_id);
        formatter.field("revert", &self.revert);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateExpirationForHitInput {
    /// <p>
    /// The HIT to update.
    /// </p>
    pub hit_id: std::option::Option<std::string::String>,
    /// <p>
    /// The date and time at which you want the HIT to expire
    /// </p>
    pub expire_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for UpdateExpirationForHitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateExpirationForHitInput");
        formatter.field("hit_id", &self.hit_id);
        formatter.field("expire_at", &self.expire_at);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendTestEventNotificationInput {
    /// <p>
    /// The notification specification to test. This value is identical to the value
    /// you would provide to the UpdateNotificationSettings operation when you establish
    /// the notification specification for a HIT type.
    /// </p>
    pub notification: std::option::Option<crate::model::NotificationSpecification>,
    /// <p>
    /// The event to simulate to test the notification specification.
    /// This event is included in the test message even if the notification specification
    /// does not include the event type.
    /// The notification specification does not filter out the test event.
    /// </p>
    pub test_event_type: std::option::Option<crate::model::EventType>,
}
impl std::fmt::Debug for SendTestEventNotificationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendTestEventNotificationInput");
        formatter.field("notification", &self.notification);
        formatter.field("test_event_type", &self.test_event_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendBonusInput {
    /// <p>The ID of the Worker being paid the bonus.</p>
    pub worker_id: std::option::Option<std::string::String>,
    /// <p>
    /// The Bonus amount is a US Dollar amount specified using a string (for example, "5" represents $5.00 USD and
    /// "101.42" represents $101.42 USD). Do not include currency symbols or currency codes.
    /// </p>
    pub bonus_amount: std::option::Option<std::string::String>,
    /// <p>The ID of the assignment for which this bonus is paid.</p>
    pub assignment_id: std::option::Option<std::string::String>,
    /// <p>A message that explains the reason for the bonus payment. The
    /// Worker receiving the bonus can see this message.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>A unique identifier for this request, which allows you to
    /// retry the call on error without granting multiple bonuses. This is
    /// useful in cases such as network timeouts where it is unclear whether
    /// or not the call succeeded on the server. If the bonus already exists
    /// in the system from a previous call using the same UniqueRequestToken,
    /// subsequent calls will return an error with a message containing the
    /// request ID.</p>
    pub unique_request_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SendBonusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendBonusInput");
        formatter.field("worker_id", &self.worker_id);
        formatter.field("bonus_amount", &self.bonus_amount);
        formatter.field("assignment_id", &self.assignment_id);
        formatter.field("reason", &self.reason);
        formatter.field("unique_request_token", &self.unique_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectQualificationRequestInput {
    /// <p>
    /// The ID of the Qualification request, as returned by the
    /// <code>ListQualificationRequests</code>
    /// operation.
    /// </p>
    pub qualification_request_id: std::option::Option<std::string::String>,
    /// <p>A text message explaining why the request was rejected, to be
    /// shown to the Worker who made the request.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RejectQualificationRequestInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectQualificationRequestInput");
        formatter.field("qualification_request_id", &self.qualification_request_id);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectAssignmentInput {
    /// <p>
    /// The ID of the assignment. The assignment must correspond to a HIT created by the Requester.
    /// </p>
    pub assignment_id: std::option::Option<std::string::String>,
    /// <p>
    /// A message for the Worker, which the Worker can see in the Status section of the web site.
    /// </p>
    pub requester_feedback: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RejectAssignmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectAssignmentInput");
        formatter.field("assignment_id", &self.assignment_id);
        formatter.field("requester_feedback", &self.requester_feedback);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotifyWorkersInput {
    /// <p>The subject line of the email message to send. Can include up
    /// to 200 characters.</p>
    pub subject: std::option::Option<std::string::String>,
    /// <p>The text of the email message to send. Can include up to
    /// 4,096 characters</p>
    pub message_text: std::option::Option<std::string::String>,
    /// <p>A list of Worker IDs you wish to notify. You
    /// can notify upto
    /// 100 Workers at a time.</p>
    pub worker_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for NotifyWorkersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotifyWorkersInput");
        formatter.field("subject", &self.subject);
        formatter.field("message_text", &self.message_text);
        formatter.field("worker_ids", &self.worker_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkersWithQualificationTypeInput {
    /// <p>The ID of the Qualification type of the Qualifications to
    /// return.</p>
    pub qualification_type_id: std::option::Option<std::string::String>,
    /// <p>
    /// The status of the Qualifications to return.
    /// Can be <code>Granted | Revoked</code>.
    /// </p>
    pub status: std::option::Option<crate::model::QualificationStatus>,
    /// <p>Pagination Token</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>
    /// Limit the number of results returned.
    /// </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListWorkersWithQualificationTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkersWithQualificationTypeInput");
        formatter.field("qualification_type_id", &self.qualification_type_id);
        formatter.field("status", &self.status);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkerBlocksInput {
    /// <p>Pagination token</p>
    pub next_token: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListWorkerBlocksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkerBlocksInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReviewPolicyResultsForHitInput {
    /// <p>The unique identifier of the HIT to retrieve review results for.</p>
    pub hit_id: std::option::Option<std::string::String>,
    /// <p>
    /// The Policy Level(s) to retrieve review results for - HIT or Assignment.
    /// If omitted, the default behavior is to retrieve all data for both policy levels.
    /// For a list of all the described policies, see Review Policies.
    /// </p>
    pub policy_levels: std::option::Option<std::vec::Vec<crate::model::ReviewPolicyLevel>>,
    /// <p>
    /// Specify if the operation should retrieve a list of the actions taken executing
    /// the Review Policies and their outcomes.
    /// </p>
    pub retrieve_actions: std::option::Option<bool>,
    /// <p>
    /// Specify if the operation should retrieve a list of the results computed by the Review Policies.
    /// </p>
    pub retrieve_results: std::option::Option<bool>,
    /// <p>Pagination token</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Limit the number of results returned.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListReviewPolicyResultsForHitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReviewPolicyResultsForHitInput");
        formatter.field("hit_id", &self.hit_id);
        formatter.field("policy_levels", &self.policy_levels);
        formatter.field("retrieve_actions", &self.retrieve_actions);
        formatter.field("retrieve_results", &self.retrieve_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReviewableHiTsInput {
    /// <p>
    /// The ID of the HIT type of the HITs to consider for the query.
    /// If not specified, all HITs for the Reviewer are considered
    /// </p>
    pub hit_type_id: std::option::Option<std::string::String>,
    /// <p>
    /// Can be either <code>Reviewable</code> or <code>Reviewing</code>.
    /// Reviewable is the default value.
    /// </p>
    pub status: std::option::Option<crate::model::ReviewableHitStatus>,
    /// <p>Pagination Token</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>
    /// Limit the number of results returned.
    /// </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListReviewableHiTsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReviewableHiTsInput");
        formatter.field("hit_type_id", &self.hit_type_id);
        formatter.field("status", &self.status);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListQualificationTypesInput {
    /// <p> A text query against all of the searchable attributes of
    /// Qualification types.
    /// </p>
    pub query: std::option::Option<std::string::String>,
    /// <p>Specifies that only Qualification types that a user can
    /// request through the Amazon Mechanical Turk web site, such as by
    /// taking a Qualification test, are returned as results of the search.
    /// Some Qualification types, such as those assigned automatically by the
    /// system, cannot be requested directly by users. If false, all
    /// Qualification types, including those managed by the system, are
    /// considered. Valid values are True | False.
    /// </p>
    pub must_be_requestable: std::option::Option<bool>,
    /// <p> Specifies that only Qualification types that the Requester
    /// created are returned. If false, the operation returns all
    /// Qualification types.
    /// </p>
    pub must_be_owned_by_caller: std::option::Option<bool>,
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk
    /// returns a pagination token in the response. You can use this pagination token
    /// to retrieve the next set of results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The maximum number of results to return in a single call.
    /// </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListQualificationTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListQualificationTypesInput");
        formatter.field("query", &self.query);
        formatter.field("must_be_requestable", &self.must_be_requestable);
        formatter.field("must_be_owned_by_caller", &self.must_be_owned_by_caller);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListQualificationRequestsInput {
    /// <p>The ID of the QualificationType.</p>
    pub qualification_type_id: std::option::Option<std::string::String>,
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk
    /// returns a pagination token in the response. You can use this pagination token
    /// to retrieve the next set of results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The maximum number of results to return in a single call.
    /// </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListQualificationRequestsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListQualificationRequestsInput");
        formatter.field("qualification_type_id", &self.qualification_type_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHiTsForQualificationTypeInput {
    /// <p>
    /// The ID of the Qualification type to use when querying HITs.
    /// </p>
    pub qualification_type_id: std::option::Option<std::string::String>,
    /// <p>Pagination Token</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>
    /// Limit the number of results returned.
    /// </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListHiTsForQualificationTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHiTsForQualificationTypeInput");
        formatter.field("qualification_type_id", &self.qualification_type_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHiTsInput {
    /// <p>Pagination token</p>
    pub next_token: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListHiTsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHiTsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBonusPaymentsInput {
    /// <p>The ID of the HIT associated with the bonus payments to
    /// retrieve. If not specified, all bonus payments for all assignments
    /// for the given HIT are returned. Either the HITId parameter or the
    /// AssignmentId parameter must be specified</p>
    pub hit_id: std::option::Option<std::string::String>,
    /// <p>The ID of the assignment associated with the bonus payments
    /// to retrieve. If specified, only bonus payments for the given
    /// assignment are returned. Either the HITId parameter or the
    /// AssignmentId parameter must be specified</p>
    pub assignment_id: std::option::Option<std::string::String>,
    /// <p>Pagination token</p>
    pub next_token: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListBonusPaymentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBonusPaymentsInput");
        formatter.field("hit_id", &self.hit_id);
        formatter.field("assignment_id", &self.assignment_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssignmentsForHitInput {
    /// <p>The ID of the HIT.</p>
    pub hit_id: std::option::Option<std::string::String>,
    /// <p>Pagination token</p>
    pub next_token: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub max_results: std::option::Option<i32>,
    /// <p>The status of the assignments to return: Submitted | Approved
    /// | Rejected</p>
    pub assignment_statuses: std::option::Option<std::vec::Vec<crate::model::AssignmentStatus>>,
}
impl std::fmt::Debug for ListAssignmentsForHitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssignmentsForHitInput");
        formatter.field("hit_id", &self.hit_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("assignment_statuses", &self.assignment_statuses);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetQualificationTypeInput {
    /// <p>The ID of the QualificationType.</p>
    pub qualification_type_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetQualificationTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetQualificationTypeInput");
        formatter.field("qualification_type_id", &self.qualification_type_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetQualificationScoreInput {
    /// <p>The ID of the QualificationType.</p>
    pub qualification_type_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Worker whose Qualification is being updated.</p>
    pub worker_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetQualificationScoreInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetQualificationScoreInput");
        formatter.field("qualification_type_id", &self.qualification_type_id);
        formatter.field("worker_id", &self.worker_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetHitInput {
    /// <p>The ID of the HIT to be retrieved.</p>
    pub hit_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetHitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetHitInput");
        formatter.field("hit_id", &self.hit_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFileUploadUrlInput {
    /// <p>The ID of the assignment that contains the question with a
    /// FileUploadAnswer.</p>
    pub assignment_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the question with a FileUploadAnswer, as
    /// specified in the QuestionForm of the HIT.</p>
    pub question_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetFileUploadUrlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFileUploadUrlInput");
        formatter.field("assignment_id", &self.assignment_id);
        formatter.field("question_identifier", &self.question_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssignmentInput {
    /// <p>The ID of the Assignment to be retrieved.</p>
    pub assignment_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetAssignmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssignmentInput");
        formatter.field("assignment_id", &self.assignment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccountBalanceInput {}
impl std::fmt::Debug for GetAccountBalanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccountBalanceInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateQualificationFromWorkerInput {
    /// <p>The ID of the Worker who possesses the Qualification to be revoked.</p>
    pub worker_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Qualification type of the Qualification to be revoked.</p>
    pub qualification_type_id: std::option::Option<std::string::String>,
    /// <p>A text message that explains why the Qualification was revoked. The user who had the Qualification sees this message.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisassociateQualificationFromWorkerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateQualificationFromWorkerInput");
        formatter.field("worker_id", &self.worker_id);
        formatter.field("qualification_type_id", &self.qualification_type_id);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWorkerBlockInput {
    /// <p>The ID of the Worker to unblock.</p>
    pub worker_id: std::option::Option<std::string::String>,
    /// <p>A message that explains the reason for unblocking the Worker. The Worker does not see this message.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteWorkerBlockInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWorkerBlockInput");
        formatter.field("worker_id", &self.worker_id);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteQualificationTypeInput {
    /// <p>The ID of the QualificationType to dispose.</p>
    pub qualification_type_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteQualificationTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteQualificationTypeInput");
        formatter.field("qualification_type_id", &self.qualification_type_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteHitInput {
    /// <p>The ID of the HIT to be deleted.</p>
    pub hit_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteHitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteHitInput");
        formatter.field("hit_id", &self.hit_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorkerBlockInput {
    /// <p>The ID of the Worker to block.</p>
    pub worker_id: std::option::Option<std::string::String>,
    /// <p>A message explaining the reason for blocking the Worker. This parameter enables you to keep track of your Workers. The Worker does not see this message.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateWorkerBlockInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorkerBlockInput");
        formatter.field("worker_id", &self.worker_id);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateQualificationTypeInput {
    /// <p> The name you give to the Qualification type. The type name
    /// is used to represent the Qualification to Workers, and to find the
    /// type using a Qualification type search. It must be unique across all
    /// of your Qualification types.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>One or more words or phrases that describe the Qualification
    /// type, separated by commas. The keywords of a type make the type
    /// easier to find during a search.</p>
    pub keywords: std::option::Option<std::string::String>,
    /// <p>A long description for the Qualification type. On the Amazon
    /// Mechanical Turk website, the long description is displayed when a
    /// Worker examines a Qualification type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The initial status of the Qualification type.</p>
    /// <p>Constraints: Valid values are: Active | Inactive</p>
    pub qualification_type_status: std::option::Option<crate::model::QualificationTypeStatus>,
    /// <p>The number of seconds that a Worker must wait after
    /// requesting a Qualification of the Qualification type before the
    /// worker can retry the Qualification request.</p>
    /// <p>Constraints: None. If not specified, retries are disabled and
    /// Workers can request a Qualification of this type only once, even if
    /// the Worker has not been granted the Qualification. It is not possible
    /// to disable retries for a Qualification type after it has been created
    /// with retries enabled. If you want to disable retries, you must delete
    /// existing retry-enabled Qualification type and then create a new
    /// Qualification type with retries disabled.</p>
    pub retry_delay_in_seconds: std::option::Option<i64>,
    /// <p>
    /// The questions for the Qualification test a Worker must answer
    /// correctly to obtain a Qualification of this type. If this parameter
    /// is specified,
    /// <code>TestDurationInSeconds</code>
    /// must also be specified.
    /// </p>
    /// <p>Constraints: Must not be longer than 65535 bytes. Must be a
    /// QuestionForm data structure. This parameter cannot be specified if
    /// AutoGranted is true.</p>
    /// <p>Constraints: None. If not specified, the Worker may request
    /// the Qualification without answering any questions.</p>
    pub test: std::option::Option<std::string::String>,
    /// <p>The answers to the Qualification test specified in the Test
    /// parameter, in the form of an AnswerKey data structure.</p>
    /// <p>Constraints: Must not be longer than 65535 bytes.</p>
    /// <p>Constraints: None. If not specified, you must process
    /// Qualification requests manually.</p>
    pub answer_key: std::option::Option<std::string::String>,
    /// <p>The number of seconds the Worker has to complete the
    /// Qualification test, starting from the time the Worker requests the
    /// Qualification.</p>
    pub test_duration_in_seconds: std::option::Option<i64>,
    /// <p>Specifies whether requests for the Qualification type are
    /// granted immediately, without prompting the Worker with a
    /// Qualification test.</p>
    /// <p>Constraints: If the Test parameter is specified, this
    /// parameter cannot be true.</p>
    pub auto_granted: std::option::Option<bool>,
    /// <p>The Qualification value to use for automatically granted
    /// Qualifications. This parameter is used only if the AutoGranted
    /// parameter is true.</p>
    pub auto_granted_value: std::option::Option<i32>,
}
impl std::fmt::Debug for CreateQualificationTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateQualificationTypeInput");
        formatter.field("name", &self.name);
        formatter.field("keywords", &self.keywords);
        formatter.field("description", &self.description);
        formatter.field("qualification_type_status", &self.qualification_type_status);
        formatter.field("retry_delay_in_seconds", &self.retry_delay_in_seconds);
        formatter.field("test", &self.test);
        formatter.field("answer_key", &self.answer_key);
        formatter.field("test_duration_in_seconds", &self.test_duration_in_seconds);
        formatter.field("auto_granted", &self.auto_granted);
        formatter.field("auto_granted_value", &self.auto_granted_value);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateHitWithHitTypeInput {
    /// <p>The HIT type ID you want to create this HIT with.</p>
    pub hit_type_id: std::option::Option<std::string::String>,
    /// <p>
    /// The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
    /// </p>
    pub max_assignments: std::option::Option<i32>,
    /// <p>
    /// An amount of time, in seconds, after which the HIT is no longer available for users to accept.
    /// After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches,
    /// even if not all of the assignments for the HIT have been accepted.
    /// </p>
    pub lifetime_in_seconds: std::option::Option<i64>,
    /// <p>
    /// The data the person completing the HIT uses to produce the results.
    /// </p>
    /// <p>
    /// Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure,
    /// or an HTMLQuestion data structure. The XML question data must not be larger than
    /// 64 kilobytes (65,535 bytes) in size, including whitespace.
    /// </p>
    /// <p>Either a Question parameter or a HITLayoutId parameter must be provided.</p>
    pub question: std::option::Option<std::string::String>,
    /// <p>
    /// An arbitrary data field.
    /// The RequesterAnnotation parameter lets your application attach arbitrary data
    /// to the HIT for tracking purposes.
    /// For example, this parameter could be an identifier internal to the Requester's application
    /// that corresponds with the HIT.
    /// </p>
    /// <p>
    /// The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT.
    /// It is not shown to the Worker, or any other Requester.
    /// </p>
    /// <p>
    /// The RequesterAnnotation parameter may be different for each HIT you submit.
    /// It does not affect how your HITs are grouped.
    /// </p>
    pub requester_annotation: std::option::Option<std::string::String>,
    /// <p>
    /// A unique identifier for this request which allows you to retry the call
    /// on error without creating duplicate HITs.
    /// This is useful in cases such as network timeouts where it is unclear whether or not
    /// the call succeeded on the server.
    /// If the HIT already exists in the system from a previous call using the same UniqueRequestToken,
    /// subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error
    /// with a message containing the HITId.
    /// </p>
    /// <note>
    /// <p>
    /// Note: It is your responsibility to ensure uniqueness of the token.
    /// The unique token expires after 24 hours. Subsequent calls using the same
    /// UniqueRequestToken made after the 24 hour limit could create duplicate HITs.
    /// </p>
    /// </note>
    pub unique_request_token: std::option::Option<std::string::String>,
    /// <p>
    /// The Assignment-level Review Policy applies to the assignments under the HIT.
    /// You can specify for Mechanical Turk to take various actions based on the policy.
    /// </p>
    pub assignment_review_policy: std::option::Option<crate::model::ReviewPolicy>,
    /// <p>
    /// The HIT-level Review Policy applies to the HIT.
    /// You can specify for Mechanical Turk to take various actions based on the policy.
    /// </p>
    pub hit_review_policy: std::option::Option<crate::model::ReviewPolicy>,
    /// <p>
    /// The HITLayoutId allows you to use a pre-existing HIT design with placeholder values
    /// and create an additional HIT by providing those values as HITLayoutParameters.
    /// </p>
    /// <p>
    /// Constraints: Either a Question parameter or a HITLayoutId parameter must be provided.
    /// </p>
    pub hit_layout_id: std::option::Option<std::string::String>,
    /// <p>
    /// If the HITLayoutId is provided, any placeholder values must be filled in with values
    /// using the HITLayoutParameter structure. For more information, see HITLayout.
    /// </p>
    pub hit_layout_parameters: std::option::Option<std::vec::Vec<crate::model::HitLayoutParameter>>,
}
impl std::fmt::Debug for CreateHitWithHitTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateHitWithHitTypeInput");
        formatter.field("hit_type_id", &self.hit_type_id);
        formatter.field("max_assignments", &self.max_assignments);
        formatter.field("lifetime_in_seconds", &self.lifetime_in_seconds);
        formatter.field("question", &self.question);
        formatter.field("requester_annotation", &self.requester_annotation);
        formatter.field("unique_request_token", &self.unique_request_token);
        formatter.field("assignment_review_policy", &self.assignment_review_policy);
        formatter.field("hit_review_policy", &self.hit_review_policy);
        formatter.field("hit_layout_id", &self.hit_layout_id);
        formatter.field("hit_layout_parameters", &self.hit_layout_parameters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateHitTypeInput {
    /// <p>
    /// The number of seconds after an assignment for the HIT has been submitted,
    /// after which the assignment is considered Approved automatically
    /// unless the Requester explicitly rejects it.
    /// </p>
    pub auto_approval_delay_in_seconds: std::option::Option<i64>,
    /// <p>
    /// The amount of time, in seconds, that a Worker has to complete the HIT after accepting it.
    /// If a Worker does not complete the assignment within the specified duration,
    /// the assignment is considered abandoned. If the HIT is still active
    /// (that is, its lifetime has not elapsed), the assignment becomes available
    /// for other users to find and accept.
    /// </p>
    pub assignment_duration_in_seconds: std::option::Option<i64>,
    /// <p>
    /// The amount of money the Requester will pay a Worker for successfully completing the HIT.
    /// </p>
    pub reward: std::option::Option<std::string::String>,
    /// <p>
    /// The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains.
    /// On the Amazon Mechanical Turk web site, the HIT title appears in search results,
    /// and everywhere the HIT is mentioned.
    /// </p>
    pub title: std::option::Option<std::string::String>,
    /// <p>
    /// One or more words or phrases that describe the HIT, separated by commas.
    /// These words are used in searches to find HITs.
    /// </p>
    pub keywords: std::option::Option<std::string::String>,
    /// <p>
    /// A general description of the HIT. A description includes detailed information about the kind of task
    /// the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded
    /// view of search results, and in the HIT and assignment screens. A good description gives the user enough
    /// information to evaluate the HIT before accepting it.
    /// </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>
    /// Conditions that a Worker's Qualifications must meet in order
    /// to accept the HIT. A HIT can have between zero and ten
    /// Qualification requirements. All requirements must be met in
    /// order for a Worker to accept the HIT. Additionally, other
    /// actions can be restricted using the <code>ActionsGuarded</code>
    /// field on each <code>QualificationRequirement</code> structure.
    /// </p>
    pub qualification_requirements:
        std::option::Option<std::vec::Vec<crate::model::QualificationRequirement>>,
}
impl std::fmt::Debug for CreateHitTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateHitTypeInput");
        formatter.field(
            "auto_approval_delay_in_seconds",
            &self.auto_approval_delay_in_seconds,
        );
        formatter.field(
            "assignment_duration_in_seconds",
            &self.assignment_duration_in_seconds,
        );
        formatter.field("reward", &self.reward);
        formatter.field("title", &self.title);
        formatter.field("keywords", &self.keywords);
        formatter.field("description", &self.description);
        formatter.field(
            "qualification_requirements",
            &self.qualification_requirements,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateHitInput {
    /// <p>
    /// The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
    /// </p>
    pub max_assignments: std::option::Option<i32>,
    /// <p>
    /// The number of seconds after an assignment for the HIT has been submitted,
    /// after which the assignment is considered Approved automatically
    /// unless the Requester explicitly rejects it.
    /// </p>
    pub auto_approval_delay_in_seconds: std::option::Option<i64>,
    /// <p>
    /// An amount of time, in seconds, after which the HIT is no longer available for users to accept.
    /// After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches,
    /// even if not all of the assignments for the HIT have been accepted.
    /// </p>
    pub lifetime_in_seconds: std::option::Option<i64>,
    /// <p>
    /// The amount of time, in seconds, that a Worker has to complete the HIT after accepting it.
    /// If a Worker does not complete the assignment within the specified duration,
    /// the assignment is considered abandoned. If the HIT is still active
    /// (that is, its lifetime has not elapsed), the assignment becomes available
    /// for other users to find and accept.
    /// </p>
    pub assignment_duration_in_seconds: std::option::Option<i64>,
    /// <p>
    /// The amount of money the Requester will pay a Worker for successfully completing the HIT.
    /// </p>
    pub reward: std::option::Option<std::string::String>,
    /// <p>
    /// The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains.
    /// On the Amazon Mechanical Turk web site, the HIT title appears in search results,
    /// and everywhere the HIT is mentioned.
    /// </p>
    pub title: std::option::Option<std::string::String>,
    /// <p>
    /// One or more words or phrases that describe the HIT, separated by commas.
    /// These words are used in searches to find HITs.
    /// </p>
    pub keywords: std::option::Option<std::string::String>,
    /// <p>
    /// A general description of the HIT. A description includes detailed information about the kind of task
    /// the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded
    /// view of search results, and in the HIT and assignment screens. A good description gives the user enough
    /// information to evaluate the HIT before accepting it.
    /// </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>
    /// The data the person completing the HIT uses to produce the results.
    /// </p>
    /// <p>
    /// Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure,
    /// or an HTMLQuestion data structure. The XML question data must not be larger than
    /// 64 kilobytes (65,535 bytes) in size, including whitespace.
    /// </p>
    /// <p>Either a Question parameter or a HITLayoutId parameter must be provided.</p>
    pub question: std::option::Option<std::string::String>,
    /// <p>
    /// An arbitrary data field.
    /// The RequesterAnnotation parameter lets your application attach arbitrary data
    /// to the HIT for tracking purposes.
    /// For example, this parameter could be an identifier internal to the Requester's application
    /// that corresponds with the HIT.
    /// </p>
    /// <p>
    /// The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT.
    /// It is not shown to the Worker, or any other Requester.
    /// </p>
    /// <p>
    /// The RequesterAnnotation parameter may be different for each HIT you submit.
    /// It does not affect how your HITs are grouped.
    /// </p>
    pub requester_annotation: std::option::Option<std::string::String>,
    /// <p>
    /// Conditions that a Worker's Qualifications must meet in order
    /// to accept the HIT. A HIT can have between zero and ten
    /// Qualification requirements. All requirements must be met in
    /// order for a Worker to accept the HIT. Additionally, other
    /// actions can be restricted using the <code>ActionsGuarded</code>
    /// field on each <code>QualificationRequirement</code> structure.
    /// </p>
    pub qualification_requirements:
        std::option::Option<std::vec::Vec<crate::model::QualificationRequirement>>,
    /// <p>
    /// A unique identifier for this request which allows you to retry the call
    /// on error without creating duplicate HITs.
    /// This is useful in cases such as network timeouts where it is unclear whether or not
    /// the call succeeded on the server.
    /// If the HIT already exists in the system from a previous call using the same UniqueRequestToken,
    /// subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error
    /// with a message containing the HITId.
    /// </p>
    /// <note>
    /// <p>
    /// Note: It is your responsibility to ensure uniqueness of the token.
    /// The unique token expires after 24 hours. Subsequent calls using the same
    /// UniqueRequestToken made after the 24 hour limit could create duplicate HITs.
    /// </p>
    /// </note>
    pub unique_request_token: std::option::Option<std::string::String>,
    /// <p>
    /// The Assignment-level Review Policy applies to the assignments under the HIT.
    /// You can specify for Mechanical Turk to take various actions based on the policy.
    /// </p>
    pub assignment_review_policy: std::option::Option<crate::model::ReviewPolicy>,
    /// <p>
    /// The HIT-level Review Policy applies to the HIT.
    /// You can specify for Mechanical Turk to take various actions based on the policy.
    /// </p>
    pub hit_review_policy: std::option::Option<crate::model::ReviewPolicy>,
    /// <p>
    /// The HITLayoutId allows you to use a pre-existing HIT design with placeholder values
    /// and create an additional HIT by providing those values as HITLayoutParameters.
    /// </p>
    /// <p>
    /// Constraints: Either a Question parameter or a HITLayoutId parameter must be provided.
    /// </p>
    pub hit_layout_id: std::option::Option<std::string::String>,
    /// <p>
    /// If the HITLayoutId is provided, any placeholder values must be filled in with values
    /// using the HITLayoutParameter structure. For more information, see HITLayout.
    /// </p>
    pub hit_layout_parameters: std::option::Option<std::vec::Vec<crate::model::HitLayoutParameter>>,
}
impl std::fmt::Debug for CreateHitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateHitInput");
        formatter.field("max_assignments", &self.max_assignments);
        formatter.field(
            "auto_approval_delay_in_seconds",
            &self.auto_approval_delay_in_seconds,
        );
        formatter.field("lifetime_in_seconds", &self.lifetime_in_seconds);
        formatter.field(
            "assignment_duration_in_seconds",
            &self.assignment_duration_in_seconds,
        );
        formatter.field("reward", &self.reward);
        formatter.field("title", &self.title);
        formatter.field("keywords", &self.keywords);
        formatter.field("description", &self.description);
        formatter.field("question", &self.question);
        formatter.field("requester_annotation", &self.requester_annotation);
        formatter.field(
            "qualification_requirements",
            &self.qualification_requirements,
        );
        formatter.field("unique_request_token", &self.unique_request_token);
        formatter.field("assignment_review_policy", &self.assignment_review_policy);
        formatter.field("hit_review_policy", &self.hit_review_policy);
        formatter.field("hit_layout_id", &self.hit_layout_id);
        formatter.field("hit_layout_parameters", &self.hit_layout_parameters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAdditionalAssignmentsForHitInput {
    /// <p>The ID of the HIT to extend.</p>
    pub hit_id: std::option::Option<std::string::String>,
    /// <p>The number of additional assignments to request for this HIT.</p>
    pub number_of_additional_assignments: std::option::Option<i32>,
    /// <p>
    /// A unique identifier for this request, which allows you to retry the call on error
    /// without extending the HIT multiple times.
    /// This is useful in cases such as network timeouts where it is unclear whether or not
    /// the call succeeded on the server. If the extend HIT already exists in the system
    /// from a previous call using the same <code>UniqueRequestToken</code>,
    /// subsequent calls will return an error with a message containing the request ID.
    /// </p>
    pub unique_request_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateAdditionalAssignmentsForHitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAdditionalAssignmentsForHitInput");
        formatter.field("hit_id", &self.hit_id);
        formatter.field(
            "number_of_additional_assignments",
            &self.number_of_additional_assignments,
        );
        formatter.field("unique_request_token", &self.unique_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateQualificationWithWorkerInput {
    /// <p>The ID of the Qualification type to use for the assigned Qualification.</p>
    pub qualification_type_id: std::option::Option<std::string::String>,
    /// <p>
    /// The ID of the Worker to whom the Qualification is being assigned.
    /// Worker IDs are included with submitted HIT assignments and Qualification requests.
    /// </p>
    pub worker_id: std::option::Option<std::string::String>,
    /// <p>The value of the Qualification to assign.</p>
    pub integer_value: std::option::Option<i32>,
    /// <p>
    /// Specifies whether to send a notification email message to the Worker
    /// saying that the qualification was assigned to the Worker.
    /// Note: this is true by default.
    /// </p>
    pub send_notification: std::option::Option<bool>,
}
impl std::fmt::Debug for AssociateQualificationWithWorkerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateQualificationWithWorkerInput");
        formatter.field("qualification_type_id", &self.qualification_type_id);
        formatter.field("worker_id", &self.worker_id);
        formatter.field("integer_value", &self.integer_value);
        formatter.field("send_notification", &self.send_notification);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApproveAssignmentInput {
    /// <p>
    /// The ID of the assignment. The assignment must correspond to a HIT created by the Requester.
    /// </p>
    pub assignment_id: std::option::Option<std::string::String>,
    /// <p>
    /// A message for the Worker, which the Worker can see in the Status section of the web site.
    /// </p>
    pub requester_feedback: std::option::Option<std::string::String>,
    /// <p>
    /// A flag indicating that an assignment should be approved even if it was previously rejected. Defaults to <code>False</code>.
    /// </p>
    pub override_rejection: std::option::Option<bool>,
}
impl std::fmt::Debug for ApproveAssignmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApproveAssignmentInput");
        formatter.field("assignment_id", &self.assignment_id);
        formatter.field("requester_feedback", &self.requester_feedback);
        formatter.field("override_rejection", &self.override_rejection);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptQualificationRequestInput {
    /// <p>The ID of the Qualification request, as returned by the <code>GetQualificationRequests</code> operation.</p>
    pub qualification_request_id: std::option::Option<std::string::String>,
    /// <p>
    /// The value of the Qualification. You can omit this value if you are using the
    /// presence or absence of the Qualification as the basis for a HIT requirement.
    /// </p>
    pub integer_value: std::option::Option<i32>,
}
impl std::fmt::Debug for AcceptQualificationRequestInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptQualificationRequestInput");
        formatter.field("qualification_request_id", &self.qualification_request_id);
        formatter.field("integer_value", &self.integer_value);
        formatter.finish()
    }
}
