// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `MTurkRequesterServiceV20170117`.
///
/// This client allows ergonomic access to a `MTurkRequesterServiceV20170117`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptQualificationRequest` operation.
    ///
    /// See [`AcceptQualificationRequest`](crate::client::fluent_builders::AcceptQualificationRequest) for more information about the
    /// operation and its arguments.
    pub fn accept_qualification_request(
        &self,
    ) -> fluent_builders::AcceptQualificationRequest<C, M, R> {
        fluent_builders::AcceptQualificationRequest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ApproveAssignment` operation.
    ///
    /// See [`ApproveAssignment`](crate::client::fluent_builders::ApproveAssignment) for more information about the
    /// operation and its arguments.
    pub fn approve_assignment(&self) -> fluent_builders::ApproveAssignment<C, M, R> {
        fluent_builders::ApproveAssignment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateQualificationWithWorker` operation.
    ///
    /// See [`AssociateQualificationWithWorker`](crate::client::fluent_builders::AssociateQualificationWithWorker) for more information about the
    /// operation and its arguments.
    pub fn associate_qualification_with_worker(
        &self,
    ) -> fluent_builders::AssociateQualificationWithWorker<C, M, R> {
        fluent_builders::AssociateQualificationWithWorker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAdditionalAssignmentsForHIT` operation.
    ///
    /// See [`CreateAdditionalAssignmentsForHIT`](crate::client::fluent_builders::CreateAdditionalAssignmentsForHIT) for more information about the
    /// operation and its arguments.
    pub fn create_additional_assignments_for_hit(
        &self,
    ) -> fluent_builders::CreateAdditionalAssignmentsForHIT<C, M, R> {
        fluent_builders::CreateAdditionalAssignmentsForHIT::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateHIT` operation.
    ///
    /// See [`CreateHIT`](crate::client::fluent_builders::CreateHIT) for more information about the
    /// operation and its arguments.
    pub fn create_hit(&self) -> fluent_builders::CreateHIT<C, M, R> {
        fluent_builders::CreateHIT::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateHITType` operation.
    ///
    /// See [`CreateHITType`](crate::client::fluent_builders::CreateHITType) for more information about the
    /// operation and its arguments.
    pub fn create_hit_type(&self) -> fluent_builders::CreateHITType<C, M, R> {
        fluent_builders::CreateHITType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateHITWithHITType` operation.
    ///
    /// See [`CreateHITWithHITType`](crate::client::fluent_builders::CreateHITWithHITType) for more information about the
    /// operation and its arguments.
    pub fn create_hit_with_hit_type(&self) -> fluent_builders::CreateHITWithHITType<C, M, R> {
        fluent_builders::CreateHITWithHITType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateQualificationType` operation.
    ///
    /// See [`CreateQualificationType`](crate::client::fluent_builders::CreateQualificationType) for more information about the
    /// operation and its arguments.
    pub fn create_qualification_type(&self) -> fluent_builders::CreateQualificationType<C, M, R> {
        fluent_builders::CreateQualificationType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWorkerBlock` operation.
    ///
    /// See [`CreateWorkerBlock`](crate::client::fluent_builders::CreateWorkerBlock) for more information about the
    /// operation and its arguments.
    pub fn create_worker_block(&self) -> fluent_builders::CreateWorkerBlock<C, M, R> {
        fluent_builders::CreateWorkerBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteHIT` operation.
    ///
    /// See [`DeleteHIT`](crate::client::fluent_builders::DeleteHIT) for more information about the
    /// operation and its arguments.
    pub fn delete_hit(&self) -> fluent_builders::DeleteHIT<C, M, R> {
        fluent_builders::DeleteHIT::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteQualificationType` operation.
    ///
    /// See [`DeleteQualificationType`](crate::client::fluent_builders::DeleteQualificationType) for more information about the
    /// operation and its arguments.
    pub fn delete_qualification_type(&self) -> fluent_builders::DeleteQualificationType<C, M, R> {
        fluent_builders::DeleteQualificationType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWorkerBlock` operation.
    ///
    /// See [`DeleteWorkerBlock`](crate::client::fluent_builders::DeleteWorkerBlock) for more information about the
    /// operation and its arguments.
    pub fn delete_worker_block(&self) -> fluent_builders::DeleteWorkerBlock<C, M, R> {
        fluent_builders::DeleteWorkerBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateQualificationFromWorker` operation.
    ///
    /// See [`DisassociateQualificationFromWorker`](crate::client::fluent_builders::DisassociateQualificationFromWorker) for more information about the
    /// operation and its arguments.
    pub fn disassociate_qualification_from_worker(
        &self,
    ) -> fluent_builders::DisassociateQualificationFromWorker<C, M, R> {
        fluent_builders::DisassociateQualificationFromWorker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccountBalance` operation.
    ///
    /// See [`GetAccountBalance`](crate::client::fluent_builders::GetAccountBalance) for more information about the
    /// operation and its arguments.
    pub fn get_account_balance(&self) -> fluent_builders::GetAccountBalance<C, M, R> {
        fluent_builders::GetAccountBalance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAssignment` operation.
    ///
    /// See [`GetAssignment`](crate::client::fluent_builders::GetAssignment) for more information about the
    /// operation and its arguments.
    pub fn get_assignment(&self) -> fluent_builders::GetAssignment<C, M, R> {
        fluent_builders::GetAssignment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFileUploadURL` operation.
    ///
    /// See [`GetFileUploadURL`](crate::client::fluent_builders::GetFileUploadURL) for more information about the
    /// operation and its arguments.
    pub fn get_file_upload_url(&self) -> fluent_builders::GetFileUploadURL<C, M, R> {
        fluent_builders::GetFileUploadURL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetHIT` operation.
    ///
    /// See [`GetHIT`](crate::client::fluent_builders::GetHIT) for more information about the
    /// operation and its arguments.
    pub fn get_hit(&self) -> fluent_builders::GetHIT<C, M, R> {
        fluent_builders::GetHIT::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetQualificationScore` operation.
    ///
    /// See [`GetQualificationScore`](crate::client::fluent_builders::GetQualificationScore) for more information about the
    /// operation and its arguments.
    pub fn get_qualification_score(&self) -> fluent_builders::GetQualificationScore<C, M, R> {
        fluent_builders::GetQualificationScore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetQualificationType` operation.
    ///
    /// See [`GetQualificationType`](crate::client::fluent_builders::GetQualificationType) for more information about the
    /// operation and its arguments.
    pub fn get_qualification_type(&self) -> fluent_builders::GetQualificationType<C, M, R> {
        fluent_builders::GetQualificationType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssignmentsForHIT` operation.
    ///
    /// See [`ListAssignmentsForHIT`](crate::client::fluent_builders::ListAssignmentsForHIT) for more information about the
    /// operation and its arguments.
    pub fn list_assignments_for_hit(&self) -> fluent_builders::ListAssignmentsForHIT<C, M, R> {
        fluent_builders::ListAssignmentsForHIT::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBonusPayments` operation.
    ///
    /// See [`ListBonusPayments`](crate::client::fluent_builders::ListBonusPayments) for more information about the
    /// operation and its arguments.
    pub fn list_bonus_payments(&self) -> fluent_builders::ListBonusPayments<C, M, R> {
        fluent_builders::ListBonusPayments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListHITs` operation.
    ///
    /// See [`ListHITs`](crate::client::fluent_builders::ListHITs) for more information about the
    /// operation and its arguments.
    pub fn list_hi_ts(&self) -> fluent_builders::ListHITs<C, M, R> {
        fluent_builders::ListHITs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListHITsForQualificationType` operation.
    ///
    /// See [`ListHITsForQualificationType`](crate::client::fluent_builders::ListHITsForQualificationType) for more information about the
    /// operation and its arguments.
    pub fn list_hi_ts_for_qualification_type(
        &self,
    ) -> fluent_builders::ListHITsForQualificationType<C, M, R> {
        fluent_builders::ListHITsForQualificationType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListQualificationRequests` operation.
    ///
    /// See [`ListQualificationRequests`](crate::client::fluent_builders::ListQualificationRequests) for more information about the
    /// operation and its arguments.
    pub fn list_qualification_requests(
        &self,
    ) -> fluent_builders::ListQualificationRequests<C, M, R> {
        fluent_builders::ListQualificationRequests::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListQualificationTypes` operation.
    ///
    /// See [`ListQualificationTypes`](crate::client::fluent_builders::ListQualificationTypes) for more information about the
    /// operation and its arguments.
    pub fn list_qualification_types(&self) -> fluent_builders::ListQualificationTypes<C, M, R> {
        fluent_builders::ListQualificationTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListReviewableHITs` operation.
    ///
    /// See [`ListReviewableHITs`](crate::client::fluent_builders::ListReviewableHITs) for more information about the
    /// operation and its arguments.
    pub fn list_reviewable_hi_ts(&self) -> fluent_builders::ListReviewableHITs<C, M, R> {
        fluent_builders::ListReviewableHITs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListReviewPolicyResultsForHIT` operation.
    ///
    /// See [`ListReviewPolicyResultsForHIT`](crate::client::fluent_builders::ListReviewPolicyResultsForHIT) for more information about the
    /// operation and its arguments.
    pub fn list_review_policy_results_for_hit(
        &self,
    ) -> fluent_builders::ListReviewPolicyResultsForHIT<C, M, R> {
        fluent_builders::ListReviewPolicyResultsForHIT::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWorkerBlocks` operation.
    ///
    /// See [`ListWorkerBlocks`](crate::client::fluent_builders::ListWorkerBlocks) for more information about the
    /// operation and its arguments.
    pub fn list_worker_blocks(&self) -> fluent_builders::ListWorkerBlocks<C, M, R> {
        fluent_builders::ListWorkerBlocks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWorkersWithQualificationType` operation.
    ///
    /// See [`ListWorkersWithQualificationType`](crate::client::fluent_builders::ListWorkersWithQualificationType) for more information about the
    /// operation and its arguments.
    pub fn list_workers_with_qualification_type(
        &self,
    ) -> fluent_builders::ListWorkersWithQualificationType<C, M, R> {
        fluent_builders::ListWorkersWithQualificationType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `NotifyWorkers` operation.
    ///
    /// See [`NotifyWorkers`](crate::client::fluent_builders::NotifyWorkers) for more information about the
    /// operation and its arguments.
    pub fn notify_workers(&self) -> fluent_builders::NotifyWorkers<C, M, R> {
        fluent_builders::NotifyWorkers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectAssignment` operation.
    ///
    /// See [`RejectAssignment`](crate::client::fluent_builders::RejectAssignment) for more information about the
    /// operation and its arguments.
    pub fn reject_assignment(&self) -> fluent_builders::RejectAssignment<C, M, R> {
        fluent_builders::RejectAssignment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectQualificationRequest` operation.
    ///
    /// See [`RejectQualificationRequest`](crate::client::fluent_builders::RejectQualificationRequest) for more information about the
    /// operation and its arguments.
    pub fn reject_qualification_request(
        &self,
    ) -> fluent_builders::RejectQualificationRequest<C, M, R> {
        fluent_builders::RejectQualificationRequest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendBonus` operation.
    ///
    /// See [`SendBonus`](crate::client::fluent_builders::SendBonus) for more information about the
    /// operation and its arguments.
    pub fn send_bonus(&self) -> fluent_builders::SendBonus<C, M, R> {
        fluent_builders::SendBonus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendTestEventNotification` operation.
    ///
    /// See [`SendTestEventNotification`](crate::client::fluent_builders::SendTestEventNotification) for more information about the
    /// operation and its arguments.
    pub fn send_test_event_notification(
        &self,
    ) -> fluent_builders::SendTestEventNotification<C, M, R> {
        fluent_builders::SendTestEventNotification::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateExpirationForHIT` operation.
    ///
    /// See [`UpdateExpirationForHIT`](crate::client::fluent_builders::UpdateExpirationForHIT) for more information about the
    /// operation and its arguments.
    pub fn update_expiration_for_hit(&self) -> fluent_builders::UpdateExpirationForHIT<C, M, R> {
        fluent_builders::UpdateExpirationForHIT::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateHITReviewStatus` operation.
    ///
    /// See [`UpdateHITReviewStatus`](crate::client::fluent_builders::UpdateHITReviewStatus) for more information about the
    /// operation and its arguments.
    pub fn update_hit_review_status(&self) -> fluent_builders::UpdateHITReviewStatus<C, M, R> {
        fluent_builders::UpdateHITReviewStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateHITTypeOfHIT` operation.
    ///
    /// See [`UpdateHITTypeOfHIT`](crate::client::fluent_builders::UpdateHITTypeOfHIT) for more information about the
    /// operation and its arguments.
    pub fn update_hit_type_of_hit(&self) -> fluent_builders::UpdateHITTypeOfHIT<C, M, R> {
        fluent_builders::UpdateHITTypeOfHIT::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateNotificationSettings` operation.
    ///
    /// See [`UpdateNotificationSettings`](crate::client::fluent_builders::UpdateNotificationSettings) for more information about the
    /// operation and its arguments.
    pub fn update_notification_settings(
        &self,
    ) -> fluent_builders::UpdateNotificationSettings<C, M, R> {
        fluent_builders::UpdateNotificationSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateQualificationType` operation.
    ///
    /// See [`UpdateQualificationType`](crate::client::fluent_builders::UpdateQualificationType) for more information about the
    /// operation and its arguments.
    pub fn update_qualification_type(&self) -> fluent_builders::UpdateQualificationType<C, M, R> {
        fluent_builders::UpdateQualificationType::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptQualificationRequest`.
    ///
    /// <p>
    /// The <code>AcceptQualificationRequest</code> operation approves a Worker's request for a Qualification.
    /// </p>
    /// <p>
    /// Only the owner of the Qualification type can grant a Qualification request for that  type.
    /// </p>
    /// <p>
    /// A successful request for the <code>AcceptQualificationRequest</code> operation
    /// returns with no errors and an empty body.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct AcceptQualificationRequest<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_qualification_request_input::Builder,
    }
    impl<C, M, R> AcceptQualificationRequest<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptQualificationRequest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptQualificationRequestOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptQualificationRequestError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptQualificationRequestInputOperationOutputAlias,
                crate::output::AcceptQualificationRequestOutput,
                crate::error::AcceptQualificationRequestError,
                crate::input::AcceptQualificationRequestInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Qualification request, as returned by the <code>GetQualificationRequests</code> operation.</p>
        pub fn qualification_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_request_id(inp);
            self
        }
        /// <p>The ID of the Qualification request, as returned by the <code>GetQualificationRequests</code> operation.</p>
        pub fn set_qualification_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_request_id(input);
            self
        }
        /// <p>
        /// The value of the Qualification. You can omit this value if you are using the
        /// presence or absence of the Qualification as the basis for a HIT requirement.
        /// </p>
        pub fn integer_value(mut self, inp: i32) -> Self {
            self.inner = self.inner.integer_value(inp);
            self
        }
        /// <p>
        /// The value of the Qualification. You can omit this value if you are using the
        /// presence or absence of the Qualification as the basis for a HIT requirement.
        /// </p>
        pub fn set_integer_value(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_integer_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ApproveAssignment`.
    ///
    /// <p>
    /// The <code>ApproveAssignment</code> operation approves the results of a completed assignment.
    /// </p>
    /// <p>
    /// Approving an assignment initiates two payments from the Requester's Amazon.com account
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The Worker who submitted the results is paid the reward specified in the HIT.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// Amazon Mechanical Turk fees are debited.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>
    /// If the Requester's account does not have adequate funds for these payments,
    /// the call to ApproveAssignment returns an exception, and the approval is not processed.
    /// You can include an optional feedback message with the approval,
    /// which the Worker can see in the Status section of the web site.
    /// </p>
    /// <p>
    /// You can also call this operation for assignments that were previous rejected
    /// and approve them by explicitly overriding the previous rejection.
    /// This only works on rejected assignments that were submitted within the previous 30 days
    /// and only if the assignment's related HIT has not been deleted.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ApproveAssignment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::approve_assignment_input::Builder,
    }
    impl<C, M, R> ApproveAssignment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ApproveAssignment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ApproveAssignmentOutput,
            aws_smithy_http::result::SdkError<crate::error::ApproveAssignmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ApproveAssignmentInputOperationOutputAlias,
                crate::output::ApproveAssignmentOutput,
                crate::error::ApproveAssignmentError,
                crate::input::ApproveAssignmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The ID of the assignment. The assignment must correspond to a HIT created by the Requester.
        /// </p>
        pub fn assignment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_id(inp);
            self
        }
        /// <p>
        /// The ID of the assignment. The assignment must correspond to a HIT created by the Requester.
        /// </p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_id(input);
            self
        }
        /// <p>
        /// A message for the Worker, which the Worker can see in the Status section of the web site.
        /// </p>
        pub fn requester_feedback(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.requester_feedback(inp);
            self
        }
        /// <p>
        /// A message for the Worker, which the Worker can see in the Status section of the web site.
        /// </p>
        pub fn set_requester_feedback(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_requester_feedback(input);
            self
        }
        /// <p>
        /// A flag indicating that an assignment should be approved even if it was previously rejected. Defaults to <code>False</code>.
        /// </p>
        pub fn override_rejection(mut self, inp: bool) -> Self {
            self.inner = self.inner.override_rejection(inp);
            self
        }
        /// <p>
        /// A flag indicating that an assignment should be approved even if it was previously rejected. Defaults to <code>False</code>.
        /// </p>
        pub fn set_override_rejection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_override_rejection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateQualificationWithWorker`.
    ///
    /// <p>
    /// The <code>AssociateQualificationWithWorker</code> operation gives a Worker a
    /// Qualification. <code>AssociateQualificationWithWorker</code> does not require that the Worker
    /// submit a Qualification request. It gives the Qualification directly to the Worker.
    /// </p>
    ///
    /// <p>
    /// You can only assign a Qualification of a Qualification type that you created (using
    /// the <code>CreateQualificationType</code> operation).
    /// </p>
    ///
    /// <note>
    /// <p>
    /// Note: <code>AssociateQualificationWithWorker</code> does not affect any pending Qualification
    /// requests for the Qualification by the Worker. If you assign a Qualification to a
    /// Worker, then later grant a Qualification request made by the Worker, the granting of
    /// the request may modify the Qualification score. To resolve a pending Qualification
    /// request without affecting the Qualification the Worker already has, reject the
    /// request with the <code>RejectQualificationRequest</code> operation.
    /// </p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct AssociateQualificationWithWorker<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_qualification_with_worker_input::Builder,
    }
    impl<C, M, R> AssociateQualificationWithWorker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateQualificationWithWorker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateQualificationWithWorkerOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateQualificationWithWorkerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateQualificationWithWorkerInputOperationOutputAlias,
                crate::output::AssociateQualificationWithWorkerOutput,
                crate::error::AssociateQualificationWithWorkerError,
                crate::input::AssociateQualificationWithWorkerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Qualification type to use for the assigned Qualification.</p>
        pub fn qualification_type_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_type_id(inp);
            self
        }
        /// <p>The ID of the Qualification type to use for the assigned Qualification.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_id(input);
            self
        }
        /// <p>
        /// The ID of the Worker to whom the Qualification is being assigned.
        /// Worker IDs are included with submitted HIT assignments and Qualification requests.
        /// </p>
        pub fn worker_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worker_id(inp);
            self
        }
        /// <p>
        /// The ID of the Worker to whom the Qualification is being assigned.
        /// Worker IDs are included with submitted HIT assignments and Qualification requests.
        /// </p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_worker_id(input);
            self
        }
        /// <p>The value of the Qualification to assign.</p>
        pub fn integer_value(mut self, inp: i32) -> Self {
            self.inner = self.inner.integer_value(inp);
            self
        }
        /// <p>The value of the Qualification to assign.</p>
        pub fn set_integer_value(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_integer_value(input);
            self
        }
        /// <p>
        /// Specifies whether to send a notification email message to the Worker
        /// saying that the qualification was assigned to the Worker.
        /// Note: this is true by default.
        /// </p>
        pub fn send_notification(mut self, inp: bool) -> Self {
            self.inner = self.inner.send_notification(inp);
            self
        }
        /// <p>
        /// Specifies whether to send a notification email message to the Worker
        /// saying that the qualification was assigned to the Worker.
        /// Note: this is true by default.
        /// </p>
        pub fn set_send_notification(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_send_notification(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAdditionalAssignmentsForHIT`.
    ///
    /// <p>
    /// The
    /// <code>CreateAdditionalAssignmentsForHIT</code>
    /// operation increases the maximum number of assignments of an existing HIT.
    /// </p>
    /// <p>
    /// To extend the maximum number of assignments, specify the number of additional assignments.</p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>HITs created with fewer than 10 assignments cannot be extended to have 10 or more assignments. Attempting to add assignments in a way that brings the total number of assignments for a HIT from fewer than 10 assignments to 10 or more
    /// assignments will result in an
    /// <code>AWS.MechanicalTurk.InvalidMaximumAssignmentsIncrease</code>
    /// exception.</p>
    /// </li>
    /// <li>
    /// <p>HITs that were created before July 22, 2015 cannot be extended. Attempting to extend HITs that were created before July 22, 2015 will result in an
    /// <code>AWS.MechanicalTurk.HITTooOldForExtension</code>
    /// exception.
    /// </p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateAdditionalAssignmentsForHIT<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_additional_assignments_for_hit_input::Builder,
    }
    impl<C, M, R> CreateAdditionalAssignmentsForHIT<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAdditionalAssignmentsForHIT`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAdditionalAssignmentsForHitOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAdditionalAssignmentsForHITError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAdditionalAssignmentsForHitInputOperationOutputAlias,
                crate::output::CreateAdditionalAssignmentsForHitOutput,
                crate::error::CreateAdditionalAssignmentsForHITError,
                crate::input::CreateAdditionalAssignmentsForHitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the HIT to extend.</p>
        pub fn hit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_id(inp);
            self
        }
        /// <p>The ID of the HIT to extend.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_id(input);
            self
        }
        /// <p>The number of additional assignments to request for this HIT.</p>
        pub fn number_of_additional_assignments(mut self, inp: i32) -> Self {
            self.inner = self.inner.number_of_additional_assignments(inp);
            self
        }
        /// <p>The number of additional assignments to request for this HIT.</p>
        pub fn set_number_of_additional_assignments(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_number_of_additional_assignments(input);
            self
        }
        /// <p>
        /// A unique identifier for this request, which allows you to retry the call on error
        /// without extending the HIT multiple times.
        /// This is useful in cases such as network timeouts where it is unclear whether or not
        /// the call succeeded on the server. If the extend HIT already exists in the system
        /// from a previous call using the same <code>UniqueRequestToken</code>,
        /// subsequent calls will return an error with a message containing the request ID.
        /// </p>
        pub fn unique_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.unique_request_token(inp);
            self
        }
        /// <p>
        /// A unique identifier for this request, which allows you to retry the call on error
        /// without extending the HIT multiple times.
        /// This is useful in cases such as network timeouts where it is unclear whether or not
        /// the call succeeded on the server. If the extend HIT already exists in the system
        /// from a previous call using the same <code>UniqueRequestToken</code>,
        /// subsequent calls will return an error with a message containing the request ID.
        /// </p>
        pub fn set_unique_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_unique_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHIT`.
    ///
    /// <p>The <code>CreateHIT</code> operation creates a new Human Intelligence Task (HIT).
    /// The new HIT is made available for Workers to find and accept on the Amazon Mechanical
    /// Turk website. </p>
    /// <p>
    /// This operation allows you to specify a new HIT by passing in values for the properties of the HIT, such as its title, reward amount and number of assignments. When you pass these values to <code>CreateHIT</code>, a new HIT is created for you, with a new <code>HITTypeID</code>. The HITTypeID can be used to create additional HITs in the future without needing to specify common parameters such as the title, description and reward amount each time.</p>
    /// <p> An alternative way to create HITs is to first generate a HITTypeID using the <code>CreateHITType</code> operation and then call the <code>CreateHITWithHITType</code> operation. This is the recommended best practice for Requesters who are creating large numbers of HITs.
    /// </p>
    ///
    /// <p>CreateHIT also supports several ways to provide question data: by providing a value
    /// for the <code>Question</code> parameter that fully specifies the contents of the HIT, or by providing
    /// a <code>HitLayoutId</code> and associated <code>HitLayoutParameters</code>.
    /// </p>
    ///
    /// <note>
    /// <p> If a HIT is created with 10 or more maximum assignments, there is an additional fee. For more information, see
    /// <a href="https://requester.mturk.com/pricing">Amazon Mechanical Turk Pricing</a>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateHIT<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_hit_input::Builder,
    }
    impl<C, M, R> CreateHIT<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateHIT`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHitOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHITError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateHitInputOperationOutputAlias,
                crate::output::CreateHitOutput,
                crate::error::CreateHITError,
                crate::input::CreateHitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
        /// </p>
        pub fn max_assignments(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_assignments(inp);
            self
        }
        /// <p>
        /// The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
        /// </p>
        pub fn set_max_assignments(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_assignments(input);
            self
        }
        /// <p>
        /// The number of seconds after an assignment for the HIT has been submitted,
        /// after which the assignment is considered Approved automatically
        /// unless the Requester explicitly rejects it.
        /// </p>
        pub fn auto_approval_delay_in_seconds(mut self, inp: i64) -> Self {
            self.inner = self.inner.auto_approval_delay_in_seconds(inp);
            self
        }
        /// <p>
        /// The number of seconds after an assignment for the HIT has been submitted,
        /// after which the assignment is considered Approved automatically
        /// unless the Requester explicitly rejects it.
        /// </p>
        pub fn set_auto_approval_delay_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self.inner.set_auto_approval_delay_in_seconds(input);
            self
        }
        /// <p>
        /// An amount of time, in seconds, after which the HIT is no longer available for users to accept.
        /// After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches,
        /// even if not all of the assignments for the HIT have been accepted.
        /// </p>
        pub fn lifetime_in_seconds(mut self, inp: i64) -> Self {
            self.inner = self.inner.lifetime_in_seconds(inp);
            self
        }
        /// <p>
        /// An amount of time, in seconds, after which the HIT is no longer available for users to accept.
        /// After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches,
        /// even if not all of the assignments for the HIT have been accepted.
        /// </p>
        pub fn set_lifetime_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_lifetime_in_seconds(input);
            self
        }
        /// <p>
        /// The amount of time, in seconds, that a Worker has to complete the HIT after accepting it.
        /// If a Worker does not complete the assignment within the specified duration,
        /// the assignment is considered abandoned. If the HIT is still active
        /// (that is, its lifetime has not elapsed), the assignment becomes available
        /// for other users to find and accept.
        /// </p>
        pub fn assignment_duration_in_seconds(mut self, inp: i64) -> Self {
            self.inner = self.inner.assignment_duration_in_seconds(inp);
            self
        }
        /// <p>
        /// The amount of time, in seconds, that a Worker has to complete the HIT after accepting it.
        /// If a Worker does not complete the assignment within the specified duration,
        /// the assignment is considered abandoned. If the HIT is still active
        /// (that is, its lifetime has not elapsed), the assignment becomes available
        /// for other users to find and accept.
        /// </p>
        pub fn set_assignment_duration_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self.inner.set_assignment_duration_in_seconds(input);
            self
        }
        /// <p>
        /// The amount of money the Requester will pay a Worker for successfully completing the HIT.
        /// </p>
        pub fn reward(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reward(inp);
            self
        }
        /// <p>
        /// The amount of money the Requester will pay a Worker for successfully completing the HIT.
        /// </p>
        pub fn set_reward(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reward(input);
            self
        }
        /// <p>
        /// The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains.
        /// On the Amazon Mechanical Turk web site, the HIT title appears in search results,
        /// and everywhere the HIT is mentioned.
        /// </p>
        pub fn title(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.title(inp);
            self
        }
        /// <p>
        /// The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains.
        /// On the Amazon Mechanical Turk web site, the HIT title appears in search results,
        /// and everywhere the HIT is mentioned.
        /// </p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_title(input);
            self
        }
        /// <p>
        /// One or more words or phrases that describe the HIT, separated by commas.
        /// These words are used in searches to find HITs.
        /// </p>
        pub fn keywords(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keywords(inp);
            self
        }
        /// <p>
        /// One or more words or phrases that describe the HIT, separated by commas.
        /// These words are used in searches to find HITs.
        /// </p>
        pub fn set_keywords(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_keywords(input);
            self
        }
        /// <p>
        /// A general description of the HIT. A description includes detailed information about the kind of task
        /// the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded
        /// view of search results, and in the HIT and assignment screens. A good description gives the user enough
        /// information to evaluate the HIT before accepting it.
        /// </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>
        /// A general description of the HIT. A description includes detailed information about the kind of task
        /// the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded
        /// view of search results, and in the HIT and assignment screens. A good description gives the user enough
        /// information to evaluate the HIT before accepting it.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>
        /// The data the person completing the HIT uses to produce the results.
        /// </p>
        /// <p>
        /// Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure,
        /// or an HTMLQuestion data structure. The XML question data must not be larger than
        /// 64 kilobytes (65,535 bytes) in size, including whitespace.
        /// </p>
        /// <p>Either a Question parameter or a HITLayoutId parameter must be provided.</p>
        pub fn question(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.question(inp);
            self
        }
        /// <p>
        /// The data the person completing the HIT uses to produce the results.
        /// </p>
        /// <p>
        /// Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure,
        /// or an HTMLQuestion data structure. The XML question data must not be larger than
        /// 64 kilobytes (65,535 bytes) in size, including whitespace.
        /// </p>
        /// <p>Either a Question parameter or a HITLayoutId parameter must be provided.</p>
        pub fn set_question(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_question(input);
            self
        }
        /// <p>
        /// An arbitrary data field.
        /// The RequesterAnnotation parameter lets your application attach arbitrary data
        /// to the HIT for tracking purposes.
        /// For example, this parameter could be an identifier internal to the Requester's application
        /// that corresponds with the HIT.
        /// </p>
        /// <p>
        /// The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT.
        /// It is not shown to the Worker, or any other Requester.
        /// </p>
        /// <p>
        /// The RequesterAnnotation parameter may be different for each HIT you submit.
        /// It does not affect how your HITs are grouped.
        /// </p>
        pub fn requester_annotation(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.requester_annotation(inp);
            self
        }
        /// <p>
        /// An arbitrary data field.
        /// The RequesterAnnotation parameter lets your application attach arbitrary data
        /// to the HIT for tracking purposes.
        /// For example, this parameter could be an identifier internal to the Requester's application
        /// that corresponds with the HIT.
        /// </p>
        /// <p>
        /// The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT.
        /// It is not shown to the Worker, or any other Requester.
        /// </p>
        /// <p>
        /// The RequesterAnnotation parameter may be different for each HIT you submit.
        /// It does not affect how your HITs are grouped.
        /// </p>
        pub fn set_requester_annotation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_requester_annotation(input);
            self
        }
        /// Appends an item to `QualificationRequirements`.
        ///
        /// To override the contents of this collection use [`set_qualification_requirements`](Self::set_qualification_requirements).
        ///
        /// <p>
        /// Conditions that a Worker's Qualifications must meet in order
        /// to accept the HIT. A HIT can have between zero and ten
        /// Qualification requirements. All requirements must be met in
        /// order for a Worker to accept the HIT. Additionally, other
        /// actions can be restricted using the <code>ActionsGuarded</code>
        /// field on each <code>QualificationRequirement</code> structure.
        /// </p>
        pub fn qualification_requirements(
            mut self,
            inp: impl Into<crate::model::QualificationRequirement>,
        ) -> Self {
            self.inner = self.inner.qualification_requirements(inp);
            self
        }
        /// <p>
        /// Conditions that a Worker's Qualifications must meet in order
        /// to accept the HIT. A HIT can have between zero and ten
        /// Qualification requirements. All requirements must be met in
        /// order for a Worker to accept the HIT. Additionally, other
        /// actions can be restricted using the <code>ActionsGuarded</code>
        /// field on each <code>QualificationRequirement</code> structure.
        /// </p>
        pub fn set_qualification_requirements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QualificationRequirement>>,
        ) -> Self {
            self.inner = self.inner.set_qualification_requirements(input);
            self
        }
        /// <p>
        /// A unique identifier for this request which allows you to retry the call
        /// on error without creating duplicate HITs.
        /// This is useful in cases such as network timeouts where it is unclear whether or not
        /// the call succeeded on the server.
        /// If the HIT already exists in the system from a previous call using the same UniqueRequestToken,
        /// subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error
        /// with a message containing the HITId.
        /// </p>
        /// <note>
        /// <p>
        /// Note: It is your responsibility to ensure uniqueness of the token.
        /// The unique token expires after 24 hours. Subsequent calls using the same
        /// UniqueRequestToken made after the 24 hour limit could create duplicate HITs.
        /// </p>
        /// </note>
        pub fn unique_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.unique_request_token(inp);
            self
        }
        /// <p>
        /// A unique identifier for this request which allows you to retry the call
        /// on error without creating duplicate HITs.
        /// This is useful in cases such as network timeouts where it is unclear whether or not
        /// the call succeeded on the server.
        /// If the HIT already exists in the system from a previous call using the same UniqueRequestToken,
        /// subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error
        /// with a message containing the HITId.
        /// </p>
        /// <note>
        /// <p>
        /// Note: It is your responsibility to ensure uniqueness of the token.
        /// The unique token expires after 24 hours. Subsequent calls using the same
        /// UniqueRequestToken made after the 24 hour limit could create duplicate HITs.
        /// </p>
        /// </note>
        pub fn set_unique_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_unique_request_token(input);
            self
        }
        /// <p>
        /// The Assignment-level Review Policy applies to the assignments under the HIT.
        /// You can specify for Mechanical Turk to take various actions based on the policy.
        /// </p>
        pub fn assignment_review_policy(mut self, inp: crate::model::ReviewPolicy) -> Self {
            self.inner = self.inner.assignment_review_policy(inp);
            self
        }
        /// <p>
        /// The Assignment-level Review Policy applies to the assignments under the HIT.
        /// You can specify for Mechanical Turk to take various actions based on the policy.
        /// </p>
        pub fn set_assignment_review_policy(
            mut self,
            input: std::option::Option<crate::model::ReviewPolicy>,
        ) -> Self {
            self.inner = self.inner.set_assignment_review_policy(input);
            self
        }
        /// <p>
        /// The HIT-level Review Policy applies to the HIT.
        /// You can specify for Mechanical Turk to take various actions based on the policy.
        /// </p>
        pub fn hit_review_policy(mut self, inp: crate::model::ReviewPolicy) -> Self {
            self.inner = self.inner.hit_review_policy(inp);
            self
        }
        /// <p>
        /// The HIT-level Review Policy applies to the HIT.
        /// You can specify for Mechanical Turk to take various actions based on the policy.
        /// </p>
        pub fn set_hit_review_policy(
            mut self,
            input: std::option::Option<crate::model::ReviewPolicy>,
        ) -> Self {
            self.inner = self.inner.set_hit_review_policy(input);
            self
        }
        /// <p>
        /// The HITLayoutId allows you to use a pre-existing HIT design with placeholder values
        /// and create an additional HIT by providing those values as HITLayoutParameters.
        /// </p>
        /// <p>
        /// Constraints: Either a Question parameter or a HITLayoutId parameter must be provided.
        /// </p>
        pub fn hit_layout_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_layout_id(inp);
            self
        }
        /// <p>
        /// The HITLayoutId allows you to use a pre-existing HIT design with placeholder values
        /// and create an additional HIT by providing those values as HITLayoutParameters.
        /// </p>
        /// <p>
        /// Constraints: Either a Question parameter or a HITLayoutId parameter must be provided.
        /// </p>
        pub fn set_hit_layout_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hit_layout_id(input);
            self
        }
        /// Appends an item to `HITLayoutParameters`.
        ///
        /// To override the contents of this collection use [`set_hit_layout_parameters`](Self::set_hit_layout_parameters).
        ///
        /// <p>
        /// If the HITLayoutId is provided, any placeholder values must be filled in with values
        /// using the HITLayoutParameter structure. For more information, see HITLayout.
        /// </p>
        pub fn hit_layout_parameters(
            mut self,
            inp: impl Into<crate::model::HitLayoutParameter>,
        ) -> Self {
            self.inner = self.inner.hit_layout_parameters(inp);
            self
        }
        /// <p>
        /// If the HITLayoutId is provided, any placeholder values must be filled in with values
        /// using the HITLayoutParameter structure. For more information, see HITLayout.
        /// </p>
        pub fn set_hit_layout_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HitLayoutParameter>>,
        ) -> Self {
            self.inner = self.inner.set_hit_layout_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHITType`.
    ///
    /// <p>
    /// The <code>CreateHITType</code> operation creates a new HIT type. This operation
    /// allows you to define a standard set of HIT properties to use when creating HITs.
    /// If you register a HIT type with values that match an existing HIT type, the HIT type
    /// ID of the existing type will be returned.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateHITType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_hit_type_input::Builder,
    }
    impl<C, M, R> CreateHITType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateHITType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHitTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHITTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateHitTypeInputOperationOutputAlias,
                crate::output::CreateHitTypeOutput,
                crate::error::CreateHITTypeError,
                crate::input::CreateHitTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The number of seconds after an assignment for the HIT has been submitted,
        /// after which the assignment is considered Approved automatically
        /// unless the Requester explicitly rejects it.
        /// </p>
        pub fn auto_approval_delay_in_seconds(mut self, inp: i64) -> Self {
            self.inner = self.inner.auto_approval_delay_in_seconds(inp);
            self
        }
        /// <p>
        /// The number of seconds after an assignment for the HIT has been submitted,
        /// after which the assignment is considered Approved automatically
        /// unless the Requester explicitly rejects it.
        /// </p>
        pub fn set_auto_approval_delay_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self.inner.set_auto_approval_delay_in_seconds(input);
            self
        }
        /// <p>
        /// The amount of time, in seconds, that a Worker has to complete the HIT after accepting it.
        /// If a Worker does not complete the assignment within the specified duration,
        /// the assignment is considered abandoned. If the HIT is still active
        /// (that is, its lifetime has not elapsed), the assignment becomes available
        /// for other users to find and accept.
        /// </p>
        pub fn assignment_duration_in_seconds(mut self, inp: i64) -> Self {
            self.inner = self.inner.assignment_duration_in_seconds(inp);
            self
        }
        /// <p>
        /// The amount of time, in seconds, that a Worker has to complete the HIT after accepting it.
        /// If a Worker does not complete the assignment within the specified duration,
        /// the assignment is considered abandoned. If the HIT is still active
        /// (that is, its lifetime has not elapsed), the assignment becomes available
        /// for other users to find and accept.
        /// </p>
        pub fn set_assignment_duration_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self.inner.set_assignment_duration_in_seconds(input);
            self
        }
        /// <p>
        /// The amount of money the Requester will pay a Worker for successfully completing the HIT.
        /// </p>
        pub fn reward(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reward(inp);
            self
        }
        /// <p>
        /// The amount of money the Requester will pay a Worker for successfully completing the HIT.
        /// </p>
        pub fn set_reward(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reward(input);
            self
        }
        /// <p>
        /// The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains.
        /// On the Amazon Mechanical Turk web site, the HIT title appears in search results,
        /// and everywhere the HIT is mentioned.
        /// </p>
        pub fn title(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.title(inp);
            self
        }
        /// <p>
        /// The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains.
        /// On the Amazon Mechanical Turk web site, the HIT title appears in search results,
        /// and everywhere the HIT is mentioned.
        /// </p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_title(input);
            self
        }
        /// <p>
        /// One or more words or phrases that describe the HIT, separated by commas.
        /// These words are used in searches to find HITs.
        /// </p>
        pub fn keywords(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keywords(inp);
            self
        }
        /// <p>
        /// One or more words or phrases that describe the HIT, separated by commas.
        /// These words are used in searches to find HITs.
        /// </p>
        pub fn set_keywords(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_keywords(input);
            self
        }
        /// <p>
        /// A general description of the HIT. A description includes detailed information about the kind of task
        /// the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded
        /// view of search results, and in the HIT and assignment screens. A good description gives the user enough
        /// information to evaluate the HIT before accepting it.
        /// </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>
        /// A general description of the HIT. A description includes detailed information about the kind of task
        /// the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded
        /// view of search results, and in the HIT and assignment screens. A good description gives the user enough
        /// information to evaluate the HIT before accepting it.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `QualificationRequirements`.
        ///
        /// To override the contents of this collection use [`set_qualification_requirements`](Self::set_qualification_requirements).
        ///
        /// <p>
        /// Conditions that a Worker's Qualifications must meet in order
        /// to accept the HIT. A HIT can have between zero and ten
        /// Qualification requirements. All requirements must be met in
        /// order for a Worker to accept the HIT. Additionally, other
        /// actions can be restricted using the <code>ActionsGuarded</code>
        /// field on each <code>QualificationRequirement</code> structure.
        /// </p>
        pub fn qualification_requirements(
            mut self,
            inp: impl Into<crate::model::QualificationRequirement>,
        ) -> Self {
            self.inner = self.inner.qualification_requirements(inp);
            self
        }
        /// <p>
        /// Conditions that a Worker's Qualifications must meet in order
        /// to accept the HIT. A HIT can have between zero and ten
        /// Qualification requirements. All requirements must be met in
        /// order for a Worker to accept the HIT. Additionally, other
        /// actions can be restricted using the <code>ActionsGuarded</code>
        /// field on each <code>QualificationRequirement</code> structure.
        /// </p>
        pub fn set_qualification_requirements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QualificationRequirement>>,
        ) -> Self {
            self.inner = self.inner.set_qualification_requirements(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHITWithHITType`.
    ///
    /// <p>
    /// The <code>CreateHITWithHITType</code> operation creates a new Human Intelligence Task (HIT)
    /// using an existing HITTypeID generated by the <code>CreateHITType</code> operation.
    /// </p>
    /// <p>
    /// This is an alternative way to create HITs from the <code>CreateHIT</code> operation.
    /// This is the recommended best practice for Requesters who are creating large numbers of HITs.
    /// </p>
    /// <p>CreateHITWithHITType also supports several ways to provide question data:
    /// by providing a value for the <code>Question</code> parameter that fully specifies the contents of the HIT,
    /// or by providing a <code>HitLayoutId</code> and associated <code>HitLayoutParameters</code>.
    /// </p>
    /// <note>
    /// <p>
    /// If a HIT is created with 10 or more maximum assignments, there is an additional fee.
    /// For more information, see <a href="https://requester.mturk.com/pricing">Amazon Mechanical Turk Pricing</a>.
    /// </p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateHITWithHITType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_hit_with_hit_type_input::Builder,
    }
    impl<C, M, R> CreateHITWithHITType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateHITWithHITType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHitWithHitTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHITWithHITTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateHitWithHitTypeInputOperationOutputAlias,
                crate::output::CreateHitWithHitTypeOutput,
                crate::error::CreateHITWithHITTypeError,
                crate::input::CreateHitWithHitTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The HIT type ID you want to create this HIT with.</p>
        pub fn hit_type_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_type_id(inp);
            self
        }
        /// <p>The HIT type ID you want to create this HIT with.</p>
        pub fn set_hit_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_type_id(input);
            self
        }
        /// <p>
        /// The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
        /// </p>
        pub fn max_assignments(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_assignments(inp);
            self
        }
        /// <p>
        /// The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
        /// </p>
        pub fn set_max_assignments(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_assignments(input);
            self
        }
        /// <p>
        /// An amount of time, in seconds, after which the HIT is no longer available for users to accept.
        /// After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches,
        /// even if not all of the assignments for the HIT have been accepted.
        /// </p>
        pub fn lifetime_in_seconds(mut self, inp: i64) -> Self {
            self.inner = self.inner.lifetime_in_seconds(inp);
            self
        }
        /// <p>
        /// An amount of time, in seconds, after which the HIT is no longer available for users to accept.
        /// After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches,
        /// even if not all of the assignments for the HIT have been accepted.
        /// </p>
        pub fn set_lifetime_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_lifetime_in_seconds(input);
            self
        }
        /// <p>
        /// The data the person completing the HIT uses to produce the results.
        /// </p>
        /// <p>
        /// Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure,
        /// or an HTMLQuestion data structure. The XML question data must not be larger than
        /// 64 kilobytes (65,535 bytes) in size, including whitespace.
        /// </p>
        /// <p>Either a Question parameter or a HITLayoutId parameter must be provided.</p>
        pub fn question(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.question(inp);
            self
        }
        /// <p>
        /// The data the person completing the HIT uses to produce the results.
        /// </p>
        /// <p>
        /// Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure,
        /// or an HTMLQuestion data structure. The XML question data must not be larger than
        /// 64 kilobytes (65,535 bytes) in size, including whitespace.
        /// </p>
        /// <p>Either a Question parameter or a HITLayoutId parameter must be provided.</p>
        pub fn set_question(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_question(input);
            self
        }
        /// <p>
        /// An arbitrary data field.
        /// The RequesterAnnotation parameter lets your application attach arbitrary data
        /// to the HIT for tracking purposes.
        /// For example, this parameter could be an identifier internal to the Requester's application
        /// that corresponds with the HIT.
        /// </p>
        /// <p>
        /// The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT.
        /// It is not shown to the Worker, or any other Requester.
        /// </p>
        /// <p>
        /// The RequesterAnnotation parameter may be different for each HIT you submit.
        /// It does not affect how your HITs are grouped.
        /// </p>
        pub fn requester_annotation(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.requester_annotation(inp);
            self
        }
        /// <p>
        /// An arbitrary data field.
        /// The RequesterAnnotation parameter lets your application attach arbitrary data
        /// to the HIT for tracking purposes.
        /// For example, this parameter could be an identifier internal to the Requester's application
        /// that corresponds with the HIT.
        /// </p>
        /// <p>
        /// The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT.
        /// It is not shown to the Worker, or any other Requester.
        /// </p>
        /// <p>
        /// The RequesterAnnotation parameter may be different for each HIT you submit.
        /// It does not affect how your HITs are grouped.
        /// </p>
        pub fn set_requester_annotation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_requester_annotation(input);
            self
        }
        /// <p>
        /// A unique identifier for this request which allows you to retry the call
        /// on error without creating duplicate HITs.
        /// This is useful in cases such as network timeouts where it is unclear whether or not
        /// the call succeeded on the server.
        /// If the HIT already exists in the system from a previous call using the same UniqueRequestToken,
        /// subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error
        /// with a message containing the HITId.
        /// </p>
        /// <note>
        /// <p>
        /// Note: It is your responsibility to ensure uniqueness of the token.
        /// The unique token expires after 24 hours. Subsequent calls using the same
        /// UniqueRequestToken made after the 24 hour limit could create duplicate HITs.
        /// </p>
        /// </note>
        pub fn unique_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.unique_request_token(inp);
            self
        }
        /// <p>
        /// A unique identifier for this request which allows you to retry the call
        /// on error without creating duplicate HITs.
        /// This is useful in cases such as network timeouts where it is unclear whether or not
        /// the call succeeded on the server.
        /// If the HIT already exists in the system from a previous call using the same UniqueRequestToken,
        /// subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error
        /// with a message containing the HITId.
        /// </p>
        /// <note>
        /// <p>
        /// Note: It is your responsibility to ensure uniqueness of the token.
        /// The unique token expires after 24 hours. Subsequent calls using the same
        /// UniqueRequestToken made after the 24 hour limit could create duplicate HITs.
        /// </p>
        /// </note>
        pub fn set_unique_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_unique_request_token(input);
            self
        }
        /// <p>
        /// The Assignment-level Review Policy applies to the assignments under the HIT.
        /// You can specify for Mechanical Turk to take various actions based on the policy.
        /// </p>
        pub fn assignment_review_policy(mut self, inp: crate::model::ReviewPolicy) -> Self {
            self.inner = self.inner.assignment_review_policy(inp);
            self
        }
        /// <p>
        /// The Assignment-level Review Policy applies to the assignments under the HIT.
        /// You can specify for Mechanical Turk to take various actions based on the policy.
        /// </p>
        pub fn set_assignment_review_policy(
            mut self,
            input: std::option::Option<crate::model::ReviewPolicy>,
        ) -> Self {
            self.inner = self.inner.set_assignment_review_policy(input);
            self
        }
        /// <p>
        /// The HIT-level Review Policy applies to the HIT.
        /// You can specify for Mechanical Turk to take various actions based on the policy.
        /// </p>
        pub fn hit_review_policy(mut self, inp: crate::model::ReviewPolicy) -> Self {
            self.inner = self.inner.hit_review_policy(inp);
            self
        }
        /// <p>
        /// The HIT-level Review Policy applies to the HIT.
        /// You can specify for Mechanical Turk to take various actions based on the policy.
        /// </p>
        pub fn set_hit_review_policy(
            mut self,
            input: std::option::Option<crate::model::ReviewPolicy>,
        ) -> Self {
            self.inner = self.inner.set_hit_review_policy(input);
            self
        }
        /// <p>
        /// The HITLayoutId allows you to use a pre-existing HIT design with placeholder values
        /// and create an additional HIT by providing those values as HITLayoutParameters.
        /// </p>
        /// <p>
        /// Constraints: Either a Question parameter or a HITLayoutId parameter must be provided.
        /// </p>
        pub fn hit_layout_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_layout_id(inp);
            self
        }
        /// <p>
        /// The HITLayoutId allows you to use a pre-existing HIT design with placeholder values
        /// and create an additional HIT by providing those values as HITLayoutParameters.
        /// </p>
        /// <p>
        /// Constraints: Either a Question parameter or a HITLayoutId parameter must be provided.
        /// </p>
        pub fn set_hit_layout_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hit_layout_id(input);
            self
        }
        /// Appends an item to `HITLayoutParameters`.
        ///
        /// To override the contents of this collection use [`set_hit_layout_parameters`](Self::set_hit_layout_parameters).
        ///
        /// <p>
        /// If the HITLayoutId is provided, any placeholder values must be filled in with values
        /// using the HITLayoutParameter structure. For more information, see HITLayout.
        /// </p>
        pub fn hit_layout_parameters(
            mut self,
            inp: impl Into<crate::model::HitLayoutParameter>,
        ) -> Self {
            self.inner = self.inner.hit_layout_parameters(inp);
            self
        }
        /// <p>
        /// If the HITLayoutId is provided, any placeholder values must be filled in with values
        /// using the HITLayoutParameter structure. For more information, see HITLayout.
        /// </p>
        pub fn set_hit_layout_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HitLayoutParameter>>,
        ) -> Self {
            self.inner = self.inner.set_hit_layout_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateQualificationType`.
    ///
    /// <p>
    /// The
    /// <code>CreateQualificationType</code>
    /// operation creates a new Qualification type, which is represented by a
    /// <code>QualificationType</code>
    /// data structure.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateQualificationType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_qualification_type_input::Builder,
    }
    impl<C, M, R> CreateQualificationType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateQualificationType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateQualificationTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateQualificationTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateQualificationTypeInputOperationOutputAlias,
                crate::output::CreateQualificationTypeOutput,
                crate::error::CreateQualificationTypeError,
                crate::input::CreateQualificationTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name you give to the Qualification type. The type name
        /// is used to represent the Qualification to Workers, and to find the
        /// type using a Qualification type search. It must be unique across all
        /// of your Qualification types.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p> The name you give to the Qualification type. The type name
        /// is used to represent the Qualification to Workers, and to find the
        /// type using a Qualification type search. It must be unique across all
        /// of your Qualification types.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>One or more words or phrases that describe the Qualification
        /// type, separated by commas. The keywords of a type make the type
        /// easier to find during a search.</p>
        pub fn keywords(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keywords(inp);
            self
        }
        /// <p>One or more words or phrases that describe the Qualification
        /// type, separated by commas. The keywords of a type make the type
        /// easier to find during a search.</p>
        pub fn set_keywords(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_keywords(input);
            self
        }
        /// <p>A long description for the Qualification type. On the Amazon
        /// Mechanical Turk website, the long description is displayed when a
        /// Worker examines a Qualification type.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A long description for the Qualification type. On the Amazon
        /// Mechanical Turk website, the long description is displayed when a
        /// Worker examines a Qualification type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The initial status of the Qualification type.</p>
        /// <p>Constraints: Valid values are: Active | Inactive</p>
        pub fn qualification_type_status(
            mut self,
            inp: crate::model::QualificationTypeStatus,
        ) -> Self {
            self.inner = self.inner.qualification_type_status(inp);
            self
        }
        /// <p>The initial status of the Qualification type.</p>
        /// <p>Constraints: Valid values are: Active | Inactive</p>
        pub fn set_qualification_type_status(
            mut self,
            input: std::option::Option<crate::model::QualificationTypeStatus>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_status(input);
            self
        }
        /// <p>The number of seconds that a Worker must wait after
        /// requesting a Qualification of the Qualification type before the
        /// worker can retry the Qualification request.</p>
        /// <p>Constraints: None. If not specified, retries are disabled and
        /// Workers can request a Qualification of this type only once, even if
        /// the Worker has not been granted the Qualification. It is not possible
        /// to disable retries for a Qualification type after it has been created
        /// with retries enabled. If you want to disable retries, you must delete
        /// existing retry-enabled Qualification type and then create a new
        /// Qualification type with retries disabled.</p>
        pub fn retry_delay_in_seconds(mut self, inp: i64) -> Self {
            self.inner = self.inner.retry_delay_in_seconds(inp);
            self
        }
        /// <p>The number of seconds that a Worker must wait after
        /// requesting a Qualification of the Qualification type before the
        /// worker can retry the Qualification request.</p>
        /// <p>Constraints: None. If not specified, retries are disabled and
        /// Workers can request a Qualification of this type only once, even if
        /// the Worker has not been granted the Qualification. It is not possible
        /// to disable retries for a Qualification type after it has been created
        /// with retries enabled. If you want to disable retries, you must delete
        /// existing retry-enabled Qualification type and then create a new
        /// Qualification type with retries disabled.</p>
        pub fn set_retry_delay_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_retry_delay_in_seconds(input);
            self
        }
        /// <p>
        /// The questions for the Qualification test a Worker must answer
        /// correctly to obtain a Qualification of this type. If this parameter
        /// is specified,
        /// <code>TestDurationInSeconds</code>
        /// must also be specified.
        /// </p>
        /// <p>Constraints: Must not be longer than 65535 bytes. Must be a
        /// QuestionForm data structure. This parameter cannot be specified if
        /// AutoGranted is true.</p>
        /// <p>Constraints: None. If not specified, the Worker may request
        /// the Qualification without answering any questions.</p>
        pub fn test(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.test(inp);
            self
        }
        /// <p>
        /// The questions for the Qualification test a Worker must answer
        /// correctly to obtain a Qualification of this type. If this parameter
        /// is specified,
        /// <code>TestDurationInSeconds</code>
        /// must also be specified.
        /// </p>
        /// <p>Constraints: Must not be longer than 65535 bytes. Must be a
        /// QuestionForm data structure. This parameter cannot be specified if
        /// AutoGranted is true.</p>
        /// <p>Constraints: None. If not specified, the Worker may request
        /// the Qualification without answering any questions.</p>
        pub fn set_test(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_test(input);
            self
        }
        /// <p>The answers to the Qualification test specified in the Test
        /// parameter, in the form of an AnswerKey data structure.</p>
        /// <p>Constraints: Must not be longer than 65535 bytes.</p>
        /// <p>Constraints: None. If not specified, you must process
        /// Qualification requests manually.</p>
        pub fn answer_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.answer_key(inp);
            self
        }
        /// <p>The answers to the Qualification test specified in the Test
        /// parameter, in the form of an AnswerKey data structure.</p>
        /// <p>Constraints: Must not be longer than 65535 bytes.</p>
        /// <p>Constraints: None. If not specified, you must process
        /// Qualification requests manually.</p>
        pub fn set_answer_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_answer_key(input);
            self
        }
        /// <p>The number of seconds the Worker has to complete the
        /// Qualification test, starting from the time the Worker requests the
        /// Qualification.</p>
        pub fn test_duration_in_seconds(mut self, inp: i64) -> Self {
            self.inner = self.inner.test_duration_in_seconds(inp);
            self
        }
        /// <p>The number of seconds the Worker has to complete the
        /// Qualification test, starting from the time the Worker requests the
        /// Qualification.</p>
        pub fn set_test_duration_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_test_duration_in_seconds(input);
            self
        }
        /// <p>Specifies whether requests for the Qualification type are
        /// granted immediately, without prompting the Worker with a
        /// Qualification test.</p>
        /// <p>Constraints: If the Test parameter is specified, this
        /// parameter cannot be true.</p>
        pub fn auto_granted(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_granted(inp);
            self
        }
        /// <p>Specifies whether requests for the Qualification type are
        /// granted immediately, without prompting the Worker with a
        /// Qualification test.</p>
        /// <p>Constraints: If the Test parameter is specified, this
        /// parameter cannot be true.</p>
        pub fn set_auto_granted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_granted(input);
            self
        }
        /// <p>The Qualification value to use for automatically granted
        /// Qualifications. This parameter is used only if the AutoGranted
        /// parameter is true.</p>
        pub fn auto_granted_value(mut self, inp: i32) -> Self {
            self.inner = self.inner.auto_granted_value(inp);
            self
        }
        /// <p>The Qualification value to use for automatically granted
        /// Qualifications. This parameter is used only if the AutoGranted
        /// parameter is true.</p>
        pub fn set_auto_granted_value(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_auto_granted_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkerBlock`.
    ///
    /// <p>The <code>CreateWorkerBlock</code> operation allows you to prevent a Worker from working on your HITs. For example, you can block a Worker who is producing poor quality work. You can block up to 100,000 Workers.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateWorkerBlock<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_worker_block_input::Builder,
    }
    impl<C, M, R> CreateWorkerBlock<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorkerBlock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkerBlockOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkerBlockError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorkerBlockInputOperationOutputAlias,
                crate::output::CreateWorkerBlockOutput,
                crate::error::CreateWorkerBlockError,
                crate::input::CreateWorkerBlockInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Worker to block.</p>
        pub fn worker_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worker_id(inp);
            self
        }
        /// <p>The ID of the Worker to block.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_worker_id(input);
            self
        }
        /// <p>A message explaining the reason for blocking the Worker. This parameter enables you to keep track of your Workers. The Worker does not see this message.</p>
        pub fn reason(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(inp);
            self
        }
        /// <p>A message explaining the reason for blocking the Worker. This parameter enables you to keep track of your Workers. The Worker does not see this message.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHIT`.
    ///
    /// <p>
    /// The <code>DeleteHIT</code> operation is used to delete HIT that is no longer needed.
    /// Only the Requester who created the HIT can delete it.
    /// </p>
    /// <p>
    /// You can only dispose of HITs that are in the <code>Reviewable</code> state,
    /// with all of their submitted assignments already either approved or rejected.
    /// If you call the DeleteHIT operation on a HIT that is not in the <code>Reviewable</code> state
    /// (for example, that has not expired, or still has active assignments),
    /// or on a HIT that is Reviewable but without all of its submitted assignments
    /// already approved or rejected, the service will return an error.
    /// </p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>
    /// HITs are automatically disposed of after 120 days.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// After you dispose of a HIT, you can no longer approve the HIT's rejected assignments.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// Disposed HITs are not returned in results for the ListHITs operation.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// Disposing HITs can improve the performance of operations such as ListReviewableHITs and ListHITs.
    /// </p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteHIT<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_hit_input::Builder,
    }
    impl<C, M, R> DeleteHIT<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteHIT`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHitOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHITError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteHitInputOperationOutputAlias,
                crate::output::DeleteHitOutput,
                crate::error::DeleteHITError,
                crate::input::DeleteHitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the HIT to be deleted.</p>
        pub fn hit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_id(inp);
            self
        }
        /// <p>The ID of the HIT to be deleted.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteQualificationType`.
    ///
    /// <p>
    /// The
    /// <code>DeleteQualificationType</code>
    /// deletes a Qualification type and deletes any HIT types that are
    /// associated with the Qualification type.
    /// </p>
    /// <p>This operation does not revoke Qualifications already assigned
    /// to Workers because the Qualifications might be needed for active HITs.
    /// If there are any pending requests for the Qualification type, Amazon
    /// Mechanical Turk rejects those requests. After you delete a
    /// Qualification type, you can no longer use it to create HITs or HIT
    /// types.</p>
    /// <note>
    /// <p>DeleteQualificationType must wait for all the HITs that use
    /// the deleted Qualification type to be deleted before completing. It
    /// may take up to 48 hours before DeleteQualificationType completes and
    /// the unique name of the Qualification type is available for reuse with
    /// CreateQualificationType.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteQualificationType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_qualification_type_input::Builder,
    }
    impl<C, M, R> DeleteQualificationType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteQualificationType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteQualificationTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteQualificationTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteQualificationTypeInputOperationOutputAlias,
                crate::output::DeleteQualificationTypeOutput,
                crate::error::DeleteQualificationTypeError,
                crate::input::DeleteQualificationTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the QualificationType to dispose.</p>
        pub fn qualification_type_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_type_id(inp);
            self
        }
        /// <p>The ID of the QualificationType to dispose.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkerBlock`.
    ///
    /// <p>The <code>DeleteWorkerBlock</code> operation allows you to reinstate a blocked Worker to work on your HITs. This operation reverses the effects of the CreateWorkerBlock operation. You need the Worker ID to use this operation. If the Worker ID is missing or invalid, this operation fails and returns the message “WorkerId is invalid.” If the specified Worker is not blocked, this operation returns successfully.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteWorkerBlock<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_worker_block_input::Builder,
    }
    impl<C, M, R> DeleteWorkerBlock<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWorkerBlock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkerBlockOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkerBlockError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWorkerBlockInputOperationOutputAlias,
                crate::output::DeleteWorkerBlockOutput,
                crate::error::DeleteWorkerBlockError,
                crate::input::DeleteWorkerBlockInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Worker to unblock.</p>
        pub fn worker_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worker_id(inp);
            self
        }
        /// <p>The ID of the Worker to unblock.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_worker_id(input);
            self
        }
        /// <p>A message that explains the reason for unblocking the Worker. The Worker does not see this message.</p>
        pub fn reason(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(inp);
            self
        }
        /// <p>A message that explains the reason for unblocking the Worker. The Worker does not see this message.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateQualificationFromWorker`.
    ///
    /// <p>
    /// The   <code>DisassociateQualificationFromWorker</code>
    /// revokes a previously granted Qualification from a user.
    /// </p>
    /// <p>
    /// You can provide a text message explaining why the Qualification was
    /// revoked. The user who had the Qualification can see this message.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateQualificationFromWorker<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_qualification_from_worker_input::Builder,
    }
    impl<C, M, R> DisassociateQualificationFromWorker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateQualificationFromWorker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateQualificationFromWorkerOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateQualificationFromWorkerError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateQualificationFromWorkerInputOperationOutputAlias,
                crate::output::DisassociateQualificationFromWorkerOutput,
                crate::error::DisassociateQualificationFromWorkerError,
                crate::input::DisassociateQualificationFromWorkerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Worker who possesses the Qualification to be revoked.</p>
        pub fn worker_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worker_id(inp);
            self
        }
        /// <p>The ID of the Worker who possesses the Qualification to be revoked.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_worker_id(input);
            self
        }
        /// <p>The ID of the Qualification type of the Qualification to be revoked.</p>
        pub fn qualification_type_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_type_id(inp);
            self
        }
        /// <p>The ID of the Qualification type of the Qualification to be revoked.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_id(input);
            self
        }
        /// <p>A text message that explains why the Qualification was revoked. The user who had the Qualification sees this message.</p>
        pub fn reason(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(inp);
            self
        }
        /// <p>A text message that explains why the Qualification was revoked. The user who had the Qualification sees this message.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccountBalance`.
    ///
    /// <p>The <code>GetAccountBalance</code> operation retrieves the Prepaid HITs balance in your Amazon Mechanical Turk account if you are a Prepaid Requester.
    /// Alternatively, this operation will retrieve the remaining available AWS Billing usage if you have enabled AWS Billing.
    /// Note: If you have enabled AWS Billing and still have a remaining Prepaid HITs balance, this balance can be viewed on the My Account page in the Requester console.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAccountBalance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_account_balance_input::Builder,
    }
    impl<C, M, R> GetAccountBalance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccountBalance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountBalanceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountBalanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccountBalanceInputOperationOutputAlias,
                crate::output::GetAccountBalanceOutput,
                crate::error::GetAccountBalanceError,
                crate::input::GetAccountBalanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetAssignment`.
    ///
    /// <p>
    /// The <code>GetAssignment</code> operation retrieves the details of the specified Assignment.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetAssignment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_assignment_input::Builder,
    }
    impl<C, M, R> GetAssignment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAssignment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssignmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssignmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAssignmentInputOperationOutputAlias,
                crate::output::GetAssignmentOutput,
                crate::error::GetAssignmentError,
                crate::input::GetAssignmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Assignment to be retrieved.</p>
        pub fn assignment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_id(inp);
            self
        }
        /// <p>The ID of the Assignment to be retrieved.</p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFileUploadURL`.
    ///
    /// <p>
    /// The
    /// <code>GetFileUploadURL</code>
    /// operation generates and returns a temporary URL. You use the
    /// temporary URL to retrieve a file uploaded by a Worker as an answer to
    /// a FileUploadAnswer question for a HIT. The temporary URL is generated
    /// the instant the GetFileUploadURL operation is called, and is valid
    /// for 60 seconds. You can get a temporary file upload URL any time
    /// until the HIT is disposed. After the HIT is disposed, any uploaded
    /// files are deleted, and cannot be retrieved.
    ///
    /// Pending Deprecation on December 12, 2017. The Answer Specification  
    /// structure will no longer  support the <code>FileUploadAnswer</code>
    /// element to be used for the QuestionForm data structure.
    /// Instead, we recommend that Requesters who want to create HITs asking
    /// Workers to upload files to use Amazon S3.
    ///
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetFileUploadURL<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_file_upload_url_input::Builder,
    }
    impl<C, M, R> GetFileUploadURL<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFileUploadURL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFileUploadUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFileUploadURLError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFileUploadUrlInputOperationOutputAlias,
                crate::output::GetFileUploadUrlOutput,
                crate::error::GetFileUploadURLError,
                crate::input::GetFileUploadUrlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the assignment that contains the question with a
        /// FileUploadAnswer.</p>
        pub fn assignment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_id(inp);
            self
        }
        /// <p>The ID of the assignment that contains the question with a
        /// FileUploadAnswer.</p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_id(input);
            self
        }
        /// <p>The identifier of the question with a FileUploadAnswer, as
        /// specified in the QuestionForm of the HIT.</p>
        pub fn question_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.question_identifier(inp);
            self
        }
        /// <p>The identifier of the question with a FileUploadAnswer, as
        /// specified in the QuestionForm of the HIT.</p>
        pub fn set_question_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_question_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetHIT`.
    ///
    /// <p>
    /// The <code>GetHIT</code> operation retrieves the details of the specified HIT.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetHIT<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_hit_input::Builder,
    }
    impl<C, M, R> GetHIT<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetHIT`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetHitOutput,
            aws_smithy_http::result::SdkError<crate::error::GetHITError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetHitInputOperationOutputAlias,
                crate::output::GetHitOutput,
                crate::error::GetHITError,
                crate::input::GetHitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the HIT to be retrieved.</p>
        pub fn hit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_id(inp);
            self
        }
        /// <p>The ID of the HIT to be retrieved.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetQualificationScore`.
    ///
    /// <p>
    /// The
    /// <code>GetQualificationScore</code>
    /// operation returns the value of a Worker's Qualification for a given
    /// Qualification type.
    /// </p>
    /// <p>
    /// To get a Worker's Qualification, you must know the Worker's ID. The
    /// Worker's ID is included in the assignment data returned by the
    /// <code>ListAssignmentsForHIT</code>
    /// operation.
    /// </p>
    /// <p>Only the owner of a Qualification type can query the value of
    /// a Worker's Qualification of that type.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetQualificationScore<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_qualification_score_input::Builder,
    }
    impl<C, M, R> GetQualificationScore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetQualificationScore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetQualificationScoreOutput,
            aws_smithy_http::result::SdkError<crate::error::GetQualificationScoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetQualificationScoreInputOperationOutputAlias,
                crate::output::GetQualificationScoreOutput,
                crate::error::GetQualificationScoreError,
                crate::input::GetQualificationScoreInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the QualificationType.</p>
        pub fn qualification_type_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_type_id(inp);
            self
        }
        /// <p>The ID of the QualificationType.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_id(input);
            self
        }
        /// <p>The ID of the Worker whose Qualification is being updated.</p>
        pub fn worker_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worker_id(inp);
            self
        }
        /// <p>The ID of the Worker whose Qualification is being updated.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_worker_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetQualificationType`.
    ///
    /// <p>
    /// The <code>GetQualificationType</code>operation retrieves information about a Qualification type using its ID.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetQualificationType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_qualification_type_input::Builder,
    }
    impl<C, M, R> GetQualificationType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetQualificationType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetQualificationTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetQualificationTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetQualificationTypeInputOperationOutputAlias,
                crate::output::GetQualificationTypeOutput,
                crate::error::GetQualificationTypeError,
                crate::input::GetQualificationTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the QualificationType.</p>
        pub fn qualification_type_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_type_id(inp);
            self
        }
        /// <p>The ID of the QualificationType.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssignmentsForHIT`.
    ///
    /// <p>
    /// The
    /// <code>ListAssignmentsForHIT</code>
    /// operation retrieves completed assignments for a HIT. You can use this
    /// operation to retrieve the results for a HIT.
    /// </p>
    /// <p> You can get assignments for a HIT at any time, even if the
    /// HIT is not yet Reviewable. If a HIT requested multiple assignments,
    /// and has received some results but has not yet become Reviewable, you
    /// can still retrieve the partial results with this operation.
    /// </p>
    /// <p> Use the AssignmentStatus parameter to control which set of
    /// assignments for a HIT are returned. The ListAssignmentsForHIT
    /// operation
    /// can return submitted assignments awaiting approval, or it can return
    /// assignments that have already been approved or rejected. You can set
    /// AssignmentStatus=Approved,Rejected to get assignments that have
    /// already been approved and rejected together in one result set.
    /// </p>
    /// <p> Only the Requester who created the HIT can retrieve the
    /// assignments for that HIT.
    /// </p>
    /// <p> Results are sorted and divided into numbered pages and the
    /// operation returns a single page of results. You can use the
    /// parameters
    /// of the operation to control sorting and pagination.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListAssignmentsForHIT<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_assignments_for_hit_input::Builder,
    }
    impl<C, M, R> ListAssignmentsForHIT<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssignmentsForHIT`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssignmentsForHitOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssignmentsForHITError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssignmentsForHitInputOperationOutputAlias,
                crate::output::ListAssignmentsForHitOutput,
                crate::error::ListAssignmentsForHITError,
                crate::input::ListAssignmentsForHitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the HIT.</p>
        pub fn hit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_id(inp);
            self
        }
        /// <p>The ID of the HIT.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_id(input);
            self
        }
        /// <p>Pagination token</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `AssignmentStatuses`.
        ///
        /// To override the contents of this collection use [`set_assignment_statuses`](Self::set_assignment_statuses).
        ///
        /// <p>The status of the assignments to return: Submitted | Approved
        /// | Rejected</p>
        pub fn assignment_statuses(
            mut self,
            inp: impl Into<crate::model::AssignmentStatus>,
        ) -> Self {
            self.inner = self.inner.assignment_statuses(inp);
            self
        }
        /// <p>The status of the assignments to return: Submitted | Approved
        /// | Rejected</p>
        pub fn set_assignment_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssignmentStatus>>,
        ) -> Self {
            self.inner = self.inner.set_assignment_statuses(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBonusPayments`.
    ///
    /// <p>
    /// The
    /// <code>ListBonusPayments</code>
    /// operation retrieves the amounts of bonuses you have paid to Workers
    /// for a given HIT or assignment.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListBonusPayments<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_bonus_payments_input::Builder,
    }
    impl<C, M, R> ListBonusPayments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBonusPayments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBonusPaymentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBonusPaymentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBonusPaymentsInputOperationOutputAlias,
                crate::output::ListBonusPaymentsOutput,
                crate::error::ListBonusPaymentsError,
                crate::input::ListBonusPaymentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the HIT associated with the bonus payments to
        /// retrieve. If not specified, all bonus payments for all assignments
        /// for the given HIT are returned. Either the HITId parameter or the
        /// AssignmentId parameter must be specified</p>
        pub fn hit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_id(inp);
            self
        }
        /// <p>The ID of the HIT associated with the bonus payments to
        /// retrieve. If not specified, all bonus payments for all assignments
        /// for the given HIT are returned. Either the HITId parameter or the
        /// AssignmentId parameter must be specified</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_id(input);
            self
        }
        /// <p>The ID of the assignment associated with the bonus payments
        /// to retrieve. If specified, only bonus payments for the given
        /// assignment are returned. Either the HITId parameter or the
        /// AssignmentId parameter must be specified</p>
        pub fn assignment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_id(inp);
            self
        }
        /// <p>The ID of the assignment associated with the bonus payments
        /// to retrieve. If specified, only bonus payments for the given
        /// assignment are returned. Either the HITId parameter or the
        /// AssignmentId parameter must be specified</p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_id(input);
            self
        }
        /// <p>Pagination token</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHITs`.
    ///
    /// <p>
    /// The
    /// <code>ListHITs</code>
    /// operation returns all of a Requester's HITs. The operation returns
    /// HITs of any status, except for HITs that have been deleted of with
    /// the DeleteHIT operation or that have been auto-deleted.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListHITs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_hi_ts_input::Builder,
    }
    impl<C, M, R> ListHITs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListHITs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHiTsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHITsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListHiTsInputOperationOutputAlias,
                crate::output::ListHiTsOutput,
                crate::error::ListHITsError,
                crate::input::ListHiTsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Pagination token</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHITsForQualificationType`.
    ///
    /// <p>
    /// The <code>ListHITsForQualificationType</code> operation returns the HITs that use
    /// the given Qualification type for a Qualification requirement.
    /// The operation returns HITs of any status, except for HITs that have been deleted
    /// with the <code>DeleteHIT</code> operation or that have been auto-deleted.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListHITsForQualificationType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_hi_ts_for_qualification_type_input::Builder,
    }
    impl<C, M, R> ListHITsForQualificationType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListHITsForQualificationType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHiTsForQualificationTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHITsForQualificationTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListHiTsForQualificationTypeInputOperationOutputAlias,
                crate::output::ListHiTsForQualificationTypeOutput,
                crate::error::ListHITsForQualificationTypeError,
                crate::input::ListHiTsForQualificationTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The ID of the Qualification type to use when querying HITs.
        /// </p>
        pub fn qualification_type_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_type_id(inp);
            self
        }
        /// <p>
        /// The ID of the Qualification type to use when querying HITs.
        /// </p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_id(input);
            self
        }
        /// <p>Pagination Token</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination Token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// Limit the number of results returned.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// Limit the number of results returned.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListQualificationRequests`.
    ///
    /// <p>
    /// The
    /// <code>ListQualificationRequests</code>
    /// operation retrieves requests for Qualifications of a particular
    /// Qualification type. The owner of the Qualification type calls this
    /// operation to poll for pending requests, and accepts them using the
    /// AcceptQualification operation.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListQualificationRequests<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_qualification_requests_input::Builder,
    }
    impl<C, M, R> ListQualificationRequests<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListQualificationRequests`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListQualificationRequestsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListQualificationRequestsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListQualificationRequestsInputOperationOutputAlias,
                crate::output::ListQualificationRequestsOutput,
                crate::error::ListQualificationRequestsError,
                crate::input::ListQualificationRequestsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the QualificationType.</p>
        pub fn qualification_type_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_type_id(inp);
            self
        }
        /// <p>The ID of the QualificationType.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_id(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk
        /// returns a pagination token in the response. You can use this pagination token
        /// to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk
        /// returns a pagination token in the response. You can use this pagination token
        /// to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of results to return in a single call.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> The maximum number of results to return in a single call.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListQualificationTypes`.
    ///
    /// <p>
    /// The
    /// <code>ListQualificationTypes</code>
    /// operation returns a list of Qualification types, filtered by
    /// an optional search term.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListQualificationTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_qualification_types_input::Builder,
    }
    impl<C, M, R> ListQualificationTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListQualificationTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListQualificationTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListQualificationTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListQualificationTypesInputOperationOutputAlias,
                crate::output::ListQualificationTypesOutput,
                crate::error::ListQualificationTypesError,
                crate::input::ListQualificationTypesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> A text query against all of the searchable attributes of
        /// Qualification types.
        /// </p>
        pub fn query(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query(inp);
            self
        }
        /// <p> A text query against all of the searchable attributes of
        /// Qualification types.
        /// </p>
        pub fn set_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query(input);
            self
        }
        /// <p>Specifies that only Qualification types that a user can
        /// request through the Amazon Mechanical Turk web site, such as by
        /// taking a Qualification test, are returned as results of the search.
        /// Some Qualification types, such as those assigned automatically by the
        /// system, cannot be requested directly by users. If false, all
        /// Qualification types, including those managed by the system, are
        /// considered. Valid values are True | False.
        /// </p>
        pub fn must_be_requestable(mut self, inp: bool) -> Self {
            self.inner = self.inner.must_be_requestable(inp);
            self
        }
        /// <p>Specifies that only Qualification types that a user can
        /// request through the Amazon Mechanical Turk web site, such as by
        /// taking a Qualification test, are returned as results of the search.
        /// Some Qualification types, such as those assigned automatically by the
        /// system, cannot be requested directly by users. If false, all
        /// Qualification types, including those managed by the system, are
        /// considered. Valid values are True | False.
        /// </p>
        pub fn set_must_be_requestable(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_must_be_requestable(input);
            self
        }
        /// <p> Specifies that only Qualification types that the Requester
        /// created are returned. If false, the operation returns all
        /// Qualification types.
        /// </p>
        pub fn must_be_owned_by_caller(mut self, inp: bool) -> Self {
            self.inner = self.inner.must_be_owned_by_caller(inp);
            self
        }
        /// <p> Specifies that only Qualification types that the Requester
        /// created are returned. If false, the operation returns all
        /// Qualification types.
        /// </p>
        pub fn set_must_be_owned_by_caller(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_must_be_owned_by_caller(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk
        /// returns a pagination token in the response. You can use this pagination token
        /// to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk
        /// returns a pagination token in the response. You can use this pagination token
        /// to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of results to return in a single call.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> The maximum number of results to return in a single call.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReviewableHITs`.
    ///
    /// <p>
    /// The <code>ListReviewableHITs</code> operation retrieves the HITs with Status equal to
    /// Reviewable or Status equal to Reviewing that belong to the Requester calling the operation.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListReviewableHITs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_reviewable_hi_ts_input::Builder,
    }
    impl<C, M, R> ListReviewableHITs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReviewableHITs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReviewableHiTsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReviewableHITsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReviewableHiTsInputOperationOutputAlias,
                crate::output::ListReviewableHiTsOutput,
                crate::error::ListReviewableHITsError,
                crate::input::ListReviewableHiTsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The ID of the HIT type of the HITs to consider for the query.
        /// If not specified, all HITs for the Reviewer are considered
        /// </p>
        pub fn hit_type_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_type_id(inp);
            self
        }
        /// <p>
        /// The ID of the HIT type of the HITs to consider for the query.
        /// If not specified, all HITs for the Reviewer are considered
        /// </p>
        pub fn set_hit_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_type_id(input);
            self
        }
        /// <p>
        /// Can be either <code>Reviewable</code> or <code>Reviewing</code>.
        /// Reviewable is the default value.
        /// </p>
        pub fn status(mut self, inp: crate::model::ReviewableHitStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>
        /// Can be either <code>Reviewable</code> or <code>Reviewing</code>.
        /// Reviewable is the default value.
        /// </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ReviewableHitStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>Pagination Token</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination Token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// Limit the number of results returned.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// Limit the number of results returned.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReviewPolicyResultsForHIT`.
    ///
    /// <p>
    /// The <code>ListReviewPolicyResultsForHIT</code> operation retrieves the computed results
    /// and the actions taken in the course of executing your Review Policies for a given HIT.
    /// For information about how to specify Review Policies when you call CreateHIT,
    /// see Review Policies. The ListReviewPolicyResultsForHIT operation can return results for both
    /// Assignment-level and HIT-level review results.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListReviewPolicyResultsForHIT<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_review_policy_results_for_hit_input::Builder,
    }
    impl<C, M, R> ListReviewPolicyResultsForHIT<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReviewPolicyResultsForHIT`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReviewPolicyResultsForHitOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReviewPolicyResultsForHITError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReviewPolicyResultsForHitInputOperationOutputAlias,
                crate::output::ListReviewPolicyResultsForHitOutput,
                crate::error::ListReviewPolicyResultsForHITError,
                crate::input::ListReviewPolicyResultsForHitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the HIT to retrieve review results for.</p>
        pub fn hit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_id(inp);
            self
        }
        /// <p>The unique identifier of the HIT to retrieve review results for.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_id(input);
            self
        }
        /// Appends an item to `PolicyLevels`.
        ///
        /// To override the contents of this collection use [`set_policy_levels`](Self::set_policy_levels).
        ///
        /// <p>
        /// The Policy Level(s) to retrieve review results for - HIT or Assignment.
        /// If omitted, the default behavior is to retrieve all data for both policy levels.
        /// For a list of all the described policies, see Review Policies.
        /// </p>
        pub fn policy_levels(mut self, inp: impl Into<crate::model::ReviewPolicyLevel>) -> Self {
            self.inner = self.inner.policy_levels(inp);
            self
        }
        /// <p>
        /// The Policy Level(s) to retrieve review results for - HIT or Assignment.
        /// If omitted, the default behavior is to retrieve all data for both policy levels.
        /// For a list of all the described policies, see Review Policies.
        /// </p>
        pub fn set_policy_levels(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReviewPolicyLevel>>,
        ) -> Self {
            self.inner = self.inner.set_policy_levels(input);
            self
        }
        /// <p>
        /// Specify if the operation should retrieve a list of the actions taken executing
        /// the Review Policies and their outcomes.
        /// </p>
        pub fn retrieve_actions(mut self, inp: bool) -> Self {
            self.inner = self.inner.retrieve_actions(inp);
            self
        }
        /// <p>
        /// Specify if the operation should retrieve a list of the actions taken executing
        /// the Review Policies and their outcomes.
        /// </p>
        pub fn set_retrieve_actions(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_retrieve_actions(input);
            self
        }
        /// <p>
        /// Specify if the operation should retrieve a list of the results computed by the Review Policies.
        /// </p>
        pub fn retrieve_results(mut self, inp: bool) -> Self {
            self.inner = self.inner.retrieve_results(inp);
            self
        }
        /// <p>
        /// Specify if the operation should retrieve a list of the results computed by the Review Policies.
        /// </p>
        pub fn set_retrieve_results(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_retrieve_results(input);
            self
        }
        /// <p>Pagination token</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Limit the number of results returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Limit the number of results returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkerBlocks`.
    ///
    /// <p>The <code>ListWorkersBlocks</code> operation retrieves a list of Workers who are blocked from working on your HITs.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListWorkerBlocks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_worker_blocks_input::Builder,
    }
    impl<C, M, R> ListWorkerBlocks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorkerBlocks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkerBlocksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkerBlocksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorkerBlocksInputOperationOutputAlias,
                crate::output::ListWorkerBlocksOutput,
                crate::error::ListWorkerBlocksError,
                crate::input::ListWorkerBlocksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Pagination token</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkersWithQualificationType`.
    ///
    /// <p>
    /// The <code>ListWorkersWithQualificationType</code> operation returns all of the Workers
    /// that have been associated with a given Qualification type.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListWorkersWithQualificationType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_workers_with_qualification_type_input::Builder,
    }
    impl<C, M, R> ListWorkersWithQualificationType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorkersWithQualificationType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkersWithQualificationTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkersWithQualificationTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorkersWithQualificationTypeInputOperationOutputAlias,
                crate::output::ListWorkersWithQualificationTypeOutput,
                crate::error::ListWorkersWithQualificationTypeError,
                crate::input::ListWorkersWithQualificationTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Qualification type of the Qualifications to
        /// return.</p>
        pub fn qualification_type_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_type_id(inp);
            self
        }
        /// <p>The ID of the Qualification type of the Qualifications to
        /// return.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_id(input);
            self
        }
        /// <p>
        /// The status of the Qualifications to return.
        /// Can be <code>Granted | Revoked</code>.
        /// </p>
        pub fn status(mut self, inp: crate::model::QualificationStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>
        /// The status of the Qualifications to return.
        /// Can be <code>Granted | Revoked</code>.
        /// </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::QualificationStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>Pagination Token</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination Token</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// Limit the number of results returned.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// Limit the number of results returned.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `NotifyWorkers`.
    ///
    /// <p>
    /// The
    /// <code>NotifyWorkers</code>
    /// operation sends an email to one or more Workers that you specify with
    /// the Worker ID. You can specify up to 100 Worker IDs to send the same
    /// message with a single call to the NotifyWorkers operation. The
    /// NotifyWorkers operation will send a notification email to a Worker
    /// only if you have previously approved or rejected work from the
    /// Worker.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct NotifyWorkers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::notify_workers_input::Builder,
    }
    impl<C, M, R> NotifyWorkers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `NotifyWorkers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::NotifyWorkersOutput,
            aws_smithy_http::result::SdkError<crate::error::NotifyWorkersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::NotifyWorkersInputOperationOutputAlias,
                crate::output::NotifyWorkersOutput,
                crate::error::NotifyWorkersError,
                crate::input::NotifyWorkersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The subject line of the email message to send. Can include up
        /// to 200 characters.</p>
        pub fn subject(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subject(inp);
            self
        }
        /// <p>The subject line of the email message to send. Can include up
        /// to 200 characters.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subject(input);
            self
        }
        /// <p>The text of the email message to send. Can include up to
        /// 4,096 characters</p>
        pub fn message_text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_text(inp);
            self
        }
        /// <p>The text of the email message to send. Can include up to
        /// 4,096 characters</p>
        pub fn set_message_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_text(input);
            self
        }
        /// Appends an item to `WorkerIds`.
        ///
        /// To override the contents of this collection use [`set_worker_ids`](Self::set_worker_ids).
        ///
        /// <p>A list of Worker IDs you wish to notify. You
        /// can notify upto
        /// 100 Workers at a time.</p>
        pub fn worker_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worker_ids(inp);
            self
        }
        /// <p>A list of Worker IDs you wish to notify. You
        /// can notify upto
        /// 100 Workers at a time.</p>
        pub fn set_worker_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_worker_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectAssignment`.
    ///
    /// <p>
    /// The <code>RejectAssignment</code> operation rejects the results of a completed assignment.
    /// </p>
    /// <p>
    /// You can include an optional feedback message with the rejection,
    /// which the Worker can see in the Status section of the web site.
    /// When you include a feedback message with the rejection,
    /// it helps the Worker understand why the assignment was rejected,
    /// and can improve the quality of the results the Worker submits in the future.
    /// </p>
    /// <p>
    /// Only the Requester who created the HIT can reject an assignment for the HIT.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct RejectAssignment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reject_assignment_input::Builder,
    }
    impl<C, M, R> RejectAssignment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RejectAssignment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectAssignmentOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectAssignmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RejectAssignmentInputOperationOutputAlias,
                crate::output::RejectAssignmentOutput,
                crate::error::RejectAssignmentError,
                crate::input::RejectAssignmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The ID of the assignment. The assignment must correspond to a HIT created by the Requester.
        /// </p>
        pub fn assignment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_id(inp);
            self
        }
        /// <p>
        /// The ID of the assignment. The assignment must correspond to a HIT created by the Requester.
        /// </p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_id(input);
            self
        }
        /// <p>
        /// A message for the Worker, which the Worker can see in the Status section of the web site.
        /// </p>
        pub fn requester_feedback(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.requester_feedback(inp);
            self
        }
        /// <p>
        /// A message for the Worker, which the Worker can see in the Status section of the web site.
        /// </p>
        pub fn set_requester_feedback(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_requester_feedback(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectQualificationRequest`.
    ///
    /// <p>
    /// The
    /// <code>RejectQualificationRequest</code>
    /// operation rejects a user's request for a Qualification.
    /// </p>
    /// <p> You can provide a text message explaining why the request was
    /// rejected. The Worker who made the request can see this message.</p>
    #[derive(std::fmt::Debug)]
    pub struct RejectQualificationRequest<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reject_qualification_request_input::Builder,
    }
    impl<C, M, R> RejectQualificationRequest<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RejectQualificationRequest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectQualificationRequestOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectQualificationRequestError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RejectQualificationRequestInputOperationOutputAlias,
                crate::output::RejectQualificationRequestOutput,
                crate::error::RejectQualificationRequestError,
                crate::input::RejectQualificationRequestInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The ID of the Qualification request, as returned by the
        /// <code>ListQualificationRequests</code>
        /// operation.
        /// </p>
        pub fn qualification_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_request_id(inp);
            self
        }
        /// <p>
        /// The ID of the Qualification request, as returned by the
        /// <code>ListQualificationRequests</code>
        /// operation.
        /// </p>
        pub fn set_qualification_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_request_id(input);
            self
        }
        /// <p>A text message explaining why the request was rejected, to be
        /// shown to the Worker who made the request.</p>
        pub fn reason(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(inp);
            self
        }
        /// <p>A text message explaining why the request was rejected, to be
        /// shown to the Worker who made the request.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendBonus`.
    ///
    /// <p>
    /// The
    /// <code>SendBonus</code>
    /// operation issues a payment of money from your account to a Worker.
    /// This payment happens separately from the reward you pay to the Worker
    /// when you approve the Worker's assignment. The SendBonus operation
    /// requires the Worker's ID and the assignment ID as parameters to
    /// initiate payment of the bonus. You must include a message that
    /// explains the reason for the bonus payment, as the Worker may not be
    /// expecting the payment. Amazon Mechanical Turk collects a fee for
    /// bonus payments, similar to the HIT listing fee. This operation fails
    /// if your account does not have enough funds to pay for both the bonus
    /// and the fees.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct SendBonus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_bonus_input::Builder,
    }
    impl<C, M, R> SendBonus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendBonus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendBonusOutput,
            aws_smithy_http::result::SdkError<crate::error::SendBonusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendBonusInputOperationOutputAlias,
                crate::output::SendBonusOutput,
                crate::error::SendBonusError,
                crate::input::SendBonusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Worker being paid the bonus.</p>
        pub fn worker_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worker_id(inp);
            self
        }
        /// <p>The ID of the Worker being paid the bonus.</p>
        pub fn set_worker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_worker_id(input);
            self
        }
        /// <p>
        /// The Bonus amount is a US Dollar amount specified using a string (for example, "5" represents $5.00 USD and
        /// "101.42" represents $101.42 USD). Do not include currency symbols or currency codes.
        /// </p>
        pub fn bonus_amount(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bonus_amount(inp);
            self
        }
        /// <p>
        /// The Bonus amount is a US Dollar amount specified using a string (for example, "5" represents $5.00 USD and
        /// "101.42" represents $101.42 USD). Do not include currency symbols or currency codes.
        /// </p>
        pub fn set_bonus_amount(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bonus_amount(input);
            self
        }
        /// <p>The ID of the assignment for which this bonus is paid.</p>
        pub fn assignment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_id(inp);
            self
        }
        /// <p>The ID of the assignment for which this bonus is paid.</p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_id(input);
            self
        }
        /// <p>A message that explains the reason for the bonus payment. The
        /// Worker receiving the bonus can see this message.</p>
        pub fn reason(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(inp);
            self
        }
        /// <p>A message that explains the reason for the bonus payment. The
        /// Worker receiving the bonus can see this message.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
        /// <p>A unique identifier for this request, which allows you to
        /// retry the call on error without granting multiple bonuses. This is
        /// useful in cases such as network timeouts where it is unclear whether
        /// or not the call succeeded on the server. If the bonus already exists
        /// in the system from a previous call using the same UniqueRequestToken,
        /// subsequent calls will return an error with a message containing the
        /// request ID.</p>
        pub fn unique_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.unique_request_token(inp);
            self
        }
        /// <p>A unique identifier for this request, which allows you to
        /// retry the call on error without granting multiple bonuses. This is
        /// useful in cases such as network timeouts where it is unclear whether
        /// or not the call succeeded on the server. If the bonus already exists
        /// in the system from a previous call using the same UniqueRequestToken,
        /// subsequent calls will return an error with a message containing the
        /// request ID.</p>
        pub fn set_unique_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_unique_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendTestEventNotification`.
    ///
    /// <p>
    /// The <code>SendTestEventNotification</code> operation causes Amazon Mechanical Turk to send
    /// a notification message as if a HIT event occurred, according to the provided
    /// notification specification. This allows you to test notifications without
    /// setting up notifications for a real HIT type and trying to trigger them using the website.
    /// When you call this operation, the service attempts to send the test notification immediately.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct SendTestEventNotification<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_test_event_notification_input::Builder,
    }
    impl<C, M, R> SendTestEventNotification<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendTestEventNotification`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendTestEventNotificationOutput,
            aws_smithy_http::result::SdkError<crate::error::SendTestEventNotificationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendTestEventNotificationInputOperationOutputAlias,
                crate::output::SendTestEventNotificationOutput,
                crate::error::SendTestEventNotificationError,
                crate::input::SendTestEventNotificationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The notification specification to test. This value is identical to the value
        /// you would provide to the UpdateNotificationSettings operation when you establish
        /// the notification specification for a HIT type.
        /// </p>
        pub fn notification(mut self, inp: crate::model::NotificationSpecification) -> Self {
            self.inner = self.inner.notification(inp);
            self
        }
        /// <p>
        /// The notification specification to test. This value is identical to the value
        /// you would provide to the UpdateNotificationSettings operation when you establish
        /// the notification specification for a HIT type.
        /// </p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::NotificationSpecification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
        /// <p>
        /// The event to simulate to test the notification specification.
        /// This event is included in the test message even if the notification specification
        /// does not include the event type.
        /// The notification specification does not filter out the test event.
        /// </p>
        pub fn test_event_type(mut self, inp: crate::model::EventType) -> Self {
            self.inner = self.inner.test_event_type(inp);
            self
        }
        /// <p>
        /// The event to simulate to test the notification specification.
        /// This event is included in the test message even if the notification specification
        /// does not include the event type.
        /// The notification specification does not filter out the test event.
        /// </p>
        pub fn set_test_event_type(
            mut self,
            input: std::option::Option<crate::model::EventType>,
        ) -> Self {
            self.inner = self.inner.set_test_event_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateExpirationForHIT`.
    ///
    /// <p>
    /// The <code>UpdateExpirationForHIT</code> operation allows you update the expiration time of a HIT.
    /// If you update it to a time in the past, the HIT will be immediately expired.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateExpirationForHIT<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_expiration_for_hit_input::Builder,
    }
    impl<C, M, R> UpdateExpirationForHIT<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateExpirationForHIT`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateExpirationForHitOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateExpirationForHITError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateExpirationForHitInputOperationOutputAlias,
                crate::output::UpdateExpirationForHitOutput,
                crate::error::UpdateExpirationForHITError,
                crate::input::UpdateExpirationForHitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The HIT to update.
        /// </p>
        pub fn hit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_id(inp);
            self
        }
        /// <p>
        /// The HIT to update.
        /// </p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_id(input);
            self
        }
        /// <p>
        /// The date and time at which you want the HIT to expire
        /// </p>
        pub fn expire_at(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.expire_at(inp);
            self
        }
        /// <p>
        /// The date and time at which you want the HIT to expire
        /// </p>
        pub fn set_expire_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_expire_at(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateHITReviewStatus`.
    ///
    /// <p>
    /// The <code>UpdateHITReviewStatus</code> operation updates the status of a HIT.
    /// If the status is Reviewable, this operation can update the status to Reviewing,
    /// or it can revert a Reviewing HIT back to the Reviewable status.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateHITReviewStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_hit_review_status_input::Builder,
    }
    impl<C, M, R> UpdateHITReviewStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateHITReviewStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateHitReviewStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateHITReviewStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateHitReviewStatusInputOperationOutputAlias,
                crate::output::UpdateHitReviewStatusOutput,
                crate::error::UpdateHITReviewStatusError,
                crate::input::UpdateHitReviewStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The ID of the HIT to update.
        /// </p>
        pub fn hit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_id(inp);
            self
        }
        /// <p>
        /// The ID of the HIT to update.
        /// </p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_id(input);
            self
        }
        /// <p>
        /// Specifies how to update the HIT status. Default is <code>False</code>.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// Setting this to false will only transition a HIT from <code>Reviewable</code> to <code>Reviewing</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// Setting this to true will only transition a HIT from <code>Reviewing</code> to <code>Reviewable</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn revert(mut self, inp: bool) -> Self {
            self.inner = self.inner.revert(inp);
            self
        }
        /// <p>
        /// Specifies how to update the HIT status. Default is <code>False</code>.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// Setting this to false will only transition a HIT from <code>Reviewable</code> to <code>Reviewing</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// Setting this to true will only transition a HIT from <code>Reviewing</code> to <code>Reviewable</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_revert(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_revert(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateHITTypeOfHIT`.
    ///
    /// <p>
    /// The
    /// <code>UpdateHITTypeOfHIT</code>
    /// operation allows you to change the HITType properties of a HIT. This
    /// operation disassociates the HIT from its old HITType properties and
    /// associates it with the new HITType properties. The HIT takes on the
    /// properties of the new HITType in place of the old ones.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateHITTypeOfHIT<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_hit_type_of_hit_input::Builder,
    }
    impl<C, M, R> UpdateHITTypeOfHIT<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateHITTypeOfHIT`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateHitTypeOfHitOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateHITTypeOfHITError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateHitTypeOfHitInputOperationOutputAlias,
                crate::output::UpdateHitTypeOfHitOutput,
                crate::error::UpdateHITTypeOfHITError,
                crate::input::UpdateHitTypeOfHitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The HIT to update.</p>
        pub fn hit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_id(inp);
            self
        }
        /// <p>The HIT to update.</p>
        pub fn set_hit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_id(input);
            self
        }
        /// <p>The ID of the new HIT type.</p>
        pub fn hit_type_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_type_id(inp);
            self
        }
        /// <p>The ID of the new HIT type.</p>
        pub fn set_hit_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_type_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNotificationSettings`.
    ///
    /// <p>
    /// The <code>UpdateNotificationSettings</code> operation creates, updates,
    /// disables or re-enables notifications for a HIT type.
    /// If you call the UpdateNotificationSettings operation for a HIT type that already has a
    /// notification specification, the operation replaces the old specification with a new one.
    /// You can call the UpdateNotificationSettings operation to enable or disable notifications
    /// for the HIT type, without having to modify the notification specification itself by providing
    /// updates to the Active status without specifying a new notification specification.
    /// To change the Active status of a HIT type's notifications,
    /// the HIT type must already have a notification specification,
    /// or one must be provided in the same call to <code>UpdateNotificationSettings</code>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateNotificationSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_notification_settings_input::Builder,
    }
    impl<C, M, R> UpdateNotificationSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateNotificationSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNotificationSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNotificationSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateNotificationSettingsInputOperationOutputAlias,
                crate::output::UpdateNotificationSettingsOutput,
                crate::error::UpdateNotificationSettingsError,
                crate::input::UpdateNotificationSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The ID of the HIT type whose notification specification is being updated.
        /// </p>
        pub fn hit_type_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hit_type_id(inp);
            self
        }
        /// <p>
        /// The ID of the HIT type whose notification specification is being updated.
        /// </p>
        pub fn set_hit_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hit_type_id(input);
            self
        }
        /// <p>
        /// The notification specification for the HIT type.
        /// </p>
        pub fn notification(mut self, inp: crate::model::NotificationSpecification) -> Self {
            self.inner = self.inner.notification(inp);
            self
        }
        /// <p>
        /// The notification specification for the HIT type.
        /// </p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::NotificationSpecification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
        /// <p>
        /// Specifies whether notifications are sent for HITs of this HIT type,
        /// according to the notification specification.
        /// You must specify either the Notification parameter or the Active parameter
        /// for the call to UpdateNotificationSettings to succeed.
        /// </p>
        pub fn active(mut self, inp: bool) -> Self {
            self.inner = self.inner.active(inp);
            self
        }
        /// <p>
        /// Specifies whether notifications are sent for HITs of this HIT type,
        /// according to the notification specification.
        /// You must specify either the Notification parameter or the Active parameter
        /// for the call to UpdateNotificationSettings to succeed.
        /// </p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_active(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateQualificationType`.
    ///
    /// <p>
    /// The
    /// <code>UpdateQualificationType</code>
    /// operation modifies the attributes of an existing Qualification type,
    /// which is represented by a QualificationType data structure. Only the
    /// owner of a Qualification type can modify its attributes.
    /// </p>
    /// <p> Most attributes of a Qualification type can be changed after
    /// the type has been created. However, the Name and Keywords fields
    /// cannot be modified. The RetryDelayInSeconds parameter can be modified
    /// or added to change the delay or to enable retries, but
    /// RetryDelayInSeconds cannot be used to disable retries. </p>
    /// <p> You can use this operation to update the test for a
    /// Qualification type. The test is updated based on the values specified
    /// for the Test, TestDurationInSeconds and AnswerKey parameters. All
    /// three parameters specify the updated test. If you are updating the
    /// test for a type, you must specify the Test and TestDurationInSeconds
    /// parameters. The AnswerKey parameter is optional; omitting it specifies
    /// that the updated test does not have an answer key. </p>
    /// <p> If you omit the Test parameter, the test for the
    /// Qualification type is unchanged. There is no way to remove a test from
    /// a Qualification type that has one. If the type already has a test, you
    /// cannot update it to be AutoGranted. If the Qualification type does not
    /// have a test and one is provided by an update, the type will henceforth
    /// have a test. </p>
    /// <p> If you want to update the test duration or answer key for an
    /// existing test without changing the questions, you must specify a Test
    /// parameter with the original questions, along with the updated values. </p>
    /// <p> If you provide an updated Test but no AnswerKey, the new test
    /// will not have an answer key. Requests for such Qualifications must be
    /// granted manually. </p>
    /// <p> You can also update the AutoGranted and AutoGrantedValue
    /// attributes of the Qualification type.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateQualificationType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_qualification_type_input::Builder,
    }
    impl<C, M, R> UpdateQualificationType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateQualificationType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateQualificationTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateQualificationTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateQualificationTypeInputOperationOutputAlias,
                crate::output::UpdateQualificationTypeOutput,
                crate::error::UpdateQualificationTypeError,
                crate::input::UpdateQualificationTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Qualification type to update.</p>
        pub fn qualification_type_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualification_type_id(inp);
            self
        }
        /// <p>The ID of the Qualification type to update.</p>
        pub fn set_qualification_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_id(input);
            self
        }
        /// <p>The new description of the Qualification type.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The new description of the Qualification type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The new status of the Qualification type - Active | Inactive</p>
        pub fn qualification_type_status(
            mut self,
            inp: crate::model::QualificationTypeStatus,
        ) -> Self {
            self.inner = self.inner.qualification_type_status(inp);
            self
        }
        /// <p>The new status of the Qualification type - Active | Inactive</p>
        pub fn set_qualification_type_status(
            mut self,
            input: std::option::Option<crate::model::QualificationTypeStatus>,
        ) -> Self {
            self.inner = self.inner.set_qualification_type_status(input);
            self
        }
        /// <p>The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified.</p>
        /// <p>Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be specified if AutoGranted is true.</p>
        /// <p>Constraints: None. If not specified, the Worker may request the Qualification without answering any questions.</p>
        pub fn test(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.test(inp);
            self
        }
        /// <p>The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified.</p>
        /// <p>Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be specified if AutoGranted is true.</p>
        /// <p>Constraints: None. If not specified, the Worker may request the Qualification without answering any questions.</p>
        pub fn set_test(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_test(input);
            self
        }
        /// <p>The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data structure.</p>
        pub fn answer_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.answer_key(inp);
            self
        }
        /// <p>The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data structure.</p>
        pub fn set_answer_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_answer_key(input);
            self
        }
        /// <p>The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker requests the Qualification.</p>
        pub fn test_duration_in_seconds(mut self, inp: i64) -> Self {
            self.inner = self.inner.test_duration_in_seconds(inp);
            self
        }
        /// <p>The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker requests the Qualification.</p>
        pub fn set_test_duration_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_test_duration_in_seconds(input);
            self
        }
        /// <p>The amount of time, in seconds, that Workers must wait
        /// after requesting a Qualification of the specified Qualification type
        /// before they can retry the Qualification request. It is not possible to
        /// disable retries for a Qualification type after it has been created with
        /// retries enabled. If you want to disable retries, you must dispose of
        /// the existing retry-enabled Qualification type using
        /// DisposeQualificationType and then create a new Qualification type with
        /// retries disabled using CreateQualificationType.</p>
        pub fn retry_delay_in_seconds(mut self, inp: i64) -> Self {
            self.inner = self.inner.retry_delay_in_seconds(inp);
            self
        }
        /// <p>The amount of time, in seconds, that Workers must wait
        /// after requesting a Qualification of the specified Qualification type
        /// before they can retry the Qualification request. It is not possible to
        /// disable retries for a Qualification type after it has been created with
        /// retries enabled. If you want to disable retries, you must dispose of
        /// the existing retry-enabled Qualification type using
        /// DisposeQualificationType and then create a new Qualification type with
        /// retries disabled using CreateQualificationType.</p>
        pub fn set_retry_delay_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_retry_delay_in_seconds(input);
            self
        }
        /// <p>Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test.</p>
        /// <p>Constraints: If the Test parameter is specified, this parameter cannot be true.</p>
        pub fn auto_granted(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_granted(inp);
            self
        }
        /// <p>Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test.</p>
        /// <p>Constraints: If the Test parameter is specified, this parameter cannot be true.</p>
        pub fn set_auto_granted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_granted(input);
            self
        }
        /// <p>The Qualification value to use for automatically granted Qualifications. This parameter is used only if the AutoGranted parameter is true.</p>
        pub fn auto_granted_value(mut self, inp: i32) -> Self {
            self.inner = self.inner.auto_granted_value(inp);
            self
        }
        /// <p>The Qualification value to use for automatically granted Qualifications. This parameter is used only if the AutoGranted parameter is true.</p>
        pub fn set_auto_granted_value(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_auto_granted_value(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
