// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptQualificationRequest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptQualificationRequestError {
    /// Kind of error that occurred.
    pub kind: AcceptQualificationRequestErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptQualificationRequest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptQualificationRequestErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptQualificationRequestError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptQualificationRequestErrorKind::RequestError(_inner) => _inner.fmt(f),
            AcceptQualificationRequestErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            AcceptQualificationRequestErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcceptQualificationRequestError {
    fn code(&self) -> Option<&str> {
        AcceptQualificationRequestError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcceptQualificationRequestError {
    /// Creates a new `AcceptQualificationRequestError`.
    pub fn new(kind: AcceptQualificationRequestErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptQualificationRequestError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptQualificationRequestErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptQualificationRequestError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptQualificationRequestErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AcceptQualificationRequestErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(
            &self.kind,
            AcceptQualificationRequestErrorKind::RequestError(_)
        )
    }
    /// Returns true if the error kind is `AcceptQualificationRequestErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            AcceptQualificationRequestErrorKind::ServiceFault(_)
        )
    }
}
impl std::error::Error for AcceptQualificationRequestError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptQualificationRequestErrorKind::RequestError(_inner) => Some(_inner),
            AcceptQualificationRequestErrorKind::ServiceFault(_inner) => Some(_inner),
            AcceptQualificationRequestErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ApproveAssignment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ApproveAssignmentError {
    /// Kind of error that occurred.
    pub kind: ApproveAssignmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ApproveAssignment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ApproveAssignmentErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ApproveAssignmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ApproveAssignmentErrorKind::RequestError(_inner) => _inner.fmt(f),
            ApproveAssignmentErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            ApproveAssignmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ApproveAssignmentError {
    fn code(&self) -> Option<&str> {
        ApproveAssignmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ApproveAssignmentError {
    /// Creates a new `ApproveAssignmentError`.
    pub fn new(kind: ApproveAssignmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ApproveAssignmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ApproveAssignmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ApproveAssignmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ApproveAssignmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ApproveAssignmentErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, ApproveAssignmentErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `ApproveAssignmentErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, ApproveAssignmentErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for ApproveAssignmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ApproveAssignmentErrorKind::RequestError(_inner) => Some(_inner),
            ApproveAssignmentErrorKind::ServiceFault(_inner) => Some(_inner),
            ApproveAssignmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateQualificationWithWorker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateQualificationWithWorkerError {
    /// Kind of error that occurred.
    pub kind: AssociateQualificationWithWorkerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateQualificationWithWorker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateQualificationWithWorkerErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateQualificationWithWorkerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateQualificationWithWorkerErrorKind::RequestError(_inner) => _inner.fmt(f),
            AssociateQualificationWithWorkerErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            AssociateQualificationWithWorkerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateQualificationWithWorkerError {
    fn code(&self) -> Option<&str> {
        AssociateQualificationWithWorkerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateQualificationWithWorkerError {
    /// Creates a new `AssociateQualificationWithWorkerError`.
    pub fn new(
        kind: AssociateQualificationWithWorkerErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateQualificationWithWorkerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateQualificationWithWorkerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateQualificationWithWorkerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateQualificationWithWorkerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateQualificationWithWorkerErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(
            &self.kind,
            AssociateQualificationWithWorkerErrorKind::RequestError(_)
        )
    }
    /// Returns true if the error kind is `AssociateQualificationWithWorkerErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            AssociateQualificationWithWorkerErrorKind::ServiceFault(_)
        )
    }
}
impl std::error::Error for AssociateQualificationWithWorkerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateQualificationWithWorkerErrorKind::RequestError(_inner) => Some(_inner),
            AssociateQualificationWithWorkerErrorKind::ServiceFault(_inner) => Some(_inner),
            AssociateQualificationWithWorkerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAdditionalAssignmentsForHIT` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAdditionalAssignmentsForHITError {
    /// Kind of error that occurred.
    pub kind: CreateAdditionalAssignmentsForHITErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAdditionalAssignmentsForHIT` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAdditionalAssignmentsForHITErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAdditionalAssignmentsForHITError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAdditionalAssignmentsForHITErrorKind::RequestError(_inner) => _inner.fmt(f),
            CreateAdditionalAssignmentsForHITErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            CreateAdditionalAssignmentsForHITErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAdditionalAssignmentsForHITError {
    fn code(&self) -> Option<&str> {
        CreateAdditionalAssignmentsForHITError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAdditionalAssignmentsForHITError {
    /// Creates a new `CreateAdditionalAssignmentsForHITError`.
    pub fn new(
        kind: CreateAdditionalAssignmentsForHITErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAdditionalAssignmentsForHITError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAdditionalAssignmentsForHITErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAdditionalAssignmentsForHITError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAdditionalAssignmentsForHITErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateAdditionalAssignmentsForHITErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateAdditionalAssignmentsForHITErrorKind::RequestError(_)
        )
    }
    /// Returns true if the error kind is `CreateAdditionalAssignmentsForHITErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateAdditionalAssignmentsForHITErrorKind::ServiceFault(_)
        )
    }
}
impl std::error::Error for CreateAdditionalAssignmentsForHITError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAdditionalAssignmentsForHITErrorKind::RequestError(_inner) => Some(_inner),
            CreateAdditionalAssignmentsForHITErrorKind::ServiceFault(_inner) => Some(_inner),
            CreateAdditionalAssignmentsForHITErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateHIT` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateHITError {
    /// Kind of error that occurred.
    pub kind: CreateHITErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateHIT` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateHITErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateHITError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateHITErrorKind::RequestError(_inner) => _inner.fmt(f),
            CreateHITErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            CreateHITErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateHITError {
    fn code(&self) -> Option<&str> {
        CreateHITError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateHITError {
    /// Creates a new `CreateHITError`.
    pub fn new(kind: CreateHITErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateHITError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateHITErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateHITError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateHITErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateHITErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, CreateHITErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `CreateHITErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, CreateHITErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for CreateHITError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateHITErrorKind::RequestError(_inner) => Some(_inner),
            CreateHITErrorKind::ServiceFault(_inner) => Some(_inner),
            CreateHITErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateHITType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateHITTypeError {
    /// Kind of error that occurred.
    pub kind: CreateHITTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateHITType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateHITTypeErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateHITTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateHITTypeErrorKind::RequestError(_inner) => _inner.fmt(f),
            CreateHITTypeErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            CreateHITTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateHITTypeError {
    fn code(&self) -> Option<&str> {
        CreateHITTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateHITTypeError {
    /// Creates a new `CreateHITTypeError`.
    pub fn new(kind: CreateHITTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateHITTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateHITTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateHITTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateHITTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateHITTypeErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, CreateHITTypeErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `CreateHITTypeErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, CreateHITTypeErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for CreateHITTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateHITTypeErrorKind::RequestError(_inner) => Some(_inner),
            CreateHITTypeErrorKind::ServiceFault(_inner) => Some(_inner),
            CreateHITTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateHITWithHITType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateHITWithHITTypeError {
    /// Kind of error that occurred.
    pub kind: CreateHITWithHITTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateHITWithHITType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateHITWithHITTypeErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateHITWithHITTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateHITWithHITTypeErrorKind::RequestError(_inner) => _inner.fmt(f),
            CreateHITWithHITTypeErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            CreateHITWithHITTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateHITWithHITTypeError {
    fn code(&self) -> Option<&str> {
        CreateHITWithHITTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateHITWithHITTypeError {
    /// Creates a new `CreateHITWithHITTypeError`.
    pub fn new(kind: CreateHITWithHITTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateHITWithHITTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateHITWithHITTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateHITWithHITTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateHITWithHITTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateHITWithHITTypeErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, CreateHITWithHITTypeErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `CreateHITWithHITTypeErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, CreateHITWithHITTypeErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for CreateHITWithHITTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateHITWithHITTypeErrorKind::RequestError(_inner) => Some(_inner),
            CreateHITWithHITTypeErrorKind::ServiceFault(_inner) => Some(_inner),
            CreateHITWithHITTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateQualificationType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateQualificationTypeError {
    /// Kind of error that occurred.
    pub kind: CreateQualificationTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateQualificationType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateQualificationTypeErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateQualificationTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateQualificationTypeErrorKind::RequestError(_inner) => _inner.fmt(f),
            CreateQualificationTypeErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            CreateQualificationTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateQualificationTypeError {
    fn code(&self) -> Option<&str> {
        CreateQualificationTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateQualificationTypeError {
    /// Creates a new `CreateQualificationTypeError`.
    pub fn new(kind: CreateQualificationTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateQualificationTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateQualificationTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateQualificationTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateQualificationTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateQualificationTypeErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateQualificationTypeErrorKind::RequestError(_)
        )
    }
    /// Returns true if the error kind is `CreateQualificationTypeErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateQualificationTypeErrorKind::ServiceFault(_)
        )
    }
}
impl std::error::Error for CreateQualificationTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateQualificationTypeErrorKind::RequestError(_inner) => Some(_inner),
            CreateQualificationTypeErrorKind::ServiceFault(_inner) => Some(_inner),
            CreateQualificationTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWorkerBlock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWorkerBlockError {
    /// Kind of error that occurred.
    pub kind: CreateWorkerBlockErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWorkerBlock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWorkerBlockErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWorkerBlockError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWorkerBlockErrorKind::RequestError(_inner) => _inner.fmt(f),
            CreateWorkerBlockErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            CreateWorkerBlockErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWorkerBlockError {
    fn code(&self) -> Option<&str> {
        CreateWorkerBlockError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateWorkerBlockError {
    /// Creates a new `CreateWorkerBlockError`.
    pub fn new(kind: CreateWorkerBlockErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWorkerBlockError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWorkerBlockErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWorkerBlockError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWorkerBlockErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateWorkerBlockErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, CreateWorkerBlockErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `CreateWorkerBlockErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, CreateWorkerBlockErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for CreateWorkerBlockError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWorkerBlockErrorKind::RequestError(_inner) => Some(_inner),
            CreateWorkerBlockErrorKind::ServiceFault(_inner) => Some(_inner),
            CreateWorkerBlockErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteHIT` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteHITError {
    /// Kind of error that occurred.
    pub kind: DeleteHITErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteHIT` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteHITErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteHITError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteHITErrorKind::RequestError(_inner) => _inner.fmt(f),
            DeleteHITErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            DeleteHITErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteHITError {
    fn code(&self) -> Option<&str> {
        DeleteHITError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteHITError {
    /// Creates a new `DeleteHITError`.
    pub fn new(kind: DeleteHITErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteHITError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteHITErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteHITError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteHITErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteHITErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, DeleteHITErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `DeleteHITErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, DeleteHITErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for DeleteHITError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteHITErrorKind::RequestError(_inner) => Some(_inner),
            DeleteHITErrorKind::ServiceFault(_inner) => Some(_inner),
            DeleteHITErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteQualificationType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteQualificationTypeError {
    /// Kind of error that occurred.
    pub kind: DeleteQualificationTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteQualificationType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteQualificationTypeErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteQualificationTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteQualificationTypeErrorKind::RequestError(_inner) => _inner.fmt(f),
            DeleteQualificationTypeErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            DeleteQualificationTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteQualificationTypeError {
    fn code(&self) -> Option<&str> {
        DeleteQualificationTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteQualificationTypeError {
    /// Creates a new `DeleteQualificationTypeError`.
    pub fn new(kind: DeleteQualificationTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteQualificationTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteQualificationTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteQualificationTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteQualificationTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteQualificationTypeErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQualificationTypeErrorKind::RequestError(_)
        )
    }
    /// Returns true if the error kind is `DeleteQualificationTypeErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQualificationTypeErrorKind::ServiceFault(_)
        )
    }
}
impl std::error::Error for DeleteQualificationTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteQualificationTypeErrorKind::RequestError(_inner) => Some(_inner),
            DeleteQualificationTypeErrorKind::ServiceFault(_inner) => Some(_inner),
            DeleteQualificationTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWorkerBlock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWorkerBlockError {
    /// Kind of error that occurred.
    pub kind: DeleteWorkerBlockErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWorkerBlock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWorkerBlockErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWorkerBlockError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWorkerBlockErrorKind::RequestError(_inner) => _inner.fmt(f),
            DeleteWorkerBlockErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            DeleteWorkerBlockErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWorkerBlockError {
    fn code(&self) -> Option<&str> {
        DeleteWorkerBlockError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteWorkerBlockError {
    /// Creates a new `DeleteWorkerBlockError`.
    pub fn new(kind: DeleteWorkerBlockErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWorkerBlockError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWorkerBlockErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWorkerBlockError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWorkerBlockErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteWorkerBlockErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, DeleteWorkerBlockErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `DeleteWorkerBlockErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, DeleteWorkerBlockErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for DeleteWorkerBlockError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWorkerBlockErrorKind::RequestError(_inner) => Some(_inner),
            DeleteWorkerBlockErrorKind::ServiceFault(_inner) => Some(_inner),
            DeleteWorkerBlockErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateQualificationFromWorker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateQualificationFromWorkerError {
    /// Kind of error that occurred.
    pub kind: DisassociateQualificationFromWorkerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateQualificationFromWorker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateQualificationFromWorkerErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateQualificationFromWorkerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateQualificationFromWorkerErrorKind::RequestError(_inner) => _inner.fmt(f),
            DisassociateQualificationFromWorkerErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            DisassociateQualificationFromWorkerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateQualificationFromWorkerError {
    fn code(&self) -> Option<&str> {
        DisassociateQualificationFromWorkerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateQualificationFromWorkerError {
    /// Creates a new `DisassociateQualificationFromWorkerError`.
    pub fn new(
        kind: DisassociateQualificationFromWorkerErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateQualificationFromWorkerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateQualificationFromWorkerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateQualificationFromWorkerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateQualificationFromWorkerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociateQualificationFromWorkerErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateQualificationFromWorkerErrorKind::RequestError(_)
        )
    }
    /// Returns true if the error kind is `DisassociateQualificationFromWorkerErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateQualificationFromWorkerErrorKind::ServiceFault(_)
        )
    }
}
impl std::error::Error for DisassociateQualificationFromWorkerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateQualificationFromWorkerErrorKind::RequestError(_inner) => Some(_inner),
            DisassociateQualificationFromWorkerErrorKind::ServiceFault(_inner) => Some(_inner),
            DisassociateQualificationFromWorkerErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetAccountBalance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccountBalanceError {
    /// Kind of error that occurred.
    pub kind: GetAccountBalanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccountBalance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccountBalanceErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccountBalanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccountBalanceErrorKind::RequestError(_inner) => _inner.fmt(f),
            GetAccountBalanceErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            GetAccountBalanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccountBalanceError {
    fn code(&self) -> Option<&str> {
        GetAccountBalanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAccountBalanceError {
    /// Creates a new `GetAccountBalanceError`.
    pub fn new(kind: GetAccountBalanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccountBalanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccountBalanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccountBalanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccountBalanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAccountBalanceErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, GetAccountBalanceErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `GetAccountBalanceErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, GetAccountBalanceErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for GetAccountBalanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccountBalanceErrorKind::RequestError(_inner) => Some(_inner),
            GetAccountBalanceErrorKind::ServiceFault(_inner) => Some(_inner),
            GetAccountBalanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAssignment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAssignmentError {
    /// Kind of error that occurred.
    pub kind: GetAssignmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAssignment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAssignmentErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAssignmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAssignmentErrorKind::RequestError(_inner) => _inner.fmt(f),
            GetAssignmentErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            GetAssignmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAssignmentError {
    fn code(&self) -> Option<&str> {
        GetAssignmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAssignmentError {
    /// Creates a new `GetAssignmentError`.
    pub fn new(kind: GetAssignmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAssignmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAssignmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAssignmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAssignmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAssignmentErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, GetAssignmentErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `GetAssignmentErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, GetAssignmentErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for GetAssignmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAssignmentErrorKind::RequestError(_inner) => Some(_inner),
            GetAssignmentErrorKind::ServiceFault(_inner) => Some(_inner),
            GetAssignmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFileUploadURL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFileUploadURLError {
    /// Kind of error that occurred.
    pub kind: GetFileUploadURLErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFileUploadURL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFileUploadURLErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFileUploadURLError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFileUploadURLErrorKind::RequestError(_inner) => _inner.fmt(f),
            GetFileUploadURLErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            GetFileUploadURLErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFileUploadURLError {
    fn code(&self) -> Option<&str> {
        GetFileUploadURLError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFileUploadURLError {
    /// Creates a new `GetFileUploadURLError`.
    pub fn new(kind: GetFileUploadURLErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFileUploadURLError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFileUploadURLErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFileUploadURLError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFileUploadURLErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetFileUploadURLErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, GetFileUploadURLErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `GetFileUploadURLErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, GetFileUploadURLErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for GetFileUploadURLError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFileUploadURLErrorKind::RequestError(_inner) => Some(_inner),
            GetFileUploadURLErrorKind::ServiceFault(_inner) => Some(_inner),
            GetFileUploadURLErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetHIT` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetHITError {
    /// Kind of error that occurred.
    pub kind: GetHITErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetHIT` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetHITErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetHITError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetHITErrorKind::RequestError(_inner) => _inner.fmt(f),
            GetHITErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            GetHITErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetHITError {
    fn code(&self) -> Option<&str> {
        GetHITError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetHITError {
    /// Creates a new `GetHITError`.
    pub fn new(kind: GetHITErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetHITError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetHITErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetHITError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetHITErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetHITErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, GetHITErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `GetHITErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, GetHITErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for GetHITError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetHITErrorKind::RequestError(_inner) => Some(_inner),
            GetHITErrorKind::ServiceFault(_inner) => Some(_inner),
            GetHITErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetQualificationScore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetQualificationScoreError {
    /// Kind of error that occurred.
    pub kind: GetQualificationScoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetQualificationScore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetQualificationScoreErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetQualificationScoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetQualificationScoreErrorKind::RequestError(_inner) => _inner.fmt(f),
            GetQualificationScoreErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            GetQualificationScoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetQualificationScoreError {
    fn code(&self) -> Option<&str> {
        GetQualificationScoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetQualificationScoreError {
    /// Creates a new `GetQualificationScoreError`.
    pub fn new(kind: GetQualificationScoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetQualificationScoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetQualificationScoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetQualificationScoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetQualificationScoreErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetQualificationScoreErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, GetQualificationScoreErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `GetQualificationScoreErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, GetQualificationScoreErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for GetQualificationScoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetQualificationScoreErrorKind::RequestError(_inner) => Some(_inner),
            GetQualificationScoreErrorKind::ServiceFault(_inner) => Some(_inner),
            GetQualificationScoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetQualificationType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetQualificationTypeError {
    /// Kind of error that occurred.
    pub kind: GetQualificationTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetQualificationType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetQualificationTypeErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetQualificationTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetQualificationTypeErrorKind::RequestError(_inner) => _inner.fmt(f),
            GetQualificationTypeErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            GetQualificationTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetQualificationTypeError {
    fn code(&self) -> Option<&str> {
        GetQualificationTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetQualificationTypeError {
    /// Creates a new `GetQualificationTypeError`.
    pub fn new(kind: GetQualificationTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetQualificationTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetQualificationTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetQualificationTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetQualificationTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetQualificationTypeErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, GetQualificationTypeErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `GetQualificationTypeErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, GetQualificationTypeErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for GetQualificationTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetQualificationTypeErrorKind::RequestError(_inner) => Some(_inner),
            GetQualificationTypeErrorKind::ServiceFault(_inner) => Some(_inner),
            GetQualificationTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssignmentsForHIT` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssignmentsForHITError {
    /// Kind of error that occurred.
    pub kind: ListAssignmentsForHITErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssignmentsForHIT` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssignmentsForHITErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssignmentsForHITError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssignmentsForHITErrorKind::RequestError(_inner) => _inner.fmt(f),
            ListAssignmentsForHITErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            ListAssignmentsForHITErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssignmentsForHITError {
    fn code(&self) -> Option<&str> {
        ListAssignmentsForHITError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssignmentsForHITError {
    /// Creates a new `ListAssignmentsForHITError`.
    pub fn new(kind: ListAssignmentsForHITErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssignmentsForHITError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssignmentsForHITErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssignmentsForHITError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssignmentsForHITErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListAssignmentsForHITErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, ListAssignmentsForHITErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `ListAssignmentsForHITErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, ListAssignmentsForHITErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for ListAssignmentsForHITError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssignmentsForHITErrorKind::RequestError(_inner) => Some(_inner),
            ListAssignmentsForHITErrorKind::ServiceFault(_inner) => Some(_inner),
            ListAssignmentsForHITErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBonusPayments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBonusPaymentsError {
    /// Kind of error that occurred.
    pub kind: ListBonusPaymentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBonusPayments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBonusPaymentsErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBonusPaymentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBonusPaymentsErrorKind::RequestError(_inner) => _inner.fmt(f),
            ListBonusPaymentsErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            ListBonusPaymentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBonusPaymentsError {
    fn code(&self) -> Option<&str> {
        ListBonusPaymentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBonusPaymentsError {
    /// Creates a new `ListBonusPaymentsError`.
    pub fn new(kind: ListBonusPaymentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBonusPaymentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBonusPaymentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBonusPaymentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBonusPaymentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListBonusPaymentsErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, ListBonusPaymentsErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `ListBonusPaymentsErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, ListBonusPaymentsErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for ListBonusPaymentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBonusPaymentsErrorKind::RequestError(_inner) => Some(_inner),
            ListBonusPaymentsErrorKind::ServiceFault(_inner) => Some(_inner),
            ListBonusPaymentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListHITs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListHITsError {
    /// Kind of error that occurred.
    pub kind: ListHITsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListHITs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListHITsErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListHITsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListHITsErrorKind::RequestError(_inner) => _inner.fmt(f),
            ListHITsErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            ListHITsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListHITsError {
    fn code(&self) -> Option<&str> {
        ListHITsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListHITsError {
    /// Creates a new `ListHITsError`.
    pub fn new(kind: ListHITsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListHITsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListHITsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListHITsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListHITsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListHITsErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, ListHITsErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `ListHITsErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, ListHITsErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for ListHITsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListHITsErrorKind::RequestError(_inner) => Some(_inner),
            ListHITsErrorKind::ServiceFault(_inner) => Some(_inner),
            ListHITsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListHITsForQualificationType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListHITsForQualificationTypeError {
    /// Kind of error that occurred.
    pub kind: ListHITsForQualificationTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListHITsForQualificationType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListHITsForQualificationTypeErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListHITsForQualificationTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListHITsForQualificationTypeErrorKind::RequestError(_inner) => _inner.fmt(f),
            ListHITsForQualificationTypeErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            ListHITsForQualificationTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListHITsForQualificationTypeError {
    fn code(&self) -> Option<&str> {
        ListHITsForQualificationTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListHITsForQualificationTypeError {
    /// Creates a new `ListHITsForQualificationTypeError`.
    pub fn new(kind: ListHITsForQualificationTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListHITsForQualificationTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListHITsForQualificationTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListHITsForQualificationTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListHITsForQualificationTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListHITsForQualificationTypeErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(
            &self.kind,
            ListHITsForQualificationTypeErrorKind::RequestError(_)
        )
    }
    /// Returns true if the error kind is `ListHITsForQualificationTypeErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListHITsForQualificationTypeErrorKind::ServiceFault(_)
        )
    }
}
impl std::error::Error for ListHITsForQualificationTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListHITsForQualificationTypeErrorKind::RequestError(_inner) => Some(_inner),
            ListHITsForQualificationTypeErrorKind::ServiceFault(_inner) => Some(_inner),
            ListHITsForQualificationTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListQualificationRequests` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListQualificationRequestsError {
    /// Kind of error that occurred.
    pub kind: ListQualificationRequestsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListQualificationRequests` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListQualificationRequestsErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListQualificationRequestsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListQualificationRequestsErrorKind::RequestError(_inner) => _inner.fmt(f),
            ListQualificationRequestsErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            ListQualificationRequestsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListQualificationRequestsError {
    fn code(&self) -> Option<&str> {
        ListQualificationRequestsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListQualificationRequestsError {
    /// Creates a new `ListQualificationRequestsError`.
    pub fn new(kind: ListQualificationRequestsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListQualificationRequestsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListQualificationRequestsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListQualificationRequestsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListQualificationRequestsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListQualificationRequestsErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(
            &self.kind,
            ListQualificationRequestsErrorKind::RequestError(_)
        )
    }
    /// Returns true if the error kind is `ListQualificationRequestsErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListQualificationRequestsErrorKind::ServiceFault(_)
        )
    }
}
impl std::error::Error for ListQualificationRequestsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListQualificationRequestsErrorKind::RequestError(_inner) => Some(_inner),
            ListQualificationRequestsErrorKind::ServiceFault(_inner) => Some(_inner),
            ListQualificationRequestsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListQualificationTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListQualificationTypesError {
    /// Kind of error that occurred.
    pub kind: ListQualificationTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListQualificationTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListQualificationTypesErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListQualificationTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListQualificationTypesErrorKind::RequestError(_inner) => _inner.fmt(f),
            ListQualificationTypesErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            ListQualificationTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListQualificationTypesError {
    fn code(&self) -> Option<&str> {
        ListQualificationTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListQualificationTypesError {
    /// Creates a new `ListQualificationTypesError`.
    pub fn new(kind: ListQualificationTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListQualificationTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListQualificationTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListQualificationTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListQualificationTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListQualificationTypesErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, ListQualificationTypesErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `ListQualificationTypesErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, ListQualificationTypesErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for ListQualificationTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListQualificationTypesErrorKind::RequestError(_inner) => Some(_inner),
            ListQualificationTypesErrorKind::ServiceFault(_inner) => Some(_inner),
            ListQualificationTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListReviewableHITs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListReviewableHITsError {
    /// Kind of error that occurred.
    pub kind: ListReviewableHITsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListReviewableHITs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListReviewableHITsErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListReviewableHITsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListReviewableHITsErrorKind::RequestError(_inner) => _inner.fmt(f),
            ListReviewableHITsErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            ListReviewableHITsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListReviewableHITsError {
    fn code(&self) -> Option<&str> {
        ListReviewableHITsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListReviewableHITsError {
    /// Creates a new `ListReviewableHITsError`.
    pub fn new(kind: ListReviewableHITsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListReviewableHITsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListReviewableHITsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListReviewableHITsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListReviewableHITsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListReviewableHITsErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, ListReviewableHITsErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `ListReviewableHITsErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, ListReviewableHITsErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for ListReviewableHITsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListReviewableHITsErrorKind::RequestError(_inner) => Some(_inner),
            ListReviewableHITsErrorKind::ServiceFault(_inner) => Some(_inner),
            ListReviewableHITsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListReviewPolicyResultsForHIT` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListReviewPolicyResultsForHITError {
    /// Kind of error that occurred.
    pub kind: ListReviewPolicyResultsForHITErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListReviewPolicyResultsForHIT` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListReviewPolicyResultsForHITErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListReviewPolicyResultsForHITError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListReviewPolicyResultsForHITErrorKind::RequestError(_inner) => _inner.fmt(f),
            ListReviewPolicyResultsForHITErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            ListReviewPolicyResultsForHITErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListReviewPolicyResultsForHITError {
    fn code(&self) -> Option<&str> {
        ListReviewPolicyResultsForHITError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListReviewPolicyResultsForHITError {
    /// Creates a new `ListReviewPolicyResultsForHITError`.
    pub fn new(
        kind: ListReviewPolicyResultsForHITErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListReviewPolicyResultsForHITError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListReviewPolicyResultsForHITErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListReviewPolicyResultsForHITError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListReviewPolicyResultsForHITErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListReviewPolicyResultsForHITErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(
            &self.kind,
            ListReviewPolicyResultsForHITErrorKind::RequestError(_)
        )
    }
    /// Returns true if the error kind is `ListReviewPolicyResultsForHITErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListReviewPolicyResultsForHITErrorKind::ServiceFault(_)
        )
    }
}
impl std::error::Error for ListReviewPolicyResultsForHITError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListReviewPolicyResultsForHITErrorKind::RequestError(_inner) => Some(_inner),
            ListReviewPolicyResultsForHITErrorKind::ServiceFault(_inner) => Some(_inner),
            ListReviewPolicyResultsForHITErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWorkerBlocks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWorkerBlocksError {
    /// Kind of error that occurred.
    pub kind: ListWorkerBlocksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWorkerBlocks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWorkerBlocksErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWorkerBlocksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWorkerBlocksErrorKind::RequestError(_inner) => _inner.fmt(f),
            ListWorkerBlocksErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            ListWorkerBlocksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWorkerBlocksError {
    fn code(&self) -> Option<&str> {
        ListWorkerBlocksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListWorkerBlocksError {
    /// Creates a new `ListWorkerBlocksError`.
    pub fn new(kind: ListWorkerBlocksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWorkerBlocksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWorkerBlocksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWorkerBlocksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWorkerBlocksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListWorkerBlocksErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, ListWorkerBlocksErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `ListWorkerBlocksErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, ListWorkerBlocksErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for ListWorkerBlocksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWorkerBlocksErrorKind::RequestError(_inner) => Some(_inner),
            ListWorkerBlocksErrorKind::ServiceFault(_inner) => Some(_inner),
            ListWorkerBlocksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWorkersWithQualificationType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWorkersWithQualificationTypeError {
    /// Kind of error that occurred.
    pub kind: ListWorkersWithQualificationTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWorkersWithQualificationType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWorkersWithQualificationTypeErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWorkersWithQualificationTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWorkersWithQualificationTypeErrorKind::RequestError(_inner) => _inner.fmt(f),
            ListWorkersWithQualificationTypeErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            ListWorkersWithQualificationTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWorkersWithQualificationTypeError {
    fn code(&self) -> Option<&str> {
        ListWorkersWithQualificationTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListWorkersWithQualificationTypeError {
    /// Creates a new `ListWorkersWithQualificationTypeError`.
    pub fn new(
        kind: ListWorkersWithQualificationTypeErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWorkersWithQualificationTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWorkersWithQualificationTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWorkersWithQualificationTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWorkersWithQualificationTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListWorkersWithQualificationTypeErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkersWithQualificationTypeErrorKind::RequestError(_)
        )
    }
    /// Returns true if the error kind is `ListWorkersWithQualificationTypeErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkersWithQualificationTypeErrorKind::ServiceFault(_)
        )
    }
}
impl std::error::Error for ListWorkersWithQualificationTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWorkersWithQualificationTypeErrorKind::RequestError(_inner) => Some(_inner),
            ListWorkersWithQualificationTypeErrorKind::ServiceFault(_inner) => Some(_inner),
            ListWorkersWithQualificationTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `NotifyWorkers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct NotifyWorkersError {
    /// Kind of error that occurred.
    pub kind: NotifyWorkersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `NotifyWorkers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum NotifyWorkersErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for NotifyWorkersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            NotifyWorkersErrorKind::RequestError(_inner) => _inner.fmt(f),
            NotifyWorkersErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            NotifyWorkersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for NotifyWorkersError {
    fn code(&self) -> Option<&str> {
        NotifyWorkersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl NotifyWorkersError {
    /// Creates a new `NotifyWorkersError`.
    pub fn new(kind: NotifyWorkersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `NotifyWorkersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: NotifyWorkersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `NotifyWorkersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: NotifyWorkersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `NotifyWorkersErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, NotifyWorkersErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `NotifyWorkersErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, NotifyWorkersErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for NotifyWorkersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            NotifyWorkersErrorKind::RequestError(_inner) => Some(_inner),
            NotifyWorkersErrorKind::ServiceFault(_inner) => Some(_inner),
            NotifyWorkersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RejectAssignment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RejectAssignmentError {
    /// Kind of error that occurred.
    pub kind: RejectAssignmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RejectAssignment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RejectAssignmentErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RejectAssignmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RejectAssignmentErrorKind::RequestError(_inner) => _inner.fmt(f),
            RejectAssignmentErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            RejectAssignmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RejectAssignmentError {
    fn code(&self) -> Option<&str> {
        RejectAssignmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RejectAssignmentError {
    /// Creates a new `RejectAssignmentError`.
    pub fn new(kind: RejectAssignmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RejectAssignmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RejectAssignmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RejectAssignmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RejectAssignmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RejectAssignmentErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, RejectAssignmentErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `RejectAssignmentErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, RejectAssignmentErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for RejectAssignmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RejectAssignmentErrorKind::RequestError(_inner) => Some(_inner),
            RejectAssignmentErrorKind::ServiceFault(_inner) => Some(_inner),
            RejectAssignmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RejectQualificationRequest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RejectQualificationRequestError {
    /// Kind of error that occurred.
    pub kind: RejectQualificationRequestErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RejectQualificationRequest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RejectQualificationRequestErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RejectQualificationRequestError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RejectQualificationRequestErrorKind::RequestError(_inner) => _inner.fmt(f),
            RejectQualificationRequestErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            RejectQualificationRequestErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RejectQualificationRequestError {
    fn code(&self) -> Option<&str> {
        RejectQualificationRequestError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RejectQualificationRequestError {
    /// Creates a new `RejectQualificationRequestError`.
    pub fn new(kind: RejectQualificationRequestErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RejectQualificationRequestError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RejectQualificationRequestErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RejectQualificationRequestError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RejectQualificationRequestErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RejectQualificationRequestErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(
            &self.kind,
            RejectQualificationRequestErrorKind::RequestError(_)
        )
    }
    /// Returns true if the error kind is `RejectQualificationRequestErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            RejectQualificationRequestErrorKind::ServiceFault(_)
        )
    }
}
impl std::error::Error for RejectQualificationRequestError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RejectQualificationRequestErrorKind::RequestError(_inner) => Some(_inner),
            RejectQualificationRequestErrorKind::ServiceFault(_inner) => Some(_inner),
            RejectQualificationRequestErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendBonus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendBonusError {
    /// Kind of error that occurred.
    pub kind: SendBonusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendBonus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendBonusErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendBonusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendBonusErrorKind::RequestError(_inner) => _inner.fmt(f),
            SendBonusErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            SendBonusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendBonusError {
    fn code(&self) -> Option<&str> {
        SendBonusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendBonusError {
    /// Creates a new `SendBonusError`.
    pub fn new(kind: SendBonusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendBonusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendBonusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendBonusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendBonusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SendBonusErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, SendBonusErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `SendBonusErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, SendBonusErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for SendBonusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendBonusErrorKind::RequestError(_inner) => Some(_inner),
            SendBonusErrorKind::ServiceFault(_inner) => Some(_inner),
            SendBonusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendTestEventNotification` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendTestEventNotificationError {
    /// Kind of error that occurred.
    pub kind: SendTestEventNotificationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendTestEventNotification` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendTestEventNotificationErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendTestEventNotificationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendTestEventNotificationErrorKind::RequestError(_inner) => _inner.fmt(f),
            SendTestEventNotificationErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            SendTestEventNotificationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendTestEventNotificationError {
    fn code(&self) -> Option<&str> {
        SendTestEventNotificationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendTestEventNotificationError {
    /// Creates a new `SendTestEventNotificationError`.
    pub fn new(kind: SendTestEventNotificationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendTestEventNotificationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendTestEventNotificationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendTestEventNotificationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendTestEventNotificationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SendTestEventNotificationErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(
            &self.kind,
            SendTestEventNotificationErrorKind::RequestError(_)
        )
    }
    /// Returns true if the error kind is `SendTestEventNotificationErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            SendTestEventNotificationErrorKind::ServiceFault(_)
        )
    }
}
impl std::error::Error for SendTestEventNotificationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendTestEventNotificationErrorKind::RequestError(_inner) => Some(_inner),
            SendTestEventNotificationErrorKind::ServiceFault(_inner) => Some(_inner),
            SendTestEventNotificationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateExpirationForHIT` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateExpirationForHITError {
    /// Kind of error that occurred.
    pub kind: UpdateExpirationForHITErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateExpirationForHIT` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateExpirationForHITErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateExpirationForHITError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateExpirationForHITErrorKind::RequestError(_inner) => _inner.fmt(f),
            UpdateExpirationForHITErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            UpdateExpirationForHITErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateExpirationForHITError {
    fn code(&self) -> Option<&str> {
        UpdateExpirationForHITError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateExpirationForHITError {
    /// Creates a new `UpdateExpirationForHITError`.
    pub fn new(kind: UpdateExpirationForHITErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateExpirationForHITError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateExpirationForHITErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateExpirationForHITError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateExpirationForHITErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateExpirationForHITErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, UpdateExpirationForHITErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `UpdateExpirationForHITErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, UpdateExpirationForHITErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for UpdateExpirationForHITError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateExpirationForHITErrorKind::RequestError(_inner) => Some(_inner),
            UpdateExpirationForHITErrorKind::ServiceFault(_inner) => Some(_inner),
            UpdateExpirationForHITErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateHITReviewStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateHITReviewStatusError {
    /// Kind of error that occurred.
    pub kind: UpdateHITReviewStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateHITReviewStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateHITReviewStatusErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateHITReviewStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateHITReviewStatusErrorKind::RequestError(_inner) => _inner.fmt(f),
            UpdateHITReviewStatusErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            UpdateHITReviewStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateHITReviewStatusError {
    fn code(&self) -> Option<&str> {
        UpdateHITReviewStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateHITReviewStatusError {
    /// Creates a new `UpdateHITReviewStatusError`.
    pub fn new(kind: UpdateHITReviewStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateHITReviewStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateHITReviewStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateHITReviewStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateHITReviewStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateHITReviewStatusErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, UpdateHITReviewStatusErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `UpdateHITReviewStatusErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, UpdateHITReviewStatusErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for UpdateHITReviewStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateHITReviewStatusErrorKind::RequestError(_inner) => Some(_inner),
            UpdateHITReviewStatusErrorKind::ServiceFault(_inner) => Some(_inner),
            UpdateHITReviewStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateHITTypeOfHIT` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateHITTypeOfHITError {
    /// Kind of error that occurred.
    pub kind: UpdateHITTypeOfHITErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateHITTypeOfHIT` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateHITTypeOfHITErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateHITTypeOfHITError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateHITTypeOfHITErrorKind::RequestError(_inner) => _inner.fmt(f),
            UpdateHITTypeOfHITErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            UpdateHITTypeOfHITErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateHITTypeOfHITError {
    fn code(&self) -> Option<&str> {
        UpdateHITTypeOfHITError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateHITTypeOfHITError {
    /// Creates a new `UpdateHITTypeOfHITError`.
    pub fn new(kind: UpdateHITTypeOfHITErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateHITTypeOfHITError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateHITTypeOfHITErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateHITTypeOfHITError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateHITTypeOfHITErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateHITTypeOfHITErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(&self.kind, UpdateHITTypeOfHITErrorKind::RequestError(_))
    }
    /// Returns true if the error kind is `UpdateHITTypeOfHITErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(&self.kind, UpdateHITTypeOfHITErrorKind::ServiceFault(_))
    }
}
impl std::error::Error for UpdateHITTypeOfHITError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateHITTypeOfHITErrorKind::RequestError(_inner) => Some(_inner),
            UpdateHITTypeOfHITErrorKind::ServiceFault(_inner) => Some(_inner),
            UpdateHITTypeOfHITErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateNotificationSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateNotificationSettingsError {
    /// Kind of error that occurred.
    pub kind: UpdateNotificationSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateNotificationSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateNotificationSettingsErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateNotificationSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateNotificationSettingsErrorKind::RequestError(_inner) => _inner.fmt(f),
            UpdateNotificationSettingsErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            UpdateNotificationSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateNotificationSettingsError {
    fn code(&self) -> Option<&str> {
        UpdateNotificationSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateNotificationSettingsError {
    /// Creates a new `UpdateNotificationSettingsError`.
    pub fn new(kind: UpdateNotificationSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateNotificationSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateNotificationSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateNotificationSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateNotificationSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateNotificationSettingsErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNotificationSettingsErrorKind::RequestError(_)
        )
    }
    /// Returns true if the error kind is `UpdateNotificationSettingsErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNotificationSettingsErrorKind::ServiceFault(_)
        )
    }
}
impl std::error::Error for UpdateNotificationSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateNotificationSettingsErrorKind::RequestError(_inner) => Some(_inner),
            UpdateNotificationSettingsErrorKind::ServiceFault(_inner) => Some(_inner),
            UpdateNotificationSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateQualificationType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateQualificationTypeError {
    /// Kind of error that occurred.
    pub kind: UpdateQualificationTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateQualificationType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateQualificationTypeErrorKind {
    /// <p>Your request is invalid.</p>
    RequestError(crate::error::RequestError),
    /// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
    ServiceFault(crate::error::ServiceFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateQualificationTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateQualificationTypeErrorKind::RequestError(_inner) => _inner.fmt(f),
            UpdateQualificationTypeErrorKind::ServiceFault(_inner) => _inner.fmt(f),
            UpdateQualificationTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateQualificationTypeError {
    fn code(&self) -> Option<&str> {
        UpdateQualificationTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateQualificationTypeError {
    /// Creates a new `UpdateQualificationTypeError`.
    pub fn new(kind: UpdateQualificationTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateQualificationTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateQualificationTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateQualificationTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateQualificationTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateQualificationTypeErrorKind::RequestError`.
    pub fn is_request_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQualificationTypeErrorKind::RequestError(_)
        )
    }
    /// Returns true if the error kind is `UpdateQualificationTypeErrorKind::ServiceFault`.
    pub fn is_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQualificationTypeErrorKind::ServiceFault(_)
        )
    }
}
impl std::error::Error for UpdateQualificationTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateQualificationTypeErrorKind::RequestError(_inner) => Some(_inner),
            UpdateQualificationTypeErrorKind::ServiceFault(_inner) => Some(_inner),
            UpdateQualificationTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub turk_error_code: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceFault");
        formatter.field("message", &self.message);
        formatter.field("turk_error_code", &self.turk_error_code);
        formatter.finish()
    }
}
impl ServiceFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceFault")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceFault {}
/// See [`ServiceFault`](crate::error::ServiceFault)
pub mod service_fault {
    /// A builder for [`ServiceFault`](crate::error::ServiceFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) turk_error_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn turk_error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.turk_error_code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_turk_error_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.turk_error_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceFault`](crate::error::ServiceFault)
        pub fn build(self) -> crate::error::ServiceFault {
            crate::error::ServiceFault {
                message: self.message,
                turk_error_code: self.turk_error_code,
            }
        }
    }
}
impl ServiceFault {
    /// Creates a new builder-style object to manufacture [`ServiceFault`](crate::error::ServiceFault)
    pub fn builder() -> crate::error::service_fault::Builder {
        crate::error::service_fault::Builder::default()
    }
}

/// <p>Your request is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub turk_error_code: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RequestError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestError");
        formatter.field("message", &self.message);
        formatter.field("turk_error_code", &self.turk_error_code);
        formatter.finish()
    }
}
impl RequestError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RequestError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RequestError")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for RequestError {}
/// See [`RequestError`](crate::error::RequestError)
pub mod request_error {
    /// A builder for [`RequestError`](crate::error::RequestError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) turk_error_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn turk_error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.turk_error_code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_turk_error_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.turk_error_code = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestError`](crate::error::RequestError)
        pub fn build(self) -> crate::error::RequestError {
            crate::error::RequestError {
                message: self.message,
                turk_error_code: self.turk_error_code,
            }
        }
    }
}
impl RequestError {
    /// Creates a new builder-style object to manufacture [`RequestError`](crate::error::RequestError)
    pub fn builder() -> crate::error::request_error::Builder {
        crate::error::request_error::Builder::default()
    }
}
