// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateBrokerInput`](crate::input::CreateBrokerInput)
pub mod create_broker_input {
    /// A builder for [`CreateBrokerInput`](crate::input::CreateBrokerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_strategy:
            std::option::Option<crate::model::AuthenticationStrategy>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) broker_name: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::ConfigurationId>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) deployment_mode: std::option::Option<crate::model::DeploymentMode>,
        pub(crate) encryption_options: std::option::Option<crate::model::EncryptionOptions>,
        pub(crate) engine_type: std::option::Option<crate::model::EngineType>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) host_instance_type: std::option::Option<std::string::String>,
        pub(crate) ldap_server_metadata: std::option::Option<crate::model::LdapServerMetadataInput>,
        pub(crate) logs: std::option::Option<crate::model::Logs>,
        pub(crate) maintenance_window_start_time:
            std::option::Option<crate::model::WeeklyStartTime>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) storage_type: std::option::Option<crate::model::BrokerStorageType>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) users: std::option::Option<std::vec::Vec<crate::model::User>>,
    }
    impl Builder {
        /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
        pub fn authentication_strategy(
            mut self,
            input: crate::model::AuthenticationStrategy,
        ) -> Self {
            self.authentication_strategy = Some(input);
            self
        }
        /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
        pub fn set_authentication_strategy(
            mut self,
            input: std::option::Option<crate::model::AuthenticationStrategy>,
        ) -> Self {
            self.authentication_strategy = input;
            self
        }
        /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot. Set to true by default, if no value is specified.</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot. Set to true by default, if no value is specified.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>Required. The broker's name. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.</p>
        pub fn broker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_name = Some(input.into());
            self
        }
        /// <p>Required. The broker's name. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.</p>
        pub fn set_broker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_name = input;
            self
        }
        /// <p>A list of information about the configuration.</p>
        pub fn configuration(mut self, input: crate::model::ConfigurationId) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>A list of information about the configuration.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ConfigurationId>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the API action. Note: We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the creatorRequestId if your application doesn't require idempotency.</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the API action. Note: We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the creatorRequestId if your application doesn't require idempotency.</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>Required. The broker's deployment mode.</p>
        pub fn deployment_mode(mut self, input: crate::model::DeploymentMode) -> Self {
            self.deployment_mode = Some(input);
            self
        }
        /// <p>Required. The broker's deployment mode.</p>
        pub fn set_deployment_mode(
            mut self,
            input: std::option::Option<crate::model::DeploymentMode>,
        ) -> Self {
            self.deployment_mode = input;
            self
        }
        /// <p>Encryption options for the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn encryption_options(mut self, input: crate::model::EncryptionOptions) -> Self {
            self.encryption_options = Some(input);
            self
        }
        /// <p>Encryption options for the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn set_encryption_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionOptions>,
        ) -> Self {
            self.encryption_options = input;
            self
        }
        /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
        pub fn engine_type(mut self, input: crate::model::EngineType) -> Self {
            self.engine_type = Some(input);
            self
        }
        /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
        pub fn set_engine_type(
            mut self,
            input: std::option::Option<crate::model::EngineType>,
        ) -> Self {
            self.engine_type = input;
            self
        }
        /// <p>Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Required. The broker's instance type.</p>
        pub fn host_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_instance_type = Some(input.into());
            self
        }
        /// <p>Required. The broker's instance type.</p>
        pub fn set_host_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.host_instance_type = input;
            self
        }
        /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn ldap_server_metadata(
            mut self,
            input: crate::model::LdapServerMetadataInput,
        ) -> Self {
            self.ldap_server_metadata = Some(input);
            self
        }
        /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn set_ldap_server_metadata(
            mut self,
            input: std::option::Option<crate::model::LdapServerMetadataInput>,
        ) -> Self {
            self.ldap_server_metadata = input;
            self
        }
        /// <p>Enables Amazon CloudWatch logging for brokers.</p>
        pub fn logs(mut self, input: crate::model::Logs) -> Self {
            self.logs = Some(input);
            self
        }
        /// <p>Enables Amazon CloudWatch logging for brokers.</p>
        pub fn set_logs(mut self, input: std::option::Option<crate::model::Logs>) -> Self {
            self.logs = input;
            self
        }
        /// <p>The parameters that determine the WeeklyStartTime.</p>
        pub fn maintenance_window_start_time(
            mut self,
            input: crate::model::WeeklyStartTime,
        ) -> Self {
            self.maintenance_window_start_time = Some(input);
            self
        }
        /// <p>The parameters that determine the WeeklyStartTime.</p>
        pub fn set_maintenance_window_start_time(
            mut self,
            input: std::option::Option<crate::model::WeeklyStartTime>,
        ) -> Self {
            self.maintenance_window_start_time = input;
            self
        }
        /// <p>Enables connections from applications outside of the VPC that hosts the broker's subnets. Set to false by default, if no value is provided.</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p>Enables connections from applications outside of the VPC that hosts the broker's subnets. Set to false by default, if no value is provided.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>The broker's storage type.</p>
        pub fn storage_type(mut self, input: crate::model::BrokerStorageType) -> Self {
            self.storage_type = Some(input);
            self
        }
        /// <p>The broker's storage type.</p>
        pub fn set_storage_type(
            mut self,
            input: std::option::Option<crate::model::BrokerStorageType>,
        ) -> Self {
            self.storage_type = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones. If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ will not be able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two subnets. A CLUSTER_MULTI_AZ Amazon MQ for RabbitMQ deployment has no subnet requirements when deployed with public accessibility. Deployment without public accessibility requires at least one subnet.</p> <important>
        /// <p>If you specify subnets in a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html">shared VPC</a> for a RabbitMQ broker, the associated VPC to which the specified subnets belong must be owned by your AWS account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by your AWS account.</p>
        /// </important>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones. If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ will not be able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two subnets. A CLUSTER_MULTI_AZ Amazon MQ for RabbitMQ deployment has no subnet requirements when deployed with public accessibility. Deployment without public accessibility requires at least one subnet.</p> <important>
        /// <p>If you specify subnets in a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html">shared VPC</a> for a RabbitMQ broker, the associated VPC to which the specified subnets belong must be owned by your AWS account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by your AWS account.</p>
        /// </important>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags when creating the broker.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Create tags when creating the broker.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `users`.
        ///
        /// To override the contents of this collection use [`set_users`](Self::set_users).
        ///
        /// <p>Required. The list of broker users (persons or applications) who can access queues and topics. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p> <important>
        /// <title>Amazon MQ for RabbitMQ</title>
        /// <p>When you create an Amazon MQ for RabbitMQ broker, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers or via the RabbitMQ web console.</p>
        /// </important>
        pub fn users(mut self, input: crate::model::User) -> Self {
            let mut v = self.users.unwrap_or_default();
            v.push(input);
            self.users = Some(v);
            self
        }
        /// <p>Required. The list of broker users (persons or applications) who can access queues and topics. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p> <important>
        /// <title>Amazon MQ for RabbitMQ</title>
        /// <p>When you create an Amazon MQ for RabbitMQ broker, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers or via the RabbitMQ web console.</p>
        /// </important>
        pub fn set_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::User>>,
        ) -> Self {
            self.users = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBrokerInput`](crate::input::CreateBrokerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBrokerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBrokerInput {
                authentication_strategy: self.authentication_strategy,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade.unwrap_or_default(),
                broker_name: self.broker_name,
                configuration: self.configuration,
                creator_request_id: self.creator_request_id,
                deployment_mode: self.deployment_mode,
                encryption_options: self.encryption_options,
                engine_type: self.engine_type,
                engine_version: self.engine_version,
                host_instance_type: self.host_instance_type,
                ldap_server_metadata: self.ldap_server_metadata,
                logs: self.logs,
                maintenance_window_start_time: self.maintenance_window_start_time,
                publicly_accessible: self.publicly_accessible.unwrap_or_default(),
                security_groups: self.security_groups,
                storage_type: self.storage_type,
                subnet_ids: self.subnet_ids,
                tags: self.tags,
                users: self.users,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBrokerInputOperationOutputAlias = crate::operation::CreateBroker;
#[doc(hidden)]
pub type CreateBrokerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBrokerInput {
    /// Consumes the builder and constructs an Operation<[`CreateBroker`](crate::operation::CreateBroker)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBroker,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBrokerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/brokers").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBrokerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBrokerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.creator_request_id.is_none() {
            self.creator_request_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_broker(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBroker::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBroker",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBrokerInput`](crate::input::CreateBrokerInput)
    pub fn builder() -> crate::input::create_broker_input::Builder {
        crate::input::create_broker_input::Builder::default()
    }
}

/// See [`CreateConfigurationInput`](crate::input::CreateConfigurationInput)
pub mod create_configuration_input {
    /// A builder for [`CreateConfigurationInput`](crate::input::CreateConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_strategy:
            std::option::Option<crate::model::AuthenticationStrategy>,
        pub(crate) engine_type: std::option::Option<crate::model::EngineType>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
        pub fn authentication_strategy(
            mut self,
            input: crate::model::AuthenticationStrategy,
        ) -> Self {
            self.authentication_strategy = Some(input);
            self
        }
        /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
        pub fn set_authentication_strategy(
            mut self,
            input: std::option::Option<crate::model::AuthenticationStrategy>,
        ) -> Self {
            self.authentication_strategy = input;
            self
        }
        /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
        pub fn engine_type(mut self, input: crate::model::EngineType) -> Self {
            self.engine_type = Some(input);
            self
        }
        /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
        pub fn set_engine_type(
            mut self,
            input: std::option::Option<crate::model::EngineType>,
        ) -> Self {
            self.engine_type = input;
            self
        }
        /// <p>Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags when creating the configuration.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Create tags when creating the configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConfigurationInput`](crate::input::CreateConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConfigurationInput {
                authentication_strategy: self.authentication_strategy,
                engine_type: self.engine_type,
                engine_version: self.engine_version,
                name: self.name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConfigurationInputOperationOutputAlias = crate::operation::CreateConfiguration;
#[doc(hidden)]
pub type CreateConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`CreateConfiguration`](crate::operation::CreateConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/configurations").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_configuration(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConfiguration",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateConfigurationInput`](crate::input::CreateConfigurationInput)
    pub fn builder() -> crate::input::create_configuration_input::Builder {
        crate::input::create_configuration_input::Builder::default()
    }
}

/// See [`CreateTagsInput`](crate::input::CreateTagsInput)
pub mod create_tags_input {
    /// A builder for [`CreateTagsInput`](crate::input::CreateTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair for the resource tag.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The key-value pair for the resource tag.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTagsInput`](crate::input::CreateTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTagsInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTagsInputOperationOutputAlias = crate::operation::CreateTags;
#[doc(hidden)]
pub type CreateTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateTagsInput {
    /// Consumes the builder and constructs an Operation<[`CreateTags`](crate::operation::CreateTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.resource_arn;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_1, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_tags(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTags",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTagsInput`](crate::input::CreateTagsInput)
    pub fn builder() -> crate::input::create_tags_input::Builder {
        crate::input::create_tags_input::Builder::default()
    }
}

/// See [`CreateUserInput`](crate::input::CreateUserInput)
pub mod create_user_input {
    /// A builder for [`CreateUserInput`](crate::input::CreateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) broker_id: std::option::Option<std::string::String>,
        pub(crate) console_access: std::option::Option<bool>,
        pub(crate) groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_id = Some(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_id = input;
            self
        }
        /// <p>Enables access to the ActiveMQ Web Console for the ActiveMQ user.</p>
        pub fn console_access(mut self, input: bool) -> Self {
            self.console_access = Some(input);
            self
        }
        /// <p>Enables access to the ActiveMQ Web Console for the ActiveMQ user.</p>
        pub fn set_console_access(mut self, input: std::option::Option<bool>) -> Self {
            self.console_access = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input.into());
            self.groups = Some(v);
            self
        }
        /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>Required. The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>Required. The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserInput`](crate::input::CreateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserInput {
                broker_id: self.broker_id,
                console_access: self.console_access.unwrap_or_default(),
                groups: self.groups,
                password: self.password,
                username: self.username,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserInputOperationOutputAlias = crate::operation::CreateUser;
#[doc(hidden)]
pub type CreateUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUserInput {
    /// Consumes the builder and constructs an Operation<[`CreateUser`](crate::operation::CreateUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.broker_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "broker_id",
                        details: "cannot be empty or unset",
                    })?;
            let broker_id = aws_smithy_http::label::fmt_string(input_2, false);
            if broker_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "broker_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_3 = &_input.username;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "username",
                        details: "cannot be empty or unset",
                    })?;
            let username = aws_smithy_http::label::fmt_string(input_3, false);
            if username.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "username",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/brokers/{BrokerId}/users/{Username}",
                BrokerId = broker_id,
                Username = username
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_user(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUser",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
}

/// See [`DeleteBrokerInput`](crate::input::DeleteBrokerInput)
pub mod delete_broker_input {
    /// A builder for [`DeleteBrokerInput`](crate::input::DeleteBrokerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) broker_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_id = Some(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBrokerInput`](crate::input::DeleteBrokerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBrokerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBrokerInput {
                broker_id: self.broker_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBrokerInputOperationOutputAlias = crate::operation::DeleteBroker;
#[doc(hidden)]
pub type DeleteBrokerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBrokerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBroker`](crate::operation::DeleteBroker)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBroker,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBrokerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.broker_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "broker_id",
                        details: "cannot be empty or unset",
                    })?;
            let broker_id = aws_smithy_http::label::fmt_string(input_4, false);
            if broker_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "broker_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/brokers/{BrokerId}", BrokerId = broker_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBrokerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBrokerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBroker::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBroker",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBrokerInput`](crate::input::DeleteBrokerInput)
    pub fn builder() -> crate::input::delete_broker_input::Builder {
        crate::input::delete_broker_input::Builder::default()
    }
}

/// See [`DeleteTagsInput`](crate::input::DeleteTagsInput)
pub mod delete_tags_input {
    /// A builder for [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>An array of tag keys to delete</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>An array of tag keys to delete</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTagsInput`](crate::input::DeleteTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTagsInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTagsInputOperationOutputAlias = crate::operation::DeleteTags;
#[doc(hidden)]
pub type DeleteTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTagsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTags`](crate::operation::DeleteTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.resource_arn;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_5, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteTagsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_6) = &_input.tag_keys {
                for inner_7 in inner_6 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_7));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTags",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    pub fn builder() -> crate::input::delete_tags_input::Builder {
        crate::input::delete_tags_input::Builder::default()
    }
}

/// See [`DeleteUserInput`](crate::input::DeleteUserInput)
pub mod delete_user_input {
    /// A builder for [`DeleteUserInput`](crate::input::DeleteUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) broker_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_id = Some(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_id = input;
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserInput`](crate::input::DeleteUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserInput {
                broker_id: self.broker_id,
                username: self.username,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserInputOperationOutputAlias = crate::operation::DeleteUser;
#[doc(hidden)]
pub type DeleteUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUserInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUser`](crate::operation::DeleteUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.broker_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "broker_id",
                        details: "cannot be empty or unset",
                    })?;
            let broker_id = aws_smithy_http::label::fmt_string(input_8, false);
            if broker_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "broker_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_9 = &_input.username;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "username",
                        details: "cannot be empty or unset",
                    })?;
            let username = aws_smithy_http::label::fmt_string(input_9, false);
            if username.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "username",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/brokers/{BrokerId}/users/{Username}",
                BrokerId = broker_id,
                Username = username
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUser",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
}

/// See [`DescribeBrokerInput`](crate::input::DescribeBrokerInput)
pub mod describe_broker_input {
    /// A builder for [`DescribeBrokerInput`](crate::input::DescribeBrokerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) broker_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_id = Some(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBrokerInput`](crate::input::DescribeBrokerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBrokerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBrokerInput {
                broker_id: self.broker_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBrokerInputOperationOutputAlias = crate::operation::DescribeBroker;
#[doc(hidden)]
pub type DescribeBrokerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeBrokerInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBroker`](crate::operation::DescribeBroker)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBroker,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBrokerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.broker_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "broker_id",
                        details: "cannot be empty or unset",
                    })?;
            let broker_id = aws_smithy_http::label::fmt_string(input_10, false);
            if broker_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "broker_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/brokers/{BrokerId}", BrokerId = broker_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBrokerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBrokerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBroker::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBroker",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBrokerInput`](crate::input::DescribeBrokerInput)
    pub fn builder() -> crate::input::describe_broker_input::Builder {
        crate::input::describe_broker_input::Builder::default()
    }
}

/// See [`DescribeBrokerEngineTypesInput`](crate::input::DescribeBrokerEngineTypesInput)
pub mod describe_broker_engine_types_input {
    /// A builder for [`DescribeBrokerEngineTypesInput`](crate::input::DescribeBrokerEngineTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine_type: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Filter response by engine type.</p>
        pub fn engine_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_type = Some(input.into());
            self
        }
        /// <p>Filter response by engine type.</p>
        pub fn set_engine_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine_type = input;
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBrokerEngineTypesInput`](crate::input::DescribeBrokerEngineTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBrokerEngineTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBrokerEngineTypesInput {
                engine_type: self.engine_type,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBrokerEngineTypesInputOperationOutputAlias =
    crate::operation::DescribeBrokerEngineTypes;
#[doc(hidden)]
pub type DescribeBrokerEngineTypesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeBrokerEngineTypesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBrokerEngineTypes`](crate::operation::DescribeBrokerEngineTypes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBrokerEngineTypes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBrokerEngineTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/broker-engine-types").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DescribeBrokerEngineTypesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_11) = &_input.engine_type {
                query.push_kv("engineType", &aws_smithy_http::query::fmt_string(&inner_11));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_12) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_12));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBrokerEngineTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBrokerEngineTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBrokerEngineTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBrokerEngineTypes",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBrokerEngineTypesInput`](crate::input::DescribeBrokerEngineTypesInput)
    pub fn builder() -> crate::input::describe_broker_engine_types_input::Builder {
        crate::input::describe_broker_engine_types_input::Builder::default()
    }
}

/// See [`DescribeBrokerInstanceOptionsInput`](crate::input::DescribeBrokerInstanceOptionsInput)
pub mod describe_broker_instance_options_input {
    /// A builder for [`DescribeBrokerInstanceOptionsInput`](crate::input::DescribeBrokerInstanceOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine_type: std::option::Option<std::string::String>,
        pub(crate) host_instance_type: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) storage_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Filter response by engine type.</p>
        pub fn engine_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_type = Some(input.into());
            self
        }
        /// <p>Filter response by engine type.</p>
        pub fn set_engine_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine_type = input;
            self
        }
        /// <p>Filter response by host instance type.</p>
        pub fn host_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_instance_type = Some(input.into());
            self
        }
        /// <p>Filter response by host instance type.</p>
        pub fn set_host_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.host_instance_type = input;
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Filter response by storage type.</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type = Some(input.into());
            self
        }
        /// <p>Filter response by storage type.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBrokerInstanceOptionsInput`](crate::input::DescribeBrokerInstanceOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBrokerInstanceOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBrokerInstanceOptionsInput {
                engine_type: self.engine_type,
                host_instance_type: self.host_instance_type,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                storage_type: self.storage_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBrokerInstanceOptionsInputOperationOutputAlias =
    crate::operation::DescribeBrokerInstanceOptions;
#[doc(hidden)]
pub type DescribeBrokerInstanceOptionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeBrokerInstanceOptionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBrokerInstanceOptions`](crate::operation::DescribeBrokerInstanceOptions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBrokerInstanceOptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBrokerInstanceOptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/broker-instance-options").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DescribeBrokerInstanceOptionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_13) = &_input.engine_type {
                query.push_kv("engineType", &aws_smithy_http::query::fmt_string(&inner_13));
            }
            if let Some(inner_14) = &_input.host_instance_type {
                query.push_kv(
                    "hostInstanceType",
                    &aws_smithy_http::query::fmt_string(&inner_14),
                );
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_15) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_15));
            }
            if let Some(inner_16) = &_input.storage_type {
                query.push_kv(
                    "storageType",
                    &aws_smithy_http::query::fmt_string(&inner_16),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBrokerInstanceOptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBrokerInstanceOptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBrokerInstanceOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBrokerInstanceOptions",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBrokerInstanceOptionsInput`](crate::input::DescribeBrokerInstanceOptionsInput)
    pub fn builder() -> crate::input::describe_broker_instance_options_input::Builder {
        crate::input::describe_broker_instance_options_input::Builder::default()
    }
}

/// See [`DescribeConfigurationInput`](crate::input::DescribeConfigurationInput)
pub mod describe_configuration_input {
    /// A builder for [`DescribeConfigurationInput`](crate::input::DescribeConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_id = Some(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConfigurationInput`](crate::input::DescribeConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConfigurationInput {
                configuration_id: self.configuration_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConfigurationInputOperationOutputAlias = crate::operation::DescribeConfiguration;
#[doc(hidden)]
pub type DescribeConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConfiguration`](crate::operation::DescribeConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.configuration_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_id",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_id = aws_smithy_http::label::fmt_string(input_17, false);
            if configuration_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/configurations/{ConfigurationId}",
                ConfigurationId = configuration_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConfiguration",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationInput`](crate::input::DescribeConfigurationInput)
    pub fn builder() -> crate::input::describe_configuration_input::Builder {
        crate::input::describe_configuration_input::Builder::default()
    }
}

/// See [`DescribeConfigurationRevisionInput`](crate::input::DescribeConfigurationRevisionInput)
pub mod describe_configuration_revision_input {
    /// A builder for [`DescribeConfigurationRevisionInput`](crate::input::DescribeConfigurationRevisionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_id: std::option::Option<std::string::String>,
        pub(crate) configuration_revision: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_id = Some(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_id = input;
            self
        }
        /// <p>The revision of the configuration.</p>
        pub fn configuration_revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_revision = Some(input.into());
            self
        }
        /// <p>The revision of the configuration.</p>
        pub fn set_configuration_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_revision = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConfigurationRevisionInput`](crate::input::DescribeConfigurationRevisionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConfigurationRevisionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConfigurationRevisionInput {
                configuration_id: self.configuration_id,
                configuration_revision: self.configuration_revision,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConfigurationRevisionInputOperationOutputAlias =
    crate::operation::DescribeConfigurationRevision;
#[doc(hidden)]
pub type DescribeConfigurationRevisionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeConfigurationRevisionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConfigurationRevision`](crate::operation::DescribeConfigurationRevision)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConfigurationRevision,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeConfigurationRevisionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.configuration_id;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_id",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_id = aws_smithy_http::label::fmt_string(input_18, false);
            if configuration_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_19 = &_input.configuration_revision;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_revision",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_revision = aws_smithy_http::label::fmt_string(input_19, false);
            if configuration_revision.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_revision",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/configurations/{ConfigurationId}/revisions/{ConfigurationRevision}",
                ConfigurationId = configuration_id,
                ConfigurationRevision = configuration_revision
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeConfigurationRevisionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeConfigurationRevisionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConfigurationRevision::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConfigurationRevision",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationRevisionInput`](crate::input::DescribeConfigurationRevisionInput)
    pub fn builder() -> crate::input::describe_configuration_revision_input::Builder {
        crate::input::describe_configuration_revision_input::Builder::default()
    }
}

/// See [`DescribeUserInput`](crate::input::DescribeUserInput)
pub mod describe_user_input {
    /// A builder for [`DescribeUserInput`](crate::input::DescribeUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) broker_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_id = Some(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_id = input;
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserInput`](crate::input::DescribeUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUserInput {
                broker_id: self.broker_id,
                username: self.username,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUserInputOperationOutputAlias = crate::operation::DescribeUser;
#[doc(hidden)]
pub type DescribeUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeUserInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUser`](crate::operation::DescribeUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.broker_id;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "broker_id",
                        details: "cannot be empty or unset",
                    })?;
            let broker_id = aws_smithy_http::label::fmt_string(input_20, false);
            if broker_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "broker_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_21 = &_input.username;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "username",
                        details: "cannot be empty or unset",
                    })?;
            let username = aws_smithy_http::label::fmt_string(input_21, false);
            if username.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "username",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/brokers/{BrokerId}/users/{Username}",
                BrokerId = broker_id,
                Username = username
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUser",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeUserInput`](crate::input::DescribeUserInput)
    pub fn builder() -> crate::input::describe_user_input::Builder {
        crate::input::describe_user_input::Builder::default()
    }
}

/// See [`ListBrokersInput`](crate::input::ListBrokersInput)
pub mod list_brokers_input {
    /// A builder for [`ListBrokersInput`](crate::input::ListBrokersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBrokersInput`](crate::input::ListBrokersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBrokersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBrokersInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBrokersInputOperationOutputAlias = crate::operation::ListBrokers;
#[doc(hidden)]
pub type ListBrokersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBrokersInput {
    /// Consumes the builder and constructs an Operation<[`ListBrokers`](crate::operation::ListBrokers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBrokers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBrokersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/brokers").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListBrokersInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_22) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_22));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBrokersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBrokersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBrokers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBrokers",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBrokersInput`](crate::input::ListBrokersInput)
    pub fn builder() -> crate::input::list_brokers_input::Builder {
        crate::input::list_brokers_input::Builder::default()
    }
}

/// See [`ListConfigurationRevisionsInput`](crate::input::ListConfigurationRevisionsInput)
pub mod list_configuration_revisions_input {
    /// A builder for [`ListConfigurationRevisionsInput`](crate::input::ListConfigurationRevisionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_id = Some(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_id = input;
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConfigurationRevisionsInput`](crate::input::ListConfigurationRevisionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListConfigurationRevisionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListConfigurationRevisionsInput {
                configuration_id: self.configuration_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListConfigurationRevisionsInputOperationOutputAlias =
    crate::operation::ListConfigurationRevisions;
#[doc(hidden)]
pub type ListConfigurationRevisionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListConfigurationRevisionsInput {
    /// Consumes the builder and constructs an Operation<[`ListConfigurationRevisions`](crate::operation::ListConfigurationRevisions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListConfigurationRevisions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListConfigurationRevisionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.configuration_id;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_id",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_id = aws_smithy_http::label::fmt_string(input_23, false);
            if configuration_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/configurations/{ConfigurationId}/revisions",
                ConfigurationId = configuration_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListConfigurationRevisionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_24) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_24));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListConfigurationRevisionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListConfigurationRevisionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListConfigurationRevisions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListConfigurationRevisions",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListConfigurationRevisionsInput`](crate::input::ListConfigurationRevisionsInput)
    pub fn builder() -> crate::input::list_configuration_revisions_input::Builder {
        crate::input::list_configuration_revisions_input::Builder::default()
    }
}

/// See [`ListConfigurationsInput`](crate::input::ListConfigurationsInput)
pub mod list_configurations_input {
    /// A builder for [`ListConfigurationsInput`](crate::input::ListConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConfigurationsInput`](crate::input::ListConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListConfigurationsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListConfigurationsInputOperationOutputAlias = crate::operation::ListConfigurations;
#[doc(hidden)]
pub type ListConfigurationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`ListConfigurations`](crate::operation::ListConfigurations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListConfigurationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/configurations").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListConfigurationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_25) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_25));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListConfigurationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListConfigurationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListConfigurations",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListConfigurationsInput`](crate::input::ListConfigurationsInput)
    pub fn builder() -> crate::input::list_configurations_input::Builder {
        crate::input::list_configurations_input::Builder::default()
    }
}

/// See [`ListTagsInput`](crate::input::ListTagsInput)
pub mod list_tags_input {
    /// A builder for [`ListTagsInput`](crate::input::ListTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsInput`](crate::input::ListTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListTagsInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsInputOperationOutputAlias = crate::operation::ListTags;
#[doc(hidden)]
pub type ListTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListTags`](crate::operation::ListTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_26 = &_input.resource_arn;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_26, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("ListTags", "mq"));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
}

/// See [`ListUsersInput`](crate::input::ListUsersInput)
pub mod list_users_input {
    /// A builder for [`ListUsersInput`](crate::input::ListUsersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) broker_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_id = Some(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_id = input;
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUsersInput`](crate::input::ListUsersInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListUsersInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListUsersInput {
                broker_id: self.broker_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUsersInputOperationOutputAlias = crate::operation::ListUsers;
#[doc(hidden)]
pub type ListUsersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListUsersInput {
    /// Consumes the builder and constructs an Operation<[`ListUsers`](crate::operation::ListUsers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUsers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListUsersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.broker_id;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "broker_id",
                        details: "cannot be empty or unset",
                    })?;
            let broker_id = aws_smithy_http::label::fmt_string(input_27, false);
            if broker_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "broker_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/brokers/{BrokerId}/users", BrokerId = broker_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListUsersInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_28) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_28));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListUsersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListUsersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListUsers::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("ListUsers", "mq"));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListUsersInput`](crate::input::ListUsersInput)
    pub fn builder() -> crate::input::list_users_input::Builder {
        crate::input::list_users_input::Builder::default()
    }
}

/// See [`RebootBrokerInput`](crate::input::RebootBrokerInput)
pub mod reboot_broker_input {
    /// A builder for [`RebootBrokerInput`](crate::input::RebootBrokerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) broker_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_id = Some(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RebootBrokerInput`](crate::input::RebootBrokerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RebootBrokerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RebootBrokerInput {
                broker_id: self.broker_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RebootBrokerInputOperationOutputAlias = crate::operation::RebootBroker;
#[doc(hidden)]
pub type RebootBrokerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RebootBrokerInput {
    /// Consumes the builder and constructs an Operation<[`RebootBroker`](crate::operation::RebootBroker)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RebootBroker,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RebootBrokerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_29 = &_input.broker_id;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "broker_id",
                        details: "cannot be empty or unset",
                    })?;
            let broker_id = aws_smithy_http::label::fmt_string(input_29, false);
            if broker_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "broker_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/brokers/{BrokerId}/reboot",
                BrokerId = broker_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RebootBrokerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RebootBrokerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RebootBroker::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RebootBroker",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RebootBrokerInput`](crate::input::RebootBrokerInput)
    pub fn builder() -> crate::input::reboot_broker_input::Builder {
        crate::input::reboot_broker_input::Builder::default()
    }
}

/// See [`UpdateBrokerInput`](crate::input::UpdateBrokerInput)
pub mod update_broker_input {
    /// A builder for [`UpdateBrokerInput`](crate::input::UpdateBrokerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_strategy:
            std::option::Option<crate::model::AuthenticationStrategy>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) broker_id: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::ConfigurationId>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) host_instance_type: std::option::Option<std::string::String>,
        pub(crate) ldap_server_metadata: std::option::Option<crate::model::LdapServerMetadataInput>,
        pub(crate) logs: std::option::Option<crate::model::Logs>,
        pub(crate) maintenance_window_start_time:
            std::option::Option<crate::model::WeeklyStartTime>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
        pub fn authentication_strategy(
            mut self,
            input: crate::model::AuthenticationStrategy,
        ) -> Self {
            self.authentication_strategy = Some(input);
            self
        }
        /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
        pub fn set_authentication_strategy(
            mut self,
            input: std::option::Option<crate::model::AuthenticationStrategy>,
        ) -> Self {
            self.authentication_strategy = input;
            self
        }
        /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_id = Some(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_id = input;
            self
        }
        /// <p>A list of information about the configuration.</p>
        pub fn configuration(mut self, input: crate::model::ConfigurationId) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>A list of information about the configuration.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ConfigurationId>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The broker engine version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The broker engine version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types</a>.</p>
        pub fn host_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_instance_type = Some(input.into());
            self
        }
        /// <p>The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types</a>.</p>
        pub fn set_host_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.host_instance_type = input;
            self
        }
        /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn ldap_server_metadata(
            mut self,
            input: crate::model::LdapServerMetadataInput,
        ) -> Self {
            self.ldap_server_metadata = Some(input);
            self
        }
        /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn set_ldap_server_metadata(
            mut self,
            input: std::option::Option<crate::model::LdapServerMetadataInput>,
        ) -> Self {
            self.ldap_server_metadata = input;
            self
        }
        /// <p>Enables Amazon CloudWatch logging for brokers.</p>
        pub fn logs(mut self, input: crate::model::Logs) -> Self {
            self.logs = Some(input);
            self
        }
        /// <p>Enables Amazon CloudWatch logging for brokers.</p>
        pub fn set_logs(mut self, input: std::option::Option<crate::model::Logs>) -> Self {
            self.logs = input;
            self
        }
        /// <p>The parameters that determine the WeeklyStartTime.</p>
        pub fn maintenance_window_start_time(
            mut self,
            input: crate::model::WeeklyStartTime,
        ) -> Self {
            self.maintenance_window_start_time = Some(input);
            self
        }
        /// <p>The parameters that determine the WeeklyStartTime.</p>
        pub fn set_maintenance_window_start_time(
            mut self,
            input: std::option::Option<crate::model::WeeklyStartTime>,
        ) -> Self {
            self.maintenance_window_start_time = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBrokerInput`](crate::input::UpdateBrokerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBrokerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBrokerInput {
                authentication_strategy: self.authentication_strategy,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade.unwrap_or_default(),
                broker_id: self.broker_id,
                configuration: self.configuration,
                engine_version: self.engine_version,
                host_instance_type: self.host_instance_type,
                ldap_server_metadata: self.ldap_server_metadata,
                logs: self.logs,
                maintenance_window_start_time: self.maintenance_window_start_time,
                security_groups: self.security_groups,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBrokerInputOperationOutputAlias = crate::operation::UpdateBroker;
#[doc(hidden)]
pub type UpdateBrokerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateBrokerInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBroker`](crate::operation::UpdateBroker)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBroker,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateBrokerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.broker_id;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "broker_id",
                        details: "cannot be empty or unset",
                    })?;
            let broker_id = aws_smithy_http::label::fmt_string(input_30, false);
            if broker_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "broker_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/brokers/{BrokerId}", BrokerId = broker_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateBrokerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateBrokerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_broker(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBroker::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBroker",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateBrokerInput`](crate::input::UpdateBrokerInput)
    pub fn builder() -> crate::input::update_broker_input::Builder {
        crate::input::update_broker_input::Builder::default()
    }
}

/// See [`UpdateConfigurationInput`](crate::input::UpdateConfigurationInput)
pub mod update_configuration_input {
    /// A builder for [`UpdateConfigurationInput`](crate::input::UpdateConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_id: std::option::Option<std::string::String>,
        pub(crate) data: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_id = Some(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_id = input;
            self
        }
        /// <p>Required. The base64-encoded XML configuration.</p>
        pub fn data(mut self, input: impl Into<std::string::String>) -> Self {
            self.data = Some(input.into());
            self
        }
        /// <p>Required. The base64-encoded XML configuration.</p>
        pub fn set_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data = input;
            self
        }
        /// <p>The description of the configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConfigurationInput`](crate::input::UpdateConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConfigurationInput {
                configuration_id: self.configuration_id,
                data: self.data,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConfigurationInputOperationOutputAlias = crate::operation::UpdateConfiguration;
#[doc(hidden)]
pub type UpdateConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConfiguration`](crate::operation::UpdateConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_31 = &_input.configuration_id;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_id",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_id = aws_smithy_http::label::fmt_string(input_31, false);
            if configuration_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/configurations/{ConfigurationId}",
                ConfigurationId = configuration_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_configuration(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConfiguration",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationInput`](crate::input::UpdateConfigurationInput)
    pub fn builder() -> crate::input::update_configuration_input::Builder {
        crate::input::update_configuration_input::Builder::default()
    }
}

/// See [`UpdateUserInput`](crate::input::UpdateUserInput)
pub mod update_user_input {
    /// A builder for [`UpdateUserInput`](crate::input::UpdateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) broker_id: std::option::Option<std::string::String>,
        pub(crate) console_access: std::option::Option<bool>,
        pub(crate) groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_id = Some(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_id = input;
            self
        }
        /// <p>Enables access to the the ActiveMQ Web Console for the ActiveMQ user.</p>
        pub fn console_access(mut self, input: bool) -> Self {
            self.console_access = Some(input);
            self
        }
        /// <p>Enables access to the the ActiveMQ Web Console for the ActiveMQ user.</p>
        pub fn set_console_access(mut self, input: std::option::Option<bool>) -> Self {
            self.console_access = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input.into());
            self.groups = Some(v);
            self
        }
        /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserInput`](crate::input::UpdateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateUserInput {
                broker_id: self.broker_id,
                console_access: self.console_access.unwrap_or_default(),
                groups: self.groups,
                password: self.password,
                username: self.username,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateUserInputOperationOutputAlias = crate::operation::UpdateUser;
#[doc(hidden)]
pub type UpdateUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateUserInput {
    /// Consumes the builder and constructs an Operation<[`UpdateUser`](crate::operation::UpdateUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_32 = &_input.broker_id;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "broker_id",
                        details: "cannot be empty or unset",
                    })?;
            let broker_id = aws_smithy_http::label::fmt_string(input_32, false);
            if broker_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "broker_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_33 = &_input.username;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "username",
                        details: "cannot be empty or unset",
                    })?;
            let username = aws_smithy_http::label::fmt_string(input_33, false);
            if username.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "username",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/brokers/{BrokerId}/users/{Username}",
                BrokerId = broker_id,
                Username = username
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_user(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateUser",
            "mq",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateUserInput`](crate::input::UpdateUserInput)
    pub fn builder() -> crate::input::update_user_input::Builder {
        crate::input::update_user_input::Builder::default()
    }
}

/// <p>Updates the information for an ActiveMQ user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserInput {
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub broker_id: std::option::Option<std::string::String>,
    /// <p>Enables access to the the ActiveMQ Web Console for the ActiveMQ user.</p>
    pub console_access: bool,
    /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub username: std::option::Option<std::string::String>,
}
impl UpdateUserInput {
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub fn broker_id(&self) -> std::option::Option<&str> {
        self.broker_id.as_deref()
    }
    /// <p>Enables access to the the ActiveMQ Web Console for the ActiveMQ user.</p>
    pub fn console_access(&self) -> bool {
        self.console_access
    }
    /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub fn groups(&self) -> std::option::Option<&[std::string::String]> {
        self.groups.as_deref()
    }
    /// <p>The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
}
impl std::fmt::Debug for UpdateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserInput");
        formatter.field("broker_id", &self.broker_id);
        formatter.field("console_access", &self.console_access);
        formatter.field("groups", &self.groups);
        formatter.field("password", &self.password);
        formatter.field("username", &self.username);
        formatter.finish()
    }
}

/// <p>Updates the specified configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConfigurationInput {
    /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
    pub configuration_id: std::option::Option<std::string::String>,
    /// <p>Required. The base64-encoded XML configuration.</p>
    pub data: std::option::Option<std::string::String>,
    /// <p>The description of the configuration.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateConfigurationInput {
    /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
    pub fn configuration_id(&self) -> std::option::Option<&str> {
        self.configuration_id.as_deref()
    }
    /// <p>Required. The base64-encoded XML configuration.</p>
    pub fn data(&self) -> std::option::Option<&str> {
        self.data.as_deref()
    }
    /// <p>The description of the configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConfigurationInput");
        formatter.field("configuration_id", &self.configuration_id);
        formatter.field("data", &self.data);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

/// <p>Updates the broker using the specified properties.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBrokerInput {
    /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
    pub authentication_strategy: std::option::Option<crate::model::AuthenticationStrategy>,
    /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.</p>
    pub auto_minor_version_upgrade: bool,
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub broker_id: std::option::Option<std::string::String>,
    /// <p>A list of information about the configuration.</p>
    pub configuration: std::option::Option<crate::model::ConfigurationId>,
    /// <p>The broker engine version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types</a>.</p>
    pub host_instance_type: std::option::Option<std::string::String>,
    /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
    pub ldap_server_metadata: std::option::Option<crate::model::LdapServerMetadataInput>,
    /// <p>Enables Amazon CloudWatch logging for brokers.</p>
    pub logs: std::option::Option<crate::model::Logs>,
    /// <p>The parameters that determine the WeeklyStartTime.</p>
    pub maintenance_window_start_time: std::option::Option<crate::model::WeeklyStartTime>,
    /// <p>The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateBrokerInput {
    /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
    pub fn authentication_strategy(
        &self,
    ) -> std::option::Option<&crate::model::AuthenticationStrategy> {
        self.authentication_strategy.as_ref()
    }
    /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.</p>
    pub fn auto_minor_version_upgrade(&self) -> bool {
        self.auto_minor_version_upgrade
    }
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub fn broker_id(&self) -> std::option::Option<&str> {
        self.broker_id.as_deref()
    }
    /// <p>A list of information about the configuration.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::ConfigurationId> {
        self.configuration.as_ref()
    }
    /// <p>The broker engine version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types</a>.</p>
    pub fn host_instance_type(&self) -> std::option::Option<&str> {
        self.host_instance_type.as_deref()
    }
    /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
    pub fn ldap_server_metadata(
        &self,
    ) -> std::option::Option<&crate::model::LdapServerMetadataInput> {
        self.ldap_server_metadata.as_ref()
    }
    /// <p>Enables Amazon CloudWatch logging for brokers.</p>
    pub fn logs(&self) -> std::option::Option<&crate::model::Logs> {
        self.logs.as_ref()
    }
    /// <p>The parameters that determine the WeeklyStartTime.</p>
    pub fn maintenance_window_start_time(
        &self,
    ) -> std::option::Option<&crate::model::WeeklyStartTime> {
        self.maintenance_window_start_time.as_ref()
    }
    /// <p>The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
}
impl std::fmt::Debug for UpdateBrokerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBrokerInput");
        formatter.field("authentication_strategy", &self.authentication_strategy);
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.field("broker_id", &self.broker_id);
        formatter.field("configuration", &self.configuration);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("host_instance_type", &self.host_instance_type);
        formatter.field("ldap_server_metadata", &self.ldap_server_metadata);
        formatter.field("logs", &self.logs);
        formatter.field(
            "maintenance_window_start_time",
            &self.maintenance_window_start_time,
        );
        formatter.field("security_groups", &self.security_groups);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebootBrokerInput {
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub broker_id: std::option::Option<std::string::String>,
}
impl RebootBrokerInput {
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub fn broker_id(&self) -> std::option::Option<&str> {
        self.broker_id.as_deref()
    }
}
impl std::fmt::Debug for RebootBrokerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebootBrokerInput");
        formatter.field("broker_id", &self.broker_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUsersInput {
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub broker_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub max_results: i32,
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListUsersInput {
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub fn broker_id(&self) -> std::option::Option<&str> {
        self.broker_id.as_deref()
    }
    /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListUsersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUsersInput");
        formatter.field("broker_id", &self.broker_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsInput {
    /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsInput {
    /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConfigurationsInput {
    /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub max_results: i32,
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListConfigurationsInput {
    /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListConfigurationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConfigurationsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConfigurationRevisionsInput {
    /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
    pub configuration_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub max_results: i32,
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListConfigurationRevisionsInput {
    /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
    pub fn configuration_id(&self) -> std::option::Option<&str> {
        self.configuration_id.as_deref()
    }
    /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListConfigurationRevisionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConfigurationRevisionsInput");
        formatter.field("configuration_id", &self.configuration_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBrokersInput {
    /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub max_results: i32,
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBrokersInput {
    /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBrokersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBrokersInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUserInput {
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub broker_id: std::option::Option<std::string::String>,
    /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub username: std::option::Option<std::string::String>,
}
impl DescribeUserInput {
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub fn broker_id(&self) -> std::option::Option<&str> {
        self.broker_id.as_deref()
    }
    /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
}
impl std::fmt::Debug for DescribeUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUserInput");
        formatter.field("broker_id", &self.broker_id);
        formatter.field("username", &self.username);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConfigurationRevisionInput {
    /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
    pub configuration_id: std::option::Option<std::string::String>,
    /// <p>The revision of the configuration.</p>
    pub configuration_revision: std::option::Option<std::string::String>,
}
impl DescribeConfigurationRevisionInput {
    /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
    pub fn configuration_id(&self) -> std::option::Option<&str> {
        self.configuration_id.as_deref()
    }
    /// <p>The revision of the configuration.</p>
    pub fn configuration_revision(&self) -> std::option::Option<&str> {
        self.configuration_revision.as_deref()
    }
}
impl std::fmt::Debug for DescribeConfigurationRevisionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConfigurationRevisionInput");
        formatter.field("configuration_id", &self.configuration_id);
        formatter.field("configuration_revision", &self.configuration_revision);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConfigurationInput {
    /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
    pub configuration_id: std::option::Option<std::string::String>,
}
impl DescribeConfigurationInput {
    /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
    pub fn configuration_id(&self) -> std::option::Option<&str> {
        self.configuration_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConfigurationInput");
        formatter.field("configuration_id", &self.configuration_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBrokerInstanceOptionsInput {
    /// <p>Filter response by engine type.</p>
    pub engine_type: std::option::Option<std::string::String>,
    /// <p>Filter response by host instance type.</p>
    pub host_instance_type: std::option::Option<std::string::String>,
    /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub max_results: i32,
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Filter response by storage type.</p>
    pub storage_type: std::option::Option<std::string::String>,
}
impl DescribeBrokerInstanceOptionsInput {
    /// <p>Filter response by engine type.</p>
    pub fn engine_type(&self) -> std::option::Option<&str> {
        self.engine_type.as_deref()
    }
    /// <p>Filter response by host instance type.</p>
    pub fn host_instance_type(&self) -> std::option::Option<&str> {
        self.host_instance_type.as_deref()
    }
    /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Filter response by storage type.</p>
    pub fn storage_type(&self) -> std::option::Option<&str> {
        self.storage_type.as_deref()
    }
}
impl std::fmt::Debug for DescribeBrokerInstanceOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBrokerInstanceOptionsInput");
        formatter.field("engine_type", &self.engine_type);
        formatter.field("host_instance_type", &self.host_instance_type);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("storage_type", &self.storage_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBrokerEngineTypesInput {
    /// <p>Filter response by engine type.</p>
    pub engine_type: std::option::Option<std::string::String>,
    /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub max_results: i32,
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeBrokerEngineTypesInput {
    /// <p>Filter response by engine type.</p>
    pub fn engine_type(&self) -> std::option::Option<&str> {
        self.engine_type.as_deref()
    }
    /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeBrokerEngineTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBrokerEngineTypesInput");
        formatter.field("engine_type", &self.engine_type);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBrokerInput {
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub broker_id: std::option::Option<std::string::String>,
}
impl DescribeBrokerInput {
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub fn broker_id(&self) -> std::option::Option<&str> {
        self.broker_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeBrokerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBrokerInput");
        formatter.field("broker_id", &self.broker_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserInput {
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub broker_id: std::option::Option<std::string::String>,
    /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub username: std::option::Option<std::string::String>,
}
impl DeleteUserInput {
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub fn broker_id(&self) -> std::option::Option<&str> {
        self.broker_id.as_deref()
    }
    /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
}
impl std::fmt::Debug for DeleteUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserInput");
        formatter.field("broker_id", &self.broker_id);
        formatter.field("username", &self.username);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTagsInput {
    /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>An array of tag keys to delete</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DeleteTagsInput {
    /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>An array of tag keys to delete</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for DeleteTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTagsInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBrokerInput {
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub broker_id: std::option::Option<std::string::String>,
}
impl DeleteBrokerInput {
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub fn broker_id(&self) -> std::option::Option<&str> {
        self.broker_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteBrokerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBrokerInput");
        formatter.field("broker_id", &self.broker_id);
        formatter.finish()
    }
}

/// <p>Creates a new ActiveMQ user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserInput {
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub broker_id: std::option::Option<std::string::String>,
    /// <p>Enables access to the ActiveMQ Web Console for the ActiveMQ user.</p>
    pub console_access: bool,
    /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Required. The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub username: std::option::Option<std::string::String>,
}
impl CreateUserInput {
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub fn broker_id(&self) -> std::option::Option<&str> {
        self.broker_id.as_deref()
    }
    /// <p>Enables access to the ActiveMQ Web Console for the ActiveMQ user.</p>
    pub fn console_access(&self) -> bool {
        self.console_access
    }
    /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub fn groups(&self) -> std::option::Option<&[std::string::String]> {
        self.groups.as_deref()
    }
    /// <p>Required. The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
}
impl std::fmt::Debug for CreateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserInput");
        formatter.field("broker_id", &self.broker_id);
        formatter.field("console_access", &self.console_access);
        formatter.field("groups", &self.groups);
        formatter.field("password", &self.password);
        formatter.field("username", &self.username);
        formatter.finish()
    }
}

/// <p>A map of the key-value pairs for the resource tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTagsInput {
    /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The key-value pair for the resource tag.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateTagsInput {
    /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The key-value pair for the resource tag.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTagsInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Creates a new configuration for the specified configuration name. Amazon MQ uses the default configuration (the engine type and version).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigurationInput {
    /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
    pub authentication_strategy: std::option::Option<crate::model::AuthenticationStrategy>,
    /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
    pub engine_type: std::option::Option<crate::model::EngineType>,
    /// <p>Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Create tags when creating the configuration.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateConfigurationInput {
    /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
    pub fn authentication_strategy(
        &self,
    ) -> std::option::Option<&crate::model::AuthenticationStrategy> {
        self.authentication_strategy.as_ref()
    }
    /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
    pub fn engine_type(&self) -> std::option::Option<&crate::model::EngineType> {
        self.engine_type.as_ref()
    }
    /// <p>Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Create tags when creating the configuration.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigurationInput");
        formatter.field("authentication_strategy", &self.authentication_strategy);
        formatter.field("engine_type", &self.engine_type);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Creates a broker using the specified properties.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBrokerInput {
    /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
    pub authentication_strategy: std::option::Option<crate::model::AuthenticationStrategy>,
    /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot. Set to true by default, if no value is specified.</p>
    pub auto_minor_version_upgrade: bool,
    /// <p>Required. The broker's name. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.</p>
    pub broker_name: std::option::Option<std::string::String>,
    /// <p>A list of information about the configuration.</p>
    pub configuration: std::option::Option<crate::model::ConfigurationId>,
    /// <p>The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the API action. Note: We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the creatorRequestId if your application doesn't require idempotency.</p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>Required. The broker's deployment mode.</p>
    pub deployment_mode: std::option::Option<crate::model::DeploymentMode>,
    /// <p>Encryption options for the broker. Does not apply to RabbitMQ brokers.</p>
    pub encryption_options: std::option::Option<crate::model::EncryptionOptions>,
    /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
    pub engine_type: std::option::Option<crate::model::EngineType>,
    /// <p>Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Required. The broker's instance type.</p>
    pub host_instance_type: std::option::Option<std::string::String>,
    /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
    pub ldap_server_metadata: std::option::Option<crate::model::LdapServerMetadataInput>,
    /// <p>Enables Amazon CloudWatch logging for brokers.</p>
    pub logs: std::option::Option<crate::model::Logs>,
    /// <p>The parameters that determine the WeeklyStartTime.</p>
    pub maintenance_window_start_time: std::option::Option<crate::model::WeeklyStartTime>,
    /// <p>Enables connections from applications outside of the VPC that hosts the broker's subnets. Set to false by default, if no value is provided.</p>
    pub publicly_accessible: bool,
    /// <p>The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The broker's storage type.</p>
    pub storage_type: std::option::Option<crate::model::BrokerStorageType>,
    /// <p>The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones. If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ will not be able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two subnets. A CLUSTER_MULTI_AZ Amazon MQ for RabbitMQ deployment has no subnet requirements when deployed with public accessibility. Deployment without public accessibility requires at least one subnet.</p> <important>
    /// <p>If you specify subnets in a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html">shared VPC</a> for a RabbitMQ broker, the associated VPC to which the specified subnets belong must be owned by your AWS account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by your AWS account.</p>
    /// </important>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Create tags when creating the broker.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Required. The list of broker users (persons or applications) who can access queues and topics. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p> <important>
    /// <title>Amazon MQ for RabbitMQ</title>
    /// <p>When you create an Amazon MQ for RabbitMQ broker, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers or via the RabbitMQ web console.</p>
    /// </important>
    pub users: std::option::Option<std::vec::Vec<crate::model::User>>,
}
impl CreateBrokerInput {
    /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
    pub fn authentication_strategy(
        &self,
    ) -> std::option::Option<&crate::model::AuthenticationStrategy> {
        self.authentication_strategy.as_ref()
    }
    /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot. Set to true by default, if no value is specified.</p>
    pub fn auto_minor_version_upgrade(&self) -> bool {
        self.auto_minor_version_upgrade
    }
    /// <p>Required. The broker's name. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.</p>
    pub fn broker_name(&self) -> std::option::Option<&str> {
        self.broker_name.as_deref()
    }
    /// <p>A list of information about the configuration.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::ConfigurationId> {
        self.configuration.as_ref()
    }
    /// <p>The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the API action. Note: We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the creatorRequestId if your application doesn't require idempotency.</p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
    /// <p>Required. The broker's deployment mode.</p>
    pub fn deployment_mode(&self) -> std::option::Option<&crate::model::DeploymentMode> {
        self.deployment_mode.as_ref()
    }
    /// <p>Encryption options for the broker. Does not apply to RabbitMQ brokers.</p>
    pub fn encryption_options(&self) -> std::option::Option<&crate::model::EncryptionOptions> {
        self.encryption_options.as_ref()
    }
    /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
    pub fn engine_type(&self) -> std::option::Option<&crate::model::EngineType> {
        self.engine_type.as_ref()
    }
    /// <p>Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>Required. The broker's instance type.</p>
    pub fn host_instance_type(&self) -> std::option::Option<&str> {
        self.host_instance_type.as_deref()
    }
    /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
    pub fn ldap_server_metadata(
        &self,
    ) -> std::option::Option<&crate::model::LdapServerMetadataInput> {
        self.ldap_server_metadata.as_ref()
    }
    /// <p>Enables Amazon CloudWatch logging for brokers.</p>
    pub fn logs(&self) -> std::option::Option<&crate::model::Logs> {
        self.logs.as_ref()
    }
    /// <p>The parameters that determine the WeeklyStartTime.</p>
    pub fn maintenance_window_start_time(
        &self,
    ) -> std::option::Option<&crate::model::WeeklyStartTime> {
        self.maintenance_window_start_time.as_ref()
    }
    /// <p>Enables connections from applications outside of the VPC that hosts the broker's subnets. Set to false by default, if no value is provided.</p>
    pub fn publicly_accessible(&self) -> bool {
        self.publicly_accessible
    }
    /// <p>The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
    /// <p>The broker's storage type.</p>
    pub fn storage_type(&self) -> std::option::Option<&crate::model::BrokerStorageType> {
        self.storage_type.as_ref()
    }
    /// <p>The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones. If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ will not be able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two subnets. A CLUSTER_MULTI_AZ Amazon MQ for RabbitMQ deployment has no subnet requirements when deployed with public accessibility. Deployment without public accessibility requires at least one subnet.</p> <important>
    /// <p>If you specify subnets in a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html">shared VPC</a> for a RabbitMQ broker, the associated VPC to which the specified subnets belong must be owned by your AWS account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by your AWS account.</p>
    /// </important>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>Create tags when creating the broker.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Required. The list of broker users (persons or applications) who can access queues and topics. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p> <important>
    /// <title>Amazon MQ for RabbitMQ</title>
    /// <p>When you create an Amazon MQ for RabbitMQ broker, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers or via the RabbitMQ web console.</p>
    /// </important>
    pub fn users(&self) -> std::option::Option<&[crate::model::User]> {
        self.users.as_deref()
    }
}
impl std::fmt::Debug for CreateBrokerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBrokerInput");
        formatter.field("authentication_strategy", &self.authentication_strategy);
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.field("broker_name", &self.broker_name);
        formatter.field("configuration", &self.configuration);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("deployment_mode", &self.deployment_mode);
        formatter.field("encryption_options", &self.encryption_options);
        formatter.field("engine_type", &self.engine_type);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("host_instance_type", &self.host_instance_type);
        formatter.field("ldap_server_metadata", &self.ldap_server_metadata);
        formatter.field("logs", &self.logs);
        formatter.field(
            "maintenance_window_start_time",
            &self.maintenance_window_start_time,
        );
        formatter.field("publicly_accessible", &self.publicly_accessible);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("storage_type", &self.storage_type);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("tags", &self.tags);
        formatter.field("users", &self.users);
        formatter.finish()
    }
}
