// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AmazonMQ
///
/// Client for invoking operations on AmazonMQ. Each operation on AmazonMQ is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_mq::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_mq::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_mq::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CreateBroker`](crate::client::fluent_builders::CreateBroker) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_strategy(AuthenticationStrategy)`](crate::client::fluent_builders::CreateBroker::authentication_strategy) / [`set_authentication_strategy(Option<AuthenticationStrategy>)`](crate::client::fluent_builders::CreateBroker::set_authentication_strategy): <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::CreateBroker::auto_minor_version_upgrade) / [`set_auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::CreateBroker::set_auto_minor_version_upgrade): <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot. Set to true by default, if no value is specified.</p>
    ///   - [`broker_name(impl Into<String>)`](crate::client::fluent_builders::CreateBroker::broker_name) / [`set_broker_name(Option<String>)`](crate::client::fluent_builders::CreateBroker::set_broker_name): <p>Required. The broker's name. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.</p>
    ///   - [`configuration(ConfigurationId)`](crate::client::fluent_builders::CreateBroker::configuration) / [`set_configuration(Option<ConfigurationId>)`](crate::client::fluent_builders::CreateBroker::set_configuration): <p>A list of information about the configuration.</p>
    ///   - [`creator_request_id(impl Into<String>)`](crate::client::fluent_builders::CreateBroker::creator_request_id) / [`set_creator_request_id(Option<String>)`](crate::client::fluent_builders::CreateBroker::set_creator_request_id): <p>The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the API action. Note: We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the creatorRequestId if your application doesn't require idempotency.</p>
    ///   - [`deployment_mode(DeploymentMode)`](crate::client::fluent_builders::CreateBroker::deployment_mode) / [`set_deployment_mode(Option<DeploymentMode>)`](crate::client::fluent_builders::CreateBroker::set_deployment_mode): <p>Required. The broker's deployment mode.</p>
    ///   - [`encryption_options(EncryptionOptions)`](crate::client::fluent_builders::CreateBroker::encryption_options) / [`set_encryption_options(Option<EncryptionOptions>)`](crate::client::fluent_builders::CreateBroker::set_encryption_options): <p>Encryption options for the broker. Does not apply to RabbitMQ brokers.</p>
    ///   - [`engine_type(EngineType)`](crate::client::fluent_builders::CreateBroker::engine_type) / [`set_engine_type(Option<EngineType>)`](crate::client::fluent_builders::CreateBroker::set_engine_type): <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::CreateBroker::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::CreateBroker::set_engine_version): <p>Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    ///   - [`host_instance_type(impl Into<String>)`](crate::client::fluent_builders::CreateBroker::host_instance_type) / [`set_host_instance_type(Option<String>)`](crate::client::fluent_builders::CreateBroker::set_host_instance_type): <p>Required. The broker's instance type.</p>
    ///   - [`ldap_server_metadata(LdapServerMetadataInput)`](crate::client::fluent_builders::CreateBroker::ldap_server_metadata) / [`set_ldap_server_metadata(Option<LdapServerMetadataInput>)`](crate::client::fluent_builders::CreateBroker::set_ldap_server_metadata): <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
    ///   - [`logs(Logs)`](crate::client::fluent_builders::CreateBroker::logs) / [`set_logs(Option<Logs>)`](crate::client::fluent_builders::CreateBroker::set_logs): <p>Enables Amazon CloudWatch logging for brokers.</p>
    ///   - [`maintenance_window_start_time(WeeklyStartTime)`](crate::client::fluent_builders::CreateBroker::maintenance_window_start_time) / [`set_maintenance_window_start_time(Option<WeeklyStartTime>)`](crate::client::fluent_builders::CreateBroker::set_maintenance_window_start_time): <p>The parameters that determine the WeeklyStartTime.</p>
    ///   - [`publicly_accessible(bool)`](crate::client::fluent_builders::CreateBroker::publicly_accessible) / [`set_publicly_accessible(bool)`](crate::client::fluent_builders::CreateBroker::set_publicly_accessible): <p>Enables connections from applications outside of the VPC that hosts the broker's subnets. Set to false by default, if no value is provided.</p>
    ///   - [`security_groups(Vec<String>)`](crate::client::fluent_builders::CreateBroker::security_groups) / [`set_security_groups(Option<Vec<String>>)`](crate::client::fluent_builders::CreateBroker::set_security_groups): <p>The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.</p>
    ///   - [`storage_type(BrokerStorageType)`](crate::client::fluent_builders::CreateBroker::storage_type) / [`set_storage_type(Option<BrokerStorageType>)`](crate::client::fluent_builders::CreateBroker::set_storage_type): <p>The broker's storage type.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::CreateBroker::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateBroker::set_subnet_ids): <p>The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones. If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ will not be able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two subnets. A CLUSTER_MULTI_AZ Amazon MQ for RabbitMQ deployment has no subnet requirements when deployed with public accessibility. Deployment without public accessibility requires at least one subnet.</p> <important>  <p>If you specify subnets in a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html">shared VPC</a> for a RabbitMQ broker, the associated VPC to which the specified subnets belong must be owned by your AWS account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by your AWS account.</p> </important>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateBroker::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateBroker::set_tags): <p>Create tags when creating the broker.</p>
    ///   - [`users(Vec<User>)`](crate::client::fluent_builders::CreateBroker::users) / [`set_users(Option<Vec<User>>)`](crate::client::fluent_builders::CreateBroker::set_users): <p>Required. The list of broker users (persons or applications) who can access queues and topics. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p> <important>  <title>Amazon MQ for RabbitMQ</title>   <p>When you create an Amazon MQ for RabbitMQ broker, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers or via the RabbitMQ web console.</p> </important>
    /// - On success, responds with [`CreateBrokerOutput`](crate::output::CreateBrokerOutput) with field(s):
    ///   - [`broker_arn(Option<String>)`](crate::output::CreateBrokerOutput::broker_arn): <p>The broker's Amazon Resource Name (ARN).</p>
    ///   - [`broker_id(Option<String>)`](crate::output::CreateBrokerOutput::broker_id): <p>The unique ID that Amazon MQ generates for the broker.</p>
    /// - On failure, responds with [`SdkError<CreateBrokerError>`](crate::error::CreateBrokerError)
    pub fn create_broker(&self) -> fluent_builders::CreateBroker<C, M, R> {
        fluent_builders::CreateBroker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConfiguration`](crate::client::fluent_builders::CreateConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_strategy(AuthenticationStrategy)`](crate::client::fluent_builders::CreateConfiguration::authentication_strategy) / [`set_authentication_strategy(Option<AuthenticationStrategy>)`](crate::client::fluent_builders::CreateConfiguration::set_authentication_strategy): <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
    ///   - [`engine_type(EngineType)`](crate::client::fluent_builders::CreateConfiguration::engine_type) / [`set_engine_type(Option<EngineType>)`](crate::client::fluent_builders::CreateConfiguration::set_engine_type): <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::CreateConfiguration::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::CreateConfiguration::set_engine_version): <p>Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateConfiguration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateConfiguration::set_name): <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateConfiguration::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateConfiguration::set_tags): <p>Create tags when creating the configuration.</p>
    /// - On success, responds with [`CreateConfigurationOutput`](crate::output::CreateConfigurationOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateConfigurationOutput::arn): <p>Required. The Amazon Resource Name (ARN) of the configuration.</p>
    ///   - [`authentication_strategy(Option<AuthenticationStrategy>)`](crate::output::CreateConfigurationOutput::authentication_strategy): <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
    ///   - [`created(Option<DateTime>)`](crate::output::CreateConfigurationOutput::created): <p>Required. The date and time of the configuration.</p>
    ///   - [`id(Option<String>)`](crate::output::CreateConfigurationOutput::id): <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
    ///   - [`latest_revision(Option<ConfigurationRevision>)`](crate::output::CreateConfigurationOutput::latest_revision): <p>The latest revision of the configuration.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateConfigurationOutput::name): <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
    /// - On failure, responds with [`SdkError<CreateConfigurationError>`](crate::error::CreateConfigurationError)
    pub fn create_configuration(&self) -> fluent_builders::CreateConfiguration<C, M, R> {
        fluent_builders::CreateConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTags`](crate::client::fluent_builders::CreateTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::CreateTags::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::CreateTags::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource tag.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateTags::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateTags::set_tags): <p>The key-value pair for the resource tag.</p>
    /// - On success, responds with [`CreateTagsOutput`](crate::output::CreateTagsOutput)

    /// - On failure, responds with [`SdkError<CreateTagsError>`](crate::error::CreateTagsError)
    pub fn create_tags(&self) -> fluent_builders::CreateTags<C, M, R> {
        fluent_builders::CreateTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUser`](crate::client::fluent_builders::CreateUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`broker_id(impl Into<String>)`](crate::client::fluent_builders::CreateUser::broker_id) / [`set_broker_id(Option<String>)`](crate::client::fluent_builders::CreateUser::set_broker_id): <p>The unique ID that Amazon MQ generates for the broker.</p>
    ///   - [`console_access(bool)`](crate::client::fluent_builders::CreateUser::console_access) / [`set_console_access(bool)`](crate::client::fluent_builders::CreateUser::set_console_access): <p>Enables access to the ActiveMQ Web Console for the ActiveMQ user.</p>
    ///   - [`groups(Vec<String>)`](crate::client::fluent_builders::CreateUser::groups) / [`set_groups(Option<Vec<String>>)`](crate::client::fluent_builders::CreateUser::set_groups): <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::CreateUser::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::CreateUser::set_password): <p>Required. The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::CreateUser::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::CreateUser::set_username): <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    /// - On success, responds with [`CreateUserOutput`](crate::output::CreateUserOutput)

    /// - On failure, responds with [`SdkError<CreateUserError>`](crate::error::CreateUserError)
    pub fn create_user(&self) -> fluent_builders::CreateUser<C, M, R> {
        fluent_builders::CreateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBroker`](crate::client::fluent_builders::DeleteBroker) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`broker_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBroker::broker_id) / [`set_broker_id(Option<String>)`](crate::client::fluent_builders::DeleteBroker::set_broker_id): <p>The unique ID that Amazon MQ generates for the broker.</p>
    /// - On success, responds with [`DeleteBrokerOutput`](crate::output::DeleteBrokerOutput) with field(s):
    ///   - [`broker_id(Option<String>)`](crate::output::DeleteBrokerOutput::broker_id): <p>The unique ID that Amazon MQ generates for the broker.</p>
    /// - On failure, responds with [`SdkError<DeleteBrokerError>`](crate::error::DeleteBrokerError)
    pub fn delete_broker(&self) -> fluent_builders::DeleteBroker<C, M, R> {
        fluent_builders::DeleteBroker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTags`](crate::client::fluent_builders::DeleteTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteTags::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DeleteTags::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource tag.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::DeleteTags::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteTags::set_tag_keys): <p>An array of tag keys to delete</p>
    /// - On success, responds with [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)

    /// - On failure, responds with [`SdkError<DeleteTagsError>`](crate::error::DeleteTagsError)
    pub fn delete_tags(&self) -> fluent_builders::DeleteTags<C, M, R> {
        fluent_builders::DeleteTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUser`](crate::client::fluent_builders::DeleteUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`broker_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUser::broker_id) / [`set_broker_id(Option<String>)`](crate::client::fluent_builders::DeleteUser::set_broker_id): <p>The unique ID that Amazon MQ generates for the broker.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::DeleteUser::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::DeleteUser::set_username): <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    /// - On success, responds with [`DeleteUserOutput`](crate::output::DeleteUserOutput)

    /// - On failure, responds with [`SdkError<DeleteUserError>`](crate::error::DeleteUserError)
    pub fn delete_user(&self) -> fluent_builders::DeleteUser<C, M, R> {
        fluent_builders::DeleteUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBroker`](crate::client::fluent_builders::DescribeBroker) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`broker_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBroker::broker_id) / [`set_broker_id(Option<String>)`](crate::client::fluent_builders::DescribeBroker::set_broker_id): <p>The unique ID that Amazon MQ generates for the broker.</p>
    /// - On success, responds with [`DescribeBrokerOutput`](crate::output::DescribeBrokerOutput) with field(s):
    ///   - [`authentication_strategy(Option<AuthenticationStrategy>)`](crate::output::DescribeBrokerOutput::authentication_strategy): <p>The authentication strategy used to secure the broker. The default is SIMPLE.</p>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::output::DescribeBrokerOutput::auto_minor_version_upgrade): <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.</p>
    ///   - [`broker_arn(Option<String>)`](crate::output::DescribeBrokerOutput::broker_arn): <p>The broker's Amazon Resource Name (ARN).</p>
    ///   - [`broker_id(Option<String>)`](crate::output::DescribeBrokerOutput::broker_id): <p>The unique ID that Amazon MQ generates for the broker.</p>
    ///   - [`broker_instances(Option<Vec<BrokerInstance>>)`](crate::output::DescribeBrokerOutput::broker_instances): <p>A list of information about allocated brokers.</p>
    ///   - [`broker_name(Option<String>)`](crate::output::DescribeBrokerOutput::broker_name): <p>The broker's name. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.</p>
    ///   - [`broker_state(Option<BrokerState>)`](crate::output::DescribeBrokerOutput::broker_state): <p>The broker's status.</p>
    ///   - [`configurations(Option<Configurations>)`](crate::output::DescribeBrokerOutput::configurations): <p>The list of all revisions for the specified configuration.</p>
    ///   - [`created(Option<DateTime>)`](crate::output::DescribeBrokerOutput::created): <p>The time when the broker was created.</p>
    ///   - [`deployment_mode(Option<DeploymentMode>)`](crate::output::DescribeBrokerOutput::deployment_mode): <p>The broker's deployment mode.</p>
    ///   - [`encryption_options(Option<EncryptionOptions>)`](crate::output::DescribeBrokerOutput::encryption_options): <p>Encryption options for the broker. Does not apply to RabbitMQ brokers.</p>
    ///   - [`engine_type(Option<EngineType>)`](crate::output::DescribeBrokerOutput::engine_type): <p>The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
    ///   - [`engine_version(Option<String>)`](crate::output::DescribeBrokerOutput::engine_version): <p>The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    ///   - [`host_instance_type(Option<String>)`](crate::output::DescribeBrokerOutput::host_instance_type): <p>The broker's instance type.</p>
    ///   - [`ldap_server_metadata(Option<LdapServerMetadataOutput>)`](crate::output::DescribeBrokerOutput::ldap_server_metadata): <p>The metadata of the LDAP server used to authenticate and authorize connections to the broker.</p>
    ///   - [`logs(Option<LogsSummary>)`](crate::output::DescribeBrokerOutput::logs): <p>The list of information about logs currently enabled and pending to be deployed for the specified broker.</p>
    ///   - [`maintenance_window_start_time(Option<WeeklyStartTime>)`](crate::output::DescribeBrokerOutput::maintenance_window_start_time): <p>The parameters that determine the WeeklyStartTime.</p>
    ///   - [`pending_authentication_strategy(Option<AuthenticationStrategy>)`](crate::output::DescribeBrokerOutput::pending_authentication_strategy): <p>The authentication strategy that will be applied when the broker is rebooted. The default is SIMPLE.</p>
    ///   - [`pending_engine_version(Option<String>)`](crate::output::DescribeBrokerOutput::pending_engine_version): <p>The broker engine version to upgrade to. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    ///   - [`pending_host_instance_type(Option<String>)`](crate::output::DescribeBrokerOutput::pending_host_instance_type): <p>The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types</a>.</p>
    ///   - [`pending_ldap_server_metadata(Option<LdapServerMetadataOutput>)`](crate::output::DescribeBrokerOutput::pending_ldap_server_metadata): <p>The metadata of the LDAP server that will be used to authenticate and authorize connections to the broker after it is rebooted.</p>
    ///   - [`pending_security_groups(Option<Vec<String>>)`](crate::output::DescribeBrokerOutput::pending_security_groups): <p>The list of pending security groups to authorize connections to brokers.</p>
    ///   - [`publicly_accessible(bool)`](crate::output::DescribeBrokerOutput::publicly_accessible): <p>Enables connections from applications outside of the VPC that hosts the broker's subnets.</p>
    ///   - [`security_groups(Option<Vec<String>>)`](crate::output::DescribeBrokerOutput::security_groups): <p>The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.</p>
    ///   - [`storage_type(Option<BrokerStorageType>)`](crate::output::DescribeBrokerOutput::storage_type): <p>The broker's storage type.</p>
    ///   - [`subnet_ids(Option<Vec<String>>)`](crate::output::DescribeBrokerOutput::subnet_ids): <p>The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeBrokerOutput::tags): <p>The list of all tags associated with this broker.</p>
    ///   - [`users(Option<Vec<UserSummary>>)`](crate::output::DescribeBrokerOutput::users): <p>The list of all broker usernames for the specified broker.</p>
    /// - On failure, responds with [`SdkError<DescribeBrokerError>`](crate::error::DescribeBrokerError)
    pub fn describe_broker(&self) -> fluent_builders::DescribeBroker<C, M, R> {
        fluent_builders::DescribeBroker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBrokerEngineTypes`](crate::client::fluent_builders::DescribeBrokerEngineTypes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine_type(impl Into<String>)`](crate::client::fluent_builders::DescribeBrokerEngineTypes::engine_type) / [`set_engine_type(Option<String>)`](crate::client::fluent_builders::DescribeBrokerEngineTypes::set_engine_type): <p>Filter response by engine type.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeBrokerEngineTypes::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeBrokerEngineTypes::set_max_results): <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeBrokerEngineTypes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeBrokerEngineTypes::set_next_token): <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    /// - On success, responds with [`DescribeBrokerEngineTypesOutput`](crate::output::DescribeBrokerEngineTypesOutput) with field(s):
    ///   - [`broker_engine_types(Option<Vec<BrokerEngineType>>)`](crate::output::DescribeBrokerEngineTypesOutput::broker_engine_types): <p>List of available engine types and versions.</p>
    ///   - [`max_results(i32)`](crate::output::DescribeBrokerEngineTypesOutput::max_results): <p>Required. The maximum number of engine types that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeBrokerEngineTypesOutput::next_token): <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    /// - On failure, responds with [`SdkError<DescribeBrokerEngineTypesError>`](crate::error::DescribeBrokerEngineTypesError)
    pub fn describe_broker_engine_types(
        &self,
    ) -> fluent_builders::DescribeBrokerEngineTypes<C, M, R> {
        fluent_builders::DescribeBrokerEngineTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBrokerInstanceOptions`](crate::client::fluent_builders::DescribeBrokerInstanceOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine_type(impl Into<String>)`](crate::client::fluent_builders::DescribeBrokerInstanceOptions::engine_type) / [`set_engine_type(Option<String>)`](crate::client::fluent_builders::DescribeBrokerInstanceOptions::set_engine_type): <p>Filter response by engine type.</p>
    ///   - [`host_instance_type(impl Into<String>)`](crate::client::fluent_builders::DescribeBrokerInstanceOptions::host_instance_type) / [`set_host_instance_type(Option<String>)`](crate::client::fluent_builders::DescribeBrokerInstanceOptions::set_host_instance_type): <p>Filter response by host instance type.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeBrokerInstanceOptions::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeBrokerInstanceOptions::set_max_results): <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeBrokerInstanceOptions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeBrokerInstanceOptions::set_next_token): <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    ///   - [`storage_type(impl Into<String>)`](crate::client::fluent_builders::DescribeBrokerInstanceOptions::storage_type) / [`set_storage_type(Option<String>)`](crate::client::fluent_builders::DescribeBrokerInstanceOptions::set_storage_type): <p>Filter response by storage type.</p>
    /// - On success, responds with [`DescribeBrokerInstanceOptionsOutput`](crate::output::DescribeBrokerInstanceOptionsOutput) with field(s):
    ///   - [`broker_instance_options(Option<Vec<BrokerInstanceOption>>)`](crate::output::DescribeBrokerInstanceOptionsOutput::broker_instance_options): <p>List of available broker instance options.</p>
    ///   - [`max_results(i32)`](crate::output::DescribeBrokerInstanceOptionsOutput::max_results): <p>Required. The maximum number of instance options that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeBrokerInstanceOptionsOutput::next_token): <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    /// - On failure, responds with [`SdkError<DescribeBrokerInstanceOptionsError>`](crate::error::DescribeBrokerInstanceOptionsError)
    pub fn describe_broker_instance_options(
        &self,
    ) -> fluent_builders::DescribeBrokerInstanceOptions<C, M, R> {
        fluent_builders::DescribeBrokerInstanceOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConfiguration`](crate::client::fluent_builders::DescribeConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_id(impl Into<String>)`](crate::client::fluent_builders::DescribeConfiguration::configuration_id) / [`set_configuration_id(Option<String>)`](crate::client::fluent_builders::DescribeConfiguration::set_configuration_id): <p>The unique ID that Amazon MQ generates for the configuration.</p>
    /// - On success, responds with [`DescribeConfigurationOutput`](crate::output::DescribeConfigurationOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DescribeConfigurationOutput::arn): <p>Required. The ARN of the configuration.</p>
    ///   - [`authentication_strategy(Option<AuthenticationStrategy>)`](crate::output::DescribeConfigurationOutput::authentication_strategy): <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
    ///   - [`created(Option<DateTime>)`](crate::output::DescribeConfigurationOutput::created): <p>Required. The date and time of the configuration revision.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeConfigurationOutput::description): <p>Required. The description of the configuration.</p>
    ///   - [`engine_type(Option<EngineType>)`](crate::output::DescribeConfigurationOutput::engine_type): <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
    ///   - [`engine_version(Option<String>)`](crate::output::DescribeConfigurationOutput::engine_version): <p>Required. The broker engine's version. For a list of supported engine versions, see, <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    ///   - [`id(Option<String>)`](crate::output::DescribeConfigurationOutput::id): <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
    ///   - [`latest_revision(Option<ConfigurationRevision>)`](crate::output::DescribeConfigurationOutput::latest_revision): <p>Required. The latest revision of the configuration.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeConfigurationOutput::name): <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeConfigurationOutput::tags): <p>The list of all tags associated with this configuration.</p>
    /// - On failure, responds with [`SdkError<DescribeConfigurationError>`](crate::error::DescribeConfigurationError)
    pub fn describe_configuration(&self) -> fluent_builders::DescribeConfiguration<C, M, R> {
        fluent_builders::DescribeConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConfigurationRevision`](crate::client::fluent_builders::DescribeConfigurationRevision) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_id(impl Into<String>)`](crate::client::fluent_builders::DescribeConfigurationRevision::configuration_id) / [`set_configuration_id(Option<String>)`](crate::client::fluent_builders::DescribeConfigurationRevision::set_configuration_id): <p>The unique ID that Amazon MQ generates for the configuration.</p>
    ///   - [`configuration_revision(impl Into<String>)`](crate::client::fluent_builders::DescribeConfigurationRevision::configuration_revision) / [`set_configuration_revision(Option<String>)`](crate::client::fluent_builders::DescribeConfigurationRevision::set_configuration_revision): <p>The revision of the configuration.</p>
    /// - On success, responds with [`DescribeConfigurationRevisionOutput`](crate::output::DescribeConfigurationRevisionOutput) with field(s):
    ///   - [`configuration_id(Option<String>)`](crate::output::DescribeConfigurationRevisionOutput::configuration_id): <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
    ///   - [`created(Option<DateTime>)`](crate::output::DescribeConfigurationRevisionOutput::created): <p>Required. The date and time of the configuration.</p>
    ///   - [`data(Option<String>)`](crate::output::DescribeConfigurationRevisionOutput::data): <p>Required. The base64-encoded XML configuration.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeConfigurationRevisionOutput::description): <p>The description of the configuration.</p>
    /// - On failure, responds with [`SdkError<DescribeConfigurationRevisionError>`](crate::error::DescribeConfigurationRevisionError)
    pub fn describe_configuration_revision(
        &self,
    ) -> fluent_builders::DescribeConfigurationRevision<C, M, R> {
        fluent_builders::DescribeConfigurationRevision::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUser`](crate::client::fluent_builders::DescribeUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`broker_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUser::broker_id) / [`set_broker_id(Option<String>)`](crate::client::fluent_builders::DescribeUser::set_broker_id): <p>The unique ID that Amazon MQ generates for the broker.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::DescribeUser::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::DescribeUser::set_username): <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    /// - On success, responds with [`DescribeUserOutput`](crate::output::DescribeUserOutput) with field(s):
    ///   - [`broker_id(Option<String>)`](crate::output::DescribeUserOutput::broker_id): <p>Required. The unique ID that Amazon MQ generates for the broker.</p>
    ///   - [`console_access(bool)`](crate::output::DescribeUserOutput::console_access): <p>Enables access to the the ActiveMQ Web Console for the ActiveMQ user.</p>
    ///   - [`groups(Option<Vec<String>>)`](crate::output::DescribeUserOutput::groups): <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    ///   - [`pending(Option<UserPendingChanges>)`](crate::output::DescribeUserOutput::pending): <p>The status of the changes pending for the ActiveMQ user.</p>
    ///   - [`username(Option<String>)`](crate::output::DescribeUserOutput::username): <p>Required. The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    /// - On failure, responds with [`SdkError<DescribeUserError>`](crate::error::DescribeUserError)
    pub fn describe_user(&self) -> fluent_builders::DescribeUser<C, M, R> {
        fluent_builders::DescribeUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBrokers`](crate::client::fluent_builders::ListBrokers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBrokers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListBrokers::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListBrokers::set_max_results): <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBrokers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBrokers::set_next_token): <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    /// - On success, responds with [`ListBrokersOutput`](crate::output::ListBrokersOutput) with field(s):
    ///   - [`broker_summaries(Option<Vec<BrokerSummary>>)`](crate::output::ListBrokersOutput::broker_summaries): <p>A list of information about all brokers.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBrokersOutput::next_token): <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    /// - On failure, responds with [`SdkError<ListBrokersError>`](crate::error::ListBrokersError)
    pub fn list_brokers(&self) -> fluent_builders::ListBrokers<C, M, R> {
        fluent_builders::ListBrokers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListConfigurationRevisions`](crate::client::fluent_builders::ListConfigurationRevisions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_id(impl Into<String>)`](crate::client::fluent_builders::ListConfigurationRevisions::configuration_id) / [`set_configuration_id(Option<String>)`](crate::client::fluent_builders::ListConfigurationRevisions::set_configuration_id): <p>The unique ID that Amazon MQ generates for the configuration.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListConfigurationRevisions::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListConfigurationRevisions::set_max_results): <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListConfigurationRevisions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListConfigurationRevisions::set_next_token): <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    /// - On success, responds with [`ListConfigurationRevisionsOutput`](crate::output::ListConfigurationRevisionsOutput) with field(s):
    ///   - [`configuration_id(Option<String>)`](crate::output::ListConfigurationRevisionsOutput::configuration_id): <p>The unique ID that Amazon MQ generates for the configuration.</p>
    ///   - [`max_results(i32)`](crate::output::ListConfigurationRevisionsOutput::max_results): <p>The maximum number of configuration revisions that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListConfigurationRevisionsOutput::next_token): <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    ///   - [`revisions(Option<Vec<ConfigurationRevision>>)`](crate::output::ListConfigurationRevisionsOutput::revisions): <p>The list of all revisions for the specified configuration.</p>
    /// - On failure, responds with [`SdkError<ListConfigurationRevisionsError>`](crate::error::ListConfigurationRevisionsError)
    pub fn list_configuration_revisions(
        &self,
    ) -> fluent_builders::ListConfigurationRevisions<C, M, R> {
        fluent_builders::ListConfigurationRevisions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListConfigurations`](crate::client::fluent_builders::ListConfigurations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListConfigurations::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListConfigurations::set_max_results): <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListConfigurations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListConfigurations::set_next_token): <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    /// - On success, responds with [`ListConfigurationsOutput`](crate::output::ListConfigurationsOutput) with field(s):
    ///   - [`configurations(Option<Vec<Configuration>>)`](crate::output::ListConfigurationsOutput::configurations): <p>The list of all revisions for the specified configuration.</p>
    ///   - [`max_results(i32)`](crate::output::ListConfigurationsOutput::max_results): <p>The maximum number of configurations that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListConfigurationsOutput::next_token): <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    /// - On failure, responds with [`SdkError<ListConfigurationsError>`](crate::error::ListConfigurationsError)
    pub fn list_configurations(&self) -> fluent_builders::ListConfigurations<C, M, R> {
        fluent_builders::ListConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTags`](crate::client::fluent_builders::ListTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTags::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTags::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource tag.</p>
    /// - On success, responds with [`ListTagsOutput`](crate::output::ListTagsOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsOutput::tags): <p>The key-value pair for the resource tag.</p>
    /// - On failure, responds with [`SdkError<ListTagsError>`](crate::error::ListTagsError)
    pub fn list_tags(&self) -> fluent_builders::ListTags<C, M, R> {
        fluent_builders::ListTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUsers`](crate::client::fluent_builders::ListUsers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`broker_id(impl Into<String>)`](crate::client::fluent_builders::ListUsers::broker_id) / [`set_broker_id(Option<String>)`](crate::client::fluent_builders::ListUsers::set_broker_id): <p>The unique ID that Amazon MQ generates for the broker.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListUsers::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListUsers::set_max_results): <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListUsers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListUsers::set_next_token): <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    /// - On success, responds with [`ListUsersOutput`](crate::output::ListUsersOutput) with field(s):
    ///   - [`broker_id(Option<String>)`](crate::output::ListUsersOutput::broker_id): <p>Required. The unique ID that Amazon MQ generates for the broker.</p>
    ///   - [`max_results(i32)`](crate::output::ListUsersOutput::max_results): <p>Required. The maximum number of ActiveMQ users that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListUsersOutput::next_token): <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    ///   - [`users(Option<Vec<UserSummary>>)`](crate::output::ListUsersOutput::users): <p>Required. The list of all ActiveMQ usernames for the specified broker. Does not apply to RabbitMQ brokers.</p>
    /// - On failure, responds with [`SdkError<ListUsersError>`](crate::error::ListUsersError)
    pub fn list_users(&self) -> fluent_builders::ListUsers<C, M, R> {
        fluent_builders::ListUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RebootBroker`](crate::client::fluent_builders::RebootBroker) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`broker_id(impl Into<String>)`](crate::client::fluent_builders::RebootBroker::broker_id) / [`set_broker_id(Option<String>)`](crate::client::fluent_builders::RebootBroker::set_broker_id): <p>The unique ID that Amazon MQ generates for the broker.</p>
    /// - On success, responds with [`RebootBrokerOutput`](crate::output::RebootBrokerOutput)

    /// - On failure, responds with [`SdkError<RebootBrokerError>`](crate::error::RebootBrokerError)
    pub fn reboot_broker(&self) -> fluent_builders::RebootBroker<C, M, R> {
        fluent_builders::RebootBroker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateBroker`](crate::client::fluent_builders::UpdateBroker) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_strategy(AuthenticationStrategy)`](crate::client::fluent_builders::UpdateBroker::authentication_strategy) / [`set_authentication_strategy(Option<AuthenticationStrategy>)`](crate::client::fluent_builders::UpdateBroker::set_authentication_strategy): <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::UpdateBroker::auto_minor_version_upgrade) / [`set_auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::UpdateBroker::set_auto_minor_version_upgrade): <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.</p>
    ///   - [`broker_id(impl Into<String>)`](crate::client::fluent_builders::UpdateBroker::broker_id) / [`set_broker_id(Option<String>)`](crate::client::fluent_builders::UpdateBroker::set_broker_id): <p>The unique ID that Amazon MQ generates for the broker.</p>
    ///   - [`configuration(ConfigurationId)`](crate::client::fluent_builders::UpdateBroker::configuration) / [`set_configuration(Option<ConfigurationId>)`](crate::client::fluent_builders::UpdateBroker::set_configuration): <p>A list of information about the configuration.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::UpdateBroker::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::UpdateBroker::set_engine_version): <p>The broker engine version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    ///   - [`host_instance_type(impl Into<String>)`](crate::client::fluent_builders::UpdateBroker::host_instance_type) / [`set_host_instance_type(Option<String>)`](crate::client::fluent_builders::UpdateBroker::set_host_instance_type): <p>The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types</a>.</p>
    ///   - [`ldap_server_metadata(LdapServerMetadataInput)`](crate::client::fluent_builders::UpdateBroker::ldap_server_metadata) / [`set_ldap_server_metadata(Option<LdapServerMetadataInput>)`](crate::client::fluent_builders::UpdateBroker::set_ldap_server_metadata): <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
    ///   - [`logs(Logs)`](crate::client::fluent_builders::UpdateBroker::logs) / [`set_logs(Option<Logs>)`](crate::client::fluent_builders::UpdateBroker::set_logs): <p>Enables Amazon CloudWatch logging for brokers.</p>
    ///   - [`maintenance_window_start_time(WeeklyStartTime)`](crate::client::fluent_builders::UpdateBroker::maintenance_window_start_time) / [`set_maintenance_window_start_time(Option<WeeklyStartTime>)`](crate::client::fluent_builders::UpdateBroker::set_maintenance_window_start_time): <p>The parameters that determine the WeeklyStartTime.</p>
    ///   - [`security_groups(Vec<String>)`](crate::client::fluent_builders::UpdateBroker::security_groups) / [`set_security_groups(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateBroker::set_security_groups): <p>The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.</p>
    /// - On success, responds with [`UpdateBrokerOutput`](crate::output::UpdateBrokerOutput) with field(s):
    ///   - [`authentication_strategy(Option<AuthenticationStrategy>)`](crate::output::UpdateBrokerOutput::authentication_strategy): <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::output::UpdateBrokerOutput::auto_minor_version_upgrade): <p>The new boolean value that specifies whether broker engines automatically upgrade to new minor versions as new versions are released and supported by Amazon MQ.</p>
    ///   - [`broker_id(Option<String>)`](crate::output::UpdateBrokerOutput::broker_id): <p>Required. The unique ID that Amazon MQ generates for the broker.</p>
    ///   - [`configuration(Option<ConfigurationId>)`](crate::output::UpdateBrokerOutput::configuration): <p>The ID of the updated configuration.</p>
    ///   - [`engine_version(Option<String>)`](crate::output::UpdateBrokerOutput::engine_version): <p>The broker engine version to upgrade to. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    ///   - [`host_instance_type(Option<String>)`](crate::output::UpdateBrokerOutput::host_instance_type): <p>The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types</a>.</p>
    ///   - [`ldap_server_metadata(Option<LdapServerMetadataOutput>)`](crate::output::UpdateBrokerOutput::ldap_server_metadata): <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
    ///   - [`logs(Option<Logs>)`](crate::output::UpdateBrokerOutput::logs): <p>The list of information about logs to be enabled for the specified broker.</p>
    ///   - [`maintenance_window_start_time(Option<WeeklyStartTime>)`](crate::output::UpdateBrokerOutput::maintenance_window_start_time): <p>The parameters that determine the WeeklyStartTime.</p>
    ///   - [`security_groups(Option<Vec<String>>)`](crate::output::UpdateBrokerOutput::security_groups): <p>The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.</p>
    /// - On failure, responds with [`SdkError<UpdateBrokerError>`](crate::error::UpdateBrokerError)
    pub fn update_broker(&self) -> fluent_builders::UpdateBroker<C, M, R> {
        fluent_builders::UpdateBroker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConfiguration`](crate::client::fluent_builders::UpdateConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_id(impl Into<String>)`](crate::client::fluent_builders::UpdateConfiguration::configuration_id) / [`set_configuration_id(Option<String>)`](crate::client::fluent_builders::UpdateConfiguration::set_configuration_id): <p>The unique ID that Amazon MQ generates for the configuration.</p>
    ///   - [`data(impl Into<String>)`](crate::client::fluent_builders::UpdateConfiguration::data) / [`set_data(Option<String>)`](crate::client::fluent_builders::UpdateConfiguration::set_data): <p>Required. The base64-encoded XML configuration.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateConfiguration::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateConfiguration::set_description): <p>The description of the configuration.</p>
    /// - On success, responds with [`UpdateConfigurationOutput`](crate::output::UpdateConfigurationOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdateConfigurationOutput::arn): <p>Required. The Amazon Resource Name (ARN) of the configuration.</p>
    ///   - [`created(Option<DateTime>)`](crate::output::UpdateConfigurationOutput::created): <p>Required. The date and time of the configuration.</p>
    ///   - [`id(Option<String>)`](crate::output::UpdateConfigurationOutput::id): <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
    ///   - [`latest_revision(Option<ConfigurationRevision>)`](crate::output::UpdateConfigurationOutput::latest_revision): <p>The latest revision of the configuration.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateConfigurationOutput::name): <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
    ///   - [`warnings(Option<Vec<SanitizationWarning>>)`](crate::output::UpdateConfigurationOutput::warnings): <p>The list of the first 20 warnings about the configuration XML elements or attributes that were sanitized.</p>
    /// - On failure, responds with [`SdkError<UpdateConfigurationError>`](crate::error::UpdateConfigurationError)
    pub fn update_configuration(&self) -> fluent_builders::UpdateConfiguration<C, M, R> {
        fluent_builders::UpdateConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUser`](crate::client::fluent_builders::UpdateUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`broker_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::broker_id) / [`set_broker_id(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_broker_id): <p>The unique ID that Amazon MQ generates for the broker.</p>
    ///   - [`console_access(bool)`](crate::client::fluent_builders::UpdateUser::console_access) / [`set_console_access(bool)`](crate::client::fluent_builders::UpdateUser::set_console_access): <p>Enables access to the the ActiveMQ Web Console for the ActiveMQ user.</p>
    ///   - [`groups(Vec<String>)`](crate::client::fluent_builders::UpdateUser::groups) / [`set_groups(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateUser::set_groups): <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_password): <p>The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_username): <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    /// - On success, responds with [`UpdateUserOutput`](crate::output::UpdateUserOutput)

    /// - On failure, responds with [`SdkError<UpdateUserError>`](crate::error::UpdateUserError)
    pub fn update_user(&self) -> fluent_builders::UpdateUser<C, M, R> {
        fluent_builders::UpdateUser::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateBroker`.
    ///
    /// <p>Creates a broker. Note: This API is asynchronous.</p>
    /// <p>To create a broker, you must either use the AmazonMQFullAccess IAM policy or include the following EC2 permissions in your IAM policy.</p>
    /// <ul>
    /// <li><p>ec2:CreateNetworkInterface</p> <p>This permission is required to allow Amazon MQ to create an elastic network interface (ENI) on behalf of your account.</p></li>
    /// <li><p>ec2:CreateNetworkInterfacePermission</p> <p>This permission is required to attach the ENI to the broker instance.</p></li>
    /// <li><p>ec2:DeleteNetworkInterface</p></li>
    /// <li><p>ec2:DeleteNetworkInterfacePermission</p></li>
    /// <li><p>ec2:DetachNetworkInterface</p></li>
    /// <li><p>ec2:DescribeInternetGateways</p></li>
    /// <li><p>ec2:DescribeNetworkInterfaces</p></li>
    /// <li><p>ec2:DescribeNetworkInterfacePermissions</p></li>
    /// <li><p>ec2:DescribeRouteTables</p></li>
    /// <li><p>ec2:DescribeSecurityGroups</p></li>
    /// <li><p>ec2:DescribeSubnets</p></li>
    /// <li><p>ec2:DescribeVpcs</p></li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/amazon-mq-setting-up.html#create-iam-user">Create an IAM User and Get Your AWS Credentials</a> and <a href="https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/connecting-to-amazon-mq.html#never-modify-delete-elastic-network-interface">Never Modify or Delete the Amazon MQ Elastic Network Interface</a> in the <i>Amazon MQ Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBroker<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_broker_input::Builder,
    }
    impl<C, M, R> CreateBroker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBroker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBrokerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBrokerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBrokerInputOperationOutputAlias,
                crate::output::CreateBrokerOutput,
                crate::error::CreateBrokerError,
                crate::input::CreateBrokerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
        pub fn authentication_strategy(
            mut self,
            input: crate::model::AuthenticationStrategy,
        ) -> Self {
            self.inner = self.inner.authentication_strategy(input);
            self
        }
        /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
        pub fn set_authentication_strategy(
            mut self,
            input: std::option::Option<crate::model::AuthenticationStrategy>,
        ) -> Self {
            self.inner = self.inner.set_authentication_strategy(input);
            self
        }
        /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot. Set to true by default, if no value is specified.</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(input);
            self
        }
        /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot. Set to true by default, if no value is specified.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// <p>Required. The broker's name. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.</p>
        pub fn broker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_name(input.into());
            self
        }
        /// <p>Required. The broker's name. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.</p>
        pub fn set_broker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_name(input);
            self
        }
        /// <p>A list of information about the configuration.</p>
        pub fn configuration(mut self, input: crate::model::ConfigurationId) -> Self {
            self.inner = self.inner.configuration(input);
            self
        }
        /// <p>A list of information about the configuration.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ConfigurationId>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the API action. Note: We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the creatorRequestId if your application doesn't require idempotency.</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(input.into());
            self
        }
        /// <p>The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the API action. Note: We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the creatorRequestId if your application doesn't require idempotency.</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// <p>Required. The broker's deployment mode.</p>
        pub fn deployment_mode(mut self, input: crate::model::DeploymentMode) -> Self {
            self.inner = self.inner.deployment_mode(input);
            self
        }
        /// <p>Required. The broker's deployment mode.</p>
        pub fn set_deployment_mode(
            mut self,
            input: std::option::Option<crate::model::DeploymentMode>,
        ) -> Self {
            self.inner = self.inner.set_deployment_mode(input);
            self
        }
        /// <p>Encryption options for the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn encryption_options(mut self, input: crate::model::EncryptionOptions) -> Self {
            self.inner = self.inner.encryption_options(input);
            self
        }
        /// <p>Encryption options for the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn set_encryption_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionOptions>,
        ) -> Self {
            self.inner = self.inner.set_encryption_options(input);
            self
        }
        /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
        pub fn engine_type(mut self, input: crate::model::EngineType) -> Self {
            self.inner = self.inner.engine_type(input);
            self
        }
        /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
        pub fn set_engine_type(
            mut self,
            input: std::option::Option<crate::model::EngineType>,
        ) -> Self {
            self.inner = self.inner.set_engine_type(input);
            self
        }
        /// <p>Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>Required. The broker's instance type.</p>
        pub fn host_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.host_instance_type(input.into());
            self
        }
        /// <p>Required. The broker's instance type.</p>
        pub fn set_host_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_host_instance_type(input);
            self
        }
        /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn ldap_server_metadata(
            mut self,
            input: crate::model::LdapServerMetadataInput,
        ) -> Self {
            self.inner = self.inner.ldap_server_metadata(input);
            self
        }
        /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn set_ldap_server_metadata(
            mut self,
            input: std::option::Option<crate::model::LdapServerMetadataInput>,
        ) -> Self {
            self.inner = self.inner.set_ldap_server_metadata(input);
            self
        }
        /// <p>Enables Amazon CloudWatch logging for brokers.</p>
        pub fn logs(mut self, input: crate::model::Logs) -> Self {
            self.inner = self.inner.logs(input);
            self
        }
        /// <p>Enables Amazon CloudWatch logging for brokers.</p>
        pub fn set_logs(mut self, input: std::option::Option<crate::model::Logs>) -> Self {
            self.inner = self.inner.set_logs(input);
            self
        }
        /// <p>The parameters that determine the WeeklyStartTime.</p>
        pub fn maintenance_window_start_time(
            mut self,
            input: crate::model::WeeklyStartTime,
        ) -> Self {
            self.inner = self.inner.maintenance_window_start_time(input);
            self
        }
        /// <p>The parameters that determine the WeeklyStartTime.</p>
        pub fn set_maintenance_window_start_time(
            mut self,
            input: std::option::Option<crate::model::WeeklyStartTime>,
        ) -> Self {
            self.inner = self.inner.set_maintenance_window_start_time(input);
            self
        }
        /// <p>Enables connections from applications outside of the VPC that hosts the broker's subnets. Set to false by default, if no value is provided.</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.inner = self.inner.publicly_accessible(input);
            self
        }
        /// <p>Enables connections from applications outside of the VPC that hosts the broker's subnets. Set to false by default, if no value is provided.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_accessible(input);
            self
        }
        /// Appends an item to `SecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_groups(input.into());
            self
        }
        /// <p>The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_groups(input);
            self
        }
        /// <p>The broker's storage type.</p>
        pub fn storage_type(mut self, input: crate::model::BrokerStorageType) -> Self {
            self.inner = self.inner.storage_type(input);
            self
        }
        /// <p>The broker's storage type.</p>
        pub fn set_storage_type(
            mut self,
            input: std::option::Option<crate::model::BrokerStorageType>,
        ) -> Self {
            self.inner = self.inner.set_storage_type(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones. If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ will not be able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two subnets. A CLUSTER_MULTI_AZ Amazon MQ for RabbitMQ deployment has no subnet requirements when deployed with public accessibility. Deployment without public accessibility requires at least one subnet.</p> <important>
        /// <p>If you specify subnets in a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html">shared VPC</a> for a RabbitMQ broker, the associated VPC to which the specified subnets belong must be owned by your AWS account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by your AWS account.</p>
        /// </important>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones. If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ will not be able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two subnets. A CLUSTER_MULTI_AZ Amazon MQ for RabbitMQ deployment has no subnet requirements when deployed with public accessibility. Deployment without public accessibility requires at least one subnet.</p> <important>
        /// <p>If you specify subnets in a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html">shared VPC</a> for a RabbitMQ broker, the associated VPC to which the specified subnets belong must be owned by your AWS account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by your AWS account.</p>
        /// </important>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags when creating the broker.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Create tags when creating the broker.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `Users`.
        ///
        /// To override the contents of this collection use [`set_users`](Self::set_users).
        ///
        /// <p>Required. The list of broker users (persons or applications) who can access queues and topics. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p> <important>
        /// <title>Amazon MQ for RabbitMQ</title>
        /// <p>When you create an Amazon MQ for RabbitMQ broker, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers or via the RabbitMQ web console.</p>
        /// </important>
        pub fn users(mut self, input: crate::model::User) -> Self {
            self.inner = self.inner.users(input);
            self
        }
        /// <p>Required. The list of broker users (persons or applications) who can access queues and topics. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p> <important>
        /// <title>Amazon MQ for RabbitMQ</title>
        /// <p>When you create an Amazon MQ for RabbitMQ broker, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers or via the RabbitMQ web console.</p>
        /// </important>
        pub fn set_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::User>>,
        ) -> Self {
            self.inner = self.inner.set_users(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConfiguration`.
    ///
    /// <p>Creates a new configuration for the specified configuration name. Amazon MQ uses the default configuration (the engine type and version).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_configuration_input::Builder,
    }
    impl<C, M, R> CreateConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConfigurationInputOperationOutputAlias,
                crate::output::CreateConfigurationOutput,
                crate::error::CreateConfigurationError,
                crate::input::CreateConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
        pub fn authentication_strategy(
            mut self,
            input: crate::model::AuthenticationStrategy,
        ) -> Self {
            self.inner = self.inner.authentication_strategy(input);
            self
        }
        /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
        pub fn set_authentication_strategy(
            mut self,
            input: std::option::Option<crate::model::AuthenticationStrategy>,
        ) -> Self {
            self.inner = self.inner.set_authentication_strategy(input);
            self
        }
        /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
        pub fn engine_type(mut self, input: crate::model::EngineType) -> Self {
            self.inner = self.inner.engine_type(input);
            self
        }
        /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
        pub fn set_engine_type(
            mut self,
            input: std::option::Option<crate::model::EngineType>,
        ) -> Self {
            self.inner = self.inner.set_engine_type(input);
            self
        }
        /// <p>Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags when creating the configuration.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Create tags when creating the configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTags`.
    ///
    /// <p>Add a tag to a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_tags_input::Builder,
    }
    impl<C, M, R> CreateTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTagsInputOperationOutputAlias,
                crate::output::CreateTagsOutput,
                crate::error::CreateTagsError,
                crate::input::CreateTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair for the resource tag.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The key-value pair for the resource tag.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUser`.
    ///
    /// <p>Creates an ActiveMQ user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_input::Builder,
    }
    impl<C, M, R> CreateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserInputOperationOutputAlias,
                crate::output::CreateUserOutput,
                crate::error::CreateUserError,
                crate::input::CreateUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_id(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_id(input);
            self
        }
        /// <p>Enables access to the ActiveMQ Web Console for the ActiveMQ user.</p>
        pub fn console_access(mut self, input: bool) -> Self {
            self.inner = self.inner.console_access(input);
            self
        }
        /// <p>Enables access to the ActiveMQ Web Console for the ActiveMQ user.</p>
        pub fn set_console_access(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_console_access(input);
            self
        }
        /// Appends an item to `Groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.groups(input.into());
            self
        }
        /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_groups(input);
            self
        }
        /// <p>Required. The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>Required. The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBroker`.
    ///
    /// <p>Deletes a broker. Note: This API is asynchronous.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBroker<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_broker_input::Builder,
    }
    impl<C, M, R> DeleteBroker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBroker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBrokerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBrokerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBrokerInputOperationOutputAlias,
                crate::output::DeleteBrokerOutput,
                crate::error::DeleteBrokerError,
                crate::input::DeleteBrokerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_id(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTags`.
    ///
    /// <p>Removes a tag from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_tags_input::Builder,
    }
    impl<C, M, R> DeleteTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTagsInputOperationOutputAlias,
                crate::output::DeleteTagsOutput,
                crate::error::DeleteTagsError,
                crate::input::DeleteTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>An array of tag keys to delete</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>An array of tag keys to delete</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUser`.
    ///
    /// <p>Deletes an ActiveMQ user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_input::Builder,
    }
    impl<C, M, R> DeleteUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserInputOperationOutputAlias,
                crate::output::DeleteUserOutput,
                crate::error::DeleteUserError,
                crate::input::DeleteUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_id(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_id(input);
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBroker`.
    ///
    /// <p>Returns information about the specified broker.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBroker<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_broker_input::Builder,
    }
    impl<C, M, R> DescribeBroker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBroker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBrokerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBrokerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBrokerInputOperationOutputAlias,
                crate::output::DescribeBrokerOutput,
                crate::error::DescribeBrokerError,
                crate::input::DescribeBrokerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_id(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBrokerEngineTypes`.
    ///
    /// <p>Describe available engine types and versions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBrokerEngineTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_broker_engine_types_input::Builder,
    }
    impl<C, M, R> DescribeBrokerEngineTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBrokerEngineTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBrokerEngineTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBrokerEngineTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBrokerEngineTypesInputOperationOutputAlias,
                crate::output::DescribeBrokerEngineTypesOutput,
                crate::error::DescribeBrokerEngineTypesError,
                crate::input::DescribeBrokerEngineTypesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filter response by engine type.</p>
        pub fn engine_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_type(input.into());
            self
        }
        /// <p>Filter response by engine type.</p>
        pub fn set_engine_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine_type(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBrokerInstanceOptions`.
    ///
    /// <p>Describe available broker instance options.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBrokerInstanceOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_broker_instance_options_input::Builder,
    }
    impl<C, M, R> DescribeBrokerInstanceOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBrokerInstanceOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBrokerInstanceOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBrokerInstanceOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBrokerInstanceOptionsInputOperationOutputAlias,
                crate::output::DescribeBrokerInstanceOptionsOutput,
                crate::error::DescribeBrokerInstanceOptionsError,
                crate::input::DescribeBrokerInstanceOptionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filter response by engine type.</p>
        pub fn engine_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_type(input.into());
            self
        }
        /// <p>Filter response by engine type.</p>
        pub fn set_engine_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine_type(input);
            self
        }
        /// <p>Filter response by host instance type.</p>
        pub fn host_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.host_instance_type(input.into());
            self
        }
        /// <p>Filter response by host instance type.</p>
        pub fn set_host_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_host_instance_type(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Filter response by storage type.</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.storage_type(input.into());
            self
        }
        /// <p>Filter response by storage type.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_storage_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConfiguration`.
    ///
    /// <p>Returns information about the specified configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_configuration_input::Builder,
    }
    impl<C, M, R> DescribeConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConfigurationInputOperationOutputAlias,
                crate::output::DescribeConfigurationOutput,
                crate::error::DescribeConfigurationError,
                crate::input::DescribeConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_id(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConfigurationRevision`.
    ///
    /// <p>Returns the specified configuration revision for the specified configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConfigurationRevision<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_configuration_revision_input::Builder,
    }
    impl<C, M, R> DescribeConfigurationRevision<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConfigurationRevision`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConfigurationRevisionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConfigurationRevisionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConfigurationRevisionInputOperationOutputAlias,
                crate::output::DescribeConfigurationRevisionOutput,
                crate::error::DescribeConfigurationRevisionError,
                crate::input::DescribeConfigurationRevisionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_id(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_id(input);
            self
        }
        /// <p>The revision of the configuration.</p>
        pub fn configuration_revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_revision(input.into());
            self
        }
        /// <p>The revision of the configuration.</p>
        pub fn set_configuration_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_revision(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUser`.
    ///
    /// <p>Returns information about an ActiveMQ user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_input::Builder,
    }
    impl<C, M, R> DescribeUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserInputOperationOutputAlias,
                crate::output::DescribeUserOutput,
                crate::error::DescribeUserError,
                crate::input::DescribeUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_id(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_id(input);
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBrokers`.
    ///
    /// <p>Returns a list of all brokers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBrokers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_brokers_input::Builder,
    }
    impl<C, M, R> ListBrokers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBrokers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBrokersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBrokersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBrokersInputOperationOutputAlias,
                crate::output::ListBrokersOutput,
                crate::error::ListBrokersError,
                crate::input::ListBrokersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBrokersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBrokersPaginator<C, M, R> {
            crate::paginator::ListBrokersPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConfigurationRevisions`.
    ///
    /// <p>Returns a list of all revisions for the specified configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListConfigurationRevisions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_configuration_revisions_input::Builder,
    }
    impl<C, M, R> ListConfigurationRevisions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConfigurationRevisions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConfigurationRevisionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConfigurationRevisionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConfigurationRevisionsInputOperationOutputAlias,
                crate::output::ListConfigurationRevisionsOutput,
                crate::error::ListConfigurationRevisionsError,
                crate::input::ListConfigurationRevisionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_id(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_id(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConfigurations`.
    ///
    /// <p>Returns a list of all configurations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_configurations_input::Builder,
    }
    impl<C, M, R> ListConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConfigurationsInputOperationOutputAlias,
                crate::output::ListConfigurationsOutput,
                crate::error::ListConfigurationsError,
                crate::input::ListConfigurationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTags`.
    ///
    /// <p>Lists tags for a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_input::Builder,
    }
    impl<C, M, R> ListTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsInputOperationOutputAlias,
                crate::output::ListTagsOutput,
                crate::error::ListTagsError,
                crate::input::ListTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUsers`.
    ///
    /// <p>Returns a list of all ActiveMQ users.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_users_input::Builder,
    }
    impl<C, M, R> ListUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUsersInputOperationOutputAlias,
                crate::output::ListUsersOutput,
                crate::error::ListUsersError,
                crate::input::ListUsersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_id(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_id(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RebootBroker`.
    ///
    /// <p>Reboots a broker. Note: This API is asynchronous.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RebootBroker<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reboot_broker_input::Builder,
    }
    impl<C, M, R> RebootBroker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RebootBroker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RebootBrokerOutput,
            aws_smithy_http::result::SdkError<crate::error::RebootBrokerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RebootBrokerInputOperationOutputAlias,
                crate::output::RebootBrokerOutput,
                crate::error::RebootBrokerError,
                crate::input::RebootBrokerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_id(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBroker`.
    ///
    /// <p>Adds a pending configuration change to a broker.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBroker<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_broker_input::Builder,
    }
    impl<C, M, R> UpdateBroker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBroker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBrokerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBrokerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBrokerInputOperationOutputAlias,
                crate::output::UpdateBrokerOutput,
                crate::error::UpdateBrokerError,
                crate::input::UpdateBrokerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
        pub fn authentication_strategy(
            mut self,
            input: crate::model::AuthenticationStrategy,
        ) -> Self {
            self.inner = self.inner.authentication_strategy(input);
            self
        }
        /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
        pub fn set_authentication_strategy(
            mut self,
            input: std::option::Option<crate::model::AuthenticationStrategy>,
        ) -> Self {
            self.inner = self.inner.set_authentication_strategy(input);
            self
        }
        /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(input);
            self
        }
        /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_id(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_id(input);
            self
        }
        /// <p>A list of information about the configuration.</p>
        pub fn configuration(mut self, input: crate::model::ConfigurationId) -> Self {
            self.inner = self.inner.configuration(input);
            self
        }
        /// <p>A list of information about the configuration.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ConfigurationId>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>The broker engine version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The broker engine version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types</a>.</p>
        pub fn host_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.host_instance_type(input.into());
            self
        }
        /// <p>The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types</a>.</p>
        pub fn set_host_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_host_instance_type(input);
            self
        }
        /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn ldap_server_metadata(
            mut self,
            input: crate::model::LdapServerMetadataInput,
        ) -> Self {
            self.inner = self.inner.ldap_server_metadata(input);
            self
        }
        /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn set_ldap_server_metadata(
            mut self,
            input: std::option::Option<crate::model::LdapServerMetadataInput>,
        ) -> Self {
            self.inner = self.inner.set_ldap_server_metadata(input);
            self
        }
        /// <p>Enables Amazon CloudWatch logging for brokers.</p>
        pub fn logs(mut self, input: crate::model::Logs) -> Self {
            self.inner = self.inner.logs(input);
            self
        }
        /// <p>Enables Amazon CloudWatch logging for brokers.</p>
        pub fn set_logs(mut self, input: std::option::Option<crate::model::Logs>) -> Self {
            self.inner = self.inner.set_logs(input);
            self
        }
        /// <p>The parameters that determine the WeeklyStartTime.</p>
        pub fn maintenance_window_start_time(
            mut self,
            input: crate::model::WeeklyStartTime,
        ) -> Self {
            self.inner = self.inner.maintenance_window_start_time(input);
            self
        }
        /// <p>The parameters that determine the WeeklyStartTime.</p>
        pub fn set_maintenance_window_start_time(
            mut self,
            input: std::option::Option<crate::model::WeeklyStartTime>,
        ) -> Self {
            self.inner = self.inner.set_maintenance_window_start_time(input);
            self
        }
        /// Appends an item to `SecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_groups(input.into());
            self
        }
        /// <p>The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_groups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConfiguration`.
    ///
    /// <p>Updates the specified configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_configuration_input::Builder,
    }
    impl<C, M, R> UpdateConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConfigurationInputOperationOutputAlias,
                crate::output::UpdateConfigurationOutput,
                crate::error::UpdateConfigurationError,
                crate::input::UpdateConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_id(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_id(input);
            self
        }
        /// <p>Required. The base64-encoded XML configuration.</p>
        pub fn data(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data(input.into());
            self
        }
        /// <p>Required. The base64-encoded XML configuration.</p>
        pub fn set_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data(input);
            self
        }
        /// <p>The description of the configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUser`.
    ///
    /// <p>Updates the information for an ActiveMQ user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_input::Builder,
    }
    impl<C, M, R> UpdateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserInputOperationOutputAlias,
                crate::output::UpdateUserOutput,
                crate::error::UpdateUserError,
                crate::input::UpdateUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_id(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_id(input);
            self
        }
        /// <p>Enables access to the the ActiveMQ Web Console for the ActiveMQ user.</p>
        pub fn console_access(mut self, input: bool) -> Self {
            self.inner = self.inner.console_access(input);
            self
        }
        /// <p>Enables access to the the ActiveMQ Web Console for the ActiveMQ user.</p>
        pub fn set_console_access(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_console_access(input);
            self
        }
        /// Appends an item to `Groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.groups(input.into());
            self
        }
        /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_groups(input);
            self
        }
        /// <p>The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
