// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserOutput {}
impl std::fmt::Debug for UpdateUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserOutput");
        formatter.finish()
    }
}
/// See [`UpdateUserOutput`](crate::output::UpdateUserOutput)
pub mod update_user_output {
    /// A builder for [`UpdateUserOutput`](crate::output::UpdateUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateUserOutput`](crate::output::UpdateUserOutput)
        pub fn build(self) -> crate::output::UpdateUserOutput {
            crate::output::UpdateUserOutput {}
        }
    }
}
impl UpdateUserOutput {
    /// Creates a new builder-style object to manufacture [`UpdateUserOutput`](crate::output::UpdateUserOutput)
    pub fn builder() -> crate::output::update_user_output::Builder {
        crate::output::update_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConfigurationOutput {
    /// <p>Required. The Amazon Resource Name (ARN) of the configuration.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Required. The date and time of the configuration.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The latest revision of the configuration.</p>
    pub latest_revision: std::option::Option<crate::model::ConfigurationRevision>,
    /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The list of the first 20 warnings about the configuration XML elements or attributes that were sanitized.</p>
    pub warnings: std::option::Option<std::vec::Vec<crate::model::SanitizationWarning>>,
}
impl UpdateConfigurationOutput {
    /// <p>Required. The Amazon Resource Name (ARN) of the configuration.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Required. The date and time of the configuration.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The latest revision of the configuration.</p>
    pub fn latest_revision(&self) -> std::option::Option<&crate::model::ConfigurationRevision> {
        self.latest_revision.as_ref()
    }
    /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The list of the first 20 warnings about the configuration XML elements or attributes that were sanitized.</p>
    pub fn warnings(&self) -> std::option::Option<&[crate::model::SanitizationWarning]> {
        self.warnings.as_deref()
    }
}
impl std::fmt::Debug for UpdateConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConfigurationOutput");
        formatter.field("arn", &self.arn);
        formatter.field("created", &self.created);
        formatter.field("id", &self.id);
        formatter.field("latest_revision", &self.latest_revision);
        formatter.field("name", &self.name);
        formatter.field("warnings", &self.warnings);
        formatter.finish()
    }
}
/// See [`UpdateConfigurationOutput`](crate::output::UpdateConfigurationOutput)
pub mod update_configuration_output {
    /// A builder for [`UpdateConfigurationOutput`](crate::output::UpdateConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) latest_revision: std::option::Option<crate::model::ConfigurationRevision>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<crate::model::SanitizationWarning>>,
    }
    impl Builder {
        /// <p>Required. The Amazon Resource Name (ARN) of the configuration.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Required. The Amazon Resource Name (ARN) of the configuration.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Required. The date and time of the configuration.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>Required. The date and time of the configuration.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The latest revision of the configuration.</p>
        pub fn latest_revision(mut self, input: crate::model::ConfigurationRevision) -> Self {
            self.latest_revision = Some(input);
            self
        }
        /// <p>The latest revision of the configuration.</p>
        pub fn set_latest_revision(
            mut self,
            input: std::option::Option<crate::model::ConfigurationRevision>,
        ) -> Self {
            self.latest_revision = input;
            self
        }
        /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>The list of the first 20 warnings about the configuration XML elements or attributes that were sanitized.</p>
        pub fn warnings(mut self, input: impl Into<crate::model::SanitizationWarning>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>The list of the first 20 warnings about the configuration XML elements or attributes that were sanitized.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SanitizationWarning>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConfigurationOutput`](crate::output::UpdateConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateConfigurationOutput {
            crate::output::UpdateConfigurationOutput {
                arn: self.arn,
                created: self.created,
                id: self.id,
                latest_revision: self.latest_revision,
                name: self.name,
                warnings: self.warnings,
            }
        }
    }
}
impl UpdateConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationOutput`](crate::output::UpdateConfigurationOutput)
    pub fn builder() -> crate::output::update_configuration_output::Builder {
        crate::output::update_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBrokerOutput {
    /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
    pub authentication_strategy: std::option::Option<crate::model::AuthenticationStrategy>,
    /// <p>The new boolean value that specifies whether broker engines automatically upgrade to new minor versions as new versions are released and supported by Amazon MQ.</p>
    pub auto_minor_version_upgrade: bool,
    /// <p>Required. The unique ID that Amazon MQ generates for the broker.</p>
    pub broker_id: std::option::Option<std::string::String>,
    /// <p>The ID of the updated configuration.</p>
    pub configuration: std::option::Option<crate::model::ConfigurationId>,
    /// <p>The broker engine version to upgrade to. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types</a>.</p>
    pub host_instance_type: std::option::Option<std::string::String>,
    /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
    pub ldap_server_metadata: std::option::Option<crate::model::LdapServerMetadataOutput>,
    /// <p>The list of information about logs to be enabled for the specified broker.</p>
    pub logs: std::option::Option<crate::model::Logs>,
    /// <p>The parameters that determine the WeeklyStartTime.</p>
    pub maintenance_window_start_time: std::option::Option<crate::model::WeeklyStartTime>,
    /// <p>The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateBrokerOutput {
    /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
    pub fn authentication_strategy(
        &self,
    ) -> std::option::Option<&crate::model::AuthenticationStrategy> {
        self.authentication_strategy.as_ref()
    }
    /// <p>The new boolean value that specifies whether broker engines automatically upgrade to new minor versions as new versions are released and supported by Amazon MQ.</p>
    pub fn auto_minor_version_upgrade(&self) -> bool {
        self.auto_minor_version_upgrade
    }
    /// <p>Required. The unique ID that Amazon MQ generates for the broker.</p>
    pub fn broker_id(&self) -> std::option::Option<&str> {
        self.broker_id.as_deref()
    }
    /// <p>The ID of the updated configuration.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::ConfigurationId> {
        self.configuration.as_ref()
    }
    /// <p>The broker engine version to upgrade to. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types</a>.</p>
    pub fn host_instance_type(&self) -> std::option::Option<&str> {
        self.host_instance_type.as_deref()
    }
    /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
    pub fn ldap_server_metadata(
        &self,
    ) -> std::option::Option<&crate::model::LdapServerMetadataOutput> {
        self.ldap_server_metadata.as_ref()
    }
    /// <p>The list of information about logs to be enabled for the specified broker.</p>
    pub fn logs(&self) -> std::option::Option<&crate::model::Logs> {
        self.logs.as_ref()
    }
    /// <p>The parameters that determine the WeeklyStartTime.</p>
    pub fn maintenance_window_start_time(
        &self,
    ) -> std::option::Option<&crate::model::WeeklyStartTime> {
        self.maintenance_window_start_time.as_ref()
    }
    /// <p>The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
}
impl std::fmt::Debug for UpdateBrokerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBrokerOutput");
        formatter.field("authentication_strategy", &self.authentication_strategy);
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.field("broker_id", &self.broker_id);
        formatter.field("configuration", &self.configuration);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("host_instance_type", &self.host_instance_type);
        formatter.field("ldap_server_metadata", &self.ldap_server_metadata);
        formatter.field("logs", &self.logs);
        formatter.field(
            "maintenance_window_start_time",
            &self.maintenance_window_start_time,
        );
        formatter.field("security_groups", &self.security_groups);
        formatter.finish()
    }
}
/// See [`UpdateBrokerOutput`](crate::output::UpdateBrokerOutput)
pub mod update_broker_output {
    /// A builder for [`UpdateBrokerOutput`](crate::output::UpdateBrokerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_strategy:
            std::option::Option<crate::model::AuthenticationStrategy>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) broker_id: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::ConfigurationId>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) host_instance_type: std::option::Option<std::string::String>,
        pub(crate) ldap_server_metadata:
            std::option::Option<crate::model::LdapServerMetadataOutput>,
        pub(crate) logs: std::option::Option<crate::model::Logs>,
        pub(crate) maintenance_window_start_time:
            std::option::Option<crate::model::WeeklyStartTime>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
        pub fn authentication_strategy(
            mut self,
            input: crate::model::AuthenticationStrategy,
        ) -> Self {
            self.authentication_strategy = Some(input);
            self
        }
        /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
        pub fn set_authentication_strategy(
            mut self,
            input: std::option::Option<crate::model::AuthenticationStrategy>,
        ) -> Self {
            self.authentication_strategy = input;
            self
        }
        /// <p>The new boolean value that specifies whether broker engines automatically upgrade to new minor versions as new versions are released and supported by Amazon MQ.</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>The new boolean value that specifies whether broker engines automatically upgrade to new minor versions as new versions are released and supported by Amazon MQ.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>Required. The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_id = Some(input.into());
            self
        }
        /// <p>Required. The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_id = input;
            self
        }
        /// <p>The ID of the updated configuration.</p>
        pub fn configuration(mut self, input: crate::model::ConfigurationId) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The ID of the updated configuration.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ConfigurationId>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The broker engine version to upgrade to. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The broker engine version to upgrade to. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types</a>.</p>
        pub fn host_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_instance_type = Some(input.into());
            self
        }
        /// <p>The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types</a>.</p>
        pub fn set_host_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.host_instance_type = input;
            self
        }
        /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn ldap_server_metadata(
            mut self,
            input: crate::model::LdapServerMetadataOutput,
        ) -> Self {
            self.ldap_server_metadata = Some(input);
            self
        }
        /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn set_ldap_server_metadata(
            mut self,
            input: std::option::Option<crate::model::LdapServerMetadataOutput>,
        ) -> Self {
            self.ldap_server_metadata = input;
            self
        }
        /// <p>The list of information about logs to be enabled for the specified broker.</p>
        pub fn logs(mut self, input: crate::model::Logs) -> Self {
            self.logs = Some(input);
            self
        }
        /// <p>The list of information about logs to be enabled for the specified broker.</p>
        pub fn set_logs(mut self, input: std::option::Option<crate::model::Logs>) -> Self {
            self.logs = input;
            self
        }
        /// <p>The parameters that determine the WeeklyStartTime.</p>
        pub fn maintenance_window_start_time(
            mut self,
            input: crate::model::WeeklyStartTime,
        ) -> Self {
            self.maintenance_window_start_time = Some(input);
            self
        }
        /// <p>The parameters that determine the WeeklyStartTime.</p>
        pub fn set_maintenance_window_start_time(
            mut self,
            input: std::option::Option<crate::model::WeeklyStartTime>,
        ) -> Self {
            self.maintenance_window_start_time = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBrokerOutput`](crate::output::UpdateBrokerOutput)
        pub fn build(self) -> crate::output::UpdateBrokerOutput {
            crate::output::UpdateBrokerOutput {
                authentication_strategy: self.authentication_strategy,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade.unwrap_or_default(),
                broker_id: self.broker_id,
                configuration: self.configuration,
                engine_version: self.engine_version,
                host_instance_type: self.host_instance_type,
                ldap_server_metadata: self.ldap_server_metadata,
                logs: self.logs,
                maintenance_window_start_time: self.maintenance_window_start_time,
                security_groups: self.security_groups,
            }
        }
    }
}
impl UpdateBrokerOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBrokerOutput`](crate::output::UpdateBrokerOutput)
    pub fn builder() -> crate::output::update_broker_output::Builder {
        crate::output::update_broker_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebootBrokerOutput {}
impl std::fmt::Debug for RebootBrokerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebootBrokerOutput");
        formatter.finish()
    }
}
/// See [`RebootBrokerOutput`](crate::output::RebootBrokerOutput)
pub mod reboot_broker_output {
    /// A builder for [`RebootBrokerOutput`](crate::output::RebootBrokerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RebootBrokerOutput`](crate::output::RebootBrokerOutput)
        pub fn build(self) -> crate::output::RebootBrokerOutput {
            crate::output::RebootBrokerOutput {}
        }
    }
}
impl RebootBrokerOutput {
    /// Creates a new builder-style object to manufacture [`RebootBrokerOutput`](crate::output::RebootBrokerOutput)
    pub fn builder() -> crate::output::reboot_broker_output::Builder {
        crate::output::reboot_broker_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUsersOutput {
    /// <p>Required. The unique ID that Amazon MQ generates for the broker.</p>
    pub broker_id: std::option::Option<std::string::String>,
    /// <p>Required. The maximum number of ActiveMQ users that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub max_results: i32,
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Required. The list of all ActiveMQ usernames for the specified broker. Does not apply to RabbitMQ brokers.</p>
    pub users: std::option::Option<std::vec::Vec<crate::model::UserSummary>>,
}
impl ListUsersOutput {
    /// <p>Required. The unique ID that Amazon MQ generates for the broker.</p>
    pub fn broker_id(&self) -> std::option::Option<&str> {
        self.broker_id.as_deref()
    }
    /// <p>Required. The maximum number of ActiveMQ users that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Required. The list of all ActiveMQ usernames for the specified broker. Does not apply to RabbitMQ brokers.</p>
    pub fn users(&self) -> std::option::Option<&[crate::model::UserSummary]> {
        self.users.as_deref()
    }
}
impl std::fmt::Debug for ListUsersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUsersOutput");
        formatter.field("broker_id", &self.broker_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("users", &self.users);
        formatter.finish()
    }
}
/// See [`ListUsersOutput`](crate::output::ListUsersOutput)
pub mod list_users_output {
    /// A builder for [`ListUsersOutput`](crate::output::ListUsersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) broker_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) users: std::option::Option<std::vec::Vec<crate::model::UserSummary>>,
    }
    impl Builder {
        /// <p>Required. The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_id = Some(input.into());
            self
        }
        /// <p>Required. The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_id = input;
            self
        }
        /// <p>Required. The maximum number of ActiveMQ users that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Required. The maximum number of ActiveMQ users that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `users`.
        ///
        /// To override the contents of this collection use [`set_users`](Self::set_users).
        ///
        /// <p>Required. The list of all ActiveMQ usernames for the specified broker. Does not apply to RabbitMQ brokers.</p>
        pub fn users(mut self, input: impl Into<crate::model::UserSummary>) -> Self {
            let mut v = self.users.unwrap_or_default();
            v.push(input.into());
            self.users = Some(v);
            self
        }
        /// <p>Required. The list of all ActiveMQ usernames for the specified broker. Does not apply to RabbitMQ brokers.</p>
        pub fn set_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserSummary>>,
        ) -> Self {
            self.users = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUsersOutput`](crate::output::ListUsersOutput)
        pub fn build(self) -> crate::output::ListUsersOutput {
            crate::output::ListUsersOutput {
                broker_id: self.broker_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                users: self.users,
            }
        }
    }
}
impl ListUsersOutput {
    /// Creates a new builder-style object to manufacture [`ListUsersOutput`](crate::output::ListUsersOutput)
    pub fn builder() -> crate::output::list_users_output::Builder {
        crate::output::list_users_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsOutput {
    /// <p>The key-value pair for the resource tag.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsOutput {
    /// <p>The key-value pair for the resource tag.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsOutput`](crate::output::ListTagsOutput)
pub mod list_tags_output {
    /// A builder for [`ListTagsOutput`](crate::output::ListTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair for the resource tag.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The key-value pair for the resource tag.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsOutput`](crate::output::ListTagsOutput)
        pub fn build(self) -> crate::output::ListTagsOutput {
            crate::output::ListTagsOutput { tags: self.tags }
        }
    }
}
impl ListTagsOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsOutput`](crate::output::ListTagsOutput)
    pub fn builder() -> crate::output::list_tags_output::Builder {
        crate::output::list_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConfigurationsOutput {
    /// <p>The list of all revisions for the specified configuration.</p>
    pub configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
    /// <p>The maximum number of configurations that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub max_results: i32,
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListConfigurationsOutput {
    /// <p>The list of all revisions for the specified configuration.</p>
    pub fn configurations(&self) -> std::option::Option<&[crate::model::Configuration]> {
        self.configurations.as_deref()
    }
    /// <p>The maximum number of configurations that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConfigurationsOutput");
        formatter.field("configurations", &self.configurations);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListConfigurationsOutput`](crate::output::ListConfigurationsOutput)
pub mod list_configurations_output {
    /// A builder for [`ListConfigurationsOutput`](crate::output::ListConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `configurations`.
        ///
        /// To override the contents of this collection use [`set_configurations`](Self::set_configurations).
        ///
        /// <p>The list of all revisions for the specified configuration.</p>
        pub fn configurations(mut self, input: impl Into<crate::model::Configuration>) -> Self {
            let mut v = self.configurations.unwrap_or_default();
            v.push(input.into());
            self.configurations = Some(v);
            self
        }
        /// <p>The list of all revisions for the specified configuration.</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        ) -> Self {
            self.configurations = input;
            self
        }
        /// <p>The maximum number of configurations that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of configurations that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConfigurationsOutput`](crate::output::ListConfigurationsOutput)
        pub fn build(self) -> crate::output::ListConfigurationsOutput {
            crate::output::ListConfigurationsOutput {
                configurations: self.configurations,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            }
        }
    }
}
impl ListConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`ListConfigurationsOutput`](crate::output::ListConfigurationsOutput)
    pub fn builder() -> crate::output::list_configurations_output::Builder {
        crate::output::list_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConfigurationRevisionsOutput {
    /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
    pub configuration_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of configuration revisions that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub max_results: i32,
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The list of all revisions for the specified configuration.</p>
    pub revisions: std::option::Option<std::vec::Vec<crate::model::ConfigurationRevision>>,
}
impl ListConfigurationRevisionsOutput {
    /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
    pub fn configuration_id(&self) -> std::option::Option<&str> {
        self.configuration_id.as_deref()
    }
    /// <p>The maximum number of configuration revisions that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The list of all revisions for the specified configuration.</p>
    pub fn revisions(&self) -> std::option::Option<&[crate::model::ConfigurationRevision]> {
        self.revisions.as_deref()
    }
}
impl std::fmt::Debug for ListConfigurationRevisionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConfigurationRevisionsOutput");
        formatter.field("configuration_id", &self.configuration_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("revisions", &self.revisions);
        formatter.finish()
    }
}
/// See [`ListConfigurationRevisionsOutput`](crate::output::ListConfigurationRevisionsOutput)
pub mod list_configuration_revisions_output {
    /// A builder for [`ListConfigurationRevisionsOutput`](crate::output::ListConfigurationRevisionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) revisions:
            std::option::Option<std::vec::Vec<crate::model::ConfigurationRevision>>,
    }
    impl Builder {
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_id = Some(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_id = input;
            self
        }
        /// <p>The maximum number of configuration revisions that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of configuration revisions that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `revisions`.
        ///
        /// To override the contents of this collection use [`set_revisions`](Self::set_revisions).
        ///
        /// <p>The list of all revisions for the specified configuration.</p>
        pub fn revisions(mut self, input: impl Into<crate::model::ConfigurationRevision>) -> Self {
            let mut v = self.revisions.unwrap_or_default();
            v.push(input.into());
            self.revisions = Some(v);
            self
        }
        /// <p>The list of all revisions for the specified configuration.</p>
        pub fn set_revisions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationRevision>>,
        ) -> Self {
            self.revisions = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConfigurationRevisionsOutput`](crate::output::ListConfigurationRevisionsOutput)
        pub fn build(self) -> crate::output::ListConfigurationRevisionsOutput {
            crate::output::ListConfigurationRevisionsOutput {
                configuration_id: self.configuration_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                revisions: self.revisions,
            }
        }
    }
}
impl ListConfigurationRevisionsOutput {
    /// Creates a new builder-style object to manufacture [`ListConfigurationRevisionsOutput`](crate::output::ListConfigurationRevisionsOutput)
    pub fn builder() -> crate::output::list_configuration_revisions_output::Builder {
        crate::output::list_configuration_revisions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBrokersOutput {
    /// <p>A list of information about all brokers.</p>
    pub broker_summaries: std::option::Option<std::vec::Vec<crate::model::BrokerSummary>>,
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBrokersOutput {
    /// <p>A list of information about all brokers.</p>
    pub fn broker_summaries(&self) -> std::option::Option<&[crate::model::BrokerSummary]> {
        self.broker_summaries.as_deref()
    }
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBrokersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBrokersOutput");
        formatter.field("broker_summaries", &self.broker_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBrokersOutput`](crate::output::ListBrokersOutput)
pub mod list_brokers_output {
    /// A builder for [`ListBrokersOutput`](crate::output::ListBrokersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) broker_summaries:
            std::option::Option<std::vec::Vec<crate::model::BrokerSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `broker_summaries`.
        ///
        /// To override the contents of this collection use [`set_broker_summaries`](Self::set_broker_summaries).
        ///
        /// <p>A list of information about all brokers.</p>
        pub fn broker_summaries(mut self, input: impl Into<crate::model::BrokerSummary>) -> Self {
            let mut v = self.broker_summaries.unwrap_or_default();
            v.push(input.into());
            self.broker_summaries = Some(v);
            self
        }
        /// <p>A list of information about all brokers.</p>
        pub fn set_broker_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BrokerSummary>>,
        ) -> Self {
            self.broker_summaries = input;
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBrokersOutput`](crate::output::ListBrokersOutput)
        pub fn build(self) -> crate::output::ListBrokersOutput {
            crate::output::ListBrokersOutput {
                broker_summaries: self.broker_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBrokersOutput {
    /// Creates a new builder-style object to manufacture [`ListBrokersOutput`](crate::output::ListBrokersOutput)
    pub fn builder() -> crate::output::list_brokers_output::Builder {
        crate::output::list_brokers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUserOutput {
    /// <p>Required. The unique ID that Amazon MQ generates for the broker.</p>
    pub broker_id: std::option::Option<std::string::String>,
    /// <p>Enables access to the the ActiveMQ Web Console for the ActiveMQ user.</p>
    pub console_access: bool,
    /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The status of the changes pending for the ActiveMQ user.</p>
    pub pending: std::option::Option<crate::model::UserPendingChanges>,
    /// <p>Required. The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub username: std::option::Option<std::string::String>,
}
impl DescribeUserOutput {
    /// <p>Required. The unique ID that Amazon MQ generates for the broker.</p>
    pub fn broker_id(&self) -> std::option::Option<&str> {
        self.broker_id.as_deref()
    }
    /// <p>Enables access to the the ActiveMQ Web Console for the ActiveMQ user.</p>
    pub fn console_access(&self) -> bool {
        self.console_access
    }
    /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub fn groups(&self) -> std::option::Option<&[std::string::String]> {
        self.groups.as_deref()
    }
    /// <p>The status of the changes pending for the ActiveMQ user.</p>
    pub fn pending(&self) -> std::option::Option<&crate::model::UserPendingChanges> {
        self.pending.as_ref()
    }
    /// <p>Required. The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
}
impl std::fmt::Debug for DescribeUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUserOutput");
        formatter.field("broker_id", &self.broker_id);
        formatter.field("console_access", &self.console_access);
        formatter.field("groups", &self.groups);
        formatter.field("pending", &self.pending);
        formatter.field("username", &self.username);
        formatter.finish()
    }
}
/// See [`DescribeUserOutput`](crate::output::DescribeUserOutput)
pub mod describe_user_output {
    /// A builder for [`DescribeUserOutput`](crate::output::DescribeUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) broker_id: std::option::Option<std::string::String>,
        pub(crate) console_access: std::option::Option<bool>,
        pub(crate) groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) pending: std::option::Option<crate::model::UserPendingChanges>,
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Required. The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_id = Some(input.into());
            self
        }
        /// <p>Required. The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_id = input;
            self
        }
        /// <p>Enables access to the the ActiveMQ Web Console for the ActiveMQ user.</p>
        pub fn console_access(mut self, input: bool) -> Self {
            self.console_access = Some(input);
            self
        }
        /// <p>Enables access to the the ActiveMQ Web Console for the ActiveMQ user.</p>
        pub fn set_console_access(mut self, input: std::option::Option<bool>) -> Self {
            self.console_access = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input.into());
            self.groups = Some(v);
            self
        }
        /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>The status of the changes pending for the ActiveMQ user.</p>
        pub fn pending(mut self, input: crate::model::UserPendingChanges) -> Self {
            self.pending = Some(input);
            self
        }
        /// <p>The status of the changes pending for the ActiveMQ user.</p>
        pub fn set_pending(
            mut self,
            input: std::option::Option<crate::model::UserPendingChanges>,
        ) -> Self {
            self.pending = input;
            self
        }
        /// <p>Required. The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>Required. The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserOutput`](crate::output::DescribeUserOutput)
        pub fn build(self) -> crate::output::DescribeUserOutput {
            crate::output::DescribeUserOutput {
                broker_id: self.broker_id,
                console_access: self.console_access.unwrap_or_default(),
                groups: self.groups,
                pending: self.pending,
                username: self.username,
            }
        }
    }
}
impl DescribeUserOutput {
    /// Creates a new builder-style object to manufacture [`DescribeUserOutput`](crate::output::DescribeUserOutput)
    pub fn builder() -> crate::output::describe_user_output::Builder {
        crate::output::describe_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConfigurationRevisionOutput {
    /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
    pub configuration_id: std::option::Option<std::string::String>,
    /// <p>Required. The date and time of the configuration.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Required. The base64-encoded XML configuration.</p>
    pub data: std::option::Option<std::string::String>,
    /// <p>The description of the configuration.</p>
    pub description: std::option::Option<std::string::String>,
}
impl DescribeConfigurationRevisionOutput {
    /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
    pub fn configuration_id(&self) -> std::option::Option<&str> {
        self.configuration_id.as_deref()
    }
    /// <p>Required. The date and time of the configuration.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>Required. The base64-encoded XML configuration.</p>
    pub fn data(&self) -> std::option::Option<&str> {
        self.data.as_deref()
    }
    /// <p>The description of the configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for DescribeConfigurationRevisionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConfigurationRevisionOutput");
        formatter.field("configuration_id", &self.configuration_id);
        formatter.field("created", &self.created);
        formatter.field("data", &self.data);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`DescribeConfigurationRevisionOutput`](crate::output::DescribeConfigurationRevisionOutput)
pub mod describe_configuration_revision_output {
    /// A builder for [`DescribeConfigurationRevisionOutput`](crate::output::DescribeConfigurationRevisionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_id: std::option::Option<std::string::String>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) data: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_id = Some(input.into());
            self
        }
        /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_id = input;
            self
        }
        /// <p>Required. The date and time of the configuration.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>Required. The date and time of the configuration.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>Required. The base64-encoded XML configuration.</p>
        pub fn data(mut self, input: impl Into<std::string::String>) -> Self {
            self.data = Some(input.into());
            self
        }
        /// <p>Required. The base64-encoded XML configuration.</p>
        pub fn set_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data = input;
            self
        }
        /// <p>The description of the configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConfigurationRevisionOutput`](crate::output::DescribeConfigurationRevisionOutput)
        pub fn build(self) -> crate::output::DescribeConfigurationRevisionOutput {
            crate::output::DescribeConfigurationRevisionOutput {
                configuration_id: self.configuration_id,
                created: self.created,
                data: self.data,
                description: self.description,
            }
        }
    }
}
impl DescribeConfigurationRevisionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationRevisionOutput`](crate::output::DescribeConfigurationRevisionOutput)
    pub fn builder() -> crate::output::describe_configuration_revision_output::Builder {
        crate::output::describe_configuration_revision_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConfigurationOutput {
    /// <p>Required. The ARN of the configuration.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
    pub authentication_strategy: std::option::Option<crate::model::AuthenticationStrategy>,
    /// <p>Required. The date and time of the configuration revision.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Required. The description of the configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
    pub engine_type: std::option::Option<crate::model::EngineType>,
    /// <p>Required. The broker engine's version. For a list of supported engine versions, see, <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Required. The latest revision of the configuration.</p>
    pub latest_revision: std::option::Option<crate::model::ConfigurationRevision>,
    /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The list of all tags associated with this configuration.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribeConfigurationOutput {
    /// <p>Required. The ARN of the configuration.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
    pub fn authentication_strategy(
        &self,
    ) -> std::option::Option<&crate::model::AuthenticationStrategy> {
        self.authentication_strategy.as_ref()
    }
    /// <p>Required. The date and time of the configuration revision.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>Required. The description of the configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
    pub fn engine_type(&self) -> std::option::Option<&crate::model::EngineType> {
        self.engine_type.as_ref()
    }
    /// <p>Required. The broker engine's version. For a list of supported engine versions, see, <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Required. The latest revision of the configuration.</p>
    pub fn latest_revision(&self) -> std::option::Option<&crate::model::ConfigurationRevision> {
        self.latest_revision.as_ref()
    }
    /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The list of all tags associated with this configuration.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DescribeConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConfigurationOutput");
        formatter.field("arn", &self.arn);
        formatter.field("authentication_strategy", &self.authentication_strategy);
        formatter.field("created", &self.created);
        formatter.field("description", &self.description);
        formatter.field("engine_type", &self.engine_type);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("id", &self.id);
        formatter.field("latest_revision", &self.latest_revision);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeConfigurationOutput`](crate::output::DescribeConfigurationOutput)
pub mod describe_configuration_output {
    /// A builder for [`DescribeConfigurationOutput`](crate::output::DescribeConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) authentication_strategy:
            std::option::Option<crate::model::AuthenticationStrategy>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) engine_type: std::option::Option<crate::model::EngineType>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) latest_revision: std::option::Option<crate::model::ConfigurationRevision>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Required. The ARN of the configuration.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Required. The ARN of the configuration.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
        pub fn authentication_strategy(
            mut self,
            input: crate::model::AuthenticationStrategy,
        ) -> Self {
            self.authentication_strategy = Some(input);
            self
        }
        /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
        pub fn set_authentication_strategy(
            mut self,
            input: std::option::Option<crate::model::AuthenticationStrategy>,
        ) -> Self {
            self.authentication_strategy = input;
            self
        }
        /// <p>Required. The date and time of the configuration revision.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>Required. The date and time of the configuration revision.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>Required. The description of the configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Required. The description of the configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
        pub fn engine_type(mut self, input: crate::model::EngineType) -> Self {
            self.engine_type = Some(input);
            self
        }
        /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
        pub fn set_engine_type(
            mut self,
            input: std::option::Option<crate::model::EngineType>,
        ) -> Self {
            self.engine_type = input;
            self
        }
        /// <p>Required. The broker engine's version. For a list of supported engine versions, see, <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>Required. The broker engine's version. For a list of supported engine versions, see, <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Required. The latest revision of the configuration.</p>
        pub fn latest_revision(mut self, input: crate::model::ConfigurationRevision) -> Self {
            self.latest_revision = Some(input);
            self
        }
        /// <p>Required. The latest revision of the configuration.</p>
        pub fn set_latest_revision(
            mut self,
            input: std::option::Option<crate::model::ConfigurationRevision>,
        ) -> Self {
            self.latest_revision = input;
            self
        }
        /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of all tags associated with this configuration.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of all tags associated with this configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConfigurationOutput`](crate::output::DescribeConfigurationOutput)
        pub fn build(self) -> crate::output::DescribeConfigurationOutput {
            crate::output::DescribeConfigurationOutput {
                arn: self.arn,
                authentication_strategy: self.authentication_strategy,
                created: self.created,
                description: self.description,
                engine_type: self.engine_type,
                engine_version: self.engine_version,
                id: self.id,
                latest_revision: self.latest_revision,
                name: self.name,
                tags: self.tags,
            }
        }
    }
}
impl DescribeConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationOutput`](crate::output::DescribeConfigurationOutput)
    pub fn builder() -> crate::output::describe_configuration_output::Builder {
        crate::output::describe_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBrokerInstanceOptionsOutput {
    /// <p>List of available broker instance options.</p>
    pub broker_instance_options:
        std::option::Option<std::vec::Vec<crate::model::BrokerInstanceOption>>,
    /// <p>Required. The maximum number of instance options that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub max_results: i32,
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeBrokerInstanceOptionsOutput {
    /// <p>List of available broker instance options.</p>
    pub fn broker_instance_options(
        &self,
    ) -> std::option::Option<&[crate::model::BrokerInstanceOption]> {
        self.broker_instance_options.as_deref()
    }
    /// <p>Required. The maximum number of instance options that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeBrokerInstanceOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBrokerInstanceOptionsOutput");
        formatter.field("broker_instance_options", &self.broker_instance_options);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeBrokerInstanceOptionsOutput`](crate::output::DescribeBrokerInstanceOptionsOutput)
pub mod describe_broker_instance_options_output {
    /// A builder for [`DescribeBrokerInstanceOptionsOutput`](crate::output::DescribeBrokerInstanceOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) broker_instance_options:
            std::option::Option<std::vec::Vec<crate::model::BrokerInstanceOption>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `broker_instance_options`.
        ///
        /// To override the contents of this collection use [`set_broker_instance_options`](Self::set_broker_instance_options).
        ///
        /// <p>List of available broker instance options.</p>
        pub fn broker_instance_options(
            mut self,
            input: impl Into<crate::model::BrokerInstanceOption>,
        ) -> Self {
            let mut v = self.broker_instance_options.unwrap_or_default();
            v.push(input.into());
            self.broker_instance_options = Some(v);
            self
        }
        /// <p>List of available broker instance options.</p>
        pub fn set_broker_instance_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BrokerInstanceOption>>,
        ) -> Self {
            self.broker_instance_options = input;
            self
        }
        /// <p>Required. The maximum number of instance options that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Required. The maximum number of instance options that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBrokerInstanceOptionsOutput`](crate::output::DescribeBrokerInstanceOptionsOutput)
        pub fn build(self) -> crate::output::DescribeBrokerInstanceOptionsOutput {
            crate::output::DescribeBrokerInstanceOptionsOutput {
                broker_instance_options: self.broker_instance_options,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeBrokerInstanceOptionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBrokerInstanceOptionsOutput`](crate::output::DescribeBrokerInstanceOptionsOutput)
    pub fn builder() -> crate::output::describe_broker_instance_options_output::Builder {
        crate::output::describe_broker_instance_options_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBrokerEngineTypesOutput {
    /// <p>List of available engine types and versions.</p>
    pub broker_engine_types: std::option::Option<std::vec::Vec<crate::model::BrokerEngineType>>,
    /// <p>Required. The maximum number of engine types that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub max_results: i32,
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeBrokerEngineTypesOutput {
    /// <p>List of available engine types and versions.</p>
    pub fn broker_engine_types(&self) -> std::option::Option<&[crate::model::BrokerEngineType]> {
        self.broker_engine_types.as_deref()
    }
    /// <p>Required. The maximum number of engine types that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeBrokerEngineTypesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBrokerEngineTypesOutput");
        formatter.field("broker_engine_types", &self.broker_engine_types);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeBrokerEngineTypesOutput`](crate::output::DescribeBrokerEngineTypesOutput)
pub mod describe_broker_engine_types_output {
    /// A builder for [`DescribeBrokerEngineTypesOutput`](crate::output::DescribeBrokerEngineTypesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) broker_engine_types:
            std::option::Option<std::vec::Vec<crate::model::BrokerEngineType>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `broker_engine_types`.
        ///
        /// To override the contents of this collection use [`set_broker_engine_types`](Self::set_broker_engine_types).
        ///
        /// <p>List of available engine types and versions.</p>
        pub fn broker_engine_types(
            mut self,
            input: impl Into<crate::model::BrokerEngineType>,
        ) -> Self {
            let mut v = self.broker_engine_types.unwrap_or_default();
            v.push(input.into());
            self.broker_engine_types = Some(v);
            self
        }
        /// <p>List of available engine types and versions.</p>
        pub fn set_broker_engine_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BrokerEngineType>>,
        ) -> Self {
            self.broker_engine_types = input;
            self
        }
        /// <p>Required. The maximum number of engine types that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Required. The maximum number of engine types that can be returned per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBrokerEngineTypesOutput`](crate::output::DescribeBrokerEngineTypesOutput)
        pub fn build(self) -> crate::output::DescribeBrokerEngineTypesOutput {
            crate::output::DescribeBrokerEngineTypesOutput {
                broker_engine_types: self.broker_engine_types,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeBrokerEngineTypesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBrokerEngineTypesOutput`](crate::output::DescribeBrokerEngineTypesOutput)
    pub fn builder() -> crate::output::describe_broker_engine_types_output::Builder {
        crate::output::describe_broker_engine_types_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBrokerOutput {
    /// <p>The authentication strategy used to secure the broker. The default is SIMPLE.</p>
    pub authentication_strategy: std::option::Option<crate::model::AuthenticationStrategy>,
    /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.</p>
    pub auto_minor_version_upgrade: bool,
    /// <p>The broker's Amazon Resource Name (ARN).</p>
    pub broker_arn: std::option::Option<std::string::String>,
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub broker_id: std::option::Option<std::string::String>,
    /// <p>A list of information about allocated brokers.</p>
    pub broker_instances: std::option::Option<std::vec::Vec<crate::model::BrokerInstance>>,
    /// <p>The broker's name. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.</p>
    pub broker_name: std::option::Option<std::string::String>,
    /// <p>The broker's status.</p>
    pub broker_state: std::option::Option<crate::model::BrokerState>,
    /// <p>The list of all revisions for the specified configuration.</p>
    pub configurations: std::option::Option<crate::model::Configurations>,
    /// <p>The time when the broker was created.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The broker's deployment mode.</p>
    pub deployment_mode: std::option::Option<crate::model::DeploymentMode>,
    /// <p>Encryption options for the broker. Does not apply to RabbitMQ brokers.</p>
    pub encryption_options: std::option::Option<crate::model::EncryptionOptions>,
    /// <p>The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
    pub engine_type: std::option::Option<crate::model::EngineType>,
    /// <p>The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The broker's instance type.</p>
    pub host_instance_type: std::option::Option<std::string::String>,
    /// <p>The metadata of the LDAP server used to authenticate and authorize connections to the broker.</p>
    pub ldap_server_metadata: std::option::Option<crate::model::LdapServerMetadataOutput>,
    /// <p>The list of information about logs currently enabled and pending to be deployed for the specified broker.</p>
    pub logs: std::option::Option<crate::model::LogsSummary>,
    /// <p>The parameters that determine the WeeklyStartTime.</p>
    pub maintenance_window_start_time: std::option::Option<crate::model::WeeklyStartTime>,
    /// <p>The authentication strategy that will be applied when the broker is rebooted. The default is SIMPLE.</p>
    pub pending_authentication_strategy: std::option::Option<crate::model::AuthenticationStrategy>,
    /// <p>The broker engine version to upgrade to. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    pub pending_engine_version: std::option::Option<std::string::String>,
    /// <p>The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types</a>.</p>
    pub pending_host_instance_type: std::option::Option<std::string::String>,
    /// <p>The metadata of the LDAP server that will be used to authenticate and authorize connections to the broker after it is rebooted.</p>
    pub pending_ldap_server_metadata: std::option::Option<crate::model::LdapServerMetadataOutput>,
    /// <p>The list of pending security groups to authorize connections to brokers.</p>
    pub pending_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Enables connections from applications outside of the VPC that hosts the broker's subnets.</p>
    pub publicly_accessible: bool,
    /// <p>The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The broker's storage type.</p>
    pub storage_type: std::option::Option<crate::model::BrokerStorageType>,
    /// <p>The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of all tags associated with this broker.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The list of all broker usernames for the specified broker.</p>
    pub users: std::option::Option<std::vec::Vec<crate::model::UserSummary>>,
}
impl DescribeBrokerOutput {
    /// <p>The authentication strategy used to secure the broker. The default is SIMPLE.</p>
    pub fn authentication_strategy(
        &self,
    ) -> std::option::Option<&crate::model::AuthenticationStrategy> {
        self.authentication_strategy.as_ref()
    }
    /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.</p>
    pub fn auto_minor_version_upgrade(&self) -> bool {
        self.auto_minor_version_upgrade
    }
    /// <p>The broker's Amazon Resource Name (ARN).</p>
    pub fn broker_arn(&self) -> std::option::Option<&str> {
        self.broker_arn.as_deref()
    }
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub fn broker_id(&self) -> std::option::Option<&str> {
        self.broker_id.as_deref()
    }
    /// <p>A list of information about allocated brokers.</p>
    pub fn broker_instances(&self) -> std::option::Option<&[crate::model::BrokerInstance]> {
        self.broker_instances.as_deref()
    }
    /// <p>The broker's name. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.</p>
    pub fn broker_name(&self) -> std::option::Option<&str> {
        self.broker_name.as_deref()
    }
    /// <p>The broker's status.</p>
    pub fn broker_state(&self) -> std::option::Option<&crate::model::BrokerState> {
        self.broker_state.as_ref()
    }
    /// <p>The list of all revisions for the specified configuration.</p>
    pub fn configurations(&self) -> std::option::Option<&crate::model::Configurations> {
        self.configurations.as_ref()
    }
    /// <p>The time when the broker was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>The broker's deployment mode.</p>
    pub fn deployment_mode(&self) -> std::option::Option<&crate::model::DeploymentMode> {
        self.deployment_mode.as_ref()
    }
    /// <p>Encryption options for the broker. Does not apply to RabbitMQ brokers.</p>
    pub fn encryption_options(&self) -> std::option::Option<&crate::model::EncryptionOptions> {
        self.encryption_options.as_ref()
    }
    /// <p>The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
    pub fn engine_type(&self) -> std::option::Option<&crate::model::EngineType> {
        self.engine_type.as_ref()
    }
    /// <p>The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The broker's instance type.</p>
    pub fn host_instance_type(&self) -> std::option::Option<&str> {
        self.host_instance_type.as_deref()
    }
    /// <p>The metadata of the LDAP server used to authenticate and authorize connections to the broker.</p>
    pub fn ldap_server_metadata(
        &self,
    ) -> std::option::Option<&crate::model::LdapServerMetadataOutput> {
        self.ldap_server_metadata.as_ref()
    }
    /// <p>The list of information about logs currently enabled and pending to be deployed for the specified broker.</p>
    pub fn logs(&self) -> std::option::Option<&crate::model::LogsSummary> {
        self.logs.as_ref()
    }
    /// <p>The parameters that determine the WeeklyStartTime.</p>
    pub fn maintenance_window_start_time(
        &self,
    ) -> std::option::Option<&crate::model::WeeklyStartTime> {
        self.maintenance_window_start_time.as_ref()
    }
    /// <p>The authentication strategy that will be applied when the broker is rebooted. The default is SIMPLE.</p>
    pub fn pending_authentication_strategy(
        &self,
    ) -> std::option::Option<&crate::model::AuthenticationStrategy> {
        self.pending_authentication_strategy.as_ref()
    }
    /// <p>The broker engine version to upgrade to. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    pub fn pending_engine_version(&self) -> std::option::Option<&str> {
        self.pending_engine_version.as_deref()
    }
    /// <p>The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types</a>.</p>
    pub fn pending_host_instance_type(&self) -> std::option::Option<&str> {
        self.pending_host_instance_type.as_deref()
    }
    /// <p>The metadata of the LDAP server that will be used to authenticate and authorize connections to the broker after it is rebooted.</p>
    pub fn pending_ldap_server_metadata(
        &self,
    ) -> std::option::Option<&crate::model::LdapServerMetadataOutput> {
        self.pending_ldap_server_metadata.as_ref()
    }
    /// <p>The list of pending security groups to authorize connections to brokers.</p>
    pub fn pending_security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.pending_security_groups.as_deref()
    }
    /// <p>Enables connections from applications outside of the VPC that hosts the broker's subnets.</p>
    pub fn publicly_accessible(&self) -> bool {
        self.publicly_accessible
    }
    /// <p>The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
    /// <p>The broker's storage type.</p>
    pub fn storage_type(&self) -> std::option::Option<&crate::model::BrokerStorageType> {
        self.storage_type.as_ref()
    }
    /// <p>The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>The list of all tags associated with this broker.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The list of all broker usernames for the specified broker.</p>
    pub fn users(&self) -> std::option::Option<&[crate::model::UserSummary]> {
        self.users.as_deref()
    }
}
impl std::fmt::Debug for DescribeBrokerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBrokerOutput");
        formatter.field("authentication_strategy", &self.authentication_strategy);
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.field("broker_arn", &self.broker_arn);
        formatter.field("broker_id", &self.broker_id);
        formatter.field("broker_instances", &self.broker_instances);
        formatter.field("broker_name", &self.broker_name);
        formatter.field("broker_state", &self.broker_state);
        formatter.field("configurations", &self.configurations);
        formatter.field("created", &self.created);
        formatter.field("deployment_mode", &self.deployment_mode);
        formatter.field("encryption_options", &self.encryption_options);
        formatter.field("engine_type", &self.engine_type);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("host_instance_type", &self.host_instance_type);
        formatter.field("ldap_server_metadata", &self.ldap_server_metadata);
        formatter.field("logs", &self.logs);
        formatter.field(
            "maintenance_window_start_time",
            &self.maintenance_window_start_time,
        );
        formatter.field(
            "pending_authentication_strategy",
            &self.pending_authentication_strategy,
        );
        formatter.field("pending_engine_version", &self.pending_engine_version);
        formatter.field(
            "pending_host_instance_type",
            &self.pending_host_instance_type,
        );
        formatter.field(
            "pending_ldap_server_metadata",
            &self.pending_ldap_server_metadata,
        );
        formatter.field("pending_security_groups", &self.pending_security_groups);
        formatter.field("publicly_accessible", &self.publicly_accessible);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("storage_type", &self.storage_type);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("tags", &self.tags);
        formatter.field("users", &self.users);
        formatter.finish()
    }
}
/// See [`DescribeBrokerOutput`](crate::output::DescribeBrokerOutput)
pub mod describe_broker_output {
    /// A builder for [`DescribeBrokerOutput`](crate::output::DescribeBrokerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_strategy:
            std::option::Option<crate::model::AuthenticationStrategy>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) broker_arn: std::option::Option<std::string::String>,
        pub(crate) broker_id: std::option::Option<std::string::String>,
        pub(crate) broker_instances:
            std::option::Option<std::vec::Vec<crate::model::BrokerInstance>>,
        pub(crate) broker_name: std::option::Option<std::string::String>,
        pub(crate) broker_state: std::option::Option<crate::model::BrokerState>,
        pub(crate) configurations: std::option::Option<crate::model::Configurations>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deployment_mode: std::option::Option<crate::model::DeploymentMode>,
        pub(crate) encryption_options: std::option::Option<crate::model::EncryptionOptions>,
        pub(crate) engine_type: std::option::Option<crate::model::EngineType>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) host_instance_type: std::option::Option<std::string::String>,
        pub(crate) ldap_server_metadata:
            std::option::Option<crate::model::LdapServerMetadataOutput>,
        pub(crate) logs: std::option::Option<crate::model::LogsSummary>,
        pub(crate) maintenance_window_start_time:
            std::option::Option<crate::model::WeeklyStartTime>,
        pub(crate) pending_authentication_strategy:
            std::option::Option<crate::model::AuthenticationStrategy>,
        pub(crate) pending_engine_version: std::option::Option<std::string::String>,
        pub(crate) pending_host_instance_type: std::option::Option<std::string::String>,
        pub(crate) pending_ldap_server_metadata:
            std::option::Option<crate::model::LdapServerMetadataOutput>,
        pub(crate) pending_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) storage_type: std::option::Option<crate::model::BrokerStorageType>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) users: std::option::Option<std::vec::Vec<crate::model::UserSummary>>,
    }
    impl Builder {
        /// <p>The authentication strategy used to secure the broker. The default is SIMPLE.</p>
        pub fn authentication_strategy(
            mut self,
            input: crate::model::AuthenticationStrategy,
        ) -> Self {
            self.authentication_strategy = Some(input);
            self
        }
        /// <p>The authentication strategy used to secure the broker. The default is SIMPLE.</p>
        pub fn set_authentication_strategy(
            mut self,
            input: std::option::Option<crate::model::AuthenticationStrategy>,
        ) -> Self {
            self.authentication_strategy = input;
            self
        }
        /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>The broker's Amazon Resource Name (ARN).</p>
        pub fn broker_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_arn = Some(input.into());
            self
        }
        /// <p>The broker's Amazon Resource Name (ARN).</p>
        pub fn set_broker_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_arn = input;
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_id = Some(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_id = input;
            self
        }
        /// Appends an item to `broker_instances`.
        ///
        /// To override the contents of this collection use [`set_broker_instances`](Self::set_broker_instances).
        ///
        /// <p>A list of information about allocated brokers.</p>
        pub fn broker_instances(mut self, input: impl Into<crate::model::BrokerInstance>) -> Self {
            let mut v = self.broker_instances.unwrap_or_default();
            v.push(input.into());
            self.broker_instances = Some(v);
            self
        }
        /// <p>A list of information about allocated brokers.</p>
        pub fn set_broker_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BrokerInstance>>,
        ) -> Self {
            self.broker_instances = input;
            self
        }
        /// <p>The broker's name. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.</p>
        pub fn broker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_name = Some(input.into());
            self
        }
        /// <p>The broker's name. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.</p>
        pub fn set_broker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_name = input;
            self
        }
        /// <p>The broker's status.</p>
        pub fn broker_state(mut self, input: crate::model::BrokerState) -> Self {
            self.broker_state = Some(input);
            self
        }
        /// <p>The broker's status.</p>
        pub fn set_broker_state(
            mut self,
            input: std::option::Option<crate::model::BrokerState>,
        ) -> Self {
            self.broker_state = input;
            self
        }
        /// <p>The list of all revisions for the specified configuration.</p>
        pub fn configurations(mut self, input: crate::model::Configurations) -> Self {
            self.configurations = Some(input);
            self
        }
        /// <p>The list of all revisions for the specified configuration.</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<crate::model::Configurations>,
        ) -> Self {
            self.configurations = input;
            self
        }
        /// <p>The time when the broker was created.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The time when the broker was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The broker's deployment mode.</p>
        pub fn deployment_mode(mut self, input: crate::model::DeploymentMode) -> Self {
            self.deployment_mode = Some(input);
            self
        }
        /// <p>The broker's deployment mode.</p>
        pub fn set_deployment_mode(
            mut self,
            input: std::option::Option<crate::model::DeploymentMode>,
        ) -> Self {
            self.deployment_mode = input;
            self
        }
        /// <p>Encryption options for the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn encryption_options(mut self, input: crate::model::EncryptionOptions) -> Self {
            self.encryption_options = Some(input);
            self
        }
        /// <p>Encryption options for the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn set_encryption_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionOptions>,
        ) -> Self {
            self.encryption_options = input;
            self
        }
        /// <p>The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
        pub fn engine_type(mut self, input: crate::model::EngineType) -> Self {
            self.engine_type = Some(input);
            self
        }
        /// <p>The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
        pub fn set_engine_type(
            mut self,
            input: std::option::Option<crate::model::EngineType>,
        ) -> Self {
            self.engine_type = input;
            self
        }
        /// <p>The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The broker's instance type.</p>
        pub fn host_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_instance_type = Some(input.into());
            self
        }
        /// <p>The broker's instance type.</p>
        pub fn set_host_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.host_instance_type = input;
            self
        }
        /// <p>The metadata of the LDAP server used to authenticate and authorize connections to the broker.</p>
        pub fn ldap_server_metadata(
            mut self,
            input: crate::model::LdapServerMetadataOutput,
        ) -> Self {
            self.ldap_server_metadata = Some(input);
            self
        }
        /// <p>The metadata of the LDAP server used to authenticate and authorize connections to the broker.</p>
        pub fn set_ldap_server_metadata(
            mut self,
            input: std::option::Option<crate::model::LdapServerMetadataOutput>,
        ) -> Self {
            self.ldap_server_metadata = input;
            self
        }
        /// <p>The list of information about logs currently enabled and pending to be deployed for the specified broker.</p>
        pub fn logs(mut self, input: crate::model::LogsSummary) -> Self {
            self.logs = Some(input);
            self
        }
        /// <p>The list of information about logs currently enabled and pending to be deployed for the specified broker.</p>
        pub fn set_logs(mut self, input: std::option::Option<crate::model::LogsSummary>) -> Self {
            self.logs = input;
            self
        }
        /// <p>The parameters that determine the WeeklyStartTime.</p>
        pub fn maintenance_window_start_time(
            mut self,
            input: crate::model::WeeklyStartTime,
        ) -> Self {
            self.maintenance_window_start_time = Some(input);
            self
        }
        /// <p>The parameters that determine the WeeklyStartTime.</p>
        pub fn set_maintenance_window_start_time(
            mut self,
            input: std::option::Option<crate::model::WeeklyStartTime>,
        ) -> Self {
            self.maintenance_window_start_time = input;
            self
        }
        /// <p>The authentication strategy that will be applied when the broker is rebooted. The default is SIMPLE.</p>
        pub fn pending_authentication_strategy(
            mut self,
            input: crate::model::AuthenticationStrategy,
        ) -> Self {
            self.pending_authentication_strategy = Some(input);
            self
        }
        /// <p>The authentication strategy that will be applied when the broker is rebooted. The default is SIMPLE.</p>
        pub fn set_pending_authentication_strategy(
            mut self,
            input: std::option::Option<crate::model::AuthenticationStrategy>,
        ) -> Self {
            self.pending_authentication_strategy = input;
            self
        }
        /// <p>The broker engine version to upgrade to. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn pending_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.pending_engine_version = Some(input.into());
            self
        }
        /// <p>The broker engine version to upgrade to. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn set_pending_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pending_engine_version = input;
            self
        }
        /// <p>The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types</a>.</p>
        pub fn pending_host_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.pending_host_instance_type = Some(input.into());
            self
        }
        /// <p>The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types</a>.</p>
        pub fn set_pending_host_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pending_host_instance_type = input;
            self
        }
        /// <p>The metadata of the LDAP server that will be used to authenticate and authorize connections to the broker after it is rebooted.</p>
        pub fn pending_ldap_server_metadata(
            mut self,
            input: crate::model::LdapServerMetadataOutput,
        ) -> Self {
            self.pending_ldap_server_metadata = Some(input);
            self
        }
        /// <p>The metadata of the LDAP server that will be used to authenticate and authorize connections to the broker after it is rebooted.</p>
        pub fn set_pending_ldap_server_metadata(
            mut self,
            input: std::option::Option<crate::model::LdapServerMetadataOutput>,
        ) -> Self {
            self.pending_ldap_server_metadata = input;
            self
        }
        /// Appends an item to `pending_security_groups`.
        ///
        /// To override the contents of this collection use [`set_pending_security_groups`](Self::set_pending_security_groups).
        ///
        /// <p>The list of pending security groups to authorize connections to brokers.</p>
        pub fn pending_security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.pending_security_groups.unwrap_or_default();
            v.push(input.into());
            self.pending_security_groups = Some(v);
            self
        }
        /// <p>The list of pending security groups to authorize connections to brokers.</p>
        pub fn set_pending_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.pending_security_groups = input;
            self
        }
        /// <p>Enables connections from applications outside of the VPC that hosts the broker's subnets.</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p>Enables connections from applications outside of the VPC that hosts the broker's subnets.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>The broker's storage type.</p>
        pub fn storage_type(mut self, input: crate::model::BrokerStorageType) -> Self {
            self.storage_type = Some(input);
            self
        }
        /// <p>The broker's storage type.</p>
        pub fn set_storage_type(
            mut self,
            input: std::option::Option<crate::model::BrokerStorageType>,
        ) -> Self {
            self.storage_type = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of all tags associated with this broker.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of all tags associated with this broker.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `users`.
        ///
        /// To override the contents of this collection use [`set_users`](Self::set_users).
        ///
        /// <p>The list of all broker usernames for the specified broker.</p>
        pub fn users(mut self, input: impl Into<crate::model::UserSummary>) -> Self {
            let mut v = self.users.unwrap_or_default();
            v.push(input.into());
            self.users = Some(v);
            self
        }
        /// <p>The list of all broker usernames for the specified broker.</p>
        pub fn set_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserSummary>>,
        ) -> Self {
            self.users = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBrokerOutput`](crate::output::DescribeBrokerOutput)
        pub fn build(self) -> crate::output::DescribeBrokerOutput {
            crate::output::DescribeBrokerOutput {
                authentication_strategy: self.authentication_strategy,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade.unwrap_or_default(),
                broker_arn: self.broker_arn,
                broker_id: self.broker_id,
                broker_instances: self.broker_instances,
                broker_name: self.broker_name,
                broker_state: self.broker_state,
                configurations: self.configurations,
                created: self.created,
                deployment_mode: self.deployment_mode,
                encryption_options: self.encryption_options,
                engine_type: self.engine_type,
                engine_version: self.engine_version,
                host_instance_type: self.host_instance_type,
                ldap_server_metadata: self.ldap_server_metadata,
                logs: self.logs,
                maintenance_window_start_time: self.maintenance_window_start_time,
                pending_authentication_strategy: self.pending_authentication_strategy,
                pending_engine_version: self.pending_engine_version,
                pending_host_instance_type: self.pending_host_instance_type,
                pending_ldap_server_metadata: self.pending_ldap_server_metadata,
                pending_security_groups: self.pending_security_groups,
                publicly_accessible: self.publicly_accessible.unwrap_or_default(),
                security_groups: self.security_groups,
                storage_type: self.storage_type,
                subnet_ids: self.subnet_ids,
                tags: self.tags,
                users: self.users,
            }
        }
    }
}
impl DescribeBrokerOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBrokerOutput`](crate::output::DescribeBrokerOutput)
    pub fn builder() -> crate::output::describe_broker_output::Builder {
        crate::output::describe_broker_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserOutput {}
impl std::fmt::Debug for DeleteUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserOutput");
        formatter.finish()
    }
}
/// See [`DeleteUserOutput`](crate::output::DeleteUserOutput)
pub mod delete_user_output {
    /// A builder for [`DeleteUserOutput`](crate::output::DeleteUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteUserOutput`](crate::output::DeleteUserOutput)
        pub fn build(self) -> crate::output::DeleteUserOutput {
            crate::output::DeleteUserOutput {}
        }
    }
}
impl DeleteUserOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUserOutput`](crate::output::DeleteUserOutput)
    pub fn builder() -> crate::output::delete_user_output::Builder {
        crate::output::delete_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTagsOutput {}
impl std::fmt::Debug for DeleteTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTagsOutput");
        formatter.finish()
    }
}
/// See [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
pub mod delete_tags_output {
    /// A builder for [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
        pub fn build(self) -> crate::output::DeleteTagsOutput {
            crate::output::DeleteTagsOutput {}
        }
    }
}
impl DeleteTagsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
    pub fn builder() -> crate::output::delete_tags_output::Builder {
        crate::output::delete_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBrokerOutput {
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub broker_id: std::option::Option<std::string::String>,
}
impl DeleteBrokerOutput {
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub fn broker_id(&self) -> std::option::Option<&str> {
        self.broker_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteBrokerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBrokerOutput");
        formatter.field("broker_id", &self.broker_id);
        formatter.finish()
    }
}
/// See [`DeleteBrokerOutput`](crate::output::DeleteBrokerOutput)
pub mod delete_broker_output {
    /// A builder for [`DeleteBrokerOutput`](crate::output::DeleteBrokerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) broker_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_id = Some(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBrokerOutput`](crate::output::DeleteBrokerOutput)
        pub fn build(self) -> crate::output::DeleteBrokerOutput {
            crate::output::DeleteBrokerOutput {
                broker_id: self.broker_id,
            }
        }
    }
}
impl DeleteBrokerOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBrokerOutput`](crate::output::DeleteBrokerOutput)
    pub fn builder() -> crate::output::delete_broker_output::Builder {
        crate::output::delete_broker_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserOutput {}
impl std::fmt::Debug for CreateUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserOutput");
        formatter.finish()
    }
}
/// See [`CreateUserOutput`](crate::output::CreateUserOutput)
pub mod create_user_output {
    /// A builder for [`CreateUserOutput`](crate::output::CreateUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateUserOutput`](crate::output::CreateUserOutput)
        pub fn build(self) -> crate::output::CreateUserOutput {
            crate::output::CreateUserOutput {}
        }
    }
}
impl CreateUserOutput {
    /// Creates a new builder-style object to manufacture [`CreateUserOutput`](crate::output::CreateUserOutput)
    pub fn builder() -> crate::output::create_user_output::Builder {
        crate::output::create_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTagsOutput {}
impl std::fmt::Debug for CreateTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTagsOutput");
        formatter.finish()
    }
}
/// See [`CreateTagsOutput`](crate::output::CreateTagsOutput)
pub mod create_tags_output {
    /// A builder for [`CreateTagsOutput`](crate::output::CreateTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateTagsOutput`](crate::output::CreateTagsOutput)
        pub fn build(self) -> crate::output::CreateTagsOutput {
            crate::output::CreateTagsOutput {}
        }
    }
}
impl CreateTagsOutput {
    /// Creates a new builder-style object to manufacture [`CreateTagsOutput`](crate::output::CreateTagsOutput)
    pub fn builder() -> crate::output::create_tags_output::Builder {
        crate::output::create_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigurationOutput {
    /// <p>Required. The Amazon Resource Name (ARN) of the configuration.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
    pub authentication_strategy: std::option::Option<crate::model::AuthenticationStrategy>,
    /// <p>Required. The date and time of the configuration.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The latest revision of the configuration.</p>
    pub latest_revision: std::option::Option<crate::model::ConfigurationRevision>,
    /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
    pub name: std::option::Option<std::string::String>,
}
impl CreateConfigurationOutput {
    /// <p>Required. The Amazon Resource Name (ARN) of the configuration.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
    pub fn authentication_strategy(
        &self,
    ) -> std::option::Option<&crate::model::AuthenticationStrategy> {
        self.authentication_strategy.as_ref()
    }
    /// <p>Required. The date and time of the configuration.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The latest revision of the configuration.</p>
    pub fn latest_revision(&self) -> std::option::Option<&crate::model::ConfigurationRevision> {
        self.latest_revision.as_ref()
    }
    /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for CreateConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigurationOutput");
        formatter.field("arn", &self.arn);
        formatter.field("authentication_strategy", &self.authentication_strategy);
        formatter.field("created", &self.created);
        formatter.field("id", &self.id);
        formatter.field("latest_revision", &self.latest_revision);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`CreateConfigurationOutput`](crate::output::CreateConfigurationOutput)
pub mod create_configuration_output {
    /// A builder for [`CreateConfigurationOutput`](crate::output::CreateConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) authentication_strategy:
            std::option::Option<crate::model::AuthenticationStrategy>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) latest_revision: std::option::Option<crate::model::ConfigurationRevision>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Required. The Amazon Resource Name (ARN) of the configuration.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Required. The Amazon Resource Name (ARN) of the configuration.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
        pub fn authentication_strategy(
            mut self,
            input: crate::model::AuthenticationStrategy,
        ) -> Self {
            self.authentication_strategy = Some(input);
            self
        }
        /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
        pub fn set_authentication_strategy(
            mut self,
            input: std::option::Option<crate::model::AuthenticationStrategy>,
        ) -> Self {
            self.authentication_strategy = input;
            self
        }
        /// <p>Required. The date and time of the configuration.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>Required. The date and time of the configuration.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The latest revision of the configuration.</p>
        pub fn latest_revision(mut self, input: crate::model::ConfigurationRevision) -> Self {
            self.latest_revision = Some(input);
            self
        }
        /// <p>The latest revision of the configuration.</p>
        pub fn set_latest_revision(
            mut self,
            input: std::option::Option<crate::model::ConfigurationRevision>,
        ) -> Self {
            self.latest_revision = input;
            self
        }
        /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConfigurationOutput`](crate::output::CreateConfigurationOutput)
        pub fn build(self) -> crate::output::CreateConfigurationOutput {
            crate::output::CreateConfigurationOutput {
                arn: self.arn,
                authentication_strategy: self.authentication_strategy,
                created: self.created,
                id: self.id,
                latest_revision: self.latest_revision,
                name: self.name,
            }
        }
    }
}
impl CreateConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`CreateConfigurationOutput`](crate::output::CreateConfigurationOutput)
    pub fn builder() -> crate::output::create_configuration_output::Builder {
        crate::output::create_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBrokerOutput {
    /// <p>The broker's Amazon Resource Name (ARN).</p>
    pub broker_arn: std::option::Option<std::string::String>,
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub broker_id: std::option::Option<std::string::String>,
}
impl CreateBrokerOutput {
    /// <p>The broker's Amazon Resource Name (ARN).</p>
    pub fn broker_arn(&self) -> std::option::Option<&str> {
        self.broker_arn.as_deref()
    }
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub fn broker_id(&self) -> std::option::Option<&str> {
        self.broker_id.as_deref()
    }
}
impl std::fmt::Debug for CreateBrokerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBrokerOutput");
        formatter.field("broker_arn", &self.broker_arn);
        formatter.field("broker_id", &self.broker_id);
        formatter.finish()
    }
}
/// See [`CreateBrokerOutput`](crate::output::CreateBrokerOutput)
pub mod create_broker_output {
    /// A builder for [`CreateBrokerOutput`](crate::output::CreateBrokerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) broker_arn: std::option::Option<std::string::String>,
        pub(crate) broker_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The broker's Amazon Resource Name (ARN).</p>
        pub fn broker_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_arn = Some(input.into());
            self
        }
        /// <p>The broker's Amazon Resource Name (ARN).</p>
        pub fn set_broker_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_arn = input;
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_id = Some(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBrokerOutput`](crate::output::CreateBrokerOutput)
        pub fn build(self) -> crate::output::CreateBrokerOutput {
            crate::output::CreateBrokerOutput {
                broker_arn: self.broker_arn,
                broker_id: self.broker_id,
            }
        }
    }
}
impl CreateBrokerOutput {
    /// Creates a new builder-style object to manufacture [`CreateBrokerOutput`](crate::output::CreateBrokerOutput)
    pub fn builder() -> crate::output::create_broker_output::Builder {
        crate::output::create_broker_output::Builder::default()
    }
}
